
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  138 ( 1087),  selected  138 , name 2hq9_B
# Molecule2: number of CA atoms  143 ( 1091),  selected  143 , name T0506_25_173.pdb
# PARAMETERS: 2hq9_B.T0506_25_173.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_B      -       -           -
LGA    L     2_B      -       -           -
LGA    V     3_B      -       -           -
LGA    R     4_B      -       -           -
LGA    T     5_B      -       -           -
LGA    L     6_B      E      25           #
LGA    S     7_B      A      26          1.119
LGA    A     8_B      V      27          2.307
LGA    L     9_B      R      28          2.565
LGA    E    10_B      V      29          1.473
LGA    C    11_B      A      30          0.967
LGA    T    12_B      R      31          1.498
LGA    K    13_B      D      32          0.593
LGA    V    14_B      V      33          0.676
LGA    L    15_B      L      34          1.755
LGA    T    16_B      H      35          0.735
LGA    A    17_B      T      36          0.685
LGA    N    18_B      S      37          1.109
LGA    R    19_B      R      38          0.394
LGA    V    20_B      T      39          0.261
LGA    G    21_B      A      40          0.760
LGA    R    22_B      A      41          0.775
LGA    L    23_B      L      42          0.291
LGA    A    24_B      A      43          0.343
LGA    C    25_B      T      44          0.279
LGA    A    26_B      L      45          0.203
LGA    K    27_B      D      46          2.271
LGA    D    28_B      P      47          3.940
LGA    -       -      V      48           -
LGA    -       -      S      49           -
LGA    G    29_B      G      50          1.519
LGA    Q    30_B      Y      51          1.371
LGA    P    31_B      P      52          0.855
LGA    Y    32_B      Y      53          0.575
LGA    V    33_B      T      54          0.166
LGA    V    34_B      T      55          0.468
LGA    P    35_B      A      56          0.473
LGA    L    36_B      T      57          0.275
LGA    Y    37_B      N      58          0.731
LGA    Y    38_B      I      59          1.003
LGA    A    39_B      G      60          1.371
LGA    Y    40_B      I      61          2.055
LGA    S    41_B      E      62          2.453
LGA    -       -      P      63           -
LGA    D    42_B      D      64          2.302
LGA    A    43_B      G      65          3.571
LGA    H    44_B      T      66          2.041
LGA    L    45_B      P      67          1.533
LGA    Y    46_B      F      68          1.605
LGA    A    47_B      F      69          1.598
LGA    F    48_B      F      70          1.813
LGA    S    49_B      A      71          1.994
LGA    X    50_B      A      72          1.421
LGA    P    51_B      G      73          1.192
LGA    G    52_B      L      74          2.291
LGA    K    53_B      T      75          3.187
LGA    -       -      L      76           -
LGA    K    54_B      H      77          0.912
LGA    I    55_B      A      78          0.875
LGA    E    56_B      R      79          1.214
LGA    W    57_B      N      80          0.761
LGA    X    58_B      M      81          0.526
LGA    R    59_B      E      82          1.485
LGA    A    60_B      T      83          1.453
LGA    N    61_B      D      84          0.649
LGA    P    62_B      A      85          0.580
LGA    R    63_B      R      86          0.539
LGA    V    64_B      I      87          0.385
LGA    S    65_B      S      88          0.497
LGA    V    66_B      V      89          0.518
LGA    Q    67_B      T      90          1.023
LGA    V    68_B      L      91          1.739
LGA    D    69_B      A      92          1.739
LGA    E    70_B      P      93          2.437
LGA    -       -      F      94           -
LGA    H    71_B      G      95           #
LGA    G    72_B      K      96          6.104
LGA    Q    73_B      -       -           -
LGA    G    74_B      -       -           -
LGA    R    75_B      -       -           -
LGA    G    76_B      G      97           #
LGA    -       -      D      98           -
LGA    -       -      A      99           -
LGA    -       -      L     100           -
LGA    W    77_B      T     101          2.608
LGA    K    78_B      L     102          2.725
LGA    -       -      P     103           -
LGA    S    79_B      R     104          0.932
LGA    V    80_B      L     105          1.001
LGA    V    81_B      T     106          0.760
LGA    V    82_B      L     107          0.864
LGA    D    83_B      V     108          0.436
LGA    G    84_B      G     109          2.037
LGA    R    85_B      R     110          1.061
LGA    Y    86_B      A     111          0.348
LGA    E    87_B      D     112          1.101
LGA    E    88_B      R     113          1.202
LGA    L    89_B      I     114          1.603
LGA    P    90_B      G     115          3.547
LGA    D    91_B      P     116          2.797
LGA    L    92_B      D     117          2.918
LGA    I    93_B      -       -           -
LGA    G    94_B      E     118          4.280
LGA    H    95_B      V     119          4.160
LGA    K    96_B      P     120          2.959
LGA    L    97_B      L     121          2.253
LGA    Q    98_B      A     122          2.992
LGA    R    99_B      -       -           -
LGA    D   100_B      I     123          3.473
LGA    H   101_B      A     124          2.956
LGA    A   102_B      R     125          2.466
LGA    W   103_B      Y     126          3.376
LGA    S   104_B      I     127          2.430
LGA    V   105_B      A     128          2.031
LGA    L   106_B      R     129          4.280
LGA    S   107_B      Y     130          4.184
LGA    K   108_B      P     131          1.579
LGA    H   109_B      K     132          4.220
LGA    T   110_B      A     133          2.782
LGA    -       -      K     134           -
LGA    D   111_B      L     135          5.314
LGA    W   112_B      -       -           -
LGA    W   113_B      -       -           -
LGA    E   114_B      Y     136          3.943
LGA    P   115_B      -       -           -
LGA    G   116_B      -       -           -
LGA    A   117_B      -       -           -
LGA    L   118_B      -       -           -
LGA    S   128_B      L     137          3.598
LGA    A   129_B      S     138          5.093
LGA    -       -      L     139           -
LGA    P   130_B      P     140          3.015
LGA    H   131_B      D     141          4.532
LGA    V   132_B      T     142          2.815
LGA    -       -      R     143           -
LGA    F   133_B      L     144          1.622
LGA    F   134_B      Y     145          1.614
LGA    R   135_B      R     146          1.472
LGA    I   136_B      L     147          1.575
LGA    L   137_B      R     148          2.141
LGA    I   138_B      T     149          2.226
LGA    E   139_B      E     150          2.200
LGA    Q   140_B      G     151          1.516
LGA    V   141_B      V     152          1.495
LGA    S   142_B      Q     153          1.185
LGA    G   143_B      I     154          0.963
LGA    R   144_B      N     155          1.056
LGA    E   145_B      G     156          1.449
LGA    A   146_B      S     163           -
LGA    S   147_B      N     164           -
LGA    -       -      I     165           -
LGA    -       -      T     166           -
LGA    -       -      P     167           -
LGA    -       -      A     168           -
LGA    -       -      D     169           -
LGA    -       -      L     170           -
LGA    -       -      R     171           -
LGA    -       -      T     172           -
LGA    -       -      D     173           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  138  143    5.0    117    2.20    17.09     62.319     5.093

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.709466 * X  +  -0.312419 * Y  +  -0.631706 * Z  +  24.632280
  Y_new =   0.662920 * X  +  -0.008333 * Y  +   0.748644 * Z  +   8.406451
  Z_new =  -0.239154 * X  +  -0.949908 * Y  +   0.201197 * Z  +  63.075905 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.362074    1.779519  [ DEG:   -78.0411    101.9589 ]
  Theta =   0.241495    2.900098  [ DEG:    13.8366    166.1634 ]
  Phi   =   0.751495   -2.390098  [ DEG:    43.0575   -136.9425 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hq9_B                                        
REMARK     2: T0506_25_173.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hq9_B.T0506_25_173.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  138  143   5.0  117   2.20   17.09  62.319
REMARK  ---------------------------------------------------------- 
MOLECULE 2hq9_B
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   18-JUL-06   2HQ9              
TITLE     CRYSTAL STRUCTURE OF A FAD-BINDING PROTEIN (NP_107146.1)              
TITLE    2 FROM MESORHIZOBIUM LOTI AT 1.95 A RESOLUTION                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MLL6688 PROTEIN;                                           
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RHIZOBIUM LOTI;                                 
SOURCE   3 ORGANISM_COMMON: MESORHIZOBIUM LOTI;                                 
SOURCE   4 GENE: NP_107146.1;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    NP_107146.1, HYPOTHETICAL PROTEIN, STRUCTURAL GENOMICS,               
KEYWDS   2 JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG, PROTEIN                  
KEYWDS   3 STRUCTURE INITIATIVE, PSI                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   29-AUG-06 2HQ9    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF HYPOTHETICAL PROTEIN                    
JRNL        TITL 2 (NP_107146.1) FROM MESORHIZOBIUM LOTI AT 1.95 A              
JRNL        TITL 3 RESOLUTION                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.95 ANGSTROMS.                                          
DBREF  2HQ9 A    1   148  UNP    Q988L5   Q988L5_RHILO     1    148             
DBREF  2HQ9 B    1   148  UNP    Q988L5   Q988L5_RHILO     1    148             
SEQRES   1 A  149  GLY MSE LEU VAL ARG THR LEU SER ALA LEU GLU CYS THR          
SEQRES   2 A  149  LYS VAL LEU THR ALA ASN ARG VAL GLY ARG LEU ALA CYS          
SEQRES   3 A  149  ALA LYS ASP GLY GLN PRO TYR VAL VAL PRO LEU TYR TYR          
SEQRES   4 A  149  ALA TYR SER ASP ALA HIS LEU TYR ALA PHE SER MSE PRO          
SEQRES   5 A  149  GLY LYS LYS ILE GLU TRP MSE ARG ALA ASN PRO ARG VAL          
SEQRES   6 A  149  SER VAL GLN VAL ASP GLU HIS GLY GLN GLY ARG GLY TRP          
SEQRES   7 A  149  LYS SER VAL VAL VAL ASP GLY ARG TYR GLU GLU LEU PRO          
SEQRES   8 A  149  ASP LEU ILE GLY HIS LYS LEU GLN ARG ASP HIS ALA TRP          
SEQRES   9 A  149  SER VAL LEU SER LYS HIS THR ASP TRP TRP GLU PRO GLY          
SEQRES  10 A  149  ALA LEU LYS PRO VAL THR PRO PRO THR ALA ASP SER ALA          
SEQRES  11 A  149  PRO HIS VAL PHE PHE ARG ILE LEU ILE GLU GLN VAL SER          
SEQRES  12 A  149  GLY ARG GLU ALA SER GLU                                      
SEQRES   1 B  149  GLY MSE LEU VAL ARG THR LEU SER ALA LEU GLU CYS THR          
SEQRES   2 B  149  LYS VAL LEU THR ALA ASN ARG VAL GLY ARG LEU ALA CYS          
SEQRES   3 B  149  ALA LYS ASP GLY GLN PRO TYR VAL VAL PRO LEU TYR TYR          
SEQRES   4 B  149  ALA TYR SER ASP ALA HIS LEU TYR ALA PHE SER MSE PRO          
SEQRES   5 B  149  GLY LYS LYS ILE GLU TRP MSE ARG ALA ASN PRO ARG VAL          
SEQRES   6 B  149  SER VAL GLN VAL ASP GLU HIS GLY GLN GLY ARG GLY TRP          
SEQRES   7 B  149  LYS SER VAL VAL VAL ASP GLY ARG TYR GLU GLU LEU PRO          
SEQRES   8 B  149  ASP LEU ILE GLY HIS LYS LEU GLN ARG ASP HIS ALA TRP          
SEQRES   9 B  149  SER VAL LEU SER LYS HIS THR ASP TRP TRP GLU PRO GLY          
SEQRES  10 B  149  ALA LEU LYS PRO VAL THR PRO PRO THR ALA ASP SER ALA          
SEQRES  11 B  149  PRO HIS VAL PHE PHE ARG ILE LEU ILE GLU GLN VAL SER          
SEQRES  12 B  149  GLY ARG GLU ALA SER GLU                                      
HET    MSE  A   1       8                                                       
HET    MSE  A  50       8                                                       
HET    MSE  A  58       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  50       8                                                       
HET    MSE  B  58       8                                                       
HET     CL      1       1                                                       
HET    FAD  A 200      53                                                       
HET    FAD  B 200      53                                                       
HET    EDO      2       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
HETNAM     FAD FLAVIN-ADENINE DINUCLEOTIDE                                      
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   3   CL    CL 1-                                                        
FORMUL   4  FAD    2(C27 H33 N9 O15 P2)                                         
FORMUL   6  EDO    C2 H6 O2                                                     
FORMUL   7  HOH   *178(H2 O)                                                    
CRYST1   47.852   74.895   84.626  90.00  90.00  90.00 P 21 21 21    8          
HETATM 1091  N   MSE B   1      38.069  41.710   1.171  1.00 46.39           N  
HETATM 1092  CA  MSE B   1      36.650  41.962   0.769  1.00 46.28           C  
HETATM 1093  C   MSE B   1      36.504  43.250  -0.037  1.00 44.25           C  
HETATM 1094  O   MSE B   1      36.775  44.352   0.487  1.00 44.80           O  
HETATM 1095  CB  MSE B   1      35.740  42.052   2.011  1.00 47.65           C  
HETATM 1096  CG  MSE B   1      35.744  40.787   2.875  1.00 50.54           C  
HETATM 1097 SE   MSE B   1      34.734  39.314   2.116  0.75 56.80          SE  
HETATM 1098  CE  MSE B   1      35.656  37.737   2.994  1.00 54.20           C  
ATOM   1099  N   LEU B   2      36.070  43.119  -1.291  1.00 41.23           N  
ATOM   1100  CA  LEU B   2      35.487  44.254  -1.994  1.00 39.08           C  
ATOM   1101  C   LEU B   2      34.335  44.705  -1.105  1.00 37.07           C  
ATOM   1102  O   LEU B   2      33.424  43.935  -0.892  1.00 36.38           O  
ATOM   1103  CB  LEU B   2      34.948  43.864  -3.373  1.00 38.77           C  
ATOM   1104  N   VAL B   3      34.418  45.911  -0.552  1.00 34.89           N  
ATOM   1105  CA  VAL B   3      33.262  46.565   0.069  1.00 33.94           C  
ATOM   1106  C   VAL B   3      32.833  47.770  -0.770  1.00 32.88           C  
ATOM   1107  O   VAL B   3      33.651  48.586  -1.188  1.00 32.69           O  
ATOM   1108  CB  VAL B   3      33.570  47.009   1.519  1.00 34.20           C  
ATOM   1109  CG1 VAL B   3      32.381  47.697   2.157  1.00 32.37           C  
ATOM   1110  CG2 VAL B   3      34.028  45.799   2.366  1.00 34.67           C  
ATOM   1111  N   ARG B   4      31.540  47.886  -1.015  1.00 31.81           N  
ATOM   1112  CA  ARG B   4      31.014  48.963  -1.844  1.00 31.24           C  
ATOM   1113  C   ARG B   4      29.663  49.391  -1.306  1.00 29.75           C  
ATOM   1114  O   ARG B   4      29.004  48.622  -0.611  1.00 26.62           O  
ATOM   1115  CB  ARG B   4      30.848  48.479  -3.272  1.00 32.33           C  
ATOM   1116  CG  ARG B   4      30.503  47.006  -3.353  1.00 36.25           C  
ATOM   1117  CD  ARG B   4      30.274  46.556  -4.791  1.00 40.75           C  
ATOM   1118  NE  ARG B   4      28.958  46.960  -5.301  1.00 42.12           N  
ATOM   1119  CZ  ARG B   4      27.795  46.437  -4.904  1.00 43.89           C  
ATOM   1120  NH1 ARG B   4      27.763  45.490  -3.963  1.00 44.50           N  
ATOM   1121  NH2 ARG B   4      26.650  46.869  -5.440  1.00 41.40           N  
ATOM   1122  N   THR B   5      29.259  50.601  -1.667  1.00 28.02           N  
ATOM   1123  CA  THR B   5      27.984  51.103  -1.257  1.00 28.34           C  
ATOM   1124  C   THR B   5      26.911  50.624  -2.225  1.00 27.71           C  
ATOM   1125  O   THR B   5      27.185  50.402  -3.383  1.00 26.56           O  
ATOM   1126  CB  THR B   5      27.943  52.636  -1.202  1.00 28.16           C  
ATOM   1127  OG1 THR B   5      27.939  53.149  -2.530  1.00 30.93           O  
ATOM   1128  CG2 THR B   5      29.124  53.194  -0.425  1.00 28.73           C  
ATOM   1129  N   LEU B   6      25.672  50.533  -1.744  1.00 26.54           N  
ATOM   1130  CA  LEU B   6      24.612  49.956  -2.515  1.00 26.65           C  
ATOM   1131  C   LEU B   6      23.814  51.099  -3.104  1.00 27.22           C  
ATOM   1132  O   LEU B   6      23.739  52.170  -2.535  1.00 28.41           O  
ATOM   1133  CB  LEU B   6      23.678  49.098  -1.640  1.00 26.12           C  
ATOM   1134  CG  LEU B   6      24.182  47.782  -1.061  1.00 25.83           C  
ATOM   1135  CD1 LEU B   6      23.116  47.114  -0.191  1.00 25.14           C  
ATOM   1136  CD2 LEU B   6      24.630  46.835  -2.135  1.00 25.72           C  
ATOM   1137  N   SER B   7      23.175  50.849  -4.218  1.00 27.89           N  
ATOM   1138  CA  SER B   7      22.332  51.867  -4.854  1.00 28.49           C  
ATOM   1139  C   SER B   7      21.072  51.986  -4.028  1.00 28.98           C  
ATOM   1140  O   SER B   7      20.767  51.097  -3.219  1.00 29.04           O  
ATOM   1141  CB  SER B   7      21.980  51.408  -6.255  1.00 28.35           C  
ATOM   1142  OG  SER B   7      21.243  50.209  -6.172  1.00 28.20           O  
ATOM   1143  N   ALA B   8      20.303  53.050  -4.233  1.00 29.28           N  
ATOM   1144  CA  ALA B   8      19.019  53.158  -3.560  1.00 29.28           C  
ATOM   1145  C   ALA B   8      18.122  51.932  -3.822  1.00 29.42           C  
ATOM   1146  O   ALA B   8      17.482  51.414  -2.920  1.00 29.91           O  
ATOM   1147  CB  ALA B   8      18.308  54.434  -3.980  1.00 30.11           C  
ATOM   1148  N   LEU B   9      18.098  51.445  -5.050  1.00 29.51           N  
ATOM   1149  CA  LEU B   9      17.246  50.303  -5.396  1.00 29.19           C  
ATOM   1150  C   LEU B   9      17.753  48.984  -4.742  1.00 29.36           C  
ATOM   1151  O   LEU B   9      16.966  48.124  -4.325  1.00 28.40           O  
ATOM   1152  CB  LEU B   9      17.153  50.213  -6.924  1.00 30.49           C  
ATOM   1153  CG  LEU B   9      16.643  51.503  -7.647  1.00 32.24           C  
ATOM   1154  CD1 LEU B   9      16.716  51.371  -9.141  1.00 33.09           C  
ATOM   1155  CD2 LEU B   9      15.223  51.895  -7.236  1.00 33.74           C  
ATOM   1156  N   GLU B  10      19.075  48.844  -4.600  1.00 28.95           N  
ATOM   1157  CA  GLU B  10      19.636  47.668  -3.915  1.00 29.37           C  
ATOM   1158  C   GLU B  10      19.229  47.673  -2.426  1.00 27.75           C  
ATOM   1159  O   GLU B  10      18.972  46.631  -1.841  1.00 27.20           O  
ATOM   1160  CB  GLU B  10      21.161  47.624  -4.054  1.00 29.03           C  
ATOM   1161  CG  GLU B  10      21.651  47.321  -5.484  1.00 31.79           C  
ATOM   1162  CD  GLU B  10      23.174  47.251  -5.599  1.00 32.67           C  
ATOM   1163  OE1 GLU B  10      23.843  48.295  -5.384  1.00 36.93           O  
ATOM   1164  OE2 GLU B  10      23.695  46.157  -5.930  1.00 38.87           O  
ATOM   1165  N   CYS B  11      19.174  48.854  -1.827  1.00 27.75           N  
ATOM   1166  CA  CYS B  11      18.801  48.983  -0.424  1.00 27.32           C  
ATOM   1167  C   CYS B  11      17.369  48.514  -0.202  1.00 27.17           C  
ATOM   1168  O   CYS B  11      17.092  47.674   0.654  1.00 26.87           O  
ATOM   1169  CB  CYS B  11      18.993  50.412   0.076  1.00 27.52           C  
ATOM   1170  SG  CYS B  11      20.665  50.983   0.156  1.00 27.17           S  
ATOM   1171  N   THR B  12      16.470  49.006  -1.032  1.00 26.62           N  
ATOM   1172  CA  THR B  12      15.098  48.523  -1.047  1.00 27.12           C  
ATOM   1173  C   THR B  12      14.966  47.003  -1.140  1.00 25.75           C  
ATOM   1174  O   THR B  12      14.166  46.427  -0.409  1.00 24.52           O  
ATOM   1175  CB  THR B  12      14.274  49.233  -2.135  1.00 27.68           C  
ATOM   1176  OG1 THR B  12      14.379  50.649  -1.909  1.00 30.86           O  
ATOM   1177  CG2 THR B  12      12.807  48.826  -2.060  1.00 29.66           C  
ATOM   1178  N   LYS B  13      15.769  46.350  -1.970  1.00 24.87           N  
ATOM   1179  CA  LYS B  13      15.712  44.877  -2.119  1.00 24.99           C  
ATOM   1180  C   LYS B  13      16.087  44.133  -0.859  1.00 24.66           C  
ATOM   1181  O   LYS B  13      15.530  43.091  -0.554  1.00 24.48           O  
ATOM   1182  CB  LYS B  13      16.665  44.368  -3.227  1.00 24.41           C  
ATOM   1183  CG  LYS B  13      16.092  44.392  -4.611  1.00 25.95           C  
ATOM   1184  N   VAL B  14      17.080  44.648  -0.146  1.00 25.13           N  
ATOM   1185  CA  VAL B  14      17.483  44.061   1.116  1.00 25.06           C  
ATOM   1186  C   VAL B  14      16.334  44.234   2.125  1.00 24.49           C  
ATOM   1187  O   VAL B  14      15.948  43.286   2.744  1.00 25.12           O  
ATOM   1188  CB  VAL B  14      18.830  44.687   1.628  1.00 24.88           C  
ATOM   1189  CG1 VAL B  14      19.116  44.280   3.040  1.00 26.19           C  
ATOM   1190  CG2 VAL B  14      19.984  44.301   0.727  1.00 23.62           C  
ATOM   1191  N   LEU B  15      15.781  45.430   2.258  1.00 26.01           N  
ATOM   1192  CA  LEU B  15      14.692  45.670   3.216  1.00 26.97           C  
ATOM   1193  C   LEU B  15      13.460  44.823   2.926  1.00 28.75           C  
ATOM   1194  O   LEU B  15      12.837  44.269   3.823  1.00 29.26           O  
ATOM   1195  CB  LEU B  15      14.272  47.128   3.213  1.00 25.97           C  
ATOM   1196  CG  LEU B  15      15.279  48.119   3.722  1.00 25.29           C  
ATOM   1197  CD1 LEU B  15      14.730  49.482   3.486  1.00 28.02           C  
ATOM   1198  CD2 LEU B  15      15.531  47.920   5.198  1.00 24.05           C  
ATOM   1199  N   THR B  16      13.138  44.714   1.646  1.00 30.46           N  
ATOM   1200  CA  THR B  16      11.962  44.001   1.203  1.00 32.35           C  
ATOM   1201  C   THR B  16      12.090  42.526   1.542  1.00 33.21           C  
ATOM   1202  O   THR B  16      11.139  41.905   2.028  1.00 34.22           O  
ATOM   1203  CB  THR B  16      11.794  44.196  -0.318  1.00 32.75           C  
ATOM   1204  OG1 THR B  16      11.483  45.580  -0.604  1.00 33.36           O  
ATOM   1205  CG2 THR B  16      10.721  43.303  -0.865  1.00 34.11           C  
ATOM   1206  N   ALA B  17      13.284  41.984   1.313  1.00 32.90           N  
ATOM   1207  CA  ALA B  17      13.560  40.564   1.448  1.00 32.15           C  
ATOM   1208  C   ALA B  17      13.688  40.064   2.872  1.00 31.49           C  
ATOM   1209  O   ALA B  17      13.559  38.869   3.111  1.00 31.46           O  
ATOM   1210  CB  ALA B  17      14.854  40.195   0.676  1.00 32.69           C  
ATOM   1211  N   ASN B  18      13.970  40.950   3.821  1.00 30.36           N  
ATOM   1212  CA  ASN B  18      14.212  40.518   5.171  1.00 29.25           C  
ATOM   1213  C   ASN B  18      13.063  40.892   6.104  1.00 28.07           C  
ATOM   1214  O   ASN B  18      12.167  41.656   5.745  1.00 27.52           O  
ATOM   1215  CB  ASN B  18      15.564  41.073   5.627  1.00 29.49           C  
ATOM   1216  CG  ASN B  18      16.709  40.391   4.945  1.00 30.04           C  
ATOM   1217  OD1 ASN B  18      17.044  39.258   5.282  1.00 30.15           O  
ATOM   1218  ND2 ASN B  18      17.271  41.032   3.921  1.00 28.20           N  
ATOM   1219  N   ARG B  19      13.090  40.298   7.278  1.00 28.41           N  
ATOM   1220  CA  ARG B  19      12.004  40.392   8.286  1.00 28.87           C  
ATOM   1221  C   ARG B  19      12.450  40.799   9.682  1.00 27.98           C  
ATOM   1222  O   ARG B  19      11.648  40.969  10.538  1.00 26.27           O  
ATOM   1223  CB  ARG B  19      11.300  39.038   8.427  1.00 30.01           C  
ATOM   1224  CG  ARG B  19      12.174  37.884   8.934  1.00 31.49           C  
ATOM   1225  N   VAL B  20      13.742  40.857   9.916  1.00 27.14           N  
ATOM   1226  CA  VAL B  20      14.250  41.208  11.207  1.00 28.37           C  
ATOM   1227  C   VAL B  20      15.279  42.309  11.045  1.00 27.21           C  
ATOM   1228  O   VAL B  20      16.064  42.338  10.094  1.00 27.47           O  
ATOM   1229  CB  VAL B  20      14.813  39.983  11.981  1.00 29.41           C  
ATOM   1230  CG1 VAL B  20      16.052  39.462  11.355  1.00 31.08           C  
ATOM   1231  CG2 VAL B  20      15.100  40.362  13.458  1.00 33.49           C  
ATOM   1232  N   GLY B  21      15.211  43.255  11.958  1.00 25.37           N  
ATOM   1233  CA  GLY B  21      16.165  44.311  12.003  1.00 25.95           C  
ATOM   1234  C   GLY B  21      16.494  44.602  13.459  1.00 24.94           C  
ATOM   1235  O   GLY B  21      15.915  43.977  14.354  1.00 25.82           O  
ATOM   1236  N   ARG B  22      17.426  45.528  13.668  1.00 23.41           N  
ATOM   1237  CA  ARG B  22      17.685  46.103  14.968  1.00 23.42           C  
ATOM   1238  C   ARG B  22      17.232  47.550  14.937  1.00 23.27           C  
ATOM   1239  O   ARG B  22      17.594  48.325  14.051  1.00 25.73           O  
ATOM   1240  CB  ARG B  22      19.152  45.975  15.385  1.00 22.99           C  
ATOM   1241  CG  ARG B  22      19.456  44.684  16.105  1.00 25.30           C  
ATOM   1242  CD  ARG B  22      19.433  43.568  15.151  1.00 27.71           C  
ATOM   1243  NE  ARG B  22      19.791  42.283  15.757  1.00 28.39           N  
ATOM   1244  CZ  ARG B  22      19.890  41.155  15.059  1.00 31.60           C  
ATOM   1245  NH1 ARG B  22      19.647  41.147  13.755  1.00 30.08           N  
ATOM   1246  NH2 ARG B  22      20.235  40.026  15.668  1.00 34.30           N  
ATOM   1247  N   LEU B  23      16.418  47.912  15.898  1.00 23.05           N  
ATOM   1248  CA  LEU B  23      15.853  49.236  16.000  1.00 23.63           C  
ATOM   1249  C   LEU B  23      16.503  49.981  17.147  1.00 23.87           C  
ATOM   1250  O   LEU B  23      16.503  49.493  18.276  1.00 24.54           O  
ATOM   1251  CB  LEU B  23      14.374  49.094  16.309  1.00 24.81           C  
ATOM   1252  CG  LEU B  23      13.634  50.387  16.691  1.00 27.36           C  
ATOM   1253  CD1 LEU B  23      13.472  51.253  15.518  1.00 26.05           C  
ATOM   1254  CD2 LEU B  23      12.289  49.932  17.232  1.00 32.63           C  
ATOM   1255  N   ALA B  24      17.004  51.174  16.857  1.00 22.96           N  
ATOM   1256  CA  ALA B  24      17.581  52.018  17.852  1.00 23.23           C  
ATOM   1257  C   ALA B  24      16.785  53.293  18.045  1.00 23.75           C  
ATOM   1258  O   ALA B  24      16.404  53.938  17.080  1.00 23.89           O  
ATOM   1259  CB  ALA B  24      18.977  52.373  17.451  1.00 23.07           C  
ATOM   1260  N   CYS B  25      16.599  53.663  19.309  1.00 24.60           N  
ATOM   1261  CA  CYS B  25      15.977  54.897  19.710  1.00 23.41           C  
ATOM   1262  C   CYS B  25      16.910  55.542  20.741  1.00 23.30           C  
ATOM   1263  O   CYS B  25      17.974  54.975  21.089  1.00 22.67           O  
ATOM   1264  CB  CYS B  25      14.602  54.656  20.287  1.00 23.94           C  
ATOM   1265  SG  CYS B  25      14.477  53.527  21.713  1.00 27.21           S  
ATOM   1266  N   ALA B  26      16.545  56.728  21.200  1.00 21.97           N  
ATOM   1267  CA  ALA B  26      17.392  57.433  22.173  1.00 22.60           C  
ATOM   1268  C   ALA B  26      16.603  58.331  23.100  1.00 22.65           C  
ATOM   1269  O   ALA B  26      15.514  58.815  22.748  1.00 23.80           O  
ATOM   1270  CB  ALA B  26      18.460  58.271  21.427  1.00 22.42           C  
ATOM   1271  N   LYS B  27      17.174  58.563  24.278  1.00 23.45           N  
ATOM   1272  CA  LYS B  27      16.655  59.527  25.242  1.00 22.99           C  
ATOM   1273  C   LYS B  27      17.815  60.162  25.962  1.00 23.66           C  
ATOM   1274  O   LYS B  27      18.650  59.458  26.556  1.00 22.40           O  
ATOM   1275  CB  LYS B  27      15.792  58.852  26.286  1.00 23.32           C  
ATOM   1276  CG  LYS B  27      15.158  59.808  27.289  1.00 26.59           C  
ATOM   1277  CD  LYS B  27      14.559  59.016  28.443  1.00 33.83           C  
ATOM   1278  CE  LYS B  27      13.167  59.446  28.760  1.00 39.78           C  
ATOM   1279  NZ  LYS B  27      12.279  59.108  27.603  1.00 41.00           N  
ATOM   1280  N   ASP B  28      17.821  61.491  25.951  1.00 24.65           N  
ATOM   1281  CA  ASP B  28      18.865  62.306  26.595  1.00 26.63           C  
ATOM   1282  C   ASP B  28      20.275  61.818  26.208  1.00 26.68           C  
ATOM   1283  O   ASP B  28      21.155  61.690  27.057  1.00 28.90           O  
ATOM   1284  CB  ASP B  28      18.663  62.338  28.115  1.00 27.98           C  
ATOM   1285  CG  ASP B  28      17.291  62.925  28.499  1.00 31.49           C  
ATOM   1286  OD1 ASP B  28      16.787  63.769  27.722  1.00 36.26           O  
ATOM   1287  OD2 ASP B  28      16.702  62.529  29.536  1.00 35.87           O  
ATOM   1288  N   GLY B  29      20.474  61.517  24.928  1.00 25.71           N  
ATOM   1289  CA  GLY B  29      21.809  61.137  24.442  1.00 25.14           C  
ATOM   1290  C   GLY B  29      22.142  59.665  24.603  1.00 24.38           C  
ATOM   1291  O   GLY B  29      23.179  59.217  24.104  1.00 24.21           O  
ATOM   1292  N   GLN B  30      21.275  58.908  25.294  1.00 23.01           N  
ATOM   1293  CA  GLN B  30      21.502  57.485  25.536  1.00 22.43           C  
ATOM   1294  C   GLN B  30      20.746  56.716  24.492  1.00 22.50           C  
ATOM   1295  O   GLN B  30      19.514  56.848  24.422  1.00 21.99           O  
ATOM   1296  CB  GLN B  30      20.979  57.057  26.898  1.00 22.67           C  
ATOM   1297  CG  GLN B  30      21.088  55.584  27.192  1.00 21.13           C  
ATOM   1298  CD  GLN B  30      22.507  55.099  27.156  1.00 22.57           C  
ATOM   1299  OE1 GLN B  30      23.381  55.658  27.820  1.00 23.79           O  
ATOM   1300  NE2 GLN B  30      22.762  54.104  26.351  1.00 19.52           N  
ATOM   1301  N   PRO B  31      21.458  55.930  23.666  1.00 21.78           N  
ATOM   1302  CA  PRO B  31      20.765  55.000  22.781  1.00 20.94           C  
ATOM   1303  C   PRO B  31      20.241  53.727  23.449  1.00 21.60           C  
ATOM   1304  O   PRO B  31      20.689  53.317  24.546  1.00 20.20           O  
ATOM   1305  CB  PRO B  31      21.846  54.662  21.726  1.00 21.39           C  
ATOM   1306  CG  PRO B  31      22.976  55.659  21.971  1.00 22.02           C  
ATOM   1307  CD  PRO B  31      22.906  55.880  23.435  1.00 21.94           C  
ATOM   1308  N   TYR B  32      19.306  53.095  22.745  1.00 22.08           N  
ATOM   1309  CA  TYR B  32      18.747  51.838  23.145  1.00 23.10           C  
ATOM   1310  C   TYR B  32      18.400  51.054  21.898  1.00 22.42           C  
ATOM   1311  O   TYR B  32      17.773  51.587  21.012  1.00 23.31           O  
ATOM   1312  CB  TYR B  32      17.540  52.125  24.021  1.00 22.59           C  
ATOM   1313  CG  TYR B  32      16.751  50.943  24.440  1.00 22.96           C  
ATOM   1314  CD1 TYR B  32      17.352  49.854  25.060  1.00 23.68           C  
ATOM   1315  CD2 TYR B  32      15.405  50.883  24.213  1.00 22.31           C  
ATOM   1316  CE1 TYR B  32      16.578  48.748  25.444  1.00 24.18           C  
ATOM   1317  CE2 TYR B  32      14.627  49.770  24.608  1.00 22.64           C  
ATOM   1318  CZ  TYR B  32      15.201  48.739  25.216  1.00 24.27           C  
ATOM   1319  OH  TYR B  32      14.404  47.700  25.647  1.00 24.77           O  
ATOM   1320  N   VAL B  33      18.949  49.847  21.768  1.00 23.11           N  
ATOM   1321  CA  VAL B  33      18.766  49.062  20.563  1.00 23.23           C  
ATOM   1322  C   VAL B  33      18.261  47.662  20.872  1.00 22.86           C  
ATOM   1323  O   VAL B  33      18.783  47.006  21.741  1.00 22.66           O  
ATOM   1324  CB  VAL B  33      20.053  49.064  19.687  1.00 24.20           C  
ATOM   1325  CG1 VAL B  33      21.251  48.586  20.426  1.00 24.19           C  
ATOM   1326  CG2 VAL B  33      19.836  48.282  18.406  1.00 24.50           C  
ATOM   1327  N   VAL B  34      17.211  47.228  20.163  1.00 22.23           N  
ATOM   1328  CA  VAL B  34      16.645  45.892  20.343  1.00 23.14           C  
ATOM   1329  C   VAL B  34      16.263  45.279  18.995  1.00 22.81           C  
ATOM   1330  O   VAL B  34      16.043  46.000  18.044  1.00 22.17           O  
ATOM   1331  CB  VAL B  34      15.376  45.918  21.235  1.00 24.24           C  
ATOM   1332  CG1 VAL B  34      15.737  46.337  22.635  1.00 25.68           C  
ATOM   1333  CG2 VAL B  34      14.321  46.855  20.636  1.00 26.23           C  
ATOM   1334  N   PRO B  35      16.180  43.952  18.930  1.00 23.35           N  
ATOM   1335  CA  PRO B  35      15.731  43.341  17.699  1.00 25.11           C  
ATOM   1336  C   PRO B  35      14.207  43.481  17.509  1.00 25.86           C  
ATOM   1337  O   PRO B  35      13.436  43.447  18.485  1.00 27.41           O  
ATOM   1338  CB  PRO B  35      16.148  41.889  17.855  1.00 25.28           C  
ATOM   1339  CG  PRO B  35      16.270  41.641  19.332  1.00 25.07           C  
ATOM   1340  CD  PRO B  35      16.527  42.958  19.977  1.00 24.72           C  
ATOM   1341  N   LEU B  36      13.788  43.525  16.254  1.00 26.13           N  
ATOM   1342  CA  LEU B  36      12.392  43.720  15.918  1.00 26.68           C  
ATOM   1343  C   LEU B  36      12.050  43.049  14.606  1.00 25.57           C  
ATOM   1344  O   LEU B  36      12.825  43.129  13.659  1.00 24.47           O  
ATOM   1345  CB  LEU B  36      12.133  45.199  15.791  1.00 27.35           C  
ATOM   1346  CG  LEU B  36      10.683  45.656  15.649  1.00 31.66           C  
ATOM   1347  CD1 LEU B  36      10.108  46.024  17.022  1.00 33.59           C  
ATOM   1348  CD2 LEU B  36      10.655  46.830  14.703  1.00 34.07           C  
ATOM   1349  N   TYR B  37      10.890  42.396  14.553  1.00 24.92           N  
ATOM   1350  CA  TYR B  37      10.388  41.859  13.297  1.00 24.34           C  
ATOM   1351  C   TYR B  37       9.641  42.967  12.599  1.00 24.32           C  
ATOM   1352  O   TYR B  37       8.871  43.706  13.252  1.00 24.01           O  
ATOM   1353  CB  TYR B  37       9.446  40.710  13.556  1.00 26.36           C  
ATOM   1354  CG  TYR B  37      10.095  39.435  13.939  1.00 27.45           C  
ATOM   1355  CD1 TYR B  37      11.101  38.884  13.158  1.00 30.76           C  
ATOM   1356  CD2 TYR B  37       9.651  38.723  15.038  1.00 31.27           C  
ATOM   1357  CE1 TYR B  37      11.704  37.677  13.503  1.00 33.05           C  
ATOM   1358  CE2 TYR B  37      10.220  37.506  15.384  1.00 30.79           C  
ATOM   1359  CZ  TYR B  37      11.238  36.988  14.611  1.00 31.10           C  
ATOM   1360  OH  TYR B  37      11.820  35.806  14.959  1.00 33.11           O  
ATOM   1361  N   TYR B  38       9.830  43.114  11.288  1.00 22.39           N  
ATOM   1362  CA  TYR B  38       9.100  44.156  10.554  1.00 22.49           C  
ATOM   1363  C   TYR B  38       8.562  43.611   9.241  1.00 23.10           C  
ATOM   1364  O   TYR B  38       8.998  42.543   8.760  1.00 23.46           O  
ATOM   1365  CB  TYR B  38      10.014  45.386  10.297  1.00 22.84           C  
ATOM   1366  CG  TYR B  38      11.053  45.069   9.267  1.00 20.71           C  
ATOM   1367  CD1 TYR B  38      12.277  44.496   9.626  1.00 23.53           C  
ATOM   1368  CD2 TYR B  38      10.801  45.273   7.918  1.00 25.09           C  
ATOM   1369  CE1 TYR B  38      13.214  44.156   8.668  1.00 22.80           C  
ATOM   1370  CE2 TYR B  38      11.756  44.895   6.932  1.00 22.22           C  
ATOM   1371  CZ  TYR B  38      12.930  44.352   7.321  1.00 23.35           C  
ATOM   1372  OH  TYR B  38      13.810  44.012   6.335  1.00 23.75           O  
ATOM   1373  N   ALA B  39       7.638  44.346   8.649  1.00 23.15           N  
ATOM   1374  CA  ALA B  39       7.181  44.048   7.274  1.00 24.46           C  
ATOM   1375  C   ALA B  39       7.340  45.333   6.465  1.00 24.59           C  
ATOM   1376  O   ALA B  39       6.878  46.356   6.895  1.00 24.59           O  
ATOM   1377  CB  ALA B  39       5.692  43.606   7.276  1.00 24.03           C  
ATOM   1378  N   TYR B  40       8.041  45.274   5.335  1.00 25.00           N  
ATOM   1379  CA  TYR B  40       8.227  46.433   4.468  1.00 25.65           C  
ATOM   1380  C   TYR B  40       7.001  46.700   3.563  1.00 26.10           C  
ATOM   1381  O   TYR B  40       6.487  45.787   2.906  1.00 24.55           O  
ATOM   1382  CB  TYR B  40       9.465  46.225   3.568  1.00 26.69           C  
ATOM   1383  CG  TYR B  40       9.619  47.321   2.568  1.00 27.10           C  
ATOM   1384  CD1 TYR B  40      10.293  48.490   2.905  1.00 31.74           C  
ATOM   1385  CD2 TYR B  40       9.047  47.228   1.318  1.00 28.64           C  
ATOM   1386  CE1 TYR B  40      10.371  49.536   2.019  1.00 31.25           C  
ATOM   1387  CE2 TYR B  40       9.116  48.268   0.412  1.00 28.69           C  
ATOM   1388  CZ  TYR B  40       9.778  49.414   0.770  1.00 30.32           C  
ATOM   1389  OH  TYR B  40       9.852  50.448  -0.118  1.00 31.27           O  
ATOM   1390  N   SER B  41       6.583  47.962   3.482  1.00 25.52           N  
ATOM   1391  CA  SER B  41       5.663  48.405   2.421  1.00 27.13           C  
ATOM   1392  C   SER B  41       5.709  49.910   2.282  1.00 27.03           C  
ATOM   1393  O   SER B  41       5.731  50.615   3.281  1.00 26.15           O  
ATOM   1394  CB  SER B  41       4.212  48.005   2.699  1.00 26.84           C  
ATOM   1395  OG  SER B  41       3.404  48.324   1.582  1.00 28.52           O  
ATOM   1396  N   ASP B  42       5.722  50.381   1.052  1.00 27.80           N  
ATOM   1397  CA  ASP B  42       5.467  51.795   0.747  1.00 30.11           C  
ATOM   1398  C   ASP B  42       6.459  52.721   1.505  1.00 30.16           C  
ATOM   1399  O   ASP B  42       6.042  53.722   2.042  1.00 31.29           O  
ATOM   1400  CB  ASP B  42       3.943  52.210   0.957  1.00 30.85           C  
ATOM   1401  CG  ASP B  42       3.328  51.903   2.431  1.00 36.94           C  
ATOM   1402  OD1 ASP B  42       3.569  52.663   3.419  1.00 43.15           O  
ATOM   1403  OD2 ASP B  42       2.511  50.934   2.589  1.00 41.40           O  
ATOM   1404  N   ALA B  43       7.744  52.345   1.556  1.00 29.51           N  
ATOM   1405  CA  ALA B  43       8.820  53.120   2.239  1.00 29.20           C  
ATOM   1406  C   ALA B  43       8.586  53.286   3.731  1.00 28.73           C  
ATOM   1407  O   ALA B  43       9.011  54.275   4.350  1.00 29.33           O  
ATOM   1408  CB  ALA B  43       9.020  54.464   1.593  1.00 30.46           C  
ATOM   1409  N   HIS B  44       7.920  52.286   4.295  1.00 26.16           N  
ATOM   1410  CA  HIS B  44       7.757  52.155   5.705  1.00 25.98           C  
ATOM   1411  C   HIS B  44       8.106  50.747   6.128  1.00 23.85           C  
ATOM   1412  O   HIS B  44       7.868  49.771   5.390  1.00 22.28           O  
ATOM   1413  CB  HIS B  44       6.321  52.407   6.099  1.00 26.69           C  
ATOM   1414  CG  HIS B  44       5.823  53.781   5.781  1.00 29.32           C  
ATOM   1415  ND1 HIS B  44       5.112  54.059   4.639  1.00 33.69           N  
ATOM   1416  CD2 HIS B  44       5.855  54.933   6.499  1.00 33.61           C  
ATOM   1417  CE1 HIS B  44       4.764  55.337   4.638  1.00 35.54           C  
ATOM   1418  NE2 HIS B  44       5.185  55.883   5.766  1.00 35.82           N  
ATOM   1419  N   LEU B  45       8.576  50.647   7.350  1.00 22.36           N  
ATOM   1420  CA  LEU B  45       8.695  49.380   8.054  1.00 22.99           C  
ATOM   1421  C   LEU B  45       7.626  49.259   9.133  1.00 23.69           C  
ATOM   1422  O   LEU B  45       7.612  50.035  10.074  1.00 24.47           O  
ATOM   1423  CB  LEU B  45      10.066  49.291   8.709  1.00 21.08           C  
ATOM   1424  CG  LEU B  45      11.235  49.657   7.827  1.00 24.26           C  
ATOM   1425  CD1 LEU B  45      12.541  49.538   8.574  1.00 24.82           C  
ATOM   1426  CD2 LEU B  45      11.317  48.810   6.583  1.00 21.67           C  
ATOM   1427  N   TYR B  46       6.737  48.279   9.004  1.00 24.62           N  
ATOM   1428  CA  TYR B  46       5.620  48.085   9.937  1.00 23.88           C  
ATOM   1429  C   TYR B  46       5.963  47.033  10.962  1.00 23.68           C  
ATOM   1430  O   TYR B  46       6.655  46.033  10.678  1.00 24.96           O  
ATOM   1431  CB  TYR B  46       4.324  47.666   9.172  1.00 24.25           C  
ATOM   1432  CG  TYR B  46       3.731  48.739   8.285  1.00 24.65           C  
ATOM   1433  CD1 TYR B  46       4.216  48.980   7.001  1.00 24.71           C  
ATOM   1434  CD2 TYR B  46       2.681  49.532   8.736  1.00 25.90           C  
ATOM   1435  CE1 TYR B  46       3.672  49.974   6.225  1.00 26.96           C  
ATOM   1436  CE2 TYR B  46       2.146  50.526   7.942  1.00 25.52           C  
ATOM   1437  CZ  TYR B  46       2.615  50.733   6.724  1.00 24.80           C  
ATOM   1438  OH  TYR B  46       2.024  51.765   5.985  1.00 27.16           O  
ATOM   1439  N   ALA B  47       5.485  47.246  12.180  1.00 23.60           N  
ATOM   1440  CA  ALA B  47       5.783  46.359  13.263  1.00 23.10           C  
ATOM   1441  C   ALA B  47       4.753  46.511  14.382  1.00 23.63           C  
ATOM   1442  O   ALA B  47       3.948  47.462  14.399  1.00 23.80           O  
ATOM   1443  CB  ALA B  47       7.262  46.564  13.772  1.00 22.40           C  
ATOM   1444  N   PHE B  48       4.751  45.524  15.268  1.00 23.57           N  
ATOM   1445  CA  PHE B  48       3.903  45.493  16.457  1.00 24.18           C  
ATOM   1446  C   PHE B  48       4.809  45.427  17.655  1.00 25.56           C  
ATOM   1447  O   PHE B  48       5.906  44.864  17.565  1.00 24.37           O  
ATOM   1448  CB  PHE B  48       2.952  44.279  16.445  1.00 23.98           C  
ATOM   1449  CG  PHE B  48       1.826  44.420  15.482  1.00 24.43           C  
ATOM   1450  CD1 PHE B  48       1.976  44.024  14.162  1.00 25.13           C  
ATOM   1451  CD2 PHE B  48       0.622  44.987  15.877  1.00 27.13           C  
ATOM   1452  CE1 PHE B  48       0.961  44.229  13.248  1.00 26.41           C  
ATOM   1453  CE2 PHE B  48      -0.377  45.178  14.963  1.00 27.50           C  
ATOM   1454  CZ  PHE B  48      -0.212  44.779  13.655  1.00 23.62           C  
ATOM   1455  N   SER B  49       4.362  46.004  18.766  1.00 25.73           N  
ATOM   1456  CA  SER B  49       5.065  45.892  20.039  1.00 27.00           C  
ATOM   1457  C   SER B  49       4.054  45.811  21.191  1.00 27.37           C  
ATOM   1458  O   SER B  49       2.932  46.297  21.083  1.00 28.52           O  
ATOM   1459  CB  SER B  49       5.998  47.108  20.240  1.00 26.98           C  
ATOM   1460  OG  SER B  49       6.675  47.042  21.490  1.00 28.66           O  
HETATM 1461  N   MSE B  50       4.450  45.206  22.295  1.00 27.66           N  
HETATM 1462  CA  MSE B  50       3.721  45.417  23.546  1.00 28.40           C  
HETATM 1463  C   MSE B  50       4.217  46.739  24.145  1.00 27.82           C  
HETATM 1464  O   MSE B  50       5.287  47.249  23.757  1.00 27.40           O  
HETATM 1465  CB  MSE B  50       3.929  44.233  24.493  1.00 29.11           C  
HETATM 1466  CG  MSE B  50       3.319  42.905  23.980  1.00 33.06           C  
HETATM 1467 SE   MSE B  50       1.390  43.064  23.732  0.75 41.83          SE  
HETATM 1468  CE  MSE B  50       0.892  43.106  25.554  1.00 40.95           C  
ATOM   1469  N   PRO B  51       3.446  47.330  25.064  1.00 28.22           N  
ATOM   1470  CA  PRO B  51       3.934  48.517  25.761  1.00 28.18           C  
ATOM   1471  C   PRO B  51       5.277  48.283  26.394  1.00 27.90           C  
ATOM   1472  O   PRO B  51       5.568  47.163  26.823  1.00 28.26           O  
ATOM   1473  CB  PRO B  51       2.914  48.714  26.874  1.00 28.66           C  
ATOM   1474  CG  PRO B  51       1.680  48.083  26.352  1.00 30.26           C  
ATOM   1475  CD  PRO B  51       2.109  46.925  25.528  1.00 28.43           C  
ATOM   1476  N   GLY B  52       6.083  49.333  26.519  1.00 27.52           N  
ATOM   1477  CA  GLY B  52       7.417  49.184  27.119  1.00 25.83           C  
ATOM   1478  C   GLY B  52       8.385  50.289  26.782  1.00 25.63           C  
ATOM   1479  O   GLY B  52       8.014  51.268  26.149  1.00 25.15           O  
ATOM   1480  N   LYS B  53       9.639  50.112  27.190  1.00 24.44           N  
ATOM   1481  CA  LYS B  53      10.687  51.131  27.020  1.00 24.50           C  
ATOM   1482  C   LYS B  53      10.809  51.681  25.628  1.00 23.85           C  
ATOM   1483  O   LYS B  53      10.731  52.894  25.441  1.00 23.54           O  
ATOM   1484  CB  LYS B  53      12.051  50.559  27.484  1.00 24.44           C  
ATOM   1485  CG  LYS B  53      13.140  51.566  27.702  1.00 24.89           C  
ATOM   1486  CD  LYS B  53      14.441  50.947  28.212  1.00 24.32           C  
ATOM   1487  CE  LYS B  53      15.622  51.859  28.002  1.00 27.61           C  
ATOM   1488  NZ  LYS B  53      16.815  51.374  28.751  1.00 26.61           N  
ATOM   1489  N   LYS B  54      10.998  50.836  24.634  1.00 22.01           N  
ATOM   1490  CA  LYS B  54      11.202  51.382  23.287  1.00 22.11           C  
ATOM   1491  C   LYS B  54      10.006  52.209  22.795  1.00 22.20           C  
ATOM   1492  O   LYS B  54      10.197  53.236  22.177  1.00 20.99           O  
ATOM   1493  CB  LYS B  54      11.529  50.332  22.267  1.00 22.40           C  
ATOM   1494  CG  LYS B  54      10.489  49.308  22.042  1.00 24.70           C  
ATOM   1495  CD  LYS B  54      10.975  48.233  21.077  1.00 27.53           C  
ATOM   1496  CE  LYS B  54       9.891  47.296  20.698  1.00 27.99           C  
ATOM   1497  NZ  LYS B  54       9.135  46.738  21.919  1.00 29.75           N  
ATOM   1498  N   ILE B  55       8.802  51.770  23.076  1.00 22.20           N  
ATOM   1499  CA  ILE B  55       7.626  52.562  22.728  1.00 23.45           C  
ATOM   1500  C   ILE B  55       7.622  53.881  23.503  1.00 23.86           C  
ATOM   1501  O   ILE B  55       7.350  54.945  22.927  1.00 25.45           O  
ATOM   1502  CB  ILE B  55       6.342  51.763  22.962  1.00 23.59           C  
ATOM   1503  CG1 ILE B  55       6.300  50.550  22.021  1.00 23.69           C  
ATOM   1504  CG2 ILE B  55       5.113  52.612  22.730  1.00 22.77           C  
ATOM   1505  CD1 ILE B  55       6.397  50.912  20.515  1.00 24.56           C  
ATOM   1506  N   GLU B  56       7.878  53.844  24.804  1.00 23.95           N  
ATOM   1507  CA  GLU B  56       7.917  55.100  25.552  1.00 24.79           C  
ATOM   1508  C   GLU B  56       8.965  56.095  24.997  1.00 24.28           C  
ATOM   1509  O   GLU B  56       8.694  57.299  24.837  1.00 24.60           O  
ATOM   1510  CB  GLU B  56       8.165  54.853  27.029  1.00 25.30           C  
ATOM   1511  CG  GLU B  56       7.030  54.180  27.751  1.00 26.13           C  
ATOM   1512  CD  GLU B  56       5.708  54.925  27.561  1.00 28.97           C  
ATOM   1513  OE1 GLU B  56       5.500  55.916  28.285  1.00 28.71           O  
ATOM   1514  OE2 GLU B  56       4.907  54.512  26.689  1.00 30.98           O  
ATOM   1515  N   TRP B  57      10.154  55.598  24.703  1.00 24.42           N  
ATOM   1516  CA  TRP B  57      11.233  56.435  24.186  1.00 24.41           C  
ATOM   1517  C   TRP B  57      10.949  56.986  22.791  1.00 25.21           C  
ATOM   1518  O   TRP B  57      11.305  58.143  22.489  1.00 26.32           O  
ATOM   1519  CB  TRP B  57      12.546  55.655  24.218  1.00 24.18           C  
ATOM   1520  CG  TRP B  57      13.169  55.565  25.574  1.00 24.75           C  
ATOM   1521  CD1 TRP B  57      12.550  55.624  26.791  1.00 22.93           C  
ATOM   1522  CD2 TRP B  57      14.559  55.417  25.832  1.00 22.33           C  
ATOM   1523  NE1 TRP B  57      13.483  55.526  27.793  1.00 24.57           N  
ATOM   1524  CE2 TRP B  57      14.728  55.412  27.220  1.00 24.68           C  
ATOM   1525  CE3 TRP B  57      15.691  55.342  25.002  1.00 22.03           C  
ATOM   1526  CZ2 TRP B  57      15.972  55.291  27.805  1.00 24.04           C  
ATOM   1527  CZ3 TRP B  57      16.903  55.214  25.571  1.00 23.40           C  
ATOM   1528  CH2 TRP B  57      17.051  55.172  26.953  1.00 23.16           C  
HETATM 1529  N   MSE B  58      10.303  56.199  21.938  1.00 24.31           N  
HETATM 1530  CA  MSE B  58       9.974  56.685  20.586  1.00 23.63           C  
HETATM 1531  C   MSE B  58       8.785  57.646  20.554  1.00 23.64           C  
HETATM 1532  O   MSE B  58       8.726  58.533  19.714  1.00 21.50           O  
HETATM 1533  CB  MSE B  58       9.729  55.488  19.646  1.00 24.12           C  
HETATM 1534  CG  MSE B  58      10.978  54.692  19.442  1.00 23.83           C  
HETATM 1535 SE   MSE B  58      10.842  53.306  18.089  0.75 21.77          SE  
HETATM 1536  CE  MSE B  58       9.536  52.177  19.024  1.00 28.17           C  
ATOM   1537  N   ARG B  59       7.864  57.485  21.508  1.00 23.42           N  
ATOM   1538  CA  ARG B  59       6.773  58.409  21.698  1.00 23.54           C  
ATOM   1539  C   ARG B  59       7.349  59.756  22.054  1.00 23.69           C  
ATOM   1540  O   ARG B  59       6.871  60.773  21.557  1.00 25.18           O  
ATOM   1541  CB  ARG B  59       5.786  57.926  22.788  1.00 23.01           C  
ATOM   1542  CG  ARG B  59       4.724  56.890  22.300  1.00 22.17           C  
ATOM   1543  CD  ARG B  59       4.011  56.274  23.481  1.00 23.09           C  
ATOM   1544  NE  ARG B  59       3.024  55.344  22.971  1.00 23.33           N  
ATOM   1545  CZ  ARG B  59       2.378  54.440  23.679  1.00 23.10           C  
ATOM   1546  NH1 ARG B  59       2.587  54.325  24.988  1.00 21.39           N  
ATOM   1547  NH2 ARG B  59       1.493  53.640  23.045  1.00 22.06           N  
ATOM   1548  N   ALA B  60       8.348  59.791  22.915  1.00 23.31           N  
ATOM   1549  CA  ALA B  60       8.975  61.075  23.277  1.00 23.81           C  
ATOM   1550  C   ALA B  60       9.987  61.661  22.235  1.00 23.89           C  
ATOM   1551  O   ALA B  60      10.117  62.894  22.102  1.00 22.59           O  
ATOM   1552  CB  ALA B  60       9.623  60.969  24.651  1.00 24.68           C  
ATOM   1553  N   ASN B  61      10.708  60.798  21.541  1.00 23.96           N  
ATOM   1554  CA  ASN B  61      11.689  61.163  20.521  1.00 24.75           C  
ATOM   1555  C   ASN B  61      11.502  60.234  19.328  1.00 23.76           C  
ATOM   1556  O   ASN B  61      11.977  59.126  19.350  1.00 23.92           O  
ATOM   1557  CB  ASN B  61      13.147  60.994  21.024  1.00 25.13           C  
ATOM   1558  CG  ASN B  61      14.193  61.256  19.913  1.00 27.45           C  
ATOM   1559  OD1 ASN B  61      13.846  61.831  18.848  1.00 24.65           O  
ATOM   1560  ND2 ASN B  61      15.485  60.866  20.167  1.00 23.16           N  
ATOM   1561  N   PRO B  62      10.815  60.683  18.280  1.00 23.12           N  
ATOM   1562  CA  PRO B  62      10.582  59.741  17.210  1.00 24.13           C  
ATOM   1563  C   PRO B  62      11.748  59.514  16.239  1.00 22.77           C  
ATOM   1564  O   PRO B  62      11.564  58.778  15.306  1.00 21.89           O  
ATOM   1565  CB  PRO B  62       9.340  60.303  16.510  1.00 23.36           C  
ATOM   1566  CG  PRO B  62       9.455  61.728  16.714  1.00 25.85           C  
ATOM   1567  CD  PRO B  62      10.197  61.984  18.002  1.00 25.44           C  
ATOM   1568  N   ARG B  63      12.954  60.065  16.474  1.00 21.90           N  
ATOM   1569  CA  ARG B  63      14.107  59.747  15.626  0.50 21.69           C  
ATOM   1571  C   ARG B  63      14.625  58.339  15.922  1.00 21.53           C  
ATOM   1572  O   ARG B  63      14.911  58.009  17.073  1.00 22.53           O  
ATOM   1573  CB  ARG B  63      15.240  60.775  15.833  0.50 22.00           C  
ATOM   1575  CG  ARG B  63      14.838  62.223  15.670  0.50 21.76           C  
ATOM   1577  CD  ARG B  63      15.976  63.129  16.125  0.50 22.19           C  
ATOM   1579  NE  ARG B  63      15.733  64.561  15.981  0.50 22.59           N  
ATOM   1581  CZ  ARG B  63      14.895  65.278  16.735  0.50 23.49           C  
ATOM   1583  NH1 ARG B  63      14.140  64.688  17.663  0.50 24.91           N  
ATOM   1585  NH2 ARG B  63      14.775  66.578  16.520  0.50 22.97           N  
ATOM   1587  N   VAL B  64      14.758  57.505  14.879  1.00 20.55           N  
ATOM   1588  CA  VAL B  64      15.280  56.192  15.043  1.00 23.05           C  
ATOM   1589  C   VAL B  64      16.279  55.841  13.940  1.00 21.68           C  
ATOM   1590  O   VAL B  64      16.371  56.503  12.923  1.00 22.37           O  
ATOM   1591  CB  VAL B  64      14.146  55.094  15.031  1.00 23.09           C  
ATOM   1592  CG1 VAL B  64      13.118  55.408  16.117  1.00 24.13           C  
ATOM   1593  CG2 VAL B  64      13.495  54.970  13.666  1.00 25.15           C  
ATOM   1594  N   SER B  65      16.962  54.738  14.155  1.00 23.10           N  
ATOM   1595  CA  SER B  65      17.770  54.104  13.113  1.00 23.90           C  
ATOM   1596  C   SER B  65      17.442  52.618  13.142  1.00 24.28           C  
ATOM   1597  O   SER B  65      17.185  52.038  14.229  1.00 24.90           O  
ATOM   1598  CB  SER B  65      19.254  54.376  13.363  1.00 24.06           C  
ATOM   1599  OG  SER B  65      20.091  53.691  12.448  1.00 25.21           O  
ATOM   1600  N   VAL B  66      17.405  51.996  11.955  1.00 23.68           N  
ATOM   1601  CA  VAL B  66      17.172  50.549  11.825  1.00 23.15           C  
ATOM   1602  C   VAL B  66      18.230  49.930  10.935  1.00 22.69           C  
ATOM   1603  O   VAL B  66      18.526  50.453   9.884  1.00 21.72           O  
ATOM   1604  CB  VAL B  66      15.767  50.251  11.208  1.00 23.26           C  
ATOM   1605  CG1 VAL B  66      15.492  48.774  11.179  1.00 25.14           C  
ATOM   1606  CG2 VAL B  66      14.673  50.900  11.998  1.00 24.57           C  
ATOM   1607  N   GLN B  67      18.789  48.814  11.365  1.00 22.12           N  
ATOM   1608  CA  GLN B  67      19.790  48.103  10.620  1.00 22.60           C  
ATOM   1609  C   GLN B  67      19.324  46.692  10.258  1.00 21.78           C  
ATOM   1610  O   GLN B  67      18.798  45.950  11.106  1.00 20.00           O  
ATOM   1611  CB  GLN B  67      21.100  48.045  11.423  1.00 23.38           C  
ATOM   1612  CG  GLN B  67      22.251  47.509  10.603  1.00 23.82           C  
ATOM   1613  CD  GLN B  67      22.400  45.980  10.741  1.00 23.88           C  
ATOM   1614  OE1 GLN B  67      21.997  45.382  11.761  1.00 21.87           O  
ATOM   1615  NE2 GLN B  67      22.991  45.352   9.722  1.00 21.61           N  
ATOM   1616  N   VAL B  68      19.514  46.325   8.987  1.00 22.49           N  
ATOM   1617  CA  VAL B  68      19.012  45.075   8.452  1.00 21.21           C  
ATOM   1618  C   VAL B  68      20.129  44.496   7.639  1.00 21.73           C  
ATOM   1619  O   VAL B  68      20.786  45.211   6.911  1.00 21.53           O  
ATOM   1620  CB  VAL B  68      17.773  45.319   7.558  1.00 21.16           C  
ATOM   1621  CG1 VAL B  68      17.278  44.037   6.885  1.00 21.77           C  
ATOM   1622  CG2 VAL B  68      16.646  45.980   8.380  1.00 20.42           C  
ATOM   1623  N   ASP B  69      20.373  43.200   7.755  1.00 22.49           N  
ATOM   1624  CA  ASP B  69      21.370  42.589   6.897  1.00 24.55           C  
ATOM   1625  C   ASP B  69      21.060  41.170   6.502  1.00 25.87           C  
ATOM   1626  O   ASP B  69      20.172  40.545   7.051  1.00 25.04           O  
ATOM   1627  CB  ASP B  69      22.779  42.680   7.510  1.00 24.99           C  
ATOM   1628  CG  ASP B  69      22.861  42.047   8.879  1.00 29.53           C  
ATOM   1629  OD1 ASP B  69      22.503  40.856   9.001  1.00 32.48           O  
ATOM   1630  OD2 ASP B  69      23.275  42.756   9.831  1.00 35.29           O  
ATOM   1631  N   GLU B  70      21.826  40.652   5.546  1.00 27.22           N  
ATOM   1632  CA  GLU B  70      21.639  39.308   5.097  1.00 30.39           C  
ATOM   1633  C   GLU B  70      22.987  38.760   4.673  1.00 32.51           C  
ATOM   1634  O   GLU B  70      23.904  39.505   4.359  1.00 30.69           O  
ATOM   1635  CB  GLU B  70      20.632  39.264   3.933  1.00 30.08           C  
ATOM   1636  CG  GLU B  70      21.098  40.067   2.707  1.00 30.63           C  
ATOM   1637  CD  GLU B  70      20.126  40.040   1.527  1.00 31.59           C  
ATOM   1638  OE1 GLU B  70      18.871  40.031   1.715  1.00 30.40           O  
ATOM   1639  OE2 GLU B  70      20.637  40.077   0.378  1.00 32.76           O  
ATOM   1640  N   HIS B  71      23.099  37.440   4.698  1.00 36.88           N  
ATOM   1641  CA  HIS B  71      24.239  36.766   4.077  1.00 39.91           C  
ATOM   1642  C   HIS B  71      24.164  36.780   2.559  1.00 41.30           C  
ATOM   1643  O   HIS B  71      23.086  36.818   1.954  1.00 40.92           O  
ATOM   1644  CB  HIS B  71      24.329  35.307   4.523  1.00 41.44           C  
ATOM   1645  CG  HIS B  71      24.752  35.156   5.946  1.00 45.16           C  
ATOM   1646  ND1 HIS B  71      23.960  34.552   6.900  1.00 49.35           N  
ATOM   1647  CD2 HIS B  71      25.869  35.573   6.590  1.00 49.49           C  
ATOM   1648  CE1 HIS B  71      24.577  34.589   8.069  1.00 50.23           C  
ATOM   1649  NE2 HIS B  71      25.739  35.201   7.907  1.00 50.73           N  
ATOM   1650  N   GLY B  72      25.344  36.741   1.957  1.00 42.98           N  
ATOM   1651  CA  GLY B  72      25.462  36.372   0.578  1.00 44.16           C  
ATOM   1652  C   GLY B  72      26.294  35.110   0.540  1.00 45.33           C  
ATOM   1653  O   GLY B  72      26.104  34.177   1.341  1.00 46.16           O  
ATOM   1654  N   GLN B  73      27.274  35.143  -0.354  1.00 46.14           N  
ATOM   1655  CA  GLN B  73      28.045  33.995  -0.789  1.00 46.21           C  
ATOM   1656  C   GLN B  73      29.296  33.966   0.063  1.00 45.42           C  
ATOM   1657  O   GLN B  73      29.845  35.020   0.384  1.00 45.57           O  
ATOM   1658  CB  GLN B  73      28.422  34.160  -2.275  1.00 46.88           C  
ATOM   1659  CG  GLN B  73      29.019  35.570  -2.639  1.00 49.54           C  
ATOM   1660  CD  GLN B  73      27.991  36.710  -2.553  1.00 51.62           C  
ATOM   1661  OE1 GLN B  73      26.918  36.629  -3.154  1.00 54.74           O  
ATOM   1662  NE2 GLN B  73      28.307  37.757  -1.777  1.00 53.62           N  
ATOM   1663  N   GLY B  74      29.753  32.771   0.423  1.00 44.46           N  
ATOM   1664  CA  GLY B  74      30.886  32.625   1.327  1.00 43.59           C  
ATOM   1665  C   GLY B  74      30.710  33.495   2.564  1.00 42.90           C  
ATOM   1666  O   GLY B  74      29.695  33.401   3.251  1.00 42.68           O  
ATOM   1667  N   ARG B  75      31.695  34.349   2.835  1.00 41.82           N  
ATOM   1668  CA  ARG B  75      31.637  35.285   3.955  1.00 40.99           C  
ATOM   1669  C   ARG B  75      30.963  36.617   3.566  1.00 39.44           C  
ATOM   1670  O   ARG B  75      30.978  37.575   4.353  1.00 40.05           O  
ATOM   1671  CB  ARG B  75      33.068  35.534   4.497  1.00 41.59           C  
ATOM   1672  N   GLY B  76      30.383  36.675   2.362  1.00 37.39           N  
ATOM   1673  CA  GLY B  76      29.674  37.865   1.872  1.00 36.22           C  
ATOM   1674  C   GLY B  76      28.483  38.295   2.727  1.00 34.57           C  
ATOM   1675  O   GLY B  76      27.944  37.500   3.514  1.00 34.33           O  
ATOM   1676  N   TRP B  77      28.086  39.563   2.573  1.00 32.70           N  
ATOM   1677  CA  TRP B  77      26.909  40.107   3.234  1.00 30.66           C  
ATOM   1678  C   TRP B  77      26.467  41.442   2.612  1.00 28.89           C  
ATOM   1679  O   TRP B  77      27.219  42.085   1.858  1.00 27.59           O  
ATOM   1680  CB  TRP B  77      27.148  40.308   4.726  1.00 31.50           C  
ATOM   1681  CG  TRP B  77      28.350  41.105   5.062  1.00 31.56           C  
ATOM   1682  CD1 TRP B  77      29.573  40.604   5.421  1.00 33.25           C  
ATOM   1683  CD2 TRP B  77      28.476  42.547   5.114  1.00 32.62           C  
ATOM   1684  NE1 TRP B  77      30.461  41.642   5.669  1.00 33.54           N  
ATOM   1685  CE2 TRP B  77      29.811  42.840   5.491  1.00 33.31           C  
ATOM   1686  CE3 TRP B  77      27.603  43.622   4.852  1.00 31.41           C  
ATOM   1687  CZ2 TRP B  77      30.286  44.157   5.613  1.00 32.59           C  
ATOM   1688  CZ3 TRP B  77      28.077  44.921   4.984  1.00 31.69           C  
ATOM   1689  CH2 TRP B  77      29.410  45.179   5.351  1.00 31.54           C  
ATOM   1690  N   LYS B  78      25.230  41.808   2.908  1.00 25.99           N  
ATOM   1691  CA  LYS B  78      24.652  43.069   2.496  1.00 25.33           C  
ATOM   1692  C   LYS B  78      23.994  43.626   3.735  1.00 24.47           C  
ATOM   1693  O   LYS B  78      23.352  42.873   4.498  1.00 22.86           O  
ATOM   1694  CB  LYS B  78      23.594  42.898   1.425  1.00 25.48           C  
ATOM   1695  CG  LYS B  78      24.123  42.497   0.090  1.00 27.96           C  
ATOM   1696  CD  LYS B  78      23.036  42.626  -0.977  1.00 30.07           C  
ATOM   1697  CE  LYS B  78      23.281  41.727  -2.128  1.00 31.90           C  
ATOM   1698  NZ  LYS B  78      24.349  42.268  -2.987  1.00 34.49           N  
ATOM   1699  N   SER B  79      24.185  44.918   3.979  1.00 24.47           N  
ATOM   1700  CA  SER B  79      23.595  45.568   5.162  1.00 24.02           C  
ATOM   1701  C   SER B  79      22.997  46.893   4.726  1.00 25.25           C  
ATOM   1702  O   SER B  79      23.619  47.590   3.895  1.00 25.50           O  
ATOM   1703  CB  SER B  79      24.704  45.851   6.179  1.00 24.34           C  
ATOM   1704  OG  SER B  79      24.235  46.629   7.285  1.00 23.11           O  
ATOM   1705  N   VAL B  80      21.866  47.257   5.342  1.00 24.77           N  
ATOM   1706  CA  VAL B  80      21.187  48.531   5.118  1.00 24.22           C  
ATOM   1707  C   VAL B  80      21.028  49.255   6.453  1.00 23.92           C  
ATOM   1708  O   VAL B  80      20.718  48.619   7.488  1.00 23.19           O  
ATOM   1709  CB  VAL B  80      19.807  48.275   4.414  1.00 24.92           C  
ATOM   1710  CG1 VAL B  80      18.914  49.507   4.424  1.00 25.80           C  
ATOM   1711  CG2 VAL B  80      20.074  47.870   2.983  1.00 24.62           C  
ATOM   1712  N   VAL B  81      21.250  50.568   6.442  1.00 22.37           N  
ATOM   1713  CA  VAL B  81      20.909  51.397   7.583  1.00 23.14           C  
ATOM   1714  C   VAL B  81      19.865  52.407   7.175  1.00 23.14           C  
ATOM   1715  O   VAL B  81      20.024  53.118   6.165  1.00 23.11           O  
ATOM   1716  CB  VAL B  81      22.133  52.039   8.273  1.00 23.59           C  
ATOM   1717  CG1 VAL B  81      21.686  52.949   9.412  1.00 23.62           C  
ATOM   1718  CG2 VAL B  81      23.052  50.947   8.795  1.00 27.07           C  
ATOM   1719  N   VAL B  82      18.777  52.425   7.944  1.00 25.61           N  
ATOM   1720  CA  VAL B  82      17.650  53.347   7.702  1.00 26.69           C  
ATOM   1721  C   VAL B  82      17.642  54.397   8.788  1.00 27.09           C  
ATOM   1722  O   VAL B  82      17.696  54.071   9.972  1.00 26.42           O  
ATOM   1723  CB  VAL B  82      16.314  52.623   7.760  1.00 27.63           C  
ATOM   1724  CG1 VAL B  82      15.143  53.613   8.094  1.00 29.91           C  
ATOM   1725  CG2 VAL B  82      16.063  51.884   6.454  1.00 27.65           C  
ATOM   1726  N   ASP B  83      17.523  55.657   8.390  1.00 26.77           N  
ATOM   1727  CA  ASP B  83      17.284  56.685   9.350  1.00 27.20           C  
ATOM   1728  C   ASP B  83      15.871  57.121   9.192  1.00 26.17           C  
ATOM   1729  O   ASP B  83      15.383  57.459   8.106  1.00 25.30           O  
ATOM   1730  CB  ASP B  83      18.339  57.757   9.266  1.00 28.63           C  
ATOM   1731  CG  ASP B  83      19.764  57.168   9.555  1.00 34.25           C  
ATOM   1732  OD1 ASP B  83      19.969  56.321  10.521  1.00 40.10           O  
ATOM   1733  OD2 ASP B  83      20.677  57.525   8.792  1.00 40.71           O  
ATOM   1734  N   GLY B  84      15.173  57.017  10.294  1.00 26.44           N  
ATOM   1735  CA  GLY B  84      13.734  56.985  10.256  1.00 26.02           C  
ATOM   1736  C   GLY B  84      13.030  57.833  11.291  1.00 25.33           C  
ATOM   1737  O   GLY B  84      13.650  58.424  12.211  1.00 22.06           O  
ATOM   1738  N   ARG B  85      11.719  57.824  11.130  1.00 24.23           N  
ATOM   1739  CA  ARG B  85      10.825  58.444  12.064  1.00 25.97           C  
ATOM   1740  C   ARG B  85       9.760  57.438  12.521  1.00 25.59           C  
ATOM   1741  O   ARG B  85       9.083  56.799  11.695  1.00 25.01           O  
ATOM   1742  CB  ARG B  85      10.198  59.664  11.386  1.00 26.89           C  
ATOM   1743  CG  ARG B  85       8.925  60.065  12.024  1.00 28.81           C  
ATOM   1744  CD  ARG B  85       8.142  61.222  11.326  1.00 29.81           C  
ATOM   1745  NE  ARG B  85       8.795  61.910  10.205  1.00 32.24           N  
ATOM   1746  CZ  ARG B  85       8.290  63.035   9.690  1.00 31.41           C  
ATOM   1747  NH1 ARG B  85       7.188  63.541  10.223  1.00 34.01           N  
ATOM   1748  NH2 ARG B  85       8.870  63.662   8.683  1.00 30.74           N  
ATOM   1749  N   TYR B  86       9.655  57.239  13.832  1.00 25.47           N  
ATOM   1750  CA  TYR B  86       8.534  56.462  14.422  1.00 24.65           C  
ATOM   1751  C   TYR B  86       7.167  57.130  14.201  1.00 26.02           C  
ATOM   1752  O   TYR B  86       7.025  58.320  14.508  1.00 25.23           O  
ATOM   1753  CB  TYR B  86       8.763  56.388  15.905  1.00 24.87           C  
ATOM   1754  CG  TYR B  86       7.639  55.737  16.743  1.00 24.21           C  
ATOM   1755  CD1 TYR B  86       7.498  54.364  16.808  1.00 25.90           C  
ATOM   1756  CD2 TYR B  86       6.781  56.517  17.513  1.00 24.59           C  
ATOM   1757  CE1 TYR B  86       6.503  53.771  17.600  1.00 25.31           C  
ATOM   1758  CE2 TYR B  86       5.786  55.927  18.329  1.00 23.62           C  
ATOM   1759  CZ  TYR B  86       5.659  54.559  18.355  1.00 25.37           C  
ATOM   1760  OH  TYR B  86       4.697  53.947  19.126  1.00 25.13           O  
ATOM   1761  N   GLU B  87       6.176  56.390  13.688  1.00 25.57           N  
ATOM   1762  CA  GLU B  87       4.789  56.890  13.627  1.00 27.84           C  
ATOM   1763  C   GLU B  87       3.895  55.852  14.208  1.00 26.83           C  
ATOM   1764  O   GLU B  87       3.773  54.770  13.654  1.00 26.44           O  
ATOM   1765  CB  GLU B  87       4.349  57.128  12.199  1.00 29.41           C  
ATOM   1766  CG  GLU B  87       5.308  58.042  11.434  1.00 35.08           C  
ATOM   1767  CD  GLU B  87       5.175  57.947   9.921  1.00 44.19           C  
ATOM   1768  OE1 GLU B  87       4.100  57.521   9.446  1.00 47.92           O  
ATOM   1769  OE2 GLU B  87       6.149  58.318   9.215  1.00 51.77           O  
ATOM   1770  N   GLU B  88       3.302  56.143  15.359  1.00 26.91           N  
ATOM   1771  CA  GLU B  88       2.354  55.185  15.974  1.00 25.83           C  
ATOM   1772  C   GLU B  88       1.100  55.146  15.125  1.00 26.25           C  
ATOM   1773  O   GLU B  88       0.731  56.157  14.536  1.00 26.57           O  
ATOM   1774  CB  GLU B  88       2.012  55.605  17.388  1.00 27.20           C  
ATOM   1775  CG  GLU B  88       1.261  54.522  18.170  1.00 26.61           C  
ATOM   1776  CD  GLU B  88       1.423  54.617  19.657  1.00 29.02           C  
ATOM   1777  OE1 GLU B  88       2.478  55.093  20.128  1.00 26.98           O  
ATOM   1778  OE2 GLU B  88       0.498  54.167  20.366  1.00 27.71           O  
ATOM   1779  N   LEU B  89       0.476  53.985  15.019  1.00 25.87           N  
ATOM   1780  CA  LEU B  89      -0.734  53.858  14.240  1.00 26.57           C  
ATOM   1781  C   LEU B  89      -1.882  53.481  15.174  1.00 25.83           C  
ATOM   1782  O   LEU B  89      -2.153  52.301  15.348  1.00 26.78           O  
ATOM   1783  CB  LEU B  89      -0.528  52.830  13.142  1.00 26.21           C  
ATOM   1784  CG  LEU B  89       0.615  53.160  12.161  1.00 27.06           C  
ATOM   1785  CD1 LEU B  89       1.029  51.876  11.395  1.00 29.68           C  
ATOM   1786  CD2 LEU B  89       0.331  54.304  11.228  1.00 28.47           C  
ATOM   1787  N   PRO B  90      -2.591  54.481  15.741  1.00 24.94           N  
ATOM   1788  CA  PRO B  90      -3.616  54.160  16.705  1.00 25.09           C  
ATOM   1789  C   PRO B  90      -4.684  53.263  16.145  1.00 23.43           C  
ATOM   1790  O   PRO B  90      -4.911  53.287  14.923  1.00 21.46           O  
ATOM   1791  CB  PRO B  90      -4.236  55.521  17.043  1.00 25.65           C  
ATOM   1792  CG  PRO B  90      -3.249  56.467  16.702  1.00 26.97           C  
ATOM   1793  CD  PRO B  90      -2.549  55.927  15.498  1.00 26.72           C  
ATOM   1794  N   ASP B  91      -5.353  52.518  17.034  1.00 22.44           N  
ATOM   1795  CA  ASP B  91      -6.356  51.563  16.642  1.00 23.18           C  
ATOM   1796  C   ASP B  91      -7.683  52.243  16.274  1.00 22.88           C  
ATOM   1797  O   ASP B  91      -8.701  52.080  16.939  1.00 21.27           O  
ATOM   1798  CB  ASP B  91      -6.591  50.499  17.718  1.00 22.85           C  
ATOM   1799  CG  ASP B  91      -7.362  49.301  17.190  1.00 27.26           C  
ATOM   1800  OD1 ASP B  91      -7.681  49.213  15.973  1.00 28.92           O  
ATOM   1801  OD2 ASP B  91      -7.640  48.422  18.006  1.00 28.34           O  
ATOM   1802  N   LEU B  92      -7.639  52.964  15.164  1.00 23.30           N  
ATOM   1803  CA  LEU B  92      -8.776  53.705  14.635  1.00 23.98           C  
ATOM   1804  C   LEU B  92      -9.034  53.150  13.251  1.00 23.61           C  
ATOM   1805  O   LEU B  92      -8.154  52.555  12.633  1.00 23.13           O  
ATOM   1806  CB  LEU B  92      -8.462  55.202  14.532  1.00 23.94           C  
ATOM   1807  CG  LEU B  92      -7.982  55.873  15.822  1.00 27.81           C  
ATOM   1808  CD1 LEU B  92      -7.381  57.214  15.451  1.00 31.01           C  
ATOM   1809  CD2 LEU B  92      -9.112  56.016  16.823  1.00 29.49           C  
ATOM   1810  N   ILE B  93     -10.228  53.374  12.756  1.00 24.49           N  
ATOM   1811  CA  ILE B  93     -10.677  52.732  11.515  1.00 26.12           C  
ATOM   1812  C   ILE B  93      -9.812  53.086  10.305  1.00 26.66           C  
ATOM   1813  O   ILE B  93      -9.623  52.249   9.405  1.00 26.16           O  
ATOM   1814  CB  ILE B  93     -12.200  52.985  11.260  1.00 27.03           C  
ATOM   1815  CG1 ILE B  93     -12.750  52.109  10.116  1.00 28.27           C  
ATOM   1816  CG2 ILE B  93     -12.461  54.474  11.013  1.00 30.09           C  
ATOM   1817  CD1 ILE B  93     -12.651  50.577  10.362  1.00 30.15           C  
ATOM   1818  N   GLY B  94      -9.221  54.279  10.324  1.00 28.28           N  
ATOM   1819  CA  GLY B  94      -8.355  54.721   9.236  1.00 29.18           C  
ATOM   1820  C   GLY B  94      -7.078  53.904   9.104  1.00 30.07           C  
ATOM   1821  O   GLY B  94      -6.422  53.952   8.045  1.00 30.98           O  
ATOM   1822  N   HIS B  95      -6.697  53.189  10.173  1.00 28.19           N  
ATOM   1823  CA  HIS B  95      -5.504  52.322  10.172  1.00 26.77           C  
ATOM   1824  C   HIS B  95      -5.835  50.833  10.255  1.00 25.63           C  
ATOM   1825  O   HIS B  95      -4.939  50.001  10.303  1.00 25.54           O  
ATOM   1826  CB  HIS B  95      -4.559  52.696  11.332  1.00 26.82           C  
ATOM   1827  CG  HIS B  95      -4.064  54.101  11.278  1.00 29.35           C  
ATOM   1828  ND1 HIS B  95      -3.372  54.604  10.195  1.00 31.07           N  
ATOM   1829  CD2 HIS B  95      -4.169  55.121  12.168  1.00 31.36           C  
ATOM   1830  CE1 HIS B  95      -3.044  55.865  10.440  1.00 32.91           C  
ATOM   1831  NE2 HIS B  95      -3.514  56.199  11.629  1.00 32.15           N  
ATOM   1832  N   LYS B  96      -7.118  50.476  10.169  1.00 26.33           N  
ATOM   1833  CA  LYS B  96      -7.544  49.114  10.402  1.00 26.30           C  
ATOM   1834  C   LYS B  96      -7.037  48.170   9.305  1.00 26.54           C  
ATOM   1835  O   LYS B  96      -6.522  47.087   9.597  1.00 25.56           O  
ATOM   1836  CB  LYS B  96      -9.055  49.044  10.514  1.00 27.19           C  
ATOM   1837  CG  LYS B  96      -9.588  47.634  10.706  1.00 29.25           C  
ATOM   1838  CD  LYS B  96      -8.918  46.911  11.848  1.00 33.24           C  
ATOM   1839  CE  LYS B  96      -9.765  45.736  12.362  1.00 35.05           C  
ATOM   1840  NZ  LYS B  96      -9.031  45.029  13.470  1.00 37.61           N  
ATOM   1841  N   LEU B  97      -7.108  48.620   8.059  1.00 26.11           N  
ATOM   1842  CA  LEU B  97      -6.690  47.778   6.959  1.00 26.76           C  
ATOM   1843  C   LEU B  97      -5.166  47.574   7.037  1.00 25.80           C  
ATOM   1844  O   LEU B  97      -4.699  46.459   6.880  1.00 25.13           O  
ATOM   1845  CB  LEU B  97      -7.164  48.369   5.634  1.00 26.73           C  
ATOM   1846  CG  LEU B  97      -6.708  47.628   4.378  1.00 30.08           C  
ATOM   1847  CD1 LEU B  97      -7.386  46.253   4.316  1.00 30.70           C  
ATOM   1848  CD2 LEU B  97      -6.998  48.496   3.158  1.00 29.18           C  
ATOM   1849  N   GLN B  98      -4.417  48.642   7.319  1.00 25.90           N  
ATOM   1850  CA  GLN B  98      -2.958  48.555   7.547  1.00 26.26           C  
ATOM   1851  C   GLN B  98      -2.679  47.578   8.655  1.00 24.89           C  
ATOM   1852  O   GLN B  98      -1.819  46.704   8.544  1.00 25.09           O  
ATOM   1853  CB  GLN B  98      -2.379  49.904   7.976  1.00 26.72           C  
ATOM   1854  CG  GLN B  98      -2.400  50.949   6.878  1.00 31.69           C  
ATOM   1855  CD  GLN B  98      -2.114  52.324   7.387  1.00 36.32           C  
ATOM   1856  OE1 GLN B  98      -2.624  52.736   8.422  1.00 40.42           O  
ATOM   1857  NE2 GLN B  98      -1.314  53.071   6.639  1.00 40.14           N  
ATOM   1858  N   ARG B  99      -3.443  47.701   9.735  1.00 24.47           N  
ATOM   1859  CA  ARG B  99      -3.275  46.824  10.901  1.00 23.50           C  
ATOM   1860  C   ARG B  99      -3.553  45.370  10.553  1.00 23.81           C  
ATOM   1861  O   ARG B  99      -2.756  44.475  10.876  1.00 22.19           O  
ATOM   1862  CB  ARG B  99      -4.189  47.260  12.047  1.00 23.54           C  
ATOM   1863  CG  ARG B  99      -3.819  46.626  13.380  1.00 24.05           C  
ATOM   1864  CD  ARG B  99      -4.773  47.017  14.446  1.00 26.12           C  
ATOM   1865  NE  ARG B  99      -4.263  46.656  15.762  1.00 27.80           N  
ATOM   1866  CZ  ARG B  99      -3.698  47.494  16.640  1.00 28.58           C  
ATOM   1867  NH1 ARG B  99      -3.582  48.786  16.412  1.00 27.13           N  
ATOM   1868  NH2 ARG B  99      -3.266  47.015  17.801  1.00 32.10           N  
ATOM   1869  N   ASP B 100      -4.689  45.131   9.909  1.00 23.93           N  
ATOM   1870  CA  ASP B 100      -5.047  43.764   9.518  1.00 24.51           C  
ATOM   1871  C   ASP B 100      -4.011  43.137   8.592  1.00 24.26           C  
ATOM   1872  O   ASP B 100      -3.556  42.010   8.822  1.00 23.36           O  
ATOM   1873  CB  ASP B 100      -6.428  43.733   8.874  1.00 25.09           C  
ATOM   1874  CG  ASP B 100      -7.559  44.009   9.869  1.00 28.04           C  
ATOM   1875  OD1 ASP B 100      -7.347  43.976  11.130  1.00 31.70           O  
ATOM   1876  OD2 ASP B 100      -8.654  44.302   9.357  1.00 29.09           O  
ATOM   1877  N   HIS B 101      -3.609  43.886   7.567  1.00 24.61           N  
ATOM   1878  CA  HIS B 101      -2.564  43.420   6.645  1.00 25.03           C  
ATOM   1879  C   HIS B 101      -1.268  43.089   7.343  1.00 24.69           C  
ATOM   1880  O   HIS B 101      -0.737  41.997   7.170  1.00 24.61           O  
ATOM   1881  CB  HIS B 101      -2.237  44.489   5.603  1.00 25.40           C  
ATOM   1882  CG  HIS B 101      -3.311  44.690   4.588  1.00 26.45           C  
ATOM   1883  ND1 HIS B 101      -3.375  45.812   3.797  1.00 27.61           N  
ATOM   1884  CD2 HIS B 101      -4.338  43.894   4.202  1.00 27.79           C  
ATOM   1885  CE1 HIS B 101      -4.411  45.708   2.978  1.00 28.85           C  
ATOM   1886  NE2 HIS B 101      -5.010  44.553   3.206  1.00 26.72           N  
ATOM   1887  N   ALA B 102      -0.769  44.032   8.125  1.00 24.65           N  
ATOM   1888  CA  ALA B 102       0.498  43.835   8.873  1.00 25.14           C  
ATOM   1889  C   ALA B 102       0.417  42.646   9.819  1.00 24.99           C  
ATOM   1890  O   ALA B 102       1.369  41.876   9.933  1.00 23.88           O  
ATOM   1891  CB  ALA B 102       0.899  45.080   9.656  1.00 25.77           C  
ATOM   1892  N   TRP B 103      -0.713  42.520  10.515  1.00 25.09           N  
ATOM   1893  CA  TRP B 103      -0.854  41.488  11.538  1.00 25.35           C  
ATOM   1894  C   TRP B 103      -0.839  40.102  10.893  1.00 25.71           C  
ATOM   1895  O   TRP B 103      -0.284  39.145  11.456  1.00 25.59           O  
ATOM   1896  CB  TRP B 103      -2.147  41.679  12.319  1.00 25.61           C  
ATOM   1897  CG  TRP B 103      -2.338  40.637  13.331  1.00 25.44           C  
ATOM   1898  CD1 TRP B 103      -3.247  39.594  13.305  1.00 27.85           C  
ATOM   1899  CD2 TRP B 103      -1.559  40.458  14.495  1.00 25.23           C  
ATOM   1900  NE1 TRP B 103      -3.089  38.818  14.408  1.00 26.17           N  
ATOM   1901  CE2 TRP B 103      -2.062  39.324  15.163  1.00 26.24           C  
ATOM   1902  CE3 TRP B 103      -0.493  41.176  15.071  1.00 27.08           C  
ATOM   1903  CZ2 TRP B 103      -1.536  38.883  16.392  1.00 27.97           C  
ATOM   1904  CZ3 TRP B 103       0.030  40.744  16.294  1.00 28.00           C  
ATOM   1905  CH2 TRP B 103      -0.477  39.595  16.927  1.00 26.12           C  
ATOM   1906  N   SER B 104      -1.452  39.993   9.723  1.00 25.62           N  
ATOM   1907  CA  SER B 104      -1.521  38.701   9.043  0.50 26.52           C  
ATOM   1909  C   SER B 104      -0.125  38.243   8.635  1.00 26.85           C  
ATOM   1910  O   SER B 104       0.174  37.064   8.713  1.00 27.73           O  
ATOM   1911  CB  SER B 104      -2.505  38.714   7.858  0.50 26.32           C  
ATOM   1913  OG  SER B 104      -2.065  39.498   6.766  0.50 27.03           O  
ATOM   1915  N   VAL B 105       0.746  39.188   8.255  1.00 28.73           N  
ATOM   1916  CA  VAL B 105       2.133  38.862   7.877  1.00 29.59           C  
ATOM   1917  C   VAL B 105       3.004  38.611   9.109  1.00 29.54           C  
ATOM   1918  O   VAL B 105       3.841  37.708   9.114  1.00 29.18           O  
ATOM   1919  CB  VAL B 105       2.736  39.968   7.011  1.00 29.82           C  
ATOM   1920  CG1 VAL B 105       4.241  39.823   6.916  1.00 32.46           C  
ATOM   1921  CG2 VAL B 105       2.089  39.951   5.652  1.00 30.23           C  
ATOM   1922  N   LEU B 106       2.785  39.381  10.159  1.00 29.88           N  
ATOM   1923  CA  LEU B 106       3.627  39.317  11.345  1.00 31.15           C  
ATOM   1924  C   LEU B 106       3.088  38.431  12.462  1.00 33.12           C  
ATOM   1925  O   LEU B 106       3.767  38.220  13.470  1.00 33.88           O  
ATOM   1926  CB  LEU B 106       3.858  40.731  11.878  1.00 30.91           C  
ATOM   1927  CG  LEU B 106       4.745  41.621  11.006  1.00 29.44           C  
ATOM   1928  CD1 LEU B 106       4.592  43.058  11.455  1.00 28.44           C  
ATOM   1929  CD2 LEU B 106       6.221  41.188  11.028  1.00 30.82           C  
ATOM   1930  N   SER B 107       1.862  37.933  12.295  1.00 34.62           N  
ATOM   1931  CA  SER B 107       1.162  37.205  13.357  1.00 36.41           C  
ATOM   1932  C   SER B 107       1.947  36.002  13.814  1.00 37.57           C  
ATOM   1933  O   SER B 107       2.106  35.801  15.017  1.00 38.48           O  
ATOM   1934  CB  SER B 107      -0.201  36.743  12.867  1.00 35.67           C  
ATOM   1935  OG  SER B 107      -0.659  35.663  13.641  1.00 39.86           O  
ATOM   1936  N   LYS B 108       2.409  35.203  12.851  1.00 38.68           N  
ATOM   1937  CA  LYS B 108       3.280  34.055  13.104  1.00 40.68           C  
ATOM   1938  C   LYS B 108       4.556  34.439  13.883  1.00 41.16           C  
ATOM   1939  O   LYS B 108       4.895  33.816  14.904  1.00 40.70           O  
ATOM   1940  CB  LYS B 108       3.676  33.416  11.757  1.00 41.20           C  
ATOM   1941  CG  LYS B 108       4.332  32.021  11.863  1.00 43.48           C  
ATOM   1942  CD  LYS B 108       5.549  31.867  10.907  1.00 44.45           C  
ATOM   1943  CE  LYS B 108       5.978  30.390  10.715  1.00 44.83           C  
ATOM   1944  NZ  LYS B 108       7.377  30.264  10.160  1.00 45.30           N  
ATOM   1945  N   HIS B 109       5.242  35.468  13.376  1.00 41.95           N  
ATOM   1946  CA  HIS B 109       6.515  35.954  13.944  1.00 42.49           C  
ATOM   1947  C   HIS B 109       6.299  36.476  15.338  1.00 41.62           C  
ATOM   1948  O   HIS B 109       7.132  36.254  16.215  1.00 41.57           O  
ATOM   1949  CB  HIS B 109       7.147  37.039  13.046  1.00 43.15           C  
ATOM   1950  CG  HIS B 109       7.589  36.514  11.720  1.00 46.82           C  
ATOM   1951  ND1 HIS B 109       8.827  35.936  11.526  1.00 51.88           N  
ATOM   1952  CD2 HIS B 109       6.933  36.402  10.540  1.00 49.36           C  
ATOM   1953  CE1 HIS B 109       8.922  35.507  10.279  1.00 51.37           C  
ATOM   1954  NE2 HIS B 109       7.787  35.781   9.657  1.00 50.44           N  
ATOM   1955  N   THR B 110       5.169  37.157  15.535  1.00 41.30           N  
ATOM   1956  CA  THR B 110       4.781  37.713  16.837  1.00 41.28           C  
ATOM   1957  C   THR B 110       4.672  36.610  17.882  1.00 41.40           C  
ATOM   1958  O   THR B 110       4.946  36.829  19.058  1.00 41.05           O  
ATOM   1959  CB  THR B 110       3.443  38.510  16.760  1.00 41.21           C  
ATOM   1960  OG1 THR B 110       3.589  39.613  15.850  1.00 40.04           O  
ATOM   1961  CG2 THR B 110       3.027  39.024  18.142  1.00 41.28           C  
ATOM   1962  N   ASP B 111       4.328  35.407  17.444  1.00 41.58           N  
ATOM   1963  CA  ASP B 111       4.290  34.288  18.375  1.00 42.31           C  
ATOM   1964  C   ASP B 111       5.667  33.919  18.881  1.00 42.03           C  
ATOM   1965  O   ASP B 111       5.754  33.167  19.842  1.00 41.71           O  
ATOM   1966  CB  ASP B 111       3.612  33.057  17.755  1.00 42.51           C  
ATOM   1967  CG  ASP B 111       2.128  33.254  17.584  1.00 44.23           C  
ATOM   1968  OD1 ASP B 111       1.521  33.958  18.435  1.00 45.73           O  
ATOM   1969  OD2 ASP B 111       1.570  32.722  16.604  1.00 45.73           O  
ATOM   1970  N   TRP B 112       6.727  34.436  18.246  1.00 41.87           N  
ATOM   1971  CA  TRP B 112       8.100  34.115  18.646  1.00 41.63           C  
ATOM   1972  C   TRP B 112       8.756  35.113  19.622  1.00 40.92           C  
ATOM   1973  O   TRP B 112       9.871  34.852  20.077  1.00 40.68           O  
ATOM   1974  CB  TRP B 112       9.000  33.892  17.427  1.00 42.21           C  
ATOM   1975  CG  TRP B 112       8.440  32.917  16.432  1.00 43.02           C  
ATOM   1976  CD1 TRP B 112       7.525  31.920  16.659  1.00 43.70           C  
ATOM   1977  CD2 TRP B 112       8.762  32.850  15.043  1.00 44.52           C  
ATOM   1978  NE1 TRP B 112       7.248  31.252  15.493  1.00 43.63           N  
ATOM   1979  CE2 TRP B 112       7.997  31.802  14.485  1.00 44.09           C  
ATOM   1980  CE3 TRP B 112       9.607  33.596  14.205  1.00 44.33           C  
ATOM   1981  CZ2 TRP B 112       8.078  31.457  13.129  1.00 44.33           C  
ATOM   1982  CZ3 TRP B 112       9.682  33.262  12.857  1.00 43.35           C  
ATOM   1983  CH2 TRP B 112       8.920  32.204  12.332  1.00 44.07           C  
ATOM   1984  N   TRP B 113       8.076  36.211  19.971  1.00 39.34           N  
ATOM   1985  CA  TRP B 113       8.571  37.112  21.036  1.00 38.50           C  
ATOM   1986  C   TRP B 113       7.526  37.510  22.070  1.00 38.02           C  
ATOM   1987  O   TRP B 113       7.887  37.853  23.191  1.00 36.71           O  
ATOM   1988  CB  TRP B 113       9.183  38.404  20.439  1.00 37.50           C  
ATOM   1989  CG  TRP B 113       8.238  39.160  19.550  1.00 37.36           C  
ATOM   1990  CD1 TRP B 113       8.154  39.079  18.192  1.00 36.72           C  
ATOM   1991  CD2 TRP B 113       7.249  40.127  19.955  1.00 36.12           C  
ATOM   1992  NE1 TRP B 113       7.183  39.923  17.722  1.00 36.44           N  
ATOM   1993  CE2 TRP B 113       6.602  40.573  18.780  1.00 37.10           C  
ATOM   1994  CE3 TRP B 113       6.860  40.667  21.192  1.00 36.76           C  
ATOM   1995  CZ2 TRP B 113       5.579  41.527  18.804  1.00 36.24           C  
ATOM   1996  CZ3 TRP B 113       5.843  41.608  21.219  1.00 37.02           C  
ATOM   1997  CH2 TRP B 113       5.198  42.013  20.034  1.00 36.95           C  
ATOM   1998  N   GLU B 114       6.250  37.526  21.671  1.00 38.35           N  
ATOM   1999  CA  GLU B 114       5.160  37.990  22.548  1.00 39.07           C  
ATOM   2000  C   GLU B 114       5.051  37.141  23.834  1.00 39.21           C  
ATOM   2001  O   GLU B 114       4.783  35.939  23.756  1.00 38.57           O  
ATOM   2002  CB  GLU B 114       3.835  37.949  21.775  1.00 39.48           C  
ATOM   2003  CG  GLU B 114       2.622  38.494  22.511  1.00 41.57           C  
ATOM   2004  CD  GLU B 114       1.337  38.023  21.837  1.00 46.27           C  
ATOM   2005  OE1 GLU B 114       0.896  38.658  20.845  1.00 47.00           O  
ATOM   2006  OE2 GLU B 114       0.797  36.977  22.279  1.00 49.40           O  
ATOM   2007  N   PRO B 115       5.235  37.765  25.017  1.00 39.27           N  
ATOM   2008  CA  PRO B 115       5.120  36.971  26.243  1.00 40.06           C  
ATOM   2009  C   PRO B 115       3.674  36.531  26.501  1.00 40.59           C  
ATOM   2010  O   PRO B 115       2.733  37.341  26.423  1.00 39.93           O  
ATOM   2011  CB  PRO B 115       5.618  37.919  27.346  1.00 39.84           C  
ATOM   2012  CG  PRO B 115       6.209  39.111  26.618  1.00 40.13           C  
ATOM   2013  CD  PRO B 115       5.535  39.179  25.306  1.00 39.95           C  
ATOM   2014  N   GLY B 116       3.502  35.248  26.781  1.00 41.81           N  
ATOM   2015  CA  GLY B 116       2.183  34.718  27.144  1.00 42.86           C  
ATOM   2016  C   GLY B 116       1.747  35.213  28.509  1.00 43.55           C  
ATOM   2017  O   GLY B 116       2.580  35.681  29.291  1.00 43.78           O  
ATOM   2018  N   ALA B 117       0.441  35.121  28.782  1.00 44.40           N  
ATOM   2019  CA  ALA B 117      -0.101  35.366  30.129  1.00 44.85           C  
ATOM   2020  C   ALA B 117       0.417  34.282  31.084  1.00 45.28           C  
ATOM   2021  O   ALA B 117       0.445  33.110  30.722  1.00 45.06           O  
ATOM   2022  CB  ALA B 117      -1.641  35.413  30.110  1.00 44.74           C  
ATOM   2023  N   LEU B 118       0.846  34.702  32.280  1.00 46.07           N  
ATOM   2024  CA  LEU B 118       1.543  33.850  33.269  1.00 46.30           C  
ATOM   2025  C   LEU B 118       2.537  32.834  32.662  1.00 46.48           C  
ATOM   2026  O   LEU B 118       3.341  33.161  31.777  1.00 47.05           O  
ATOM   2027  CB  LEU B 118       0.534  33.115  34.166  1.00 46.35           C  
ATOM   2028  CG  LEU B 118      -0.244  33.840  35.267  1.00 46.46           C  
ATOM   2029  CD1 LEU B 118      -1.379  34.688  34.675  1.00 47.32           C  
ATOM   2030  CD2 LEU B 118      -0.802  32.833  36.289  1.00 46.32           C  
ATOM   2031  N   SER B 128      -4.012  41.457  18.102  1.00 60.42           N  
ATOM   2032  CA  SER B 128      -3.458  42.809  17.970  1.00 58.84           C  
ATOM   2033  C   SER B 128      -4.353  43.867  18.675  1.00 60.98           C  
ATOM   2034  O   SER B 128      -4.598  44.936  18.137  1.00 64.55           O  
ATOM   2035  CB  SER B 128      -3.237  43.145  16.485  1.00 57.75           C  
ATOM   2036  OG  SER B 128      -4.456  43.159  15.746  1.00 48.80           O  
ATOM   2037  N   ALA B 129      -4.870  43.561  19.861  1.00 59.48           N  
ATOM   2038  CA  ALA B 129      -5.643  44.544  20.603  1.00 58.51           C  
ATOM   2039  C   ALA B 129      -4.753  45.341  21.577  1.00 58.40           C  
ATOM   2040  O   ALA B 129      -4.643  46.551  21.412  1.00 61.09           O  
ATOM   2041  CB  ALA B 129      -6.847  43.903  21.312  1.00 58.73           C  
ATOM   2042  N   PRO B 130      -4.071  44.679  22.561  1.00 55.36           N  
ATOM   2043  CA  PRO B 130      -3.246  45.492  23.496  1.00 50.87           C  
ATOM   2044  C   PRO B 130      -1.888  45.827  22.872  1.00 45.59           C  
ATOM   2045  O   PRO B 130      -1.010  46.377  23.541  1.00 45.54           O  
ATOM   2046  CB  PRO B 130      -3.043  44.565  24.689  1.00 50.94           C  
ATOM   2047  CG  PRO B 130      -3.011  43.169  24.062  1.00 55.12           C  
ATOM   2048  CD  PRO B 130      -3.930  43.230  22.827  1.00 56.34           C  
ATOM   2049  N   HIS B 131      -1.748  45.464  21.607  1.00 39.87           N  
ATOM   2050  CA  HIS B 131      -0.546  45.731  20.873  1.00 37.52           C  
ATOM   2051  C   HIS B 131      -0.503  47.163  20.434  1.00 34.37           C  
ATOM   2052  O   HIS B 131      -1.515  47.758  20.061  1.00 32.09           O  
ATOM   2053  CB  HIS B 131      -0.466  44.854  19.641  1.00 38.32           C  
ATOM   2054  CG  HIS B 131      -0.180  43.433  19.954  1.00 40.49           C  
ATOM   2055  ND1 HIS B 131       1.108  42.953  20.061  1.00 43.40           N  
ATOM   2056  CD2 HIS B 131      -1.003  42.400  20.241  1.00 41.64           C  
ATOM   2057  CE1 HIS B 131       1.063  41.671  20.381  1.00 45.61           C  
ATOM   2058  NE2 HIS B 131      -0.207  41.313  20.491  1.00 43.65           N  
ATOM   2059  N   VAL B 132       0.710  47.687  20.433  1.00 31.17           N  
ATOM   2060  CA  VAL B 132       0.976  48.940  19.781  1.00 29.68           C  
ATOM   2061  C   VAL B 132       1.424  48.603  18.362  1.00 28.05           C  
ATOM   2062  O   VAL B 132       2.399  47.870  18.157  1.00 27.12           O  
ATOM   2063  CB  VAL B 132       2.081  49.723  20.502  1.00 28.37           C  
ATOM   2064  CG1 VAL B 132       2.369  50.998  19.740  1.00 29.42           C  
ATOM   2065  CG2 VAL B 132       1.695  49.986  21.913  1.00 29.73           C  
ATOM   2066  N   PHE B 133       0.692  49.119  17.386  1.00 26.32           N  
ATOM   2067  CA  PHE B 133       1.051  48.995  15.975  1.00 24.97           C  
ATOM   2068  C   PHE B 133       1.733  50.295  15.566  1.00 24.68           C  
ATOM   2069  O   PHE B 133       1.299  51.382  15.965  1.00 23.08           O  
ATOM   2070  CB  PHE B 133      -0.246  48.819  15.177  1.00 24.57           C  
ATOM   2071  CG  PHE B 133      -0.071  48.708  13.697  1.00 24.44           C  
ATOM   2072  CD1 PHE B 133       0.964  48.004  13.143  1.00 21.72           C  
ATOM   2073  CD2 PHE B 133      -1.018  49.277  12.853  1.00 24.91           C  
ATOM   2074  CE1 PHE B 133       1.074  47.905  11.801  1.00 24.50           C  
ATOM   2075  CE2 PHE B 133      -0.913  49.176  11.512  1.00 23.53           C  
ATOM   2076  CZ  PHE B 133       0.119  48.479  10.978  1.00 24.82           C  
ATOM   2077  N   PHE B 134       2.803  50.198  14.787  1.00 23.20           N  
ATOM   2078  CA  PHE B 134       3.532  51.393  14.392  1.00 23.97           C  
ATOM   2079  C   PHE B 134       4.282  51.146  13.117  1.00 23.50           C  
ATOM   2080  O   PHE B 134       4.467  49.979  12.690  1.00 24.28           O  
ATOM   2081  CB  PHE B 134       4.478  51.881  15.507  1.00 23.31           C  
ATOM   2082  CG  PHE B 134       5.682  50.990  15.763  1.00 23.33           C  
ATOM   2083  CD1 PHE B 134       5.598  49.938  16.648  1.00 23.93           C  
ATOM   2084  CD2 PHE B 134       6.898  51.199  15.122  1.00 25.15           C  
ATOM   2085  CE1 PHE B 134       6.705  49.110  16.876  1.00 24.28           C  
ATOM   2086  CE2 PHE B 134       8.017  50.384  15.389  1.00 26.21           C  
ATOM   2087  CZ  PHE B 134       7.917  49.346  16.239  1.00 23.57           C  
ATOM   2088  N   ARG B 135       4.732  52.245  12.530  1.00 25.28           N  
ATOM   2089  CA  ARG B 135       5.659  52.177  11.409  1.00 26.04           C  
ATOM   2090  C   ARG B 135       6.845  53.114  11.581  1.00 25.81           C  
ATOM   2091  O   ARG B 135       6.760  54.172  12.210  1.00 25.97           O  
ATOM   2092  CB  ARG B 135       4.972  52.428  10.070  1.00 25.78           C  
ATOM   2093  CG  ARG B 135       4.288  53.745   9.902  1.00 25.38           C  
ATOM   2094  CD  ARG B 135       3.415  53.778   8.640  1.00 26.99           C  
ATOM   2095  NE  ARG B 135       2.952  55.144   8.441  1.00 27.42           N  
ATOM   2096  CZ  ARG B 135       2.072  55.550   7.522  1.00 32.13           C  
ATOM   2097  NH1 ARG B 135       1.500  54.717   6.681  1.00 31.52           N  
ATOM   2098  NH2 ARG B 135       1.733  56.826   7.463  1.00 31.29           N  
ATOM   2099  N   ILE B 136       7.951  52.708  10.981  1.00 25.29           N  
ATOM   2100  CA  ILE B 136       9.095  53.544  10.768  1.00 24.25           C  
ATOM   2101  C   ILE B 136       9.091  54.058   9.331  1.00 25.03           C  
ATOM   2102  O   ILE B 136       9.215  53.279   8.370  1.00 23.91           O  
ATOM   2103  CB  ILE B 136      10.400  52.762  11.026  1.00 24.42           C  
ATOM   2104  CG1 ILE B 136      10.428  52.152  12.428  1.00 24.93           C  
ATOM   2105  CG2 ILE B 136      11.574  53.644  10.825  1.00 23.41           C  
ATOM   2106  CD1 ILE B 136      10.113  53.059  13.610  1.00 24.59           C  
ATOM   2107  N   LEU B 137       8.913  55.365   9.176  1.00 25.20           N  
ATOM   2108  CA  LEU B 137       9.073  56.008   7.871  1.00 26.69           C  
ATOM   2109  C   LEU B 137      10.534  56.120   7.530  1.00 24.45           C  
ATOM   2110  O   LEU B 137      11.333  56.594   8.347  1.00 24.62           O  
ATOM   2111  CB  LEU B 137       8.447  57.377   7.895  1.00 27.01           C  
ATOM   2112  CG  LEU B 137       8.686  58.246   6.676  1.00 32.06           C  
ATOM   2113  CD1 LEU B 137       8.360  57.586   5.296  1.00 33.93           C  
ATOM   2114  CD2 LEU B 137       7.819  59.481   6.874  1.00 36.32           C  
ATOM   2115  N   ILE B 138      10.897  55.604   6.360  1.00 24.55           N  
ATOM   2116  CA  ILE B 138      12.277  55.575   5.908  1.00 24.96           C  
ATOM   2117  C   ILE B 138      12.576  56.942   5.304  1.00 25.87           C  
ATOM   2118  O   ILE B 138      12.055  57.285   4.259  1.00 26.25           O  
ATOM   2119  CB  ILE B 138      12.495  54.438   4.856  1.00 23.88           C  
ATOM   2120  CG1 ILE B 138      12.201  53.087   5.494  1.00 25.66           C  
ATOM   2121  CG2 ILE B 138      13.937  54.473   4.279  1.00 25.99           C  
ATOM   2122  CD1 ILE B 138      12.067  51.920   4.534  1.00 25.36           C  
ATOM   2123  N   GLU B 139      13.404  57.746   5.971  1.00 26.08           N  
ATOM   2124  CA  GLU B 139      13.728  59.060   5.453  1.00 26.49           C  
ATOM   2125  C   GLU B 139      15.058  59.065   4.713  1.00 27.01           C  
ATOM   2126  O   GLU B 139      15.168  59.642   3.636  1.00 27.70           O  
ATOM   2127  CB  GLU B 139      13.699  60.089   6.579  1.00 26.32           C  
ATOM   2128  CG  GLU B 139      12.312  60.132   7.220  1.00 27.49           C  
ATOM   2129  CD  GLU B 139      12.039  61.337   8.057  1.00 29.13           C  
ATOM   2130  OE1 GLU B 139      12.991  62.063   8.403  1.00 27.63           O  
ATOM   2131  OE2 GLU B 139      10.849  61.542   8.362  1.00 28.86           O  
ATOM   2132  N   GLN B 140      16.077  58.465   5.298  1.00 27.07           N  
ATOM   2133  CA  GLN B 140      17.378  58.297   4.623  1.00 26.84           C  
ATOM   2134  C   GLN B 140      17.701  56.809   4.689  1.00 26.51           C  
ATOM   2135  O   GLN B 140      17.293  56.099   5.629  1.00 25.97           O  
ATOM   2136  CB  GLN B 140      18.510  59.075   5.322  1.00 27.13           C  
ATOM   2137  CG  GLN B 140      18.116  60.472   5.826  1.00 30.96           C  
ATOM   2138  CD  GLN B 140      17.827  61.450   4.686  1.00 35.12           C  
ATOM   2139  OE1 GLN B 140      18.326  61.251   3.572  1.00 36.73           O  
ATOM   2140  NE2 GLN B 140      17.038  62.525   4.961  1.00 30.93           N  
ATOM   2141  N   VAL B 141      18.385  56.311   3.678  1.00 26.56           N  
ATOM   2142  CA  VAL B 141      18.778  54.891   3.648  1.00 27.08           C  
ATOM   2143  C   VAL B 141      20.119  54.785   2.949  1.00 26.48           C  
ATOM   2144  O   VAL B 141      20.367  55.488   1.971  1.00 25.69           O  
ATOM   2145  CB  VAL B 141      17.698  53.978   2.984  1.00 27.89           C  
ATOM   2146  CG1 VAL B 141      17.479  54.310   1.590  1.00 29.67           C  
ATOM   2147  CG2 VAL B 141      18.094  52.468   3.071  1.00 27.50           C  
ATOM   2148  N   SER B 142      20.995  53.956   3.501  1.00 26.47           N  
ATOM   2149  CA  SER B 142      22.286  53.643   2.934  1.00 27.07           C  
ATOM   2150  C   SER B 142      22.494  52.139   3.018  1.00 26.56           C  
ATOM   2151  O   SER B 142      21.854  51.460   3.822  1.00 25.30           O  
ATOM   2152  CB  SER B 142      23.414  54.341   3.691  1.00 27.75           C  
ATOM   2153  OG  SER B 142      23.453  53.824   5.026  1.00 31.92           O  
ATOM   2154  N   GLY B 143      23.380  51.636   2.167  1.00 25.29           N  
ATOM   2155  CA  GLY B 143      23.641  50.201   2.064  1.00 25.86           C  
ATOM   2156  C   GLY B 143      25.118  49.942   1.812  1.00 25.69           C  
ATOM   2157  O   GLY B 143      25.812  50.770   1.223  1.00 26.02           O  
ATOM   2158  N   ARG B 144      25.589  48.786   2.274  1.00 25.77           N  
ATOM   2159  CA  ARG B 144      26.936  48.313   2.044  1.00 26.62           C  
ATOM   2160  C   ARG B 144      26.902  46.847   1.667  1.00 26.63           C  
ATOM   2161  O   ARG B 144      26.095  46.103   2.184  1.00 24.57           O  
ATOM   2162  CB  ARG B 144      27.800  48.383   3.307  1.00 27.65           C  
ATOM   2163  CG  ARG B 144      28.108  49.762   3.837  1.00 31.23           C  
ATOM   2164  CD  ARG B 144      29.171  50.410   3.011  1.00 34.16           C  
ATOM   2165  NE  ARG B 144      29.432  51.801   3.398  1.00 36.40           N  
ATOM   2166  CZ  ARG B 144      30.385  52.195   4.238  1.00 38.33           C  
ATOM   2167  NH1 ARG B 144      31.213  51.327   4.814  1.00 40.51           N  
ATOM   2168  NH2 ARG B 144      30.540  53.486   4.475  1.00 39.30           N  
ATOM   2169  N   GLU B 145      27.819  46.418   0.809  1.00 25.72           N  
ATOM   2170  CA  GLU B 145      27.998  44.997   0.556  1.00 27.21           C  
ATOM   2171  C   GLU B 145      29.480  44.645   0.626  1.00 27.50           C  
ATOM   2172  O   GLU B 145      30.286  45.370   0.097  1.00 26.96           O  
ATOM   2173  CB  GLU B 145      27.485  44.606  -0.825  1.00 27.92           C  
ATOM   2174  CG  GLU B 145      27.725  43.125  -1.132  1.00 32.23           C  
ATOM   2175  CD  GLU B 145      27.557  42.773  -2.564  1.00 37.60           C  
ATOM   2176  OE1 GLU B 145      26.419  42.875  -3.049  1.00 40.58           O  
ATOM   2177  OE2 GLU B 145      28.572  42.397  -3.223  1.00 44.09           O  
ATOM   2178  N   ALA B 146      29.803  43.555   1.308  1.00 28.31           N  
ATOM   2179  CA  ALA B 146      31.107  42.907   1.261  1.00 29.73           C  
ATOM   2180  C   ALA B 146      31.034  41.702   0.335  1.00 30.62           C  
ATOM   2181  O   ALA B 146      30.170  40.837   0.512  1.00 30.95           O  
ATOM   2182  CB  ALA B 146      31.515  42.429   2.654  1.00 29.89           C  
ATOM   2183  N   SER B 147      31.921  41.655  -0.648  1.00 31.84           N  
ATOM   2184  CA  SER B 147      32.162  40.447  -1.472  1.00 32.99           C  
ATOM   2185  C   SER B 147      33.456  39.766  -1.025  1.00 33.33           C  
ATOM   2186  O   SER B 147      33.952  38.853  -1.689  1.00 34.32           O  
ATOM   2187  CB  SER B 147      32.300  40.813  -2.953  1.00 33.33           C  
ATOM   2188  OG  SER B 147      31.274  41.703  -3.354  1.00 35.46           O  
TER    2189      SER B 147                                                      
END
MOLECULE T0506_25_173.pdb
ATOM     78  N   GLU    25      24.099  47.813  -7.832  1.00 47.53           N  
ATOM     79  CA  GLU    25      23.428  49.088  -8.068  1.00 46.43           C  
ATOM     80  C   GLU    25      22.710  49.488  -6.817  1.00 44.86           C  
ATOM     81  O   GLU    25      21.685  48.901  -6.451  1.00 45.13           O  
ATOM     82  CB  GLU    25      22.471  49.047  -9.256  1.00 47.06           C  
ATOM     83  CG  GLU    25      22.225  50.443  -9.881  1.00 47.24           C  
ATOM     84  CD  GLU    25      21.172  51.248  -9.119  1.00 46.10           C  
ATOM     85  OE1 GLU    25      21.561  52.100  -8.295  1.00 45.74           O  
ATOM     86  OE2 GLU    25      19.958  51.022  -9.342  1.00 44.94           O  
ATOM     87  N   ALA    26      23.264  50.509  -6.181  1.00 43.10           N  
ATOM     88  CA  ALA    26      22.889  50.896  -4.846  1.00 42.10           C  
ATOM     89  C   ALA    26      21.383  50.862  -4.620  1.00 41.22           C  
ATOM     90  O   ALA    26      20.938  50.241  -3.667  1.00 41.52           O  
ATOM     91  CB  ALA    26      23.459  52.259  -4.514  1.00 42.27           C  
ATOM     92  N   VAL    27      20.618  51.503  -5.507  1.00 39.82           N  
ATOM     93  CA  VAL    27      19.170  51.685  -5.330  1.00 38.62           C  
ATOM     94  C   VAL    27      18.441  50.333  -5.389  1.00 38.25           C  
ATOM     95  O   VAL    27      17.627  50.011  -4.527  1.00 38.38           O  
ATOM     96  CB  VAL    27      18.586  52.704  -6.353  1.00 37.58           C  
ATOM     97  CG1 VAL    27      17.069  52.638  -6.404  1.00 37.20           C  
ATOM     98  CG2 VAL    27      19.050  54.113  -6.001  1.00 37.77           C  
ATOM     99  N   ARG    28      18.794  49.533  -6.374  1.00 38.45           N  
ATOM    100  CA  ARG    28      18.189  48.223  -6.565  1.00 39.15           C  
ATOM    101  C   ARG    28      18.541  47.242  -5.432  1.00 38.81           C  
ATOM    102  O   ARG    28      17.647  46.634  -4.831  1.00 39.72           O  
ATOM    103  CB  ARG    28      18.559  47.687  -7.963  1.00 38.85           C  
ATOM    104  CG  ARG    28      18.278  46.216  -8.142  1.00 41.94           C  
ATOM    105  CD  ARG    28      16.816  45.790  -7.837  1.00 45.21           C  
ATOM    106  NE  ARG    28      16.439  44.831  -8.874  1.00 51.01           N  
ATOM    107  CZ  ARG    28      16.676  43.525  -8.835  1.00 49.95           C  
ATOM    108  NH1 ARG    28      17.225  42.961  -7.766  1.00 50.06           N  
ATOM    109  NH2 ARG    28      16.313  42.783  -9.854  1.00 49.70           N  
ATOM    110  N   VAL    29      19.822  47.129  -5.087  1.00 38.22           N  
ATOM    111  CA  VAL    29      20.219  46.316  -3.927  1.00 37.36           C  
ATOM    112  C   VAL    29      19.496  46.775  -2.649  1.00 36.79           C  
ATOM    113  O   VAL    29      19.018  45.955  -1.848  1.00 36.89           O  
ATOM    114  CB  VAL    29      21.772  46.348  -3.708  1.00 37.56           C  
ATOM    115  CG1 VAL    29      22.144  45.746  -2.370  1.00 37.50           C  
ATOM    116  CG2 VAL    29      22.494  45.612  -4.819  1.00 37.85           C  
ATOM    117  N   ALA    30      19.421  48.097  -2.454  1.00 35.35           N  
ATOM    118  CA  ALA    30      18.687  48.682  -1.336  1.00 34.46           C  
ATOM    119  C   ALA    30      17.203  48.317  -1.292  1.00 33.63           C  
ATOM    120  O   ALA    30      16.700  47.953  -0.243  1.00 33.01           O  
ATOM    121  CB  ALA    30      18.851  50.228  -1.333  1.00 33.58           C  
ATOM    122  N   ARG    31      16.515  48.424  -2.422  1.00 32.99           N  
ATOM    123  CA  ARG    31      15.084  48.146  -2.496  1.00 34.07           C  
ATOM    124  C   ARG    31      14.826  46.663  -2.284  1.00 33.95           C  
ATOM    125  O   ARG    31      13.803  46.281  -1.725  1.00 35.51           O  
ATOM    126  CB  ARG    31      14.481  48.670  -3.812  1.00 33.27           C  
ATOM    127  CG  ARG    31      14.226  50.179  -3.744  1.00 34.01           C  
ATOM    128  CD  ARG    31      13.577  50.726  -5.019  1.00 35.99           C  
ATOM    129  NE  ARG    31      12.143  50.433  -5.017  1.00 33.98           N  
ATOM    130  CZ  ARG    31      11.416  50.411  -6.115  1.00 38.90           C  
ATOM    131  NH1 ARG    31      12.005  50.704  -7.262  1.00 31.97           N  
ATOM    132  NH2 ARG    31      10.110  50.128  -6.060  1.00 42.34           N  
ATOM    133  N   ASP    32      15.778  45.838  -2.686  1.00 34.58           N  
ATOM    134  CA  ASP    32      15.679  44.398  -2.466  0.50 35.02           C  
ATOM    136  C   ASP    32      15.826  44.056  -1.006  1.00 34.99           C  
ATOM    137  O   ASP    32      15.045  43.274  -0.480  1.00 35.71           O  
ATOM    138  CB  ASP    32      16.723  43.631  -3.275  0.50 34.91           C  
ATOM    140  CG  ASP    32      16.252  42.240  -3.643  0.50 37.60           C  
ATOM    142  OD1 ASP    32      15.113  42.109  -4.168  0.50 37.96           O  
ATOM    144  OD2 ASP    32      17.027  41.278  -3.431  0.50 39.94           O  
ATOM    146  N   VAL    33      16.799  44.665  -0.335  1.00 35.69           N  
ATOM    147  CA  VAL    33      16.952  44.479   1.129  1.00 35.38           C  
ATOM    148  C   VAL    33      15.725  44.991   1.852  1.00 36.91           C  
ATOM    149  O   VAL    33      15.266  44.403   2.861  1.00 37.01           O  
ATOM    150  CB  VAL    33      18.200  45.234   1.681  1.00 35.08           C  
ATOM    151  CG1 VAL    33      18.291  45.100   3.203  1.00 35.22           C  
ATOM    152  CG2 VAL    33      19.474  44.688   1.037  1.00 33.53           C  
ATOM    153  N   LEU    34      15.223  46.132   1.383  1.00 36.92           N  
ATOM    154  CA  LEU    34      14.044  46.713   1.963  1.00 37.55           C  
ATOM    155  C   LEU    34      12.872  45.725   1.973  1.00 37.09           C  
ATOM    156  O   LEU    34      12.183  45.569   3.011  1.00 37.29           O  
ATOM    157  CB  LEU    34      13.635  47.981   1.239  1.00 37.10           C  
ATOM    158  CG  LEU    34      12.325  48.656   1.652  1.00 36.56           C  
ATOM    159  CD1 LEU    34      12.382  49.294   3.019  1.00 35.33           C  
ATOM    160  CD2 LEU    34      12.021  49.705   0.548  1.00 33.63           C  
ATOM    161  N   HIS    35      12.674  45.055   0.852  1.00 36.94           N  
ATOM    162  CA  HIS    35      11.488  44.235   0.692  1.00 37.17           C  
ATOM    163  C   HIS    35      11.613  42.812   1.221  1.00 37.43           C  
ATOM    164  O   HIS    35      10.598  42.106   1.372  1.00 36.36           O  
ATOM    165  CB  HIS    35      11.031  44.238  -0.765  1.00 36.90           C  
ATOM    166  CG  HIS    35      10.298  45.502  -1.165  1.00 37.86           C  
ATOM    167  ND1 HIS    35       8.920  45.593  -1.165  1.00 38.07           N  
ATOM    168  CD2 HIS    35      10.751  46.717  -1.569  1.00 36.41           C  
ATOM    169  CE1 HIS    35       8.553  46.819  -1.526  1.00 36.43           C  
ATOM    170  NE2 HIS    35       9.647  47.517  -1.784  1.00 36.29           N  
ATOM    171  N   THR    36      12.843  42.372   1.438  1.00 36.97           N  
ATOM    172  CA  THR    36      13.079  40.969   1.718  1.00 37.62           C  
ATOM    173  C   THR    36      13.741  40.752   3.075  1.00 38.16           C  
ATOM    174  O   THR    36      14.194  39.635   3.373  1.00 38.65           O  
ATOM    175  CB  THR    36      13.897  40.253   0.588  1.00 39.04           C  
ATOM    176  OG1 THR    36      15.189  40.884   0.435  1.00 37.71           O  
ATOM    177  CG2 THR    36      13.146  40.274  -0.759  1.00 37.27           C  
ATOM    178  N   SER    37      13.811  41.788   3.890  1.00 37.79           N  
ATOM    179  CA  SER    37      14.363  41.613   5.263  1.00 39.48           C  
ATOM    180  C   SER    37      13.260  41.475   6.314  1.00 38.86           C  
ATOM    181  O   SER    37      12.412  42.358   6.422  1.00 38.51           O  
ATOM    182  CB  SER    37      15.345  42.762   5.618  1.00 38.38           C  
ATOM    183  OG  SER    37      16.371  42.838   4.608  1.00 41.05           O  
ATOM    184  N   ARG    38      13.268  40.369   7.076  1.00 39.77           N  
ATOM    185  CA  ARG    38      12.327  40.179   8.211  1.00 41.34           C  
ATOM    186  C   ARG    38      12.758  40.914   9.477  1.00 42.43           C  
ATOM    187  O   ARG    38      11.968  41.608  10.100  1.00 42.17           O  
ATOM    188  CB  ARG    38      12.100  38.691   8.578  1.00 41.21           C  
ATOM    189  CG  ARG    38      10.919  38.002   7.837  1.00 42.35           C  
ATOM    190  CD  ARG    38      10.623  36.515   8.413  1.00 44.16           C  
ATOM    191  NE  ARG    38       9.250  36.088   8.125  1.00 48.27           N  
ATOM    192  CZ  ARG    38       8.909  35.290   7.123  1.00 48.91           C  
ATOM    193  NH1 ARG    38       7.635  34.955   6.942  1.00 48.62           N  
ATOM    194  NH2 ARG    38       9.846  34.775   6.322  1.00 51.54           N  
ATOM    195  N   THR    39      14.015  40.742   9.867  1.00 43.04           N  
ATOM    196  CA  THR    39      14.487  41.282  11.126  1.00 43.56           C  
ATOM    197  C   THR    39      15.269  42.567  10.903  1.00 43.75           C  
ATOM    198  O   THR    39      16.001  42.696   9.921  1.00 43.67           O  
ATOM    199  CB  THR    39      15.318  40.257  11.910  1.00 43.91           C  
ATOM    200  OG1 THR    39      14.552  39.053  12.056  1.00 45.50           O  
ATOM    201  CG2 THR    39      15.640  40.777  13.315  1.00 44.70           C  
ATOM    202  N   ALA    40      15.033  43.524  11.799  1.00 41.52           N  
ATOM    203  CA  ALA    40      15.651  44.828  11.787  1.00 40.98           C  
ATOM    204  C   ALA    40      16.237  45.164  13.169  1.00 40.63           C  
ATOM    205  O   ALA    40      15.643  44.853  14.180  1.00 40.12           O  
ATOM    206  CB  ALA    40      14.604  45.873  11.432  1.00 41.19           C  
ATOM    207  N   ALA    41      17.418  45.765  13.177  1.00 39.80           N  
ATOM    208  CA  ALA    41      17.920  46.465  14.324  1.00 38.78           C  
ATOM    209  C   ALA    41      17.158  47.790  14.407  1.00 39.25           C  
ATOM    210  O   ALA    41      16.861  48.426  13.397  1.00 38.98           O  
ATOM    211  CB  ALA    41      19.416  46.708  14.140  1.00 39.12           C  
ATOM    212  N   LEU    42      16.797  48.193  15.623  1.00 38.68           N  
ATOM    213  CA  LEU    42      16.037  49.406  15.853  1.00 39.79           C  
ATOM    214  C   LEU    42      16.785  50.125  16.957  1.00 39.98           C  
ATOM    215  O   LEU    42      17.011  49.536  18.044  1.00 38.61           O  
ATOM    216  CB  LEU    42      14.655  49.049  16.433  1.00 40.02           C  
ATOM    217  CG  LEU    42      13.458  50.015  16.368  1.00 43.63           C  
ATOM    218  CD1 LEU    42      12.539  49.898  17.612  1.00 42.40           C  
ATOM    219  CD2 LEU    42      13.771  51.474  16.022  1.00 39.93           C  
ATOM    220  N   ALA    43      17.123  51.378  16.688  1.00 38.14           N  
ATOM    221  CA  ALA    43      17.741  52.250  17.656  1.00 38.67           C  
ATOM    222  C   ALA    43      16.827  53.423  17.999  1.00 39.37           C  
ATOM    223  O   ALA    43      16.177  54.035  17.134  1.00 40.23           O  
ATOM    224  CB  ALA    43      19.111  52.747  17.153  1.00 38.06           C  
ATOM    225  N   THR    44      16.877  53.783  19.273  1.00 39.46           N  
ATOM    226  CA  THR    44      15.964  54.691  19.898  1.00 38.96           C  
ATOM    227  C   THR    44      16.884  55.530  20.822  1.00 38.63           C  
ATOM    228  O   THR    44      18.054  55.168  21.043  1.00 38.06           O  
ATOM    229  CB  THR    44      14.985  53.702  20.568  1.00 40.23           C  
ATOM    230  OG1 THR    44      13.679  53.682  19.961  1.00 45.89           O  
ATOM    231  CG2 THR    44      15.079  53.504  22.014  1.00 33.78           C  
ATOM    232  N   LEU    45      16.389  56.659  21.328  1.00 38.88           N  
ATOM    233  CA  LEU    45      17.207  57.508  22.210  1.00 38.18           C  
ATOM    234  C   LEU    45      16.689  57.522  23.642  1.00 38.60           C  
ATOM    235  O   LEU    45      15.488  57.696  23.887  1.00 39.08           O  
ATOM    236  CB  LEU    45      17.306  58.953  21.676  1.00 38.20           C  
ATOM    237  CG  LEU    45      17.965  59.257  20.311  1.00 38.94           C  
ATOM    238  CD1 LEU    45      17.732  60.739  19.933  1.00 35.37           C  
ATOM    239  CD2 LEU    45      19.475  58.944  20.302  1.00 34.51           C  
ATOM    240  N   ASP    46      17.602  57.365  24.594  1.00 38.81           N  
ATOM    241  CA  ASP    46      17.234  57.458  25.978  1.00 38.11           C  
ATOM    242  C   ASP    46      16.965  58.919  26.355  1.00 38.82           C  
ATOM    243  O   ASP    46      17.782  59.804  26.077  1.00 39.17           O  
ATOM    244  CB  ASP    46      18.269  56.823  26.873  1.00 37.52           C  
ATOM    245  CG  ASP    46      17.782  56.687  28.297  1.00 38.27           C  
ATOM    246  OD1 ASP    46      17.801  57.702  29.037  1.00 39.29           O  
ATOM    247  OD2 ASP    46      17.353  55.572  28.670  1.00 39.12           O  
ATOM    248  N   PRO    47      15.793  59.181  26.968  1.00 39.51           N  
ATOM    249  CA  PRO    47      15.406  60.562  27.316  1.00 39.59           C  
ATOM    250  C   PRO    47      16.261  61.296  28.350  1.00 39.85           C  
ATOM    251  O   PRO    47      16.218  62.528  28.393  1.00 41.11           O  
ATOM    252  CB  PRO    47      13.972  60.421  27.810  1.00 39.48           C  
ATOM    253  CG  PRO    47      13.786  59.014  28.136  1.00 39.84           C  
ATOM    254  CD  PRO    47      14.738  58.210  27.302  1.00 39.29           C  
ATOM    255  N   VAL    48      16.978  60.575  29.215  1.00 39.58           N  
ATOM    256  CA  VAL    48      17.764  61.207  30.288  1.00 38.34           C  
ATOM    257  C   VAL    48      19.253  61.154  29.955  1.00 37.75           C  
ATOM    258  O   VAL    48      19.960  62.160  30.031  1.00 36.21           O  
ATOM    259  CB  VAL    48      17.522  60.535  31.703  1.00 38.53           C  
ATOM    260  CG1 VAL    48      18.371  61.189  32.800  1.00 38.22           C  
ATOM    261  CG2 VAL    48      16.045  60.571  32.106  1.00 38.99           C  
ATOM    262  N   SER    49      19.719  59.969  29.570  1.00 37.22           N  
ATOM    263  CA  SER    49      21.152  59.725  29.436  1.00 37.08           C  
ATOM    264  C   SER    49      21.684  60.192  28.093  1.00 37.18           C  
ATOM    265  O   SER    49      22.841  60.545  27.976  1.00 37.79           O  
ATOM    266  CB  SER    49      21.474  58.250  29.669  1.00 37.19           C  
ATOM    267  OG  SER    49      20.872  57.441  28.663  1.00 35.06           O  
ATOM    268  N   GLY    50      20.835  60.174  27.079  1.00 38.39           N  
ATOM    269  CA  GLY    50      21.214  60.622  25.742  1.00 38.15           C  
ATOM    270  C   GLY    50      21.913  59.521  24.969  1.00 36.98           C  
ATOM    271  O   GLY    50      22.166  59.670  23.775  1.00 37.41           O  
ATOM    272  N   TYR    51      22.211  58.412  25.651  1.00 35.98           N  
ATOM    273  CA  TYR    51      22.733  57.203  25.004  1.00 34.74           C  
ATOM    274  C   TYR    51      21.698  56.630  24.013  1.00 34.55           C  
ATOM    275  O   TYR    51      20.453  56.775  24.230  1.00 35.08           O  
ATOM    276  CB  TYR    51      23.047  56.109  26.039  1.00 33.87           C  
ATOM    277  CG  TYR    51      24.321  56.276  26.852  1.00 33.36           C  
ATOM    278  CD1 TYR    51      25.393  55.409  26.676  1.00 32.99           C  
ATOM    279  CD2 TYR    51      24.442  57.298  27.780  1.00 33.00           C  
ATOM    280  CE1 TYR    51      26.558  55.551  27.429  1.00 34.11           C  
ATOM    281  CE2 TYR    51      25.600  57.456  28.550  1.00 35.12           C  
ATOM    282  CZ  TYR    51      26.653  56.575  28.352  1.00 34.84           C  
ATOM    283  OH  TYR    51      27.786  56.715  29.074  1.00 32.74           O  
ATOM    284  N   PRO    52      22.191  55.951  22.950  1.00 34.99           N  
ATOM    285  CA  PRO    52      21.241  55.231  22.109  1.00 34.67           C  
ATOM    286  C   PRO    52      20.776  53.982  22.843  1.00 35.35           C  
ATOM    287  O   PRO    52      21.419  53.563  23.835  1.00 34.36           O  
ATOM    288  CB  PRO    52      22.052  54.874  20.842  1.00 35.16           C  
ATOM    289  CG  PRO    52      23.495  54.940  21.259  1.00 34.77           C  
ATOM    290  CD  PRO    52      23.602  55.799  22.497  1.00 34.82           C  
ATOM    291  N   TYR    53      19.673  53.403  22.378  1.00 35.86           N  
ATOM    292  CA  TYR    53      19.173  52.180  22.965  1.00 36.96           C  
ATOM    293  C   TYR    53      18.667  51.328  21.811  1.00 36.80           C  
ATOM    294  O   TYR    53      17.880  51.791  21.003  1.00 37.91           O  
ATOM    295  CB  TYR    53      18.040  52.462  24.003  1.00 36.72           C  
ATOM    296  CG  TYR    53      17.422  51.187  24.528  1.00 38.05           C  
ATOM    297  CD1 TYR    53      17.975  50.523  25.627  1.00 38.59           C  
ATOM    298  CD2 TYR    53      16.305  50.606  23.893  1.00 37.83           C  
ATOM    299  CE1 TYR    53      17.424  49.341  26.105  1.00 39.91           C  
ATOM    300  CE2 TYR    53      15.747  49.416  24.370  1.00 39.19           C  
ATOM    301  CZ  TYR    53      16.310  48.792  25.458  1.00 38.48           C  
ATOM    302  OH  TYR    53      15.774  47.610  25.907  1.00 40.55           O  
ATOM    303  N   THR    54      19.131  50.080  21.734  1.00 37.35           N  
ATOM    304  CA  THR    54      18.820  49.210  20.616  1.00 36.80           C  
ATOM    305  C   THR    54      17.924  48.044  20.993  1.00 37.74           C  
ATOM    306  O   THR    54      17.930  47.569  22.152  1.00 37.88           O  
ATOM    307  CB  THR    54      20.095  48.663  19.947  1.00 37.33           C  
ATOM    308  OG1 THR    54      20.944  48.083  20.945  1.00 36.66           O  
ATOM    309  CG2 THR    54      20.831  49.750  19.249  1.00 37.47           C  
ATOM    310  N   THR    55      17.168  47.563  20.005  1.00 37.99           N  
ATOM    311  CA  THR    55      16.482  46.258  20.101  1.00 38.74           C  
ATOM    312  C   THR    55      16.468  45.581  18.733  1.00 38.58           C  
ATOM    313  O   THR    55      16.991  46.145  17.767  1.00 38.75           O  
ATOM    314  CB  THR    55      15.031  46.362  20.760  1.00 39.15           C  
ATOM    315  OG1 THR    55      14.547  45.043  21.053  1.00 42.34           O  
ATOM    316  CG2 THR    55      14.021  47.094  19.861  1.00 37.54           C  
ATOM    317  N   ALA    56      15.919  44.370  18.666  1.00 37.63           N  
ATOM    318  CA  ALA    56      15.601  43.697  17.415  1.00 38.20           C  
ATOM    319  C   ALA    56      14.083  43.590  17.259  1.00 38.64           C  
ATOM    320  O   ALA    56      13.374  43.290  18.226  1.00 38.50           O  
ATOM    321  CB  ALA    56      16.243  42.301  17.344  1.00 37.34           C  
ATOM    322  N   THR    57      13.593  43.808  16.043  1.00 38.00           N  
ATOM    323  CA  THR    57      12.144  43.750  15.804  1.00 39.69           C  
ATOM    324  C   THR    57      11.844  43.200  14.405  1.00 40.17           C  
ATOM    325  O   THR    57      12.767  43.030  13.611  1.00 39.47           O  
ATOM    326  CB  THR    57      11.479  45.144  16.054  1.00 39.51           C  
ATOM    327  OG1 THR    57      10.075  44.982  16.284  1.00 42.44           O  
ATOM    328  CG2 THR    57      11.769  46.175  14.922  1.00 37.64           C  
ATOM    329  N   ASN    58      10.569  42.905  14.141  1.00 39.45           N  
ATOM    330  CA  ASN    58      10.140  42.384  12.852  1.00 40.47           C  
ATOM    331  C   ASN    58       9.653  43.550  11.984  1.00 39.86           C  
ATOM    332  O   ASN    58       8.995  44.471  12.473  1.00 39.32           O  
ATOM    333  CB  ASN    58       8.964  41.419  13.043  1.00 39.87           C  
ATOM    334  CG  ASN    58       9.261  40.264  13.997  1.00 42.71           C  
ATOM    335  OD1 ASN    58      10.325  39.625  13.945  1.00 43.20           O  
ATOM    336  ND2 ASN    58       8.253  39.910  14.811  1.00 41.63           N  
ATOM    337  N   ILE    59       9.872  43.453  10.689  1.00 40.97           N  
ATOM    338  CA  ILE    59       9.529  44.518   9.723  1.00 41.64           C  
ATOM    339  C   ILE    59       8.358  44.133   8.821  1.00 42.78           C  
ATOM    340  O   ILE    59       8.394  43.067   8.117  1.00 41.24           O  
ATOM    341  CB  ILE    59      10.792  44.815   8.837  1.00 41.35           C  
ATOM    342  CG1 ILE    59      11.835  45.573   9.675  1.00 42.44           C  
ATOM    343  CG2 ILE    59      10.454  45.666   7.603  1.00 44.65           C  
ATOM    344  CD1 ILE    59      11.346  46.945  10.221  1.00 39.10           C  
ATOM    345  N   GLY    60       7.314  44.975   8.847  1.00 43.54           N  
ATOM    346  CA  GLY    60       6.265  44.917   7.809  1.00 43.52           C  
ATOM    347  C   GLY    60       6.563  45.946   6.702  1.00 43.16           C  
ATOM    348  O   GLY    60       7.319  46.877   6.917  1.00 41.80           O  
ATOM    349  N   ILE    61       6.013  45.756   5.504  1.00 42.96           N  
ATOM    350  CA  ILE    61       6.196  46.748   4.436  1.00 44.08           C  
ATOM    351  C   ILE    61       4.826  47.088   3.847  1.00 43.86           C  
ATOM    352  O   ILE    61       4.039  46.184   3.546  1.00 45.44           O  
ATOM    353  CB  ILE    61       7.164  46.288   3.289  1.00 45.00           C  
ATOM    354  CG1 ILE    61       8.525  45.853   3.795  1.00 47.28           C  
ATOM    355  CG2 ILE    61       7.534  47.453   2.427  1.00 44.58           C  
ATOM    356  CD1 ILE    61       9.499  47.050   4.107  1.00 51.63           C  
ATOM    357  N   GLU    62       4.548  48.376   3.660  1.00 41.87           N  
ATOM    358  CA  GLU    62       3.316  48.797   3.016  1.00 41.07           C  
ATOM    359  C   GLU    62       3.499  48.862   1.468  1.00 41.15           C  
ATOM    360  O   GLU    62       4.639  48.887   0.990  1.00 41.34           O  
ATOM    361  CB  GLU    62       2.863  50.132   3.623  1.00 39.56           C  
ATOM    362  CG  GLU    62       2.863  50.081   5.181  1.00 39.44           C  
ATOM    363  CD  GLU    62       2.347  51.371   5.819  1.00 42.98           C  
ATOM    364  OE1 GLU    62       1.600  51.268   6.823  1.00 43.58           O  
ATOM    365  OE2 GLU    62       2.685  52.470   5.299  1.00 39.51           O  
ATOM    366  N   PRO    63       2.390  48.847   0.695  1.00 40.53           N  
ATOM    367  CA  PRO    63       2.460  48.832  -0.787  1.00 40.41           C  
ATOM    368  C   PRO    63       3.454  49.832  -1.394  1.00 39.89           C  
ATOM    369  O   PRO    63       4.140  49.476  -2.317  1.00 40.56           O  
ATOM    370  CB  PRO    63       1.033  49.157  -1.198  1.00 39.57           C  
ATOM    371  CG  PRO    63       0.213  48.552  -0.087  1.00 40.59           C  
ATOM    372  CD  PRO    63       0.995  48.773   1.160  1.00 40.41           C  
ATOM    373  N   ASP    64       3.560  51.048  -0.853  1.00 40.36           N  
ATOM    374  CA  ASP    64       4.530  52.054  -1.340  1.00 40.96           C  
ATOM    375  C   ASP    64       5.987  51.837  -0.852  1.00 41.65           C  
ATOM    376  O   ASP    64       6.844  52.696  -1.079  1.00 43.12           O  
ATOM    377  CB  ASP    64       4.066  53.493  -1.017  1.00 39.69           C  
ATOM    378  CG  ASP    64       4.138  53.809   0.465  1.00 40.09           C  
ATOM    379  OD1 ASP    64       3.820  54.926   0.865  1.00 40.33           O  
ATOM    380  OD2 ASP    64       4.498  52.913   1.241  1.00 36.40           O  
ATOM    381  N   GLY    65       6.228  50.735  -0.150  1.00 42.72           N  
ATOM    382  CA  GLY    65       7.554  50.370   0.345  1.00 44.04           C  
ATOM    383  C   GLY    65       7.891  50.838   1.747  1.00 44.29           C  
ATOM    384  O   GLY    65       8.999  50.566   2.222  1.00 45.96           O  
ATOM    385  N   THR    66       6.937  51.499   2.422  1.00 42.92           N  
ATOM    386  CA  THR    66       7.145  52.061   3.760  1.00 40.94           C  
ATOM    387  C   THR    66       7.233  50.965   4.834  1.00 40.64           C  
ATOM    388  O   THR    66       6.277  50.188   4.993  1.00 39.14           O  
ATOM    389  CB  THR    66       6.021  53.044   4.171  1.00 40.87           C  
ATOM    390  OG1 THR    66       5.955  54.140   3.252  1.00 40.45           O  
ATOM    391  CG2 THR    66       6.306  53.607   5.551  1.00 39.21           C  
ATOM    392  N   PRO    67       8.368  50.910   5.573  1.00 40.41           N  
ATOM    393  CA  PRO    67       8.465  49.942   6.647  1.00 41.38           C  
ATOM    394  C   PRO    67       7.598  50.307   7.843  1.00 41.41           C  
ATOM    395  O   PRO    67       7.431  51.490   8.173  1.00 40.86           O  
ATOM    396  CB  PRO    67       9.946  49.979   7.045  1.00 41.94           C  
ATOM    397  CG  PRO    67      10.638  50.775   6.040  1.00 41.43           C  
ATOM    398  CD  PRO    67       9.595  51.719   5.491  1.00 40.36           C  
ATOM    399  N   PHE    68       7.052  49.277   8.506  1.00 40.81           N  
ATOM    400  CA  PHE    68       6.285  49.530   9.723  1.00 39.59           C  
ATOM    401  C   PHE    68       6.606  48.413  10.691  1.00 39.37           C  
ATOM    402  O   PHE    68       7.122  47.356  10.315  1.00 38.92           O  
ATOM    403  CB  PHE    68       4.757  49.696   9.440  1.00 38.61           C  
ATOM    404  CG  PHE    68       4.008  48.388   9.182  1.00 38.40           C  
ATOM    405  CD1 PHE    68       3.373  47.706  10.228  1.00 39.53           C  
ATOM    406  CD2 PHE    68       3.910  47.857   7.890  1.00 37.81           C  
ATOM    407  CE1 PHE    68       2.642  46.505   9.975  1.00 40.30           C  
ATOM    408  CE2 PHE    68       3.216  46.680   7.637  1.00 39.43           C  
ATOM    409  CZ  PHE    68       2.582  45.996   8.692  1.00 40.88           C  
ATOM    410  N   PHE    69       6.294  48.640  11.947  1.00 39.54           N  
ATOM    411  CA  PHE    69       6.642  47.671  12.957  1.00 39.34           C  
ATOM    412  C   PHE    69       5.764  47.887  14.204  1.00 38.68           C  
ATOM    413  O   PHE    69       5.059  48.905  14.332  1.00 38.42           O  
ATOM    414  CB  PHE    69       8.148  47.734  13.285  1.00 39.39           C  
ATOM    415  CG  PHE    69       8.605  49.071  13.808  1.00 40.13           C  
ATOM    416  CD1 PHE    69       8.609  49.334  15.181  1.00 37.66           C  
ATOM    417  CD2 PHE    69       9.055  50.060  12.934  1.00 40.27           C  
ATOM    418  CE1 PHE    69       9.039  50.590  15.678  1.00 40.43           C  
ATOM    419  CE2 PHE    69       9.487  51.301  13.407  1.00 39.29           C  
ATOM    420  CZ  PHE    69       9.483  51.566  14.796  1.00 42.12           C  
ATOM    421  N   PHE    70       5.835  46.889  15.076  1.00 38.05           N  
ATOM    422  CA  PHE    70       5.076  46.866  16.296  0.50 38.37           C  
ATOM    424  C   PHE    70       6.038  46.859  17.464  1.00 38.87           C  
ATOM    425  O   PHE    70       7.149  46.304  17.360  1.00 38.01           O  
ATOM    426  CB  PHE    70       4.186  45.615  16.328  0.50 38.34           C  
ATOM    428  CG  PHE    70       4.063  44.995  17.679  0.50 37.72           C  
ATOM    430  CD1 PHE    70       3.134  45.471  18.599  0.50 36.50           C  
ATOM    432  CD2 PHE    70       4.879  43.917  18.036  0.50 38.31           C  
ATOM    434  CE1 PHE    70       3.023  44.878  19.863  0.50 37.53           C  
ATOM    436  CE2 PHE    70       4.773  43.321  19.307  0.50 36.98           C  
ATOM    438  CZ  PHE    70       3.851  43.807  20.216  0.50 36.69           C  
ATOM    440  N   ALA    71       5.596  47.458  18.571  1.00 38.29           N  
ATOM    441  CA  ALA    71       6.344  47.406  19.823  1.00 38.96           C  
ATOM    442  C   ALA    71       5.331  47.251  20.949  1.00 39.61           C  
ATOM    443  O   ALA    71       4.312  47.936  20.937  1.00 40.47           O  
ATOM    444  CB  ALA    71       7.151  48.660  20.043  1.00 38.39           C  
ATOM    445  N   ALA    72       5.592  46.345  21.892  1.00 39.98           N  
ATOM    446  CA  ALA    72       4.775  46.269  23.119  1.00 41.01           C  
ATOM    447  C   ALA    72       4.906  47.607  23.852  1.00 41.50           C  
ATOM    448  O   ALA    72       6.005  48.142  23.924  1.00 42.57           O  
ATOM    449  CB  ALA    72       5.262  45.138  23.991  1.00 40.44           C  
ATOM    450  N   GLY    73       3.808  48.150  24.386  1.00 41.80           N  
ATOM    451  CA  GLY    73       3.846  49.469  25.049  1.00 41.25           C  
ATOM    452  C   GLY    73       4.707  49.578  26.305  1.00 41.94           C  
ATOM    453  O   GLY    73       5.268  50.647  26.616  1.00 41.43           O  
ATOM    454  N   LEU    74       4.819  48.486  27.054  1.00 41.99           N  
ATOM    455  CA  LEU    74       5.571  48.544  28.315  1.00 43.68           C  
ATOM    456  C   LEU    74       7.093  48.305  28.146  1.00 43.63           C  
ATOM    457  O   LEU    74       7.759  47.837  29.053  1.00 44.67           O  
ATOM    458  CB  LEU    74       4.930  47.605  29.352  1.00 44.01           C  
ATOM    459  CG  LEU    74       3.413  47.749  29.578  1.00 46.05           C  
ATOM    460  CD1 LEU    74       2.965  46.988  30.851  1.00 49.35           C  
ATOM    461  CD2 LEU    74       2.939  49.230  29.653  1.00 48.89           C  
ATOM    462  N   THR    75       7.626  48.623  26.970  1.00 43.11           N  
ATOM    463  CA  THR    75       9.046  48.418  26.701  1.00 42.65           C  
ATOM    464  C   THR    75       9.824  49.744  26.683  1.00 42.24           C  
ATOM    465  O   THR    75       9.263  50.835  26.438  1.00 41.76           O  
ATOM    466  CB  THR    75       9.306  47.632  25.409  1.00 42.39           C  
ATOM    467  OG1 THR    75       8.924  48.421  24.270  1.00 44.12           O  
ATOM    468  CG2 THR    75       8.570  46.277  25.420  1.00 41.79           C  
ATOM    469  N   LEU    76      11.114  49.633  26.971  1.00 40.77           N  
ATOM    470  CA  LEU    76      12.015  50.766  26.924  1.00 41.14           C  
ATOM    471  C   LEU    76      12.007  51.489  25.574  1.00 40.66           C  
ATOM    472  O   LEU    76      11.944  52.711  25.542  1.00 39.81           O  
ATOM    473  CB  LEU    76      13.425  50.295  27.255  1.00 41.59           C  
ATOM    474  CG  LEU    76      14.009  50.414  28.673  1.00 43.88           C  
ATOM    475  CD1 LEU    76      13.137  51.171  29.678  1.00 45.72           C  
ATOM    476  CD2 LEU    76      14.462  49.068  29.235  1.00 45.24           C  
ATOM    477  N   HIS    77      12.082  50.753  24.458  1.00 39.75           N  
ATOM    478  CA  HIS    77      12.104  51.447  23.167  1.00 39.95           C  
ATOM    479  C   HIS    77      10.777  52.175  22.905  1.00 39.38           C  
ATOM    480  O   HIS    77      10.792  53.307  22.464  1.00 40.18           O  
ATOM    481  CB  HIS    77      12.509  50.543  21.992  1.00 39.44           C  
ATOM    482  CG  HIS    77      11.775  49.241  21.944  1.00 39.43           C  
ATOM    483  ND1 HIS    77      11.884  48.284  22.934  1.00 40.59           N  
ATOM    484  CD2 HIS    77      10.954  48.718  21.004  1.00 41.59           C  
ATOM    485  CE1 HIS    77      11.144  47.235  22.614  1.00 38.83           C  
ATOM    486  NE2 HIS    77      10.565  47.473  21.448  1.00 39.75           N  
ATOM    487  N   ALA    78       9.640  51.531  23.189  1.00 39.56           N  
ATOM    488  CA  ALA    78       8.326  52.206  23.113  1.00 38.93           C  
ATOM    489  C   ALA    78       8.338  53.516  23.887  1.00 38.55           C  
ATOM    490  O   ALA    78       7.962  54.567  23.330  1.00 39.14           O  
ATOM    491  CB  ALA    78       7.207  51.312  23.617  1.00 38.80           C  
ATOM    492  N   ARG    79       8.770  53.448  25.163  1.00 37.66           N  
ATOM    493  CA  ARG    79       8.928  54.611  26.013  1.00 37.31           C  
ATOM    494  C   ARG    79       9.798  55.654  25.329  1.00 37.34           C  
ATOM    495  O   ARG    79       9.412  56.836  25.268  1.00 36.32           O  
ATOM    496  CB  ARG    79       9.554  54.227  27.373  1.00 36.74           C  
ATOM    497  CG  ARG    79       9.456  55.287  28.537  1.00 37.11           C  
ATOM    498  CD  ARG    79      10.594  56.342  28.549  1.00 38.08           C  
ATOM    499  NE  ARG    79      11.916  55.725  28.313  1.00 40.43           N  
ATOM    500  CZ  ARG    79      12.646  55.127  29.241  1.00 38.21           C  
ATOM    501  NH1 ARG    79      12.214  55.069  30.506  1.00 37.01           N  
ATOM    502  NH2 ARG    79      13.817  54.592  28.914  1.00 38.84           N  
ATOM    503  N   ASN    80      10.978  55.233  24.861  1.00 37.06           N  
ATOM    504  CA  ASN    80      11.944  56.179  24.276  1.00 38.46           C  
ATOM    505  C   ASN    80      11.301  56.927  23.122  1.00 39.46           C  
ATOM    506  O   ASN    80      11.364  58.170  23.060  1.00 39.42           O  
ATOM    507  CB  ASN    80      13.239  55.484  23.823  1.00 38.83           C  
ATOM    508  CG  ASN    80      14.083  54.995  24.983  1.00 37.97           C  
ATOM    509  OD1 ASN    80      13.876  55.410  26.113  1.00 38.02           O  
ATOM    510  ND2 ASN    80      15.026  54.079  24.712  1.00 33.92           N  
ATOM    511  N   MET    81      10.639  56.167  22.250  1.00 40.14           N  
ATOM    512  CA  MET    81       9.919  56.713  21.108  1.00 42.73           C  
ATOM    513  C   MET    81       8.765  57.675  21.467  1.00 43.11           C  
ATOM    514  O   MET    81       8.520  58.618  20.730  1.00 42.53           O  
ATOM    515  CB  MET    81       9.432  55.580  20.198  1.00 42.61           C  
ATOM    516  CG  MET    81      10.568  54.902  19.431  1.00 43.80           C  
ATOM    517  SD  MET    81       9.974  53.560  18.134  0.90 48.49          SE  
ATOM    518  CE  MET    81       9.395  52.112  19.373  1.00 41.87           C  
ATOM    519  N   GLU    82       8.087  57.458  22.601  1.00 44.27           N  
ATOM    520  CA  GLU    82       7.135  58.466  23.137  1.00 45.85           C  
ATOM    521  C   GLU    82       7.860  59.782  23.394  1.00 45.91           C  
ATOM    522  O   GLU    82       7.403  60.843  22.989  1.00 46.79           O  
ATOM    523  CB  GLU    82       6.489  58.039  24.470  1.00 45.53           C  
ATOM    524  CG  GLU    82       5.217  57.205  24.406  1.00 48.85           C  
ATOM    525  CD  GLU    82       4.247  57.594  23.266  1.00 54.63           C  
ATOM    526  OE1 GLU    82       3.253  58.314  23.531  1.00 55.24           O  
ATOM    527  OE2 GLU    82       4.470  57.147  22.101  1.00 57.39           O  
ATOM    528  N   THR    83       8.992  59.693  24.080  1.00 46.45           N  
ATOM    529  CA  THR    83       9.771  60.867  24.475  1.00 45.76           C  
ATOM    530  C   THR    83      10.447  61.603  23.288  1.00 45.32           C  
ATOM    531  O   THR    83      10.521  62.828  23.305  1.00 45.43           O  
ATOM    532  CB  THR    83      10.795  60.516  25.590  1.00 46.00           C  
ATOM    533  OG1 THR    83      11.720  59.527  25.129  1.00 46.47           O  
ATOM    534  CG2 THR    83      10.084  59.971  26.841  1.00 46.29           C  
ATOM    535  N   ASP    84      10.895  60.857  22.263  1.00 43.62           N  
ATOM    536  CA  ASP    84      11.665  61.391  21.128  1.00 41.98           C  
ATOM    537  C   ASP    84      11.534  60.402  19.962  1.00 41.59           C  
ATOM    538  O   ASP    84      11.974  59.236  20.064  1.00 40.45           O  
ATOM    539  CB  ASP    84      13.139  61.539  21.541  1.00 42.13           C  
ATOM    540  CG  ASP    84      14.009  62.236  20.488  1.00 42.54           C  
ATOM    541  OD1 ASP    84      13.770  62.126  19.266  1.00 43.26           O  
ATOM    542  OD2 ASP    84      14.984  62.892  20.912  1.00 44.27           O  
ATOM    543  N   ALA    85      10.941  60.861  18.856  1.00 39.53           N  
ATOM    544  CA  ALA    85      10.596  59.949  17.752  1.00 38.78           C  
ATOM    545  C   ALA    85      11.753  59.634  16.791  1.00 38.06           C  
ATOM    546  O   ALA    85      11.574  58.840  15.886  1.00 38.40           O  
ATOM    547  CB  ALA    85       9.356  60.477  16.964  1.00 38.66           C  
ATOM    548  N   ARG    86      12.921  60.255  16.968  1.00 37.49           N  
ATOM    549  CA  ARG    86      14.075  59.998  16.101  1.00 37.80           C  
ATOM    550  C   ARG    86      14.598  58.573  16.313  1.00 37.79           C  
ATOM    551  O   ARG    86      14.936  58.172  17.447  1.00 38.77           O  
ATOM    552  CB  ARG    86      15.191  61.015  16.337  1.00 37.29           C  
ATOM    553  CG  ARG    86      14.782  62.423  15.962  1.00 37.81           C  
ATOM    554  CD  ARG    86      15.909  63.377  16.220  1.00 40.31           C  
ATOM    555  NE  ARG    86      16.150  63.542  17.639  1.00 40.47           N  
ATOM    556  CZ  ARG    86      17.144  64.262  18.153  1.00 42.65           C  
ATOM    557  NH1 ARG    86      17.257  64.358  19.461  1.00 40.10           N  
ATOM    558  NH2 ARG    86      18.022  64.881  17.368  1.00 43.73           N  
ATOM    559  N   ILE    87      14.606  57.800  15.230  1.00 38.06           N  
ATOM    560  CA  ILE    87      15.018  56.378  15.256  1.00 36.98           C  
ATOM    561  C   ILE    87      15.927  56.047  14.083  1.00 38.03           C  
ATOM    562  O   ILE    87      16.014  56.818  13.113  1.00 37.74           O  
ATOM    563  CB  ILE    87      13.797  55.385  15.235  1.00 36.88           C  
ATOM    564  CG1 ILE    87      12.957  55.462  13.944  1.00 36.90           C  
ATOM    565  CG2 ILE    87      12.886  55.630  16.470  1.00 36.77           C  
ATOM    566  CD1 ILE    87      12.027  54.186  13.735  1.00 34.81           C  
ATOM    567  N   SER    88      16.604  54.893  14.173  1.00 38.43           N  
ATOM    568  CA  SER    88      17.331  54.328  13.048  1.00 37.90           C  
ATOM    569  C   SER    88      17.026  52.830  12.974  1.00 38.40           C  
ATOM    570  O   SER    88      16.896  52.180  14.008  1.00 38.37           O  
ATOM    571  CB  SER    88      18.842  54.556  13.197  1.00 36.88           C  
ATOM    572  OG  SER    88      19.560  54.036  12.078  1.00 36.15           O  
ATOM    573  N   VAL    89      16.930  52.277  11.760  1.00 38.48           N  
ATOM    574  CA  VAL    89      16.787  50.813  11.601  1.00 38.88           C  
ATOM    575  C   VAL    89      17.830  50.302  10.631  1.00 38.06           C  
ATOM    576  O   VAL    89      18.230  51.035   9.725  1.00 36.88           O  
ATOM    577  CB  VAL    89      15.369  50.373  11.097  1.00 40.20           C  
ATOM    578  CG1 VAL    89      14.302  50.819  12.041  1.00 38.37           C  
ATOM    579  CG2 VAL    89      15.078  50.950   9.696  1.00 40.61           C  
ATOM    580  N   THR    90      18.312  49.087  10.863  1.00 37.53           N  
ATOM    581  CA  THR    90      19.163  48.436   9.884  1.00 37.70           C  
ATOM    582  C   THR    90      18.491  47.149   9.499  1.00 37.66           C  
ATOM    583  O   THR    90      18.180  46.320  10.339  1.00 38.80           O  
ATOM    584  CB  THR    90      20.601  48.220  10.352  1.00 35.79           C  
ATOM    585  OG1 THR    90      21.173  49.505  10.639  1.00 36.06           O  
ATOM    586  CG2 THR    90      21.482  47.492   9.246  1.00 37.44           C  
ATOM    587  N   LEU    91      18.250  47.032   8.200  1.00 38.53           N  
ATOM    588  CA  LEU    91      17.699  45.849   7.614  1.00 39.28           C  
ATOM    589  C   LEU    91      18.794  45.059   6.917  1.00 40.62           C  
ATOM    590  O   LEU    91      19.650  45.631   6.225  1.00 40.09           O  
ATOM    591  CB  LEU    91      16.605  46.249   6.647  1.00 40.01           C  
ATOM    592  CG  LEU    91      15.246  46.573   7.263  1.00 38.97           C  
ATOM    593  CD1 LEU    91      15.310  47.813   8.152  1.00 43.01           C  
ATOM    594  CD2 LEU    91      14.252  46.840   6.101  1.00 40.75           C  
ATOM    595  N   ALA    92      18.781  43.736   7.095  1.00 41.61           N  
ATOM    596  CA  ALA    92      19.736  42.893   6.387  1.00 43.96           C  
ATOM    597  C   ALA    92      19.142  41.498   6.171  1.00 46.03           C  
ATOM    598  O   ALA    92      18.278  41.098   6.966  1.00 47.72           O  
ATOM    599  CB  ALA    92      21.036  42.818   7.155  1.00 42.95           C  
ATOM    600  N   PRO    93      19.572  40.763   5.108  1.00 47.15           N  
ATOM    601  CA  PRO    93      19.204  39.332   5.006  1.00 47.61           C  
ATOM    602  C   PRO    93      19.973  38.543   6.092  1.00 47.80           C  
ATOM    603  O   PRO    93      20.882  37.772   5.765  1.00 47.05           O  
ATOM    604  CB  PRO    93      19.687  38.934   3.596  1.00 47.22           C  
ATOM    605  CG  PRO    93      20.845  39.877   3.317  1.00 47.42           C  
ATOM    606  CD  PRO    93      20.406  41.189   3.950  1.00 47.69           C  
ATOM    607  N   PHE    94      19.635  38.785   7.367  1.00 47.53           N  
ATOM    608  CA  PHE    94      20.393  38.209   8.489  1.00 48.62           C  
ATOM    609  C   PHE    94      20.432  36.678   8.505  1.00 50.08           C  
ATOM    610  O   PHE    94      21.419  36.076   8.964  1.00 51.13           O  
ATOM    611  CB  PHE    94      19.810  38.662   9.811  1.00 48.35           C  
ATOM    612  CG  PHE    94      20.107  40.061  10.144  1.00 48.23           C  
ATOM    613  CD1 PHE    94      21.394  40.456  10.421  1.00 47.44           C  
ATOM    614  CD2 PHE    94      19.080  41.006  10.192  1.00 46.55           C  
ATOM    615  CE1 PHE    94      21.655  41.793  10.741  1.00 49.24           C  
ATOM    616  CE2 PHE    94      19.329  42.325  10.524  1.00 47.35           C  
ATOM    617  CZ  PHE    94      20.607  42.724  10.797  1.00 48.46           C  
ATOM    618  N   GLY    95      19.369  36.036   8.025  1.00 50.07           N  
ATOM    619  CA  GLY    95      19.398  34.572   7.973  1.00 52.05           C  
ATOM    620  C   GLY    95      20.520  34.009   7.112  1.00 52.20           C  
ATOM    621  O   GLY    95      20.907  32.844   7.284  1.00 52.90           O  
ATOM    622  N   LYS    96      21.045  34.824   6.187  1.00 52.00           N  
ATOM    623  CA  LYS    96      21.969  34.329   5.148  1.00 51.83           C  
ATOM    624  C   LYS    96      23.437  34.283   5.579  1.00 51.44           C  
ATOM    625  O   LYS    96      24.319  34.006   4.770  1.00 51.70           O  
ATOM    626  CB  LYS    96      21.802  35.142   3.824  1.00 51.81           C  
ATOM    627  N   GLY    97      23.713  34.551   6.847  1.00 50.94           N  
ATOM    628  CA  GLY    97      25.090  34.414   7.308  1.00 50.33           C  
ATOM    629  C   GLY    97      25.611  35.687   7.922  1.00 49.54           C  
ATOM    630  O   GLY    97      24.831  36.573   8.261  1.00 50.33           O  
ATOM    631  N   ASP    98      26.932  35.782   8.047  1.00 49.05           N  
ATOM    632  CA  ASP    98      27.539  36.781   8.924  1.00 48.11           C  
ATOM    633  C   ASP    98      27.244  38.226   8.526  1.00 47.99           C  
ATOM    634  O   ASP    98      27.201  38.544   7.338  1.00 47.68           O  
ATOM    635  CB  ASP    98      29.033  36.507   9.105  1.00 47.96           C  
ATOM    636  CG  ASP    98      29.289  35.466  10.185  1.00 47.86           C  
ATOM    637  OD1 ASP    98      28.397  35.330  11.066  1.00 49.44           O  
ATOM    638  OD2 ASP    98      30.344  34.796  10.165  1.00 42.64           O  
ATOM    639  N   ALA    99      27.013  39.085   9.526  1.00 47.12           N  
ATOM    640  CA  ALA    99      26.613  40.475   9.280  1.00 47.62           C  
ATOM    641  C   ALA    99      27.544  41.255   8.332  1.00 47.81           C  
ATOM    642  O   ALA    99      27.066  41.994   7.462  1.00 49.11           O  
ATOM    643  CB  ALA    99      26.414  41.247  10.612  1.00 46.67           C  
ATOM    644  N   LEU   100      28.854  41.108   8.500  1.00 47.20           N  
ATOM    645  CA  LEU   100      29.784  41.843   7.668  1.00 47.26           C  
ATOM    646  C   LEU   100      29.881  41.320   6.208  1.00 47.34           C  
ATOM    647  O   LEU   100      30.537  41.933   5.366  1.00 47.80           O  
ATOM    648  CB  LEU   100      31.156  41.957   8.363  1.00 47.63           C  
ATOM    649  CG  LEU   100      31.246  42.793   9.655  1.00 47.37           C  
ATOM    650  CD1 LEU   100      32.698  42.945  10.097  1.00 44.40           C  
ATOM    651  CD2 LEU   100      30.603  44.166   9.523  1.00 47.96           C  
ATOM    652  N   THR   101      29.225  40.196   5.918  1.00 47.25           N  
ATOM    653  CA  THR   101      29.122  39.670   4.543  1.00 47.24           C  
ATOM    654  C   THR   101      27.868  40.174   3.822  1.00 47.24           C  
ATOM    655  O   THR   101      27.753  40.062   2.608  1.00 48.04           O  
ATOM    656  CB  THR   101      29.068  38.093   4.506  1.00 47.64           C  
ATOM    657  OG1 THR   101      27.862  37.639   5.158  1.00 47.49           O  
ATOM    658  CG2 THR   101      30.274  37.470   5.169  1.00 44.40           C  
ATOM    659  N   LEU   102      26.921  40.710   4.562  1.00 47.23           N  
ATOM    660  CA  LEU   102      25.623  41.022   4.011  1.00 47.59           C  
ATOM    661  C   LEU   102      25.497  42.449   3.542  1.00 46.58           C  
ATOM    662  O   LEU   102      26.127  43.302   4.092  1.00 46.32           O  
ATOM    663  CB  LEU   102      24.556  40.797   5.080  1.00 48.18           C  
ATOM    664  CG  LEU   102      24.513  39.508   5.876  1.00 49.29           C  
ATOM    665  CD1 LEU   102      23.450  39.497   6.890  1.00 47.88           C  
ATOM    666  CD2 LEU   102      24.375  38.361   4.974  1.00 48.28           C  
ATOM    667  N   PRO   103      24.634  42.711   2.567  1.00 45.68           N  
ATOM    668  CA  PRO   103      24.248  44.107   2.342  1.00 44.98           C  
ATOM    669  C   PRO   103      23.440  44.570   3.544  1.00 44.51           C  
ATOM    670  O   PRO   103      22.679  43.789   4.116  1.00 45.61           O  
ATOM    671  CB  PRO   103      23.360  44.042   1.099  1.00 45.24           C  
ATOM    672  CG  PRO   103      22.818  42.660   1.098  1.00 46.09           C  
ATOM    673  CD  PRO   103      23.959  41.807   1.626  1.00 45.51           C  
ATOM    674  N   ARG   104      23.642  45.803   3.964  1.00 42.27           N  
ATOM    675  CA  ARG   104      23.009  46.293   5.151  1.00 42.38           C  
ATOM    676  C   ARG   104      22.432  47.658   4.826  1.00 40.76           C  
ATOM    677  O   ARG   104      23.163  48.568   4.419  1.00 40.88           O  
ATOM    678  CB  ARG   104      24.002  46.412   6.307  1.00 42.35           C  
ATOM    679  CG  ARG   104      24.269  45.116   7.027  1.00 45.67           C  
ATOM    680  CD  ARG   104      25.616  44.582   6.761  1.00 47.32           C  
ATOM    681  NE  ARG   104      26.661  45.481   7.210  1.00 49.89           N  
ATOM    682  CZ  ARG   104      27.859  45.565   6.657  1.00 50.47           C  
ATOM    683  NH1 ARG   104      28.731  46.415   7.158  1.00 52.92           N  
ATOM    684  NH2 ARG   104      28.191  44.799   5.609  1.00 54.70           N  
ATOM    685  N   LEU   105      21.116  47.757   4.962  1.00 38.88           N  
ATOM    686  CA  LEU   105      20.420  48.984   4.661  1.00 37.14           C  
ATOM    687  C   LEU   105      20.077  49.715   5.945  1.00 37.01           C  
ATOM    688  O   LEU   105      19.348  49.180   6.791  1.00 36.52           O  
ATOM    689  CB  LEU   105      19.189  48.688   3.787  1.00 37.18           C  
ATOM    690  CG  LEU   105      18.183  49.809   3.601  1.00 37.12           C  
ATOM    691  CD1 LEU   105      18.777  50.834   2.609  1.00 38.71           C  
ATOM    692  CD2 LEU   105      16.883  49.254   3.095  1.00 39.88           C  
ATOM    693  N   THR   106      20.646  50.912   6.115  1.00 36.12           N  
ATOM    694  CA  THR   106      20.308  51.740   7.269  1.00 36.15           C  
ATOM    695  C   THR   106      19.352  52.861   6.858  1.00 36.02           C  
ATOM    696  O   THR   106      19.630  53.603   5.923  1.00 34.58           O  
ATOM    697  CB  THR   106      21.576  52.300   7.981  1.00 36.43           C  
ATOM    698  OG1 THR   106      22.362  51.202   8.439  1.00 37.67           O  
ATOM    699  CG2 THR   106      21.183  53.136   9.188  1.00 35.63           C  
ATOM    700  N   LEU   107      18.220  52.959   7.562  1.00 36.38           N  
ATOM    701  CA  LEU   107      17.226  53.997   7.322  1.00 37.39           C  
ATOM    702  C   LEU   107      17.071  54.808   8.598  1.00 37.59           C  
ATOM    703  O   LEU   107      16.786  54.255   9.658  1.00 38.36           O  
ATOM    704  CB  LEU   107      15.883  53.386   6.890  1.00 37.42           C  
ATOM    705  CG  LEU   107      15.888  52.335   5.754  1.00 38.96           C  
ATOM    706  CD1 LEU   107      14.515  51.683   5.658  1.00 38.73           C  
ATOM    707  CD2 LEU   107      16.225  52.995   4.407  1.00 37.32           C  
ATOM    708  N   VAL   108      17.306  56.117   8.486  1.00 37.38           N  
ATOM    709  CA  VAL   108      17.208  57.028   9.609  1.00 36.50           C  
ATOM    710  C   VAL   108      15.982  57.912   9.428  1.00 36.44           C  
ATOM    711  O   VAL   108      15.771  58.434   8.349  1.00 36.83           O  
ATOM    712  CB  VAL   108      18.506  57.843   9.752  1.00 35.47           C  
ATOM    713  CG1 VAL   108      18.391  58.875  10.868  1.00 35.13           C  
ATOM    714  CG2 VAL   108      19.692  56.899   9.952  1.00 33.05           C  
ATOM    715  N   GLY   109      15.178  58.090  10.478  1.00 37.67           N  
ATOM    716  CA  GLY   109      14.016  58.998  10.380  1.00 37.60           C  
ATOM    717  C   GLY   109      13.194  59.088  11.645  1.00 38.67           C  
ATOM    718  O   GLY   109      13.748  59.065  12.745  1.00 38.44           O  
ATOM    719  N   ARG   110      11.873  59.219  11.496  1.00 39.40           N  
ATOM    720  CA  ARG   110      10.971  59.310  12.660  1.00 39.19           C  
ATOM    721  C   ARG   110       9.996  58.148  12.742  1.00 39.98           C  
ATOM    722  O   ARG   110       9.556  57.623  11.725  1.00 40.59           O  
ATOM    723  CB  ARG   110      10.250  60.665  12.723  1.00 38.94           C  
ATOM    724  CG  ARG   110      11.188  61.811  13.077  1.00 37.80           C  
ATOM    725  CD  ARG   110      10.575  63.184  12.887  1.00 38.81           C  
ATOM    726  NE  ARG   110      11.606  64.173  13.201  1.00 40.29           N  
ATOM    727  CZ  ARG   110      11.942  64.569  14.432  1.00 41.25           C  
ATOM    728  NH1 ARG   110      12.941  65.434  14.584  1.00 40.86           N  
ATOM    729  NH2 ARG   110      11.291  64.117  15.507  1.00 40.51           N  
ATOM    730  N   ALA   111       9.739  57.698  13.974  1.00 39.87           N  
ATOM    731  CA  ALA   111       8.742  56.686  14.255  1.00 39.24           C  
ATOM    732  C   ALA   111       7.410  57.388  14.427  1.00 39.28           C  
ATOM    733  O   ALA   111       7.158  58.004  15.488  1.00 39.27           O  
ATOM    734  CB  ALA   111       9.101  55.963  15.524  1.00 40.42           C  
ATOM    735  N   ASP   112       6.564  57.297  13.400  1.00 37.97           N  
ATOM    736  CA  ASP   112       5.245  57.869  13.413  1.00 37.66           C  
ATOM    737  C   ASP   112       4.263  56.791  13.859  1.00 39.07           C  
ATOM    738  O   ASP   112       4.145  55.730  13.241  1.00 37.57           O  
ATOM    739  CB  ASP   112       4.845  58.330  12.005  1.00 37.47           C  
ATOM    740  CG  ASP   112       5.527  59.613  11.572  1.00 38.12           C  
ATOM    741  OD1 ASP   112       5.787  60.485  12.423  1.00 34.00           O  
ATOM    742  OD2 ASP   112       5.797  59.778  10.356  1.00 37.81           O  
ATOM    743  N   ARG   113       3.500  57.090  14.888  1.00 39.45           N  
ATOM    744  CA  ARG   113       2.459  56.184  15.313  1.00 40.59           C  
ATOM    745  C   ARG   113       1.341  56.051  14.258  1.00 40.91           C  
ATOM    746  O   ARG   113       0.798  57.048  13.762  1.00 40.36           O  
ATOM    747  CB  ARG   113       1.932  56.668  16.654  1.00 42.56           C  
ATOM    748  CG  ARG   113       1.322  55.580  17.451  1.00 46.63           C  
ATOM    749  CD  ARG   113       2.301  54.882  18.378  1.00 48.90           C  
ATOM    750  NE  ARG   113       1.434  54.340  19.405  1.00 53.60           N  
ATOM    751  CZ  ARG   113       1.151  54.953  20.547  1.00 53.42           C  
ATOM    752  NH1 ARG   113       1.738  56.096  20.858  1.00 55.23           N  
ATOM    753  NH2 ARG   113       0.299  54.401  21.390  1.00 54.54           N  
ATOM    754  N   ILE   114       1.048  54.812  13.868  1.00 40.30           N  
ATOM    755  CA  ILE   114      -0.049  54.545  12.963  1.00 40.96           C  
ATOM    756  C   ILE   114      -1.386  54.812  13.695  1.00 41.58           C  
ATOM    757  O   ILE   114      -1.612  54.259  14.774  1.00 42.47           O  
ATOM    758  CB  ILE   114       0.042  53.108  12.411  1.00 40.38           C  
ATOM    759  CG1 ILE   114       1.260  52.984  11.459  1.00 41.25           C  
ATOM    760  CG2 ILE   114      -1.249  52.703  11.686  1.00 39.00           C  
ATOM    761  CD1 ILE   114       1.469  51.610  10.872  1.00 40.00           C  
ATOM    762  N   GLY   115      -2.227  55.688  13.131  1.00 41.83           N  
ATOM    763  CA  GLY   115      -3.554  56.030  13.692  1.00 41.15           C  
ATOM    764  C   GLY   115      -4.538  54.858  13.797  1.00 41.00           C  
ATOM    765  O   GLY   115      -4.438  53.905  13.029  1.00 40.08           O  
ATOM    766  N   PRO   116      -5.480  54.923  14.770  1.00 41.33           N  
ATOM    767  CA  PRO   116      -6.488  53.900  15.110  1.00 41.12           C  
ATOM    768  C   PRO   116      -7.162  53.226  13.897  1.00 41.75           C  
ATOM    769  O   PRO   116      -7.274  51.988  13.861  1.00 40.88           O  
ATOM    770  CB  PRO   116      -7.537  54.687  15.910  1.00 41.97           C  
ATOM    771  CG  PRO   116      -6.830  55.877  16.457  1.00 41.54           C  
ATOM    772  CD  PRO   116      -5.555  56.093  15.673  1.00 41.00           C  
ATOM    773  N   ASP   117      -7.599  54.026  12.918  1.00 41.48           N  
ATOM    774  CA  ASP   117      -8.340  53.487  11.759  1.00 42.14           C  
ATOM    775  C   ASP   117      -7.572  52.469  10.922  1.00 41.56           C  
ATOM    776  O   ASP   117      -8.163  51.581  10.314  1.00 40.67           O  
ATOM    777  CB  ASP   117      -8.893  54.602  10.847  1.00 42.62           C  
ATOM    778  CG  ASP   117      -9.916  55.509  11.548  1.00 44.68           C  
ATOM    779  OD1 ASP   117     -10.339  56.488  10.904  1.00 47.01           O  
ATOM    780  OD2 ASP   117     -10.294  55.273  12.721  1.00 46.41           O  
ATOM    781  N   GLU   118      -6.247  52.616  10.907  1.00 42.25           N  
ATOM    782  CA  GLU   118      -5.363  51.789  10.115  1.00 42.48           C  
ATOM    783  C   GLU   118      -4.801  50.593  10.880  1.00 41.49           C  
ATOM    784  O   GLU   118      -4.125  49.758  10.287  1.00 40.69           O  
ATOM    785  CB  GLU   118      -4.195  52.638   9.616  1.00 43.11           C  
ATOM    786  CG  GLU   118      -4.617  53.969   8.963  1.00 45.99           C  
ATOM    787  CD  GLU   118      -3.407  54.741   8.501  1.00 51.55           C  
ATOM    788  OE1 GLU   118      -2.791  54.297   7.508  1.00 53.87           O  
ATOM    789  OE2 GLU   118      -3.024  55.742   9.151  1.00 51.97           O  
ATOM    790  N   VAL   119      -5.055  50.470  12.180  1.00 40.47           N  
ATOM    791  CA  VAL   119      -4.452  49.289  12.818  1.00 39.77           C  
ATOM    792  C   VAL   119      -4.970  47.927  12.305  1.00 38.62           C  
ATOM    793  O   VAL   119      -4.153  47.050  12.063  1.00 37.65           O  
ATOM    794  CB  VAL   119      -4.130  49.368  14.343  1.00 39.16           C  
ATOM    795  CG1 VAL   119      -3.759  50.786  14.742  1.00 39.45           C  
ATOM    796  CG2 VAL   119      -5.185  48.829  15.167  1.00 41.43           C  
ATOM    797  N   PRO   120      -6.304  47.757  12.134  1.00 38.16           N  
ATOM    798  CA  PRO   120      -6.766  46.493  11.532  1.00 37.43           C  
ATOM    799  C   PRO   120      -6.020  46.047  10.227  1.00 37.74           C  
ATOM    800  O   PRO   120      -5.633  44.876  10.099  1.00 36.09           O  
ATOM    801  CB  PRO   120      -8.245  46.752  11.284  1.00 37.07           C  
ATOM    802  CG  PRO   120      -8.634  47.730  12.397  1.00 38.18           C  
ATOM    803  CD  PRO   120      -7.440  48.628  12.532  1.00 37.57           C  
ATOM    804  N   LEU   121      -5.823  46.977   9.301  1.00 37.13           N  
ATOM    805  CA  LEU   121      -5.069  46.685   8.080  1.00 38.71           C  
ATOM    806  C   LEU   121      -3.622  46.312   8.376  1.00 37.67           C  
ATOM    807  O   LEU   121      -3.110  45.342   7.819  1.00 37.67           O  
ATOM    808  CB  LEU   121      -5.126  47.883   7.139  1.00 38.61           C  
ATOM    809  CG  LEU   121      -4.512  47.752   5.759  1.00 39.30           C  
ATOM    810  CD1 LEU   121      -5.110  46.579   4.936  1.00 35.77           C  
ATOM    811  CD2 LEU   121      -4.764  49.121   5.140  1.00 41.31           C  
ATOM    812  N   ALA   122      -2.980  47.061   9.274  1.00 36.98           N  
ATOM    813  CA  ALA   122      -1.574  46.854   9.582  1.00 36.59           C  
ATOM    814  C   ALA   122      -1.386  45.497  10.265  1.00 37.61           C  
ATOM    815  O   ALA   122      -0.397  44.789  10.033  1.00 36.60           O  
ATOM    816  CB  ALA   122      -1.034  48.017  10.459  1.00 37.41           C  
ATOM    817  N   ILE   123      -2.358  45.125  11.089  1.00 37.52           N  
ATOM    818  CA  ILE   123      -2.385  43.802  11.748  1.00 38.61           C  
ATOM    819  C   ILE   123      -2.406  42.675  10.741  1.00 37.17           C  
ATOM    820  O   ILE   123      -1.649  41.710  10.838  1.00 37.42           O  
ATOM    821  CB  ILE   123      -3.657  43.639  12.672  1.00 39.07           C  
ATOM    822  CG1 ILE   123      -3.511  44.499  13.927  1.00 41.23           C  
ATOM    823  CG2 ILE   123      -3.890  42.180  13.098  1.00 40.52           C  
ATOM    824  CD1 ILE   123      -2.270  44.198  14.646  1.00 45.57           C  
ATOM    825  N   ALA   124      -3.313  42.752   9.795  1.00 36.81           N  
ATOM    826  CA  ALA   124      -3.427  41.659   8.857  1.00 37.23           C  
ATOM    827  C   ALA   124      -2.128  41.553   8.001  1.00 37.64           C  
ATOM    828  O   ALA   124      -1.590  40.452   7.800  1.00 36.63           O  
ATOM    829  CB  ALA   124      -4.654  41.830   7.999  1.00 37.00           C  
ATOM    830  N   ARG   125      -1.607  42.702   7.579  1.00 37.64           N  
ATOM    831  CA  ARG   125      -0.338  42.736   6.830  1.00 38.74           C  
ATOM    832  C   ARG   125       0.839  42.139   7.607  1.00 39.32           C  
ATOM    833  O   ARG   125       1.660  41.394   7.056  1.00 39.10           O  
ATOM    834  CB  ARG   125       0.003  44.157   6.428  1.00 39.12           C  
ATOM    835  CG  ARG   125      -0.760  44.677   5.279  1.00 39.31           C  
ATOM    836  CD  ARG   125      -0.540  46.186   5.178  1.00 42.21           C  
ATOM    837  NE  ARG   125      -1.251  46.747   4.033  1.00 42.02           N  
ATOM    838  CZ  ARG   125      -1.330  48.041   3.735  1.00 44.09           C  
ATOM    839  NH1 ARG   125      -0.787  48.966   4.539  1.00 42.23           N  
ATOM    840  NH2 ARG   125      -1.989  48.402   2.627  1.00 43.74           N  
ATOM    841  N   TYR   126       0.913  42.455   8.901  1.00 38.91           N  
ATOM    842  CA  TYR   126       1.965  41.957   9.741  1.00 38.50           C  
ATOM    843  C   TYR   126       1.883  40.445  10.004  1.00 38.28           C  
ATOM    844  O   TYR   126       2.888  39.738   9.921  1.00 37.03           O  
ATOM    845  CB  TYR   126       1.882  42.701  11.070  1.00 38.18           C  
ATOM    846  CG  TYR   126       3.073  42.563  11.972  1.00 38.12           C  
ATOM    847  CD1 TYR   126       4.130  43.481  11.909  1.00 38.79           C  
ATOM    848  CD2 TYR   126       3.099  41.592  12.959  1.00 38.98           C  
ATOM    849  CE1 TYR   126       5.217  43.383  12.779  1.00 38.36           C  
ATOM    850  CE2 TYR   126       4.154  41.486  13.840  1.00 39.29           C  
ATOM    851  CZ  TYR   126       5.211  42.397  13.757  1.00 39.80           C  
ATOM    852  OH  TYR   126       6.241  42.303  14.671  1.00 40.32           O  
ATOM    853  N   ILE   127       0.680  39.970  10.361  1.00 38.68           N  
ATOM    854  CA  ILE   127       0.370  38.560  10.561  1.00 38.24           C  
ATOM    855  C   ILE   127       0.751  37.693   9.356  1.00 38.71           C  
ATOM    856  O   ILE   127       1.212  36.567   9.513  1.00 37.24           O  
ATOM    857  CB  ILE   127      -1.169  38.356  10.836  1.00 39.14           C  
ATOM    858  CG1 ILE   127      -1.566  38.755  12.282  1.00 39.78           C  
ATOM    859  CG2 ILE   127      -1.614  36.931  10.590  1.00 38.81           C  
ATOM    860  CD1 ILE   127      -0.651  38.299  13.287  1.00 41.39           C  
ATOM    861  N   ALA   128       0.536  38.247   8.170  1.00 38.28           N  
ATOM    862  CA  ALA   128       0.881  37.603   6.892  1.00 39.64           C  
ATOM    863  C   ALA   128       2.362  37.196   6.864  1.00 39.77           C  
ATOM    864  O   ALA   128       2.692  36.160   6.326  1.00 40.73           O  
ATOM    865  CB  ALA   128       0.538  38.544   5.716  1.00 37.72           C  
ATOM    866  N   ARG   129       3.239  37.977   7.501  1.00 39.93           N  
ATOM    867  CA  ARG   129       4.663  37.665   7.535  1.00 40.44           C  
ATOM    868  C   ARG   129       5.092  36.935   8.789  1.00 41.02           C  
ATOM    869  O   ARG   129       6.078  36.186   8.762  1.00 41.36           O  
ATOM    870  CB  ARG   129       5.504  38.953   7.385  1.00 40.36           C  
ATOM    871  CG  ARG   129       5.631  39.460   6.006  1.00 40.68           C  
ATOM    872  CD  ARG   129       6.516  40.731   6.028  1.00 42.98           C  
ATOM    873  NE  ARG   129       7.005  41.042   4.703  1.00 42.54           N  
ATOM    874  CZ  ARG   129       8.005  41.881   4.428  1.00 40.53           C  
ATOM    875  NH1 ARG   129       8.668  42.496   5.400  1.00 35.92           N  
ATOM    876  NH2 ARG   129       8.369  42.072   3.162  1.00 40.85           N  
ATOM    877  N   TYR   130       4.355  37.171   9.879  1.00 40.43           N  
ATOM    878  CA  TYR   130       4.744  36.787  11.237  1.00 40.69           C  
ATOM    879  C   TYR   130       3.545  36.101  11.899  1.00 40.82           C  
ATOM    880  O   TYR   130       2.832  36.721  12.718  1.00 39.21           O  
ATOM    881  CB  TYR   130       5.205  38.026  12.053  1.00 40.55           C  
ATOM    882  CG  TYR   130       6.263  38.783  11.311  1.00 40.43           C  
ATOM    883  CD1 TYR   130       7.511  38.180  11.078  1.00 41.13           C  
ATOM    884  CD2 TYR   130       6.016  40.050  10.782  1.00 36.37           C  
ATOM    885  CE1 TYR   130       8.468  38.794  10.335  1.00 42.15           C  
ATOM    886  CE2 TYR   130       6.996  40.693  10.025  1.00 37.26           C  
ATOM    887  CZ  TYR   130       8.215  40.051   9.809  1.00 39.60           C  
ATOM    888  OH  TYR   130       9.191  40.643   9.072  1.00 41.60           O  
ATOM    889  N   PRO   131       3.306  34.817  11.540  1.00 42.16           N  
ATOM    890  CA  PRO   131       2.096  34.165  12.065  1.00 42.41           C  
ATOM    891  C   PRO   131       2.062  34.024  13.586  1.00 43.43           C  
ATOM    892  O   PRO   131       0.988  33.896  14.156  1.00 43.70           O  
ATOM    893  CB  PRO   131       2.077  32.794  11.349  1.00 42.87           C  
ATOM    894  CG  PRO   131       3.453  32.545  10.957  1.00 42.32           C  
ATOM    895  CD  PRO   131       4.065  33.913  10.654  1.00 41.32           C  
ATOM    896  N   LYS   132       3.210  34.079  14.254  1.00 44.16           N  
ATOM    897  CA  LYS   132       3.206  34.014  15.703  1.00 45.24           C  
ATOM    898  C   LYS   132       2.663  35.298  16.324  1.00 44.82           C  
ATOM    899  O   LYS   132       2.263  35.304  17.487  1.00 43.69           O  
ATOM    900  CB  LYS   132       4.595  33.704  16.260  1.00 45.12           C  
ATOM    901  CG  LYS   132       4.842  32.232  16.432  1.00 47.27           C  
ATOM    902  CD  LYS   132       6.196  31.909  17.119  1.00 48.39           C  
ATOM    903  CE  LYS   132       7.430  32.170  16.226  1.00 52.49           C  
ATOM    904  NZ  LYS   132       7.137  32.521  14.768  1.00 53.17           N  
ATOM    905  N   ALA   133       2.641  36.376  15.540  1.00 44.82           N  
ATOM    906  CA  ALA   133       2.119  37.640  16.033  1.00 45.86           C  
ATOM    907  C   ALA   133       0.639  37.487  16.421  1.00 46.28           C  
ATOM    908  O   ALA   133       0.119  38.284  17.187  1.00 46.88           O  
ATOM    909  CB  ALA   133       2.317  38.750  15.011  1.00 44.40           C  
ATOM    910  N   LYS   134      -0.011  36.451  15.885  1.00 46.67           N  
ATOM    911  CA  LYS   134      -1.416  36.157  16.164  1.00 47.61           C  
ATOM    912  C   LYS   134      -1.651  36.137  17.651  1.00 47.75           C  
ATOM    913  O   LYS   134      -2.757  36.404  18.112  1.00 47.97           O  
ATOM    914  CB  LYS   134      -1.842  34.813  15.552  1.00 47.52           C  
ATOM    915  CG  LYS   134      -1.859  34.804  14.020  1.00 47.47           C  
ATOM    916  CD  LYS   134      -2.287  33.432  13.483  1.00 49.07           C  
ATOM    917  CE  LYS   134      -1.445  32.992  12.281  1.00 51.18           C  
ATOM    918  NZ  LYS   134      -1.843  33.616  10.967  1.00 49.86           N  
ATOM    919  N   LEU   135      -0.579  35.853  18.390  1.00 48.06           N  
ATOM    920  CA  LEU   135      -0.617  35.721  19.826  1.00 47.97           C  
ATOM    921  C   LEU   135      -0.192  37.001  20.519  1.00 47.15           C  
ATOM    922  O   LEU   135      -0.969  37.551  21.300  1.00 46.82           O  
ATOM    923  CB  LEU   135       0.261  34.537  20.278  1.00 48.70           C  
ATOM    924  CG  LEU   135       0.035  33.874  21.647  1.00 50.11           C  
ATOM    925  CD1 LEU   135       0.774  34.634  22.791  1.00 50.84           C  
ATOM    926  CD2 LEU   135      -1.474  33.663  21.956  1.00 50.85           C  
ATOM    927  N   TYR   136       1.031  37.462  20.260  1.00 46.11           N  
ATOM    928  CA  TYR   136       1.581  38.606  21.013  1.00 45.99           C  
ATOM    929  C   TYR   136       1.034  39.993  20.657  1.00 46.23           C  
ATOM    930  O   TYR   136       1.253  40.941  21.400  1.00 47.04           O  
ATOM    931  CB  TYR   136       3.109  38.615  21.041  1.00 45.39           C  
ATOM    932  CG  TYR   136       3.790  38.700  19.693  1.00 46.29           C  
ATOM    933  CD1 TYR   136       3.885  39.920  19.003  1.00 46.59           C  
ATOM    934  CD2 TYR   136       4.382  37.560  19.114  1.00 47.90           C  
ATOM    935  CE1 TYR   136       4.510  40.011  17.768  1.00 45.30           C  
ATOM    936  CE2 TYR   136       5.021  37.640  17.878  1.00 45.08           C  
ATOM    937  CZ  TYR   136       5.087  38.863  17.214  1.00 45.87           C  
ATOM    938  OH  TYR   136       5.715  38.938  15.992  1.00 41.33           O  
ATOM    939  N   LEU   137       0.359  40.122  19.511  1.00 46.65           N  
ATOM    940  CA  LEU   137      -0.418  41.332  19.204  1.00 46.13           C  
ATOM    941  C   LEU   137      -1.735  41.311  20.000  1.00 46.60           C  
ATOM    942  O   LEU   137      -2.290  42.359  20.306  1.00 46.98           O  
ATOM    943  CB  LEU   137      -0.713  41.459  17.704  1.00 45.65           C  
ATOM    944  CG  LEU   137       0.437  41.531  16.695  1.00 44.77           C  
ATOM    945  CD1 LEU   137      -0.089  41.595  15.239  1.00 43.62           C  
ATOM    946  CD2 LEU   137       1.283  42.731  17.005  1.00 44.94           C  
ATOM    947  N   SER   138      -2.232  40.115  20.331  1.00 46.62           N  
ATOM    948  CA  SER   138      -3.452  39.978  21.138  1.00 46.51           C  
ATOM    949  C   SER   138      -3.169  40.269  22.616  1.00 46.44           C  
ATOM    950  O   SER   138      -4.035  40.077  23.474  1.00 45.70           O  
ATOM    951  CB  SER   138      -4.083  38.578  20.979  1.00 46.73           C  
ATOM    952  OG  SER   138      -4.835  38.461  19.779  1.00 45.66           O  
ATOM    953  N   LEU   139      -1.955  40.729  22.906  1.00 46.67           N  
ATOM    954  CA  LEU   139      -1.587  41.082  24.277  1.00 47.11           C  
ATOM    955  C   LEU   139      -1.803  42.577  24.520  1.00 47.01           C  
ATOM    956  O   LEU   139      -1.718  43.355  23.579  1.00 47.26           O  
ATOM    957  CB  LEU   139      -0.132  40.673  24.561  1.00 47.38           C  
ATOM    958  CG  LEU   139       0.075  39.157  24.775  1.00 48.22           C  
ATOM    959  CD1 LEU   139       1.557  38.734  24.649  1.00 48.29           C  
ATOM    960  CD2 LEU   139      -0.538  38.697  26.101  1.00 46.80           C  
ATOM    961  N   PRO   140      -2.098  42.982  25.772  1.00 46.85           N  
ATOM    962  CA  PRO   140      -2.243  44.405  26.123  1.00 47.11           C  
ATOM    963  C   PRO   140      -1.185  45.383  25.554  1.00 46.98           C  
ATOM    964  O   PRO   140      -0.054  44.997  25.304  1.00 46.95           O  
ATOM    965  CB  PRO   140      -2.208  44.384  27.670  1.00 47.08           C  
ATOM    966  CG  PRO   140      -2.900  43.086  27.999  1.00 46.63           C  
ATOM    967  CD  PRO   140      -2.367  42.116  26.942  1.00 47.39           C  
ATOM    968  N   ASP   141      -1.623  46.629  25.332  1.00 47.12           N  
ATOM    969  CA  ASP   141      -0.824  47.794  24.899  1.00 46.88           C  
ATOM    970  C   ASP   141       0.037  47.641  23.642  1.00 45.67           C  
ATOM    971  O   ASP   141       1.088  48.244  23.545  1.00 45.12           O  
ATOM    972  CB  ASP   141      -0.028  48.431  26.058  1.00 47.97           C  
ATOM    973  CG  ASP   141       0.312  49.933  25.794  1.00 51.71           C  
ATOM    974  OD1 ASP   141       0.123  50.416  24.640  1.00 56.09           O  
ATOM    975  OD2 ASP   141       0.765  50.642  26.726  1.00 53.23           O  
ATOM    976  N   THR   142      -0.433  46.872  22.665  1.00 45.38           N  
ATOM    977  CA  THR   142       0.298  46.738  21.399  1.00 44.64           C  
ATOM    978  C   THR   142       0.354  48.133  20.750  1.00 43.67           C  
ATOM    979  O   THR   142      -0.661  48.835  20.706  1.00 42.32           O  
ATOM    980  CB  THR   142      -0.322  45.645  20.432  1.00 45.28           C  
ATOM    981  OG1 THR   142      -1.500  46.129  19.764  1.00 50.55           O  
ATOM    982  CG2 THR   142      -0.691  44.384  21.154  1.00 43.67           C  
ATOM    983  N   ARG   143       1.543  48.544  20.302  1.00 42.84           N  
ATOM    984  CA  ARG   143       1.752  49.844  19.613  1.00 41.55           C  
ATOM    985  C   ARG   143       2.296  49.644  18.197  1.00 41.15           C  
ATOM    986  O   ARG   143       3.172  48.825  17.972  1.00 39.56           O  
ATOM    987  CB  ARG   143       2.693  50.754  20.397  1.00 41.33           C  
ATOM    988  CG  ARG   143       2.105  51.238  21.716  1.00 42.76           C  
ATOM    989  CD  ARG   143       2.837  52.418  22.285  1.00 41.74           C  
ATOM    990  NE  ARG   143       2.324  52.678  23.626  1.00 43.71           N  
ATOM    991  CZ  ARG   143       2.963  53.384  24.552  1.00 44.78           C  
ATOM    992  NH1 ARG   143       4.143  53.932  24.282  1.00 44.95           N  
ATOM    993  NH2 ARG   143       2.417  53.540  25.749  1.00 44.32           N  
ATOM    994  N   LEU   144       1.784  50.424  17.263  1.00 40.42           N  
ATOM    995  CA  LEU   144       2.074  50.247  15.850  1.00 40.95           C  
ATOM    996  C   LEU   144       2.702  51.530  15.277  1.00 40.06           C  
ATOM    997  O   LEU   144       2.163  52.615  15.462  1.00 38.91           O  
ATOM    998  CB  LEU   144       0.751  49.987  15.181  1.00 42.20           C  
ATOM    999  CG  LEU   144       0.619  49.097  13.969  1.00 46.50           C  
ATOM   1000  CD1 LEU   144       1.875  48.287  13.671  1.00 49.12           C  
ATOM   1001  CD2 LEU   144      -0.608  48.216  14.255  1.00 48.62           C  
ATOM   1002  N   TYR   145       3.817  51.406  14.564  1.00 39.79           N  
ATOM   1003  CA  TYR   145       4.558  52.599  14.078  1.00 40.16           C  
ATOM   1004  C   TYR   145       4.959  52.432  12.632  1.00 40.01           C  
ATOM   1005  O   TYR   145       5.267  51.349  12.243  1.00 39.76           O  
ATOM   1006  CB  TYR   145       5.867  52.724  14.824  1.00 39.53           C  
ATOM   1007  CG  TYR   145       5.781  52.715  16.319  1.00 40.63           C  
ATOM   1008  CD1 TYR   145       5.830  53.908  17.048  1.00 39.84           C  
ATOM   1009  CD2 TYR   145       5.749  51.505  17.013  1.00 40.60           C  
ATOM   1010  CE1 TYR   145       5.801  53.895  18.451  1.00 40.06           C  
ATOM   1011  CE2 TYR   145       5.697  51.480  18.355  1.00 39.43           C  
ATOM   1012  CZ  TYR   145       5.730  52.671  19.081  1.00 39.67           C  
ATOM   1013  OH  TYR   145       5.702  52.587  20.428  1.00 42.40           O  
ATOM   1014  N   ARG   146       5.015  53.506  11.843  1.00 39.59           N  
ATOM   1015  CA  ARG   146       5.738  53.386  10.573  1.00 39.78           C  
ATOM   1016  C   ARG   146       6.938  54.325  10.546  1.00 39.11           C  
ATOM   1017  O   ARG   146       6.964  55.378  11.224  1.00 39.10           O  
ATOM   1018  CB  ARG   146       4.811  53.511   9.324  1.00 40.31           C  
ATOM   1019  CG  ARG   146       4.060  54.788   9.265  1.00 39.82           C  
ATOM   1020  CD  ARG   146       3.345  55.018   7.916  1.00 38.92           C  
ATOM   1021  NE  ARG   146       2.211  54.139   7.701  1.00 37.29           N  
ATOM   1022  CZ  ARG   146       0.949  54.414   8.052  1.00 39.59           C  
ATOM   1023  NH1 ARG   146       0.620  55.547   8.670  1.00 36.29           N  
ATOM   1024  NH2 ARG   146       0.002  53.529   7.806  1.00 38.02           N  
ATOM   1025  N   LEU   147       7.953  53.898   9.812  1.00 38.46           N  
ATOM   1026  CA  LEU   147       9.159  54.674   9.672  1.00 39.22           C  
ATOM   1027  C   LEU   147       8.892  55.779   8.668  1.00 39.28           C  
ATOM   1028  O   LEU   147       8.458  55.507   7.541  1.00 40.23           O  
ATOM   1029  CB  LEU   147      10.337  53.786   9.223  1.00 38.32           C  
ATOM   1030  CG  LEU   147      11.633  54.552   8.934  1.00 40.43           C  
ATOM   1031  CD1 LEU   147      12.162  55.301  10.146  1.00 40.13           C  
ATOM   1032  CD2 LEU   147      12.676  53.585   8.383  1.00 39.88           C  
ATOM   1033  N   ARG   148       9.128  57.019   9.093  1.00 38.60           N  
ATOM   1034  CA  ARG   148       9.226  58.123   8.164  1.00 38.77           C  
ATOM   1035  C   ARG   148      10.701  58.279   7.820  1.00 38.33           C  
ATOM   1036  O   ARG   148      11.459  58.805   8.619  1.00 38.32           O  
ATOM   1037  CB  ARG   148       8.725  59.410   8.813  1.00 38.13           C  
ATOM   1038  CG  ARG   148       8.409  60.481   7.803  1.00 37.78           C  
ATOM   1039  CD  ARG   148       8.179  61.861   8.399  1.00 38.22           C  
ATOM   1040  NE  ARG   148       7.600  61.872   9.745  1.00 37.75           N  
ATOM   1041  CZ  ARG   148       7.628  62.927  10.557  1.00 37.04           C  
ATOM   1042  NH1 ARG   148       8.198  64.048  10.163  1.00 39.09           N  
ATOM   1043  NH2 ARG   148       7.088  62.877  11.769  1.00 37.72           N  
ATOM   1044  N   THR   149      11.112  57.813   6.646  1.00 38.59           N  
ATOM   1045  CA  THR   149      12.545  57.748   6.309  1.00 37.96           C  
ATOM   1046  C   THR   149      13.029  59.141   5.922  1.00 38.33           C  
ATOM   1047  O   THR   149      12.405  59.803   5.065  1.00 36.50           O  
ATOM   1048  CB  THR   149      12.806  56.757   5.154  1.00 38.31           C  
ATOM   1049  OG1 THR   149      12.509  55.419   5.604  1.00 41.10           O  
ATOM   1050  CG2 THR   149      14.270  56.801   4.713  1.00 35.97           C  
ATOM   1051  N   GLU   150      14.136  59.582   6.538  1.00 37.61           N  
ATOM   1052  CA  GLU   150      14.712  60.870   6.226  1.00 37.27           C  
ATOM   1053  C   GLU   150      16.117  60.754   5.641  1.00 36.61           C  
ATOM   1054  O   GLU   150      16.620  61.694   5.038  1.00 35.99           O  
ATOM   1055  CB  GLU   150      14.728  61.781   7.469  1.00 37.85           C  
ATOM   1056  CG  GLU   150      13.363  62.026   8.039  1.00 40.67           C  
ATOM   1057  CD  GLU   150      13.392  62.918   9.236  1.00 43.99           C  
ATOM   1058  OE1 GLU   150      13.697  62.446  10.343  1.00 45.92           O  
ATOM   1059  OE2 GLU   150      13.083  64.103   9.075  1.00 47.26           O  
ATOM   1060  N   GLY   151      16.754  59.605   5.811  1.00 36.37           N  
ATOM   1061  CA  GLY   151      18.106  59.438   5.304  1.00 35.42           C  
ATOM   1062  C   GLY   151      18.391  57.979   5.175  1.00 36.25           C  
ATOM   1063  O   GLY   151      17.818  57.157   5.916  1.00 36.80           O  
ATOM   1064  N   VAL   152      19.238  57.639   4.215  1.00 36.10           N  
ATOM   1065  CA  VAL   152      19.430  56.227   3.805  1.00 35.33           C  
ATOM   1066  C   VAL   152      20.918  55.988   3.648  1.00 35.97           C  
ATOM   1067  O   VAL   152      21.619  56.816   3.048  1.00 35.63           O  
ATOM   1068  CB  VAL   152      18.795  55.952   2.411  1.00 34.93           C  
ATOM   1069  CG1 VAL   152      19.039  54.483   1.920  1.00 32.95           C  
ATOM   1070  CG2 VAL   152      17.350  56.272   2.423  1.00 35.09           C  
ATOM   1071  N   GLN   153      21.393  54.850   4.145  1.00 36.44           N  
ATOM   1072  CA  GLN   153      22.734  54.355   3.769  1.00 37.39           C  
ATOM   1073  C   GLN   153      22.655  52.879   3.356  1.00 36.80           C  
ATOM   1074  O   GLN   153      22.052  52.100   4.058  1.00 36.40           O  
ATOM   1075  CB  GLN   153      23.665  54.515   4.963  1.00 37.50           C  
ATOM   1076  CG  GLN   153      25.127  54.524   4.640  1.00 41.65           C  
ATOM   1077  CD  GLN   153      25.556  55.736   3.810  1.00 41.98           C  
ATOM   1078  OE1 GLN   153      24.964  56.831   3.864  1.00 45.79           O  
ATOM   1079  NE2 GLN   153      26.583  55.533   3.041  1.00 42.54           N  
ATOM   1080  N   ILE   154      23.241  52.503   2.226  1.00 37.17           N  
ATOM   1081  CA  ILE   154      23.331  51.090   1.860  1.00 39.21           C  
ATOM   1082  C   ILE   154      24.785  50.640   1.815  1.00 41.79           C  
ATOM   1083  O   ILE   154      25.679  51.367   1.372  1.00 41.41           O  
ATOM   1084  CB  ILE   154      22.601  50.741   0.538  1.00 38.42           C  
ATOM   1085  CG1 ILE   154      22.646  49.226   0.255  1.00 38.22           C  
ATOM   1086  CG2 ILE   154      23.205  51.475  -0.643  1.00 38.65           C  
ATOM   1087  CD1 ILE   154      21.854  48.347   1.229  1.00 39.83           C  
ATOM   1088  N   ASN   155      25.004  49.399   2.225  1.00 44.68           N  
ATOM   1089  CA  ASN   155      26.328  48.960   2.615  1.00 46.88           C  
ATOM   1090  C   ASN   155      26.582  47.483   2.353  1.00 47.70           C  
ATOM   1091  O   ASN   155      25.686  46.663   2.509  1.00 46.80           O  
ATOM   1092  CB  ASN   155      26.426  49.207   4.104  1.00 47.14           C  
ATOM   1093  CG  ASN   155      27.647  49.882   4.462  1.00 50.04           C  
ATOM   1094  OD1 ASN   155      28.705  49.253   4.585  1.00 55.54           O  
ATOM   1095  ND2 ASN   155      27.558  51.195   4.622  1.00 52.46           N  
ATOM   1096  N   GLY   156      27.811  47.151   1.959  1.00 49.84           N  
ATOM   1097  CA  GLY   156      28.226  45.753   1.770  1.00 51.52           C  
ATOM   1098  C   GLY   156      27.617  45.115   0.522  1.00 52.58           C  
ATOM   1099  O   GLY   156      27.855  43.933   0.213  1.00 53.20           O  
ATOM   1100  N   SER   163      26.464  54.270  -1.177  1.00 60.56           N  
ATOM   1101  CA  SER   163      26.432  55.140  -2.358  1.00 60.69           C  
ATOM   1102  C   SER   163      25.807  56.505  -2.030  1.00 60.30           C  
ATOM   1103  O   SER   163      25.996  57.018  -0.913  1.00 60.50           O  
ATOM   1104  CB  SER   163      25.691  54.453  -3.512  1.00 60.82           C  
ATOM   1105  N   ASN   164      25.077  57.098  -2.983  1.00 59.18           N  
ATOM   1106  CA  ASN   164      24.316  58.305  -2.663  1.00 57.87           C  
ATOM   1107  C   ASN   164      22.811  58.245  -2.973  1.00 56.64           C  
ATOM   1108  O   ASN   164      22.310  58.927  -3.882  1.00 56.74           O  
ATOM   1109  CB  ASN   164      24.991  59.557  -3.217  1.00 58.18           C  
ATOM   1110  CG  ASN   164      25.093  60.662  -2.170  1.00 59.61           C  
ATOM   1111  OD1 ASN   164      24.452  60.581  -1.102  1.00 61.55           O  
ATOM   1112  ND2 ASN   164      25.898  61.696  -2.459  1.00 58.37           N  
ATOM   1113  N   ILE   165      22.119  57.431  -2.171  1.00 54.60           N  
ATOM   1114  CA  ILE   165      20.681  57.144  -2.264  1.00 52.78           C  
ATOM   1115  C   ILE   165      19.834  58.029  -1.349  1.00 51.56           C  
ATOM   1116  O   ILE   165      20.213  58.327  -0.218  1.00 51.45           O  
ATOM   1117  CB  ILE   165      20.383  55.679  -1.835  1.00 52.71           C  
ATOM   1118  CG1 ILE   165      21.223  54.685  -2.617  1.00 52.48           C  
ATOM   1119  CG2 ILE   165      18.870  55.346  -1.944  1.00 52.17           C  
ATOM   1120  CD1 ILE   165      21.075  53.276  -2.069  1.00 53.76           C  
ATOM   1121  N   THR   166      18.659  58.387  -1.850  1.00 49.82           N  
ATOM   1122  CA  THR   166      17.685  59.221  -1.167  1.00 47.99           C  
ATOM   1123  C   THR   166      16.460  58.402  -0.707  1.00 46.53           C  
ATOM   1124  O   THR   166      16.163  57.365  -1.305  1.00 45.87           O  
ATOM   1125  CB  THR   166      17.195  60.292  -2.160  1.00 48.47           C  
ATOM   1126  OG1 THR   166      16.247  61.157  -1.526  1.00 50.18           O  
ATOM   1127  CG2 THR   166      16.526  59.641  -3.353  1.00 47.03           C  
ATOM   1128  N   PRO   167      15.736  58.879   0.335  1.00 44.87           N  
ATOM   1129  CA  PRO   167      14.458  58.290   0.720  1.00 43.50           C  
ATOM   1130  C   PRO   167      13.494  58.042  -0.451  1.00 42.73           C  
ATOM   1131  O   PRO   167      12.872  56.980  -0.511  1.00 41.20           O  
ATOM   1132  CB  PRO   167      13.899  59.320   1.701  1.00 43.49           C  
ATOM   1133  CG  PRO   167      15.121  59.813   2.394  1.00 43.85           C  
ATOM   1134  CD  PRO   167      16.106  59.979   1.255  1.00 44.61           C  
ATOM   1135  N   ALA   168      13.394  59.003  -1.376  1.00 41.20           N  
ATOM   1136  CA  ALA   168      12.558  58.884  -2.575  1.00 40.36           C  
ATOM   1137  C   ALA   168      12.945  57.702  -3.447  1.00 40.15           C  
ATOM   1138  O   ALA   168      12.078  57.091  -4.074  1.00 39.71           O  
ATOM   1139  CB  ALA   168      12.623  60.191  -3.420  1.00 39.95           C  
ATOM   1140  N   ASP   169      14.248  57.401  -3.501  1.00 40.01           N  
ATOM   1141  CA  ASP   169      14.760  56.285  -4.307  1.00 40.40           C  
ATOM   1142  C   ASP   169      14.215  54.952  -3.813  1.00 39.36           C  
ATOM   1143  O   ASP   169      14.077  54.007  -4.570  1.00 38.74           O  
ATOM   1144  CB  ASP   169      16.286  56.201  -4.240  1.00 40.55           C  
ATOM   1145  CG  ASP   169      16.984  57.170  -5.175  1.00 44.16           C  
ATOM   1146  OD1 ASP   169      16.370  57.686  -6.141  1.00 46.62           O  
ATOM   1147  OD2 ASP   169      18.177  57.426  -4.917  1.00 46.46           O  
ATOM   1148  N   LEU   170      13.938  54.869  -2.520  1.00 39.88           N  
ATOM   1149  CA  LEU   170      13.470  53.617  -1.971  1.00 40.30           C  
ATOM   1150  C   LEU   170      11.977  53.420  -2.130  1.00 41.43           C  
ATOM   1151  O   LEU   170      11.506  52.272  -2.117  1.00 43.10           O  
ATOM   1152  CB  LEU   170      13.843  53.477  -0.496  1.00 39.86           C  
ATOM   1153  CG  LEU   170      15.310  53.540  -0.134  1.00 41.26           C  
ATOM   1154  CD1 LEU   170      15.403  53.049   1.308  1.00 38.50           C  
ATOM   1155  CD2 LEU   170      16.132  52.668  -1.055  1.00 41.75           C  
ATOM   1156  N   ARG   171      11.220  54.508  -2.225  1.00 41.64           N  
ATOM   1157  CA  ARG   171       9.757  54.400  -2.276  1.00 42.86           C  
ATOM   1158  C   ARG   171       9.224  53.862  -3.570  1.00 41.94           C  
ATOM   1159  O   ARG   171       9.793  54.126  -4.624  1.00 42.66           O  
ATOM   1160  CB  ARG   171       9.090  55.745  -2.037  1.00 44.35           C  
ATOM   1161  CG  ARG   171       8.629  55.926  -0.589  1.00 48.08           C  
ATOM   1162  CD  ARG   171       7.734  57.174  -0.489  1.00 55.26           C  
ATOM   1163  NE  ARG   171       8.159  58.232  -1.413  1.00 59.23           N  
ATOM   1164  CZ  ARG   171       9.087  59.155  -1.153  1.00 60.97           C  
ATOM   1165  NH1 ARG   171       9.718  59.190   0.027  1.00 59.89           N  
ATOM   1166  NH2 ARG   171       9.385  60.056  -2.088  1.00 61.23           N  
ATOM   1167  N   THR   172       8.104  53.136  -3.502  1.00 39.89           N  
ATOM   1168  CA  THR   172       7.400  52.778  -4.733  1.00 37.54           C  
ATOM   1169  C   THR   172       6.310  53.770  -5.091  1.00 36.45           C  
ATOM   1170  O   THR   172       5.388  53.982  -4.324  1.00 35.85           O  
ATOM   1171  CB  THR   172       6.777  51.374  -4.624  1.00 37.27           C  
ATOM   1172  OG1 THR   172       7.811  50.456  -4.280  1.00 36.73           O  
ATOM   1173  CG2 THR   172       6.129  50.979  -5.942  1.00 37.43           C  
ATOM   1174  N   ASP   173       6.386  54.342  -6.290  1.00 35.89           N  
ATOM   1175  CA  ASP   173       5.430  55.349  -6.699  1.00 35.73           C  
ATOM   1176  C   ASP   173       4.100  54.712  -7.127  1.00 35.45           C  
ATOM   1177  O   ASP   173       4.050  53.928  -8.081  1.00 34.18           O  
ATOM   1178  CB  ASP   173       6.040  56.182  -7.820  1.00 36.16           C  
ATOM   1179  CG  ASP   173       5.205  57.399  -8.183  1.00 37.67           C  
ATOM   1180  OD1 ASP   173       4.108  57.608  -7.606  1.00 38.56           O  
ATOM   1181  OD2 ASP   173       5.674  58.164  -9.053  1.00 40.65           O  
END
