
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  172 ( 1347),  selected  172 , name 1xhn_A
# Molecule2: number of CA atoms  234 ( 1778),  selected  234 , name T0506.pdb
# PARAMETERS: 1xhn_A.T0506.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    11_A      V       4           -
LGA    S    12_A      A       5           -
LGA    L    13_A      P       6           -
LGA    P    14_A      P       7           -
LGA    P    15_A      V       8           -
LGA    -       -      I       9           -
LGA    -       -      T      10           -
LGA    -       -      P      11           -
LGA    -       -      R      12           -
LGA    R    16_A      F      24          2.212
LGA    E    17_A      E      25          1.416
LGA    D    18_A      A      26          4.074
LGA    A    19_A      V      27          1.915
LGA    A    20_A      -       -           -
LGA    R    21_A      R      28          2.497
LGA    V    22_A      V      29          1.971
LGA    A    23_A      A      30          1.817
LGA    R    24_A      R      31          2.047
LGA    F    25_A      D      32          1.274
LGA    V    26_A      V      33          0.969
LGA    T    27_A      L      34          1.975
LGA    H    28_A      H      35          1.754
LGA    V    29_A      T      36          1.408
LGA    S    30_A      S      37          1.434
LGA    D    31_A      R      38          1.409
LGA    W    32_A      T      39          1.672
LGA    G    33_A      A      40          0.659
LGA    A    34_A      A      41          0.686
LGA    L    35_A      L      42          0.529
LGA    A    36_A      A      43          0.806
LGA    T    37_A      T      44          0.946
LGA    I    38_A      L      45          0.917
LGA    S    39_A      D      46          1.589
LGA    T    40_A      P      47          3.262
LGA    L    41_A      V      48           #
LGA    E    42_A      -       -           -
LGA    A    43_A      -       -           -
LGA    V    44_A      -       -           -
LGA    R    45_A      S      49          1.729
LGA    G    46_A      G      50          1.033
LGA    R    47_A      Y      51          0.598
LGA    P    48_A      P      52          1.071
LGA    F    49_A      Y      53          1.177
LGA    A    50_A      T      54          1.017
LGA    D    51_A      T      55          0.677
LGA    V    52_A      A      56          0.741
LGA    L    53_A      T      57          1.033
LGA    S    54_A      N      58          1.443
LGA    L    55_A      I      59          1.642
LGA    S    56_A      G      60          1.289
LGA    D    57_A      I      61          0.900
LGA    G    58_A      E      62          5.001
LGA    P    59_A      -       -           -
LGA    P    60_A      -       -           -
LGA    G    61_A      -       -           -
LGA    A    62_A      -       -           -
LGA    G    63_A      P      63          5.469
LGA    S    64_A      D      64          3.859
LGA    G    65_A      G      65          2.191
LGA    V    66_A      T      66          1.441
LGA    P    67_A      P      67          1.391
LGA    Y    68_A      F      68          1.263
LGA    F    69_A      F      69          0.986
LGA    Y    70_A      F      70          1.520
LGA    L    71_A      A      71          1.607
LGA    S    72_A      A      72          2.015
LGA    P    73_A      G      73          1.740
LGA    L    74_A      L      74          0.542
LGA    Q    75_A      T      75          1.103
LGA    L    76_A      L      76          1.038
LGA    S    77_A      H      77          0.592
LGA    V    78_A      A      78          0.666
LGA    S    79_A      R      79          0.624
LGA    N    80_A      N      80          0.551
LGA    L    81_A      M      81          0.556
LGA    Q    82_A      E      82          0.783
LGA    E    83_A      T      83          0.821
LGA    N    84_A      D      84          0.748
LGA    P    85_A      A      85          0.400
LGA    Y    86_A      R      86          0.192
LGA    A    87_A      I      87          0.271
LGA    T    88_A      S      88          0.339
LGA    L    89_A      V      89          0.240
LGA    T    90_A      T      90          0.412
LGA    X    91_A      L      91          1.473
LGA    T    92_A      A      92          1.693
LGA    L    93_A      P      93          2.200
LGA    A    94_A      -       -           -
LGA    Q    95_A      F      94          0.921
LGA    T    96_A      G      95          2.415
LGA    N    97_A      K      96          2.035
LGA    F    98_A      -       -           -
LGA    C    99_A      G      97          4.702
LGA    K   100_A      -       -           -
LGA    K   101_A      -       -           -
LGA    H   102_A      -       -           -
LGA    G   103_A      -       -           -
LGA    F   104_A      -       -           -
LGA    D   105_A      D      98          5.362
LGA    P   106_A      A      99          2.730
LGA    Q   107_A      L     100          1.821
LGA    S   108_A      -       -           -
LGA    P   109_A      -       -           -
LGA    L   110_A      T     101           #
LGA    C   111_A      L     102          1.907
LGA    V   112_A      P     103          0.419
LGA    H   113_A      R     104          0.384
LGA    I   114_A      L     105          0.696
LGA    X   115_A      T     106          0.304
LGA    L   116_A      L     107          0.494
LGA    S   117_A      V     108          0.615
LGA    G   118_A      G     109          0.433
LGA    T   119_A      R     110          0.591
LGA    V   120_A      A     111          0.542
LGA    T   121_A      D     112          1.628
LGA    K   122_A      R     113          1.035
LGA    V   123_A      I     114          0.604
LGA    N   124_A      G     115          2.587
LGA    E   125_A      P     116          4.036
LGA    T   126_A      D     117          4.804
LGA    E   127_A      E     118          3.513
LGA    X   128_A      V     119          2.748
LGA    D   129_A      P     120          3.753
LGA    I   130_A      L     121          3.511
LGA    A   131_A      A     122          1.887
LGA    K   132_A      I     123          1.754
LGA    H   133_A      A     124          2.180
LGA    S   134_A      R     125          1.847
LGA    L   135_A      Y     126          0.789
LGA    F   136_A      I     127          1.180
LGA    I   137_A      A     128          0.889
LGA    R   138_A      R     129          0.732
LGA    H   139_A      Y     130          1.031
LGA    P   140_A      P     131          1.370
LGA    E   141_A      K     132          1.370
LGA    X   142_A      A     133          1.491
LGA    K   143_A      K     134          1.724
LGA    T   144_A      L     135          1.164
LGA    W   145_A      Y     136          1.719
LGA    -       -      L     137           -
LGA    P   146_A      S     138          4.702
LGA    S   147_A      L     139          2.806
LGA    S   148_A      P     140          2.444
LGA    H   149_A      -       -           -
LGA    N   150_A      D     141          0.948
LGA    W   151_A      T     142          0.424
LGA    F   152_A      R     143          2.258
LGA    F   153_A      L     144          1.702
LGA    A   154_A      Y     145          1.138
LGA    K   155_A      R     146          0.859
LGA    L   156_A      L     147          0.783
LGA    N   157_A      R     148          0.757
LGA    I   158_A      T     149          0.583
LGA    T   159_A      E     150          0.938
LGA    N   160_A      G     151          0.688
LGA    I   161_A      V     152          0.713
LGA    W   162_A      Q     153          0.637
LGA    V   163_A      I     154          0.666
LGA    L   164_A      N     155          0.903
LGA    D   165_A      G     156          3.820
LGA    Y   166_A      -       -           -
LGA    F   167_A      -       -           -
LGA    G   168_A      -       -           -
LGA    G   169_A      -       -           -
LGA    P   170_A      -       -           -
LGA    K   171_A      S     163          1.565
LGA    I   172_A      N     164          2.894
LGA    V   173_A      I     165          1.709
LGA    T   174_A      T     166          1.357
LGA    P   175_A      P     167          1.561
LGA    E   176_A      A     168          1.312
LGA    E   177_A      D     169          1.394
LGA    Y   178_A      L     170          0.907
LGA    Y   179_A      R     171          0.630
LGA    N   180_A      T     172          3.512
LGA    V   181_A      D     173           #
LGA    -       -      L     174           -
LGA    -       -      S     175           -
LGA    -       -      G     176           -
LGA    -       -      A     177           -
LGA    -       -      E     178           -
LGA    -       -      E     179           -
LGA    -       -      L     180           -
LGA    -       -      M     181           -
LGA    -       -      A     182           -
LGA    -       -      A     183           -
LGA    -       -      A     184           -
LGA    -       -      E     185           -
LGA    -       -      S     186           -
LGA    -       -      E     187           -
LGA    -       -      A     188           -
LGA    -       -      T     189           -
LGA    -       -      R     190           -
LGA    -       -      L     191           -
LGA    -       -      N     192           -
LGA    -       -      A     193           -
LGA    -       -      I     194           -
LGA    -       -      K     195           -
LGA    -       -      G     196           -
LGA    -       -      E     197           -
LGA    -       -      A     198           -
LGA    -       -      S     199           -
LGA    -       -      R     200           -
LGA    -       -      L     201           -
LGA    -       -      A     202           -
LGA    -       -      V     203           -
LGA    -       -      L     204           -
LGA    -       -      A     205           -
LGA    -       -      G     206           -
LGA    -       -      A     207           -
LGA    -       -      K     208           -
LGA    -       -      T     209           -
LGA    -       -      G     210           -
LGA    -       -      R     211           -
LGA    -       -      W     212           -
LGA    -       -      K     213           -
LGA    -       -      I     214           -
LGA    -       -      T     215           -
LGA    -       -      S     216           -
LGA    -       -      I     217           -
LGA    -       -      D     218           -
LGA    T   182_A      P     219          4.945
LGA    -       -      D     220           -
LGA    -       -      G     221           -
LGA    -       -      I     222           -
LGA    -       -      D     223           -
LGA    -       -      L     224           -
LGA    -       -      A     225           -
LGA    -       -      S     226           -
LGA    -       -      A     227           -
LGA    -       -      S     228           -
LGA    -       -      D     229           -
LGA    -       -      L     230           -
LGA    -       -      A     231           -
LGA    -       -      R     232           -
LGA    -       -      L     233           -
LGA    -       -      W     234           -
LGA    -       -      F     235           -
LGA    -       -      A     236           -
LGA    -       -      E     237           -
LGA    -       -      R     238           -
LGA    -       -      V     239           -
LGA    -       -      E     240           -
LGA    -       -      T     241           -
LGA    -       -      L     242           -
LGA    -       -      K     243           -
LGA    -       -      Q     244           -
LGA    -       -      F     245           -
LGA    -       -      E     246           -
LGA    -       -      K     247           -
LGA    -       -      A     248           -
LGA    -       -      L     249           -
LGA    -       -      A     250           -
LGA    -       -      Q     251           -
LGA    -       -      L     252           -
LGA    -       -      L     253           -
LGA    -       -      K     254           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  172  234    5.0    141    1.96    22.70     53.512     6.850

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.835805 * X  +   0.116372 * Y  +  -0.536552 * Z  +  49.405170
  Y_new =  -0.531500 * X  +   0.073461 * Y  +   0.843867 * Z  +  61.653255
  Z_new =   0.137618 * X  +   0.990485 * Y  +   0.000452 * Z  + -83.715408 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.570340   -1.571253  [ DEG:    89.9738    -90.0262 ]
  Theta =  -0.138056   -3.003536  [ DEG:    -7.9101   -172.0900 ]
  Phi   =  -2.575184    0.566409  [ DEG:  -147.5472     32.4528 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1xhn_A                                        
REMARK     2: T0506.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1xhn_A.T0506.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  172  234   5.0  141   1.96   22.70  53.512
REMARK  ---------------------------------------------------------- 
MOLECULE 1xhn_A
HEADER    UNKNOWN FUNCTION                        20-SEP-04   1XHN              
TITLE     THE CRYSTAL STRUCTURE OF CELLULAR REPRESSOR OF E1A-                   
TITLE    2 STIMULATED GENES (CREG)                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CELLULAR REPRESSOR OF E1A-STIMULATED GENES;                
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 FRAGMENT: RESIDUES 13-184;                                           
COMPND   5 SYNONYM: CREG;                                                       
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    BETA-BARREL                                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.SACHER,V.V.LUNIN,M.CYGLER                                           
REVDAT   2   10-JAN-06 1XHN    1       JRNL                                     
REVDAT   1   15-NOV-05 1XHN    0                                                
JRNL        AUTH   M.SACHER,A.DI BACCO,V.V.LUNIN,Z.YE,J.WAGNER,G.GILL,          
JRNL        AUTH 2 M.CYGLER                                                     
JRNL        TITL   THE CRYSTAL STRUCTURE OF CREG, A SECRETED                    
JRNL        TITL 2 GLYCOPROTEIN INVOLVED IN CELLULAR GROWTH AND                 
JRNL        TITL 3 DIFFERENTIATION                                              
JRNL        REF    PROC.NATL.ACAD.SCI.USA        V. 102 18326 2005              
JRNL        REFN   ASTM PNASA6  US ISSN 0027-8424                               
REMARK   2 RESOLUTION. 1.95 ANGSTROMS.                                          
DBREF  1XHN A   13   184  UNP    O75629   CREG1_HUMAN     49    220             
DBREF  1XHN B   13   184  UNP    O75629   CREG1_HUMAN     49    220             
DBREF  1XHN C   13   184  UNP    O75629   CREG1_HUMAN     49    220             
DBREF  1XHN D   13   184  UNP    O75629   CREG1_HUMAN     49    220             
SEQRES   1 A  184  MSE GLY SER SER HIS HIS HIS HIS HIS HIS GLY SER LEU          
SEQRES   2 A  184  PRO PRO ARG GLU ASP ALA ALA ARG VAL ALA ARG PHE VAL          
SEQRES   3 A  184  THR HIS VAL SER ASP TRP GLY ALA LEU ALA THR ILE SER          
SEQRES   4 A  184  THR LEU GLU ALA VAL ARG GLY ARG PRO PHE ALA ASP VAL          
SEQRES   5 A  184  LEU SER LEU SER ASP GLY PRO PRO GLY ALA GLY SER GLY          
SEQRES   6 A  184  VAL PRO TYR PHE TYR LEU SER PRO LEU GLN LEU SER VAL          
SEQRES   7 A  184  SER ASN LEU GLN GLU ASN PRO TYR ALA THR LEU THR MSE          
SEQRES   8 A  184  THR LEU ALA GLN THR ASN PHE CYS LYS LYS HIS GLY PHE          
SEQRES   9 A  184  ASP PRO GLN SER PRO LEU CYS VAL HIS ILE MSE LEU SER          
SEQRES  10 A  184  GLY THR VAL THR LYS VAL ASN GLU THR GLU MSE ASP ILE          
SEQRES  11 A  184  ALA LYS HIS SER LEU PHE ILE ARG HIS PRO GLU MSE LYS          
SEQRES  12 A  184  THR TRP PRO SER SER HIS ASN TRP PHE PHE ALA LYS LEU          
SEQRES  13 A  184  ASN ILE THR ASN ILE TRP VAL LEU ASP TYR PHE GLY GLY          
SEQRES  14 A  184  PRO LYS ILE VAL THR PRO GLU GLU TYR TYR ASN VAL THR          
SEQRES  15 A  184  VAL GLN                                                      
SEQRES   1 B  184  MSE GLY SER SER HIS HIS HIS HIS HIS HIS GLY SER LEU          
SEQRES   2 B  184  PRO PRO ARG GLU ASP ALA ALA ARG VAL ALA ARG PHE VAL          
SEQRES   3 B  184  THR HIS VAL SER ASP TRP GLY ALA LEU ALA THR ILE SER          
SEQRES   4 B  184  THR LEU GLU ALA VAL ARG GLY ARG PRO PHE ALA ASP VAL          
SEQRES   5 B  184  LEU SER LEU SER ASP GLY PRO PRO GLY ALA GLY SER GLY          
SEQRES   6 B  184  VAL PRO TYR PHE TYR LEU SER PRO LEU GLN LEU SER VAL          
SEQRES   7 B  184  SER ASN LEU GLN GLU ASN PRO TYR ALA THR LEU THR MSE          
SEQRES   8 B  184  THR LEU ALA GLN THR ASN PHE CYS LYS LYS HIS GLY PHE          
SEQRES   9 B  184  ASP PRO GLN SER PRO LEU CYS VAL HIS ILE MSE LEU SER          
SEQRES  10 B  184  GLY THR VAL THR LYS VAL ASN GLU THR GLU MSE ASP ILE          
SEQRES  11 B  184  ALA LYS HIS SER LEU PHE ILE ARG HIS PRO GLU MSE LYS          
SEQRES  12 B  184  THR TRP PRO SER SER HIS ASN TRP PHE PHE ALA LYS LEU          
SEQRES  13 B  184  ASN ILE THR ASN ILE TRP VAL LEU ASP TYR PHE GLY GLY          
SEQRES  14 B  184  PRO LYS ILE VAL THR PRO GLU GLU TYR TYR ASN VAL THR          
SEQRES  15 B  184  VAL GLN                                                      
SEQRES   1 C  184  MSE GLY SER SER HIS HIS HIS HIS HIS HIS GLY SER LEU          
SEQRES   2 C  184  PRO PRO ARG GLU ASP ALA ALA ARG VAL ALA ARG PHE VAL          
SEQRES   3 C  184  THR HIS VAL SER ASP TRP GLY ALA LEU ALA THR ILE SER          
SEQRES   4 C  184  THR LEU GLU ALA VAL ARG GLY ARG PRO PHE ALA ASP VAL          
SEQRES   5 C  184  LEU SER LEU SER ASP GLY PRO PRO GLY ALA GLY SER GLY          
SEQRES   6 C  184  VAL PRO TYR PHE TYR LEU SER PRO LEU GLN LEU SER VAL          
SEQRES   7 C  184  SER ASN LEU GLN GLU ASN PRO TYR ALA THR LEU THR MSE          
SEQRES   8 C  184  THR LEU ALA GLN THR ASN PHE CYS LYS LYS HIS GLY PHE          
SEQRES   9 C  184  ASP PRO GLN SER PRO LEU CYS VAL HIS ILE MSE LEU SER          
SEQRES  10 C  184  GLY THR VAL THR LYS VAL ASN GLU THR GLU MSE ASP ILE          
SEQRES  11 C  184  ALA LYS HIS SER LEU PHE ILE ARG HIS PRO GLU MSE LYS          
SEQRES  12 C  184  THR TRP PRO SER SER HIS ASN TRP PHE PHE ALA LYS LEU          
SEQRES  13 C  184  ASN ILE THR ASN ILE TRP VAL LEU ASP TYR PHE GLY GLY          
SEQRES  14 C  184  PRO LYS ILE VAL THR PRO GLU GLU TYR TYR ASN VAL THR          
SEQRES  15 C  184  VAL GLN                                                      
SEQRES   1 D  184  MSE GLY SER SER HIS HIS HIS HIS HIS HIS GLY SER LEU          
SEQRES   2 D  184  PRO PRO ARG GLU ASP ALA ALA ARG VAL ALA ARG PHE VAL          
SEQRES   3 D  184  THR HIS VAL SER ASP TRP GLY ALA LEU ALA THR ILE SER          
SEQRES   4 D  184  THR LEU GLU ALA VAL ARG GLY ARG PRO PHE ALA ASP VAL          
SEQRES   5 D  184  LEU SER LEU SER ASP GLY PRO PRO GLY ALA GLY SER GLY          
SEQRES   6 D  184  VAL PRO TYR PHE TYR LEU SER PRO LEU GLN LEU SER VAL          
SEQRES   7 D  184  SER ASN LEU GLN GLU ASN PRO TYR ALA THR LEU THR MSE          
SEQRES   8 D  184  THR LEU ALA GLN THR ASN PHE CYS LYS LYS HIS GLY PHE          
SEQRES   9 D  184  ASP PRO GLN SER PRO LEU CYS VAL HIS ILE MSE LEU SER          
SEQRES  10 D  184  GLY THR VAL THR LYS VAL ASN GLU THR GLU MSE ASP ILE          
SEQRES  11 D  184  ALA LYS HIS SER LEU PHE ILE ARG HIS PRO GLU MSE LYS          
SEQRES  12 D  184  THR TRP PRO SER SER HIS ASN TRP PHE PHE ALA LYS LEU          
SEQRES  13 D  184  ASN ILE THR ASN ILE TRP VAL LEU ASP TYR PHE GLY GLY          
SEQRES  14 D  184  PRO LYS ILE VAL THR PRO GLU GLU TYR TYR ASN VAL THR          
SEQRES  15 D  184  VAL GLN                                                      
HET    MSE  A  91       8                                                       
HET    MSE  A 115       8                                                       
HET    MSE  A 128      12                                                       
HET    MSE  A 142       8                                                       
HET    MSE  B  91       8                                                       
HET    MSE  B 115       8                                                       
HET    MSE  B 128      11                                                       
HET    MSE  B 142       8                                                       
HET    MSE  C  91       8                                                       
HET    MSE  C 115       8                                                       
HET    MSE  C 128      12                                                       
HET    MSE  C 142       8                                                       
HET    MSE  D  91       8                                                       
HET    MSE  D 115       8                                                       
HET    MSE  D 128       8                                                       
HET    MSE  D 142       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    16(C5 H11 N O2 SE)                                           
FORMUL   5  HOH   *892(H2 O)                                                    
CRYST1  106.130  121.260   55.920  90.00  90.00  90.00 P 21 21 2    16          
ATOM      1  N   GLY A  11      13.292  35.583  -6.550  1.00 33.92           N  
ATOM      2  CA  GLY A  11      13.613  36.552  -5.437  1.00 32.27           C  
ATOM      3  C   GLY A  11      15.103  36.816  -5.307  1.00 31.41           C  
ATOM      4  O   GLY A  11      15.706  36.534  -4.252  1.00 32.68           O  
ATOM      5  N   SER A  12      15.727  37.332  -6.366  1.00 29.73           N  
ATOM      6  CA  SER A  12      17.185  37.567  -6.324  1.00 27.90           C  
ATOM      7  C   SER A  12      17.598  39.044  -6.149  1.00 24.80           C  
ATOM      8  O   SER A  12      16.818  39.959  -6.402  1.00 23.13           O  
ATOM      9  CB  SER A  12      17.908  36.925  -7.522  1.00 28.33           C  
ATOM     10  OG  SER A  12      17.184  37.104  -8.725  1.00 32.42           O  
ATOM     11  N   LEU A  13      18.840  39.248  -5.705  1.00 22.37           N  
ATOM     12  CA  LEU A  13      19.333  40.589  -5.391  1.00 20.39           C  
ATOM     13  C   LEU A  13      19.348  41.463  -6.642  1.00 18.51           C  
ATOM     14  O   LEU A  13      19.877  41.048  -7.672  1.00 18.09           O  
ATOM     15  CB  LEU A  13      20.754  40.515  -4.794  1.00 19.27           C  
ATOM     16  CG  LEU A  13      21.360  41.811  -4.268  1.00 19.41           C  
ATOM     17  CD1 LEU A  13      20.670  42.285  -3.023  1.00 16.84           C  
ATOM     18  CD2 LEU A  13      22.875  41.680  -4.051  1.00 19.52           C  
ATOM     19  N   PRO A  14      18.781  42.662  -6.562  1.00 17.20           N  
ATOM     20  CA  PRO A  14      18.845  43.583  -7.704  1.00 17.11           C  
ATOM     21  C   PRO A  14      20.268  44.062  -8.016  1.00 15.27           C  
ATOM     22  O   PRO A  14      21.176  43.839  -7.184  1.00 14.54           O  
ATOM     23  CB  PRO A  14      17.975  44.776  -7.255  1.00 16.99           C  
ATOM     24  CG  PRO A  14      17.094  44.202  -6.159  1.00 18.23           C  
ATOM     25  CD  PRO A  14      18.032  43.251  -5.431  1.00 16.97           C  
ATOM     26  N   PRO A  15      20.463  44.733  -9.153  1.00 14.97           N  
ATOM     27  CA  PRO A  15      21.791  45.300  -9.493  1.00 14.88           C  
ATOM     28  C   PRO A  15      22.247  46.215  -8.390  1.00 13.94           C  
ATOM     29  O   PRO A  15      21.484  47.081  -7.952  1.00 13.45           O  
ATOM     30  CB  PRO A  15      21.538  46.066 -10.820  1.00 14.67           C  
ATOM     31  CG  PRO A  15      20.374  45.328 -11.449  1.00 16.30           C  
ATOM     32  CD  PRO A  15      19.473  45.008 -10.218  1.00 15.15           C  
ATOM     33  N   ARG A  16      23.476  46.009  -7.927  1.00 13.91           N  
ATOM     34  CA  ARG A  16      23.997  46.737  -6.793  1.00 13.21           C  
ATOM     35  C   ARG A  16      24.083  48.249  -7.041  1.00 13.50           C  
ATOM     36  O   ARG A  16      23.921  49.045  -6.088  1.00 13.25           O  
ATOM     37  CB  ARG A  16      25.333  46.133  -6.378  1.00 12.46           C  
ATOM     38  CG  ARG A  16      25.138  44.741  -5.708  1.00 14.15           C  
ATOM     39  CD  ARG A  16      26.466  44.093  -5.406  1.00 10.35           C  
ATOM     40  NE  ARG A  16      26.416  42.721  -4.893  1.00 13.99           N  
ATOM     41  CZ  ARG A  16      26.309  42.387  -3.601  1.00 14.14           C  
ATOM     42  NH1 ARG A  16      26.155  43.339  -2.660  1.00 10.25           N  
ATOM     43  NH2 ARG A  16      26.327  41.086  -3.257  1.00 10.87           N  
ATOM     44  N   GLU A  17      24.251  48.653  -8.298  1.00 11.99           N  
ATOM     45  CA  GLU A  17      24.242  50.103  -8.628  1.00 14.18           C  
ATOM     46  C   GLU A  17      22.870  50.745  -8.332  1.00 13.82           C  
ATOM     47  O   GLU A  17      22.783  51.953  -8.088  1.00 14.36           O  
ATOM     48  CB  GLU A  17      24.565  50.276 -10.126  0.50 14.46           C  
ATOM     50  CG  GLU A  17      24.703  51.702 -10.630  0.50 18.19           C  
ATOM     52  CD  GLU A  17      23.400  52.275 -11.184  0.50 22.21           C  
ATOM     54  OE1 GLU A  17      22.589  51.512 -11.761  0.50 22.82           O  
ATOM     56  OE2 GLU A  17      23.185  53.513 -11.036  0.50 26.13           O  
ATOM     58  N   ASP A  18      21.809  49.942  -8.354  1.00 13.52           N  
ATOM     59  CA  ASP A  18      20.479  50.487  -8.104  1.00 15.18           C  
ATOM     60  C   ASP A  18      20.245  50.350  -6.617  1.00 14.29           C  
ATOM     61  O   ASP A  18      19.627  49.390  -6.149  1.00 13.71           O  
ATOM     62  CB  ASP A  18      19.415  49.771  -8.925  1.00 16.75           C  
ATOM     63  CG  ASP A  18      18.093  50.572  -9.005  1.00 21.33           C  
ATOM     64  OD1 ASP A  18      17.656  51.246  -8.041  1.00 20.10           O  
ATOM     65  OD2 ASP A  18      17.418  50.582 -10.038  1.00 28.07           O  
ATOM     66  N   ALA A  19      20.828  51.288  -5.878  1.00 13.82           N  
ATOM     67  CA  ALA A  19      20.791  51.218  -4.424  1.00 13.96           C  
ATOM     68  C   ALA A  19      19.322  51.351  -3.932  1.00 12.84           C  
ATOM     69  O   ALA A  19      18.975  50.742  -2.948  1.00 13.70           O  
ATOM     70  CB  ALA A  19      21.703  52.254  -3.784  1.00 13.09           C  
ATOM     71  N   ALA A  20      18.479  52.127  -4.625  1.00 12.09           N  
ATOM     72  CA  ALA A  20      17.062  52.218  -4.238  1.00 11.48           C  
ATOM     73  C   ALA A  20      16.365  50.838  -4.303  1.00 10.79           C  
ATOM     74  O   ALA A  20      15.671  50.416  -3.347  1.00  8.72           O  
ATOM     75  CB  ALA A  20      16.312  53.255  -5.128  1.00 11.88           C  
ATOM     76  N   ARG A  21      16.556  50.142  -5.421  1.00 11.81           N  
ATOM     77  CA  ARG A  21      15.976  48.792  -5.559  1.00 12.77           C  
ATOM     78  C   ARG A  21      16.512  47.807  -4.514  1.00 11.61           C  
ATOM     79  O   ARG A  21      15.752  46.989  -3.961  1.00 12.01           O  
ATOM     80  CB  ARG A  21      16.256  48.215  -6.943  1.00 12.99           C  
ATOM     81  CG  ARG A  21      15.467  48.821  -8.059  1.00 20.29           C  
ATOM     82  CD  ARG A  21      15.702  48.082  -9.389  1.00 24.48           C  
ATOM     83  NE  ARG A  21      15.224  46.709  -9.327  1.00 26.88           N  
ATOM     84  CZ  ARG A  21      15.514  45.773 -10.239  1.00 32.74           C  
ATOM     85  NH1 ARG A  21      16.299  46.068 -11.293  1.00 31.90           N  
ATOM     86  NH2 ARG A  21      15.019  44.540 -10.102  1.00 33.94           N  
ATOM     87  N   VAL A  22      17.835  47.830  -4.314  1.00 10.20           N  
ATOM     88  CA  VAL A  22      18.479  46.999  -3.303  1.00  9.24           C  
ATOM     89  C   VAL A  22      17.939  47.286  -1.908  1.00  9.79           C  
ATOM     90  O   VAL A  22      17.626  46.381  -1.145  1.00  9.07           O  
ATOM     91  CB  VAL A  22      20.026  47.177  -3.326  1.00  9.82           C  
ATOM     92  CG1 VAL A  22      20.693  46.439  -2.151  1.00  8.25           C  
ATOM     93  CG2 VAL A  22      20.588  46.650  -4.646  1.00 10.42           C  
ATOM     94  N   ALA A  23      17.750  48.565  -1.583  1.00  9.16           N  
ATOM     95  CA  ALA A  23      17.225  48.881  -0.275  1.00  9.44           C  
ATOM     96  C   ALA A  23      15.820  48.294  -0.110  1.00  9.68           C  
ATOM     97  O   ALA A  23      15.487  47.720   0.931  1.00  9.67           O  
ATOM     98  CB  ALA A  23      17.189  50.431  -0.072  1.00  8.19           C  
ATOM     99  N   ARG A  24      14.983  48.440  -1.132  1.00 10.03           N  
ATOM    100  CA  ARG A  24      13.654  47.890  -1.054  1.00  9.87           C  
ATOM    101  C   ARG A  24      13.697  46.352  -0.962  1.00  9.93           C  
ATOM    102  O   ARG A  24      12.889  45.726  -0.258  1.00 10.17           O  
ATOM    103  CB  ARG A  24      12.855  48.285  -2.295  1.00 10.13           C  
ATOM    104  CG  ARG A  24      12.325  49.797  -2.271  1.00  8.84           C  
ATOM    105  CD  ARG A  24      11.148  50.088  -1.266  1.00 10.51           C  
ATOM    106  NE  ARG A  24       9.938  49.338  -1.638  1.00 16.47           N  
ATOM    107  CZ  ARG A  24       9.067  49.773  -2.547  1.00 17.26           C  
ATOM    108  NH1 ARG A  24       9.289  50.929  -3.157  1.00 19.82           N  
ATOM    109  NH2 ARG A  24       7.978  49.065  -2.851  1.00 19.87           N  
ATOM    110  N   PHE A  25      14.592  45.733  -1.725  1.00  7.49           N  
ATOM    111  CA  PHE A  25      14.789  44.254  -1.566  1.00  8.49           C  
ATOM    112  C   PHE A  25      15.099  43.775  -0.119  1.00  8.74           C  
ATOM    113  O   PHE A  25      14.447  42.840   0.430  1.00  9.28           O  
ATOM    114  CB  PHE A  25      15.847  43.785  -2.551  1.00  8.05           C  
ATOM    115  CG  PHE A  25      16.171  42.314  -2.451  1.00 10.60           C  
ATOM    116  CD1 PHE A  25      15.397  41.366  -3.126  1.00 14.80           C  
ATOM    117  CD2 PHE A  25      17.198  41.903  -1.612  1.00 13.42           C  
ATOM    118  CE1 PHE A  25      15.659  39.976  -2.984  1.00 15.12           C  
ATOM    119  CE2 PHE A  25      17.511  40.513  -1.460  1.00 16.05           C  
ATOM    120  CZ  PHE A  25      16.735  39.559  -2.164  1.00 14.62           C  
ATOM    121  N   VAL A  26      16.118  44.365   0.478  1.00  9.89           N  
ATOM    122  CA  VAL A  26      16.451  44.140   1.887  1.00  9.70           C  
ATOM    123  C   VAL A  26      15.288  44.399   2.844  1.00 10.97           C  
ATOM    124  O   VAL A  26      15.024  43.566   3.691  1.00 11.27           O  
ATOM    125  CB  VAL A  26      17.664  44.965   2.296  1.00  9.71           C  
ATOM    126  CG1 VAL A  26      17.967  44.810   3.812  1.00  8.34           C  
ATOM    127  CG2 VAL A  26      18.901  44.514   1.435  1.00 10.95           C  
ATOM    128  N   THR A  27      14.631  45.563   2.742  1.00 10.95           N  
ATOM    129  CA  THR A  27      13.489  45.812   3.631  1.00 12.03           C  
ATOM    130  C   THR A  27      12.441  44.697   3.544  1.00 11.23           C  
ATOM    131  O   THR A  27      11.955  44.186   4.571  1.00 12.20           O  
ATOM    132  CB  THR A  27      12.856  47.169   3.330  1.00 10.64           C  
ATOM    133  OG1 THR A  27      13.769  48.207   3.718  1.00  9.03           O  
ATOM    134  CG2 THR A  27      11.621  47.398   4.212  1.00 11.71           C  
ATOM    135  N   HIS A  28      12.066  44.353   2.332  1.00 12.07           N  
ATOM    136  CA  HIS A  28      11.064  43.308   2.120  1.00 12.89           C  
ATOM    137  C   HIS A  28      11.498  41.908   2.588  1.00 13.09           C  
ATOM    138  O   HIS A  28      10.681  41.197   3.174  1.00 13.87           O  
ATOM    139  CB  HIS A  28      10.526  43.315   0.653  1.00 13.93           C  
ATOM    140  CG  HIS A  28       9.379  42.360   0.434  1.00 13.41           C  
ATOM    141  ND1 HIS A  28       8.171  42.481   1.094  1.00 18.30           N  
ATOM    142  CD2 HIS A  28       9.268  41.260  -0.347  1.00 16.99           C  
ATOM    143  CE1 HIS A  28       7.364  41.501   0.727  1.00 15.93           C  
ATOM    144  NE2 HIS A  28       8.012  40.739  -0.140  1.00 18.50           N  
ATOM    145  N   VAL A  29      12.756  41.484   2.364  1.00 13.47           N  
ATOM    146  CA  VAL A  29      13.171  40.130   2.845  1.00 13.93           C  
ATOM    147  C   VAL A  29      13.413  40.027   4.342  1.00 12.73           C  
ATOM    148  O   VAL A  29      13.603  38.929   4.866  1.00 13.83           O  
ATOM    149  CB  VAL A  29      14.415  39.484   2.101  1.00 14.06           C  
ATOM    150  CG1 VAL A  29      14.176  39.353   0.640  1.00 16.45           C  
ATOM    151  CG2 VAL A  29      15.693  40.257   2.348  1.00 12.85           C  
ATOM    152  N   SER A  30      13.431  41.152   5.032  1.00 11.41           N  
ATOM    153  CA  SER A  30      13.725  41.189   6.475  1.00 11.04           C  
ATOM    154  C   SER A  30      12.459  40.968   7.293  1.00 11.77           C  
ATOM    155  O   SER A  30      11.463  41.633   7.036  1.00 11.88           O  
ATOM    156  CB  SER A  30      14.331  42.572   6.820  1.00 11.30           C  
ATOM    157  OG  SER A  30      15.630  42.723   6.157  1.00  8.34           O  
ATOM    158  N   ASP A  31      12.482  40.039   8.247  1.00 10.77           N  
ATOM    159  CA  ASP A  31      11.350  39.878   9.181  1.00 11.50           C  
ATOM    160  C   ASP A  31      11.540  40.633  10.486  1.00 11.81           C  
ATOM    161  O   ASP A  31      10.607  40.727  11.298  1.00 12.13           O  
ATOM    162  CB  ASP A  31      11.075  38.398   9.499  1.00 11.31           C  
ATOM    163  CG  ASP A  31      10.715  37.578   8.247  1.00 16.35           C  
ATOM    164  OD1 ASP A  31      10.131  38.150   7.301  1.00 16.18           O  
ATOM    165  OD2 ASP A  31      11.073  36.374   8.109  1.00 20.63           O  
ATOM    166  N   TRP A  32      12.761  41.140  10.698  1.00  9.29           N  
ATOM    167  CA  TRP A  32      13.115  41.858  11.889  1.00  9.07           C  
ATOM    168  C   TRP A  32      14.299  42.778  11.543  1.00  9.30           C  
ATOM    169  O   TRP A  32      14.915  42.676  10.442  1.00  9.24           O  
ATOM    170  CB  TRP A  32      13.469  40.906  13.038  1.00  9.11           C  
ATOM    171  CG  TRP A  32      14.688  40.014  12.777  1.00 11.44           C  
ATOM    172  CD1 TRP A  32      14.677  38.781  12.162  1.00 13.37           C  
ATOM    173  CD2 TRP A  32      16.073  40.247  13.164  1.00 10.84           C  
ATOM    174  NE1 TRP A  32      15.961  38.278  12.099  1.00  9.17           N  
ATOM    175  CE2 TRP A  32      16.829  39.166  12.695  1.00  8.85           C  
ATOM    176  CE3 TRP A  32      16.749  41.304  13.788  1.00 13.29           C  
ATOM    177  CZ2 TRP A  32      18.239  39.061  12.905  1.00 11.79           C  
ATOM    178  CZ3 TRP A  32      18.144  41.238  13.962  1.00 14.15           C  
ATOM    179  CH2 TRP A  32      18.877  40.100  13.526  1.00 11.96           C  
ATOM    180  N   GLY A  33      14.596  43.677  12.477  1.00  9.95           N  
ATOM    181  CA  GLY A  33      15.746  44.566  12.384  1.00  9.62           C  
ATOM    182  C   GLY A  33      16.147  45.091  13.741  1.00  9.38           C  
ATOM    183  O   GLY A  33      15.543  44.729  14.771  1.00  9.15           O  
ATOM    184  N   ALA A  34      17.204  45.912  13.753  1.00  8.93           N  
ATOM    185  CA  ALA A  34      17.684  46.504  14.967  1.00  8.94           C  
ATOM    186  C   ALA A  34      17.306  47.991  14.902  1.00  9.85           C  
ATOM    187  O   ALA A  34      17.671  48.693  13.954  1.00 10.56           O  
ATOM    188  CB  ALA A  34      19.241  46.317  15.126  1.00  8.21           C  
ATOM    189  N   LEU A  35      16.557  48.458  15.902  1.00 10.11           N  
ATOM    190  CA  LEU A  35      16.222  49.884  15.983  1.00  9.75           C  
ATOM    191  C   LEU A  35      17.066  50.593  17.018  1.00  9.68           C  
ATOM    192  O   LEU A  35      17.177  50.130  18.142  1.00  9.70           O  
ATOM    193  CB  LEU A  35      14.739  50.035  16.318  1.00  9.85           C  
ATOM    194  CG  LEU A  35      14.205  51.445  16.110  1.00  9.12           C  
ATOM    195  CD1 LEU A  35      13.921  51.626  14.610  1.00  8.34           C  
ATOM    196  CD2 LEU A  35      12.931  51.608  16.951  1.00 10.55           C  
ATOM    197  N   ALA A  36      17.655  51.724  16.625  1.00 12.22           N  
ATOM    198  CA  ALA A  36      18.476  52.554  17.526  1.00 11.33           C  
ATOM    199  C   ALA A  36      17.627  53.755  17.955  1.00 11.93           C  
ATOM    200  O   ALA A  36      17.007  54.395  17.102  1.00 11.99           O  
ATOM    201  CB  ALA A  36      19.727  53.058  16.793  1.00 10.41           C  
ATOM    202  N   THR A  37      17.582  53.994  19.271  1.00 11.43           N  
ATOM    203  CA  THR A  37      16.830  55.071  19.906  1.00 13.04           C  
ATOM    204  C   THR A  37      17.771  55.752  20.906  1.00 13.61           C  
ATOM    205  O   THR A  37      18.924  55.304  21.099  1.00 13.36           O  
ATOM    206  CB  THR A  37      15.541  54.590  20.603  1.00 12.13           C  
ATOM    207  OG1 THR A  37      15.809  53.516  21.518  1.00 11.52           O  
ATOM    208  CG2 THR A  37      14.523  54.056  19.595  1.00 14.92           C  
ATOM    209  N   ILE A  38      17.312  56.855  21.489  1.00 14.60           N  
ATOM    210  CA  ILE A  38      18.053  57.473  22.562  1.00 14.09           C  
ATOM    211  C   ILE A  38      17.443  57.033  23.875  1.00 14.45           C  
ATOM    212  O   ILE A  38      16.244  57.153  24.073  1.00 14.05           O  
ATOM    213  CB  ILE A  38      17.991  59.021  22.483  1.00 14.10           C  
ATOM    214  CG1 ILE A  38      18.466  59.588  21.108  1.00 15.88           C  
ATOM    215  CG2 ILE A  38      18.764  59.609  23.681  1.00 13.58           C  
ATOM    216  CD1 ILE A  38      19.857  59.325  20.720  1.00 16.29           C  
ATOM    217  N   SER A  39      18.262  56.526  24.782  1.00 16.15           N  
ATOM    218  CA  SER A  39      17.745  55.953  26.016  1.00 16.83           C  
ATOM    219  C   SER A  39      17.229  57.028  26.957  1.00 17.73           C  
ATOM    220  O   SER A  39      17.896  58.063  27.165  1.00 16.36           O  
ATOM    221  CB  SER A  39      18.811  55.119  26.736  1.00 16.23           C  
ATOM    222  OG  SER A  39      18.182  54.414  27.790  1.00 19.61           O  
ATOM    223  N   THR A  40      16.055  56.738  27.531  1.00 18.70           N  
ATOM    224  CA  THR A  40      15.462  57.559  28.590  1.00 19.89           C  
ATOM    225  C   THR A  40      15.541  56.850  29.945  1.00 20.40           C  
ATOM    226  O   THR A  40      14.939  57.314  30.900  1.00 21.43           O  
ATOM    227  CB  THR A  40      13.956  57.884  28.341  1.00 20.57           C  
ATOM    228  OG1 THR A  40      13.204  56.674  28.274  1.00 19.08           O  
ATOM    229  CG2 THR A  40      13.703  58.623  27.032  1.00 21.14           C  
ATOM    230  N   LEU A  41      16.247  55.724  30.020  1.00 20.37           N  
ATOM    231  CA  LEU A  41      16.513  55.074  31.305  1.00 21.38           C  
ATOM    232  C   LEU A  41      17.462  55.940  32.159  1.00 21.45           C  
ATOM    233  O   LEU A  41      18.516  56.349  31.686  1.00 20.28           O  
ATOM    234  CB  LEU A  41      17.165  53.706  31.111  1.00 20.55           C  
ATOM    235  CG  LEU A  41      16.344  52.540  30.538  1.00 23.71           C  
ATOM    236  CD1 LEU A  41      17.302  51.424  30.102  1.00 23.52           C  
ATOM    237  CD2 LEU A  41      15.268  51.997  31.548  1.00 23.48           C  
ATOM    238  N   GLU A  42      17.097  56.172  33.424  1.00 21.91           N  
ATOM    239  CA  GLU A  42      17.938  56.947  34.346  1.00 21.32           C  
ATOM    240  C   GLU A  42      19.393  56.493  34.308  1.00 20.36           C  
ATOM    241  O   GLU A  42      20.303  57.325  34.217  1.00 19.58           O  
ATOM    242  CB  GLU A  42      17.400  56.812  35.792  1.00 23.24           C  
ATOM    243  CG  GLU A  42      18.220  57.543  36.863  1.00 22.80           C  
ATOM    244  CD  GLU A  42      17.929  59.044  36.806  1.00 28.88           C  
ATOM    245  OE1 GLU A  42      17.304  59.476  35.797  1.00 29.69           O  
ATOM    246  OE2 GLU A  42      18.290  59.780  37.758  1.00 30.38           O  
ATOM    247  N   ALA A  43      19.611  55.179  34.367  1.00 20.00           N  
ATOM    248  CA  ALA A  43      20.983  54.622  34.435  1.00 20.39           C  
ATOM    249  C   ALA A  43      21.874  55.025  33.278  1.00 19.62           C  
ATOM    250  O   ALA A  43      23.124  55.093  33.430  1.00 20.22           O  
ATOM    251  CB  ALA A  43      20.944  53.096  34.558  1.00 20.97           C  
ATOM    252  N   VAL A  44      21.254  55.224  32.105  1.00 18.72           N  
ATOM    253  CA  VAL A  44      21.988  55.457  30.859  1.00 16.60           C  
ATOM    254  C   VAL A  44      21.380  56.558  29.998  1.00 17.01           C  
ATOM    255  O   VAL A  44      21.511  56.530  28.784  1.00 16.45           O  
ATOM    256  CB  VAL A  44      22.148  54.144  30.005  1.00 18.16           C  
ATOM    257  CG1 VAL A  44      23.145  53.202  30.650  1.00 18.28           C  
ATOM    258  CG2 VAL A  44      20.771  53.452  29.698  1.00 14.08           C  
ATOM    259  N   ARG A  45      20.732  57.540  30.632  1.00 14.94           N  
ATOM    260  CA  ARG A  45      19.981  58.533  29.880  1.00 15.99           C  
ATOM    261  C   ARG A  45      20.849  59.268  28.895  1.00 14.37           C  
ATOM    262  O   ARG A  45      21.932  59.670  29.234  1.00 14.50           O  
ATOM    263  CB  ARG A  45      19.281  59.500  30.837  1.00 15.86           C  
ATOM    264  CG  ARG A  45      18.339  60.500  30.195  1.00 15.81           C  
ATOM    265  CD  ARG A  45      17.652  61.411  31.245  1.00 24.23           C  
ATOM    266  NE  ARG A  45      17.078  60.675  32.389  1.00 28.04           N  
ATOM    267  CZ  ARG A  45      15.800  60.287  32.500  1.00 30.31           C  
ATOM    268  NH1 ARG A  45      14.928  60.531  31.518  1.00 33.21           N  
ATOM    269  NH2 ARG A  45      15.397  59.611  33.585  1.00 27.84           N  
ATOM    270  N   GLY A  46      20.362  59.394  27.666  1.00 13.68           N  
ATOM    271  CA  GLY A  46      21.079  60.058  26.597  1.00 13.13           C  
ATOM    272  C   GLY A  46      21.941  59.131  25.742  1.00 13.33           C  
ATOM    273  O   GLY A  46      22.330  59.528  24.648  1.00 12.89           O  
ATOM    274  N   ARG A  47      22.215  57.915  26.227  1.00 13.00           N  
ATOM    275  CA  ARG A  47      23.020  56.941  25.459  1.00 14.62           C  
ATOM    276  C   ARG A  47      22.240  56.327  24.261  1.00 13.75           C  
ATOM    277  O   ARG A  47      20.998  56.172  24.335  1.00 14.03           O  
ATOM    278  CB  ARG A  47      23.557  55.823  26.376  1.00 16.18           C  
ATOM    279  CG  ARG A  47      24.925  56.156  26.974  1.00 20.21           C  
ATOM    280  CD  ARG A  47      25.246  55.607  28.329  1.00 27.71           C  
ATOM    281  NE  ARG A  47      25.674  54.234  28.239  1.00 31.45           N  
ATOM    282  CZ  ARG A  47      26.519  53.602  29.056  1.00 29.11           C  
ATOM    283  NH1 ARG A  47      27.107  54.187  30.094  1.00 27.45           N  
ATOM    284  NH2 ARG A  47      26.762  52.321  28.813  1.00 27.11           N  
ATOM    285  N   PRO A  48      22.937  56.053  23.156  1.00 12.70           N  
ATOM    286  CA  PRO A  48      22.299  55.374  22.018  1.00 14.06           C  
ATOM    287  C   PRO A  48      21.987  53.974  22.476  1.00 13.97           C  
ATOM    288  O   PRO A  48      22.756  53.402  23.250  1.00 14.86           O  
ATOM    289  CB  PRO A  48      23.372  55.392  20.909  1.00 12.94           C  
ATOM    290  CG  PRO A  48      24.641  55.629  21.608  1.00 14.85           C  
ATOM    291  CD  PRO A  48      24.363  56.359  22.891  1.00 12.66           C  
ATOM    292  N   PHE A  49      20.794  53.507  22.145  1.00 13.24           N  
ATOM    293  CA  PHE A  49      20.293  52.218  22.606  1.00 12.87           C  
ATOM    294  C   PHE A  49      19.920  51.461  21.348  1.00 13.10           C  
ATOM    295  O   PHE A  49      19.486  52.104  20.387  1.00 12.06           O  
ATOM    296  CB  PHE A  49      19.014  52.419  23.441  1.00 12.70           C  
ATOM    297  CG  PHE A  49      18.581  51.183  24.194  1.00 15.36           C  
ATOM    298  CD1 PHE A  49      19.329  50.722  25.276  1.00 13.69           C  
ATOM    299  CD2 PHE A  49      17.420  50.498  23.824  1.00 15.87           C  
ATOM    300  CE1 PHE A  49      18.917  49.576  26.007  1.00 17.04           C  
ATOM    301  CE2 PHE A  49      17.010  49.330  24.535  1.00 18.31           C  
ATOM    302  CZ  PHE A  49      17.768  48.886  25.637  1.00 14.43           C  
ATOM    303  N   ALA A  50      20.133  50.131  21.344  1.00 13.21           N  
ATOM    304  CA  ALA A  50      19.761  49.255  20.232  1.00 13.25           C  
ATOM    305  C   ALA A  50      18.858  48.162  20.756  1.00 13.33           C  
ATOM    306  O   ALA A  50      18.934  47.779  21.894  1.00 14.97           O  
ATOM    307  CB  ALA A  50      20.992  48.628  19.570  1.00 12.69           C  
ATOM    308  N   ASP A  51      18.010  47.633  19.894  1.00 14.24           N  
ATOM    309  CA  ASP A  51      16.997  46.653  20.293  1.00 14.83           C  
ATOM    310  C   ASP A  51      16.432  45.958  19.037  1.00 13.50           C  
ATOM    311  O   ASP A  51      16.442  46.537  17.934  1.00 13.72           O  
ATOM    312  CB  ASP A  51      15.894  47.391  21.073  1.00 15.78           C  
ATOM    313  CG  ASP A  51      14.820  46.460  21.650  1.00 20.92           C  
ATOM    314  OD1 ASP A  51      15.081  45.263  21.995  1.00 24.06           O  
ATOM    315  OD2 ASP A  51      13.648  46.880  21.779  1.00 28.07           O  
ATOM    316  N   VAL A  52      15.941  44.735  19.210  1.00 12.37           N  
ATOM    317  CA  VAL A  52      15.497  43.854  18.131  1.00 11.82           C  
ATOM    318  C   VAL A  52      13.978  43.957  18.006  1.00 13.13           C  
ATOM    319  O   VAL A  52      13.267  43.738  18.994  1.00 12.90           O  
ATOM    320  CB  VAL A  52      15.967  42.365  18.415  1.00 12.84           C  
ATOM    321  CG1 VAL A  52      15.364  41.395  17.412  1.00 12.40           C  
ATOM    322  CG2 VAL A  52      17.496  42.291  18.320  1.00 12.96           C  
ATOM    323  N   LEU A  53      13.480  44.384  16.838  1.00 11.65           N  
ATOM    324  CA  LEU A  53      12.041  44.421  16.583  1.00 11.45           C  
ATOM    325  C   LEU A  53      11.655  43.577  15.383  1.00 11.13           C  
ATOM    326  O   LEU A  53      12.332  43.594  14.379  1.00 12.21           O  
ATOM    327  CB  LEU A  53      11.580  45.884  16.342  1.00 11.51           C  
ATOM    328  CG  LEU A  53      11.833  46.913  17.451  1.00 11.78           C  
ATOM    329  CD1 LEU A  53      11.371  48.285  16.906  1.00 17.65           C  
ATOM    330  CD2 LEU A  53      10.977  46.483  18.665  1.00 16.49           C  
ATOM    331  N   SER A  54      10.511  42.904  15.461  1.00 11.39           N  
ATOM    332  CA  SER A  54       9.904  42.295  14.273  1.00 11.15           C  
ATOM    333  C   SER A  54       9.325  43.438  13.378  1.00 10.52           C  
ATOM    334  O   SER A  54       9.011  44.507  13.843  1.00 10.81           O  
ATOM    335  CB  SER A  54       8.790  41.327  14.693  1.00 11.04           C  
ATOM    336  OG  SER A  54       9.309  40.058  15.005  1.00 12.49           O  
ATOM    337  N   LEU A  55       9.286  43.220  12.082  1.00  9.89           N  
ATOM    338  CA  LEU A  55       8.757  44.186  11.134  1.00 10.08           C  
ATOM    339  C   LEU A  55       8.197  43.495   9.906  1.00  9.31           C  
ATOM    340  O   LEU A  55       8.453  42.309   9.691  1.00 10.97           O  
ATOM    341  CB  LEU A  55       9.830  45.201  10.722  1.00  8.88           C  
ATOM    342  CG  LEU A  55      11.119  44.669  10.067  1.00 11.42           C  
ATOM    343  CD1 LEU A  55      11.004  44.934   8.598  1.00 10.40           C  
ATOM    344  CD2 LEU A  55      12.272  45.518  10.618  1.00 10.58           C  
ATOM    345  N   SER A  56       7.443  44.262   9.109  1.00 10.79           N  
ATOM    346  CA  SER A  56       6.968  43.836   7.822  1.00 12.44           C  
ATOM    347  C   SER A  56       6.652  45.036   6.976  1.00 13.14           C  
ATOM    348  O   SER A  56       6.070  46.035   7.467  1.00 12.14           O  
ATOM    349  CB  SER A  56       5.680  42.997   7.952  1.00 12.77           C  
ATOM    350  OG  SER A  56       5.289  42.550   6.671  1.00 13.17           O  
ATOM    351  N   ASP A  57       6.971  44.940   5.691  1.00 12.63           N  
ATOM    352  CA  ASP A  57       6.485  45.964   4.769  1.00 12.20           C  
ATOM    353  C   ASP A  57       5.360  45.475   3.863  1.00 14.49           C  
ATOM    354  O   ASP A  57       5.052  46.137   2.895  1.00 15.51           O  
ATOM    355  CB  ASP A  57       7.630  46.565   3.908  1.00 12.31           C  
ATOM    356  CG  ASP A  57       8.093  45.639   2.813  1.00 10.28           C  
ATOM    357  OD1 ASP A  57       7.921  44.391   2.932  1.00  7.20           O  
ATOM    358  OD2 ASP A  57       8.603  46.073   1.762  1.00 13.94           O  
ATOM    359  N   GLY A  58       4.761  44.325   4.146  1.00 14.81           N  
ATOM    360  CA  GLY A  58       3.763  43.822   3.247  1.00 18.46           C  
ATOM    361  C   GLY A  58       3.783  42.319   3.159  1.00 21.46           C  
ATOM    362  O   GLY A  58       4.761  41.666   3.569  1.00 20.55           O  
ATOM    363  N   PRO A  59       2.701  41.765   2.605  1.00 23.77           N  
ATOM    364  CA  PRO A  59       2.641  40.331   2.318  1.00 26.38           C  
ATOM    365  C   PRO A  59       3.502  39.976   1.107  1.00 28.47           C  
ATOM    366  O   PRO A  59       4.052  40.877   0.456  1.00 28.04           O  
ATOM    367  CB  PRO A  59       1.158  40.091   1.985  1.00 26.50           C  
ATOM    368  CG  PRO A  59       0.659  41.383   1.518  1.00 25.75           C  
ATOM    369  CD  PRO A  59       1.467  42.475   2.212  1.00 23.86           C  
ATOM    370  N   PRO A  60       3.590  38.680   0.789  1.00 30.73           N  
ATOM    371  CA  PRO A  60       4.451  38.177  -0.310  1.00 31.58           C  
ATOM    372  C   PRO A  60       4.107  38.553  -1.775  1.00 33.04           C  
ATOM    373  O   PRO A  60       3.735  37.673  -2.595  1.00 35.16           O  
ATOM    374  CB  PRO A  60       4.413  36.646  -0.105  1.00 31.81           C  
ATOM    375  CG  PRO A  60       3.983  36.473   1.377  1.00 30.60           C  
ATOM    376  CD  PRO A  60       2.914  37.574   1.504  1.00 30.88           C  
ATOM    377  N   GLY A  61       4.285  39.829  -2.121  1.00 32.45           N  
ATOM    378  CA  GLY A  61       4.151  40.308  -3.484  1.00 30.21           C  
ATOM    379  C   GLY A  61       3.617  41.721  -3.419  1.00 29.52           C  
ATOM    380  O   GLY A  61       3.162  42.305  -4.422  1.00 29.41           O  
ATOM    381  N   ALA A  62       3.671  42.276  -2.212  1.00 27.10           N  
ATOM    382  CA  ALA A  62       3.170  43.608  -1.966  1.00 24.90           C  
ATOM    383  C   ALA A  62       4.010  44.335  -0.900  1.00 22.98           C  
ATOM    384  O   ALA A  62       3.468  45.031  -0.001  1.00 20.61           O  
ATOM    385  CB  ALA A  62       1.688  43.543  -1.581  1.00 24.91           C  
ATOM    386  N   GLY A  63       5.343  44.197  -1.012  1.00 21.35           N  
ATOM    387  CA  GLY A  63       6.221  44.921  -0.099  1.00 17.92           C  
ATOM    388  C   GLY A  63       6.295  46.360  -0.503  1.00 17.46           C  
ATOM    389  O   GLY A  63       6.804  46.676  -1.590  1.00 17.94           O  
ATOM    390  N   SER A  64       5.829  47.244   0.365  1.00 16.09           N  
ATOM    391  CA  SER A  64       5.727  48.653   0.035  1.00 15.08           C  
ATOM    392  C   SER A  64       6.980  49.382   0.431  1.00 13.31           C  
ATOM    393  O   SER A  64       7.108  50.536   0.128  1.00 12.19           O  
ATOM    394  CB  SER A  64       4.548  49.285   0.775  1.00 14.34           C  
ATOM    395  OG  SER A  64       4.843  49.383   2.170  1.00 16.34           O  
ATOM    396  N   GLY A  65       7.905  48.724   1.129  1.00 12.46           N  
ATOM    397  CA  GLY A  65       9.051  49.441   1.647  1.00 12.00           C  
ATOM    398  C   GLY A  65       8.816  50.113   2.992  1.00 11.96           C  
ATOM    399  O   GLY A  65       9.757  50.536   3.623  1.00 11.28           O  
ATOM    400  N   VAL A  66       7.564  50.208   3.455  1.00 11.63           N  
ATOM    401  CA  VAL A  66       7.290  50.968   4.688  1.00 11.86           C  
ATOM    402  C   VAL A  66       7.490  50.023   5.864  1.00 11.39           C  
ATOM    403  O   VAL A  66       6.806  49.020   5.894  1.00 10.68           O  
ATOM    404  CB  VAL A  66       5.795  51.418   4.798  1.00 11.80           C  
ATOM    405  CG1 VAL A  66       5.563  52.010   6.187  1.00 11.35           C  
ATOM    406  CG2 VAL A  66       5.401  52.449   3.659  1.00 11.70           C  
ATOM    407  N   PRO A  67       8.427  50.277   6.791  1.00 11.97           N  
ATOM    408  CA  PRO A  67       8.611  49.335   7.890  1.00 12.23           C  
ATOM    409  C   PRO A  67       7.461  49.515   8.910  1.00 11.68           C  
ATOM    410  O   PRO A  67       7.441  50.546   9.539  1.00 13.16           O  
ATOM    411  CB  PRO A  67       9.966  49.759   8.507  1.00 11.62           C  
ATOM    412  CG  PRO A  67      10.651  50.680   7.425  1.00 13.07           C  
ATOM    413  CD  PRO A  67       9.396  51.397   6.879  1.00 12.93           C  
ATOM    414  N   TYR A  68       6.582  48.525   9.071  1.00 11.59           N  
ATOM    415  CA  TYR A  68       5.557  48.577  10.118  1.00 12.06           C  
ATOM    416  C   TYR A  68       6.056  47.782  11.302  1.00 11.51           C  
ATOM    417  O   TYR A  68       6.742  46.792  11.108  1.00 12.32           O  
ATOM    418  CB  TYR A  68       4.236  47.948   9.652  1.00 10.61           C  
ATOM    419  CG  TYR A  68       3.577  48.745   8.535  1.00 13.98           C  
ATOM    420  CD1 TYR A  68       3.065  50.039   8.774  1.00 13.35           C  
ATOM    421  CD2 TYR A  68       3.501  48.220   7.238  1.00 16.02           C  
ATOM    422  CE1 TYR A  68       2.489  50.774   7.749  1.00 14.94           C  
ATOM    423  CE2 TYR A  68       2.910  48.969   6.185  1.00 15.98           C  
ATOM    424  CZ  TYR A  68       2.428  50.235   6.467  1.00 15.37           C  
ATOM    425  OH  TYR A  68       1.867  50.963   5.443  1.00 17.29           O  
ATOM    426  N   PHE A  69       5.688  48.219  12.503  1.00 11.64           N  
ATOM    427  CA  PHE A  69       6.059  47.536  13.740  1.00 11.88           C  
ATOM    428  C   PHE A  69       4.777  47.303  14.558  1.00 12.91           C  
ATOM    429  O   PHE A  69       3.827  48.117  14.471  1.00 10.73           O  
ATOM    430  CB  PHE A  69       6.978  48.431  14.585  1.00 11.14           C  
ATOM    431  CG  PHE A  69       8.212  48.947  13.851  1.00 12.53           C  
ATOM    432  CD1 PHE A  69       9.244  48.078  13.492  1.00 13.41           C  
ATOM    433  CD2 PHE A  69       8.321  50.298  13.520  1.00 14.40           C  
ATOM    434  CE1 PHE A  69      10.383  48.541  12.805  1.00 14.54           C  
ATOM    435  CE2 PHE A  69       9.458  50.773  12.846  1.00 14.33           C  
ATOM    436  CZ  PHE A  69      10.491  49.905  12.496  1.00 14.27           C  
ATOM    437  N   TYR A  70       4.798  46.273  15.414  1.00 11.77           N  
ATOM    438  CA  TYR A  70       3.762  46.115  16.434  1.00 12.53           C  
ATOM    439  C   TYR A  70       4.391  46.228  17.823  1.00 12.43           C  
ATOM    440  O   TYR A  70       5.147  45.325  18.250  1.00 12.93           O  
ATOM    441  CB  TYR A  70       3.164  44.731  16.253  1.00 11.14           C  
ATOM    442  CG  TYR A  70       1.802  44.467  16.870  1.00 14.49           C  
ATOM    443  CD1 TYR A  70       0.755  45.346  16.712  1.00 14.82           C  
ATOM    444  CD2 TYR A  70       1.554  43.251  17.523  1.00 13.47           C  
ATOM    445  CE1 TYR A  70      -0.501  45.064  17.267  1.00 15.38           C  
ATOM    446  CE2 TYR A  70       0.306  42.963  18.046  1.00 15.02           C  
ATOM    447  CZ  TYR A  70      -0.713  43.864  17.906  1.00 18.72           C  
ATOM    448  OH  TYR A  70      -1.956  43.556  18.454  1.00 19.24           O  
ATOM    449  N   LEU A  71       4.058  47.306  18.515  1.00 12.20           N  
ATOM    450  CA  LEU A  71       4.787  47.772  19.676  1.00 12.92           C  
ATOM    451  C   LEU A  71       3.913  47.915  20.913  1.00 14.90           C  
ATOM    452  O   LEU A  71       2.707  48.191  20.797  1.00 15.75           O  
ATOM    453  CB  LEU A  71       5.404  49.145  19.348  1.00 12.65           C  
ATOM    454  CG  LEU A  71       6.349  49.184  18.126  1.00 13.06           C  
ATOM    455  CD1 LEU A  71       6.863  50.610  17.964  1.00 14.50           C  
ATOM    456  CD2 LEU A  71       7.536  48.198  18.330  1.00 13.55           C  
ATOM    457  N   SER A  72       4.540  47.848  22.092  1.00 15.45           N  
ATOM    458  CA  SER A  72       3.824  48.029  23.358  1.00 15.62           C  
ATOM    459  C   SER A  72       4.494  49.140  24.159  1.00 16.26           C  
ATOM    460  O   SER A  72       5.722  49.264  24.080  1.00 14.97           O  
ATOM    461  CB  SER A  72       3.882  46.717  24.137  1.00 15.56           C  
ATOM    462  OG  SER A  72       3.668  46.959  25.506  1.00 16.71           O  
ATOM    463  N   PRO A  73       3.718  49.982  24.864  1.00 17.88           N  
ATOM    464  CA  PRO A  73       4.297  50.983  25.780  1.00 19.24           C  
ATOM    465  C   PRO A  73       5.243  50.374  26.826  1.00 19.84           C  
ATOM    466  O   PRO A  73       6.096  51.096  27.333  1.00 21.41           O  
ATOM    467  CB  PRO A  73       3.075  51.580  26.477  1.00 19.83           C  
ATOM    468  CG  PRO A  73       1.983  51.446  25.495  1.00 19.61           C  
ATOM    469  CD  PRO A  73       2.245  50.091  24.818  1.00 18.03           C  
ATOM    470  N   LEU A  74       5.097  49.090  27.152  1.00 19.63           N  
ATOM    471  CA  LEU A  74       6.028  48.412  28.056  1.00 19.85           C  
ATOM    472  C   LEU A  74       7.472  48.241  27.501  1.00 19.85           C  
ATOM    473  O   LEU A  74       8.417  47.972  28.266  1.00 20.00           O  
ATOM    474  CB  LEU A  74       5.460  47.056  28.478  1.00 20.52           C  
ATOM    475  CG  LEU A  74       4.099  47.095  29.194  1.00 22.86           C  
ATOM    476  CD1 LEU A  74       3.724  45.657  29.433  1.00 22.17           C  
ATOM    477  CD2 LEU A  74       4.181  47.883  30.519  1.00 24.58           C  
ATOM    478  N   GLN A  75       7.658  48.385  26.194  1.00 17.90           N  
ATOM    479  CA  GLN A  75       9.000  48.138  25.635  1.00 16.84           C  
ATOM    480  C   GLN A  75       9.953  49.302  25.860  1.00 16.57           C  
ATOM    481  O   GLN A  75       9.552  50.482  25.791  1.00 15.27           O  
ATOM    482  CB  GLN A  75       8.937  47.851  24.146  1.00 15.54           C  
ATOM    483  CG  GLN A  75       8.367  46.501  23.774  1.00 16.63           C  
ATOM    484  CD  GLN A  75       8.177  46.423  22.256  1.00 20.08           C  
ATOM    485  OE1 GLN A  75       7.148  46.826  21.761  1.00 17.67           O  
ATOM    486  NE2 GLN A  75       9.220  45.990  21.523  1.00 18.62           N  
ATOM    487  N   LEU A  76      11.218  48.971  26.129  1.00 15.05           N  
ATOM    488  CA  LEU A  76      12.277  49.993  26.283  1.00 15.38           C  
ATOM    489  C   LEU A  76      12.336  50.903  25.053  1.00 14.75           C  
ATOM    490  O   LEU A  76      12.498  52.126  25.189  1.00 13.00           O  
ATOM    491  CB  LEU A  76      13.640  49.304  26.483  1.00 16.78           C  
ATOM    492  CG  LEU A  76      13.840  48.652  27.886  1.00 19.38           C  
ATOM    493  CD1 LEU A  76      15.265  48.167  28.095  1.00 22.26           C  
ATOM    494  CD2 LEU A  76      13.488  49.614  28.997  1.00 22.90           C  
ATOM    495  N   SER A  77      12.199  50.340  23.839  1.00 13.54           N  
ATOM    496  CA  SER A  77      12.299  51.213  22.660  1.00 14.67           C  
ATOM    497  C   SER A  77      11.182  52.250  22.622  1.00 13.75           C  
ATOM    498  O   SER A  77      11.420  53.394  22.213  1.00 14.19           O  
ATOM    499  CB  SER A  77      12.364  50.458  21.338  1.00 13.48           C  
ATOM    500  OG  SER A  77      13.582  49.699  21.273  1.00 21.24           O  
ATOM    501  N   VAL A  78       9.986  51.840  23.046  1.00 13.76           N  
ATOM    502  CA  VAL A  78       8.771  52.682  22.972  1.00 14.75           C  
ATOM    503  C   VAL A  78       8.844  53.793  24.040  1.00 15.36           C  
ATOM    504  O   VAL A  78       8.553  54.978  23.773  1.00 15.52           O  
ATOM    505  CB  VAL A  78       7.447  51.821  23.108  1.00 14.53           C  
ATOM    506  CG1 VAL A  78       6.202  52.686  23.186  1.00 13.25           C  
ATOM    507  CG2 VAL A  78       7.274  50.867  21.918  1.00 14.87           C  
ATOM    508  N   SER A  79       9.262  53.437  25.258  1.00 16.33           N  
ATOM    509  CA  SER A  79       9.494  54.490  26.246  1.00 16.89           C  
ATOM    510  C   SER A  79      10.519  55.547  25.724  1.00 16.93           C  
ATOM    511  O   SER A  79      10.316  56.752  25.889  1.00 17.21           O  
ATOM    512  CB  SER A  79       9.752  53.936  27.643  1.00 16.23           C  
ATOM    513  OG  SER A  79      10.982  53.230  27.657  0.50 20.86           O  
ATOM    515  N   ASN A  80      11.542  55.108  25.004  1.00 16.84           N  
ATOM    516  CA  ASN A  80      12.476  56.063  24.364  1.00 16.53           C  
ATOM    517  C   ASN A  80      11.778  56.936  23.284  1.00 15.62           C  
ATOM    518  O   ASN A  80      11.957  58.168  23.223  1.00 16.64           O  
ATOM    519  CB  ASN A  80      13.651  55.294  23.748  1.00 13.30           C  
ATOM    520  CG  ASN A  80      14.515  54.580  24.783  1.00 15.36           C  
ATOM    521  OD1 ASN A  80      14.467  54.869  25.980  1.00 11.16           O  
ATOM    522  ND2 ASN A  80      15.331  53.640  24.314  1.00 11.35           N  
ATOM    523  N   LEU A  81      10.955  56.317  22.454  1.00 16.67           N  
ATOM    524  CA  LEU A  81      10.296  57.050  21.341  1.00 17.65           C  
ATOM    525  C   LEU A  81       9.256  58.066  21.753  1.00 19.18           C  
ATOM    526  O   LEU A  81       8.993  59.024  21.013  1.00 19.40           O  
ATOM    527  CB  LEU A  81       9.659  56.119  20.322  1.00 17.06           C  
ATOM    528  CG  LEU A  81      10.652  55.197  19.580  1.00 15.22           C  
ATOM    529  CD1 LEU A  81       9.841  54.014  18.945  1.00 13.99           C  
ATOM    530  CD2 LEU A  81      11.501  55.903  18.571  1.00 10.66           C  
ATOM    531  N   GLN A  82       8.703  57.878  22.944  1.00 20.17           N  
ATOM    532  CA  GLN A  82       7.730  58.805  23.516  1.00 22.07           C  
ATOM    533  C   GLN A  82       8.401  60.126  23.844  1.00 22.32           C  
ATOM    534  O   GLN A  82       7.779  61.195  23.677  1.00 22.48           O  
ATOM    535  CB  GLN A  82       7.104  58.211  24.776  1.00 23.02           C  
ATOM    536  CG  GLN A  82       6.084  57.089  24.477  1.00 27.41           C  
ATOM    537  CD  GLN A  82       5.490  56.438  25.752  1.00 33.90           C  
ATOM    538  OE1 GLN A  82       4.720  55.458  25.660  1.00 36.22           O  
ATOM    539  NE2 GLN A  82       5.829  56.992  26.933  1.00 36.12           N  
ATOM    540  N   GLU A  83       9.670  60.047  24.275  1.00 21.32           N  
ATOM    541  CA  GLU A  83      10.517  61.206  24.539  1.00 22.45           C  
ATOM    542  C   GLU A  83      11.257  61.794  23.346  1.00 21.71           C  
ATOM    543  O   GLU A  83      11.416  63.022  23.299  1.00 22.32           O  
ATOM    544  CB  GLU A  83      11.536  60.980  25.678  1.00 23.51           C  
ATOM    545  CG  GLU A  83      10.989  60.570  27.043  1.00 29.46           C  
ATOM    546  CD  GLU A  83       9.714  61.291  27.470  1.00 36.29           C  
ATOM    547  OE1 GLU A  83       9.706  62.539  27.585  1.00 39.51           O  
ATOM    548  OE2 GLU A  83       8.707  60.585  27.728  1.00 41.34           O  
ATOM    549  N   ASN A  84      11.749  60.946  22.441  1.00 19.68           N  
ATOM    550  CA  ASN A  84      12.410  61.365  21.196  1.00 19.08           C  
ATOM    551  C   ASN A  84      12.058  60.336  20.082  1.00 18.14           C  
ATOM    552  O   ASN A  84      12.497  59.197  20.154  1.00 17.40           O  
ATOM    553  CB  ASN A  84      13.935  61.487  21.426  1.00 18.68           C  
ATOM    554  CG  ASN A  84      14.697  61.932  20.197  1.00 19.16           C  
ATOM    555  OD1 ASN A  84      14.169  61.952  19.085  1.00 17.78           O  
ATOM    556  ND2 ASN A  84      15.954  62.314  20.397  1.00 20.06           N  
ATOM    557  N   PRO A  85      11.246  60.734  19.092  1.00 17.26           N  
ATOM    558  CA  PRO A  85      10.739  59.794  18.091  1.00 16.92           C  
ATOM    559  C   PRO A  85      11.759  59.496  17.005  1.00 16.31           C  
ATOM    560  O   PRO A  85      11.447  58.653  16.172  1.00 15.33           O  
ATOM    561  CB  PRO A  85       9.508  60.512  17.505  1.00 17.54           C  
ATOM    562  CG  PRO A  85       9.878  62.031  17.622  1.00 17.33           C  
ATOM    563  CD  PRO A  85      10.747  62.118  18.860  1.00 17.49           C  
ATOM    564  N   TYR A  86      12.936  60.122  17.043  1.00 16.05           N  
ATOM    565  CA  TYR A  86      13.981  59.839  16.051  1.00 17.59           C  
ATOM    566  C   TYR A  86      14.570  58.451  16.265  1.00 16.45           C  
ATOM    567  O   TYR A  86      14.872  58.030  17.379  1.00 16.25           O  
ATOM    568  CB  TYR A  86      15.099  60.869  16.052  1.00 18.08           C  
ATOM    569  CG  TYR A  86      14.674  62.203  15.499  1.00 23.45           C  
ATOM    570  CD1 TYR A  86      14.250  62.320  14.161  1.00 24.18           C  
ATOM    571  CD2 TYR A  86      14.691  63.356  16.311  1.00 27.46           C  
ATOM    572  CE1 TYR A  86      13.859  63.529  13.650  1.00 28.25           C  
ATOM    573  CE2 TYR A  86      14.283  64.566  15.817  1.00 29.97           C  
ATOM    574  CZ  TYR A  86      13.878  64.650  14.475  1.00 31.84           C  
ATOM    575  OH  TYR A  86      13.466  65.865  13.964  1.00 36.57           O  
ATOM    576  N   ALA A  87      14.742  57.753  15.157  1.00 16.03           N  
ATOM    577  CA  ALA A  87      15.285  56.397  15.213  1.00 14.20           C  
ATOM    578  C   ALA A  87      15.949  56.056  13.895  1.00 13.43           C  
ATOM    579  O   ALA A  87      15.642  56.678  12.872  1.00 12.33           O  
ATOM    580  CB  ALA A  87      14.161  55.409  15.516  1.00 11.70           C  
ATOM    581  N   THR A  88      16.811  55.021  13.937  1.00 10.91           N  
ATOM    582  CA  THR A  88      17.432  54.434  12.743  1.00 10.64           C  
ATOM    583  C   THR A  88      17.270  52.935  12.846  1.00  9.87           C  
ATOM    584  O   THR A  88      17.549  52.346  13.899  1.00 10.42           O  
ATOM    585  CB  THR A  88      18.938  54.791  12.648  1.00  8.75           C  
ATOM    586  OG1 THR A  88      19.069  56.207  12.431  1.00 13.33           O  
ATOM    587  CG2 THR A  88      19.506  54.236  11.388  1.00  7.23           C  
ATOM    588  N   LEU A  89      16.739  52.346  11.790  1.00  9.19           N  
ATOM    589  CA  LEU A  89      16.572  50.890  11.677  1.00 10.20           C  
ATOM    590  C   LEU A  89      17.698  50.320  10.765  1.00 10.12           C  
ATOM    591  O   LEU A  89      17.951  50.878   9.680  1.00 10.20           O  
ATOM    592  CB  LEU A  89      15.194  50.621  11.038  1.00  9.24           C  
ATOM    593  CG  LEU A  89      14.765  49.200  10.690  1.00  9.37           C  
ATOM    594  CD1 LEU A  89      14.551  48.497  12.026  1.00 12.56           C  
ATOM    595  CD2 LEU A  89      13.519  49.062   9.763  1.00  7.36           C  
ATOM    596  N   THR A  90      18.368  49.236  11.179  1.00  9.85           N  
ATOM    597  CA  THR A  90      19.285  48.572  10.253  1.00  8.52           C  
ATOM    598  C   THR A  90      18.909  47.132  10.049  1.00  8.98           C  
ATOM    599  O   THR A  90      18.447  46.485  10.984  1.00  8.35           O  
ATOM    600  CB  THR A  90      20.775  48.650  10.687  0.50  9.62           C  
ATOM    602  OG1 THR A  90      20.966  48.031  11.975  0.50 10.12           O  
ATOM    604  CG2 THR A  90      21.115  50.039  10.924  0.50 12.65           C  
HETATM  606  N   MSE A  91      19.147  46.640   8.829  1.00  9.10           N  
HETATM  607  CA  MSE A  91      18.797  45.298   8.426  1.00 10.49           C  
HETATM  608  C   MSE A  91      19.932  44.815   7.537  1.00 10.83           C  
HETATM  609  O   MSE A  91      20.490  45.619   6.794  1.00 11.90           O  
HETATM  610  CB  MSE A  91      17.469  45.322   7.650  1.00  9.14           C  
HETATM  611  CG  MSE A  91      16.266  45.585   8.569  1.00  9.57           C  
HETATM  612 SE   MSE A  91      14.770  46.072   7.389  1.00 20.72          SE  
HETATM  613  CE  MSE A  91      15.462  47.808   6.747  1.00 11.39           C  
ATOM    614  N   THR A  92      20.256  43.524   7.620  1.00 10.21           N  
ATOM    615  CA  THR A  92      21.367  42.940   6.837  1.00  9.47           C  
ATOM    616  C   THR A  92      20.928  41.626   6.177  1.00 10.21           C  
ATOM    617  O   THR A  92      20.142  40.868   6.747  1.00  9.47           O  
ATOM    618  CB  THR A  92      22.611  42.704   7.722  1.00  9.80           C  
ATOM    619  OG1 THR A  92      23.554  41.841   7.060  1.00 11.09           O  
ATOM    620  CG2 THR A  92      22.251  41.886   8.992  1.00  7.97           C  
ATOM    621  N   LEU A  93      21.469  41.331   4.990  1.00  9.24           N  
ATOM    622  CA  LEU A  93      21.186  40.053   4.380  1.00  9.22           C  
ATOM    623  C   LEU A  93      21.809  38.868   5.160  1.00  9.53           C  
ATOM    624  O   LEU A  93      21.504  37.711   4.853  1.00 10.19           O  
ATOM    625  CB  LEU A  93      21.632  40.047   2.891  1.00  8.62           C  
ATOM    626  CG  LEU A  93      20.850  41.021   1.995  1.00 10.66           C  
ATOM    627  CD1 LEU A  93      21.274  40.982   0.543  1.00  7.68           C  
ATOM    628  CD2 LEU A  93      19.313  40.796   2.107  1.00 11.77           C  
ATOM    629  N   ALA A  94      22.657  39.178   6.148  1.00 10.31           N  
ATOM    630  CA  ALA A  94      23.225  38.191   7.068  1.00 10.39           C  
ATOM    631  C   ALA A  94      22.110  37.592   7.942  1.00 11.35           C  
ATOM    632  O   ALA A  94      22.287  36.589   8.600  1.00 12.09           O  
ATOM    633  CB  ALA A  94      24.338  38.823   7.910  1.00 10.57           C  
ATOM    634  N   GLN A  95      20.914  38.191   7.898  1.00 11.38           N  
ATOM    635  CA  GLN A  95      19.712  37.589   8.496  1.00 10.49           C  
ATOM    636  C   GLN A  95      19.165  36.371   7.724  1.00 12.93           C  
ATOM    637  O   GLN A  95      18.369  35.579   8.269  1.00 11.40           O  
ATOM    638  CB  GLN A  95      18.604  38.680   8.600  1.00 10.98           C  
ATOM    639  CG  GLN A  95      18.978  39.717   9.673  1.00  8.40           C  
ATOM    640  CD  GLN A  95      18.145  41.009   9.603  1.00 12.11           C  
ATOM    641  OE1 GLN A  95      18.704  42.091   9.662  1.00 10.62           O  
ATOM    642  NE2 GLN A  95      16.812  40.875   9.573  1.00 10.53           N  
ATOM    643  N   THR A  96      19.523  36.277   6.439  1.00 13.62           N  
ATOM    644  CA  THR A  96      19.270  35.087   5.617  1.00 15.31           C  
ATOM    645  C   THR A  96      20.545  34.286   5.436  1.00 16.11           C  
ATOM    646  O   THR A  96      21.575  34.589   6.047  1.00 15.40           O  
ATOM    647  CB  THR A  96      18.761  35.487   4.216  1.00 15.27           C  
ATOM    648  OG1 THR A  96      19.784  36.161   3.486  1.00 15.26           O  
ATOM    649  CG2 THR A  96      17.655  36.560   4.275  1.00 15.68           C  
ATOM    650  N   ASN A  97      20.500  33.271   4.571  1.00 16.18           N  
ATOM    651  CA  ASN A  97      21.722  32.495   4.301  1.00 18.87           C  
ATOM    652  C   ASN A  97      22.531  33.123   3.151  1.00 17.98           C  
ATOM    653  O   ASN A  97      23.558  32.577   2.728  1.00 18.62           O  
ATOM    654  CB  ASN A  97      21.353  31.034   3.976  1.00 19.50           C  
ATOM    655  CG  ASN A  97      22.579  30.110   3.888  1.00 26.52           C  
ATOM    656  OD1 ASN A  97      23.440  30.069   4.796  1.00 31.52           O  
ATOM    657  ND2 ASN A  97      22.651  29.336   2.787  1.00 30.69           N  
ATOM    658  N   PHE A  98      22.065  34.264   2.650  1.00 16.08           N  
ATOM    659  CA  PHE A  98      22.728  34.885   1.504  1.00 16.48           C  
ATOM    660  C   PHE A  98      24.242  35.086   1.696  1.00 14.92           C  
ATOM    661  O   PHE A  98      25.022  34.783   0.791  1.00 14.89           O  
ATOM    662  CB  PHE A  98      22.056  36.205   1.161  1.00 16.48           C  
ATOM    663  CG  PHE A  98      22.716  36.974   0.029  1.00 16.41           C  
ATOM    664  CD1 PHE A  98      22.304  36.781  -1.293  1.00 15.01           C  
ATOM    665  CD2 PHE A  98      23.669  37.930   0.304  1.00 13.89           C  
ATOM    666  CE1 PHE A  98      22.869  37.504  -2.334  1.00 17.26           C  
ATOM    667  CE2 PHE A  98      24.218  38.675  -0.720  1.00 15.18           C  
ATOM    668  CZ  PHE A  98      23.818  38.476  -2.042  1.00 16.24           C  
ATOM    669  N   CYS A  99      24.648  35.640   2.831  1.00 14.35           N  
ATOM    670  CA  CYS A  99      26.048  36.023   2.996  1.00 14.61           C  
ATOM    671  C   CYS A  99      26.957  34.802   3.207  1.00 17.41           C  
ATOM    672  O   CYS A  99      28.111  34.756   2.698  1.00 18.07           O  
ATOM    673  CB  CYS A  99      26.219  37.067   4.098  1.00 14.54           C  
ATOM    674  SG  CYS A  99      25.216  38.545   3.723  1.00 13.25           S  
ATOM    675  N   LYS A 100      26.424  33.818   3.936  1.00 17.48           N  
ATOM    676  CA  LYS A 100      27.158  32.585   4.174  1.00 20.23           C  
ATOM    677  C   LYS A 100      27.352  31.838   2.851  1.00 20.02           C  
ATOM    678  O   LYS A 100      28.441  31.471   2.540  1.00 21.45           O  
ATOM    679  CB  LYS A 100      26.430  31.725   5.214  1.00 20.26           C  
ATOM    680  CG  LYS A 100      26.591  32.257   6.660  1.00 24.82           C  
ATOM    681  CD  LYS A 100      27.281  31.233   7.561  1.00 30.39           C  
ATOM    682  CE  LYS A 100      27.473  31.755   9.005  1.00 32.31           C  
ATOM    683  NZ  LYS A 100      28.924  31.880   9.429  1.00 35.26           N  
ATOM    684  N   LYS A 101      26.301  31.680   2.052  1.00 20.58           N  
ATOM    685  CA  LYS A 101      26.371  30.919   0.799  1.00 20.97           C  
ATOM    686  C   LYS A 101      27.351  31.506  -0.241  1.00 21.30           C  
ATOM    687  O   LYS A 101      28.034  30.772  -0.978  1.00 19.92           O  
ATOM    688  CB  LYS A 101      24.944  30.701   0.234  0.50 21.96           C  
ATOM    690  CG  LYS A 101      24.528  31.539  -1.011  0.50 22.41           C  
ATOM    692  CD  LYS A 101      23.657  30.740  -2.003  0.50 23.81           C  
ATOM    694  CE  LYS A 101      24.478  29.693  -2.830  0.50 25.27           C  
ATOM    696  NZ  LYS A 101      24.361  29.873  -4.318  0.50 24.61           N  
ATOM    698  N   HIS A 102      27.446  32.834  -0.260  1.00 20.03           N  
ATOM    699  CA  HIS A 102      28.303  33.547  -1.182  1.00 19.62           C  
ATOM    700  C   HIS A 102      29.669  33.857  -0.594  1.00 19.08           C  
ATOM    701  O   HIS A 102      30.528  34.382  -1.285  1.00 19.88           O  
ATOM    702  CB  HIS A 102      27.628  34.854  -1.584  1.00 18.46           C  
ATOM    703  CG  HIS A 102      26.451  34.661  -2.487  1.00 22.15           C  
ATOM    704  ND1 HIS A 102      26.568  34.160  -3.772  1.00 24.46           N  
ATOM    705  CD2 HIS A 102      25.127  34.874  -2.286  1.00 23.27           C  
ATOM    706  CE1 HIS A 102      25.368  34.090  -4.325  1.00 24.54           C  
ATOM    707  NE2 HIS A 102      24.476  34.508  -3.442  1.00 22.48           N  
ATOM    708  N   GLY A 103      29.877  33.561   0.680  1.00 18.27           N  
ATOM    709  CA  GLY A 103      31.180  33.821   1.269  1.00 17.63           C  
ATOM    710  C   GLY A 103      31.440  35.321   1.431  1.00 17.24           C  
ATOM    711  O   GLY A 103      32.582  35.794   1.230  1.00 17.42           O  
ATOM    712  N   PHE A 104      30.399  36.062   1.829  1.00 14.11           N  
ATOM    713  CA  PHE A 104      30.594  37.471   2.173  1.00 13.66           C  
ATOM    714  C   PHE A 104      30.513  37.602   3.698  1.00 13.81           C  
ATOM    715  O   PHE A 104      29.451  37.322   4.300  1.00 13.13           O  
ATOM    716  CB  PHE A 104      29.503  38.354   1.585  1.00 11.71           C  
ATOM    717  CG  PHE A 104      29.309  38.239   0.087  1.00 13.59           C  
ATOM    718  CD1 PHE A 104      30.392  38.017  -0.790  1.00 12.40           C  
ATOM    719  CD2 PHE A 104      28.035  38.451  -0.461  1.00 10.47           C  
ATOM    720  CE1 PHE A 104      30.184  37.994  -2.200  1.00 14.32           C  
ATOM    721  CE2 PHE A 104      27.831  38.413  -1.840  1.00 10.44           C  
ATOM    722  CZ  PHE A 104      28.922  38.181  -2.710  1.00 15.17           C  
ATOM    723  N   ASP A 105      31.603  38.047   4.320  1.00 12.99           N  
ATOM    724  CA  ASP A 105      31.580  38.343   5.765  1.00 12.94           C  
ATOM    725  C   ASP A 105      30.444  39.309   6.066  1.00 11.97           C  
ATOM    726  O   ASP A 105      30.151  40.195   5.231  1.00 10.87           O  
ATOM    727  CB  ASP A 105      32.874  39.042   6.175  1.00 13.11           C  
ATOM    728  CG  ASP A 105      33.046  39.094   7.673  1.00 12.76           C  
ATOM    729  OD1 ASP A 105      32.813  40.172   8.225  1.00 11.20           O  
ATOM    730  OD2 ASP A 105      33.443  38.098   8.375  1.00 15.92           O  
ATOM    731  N   PRO A 106      29.790  39.185   7.230  1.00 11.13           N  
ATOM    732  CA  PRO A 106      28.697  40.115   7.553  1.00 10.96           C  
ATOM    733  C   PRO A 106      29.054  41.600   7.449  1.00 10.31           C  
ATOM    734  O   PRO A 106      28.142  42.382   7.236  1.00 11.50           O  
ATOM    735  CB  PRO A 106      28.322  39.759   8.983  1.00 10.30           C  
ATOM    736  CG  PRO A 106      28.678  38.259   9.113  1.00 12.00           C  
ATOM    737  CD  PRO A 106      29.900  38.094   8.219  1.00 11.82           C  
ATOM    738  N   GLN A 107      30.317  41.983   7.633  1.00  9.86           N  
ATOM    739  CA  GLN A 107      30.743  43.388   7.564  1.00  8.79           C  
ATOM    740  C   GLN A 107      31.296  43.784   6.181  1.00  9.64           C  
ATOM    741  O   GLN A 107      31.573  44.981   5.911  1.00  8.72           O  
ATOM    742  CB  GLN A 107      31.755  43.700   8.682  1.00  8.86           C  
ATOM    743  CG  GLN A 107      31.977  45.186   8.988  1.00 11.64           C  
ATOM    744  CD  GLN A 107      32.952  45.398  10.131  1.00 10.91           C  
ATOM    745  OE1 GLN A 107      32.858  44.731  11.192  1.00  9.25           O  
ATOM    746  NE2 GLN A 107      33.868  46.351   9.952  1.00 11.79           N  
ATOM    747  N   SER A 108      31.435  42.821   5.269  1.00  9.68           N  
ATOM    748  CA  SER A 108      31.684  43.184   3.866  1.00 10.83           C  
ATOM    749  C   SER A 108      30.437  43.883   3.268  1.00 11.10           C  
ATOM    750  O   SER A 108      29.321  43.367   3.448  1.00 11.76           O  
ATOM    751  CB  SER A 108      31.922  41.968   3.023  1.00 11.85           C  
ATOM    752  OG  SER A 108      32.004  42.373   1.664  1.00 11.59           O  
ATOM    753  N   PRO A 109      30.616  44.991   2.538  1.00 10.95           N  
ATOM    754  CA  PRO A 109      29.458  45.664   1.898  1.00 10.95           C  
ATOM    755  C   PRO A 109      28.791  44.732   0.911  1.00 10.89           C  
ATOM    756  O   PRO A 109      27.637  44.939   0.558  1.00 11.16           O  
ATOM    757  CB  PRO A 109      30.076  46.883   1.181  1.00 11.06           C  
ATOM    758  CG  PRO A 109      31.591  46.548   0.994  1.00 10.63           C  
ATOM    759  CD  PRO A 109      31.905  45.667   2.250  1.00 10.93           C  
ATOM    760  N   LEU A 110      29.485  43.670   0.480  1.00 11.04           N  
ATOM    761  CA  LEU A 110      28.809  42.694  -0.378  1.00 11.01           C  
ATOM    762  C   LEU A 110      27.721  41.947   0.375  1.00 10.91           C  
ATOM    763  O   LEU A 110      26.768  41.481  -0.233  1.00 10.74           O  
ATOM    764  CB  LEU A 110      29.793  41.702  -1.041  1.00 11.12           C  
ATOM    765  CG  LEU A 110      30.568  42.221  -2.270  1.00 10.70           C  
ATOM    766  CD1 LEU A 110      29.664  42.592  -3.444  1.00 16.09           C  
ATOM    767  CD2 LEU A 110      31.457  43.392  -1.890  1.00 16.44           C  
ATOM    768  N   CYS A 111      27.875  41.829   1.700  1.00 10.81           N  
ATOM    769  CA  CYS A 111      26.790  41.317   2.532  1.00 10.59           C  
ATOM    770  C   CYS A 111      25.893  42.522   2.814  1.00  9.48           C  
ATOM    771  O   CYS A 111      26.091  43.275   3.809  1.00  9.75           O  
ATOM    772  CB  CYS A 111      27.303  40.687   3.837  1.00 10.64           C  
ATOM    773  SG  CYS A 111      25.915  40.076   4.829  1.00 10.50           S  
ATOM    774  N   VAL A 112      24.942  42.738   1.912  1.00  8.75           N  
ATOM    775  CA  VAL A 112      24.220  44.009   1.936  1.00  8.19           C  
ATOM    776  C   VAL A 112      23.614  44.349   3.296  1.00  8.17           C  
ATOM    777  O   VAL A 112      22.932  43.527   3.931  1.00  8.28           O  
ATOM    778  CB  VAL A 112      23.133  44.100   0.812  1.00  9.21           C  
ATOM    779  CG1 VAL A 112      22.463  45.492   0.854  1.00  6.28           C  
ATOM    780  CG2 VAL A 112      23.767  43.858  -0.567  1.00  6.56           C  
ATOM    781  N   HIS A 113      23.922  45.542   3.802  1.00  9.42           N  
ATOM    782  CA  HIS A 113      23.120  46.073   4.857  1.00  9.99           C  
ATOM    783  C   HIS A 113      22.703  47.534   4.562  1.00 10.12           C  
ATOM    784  O   HIS A 113      23.375  48.292   3.822  1.00  9.28           O  
ATOM    785  CB  HIS A 113      23.800  45.958   6.236  0.50 10.57           C  
ATOM    787  CG  HIS A 113      24.957  46.898   6.437  0.50 12.15           C  
ATOM    789  ND1 HIS A 113      26.190  46.700   5.851  0.50 13.73           N  
ATOM    791  CD2 HIS A 113      25.074  48.021   7.184  0.50 14.75           C  
ATOM    793  CE1 HIS A 113      27.015  47.660   6.230  0.50 15.73           C  
ATOM    795  NE2 HIS A 113      26.358  48.485   7.025  0.50 14.57           N  
ATOM    797  N   ILE A 114      21.562  47.893   5.122  1.00  9.09           N  
ATOM    798  CA  ILE A 114      21.018  49.242   4.907  1.00  7.92           C  
ATOM    799  C   ILE A 114      20.672  49.879   6.256  1.00 10.45           C  
ATOM    800  O   ILE A 114      20.446  49.171   7.252  1.00  8.79           O  
ATOM    801  CB  ILE A 114      19.810  49.233   3.938  1.00  9.28           C  
ATOM    802  CG1 ILE A 114      18.515  48.758   4.605  1.00  7.87           C  
ATOM    803  CG2 ILE A 114      20.081  48.385   2.608  1.00  6.20           C  
ATOM    804  CD1 ILE A 114      17.293  48.841   3.670  1.00  9.43           C  
HETATM  805  N   MSE A 115      20.623  51.208   6.281  1.00  9.01           N  
HETATM  806  CA  MSE A 115      20.148  51.931   7.443  1.00 11.10           C  
HETATM  807  C   MSE A 115      19.066  52.888   6.963  1.00 10.24           C  
HETATM  808  O   MSE A 115      19.278  53.576   5.974  1.00 11.36           O  
HETATM  809  CB  MSE A 115      21.280  52.717   8.126  1.00 11.71           C  
HETATM  810  CG  MSE A 115      22.389  51.844   8.669  1.00 18.66           C  
HETATM  811 SE   MSE A 115      23.673  51.463   7.245  1.00 35.76          SE  
HETATM  812  CE  MSE A 115      25.234  52.242   8.176  1.00 28.60           C  
ATOM    813  N   LEU A 116      17.914  52.882   7.641  1.00 11.54           N  
ATOM    814  CA  LEU A 116      16.786  53.773   7.336  1.00 12.23           C  
ATOM    815  C   LEU A 116      16.550  54.580   8.561  1.00 13.35           C  
ATOM    816  O   LEU A 116      16.256  54.030   9.623  1.00 13.64           O  
ATOM    817  CB  LEU A 116      15.491  53.006   6.994  1.00 12.72           C  
ATOM    818  CG  LEU A 116      15.612  51.896   5.971  1.00 12.05           C  
ATOM    819  CD1 LEU A 116      14.294  51.161   5.955  1.00 11.79           C  
ATOM    820  CD2 LEU A 116      15.961  52.442   4.576  1.00 12.12           C  
ATOM    821  N   SER A 117      16.720  55.894   8.410  1.00 13.87           N  
ATOM    822  CA  SER A 117      16.640  56.809   9.523  1.00 14.73           C  
ATOM    823  C   SER A 117      15.432  57.739   9.346  1.00 15.12           C  
ATOM    824  O   SER A 117      15.075  58.095   8.210  1.00 14.37           O  
ATOM    825  CB  SER A 117      17.950  57.608   9.646  1.00 13.97           C  
ATOM    826  OG  SER A 117      17.998  58.226  10.933  1.00 20.35           O  
ATOM    827  N   GLY A 118      14.806  58.126  10.468  1.00 15.42           N  
ATOM    828  CA  GLY A 118      13.592  58.928  10.433  1.00 15.87           C  
ATOM    829  C   GLY A 118      12.938  59.025  11.823  1.00 16.15           C  
ATOM    830  O   GLY A 118      13.670  59.026  12.848  1.00 16.33           O  
ATOM    831  N   THR A 119      11.599  59.029  11.860  1.00 14.23           N  
ATOM    832  CA  THR A 119      10.853  58.935  13.101  1.00 14.07           C  
ATOM    833  C   THR A 119       9.922  57.745  13.128  1.00 14.64           C  
ATOM    834  O   THR A 119       9.376  57.322  12.110  1.00 16.14           O  
ATOM    835  CB  THR A 119      10.037  60.240  13.413  1.00 13.27           C  
ATOM    836  OG1 THR A 119       9.138  60.488  12.334  1.00 17.97           O  
ATOM    837  CG2 THR A 119      10.991  61.462  13.412  1.00  9.28           C  
ATOM    838  N   VAL A 120       9.697  57.225  14.327  1.00 14.37           N  
ATOM    839  CA  VAL A 120       8.691  56.194  14.476  1.00 14.58           C  
ATOM    840  C   VAL A 120       7.444  56.858  15.035  1.00 15.43           C  
ATOM    841  O   VAL A 120       7.523  57.540  16.062  1.00 15.53           O  
ATOM    842  CB  VAL A 120       9.125  55.063  15.394  1.00 15.19           C  
ATOM    843  CG1 VAL A 120       7.984  54.056  15.522  1.00 11.66           C  
ATOM    844  CG2 VAL A 120      10.378  54.387  14.844  1.00 12.90           C  
ATOM    845  N   THR A 121       6.313  56.647  14.374  1.00 16.71           N  
ATOM    846  CA  THR A 121       5.030  57.183  14.874  1.00 17.89           C  
ATOM    847  C   THR A 121       3.964  56.104  14.871  1.00 18.22           C  
ATOM    848  O   THR A 121       4.101  55.042  14.220  1.00 18.83           O  
ATOM    849  CB  THR A 121       4.513  58.334  13.998  1.00 17.90           C  
ATOM    850  OG1 THR A 121       4.552  57.919  12.630  1.00 18.53           O  
ATOM    851  CG2 THR A 121       5.388  59.603  14.079  1.00 19.86           C  
ATOM    852  N   LYS A 122       2.884  56.380  15.600  1.00 19.26           N  
ATOM    853  CA  LYS A 122       1.689  55.544  15.575  1.00 20.69           C  
ATOM    854  C   LYS A 122       1.034  55.694  14.210  1.00 21.22           C  
ATOM    855  O   LYS A 122       0.998  56.774  13.660  1.00 21.32           O  
ATOM    856  CB  LYS A 122       0.704  55.955  16.685  1.00 21.67           C  
ATOM    857  CG  LYS A 122       1.242  55.728  18.116  1.00 24.50           C  
ATOM    858  CD  LYS A 122       0.125  55.802  19.174  1.00 28.85           C  
ATOM    859  CE  LYS A 122       0.635  55.402  20.557  1.00 33.34           C  
ATOM    860  NZ  LYS A 122      -0.518  54.938  21.452  1.00 36.64           N  
ATOM    861  N   VAL A 123       0.569  54.585  13.661  1.00 21.97           N  
ATOM    862  CA  VAL A 123      -0.069  54.572  12.360  1.00 23.58           C  
ATOM    863  C   VAL A 123      -1.473  55.228  12.452  1.00 25.89           C  
ATOM    864  O   VAL A 123      -2.195  55.036  13.446  1.00 25.87           O  
ATOM    865  CB  VAL A 123      -0.100  53.124  11.826  1.00 22.60           C  
ATOM    866  CG1 VAL A 123      -1.047  52.968  10.710  1.00 22.45           C  
ATOM    867  CG2 VAL A 123       1.359  52.660  11.376  1.00 19.69           C  
ATOM    868  N   ASN A 124      -1.810  56.020  11.429  1.00 27.97           N  
ATOM    869  CA  ASN A 124      -3.171  56.536  11.184  1.00 30.15           C  
ATOM    870  C   ASN A 124      -4.280  55.521  11.117  1.00 29.99           C  
ATOM    871  O   ASN A 124      -4.060  54.396  10.672  1.00 29.63           O  
ATOM    872  CB  ASN A 124      -3.209  57.266   9.823  1.00 31.61           C  
ATOM    873  CG  ASN A 124      -2.729  58.682   9.932  1.00 34.03           C  
ATOM    874  OD1 ASN A 124      -2.609  59.210  11.045  1.00 39.08           O  
ATOM    875  ND2 ASN A 124      -2.394  59.299   8.791  1.00 36.17           N  
ATOM    876  N   GLU A 125      -5.499  55.959  11.475  1.00 30.92           N  
ATOM    877  CA  GLU A 125      -6.711  55.158  11.281  1.00 30.62           C  
ATOM    878  C   GLU A 125      -6.788  54.560   9.888  1.00 29.63           C  
ATOM    879  O   GLU A 125      -7.001  53.353   9.758  1.00 28.98           O  
ATOM    880  CB  GLU A 125      -7.994  55.981  11.544  1.00 32.54           C  
ATOM    881  CG  GLU A 125      -8.708  55.589  12.830  1.00 36.29           C  
ATOM    882  CD  GLU A 125     -10.222  55.504  12.668  1.00 42.91           C  
ATOM    883  OE1 GLU A 125     -10.855  56.522  12.263  1.00 46.83           O  
ATOM    884  OE2 GLU A 125     -10.790  54.425  12.956  1.00 44.82           O  
ATOM    885  N   THR A 126      -6.591  55.383   8.850  1.00 28.39           N  
ATOM    886  CA  THR A 126      -6.712  54.890   7.462  1.00 28.36           C  
ATOM    887  C   THR A 126      -5.639  53.858   7.054  1.00 27.43           C  
ATOM    888  O   THR A 126      -5.848  53.069   6.120  1.00 27.17           O  
ATOM    889  CB  THR A 126      -6.814  56.073   6.413  1.00 29.10           C  
ATOM    890  OG1 THR A 126      -5.760  57.028   6.610  1.00 29.02           O  
ATOM    891  CG2 THR A 126      -8.134  56.917   6.660  1.00 29.68           C  
ATOM    892  N   GLU A 127      -4.507  53.849   7.762  1.00 26.86           N  
ATOM    893  CA  GLU A 127      -3.388  52.943   7.449  1.00 24.99           C  
ATOM    894  C   GLU A 127      -3.250  51.746   8.414  1.00 25.03           C  
ATOM    895  O   GLU A 127      -2.452  50.825   8.177  1.00 21.81           O  
ATOM    896  CB  GLU A 127      -2.090  53.756   7.305  1.00 25.67           C  
ATOM    897  CG  GLU A 127      -0.863  52.968   6.863  1.00 25.21           C  
ATOM    898  CD  GLU A 127       0.351  53.826   6.597  1.00 27.51           C  
ATOM    899  OE1 GLU A 127       0.344  55.023   6.974  1.00 26.82           O  
ATOM    900  OE2 GLU A 127       1.326  53.283   5.996  1.00 24.50           O  
HETATM  901  N   MSE A 128      -4.055  51.725   9.486  1.00 25.25           N  
HETATM  902  CA  MSE A 128      -4.003  50.596  10.443  1.00 25.51           C  
HETATM  903  C   MSE A 128      -4.202  49.225   9.792  1.00 23.80           C  
HETATM  904  O   MSE A 128      -3.516  48.237  10.158  1.00 22.24           O  
HETATM  905  CB  MSE A 128      -5.031  50.796  11.558  0.50 26.35           C  
HETATM  907  CG  MSE A 128      -5.594  49.531  12.171  0.50 30.48           C  
HETATM  909 SE   MSE A 128      -6.367  49.899  13.915  0.50 45.46          SE  
HETATM  911  CE  MSE A 128      -6.566  48.033  14.564  0.50 41.18           C  
ATOM    913  N   ASP A 129      -5.130  49.143   8.831  1.00 21.42           N  
ATOM    914  CA  ASP A 129      -5.457  47.847   8.286  1.00 20.52           C  
ATOM    915  C   ASP A 129      -4.315  47.292   7.448  1.00 19.12           C  
ATOM    916  O   ASP A 129      -3.998  46.114   7.553  1.00 18.89           O  
ATOM    917  CB  ASP A 129      -6.761  47.817   7.467  1.00 20.65           C  
ATOM    918  CG  ASP A 129      -7.302  46.423   7.339  1.00 22.54           C  
ATOM    919  OD1 ASP A 129      -7.707  45.873   8.405  1.00 26.37           O  
ATOM    920  OD2 ASP A 129      -7.337  45.770   6.255  1.00 17.28           O  
ATOM    921  N   ILE A 130      -3.722  48.146   6.613  1.00 18.76           N  
ATOM    922  CA  ILE A 130      -2.587  47.707   5.816  1.00 18.06           C  
ATOM    923  C   ILE A 130      -1.396  47.299   6.738  1.00 16.43           C  
ATOM    924  O   ILE A 130      -0.808  46.254   6.519  1.00 16.57           O  
ATOM    925  CB  ILE A 130      -2.248  48.710   4.631  1.00 18.97           C  
ATOM    926  CG1 ILE A 130      -1.243  48.099   3.651  1.00 21.59           C  
ATOM    927  CG2 ILE A 130      -1.712  50.017   5.085  1.00 17.89           C  
ATOM    928  CD1 ILE A 130      -0.913  49.104   2.427  1.00 21.51           C  
ATOM    929  N   ALA A 131      -1.139  48.061   7.802  1.00 16.36           N  
ATOM    930  CA  ALA A 131      -0.089  47.705   8.788  1.00 16.57           C  
ATOM    931  C   ALA A 131      -0.377  46.354   9.430  1.00 15.53           C  
ATOM    932  O   ALA A 131       0.504  45.468   9.550  1.00 15.73           O  
ATOM    933  CB  ALA A 131      -0.014  48.768   9.838  1.00 16.26           C  
ATOM    934  N   LYS A 132      -1.642  46.170   9.812  1.00 15.26           N  
ATOM    935  CA  LYS A 132      -2.079  44.952  10.460  1.00 14.83           C  
ATOM    936  C   LYS A 132      -1.958  43.784   9.547  1.00 15.71           C  
ATOM    937  O   LYS A 132      -1.423  42.715   9.923  1.00 14.17           O  
ATOM    938  CB  LYS A 132      -3.538  45.081  10.940  1.00 15.36           C  
ATOM    939  CG  LYS A 132      -4.038  43.830  11.651  1.00 18.33           C  
ATOM    940  CD  LYS A 132      -5.438  43.970  12.253  1.00 22.03           C  
ATOM    941  CE  LYS A 132      -5.959  42.550  12.614  1.00 26.82           C  
ATOM    942  NZ  LYS A 132      -7.484  42.375  12.692  1.00 31.94           N  
ATOM    943  N   HIS A 133      -2.477  43.943   8.337  1.00 15.01           N  
ATOM    944  CA  HIS A 133      -2.385  42.867   7.371  1.00 16.44           C  
ATOM    945  C   HIS A 133      -0.882  42.535   7.076  1.00 16.09           C  
ATOM    946  O   HIS A 133      -0.486  41.368   7.074  1.00 17.23           O  
ATOM    947  CB  HIS A 133      -3.180  43.276   6.090  1.00 17.53           C  
ATOM    948  CG  HIS A 133      -3.192  42.232   5.019  1.00 21.50           C  
ATOM    949  ND1 HIS A 133      -3.683  40.955   5.225  1.00 24.85           N  
ATOM    950  CD2 HIS A 133      -2.802  42.284   3.717  1.00 22.54           C  
ATOM    951  CE1 HIS A 133      -3.599  40.269   4.096  1.00 23.07           C  
ATOM    952  NE2 HIS A 133      -3.062  41.048   3.171  1.00 25.06           N  
ATOM    953  N   SER A 134      -0.070  43.568   6.832  1.00 15.47           N  
ATOM    954  CA  SER A 134       1.368  43.394   6.567  1.00 15.40           C  
ATOM    955  C   SER A 134       2.051  42.597   7.694  1.00 15.08           C  
ATOM    956  O   SER A 134       2.714  41.559   7.438  1.00 15.53           O  
ATOM    957  CB  SER A 134       2.041  44.769   6.366  1.00 15.09           C  
ATOM    958  OG  SER A 134       1.551  45.398   5.184  1.00 17.40           O  
ATOM    959  N   LEU A 135       1.826  43.032   8.935  1.00 13.70           N  
ATOM    960  CA  LEU A 135       2.474  42.429  10.116  1.00 14.06           C  
ATOM    961  C   LEU A 135       1.944  41.015  10.447  1.00 14.31           C  
ATOM    962  O   LEU A 135       2.706  40.064  10.579  1.00 13.52           O  
ATOM    963  CB  LEU A 135       2.325  43.385  11.311  1.00 13.16           C  
ATOM    964  CG  LEU A 135       3.293  44.594  11.328  1.00 13.03           C  
ATOM    965  CD1 LEU A 135       2.722  45.684  12.190  1.00 10.08           C  
ATOM    966  CD2 LEU A 135       4.732  44.283  11.836  1.00 12.51           C  
ATOM    967  N   PHE A 136       0.617  40.863  10.487  1.00 13.55           N  
ATOM    968  CA  PHE A 136       0.020  39.609  10.974  1.00 14.16           C  
ATOM    969  C   PHE A 136       0.231  38.440  10.003  1.00 13.75           C  
ATOM    970  O   PHE A 136       0.384  37.302  10.390  1.00 14.54           O  
ATOM    971  CB  PHE A 136      -1.480  39.834  11.321  1.00 14.65           C  
ATOM    972  CG  PHE A 136      -1.708  40.534  12.668  1.00 16.15           C  
ATOM    973  CD1 PHE A 136      -2.981  40.508  13.272  1.00 17.70           C  
ATOM    974  CD2 PHE A 136      -0.673  41.227  13.320  1.00 15.87           C  
ATOM    975  CE1 PHE A 136      -3.223  41.158  14.499  1.00 20.17           C  
ATOM    976  CE2 PHE A 136      -0.897  41.917  14.558  1.00 16.08           C  
ATOM    977  CZ  PHE A 136      -2.170  41.857  15.163  1.00 19.68           C  
ATOM    978  N   ILE A 137       0.268  38.731   8.716  1.00 15.02           N  
ATOM    979  CA  ILE A 137       0.600  37.741   7.724  1.00 15.81           C  
ATOM    980  C   ILE A 137       2.089  37.307   7.840  1.00 15.69           C  
ATOM    981  O   ILE A 137       2.412  36.107   7.778  1.00 15.14           O  
ATOM    982  CB  ILE A 137       0.240  38.310   6.303  1.00 16.53           C  
ATOM    983  CG1 ILE A 137      -1.254  38.140   6.028  1.00 20.37           C  
ATOM    984  CG2 ILE A 137       1.064  37.671   5.185  1.00 18.22           C  
ATOM    985  CD1 ILE A 137      -1.711  36.698   5.944  1.00 23.47           C  
ATOM    986  N   ARG A 138       2.979  38.272   8.028  1.00 14.40           N  
ATOM    987  CA  ARG A 138       4.406  37.934   8.165  1.00 14.72           C  
ATOM    988  C   ARG A 138       4.675  37.323   9.540  1.00 14.64           C  
ATOM    989  O   ARG A 138       5.559  36.492   9.665  1.00 14.80           O  
ATOM    990  CB  ARG A 138       5.310  39.176   7.973  1.00 14.45           C  
ATOM    991  CG  ARG A 138       6.836  38.789   7.778  1.00 16.21           C  
ATOM    992  CD  ARG A 138       7.162  38.298   6.316  1.00 19.35           C  
ATOM    993  NE  ARG A 138       6.953  39.436   5.434  1.00 13.97           N  
ATOM    994  CZ  ARG A 138       7.861  40.401   5.216  1.00 14.38           C  
ATOM    995  NH1 ARG A 138       9.088  40.333   5.762  1.00 13.53           N  
ATOM    996  NH2 ARG A 138       7.545  41.444   4.436  1.00 12.57           N  
ATOM    997  N   HIS A 139       3.939  37.770  10.570  1.00 12.85           N  
ATOM    998  CA  HIS A 139       4.218  37.342  11.929  1.00 14.70           C  
ATOM    999  C   HIS A 139       2.970  36.776  12.608  1.00 15.39           C  
ATOM   1000  O   HIS A 139       2.408  37.448  13.454  1.00 16.29           O  
ATOM   1001  CB  HIS A 139       4.789  38.495  12.766  1.00 14.45           C  
ATOM   1002  CG  HIS A 139       6.090  39.020  12.254  1.00 14.87           C  
ATOM   1003  ND1 HIS A 139       7.308  38.522  12.662  1.00 11.99           N  
ATOM   1004  CD2 HIS A 139       6.357  40.012  11.371  1.00 12.39           C  
ATOM   1005  CE1 HIS A 139       8.276  39.173  12.035  1.00 15.27           C  
ATOM   1006  NE2 HIS A 139       7.726  40.093  11.256  1.00 15.76           N  
ATOM   1007  N   PRO A 140       2.541  35.549  12.250  1.00 16.33           N  
ATOM   1008  CA  PRO A 140       1.285  34.984  12.806  1.00 16.63           C  
ATOM   1009  C   PRO A 140       1.213  34.879  14.341  1.00 15.72           C  
ATOM   1010  O   PRO A 140       0.124  34.934  14.904  1.00 15.72           O  
ATOM   1011  CB  PRO A 140       1.144  33.590  12.121  1.00 17.10           C  
ATOM   1012  CG  PRO A 140       2.558  33.245  11.572  1.00 18.41           C  
ATOM   1013  CD  PRO A 140       3.163  34.650  11.260  1.00 16.15           C  
ATOM   1014  N   GLU A 141       2.348  34.814  15.018  1.00 16.08           N  
ATOM   1015  CA  GLU A 141       2.357  34.750  16.486  1.00 15.54           C  
ATOM   1016  C   GLU A 141       1.749  36.003  17.147  1.00 15.02           C  
ATOM   1017  O   GLU A 141       1.216  35.942  18.275  1.00 15.13           O  
ATOM   1018  CB  GLU A 141       3.791  34.458  16.985  1.00 14.85           C  
ATOM   1019  CG  GLU A 141       3.907  34.135  18.456  1.00 16.76           C  
ATOM   1020  CD  GLU A 141       5.293  34.344  19.034  1.00 17.08           C  
ATOM   1021  OE1 GLU A 141       6.186  33.460  18.842  1.00 17.19           O  
ATOM   1022  OE2 GLU A 141       5.481  35.400  19.683  1.00 16.74           O  
HETATM 1023  N   MSE A 142       1.810  37.144  16.463  1.00 14.94           N  
HETATM 1024  CA  MSE A 142       1.335  38.414  17.037  1.00 14.15           C  
HETATM 1025  C   MSE A 142      -0.187  38.379  17.399  1.00 16.24           C  
HETATM 1026  O   MSE A 142      -0.618  39.046  18.340  1.00 15.46           O  
HETATM 1027  CB  MSE A 142       1.603  39.564  16.076  1.00 14.37           C  
HETATM 1028  CG  MSE A 142       3.092  39.964  15.949  1.00 13.87           C  
HETATM 1029 SE   MSE A 142       3.275  41.425  14.638  1.00 20.80          SE  
HETATM 1030  CE  MSE A 142       5.305  41.491  14.801  1.00 16.54           C  
ATOM   1031  N   LYS A 143      -0.961  37.597  16.644  1.00 17.42           N  
ATOM   1032  CA  LYS A 143      -2.401  37.341  16.938  1.00 19.40           C  
ATOM   1033  C   LYS A 143      -2.605  36.793  18.361  1.00 18.97           C  
ATOM   1034  O   LYS A 143      -3.635  37.088  18.993  1.00 19.84           O  
ATOM   1035  CB  LYS A 143      -3.008  36.384  15.902  1.00 18.46           C  
ATOM   1036  CG  LYS A 143      -3.171  37.044  14.518  1.00 23.60           C  
ATOM   1037  CD  LYS A 143      -3.969  36.178  13.531  1.00 29.78           C  
ATOM   1038  CE  LYS A 143      -3.111  35.056  12.957  1.00 34.66           C  
ATOM   1039  NZ  LYS A 143      -3.707  34.310  11.757  1.00 38.77           N  
ATOM   1040  N   THR A 144      -1.598  36.084  18.889  1.00 18.43           N  
ATOM   1041  CA  THR A 144      -1.685  35.517  20.242  1.00 17.71           C  
ATOM   1042  C   THR A 144      -1.059  36.356  21.368  1.00 18.46           C  
ATOM   1043  O   THR A 144      -1.147  35.973  22.530  1.00 17.69           O  
ATOM   1044  CB  THR A 144      -1.045  34.139  20.338  1.00 17.07           C  
ATOM   1045  OG1 THR A 144       0.391  34.246  20.217  1.00 16.50           O  
ATOM   1046  CG2 THR A 144      -1.478  33.178  19.228  1.00 19.25           C  
ATOM   1047  N   TRP A 145      -0.404  37.471  21.037  1.00 18.92           N  
ATOM   1048  CA  TRP A 145       0.240  38.307  22.046  1.00 18.43           C  
ATOM   1049  C   TRP A 145      -0.783  38.911  23.012  1.00 18.53           C  
ATOM   1050  O   TRP A 145      -1.873  39.315  22.602  1.00 18.94           O  
ATOM   1051  CB  TRP A 145       1.042  39.414  21.354  1.00 18.25           C  
ATOM   1052  CG  TRP A 145       2.319  38.909  20.625  1.00 16.83           C  
ATOM   1053  CD1 TRP A 145       2.724  37.616  20.459  1.00 17.80           C  
ATOM   1054  CD2 TRP A 145       3.312  39.713  19.977  1.00 13.77           C  
ATOM   1055  NE1 TRP A 145       3.918  37.573  19.775  1.00 15.15           N  
ATOM   1056  CE2 TRP A 145       4.291  38.845  19.454  1.00 13.69           C  
ATOM   1057  CE3 TRP A 145       3.463  41.087  19.768  1.00 15.83           C  
ATOM   1058  CZ2 TRP A 145       5.392  39.299  18.723  1.00 14.07           C  
ATOM   1059  CZ3 TRP A 145       4.556  41.543  19.061  1.00 13.72           C  
ATOM   1060  CH2 TRP A 145       5.511  40.647  18.542  1.00 15.50           C  
ATOM   1061  N   PRO A 146      -0.402  39.076  24.278  1.00 19.02           N  
ATOM   1062  CA  PRO A 146      -1.347  39.551  25.321  1.00 18.29           C  
ATOM   1063  C   PRO A 146      -1.983  40.953  25.140  1.00 18.62           C  
ATOM   1064  O   PRO A 146      -1.244  41.938  25.081  1.00 17.62           O  
ATOM   1065  CB  PRO A 146      -0.484  39.525  26.615  1.00 18.75           C  
ATOM   1066  CG  PRO A 146       0.978  39.518  26.155  1.00 19.10           C  
ATOM   1067  CD  PRO A 146       0.951  38.800  24.814  1.00 17.96           C  
ATOM   1068  N   SER A 147      -3.322  41.072  25.088  1.00 17.51           N  
ATOM   1069  CA  SER A 147      -3.962  42.410  24.959  1.00 18.87           C  
ATOM   1070  C   SER A 147      -3.581  43.407  26.065  1.00 17.87           C  
ATOM   1071  O   SER A 147      -3.632  44.637  25.878  1.00 19.39           O  
ATOM   1072  CB  SER A 147      -5.517  42.294  24.866  1.00 18.82           C  
ATOM   1073  OG  SER A 147      -6.041  41.657  26.033  1.00 22.97           O  
ATOM   1074  N   SER A 148      -3.208  42.870  27.219  1.00 16.96           N  
ATOM   1075  CA  SER A 148      -2.789  43.638  28.379  1.00 16.24           C  
ATOM   1076  C   SER A 148      -1.539  44.498  28.126  1.00 17.27           C  
ATOM   1077  O   SER A 148      -1.290  45.439  28.868  1.00 17.40           O  
ATOM   1078  CB  SER A 148      -2.599  42.714  29.597  1.00 16.54           C  
ATOM   1079  OG  SER A 148      -1.488  41.802  29.428  1.00 15.74           O  
ATOM   1080  N   HIS A 149      -0.806  44.208  27.050  1.00 16.66           N  
ATOM   1081  CA  HIS A 149       0.391  44.972  26.685  1.00 18.08           C  
ATOM   1082  C   HIS A 149       0.047  46.181  25.805  1.00 17.74           C  
ATOM   1083  O   HIS A 149       0.947  46.990  25.460  1.00 17.71           O  
ATOM   1084  CB  HIS A 149       1.473  44.065  26.031  1.00 18.33           C  
ATOM   1085  CG  HIS A 149       2.151  43.128  27.002  1.00 22.88           C  
ATOM   1086  ND1 HIS A 149       3.514  42.905  27.001  1.00 24.97           N  
ATOM   1087  CD2 HIS A 149       1.657  42.389  28.028  1.00 25.09           C  
ATOM   1088  CE1 HIS A 149       3.828  42.051  27.960  1.00 25.23           C  
ATOM   1089  NE2 HIS A 149       2.720  41.723  28.603  1.00 29.01           N  
ATOM   1090  N   ASN A 150      -1.241  46.319  25.461  1.00 16.65           N  
ATOM   1091  CA  ASN A 150      -1.711  47.505  24.729  1.00 17.29           C  
ATOM   1092  C   ASN A 150      -0.924  47.751  23.416  1.00 17.25           C  
ATOM   1093  O   ASN A 150      -0.355  48.816  23.197  1.00 17.40           O  
ATOM   1094  CB  ASN A 150      -1.650  48.695  25.663  1.00 16.64           C  
ATOM   1095  CG  ASN A 150      -2.668  48.561  26.815  1.00 19.76           C  
ATOM   1096  OD1 ASN A 150      -3.745  47.958  26.650  1.00 21.89           O  
ATOM   1097  ND2 ASN A 150      -2.315  49.075  27.968  1.00 21.24           N  
ATOM   1098  N   TRP A 151      -0.837  46.713  22.593  1.00 17.48           N  
ATOM   1099  CA  TRP A 151      -0.114  46.765  21.303  1.00 16.96           C  
ATOM   1100  C   TRP A 151      -0.679  47.856  20.407  1.00 17.96           C  
ATOM   1101  O   TRP A 151      -1.892  48.092  20.412  1.00 18.80           O  
ATOM   1102  CB  TRP A 151      -0.197  45.392  20.616  1.00 17.12           C  
ATOM   1103  CG  TRP A 151       0.370  44.297  21.472  1.00 17.52           C  
ATOM   1104  CD1 TRP A 151      -0.327  43.351  22.226  1.00 16.29           C  
ATOM   1105  CD2 TRP A 151       1.745  44.064  21.718  1.00 16.57           C  
ATOM   1106  NE1 TRP A 151       0.561  42.549  22.908  1.00 16.60           N  
ATOM   1107  CE2 TRP A 151       1.839  42.969  22.629  1.00 16.46           C  
ATOM   1108  CE3 TRP A 151       2.931  44.657  21.251  1.00 16.87           C  
ATOM   1109  CZ2 TRP A 151       3.054  42.471  23.074  1.00 16.27           C  
ATOM   1110  CZ3 TRP A 151       4.138  44.176  21.699  1.00 13.71           C  
ATOM   1111  CH2 TRP A 151       4.201  43.068  22.603  1.00 17.76           C  
ATOM   1112  N   PHE A 152       0.190  48.588  19.711  1.00 15.90           N  
ATOM   1113  CA  PHE A 152      -0.260  49.482  18.654  1.00 15.62           C  
ATOM   1114  C   PHE A 152       0.616  49.319  17.415  1.00 15.33           C  
ATOM   1115  O   PHE A 152       1.778  48.882  17.503  1.00 14.75           O  
ATOM   1116  CB  PHE A 152      -0.265  50.944  19.103  1.00 14.93           C  
ATOM   1117  CG  PHE A 152       1.071  51.436  19.553  1.00 16.43           C  
ATOM   1118  CD1 PHE A 152       1.516  51.194  20.859  1.00 15.50           C  
ATOM   1119  CD2 PHE A 152       1.895  52.164  18.679  1.00 17.60           C  
ATOM   1120  CE1 PHE A 152       2.743  51.660  21.315  1.00 17.07           C  
ATOM   1121  CE2 PHE A 152       3.133  52.647  19.122  1.00 18.02           C  
ATOM   1122  CZ  PHE A 152       3.558  52.394  20.468  1.00 16.59           C  
ATOM   1123  N   PHE A 153       0.035  49.667  16.270  1.00 15.66           N  
ATOM   1124  CA  PHE A 153       0.731  49.678  14.973  1.00 16.59           C  
ATOM   1125  C   PHE A 153       1.492  50.950  14.789  1.00 16.74           C  
ATOM   1126  O   PHE A 153       0.947  52.053  14.984  1.00 17.39           O  
ATOM   1127  CB  PHE A 153      -0.258  49.446  13.832  1.00 16.61           C  
ATOM   1128  CG  PHE A 153      -0.998  48.143  13.959  1.00 20.14           C  
ATOM   1129  CD1 PHE A 153      -0.346  46.941  13.676  1.00 18.39           C  
ATOM   1130  CD2 PHE A 153      -2.345  48.120  14.375  1.00 20.84           C  
ATOM   1131  CE1 PHE A 153      -1.001  45.740  13.791  1.00 21.96           C  
ATOM   1132  CE2 PHE A 153      -3.025  46.908  14.487  1.00 19.61           C  
ATOM   1133  CZ  PHE A 153      -2.358  45.723  14.202  1.00 22.55           C  
ATOM   1134  N   ALA A 154       2.783  50.799  14.480  1.00 15.71           N  
ATOM   1135  CA  ALA A 154       3.678  51.921  14.328  1.00 14.88           C  
ATOM   1136  C   ALA A 154       4.359  51.836  12.935  1.00 14.71           C  
ATOM   1137  O   ALA A 154       4.335  50.799  12.290  1.00 13.63           O  
ATOM   1138  CB  ALA A 154       4.716  51.899  15.468  1.00 14.51           C  
ATOM   1139  N   LYS A 155       4.910  52.943  12.459  1.00 14.37           N  
ATOM   1140  CA  LYS A 155       5.730  52.869  11.259  1.00 15.00           C  
ATOM   1141  C   LYS A 155       6.965  53.749  11.372  1.00 14.27           C  
ATOM   1142  O   LYS A 155       6.984  54.713  12.134  1.00 15.35           O  
ATOM   1143  CB  LYS A 155       4.896  53.273  10.003  1.00 13.98           C  
ATOM   1144  CG  LYS A 155       4.515  54.766  10.015  1.00 18.38           C  
ATOM   1145  CD  LYS A 155       3.440  55.052   8.933  1.00 20.45           C  
ATOM   1146  CE  LYS A 155       4.024  55.859   7.807  1.00 25.29           C  
ATOM   1147  NZ  LYS A 155       3.064  56.039   6.674  1.00 27.32           N  
ATOM   1148  N   LEU A 156       7.960  53.453  10.535  1.00 14.11           N  
ATOM   1149  CA  LEU A 156       9.114  54.311  10.365  1.00 13.81           C  
ATOM   1150  C   LEU A 156       8.831  55.194   9.141  1.00 14.09           C  
ATOM   1151  O   LEU A 156       8.550  54.693   8.012  1.00 13.68           O  
ATOM   1152  CB  LEU A 156      10.405  53.473  10.159  1.00 14.05           C  
ATOM   1153  CG  LEU A 156      11.707  54.295  10.056  1.00 14.87           C  
ATOM   1154  CD1 LEU A 156      12.059  55.063  11.369  1.00 12.13           C  
ATOM   1155  CD2 LEU A 156      12.898  53.388   9.580  1.00  8.90           C  
ATOM   1156  N   ASN A 157       8.839  56.478   9.416  1.00 12.01           N  
ATOM   1157  CA  ASN A 157       8.791  57.554   8.410  1.00 15.31           C  
ATOM   1158  C   ASN A 157      10.215  57.866   7.975  1.00 14.77           C  
ATOM   1159  O   ASN A 157      10.983  58.435   8.751  1.00 16.52           O  
ATOM   1160  CB  ASN A 157       8.156  58.806   9.038  1.00 15.41           C  
ATOM   1161  CG  ASN A 157       6.781  58.518   9.669  1.00 18.06           C  
ATOM   1162  OD1 ASN A 157       5.833  58.221   8.965  1.00 17.90           O  
ATOM   1163  ND2 ASN A 157       6.676  58.619  11.010  1.00 21.16           N  
ATOM   1164  N   ILE A 158      10.587  57.506   6.749  1.00 14.19           N  
ATOM   1165  CA  ILE A 158      12.004  57.546   6.390  1.00 14.43           C  
ATOM   1166  C   ILE A 158      12.395  58.906   5.803  1.00 15.85           C  
ATOM   1167  O   ILE A 158      11.848  59.319   4.809  1.00 16.19           O  
ATOM   1168  CB  ILE A 158      12.341  56.447   5.398  1.00 15.31           C  
ATOM   1169  CG1 ILE A 158      11.980  55.082   5.985  1.00 12.48           C  
ATOM   1170  CG2 ILE A 158      13.832  56.509   5.022  1.00 13.19           C  
ATOM   1171  CD1 ILE A 158      11.608  54.054   4.958  1.00 14.31           C  
ATOM   1172  N   THR A 159      13.362  59.579   6.406  1.00 15.80           N  
ATOM   1173  CA  THR A 159      13.900  60.754   5.771  1.00 16.70           C  
ATOM   1174  C   THR A 159      15.289  60.573   5.197  1.00 17.55           C  
ATOM   1175  O   THR A 159      15.668  61.340   4.305  1.00 16.75           O  
ATOM   1176  CB  THR A 159      13.832  61.970   6.700  1.00 16.55           C  
ATOM   1177  OG1 THR A 159      14.571  61.692   7.880  1.00 18.12           O  
ATOM   1178  CG2 THR A 159      12.398  62.179   7.240  1.00 16.69           C  
ATOM   1179  N   ASN A 160      16.056  59.605   5.714  1.00 17.43           N  
ATOM   1180  CA  ASN A 160      17.427  59.360   5.228  1.00 18.54           C  
ATOM   1181  C   ASN A 160      17.688  57.858   5.082  1.00 17.86           C  
ATOM   1182  O   ASN A 160      17.183  57.032   5.888  1.00 17.18           O  
ATOM   1183  CB  ASN A 160      18.476  59.976   6.178  1.00 18.47           C  
ATOM   1184  CG  ASN A 160      18.353  61.501   6.299  1.00 21.70           C  
ATOM   1185  OD1 ASN A 160      19.120  62.235   5.664  1.00 25.08           O  
ATOM   1186  ND2 ASN A 160      17.393  61.978   7.094  1.00 20.14           N  
ATOM   1187  N   ILE A 161      18.424  57.517   4.028  1.00 15.93           N  
ATOM   1188  CA  ILE A 161      18.732  56.137   3.692  1.00 14.23           C  
ATOM   1189  C   ILE A 161      20.201  56.002   3.245  1.00 14.41           C  
ATOM   1190  O   ILE A 161      20.658  56.765   2.394  1.00 14.06           O  
ATOM   1191  CB  ILE A 161      17.816  55.623   2.547  1.00 12.64           C  
ATOM   1192  CG1 ILE A 161      16.315  55.748   2.912  1.00 11.59           C  
ATOM   1193  CG2 ILE A 161      18.176  54.173   2.150  1.00 14.70           C  
ATOM   1194  CD1 ILE A 161      15.436  55.421   1.733  1.00  5.83           C  
ATOM   1195  N   TRP A 162      20.920  55.046   3.857  1.00 12.83           N  
ATOM   1196  CA  TRP A 162      22.276  54.651   3.441  1.00 12.46           C  
ATOM   1197  C   TRP A 162      22.262  53.178   3.041  1.00 11.54           C  
ATOM   1198  O   TRP A 162      21.614  52.359   3.716  1.00 11.17           O  
ATOM   1199  CB  TRP A 162      23.302  54.793   4.584  1.00 12.99           C  
ATOM   1200  CG  TRP A 162      23.514  56.206   5.050  1.00 17.12           C  
ATOM   1201  CD1 TRP A 162      24.528  57.065   4.694  1.00 19.06           C  
ATOM   1202  CD2 TRP A 162      22.702  56.910   5.999  1.00 17.63           C  
ATOM   1203  NE1 TRP A 162      24.391  58.256   5.370  1.00 19.97           N  
ATOM   1204  CE2 TRP A 162      23.264  58.203   6.157  1.00 20.66           C  
ATOM   1205  CE3 TRP A 162      21.533  56.590   6.710  1.00 17.33           C  
ATOM   1206  CZ2 TRP A 162      22.710  59.170   7.026  1.00 18.23           C  
ATOM   1207  CZ3 TRP A 162      20.970  57.567   7.579  1.00 16.50           C  
ATOM   1208  CH2 TRP A 162      21.575  58.824   7.733  1.00 19.83           C  
ATOM   1209  N   VAL A 163      22.968  52.846   1.947  1.00 10.71           N  
ATOM   1210  CA  VAL A 163      23.006  51.488   1.436  1.00  9.79           C  
ATOM   1211  C   VAL A 163      24.467  51.094   1.342  1.00 10.29           C  
ATOM   1212  O   VAL A 163      25.274  51.801   0.714  1.00 10.12           O  
ATOM   1213  CB  VAL A 163      22.268  51.332   0.079  1.00 10.43           C  
ATOM   1214  CG1 VAL A 163      22.446  49.906  -0.538  1.00  9.60           C  
ATOM   1215  CG2 VAL A 163      20.736  51.580   0.262  1.00  8.24           C  
ATOM   1216  N   LEU A 164      24.803  49.992   2.005  1.00  9.46           N  
ATOM   1217  CA  LEU A 164      26.139  49.424   1.864  1.00  9.61           C  
ATOM   1218  C   LEU A 164      25.988  48.168   1.047  1.00 10.35           C  
ATOM   1219  O   LEU A 164      25.603  47.113   1.568  1.00  9.67           O  
ATOM   1220  CB  LEU A 164      26.782  49.114   3.232  1.00  7.89           C  
ATOM   1221  CG  LEU A 164      27.636  50.235   3.863  1.00 11.45           C  
ATOM   1222  CD1 LEU A 164      28.847  50.675   3.048  1.00 11.48           C  
ATOM   1223  CD2 LEU A 164      26.730  51.445   4.186  1.00 13.13           C  
ATOM   1224  N   ASP A 165      26.260  48.268  -0.251  1.00  9.74           N  
ATOM   1225  CA  ASP A 165      26.075  47.077  -1.095  1.00  9.77           C  
ATOM   1226  C   ASP A 165      27.264  46.818  -2.030  1.00 10.36           C  
ATOM   1227  O   ASP A 165      27.282  45.855  -2.814  1.00 11.42           O  
ATOM   1228  CB  ASP A 165      24.744  47.075  -1.820  1.00  9.72           C  
ATOM   1229  CG  ASP A 165      24.683  48.071  -2.978  1.00  7.57           C  
ATOM   1230  OD1 ASP A 165      25.656  48.831  -3.221  1.00  9.43           O  
ATOM   1231  OD2 ASP A 165      23.675  48.084  -3.742  1.00  8.74           O  
ATOM   1232  N   TYR A 166      28.299  47.633  -1.886  1.00 10.92           N  
ATOM   1233  CA  TYR A 166      29.528  47.461  -2.699  1.00 11.35           C  
ATOM   1234  C   TYR A 166      30.703  48.174  -2.071  1.00 12.23           C  
ATOM   1235  O   TYR A 166      30.542  48.934  -1.106  1.00 12.60           O  
ATOM   1236  CB  TYR A 166      29.343  47.960  -4.140  1.00  9.79           C  
ATOM   1237  CG  TYR A 166      30.186  47.217  -5.199  1.00 11.59           C  
ATOM   1238  CD1 TYR A 166      31.252  47.866  -5.848  1.00 13.71           C  
ATOM   1239  CD2 TYR A 166      29.939  45.875  -5.515  1.00 11.09           C  
ATOM   1240  CE1 TYR A 166      32.040  47.202  -6.787  1.00 12.74           C  
ATOM   1241  CE2 TYR A 166      30.721  45.178  -6.465  1.00 13.20           C  
ATOM   1242  CZ  TYR A 166      31.779  45.866  -7.090  1.00 10.88           C  
ATOM   1243  OH  TYR A 166      32.550  45.233  -8.027  1.00 11.24           O  
ATOM   1244  N   PHE A 167      31.908  47.896  -2.596  1.00 13.37           N  
ATOM   1245  CA  PHE A 167      33.046  48.733  -2.291  1.00 14.68           C  
ATOM   1246  C   PHE A 167      32.786  50.206  -2.704  1.00 15.60           C  
ATOM   1247  O   PHE A 167      31.935  50.520  -3.549  1.00 13.35           O  
ATOM   1248  CB  PHE A 167      34.310  48.178  -2.989  1.00 14.97           C  
ATOM   1249  CG  PHE A 167      34.535  46.688  -2.763  1.00 15.12           C  
ATOM   1250  CD1 PHE A 167      34.664  46.148  -1.458  1.00 16.84           C  
ATOM   1251  CD2 PHE A 167      34.617  45.825  -3.847  1.00 15.89           C  
ATOM   1252  CE1 PHE A 167      34.881  44.736  -1.281  1.00 17.96           C  
ATOM   1253  CE2 PHE A 167      34.836  44.444  -3.692  1.00 12.39           C  
ATOM   1254  CZ  PHE A 167      34.968  43.889  -2.430  1.00 15.22           C  
ATOM   1255  N   GLY A 168      33.522  51.107  -2.065  1.00 16.66           N  
ATOM   1256  CA  GLY A 168      33.490  52.513  -2.421  1.00 19.11           C  
ATOM   1257  C   GLY A 168      32.688  53.344  -1.428  1.00 20.35           C  
ATOM   1258  O   GLY A 168      32.478  54.547  -1.652  1.00 21.90           O  
ATOM   1259  N   GLY A 169      32.244  52.740  -0.330  1.00 20.20           N  
ATOM   1260  CA  GLY A 169      31.456  53.494   0.643  1.00 19.40           C  
ATOM   1261  C   GLY A 169      29.914  53.487   0.464  1.00 18.06           C  
ATOM   1262  O   GLY A 169      29.397  52.917  -0.490  1.00 17.63           O  
ATOM   1263  N   PRO A 170      29.206  54.137   1.405  1.00 18.52           N  
ATOM   1264  CA  PRO A 170      27.739  54.164   1.430  1.00 18.16           C  
ATOM   1265  C   PRO A 170      27.144  54.879   0.232  1.00 18.51           C  
ATOM   1266  O   PRO A 170      27.716  55.846  -0.292  1.00 18.34           O  
ATOM   1267  CB  PRO A 170      27.411  54.930   2.725  1.00 17.63           C  
ATOM   1268  CG  PRO A 170      28.633  54.882   3.539  1.00 18.16           C  
ATOM   1269  CD  PRO A 170      29.785  54.914   2.531  1.00 17.33           C  
ATOM   1270  N   LYS A 171      26.009  54.375  -0.232  1.00 17.96           N  
ATOM   1271  CA  LYS A 171      25.273  55.023  -1.313  1.00 17.08           C  
ATOM   1272  C   LYS A 171      24.048  55.615  -0.658  1.00 17.92           C  
ATOM   1273  O   LYS A 171      23.382  54.949   0.131  1.00 16.94           O  
ATOM   1274  CB  LYS A 171      24.914  54.042  -2.410  1.00 17.12           C  
ATOM   1275  CG  LYS A 171      26.141  53.345  -2.973  1.00 16.82           C  
ATOM   1276  CD  LYS A 171      25.738  52.353  -4.011  1.00 20.33           C  
ATOM   1277  CE  LYS A 171      26.958  51.511  -4.449  1.00 17.70           C  
ATOM   1278  NZ  LYS A 171      26.408  50.676  -5.447  1.00 24.18           N  
ATOM   1279  N   ILE A 172      23.806  56.889  -0.954  1.00 15.90           N  
ATOM   1280  CA  ILE A 172      22.724  57.661  -0.334  1.00 16.99           C  
ATOM   1281  C   ILE A 172      21.555  57.475  -1.263  1.00 17.23           C  
ATOM   1282  O   ILE A 172      21.741  57.555  -2.479  1.00 15.12           O  
ATOM   1283  CB  ILE A 172      23.091  59.179  -0.313  1.00 18.14           C  
ATOM   1284  CG1 ILE A 172      24.386  59.449   0.448  1.00 19.77           C  
ATOM   1285  CG2 ILE A 172      21.888  60.063   0.210  1.00 17.31           C  
ATOM   1286  CD1 ILE A 172      24.408  58.848   1.810  1.00 22.04           C  
ATOM   1287  N   VAL A 173      20.358  57.259  -0.699  1.00 15.96           N  
ATOM   1288  CA  VAL A 173      19.158  57.045  -1.495  1.00 16.20           C  
ATOM   1289  C   VAL A 173      18.119  57.964  -0.872  1.00 16.50           C  
ATOM   1290  O   VAL A 173      17.906  57.935   0.331  1.00 17.50           O  
ATOM   1291  CB  VAL A 173      18.654  55.554  -1.399  1.00 15.05           C  
ATOM   1292  CG1 VAL A 173      17.323  55.336  -2.162  1.00 15.25           C  
ATOM   1293  CG2 VAL A 173      19.749  54.553  -1.912  1.00 17.01           C  
ATOM   1294  N   THR A 174      17.423  58.743  -1.682  1.00 16.67           N  
ATOM   1295  CA  THR A 174      16.378  59.585  -1.135  1.00 16.93           C  
ATOM   1296  C   THR A 174      15.121  58.758  -0.906  1.00 16.25           C  
ATOM   1297  O   THR A 174      14.878  57.795  -1.609  1.00 16.87           O  
ATOM   1298  CB  THR A 174      16.041  60.756  -2.129  1.00 16.32           C  
ATOM   1299  OG1 THR A 174      15.491  60.179  -3.322  1.00 16.73           O  
ATOM   1300  CG2 THR A 174      17.304  61.519  -2.650  1.00 17.35           C  
ATOM   1301  N   PRO A 175      14.283  59.165   0.044  1.00 16.92           N  
ATOM   1302  CA  PRO A 175      12.987  58.523   0.253  1.00 16.74           C  
ATOM   1303  C   PRO A 175      12.211  58.424  -1.050  1.00 16.98           C  
ATOM   1304  O   PRO A 175      11.474  57.472  -1.241  1.00 15.70           O  
ATOM   1305  CB  PRO A 175      12.295  59.500   1.181  1.00 17.17           C  
ATOM   1306  CG  PRO A 175      13.427  60.045   1.961  1.00 16.85           C  
ATOM   1307  CD  PRO A 175      14.503  60.290   0.988  1.00 17.32           C  
ATOM   1308  N   GLU A 176      12.321  59.431  -1.928  1.00 17.24           N  
ATOM   1309  CA  GLU A 176      11.467  59.385  -3.105  1.00 18.57           C  
ATOM   1310  C   GLU A 176      11.981  58.361  -4.098  1.00 16.51           C  
ATOM   1311  O   GLU A 176      11.198  57.660  -4.723  1.00 15.11           O  
ATOM   1312  CB  GLU A 176      11.226  60.769  -3.741  1.00 19.48           C  
ATOM   1313  CG  GLU A 176      12.217  61.831  -3.321  1.00 26.14           C  
ATOM   1314  CD  GLU A 176      11.957  62.392  -1.930  1.00 33.20           C  
ATOM   1315  OE1 GLU A 176      10.773  62.719  -1.615  1.00 38.20           O  
ATOM   1316  OE2 GLU A 176      12.940  62.506  -1.158  1.00 30.39           O  
ATOM   1317  N   GLU A 177      13.301  58.217  -4.207  1.00 16.22           N  
ATOM   1318  CA  GLU A 177      13.854  57.101  -4.984  1.00 15.69           C  
ATOM   1319  C   GLU A 177      13.419  55.770  -4.399  1.00 15.51           C  
ATOM   1320  O   GLU A 177      13.057  54.805  -5.125  1.00 15.72           O  
ATOM   1321  CB  GLU A 177      15.401  57.166  -5.036  1.00 15.12           C  
ATOM   1322  CG  GLU A 177      15.949  58.303  -5.931  1.00 16.58           C  
ATOM   1323  CD  GLU A 177      17.367  58.774  -5.551  1.00 18.00           C  
ATOM   1324  OE1 GLU A 177      17.943  58.317  -4.531  1.00 17.94           O  
ATOM   1325  OE2 GLU A 177      17.919  59.650  -6.261  1.00 19.82           O  
ATOM   1326  N   TYR A 178      13.557  55.650  -3.088  1.00 14.82           N  
ATOM   1327  CA  TYR A 178      13.224  54.347  -2.450  1.00 13.29           C  
ATOM   1328  C   TYR A 178      11.752  53.968  -2.726  1.00 14.65           C  
ATOM   1329  O   TYR A 178      11.461  52.847  -3.152  1.00 13.16           O  
ATOM   1330  CB  TYR A 178      13.441  54.536  -0.971  1.00 13.22           C  
ATOM   1331  CG  TYR A 178      13.115  53.377  -0.045  1.00 12.40           C  
ATOM   1332  CD1 TYR A 178      13.985  52.252   0.064  1.00 11.10           C  
ATOM   1333  CD2 TYR A 178      11.954  53.414   0.754  1.00 10.48           C  
ATOM   1334  CE1 TYR A 178      13.675  51.194   0.955  1.00 11.46           C  
ATOM   1335  CE2 TYR A 178      11.679  52.360   1.667  1.00 10.95           C  
ATOM   1336  CZ  TYR A 178      12.544  51.277   1.754  1.00 11.89           C  
ATOM   1337  OH  TYR A 178      12.222  50.266   2.623  1.00 10.96           O  
ATOM   1338  N   TYR A 179      10.833  54.927  -2.526  1.00 14.09           N  
ATOM   1339  CA  TYR A 179       9.398  54.649  -2.730  1.00 17.05           C  
ATOM   1340  C   TYR A 179       8.906  54.664  -4.188  1.00 18.38           C  
ATOM   1341  O   TYR A 179       7.809  54.190  -4.504  1.00 18.35           O  
ATOM   1342  CB  TYR A 179       8.563  55.547  -1.827  1.00 16.34           C  
ATOM   1343  CG  TYR A 179       8.569  55.135  -0.376  1.00 15.22           C  
ATOM   1344  CD1 TYR A 179       8.164  53.854   0.008  1.00 18.25           C  
ATOM   1345  CD2 TYR A 179       8.966  56.017   0.607  1.00 16.56           C  
ATOM   1346  CE1 TYR A 179       8.166  53.491   1.347  1.00 15.90           C  
ATOM   1347  CE2 TYR A 179       8.956  55.665   1.931  1.00 16.71           C  
ATOM   1348  CZ  TYR A 179       8.563  54.407   2.289  1.00 16.42           C  
ATOM   1349  OH  TYR A 179       8.570  54.069   3.618  1.00 15.46           O  
ATOM   1350  N   ASN A 180       9.739  55.166  -5.103  1.00 19.50           N  
ATOM   1351  CA  ASN A 180       9.393  55.046  -6.527  1.00 20.82           C  
ATOM   1352  C   ASN A 180       9.825  53.709  -7.168  1.00 20.65           C  
ATOM   1353  O   ASN A 180       9.424  53.375  -8.293  1.00 21.73           O  
ATOM   1354  CB  ASN A 180       9.890  56.253  -7.317  1.00 22.21           C  
ATOM   1355  CG  ASN A 180       8.984  57.525  -7.135  1.00 28.28           C  
ATOM   1356  OD1 ASN A 180       9.080  58.223  -6.128  1.00 31.33           O  
ATOM   1357  ND2 ASN A 180       8.114  57.804  -8.121  1.00 32.29           N  
ATOM   1358  N   VAL A 181      10.579  52.892  -6.437  1.00 19.97           N  
ATOM   1359  CA  VAL A 181      10.854  51.536  -6.912  1.00 19.46           C  
ATOM   1360  C   VAL A 181       9.573  50.730  -7.135  1.00 20.70           C  
ATOM   1361  O   VAL A 181       8.712  50.686  -6.265  1.00 20.60           O  
ATOM   1362  CB  VAL A 181      11.740  50.720  -5.925  1.00 19.83           C  
ATOM   1363  CG1 VAL A 181      11.843  49.265  -6.414  1.00 17.26           C  
ATOM   1364  CG2 VAL A 181      13.112  51.364  -5.789  1.00 18.47           C  
ATOM   1365  N   THR A 182       9.446  50.105  -8.300  1.00 22.33           N  
ATOM   1366  CA  THR A 182       8.356  49.176  -8.545  1.00 25.40           C  
ATOM   1367  C   THR A 182       8.891  47.730  -8.530  1.00 26.61           C  
ATOM   1368  O   THR A 182       9.767  47.396  -9.330  1.00 27.85           O  
ATOM   1369  CB  THR A 182       7.633  49.517  -9.886  1.00 26.22           C  
ATOM   1370  OG1 THR A 182       8.592  49.747 -10.925  1.00 27.99           O  
ATOM   1371  CG2 THR A 182       6.934  50.884  -9.784  1.00 27.42           C  
TER    1372      THR A 182                                                      
END
MOLECULE T0506.pdb
ATOM      1  N   VAL     4      16.223  74.529   6.413  1.00 43.65           N  
ATOM      2  CA  VAL     4      17.370  74.880   7.304  1.00 43.82           C  
ATOM      3  C   VAL     4      17.963  73.638   8.008  1.00 43.97           C  
ATOM      4  O   VAL     4      19.114  73.665   8.459  1.00 44.37           O  
ATOM      5  CB  VAL     4      16.969  76.004   8.316  1.00 43.84           C  
ATOM      6  CG1 VAL     4      18.109  76.346   9.267  1.00 44.06           C  
ATOM      7  CG2 VAL     4      16.529  77.270   7.571  1.00 43.89           C  
ATOM      8  N   ALA     5      17.192  72.548   8.063  1.00 43.79           N  
ATOM      9  CA  ALA     5      17.573  71.332   8.805  1.00 43.55           C  
ATOM     10  C   ALA     5      18.661  70.477   8.131  1.00 43.26           C  
ATOM     11  O   ALA     5      18.524  70.078   6.973  1.00 42.98           O  
ATOM     12  CB  ALA     5      16.339  70.479   9.111  1.00 43.90           C  
ATOM     13  N   PRO     6      19.740  70.170   8.871  1.00 43.22           N  
ATOM     14  CA  PRO     6      20.844  69.368   8.331  1.00 42.95           C  
ATOM     15  C   PRO     6      20.447  67.919   7.950  1.00 42.45           C  
ATOM     16  O   PRO     6      19.464  67.374   8.487  1.00 41.77           O  
ATOM     17  CB  PRO     6      21.854  69.359   9.484  1.00 43.23           C  
ATOM     18  CG  PRO     6      21.006  69.553  10.707  1.00 43.87           C  
ATOM     19  CD  PRO     6      19.985  70.552  10.274  1.00 43.24           C  
ATOM     20  N   PRO     7      21.198  67.301   7.015  1.00 41.83           N  
ATOM     21  CA  PRO     7      20.961  65.893   6.726  1.00 41.46           C  
ATOM     22  C   PRO     7      20.933  65.068   8.016  1.00 40.74           C  
ATOM     23  O   PRO     7      21.728  65.315   8.930  1.00 40.20           O  
ATOM     24  CB  PRO     7      22.164  65.498   5.854  1.00 42.16           C  
ATOM     25  CG  PRO     7      23.099  66.664   5.880  1.00 41.75           C  
ATOM     26  CD  PRO     7      22.276  67.858   6.180  1.00 41.68           C  
ATOM     27  N   VAL     8      19.999  64.129   8.112  1.00 40.33           N  
ATOM     28  CA  VAL     8      19.881  63.318   9.347  1.00 39.91           C  
ATOM     29  C   VAL     8      21.138  62.431   9.570  1.00 40.27           C  
ATOM     30  O   VAL     8      21.506  62.089  10.707  1.00 40.37           O  
ATOM     31  CB  VAL     8      18.516  62.556   9.435  1.00 39.67           C  
ATOM     32  CG1 VAL     8      17.329  63.555   9.348  1.00 36.98           C  
ATOM     33  CG2 VAL     8      18.390  61.517   8.365  1.00 38.22           C  
ATOM     34  N   ILE     9      21.801  62.086   8.475  1.00 40.55           N  
ATOM     35  CA  ILE     9      23.080  61.402   8.548  1.00 40.74           C  
ATOM     36  C   ILE     9      24.104  62.396   8.056  1.00 40.78           C  
ATOM     37  O   ILE     9      24.011  62.841   6.917  1.00 41.63           O  
ATOM     38  CB  ILE     9      23.118  60.143   7.647  1.00 40.61           C  
ATOM     39  CG1 ILE     9      21.953  59.189   7.985  1.00 41.00           C  
ATOM     40  CG2 ILE     9      24.517  59.462   7.731  1.00 39.79           C  
ATOM     41  CD1 ILE     9      21.690  58.061   6.971  1.00 40.63           C  
ATOM     42  N   THR    10      25.056  62.771   8.909  1.00 40.43           N  
ATOM     43  CA  THR    10      26.176  63.599   8.483  1.00 40.73           C  
ATOM     44  C   THR    10      27.078  62.807   7.534  1.00 40.81           C  
ATOM     45  O   THR    10      27.550  61.725   7.907  1.00 41.55           O  
ATOM     46  CB  THR    10      26.948  64.128   9.696  1.00 40.40           C  
ATOM     47  OG1 THR    10      26.031  64.861  10.516  1.00 39.93           O  
ATOM     48  CG2 THR    10      28.134  65.030   9.289  1.00 40.89           C  
ATOM     49  N   PRO    11      27.264  63.306   6.290  1.00 40.27           N  
ATOM     50  CA  PRO    11      28.106  62.635   5.300  1.00 40.30           C  
ATOM     51  C   PRO    11      29.531  62.424   5.796  1.00 40.59           C  
ATOM     52  O   PRO    11      30.089  63.270   6.519  1.00 40.09           O  
ATOM     53  CB  PRO    11      28.124  63.627   4.123  1.00 39.98           C  
ATOM     54  CG  PRO    11      26.898  64.368   4.249  1.00 39.70           C  
ATOM     55  CD  PRO    11      26.687  64.541   5.731  1.00 40.75           C  
ATOM     56  N   ARG    12      30.113  61.303   5.387  1.00 41.07           N  
ATOM     57  CA  ARG    12      31.472  60.953   5.767  1.00 41.14           C  
ATOM     58  C   ARG    12      32.453  61.993   5.258  1.00 41.53           C  
ATOM     59  O   ARG    12      33.228  62.542   6.035  1.00 41.73           O  
ATOM     60  CB  ARG    12      31.835  59.577   5.213  1.00 41.12           C  
ATOM     61  CG  ARG    12      32.473  58.648   6.214  1.00 39.82           C  
ATOM     62  CD  ARG    12      33.423  59.386   7.103  1.00 37.35           C  
ATOM     63  NE  ARG    12      34.538  58.566   7.537  1.00 35.24           N  
ATOM     64  CZ  ARG    12      35.491  59.009   8.340  1.00 36.29           C  
ATOM     65  NH1 ARG    12      35.452  60.263   8.767  1.00 35.93           N  
ATOM     66  NH2 ARG    12      36.488  58.210   8.710  1.00 36.57           N  
ATOM     67  N   PHE    24      26.609  45.777  -8.751  1.00 49.65           N  
ATOM     68  CA  PHE    24      26.051  46.396  -7.541  1.00 49.63           C  
ATOM     69  C   PHE    24      25.420  47.733  -7.925  1.00 48.93           C  
ATOM     70  O   PHE    24      26.123  48.667  -8.335  1.00 49.03           O  
ATOM     71  CB  PHE    24      27.132  46.601  -6.452  1.00 49.78           C  
ATOM     72  CG  PHE    24      26.616  47.272  -5.196  1.00 50.83           C  
ATOM     73  CD1 PHE    24      26.081  46.515  -4.146  1.00 50.02           C  
ATOM     74  CD2 PHE    24      26.659  48.674  -5.061  1.00 51.88           C  
ATOM     75  CE1 PHE    24      25.585  47.152  -2.977  1.00 50.73           C  
ATOM     76  CE2 PHE    24      26.163  49.313  -3.901  1.00 50.87           C  
ATOM     77  CZ  PHE    24      25.627  48.551  -2.863  1.00 49.25           C  
ATOM     78  N   GLU    25      24.099  47.813  -7.832  1.00 47.53           N  
ATOM     79  CA  GLU    25      23.428  49.088  -8.068  1.00 46.43           C  
ATOM     80  C   GLU    25      22.710  49.488  -6.817  1.00 44.86           C  
ATOM     81  O   GLU    25      21.685  48.901  -6.451  1.00 45.13           O  
ATOM     82  CB  GLU    25      22.471  49.047  -9.256  1.00 47.06           C  
ATOM     83  CG  GLU    25      22.225  50.443  -9.881  1.00 47.24           C  
ATOM     84  CD  GLU    25      21.172  51.248  -9.119  1.00 46.10           C  
ATOM     85  OE1 GLU    25      21.561  52.100  -8.295  1.00 45.74           O  
ATOM     86  OE2 GLU    25      19.958  51.022  -9.342  1.00 44.94           O  
ATOM     87  N   ALA    26      23.264  50.509  -6.181  1.00 43.10           N  
ATOM     88  CA  ALA    26      22.889  50.896  -4.846  1.00 42.10           C  
ATOM     89  C   ALA    26      21.383  50.862  -4.620  1.00 41.22           C  
ATOM     90  O   ALA    26      20.938  50.241  -3.667  1.00 41.52           O  
ATOM     91  CB  ALA    26      23.459  52.259  -4.514  1.00 42.27           C  
ATOM     92  N   VAL    27      20.618  51.503  -5.507  1.00 39.82           N  
ATOM     93  CA  VAL    27      19.170  51.685  -5.330  1.00 38.62           C  
ATOM     94  C   VAL    27      18.441  50.333  -5.389  1.00 38.25           C  
ATOM     95  O   VAL    27      17.627  50.011  -4.527  1.00 38.38           O  
ATOM     96  CB  VAL    27      18.586  52.704  -6.353  1.00 37.58           C  
ATOM     97  CG1 VAL    27      17.069  52.638  -6.404  1.00 37.20           C  
ATOM     98  CG2 VAL    27      19.050  54.113  -6.001  1.00 37.77           C  
ATOM     99  N   ARG    28      18.794  49.533  -6.374  1.00 38.45           N  
ATOM    100  CA  ARG    28      18.189  48.223  -6.565  1.00 39.15           C  
ATOM    101  C   ARG    28      18.541  47.242  -5.432  1.00 38.81           C  
ATOM    102  O   ARG    28      17.647  46.634  -4.831  1.00 39.72           O  
ATOM    103  CB  ARG    28      18.559  47.687  -7.963  1.00 38.85           C  
ATOM    104  CG  ARG    28      18.278  46.216  -8.142  1.00 41.94           C  
ATOM    105  CD  ARG    28      16.816  45.790  -7.837  1.00 45.21           C  
ATOM    106  NE  ARG    28      16.439  44.831  -8.874  1.00 51.01           N  
ATOM    107  CZ  ARG    28      16.676  43.525  -8.835  1.00 49.95           C  
ATOM    108  NH1 ARG    28      17.225  42.961  -7.766  1.00 50.06           N  
ATOM    109  NH2 ARG    28      16.313  42.783  -9.854  1.00 49.70           N  
ATOM    110  N   VAL    29      19.822  47.129  -5.087  1.00 38.22           N  
ATOM    111  CA  VAL    29      20.219  46.316  -3.927  1.00 37.36           C  
ATOM    112  C   VAL    29      19.496  46.775  -2.649  1.00 36.79           C  
ATOM    113  O   VAL    29      19.018  45.955  -1.848  1.00 36.89           O  
ATOM    114  CB  VAL    29      21.772  46.348  -3.708  1.00 37.56           C  
ATOM    115  CG1 VAL    29      22.144  45.746  -2.370  1.00 37.50           C  
ATOM    116  CG2 VAL    29      22.494  45.612  -4.819  1.00 37.85           C  
ATOM    117  N   ALA    30      19.421  48.097  -2.454  1.00 35.35           N  
ATOM    118  CA  ALA    30      18.687  48.682  -1.336  1.00 34.46           C  
ATOM    119  C   ALA    30      17.203  48.317  -1.292  1.00 33.63           C  
ATOM    120  O   ALA    30      16.700  47.953  -0.243  1.00 33.01           O  
ATOM    121  CB  ALA    30      18.851  50.228  -1.333  1.00 33.58           C  
ATOM    122  N   ARG    31      16.515  48.424  -2.422  1.00 32.99           N  
ATOM    123  CA  ARG    31      15.084  48.146  -2.496  1.00 34.07           C  
ATOM    124  C   ARG    31      14.826  46.663  -2.284  1.00 33.95           C  
ATOM    125  O   ARG    31      13.803  46.281  -1.725  1.00 35.51           O  
ATOM    126  CB  ARG    31      14.481  48.670  -3.812  1.00 33.27           C  
ATOM    127  CG  ARG    31      14.226  50.179  -3.744  1.00 34.01           C  
ATOM    128  CD  ARG    31      13.577  50.726  -5.019  1.00 35.99           C  
ATOM    129  NE  ARG    31      12.143  50.433  -5.017  1.00 33.98           N  
ATOM    130  CZ  ARG    31      11.416  50.411  -6.115  1.00 38.90           C  
ATOM    131  NH1 ARG    31      12.005  50.704  -7.262  1.00 31.97           N  
ATOM    132  NH2 ARG    31      10.110  50.128  -6.060  1.00 42.34           N  
ATOM    133  N   ASP    32      15.778  45.838  -2.686  1.00 34.58           N  
ATOM    134  CA  ASP    32      15.679  44.398  -2.466  0.50 35.02           C  
ATOM    136  C   ASP    32      15.826  44.056  -1.006  1.00 34.99           C  
ATOM    137  O   ASP    32      15.045  43.274  -0.480  1.00 35.71           O  
ATOM    138  CB  ASP    32      16.723  43.631  -3.275  0.50 34.91           C  
ATOM    140  CG  ASP    32      16.252  42.240  -3.643  0.50 37.60           C  
ATOM    142  OD1 ASP    32      15.113  42.109  -4.168  0.50 37.96           O  
ATOM    144  OD2 ASP    32      17.027  41.278  -3.431  0.50 39.94           O  
ATOM    146  N   VAL    33      16.799  44.665  -0.335  1.00 35.69           N  
ATOM    147  CA  VAL    33      16.952  44.479   1.129  1.00 35.38           C  
ATOM    148  C   VAL    33      15.725  44.991   1.852  1.00 36.91           C  
ATOM    149  O   VAL    33      15.266  44.403   2.861  1.00 37.01           O  
ATOM    150  CB  VAL    33      18.200  45.234   1.681  1.00 35.08           C  
ATOM    151  CG1 VAL    33      18.291  45.100   3.203  1.00 35.22           C  
ATOM    152  CG2 VAL    33      19.474  44.688   1.037  1.00 33.53           C  
ATOM    153  N   LEU    34      15.223  46.132   1.383  1.00 36.92           N  
ATOM    154  CA  LEU    34      14.044  46.713   1.963  1.00 37.55           C  
ATOM    155  C   LEU    34      12.872  45.725   1.973  1.00 37.09           C  
ATOM    156  O   LEU    34      12.183  45.569   3.011  1.00 37.29           O  
ATOM    157  CB  LEU    34      13.635  47.981   1.239  1.00 37.10           C  
ATOM    158  CG  LEU    34      12.325  48.656   1.652  1.00 36.56           C  
ATOM    159  CD1 LEU    34      12.382  49.294   3.019  1.00 35.33           C  
ATOM    160  CD2 LEU    34      12.021  49.705   0.548  1.00 33.63           C  
ATOM    161  N   HIS    35      12.674  45.055   0.852  1.00 36.94           N  
ATOM    162  CA  HIS    35      11.488  44.235   0.692  1.00 37.17           C  
ATOM    163  C   HIS    35      11.613  42.812   1.221  1.00 37.43           C  
ATOM    164  O   HIS    35      10.598  42.106   1.372  1.00 36.36           O  
ATOM    165  CB  HIS    35      11.031  44.238  -0.765  1.00 36.90           C  
ATOM    166  CG  HIS    35      10.298  45.502  -1.165  1.00 37.86           C  
ATOM    167  ND1 HIS    35       8.920  45.593  -1.165  1.00 38.07           N  
ATOM    168  CD2 HIS    35      10.751  46.717  -1.569  1.00 36.41           C  
ATOM    169  CE1 HIS    35       8.553  46.819  -1.526  1.00 36.43           C  
ATOM    170  NE2 HIS    35       9.647  47.517  -1.784  1.00 36.29           N  
ATOM    171  N   THR    36      12.843  42.372   1.438  1.00 36.97           N  
ATOM    172  CA  THR    36      13.079  40.969   1.718  1.00 37.62           C  
ATOM    173  C   THR    36      13.741  40.752   3.075  1.00 38.16           C  
ATOM    174  O   THR    36      14.194  39.635   3.373  1.00 38.65           O  
ATOM    175  CB  THR    36      13.897  40.253   0.588  1.00 39.04           C  
ATOM    176  OG1 THR    36      15.189  40.884   0.435  1.00 37.71           O  
ATOM    177  CG2 THR    36      13.146  40.274  -0.759  1.00 37.27           C  
ATOM    178  N   SER    37      13.811  41.788   3.890  1.00 37.79           N  
ATOM    179  CA  SER    37      14.363  41.613   5.263  1.00 39.48           C  
ATOM    180  C   SER    37      13.260  41.475   6.314  1.00 38.86           C  
ATOM    181  O   SER    37      12.412  42.358   6.422  1.00 38.51           O  
ATOM    182  CB  SER    37      15.345  42.762   5.618  1.00 38.38           C  
ATOM    183  OG  SER    37      16.371  42.838   4.608  1.00 41.05           O  
ATOM    184  N   ARG    38      13.268  40.369   7.076  1.00 39.77           N  
ATOM    185  CA  ARG    38      12.327  40.179   8.211  1.00 41.34           C  
ATOM    186  C   ARG    38      12.758  40.914   9.477  1.00 42.43           C  
ATOM    187  O   ARG    38      11.968  41.608  10.100  1.00 42.17           O  
ATOM    188  CB  ARG    38      12.100  38.691   8.578  1.00 41.21           C  
ATOM    189  CG  ARG    38      10.919  38.002   7.837  1.00 42.35           C  
ATOM    190  CD  ARG    38      10.623  36.515   8.413  1.00 44.16           C  
ATOM    191  NE  ARG    38       9.250  36.088   8.125  1.00 48.27           N  
ATOM    192  CZ  ARG    38       8.909  35.290   7.123  1.00 48.91           C  
ATOM    193  NH1 ARG    38       7.635  34.955   6.942  1.00 48.62           N  
ATOM    194  NH2 ARG    38       9.846  34.775   6.322  1.00 51.54           N  
ATOM    195  N   THR    39      14.015  40.742   9.867  1.00 43.04           N  
ATOM    196  CA  THR    39      14.487  41.282  11.126  1.00 43.56           C  
ATOM    197  C   THR    39      15.269  42.567  10.903  1.00 43.75           C  
ATOM    198  O   THR    39      16.001  42.696   9.921  1.00 43.67           O  
ATOM    199  CB  THR    39      15.318  40.257  11.910  1.00 43.91           C  
ATOM    200  OG1 THR    39      14.552  39.053  12.056  1.00 45.50           O  
ATOM    201  CG2 THR    39      15.640  40.777  13.315  1.00 44.70           C  
ATOM    202  N   ALA    40      15.033  43.524  11.799  1.00 41.52           N  
ATOM    203  CA  ALA    40      15.651  44.828  11.787  1.00 40.98           C  
ATOM    204  C   ALA    40      16.237  45.164  13.169  1.00 40.63           C  
ATOM    205  O   ALA    40      15.643  44.853  14.180  1.00 40.12           O  
ATOM    206  CB  ALA    40      14.604  45.873  11.432  1.00 41.19           C  
ATOM    207  N   ALA    41      17.418  45.765  13.177  1.00 39.80           N  
ATOM    208  CA  ALA    41      17.920  46.465  14.324  1.00 38.78           C  
ATOM    209  C   ALA    41      17.158  47.790  14.407  1.00 39.25           C  
ATOM    210  O   ALA    41      16.861  48.426  13.397  1.00 38.98           O  
ATOM    211  CB  ALA    41      19.416  46.708  14.140  1.00 39.12           C  
ATOM    212  N   LEU    42      16.797  48.193  15.623  1.00 38.68           N  
ATOM    213  CA  LEU    42      16.037  49.406  15.853  1.00 39.79           C  
ATOM    214  C   LEU    42      16.785  50.125  16.957  1.00 39.98           C  
ATOM    215  O   LEU    42      17.011  49.536  18.044  1.00 38.61           O  
ATOM    216  CB  LEU    42      14.655  49.049  16.433  1.00 40.02           C  
ATOM    217  CG  LEU    42      13.458  50.015  16.368  1.00 43.63           C  
ATOM    218  CD1 LEU    42      12.539  49.898  17.612  1.00 42.40           C  
ATOM    219  CD2 LEU    42      13.771  51.474  16.022  1.00 39.93           C  
ATOM    220  N   ALA    43      17.123  51.378  16.688  1.00 38.14           N  
ATOM    221  CA  ALA    43      17.741  52.250  17.656  1.00 38.67           C  
ATOM    222  C   ALA    43      16.827  53.423  17.999  1.00 39.37           C  
ATOM    223  O   ALA    43      16.177  54.035  17.134  1.00 40.23           O  
ATOM    224  CB  ALA    43      19.111  52.747  17.153  1.00 38.06           C  
ATOM    225  N   THR    44      16.877  53.783  19.273  1.00 39.46           N  
ATOM    226  CA  THR    44      15.964  54.691  19.898  1.00 38.96           C  
ATOM    227  C   THR    44      16.884  55.530  20.822  1.00 38.63           C  
ATOM    228  O   THR    44      18.054  55.168  21.043  1.00 38.06           O  
ATOM    229  CB  THR    44      14.985  53.702  20.568  1.00 40.23           C  
ATOM    230  OG1 THR    44      13.679  53.682  19.961  1.00 45.89           O  
ATOM    231  CG2 THR    44      15.079  53.504  22.014  1.00 33.78           C  
ATOM    232  N   LEU    45      16.389  56.659  21.328  1.00 38.88           N  
ATOM    233  CA  LEU    45      17.207  57.508  22.210  1.00 38.18           C  
ATOM    234  C   LEU    45      16.689  57.522  23.642  1.00 38.60           C  
ATOM    235  O   LEU    45      15.488  57.696  23.887  1.00 39.08           O  
ATOM    236  CB  LEU    45      17.306  58.953  21.676  1.00 38.20           C  
ATOM    237  CG  LEU    45      17.965  59.257  20.311  1.00 38.94           C  
ATOM    238  CD1 LEU    45      17.732  60.739  19.933  1.00 35.37           C  
ATOM    239  CD2 LEU    45      19.475  58.944  20.302  1.00 34.51           C  
ATOM    240  N   ASP    46      17.602  57.365  24.594  1.00 38.81           N  
ATOM    241  CA  ASP    46      17.234  57.458  25.978  1.00 38.11           C  
ATOM    242  C   ASP    46      16.965  58.919  26.355  1.00 38.82           C  
ATOM    243  O   ASP    46      17.782  59.804  26.077  1.00 39.17           O  
ATOM    244  CB  ASP    46      18.269  56.823  26.873  1.00 37.52           C  
ATOM    245  CG  ASP    46      17.782  56.687  28.297  1.00 38.27           C  
ATOM    246  OD1 ASP    46      17.801  57.702  29.037  1.00 39.29           O  
ATOM    247  OD2 ASP    46      17.353  55.572  28.670  1.00 39.12           O  
ATOM    248  N   PRO    47      15.793  59.181  26.968  1.00 39.51           N  
ATOM    249  CA  PRO    47      15.406  60.562  27.316  1.00 39.59           C  
ATOM    250  C   PRO    47      16.261  61.296  28.350  1.00 39.85           C  
ATOM    251  O   PRO    47      16.218  62.528  28.393  1.00 41.11           O  
ATOM    252  CB  PRO    47      13.972  60.421  27.810  1.00 39.48           C  
ATOM    253  CG  PRO    47      13.786  59.014  28.136  1.00 39.84           C  
ATOM    254  CD  PRO    47      14.738  58.210  27.302  1.00 39.29           C  
ATOM    255  N   VAL    48      16.978  60.575  29.215  1.00 39.58           N  
ATOM    256  CA  VAL    48      17.764  61.207  30.288  1.00 38.34           C  
ATOM    257  C   VAL    48      19.253  61.154  29.955  1.00 37.75           C  
ATOM    258  O   VAL    48      19.960  62.160  30.031  1.00 36.21           O  
ATOM    259  CB  VAL    48      17.522  60.535  31.703  1.00 38.53           C  
ATOM    260  CG1 VAL    48      18.371  61.189  32.800  1.00 38.22           C  
ATOM    261  CG2 VAL    48      16.045  60.571  32.106  1.00 38.99           C  
ATOM    262  N   SER    49      19.719  59.969  29.570  1.00 37.22           N  
ATOM    263  CA  SER    49      21.152  59.725  29.436  1.00 37.08           C  
ATOM    264  C   SER    49      21.684  60.192  28.093  1.00 37.18           C  
ATOM    265  O   SER    49      22.841  60.545  27.976  1.00 37.79           O  
ATOM    266  CB  SER    49      21.474  58.250  29.669  1.00 37.19           C  
ATOM    267  OG  SER    49      20.872  57.441  28.663  1.00 35.06           O  
ATOM    268  N   GLY    50      20.835  60.174  27.079  1.00 38.39           N  
ATOM    269  CA  GLY    50      21.214  60.622  25.742  1.00 38.15           C  
ATOM    270  C   GLY    50      21.913  59.521  24.969  1.00 36.98           C  
ATOM    271  O   GLY    50      22.166  59.670  23.775  1.00 37.41           O  
ATOM    272  N   TYR    51      22.211  58.412  25.651  1.00 35.98           N  
ATOM    273  CA  TYR    51      22.733  57.203  25.004  1.00 34.74           C  
ATOM    274  C   TYR    51      21.698  56.630  24.013  1.00 34.55           C  
ATOM    275  O   TYR    51      20.453  56.775  24.230  1.00 35.08           O  
ATOM    276  CB  TYR    51      23.047  56.109  26.039  1.00 33.87           C  
ATOM    277  CG  TYR    51      24.321  56.276  26.852  1.00 33.36           C  
ATOM    278  CD1 TYR    51      25.393  55.409  26.676  1.00 32.99           C  
ATOM    279  CD2 TYR    51      24.442  57.298  27.780  1.00 33.00           C  
ATOM    280  CE1 TYR    51      26.558  55.551  27.429  1.00 34.11           C  
ATOM    281  CE2 TYR    51      25.600  57.456  28.550  1.00 35.12           C  
ATOM    282  CZ  TYR    51      26.653  56.575  28.352  1.00 34.84           C  
ATOM    283  OH  TYR    51      27.786  56.715  29.074  1.00 32.74           O  
ATOM    284  N   PRO    52      22.191  55.951  22.950  1.00 34.99           N  
ATOM    285  CA  PRO    52      21.241  55.231  22.109  1.00 34.67           C  
ATOM    286  C   PRO    52      20.776  53.982  22.843  1.00 35.35           C  
ATOM    287  O   PRO    52      21.419  53.563  23.835  1.00 34.36           O  
ATOM    288  CB  PRO    52      22.052  54.874  20.842  1.00 35.16           C  
ATOM    289  CG  PRO    52      23.495  54.940  21.259  1.00 34.77           C  
ATOM    290  CD  PRO    52      23.602  55.799  22.497  1.00 34.82           C  
ATOM    291  N   TYR    53      19.673  53.403  22.378  1.00 35.86           N  
ATOM    292  CA  TYR    53      19.173  52.180  22.965  1.00 36.96           C  
ATOM    293  C   TYR    53      18.667  51.328  21.811  1.00 36.80           C  
ATOM    294  O   TYR    53      17.880  51.791  21.003  1.00 37.91           O  
ATOM    295  CB  TYR    53      18.040  52.462  24.003  1.00 36.72           C  
ATOM    296  CG  TYR    53      17.422  51.187  24.528  1.00 38.05           C  
ATOM    297  CD1 TYR    53      17.975  50.523  25.627  1.00 38.59           C  
ATOM    298  CD2 TYR    53      16.305  50.606  23.893  1.00 37.83           C  
ATOM    299  CE1 TYR    53      17.424  49.341  26.105  1.00 39.91           C  
ATOM    300  CE2 TYR    53      15.747  49.416  24.370  1.00 39.19           C  
ATOM    301  CZ  TYR    53      16.310  48.792  25.458  1.00 38.48           C  
ATOM    302  OH  TYR    53      15.774  47.610  25.907  1.00 40.55           O  
ATOM    303  N   THR    54      19.131  50.080  21.734  1.00 37.35           N  
ATOM    304  CA  THR    54      18.820  49.210  20.616  1.00 36.80           C  
ATOM    305  C   THR    54      17.924  48.044  20.993  1.00 37.74           C  
ATOM    306  O   THR    54      17.930  47.569  22.152  1.00 37.88           O  
ATOM    307  CB  THR    54      20.095  48.663  19.947  1.00 37.33           C  
ATOM    308  OG1 THR    54      20.944  48.083  20.945  1.00 36.66           O  
ATOM    309  CG2 THR    54      20.831  49.750  19.249  1.00 37.47           C  
ATOM    310  N   THR    55      17.168  47.563  20.005  1.00 37.99           N  
ATOM    311  CA  THR    55      16.482  46.258  20.101  1.00 38.74           C  
ATOM    312  C   THR    55      16.468  45.581  18.733  1.00 38.58           C  
ATOM    313  O   THR    55      16.991  46.145  17.767  1.00 38.75           O  
ATOM    314  CB  THR    55      15.031  46.362  20.760  1.00 39.15           C  
ATOM    315  OG1 THR    55      14.547  45.043  21.053  1.00 42.34           O  
ATOM    316  CG2 THR    55      14.021  47.094  19.861  1.00 37.54           C  
ATOM    317  N   ALA    56      15.919  44.370  18.666  1.00 37.63           N  
ATOM    318  CA  ALA    56      15.601  43.697  17.415  1.00 38.20           C  
ATOM    319  C   ALA    56      14.083  43.590  17.259  1.00 38.64           C  
ATOM    320  O   ALA    56      13.374  43.290  18.226  1.00 38.50           O  
ATOM    321  CB  ALA    56      16.243  42.301  17.344  1.00 37.34           C  
ATOM    322  N   THR    57      13.593  43.808  16.043  1.00 38.00           N  
ATOM    323  CA  THR    57      12.144  43.750  15.804  1.00 39.69           C  
ATOM    324  C   THR    57      11.844  43.200  14.405  1.00 40.17           C  
ATOM    325  O   THR    57      12.767  43.030  13.611  1.00 39.47           O  
ATOM    326  CB  THR    57      11.479  45.144  16.054  1.00 39.51           C  
ATOM    327  OG1 THR    57      10.075  44.982  16.284  1.00 42.44           O  
ATOM    328  CG2 THR    57      11.769  46.175  14.922  1.00 37.64           C  
ATOM    329  N   ASN    58      10.569  42.905  14.141  1.00 39.45           N  
ATOM    330  CA  ASN    58      10.140  42.384  12.852  1.00 40.47           C  
ATOM    331  C   ASN    58       9.653  43.550  11.984  1.00 39.86           C  
ATOM    332  O   ASN    58       8.995  44.471  12.473  1.00 39.32           O  
ATOM    333  CB  ASN    58       8.964  41.419  13.043  1.00 39.87           C  
ATOM    334  CG  ASN    58       9.261  40.264  13.997  1.00 42.71           C  
ATOM    335  OD1 ASN    58      10.325  39.625  13.945  1.00 43.20           O  
ATOM    336  ND2 ASN    58       8.253  39.910  14.811  1.00 41.63           N  
ATOM    337  N   ILE    59       9.872  43.453  10.689  1.00 40.97           N  
ATOM    338  CA  ILE    59       9.529  44.518   9.723  1.00 41.64           C  
ATOM    339  C   ILE    59       8.358  44.133   8.821  1.00 42.78           C  
ATOM    340  O   ILE    59       8.394  43.067   8.117  1.00 41.24           O  
ATOM    341  CB  ILE    59      10.792  44.815   8.837  1.00 41.35           C  
ATOM    342  CG1 ILE    59      11.835  45.573   9.675  1.00 42.44           C  
ATOM    343  CG2 ILE    59      10.454  45.666   7.603  1.00 44.65           C  
ATOM    344  CD1 ILE    59      11.346  46.945  10.221  1.00 39.10           C  
ATOM    345  N   GLY    60       7.314  44.975   8.847  1.00 43.54           N  
ATOM    346  CA  GLY    60       6.265  44.917   7.809  1.00 43.52           C  
ATOM    347  C   GLY    60       6.563  45.946   6.702  1.00 43.16           C  
ATOM    348  O   GLY    60       7.319  46.877   6.917  1.00 41.80           O  
ATOM    349  N   ILE    61       6.013  45.756   5.504  1.00 42.96           N  
ATOM    350  CA  ILE    61       6.196  46.748   4.436  1.00 44.08           C  
ATOM    351  C   ILE    61       4.826  47.088   3.847  1.00 43.86           C  
ATOM    352  O   ILE    61       4.039  46.184   3.546  1.00 45.44           O  
ATOM    353  CB  ILE    61       7.164  46.288   3.289  1.00 45.00           C  
ATOM    354  CG1 ILE    61       8.525  45.853   3.795  1.00 47.28           C  
ATOM    355  CG2 ILE    61       7.534  47.453   2.427  1.00 44.58           C  
ATOM    356  CD1 ILE    61       9.499  47.050   4.107  1.00 51.63           C  
ATOM    357  N   GLU    62       4.548  48.376   3.660  1.00 41.87           N  
ATOM    358  CA  GLU    62       3.316  48.797   3.016  1.00 41.07           C  
ATOM    359  C   GLU    62       3.499  48.862   1.468  1.00 41.15           C  
ATOM    360  O   GLU    62       4.639  48.887   0.990  1.00 41.34           O  
ATOM    361  CB  GLU    62       2.863  50.132   3.623  1.00 39.56           C  
ATOM    362  CG  GLU    62       2.863  50.081   5.181  1.00 39.44           C  
ATOM    363  CD  GLU    62       2.347  51.371   5.819  1.00 42.98           C  
ATOM    364  OE1 GLU    62       1.600  51.268   6.823  1.00 43.58           O  
ATOM    365  OE2 GLU    62       2.685  52.470   5.299  1.00 39.51           O  
ATOM    366  N   PRO    63       2.390  48.847   0.695  1.00 40.53           N  
ATOM    367  CA  PRO    63       2.460  48.832  -0.787  1.00 40.41           C  
ATOM    368  C   PRO    63       3.454  49.832  -1.394  1.00 39.89           C  
ATOM    369  O   PRO    63       4.140  49.476  -2.317  1.00 40.56           O  
ATOM    370  CB  PRO    63       1.033  49.157  -1.198  1.00 39.57           C  
ATOM    371  CG  PRO    63       0.213  48.552  -0.087  1.00 40.59           C  
ATOM    372  CD  PRO    63       0.995  48.773   1.160  1.00 40.41           C  
ATOM    373  N   ASP    64       3.560  51.048  -0.853  1.00 40.36           N  
ATOM    374  CA  ASP    64       4.530  52.054  -1.340  1.00 40.96           C  
ATOM    375  C   ASP    64       5.987  51.837  -0.852  1.00 41.65           C  
ATOM    376  O   ASP    64       6.844  52.696  -1.079  1.00 43.12           O  
ATOM    377  CB  ASP    64       4.066  53.493  -1.017  1.00 39.69           C  
ATOM    378  CG  ASP    64       4.138  53.809   0.465  1.00 40.09           C  
ATOM    379  OD1 ASP    64       3.820  54.926   0.865  1.00 40.33           O  
ATOM    380  OD2 ASP    64       4.498  52.913   1.241  1.00 36.40           O  
ATOM    381  N   GLY    65       6.228  50.735  -0.150  1.00 42.72           N  
ATOM    382  CA  GLY    65       7.554  50.370   0.345  1.00 44.04           C  
ATOM    383  C   GLY    65       7.891  50.838   1.747  1.00 44.29           C  
ATOM    384  O   GLY    65       8.999  50.566   2.222  1.00 45.96           O  
ATOM    385  N   THR    66       6.937  51.499   2.422  1.00 42.92           N  
ATOM    386  CA  THR    66       7.145  52.061   3.760  1.00 40.94           C  
ATOM    387  C   THR    66       7.233  50.965   4.834  1.00 40.64           C  
ATOM    388  O   THR    66       6.277  50.188   4.993  1.00 39.14           O  
ATOM    389  CB  THR    66       6.021  53.044   4.171  1.00 40.87           C  
ATOM    390  OG1 THR    66       5.955  54.140   3.252  1.00 40.45           O  
ATOM    391  CG2 THR    66       6.306  53.607   5.551  1.00 39.21           C  
ATOM    392  N   PRO    67       8.368  50.910   5.573  1.00 40.41           N  
ATOM    393  CA  PRO    67       8.465  49.942   6.647  1.00 41.38           C  
ATOM    394  C   PRO    67       7.598  50.307   7.843  1.00 41.41           C  
ATOM    395  O   PRO    67       7.431  51.490   8.173  1.00 40.86           O  
ATOM    396  CB  PRO    67       9.946  49.979   7.045  1.00 41.94           C  
ATOM    397  CG  PRO    67      10.638  50.775   6.040  1.00 41.43           C  
ATOM    398  CD  PRO    67       9.595  51.719   5.491  1.00 40.36           C  
ATOM    399  N   PHE    68       7.052  49.277   8.506  1.00 40.81           N  
ATOM    400  CA  PHE    68       6.285  49.530   9.723  1.00 39.59           C  
ATOM    401  C   PHE    68       6.606  48.413  10.691  1.00 39.37           C  
ATOM    402  O   PHE    68       7.122  47.356  10.315  1.00 38.92           O  
ATOM    403  CB  PHE    68       4.757  49.696   9.440  1.00 38.61           C  
ATOM    404  CG  PHE    68       4.008  48.388   9.182  1.00 38.40           C  
ATOM    405  CD1 PHE    68       3.373  47.706  10.228  1.00 39.53           C  
ATOM    406  CD2 PHE    68       3.910  47.857   7.890  1.00 37.81           C  
ATOM    407  CE1 PHE    68       2.642  46.505   9.975  1.00 40.30           C  
ATOM    408  CE2 PHE    68       3.216  46.680   7.637  1.00 39.43           C  
ATOM    409  CZ  PHE    68       2.582  45.996   8.692  1.00 40.88           C  
ATOM    410  N   PHE    69       6.294  48.640  11.947  1.00 39.54           N  
ATOM    411  CA  PHE    69       6.642  47.671  12.957  1.00 39.34           C  
ATOM    412  C   PHE    69       5.764  47.887  14.204  1.00 38.68           C  
ATOM    413  O   PHE    69       5.059  48.905  14.332  1.00 38.42           O  
ATOM    414  CB  PHE    69       8.148  47.734  13.285  1.00 39.39           C  
ATOM    415  CG  PHE    69       8.605  49.071  13.808  1.00 40.13           C  
ATOM    416  CD1 PHE    69       8.609  49.334  15.181  1.00 37.66           C  
ATOM    417  CD2 PHE    69       9.055  50.060  12.934  1.00 40.27           C  
ATOM    418  CE1 PHE    69       9.039  50.590  15.678  1.00 40.43           C  
ATOM    419  CE2 PHE    69       9.487  51.301  13.407  1.00 39.29           C  
ATOM    420  CZ  PHE    69       9.483  51.566  14.796  1.00 42.12           C  
ATOM    421  N   PHE    70       5.835  46.889  15.076  1.00 38.05           N  
ATOM    422  CA  PHE    70       5.076  46.866  16.296  0.50 38.37           C  
ATOM    424  C   PHE    70       6.038  46.859  17.464  1.00 38.87           C  
ATOM    425  O   PHE    70       7.149  46.304  17.360  1.00 38.01           O  
ATOM    426  CB  PHE    70       4.186  45.615  16.328  0.50 38.34           C  
ATOM    428  CG  PHE    70       4.063  44.995  17.679  0.50 37.72           C  
ATOM    430  CD1 PHE    70       3.134  45.471  18.599  0.50 36.50           C  
ATOM    432  CD2 PHE    70       4.879  43.917  18.036  0.50 38.31           C  
ATOM    434  CE1 PHE    70       3.023  44.878  19.863  0.50 37.53           C  
ATOM    436  CE2 PHE    70       4.773  43.321  19.307  0.50 36.98           C  
ATOM    438  CZ  PHE    70       3.851  43.807  20.216  0.50 36.69           C  
ATOM    440  N   ALA    71       5.596  47.458  18.571  1.00 38.29           N  
ATOM    441  CA  ALA    71       6.344  47.406  19.823  1.00 38.96           C  
ATOM    442  C   ALA    71       5.331  47.251  20.949  1.00 39.61           C  
ATOM    443  O   ALA    71       4.312  47.936  20.937  1.00 40.47           O  
ATOM    444  CB  ALA    71       7.151  48.660  20.043  1.00 38.39           C  
ATOM    445  N   ALA    72       5.592  46.345  21.892  1.00 39.98           N  
ATOM    446  CA  ALA    72       4.775  46.269  23.119  1.00 41.01           C  
ATOM    447  C   ALA    72       4.906  47.607  23.852  1.00 41.50           C  
ATOM    448  O   ALA    72       6.005  48.142  23.924  1.00 42.57           O  
ATOM    449  CB  ALA    72       5.262  45.138  23.991  1.00 40.44           C  
ATOM    450  N   GLY    73       3.808  48.150  24.386  1.00 41.80           N  
ATOM    451  CA  GLY    73       3.846  49.469  25.049  1.00 41.25           C  
ATOM    452  C   GLY    73       4.707  49.578  26.305  1.00 41.94           C  
ATOM    453  O   GLY    73       5.268  50.647  26.616  1.00 41.43           O  
ATOM    454  N   LEU    74       4.819  48.486  27.054  1.00 41.99           N  
ATOM    455  CA  LEU    74       5.571  48.544  28.315  1.00 43.68           C  
ATOM    456  C   LEU    74       7.093  48.305  28.146  1.00 43.63           C  
ATOM    457  O   LEU    74       7.759  47.837  29.053  1.00 44.67           O  
ATOM    458  CB  LEU    74       4.930  47.605  29.352  1.00 44.01           C  
ATOM    459  CG  LEU    74       3.413  47.749  29.578  1.00 46.05           C  
ATOM    460  CD1 LEU    74       2.965  46.988  30.851  1.00 49.35           C  
ATOM    461  CD2 LEU    74       2.939  49.230  29.653  1.00 48.89           C  
ATOM    462  N   THR    75       7.626  48.623  26.970  1.00 43.11           N  
ATOM    463  CA  THR    75       9.046  48.418  26.701  1.00 42.65           C  
ATOM    464  C   THR    75       9.824  49.744  26.683  1.00 42.24           C  
ATOM    465  O   THR    75       9.263  50.835  26.438  1.00 41.76           O  
ATOM    466  CB  THR    75       9.306  47.632  25.409  1.00 42.39           C  
ATOM    467  OG1 THR    75       8.924  48.421  24.270  1.00 44.12           O  
ATOM    468  CG2 THR    75       8.570  46.277  25.420  1.00 41.79           C  
ATOM    469  N   LEU    76      11.114  49.633  26.971  1.00 40.77           N  
ATOM    470  CA  LEU    76      12.015  50.766  26.924  1.00 41.14           C  
ATOM    471  C   LEU    76      12.007  51.489  25.574  1.00 40.66           C  
ATOM    472  O   LEU    76      11.944  52.711  25.542  1.00 39.81           O  
ATOM    473  CB  LEU    76      13.425  50.295  27.255  1.00 41.59           C  
ATOM    474  CG  LEU    76      14.009  50.414  28.673  1.00 43.88           C  
ATOM    475  CD1 LEU    76      13.137  51.171  29.678  1.00 45.72           C  
ATOM    476  CD2 LEU    76      14.462  49.068  29.235  1.00 45.24           C  
ATOM    477  N   HIS    77      12.082  50.753  24.458  1.00 39.75           N  
ATOM    478  CA  HIS    77      12.104  51.447  23.167  1.00 39.95           C  
ATOM    479  C   HIS    77      10.777  52.175  22.905  1.00 39.38           C  
ATOM    480  O   HIS    77      10.792  53.307  22.464  1.00 40.18           O  
ATOM    481  CB  HIS    77      12.509  50.543  21.992  1.00 39.44           C  
ATOM    482  CG  HIS    77      11.775  49.241  21.944  1.00 39.43           C  
ATOM    483  ND1 HIS    77      11.884  48.284  22.934  1.00 40.59           N  
ATOM    484  CD2 HIS    77      10.954  48.718  21.004  1.00 41.59           C  
ATOM    485  CE1 HIS    77      11.144  47.235  22.614  1.00 38.83           C  
ATOM    486  NE2 HIS    77      10.565  47.473  21.448  1.00 39.75           N  
ATOM    487  N   ALA    78       9.640  51.531  23.189  1.00 39.56           N  
ATOM    488  CA  ALA    78       8.326  52.206  23.113  1.00 38.93           C  
ATOM    489  C   ALA    78       8.338  53.516  23.887  1.00 38.55           C  
ATOM    490  O   ALA    78       7.962  54.567  23.330  1.00 39.14           O  
ATOM    491  CB  ALA    78       7.207  51.312  23.617  1.00 38.80           C  
ATOM    492  N   ARG    79       8.770  53.448  25.163  1.00 37.66           N  
ATOM    493  CA  ARG    79       8.928  54.611  26.013  1.00 37.31           C  
ATOM    494  C   ARG    79       9.798  55.654  25.329  1.00 37.34           C  
ATOM    495  O   ARG    79       9.412  56.836  25.268  1.00 36.32           O  
ATOM    496  CB  ARG    79       9.554  54.227  27.373  1.00 36.74           C  
ATOM    497  CG  ARG    79       9.456  55.287  28.537  1.00 37.11           C  
ATOM    498  CD  ARG    79      10.594  56.342  28.549  1.00 38.08           C  
ATOM    499  NE  ARG    79      11.916  55.725  28.313  1.00 40.43           N  
ATOM    500  CZ  ARG    79      12.646  55.127  29.241  1.00 38.21           C  
ATOM    501  NH1 ARG    79      12.214  55.069  30.506  1.00 37.01           N  
ATOM    502  NH2 ARG    79      13.817  54.592  28.914  1.00 38.84           N  
ATOM    503  N   ASN    80      10.978  55.233  24.861  1.00 37.06           N  
ATOM    504  CA  ASN    80      11.944  56.179  24.276  1.00 38.46           C  
ATOM    505  C   ASN    80      11.301  56.927  23.122  1.00 39.46           C  
ATOM    506  O   ASN    80      11.364  58.170  23.060  1.00 39.42           O  
ATOM    507  CB  ASN    80      13.239  55.484  23.823  1.00 38.83           C  
ATOM    508  CG  ASN    80      14.083  54.995  24.983  1.00 37.97           C  
ATOM    509  OD1 ASN    80      13.876  55.410  26.113  1.00 38.02           O  
ATOM    510  ND2 ASN    80      15.026  54.079  24.712  1.00 33.92           N  
ATOM    511  N   MET    81      10.639  56.167  22.250  1.00 40.14           N  
ATOM    512  CA  MET    81       9.919  56.713  21.108  1.00 42.73           C  
ATOM    513  C   MET    81       8.765  57.675  21.467  1.00 43.11           C  
ATOM    514  O   MET    81       8.520  58.618  20.730  1.00 42.53           O  
ATOM    515  CB  MET    81       9.432  55.580  20.198  1.00 42.61           C  
ATOM    516  CG  MET    81      10.568  54.902  19.431  1.00 43.80           C  
ATOM    517  SD  MET    81       9.974  53.560  18.134  0.90 48.49          SE  
ATOM    518  CE  MET    81       9.395  52.112  19.373  1.00 41.87           C  
ATOM    519  N   GLU    82       8.087  57.458  22.601  1.00 44.27           N  
ATOM    520  CA  GLU    82       7.135  58.466  23.137  1.00 45.85           C  
ATOM    521  C   GLU    82       7.860  59.782  23.394  1.00 45.91           C  
ATOM    522  O   GLU    82       7.403  60.843  22.989  1.00 46.79           O  
ATOM    523  CB  GLU    82       6.489  58.039  24.470  1.00 45.53           C  
ATOM    524  CG  GLU    82       5.217  57.205  24.406  1.00 48.85           C  
ATOM    525  CD  GLU    82       4.247  57.594  23.266  1.00 54.63           C  
ATOM    526  OE1 GLU    82       3.253  58.314  23.531  1.00 55.24           O  
ATOM    527  OE2 GLU    82       4.470  57.147  22.101  1.00 57.39           O  
ATOM    528  N   THR    83       8.992  59.693  24.080  1.00 46.45           N  
ATOM    529  CA  THR    83       9.771  60.867  24.475  1.00 45.76           C  
ATOM    530  C   THR    83      10.447  61.603  23.288  1.00 45.32           C  
ATOM    531  O   THR    83      10.521  62.828  23.305  1.00 45.43           O  
ATOM    532  CB  THR    83      10.795  60.516  25.590  1.00 46.00           C  
ATOM    533  OG1 THR    83      11.720  59.527  25.129  1.00 46.47           O  
ATOM    534  CG2 THR    83      10.084  59.971  26.841  1.00 46.29           C  
ATOM    535  N   ASP    84      10.895  60.857  22.263  1.00 43.62           N  
ATOM    536  CA  ASP    84      11.665  61.391  21.128  1.00 41.98           C  
ATOM    537  C   ASP    84      11.534  60.402  19.962  1.00 41.59           C  
ATOM    538  O   ASP    84      11.974  59.236  20.064  1.00 40.45           O  
ATOM    539  CB  ASP    84      13.139  61.539  21.541  1.00 42.13           C  
ATOM    540  CG  ASP    84      14.009  62.236  20.488  1.00 42.54           C  
ATOM    541  OD1 ASP    84      13.770  62.126  19.266  1.00 43.26           O  
ATOM    542  OD2 ASP    84      14.984  62.892  20.912  1.00 44.27           O  
ATOM    543  N   ALA    85      10.941  60.861  18.856  1.00 39.53           N  
ATOM    544  CA  ALA    85      10.596  59.949  17.752  1.00 38.78           C  
ATOM    545  C   ALA    85      11.753  59.634  16.791  1.00 38.06           C  
ATOM    546  O   ALA    85      11.574  58.840  15.886  1.00 38.40           O  
ATOM    547  CB  ALA    85       9.356  60.477  16.964  1.00 38.66           C  
ATOM    548  N   ARG    86      12.921  60.255  16.968  1.00 37.49           N  
ATOM    549  CA  ARG    86      14.075  59.998  16.101  1.00 37.80           C  
ATOM    550  C   ARG    86      14.598  58.573  16.313  1.00 37.79           C  
ATOM    551  O   ARG    86      14.936  58.172  17.447  1.00 38.77           O  
ATOM    552  CB  ARG    86      15.191  61.015  16.337  1.00 37.29           C  
ATOM    553  CG  ARG    86      14.782  62.423  15.962  1.00 37.81           C  
ATOM    554  CD  ARG    86      15.909  63.377  16.220  1.00 40.31           C  
ATOM    555  NE  ARG    86      16.150  63.542  17.639  1.00 40.47           N  
ATOM    556  CZ  ARG    86      17.144  64.262  18.153  1.00 42.65           C  
ATOM    557  NH1 ARG    86      17.257  64.358  19.461  1.00 40.10           N  
ATOM    558  NH2 ARG    86      18.022  64.881  17.368  1.00 43.73           N  
ATOM    559  N   ILE    87      14.606  57.800  15.230  1.00 38.06           N  
ATOM    560  CA  ILE    87      15.018  56.378  15.256  1.00 36.98           C  
ATOM    561  C   ILE    87      15.927  56.047  14.083  1.00 38.03           C  
ATOM    562  O   ILE    87      16.014  56.818  13.113  1.00 37.74           O  
ATOM    563  CB  ILE    87      13.797  55.385  15.235  1.00 36.88           C  
ATOM    564  CG1 ILE    87      12.957  55.462  13.944  1.00 36.90           C  
ATOM    565  CG2 ILE    87      12.886  55.630  16.470  1.00 36.77           C  
ATOM    566  CD1 ILE    87      12.027  54.186  13.735  1.00 34.81           C  
ATOM    567  N   SER    88      16.604  54.893  14.173  1.00 38.43           N  
ATOM    568  CA  SER    88      17.331  54.328  13.048  1.00 37.90           C  
ATOM    569  C   SER    88      17.026  52.830  12.974  1.00 38.40           C  
ATOM    570  O   SER    88      16.896  52.180  14.008  1.00 38.37           O  
ATOM    571  CB  SER    88      18.842  54.556  13.197  1.00 36.88           C  
ATOM    572  OG  SER    88      19.560  54.036  12.078  1.00 36.15           O  
ATOM    573  N   VAL    89      16.930  52.277  11.760  1.00 38.48           N  
ATOM    574  CA  VAL    89      16.787  50.813  11.601  1.00 38.88           C  
ATOM    575  C   VAL    89      17.830  50.302  10.631  1.00 38.06           C  
ATOM    576  O   VAL    89      18.230  51.035   9.725  1.00 36.88           O  
ATOM    577  CB  VAL    89      15.369  50.373  11.097  1.00 40.20           C  
ATOM    578  CG1 VAL    89      14.302  50.819  12.041  1.00 38.37           C  
ATOM    579  CG2 VAL    89      15.078  50.950   9.696  1.00 40.61           C  
ATOM    580  N   THR    90      18.312  49.087  10.863  1.00 37.53           N  
ATOM    581  CA  THR    90      19.163  48.436   9.884  1.00 37.70           C  
ATOM    582  C   THR    90      18.491  47.149   9.499  1.00 37.66           C  
ATOM    583  O   THR    90      18.180  46.320  10.339  1.00 38.80           O  
ATOM    584  CB  THR    90      20.601  48.220  10.352  1.00 35.79           C  
ATOM    585  OG1 THR    90      21.173  49.505  10.639  1.00 36.06           O  
ATOM    586  CG2 THR    90      21.482  47.492   9.246  1.00 37.44           C  
ATOM    587  N   LEU    91      18.250  47.032   8.200  1.00 38.53           N  
ATOM    588  CA  LEU    91      17.699  45.849   7.614  1.00 39.28           C  
ATOM    589  C   LEU    91      18.794  45.059   6.917  1.00 40.62           C  
ATOM    590  O   LEU    91      19.650  45.631   6.225  1.00 40.09           O  
ATOM    591  CB  LEU    91      16.605  46.249   6.647  1.00 40.01           C  
ATOM    592  CG  LEU    91      15.246  46.573   7.263  1.00 38.97           C  
ATOM    593  CD1 LEU    91      15.310  47.813   8.152  1.00 43.01           C  
ATOM    594  CD2 LEU    91      14.252  46.840   6.101  1.00 40.75           C  
ATOM    595  N   ALA    92      18.781  43.736   7.095  1.00 41.61           N  
ATOM    596  CA  ALA    92      19.736  42.893   6.387  1.00 43.96           C  
ATOM    597  C   ALA    92      19.142  41.498   6.171  1.00 46.03           C  
ATOM    598  O   ALA    92      18.278  41.098   6.966  1.00 47.72           O  
ATOM    599  CB  ALA    92      21.036  42.818   7.155  1.00 42.95           C  
ATOM    600  N   PRO    93      19.572  40.763   5.108  1.00 47.15           N  
ATOM    601  CA  PRO    93      19.204  39.332   5.006  1.00 47.61           C  
ATOM    602  C   PRO    93      19.973  38.543   6.092  1.00 47.80           C  
ATOM    603  O   PRO    93      20.882  37.772   5.765  1.00 47.05           O  
ATOM    604  CB  PRO    93      19.687  38.934   3.596  1.00 47.22           C  
ATOM    605  CG  PRO    93      20.845  39.877   3.317  1.00 47.42           C  
ATOM    606  CD  PRO    93      20.406  41.189   3.950  1.00 47.69           C  
ATOM    607  N   PHE    94      19.635  38.785   7.367  1.00 47.53           N  
ATOM    608  CA  PHE    94      20.393  38.209   8.489  1.00 48.62           C  
ATOM    609  C   PHE    94      20.432  36.678   8.505  1.00 50.08           C  
ATOM    610  O   PHE    94      21.419  36.076   8.964  1.00 51.13           O  
ATOM    611  CB  PHE    94      19.810  38.662   9.811  1.00 48.35           C  
ATOM    612  CG  PHE    94      20.107  40.061  10.144  1.00 48.23           C  
ATOM    613  CD1 PHE    94      21.394  40.456  10.421  1.00 47.44           C  
ATOM    614  CD2 PHE    94      19.080  41.006  10.192  1.00 46.55           C  
ATOM    615  CE1 PHE    94      21.655  41.793  10.741  1.00 49.24           C  
ATOM    616  CE2 PHE    94      19.329  42.325  10.524  1.00 47.35           C  
ATOM    617  CZ  PHE    94      20.607  42.724  10.797  1.00 48.46           C  
ATOM    618  N   GLY    95      19.369  36.036   8.025  1.00 50.07           N  
ATOM    619  CA  GLY    95      19.398  34.572   7.973  1.00 52.05           C  
ATOM    620  C   GLY    95      20.520  34.009   7.112  1.00 52.20           C  
ATOM    621  O   GLY    95      20.907  32.844   7.284  1.00 52.90           O  
ATOM    622  N   LYS    96      21.045  34.824   6.187  1.00 52.00           N  
ATOM    623  CA  LYS    96      21.969  34.329   5.148  1.00 51.83           C  
ATOM    624  C   LYS    96      23.437  34.283   5.579  1.00 51.44           C  
ATOM    625  O   LYS    96      24.319  34.006   4.770  1.00 51.70           O  
ATOM    626  CB  LYS    96      21.802  35.142   3.824  1.00 51.81           C  
ATOM    627  N   GLY    97      23.713  34.551   6.847  1.00 50.94           N  
ATOM    628  CA  GLY    97      25.090  34.414   7.308  1.00 50.33           C  
ATOM    629  C   GLY    97      25.611  35.687   7.922  1.00 49.54           C  
ATOM    630  O   GLY    97      24.831  36.573   8.261  1.00 50.33           O  
ATOM    631  N   ASP    98      26.932  35.782   8.047  1.00 49.05           N  
ATOM    632  CA  ASP    98      27.539  36.781   8.924  1.00 48.11           C  
ATOM    633  C   ASP    98      27.244  38.226   8.526  1.00 47.99           C  
ATOM    634  O   ASP    98      27.201  38.544   7.338  1.00 47.68           O  
ATOM    635  CB  ASP    98      29.033  36.507   9.105  1.00 47.96           C  
ATOM    636  CG  ASP    98      29.289  35.466  10.185  1.00 47.86           C  
ATOM    637  OD1 ASP    98      28.397  35.330  11.066  1.00 49.44           O  
ATOM    638  OD2 ASP    98      30.344  34.796  10.165  1.00 42.64           O  
ATOM    639  N   ALA    99      27.013  39.085   9.526  1.00 47.12           N  
ATOM    640  CA  ALA    99      26.613  40.475   9.280  1.00 47.62           C  
ATOM    641  C   ALA    99      27.544  41.255   8.332  1.00 47.81           C  
ATOM    642  O   ALA    99      27.066  41.994   7.462  1.00 49.11           O  
ATOM    643  CB  ALA    99      26.414  41.247  10.612  1.00 46.67           C  
ATOM    644  N   LEU   100      28.854  41.108   8.500  1.00 47.20           N  
ATOM    645  CA  LEU   100      29.784  41.843   7.668  1.00 47.26           C  
ATOM    646  C   LEU   100      29.881  41.320   6.208  1.00 47.34           C  
ATOM    647  O   LEU   100      30.537  41.933   5.366  1.00 47.80           O  
ATOM    648  CB  LEU   100      31.156  41.957   8.363  1.00 47.63           C  
ATOM    649  CG  LEU   100      31.246  42.793   9.655  1.00 47.37           C  
ATOM    650  CD1 LEU   100      32.698  42.945  10.097  1.00 44.40           C  
ATOM    651  CD2 LEU   100      30.603  44.166   9.523  1.00 47.96           C  
ATOM    652  N   THR   101      29.225  40.196   5.918  1.00 47.25           N  
ATOM    653  CA  THR   101      29.122  39.670   4.543  1.00 47.24           C  
ATOM    654  C   THR   101      27.868  40.174   3.822  1.00 47.24           C  
ATOM    655  O   THR   101      27.753  40.062   2.608  1.00 48.04           O  
ATOM    656  CB  THR   101      29.068  38.093   4.506  1.00 47.64           C  
ATOM    657  OG1 THR   101      27.862  37.639   5.158  1.00 47.49           O  
ATOM    658  CG2 THR   101      30.274  37.470   5.169  1.00 44.40           C  
ATOM    659  N   LEU   102      26.921  40.710   4.562  1.00 47.23           N  
ATOM    660  CA  LEU   102      25.623  41.022   4.011  1.00 47.59           C  
ATOM    661  C   LEU   102      25.497  42.449   3.542  1.00 46.58           C  
ATOM    662  O   LEU   102      26.127  43.302   4.092  1.00 46.32           O  
ATOM    663  CB  LEU   102      24.556  40.797   5.080  1.00 48.18           C  
ATOM    664  CG  LEU   102      24.513  39.508   5.876  1.00 49.29           C  
ATOM    665  CD1 LEU   102      23.450  39.497   6.890  1.00 47.88           C  
ATOM    666  CD2 LEU   102      24.375  38.361   4.974  1.00 48.28           C  
ATOM    667  N   PRO   103      24.634  42.711   2.567  1.00 45.68           N  
ATOM    668  CA  PRO   103      24.248  44.107   2.342  1.00 44.98           C  
ATOM    669  C   PRO   103      23.440  44.570   3.544  1.00 44.51           C  
ATOM    670  O   PRO   103      22.679  43.789   4.116  1.00 45.61           O  
ATOM    671  CB  PRO   103      23.360  44.042   1.099  1.00 45.24           C  
ATOM    672  CG  PRO   103      22.818  42.660   1.098  1.00 46.09           C  
ATOM    673  CD  PRO   103      23.959  41.807   1.626  1.00 45.51           C  
ATOM    674  N   ARG   104      23.642  45.803   3.964  1.00 42.27           N  
ATOM    675  CA  ARG   104      23.009  46.293   5.151  1.00 42.38           C  
ATOM    676  C   ARG   104      22.432  47.658   4.826  1.00 40.76           C  
ATOM    677  O   ARG   104      23.163  48.568   4.419  1.00 40.88           O  
ATOM    678  CB  ARG   104      24.002  46.412   6.307  1.00 42.35           C  
ATOM    679  CG  ARG   104      24.269  45.116   7.027  1.00 45.67           C  
ATOM    680  CD  ARG   104      25.616  44.582   6.761  1.00 47.32           C  
ATOM    681  NE  ARG   104      26.661  45.481   7.210  1.00 49.89           N  
ATOM    682  CZ  ARG   104      27.859  45.565   6.657  1.00 50.47           C  
ATOM    683  NH1 ARG   104      28.731  46.415   7.158  1.00 52.92           N  
ATOM    684  NH2 ARG   104      28.191  44.799   5.609  1.00 54.70           N  
ATOM    685  N   LEU   105      21.116  47.757   4.962  1.00 38.88           N  
ATOM    686  CA  LEU   105      20.420  48.984   4.661  1.00 37.14           C  
ATOM    687  C   LEU   105      20.077  49.715   5.945  1.00 37.01           C  
ATOM    688  O   LEU   105      19.348  49.180   6.791  1.00 36.52           O  
ATOM    689  CB  LEU   105      19.189  48.688   3.787  1.00 37.18           C  
ATOM    690  CG  LEU   105      18.183  49.809   3.601  1.00 37.12           C  
ATOM    691  CD1 LEU   105      18.777  50.834   2.609  1.00 38.71           C  
ATOM    692  CD2 LEU   105      16.883  49.254   3.095  1.00 39.88           C  
ATOM    693  N   THR   106      20.646  50.912   6.115  1.00 36.12           N  
ATOM    694  CA  THR   106      20.308  51.740   7.269  1.00 36.15           C  
ATOM    695  C   THR   106      19.352  52.861   6.858  1.00 36.02           C  
ATOM    696  O   THR   106      19.630  53.603   5.923  1.00 34.58           O  
ATOM    697  CB  THR   106      21.576  52.300   7.981  1.00 36.43           C  
ATOM    698  OG1 THR   106      22.362  51.202   8.439  1.00 37.67           O  
ATOM    699  CG2 THR   106      21.183  53.136   9.188  1.00 35.63           C  
ATOM    700  N   LEU   107      18.220  52.959   7.562  1.00 36.38           N  
ATOM    701  CA  LEU   107      17.226  53.997   7.322  1.00 37.39           C  
ATOM    702  C   LEU   107      17.071  54.808   8.598  1.00 37.59           C  
ATOM    703  O   LEU   107      16.786  54.255   9.658  1.00 38.36           O  
ATOM    704  CB  LEU   107      15.883  53.386   6.890  1.00 37.42           C  
ATOM    705  CG  LEU   107      15.888  52.335   5.754  1.00 38.96           C  
ATOM    706  CD1 LEU   107      14.515  51.683   5.658  1.00 38.73           C  
ATOM    707  CD2 LEU   107      16.225  52.995   4.407  1.00 37.32           C  
ATOM    708  N   VAL   108      17.306  56.117   8.486  1.00 37.38           N  
ATOM    709  CA  VAL   108      17.208  57.028   9.609  1.00 36.50           C  
ATOM    710  C   VAL   108      15.982  57.912   9.428  1.00 36.44           C  
ATOM    711  O   VAL   108      15.771  58.434   8.349  1.00 36.83           O  
ATOM    712  CB  VAL   108      18.506  57.843   9.752  1.00 35.47           C  
ATOM    713  CG1 VAL   108      18.391  58.875  10.868  1.00 35.13           C  
ATOM    714  CG2 VAL   108      19.692  56.899   9.952  1.00 33.05           C  
ATOM    715  N   GLY   109      15.178  58.090  10.478  1.00 37.67           N  
ATOM    716  CA  GLY   109      14.016  58.998  10.380  1.00 37.60           C  
ATOM    717  C   GLY   109      13.194  59.088  11.645  1.00 38.67           C  
ATOM    718  O   GLY   109      13.748  59.065  12.745  1.00 38.44           O  
ATOM    719  N   ARG   110      11.873  59.219  11.496  1.00 39.40           N  
ATOM    720  CA  ARG   110      10.971  59.310  12.660  1.00 39.19           C  
ATOM    721  C   ARG   110       9.996  58.148  12.742  1.00 39.98           C  
ATOM    722  O   ARG   110       9.556  57.623  11.725  1.00 40.59           O  
ATOM    723  CB  ARG   110      10.250  60.665  12.723  1.00 38.94           C  
ATOM    724  CG  ARG   110      11.188  61.811  13.077  1.00 37.80           C  
ATOM    725  CD  ARG   110      10.575  63.184  12.887  1.00 38.81           C  
ATOM    726  NE  ARG   110      11.606  64.173  13.201  1.00 40.29           N  
ATOM    727  CZ  ARG   110      11.942  64.569  14.432  1.00 41.25           C  
ATOM    728  NH1 ARG   110      12.941  65.434  14.584  1.00 40.86           N  
ATOM    729  NH2 ARG   110      11.291  64.117  15.507  1.00 40.51           N  
ATOM    730  N   ALA   111       9.739  57.698  13.974  1.00 39.87           N  
ATOM    731  CA  ALA   111       8.742  56.686  14.255  1.00 39.24           C  
ATOM    732  C   ALA   111       7.410  57.388  14.427  1.00 39.28           C  
ATOM    733  O   ALA   111       7.158  58.004  15.488  1.00 39.27           O  
ATOM    734  CB  ALA   111       9.101  55.963  15.524  1.00 40.42           C  
ATOM    735  N   ASP   112       6.564  57.297  13.400  1.00 37.97           N  
ATOM    736  CA  ASP   112       5.245  57.869  13.413  1.00 37.66           C  
ATOM    737  C   ASP   112       4.263  56.791  13.859  1.00 39.07           C  
ATOM    738  O   ASP   112       4.145  55.730  13.241  1.00 37.57           O  
ATOM    739  CB  ASP   112       4.845  58.330  12.005  1.00 37.47           C  
ATOM    740  CG  ASP   112       5.527  59.613  11.572  1.00 38.12           C  
ATOM    741  OD1 ASP   112       5.787  60.485  12.423  1.00 34.00           O  
ATOM    742  OD2 ASP   112       5.797  59.778  10.356  1.00 37.81           O  
ATOM    743  N   ARG   113       3.500  57.090  14.888  1.00 39.45           N  
ATOM    744  CA  ARG   113       2.459  56.184  15.313  1.00 40.59           C  
ATOM    745  C   ARG   113       1.341  56.051  14.258  1.00 40.91           C  
ATOM    746  O   ARG   113       0.798  57.048  13.762  1.00 40.36           O  
ATOM    747  CB  ARG   113       1.932  56.668  16.654  1.00 42.56           C  
ATOM    748  CG  ARG   113       1.322  55.580  17.451  1.00 46.63           C  
ATOM    749  CD  ARG   113       2.301  54.882  18.378  1.00 48.90           C  
ATOM    750  NE  ARG   113       1.434  54.340  19.405  1.00 53.60           N  
ATOM    751  CZ  ARG   113       1.151  54.953  20.547  1.00 53.42           C  
ATOM    752  NH1 ARG   113       1.738  56.096  20.858  1.00 55.23           N  
ATOM    753  NH2 ARG   113       0.299  54.401  21.390  1.00 54.54           N  
ATOM    754  N   ILE   114       1.048  54.812  13.868  1.00 40.30           N  
ATOM    755  CA  ILE   114      -0.049  54.545  12.963  1.00 40.96           C  
ATOM    756  C   ILE   114      -1.386  54.812  13.695  1.00 41.58           C  
ATOM    757  O   ILE   114      -1.612  54.259  14.774  1.00 42.47           O  
ATOM    758  CB  ILE   114       0.042  53.108  12.411  1.00 40.38           C  
ATOM    759  CG1 ILE   114       1.260  52.984  11.459  1.00 41.25           C  
ATOM    760  CG2 ILE   114      -1.249  52.703  11.686  1.00 39.00           C  
ATOM    761  CD1 ILE   114       1.469  51.610  10.872  1.00 40.00           C  
ATOM    762  N   GLY   115      -2.227  55.688  13.131  1.00 41.83           N  
ATOM    763  CA  GLY   115      -3.554  56.030  13.692  1.00 41.15           C  
ATOM    764  C   GLY   115      -4.538  54.858  13.797  1.00 41.00           C  
ATOM    765  O   GLY   115      -4.438  53.905  13.029  1.00 40.08           O  
ATOM    766  N   PRO   116      -5.480  54.923  14.770  1.00 41.33           N  
ATOM    767  CA  PRO   116      -6.488  53.900  15.110  1.00 41.12           C  
ATOM    768  C   PRO   116      -7.162  53.226  13.897  1.00 41.75           C  
ATOM    769  O   PRO   116      -7.274  51.988  13.861  1.00 40.88           O  
ATOM    770  CB  PRO   116      -7.537  54.687  15.910  1.00 41.97           C  
ATOM    771  CG  PRO   116      -6.830  55.877  16.457  1.00 41.54           C  
ATOM    772  CD  PRO   116      -5.555  56.093  15.673  1.00 41.00           C  
ATOM    773  N   ASP   117      -7.599  54.026  12.918  1.00 41.48           N  
ATOM    774  CA  ASP   117      -8.340  53.487  11.759  1.00 42.14           C  
ATOM    775  C   ASP   117      -7.572  52.469  10.922  1.00 41.56           C  
ATOM    776  O   ASP   117      -8.163  51.581  10.314  1.00 40.67           O  
ATOM    777  CB  ASP   117      -8.893  54.602  10.847  1.00 42.62           C  
ATOM    778  CG  ASP   117      -9.916  55.509  11.548  1.00 44.68           C  
ATOM    779  OD1 ASP   117     -10.339  56.488  10.904  1.00 47.01           O  
ATOM    780  OD2 ASP   117     -10.294  55.273  12.721  1.00 46.41           O  
ATOM    781  N   GLU   118      -6.247  52.616  10.907  1.00 42.25           N  
ATOM    782  CA  GLU   118      -5.363  51.789  10.115  1.00 42.48           C  
ATOM    783  C   GLU   118      -4.801  50.593  10.880  1.00 41.49           C  
ATOM    784  O   GLU   118      -4.125  49.758  10.287  1.00 40.69           O  
ATOM    785  CB  GLU   118      -4.195  52.638   9.616  1.00 43.11           C  
ATOM    786  CG  GLU   118      -4.617  53.969   8.963  1.00 45.99           C  
ATOM    787  CD  GLU   118      -3.407  54.741   8.501  1.00 51.55           C  
ATOM    788  OE1 GLU   118      -2.791  54.297   7.508  1.00 53.87           O  
ATOM    789  OE2 GLU   118      -3.024  55.742   9.151  1.00 51.97           O  
ATOM    790  N   VAL   119      -5.055  50.470  12.180  1.00 40.47           N  
ATOM    791  CA  VAL   119      -4.452  49.289  12.818  1.00 39.77           C  
ATOM    792  C   VAL   119      -4.970  47.927  12.305  1.00 38.62           C  
ATOM    793  O   VAL   119      -4.153  47.050  12.063  1.00 37.65           O  
ATOM    794  CB  VAL   119      -4.130  49.368  14.343  1.00 39.16           C  
ATOM    795  CG1 VAL   119      -3.759  50.786  14.742  1.00 39.45           C  
ATOM    796  CG2 VAL   119      -5.185  48.829  15.167  1.00 41.43           C  
ATOM    797  N   PRO   120      -6.304  47.757  12.134  1.00 38.16           N  
ATOM    798  CA  PRO   120      -6.766  46.493  11.532  1.00 37.43           C  
ATOM    799  C   PRO   120      -6.020  46.047  10.227  1.00 37.74           C  
ATOM    800  O   PRO   120      -5.633  44.876  10.099  1.00 36.09           O  
ATOM    801  CB  PRO   120      -8.245  46.752  11.284  1.00 37.07           C  
ATOM    802  CG  PRO   120      -8.634  47.730  12.397  1.00 38.18           C  
ATOM    803  CD  PRO   120      -7.440  48.628  12.532  1.00 37.57           C  
ATOM    804  N   LEU   121      -5.823  46.977   9.301  1.00 37.13           N  
ATOM    805  CA  LEU   121      -5.069  46.685   8.080  1.00 38.71           C  
ATOM    806  C   LEU   121      -3.622  46.312   8.376  1.00 37.67           C  
ATOM    807  O   LEU   121      -3.110  45.342   7.819  1.00 37.67           O  
ATOM    808  CB  LEU   121      -5.126  47.883   7.139  1.00 38.61           C  
ATOM    809  CG  LEU   121      -4.512  47.752   5.759  1.00 39.30           C  
ATOM    810  CD1 LEU   121      -5.110  46.579   4.936  1.00 35.77           C  
ATOM    811  CD2 LEU   121      -4.764  49.121   5.140  1.00 41.31           C  
ATOM    812  N   ALA   122      -2.980  47.061   9.274  1.00 36.98           N  
ATOM    813  CA  ALA   122      -1.574  46.854   9.582  1.00 36.59           C  
ATOM    814  C   ALA   122      -1.386  45.497  10.265  1.00 37.61           C  
ATOM    815  O   ALA   122      -0.397  44.789  10.033  1.00 36.60           O  
ATOM    816  CB  ALA   122      -1.034  48.017  10.459  1.00 37.41           C  
ATOM    817  N   ILE   123      -2.358  45.125  11.089  1.00 37.52           N  
ATOM    818  CA  ILE   123      -2.385  43.802  11.748  1.00 38.61           C  
ATOM    819  C   ILE   123      -2.406  42.675  10.741  1.00 37.17           C  
ATOM    820  O   ILE   123      -1.649  41.710  10.838  1.00 37.42           O  
ATOM    821  CB  ILE   123      -3.657  43.639  12.672  1.00 39.07           C  
ATOM    822  CG1 ILE   123      -3.511  44.499  13.927  1.00 41.23           C  
ATOM    823  CG2 ILE   123      -3.890  42.180  13.098  1.00 40.52           C  
ATOM    824  CD1 ILE   123      -2.270  44.198  14.646  1.00 45.57           C  
ATOM    825  N   ALA   124      -3.313  42.752   9.795  1.00 36.81           N  
ATOM    826  CA  ALA   124      -3.427  41.659   8.857  1.00 37.23           C  
ATOM    827  C   ALA   124      -2.128  41.553   8.001  1.00 37.64           C  
ATOM    828  O   ALA   124      -1.590  40.452   7.800  1.00 36.63           O  
ATOM    829  CB  ALA   124      -4.654  41.830   7.999  1.00 37.00           C  
ATOM    830  N   ARG   125      -1.607  42.702   7.579  1.00 37.64           N  
ATOM    831  CA  ARG   125      -0.338  42.736   6.830  1.00 38.74           C  
ATOM    832  C   ARG   125       0.839  42.139   7.607  1.00 39.32           C  
ATOM    833  O   ARG   125       1.660  41.394   7.056  1.00 39.10           O  
ATOM    834  CB  ARG   125       0.003  44.157   6.428  1.00 39.12           C  
ATOM    835  CG  ARG   125      -0.760  44.677   5.279  1.00 39.31           C  
ATOM    836  CD  ARG   125      -0.540  46.186   5.178  1.00 42.21           C  
ATOM    837  NE  ARG   125      -1.251  46.747   4.033  1.00 42.02           N  
ATOM    838  CZ  ARG   125      -1.330  48.041   3.735  1.00 44.09           C  
ATOM    839  NH1 ARG   125      -0.787  48.966   4.539  1.00 42.23           N  
ATOM    840  NH2 ARG   125      -1.989  48.402   2.627  1.00 43.74           N  
ATOM    841  N   TYR   126       0.913  42.455   8.901  1.00 38.91           N  
ATOM    842  CA  TYR   126       1.965  41.957   9.741  1.00 38.50           C  
ATOM    843  C   TYR   126       1.883  40.445  10.004  1.00 38.28           C  
ATOM    844  O   TYR   126       2.888  39.738   9.921  1.00 37.03           O  
ATOM    845  CB  TYR   126       1.882  42.701  11.070  1.00 38.18           C  
ATOM    846  CG  TYR   126       3.073  42.563  11.972  1.00 38.12           C  
ATOM    847  CD1 TYR   126       4.130  43.481  11.909  1.00 38.79           C  
ATOM    848  CD2 TYR   126       3.099  41.592  12.959  1.00 38.98           C  
ATOM    849  CE1 TYR   126       5.217  43.383  12.779  1.00 38.36           C  
ATOM    850  CE2 TYR   126       4.154  41.486  13.840  1.00 39.29           C  
ATOM    851  CZ  TYR   126       5.211  42.397  13.757  1.00 39.80           C  
ATOM    852  OH  TYR   126       6.241  42.303  14.671  1.00 40.32           O  
ATOM    853  N   ILE   127       0.680  39.970  10.361  1.00 38.68           N  
ATOM    854  CA  ILE   127       0.370  38.560  10.561  1.00 38.24           C  
ATOM    855  C   ILE   127       0.751  37.693   9.356  1.00 38.71           C  
ATOM    856  O   ILE   127       1.212  36.567   9.513  1.00 37.24           O  
ATOM    857  CB  ILE   127      -1.169  38.356  10.836  1.00 39.14           C  
ATOM    858  CG1 ILE   127      -1.566  38.755  12.282  1.00 39.78           C  
ATOM    859  CG2 ILE   127      -1.614  36.931  10.590  1.00 38.81           C  
ATOM    860  CD1 ILE   127      -0.651  38.299  13.287  1.00 41.39           C  
ATOM    861  N   ALA   128       0.536  38.247   8.170  1.00 38.28           N  
ATOM    862  CA  ALA   128       0.881  37.603   6.892  1.00 39.64           C  
ATOM    863  C   ALA   128       2.362  37.196   6.864  1.00 39.77           C  
ATOM    864  O   ALA   128       2.692  36.160   6.326  1.00 40.73           O  
ATOM    865  CB  ALA   128       0.538  38.544   5.716  1.00 37.72           C  
ATOM    866  N   ARG   129       3.239  37.977   7.501  1.00 39.93           N  
ATOM    867  CA  ARG   129       4.663  37.665   7.535  1.00 40.44           C  
ATOM    868  C   ARG   129       5.092  36.935   8.789  1.00 41.02           C  
ATOM    869  O   ARG   129       6.078  36.186   8.762  1.00 41.36           O  
ATOM    870  CB  ARG   129       5.504  38.953   7.385  1.00 40.36           C  
ATOM    871  CG  ARG   129       5.631  39.460   6.006  1.00 40.68           C  
ATOM    872  CD  ARG   129       6.516  40.731   6.028  1.00 42.98           C  
ATOM    873  NE  ARG   129       7.005  41.042   4.703  1.00 42.54           N  
ATOM    874  CZ  ARG   129       8.005  41.881   4.428  1.00 40.53           C  
ATOM    875  NH1 ARG   129       8.668  42.496   5.400  1.00 35.92           N  
ATOM    876  NH2 ARG   129       8.369  42.072   3.162  1.00 40.85           N  
ATOM    877  N   TYR   130       4.355  37.171   9.879  1.00 40.43           N  
ATOM    878  CA  TYR   130       4.744  36.787  11.237  1.00 40.69           C  
ATOM    879  C   TYR   130       3.545  36.101  11.899  1.00 40.82           C  
ATOM    880  O   TYR   130       2.832  36.721  12.718  1.00 39.21           O  
ATOM    881  CB  TYR   130       5.205  38.026  12.053  1.00 40.55           C  
ATOM    882  CG  TYR   130       6.263  38.783  11.311  1.00 40.43           C  
ATOM    883  CD1 TYR   130       7.511  38.180  11.078  1.00 41.13           C  
ATOM    884  CD2 TYR   130       6.016  40.050  10.782  1.00 36.37           C  
ATOM    885  CE1 TYR   130       8.468  38.794  10.335  1.00 42.15           C  
ATOM    886  CE2 TYR   130       6.996  40.693  10.025  1.00 37.26           C  
ATOM    887  CZ  TYR   130       8.215  40.051   9.809  1.00 39.60           C  
ATOM    888  OH  TYR   130       9.191  40.643   9.072  1.00 41.60           O  
ATOM    889  N   PRO   131       3.306  34.817  11.540  1.00 42.16           N  
ATOM    890  CA  PRO   131       2.096  34.165  12.065  1.00 42.41           C  
ATOM    891  C   PRO   131       2.062  34.024  13.586  1.00 43.43           C  
ATOM    892  O   PRO   131       0.988  33.896  14.156  1.00 43.70           O  
ATOM    893  CB  PRO   131       2.077  32.794  11.349  1.00 42.87           C  
ATOM    894  CG  PRO   131       3.453  32.545  10.957  1.00 42.32           C  
ATOM    895  CD  PRO   131       4.065  33.913  10.654  1.00 41.32           C  
ATOM    896  N   LYS   132       3.210  34.079  14.254  1.00 44.16           N  
ATOM    897  CA  LYS   132       3.206  34.014  15.703  1.00 45.24           C  
ATOM    898  C   LYS   132       2.663  35.298  16.324  1.00 44.82           C  
ATOM    899  O   LYS   132       2.263  35.304  17.487  1.00 43.69           O  
ATOM    900  CB  LYS   132       4.595  33.704  16.260  1.00 45.12           C  
ATOM    901  CG  LYS   132       4.842  32.232  16.432  1.00 47.27           C  
ATOM    902  CD  LYS   132       6.196  31.909  17.119  1.00 48.39           C  
ATOM    903  CE  LYS   132       7.430  32.170  16.226  1.00 52.49           C  
ATOM    904  NZ  LYS   132       7.137  32.521  14.768  1.00 53.17           N  
ATOM    905  N   ALA   133       2.641  36.376  15.540  1.00 44.82           N  
ATOM    906  CA  ALA   133       2.119  37.640  16.033  1.00 45.86           C  
ATOM    907  C   ALA   133       0.639  37.487  16.421  1.00 46.28           C  
ATOM    908  O   ALA   133       0.119  38.284  17.187  1.00 46.88           O  
ATOM    909  CB  ALA   133       2.317  38.750  15.011  1.00 44.40           C  
ATOM    910  N   LYS   134      -0.011  36.451  15.885  1.00 46.67           N  
ATOM    911  CA  LYS   134      -1.416  36.157  16.164  1.00 47.61           C  
ATOM    912  C   LYS   134      -1.651  36.137  17.651  1.00 47.75           C  
ATOM    913  O   LYS   134      -2.757  36.404  18.112  1.00 47.97           O  
ATOM    914  CB  LYS   134      -1.842  34.813  15.552  1.00 47.52           C  
ATOM    915  CG  LYS   134      -1.859  34.804  14.020  1.00 47.47           C  
ATOM    916  CD  LYS   134      -2.287  33.432  13.483  1.00 49.07           C  
ATOM    917  CE  LYS   134      -1.445  32.992  12.281  1.00 51.18           C  
ATOM    918  NZ  LYS   134      -1.843  33.616  10.967  1.00 49.86           N  
ATOM    919  N   LEU   135      -0.579  35.853  18.390  1.00 48.06           N  
ATOM    920  CA  LEU   135      -0.617  35.721  19.826  1.00 47.97           C  
ATOM    921  C   LEU   135      -0.192  37.001  20.519  1.00 47.15           C  
ATOM    922  O   LEU   135      -0.969  37.551  21.300  1.00 46.82           O  
ATOM    923  CB  LEU   135       0.261  34.537  20.278  1.00 48.70           C  
ATOM    924  CG  LEU   135       0.035  33.874  21.647  1.00 50.11           C  
ATOM    925  CD1 LEU   135       0.774  34.634  22.791  1.00 50.84           C  
ATOM    926  CD2 LEU   135      -1.474  33.663  21.956  1.00 50.85           C  
ATOM    927  N   TYR   136       1.031  37.462  20.260  1.00 46.11           N  
ATOM    928  CA  TYR   136       1.581  38.606  21.013  1.00 45.99           C  
ATOM    929  C   TYR   136       1.034  39.993  20.657  1.00 46.23           C  
ATOM    930  O   TYR   136       1.253  40.941  21.400  1.00 47.04           O  
ATOM    931  CB  TYR   136       3.109  38.615  21.041  1.00 45.39           C  
ATOM    932  CG  TYR   136       3.790  38.700  19.693  1.00 46.29           C  
ATOM    933  CD1 TYR   136       3.885  39.920  19.003  1.00 46.59           C  
ATOM    934  CD2 TYR   136       4.382  37.560  19.114  1.00 47.90           C  
ATOM    935  CE1 TYR   136       4.510  40.011  17.768  1.00 45.30           C  
ATOM    936  CE2 TYR   136       5.021  37.640  17.878  1.00 45.08           C  
ATOM    937  CZ  TYR   136       5.087  38.863  17.214  1.00 45.87           C  
ATOM    938  OH  TYR   136       5.715  38.938  15.992  1.00 41.33           O  
ATOM    939  N   LEU   137       0.359  40.122  19.511  1.00 46.65           N  
ATOM    940  CA  LEU   137      -0.418  41.332  19.204  1.00 46.13           C  
ATOM    941  C   LEU   137      -1.735  41.311  20.000  1.00 46.60           C  
ATOM    942  O   LEU   137      -2.290  42.359  20.306  1.00 46.98           O  
ATOM    943  CB  LEU   137      -0.713  41.459  17.704  1.00 45.65           C  
ATOM    944  CG  LEU   137       0.437  41.531  16.695  1.00 44.77           C  
ATOM    945  CD1 LEU   137      -0.089  41.595  15.239  1.00 43.62           C  
ATOM    946  CD2 LEU   137       1.283  42.731  17.005  1.00 44.94           C  
ATOM    947  N   SER   138      -2.232  40.115  20.331  1.00 46.62           N  
ATOM    948  CA  SER   138      -3.452  39.978  21.138  1.00 46.51           C  
ATOM    949  C   SER   138      -3.169  40.269  22.616  1.00 46.44           C  
ATOM    950  O   SER   138      -4.035  40.077  23.474  1.00 45.70           O  
ATOM    951  CB  SER   138      -4.083  38.578  20.979  1.00 46.73           C  
ATOM    952  OG  SER   138      -4.835  38.461  19.779  1.00 45.66           O  
ATOM    953  N   LEU   139      -1.955  40.729  22.906  1.00 46.67           N  
ATOM    954  CA  LEU   139      -1.587  41.082  24.277  1.00 47.11           C  
ATOM    955  C   LEU   139      -1.803  42.577  24.520  1.00 47.01           C  
ATOM    956  O   LEU   139      -1.718  43.355  23.579  1.00 47.26           O  
ATOM    957  CB  LEU   139      -0.132  40.673  24.561  1.00 47.38           C  
ATOM    958  CG  LEU   139       0.075  39.157  24.775  1.00 48.22           C  
ATOM    959  CD1 LEU   139       1.557  38.734  24.649  1.00 48.29           C  
ATOM    960  CD2 LEU   139      -0.538  38.697  26.101  1.00 46.80           C  
ATOM    961  N   PRO   140      -2.098  42.982  25.772  1.00 46.85           N  
ATOM    962  CA  PRO   140      -2.243  44.405  26.123  1.00 47.11           C  
ATOM    963  C   PRO   140      -1.185  45.383  25.554  1.00 46.98           C  
ATOM    964  O   PRO   140      -0.054  44.997  25.304  1.00 46.95           O  
ATOM    965  CB  PRO   140      -2.208  44.384  27.670  1.00 47.08           C  
ATOM    966  CG  PRO   140      -2.900  43.086  27.999  1.00 46.63           C  
ATOM    967  CD  PRO   140      -2.367  42.116  26.942  1.00 47.39           C  
ATOM    968  N   ASP   141      -1.623  46.629  25.332  1.00 47.12           N  
ATOM    969  CA  ASP   141      -0.824  47.794  24.899  1.00 46.88           C  
ATOM    970  C   ASP   141       0.037  47.641  23.642  1.00 45.67           C  
ATOM    971  O   ASP   141       1.088  48.244  23.545  1.00 45.12           O  
ATOM    972  CB  ASP   141      -0.028  48.431  26.058  1.00 47.97           C  
ATOM    973  CG  ASP   141       0.312  49.933  25.794  1.00 51.71           C  
ATOM    974  OD1 ASP   141       0.123  50.416  24.640  1.00 56.09           O  
ATOM    975  OD2 ASP   141       0.765  50.642  26.726  1.00 53.23           O  
ATOM    976  N   THR   142      -0.433  46.872  22.665  1.00 45.38           N  
ATOM    977  CA  THR   142       0.298  46.738  21.399  1.00 44.64           C  
ATOM    978  C   THR   142       0.354  48.133  20.750  1.00 43.67           C  
ATOM    979  O   THR   142      -0.661  48.835  20.706  1.00 42.32           O  
ATOM    980  CB  THR   142      -0.322  45.645  20.432  1.00 45.28           C  
ATOM    981  OG1 THR   142      -1.500  46.129  19.764  1.00 50.55           O  
ATOM    982  CG2 THR   142      -0.691  44.384  21.154  1.00 43.67           C  
ATOM    983  N   ARG   143       1.543  48.544  20.302  1.00 42.84           N  
ATOM    984  CA  ARG   143       1.752  49.844  19.613  1.00 41.55           C  
ATOM    985  C   ARG   143       2.296  49.644  18.197  1.00 41.15           C  
ATOM    986  O   ARG   143       3.172  48.825  17.972  1.00 39.56           O  
ATOM    987  CB  ARG   143       2.693  50.754  20.397  1.00 41.33           C  
ATOM    988  CG  ARG   143       2.105  51.238  21.716  1.00 42.76           C  
ATOM    989  CD  ARG   143       2.837  52.418  22.285  1.00 41.74           C  
ATOM    990  NE  ARG   143       2.324  52.678  23.626  1.00 43.71           N  
ATOM    991  CZ  ARG   143       2.963  53.384  24.552  1.00 44.78           C  
ATOM    992  NH1 ARG   143       4.143  53.932  24.282  1.00 44.95           N  
ATOM    993  NH2 ARG   143       2.417  53.540  25.749  1.00 44.32           N  
ATOM    994  N   LEU   144       1.784  50.424  17.263  1.00 40.42           N  
ATOM    995  CA  LEU   144       2.074  50.247  15.850  1.00 40.95           C  
ATOM    996  C   LEU   144       2.702  51.530  15.277  1.00 40.06           C  
ATOM    997  O   LEU   144       2.163  52.615  15.462  1.00 38.91           O  
ATOM    998  CB  LEU   144       0.751  49.987  15.181  1.00 42.20           C  
ATOM    999  CG  LEU   144       0.619  49.097  13.969  1.00 46.50           C  
ATOM   1000  CD1 LEU   144       1.875  48.287  13.671  1.00 49.12           C  
ATOM   1001  CD2 LEU   144      -0.608  48.216  14.255  1.00 48.62           C  
ATOM   1002  N   TYR   145       3.817  51.406  14.564  1.00 39.79           N  
ATOM   1003  CA  TYR   145       4.558  52.599  14.078  1.00 40.16           C  
ATOM   1004  C   TYR   145       4.959  52.432  12.632  1.00 40.01           C  
ATOM   1005  O   TYR   145       5.267  51.349  12.243  1.00 39.76           O  
ATOM   1006  CB  TYR   145       5.867  52.724  14.824  1.00 39.53           C  
ATOM   1007  CG  TYR   145       5.781  52.715  16.319  1.00 40.63           C  
ATOM   1008  CD1 TYR   145       5.830  53.908  17.048  1.00 39.84           C  
ATOM   1009  CD2 TYR   145       5.749  51.505  17.013  1.00 40.60           C  
ATOM   1010  CE1 TYR   145       5.801  53.895  18.451  1.00 40.06           C  
ATOM   1011  CE2 TYR   145       5.697  51.480  18.355  1.00 39.43           C  
ATOM   1012  CZ  TYR   145       5.730  52.671  19.081  1.00 39.67           C  
ATOM   1013  OH  TYR   145       5.702  52.587  20.428  1.00 42.40           O  
ATOM   1014  N   ARG   146       5.015  53.506  11.843  1.00 39.59           N  
ATOM   1015  CA  ARG   146       5.738  53.386  10.573  1.00 39.78           C  
ATOM   1016  C   ARG   146       6.938  54.325  10.546  1.00 39.11           C  
ATOM   1017  O   ARG   146       6.964  55.378  11.224  1.00 39.10           O  
ATOM   1018  CB  ARG   146       4.811  53.511   9.324  1.00 40.31           C  
ATOM   1019  CG  ARG   146       4.060  54.788   9.265  1.00 39.82           C  
ATOM   1020  CD  ARG   146       3.345  55.018   7.916  1.00 38.92           C  
ATOM   1021  NE  ARG   146       2.211  54.139   7.701  1.00 37.29           N  
ATOM   1022  CZ  ARG   146       0.949  54.414   8.052  1.00 39.59           C  
ATOM   1023  NH1 ARG   146       0.620  55.547   8.670  1.00 36.29           N  
ATOM   1024  NH2 ARG   146       0.002  53.529   7.806  1.00 38.02           N  
ATOM   1025  N   LEU   147       7.953  53.898   9.812  1.00 38.46           N  
ATOM   1026  CA  LEU   147       9.159  54.674   9.672  1.00 39.22           C  
ATOM   1027  C   LEU   147       8.892  55.779   8.668  1.00 39.28           C  
ATOM   1028  O   LEU   147       8.458  55.507   7.541  1.00 40.23           O  
ATOM   1029  CB  LEU   147      10.337  53.786   9.223  1.00 38.32           C  
ATOM   1030  CG  LEU   147      11.633  54.552   8.934  1.00 40.43           C  
ATOM   1031  CD1 LEU   147      12.162  55.301  10.146  1.00 40.13           C  
ATOM   1032  CD2 LEU   147      12.676  53.585   8.383  1.00 39.88           C  
ATOM   1033  N   ARG   148       9.128  57.019   9.093  1.00 38.60           N  
ATOM   1034  CA  ARG   148       9.226  58.123   8.164  1.00 38.77           C  
ATOM   1035  C   ARG   148      10.701  58.279   7.820  1.00 38.33           C  
ATOM   1036  O   ARG   148      11.459  58.805   8.619  1.00 38.32           O  
ATOM   1037  CB  ARG   148       8.725  59.410   8.813  1.00 38.13           C  
ATOM   1038  CG  ARG   148       8.409  60.481   7.803  1.00 37.78           C  
ATOM   1039  CD  ARG   148       8.179  61.861   8.399  1.00 38.22           C  
ATOM   1040  NE  ARG   148       7.600  61.872   9.745  1.00 37.75           N  
ATOM   1041  CZ  ARG   148       7.628  62.927  10.557  1.00 37.04           C  
ATOM   1042  NH1 ARG   148       8.198  64.048  10.163  1.00 39.09           N  
ATOM   1043  NH2 ARG   148       7.088  62.877  11.769  1.00 37.72           N  
ATOM   1044  N   THR   149      11.112  57.813   6.646  1.00 38.59           N  
ATOM   1045  CA  THR   149      12.545  57.748   6.309  1.00 37.96           C  
ATOM   1046  C   THR   149      13.029  59.141   5.922  1.00 38.33           C  
ATOM   1047  O   THR   149      12.405  59.803   5.065  1.00 36.50           O  
ATOM   1048  CB  THR   149      12.806  56.757   5.154  1.00 38.31           C  
ATOM   1049  OG1 THR   149      12.509  55.419   5.604  1.00 41.10           O  
ATOM   1050  CG2 THR   149      14.270  56.801   4.713  1.00 35.97           C  
ATOM   1051  N   GLU   150      14.136  59.582   6.538  1.00 37.61           N  
ATOM   1052  CA  GLU   150      14.712  60.870   6.226  1.00 37.27           C  
ATOM   1053  C   GLU   150      16.117  60.754   5.641  1.00 36.61           C  
ATOM   1054  O   GLU   150      16.620  61.694   5.038  1.00 35.99           O  
ATOM   1055  CB  GLU   150      14.728  61.781   7.469  1.00 37.85           C  
ATOM   1056  CG  GLU   150      13.363  62.026   8.039  1.00 40.67           C  
ATOM   1057  CD  GLU   150      13.392  62.918   9.236  1.00 43.99           C  
ATOM   1058  OE1 GLU   150      13.697  62.446  10.343  1.00 45.92           O  
ATOM   1059  OE2 GLU   150      13.083  64.103   9.075  1.00 47.26           O  
ATOM   1060  N   GLY   151      16.754  59.605   5.811  1.00 36.37           N  
ATOM   1061  CA  GLY   151      18.106  59.438   5.304  1.00 35.42           C  
ATOM   1062  C   GLY   151      18.391  57.979   5.175  1.00 36.25           C  
ATOM   1063  O   GLY   151      17.818  57.157   5.916  1.00 36.80           O  
ATOM   1064  N   VAL   152      19.238  57.639   4.215  1.00 36.10           N  
ATOM   1065  CA  VAL   152      19.430  56.227   3.805  1.00 35.33           C  
ATOM   1066  C   VAL   152      20.918  55.988   3.648  1.00 35.97           C  
ATOM   1067  O   VAL   152      21.619  56.816   3.048  1.00 35.63           O  
ATOM   1068  CB  VAL   152      18.795  55.952   2.411  1.00 34.93           C  
ATOM   1069  CG1 VAL   152      19.039  54.483   1.920  1.00 32.95           C  
ATOM   1070  CG2 VAL   152      17.350  56.272   2.423  1.00 35.09           C  
ATOM   1071  N   GLN   153      21.393  54.850   4.145  1.00 36.44           N  
ATOM   1072  CA  GLN   153      22.734  54.355   3.769  1.00 37.39           C  
ATOM   1073  C   GLN   153      22.655  52.879   3.356  1.00 36.80           C  
ATOM   1074  O   GLN   153      22.052  52.100   4.058  1.00 36.40           O  
ATOM   1075  CB  GLN   153      23.665  54.515   4.963  1.00 37.50           C  
ATOM   1076  CG  GLN   153      25.127  54.524   4.640  1.00 41.65           C  
ATOM   1077  CD  GLN   153      25.556  55.736   3.810  1.00 41.98           C  
ATOM   1078  OE1 GLN   153      24.964  56.831   3.864  1.00 45.79           O  
ATOM   1079  NE2 GLN   153      26.583  55.533   3.041  1.00 42.54           N  
ATOM   1080  N   ILE   154      23.241  52.503   2.226  1.00 37.17           N  
ATOM   1081  CA  ILE   154      23.331  51.090   1.860  1.00 39.21           C  
ATOM   1082  C   ILE   154      24.785  50.640   1.815  1.00 41.79           C  
ATOM   1083  O   ILE   154      25.679  51.367   1.372  1.00 41.41           O  
ATOM   1084  CB  ILE   154      22.601  50.741   0.538  1.00 38.42           C  
ATOM   1085  CG1 ILE   154      22.646  49.226   0.255  1.00 38.22           C  
ATOM   1086  CG2 ILE   154      23.205  51.475  -0.643  1.00 38.65           C  
ATOM   1087  CD1 ILE   154      21.854  48.347   1.229  1.00 39.83           C  
ATOM   1088  N   ASN   155      25.004  49.399   2.225  1.00 44.68           N  
ATOM   1089  CA  ASN   155      26.328  48.960   2.615  1.00 46.88           C  
ATOM   1090  C   ASN   155      26.582  47.483   2.353  1.00 47.70           C  
ATOM   1091  O   ASN   155      25.686  46.663   2.509  1.00 46.80           O  
ATOM   1092  CB  ASN   155      26.426  49.207   4.104  1.00 47.14           C  
ATOM   1093  CG  ASN   155      27.647  49.882   4.462  1.00 50.04           C  
ATOM   1094  OD1 ASN   155      28.705  49.253   4.585  1.00 55.54           O  
ATOM   1095  ND2 ASN   155      27.558  51.195   4.622  1.00 52.46           N  
ATOM   1096  N   GLY   156      27.811  47.151   1.959  1.00 49.84           N  
ATOM   1097  CA  GLY   156      28.226  45.753   1.770  1.00 51.52           C  
ATOM   1098  C   GLY   156      27.617  45.115   0.522  1.00 52.58           C  
ATOM   1099  O   GLY   156      27.855  43.933   0.213  1.00 53.20           O  
ATOM   1100  N   SER   163      26.464  54.270  -1.177  1.00 60.56           N  
ATOM   1101  CA  SER   163      26.432  55.140  -2.358  1.00 60.69           C  
ATOM   1102  C   SER   163      25.807  56.505  -2.030  1.00 60.30           C  
ATOM   1103  O   SER   163      25.996  57.018  -0.913  1.00 60.50           O  
ATOM   1104  CB  SER   163      25.691  54.453  -3.512  1.00 60.82           C  
ATOM   1105  N   ASN   164      25.077  57.098  -2.983  1.00 59.18           N  
ATOM   1106  CA  ASN   164      24.316  58.305  -2.663  1.00 57.87           C  
ATOM   1107  C   ASN   164      22.811  58.245  -2.973  1.00 56.64           C  
ATOM   1108  O   ASN   164      22.310  58.927  -3.882  1.00 56.74           O  
ATOM   1109  CB  ASN   164      24.991  59.557  -3.217  1.00 58.18           C  
ATOM   1110  CG  ASN   164      25.093  60.662  -2.170  1.00 59.61           C  
ATOM   1111  OD1 ASN   164      24.452  60.581  -1.102  1.00 61.55           O  
ATOM   1112  ND2 ASN   164      25.898  61.696  -2.459  1.00 58.37           N  
ATOM   1113  N   ILE   165      22.119  57.431  -2.171  1.00 54.60           N  
ATOM   1114  CA  ILE   165      20.681  57.144  -2.264  1.00 52.78           C  
ATOM   1115  C   ILE   165      19.834  58.029  -1.349  1.00 51.56           C  
ATOM   1116  O   ILE   165      20.213  58.327  -0.218  1.00 51.45           O  
ATOM   1117  CB  ILE   165      20.383  55.679  -1.835  1.00 52.71           C  
ATOM   1118  CG1 ILE   165      21.223  54.685  -2.617  1.00 52.48           C  
ATOM   1119  CG2 ILE   165      18.870  55.346  -1.944  1.00 52.17           C  
ATOM   1120  CD1 ILE   165      21.075  53.276  -2.069  1.00 53.76           C  
ATOM   1121  N   THR   166      18.659  58.387  -1.850  1.00 49.82           N  
ATOM   1122  CA  THR   166      17.685  59.221  -1.167  1.00 47.99           C  
ATOM   1123  C   THR   166      16.460  58.402  -0.707  1.00 46.53           C  
ATOM   1124  O   THR   166      16.163  57.365  -1.305  1.00 45.87           O  
ATOM   1125  CB  THR   166      17.195  60.292  -2.160  1.00 48.47           C  
ATOM   1126  OG1 THR   166      16.247  61.157  -1.526  1.00 50.18           O  
ATOM   1127  CG2 THR   166      16.526  59.641  -3.353  1.00 47.03           C  
ATOM   1128  N   PRO   167      15.736  58.879   0.335  1.00 44.87           N  
ATOM   1129  CA  PRO   167      14.458  58.290   0.720  1.00 43.50           C  
ATOM   1130  C   PRO   167      13.494  58.042  -0.451  1.00 42.73           C  
ATOM   1131  O   PRO   167      12.872  56.980  -0.511  1.00 41.20           O  
ATOM   1132  CB  PRO   167      13.899  59.320   1.701  1.00 43.49           C  
ATOM   1133  CG  PRO   167      15.121  59.813   2.394  1.00 43.85           C  
ATOM   1134  CD  PRO   167      16.106  59.979   1.255  1.00 44.61           C  
ATOM   1135  N   ALA   168      13.394  59.003  -1.376  1.00 41.20           N  
ATOM   1136  CA  ALA   168      12.558  58.884  -2.575  1.00 40.36           C  
ATOM   1137  C   ALA   168      12.945  57.702  -3.447  1.00 40.15           C  
ATOM   1138  O   ALA   168      12.078  57.091  -4.074  1.00 39.71           O  
ATOM   1139  CB  ALA   168      12.623  60.191  -3.420  1.00 39.95           C  
ATOM   1140  N   ASP   169      14.248  57.401  -3.501  1.00 40.01           N  
ATOM   1141  CA  ASP   169      14.760  56.285  -4.307  1.00 40.40           C  
ATOM   1142  C   ASP   169      14.215  54.952  -3.813  1.00 39.36           C  
ATOM   1143  O   ASP   169      14.077  54.007  -4.570  1.00 38.74           O  
ATOM   1144  CB  ASP   169      16.286  56.201  -4.240  1.00 40.55           C  
ATOM   1145  CG  ASP   169      16.984  57.170  -5.175  1.00 44.16           C  
ATOM   1146  OD1 ASP   169      16.370  57.686  -6.141  1.00 46.62           O  
ATOM   1147  OD2 ASP   169      18.177  57.426  -4.917  1.00 46.46           O  
ATOM   1148  N   LEU   170      13.938  54.869  -2.520  1.00 39.88           N  
ATOM   1149  CA  LEU   170      13.470  53.617  -1.971  1.00 40.30           C  
ATOM   1150  C   LEU   170      11.977  53.420  -2.130  1.00 41.43           C  
ATOM   1151  O   LEU   170      11.506  52.272  -2.117  1.00 43.10           O  
ATOM   1152  CB  LEU   170      13.843  53.477  -0.496  1.00 39.86           C  
ATOM   1153  CG  LEU   170      15.310  53.540  -0.134  1.00 41.26           C  
ATOM   1154  CD1 LEU   170      15.403  53.049   1.308  1.00 38.50           C  
ATOM   1155  CD2 LEU   170      16.132  52.668  -1.055  1.00 41.75           C  
ATOM   1156  N   ARG   171      11.220  54.508  -2.225  1.00 41.64           N  
ATOM   1157  CA  ARG   171       9.757  54.400  -2.276  1.00 42.86           C  
ATOM   1158  C   ARG   171       9.224  53.862  -3.570  1.00 41.94           C  
ATOM   1159  O   ARG   171       9.793  54.126  -4.624  1.00 42.66           O  
ATOM   1160  CB  ARG   171       9.090  55.745  -2.037  1.00 44.35           C  
ATOM   1161  CG  ARG   171       8.629  55.926  -0.589  1.00 48.08           C  
ATOM   1162  CD  ARG   171       7.734  57.174  -0.489  1.00 55.26           C  
ATOM   1163  NE  ARG   171       8.159  58.232  -1.413  1.00 59.23           N  
ATOM   1164  CZ  ARG   171       9.087  59.155  -1.153  1.00 60.97           C  
ATOM   1165  NH1 ARG   171       9.718  59.190   0.027  1.00 59.89           N  
ATOM   1166  NH2 ARG   171       9.385  60.056  -2.088  1.00 61.23           N  
ATOM   1167  N   THR   172       8.104  53.136  -3.502  1.00 39.89           N  
ATOM   1168  CA  THR   172       7.400  52.778  -4.733  1.00 37.54           C  
ATOM   1169  C   THR   172       6.310  53.770  -5.091  1.00 36.45           C  
ATOM   1170  O   THR   172       5.388  53.982  -4.324  1.00 35.85           O  
ATOM   1171  CB  THR   172       6.777  51.374  -4.624  1.00 37.27           C  
ATOM   1172  OG1 THR   172       7.811  50.456  -4.280  1.00 36.73           O  
ATOM   1173  CG2 THR   172       6.129  50.979  -5.942  1.00 37.43           C  
ATOM   1174  N   ASP   173       6.386  54.342  -6.290  1.00 35.89           N  
ATOM   1175  CA  ASP   173       5.430  55.349  -6.699  1.00 35.73           C  
ATOM   1176  C   ASP   173       4.100  54.712  -7.127  1.00 35.45           C  
ATOM   1177  O   ASP   173       4.050  53.928  -8.081  1.00 34.18           O  
ATOM   1178  CB  ASP   173       6.040  56.182  -7.820  1.00 36.16           C  
ATOM   1179  CG  ASP   173       5.205  57.399  -8.183  1.00 37.67           C  
ATOM   1180  OD1 ASP   173       4.108  57.608  -7.606  1.00 38.56           O  
ATOM   1181  OD2 ASP   173       5.674  58.164  -9.053  1.00 40.65           O  
ATOM   1182  N   LEU   174       3.020  55.082  -6.432  1.00 35.60           N  
ATOM   1183  CA  LEU   174       1.699  54.491  -6.690  1.00 36.94           C  
ATOM   1184  C   LEU   174       0.820  55.341  -7.622  1.00 37.73           C  
ATOM   1185  O   LEU   174      -0.223  54.871  -8.064  1.00 38.70           O  
ATOM   1186  CB  LEU   174       0.955  54.137  -5.392  1.00 35.87           C  
ATOM   1187  CG  LEU   174       1.652  53.225  -4.335  1.00 37.10           C  
ATOM   1188  CD1 LEU   174       0.739  52.947  -3.138  1.00 42.05           C  
ATOM   1189  CD2 LEU   174       2.199  51.941  -4.887  1.00 34.58           C  
ATOM   1190  N   SER   175       1.250  56.578  -7.903  1.00 39.29           N  
ATOM   1191  CA  SER   175       0.577  57.509  -8.835  1.00 39.41           C  
ATOM   1192  C   SER   175       0.497  56.903 -10.201  1.00 38.81           C  
ATOM   1193  O   SER   175       1.480  56.338 -10.665  1.00 39.39           O  
ATOM   1194  CB  SER   175       1.393  58.781  -8.985  1.00 40.30           C  
ATOM   1195  OG  SER   175       1.749  59.250  -7.720  1.00 44.26           O  
ATOM   1196  N   GLY   176      -0.657  57.005 -10.851  1.00 38.00           N  
ATOM   1197  CA  GLY   176      -0.818  56.431 -12.193  1.00 36.90           C  
ATOM   1198  C   GLY   176      -1.274  54.983 -12.166  1.00 36.94           C  
ATOM   1199  O   GLY   176      -1.785  54.486 -13.161  1.00 36.75           O  
ATOM   1200  N   ALA   177      -1.121  54.326 -11.017  1.00 35.74           N  
ATOM   1201  CA  ALA   177      -1.447  52.891 -10.828  1.00 36.90           C  
ATOM   1202  C   ALA   177      -2.671  52.600  -9.946  1.00 37.11           C  
ATOM   1203  O   ALA   177      -2.825  51.471  -9.488  1.00 35.89           O  
ATOM   1204  CB  ALA   177      -0.241  52.139 -10.254  1.00 34.41           C  
ATOM   1205  N   GLU   178      -3.561  53.581  -9.759  1.00 38.00           N  
ATOM   1206  CA  GLU   178      -4.748  53.361  -8.912  1.00 39.26           C  
ATOM   1207  C   GLU   178      -5.582  52.148  -9.317  1.00 39.46           C  
ATOM   1208  O   GLU   178      -6.096  51.457  -8.448  1.00 39.25           O  
ATOM   1209  CB  GLU   178      -5.639  54.605  -8.793  1.00 40.40           C  
ATOM   1210  CG  GLU   178      -5.522  55.617  -9.915  1.00 43.04           C  
ATOM   1211  CD  GLU   178      -4.197  56.362  -9.892  1.00 44.81           C  
ATOM   1212  OE1 GLU   178      -3.412  56.160 -10.831  1.00 45.64           O  
ATOM   1213  OE2 GLU   178      -3.929  57.129  -8.943  1.00 47.96           O  
ATOM   1214  N   GLU   179      -5.709  51.882 -10.626  1.00 39.61           N  
ATOM   1215  CA  GLU   179      -6.423  50.683 -11.098  1.00 40.08           C  
ATOM   1216  C   GLU   179      -5.830  49.369 -10.565  1.00 39.89           C  
ATOM   1217  O   GLU   179      -6.570  48.512 -10.047  1.00 40.80           O  
ATOM   1218  CB  GLU   179      -6.540  50.655 -12.636  1.00 40.11           C  
ATOM   1219  CG  GLU   179      -6.507  49.214 -13.179  1.00 43.47           C  
ATOM   1220  CD  GLU   179      -7.351  48.973 -14.415  1.00 46.41           C  
ATOM   1221  OE1 GLU   179      -7.880  49.960 -14.980  1.00 50.62           O  
ATOM   1222  OE2 GLU   179      -7.486  47.788 -14.810  1.00 46.82           O  
ATOM   1223  N   LEU   180      -4.510  49.194 -10.691  1.00 39.48           N  
ATOM   1224  CA  LEU   180      -3.811  48.025 -10.098  1.00 39.31           C  
ATOM   1225  C   LEU   180      -4.002  47.941  -8.583  1.00 39.44           C  
ATOM   1226  O   LEU   180      -4.246  46.872  -8.015  1.00 38.38           O  
ATOM   1227  CB  LEU   180      -2.304  48.141 -10.358  1.00 39.30           C  
ATOM   1228  CG  LEU   180      -1.441  47.036  -9.750  1.00 38.15           C  
ATOM   1229  CD1 LEU   180      -1.658  45.717 -10.486  1.00 33.34           C  
ATOM   1230  CD2 LEU   180       0.046  47.422  -9.780  1.00 40.22           C  
ATOM   1231  N   MET   181      -3.847  49.086  -7.932  1.00 38.84           N  
ATOM   1232  CA  MET   181      -3.893  49.139  -6.471  1.00 39.22           C  
ATOM   1233  C   MET   181      -5.316  48.856  -5.978  1.00 39.12           C  
ATOM   1234  O   MET   181      -5.490  48.219  -4.945  1.00 38.93           O  
ATOM   1235  CB  MET   181      -3.352  50.496  -5.973  1.00 39.28           C  
ATOM   1236  CG  MET   181      -1.848  50.761  -6.347  1.00 39.80           C  
ATOM   1237  SD  MET   181      -0.644  49.150  -6.207  0.80 50.03          SE  
ATOM   1238  CE  MET   181      -0.749  48.741  -4.304  1.00 43.54           C  
ATOM   1239  N   ALA   182      -6.324  49.314  -6.730  1.00 38.66           N  
ATOM   1240  CA  ALA   182      -7.714  48.950  -6.445  1.00 38.95           C  
ATOM   1241  C   ALA   182      -7.947  47.426  -6.575  1.00 39.20           C  
ATOM   1242  O   ALA   182      -8.852  46.885  -5.948  1.00 39.76           O  
ATOM   1243  CB  ALA   182      -8.685  49.737  -7.336  1.00 38.72           C  
ATOM   1244  N   ALA   183      -7.113  46.736  -7.337  1.00 39.12           N  
ATOM   1245  CA  ALA   183      -7.270  45.262  -7.542  1.00 39.14           C  
ATOM   1246  C   ALA   183      -6.224  44.408  -6.838  1.00 39.39           C  
ATOM   1247  O   ALA   183      -6.325  43.165  -6.826  1.00 38.95           O  
ATOM   1248  CB  ALA   183      -7.291  44.929  -9.019  1.00 38.99           C  
ATOM   1249  N   ALA   184      -5.240  45.051  -6.210  1.00 39.22           N  
ATOM   1250  CA  ALA   184      -4.066  44.328  -5.747  1.00 38.88           C  
ATOM   1251  C   ALA   184      -4.423  43.297  -4.675  1.00 40.07           C  
ATOM   1252  O   ALA   184      -3.806  42.227  -4.618  1.00 38.32           O  
ATOM   1253  CB  ALA   184      -3.035  45.275  -5.244  1.00 39.29           C  
ATOM   1254  N   GLU   185      -5.384  43.627  -3.809  1.00 40.14           N  
ATOM   1255  CA  GLU   185      -5.765  42.693  -2.732  1.00 42.11           C  
ATOM   1256  C   GLU   185      -6.500  41.436  -3.275  1.00 41.53           C  
ATOM   1257  O   GLU   185      -6.199  40.301  -2.894  1.00 39.45           O  
ATOM   1258  CB  GLU   185      -6.582  43.433  -1.678  1.00 43.22           C  
ATOM   1259  CG  GLU   185      -6.269  43.043  -0.223  1.00 50.16           C  
ATOM   1260  CD  GLU   185      -4.758  43.002   0.076  1.00 57.11           C  
ATOM   1261  OE1 GLU   185      -4.074  44.003  -0.245  1.00 60.08           O  
ATOM   1262  OE2 GLU   185      -4.260  41.967   0.605  1.00 60.58           O  
ATOM   1263  N   SER   186      -7.432  41.647  -4.199  1.00 41.32           N  
ATOM   1264  CA  SER   186      -8.175  40.535  -4.777  1.00 42.46           C  
ATOM   1265  C   SER   186      -7.328  39.745  -5.782  1.00 42.08           C  
ATOM   1266  O   SER   186      -7.512  38.536  -5.919  1.00 41.71           O  
ATOM   1267  CB  SER   186      -9.474  41.018  -5.415  1.00 42.62           C  
ATOM   1268  OG  SER   186      -9.174  41.911  -6.461  1.00 44.62           O  
ATOM   1269  N   GLU   187      -6.398  40.404  -6.467  1.00 41.08           N  
ATOM   1270  CA  GLU   187      -5.419  39.646  -7.263  1.00 40.35           C  
ATOM   1271  C   GLU   187      -4.514  38.748  -6.418  1.00 39.77           C  
ATOM   1272  O   GLU   187      -4.302  37.599  -6.783  1.00 38.95           O  
ATOM   1273  CB  GLU   187      -4.589  40.552  -8.164  1.00 41.17           C  
ATOM   1274  CG  GLU   187      -5.388  41.079  -9.337  1.00 42.00           C  
ATOM   1275  CD  GLU   187      -5.830  39.962 -10.258  1.00 47.88           C  
ATOM   1276  OE1 GLU   187      -5.005  39.505 -11.069  1.00 47.76           O  
ATOM   1277  OE2 GLU   187      -6.990  39.526 -10.166  1.00 47.91           O  
ATOM   1278  N   ALA   188      -4.021  39.248  -5.275  1.00 39.62           N  
ATOM   1279  CA  ALA   188      -3.208  38.428  -4.354  1.00 39.36           C  
ATOM   1280  C   ALA   188      -3.986  37.181  -3.925  1.00 39.81           C  
ATOM   1281  O   ALA   188      -3.456  36.069  -3.961  1.00 39.51           O  
ATOM   1282  CB  ALA   188      -2.779  39.257  -3.093  1.00 38.66           C  
ATOM   1283  N   THR   189      -5.235  37.384  -3.502  1.00 38.54           N  
ATOM   1284  CA  THR   189      -6.118  36.310  -3.087  1.00 39.26           C  
ATOM   1285  C   THR   189      -6.334  35.303  -4.210  1.00 39.11           C  
ATOM   1286  O   THR   189      -6.262  34.090  -3.988  1.00 37.88           O  
ATOM   1287  CB  THR   189      -7.494  36.855  -2.631  1.00 39.24           C  
ATOM   1288  OG1 THR   189      -7.288  37.830  -1.619  1.00 40.65           O  
ATOM   1289  CG2 THR   189      -8.378  35.765  -2.068  1.00 40.14           C  
ATOM   1290  N   ARG   190      -6.581  35.820  -5.393  1.00 39.23           N  
ATOM   1291  CA  ARG   190      -6.801  35.025  -6.570  1.00 40.56           C  
ATOM   1292  C   ARG   190      -5.633  34.123  -6.835  1.00 40.07           C  
ATOM   1293  O   ARG   190      -5.788  32.956  -6.975  1.00 40.14           O  
ATOM   1294  CB  ARG   190      -6.993  35.918  -7.779  1.00 41.29           C  
ATOM   1295  CG  ARG   190      -8.079  35.488  -8.702  1.00 44.05           C  
ATOM   1296  CD  ARG   190      -7.768  35.575 -10.156  1.00 46.79           C  
ATOM   1297  NE  ARG   190      -6.739  36.506 -10.516  1.00 51.37           N  
ATOM   1298  CZ  ARG   190      -5.737  36.223 -11.314  1.00 47.62           C  
ATOM   1299  NH1 ARG   190      -5.642  35.058 -11.853  1.00 49.34           N  
ATOM   1300  NH2 ARG   190      -4.843  37.121 -11.564  1.00 47.10           N  
ATOM   1301  N   LEU   191      -4.467  34.720  -6.926  1.00 38.98           N  
ATOM   1302  CA  LEU   191      -3.217  34.037  -7.202  1.00 38.93           C  
ATOM   1303  C   LEU   191      -2.794  33.073  -6.116  1.00 39.02           C  
ATOM   1304  O   LEU   191      -2.290  31.994  -6.440  1.00 38.62           O  
ATOM   1305  CB  LEU   191      -2.075  35.040  -7.476  1.00 39.93           C  
ATOM   1306  CG  LEU   191      -2.305  35.806  -8.793  1.00 40.44           C  
ATOM   1307  CD1 LEU   191      -1.294  36.936  -8.975  1.00 43.47           C  
ATOM   1308  CD2 LEU   191      -2.281  34.785  -9.946  1.00 44.54           C  
ATOM   1309  N   ASN   192      -2.993  33.452  -4.850  1.00 37.70           N  
ATOM   1310  CA  ASN   192      -2.697  32.567  -3.715  1.00 36.83           C  
ATOM   1311  C   ASN   192      -3.572  31.343  -3.723  1.00 37.14           C  
ATOM   1312  O   ASN   192      -3.220  30.335  -3.109  1.00 38.40           O  
ATOM   1313  CB  ASN   192      -2.803  33.285  -2.328  1.00 36.57           C  
ATOM   1314  CG  ASN   192      -1.633  34.215  -2.047  1.00 36.66           C  
ATOM   1315  OD1 ASN   192      -0.523  33.959  -2.494  1.00 38.01           O  
ATOM   1316  ND2 ASN   192      -1.882  35.340  -1.331  1.00 36.35           N  
ATOM   1317  N   ALA   193      -4.720  31.401  -4.391  1.00 37.30           N  
ATOM   1318  CA  ALA   193      -5.619  30.241  -4.494  1.00 36.33           C  
ATOM   1319  C   ALA   193      -5.196  29.261  -5.595  1.00 35.42           C  
ATOM   1320  O   ALA   193      -5.751  28.146  -5.717  1.00 34.15           O  
ATOM   1321  CB  ALA   193      -7.096  30.722  -4.711  1.00 37.39           C  
ATOM   1322  N   ILE   194      -4.213  29.656  -6.408  1.00 34.06           N  
ATOM   1323  CA  ILE   194      -3.711  28.735  -7.433  1.00 34.61           C  
ATOM   1324  C   ILE   194      -2.594  27.985  -6.706  1.00 33.90           C  
ATOM   1325  O   ILE   194      -1.568  28.560  -6.394  1.00 33.32           O  
ATOM   1326  CB  ILE   194      -3.222  29.454  -8.746  1.00 34.05           C  
ATOM   1327  CG1 ILE   194      -4.363  30.303  -9.345  1.00 35.03           C  
ATOM   1328  CG2 ILE   194      -2.699  28.418  -9.802  1.00 33.21           C  
ATOM   1329  CD1 ILE   194      -3.961  31.173 -10.615  1.00 33.84           C  
ATOM   1330  N   LYS   195      -2.847  26.728  -6.374  1.00 35.20           N  
ATOM   1331  CA  LYS   195      -1.876  25.930  -5.637  1.00 35.60           C  
ATOM   1332  C   LYS   195      -0.505  25.965  -6.346  1.00 36.08           C  
ATOM   1333  O   LYS   195      -0.411  25.714  -7.565  1.00 35.81           O  
ATOM   1334  CB  LYS   195      -2.387  24.514  -5.446  1.00 35.34           C  
ATOM   1335  CG  LYS   195      -1.460  23.600  -4.645  1.00 36.94           C  
ATOM   1336  CD  LYS   195      -2.201  22.407  -4.192  1.00 34.56           C  
ATOM   1337  CE  LYS   195      -1.351  21.448  -3.450  1.00 34.63           C  
ATOM   1338  NZ  LYS   195      -2.210  20.321  -3.050  1.00 30.40           N  
ATOM   1339  N   GLY   196       0.531  26.345  -5.599  1.00 36.12           N  
ATOM   1340  CA  GLY   196       1.898  26.289  -6.099  1.00 35.91           C  
ATOM   1341  C   GLY   196       2.305  27.551  -6.816  1.00 36.65           C  
ATOM   1342  O   GLY   196       3.507  27.740  -7.088  1.00 36.86           O  
ATOM   1343  N   GLU   197       1.344  28.426  -7.125  1.00 36.33           N  
ATOM   1344  CA  GLU   197       1.667  29.605  -7.943  1.00 37.55           C  
ATOM   1345  C   GLU   197       2.560  30.629  -7.204  1.00 38.59           C  
ATOM   1346  O   GLU   197       3.497  31.163  -7.798  1.00 38.33           O  
ATOM   1347  CB  GLU   197       0.419  30.300  -8.468  1.00 37.82           C  
ATOM   1348  CG  GLU   197       0.668  31.114  -9.722  1.00 43.40           C  
ATOM   1349  CD  GLU   197       0.559  30.264 -11.018  1.00 49.01           C  
ATOM   1350  OE1 GLU   197      -0.187  30.686 -11.921  1.00 51.75           O  
ATOM   1351  OE2 GLU   197       1.177  29.164 -11.156  1.00 52.34           O  
ATOM   1352  N   ALA   198       2.291  30.892  -5.920  1.00 38.82           N  
ATOM   1353  CA  ALA   198       3.132  31.857  -5.162  1.00 39.20           C  
ATOM   1354  C   ALA   198       4.581  31.318  -5.068  1.00 40.28           C  
ATOM   1355  O   ALA   198       5.559  32.067  -5.197  1.00 39.92           O  
ATOM   1356  CB  ALA   198       2.568  32.073  -3.828  1.00 39.55           C  
ATOM   1357  N   SER   199       4.705  30.011  -4.877  1.00 39.80           N  
ATOM   1358  CA  SER   199       6.017  29.356  -4.808  1.00 41.18           C  
ATOM   1359  C   SER   199       6.752  29.410  -6.164  1.00 40.92           C  
ATOM   1360  O   SER   199       7.961  29.702  -6.200  1.00 41.81           O  
ATOM   1361  CB  SER   199       5.854  27.933  -4.303  1.00 40.29           C  
ATOM   1362  OG  SER   199       7.118  27.325  -4.118  1.00 44.86           O  
ATOM   1363  N   ARG   200       6.030  29.226  -7.276  1.00 40.52           N  
ATOM   1364  CA  ARG   200       6.615  29.459  -8.615  1.00 40.24           C  
ATOM   1365  C   ARG   200       7.175  30.877  -8.784  1.00 39.77           C  
ATOM   1366  O   ARG   200       8.250  31.065  -9.381  1.00 39.36           O  
ATOM   1367  CB  ARG   200       5.632  29.137  -9.745  1.00 40.01           C  
ATOM   1368  CG  ARG   200       5.495  27.640  -9.987  1.00 41.00           C  
ATOM   1369  CD  ARG   200       4.264  27.239 -10.825  1.00 42.99           C  
ATOM   1370  NE  ARG   200       4.142  28.008 -12.068  1.00 49.55           N  
ATOM   1371  CZ  ARG   200       3.651  27.538 -13.224  1.00 52.36           C  
ATOM   1372  NH1 ARG   200       3.581  28.348 -14.283  1.00 52.08           N  
ATOM   1373  NH2 ARG   200       3.251  26.265 -13.339  1.00 51.69           N  
ATOM   1374  N   LEU   201       6.440  31.860  -8.295  1.00 37.63           N  
ATOM   1375  CA  LEU   201       6.869  33.279  -8.351  1.00 39.30           C  
ATOM   1376  C   LEU   201       8.065  33.524  -7.449  1.00 39.33           C  
ATOM   1377  O   LEU   201       8.985  34.253  -7.837  1.00 38.96           O  
ATOM   1378  CB  LEU   201       5.730  34.241  -7.952  1.00 37.79           C  
ATOM   1379  CG  LEU   201       4.440  34.162  -8.770  1.00 40.78           C  
ATOM   1380  CD1 LEU   201       3.361  35.029  -8.131  1.00 38.26           C  
ATOM   1381  CD2 LEU   201       4.702  34.616 -10.232  1.00 39.91           C  
ATOM   1382  N   ALA   202       8.062  32.902  -6.263  1.00 39.34           N  
ATOM   1383  CA  ALA   202       9.182  33.054  -5.347  1.00 40.13           C  
ATOM   1384  C   ALA   202      10.467  32.448  -5.938  1.00 41.27           C  
ATOM   1385  O   ALA   202      11.551  33.034  -5.818  1.00 41.45           O  
ATOM   1386  CB  ALA   202       8.861  32.465  -4.019  1.00 39.97           C  
ATOM   1387  N   VAL   203      10.339  31.298  -6.600  1.00 41.74           N  
ATOM   1388  CA  VAL   203      11.497  30.685  -7.267  1.00 42.08           C  
ATOM   1389  C   VAL   203      12.026  31.580  -8.399  1.00 41.70           C  
ATOM   1390  O   VAL   203      13.220  31.783  -8.475  1.00 41.07           O  
ATOM   1391  CB  VAL   203      11.276  29.184  -7.667  1.00 42.31           C  
ATOM   1392  CG1 VAL   203      10.766  28.360  -6.474  1.00 41.59           C  
ATOM   1393  CG2 VAL   203      10.334  29.057  -8.821  1.00 44.04           C  
ATOM   1394  N   LEU   204      11.135  32.148  -9.229  1.00 42.28           N  
ATOM   1395  CA  LEU   204      11.501  33.205 -10.217  1.00 42.77           C  
ATOM   1396  C   LEU   204      12.250  34.379  -9.590  1.00 42.88           C  
ATOM   1397  O   LEU   204      13.131  34.975 -10.208  1.00 42.99           O  
ATOM   1398  CB  LEU   204      10.258  33.789 -10.906  1.00 43.24           C  
ATOM   1399  CG  LEU   204       9.650  33.355 -12.246  1.00 46.48           C  
ATOM   1400  CD1 LEU   204       8.426  32.557 -12.066  1.00 47.32           C  
ATOM   1401  CD2 LEU   204       9.289  34.637 -13.021  1.00 48.31           C  
ATOM   1402  N   ALA   205      11.845  34.737  -8.373  1.00 41.99           N  
ATOM   1403  CA  ALA   205      12.465  35.806  -7.612  1.00 42.75           C  
ATOM   1404  C   ALA   205      13.871  35.462  -7.077  1.00 42.85           C  
ATOM   1405  O   ALA   205      14.571  36.350  -6.561  1.00 44.20           O  
ATOM   1406  CB  ALA   205      11.544  36.181  -6.480  1.00 41.31           C  
ATOM   1407  N   GLY   206      14.252  34.186  -7.176  1.00 42.19           N  
ATOM   1408  CA  GLY   206      15.535  33.667  -6.718  1.00 42.09           C  
ATOM   1409  C   GLY   206      15.461  32.901  -5.405  1.00 42.11           C  
ATOM   1410  O   GLY   206      16.487  32.569  -4.842  1.00 41.96           O  
ATOM   1411  N   ALA   207      14.258  32.640  -4.900  1.00 42.14           N  
ATOM   1412  CA  ALA   207      14.086  31.971  -3.599  1.00 43.13           C  
ATOM   1413  C   ALA   207      13.941  30.435  -3.687  1.00 44.04           C  
ATOM   1414  O   ALA   207      13.926  29.858  -4.771  1.00 43.67           O  
ATOM   1415  CB  ALA   207      12.901  32.560  -2.844  1.00 43.20           C  
ATOM   1416  N   LYS   208      13.858  29.784  -2.528  1.00 45.85           N  
ATOM   1417  CA  LYS   208      13.705  28.329  -2.474  1.00 47.85           C  
ATOM   1418  C   LYS   208      12.243  27.932  -2.333  1.00 48.78           C  
ATOM   1419  O   LYS   208      11.493  28.568  -1.602  1.00 48.17           O  
ATOM   1420  CB  LYS   208      14.510  27.734  -1.313  1.00 48.57           C  
ATOM   1421  CG  LYS   208      15.886  27.145  -1.690  1.00 50.53           C  
ATOM   1422  CD  LYS   208      17.062  28.075  -1.389  1.00 55.23           C  
ATOM   1423  CE  LYS   208      17.400  28.165   0.123  1.00 57.03           C  
ATOM   1424  NZ  LYS   208      16.408  29.004   0.917  1.00 54.74           N  
ATOM   1425  N   THR   209      11.856  26.854  -3.017  1.00 50.43           N  
ATOM   1426  CA  THR   209      10.494  26.310  -2.927  1.00 51.48           C  
ATOM   1427  C   THR   209      10.035  26.159  -1.464  1.00 51.51           C  
ATOM   1428  O   THR   209      10.851  26.107  -0.522  1.00 51.65           O  
ATOM   1429  CB  THR   209      10.333  24.991  -3.735  1.00 52.21           C  
ATOM   1430  OG1 THR   209       8.940  24.634  -3.819  1.00 53.28           O  
ATOM   1431  CG2 THR   209      11.159  23.850  -3.116  1.00 52.02           C  
ATOM   1432  N   GLY   210       8.723  26.145  -1.276  1.00 50.99           N  
ATOM   1433  CA  GLY   210       8.183  26.203   0.072  1.00 50.54           C  
ATOM   1434  C   GLY   210       6.723  26.562   0.048  1.00 49.29           C  
ATOM   1435  O   GLY   210       6.091  26.552  -1.014  1.00 48.86           O  
ATOM   1436  N   ARG   211       6.181  26.857   1.225  1.00 48.70           N  
ATOM   1437  CA  ARG   211       4.782  27.252   1.299  1.00 48.23           C  
ATOM   1438  C   ARG   211       4.771  28.768   1.288  1.00 45.98           C  
ATOM   1439  O   ARG   211       4.824  29.430   2.335  1.00 47.07           O  
ATOM   1440  CB  ARG   211       4.040  26.622   2.493  1.00 48.33           C  
ATOM   1441  CG  ARG   211       4.079  25.034   2.560  1.00 52.97           C  
ATOM   1442  CD  ARG   211       4.151  24.292   1.176  1.00 61.21           C  
ATOM   1443  NE  ARG   211       2.925  24.332   0.342  1.00 66.10           N  
ATOM   1444  CZ  ARG   211       2.842  24.786  -0.919  1.00 69.04           C  
ATOM   1445  NH1 ARG   211       3.911  25.278  -1.544  1.00 70.03           N  
ATOM   1446  NH2 ARG   211       1.671  24.742  -1.576  1.00 70.00           N  
ATOM   1447  N   TRP   212       4.775  29.298   0.067  1.00 43.67           N  
ATOM   1448  CA  TRP   212       4.775  30.749  -0.205  1.00 41.76           C  
ATOM   1449  C   TRP   212       3.382  31.352  -0.350  1.00 40.77           C  
ATOM   1450  O   TRP   212       2.448  30.677  -0.800  1.00 40.44           O  
ATOM   1451  CB  TRP   212       5.553  31.004  -1.494  1.00 41.37           C  
ATOM   1452  CG  TRP   212       7.006  30.766  -1.310  1.00 39.46           C  
ATOM   1453  CD1 TRP   212       7.678  29.606  -1.529  1.00 38.11           C  
ATOM   1454  CD2 TRP   212       7.962  31.698  -0.787  1.00 39.28           C  
ATOM   1455  NE1 TRP   212       9.008  29.772  -1.236  1.00 37.62           N  
ATOM   1456  CE2 TRP   212       9.212  31.037  -0.758  1.00 40.47           C  
ATOM   1457  CE3 TRP   212       7.893  33.032  -0.374  1.00 36.46           C  
ATOM   1458  CZ2 TRP   212      10.390  31.671  -0.314  1.00 39.98           C  
ATOM   1459  CZ3 TRP   212       9.054  33.663   0.048  1.00 38.84           C  
ATOM   1460  CH2 TRP   212      10.290  32.983   0.070  1.00 39.28           C  
ATOM   1461  N   LYS   213       3.249  32.622   0.017  1.00 40.58           N  
ATOM   1462  CA  LYS   213       2.059  33.422  -0.275  1.00 40.25           C  
ATOM   1463  C   LYS   213       2.484  34.787  -0.791  1.00 39.48           C  
ATOM   1464  O   LYS   213       3.498  35.318  -0.343  1.00 39.04           O  
ATOM   1465  CB  LYS   213       1.194  33.602   0.979  1.00 40.47           C  
ATOM   1466  CG  LYS   213       0.446  32.298   1.467  1.00 43.77           C  
ATOM   1467  CD  LYS   213      -0.666  31.854   0.470  1.00 48.68           C  
ATOM   1468  CE  LYS   213      -1.257  30.458   0.783  1.00 45.97           C  
ATOM   1469  NZ  LYS   213      -2.195  29.896  -0.272  1.00 44.84           N  
ATOM   1470  N   ILE   214       1.723  35.334  -1.746  1.00 38.84           N  
ATOM   1471  CA  ILE   214       1.833  36.736  -2.134  1.00 38.25           C  
ATOM   1472  C   ILE   214       1.308  37.565  -1.016  1.00 39.46           C  
ATOM   1473  O   ILE   214       0.191  37.315  -0.538  1.00 39.34           O  
ATOM   1474  CB  ILE   214       1.020  37.045  -3.356  1.00 38.32           C  
ATOM   1475  CG1 ILE   214       1.577  36.244  -4.537  1.00 41.05           C  
ATOM   1476  CG2 ILE   214       0.995  38.591  -3.651  1.00 36.16           C  
ATOM   1477  CD1 ILE   214       0.735  36.298  -5.751  1.00 42.99           C  
ATOM   1478  N   THR   215       2.118  38.522  -0.572  1.00 40.09           N  
ATOM   1479  CA  THR   215       1.717  39.429   0.495  1.00 39.19           C  
ATOM   1480  C   THR   215       1.306  40.776  -0.058  1.00 40.01           C  
ATOM   1481  O   THR   215       0.474  41.460   0.565  1.00 40.47           O  
ATOM   1482  CB  THR   215       2.810  39.584   1.605  1.00 38.67           C  
ATOM   1483  OG1 THR   215       4.030  40.065   1.019  1.00 36.42           O  
ATOM   1484  CG2 THR   215       3.081  38.205   2.256  1.00 39.25           C  
ATOM   1485  N   SER   216       1.859  41.163  -1.219  1.00 40.46           N  
ATOM   1486  CA  SER   216       1.661  42.478  -1.733  1.00 40.62           C  
ATOM   1487  C   SER   216       2.031  42.554  -3.192  1.00 41.47           C  
ATOM   1488  O   SER   216       3.074  42.032  -3.593  1.00 41.94           O  
ATOM   1489  CB  SER   216       2.497  43.491  -0.907  1.00 39.86           C  
ATOM   1490  OG  SER   216       2.128  44.823  -1.153  1.00 41.34           O  
ATOM   1491  N   ILE   217       1.172  43.215  -3.992  1.00 41.47           N  
ATOM   1492  CA  ILE   217       1.457  43.510  -5.417  1.00 40.32           C  
ATOM   1493  C   ILE   217       1.534  45.018  -5.557  1.00 40.31           C  
ATOM   1494  O   ILE   217       0.694  45.723  -5.002  1.00 39.84           O  
ATOM   1495  CB  ILE   217       0.343  42.980  -6.348  1.00 40.39           C  
ATOM   1496  CG1 ILE   217       0.187  41.443  -6.165  1.00 39.41           C  
ATOM   1497  CG2 ILE   217       0.598  43.426  -7.811  1.00 39.89           C  
ATOM   1498  CD1 ILE   217      -1.090  40.855  -6.724  1.00 41.51           C  
ATOM   1499  N   ASP   218       2.548  45.504  -6.273  1.00 39.30           N  
ATOM   1500  CA  ASP   218       2.705  46.956  -6.484  1.00 38.73           C  
ATOM   1501  C   ASP   218       3.151  47.210  -7.933  1.00 37.93           C  
ATOM   1502  O   ASP   218       3.416  46.255  -8.685  1.00 37.25           O  
ATOM   1503  CB  ASP   218       3.623  47.588  -5.385  1.00 37.51           C  
ATOM   1504  CG  ASP   218       5.058  47.024  -5.398  1.00 40.93           C  
ATOM   1505  OD1 ASP   218       5.778  47.238  -6.414  1.00 42.23           O  
ATOM   1506  OD2 ASP   218       5.485  46.367  -4.407  1.00 40.91           O  
ATOM   1507  N   PRO   219       3.198  48.476  -8.359  1.00 37.21           N  
ATOM   1508  CA  PRO   219       3.591  48.663  -9.760  1.00 37.75           C  
ATOM   1509  C   PRO   219       4.951  48.083 -10.199  1.00 37.92           C  
ATOM   1510  O   PRO   219       5.164  47.847 -11.405  1.00 38.51           O  
ATOM   1511  CB  PRO   219       3.597  50.203  -9.907  1.00 38.18           C  
ATOM   1512  CG  PRO   219       2.574  50.651  -8.926  1.00 36.94           C  
ATOM   1513  CD  PRO   219       2.808  49.758  -7.722  1.00 36.21           C  
ATOM   1514  N   ASP   220       5.859  47.883  -9.259  1.00 37.98           N  
ATOM   1515  CA  ASP   220       7.228  47.454  -9.589  1.00 39.01           C  
ATOM   1516  C   ASP   220       7.467  45.947  -9.367  1.00 38.51           C  
ATOM   1517  O   ASP   220       8.460  45.362  -9.868  1.00 37.46           O  
ATOM   1518  CB  ASP   220       8.245  48.271  -8.767  1.00 38.35           C  
ATOM   1519  CG  ASP   220       8.330  49.724  -9.217  1.00 39.07           C  
ATOM   1520  OD1 ASP   220       7.923  50.038 -10.360  1.00 39.95           O  
ATOM   1521  OD2 ASP   220       8.803  50.553  -8.411  1.00 42.67           O  
ATOM   1522  N   GLY   221       6.533  45.310  -8.679  1.00 37.64           N  
ATOM   1523  CA  GLY   221       6.634  43.860  -8.472  1.00 38.70           C  
ATOM   1524  C   GLY   221       5.776  43.311  -7.351  1.00 39.35           C  
ATOM   1525  O   GLY   221       4.787  43.925  -6.960  1.00 39.63           O  
ATOM   1526  N   ILE   222       6.190  42.163  -6.812  1.00 39.81           N  
ATOM   1527  CA  ILE   222       5.341  41.364  -5.958  1.00 40.03           C  
ATOM   1528  C   ILE   222       6.174  40.894  -4.775  1.00 40.65           C  
ATOM   1529  O   ILE   222       7.272  40.320  -4.965  1.00 41.65           O  
ATOM   1530  CB  ILE   222       4.790  40.075  -6.716  1.00 39.93           C  
ATOM   1531  CG1 ILE   222       4.009  40.441  -7.999  1.00 38.13           C  
ATOM   1532  CG2 ILE   222       3.929  39.192  -5.700  1.00 38.68           C  
ATOM   1533  CD1 ILE   222       3.752  39.227  -8.997  1.00 40.00           C  
ATOM   1534  N   ASP   223       5.645  41.080  -3.567  1.00 39.32           N  
ATOM   1535  CA  ASP   223       6.358  40.638  -2.403  1.00 39.52           C  
ATOM   1536  C   ASP   223       5.741  39.337  -2.046  1.00 38.95           C  
ATOM   1537  O   ASP   223       4.511  39.211  -2.116  1.00 38.85           O  
ATOM   1538  CB  ASP   223       6.196  41.623  -1.251  1.00 39.17           C  
ATOM   1539  CG  ASP   223       7.141  42.848  -1.375  1.00 42.76           C  
ATOM   1540  OD1 ASP   223       8.022  42.907  -2.249  1.00 47.48           O  
ATOM   1541  OD2 ASP   223       6.998  43.742  -0.557  1.00 44.98           O  
ATOM   1542  N   LEU   224       6.580  38.377  -1.633  1.00 39.80           N  
ATOM   1543  CA  LEU   224       6.111  37.053  -1.146  1.00 38.74           C  
ATOM   1544  C   LEU   224       6.722  36.680   0.186  1.00 39.35           C  
ATOM   1545  O   LEU   224       7.821  37.137   0.512  1.00 38.40           O  
ATOM   1546  CB  LEU   224       6.378  35.942  -2.182  1.00 39.02           C  
ATOM   1547  CG  LEU   224       5.897  36.304  -3.590  1.00 37.93           C  
ATOM   1548  CD1 LEU   224       7.068  36.608  -4.460  1.00 39.11           C  
ATOM   1549  CD2 LEU   224       5.071  35.150  -4.101  1.00 40.89           C  
ATOM   1550  N   ALA   225       5.995  35.870   0.966  1.00 37.56           N  
ATOM   1551  CA  ALA   225       6.510  35.322   2.200  1.00 38.71           C  
ATOM   1552  C   ALA   225       6.232  33.820   2.347  1.00 40.11           C  
ATOM   1553  O   ALA   225       5.213  33.284   1.854  1.00 39.61           O  
ATOM   1554  CB  ALA   225       5.984  36.121   3.449  1.00 38.10           C  
ATOM   1555  N   SER   226       7.187  33.150   2.992  1.00 41.63           N  
ATOM   1556  CA  SER   226       7.013  31.793   3.510  1.00 41.51           C  
ATOM   1557  C   SER   226       7.324  31.904   4.982  1.00 42.46           C  
ATOM   1558  O   SER   226       7.537  33.010   5.479  1.00 43.34           O  
ATOM   1559  CB  SER   226       7.970  30.828   2.842  1.00 41.83           C  
ATOM   1560  OG  SER   226       9.300  31.081   3.257  1.00 42.39           O  
ATOM   1561  N   ALA   227       7.342  30.774   5.689  1.00 42.16           N  
ATOM   1562  CA  ALA   227       7.669  30.767   7.106  1.00 42.59           C  
ATOM   1563  C   ALA   227       9.110  31.220   7.433  1.00 42.71           C  
ATOM   1564  O   ALA   227       9.305  32.007   8.356  1.00 42.36           O  
ATOM   1565  CB  ALA   227       7.402  29.404   7.699  1.00 43.21           C  
ATOM   1566  N   SER   228      10.105  30.715   6.694  1.00 42.72           N  
ATOM   1567  CA  SER   228      11.510  31.070   6.946  1.00 42.93           C  
ATOM   1568  C   SER   228      12.085  32.193   6.075  1.00 42.11           C  
ATOM   1569  O   SER   228      13.103  32.779   6.454  1.00 42.02           O  
ATOM   1570  CB  SER   228      12.418  29.834   6.879  1.00 43.93           C  
ATOM   1571  OG  SER   228      12.426  29.254   5.581  1.00 46.22           O  
ATOM   1572  N   ASP   229      11.432  32.518   4.949  1.00 41.72           N  
ATOM   1573  CA  ASP   229      11.994  33.464   3.977  1.00 39.90           C  
ATOM   1574  C   ASP   229      11.038  34.518   3.395  1.00 38.59           C  
ATOM   1575  O   ASP   229       9.824  34.418   3.499  1.00 37.75           O  
ATOM   1576  CB  ASP   229      12.660  32.689   2.838  1.00 40.44           C  
ATOM   1577  CG  ASP   229      13.926  33.373   2.310  1.00 44.68           C  
ATOM   1578  OD1 ASP   229      14.608  32.727   1.477  1.00 49.71           O  
ATOM   1579  OD2 ASP   229      14.260  34.531   2.722  1.00 43.59           O  
ATOM   1580  N   LEU   230      11.617  35.547   2.781  1.00 36.54           N  
ATOM   1581  CA  LEU   230      10.867  36.577   2.051  1.00 36.28           C  
ATOM   1582  C   LEU   230      11.476  36.665   0.654  1.00 36.24           C  
ATOM   1583  O   LEU   230      12.709  36.487   0.502  1.00 36.39           O  
ATOM   1584  CB  LEU   230      10.960  37.968   2.743  1.00 34.87           C  
ATOM   1585  CG  LEU   230      10.459  38.126   4.187  1.00 34.46           C  
ATOM   1586  CD1 LEU   230      10.799  39.517   4.729  1.00 32.33           C  
ATOM   1587  CD2 LEU   230       8.953  37.824   4.324  1.00 35.09           C  
ATOM   1588  N   ALA   231      10.630  36.971  -0.330  1.00 36.69           N  
ATOM   1589  CA  ALA   231      11.059  37.169  -1.718  1.00 37.63           C  
ATOM   1590  C   ALA   231      10.385  38.400  -2.322  1.00 37.88           C  
ATOM   1591  O   ALA   231       9.292  38.845  -1.850  1.00 36.74           O  
ATOM   1592  CB  ALA   231      10.745  35.917  -2.578  1.00 38.16           C  
ATOM   1593  N   ARG   232      11.063  38.987  -3.312  1.00 37.21           N  
ATOM   1594  CA  ARG   232      10.468  40.025  -4.146  1.00 37.53           C  
ATOM   1595  C   ARG   232      10.745  39.728  -5.616  1.00 37.39           C  
ATOM   1596  O   ARG   232      11.906  39.647  -6.036  1.00 38.13           O  
ATOM   1597  CB  ARG   232      10.957  41.450  -3.789  1.00 38.48           C  
ATOM   1598  CG  ARG   232      10.221  42.472  -4.667  1.00 41.60           C  
ATOM   1599  CD  ARG   232      10.480  43.857  -4.294  1.00 44.96           C  
ATOM   1600  NE  ARG   232       9.842  44.856  -5.158  1.00 45.46           N  
ATOM   1601  CZ  ARG   232       8.545  45.201  -5.198  1.00 44.81           C  
ATOM   1602  NH1 ARG   232       7.613  44.591  -4.445  1.00 40.67           N  
ATOM   1603  NH2 ARG   232       8.185  46.204  -6.021  1.00 40.08           N  
ATOM   1604  N   LEU   233       9.680  39.585  -6.392  1.00 37.74           N  
ATOM   1605  CA  LEU   233       9.800  39.394  -7.866  1.00 37.36           C  
ATOM   1606  C   LEU   233       9.638  40.752  -8.532  1.00 38.69           C  
ATOM   1607  O   LEU   233       8.593  41.362  -8.387  1.00 39.15           O  
ATOM   1608  CB  LEU   233       8.739  38.415  -8.393  1.00 38.10           C  
ATOM   1609  CG  LEU   233       8.736  38.007  -9.900  1.00 37.23           C  
ATOM   1610  CD1 LEU   233      10.041  37.435 -10.324  1.00 36.14           C  
ATOM   1611  CD2 LEU   233       7.602  36.987 -10.196  1.00 36.27           C  
ATOM   1612  N   TRP   234      10.659  41.219  -9.269  1.00 38.24           N  
ATOM   1613  CA  TRP   234      10.559  42.485  -9.974  1.00 39.13           C  
ATOM   1614  C   TRP   234       9.999  42.342 -11.361  1.00 39.09           C  
ATOM   1615  O   TRP   234      10.421  41.458 -12.124  1.00 40.17           O  
ATOM   1616  CB  TRP   234      11.916  43.181 -10.045  1.00 39.39           C  
ATOM   1617  CG  TRP   234      12.446  43.508  -8.659  1.00 39.51           C  
ATOM   1618  CD1 TRP   234      13.161  42.667  -7.823  1.00 40.36           C  
ATOM   1619  CD2 TRP   234      12.292  44.740  -7.949  1.00 40.13           C  
ATOM   1620  NE1 TRP   234      13.498  43.317  -6.657  1.00 35.87           N  
ATOM   1621  CE2 TRP   234      12.967  44.585  -6.692  1.00 41.06           C  
ATOM   1622  CE3 TRP   234      11.668  45.966  -8.244  1.00 39.24           C  
ATOM   1623  CZ2 TRP   234      13.023  45.616  -5.731  1.00 42.27           C  
ATOM   1624  CZ3 TRP   234      11.732  47.019  -7.270  1.00 42.22           C  
ATOM   1625  CH2 TRP   234      12.398  46.825  -6.044  1.00 40.34           C  
ATOM   1626  N   PHE   235       9.043  43.203 -11.706  1.00 38.84           N  
ATOM   1627  CA  PHE   235       8.515  43.208 -13.084  1.00 38.96           C  
ATOM   1628  C   PHE   235       9.582  43.700 -14.033  1.00 38.59           C  
ATOM   1629  O   PHE   235      10.443  44.516 -13.632  1.00 38.93           O  
ATOM   1630  CB  PHE   235       7.276  44.094 -13.183  1.00 38.97           C  
ATOM   1631  CG  PHE   235       6.112  43.615 -12.341  1.00 40.90           C  
ATOM   1632  CD1 PHE   235       5.797  42.235 -12.271  1.00 40.09           C  
ATOM   1633  CD2 PHE   235       5.322  44.534 -11.636  1.00 39.05           C  
ATOM   1634  CE1 PHE   235       4.745  41.781 -11.549  1.00 39.69           C  
ATOM   1635  CE2 PHE   235       4.223  44.079 -10.871  1.00 37.48           C  
ATOM   1636  CZ  PHE   235       3.940  42.720 -10.819  1.00 40.48           C  
ATOM   1637  N   ALA   236       9.543  43.231 -15.280  1.00 38.45           N  
ATOM   1638  CA  ALA   236      10.436  43.786 -16.290  1.00 37.70           C  
ATOM   1639  C   ALA   236      10.100  45.249 -16.627  1.00 37.64           C  
ATOM   1640  O   ALA   236      10.982  46.013 -16.965  1.00 37.01           O  
ATOM   1641  CB  ALA   236      10.483  42.913 -17.582  1.00 38.00           C  
ATOM   1642  N   GLU   237       8.824  45.611 -16.580  1.00 37.50           N  
ATOM   1643  CA  GLU   237       8.438  47.005 -16.714  1.00 38.69           C  
ATOM   1644  C   GLU   237       7.311  47.345 -15.745  1.00 38.00           C  
ATOM   1645  O   GLU   237       6.660  46.443 -15.220  1.00 38.35           O  
ATOM   1646  CB  GLU   237       8.133  47.404 -18.174  1.00 38.07           C  
ATOM   1647  CG  GLU   237       7.000  46.656 -18.820  1.00 38.95           C  
ATOM   1648  CD  GLU   237       6.900  46.949 -20.306  1.00 40.50           C  
ATOM   1649  OE1 GLU   237       6.063  46.300 -20.980  1.00 44.17           O  
ATOM   1650  OE2 GLU   237       7.648  47.820 -20.803  1.00 39.99           O  
ATOM   1651  N   ARG   238       7.144  48.649 -15.473  1.00 38.50           N  
ATOM   1652  CA  ARG   238       6.249  49.148 -14.421  1.00 38.23           C  
ATOM   1653  C   ARG   238       4.837  48.801 -14.832  1.00 38.36           C  
ATOM   1654  O   ARG   238       4.489  48.922 -15.997  1.00 36.49           O  
ATOM   1655  CB  ARG   238       6.398  50.684 -14.283  1.00 39.03           C  
ATOM   1656  CG  ARG   238       5.456  51.361 -13.290  1.00 38.45           C  
ATOM   1657  CD  ARG   238       5.582  52.918 -13.308  1.00 40.35           C  
ATOM   1658  NE  ARG   238       4.427  53.521 -12.639  1.00 40.39           N  
ATOM   1659  CZ  ARG   238       4.292  53.621 -11.319  1.00 38.31           C  
ATOM   1660  NH1 ARG   238       5.236  53.158 -10.511  1.00 40.01           N  
ATOM   1661  NH2 ARG   238       3.199  54.153 -10.810  1.00 35.26           N  
ATOM   1662  N   VAL   239       4.014  48.410 -13.876  1.00 39.17           N  
ATOM   1663  CA  VAL   239       2.653  47.913 -14.163  1.00 40.40           C  
ATOM   1664  C   VAL   239       1.617  48.878 -13.543  1.00 40.56           C  
ATOM   1665  O   VAL   239       1.759  49.304 -12.403  1.00 38.13           O  
ATOM   1666  CB  VAL   239       2.495  46.455 -13.636  1.00 40.92           C  
ATOM   1667  CG1 VAL   239       1.032  46.075 -13.500  1.00 41.13           C  
ATOM   1668  CG2 VAL   239       3.219  45.489 -14.602  1.00 41.64           C  
ATOM   1669  N   GLU   240       0.599  49.262 -14.314  1.00 39.99           N  
ATOM   1670  CA  GLU   240      -0.309  50.325 -13.830  1.00 40.55           C  
ATOM   1671  C   GLU   240      -1.774  49.914 -13.806  1.00 40.06           C  
ATOM   1672  O   GLU   240      -2.584  50.452 -13.040  1.00 38.77           O  
ATOM   1673  CB  GLU   240      -0.098  51.614 -14.631  1.00 41.11           C  
ATOM   1674  CG  GLU   240       1.092  52.415 -14.105  1.00 40.98           C  
ATOM   1675  CD  GLU   240       1.240  53.750 -14.788  1.00 42.99           C  
ATOM   1676  OE1 GLU   240       0.678  53.947 -15.907  1.00 43.11           O  
ATOM   1677  OE2 GLU   240       1.937  54.609 -14.198  1.00 45.89           O  
ATOM   1678  N   THR   241      -2.069  48.888 -14.592  1.00 40.56           N  
ATOM   1679  CA  THR   241      -3.427  48.407 -14.767  1.00 40.97           C  
ATOM   1680  C   THR   241      -3.498  46.920 -14.591  1.00 41.14           C  
ATOM   1681  O   THR   241      -2.471  46.206 -14.586  1.00 40.51           O  
ATOM   1682  CB  THR   241      -3.978  48.755 -16.176  1.00 41.31           C  
ATOM   1683  OG1 THR   241      -3.235  48.037 -17.173  1.00 41.19           O  
ATOM   1684  CG2 THR   241      -3.896  50.254 -16.443  1.00 40.83           C  
ATOM   1685  N   LEU   242      -4.724  46.430 -14.464  1.00 41.44           N  
ATOM   1686  CA  LEU   242      -4.923  44.999 -14.321  1.00 41.37           C  
ATOM   1687  C   LEU   242      -4.507  44.277 -15.604  1.00 40.45           C  
ATOM   1688  O   LEU   242      -3.842  43.239 -15.543  1.00 39.76           O  
ATOM   1689  CB  LEU   242      -6.383  44.686 -13.982  1.00 42.24           C  
ATOM   1690  CG  LEU   242      -6.693  43.207 -13.740  1.00 43.34           C  
ATOM   1691  CD1 LEU   242      -6.140  42.777 -12.389  1.00 47.07           C  
ATOM   1692  CD2 LEU   242      -8.186  43.008 -13.766  1.00 45.50           C  
ATOM   1693  N   LYS   243      -4.917  44.817 -16.755  1.00 39.92           N  
ATOM   1694  CA  LYS   243      -4.502  44.262 -18.042  1.00 39.83           C  
ATOM   1695  C   LYS   243      -2.986  44.123 -18.089  1.00 39.07           C  
ATOM   1696  O   LYS   243      -2.484  43.076 -18.483  1.00 38.24           O  
ATOM   1697  CB  LYS   243      -4.976  45.110 -19.240  1.00 40.23           C  
ATOM   1698  CG  LYS   243      -4.818  44.352 -20.557  1.00 43.46           C  
ATOM   1699  CD  LYS   243      -5.697  44.891 -21.694  1.00 46.25           C  
ATOM   1700  CE  LYS   243      -6.112  43.753 -22.612  1.00 49.30           C  
ATOM   1701  NZ  LYS   243      -6.790  42.665 -21.842  1.00 50.82           N  
ATOM   1702  N   GLN   244      -2.270  45.172 -17.665  1.00 38.67           N  
ATOM   1703  CA  GLN   244      -0.815  45.166 -17.687  1.00 38.68           C  
ATOM   1704  C   GLN   244      -0.265  44.151 -16.698  1.00 39.31           C  
ATOM   1705  O   GLN   244       0.726  43.487 -16.981  1.00 39.04           O  
ATOM   1706  CB  GLN   244      -0.226  46.558 -17.442  1.00 37.90           C  
ATOM   1707  CG  GLN   244      -0.509  47.574 -18.567  1.00 37.97           C  
ATOM   1708  CD  GLN   244      -0.042  48.971 -18.208  1.00 38.18           C  
ATOM   1709  OE1 GLN   244       0.280  49.264 -17.055  1.00 37.40           O  
ATOM   1710  NE2 GLN   244      -0.004  49.850 -19.201  1.00 38.82           N  
ATOM   1711  N   PHE   245      -0.904  44.014 -15.532  1.00 40.67           N  
ATOM   1712  CA  PHE   245      -0.460  43.012 -14.562  1.00 41.10           C  
ATOM   1713  C   PHE   245      -0.560  41.581 -15.123  1.00 41.63           C  
ATOM   1714  O   PHE   245       0.404  40.810 -15.086  1.00 40.20           O  
ATOM   1715  CB  PHE   245      -1.295  43.096 -13.303  1.00 40.94           C  
ATOM   1716  CG  PHE   245      -0.929  42.085 -12.296  1.00 42.35           C  
ATOM   1717  CD1 PHE   245       0.328  42.120 -11.694  1.00 45.23           C  
ATOM   1718  CD2 PHE   245      -1.842  41.116 -11.891  1.00 43.67           C  
ATOM   1719  CE1 PHE   245       0.700  41.173 -10.739  1.00 42.02           C  
ATOM   1720  CE2 PHE   245      -1.473  40.171 -10.906  1.00 44.61           C  
ATOM   1721  CZ  PHE   245      -0.206  40.220 -10.336  1.00 39.90           C  
ATOM   1722  N   GLU   246      -1.760  41.234 -15.585  1.00 43.00           N  
ATOM   1723  CA  GLU   246      -2.042  39.927 -16.170  1.00 44.84           C  
ATOM   1724  C   GLU   246      -1.063  39.602 -17.321  1.00 44.90           C  
ATOM   1725  O   GLU   246      -0.621  38.454 -17.459  1.00 44.81           O  
ATOM   1726  CB  GLU   246      -3.526  39.860 -16.591  1.00 44.32           C  
ATOM   1727  CG  GLU   246      -3.954  38.674 -17.517  1.00 47.80           C  
ATOM   1728  CD  GLU   246      -5.251  38.946 -18.302  1.00 48.21           C  
ATOM   1729  OE1 GLU   246      -5.773  40.089 -18.210  1.00 54.42           O  
ATOM   1730  OE2 GLU   246      -5.737  38.036 -19.037  1.00 53.58           O  
ATOM   1731  N   LYS   247      -0.709  40.599 -18.135  1.00 45.50           N  
ATOM   1732  CA  LYS   247       0.238  40.365 -19.245  1.00 45.47           C  
ATOM   1733  C   LYS   247       1.616  40.052 -18.693  1.00 45.44           C  
ATOM   1734  O   LYS   247       2.220  39.049 -19.049  1.00 44.50           O  
ATOM   1735  CB  LYS   247       0.365  41.573 -20.175  1.00 45.46           C  
ATOM   1736  CG  LYS   247      -0.918  42.053 -20.865  1.00 48.64           C  
ATOM   1737  CD  LYS   247      -1.542  41.049 -21.852  1.00 50.26           C  
ATOM   1738  CE  LYS   247      -2.612  40.175 -21.151  1.00 52.86           C  
ATOM   1739  NZ  LYS   247      -3.531  40.995 -20.265  1.00 51.97           N  
ATOM   1740  N   ALA   248       2.113  40.961 -17.860  1.00 45.18           N  
ATOM   1741  CA  ALA   248       3.347  40.778 -17.103  1.00 47.11           C  
ATOM   1742  C   ALA   248       3.417  39.420 -16.390  1.00 47.71           C  
ATOM   1743  O   ALA   248       4.455  38.767 -16.415  1.00 48.59           O  
ATOM   1744  CB  ALA   248       3.510  41.906 -16.065  1.00 46.51           C  
ATOM   1745  N   LEU   249       2.324  38.999 -15.752  1.00 48.09           N  
ATOM   1746  CA  LEU   249       2.333  37.731 -15.017  1.00 49.29           C  
ATOM   1747  C   LEU   249       2.472  36.559 -15.978  1.00 48.63           C  
ATOM   1748  O   LEU   249       3.212  35.595 -15.702  1.00 48.78           O  
ATOM   1749  CB  LEU   249       1.068  37.553 -14.151  1.00 49.60           C  
ATOM   1750  CG  LEU   249       1.090  37.485 -12.610  1.00 54.43           C  
ATOM   1751  CD1 LEU   249       0.097  36.412 -12.168  1.00 55.08           C  
ATOM   1752  CD2 LEU   249       2.454  37.183 -11.983  1.00 55.79           C  
ATOM   1753  N   ALA   250       1.760  36.656 -17.101  1.00 48.14           N  
ATOM   1754  CA  ALA   250       1.699  35.597 -18.113  1.00 47.71           C  
ATOM   1755  C   ALA   250       3.049  35.394 -18.810  1.00 47.83           C  
ATOM   1756  O   ALA   250       3.456  34.250 -19.061  1.00 47.90           O  
ATOM   1757  CB  ALA   250       0.585  35.891 -19.145  1.00 47.10           C  
ATOM   1758  N   GLN   251       3.714  36.499 -19.150  1.00 47.40           N  
ATOM   1759  CA  GLN   251       5.108  36.485 -19.619  1.00 47.72           C  
ATOM   1760  C   GLN   251       5.992  35.752 -18.607  1.00 47.15           C  
ATOM   1761  O   GLN   251       6.709  34.823 -18.961  1.00 47.30           O  
ATOM   1762  CB  GLN   251       5.616  37.924 -19.883  1.00 47.82           C  
ATOM   1763  CG  GLN   251       7.139  38.186 -19.666  1.00 50.16           C  
ATOM   1764  CD  GLN   251       7.488  39.108 -18.448  1.00 55.43           C  
ATOM   1765  OE1 GLN   251       8.672  39.397 -18.198  1.00 57.79           O  
ATOM   1766  NE2 GLN   251       6.471  39.574 -17.717  1.00 51.70           N  
ATOM   1767  N   LEU   252       5.888  36.124 -17.345  1.00 46.40           N  
ATOM   1768  CA  LEU   252       6.785  35.611 -16.347  1.00 45.83           C  
ATOM   1769  C   LEU   252       6.648  34.127 -16.155  1.00 45.15           C  
ATOM   1770  O   LEU   252       7.614  33.437 -15.989  1.00 45.08           O  
ATOM   1771  CB  LEU   252       6.532  36.290 -15.001  1.00 45.21           C  
ATOM   1772  CG  LEU   252       7.059  37.678 -14.736  1.00 47.10           C  
ATOM   1773  CD1 LEU   252       6.263  38.387 -13.704  1.00 50.45           C  
ATOM   1774  CD2 LEU   252       8.474  37.620 -14.342  1.00 46.31           C  
ATOM   1775  N   LEU   253       5.428  33.655 -16.131  1.00 44.83           N  
ATOM   1776  CA  LEU   253       5.173  32.277 -15.753  1.00 45.50           C  
ATOM   1777  C   LEU   253       5.338  31.295 -16.921  1.00 47.33           C  
ATOM   1778  O   LEU   253       4.850  30.149 -16.882  1.00 47.87           O  
ATOM   1779  CB  LEU   253       3.790  32.160 -15.118  1.00 45.04           C  
ATOM   1780  CG  LEU   253       3.754  32.686 -13.679  1.00 44.08           C  
ATOM   1781  CD1 LEU   253       2.335  32.971 -13.207  1.00 41.18           C  
ATOM   1782  CD2 LEU   253       4.480  31.688 -12.774  1.00 44.27           C  
ATOM   1783  N   LYS   254       6.051  31.725 -17.954  1.00 48.81           N  
ATOM   1784  CA  LYS   254       6.266  30.875 -19.122  1.00 49.32           C  
ATOM   1785  C   LYS   254       7.219  29.706 -18.901  1.00 49.52           C  
ATOM   1786  O   LYS   254       7.221  28.754 -19.695  1.00 49.50           O  
ATOM   1787  CB  LYS   254       6.687  31.703 -20.338  1.00 49.85           C  
ATOM   1788  CG  LYS   254       5.620  31.769 -21.438  1.00 51.80           C  
ATOM   1789  CD  LYS   254       4.301  32.361 -20.926  1.00 53.96           C  
ATOM   1790  CE  LYS   254       3.413  31.331 -20.190  1.00 54.77           C  
ATOM   1791  NZ  LYS   254       2.785  31.953 -18.947  1.00 53.07           N  
END
