
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  238 ( 1863),  selected  238 , name 2arz_A
# Molecule2: number of CA atoms  234 ( 1778),  selected  234 , name T0506.pdb
# PARAMETERS: 2arz_A.T0506.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     2_A      V       4           -
LGA    V     3_A      A       5           -
LGA    -       -      P       6           -
LGA    -       -      P       7           -
LGA    -       -      V       8           -
LGA    -       -      I       9           -
LGA    -       -      T      10           -
LGA    -       -      P      11           -
LGA    -       -      R      12           -
LGA    -       -      F      24           -
LGA    E     4_A      E      25          3.705
LGA    A     5_A      A      26          2.038
LGA    A     6_A      V      27          2.439
LGA    K     7_A      R      28          2.871
LGA    N     8_A      V      29          2.396
LGA    A     9_A      A      30          1.475
LGA    R    10_A      R      31          1.572
LGA    E    11_A      D      32          1.767
LGA    L    12_A      V      33          1.204
LGA    L    13_A      L      34          0.376
LGA    L    14_A      H      35          0.851
LGA    K    15_A      T      36          1.566
LGA    E    16_A      S      37          0.956
LGA    Y    17_A      R      38          1.943
LGA    R    18_A      T      39          1.575
LGA    A    19_A      A      40          0.823
LGA    V    20_A      A      41          0.631
LGA    L    21_A      L      42          0.511
LGA    S    22_A      A      43          0.735
LGA    T    23_A      T      44          0.694
LGA    H    24_A      L      45          0.893
LGA    S    25_A      D      46          2.763
LGA    K    26_A      P      47          4.524
LGA    K    27_A      -       -           -
LGA    W    28_A      V      48           #
LGA    P    29_A      S      49          2.067
LGA    G    30_A      G      50          3.024
LGA    F    31_A      Y      51          2.445
LGA    P    32_A      P      52          1.314
LGA    F    33_A      Y      53          1.839
LGA    G    34_A      T      54          1.629
LGA    S    35_A      T      55          1.080
LGA    V    36_A      A      56          1.201
LGA    V    37_A      T      57          1.223
LGA    P    38_A      N      58          0.998
LGA    Y    39_A      I      59          1.262
LGA    C    40_A      G      60          1.880
LGA    L    41_A      I      61          1.759
LGA    D    42_A      E      62          1.981
LGA    A    43_A      P      63          3.766
LGA    E    44_A      D      64          3.314
LGA    G    45_A      G      65          2.038
LGA    R    46_A      T      66          1.346
LGA    P    47_A      P      67          0.841
LGA    L    48_A      F      68          1.017
LGA    I    49_A      F      69          0.894
LGA    L    50_A      F      70          1.748
LGA    I    51_A      A      71          1.738
LGA    S    52_A      A      72          1.431
LGA    R    53_A      G      73          1.245
LGA    I    54_A      L      74          1.232
LGA    A    55_A      T      75          2.101
LGA    Q    56_A      L      76          1.839
LGA    H    57_A      H      77          1.249
LGA    T    58_A      A      78          0.793
LGA    H    59_A      R      79          0.745
LGA    N    60_A      N      80          1.076
LGA    L    61_A      M      81          0.647
LGA    Q    62_A      E      82          0.659
LGA    A    63_A      T      83          0.831
LGA    D    64_A      D      84          0.837
LGA    P    65_A      A      85          0.561
LGA    R    66_A      R      86          0.210
LGA    C    67_A      I      87          0.645
LGA    S    68_A      S      88          0.415
LGA    M    69_A      V      89          0.446
LGA    L    70_A      T      90          0.312
LGA    V    71_A      L      91          1.013
LGA    G    72_A      A      92          1.711
LGA    E    73_A      P      93          2.717
LGA    R    74_A      F      94          2.851
LGA    G    75_A      G      95          3.297
LGA    A    76_A      K      96          4.310
LGA    E    77_A      G      97          3.781
LGA    D    78_A      D      98          4.846
LGA    I    79_A      A      99          3.217
LGA    Q    80_A      L     100          3.098
LGA    A    81_A      T     101          3.642
LGA    V    82_A      L     102          3.140
LGA    G    83_A      P     103          1.946
LGA    R    84_A      R     104          1.300
LGA    L    85_A      L     105          1.115
LGA    T    86_A      T     106          0.712
LGA    L    87_A      L     107          0.524
LGA    L    88_A      V     108          0.509
LGA    A    89_A      G     109          0.991
LGA    E    90_A      R     110          0.408
LGA    A    91_A      A     111          0.381
LGA    R    92_A      D     112          0.861
LGA    Q    93_A      R     113          0.535
LGA    L    94_A      I     114          1.473
LGA    A    95_A      G     115          1.742
LGA    E    96_A      P     116          2.127
LGA    E    97_A      D     117          3.233
LGA    E    98_A      E     118          3.196
LGA    V    99_A      V     119          2.789
LGA    A   100_A      P     120          3.806
LGA    A   101_A      L     121          3.611
LGA    A   102_A      A     122          2.711
LGA    A   103_A      I     123          3.100
LGA    E   104_A      A     124          3.939
LGA    R   105_A      R     125          2.928
LGA    Y   106_A      Y     126          2.908
LGA    Y   107_A      I     127          3.389
LGA    R   108_A      A     128          3.036
LGA    Y   109_A      R     129          3.117
LGA    F   110_A      Y     130          3.114
LGA    P   111_A      P     131          3.875
LGA    E   112_A      K     132          3.627
LGA    S   113_A      A     133          2.559
LGA    A   114_A      K     134           #
LGA    D   115_A      L     135           -
LGA    Y   116_A      Y     136           #
LGA    H   117_A      L     137           #
LGA    R   118_A      S     138           #
LGA    V   119_A      L     139           #
LGA    H   120_A      P     140          3.449
LGA    D   121_A      D     141          2.280
LGA    F   122_A      T     142          1.172
LGA    D   123_A      R     143          2.391
LGA    F   124_A      L     144          1.701
LGA    W   125_A      Y     145          0.727
LGA    V   126_A      R     146          0.823
LGA    L   127_A      L     147          0.628
LGA    Q   128_A      R     148          0.376
LGA    P   129_A      T     149          0.855
LGA    V   130_A      E     150          1.031
LGA    Q   131_A      G     151          0.585
LGA    W   132_A      V     152          0.555
LGA    R   133_A      Q     153          1.161
LGA    F   134_A      I     154          1.421
LGA    I   135_A      N     155          1.816
LGA    G   136_A      G     156          4.071
LGA    G   137_A      -       -           -
LGA    F   138_A      -       -           -
LGA    G   139_A      -       -           -
LGA    A   140_A      -       -           -
LGA    I   141_A      -       -           -
LGA    H   142_A      S     163          2.069
LGA    W   143_A      N     164          4.063
LGA    L   144_A      I     165          3.036
LGA    A   145_A      T     166          3.048
LGA    A   146_A      P     167          3.024
LGA    E   147_A      A     168          2.406
LGA    R   148_A      D     169          2.882
LGA    V   149_A      L     170          1.948
LGA    P   150_A      R     171          1.638
LGA    L   151_A      T     172          1.638
LGA    A   152_A      D     173          3.540
LGA    N   153_A      L     174          4.581
LGA    -       -      S     175           -
LGA    -       -      G     176           -
LGA    -       -      A     177           -
LGA    P   154_A      E     178          5.370
LGA    -       -      E     179           -
LGA    F   155_A      L     180          5.279
LGA    A   156_A      M     181          5.542
LGA    G   157_A      -       -           -
LGA    E   158_A      A     182          5.590
LGA    A   159_A      A     183          2.602
LGA    E   160_A      A     184          2.157
LGA    R   161_A      E     185          1.702
LGA    G   162_A      S     186          0.746
LGA    M   163_A      E     187          0.989
LGA    V   164_A      A     188          0.970
LGA    E   165_A      T     189          0.867
LGA    H   166_A      R     190          0.778
LGA    M   167_A      L     191          0.746
LGA    N   168_A      N     192          1.247
LGA    S   169_A      A     193          1.516
LGA    D   170_A      I     194          3.295
LGA    H   171_A      -       -           -
LGA    A   172_A      K     195          1.379
LGA    A   173_A      G     196          3.285
LGA    A   174_A      E     197          2.461
LGA    I   175_A      A     198          2.816
LGA    A   176_A      S     199          3.720
LGA    H   177_A      R     200          2.844
LGA    Y   178_A      L     201          3.212
LGA    V   179_A      A     202          4.626
LGA    E   180_A      V     203          4.935
LGA    L   181_A      L     204          4.872
LGA    -       -      A     205           -
LGA    A   182_A      G     206          3.567
LGA    G   183_A      A     207          2.901
LGA    L   184_A      K     208          0.637
LGA    P   185_A      T     209          4.369
LGA    A   186_A      G     210          2.941
LGA    H   187_A      -       -           -
LGA    A   188_A      -       -           -
LGA    A   189_A      R     211          2.575
LGA    A   190_A      W     212          1.934
LGA    Q   191_A      K     213          1.855
LGA    L   192_A      I     214          1.677
LGA    A   193_A      T     215          1.688
LGA    G   194_A      S     216          1.639
LGA    I   195_A      I     217          1.722
LGA    D   196_A      D     218          2.158
LGA    T   197_A      P     219          2.196
LGA    E   198_A      D     220          2.290
LGA    G   199_A      G     221          2.219
LGA    F   200_A      I     222          1.668
LGA    H   201_A      D     223          2.301
LGA    L   202_A      L     224          2.248
LGA    R   203_A      A     225          2.121
LGA    I   204_A      S     226          1.585
LGA    G   205_A      A     227          2.229
LGA    Q   206_A      -       -           -
LGA    G   207_A      S     228          2.779
LGA    L   208_A      D     229          3.743
LGA    H   209_A      L     230          1.603
LGA    W   210_A      A     231          1.804
LGA    L   211_A      R     232          2.673
LGA    P   212_A      L     233          2.005
LGA    F   213_A      W     234          2.894
LGA    P   214_A      F     235          3.827
LGA    A   215_A      A     236          1.484
LGA    A   216_A      E     237          3.665
LGA    -       -      R     238           -
LGA    C   217_A      V     239          2.179
LGA    G   218_A      E     240          2.594
LGA    N   219_A      T     241          2.629
LGA    P   220_A      L     242          2.746
LGA    G   221_A      K     243          2.586
LGA    A   222_A      Q     244          2.471
LGA    V   223_A      F     245          2.500
LGA    R   224_A      E     246          2.273
LGA    Q   225_A      K     247          2.447
LGA    A   226_A      A     248          2.726
LGA    L   227_A      L     249          2.499
LGA    V   228_A      A     250          2.432
LGA    Q   229_A      Q     251          2.826
LGA    L   230_A      L     252          3.021
LGA    A   231_A      L     253          2.551
LGA    R   232_A      K     254          2.355
LGA    A   233_A      -       -           -
LGA    E   234_A      -       -           -
LGA    R   235_A      -       -           -
LGA    W   236_A      -       -           -
LGA    P   237_A      -       -           -
LGA    T   238_A      -       -           -
LGA    V   239_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  238  234    5.0    211    2.45    21.33     65.338     8.280

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.973517 * X  +  -0.149026 * Y  +   0.173367 * Z  +  42.056713
  Y_new =  -0.215351 * X  +   0.343226 * Y  +  -0.914232 * Z  +  69.283936
  Z_new =   0.076740 * X  +  -0.927355 * Y  +  -0.366229 * Z  +  61.823429 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.946914    1.194679  [ DEG:  -111.5499     68.4501 ]
  Theta =  -0.076816   -3.064777  [ DEG:    -4.4012   -175.5988 ]
  Phi   =  -2.923890    0.217703  [ DEG:  -167.5265     12.4735 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2arz_A                                        
REMARK     2: T0506.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2arz_A.T0506.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  238  234   5.0  211   2.45   21.33  65.338
REMARK  ---------------------------------------------------------- 
MOLECULE 2arz_A
HEADER    UNKNOWN FUNCTION                        22-AUG-05   2ARZ              
TITLE     CRYSTAL STRUCTURE OF PROTEIN OF UNKNOWN FUNCTION FROM                 
TITLE    2 PSEUDOMONAS AERUGINOSA                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN PA4388;                               
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS AERUGINOSA;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: PAO1;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    HYPOTHETICAL PROTEIN,STRUCTURAL GENOMICS,MCSG, PSEUDOMONAS            
KEYWDS   2 AERUGINOSA, PSI, PROTEIN STRUCTURE INITIATIVE, MIDWEST               
KEYWDS   3 CENTER FOR STRUCTURAL GENOMICS                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    B.NOCEK,X.XU,A.SAVCHENKO,A.EDWARDS,A.JOACHIMIAK,MIDWEST               
AUTHOR   2 CENTER FOR STRUCTURAL GENOMICS (MCSG)                                
REVDAT   1   04-OCT-05 2ARZ    0                                                
JRNL        AUTH   B.NOCEK,X.XU,A.SAVCHENKO,A.EDWARDS,A.JOACHIMIAK              
JRNL        TITL   CRYSTAL STRUCTURE OF HYPOTHETICAL PROTEIN FROM               
JRNL        TITL 2 PSEUDOMONAS AERUGINOSA                                       
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  2ARZ A    1   244  UNP    Q9HW16   Q9HW16_PSEAE     1    244             
DBREF  2ARZ B    1   244  UNP    Q9HW16   Q9HW16_PSEAE     1    244             
SEQRES   1 A  247  ALA ASN SER MET SER VAL GLU ALA ALA LYS ASN ALA ARG          
SEQRES   2 A  247  GLU LEU LEU LEU LYS GLU TYR ARG ALA VAL LEU SER THR          
SEQRES   3 A  247  HIS SER LYS LYS TRP PRO GLY PHE PRO PHE GLY SER VAL          
SEQRES   4 A  247  VAL PRO TYR CYS LEU ASP ALA GLU GLY ARG PRO LEU ILE          
SEQRES   5 A  247  LEU ILE SER ARG ILE ALA GLN HIS THR HIS ASN LEU GLN          
SEQRES   6 A  247  ALA ASP PRO ARG CYS SER MET LEU VAL GLY GLU ARG GLY          
SEQRES   7 A  247  ALA GLU ASP ILE GLN ALA VAL GLY ARG LEU THR LEU LEU          
SEQRES   8 A  247  ALA GLU ALA ARG GLN LEU ALA GLU GLU GLU VAL ALA ALA          
SEQRES   9 A  247  ALA ALA GLU ARG TYR TYR ARG TYR PHE PRO GLU SER ALA          
SEQRES  10 A  247  ASP TYR HIS ARG VAL HIS ASP PHE ASP PHE TRP VAL LEU          
SEQRES  11 A  247  GLN PRO VAL GLN TRP ARG PHE ILE GLY GLY PHE GLY ALA          
SEQRES  12 A  247  ILE HIS TRP LEU ALA ALA GLU ARG VAL PRO LEU ALA ASN          
SEQRES  13 A  247  PRO PHE ALA GLY GLU ALA GLU ARG GLY MET VAL GLU HIS          
SEQRES  14 A  247  MET ASN SER ASP HIS ALA ALA ALA ILE ALA HIS TYR VAL          
SEQRES  15 A  247  GLU LEU ALA GLY LEU PRO ALA HIS ALA ALA ALA GLN LEU          
SEQRES  16 A  247  ALA GLY ILE ASP THR GLU GLY PHE HIS LEU ARG ILE GLY          
SEQRES  17 A  247  GLN GLY LEU HIS TRP LEU PRO PHE PRO ALA ALA CYS GLY          
SEQRES  18 A  247  ASN PRO GLY ALA VAL ARG GLN ALA LEU VAL GLN LEU ALA          
SEQRES  19 A  247  ARG ALA GLU ARG TRP PRO THR VAL GLU PRO GLU GLN GLY          
SEQRES   1 B  247  ALA ASN SER MET SER VAL GLU ALA ALA LYS ASN ALA ARG          
SEQRES   2 B  247  GLU LEU LEU LEU LYS GLU TYR ARG ALA VAL LEU SER THR          
SEQRES   3 B  247  HIS SER LYS LYS TRP PRO GLY PHE PRO PHE GLY SER VAL          
SEQRES   4 B  247  VAL PRO TYR CYS LEU ASP ALA GLU GLY ARG PRO LEU ILE          
SEQRES   5 B  247  LEU ILE SER ARG ILE ALA GLN HIS THR HIS ASN LEU GLN          
SEQRES   6 B  247  ALA ASP PRO ARG CYS SER MET LEU VAL GLY GLU ARG GLY          
SEQRES   7 B  247  ALA GLU ASP ILE GLN ALA VAL GLY ARG LEU THR LEU LEU          
SEQRES   8 B  247  ALA GLU ALA ARG GLN LEU ALA GLU GLU GLU VAL ALA ALA          
SEQRES   9 B  247  ALA ALA GLU ARG TYR TYR ARG TYR PHE PRO GLU SER ALA          
SEQRES  10 B  247  ASP TYR HIS ARG VAL HIS ASP PHE ASP PHE TRP VAL LEU          
SEQRES  11 B  247  GLN PRO VAL GLN TRP ARG PHE ILE GLY GLY PHE GLY ALA          
SEQRES  12 B  247  ILE HIS TRP LEU ALA ALA GLU ARG VAL PRO LEU ALA ASN          
SEQRES  13 B  247  PRO PHE ALA GLY GLU ALA GLU ARG GLY MET VAL GLU HIS          
SEQRES  14 B  247  MET ASN SER ASP HIS ALA ALA ALA ILE ALA HIS TYR VAL          
SEQRES  15 B  247  GLU LEU ALA GLY LEU PRO ALA HIS ALA ALA ALA GLN LEU          
SEQRES  16 B  247  ALA GLY ILE ASP THR GLU GLY PHE HIS LEU ARG ILE GLY          
SEQRES  17 B  247  GLN GLY LEU HIS TRP LEU PRO PHE PRO ALA ALA CYS GLY          
SEQRES  18 B  247  ASN PRO GLY ALA VAL ARG GLN ALA LEU VAL GLN LEU ALA          
SEQRES  19 B  247  ARG ALA GLU ARG TRP PRO THR VAL GLU PRO GLU GLN GLY          
HET     CL    401       1                                                       
HET     CL    501       1                                                       
HET     CL    601       1                                                       
HET    GOL   2647       6                                                       
HET    GOL   2648       6                                                       
HETNAM      CL CHLORIDE ION                                                     
HETNAM     GOL GLYCEROL                                                         
FORMUL   3   CL    3(CL 1-)                                                     
FORMUL   6  GOL    2(C3 H8 O3)                                                  
FORMUL   8  HOH   *317(H2 O)                                                    
CRYST1   71.272   79.775   99.612  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   SER A   2      24.397  55.810  -7.755  1.00 54.40           N  
ATOM      2  CA  SER A   2      23.378  56.692  -7.097  1.00 54.22           C  
ATOM      3  C   SER A   2      21.928  56.308  -7.429  1.00 53.57           C  
ATOM      4  O   SER A   2      21.134  56.038  -6.521  1.00 53.62           O  
ATOM      5  CB  SER A   2      23.611  58.165  -7.417  1.00 54.66           C  
ATOM      6  OG  SER A   2      22.776  58.968  -6.586  1.00 55.83           O  
ATOM      7  N   VAL A   3      21.576  56.324  -8.720  1.00 52.09           N  
ATOM      8  CA  VAL A   3      20.291  55.769  -9.177  1.00 50.65           C  
ATOM      9  C   VAL A   3      20.331  54.256  -8.948  1.00 49.39           C  
ATOM     10  O   VAL A   3      19.344  53.649  -8.504  1.00 49.48           O  
ATOM     11  CB  VAL A   3      20.018  56.125 -10.678  1.00 51.12           C  
ATOM     12  CG1 VAL A   3      19.017  55.163 -11.327  1.00 50.54           C  
ATOM     13  CG2 VAL A   3      19.534  57.567 -10.783  1.00 51.06           C  
ATOM     14  N   GLU A   4      21.488  53.673  -9.258  1.00 47.43           N  
ATOM     15  CA  GLU A   4      21.796  52.282  -8.996  1.00 46.92           C  
ATOM     16  C   GLU A   4      21.680  51.995  -7.495  1.00 45.40           C  
ATOM     17  O   GLU A   4      21.021  51.018  -7.095  1.00 44.55           O  
ATOM     18  CB  GLU A   4      23.213  51.976  -9.494  1.00 47.78           C  
ATOM     19  CG  GLU A   4      23.833  50.669  -8.986  1.00 52.20           C  
ATOM     20  CD  GLU A   4      23.640  49.497  -9.937  1.00 57.49           C  
ATOM     21  OE1 GLU A   4      24.570  49.243 -10.726  1.00 59.99           O  
ATOM     22  OE2 GLU A   4      22.574  48.832  -9.911  1.00 60.02           O  
ATOM     23  N   ALA A   5      22.324  52.864  -6.700  1.00 43.28           N  
ATOM     24  CA  ALA A   5      22.332  52.817  -5.240  1.00 41.92           C  
ATOM     25  C   ALA A   5      20.937  52.876  -4.609  1.00 40.55           C  
ATOM     26  O   ALA A   5      20.622  52.035  -3.769  1.00 40.28           O  
ATOM     27  CB  ALA A   5      23.224  53.918  -4.680  1.00 41.63           C  
ATOM     28  N   ALA A   6      20.108  53.846  -5.015  1.00 39.04           N  
ATOM     29  CA  ALA A   6      18.719  53.940  -4.517  1.00 37.94           C  
ATOM     30  C   ALA A   6      17.845  52.713  -4.807  1.00 37.65           C  
ATOM     31  O   ALA A   6      17.050  52.290  -3.953  1.00 37.52           O  
ATOM     32  CB  ALA A   6      18.036  55.194  -5.006  1.00 37.47           C  
ATOM     33  N   LYS A   7      17.995  52.148  -6.000  1.00 37.72           N  
ATOM     34  CA  LYS A   7      17.274  50.940  -6.406  1.00 38.33           C  
ATOM     35  C   LYS A   7      17.723  49.744  -5.584  1.00 36.79           C  
ATOM     36  O   LYS A   7      16.904  48.958  -5.122  1.00 36.28           O  
ATOM     37  CB  LYS A   7      17.530  50.651  -7.892  1.00 39.55           C  
ATOM     38  CG  LYS A   7      16.327  50.100  -8.705  1.00 43.24           C  
ATOM     39  CD  LYS A   7      15.594  48.898  -8.079  1.00 47.05           C  
ATOM     40  CE  LYS A   7      14.773  48.106  -9.133  1.00 47.25           C  
ATOM     41  NZ  LYS A   7      14.309  46.801  -8.550  1.00 50.24           N  
ATOM     42  N   ASN A   8      19.037  49.604  -5.419  1.00 36.26           N  
ATOM     43  CA  ASN A   8      19.607  48.512  -4.662  1.00 35.03           C  
ATOM     44  C   ASN A   8      19.235  48.632  -3.183  1.00 33.90           C  
ATOM     45  O   ASN A   8      18.974  47.614  -2.520  1.00 32.83           O  
ATOM     46  CB  ASN A   8      21.126  48.474  -4.825  1.00 36.44           C  
ATOM     47  CG  ASN A   8      21.575  47.870  -6.165  1.00 39.07           C  
ATOM     48  OD1 ASN A   8      22.761  47.911  -6.485  1.00 46.64           O  
ATOM     49  ND2 ASN A   8      20.645  47.334  -6.948  1.00 38.19           N  
ATOM     50  N   ALA A   9      19.189  49.875  -2.693  1.00 31.40           N  
ATOM     51  CA  ALA A   9      18.689  50.157  -1.332  1.00 30.71           C  
ATOM     52  C   ALA A   9      17.247  49.659  -1.126  1.00 29.93           C  
ATOM     53  O   ALA A   9      16.976  48.910  -0.195  1.00 28.88           O  
ATOM     54  CB  ALA A   9      18.804  51.624  -1.007  1.00 29.30           C  
ATOM     55  N   ARG A  10      16.330  50.065  -2.005  1.00 30.05           N  
ATOM     56  CA  ARG A  10      14.944  49.606  -1.929  1.00 30.18           C  
ATOM     57  C   ARG A  10      14.799  48.077  -2.068  1.00 30.27           C  
ATOM     58  O   ARG A  10      13.987  47.460  -1.374  1.00 30.16           O  
ATOM     59  CB  ARG A  10      14.064  50.337  -2.970  1.00 30.05           C  
ATOM     60  CG  ARG A  10      12.535  49.961  -2.903  1.00 30.07           C  
ATOM     61  CD  ARG A  10      11.689  50.840  -3.844  1.00 29.70           C  
ATOM     62  NE  ARG A  10      12.170  50.773  -5.218  1.00 30.98           N  
ATOM     63  CZ  ARG A  10      12.911  51.693  -5.841  1.00 33.07           C  
ATOM     64  NH1 ARG A  10      13.311  52.799  -5.227  1.00 30.56           N  
ATOM     65  NH2 ARG A  10      13.270  51.486  -7.096  1.00 31.03           N  
ATOM     66  N   GLU A  11      15.587  47.481  -2.954  1.00 31.04           N  
ATOM     67  CA  GLU A  11      15.627  46.040  -3.116  1.00 32.79           C  
ATOM     68  C   GLU A  11      15.922  45.322  -1.822  1.00 31.86           C  
ATOM     69  O   GLU A  11      15.304  44.309  -1.542  1.00 31.86           O  
ATOM     70  CB  GLU A  11      16.682  45.615  -4.150  1.00 33.61           C  
ATOM     71  CG  GLU A  11      16.135  45.548  -5.547  1.00 39.59           C  
ATOM     72  CD  GLU A  11      17.227  45.465  -6.621  1.00 46.62           C  
ATOM     73  OE1 GLU A  11      18.364  45.019  -6.308  1.00 48.30           O  
ATOM     74  OE2 GLU A  11      16.932  45.856  -7.781  1.00 49.36           O  
ATOM     75  N   LEU A  12      16.873  45.842  -1.046  1.00 30.53           N  
ATOM     76  CA  LEU A  12      17.234  45.229   0.231  1.00 30.44           C  
ATOM     77  C   LEU A  12      16.094  45.386   1.262  1.00 29.83           C  
ATOM     78  O   LEU A  12      15.794  44.481   2.047  1.00 30.04           O  
ATOM     79  CB  LEU A  12      18.547  45.851   0.731  1.00 29.00           C  
ATOM     80  CG  LEU A  12      19.251  45.333   1.981  1.00 31.89           C  
ATOM     81  CD1 LEU A  12      19.505  43.797   1.957  1.00 31.34           C  
ATOM     82  CD2 LEU A  12      20.556  46.106   2.187  1.00 29.93           C  
ATOM     83  N   LEU A  13      15.479  46.556   1.253  1.00 30.17           N  
ATOM     84  CA  LEU A  13      14.356  46.865   2.107  1.00 29.96           C  
ATOM     85  C   LEU A  13      13.205  45.916   1.831  1.00 30.14           C  
ATOM     86  O   LEU A  13      12.546  45.439   2.770  1.00 30.16           O  
ATOM     87  CB  LEU A  13      13.897  48.309   1.838  1.00 29.70           C  
ATOM     88  CG  LEU A  13      12.929  48.942   2.831  1.00 29.96           C  
ATOM     89  CD1 LEU A  13      13.510  48.937   4.202  1.00 29.04           C  
ATOM     90  CD2 LEU A  13      12.636  50.378   2.396  1.00 30.77           C  
ATOM     91  N   LEU A  14      12.946  45.657   0.547  1.00 30.70           N  
ATOM     92  CA  LEU A  14      11.896  44.719   0.123  1.00 31.46           C  
ATOM     93  C   LEU A  14      12.247  43.278   0.467  1.00 31.92           C  
ATOM     94  O   LEU A  14      11.377  42.496   0.888  1.00 32.50           O  
ATOM     95  CB  LEU A  14      11.618  44.847  -1.392  1.00 31.01           C  
ATOM     96  CG  LEU A  14      10.818  46.073  -1.831  1.00 30.95           C  
ATOM     97  CD1 LEU A  14      11.007  46.359  -3.338  1.00 31.97           C  
ATOM     98  CD2 LEU A  14       9.353  45.912  -1.500  1.00 30.17           C  
ATOM     99  N   LYS A  15      13.518  42.915   0.289  1.00 32.87           N  
ATOM    100  CA  LYS A  15      13.937  41.512   0.525  1.00 33.61           C  
ATOM    101  C   LYS A  15      13.956  41.056   1.990  1.00 33.80           C  
ATOM    102  O   LYS A  15      13.842  39.853   2.284  1.00 32.64           O  
ATOM    103  CB  LYS A  15      15.291  41.227  -0.149  1.00 33.69           C  
ATOM    104  CG  LYS A  15      15.173  41.083  -1.644  1.00 35.15           C  
ATOM    105  CD  LYS A  15      16.543  41.105  -2.320  1.00 39.78           C  
ATOM    106  CE  LYS A  15      16.389  41.344  -3.815  1.00 44.88           C  
ATOM    107  NZ  LYS A  15      17.666  41.510  -4.609  1.00 46.32           N  
ATOM    108  N   GLU A  16      14.116  42.012   2.904  1.00 33.16           N  
ATOM    109  CA  GLU A  16      14.215  41.717   4.324  1.00 32.73           C  
ATOM    110  C   GLU A  16      12.864  41.874   5.035  1.00 31.95           C  
ATOM    111  O   GLU A  16      11.975  42.543   4.528  1.00 31.27           O  
ATOM    112  CB  GLU A  16      15.287  42.610   4.975  1.00 32.86           C  
ATOM    113  CG  GLU A  16      16.697  42.378   4.443  1.00 34.14           C  
ATOM    114  CD  GLU A  16      17.188  40.956   4.673  1.00 39.14           C  
ATOM    115  OE1 GLU A  16      17.294  40.552   5.850  1.00 45.12           O  
ATOM    116  OE2 GLU A  16      17.465  40.251   3.685  1.00 39.30           O  
ATOM    117  N   TYR A  17      12.708  41.248   6.198  1.00 31.41           N  
ATOM    118  CA  TYR A  17      11.468  41.396   6.963  1.00 31.97           C  
ATOM    119  C   TYR A  17      11.732  41.599   8.448  1.00 32.20           C  
ATOM    120  O   TYR A  17      10.796  41.725   9.234  1.00 31.94           O  
ATOM    121  CB  TYR A  17      10.491  40.218   6.716  1.00 32.27           C  
ATOM    122  CG  TYR A  17      11.055  38.861   7.097  1.00 32.35           C  
ATOM    123  CD1 TYR A  17      10.825  38.320   8.368  1.00 33.31           C  
ATOM    124  CD2 TYR A  17      11.851  38.143   6.203  1.00 31.95           C  
ATOM    125  CE1 TYR A  17      11.362  37.062   8.736  1.00 35.40           C  
ATOM    126  CE2 TYR A  17      12.387  36.880   6.558  1.00 34.90           C  
ATOM    127  CZ  TYR A  17      12.148  36.365   7.821  1.00 34.92           C  
ATOM    128  OH  TYR A  17      12.701  35.139   8.164  1.00 38.77           O  
ATOM    129  N   ARG A  18      13.006  41.629   8.828  1.00 33.17           N  
ATOM    130  CA  ARG A  18      13.410  41.954  10.194  1.00 34.90           C  
ATOM    131  C   ARG A  18      14.572  42.919  10.123  1.00 33.48           C  
ATOM    132  O   ARG A  18      15.473  42.790   9.272  1.00 32.86           O  
ATOM    133  CB  ARG A  18      13.796  40.718  11.028  1.00 34.27           C  
ATOM    134  CG  ARG A  18      12.644  39.732  11.254  1.00 39.00           C  
ATOM    135  CD  ARG A  18      13.035  38.526  12.143  1.00 40.08           C  
ATOM    136  NE  ARG A  18      13.050  38.898  13.569  1.00 51.62           N  
ATOM    137  CZ  ARG A  18      12.098  38.584  14.471  1.00 55.35           C  
ATOM    138  NH1 ARG A  18      11.033  37.850  14.128  1.00 55.64           N  
ATOM    139  NH2 ARG A  18      12.213  38.999  15.736  1.00 55.47           N  
ATOM    140  N   ALA A  19      14.528  43.895  11.020  1.00 32.21           N  
ATOM    141  CA  ALA A  19      15.460  44.994  11.004  1.00 30.92           C  
ATOM    142  C   ALA A  19      15.896  45.236  12.430  1.00 29.90           C  
ATOM    143  O   ALA A  19      15.198  44.820  13.375  1.00 28.97           O  
ATOM    144  CB  ALA A  19      14.774  46.223  10.444  1.00 30.00           C  
ATOM    145  N   VAL A  20      17.036  45.892  12.595  1.00 28.82           N  
ATOM    146  CA  VAL A  20      17.447  46.294  13.944  1.00 28.10           C  
ATOM    147  C   VAL A  20      17.113  47.769  14.110  1.00 28.10           C  
ATOM    148  O   VAL A  20      17.663  48.631  13.411  1.00 27.08           O  
ATOM    149  CB  VAL A  20      18.921  46.007  14.283  1.00 28.30           C  
ATOM    150  CG1 VAL A  20      19.279  46.601  15.633  1.00 27.01           C  
ATOM    151  CG2 VAL A  20      19.225  44.455  14.245  1.00 27.70           C  
ATOM    152  N   LEU A  21      16.187  48.022  15.033  1.00 28.03           N  
ATOM    153  CA  LEU A  21      15.780  49.385  15.412  1.00 29.13           C  
ATOM    154  C   LEU A  21      16.680  49.877  16.545  1.00 29.38           C  
ATOM    155  O   LEU A  21      16.759  49.219  17.615  1.00 30.45           O  
ATOM    156  CB  LEU A  21      14.315  49.341  15.897  1.00 28.70           C  
ATOM    157  CG  LEU A  21      13.636  50.633  16.365  1.00 31.62           C  
ATOM    158  CD1 LEU A  21      13.480  51.607  15.173  1.00 30.08           C  
ATOM    159  CD2 LEU A  21      12.289  50.330  17.042  1.00 29.43           C  
ATOM    160  N   SER A  22      17.349  51.023  16.349  1.00 28.61           N  
ATOM    161  CA  SER A  22      18.103  51.653  17.424  1.00 28.30           C  
ATOM    162  C   SER A  22      17.368  52.925  17.895  1.00 28.06           C  
ATOM    163  O   SER A  22      17.018  53.784  17.084  1.00 26.91           O  
ATOM    164  CB  SER A  22      19.529  51.996  16.979  1.00 28.66           C  
ATOM    165  OG  SER A  22      20.128  50.884  16.314  1.00 28.87           O  
ATOM    166  N   THR A  23      17.142  53.038  19.193  1.00 28.07           N  
ATOM    167  CA  THR A  23      16.402  54.170  19.758  1.00 27.77           C  
ATOM    168  C   THR A  23      17.238  54.830  20.860  1.00 29.52           C  
ATOM    169  O   THR A  23      18.170  54.211  21.411  1.00 30.89           O  
ATOM    170  CB  THR A  23      14.995  53.736  20.294  1.00 27.90           C  
ATOM    171  OG1 THR A  23      15.133  52.667  21.239  1.00 27.91           O  
ATOM    172  CG2 THR A  23      14.085  53.250  19.151  1.00 24.72           C  
ATOM    173  N   HIS A  24      16.953  56.092  21.175  1.00 29.79           N  
ATOM    174  CA  HIS A  24      17.511  56.689  22.393  1.00 30.04           C  
ATOM    175  C   HIS A  24      17.002  55.941  23.625  1.00 30.55           C  
ATOM    176  O   HIS A  24      15.792  55.827  23.835  1.00 29.03           O  
ATOM    177  CB  HIS A  24      17.136  58.149  22.506  1.00 29.91           C  
ATOM    178  CG  HIS A  24      17.567  58.971  21.335  1.00 31.71           C  
ATOM    179  ND1 HIS A  24      18.803  59.581  21.271  1.00 34.59           N  
ATOM    180  CD2 HIS A  24      16.942  59.261  20.170  1.00 27.43           C  
ATOM    181  CE1 HIS A  24      18.903  60.241  20.131  1.00 33.48           C  
ATOM    182  NE2 HIS A  24      17.785  60.075  19.449  1.00 28.40           N  
ATOM    183  N   SER A  25      17.925  55.426  24.430  1.00 31.87           N  
ATOM    184  CA  SER A  25      17.552  54.731  25.667  1.00 34.02           C  
ATOM    185  C   SER A  25      17.087  55.713  26.750  1.00 34.22           C  
ATOM    186  O   SER A  25      17.787  56.667  27.097  1.00 34.21           O  
ATOM    187  CB  SER A  25      18.696  53.888  26.244  1.00 34.38           C  
ATOM    188  OG  SER A  25      18.249  53.257  27.445  1.00 38.14           O  
ATOM    189  N   LYS A  26      15.905  55.443  27.285  1.00 35.42           N  
ATOM    190  CA  LYS A  26      15.393  56.180  28.440  1.00 36.49           C  
ATOM    191  C   LYS A  26      16.015  55.686  29.717  1.00 36.90           C  
ATOM    192  O   LYS A  26      16.423  56.499  30.549  1.00 37.13           O  
ATOM    193  CB  LYS A  26      13.880  56.061  28.539  1.00 36.57           C  
ATOM    194  CG  LYS A  26      13.153  57.020  27.624  1.00 37.38           C  
ATOM    195  CD  LYS A  26      11.659  56.913  27.864  1.00 39.50           C  
ATOM    196  CE  LYS A  26      11.230  57.668  29.119  1.00 38.26           C  
ATOM    197  NZ  LYS A  26       9.818  57.336  29.477  1.00 36.11           N  
ATOM    198  N   LYS A  27      16.101  54.363  29.866  1.00 37.57           N  
ATOM    199  CA  LYS A  27      16.712  53.726  31.055  1.00 38.58           C  
ATOM    200  C   LYS A  27      18.174  54.081  31.253  1.00 38.40           C  
ATOM    201  O   LYS A  27      18.597  54.335  32.382  1.00 38.67           O  
ATOM    202  CB  LYS A  27      16.590  52.197  31.001  1.00 38.98           C  
ATOM    203  CG  LYS A  27      15.173  51.671  31.024  1.00 41.95           C  
ATOM    204  CD  LYS A  27      14.750  51.188  32.396  1.00 47.32           C  
ATOM    205  CE  LYS A  27      13.720  50.071  32.266  1.00 48.97           C  
ATOM    206  NZ  LYS A  27      12.332  50.581  31.984  1.00 50.90           N  
ATOM    207  N   TRP A  28      18.945  54.085  30.159  1.00 38.14           N  
ATOM    208  CA  TRP A  28      20.363  54.426  30.182  1.00 37.06           C  
ATOM    209  C   TRP A  28      20.642  55.581  29.209  1.00 37.51           C  
ATOM    210  O   TRP A  28      21.213  55.366  28.149  1.00 37.68           O  
ATOM    211  CB  TRP A  28      21.209  53.195  29.807  1.00 37.35           C  
ATOM    212  CG  TRP A  28      21.356  52.215  30.904  1.00 36.51           C  
ATOM    213  CD1 TRP A  28      20.450  51.253  31.271  1.00 37.35           C  
ATOM    214  CD2 TRP A  28      22.468  52.084  31.800  1.00 36.48           C  
ATOM    215  NE1 TRP A  28      20.933  50.535  32.339  1.00 36.33           N  
ATOM    216  CE2 TRP A  28      22.169  51.019  32.683  1.00 36.39           C  
ATOM    217  CE3 TRP A  28      23.687  52.760  31.944  1.00 35.85           C  
ATOM    218  CZ2 TRP A  28      23.044  50.625  33.716  1.00 36.04           C  
ATOM    219  CZ3 TRP A  28      24.561  52.362  32.963  1.00 37.57           C  
ATOM    220  CH2 TRP A  28      24.237  51.300  33.831  1.00 36.58           C  
ATOM    221  N   PRO A  29      20.227  56.819  29.566  1.00 37.48           N  
ATOM    222  CA  PRO A  29      20.399  57.961  28.666  1.00 37.26           C  
ATOM    223  C   PRO A  29      21.825  58.105  28.164  1.00 36.95           C  
ATOM    224  O   PRO A  29      22.799  57.885  28.915  1.00 36.55           O  
ATOM    225  CB  PRO A  29      19.957  59.163  29.516  1.00 37.72           C  
ATOM    226  CG  PRO A  29      19.896  58.663  30.922  1.00 37.89           C  
ATOM    227  CD  PRO A  29      19.565  57.212  30.820  1.00 37.78           C  
ATOM    228  N   GLY A  30      21.955  58.425  26.891  1.00 37.06           N  
ATOM    229  CA  GLY A  30      23.276  58.471  26.255  1.00 37.26           C  
ATOM    230  C   GLY A  30      23.732  57.166  25.625  1.00 36.93           C  
ATOM    231  O   GLY A  30      24.765  57.129  24.968  1.00 37.77           O  
ATOM    232  N   PHE A  31      22.982  56.083  25.823  1.00 36.61           N  
ATOM    233  CA  PHE A  31      23.276  54.821  25.110  1.00 36.27           C  
ATOM    234  C   PHE A  31      22.126  54.444  24.181  1.00 36.24           C  
ATOM    235  O   PHE A  31      20.968  54.257  24.639  1.00 37.30           O  
ATOM    236  CB  PHE A  31      23.613  53.670  26.054  1.00 35.77           C  
ATOM    237  CG  PHE A  31      24.828  53.909  26.857  1.00 36.42           C  
ATOM    238  CD1 PHE A  31      26.057  53.389  26.449  1.00 36.57           C  
ATOM    239  CD2 PHE A  31      24.769  54.688  28.020  1.00 35.22           C  
ATOM    240  CE1 PHE A  31      27.188  53.633  27.171  1.00 35.30           C  
ATOM    241  CE2 PHE A  31      25.912  54.937  28.761  1.00 35.06           C  
ATOM    242  CZ  PHE A  31      27.123  54.396  28.345  1.00 36.17           C  
ATOM    243  N   PRO A  32      22.417  54.373  22.860  1.00 34.69           N  
ATOM    244  CA  PRO A  32      21.368  53.934  21.940  1.00 33.62           C  
ATOM    245  C   PRO A  32      21.163  52.434  22.134  1.00 33.18           C  
ATOM    246  O   PRO A  32      22.141  51.712  22.346  1.00 31.68           O  
ATOM    247  CB  PRO A  32      21.946  54.235  20.543  1.00 33.17           C  
ATOM    248  CG  PRO A  32      23.309  54.807  20.772  1.00 34.78           C  
ATOM    249  CD  PRO A  32      23.698  54.652  22.187  1.00 34.04           C  
ATOM    250  N   PHE A  33      19.915  51.970  22.082  1.00 32.86           N  
ATOM    251  CA  PHE A  33      19.614  50.539  22.263  1.00 33.16           C  
ATOM    252  C   PHE A  33      19.066  49.947  20.977  1.00 31.44           C  
ATOM    253  O   PHE A  33      18.223  50.560  20.324  1.00 29.21           O  
ATOM    254  CB  PHE A  33      18.571  50.327  23.377  1.00 35.16           C  
ATOM    255  CG  PHE A  33      19.155  50.071  24.754  1.00 37.70           C  
ATOM    256  CD1 PHE A  33      20.065  50.973  25.342  1.00 39.61           C  
ATOM    257  CD2 PHE A  33      18.738  48.965  25.500  1.00 41.88           C  
ATOM    258  CE1 PHE A  33      20.557  50.776  26.615  1.00 40.20           C  
ATOM    259  CE2 PHE A  33      19.244  48.747  26.811  1.00 41.70           C  
ATOM    260  CZ  PHE A  33      20.157  49.654  27.360  1.00 39.85           C  
ATOM    261  N   GLY A  34      19.553  48.763  20.613  1.00 29.31           N  
ATOM    262  CA  GLY A  34      19.025  48.066  19.475  1.00 28.43           C  
ATOM    263  C   GLY A  34      18.036  47.002  19.900  1.00 28.12           C  
ATOM    264  O   GLY A  34      18.177  46.370  20.966  1.00 28.00           O  
ATOM    265  N   SER A  35      17.013  46.821  19.085  1.00 28.69           N  
ATOM    266  CA  SER A  35      16.037  45.737  19.266  1.00 28.93           C  
ATOM    267  C   SER A  35      15.644  45.230  17.891  1.00 29.26           C  
ATOM    268  O   SER A  35      15.685  45.984  16.915  1.00 29.41           O  
ATOM    269  CB  SER A  35      14.813  46.270  20.028  1.00 29.65           C  
ATOM    270  OG  SER A  35      14.262  47.408  19.324  1.00 28.22           O  
ATOM    271  N   VAL A  36      15.269  43.957  17.795  1.00 28.76           N  
ATOM    272  CA  VAL A  36      14.879  43.386  16.508  1.00 30.31           C  
ATOM    273  C   VAL A  36      13.381  43.583  16.338  1.00 30.73           C  
ATOM    274  O   VAL A  36      12.598  43.208  17.237  1.00 31.58           O  
ATOM    275  CB  VAL A  36      15.217  41.874  16.422  1.00 30.44           C  
ATOM    276  CG1 VAL A  36      14.851  41.304  15.055  1.00 31.63           C  
ATOM    277  CG2 VAL A  36      16.705  41.640  16.745  1.00 30.09           C  
ATOM    278  N   VAL A  37      12.987  44.165  15.213  1.00 30.20           N  
ATOM    279  CA  VAL A  37      11.568  44.295  14.872  1.00 31.46           C  
ATOM    280  C   VAL A  37      11.269  43.728  13.486  1.00 31.52           C  
ATOM    281  O   VAL A  37      12.016  44.008  12.538  1.00 31.69           O  
ATOM    282  CB  VAL A  37      11.076  45.774  14.860  1.00 31.19           C  
ATOM    283  CG1 VAL A  37      10.996  46.326  16.270  1.00 31.47           C  
ATOM    284  CG2 VAL A  37      12.018  46.621  14.032  1.00 32.86           C  
ATOM    285  N   PRO A  38      10.164  42.956  13.363  1.00 31.47           N  
ATOM    286  CA  PRO A  38       9.616  42.642  12.042  1.00 31.58           C  
ATOM    287  C   PRO A  38       9.010  43.881  11.393  1.00 31.52           C  
ATOM    288  O   PRO A  38       8.519  44.804  12.080  1.00 31.30           O  
ATOM    289  CB  PRO A  38       8.475  41.649  12.340  1.00 31.84           C  
ATOM    290  CG  PRO A  38       8.662  41.232  13.772  1.00 32.42           C  
ATOM    291  CD  PRO A  38       9.345  42.392  14.449  1.00 30.81           C  
ATOM    292  N   TYR A  39       9.013  43.899  10.065  1.00 31.33           N  
ATOM    293  CA  TYR A  39       8.421  45.006   9.366  1.00 31.11           C  
ATOM    294  C   TYR A  39       7.921  44.603   7.952  1.00 31.01           C  
ATOM    295  O   TYR A  39       8.413  43.643   7.357  1.00 30.47           O  
ATOM    296  CB  TYR A  39       9.443  46.137   9.279  1.00 30.57           C  
ATOM    297  CG  TYR A  39      10.470  45.923   8.182  1.00 30.69           C  
ATOM    298  CD1 TYR A  39      11.655  45.276   8.448  1.00 27.69           C  
ATOM    299  CD2 TYR A  39      10.232  46.367   6.877  1.00 27.51           C  
ATOM    300  CE1 TYR A  39      12.607  45.065   7.471  1.00 29.50           C  
ATOM    301  CE2 TYR A  39      11.179  46.176   5.883  1.00 29.41           C  
ATOM    302  CZ  TYR A  39      12.379  45.537   6.201  1.00 29.52           C  
ATOM    303  OH  TYR A  39      13.342  45.320   5.246  1.00 31.79           O  
ATOM    304  N   CYS A  40       6.930  45.327   7.444  1.00 31.26           N  
ATOM    305  CA  CYS A  40       6.652  45.305   6.011  1.00 31.91           C  
ATOM    306  C   CYS A  40       6.581  46.768   5.542  1.00 31.80           C  
ATOM    307  O   CYS A  40       6.807  47.690   6.330  1.00 31.33           O  
ATOM    308  CB  CYS A  40       5.345  44.538   5.725  1.00 32.48           C  
ATOM    309  SG  CYS A  40       3.866  45.388   6.274  1.00 33.26           S  
ATOM    310  N   LEU A  41       6.263  47.001   4.275  1.00 31.33           N  
ATOM    311  CA  LEU A  41       6.202  48.382   3.786  1.00 31.17           C  
ATOM    312  C   LEU A  41       4.753  48.844   3.594  1.00 31.75           C  
ATOM    313  O   LEU A  41       3.879  48.028   3.283  1.00 31.69           O  
ATOM    314  CB  LEU A  41       7.009  48.565   2.500  1.00 30.66           C  
ATOM    315  CG  LEU A  41       8.511  48.266   2.524  1.00 30.12           C  
ATOM    316  CD1 LEU A  41       9.121  48.611   1.134  1.00 29.68           C  
ATOM    317  CD2 LEU A  41       9.252  48.964   3.669  1.00 29.11           C  
ATOM    318  N   ASP A  42       4.494  50.133   3.813  1.00 31.31           N  
ATOM    319  CA  ASP A  42       3.136  50.682   3.598  1.00 31.68           C  
ATOM    320  C   ASP A  42       2.875  51.111   2.150  1.00 31.98           C  
ATOM    321  O   ASP A  42       3.696  50.846   1.274  1.00 31.79           O  
ATOM    322  CB  ASP A  42       2.800  51.804   4.600  1.00 30.96           C  
ATOM    323  CG  ASP A  42       3.630  53.071   4.399  1.00 30.57           C  
ATOM    324  OD1 ASP A  42       3.540  53.935   5.303  1.00 28.89           O  
ATOM    325  OD2 ASP A  42       4.340  53.242   3.362  1.00 29.00           O  
ATOM    326  N   ALA A  43       1.734  51.757   1.907  1.00 32.68           N  
ATOM    327  CA  ALA A  43       1.343  52.173   0.543  1.00 33.72           C  
ATOM    328  C   ALA A  43       2.361  53.159  -0.076  1.00 34.09           C  
ATOM    329  O   ALA A  43       2.539  53.221  -1.297  1.00 33.65           O  
ATOM    330  CB  ALA A  43      -0.046  52.801   0.578  1.00 33.75           C  
ATOM    331  N   GLU A  44       3.025  53.920   0.786  1.00 33.83           N  
ATOM    332  CA  GLU A  44       4.053  54.863   0.353  1.00 34.14           C  
ATOM    333  C   GLU A  44       5.460  54.232   0.331  1.00 33.00           C  
ATOM    334  O   GLU A  44       6.430  54.881  -0.023  1.00 32.23           O  
ATOM    335  CB  GLU A  44       4.034  56.105   1.246  1.00 35.30           C  
ATOM    336  CG  GLU A  44       2.628  56.581   1.632  1.00 40.24           C  
ATOM    337  CD  GLU A  44       2.155  57.760   0.818  1.00 51.18           C  
ATOM    338  OE1 GLU A  44       1.472  58.644   1.410  1.00 54.75           O  
ATOM    339  OE2 GLU A  44       2.461  57.820  -0.411  1.00 54.49           O  
ATOM    340  N   GLY A  45       5.578  52.949   0.678  1.00 32.33           N  
ATOM    341  CA  GLY A  45       6.873  52.276   0.585  1.00 30.74           C  
ATOM    342  C   GLY A  45       7.747  52.510   1.811  1.00 30.80           C  
ATOM    343  O   GLY A  45       8.963  52.298   1.754  1.00 30.74           O  
ATOM    344  N   ARG A  46       7.132  52.939   2.910  1.00 30.43           N  
ATOM    345  CA  ARG A  46       7.847  53.121   4.203  1.00 31.39           C  
ATOM    346  C   ARG A  46       7.713  51.933   5.147  1.00 31.23           C  
ATOM    347  O   ARG A  46       6.691  51.240   5.108  1.00 31.70           O  
ATOM    348  CB  ARG A  46       7.299  54.330   4.947  1.00 30.71           C  
ATOM    349  CG  ARG A  46       7.250  55.625   4.113  1.00 32.62           C  
ATOM    350  CD  ARG A  46       6.549  56.708   4.942  1.00 32.12           C  
ATOM    351  NE  ARG A  46       5.128  56.388   5.090  1.00 34.12           N  
ATOM    352  CZ  ARG A  46       4.179  57.265   5.377  1.00 34.92           C  
ATOM    353  NH1 ARG A  46       4.482  58.544   5.544  1.00 35.69           N  
ATOM    354  NH2 ARG A  46       2.927  56.858   5.497  1.00 33.51           N  
ATOM    355  N   PRO A  47       8.714  51.723   6.037  1.00 30.58           N  
ATOM    356  CA  PRO A  47       8.556  50.678   7.044  1.00 30.61           C  
ATOM    357  C   PRO A  47       7.415  50.889   8.059  1.00 31.58           C  
ATOM    358  O   PRO A  47       7.290  51.961   8.673  1.00 31.66           O  
ATOM    359  CB  PRO A  47       9.936  50.617   7.738  1.00 30.99           C  
ATOM    360  CG  PRO A  47      10.905  51.265   6.776  1.00 29.62           C  
ATOM    361  CD  PRO A  47      10.053  52.351   6.104  1.00 30.78           C  
ATOM    362  N   LEU A  48       6.611  49.830   8.213  1.00 31.06           N  
ATOM    363  CA  LEU A  48       5.489  49.765   9.136  1.00 30.81           C  
ATOM    364  C   LEU A  48       5.771  48.669  10.158  1.00 30.55           C  
ATOM    365  O   LEU A  48       6.067  47.520   9.798  1.00 29.54           O  
ATOM    366  CB  LEU A  48       4.203  49.414   8.361  1.00 31.95           C  
ATOM    367  CG  LEU A  48       2.882  49.213   9.111  1.00 30.41           C  
ATOM    368  CD1 LEU A  48       2.452  50.562   9.726  1.00 29.33           C  
ATOM    369  CD2 LEU A  48       1.796  48.693   8.116  1.00 30.46           C  
ATOM    370  N   ILE A  49       5.683  49.029  11.425  1.00 29.52           N  
ATOM    371  CA  ILE A  49       5.999  48.105  12.514  1.00 29.94           C  
ATOM    372  C   ILE A  49       4.815  48.066  13.498  1.00 30.13           C  
ATOM    373  O   ILE A  49       3.959  48.933  13.500  1.00 29.61           O  
ATOM    374  CB  ILE A  49       7.374  48.453  13.235  1.00 29.72           C  
ATOM    375  CG1 ILE A  49       7.283  49.818  13.957  1.00 29.68           C  
ATOM    376  CG2 ILE A  49       8.563  48.404  12.243  1.00 28.60           C  
ATOM    377  CD1 ILE A  49       8.468  50.173  14.856  1.00 29.94           C  
ATOM    378  N   LEU A  50       4.771  47.043  14.324  1.00 30.92           N  
ATOM    379  CA  LEU A  50       3.668  46.882  15.260  1.00 30.17           C  
ATOM    380  C   LEU A  50       4.299  46.560  16.597  1.00 30.30           C  
ATOM    381  O   LEU A  50       4.937  45.503  16.773  1.00 29.98           O  
ATOM    382  CB  LEU A  50       2.721  45.766  14.770  1.00 30.55           C  
ATOM    383  CG  LEU A  50       1.629  45.310  15.751  1.00 30.68           C  
ATOM    384  CD1 LEU A  50       0.626  46.431  15.937  1.00 29.36           C  
ATOM    385  CD2 LEU A  50       0.954  44.032  15.278  1.00 30.38           C  
ATOM    386  N   ILE A  51       4.186  47.502  17.527  1.00 29.94           N  
ATOM    387  CA  ILE A  51       4.972  47.422  18.756  1.00 30.36           C  
ATOM    388  C   ILE A  51       4.102  47.588  20.029  1.00 31.02           C  
ATOM    389  O   ILE A  51       3.140  48.350  20.058  1.00 30.55           O  
ATOM    390  CB  ILE A  51       6.202  48.396  18.745  1.00 30.01           C  
ATOM    391  CG1 ILE A  51       5.758  49.848  18.503  1.00 30.26           C  
ATOM    392  CG2 ILE A  51       7.244  47.949  17.693  1.00 30.20           C  
ATOM    393  CD1 ILE A  51       6.920  50.891  18.465  1.00 29.00           C  
ATOM    394  N   SER A  52       4.475  46.864  21.068  1.00 32.42           N  
ATOM    395  CA  SER A  52       3.715  46.791  22.312  1.00 33.12           C  
ATOM    396  C   SER A  52       3.843  48.083  23.109  1.00 33.90           C  
ATOM    397  O   SER A  52       4.937  48.632  23.231  1.00 33.83           O  
ATOM    398  CB  SER A  52       4.253  45.623  23.142  1.00 33.79           C  
ATOM    399  OG  SER A  52       3.701  45.614  24.455  1.00 36.41           O  
ATOM    400  N   ARG A  53       2.736  48.557  23.664  1.00 34.89           N  
ATOM    401  CA  ARG A  53       2.732  49.719  24.551  1.00 36.54           C  
ATOM    402  C   ARG A  53       3.694  49.627  25.742  1.00 36.25           C  
ATOM    403  O   ARG A  53       4.163  50.653  26.233  1.00 37.71           O  
ATOM    404  CB  ARG A  53       1.289  50.041  24.994  1.00 36.74           C  
ATOM    405  CG  ARG A  53       0.598  51.047  24.073  1.00 38.42           C  
ATOM    406  CD  ARG A  53      -0.922  51.132  24.266  1.00 39.20           C  
ATOM    407  NE  ARG A  53      -1.571  50.253  23.299  1.00 45.03           N  
ATOM    408  CZ  ARG A  53      -2.823  50.371  22.861  1.00 48.35           C  
ATOM    409  NH1 ARG A  53      -3.292  49.492  21.973  1.00 49.18           N  
ATOM    410  NH2 ARG A  53      -3.613  51.349  23.308  1.00 49.59           N  
ATOM    411  N   ILE A  54       4.012  48.414  26.187  1.00 36.14           N  
ATOM    412  CA  ILE A  54       4.945  48.182  27.318  1.00 35.71           C  
ATOM    413  C   ILE A  54       6.389  47.855  26.934  1.00 35.13           C  
ATOM    414  O   ILE A  54       7.247  47.750  27.820  1.00 34.80           O  
ATOM    415  CB  ILE A  54       4.505  47.019  28.287  1.00 36.19           C  
ATOM    416  CG1 ILE A  54       4.399  45.688  27.535  1.00 36.47           C  
ATOM    417  CG2 ILE A  54       3.255  47.375  29.076  1.00 36.94           C  
ATOM    418  CD1 ILE A  54       5.181  44.582  28.175  1.00 41.12           C  
ATOM    419  N   ALA A  55       6.650  47.637  25.647  1.00 34.39           N  
ATOM    420  CA  ALA A  55       8.014  47.382  25.193  1.00 34.12           C  
ATOM    421  C   ALA A  55       8.865  48.627  25.413  1.00 34.03           C  
ATOM    422  O   ALA A  55       8.388  49.767  25.230  1.00 33.88           O  
ATOM    423  CB  ALA A  55       8.039  46.960  23.724  1.00 32.98           C  
ATOM    424  N   GLN A  56      10.117  48.415  25.790  1.00 33.22           N  
ATOM    425  CA  GLN A  56      11.051  49.517  25.980  1.00 33.89           C  
ATOM    426  C   GLN A  56      11.269  50.411  24.745  1.00 33.33           C  
ATOM    427  O   GLN A  56      11.356  51.656  24.878  1.00 32.26           O  
ATOM    428  CB  GLN A  56      12.407  48.995  26.462  1.00 34.47           C  
ATOM    429  CG  GLN A  56      13.351  50.096  26.930  1.00 38.75           C  
ATOM    430  CD  GLN A  56      12.804  50.906  28.125  1.00 45.19           C  
ATOM    431  OE1 GLN A  56      12.201  50.336  29.074  1.00 48.46           O  
ATOM    432  NE2 GLN A  56      13.014  52.240  28.091  1.00 44.93           N  
ATOM    433  N   HIS A  57      11.390  49.800  23.558  1.00 32.17           N  
ATOM    434  CA  HIS A  57      11.615  50.619  22.369  1.00 31.60           C  
ATOM    435  C   HIS A  57      10.421  51.541  22.101  1.00 30.90           C  
ATOM    436  O   HIS A  57      10.602  52.616  21.546  1.00 30.43           O  
ATOM    437  CB  HIS A  57      12.020  49.833  21.103  1.00 30.54           C  
ATOM    438  CG  HIS A  57      11.130  48.681  20.760  1.00 33.56           C  
ATOM    439  ND1 HIS A  57      11.604  47.552  20.120  1.00 33.17           N  
ATOM    440  CD2 HIS A  57       9.804  48.474  20.958  1.00 32.19           C  
ATOM    441  CE1 HIS A  57      10.608  46.706  19.938  1.00 34.89           C  
ATOM    442  NE2 HIS A  57       9.507  47.240  20.441  1.00 33.64           N  
ATOM    443  N   THR A  58       9.228  51.126  22.536  1.00 30.06           N  
ATOM    444  CA  THR A  58       8.024  51.963  22.421  1.00 30.05           C  
ATOM    445  C   THR A  58       8.085  53.190  23.333  1.00 30.37           C  
ATOM    446  O   THR A  58       7.801  54.319  22.895  1.00 31.29           O  
ATOM    447  CB  THR A  58       6.733  51.150  22.636  1.00 29.53           C  
ATOM    448  OG1 THR A  58       6.746  50.027  21.758  1.00 28.08           O  
ATOM    449  CG2 THR A  58       5.476  51.982  22.308  1.00 29.16           C  
ATOM    450  N   HIS A  59       8.437  52.973  24.596  1.00 30.65           N  
ATOM    451  CA  HIS A  59       8.675  54.092  25.541  1.00 31.04           C  
ATOM    452  C   HIS A  59       9.800  54.999  25.040  1.00 30.47           C  
ATOM    453  O   HIS A  59       9.737  56.223  25.197  1.00 30.18           O  
ATOM    454  CB  HIS A  59       9.045  53.571  26.924  1.00 31.40           C  
ATOM    455  CG  HIS A  59       7.956  52.769  27.576  1.00 34.61           C  
ATOM    456  ND1 HIS A  59       8.218  51.734  28.449  1.00 39.32           N  
ATOM    457  CD2 HIS A  59       6.608  52.850  27.478  1.00 36.29           C  
ATOM    458  CE1 HIS A  59       7.073  51.219  28.867  1.00 41.55           C  
ATOM    459  NE2 HIS A  59       6.082  51.879  28.292  1.00 41.70           N  
ATOM    460  N   ASN A  60      10.835  54.395  24.456  1.00 29.08           N  
ATOM    461  CA  ASN A  60      11.930  55.190  23.853  1.00 28.93           C  
ATOM    462  C   ASN A  60      11.484  56.096  22.703  1.00 28.74           C  
ATOM    463  O   ASN A  60      11.794  57.300  22.676  1.00 29.82           O  
ATOM    464  CB  ASN A  60      13.045  54.268  23.405  1.00 28.97           C  
ATOM    465  CG  ASN A  60      13.808  53.688  24.569  1.00 29.24           C  
ATOM    466  OD1 ASN A  60      13.540  54.015  25.726  1.00 30.53           O  
ATOM    467  ND2 ASN A  60      14.758  52.808  24.275  1.00 28.75           N  
ATOM    468  N   LEU A  61      10.721  55.536  21.773  1.00 27.48           N  
ATOM    469  CA  LEU A  61      10.167  56.322  20.656  1.00 26.95           C  
ATOM    470  C   LEU A  61       9.149  57.371  21.087  1.00 27.17           C  
ATOM    471  O   LEU A  61       9.050  58.440  20.456  1.00 25.54           O  
ATOM    472  CB  LEU A  61       9.534  55.414  19.629  1.00 26.36           C  
ATOM    473  CG  LEU A  61      10.485  54.533  18.809  1.00 27.32           C  
ATOM    474  CD1 LEU A  61       9.669  53.538  17.946  1.00 25.22           C  
ATOM    475  CD2 LEU A  61      11.433  55.398  17.956  1.00 24.78           C  
ATOM    476  N   GLN A  62       8.370  57.051  22.132  1.00 27.55           N  
ATOM    477  CA  GLN A  62       7.459  58.039  22.753  1.00 28.86           C  
ATOM    478  C   GLN A  62       8.210  59.260  23.313  1.00 28.41           C  
ATOM    479  O   GLN A  62       7.787  60.401  23.136  1.00 29.23           O  
ATOM    480  CB  GLN A  62       6.563  57.378  23.822  1.00 29.15           C  
ATOM    481  CG  GLN A  62       5.482  56.506  23.195  1.00 30.65           C  
ATOM    482  CD  GLN A  62       4.722  55.646  24.177  1.00 32.99           C  
ATOM    483  OE1 GLN A  62       3.600  55.211  23.881  1.00 41.56           O  
ATOM    484  NE2 GLN A  62       5.309  55.376  25.332  1.00 34.81           N  
ATOM    485  N   ALA A  63       9.342  59.026  23.958  1.00 27.87           N  
ATOM    486  CA  ALA A  63      10.131  60.118  24.512  1.00 27.86           C  
ATOM    487  C   ALA A  63      10.969  60.829  23.429  1.00 27.42           C  
ATOM    488  O   ALA A  63      11.211  62.035  23.529  1.00 26.51           O  
ATOM    489  CB  ALA A  63      11.023  59.617  25.638  1.00 28.19           C  
ATOM    490  N   ASP A  64      11.405  60.091  22.406  1.00 26.58           N  
ATOM    491  CA  ASP A  64      12.122  60.702  21.259  1.00 27.60           C  
ATOM    492  C   ASP A  64      11.929  59.831  20.004  1.00 27.62           C  
ATOM    493  O   ASP A  64      12.480  58.712  19.966  1.00 28.36           O  
ATOM    494  CB  ASP A  64      13.622  60.819  21.609  1.00 28.23           C  
ATOM    495  CG  ASP A  64      14.425  61.648  20.592  1.00 27.75           C  
ATOM    496  OD1 ASP A  64      14.004  61.806  19.444  1.00 27.26           O  
ATOM    497  OD2 ASP A  64      15.494  62.151  20.964  1.00 25.38           O  
ATOM    498  N   PRO A  65      11.164  60.320  18.981  1.00 27.83           N  
ATOM    499  CA  PRO A  65      10.846  59.454  17.833  1.00 27.32           C  
ATOM    500  C   PRO A  65      11.988  59.284  16.824  1.00 26.73           C  
ATOM    501  O   PRO A  65      11.833  58.545  15.862  1.00 25.72           O  
ATOM    502  CB  PRO A  65       9.626  60.140  17.184  1.00 28.38           C  
ATOM    503  CG  PRO A  65       9.806  61.638  17.502  1.00 27.62           C  
ATOM    504  CD  PRO A  65      10.522  61.658  18.865  1.00 27.89           C  
ATOM    505  N   ARG A  66      13.129  59.937  17.060  1.00 26.13           N  
ATOM    506  CA  ARG A  66      14.236  59.863  16.106  1.00 25.76           C  
ATOM    507  C   ARG A  66      14.988  58.543  16.327  1.00 25.01           C  
ATOM    508  O   ARG A  66      15.387  58.229  17.454  1.00 25.66           O  
ATOM    509  CB  ARG A  66      15.151  61.064  16.250  1.00 25.77           C  
ATOM    510  CG  ARG A  66      14.423  62.406  15.915  1.00 24.47           C  
ATOM    511  CD  ARG A  66      15.247  63.608  16.274  1.00 26.08           C  
ATOM    512  NE  ARG A  66      15.623  63.608  17.694  1.00 26.81           N  
ATOM    513  CZ  ARG A  66      16.449  64.471  18.273  1.00 25.65           C  
ATOM    514  NH1 ARG A  66      16.999  65.491  17.590  1.00 23.81           N  
ATOM    515  NH2 ARG A  66      16.732  64.298  19.550  1.00 21.75           N  
ATOM    516  N   CYS A  67      15.183  57.784  15.254  1.00 24.62           N  
ATOM    517  CA  CYS A  67      15.650  56.422  15.379  1.00 23.78           C  
ATOM    518  C   CYS A  67      16.388  55.986  14.143  1.00 24.32           C  
ATOM    519  O   CYS A  67      16.444  56.702  13.125  1.00 23.88           O  
ATOM    520  CB  CYS A  67      14.477  55.484  15.668  1.00 23.56           C  
ATOM    521  SG  CYS A  67      13.236  55.321  14.351  1.00 26.59           S  
ATOM    522  N   SER A  68      16.981  54.803  14.245  1.00 24.34           N  
ATOM    523  CA  SER A  68      17.714  54.197  13.139  1.00 25.94           C  
ATOM    524  C   SER A  68      17.091  52.855  12.877  1.00 26.05           C  
ATOM    525  O   SER A  68      16.696  52.187  13.830  1.00 26.79           O  
ATOM    526  CB  SER A  68      19.185  54.006  13.575  1.00 26.07           C  
ATOM    527  OG  SER A  68      19.840  53.145  12.672  1.00 28.85           O  
ATOM    528  N   MET A  69      17.011  52.443  11.611  1.00 25.50           N  
ATOM    529  CA  MET A  69      16.616  51.081  11.288  1.00 27.45           C  
ATOM    530  C   MET A  69      17.683  50.472  10.370  1.00 27.56           C  
ATOM    531  O   MET A  69      17.999  51.027   9.314  1.00 27.77           O  
ATOM    532  CB  MET A  69      15.232  51.042  10.596  1.00 26.17           C  
ATOM    533  CG  MET A  69      14.743  49.613  10.269  1.00 30.61           C  
ATOM    534  SD  MET A  69      13.003  49.377   9.676  1.00 29.77           S  
ATOM    535  CE  MET A  69      13.297  49.116   7.940  1.00 32.80           C  
ATOM    536  N   LEU A  70      18.240  49.341  10.780  1.00 28.81           N  
ATOM    537  CA  LEU A  70      19.310  48.687   9.996  1.00 29.43           C  
ATOM    538  C   LEU A  70      18.809  47.403   9.370  1.00 29.46           C  
ATOM    539  O   LEU A  70      18.264  46.537  10.079  1.00 27.90           O  
ATOM    540  CB  LEU A  70      20.536  48.376  10.869  1.00 29.04           C  
ATOM    541  CG  LEU A  70      21.587  47.479  10.174  1.00 32.74           C  
ATOM    542  CD1 LEU A  70      22.419  48.267   9.184  1.00 31.32           C  
ATOM    543  CD2 LEU A  70      22.468  46.858  11.212  1.00 34.98           C  
ATOM    544  N   VAL A  71      18.970  47.304   8.048  1.00 30.63           N  
ATOM    545  CA  VAL A  71      18.638  46.089   7.321  1.00 33.05           C  
ATOM    546  C   VAL A  71      19.855  45.585   6.533  1.00 34.11           C  
ATOM    547  O   VAL A  71      20.663  46.371   6.011  1.00 32.53           O  
ATOM    548  CB  VAL A  71      17.344  46.232   6.442  1.00 33.66           C  
ATOM    549  CG1 VAL A  71      16.329  47.126   7.118  1.00 35.22           C  
ATOM    550  CG2 VAL A  71      17.614  46.759   5.070  1.00 33.07           C  
ATOM    551  N   GLY A  72      20.007  44.270   6.485  1.00 36.30           N  
ATOM    552  CA  GLY A  72      21.138  43.683   5.806  1.00 40.04           C  
ATOM    553  C   GLY A  72      20.854  42.262   5.414  1.00 43.69           C  
ATOM    554  O   GLY A  72      20.100  41.556   6.086  1.00 44.21           O  
ATOM    555  N   GLU A  73      21.488  41.851   4.327  1.00 46.63           N  
ATOM    556  CA  GLU A  73      21.285  40.532   3.736  1.00 49.93           C  
ATOM    557  C   GLU A  73      21.337  39.420   4.788  1.00 50.95           C  
ATOM    558  O   GLU A  73      22.250  39.377   5.640  1.00 51.02           O  
ATOM    559  CB  GLU A  73      22.269  40.341   2.573  1.00 50.36           C  
ATOM    560  CG  GLU A  73      22.496  41.660   1.773  1.00 51.92           C  
ATOM    561  CD  GLU A  73      22.566  41.460   0.254  1.00 55.30           C  
ATOM    562  OE1 GLU A  73      23.481  42.031  -0.413  1.00 55.13           O  
ATOM    563  OE2 GLU A  73      21.693  40.731  -0.267  1.00 56.68           O  
ATOM    564  N   ARG A  74      20.356  38.521   4.712  0.50 51.62           N  
ATOM    566  CA  ARG A  74      20.128  37.497   5.741  0.50 52.50           C  
ATOM    568  C   ARG A  74      21.156  36.363   5.745  0.50 52.72           C  
ATOM    570  O   ARG A  74      21.507  35.832   4.685  0.50 53.59           O  
ATOM    572  CB  ARG A  74      18.723  36.903   5.580  0.50 52.27           C  
ATOM    574  CG  ARG A  74      17.967  36.726   6.888  0.50 52.09           C  
ATOM    576  CD  ARG A  74      17.825  38.067   7.607  0.50 50.02           C  
ATOM    578  NE  ARG A  74      16.593  38.250   8.381  0.50 49.11           N  
ATOM    580  CZ  ARG A  74      15.685  37.321   8.665  0.50 47.54           C  
ATOM    582  NH1 ARG A  74      14.637  37.662   9.381  0.50 47.66           N  
ATOM    584  NH2 ARG A  74      15.812  36.065   8.256  0.50 48.77           N  
ATOM    586  N   GLY A  75      21.620  35.994   6.940  1.00 52.97           N  
ATOM    587  CA  GLY A  75      22.572  34.875   7.134  1.00 52.61           C  
ATOM    588  C   GLY A  75      23.949  35.039   6.507  1.00 52.17           C  
ATOM    589  O   GLY A  75      24.630  34.044   6.205  1.00 52.14           O  
ATOM    590  N   ALA A  76      24.352  36.288   6.288  1.00 51.05           N  
ATOM    591  CA  ALA A  76      25.620  36.567   5.641  1.00 50.23           C  
ATOM    592  C   ALA A  76      26.725  36.206   6.609  1.00 49.79           C  
ATOM    593  O   ALA A  76      26.726  36.660   7.759  1.00 50.24           O  
ATOM    594  CB  ALA A  76      25.708  38.027   5.235  1.00 50.04           C  
ATOM    595  N   GLU A  77      27.652  35.372   6.154  1.00 48.69           N  
ATOM    596  CA  GLU A  77      28.809  35.011   6.979  1.00 47.99           C  
ATOM    597  C   GLU A  77      29.944  36.034   6.936  1.00 46.98           C  
ATOM    598  O   GLU A  77      30.633  36.238   7.931  1.00 46.01           O  
ATOM    599  CB  GLU A  77      29.304  33.617   6.636  1.00 48.25           C  
ATOM    600  CG  GLU A  77      28.428  32.538   7.257  1.00 49.87           C  
ATOM    601  CD  GLU A  77      28.967  31.153   7.015  1.00 50.29           C  
ATOM    602  OE1 GLU A  77      29.163  30.813   5.834  1.00 51.07           O  
ATOM    603  OE2 GLU A  77      29.175  30.405   7.997  1.00 50.32           O  
ATOM    604  N   ASP A  78      30.133  36.660   5.774  1.00 45.66           N  
ATOM    605  CA  ASP A  78      30.965  37.840   5.664  1.00 44.29           C  
ATOM    606  C   ASP A  78      30.022  39.041   5.533  1.00 44.22           C  
ATOM    607  O   ASP A  78      29.535  39.375   4.438  1.00 43.51           O  
ATOM    608  CB  ASP A  78      31.908  37.737   4.478  1.00 44.03           C  
ATOM    609  CG  ASP A  78      32.921  38.867   4.438  1.00 44.77           C  
ATOM    610  OD1 ASP A  78      32.853  39.819   5.272  1.00 42.46           O  
ATOM    611  OD2 ASP A  78      33.778  38.810   3.533  1.00 44.67           O  
ATOM    612  N   ILE A  79      29.768  39.661   6.684  1.00 43.93           N  
ATOM    613  CA  ILE A  79      28.713  40.661   6.849  1.00 44.20           C  
ATOM    614  C   ILE A  79      29.033  41.960   6.156  1.00 44.25           C  
ATOM    615  O   ILE A  79      28.132  42.777   5.906  1.00 44.33           O  
ATOM    616  CB  ILE A  79      28.376  40.921   8.334  1.00 44.25           C  
ATOM    617  CG1 ILE A  79      29.656  41.208   9.151  1.00 44.03           C  
ATOM    618  CG2 ILE A  79      27.497  39.750   8.885  1.00 44.35           C  
ATOM    619  CD1 ILE A  79      29.413  41.531  10.612  1.00 44.35           C  
ATOM    620  N   GLN A  80      30.316  42.145   5.849  1.00 44.42           N  
ATOM    621  CA  GLN A  80      30.760  43.341   5.138  1.00 44.59           C  
ATOM    622  C   GLN A  80      30.959  43.090   3.648  1.00 43.89           C  
ATOM    623  O   GLN A  80      31.494  43.950   2.946  1.00 44.54           O  
ATOM    624  CB  GLN A  80      32.010  43.935   5.790  1.00 44.83           C  
ATOM    625  CG  GLN A  80      31.742  44.531   7.167  1.00 46.75           C  
ATOM    626  CD  GLN A  80      33.010  44.980   7.850  1.00 47.84           C  
ATOM    627  OE1 GLN A  80      34.050  44.359   7.672  1.00 51.51           O  
ATOM    628  NE2 GLN A  80      32.933  46.052   8.646  1.00 48.26           N  
ATOM    629  N   ALA A  81      30.487  41.934   3.176  1.00 42.72           N  
ATOM    630  CA  ALA A  81      30.536  41.545   1.759  1.00 41.94           C  
ATOM    631  C   ALA A  81      29.156  41.574   1.114  1.00 41.29           C  
ATOM    632  O   ALA A  81      28.974  41.069  -0.011  1.00 41.01           O  
ATOM    633  CB  ALA A  81      31.154  40.157   1.597  1.00 41.93           C  
ATOM    634  N   VAL A  82      28.177  42.130   1.845  1.00 39.58           N  
ATOM    635  CA  VAL A  82      26.792  42.231   1.360  1.00 38.50           C  
ATOM    636  C   VAL A  82      26.372  43.696   1.478  1.00 36.97           C  
ATOM    637  O   VAL A  82      27.047  44.482   2.139  1.00 37.26           O  
ATOM    638  CB  VAL A  82      25.791  41.337   2.174  1.00 38.50           C  
ATOM    639  CG1 VAL A  82      26.071  39.865   1.989  1.00 40.11           C  
ATOM    640  CG2 VAL A  82      25.785  41.736   3.671  1.00 37.98           C  
ATOM    641  N   GLY A  83      25.285  44.086   0.818  1.00 35.97           N  
ATOM    642  CA  GLY A  83      24.773  45.440   1.026  1.00 34.14           C  
ATOM    643  C   GLY A  83      24.157  45.555   2.420  1.00 32.24           C  
ATOM    644  O   GLY A  83      23.649  44.568   2.974  1.00 30.80           O  
ATOM    645  N   ARG A  84      24.234  46.749   2.998  1.00 31.09           N  
ATOM    646  CA  ARG A  84      23.491  47.074   4.230  1.00 30.11           C  
ATOM    647  C   ARG A  84      22.884  48.438   4.024  1.00 29.78           C  
ATOM    648  O   ARG A  84      23.478  49.308   3.319  1.00 29.54           O  
ATOM    649  CB  ARG A  84      24.403  47.108   5.484  1.00 30.12           C  
ATOM    650  CG  ARG A  84      24.967  45.726   5.923  1.00 30.52           C  
ATOM    651  CD  ARG A  84      26.287  45.429   5.252  1.00 32.91           C  
ATOM    652  NE  ARG A  84      27.364  46.239   5.836  1.00 34.17           N  
ATOM    653  CZ  ARG A  84      28.528  46.470   5.245  1.00 35.45           C  
ATOM    654  NH1 ARG A  84      28.757  45.990   4.024  1.00 35.00           N  
ATOM    655  NH2 ARG A  84      29.447  47.198   5.875  1.00 35.77           N  
ATOM    656  N   LEU A  85      21.748  48.650   4.687  1.00 27.82           N  
ATOM    657  CA  LEU A  85      21.037  49.912   4.618  1.00 27.16           C  
ATOM    658  C   LEU A  85      20.693  50.360   6.035  1.00 26.76           C  
ATOM    659  O   LEU A  85      20.080  49.592   6.802  1.00 26.50           O  
ATOM    660  CB  LEU A  85      19.739  49.713   3.823  1.00 26.32           C  
ATOM    661  CG  LEU A  85      18.853  50.936   3.627  1.00 27.68           C  
ATOM    662  CD1 LEU A  85      19.644  51.988   2.793  1.00 24.08           C  
ATOM    663  CD2 LEU A  85      17.591  50.514   2.928  1.00 24.43           C  
ATOM    664  N   THR A  86      21.122  51.577   6.367  1.00 26.64           N  
ATOM    665  CA  THR A  86      20.689  52.258   7.573  1.00 26.76           C  
ATOM    666  C   THR A  86      19.742  53.378   7.200  1.00 26.94           C  
ATOM    667  O   THR A  86      20.100  54.293   6.444  1.00 26.59           O  
ATOM    668  CB  THR A  86      21.862  52.817   8.382  1.00 27.23           C  
ATOM    669  OG1 THR A  86      22.785  51.751   8.657  1.00 28.44           O  
ATOM    670  CG2 THR A  86      21.357  53.452   9.716  1.00 25.76           C  
ATOM    671  N   LEU A  87      18.532  53.273   7.737  1.00 26.82           N  
ATOM    672  CA  LEU A  87      17.518  54.317   7.617  1.00 26.31           C  
ATOM    673  C   LEU A  87      17.523  55.157   8.879  1.00 26.41           C  
ATOM    674  O   LEU A  87      17.359  54.608   9.968  1.00 24.91           O  
ATOM    675  CB  LEU A  87      16.138  53.684   7.456  1.00 26.08           C  
ATOM    676  CG  LEU A  87      14.896  54.575   7.617  1.00 27.47           C  
ATOM    677  CD1 LEU A  87      14.897  55.674   6.539  1.00 27.77           C  
ATOM    678  CD2 LEU A  87      13.619  53.715   7.561  1.00 25.89           C  
ATOM    679  N   LEU A  88      17.670  56.475   8.719  1.00 25.20           N  
ATOM    680  CA  LEU A  88      17.420  57.441   9.818  1.00 26.08           C  
ATOM    681  C   LEU A  88      16.002  57.909   9.633  1.00 26.06           C  
ATOM    682  O   LEU A  88      15.631  58.298   8.511  1.00 24.86           O  
ATOM    683  CB  LEU A  88      18.365  58.656   9.723  1.00 26.06           C  
ATOM    684  CG  LEU A  88      19.848  58.316   9.783  1.00 28.57           C  
ATOM    685  CD1 LEU A  88      20.701  59.584   9.996  1.00 25.75           C  
ATOM    686  CD2 LEU A  88      20.169  57.243  10.895  1.00 27.07           C  
ATOM    687  N   ALA A  89      15.198  57.854  10.701  1.00 25.62           N  
ATOM    688  CA  ALA A  89      13.747  58.061  10.560  1.00 25.97           C  
ATOM    689  C   ALA A  89      13.168  58.692  11.816  1.00 27.02           C  
ATOM    690  O   ALA A  89      13.839  58.741  12.862  1.00 25.51           O  
ATOM    691  CB  ALA A  89      13.026  56.705  10.280  1.00 24.51           C  
ATOM    692  N   GLU A  90      11.938  59.211  11.686  1.00 28.62           N  
ATOM    693  CA  GLU A  90      11.125  59.649  12.827  1.00 30.28           C  
ATOM    694  C   GLU A  90       9.940  58.705  12.960  1.00 29.20           C  
ATOM    695  O   GLU A  90       9.124  58.651  12.070  1.00 28.77           O  
ATOM    696  CB  GLU A  90      10.562  61.045  12.539  1.00 31.39           C  
ATOM    697  CG  GLU A  90      11.592  62.176  12.427  1.00 35.25           C  
ATOM    698  CD  GLU A  90      11.527  63.103  13.609  1.00 37.78           C  
ATOM    699  OE1 GLU A  90      10.634  62.925  14.461  1.00 42.10           O  
ATOM    700  OE2 GLU A  90      12.363  64.009  13.695  1.00 36.31           O  
ATOM    701  N   ALA A  91       9.813  57.983  14.064  1.00 29.62           N  
ATOM    702  CA  ALA A  91       8.703  57.057  14.178  1.00 30.12           C  
ATOM    703  C   ALA A  91       7.423  57.820  14.545  1.00 30.19           C  
ATOM    704  O   ALA A  91       7.468  58.767  15.317  1.00 30.71           O  
ATOM    705  CB  ALA A  91       8.997  55.953  15.167  1.00 28.99           C  
ATOM    706  N   ARG A  92       6.303  57.459  13.922  1.00 30.40           N  
ATOM    707  CA  ARG A  92       5.023  58.119  14.206  1.00 30.11           C  
ATOM    708  C   ARG A  92       3.981  57.038  14.395  1.00 29.81           C  
ATOM    709  O   ARG A  92       3.820  56.189  13.516  1.00 28.74           O  
ATOM    710  CB  ARG A  92       4.621  59.037  13.030  1.00 29.60           C  
ATOM    711  CG  ARG A  92       3.287  59.767  13.248  1.00 32.39           C  
ATOM    712  CD  ARG A  92       2.876  60.687  12.079  1.00 32.37           C  
ATOM    713  NE  ARG A  92       2.582  59.997  10.817  1.00 31.48           N  
ATOM    714  CZ  ARG A  92       1.459  59.316  10.573  1.00 34.36           C  
ATOM    715  NH1 ARG A  92       0.529  59.179  11.515  1.00 33.48           N  
ATOM    716  NH2 ARG A  92       1.265  58.760   9.388  1.00 33.28           N  
ATOM    717  N   GLN A  93       3.271  57.070  15.529  1.00 30.05           N  
ATOM    718  CA  GLN A  93       2.157  56.161  15.754  1.00 31.17           C  
ATOM    719  C   GLN A  93       1.001  56.591  14.849  1.00 31.24           C  
ATOM    720  O   GLN A  93       0.684  57.790  14.774  1.00 30.21           O  
ATOM    721  CB  GLN A  93       1.713  56.175  17.224  1.00 31.69           C  
ATOM    722  CG  GLN A  93       0.753  55.025  17.600  1.00 32.11           C  
ATOM    723  CD  GLN A  93       0.284  55.075  19.061  1.00 34.11           C  
ATOM    724  OE1 GLN A  93       1.069  55.336  19.977  1.00 37.72           O  
ATOM    725  NE2 GLN A  93      -0.990  54.779  19.276  1.00 36.67           N  
ATOM    726  N   LEU A  94       0.420  55.623  14.141  1.00 31.18           N  
ATOM    727  CA  LEU A  94      -0.646  55.876  13.164  1.00 32.41           C  
ATOM    728  C   LEU A  94      -1.896  56.341  13.883  1.00 32.78           C  
ATOM    729  O   LEU A  94      -2.210  55.844  14.976  1.00 32.41           O  
ATOM    730  CB  LEU A  94      -0.976  54.609  12.355  1.00 32.58           C  
ATOM    731  CG  LEU A  94       0.100  53.951  11.467  1.00 34.48           C  
ATOM    732  CD1 LEU A  94      -0.546  52.963  10.561  1.00 33.10           C  
ATOM    733  CD2 LEU A  94       0.849  54.987  10.644  1.00 36.09           C  
ATOM    734  N   ALA A  95      -2.606  57.288  13.269  1.00 33.13           N  
ATOM    735  CA  ALA A  95      -3.899  57.735  13.774  1.00 33.53           C  
ATOM    736  C   ALA A  95      -4.940  56.624  13.604  1.00 33.99           C  
ATOM    737  O   ALA A  95      -4.772  55.743  12.769  1.00 33.35           O  
ATOM    738  CB  ALA A  95      -4.325  58.985  13.017  1.00 33.83           C  
ATOM    739  N   GLU A  96      -6.029  56.697  14.364  1.00 35.09           N  
ATOM    740  CA  GLU A  96      -7.130  55.736  14.248  1.00 36.40           C  
ATOM    741  C   GLU A  96      -7.623  55.509  12.803  1.00 35.71           C  
ATOM    742  O   GLU A  96      -7.962  54.389  12.431  1.00 35.24           O  
ATOM    743  CB  GLU A  96      -8.289  56.117  15.185  1.00 36.53           C  
ATOM    744  CG  GLU A  96      -9.131  57.303  14.735  1.00 39.30           C  
ATOM    745  CD  GLU A  96     -10.366  57.523  15.615  1.00 39.99           C  
ATOM    746  OE1 GLU A  96     -10.217  58.105  16.716  1.00 45.23           O  
ATOM    747  OE2 GLU A  96     -11.482  57.140  15.196  1.00 43.10           O  
ATOM    748  N   GLU A  97      -7.645  56.577  11.999  1.00 35.46           N  
ATOM    749  CA  GLU A  97      -8.092  56.499  10.612  1.00 35.34           C  
ATOM    750  C   GLU A  97      -7.158  55.699   9.731  1.00 35.29           C  
ATOM    751  O   GLU A  97      -7.596  55.162   8.714  1.00 35.08           O  
ATOM    752  CB  GLU A  97      -8.298  57.897   9.997  1.00 35.65           C  
ATOM    753  CG  GLU A  97      -9.487  58.673  10.579  1.00 35.65           C  
ATOM    754  CD  GLU A  97      -9.121  59.515  11.807  1.00 36.15           C  
ATOM    755  OE1 GLU A  97      -7.927  59.580  12.178  1.00 32.72           O  
ATOM    756  OE2 GLU A  97     -10.040  60.118  12.402  1.00 39.35           O  
ATOM    757  N   GLU A  98      -5.881  55.594  10.122  1.00 35.02           N  
ATOM    758  CA  GLU A  98      -4.884  54.851   9.334  1.00 35.01           C  
ATOM    759  C   GLU A  98      -4.745  53.351   9.708  1.00 35.02           C  
ATOM    760  O   GLU A  98      -4.164  52.560   8.941  1.00 34.16           O  
ATOM    761  CB  GLU A  98      -3.512  55.516   9.459  1.00 34.89           C  
ATOM    762  CG  GLU A  98      -3.407  56.992   9.028  1.00 34.50           C  
ATOM    763  CD  GLU A  98      -2.106  57.605   9.534  1.00 35.52           C  
ATOM    764  OE1 GLU A  98      -1.985  57.921  10.747  1.00 33.29           O  
ATOM    765  OE2 GLU A  98      -1.187  57.766   8.710  1.00 36.50           O  
ATOM    766  N   VAL A  99      -5.291  52.976  10.866  1.00 34.91           N  
ATOM    767  CA  VAL A  99      -5.040  51.657  11.466  1.00 35.42           C  
ATOM    768  C   VAL A  99      -5.567  50.480  10.648  1.00 35.21           C  
ATOM    769  O   VAL A  99      -4.875  49.444  10.522  1.00 34.58           O  
ATOM    770  CB  VAL A  99      -5.575  51.548  12.912  1.00 35.28           C  
ATOM    771  CG1 VAL A  99      -5.528  50.081  13.381  1.00 37.03           C  
ATOM    772  CG2 VAL A  99      -4.750  52.445  13.862  1.00 36.29           C  
ATOM    773  N   ALA A 100      -6.771  50.638  10.086  1.00 34.23           N  
ATOM    774  CA  ALA A 100      -7.417  49.543   9.351  1.00 34.21           C  
ATOM    775  C   ALA A 100      -6.616  49.093   8.125  1.00 34.04           C  
ATOM    776  O   ALA A 100      -6.376  47.900   7.954  1.00 33.85           O  
ATOM    777  CB  ALA A 100      -8.859  49.887   8.986  1.00 34.27           C  
ATOM    778  N   ALA A 101      -6.178  50.047   7.297  1.00 33.80           N  
ATOM    779  CA  ALA A 101      -5.330  49.721   6.143  1.00 33.77           C  
ATOM    780  C   ALA A 101      -3.965  49.147   6.561  1.00 33.77           C  
ATOM    781  O   ALA A 101      -3.421  48.284   5.870  1.00 34.25           O  
ATOM    782  CB  ALA A 101      -5.149  50.929   5.265  1.00 34.12           C  
ATOM    783  N   ALA A 102      -3.426  49.610   7.692  1.00 33.20           N  
ATOM    784  CA  ALA A 102      -2.131  49.118   8.198  1.00 33.24           C  
ATOM    785  C   ALA A 102      -2.256  47.656   8.621  1.00 33.66           C  
ATOM    786  O   ALA A 102      -1.469  46.813   8.172  1.00 33.75           O  
ATOM    787  CB  ALA A 102      -1.677  49.926   9.348  1.00 31.68           C  
ATOM    788  N   ALA A 103      -3.254  47.375   9.469  1.00 33.57           N  
ATOM    789  CA  ALA A 103      -3.568  46.020   9.933  1.00 33.59           C  
ATOM    790  C   ALA A 103      -3.807  45.056   8.776  1.00 33.80           C  
ATOM    791  O   ALA A 103      -3.232  43.977   8.732  1.00 34.04           O  
ATOM    792  CB  ALA A 103      -4.776  46.050  10.869  1.00 33.78           C  
ATOM    793  N   GLU A 104      -4.655  45.448   7.831  1.00 34.87           N  
ATOM    794  CA  GLU A 104      -4.951  44.580   6.698  1.00 35.45           C  
ATOM    795  C   GLU A 104      -3.689  44.126   5.921  1.00 34.79           C  
ATOM    796  O   GLU A 104      -3.594  42.963   5.527  1.00 34.35           O  
ATOM    797  CB  GLU A 104      -6.016  45.218   5.786  1.00 35.64           C  
ATOM    798  CG  GLU A 104      -6.582  44.290   4.735  1.00 38.82           C  
ATOM    799  CD  GLU A 104      -5.594  44.045   3.601  1.00 42.89           C  
ATOM    800  OE1 GLU A 104      -5.516  42.901   3.097  1.00 45.89           O  
ATOM    801  OE2 GLU A 104      -4.861  44.987   3.230  1.00 45.45           O  
ATOM    802  N   ARG A 105      -2.741  45.031   5.686  1.00 34.81           N  
ATOM    803  CA  ARG A 105      -1.497  44.673   4.964  1.00 35.01           C  
ATOM    804  C   ARG A 105      -0.496  43.938   5.844  1.00 35.66           C  
ATOM    805  O   ARG A 105       0.016  42.872   5.452  1.00 35.81           O  
ATOM    806  CB  ARG A 105      -0.817  45.886   4.295  1.00 35.25           C  
ATOM    807  CG  ARG A 105       0.322  45.468   3.363  1.00 34.17           C  
ATOM    808  CD  ARG A 105       0.874  46.594   2.466  1.00 34.79           C  
ATOM    809  NE  ARG A 105       1.250  45.996   1.179  1.00 34.48           N  
ATOM    810  CZ  ARG A 105       2.474  45.613   0.804  1.00 33.02           C  
ATOM    811  NH1 ARG A 105       2.636  45.078  -0.390  1.00 30.48           N  
ATOM    812  NH2 ARG A 105       3.544  45.800   1.578  1.00 32.99           N  
ATOM    813  N   TYR A 106      -0.221  44.504   7.028  1.00 35.70           N  
ATOM    814  CA  TYR A 106       0.703  43.899   7.982  1.00 35.31           C  
ATOM    815  C   TYR A 106       0.274  42.484   8.390  1.00 35.50           C  
ATOM    816  O   TYR A 106       1.102  41.574   8.428  1.00 35.09           O  
ATOM    817  CB  TYR A 106       0.831  44.784   9.225  1.00 35.30           C  
ATOM    818  CG  TYR A 106       1.906  44.345  10.192  1.00 34.53           C  
ATOM    819  CD1 TYR A 106       1.642  43.383  11.152  1.00 33.01           C  
ATOM    820  CD2 TYR A 106       3.186  44.917  10.159  1.00 32.52           C  
ATOM    821  CE1 TYR A 106       2.624  42.961  12.052  1.00 35.08           C  
ATOM    822  CE2 TYR A 106       4.176  44.506  11.059  1.00 32.59           C  
ATOM    823  CZ  TYR A 106       3.890  43.527  12.005  1.00 33.77           C  
ATOM    824  OH  TYR A 106       4.844  43.103  12.915  1.00 31.71           O  
ATOM    825  N   TYR A 107      -1.011  42.293   8.702  1.00 35.79           N  
ATOM    826  CA  TYR A 107      -1.492  40.942   9.029  1.00 35.89           C  
ATOM    827  C   TYR A 107      -1.410  39.910   7.900  1.00 36.21           C  
ATOM    828  O   TYR A 107      -1.336  38.715   8.169  1.00 35.67           O  
ATOM    829  CB  TYR A 107      -2.852  40.952   9.744  1.00 36.43           C  
ATOM    830  CG  TYR A 107      -2.776  41.616  11.112  1.00 36.51           C  
ATOM    831  CD1 TYR A 107      -1.640  41.466  11.921  1.00 37.60           C  
ATOM    832  CD2 TYR A 107      -3.821  42.408  11.587  1.00 37.86           C  
ATOM    833  CE1 TYR A 107      -1.559  42.075  13.183  1.00 37.08           C  
ATOM    834  CE2 TYR A 107      -3.751  43.029  12.832  1.00 37.23           C  
ATOM    835  CZ  TYR A 107      -2.613  42.859  13.628  1.00 37.82           C  
ATOM    836  OH  TYR A 107      -2.542  43.457  14.871  1.00 35.67           O  
ATOM    837  N   ARG A 108      -1.370  40.372   6.646  1.00 36.03           N  
ATOM    838  CA  ARG A 108      -1.085  39.473   5.532  1.00 37.12           C  
ATOM    839  C   ARG A 108       0.351  38.992   5.587  1.00 36.63           C  
ATOM    840  O   ARG A 108       0.622  37.818   5.386  1.00 36.70           O  
ATOM    841  CB  ARG A 108      -1.437  40.100   4.154  1.00 36.72           C  
ATOM    842  CG  ARG A 108      -2.829  39.654   3.650  1.00 38.20           C  
ATOM    843  CD  ARG A 108      -3.439  40.522   2.539  1.00 38.58           C  
ATOM    844  NE  ARG A 108      -2.393  41.087   1.733  1.00 43.61           N  
ATOM    845  CZ  ARG A 108      -2.202  42.374   1.478  1.00 43.41           C  
ATOM    846  NH1 ARG A 108      -3.040  43.312   1.893  1.00 45.30           N  
ATOM    847  NH2 ARG A 108      -1.148  42.700   0.764  1.00 44.22           N  
ATOM    848  N   TYR A 109       1.267  39.908   5.911  1.00 36.01           N  
ATOM    849  CA  TYR A 109       2.680  39.587   6.090  1.00 35.15           C  
ATOM    850  C   TYR A 109       2.971  38.743   7.339  1.00 35.48           C  
ATOM    851  O   TYR A 109       3.824  37.859   7.293  1.00 34.95           O  
ATOM    852  CB  TYR A 109       3.506  40.889   6.095  1.00 34.12           C  
ATOM    853  CG  TYR A 109       3.681  41.417   4.685  1.00 33.20           C  
ATOM    854  CD1 TYR A 109       2.625  42.042   4.008  1.00 32.64           C  
ATOM    855  CD2 TYR A 109       4.879  41.219   4.005  1.00 32.85           C  
ATOM    856  CE1 TYR A 109       2.789  42.507   2.657  1.00 34.09           C  
ATOM    857  CE2 TYR A 109       5.064  41.662   2.704  1.00 31.90           C  
ATOM    858  CZ  TYR A 109       4.024  42.302   2.031  1.00 34.08           C  
ATOM    859  OH  TYR A 109       4.246  42.701   0.742  1.00 34.26           O  
ATOM    860  N   PHE A 110       2.286  39.038   8.443  1.00 35.55           N  
ATOM    861  CA  PHE A 110       2.530  38.365   9.719  1.00 37.82           C  
ATOM    862  C   PHE A 110       1.213  37.823  10.311  1.00 40.29           C  
ATOM    863  O   PHE A 110       0.708  38.358  11.289  1.00 39.32           O  
ATOM    864  CB  PHE A 110       3.278  39.292  10.706  1.00 35.78           C  
ATOM    865  CG  PHE A 110       4.571  39.830  10.147  1.00 34.44           C  
ATOM    866  CD1 PHE A 110       4.640  41.124   9.639  1.00 32.90           C  
ATOM    867  CD2 PHE A 110       5.707  39.018  10.080  1.00 33.19           C  
ATOM    868  CE1 PHE A 110       5.819  41.623   9.103  1.00 33.33           C  
ATOM    869  CE2 PHE A 110       6.916  39.521   9.548  1.00 34.71           C  
ATOM    870  CZ  PHE A 110       6.966  40.813   9.054  1.00 32.15           C  
ATOM    871  N   PRO A 111       0.696  36.745   9.746  1.00 43.46           N  
ATOM    872  CA  PRO A 111      -0.595  36.207  10.166  1.00 46.02           C  
ATOM    873  C   PRO A 111      -0.677  35.912  11.658  1.00 49.05           C  
ATOM    874  O   PRO A 111      -1.736  36.071  12.239  1.00 49.41           O  
ATOM    875  CB  PRO A 111      -0.700  34.915   9.372  1.00 46.04           C  
ATOM    876  CG  PRO A 111       0.106  35.124   8.207  1.00 44.81           C  
ATOM    877  CD  PRO A 111       1.228  36.029   8.582  1.00 43.07           C  
ATOM    878  N   GLU A 112       0.422  35.492  12.266  1.00 52.86           N  
ATOM    879  CA  GLU A 112       0.394  35.005  13.638  1.00 56.97           C  
ATOM    880  C   GLU A 112       0.140  36.129  14.645  1.00 58.75           C  
ATOM    881  O   GLU A 112       0.082  35.904  15.843  1.00 60.00           O  
ATOM    882  CB  GLU A 112       1.681  34.243  13.969  1.00 56.92           C  
ATOM    883  CG  GLU A 112       1.731  32.827  13.406  1.00 58.22           C  
ATOM    884  CD  GLU A 112       2.848  31.975  13.998  1.00 59.02           C  
ATOM    885  OE1 GLU A 112       3.211  30.949  13.385  1.00 60.28           O  
ATOM    886  OE2 GLU A 112       3.367  32.330  15.074  1.00 61.58           O  
ATOM    887  N   SER A 113      -0.016  37.341  14.137  1.00 60.66           N  
ATOM    888  CA  SER A 113      -0.028  38.531  14.963  1.00 62.41           C  
ATOM    889  C   SER A 113      -1.457  39.000  15.040  1.00 63.65           C  
ATOM    890  O   SER A 113      -1.787  39.904  15.796  1.00 63.99           O  
ATOM    891  CB  SER A 113       0.816  39.637  14.314  1.00 63.29           C  
ATOM    892  OG  SER A 113       2.187  39.298  14.298  1.00 62.47           O  
ATOM    893  N   ALA A 114      -2.310  38.396  14.231  1.00 64.59           N  
ATOM    894  CA  ALA A 114      -3.588  39.005  13.940  1.00 65.87           C  
ATOM    895  C   ALA A 114      -4.155  39.663  15.194  1.00 66.59           C  
ATOM    896  O   ALA A 114      -3.957  39.180  16.299  1.00 66.84           O  
ATOM    897  CB  ALA A 114      -4.551  37.975  13.374  1.00 65.90           C  
ATOM    898  N   ASP A 115      -4.841  40.781  15.006  1.00 67.36           N  
ATOM    899  CA  ASP A 115      -5.469  41.520  16.097  1.00 68.29           C  
ATOM    900  C   ASP A 115      -4.721  41.572  17.418  1.00 68.43           C  
ATOM    901  O   ASP A 115      -5.331  41.623  18.481  1.00 68.55           O  
ATOM    902  CB  ASP A 115      -6.890  41.037  16.312  1.00 68.56           C  
ATOM    903  CG  ASP A 115      -7.717  41.154  15.067  1.00 69.61           C  
ATOM    904  OD1 ASP A 115      -7.156  40.911  13.975  1.00 69.32           O  
ATOM    905  OD2 ASP A 115      -8.916  41.494  15.086  1.00 70.75           O  
ATOM    906  N   TYR A 116      -3.401  41.588  17.351  1.00 68.71           N  
ATOM    907  CA  TYR A 116      -2.610  41.979  18.518  1.00 69.00           C  
ATOM    908  C   TYR A 116      -2.811  43.436  18.943  1.00 68.86           C  
ATOM    909  O   TYR A 116      -2.634  43.762  20.108  1.00 68.91           O  
ATOM    910  CB  TYR A 116      -1.129  41.667  18.277  1.00 69.42           C  
ATOM    911  CG  TYR A 116      -0.694  40.350  18.881  1.00 70.45           C  
ATOM    912  CD1 TYR A 116       0.563  40.223  19.484  1.00 71.94           C  
ATOM    913  CD2 TYR A 116      -1.545  39.237  18.885  1.00 70.36           C  
ATOM    914  CE1 TYR A 116       0.976  39.014  20.058  1.00 71.32           C  
ATOM    915  CE2 TYR A 116      -1.147  38.029  19.456  1.00 71.02           C  
ATOM    916  CZ  TYR A 116       0.118  37.928  20.038  1.00 71.07           C  
ATOM    917  OH  TYR A 116       0.528  36.746  20.606  1.00 71.39           O  
ATOM    918  N   HIS A 117      -3.182  44.308  18.002  1.00 68.97           N  
ATOM    919  CA  HIS A 117      -3.646  45.662  18.338  1.00 68.65           C  
ATOM    920  C   HIS A 117      -5.053  45.635  18.991  1.00 68.56           C  
ATOM    921  O   HIS A 117      -6.078  45.432  18.326  1.00 68.44           O  
ATOM    922  CB  HIS A 117      -3.534  46.622  17.132  1.00 68.54           C  
ATOM    923  CG  HIS A 117      -4.567  46.405  16.072  1.00 68.88           C  
ATOM    924  ND1 HIS A 117      -4.689  45.220  15.376  1.00 68.84           N  
ATOM    925  CD2 HIS A 117      -5.525  47.229  15.583  1.00 69.28           C  
ATOM    926  CE1 HIS A 117      -5.686  45.319  14.513  1.00 69.32           C  
ATOM    927  NE2 HIS A 117      -6.206  46.530  14.613  1.00 69.64           N  
ATOM    928  N   ARG A 118      -5.053  45.791  20.315  1.00 68.38           N  
ATOM    929  CA  ARG A 118      -6.255  45.842  21.187  1.00 68.03           C  
ATOM    930  C   ARG A 118      -7.036  44.546  21.485  1.00 67.00           C  
ATOM    931  O   ARG A 118      -8.206  44.596  21.895  1.00 67.09           O  
ATOM    932  CB  ARG A 118      -7.177  47.042  20.883  1.00 68.55           C  
ATOM    933  CG  ARG A 118      -6.709  48.361  21.537  1.00 70.21           C  
ATOM    934  CD  ARG A 118      -6.602  48.258  23.074  1.00 73.26           C  
ATOM    935  NE  ARG A 118      -5.361  47.613  23.528  1.00 74.88           N  
ATOM    936  CZ  ARG A 118      -4.991  47.488  24.807  1.00 76.42           C  
ATOM    937  NH1 ARG A 118      -3.844  46.890  25.113  1.00 76.52           N  
ATOM    938  NH2 ARG A 118      -5.759  47.961  25.786  1.00 76.85           N  
ATOM    939  N   VAL A 119      -6.384  43.403  21.276  1.00 65.46           N  
ATOM    940  CA  VAL A 119      -6.593  42.244  22.155  1.00 63.86           C  
ATOM    941  C   VAL A 119      -5.355  42.243  23.056  1.00 62.36           C  
ATOM    942  O   VAL A 119      -5.436  41.985  24.263  1.00 62.51           O  
ATOM    943  CB  VAL A 119      -6.772  40.880  21.420  1.00 64.18           C  
ATOM    944  CG1 VAL A 119      -5.517  40.487  20.637  1.00 64.43           C  
ATOM    945  CG2 VAL A 119      -7.136  39.772  22.431  1.00 64.03           C  
ATOM    946  N   HIS A 120      -4.216  42.568  22.447  1.00 60.00           N  
ATOM    947  CA  HIS A 120      -2.987  42.779  23.173  1.00 57.75           C  
ATOM    948  C   HIS A 120      -2.540  44.239  23.099  1.00 55.47           C  
ATOM    949  O   HIS A 120      -3.208  45.100  22.521  1.00 55.03           O  
ATOM    950  CB  HIS A 120      -1.887  41.841  22.662  1.00 58.28           C  
ATOM    951  CG  HIS A 120      -2.098  40.412  23.047  1.00 60.62           C  
ATOM    952  ND1 HIS A 120      -1.763  39.918  24.292  1.00 62.12           N  
ATOM    953  CD2 HIS A 120      -2.629  39.371  22.359  1.00 62.16           C  
ATOM    954  CE1 HIS A 120      -2.070  38.635  24.350  1.00 62.48           C  
ATOM    955  NE2 HIS A 120      -2.593  38.278  23.190  1.00 62.78           N  
ATOM    956  N   ASP A 121      -1.380  44.469  23.687  1.00 52.36           N  
ATOM    957  CA  ASP A 121      -0.753  45.759  23.872  1.00 50.06           C  
ATOM    958  C   ASP A 121      -0.352  46.609  22.632  1.00 46.96           C  
ATOM    959  O   ASP A 121       0.297  47.632  22.809  1.00 46.91           O  
ATOM    960  CB  ASP A 121       0.541  45.454  24.638  1.00 50.87           C  
ATOM    961  CG  ASP A 121       0.788  46.410  25.774  1.00 52.99           C  
ATOM    962  OD1 ASP A 121      -0.189  46.914  26.379  1.00 56.73           O  
ATOM    963  OD2 ASP A 121       1.970  46.642  26.075  1.00 56.61           O  
ATOM    964  N   PHE A 122      -0.700  46.221  21.402  1.00 42.99           N  
ATOM    965  CA  PHE A 122       0.103  46.687  20.244  1.00 39.64           C  
ATOM    966  C   PHE A 122      -0.492  47.829  19.417  1.00 38.28           C  
ATOM    967  O   PHE A 122      -1.706  47.898  19.236  1.00 37.46           O  
ATOM    968  CB  PHE A 122       0.450  45.524  19.318  1.00 38.29           C  
ATOM    969  CG  PHE A 122       1.370  44.503  19.928  1.00 38.15           C  
ATOM    970  CD1 PHE A 122       0.878  43.563  20.857  1.00 36.10           C  
ATOM    971  CD2 PHE A 122       2.719  44.456  19.568  1.00 35.00           C  
ATOM    972  CE1 PHE A 122       1.719  42.603  21.440  1.00 35.62           C  
ATOM    973  CE2 PHE A 122       3.578  43.494  20.146  1.00 36.55           C  
ATOM    974  CZ  PHE A 122       3.073  42.568  21.082  1.00 36.52           C  
ATOM    975  N   ASP A 123       0.384  48.705  18.904  1.00 35.93           N  
ATOM    976  CA  ASP A 123      -0.002  49.774  17.990  1.00 34.06           C  
ATOM    977  C   ASP A 123       0.953  49.852  16.798  1.00 33.04           C  
ATOM    978  O   ASP A 123       2.167  49.600  16.905  1.00 31.57           O  
ATOM    979  CB  ASP A 123      -0.002  51.143  18.679  1.00 34.68           C  
ATOM    980  CG  ASP A 123      -0.891  51.200  19.912  1.00 36.52           C  
ATOM    981  OD1 ASP A 123      -2.133  51.113  19.776  1.00 37.96           O  
ATOM    982  OD2 ASP A 123      -0.333  51.359  21.017  1.00 38.23           O  
ATOM    983  N   PHE A 124       0.384  50.237  15.665  1.00 31.55           N  
ATOM    984  CA  PHE A 124       1.135  50.412  14.441  1.00 30.95           C  
ATOM    985  C   PHE A 124       1.855  51.741  14.420  1.00 30.55           C  
ATOM    986  O   PHE A 124       1.275  52.785  14.751  1.00 29.81           O  
ATOM    987  CB  PHE A 124       0.199  50.307  13.248  1.00 31.47           C  
ATOM    988  CG  PHE A 124      -0.252  48.907  12.966  1.00 32.20           C  
ATOM    989  CD1 PHE A 124      -1.507  48.477  13.366  1.00 35.41           C  
ATOM    990  CD2 PHE A 124       0.586  48.013  12.316  1.00 33.95           C  
ATOM    991  CE1 PHE A 124      -1.936  47.154  13.111  1.00 35.99           C  
ATOM    992  CE2 PHE A 124       0.175  46.705  12.052  1.00 34.28           C  
ATOM    993  CZ  PHE A 124      -1.078  46.270  12.450  1.00 33.73           C  
ATOM    994  N   TRP A 125       3.129  51.691  14.036  1.00 30.32           N  
ATOM    995  CA  TRP A 125       3.940  52.887  13.825  1.00 29.40           C  
ATOM    996  C   TRP A 125       4.581  52.842  12.444  1.00 29.51           C  
ATOM    997  O   TRP A 125       4.987  51.768  11.962  1.00 30.01           O  
ATOM    998  CB  TRP A 125       5.064  52.981  14.848  1.00 28.62           C  
ATOM    999  CG  TRP A 125       4.672  53.181  16.291  1.00 28.05           C  
ATOM   1000  CD1 TRP A 125       3.907  52.337  17.072  1.00 27.65           C  
ATOM   1001  CD2 TRP A 125       5.075  54.264  17.152  1.00 28.17           C  
ATOM   1002  NE1 TRP A 125       3.798  52.850  18.358  1.00 28.05           N  
ATOM   1003  CE2 TRP A 125       4.511  54.019  18.436  1.00 27.53           C  
ATOM   1004  CE3 TRP A 125       5.842  55.423  16.964  1.00 28.64           C  
ATOM   1005  CZ2 TRP A 125       4.671  54.904  19.507  1.00 27.64           C  
ATOM   1006  CZ3 TRP A 125       6.035  56.288  18.062  1.00 28.82           C  
ATOM   1007  CH2 TRP A 125       5.449  56.026  19.301  1.00 27.82           C  
ATOM   1008  N   VAL A 126       4.718  54.014  11.826  1.00 28.71           N  
ATOM   1009  CA  VAL A 126       5.401  54.135  10.522  1.00 28.50           C  
ATOM   1010  C   VAL A 126       6.731  54.855  10.775  1.00 28.30           C  
ATOM   1011  O   VAL A 126       6.788  55.761  11.607  1.00 27.14           O  
ATOM   1012  CB  VAL A 126       4.523  54.845   9.456  1.00 28.28           C  
ATOM   1013  CG1 VAL A 126       4.149  56.285   9.895  1.00 28.51           C  
ATOM   1014  CG2 VAL A 126       5.218  54.882   8.078  1.00 29.86           C  
ATOM   1015  N   LEU A 127       7.791  54.407  10.102  1.00 27.76           N  
ATOM   1016  CA  LEU A 127       9.081  55.099  10.128  1.00 28.45           C  
ATOM   1017  C   LEU A 127       9.159  56.093   8.952  1.00 27.82           C  
ATOM   1018  O   LEU A 127       9.318  55.700   7.781  1.00 28.12           O  
ATOM   1019  CB  LEU A 127      10.251  54.095  10.113  1.00 28.34           C  
ATOM   1020  CG  LEU A 127      10.271  53.045  11.241  1.00 31.43           C  
ATOM   1021  CD1 LEU A 127      11.580  52.261  11.238  1.00 34.28           C  
ATOM   1022  CD2 LEU A 127      10.058  53.663  12.632  1.00 33.68           C  
ATOM   1023  N   GLN A 128       9.035  57.377   9.277  1.00 27.35           N  
ATOM   1024  CA  GLN A 128       9.096  58.452   8.290  1.00 27.74           C  
ATOM   1025  C   GLN A 128      10.557  58.737   7.979  1.00 27.27           C  
ATOM   1026  O   GLN A 128      11.286  59.174   8.853  1.00 27.24           O  
ATOM   1027  CB  GLN A 128       8.414  59.693   8.842  1.00 27.88           C  
ATOM   1028  CG  GLN A 128       7.044  59.381   9.352  1.00 32.53           C  
ATOM   1029  CD  GLN A 128       6.451  60.447  10.242  1.00 36.62           C  
ATOM   1030  OE1 GLN A 128       5.397  60.986   9.929  1.00 41.17           O  
ATOM   1031  NE2 GLN A 128       7.102  60.742  11.360  1.00 36.60           N  
ATOM   1032  N   PRO A 129      11.007  58.410   6.756  1.00 27.97           N  
ATOM   1033  CA  PRO A 129      12.413  58.590   6.373  1.00 27.72           C  
ATOM   1034  C   PRO A 129      12.928  60.035   6.437  1.00 27.94           C  
ATOM   1035  O   PRO A 129      12.247  60.979   6.023  1.00 26.38           O  
ATOM   1036  CB  PRO A 129      12.465  58.030   4.934  1.00 27.86           C  
ATOM   1037  CG  PRO A 129      11.302  56.976   4.928  1.00 27.89           C  
ATOM   1038  CD  PRO A 129      10.234  57.754   5.684  1.00 26.92           C  
ATOM   1039  N   VAL A 130      14.115  60.172   7.023  1.00 26.59           N  
ATOM   1040  CA  VAL A 130      14.863  61.434   7.076  1.00 26.40           C  
ATOM   1041  C   VAL A 130      16.092  61.327   6.145  1.00 26.99           C  
ATOM   1042  O   VAL A 130      16.461  62.271   5.437  1.00 26.94           O  
ATOM   1043  CB  VAL A 130      15.288  61.694   8.541  1.00 26.53           C  
ATOM   1044  CG1 VAL A 130      16.296  62.840   8.653  1.00 26.06           C  
ATOM   1045  CG2 VAL A 130      14.053  61.969   9.396  1.00 23.65           C  
ATOM   1046  N   GLN A 131      16.758  60.179   6.173  1.00 27.03           N  
ATOM   1047  CA  GLN A 131      18.000  60.005   5.405  1.00 27.77           C  
ATOM   1048  C   GLN A 131      18.306  58.517   5.296  1.00 28.11           C  
ATOM   1049  O   GLN A 131      17.945  57.770   6.193  1.00 28.84           O  
ATOM   1050  CB  GLN A 131      19.180  60.744   6.087  1.00 27.89           C  
ATOM   1051  CG  GLN A 131      20.405  60.967   5.138  1.00 27.71           C  
ATOM   1052  CD  GLN A 131      20.181  62.018   4.063  1.00 29.50           C  
ATOM   1053  OE1 GLN A 131      19.084  62.600   3.913  1.00 29.18           O  
ATOM   1054  NE2 GLN A 131      21.227  62.273   3.299  1.00 26.59           N  
ATOM   1055  N   TRP A 132      18.971  58.086   4.214  1.00 27.86           N  
ATOM   1056  CA  TRP A 132      19.431  56.700   4.094  1.00 27.52           C  
ATOM   1057  C   TRP A 132      20.941  56.602   3.899  1.00 27.85           C  
ATOM   1058  O   TRP A 132      21.509  57.380   3.158  1.00 26.46           O  
ATOM   1059  CB  TRP A 132      18.763  56.021   2.907  1.00 27.42           C  
ATOM   1060  CG  TRP A 132      17.285  56.184   2.833  1.00 25.96           C  
ATOM   1061  CD1 TRP A 132      16.590  57.275   2.344  1.00 25.99           C  
ATOM   1062  CD2 TRP A 132      16.292  55.198   3.179  1.00 27.62           C  
ATOM   1063  NE1 TRP A 132      15.238  57.032   2.397  1.00 26.50           N  
ATOM   1064  CE2 TRP A 132      15.021  55.772   2.905  1.00 25.50           C  
ATOM   1065  CE3 TRP A 132      16.352  53.889   3.686  1.00 26.17           C  
ATOM   1066  CZ2 TRP A 132      13.827  55.074   3.103  1.00 26.28           C  
ATOM   1067  CZ3 TRP A 132      15.154  53.192   3.881  1.00 26.56           C  
ATOM   1068  CH2 TRP A 132      13.910  53.793   3.604  1.00 26.42           C  
ATOM   1069  N   ARG A 133      21.591  55.638   4.557  1.00 28.01           N  
ATOM   1070  CA  ARG A 133      23.021  55.369   4.257  1.00 27.45           C  
ATOM   1071  C   ARG A 133      23.126  53.955   3.688  1.00 27.97           C  
ATOM   1072  O   ARG A 133      22.908  52.974   4.413  1.00 25.78           O  
ATOM   1073  CB  ARG A 133      23.892  55.533   5.498  1.00 26.63           C  
ATOM   1074  CG  ARG A 133      25.425  55.448   5.279  1.00 27.69           C  
ATOM   1075  CD  ARG A 133      25.988  54.026   5.038  1.00 31.73           C  
ATOM   1076  NE  ARG A 133      25.267  52.937   5.728  1.00 35.35           N  
ATOM   1077  CZ  ARG A 133      25.815  52.055   6.552  1.00 36.46           C  
ATOM   1078  NH1 ARG A 133      27.109  52.123   6.840  1.00 34.93           N  
ATOM   1079  NH2 ARG A 133      25.064  51.092   7.088  1.00 37.67           N  
ATOM   1080  N   PHE A 134      23.435  53.838   2.396  1.00 28.40           N  
ATOM   1081  CA  PHE A 134      23.494  52.500   1.801  1.00 29.77           C  
ATOM   1082  C   PHE A 134      24.966  52.147   1.586  1.00 30.76           C  
ATOM   1083  O   PHE A 134      25.745  52.980   1.088  1.00 31.86           O  
ATOM   1084  CB  PHE A 134      22.674  52.431   0.494  1.00 29.55           C  
ATOM   1085  CG  PHE A 134      22.840  51.140  -0.275  1.00 31.39           C  
ATOM   1086  CD1 PHE A 134      22.204  49.968   0.143  1.00 30.31           C  
ATOM   1087  CD2 PHE A 134      23.648  51.088  -1.421  1.00 31.67           C  
ATOM   1088  CE1 PHE A 134      22.372  48.755  -0.581  1.00 30.92           C  
ATOM   1089  CE2 PHE A 134      23.799  49.885  -2.146  1.00 33.20           C  
ATOM   1090  CZ  PHE A 134      23.162  48.718  -1.716  1.00 30.11           C  
ATOM   1091  N   ILE A 135      25.361  50.944   1.980  1.00 30.88           N  
ATOM   1092  CA  ILE A 135      26.695  50.452   1.647  1.00 32.14           C  
ATOM   1093  C   ILE A 135      26.567  49.190   0.785  1.00 33.10           C  
ATOM   1094  O   ILE A 135      25.854  48.233   1.142  1.00 32.76           O  
ATOM   1095  CB  ILE A 135      27.638  50.305   2.917  1.00 32.44           C  
ATOM   1096  CG1 ILE A 135      29.035  49.824   2.525  1.00 32.19           C  
ATOM   1097  CG2 ILE A 135      27.051  49.377   3.966  1.00 32.91           C  
ATOM   1098  CD1 ILE A 135      30.085  50.181   3.532  1.00 32.78           C  
ATOM   1099  N   GLY A 136      27.185  49.229  -0.396  1.00 34.06           N  
ATOM   1100  CA  GLY A 136      27.087  48.115  -1.343  1.00 34.79           C  
ATOM   1101  C   GLY A 136      28.072  47.018  -0.981  1.00 35.48           C  
ATOM   1102  O   GLY A 136      28.974  47.232  -0.162  1.00 35.25           O  
ATOM   1103  N   GLY A 137      27.899  45.848  -1.602  1.00 36.92           N  
ATOM   1104  CA  GLY A 137      28.743  44.659  -1.356  1.00 38.24           C  
ATOM   1105  C   GLY A 137      30.240  44.874  -1.523  1.00 38.67           C  
ATOM   1106  O   GLY A 137      31.050  44.236  -0.834  1.00 39.41           O  
ATOM   1107  N   PHE A 138      30.603  45.783  -2.429  1.00 38.51           N  
ATOM   1108  CA  PHE A 138      32.001  46.150  -2.692  1.00 37.96           C  
ATOM   1109  C   PHE A 138      32.470  47.260  -1.783  1.00 37.82           C  
ATOM   1110  O   PHE A 138      33.654  47.627  -1.777  1.00 38.23           O  
ATOM   1111  CB  PHE A 138      32.179  46.531  -4.171  1.00 39.05           C  
ATOM   1112  CG  PHE A 138      32.546  45.350  -5.072  1.00 39.98           C  
ATOM   1113  CD1 PHE A 138      32.013  44.073  -4.839  1.00 38.23           C  
ATOM   1114  CD2 PHE A 138      33.422  45.533  -6.153  1.00 39.86           C  
ATOM   1115  CE1 PHE A 138      32.341  42.988  -5.651  1.00 40.38           C  
ATOM   1116  CE2 PHE A 138      33.757  44.452  -6.988  1.00 40.14           C  
ATOM   1117  CZ  PHE A 138      33.220  43.178  -6.738  1.00 40.38           C  
ATOM   1118  N   GLY A 139      31.550  47.812  -0.995  1.00 36.42           N  
ATOM   1119  CA  GLY A 139      31.949  48.736   0.037  1.00 34.80           C  
ATOM   1120  C   GLY A 139      31.795  50.197  -0.324  1.00 34.31           C  
ATOM   1121  O   GLY A 139      32.239  51.063   0.445  1.00 34.29           O  
ATOM   1122  N   ALA A 140      31.163  50.493  -1.464  1.00 32.80           N  
ATOM   1123  CA  ALA A 140      30.853  51.901  -1.790  1.00 32.62           C  
ATOM   1124  C   ALA A 140      29.722  52.465  -0.898  1.00 31.99           C  
ATOM   1125  O   ALA A 140      28.684  51.831  -0.734  1.00 30.79           O  
ATOM   1126  CB  ALA A 140      30.488  52.058  -3.257  1.00 33.22           C  
ATOM   1127  N   ILE A 141      29.946  53.649  -0.338  1.00 32.27           N  
ATOM   1128  CA  ILE A 141      28.977  54.311   0.544  1.00 33.17           C  
ATOM   1129  C   ILE A 141      28.166  55.383  -0.202  1.00 33.76           C  
ATOM   1130  O   ILE A 141      28.755  56.264  -0.838  1.00 34.07           O  
ATOM   1131  CB  ILE A 141      29.697  54.985   1.725  1.00 33.62           C  
ATOM   1132  CG1 ILE A 141      30.514  53.947   2.516  1.00 33.59           C  
ATOM   1133  CG2 ILE A 141      28.688  55.793   2.598  1.00 32.54           C  
ATOM   1134  CD1 ILE A 141      31.615  54.587   3.354  1.00 35.52           C  
ATOM   1135  N   HIS A 142      26.839  55.284  -0.139  1.00 33.16           N  
ATOM   1136  CA  HIS A 142      25.930  56.288  -0.712  1.00 33.69           C  
ATOM   1137  C   HIS A 142      24.965  56.831   0.332  1.00 32.42           C  
ATOM   1138  O   HIS A 142      24.180  56.082   0.926  1.00 32.58           O  
ATOM   1139  CB  HIS A 142      25.142  55.696  -1.886  1.00 34.19           C  
ATOM   1140  CG  HIS A 142      26.016  55.140  -2.956  1.00 37.35           C  
ATOM   1141  ND1 HIS A 142      26.512  53.853  -2.913  1.00 40.32           N  
ATOM   1142  CD2 HIS A 142      26.525  55.709  -4.075  1.00 40.05           C  
ATOM   1143  CE1 HIS A 142      27.273  53.648  -3.974  1.00 41.12           C  
ATOM   1144  NE2 HIS A 142      27.301  54.758  -4.692  1.00 41.39           N  
ATOM   1145  N   TRP A 143      25.030  58.130   0.558  1.00 31.23           N  
ATOM   1146  CA  TRP A 143      24.023  58.820   1.357  1.00 30.65           C  
ATOM   1147  C   TRP A 143      22.882  59.245   0.443  1.00 30.49           C  
ATOM   1148  O   TRP A 143      23.114  59.828  -0.622  1.00 29.99           O  
ATOM   1149  CB  TRP A 143      24.645  60.031   2.034  1.00 30.98           C  
ATOM   1150  CG  TRP A 143      25.417  59.689   3.278  1.00 31.32           C  
ATOM   1151  CD1 TRP A 143      26.762  59.489   3.394  1.00 32.81           C  
ATOM   1152  CD2 TRP A 143      24.866  59.504   4.590  1.00 31.90           C  
ATOM   1153  NE1 TRP A 143      27.086  59.201   4.718  1.00 32.94           N  
ATOM   1154  CE2 TRP A 143      25.938  59.205   5.464  1.00 31.80           C  
ATOM   1155  CE3 TRP A 143      23.571  59.560   5.105  1.00 30.22           C  
ATOM   1156  CZ2 TRP A 143      25.750  58.980   6.831  1.00 31.71           C  
ATOM   1157  CZ3 TRP A 143      23.378  59.340   6.477  1.00 32.20           C  
ATOM   1158  CH2 TRP A 143      24.465  59.062   7.320  1.00 31.74           C  
ATOM   1159  N   LEU A 144      21.648  58.941   0.831  1.00 29.77           N  
ATOM   1160  CA  LEU A 144      20.510  59.220  -0.056  1.00 29.82           C  
ATOM   1161  C   LEU A 144      19.429  60.024   0.668  1.00 30.17           C  
ATOM   1162  O   LEU A 144      19.144  59.793   1.856  1.00 28.52           O  
ATOM   1163  CB  LEU A 144      19.924  57.896  -0.609  1.00 29.19           C  
ATOM   1164  CG  LEU A 144      20.918  56.902  -1.260  1.00 30.54           C  
ATOM   1165  CD1 LEU A 144      20.362  55.506  -1.270  1.00 28.78           C  
ATOM   1166  CD2 LEU A 144      21.309  57.314  -2.681  1.00 34.08           C  
ATOM   1167  N   ALA A 145      18.821  60.965  -0.050  1.00 30.90           N  
ATOM   1168  CA  ALA A 145      17.715  61.770   0.505  1.00 31.09           C  
ATOM   1169  C   ALA A 145      16.565  60.897   0.977  1.00 31.08           C  
ATOM   1170  O   ALA A 145      16.381  59.775   0.502  1.00 31.54           O  
ATOM   1171  CB  ALA A 145      17.210  62.777  -0.532  1.00 31.00           C  
ATOM   1172  N   ALA A 146      15.792  61.425   1.910  1.00 31.19           N  
ATOM   1173  CA  ALA A 146      14.629  60.747   2.473  1.00 32.43           C  
ATOM   1174  C   ALA A 146      13.737  60.093   1.415  1.00 33.18           C  
ATOM   1175  O   ALA A 146      13.344  58.919   1.566  1.00 32.74           O  
ATOM   1176  CB  ALA A 146      13.818  61.728   3.318  1.00 32.33           C  
ATOM   1177  N   GLU A 147      13.446  60.840   0.341  1.00 34.15           N  
ATOM   1178  CA  GLU A 147      12.509  60.392  -0.701  1.00 36.10           C  
ATOM   1179  C   GLU A 147      13.136  59.610  -1.857  1.00 35.26           C  
ATOM   1180  O   GLU A 147      12.434  59.097  -2.717  1.00 34.25           O  
ATOM   1181  CB  GLU A 147      11.704  61.589  -1.237  1.00 36.66           C  
ATOM   1182  CG  GLU A 147      10.697  62.145  -0.197  1.00 39.37           C  
ATOM   1183  CD  GLU A 147       9.755  63.180  -0.799  1.00 41.58           C  
ATOM   1184  OE1 GLU A 147       8.585  62.823  -1.124  1.00 50.26           O  
ATOM   1185  OE2 GLU A 147      10.201  64.340  -0.989  1.00 49.07           O  
ATOM   1186  N   ARG A 148      14.459  59.483  -1.854  1.00 35.26           N  
ATOM   1187  CA  ARG A 148      15.161  58.779  -2.920  1.00 35.00           C  
ATOM   1188  C   ARG A 148      14.886  57.252  -2.951  1.00 34.30           C  
ATOM   1189  O   ARG A 148      14.840  56.636  -4.022  1.00 33.32           O  
ATOM   1190  CB  ARG A 148      16.655  59.075  -2.788  1.00 35.15           C  
ATOM   1191  CG  ARG A 148      17.469  58.748  -3.986  1.00 39.92           C  
ATOM   1192  CD  ARG A 148      17.318  59.759  -5.114  1.00 44.69           C  
ATOM   1193  NE  ARG A 148      17.990  59.243  -6.312  1.00 51.04           N  
ATOM   1194  CZ  ARG A 148      19.297  59.364  -6.554  1.00 53.30           C  
ATOM   1195  NH1 ARG A 148      20.083  60.007  -5.700  1.00 53.68           N  
ATOM   1196  NH2 ARG A 148      19.822  58.848  -7.657  1.00 54.93           N  
ATOM   1197  N   VAL A 149      14.681  56.653  -1.775  1.00 33.42           N  
ATOM   1198  CA  VAL A 149      14.578  55.187  -1.650  1.00 32.18           C  
ATOM   1199  C   VAL A 149      13.142  54.620  -1.745  1.00 32.87           C  
ATOM   1200  O   VAL A 149      12.912  53.718  -2.541  1.00 33.49           O  
ATOM   1201  CB  VAL A 149      15.382  54.613  -0.404  1.00 31.97           C  
ATOM   1202  CG1 VAL A 149      15.140  53.088  -0.193  1.00 28.19           C  
ATOM   1203  CG2 VAL A 149      16.886  54.906  -0.540  1.00 27.89           C  
ATOM   1204  N   PRO A 150      12.166  55.152  -0.978  1.00 33.48           N  
ATOM   1205  CA  PRO A 150      10.847  54.487  -1.057  1.00 33.57           C  
ATOM   1206  C   PRO A 150      10.152  54.675  -2.422  1.00 33.99           C  
ATOM   1207  O   PRO A 150      10.240  55.744  -2.994  1.00 34.91           O  
ATOM   1208  CB  PRO A 150      10.016  55.205   0.014  1.00 33.28           C  
ATOM   1209  CG  PRO A 150      11.004  55.974   0.844  1.00 33.74           C  
ATOM   1210  CD  PRO A 150      12.132  56.317  -0.078  1.00 32.85           C  
ATOM   1211  N   LEU A 151       9.475  53.635  -2.906  1.00 33.27           N  
ATOM   1212  CA  LEU A 151       8.548  53.717  -4.039  1.00 33.56           C  
ATOM   1213  C   LEU A 151       7.132  53.328  -3.573  1.00 33.15           C  
ATOM   1214  O   LEU A 151       6.913  52.266  -2.977  1.00 33.40           O  
ATOM   1215  CB  LEU A 151       9.019  52.821  -5.203  1.00 32.67           C  
ATOM   1216  CG  LEU A 151       8.332  52.896  -6.564  1.00 33.25           C  
ATOM   1217  CD1 LEU A 151       8.508  54.313  -7.182  1.00 31.72           C  
ATOM   1218  CD2 LEU A 151       8.901  51.822  -7.502  1.00 32.57           C  
ATOM   1219  N   ALA A 152       6.186  54.217  -3.823  1.00 33.73           N  
ATOM   1220  CA  ALA A 152       4.777  53.990  -3.496  1.00 33.83           C  
ATOM   1221  C   ALA A 152       4.247  52.706  -4.142  1.00 34.64           C  
ATOM   1222  O   ALA A 152       4.736  52.269  -5.177  1.00 35.18           O  
ATOM   1223  CB  ALA A 152       3.946  55.199  -3.950  1.00 33.71           C  
ATOM   1224  N   ASN A 153       3.245  52.097  -3.521  1.00 35.58           N  
ATOM   1225  CA  ASN A 153       2.644  50.878  -4.037  1.00 36.32           C  
ATOM   1226  C   ASN A 153       1.183  51.176  -4.332  1.00 37.08           C  
ATOM   1227  O   ASN A 153       0.372  51.286  -3.391  1.00 36.92           O  
ATOM   1228  CB  ASN A 153       2.794  49.730  -3.014  1.00 36.30           C  
ATOM   1229  CG  ASN A 153       2.090  48.444  -3.436  1.00 35.94           C  
ATOM   1230  OD1 ASN A 153       1.573  48.316  -4.562  1.00 35.36           O  
ATOM   1231  ND2 ASN A 153       2.055  47.477  -2.516  1.00 33.53           N  
ATOM   1232  N   PRO A 154       0.838  51.331  -5.634  1.00 37.79           N  
ATOM   1233  CA  PRO A 154      -0.557  51.669  -6.012  1.00 38.85           C  
ATOM   1234  C   PRO A 154      -1.557  50.541  -5.760  1.00 39.70           C  
ATOM   1235  O   PRO A 154      -2.757  50.762  -5.867  1.00 39.70           O  
ATOM   1236  CB  PRO A 154      -0.466  51.980  -7.513  1.00 38.84           C  
ATOM   1237  CG  PRO A 154       0.732  51.246  -7.993  1.00 38.91           C  
ATOM   1238  CD  PRO A 154       1.716  51.199  -6.814  1.00 37.56           C  
ATOM   1239  N   PHE A 155      -1.064  49.349  -5.411  1.00 40.22           N  
ATOM   1240  CA  PHE A 155      -1.923  48.202  -5.171  1.00 41.30           C  
ATOM   1241  C   PHE A 155      -2.335  48.084  -3.714  1.00 42.44           C  
ATOM   1242  O   PHE A 155      -3.288  47.373  -3.402  1.00 43.11           O  
ATOM   1243  CB  PHE A 155      -1.244  46.901  -5.634  1.00 41.01           C  
ATOM   1244  CG  PHE A 155      -0.718  46.966  -7.040  1.00 41.13           C  
ATOM   1245  CD1 PHE A 155      -1.574  47.261  -8.110  1.00 39.84           C  
ATOM   1246  CD2 PHE A 155       0.629  46.721  -7.307  1.00 41.29           C  
ATOM   1247  CE1 PHE A 155      -1.091  47.322  -9.408  1.00 38.84           C  
ATOM   1248  CE2 PHE A 155       1.115  46.777  -8.609  1.00 40.32           C  
ATOM   1249  CZ  PHE A 155       0.251  47.091  -9.660  1.00 40.73           C  
ATOM   1250  N   ALA A 156      -1.652  48.806  -2.828  1.00 43.37           N  
ATOM   1251  CA  ALA A 156      -1.762  48.517  -1.394  1.00 44.80           C  
ATOM   1252  C   ALA A 156      -3.199  48.633  -0.880  1.00 45.49           C  
ATOM   1253  O   ALA A 156      -3.891  49.611  -1.151  1.00 46.15           O  
ATOM   1254  CB  ALA A 156      -0.796  49.369  -0.583  1.00 44.55           C  
ATOM   1255  N   GLY A 157      -3.653  47.605  -0.170  1.00 46.40           N  
ATOM   1256  CA  GLY A 157      -5.042  47.544   0.279  1.00 47.31           C  
ATOM   1257  C   GLY A 157      -5.885  46.606  -0.574  1.00 47.80           C  
ATOM   1258  O   GLY A 157      -5.456  45.502  -0.892  1.00 48.15           O  
ATOM   1259  N   GLU A 158      -7.066  47.077  -0.967  1.00 48.30           N  
ATOM   1260  CA  GLU A 158      -8.107  46.239  -1.572  1.00 48.52           C  
ATOM   1261  C   GLU A 158      -7.784  45.680  -2.973  1.00 47.30           C  
ATOM   1262  O   GLU A 158      -8.182  44.553  -3.291  1.00 47.66           O  
ATOM   1263  CB  GLU A 158      -9.479  46.962  -1.465  1.00 49.54           C  
ATOM   1264  CG  GLU A 158     -10.505  46.742  -2.581  1.00 53.44           C  
ATOM   1265  CD  GLU A 158     -10.471  47.848  -3.656  1.00 58.87           C  
ATOM   1266  OE1 GLU A 158     -10.417  49.057  -3.300  1.00 59.80           O  
ATOM   1267  OE2 GLU A 158     -10.499  47.500  -4.864  1.00 61.64           O  
ATOM   1268  N   ALA A 159      -7.066  46.434  -3.806  1.00 46.21           N  
ATOM   1269  CA  ALA A 159      -6.632  45.886  -5.098  1.00 44.80           C  
ATOM   1270  C   ALA A 159      -5.692  44.705  -4.836  1.00 44.30           C  
ATOM   1271  O   ALA A 159      -5.929  43.581  -5.287  1.00 43.25           O  
ATOM   1272  CB  ALA A 159      -5.972  46.936  -5.949  1.00 44.73           C  
ATOM   1273  N   GLU A 160      -4.644  44.976  -4.065  1.00 43.04           N  
ATOM   1274  CA  GLU A 160      -3.690  43.973  -3.653  1.00 41.88           C  
ATOM   1275  C   GLU A 160      -4.326  42.781  -2.945  1.00 41.85           C  
ATOM   1276  O   GLU A 160      -3.993  41.632  -3.239  1.00 41.80           O  
ATOM   1277  CB  GLU A 160      -2.683  44.633  -2.706  1.00 41.71           C  
ATOM   1278  CG  GLU A 160      -1.519  43.794  -2.415  1.00 40.39           C  
ATOM   1279  CD  GLU A 160      -0.653  44.348  -1.280  1.00 39.17           C  
ATOM   1280  OE1 GLU A 160      -1.039  45.242  -0.485  1.00 38.26           O  
ATOM   1281  OE2 GLU A 160       0.444  43.838  -1.186  1.00 39.62           O  
ATOM   1282  N   ARG A 161      -5.206  43.052  -1.980  1.00 41.87           N  
ATOM   1283  CA  ARG A 161      -5.836  41.992  -1.183  1.00 41.80           C  
ATOM   1284  C   ARG A 161      -6.556  41.018  -2.102  1.00 40.64           C  
ATOM   1285  O   ARG A 161      -6.462  39.806  -1.927  1.00 40.27           O  
ATOM   1286  CB  ARG A 161      -6.806  42.577  -0.159  1.00 41.62           C  
ATOM   1287  CG  ARG A 161      -7.427  41.558   0.769  1.00 43.33           C  
ATOM   1288  CD  ARG A 161      -8.501  42.185   1.677  1.00 44.83           C  
ATOM   1289  NE  ARG A 161      -9.604  42.791   0.915  1.00 50.64           N  
ATOM   1290  CZ  ARG A 161      -9.977  44.073   0.998  1.00 54.13           C  
ATOM   1291  NH1 ARG A 161      -9.359  44.914   1.834  1.00 53.74           N  
ATOM   1292  NH2 ARG A 161     -10.992  44.517   0.252  1.00 54.88           N  
ATOM   1293  N   GLY A 162      -7.250  41.557  -3.102  1.00 40.06           N  
ATOM   1294  CA  GLY A 162      -7.935  40.738  -4.100  1.00 39.35           C  
ATOM   1295  C   GLY A 162      -7.027  39.924  -5.006  1.00 39.22           C  
ATOM   1296  O   GLY A 162      -7.270  38.726  -5.212  1.00 38.74           O  
ATOM   1297  N   MET A 163      -5.996  40.567  -5.563  1.00 39.07           N  
ATOM   1298  CA  MET A 163      -5.015  39.853  -6.384  1.00 39.37           C  
ATOM   1299  C   MET A 163      -4.358  38.714  -5.601  1.00 39.54           C  
ATOM   1300  O   MET A 163      -4.179  37.608  -6.121  1.00 40.40           O  
ATOM   1301  CB  MET A 163      -3.948  40.801  -6.925  1.00 38.39           C  
ATOM   1302  CG  MET A 163      -4.391  41.635  -8.103  1.00 38.84           C  
ATOM   1303  SD  MET A 163      -3.087  42.745  -8.640  1.00 40.84           S  
ATOM   1304  CE  MET A 163      -3.427  44.118  -7.602  1.00 29.51           C  
ATOM   1305  N   VAL A 164      -4.005  38.990  -4.346  1.00 39.91           N  
ATOM   1306  CA  VAL A 164      -3.328  38.010  -3.487  1.00 40.31           C  
ATOM   1307  C   VAL A 164      -4.259  36.850  -3.104  1.00 41.02           C  
ATOM   1308  O   VAL A 164      -3.859  35.666  -3.162  1.00 40.59           O  
ATOM   1309  CB  VAL A 164      -2.768  38.683  -2.199  1.00 39.76           C  
ATOM   1310  CG1 VAL A 164      -2.541  37.659  -1.115  1.00 40.17           C  
ATOM   1311  CG2 VAL A 164      -1.491  39.458  -2.512  1.00 40.01           C  
ATOM   1312  N   GLU A 165      -5.485  37.186  -2.689  1.00 41.89           N  
ATOM   1313  CA  GLU A 165      -6.459  36.173  -2.302  1.00 43.35           C  
ATOM   1314  C   GLU A 165      -6.756  35.234  -3.464  1.00 43.14           C  
ATOM   1315  O   GLU A 165      -6.801  34.010  -3.275  1.00 43.29           O  
ATOM   1316  CB  GLU A 165      -7.729  36.802  -1.718  1.00 43.25           C  
ATOM   1317  CG  GLU A 165      -7.594  37.117  -0.206  1.00 45.25           C  
ATOM   1318  CD  GLU A 165      -8.669  38.080   0.339  1.00 45.59           C  
ATOM   1319  OE1 GLU A 165      -9.686  38.357  -0.353  1.00 48.42           O  
ATOM   1320  OE2 GLU A 165      -8.494  38.548   1.485  1.00 48.47           O  
ATOM   1321  N   HIS A 166      -6.896  35.803  -4.664  1.00 44.15           N  
ATOM   1322  CA  HIS A 166      -7.167  35.016  -5.883  1.00 44.93           C  
ATOM   1323  C   HIS A 166      -5.995  34.172  -6.369  1.00 44.54           C  
ATOM   1324  O   HIS A 166      -6.211  33.069  -6.862  1.00 44.84           O  
ATOM   1325  CB  HIS A 166      -7.675  35.894  -7.027  1.00 45.61           C  
ATOM   1326  CG  HIS A 166      -9.166  36.037  -7.054  1.00 48.10           C  
ATOM   1327  ND1 HIS A 166      -9.823  37.109  -6.483  1.00 50.49           N  
ATOM   1328  CD2 HIS A 166     -10.128  35.230  -7.559  1.00 49.54           C  
ATOM   1329  CE1 HIS A 166     -11.125  36.963  -6.654  1.00 51.84           C  
ATOM   1330  NE2 HIS A 166     -11.337  35.829  -7.301  1.00 51.32           N  
ATOM   1331  N   MET A 167      -4.764  34.680  -6.254  1.00 43.68           N  
ATOM   1332  CA  MET A 167      -3.583  33.863  -6.575  1.00 42.34           C  
ATOM   1333  C   MET A 167      -3.471  32.666  -5.641  1.00 42.16           C  
ATOM   1334  O   MET A 167      -3.134  31.566  -6.064  1.00 42.01           O  
ATOM   1335  CB  MET A 167      -2.290  34.691  -6.519  1.00 42.18           C  
ATOM   1336  CG  MET A 167      -1.979  35.477  -7.795  1.00 39.45           C  
ATOM   1337  SD  MET A 167      -1.692  34.446  -9.255  1.00 28.55           S  
ATOM   1338  CE  MET A 167      -0.155  33.636  -8.796  1.00 34.84           C  
ATOM   1339  N   ASN A 168      -3.753  32.887  -4.364  1.00 42.05           N  
ATOM   1340  CA  ASN A 168      -3.643  31.841  -3.348  1.00 41.94           C  
ATOM   1341  C   ASN A 168      -4.713  30.736  -3.452  1.00 42.39           C  
ATOM   1342  O   ASN A 168      -4.420  29.560  -3.234  1.00 41.74           O  
ATOM   1343  CB  ASN A 168      -3.638  32.468  -1.961  1.00 41.70           C  
ATOM   1344  CG  ASN A 168      -2.309  33.139  -1.635  1.00 41.32           C  
ATOM   1345  OD1 ASN A 168      -1.255  32.724  -2.128  1.00 39.86           O  
ATOM   1346  ND2 ASN A 168      -2.352  34.164  -0.791  1.00 41.56           N  
ATOM   1347  N   SER A 169      -5.934  31.129  -3.795  1.00 42.73           N  
ATOM   1348  CA  SER A 169      -7.047  30.177  -3.989  1.00 43.83           C  
ATOM   1349  C   SER A 169      -7.020  29.442  -5.321  1.00 43.58           C  
ATOM   1350  O   SER A 169      -7.254  28.226  -5.386  1.00 44.17           O  
ATOM   1351  CB  SER A 169      -8.391  30.909  -3.849  1.00 44.05           C  
ATOM   1352  OG  SER A 169      -8.946  30.665  -2.559  1.00 46.29           O  
ATOM   1353  N   ASP A 170      -6.767  30.192  -6.389  1.00 43.85           N  
ATOM   1354  CA  ASP A 170      -6.856  29.665  -7.750  1.00 43.77           C  
ATOM   1355  C   ASP A 170      -5.532  29.092  -8.287  1.00 43.40           C  
ATOM   1356  O   ASP A 170      -5.546  28.214  -9.132  1.00 42.60           O  
ATOM   1357  CB  ASP A 170      -7.351  30.754  -8.714  1.00 44.66           C  
ATOM   1358  CG  ASP A 170      -8.734  31.348  -8.326  1.00 46.31           C  
ATOM   1359  OD1 ASP A 170      -9.558  30.674  -7.659  1.00 47.60           O  
ATOM   1360  OD2 ASP A 170      -8.998  32.505  -8.721  1.00 48.11           O  
ATOM   1361  N   HIS A 171      -4.388  29.588  -7.815  1.00 42.99           N  
ATOM   1362  CA  HIS A 171      -3.123  29.312  -8.518  1.00 42.85           C  
ATOM   1363  C   HIS A 171      -1.976  28.775  -7.659  1.00 42.74           C  
ATOM   1364  O   HIS A 171      -0.787  29.110  -7.861  1.00 42.64           O  
ATOM   1365  CB  HIS A 171      -2.690  30.532  -9.344  1.00 42.96           C  
ATOM   1366  CG  HIS A 171      -3.635  30.869 -10.455  1.00 44.33           C  
ATOM   1367  ND1 HIS A 171      -4.539  31.907 -10.375  1.00 46.06           N  
ATOM   1368  CD2 HIS A 171      -3.830  30.293 -11.662  1.00 45.26           C  
ATOM   1369  CE1 HIS A 171      -5.248  31.960 -11.489  1.00 45.91           C  
ATOM   1370  NE2 HIS A 171      -4.840  30.989 -12.287  1.00 46.19           N  
ATOM   1371  N   ALA A 172      -2.338  27.902  -6.726  1.00 42.39           N  
ATOM   1372  CA  ALA A 172      -1.371  27.181  -5.920  1.00 41.73           C  
ATOM   1373  C   ALA A 172      -0.267  26.535  -6.784  1.00 41.59           C  
ATOM   1374  O   ALA A 172       0.883  26.436  -6.361  1.00 41.41           O  
ATOM   1375  CB  ALA A 172      -2.097  26.123  -5.058  1.00 41.80           C  
ATOM   1376  N   ALA A 173      -0.619  26.086  -7.987  1.00 40.84           N  
ATOM   1377  CA  ALA A 173       0.343  25.430  -8.862  1.00 40.48           C  
ATOM   1378  C   ALA A 173       1.413  26.421  -9.356  1.00 40.51           C  
ATOM   1379  O   ALA A 173       2.596  26.093  -9.379  1.00 40.34           O  
ATOM   1380  CB  ALA A 173      -0.385  24.728 -10.055  1.00 40.58           C  
ATOM   1381  N   ALA A 174       0.994  27.629  -9.757  1.00 40.42           N  
ATOM   1382  CA  ALA A 174       1.937  28.669 -10.203  1.00 40.38           C  
ATOM   1383  C   ALA A 174       2.902  29.075  -9.080  1.00 40.29           C  
ATOM   1384  O   ALA A 174       4.065  29.352  -9.334  1.00 40.31           O  
ATOM   1385  CB  ALA A 174       1.188  29.898 -10.755  1.00 39.51           C  
ATOM   1386  N   ILE A 175       2.390  29.074  -7.848  1.00 40.76           N  
ATOM   1387  CA  ILE A 175       3.127  29.461  -6.641  1.00 40.23           C  
ATOM   1388  C   ILE A 175       4.211  28.450  -6.326  1.00 40.25           C  
ATOM   1389  O   ILE A 175       5.341  28.842  -6.045  1.00 40.07           O  
ATOM   1390  CB  ILE A 175       2.169  29.663  -5.430  1.00 40.30           C  
ATOM   1391  CG1 ILE A 175       1.207  30.836  -5.708  1.00 41.41           C  
ATOM   1392  CG2 ILE A 175       2.948  29.873  -4.102  1.00 38.79           C  
ATOM   1393  CD1 ILE A 175       0.044  30.959  -4.702  1.00 41.37           C  
ATOM   1394  N   ALA A 176       3.872  27.157  -6.378  1.00 39.27           N  
ATOM   1395  CA  ALA A 176       4.840  26.090  -6.145  1.00 38.88           C  
ATOM   1396  C   ALA A 176       5.966  26.182  -7.171  1.00 38.41           C  
ATOM   1397  O   ALA A 176       7.139  25.942  -6.876  1.00 38.66           O  
ATOM   1398  CB  ALA A 176       4.155  24.707  -6.196  1.00 38.63           C  
ATOM   1399  N   HIS A 177       5.606  26.584  -8.374  1.00 38.44           N  
ATOM   1400  CA  HIS A 177       6.576  26.735  -9.432  1.00 38.25           C  
ATOM   1401  C   HIS A 177       7.517  27.915  -9.178  1.00 38.57           C  
ATOM   1402  O   HIS A 177       8.717  27.771  -9.369  1.00 39.00           O  
ATOM   1403  CB  HIS A 177       5.871  26.831 -10.785  1.00 38.46           C  
ATOM   1404  CG  HIS A 177       6.808  26.884 -11.945  1.00 38.35           C  
ATOM   1405  ND1 HIS A 177       7.496  25.777 -12.394  1.00 39.78           N  
ATOM   1406  CD2 HIS A 177       7.170  27.907 -12.751  1.00 37.21           C  
ATOM   1407  CE1 HIS A 177       8.243  26.121 -13.429  1.00 39.25           C  
ATOM   1408  NE2 HIS A 177       8.069  27.408 -13.661  1.00 37.40           N  
ATOM   1409  N   TYR A 178       6.987  29.063  -8.737  1.00 38.77           N  
ATOM   1410  CA  TYR A 178       7.840  30.217  -8.337  1.00 38.16           C  
ATOM   1411  C   TYR A 178       8.905  29.765  -7.330  1.00 38.56           C  
ATOM   1412  O   TYR A 178      10.091  30.076  -7.471  1.00 38.25           O  
ATOM   1413  CB  TYR A 178       7.019  31.366  -7.728  1.00 37.63           C  
ATOM   1414  CG  TYR A 178       5.856  31.875  -8.560  1.00 37.89           C  
ATOM   1415  CD1 TYR A 178       4.721  32.415  -7.947  1.00 37.21           C  
ATOM   1416  CD2 TYR A 178       5.894  31.838  -9.965  1.00 38.26           C  
ATOM   1417  CE1 TYR A 178       3.654  32.897  -8.719  1.00 35.69           C  
ATOM   1418  CE2 TYR A 178       4.824  32.297 -10.746  1.00 35.62           C  
ATOM   1419  CZ  TYR A 178       3.711  32.808 -10.132  1.00 37.16           C  
ATOM   1420  OH  TYR A 178       2.683  33.265 -10.923  1.00 35.53           O  
ATOM   1421  N   VAL A 179       8.459  29.022  -6.318  1.00 39.17           N  
ATOM   1422  CA  VAL A 179       9.330  28.431  -5.291  1.00 39.90           C  
ATOM   1423  C   VAL A 179      10.457  27.584  -5.913  1.00 40.88           C  
ATOM   1424  O   VAL A 179      11.642  27.822  -5.642  1.00 40.77           O  
ATOM   1425  CB  VAL A 179       8.495  27.587  -4.285  1.00 39.36           C  
ATOM   1426  CG1 VAL A 179       9.397  26.783  -3.334  1.00 40.73           C  
ATOM   1427  CG2 VAL A 179       7.525  28.478  -3.523  1.00 38.52           C  
ATOM   1428  N   GLU A 180      10.086  26.605  -6.745  1.00 42.24           N  
ATOM   1429  CA  GLU A 180      11.063  25.774  -7.471  1.00 44.03           C  
ATOM   1430  C   GLU A 180      12.049  26.645  -8.271  1.00 44.39           C  
ATOM   1431  O   GLU A 180      13.274  26.521  -8.142  1.00 44.38           O  
ATOM   1432  CB  GLU A 180      10.329  24.787  -8.397  1.00 43.81           C  
ATOM   1433  CG  GLU A 180      11.234  23.798  -9.133  1.00 46.10           C  
ATOM   1434  CD  GLU A 180      10.457  22.827 -10.030  1.00 46.19           C  
ATOM   1435  OE1 GLU A 180       9.558  23.264 -10.801  1.00 50.53           O  
ATOM   1436  OE2 GLU A 180      10.752  21.617  -9.975  1.00 50.83           O  
ATOM   1437  N   LEU A 181      11.497  27.559  -9.062  1.00 45.05           N  
ATOM   1438  CA  LEU A 181      12.267  28.401  -9.959  1.00 46.71           C  
ATOM   1439  C   LEU A 181      13.309  29.253  -9.219  1.00 48.11           C  
ATOM   1440  O   LEU A 181      14.368  29.568  -9.771  1.00 48.57           O  
ATOM   1441  CB  LEU A 181      11.298  29.288 -10.747  1.00 46.13           C  
ATOM   1442  CG  LEU A 181      11.463  29.481 -12.258  1.00 47.08           C  
ATOM   1443  CD1 LEU A 181      11.483  28.172 -12.994  1.00 46.11           C  
ATOM   1444  CD2 LEU A 181      10.347  30.356 -12.787  1.00 46.71           C  
ATOM   1445  N   ALA A 182      13.016  29.583  -7.958  1.00 49.97           N  
ATOM   1446  CA  ALA A 182      13.722  30.635  -7.216  1.00 51.38           C  
ATOM   1447  C   ALA A 182      14.848  30.212  -6.286  1.00 52.87           C  
ATOM   1448  O   ALA A 182      15.977  30.680  -6.414  1.00 53.76           O  
ATOM   1449  CB  ALA A 182      12.724  31.473  -6.428  1.00 50.90           C  
ATOM   1450  N   GLY A 183      14.544  29.368  -5.313  1.00 54.50           N  
ATOM   1451  CA  GLY A 183      15.338  29.402  -4.093  1.00 56.04           C  
ATOM   1452  C   GLY A 183      15.427  28.055  -3.451  1.00 56.40           C  
ATOM   1453  O   GLY A 183      16.496  27.473  -3.468  1.00 57.38           O  
ATOM   1454  N   LEU A 184      14.381  27.599  -2.763  1.00 56.68           N  
ATOM   1455  CA  LEU A 184      13.491  28.375  -1.876  1.00 56.39           C  
ATOM   1456  C   LEU A 184      12.819  27.251  -1.088  1.00 56.96           C  
ATOM   1457  O   LEU A 184      12.479  26.226  -1.678  1.00 56.19           O  
ATOM   1458  CB  LEU A 184      12.449  29.283  -2.575  1.00 55.97           C  
ATOM   1459  CG  LEU A 184      12.617  30.825  -2.719  1.00 53.77           C  
ATOM   1460  CD1 LEU A 184      11.300  31.527  -2.940  1.00 49.59           C  
ATOM   1461  CD2 LEU A 184      13.338  31.495  -1.568  1.00 52.80           C  
ATOM   1462  N   PRO A 185      12.660  27.421   0.244  1.00 57.69           N  
ATOM   1463  CA  PRO A 185      12.189  26.305   1.100  1.00 58.31           C  
ATOM   1464  C   PRO A 185      10.898  25.681   0.568  1.00 58.74           C  
ATOM   1465  O   PRO A 185      10.053  26.396   0.019  1.00 58.44           O  
ATOM   1466  CB  PRO A 185      11.953  26.973   2.459  1.00 58.51           C  
ATOM   1467  CG  PRO A 185      12.871  28.193   2.451  1.00 58.23           C  
ATOM   1468  CD  PRO A 185      12.892  28.660   1.021  1.00 57.66           C  
ATOM   1469  N   ALA A 186      10.745  24.366   0.737  1.00 59.29           N  
ATOM   1470  CA  ALA A 186       9.638  23.648   0.094  1.00 59.84           C  
ATOM   1471  C   ALA A 186       8.810  22.696   0.983  1.00 60.25           C  
ATOM   1472  O   ALA A 186       8.067  21.862   0.458  1.00 60.72           O  
ATOM   1473  CB  ALA A 186      10.141  22.919  -1.162  1.00 59.61           C  
ATOM   1474  N   HIS A 187       8.912  22.839   2.305  1.00 60.51           N  
ATOM   1475  CA  HIS A 187       8.176  21.977   3.247  1.00 60.94           C  
ATOM   1476  C   HIS A 187       6.675  22.299   3.312  1.00 60.42           C  
ATOM   1477  O   HIS A 187       5.835  21.390   3.267  1.00 60.77           O  
ATOM   1478  CB  HIS A 187       8.816  22.028   4.637  1.00 61.66           C  
ATOM   1479  CG  HIS A 187      10.180  21.407   4.691  1.00 63.83           C  
ATOM   1480  ND1 HIS A 187      10.374  20.047   4.819  1.00 65.74           N  
ATOM   1481  CD2 HIS A 187      11.417  21.958   4.618  1.00 65.73           C  
ATOM   1482  CE1 HIS A 187      11.671  19.787   4.829  1.00 66.71           C  
ATOM   1483  NE2 HIS A 187      12.326  20.930   4.708  1.00 66.72           N  
ATOM   1484  N   ALA A 188       6.363  23.587   3.474  1.00 59.13           N  
ATOM   1485  CA  ALA A 188       5.082  24.184   3.069  1.00 57.92           C  
ATOM   1486  C   ALA A 188       5.410  24.714   1.658  1.00 56.38           C  
ATOM   1487  O   ALA A 188       6.552  25.147   1.460  1.00 56.46           O  
ATOM   1488  CB  ALA A 188       4.723  25.309   4.034  1.00 58.62           C  
ATOM   1489  N   ALA A 189       4.493  24.795   0.681  1.00 54.34           N  
ATOM   1490  CA  ALA A 189       3.129  25.364   0.719  1.00 52.13           C  
ATOM   1491  C   ALA A 189       3.250  26.893   0.968  1.00 50.62           C  
ATOM   1492  O   ALA A 189       3.021  27.389   2.069  1.00 49.71           O  
ATOM   1493  CB  ALA A 189       2.185  24.652   1.706  1.00 52.70           C  
ATOM   1494  N   ALA A 190       3.640  27.616  -0.085  1.00 48.35           N  
ATOM   1495  CA  ALA A 190       3.837  29.067  -0.032  1.00 46.15           C  
ATOM   1496  C   ALA A 190       2.515  29.793  -0.248  1.00 45.16           C  
ATOM   1497  O   ALA A 190       1.634  29.283  -0.932  1.00 44.60           O  
ATOM   1498  CB  ALA A 190       4.854  29.498  -1.069  1.00 45.68           C  
ATOM   1499  N   GLN A 191       2.370  30.969   0.357  1.00 43.48           N  
ATOM   1500  CA  GLN A 191       1.204  31.824   0.120  1.00 42.60           C  
ATOM   1501  C   GLN A 191       1.725  33.185  -0.312  1.00 41.23           C  
ATOM   1502  O   GLN A 191       2.809  33.598   0.153  1.00 40.49           O  
ATOM   1503  CB  GLN A 191       0.342  31.979   1.382  1.00 42.77           C  
ATOM   1504  CG  GLN A 191      -0.288  30.702   1.923  1.00 45.97           C  
ATOM   1505  CD  GLN A 191      -1.366  30.147   1.023  1.00 48.85           C  
ATOM   1506  OE1 GLN A 191      -2.366  30.815   0.740  1.00 52.58           O  
ATOM   1507  NE2 GLN A 191      -1.180  28.909   0.575  1.00 50.15           N  
ATOM   1508  N   LEU A 192       0.990  33.874  -1.200  1.00 39.44           N  
ATOM   1509  CA  LEU A 192       1.311  35.275  -1.497  1.00 38.26           C  
ATOM   1510  C   LEU A 192       0.975  36.117  -0.288  1.00 37.76           C  
ATOM   1511  O   LEU A 192      -0.099  35.970   0.308  1.00 37.31           O  
ATOM   1512  CB  LEU A 192       0.636  35.819  -2.762  1.00 38.74           C  
ATOM   1513  CG  LEU A 192       1.444  35.787  -4.057  1.00 37.42           C  
ATOM   1514  CD1 LEU A 192       1.501  34.356  -4.563  1.00 38.22           C  
ATOM   1515  CD2 LEU A 192       0.785  36.692  -5.093  1.00 38.47           C  
ATOM   1516  N   ALA A 193       1.928  36.964   0.102  1.00 37.06           N  
ATOM   1517  CA  ALA A 193       1.720  37.898   1.206  1.00 36.14           C  
ATOM   1518  C   ALA A 193       1.264  39.262   0.688  1.00 35.86           C  
ATOM   1519  O   ALA A 193       0.330  39.846   1.225  1.00 36.44           O  
ATOM   1520  CB  ALA A 193       3.004  38.011   2.057  1.00 36.05           C  
ATOM   1521  N   GLY A 194       1.912  39.743  -0.374  1.00 34.04           N  
ATOM   1522  CA  GLY A 194       1.615  41.039  -0.950  1.00 33.44           C  
ATOM   1523  C   GLY A 194       2.281  41.222  -2.300  1.00 32.46           C  
ATOM   1524  O   GLY A 194       3.140  40.432  -2.708  1.00 31.92           O  
ATOM   1525  N   ILE A 195       1.877  42.270  -2.999  1.00 33.19           N  
ATOM   1526  CA  ILE A 195       2.399  42.565  -4.329  1.00 33.54           C  
ATOM   1527  C   ILE A 195       2.667  44.040  -4.412  1.00 34.22           C  
ATOM   1528  O   ILE A 195       1.875  44.834  -3.913  1.00 34.54           O  
ATOM   1529  CB  ILE A 195       1.344  42.218  -5.442  1.00 34.62           C  
ATOM   1530  CG1 ILE A 195       1.031  40.707  -5.429  1.00 33.99           C  
ATOM   1531  CG2 ILE A 195       1.824  42.714  -6.844  1.00 32.18           C  
ATOM   1532  CD1 ILE A 195      -0.222  40.298  -6.221  1.00 33.93           C  
ATOM   1533  N   ASP A 196       3.775  44.406  -5.058  1.00 34.08           N  
ATOM   1534  CA  ASP A 196       4.102  45.801  -5.313  1.00 34.77           C  
ATOM   1535  C   ASP A 196       4.406  45.951  -6.806  1.00 35.03           C  
ATOM   1536  O   ASP A 196       4.309  44.980  -7.552  1.00 36.28           O  
ATOM   1537  CB  ASP A 196       5.272  46.288  -4.402  1.00 33.52           C  
ATOM   1538  CG  ASP A 196       6.548  45.483  -4.595  1.00 33.55           C  
ATOM   1539  OD1 ASP A 196       6.746  44.455  -3.885  1.00 34.61           O  
ATOM   1540  OD2 ASP A 196       7.382  45.893  -5.438  1.00 31.89           O  
ATOM   1541  N   THR A 197       4.759  47.151  -7.254  1.00 35.99           N  
ATOM   1542  CA  THR A 197       5.013  47.375  -8.693  1.00 36.27           C  
ATOM   1543  C   THR A 197       6.251  46.646  -9.195  1.00 36.00           C  
ATOM   1544  O   THR A 197       6.337  46.355 -10.385  1.00 35.90           O  
ATOM   1545  CB  THR A 197       5.175  48.878  -9.089  1.00 36.45           C  
ATOM   1546  OG1 THR A 197       6.388  49.413  -8.530  1.00 39.22           O  
ATOM   1547  CG2 THR A 197       3.991  49.690  -8.655  1.00 36.30           C  
ATOM   1548  N   GLU A 198       7.202  46.347  -8.299  1.00 35.22           N  
ATOM   1549  CA  GLU A 198       8.479  45.744  -8.720  1.00 34.35           C  
ATOM   1550  C   GLU A 198       8.566  44.233  -8.508  1.00 33.82           C  
ATOM   1551  O   GLU A 198       9.445  43.565  -9.053  1.00 33.16           O  
ATOM   1552  CB  GLU A 198       9.662  46.462  -8.070  1.00 34.60           C  
ATOM   1553  CG  GLU A 198       9.760  47.918  -8.476  1.00 35.49           C  
ATOM   1554  CD  GLU A 198      10.835  48.684  -7.727  1.00 34.71           C  
ATOM   1555  OE1 GLU A 198      11.729  49.257  -8.392  1.00 33.94           O  
ATOM   1556  OE2 GLU A 198      10.780  48.718  -6.487  1.00 36.87           O  
ATOM   1557  N   GLY A 199       7.639  43.685  -7.742  1.00 32.75           N  
ATOM   1558  CA  GLY A 199       7.735  42.281  -7.367  1.00 33.35           C  
ATOM   1559  C   GLY A 199       6.669  41.928  -6.371  1.00 32.89           C  
ATOM   1560  O   GLY A 199       5.712  42.678  -6.183  1.00 33.29           O  
ATOM   1561  N   PHE A 200       6.844  40.788  -5.721  1.00 33.08           N  
ATOM   1562  CA  PHE A 200       5.852  40.277  -4.801  1.00 33.25           C  
ATOM   1563  C   PHE A 200       6.522  39.441  -3.679  1.00 33.03           C  
ATOM   1564  O   PHE A 200       7.653  38.940  -3.832  1.00 32.89           O  
ATOM   1565  CB  PHE A 200       4.812  39.451  -5.564  1.00 34.12           C  
ATOM   1566  CG  PHE A 200       5.391  38.222  -6.250  1.00 34.82           C  
ATOM   1567  CD1 PHE A 200       5.285  36.965  -5.650  1.00 32.76           C  
ATOM   1568  CD2 PHE A 200       6.027  38.331  -7.499  1.00 34.64           C  
ATOM   1569  CE1 PHE A 200       5.815  35.829  -6.256  1.00 33.42           C  
ATOM   1570  CE2 PHE A 200       6.561  37.209  -8.129  1.00 34.64           C  
ATOM   1571  CZ  PHE A 200       6.443  35.944  -7.519  1.00 34.98           C  
ATOM   1572  N   HIS A 201       5.812  39.307  -2.564  1.00 33.06           N  
ATOM   1573  CA  HIS A 201       6.300  38.559  -1.417  1.00 34.08           C  
ATOM   1574  C   HIS A 201       5.593  37.218  -1.285  1.00 35.15           C  
ATOM   1575  O   HIS A 201       4.364  37.144  -1.435  1.00 35.88           O  
ATOM   1576  CB  HIS A 201       6.100  39.352  -0.122  1.00 33.09           C  
ATOM   1577  CG  HIS A 201       7.028  40.517   0.026  1.00 32.21           C  
ATOM   1578  ND1 HIS A 201       6.684  41.800  -0.352  1.00 31.30           N  
ATOM   1579  CD2 HIS A 201       8.278  40.599   0.543  1.00 29.28           C  
ATOM   1580  CE1 HIS A 201       7.681  42.623  -0.072  1.00 30.71           C  
ATOM   1581  NE2 HIS A 201       8.665  41.919   0.460  1.00 30.64           N  
ATOM   1582  N   LEU A 202       6.379  36.177  -0.989  1.00 35.73           N  
ATOM   1583  CA  LEU A 202       5.851  34.887  -0.601  1.00 37.02           C  
ATOM   1584  C   LEU A 202       6.171  34.653   0.843  1.00 37.83           C  
ATOM   1585  O   LEU A 202       7.302  34.915   1.275  1.00 37.61           O  
ATOM   1586  CB  LEU A 202       6.518  33.760  -1.387  1.00 37.60           C  
ATOM   1587  CG  LEU A 202       6.298  33.668  -2.897  1.00 38.39           C  
ATOM   1588  CD1 LEU A 202       7.091  32.462  -3.441  1.00 38.42           C  
ATOM   1589  CD2 LEU A 202       4.823  33.555  -3.195  1.00 39.17           C  
ATOM   1590  N   ARG A 203       5.187  34.164   1.592  1.00 38.56           N  
ATOM   1591  CA  ARG A 203       5.441  33.646   2.942  1.00 39.88           C  
ATOM   1592  C   ARG A 203       5.624  32.136   2.892  1.00 40.68           C  
ATOM   1593  O   ARG A 203       4.806  31.430   2.274  1.00 40.42           O  
ATOM   1594  CB  ARG A 203       4.303  33.998   3.898  1.00 39.76           C  
ATOM   1595  CG  ARG A 203       4.526  33.480   5.330  1.00 42.42           C  
ATOM   1596  CD  ARG A 203       3.919  34.412   6.350  1.00 46.53           C  
ATOM   1597  NE  ARG A 203       4.336  34.073   7.706  1.00 53.42           N  
ATOM   1598  CZ  ARG A 203       5.181  34.784   8.452  1.00 54.71           C  
ATOM   1599  NH1 ARG A 203       5.721  35.913   7.997  1.00 54.65           N  
ATOM   1600  NH2 ARG A 203       5.468  34.364   9.678  1.00 59.68           N  
ATOM   1601  N   ILE A 204       6.697  31.660   3.526  1.00 41.63           N  
ATOM   1602  CA  ILE A 204       6.991  30.220   3.702  1.00 43.06           C  
ATOM   1603  C   ILE A 204       7.701  29.893   5.027  1.00 44.74           C  
ATOM   1604  O   ILE A 204       8.784  30.391   5.250  1.00 44.65           O  
ATOM   1605  CB  ILE A 204       8.003  29.695   2.627  1.00 42.73           C  
ATOM   1606  CG1 ILE A 204       7.681  30.185   1.210  1.00 42.87           C  
ATOM   1607  CG2 ILE A 204       8.098  28.174   2.684  1.00 43.10           C  
ATOM   1608  CD1 ILE A 204       8.849  30.058   0.237  1.00 42.11           C  
ATOM   1609  N   GLY A 205       7.105  29.196   5.985  1.00 47.07           N  
ATOM   1610  CA  GLY A 205       5.864  29.564   6.594  1.00 48.79           C  
ATOM   1611  C   GLY A 205       6.240  30.592   7.679  1.00 49.61           C  
ATOM   1612  O   GLY A 205       5.352  31.191   8.265  1.00 50.68           O  
ATOM   1613  N   GLN A 206       7.540  30.827   7.929  1.00 50.39           N  
ATOM   1614  CA  GLN A 206       7.978  31.866   8.921  1.00 50.92           C  
ATOM   1615  C   GLN A 206       9.032  33.034   8.693  1.00 49.25           C  
ATOM   1616  O   GLN A 206       9.280  33.768   9.655  1.00 49.62           O  
ATOM   1617  CB  GLN A 206       8.301  31.189  10.262  1.00 51.04           C  
ATOM   1618  CG  GLN A 206       7.111  31.143  11.228  1.00 53.62           C  
ATOM   1619  CD  GLN A 206       7.468  30.513  12.561  1.00 54.27           C  
ATOM   1620  OE1 GLN A 206       6.734  29.646  13.057  1.00 60.02           O  
ATOM   1621  NE2 GLN A 206       8.599  30.940  13.161  1.00 57.33           N  
ATOM   1622  N   GLY A 207       9.657  33.307   7.547  1.00 47.61           N  
ATOM   1623  CA  GLY A 207       9.446  32.793   6.244  1.00 44.02           C  
ATOM   1624  C   GLY A 207       8.948  33.844   5.256  1.00 41.84           C  
ATOM   1625  O   GLY A 207       7.979  33.567   4.607  1.00 41.14           O  
ATOM   1626  N   LEU A 208       9.576  35.025   5.098  1.00 39.51           N  
ATOM   1627  CA  LEU A 208       9.175  35.927   3.969  1.00 37.50           C  
ATOM   1628  C   LEU A 208      10.236  36.183   2.880  1.00 36.77           C  
ATOM   1629  O   LEU A 208      11.383  36.389   3.182  1.00 35.68           O  
ATOM   1630  CB  LEU A 208       8.602  37.278   4.446  1.00 37.32           C  
ATOM   1631  CG  LEU A 208       7.205  37.383   5.044  1.00 35.56           C  
ATOM   1632  CD1 LEU A 208       7.113  38.627   5.907  1.00 34.44           C  
ATOM   1633  CD2 LEU A 208       6.136  37.391   3.956  1.00 33.84           C  
ATOM   1634  N   HIS A 209       9.814  36.218   1.616  1.00 35.99           N  
ATOM   1635  CA  HIS A 209      10.742  36.192   0.499  1.00 35.11           C  
ATOM   1636  C   HIS A 209      10.227  37.075  -0.623  1.00 35.10           C  
ATOM   1637  O   HIS A 209       9.086  36.910  -1.084  1.00 35.96           O  
ATOM   1638  CB  HIS A 209      10.937  34.744  -0.023  1.00 34.73           C  
ATOM   1639  CG  HIS A 209      11.395  33.780   1.029  1.00 33.51           C  
ATOM   1640  ND1 HIS A 209      12.724  33.611   1.359  1.00 33.12           N  
ATOM   1641  CD2 HIS A 209      10.695  32.965   1.856  1.00 33.39           C  
ATOM   1642  CE1 HIS A 209      12.818  32.733   2.346  1.00 34.87           C  
ATOM   1643  NE2 HIS A 209      11.602  32.313   2.652  1.00 32.78           N  
ATOM   1644  N   TRP A 210      11.064  38.003  -1.074  1.00 34.11           N  
ATOM   1645  CA  TRP A 210      10.686  38.874  -2.176  1.00 33.56           C  
ATOM   1646  C   TRP A 210      11.242  38.398  -3.522  1.00 33.63           C  
ATOM   1647  O   TRP A 210      12.429  38.075  -3.634  1.00 32.99           O  
ATOM   1648  CB  TRP A 210      11.176  40.291  -1.917  1.00 32.46           C  
ATOM   1649  CG  TRP A 210      10.639  41.280  -2.920  1.00 32.78           C  
ATOM   1650  CD1 TRP A 210       9.384  41.814  -2.956  1.00 31.72           C  
ATOM   1651  CD2 TRP A 210      11.353  41.857  -4.019  1.00 30.25           C  
ATOM   1652  NE1 TRP A 210       9.279  42.706  -3.991  1.00 30.04           N  
ATOM   1653  CE2 TRP A 210      10.469  42.742  -4.668  1.00 31.32           C  
ATOM   1654  CE3 TRP A 210      12.648  41.697  -4.523  1.00 29.69           C  
ATOM   1655  CZ2 TRP A 210      10.834  43.471  -5.799  1.00 30.86           C  
ATOM   1656  CZ3 TRP A 210      13.023  42.443  -5.642  1.00 31.42           C  
ATOM   1657  CH2 TRP A 210      12.121  43.316  -6.260  1.00 32.44           C  
ATOM   1658  N   LEU A 211      10.387  38.404  -4.541  1.00 34.07           N  
ATOM   1659  CA  LEU A 211      10.788  38.030  -5.896  1.00 34.55           C  
ATOM   1660  C   LEU A 211      10.408  39.121  -6.885  1.00 35.11           C  
ATOM   1661  O   LEU A 211       9.281  39.597  -6.861  1.00 35.30           O  
ATOM   1662  CB  LEU A 211      10.160  36.683  -6.301  1.00 34.59           C  
ATOM   1663  CG  LEU A 211      10.579  35.496  -5.438  1.00 35.21           C  
ATOM   1664  CD1 LEU A 211       9.607  34.327  -5.580  1.00 36.34           C  
ATOM   1665  CD2 LEU A 211      12.035  35.065  -5.738  1.00 33.67           C  
ATOM   1666  N   PRO A 212      11.354  39.518  -7.754  1.00 35.39           N  
ATOM   1667  CA  PRO A 212      11.158  40.578  -8.746  1.00 36.20           C  
ATOM   1668  C   PRO A 212      10.383  40.135  -9.991  1.00 36.77           C  
ATOM   1669  O   PRO A 212      10.483  38.975 -10.430  1.00 36.09           O  
ATOM   1670  CB  PRO A 212      12.586  40.940  -9.147  1.00 36.04           C  
ATOM   1671  CG  PRO A 212      13.338  39.651  -8.984  1.00 36.78           C  
ATOM   1672  CD  PRO A 212      12.708  38.935  -7.823  1.00 35.73           C  
ATOM   1673  N   PHE A 213       9.600  41.065 -10.528  1.00 38.01           N  
ATOM   1674  CA  PHE A 213       9.005  40.947 -11.869  1.00 38.96           C  
ATOM   1675  C   PHE A 213      10.080  41.280 -12.903  1.00 40.33           C  
ATOM   1676  O   PHE A 213      11.039  41.980 -12.569  1.00 40.87           O  
ATOM   1677  CB  PHE A 213       7.871  41.952 -12.020  1.00 38.80           C  
ATOM   1678  CG  PHE A 213       6.684  41.684 -11.143  1.00 37.81           C  
ATOM   1679  CD1 PHE A 213       6.206  40.390 -10.957  1.00 37.88           C  
ATOM   1680  CD2 PHE A 213       6.018  42.739 -10.528  1.00 37.01           C  
ATOM   1681  CE1 PHE A 213       5.091  40.146 -10.155  1.00 36.66           C  
ATOM   1682  CE2 PHE A 213       4.891  42.509  -9.720  1.00 37.32           C  
ATOM   1683  CZ  PHE A 213       4.430  41.213  -9.533  1.00 37.36           C  
ATOM   1684  N   PRO A 214       9.949  40.774 -14.159  1.00 42.03           N  
ATOM   1685  CA  PRO A 214      10.935  41.131 -15.200  1.00 42.76           C  
ATOM   1686  C   PRO A 214      11.046  42.642 -15.411  1.00 43.58           C  
ATOM   1687  O   PRO A 214      12.130  43.163 -15.692  1.00 44.43           O  
ATOM   1688  CB  PRO A 214      10.389  40.449 -16.465  1.00 42.60           C  
ATOM   1689  CG  PRO A 214       9.548  39.319 -15.947  1.00 42.99           C  
ATOM   1690  CD  PRO A 214       8.925  39.840 -14.675  1.00 41.58           C  
ATOM   1691  N   ALA A 215       9.928  43.342 -15.261  1.00 44.03           N  
ATOM   1692  CA  ALA A 215       9.936  44.790 -15.318  1.00 44.34           C  
ATOM   1693  C   ALA A 215       8.791  45.270 -14.454  1.00 44.03           C  
ATOM   1694  O   ALA A 215       7.872  44.507 -14.175  1.00 44.33           O  
ATOM   1695  CB  ALA A 215       9.791  45.272 -16.781  1.00 44.57           C  
ATOM   1696  N   ALA A 216       8.869  46.511 -13.987  1.00 44.09           N  
ATOM   1697  CA  ALA A 216       7.847  47.051 -13.097  1.00 43.95           C  
ATOM   1698  C   ALA A 216       6.472  46.926 -13.723  1.00 43.99           C  
ATOM   1699  O   ALA A 216       6.321  47.045 -14.943  1.00 43.90           O  
ATOM   1700  CB  ALA A 216       8.150  48.510 -12.754  1.00 44.63           C  
ATOM   1701  N   CYS A 217       5.476  46.649 -12.891  1.00 43.73           N  
ATOM   1702  CA  CYS A 217       4.104  46.507 -13.348  1.00 43.38           C  
ATOM   1703  C   CYS A 217       3.268  47.568 -12.675  1.00 43.35           C  
ATOM   1704  O   CYS A 217       3.079  47.531 -11.467  1.00 43.43           O  
ATOM   1705  CB  CYS A 217       3.563  45.108 -13.012  1.00 43.42           C  
ATOM   1706  SG  CYS A 217       4.518  43.731 -13.691  1.00 42.55           S  
ATOM   1707  N   GLY A 218       2.771  48.517 -13.461  1.00 43.84           N  
ATOM   1708  CA  GLY A 218       2.028  49.654 -12.925  1.00 44.06           C  
ATOM   1709  C   GLY A 218       0.551  49.420 -12.647  1.00 44.29           C  
ATOM   1710  O   GLY A 218      -0.065  50.181 -11.902  1.00 44.44           O  
ATOM   1711  N   ASN A 219      -0.016  48.371 -13.239  1.00 44.21           N  
ATOM   1712  CA  ASN A 219      -1.435  48.050 -13.089  1.00 44.15           C  
ATOM   1713  C   ASN A 219      -1.652  46.522 -12.906  1.00 43.59           C  
ATOM   1714  O   ASN A 219      -0.707  45.749 -13.113  1.00 43.29           O  
ATOM   1715  CB  ASN A 219      -2.217  48.606 -14.294  1.00 44.79           C  
ATOM   1716  CG  ASN A 219      -1.633  48.170 -15.633  1.00 45.91           C  
ATOM   1717  OD1 ASN A 219      -1.654  46.991 -15.977  1.00 48.77           O  
ATOM   1718  ND2 ASN A 219      -1.118  49.127 -16.397  1.00 48.22           N  
ATOM   1719  N   PRO A 220      -2.875  46.088 -12.506  1.00 42.95           N  
ATOM   1720  CA  PRO A 220      -3.141  44.664 -12.259  1.00 43.17           C  
ATOM   1721  C   PRO A 220      -3.052  43.775 -13.490  1.00 42.85           C  
ATOM   1722  O   PRO A 220      -2.892  42.566 -13.352  1.00 43.17           O  
ATOM   1723  CB  PRO A 220      -4.579  44.655 -11.731  1.00 42.96           C  
ATOM   1724  CG  PRO A 220      -4.803  46.027 -11.232  1.00 43.08           C  
ATOM   1725  CD  PRO A 220      -4.073  46.894 -12.215  1.00 43.46           C  
ATOM   1726  N   GLY A 221      -3.193  44.375 -14.670  1.00 42.55           N  
ATOM   1727  CA  GLY A 221      -3.120  43.661 -15.941  1.00 42.02           C  
ATOM   1728  C   GLY A 221      -1.678  43.330 -16.211  1.00 41.50           C  
ATOM   1729  O   GLY A 221      -1.355  42.232 -16.670  1.00 41.36           O  
ATOM   1730  N   ALA A 222      -0.804  44.282 -15.894  1.00 40.75           N  
ATOM   1731  CA  ALA A 222       0.630  44.070 -16.008  1.00 40.09           C  
ATOM   1732  C   ALA A 222       1.120  43.042 -14.987  1.00 39.92           C  
ATOM   1733  O   ALA A 222       1.949  42.189 -15.330  1.00 39.56           O  
ATOM   1734  CB  ALA A 222       1.378  45.382 -15.865  1.00 40.60           C  
ATOM   1735  N   VAL A 223       0.617  43.083 -13.746  1.00 39.47           N  
ATOM   1736  CA  VAL A 223       1.035  42.035 -12.813  1.00 39.70           C  
ATOM   1737  C   VAL A 223       0.563  40.625 -13.229  1.00 39.27           C  
ATOM   1738  O   VAL A 223       1.365  39.717 -13.196  1.00 38.72           O  
ATOM   1739  CB  VAL A 223       0.871  42.337 -11.257  1.00 40.11           C  
ATOM   1740  CG1 VAL A 223       0.734  43.836 -10.929  1.00 40.02           C  
ATOM   1741  CG2 VAL A 223      -0.174  41.431 -10.551  1.00 39.25           C  
ATOM   1742  N   ARG A 224      -0.694  40.470 -13.684  1.00 40.26           N  
ATOM   1743  CA  ARG A 224      -1.168  39.157 -14.218  1.00 39.78           C  
ATOM   1744  C   ARG A 224      -0.206  38.660 -15.290  1.00 39.34           C  
ATOM   1745  O   ARG A 224       0.253  37.528 -15.219  1.00 38.75           O  
ATOM   1746  CB  ARG A 224      -2.611  39.173 -14.771  1.00 40.42           C  
ATOM   1747  CG  ARG A 224      -3.250  37.742 -14.834  1.00 40.22           C  
ATOM   1748  CD  ARG A 224      -4.405  37.535 -15.875  1.00 41.23           C  
ATOM   1749  NE  ARG A 224      -4.043  36.684 -17.032  1.00 43.57           N  
ATOM   1750  CZ  ARG A 224      -4.376  35.403 -17.217  1.00 45.71           C  
ATOM   1751  NH1 ARG A 224      -5.114  34.723 -16.335  1.00 47.96           N  
ATOM   1752  NH2 ARG A 224      -3.955  34.773 -18.310  1.00 47.75           N  
ATOM   1753  N   GLN A 225       0.134  39.525 -16.246  1.00 38.46           N  
ATOM   1754  CA  GLN A 225       1.081  39.150 -17.295  1.00 38.94           C  
ATOM   1755  C   GLN A 225       2.418  38.613 -16.765  1.00 38.07           C  
ATOM   1756  O   GLN A 225       2.827  37.496 -17.111  1.00 37.77           O  
ATOM   1757  CB  GLN A 225       1.302  40.299 -18.282  1.00 39.61           C  
ATOM   1758  CG  GLN A 225       2.256  39.933 -19.405  1.00 43.76           C  
ATOM   1759  CD  GLN A 225       2.168  40.846 -20.626  1.00 49.58           C  
ATOM   1760  OE1 GLN A 225       1.751  42.013 -20.538  1.00 52.26           O  
ATOM   1761  NE2 GLN A 225       2.564  40.305 -21.788  1.00 51.08           N  
ATOM   1762  N   ALA A 226       3.088  39.401 -15.913  1.00 36.34           N  
ATOM   1763  CA  ALA A 226       4.347  38.990 -15.305  1.00 34.72           C  
ATOM   1764  C   ALA A 226       4.198  37.655 -14.568  1.00 33.76           C  
ATOM   1765  O   ALA A 226       5.034  36.792 -14.713  1.00 34.01           O  
ATOM   1766  CB  ALA A 226       4.889  40.087 -14.371  1.00 33.95           C  
ATOM   1767  N   LEU A 227       3.111  37.485 -13.822  1.00 33.54           N  
ATOM   1768  CA  LEU A 227       2.852  36.245 -13.076  1.00 33.50           C  
ATOM   1769  C   LEU A 227       2.522  35.040 -13.971  1.00 34.30           C  
ATOM   1770  O   LEU A 227       2.789  33.892 -13.595  1.00 34.04           O  
ATOM   1771  CB  LEU A 227       1.762  36.447 -12.011  1.00 32.72           C  
ATOM   1772  CG  LEU A 227       2.114  37.362 -10.822  1.00 34.16           C  
ATOM   1773  CD1 LEU A 227       0.850  37.707 -10.019  1.00 34.25           C  
ATOM   1774  CD2 LEU A 227       3.167  36.715  -9.916  1.00 31.19           C  
ATOM   1775  N   VAL A 228       1.956  35.293 -15.150  1.00 34.88           N  
ATOM   1776  CA  VAL A 228       1.699  34.205 -16.118  1.00 36.02           C  
ATOM   1777  C   VAL A 228       3.030  33.749 -16.714  1.00 36.95           C  
ATOM   1778  O   VAL A 228       3.303  32.554 -16.792  1.00 36.02           O  
ATOM   1779  CB  VAL A 228       0.688  34.607 -17.217  1.00 35.62           C  
ATOM   1780  CG1 VAL A 228       0.597  33.529 -18.347  1.00 35.35           C  
ATOM   1781  CG2 VAL A 228      -0.679  34.839 -16.604  1.00 36.40           C  
ATOM   1782  N   GLN A 229       3.852  34.723 -17.110  1.00 38.39           N  
ATOM   1783  CA  GLN A 229       5.193  34.473 -17.636  1.00 40.19           C  
ATOM   1784  C   GLN A 229       6.088  33.699 -16.655  1.00 40.68           C  
ATOM   1785  O   GLN A 229       6.738  32.732 -17.037  1.00 40.90           O  
ATOM   1786  CB  GLN A 229       5.845  35.797 -18.059  1.00 41.14           C  
ATOM   1787  CG  GLN A 229       7.171  35.626 -18.791  1.00 44.29           C  
ATOM   1788  CD  GLN A 229       8.071  36.842 -18.643  1.00 48.31           C  
ATOM   1789  OE1 GLN A 229       7.637  37.981 -18.856  1.00 49.30           O  
ATOM   1790  NE2 GLN A 229       9.336  36.607 -18.271  1.00 48.84           N  
ATOM   1791  N   LEU A 230       6.106  34.100 -15.390  1.00 41.23           N  
ATOM   1792  CA  LEU A 230       6.833  33.323 -14.374  1.00 41.92           C  
ATOM   1793  C   LEU A 230       6.285  31.899 -14.187  1.00 41.96           C  
ATOM   1794  O   LEU A 230       7.048  30.973 -13.932  1.00 41.87           O  
ATOM   1795  CB  LEU A 230       6.862  34.069 -13.042  1.00 41.83           C  
ATOM   1796  CG  LEU A 230       7.393  35.508 -13.126  1.00 42.88           C  
ATOM   1797  CD1 LEU A 230       6.966  36.321 -11.881  1.00 41.95           C  
ATOM   1798  CD2 LEU A 230       8.922  35.539 -13.370  1.00 42.90           C  
ATOM   1799  N   ALA A 231       4.966  31.739 -14.309  1.00 43.11           N  
ATOM   1800  CA  ALA A 231       4.305  30.415 -14.241  1.00 43.82           C  
ATOM   1801  C   ALA A 231       4.711  29.464 -15.365  1.00 44.51           C  
ATOM   1802  O   ALA A 231       4.846  28.259 -15.142  1.00 44.59           O  
ATOM   1803  CB  ALA A 231       2.799  30.568 -14.214  1.00 43.26           C  
ATOM   1804  N   ARG A 232       4.899  30.012 -16.563  1.00 45.95           N  
ATOM   1805  CA  ARG A 232       5.295  29.230 -17.745  1.00 47.24           C  
ATOM   1806  C   ARG A 232       6.809  29.211 -17.939  1.00 48.47           C  
ATOM   1807  O   ARG A 232       7.322  28.464 -18.776  1.00 48.16           O  
ATOM   1808  CB  ARG A 232       4.639  29.789 -19.007  1.00 46.77           C  
ATOM   1809  CG  ARG A 232       3.108  29.787 -19.000  1.00 46.90           C  
ATOM   1810  CD  ARG A 232       2.510  28.442 -19.456  1.00 46.49           C  
ATOM   1811  NE  ARG A 232       2.789  27.289 -18.586  1.00 46.79           N  
ATOM   1812  CZ  ARG A 232       2.332  27.123 -17.339  1.00 47.23           C  
ATOM   1813  NH1 ARG A 232       1.585  28.055 -16.747  1.00 46.12           N  
ATOM   1814  NH2 ARG A 232       2.650  26.018 -16.666  1.00 46.12           N  
ATOM   1815  N   ALA A 233       7.514  30.038 -17.163  1.00 49.71           N  
ATOM   1816  CA  ALA A 233       8.961  30.164 -17.282  1.00 51.33           C  
ATOM   1817  C   ALA A 233       9.673  28.886 -16.844  1.00 52.50           C  
ATOM   1818  O   ALA A 233       9.330  28.279 -15.826  1.00 52.45           O  
ATOM   1819  CB  ALA A 233       9.474  31.381 -16.490  1.00 51.23           C  
ATOM   1820  N   GLU A 234      10.656  28.479 -17.635  1.00 54.28           N  
ATOM   1821  CA  GLU A 234      11.495  27.336 -17.299  1.00 56.11           C  
ATOM   1822  C   GLU A 234      12.666  27.763 -16.392  1.00 56.63           C  
ATOM   1823  O   GLU A 234      13.150  26.967 -15.582  1.00 56.59           O  
ATOM   1824  CB  GLU A 234      11.997  26.659 -18.580  1.00 56.02           C  
ATOM   1825  CG  GLU A 234      12.034  25.129 -18.518  1.00 57.19           C  
ATOM   1826  CD  GLU A 234      12.281  24.475 -19.886  1.00 57.54           C  
ATOM   1827  OE1 GLU A 234      12.803  25.158 -20.803  1.00 59.24           O  
ATOM   1828  OE2 GLU A 234      11.957  23.271 -20.041  1.00 58.33           O  
ATOM   1829  N   ARG A 235      13.102  29.014 -16.543  1.00 57.60           N  
ATOM   1830  CA  ARG A 235      14.157  29.617 -15.715  1.00 59.07           C  
ATOM   1831  C   ARG A 235      13.721  31.025 -15.319  1.00 59.11           C  
ATOM   1832  O   ARG A 235      12.928  31.643 -16.038  1.00 59.07           O  
ATOM   1833  CB  ARG A 235      15.471  29.680 -16.512  1.00 59.58           C  
ATOM   1834  CG  ARG A 235      16.753  29.912 -15.689  1.00 61.71           C  
ATOM   1835  CD  ARG A 235      17.986  29.323 -16.393  1.00 65.36           C  
ATOM   1836  NE  ARG A 235      17.946  27.853 -16.488  1.00 67.31           N  
ATOM   1837  CZ  ARG A 235      18.733  27.111 -17.278  1.00 69.00           C  
ATOM   1838  NH1 ARG A 235      19.634  27.684 -18.070  1.00 68.58           N  
ATOM   1839  NH2 ARG A 235      18.615  25.783 -17.281  1.00 69.13           N  
ATOM   1840  N   TRP A 236      14.236  31.546 -14.203  1.00 59.22           N  
ATOM   1841  CA  TRP A 236      13.912  32.931 -13.821  1.00 59.74           C  
ATOM   1842  C   TRP A 236      14.461  33.942 -14.855  1.00 61.16           C  
ATOM   1843  O   TRP A 236      15.656  33.908 -15.182  1.00 61.56           O  
ATOM   1844  CB  TRP A 236      14.363  33.287 -12.388  1.00 58.05           C  
ATOM   1845  CG  TRP A 236      13.492  34.372 -11.806  1.00 56.35           C  
ATOM   1846  CD1 TRP A 236      13.577  35.719 -12.050  1.00 54.97           C  
ATOM   1847  CD2 TRP A 236      12.378  34.198 -10.925  1.00 54.64           C  
ATOM   1848  NE1 TRP A 236      12.585  36.392 -11.372  1.00 53.99           N  
ATOM   1849  CE2 TRP A 236      11.839  35.483 -10.669  1.00 53.93           C  
ATOM   1850  CE3 TRP A 236      11.784  33.082 -10.315  1.00 54.44           C  
ATOM   1851  CZ2 TRP A 236      10.738  35.678  -9.836  1.00 54.33           C  
ATOM   1852  CZ3 TRP A 236      10.686  33.280  -9.486  1.00 54.36           C  
ATOM   1853  CH2 TRP A 236      10.173  34.565  -9.259  1.00 54.96           C  
ATOM   1854  N   PRO A 237      13.583  34.820 -15.395  1.00 62.26           N  
ATOM   1855  CA  PRO A 237      14.009  35.785 -16.422  1.00 63.44           C  
ATOM   1856  C   PRO A 237      14.851  36.965 -15.906  1.00 64.57           C  
ATOM   1857  O   PRO A 237      14.745  37.355 -14.737  1.00 65.07           O  
ATOM   1858  CB  PRO A 237      12.680  36.291 -16.999  1.00 63.22           C  
ATOM   1859  CG  PRO A 237      11.705  36.146 -15.889  1.00 62.60           C  
ATOM   1860  CD  PRO A 237      12.138  34.929 -15.105  1.00 62.28           C  
ATOM   1861  N   THR A 238      15.676  37.517 -16.796  1.00 65.98           N  
ATOM   1862  CA  THR A 238      16.434  38.758 -16.550  1.00 66.93           C  
ATOM   1863  C   THR A 238      15.514  39.977 -16.308  1.00 67.23           C  
ATOM   1864  O   THR A 238      14.490  40.137 -16.978  1.00 67.00           O  
ATOM   1865  CB  THR A 238      17.456  39.048 -17.711  1.00 67.19           C  
ATOM   1866  OG1 THR A 238      17.680  40.462 -17.830  1.00 68.01           O  
ATOM   1867  CG2 THR A 238      16.955  38.500 -19.069  1.00 67.30           C  
ATOM   1868  N   VAL A 239      15.890  40.823 -15.346  1.00 67.82           N  
ATOM   1869  CA  VAL A 239      15.061  41.978 -14.962  1.00 68.26           C  
ATOM   1870  C   VAL A 239      15.384  43.223 -15.807  1.00 68.45           C  
ATOM   1871  O   VAL A 239      16.536  43.655 -15.892  1.00 68.91           O  
ATOM   1872  CB  VAL A 239      15.132  42.286 -13.422  1.00 68.14           C  
ATOM   1873  CG1 VAL A 239      14.197  43.433 -13.045  1.00 68.38           C  
ATOM   1874  CG2 VAL A 239      14.788  41.044 -12.601  1.00 67.76           C  
TER    1875      VAL A 239                                                      
END
MOLECULE T0506.pdb
ATOM      1  N   VAL     4      16.223  74.529   6.413  1.00 43.65           N  
ATOM      2  CA  VAL     4      17.370  74.880   7.304  1.00 43.82           C  
ATOM      3  C   VAL     4      17.963  73.638   8.008  1.00 43.97           C  
ATOM      4  O   VAL     4      19.114  73.665   8.459  1.00 44.37           O  
ATOM      5  CB  VAL     4      16.969  76.004   8.316  1.00 43.84           C  
ATOM      6  CG1 VAL     4      18.109  76.346   9.267  1.00 44.06           C  
ATOM      7  CG2 VAL     4      16.529  77.270   7.571  1.00 43.89           C  
ATOM      8  N   ALA     5      17.192  72.548   8.063  1.00 43.79           N  
ATOM      9  CA  ALA     5      17.573  71.332   8.805  1.00 43.55           C  
ATOM     10  C   ALA     5      18.661  70.477   8.131  1.00 43.26           C  
ATOM     11  O   ALA     5      18.524  70.078   6.973  1.00 42.98           O  
ATOM     12  CB  ALA     5      16.339  70.479   9.111  1.00 43.90           C  
ATOM     13  N   PRO     6      19.740  70.170   8.871  1.00 43.22           N  
ATOM     14  CA  PRO     6      20.844  69.368   8.331  1.00 42.95           C  
ATOM     15  C   PRO     6      20.447  67.919   7.950  1.00 42.45           C  
ATOM     16  O   PRO     6      19.464  67.374   8.487  1.00 41.77           O  
ATOM     17  CB  PRO     6      21.854  69.359   9.484  1.00 43.23           C  
ATOM     18  CG  PRO     6      21.006  69.553  10.707  1.00 43.87           C  
ATOM     19  CD  PRO     6      19.985  70.552  10.274  1.00 43.24           C  
ATOM     20  N   PRO     7      21.198  67.301   7.015  1.00 41.83           N  
ATOM     21  CA  PRO     7      20.961  65.893   6.726  1.00 41.46           C  
ATOM     22  C   PRO     7      20.933  65.068   8.016  1.00 40.74           C  
ATOM     23  O   PRO     7      21.728  65.315   8.930  1.00 40.20           O  
ATOM     24  CB  PRO     7      22.164  65.498   5.854  1.00 42.16           C  
ATOM     25  CG  PRO     7      23.099  66.664   5.880  1.00 41.75           C  
ATOM     26  CD  PRO     7      22.276  67.858   6.180  1.00 41.68           C  
ATOM     27  N   VAL     8      19.999  64.129   8.112  1.00 40.33           N  
ATOM     28  CA  VAL     8      19.881  63.318   9.347  1.00 39.91           C  
ATOM     29  C   VAL     8      21.138  62.431   9.570  1.00 40.27           C  
ATOM     30  O   VAL     8      21.506  62.089  10.707  1.00 40.37           O  
ATOM     31  CB  VAL     8      18.516  62.556   9.435  1.00 39.67           C  
ATOM     32  CG1 VAL     8      17.329  63.555   9.348  1.00 36.98           C  
ATOM     33  CG2 VAL     8      18.390  61.517   8.365  1.00 38.22           C  
ATOM     34  N   ILE     9      21.801  62.086   8.475  1.00 40.55           N  
ATOM     35  CA  ILE     9      23.080  61.402   8.548  1.00 40.74           C  
ATOM     36  C   ILE     9      24.104  62.396   8.056  1.00 40.78           C  
ATOM     37  O   ILE     9      24.011  62.841   6.917  1.00 41.63           O  
ATOM     38  CB  ILE     9      23.118  60.143   7.647  1.00 40.61           C  
ATOM     39  CG1 ILE     9      21.953  59.189   7.985  1.00 41.00           C  
ATOM     40  CG2 ILE     9      24.517  59.462   7.731  1.00 39.79           C  
ATOM     41  CD1 ILE     9      21.690  58.061   6.971  1.00 40.63           C  
ATOM     42  N   THR    10      25.056  62.771   8.909  1.00 40.43           N  
ATOM     43  CA  THR    10      26.176  63.599   8.483  1.00 40.73           C  
ATOM     44  C   THR    10      27.078  62.807   7.534  1.00 40.81           C  
ATOM     45  O   THR    10      27.550  61.725   7.907  1.00 41.55           O  
ATOM     46  CB  THR    10      26.948  64.128   9.696  1.00 40.40           C  
ATOM     47  OG1 THR    10      26.031  64.861  10.516  1.00 39.93           O  
ATOM     48  CG2 THR    10      28.134  65.030   9.289  1.00 40.89           C  
ATOM     49  N   PRO    11      27.264  63.306   6.290  1.00 40.27           N  
ATOM     50  CA  PRO    11      28.106  62.635   5.300  1.00 40.30           C  
ATOM     51  C   PRO    11      29.531  62.424   5.796  1.00 40.59           C  
ATOM     52  O   PRO    11      30.089  63.270   6.519  1.00 40.09           O  
ATOM     53  CB  PRO    11      28.124  63.627   4.123  1.00 39.98           C  
ATOM     54  CG  PRO    11      26.898  64.368   4.249  1.00 39.70           C  
ATOM     55  CD  PRO    11      26.687  64.541   5.731  1.00 40.75           C  
ATOM     56  N   ARG    12      30.113  61.303   5.387  1.00 41.07           N  
ATOM     57  CA  ARG    12      31.472  60.953   5.767  1.00 41.14           C  
ATOM     58  C   ARG    12      32.453  61.993   5.258  1.00 41.53           C  
ATOM     59  O   ARG    12      33.228  62.542   6.035  1.00 41.73           O  
ATOM     60  CB  ARG    12      31.835  59.577   5.213  1.00 41.12           C  
ATOM     61  CG  ARG    12      32.473  58.648   6.214  1.00 39.82           C  
ATOM     62  CD  ARG    12      33.423  59.386   7.103  1.00 37.35           C  
ATOM     63  NE  ARG    12      34.538  58.566   7.537  1.00 35.24           N  
ATOM     64  CZ  ARG    12      35.491  59.009   8.340  1.00 36.29           C  
ATOM     65  NH1 ARG    12      35.452  60.263   8.767  1.00 35.93           N  
ATOM     66  NH2 ARG    12      36.488  58.210   8.710  1.00 36.57           N  
ATOM     67  N   PHE    24      26.609  45.777  -8.751  1.00 49.65           N  
ATOM     68  CA  PHE    24      26.051  46.396  -7.541  1.00 49.63           C  
ATOM     69  C   PHE    24      25.420  47.733  -7.925  1.00 48.93           C  
ATOM     70  O   PHE    24      26.123  48.667  -8.335  1.00 49.03           O  
ATOM     71  CB  PHE    24      27.132  46.601  -6.452  1.00 49.78           C  
ATOM     72  CG  PHE    24      26.616  47.272  -5.196  1.00 50.83           C  
ATOM     73  CD1 PHE    24      26.081  46.515  -4.146  1.00 50.02           C  
ATOM     74  CD2 PHE    24      26.659  48.674  -5.061  1.00 51.88           C  
ATOM     75  CE1 PHE    24      25.585  47.152  -2.977  1.00 50.73           C  
ATOM     76  CE2 PHE    24      26.163  49.313  -3.901  1.00 50.87           C  
ATOM     77  CZ  PHE    24      25.627  48.551  -2.863  1.00 49.25           C  
ATOM     78  N   GLU    25      24.099  47.813  -7.832  1.00 47.53           N  
ATOM     79  CA  GLU    25      23.428  49.088  -8.068  1.00 46.43           C  
ATOM     80  C   GLU    25      22.710  49.488  -6.817  1.00 44.86           C  
ATOM     81  O   GLU    25      21.685  48.901  -6.451  1.00 45.13           O  
ATOM     82  CB  GLU    25      22.471  49.047  -9.256  1.00 47.06           C  
ATOM     83  CG  GLU    25      22.225  50.443  -9.881  1.00 47.24           C  
ATOM     84  CD  GLU    25      21.172  51.248  -9.119  1.00 46.10           C  
ATOM     85  OE1 GLU    25      21.561  52.100  -8.295  1.00 45.74           O  
ATOM     86  OE2 GLU    25      19.958  51.022  -9.342  1.00 44.94           O  
ATOM     87  N   ALA    26      23.264  50.509  -6.181  1.00 43.10           N  
ATOM     88  CA  ALA    26      22.889  50.896  -4.846  1.00 42.10           C  
ATOM     89  C   ALA    26      21.383  50.862  -4.620  1.00 41.22           C  
ATOM     90  O   ALA    26      20.938  50.241  -3.667  1.00 41.52           O  
ATOM     91  CB  ALA    26      23.459  52.259  -4.514  1.00 42.27           C  
ATOM     92  N   VAL    27      20.618  51.503  -5.507  1.00 39.82           N  
ATOM     93  CA  VAL    27      19.170  51.685  -5.330  1.00 38.62           C  
ATOM     94  C   VAL    27      18.441  50.333  -5.389  1.00 38.25           C  
ATOM     95  O   VAL    27      17.627  50.011  -4.527  1.00 38.38           O  
ATOM     96  CB  VAL    27      18.586  52.704  -6.353  1.00 37.58           C  
ATOM     97  CG1 VAL    27      17.069  52.638  -6.404  1.00 37.20           C  
ATOM     98  CG2 VAL    27      19.050  54.113  -6.001  1.00 37.77           C  
ATOM     99  N   ARG    28      18.794  49.533  -6.374  1.00 38.45           N  
ATOM    100  CA  ARG    28      18.189  48.223  -6.565  1.00 39.15           C  
ATOM    101  C   ARG    28      18.541  47.242  -5.432  1.00 38.81           C  
ATOM    102  O   ARG    28      17.647  46.634  -4.831  1.00 39.72           O  
ATOM    103  CB  ARG    28      18.559  47.687  -7.963  1.00 38.85           C  
ATOM    104  CG  ARG    28      18.278  46.216  -8.142  1.00 41.94           C  
ATOM    105  CD  ARG    28      16.816  45.790  -7.837  1.00 45.21           C  
ATOM    106  NE  ARG    28      16.439  44.831  -8.874  1.00 51.01           N  
ATOM    107  CZ  ARG    28      16.676  43.525  -8.835  1.00 49.95           C  
ATOM    108  NH1 ARG    28      17.225  42.961  -7.766  1.00 50.06           N  
ATOM    109  NH2 ARG    28      16.313  42.783  -9.854  1.00 49.70           N  
ATOM    110  N   VAL    29      19.822  47.129  -5.087  1.00 38.22           N  
ATOM    111  CA  VAL    29      20.219  46.316  -3.927  1.00 37.36           C  
ATOM    112  C   VAL    29      19.496  46.775  -2.649  1.00 36.79           C  
ATOM    113  O   VAL    29      19.018  45.955  -1.848  1.00 36.89           O  
ATOM    114  CB  VAL    29      21.772  46.348  -3.708  1.00 37.56           C  
ATOM    115  CG1 VAL    29      22.144  45.746  -2.370  1.00 37.50           C  
ATOM    116  CG2 VAL    29      22.494  45.612  -4.819  1.00 37.85           C  
ATOM    117  N   ALA    30      19.421  48.097  -2.454  1.00 35.35           N  
ATOM    118  CA  ALA    30      18.687  48.682  -1.336  1.00 34.46           C  
ATOM    119  C   ALA    30      17.203  48.317  -1.292  1.00 33.63           C  
ATOM    120  O   ALA    30      16.700  47.953  -0.243  1.00 33.01           O  
ATOM    121  CB  ALA    30      18.851  50.228  -1.333  1.00 33.58           C  
ATOM    122  N   ARG    31      16.515  48.424  -2.422  1.00 32.99           N  
ATOM    123  CA  ARG    31      15.084  48.146  -2.496  1.00 34.07           C  
ATOM    124  C   ARG    31      14.826  46.663  -2.284  1.00 33.95           C  
ATOM    125  O   ARG    31      13.803  46.281  -1.725  1.00 35.51           O  
ATOM    126  CB  ARG    31      14.481  48.670  -3.812  1.00 33.27           C  
ATOM    127  CG  ARG    31      14.226  50.179  -3.744  1.00 34.01           C  
ATOM    128  CD  ARG    31      13.577  50.726  -5.019  1.00 35.99           C  
ATOM    129  NE  ARG    31      12.143  50.433  -5.017  1.00 33.98           N  
ATOM    130  CZ  ARG    31      11.416  50.411  -6.115  1.00 38.90           C  
ATOM    131  NH1 ARG    31      12.005  50.704  -7.262  1.00 31.97           N  
ATOM    132  NH2 ARG    31      10.110  50.128  -6.060  1.00 42.34           N  
ATOM    133  N   ASP    32      15.778  45.838  -2.686  1.00 34.58           N  
ATOM    134  CA  ASP    32      15.679  44.398  -2.466  0.50 35.02           C  
ATOM    136  C   ASP    32      15.826  44.056  -1.006  1.00 34.99           C  
ATOM    137  O   ASP    32      15.045  43.274  -0.480  1.00 35.71           O  
ATOM    138  CB  ASP    32      16.723  43.631  -3.275  0.50 34.91           C  
ATOM    140  CG  ASP    32      16.252  42.240  -3.643  0.50 37.60           C  
ATOM    142  OD1 ASP    32      15.113  42.109  -4.168  0.50 37.96           O  
ATOM    144  OD2 ASP    32      17.027  41.278  -3.431  0.50 39.94           O  
ATOM    146  N   VAL    33      16.799  44.665  -0.335  1.00 35.69           N  
ATOM    147  CA  VAL    33      16.952  44.479   1.129  1.00 35.38           C  
ATOM    148  C   VAL    33      15.725  44.991   1.852  1.00 36.91           C  
ATOM    149  O   VAL    33      15.266  44.403   2.861  1.00 37.01           O  
ATOM    150  CB  VAL    33      18.200  45.234   1.681  1.00 35.08           C  
ATOM    151  CG1 VAL    33      18.291  45.100   3.203  1.00 35.22           C  
ATOM    152  CG2 VAL    33      19.474  44.688   1.037  1.00 33.53           C  
ATOM    153  N   LEU    34      15.223  46.132   1.383  1.00 36.92           N  
ATOM    154  CA  LEU    34      14.044  46.713   1.963  1.00 37.55           C  
ATOM    155  C   LEU    34      12.872  45.725   1.973  1.00 37.09           C  
ATOM    156  O   LEU    34      12.183  45.569   3.011  1.00 37.29           O  
ATOM    157  CB  LEU    34      13.635  47.981   1.239  1.00 37.10           C  
ATOM    158  CG  LEU    34      12.325  48.656   1.652  1.00 36.56           C  
ATOM    159  CD1 LEU    34      12.382  49.294   3.019  1.00 35.33           C  
ATOM    160  CD2 LEU    34      12.021  49.705   0.548  1.00 33.63           C  
ATOM    161  N   HIS    35      12.674  45.055   0.852  1.00 36.94           N  
ATOM    162  CA  HIS    35      11.488  44.235   0.692  1.00 37.17           C  
ATOM    163  C   HIS    35      11.613  42.812   1.221  1.00 37.43           C  
ATOM    164  O   HIS    35      10.598  42.106   1.372  1.00 36.36           O  
ATOM    165  CB  HIS    35      11.031  44.238  -0.765  1.00 36.90           C  
ATOM    166  CG  HIS    35      10.298  45.502  -1.165  1.00 37.86           C  
ATOM    167  ND1 HIS    35       8.920  45.593  -1.165  1.00 38.07           N  
ATOM    168  CD2 HIS    35      10.751  46.717  -1.569  1.00 36.41           C  
ATOM    169  CE1 HIS    35       8.553  46.819  -1.526  1.00 36.43           C  
ATOM    170  NE2 HIS    35       9.647  47.517  -1.784  1.00 36.29           N  
ATOM    171  N   THR    36      12.843  42.372   1.438  1.00 36.97           N  
ATOM    172  CA  THR    36      13.079  40.969   1.718  1.00 37.62           C  
ATOM    173  C   THR    36      13.741  40.752   3.075  1.00 38.16           C  
ATOM    174  O   THR    36      14.194  39.635   3.373  1.00 38.65           O  
ATOM    175  CB  THR    36      13.897  40.253   0.588  1.00 39.04           C  
ATOM    176  OG1 THR    36      15.189  40.884   0.435  1.00 37.71           O  
ATOM    177  CG2 THR    36      13.146  40.274  -0.759  1.00 37.27           C  
ATOM    178  N   SER    37      13.811  41.788   3.890  1.00 37.79           N  
ATOM    179  CA  SER    37      14.363  41.613   5.263  1.00 39.48           C  
ATOM    180  C   SER    37      13.260  41.475   6.314  1.00 38.86           C  
ATOM    181  O   SER    37      12.412  42.358   6.422  1.00 38.51           O  
ATOM    182  CB  SER    37      15.345  42.762   5.618  1.00 38.38           C  
ATOM    183  OG  SER    37      16.371  42.838   4.608  1.00 41.05           O  
ATOM    184  N   ARG    38      13.268  40.369   7.076  1.00 39.77           N  
ATOM    185  CA  ARG    38      12.327  40.179   8.211  1.00 41.34           C  
ATOM    186  C   ARG    38      12.758  40.914   9.477  1.00 42.43           C  
ATOM    187  O   ARG    38      11.968  41.608  10.100  1.00 42.17           O  
ATOM    188  CB  ARG    38      12.100  38.691   8.578  1.00 41.21           C  
ATOM    189  CG  ARG    38      10.919  38.002   7.837  1.00 42.35           C  
ATOM    190  CD  ARG    38      10.623  36.515   8.413  1.00 44.16           C  
ATOM    191  NE  ARG    38       9.250  36.088   8.125  1.00 48.27           N  
ATOM    192  CZ  ARG    38       8.909  35.290   7.123  1.00 48.91           C  
ATOM    193  NH1 ARG    38       7.635  34.955   6.942  1.00 48.62           N  
ATOM    194  NH2 ARG    38       9.846  34.775   6.322  1.00 51.54           N  
ATOM    195  N   THR    39      14.015  40.742   9.867  1.00 43.04           N  
ATOM    196  CA  THR    39      14.487  41.282  11.126  1.00 43.56           C  
ATOM    197  C   THR    39      15.269  42.567  10.903  1.00 43.75           C  
ATOM    198  O   THR    39      16.001  42.696   9.921  1.00 43.67           O  
ATOM    199  CB  THR    39      15.318  40.257  11.910  1.00 43.91           C  
ATOM    200  OG1 THR    39      14.552  39.053  12.056  1.00 45.50           O  
ATOM    201  CG2 THR    39      15.640  40.777  13.315  1.00 44.70           C  
ATOM    202  N   ALA    40      15.033  43.524  11.799  1.00 41.52           N  
ATOM    203  CA  ALA    40      15.651  44.828  11.787  1.00 40.98           C  
ATOM    204  C   ALA    40      16.237  45.164  13.169  1.00 40.63           C  
ATOM    205  O   ALA    40      15.643  44.853  14.180  1.00 40.12           O  
ATOM    206  CB  ALA    40      14.604  45.873  11.432  1.00 41.19           C  
ATOM    207  N   ALA    41      17.418  45.765  13.177  1.00 39.80           N  
ATOM    208  CA  ALA    41      17.920  46.465  14.324  1.00 38.78           C  
ATOM    209  C   ALA    41      17.158  47.790  14.407  1.00 39.25           C  
ATOM    210  O   ALA    41      16.861  48.426  13.397  1.00 38.98           O  
ATOM    211  CB  ALA    41      19.416  46.708  14.140  1.00 39.12           C  
ATOM    212  N   LEU    42      16.797  48.193  15.623  1.00 38.68           N  
ATOM    213  CA  LEU    42      16.037  49.406  15.853  1.00 39.79           C  
ATOM    214  C   LEU    42      16.785  50.125  16.957  1.00 39.98           C  
ATOM    215  O   LEU    42      17.011  49.536  18.044  1.00 38.61           O  
ATOM    216  CB  LEU    42      14.655  49.049  16.433  1.00 40.02           C  
ATOM    217  CG  LEU    42      13.458  50.015  16.368  1.00 43.63           C  
ATOM    218  CD1 LEU    42      12.539  49.898  17.612  1.00 42.40           C  
ATOM    219  CD2 LEU    42      13.771  51.474  16.022  1.00 39.93           C  
ATOM    220  N   ALA    43      17.123  51.378  16.688  1.00 38.14           N  
ATOM    221  CA  ALA    43      17.741  52.250  17.656  1.00 38.67           C  
ATOM    222  C   ALA    43      16.827  53.423  17.999  1.00 39.37           C  
ATOM    223  O   ALA    43      16.177  54.035  17.134  1.00 40.23           O  
ATOM    224  CB  ALA    43      19.111  52.747  17.153  1.00 38.06           C  
ATOM    225  N   THR    44      16.877  53.783  19.273  1.00 39.46           N  
ATOM    226  CA  THR    44      15.964  54.691  19.898  1.00 38.96           C  
ATOM    227  C   THR    44      16.884  55.530  20.822  1.00 38.63           C  
ATOM    228  O   THR    44      18.054  55.168  21.043  1.00 38.06           O  
ATOM    229  CB  THR    44      14.985  53.702  20.568  1.00 40.23           C  
ATOM    230  OG1 THR    44      13.679  53.682  19.961  1.00 45.89           O  
ATOM    231  CG2 THR    44      15.079  53.504  22.014  1.00 33.78           C  
ATOM    232  N   LEU    45      16.389  56.659  21.328  1.00 38.88           N  
ATOM    233  CA  LEU    45      17.207  57.508  22.210  1.00 38.18           C  
ATOM    234  C   LEU    45      16.689  57.522  23.642  1.00 38.60           C  
ATOM    235  O   LEU    45      15.488  57.696  23.887  1.00 39.08           O  
ATOM    236  CB  LEU    45      17.306  58.953  21.676  1.00 38.20           C  
ATOM    237  CG  LEU    45      17.965  59.257  20.311  1.00 38.94           C  
ATOM    238  CD1 LEU    45      17.732  60.739  19.933  1.00 35.37           C  
ATOM    239  CD2 LEU    45      19.475  58.944  20.302  1.00 34.51           C  
ATOM    240  N   ASP    46      17.602  57.365  24.594  1.00 38.81           N  
ATOM    241  CA  ASP    46      17.234  57.458  25.978  1.00 38.11           C  
ATOM    242  C   ASP    46      16.965  58.919  26.355  1.00 38.82           C  
ATOM    243  O   ASP    46      17.782  59.804  26.077  1.00 39.17           O  
ATOM    244  CB  ASP    46      18.269  56.823  26.873  1.00 37.52           C  
ATOM    245  CG  ASP    46      17.782  56.687  28.297  1.00 38.27           C  
ATOM    246  OD1 ASP    46      17.801  57.702  29.037  1.00 39.29           O  
ATOM    247  OD2 ASP    46      17.353  55.572  28.670  1.00 39.12           O  
ATOM    248  N   PRO    47      15.793  59.181  26.968  1.00 39.51           N  
ATOM    249  CA  PRO    47      15.406  60.562  27.316  1.00 39.59           C  
ATOM    250  C   PRO    47      16.261  61.296  28.350  1.00 39.85           C  
ATOM    251  O   PRO    47      16.218  62.528  28.393  1.00 41.11           O  
ATOM    252  CB  PRO    47      13.972  60.421  27.810  1.00 39.48           C  
ATOM    253  CG  PRO    47      13.786  59.014  28.136  1.00 39.84           C  
ATOM    254  CD  PRO    47      14.738  58.210  27.302  1.00 39.29           C  
ATOM    255  N   VAL    48      16.978  60.575  29.215  1.00 39.58           N  
ATOM    256  CA  VAL    48      17.764  61.207  30.288  1.00 38.34           C  
ATOM    257  C   VAL    48      19.253  61.154  29.955  1.00 37.75           C  
ATOM    258  O   VAL    48      19.960  62.160  30.031  1.00 36.21           O  
ATOM    259  CB  VAL    48      17.522  60.535  31.703  1.00 38.53           C  
ATOM    260  CG1 VAL    48      18.371  61.189  32.800  1.00 38.22           C  
ATOM    261  CG2 VAL    48      16.045  60.571  32.106  1.00 38.99           C  
ATOM    262  N   SER    49      19.719  59.969  29.570  1.00 37.22           N  
ATOM    263  CA  SER    49      21.152  59.725  29.436  1.00 37.08           C  
ATOM    264  C   SER    49      21.684  60.192  28.093  1.00 37.18           C  
ATOM    265  O   SER    49      22.841  60.545  27.976  1.00 37.79           O  
ATOM    266  CB  SER    49      21.474  58.250  29.669  1.00 37.19           C  
ATOM    267  OG  SER    49      20.872  57.441  28.663  1.00 35.06           O  
ATOM    268  N   GLY    50      20.835  60.174  27.079  1.00 38.39           N  
ATOM    269  CA  GLY    50      21.214  60.622  25.742  1.00 38.15           C  
ATOM    270  C   GLY    50      21.913  59.521  24.969  1.00 36.98           C  
ATOM    271  O   GLY    50      22.166  59.670  23.775  1.00 37.41           O  
ATOM    272  N   TYR    51      22.211  58.412  25.651  1.00 35.98           N  
ATOM    273  CA  TYR    51      22.733  57.203  25.004  1.00 34.74           C  
ATOM    274  C   TYR    51      21.698  56.630  24.013  1.00 34.55           C  
ATOM    275  O   TYR    51      20.453  56.775  24.230  1.00 35.08           O  
ATOM    276  CB  TYR    51      23.047  56.109  26.039  1.00 33.87           C  
ATOM    277  CG  TYR    51      24.321  56.276  26.852  1.00 33.36           C  
ATOM    278  CD1 TYR    51      25.393  55.409  26.676  1.00 32.99           C  
ATOM    279  CD2 TYR    51      24.442  57.298  27.780  1.00 33.00           C  
ATOM    280  CE1 TYR    51      26.558  55.551  27.429  1.00 34.11           C  
ATOM    281  CE2 TYR    51      25.600  57.456  28.550  1.00 35.12           C  
ATOM    282  CZ  TYR    51      26.653  56.575  28.352  1.00 34.84           C  
ATOM    283  OH  TYR    51      27.786  56.715  29.074  1.00 32.74           O  
ATOM    284  N   PRO    52      22.191  55.951  22.950  1.00 34.99           N  
ATOM    285  CA  PRO    52      21.241  55.231  22.109  1.00 34.67           C  
ATOM    286  C   PRO    52      20.776  53.982  22.843  1.00 35.35           C  
ATOM    287  O   PRO    52      21.419  53.563  23.835  1.00 34.36           O  
ATOM    288  CB  PRO    52      22.052  54.874  20.842  1.00 35.16           C  
ATOM    289  CG  PRO    52      23.495  54.940  21.259  1.00 34.77           C  
ATOM    290  CD  PRO    52      23.602  55.799  22.497  1.00 34.82           C  
ATOM    291  N   TYR    53      19.673  53.403  22.378  1.00 35.86           N  
ATOM    292  CA  TYR    53      19.173  52.180  22.965  1.00 36.96           C  
ATOM    293  C   TYR    53      18.667  51.328  21.811  1.00 36.80           C  
ATOM    294  O   TYR    53      17.880  51.791  21.003  1.00 37.91           O  
ATOM    295  CB  TYR    53      18.040  52.462  24.003  1.00 36.72           C  
ATOM    296  CG  TYR    53      17.422  51.187  24.528  1.00 38.05           C  
ATOM    297  CD1 TYR    53      17.975  50.523  25.627  1.00 38.59           C  
ATOM    298  CD2 TYR    53      16.305  50.606  23.893  1.00 37.83           C  
ATOM    299  CE1 TYR    53      17.424  49.341  26.105  1.00 39.91           C  
ATOM    300  CE2 TYR    53      15.747  49.416  24.370  1.00 39.19           C  
ATOM    301  CZ  TYR    53      16.310  48.792  25.458  1.00 38.48           C  
ATOM    302  OH  TYR    53      15.774  47.610  25.907  1.00 40.55           O  
ATOM    303  N   THR    54      19.131  50.080  21.734  1.00 37.35           N  
ATOM    304  CA  THR    54      18.820  49.210  20.616  1.00 36.80           C  
ATOM    305  C   THR    54      17.924  48.044  20.993  1.00 37.74           C  
ATOM    306  O   THR    54      17.930  47.569  22.152  1.00 37.88           O  
ATOM    307  CB  THR    54      20.095  48.663  19.947  1.00 37.33           C  
ATOM    308  OG1 THR    54      20.944  48.083  20.945  1.00 36.66           O  
ATOM    309  CG2 THR    54      20.831  49.750  19.249  1.00 37.47           C  
ATOM    310  N   THR    55      17.168  47.563  20.005  1.00 37.99           N  
ATOM    311  CA  THR    55      16.482  46.258  20.101  1.00 38.74           C  
ATOM    312  C   THR    55      16.468  45.581  18.733  1.00 38.58           C  
ATOM    313  O   THR    55      16.991  46.145  17.767  1.00 38.75           O  
ATOM    314  CB  THR    55      15.031  46.362  20.760  1.00 39.15           C  
ATOM    315  OG1 THR    55      14.547  45.043  21.053  1.00 42.34           O  
ATOM    316  CG2 THR    55      14.021  47.094  19.861  1.00 37.54           C  
ATOM    317  N   ALA    56      15.919  44.370  18.666  1.00 37.63           N  
ATOM    318  CA  ALA    56      15.601  43.697  17.415  1.00 38.20           C  
ATOM    319  C   ALA    56      14.083  43.590  17.259  1.00 38.64           C  
ATOM    320  O   ALA    56      13.374  43.290  18.226  1.00 38.50           O  
ATOM    321  CB  ALA    56      16.243  42.301  17.344  1.00 37.34           C  
ATOM    322  N   THR    57      13.593  43.808  16.043  1.00 38.00           N  
ATOM    323  CA  THR    57      12.144  43.750  15.804  1.00 39.69           C  
ATOM    324  C   THR    57      11.844  43.200  14.405  1.00 40.17           C  
ATOM    325  O   THR    57      12.767  43.030  13.611  1.00 39.47           O  
ATOM    326  CB  THR    57      11.479  45.144  16.054  1.00 39.51           C  
ATOM    327  OG1 THR    57      10.075  44.982  16.284  1.00 42.44           O  
ATOM    328  CG2 THR    57      11.769  46.175  14.922  1.00 37.64           C  
ATOM    329  N   ASN    58      10.569  42.905  14.141  1.00 39.45           N  
ATOM    330  CA  ASN    58      10.140  42.384  12.852  1.00 40.47           C  
ATOM    331  C   ASN    58       9.653  43.550  11.984  1.00 39.86           C  
ATOM    332  O   ASN    58       8.995  44.471  12.473  1.00 39.32           O  
ATOM    333  CB  ASN    58       8.964  41.419  13.043  1.00 39.87           C  
ATOM    334  CG  ASN    58       9.261  40.264  13.997  1.00 42.71           C  
ATOM    335  OD1 ASN    58      10.325  39.625  13.945  1.00 43.20           O  
ATOM    336  ND2 ASN    58       8.253  39.910  14.811  1.00 41.63           N  
ATOM    337  N   ILE    59       9.872  43.453  10.689  1.00 40.97           N  
ATOM    338  CA  ILE    59       9.529  44.518   9.723  1.00 41.64           C  
ATOM    339  C   ILE    59       8.358  44.133   8.821  1.00 42.78           C  
ATOM    340  O   ILE    59       8.394  43.067   8.117  1.00 41.24           O  
ATOM    341  CB  ILE    59      10.792  44.815   8.837  1.00 41.35           C  
ATOM    342  CG1 ILE    59      11.835  45.573   9.675  1.00 42.44           C  
ATOM    343  CG2 ILE    59      10.454  45.666   7.603  1.00 44.65           C  
ATOM    344  CD1 ILE    59      11.346  46.945  10.221  1.00 39.10           C  
ATOM    345  N   GLY    60       7.314  44.975   8.847  1.00 43.54           N  
ATOM    346  CA  GLY    60       6.265  44.917   7.809  1.00 43.52           C  
ATOM    347  C   GLY    60       6.563  45.946   6.702  1.00 43.16           C  
ATOM    348  O   GLY    60       7.319  46.877   6.917  1.00 41.80           O  
ATOM    349  N   ILE    61       6.013  45.756   5.504  1.00 42.96           N  
ATOM    350  CA  ILE    61       6.196  46.748   4.436  1.00 44.08           C  
ATOM    351  C   ILE    61       4.826  47.088   3.847  1.00 43.86           C  
ATOM    352  O   ILE    61       4.039  46.184   3.546  1.00 45.44           O  
ATOM    353  CB  ILE    61       7.164  46.288   3.289  1.00 45.00           C  
ATOM    354  CG1 ILE    61       8.525  45.853   3.795  1.00 47.28           C  
ATOM    355  CG2 ILE    61       7.534  47.453   2.427  1.00 44.58           C  
ATOM    356  CD1 ILE    61       9.499  47.050   4.107  1.00 51.63           C  
ATOM    357  N   GLU    62       4.548  48.376   3.660  1.00 41.87           N  
ATOM    358  CA  GLU    62       3.316  48.797   3.016  1.00 41.07           C  
ATOM    359  C   GLU    62       3.499  48.862   1.468  1.00 41.15           C  
ATOM    360  O   GLU    62       4.639  48.887   0.990  1.00 41.34           O  
ATOM    361  CB  GLU    62       2.863  50.132   3.623  1.00 39.56           C  
ATOM    362  CG  GLU    62       2.863  50.081   5.181  1.00 39.44           C  
ATOM    363  CD  GLU    62       2.347  51.371   5.819  1.00 42.98           C  
ATOM    364  OE1 GLU    62       1.600  51.268   6.823  1.00 43.58           O  
ATOM    365  OE2 GLU    62       2.685  52.470   5.299  1.00 39.51           O  
ATOM    366  N   PRO    63       2.390  48.847   0.695  1.00 40.53           N  
ATOM    367  CA  PRO    63       2.460  48.832  -0.787  1.00 40.41           C  
ATOM    368  C   PRO    63       3.454  49.832  -1.394  1.00 39.89           C  
ATOM    369  O   PRO    63       4.140  49.476  -2.317  1.00 40.56           O  
ATOM    370  CB  PRO    63       1.033  49.157  -1.198  1.00 39.57           C  
ATOM    371  CG  PRO    63       0.213  48.552  -0.087  1.00 40.59           C  
ATOM    372  CD  PRO    63       0.995  48.773   1.160  1.00 40.41           C  
ATOM    373  N   ASP    64       3.560  51.048  -0.853  1.00 40.36           N  
ATOM    374  CA  ASP    64       4.530  52.054  -1.340  1.00 40.96           C  
ATOM    375  C   ASP    64       5.987  51.837  -0.852  1.00 41.65           C  
ATOM    376  O   ASP    64       6.844  52.696  -1.079  1.00 43.12           O  
ATOM    377  CB  ASP    64       4.066  53.493  -1.017  1.00 39.69           C  
ATOM    378  CG  ASP    64       4.138  53.809   0.465  1.00 40.09           C  
ATOM    379  OD1 ASP    64       3.820  54.926   0.865  1.00 40.33           O  
ATOM    380  OD2 ASP    64       4.498  52.913   1.241  1.00 36.40           O  
ATOM    381  N   GLY    65       6.228  50.735  -0.150  1.00 42.72           N  
ATOM    382  CA  GLY    65       7.554  50.370   0.345  1.00 44.04           C  
ATOM    383  C   GLY    65       7.891  50.838   1.747  1.00 44.29           C  
ATOM    384  O   GLY    65       8.999  50.566   2.222  1.00 45.96           O  
ATOM    385  N   THR    66       6.937  51.499   2.422  1.00 42.92           N  
ATOM    386  CA  THR    66       7.145  52.061   3.760  1.00 40.94           C  
ATOM    387  C   THR    66       7.233  50.965   4.834  1.00 40.64           C  
ATOM    388  O   THR    66       6.277  50.188   4.993  1.00 39.14           O  
ATOM    389  CB  THR    66       6.021  53.044   4.171  1.00 40.87           C  
ATOM    390  OG1 THR    66       5.955  54.140   3.252  1.00 40.45           O  
ATOM    391  CG2 THR    66       6.306  53.607   5.551  1.00 39.21           C  
ATOM    392  N   PRO    67       8.368  50.910   5.573  1.00 40.41           N  
ATOM    393  CA  PRO    67       8.465  49.942   6.647  1.00 41.38           C  
ATOM    394  C   PRO    67       7.598  50.307   7.843  1.00 41.41           C  
ATOM    395  O   PRO    67       7.431  51.490   8.173  1.00 40.86           O  
ATOM    396  CB  PRO    67       9.946  49.979   7.045  1.00 41.94           C  
ATOM    397  CG  PRO    67      10.638  50.775   6.040  1.00 41.43           C  
ATOM    398  CD  PRO    67       9.595  51.719   5.491  1.00 40.36           C  
ATOM    399  N   PHE    68       7.052  49.277   8.506  1.00 40.81           N  
ATOM    400  CA  PHE    68       6.285  49.530   9.723  1.00 39.59           C  
ATOM    401  C   PHE    68       6.606  48.413  10.691  1.00 39.37           C  
ATOM    402  O   PHE    68       7.122  47.356  10.315  1.00 38.92           O  
ATOM    403  CB  PHE    68       4.757  49.696   9.440  1.00 38.61           C  
ATOM    404  CG  PHE    68       4.008  48.388   9.182  1.00 38.40           C  
ATOM    405  CD1 PHE    68       3.373  47.706  10.228  1.00 39.53           C  
ATOM    406  CD2 PHE    68       3.910  47.857   7.890  1.00 37.81           C  
ATOM    407  CE1 PHE    68       2.642  46.505   9.975  1.00 40.30           C  
ATOM    408  CE2 PHE    68       3.216  46.680   7.637  1.00 39.43           C  
ATOM    409  CZ  PHE    68       2.582  45.996   8.692  1.00 40.88           C  
ATOM    410  N   PHE    69       6.294  48.640  11.947  1.00 39.54           N  
ATOM    411  CA  PHE    69       6.642  47.671  12.957  1.00 39.34           C  
ATOM    412  C   PHE    69       5.764  47.887  14.204  1.00 38.68           C  
ATOM    413  O   PHE    69       5.059  48.905  14.332  1.00 38.42           O  
ATOM    414  CB  PHE    69       8.148  47.734  13.285  1.00 39.39           C  
ATOM    415  CG  PHE    69       8.605  49.071  13.808  1.00 40.13           C  
ATOM    416  CD1 PHE    69       8.609  49.334  15.181  1.00 37.66           C  
ATOM    417  CD2 PHE    69       9.055  50.060  12.934  1.00 40.27           C  
ATOM    418  CE1 PHE    69       9.039  50.590  15.678  1.00 40.43           C  
ATOM    419  CE2 PHE    69       9.487  51.301  13.407  1.00 39.29           C  
ATOM    420  CZ  PHE    69       9.483  51.566  14.796  1.00 42.12           C  
ATOM    421  N   PHE    70       5.835  46.889  15.076  1.00 38.05           N  
ATOM    422  CA  PHE    70       5.076  46.866  16.296  0.50 38.37           C  
ATOM    424  C   PHE    70       6.038  46.859  17.464  1.00 38.87           C  
ATOM    425  O   PHE    70       7.149  46.304  17.360  1.00 38.01           O  
ATOM    426  CB  PHE    70       4.186  45.615  16.328  0.50 38.34           C  
ATOM    428  CG  PHE    70       4.063  44.995  17.679  0.50 37.72           C  
ATOM    430  CD1 PHE    70       3.134  45.471  18.599  0.50 36.50           C  
ATOM    432  CD2 PHE    70       4.879  43.917  18.036  0.50 38.31           C  
ATOM    434  CE1 PHE    70       3.023  44.878  19.863  0.50 37.53           C  
ATOM    436  CE2 PHE    70       4.773  43.321  19.307  0.50 36.98           C  
ATOM    438  CZ  PHE    70       3.851  43.807  20.216  0.50 36.69           C  
ATOM    440  N   ALA    71       5.596  47.458  18.571  1.00 38.29           N  
ATOM    441  CA  ALA    71       6.344  47.406  19.823  1.00 38.96           C  
ATOM    442  C   ALA    71       5.331  47.251  20.949  1.00 39.61           C  
ATOM    443  O   ALA    71       4.312  47.936  20.937  1.00 40.47           O  
ATOM    444  CB  ALA    71       7.151  48.660  20.043  1.00 38.39           C  
ATOM    445  N   ALA    72       5.592  46.345  21.892  1.00 39.98           N  
ATOM    446  CA  ALA    72       4.775  46.269  23.119  1.00 41.01           C  
ATOM    447  C   ALA    72       4.906  47.607  23.852  1.00 41.50           C  
ATOM    448  O   ALA    72       6.005  48.142  23.924  1.00 42.57           O  
ATOM    449  CB  ALA    72       5.262  45.138  23.991  1.00 40.44           C  
ATOM    450  N   GLY    73       3.808  48.150  24.386  1.00 41.80           N  
ATOM    451  CA  GLY    73       3.846  49.469  25.049  1.00 41.25           C  
ATOM    452  C   GLY    73       4.707  49.578  26.305  1.00 41.94           C  
ATOM    453  O   GLY    73       5.268  50.647  26.616  1.00 41.43           O  
ATOM    454  N   LEU    74       4.819  48.486  27.054  1.00 41.99           N  
ATOM    455  CA  LEU    74       5.571  48.544  28.315  1.00 43.68           C  
ATOM    456  C   LEU    74       7.093  48.305  28.146  1.00 43.63           C  
ATOM    457  O   LEU    74       7.759  47.837  29.053  1.00 44.67           O  
ATOM    458  CB  LEU    74       4.930  47.605  29.352  1.00 44.01           C  
ATOM    459  CG  LEU    74       3.413  47.749  29.578  1.00 46.05           C  
ATOM    460  CD1 LEU    74       2.965  46.988  30.851  1.00 49.35           C  
ATOM    461  CD2 LEU    74       2.939  49.230  29.653  1.00 48.89           C  
ATOM    462  N   THR    75       7.626  48.623  26.970  1.00 43.11           N  
ATOM    463  CA  THR    75       9.046  48.418  26.701  1.00 42.65           C  
ATOM    464  C   THR    75       9.824  49.744  26.683  1.00 42.24           C  
ATOM    465  O   THR    75       9.263  50.835  26.438  1.00 41.76           O  
ATOM    466  CB  THR    75       9.306  47.632  25.409  1.00 42.39           C  
ATOM    467  OG1 THR    75       8.924  48.421  24.270  1.00 44.12           O  
ATOM    468  CG2 THR    75       8.570  46.277  25.420  1.00 41.79           C  
ATOM    469  N   LEU    76      11.114  49.633  26.971  1.00 40.77           N  
ATOM    470  CA  LEU    76      12.015  50.766  26.924  1.00 41.14           C  
ATOM    471  C   LEU    76      12.007  51.489  25.574  1.00 40.66           C  
ATOM    472  O   LEU    76      11.944  52.711  25.542  1.00 39.81           O  
ATOM    473  CB  LEU    76      13.425  50.295  27.255  1.00 41.59           C  
ATOM    474  CG  LEU    76      14.009  50.414  28.673  1.00 43.88           C  
ATOM    475  CD1 LEU    76      13.137  51.171  29.678  1.00 45.72           C  
ATOM    476  CD2 LEU    76      14.462  49.068  29.235  1.00 45.24           C  
ATOM    477  N   HIS    77      12.082  50.753  24.458  1.00 39.75           N  
ATOM    478  CA  HIS    77      12.104  51.447  23.167  1.00 39.95           C  
ATOM    479  C   HIS    77      10.777  52.175  22.905  1.00 39.38           C  
ATOM    480  O   HIS    77      10.792  53.307  22.464  1.00 40.18           O  
ATOM    481  CB  HIS    77      12.509  50.543  21.992  1.00 39.44           C  
ATOM    482  CG  HIS    77      11.775  49.241  21.944  1.00 39.43           C  
ATOM    483  ND1 HIS    77      11.884  48.284  22.934  1.00 40.59           N  
ATOM    484  CD2 HIS    77      10.954  48.718  21.004  1.00 41.59           C  
ATOM    485  CE1 HIS    77      11.144  47.235  22.614  1.00 38.83           C  
ATOM    486  NE2 HIS    77      10.565  47.473  21.448  1.00 39.75           N  
ATOM    487  N   ALA    78       9.640  51.531  23.189  1.00 39.56           N  
ATOM    488  CA  ALA    78       8.326  52.206  23.113  1.00 38.93           C  
ATOM    489  C   ALA    78       8.338  53.516  23.887  1.00 38.55           C  
ATOM    490  O   ALA    78       7.962  54.567  23.330  1.00 39.14           O  
ATOM    491  CB  ALA    78       7.207  51.312  23.617  1.00 38.80           C  
ATOM    492  N   ARG    79       8.770  53.448  25.163  1.00 37.66           N  
ATOM    493  CA  ARG    79       8.928  54.611  26.013  1.00 37.31           C  
ATOM    494  C   ARG    79       9.798  55.654  25.329  1.00 37.34           C  
ATOM    495  O   ARG    79       9.412  56.836  25.268  1.00 36.32           O  
ATOM    496  CB  ARG    79       9.554  54.227  27.373  1.00 36.74           C  
ATOM    497  CG  ARG    79       9.456  55.287  28.537  1.00 37.11           C  
ATOM    498  CD  ARG    79      10.594  56.342  28.549  1.00 38.08           C  
ATOM    499  NE  ARG    79      11.916  55.725  28.313  1.00 40.43           N  
ATOM    500  CZ  ARG    79      12.646  55.127  29.241  1.00 38.21           C  
ATOM    501  NH1 ARG    79      12.214  55.069  30.506  1.00 37.01           N  
ATOM    502  NH2 ARG    79      13.817  54.592  28.914  1.00 38.84           N  
ATOM    503  N   ASN    80      10.978  55.233  24.861  1.00 37.06           N  
ATOM    504  CA  ASN    80      11.944  56.179  24.276  1.00 38.46           C  
ATOM    505  C   ASN    80      11.301  56.927  23.122  1.00 39.46           C  
ATOM    506  O   ASN    80      11.364  58.170  23.060  1.00 39.42           O  
ATOM    507  CB  ASN    80      13.239  55.484  23.823  1.00 38.83           C  
ATOM    508  CG  ASN    80      14.083  54.995  24.983  1.00 37.97           C  
ATOM    509  OD1 ASN    80      13.876  55.410  26.113  1.00 38.02           O  
ATOM    510  ND2 ASN    80      15.026  54.079  24.712  1.00 33.92           N  
ATOM    511  N   MET    81      10.639  56.167  22.250  1.00 40.14           N  
ATOM    512  CA  MET    81       9.919  56.713  21.108  1.00 42.73           C  
ATOM    513  C   MET    81       8.765  57.675  21.467  1.00 43.11           C  
ATOM    514  O   MET    81       8.520  58.618  20.730  1.00 42.53           O  
ATOM    515  CB  MET    81       9.432  55.580  20.198  1.00 42.61           C  
ATOM    516  CG  MET    81      10.568  54.902  19.431  1.00 43.80           C  
ATOM    517  SD  MET    81       9.974  53.560  18.134  0.90 48.49          SE  
ATOM    518  CE  MET    81       9.395  52.112  19.373  1.00 41.87           C  
ATOM    519  N   GLU    82       8.087  57.458  22.601  1.00 44.27           N  
ATOM    520  CA  GLU    82       7.135  58.466  23.137  1.00 45.85           C  
ATOM    521  C   GLU    82       7.860  59.782  23.394  1.00 45.91           C  
ATOM    522  O   GLU    82       7.403  60.843  22.989  1.00 46.79           O  
ATOM    523  CB  GLU    82       6.489  58.039  24.470  1.00 45.53           C  
ATOM    524  CG  GLU    82       5.217  57.205  24.406  1.00 48.85           C  
ATOM    525  CD  GLU    82       4.247  57.594  23.266  1.00 54.63           C  
ATOM    526  OE1 GLU    82       3.253  58.314  23.531  1.00 55.24           O  
ATOM    527  OE2 GLU    82       4.470  57.147  22.101  1.00 57.39           O  
ATOM    528  N   THR    83       8.992  59.693  24.080  1.00 46.45           N  
ATOM    529  CA  THR    83       9.771  60.867  24.475  1.00 45.76           C  
ATOM    530  C   THR    83      10.447  61.603  23.288  1.00 45.32           C  
ATOM    531  O   THR    83      10.521  62.828  23.305  1.00 45.43           O  
ATOM    532  CB  THR    83      10.795  60.516  25.590  1.00 46.00           C  
ATOM    533  OG1 THR    83      11.720  59.527  25.129  1.00 46.47           O  
ATOM    534  CG2 THR    83      10.084  59.971  26.841  1.00 46.29           C  
ATOM    535  N   ASP    84      10.895  60.857  22.263  1.00 43.62           N  
ATOM    536  CA  ASP    84      11.665  61.391  21.128  1.00 41.98           C  
ATOM    537  C   ASP    84      11.534  60.402  19.962  1.00 41.59           C  
ATOM    538  O   ASP    84      11.974  59.236  20.064  1.00 40.45           O  
ATOM    539  CB  ASP    84      13.139  61.539  21.541  1.00 42.13           C  
ATOM    540  CG  ASP    84      14.009  62.236  20.488  1.00 42.54           C  
ATOM    541  OD1 ASP    84      13.770  62.126  19.266  1.00 43.26           O  
ATOM    542  OD2 ASP    84      14.984  62.892  20.912  1.00 44.27           O  
ATOM    543  N   ALA    85      10.941  60.861  18.856  1.00 39.53           N  
ATOM    544  CA  ALA    85      10.596  59.949  17.752  1.00 38.78           C  
ATOM    545  C   ALA    85      11.753  59.634  16.791  1.00 38.06           C  
ATOM    546  O   ALA    85      11.574  58.840  15.886  1.00 38.40           O  
ATOM    547  CB  ALA    85       9.356  60.477  16.964  1.00 38.66           C  
ATOM    548  N   ARG    86      12.921  60.255  16.968  1.00 37.49           N  
ATOM    549  CA  ARG    86      14.075  59.998  16.101  1.00 37.80           C  
ATOM    550  C   ARG    86      14.598  58.573  16.313  1.00 37.79           C  
ATOM    551  O   ARG    86      14.936  58.172  17.447  1.00 38.77           O  
ATOM    552  CB  ARG    86      15.191  61.015  16.337  1.00 37.29           C  
ATOM    553  CG  ARG    86      14.782  62.423  15.962  1.00 37.81           C  
ATOM    554  CD  ARG    86      15.909  63.377  16.220  1.00 40.31           C  
ATOM    555  NE  ARG    86      16.150  63.542  17.639  1.00 40.47           N  
ATOM    556  CZ  ARG    86      17.144  64.262  18.153  1.00 42.65           C  
ATOM    557  NH1 ARG    86      17.257  64.358  19.461  1.00 40.10           N  
ATOM    558  NH2 ARG    86      18.022  64.881  17.368  1.00 43.73           N  
ATOM    559  N   ILE    87      14.606  57.800  15.230  1.00 38.06           N  
ATOM    560  CA  ILE    87      15.018  56.378  15.256  1.00 36.98           C  
ATOM    561  C   ILE    87      15.927  56.047  14.083  1.00 38.03           C  
ATOM    562  O   ILE    87      16.014  56.818  13.113  1.00 37.74           O  
ATOM    563  CB  ILE    87      13.797  55.385  15.235  1.00 36.88           C  
ATOM    564  CG1 ILE    87      12.957  55.462  13.944  1.00 36.90           C  
ATOM    565  CG2 ILE    87      12.886  55.630  16.470  1.00 36.77           C  
ATOM    566  CD1 ILE    87      12.027  54.186  13.735  1.00 34.81           C  
ATOM    567  N   SER    88      16.604  54.893  14.173  1.00 38.43           N  
ATOM    568  CA  SER    88      17.331  54.328  13.048  1.00 37.90           C  
ATOM    569  C   SER    88      17.026  52.830  12.974  1.00 38.40           C  
ATOM    570  O   SER    88      16.896  52.180  14.008  1.00 38.37           O  
ATOM    571  CB  SER    88      18.842  54.556  13.197  1.00 36.88           C  
ATOM    572  OG  SER    88      19.560  54.036  12.078  1.00 36.15           O  
ATOM    573  N   VAL    89      16.930  52.277  11.760  1.00 38.48           N  
ATOM    574  CA  VAL    89      16.787  50.813  11.601  1.00 38.88           C  
ATOM    575  C   VAL    89      17.830  50.302  10.631  1.00 38.06           C  
ATOM    576  O   VAL    89      18.230  51.035   9.725  1.00 36.88           O  
ATOM    577  CB  VAL    89      15.369  50.373  11.097  1.00 40.20           C  
ATOM    578  CG1 VAL    89      14.302  50.819  12.041  1.00 38.37           C  
ATOM    579  CG2 VAL    89      15.078  50.950   9.696  1.00 40.61           C  
ATOM    580  N   THR    90      18.312  49.087  10.863  1.00 37.53           N  
ATOM    581  CA  THR    90      19.163  48.436   9.884  1.00 37.70           C  
ATOM    582  C   THR    90      18.491  47.149   9.499  1.00 37.66           C  
ATOM    583  O   THR    90      18.180  46.320  10.339  1.00 38.80           O  
ATOM    584  CB  THR    90      20.601  48.220  10.352  1.00 35.79           C  
ATOM    585  OG1 THR    90      21.173  49.505  10.639  1.00 36.06           O  
ATOM    586  CG2 THR    90      21.482  47.492   9.246  1.00 37.44           C  
ATOM    587  N   LEU    91      18.250  47.032   8.200  1.00 38.53           N  
ATOM    588  CA  LEU    91      17.699  45.849   7.614  1.00 39.28           C  
ATOM    589  C   LEU    91      18.794  45.059   6.917  1.00 40.62           C  
ATOM    590  O   LEU    91      19.650  45.631   6.225  1.00 40.09           O  
ATOM    591  CB  LEU    91      16.605  46.249   6.647  1.00 40.01           C  
ATOM    592  CG  LEU    91      15.246  46.573   7.263  1.00 38.97           C  
ATOM    593  CD1 LEU    91      15.310  47.813   8.152  1.00 43.01           C  
ATOM    594  CD2 LEU    91      14.252  46.840   6.101  1.00 40.75           C  
ATOM    595  N   ALA    92      18.781  43.736   7.095  1.00 41.61           N  
ATOM    596  CA  ALA    92      19.736  42.893   6.387  1.00 43.96           C  
ATOM    597  C   ALA    92      19.142  41.498   6.171  1.00 46.03           C  
ATOM    598  O   ALA    92      18.278  41.098   6.966  1.00 47.72           O  
ATOM    599  CB  ALA    92      21.036  42.818   7.155  1.00 42.95           C  
ATOM    600  N   PRO    93      19.572  40.763   5.108  1.00 47.15           N  
ATOM    601  CA  PRO    93      19.204  39.332   5.006  1.00 47.61           C  
ATOM    602  C   PRO    93      19.973  38.543   6.092  1.00 47.80           C  
ATOM    603  O   PRO    93      20.882  37.772   5.765  1.00 47.05           O  
ATOM    604  CB  PRO    93      19.687  38.934   3.596  1.00 47.22           C  
ATOM    605  CG  PRO    93      20.845  39.877   3.317  1.00 47.42           C  
ATOM    606  CD  PRO    93      20.406  41.189   3.950  1.00 47.69           C  
ATOM    607  N   PHE    94      19.635  38.785   7.367  1.00 47.53           N  
ATOM    608  CA  PHE    94      20.393  38.209   8.489  1.00 48.62           C  
ATOM    609  C   PHE    94      20.432  36.678   8.505  1.00 50.08           C  
ATOM    610  O   PHE    94      21.419  36.076   8.964  1.00 51.13           O  
ATOM    611  CB  PHE    94      19.810  38.662   9.811  1.00 48.35           C  
ATOM    612  CG  PHE    94      20.107  40.061  10.144  1.00 48.23           C  
ATOM    613  CD1 PHE    94      21.394  40.456  10.421  1.00 47.44           C  
ATOM    614  CD2 PHE    94      19.080  41.006  10.192  1.00 46.55           C  
ATOM    615  CE1 PHE    94      21.655  41.793  10.741  1.00 49.24           C  
ATOM    616  CE2 PHE    94      19.329  42.325  10.524  1.00 47.35           C  
ATOM    617  CZ  PHE    94      20.607  42.724  10.797  1.00 48.46           C  
ATOM    618  N   GLY    95      19.369  36.036   8.025  1.00 50.07           N  
ATOM    619  CA  GLY    95      19.398  34.572   7.973  1.00 52.05           C  
ATOM    620  C   GLY    95      20.520  34.009   7.112  1.00 52.20           C  
ATOM    621  O   GLY    95      20.907  32.844   7.284  1.00 52.90           O  
ATOM    622  N   LYS    96      21.045  34.824   6.187  1.00 52.00           N  
ATOM    623  CA  LYS    96      21.969  34.329   5.148  1.00 51.83           C  
ATOM    624  C   LYS    96      23.437  34.283   5.579  1.00 51.44           C  
ATOM    625  O   LYS    96      24.319  34.006   4.770  1.00 51.70           O  
ATOM    626  CB  LYS    96      21.802  35.142   3.824  1.00 51.81           C  
ATOM    627  N   GLY    97      23.713  34.551   6.847  1.00 50.94           N  
ATOM    628  CA  GLY    97      25.090  34.414   7.308  1.00 50.33           C  
ATOM    629  C   GLY    97      25.611  35.687   7.922  1.00 49.54           C  
ATOM    630  O   GLY    97      24.831  36.573   8.261  1.00 50.33           O  
ATOM    631  N   ASP    98      26.932  35.782   8.047  1.00 49.05           N  
ATOM    632  CA  ASP    98      27.539  36.781   8.924  1.00 48.11           C  
ATOM    633  C   ASP    98      27.244  38.226   8.526  1.00 47.99           C  
ATOM    634  O   ASP    98      27.201  38.544   7.338  1.00 47.68           O  
ATOM    635  CB  ASP    98      29.033  36.507   9.105  1.00 47.96           C  
ATOM    636  CG  ASP    98      29.289  35.466  10.185  1.00 47.86           C  
ATOM    637  OD1 ASP    98      28.397  35.330  11.066  1.00 49.44           O  
ATOM    638  OD2 ASP    98      30.344  34.796  10.165  1.00 42.64           O  
ATOM    639  N   ALA    99      27.013  39.085   9.526  1.00 47.12           N  
ATOM    640  CA  ALA    99      26.613  40.475   9.280  1.00 47.62           C  
ATOM    641  C   ALA    99      27.544  41.255   8.332  1.00 47.81           C  
ATOM    642  O   ALA    99      27.066  41.994   7.462  1.00 49.11           O  
ATOM    643  CB  ALA    99      26.414  41.247  10.612  1.00 46.67           C  
ATOM    644  N   LEU   100      28.854  41.108   8.500  1.00 47.20           N  
ATOM    645  CA  LEU   100      29.784  41.843   7.668  1.00 47.26           C  
ATOM    646  C   LEU   100      29.881  41.320   6.208  1.00 47.34           C  
ATOM    647  O   LEU   100      30.537  41.933   5.366  1.00 47.80           O  
ATOM    648  CB  LEU   100      31.156  41.957   8.363  1.00 47.63           C  
ATOM    649  CG  LEU   100      31.246  42.793   9.655  1.00 47.37           C  
ATOM    650  CD1 LEU   100      32.698  42.945  10.097  1.00 44.40           C  
ATOM    651  CD2 LEU   100      30.603  44.166   9.523  1.00 47.96           C  
ATOM    652  N   THR   101      29.225  40.196   5.918  1.00 47.25           N  
ATOM    653  CA  THR   101      29.122  39.670   4.543  1.00 47.24           C  
ATOM    654  C   THR   101      27.868  40.174   3.822  1.00 47.24           C  
ATOM    655  O   THR   101      27.753  40.062   2.608  1.00 48.04           O  
ATOM    656  CB  THR   101      29.068  38.093   4.506  1.00 47.64           C  
ATOM    657  OG1 THR   101      27.862  37.639   5.158  1.00 47.49           O  
ATOM    658  CG2 THR   101      30.274  37.470   5.169  1.00 44.40           C  
ATOM    659  N   LEU   102      26.921  40.710   4.562  1.00 47.23           N  
ATOM    660  CA  LEU   102      25.623  41.022   4.011  1.00 47.59           C  
ATOM    661  C   LEU   102      25.497  42.449   3.542  1.00 46.58           C  
ATOM    662  O   LEU   102      26.127  43.302   4.092  1.00 46.32           O  
ATOM    663  CB  LEU   102      24.556  40.797   5.080  1.00 48.18           C  
ATOM    664  CG  LEU   102      24.513  39.508   5.876  1.00 49.29           C  
ATOM    665  CD1 LEU   102      23.450  39.497   6.890  1.00 47.88           C  
ATOM    666  CD2 LEU   102      24.375  38.361   4.974  1.00 48.28           C  
ATOM    667  N   PRO   103      24.634  42.711   2.567  1.00 45.68           N  
ATOM    668  CA  PRO   103      24.248  44.107   2.342  1.00 44.98           C  
ATOM    669  C   PRO   103      23.440  44.570   3.544  1.00 44.51           C  
ATOM    670  O   PRO   103      22.679  43.789   4.116  1.00 45.61           O  
ATOM    671  CB  PRO   103      23.360  44.042   1.099  1.00 45.24           C  
ATOM    672  CG  PRO   103      22.818  42.660   1.098  1.00 46.09           C  
ATOM    673  CD  PRO   103      23.959  41.807   1.626  1.00 45.51           C  
ATOM    674  N   ARG   104      23.642  45.803   3.964  1.00 42.27           N  
ATOM    675  CA  ARG   104      23.009  46.293   5.151  1.00 42.38           C  
ATOM    676  C   ARG   104      22.432  47.658   4.826  1.00 40.76           C  
ATOM    677  O   ARG   104      23.163  48.568   4.419  1.00 40.88           O  
ATOM    678  CB  ARG   104      24.002  46.412   6.307  1.00 42.35           C  
ATOM    679  CG  ARG   104      24.269  45.116   7.027  1.00 45.67           C  
ATOM    680  CD  ARG   104      25.616  44.582   6.761  1.00 47.32           C  
ATOM    681  NE  ARG   104      26.661  45.481   7.210  1.00 49.89           N  
ATOM    682  CZ  ARG   104      27.859  45.565   6.657  1.00 50.47           C  
ATOM    683  NH1 ARG   104      28.731  46.415   7.158  1.00 52.92           N  
ATOM    684  NH2 ARG   104      28.191  44.799   5.609  1.00 54.70           N  
ATOM    685  N   LEU   105      21.116  47.757   4.962  1.00 38.88           N  
ATOM    686  CA  LEU   105      20.420  48.984   4.661  1.00 37.14           C  
ATOM    687  C   LEU   105      20.077  49.715   5.945  1.00 37.01           C  
ATOM    688  O   LEU   105      19.348  49.180   6.791  1.00 36.52           O  
ATOM    689  CB  LEU   105      19.189  48.688   3.787  1.00 37.18           C  
ATOM    690  CG  LEU   105      18.183  49.809   3.601  1.00 37.12           C  
ATOM    691  CD1 LEU   105      18.777  50.834   2.609  1.00 38.71           C  
ATOM    692  CD2 LEU   105      16.883  49.254   3.095  1.00 39.88           C  
ATOM    693  N   THR   106      20.646  50.912   6.115  1.00 36.12           N  
ATOM    694  CA  THR   106      20.308  51.740   7.269  1.00 36.15           C  
ATOM    695  C   THR   106      19.352  52.861   6.858  1.00 36.02           C  
ATOM    696  O   THR   106      19.630  53.603   5.923  1.00 34.58           O  
ATOM    697  CB  THR   106      21.576  52.300   7.981  1.00 36.43           C  
ATOM    698  OG1 THR   106      22.362  51.202   8.439  1.00 37.67           O  
ATOM    699  CG2 THR   106      21.183  53.136   9.188  1.00 35.63           C  
ATOM    700  N   LEU   107      18.220  52.959   7.562  1.00 36.38           N  
ATOM    701  CA  LEU   107      17.226  53.997   7.322  1.00 37.39           C  
ATOM    702  C   LEU   107      17.071  54.808   8.598  1.00 37.59           C  
ATOM    703  O   LEU   107      16.786  54.255   9.658  1.00 38.36           O  
ATOM    704  CB  LEU   107      15.883  53.386   6.890  1.00 37.42           C  
ATOM    705  CG  LEU   107      15.888  52.335   5.754  1.00 38.96           C  
ATOM    706  CD1 LEU   107      14.515  51.683   5.658  1.00 38.73           C  
ATOM    707  CD2 LEU   107      16.225  52.995   4.407  1.00 37.32           C  
ATOM    708  N   VAL   108      17.306  56.117   8.486  1.00 37.38           N  
ATOM    709  CA  VAL   108      17.208  57.028   9.609  1.00 36.50           C  
ATOM    710  C   VAL   108      15.982  57.912   9.428  1.00 36.44           C  
ATOM    711  O   VAL   108      15.771  58.434   8.349  1.00 36.83           O  
ATOM    712  CB  VAL   108      18.506  57.843   9.752  1.00 35.47           C  
ATOM    713  CG1 VAL   108      18.391  58.875  10.868  1.00 35.13           C  
ATOM    714  CG2 VAL   108      19.692  56.899   9.952  1.00 33.05           C  
ATOM    715  N   GLY   109      15.178  58.090  10.478  1.00 37.67           N  
ATOM    716  CA  GLY   109      14.016  58.998  10.380  1.00 37.60           C  
ATOM    717  C   GLY   109      13.194  59.088  11.645  1.00 38.67           C  
ATOM    718  O   GLY   109      13.748  59.065  12.745  1.00 38.44           O  
ATOM    719  N   ARG   110      11.873  59.219  11.496  1.00 39.40           N  
ATOM    720  CA  ARG   110      10.971  59.310  12.660  1.00 39.19           C  
ATOM    721  C   ARG   110       9.996  58.148  12.742  1.00 39.98           C  
ATOM    722  O   ARG   110       9.556  57.623  11.725  1.00 40.59           O  
ATOM    723  CB  ARG   110      10.250  60.665  12.723  1.00 38.94           C  
ATOM    724  CG  ARG   110      11.188  61.811  13.077  1.00 37.80           C  
ATOM    725  CD  ARG   110      10.575  63.184  12.887  1.00 38.81           C  
ATOM    726  NE  ARG   110      11.606  64.173  13.201  1.00 40.29           N  
ATOM    727  CZ  ARG   110      11.942  64.569  14.432  1.00 41.25           C  
ATOM    728  NH1 ARG   110      12.941  65.434  14.584  1.00 40.86           N  
ATOM    729  NH2 ARG   110      11.291  64.117  15.507  1.00 40.51           N  
ATOM    730  N   ALA   111       9.739  57.698  13.974  1.00 39.87           N  
ATOM    731  CA  ALA   111       8.742  56.686  14.255  1.00 39.24           C  
ATOM    732  C   ALA   111       7.410  57.388  14.427  1.00 39.28           C  
ATOM    733  O   ALA   111       7.158  58.004  15.488  1.00 39.27           O  
ATOM    734  CB  ALA   111       9.101  55.963  15.524  1.00 40.42           C  
ATOM    735  N   ASP   112       6.564  57.297  13.400  1.00 37.97           N  
ATOM    736  CA  ASP   112       5.245  57.869  13.413  1.00 37.66           C  
ATOM    737  C   ASP   112       4.263  56.791  13.859  1.00 39.07           C  
ATOM    738  O   ASP   112       4.145  55.730  13.241  1.00 37.57           O  
ATOM    739  CB  ASP   112       4.845  58.330  12.005  1.00 37.47           C  
ATOM    740  CG  ASP   112       5.527  59.613  11.572  1.00 38.12           C  
ATOM    741  OD1 ASP   112       5.787  60.485  12.423  1.00 34.00           O  
ATOM    742  OD2 ASP   112       5.797  59.778  10.356  1.00 37.81           O  
ATOM    743  N   ARG   113       3.500  57.090  14.888  1.00 39.45           N  
ATOM    744  CA  ARG   113       2.459  56.184  15.313  1.00 40.59           C  
ATOM    745  C   ARG   113       1.341  56.051  14.258  1.00 40.91           C  
ATOM    746  O   ARG   113       0.798  57.048  13.762  1.00 40.36           O  
ATOM    747  CB  ARG   113       1.932  56.668  16.654  1.00 42.56           C  
ATOM    748  CG  ARG   113       1.322  55.580  17.451  1.00 46.63           C  
ATOM    749  CD  ARG   113       2.301  54.882  18.378  1.00 48.90           C  
ATOM    750  NE  ARG   113       1.434  54.340  19.405  1.00 53.60           N  
ATOM    751  CZ  ARG   113       1.151  54.953  20.547  1.00 53.42           C  
ATOM    752  NH1 ARG   113       1.738  56.096  20.858  1.00 55.23           N  
ATOM    753  NH2 ARG   113       0.299  54.401  21.390  1.00 54.54           N  
ATOM    754  N   ILE   114       1.048  54.812  13.868  1.00 40.30           N  
ATOM    755  CA  ILE   114      -0.049  54.545  12.963  1.00 40.96           C  
ATOM    756  C   ILE   114      -1.386  54.812  13.695  1.00 41.58           C  
ATOM    757  O   ILE   114      -1.612  54.259  14.774  1.00 42.47           O  
ATOM    758  CB  ILE   114       0.042  53.108  12.411  1.00 40.38           C  
ATOM    759  CG1 ILE   114       1.260  52.984  11.459  1.00 41.25           C  
ATOM    760  CG2 ILE   114      -1.249  52.703  11.686  1.00 39.00           C  
ATOM    761  CD1 ILE   114       1.469  51.610  10.872  1.00 40.00           C  
ATOM    762  N   GLY   115      -2.227  55.688  13.131  1.00 41.83           N  
ATOM    763  CA  GLY   115      -3.554  56.030  13.692  1.00 41.15           C  
ATOM    764  C   GLY   115      -4.538  54.858  13.797  1.00 41.00           C  
ATOM    765  O   GLY   115      -4.438  53.905  13.029  1.00 40.08           O  
ATOM    766  N   PRO   116      -5.480  54.923  14.770  1.00 41.33           N  
ATOM    767  CA  PRO   116      -6.488  53.900  15.110  1.00 41.12           C  
ATOM    768  C   PRO   116      -7.162  53.226  13.897  1.00 41.75           C  
ATOM    769  O   PRO   116      -7.274  51.988  13.861  1.00 40.88           O  
ATOM    770  CB  PRO   116      -7.537  54.687  15.910  1.00 41.97           C  
ATOM    771  CG  PRO   116      -6.830  55.877  16.457  1.00 41.54           C  
ATOM    772  CD  PRO   116      -5.555  56.093  15.673  1.00 41.00           C  
ATOM    773  N   ASP   117      -7.599  54.026  12.918  1.00 41.48           N  
ATOM    774  CA  ASP   117      -8.340  53.487  11.759  1.00 42.14           C  
ATOM    775  C   ASP   117      -7.572  52.469  10.922  1.00 41.56           C  
ATOM    776  O   ASP   117      -8.163  51.581  10.314  1.00 40.67           O  
ATOM    777  CB  ASP   117      -8.893  54.602  10.847  1.00 42.62           C  
ATOM    778  CG  ASP   117      -9.916  55.509  11.548  1.00 44.68           C  
ATOM    779  OD1 ASP   117     -10.339  56.488  10.904  1.00 47.01           O  
ATOM    780  OD2 ASP   117     -10.294  55.273  12.721  1.00 46.41           O  
ATOM    781  N   GLU   118      -6.247  52.616  10.907  1.00 42.25           N  
ATOM    782  CA  GLU   118      -5.363  51.789  10.115  1.00 42.48           C  
ATOM    783  C   GLU   118      -4.801  50.593  10.880  1.00 41.49           C  
ATOM    784  O   GLU   118      -4.125  49.758  10.287  1.00 40.69           O  
ATOM    785  CB  GLU   118      -4.195  52.638   9.616  1.00 43.11           C  
ATOM    786  CG  GLU   118      -4.617  53.969   8.963  1.00 45.99           C  
ATOM    787  CD  GLU   118      -3.407  54.741   8.501  1.00 51.55           C  
ATOM    788  OE1 GLU   118      -2.791  54.297   7.508  1.00 53.87           O  
ATOM    789  OE2 GLU   118      -3.024  55.742   9.151  1.00 51.97           O  
ATOM    790  N   VAL   119      -5.055  50.470  12.180  1.00 40.47           N  
ATOM    791  CA  VAL   119      -4.452  49.289  12.818  1.00 39.77           C  
ATOM    792  C   VAL   119      -4.970  47.927  12.305  1.00 38.62           C  
ATOM    793  O   VAL   119      -4.153  47.050  12.063  1.00 37.65           O  
ATOM    794  CB  VAL   119      -4.130  49.368  14.343  1.00 39.16           C  
ATOM    795  CG1 VAL   119      -3.759  50.786  14.742  1.00 39.45           C  
ATOM    796  CG2 VAL   119      -5.185  48.829  15.167  1.00 41.43           C  
ATOM    797  N   PRO   120      -6.304  47.757  12.134  1.00 38.16           N  
ATOM    798  CA  PRO   120      -6.766  46.493  11.532  1.00 37.43           C  
ATOM    799  C   PRO   120      -6.020  46.047  10.227  1.00 37.74           C  
ATOM    800  O   PRO   120      -5.633  44.876  10.099  1.00 36.09           O  
ATOM    801  CB  PRO   120      -8.245  46.752  11.284  1.00 37.07           C  
ATOM    802  CG  PRO   120      -8.634  47.730  12.397  1.00 38.18           C  
ATOM    803  CD  PRO   120      -7.440  48.628  12.532  1.00 37.57           C  
ATOM    804  N   LEU   121      -5.823  46.977   9.301  1.00 37.13           N  
ATOM    805  CA  LEU   121      -5.069  46.685   8.080  1.00 38.71           C  
ATOM    806  C   LEU   121      -3.622  46.312   8.376  1.00 37.67           C  
ATOM    807  O   LEU   121      -3.110  45.342   7.819  1.00 37.67           O  
ATOM    808  CB  LEU   121      -5.126  47.883   7.139  1.00 38.61           C  
ATOM    809  CG  LEU   121      -4.512  47.752   5.759  1.00 39.30           C  
ATOM    810  CD1 LEU   121      -5.110  46.579   4.936  1.00 35.77           C  
ATOM    811  CD2 LEU   121      -4.764  49.121   5.140  1.00 41.31           C  
ATOM    812  N   ALA   122      -2.980  47.061   9.274  1.00 36.98           N  
ATOM    813  CA  ALA   122      -1.574  46.854   9.582  1.00 36.59           C  
ATOM    814  C   ALA   122      -1.386  45.497  10.265  1.00 37.61           C  
ATOM    815  O   ALA   122      -0.397  44.789  10.033  1.00 36.60           O  
ATOM    816  CB  ALA   122      -1.034  48.017  10.459  1.00 37.41           C  
ATOM    817  N   ILE   123      -2.358  45.125  11.089  1.00 37.52           N  
ATOM    818  CA  ILE   123      -2.385  43.802  11.748  1.00 38.61           C  
ATOM    819  C   ILE   123      -2.406  42.675  10.741  1.00 37.17           C  
ATOM    820  O   ILE   123      -1.649  41.710  10.838  1.00 37.42           O  
ATOM    821  CB  ILE   123      -3.657  43.639  12.672  1.00 39.07           C  
ATOM    822  CG1 ILE   123      -3.511  44.499  13.927  1.00 41.23           C  
ATOM    823  CG2 ILE   123      -3.890  42.180  13.098  1.00 40.52           C  
ATOM    824  CD1 ILE   123      -2.270  44.198  14.646  1.00 45.57           C  
ATOM    825  N   ALA   124      -3.313  42.752   9.795  1.00 36.81           N  
ATOM    826  CA  ALA   124      -3.427  41.659   8.857  1.00 37.23           C  
ATOM    827  C   ALA   124      -2.128  41.553   8.001  1.00 37.64           C  
ATOM    828  O   ALA   124      -1.590  40.452   7.800  1.00 36.63           O  
ATOM    829  CB  ALA   124      -4.654  41.830   7.999  1.00 37.00           C  
ATOM    830  N   ARG   125      -1.607  42.702   7.579  1.00 37.64           N  
ATOM    831  CA  ARG   125      -0.338  42.736   6.830  1.00 38.74           C  
ATOM    832  C   ARG   125       0.839  42.139   7.607  1.00 39.32           C  
ATOM    833  O   ARG   125       1.660  41.394   7.056  1.00 39.10           O  
ATOM    834  CB  ARG   125       0.003  44.157   6.428  1.00 39.12           C  
ATOM    835  CG  ARG   125      -0.760  44.677   5.279  1.00 39.31           C  
ATOM    836  CD  ARG   125      -0.540  46.186   5.178  1.00 42.21           C  
ATOM    837  NE  ARG   125      -1.251  46.747   4.033  1.00 42.02           N  
ATOM    838  CZ  ARG   125      -1.330  48.041   3.735  1.00 44.09           C  
ATOM    839  NH1 ARG   125      -0.787  48.966   4.539  1.00 42.23           N  
ATOM    840  NH2 ARG   125      -1.989  48.402   2.627  1.00 43.74           N  
ATOM    841  N   TYR   126       0.913  42.455   8.901  1.00 38.91           N  
ATOM    842  CA  TYR   126       1.965  41.957   9.741  1.00 38.50           C  
ATOM    843  C   TYR   126       1.883  40.445  10.004  1.00 38.28           C  
ATOM    844  O   TYR   126       2.888  39.738   9.921  1.00 37.03           O  
ATOM    845  CB  TYR   126       1.882  42.701  11.070  1.00 38.18           C  
ATOM    846  CG  TYR   126       3.073  42.563  11.972  1.00 38.12           C  
ATOM    847  CD1 TYR   126       4.130  43.481  11.909  1.00 38.79           C  
ATOM    848  CD2 TYR   126       3.099  41.592  12.959  1.00 38.98           C  
ATOM    849  CE1 TYR   126       5.217  43.383  12.779  1.00 38.36           C  
ATOM    850  CE2 TYR   126       4.154  41.486  13.840  1.00 39.29           C  
ATOM    851  CZ  TYR   126       5.211  42.397  13.757  1.00 39.80           C  
ATOM    852  OH  TYR   126       6.241  42.303  14.671  1.00 40.32           O  
ATOM    853  N   ILE   127       0.680  39.970  10.361  1.00 38.68           N  
ATOM    854  CA  ILE   127       0.370  38.560  10.561  1.00 38.24           C  
ATOM    855  C   ILE   127       0.751  37.693   9.356  1.00 38.71           C  
ATOM    856  O   ILE   127       1.212  36.567   9.513  1.00 37.24           O  
ATOM    857  CB  ILE   127      -1.169  38.356  10.836  1.00 39.14           C  
ATOM    858  CG1 ILE   127      -1.566  38.755  12.282  1.00 39.78           C  
ATOM    859  CG2 ILE   127      -1.614  36.931  10.590  1.00 38.81           C  
ATOM    860  CD1 ILE   127      -0.651  38.299  13.287  1.00 41.39           C  
ATOM    861  N   ALA   128       0.536  38.247   8.170  1.00 38.28           N  
ATOM    862  CA  ALA   128       0.881  37.603   6.892  1.00 39.64           C  
ATOM    863  C   ALA   128       2.362  37.196   6.864  1.00 39.77           C  
ATOM    864  O   ALA   128       2.692  36.160   6.326  1.00 40.73           O  
ATOM    865  CB  ALA   128       0.538  38.544   5.716  1.00 37.72           C  
ATOM    866  N   ARG   129       3.239  37.977   7.501  1.00 39.93           N  
ATOM    867  CA  ARG   129       4.663  37.665   7.535  1.00 40.44           C  
ATOM    868  C   ARG   129       5.092  36.935   8.789  1.00 41.02           C  
ATOM    869  O   ARG   129       6.078  36.186   8.762  1.00 41.36           O  
ATOM    870  CB  ARG   129       5.504  38.953   7.385  1.00 40.36           C  
ATOM    871  CG  ARG   129       5.631  39.460   6.006  1.00 40.68           C  
ATOM    872  CD  ARG   129       6.516  40.731   6.028  1.00 42.98           C  
ATOM    873  NE  ARG   129       7.005  41.042   4.703  1.00 42.54           N  
ATOM    874  CZ  ARG   129       8.005  41.881   4.428  1.00 40.53           C  
ATOM    875  NH1 ARG   129       8.668  42.496   5.400  1.00 35.92           N  
ATOM    876  NH2 ARG   129       8.369  42.072   3.162  1.00 40.85           N  
ATOM    877  N   TYR   130       4.355  37.171   9.879  1.00 40.43           N  
ATOM    878  CA  TYR   130       4.744  36.787  11.237  1.00 40.69           C  
ATOM    879  C   TYR   130       3.545  36.101  11.899  1.00 40.82           C  
ATOM    880  O   TYR   130       2.832  36.721  12.718  1.00 39.21           O  
ATOM    881  CB  TYR   130       5.205  38.026  12.053  1.00 40.55           C  
ATOM    882  CG  TYR   130       6.263  38.783  11.311  1.00 40.43           C  
ATOM    883  CD1 TYR   130       7.511  38.180  11.078  1.00 41.13           C  
ATOM    884  CD2 TYR   130       6.016  40.050  10.782  1.00 36.37           C  
ATOM    885  CE1 TYR   130       8.468  38.794  10.335  1.00 42.15           C  
ATOM    886  CE2 TYR   130       6.996  40.693  10.025  1.00 37.26           C  
ATOM    887  CZ  TYR   130       8.215  40.051   9.809  1.00 39.60           C  
ATOM    888  OH  TYR   130       9.191  40.643   9.072  1.00 41.60           O  
ATOM    889  N   PRO   131       3.306  34.817  11.540  1.00 42.16           N  
ATOM    890  CA  PRO   131       2.096  34.165  12.065  1.00 42.41           C  
ATOM    891  C   PRO   131       2.062  34.024  13.586  1.00 43.43           C  
ATOM    892  O   PRO   131       0.988  33.896  14.156  1.00 43.70           O  
ATOM    893  CB  PRO   131       2.077  32.794  11.349  1.00 42.87           C  
ATOM    894  CG  PRO   131       3.453  32.545  10.957  1.00 42.32           C  
ATOM    895  CD  PRO   131       4.065  33.913  10.654  1.00 41.32           C  
ATOM    896  N   LYS   132       3.210  34.079  14.254  1.00 44.16           N  
ATOM    897  CA  LYS   132       3.206  34.014  15.703  1.00 45.24           C  
ATOM    898  C   LYS   132       2.663  35.298  16.324  1.00 44.82           C  
ATOM    899  O   LYS   132       2.263  35.304  17.487  1.00 43.69           O  
ATOM    900  CB  LYS   132       4.595  33.704  16.260  1.00 45.12           C  
ATOM    901  CG  LYS   132       4.842  32.232  16.432  1.00 47.27           C  
ATOM    902  CD  LYS   132       6.196  31.909  17.119  1.00 48.39           C  
ATOM    903  CE  LYS   132       7.430  32.170  16.226  1.00 52.49           C  
ATOM    904  NZ  LYS   132       7.137  32.521  14.768  1.00 53.17           N  
ATOM    905  N   ALA   133       2.641  36.376  15.540  1.00 44.82           N  
ATOM    906  CA  ALA   133       2.119  37.640  16.033  1.00 45.86           C  
ATOM    907  C   ALA   133       0.639  37.487  16.421  1.00 46.28           C  
ATOM    908  O   ALA   133       0.119  38.284  17.187  1.00 46.88           O  
ATOM    909  CB  ALA   133       2.317  38.750  15.011  1.00 44.40           C  
ATOM    910  N   LYS   134      -0.011  36.451  15.885  1.00 46.67           N  
ATOM    911  CA  LYS   134      -1.416  36.157  16.164  1.00 47.61           C  
ATOM    912  C   LYS   134      -1.651  36.137  17.651  1.00 47.75           C  
ATOM    913  O   LYS   134      -2.757  36.404  18.112  1.00 47.97           O  
ATOM    914  CB  LYS   134      -1.842  34.813  15.552  1.00 47.52           C  
ATOM    915  CG  LYS   134      -1.859  34.804  14.020  1.00 47.47           C  
ATOM    916  CD  LYS   134      -2.287  33.432  13.483  1.00 49.07           C  
ATOM    917  CE  LYS   134      -1.445  32.992  12.281  1.00 51.18           C  
ATOM    918  NZ  LYS   134      -1.843  33.616  10.967  1.00 49.86           N  
ATOM    919  N   LEU   135      -0.579  35.853  18.390  1.00 48.06           N  
ATOM    920  CA  LEU   135      -0.617  35.721  19.826  1.00 47.97           C  
ATOM    921  C   LEU   135      -0.192  37.001  20.519  1.00 47.15           C  
ATOM    922  O   LEU   135      -0.969  37.551  21.300  1.00 46.82           O  
ATOM    923  CB  LEU   135       0.261  34.537  20.278  1.00 48.70           C  
ATOM    924  CG  LEU   135       0.035  33.874  21.647  1.00 50.11           C  
ATOM    925  CD1 LEU   135       0.774  34.634  22.791  1.00 50.84           C  
ATOM    926  CD2 LEU   135      -1.474  33.663  21.956  1.00 50.85           C  
ATOM    927  N   TYR   136       1.031  37.462  20.260  1.00 46.11           N  
ATOM    928  CA  TYR   136       1.581  38.606  21.013  1.00 45.99           C  
ATOM    929  C   TYR   136       1.034  39.993  20.657  1.00 46.23           C  
ATOM    930  O   TYR   136       1.253  40.941  21.400  1.00 47.04           O  
ATOM    931  CB  TYR   136       3.109  38.615  21.041  1.00 45.39           C  
ATOM    932  CG  TYR   136       3.790  38.700  19.693  1.00 46.29           C  
ATOM    933  CD1 TYR   136       3.885  39.920  19.003  1.00 46.59           C  
ATOM    934  CD2 TYR   136       4.382  37.560  19.114  1.00 47.90           C  
ATOM    935  CE1 TYR   136       4.510  40.011  17.768  1.00 45.30           C  
ATOM    936  CE2 TYR   136       5.021  37.640  17.878  1.00 45.08           C  
ATOM    937  CZ  TYR   136       5.087  38.863  17.214  1.00 45.87           C  
ATOM    938  OH  TYR   136       5.715  38.938  15.992  1.00 41.33           O  
ATOM    939  N   LEU   137       0.359  40.122  19.511  1.00 46.65           N  
ATOM    940  CA  LEU   137      -0.418  41.332  19.204  1.00 46.13           C  
ATOM    941  C   LEU   137      -1.735  41.311  20.000  1.00 46.60           C  
ATOM    942  O   LEU   137      -2.290  42.359  20.306  1.00 46.98           O  
ATOM    943  CB  LEU   137      -0.713  41.459  17.704  1.00 45.65           C  
ATOM    944  CG  LEU   137       0.437  41.531  16.695  1.00 44.77           C  
ATOM    945  CD1 LEU   137      -0.089  41.595  15.239  1.00 43.62           C  
ATOM    946  CD2 LEU   137       1.283  42.731  17.005  1.00 44.94           C  
ATOM    947  N   SER   138      -2.232  40.115  20.331  1.00 46.62           N  
ATOM    948  CA  SER   138      -3.452  39.978  21.138  1.00 46.51           C  
ATOM    949  C   SER   138      -3.169  40.269  22.616  1.00 46.44           C  
ATOM    950  O   SER   138      -4.035  40.077  23.474  1.00 45.70           O  
ATOM    951  CB  SER   138      -4.083  38.578  20.979  1.00 46.73           C  
ATOM    952  OG  SER   138      -4.835  38.461  19.779  1.00 45.66           O  
ATOM    953  N   LEU   139      -1.955  40.729  22.906  1.00 46.67           N  
ATOM    954  CA  LEU   139      -1.587  41.082  24.277  1.00 47.11           C  
ATOM    955  C   LEU   139      -1.803  42.577  24.520  1.00 47.01           C  
ATOM    956  O   LEU   139      -1.718  43.355  23.579  1.00 47.26           O  
ATOM    957  CB  LEU   139      -0.132  40.673  24.561  1.00 47.38           C  
ATOM    958  CG  LEU   139       0.075  39.157  24.775  1.00 48.22           C  
ATOM    959  CD1 LEU   139       1.557  38.734  24.649  1.00 48.29           C  
ATOM    960  CD2 LEU   139      -0.538  38.697  26.101  1.00 46.80           C  
ATOM    961  N   PRO   140      -2.098  42.982  25.772  1.00 46.85           N  
ATOM    962  CA  PRO   140      -2.243  44.405  26.123  1.00 47.11           C  
ATOM    963  C   PRO   140      -1.185  45.383  25.554  1.00 46.98           C  
ATOM    964  O   PRO   140      -0.054  44.997  25.304  1.00 46.95           O  
ATOM    965  CB  PRO   140      -2.208  44.384  27.670  1.00 47.08           C  
ATOM    966  CG  PRO   140      -2.900  43.086  27.999  1.00 46.63           C  
ATOM    967  CD  PRO   140      -2.367  42.116  26.942  1.00 47.39           C  
ATOM    968  N   ASP   141      -1.623  46.629  25.332  1.00 47.12           N  
ATOM    969  CA  ASP   141      -0.824  47.794  24.899  1.00 46.88           C  
ATOM    970  C   ASP   141       0.037  47.641  23.642  1.00 45.67           C  
ATOM    971  O   ASP   141       1.088  48.244  23.545  1.00 45.12           O  
ATOM    972  CB  ASP   141      -0.028  48.431  26.058  1.00 47.97           C  
ATOM    973  CG  ASP   141       0.312  49.933  25.794  1.00 51.71           C  
ATOM    974  OD1 ASP   141       0.123  50.416  24.640  1.00 56.09           O  
ATOM    975  OD2 ASP   141       0.765  50.642  26.726  1.00 53.23           O  
ATOM    976  N   THR   142      -0.433  46.872  22.665  1.00 45.38           N  
ATOM    977  CA  THR   142       0.298  46.738  21.399  1.00 44.64           C  
ATOM    978  C   THR   142       0.354  48.133  20.750  1.00 43.67           C  
ATOM    979  O   THR   142      -0.661  48.835  20.706  1.00 42.32           O  
ATOM    980  CB  THR   142      -0.322  45.645  20.432  1.00 45.28           C  
ATOM    981  OG1 THR   142      -1.500  46.129  19.764  1.00 50.55           O  
ATOM    982  CG2 THR   142      -0.691  44.384  21.154  1.00 43.67           C  
ATOM    983  N   ARG   143       1.543  48.544  20.302  1.00 42.84           N  
ATOM    984  CA  ARG   143       1.752  49.844  19.613  1.00 41.55           C  
ATOM    985  C   ARG   143       2.296  49.644  18.197  1.00 41.15           C  
ATOM    986  O   ARG   143       3.172  48.825  17.972  1.00 39.56           O  
ATOM    987  CB  ARG   143       2.693  50.754  20.397  1.00 41.33           C  
ATOM    988  CG  ARG   143       2.105  51.238  21.716  1.00 42.76           C  
ATOM    989  CD  ARG   143       2.837  52.418  22.285  1.00 41.74           C  
ATOM    990  NE  ARG   143       2.324  52.678  23.626  1.00 43.71           N  
ATOM    991  CZ  ARG   143       2.963  53.384  24.552  1.00 44.78           C  
ATOM    992  NH1 ARG   143       4.143  53.932  24.282  1.00 44.95           N  
ATOM    993  NH2 ARG   143       2.417  53.540  25.749  1.00 44.32           N  
ATOM    994  N   LEU   144       1.784  50.424  17.263  1.00 40.42           N  
ATOM    995  CA  LEU   144       2.074  50.247  15.850  1.00 40.95           C  
ATOM    996  C   LEU   144       2.702  51.530  15.277  1.00 40.06           C  
ATOM    997  O   LEU   144       2.163  52.615  15.462  1.00 38.91           O  
ATOM    998  CB  LEU   144       0.751  49.987  15.181  1.00 42.20           C  
ATOM    999  CG  LEU   144       0.619  49.097  13.969  1.00 46.50           C  
ATOM   1000  CD1 LEU   144       1.875  48.287  13.671  1.00 49.12           C  
ATOM   1001  CD2 LEU   144      -0.608  48.216  14.255  1.00 48.62           C  
ATOM   1002  N   TYR   145       3.817  51.406  14.564  1.00 39.79           N  
ATOM   1003  CA  TYR   145       4.558  52.599  14.078  1.00 40.16           C  
ATOM   1004  C   TYR   145       4.959  52.432  12.632  1.00 40.01           C  
ATOM   1005  O   TYR   145       5.267  51.349  12.243  1.00 39.76           O  
ATOM   1006  CB  TYR   145       5.867  52.724  14.824  1.00 39.53           C  
ATOM   1007  CG  TYR   145       5.781  52.715  16.319  1.00 40.63           C  
ATOM   1008  CD1 TYR   145       5.830  53.908  17.048  1.00 39.84           C  
ATOM   1009  CD2 TYR   145       5.749  51.505  17.013  1.00 40.60           C  
ATOM   1010  CE1 TYR   145       5.801  53.895  18.451  1.00 40.06           C  
ATOM   1011  CE2 TYR   145       5.697  51.480  18.355  1.00 39.43           C  
ATOM   1012  CZ  TYR   145       5.730  52.671  19.081  1.00 39.67           C  
ATOM   1013  OH  TYR   145       5.702  52.587  20.428  1.00 42.40           O  
ATOM   1014  N   ARG   146       5.015  53.506  11.843  1.00 39.59           N  
ATOM   1015  CA  ARG   146       5.738  53.386  10.573  1.00 39.78           C  
ATOM   1016  C   ARG   146       6.938  54.325  10.546  1.00 39.11           C  
ATOM   1017  O   ARG   146       6.964  55.378  11.224  1.00 39.10           O  
ATOM   1018  CB  ARG   146       4.811  53.511   9.324  1.00 40.31           C  
ATOM   1019  CG  ARG   146       4.060  54.788   9.265  1.00 39.82           C  
ATOM   1020  CD  ARG   146       3.345  55.018   7.916  1.00 38.92           C  
ATOM   1021  NE  ARG   146       2.211  54.139   7.701  1.00 37.29           N  
ATOM   1022  CZ  ARG   146       0.949  54.414   8.052  1.00 39.59           C  
ATOM   1023  NH1 ARG   146       0.620  55.547   8.670  1.00 36.29           N  
ATOM   1024  NH2 ARG   146       0.002  53.529   7.806  1.00 38.02           N  
ATOM   1025  N   LEU   147       7.953  53.898   9.812  1.00 38.46           N  
ATOM   1026  CA  LEU   147       9.159  54.674   9.672  1.00 39.22           C  
ATOM   1027  C   LEU   147       8.892  55.779   8.668  1.00 39.28           C  
ATOM   1028  O   LEU   147       8.458  55.507   7.541  1.00 40.23           O  
ATOM   1029  CB  LEU   147      10.337  53.786   9.223  1.00 38.32           C  
ATOM   1030  CG  LEU   147      11.633  54.552   8.934  1.00 40.43           C  
ATOM   1031  CD1 LEU   147      12.162  55.301  10.146  1.00 40.13           C  
ATOM   1032  CD2 LEU   147      12.676  53.585   8.383  1.00 39.88           C  
ATOM   1033  N   ARG   148       9.128  57.019   9.093  1.00 38.60           N  
ATOM   1034  CA  ARG   148       9.226  58.123   8.164  1.00 38.77           C  
ATOM   1035  C   ARG   148      10.701  58.279   7.820  1.00 38.33           C  
ATOM   1036  O   ARG   148      11.459  58.805   8.619  1.00 38.32           O  
ATOM   1037  CB  ARG   148       8.725  59.410   8.813  1.00 38.13           C  
ATOM   1038  CG  ARG   148       8.409  60.481   7.803  1.00 37.78           C  
ATOM   1039  CD  ARG   148       8.179  61.861   8.399  1.00 38.22           C  
ATOM   1040  NE  ARG   148       7.600  61.872   9.745  1.00 37.75           N  
ATOM   1041  CZ  ARG   148       7.628  62.927  10.557  1.00 37.04           C  
ATOM   1042  NH1 ARG   148       8.198  64.048  10.163  1.00 39.09           N  
ATOM   1043  NH2 ARG   148       7.088  62.877  11.769  1.00 37.72           N  
ATOM   1044  N   THR   149      11.112  57.813   6.646  1.00 38.59           N  
ATOM   1045  CA  THR   149      12.545  57.748   6.309  1.00 37.96           C  
ATOM   1046  C   THR   149      13.029  59.141   5.922  1.00 38.33           C  
ATOM   1047  O   THR   149      12.405  59.803   5.065  1.00 36.50           O  
ATOM   1048  CB  THR   149      12.806  56.757   5.154  1.00 38.31           C  
ATOM   1049  OG1 THR   149      12.509  55.419   5.604  1.00 41.10           O  
ATOM   1050  CG2 THR   149      14.270  56.801   4.713  1.00 35.97           C  
ATOM   1051  N   GLU   150      14.136  59.582   6.538  1.00 37.61           N  
ATOM   1052  CA  GLU   150      14.712  60.870   6.226  1.00 37.27           C  
ATOM   1053  C   GLU   150      16.117  60.754   5.641  1.00 36.61           C  
ATOM   1054  O   GLU   150      16.620  61.694   5.038  1.00 35.99           O  
ATOM   1055  CB  GLU   150      14.728  61.781   7.469  1.00 37.85           C  
ATOM   1056  CG  GLU   150      13.363  62.026   8.039  1.00 40.67           C  
ATOM   1057  CD  GLU   150      13.392  62.918   9.236  1.00 43.99           C  
ATOM   1058  OE1 GLU   150      13.697  62.446  10.343  1.00 45.92           O  
ATOM   1059  OE2 GLU   150      13.083  64.103   9.075  1.00 47.26           O  
ATOM   1060  N   GLY   151      16.754  59.605   5.811  1.00 36.37           N  
ATOM   1061  CA  GLY   151      18.106  59.438   5.304  1.00 35.42           C  
ATOM   1062  C   GLY   151      18.391  57.979   5.175  1.00 36.25           C  
ATOM   1063  O   GLY   151      17.818  57.157   5.916  1.00 36.80           O  
ATOM   1064  N   VAL   152      19.238  57.639   4.215  1.00 36.10           N  
ATOM   1065  CA  VAL   152      19.430  56.227   3.805  1.00 35.33           C  
ATOM   1066  C   VAL   152      20.918  55.988   3.648  1.00 35.97           C  
ATOM   1067  O   VAL   152      21.619  56.816   3.048  1.00 35.63           O  
ATOM   1068  CB  VAL   152      18.795  55.952   2.411  1.00 34.93           C  
ATOM   1069  CG1 VAL   152      19.039  54.483   1.920  1.00 32.95           C  
ATOM   1070  CG2 VAL   152      17.350  56.272   2.423  1.00 35.09           C  
ATOM   1071  N   GLN   153      21.393  54.850   4.145  1.00 36.44           N  
ATOM   1072  CA  GLN   153      22.734  54.355   3.769  1.00 37.39           C  
ATOM   1073  C   GLN   153      22.655  52.879   3.356  1.00 36.80           C  
ATOM   1074  O   GLN   153      22.052  52.100   4.058  1.00 36.40           O  
ATOM   1075  CB  GLN   153      23.665  54.515   4.963  1.00 37.50           C  
ATOM   1076  CG  GLN   153      25.127  54.524   4.640  1.00 41.65           C  
ATOM   1077  CD  GLN   153      25.556  55.736   3.810  1.00 41.98           C  
ATOM   1078  OE1 GLN   153      24.964  56.831   3.864  1.00 45.79           O  
ATOM   1079  NE2 GLN   153      26.583  55.533   3.041  1.00 42.54           N  
ATOM   1080  N   ILE   154      23.241  52.503   2.226  1.00 37.17           N  
ATOM   1081  CA  ILE   154      23.331  51.090   1.860  1.00 39.21           C  
ATOM   1082  C   ILE   154      24.785  50.640   1.815  1.00 41.79           C  
ATOM   1083  O   ILE   154      25.679  51.367   1.372  1.00 41.41           O  
ATOM   1084  CB  ILE   154      22.601  50.741   0.538  1.00 38.42           C  
ATOM   1085  CG1 ILE   154      22.646  49.226   0.255  1.00 38.22           C  
ATOM   1086  CG2 ILE   154      23.205  51.475  -0.643  1.00 38.65           C  
ATOM   1087  CD1 ILE   154      21.854  48.347   1.229  1.00 39.83           C  
ATOM   1088  N   ASN   155      25.004  49.399   2.225  1.00 44.68           N  
ATOM   1089  CA  ASN   155      26.328  48.960   2.615  1.00 46.88           C  
ATOM   1090  C   ASN   155      26.582  47.483   2.353  1.00 47.70           C  
ATOM   1091  O   ASN   155      25.686  46.663   2.509  1.00 46.80           O  
ATOM   1092  CB  ASN   155      26.426  49.207   4.104  1.00 47.14           C  
ATOM   1093  CG  ASN   155      27.647  49.882   4.462  1.00 50.04           C  
ATOM   1094  OD1 ASN   155      28.705  49.253   4.585  1.00 55.54           O  
ATOM   1095  ND2 ASN   155      27.558  51.195   4.622  1.00 52.46           N  
ATOM   1096  N   GLY   156      27.811  47.151   1.959  1.00 49.84           N  
ATOM   1097  CA  GLY   156      28.226  45.753   1.770  1.00 51.52           C  
ATOM   1098  C   GLY   156      27.617  45.115   0.522  1.00 52.58           C  
ATOM   1099  O   GLY   156      27.855  43.933   0.213  1.00 53.20           O  
ATOM   1100  N   SER   163      26.464  54.270  -1.177  1.00 60.56           N  
ATOM   1101  CA  SER   163      26.432  55.140  -2.358  1.00 60.69           C  
ATOM   1102  C   SER   163      25.807  56.505  -2.030  1.00 60.30           C  
ATOM   1103  O   SER   163      25.996  57.018  -0.913  1.00 60.50           O  
ATOM   1104  CB  SER   163      25.691  54.453  -3.512  1.00 60.82           C  
ATOM   1105  N   ASN   164      25.077  57.098  -2.983  1.00 59.18           N  
ATOM   1106  CA  ASN   164      24.316  58.305  -2.663  1.00 57.87           C  
ATOM   1107  C   ASN   164      22.811  58.245  -2.973  1.00 56.64           C  
ATOM   1108  O   ASN   164      22.310  58.927  -3.882  1.00 56.74           O  
ATOM   1109  CB  ASN   164      24.991  59.557  -3.217  1.00 58.18           C  
ATOM   1110  CG  ASN   164      25.093  60.662  -2.170  1.00 59.61           C  
ATOM   1111  OD1 ASN   164      24.452  60.581  -1.102  1.00 61.55           O  
ATOM   1112  ND2 ASN   164      25.898  61.696  -2.459  1.00 58.37           N  
ATOM   1113  N   ILE   165      22.119  57.431  -2.171  1.00 54.60           N  
ATOM   1114  CA  ILE   165      20.681  57.144  -2.264  1.00 52.78           C  
ATOM   1115  C   ILE   165      19.834  58.029  -1.349  1.00 51.56           C  
ATOM   1116  O   ILE   165      20.213  58.327  -0.218  1.00 51.45           O  
ATOM   1117  CB  ILE   165      20.383  55.679  -1.835  1.00 52.71           C  
ATOM   1118  CG1 ILE   165      21.223  54.685  -2.617  1.00 52.48           C  
ATOM   1119  CG2 ILE   165      18.870  55.346  -1.944  1.00 52.17           C  
ATOM   1120  CD1 ILE   165      21.075  53.276  -2.069  1.00 53.76           C  
ATOM   1121  N   THR   166      18.659  58.387  -1.850  1.00 49.82           N  
ATOM   1122  CA  THR   166      17.685  59.221  -1.167  1.00 47.99           C  
ATOM   1123  C   THR   166      16.460  58.402  -0.707  1.00 46.53           C  
ATOM   1124  O   THR   166      16.163  57.365  -1.305  1.00 45.87           O  
ATOM   1125  CB  THR   166      17.195  60.292  -2.160  1.00 48.47           C  
ATOM   1126  OG1 THR   166      16.247  61.157  -1.526  1.00 50.18           O  
ATOM   1127  CG2 THR   166      16.526  59.641  -3.353  1.00 47.03           C  
ATOM   1128  N   PRO   167      15.736  58.879   0.335  1.00 44.87           N  
ATOM   1129  CA  PRO   167      14.458  58.290   0.720  1.00 43.50           C  
ATOM   1130  C   PRO   167      13.494  58.042  -0.451  1.00 42.73           C  
ATOM   1131  O   PRO   167      12.872  56.980  -0.511  1.00 41.20           O  
ATOM   1132  CB  PRO   167      13.899  59.320   1.701  1.00 43.49           C  
ATOM   1133  CG  PRO   167      15.121  59.813   2.394  1.00 43.85           C  
ATOM   1134  CD  PRO   167      16.106  59.979   1.255  1.00 44.61           C  
ATOM   1135  N   ALA   168      13.394  59.003  -1.376  1.00 41.20           N  
ATOM   1136  CA  ALA   168      12.558  58.884  -2.575  1.00 40.36           C  
ATOM   1137  C   ALA   168      12.945  57.702  -3.447  1.00 40.15           C  
ATOM   1138  O   ALA   168      12.078  57.091  -4.074  1.00 39.71           O  
ATOM   1139  CB  ALA   168      12.623  60.191  -3.420  1.00 39.95           C  
ATOM   1140  N   ASP   169      14.248  57.401  -3.501  1.00 40.01           N  
ATOM   1141  CA  ASP   169      14.760  56.285  -4.307  1.00 40.40           C  
ATOM   1142  C   ASP   169      14.215  54.952  -3.813  1.00 39.36           C  
ATOM   1143  O   ASP   169      14.077  54.007  -4.570  1.00 38.74           O  
ATOM   1144  CB  ASP   169      16.286  56.201  -4.240  1.00 40.55           C  
ATOM   1145  CG  ASP   169      16.984  57.170  -5.175  1.00 44.16           C  
ATOM   1146  OD1 ASP   169      16.370  57.686  -6.141  1.00 46.62           O  
ATOM   1147  OD2 ASP   169      18.177  57.426  -4.917  1.00 46.46           O  
ATOM   1148  N   LEU   170      13.938  54.869  -2.520  1.00 39.88           N  
ATOM   1149  CA  LEU   170      13.470  53.617  -1.971  1.00 40.30           C  
ATOM   1150  C   LEU   170      11.977  53.420  -2.130  1.00 41.43           C  
ATOM   1151  O   LEU   170      11.506  52.272  -2.117  1.00 43.10           O  
ATOM   1152  CB  LEU   170      13.843  53.477  -0.496  1.00 39.86           C  
ATOM   1153  CG  LEU   170      15.310  53.540  -0.134  1.00 41.26           C  
ATOM   1154  CD1 LEU   170      15.403  53.049   1.308  1.00 38.50           C  
ATOM   1155  CD2 LEU   170      16.132  52.668  -1.055  1.00 41.75           C  
ATOM   1156  N   ARG   171      11.220  54.508  -2.225  1.00 41.64           N  
ATOM   1157  CA  ARG   171       9.757  54.400  -2.276  1.00 42.86           C  
ATOM   1158  C   ARG   171       9.224  53.862  -3.570  1.00 41.94           C  
ATOM   1159  O   ARG   171       9.793  54.126  -4.624  1.00 42.66           O  
ATOM   1160  CB  ARG   171       9.090  55.745  -2.037  1.00 44.35           C  
ATOM   1161  CG  ARG   171       8.629  55.926  -0.589  1.00 48.08           C  
ATOM   1162  CD  ARG   171       7.734  57.174  -0.489  1.00 55.26           C  
ATOM   1163  NE  ARG   171       8.159  58.232  -1.413  1.00 59.23           N  
ATOM   1164  CZ  ARG   171       9.087  59.155  -1.153  1.00 60.97           C  
ATOM   1165  NH1 ARG   171       9.718  59.190   0.027  1.00 59.89           N  
ATOM   1166  NH2 ARG   171       9.385  60.056  -2.088  1.00 61.23           N  
ATOM   1167  N   THR   172       8.104  53.136  -3.502  1.00 39.89           N  
ATOM   1168  CA  THR   172       7.400  52.778  -4.733  1.00 37.54           C  
ATOM   1169  C   THR   172       6.310  53.770  -5.091  1.00 36.45           C  
ATOM   1170  O   THR   172       5.388  53.982  -4.324  1.00 35.85           O  
ATOM   1171  CB  THR   172       6.777  51.374  -4.624  1.00 37.27           C  
ATOM   1172  OG1 THR   172       7.811  50.456  -4.280  1.00 36.73           O  
ATOM   1173  CG2 THR   172       6.129  50.979  -5.942  1.00 37.43           C  
ATOM   1174  N   ASP   173       6.386  54.342  -6.290  1.00 35.89           N  
ATOM   1175  CA  ASP   173       5.430  55.349  -6.699  1.00 35.73           C  
ATOM   1176  C   ASP   173       4.100  54.712  -7.127  1.00 35.45           C  
ATOM   1177  O   ASP   173       4.050  53.928  -8.081  1.00 34.18           O  
ATOM   1178  CB  ASP   173       6.040  56.182  -7.820  1.00 36.16           C  
ATOM   1179  CG  ASP   173       5.205  57.399  -8.183  1.00 37.67           C  
ATOM   1180  OD1 ASP   173       4.108  57.608  -7.606  1.00 38.56           O  
ATOM   1181  OD2 ASP   173       5.674  58.164  -9.053  1.00 40.65           O  
ATOM   1182  N   LEU   174       3.020  55.082  -6.432  1.00 35.60           N  
ATOM   1183  CA  LEU   174       1.699  54.491  -6.690  1.00 36.94           C  
ATOM   1184  C   LEU   174       0.820  55.341  -7.622  1.00 37.73           C  
ATOM   1185  O   LEU   174      -0.223  54.871  -8.064  1.00 38.70           O  
ATOM   1186  CB  LEU   174       0.955  54.137  -5.392  1.00 35.87           C  
ATOM   1187  CG  LEU   174       1.652  53.225  -4.335  1.00 37.10           C  
ATOM   1188  CD1 LEU   174       0.739  52.947  -3.138  1.00 42.05           C  
ATOM   1189  CD2 LEU   174       2.199  51.941  -4.887  1.00 34.58           C  
ATOM   1190  N   SER   175       1.250  56.578  -7.903  1.00 39.29           N  
ATOM   1191  CA  SER   175       0.577  57.509  -8.835  1.00 39.41           C  
ATOM   1192  C   SER   175       0.497  56.903 -10.201  1.00 38.81           C  
ATOM   1193  O   SER   175       1.480  56.338 -10.665  1.00 39.39           O  
ATOM   1194  CB  SER   175       1.393  58.781  -8.985  1.00 40.30           C  
ATOM   1195  OG  SER   175       1.749  59.250  -7.720  1.00 44.26           O  
ATOM   1196  N   GLY   176      -0.657  57.005 -10.851  1.00 38.00           N  
ATOM   1197  CA  GLY   176      -0.818  56.431 -12.193  1.00 36.90           C  
ATOM   1198  C   GLY   176      -1.274  54.983 -12.166  1.00 36.94           C  
ATOM   1199  O   GLY   176      -1.785  54.486 -13.161  1.00 36.75           O  
ATOM   1200  N   ALA   177      -1.121  54.326 -11.017  1.00 35.74           N  
ATOM   1201  CA  ALA   177      -1.447  52.891 -10.828  1.00 36.90           C  
ATOM   1202  C   ALA   177      -2.671  52.600  -9.946  1.00 37.11           C  
ATOM   1203  O   ALA   177      -2.825  51.471  -9.488  1.00 35.89           O  
ATOM   1204  CB  ALA   177      -0.241  52.139 -10.254  1.00 34.41           C  
ATOM   1205  N   GLU   178      -3.561  53.581  -9.759  1.00 38.00           N  
ATOM   1206  CA  GLU   178      -4.748  53.361  -8.912  1.00 39.26           C  
ATOM   1207  C   GLU   178      -5.582  52.148  -9.317  1.00 39.46           C  
ATOM   1208  O   GLU   178      -6.096  51.457  -8.448  1.00 39.25           O  
ATOM   1209  CB  GLU   178      -5.639  54.605  -8.793  1.00 40.40           C  
ATOM   1210  CG  GLU   178      -5.522  55.617  -9.915  1.00 43.04           C  
ATOM   1211  CD  GLU   178      -4.197  56.362  -9.892  1.00 44.81           C  
ATOM   1212  OE1 GLU   178      -3.412  56.160 -10.831  1.00 45.64           O  
ATOM   1213  OE2 GLU   178      -3.929  57.129  -8.943  1.00 47.96           O  
ATOM   1214  N   GLU   179      -5.709  51.882 -10.626  1.00 39.61           N  
ATOM   1215  CA  GLU   179      -6.423  50.683 -11.098  1.00 40.08           C  
ATOM   1216  C   GLU   179      -5.830  49.369 -10.565  1.00 39.89           C  
ATOM   1217  O   GLU   179      -6.570  48.512 -10.047  1.00 40.80           O  
ATOM   1218  CB  GLU   179      -6.540  50.655 -12.636  1.00 40.11           C  
ATOM   1219  CG  GLU   179      -6.507  49.214 -13.179  1.00 43.47           C  
ATOM   1220  CD  GLU   179      -7.351  48.973 -14.415  1.00 46.41           C  
ATOM   1221  OE1 GLU   179      -7.880  49.960 -14.980  1.00 50.62           O  
ATOM   1222  OE2 GLU   179      -7.486  47.788 -14.810  1.00 46.82           O  
ATOM   1223  N   LEU   180      -4.510  49.194 -10.691  1.00 39.48           N  
ATOM   1224  CA  LEU   180      -3.811  48.025 -10.098  1.00 39.31           C  
ATOM   1225  C   LEU   180      -4.002  47.941  -8.583  1.00 39.44           C  
ATOM   1226  O   LEU   180      -4.246  46.872  -8.015  1.00 38.38           O  
ATOM   1227  CB  LEU   180      -2.304  48.141 -10.358  1.00 39.30           C  
ATOM   1228  CG  LEU   180      -1.441  47.036  -9.750  1.00 38.15           C  
ATOM   1229  CD1 LEU   180      -1.658  45.717 -10.486  1.00 33.34           C  
ATOM   1230  CD2 LEU   180       0.046  47.422  -9.780  1.00 40.22           C  
ATOM   1231  N   MET   181      -3.847  49.086  -7.932  1.00 38.84           N  
ATOM   1232  CA  MET   181      -3.893  49.139  -6.471  1.00 39.22           C  
ATOM   1233  C   MET   181      -5.316  48.856  -5.978  1.00 39.12           C  
ATOM   1234  O   MET   181      -5.490  48.219  -4.945  1.00 38.93           O  
ATOM   1235  CB  MET   181      -3.352  50.496  -5.973  1.00 39.28           C  
ATOM   1236  CG  MET   181      -1.848  50.761  -6.347  1.00 39.80           C  
ATOM   1237  SD  MET   181      -0.644  49.150  -6.207  0.80 50.03          SE  
ATOM   1238  CE  MET   181      -0.749  48.741  -4.304  1.00 43.54           C  
ATOM   1239  N   ALA   182      -6.324  49.314  -6.730  1.00 38.66           N  
ATOM   1240  CA  ALA   182      -7.714  48.950  -6.445  1.00 38.95           C  
ATOM   1241  C   ALA   182      -7.947  47.426  -6.575  1.00 39.20           C  
ATOM   1242  O   ALA   182      -8.852  46.885  -5.948  1.00 39.76           O  
ATOM   1243  CB  ALA   182      -8.685  49.737  -7.336  1.00 38.72           C  
ATOM   1244  N   ALA   183      -7.113  46.736  -7.337  1.00 39.12           N  
ATOM   1245  CA  ALA   183      -7.270  45.262  -7.542  1.00 39.14           C  
ATOM   1246  C   ALA   183      -6.224  44.408  -6.838  1.00 39.39           C  
ATOM   1247  O   ALA   183      -6.325  43.165  -6.826  1.00 38.95           O  
ATOM   1248  CB  ALA   183      -7.291  44.929  -9.019  1.00 38.99           C  
ATOM   1249  N   ALA   184      -5.240  45.051  -6.210  1.00 39.22           N  
ATOM   1250  CA  ALA   184      -4.066  44.328  -5.747  1.00 38.88           C  
ATOM   1251  C   ALA   184      -4.423  43.297  -4.675  1.00 40.07           C  
ATOM   1252  O   ALA   184      -3.806  42.227  -4.618  1.00 38.32           O  
ATOM   1253  CB  ALA   184      -3.035  45.275  -5.244  1.00 39.29           C  
ATOM   1254  N   GLU   185      -5.384  43.627  -3.809  1.00 40.14           N  
ATOM   1255  CA  GLU   185      -5.765  42.693  -2.732  1.00 42.11           C  
ATOM   1256  C   GLU   185      -6.500  41.436  -3.275  1.00 41.53           C  
ATOM   1257  O   GLU   185      -6.199  40.301  -2.894  1.00 39.45           O  
ATOM   1258  CB  GLU   185      -6.582  43.433  -1.678  1.00 43.22           C  
ATOM   1259  CG  GLU   185      -6.269  43.043  -0.223  1.00 50.16           C  
ATOM   1260  CD  GLU   185      -4.758  43.002   0.076  1.00 57.11           C  
ATOM   1261  OE1 GLU   185      -4.074  44.003  -0.245  1.00 60.08           O  
ATOM   1262  OE2 GLU   185      -4.260  41.967   0.605  1.00 60.58           O  
ATOM   1263  N   SER   186      -7.432  41.647  -4.199  1.00 41.32           N  
ATOM   1264  CA  SER   186      -8.175  40.535  -4.777  1.00 42.46           C  
ATOM   1265  C   SER   186      -7.328  39.745  -5.782  1.00 42.08           C  
ATOM   1266  O   SER   186      -7.512  38.536  -5.919  1.00 41.71           O  
ATOM   1267  CB  SER   186      -9.474  41.018  -5.415  1.00 42.62           C  
ATOM   1268  OG  SER   186      -9.174  41.911  -6.461  1.00 44.62           O  
ATOM   1269  N   GLU   187      -6.398  40.404  -6.467  1.00 41.08           N  
ATOM   1270  CA  GLU   187      -5.419  39.646  -7.263  1.00 40.35           C  
ATOM   1271  C   GLU   187      -4.514  38.748  -6.418  1.00 39.77           C  
ATOM   1272  O   GLU   187      -4.302  37.599  -6.783  1.00 38.95           O  
ATOM   1273  CB  GLU   187      -4.589  40.552  -8.164  1.00 41.17           C  
ATOM   1274  CG  GLU   187      -5.388  41.079  -9.337  1.00 42.00           C  
ATOM   1275  CD  GLU   187      -5.830  39.962 -10.258  1.00 47.88           C  
ATOM   1276  OE1 GLU   187      -5.005  39.505 -11.069  1.00 47.76           O  
ATOM   1277  OE2 GLU   187      -6.990  39.526 -10.166  1.00 47.91           O  
ATOM   1278  N   ALA   188      -4.021  39.248  -5.275  1.00 39.62           N  
ATOM   1279  CA  ALA   188      -3.208  38.428  -4.354  1.00 39.36           C  
ATOM   1280  C   ALA   188      -3.986  37.181  -3.925  1.00 39.81           C  
ATOM   1281  O   ALA   188      -3.456  36.069  -3.961  1.00 39.51           O  
ATOM   1282  CB  ALA   188      -2.779  39.257  -3.093  1.00 38.66           C  
ATOM   1283  N   THR   189      -5.235  37.384  -3.502  1.00 38.54           N  
ATOM   1284  CA  THR   189      -6.118  36.310  -3.087  1.00 39.26           C  
ATOM   1285  C   THR   189      -6.334  35.303  -4.210  1.00 39.11           C  
ATOM   1286  O   THR   189      -6.262  34.090  -3.988  1.00 37.88           O  
ATOM   1287  CB  THR   189      -7.494  36.855  -2.631  1.00 39.24           C  
ATOM   1288  OG1 THR   189      -7.288  37.830  -1.619  1.00 40.65           O  
ATOM   1289  CG2 THR   189      -8.378  35.765  -2.068  1.00 40.14           C  
ATOM   1290  N   ARG   190      -6.581  35.820  -5.393  1.00 39.23           N  
ATOM   1291  CA  ARG   190      -6.801  35.025  -6.570  1.00 40.56           C  
ATOM   1292  C   ARG   190      -5.633  34.123  -6.835  1.00 40.07           C  
ATOM   1293  O   ARG   190      -5.788  32.956  -6.975  1.00 40.14           O  
ATOM   1294  CB  ARG   190      -6.993  35.918  -7.779  1.00 41.29           C  
ATOM   1295  CG  ARG   190      -8.079  35.488  -8.702  1.00 44.05           C  
ATOM   1296  CD  ARG   190      -7.768  35.575 -10.156  1.00 46.79           C  
ATOM   1297  NE  ARG   190      -6.739  36.506 -10.516  1.00 51.37           N  
ATOM   1298  CZ  ARG   190      -5.737  36.223 -11.314  1.00 47.62           C  
ATOM   1299  NH1 ARG   190      -5.642  35.058 -11.853  1.00 49.34           N  
ATOM   1300  NH2 ARG   190      -4.843  37.121 -11.564  1.00 47.10           N  
ATOM   1301  N   LEU   191      -4.467  34.720  -6.926  1.00 38.98           N  
ATOM   1302  CA  LEU   191      -3.217  34.037  -7.202  1.00 38.93           C  
ATOM   1303  C   LEU   191      -2.794  33.073  -6.116  1.00 39.02           C  
ATOM   1304  O   LEU   191      -2.290  31.994  -6.440  1.00 38.62           O  
ATOM   1305  CB  LEU   191      -2.075  35.040  -7.476  1.00 39.93           C  
ATOM   1306  CG  LEU   191      -2.305  35.806  -8.793  1.00 40.44           C  
ATOM   1307  CD1 LEU   191      -1.294  36.936  -8.975  1.00 43.47           C  
ATOM   1308  CD2 LEU   191      -2.281  34.785  -9.946  1.00 44.54           C  
ATOM   1309  N   ASN   192      -2.993  33.452  -4.850  1.00 37.70           N  
ATOM   1310  CA  ASN   192      -2.697  32.567  -3.715  1.00 36.83           C  
ATOM   1311  C   ASN   192      -3.572  31.343  -3.723  1.00 37.14           C  
ATOM   1312  O   ASN   192      -3.220  30.335  -3.109  1.00 38.40           O  
ATOM   1313  CB  ASN   192      -2.803  33.285  -2.328  1.00 36.57           C  
ATOM   1314  CG  ASN   192      -1.633  34.215  -2.047  1.00 36.66           C  
ATOM   1315  OD1 ASN   192      -0.523  33.959  -2.494  1.00 38.01           O  
ATOM   1316  ND2 ASN   192      -1.882  35.340  -1.331  1.00 36.35           N  
ATOM   1317  N   ALA   193      -4.720  31.401  -4.391  1.00 37.30           N  
ATOM   1318  CA  ALA   193      -5.619  30.241  -4.494  1.00 36.33           C  
ATOM   1319  C   ALA   193      -5.196  29.261  -5.595  1.00 35.42           C  
ATOM   1320  O   ALA   193      -5.751  28.146  -5.717  1.00 34.15           O  
ATOM   1321  CB  ALA   193      -7.096  30.722  -4.711  1.00 37.39           C  
ATOM   1322  N   ILE   194      -4.213  29.656  -6.408  1.00 34.06           N  
ATOM   1323  CA  ILE   194      -3.711  28.735  -7.433  1.00 34.61           C  
ATOM   1324  C   ILE   194      -2.594  27.985  -6.706  1.00 33.90           C  
ATOM   1325  O   ILE   194      -1.568  28.560  -6.394  1.00 33.32           O  
ATOM   1326  CB  ILE   194      -3.222  29.454  -8.746  1.00 34.05           C  
ATOM   1327  CG1 ILE   194      -4.363  30.303  -9.345  1.00 35.03           C  
ATOM   1328  CG2 ILE   194      -2.699  28.418  -9.802  1.00 33.21           C  
ATOM   1329  CD1 ILE   194      -3.961  31.173 -10.615  1.00 33.84           C  
ATOM   1330  N   LYS   195      -2.847  26.728  -6.374  1.00 35.20           N  
ATOM   1331  CA  LYS   195      -1.876  25.930  -5.637  1.00 35.60           C  
ATOM   1332  C   LYS   195      -0.505  25.965  -6.346  1.00 36.08           C  
ATOM   1333  O   LYS   195      -0.411  25.714  -7.565  1.00 35.81           O  
ATOM   1334  CB  LYS   195      -2.387  24.514  -5.446  1.00 35.34           C  
ATOM   1335  CG  LYS   195      -1.460  23.600  -4.645  1.00 36.94           C  
ATOM   1336  CD  LYS   195      -2.201  22.407  -4.192  1.00 34.56           C  
ATOM   1337  CE  LYS   195      -1.351  21.448  -3.450  1.00 34.63           C  
ATOM   1338  NZ  LYS   195      -2.210  20.321  -3.050  1.00 30.40           N  
ATOM   1339  N   GLY   196       0.531  26.345  -5.599  1.00 36.12           N  
ATOM   1340  CA  GLY   196       1.898  26.289  -6.099  1.00 35.91           C  
ATOM   1341  C   GLY   196       2.305  27.551  -6.816  1.00 36.65           C  
ATOM   1342  O   GLY   196       3.507  27.740  -7.088  1.00 36.86           O  
ATOM   1343  N   GLU   197       1.344  28.426  -7.125  1.00 36.33           N  
ATOM   1344  CA  GLU   197       1.667  29.605  -7.943  1.00 37.55           C  
ATOM   1345  C   GLU   197       2.560  30.629  -7.204  1.00 38.59           C  
ATOM   1346  O   GLU   197       3.497  31.163  -7.798  1.00 38.33           O  
ATOM   1347  CB  GLU   197       0.419  30.300  -8.468  1.00 37.82           C  
ATOM   1348  CG  GLU   197       0.668  31.114  -9.722  1.00 43.40           C  
ATOM   1349  CD  GLU   197       0.559  30.264 -11.018  1.00 49.01           C  
ATOM   1350  OE1 GLU   197      -0.187  30.686 -11.921  1.00 51.75           O  
ATOM   1351  OE2 GLU   197       1.177  29.164 -11.156  1.00 52.34           O  
ATOM   1352  N   ALA   198       2.291  30.892  -5.920  1.00 38.82           N  
ATOM   1353  CA  ALA   198       3.132  31.857  -5.162  1.00 39.20           C  
ATOM   1354  C   ALA   198       4.581  31.318  -5.068  1.00 40.28           C  
ATOM   1355  O   ALA   198       5.559  32.067  -5.197  1.00 39.92           O  
ATOM   1356  CB  ALA   198       2.568  32.073  -3.828  1.00 39.55           C  
ATOM   1357  N   SER   199       4.705  30.011  -4.877  1.00 39.80           N  
ATOM   1358  CA  SER   199       6.017  29.356  -4.808  1.00 41.18           C  
ATOM   1359  C   SER   199       6.752  29.410  -6.164  1.00 40.92           C  
ATOM   1360  O   SER   199       7.961  29.702  -6.200  1.00 41.81           O  
ATOM   1361  CB  SER   199       5.854  27.933  -4.303  1.00 40.29           C  
ATOM   1362  OG  SER   199       7.118  27.325  -4.118  1.00 44.86           O  
ATOM   1363  N   ARG   200       6.030  29.226  -7.276  1.00 40.52           N  
ATOM   1364  CA  ARG   200       6.615  29.459  -8.615  1.00 40.24           C  
ATOM   1365  C   ARG   200       7.175  30.877  -8.784  1.00 39.77           C  
ATOM   1366  O   ARG   200       8.250  31.065  -9.381  1.00 39.36           O  
ATOM   1367  CB  ARG   200       5.632  29.137  -9.745  1.00 40.01           C  
ATOM   1368  CG  ARG   200       5.495  27.640  -9.987  1.00 41.00           C  
ATOM   1369  CD  ARG   200       4.264  27.239 -10.825  1.00 42.99           C  
ATOM   1370  NE  ARG   200       4.142  28.008 -12.068  1.00 49.55           N  
ATOM   1371  CZ  ARG   200       3.651  27.538 -13.224  1.00 52.36           C  
ATOM   1372  NH1 ARG   200       3.581  28.348 -14.283  1.00 52.08           N  
ATOM   1373  NH2 ARG   200       3.251  26.265 -13.339  1.00 51.69           N  
ATOM   1374  N   LEU   201       6.440  31.860  -8.295  1.00 37.63           N  
ATOM   1375  CA  LEU   201       6.869  33.279  -8.351  1.00 39.30           C  
ATOM   1376  C   LEU   201       8.065  33.524  -7.449  1.00 39.33           C  
ATOM   1377  O   LEU   201       8.985  34.253  -7.837  1.00 38.96           O  
ATOM   1378  CB  LEU   201       5.730  34.241  -7.952  1.00 37.79           C  
ATOM   1379  CG  LEU   201       4.440  34.162  -8.770  1.00 40.78           C  
ATOM   1380  CD1 LEU   201       3.361  35.029  -8.131  1.00 38.26           C  
ATOM   1381  CD2 LEU   201       4.702  34.616 -10.232  1.00 39.91           C  
ATOM   1382  N   ALA   202       8.062  32.902  -6.263  1.00 39.34           N  
ATOM   1383  CA  ALA   202       9.182  33.054  -5.347  1.00 40.13           C  
ATOM   1384  C   ALA   202      10.467  32.448  -5.938  1.00 41.27           C  
ATOM   1385  O   ALA   202      11.551  33.034  -5.818  1.00 41.45           O  
ATOM   1386  CB  ALA   202       8.861  32.465  -4.019  1.00 39.97           C  
ATOM   1387  N   VAL   203      10.339  31.298  -6.600  1.00 41.74           N  
ATOM   1388  CA  VAL   203      11.497  30.685  -7.267  1.00 42.08           C  
ATOM   1389  C   VAL   203      12.026  31.580  -8.399  1.00 41.70           C  
ATOM   1390  O   VAL   203      13.220  31.783  -8.475  1.00 41.07           O  
ATOM   1391  CB  VAL   203      11.276  29.184  -7.667  1.00 42.31           C  
ATOM   1392  CG1 VAL   203      10.766  28.360  -6.474  1.00 41.59           C  
ATOM   1393  CG2 VAL   203      10.334  29.057  -8.821  1.00 44.04           C  
ATOM   1394  N   LEU   204      11.135  32.148  -9.229  1.00 42.28           N  
ATOM   1395  CA  LEU   204      11.501  33.205 -10.217  1.00 42.77           C  
ATOM   1396  C   LEU   204      12.250  34.379  -9.590  1.00 42.88           C  
ATOM   1397  O   LEU   204      13.131  34.975 -10.208  1.00 42.99           O  
ATOM   1398  CB  LEU   204      10.258  33.789 -10.906  1.00 43.24           C  
ATOM   1399  CG  LEU   204       9.650  33.355 -12.246  1.00 46.48           C  
ATOM   1400  CD1 LEU   204       8.426  32.557 -12.066  1.00 47.32           C  
ATOM   1401  CD2 LEU   204       9.289  34.637 -13.021  1.00 48.31           C  
ATOM   1402  N   ALA   205      11.845  34.737  -8.373  1.00 41.99           N  
ATOM   1403  CA  ALA   205      12.465  35.806  -7.612  1.00 42.75           C  
ATOM   1404  C   ALA   205      13.871  35.462  -7.077  1.00 42.85           C  
ATOM   1405  O   ALA   205      14.571  36.350  -6.561  1.00 44.20           O  
ATOM   1406  CB  ALA   205      11.544  36.181  -6.480  1.00 41.31           C  
ATOM   1407  N   GLY   206      14.252  34.186  -7.176  1.00 42.19           N  
ATOM   1408  CA  GLY   206      15.535  33.667  -6.718  1.00 42.09           C  
ATOM   1409  C   GLY   206      15.461  32.901  -5.405  1.00 42.11           C  
ATOM   1410  O   GLY   206      16.487  32.569  -4.842  1.00 41.96           O  
ATOM   1411  N   ALA   207      14.258  32.640  -4.900  1.00 42.14           N  
ATOM   1412  CA  ALA   207      14.086  31.971  -3.599  1.00 43.13           C  
ATOM   1413  C   ALA   207      13.941  30.435  -3.687  1.00 44.04           C  
ATOM   1414  O   ALA   207      13.926  29.858  -4.771  1.00 43.67           O  
ATOM   1415  CB  ALA   207      12.901  32.560  -2.844  1.00 43.20           C  
ATOM   1416  N   LYS   208      13.858  29.784  -2.528  1.00 45.85           N  
ATOM   1417  CA  LYS   208      13.705  28.329  -2.474  1.00 47.85           C  
ATOM   1418  C   LYS   208      12.243  27.932  -2.333  1.00 48.78           C  
ATOM   1419  O   LYS   208      11.493  28.568  -1.602  1.00 48.17           O  
ATOM   1420  CB  LYS   208      14.510  27.734  -1.313  1.00 48.57           C  
ATOM   1421  CG  LYS   208      15.886  27.145  -1.690  1.00 50.53           C  
ATOM   1422  CD  LYS   208      17.062  28.075  -1.389  1.00 55.23           C  
ATOM   1423  CE  LYS   208      17.400  28.165   0.123  1.00 57.03           C  
ATOM   1424  NZ  LYS   208      16.408  29.004   0.917  1.00 54.74           N  
ATOM   1425  N   THR   209      11.856  26.854  -3.017  1.00 50.43           N  
ATOM   1426  CA  THR   209      10.494  26.310  -2.927  1.00 51.48           C  
ATOM   1427  C   THR   209      10.035  26.159  -1.464  1.00 51.51           C  
ATOM   1428  O   THR   209      10.851  26.107  -0.522  1.00 51.65           O  
ATOM   1429  CB  THR   209      10.333  24.991  -3.735  1.00 52.21           C  
ATOM   1430  OG1 THR   209       8.940  24.634  -3.819  1.00 53.28           O  
ATOM   1431  CG2 THR   209      11.159  23.850  -3.116  1.00 52.02           C  
ATOM   1432  N   GLY   210       8.723  26.145  -1.276  1.00 50.99           N  
ATOM   1433  CA  GLY   210       8.183  26.203   0.072  1.00 50.54           C  
ATOM   1434  C   GLY   210       6.723  26.562   0.048  1.00 49.29           C  
ATOM   1435  O   GLY   210       6.091  26.552  -1.014  1.00 48.86           O  
ATOM   1436  N   ARG   211       6.181  26.857   1.225  1.00 48.70           N  
ATOM   1437  CA  ARG   211       4.782  27.252   1.299  1.00 48.23           C  
ATOM   1438  C   ARG   211       4.771  28.768   1.288  1.00 45.98           C  
ATOM   1439  O   ARG   211       4.824  29.430   2.335  1.00 47.07           O  
ATOM   1440  CB  ARG   211       4.040  26.622   2.493  1.00 48.33           C  
ATOM   1441  CG  ARG   211       4.079  25.034   2.560  1.00 52.97           C  
ATOM   1442  CD  ARG   211       4.151  24.292   1.176  1.00 61.21           C  
ATOM   1443  NE  ARG   211       2.925  24.332   0.342  1.00 66.10           N  
ATOM   1444  CZ  ARG   211       2.842  24.786  -0.919  1.00 69.04           C  
ATOM   1445  NH1 ARG   211       3.911  25.278  -1.544  1.00 70.03           N  
ATOM   1446  NH2 ARG   211       1.671  24.742  -1.576  1.00 70.00           N  
ATOM   1447  N   TRP   212       4.775  29.298   0.067  1.00 43.67           N  
ATOM   1448  CA  TRP   212       4.775  30.749  -0.205  1.00 41.76           C  
ATOM   1449  C   TRP   212       3.382  31.352  -0.350  1.00 40.77           C  
ATOM   1450  O   TRP   212       2.448  30.677  -0.800  1.00 40.44           O  
ATOM   1451  CB  TRP   212       5.553  31.004  -1.494  1.00 41.37           C  
ATOM   1452  CG  TRP   212       7.006  30.766  -1.310  1.00 39.46           C  
ATOM   1453  CD1 TRP   212       7.678  29.606  -1.529  1.00 38.11           C  
ATOM   1454  CD2 TRP   212       7.962  31.698  -0.787  1.00 39.28           C  
ATOM   1455  NE1 TRP   212       9.008  29.772  -1.236  1.00 37.62           N  
ATOM   1456  CE2 TRP   212       9.212  31.037  -0.758  1.00 40.47           C  
ATOM   1457  CE3 TRP   212       7.893  33.032  -0.374  1.00 36.46           C  
ATOM   1458  CZ2 TRP   212      10.390  31.671  -0.314  1.00 39.98           C  
ATOM   1459  CZ3 TRP   212       9.054  33.663   0.048  1.00 38.84           C  
ATOM   1460  CH2 TRP   212      10.290  32.983   0.070  1.00 39.28           C  
ATOM   1461  N   LYS   213       3.249  32.622   0.017  1.00 40.58           N  
ATOM   1462  CA  LYS   213       2.059  33.422  -0.275  1.00 40.25           C  
ATOM   1463  C   LYS   213       2.484  34.787  -0.791  1.00 39.48           C  
ATOM   1464  O   LYS   213       3.498  35.318  -0.343  1.00 39.04           O  
ATOM   1465  CB  LYS   213       1.194  33.602   0.979  1.00 40.47           C  
ATOM   1466  CG  LYS   213       0.446  32.298   1.467  1.00 43.77           C  
ATOM   1467  CD  LYS   213      -0.666  31.854   0.470  1.00 48.68           C  
ATOM   1468  CE  LYS   213      -1.257  30.458   0.783  1.00 45.97           C  
ATOM   1469  NZ  LYS   213      -2.195  29.896  -0.272  1.00 44.84           N  
ATOM   1470  N   ILE   214       1.723  35.334  -1.746  1.00 38.84           N  
ATOM   1471  CA  ILE   214       1.833  36.736  -2.134  1.00 38.25           C  
ATOM   1472  C   ILE   214       1.308  37.565  -1.016  1.00 39.46           C  
ATOM   1473  O   ILE   214       0.191  37.315  -0.538  1.00 39.34           O  
ATOM   1474  CB  ILE   214       1.020  37.045  -3.356  1.00 38.32           C  
ATOM   1475  CG1 ILE   214       1.577  36.244  -4.537  1.00 41.05           C  
ATOM   1476  CG2 ILE   214       0.995  38.591  -3.651  1.00 36.16           C  
ATOM   1477  CD1 ILE   214       0.735  36.298  -5.751  1.00 42.99           C  
ATOM   1478  N   THR   215       2.118  38.522  -0.572  1.00 40.09           N  
ATOM   1479  CA  THR   215       1.717  39.429   0.495  1.00 39.19           C  
ATOM   1480  C   THR   215       1.306  40.776  -0.058  1.00 40.01           C  
ATOM   1481  O   THR   215       0.474  41.460   0.565  1.00 40.47           O  
ATOM   1482  CB  THR   215       2.810  39.584   1.605  1.00 38.67           C  
ATOM   1483  OG1 THR   215       4.030  40.065   1.019  1.00 36.42           O  
ATOM   1484  CG2 THR   215       3.081  38.205   2.256  1.00 39.25           C  
ATOM   1485  N   SER   216       1.859  41.163  -1.219  1.00 40.46           N  
ATOM   1486  CA  SER   216       1.661  42.478  -1.733  1.00 40.62           C  
ATOM   1487  C   SER   216       2.031  42.554  -3.192  1.00 41.47           C  
ATOM   1488  O   SER   216       3.074  42.032  -3.593  1.00 41.94           O  
ATOM   1489  CB  SER   216       2.497  43.491  -0.907  1.00 39.86           C  
ATOM   1490  OG  SER   216       2.128  44.823  -1.153  1.00 41.34           O  
ATOM   1491  N   ILE   217       1.172  43.215  -3.992  1.00 41.47           N  
ATOM   1492  CA  ILE   217       1.457  43.510  -5.417  1.00 40.32           C  
ATOM   1493  C   ILE   217       1.534  45.018  -5.557  1.00 40.31           C  
ATOM   1494  O   ILE   217       0.694  45.723  -5.002  1.00 39.84           O  
ATOM   1495  CB  ILE   217       0.343  42.980  -6.348  1.00 40.39           C  
ATOM   1496  CG1 ILE   217       0.187  41.443  -6.165  1.00 39.41           C  
ATOM   1497  CG2 ILE   217       0.598  43.426  -7.811  1.00 39.89           C  
ATOM   1498  CD1 ILE   217      -1.090  40.855  -6.724  1.00 41.51           C  
ATOM   1499  N   ASP   218       2.548  45.504  -6.273  1.00 39.30           N  
ATOM   1500  CA  ASP   218       2.705  46.956  -6.484  1.00 38.73           C  
ATOM   1501  C   ASP   218       3.151  47.210  -7.933  1.00 37.93           C  
ATOM   1502  O   ASP   218       3.416  46.255  -8.685  1.00 37.25           O  
ATOM   1503  CB  ASP   218       3.623  47.588  -5.385  1.00 37.51           C  
ATOM   1504  CG  ASP   218       5.058  47.024  -5.398  1.00 40.93           C  
ATOM   1505  OD1 ASP   218       5.778  47.238  -6.414  1.00 42.23           O  
ATOM   1506  OD2 ASP   218       5.485  46.367  -4.407  1.00 40.91           O  
ATOM   1507  N   PRO   219       3.198  48.476  -8.359  1.00 37.21           N  
ATOM   1508  CA  PRO   219       3.591  48.663  -9.760  1.00 37.75           C  
ATOM   1509  C   PRO   219       4.951  48.083 -10.199  1.00 37.92           C  
ATOM   1510  O   PRO   219       5.164  47.847 -11.405  1.00 38.51           O  
ATOM   1511  CB  PRO   219       3.597  50.203  -9.907  1.00 38.18           C  
ATOM   1512  CG  PRO   219       2.574  50.651  -8.926  1.00 36.94           C  
ATOM   1513  CD  PRO   219       2.808  49.758  -7.722  1.00 36.21           C  
ATOM   1514  N   ASP   220       5.859  47.883  -9.259  1.00 37.98           N  
ATOM   1515  CA  ASP   220       7.228  47.454  -9.589  1.00 39.01           C  
ATOM   1516  C   ASP   220       7.467  45.947  -9.367  1.00 38.51           C  
ATOM   1517  O   ASP   220       8.460  45.362  -9.868  1.00 37.46           O  
ATOM   1518  CB  ASP   220       8.245  48.271  -8.767  1.00 38.35           C  
ATOM   1519  CG  ASP   220       8.330  49.724  -9.217  1.00 39.07           C  
ATOM   1520  OD1 ASP   220       7.923  50.038 -10.360  1.00 39.95           O  
ATOM   1521  OD2 ASP   220       8.803  50.553  -8.411  1.00 42.67           O  
ATOM   1522  N   GLY   221       6.533  45.310  -8.679  1.00 37.64           N  
ATOM   1523  CA  GLY   221       6.634  43.860  -8.472  1.00 38.70           C  
ATOM   1524  C   GLY   221       5.776  43.311  -7.351  1.00 39.35           C  
ATOM   1525  O   GLY   221       4.787  43.925  -6.960  1.00 39.63           O  
ATOM   1526  N   ILE   222       6.190  42.163  -6.812  1.00 39.81           N  
ATOM   1527  CA  ILE   222       5.341  41.364  -5.958  1.00 40.03           C  
ATOM   1528  C   ILE   222       6.174  40.894  -4.775  1.00 40.65           C  
ATOM   1529  O   ILE   222       7.272  40.320  -4.965  1.00 41.65           O  
ATOM   1530  CB  ILE   222       4.790  40.075  -6.716  1.00 39.93           C  
ATOM   1531  CG1 ILE   222       4.009  40.441  -7.999  1.00 38.13           C  
ATOM   1532  CG2 ILE   222       3.929  39.192  -5.700  1.00 38.68           C  
ATOM   1533  CD1 ILE   222       3.752  39.227  -8.997  1.00 40.00           C  
ATOM   1534  N   ASP   223       5.645  41.080  -3.567  1.00 39.32           N  
ATOM   1535  CA  ASP   223       6.358  40.638  -2.403  1.00 39.52           C  
ATOM   1536  C   ASP   223       5.741  39.337  -2.046  1.00 38.95           C  
ATOM   1537  O   ASP   223       4.511  39.211  -2.116  1.00 38.85           O  
ATOM   1538  CB  ASP   223       6.196  41.623  -1.251  1.00 39.17           C  
ATOM   1539  CG  ASP   223       7.141  42.848  -1.375  1.00 42.76           C  
ATOM   1540  OD1 ASP   223       8.022  42.907  -2.249  1.00 47.48           O  
ATOM   1541  OD2 ASP   223       6.998  43.742  -0.557  1.00 44.98           O  
ATOM   1542  N   LEU   224       6.580  38.377  -1.633  1.00 39.80           N  
ATOM   1543  CA  LEU   224       6.111  37.053  -1.146  1.00 38.74           C  
ATOM   1544  C   LEU   224       6.722  36.680   0.186  1.00 39.35           C  
ATOM   1545  O   LEU   224       7.821  37.137   0.512  1.00 38.40           O  
ATOM   1546  CB  LEU   224       6.378  35.942  -2.182  1.00 39.02           C  
ATOM   1547  CG  LEU   224       5.897  36.304  -3.590  1.00 37.93           C  
ATOM   1548  CD1 LEU   224       7.068  36.608  -4.460  1.00 39.11           C  
ATOM   1549  CD2 LEU   224       5.071  35.150  -4.101  1.00 40.89           C  
ATOM   1550  N   ALA   225       5.995  35.870   0.966  1.00 37.56           N  
ATOM   1551  CA  ALA   225       6.510  35.322   2.200  1.00 38.71           C  
ATOM   1552  C   ALA   225       6.232  33.820   2.347  1.00 40.11           C  
ATOM   1553  O   ALA   225       5.213  33.284   1.854  1.00 39.61           O  
ATOM   1554  CB  ALA   225       5.984  36.121   3.449  1.00 38.10           C  
ATOM   1555  N   SER   226       7.187  33.150   2.992  1.00 41.63           N  
ATOM   1556  CA  SER   226       7.013  31.793   3.510  1.00 41.51           C  
ATOM   1557  C   SER   226       7.324  31.904   4.982  1.00 42.46           C  
ATOM   1558  O   SER   226       7.537  33.010   5.479  1.00 43.34           O  
ATOM   1559  CB  SER   226       7.970  30.828   2.842  1.00 41.83           C  
ATOM   1560  OG  SER   226       9.300  31.081   3.257  1.00 42.39           O  
ATOM   1561  N   ALA   227       7.342  30.774   5.689  1.00 42.16           N  
ATOM   1562  CA  ALA   227       7.669  30.767   7.106  1.00 42.59           C  
ATOM   1563  C   ALA   227       9.110  31.220   7.433  1.00 42.71           C  
ATOM   1564  O   ALA   227       9.305  32.007   8.356  1.00 42.36           O  
ATOM   1565  CB  ALA   227       7.402  29.404   7.699  1.00 43.21           C  
ATOM   1566  N   SER   228      10.105  30.715   6.694  1.00 42.72           N  
ATOM   1567  CA  SER   228      11.510  31.070   6.946  1.00 42.93           C  
ATOM   1568  C   SER   228      12.085  32.193   6.075  1.00 42.11           C  
ATOM   1569  O   SER   228      13.103  32.779   6.454  1.00 42.02           O  
ATOM   1570  CB  SER   228      12.418  29.834   6.879  1.00 43.93           C  
ATOM   1571  OG  SER   228      12.426  29.254   5.581  1.00 46.22           O  
ATOM   1572  N   ASP   229      11.432  32.518   4.949  1.00 41.72           N  
ATOM   1573  CA  ASP   229      11.994  33.464   3.977  1.00 39.90           C  
ATOM   1574  C   ASP   229      11.038  34.518   3.395  1.00 38.59           C  
ATOM   1575  O   ASP   229       9.824  34.418   3.499  1.00 37.75           O  
ATOM   1576  CB  ASP   229      12.660  32.689   2.838  1.00 40.44           C  
ATOM   1577  CG  ASP   229      13.926  33.373   2.310  1.00 44.68           C  
ATOM   1578  OD1 ASP   229      14.608  32.727   1.477  1.00 49.71           O  
ATOM   1579  OD2 ASP   229      14.260  34.531   2.722  1.00 43.59           O  
ATOM   1580  N   LEU   230      11.617  35.547   2.781  1.00 36.54           N  
ATOM   1581  CA  LEU   230      10.867  36.577   2.051  1.00 36.28           C  
ATOM   1582  C   LEU   230      11.476  36.665   0.654  1.00 36.24           C  
ATOM   1583  O   LEU   230      12.709  36.487   0.502  1.00 36.39           O  
ATOM   1584  CB  LEU   230      10.960  37.968   2.743  1.00 34.87           C  
ATOM   1585  CG  LEU   230      10.459  38.126   4.187  1.00 34.46           C  
ATOM   1586  CD1 LEU   230      10.799  39.517   4.729  1.00 32.33           C  
ATOM   1587  CD2 LEU   230       8.953  37.824   4.324  1.00 35.09           C  
ATOM   1588  N   ALA   231      10.630  36.971  -0.330  1.00 36.69           N  
ATOM   1589  CA  ALA   231      11.059  37.169  -1.718  1.00 37.63           C  
ATOM   1590  C   ALA   231      10.385  38.400  -2.322  1.00 37.88           C  
ATOM   1591  O   ALA   231       9.292  38.845  -1.850  1.00 36.74           O  
ATOM   1592  CB  ALA   231      10.745  35.917  -2.578  1.00 38.16           C  
ATOM   1593  N   ARG   232      11.063  38.987  -3.312  1.00 37.21           N  
ATOM   1594  CA  ARG   232      10.468  40.025  -4.146  1.00 37.53           C  
ATOM   1595  C   ARG   232      10.745  39.728  -5.616  1.00 37.39           C  
ATOM   1596  O   ARG   232      11.906  39.647  -6.036  1.00 38.13           O  
ATOM   1597  CB  ARG   232      10.957  41.450  -3.789  1.00 38.48           C  
ATOM   1598  CG  ARG   232      10.221  42.472  -4.667  1.00 41.60           C  
ATOM   1599  CD  ARG   232      10.480  43.857  -4.294  1.00 44.96           C  
ATOM   1600  NE  ARG   232       9.842  44.856  -5.158  1.00 45.46           N  
ATOM   1601  CZ  ARG   232       8.545  45.201  -5.198  1.00 44.81           C  
ATOM   1602  NH1 ARG   232       7.613  44.591  -4.445  1.00 40.67           N  
ATOM   1603  NH2 ARG   232       8.185  46.204  -6.021  1.00 40.08           N  
ATOM   1604  N   LEU   233       9.680  39.585  -6.392  1.00 37.74           N  
ATOM   1605  CA  LEU   233       9.800  39.394  -7.866  1.00 37.36           C  
ATOM   1606  C   LEU   233       9.638  40.752  -8.532  1.00 38.69           C  
ATOM   1607  O   LEU   233       8.593  41.362  -8.387  1.00 39.15           O  
ATOM   1608  CB  LEU   233       8.739  38.415  -8.393  1.00 38.10           C  
ATOM   1609  CG  LEU   233       8.736  38.007  -9.900  1.00 37.23           C  
ATOM   1610  CD1 LEU   233      10.041  37.435 -10.324  1.00 36.14           C  
ATOM   1611  CD2 LEU   233       7.602  36.987 -10.196  1.00 36.27           C  
ATOM   1612  N   TRP   234      10.659  41.219  -9.269  1.00 38.24           N  
ATOM   1613  CA  TRP   234      10.559  42.485  -9.974  1.00 39.13           C  
ATOM   1614  C   TRP   234       9.999  42.342 -11.361  1.00 39.09           C  
ATOM   1615  O   TRP   234      10.421  41.458 -12.124  1.00 40.17           O  
ATOM   1616  CB  TRP   234      11.916  43.181 -10.045  1.00 39.39           C  
ATOM   1617  CG  TRP   234      12.446  43.508  -8.659  1.00 39.51           C  
ATOM   1618  CD1 TRP   234      13.161  42.667  -7.823  1.00 40.36           C  
ATOM   1619  CD2 TRP   234      12.292  44.740  -7.949  1.00 40.13           C  
ATOM   1620  NE1 TRP   234      13.498  43.317  -6.657  1.00 35.87           N  
ATOM   1621  CE2 TRP   234      12.967  44.585  -6.692  1.00 41.06           C  
ATOM   1622  CE3 TRP   234      11.668  45.966  -8.244  1.00 39.24           C  
ATOM   1623  CZ2 TRP   234      13.023  45.616  -5.731  1.00 42.27           C  
ATOM   1624  CZ3 TRP   234      11.732  47.019  -7.270  1.00 42.22           C  
ATOM   1625  CH2 TRP   234      12.398  46.825  -6.044  1.00 40.34           C  
ATOM   1626  N   PHE   235       9.043  43.203 -11.706  1.00 38.84           N  
ATOM   1627  CA  PHE   235       8.515  43.208 -13.084  1.00 38.96           C  
ATOM   1628  C   PHE   235       9.582  43.700 -14.033  1.00 38.59           C  
ATOM   1629  O   PHE   235      10.443  44.516 -13.632  1.00 38.93           O  
ATOM   1630  CB  PHE   235       7.276  44.094 -13.183  1.00 38.97           C  
ATOM   1631  CG  PHE   235       6.112  43.615 -12.341  1.00 40.90           C  
ATOM   1632  CD1 PHE   235       5.797  42.235 -12.271  1.00 40.09           C  
ATOM   1633  CD2 PHE   235       5.322  44.534 -11.636  1.00 39.05           C  
ATOM   1634  CE1 PHE   235       4.745  41.781 -11.549  1.00 39.69           C  
ATOM   1635  CE2 PHE   235       4.223  44.079 -10.871  1.00 37.48           C  
ATOM   1636  CZ  PHE   235       3.940  42.720 -10.819  1.00 40.48           C  
ATOM   1637  N   ALA   236       9.543  43.231 -15.280  1.00 38.45           N  
ATOM   1638  CA  ALA   236      10.436  43.786 -16.290  1.00 37.70           C  
ATOM   1639  C   ALA   236      10.100  45.249 -16.627  1.00 37.64           C  
ATOM   1640  O   ALA   236      10.982  46.013 -16.965  1.00 37.01           O  
ATOM   1641  CB  ALA   236      10.483  42.913 -17.582  1.00 38.00           C  
ATOM   1642  N   GLU   237       8.824  45.611 -16.580  1.00 37.50           N  
ATOM   1643  CA  GLU   237       8.438  47.005 -16.714  1.00 38.69           C  
ATOM   1644  C   GLU   237       7.311  47.345 -15.745  1.00 38.00           C  
ATOM   1645  O   GLU   237       6.660  46.443 -15.220  1.00 38.35           O  
ATOM   1646  CB  GLU   237       8.133  47.404 -18.174  1.00 38.07           C  
ATOM   1647  CG  GLU   237       7.000  46.656 -18.820  1.00 38.95           C  
ATOM   1648  CD  GLU   237       6.900  46.949 -20.306  1.00 40.50           C  
ATOM   1649  OE1 GLU   237       6.063  46.300 -20.980  1.00 44.17           O  
ATOM   1650  OE2 GLU   237       7.648  47.820 -20.803  1.00 39.99           O  
ATOM   1651  N   ARG   238       7.144  48.649 -15.473  1.00 38.50           N  
ATOM   1652  CA  ARG   238       6.249  49.148 -14.421  1.00 38.23           C  
ATOM   1653  C   ARG   238       4.837  48.801 -14.832  1.00 38.36           C  
ATOM   1654  O   ARG   238       4.489  48.922 -15.997  1.00 36.49           O  
ATOM   1655  CB  ARG   238       6.398  50.684 -14.283  1.00 39.03           C  
ATOM   1656  CG  ARG   238       5.456  51.361 -13.290  1.00 38.45           C  
ATOM   1657  CD  ARG   238       5.582  52.918 -13.308  1.00 40.35           C  
ATOM   1658  NE  ARG   238       4.427  53.521 -12.639  1.00 40.39           N  
ATOM   1659  CZ  ARG   238       4.292  53.621 -11.319  1.00 38.31           C  
ATOM   1660  NH1 ARG   238       5.236  53.158 -10.511  1.00 40.01           N  
ATOM   1661  NH2 ARG   238       3.199  54.153 -10.810  1.00 35.26           N  
ATOM   1662  N   VAL   239       4.014  48.410 -13.876  1.00 39.17           N  
ATOM   1663  CA  VAL   239       2.653  47.913 -14.163  1.00 40.40           C  
ATOM   1664  C   VAL   239       1.617  48.878 -13.543  1.00 40.56           C  
ATOM   1665  O   VAL   239       1.759  49.304 -12.403  1.00 38.13           O  
ATOM   1666  CB  VAL   239       2.495  46.455 -13.636  1.00 40.92           C  
ATOM   1667  CG1 VAL   239       1.032  46.075 -13.500  1.00 41.13           C  
ATOM   1668  CG2 VAL   239       3.219  45.489 -14.602  1.00 41.64           C  
ATOM   1669  N   GLU   240       0.599  49.262 -14.314  1.00 39.99           N  
ATOM   1670  CA  GLU   240      -0.309  50.325 -13.830  1.00 40.55           C  
ATOM   1671  C   GLU   240      -1.774  49.914 -13.806  1.00 40.06           C  
ATOM   1672  O   GLU   240      -2.584  50.452 -13.040  1.00 38.77           O  
ATOM   1673  CB  GLU   240      -0.098  51.614 -14.631  1.00 41.11           C  
ATOM   1674  CG  GLU   240       1.092  52.415 -14.105  1.00 40.98           C  
ATOM   1675  CD  GLU   240       1.240  53.750 -14.788  1.00 42.99           C  
ATOM   1676  OE1 GLU   240       0.678  53.947 -15.907  1.00 43.11           O  
ATOM   1677  OE2 GLU   240       1.937  54.609 -14.198  1.00 45.89           O  
ATOM   1678  N   THR   241      -2.069  48.888 -14.592  1.00 40.56           N  
ATOM   1679  CA  THR   241      -3.427  48.407 -14.767  1.00 40.97           C  
ATOM   1680  C   THR   241      -3.498  46.920 -14.591  1.00 41.14           C  
ATOM   1681  O   THR   241      -2.471  46.206 -14.586  1.00 40.51           O  
ATOM   1682  CB  THR   241      -3.978  48.755 -16.176  1.00 41.31           C  
ATOM   1683  OG1 THR   241      -3.235  48.037 -17.173  1.00 41.19           O  
ATOM   1684  CG2 THR   241      -3.896  50.254 -16.443  1.00 40.83           C  
ATOM   1685  N   LEU   242      -4.724  46.430 -14.464  1.00 41.44           N  
ATOM   1686  CA  LEU   242      -4.923  44.999 -14.321  1.00 41.37           C  
ATOM   1687  C   LEU   242      -4.507  44.277 -15.604  1.00 40.45           C  
ATOM   1688  O   LEU   242      -3.842  43.239 -15.543  1.00 39.76           O  
ATOM   1689  CB  LEU   242      -6.383  44.686 -13.982  1.00 42.24           C  
ATOM   1690  CG  LEU   242      -6.693  43.207 -13.740  1.00 43.34           C  
ATOM   1691  CD1 LEU   242      -6.140  42.777 -12.389  1.00 47.07           C  
ATOM   1692  CD2 LEU   242      -8.186  43.008 -13.766  1.00 45.50           C  
ATOM   1693  N   LYS   243      -4.917  44.817 -16.755  1.00 39.92           N  
ATOM   1694  CA  LYS   243      -4.502  44.262 -18.042  1.00 39.83           C  
ATOM   1695  C   LYS   243      -2.986  44.123 -18.089  1.00 39.07           C  
ATOM   1696  O   LYS   243      -2.484  43.076 -18.483  1.00 38.24           O  
ATOM   1697  CB  LYS   243      -4.976  45.110 -19.240  1.00 40.23           C  
ATOM   1698  CG  LYS   243      -4.818  44.352 -20.557  1.00 43.46           C  
ATOM   1699  CD  LYS   243      -5.697  44.891 -21.694  1.00 46.25           C  
ATOM   1700  CE  LYS   243      -6.112  43.753 -22.612  1.00 49.30           C  
ATOM   1701  NZ  LYS   243      -6.790  42.665 -21.842  1.00 50.82           N  
ATOM   1702  N   GLN   244      -2.270  45.172 -17.665  1.00 38.67           N  
ATOM   1703  CA  GLN   244      -0.815  45.166 -17.687  1.00 38.68           C  
ATOM   1704  C   GLN   244      -0.265  44.151 -16.698  1.00 39.31           C  
ATOM   1705  O   GLN   244       0.726  43.487 -16.981  1.00 39.04           O  
ATOM   1706  CB  GLN   244      -0.226  46.558 -17.442  1.00 37.90           C  
ATOM   1707  CG  GLN   244      -0.509  47.574 -18.567  1.00 37.97           C  
ATOM   1708  CD  GLN   244      -0.042  48.971 -18.208  1.00 38.18           C  
ATOM   1709  OE1 GLN   244       0.280  49.264 -17.055  1.00 37.40           O  
ATOM   1710  NE2 GLN   244      -0.004  49.850 -19.201  1.00 38.82           N  
ATOM   1711  N   PHE   245      -0.904  44.014 -15.532  1.00 40.67           N  
ATOM   1712  CA  PHE   245      -0.460  43.012 -14.562  1.00 41.10           C  
ATOM   1713  C   PHE   245      -0.560  41.581 -15.123  1.00 41.63           C  
ATOM   1714  O   PHE   245       0.404  40.810 -15.086  1.00 40.20           O  
ATOM   1715  CB  PHE   245      -1.295  43.096 -13.303  1.00 40.94           C  
ATOM   1716  CG  PHE   245      -0.929  42.085 -12.296  1.00 42.35           C  
ATOM   1717  CD1 PHE   245       0.328  42.120 -11.694  1.00 45.23           C  
ATOM   1718  CD2 PHE   245      -1.842  41.116 -11.891  1.00 43.67           C  
ATOM   1719  CE1 PHE   245       0.700  41.173 -10.739  1.00 42.02           C  
ATOM   1720  CE2 PHE   245      -1.473  40.171 -10.906  1.00 44.61           C  
ATOM   1721  CZ  PHE   245      -0.206  40.220 -10.336  1.00 39.90           C  
ATOM   1722  N   GLU   246      -1.760  41.234 -15.585  1.00 43.00           N  
ATOM   1723  CA  GLU   246      -2.042  39.927 -16.170  1.00 44.84           C  
ATOM   1724  C   GLU   246      -1.063  39.602 -17.321  1.00 44.90           C  
ATOM   1725  O   GLU   246      -0.621  38.454 -17.459  1.00 44.81           O  
ATOM   1726  CB  GLU   246      -3.526  39.860 -16.591  1.00 44.32           C  
ATOM   1727  CG  GLU   246      -3.954  38.674 -17.517  1.00 47.80           C  
ATOM   1728  CD  GLU   246      -5.251  38.946 -18.302  1.00 48.21           C  
ATOM   1729  OE1 GLU   246      -5.773  40.089 -18.210  1.00 54.42           O  
ATOM   1730  OE2 GLU   246      -5.737  38.036 -19.037  1.00 53.58           O  
ATOM   1731  N   LYS   247      -0.709  40.599 -18.135  1.00 45.50           N  
ATOM   1732  CA  LYS   247       0.238  40.365 -19.245  1.00 45.47           C  
ATOM   1733  C   LYS   247       1.616  40.052 -18.693  1.00 45.44           C  
ATOM   1734  O   LYS   247       2.220  39.049 -19.049  1.00 44.50           O  
ATOM   1735  CB  LYS   247       0.365  41.573 -20.175  1.00 45.46           C  
ATOM   1736  CG  LYS   247      -0.918  42.053 -20.865  1.00 48.64           C  
ATOM   1737  CD  LYS   247      -1.542  41.049 -21.852  1.00 50.26           C  
ATOM   1738  CE  LYS   247      -2.612  40.175 -21.151  1.00 52.86           C  
ATOM   1739  NZ  LYS   247      -3.531  40.995 -20.265  1.00 51.97           N  
ATOM   1740  N   ALA   248       2.113  40.961 -17.860  1.00 45.18           N  
ATOM   1741  CA  ALA   248       3.347  40.778 -17.103  1.00 47.11           C  
ATOM   1742  C   ALA   248       3.417  39.420 -16.390  1.00 47.71           C  
ATOM   1743  O   ALA   248       4.455  38.767 -16.415  1.00 48.59           O  
ATOM   1744  CB  ALA   248       3.510  41.906 -16.065  1.00 46.51           C  
ATOM   1745  N   LEU   249       2.324  38.999 -15.752  1.00 48.09           N  
ATOM   1746  CA  LEU   249       2.333  37.731 -15.017  1.00 49.29           C  
ATOM   1747  C   LEU   249       2.472  36.559 -15.978  1.00 48.63           C  
ATOM   1748  O   LEU   249       3.212  35.595 -15.702  1.00 48.78           O  
ATOM   1749  CB  LEU   249       1.068  37.553 -14.151  1.00 49.60           C  
ATOM   1750  CG  LEU   249       1.090  37.485 -12.610  1.00 54.43           C  
ATOM   1751  CD1 LEU   249       0.097  36.412 -12.168  1.00 55.08           C  
ATOM   1752  CD2 LEU   249       2.454  37.183 -11.983  1.00 55.79           C  
ATOM   1753  N   ALA   250       1.760  36.656 -17.101  1.00 48.14           N  
ATOM   1754  CA  ALA   250       1.699  35.597 -18.113  1.00 47.71           C  
ATOM   1755  C   ALA   250       3.049  35.394 -18.810  1.00 47.83           C  
ATOM   1756  O   ALA   250       3.456  34.250 -19.061  1.00 47.90           O  
ATOM   1757  CB  ALA   250       0.585  35.891 -19.145  1.00 47.10           C  
ATOM   1758  N   GLN   251       3.714  36.499 -19.150  1.00 47.40           N  
ATOM   1759  CA  GLN   251       5.108  36.485 -19.619  1.00 47.72           C  
ATOM   1760  C   GLN   251       5.992  35.752 -18.607  1.00 47.15           C  
ATOM   1761  O   GLN   251       6.709  34.823 -18.961  1.00 47.30           O  
ATOM   1762  CB  GLN   251       5.616  37.924 -19.883  1.00 47.82           C  
ATOM   1763  CG  GLN   251       7.139  38.186 -19.666  1.00 50.16           C  
ATOM   1764  CD  GLN   251       7.488  39.108 -18.448  1.00 55.43           C  
ATOM   1765  OE1 GLN   251       8.672  39.397 -18.198  1.00 57.79           O  
ATOM   1766  NE2 GLN   251       6.471  39.574 -17.717  1.00 51.70           N  
ATOM   1767  N   LEU   252       5.888  36.124 -17.345  1.00 46.40           N  
ATOM   1768  CA  LEU   252       6.785  35.611 -16.347  1.00 45.83           C  
ATOM   1769  C   LEU   252       6.648  34.127 -16.155  1.00 45.15           C  
ATOM   1770  O   LEU   252       7.614  33.437 -15.989  1.00 45.08           O  
ATOM   1771  CB  LEU   252       6.532  36.290 -15.001  1.00 45.21           C  
ATOM   1772  CG  LEU   252       7.059  37.678 -14.736  1.00 47.10           C  
ATOM   1773  CD1 LEU   252       6.263  38.387 -13.704  1.00 50.45           C  
ATOM   1774  CD2 LEU   252       8.474  37.620 -14.342  1.00 46.31           C  
ATOM   1775  N   LEU   253       5.428  33.655 -16.131  1.00 44.83           N  
ATOM   1776  CA  LEU   253       5.173  32.277 -15.753  1.00 45.50           C  
ATOM   1777  C   LEU   253       5.338  31.295 -16.921  1.00 47.33           C  
ATOM   1778  O   LEU   253       4.850  30.149 -16.882  1.00 47.87           O  
ATOM   1779  CB  LEU   253       3.790  32.160 -15.118  1.00 45.04           C  
ATOM   1780  CG  LEU   253       3.754  32.686 -13.679  1.00 44.08           C  
ATOM   1781  CD1 LEU   253       2.335  32.971 -13.207  1.00 41.18           C  
ATOM   1782  CD2 LEU   253       4.480  31.688 -12.774  1.00 44.27           C  
ATOM   1783  N   LYS   254       6.051  31.725 -17.954  1.00 48.81           N  
ATOM   1784  CA  LYS   254       6.266  30.875 -19.122  1.00 49.32           C  
ATOM   1785  C   LYS   254       7.219  29.706 -18.901  1.00 49.52           C  
ATOM   1786  O   LYS   254       7.221  28.754 -19.695  1.00 49.50           O  
ATOM   1787  CB  LYS   254       6.687  31.703 -20.338  1.00 49.85           C  
ATOM   1788  CG  LYS   254       5.620  31.769 -21.438  1.00 51.80           C  
ATOM   1789  CD  LYS   254       4.301  32.361 -20.926  1.00 53.96           C  
ATOM   1790  CE  LYS   254       3.413  31.331 -20.190  1.00 54.77           C  
ATOM   1791  NZ  LYS   254       2.785  31.953 -18.947  1.00 53.07           N  
END
