
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  166 ( 1296),  selected  166 , name 2fg9_A
# Molecule2: number of CA atoms  234 ( 1778),  selected  234 , name T0506.pdb
# PARAMETERS: 2fg9_A.T0506.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H   -12_A      V       4           -
LGA    H   -11_A      A       5           -
LGA    H   -10_A      P       6           -
LGA    H    -9_A      P       7           -
LGA    H    -8_A      V       8           -
LGA    H    -7_A      I       9           -
LGA    E    -6_A      T      10           -
LGA    N    -5_A      P      11           -
LGA    L    -4_A      R      12           -
LGA    Y    -3_A      -       -           -
LGA    F    -2_A      -       -           -
LGA    Q    -1_A      -       -           -
LGA    G     0_A      -       -           -
LGA    X     1_A      -       -           -
LGA    K     2_A      -       -           -
LGA    T     3_A      -       -           -
LGA    I     4_A      -       -           -
LGA    V     5_A      -       -           -
LGA    I     6_A      F      24           #
LGA    E     7_A      E      25          5.090
LGA    D     8_A      A      26          3.564
LGA    K     9_A      V      27          2.865
LGA    Q    10_A      R      28          3.385
LGA    R    11_A      V      29          1.985
LGA    I    12_A      A      30          1.035
LGA    E    13_A      R      31          2.359
LGA    S    14_A      D      32          1.413
LGA    I    15_A      V      33          1.440
LGA    I    16_A      L      34          2.859
LGA    L    17_A      H      35          2.906
LGA    Q    18_A      T      36          2.853
LGA    A    19_A      S      37          2.345
LGA    D    20_A      R      38          2.687
LGA    A    21_A      T      39          0.899
LGA    C    22_A      A      40          0.357
LGA    F    23_A      A      41          0.364
LGA    V    24_A      L      42          0.291
LGA    G    25_A      A      43          0.750
LGA    I    26_A      T      44          0.813
LGA    T    27_A      L      45          1.367
LGA    D    28_A      D      46          1.075
LGA    L    29_A      P      47          2.004
LGA    E    30_A      V      48           #
LGA    -       -      S      49           -
LGA    G    31_A      G      50          0.700
LGA    N    32_A      Y      51          0.539
LGA    P    33_A      P      52          1.262
LGA    Y    34_A      Y      53          0.824
LGA    V    35_A      T      54          1.051
LGA    V    36_A      T      55          0.579
LGA    P    37_A      A      56          0.419
LGA    X    38_A      T      57          0.473
LGA    N    39_A      N      58          0.825
LGA    F    40_A      I      59          1.410
LGA    G    41_A      G      60          0.738
LGA    Y    42_A      I      61          1.787
LGA    E    43_A      E      62          2.649
LGA    -       -      P      63           -
LGA    N    44_A      D      64          1.899
LGA    D    45_A      G      65          3.673
LGA    T    46_A      T      66          1.608
LGA    L    47_A      P      67          1.486
LGA    Y    48_A      F      68          1.057
LGA    L    49_A      F      69          0.935
LGA    H    50_A      F      70          0.861
LGA    S    51_A      A      71          1.803
LGA    G    52_A      A      72          1.600
LGA    P    53_A      G      73          1.627
LGA    E    54_A      L      74          2.094
LGA    G    55_A      T      75          3.490
LGA    G    56_A      L      76          1.267
LGA    K    57_A      H      77          1.312
LGA    I    58_A      A      78          2.209
LGA    E    59_A      R      79          2.229
LGA    X    60_A      N      80          1.263
LGA    L    61_A      M      81          1.183
LGA    Q    62_A      E      82          1.920
LGA    R    63_A      T      83          2.090
LGA    N    64_A      D      84          1.399
LGA    N    65_A      A      85          0.616
LGA    N    66_A      R      86          0.813
LGA    V    67_A      I      87          0.605
LGA    C    68_A      S      88          0.529
LGA    I    69_A      V      89          0.246
LGA    T    70_A      T      90          0.353
LGA    F    71_A      L      91          1.689
LGA    S    72_A      A      92          2.198
LGA    L    73_A      P      93          2.913
LGA    -       -      F      94           -
LGA    -       -      G      95           -
LGA    -       -      K      96           -
LGA    G    74_A      G      97          2.640
LGA    H    75_A      D      98          3.839
LGA    -       -      A      99           -
LGA    -       -      L     100           -
LGA    K    76_A      T     101          5.037
LGA    L    77_A      -       -           -
LGA    V    78_A      -       -           -
LGA    Y    79_A      -       -           -
LGA    Q    80_A      -       -           -
LGA    H    81_A      -       -           -
LGA    C    86_A      -       -           -
LGA    S    87_A      -       -           -
LGA    Y    88_A      -       -           -
LGA    S    89_A      -       -           -
LGA    X    90_A      -       -           -
LGA    R    91_A      -       -           -
LGA    S    92_A      L     102          2.394
LGA    E    93_A      P     103          1.111
LGA    S    94_A      R     104          0.544
LGA    A    95_A      L     105          0.545
LGA    X    96_A      T     106          0.862
LGA    C    97_A      L     107          1.007
LGA    R    98_A      V     108          1.312
LGA    G    99_A      G     109          1.701
LGA    K   100_A      R     110          0.606
LGA    V   101_A      A     111          0.858
LGA    E   102_A      D     112          1.857
LGA    F   103_A      R     113          2.018
LGA    I   104_A      I     114          2.289
LGA    E   105_A      G     115          3.536
LGA    D   106_A      P     116          0.779
LGA    X   107_A      -       -           -
LGA    E   108_A      D     117          3.641
LGA    E   109_A      E     118          0.594
LGA    K   110_A      V     119          0.999
LGA    R   111_A      P     120          1.801
LGA    H   112_A      L     121          1.302
LGA    A   113_A      A     122          1.531
LGA    L   114_A      I     123          2.182
LGA    D   115_A      A     124          2.557
LGA    I   116_A      R     125          2.685
LGA    I   117_A      Y     126          2.333
LGA    X   118_A      I     127          2.594
LGA    R   119_A      A     128          2.713
LGA    H   120_A      R     129          3.055
LGA    Y   121_A      Y     130          3.838
LGA    T   122_A      P     131          5.515
LGA    K   123_A      K     132           -
LGA    D   124_A      A     133           -
LGA    Q   125_A      -       -           -
LGA    F   126_A      K     134          5.897
LGA    S   127_A      L     135           -
LGA    -       -      Y     136           -
LGA    Y   128_A      L     137          7.401
LGA    S   129_A      -       -           -
LGA    D   130_A      -       -           -
LGA    P   131_A      -       -           -
LGA    A   132_A      S     138          3.455
LGA    V   133_A      L     139           -
LGA    R   134_A      P     140          6.620
LGA    N   135_A      D     141          2.919
LGA    V   136_A      T     142          0.785
LGA    K   137_A      R     143          0.538
LGA    V   138_A      L     144          0.653
LGA    W   139_A      Y     145          1.156
LGA    K   140_A      R     146          1.562
LGA    V   141_A      L     147          1.414
LGA    P   142_A      R     148          2.304
LGA    V   143_A      T     149          1.975
LGA    D   144_A      E     150          2.368
LGA    Q   145_A      G     151          2.423
LGA    X   146_A      V     152          2.853
LGA    T   147_A      Q     153          2.687
LGA    G   148_A      I     154          1.133
LGA    K   149_A      N     155          0.814
LGA    V   150_A      G     156          1.088
LGA    F   151_A      S     163           -
LGA    G   152_A      N     164           -
LGA    L   153_A      I     165           -
LGA    R   154_A      T     166           -
LGA    A   155_A      P     167           -
LGA    D   156_A      A     168           -
LGA    E   157_A      D     169           -
LGA    -       -      L     170           -
LGA    -       -      R     171           -
LGA    -       -      T     172           -
LGA    -       -      D     173           -
LGA    -       -      L     174           -
LGA    -       -      S     175           -
LGA    -       -      G     176           -
LGA    -       -      A     177           -
LGA    -       -      E     178           -
LGA    -       -      E     179           -
LGA    -       -      L     180           -
LGA    -       -      M     181           -
LGA    -       -      A     182           -
LGA    -       -      A     183           -
LGA    -       -      A     184           -
LGA    -       -      E     185           -
LGA    -       -      S     186           -
LGA    -       -      E     187           -
LGA    -       -      A     188           -
LGA    -       -      T     189           -
LGA    -       -      R     190           -
LGA    -       -      L     191           -
LGA    -       -      N     192           -
LGA    -       -      A     193           -
LGA    -       -      I     194           -
LGA    -       -      K     195           -
LGA    -       -      G     196           -
LGA    -       -      E     197           -
LGA    -       -      A     198           -
LGA    -       -      S     199           -
LGA    -       -      R     200           -
LGA    -       -      L     201           -
LGA    -       -      A     202           -
LGA    -       -      V     203           -
LGA    -       -      L     204           -
LGA    -       -      A     205           -
LGA    -       -      G     206           -
LGA    -       -      A     207           -
LGA    -       -      K     208           -
LGA    -       -      T     209           -
LGA    -       -      G     210           -
LGA    -       -      R     211           -
LGA    -       -      W     212           -
LGA    -       -      K     213           -
LGA    -       -      I     214           -
LGA    -       -      T     215           -
LGA    -       -      S     216           -
LGA    -       -      I     217           -
LGA    -       -      D     218           -
LGA    -       -      P     219           -
LGA    -       -      D     220           -
LGA    -       -      G     221           -
LGA    -       -      I     222           -
LGA    -       -      D     223           -
LGA    -       -      L     224           -
LGA    -       -      A     225           -
LGA    -       -      S     226           -
LGA    -       -      A     227           -
LGA    -       -      S     228           -
LGA    -       -      D     229           -
LGA    -       -      L     230           -
LGA    -       -      A     231           -
LGA    -       -      R     232           -
LGA    -       -      L     233           -
LGA    -       -      W     234           -
LGA    -       -      F     235           -
LGA    -       -      A     236           -
LGA    -       -      E     237           -
LGA    -       -      R     238           -
LGA    -       -      V     239           -
LGA    -       -      E     240           -
LGA    -       -      T     241           -
LGA    -       -      L     242           -
LGA    -       -      K     243           -
LGA    -       -      Q     244           -
LGA    -       -      F     245           -
LGA    -       -      E     246           -
LGA    -       -      K     247           -
LGA    -       -      A     248           -
LGA    -       -      L     249           -
LGA    -       -      A     250           -
LGA    -       -      Q     251           -
LGA    -       -      L     252           -
LGA    -       -      L     253           -
LGA    -       -      K     254           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  166  234    5.0    119    2.31    13.45     40.701     4.940

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.862945 * X  +  -0.372569 * Y  +  -0.341349 * Z  +  73.440544
  Y_new =   0.225938 * X  +  -0.888747 * Y  +   0.398850 * Z  +  31.396811
  Z_new =  -0.451972 * X  +   0.267062 * Y  +   0.851117 * Z  + -18.145420 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.304049   -2.837544  [ DEG:    17.4207   -162.5793 ]
  Theta =   0.468974    2.672618  [ DEG:    26.8703    153.1297 ]
  Phi   =   2.885518   -0.256075  [ DEG:   165.3280    -14.6720 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fg9_A                                        
REMARK     2: T0506.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fg9_A.T0506.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  166  234   5.0  119   2.31   13.45  40.701
REMARK  ---------------------------------------------------------- 
MOLECULE 2fg9_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   21-DEC-05   2FG9              
TITLE     CRYSTAL STRUCTURE OF (NP_811990.1) FROM BACTEROIDES                   
TITLE    2 THETAIOTAOMICRON VPI-5482 AT 2.20 A RESOLUTION                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: 5-NITROIMIDAZOLE ANTIBIOTIC RESISTANCE PROTEIN;            
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACTEROIDES THETAIOTAOMICRON VPI-5482;          
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: NP_811990.1;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    NP_811990.1, STRUCTURAL GENOMICS, JOINT CENTER FOR                    
KEYWDS   2 STRUCTURAL GENOMICS, JCSG, PROTEIN STRUCTURE INITIATIVE, PSI         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   2   03-OCT-06 2FG9    1       TITLE  JRNL                              
REVDAT   1   10-JAN-06 2FG9    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF (NP_811990.1) FROM                      
JRNL        TITL 2 BACTEROIDES THETAIOTAOMICRON VPI-5482 AT 2.20 A              
JRNL        TITL 3 RESOLUTION                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  2FG9 A    1   159  GB     29340391 AAO78184         1    159             
SEQRES   1 A  178  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 A  178  ASN LEU TYR PHE GLN GLY MSE LYS THR ILE VAL ILE GLU          
SEQRES   3 A  178  ASP LYS GLN ARG ILE GLU SER ILE ILE LEU GLN ALA ASP          
SEQRES   4 A  178  ALA CYS PHE VAL GLY ILE THR ASP LEU GLU GLY ASN PRO          
SEQRES   5 A  178  TYR VAL VAL PRO MSE ASN PHE GLY TYR GLU ASN ASP THR          
SEQRES   6 A  178  LEU TYR LEU HIS SER GLY PRO GLU GLY GLY LYS ILE GLU          
SEQRES   7 A  178  MSE LEU GLN ARG ASN ASN ASN VAL CYS ILE THR PHE SER          
SEQRES   8 A  178  LEU GLY HIS LYS LEU VAL TYR GLN HIS LYS GLN VAL ALA          
SEQRES   9 A  178  CYS SER TYR SER MSE ARG SER GLU SER ALA MSE CYS ARG          
SEQRES  10 A  178  GLY LYS VAL GLU PHE ILE GLU ASP MSE GLU GLU LYS ARG          
SEQRES  11 A  178  HIS ALA LEU ASP ILE ILE MSE ARG HIS TYR THR LYS ASP          
SEQRES  12 A  178  GLN PHE SER TYR SER ASP PRO ALA VAL ARG ASN VAL LYS          
SEQRES  13 A  178  VAL TRP LYS VAL PRO VAL ASP GLN MSE THR GLY LYS VAL          
SEQRES  14 A  178  PHE GLY LEU ARG ALA ASP GLU LYS PRO                          
HET    MSE  A   1       8                                                       
HET    MSE  A  38       8                                                       
HET    MSE  A  60       8                                                       
HET    MSE  A  90       8                                                       
HET    MSE  A  96       8                                                       
HET    MSE  A 107       8                                                       
HET    MSE  A 118       8                                                       
HET    MSE  A 146       8                                                       
HET     NI      1       1                                                       
HET    FAD      2      53                                                       
HET    EDO      3       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      NI NICKEL (II) ION                                                  
HETNAM     FAD FLAVIN-ADENINE DINUCLEOTIDE                                      
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   2   NI    NI 2+                                                        
FORMUL   3  FAD    C27 H33 N9 O15 P2                                            
FORMUL   4  EDO    C2 H6 O2                                                     
FORMUL   5  HOH   *46(H2 O)                                                     
CRYST1  134.000  134.000  134.000  90.00  90.00  90.00 I 4 3 2      48          
ATOM      1  N   HIS A -12      30.190  18.735   2.848  1.00 57.72           N  
ATOM      2  CA  HIS A -12      30.585  20.175   3.075  1.00 56.90           C  
ATOM      3  C   HIS A -12      32.098  20.210   3.366  1.00 54.72           C  
ATOM      4  O   HIS A -12      32.646  19.226   3.940  1.00 54.97           O  
ATOM      5  CB  HIS A -12      29.750  20.792   4.204  1.00 57.58           C  
ATOM      6  CG  HIS A -12      28.272  20.556   4.064  1.00 59.80           C  
ATOM      7  N   HIS A -11      32.781  21.282   2.929  1.00 50.89           N  
ATOM      8  CA  HIS A -11      34.248  21.338   3.027  1.00 48.47           C  
ATOM      9  C   HIS A -11      34.681  22.717   3.354  1.00 46.11           C  
ATOM     10  O   HIS A -11      33.888  23.649   3.293  1.00 45.93           O  
ATOM     11  CB  HIS A -11      34.960  20.826   1.755  1.00 48.12           C  
ATOM     12  CG  HIS A -11      34.775  21.726   0.572  1.00 48.70           C  
ATOM     13  ND1 HIS A -11      33.726  21.592  -0.304  1.00 46.41           N  
ATOM     14  CD2 HIS A -11      35.461  22.817   0.168  1.00 46.93           C  
ATOM     15  CE1 HIS A -11      33.789  22.537  -1.212  1.00 46.48           C  
ATOM     16  NE2 HIS A -11      34.823  23.303  -0.941  1.00 46.41           N  
ATOM     17  N   HIS A -10      35.945  22.842   3.748  1.00 44.46           N  
ATOM     18  CA  HIS A -10      36.533  24.127   4.148  1.00 43.18           C  
ATOM     19  C   HIS A -10      37.873  24.270   3.521  1.00 40.73           C  
ATOM     20  O   HIS A -10      38.499  23.317   3.203  1.00 39.06           O  
ATOM     21  CB  HIS A -10      36.732  24.203   5.650  1.00 44.20           C  
ATOM     22  CG  HIS A -10      35.500  23.912   6.424  1.00 47.71           C  
ATOM     23  ND1 HIS A -10      34.673  24.915   6.898  1.00 50.23           N  
ATOM     24  CD2 HIS A -10      34.932  22.734   6.793  1.00 49.77           C  
ATOM     25  CE1 HIS A -10      33.647  24.368   7.529  1.00 51.32           C  
ATOM     26  NE2 HIS A -10      33.771  23.051   7.466  1.00 52.60           N  
ATOM     27  N   HIS A  -9      38.293  25.500   3.322  1.00 39.83           N  
ATOM     28  CA  HIS A  -9      39.610  25.783   2.802  1.00 39.15           C  
ATOM     29  C   HIS A  -9      40.348  26.539   3.895  1.00 40.92           C  
ATOM     30  O   HIS A  -9      39.865  27.524   4.361  1.00 40.50           O  
ATOM     31  CB  HIS A  -9      39.476  26.649   1.560  1.00 37.42           C  
ATOM     32  CG  HIS A  -9      38.792  25.963   0.427  1.00 32.38           C  
ATOM     33  ND1 HIS A  -9      39.460  25.167  -0.469  1.00 28.35           N  
ATOM     34  CD2 HIS A  -9      37.497  25.939   0.060  1.00 27.70           C  
ATOM     35  CE1 HIS A  -9      38.596  24.671  -1.332  1.00 29.04           C  
ATOM     36  NE2 HIS A  -9      37.401  25.138  -1.035  1.00 27.46           N  
ATOM     37  N   HIS A  -8      41.499  26.050   4.318  0.50 42.52           N  
ATOM     39  CA  HIS A  -8      42.264  26.738   5.344  0.50 44.34           C  
ATOM     41  C   HIS A  -8      43.568  27.139   4.718  0.50 45.90           C  
ATOM     43  O   HIS A  -8      44.089  26.438   3.868  0.50 45.77           O  
ATOM     45  CB  HIS A  -8      42.493  25.863   6.583  0.50 44.45           C  
ATOM     47  CG  HIS A  -8      41.250  25.603   7.377  0.50 44.39           C  
ATOM     49  ND1 HIS A  -8      40.138  26.412   7.303  0.50 45.60           N  
ATOM     51  CD2 HIS A  -8      40.956  24.639   8.281  0.50 44.46           C  
ATOM     53  CE1 HIS A  -8      39.196  25.933   8.099  0.50 45.97           C  
ATOM     55  NE2 HIS A  -8      39.671  24.864   8.713  0.50 44.51           N  
ATOM     57  N   HIS A  -7      44.071  28.298   5.119  1.00 48.17           N  
ATOM     58  CA  HIS A  -7      45.415  28.761   4.681  1.00 50.83           C  
ATOM     59  C   HIS A  -7      46.336  28.976   5.907  1.00 53.36           C  
ATOM     60  O   HIS A  -7      45.876  29.374   7.015  1.00 54.56           O  
ATOM     61  CB  HIS A  -7      45.316  30.042   3.859  1.00 51.58           C  
ATOM     62  CG  HIS A  -7      44.202  30.046   2.854  1.00 51.47           C  
ATOM     63  ND1 HIS A  -7      42.879  30.209   3.212  1.00 52.70           N  
ATOM     64  CD2 HIS A  -7      44.220  29.940   1.502  1.00 50.68           C  
ATOM     65  CE1 HIS A  -7      42.129  30.188   2.124  1.00 51.97           C  
ATOM     66  NE2 HIS A  -7      42.918  30.019   1.075  1.00 51.90           N  
ATOM     67  N   GLU A  -6      47.615  28.691   5.696  1.00 55.66           N  
ATOM     68  CA  GLU A  -6      48.678  28.955   6.686  1.00 57.37           C  
ATOM     69  C   GLU A  -6      49.152  30.442   6.674  1.00 58.34           C  
ATOM     70  O   GLU A  -6      49.549  30.977   7.723  1.00 59.62           O  
ATOM     71  CB  GLU A  -6      49.886  28.003   6.452  1.00 56.94           C  
ATOM     72  N   ASN A  -5      49.102  31.108   5.512  1.00 58.69           N  
ATOM     73  CA  ASN A  -5      49.823  32.387   5.336  1.00 58.31           C  
ATOM     74  C   ASN A  -5      49.010  33.522   4.694  1.00 57.28           C  
ATOM     75  O   ASN A  -5      49.429  34.093   3.678  1.00 58.29           O  
ATOM     76  CB  ASN A  -5      51.141  32.159   4.548  1.00 58.26           C  
ATOM     77  N   LEU A  -4      47.899  33.882   5.330  1.00 55.52           N  
ATOM     78  CA  LEU A  -4      47.058  34.970   4.859  1.00 54.20           C  
ATOM     79  C   LEU A  -4      47.441  36.331   5.505  1.00 53.46           C  
ATOM     80  O   LEU A  -4      47.673  36.427   6.709  1.00 51.98           O  
ATOM     81  CB  LEU A  -4      45.579  34.659   5.128  1.00 54.12           C  
ATOM     82  CG  LEU A  -4      44.786  33.803   4.130  1.00 53.29           C  
ATOM     83  CD1 LEU A  -4      43.430  33.515   4.683  1.00 51.91           C  
ATOM     84  CD2 LEU A  -4      44.632  34.462   2.758  1.00 54.33           C  
ATOM     85  N   TYR A  -3      47.492  37.366   4.675  1.00 52.82           N  
ATOM     86  CA  TYR A  -3      47.815  38.720   5.102  1.00 53.16           C  
ATOM     87  C   TYR A  -3      46.593  39.576   4.971  1.00 53.15           C  
ATOM     88  O   TYR A  -3      46.085  39.761   3.876  1.00 51.22           O  
ATOM     89  CB  TYR A  -3      48.945  39.306   4.277  1.00 53.62           C  
ATOM     90  CG  TYR A  -3      50.280  38.857   4.798  1.00 54.43           C  
ATOM     91  CD1 TYR A  -3      50.751  37.582   4.526  1.00 54.72           C  
ATOM     92  CD2 TYR A  -3      51.044  39.701   5.626  1.00 55.31           C  
ATOM     93  CE1 TYR A  -3      51.977  37.152   5.033  1.00 56.99           C  
ATOM     94  CE2 TYR A  -3      52.257  39.288   6.142  1.00 56.19           C  
ATOM     95  CZ  TYR A  -3      52.731  38.010   5.844  1.00 56.56           C  
ATOM     96  OH  TYR A  -3      53.962  37.594   6.347  1.00 56.48           O  
ATOM     97  N   PHE A  -2      46.133  40.045   6.126  1.00 54.54           N  
ATOM     98  CA  PHE A  -2      45.024  40.977   6.274  1.00 56.13           C  
ATOM     99  C   PHE A  -2      45.236  42.193   5.434  1.00 57.88           C  
ATOM    100  O   PHE A  -2      46.347  42.673   5.298  1.00 57.77           O  
ATOM    101  CB  PHE A  -2      44.911  41.394   7.729  1.00 55.75           C  
ATOM    102  CG  PHE A  -2      43.825  42.388   8.000  1.00 56.56           C  
ATOM    103  CD1 PHE A  -2      42.534  41.960   8.301  1.00 56.83           C  
ATOM    104  CD2 PHE A  -2      44.096  43.744   7.986  1.00 55.81           C  
ATOM    105  CE1 PHE A  -2      41.557  42.836   8.556  1.00 56.11           C  
ATOM    106  CE2 PHE A  -2      43.107  44.640   8.242  1.00 56.78           C  
ATOM    107  CZ  PHE A  -2      41.834  44.199   8.520  1.00 56.47           C  
ATOM    108  N   GLN A  -1      44.155  42.689   4.858  1.00 61.20           N  
ATOM    109  CA  GLN A  -1      44.208  43.898   4.050  1.00 63.62           C  
ATOM    110  C   GLN A  -1      43.008  44.792   4.315  1.00 65.20           C  
ATOM    111  O   GLN A  -1      42.525  44.940   5.463  1.00 65.67           O  
ATOM    112  CB  GLN A  -1      44.323  43.519   2.572  1.00 63.71           C  
ATOM    113  CG  GLN A  -1      45.443  42.558   2.366  1.00 66.04           C  
ATOM    114  CD  GLN A  -1      45.827  42.395   0.935  1.00 69.60           C  
ATOM    115  OE1 GLN A  -1      47.030  42.427   0.582  1.00 70.14           O  
ATOM    116  NE2 GLN A  -1      44.815  42.209   0.079  1.00 70.44           N  
ATOM    117  N   GLY A   0      42.527  45.417   3.247  1.00 66.95           N  
ATOM    118  CA  GLY A   0      41.529  46.444   3.406  1.00 67.42           C  
ATOM    119  C   GLY A   0      40.257  45.827   3.889  1.00 67.82           C  
ATOM    120  O   GLY A   0      40.110  44.602   3.950  1.00 68.53           O  
HETATM  121  N   MSE A   1      39.381  46.698   4.318  1.00 68.10           N  
HETATM  122  CA  MSE A   1      37.987  46.498   4.171  1.00 69.27           C  
HETATM  123  C   MSE A   1      37.597  47.663   3.334  1.00 67.67           C  
HETATM  124  O   MSE A   1      38.170  48.737   3.465  1.00 68.68           O  
HETATM  125  CB  MSE A   1      37.275  46.629   5.484  1.00 69.74           C  
HETATM  126  CG  MSE A   1      37.838  45.790   6.615  1.00 71.94           C  
HETATM  127 SE   MSE A   1      37.355  46.635   8.347  0.75 75.24          SE  
HETATM  128  CE  MSE A   1      38.980  46.278   9.308  1.00 72.94           C  
ATOM    129  N   LYS A   2      36.661  47.472   2.441  1.00 66.23           N  
ATOM    130  CA  LYS A   2      36.121  48.585   1.697  1.00 65.16           C  
ATOM    131  C   LYS A   2      34.640  48.434   1.832  1.00 63.82           C  
ATOM    132  O   LYS A   2      34.120  47.308   1.823  1.00 63.55           O  
ATOM    133  CB  LYS A   2      36.568  48.561   0.218  1.00 65.44           C  
ATOM    134  CG  LYS A   2      36.219  47.288  -0.590  1.00 65.89           C  
ATOM    135  N   THR A   3      33.955  49.542   2.025  1.00 62.12           N  
ATOM    136  CA  THR A   3      32.527  49.525   1.849  1.00 61.52           C  
ATOM    137  C   THR A   3      32.211  50.108   0.494  1.00 60.22           C  
ATOM    138  O   THR A   3      32.930  50.952  -0.015  1.00 60.92           O  
ATOM    139  CB  THR A   3      31.771  50.285   2.955  1.00 61.47           C  
ATOM    140  OG1 THR A   3      32.275  51.610   3.063  1.00 63.67           O  
ATOM    141  CG2 THR A   3      31.950  49.606   4.268  1.00 61.29           C  
ATOM    142  N   ILE A   4      31.141  49.627  -0.104  1.00 58.99           N  
ATOM    143  CA  ILE A   4      30.642  50.200  -1.318  1.00 58.30           C  
ATOM    144  C   ILE A   4      29.192  50.584  -1.067  1.00 57.69           C  
ATOM    145  O   ILE A   4      28.482  49.887  -0.366  1.00 57.01           O  
ATOM    146  CB  ILE A   4      30.748  49.220  -2.466  1.00 58.08           C  
ATOM    147  CG1 ILE A   4      32.197  48.751  -2.628  1.00 59.27           C  
ATOM    148  CG2 ILE A   4      30.282  49.882  -3.735  1.00 58.78           C  
ATOM    149  N   VAL A   5      28.777  51.711  -1.621  1.00 57.59           N  
ATOM    150  CA  VAL A   5      27.422  52.188  -1.490  1.00 57.85           C  
ATOM    151  C   VAL A   5      26.543  51.481  -2.516  1.00 58.53           C  
ATOM    152  O   VAL A   5      26.912  51.340  -3.677  1.00 59.22           O  
ATOM    153  CB  VAL A   5      27.366  53.719  -1.680  1.00 58.06           C  
ATOM    154  CG1 VAL A   5      25.915  54.215  -1.851  1.00 58.41           C  
ATOM    155  CG2 VAL A   5      28.050  54.445  -0.502  1.00 56.56           C  
ATOM    156  N   ILE A   6      25.395  51.004  -2.066  1.00 59.42           N  
ATOM    157  CA  ILE A   6      24.368  50.449  -2.943  1.00 59.72           C  
ATOM    158  C   ILE A   6      23.390  51.593  -3.254  1.00 60.43           C  
ATOM    159  O   ILE A   6      22.746  52.137  -2.346  1.00 59.97           O  
ATOM    160  CB  ILE A   6      23.642  49.287  -2.267  1.00 59.77           C  
ATOM    161  CG1 ILE A   6      24.621  48.163  -1.928  1.00 60.26           C  
ATOM    162  CG2 ILE A   6      22.504  48.743  -3.148  1.00 60.09           C  
ATOM    163  CD1 ILE A   6      24.006  47.080  -1.057  1.00 61.87           C  
ATOM    164  N   GLU A   7      23.329  51.972  -4.534  1.00 60.69           N  
ATOM    165  CA  GLU A   7      22.458  53.038  -5.008  1.00 61.05           C  
ATOM    166  C   GLU A   7      21.037  52.535  -5.321  1.00 60.64           C  
ATOM    167  O   GLU A   7      20.072  53.252  -5.085  1.00 61.22           O  
ATOM    168  CB  GLU A   7      23.047  53.711  -6.275  1.00 61.53           C  
ATOM    169  CG  GLU A   7      24.057  54.836  -6.047  1.00 61.50           C  
ATOM    170  N   ASP A   8      20.934  51.325  -5.864  1.00 59.94           N  
ATOM    171  CA  ASP A   8      19.696  50.781  -6.425  1.00 59.37           C  
ATOM    172  C   ASP A   8      18.652  50.543  -5.329  1.00 58.32           C  
ATOM    173  O   ASP A   8      18.842  49.711  -4.461  1.00 57.33           O  
ATOM    174  CB  ASP A   8      20.050  49.486  -7.190  1.00 59.90           C  
ATOM    175  CG  ASP A   8      18.821  48.702  -7.705  1.00 63.09           C  
ATOM    176  OD1 ASP A   8      17.706  49.265  -7.836  1.00 65.82           O  
ATOM    177  OD2 ASP A   8      18.993  47.491  -7.997  1.00 66.95           O  
ATOM    178  N   LYS A   9      17.559  51.305  -5.376  1.00 57.63           N  
ATOM    179  CA  LYS A   9      16.513  51.270  -4.342  1.00 57.48           C  
ATOM    180  C   LYS A   9      15.833  49.901  -4.205  1.00 57.39           C  
ATOM    181  O   LYS A   9      15.510  49.466  -3.094  1.00 56.95           O  
ATOM    182  CB  LYS A   9      15.449  52.361  -4.608  1.00 57.55           C  
ATOM    183  CG  LYS A   9      14.286  52.340  -3.609  1.00 57.81           C  
ATOM    184  CD  LYS A   9      13.351  53.544  -3.708  1.00 57.31           C  
ATOM    185  CE  LYS A   9      12.099  53.260  -2.886  1.00 58.02           C  
ATOM    186  NZ  LYS A   9      11.132  54.387  -2.791  1.00 59.24           N  
ATOM    187  N   GLN A  10      15.629  49.232  -5.336  1.00 57.21           N  
ATOM    188  CA  GLN A  10      15.048  47.893  -5.345  1.00 57.19           C  
ATOM    189  C   GLN A  10      15.977  46.885  -4.695  1.00 56.14           C  
ATOM    190  O   GLN A  10      15.529  45.966  -4.017  1.00 55.95           O  
ATOM    191  CB  GLN A  10      14.705  47.448  -6.777  1.00 57.63           C  
ATOM    192  CG  GLN A  10      13.421  48.088  -7.310  1.00 59.60           C  
ATOM    193  CD  GLN A  10      13.572  49.588  -7.515  1.00 63.94           C  
ATOM    194  OE1 GLN A  10      14.607  50.063  -8.054  1.00 65.02           O  
ATOM    195  NE2 GLN A  10      12.554  50.355  -7.076  1.00 62.88           N  
ATOM    196  N   ARG A  11      17.271  47.061  -4.900  1.00 55.50           N  
ATOM    197  CA  ARG A  11      18.259  46.222  -4.231  1.00 55.39           C  
ATOM    198  C   ARG A  11      18.316  46.420  -2.707  1.00 54.29           C  
ATOM    199  O   ARG A  11      18.476  45.463  -1.960  1.00 53.73           O  
ATOM    200  CB  ARG A  11      19.628  46.482  -4.809  1.00 55.70           C  
ATOM    201  CG  ARG A  11      20.618  45.467  -4.368  1.00 58.36           C  
ATOM    202  CD  ARG A  11      21.963  45.721  -4.991  1.00 61.25           C  
ATOM    203  NE  ARG A  11      22.999  44.895  -4.364  1.00 62.44           N  
ATOM    204  CZ  ARG A  11      24.304  45.051  -4.576  1.00 64.41           C  
ATOM    205  NH1 ARG A  11      24.729  46.004  -5.393  1.00 64.56           N  
ATOM    206  NH2 ARG A  11      25.194  44.254  -3.967  1.00 65.06           N  
ATOM    207  N   ILE A  12      18.185  47.668  -2.260  1.00 53.41           N  
ATOM    208  CA  ILE A  12      18.121  47.976  -0.833  1.00 52.08           C  
ATOM    209  C   ILE A  12      16.839  47.391  -0.258  1.00 52.00           C  
ATOM    210  O   ILE A  12      16.858  46.733   0.775  1.00 52.15           O  
ATOM    211  CB  ILE A  12      18.159  49.507  -0.577  1.00 51.55           C  
ATOM    212  CG1 ILE A  12      19.451  50.110  -1.120  1.00 51.16           C  
ATOM    213  CG2 ILE A  12      18.033  49.823   0.890  1.00 50.36           C  
ATOM    214  CD1 ILE A  12      19.450  51.632  -1.153  1.00 51.71           C  
ATOM    215  N   GLU A  13      15.726  47.600  -0.944  1.00 52.26           N  
ATOM    216  CA  GLU A  13      14.455  47.013  -0.525  1.00 52.26           C  
ATOM    217  C   GLU A  13      14.504  45.507  -0.522  1.00 52.85           C  
ATOM    218  O   GLU A  13      13.899  44.868   0.342  1.00 53.26           O  
ATOM    219  CB  GLU A  13      13.328  47.514  -1.412  1.00 52.51           C  
ATOM    220  CG  GLU A  13      12.910  48.898  -1.058  1.00 52.97           C  
ATOM    221  CD  GLU A  13      11.896  49.479  -2.022  1.00 55.29           C  
ATOM    222  OE1 GLU A  13      11.782  48.917  -3.135  1.00 59.16           O  
ATOM    223  OE2 GLU A  13      11.226  50.485  -1.667  1.00 52.34           O  
ATOM    224  N   SER A  14      15.261  44.920  -1.447  1.00 53.20           N  
ATOM    225  CA  SER A  14      15.414  43.459  -1.444  1.00 53.66           C  
ATOM    226  C   SER A  14      16.090  42.968  -0.170  1.00 53.41           C  
ATOM    227  O   SER A  14      15.704  41.937   0.382  1.00 52.88           O  
ATOM    228  CB  SER A  14      16.206  42.969  -2.659  1.00 54.19           C  
ATOM    229  OG  SER A  14      16.381  41.560  -2.579  1.00 56.90           O  
ATOM    230  N   ILE A  15      17.084  43.718   0.305  1.00 53.44           N  
ATOM    231  CA  ILE A  15      17.772  43.368   1.536  1.00 53.01           C  
ATOM    232  C   ILE A  15      16.781  43.450   2.671  1.00 53.21           C  
ATOM    233  O   ILE A  15      16.676  42.535   3.478  1.00 53.08           O  
ATOM    234  CB  ILE A  15      18.996  44.297   1.804  1.00 53.13           C  
ATOM    235  CG1 ILE A  15      20.024  44.110   0.703  1.00 53.72           C  
ATOM    236  CG2 ILE A  15      19.661  43.952   3.125  1.00 52.53           C  
ATOM    237  CD1 ILE A  15      21.002  45.214   0.577  1.00 54.09           C  
ATOM    238  N   ILE A  16      16.048  44.555   2.733  1.00 53.36           N  
ATOM    239  CA  ILE A  16      15.042  44.740   3.775  1.00 53.55           C  
ATOM    240  C   ILE A  16      14.035  43.578   3.766  1.00 54.20           C  
ATOM    241  O   ILE A  16      13.665  43.039   4.809  1.00 54.03           O  
ATOM    242  CB  ILE A  16      14.313  46.101   3.584  1.00 53.13           C  
ATOM    243  CG1 ILE A  16      15.277  47.262   3.794  1.00 54.31           C  
ATOM    244  CG2 ILE A  16      13.099  46.257   4.530  1.00 53.65           C  
ATOM    245  CD1 ILE A  16      14.660  48.600   3.502  1.00 53.44           C  
ATOM    246  N   LEU A  17      13.585  43.214   2.578  1.00 55.66           N  
ATOM    247  CA  LEU A  17      12.576  42.175   2.429  1.00 56.62           C  
ATOM    248  C   LEU A  17      13.107  40.788   2.779  1.00 56.84           C  
ATOM    249  O   LEU A  17      12.355  39.941   3.241  1.00 57.59           O  
ATOM    250  CB  LEU A  17      11.984  42.219   1.017  1.00 57.09           C  
ATOM    251  CG  LEU A  17      11.169  43.505   0.698  1.00 59.31           C  
ATOM    252  CD1 LEU A  17      10.710  43.560  -0.793  1.00 60.35           C  
ATOM    253  CD2 LEU A  17       9.952  43.686   1.649  1.00 59.93           C  
ATOM    254  N   GLN A  18      14.396  40.565   2.581  1.00 57.02           N  
ATOM    255  CA  GLN A  18      15.039  39.309   2.959  1.00 57.80           C  
ATOM    256  C   GLN A  18      15.271  39.184   4.457  1.00 56.46           C  
ATOM    257  O   GLN A  18      15.476  38.083   4.951  1.00 55.64           O  
ATOM    258  CB  GLN A  18      16.403  39.163   2.256  1.00 57.77           C  
ATOM    259  CG  GLN A  18      16.301  38.870   0.743  1.00 60.52           C  
ATOM    260  CD  GLN A  18      17.678  38.647   0.093  1.00 62.58           C  
ATOM    261  OE1 GLN A  18      18.210  37.522   0.134  1.00 69.05           O  
ATOM    262  NE2 GLN A  18      18.267  39.716  -0.508  1.00 67.64           N  
ATOM    263  N   ALA A  19      15.305  40.295   5.186  1.00 55.04           N  
ATOM    264  CA  ALA A  19      15.740  40.240   6.575  1.00 54.28           C  
ATOM    265  C   ALA A  19      14.615  39.716   7.470  1.00 53.66           C  
ATOM    266  O   ALA A  19      13.450  39.992   7.223  1.00 54.15           O  
ATOM    267  CB  ALA A  19      16.250  41.635   7.039  1.00 54.05           C  
ATOM    268  N   ASP A  20      14.958  38.962   8.505  1.00 53.07           N  
ATOM    269  CA  ASP A  20      13.949  38.407   9.416  1.00 53.46           C  
ATOM    270  C   ASP A  20      13.646  39.400  10.538  1.00 52.46           C  
ATOM    271  O   ASP A  20      12.542  39.497  11.016  1.00 52.66           O  
ATOM    272  CB  ASP A  20      14.412  37.071  10.039  1.00 54.43           C  
ATOM    273  N   ALA A  21      14.657  40.107  10.961  1.00 51.70           N  
ATOM    274  CA  ALA A  21      14.540  41.113  12.007  1.00 51.69           C  
ATOM    275  C   ALA A  21      15.279  42.341  11.579  1.00 49.88           C  
ATOM    276  O   ALA A  21      16.095  42.322  10.674  1.00 50.16           O  
ATOM    277  CB  ALA A  21      15.144  40.609  13.322  1.00 51.62           C  
ATOM    278  N   CYS A  22      15.017  43.390  12.298  1.00 48.43           N  
ATOM    279  CA  CYS A  22      15.676  44.637  12.088  1.00 48.27           C  
ATOM    280  C   CYS A  22      16.148  45.111  13.449  1.00 48.06           C  
ATOM    281  O   CYS A  22      15.663  44.638  14.495  1.00 47.50           O  
ATOM    282  CB  CYS A  22      14.724  45.623  11.418  1.00 48.59           C  
ATOM    283  SG  CYS A  22      13.476  46.353  12.463  1.00 47.70           S  
ATOM    284  N   PHE A  23      17.127  46.004  13.421  1.00 47.76           N  
ATOM    285  CA  PHE A  23      17.727  46.541  14.623  1.00 47.79           C  
ATOM    286  C   PHE A  23      17.426  48.011  14.695  1.00 47.38           C  
ATOM    287  O   PHE A  23      17.870  48.791  13.874  1.00 47.95           O  
ATOM    288  CB  PHE A  23      19.239  46.189  14.662  1.00 47.59           C  
ATOM    289  CG  PHE A  23      19.454  44.705  14.670  1.00 46.06           C  
ATOM    290  CD1 PHE A  23      19.279  43.978  13.529  1.00 46.10           C  
ATOM    291  CD2 PHE A  23      19.702  44.038  15.840  1.00 44.91           C  
ATOM    292  CE1 PHE A  23      19.425  42.623  13.536  1.00 47.14           C  
ATOM    293  CE2 PHE A  23      19.820  42.674  15.853  1.00 46.58           C  
ATOM    294  CZ  PHE A  23      19.687  41.964  14.708  1.00 45.89           C  
ATOM    295  N   VAL A  24      16.592  48.360  15.667  1.00 47.76           N  
ATOM    296  CA  VAL A  24      16.079  49.693  15.825  1.00 47.16           C  
ATOM    297  C   VAL A  24      16.941  50.430  16.854  1.00 46.81           C  
ATOM    298  O   VAL A  24      17.009  50.035  18.026  1.00 45.96           O  
ATOM    299  CB  VAL A  24      14.590  49.669  16.279  1.00 47.46           C  
ATOM    300  CG1 VAL A  24      14.020  51.072  16.339  1.00 49.30           C  
ATOM    301  CG2 VAL A  24      13.762  48.779  15.362  1.00 48.17           C  
ATOM    302  N   GLY A  25      17.595  51.486  16.382  1.00 45.86           N  
ATOM    303  CA  GLY A  25      18.329  52.409  17.219  1.00 46.22           C  
ATOM    304  C   GLY A  25      17.443  53.552  17.671  1.00 46.46           C  
ATOM    305  O   GLY A  25      16.772  54.201  16.847  1.00 46.16           O  
ATOM    306  N   ILE A  26      17.459  53.789  18.987  1.00 45.99           N  
ATOM    307  CA  ILE A  26      16.717  54.850  19.636  1.00 45.59           C  
ATOM    308  C   ILE A  26      17.728  55.537  20.575  1.00 45.48           C  
ATOM    309  O   ILE A  26      18.566  54.856  21.198  1.00 45.76           O  
ATOM    310  CB  ILE A  26      15.611  54.240  20.492  1.00 45.54           C  
ATOM    311  CG1 ILE A  26      14.814  53.220  19.691  1.00 44.88           C  
ATOM    312  CG2 ILE A  26      14.695  55.277  21.033  1.00 44.41           C  
ATOM    313  CD1 ILE A  26      13.822  52.441  20.523  1.00 46.63           C  
ATOM    314  N   THR A  27      17.662  56.861  20.681  1.00 45.32           N  
ATOM    315  CA  THR A  27      18.459  57.571  21.665  1.00 45.27           C  
ATOM    316  C   THR A  27      17.755  57.453  22.985  1.00 45.38           C  
ATOM    317  O   THR A  27      16.551  57.685  23.066  1.00 46.44           O  
ATOM    318  CB  THR A  27      18.644  59.018  21.298  1.00 45.48           C  
ATOM    319  OG1 THR A  27      19.227  59.072  19.994  1.00 47.14           O  
ATOM    320  CG2 THR A  27      19.584  59.703  22.299  1.00 44.30           C  
ATOM    321  N   ASP A  28      18.478  57.045  24.023  1.00 45.76           N  
ATOM    322  CA  ASP A  28      17.835  56.852  25.325  1.00 45.57           C  
ATOM    323  C   ASP A  28      17.729  58.177  26.041  1.00 45.22           C  
ATOM    324  O   ASP A  28      18.066  59.201  25.460  1.00 44.42           O  
ATOM    325  CB  ASP A  28      18.542  55.761  26.145  1.00 45.52           C  
ATOM    326  CG  ASP A  28      19.885  56.178  26.692  1.00 45.90           C  
ATOM    327  OD1 ASP A  28      20.232  57.368  26.702  1.00 46.05           O  
ATOM    328  OD2 ASP A  28      20.597  55.273  27.153  1.00 43.97           O  
ATOM    329  N   LEU A  29      17.255  58.158  27.285  1.00 45.54           N  
ATOM    330  CA  LEU A  29      16.883  59.396  28.005  1.00 45.80           C  
ATOM    331  C   LEU A  29      18.096  60.191  28.484  1.00 45.68           C  
ATOM    332  O   LEU A  29      17.975  61.362  28.871  1.00 46.01           O  
ATOM    333  CB  LEU A  29      15.984  59.078  29.205  1.00 45.91           C  
ATOM    334  CG  LEU A  29      14.610  58.478  28.887  1.00 47.88           C  
ATOM    335  CD1 LEU A  29      13.806  58.311  30.186  1.00 49.66           C  
ATOM    336  CD2 LEU A  29      13.826  59.372  27.908  1.00 48.05           C  
ATOM    337  N   GLU A  30      19.244  59.536  28.465  1.00 45.39           N  
ATOM    338  CA  GLU A  30      20.520  60.134  28.766  1.00 46.08           C  
ATOM    339  C   GLU A  30      21.308  60.481  27.519  1.00 44.92           C  
ATOM    340  O   GLU A  30      22.413  60.894  27.632  1.00 44.82           O  
ATOM    341  CB  GLU A  30      21.340  59.145  29.584  1.00 46.77           C  
ATOM    342  CG  GLU A  30      20.630  58.648  30.843  1.00 51.17           C  
ATOM    343  CD  GLU A  30      21.613  58.194  31.889  1.00 57.03           C  
ATOM    344  OE1 GLU A  30      22.336  57.224  31.618  1.00 62.03           O  
ATOM    345  OE2 GLU A  30      21.699  58.833  32.960  1.00 63.49           O  
ATOM    346  N   GLY A  31      20.771  60.304  26.323  1.00 44.85           N  
ATOM    347  CA  GLY A  31      21.518  60.667  25.113  1.00 44.96           C  
ATOM    348  C   GLY A  31      22.411  59.580  24.547  1.00 45.12           C  
ATOM    349  O   GLY A  31      23.179  59.814  23.611  1.00 45.67           O  
ATOM    350  N   ASN A  32      22.297  58.371  25.087  1.00 45.39           N  
ATOM    351  CA  ASN A  32      23.112  57.259  24.625  1.00 45.03           C  
ATOM    352  C   ASN A  32      22.315  56.317  23.756  1.00 45.78           C  
ATOM    353  O   ASN A  32      21.083  56.330  23.817  1.00 47.09           O  
ATOM    354  CB  ASN A  32      23.730  56.538  25.813  1.00 44.42           C  
ATOM    355  CG  ASN A  32      24.608  57.440  26.619  1.00 42.90           C  
ATOM    356  OD1 ASN A  32      25.320  58.258  26.063  1.00 41.61           O  
ATOM    357  ND2 ASN A  32      24.554  57.310  27.931  1.00 36.24           N  
ATOM    358  N   PRO A  33      23.006  55.533  22.903  1.00 45.41           N  
ATOM    359  CA  PRO A  33      22.339  54.618  22.006  1.00 45.61           C  
ATOM    360  C   PRO A  33      21.651  53.449  22.717  1.00 45.97           C  
ATOM    361  O   PRO A  33      22.116  52.968  23.760  1.00 44.85           O  
ATOM    362  CB  PRO A  33      23.477  54.080  21.130  1.00 45.86           C  
ATOM    363  CG  PRO A  33      24.581  55.023  21.330  1.00 47.07           C  
ATOM    364  CD  PRO A  33      24.461  55.500  22.724  1.00 44.68           C  
ATOM    365  N   TYR A  34      20.535  53.034  22.130  1.00 46.43           N  
ATOM    366  CA  TYR A  34      19.790  51.861  22.520  1.00 46.91           C  
ATOM    367  C   TYR A  34      19.398  51.153  21.239  1.00 47.25           C  
ATOM    368  O   TYR A  34      18.729  51.746  20.418  1.00 46.57           O  
ATOM    369  CB  TYR A  34      18.535  52.295  23.236  1.00 47.06           C  
ATOM    370  CG  TYR A  34      17.709  51.179  23.842  1.00 48.04           C  
ATOM    371  CD1 TYR A  34      18.229  50.378  24.851  1.00 47.69           C  
ATOM    372  CD2 TYR A  34      16.385  50.968  23.443  1.00 48.45           C  
ATOM    373  CE1 TYR A  34      17.465  49.398  25.433  1.00 47.60           C  
ATOM    374  CE2 TYR A  34      15.626  50.008  24.019  1.00 46.64           C  
ATOM    375  CZ  TYR A  34      16.170  49.226  25.014  1.00 48.17           C  
ATOM    376  OH  TYR A  34      15.429  48.252  25.595  1.00 49.87           O  
ATOM    377  N   VAL A  35      19.835  49.909  21.049  1.00 47.89           N  
ATOM    378  CA  VAL A  35      19.516  49.195  19.828  1.00 47.96           C  
ATOM    379  C   VAL A  35      18.698  47.967  20.166  1.00 49.01           C  
ATOM    380  O   VAL A  35      19.121  47.123  20.904  1.00 50.63           O  
ATOM    381  CB  VAL A  35      20.773  48.778  19.054  1.00 48.15           C  
ATOM    382  CG1 VAL A  35      20.389  48.027  17.808  1.00 47.08           C  
ATOM    383  CG2 VAL A  35      21.598  49.995  18.674  1.00 47.45           C  
ATOM    384  N   VAL A  36      17.532  47.849  19.580  1.00 49.75           N  
ATOM    385  CA  VAL A  36      16.626  46.805  19.979  1.00 50.77           C  
ATOM    386  C   VAL A  36      16.233  46.038  18.707  1.00 49.52           C  
ATOM    387  O   VAL A  36      15.871  46.645  17.692  1.00 49.73           O  
ATOM    388  CB  VAL A  36      15.448  47.487  20.809  1.00 51.58           C  
ATOM    389  CG1 VAL A  36      14.453  48.203  19.900  1.00 51.85           C  
ATOM    390  CG2 VAL A  36      14.744  46.495  21.660  1.00 53.02           C  
ATOM    391  N   PRO A  37      16.356  44.704  18.712  1.00 48.51           N  
ATOM    392  CA  PRO A  37      15.847  44.017  17.529  1.00 48.44           C  
ATOM    393  C   PRO A  37      14.345  43.886  17.552  1.00 48.54           C  
ATOM    394  O   PRO A  37      13.768  43.735  18.616  1.00 46.84           O  
ATOM    395  CB  PRO A  37      16.457  42.621  17.624  1.00 48.36           C  
ATOM    396  CG  PRO A  37      16.723  42.431  19.056  1.00 48.72           C  
ATOM    397  CD  PRO A  37      16.878  43.770  19.710  1.00 48.52           C  
HETATM  398  N   MSE A  38      13.746  43.870  16.371  1.00 49.30           N  
HETATM  399  CA  MSE A  38      12.313  43.830  16.238  1.00 51.75           C  
HETATM  400  C   MSE A  38      11.877  43.238  14.937  1.00 49.89           C  
HETATM  401  O   MSE A  38      12.595  43.284  13.959  1.00 49.38           O  
HETATM  402  CB  MSE A  38      11.754  45.252  16.408  1.00 51.67           C  
HETATM  403  CG  MSE A  38      11.700  45.601  17.896  1.00 53.26           C  
HETATM  404 SE   MSE A  38      11.092  47.195  18.175  0.75 64.93          SE  
HETATM  405  CE  MSE A  38       9.120  46.883  18.113  1.00 62.25           C  
ATOM    406  N   ASN A  39      10.684  42.662  14.918  1.00 49.45           N  
ATOM    407  CA  ASN A  39      10.102  42.226  13.660  1.00 49.05           C  
ATOM    408  C   ASN A  39       9.485  43.420  12.954  1.00 47.79           C  
ATOM    409  O   ASN A  39       9.335  44.461  13.536  1.00 48.02           O  
ATOM    410  CB  ASN A  39       9.094  41.133  13.927  1.00 50.46           C  
ATOM    411  CG  ASN A  39       9.747  39.908  14.510  1.00 50.47           C  
ATOM    412  OD1 ASN A  39       9.293  39.388  15.497  1.00 56.97           O  
ATOM    413  ND2 ASN A  39      10.867  39.498  13.948  1.00 53.09           N  
ATOM    414  N   PHE A  40       9.180  43.283  11.686  1.00 46.44           N  
ATOM    415  CA  PHE A  40       8.783  44.405  10.914  1.00 45.07           C  
ATOM    416  C   PHE A  40       8.110  43.976   9.615  1.00 44.95           C  
ATOM    417  O   PHE A  40       8.198  42.802   9.165  1.00 44.62           O  
ATOM    418  CB  PHE A  40      10.010  45.242  10.569  1.00 46.02           C  
ATOM    419  CG  PHE A  40      10.901  44.592   9.556  1.00 44.56           C  
ATOM    420  CD1 PHE A  40      11.861  43.701   9.952  1.00 48.41           C  
ATOM    421  CD2 PHE A  40      10.723  44.813   8.201  1.00 46.63           C  
ATOM    422  CE1 PHE A  40      12.650  43.065   9.031  1.00 45.77           C  
ATOM    423  CE2 PHE A  40      11.511  44.176   7.256  1.00 45.71           C  
ATOM    424  CZ  PHE A  40      12.458  43.294   7.672  1.00 47.60           C  
ATOM    425  N   GLY A  41       7.461  44.958   9.013  1.00 43.29           N  
ATOM    426  CA  GLY A  41       6.992  44.898   7.685  1.00 43.46           C  
ATOM    427  C   GLY A  41       7.439  46.140   6.969  1.00 44.40           C  
ATOM    428  O   GLY A  41       7.758  47.175   7.574  1.00 43.48           O  
ATOM    429  N   TYR A  42       7.495  46.028   5.655  1.00 45.91           N  
ATOM    430  CA  TYR A  42       7.899  47.134   4.815  1.00 47.01           C  
ATOM    431  C   TYR A  42       7.004  47.166   3.602  1.00 47.96           C  
ATOM    432  O   TYR A  42       6.908  46.169   2.873  1.00 47.27           O  
ATOM    433  CB  TYR A  42       9.356  46.996   4.372  1.00 47.51           C  
ATOM    434  CG  TYR A  42       9.815  48.097   3.441  1.00 47.15           C  
ATOM    435  CD1 TYR A  42      10.159  49.351   3.923  1.00 47.49           C  
ATOM    436  CD2 TYR A  42       9.866  47.885   2.079  1.00 48.06           C  
ATOM    437  CE1 TYR A  42      10.541  50.360   3.056  1.00 49.11           C  
ATOM    438  CE2 TYR A  42      10.252  48.884   1.207  1.00 48.14           C  
ATOM    439  CZ  TYR A  42      10.584  50.119   1.694  1.00 48.32           C  
ATOM    440  OH  TYR A  42      11.012  51.093   0.825  1.00 48.30           O  
ATOM    441  N   GLU A  43       6.330  48.301   3.394  1.00 49.01           N  
ATOM    442  CA  GLU A  43       5.787  48.598   2.083  1.00 50.10           C  
ATOM    443  C   GLU A  43       5.720  50.091   1.803  1.00 50.16           C  
ATOM    444  O   GLU A  43       5.506  50.905   2.705  1.00 49.07           O  
ATOM    445  CB  GLU A  43       4.440  47.908   1.891  1.00 50.68           C  
ATOM    446  CG  GLU A  43       3.242  48.605   2.474  1.00 52.58           C  
ATOM    447  CD  GLU A  43       1.930  47.982   2.000  1.00 52.38           C  
ATOM    448  OE1 GLU A  43       1.878  46.744   1.758  1.00 53.24           O  
ATOM    449  OE2 GLU A  43       0.954  48.744   1.889  1.00 56.13           O  
ATOM    450  N   ASN A  44       5.960  50.440   0.540  1.00 51.19           N  
ATOM    451  CA  ASN A  44       5.792  51.819   0.060  1.00 51.91           C  
ATOM    452  C   ASN A  44       6.501  52.808   0.963  1.00 51.01           C  
ATOM    453  O   ASN A  44       5.867  53.662   1.560  1.00 51.35           O  
ATOM    454  CB  ASN A  44       4.295  52.165  -0.068  1.00 51.13           C  
ATOM    455  CG  ASN A  44       3.598  51.334  -1.158  1.00 54.95           C  
ATOM    456  OD1 ASN A  44       4.197  51.036  -2.202  1.00 57.25           O  
ATOM    457  ND2 ASN A  44       2.328  50.959  -0.925  1.00 55.76           N  
ATOM    458  N   ASP A  45       7.815  52.621   1.087  1.00 51.06           N  
ATOM    459  CA  ASP A  45       8.753  53.514   1.817  1.00 49.61           C  
ATOM    460  C   ASP A  45       8.396  53.733   3.271  1.00 48.95           C  
ATOM    461  O   ASP A  45       8.728  54.772   3.881  1.00 47.10           O  
ATOM    462  CB  ASP A  45       8.852  54.834   1.102  1.00 50.18           C  
ATOM    463  CG  ASP A  45       9.088  54.654  -0.364  1.00 51.31           C  
ATOM    464  OD1 ASP A  45      10.214  54.263  -0.739  1.00 54.40           O  
ATOM    465  OD2 ASP A  45       8.139  54.851  -1.136  1.00 53.19           O  
ATOM    466  N   THR A  46       7.760  52.716   3.839  1.00 48.01           N  
ATOM    467  CA  THR A  46       7.266  52.781   5.193  1.00 47.66           C  
ATOM    468  C   THR A  46       7.516  51.475   5.932  1.00 47.88           C  
ATOM    469  O   THR A  46       7.258  50.373   5.393  1.00 47.73           O  
ATOM    470  CB  THR A  46       5.800  53.094   5.175  1.00 47.84           C  
ATOM    471  OG1 THR A  46       5.571  54.118   4.207  1.00 46.20           O  
ATOM    472  CG2 THR A  46       5.334  53.574   6.524  1.00 47.67           C  
ATOM    473  N   LEU A  47       8.051  51.606   7.145  1.00 46.97           N  
ATOM    474  CA  LEU A  47       8.272  50.470   8.023  1.00 47.24           C  
ATOM    475  C   LEU A  47       7.209  50.461   9.100  1.00 47.20           C  
ATOM    476  O   LEU A  47       6.796  51.527   9.575  1.00 47.08           O  
ATOM    477  CB  LEU A  47       9.655  50.555   8.691  1.00 47.27           C  
ATOM    478  CG  LEU A  47      10.818  50.226   7.766  1.00 46.73           C  
ATOM    479  CD1 LEU A  47      12.120  50.664   8.406  1.00 46.85           C  
ATOM    480  CD2 LEU A  47      10.852  48.777   7.501  1.00 47.42           C  
ATOM    481  N   TYR A  48       6.785  49.254   9.481  1.00 46.62           N  
ATOM    482  CA  TYR A  48       5.780  49.040  10.511  1.00 46.08           C  
ATOM    483  C   TYR A  48       6.334  48.056  11.527  1.00 46.60           C  
ATOM    484  O   TYR A  48       6.893  47.018  11.165  1.00 45.44           O  
ATOM    485  CB  TYR A  48       4.491  48.468   9.905  1.00 46.57           C  
ATOM    486  CG  TYR A  48       3.874  49.363   8.868  1.00 45.27           C  
ATOM    487  CD1 TYR A  48       3.034  50.410   9.225  1.00 45.23           C  
ATOM    488  CD2 TYR A  48       4.189  49.197   7.539  1.00 45.17           C  
ATOM    489  CE1 TYR A  48       2.478  51.264   8.242  1.00 44.19           C  
ATOM    490  CE2 TYR A  48       3.648  50.002   6.574  1.00 45.66           C  
ATOM    491  CZ  TYR A  48       2.803  51.044   6.925  1.00 45.44           C  
ATOM    492  OH  TYR A  48       2.296  51.795   5.901  1.00 46.10           O  
ATOM    493  N   LEU A  49       6.154  48.386  12.789  1.00 46.68           N  
ATOM    494  CA  LEU A  49       6.526  47.551  13.877  1.00 47.03           C  
ATOM    495  C   LEU A  49       5.393  47.541  14.880  1.00 47.99           C  
ATOM    496  O   LEU A  49       4.391  48.241  14.715  1.00 45.87           O  
ATOM    497  CB  LEU A  49       7.803  48.055  14.519  1.00 47.01           C  
ATOM    498  CG  LEU A  49       8.961  48.298  13.542  1.00 47.88           C  
ATOM    499  CD1 LEU A  49       9.035  49.715  13.182  1.00 50.39           C  
ATOM    500  CD2 LEU A  49      10.308  47.865  14.114  1.00 49.56           C  
ATOM    501  N   HIS A  50       5.542  46.712  15.902  1.00 49.54           N  
ATOM    502  CA  HIS A  50       4.559  46.665  16.955  1.00 51.83           C  
ATOM    503  C   HIS A  50       5.225  46.210  18.214  1.00 52.33           C  
ATOM    504  O   HIS A  50       6.272  45.569  18.153  1.00 53.04           O  
ATOM    505  CB  HIS A  50       3.352  45.774  16.606  1.00 53.63           C  
ATOM    506  CG  HIS A  50       3.710  44.367  16.261  1.00 56.18           C  
ATOM    507  ND1 HIS A  50       4.983  43.856  16.415  1.00 62.22           N  
ATOM    508  CD2 HIS A  50       2.953  43.347  15.796  1.00 59.94           C  
ATOM    509  CE1 HIS A  50       4.996  42.590  16.037  1.00 61.62           C  
ATOM    510  NE2 HIS A  50       3.777  42.257  15.655  1.00 59.45           N  
ATOM    511  N   SER A  51       4.645  46.610  19.346  1.00 52.58           N  
ATOM    512  CA  SER A  51       5.168  46.318  20.650  1.00 52.67           C  
ATOM    513  C   SER A  51       4.029  46.412  21.669  1.00 53.84           C  
ATOM    514  O   SER A  51       2.896  46.750  21.319  1.00 53.19           O  
ATOM    515  CB  SER A  51       6.280  47.315  20.995  1.00 53.37           C  
ATOM    516  OG  SER A  51       5.807  48.653  21.065  1.00 52.18           O  
ATOM    517  N   GLY A  52       4.331  46.084  22.919  1.00 54.38           N  
ATOM    518  CA  GLY A  52       3.452  46.358  24.015  1.00 55.18           C  
ATOM    519  C   GLY A  52       3.379  47.855  24.115  1.00 56.54           C  
ATOM    520  O   GLY A  52       4.160  48.552  23.454  1.00 57.56           O  
ATOM    521  N   PRO A  53       2.434  48.365  24.916  1.00 57.43           N  
ATOM    522  CA  PRO A  53       2.258  49.817  24.983  1.00 58.36           C  
ATOM    523  C   PRO A  53       3.261  50.556  25.888  1.00 59.16           C  
ATOM    524  O   PRO A  53       3.268  51.771  25.874  1.00 59.20           O  
ATOM    525  CB  PRO A  53       0.826  49.962  25.510  1.00 57.45           C  
ATOM    526  CG  PRO A  53       0.671  48.770  26.412  1.00 57.81           C  
ATOM    527  CD  PRO A  53       1.462  47.650  25.768  1.00 57.15           C  
ATOM    528  N   GLU A  54       4.063  49.834  26.667  1.00 60.51           N  
ATOM    529  CA  GLU A  54       5.120  50.419  27.498  1.00 61.86           C  
ATOM    530  C   GLU A  54       6.355  49.486  27.462  1.00 62.43           C  
ATOM    531  O   GLU A  54       6.301  48.443  26.820  1.00 63.50           O  
ATOM    532  CB  GLU A  54       4.616  50.588  28.937  1.00 62.59           C  
ATOM    533  CG  GLU A  54       3.077  50.842  29.121  1.00 64.17           C  
ATOM    534  CD  GLU A  54       2.644  52.325  28.935  1.00 68.99           C  
ATOM    535  OE1 GLU A  54       3.543  53.211  28.843  1.00 70.47           O  
ATOM    536  OE2 GLU A  54       1.396  52.599  28.887  1.00 70.00           O  
ATOM    537  N   GLY A  55       7.492  49.821  28.065  1.00 63.10           N  
ATOM    538  CA  GLY A  55       7.850  51.155  28.506  1.00 63.38           C  
ATOM    539  C   GLY A  55       9.207  51.583  27.930  1.00 63.04           C  
ATOM    540  O   GLY A  55       9.308  52.613  27.267  1.00 63.88           O  
ATOM    541  N   GLY A  56      10.258  50.818  28.171  1.00 62.60           N  
ATOM    542  CA  GLY A  56      11.615  51.350  27.975  1.00 62.12           C  
ATOM    543  C   GLY A  56      11.785  52.164  26.713  1.00 61.25           C  
ATOM    544  O   GLY A  56      11.985  53.363  26.769  1.00 61.27           O  
ATOM    545  N   LYS A  57      11.674  51.489  25.575  1.00 60.57           N  
ATOM    546  CA  LYS A  57      11.777  52.109  24.251  1.00 59.93           C  
ATOM    547  C   LYS A  57      10.668  53.118  23.982  1.00 59.23           C  
ATOM    548  O   LYS A  57      10.820  54.002  23.130  1.00 59.96           O  
ATOM    549  CB  LYS A  57      11.770  51.042  23.145  1.00 59.39           C  
ATOM    550  CG  LYS A  57      10.548  50.094  23.138  1.00 59.05           C  
ATOM    551  CD  LYS A  57      10.840  48.882  22.212  1.00 60.16           C  
ATOM    552  CE  LYS A  57       9.680  47.950  22.021  1.00 57.76           C  
ATOM    553  NZ  LYS A  57       9.262  47.365  23.301  1.00 58.29           N  
ATOM    554  N   ILE A  58       9.563  53.004  24.711  1.00 58.18           N  
ATOM    555  CA  ILE A  58       8.426  53.903  24.523  1.00 57.19           C  
ATOM    556  C   ILE A  58       8.705  55.245  25.157  1.00 56.56           C  
ATOM    557  O   ILE A  58       8.516  56.283  24.527  1.00 56.33           O  
ATOM    558  CB  ILE A  58       7.115  53.292  25.102  1.00 57.40           C  
ATOM    559  CG1 ILE A  58       6.864  51.887  24.497  1.00 56.82           C  
ATOM    560  CG2 ILE A  58       5.924  54.257  24.943  1.00 56.79           C  
ATOM    561  CD1 ILE A  58       6.997  51.809  22.966  1.00 58.24           C  
ATOM    562  N   GLU A  59       9.141  55.233  26.413  1.00 55.81           N  
ATOM    563  CA  GLU A  59       9.570  56.473  27.057  1.00 55.02           C  
ATOM    564  C   GLU A  59      10.596  57.223  26.191  1.00 53.46           C  
ATOM    565  O   GLU A  59      10.503  58.436  26.010  1.00 52.41           O  
ATOM    566  CB  GLU A  59      10.111  56.199  28.470  1.00 55.40           C  
ATOM    567  CG  GLU A  59       8.995  56.235  29.554  1.00 58.25           C  
HETATM  568  N   MSE A  60      11.543  56.489  25.608  1.00 52.15           N  
HETATM  569  CA  MSE A  60      12.590  57.121  24.814  1.00 51.43           C  
HETATM  570  C   MSE A  60      11.975  57.765  23.588  1.00 50.56           C  
HETATM  571  O   MSE A  60      12.266  58.905  23.267  1.00 49.79           O  
HETATM  572  CB  MSE A  60      13.664  56.107  24.389  1.00 51.15           C  
HETATM  573  CG  MSE A  60      14.302  55.380  25.524  1.00 50.38           C  
HETATM  574 SE   MSE A  60      15.448  53.983  24.849  0.75 53.39          SE  
HETATM  575  CE  MSE A  60      16.019  53.145  26.671  1.00 55.32           C  
ATOM    576  N   LEU A  61      11.123  57.031  22.885  1.00 50.76           N  
ATOM    577  CA  LEU A  61      10.540  57.567  21.642  1.00 50.77           C  
ATOM    578  C   LEU A  61       9.662  58.778  21.893  1.00 50.51           C  
ATOM    579  O   LEU A  61       9.490  59.611  21.012  1.00 48.92           O  
ATOM    580  CB  LEU A  61       9.733  56.515  20.900  1.00 51.32           C  
ATOM    581  CG  LEU A  61      10.581  55.355  20.387  1.00 50.82           C  
ATOM    582  CD1 LEU A  61       9.702  54.205  20.027  1.00 51.04           C  
ATOM    583  CD2 LEU A  61      11.409  55.813  19.194  1.00 52.28           C  
ATOM    584  N   GLN A  62       9.100  58.855  23.087  1.00 50.38           N  
ATOM    585  CA  GLN A  62       8.264  59.992  23.422  1.00 51.72           C  
ATOM    586  C   GLN A  62       9.106  61.259  23.583  1.00 50.11           C  
ATOM    587  O   GLN A  62       8.629  62.332  23.293  1.00 49.52           O  
ATOM    588  CB  GLN A  62       7.372  59.663  24.625  1.00 51.97           C  
ATOM    589  CG  GLN A  62       6.373  58.531  24.231  1.00 55.06           C  
ATOM    590  CD  GLN A  62       5.421  58.109  25.358  1.00 56.06           C  
ATOM    591  OE1 GLN A  62       5.668  58.415  26.535  1.00 63.01           O  
ATOM    592  NE2 GLN A  62       4.326  57.401  24.996  1.00 58.13           N  
ATOM    593  N   ARG A  63      10.367  61.100  23.985  0.50 49.44           N  
ATOM    595  CA  ARG A  63      11.317  62.206  24.045  0.50 48.42           C  
ATOM    597  C   ARG A  63      11.976  62.506  22.686  0.50 48.58           C  
ATOM    599  O   ARG A  63      12.181  63.665  22.346  0.50 48.03           O  
ATOM    601  CB  ARG A  63      12.380  61.880  25.088  0.50 48.33           C  
ATOM    603  CG  ARG A  63      13.465  62.937  25.288  0.50 45.68           C  
ATOM    605  CD  ARG A  63      14.656  62.331  26.008  0.50 43.32           C  
ATOM    607  NE  ARG A  63      15.890  62.548  25.260  0.50 43.98           N  
ATOM    609  CZ  ARG A  63      16.251  61.887  24.168  0.50 40.49           C  
ATOM    611  NH1 ARG A  63      15.470  60.932  23.650  0.50 47.88           N  
ATOM    613  NH2 ARG A  63      17.380  62.190  23.568  0.50 38.29           N  
ATOM    615  N   ASN A  64      12.331  61.459  21.936  1.00 48.83           N  
ATOM    616  CA  ASN A  64      12.944  61.589  20.597  1.00 48.45           C  
ATOM    617  C   ASN A  64      12.452  60.429  19.758  1.00 47.79           C  
ATOM    618  O   ASN A  64      12.810  59.308  20.029  1.00 48.05           O  
ATOM    619  CB  ASN A  64      14.488  61.537  20.673  1.00 48.90           C  
ATOM    620  CG  ASN A  64      15.178  61.725  19.296  1.00 48.19           C  
ATOM    621  OD1 ASN A  64      14.554  61.675  18.224  1.00 46.60           O  
ATOM    622  ND2 ASN A  64      16.459  61.951  19.338  1.00 44.65           N  
ATOM    623  N   ASN A  65      11.652  60.696  18.737  1.00 47.10           N  
ATOM    624  CA  ASN A  65      11.081  59.627  17.951  1.00 47.77           C  
ATOM    625  C   ASN A  65      11.863  59.334  16.665  1.00 47.89           C  
ATOM    626  O   ASN A  65      11.389  58.578  15.807  1.00 47.19           O  
ATOM    627  CB  ASN A  65       9.587  59.847  17.687  1.00 46.98           C  
ATOM    628  CG  ASN A  65       9.309  60.983  16.709  1.00 47.83           C  
ATOM    629  OD1 ASN A  65      10.110  61.860  16.532  1.00 47.04           O  
ATOM    630  ND2 ASN A  65       8.159  60.940  16.067  1.00 49.65           N  
ATOM    631  N   ASN A  66      13.041  59.939  16.526  1.00 47.43           N  
ATOM    632  CA  ASN A  66      13.934  59.563  15.429  1.00 48.24           C  
ATOM    633  C   ASN A  66      14.578  58.205  15.677  1.00 48.35           C  
ATOM    634  O   ASN A  66      15.175  57.987  16.741  1.00 47.79           O  
ATOM    635  CB  ASN A  66      15.025  60.598  15.257  1.00 48.10           C  
ATOM    636  CG  ASN A  66      14.489  61.884  14.751  1.00 49.51           C  
ATOM    637  OD1 ASN A  66      14.165  61.996  13.577  1.00 54.80           O  
ATOM    638  ND2 ASN A  66      14.330  62.852  15.640  1.00 43.89           N  
ATOM    639  N   VAL A  67      14.450  57.309  14.700  1.00 48.87           N  
ATOM    640  CA  VAL A  67      15.022  55.982  14.798  1.00 48.90           C  
ATOM    641  C   VAL A  67      15.881  55.666  13.583  1.00 49.07           C  
ATOM    642  O   VAL A  67      15.609  56.150  12.487  1.00 49.05           O  
ATOM    643  CB  VAL A  67      13.938  54.915  14.958  1.00 49.43           C  
ATOM    644  CG1 VAL A  67      13.232  55.101  16.291  1.00 50.88           C  
ATOM    645  CG2 VAL A  67      12.915  54.964  13.803  1.00 48.63           C  
ATOM    646  N   CYS A  68      16.914  54.848  13.789  1.00 48.51           N  
ATOM    647  CA  CYS A  68      17.727  54.330  12.698  1.00 48.25           C  
ATOM    648  C   CYS A  68      17.523  52.807  12.681  1.00 48.10           C  
ATOM    649  O   CYS A  68      17.842  52.112  13.633  1.00 48.12           O  
ATOM    650  CB  CYS A  68      19.191  54.734  12.876  1.00 47.97           C  
ATOM    651  SG  CYS A  68      20.246  54.261  11.498  1.00 48.38           S  
ATOM    652  N   ILE A  69      16.911  52.306  11.620  1.00 48.03           N  
ATOM    653  CA  ILE A  69      16.570  50.917  11.553  1.00 48.37           C  
ATOM    654  C   ILE A  69      17.436  50.233  10.506  1.00 47.71           C  
ATOM    655  O   ILE A  69      17.401  50.567   9.333  1.00 47.14           O  
ATOM    656  CB  ILE A  69      15.085  50.732  11.252  1.00 48.91           C  
ATOM    657  CG1 ILE A  69      14.245  51.508  12.270  1.00 48.78           C  
ATOM    658  CG2 ILE A  69      14.757  49.235  11.252  1.00 51.17           C  
ATOM    659  CD1 ILE A  69      12.744  51.415  12.099  1.00 48.17           C  
ATOM    660  N   THR A  70      18.202  49.252  10.963  1.00 48.17           N  
ATOM    661  CA  THR A  70      19.255  48.622  10.170  1.00 46.81           C  
ATOM    662  C   THR A  70      19.015  47.147   9.964  1.00 47.28           C  
ATOM    663  O   THR A  70      18.461  46.462  10.824  1.00 47.62           O  
ATOM    664  CB  THR A  70      20.594  48.857  10.854  1.00 46.68           C  
ATOM    665  OG1 THR A  70      20.832  50.268  10.906  1.00 43.60           O  
ATOM    666  CG2 THR A  70      21.719  48.236  10.107  1.00 45.70           C  
ATOM    667  N   PHE A  71      19.413  46.666   8.795  1.00 47.43           N  
ATOM    668  CA  PHE A  71      19.111  45.290   8.352  1.00 48.29           C  
ATOM    669  C   PHE A  71      20.380  44.701   7.766  1.00 49.12           C  
ATOM    670  O   PHE A  71      21.127  45.419   7.113  1.00 48.30           O  
ATOM    671  CB  PHE A  71      18.050  45.252   7.242  1.00 47.71           C  
ATOM    672  CG  PHE A  71      16.819  46.062   7.523  1.00 47.67           C  
ATOM    673  CD1 PHE A  71      16.829  47.435   7.370  1.00 48.16           C  
ATOM    674  CD2 PHE A  71      15.637  45.447   7.884  1.00 47.81           C  
ATOM    675  CE1 PHE A  71      15.690  48.168   7.585  1.00 47.25           C  
ATOM    676  CE2 PHE A  71      14.522  46.175   8.127  1.00 47.08           C  
ATOM    677  CZ  PHE A  71      14.542  47.536   7.989  1.00 47.45           C  
ATOM    678  N   SER A  72      20.633  43.421   7.983  1.00 50.51           N  
ATOM    679  CA  SER A  72      21.737  42.804   7.292  1.00 53.51           C  
ATOM    680  C   SER A  72      21.563  41.341   7.114  1.00 55.44           C  
ATOM    681  O   SER A  72      21.048  40.675   7.988  1.00 56.43           O  
ATOM    682  CB  SER A  72      23.050  43.050   8.041  1.00 53.92           C  
ATOM    683  OG  SER A  72      24.102  42.431   7.350  1.00 55.75           O  
ATOM    684  N   LEU A  73      22.055  40.827   5.994  1.00 57.65           N  
ATOM    685  CA  LEU A  73      22.023  39.390   5.739  1.00 59.43           C  
ATOM    686  C   LEU A  73      23.395  38.846   6.064  1.00 59.76           C  
ATOM    687  O   LEU A  73      24.412  39.595   6.088  1.00 60.55           O  
ATOM    688  CB  LEU A  73      21.714  39.107   4.275  1.00 60.25           C  
ATOM    689  CG  LEU A  73      20.776  40.133   3.622  1.00 63.82           C  
ATOM    690  CD1 LEU A  73      20.753  39.950   2.085  1.00 63.69           C  
ATOM    691  CD2 LEU A  73      19.371  40.037   4.296  1.00 65.00           C  
ATOM    692  N   GLY A  74      23.466  37.544   6.271  1.00 59.17           N  
ATOM    693  CA  GLY A  74      24.765  36.945   6.632  1.00 59.27           C  
ATOM    694  C   GLY A  74      25.897  37.280   5.658  1.00 58.80           C  
ATOM    695  O   GLY A  74      25.668  37.765   4.550  1.00 59.78           O  
ATOM    696  N   HIS A  75      27.132  36.998   6.060  1.00 57.33           N  
ATOM    697  CA  HIS A  75      28.246  37.209   5.175  1.00 56.00           C  
ATOM    698  C   HIS A  75      28.398  36.034   4.255  1.00 53.96           C  
ATOM    699  O   HIS A  75      28.031  34.949   4.595  1.00 53.02           O  
ATOM    700  CB  HIS A  75      29.526  37.462   5.943  1.00 56.39           C  
ATOM    701  CG  HIS A  75      30.013  36.284   6.711  1.00 60.24           C  
ATOM    702  ND1 HIS A  75      29.718  36.096   8.045  1.00 64.76           N  
ATOM    703  CD2 HIS A  75      30.818  35.252   6.349  1.00 62.27           C  
ATOM    704  CE1 HIS A  75      30.305  34.982   8.463  1.00 65.05           C  
ATOM    705  NE2 HIS A  75      30.984  34.457   7.458  1.00 64.18           N  
ATOM    706  N   LYS A  76      28.910  36.275   3.068  1.00 52.42           N  
ATOM    707  CA  LYS A  76      29.390  35.187   2.263  1.00 52.77           C  
ATOM    708  C   LYS A  76      30.905  35.229   2.152  1.00 50.97           C  
ATOM    709  O   LYS A  76      31.552  36.262   2.239  1.00 50.38           O  
ATOM    710  CB  LYS A  76      28.693  35.141   0.891  1.00 52.92           C  
ATOM    711  CG  LYS A  76      29.035  36.276  -0.050  1.00 53.82           C  
ATOM    712  CD  LYS A  76      28.289  36.122  -1.403  1.00 55.16           C  
ATOM    713  N   LEU A  77      31.452  34.059   1.958  1.00 49.28           N  
ATOM    714  CA  LEU A  77      32.839  33.880   1.806  1.00 48.34           C  
ATOM    715  C   LEU A  77      33.150  33.583   0.326  1.00 46.44           C  
ATOM    716  O   LEU A  77      32.553  32.702  -0.272  1.00 44.38           O  
ATOM    717  CB  LEU A  77      33.163  32.733   2.711  1.00 49.22           C  
ATOM    718  CG  LEU A  77      34.590  32.431   3.082  1.00 54.33           C  
ATOM    719  CD1 LEU A  77      35.201  33.577   3.851  1.00 57.12           C  
ATOM    720  CD2 LEU A  77      34.505  31.152   3.955  1.00 57.79           C  
ATOM    721  N   VAL A  78      34.019  34.380  -0.269  1.00 44.80           N  
ATOM    722  CA  VAL A  78      34.377  34.259  -1.647  1.00 45.27           C  
ATOM    723  C   VAL A  78      35.898  34.141  -1.752  1.00 45.43           C  
ATOM    724  O   VAL A  78      36.601  34.995  -1.239  1.00 44.02           O  
ATOM    725  CB  VAL A  78      33.932  35.515  -2.459  1.00 45.83           C  
ATOM    726  CG1 VAL A  78      34.300  35.352  -3.922  1.00 45.81           C  
ATOM    727  CG2 VAL A  78      32.471  35.745  -2.343  1.00 45.36           C  
ATOM    728  N   TYR A  79      36.383  33.067  -2.377  1.00 46.07           N  
ATOM    729  CA  TYR A  79      37.785  32.920  -2.697  1.00 48.05           C  
ATOM    730  C   TYR A  79      38.030  33.280  -4.169  1.00 49.94           C  
ATOM    731  O   TYR A  79      37.402  32.726  -5.056  1.00 50.08           O  
ATOM    732  CB  TYR A  79      38.275  31.490  -2.417  1.00 48.03           C  
ATOM    733  CG  TYR A  79      38.049  31.027  -0.998  1.00 47.81           C  
ATOM    734  CD1 TYR A  79      38.946  31.336   0.015  1.00 50.47           C  
ATOM    735  CD2 TYR A  79      36.943  30.292  -0.668  1.00 47.79           C  
ATOM    736  CE1 TYR A  79      38.718  30.920   1.322  1.00 50.04           C  
ATOM    737  CE2 TYR A  79      36.696  29.888   0.610  1.00 48.98           C  
ATOM    738  CZ  TYR A  79      37.582  30.191   1.614  1.00 50.60           C  
ATOM    739  OH  TYR A  79      37.306  29.769   2.912  1.00 50.41           O  
ATOM    740  N   GLN A  80      38.937  34.217  -4.415  1.00 52.84           N  
ATOM    741  CA  GLN A  80      39.259  34.701  -5.771  1.00 54.63           C  
ATOM    742  C   GLN A  80      40.532  33.993  -6.176  1.00 56.66           C  
ATOM    743  O   GLN A  80      41.466  33.814  -5.367  1.00 55.94           O  
ATOM    744  CB  GLN A  80      39.442  36.224  -5.796  1.00 55.33           C  
ATOM    745  CG  GLN A  80      38.487  37.019  -6.770  1.00 56.13           C  
ATOM    746  N   HIS A  81      40.562  33.519  -7.421  1.00 59.34           N  
ATOM    747  CA  HIS A  81      41.669  32.652  -7.851  1.00 61.00           C  
ATOM    748  C   HIS A  81      42.371  33.138  -9.112  1.00 61.40           C  
ATOM    749  O   HIS A  81      43.600  33.006  -9.199  1.00 62.91           O  
ATOM    750  CB  HIS A  81      41.186  31.216  -8.021  1.00 61.25           C  
ATOM    751  CG  HIS A  81      40.536  30.649  -6.795  1.00 63.00           C  
ATOM    752  ND1 HIS A  81      41.259  30.176  -5.717  1.00 65.17           N  
ATOM    753  CD2 HIS A  81      39.230  30.463  -6.481  1.00 62.10           C  
ATOM    754  CE1 HIS A  81      40.426  29.722  -4.796  1.00 61.75           C  
ATOM    755  NE2 HIS A  81      39.191  29.870  -5.240  1.00 59.74           N  
ATOM    756  N   CYS A  86      46.177  33.601  -4.435  1.00 62.09           N  
ATOM    757  CA  CYS A  86      44.780  33.484  -3.977  1.00 62.13           C  
ATOM    758  C   CYS A  86      44.401  34.562  -2.929  1.00 61.45           C  
ATOM    759  O   CYS A  86      45.238  35.303  -2.399  1.00 61.43           O  
ATOM    760  CB  CYS A  86      44.468  32.052  -3.473  1.00 62.44           C  
ATOM    761  N   SER A  87      43.117  34.653  -2.657  1.00 60.39           N  
ATOM    762  CA  SER A  87      42.551  35.840  -2.034  1.00 59.39           C  
ATOM    763  C   SER A  87      41.273  35.436  -1.335  1.00 58.48           C  
ATOM    764  O   SER A  87      40.517  34.628  -1.833  1.00 57.48           O  
ATOM    765  CB  SER A  87      42.258  36.887  -3.102  1.00 59.34           C  
ATOM    766  OG  SER A  87      42.082  38.143  -2.528  1.00 59.36           O  
ATOM    767  N   TYR A  88      41.059  35.987  -0.160  1.00 58.06           N  
ATOM    768  CA  TYR A  88      39.921  35.639   0.679  1.00 58.19           C  
ATOM    769  C   TYR A  88      39.149  36.960   0.846  1.00 56.64           C  
ATOM    770  O   TYR A  88      39.725  38.013   1.021  1.00 54.94           O  
ATOM    771  CB  TYR A  88      40.464  34.989   1.981  1.00 59.77           C  
ATOM    772  CG  TYR A  88      39.657  35.044   3.267  1.00 61.01           C  
ATOM    773  CD1 TYR A  88      39.133  36.226   3.745  1.00 62.97           C  
ATOM    774  CD2 TYR A  88      39.539  33.926   4.065  1.00 62.98           C  
ATOM    775  CE1 TYR A  88      38.417  36.278   4.930  1.00 64.42           C  
ATOM    776  CE2 TYR A  88      38.837  33.956   5.256  1.00 63.19           C  
ATOM    777  CZ  TYR A  88      38.266  35.138   5.694  1.00 64.72           C  
ATOM    778  OH  TYR A  88      37.544  35.221   6.900  1.00 64.75           O  
ATOM    779  N   SER A  89      37.842  36.879   0.752  1.00 55.77           N  
ATOM    780  CA  SER A  89      36.972  38.017   0.847  1.00 55.96           C  
ATOM    781  C   SER A  89      35.732  37.556   1.586  1.00 56.28           C  
ATOM    782  O   SER A  89      35.126  36.543   1.217  1.00 55.41           O  
ATOM    783  CB  SER A  89      36.586  38.460  -0.550  1.00 56.04           C  
ATOM    784  OG  SER A  89      35.687  39.544  -0.507  1.00 59.28           O  
HETATM  785  N   MSE A  90      35.369  38.274   2.634  1.00 56.33           N  
HETATM  786  CA  MSE A  90      34.160  38.007   3.374  1.00 58.77           C  
HETATM  787  C   MSE A  90      33.251  39.213   3.175  1.00 56.02           C  
HETATM  788  O   MSE A  90      33.618  40.325   3.524  1.00 55.06           O  
HETATM  789  CB  MSE A  90      34.515  37.783   4.833  1.00 58.60           C  
HETATM  790  CG  MSE A  90      33.330  37.572   5.744  1.00 63.26           C  
HETATM  791 SE   MSE A  90      33.846  37.026   7.602  0.75 71.26          SE  
HETATM  792  CE  MSE A  90      35.692  37.862   7.740  1.00 72.57           C  
ATOM    793  N   ARG A  91      32.076  38.986   2.594  1.00 54.96           N  
ATOM    794  CA  ARG A  91      31.253  40.044   1.991  1.00 54.63           C  
ATOM    795  C   ARG A  91      29.848  39.990   2.548  1.00 53.51           C  
ATOM    796  O   ARG A  91      29.253  38.925   2.637  1.00 51.87           O  
ATOM    797  CB  ARG A  91      31.161  39.851   0.469  1.00 55.09           C  
ATOM    798  CG  ARG A  91      32.379  40.356  -0.348  1.00 57.94           C  
ATOM    799  CD  ARG A  91      32.658  39.497  -1.646  1.00 57.34           C  
ATOM    800  N   SER A  92      29.299  41.135   2.925  1.00 52.36           N  
ATOM    801  CA  SER A  92      27.899  41.175   3.286  1.00 52.52           C  
ATOM    802  C   SER A  92      27.247  42.461   2.856  1.00 52.38           C  
ATOM    803  O   SER A  92      27.910  43.393   2.384  1.00 52.97           O  
ATOM    804  CB  SER A  92      27.743  40.971   4.777  1.00 52.67           C  
ATOM    805  OG  SER A  92      28.691  41.745   5.430  1.00 56.78           O  
ATOM    806  N   GLU A  93      25.937  42.525   2.990  1.00 51.83           N  
ATOM    807  CA  GLU A  93      25.255  43.747   2.643  1.00 51.56           C  
ATOM    808  C   GLU A  93      24.234  44.113   3.678  1.00 49.49           C  
ATOM    809  O   GLU A  93      23.735  43.235   4.380  1.00 48.83           O  
ATOM    810  CB  GLU A  93      24.629  43.648   1.250  1.00 51.55           C  
ATOM    811  CG  GLU A  93      23.994  42.359   0.888  1.00 53.63           C  
ATOM    812  CD  GLU A  93      23.656  42.286  -0.625  1.00 56.42           C  
ATOM    813  OE1 GLU A  93      24.413  42.863  -1.448  1.00 58.93           O  
ATOM    814  OE2 GLU A  93      22.641  41.618  -0.984  1.00 63.36           O  
ATOM    815  N   SER A  94      23.950  45.406   3.767  1.00 46.68           N  
ATOM    816  CA  SER A  94      23.037  45.931   4.746  1.00 46.36           C  
ATOM    817  C   SER A  94      22.235  47.067   4.208  1.00 45.75           C  
ATOM    818  O   SER A  94      22.631  47.720   3.265  1.00 44.67           O  
ATOM    819  CB  SER A  94      23.776  46.458   5.973  1.00 46.71           C  
ATOM    820  OG  SER A  94      24.789  47.378   5.623  1.00 44.69           O  
ATOM    821  N   ALA A  95      21.104  47.307   4.852  1.00 45.76           N  
ATOM    822  CA  ALA A  95      20.282  48.465   4.571  1.00 45.63           C  
ATOM    823  C   ALA A  95      20.120  49.230   5.866  1.00 45.94           C  
ATOM    824  O   ALA A  95      20.247  48.662   6.937  1.00 44.99           O  
ATOM    825  CB  ALA A  95      18.971  48.063   4.052  1.00 45.39           C  
HETATM  826  N   MSE A  96      19.866  50.524   5.725  1.00 47.02           N  
HETATM  827  CA  MSE A  96      19.641  51.415   6.830  1.00 48.60           C  
HETATM  828  C   MSE A  96      18.553  52.364   6.464  1.00 47.52           C  
HETATM  829  O   MSE A  96      18.624  52.989   5.437  1.00 47.56           O  
HETATM  830  CB  MSE A  96      20.900  52.200   7.122  1.00 48.25           C  
HETATM  831  CG  MSE A  96      20.802  53.031   8.374  1.00 49.74           C  
HETATM  832 SE   MSE A  96      22.325  54.187   8.595  0.75 56.29          SE  
HETATM  833  CE  MSE A  96      23.671  52.765   8.959  1.00 55.27           C  
ATOM    834  N   CYS A  97      17.551  52.465   7.325  1.00 47.68           N  
ATOM    835  CA  CYS A  97      16.439  53.389   7.165  1.00 47.22           C  
ATOM    836  C   CYS A  97      16.364  54.360   8.332  1.00 47.45           C  
ATOM    837  O   CYS A  97      16.333  53.952   9.473  1.00 47.02           O  
ATOM    838  CB  CYS A  97      15.111  52.644   7.143  1.00 46.19           C  
ATOM    839  SG  CYS A  97      14.886  51.507   5.756  1.00 48.30           S  
ATOM    840  N   ARG A  98      16.249  55.641   8.022  1.00 47.99           N  
ATOM    841  CA  ARG A  98      16.075  56.685   9.044  1.00 48.82           C  
ATOM    842  C   ARG A  98      14.695  57.292   8.859  1.00 47.55           C  
ATOM    843  O   ARG A  98      14.284  57.587   7.741  1.00 47.09           O  
ATOM    844  CB  ARG A  98      17.123  57.762   8.893  1.00 48.65           C  
ATOM    845  CG  ARG A  98      18.562  57.356   9.358  1.00 52.61           C  
ATOM    846  CD  ARG A  98      19.300  58.641   9.643  1.00 56.32           C  
ATOM    847  NE  ARG A  98      20.764  58.624   9.841  1.00 58.87           N  
ATOM    848  CZ  ARG A  98      21.643  58.321   8.891  1.00 59.58           C  
ATOM    849  NH1 ARG A  98      21.240  57.923   7.682  1.00 61.29           N  
ATOM    850  NH2 ARG A  98      22.937  58.373   9.164  1.00 60.63           N  
ATOM    851  N   GLY A  99      13.987  57.491   9.959  1.00 47.19           N  
ATOM    852  CA  GLY A  99      12.657  58.096   9.897  1.00 46.82           C  
ATOM    853  C   GLY A  99      12.194  58.355  11.293  1.00 47.13           C  
ATOM    854  O   GLY A  99      12.947  58.168  12.242  1.00 47.18           O  
ATOM    855  N   LYS A 100      10.963  58.839  11.420  1.00 48.10           N  
ATOM    856  CA  LYS A 100      10.390  59.144  12.709  1.00 47.63           C  
ATOM    857  C   LYS A 100       9.249  58.203  13.004  1.00 46.88           C  
ATOM    858  O   LYS A 100       8.460  57.918  12.129  1.00 46.28           O  
ATOM    859  CB  LYS A 100       9.865  60.551  12.694  1.00 48.16           C  
ATOM    860  CG  LYS A 100      10.902  61.599  12.704  1.00 50.16           C  
ATOM    861  CD  LYS A 100      10.215  62.939  12.596  1.00 52.74           C  
ATOM    862  CE  LYS A 100      11.080  64.104  13.135  1.00 55.95           C  
ATOM    863  NZ  LYS A 100      12.015  64.547  12.077  1.00 58.27           N  
ATOM    864  N   VAL A 101       9.143  57.776  14.251  1.00 47.04           N  
ATOM    865  CA  VAL A 101       8.060  56.925  14.717  1.00 47.82           C  
ATOM    866  C   VAL A 101       6.738  57.596  15.144  1.00 47.90           C  
ATOM    867  O   VAL A 101       6.724  58.437  16.031  1.00 49.52           O  
ATOM    868  CB  VAL A 101       8.543  56.130  15.942  1.00 48.32           C  
ATOM    869  CG1 VAL A 101       7.389  55.300  16.546  1.00 50.35           C  
ATOM    870  CG2 VAL A 101       9.675  55.228  15.562  1.00 49.64           C  
ATOM    871  N   GLU A 102       5.646  57.213  14.482  0.50 48.08           N  
ATOM    873  CA  GLU A 102       4.284  57.470  14.952  0.50 47.78           C  
ATOM    875  C   GLU A 102       3.735  56.210  15.585  0.50 48.10           C  
ATOM    877  O   GLU A 102       4.077  55.114  15.164  0.50 48.13           O  
ATOM    879  CB  GLU A 102       3.353  57.850  13.786  0.50 47.75           C  
ATOM    881  CG  GLU A 102       1.849  57.690  14.096  0.50 46.97           C  
ATOM    883  CD  GLU A 102       0.932  58.086  12.943  0.50 47.16           C  
ATOM    885  OE1 GLU A 102       1.280  57.810  11.767  0.50 41.75           O  
ATOM    887  OE2 GLU A 102      -0.160  58.650  13.230  0.50 47.69           O  
ATOM    889  N   PHE A 103       2.877  56.371  16.584  1.00 48.34           N  
ATOM    890  CA  PHE A 103       2.051  55.281  17.071  1.00 48.50           C  
ATOM    891  C   PHE A 103       0.667  55.450  16.525  1.00 48.78           C  
ATOM    892  O   PHE A 103      -0.023  56.417  16.853  1.00 49.33           O  
ATOM    893  CB  PHE A 103       1.988  55.254  18.585  1.00 48.99           C  
ATOM    894  CG  PHE A 103       3.333  55.020  19.244  1.00 50.23           C  
ATOM    895  CD1 PHE A 103       4.134  53.955  18.864  1.00 51.36           C  
ATOM    896  CD2 PHE A 103       3.766  55.834  20.259  1.00 50.76           C  
ATOM    897  CE1 PHE A 103       5.340  53.740  19.468  1.00 49.98           C  
ATOM    898  CE2 PHE A 103       4.989  55.618  20.873  1.00 50.24           C  
ATOM    899  CZ  PHE A 103       5.768  54.589  20.474  1.00 50.48           C  
ATOM    900  N   ILE A 104       0.248  54.486  15.716  1.00 48.98           N  
ATOM    901  CA  ILE A 104      -1.034  54.543  15.029  1.00 49.42           C  
ATOM    902  C   ILE A 104      -2.118  54.344  16.069  1.00 49.33           C  
ATOM    903  O   ILE A 104      -2.046  53.413  16.864  1.00 49.05           O  
ATOM    904  CB  ILE A 104      -1.118  53.436  13.993  1.00 49.53           C  
ATOM    905  CG1 ILE A 104      -0.058  53.641  12.901  1.00 51.00           C  
ATOM    906  CG2 ILE A 104      -2.468  53.368  13.362  1.00 49.46           C  
ATOM    907  CD1 ILE A 104       0.146  52.384  12.056  1.00 52.75           C  
ATOM    908  N   GLU A 105      -3.109  55.229  16.077  1.00 49.71           N  
ATOM    909  CA  GLU A 105      -4.167  55.143  17.060  1.00 50.04           C  
ATOM    910  C   GLU A 105      -5.414  54.530  16.483  1.00 49.90           C  
ATOM    911  O   GLU A 105      -6.074  53.776  17.179  1.00 49.55           O  
ATOM    912  CB  GLU A 105      -4.467  56.508  17.661  1.00 50.80           C  
ATOM    913  CG  GLU A 105      -3.330  57.070  18.608  1.00 51.77           C  
ATOM    914  N   ASP A 106      -5.749  54.809  15.225  1.00 50.31           N  
ATOM    915  CA  ASP A 106      -7.016  54.294  14.695  1.00 51.27           C  
ATOM    916  C   ASP A 106      -6.949  52.777  14.679  1.00 52.48           C  
ATOM    917  O   ASP A 106      -5.965  52.178  14.244  1.00 51.90           O  
ATOM    918  CB  ASP A 106      -7.352  54.842  13.304  1.00 51.30           C  
ATOM    919  CG  ASP A 106      -8.628  54.215  12.711  1.00 52.30           C  
ATOM    920  OD1 ASP A 106      -9.746  54.497  13.191  1.00 50.95           O  
ATOM    921  OD2 ASP A 106      -8.515  53.412  11.762  1.00 55.91           O  
HETATM  922  N   MSE A 107      -8.008  52.167  15.170  1.00 54.48           N  
HETATM  923  CA  MSE A 107      -8.072  50.739  15.313  1.00 57.50           C  
HETATM  924  C   MSE A 107      -7.920  50.027  13.976  1.00 54.49           C  
HETATM  925  O   MSE A 107      -7.180  49.069  13.884  1.00 52.93           O  
HETATM  926  CB  MSE A 107      -9.386  50.358  15.964  1.00 57.76           C  
HETATM  927  CG  MSE A 107      -9.423  48.914  16.477  1.00 62.95           C  
HETATM  928 SE   MSE A 107      -9.567  48.851  18.434  0.75 70.68          SE  
HETATM  929  CE  MSE A 107     -11.447  49.194  18.632  1.00 68.73           C  
ATOM    930  N   GLU A 108      -8.625  50.494  12.946  1.00 53.43           N  
ATOM    931  CA  GLU A 108      -8.560  49.856  11.610  1.00 52.22           C  
ATOM    932  C   GLU A 108      -7.196  50.070  10.931  1.00 51.32           C  
ATOM    933  O   GLU A 108      -6.692  49.183  10.228  1.00 50.70           O  
ATOM    934  CB  GLU A 108      -9.680  50.347  10.703  1.00 52.10           C  
ATOM    935  CG  GLU A 108     -11.060  49.741  10.979  1.00 51.59           C  
ATOM    936  CD  GLU A 108     -11.031  48.230  11.009  1.00 50.72           C  
ATOM    937  OE1 GLU A 108     -10.455  47.601  10.102  1.00 49.73           O  
ATOM    938  OE2 GLU A 108     -11.572  47.666  11.961  1.00 51.14           O  
ATOM    939  N   GLU A 109      -6.594  51.230  11.143  1.00 50.69           N  
ATOM    940  CA  GLU A 109      -5.249  51.478  10.608  1.00 50.72           C  
ATOM    941  C   GLU A 109      -4.238  50.561  11.248  1.00 49.28           C  
ATOM    942  O   GLU A 109      -3.269  50.148  10.609  1.00 50.20           O  
ATOM    943  CB  GLU A 109      -4.809  52.902  10.856  1.00 50.54           C  
ATOM    944  CG  GLU A 109      -5.577  53.917  10.053  1.00 52.69           C  
ATOM    945  CD  GLU A 109      -5.097  55.345  10.326  1.00 53.42           C  
ATOM    946  OE1 GLU A 109      -4.029  55.507  10.983  1.00 57.17           O  
ATOM    947  OE2 GLU A 109      -5.788  56.303   9.881  1.00 57.69           O  
ATOM    948  N   LYS A 110      -4.436  50.301  12.536  1.00 47.61           N  
ATOM    949  CA  LYS A 110      -3.579  49.407  13.291  1.00 45.55           C  
ATOM    950  C   LYS A 110      -3.642  47.992  12.727  1.00 45.45           C  
ATOM    951  O   LYS A 110      -2.616  47.356  12.595  1.00 43.98           O  
ATOM    952  CB  LYS A 110      -3.982  49.392  14.756  1.00 45.02           C  
ATOM    953  CG  LYS A 110      -3.333  50.425  15.607  1.00 42.56           C  
ATOM    954  CD  LYS A 110      -3.976  50.483  16.976  1.00 43.02           C  
ATOM    955  CE  LYS A 110      -2.984  50.258  18.115  1.00 42.76           C  
ATOM    956  NZ  LYS A 110      -3.636  50.257  19.444  1.00 41.17           N  
ATOM    957  N   ARG A 111      -4.842  47.509  12.393  1.00 45.77           N  
ATOM    958  CA  ARG A 111      -5.009  46.184  11.781  1.00 46.84           C  
ATOM    959  C   ARG A 111      -4.342  46.069  10.424  1.00 49.02           C  
ATOM    960  O   ARG A 111      -3.736  45.028  10.089  1.00 50.90           O  
ATOM    961  CB  ARG A 111      -6.480  45.853  11.555  1.00 45.83           C  
ATOM    962  CG  ARG A 111      -7.282  45.678  12.806  1.00 44.73           C  
ATOM    963  CD  ARG A 111      -8.552  44.915  12.503  1.00 44.54           C  
ATOM    964  NE  ARG A 111      -9.088  44.292  13.691  1.00 42.31           N  
ATOM    965  CZ  ARG A 111      -9.784  44.946  14.593  1.00 43.95           C  
ATOM    966  NH1 ARG A 111     -10.044  46.237  14.436  1.00 44.76           N  
ATOM    967  NH2 ARG A 111     -10.245  44.308  15.647  1.00 44.92           N  
ATOM    968  N   HIS A 112      -4.499  47.112   9.620  1.00 51.00           N  
ATOM    969  CA  HIS A 112      -3.884  47.176   8.302  1.00 52.07           C  
ATOM    970  C   HIS A 112      -2.376  47.018   8.420  1.00 51.19           C  
ATOM    971  O   HIS A 112      -1.773  46.161   7.758  1.00 50.87           O  
ATOM    972  CB  HIS A 112      -4.223  48.510   7.623  1.00 53.44           C  
ATOM    973  CG  HIS A 112      -3.551  48.683   6.298  1.00 58.23           C  
ATOM    974  ND1 HIS A 112      -3.775  47.828   5.237  1.00 61.86           N  
ATOM    975  CD2 HIS A 112      -2.617  49.575   5.879  1.00 62.98           C  
ATOM    976  CE1 HIS A 112      -3.024  48.200   4.213  1.00 63.27           C  
ATOM    977  NE2 HIS A 112      -2.322  49.263   4.571  1.00 64.14           N  
ATOM    978  N   ALA A 113      -1.786  47.834   9.295  1.00 50.28           N  
ATOM    979  CA  ALA A 113      -0.368  47.797   9.560  1.00 49.63           C  
ATOM    980  C   ALA A 113       0.084  46.467  10.133  1.00 49.19           C  
ATOM    981  O   ALA A 113       1.148  45.951   9.754  1.00 48.50           O  
ATOM    982  CB  ALA A 113      -0.001  48.903  10.498  1.00 50.32           C  
ATOM    983  N   LEU A 114      -0.696  45.919  11.060  1.00 48.76           N  
ATOM    984  CA  LEU A 114      -0.365  44.619  11.624  1.00 48.87           C  
ATOM    985  C   LEU A 114      -0.326  43.567  10.533  1.00 49.21           C  
ATOM    986  O   LEU A 114       0.492  42.681  10.575  1.00 49.33           O  
ATOM    987  CB  LEU A 114      -1.335  44.203  12.718  1.00 48.69           C  
ATOM    988  CG  LEU A 114      -1.171  44.900  14.052  1.00 47.54           C  
ATOM    989  CD1 LEU A 114      -2.440  44.890  14.852  1.00 46.32           C  
ATOM    990  CD2 LEU A 114      -0.081  44.273  14.823  1.00 48.54           C  
ATOM    991  N   ASP A 115      -1.168  43.718   9.529  1.00 50.33           N  
ATOM    992  CA  ASP A 115      -1.184  42.793   8.386  1.00 51.28           C  
ATOM    993  C   ASP A 115       0.092  42.878   7.561  1.00 50.64           C  
ATOM    994  O   ASP A 115       0.590  41.859   7.095  1.00 49.87           O  
ATOM    995  CB  ASP A 115      -2.374  43.062   7.476  1.00 51.57           C  
ATOM    996  CG  ASP A 115      -3.649  42.422   7.976  1.00 55.66           C  
ATOM    997  OD1 ASP A 115      -3.610  41.670   8.986  1.00 61.80           O  
ATOM    998  OD2 ASP A 115      -4.706  42.660   7.344  1.00 59.20           O  
ATOM    999  N   ILE A 116       0.589  44.094   7.366  1.00 50.05           N  
ATOM   1000  CA  ILE A 116       1.841  44.293   6.639  1.00 50.00           C  
ATOM   1001  C   ILE A 116       2.971  43.606   7.397  1.00 49.17           C  
ATOM   1002  O   ILE A 116       3.849  42.970   6.804  1.00 49.57           O  
ATOM   1003  CB  ILE A 116       2.122  45.792   6.401  1.00 50.22           C  
ATOM   1004  CG1 ILE A 116       1.026  46.365   5.519  1.00 50.18           C  
ATOM   1005  CG2 ILE A 116       3.480  46.005   5.717  1.00 50.85           C  
ATOM   1006  CD1 ILE A 116       0.902  47.835   5.604  1.00 51.41           C  
ATOM   1007  N   ILE A 117       2.940  43.696   8.715  1.00 48.53           N  
ATOM   1008  CA  ILE A 117       3.999  43.074   9.505  1.00 48.28           C  
ATOM   1009  C   ILE A 117       3.922  41.543   9.375  1.00 48.11           C  
ATOM   1010  O   ILE A 117       4.938  40.896   9.164  1.00 47.99           O  
ATOM   1011  CB  ILE A 117       3.945  43.448  11.000  1.00 47.55           C  
ATOM   1012  CG1 ILE A 117       4.050  44.963  11.203  1.00 48.19           C  
ATOM   1013  CG2 ILE A 117       5.049  42.716  11.766  1.00 47.55           C  
ATOM   1014  CD1 ILE A 117       3.812  45.407  12.622  1.00 48.04           C  
HETATM 1015  N   MSE A 118       2.728  40.969   9.558  1.00 48.70           N  
HETATM 1016  CA  MSE A 118       2.552  39.515   9.535  1.00 49.27           C  
HETATM 1017  C   MSE A 118       2.875  38.943   8.162  1.00 49.15           C  
HETATM 1018  O   MSE A 118       3.475  37.874   8.073  1.00 49.17           O  
HETATM 1019  CB  MSE A 118       1.123  39.099   9.935  1.00 50.35           C  
HETATM 1020  CG  MSE A 118       0.732  39.314  11.407  1.00 52.25           C  
HETATM 1021 SE   MSE A 118       2.212  38.988  12.680  0.75 61.80          SE  
HETATM 1022  CE  MSE A 118       2.853  37.111  12.117  1.00 62.73           C  
ATOM   1023  N   ARG A 119       2.507  39.666   7.100  1.00 49.21           N  
ATOM   1024  CA  ARG A 119       2.754  39.201   5.753  1.00 50.35           C  
ATOM   1025  C   ARG A 119       4.233  39.123   5.486  1.00 50.30           C  
ATOM   1026  O   ARG A 119       4.663  38.411   4.617  1.00 51.09           O  
ATOM   1027  CB  ARG A 119       2.024  40.038   4.695  1.00 51.20           C  
ATOM   1028  CG  ARG A 119       2.947  40.807   3.751  1.00 54.52           C  
ATOM   1029  N   HIS A 120       5.046  39.818   6.261  1.00 50.30           N  
ATOM   1030  CA  HIS A 120       6.470  39.665   6.098  1.00 49.68           C  
ATOM   1031  C   HIS A 120       6.935  38.255   6.498  1.00 49.43           C  
ATOM   1032  O   HIS A 120       7.964  37.829   6.058  1.00 48.71           O  
ATOM   1033  CB  HIS A 120       7.174  40.741   6.889  1.00 48.98           C  
ATOM   1034  CG  HIS A 120       8.639  40.749   6.715  1.00 49.25           C  
ATOM   1035  ND1 HIS A 120       9.228  40.893   5.489  1.00 54.64           N  
ATOM   1036  CD2 HIS A 120       9.644  40.600   7.601  1.00 50.10           C  
ATOM   1037  CE1 HIS A 120      10.542  40.818   5.622  1.00 53.93           C  
ATOM   1038  NE2 HIS A 120      10.820  40.638   6.893  1.00 51.49           N  
ATOM   1039  N   TYR A 121       6.171  37.536   7.315  1.00 50.39           N  
ATOM   1040  CA  TYR A 121       6.643  36.266   7.942  1.00 50.32           C  
ATOM   1041  C   TYR A 121       5.831  35.044   7.572  1.00 51.04           C  
ATOM   1042  O   TYR A 121       6.324  33.917   7.687  1.00 51.34           O  
ATOM   1043  CB  TYR A 121       6.628  36.412   9.478  1.00 50.22           C  
ATOM   1044  CG  TYR A 121       7.560  37.484   9.960  1.00 47.83           C  
ATOM   1045  CD1 TYR A 121       8.905  37.200  10.135  1.00 48.91           C  
ATOM   1046  CD2 TYR A 121       7.133  38.763  10.160  1.00 47.87           C  
ATOM   1047  CE1 TYR A 121       9.790  38.143  10.514  1.00 47.34           C  
ATOM   1048  CE2 TYR A 121       8.021  39.740  10.552  1.00 49.72           C  
ATOM   1049  CZ  TYR A 121       9.356  39.418  10.735  1.00 48.46           C  
ATOM   1050  OH  TYR A 121      10.262  40.366  11.105  1.00 47.44           O  
ATOM   1051  N   THR A 122       4.582  35.244   7.168  1.00 50.95           N  
ATOM   1052  CA  THR A 122       3.735  34.130   6.800  1.00 51.94           C  
ATOM   1053  C   THR A 122       2.632  34.577   5.878  1.00 52.65           C  
ATOM   1054  O   THR A 122       2.287  35.731   5.844  1.00 52.55           O  
ATOM   1055  CB  THR A 122       3.069  33.427   8.039  1.00 51.60           C  
ATOM   1056  OG1 THR A 122       2.170  32.406   7.592  1.00 53.51           O  
ATOM   1057  CG2 THR A 122       2.279  34.380   8.859  1.00 51.32           C  
ATOM   1058  N   LYS A 123       2.049  33.617   5.171  1.00 54.49           N  
ATOM   1059  CA  LYS A 123       0.947  33.869   4.267  1.00 55.47           C  
ATOM   1060  C   LYS A 123      -0.360  33.596   5.000  1.00 56.36           C  
ATOM   1061  O   LYS A 123      -1.435  33.736   4.440  1.00 56.17           O  
ATOM   1062  CB  LYS A 123       1.079  32.962   3.047  1.00 55.71           C  
ATOM   1063  CG  LYS A 123       2.391  33.119   2.258  1.00 57.21           C  
ATOM   1064  N   ASP A 124      -0.264  33.188   6.259  1.00 57.92           N  
ATOM   1065  CA  ASP A 124      -1.451  32.856   7.048  1.00 59.38           C  
ATOM   1066  C   ASP A 124      -2.321  34.085   7.294  1.00 59.03           C  
ATOM   1067  O   ASP A 124      -1.822  35.191   7.345  1.00 59.04           O  
ATOM   1068  CB  ASP A 124      -1.027  32.241   8.394  1.00 60.46           C  
ATOM   1069  CG  ASP A 124      -0.575  30.793   8.258  1.00 62.52           C  
ATOM   1070  OD1 ASP A 124       0.076  30.485   7.241  1.00 67.43           O  
ATOM   1071  OD2 ASP A 124      -0.901  29.964   9.141  1.00 65.25           O  
ATOM   1072  N   GLN A 125      -3.624  33.881   7.428  1.00 59.30           N  
ATOM   1073  CA  GLN A 125      -4.546  34.971   7.740  1.00 59.29           C  
ATOM   1074  C   GLN A 125      -4.577  35.150   9.244  1.00 58.93           C  
ATOM   1075  O   GLN A 125      -4.826  34.190   9.971  1.00 58.58           O  
ATOM   1076  CB  GLN A 125      -5.959  34.671   7.235  1.00 59.37           C  
ATOM   1077  N   PHE A 126      -4.301  36.372   9.693  1.00 58.61           N  
ATOM   1078  CA  PHE A 126      -4.380  36.720  11.097  1.00 58.99           C  
ATOM   1079  C   PHE A 126      -5.600  37.558  11.367  1.00 58.62           C  
ATOM   1080  O   PHE A 126      -5.877  38.514  10.626  1.00 60.16           O  
ATOM   1081  CB  PHE A 126      -3.180  37.528  11.512  1.00 59.78           C  
ATOM   1082  CG  PHE A 126      -2.030  36.692  11.906  1.00 60.36           C  
ATOM   1083  CD1 PHE A 126      -1.343  35.982  10.968  1.00 59.96           C  
ATOM   1084  CD2 PHE A 126      -1.652  36.596  13.229  1.00 62.32           C  
ATOM   1085  CE1 PHE A 126      -0.303  35.202  11.327  1.00 61.32           C  
ATOM   1086  CE2 PHE A 126      -0.603  35.806  13.596  1.00 62.20           C  
ATOM   1087  CZ  PHE A 126       0.069  35.109  12.649  1.00 61.57           C  
ATOM   1088  N   SER A 127      -6.330  37.199  12.423  1.00 56.79           N  
ATOM   1089  CA  SER A 127      -7.299  38.098  13.019  1.00 54.43           C  
ATOM   1090  C   SER A 127      -6.752  38.700  14.301  1.00 52.83           C  
ATOM   1091  O   SER A 127      -5.789  38.193  14.867  1.00 52.40           O  
ATOM   1092  CB  SER A 127      -8.570  37.360  13.268  1.00 54.16           C  
ATOM   1093  OG  SER A 127      -9.104  36.977  12.025  1.00 55.11           O  
ATOM   1094  N   TYR A 128      -7.348  39.821  14.702  1.00 50.97           N  
ATOM   1095  CA  TYR A 128      -6.996  40.558  15.902  1.00 49.49           C  
ATOM   1096  C   TYR A 128      -8.291  40.996  16.566  1.00 47.58           C  
ATOM   1097  O   TYR A 128      -9.002  41.805  16.016  1.00 47.70           O  
ATOM   1098  CB  TYR A 128      -6.228  41.822  15.551  1.00 50.82           C  
ATOM   1099  CG  TYR A 128      -5.134  41.596  14.557  1.00 51.35           C  
ATOM   1100  CD1 TYR A 128      -5.442  41.549  13.211  1.00 53.88           C  
ATOM   1101  CD2 TYR A 128      -3.809  41.433  14.951  1.00 49.91           C  
ATOM   1102  CE1 TYR A 128      -4.482  41.336  12.266  1.00 54.20           C  
ATOM   1103  CE2 TYR A 128      -2.823  41.203  14.008  1.00 51.50           C  
ATOM   1104  CZ  TYR A 128      -3.191  41.140  12.651  1.00 52.63           C  
ATOM   1105  OH  TYR A 128      -2.312  40.898  11.605  1.00 54.41           O  
ATOM   1106  N   SER A 129      -8.602  40.467  17.738  1.00 44.61           N  
ATOM   1107  CA  SER A 129      -9.743  40.934  18.495  1.00 42.29           C  
ATOM   1108  C   SER A 129      -9.518  42.418  18.790  1.00 40.75           C  
ATOM   1109  O   SER A 129      -8.408  42.881  18.693  1.00 39.70           O  
ATOM   1110  CB  SER A 129      -9.833  40.169  19.795  1.00 41.90           C  
ATOM   1111  OG  SER A 129      -8.771  40.576  20.634  1.00 42.28           O  
ATOM   1112  N   ASP A 130     -10.570  43.147  19.145  1.00 39.24           N  
ATOM   1113  CA  ASP A 130     -10.442  44.533  19.543  1.00 39.46           C  
ATOM   1114  C   ASP A 130      -9.512  44.663  20.741  1.00 39.20           C  
ATOM   1115  O   ASP A 130      -8.645  45.511  20.738  1.00 39.83           O  
ATOM   1116  CB  ASP A 130     -11.801  45.140  19.918  1.00 39.43           C  
ATOM   1117  CG  ASP A 130     -12.659  45.507  18.709  1.00 39.68           C  
ATOM   1118  OD1 ASP A 130     -12.180  45.455  17.535  1.00 40.48           O  
ATOM   1119  OD2 ASP A 130     -13.826  45.878  18.961  1.00 40.05           O  
ATOM   1120  N   PRO A 131      -9.712  43.855  21.794  1.00 39.38           N  
ATOM   1121  CA  PRO A 131      -8.797  43.961  22.923  1.00 39.51           C  
ATOM   1122  C   PRO A 131      -7.331  43.721  22.583  1.00 40.40           C  
ATOM   1123  O   PRO A 131      -6.478  44.357  23.169  1.00 40.56           O  
ATOM   1124  CB  PRO A 131      -9.304  42.884  23.879  1.00 39.34           C  
ATOM   1125  CG  PRO A 131     -10.721  42.783  23.577  1.00 39.31           C  
ATOM   1126  CD  PRO A 131     -10.777  42.871  22.084  1.00 39.11           C  
ATOM   1127  N   ALA A 132      -7.038  42.824  21.641  1.00 41.42           N  
ATOM   1128  CA  ALA A 132      -5.660  42.636  21.146  1.00 42.43           C  
ATOM   1129  C   ALA A 132      -5.162  43.848  20.389  1.00 43.60           C  
ATOM   1130  O   ALA A 132      -4.034  44.257  20.527  1.00 43.66           O  
ATOM   1131  CB  ALA A 132      -5.568  41.381  20.247  1.00 42.04           C  
ATOM   1132  N   VAL A 133      -5.990  44.431  19.553  1.00 45.58           N  
ATOM   1133  CA  VAL A 133      -5.535  45.637  18.860  1.00 46.63           C  
ATOM   1134  C   VAL A 133      -5.286  46.758  19.865  1.00 47.29           C  
ATOM   1135  O   VAL A 133      -4.310  47.494  19.742  1.00 47.23           O  
ATOM   1136  CB  VAL A 133      -6.542  46.087  17.790  1.00 46.58           C  
ATOM   1137  CG1 VAL A 133      -6.037  47.336  17.104  1.00 48.34           C  
ATOM   1138  CG2 VAL A 133      -6.726  45.003  16.779  1.00 46.85           C  
ATOM   1139  N   ARG A 134      -6.175  46.907  20.847  1.00 48.79           N  
ATOM   1140  CA  ARG A 134      -5.971  47.913  21.925  1.00 49.75           C  
ATOM   1141  C   ARG A 134      -4.662  47.782  22.692  1.00 51.12           C  
ATOM   1142  O   ARG A 134      -4.035  48.777  23.011  1.00 51.44           O  
ATOM   1143  CB  ARG A 134      -7.081  47.841  22.959  1.00 49.58           C  
ATOM   1144  CG  ARG A 134      -8.219  48.770  22.684  1.00 47.70           C  
ATOM   1145  CD  ARG A 134      -9.358  48.522  23.644  1.00 44.51           C  
ATOM   1146  NE  ARG A 134     -10.635  48.728  22.982  1.00 39.51           N  
ATOM   1147  CZ  ARG A 134     -11.602  47.839  22.956  1.00 39.17           C  
ATOM   1148  NH1 ARG A 134     -11.469  46.667  23.557  1.00 41.66           N  
ATOM   1149  NH2 ARG A 134     -12.701  48.107  22.304  1.00 38.61           N  
ATOM   1150  N   ASN A 135      -4.257  46.550  22.990  0.50 52.04           N  
ATOM   1152  CA  ASN A 135      -3.089  46.282  23.848  0.50 52.68           C  
ATOM   1154  C   ASN A 135      -1.772  46.164  23.086  0.50 52.96           C  
ATOM   1156  O   ASN A 135      -0.840  45.477  23.541  0.50 53.11           O  
ATOM   1158  CB  ASN A 135      -3.312  44.976  24.625  0.50 52.94           C  
ATOM   1160  CG  ASN A 135      -2.235  44.717  25.675  0.50 53.87           C  
ATOM   1162  OD1 ASN A 135      -1.672  45.648  26.271  0.50 52.12           O  
ATOM   1164  ND2 ASN A 135      -1.952  43.436  25.910  0.50 54.97           N  
ATOM   1166  N   VAL A 136      -1.701  46.772  21.906  1.00 52.83           N  
ATOM   1167  CA  VAL A 136      -0.442  46.827  21.150  1.00 52.16           C  
ATOM   1168  C   VAL A 136      -0.294  48.208  20.622  1.00 51.26           C  
ATOM   1169  O   VAL A 136      -1.300  48.879  20.286  1.00 50.38           O  
ATOM   1170  CB  VAL A 136      -0.343  45.839  19.948  1.00 52.62           C  
ATOM   1171  CG1 VAL A 136      -0.282  44.442  20.441  1.00 55.29           C  
ATOM   1172  CG2 VAL A 136      -1.483  46.024  18.958  1.00 52.83           C  
ATOM   1173  N   LYS A 137       0.961  48.647  20.603  1.00 50.93           N  
ATOM   1174  CA  LYS A 137       1.335  49.886  19.951  1.00 50.69           C  
ATOM   1175  C   LYS A 137       1.849  49.451  18.623  1.00 49.82           C  
ATOM   1176  O   LYS A 137       2.671  48.546  18.539  1.00 48.94           O  
ATOM   1177  CB  LYS A 137       2.403  50.666  20.711  1.00 50.68           C  
ATOM   1178  CG  LYS A 137       1.803  51.719  21.642  1.00 50.79           C  
ATOM   1179  CD  LYS A 137       2.888  52.488  22.311  1.00 52.61           C  
ATOM   1180  CE  LYS A 137       2.371  53.767  22.975  1.00 53.08           C  
ATOM   1181  NZ  LYS A 137       1.963  53.459  24.363  1.00 54.54           N  
ATOM   1182  N   VAL A 138       1.332  50.095  17.591  1.00 49.01           N  
ATOM   1183  CA  VAL A 138       1.762  49.841  16.257  1.00 48.85           C  
ATOM   1184  C   VAL A 138       2.497  51.063  15.737  1.00 48.33           C  
ATOM   1185  O   VAL A 138       1.922  52.149  15.640  1.00 48.51           O  
ATOM   1186  CB  VAL A 138       0.585  49.497  15.342  1.00 48.80           C  
ATOM   1187  CG1 VAL A 138       1.119  49.056  13.995  1.00 49.69           C  
ATOM   1188  CG2 VAL A 138      -0.269  48.361  15.952  1.00 48.22           C  
ATOM   1189  N   TRP A 139       3.750  50.845  15.354  1.00 47.64           N  
ATOM   1190  CA  TRP A 139       4.674  51.908  14.998  1.00 47.23           C  
ATOM   1191  C   TRP A 139       4.657  52.068  13.516  1.00 47.88           C  
ATOM   1192  O   TRP A 139       4.788  51.088  12.798  1.00 48.25           O  
ATOM   1193  CB  TRP A 139       6.085  51.511  15.329  1.00 47.20           C  
ATOM   1194  CG  TRP A 139       6.378  51.142  16.710  1.00 46.82           C  
ATOM   1195  CD1 TRP A 139       5.514  50.712  17.674  1.00 46.66           C  
ATOM   1196  CD2 TRP A 139       7.674  51.093  17.281  1.00 46.39           C  
ATOM   1197  NE1 TRP A 139       6.206  50.427  18.826  1.00 47.36           N  
ATOM   1198  CE2 TRP A 139       7.536  50.652  18.607  1.00 45.16           C  
ATOM   1199  CE3 TRP A 139       8.951  51.391  16.799  1.00 48.23           C  
ATOM   1200  CZ2 TRP A 139       8.625  50.502  19.457  1.00 47.04           C  
ATOM   1201  CZ3 TRP A 139      10.027  51.252  17.648  1.00 45.43           C  
ATOM   1202  CH2 TRP A 139       9.855  50.812  18.960  1.00 45.89           C  
ATOM   1203  N   LYS A 140       4.486  53.294  13.048  1.00 47.82           N  
ATOM   1204  CA  LYS A 140       4.619  53.618  11.638  1.00 48.00           C  
ATOM   1205  C   LYS A 140       5.818  54.516  11.506  1.00 47.38           C  
ATOM   1206  O   LYS A 140       5.979  55.491  12.262  1.00 47.75           O  
ATOM   1207  CB  LYS A 140       3.375  54.332  11.124  1.00 48.83           C  
ATOM   1208  CG  LYS A 140       3.398  54.701   9.651  1.00 49.36           C  
ATOM   1209  CD  LYS A 140       2.078  55.325   9.296  1.00 49.52           C  
ATOM   1210  CE  LYS A 140       2.050  55.757   7.838  1.00 51.87           C  
ATOM   1211  NZ  LYS A 140       0.749  56.405   7.485  1.00 50.37           N  
ATOM   1212  N   VAL A 141       6.674  54.169  10.562  1.00 47.35           N  
ATOM   1213  CA  VAL A 141       7.940  54.883  10.358  1.00 46.97           C  
ATOM   1214  C   VAL A 141       8.096  55.143   8.879  1.00 46.61           C  
ATOM   1215  O   VAL A 141       8.649  54.300   8.144  1.00 45.06           O  
ATOM   1216  CB  VAL A 141       9.147  54.069  10.850  1.00 46.68           C  
ATOM   1217  CG1 VAL A 141      10.415  54.903  10.741  1.00 44.78           C  
ATOM   1218  CG2 VAL A 141       8.937  53.588  12.286  1.00 46.97           C  
ATOM   1219  N   PRO A 142       7.577  56.292   8.424  1.00 45.87           N  
ATOM   1220  CA  PRO A 142       7.857  56.651   7.037  1.00 46.09           C  
ATOM   1221  C   PRO A 142       9.352  56.850   6.915  1.00 46.22           C  
ATOM   1222  O   PRO A 142       9.961  57.484   7.791  1.00 45.84           O  
ATOM   1223  CB  PRO A 142       7.107  57.969   6.832  1.00 46.04           C  
ATOM   1224  CG  PRO A 142       6.078  58.059   7.984  1.00 46.36           C  
ATOM   1225  CD  PRO A 142       6.745  57.290   9.121  1.00 46.39           C  
ATOM   1226  N   VAL A 143       9.940  56.268   5.876  1.00 46.73           N  
ATOM   1227  CA  VAL A 143      11.381  56.257   5.738  1.00 47.72           C  
ATOM   1228  C   VAL A 143      11.823  57.486   5.009  1.00 48.37           C  
ATOM   1229  O   VAL A 143      11.510  57.644   3.827  1.00 48.55           O  
ATOM   1230  CB  VAL A 143      11.879  55.026   4.974  1.00 47.41           C  
ATOM   1231  CG1 VAL A 143      13.386  55.161   4.637  1.00 48.66           C  
ATOM   1232  CG2 VAL A 143      11.640  53.809   5.793  1.00 47.53           C  
ATOM   1233  N   ASP A 144      12.585  58.326   5.699  1.00 49.25           N  
ATOM   1234  CA  ASP A 144      13.064  59.581   5.116  1.00 50.11           C  
ATOM   1235  C   ASP A 144      14.380  59.419   4.373  1.00 50.71           C  
ATOM   1236  O   ASP A 144      14.652  60.153   3.432  1.00 50.28           O  
ATOM   1237  CB  ASP A 144      13.187  60.646   6.201  1.00 50.23           C  
ATOM   1238  CG  ASP A 144      11.841  61.064   6.735  1.00 50.84           C  
ATOM   1239  OD1 ASP A 144      10.910  61.211   5.922  1.00 50.54           O  
ATOM   1240  OD2 ASP A 144      11.704  61.223   7.961  1.00 53.43           O  
ATOM   1241  N   GLN A 145      15.206  58.477   4.811  1.00 51.89           N  
ATOM   1242  CA  GLN A 145      16.428  58.166   4.105  1.00 52.72           C  
ATOM   1243  C   GLN A 145      16.700  56.677   4.225  1.00 52.45           C  
ATOM   1244  O   GLN A 145      16.627  56.095   5.293  1.00 52.88           O  
ATOM   1245  CB  GLN A 145      17.609  59.001   4.631  1.00 53.07           C  
ATOM   1246  CG  GLN A 145      18.930  58.622   3.946  1.00 54.91           C  
ATOM   1247  CD  GLN A 145      20.109  59.473   4.388  1.00 55.81           C  
ATOM   1248  OE1 GLN A 145      20.051  60.142   5.436  1.00 58.64           O  
ATOM   1249  NE2 GLN A 145      21.193  59.452   3.585  1.00 56.48           N  
HETATM 1250  N   MSE A 146      16.971  56.070   3.079  1.00 52.66           N  
HETATM 1251  CA  MSE A 146      17.193  54.667   2.967  1.00 52.75           C  
HETATM 1252  C   MSE A 146      18.460  54.487   2.184  1.00 51.08           C  
HETATM 1253  O   MSE A 146      18.572  54.971   1.083  1.00 49.76           O  
HETATM 1254  CB  MSE A 146      16.070  54.029   2.225  1.00 52.09           C  
HETATM 1255  CG  MSE A 146      16.252  52.528   2.064  1.00 55.20           C  
HETATM 1256 SE   MSE A 146      14.678  51.818   1.159  0.75 57.98          SE  
HETATM 1257  CE  MSE A 146      13.612  51.470   2.577  1.00 60.72           C  
ATOM   1258  N   THR A 147      19.409  53.766   2.771  1.00 50.83           N  
ATOM   1259  CA  THR A 147      20.728  53.554   2.171  1.00 50.35           C  
ATOM   1260  C   THR A 147      21.134  52.110   2.308  1.00 49.92           C  
ATOM   1261  O   THR A 147      20.577  51.384   3.124  1.00 50.02           O  
ATOM   1262  CB  THR A 147      21.765  54.470   2.810  1.00 50.04           C  
ATOM   1263  OG1 THR A 147      21.771  54.283   4.226  1.00 49.97           O  
ATOM   1264  CG2 THR A 147      21.390  55.867   2.572  1.00 50.25           C  
ATOM   1265  N   GLY A 148      22.084  51.693   1.487  1.00 49.32           N  
ATOM   1266  CA  GLY A 148      22.580  50.321   1.504  1.00 49.45           C  
ATOM   1267  C   GLY A 148      24.084  50.366   1.379  1.00 50.11           C  
ATOM   1268  O   GLY A 148      24.635  51.347   0.893  1.00 49.68           O  
ATOM   1269  N   LYS A 149      24.753  49.327   1.847  1.00 50.64           N  
ATOM   1270  CA  LYS A 149      26.208  49.319   1.894  1.00 52.06           C  
ATOM   1271  C   LYS A 149      26.597  47.876   1.710  1.00 52.58           C  
ATOM   1272  O   LYS A 149      25.959  46.994   2.267  1.00 52.24           O  
ATOM   1273  CB  LYS A 149      26.748  49.916   3.237  1.00 52.17           C  
ATOM   1274  CG  LYS A 149      28.118  50.713   3.169  1.00 54.92           C  
ATOM   1275  CD  LYS A 149      28.033  52.284   3.250  1.00 56.32           C  
ATOM   1276  N   VAL A 150      27.602  47.619   0.873  1.00 53.65           N  
ATOM   1277  CA  VAL A 150      28.263  46.318   0.841  1.00 53.99           C  
ATOM   1278  C   VAL A 150      29.603  46.436   1.551  1.00 54.88           C  
ATOM   1279  O   VAL A 150      30.386  47.337   1.269  1.00 55.96           O  
ATOM   1280  CB  VAL A 150      28.549  45.858  -0.570  1.00 54.20           C  
ATOM   1281  CG1 VAL A 150      29.345  44.563  -0.536  1.00 54.31           C  
ATOM   1282  CG2 VAL A 150      27.246  45.690  -1.360  1.00 54.82           C  
ATOM   1283  N   PHE A 151      29.884  45.538   2.466  1.00 55.38           N  
ATOM   1284  CA  PHE A 151      31.158  45.555   3.110  1.00 56.25           C  
ATOM   1285  C   PHE A 151      31.977  44.334   2.707  1.00 56.88           C  
ATOM   1286  O   PHE A 151      31.495  43.226   2.840  1.00 57.70           O  
ATOM   1287  CB  PHE A 151      30.980  45.588   4.601  1.00 56.02           C  
ATOM   1288  CG  PHE A 151      32.244  45.336   5.354  1.00 56.43           C  
ATOM   1289  CD1 PHE A 151      32.603  44.028   5.691  1.00 56.04           C  
ATOM   1290  CD2 PHE A 151      33.079  46.388   5.723  1.00 53.82           C  
ATOM   1291  CE1 PHE A 151      33.762  43.767   6.403  1.00 57.12           C  
ATOM   1292  CE2 PHE A 151      34.233  46.158   6.449  1.00 55.59           C  
ATOM   1293  CZ  PHE A 151      34.587  44.816   6.800  1.00 57.16           C  
ATOM   1294  N   GLY A 152      33.217  44.571   2.243  1.00 57.15           N  
ATOM   1295  CA  GLY A 152      34.188  43.538   1.878  1.00 57.02           C  
ATOM   1296  C   GLY A 152      35.418  43.559   2.757  1.00 57.25           C  
ATOM   1297  O   GLY A 152      36.193  44.511   2.710  1.00 57.64           O  
ATOM   1298  N   LEU A 153      35.590  42.505   3.566  1.00 57.62           N  
ATOM   1299  CA  LEU A 153      36.795  42.281   4.387  1.00 57.59           C  
ATOM   1300  C   LEU A 153      37.759  41.306   3.699  1.00 56.05           C  
ATOM   1301  O   LEU A 153      37.389  40.168   3.495  1.00 55.75           O  
ATOM   1302  CB  LEU A 153      36.396  41.731   5.756  1.00 57.89           C  
ATOM   1303  CG  LEU A 153      37.497  41.108   6.636  1.00 60.45           C  
ATOM   1304  CD1 LEU A 153      38.801  41.882   6.529  1.00 61.88           C  
ATOM   1305  CD2 LEU A 153      37.054  41.041   8.126  1.00 60.09           C  
ATOM   1306  N   ARG A 154      38.992  41.743   3.417  1.00 53.73           N  
ATOM   1307  CA  ARG A 154      39.874  41.077   2.474  1.00 53.40           C  
ATOM   1308  C   ARG A 154      41.208  40.574   3.086  1.00 52.02           C  
ATOM   1309  O   ARG A 154      41.786  41.175   3.951  1.00 50.01           O  
ATOM   1310  CB  ARG A 154      40.164  42.010   1.274  1.00 53.43           C  
ATOM   1311  CG  ARG A 154      40.264  41.285  -0.114  1.00 55.27           C  
ATOM   1312  CD  ARG A 154      41.435  41.776  -1.044  1.00 55.40           C  
ATOM   1313  N   ALA A 155      41.673  39.437   2.615  1.00 51.90           N  
ATOM   1314  CA  ALA A 155      43.009  38.954   2.950  1.00 52.99           C  
ATOM   1315  C   ALA A 155      43.593  38.265   1.729  1.00 53.58           C  
ATOM   1316  O   ALA A 155      42.844  37.678   0.961  1.00 52.19           O  
ATOM   1317  CB  ALA A 155      42.940  38.017   4.120  1.00 53.13           C  
ATOM   1318  N   ASP A 156      44.911  38.371   1.538  1.00 55.59           N  
ATOM   1319  CA  ASP A 156      45.609  37.784   0.387  1.00 57.53           C  
ATOM   1320  C   ASP A 156      46.727  36.853   0.856  1.00 58.85           C  
ATOM   1321  O   ASP A 156      47.206  37.008   1.960  1.00 58.96           O  
ATOM   1322  CB  ASP A 156      46.227  38.883  -0.476  1.00 58.08           C  
ATOM   1323  CG  ASP A 156      45.191  39.686  -1.292  1.00 60.66           C  
ATOM   1324  OD1 ASP A 156      43.961  39.589  -1.062  1.00 64.80           O  
ATOM   1325  OD2 ASP A 156      45.629  40.458  -2.178  1.00 63.21           O  
ATOM   1326  N   GLU A 157      47.133  35.894   0.020  1.00 60.56           N  
ATOM   1327  CA  GLU A 157      48.250  34.964   0.340  1.00 62.48           C  
ATOM   1328  C   GLU A 157      49.584  35.636   0.068  1.00 62.10           C  
ATOM   1329  O   GLU A 157      49.610  36.635  -0.642  1.00 62.75           O  
ATOM   1330  CB  GLU A 157      48.174  33.662  -0.485  1.00 62.55           C  
ATOM   1331  CG  GLU A 157      47.227  32.557   0.060  1.00 64.51           C  
ATOM   1332  CD  GLU A 157      47.073  31.358  -0.908  1.00 65.38           C  
ATOM   1333  OE1 GLU A 157      47.115  31.558  -2.151  1.00 68.51           O  
ATOM   1334  OE2 GLU A 157      46.919  30.207  -0.426  1.00 70.08           O  
TER    1335      GLU A 157                                                      
END
MOLECULE T0506.pdb
ATOM      1  N   VAL     4      16.223  74.529   6.413  1.00 43.65           N  
ATOM      2  CA  VAL     4      17.370  74.880   7.304  1.00 43.82           C  
ATOM      3  C   VAL     4      17.963  73.638   8.008  1.00 43.97           C  
ATOM      4  O   VAL     4      19.114  73.665   8.459  1.00 44.37           O  
ATOM      5  CB  VAL     4      16.969  76.004   8.316  1.00 43.84           C  
ATOM      6  CG1 VAL     4      18.109  76.346   9.267  1.00 44.06           C  
ATOM      7  CG2 VAL     4      16.529  77.270   7.571  1.00 43.89           C  
ATOM      8  N   ALA     5      17.192  72.548   8.063  1.00 43.79           N  
ATOM      9  CA  ALA     5      17.573  71.332   8.805  1.00 43.55           C  
ATOM     10  C   ALA     5      18.661  70.477   8.131  1.00 43.26           C  
ATOM     11  O   ALA     5      18.524  70.078   6.973  1.00 42.98           O  
ATOM     12  CB  ALA     5      16.339  70.479   9.111  1.00 43.90           C  
ATOM     13  N   PRO     6      19.740  70.170   8.871  1.00 43.22           N  
ATOM     14  CA  PRO     6      20.844  69.368   8.331  1.00 42.95           C  
ATOM     15  C   PRO     6      20.447  67.919   7.950  1.00 42.45           C  
ATOM     16  O   PRO     6      19.464  67.374   8.487  1.00 41.77           O  
ATOM     17  CB  PRO     6      21.854  69.359   9.484  1.00 43.23           C  
ATOM     18  CG  PRO     6      21.006  69.553  10.707  1.00 43.87           C  
ATOM     19  CD  PRO     6      19.985  70.552  10.274  1.00 43.24           C  
ATOM     20  N   PRO     7      21.198  67.301   7.015  1.00 41.83           N  
ATOM     21  CA  PRO     7      20.961  65.893   6.726  1.00 41.46           C  
ATOM     22  C   PRO     7      20.933  65.068   8.016  1.00 40.74           C  
ATOM     23  O   PRO     7      21.728  65.315   8.930  1.00 40.20           O  
ATOM     24  CB  PRO     7      22.164  65.498   5.854  1.00 42.16           C  
ATOM     25  CG  PRO     7      23.099  66.664   5.880  1.00 41.75           C  
ATOM     26  CD  PRO     7      22.276  67.858   6.180  1.00 41.68           C  
ATOM     27  N   VAL     8      19.999  64.129   8.112  1.00 40.33           N  
ATOM     28  CA  VAL     8      19.881  63.318   9.347  1.00 39.91           C  
ATOM     29  C   VAL     8      21.138  62.431   9.570  1.00 40.27           C  
ATOM     30  O   VAL     8      21.506  62.089  10.707  1.00 40.37           O  
ATOM     31  CB  VAL     8      18.516  62.556   9.435  1.00 39.67           C  
ATOM     32  CG1 VAL     8      17.329  63.555   9.348  1.00 36.98           C  
ATOM     33  CG2 VAL     8      18.390  61.517   8.365  1.00 38.22           C  
ATOM     34  N   ILE     9      21.801  62.086   8.475  1.00 40.55           N  
ATOM     35  CA  ILE     9      23.080  61.402   8.548  1.00 40.74           C  
ATOM     36  C   ILE     9      24.104  62.396   8.056  1.00 40.78           C  
ATOM     37  O   ILE     9      24.011  62.841   6.917  1.00 41.63           O  
ATOM     38  CB  ILE     9      23.118  60.143   7.647  1.00 40.61           C  
ATOM     39  CG1 ILE     9      21.953  59.189   7.985  1.00 41.00           C  
ATOM     40  CG2 ILE     9      24.517  59.462   7.731  1.00 39.79           C  
ATOM     41  CD1 ILE     9      21.690  58.061   6.971  1.00 40.63           C  
ATOM     42  N   THR    10      25.056  62.771   8.909  1.00 40.43           N  
ATOM     43  CA  THR    10      26.176  63.599   8.483  1.00 40.73           C  
ATOM     44  C   THR    10      27.078  62.807   7.534  1.00 40.81           C  
ATOM     45  O   THR    10      27.550  61.725   7.907  1.00 41.55           O  
ATOM     46  CB  THR    10      26.948  64.128   9.696  1.00 40.40           C  
ATOM     47  OG1 THR    10      26.031  64.861  10.516  1.00 39.93           O  
ATOM     48  CG2 THR    10      28.134  65.030   9.289  1.00 40.89           C  
ATOM     49  N   PRO    11      27.264  63.306   6.290  1.00 40.27           N  
ATOM     50  CA  PRO    11      28.106  62.635   5.300  1.00 40.30           C  
ATOM     51  C   PRO    11      29.531  62.424   5.796  1.00 40.59           C  
ATOM     52  O   PRO    11      30.089  63.270   6.519  1.00 40.09           O  
ATOM     53  CB  PRO    11      28.124  63.627   4.123  1.00 39.98           C  
ATOM     54  CG  PRO    11      26.898  64.368   4.249  1.00 39.70           C  
ATOM     55  CD  PRO    11      26.687  64.541   5.731  1.00 40.75           C  
ATOM     56  N   ARG    12      30.113  61.303   5.387  1.00 41.07           N  
ATOM     57  CA  ARG    12      31.472  60.953   5.767  1.00 41.14           C  
ATOM     58  C   ARG    12      32.453  61.993   5.258  1.00 41.53           C  
ATOM     59  O   ARG    12      33.228  62.542   6.035  1.00 41.73           O  
ATOM     60  CB  ARG    12      31.835  59.577   5.213  1.00 41.12           C  
ATOM     61  CG  ARG    12      32.473  58.648   6.214  1.00 39.82           C  
ATOM     62  CD  ARG    12      33.423  59.386   7.103  1.00 37.35           C  
ATOM     63  NE  ARG    12      34.538  58.566   7.537  1.00 35.24           N  
ATOM     64  CZ  ARG    12      35.491  59.009   8.340  1.00 36.29           C  
ATOM     65  NH1 ARG    12      35.452  60.263   8.767  1.00 35.93           N  
ATOM     66  NH2 ARG    12      36.488  58.210   8.710  1.00 36.57           N  
ATOM     67  N   PHE    24      26.609  45.777  -8.751  1.00 49.65           N  
ATOM     68  CA  PHE    24      26.051  46.396  -7.541  1.00 49.63           C  
ATOM     69  C   PHE    24      25.420  47.733  -7.925  1.00 48.93           C  
ATOM     70  O   PHE    24      26.123  48.667  -8.335  1.00 49.03           O  
ATOM     71  CB  PHE    24      27.132  46.601  -6.452  1.00 49.78           C  
ATOM     72  CG  PHE    24      26.616  47.272  -5.196  1.00 50.83           C  
ATOM     73  CD1 PHE    24      26.081  46.515  -4.146  1.00 50.02           C  
ATOM     74  CD2 PHE    24      26.659  48.674  -5.061  1.00 51.88           C  
ATOM     75  CE1 PHE    24      25.585  47.152  -2.977  1.00 50.73           C  
ATOM     76  CE2 PHE    24      26.163  49.313  -3.901  1.00 50.87           C  
ATOM     77  CZ  PHE    24      25.627  48.551  -2.863  1.00 49.25           C  
ATOM     78  N   GLU    25      24.099  47.813  -7.832  1.00 47.53           N  
ATOM     79  CA  GLU    25      23.428  49.088  -8.068  1.00 46.43           C  
ATOM     80  C   GLU    25      22.710  49.488  -6.817  1.00 44.86           C  
ATOM     81  O   GLU    25      21.685  48.901  -6.451  1.00 45.13           O  
ATOM     82  CB  GLU    25      22.471  49.047  -9.256  1.00 47.06           C  
ATOM     83  CG  GLU    25      22.225  50.443  -9.881  1.00 47.24           C  
ATOM     84  CD  GLU    25      21.172  51.248  -9.119  1.00 46.10           C  
ATOM     85  OE1 GLU    25      21.561  52.100  -8.295  1.00 45.74           O  
ATOM     86  OE2 GLU    25      19.958  51.022  -9.342  1.00 44.94           O  
ATOM     87  N   ALA    26      23.264  50.509  -6.181  1.00 43.10           N  
ATOM     88  CA  ALA    26      22.889  50.896  -4.846  1.00 42.10           C  
ATOM     89  C   ALA    26      21.383  50.862  -4.620  1.00 41.22           C  
ATOM     90  O   ALA    26      20.938  50.241  -3.667  1.00 41.52           O  
ATOM     91  CB  ALA    26      23.459  52.259  -4.514  1.00 42.27           C  
ATOM     92  N   VAL    27      20.618  51.503  -5.507  1.00 39.82           N  
ATOM     93  CA  VAL    27      19.170  51.685  -5.330  1.00 38.62           C  
ATOM     94  C   VAL    27      18.441  50.333  -5.389  1.00 38.25           C  
ATOM     95  O   VAL    27      17.627  50.011  -4.527  1.00 38.38           O  
ATOM     96  CB  VAL    27      18.586  52.704  -6.353  1.00 37.58           C  
ATOM     97  CG1 VAL    27      17.069  52.638  -6.404  1.00 37.20           C  
ATOM     98  CG2 VAL    27      19.050  54.113  -6.001  1.00 37.77           C  
ATOM     99  N   ARG    28      18.794  49.533  -6.374  1.00 38.45           N  
ATOM    100  CA  ARG    28      18.189  48.223  -6.565  1.00 39.15           C  
ATOM    101  C   ARG    28      18.541  47.242  -5.432  1.00 38.81           C  
ATOM    102  O   ARG    28      17.647  46.634  -4.831  1.00 39.72           O  
ATOM    103  CB  ARG    28      18.559  47.687  -7.963  1.00 38.85           C  
ATOM    104  CG  ARG    28      18.278  46.216  -8.142  1.00 41.94           C  
ATOM    105  CD  ARG    28      16.816  45.790  -7.837  1.00 45.21           C  
ATOM    106  NE  ARG    28      16.439  44.831  -8.874  1.00 51.01           N  
ATOM    107  CZ  ARG    28      16.676  43.525  -8.835  1.00 49.95           C  
ATOM    108  NH1 ARG    28      17.225  42.961  -7.766  1.00 50.06           N  
ATOM    109  NH2 ARG    28      16.313  42.783  -9.854  1.00 49.70           N  
ATOM    110  N   VAL    29      19.822  47.129  -5.087  1.00 38.22           N  
ATOM    111  CA  VAL    29      20.219  46.316  -3.927  1.00 37.36           C  
ATOM    112  C   VAL    29      19.496  46.775  -2.649  1.00 36.79           C  
ATOM    113  O   VAL    29      19.018  45.955  -1.848  1.00 36.89           O  
ATOM    114  CB  VAL    29      21.772  46.348  -3.708  1.00 37.56           C  
ATOM    115  CG1 VAL    29      22.144  45.746  -2.370  1.00 37.50           C  
ATOM    116  CG2 VAL    29      22.494  45.612  -4.819  1.00 37.85           C  
ATOM    117  N   ALA    30      19.421  48.097  -2.454  1.00 35.35           N  
ATOM    118  CA  ALA    30      18.687  48.682  -1.336  1.00 34.46           C  
ATOM    119  C   ALA    30      17.203  48.317  -1.292  1.00 33.63           C  
ATOM    120  O   ALA    30      16.700  47.953  -0.243  1.00 33.01           O  
ATOM    121  CB  ALA    30      18.851  50.228  -1.333  1.00 33.58           C  
ATOM    122  N   ARG    31      16.515  48.424  -2.422  1.00 32.99           N  
ATOM    123  CA  ARG    31      15.084  48.146  -2.496  1.00 34.07           C  
ATOM    124  C   ARG    31      14.826  46.663  -2.284  1.00 33.95           C  
ATOM    125  O   ARG    31      13.803  46.281  -1.725  1.00 35.51           O  
ATOM    126  CB  ARG    31      14.481  48.670  -3.812  1.00 33.27           C  
ATOM    127  CG  ARG    31      14.226  50.179  -3.744  1.00 34.01           C  
ATOM    128  CD  ARG    31      13.577  50.726  -5.019  1.00 35.99           C  
ATOM    129  NE  ARG    31      12.143  50.433  -5.017  1.00 33.98           N  
ATOM    130  CZ  ARG    31      11.416  50.411  -6.115  1.00 38.90           C  
ATOM    131  NH1 ARG    31      12.005  50.704  -7.262  1.00 31.97           N  
ATOM    132  NH2 ARG    31      10.110  50.128  -6.060  1.00 42.34           N  
ATOM    133  N   ASP    32      15.778  45.838  -2.686  1.00 34.58           N  
ATOM    134  CA  ASP    32      15.679  44.398  -2.466  0.50 35.02           C  
ATOM    136  C   ASP    32      15.826  44.056  -1.006  1.00 34.99           C  
ATOM    137  O   ASP    32      15.045  43.274  -0.480  1.00 35.71           O  
ATOM    138  CB  ASP    32      16.723  43.631  -3.275  0.50 34.91           C  
ATOM    140  CG  ASP    32      16.252  42.240  -3.643  0.50 37.60           C  
ATOM    142  OD1 ASP    32      15.113  42.109  -4.168  0.50 37.96           O  
ATOM    144  OD2 ASP    32      17.027  41.278  -3.431  0.50 39.94           O  
ATOM    146  N   VAL    33      16.799  44.665  -0.335  1.00 35.69           N  
ATOM    147  CA  VAL    33      16.952  44.479   1.129  1.00 35.38           C  
ATOM    148  C   VAL    33      15.725  44.991   1.852  1.00 36.91           C  
ATOM    149  O   VAL    33      15.266  44.403   2.861  1.00 37.01           O  
ATOM    150  CB  VAL    33      18.200  45.234   1.681  1.00 35.08           C  
ATOM    151  CG1 VAL    33      18.291  45.100   3.203  1.00 35.22           C  
ATOM    152  CG2 VAL    33      19.474  44.688   1.037  1.00 33.53           C  
ATOM    153  N   LEU    34      15.223  46.132   1.383  1.00 36.92           N  
ATOM    154  CA  LEU    34      14.044  46.713   1.963  1.00 37.55           C  
ATOM    155  C   LEU    34      12.872  45.725   1.973  1.00 37.09           C  
ATOM    156  O   LEU    34      12.183  45.569   3.011  1.00 37.29           O  
ATOM    157  CB  LEU    34      13.635  47.981   1.239  1.00 37.10           C  
ATOM    158  CG  LEU    34      12.325  48.656   1.652  1.00 36.56           C  
ATOM    159  CD1 LEU    34      12.382  49.294   3.019  1.00 35.33           C  
ATOM    160  CD2 LEU    34      12.021  49.705   0.548  1.00 33.63           C  
ATOM    161  N   HIS    35      12.674  45.055   0.852  1.00 36.94           N  
ATOM    162  CA  HIS    35      11.488  44.235   0.692  1.00 37.17           C  
ATOM    163  C   HIS    35      11.613  42.812   1.221  1.00 37.43           C  
ATOM    164  O   HIS    35      10.598  42.106   1.372  1.00 36.36           O  
ATOM    165  CB  HIS    35      11.031  44.238  -0.765  1.00 36.90           C  
ATOM    166  CG  HIS    35      10.298  45.502  -1.165  1.00 37.86           C  
ATOM    167  ND1 HIS    35       8.920  45.593  -1.165  1.00 38.07           N  
ATOM    168  CD2 HIS    35      10.751  46.717  -1.569  1.00 36.41           C  
ATOM    169  CE1 HIS    35       8.553  46.819  -1.526  1.00 36.43           C  
ATOM    170  NE2 HIS    35       9.647  47.517  -1.784  1.00 36.29           N  
ATOM    171  N   THR    36      12.843  42.372   1.438  1.00 36.97           N  
ATOM    172  CA  THR    36      13.079  40.969   1.718  1.00 37.62           C  
ATOM    173  C   THR    36      13.741  40.752   3.075  1.00 38.16           C  
ATOM    174  O   THR    36      14.194  39.635   3.373  1.00 38.65           O  
ATOM    175  CB  THR    36      13.897  40.253   0.588  1.00 39.04           C  
ATOM    176  OG1 THR    36      15.189  40.884   0.435  1.00 37.71           O  
ATOM    177  CG2 THR    36      13.146  40.274  -0.759  1.00 37.27           C  
ATOM    178  N   SER    37      13.811  41.788   3.890  1.00 37.79           N  
ATOM    179  CA  SER    37      14.363  41.613   5.263  1.00 39.48           C  
ATOM    180  C   SER    37      13.260  41.475   6.314  1.00 38.86           C  
ATOM    181  O   SER    37      12.412  42.358   6.422  1.00 38.51           O  
ATOM    182  CB  SER    37      15.345  42.762   5.618  1.00 38.38           C  
ATOM    183  OG  SER    37      16.371  42.838   4.608  1.00 41.05           O  
ATOM    184  N   ARG    38      13.268  40.369   7.076  1.00 39.77           N  
ATOM    185  CA  ARG    38      12.327  40.179   8.211  1.00 41.34           C  
ATOM    186  C   ARG    38      12.758  40.914   9.477  1.00 42.43           C  
ATOM    187  O   ARG    38      11.968  41.608  10.100  1.00 42.17           O  
ATOM    188  CB  ARG    38      12.100  38.691   8.578  1.00 41.21           C  
ATOM    189  CG  ARG    38      10.919  38.002   7.837  1.00 42.35           C  
ATOM    190  CD  ARG    38      10.623  36.515   8.413  1.00 44.16           C  
ATOM    191  NE  ARG    38       9.250  36.088   8.125  1.00 48.27           N  
ATOM    192  CZ  ARG    38       8.909  35.290   7.123  1.00 48.91           C  
ATOM    193  NH1 ARG    38       7.635  34.955   6.942  1.00 48.62           N  
ATOM    194  NH2 ARG    38       9.846  34.775   6.322  1.00 51.54           N  
ATOM    195  N   THR    39      14.015  40.742   9.867  1.00 43.04           N  
ATOM    196  CA  THR    39      14.487  41.282  11.126  1.00 43.56           C  
ATOM    197  C   THR    39      15.269  42.567  10.903  1.00 43.75           C  
ATOM    198  O   THR    39      16.001  42.696   9.921  1.00 43.67           O  
ATOM    199  CB  THR    39      15.318  40.257  11.910  1.00 43.91           C  
ATOM    200  OG1 THR    39      14.552  39.053  12.056  1.00 45.50           O  
ATOM    201  CG2 THR    39      15.640  40.777  13.315  1.00 44.70           C  
ATOM    202  N   ALA    40      15.033  43.524  11.799  1.00 41.52           N  
ATOM    203  CA  ALA    40      15.651  44.828  11.787  1.00 40.98           C  
ATOM    204  C   ALA    40      16.237  45.164  13.169  1.00 40.63           C  
ATOM    205  O   ALA    40      15.643  44.853  14.180  1.00 40.12           O  
ATOM    206  CB  ALA    40      14.604  45.873  11.432  1.00 41.19           C  
ATOM    207  N   ALA    41      17.418  45.765  13.177  1.00 39.80           N  
ATOM    208  CA  ALA    41      17.920  46.465  14.324  1.00 38.78           C  
ATOM    209  C   ALA    41      17.158  47.790  14.407  1.00 39.25           C  
ATOM    210  O   ALA    41      16.861  48.426  13.397  1.00 38.98           O  
ATOM    211  CB  ALA    41      19.416  46.708  14.140  1.00 39.12           C  
ATOM    212  N   LEU    42      16.797  48.193  15.623  1.00 38.68           N  
ATOM    213  CA  LEU    42      16.037  49.406  15.853  1.00 39.79           C  
ATOM    214  C   LEU    42      16.785  50.125  16.957  1.00 39.98           C  
ATOM    215  O   LEU    42      17.011  49.536  18.044  1.00 38.61           O  
ATOM    216  CB  LEU    42      14.655  49.049  16.433  1.00 40.02           C  
ATOM    217  CG  LEU    42      13.458  50.015  16.368  1.00 43.63           C  
ATOM    218  CD1 LEU    42      12.539  49.898  17.612  1.00 42.40           C  
ATOM    219  CD2 LEU    42      13.771  51.474  16.022  1.00 39.93           C  
ATOM    220  N   ALA    43      17.123  51.378  16.688  1.00 38.14           N  
ATOM    221  CA  ALA    43      17.741  52.250  17.656  1.00 38.67           C  
ATOM    222  C   ALA    43      16.827  53.423  17.999  1.00 39.37           C  
ATOM    223  O   ALA    43      16.177  54.035  17.134  1.00 40.23           O  
ATOM    224  CB  ALA    43      19.111  52.747  17.153  1.00 38.06           C  
ATOM    225  N   THR    44      16.877  53.783  19.273  1.00 39.46           N  
ATOM    226  CA  THR    44      15.964  54.691  19.898  1.00 38.96           C  
ATOM    227  C   THR    44      16.884  55.530  20.822  1.00 38.63           C  
ATOM    228  O   THR    44      18.054  55.168  21.043  1.00 38.06           O  
ATOM    229  CB  THR    44      14.985  53.702  20.568  1.00 40.23           C  
ATOM    230  OG1 THR    44      13.679  53.682  19.961  1.00 45.89           O  
ATOM    231  CG2 THR    44      15.079  53.504  22.014  1.00 33.78           C  
ATOM    232  N   LEU    45      16.389  56.659  21.328  1.00 38.88           N  
ATOM    233  CA  LEU    45      17.207  57.508  22.210  1.00 38.18           C  
ATOM    234  C   LEU    45      16.689  57.522  23.642  1.00 38.60           C  
ATOM    235  O   LEU    45      15.488  57.696  23.887  1.00 39.08           O  
ATOM    236  CB  LEU    45      17.306  58.953  21.676  1.00 38.20           C  
ATOM    237  CG  LEU    45      17.965  59.257  20.311  1.00 38.94           C  
ATOM    238  CD1 LEU    45      17.732  60.739  19.933  1.00 35.37           C  
ATOM    239  CD2 LEU    45      19.475  58.944  20.302  1.00 34.51           C  
ATOM    240  N   ASP    46      17.602  57.365  24.594  1.00 38.81           N  
ATOM    241  CA  ASP    46      17.234  57.458  25.978  1.00 38.11           C  
ATOM    242  C   ASP    46      16.965  58.919  26.355  1.00 38.82           C  
ATOM    243  O   ASP    46      17.782  59.804  26.077  1.00 39.17           O  
ATOM    244  CB  ASP    46      18.269  56.823  26.873  1.00 37.52           C  
ATOM    245  CG  ASP    46      17.782  56.687  28.297  1.00 38.27           C  
ATOM    246  OD1 ASP    46      17.801  57.702  29.037  1.00 39.29           O  
ATOM    247  OD2 ASP    46      17.353  55.572  28.670  1.00 39.12           O  
ATOM    248  N   PRO    47      15.793  59.181  26.968  1.00 39.51           N  
ATOM    249  CA  PRO    47      15.406  60.562  27.316  1.00 39.59           C  
ATOM    250  C   PRO    47      16.261  61.296  28.350  1.00 39.85           C  
ATOM    251  O   PRO    47      16.218  62.528  28.393  1.00 41.11           O  
ATOM    252  CB  PRO    47      13.972  60.421  27.810  1.00 39.48           C  
ATOM    253  CG  PRO    47      13.786  59.014  28.136  1.00 39.84           C  
ATOM    254  CD  PRO    47      14.738  58.210  27.302  1.00 39.29           C  
ATOM    255  N   VAL    48      16.978  60.575  29.215  1.00 39.58           N  
ATOM    256  CA  VAL    48      17.764  61.207  30.288  1.00 38.34           C  
ATOM    257  C   VAL    48      19.253  61.154  29.955  1.00 37.75           C  
ATOM    258  O   VAL    48      19.960  62.160  30.031  1.00 36.21           O  
ATOM    259  CB  VAL    48      17.522  60.535  31.703  1.00 38.53           C  
ATOM    260  CG1 VAL    48      18.371  61.189  32.800  1.00 38.22           C  
ATOM    261  CG2 VAL    48      16.045  60.571  32.106  1.00 38.99           C  
ATOM    262  N   SER    49      19.719  59.969  29.570  1.00 37.22           N  
ATOM    263  CA  SER    49      21.152  59.725  29.436  1.00 37.08           C  
ATOM    264  C   SER    49      21.684  60.192  28.093  1.00 37.18           C  
ATOM    265  O   SER    49      22.841  60.545  27.976  1.00 37.79           O  
ATOM    266  CB  SER    49      21.474  58.250  29.669  1.00 37.19           C  
ATOM    267  OG  SER    49      20.872  57.441  28.663  1.00 35.06           O  
ATOM    268  N   GLY    50      20.835  60.174  27.079  1.00 38.39           N  
ATOM    269  CA  GLY    50      21.214  60.622  25.742  1.00 38.15           C  
ATOM    270  C   GLY    50      21.913  59.521  24.969  1.00 36.98           C  
ATOM    271  O   GLY    50      22.166  59.670  23.775  1.00 37.41           O  
ATOM    272  N   TYR    51      22.211  58.412  25.651  1.00 35.98           N  
ATOM    273  CA  TYR    51      22.733  57.203  25.004  1.00 34.74           C  
ATOM    274  C   TYR    51      21.698  56.630  24.013  1.00 34.55           C  
ATOM    275  O   TYR    51      20.453  56.775  24.230  1.00 35.08           O  
ATOM    276  CB  TYR    51      23.047  56.109  26.039  1.00 33.87           C  
ATOM    277  CG  TYR    51      24.321  56.276  26.852  1.00 33.36           C  
ATOM    278  CD1 TYR    51      25.393  55.409  26.676  1.00 32.99           C  
ATOM    279  CD2 TYR    51      24.442  57.298  27.780  1.00 33.00           C  
ATOM    280  CE1 TYR    51      26.558  55.551  27.429  1.00 34.11           C  
ATOM    281  CE2 TYR    51      25.600  57.456  28.550  1.00 35.12           C  
ATOM    282  CZ  TYR    51      26.653  56.575  28.352  1.00 34.84           C  
ATOM    283  OH  TYR    51      27.786  56.715  29.074  1.00 32.74           O  
ATOM    284  N   PRO    52      22.191  55.951  22.950  1.00 34.99           N  
ATOM    285  CA  PRO    52      21.241  55.231  22.109  1.00 34.67           C  
ATOM    286  C   PRO    52      20.776  53.982  22.843  1.00 35.35           C  
ATOM    287  O   PRO    52      21.419  53.563  23.835  1.00 34.36           O  
ATOM    288  CB  PRO    52      22.052  54.874  20.842  1.00 35.16           C  
ATOM    289  CG  PRO    52      23.495  54.940  21.259  1.00 34.77           C  
ATOM    290  CD  PRO    52      23.602  55.799  22.497  1.00 34.82           C  
ATOM    291  N   TYR    53      19.673  53.403  22.378  1.00 35.86           N  
ATOM    292  CA  TYR    53      19.173  52.180  22.965  1.00 36.96           C  
ATOM    293  C   TYR    53      18.667  51.328  21.811  1.00 36.80           C  
ATOM    294  O   TYR    53      17.880  51.791  21.003  1.00 37.91           O  
ATOM    295  CB  TYR    53      18.040  52.462  24.003  1.00 36.72           C  
ATOM    296  CG  TYR    53      17.422  51.187  24.528  1.00 38.05           C  
ATOM    297  CD1 TYR    53      17.975  50.523  25.627  1.00 38.59           C  
ATOM    298  CD2 TYR    53      16.305  50.606  23.893  1.00 37.83           C  
ATOM    299  CE1 TYR    53      17.424  49.341  26.105  1.00 39.91           C  
ATOM    300  CE2 TYR    53      15.747  49.416  24.370  1.00 39.19           C  
ATOM    301  CZ  TYR    53      16.310  48.792  25.458  1.00 38.48           C  
ATOM    302  OH  TYR    53      15.774  47.610  25.907  1.00 40.55           O  
ATOM    303  N   THR    54      19.131  50.080  21.734  1.00 37.35           N  
ATOM    304  CA  THR    54      18.820  49.210  20.616  1.00 36.80           C  
ATOM    305  C   THR    54      17.924  48.044  20.993  1.00 37.74           C  
ATOM    306  O   THR    54      17.930  47.569  22.152  1.00 37.88           O  
ATOM    307  CB  THR    54      20.095  48.663  19.947  1.00 37.33           C  
ATOM    308  OG1 THR    54      20.944  48.083  20.945  1.00 36.66           O  
ATOM    309  CG2 THR    54      20.831  49.750  19.249  1.00 37.47           C  
ATOM    310  N   THR    55      17.168  47.563  20.005  1.00 37.99           N  
ATOM    311  CA  THR    55      16.482  46.258  20.101  1.00 38.74           C  
ATOM    312  C   THR    55      16.468  45.581  18.733  1.00 38.58           C  
ATOM    313  O   THR    55      16.991  46.145  17.767  1.00 38.75           O  
ATOM    314  CB  THR    55      15.031  46.362  20.760  1.00 39.15           C  
ATOM    315  OG1 THR    55      14.547  45.043  21.053  1.00 42.34           O  
ATOM    316  CG2 THR    55      14.021  47.094  19.861  1.00 37.54           C  
ATOM    317  N   ALA    56      15.919  44.370  18.666  1.00 37.63           N  
ATOM    318  CA  ALA    56      15.601  43.697  17.415  1.00 38.20           C  
ATOM    319  C   ALA    56      14.083  43.590  17.259  1.00 38.64           C  
ATOM    320  O   ALA    56      13.374  43.290  18.226  1.00 38.50           O  
ATOM    321  CB  ALA    56      16.243  42.301  17.344  1.00 37.34           C  
ATOM    322  N   THR    57      13.593  43.808  16.043  1.00 38.00           N  
ATOM    323  CA  THR    57      12.144  43.750  15.804  1.00 39.69           C  
ATOM    324  C   THR    57      11.844  43.200  14.405  1.00 40.17           C  
ATOM    325  O   THR    57      12.767  43.030  13.611  1.00 39.47           O  
ATOM    326  CB  THR    57      11.479  45.144  16.054  1.00 39.51           C  
ATOM    327  OG1 THR    57      10.075  44.982  16.284  1.00 42.44           O  
ATOM    328  CG2 THR    57      11.769  46.175  14.922  1.00 37.64           C  
ATOM    329  N   ASN    58      10.569  42.905  14.141  1.00 39.45           N  
ATOM    330  CA  ASN    58      10.140  42.384  12.852  1.00 40.47           C  
ATOM    331  C   ASN    58       9.653  43.550  11.984  1.00 39.86           C  
ATOM    332  O   ASN    58       8.995  44.471  12.473  1.00 39.32           O  
ATOM    333  CB  ASN    58       8.964  41.419  13.043  1.00 39.87           C  
ATOM    334  CG  ASN    58       9.261  40.264  13.997  1.00 42.71           C  
ATOM    335  OD1 ASN    58      10.325  39.625  13.945  1.00 43.20           O  
ATOM    336  ND2 ASN    58       8.253  39.910  14.811  1.00 41.63           N  
ATOM    337  N   ILE    59       9.872  43.453  10.689  1.00 40.97           N  
ATOM    338  CA  ILE    59       9.529  44.518   9.723  1.00 41.64           C  
ATOM    339  C   ILE    59       8.358  44.133   8.821  1.00 42.78           C  
ATOM    340  O   ILE    59       8.394  43.067   8.117  1.00 41.24           O  
ATOM    341  CB  ILE    59      10.792  44.815   8.837  1.00 41.35           C  
ATOM    342  CG1 ILE    59      11.835  45.573   9.675  1.00 42.44           C  
ATOM    343  CG2 ILE    59      10.454  45.666   7.603  1.00 44.65           C  
ATOM    344  CD1 ILE    59      11.346  46.945  10.221  1.00 39.10           C  
ATOM    345  N   GLY    60       7.314  44.975   8.847  1.00 43.54           N  
ATOM    346  CA  GLY    60       6.265  44.917   7.809  1.00 43.52           C  
ATOM    347  C   GLY    60       6.563  45.946   6.702  1.00 43.16           C  
ATOM    348  O   GLY    60       7.319  46.877   6.917  1.00 41.80           O  
ATOM    349  N   ILE    61       6.013  45.756   5.504  1.00 42.96           N  
ATOM    350  CA  ILE    61       6.196  46.748   4.436  1.00 44.08           C  
ATOM    351  C   ILE    61       4.826  47.088   3.847  1.00 43.86           C  
ATOM    352  O   ILE    61       4.039  46.184   3.546  1.00 45.44           O  
ATOM    353  CB  ILE    61       7.164  46.288   3.289  1.00 45.00           C  
ATOM    354  CG1 ILE    61       8.525  45.853   3.795  1.00 47.28           C  
ATOM    355  CG2 ILE    61       7.534  47.453   2.427  1.00 44.58           C  
ATOM    356  CD1 ILE    61       9.499  47.050   4.107  1.00 51.63           C  
ATOM    357  N   GLU    62       4.548  48.376   3.660  1.00 41.87           N  
ATOM    358  CA  GLU    62       3.316  48.797   3.016  1.00 41.07           C  
ATOM    359  C   GLU    62       3.499  48.862   1.468  1.00 41.15           C  
ATOM    360  O   GLU    62       4.639  48.887   0.990  1.00 41.34           O  
ATOM    361  CB  GLU    62       2.863  50.132   3.623  1.00 39.56           C  
ATOM    362  CG  GLU    62       2.863  50.081   5.181  1.00 39.44           C  
ATOM    363  CD  GLU    62       2.347  51.371   5.819  1.00 42.98           C  
ATOM    364  OE1 GLU    62       1.600  51.268   6.823  1.00 43.58           O  
ATOM    365  OE2 GLU    62       2.685  52.470   5.299  1.00 39.51           O  
ATOM    366  N   PRO    63       2.390  48.847   0.695  1.00 40.53           N  
ATOM    367  CA  PRO    63       2.460  48.832  -0.787  1.00 40.41           C  
ATOM    368  C   PRO    63       3.454  49.832  -1.394  1.00 39.89           C  
ATOM    369  O   PRO    63       4.140  49.476  -2.317  1.00 40.56           O  
ATOM    370  CB  PRO    63       1.033  49.157  -1.198  1.00 39.57           C  
ATOM    371  CG  PRO    63       0.213  48.552  -0.087  1.00 40.59           C  
ATOM    372  CD  PRO    63       0.995  48.773   1.160  1.00 40.41           C  
ATOM    373  N   ASP    64       3.560  51.048  -0.853  1.00 40.36           N  
ATOM    374  CA  ASP    64       4.530  52.054  -1.340  1.00 40.96           C  
ATOM    375  C   ASP    64       5.987  51.837  -0.852  1.00 41.65           C  
ATOM    376  O   ASP    64       6.844  52.696  -1.079  1.00 43.12           O  
ATOM    377  CB  ASP    64       4.066  53.493  -1.017  1.00 39.69           C  
ATOM    378  CG  ASP    64       4.138  53.809   0.465  1.00 40.09           C  
ATOM    379  OD1 ASP    64       3.820  54.926   0.865  1.00 40.33           O  
ATOM    380  OD2 ASP    64       4.498  52.913   1.241  1.00 36.40           O  
ATOM    381  N   GLY    65       6.228  50.735  -0.150  1.00 42.72           N  
ATOM    382  CA  GLY    65       7.554  50.370   0.345  1.00 44.04           C  
ATOM    383  C   GLY    65       7.891  50.838   1.747  1.00 44.29           C  
ATOM    384  O   GLY    65       8.999  50.566   2.222  1.00 45.96           O  
ATOM    385  N   THR    66       6.937  51.499   2.422  1.00 42.92           N  
ATOM    386  CA  THR    66       7.145  52.061   3.760  1.00 40.94           C  
ATOM    387  C   THR    66       7.233  50.965   4.834  1.00 40.64           C  
ATOM    388  O   THR    66       6.277  50.188   4.993  1.00 39.14           O  
ATOM    389  CB  THR    66       6.021  53.044   4.171  1.00 40.87           C  
ATOM    390  OG1 THR    66       5.955  54.140   3.252  1.00 40.45           O  
ATOM    391  CG2 THR    66       6.306  53.607   5.551  1.00 39.21           C  
ATOM    392  N   PRO    67       8.368  50.910   5.573  1.00 40.41           N  
ATOM    393  CA  PRO    67       8.465  49.942   6.647  1.00 41.38           C  
ATOM    394  C   PRO    67       7.598  50.307   7.843  1.00 41.41           C  
ATOM    395  O   PRO    67       7.431  51.490   8.173  1.00 40.86           O  
ATOM    396  CB  PRO    67       9.946  49.979   7.045  1.00 41.94           C  
ATOM    397  CG  PRO    67      10.638  50.775   6.040  1.00 41.43           C  
ATOM    398  CD  PRO    67       9.595  51.719   5.491  1.00 40.36           C  
ATOM    399  N   PHE    68       7.052  49.277   8.506  1.00 40.81           N  
ATOM    400  CA  PHE    68       6.285  49.530   9.723  1.00 39.59           C  
ATOM    401  C   PHE    68       6.606  48.413  10.691  1.00 39.37           C  
ATOM    402  O   PHE    68       7.122  47.356  10.315  1.00 38.92           O  
ATOM    403  CB  PHE    68       4.757  49.696   9.440  1.00 38.61           C  
ATOM    404  CG  PHE    68       4.008  48.388   9.182  1.00 38.40           C  
ATOM    405  CD1 PHE    68       3.373  47.706  10.228  1.00 39.53           C  
ATOM    406  CD2 PHE    68       3.910  47.857   7.890  1.00 37.81           C  
ATOM    407  CE1 PHE    68       2.642  46.505   9.975  1.00 40.30           C  
ATOM    408  CE2 PHE    68       3.216  46.680   7.637  1.00 39.43           C  
ATOM    409  CZ  PHE    68       2.582  45.996   8.692  1.00 40.88           C  
ATOM    410  N   PHE    69       6.294  48.640  11.947  1.00 39.54           N  
ATOM    411  CA  PHE    69       6.642  47.671  12.957  1.00 39.34           C  
ATOM    412  C   PHE    69       5.764  47.887  14.204  1.00 38.68           C  
ATOM    413  O   PHE    69       5.059  48.905  14.332  1.00 38.42           O  
ATOM    414  CB  PHE    69       8.148  47.734  13.285  1.00 39.39           C  
ATOM    415  CG  PHE    69       8.605  49.071  13.808  1.00 40.13           C  
ATOM    416  CD1 PHE    69       8.609  49.334  15.181  1.00 37.66           C  
ATOM    417  CD2 PHE    69       9.055  50.060  12.934  1.00 40.27           C  
ATOM    418  CE1 PHE    69       9.039  50.590  15.678  1.00 40.43           C  
ATOM    419  CE2 PHE    69       9.487  51.301  13.407  1.00 39.29           C  
ATOM    420  CZ  PHE    69       9.483  51.566  14.796  1.00 42.12           C  
ATOM    421  N   PHE    70       5.835  46.889  15.076  1.00 38.05           N  
ATOM    422  CA  PHE    70       5.076  46.866  16.296  0.50 38.37           C  
ATOM    424  C   PHE    70       6.038  46.859  17.464  1.00 38.87           C  
ATOM    425  O   PHE    70       7.149  46.304  17.360  1.00 38.01           O  
ATOM    426  CB  PHE    70       4.186  45.615  16.328  0.50 38.34           C  
ATOM    428  CG  PHE    70       4.063  44.995  17.679  0.50 37.72           C  
ATOM    430  CD1 PHE    70       3.134  45.471  18.599  0.50 36.50           C  
ATOM    432  CD2 PHE    70       4.879  43.917  18.036  0.50 38.31           C  
ATOM    434  CE1 PHE    70       3.023  44.878  19.863  0.50 37.53           C  
ATOM    436  CE2 PHE    70       4.773  43.321  19.307  0.50 36.98           C  
ATOM    438  CZ  PHE    70       3.851  43.807  20.216  0.50 36.69           C  
ATOM    440  N   ALA    71       5.596  47.458  18.571  1.00 38.29           N  
ATOM    441  CA  ALA    71       6.344  47.406  19.823  1.00 38.96           C  
ATOM    442  C   ALA    71       5.331  47.251  20.949  1.00 39.61           C  
ATOM    443  O   ALA    71       4.312  47.936  20.937  1.00 40.47           O  
ATOM    444  CB  ALA    71       7.151  48.660  20.043  1.00 38.39           C  
ATOM    445  N   ALA    72       5.592  46.345  21.892  1.00 39.98           N  
ATOM    446  CA  ALA    72       4.775  46.269  23.119  1.00 41.01           C  
ATOM    447  C   ALA    72       4.906  47.607  23.852  1.00 41.50           C  
ATOM    448  O   ALA    72       6.005  48.142  23.924  1.00 42.57           O  
ATOM    449  CB  ALA    72       5.262  45.138  23.991  1.00 40.44           C  
ATOM    450  N   GLY    73       3.808  48.150  24.386  1.00 41.80           N  
ATOM    451  CA  GLY    73       3.846  49.469  25.049  1.00 41.25           C  
ATOM    452  C   GLY    73       4.707  49.578  26.305  1.00 41.94           C  
ATOM    453  O   GLY    73       5.268  50.647  26.616  1.00 41.43           O  
ATOM    454  N   LEU    74       4.819  48.486  27.054  1.00 41.99           N  
ATOM    455  CA  LEU    74       5.571  48.544  28.315  1.00 43.68           C  
ATOM    456  C   LEU    74       7.093  48.305  28.146  1.00 43.63           C  
ATOM    457  O   LEU    74       7.759  47.837  29.053  1.00 44.67           O  
ATOM    458  CB  LEU    74       4.930  47.605  29.352  1.00 44.01           C  
ATOM    459  CG  LEU    74       3.413  47.749  29.578  1.00 46.05           C  
ATOM    460  CD1 LEU    74       2.965  46.988  30.851  1.00 49.35           C  
ATOM    461  CD2 LEU    74       2.939  49.230  29.653  1.00 48.89           C  
ATOM    462  N   THR    75       7.626  48.623  26.970  1.00 43.11           N  
ATOM    463  CA  THR    75       9.046  48.418  26.701  1.00 42.65           C  
ATOM    464  C   THR    75       9.824  49.744  26.683  1.00 42.24           C  
ATOM    465  O   THR    75       9.263  50.835  26.438  1.00 41.76           O  
ATOM    466  CB  THR    75       9.306  47.632  25.409  1.00 42.39           C  
ATOM    467  OG1 THR    75       8.924  48.421  24.270  1.00 44.12           O  
ATOM    468  CG2 THR    75       8.570  46.277  25.420  1.00 41.79           C  
ATOM    469  N   LEU    76      11.114  49.633  26.971  1.00 40.77           N  
ATOM    470  CA  LEU    76      12.015  50.766  26.924  1.00 41.14           C  
ATOM    471  C   LEU    76      12.007  51.489  25.574  1.00 40.66           C  
ATOM    472  O   LEU    76      11.944  52.711  25.542  1.00 39.81           O  
ATOM    473  CB  LEU    76      13.425  50.295  27.255  1.00 41.59           C  
ATOM    474  CG  LEU    76      14.009  50.414  28.673  1.00 43.88           C  
ATOM    475  CD1 LEU    76      13.137  51.171  29.678  1.00 45.72           C  
ATOM    476  CD2 LEU    76      14.462  49.068  29.235  1.00 45.24           C  
ATOM    477  N   HIS    77      12.082  50.753  24.458  1.00 39.75           N  
ATOM    478  CA  HIS    77      12.104  51.447  23.167  1.00 39.95           C  
ATOM    479  C   HIS    77      10.777  52.175  22.905  1.00 39.38           C  
ATOM    480  O   HIS    77      10.792  53.307  22.464  1.00 40.18           O  
ATOM    481  CB  HIS    77      12.509  50.543  21.992  1.00 39.44           C  
ATOM    482  CG  HIS    77      11.775  49.241  21.944  1.00 39.43           C  
ATOM    483  ND1 HIS    77      11.884  48.284  22.934  1.00 40.59           N  
ATOM    484  CD2 HIS    77      10.954  48.718  21.004  1.00 41.59           C  
ATOM    485  CE1 HIS    77      11.144  47.235  22.614  1.00 38.83           C  
ATOM    486  NE2 HIS    77      10.565  47.473  21.448  1.00 39.75           N  
ATOM    487  N   ALA    78       9.640  51.531  23.189  1.00 39.56           N  
ATOM    488  CA  ALA    78       8.326  52.206  23.113  1.00 38.93           C  
ATOM    489  C   ALA    78       8.338  53.516  23.887  1.00 38.55           C  
ATOM    490  O   ALA    78       7.962  54.567  23.330  1.00 39.14           O  
ATOM    491  CB  ALA    78       7.207  51.312  23.617  1.00 38.80           C  
ATOM    492  N   ARG    79       8.770  53.448  25.163  1.00 37.66           N  
ATOM    493  CA  ARG    79       8.928  54.611  26.013  1.00 37.31           C  
ATOM    494  C   ARG    79       9.798  55.654  25.329  1.00 37.34           C  
ATOM    495  O   ARG    79       9.412  56.836  25.268  1.00 36.32           O  
ATOM    496  CB  ARG    79       9.554  54.227  27.373  1.00 36.74           C  
ATOM    497  CG  ARG    79       9.456  55.287  28.537  1.00 37.11           C  
ATOM    498  CD  ARG    79      10.594  56.342  28.549  1.00 38.08           C  
ATOM    499  NE  ARG    79      11.916  55.725  28.313  1.00 40.43           N  
ATOM    500  CZ  ARG    79      12.646  55.127  29.241  1.00 38.21           C  
ATOM    501  NH1 ARG    79      12.214  55.069  30.506  1.00 37.01           N  
ATOM    502  NH2 ARG    79      13.817  54.592  28.914  1.00 38.84           N  
ATOM    503  N   ASN    80      10.978  55.233  24.861  1.00 37.06           N  
ATOM    504  CA  ASN    80      11.944  56.179  24.276  1.00 38.46           C  
ATOM    505  C   ASN    80      11.301  56.927  23.122  1.00 39.46           C  
ATOM    506  O   ASN    80      11.364  58.170  23.060  1.00 39.42           O  
ATOM    507  CB  ASN    80      13.239  55.484  23.823  1.00 38.83           C  
ATOM    508  CG  ASN    80      14.083  54.995  24.983  1.00 37.97           C  
ATOM    509  OD1 ASN    80      13.876  55.410  26.113  1.00 38.02           O  
ATOM    510  ND2 ASN    80      15.026  54.079  24.712  1.00 33.92           N  
ATOM    511  N   MET    81      10.639  56.167  22.250  1.00 40.14           N  
ATOM    512  CA  MET    81       9.919  56.713  21.108  1.00 42.73           C  
ATOM    513  C   MET    81       8.765  57.675  21.467  1.00 43.11           C  
ATOM    514  O   MET    81       8.520  58.618  20.730  1.00 42.53           O  
ATOM    515  CB  MET    81       9.432  55.580  20.198  1.00 42.61           C  
ATOM    516  CG  MET    81      10.568  54.902  19.431  1.00 43.80           C  
ATOM    517  SD  MET    81       9.974  53.560  18.134  0.90 48.49          SE  
ATOM    518  CE  MET    81       9.395  52.112  19.373  1.00 41.87           C  
ATOM    519  N   GLU    82       8.087  57.458  22.601  1.00 44.27           N  
ATOM    520  CA  GLU    82       7.135  58.466  23.137  1.00 45.85           C  
ATOM    521  C   GLU    82       7.860  59.782  23.394  1.00 45.91           C  
ATOM    522  O   GLU    82       7.403  60.843  22.989  1.00 46.79           O  
ATOM    523  CB  GLU    82       6.489  58.039  24.470  1.00 45.53           C  
ATOM    524  CG  GLU    82       5.217  57.205  24.406  1.00 48.85           C  
ATOM    525  CD  GLU    82       4.247  57.594  23.266  1.00 54.63           C  
ATOM    526  OE1 GLU    82       3.253  58.314  23.531  1.00 55.24           O  
ATOM    527  OE2 GLU    82       4.470  57.147  22.101  1.00 57.39           O  
ATOM    528  N   THR    83       8.992  59.693  24.080  1.00 46.45           N  
ATOM    529  CA  THR    83       9.771  60.867  24.475  1.00 45.76           C  
ATOM    530  C   THR    83      10.447  61.603  23.288  1.00 45.32           C  
ATOM    531  O   THR    83      10.521  62.828  23.305  1.00 45.43           O  
ATOM    532  CB  THR    83      10.795  60.516  25.590  1.00 46.00           C  
ATOM    533  OG1 THR    83      11.720  59.527  25.129  1.00 46.47           O  
ATOM    534  CG2 THR    83      10.084  59.971  26.841  1.00 46.29           C  
ATOM    535  N   ASP    84      10.895  60.857  22.263  1.00 43.62           N  
ATOM    536  CA  ASP    84      11.665  61.391  21.128  1.00 41.98           C  
ATOM    537  C   ASP    84      11.534  60.402  19.962  1.00 41.59           C  
ATOM    538  O   ASP    84      11.974  59.236  20.064  1.00 40.45           O  
ATOM    539  CB  ASP    84      13.139  61.539  21.541  1.00 42.13           C  
ATOM    540  CG  ASP    84      14.009  62.236  20.488  1.00 42.54           C  
ATOM    541  OD1 ASP    84      13.770  62.126  19.266  1.00 43.26           O  
ATOM    542  OD2 ASP    84      14.984  62.892  20.912  1.00 44.27           O  
ATOM    543  N   ALA    85      10.941  60.861  18.856  1.00 39.53           N  
ATOM    544  CA  ALA    85      10.596  59.949  17.752  1.00 38.78           C  
ATOM    545  C   ALA    85      11.753  59.634  16.791  1.00 38.06           C  
ATOM    546  O   ALA    85      11.574  58.840  15.886  1.00 38.40           O  
ATOM    547  CB  ALA    85       9.356  60.477  16.964  1.00 38.66           C  
ATOM    548  N   ARG    86      12.921  60.255  16.968  1.00 37.49           N  
ATOM    549  CA  ARG    86      14.075  59.998  16.101  1.00 37.80           C  
ATOM    550  C   ARG    86      14.598  58.573  16.313  1.00 37.79           C  
ATOM    551  O   ARG    86      14.936  58.172  17.447  1.00 38.77           O  
ATOM    552  CB  ARG    86      15.191  61.015  16.337  1.00 37.29           C  
ATOM    553  CG  ARG    86      14.782  62.423  15.962  1.00 37.81           C  
ATOM    554  CD  ARG    86      15.909  63.377  16.220  1.00 40.31           C  
ATOM    555  NE  ARG    86      16.150  63.542  17.639  1.00 40.47           N  
ATOM    556  CZ  ARG    86      17.144  64.262  18.153  1.00 42.65           C  
ATOM    557  NH1 ARG    86      17.257  64.358  19.461  1.00 40.10           N  
ATOM    558  NH2 ARG    86      18.022  64.881  17.368  1.00 43.73           N  
ATOM    559  N   ILE    87      14.606  57.800  15.230  1.00 38.06           N  
ATOM    560  CA  ILE    87      15.018  56.378  15.256  1.00 36.98           C  
ATOM    561  C   ILE    87      15.927  56.047  14.083  1.00 38.03           C  
ATOM    562  O   ILE    87      16.014  56.818  13.113  1.00 37.74           O  
ATOM    563  CB  ILE    87      13.797  55.385  15.235  1.00 36.88           C  
ATOM    564  CG1 ILE    87      12.957  55.462  13.944  1.00 36.90           C  
ATOM    565  CG2 ILE    87      12.886  55.630  16.470  1.00 36.77           C  
ATOM    566  CD1 ILE    87      12.027  54.186  13.735  1.00 34.81           C  
ATOM    567  N   SER    88      16.604  54.893  14.173  1.00 38.43           N  
ATOM    568  CA  SER    88      17.331  54.328  13.048  1.00 37.90           C  
ATOM    569  C   SER    88      17.026  52.830  12.974  1.00 38.40           C  
ATOM    570  O   SER    88      16.896  52.180  14.008  1.00 38.37           O  
ATOM    571  CB  SER    88      18.842  54.556  13.197  1.00 36.88           C  
ATOM    572  OG  SER    88      19.560  54.036  12.078  1.00 36.15           O  
ATOM    573  N   VAL    89      16.930  52.277  11.760  1.00 38.48           N  
ATOM    574  CA  VAL    89      16.787  50.813  11.601  1.00 38.88           C  
ATOM    575  C   VAL    89      17.830  50.302  10.631  1.00 38.06           C  
ATOM    576  O   VAL    89      18.230  51.035   9.725  1.00 36.88           O  
ATOM    577  CB  VAL    89      15.369  50.373  11.097  1.00 40.20           C  
ATOM    578  CG1 VAL    89      14.302  50.819  12.041  1.00 38.37           C  
ATOM    579  CG2 VAL    89      15.078  50.950   9.696  1.00 40.61           C  
ATOM    580  N   THR    90      18.312  49.087  10.863  1.00 37.53           N  
ATOM    581  CA  THR    90      19.163  48.436   9.884  1.00 37.70           C  
ATOM    582  C   THR    90      18.491  47.149   9.499  1.00 37.66           C  
ATOM    583  O   THR    90      18.180  46.320  10.339  1.00 38.80           O  
ATOM    584  CB  THR    90      20.601  48.220  10.352  1.00 35.79           C  
ATOM    585  OG1 THR    90      21.173  49.505  10.639  1.00 36.06           O  
ATOM    586  CG2 THR    90      21.482  47.492   9.246  1.00 37.44           C  
ATOM    587  N   LEU    91      18.250  47.032   8.200  1.00 38.53           N  
ATOM    588  CA  LEU    91      17.699  45.849   7.614  1.00 39.28           C  
ATOM    589  C   LEU    91      18.794  45.059   6.917  1.00 40.62           C  
ATOM    590  O   LEU    91      19.650  45.631   6.225  1.00 40.09           O  
ATOM    591  CB  LEU    91      16.605  46.249   6.647  1.00 40.01           C  
ATOM    592  CG  LEU    91      15.246  46.573   7.263  1.00 38.97           C  
ATOM    593  CD1 LEU    91      15.310  47.813   8.152  1.00 43.01           C  
ATOM    594  CD2 LEU    91      14.252  46.840   6.101  1.00 40.75           C  
ATOM    595  N   ALA    92      18.781  43.736   7.095  1.00 41.61           N  
ATOM    596  CA  ALA    92      19.736  42.893   6.387  1.00 43.96           C  
ATOM    597  C   ALA    92      19.142  41.498   6.171  1.00 46.03           C  
ATOM    598  O   ALA    92      18.278  41.098   6.966  1.00 47.72           O  
ATOM    599  CB  ALA    92      21.036  42.818   7.155  1.00 42.95           C  
ATOM    600  N   PRO    93      19.572  40.763   5.108  1.00 47.15           N  
ATOM    601  CA  PRO    93      19.204  39.332   5.006  1.00 47.61           C  
ATOM    602  C   PRO    93      19.973  38.543   6.092  1.00 47.80           C  
ATOM    603  O   PRO    93      20.882  37.772   5.765  1.00 47.05           O  
ATOM    604  CB  PRO    93      19.687  38.934   3.596  1.00 47.22           C  
ATOM    605  CG  PRO    93      20.845  39.877   3.317  1.00 47.42           C  
ATOM    606  CD  PRO    93      20.406  41.189   3.950  1.00 47.69           C  
ATOM    607  N   PHE    94      19.635  38.785   7.367  1.00 47.53           N  
ATOM    608  CA  PHE    94      20.393  38.209   8.489  1.00 48.62           C  
ATOM    609  C   PHE    94      20.432  36.678   8.505  1.00 50.08           C  
ATOM    610  O   PHE    94      21.419  36.076   8.964  1.00 51.13           O  
ATOM    611  CB  PHE    94      19.810  38.662   9.811  1.00 48.35           C  
ATOM    612  CG  PHE    94      20.107  40.061  10.144  1.00 48.23           C  
ATOM    613  CD1 PHE    94      21.394  40.456  10.421  1.00 47.44           C  
ATOM    614  CD2 PHE    94      19.080  41.006  10.192  1.00 46.55           C  
ATOM    615  CE1 PHE    94      21.655  41.793  10.741  1.00 49.24           C  
ATOM    616  CE2 PHE    94      19.329  42.325  10.524  1.00 47.35           C  
ATOM    617  CZ  PHE    94      20.607  42.724  10.797  1.00 48.46           C  
ATOM    618  N   GLY    95      19.369  36.036   8.025  1.00 50.07           N  
ATOM    619  CA  GLY    95      19.398  34.572   7.973  1.00 52.05           C  
ATOM    620  C   GLY    95      20.520  34.009   7.112  1.00 52.20           C  
ATOM    621  O   GLY    95      20.907  32.844   7.284  1.00 52.90           O  
ATOM    622  N   LYS    96      21.045  34.824   6.187  1.00 52.00           N  
ATOM    623  CA  LYS    96      21.969  34.329   5.148  1.00 51.83           C  
ATOM    624  C   LYS    96      23.437  34.283   5.579  1.00 51.44           C  
ATOM    625  O   LYS    96      24.319  34.006   4.770  1.00 51.70           O  
ATOM    626  CB  LYS    96      21.802  35.142   3.824  1.00 51.81           C  
ATOM    627  N   GLY    97      23.713  34.551   6.847  1.00 50.94           N  
ATOM    628  CA  GLY    97      25.090  34.414   7.308  1.00 50.33           C  
ATOM    629  C   GLY    97      25.611  35.687   7.922  1.00 49.54           C  
ATOM    630  O   GLY    97      24.831  36.573   8.261  1.00 50.33           O  
ATOM    631  N   ASP    98      26.932  35.782   8.047  1.00 49.05           N  
ATOM    632  CA  ASP    98      27.539  36.781   8.924  1.00 48.11           C  
ATOM    633  C   ASP    98      27.244  38.226   8.526  1.00 47.99           C  
ATOM    634  O   ASP    98      27.201  38.544   7.338  1.00 47.68           O  
ATOM    635  CB  ASP    98      29.033  36.507   9.105  1.00 47.96           C  
ATOM    636  CG  ASP    98      29.289  35.466  10.185  1.00 47.86           C  
ATOM    637  OD1 ASP    98      28.397  35.330  11.066  1.00 49.44           O  
ATOM    638  OD2 ASP    98      30.344  34.796  10.165  1.00 42.64           O  
ATOM    639  N   ALA    99      27.013  39.085   9.526  1.00 47.12           N  
ATOM    640  CA  ALA    99      26.613  40.475   9.280  1.00 47.62           C  
ATOM    641  C   ALA    99      27.544  41.255   8.332  1.00 47.81           C  
ATOM    642  O   ALA    99      27.066  41.994   7.462  1.00 49.11           O  
ATOM    643  CB  ALA    99      26.414  41.247  10.612  1.00 46.67           C  
ATOM    644  N   LEU   100      28.854  41.108   8.500  1.00 47.20           N  
ATOM    645  CA  LEU   100      29.784  41.843   7.668  1.00 47.26           C  
ATOM    646  C   LEU   100      29.881  41.320   6.208  1.00 47.34           C  
ATOM    647  O   LEU   100      30.537  41.933   5.366  1.00 47.80           O  
ATOM    648  CB  LEU   100      31.156  41.957   8.363  1.00 47.63           C  
ATOM    649  CG  LEU   100      31.246  42.793   9.655  1.00 47.37           C  
ATOM    650  CD1 LEU   100      32.698  42.945  10.097  1.00 44.40           C  
ATOM    651  CD2 LEU   100      30.603  44.166   9.523  1.00 47.96           C  
ATOM    652  N   THR   101      29.225  40.196   5.918  1.00 47.25           N  
ATOM    653  CA  THR   101      29.122  39.670   4.543  1.00 47.24           C  
ATOM    654  C   THR   101      27.868  40.174   3.822  1.00 47.24           C  
ATOM    655  O   THR   101      27.753  40.062   2.608  1.00 48.04           O  
ATOM    656  CB  THR   101      29.068  38.093   4.506  1.00 47.64           C  
ATOM    657  OG1 THR   101      27.862  37.639   5.158  1.00 47.49           O  
ATOM    658  CG2 THR   101      30.274  37.470   5.169  1.00 44.40           C  
ATOM    659  N   LEU   102      26.921  40.710   4.562  1.00 47.23           N  
ATOM    660  CA  LEU   102      25.623  41.022   4.011  1.00 47.59           C  
ATOM    661  C   LEU   102      25.497  42.449   3.542  1.00 46.58           C  
ATOM    662  O   LEU   102      26.127  43.302   4.092  1.00 46.32           O  
ATOM    663  CB  LEU   102      24.556  40.797   5.080  1.00 48.18           C  
ATOM    664  CG  LEU   102      24.513  39.508   5.876  1.00 49.29           C  
ATOM    665  CD1 LEU   102      23.450  39.497   6.890  1.00 47.88           C  
ATOM    666  CD2 LEU   102      24.375  38.361   4.974  1.00 48.28           C  
ATOM    667  N   PRO   103      24.634  42.711   2.567  1.00 45.68           N  
ATOM    668  CA  PRO   103      24.248  44.107   2.342  1.00 44.98           C  
ATOM    669  C   PRO   103      23.440  44.570   3.544  1.00 44.51           C  
ATOM    670  O   PRO   103      22.679  43.789   4.116  1.00 45.61           O  
ATOM    671  CB  PRO   103      23.360  44.042   1.099  1.00 45.24           C  
ATOM    672  CG  PRO   103      22.818  42.660   1.098  1.00 46.09           C  
ATOM    673  CD  PRO   103      23.959  41.807   1.626  1.00 45.51           C  
ATOM    674  N   ARG   104      23.642  45.803   3.964  1.00 42.27           N  
ATOM    675  CA  ARG   104      23.009  46.293   5.151  1.00 42.38           C  
ATOM    676  C   ARG   104      22.432  47.658   4.826  1.00 40.76           C  
ATOM    677  O   ARG   104      23.163  48.568   4.419  1.00 40.88           O  
ATOM    678  CB  ARG   104      24.002  46.412   6.307  1.00 42.35           C  
ATOM    679  CG  ARG   104      24.269  45.116   7.027  1.00 45.67           C  
ATOM    680  CD  ARG   104      25.616  44.582   6.761  1.00 47.32           C  
ATOM    681  NE  ARG   104      26.661  45.481   7.210  1.00 49.89           N  
ATOM    682  CZ  ARG   104      27.859  45.565   6.657  1.00 50.47           C  
ATOM    683  NH1 ARG   104      28.731  46.415   7.158  1.00 52.92           N  
ATOM    684  NH2 ARG   104      28.191  44.799   5.609  1.00 54.70           N  
ATOM    685  N   LEU   105      21.116  47.757   4.962  1.00 38.88           N  
ATOM    686  CA  LEU   105      20.420  48.984   4.661  1.00 37.14           C  
ATOM    687  C   LEU   105      20.077  49.715   5.945  1.00 37.01           C  
ATOM    688  O   LEU   105      19.348  49.180   6.791  1.00 36.52           O  
ATOM    689  CB  LEU   105      19.189  48.688   3.787  1.00 37.18           C  
ATOM    690  CG  LEU   105      18.183  49.809   3.601  1.00 37.12           C  
ATOM    691  CD1 LEU   105      18.777  50.834   2.609  1.00 38.71           C  
ATOM    692  CD2 LEU   105      16.883  49.254   3.095  1.00 39.88           C  
ATOM    693  N   THR   106      20.646  50.912   6.115  1.00 36.12           N  
ATOM    694  CA  THR   106      20.308  51.740   7.269  1.00 36.15           C  
ATOM    695  C   THR   106      19.352  52.861   6.858  1.00 36.02           C  
ATOM    696  O   THR   106      19.630  53.603   5.923  1.00 34.58           O  
ATOM    697  CB  THR   106      21.576  52.300   7.981  1.00 36.43           C  
ATOM    698  OG1 THR   106      22.362  51.202   8.439  1.00 37.67           O  
ATOM    699  CG2 THR   106      21.183  53.136   9.188  1.00 35.63           C  
ATOM    700  N   LEU   107      18.220  52.959   7.562  1.00 36.38           N  
ATOM    701  CA  LEU   107      17.226  53.997   7.322  1.00 37.39           C  
ATOM    702  C   LEU   107      17.071  54.808   8.598  1.00 37.59           C  
ATOM    703  O   LEU   107      16.786  54.255   9.658  1.00 38.36           O  
ATOM    704  CB  LEU   107      15.883  53.386   6.890  1.00 37.42           C  
ATOM    705  CG  LEU   107      15.888  52.335   5.754  1.00 38.96           C  
ATOM    706  CD1 LEU   107      14.515  51.683   5.658  1.00 38.73           C  
ATOM    707  CD2 LEU   107      16.225  52.995   4.407  1.00 37.32           C  
ATOM    708  N   VAL   108      17.306  56.117   8.486  1.00 37.38           N  
ATOM    709  CA  VAL   108      17.208  57.028   9.609  1.00 36.50           C  
ATOM    710  C   VAL   108      15.982  57.912   9.428  1.00 36.44           C  
ATOM    711  O   VAL   108      15.771  58.434   8.349  1.00 36.83           O  
ATOM    712  CB  VAL   108      18.506  57.843   9.752  1.00 35.47           C  
ATOM    713  CG1 VAL   108      18.391  58.875  10.868  1.00 35.13           C  
ATOM    714  CG2 VAL   108      19.692  56.899   9.952  1.00 33.05           C  
ATOM    715  N   GLY   109      15.178  58.090  10.478  1.00 37.67           N  
ATOM    716  CA  GLY   109      14.016  58.998  10.380  1.00 37.60           C  
ATOM    717  C   GLY   109      13.194  59.088  11.645  1.00 38.67           C  
ATOM    718  O   GLY   109      13.748  59.065  12.745  1.00 38.44           O  
ATOM    719  N   ARG   110      11.873  59.219  11.496  1.00 39.40           N  
ATOM    720  CA  ARG   110      10.971  59.310  12.660  1.00 39.19           C  
ATOM    721  C   ARG   110       9.996  58.148  12.742  1.00 39.98           C  
ATOM    722  O   ARG   110       9.556  57.623  11.725  1.00 40.59           O  
ATOM    723  CB  ARG   110      10.250  60.665  12.723  1.00 38.94           C  
ATOM    724  CG  ARG   110      11.188  61.811  13.077  1.00 37.80           C  
ATOM    725  CD  ARG   110      10.575  63.184  12.887  1.00 38.81           C  
ATOM    726  NE  ARG   110      11.606  64.173  13.201  1.00 40.29           N  
ATOM    727  CZ  ARG   110      11.942  64.569  14.432  1.00 41.25           C  
ATOM    728  NH1 ARG   110      12.941  65.434  14.584  1.00 40.86           N  
ATOM    729  NH2 ARG   110      11.291  64.117  15.507  1.00 40.51           N  
ATOM    730  N   ALA   111       9.739  57.698  13.974  1.00 39.87           N  
ATOM    731  CA  ALA   111       8.742  56.686  14.255  1.00 39.24           C  
ATOM    732  C   ALA   111       7.410  57.388  14.427  1.00 39.28           C  
ATOM    733  O   ALA   111       7.158  58.004  15.488  1.00 39.27           O  
ATOM    734  CB  ALA   111       9.101  55.963  15.524  1.00 40.42           C  
ATOM    735  N   ASP   112       6.564  57.297  13.400  1.00 37.97           N  
ATOM    736  CA  ASP   112       5.245  57.869  13.413  1.00 37.66           C  
ATOM    737  C   ASP   112       4.263  56.791  13.859  1.00 39.07           C  
ATOM    738  O   ASP   112       4.145  55.730  13.241  1.00 37.57           O  
ATOM    739  CB  ASP   112       4.845  58.330  12.005  1.00 37.47           C  
ATOM    740  CG  ASP   112       5.527  59.613  11.572  1.00 38.12           C  
ATOM    741  OD1 ASP   112       5.787  60.485  12.423  1.00 34.00           O  
ATOM    742  OD2 ASP   112       5.797  59.778  10.356  1.00 37.81           O  
ATOM    743  N   ARG   113       3.500  57.090  14.888  1.00 39.45           N  
ATOM    744  CA  ARG   113       2.459  56.184  15.313  1.00 40.59           C  
ATOM    745  C   ARG   113       1.341  56.051  14.258  1.00 40.91           C  
ATOM    746  O   ARG   113       0.798  57.048  13.762  1.00 40.36           O  
ATOM    747  CB  ARG   113       1.932  56.668  16.654  1.00 42.56           C  
ATOM    748  CG  ARG   113       1.322  55.580  17.451  1.00 46.63           C  
ATOM    749  CD  ARG   113       2.301  54.882  18.378  1.00 48.90           C  
ATOM    750  NE  ARG   113       1.434  54.340  19.405  1.00 53.60           N  
ATOM    751  CZ  ARG   113       1.151  54.953  20.547  1.00 53.42           C  
ATOM    752  NH1 ARG   113       1.738  56.096  20.858  1.00 55.23           N  
ATOM    753  NH2 ARG   113       0.299  54.401  21.390  1.00 54.54           N  
ATOM    754  N   ILE   114       1.048  54.812  13.868  1.00 40.30           N  
ATOM    755  CA  ILE   114      -0.049  54.545  12.963  1.00 40.96           C  
ATOM    756  C   ILE   114      -1.386  54.812  13.695  1.00 41.58           C  
ATOM    757  O   ILE   114      -1.612  54.259  14.774  1.00 42.47           O  
ATOM    758  CB  ILE   114       0.042  53.108  12.411  1.00 40.38           C  
ATOM    759  CG1 ILE   114       1.260  52.984  11.459  1.00 41.25           C  
ATOM    760  CG2 ILE   114      -1.249  52.703  11.686  1.00 39.00           C  
ATOM    761  CD1 ILE   114       1.469  51.610  10.872  1.00 40.00           C  
ATOM    762  N   GLY   115      -2.227  55.688  13.131  1.00 41.83           N  
ATOM    763  CA  GLY   115      -3.554  56.030  13.692  1.00 41.15           C  
ATOM    764  C   GLY   115      -4.538  54.858  13.797  1.00 41.00           C  
ATOM    765  O   GLY   115      -4.438  53.905  13.029  1.00 40.08           O  
ATOM    766  N   PRO   116      -5.480  54.923  14.770  1.00 41.33           N  
ATOM    767  CA  PRO   116      -6.488  53.900  15.110  1.00 41.12           C  
ATOM    768  C   PRO   116      -7.162  53.226  13.897  1.00 41.75           C  
ATOM    769  O   PRO   116      -7.274  51.988  13.861  1.00 40.88           O  
ATOM    770  CB  PRO   116      -7.537  54.687  15.910  1.00 41.97           C  
ATOM    771  CG  PRO   116      -6.830  55.877  16.457  1.00 41.54           C  
ATOM    772  CD  PRO   116      -5.555  56.093  15.673  1.00 41.00           C  
ATOM    773  N   ASP   117      -7.599  54.026  12.918  1.00 41.48           N  
ATOM    774  CA  ASP   117      -8.340  53.487  11.759  1.00 42.14           C  
ATOM    775  C   ASP   117      -7.572  52.469  10.922  1.00 41.56           C  
ATOM    776  O   ASP   117      -8.163  51.581  10.314  1.00 40.67           O  
ATOM    777  CB  ASP   117      -8.893  54.602  10.847  1.00 42.62           C  
ATOM    778  CG  ASP   117      -9.916  55.509  11.548  1.00 44.68           C  
ATOM    779  OD1 ASP   117     -10.339  56.488  10.904  1.00 47.01           O  
ATOM    780  OD2 ASP   117     -10.294  55.273  12.721  1.00 46.41           O  
ATOM    781  N   GLU   118      -6.247  52.616  10.907  1.00 42.25           N  
ATOM    782  CA  GLU   118      -5.363  51.789  10.115  1.00 42.48           C  
ATOM    783  C   GLU   118      -4.801  50.593  10.880  1.00 41.49           C  
ATOM    784  O   GLU   118      -4.125  49.758  10.287  1.00 40.69           O  
ATOM    785  CB  GLU   118      -4.195  52.638   9.616  1.00 43.11           C  
ATOM    786  CG  GLU   118      -4.617  53.969   8.963  1.00 45.99           C  
ATOM    787  CD  GLU   118      -3.407  54.741   8.501  1.00 51.55           C  
ATOM    788  OE1 GLU   118      -2.791  54.297   7.508  1.00 53.87           O  
ATOM    789  OE2 GLU   118      -3.024  55.742   9.151  1.00 51.97           O  
ATOM    790  N   VAL   119      -5.055  50.470  12.180  1.00 40.47           N  
ATOM    791  CA  VAL   119      -4.452  49.289  12.818  1.00 39.77           C  
ATOM    792  C   VAL   119      -4.970  47.927  12.305  1.00 38.62           C  
ATOM    793  O   VAL   119      -4.153  47.050  12.063  1.00 37.65           O  
ATOM    794  CB  VAL   119      -4.130  49.368  14.343  1.00 39.16           C  
ATOM    795  CG1 VAL   119      -3.759  50.786  14.742  1.00 39.45           C  
ATOM    796  CG2 VAL   119      -5.185  48.829  15.167  1.00 41.43           C  
ATOM    797  N   PRO   120      -6.304  47.757  12.134  1.00 38.16           N  
ATOM    798  CA  PRO   120      -6.766  46.493  11.532  1.00 37.43           C  
ATOM    799  C   PRO   120      -6.020  46.047  10.227  1.00 37.74           C  
ATOM    800  O   PRO   120      -5.633  44.876  10.099  1.00 36.09           O  
ATOM    801  CB  PRO   120      -8.245  46.752  11.284  1.00 37.07           C  
ATOM    802  CG  PRO   120      -8.634  47.730  12.397  1.00 38.18           C  
ATOM    803  CD  PRO   120      -7.440  48.628  12.532  1.00 37.57           C  
ATOM    804  N   LEU   121      -5.823  46.977   9.301  1.00 37.13           N  
ATOM    805  CA  LEU   121      -5.069  46.685   8.080  1.00 38.71           C  
ATOM    806  C   LEU   121      -3.622  46.312   8.376  1.00 37.67           C  
ATOM    807  O   LEU   121      -3.110  45.342   7.819  1.00 37.67           O  
ATOM    808  CB  LEU   121      -5.126  47.883   7.139  1.00 38.61           C  
ATOM    809  CG  LEU   121      -4.512  47.752   5.759  1.00 39.30           C  
ATOM    810  CD1 LEU   121      -5.110  46.579   4.936  1.00 35.77           C  
ATOM    811  CD2 LEU   121      -4.764  49.121   5.140  1.00 41.31           C  
ATOM    812  N   ALA   122      -2.980  47.061   9.274  1.00 36.98           N  
ATOM    813  CA  ALA   122      -1.574  46.854   9.582  1.00 36.59           C  
ATOM    814  C   ALA   122      -1.386  45.497  10.265  1.00 37.61           C  
ATOM    815  O   ALA   122      -0.397  44.789  10.033  1.00 36.60           O  
ATOM    816  CB  ALA   122      -1.034  48.017  10.459  1.00 37.41           C  
ATOM    817  N   ILE   123      -2.358  45.125  11.089  1.00 37.52           N  
ATOM    818  CA  ILE   123      -2.385  43.802  11.748  1.00 38.61           C  
ATOM    819  C   ILE   123      -2.406  42.675  10.741  1.00 37.17           C  
ATOM    820  O   ILE   123      -1.649  41.710  10.838  1.00 37.42           O  
ATOM    821  CB  ILE   123      -3.657  43.639  12.672  1.00 39.07           C  
ATOM    822  CG1 ILE   123      -3.511  44.499  13.927  1.00 41.23           C  
ATOM    823  CG2 ILE   123      -3.890  42.180  13.098  1.00 40.52           C  
ATOM    824  CD1 ILE   123      -2.270  44.198  14.646  1.00 45.57           C  
ATOM    825  N   ALA   124      -3.313  42.752   9.795  1.00 36.81           N  
ATOM    826  CA  ALA   124      -3.427  41.659   8.857  1.00 37.23           C  
ATOM    827  C   ALA   124      -2.128  41.553   8.001  1.00 37.64           C  
ATOM    828  O   ALA   124      -1.590  40.452   7.800  1.00 36.63           O  
ATOM    829  CB  ALA   124      -4.654  41.830   7.999  1.00 37.00           C  
ATOM    830  N   ARG   125      -1.607  42.702   7.579  1.00 37.64           N  
ATOM    831  CA  ARG   125      -0.338  42.736   6.830  1.00 38.74           C  
ATOM    832  C   ARG   125       0.839  42.139   7.607  1.00 39.32           C  
ATOM    833  O   ARG   125       1.660  41.394   7.056  1.00 39.10           O  
ATOM    834  CB  ARG   125       0.003  44.157   6.428  1.00 39.12           C  
ATOM    835  CG  ARG   125      -0.760  44.677   5.279  1.00 39.31           C  
ATOM    836  CD  ARG   125      -0.540  46.186   5.178  1.00 42.21           C  
ATOM    837  NE  ARG   125      -1.251  46.747   4.033  1.00 42.02           N  
ATOM    838  CZ  ARG   125      -1.330  48.041   3.735  1.00 44.09           C  
ATOM    839  NH1 ARG   125      -0.787  48.966   4.539  1.00 42.23           N  
ATOM    840  NH2 ARG   125      -1.989  48.402   2.627  1.00 43.74           N  
ATOM    841  N   TYR   126       0.913  42.455   8.901  1.00 38.91           N  
ATOM    842  CA  TYR   126       1.965  41.957   9.741  1.00 38.50           C  
ATOM    843  C   TYR   126       1.883  40.445  10.004  1.00 38.28           C  
ATOM    844  O   TYR   126       2.888  39.738   9.921  1.00 37.03           O  
ATOM    845  CB  TYR   126       1.882  42.701  11.070  1.00 38.18           C  
ATOM    846  CG  TYR   126       3.073  42.563  11.972  1.00 38.12           C  
ATOM    847  CD1 TYR   126       4.130  43.481  11.909  1.00 38.79           C  
ATOM    848  CD2 TYR   126       3.099  41.592  12.959  1.00 38.98           C  
ATOM    849  CE1 TYR   126       5.217  43.383  12.779  1.00 38.36           C  
ATOM    850  CE2 TYR   126       4.154  41.486  13.840  1.00 39.29           C  
ATOM    851  CZ  TYR   126       5.211  42.397  13.757  1.00 39.80           C  
ATOM    852  OH  TYR   126       6.241  42.303  14.671  1.00 40.32           O  
ATOM    853  N   ILE   127       0.680  39.970  10.361  1.00 38.68           N  
ATOM    854  CA  ILE   127       0.370  38.560  10.561  1.00 38.24           C  
ATOM    855  C   ILE   127       0.751  37.693   9.356  1.00 38.71           C  
ATOM    856  O   ILE   127       1.212  36.567   9.513  1.00 37.24           O  
ATOM    857  CB  ILE   127      -1.169  38.356  10.836  1.00 39.14           C  
ATOM    858  CG1 ILE   127      -1.566  38.755  12.282  1.00 39.78           C  
ATOM    859  CG2 ILE   127      -1.614  36.931  10.590  1.00 38.81           C  
ATOM    860  CD1 ILE   127      -0.651  38.299  13.287  1.00 41.39           C  
ATOM    861  N   ALA   128       0.536  38.247   8.170  1.00 38.28           N  
ATOM    862  CA  ALA   128       0.881  37.603   6.892  1.00 39.64           C  
ATOM    863  C   ALA   128       2.362  37.196   6.864  1.00 39.77           C  
ATOM    864  O   ALA   128       2.692  36.160   6.326  1.00 40.73           O  
ATOM    865  CB  ALA   128       0.538  38.544   5.716  1.00 37.72           C  
ATOM    866  N   ARG   129       3.239  37.977   7.501  1.00 39.93           N  
ATOM    867  CA  ARG   129       4.663  37.665   7.535  1.00 40.44           C  
ATOM    868  C   ARG   129       5.092  36.935   8.789  1.00 41.02           C  
ATOM    869  O   ARG   129       6.078  36.186   8.762  1.00 41.36           O  
ATOM    870  CB  ARG   129       5.504  38.953   7.385  1.00 40.36           C  
ATOM    871  CG  ARG   129       5.631  39.460   6.006  1.00 40.68           C  
ATOM    872  CD  ARG   129       6.516  40.731   6.028  1.00 42.98           C  
ATOM    873  NE  ARG   129       7.005  41.042   4.703  1.00 42.54           N  
ATOM    874  CZ  ARG   129       8.005  41.881   4.428  1.00 40.53           C  
ATOM    875  NH1 ARG   129       8.668  42.496   5.400  1.00 35.92           N  
ATOM    876  NH2 ARG   129       8.369  42.072   3.162  1.00 40.85           N  
ATOM    877  N   TYR   130       4.355  37.171   9.879  1.00 40.43           N  
ATOM    878  CA  TYR   130       4.744  36.787  11.237  1.00 40.69           C  
ATOM    879  C   TYR   130       3.545  36.101  11.899  1.00 40.82           C  
ATOM    880  O   TYR   130       2.832  36.721  12.718  1.00 39.21           O  
ATOM    881  CB  TYR   130       5.205  38.026  12.053  1.00 40.55           C  
ATOM    882  CG  TYR   130       6.263  38.783  11.311  1.00 40.43           C  
ATOM    883  CD1 TYR   130       7.511  38.180  11.078  1.00 41.13           C  
ATOM    884  CD2 TYR   130       6.016  40.050  10.782  1.00 36.37           C  
ATOM    885  CE1 TYR   130       8.468  38.794  10.335  1.00 42.15           C  
ATOM    886  CE2 TYR   130       6.996  40.693  10.025  1.00 37.26           C  
ATOM    887  CZ  TYR   130       8.215  40.051   9.809  1.00 39.60           C  
ATOM    888  OH  TYR   130       9.191  40.643   9.072  1.00 41.60           O  
ATOM    889  N   PRO   131       3.306  34.817  11.540  1.00 42.16           N  
ATOM    890  CA  PRO   131       2.096  34.165  12.065  1.00 42.41           C  
ATOM    891  C   PRO   131       2.062  34.024  13.586  1.00 43.43           C  
ATOM    892  O   PRO   131       0.988  33.896  14.156  1.00 43.70           O  
ATOM    893  CB  PRO   131       2.077  32.794  11.349  1.00 42.87           C  
ATOM    894  CG  PRO   131       3.453  32.545  10.957  1.00 42.32           C  
ATOM    895  CD  PRO   131       4.065  33.913  10.654  1.00 41.32           C  
ATOM    896  N   LYS   132       3.210  34.079  14.254  1.00 44.16           N  
ATOM    897  CA  LYS   132       3.206  34.014  15.703  1.00 45.24           C  
ATOM    898  C   LYS   132       2.663  35.298  16.324  1.00 44.82           C  
ATOM    899  O   LYS   132       2.263  35.304  17.487  1.00 43.69           O  
ATOM    900  CB  LYS   132       4.595  33.704  16.260  1.00 45.12           C  
ATOM    901  CG  LYS   132       4.842  32.232  16.432  1.00 47.27           C  
ATOM    902  CD  LYS   132       6.196  31.909  17.119  1.00 48.39           C  
ATOM    903  CE  LYS   132       7.430  32.170  16.226  1.00 52.49           C  
ATOM    904  NZ  LYS   132       7.137  32.521  14.768  1.00 53.17           N  
ATOM    905  N   ALA   133       2.641  36.376  15.540  1.00 44.82           N  
ATOM    906  CA  ALA   133       2.119  37.640  16.033  1.00 45.86           C  
ATOM    907  C   ALA   133       0.639  37.487  16.421  1.00 46.28           C  
ATOM    908  O   ALA   133       0.119  38.284  17.187  1.00 46.88           O  
ATOM    909  CB  ALA   133       2.317  38.750  15.011  1.00 44.40           C  
ATOM    910  N   LYS   134      -0.011  36.451  15.885  1.00 46.67           N  
ATOM    911  CA  LYS   134      -1.416  36.157  16.164  1.00 47.61           C  
ATOM    912  C   LYS   134      -1.651  36.137  17.651  1.00 47.75           C  
ATOM    913  O   LYS   134      -2.757  36.404  18.112  1.00 47.97           O  
ATOM    914  CB  LYS   134      -1.842  34.813  15.552  1.00 47.52           C  
ATOM    915  CG  LYS   134      -1.859  34.804  14.020  1.00 47.47           C  
ATOM    916  CD  LYS   134      -2.287  33.432  13.483  1.00 49.07           C  
ATOM    917  CE  LYS   134      -1.445  32.992  12.281  1.00 51.18           C  
ATOM    918  NZ  LYS   134      -1.843  33.616  10.967  1.00 49.86           N  
ATOM    919  N   LEU   135      -0.579  35.853  18.390  1.00 48.06           N  
ATOM    920  CA  LEU   135      -0.617  35.721  19.826  1.00 47.97           C  
ATOM    921  C   LEU   135      -0.192  37.001  20.519  1.00 47.15           C  
ATOM    922  O   LEU   135      -0.969  37.551  21.300  1.00 46.82           O  
ATOM    923  CB  LEU   135       0.261  34.537  20.278  1.00 48.70           C  
ATOM    924  CG  LEU   135       0.035  33.874  21.647  1.00 50.11           C  
ATOM    925  CD1 LEU   135       0.774  34.634  22.791  1.00 50.84           C  
ATOM    926  CD2 LEU   135      -1.474  33.663  21.956  1.00 50.85           C  
ATOM    927  N   TYR   136       1.031  37.462  20.260  1.00 46.11           N  
ATOM    928  CA  TYR   136       1.581  38.606  21.013  1.00 45.99           C  
ATOM    929  C   TYR   136       1.034  39.993  20.657  1.00 46.23           C  
ATOM    930  O   TYR   136       1.253  40.941  21.400  1.00 47.04           O  
ATOM    931  CB  TYR   136       3.109  38.615  21.041  1.00 45.39           C  
ATOM    932  CG  TYR   136       3.790  38.700  19.693  1.00 46.29           C  
ATOM    933  CD1 TYR   136       3.885  39.920  19.003  1.00 46.59           C  
ATOM    934  CD2 TYR   136       4.382  37.560  19.114  1.00 47.90           C  
ATOM    935  CE1 TYR   136       4.510  40.011  17.768  1.00 45.30           C  
ATOM    936  CE2 TYR   136       5.021  37.640  17.878  1.00 45.08           C  
ATOM    937  CZ  TYR   136       5.087  38.863  17.214  1.00 45.87           C  
ATOM    938  OH  TYR   136       5.715  38.938  15.992  1.00 41.33           O  
ATOM    939  N   LEU   137       0.359  40.122  19.511  1.00 46.65           N  
ATOM    940  CA  LEU   137      -0.418  41.332  19.204  1.00 46.13           C  
ATOM    941  C   LEU   137      -1.735  41.311  20.000  1.00 46.60           C  
ATOM    942  O   LEU   137      -2.290  42.359  20.306  1.00 46.98           O  
ATOM    943  CB  LEU   137      -0.713  41.459  17.704  1.00 45.65           C  
ATOM    944  CG  LEU   137       0.437  41.531  16.695  1.00 44.77           C  
ATOM    945  CD1 LEU   137      -0.089  41.595  15.239  1.00 43.62           C  
ATOM    946  CD2 LEU   137       1.283  42.731  17.005  1.00 44.94           C  
ATOM    947  N   SER   138      -2.232  40.115  20.331  1.00 46.62           N  
ATOM    948  CA  SER   138      -3.452  39.978  21.138  1.00 46.51           C  
ATOM    949  C   SER   138      -3.169  40.269  22.616  1.00 46.44           C  
ATOM    950  O   SER   138      -4.035  40.077  23.474  1.00 45.70           O  
ATOM    951  CB  SER   138      -4.083  38.578  20.979  1.00 46.73           C  
ATOM    952  OG  SER   138      -4.835  38.461  19.779  1.00 45.66           O  
ATOM    953  N   LEU   139      -1.955  40.729  22.906  1.00 46.67           N  
ATOM    954  CA  LEU   139      -1.587  41.082  24.277  1.00 47.11           C  
ATOM    955  C   LEU   139      -1.803  42.577  24.520  1.00 47.01           C  
ATOM    956  O   LEU   139      -1.718  43.355  23.579  1.00 47.26           O  
ATOM    957  CB  LEU   139      -0.132  40.673  24.561  1.00 47.38           C  
ATOM    958  CG  LEU   139       0.075  39.157  24.775  1.00 48.22           C  
ATOM    959  CD1 LEU   139       1.557  38.734  24.649  1.00 48.29           C  
ATOM    960  CD2 LEU   139      -0.538  38.697  26.101  1.00 46.80           C  
ATOM    961  N   PRO   140      -2.098  42.982  25.772  1.00 46.85           N  
ATOM    962  CA  PRO   140      -2.243  44.405  26.123  1.00 47.11           C  
ATOM    963  C   PRO   140      -1.185  45.383  25.554  1.00 46.98           C  
ATOM    964  O   PRO   140      -0.054  44.997  25.304  1.00 46.95           O  
ATOM    965  CB  PRO   140      -2.208  44.384  27.670  1.00 47.08           C  
ATOM    966  CG  PRO   140      -2.900  43.086  27.999  1.00 46.63           C  
ATOM    967  CD  PRO   140      -2.367  42.116  26.942  1.00 47.39           C  
ATOM    968  N   ASP   141      -1.623  46.629  25.332  1.00 47.12           N  
ATOM    969  CA  ASP   141      -0.824  47.794  24.899  1.00 46.88           C  
ATOM    970  C   ASP   141       0.037  47.641  23.642  1.00 45.67           C  
ATOM    971  O   ASP   141       1.088  48.244  23.545  1.00 45.12           O  
ATOM    972  CB  ASP   141      -0.028  48.431  26.058  1.00 47.97           C  
ATOM    973  CG  ASP   141       0.312  49.933  25.794  1.00 51.71           C  
ATOM    974  OD1 ASP   141       0.123  50.416  24.640  1.00 56.09           O  
ATOM    975  OD2 ASP   141       0.765  50.642  26.726  1.00 53.23           O  
ATOM    976  N   THR   142      -0.433  46.872  22.665  1.00 45.38           N  
ATOM    977  CA  THR   142       0.298  46.738  21.399  1.00 44.64           C  
ATOM    978  C   THR   142       0.354  48.133  20.750  1.00 43.67           C  
ATOM    979  O   THR   142      -0.661  48.835  20.706  1.00 42.32           O  
ATOM    980  CB  THR   142      -0.322  45.645  20.432  1.00 45.28           C  
ATOM    981  OG1 THR   142      -1.500  46.129  19.764  1.00 50.55           O  
ATOM    982  CG2 THR   142      -0.691  44.384  21.154  1.00 43.67           C  
ATOM    983  N   ARG   143       1.543  48.544  20.302  1.00 42.84           N  
ATOM    984  CA  ARG   143       1.752  49.844  19.613  1.00 41.55           C  
ATOM    985  C   ARG   143       2.296  49.644  18.197  1.00 41.15           C  
ATOM    986  O   ARG   143       3.172  48.825  17.972  1.00 39.56           O  
ATOM    987  CB  ARG   143       2.693  50.754  20.397  1.00 41.33           C  
ATOM    988  CG  ARG   143       2.105  51.238  21.716  1.00 42.76           C  
ATOM    989  CD  ARG   143       2.837  52.418  22.285  1.00 41.74           C  
ATOM    990  NE  ARG   143       2.324  52.678  23.626  1.00 43.71           N  
ATOM    991  CZ  ARG   143       2.963  53.384  24.552  1.00 44.78           C  
ATOM    992  NH1 ARG   143       4.143  53.932  24.282  1.00 44.95           N  
ATOM    993  NH2 ARG   143       2.417  53.540  25.749  1.00 44.32           N  
ATOM    994  N   LEU   144       1.784  50.424  17.263  1.00 40.42           N  
ATOM    995  CA  LEU   144       2.074  50.247  15.850  1.00 40.95           C  
ATOM    996  C   LEU   144       2.702  51.530  15.277  1.00 40.06           C  
ATOM    997  O   LEU   144       2.163  52.615  15.462  1.00 38.91           O  
ATOM    998  CB  LEU   144       0.751  49.987  15.181  1.00 42.20           C  
ATOM    999  CG  LEU   144       0.619  49.097  13.969  1.00 46.50           C  
ATOM   1000  CD1 LEU   144       1.875  48.287  13.671  1.00 49.12           C  
ATOM   1001  CD2 LEU   144      -0.608  48.216  14.255  1.00 48.62           C  
ATOM   1002  N   TYR   145       3.817  51.406  14.564  1.00 39.79           N  
ATOM   1003  CA  TYR   145       4.558  52.599  14.078  1.00 40.16           C  
ATOM   1004  C   TYR   145       4.959  52.432  12.632  1.00 40.01           C  
ATOM   1005  O   TYR   145       5.267  51.349  12.243  1.00 39.76           O  
ATOM   1006  CB  TYR   145       5.867  52.724  14.824  1.00 39.53           C  
ATOM   1007  CG  TYR   145       5.781  52.715  16.319  1.00 40.63           C  
ATOM   1008  CD1 TYR   145       5.830  53.908  17.048  1.00 39.84           C  
ATOM   1009  CD2 TYR   145       5.749  51.505  17.013  1.00 40.60           C  
ATOM   1010  CE1 TYR   145       5.801  53.895  18.451  1.00 40.06           C  
ATOM   1011  CE2 TYR   145       5.697  51.480  18.355  1.00 39.43           C  
ATOM   1012  CZ  TYR   145       5.730  52.671  19.081  1.00 39.67           C  
ATOM   1013  OH  TYR   145       5.702  52.587  20.428  1.00 42.40           O  
ATOM   1014  N   ARG   146       5.015  53.506  11.843  1.00 39.59           N  
ATOM   1015  CA  ARG   146       5.738  53.386  10.573  1.00 39.78           C  
ATOM   1016  C   ARG   146       6.938  54.325  10.546  1.00 39.11           C  
ATOM   1017  O   ARG   146       6.964  55.378  11.224  1.00 39.10           O  
ATOM   1018  CB  ARG   146       4.811  53.511   9.324  1.00 40.31           C  
ATOM   1019  CG  ARG   146       4.060  54.788   9.265  1.00 39.82           C  
ATOM   1020  CD  ARG   146       3.345  55.018   7.916  1.00 38.92           C  
ATOM   1021  NE  ARG   146       2.211  54.139   7.701  1.00 37.29           N  
ATOM   1022  CZ  ARG   146       0.949  54.414   8.052  1.00 39.59           C  
ATOM   1023  NH1 ARG   146       0.620  55.547   8.670  1.00 36.29           N  
ATOM   1024  NH2 ARG   146       0.002  53.529   7.806  1.00 38.02           N  
ATOM   1025  N   LEU   147       7.953  53.898   9.812  1.00 38.46           N  
ATOM   1026  CA  LEU   147       9.159  54.674   9.672  1.00 39.22           C  
ATOM   1027  C   LEU   147       8.892  55.779   8.668  1.00 39.28           C  
ATOM   1028  O   LEU   147       8.458  55.507   7.541  1.00 40.23           O  
ATOM   1029  CB  LEU   147      10.337  53.786   9.223  1.00 38.32           C  
ATOM   1030  CG  LEU   147      11.633  54.552   8.934  1.00 40.43           C  
ATOM   1031  CD1 LEU   147      12.162  55.301  10.146  1.00 40.13           C  
ATOM   1032  CD2 LEU   147      12.676  53.585   8.383  1.00 39.88           C  
ATOM   1033  N   ARG   148       9.128  57.019   9.093  1.00 38.60           N  
ATOM   1034  CA  ARG   148       9.226  58.123   8.164  1.00 38.77           C  
ATOM   1035  C   ARG   148      10.701  58.279   7.820  1.00 38.33           C  
ATOM   1036  O   ARG   148      11.459  58.805   8.619  1.00 38.32           O  
ATOM   1037  CB  ARG   148       8.725  59.410   8.813  1.00 38.13           C  
ATOM   1038  CG  ARG   148       8.409  60.481   7.803  1.00 37.78           C  
ATOM   1039  CD  ARG   148       8.179  61.861   8.399  1.00 38.22           C  
ATOM   1040  NE  ARG   148       7.600  61.872   9.745  1.00 37.75           N  
ATOM   1041  CZ  ARG   148       7.628  62.927  10.557  1.00 37.04           C  
ATOM   1042  NH1 ARG   148       8.198  64.048  10.163  1.00 39.09           N  
ATOM   1043  NH2 ARG   148       7.088  62.877  11.769  1.00 37.72           N  
ATOM   1044  N   THR   149      11.112  57.813   6.646  1.00 38.59           N  
ATOM   1045  CA  THR   149      12.545  57.748   6.309  1.00 37.96           C  
ATOM   1046  C   THR   149      13.029  59.141   5.922  1.00 38.33           C  
ATOM   1047  O   THR   149      12.405  59.803   5.065  1.00 36.50           O  
ATOM   1048  CB  THR   149      12.806  56.757   5.154  1.00 38.31           C  
ATOM   1049  OG1 THR   149      12.509  55.419   5.604  1.00 41.10           O  
ATOM   1050  CG2 THR   149      14.270  56.801   4.713  1.00 35.97           C  
ATOM   1051  N   GLU   150      14.136  59.582   6.538  1.00 37.61           N  
ATOM   1052  CA  GLU   150      14.712  60.870   6.226  1.00 37.27           C  
ATOM   1053  C   GLU   150      16.117  60.754   5.641  1.00 36.61           C  
ATOM   1054  O   GLU   150      16.620  61.694   5.038  1.00 35.99           O  
ATOM   1055  CB  GLU   150      14.728  61.781   7.469  1.00 37.85           C  
ATOM   1056  CG  GLU   150      13.363  62.026   8.039  1.00 40.67           C  
ATOM   1057  CD  GLU   150      13.392  62.918   9.236  1.00 43.99           C  
ATOM   1058  OE1 GLU   150      13.697  62.446  10.343  1.00 45.92           O  
ATOM   1059  OE2 GLU   150      13.083  64.103   9.075  1.00 47.26           O  
ATOM   1060  N   GLY   151      16.754  59.605   5.811  1.00 36.37           N  
ATOM   1061  CA  GLY   151      18.106  59.438   5.304  1.00 35.42           C  
ATOM   1062  C   GLY   151      18.391  57.979   5.175  1.00 36.25           C  
ATOM   1063  O   GLY   151      17.818  57.157   5.916  1.00 36.80           O  
ATOM   1064  N   VAL   152      19.238  57.639   4.215  1.00 36.10           N  
ATOM   1065  CA  VAL   152      19.430  56.227   3.805  1.00 35.33           C  
ATOM   1066  C   VAL   152      20.918  55.988   3.648  1.00 35.97           C  
ATOM   1067  O   VAL   152      21.619  56.816   3.048  1.00 35.63           O  
ATOM   1068  CB  VAL   152      18.795  55.952   2.411  1.00 34.93           C  
ATOM   1069  CG1 VAL   152      19.039  54.483   1.920  1.00 32.95           C  
ATOM   1070  CG2 VAL   152      17.350  56.272   2.423  1.00 35.09           C  
ATOM   1071  N   GLN   153      21.393  54.850   4.145  1.00 36.44           N  
ATOM   1072  CA  GLN   153      22.734  54.355   3.769  1.00 37.39           C  
ATOM   1073  C   GLN   153      22.655  52.879   3.356  1.00 36.80           C  
ATOM   1074  O   GLN   153      22.052  52.100   4.058  1.00 36.40           O  
ATOM   1075  CB  GLN   153      23.665  54.515   4.963  1.00 37.50           C  
ATOM   1076  CG  GLN   153      25.127  54.524   4.640  1.00 41.65           C  
ATOM   1077  CD  GLN   153      25.556  55.736   3.810  1.00 41.98           C  
ATOM   1078  OE1 GLN   153      24.964  56.831   3.864  1.00 45.79           O  
ATOM   1079  NE2 GLN   153      26.583  55.533   3.041  1.00 42.54           N  
ATOM   1080  N   ILE   154      23.241  52.503   2.226  1.00 37.17           N  
ATOM   1081  CA  ILE   154      23.331  51.090   1.860  1.00 39.21           C  
ATOM   1082  C   ILE   154      24.785  50.640   1.815  1.00 41.79           C  
ATOM   1083  O   ILE   154      25.679  51.367   1.372  1.00 41.41           O  
ATOM   1084  CB  ILE   154      22.601  50.741   0.538  1.00 38.42           C  
ATOM   1085  CG1 ILE   154      22.646  49.226   0.255  1.00 38.22           C  
ATOM   1086  CG2 ILE   154      23.205  51.475  -0.643  1.00 38.65           C  
ATOM   1087  CD1 ILE   154      21.854  48.347   1.229  1.00 39.83           C  
ATOM   1088  N   ASN   155      25.004  49.399   2.225  1.00 44.68           N  
ATOM   1089  CA  ASN   155      26.328  48.960   2.615  1.00 46.88           C  
ATOM   1090  C   ASN   155      26.582  47.483   2.353  1.00 47.70           C  
ATOM   1091  O   ASN   155      25.686  46.663   2.509  1.00 46.80           O  
ATOM   1092  CB  ASN   155      26.426  49.207   4.104  1.00 47.14           C  
ATOM   1093  CG  ASN   155      27.647  49.882   4.462  1.00 50.04           C  
ATOM   1094  OD1 ASN   155      28.705  49.253   4.585  1.00 55.54           O  
ATOM   1095  ND2 ASN   155      27.558  51.195   4.622  1.00 52.46           N  
ATOM   1096  N   GLY   156      27.811  47.151   1.959  1.00 49.84           N  
ATOM   1097  CA  GLY   156      28.226  45.753   1.770  1.00 51.52           C  
ATOM   1098  C   GLY   156      27.617  45.115   0.522  1.00 52.58           C  
ATOM   1099  O   GLY   156      27.855  43.933   0.213  1.00 53.20           O  
ATOM   1100  N   SER   163      26.464  54.270  -1.177  1.00 60.56           N  
ATOM   1101  CA  SER   163      26.432  55.140  -2.358  1.00 60.69           C  
ATOM   1102  C   SER   163      25.807  56.505  -2.030  1.00 60.30           C  
ATOM   1103  O   SER   163      25.996  57.018  -0.913  1.00 60.50           O  
ATOM   1104  CB  SER   163      25.691  54.453  -3.512  1.00 60.82           C  
ATOM   1105  N   ASN   164      25.077  57.098  -2.983  1.00 59.18           N  
ATOM   1106  CA  ASN   164      24.316  58.305  -2.663  1.00 57.87           C  
ATOM   1107  C   ASN   164      22.811  58.245  -2.973  1.00 56.64           C  
ATOM   1108  O   ASN   164      22.310  58.927  -3.882  1.00 56.74           O  
ATOM   1109  CB  ASN   164      24.991  59.557  -3.217  1.00 58.18           C  
ATOM   1110  CG  ASN   164      25.093  60.662  -2.170  1.00 59.61           C  
ATOM   1111  OD1 ASN   164      24.452  60.581  -1.102  1.00 61.55           O  
ATOM   1112  ND2 ASN   164      25.898  61.696  -2.459  1.00 58.37           N  
ATOM   1113  N   ILE   165      22.119  57.431  -2.171  1.00 54.60           N  
ATOM   1114  CA  ILE   165      20.681  57.144  -2.264  1.00 52.78           C  
ATOM   1115  C   ILE   165      19.834  58.029  -1.349  1.00 51.56           C  
ATOM   1116  O   ILE   165      20.213  58.327  -0.218  1.00 51.45           O  
ATOM   1117  CB  ILE   165      20.383  55.679  -1.835  1.00 52.71           C  
ATOM   1118  CG1 ILE   165      21.223  54.685  -2.617  1.00 52.48           C  
ATOM   1119  CG2 ILE   165      18.870  55.346  -1.944  1.00 52.17           C  
ATOM   1120  CD1 ILE   165      21.075  53.276  -2.069  1.00 53.76           C  
ATOM   1121  N   THR   166      18.659  58.387  -1.850  1.00 49.82           N  
ATOM   1122  CA  THR   166      17.685  59.221  -1.167  1.00 47.99           C  
ATOM   1123  C   THR   166      16.460  58.402  -0.707  1.00 46.53           C  
ATOM   1124  O   THR   166      16.163  57.365  -1.305  1.00 45.87           O  
ATOM   1125  CB  THR   166      17.195  60.292  -2.160  1.00 48.47           C  
ATOM   1126  OG1 THR   166      16.247  61.157  -1.526  1.00 50.18           O  
ATOM   1127  CG2 THR   166      16.526  59.641  -3.353  1.00 47.03           C  
ATOM   1128  N   PRO   167      15.736  58.879   0.335  1.00 44.87           N  
ATOM   1129  CA  PRO   167      14.458  58.290   0.720  1.00 43.50           C  
ATOM   1130  C   PRO   167      13.494  58.042  -0.451  1.00 42.73           C  
ATOM   1131  O   PRO   167      12.872  56.980  -0.511  1.00 41.20           O  
ATOM   1132  CB  PRO   167      13.899  59.320   1.701  1.00 43.49           C  
ATOM   1133  CG  PRO   167      15.121  59.813   2.394  1.00 43.85           C  
ATOM   1134  CD  PRO   167      16.106  59.979   1.255  1.00 44.61           C  
ATOM   1135  N   ALA   168      13.394  59.003  -1.376  1.00 41.20           N  
ATOM   1136  CA  ALA   168      12.558  58.884  -2.575  1.00 40.36           C  
ATOM   1137  C   ALA   168      12.945  57.702  -3.447  1.00 40.15           C  
ATOM   1138  O   ALA   168      12.078  57.091  -4.074  1.00 39.71           O  
ATOM   1139  CB  ALA   168      12.623  60.191  -3.420  1.00 39.95           C  
ATOM   1140  N   ASP   169      14.248  57.401  -3.501  1.00 40.01           N  
ATOM   1141  CA  ASP   169      14.760  56.285  -4.307  1.00 40.40           C  
ATOM   1142  C   ASP   169      14.215  54.952  -3.813  1.00 39.36           C  
ATOM   1143  O   ASP   169      14.077  54.007  -4.570  1.00 38.74           O  
ATOM   1144  CB  ASP   169      16.286  56.201  -4.240  1.00 40.55           C  
ATOM   1145  CG  ASP   169      16.984  57.170  -5.175  1.00 44.16           C  
ATOM   1146  OD1 ASP   169      16.370  57.686  -6.141  1.00 46.62           O  
ATOM   1147  OD2 ASP   169      18.177  57.426  -4.917  1.00 46.46           O  
ATOM   1148  N   LEU   170      13.938  54.869  -2.520  1.00 39.88           N  
ATOM   1149  CA  LEU   170      13.470  53.617  -1.971  1.00 40.30           C  
ATOM   1150  C   LEU   170      11.977  53.420  -2.130  1.00 41.43           C  
ATOM   1151  O   LEU   170      11.506  52.272  -2.117  1.00 43.10           O  
ATOM   1152  CB  LEU   170      13.843  53.477  -0.496  1.00 39.86           C  
ATOM   1153  CG  LEU   170      15.310  53.540  -0.134  1.00 41.26           C  
ATOM   1154  CD1 LEU   170      15.403  53.049   1.308  1.00 38.50           C  
ATOM   1155  CD2 LEU   170      16.132  52.668  -1.055  1.00 41.75           C  
ATOM   1156  N   ARG   171      11.220  54.508  -2.225  1.00 41.64           N  
ATOM   1157  CA  ARG   171       9.757  54.400  -2.276  1.00 42.86           C  
ATOM   1158  C   ARG   171       9.224  53.862  -3.570  1.00 41.94           C  
ATOM   1159  O   ARG   171       9.793  54.126  -4.624  1.00 42.66           O  
ATOM   1160  CB  ARG   171       9.090  55.745  -2.037  1.00 44.35           C  
ATOM   1161  CG  ARG   171       8.629  55.926  -0.589  1.00 48.08           C  
ATOM   1162  CD  ARG   171       7.734  57.174  -0.489  1.00 55.26           C  
ATOM   1163  NE  ARG   171       8.159  58.232  -1.413  1.00 59.23           N  
ATOM   1164  CZ  ARG   171       9.087  59.155  -1.153  1.00 60.97           C  
ATOM   1165  NH1 ARG   171       9.718  59.190   0.027  1.00 59.89           N  
ATOM   1166  NH2 ARG   171       9.385  60.056  -2.088  1.00 61.23           N  
ATOM   1167  N   THR   172       8.104  53.136  -3.502  1.00 39.89           N  
ATOM   1168  CA  THR   172       7.400  52.778  -4.733  1.00 37.54           C  
ATOM   1169  C   THR   172       6.310  53.770  -5.091  1.00 36.45           C  
ATOM   1170  O   THR   172       5.388  53.982  -4.324  1.00 35.85           O  
ATOM   1171  CB  THR   172       6.777  51.374  -4.624  1.00 37.27           C  
ATOM   1172  OG1 THR   172       7.811  50.456  -4.280  1.00 36.73           O  
ATOM   1173  CG2 THR   172       6.129  50.979  -5.942  1.00 37.43           C  
ATOM   1174  N   ASP   173       6.386  54.342  -6.290  1.00 35.89           N  
ATOM   1175  CA  ASP   173       5.430  55.349  -6.699  1.00 35.73           C  
ATOM   1176  C   ASP   173       4.100  54.712  -7.127  1.00 35.45           C  
ATOM   1177  O   ASP   173       4.050  53.928  -8.081  1.00 34.18           O  
ATOM   1178  CB  ASP   173       6.040  56.182  -7.820  1.00 36.16           C  
ATOM   1179  CG  ASP   173       5.205  57.399  -8.183  1.00 37.67           C  
ATOM   1180  OD1 ASP   173       4.108  57.608  -7.606  1.00 38.56           O  
ATOM   1181  OD2 ASP   173       5.674  58.164  -9.053  1.00 40.65           O  
ATOM   1182  N   LEU   174       3.020  55.082  -6.432  1.00 35.60           N  
ATOM   1183  CA  LEU   174       1.699  54.491  -6.690  1.00 36.94           C  
ATOM   1184  C   LEU   174       0.820  55.341  -7.622  1.00 37.73           C  
ATOM   1185  O   LEU   174      -0.223  54.871  -8.064  1.00 38.70           O  
ATOM   1186  CB  LEU   174       0.955  54.137  -5.392  1.00 35.87           C  
ATOM   1187  CG  LEU   174       1.652  53.225  -4.335  1.00 37.10           C  
ATOM   1188  CD1 LEU   174       0.739  52.947  -3.138  1.00 42.05           C  
ATOM   1189  CD2 LEU   174       2.199  51.941  -4.887  1.00 34.58           C  
ATOM   1190  N   SER   175       1.250  56.578  -7.903  1.00 39.29           N  
ATOM   1191  CA  SER   175       0.577  57.509  -8.835  1.00 39.41           C  
ATOM   1192  C   SER   175       0.497  56.903 -10.201  1.00 38.81           C  
ATOM   1193  O   SER   175       1.480  56.338 -10.665  1.00 39.39           O  
ATOM   1194  CB  SER   175       1.393  58.781  -8.985  1.00 40.30           C  
ATOM   1195  OG  SER   175       1.749  59.250  -7.720  1.00 44.26           O  
ATOM   1196  N   GLY   176      -0.657  57.005 -10.851  1.00 38.00           N  
ATOM   1197  CA  GLY   176      -0.818  56.431 -12.193  1.00 36.90           C  
ATOM   1198  C   GLY   176      -1.274  54.983 -12.166  1.00 36.94           C  
ATOM   1199  O   GLY   176      -1.785  54.486 -13.161  1.00 36.75           O  
ATOM   1200  N   ALA   177      -1.121  54.326 -11.017  1.00 35.74           N  
ATOM   1201  CA  ALA   177      -1.447  52.891 -10.828  1.00 36.90           C  
ATOM   1202  C   ALA   177      -2.671  52.600  -9.946  1.00 37.11           C  
ATOM   1203  O   ALA   177      -2.825  51.471  -9.488  1.00 35.89           O  
ATOM   1204  CB  ALA   177      -0.241  52.139 -10.254  1.00 34.41           C  
ATOM   1205  N   GLU   178      -3.561  53.581  -9.759  1.00 38.00           N  
ATOM   1206  CA  GLU   178      -4.748  53.361  -8.912  1.00 39.26           C  
ATOM   1207  C   GLU   178      -5.582  52.148  -9.317  1.00 39.46           C  
ATOM   1208  O   GLU   178      -6.096  51.457  -8.448  1.00 39.25           O  
ATOM   1209  CB  GLU   178      -5.639  54.605  -8.793  1.00 40.40           C  
ATOM   1210  CG  GLU   178      -5.522  55.617  -9.915  1.00 43.04           C  
ATOM   1211  CD  GLU   178      -4.197  56.362  -9.892  1.00 44.81           C  
ATOM   1212  OE1 GLU   178      -3.412  56.160 -10.831  1.00 45.64           O  
ATOM   1213  OE2 GLU   178      -3.929  57.129  -8.943  1.00 47.96           O  
ATOM   1214  N   GLU   179      -5.709  51.882 -10.626  1.00 39.61           N  
ATOM   1215  CA  GLU   179      -6.423  50.683 -11.098  1.00 40.08           C  
ATOM   1216  C   GLU   179      -5.830  49.369 -10.565  1.00 39.89           C  
ATOM   1217  O   GLU   179      -6.570  48.512 -10.047  1.00 40.80           O  
ATOM   1218  CB  GLU   179      -6.540  50.655 -12.636  1.00 40.11           C  
ATOM   1219  CG  GLU   179      -6.507  49.214 -13.179  1.00 43.47           C  
ATOM   1220  CD  GLU   179      -7.351  48.973 -14.415  1.00 46.41           C  
ATOM   1221  OE1 GLU   179      -7.880  49.960 -14.980  1.00 50.62           O  
ATOM   1222  OE2 GLU   179      -7.486  47.788 -14.810  1.00 46.82           O  
ATOM   1223  N   LEU   180      -4.510  49.194 -10.691  1.00 39.48           N  
ATOM   1224  CA  LEU   180      -3.811  48.025 -10.098  1.00 39.31           C  
ATOM   1225  C   LEU   180      -4.002  47.941  -8.583  1.00 39.44           C  
ATOM   1226  O   LEU   180      -4.246  46.872  -8.015  1.00 38.38           O  
ATOM   1227  CB  LEU   180      -2.304  48.141 -10.358  1.00 39.30           C  
ATOM   1228  CG  LEU   180      -1.441  47.036  -9.750  1.00 38.15           C  
ATOM   1229  CD1 LEU   180      -1.658  45.717 -10.486  1.00 33.34           C  
ATOM   1230  CD2 LEU   180       0.046  47.422  -9.780  1.00 40.22           C  
ATOM   1231  N   MET   181      -3.847  49.086  -7.932  1.00 38.84           N  
ATOM   1232  CA  MET   181      -3.893  49.139  -6.471  1.00 39.22           C  
ATOM   1233  C   MET   181      -5.316  48.856  -5.978  1.00 39.12           C  
ATOM   1234  O   MET   181      -5.490  48.219  -4.945  1.00 38.93           O  
ATOM   1235  CB  MET   181      -3.352  50.496  -5.973  1.00 39.28           C  
ATOM   1236  CG  MET   181      -1.848  50.761  -6.347  1.00 39.80           C  
ATOM   1237  SD  MET   181      -0.644  49.150  -6.207  0.80 50.03          SE  
ATOM   1238  CE  MET   181      -0.749  48.741  -4.304  1.00 43.54           C  
ATOM   1239  N   ALA   182      -6.324  49.314  -6.730  1.00 38.66           N  
ATOM   1240  CA  ALA   182      -7.714  48.950  -6.445  1.00 38.95           C  
ATOM   1241  C   ALA   182      -7.947  47.426  -6.575  1.00 39.20           C  
ATOM   1242  O   ALA   182      -8.852  46.885  -5.948  1.00 39.76           O  
ATOM   1243  CB  ALA   182      -8.685  49.737  -7.336  1.00 38.72           C  
ATOM   1244  N   ALA   183      -7.113  46.736  -7.337  1.00 39.12           N  
ATOM   1245  CA  ALA   183      -7.270  45.262  -7.542  1.00 39.14           C  
ATOM   1246  C   ALA   183      -6.224  44.408  -6.838  1.00 39.39           C  
ATOM   1247  O   ALA   183      -6.325  43.165  -6.826  1.00 38.95           O  
ATOM   1248  CB  ALA   183      -7.291  44.929  -9.019  1.00 38.99           C  
ATOM   1249  N   ALA   184      -5.240  45.051  -6.210  1.00 39.22           N  
ATOM   1250  CA  ALA   184      -4.066  44.328  -5.747  1.00 38.88           C  
ATOM   1251  C   ALA   184      -4.423  43.297  -4.675  1.00 40.07           C  
ATOM   1252  O   ALA   184      -3.806  42.227  -4.618  1.00 38.32           O  
ATOM   1253  CB  ALA   184      -3.035  45.275  -5.244  1.00 39.29           C  
ATOM   1254  N   GLU   185      -5.384  43.627  -3.809  1.00 40.14           N  
ATOM   1255  CA  GLU   185      -5.765  42.693  -2.732  1.00 42.11           C  
ATOM   1256  C   GLU   185      -6.500  41.436  -3.275  1.00 41.53           C  
ATOM   1257  O   GLU   185      -6.199  40.301  -2.894  1.00 39.45           O  
ATOM   1258  CB  GLU   185      -6.582  43.433  -1.678  1.00 43.22           C  
ATOM   1259  CG  GLU   185      -6.269  43.043  -0.223  1.00 50.16           C  
ATOM   1260  CD  GLU   185      -4.758  43.002   0.076  1.00 57.11           C  
ATOM   1261  OE1 GLU   185      -4.074  44.003  -0.245  1.00 60.08           O  
ATOM   1262  OE2 GLU   185      -4.260  41.967   0.605  1.00 60.58           O  
ATOM   1263  N   SER   186      -7.432  41.647  -4.199  1.00 41.32           N  
ATOM   1264  CA  SER   186      -8.175  40.535  -4.777  1.00 42.46           C  
ATOM   1265  C   SER   186      -7.328  39.745  -5.782  1.00 42.08           C  
ATOM   1266  O   SER   186      -7.512  38.536  -5.919  1.00 41.71           O  
ATOM   1267  CB  SER   186      -9.474  41.018  -5.415  1.00 42.62           C  
ATOM   1268  OG  SER   186      -9.174  41.911  -6.461  1.00 44.62           O  
ATOM   1269  N   GLU   187      -6.398  40.404  -6.467  1.00 41.08           N  
ATOM   1270  CA  GLU   187      -5.419  39.646  -7.263  1.00 40.35           C  
ATOM   1271  C   GLU   187      -4.514  38.748  -6.418  1.00 39.77           C  
ATOM   1272  O   GLU   187      -4.302  37.599  -6.783  1.00 38.95           O  
ATOM   1273  CB  GLU   187      -4.589  40.552  -8.164  1.00 41.17           C  
ATOM   1274  CG  GLU   187      -5.388  41.079  -9.337  1.00 42.00           C  
ATOM   1275  CD  GLU   187      -5.830  39.962 -10.258  1.00 47.88           C  
ATOM   1276  OE1 GLU   187      -5.005  39.505 -11.069  1.00 47.76           O  
ATOM   1277  OE2 GLU   187      -6.990  39.526 -10.166  1.00 47.91           O  
ATOM   1278  N   ALA   188      -4.021  39.248  -5.275  1.00 39.62           N  
ATOM   1279  CA  ALA   188      -3.208  38.428  -4.354  1.00 39.36           C  
ATOM   1280  C   ALA   188      -3.986  37.181  -3.925  1.00 39.81           C  
ATOM   1281  O   ALA   188      -3.456  36.069  -3.961  1.00 39.51           O  
ATOM   1282  CB  ALA   188      -2.779  39.257  -3.093  1.00 38.66           C  
ATOM   1283  N   THR   189      -5.235  37.384  -3.502  1.00 38.54           N  
ATOM   1284  CA  THR   189      -6.118  36.310  -3.087  1.00 39.26           C  
ATOM   1285  C   THR   189      -6.334  35.303  -4.210  1.00 39.11           C  
ATOM   1286  O   THR   189      -6.262  34.090  -3.988  1.00 37.88           O  
ATOM   1287  CB  THR   189      -7.494  36.855  -2.631  1.00 39.24           C  
ATOM   1288  OG1 THR   189      -7.288  37.830  -1.619  1.00 40.65           O  
ATOM   1289  CG2 THR   189      -8.378  35.765  -2.068  1.00 40.14           C  
ATOM   1290  N   ARG   190      -6.581  35.820  -5.393  1.00 39.23           N  
ATOM   1291  CA  ARG   190      -6.801  35.025  -6.570  1.00 40.56           C  
ATOM   1292  C   ARG   190      -5.633  34.123  -6.835  1.00 40.07           C  
ATOM   1293  O   ARG   190      -5.788  32.956  -6.975  1.00 40.14           O  
ATOM   1294  CB  ARG   190      -6.993  35.918  -7.779  1.00 41.29           C  
ATOM   1295  CG  ARG   190      -8.079  35.488  -8.702  1.00 44.05           C  
ATOM   1296  CD  ARG   190      -7.768  35.575 -10.156  1.00 46.79           C  
ATOM   1297  NE  ARG   190      -6.739  36.506 -10.516  1.00 51.37           N  
ATOM   1298  CZ  ARG   190      -5.737  36.223 -11.314  1.00 47.62           C  
ATOM   1299  NH1 ARG   190      -5.642  35.058 -11.853  1.00 49.34           N  
ATOM   1300  NH2 ARG   190      -4.843  37.121 -11.564  1.00 47.10           N  
ATOM   1301  N   LEU   191      -4.467  34.720  -6.926  1.00 38.98           N  
ATOM   1302  CA  LEU   191      -3.217  34.037  -7.202  1.00 38.93           C  
ATOM   1303  C   LEU   191      -2.794  33.073  -6.116  1.00 39.02           C  
ATOM   1304  O   LEU   191      -2.290  31.994  -6.440  1.00 38.62           O  
ATOM   1305  CB  LEU   191      -2.075  35.040  -7.476  1.00 39.93           C  
ATOM   1306  CG  LEU   191      -2.305  35.806  -8.793  1.00 40.44           C  
ATOM   1307  CD1 LEU   191      -1.294  36.936  -8.975  1.00 43.47           C  
ATOM   1308  CD2 LEU   191      -2.281  34.785  -9.946  1.00 44.54           C  
ATOM   1309  N   ASN   192      -2.993  33.452  -4.850  1.00 37.70           N  
ATOM   1310  CA  ASN   192      -2.697  32.567  -3.715  1.00 36.83           C  
ATOM   1311  C   ASN   192      -3.572  31.343  -3.723  1.00 37.14           C  
ATOM   1312  O   ASN   192      -3.220  30.335  -3.109  1.00 38.40           O  
ATOM   1313  CB  ASN   192      -2.803  33.285  -2.328  1.00 36.57           C  
ATOM   1314  CG  ASN   192      -1.633  34.215  -2.047  1.00 36.66           C  
ATOM   1315  OD1 ASN   192      -0.523  33.959  -2.494  1.00 38.01           O  
ATOM   1316  ND2 ASN   192      -1.882  35.340  -1.331  1.00 36.35           N  
ATOM   1317  N   ALA   193      -4.720  31.401  -4.391  1.00 37.30           N  
ATOM   1318  CA  ALA   193      -5.619  30.241  -4.494  1.00 36.33           C  
ATOM   1319  C   ALA   193      -5.196  29.261  -5.595  1.00 35.42           C  
ATOM   1320  O   ALA   193      -5.751  28.146  -5.717  1.00 34.15           O  
ATOM   1321  CB  ALA   193      -7.096  30.722  -4.711  1.00 37.39           C  
ATOM   1322  N   ILE   194      -4.213  29.656  -6.408  1.00 34.06           N  
ATOM   1323  CA  ILE   194      -3.711  28.735  -7.433  1.00 34.61           C  
ATOM   1324  C   ILE   194      -2.594  27.985  -6.706  1.00 33.90           C  
ATOM   1325  O   ILE   194      -1.568  28.560  -6.394  1.00 33.32           O  
ATOM   1326  CB  ILE   194      -3.222  29.454  -8.746  1.00 34.05           C  
ATOM   1327  CG1 ILE   194      -4.363  30.303  -9.345  1.00 35.03           C  
ATOM   1328  CG2 ILE   194      -2.699  28.418  -9.802  1.00 33.21           C  
ATOM   1329  CD1 ILE   194      -3.961  31.173 -10.615  1.00 33.84           C  
ATOM   1330  N   LYS   195      -2.847  26.728  -6.374  1.00 35.20           N  
ATOM   1331  CA  LYS   195      -1.876  25.930  -5.637  1.00 35.60           C  
ATOM   1332  C   LYS   195      -0.505  25.965  -6.346  1.00 36.08           C  
ATOM   1333  O   LYS   195      -0.411  25.714  -7.565  1.00 35.81           O  
ATOM   1334  CB  LYS   195      -2.387  24.514  -5.446  1.00 35.34           C  
ATOM   1335  CG  LYS   195      -1.460  23.600  -4.645  1.00 36.94           C  
ATOM   1336  CD  LYS   195      -2.201  22.407  -4.192  1.00 34.56           C  
ATOM   1337  CE  LYS   195      -1.351  21.448  -3.450  1.00 34.63           C  
ATOM   1338  NZ  LYS   195      -2.210  20.321  -3.050  1.00 30.40           N  
ATOM   1339  N   GLY   196       0.531  26.345  -5.599  1.00 36.12           N  
ATOM   1340  CA  GLY   196       1.898  26.289  -6.099  1.00 35.91           C  
ATOM   1341  C   GLY   196       2.305  27.551  -6.816  1.00 36.65           C  
ATOM   1342  O   GLY   196       3.507  27.740  -7.088  1.00 36.86           O  
ATOM   1343  N   GLU   197       1.344  28.426  -7.125  1.00 36.33           N  
ATOM   1344  CA  GLU   197       1.667  29.605  -7.943  1.00 37.55           C  
ATOM   1345  C   GLU   197       2.560  30.629  -7.204  1.00 38.59           C  
ATOM   1346  O   GLU   197       3.497  31.163  -7.798  1.00 38.33           O  
ATOM   1347  CB  GLU   197       0.419  30.300  -8.468  1.00 37.82           C  
ATOM   1348  CG  GLU   197       0.668  31.114  -9.722  1.00 43.40           C  
ATOM   1349  CD  GLU   197       0.559  30.264 -11.018  1.00 49.01           C  
ATOM   1350  OE1 GLU   197      -0.187  30.686 -11.921  1.00 51.75           O  
ATOM   1351  OE2 GLU   197       1.177  29.164 -11.156  1.00 52.34           O  
ATOM   1352  N   ALA   198       2.291  30.892  -5.920  1.00 38.82           N  
ATOM   1353  CA  ALA   198       3.132  31.857  -5.162  1.00 39.20           C  
ATOM   1354  C   ALA   198       4.581  31.318  -5.068  1.00 40.28           C  
ATOM   1355  O   ALA   198       5.559  32.067  -5.197  1.00 39.92           O  
ATOM   1356  CB  ALA   198       2.568  32.073  -3.828  1.00 39.55           C  
ATOM   1357  N   SER   199       4.705  30.011  -4.877  1.00 39.80           N  
ATOM   1358  CA  SER   199       6.017  29.356  -4.808  1.00 41.18           C  
ATOM   1359  C   SER   199       6.752  29.410  -6.164  1.00 40.92           C  
ATOM   1360  O   SER   199       7.961  29.702  -6.200  1.00 41.81           O  
ATOM   1361  CB  SER   199       5.854  27.933  -4.303  1.00 40.29           C  
ATOM   1362  OG  SER   199       7.118  27.325  -4.118  1.00 44.86           O  
ATOM   1363  N   ARG   200       6.030  29.226  -7.276  1.00 40.52           N  
ATOM   1364  CA  ARG   200       6.615  29.459  -8.615  1.00 40.24           C  
ATOM   1365  C   ARG   200       7.175  30.877  -8.784  1.00 39.77           C  
ATOM   1366  O   ARG   200       8.250  31.065  -9.381  1.00 39.36           O  
ATOM   1367  CB  ARG   200       5.632  29.137  -9.745  1.00 40.01           C  
ATOM   1368  CG  ARG   200       5.495  27.640  -9.987  1.00 41.00           C  
ATOM   1369  CD  ARG   200       4.264  27.239 -10.825  1.00 42.99           C  
ATOM   1370  NE  ARG   200       4.142  28.008 -12.068  1.00 49.55           N  
ATOM   1371  CZ  ARG   200       3.651  27.538 -13.224  1.00 52.36           C  
ATOM   1372  NH1 ARG   200       3.581  28.348 -14.283  1.00 52.08           N  
ATOM   1373  NH2 ARG   200       3.251  26.265 -13.339  1.00 51.69           N  
ATOM   1374  N   LEU   201       6.440  31.860  -8.295  1.00 37.63           N  
ATOM   1375  CA  LEU   201       6.869  33.279  -8.351  1.00 39.30           C  
ATOM   1376  C   LEU   201       8.065  33.524  -7.449  1.00 39.33           C  
ATOM   1377  O   LEU   201       8.985  34.253  -7.837  1.00 38.96           O  
ATOM   1378  CB  LEU   201       5.730  34.241  -7.952  1.00 37.79           C  
ATOM   1379  CG  LEU   201       4.440  34.162  -8.770  1.00 40.78           C  
ATOM   1380  CD1 LEU   201       3.361  35.029  -8.131  1.00 38.26           C  
ATOM   1381  CD2 LEU   201       4.702  34.616 -10.232  1.00 39.91           C  
ATOM   1382  N   ALA   202       8.062  32.902  -6.263  1.00 39.34           N  
ATOM   1383  CA  ALA   202       9.182  33.054  -5.347  1.00 40.13           C  
ATOM   1384  C   ALA   202      10.467  32.448  -5.938  1.00 41.27           C  
ATOM   1385  O   ALA   202      11.551  33.034  -5.818  1.00 41.45           O  
ATOM   1386  CB  ALA   202       8.861  32.465  -4.019  1.00 39.97           C  
ATOM   1387  N   VAL   203      10.339  31.298  -6.600  1.00 41.74           N  
ATOM   1388  CA  VAL   203      11.497  30.685  -7.267  1.00 42.08           C  
ATOM   1389  C   VAL   203      12.026  31.580  -8.399  1.00 41.70           C  
ATOM   1390  O   VAL   203      13.220  31.783  -8.475  1.00 41.07           O  
ATOM   1391  CB  VAL   203      11.276  29.184  -7.667  1.00 42.31           C  
ATOM   1392  CG1 VAL   203      10.766  28.360  -6.474  1.00 41.59           C  
ATOM   1393  CG2 VAL   203      10.334  29.057  -8.821  1.00 44.04           C  
ATOM   1394  N   LEU   204      11.135  32.148  -9.229  1.00 42.28           N  
ATOM   1395  CA  LEU   204      11.501  33.205 -10.217  1.00 42.77           C  
ATOM   1396  C   LEU   204      12.250  34.379  -9.590  1.00 42.88           C  
ATOM   1397  O   LEU   204      13.131  34.975 -10.208  1.00 42.99           O  
ATOM   1398  CB  LEU   204      10.258  33.789 -10.906  1.00 43.24           C  
ATOM   1399  CG  LEU   204       9.650  33.355 -12.246  1.00 46.48           C  
ATOM   1400  CD1 LEU   204       8.426  32.557 -12.066  1.00 47.32           C  
ATOM   1401  CD2 LEU   204       9.289  34.637 -13.021  1.00 48.31           C  
ATOM   1402  N   ALA   205      11.845  34.737  -8.373  1.00 41.99           N  
ATOM   1403  CA  ALA   205      12.465  35.806  -7.612  1.00 42.75           C  
ATOM   1404  C   ALA   205      13.871  35.462  -7.077  1.00 42.85           C  
ATOM   1405  O   ALA   205      14.571  36.350  -6.561  1.00 44.20           O  
ATOM   1406  CB  ALA   205      11.544  36.181  -6.480  1.00 41.31           C  
ATOM   1407  N   GLY   206      14.252  34.186  -7.176  1.00 42.19           N  
ATOM   1408  CA  GLY   206      15.535  33.667  -6.718  1.00 42.09           C  
ATOM   1409  C   GLY   206      15.461  32.901  -5.405  1.00 42.11           C  
ATOM   1410  O   GLY   206      16.487  32.569  -4.842  1.00 41.96           O  
ATOM   1411  N   ALA   207      14.258  32.640  -4.900  1.00 42.14           N  
ATOM   1412  CA  ALA   207      14.086  31.971  -3.599  1.00 43.13           C  
ATOM   1413  C   ALA   207      13.941  30.435  -3.687  1.00 44.04           C  
ATOM   1414  O   ALA   207      13.926  29.858  -4.771  1.00 43.67           O  
ATOM   1415  CB  ALA   207      12.901  32.560  -2.844  1.00 43.20           C  
ATOM   1416  N   LYS   208      13.858  29.784  -2.528  1.00 45.85           N  
ATOM   1417  CA  LYS   208      13.705  28.329  -2.474  1.00 47.85           C  
ATOM   1418  C   LYS   208      12.243  27.932  -2.333  1.00 48.78           C  
ATOM   1419  O   LYS   208      11.493  28.568  -1.602  1.00 48.17           O  
ATOM   1420  CB  LYS   208      14.510  27.734  -1.313  1.00 48.57           C  
ATOM   1421  CG  LYS   208      15.886  27.145  -1.690  1.00 50.53           C  
ATOM   1422  CD  LYS   208      17.062  28.075  -1.389  1.00 55.23           C  
ATOM   1423  CE  LYS   208      17.400  28.165   0.123  1.00 57.03           C  
ATOM   1424  NZ  LYS   208      16.408  29.004   0.917  1.00 54.74           N  
ATOM   1425  N   THR   209      11.856  26.854  -3.017  1.00 50.43           N  
ATOM   1426  CA  THR   209      10.494  26.310  -2.927  1.00 51.48           C  
ATOM   1427  C   THR   209      10.035  26.159  -1.464  1.00 51.51           C  
ATOM   1428  O   THR   209      10.851  26.107  -0.522  1.00 51.65           O  
ATOM   1429  CB  THR   209      10.333  24.991  -3.735  1.00 52.21           C  
ATOM   1430  OG1 THR   209       8.940  24.634  -3.819  1.00 53.28           O  
ATOM   1431  CG2 THR   209      11.159  23.850  -3.116  1.00 52.02           C  
ATOM   1432  N   GLY   210       8.723  26.145  -1.276  1.00 50.99           N  
ATOM   1433  CA  GLY   210       8.183  26.203   0.072  1.00 50.54           C  
ATOM   1434  C   GLY   210       6.723  26.562   0.048  1.00 49.29           C  
ATOM   1435  O   GLY   210       6.091  26.552  -1.014  1.00 48.86           O  
ATOM   1436  N   ARG   211       6.181  26.857   1.225  1.00 48.70           N  
ATOM   1437  CA  ARG   211       4.782  27.252   1.299  1.00 48.23           C  
ATOM   1438  C   ARG   211       4.771  28.768   1.288  1.00 45.98           C  
ATOM   1439  O   ARG   211       4.824  29.430   2.335  1.00 47.07           O  
ATOM   1440  CB  ARG   211       4.040  26.622   2.493  1.00 48.33           C  
ATOM   1441  CG  ARG   211       4.079  25.034   2.560  1.00 52.97           C  
ATOM   1442  CD  ARG   211       4.151  24.292   1.176  1.00 61.21           C  
ATOM   1443  NE  ARG   211       2.925  24.332   0.342  1.00 66.10           N  
ATOM   1444  CZ  ARG   211       2.842  24.786  -0.919  1.00 69.04           C  
ATOM   1445  NH1 ARG   211       3.911  25.278  -1.544  1.00 70.03           N  
ATOM   1446  NH2 ARG   211       1.671  24.742  -1.576  1.00 70.00           N  
ATOM   1447  N   TRP   212       4.775  29.298   0.067  1.00 43.67           N  
ATOM   1448  CA  TRP   212       4.775  30.749  -0.205  1.00 41.76           C  
ATOM   1449  C   TRP   212       3.382  31.352  -0.350  1.00 40.77           C  
ATOM   1450  O   TRP   212       2.448  30.677  -0.800  1.00 40.44           O  
ATOM   1451  CB  TRP   212       5.553  31.004  -1.494  1.00 41.37           C  
ATOM   1452  CG  TRP   212       7.006  30.766  -1.310  1.00 39.46           C  
ATOM   1453  CD1 TRP   212       7.678  29.606  -1.529  1.00 38.11           C  
ATOM   1454  CD2 TRP   212       7.962  31.698  -0.787  1.00 39.28           C  
ATOM   1455  NE1 TRP   212       9.008  29.772  -1.236  1.00 37.62           N  
ATOM   1456  CE2 TRP   212       9.212  31.037  -0.758  1.00 40.47           C  
ATOM   1457  CE3 TRP   212       7.893  33.032  -0.374  1.00 36.46           C  
ATOM   1458  CZ2 TRP   212      10.390  31.671  -0.314  1.00 39.98           C  
ATOM   1459  CZ3 TRP   212       9.054  33.663   0.048  1.00 38.84           C  
ATOM   1460  CH2 TRP   212      10.290  32.983   0.070  1.00 39.28           C  
ATOM   1461  N   LYS   213       3.249  32.622   0.017  1.00 40.58           N  
ATOM   1462  CA  LYS   213       2.059  33.422  -0.275  1.00 40.25           C  
ATOM   1463  C   LYS   213       2.484  34.787  -0.791  1.00 39.48           C  
ATOM   1464  O   LYS   213       3.498  35.318  -0.343  1.00 39.04           O  
ATOM   1465  CB  LYS   213       1.194  33.602   0.979  1.00 40.47           C  
ATOM   1466  CG  LYS   213       0.446  32.298   1.467  1.00 43.77           C  
ATOM   1467  CD  LYS   213      -0.666  31.854   0.470  1.00 48.68           C  
ATOM   1468  CE  LYS   213      -1.257  30.458   0.783  1.00 45.97           C  
ATOM   1469  NZ  LYS   213      -2.195  29.896  -0.272  1.00 44.84           N  
ATOM   1470  N   ILE   214       1.723  35.334  -1.746  1.00 38.84           N  
ATOM   1471  CA  ILE   214       1.833  36.736  -2.134  1.00 38.25           C  
ATOM   1472  C   ILE   214       1.308  37.565  -1.016  1.00 39.46           C  
ATOM   1473  O   ILE   214       0.191  37.315  -0.538  1.00 39.34           O  
ATOM   1474  CB  ILE   214       1.020  37.045  -3.356  1.00 38.32           C  
ATOM   1475  CG1 ILE   214       1.577  36.244  -4.537  1.00 41.05           C  
ATOM   1476  CG2 ILE   214       0.995  38.591  -3.651  1.00 36.16           C  
ATOM   1477  CD1 ILE   214       0.735  36.298  -5.751  1.00 42.99           C  
ATOM   1478  N   THR   215       2.118  38.522  -0.572  1.00 40.09           N  
ATOM   1479  CA  THR   215       1.717  39.429   0.495  1.00 39.19           C  
ATOM   1480  C   THR   215       1.306  40.776  -0.058  1.00 40.01           C  
ATOM   1481  O   THR   215       0.474  41.460   0.565  1.00 40.47           O  
ATOM   1482  CB  THR   215       2.810  39.584   1.605  1.00 38.67           C  
ATOM   1483  OG1 THR   215       4.030  40.065   1.019  1.00 36.42           O  
ATOM   1484  CG2 THR   215       3.081  38.205   2.256  1.00 39.25           C  
ATOM   1485  N   SER   216       1.859  41.163  -1.219  1.00 40.46           N  
ATOM   1486  CA  SER   216       1.661  42.478  -1.733  1.00 40.62           C  
ATOM   1487  C   SER   216       2.031  42.554  -3.192  1.00 41.47           C  
ATOM   1488  O   SER   216       3.074  42.032  -3.593  1.00 41.94           O  
ATOM   1489  CB  SER   216       2.497  43.491  -0.907  1.00 39.86           C  
ATOM   1490  OG  SER   216       2.128  44.823  -1.153  1.00 41.34           O  
ATOM   1491  N   ILE   217       1.172  43.215  -3.992  1.00 41.47           N  
ATOM   1492  CA  ILE   217       1.457  43.510  -5.417  1.00 40.32           C  
ATOM   1493  C   ILE   217       1.534  45.018  -5.557  1.00 40.31           C  
ATOM   1494  O   ILE   217       0.694  45.723  -5.002  1.00 39.84           O  
ATOM   1495  CB  ILE   217       0.343  42.980  -6.348  1.00 40.39           C  
ATOM   1496  CG1 ILE   217       0.187  41.443  -6.165  1.00 39.41           C  
ATOM   1497  CG2 ILE   217       0.598  43.426  -7.811  1.00 39.89           C  
ATOM   1498  CD1 ILE   217      -1.090  40.855  -6.724  1.00 41.51           C  
ATOM   1499  N   ASP   218       2.548  45.504  -6.273  1.00 39.30           N  
ATOM   1500  CA  ASP   218       2.705  46.956  -6.484  1.00 38.73           C  
ATOM   1501  C   ASP   218       3.151  47.210  -7.933  1.00 37.93           C  
ATOM   1502  O   ASP   218       3.416  46.255  -8.685  1.00 37.25           O  
ATOM   1503  CB  ASP   218       3.623  47.588  -5.385  1.00 37.51           C  
ATOM   1504  CG  ASP   218       5.058  47.024  -5.398  1.00 40.93           C  
ATOM   1505  OD1 ASP   218       5.778  47.238  -6.414  1.00 42.23           O  
ATOM   1506  OD2 ASP   218       5.485  46.367  -4.407  1.00 40.91           O  
ATOM   1507  N   PRO   219       3.198  48.476  -8.359  1.00 37.21           N  
ATOM   1508  CA  PRO   219       3.591  48.663  -9.760  1.00 37.75           C  
ATOM   1509  C   PRO   219       4.951  48.083 -10.199  1.00 37.92           C  
ATOM   1510  O   PRO   219       5.164  47.847 -11.405  1.00 38.51           O  
ATOM   1511  CB  PRO   219       3.597  50.203  -9.907  1.00 38.18           C  
ATOM   1512  CG  PRO   219       2.574  50.651  -8.926  1.00 36.94           C  
ATOM   1513  CD  PRO   219       2.808  49.758  -7.722  1.00 36.21           C  
ATOM   1514  N   ASP   220       5.859  47.883  -9.259  1.00 37.98           N  
ATOM   1515  CA  ASP   220       7.228  47.454  -9.589  1.00 39.01           C  
ATOM   1516  C   ASP   220       7.467  45.947  -9.367  1.00 38.51           C  
ATOM   1517  O   ASP   220       8.460  45.362  -9.868  1.00 37.46           O  
ATOM   1518  CB  ASP   220       8.245  48.271  -8.767  1.00 38.35           C  
ATOM   1519  CG  ASP   220       8.330  49.724  -9.217  1.00 39.07           C  
ATOM   1520  OD1 ASP   220       7.923  50.038 -10.360  1.00 39.95           O  
ATOM   1521  OD2 ASP   220       8.803  50.553  -8.411  1.00 42.67           O  
ATOM   1522  N   GLY   221       6.533  45.310  -8.679  1.00 37.64           N  
ATOM   1523  CA  GLY   221       6.634  43.860  -8.472  1.00 38.70           C  
ATOM   1524  C   GLY   221       5.776  43.311  -7.351  1.00 39.35           C  
ATOM   1525  O   GLY   221       4.787  43.925  -6.960  1.00 39.63           O  
ATOM   1526  N   ILE   222       6.190  42.163  -6.812  1.00 39.81           N  
ATOM   1527  CA  ILE   222       5.341  41.364  -5.958  1.00 40.03           C  
ATOM   1528  C   ILE   222       6.174  40.894  -4.775  1.00 40.65           C  
ATOM   1529  O   ILE   222       7.272  40.320  -4.965  1.00 41.65           O  
ATOM   1530  CB  ILE   222       4.790  40.075  -6.716  1.00 39.93           C  
ATOM   1531  CG1 ILE   222       4.009  40.441  -7.999  1.00 38.13           C  
ATOM   1532  CG2 ILE   222       3.929  39.192  -5.700  1.00 38.68           C  
ATOM   1533  CD1 ILE   222       3.752  39.227  -8.997  1.00 40.00           C  
ATOM   1534  N   ASP   223       5.645  41.080  -3.567  1.00 39.32           N  
ATOM   1535  CA  ASP   223       6.358  40.638  -2.403  1.00 39.52           C  
ATOM   1536  C   ASP   223       5.741  39.337  -2.046  1.00 38.95           C  
ATOM   1537  O   ASP   223       4.511  39.211  -2.116  1.00 38.85           O  
ATOM   1538  CB  ASP   223       6.196  41.623  -1.251  1.00 39.17           C  
ATOM   1539  CG  ASP   223       7.141  42.848  -1.375  1.00 42.76           C  
ATOM   1540  OD1 ASP   223       8.022  42.907  -2.249  1.00 47.48           O  
ATOM   1541  OD2 ASP   223       6.998  43.742  -0.557  1.00 44.98           O  
ATOM   1542  N   LEU   224       6.580  38.377  -1.633  1.00 39.80           N  
ATOM   1543  CA  LEU   224       6.111  37.053  -1.146  1.00 38.74           C  
ATOM   1544  C   LEU   224       6.722  36.680   0.186  1.00 39.35           C  
ATOM   1545  O   LEU   224       7.821  37.137   0.512  1.00 38.40           O  
ATOM   1546  CB  LEU   224       6.378  35.942  -2.182  1.00 39.02           C  
ATOM   1547  CG  LEU   224       5.897  36.304  -3.590  1.00 37.93           C  
ATOM   1548  CD1 LEU   224       7.068  36.608  -4.460  1.00 39.11           C  
ATOM   1549  CD2 LEU   224       5.071  35.150  -4.101  1.00 40.89           C  
ATOM   1550  N   ALA   225       5.995  35.870   0.966  1.00 37.56           N  
ATOM   1551  CA  ALA   225       6.510  35.322   2.200  1.00 38.71           C  
ATOM   1552  C   ALA   225       6.232  33.820   2.347  1.00 40.11           C  
ATOM   1553  O   ALA   225       5.213  33.284   1.854  1.00 39.61           O  
ATOM   1554  CB  ALA   225       5.984  36.121   3.449  1.00 38.10           C  
ATOM   1555  N   SER   226       7.187  33.150   2.992  1.00 41.63           N  
ATOM   1556  CA  SER   226       7.013  31.793   3.510  1.00 41.51           C  
ATOM   1557  C   SER   226       7.324  31.904   4.982  1.00 42.46           C  
ATOM   1558  O   SER   226       7.537  33.010   5.479  1.00 43.34           O  
ATOM   1559  CB  SER   226       7.970  30.828   2.842  1.00 41.83           C  
ATOM   1560  OG  SER   226       9.300  31.081   3.257  1.00 42.39           O  
ATOM   1561  N   ALA   227       7.342  30.774   5.689  1.00 42.16           N  
ATOM   1562  CA  ALA   227       7.669  30.767   7.106  1.00 42.59           C  
ATOM   1563  C   ALA   227       9.110  31.220   7.433  1.00 42.71           C  
ATOM   1564  O   ALA   227       9.305  32.007   8.356  1.00 42.36           O  
ATOM   1565  CB  ALA   227       7.402  29.404   7.699  1.00 43.21           C  
ATOM   1566  N   SER   228      10.105  30.715   6.694  1.00 42.72           N  
ATOM   1567  CA  SER   228      11.510  31.070   6.946  1.00 42.93           C  
ATOM   1568  C   SER   228      12.085  32.193   6.075  1.00 42.11           C  
ATOM   1569  O   SER   228      13.103  32.779   6.454  1.00 42.02           O  
ATOM   1570  CB  SER   228      12.418  29.834   6.879  1.00 43.93           C  
ATOM   1571  OG  SER   228      12.426  29.254   5.581  1.00 46.22           O  
ATOM   1572  N   ASP   229      11.432  32.518   4.949  1.00 41.72           N  
ATOM   1573  CA  ASP   229      11.994  33.464   3.977  1.00 39.90           C  
ATOM   1574  C   ASP   229      11.038  34.518   3.395  1.00 38.59           C  
ATOM   1575  O   ASP   229       9.824  34.418   3.499  1.00 37.75           O  
ATOM   1576  CB  ASP   229      12.660  32.689   2.838  1.00 40.44           C  
ATOM   1577  CG  ASP   229      13.926  33.373   2.310  1.00 44.68           C  
ATOM   1578  OD1 ASP   229      14.608  32.727   1.477  1.00 49.71           O  
ATOM   1579  OD2 ASP   229      14.260  34.531   2.722  1.00 43.59           O  
ATOM   1580  N   LEU   230      11.617  35.547   2.781  1.00 36.54           N  
ATOM   1581  CA  LEU   230      10.867  36.577   2.051  1.00 36.28           C  
ATOM   1582  C   LEU   230      11.476  36.665   0.654  1.00 36.24           C  
ATOM   1583  O   LEU   230      12.709  36.487   0.502  1.00 36.39           O  
ATOM   1584  CB  LEU   230      10.960  37.968   2.743  1.00 34.87           C  
ATOM   1585  CG  LEU   230      10.459  38.126   4.187  1.00 34.46           C  
ATOM   1586  CD1 LEU   230      10.799  39.517   4.729  1.00 32.33           C  
ATOM   1587  CD2 LEU   230       8.953  37.824   4.324  1.00 35.09           C  
ATOM   1588  N   ALA   231      10.630  36.971  -0.330  1.00 36.69           N  
ATOM   1589  CA  ALA   231      11.059  37.169  -1.718  1.00 37.63           C  
ATOM   1590  C   ALA   231      10.385  38.400  -2.322  1.00 37.88           C  
ATOM   1591  O   ALA   231       9.292  38.845  -1.850  1.00 36.74           O  
ATOM   1592  CB  ALA   231      10.745  35.917  -2.578  1.00 38.16           C  
ATOM   1593  N   ARG   232      11.063  38.987  -3.312  1.00 37.21           N  
ATOM   1594  CA  ARG   232      10.468  40.025  -4.146  1.00 37.53           C  
ATOM   1595  C   ARG   232      10.745  39.728  -5.616  1.00 37.39           C  
ATOM   1596  O   ARG   232      11.906  39.647  -6.036  1.00 38.13           O  
ATOM   1597  CB  ARG   232      10.957  41.450  -3.789  1.00 38.48           C  
ATOM   1598  CG  ARG   232      10.221  42.472  -4.667  1.00 41.60           C  
ATOM   1599  CD  ARG   232      10.480  43.857  -4.294  1.00 44.96           C  
ATOM   1600  NE  ARG   232       9.842  44.856  -5.158  1.00 45.46           N  
ATOM   1601  CZ  ARG   232       8.545  45.201  -5.198  1.00 44.81           C  
ATOM   1602  NH1 ARG   232       7.613  44.591  -4.445  1.00 40.67           N  
ATOM   1603  NH2 ARG   232       8.185  46.204  -6.021  1.00 40.08           N  
ATOM   1604  N   LEU   233       9.680  39.585  -6.392  1.00 37.74           N  
ATOM   1605  CA  LEU   233       9.800  39.394  -7.866  1.00 37.36           C  
ATOM   1606  C   LEU   233       9.638  40.752  -8.532  1.00 38.69           C  
ATOM   1607  O   LEU   233       8.593  41.362  -8.387  1.00 39.15           O  
ATOM   1608  CB  LEU   233       8.739  38.415  -8.393  1.00 38.10           C  
ATOM   1609  CG  LEU   233       8.736  38.007  -9.900  1.00 37.23           C  
ATOM   1610  CD1 LEU   233      10.041  37.435 -10.324  1.00 36.14           C  
ATOM   1611  CD2 LEU   233       7.602  36.987 -10.196  1.00 36.27           C  
ATOM   1612  N   TRP   234      10.659  41.219  -9.269  1.00 38.24           N  
ATOM   1613  CA  TRP   234      10.559  42.485  -9.974  1.00 39.13           C  
ATOM   1614  C   TRP   234       9.999  42.342 -11.361  1.00 39.09           C  
ATOM   1615  O   TRP   234      10.421  41.458 -12.124  1.00 40.17           O  
ATOM   1616  CB  TRP   234      11.916  43.181 -10.045  1.00 39.39           C  
ATOM   1617  CG  TRP   234      12.446  43.508  -8.659  1.00 39.51           C  
ATOM   1618  CD1 TRP   234      13.161  42.667  -7.823  1.00 40.36           C  
ATOM   1619  CD2 TRP   234      12.292  44.740  -7.949  1.00 40.13           C  
ATOM   1620  NE1 TRP   234      13.498  43.317  -6.657  1.00 35.87           N  
ATOM   1621  CE2 TRP   234      12.967  44.585  -6.692  1.00 41.06           C  
ATOM   1622  CE3 TRP   234      11.668  45.966  -8.244  1.00 39.24           C  
ATOM   1623  CZ2 TRP   234      13.023  45.616  -5.731  1.00 42.27           C  
ATOM   1624  CZ3 TRP   234      11.732  47.019  -7.270  1.00 42.22           C  
ATOM   1625  CH2 TRP   234      12.398  46.825  -6.044  1.00 40.34           C  
ATOM   1626  N   PHE   235       9.043  43.203 -11.706  1.00 38.84           N  
ATOM   1627  CA  PHE   235       8.515  43.208 -13.084  1.00 38.96           C  
ATOM   1628  C   PHE   235       9.582  43.700 -14.033  1.00 38.59           C  
ATOM   1629  O   PHE   235      10.443  44.516 -13.632  1.00 38.93           O  
ATOM   1630  CB  PHE   235       7.276  44.094 -13.183  1.00 38.97           C  
ATOM   1631  CG  PHE   235       6.112  43.615 -12.341  1.00 40.90           C  
ATOM   1632  CD1 PHE   235       5.797  42.235 -12.271  1.00 40.09           C  
ATOM   1633  CD2 PHE   235       5.322  44.534 -11.636  1.00 39.05           C  
ATOM   1634  CE1 PHE   235       4.745  41.781 -11.549  1.00 39.69           C  
ATOM   1635  CE2 PHE   235       4.223  44.079 -10.871  1.00 37.48           C  
ATOM   1636  CZ  PHE   235       3.940  42.720 -10.819  1.00 40.48           C  
ATOM   1637  N   ALA   236       9.543  43.231 -15.280  1.00 38.45           N  
ATOM   1638  CA  ALA   236      10.436  43.786 -16.290  1.00 37.70           C  
ATOM   1639  C   ALA   236      10.100  45.249 -16.627  1.00 37.64           C  
ATOM   1640  O   ALA   236      10.982  46.013 -16.965  1.00 37.01           O  
ATOM   1641  CB  ALA   236      10.483  42.913 -17.582  1.00 38.00           C  
ATOM   1642  N   GLU   237       8.824  45.611 -16.580  1.00 37.50           N  
ATOM   1643  CA  GLU   237       8.438  47.005 -16.714  1.00 38.69           C  
ATOM   1644  C   GLU   237       7.311  47.345 -15.745  1.00 38.00           C  
ATOM   1645  O   GLU   237       6.660  46.443 -15.220  1.00 38.35           O  
ATOM   1646  CB  GLU   237       8.133  47.404 -18.174  1.00 38.07           C  
ATOM   1647  CG  GLU   237       7.000  46.656 -18.820  1.00 38.95           C  
ATOM   1648  CD  GLU   237       6.900  46.949 -20.306  1.00 40.50           C  
ATOM   1649  OE1 GLU   237       6.063  46.300 -20.980  1.00 44.17           O  
ATOM   1650  OE2 GLU   237       7.648  47.820 -20.803  1.00 39.99           O  
ATOM   1651  N   ARG   238       7.144  48.649 -15.473  1.00 38.50           N  
ATOM   1652  CA  ARG   238       6.249  49.148 -14.421  1.00 38.23           C  
ATOM   1653  C   ARG   238       4.837  48.801 -14.832  1.00 38.36           C  
ATOM   1654  O   ARG   238       4.489  48.922 -15.997  1.00 36.49           O  
ATOM   1655  CB  ARG   238       6.398  50.684 -14.283  1.00 39.03           C  
ATOM   1656  CG  ARG   238       5.456  51.361 -13.290  1.00 38.45           C  
ATOM   1657  CD  ARG   238       5.582  52.918 -13.308  1.00 40.35           C  
ATOM   1658  NE  ARG   238       4.427  53.521 -12.639  1.00 40.39           N  
ATOM   1659  CZ  ARG   238       4.292  53.621 -11.319  1.00 38.31           C  
ATOM   1660  NH1 ARG   238       5.236  53.158 -10.511  1.00 40.01           N  
ATOM   1661  NH2 ARG   238       3.199  54.153 -10.810  1.00 35.26           N  
ATOM   1662  N   VAL   239       4.014  48.410 -13.876  1.00 39.17           N  
ATOM   1663  CA  VAL   239       2.653  47.913 -14.163  1.00 40.40           C  
ATOM   1664  C   VAL   239       1.617  48.878 -13.543  1.00 40.56           C  
ATOM   1665  O   VAL   239       1.759  49.304 -12.403  1.00 38.13           O  
ATOM   1666  CB  VAL   239       2.495  46.455 -13.636  1.00 40.92           C  
ATOM   1667  CG1 VAL   239       1.032  46.075 -13.500  1.00 41.13           C  
ATOM   1668  CG2 VAL   239       3.219  45.489 -14.602  1.00 41.64           C  
ATOM   1669  N   GLU   240       0.599  49.262 -14.314  1.00 39.99           N  
ATOM   1670  CA  GLU   240      -0.309  50.325 -13.830  1.00 40.55           C  
ATOM   1671  C   GLU   240      -1.774  49.914 -13.806  1.00 40.06           C  
ATOM   1672  O   GLU   240      -2.584  50.452 -13.040  1.00 38.77           O  
ATOM   1673  CB  GLU   240      -0.098  51.614 -14.631  1.00 41.11           C  
ATOM   1674  CG  GLU   240       1.092  52.415 -14.105  1.00 40.98           C  
ATOM   1675  CD  GLU   240       1.240  53.750 -14.788  1.00 42.99           C  
ATOM   1676  OE1 GLU   240       0.678  53.947 -15.907  1.00 43.11           O  
ATOM   1677  OE2 GLU   240       1.937  54.609 -14.198  1.00 45.89           O  
ATOM   1678  N   THR   241      -2.069  48.888 -14.592  1.00 40.56           N  
ATOM   1679  CA  THR   241      -3.427  48.407 -14.767  1.00 40.97           C  
ATOM   1680  C   THR   241      -3.498  46.920 -14.591  1.00 41.14           C  
ATOM   1681  O   THR   241      -2.471  46.206 -14.586  1.00 40.51           O  
ATOM   1682  CB  THR   241      -3.978  48.755 -16.176  1.00 41.31           C  
ATOM   1683  OG1 THR   241      -3.235  48.037 -17.173  1.00 41.19           O  
ATOM   1684  CG2 THR   241      -3.896  50.254 -16.443  1.00 40.83           C  
ATOM   1685  N   LEU   242      -4.724  46.430 -14.464  1.00 41.44           N  
ATOM   1686  CA  LEU   242      -4.923  44.999 -14.321  1.00 41.37           C  
ATOM   1687  C   LEU   242      -4.507  44.277 -15.604  1.00 40.45           C  
ATOM   1688  O   LEU   242      -3.842  43.239 -15.543  1.00 39.76           O  
ATOM   1689  CB  LEU   242      -6.383  44.686 -13.982  1.00 42.24           C  
ATOM   1690  CG  LEU   242      -6.693  43.207 -13.740  1.00 43.34           C  
ATOM   1691  CD1 LEU   242      -6.140  42.777 -12.389  1.00 47.07           C  
ATOM   1692  CD2 LEU   242      -8.186  43.008 -13.766  1.00 45.50           C  
ATOM   1693  N   LYS   243      -4.917  44.817 -16.755  1.00 39.92           N  
ATOM   1694  CA  LYS   243      -4.502  44.262 -18.042  1.00 39.83           C  
ATOM   1695  C   LYS   243      -2.986  44.123 -18.089  1.00 39.07           C  
ATOM   1696  O   LYS   243      -2.484  43.076 -18.483  1.00 38.24           O  
ATOM   1697  CB  LYS   243      -4.976  45.110 -19.240  1.00 40.23           C  
ATOM   1698  CG  LYS   243      -4.818  44.352 -20.557  1.00 43.46           C  
ATOM   1699  CD  LYS   243      -5.697  44.891 -21.694  1.00 46.25           C  
ATOM   1700  CE  LYS   243      -6.112  43.753 -22.612  1.00 49.30           C  
ATOM   1701  NZ  LYS   243      -6.790  42.665 -21.842  1.00 50.82           N  
ATOM   1702  N   GLN   244      -2.270  45.172 -17.665  1.00 38.67           N  
ATOM   1703  CA  GLN   244      -0.815  45.166 -17.687  1.00 38.68           C  
ATOM   1704  C   GLN   244      -0.265  44.151 -16.698  1.00 39.31           C  
ATOM   1705  O   GLN   244       0.726  43.487 -16.981  1.00 39.04           O  
ATOM   1706  CB  GLN   244      -0.226  46.558 -17.442  1.00 37.90           C  
ATOM   1707  CG  GLN   244      -0.509  47.574 -18.567  1.00 37.97           C  
ATOM   1708  CD  GLN   244      -0.042  48.971 -18.208  1.00 38.18           C  
ATOM   1709  OE1 GLN   244       0.280  49.264 -17.055  1.00 37.40           O  
ATOM   1710  NE2 GLN   244      -0.004  49.850 -19.201  1.00 38.82           N  
ATOM   1711  N   PHE   245      -0.904  44.014 -15.532  1.00 40.67           N  
ATOM   1712  CA  PHE   245      -0.460  43.012 -14.562  1.00 41.10           C  
ATOM   1713  C   PHE   245      -0.560  41.581 -15.123  1.00 41.63           C  
ATOM   1714  O   PHE   245       0.404  40.810 -15.086  1.00 40.20           O  
ATOM   1715  CB  PHE   245      -1.295  43.096 -13.303  1.00 40.94           C  
ATOM   1716  CG  PHE   245      -0.929  42.085 -12.296  1.00 42.35           C  
ATOM   1717  CD1 PHE   245       0.328  42.120 -11.694  1.00 45.23           C  
ATOM   1718  CD2 PHE   245      -1.842  41.116 -11.891  1.00 43.67           C  
ATOM   1719  CE1 PHE   245       0.700  41.173 -10.739  1.00 42.02           C  
ATOM   1720  CE2 PHE   245      -1.473  40.171 -10.906  1.00 44.61           C  
ATOM   1721  CZ  PHE   245      -0.206  40.220 -10.336  1.00 39.90           C  
ATOM   1722  N   GLU   246      -1.760  41.234 -15.585  1.00 43.00           N  
ATOM   1723  CA  GLU   246      -2.042  39.927 -16.170  1.00 44.84           C  
ATOM   1724  C   GLU   246      -1.063  39.602 -17.321  1.00 44.90           C  
ATOM   1725  O   GLU   246      -0.621  38.454 -17.459  1.00 44.81           O  
ATOM   1726  CB  GLU   246      -3.526  39.860 -16.591  1.00 44.32           C  
ATOM   1727  CG  GLU   246      -3.954  38.674 -17.517  1.00 47.80           C  
ATOM   1728  CD  GLU   246      -5.251  38.946 -18.302  1.00 48.21           C  
ATOM   1729  OE1 GLU   246      -5.773  40.089 -18.210  1.00 54.42           O  
ATOM   1730  OE2 GLU   246      -5.737  38.036 -19.037  1.00 53.58           O  
ATOM   1731  N   LYS   247      -0.709  40.599 -18.135  1.00 45.50           N  
ATOM   1732  CA  LYS   247       0.238  40.365 -19.245  1.00 45.47           C  
ATOM   1733  C   LYS   247       1.616  40.052 -18.693  1.00 45.44           C  
ATOM   1734  O   LYS   247       2.220  39.049 -19.049  1.00 44.50           O  
ATOM   1735  CB  LYS   247       0.365  41.573 -20.175  1.00 45.46           C  
ATOM   1736  CG  LYS   247      -0.918  42.053 -20.865  1.00 48.64           C  
ATOM   1737  CD  LYS   247      -1.542  41.049 -21.852  1.00 50.26           C  
ATOM   1738  CE  LYS   247      -2.612  40.175 -21.151  1.00 52.86           C  
ATOM   1739  NZ  LYS   247      -3.531  40.995 -20.265  1.00 51.97           N  
ATOM   1740  N   ALA   248       2.113  40.961 -17.860  1.00 45.18           N  
ATOM   1741  CA  ALA   248       3.347  40.778 -17.103  1.00 47.11           C  
ATOM   1742  C   ALA   248       3.417  39.420 -16.390  1.00 47.71           C  
ATOM   1743  O   ALA   248       4.455  38.767 -16.415  1.00 48.59           O  
ATOM   1744  CB  ALA   248       3.510  41.906 -16.065  1.00 46.51           C  
ATOM   1745  N   LEU   249       2.324  38.999 -15.752  1.00 48.09           N  
ATOM   1746  CA  LEU   249       2.333  37.731 -15.017  1.00 49.29           C  
ATOM   1747  C   LEU   249       2.472  36.559 -15.978  1.00 48.63           C  
ATOM   1748  O   LEU   249       3.212  35.595 -15.702  1.00 48.78           O  
ATOM   1749  CB  LEU   249       1.068  37.553 -14.151  1.00 49.60           C  
ATOM   1750  CG  LEU   249       1.090  37.485 -12.610  1.00 54.43           C  
ATOM   1751  CD1 LEU   249       0.097  36.412 -12.168  1.00 55.08           C  
ATOM   1752  CD2 LEU   249       2.454  37.183 -11.983  1.00 55.79           C  
ATOM   1753  N   ALA   250       1.760  36.656 -17.101  1.00 48.14           N  
ATOM   1754  CA  ALA   250       1.699  35.597 -18.113  1.00 47.71           C  
ATOM   1755  C   ALA   250       3.049  35.394 -18.810  1.00 47.83           C  
ATOM   1756  O   ALA   250       3.456  34.250 -19.061  1.00 47.90           O  
ATOM   1757  CB  ALA   250       0.585  35.891 -19.145  1.00 47.10           C  
ATOM   1758  N   GLN   251       3.714  36.499 -19.150  1.00 47.40           N  
ATOM   1759  CA  GLN   251       5.108  36.485 -19.619  1.00 47.72           C  
ATOM   1760  C   GLN   251       5.992  35.752 -18.607  1.00 47.15           C  
ATOM   1761  O   GLN   251       6.709  34.823 -18.961  1.00 47.30           O  
ATOM   1762  CB  GLN   251       5.616  37.924 -19.883  1.00 47.82           C  
ATOM   1763  CG  GLN   251       7.139  38.186 -19.666  1.00 50.16           C  
ATOM   1764  CD  GLN   251       7.488  39.108 -18.448  1.00 55.43           C  
ATOM   1765  OE1 GLN   251       8.672  39.397 -18.198  1.00 57.79           O  
ATOM   1766  NE2 GLN   251       6.471  39.574 -17.717  1.00 51.70           N  
ATOM   1767  N   LEU   252       5.888  36.124 -17.345  1.00 46.40           N  
ATOM   1768  CA  LEU   252       6.785  35.611 -16.347  1.00 45.83           C  
ATOM   1769  C   LEU   252       6.648  34.127 -16.155  1.00 45.15           C  
ATOM   1770  O   LEU   252       7.614  33.437 -15.989  1.00 45.08           O  
ATOM   1771  CB  LEU   252       6.532  36.290 -15.001  1.00 45.21           C  
ATOM   1772  CG  LEU   252       7.059  37.678 -14.736  1.00 47.10           C  
ATOM   1773  CD1 LEU   252       6.263  38.387 -13.704  1.00 50.45           C  
ATOM   1774  CD2 LEU   252       8.474  37.620 -14.342  1.00 46.31           C  
ATOM   1775  N   LEU   253       5.428  33.655 -16.131  1.00 44.83           N  
ATOM   1776  CA  LEU   253       5.173  32.277 -15.753  1.00 45.50           C  
ATOM   1777  C   LEU   253       5.338  31.295 -16.921  1.00 47.33           C  
ATOM   1778  O   LEU   253       4.850  30.149 -16.882  1.00 47.87           O  
ATOM   1779  CB  LEU   253       3.790  32.160 -15.118  1.00 45.04           C  
ATOM   1780  CG  LEU   253       3.754  32.686 -13.679  1.00 44.08           C  
ATOM   1781  CD1 LEU   253       2.335  32.971 -13.207  1.00 41.18           C  
ATOM   1782  CD2 LEU   253       4.480  31.688 -12.774  1.00 44.27           C  
ATOM   1783  N   LYS   254       6.051  31.725 -17.954  1.00 48.81           N  
ATOM   1784  CA  LYS   254       6.266  30.875 -19.122  1.00 49.32           C  
ATOM   1785  C   LYS   254       7.219  29.706 -18.901  1.00 49.52           C  
ATOM   1786  O   LYS   254       7.221  28.754 -19.695  1.00 49.50           O  
ATOM   1787  CB  LYS   254       6.687  31.703 -20.338  1.00 49.85           C  
ATOM   1788  CG  LYS   254       5.620  31.769 -21.438  1.00 51.80           C  
ATOM   1789  CD  LYS   254       4.301  32.361 -20.926  1.00 53.96           C  
ATOM   1790  CE  LYS   254       3.413  31.331 -20.190  1.00 54.77           C  
ATOM   1791  NZ  LYS   254       2.785  31.953 -18.947  1.00 53.07           N  
END
