
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  194 ( 1574),  selected  194 , name 2i51_A
# Molecule2: number of CA atoms  234 ( 1778),  selected  234 , name T0506.pdb
# PARAMETERS: 2i51_A.T0506.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      V       4           -
LGA    S     2_A      A       5           -
LGA    L     3_A      P       6           -
LGA    A     4_A      P       7           -
LGA    -       -      V       8           -
LGA    -       -      I       9           -
LGA    -       -      T      10           -
LGA    -       -      P      11           -
LGA    -       -      R      12           -
LGA    -       -      F      24           -
LGA    -       -      E      25           -
LGA    -       -      A      26           -
LGA    P     5_A      V      27          4.327
LGA    -       -      R      28           -
LGA    W     6_A      V      29          6.410
LGA    R     7_A      A      30          5.388
LGA    G     8_A      R      31          3.241
LGA    A     9_A      D      32          3.459
LGA    I    10_A      V      33          2.306
LGA    -       -      L      34           -
LGA    A    11_A      H      35          4.184
LGA    H    12_A      -       -           -
LGA    A    13_A      -       -           -
LGA    L    14_A      T      36          2.441
LGA    H    15_A      -       -           -
LGA    R    16_A      -       -           -
LGA    N    17_A      -       -           -
LGA    R    18_A      -       -           -
LGA    S    19_A      -       -           -
LGA    L    20_A      -       -           -
LGA    V    21_A      -       -           -
LGA    Y    22_A      -       -           -
LGA    A    23_A      S      37           #
LGA    R    24_A      R      38          1.449
LGA    Y    25_A      T      39          1.139
LGA    L    26_A      A      40          1.421
LGA    Q    27_A      A      41          0.634
LGA    L    28_A      L      42          0.222
LGA    A    29_A      A      43          0.529
LGA    T    30_A      T      44          0.714
LGA    V    31_A      L      45          0.513
LGA    Q    32_A      D      46          0.890
LGA    P    33_A      P      47          0.132
LGA    N    34_A      V      48          1.508
LGA    -       -      S      49           -
LGA    G    35_A      G      50          0.724
LGA    R    36_A      Y      51          1.263
LGA    P    37_A      P      52          0.878
LGA    A    38_A      Y      53          0.520
LGA    N    39_A      T      54          0.371
LGA    R    40_A      T      55          0.557
LGA    T    41_A      A      56          0.367
LGA    L    42_A      T      57          0.279
LGA    V    43_A      N      58          0.922
LGA    F    44_A      I      59          1.277
LGA    R    45_A      G      60          1.895
LGA    G    46_A      I      61          2.291
LGA    F    47_A      -       -           -
LGA    L    48_A      E      62          1.576
LGA    E    49_A      P      63          2.285
LGA    D    50_A      D      64          2.877
LGA    T    51_A      -       -           -
LGA    N    52_A      G      65          3.443
LGA    Q    53_A      T      66          1.750
LGA    L    54_A      P      67          0.253
LGA    R    55_A      F      68          1.382
LGA    F    56_A      F      69          0.941
LGA    I    57_A      F      70          1.133
LGA    T    58_A      A      71          1.339
LGA    D    59_A      A      72          1.383
LGA    T    60_A      G      73          1.697
LGA    R    61_A      L      74          1.879
LGA    S    62_A      T      75          1.686
LGA    A    63_A      L      76          1.824
LGA    K    64_A      H      77          1.451
LGA    A    65_A      A      78          1.559
LGA    D    66_A      R      79          1.859
LGA    Q    67_A      N      80          0.764
LGA    I    68_A      M      81          0.664
LGA    Q    69_A      E      82          1.676
LGA    Q    70_A      T      83          1.607
LGA    Q    71_A      D      84          1.183
LGA    P    72_A      A      85          0.770
LGA    W    73_A      R      86          1.142
LGA    A    74_A      I      87          0.777
LGA    E    75_A      S      88          0.869
LGA    I    76_A      V      89          1.031
LGA    C    77_A      T      90          1.843
LGA    W    78_A      L      91          2.393
LGA    Y    79_A      A      92          2.950
LGA    F    80_A      P      93          2.404
LGA    -       -      F      94           -
LGA    -       -      G      95           -
LGA    -       -      K      96           -
LGA    P    81_A      G      97          3.148
LGA    N    82_A      D      98           -
LGA    T    83_A      A      99           -
LGA    -       -      L     100           -
LGA    R    84_A      T     101          2.725
LGA    E    85_A      L     102          2.479
LGA    -       -      P     103           -
LGA    Q    86_A      R     104          1.095
LGA    F    87_A      L     105          1.116
LGA    R    88_A      T     106          1.158
LGA    X    89_A      L     107          1.129
LGA    A    90_A      V     108          0.619
LGA    G    91_A      G     109          0.914
LGA    D    92_A      R     110          1.088
LGA    L    93_A      A     111          0.940
LGA    T    94_A      D     112          0.882
LGA    L    95_A      R     113          2.101
LGA    I    96_A      I     114          3.002
LGA    S    97_A      -       -           -
LGA    S    98_A      -       -           -
LGA    D    99_A      -       -           -
LGA    D   100_A      -       -           -
LGA    S   101_A      -       -           -
LGA    H   102_A      -       -           -
LGA    Q   103_A      G     115          3.976
LGA    D   104_A      -       -           -
LGA    L   105_A      -       -           -
LGA    Q   106_A      P     116          3.077
LGA    P   107_A      D     117          3.733
LGA    A   108_A      E     118          2.883
LGA    R   109_A      V     119          1.529
LGA    I   110_A      P     120          1.168
LGA    A   111_A      L     121          1.274
LGA    X   112_A      A     122          2.206
LGA    W   113_A      I     123          2.080
LGA    Q   114_A      A     124          3.254
LGA    E   115_A      R     125          4.280
LGA    -       -      Y     126           -
LGA    L   116_A      I     127          2.013
LGA    -       -      A     128           -
LGA    -       -      R     129           -
LGA    S   117_A      Y     130           #
LGA    D   118_A      P     131           #
LGA    A   119_A      K     132          3.645
LGA    A   120_A      A     133          1.605
LGA    R   121_A      K     134          3.409
LGA    L   122_A      L     135          2.278
LGA    Q   123_A      Y     136          2.096
LGA    -       -      L     137           -
LGA    F   124_A      S     138          4.293
LGA    G   125_A      L     139          2.637
LGA    W   126_A      -       -           -
LGA    P   127_A      -       -           -
LGA    Y   128_A      -       -           -
LGA    P   129_A      -       -           -
LGA    G   130_A      -       -           -
LGA    K   131_A      -       -           -
LGA    P   132_A      -       -           -
LGA    R   133_A      -       -           -
LGA    I   134_A      -       -           -
LGA    K   135_A      -       -           -
LGA    E   136_A      -       -           -
LGA    S   137_A      -       -           -
LGA    G   138_A      -       -           -
LGA    A   139_A      -       -           -
LGA    F   140_A      -       -           -
LGA    E   141_A      -       -           -
LGA    P   142_A      -       -           -
LGA    S   143_A      -       -           -
LGA    P   144_A      -       -           -
LGA    P   145_A      -       -           -
LGA    D   146_A      -       -           -
LGA    P   147_A      -       -           -
LGA    I   148_A      -       -           -
LGA    E   149_A      -       -           -
LGA    P   150_A      -       -           -
LGA    V   151_A      -       -           -
LGA    P   152_A      P     140           #
LGA    N   153_A      D     141          1.339
LGA    F   154_A      T     142          1.821
LGA    C   155_A      R     143          1.728
LGA    L   156_A      L     144          1.499
LGA    L   157_A      Y     145          1.481
LGA    L   158_A      R     146          0.787
LGA    L   159_A      L     147          0.877
LGA    D   160_A      R     148          2.132
LGA    P   161_A      T     149          1.728
LGA    V   162_A      E     150          1.912
LGA    Q   163_A      G     151          1.451
LGA    V   164_A      V     152          1.455
LGA    D   165_A      Q     153          1.200
LGA    H   166_A      I     154          1.065
LGA    L   167_A      N     155          1.162
LGA    E   168_A      G     156          1.883
LGA    L   169_A      -       -           -
LGA    R   170_A      -       -           -
LGA    G   171_A      -       -           -
LGA    E   172_A      -       -           -
LGA    P   173_A      -       -           -
LGA    Q   174_A      -       -           -
LGA    N   175_A      -       -           -
LGA    R   176_A      -       -           -
LGA    W   177_A      S     163          1.746
LGA    L   178_A      N     164          3.476
LGA    Y   179_A      I     165          1.844
LGA    H   180_A      T     166          3.119
LGA    R   181_A      P     167          4.334
LGA    N   182_A      -       -           -
LGA    D   183_A      -       -           -
LGA    Q   184_A      -       -           -
LGA    Q   185_A      -       -           -
LGA    E   186_A      A     168          5.171
LGA    W   187_A      D     169          5.017
LGA    S   188_A      L     170           -
LGA    S   189_A      R     171           -
LGA    E   190_A      T     172           -
LGA    A   191_A      D     173           -
LGA    I   192_A      L     174           -
LGA    N   193_A      S     175           -
LGA    P   194_A      G     176           -
LGA    -       -      A     177           -
LGA    -       -      E     178           -
LGA    -       -      E     179           -
LGA    -       -      L     180           -
LGA    -       -      M     181           -
LGA    -       -      A     182           -
LGA    -       -      A     183           -
LGA    -       -      A     184           -
LGA    -       -      E     185           -
LGA    -       -      S     186           -
LGA    -       -      E     187           -
LGA    -       -      A     188           -
LGA    -       -      T     189           -
LGA    -       -      R     190           -
LGA    -       -      L     191           -
LGA    -       -      N     192           -
LGA    -       -      A     193           -
LGA    -       -      I     194           -
LGA    -       -      K     195           -
LGA    -       -      G     196           -
LGA    -       -      E     197           -
LGA    -       -      A     198           -
LGA    -       -      S     199           -
LGA    -       -      R     200           -
LGA    -       -      L     201           -
LGA    -       -      A     202           -
LGA    -       -      V     203           -
LGA    -       -      L     204           -
LGA    -       -      A     205           -
LGA    -       -      G     206           -
LGA    -       -      A     207           -
LGA    -       -      K     208           -
LGA    -       -      T     209           -
LGA    -       -      G     210           -
LGA    -       -      R     211           -
LGA    -       -      W     212           -
LGA    -       -      K     213           -
LGA    -       -      I     214           -
LGA    -       -      T     215           -
LGA    -       -      S     216           -
LGA    -       -      I     217           -
LGA    -       -      D     218           -
LGA    -       -      P     219           -
LGA    -       -      D     220           -
LGA    -       -      G     221           -
LGA    -       -      I     222           -
LGA    -       -      D     223           -
LGA    -       -      L     224           -
LGA    -       -      A     225           -
LGA    -       -      S     226           -
LGA    -       -      A     227           -
LGA    -       -      S     228           -
LGA    -       -      D     229           -
LGA    -       -      L     230           -
LGA    -       -      A     231           -
LGA    -       -      R     232           -
LGA    -       -      L     233           -
LGA    -       -      W     234           -
LGA    -       -      F     235           -
LGA    -       -      A     236           -
LGA    -       -      E     237           -
LGA    -       -      R     238           -
LGA    -       -      V     239           -
LGA    -       -      E     240           -
LGA    -       -      T     241           -
LGA    -       -      L     242           -
LGA    -       -      K     243           -
LGA    -       -      Q     244           -
LGA    -       -      F     245           -
LGA    -       -      E     246           -
LGA    -       -      K     247           -
LGA    -       -      A     248           -
LGA    -       -      L     249           -
LGA    -       -      A     250           -
LGA    -       -      Q     251           -
LGA    -       -      L     252           -
LGA    -       -      L     253           -
LGA    -       -      K     254           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  194  234    5.0    119    2.24    14.29     40.047     5.076

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.363401 * X  +   0.491329 * Y  +   0.791540 * Z  + -40.503899
  Y_new =   0.179123 * X  +   0.796926 * Y  +  -0.576908 * Z  +  -7.754915
  Z_new =  -0.914251 * X  +   0.351432 * Y  +   0.201596 * Z  +  33.065884 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.049985   -2.091608  [ DEG:    60.1597   -119.8403 ]
  Theta =   1.153655    1.987938  [ DEG:    66.0996    113.9004 ]
  Phi   =   0.457958   -2.683635  [ DEG:    26.2390   -153.7610 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2i51_A                                        
REMARK     2: T0506.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2i51_A.T0506.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  194  234   5.0  119   2.24   14.29  40.047
REMARK  ---------------------------------------------------------- 
MOLECULE 2i51_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   23-AUG-06   2I51              
TITLE     CRYSTAL STRUCTURE OF UNCHARACTERIZED CONSERVED PROTEIN OF             
TITLE    2 COG5135 (ZP_00109616.1) FROM NOSTOC PUNCTIFORME PCC 73102            
TITLE    3 AT 1.40 A RESOLUTION                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED CONSERVED PROTEIN OF COG5135;              
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: NOSTOC PUNCTIFORME PCC 73102;                   
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: ZP_00109616.1;                                                 
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    ZP_00109616.1, UNCHARACTERIZED CONSERVED PROTEIN OF COG5135,          
KEYWDS   2 STRUCTURAL GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS,           
KEYWDS   3 JCSG, PROTEIN STRUCTURE INITIATIVE, PSI2                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   05-SEP-06 2I51    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF UNCHARACTERIZED CONSERVED               
JRNL        TITL 2 PROTEIN OF COG5135 (ZP_00109616.1) FROM NOSTOC               
JRNL        TITL 3 PUNCTIFORME PCC 73102 AT 1.40 A RESOLUTION                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.40 ANGSTROMS.                                          
DBREF  2I51 A    1   181  UNP    Q8YQ04   Q8YQ04_ANASP     1    181             
DBREF  2I51 B    1   181  UNP    Q8YQ04   Q8YQ04_ANASP     1    181             
SEQRES   1 A  195  GLY MSE SER LEU ALA PRO TRP ARG GLY ALA ILE ALA HIS          
SEQRES   2 A  195  ALA LEU HIS ARG ASN ARG SER LEU VAL TYR ALA ARG TYR          
SEQRES   3 A  195  LEU GLN LEU ALA THR VAL GLN PRO ASN GLY ARG PRO ALA          
SEQRES   4 A  195  ASN ARG THR LEU VAL PHE ARG GLY PHE LEU GLU ASP THR          
SEQRES   5 A  195  ASN GLN LEU ARG PHE ILE THR ASP THR ARG SER ALA LYS          
SEQRES   6 A  195  ALA ASP GLN ILE GLN GLN GLN PRO TRP ALA GLU ILE CYS          
SEQRES   7 A  195  TRP TYR PHE PRO ASN THR ARG GLU GLN PHE ARG MSE ALA          
SEQRES   8 A  195  GLY ASP LEU THR LEU ILE SER SER ASP ASP SER HIS GLN          
SEQRES   9 A  195  ASP LEU GLN PRO ALA ARG ILE ALA MSE TRP GLN GLU LEU          
SEQRES  10 A  195  SER ASP ALA ALA ARG LEU GLN PHE GLY TRP PRO TYR PRO          
SEQRES  11 A  195  GLY LYS PRO ARG ILE LYS GLU SER GLY ALA PHE GLU PRO          
SEQRES  12 A  195  SER PRO PRO ASP PRO ILE GLU PRO VAL PRO ASN PHE CYS          
SEQRES  13 A  195  LEU LEU LEU LEU ASP PRO VAL GLN VAL ASP HIS LEU GLU          
SEQRES  14 A  195  LEU ARG GLY GLU PRO GLN ASN ARG TRP LEU TYR HIS ARG          
SEQRES  15 A  195  ASN ASP GLN GLN GLU TRP SER SER GLU ALA ILE ASN PRO          
SEQRES   1 B  195  GLY MSE SER LEU ALA PRO TRP ARG GLY ALA ILE ALA HIS          
SEQRES   2 B  195  ALA LEU HIS ARG ASN ARG SER LEU VAL TYR ALA ARG TYR          
SEQRES   3 B  195  LEU GLN LEU ALA THR VAL GLN PRO ASN GLY ARG PRO ALA          
SEQRES   4 B  195  ASN ARG THR LEU VAL PHE ARG GLY PHE LEU GLU ASP THR          
SEQRES   5 B  195  ASN GLN LEU ARG PHE ILE THR ASP THR ARG SER ALA LYS          
SEQRES   6 B  195  ALA ASP GLN ILE GLN GLN GLN PRO TRP ALA GLU ILE CYS          
SEQRES   7 B  195  TRP TYR PHE PRO ASN THR ARG GLU GLN PHE ARG MSE ALA          
SEQRES   8 B  195  GLY ASP LEU THR LEU ILE SER SER ASP ASP SER HIS GLN          
SEQRES   9 B  195  ASP LEU GLN PRO ALA ARG ILE ALA MSE TRP GLN GLU LEU          
SEQRES  10 B  195  SER ASP ALA ALA ARG LEU GLN PHE GLY TRP PRO TYR PRO          
SEQRES  11 B  195  GLY LYS PRO ARG ILE LYS GLU SER GLY ALA PHE GLU PRO          
SEQRES  12 B  195  SER PRO PRO ASP PRO ILE GLU PRO VAL PRO ASN PHE CYS          
SEQRES  13 B  195  LEU LEU LEU LEU ASP PRO VAL GLN VAL ASP HIS LEU GLU          
SEQRES  14 B  195  LEU ARG GLY GLU PRO GLN ASN ARG TRP LEU TYR HIS ARG          
SEQRES  15 B  195  ASN ASP GLN GLN GLU TRP SER SER GLU ALA ILE ASN PRO          
HET    MSE  A   1       5                                                       
HET    MSE  A  89      13                                                       
HET    MSE  A 112       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  89      13                                                       
HET    MSE  B 112       8                                                       
HET    FMN  A 300      31                                                       
HET    FMN  B 300      31                                                       
HET    EDO      2       4                                                       
HET    EDO      3       4                                                       
HET    EDO      4       4                                                       
HET    EDO      5       4                                                       
HET    EDO      6       6                                                       
HET    EDO      7       8                                                       
HET    EDO      8       4                                                       
HET    EDO      9       4                                                       
HET    EDO     10       4                                                       
HET    EDO     11       4                                                       
HET    EDO     12       4                                                       
HET    EDO     13       4                                                       
HET    EDO     14       4                                                       
HET    EDO     15       4                                                       
HET    EDO     16       4                                                       
HET    EDO     17       4                                                       
HET    EDO     18       4                                                       
HET    EDO     19       4                                                       
HET    EDO     20       4                                                       
HET    EDO     21       4                                                       
HET    GOL      1       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     FMN FLAVIN MONONUCLEOTIDE                                            
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETNAM     GOL GLYCEROL                                                         
HETSYN     FMN RIBOFLAVIN MONOPHOSPHATE                                         
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   3  FMN    2(C17 H21 N4 O9 P)                                           
FORMUL   5  EDO    20(C2 H6 O2)                                                 
FORMUL  25  GOL    C3 H8 O3                                                     
FORMUL  26  HOH   *359(H2 O)                                                    
CRYST1   65.647   65.928  112.380  90.00  90.00  90.00 P 21 21 21    8          
HETATM    1  N   MSE A   1       5.415  58.132  -2.511  1.00 49.89           N  
HETATM    2  CA  MSE A   1       4.431  57.699  -3.555  1.00 48.25           C  
HETATM    3  C   MSE A   1       5.159  57.056  -4.732  1.00 45.22           C  
HETATM    4  O   MSE A   1       4.728  56.013  -5.237  1.00 50.28           O  
HETATM    5  CB  MSE A   1       3.561  58.867  -4.036  1.00 49.10           C  
ATOM      6  N   SER A   2       6.246  57.664  -5.191  1.00 35.95           N  
ATOM      7  CA  SER A   2       7.113  56.954  -6.129  1.00 31.21           C  
ATOM      8  C   SER A   2       8.026  56.037  -5.290  1.00 23.45           C  
ATOM      9  O   SER A   2       8.319  56.333  -4.119  1.00 20.56           O  
ATOM     10  CB  SER A   2       7.912  57.900  -7.006  1.00 34.13           C  
ATOM     11  OG  SER A   2       9.004  58.459  -6.326  1.00 40.99           O  
ATOM     12  N   LEU A   3       8.393  54.907  -5.873  1.00 20.63           N  
ATOM     13  CA  LEU A   3       9.271  53.959  -5.178  0.50 19.77           C  
ATOM     15  C   LEU A   3      10.641  54.582  -4.959  1.00 18.44           C  
ATOM     16  O   LEU A   3      11.263  55.136  -5.857  1.00 18.85           O  
ATOM     17  CB  LEU A   3       9.395  52.626  -5.952  0.50 22.46           C  
ATOM     19  CG  LEU A   3       8.225  51.633  -5.823  0.50 18.32           C  
ATOM     21  CD1 LEU A   3       8.216  50.568  -6.941  0.50 18.91           C  
ATOM     23  CD2 LEU A   3       8.230  50.951  -4.464  0.50 19.69           C  
ATOM     25  N   ALA A   4      11.131  54.479  -3.735  1.00 15.15           N  
ATOM     26  CA  ALA A   4      12.448  54.990  -3.432  1.00 16.31           C  
ATOM     27  C   ALA A   4      13.482  54.158  -4.169  1.00 15.65           C  
ATOM     28  O   ALA A   4      13.291  52.962  -4.428  1.00 15.30           O  
ATOM     29  CB  ALA A   4      12.679  54.918  -1.911  1.00 18.14           C  
ATOM     30  N   PRO A   5      14.624  54.764  -4.515  1.00 16.77           N  
ATOM     31  CA  PRO A   5      15.596  54.123  -5.392  1.00 17.79           C  
ATOM     32  C   PRO A   5      16.343  52.945  -4.800  1.00 16.35           C  
ATOM     33  O   PRO A   5      17.021  52.232  -5.522  1.00 18.15           O  
ATOM     34  CB  PRO A   5      16.572  55.274  -5.701  1.00 18.98           C  
ATOM     35  CG  PRO A   5      16.450  56.190  -4.575  1.00 20.71           C  
ATOM     36  CD  PRO A   5      14.984  56.173  -4.258  1.00 19.33           C  
ATOM     37  N   TRP A   6      16.220  52.747  -3.498  1.00 15.29           N  
ATOM     38  CA  TRP A   6      16.815  51.627  -2.788  1.00 14.25           C  
ATOM     39  C   TRP A   6      15.834  50.479  -2.609  1.00 14.16           C  
ATOM     40  O   TRP A   6      16.207  49.424  -2.070  1.00 14.66           O  
ATOM     41  CB  TRP A   6      17.376  52.037  -1.399  1.00 14.79           C  
ATOM     42  CG  TRP A   6      16.468  52.967  -0.630  1.00 14.87           C  
ATOM     43  CD1 TRP A   6      16.576  54.310  -0.568  1.00 15.85           C  
ATOM     44  CD2 TRP A   6      15.291  52.623   0.131  1.00 15.27           C  
ATOM     45  NE1 TRP A   6      15.566  54.829   0.171  1.00 15.33           N  
ATOM     46  CE2 TRP A   6      14.749  53.836   0.620  1.00 14.61           C  
ATOM     47  CE3 TRP A   6      14.663  51.423   0.475  1.00 15.97           C  
ATOM     48  CZ2 TRP A   6      13.601  53.868   1.426  1.00 16.43           C  
ATOM     49  CZ3 TRP A   6      13.519  51.449   1.242  1.00 16.80           C  
ATOM     50  CH2 TRP A   6      12.987  52.683   1.706  1.00 15.69           C  
ATOM     51  N   ARG A   7      14.605  50.636  -3.108  1.00 13.42           N  
ATOM     52  CA  ARG A   7      13.619  49.582  -2.930  1.00 12.19           C  
ATOM     53  C   ARG A   7      13.979  48.309  -3.697  1.00 13.31           C  
ATOM     54  O   ARG A   7      13.761  47.201  -3.185  1.00 14.64           O  
ATOM     55  CB  ARG A   7      12.210  50.040  -3.293  1.00 13.74           C  
ATOM     56  CG  ARG A   7      11.609  50.975  -2.278  1.00 14.12           C  
ATOM     57  CD  ARG A   7      11.113  50.289  -1.075  1.00 15.16           C  
ATOM     58  NE  ARG A   7      10.014  49.322  -1.249  1.00 13.37           N  
ATOM     59  CZ  ARG A   7       8.723  49.642  -1.192  1.00 14.22           C  
ATOM     60  NH1 ARG A   7       8.335  50.898  -1.050  1.00 15.51           N  
ATOM     61  NH2 ARG A   7       7.792  48.699  -1.262  1.00 17.69           N  
ATOM     62  N   GLY A   8      14.528  48.447  -4.889  1.00 12.49           N  
ATOM     63  CA  GLY A   8      14.968  47.281  -5.617  1.00 13.55           C  
ATOM     64  C   GLY A   8      16.063  46.512  -4.918  1.00 14.01           C  
ATOM     65  O   GLY A   8      16.052  45.268  -4.895  1.00 14.86           O  
ATOM     66  N   ALA A   9      16.989  47.243  -4.296  1.00 14.88           N  
ATOM     67  CA  ALA A   9      18.092  46.625  -3.554  1.00 14.54           C  
ATOM     68  C   ALA A   9      17.532  45.809  -2.400  1.00 12.66           C  
ATOM     69  O   ALA A   9      17.974  44.655  -2.118  1.00 13.24           O  
ATOM     70  CB  ALA A   9      19.102  47.694  -3.056  1.00 17.42           C  
ATOM     71  N   ILE A  10      16.588  46.389  -1.662  1.00 12.84           N  
ATOM     72  CA  ILE A  10      15.949  45.679  -0.566  0.50 11.83           C  
ATOM     74  C   ILE A  10      15.225  44.424  -1.062  1.00 13.99           C  
ATOM     75  O   ILE A  10      15.297  43.365  -0.459  1.00 14.54           O  
ATOM     76  CB  ILE A  10      14.928  46.590   0.217  0.50 11.81           C  
ATOM     78  CG1 ILE A  10      15.758  47.528   1.121  0.50 13.37           C  
ATOM     80  CG2 ILE A  10      13.917  45.752   1.067  0.50  9.96           C  
ATOM     82  CD1 ILE A  10      16.346  46.864   2.335  0.50 11.74           C  
ATOM     84  N   ALA A  11      14.493  44.565  -2.188  1.00 13.80           N  
ATOM     85  CA  ALA A  11      13.776  43.419  -2.714  1.00 14.19           C  
ATOM     86  C   ALA A  11      14.728  42.299  -3.079  1.00 14.17           C  
ATOM     87  O   ALA A  11      14.452  41.128  -2.856  1.00 14.32           O  
ATOM     88  CB  ALA A  11      12.952  43.836  -3.939  1.00 14.56           C  
ATOM     89  N   HIS A  12      15.856  42.660  -3.671  1.00 12.77           N  
ATOM     90  CA  HIS A  12      16.870  41.646  -4.092  1.00 12.23           C  
ATOM     91  C   HIS A  12      17.511  41.016  -2.872  1.00 13.91           C  
ATOM     92  O   HIS A  12      17.834  39.820  -2.908  1.00 14.57           O  
ATOM     93  CB  HIS A  12      17.888  42.315  -5.013  1.00 13.79           C  
ATOM     94  CG  HIS A  12      18.806  41.354  -5.700  1.00 13.27           C  
ATOM     95  ND1 HIS A  12      20.137  41.613  -5.989  1.00 21.18           N  
ATOM     96  CD2 HIS A  12      18.503  40.203  -6.336  1.00 11.19           C  
ATOM     97  CE1 HIS A  12      20.622  40.601  -6.708  1.00 13.26           C  
ATOM     98  NE2 HIS A  12      19.646  39.736  -6.915  1.00 17.64           N  
ATOM     99  N   ALA A  13      17.740  41.764  -1.805  1.00 13.98           N  
ATOM    100  CA  ALA A  13      18.289  41.188  -0.579  1.00 13.08           C  
ATOM    101  C   ALA A  13      17.288  40.241   0.067  1.00 13.66           C  
ATOM    102  O   ALA A  13      17.625  39.097   0.420  1.00 13.95           O  
ATOM    103  CB  ALA A  13      18.702  42.314   0.392  1.00 13.08           C  
ATOM    104  N   LEU A  14      16.032  40.678   0.161  1.00 12.54           N  
ATOM    105  CA  LEU A  14      15.012  39.816   0.774  1.00 14.17           C  
ATOM    106  C   LEU A  14      14.876  38.518  -0.016  1.00 14.56           C  
ATOM    107  O   LEU A  14      14.842  37.420   0.551  1.00 15.45           O  
ATOM    108  CB  LEU A  14      13.657  40.538   0.807  1.00 14.45           C  
ATOM    109  CG  LEU A  14      13.554  41.618   1.874  1.00 15.71           C  
ATOM    110  CD1 LEU A  14      12.389  42.551   1.553  1.00 17.56           C  
ATOM    111  CD2 LEU A  14      13.420  40.989   3.277  1.00 16.11           C  
ATOM    112  N   HIS A  15      14.817  38.596  -1.336  1.00 14.60           N  
ATOM    113  CA  HIS A  15      14.663  37.414  -2.135  1.00 13.04           C  
ATOM    114  C   HIS A  15      15.824  36.432  -1.972  1.00 13.03           C  
ATOM    115  O   HIS A  15      15.626  35.218  -1.842  1.00 14.86           O  
ATOM    116  CB  HIS A  15      14.416  37.796  -3.590  1.00 13.76           C  
ATOM    117  CG  HIS A  15      14.191  36.635  -4.477  1.00 15.34           C  
ATOM    118  ND1 HIS A  15      13.102  35.801  -4.323  1.00 16.55           N  
ATOM    119  CD2 HIS A  15      14.912  36.158  -5.516  1.00 15.52           C  
ATOM    120  CE1 HIS A  15      13.181  34.840  -5.245  1.00 18.15           C  
ATOM    121  NE2 HIS A  15      14.273  35.030  -5.974  1.00 18.17           N  
ATOM    122  N   ARG A  16      17.048  36.942  -2.005  1.00 14.13           N  
ATOM    123  CA  ARG A  16      18.222  36.086  -1.958  1.00 13.52           C  
ATOM    124  C   ARG A  16      18.498  35.571  -0.568  1.00 16.73           C  
ATOM    125  O   ARG A  16      19.326  34.671  -0.410  1.00 19.78           O  
ATOM    126  CB  ARG A  16      19.437  36.814  -2.498  1.00 14.37           C  
ATOM    127  CG  ARG A  16      19.420  37.034  -3.969  1.00 13.67           C  
ATOM    128  CD  ARG A  16      20.689  37.660  -4.441  1.00 15.08           C  
ATOM    129  NE  ARG A  16      20.806  38.967  -3.825  1.00 19.17           N  
ATOM    130  CZ  ARG A  16      21.859  39.762  -3.878  1.00 23.12           C  
ATOM    131  NH1 ARG A  16      22.920  39.441  -4.579  1.00 20.81           N  
ATOM    132  NH2 ARG A  16      21.802  40.929  -3.235  1.00 24.38           N  
ATOM    133  N   ASN A  17      17.783  36.065   0.420  1.00 14.39           N  
ATOM    134  CA  ASN A  17      17.886  35.592   1.806  1.00 15.94           C  
ATOM    135  C   ASN A  17      16.641  34.862   2.303  1.00 18.56           C  
ATOM    136  O   ASN A  17      16.517  34.598   3.500  1.00 17.77           O  
ATOM    137  CB  ASN A  17      18.269  36.735   2.761  1.00 15.87           C  
ATOM    138  CG  ASN A  17      19.680  37.189   2.577  1.00 16.62           C  
ATOM    139  OD1 ASN A  17      20.555  36.799   3.358  1.00 21.72           O  
ATOM    140  ND2 ASN A  17      19.948  37.993   1.571  1.00 15.32           N  
ATOM    141  N   ARG A  18      15.725  34.515   1.404  1.00 16.71           N  
ATOM    142  CA  ARG A  18      14.425  33.974   1.773  1.00 19.09           C  
ATOM    143  C   ARG A  18      14.532  32.604   2.474  1.00 18.23           C  
ATOM    144  O   ARG A  18      13.550  32.246   3.149  1.00 21.86           O  
ATOM    145  CB  ARG A  18      13.527  33.899   0.548  1.00 19.26           C  
ATOM    146  CG  ARG A  18      13.898  32.906  -0.459  1.00 19.50           C  
ATOM    147  CD  ARG A  18      13.019  33.067  -1.723  1.00 20.81           C  
ATOM    148  NE  ARG A  18      13.302  32.059  -2.715  1.00 22.90           N  
ATOM    149  CZ  ARG A  18      14.364  32.000  -3.495  1.00 24.30           C  
ATOM    150  NH1 ARG A  18      15.321  32.919  -3.489  1.00 19.05           N  
ATOM    151  NH2 ARG A  18      14.467  30.993  -4.361  1.00 34.63           N  
ATOM    152  N   SER A  19      15.655  31.904   2.338  1.00 17.98           N  
ATOM    153  CA  SER A  19      15.836  30.572   2.989  1.00 20.51           C  
ATOM    154  C   SER A  19      16.070  30.763   4.492  1.00 21.23           C  
ATOM    155  O   SER A  19      16.022  29.778   5.245  1.00 22.89           O  
ATOM    156  CB  SER A  19      17.000  29.811   2.393  1.00 19.44           C  
ATOM    157  OG  SER A  19      18.233  30.455   2.545  1.00 25.42           O  
ATOM    158  N   LEU A  20      16.393  31.989   4.916  1.00 19.62           N  
ATOM    159  CA  LEU A  20      16.680  32.276   6.337  1.00 18.99           C  
ATOM    160  C   LEU A  20      15.549  33.056   6.949  1.00 18.15           C  
ATOM    161  O   LEU A  20      15.345  34.241   6.613  1.00 19.39           O  
ATOM    162  CB  LEU A  20      17.964  33.039   6.464  1.00 19.07           C  
ATOM    163  CG  LEU A  20      19.199  32.499   5.754  1.00 20.77           C  
ATOM    164  CD1 LEU A  20      20.349  33.506   5.918  1.00 24.39           C  
ATOM    165  CD2 LEU A  20      19.603  31.105   6.262  1.00 22.63           C  
ATOM    166  N   VAL A  21      14.800  32.440   7.866  1.00 19.31           N  
ATOM    167  CA  VAL A  21      13.676  33.137   8.501  1.00 19.75           C  
ATOM    168  C   VAL A  21      14.126  34.463   9.132  1.00 17.74           C  
ATOM    169  O   VAL A  21      13.435  35.501   9.097  1.00 20.05           O  
ATOM    170  CB  VAL A  21      12.988  32.273   9.589  1.00 26.27           C  
ATOM    171  CG1 VAL A  21      11.918  33.094  10.370  1.00 30.90           C  
ATOM    172  CG2 VAL A  21      12.366  31.035   8.956  1.00 29.93           C  
ATOM    173  N   TYR A  22      15.320  34.408   9.712  1.00 17.56           N  
ATOM    174  CA  TYR A  22      15.877  35.508  10.444  1.00 17.54           C  
ATOM    175  C   TYR A  22      16.465  36.660   9.617  1.00 16.64           C  
ATOM    176  O   TYR A  22      16.944  37.667  10.134  1.00 19.29           O  
ATOM    177  CB  TYR A  22      16.927  34.994  11.440  1.00 19.69           C  
ATOM    178  CG  TYR A  22      17.941  34.015  10.890  1.00 18.06           C  
ATOM    179  CD1 TYR A  22      19.113  34.472  10.342  1.00 16.88           C  
ATOM    180  CD2 TYR A  22      17.744  32.644  10.985  1.00 18.26           C  
ATOM    181  CE1 TYR A  22      20.045  33.607   9.887  1.00 16.95           C  
ATOM    182  CE2 TYR A  22      18.709  31.763  10.600  1.00 16.89           C  
ATOM    183  CZ  TYR A  22      19.851  32.229  10.030  1.00 17.47           C  
ATOM    184  OH  TYR A  22      20.820  31.313   9.611  1.00 19.37           O  
ATOM    185  N   ALA A  23      16.446  36.519   8.307  1.00 16.10           N  
ATOM    186  CA  ALA A  23      16.853  37.625   7.445  1.00 17.38           C  
ATOM    187  C   ALA A  23      15.804  38.740   7.482  1.00 16.78           C  
ATOM    188  O   ALA A  23      16.078  39.815   6.991  1.00 19.10           O  
ATOM    189  CB  ALA A  23      17.049  37.158   6.033  1.00 20.70           C  
ATOM    190  N   ARG A  24      14.622  38.479   8.047  1.00 16.12           N  
ATOM    191  CA  ARG A  24      13.614  39.516   8.259  1.00 16.50           C  
ATOM    192  C   ARG A  24      13.715  40.127   9.658  1.00 15.58           C  
ATOM    193  O   ARG A  24      12.867  40.945  10.029  1.00 18.28           O  
ATOM    194  CB  ARG A  24      12.244  39.014   7.944  1.00 21.85           C  
ATOM    195  CG  ARG A  24      12.148  38.741   6.393  1.00 26.06           C  
ATOM    196  CD  ARG A  24      10.893  38.065   6.003  1.00 33.43           C  
ATOM    197  NE  ARG A  24       9.782  38.963   6.240  1.00 31.94           N  
ATOM    198  CZ  ARG A  24       9.197  39.747   5.328  1.00 34.90           C  
ATOM    199  NH1 ARG A  24       9.586  39.747   4.056  1.00 30.55           N  
ATOM    200  NH2 ARG A  24       8.186  40.534   5.706  1.00 35.97           N  
ATOM    201  N   TYR A  25      14.780  39.840  10.388  1.00 14.72           N  
ATOM    202  CA  TYR A  25      14.987  40.431  11.695  1.00 14.80           C  
ATOM    203  C   TYR A  25      16.010  41.551  11.559  1.00 16.03           C  
ATOM    204  O   TYR A  25      17.041  41.411  10.868  1.00 17.77           O  
ATOM    205  CB  TYR A  25      15.517  39.414  12.691  1.00 15.18           C  
ATOM    206  CG  TYR A  25      14.679  38.208  12.929  1.00 14.89           C  
ATOM    207  CD1 TYR A  25      13.366  38.144  12.553  1.00 17.04           C  
ATOM    208  CD2 TYR A  25      15.243  37.099  13.524  1.00 16.60           C  
ATOM    209  CE1 TYR A  25      12.623  36.961  12.760  1.00 20.36           C  
ATOM    210  CE2 TYR A  25      14.538  35.964  13.739  1.00 16.60           C  
ATOM    211  CZ  TYR A  25      13.243  35.898  13.367  1.00 18.93           C  
ATOM    212  OH  TYR A  25      12.509  34.714  13.580  1.00 21.86           O  
ATOM    213  N   LEU A  26      15.748  42.694  12.173  1.00 14.58           N  
ATOM    214  CA  LEU A  26      16.634  43.837  12.051  1.00 13.59           C  
ATOM    215  C   LEU A  26      16.712  44.543  13.397  1.00 14.70           C  
ATOM    216  O   LEU A  26      15.886  44.309  14.303  1.00 14.33           O  
ATOM    217  CB  LEU A  26      16.192  44.760  10.919  1.00 15.24           C  
ATOM    218  CG  LEU A  26      14.776  45.331  10.965  1.00 14.81           C  
ATOM    219  CD1 LEU A  26      14.685  46.430  12.049  1.00 16.29           C  
ATOM    220  CD2 LEU A  26      14.352  45.899   9.546  1.00 16.23           C  
ATOM    221  N   GLN A  27      17.676  45.425  13.568  1.00 14.53           N  
ATOM    222  CA  GLN A  27      17.908  46.098  14.841  1.00 13.88           C  
ATOM    223  C   GLN A  27      17.528  47.557  14.784  1.00 14.70           C  
ATOM    224  O   GLN A  27      18.054  48.301  13.914  1.00 16.13           O  
ATOM    225  CB  GLN A  27      19.359  45.902  15.299  1.00 15.01           C  
ATOM    226  CG  GLN A  27      19.680  44.470  15.699  1.00 14.02           C  
ATOM    227  CD  GLN A  27      19.708  43.482  14.585  1.00 16.50           C  
ATOM    228  OE1 GLN A  27      20.228  43.778  13.491  1.00 16.84           O  
ATOM    229  NE2 GLN A  27      19.109  42.291  14.808  1.00 17.08           N  
ATOM    230  N   LEU A  28      16.665  47.978  15.703  1.00 13.59           N  
ATOM    231  CA  LEU A  28      16.202  49.364  15.711  1.00 14.39           C  
ATOM    232  C   LEU A  28      16.833  50.083  16.885  1.00 13.58           C  
ATOM    233  O   LEU A  28      16.622  49.739  18.073  1.00 14.94           O  
ATOM    234  CB  LEU A  28      14.692  49.405  15.915  1.00 16.96           C  
ATOM    235  CG  LEU A  28      14.094  50.814  16.162  1.00 17.48           C  
ATOM    236  CD1 LEU A  28      13.940  51.439  14.829  1.00 26.65           C  
ATOM    237  CD2 LEU A  28      12.770  50.737  16.964  1.00 22.13           C  
ATOM    238  N   ALA A  29      17.586  51.151  16.572  1.00 12.61           N  
ATOM    239  CA  ALA A  29      18.193  51.985  17.586  1.00 12.98           C  
ATOM    240  C   ALA A  29      17.376  53.249  17.776  1.00 15.20           C  
ATOM    241  O   ALA A  29      17.025  53.929  16.824  1.00 15.38           O  
ATOM    242  CB  ALA A  29      19.652  52.382  17.161  1.00 16.09           C  
ATOM    243  N   THR A  30      17.146  53.587  19.035  1.00 13.90           N  
ATOM    244  CA  THR A  30      16.496  54.806  19.436  1.00 16.10           C  
ATOM    245  C   THR A  30      17.367  55.501  20.483  1.00 16.67           C  
ATOM    246  O   THR A  30      18.436  54.982  20.859  1.00 14.74           O  
ATOM    247  CB  THR A  30      15.111  54.486  20.097  1.00 14.92           C  
ATOM    248  OG1 THR A  30      15.302  53.511  21.162  1.00 16.29           O  
ATOM    249  CG2 THR A  30      14.091  54.001  19.099  1.00 16.82           C  
ATOM    250  N   VAL A  31      16.957  56.702  20.917  1.00 16.55           N  
ATOM    251  CA  VAL A  31      17.656  57.416  21.980  1.00 16.89           C  
ATOM    252  C   VAL A  31      16.699  57.551  23.157  1.00 16.11           C  
ATOM    253  O   VAL A  31      15.479  57.856  22.992  1.00 19.16           O  
ATOM    254  CB  VAL A  31      18.217  58.797  21.518  1.00 20.08           C  
ATOM    255  CG1 VAL A  31      19.093  59.465  22.609  1.00 20.53           C  
ATOM    256  CG2 VAL A  31      19.082  58.650  20.320  1.00 26.32           C  
ATOM    257  N   GLN A  32      17.218  57.290  24.359  1.00 16.16           N  
ATOM    258  CA  GLN A  32      16.439  57.434  25.578  1.00 19.54           C  
ATOM    259  C   GLN A  32      16.361  58.914  25.991  1.00 18.73           C  
ATOM    260  O   GLN A  32      17.180  59.724  25.573  1.00 19.26           O  
ATOM    261  CB  GLN A  32      17.057  56.595  26.687  1.00 19.56           C  
ATOM    262  CG  GLN A  32      17.153  55.122  26.322  1.00 21.46           C  
ATOM    263  CD  GLN A  32      17.929  54.313  27.339  1.00 26.37           C  
ATOM    264  OE1 GLN A  32      17.517  54.184  28.513  1.00 32.11           O  
ATOM    265  NE2 GLN A  32      19.076  53.804  26.929  1.00 22.18           N  
ATOM    266  N   PRO A  33      15.361  59.268  26.809  1.00 19.66           N  
ATOM    267  CA  PRO A  33      15.304  60.614  27.380  1.00 23.31           C  
ATOM    268  C   PRO A  33      16.609  61.052  28.051  1.00 23.68           C  
ATOM    269  O   PRO A  33      16.942  62.250  28.044  1.00 25.27           O  
ATOM    270  CB  PRO A  33      14.163  60.520  28.400  1.00 23.67           C  
ATOM    271  CG  PRO A  33      13.279  59.425  27.872  1.00 24.37           C  
ATOM    272  CD  PRO A  33      14.174  58.458  27.148  1.00 21.34           C  
ATOM    273  N   ASN A  34      17.340  60.115  28.648  1.00 22.45           N  
ATOM    274  CA  ASN A  34      18.609  60.457  29.289  1.00 22.63           C  
ATOM    275  C   ASN A  34      19.792  60.627  28.304  1.00 23.67           C  
ATOM    276  O   ASN A  34      20.918  60.898  28.729  1.00 23.04           O  
ATOM    277  CB  ASN A  34      18.978  59.440  30.388  1.00 24.32           C  
ATOM    278  CG  ASN A  34      19.287  58.053  29.837  1.00 28.59           C  
ATOM    279  OD1 ASN A  34      19.405  57.850  28.620  1.00 21.32           O  
ATOM    280  ND2 ASN A  34      19.426  57.086  30.742  1.00 32.33           N  
ATOM    281  N   GLY A  35      19.536  60.482  27.005  1.00 20.19           N  
ATOM    282  CA  GLY A  35      20.541  60.744  25.979  1.00 20.35           C  
ATOM    283  C   GLY A  35      21.298  59.486  25.526  1.00 18.93           C  
ATOM    284  O   GLY A  35      22.117  59.529  24.626  1.00 21.91           O  
ATOM    285  N   ARG A  36      21.083  58.381  26.210  1.00 17.21           N  
ATOM    286  CA  ARG A  36      21.815  57.148  25.870  1.00 16.31           C  
ATOM    287  C   ARG A  36      21.049  56.379  24.775  1.00 15.67           C  
ATOM    288  O   ARG A  36      19.829  56.402  24.709  1.00 15.75           O  
ATOM    289  CB  ARG A  36      21.942  56.253  27.094  1.00 15.94           C  
ATOM    290  CG  ARG A  36      22.831  56.871  28.202  1.00 17.26           C  
ATOM    291  CD  ARG A  36      22.821  55.977  29.427  1.00 24.85           C  
ATOM    292  NE  ARG A  36      23.819  56.482  30.391  1.00 30.70           N  
ATOM    293  CZ  ARG A  36      24.037  56.002  31.615  1.00 37.26           C  
ATOM    294  NH1 ARG A  36      23.329  54.989  32.105  1.00 36.55           N  
ATOM    295  NH2 ARG A  36      24.983  56.556  32.357  1.00 40.33           N  
ATOM    296  N   PRO A  37      21.759  55.620  23.935  1.00 14.94           N  
ATOM    297  CA  PRO A  37      21.120  54.828  22.880  1.00 14.78           C  
ATOM    298  C   PRO A  37      20.463  53.590  23.467  1.00 17.32           C  
ATOM    299  O   PRO A  37      20.774  53.142  24.579  1.00 17.62           O  
ATOM    300  CB  PRO A  37      22.301  54.434  22.006  1.00 15.70           C  
ATOM    301  CG  PRO A  37      23.423  54.367  22.965  1.00 18.20           C  
ATOM    302  CD  PRO A  37      23.223  55.445  23.946  1.00 17.81           C  
ATOM    303  N   ALA A  38      19.556  53.030  22.680  1.00 14.69           N  
ATOM    304  CA  ALA A  38      18.899  51.738  22.954  1.00 16.00           C  
ATOM    305  C   ALA A  38      18.807  51.020  21.631  1.00 15.89           C  
ATOM    306  O   ALA A  38      18.700  51.643  20.587  1.00 17.27           O  
ATOM    307  CB  ALA A  38      17.492  51.912  23.584  1.00 17.46           C  
ATOM    308  N   ASN A  39      18.885  49.715  21.673  1.00 12.94           N  
ATOM    309  CA  ASN A  39      18.986  48.921  20.454  1.00 13.35           C  
ATOM    310  C   ASN A  39      18.362  47.556  20.689  1.00 14.81           C  
ATOM    311  O   ASN A  39      18.745  46.876  21.620  1.00 16.07           O  
ATOM    312  CB  ASN A  39      20.467  48.782  20.124  1.00 14.40           C  
ATOM    313  CG  ASN A  39      20.749  48.422  18.666  1.00 16.91           C  
ATOM    314  OD1 ASN A  39      19.852  48.416  17.817  1.00 16.64           O  
ATOM    315  ND2 ASN A  39      22.067  48.149  18.372  1.00 17.16           N  
ATOM    316  N   ARG A  40      17.432  47.154  19.821  1.00 13.29           N  
ATOM    317  CA  ARG A  40      16.797  45.823  19.953  1.00 13.53           C  
ATOM    318  C   ARG A  40      16.330  45.313  18.632  1.00 13.01           C  
ATOM    319  O   ARG A  40      16.065  46.082  17.710  1.00 14.64           O  
ATOM    320  CB  ARG A  40      15.640  45.851  20.941  1.00 14.98           C  
ATOM    321  CG  ARG A  40      14.358  46.390  20.421  1.00 14.45           C  
ATOM    322  CD  ARG A  40      14.350  47.891  20.197  1.00 14.32           C  
ATOM    323  NE  ARG A  40      14.400  48.680  21.413  1.00 14.18           N  
ATOM    324  CZ  ARG A  40      14.653  49.983  21.520  1.00 13.73           C  
ATOM    325  NH1 ARG A  40      15.139  50.702  20.494  1.00 16.14           N  
ATOM    326  NH2 ARG A  40      14.486  50.557  22.679  1.00 17.41           N  
ATOM    327  N   THR A  41      16.161  43.996  18.557  1.00 13.52           N  
ATOM    328  CA  THR A  41      15.707  43.351  17.357  1.00 13.52           C  
ATOM    329  C   THR A  41      14.187  43.446  17.222  1.00 15.19           C  
ATOM    330  O   THR A  41      13.469  43.277  18.237  1.00 14.27           O  
ATOM    331  CB  THR A  41      16.142  41.871  17.333  1.00 15.18           C  
ATOM    332  OG1 THR A  41      17.577  41.806  17.454  1.00 16.01           O  
ATOM    333  CG2 THR A  41      15.726  41.166  16.029  1.00 15.59           C  
ATOM    334  N   LEU A  42      13.726  43.693  15.997  1.00 15.31           N  
ATOM    335  CA  LEU A  42      12.329  43.607  15.651  1.00 14.88           C  
ATOM    336  C   LEU A  42      12.184  42.775  14.403  1.00 15.71           C  
ATOM    337  O   LEU A  42      13.129  42.608  13.647  1.00 16.09           O  
ATOM    338  CB  LEU A  42      11.736  44.971  15.302  1.00 15.35           C  
ATOM    339  CG  LEU A  42      12.001  46.106  16.276  1.00 21.87           C  
ATOM    340  CD1 LEU A  42      11.490  47.454  15.671  1.00 22.20           C  
ATOM    341  CD2 LEU A  42      11.350  45.740  17.527  1.00 21.42           C  
ATOM    342  N   VAL A  43      10.987  42.254  14.133  1.00 15.60           N  
ATOM    343  CA  VAL A  43      10.656  41.620  12.850  1.00 15.54           C  
ATOM    344  C   VAL A  43      10.146  42.623  11.843  1.00 15.44           C  
ATOM    345  O   VAL A  43       9.200  43.371  12.139  1.00 15.79           O  
ATOM    346  CB  VAL A  43       9.540  40.569  13.074  1.00 15.63           C  
ATOM    347  CG1 VAL A  43       9.139  39.885  11.724  1.00 19.86           C  
ATOM    348  CG2 VAL A  43       9.983  39.513  14.112  1.00 19.44           C  
ATOM    349  N   PHE A  44      10.759  42.686  10.662  1.00 14.99           N  
ATOM    350  CA  PHE A  44      10.246  43.474   9.562  1.00 13.80           C  
ATOM    351  C   PHE A  44       8.957  42.828   9.054  1.00 14.07           C  
ATOM    352  O   PHE A  44       8.923  41.657   8.723  1.00 15.64           O  
ATOM    353  CB  PHE A  44      11.286  43.449   8.447  1.00 16.55           C  
ATOM    354  CG  PHE A  44      10.816  44.008   7.142  1.00 13.58           C  
ATOM    355  CD1 PHE A  44      10.564  45.373   7.009  1.00 15.85           C  
ATOM    356  CD2 PHE A  44      10.656  43.191   6.050  1.00 17.47           C  
ATOM    357  CE1 PHE A  44      10.153  45.868   5.782  1.00 16.76           C  
ATOM    358  CE2 PHE A  44      10.270  43.691   4.832  1.00 17.14           C  
ATOM    359  CZ  PHE A  44      10.041  45.019   4.699  1.00 14.95           C  
ATOM    360  N   ARG A  45       7.926  43.657   8.953  1.00 14.89           N  
ATOM    361  CA  ARG A  45       6.596  43.203   8.546  0.50 16.15           C  
ATOM    363  C   ARG A  45       6.133  43.822   7.233  1.00 18.59           C  
ATOM    364  O   ARG A  45       4.935  44.102   7.054  1.00 17.82           O  
ATOM    365  CB  ARG A  45       5.600  43.484   9.666  0.50 15.91           C  
ATOM    367  CG  ARG A  45       6.099  42.945  11.007  0.50 21.59           C  
ATOM    369  CD  ARG A  45       5.047  42.439  11.897  0.50 22.23           C  
ATOM    371  NE  ARG A  45       5.539  41.613  13.006  0.50 13.34           N  
ATOM    373  CZ  ARG A  45       5.253  40.309  13.155  0.50 13.00           C  
ATOM    375  NH1 ARG A  45       4.560  39.657  12.244  0.50 16.65           N  
ATOM    377  NH2 ARG A  45       5.716  39.630  14.190  0.50 20.19           N  
ATOM    379  N   GLY A  46       7.061  44.068   6.308  1.00 16.15           N  
ATOM    380  CA  GLY A  46       6.734  44.596   5.009  1.00 15.71           C  
ATOM    381  C   GLY A  46       6.671  46.108   4.952  1.00 15.83           C  
ATOM    382  O   GLY A  46       6.741  46.790   5.954  1.00 18.95           O  
ATOM    383  N   PHE A  47       6.568  46.644   3.749  1.00 15.48           N  
ATOM    384  CA  PHE A  47       6.260  48.042   3.533  1.00 14.10           C  
ATOM    385  C   PHE A  47       4.761  48.312   3.581  1.00 16.79           C  
ATOM    386  O   PHE A  47       3.960  47.490   3.151  1.00 18.39           O  
ATOM    387  CB  PHE A  47       6.814  48.462   2.185  1.00 15.69           C  
ATOM    388  CG  PHE A  47       8.348  48.473   2.155  1.00 15.01           C  
ATOM    389  CD1 PHE A  47       9.062  49.586   2.577  1.00 16.88           C  
ATOM    390  CD2 PHE A  47       9.039  47.340   1.756  1.00 15.59           C  
ATOM    391  CE1 PHE A  47      10.470  49.581   2.576  1.00 17.41           C  
ATOM    392  CE2 PHE A  47      10.432  47.322   1.786  1.00 16.24           C  
ATOM    393  CZ  PHE A  47      11.124  48.421   2.218  1.00 15.51           C  
ATOM    394  N   LEU A  48       4.429  49.509   4.032  1.00 17.06           N  
ATOM    395  CA  LEU A  48       3.054  49.963   4.044  1.00 16.49           C  
ATOM    396  C   LEU A  48       2.706  50.251   2.607  1.00 17.25           C  
ATOM    397  O   LEU A  48       3.441  50.921   1.898  1.00 16.66           O  
ATOM    398  CB  LEU A  48       2.931  51.207   4.898  1.00 16.02           C  
ATOM    399  CG  LEU A  48       1.570  51.845   4.950  1.00 18.34           C  
ATOM    400  CD1 LEU A  48       0.541  50.859   5.566  1.00 21.93           C  
ATOM    401  CD2 LEU A  48       1.705  53.134   5.740  1.00 19.75           C  
ATOM    402  N   GLU A  49       1.545  49.789   2.183  1.00 18.79           N  
ATOM    403  CA  GLU A  49       1.162  49.868   0.783  0.50 20.70           C  
ATOM    405  C   GLU A  49       1.163  51.312   0.292  1.00 20.20           C  
ATOM    406  O   GLU A  49       0.763  52.253   1.020  1.00 19.58           O  
ATOM    407  CB  GLU A  49      -0.198  49.221   0.559  0.50 22.96           C  
ATOM    409  CG  GLU A  49      -1.281  49.819   1.399  0.50 21.42           C  
ATOM    411  N   ASP A  50       1.645  51.490  -0.935  1.00 21.46           N  
ATOM    412  CA  ASP A  50       1.752  52.774  -1.552  1.00 24.58           C  
ATOM    413  C   ASP A  50       2.651  53.778  -0.859  1.00 20.32           C  
ATOM    414  O   ASP A  50       2.556  54.991  -1.096  1.00 22.68           O  
ATOM    415  CB  ASP A  50       0.369  53.378  -1.795  1.00 26.61           C  
ATOM    416  CG  ASP A  50       0.026  53.376  -3.263  1.00 43.68           C  
ATOM    417  OD1 ASP A  50       0.104  52.282  -3.894  1.00 47.70           O  
ATOM    418  OD2 ASP A  50      -0.256  54.476  -3.783  1.00 59.24           O  
ATOM    419  N   THR A  51       3.581  53.274  -0.040  1.00 17.29           N  
ATOM    420  CA  THR A  51       4.556  54.129   0.596  1.00 16.13           C  
ATOM    421  C   THR A  51       5.903  53.403   0.613  1.00 16.31           C  
ATOM    422  O   THR A  51       5.988  52.211   0.257  1.00 17.43           O  
ATOM    423  CB  THR A  51       4.225  54.428   2.057  1.00 19.51           C  
ATOM    424  OG1 THR A  51       4.563  53.322   2.869  1.00 18.95           O  
ATOM    425  CG2 THR A  51       2.694  54.792   2.265  1.00 18.29           C  
ATOM    426  N   ASN A  52       6.924  54.130   1.062  1.00 16.96           N  
ATOM    427  CA  ASN A  52       8.262  53.588   1.341  1.00 15.36           C  
ATOM    428  C   ASN A  52       8.511  53.393   2.855  1.00 15.20           C  
ATOM    429  O   ASN A  52       9.658  53.180   3.303  1.00 16.44           O  
ATOM    430  CB  ASN A  52       9.338  54.487   0.739  1.00 17.06           C  
ATOM    431  CG  ASN A  52       9.271  54.534  -0.752  1.00 18.02           C  
ATOM    432  OD1 ASN A  52       9.444  53.523  -1.423  1.00 15.64           O  
ATOM    433  ND2 ASN A  52       8.934  55.718  -1.303  1.00 18.99           N  
ATOM    434  N   GLN A  53       7.445  53.374   3.641  1.00 14.10           N  
ATOM    435  CA  GLN A  53       7.548  53.136   5.081  1.00 15.85           C  
ATOM    436  C   GLN A  53       7.610  51.674   5.411  1.00 14.38           C  
ATOM    437  O   GLN A  53       6.873  50.854   4.889  1.00 15.56           O  
ATOM    438  CB  GLN A  53       6.405  53.777   5.819  1.00 17.41           C  
ATOM    439  CG  GLN A  53       6.375  55.267   5.564  1.00 18.01           C  
ATOM    440  CD  GLN A  53       5.827  56.069   6.738  1.00 24.87           C  
ATOM    441  OE1 GLN A  53       6.333  55.966   7.828  1.00 25.88           O  
ATOM    442  NE2 GLN A  53       4.886  56.950   6.477  1.00 31.93           N  
ATOM    443  N   LEU A  54       8.490  51.339   6.339  1.00 14.79           N  
ATOM    444  CA  LEU A  54       8.582  49.957   6.871  1.00 14.63           C  
ATOM    445  C   LEU A  54       7.675  49.780   8.080  1.00 14.74           C  
ATOM    446  O   LEU A  54       7.612  50.695   8.931  1.00 15.15           O  
ATOM    447  CB  LEU A  54      10.025  49.670   7.329  1.00 14.97           C  
ATOM    448  CG  LEU A  54      11.110  49.666   6.259  1.00 16.33           C  
ATOM    449  CD1 LEU A  54      11.519  51.091   5.745  1.00 15.80           C  
ATOM    450  CD2 LEU A  54      12.341  48.994   6.890  1.00 19.08           C  
ATOM    451  N   ARG A  55       7.022  48.619   8.157  1.00 14.65           N  
ATOM    452  CA  ARG A  55       6.089  48.253   9.233  1.00 14.71           C  
ATOM    453  C   ARG A  55       6.713  47.336  10.245  1.00 14.68           C  
ATOM    454  O   ARG A  55       7.375  46.343   9.904  1.00 14.20           O  
ATOM    455  CB  ARG A  55       4.854  47.522   8.663  1.00 15.18           C  
ATOM    456  CG  ARG A  55       4.088  48.257   7.674  1.00 16.56           C  
ATOM    457  CD  ARG A  55       2.736  47.572   7.417  1.00 14.37           C  
ATOM    458  NE  ARG A  55       2.880  46.198   6.973  1.00 16.47           N  
ATOM    459  CZ  ARG A  55       1.880  45.338   6.810  1.00 17.65           C  
ATOM    460  NH1 ARG A  55       0.593  45.693   7.003  1.00 17.43           N  
ATOM    461  NH2 ARG A  55       2.154  44.085   6.466  1.00 20.80           N  
ATOM    462  N   PHE A  56       6.437  47.643  11.530  1.00 14.68           N  
ATOM    463  CA  PHE A  56       6.766  46.790  12.652  1.00 14.44           C  
ATOM    464  C   PHE A  56       5.573  46.864  13.623  1.00 15.55           C  
ATOM    465  O   PHE A  56       4.723  47.769  13.498  1.00 15.71           O  
ATOM    466  CB  PHE A  56       7.991  47.329  13.372  1.00 15.92           C  
ATOM    467  CG  PHE A  56       9.147  47.584  12.459  1.00 14.15           C  
ATOM    468  CD1 PHE A  56      10.002  46.569  12.155  1.00 17.02           C  
ATOM    469  CD2 PHE A  56       9.343  48.812  11.907  1.00 18.74           C  
ATOM    470  CE1 PHE A  56      11.050  46.782  11.280  1.00 16.62           C  
ATOM    471  CE2 PHE A  56      10.405  49.067  11.066  1.00 19.28           C  
ATOM    472  CZ  PHE A  56      11.258  48.010  10.750  1.00 15.61           C  
ATOM    473  N   ILE A  57       5.566  45.965  14.592  1.00 15.25           N  
ATOM    474  CA  ILE A  57       4.618  46.019  15.699  1.00 14.32           C  
ATOM    475  C   ILE A  57       5.376  46.079  17.001  1.00 16.00           C  
ATOM    476  O   ILE A  57       6.528  45.593  17.092  1.00 16.01           O  
ATOM    477  CB  ILE A  57       3.645  44.820  15.675  1.00 14.08           C  
ATOM    478  CG1 ILE A  57       4.315  43.507  16.054  1.00 16.48           C  
ATOM    479  CG2 ILE A  57       2.914  44.783  14.347  1.00 15.99           C  
ATOM    480  CD1 ILE A  57       3.396  42.243  16.049  1.00 18.22           C  
ATOM    481  N   THR A  58       4.736  46.657  18.002  1.00 14.57           N  
ATOM    482  CA  THR A  58       5.307  46.707  19.344  1.00 14.84           C  
ATOM    483  C   THR A  58       4.204  46.921  20.349  1.00 15.34           C  
ATOM    484  O   THR A  58       3.078  47.283  19.990  1.00 15.49           O  
ATOM    485  CB  THR A  58       6.445  47.726  19.469  1.00 18.09           C  
ATOM    486  OG1 THR A  58       7.294  47.385  20.574  1.00 22.08           O  
ATOM    487  CG2 THR A  58       5.909  49.148  19.591  1.00 19.35           C  
ATOM    488  N   ASP A  59       4.518  46.675  21.607  1.00 15.89           N  
ATOM    489  CA  ASP A  59       3.580  46.832  22.711  1.00 15.84           C  
ATOM    490  C   ASP A  59       3.701  48.234  23.314  1.00 16.30           C  
ATOM    491  O   ASP A  59       4.815  48.720  23.547  1.00 17.12           O  
ATOM    492  CB  ASP A  59       3.909  45.756  23.754  1.00 16.30           C  
ATOM    493  CG  ASP A  59       2.826  45.527  24.768  1.00 19.39           C  
ATOM    494  OD1 ASP A  59       2.360  46.473  25.422  1.00 15.98           O  
ATOM    495  OD2 ASP A  59       2.439  44.348  24.898  1.00 22.71           O  
ATOM    496  N   THR A  60       2.567  48.898  23.592  1.00 16.43           N  
ATOM    497  CA  THR A  60       2.589  50.236  24.207  1.00 16.11           C  
ATOM    498  C   THR A  60       3.268  50.209  25.574  1.00 17.95           C  
ATOM    499  O   THR A  60       3.706  51.262  26.064  1.00 18.08           O  
ATOM    500  CB  THR A  60       1.181  50.850  24.445  1.00 20.46           C  
ATOM    501  OG1 THR A  60       0.448  49.976  25.304  1.00 20.81           O  
ATOM    502  CG2 THR A  60       0.408  51.020  23.153  1.00 26.22           C  
ATOM    503  N   ARG A  61       3.302  49.048  26.223  1.00 16.04           N  
ATOM    504  CA  ARG A  61       3.889  48.910  27.562  1.00 16.91           C  
ATOM    505  C   ARG A  61       5.397  48.795  27.516  1.00 17.23           C  
ATOM    506  O   ARG A  61       6.043  48.863  28.567  1.00 18.45           O  
ATOM    507  CB  ARG A  61       3.332  47.651  28.250  1.00 16.32           C  
ATOM    508  CG  ARG A  61       1.834  47.740  28.482  1.00 16.65           C  
ATOM    509  CD  ARG A  61       1.252  46.427  28.990  1.00 17.09           C  
ATOM    510  NE  ARG A  61       1.474  45.336  28.071  1.00 17.79           N  
ATOM    511  CZ  ARG A  61       1.323  44.047  28.357  1.00 18.29           C  
ATOM    512  NH1 ARG A  61       0.872  43.669  29.553  1.00 20.36           N  
ATOM    513  NH2 ARG A  61       1.601  43.124  27.442  1.00 19.45           N  
ATOM    514  N   SER A  62       5.965  48.600  26.331  1.00 14.48           N  
ATOM    515  CA  SER A  62       7.425  48.460  26.239  1.00 16.72           C  
ATOM    516  C   SER A  62       8.154  49.812  26.388  1.00 16.72           C  
ATOM    517  O   SER A  62       7.627  50.906  26.159  1.00 17.91           O  
ATOM    518  CB  SER A  62       7.815  47.782  24.957  1.00 19.26           C  
ATOM    519  OG  SER A  62       7.565  48.624  23.867  1.00 19.00           O  
ATOM    520  N   ALA A  63       9.420  49.736  26.825  1.00 17.52           N  
ATOM    521  CA  ALA A  63      10.200  50.930  26.997  1.00 15.71           C  
ATOM    522  C   ALA A  63      10.345  51.767  25.739  1.00 15.26           C  
ATOM    523  O   ALA A  63      10.381  53.014  25.817  1.00 18.44           O  
ATOM    524  CB  ALA A  63      11.600  50.562  27.500  1.00 18.73           C  
ATOM    525  N   LYS A  64      10.447  51.108  24.588  1.00 16.22           N  
ATOM    526  CA  LYS A  64      10.717  51.828  23.360  1.00 16.78           C  
ATOM    527  C   LYS A  64       9.535  52.745  23.053  1.00 19.59           C  
ATOM    528  O   LYS A  64       9.701  53.747  22.402  1.00 18.22           O  
ATOM    529  CB  LYS A  64      10.969  50.909  22.181  1.00 17.15           C  
ATOM    530  CG  LYS A  64       9.715  50.267  21.536  1.00 15.13           C  
ATOM    531  CD  LYS A  64      10.058  49.264  20.465  1.00 17.29           C  
ATOM    532  CE  LYS A  64      10.527  47.943  21.000  1.00 17.18           C  
ATOM    533  NZ  LYS A  64       9.678  47.336  22.112  1.00 17.49           N  
ATOM    534  N   ALA A  65       8.328  52.374  23.497  1.00 19.83           N  
ATOM    535  CA  ALA A  65       7.149  53.225  23.192  1.00 21.01           C  
ATOM    536  C   ALA A  65       7.343  54.633  23.709  1.00 21.96           C  
ATOM    537  O   ALA A  65       7.153  55.597  22.964  1.00 21.14           O  
ATOM    538  CB  ALA A  65       5.838  52.590  23.715  1.00 23.26           C  
ATOM    539  N   ASP A  66       7.767  54.775  24.959  1.00 21.63           N  
ATOM    540  CA  ASP A  66       7.959  56.110  25.494  1.00 21.26           C  
ATOM    541  C   ASP A  66       9.171  56.786  24.876  1.00 21.95           C  
ATOM    542  O   ASP A  66       9.195  57.992  24.645  1.00 21.06           O  
ATOM    543  CB  ASP A  66       8.138  56.100  27.005  1.00 23.71           C  
ATOM    544  CG  ASP A  66       8.190  57.491  27.564  1.00 33.65           C  
ATOM    545  OD1 ASP A  66       7.153  58.192  27.477  1.00 44.48           O  
ATOM    546  OD2 ASP A  66       9.272  57.906  28.035  1.00 45.05           O  
ATOM    547  N   GLN A  67      10.202  56.001  24.572  1.00 19.08           N  
ATOM    548  CA  GLN A  67      11.391  56.596  23.953  1.00 18.35           C  
ATOM    549  C   GLN A  67      10.994  57.219  22.612  1.00 18.97           C  
ATOM    550  O   GLN A  67      11.429  58.318  22.283  1.00 19.62           O  
ATOM    551  CB  GLN A  67      12.491  55.559  23.703  1.00 18.19           C  
ATOM    552  CG  GLN A  67      13.059  54.891  24.996  1.00 15.55           C  
ATOM    553  CD  GLN A  67      13.864  53.650  24.732  1.00 16.12           C  
ATOM    554  OE1 GLN A  67      14.205  53.331  23.590  1.00 17.49           O  
ATOM    555  NE2 GLN A  67      14.181  52.924  25.802  1.00 17.90           N  
ATOM    556  N   ILE A  68      10.191  56.506  21.838  1.00 18.64           N  
ATOM    557  CA  ILE A  68       9.789  56.956  20.505  1.00 18.47           C  
ATOM    558  C   ILE A  68       8.897  58.191  20.592  1.00 20.21           C  
ATOM    559  O   ILE A  68       9.024  59.133  19.801  1.00 19.64           O  
ATOM    560  CB  ILE A  68       9.128  55.791  19.746  1.00 17.55           C  
ATOM    561  CG1 ILE A  68      10.192  54.738  19.454  1.00 18.01           C  
ATOM    562  CG2 ILE A  68       8.444  56.247  18.464  1.00 19.15           C  
ATOM    563  CD1 ILE A  68       9.677  53.391  19.021  1.00 20.02           C  
ATOM    564  N   GLN A  69       7.979  58.201  21.549  1.00 19.19           N  
ATOM    565  CA  GLN A  69       7.137  59.364  21.723  1.00 20.70           C  
ATOM    566  C   GLN A  69       7.933  60.623  22.007  1.00 22.44           C  
ATOM    567  O   GLN A  69       7.573  61.703  21.535  1.00 26.01           O  
ATOM    568  CB  GLN A  69       6.119  59.099  22.842  1.00 23.14           C  
ATOM    569  CG  GLN A  69       5.168  57.960  22.478  1.00 31.58           C  
ATOM    570  N   GLN A  70       9.018  60.500  22.775  1.00 20.68           N  
ATOM    571  CA  GLN A  70       9.857  61.658  23.079  1.00 21.29           C  
ATOM    572  C   GLN A  70      10.851  62.019  21.972  1.00 21.72           C  
ATOM    573  O   GLN A  70      11.170  63.188  21.800  1.00 24.11           O  
ATOM    574  CB  GLN A  70      10.580  61.488  24.419  1.00 22.28           C  
ATOM    575  CG  GLN A  70       9.622  61.303  25.582  1.00 23.14           C  
ATOM    576  CD  GLN A  70      10.277  61.497  26.949  1.00 28.40           C  
ATOM    577  OE1 GLN A  70      11.063  62.424  27.152  1.00 44.05           O  
ATOM    578  NE2 GLN A  70       9.939  60.619  27.893  1.00 39.76           N  
ATOM    579  N   GLN A  71      11.335  61.029  21.213  1.00 20.09           N  
ATOM    580  CA  GLN A  71      12.266  61.287  20.115  1.00 19.14           C  
ATOM    581  C   GLN A  71      11.976  60.263  19.026  1.00 18.34           C  
ATOM    582  O   GLN A  71      12.446  59.134  19.087  1.00 16.99           O  
ATOM    583  CB  GLN A  71      13.700  61.215  20.605  1.00 21.95           C  
ATOM    584  CG  GLN A  71      14.834  61.115  19.556  1.00 28.61           C  
ATOM    585  CD  GLN A  71      14.911  62.243  18.593  1.00 35.45           C  
ATOM    586  OE1 GLN A  71      14.071  62.389  17.715  1.00 29.38           O  
ATOM    587  NE2 GLN A  71      15.949  63.068  18.737  1.00 43.95           N  
ATOM    588  N   PRO A  72      11.154  60.654  18.059  1.00 18.07           N  
ATOM    589  CA  PRO A  72      10.755  59.696  17.042  0.50 18.79           C  
ATOM    591  C   PRO A  72      11.911  59.315  16.027  0.50 15.06           C  
ATOM    593  O   PRO A  72      11.755  58.472  15.193  0.50 15.17           O  
ATOM    595  CB  PRO A  72       9.465  60.343  16.467  1.00 22.73           C  
ATOM    596  CG  PRO A  72       9.595  61.798  16.712  1.00 25.05           C  
ATOM    597  CD  PRO A  72      10.476  61.960  17.935  1.00 21.93           C  
ATOM    598  N   TRP A  73      13.069  59.944  16.064  0.50 22.73           N  
ATOM    600  CA  TRP A  73      14.046  59.590  15.034  1.00 24.42           C  
ATOM    601  C   TRP A  73      14.788  58.292  15.406  1.00 26.70           C  
ATOM    602  O   TRP A  73      15.278  58.192  16.536  1.00 28.77           O  
ATOM    603  CB  TRP A  73      14.996  60.702  14.904  1.00 27.21           C  
ATOM    604  CG  TRP A  73      15.914  60.463  13.783  1.00 30.00           C  
ATOM    605  CD1 TRP A  73      17.020  59.672  13.792  1.00 24.82           C  
ATOM    606  CD2 TRP A  73      15.820  61.019  12.481  1.00 27.92           C  
ATOM    607  NE1 TRP A  73      17.617  59.691  12.582  1.00 23.55           N  
ATOM    608  CE2 TRP A  73      16.926  60.552  11.757  1.00 24.81           C  
ATOM    609  CE3 TRP A  73      14.911  61.884  11.853  1.00 24.77           C  
ATOM    610  CZ2 TRP A  73      17.158  60.910  10.430  1.00 26.17           C  
ATOM    611  CZ3 TRP A  73      15.155  62.243  10.529  1.00 23.88           C  
ATOM    612  CH2 TRP A  73      16.262  61.778   9.848  1.00 26.04           C  
ATOM    613  N   ALA A  74      14.847  57.323  14.480  1.00 19.97           N  
ATOM    614  CA  ALA A  74      15.499  56.024  14.759  1.00 18.65           C  
ATOM    615  C   ALA A  74      16.450  55.673  13.615  1.00 17.33           C  
ATOM    616  O   ALA A  74      16.347  56.239  12.523  1.00 16.94           O  
ATOM    617  CB  ALA A  74      14.493  54.937  14.962  1.00 23.03           C  
ATOM    618  N   GLU A  75      17.346  54.720  13.872  1.00 14.58           N  
ATOM    619  CA  GLU A  75      18.155  54.187  12.812  1.00 13.83           C  
ATOM    620  C   GLU A  75      18.138  52.667  12.909  1.00 15.80           C  
ATOM    621  O   GLU A  75      18.437  52.091  13.980  1.00 17.29           O  
ATOM    622  CB  GLU A  75      19.605  54.651  12.913  1.00 15.86           C  
ATOM    623  CG  GLU A  75      20.428  54.214  11.689  1.00 16.13           C  
ATOM    624  CD  GLU A  75      21.722  55.007  11.551  1.00 17.56           C  
ATOM    625  OE1 GLU A  75      21.659  56.270  11.364  1.00 21.07           O  
ATOM    626  OE2 GLU A  75      22.819  54.428  11.617  1.00 18.39           O  
ATOM    627  N   ILE A  76      17.704  52.031  11.827  1.00 14.80           N  
ATOM    628  CA  ILE A  76      17.773  50.589  11.801  0.50 14.42           C  
ATOM    630  C   ILE A  76      19.084  50.147  11.148  1.00 15.17           C  
ATOM    631  O   ILE A  76      19.674  50.840  10.311  1.00 15.50           O  
ATOM    632  CB  ILE A  76      16.559  49.953  11.146  0.50 15.15           C  
ATOM    634  CG1 ILE A  76      16.437  50.451   9.696  0.50 12.61           C  
ATOM    636  CG2 ILE A  76      15.294  50.173  12.019  0.50 13.64           C  
ATOM    638  CD1 ILE A  76      15.432  49.642   8.862  0.50 18.91           C  
ATOM    640  N   CYS A  77      19.579  48.995  11.596  1.00 14.89           N  
ATOM    641  CA  CYS A  77      20.666  48.310  10.944  1.00 14.31           C  
ATOM    642  C   CYS A  77      20.139  46.947  10.633  1.00 14.77           C  
ATOM    643  O   CYS A  77      19.613  46.247  11.491  1.00 15.38           O  
ATOM    644  CB  CYS A  77      21.877  48.245  11.834  1.00 17.44           C  
ATOM    645  SG  CYS A  77      23.290  47.492  11.015  1.00 17.79           S  
ATOM    646  N   TRP A  78      20.280  46.563   9.367  1.00 13.89           N  
ATOM    647  CA  TRP A  78      19.692  45.321   8.829  1.00 14.36           C  
ATOM    648  C   TRP A  78      20.770  44.571   8.060  1.00 15.48           C  
ATOM    649  O   TRP A  78      21.254  45.058   7.028  1.00 15.41           O  
ATOM    650  CB  TRP A  78      18.559  45.686   7.946  1.00 14.64           C  
ATOM    651  CG  TRP A  78      17.624  44.563   7.527  1.00 13.80           C  
ATOM    652  CD1 TRP A  78      17.681  43.227   7.838  1.00 16.26           C  
ATOM    653  CD2 TRP A  78      16.402  44.765   6.799  1.00 12.86           C  
ATOM    654  NE1 TRP A  78      16.539  42.594   7.346  1.00 16.42           N  
ATOM    655  CE2 TRP A  78      15.746  43.514   6.737  1.00 14.02           C  
ATOM    656  CE3 TRP A  78      15.765  45.886   6.278  1.00 15.18           C  
ATOM    657  CZ2 TRP A  78      14.493  43.366   6.109  1.00 15.56           C  
ATOM    658  CZ3 TRP A  78      14.585  45.733   5.601  1.00 16.17           C  
ATOM    659  CH2 TRP A  78      13.965  44.495   5.551  1.00 17.60           C  
ATOM    660  N   TYR A  79      21.171  43.424   8.578  1.00 14.57           N  
ATOM    661  CA  TYR A  79      22.199  42.612   7.984  1.00 16.01           C  
ATOM    662  C   TYR A  79      21.601  41.356   7.375  1.00 14.87           C  
ATOM    663  O   TYR A  79      20.784  40.638   8.014  1.00 16.66           O  
ATOM    664  CB  TYR A  79      23.318  42.234   9.012  1.00 17.15           C  
ATOM    665  CG  TYR A  79      24.392  41.405   8.414  1.00 15.00           C  
ATOM    666  CD1 TYR A  79      25.219  41.946   7.433  1.00 15.28           C  
ATOM    667  CD2 TYR A  79      24.559  40.060   8.719  1.00 15.61           C  
ATOM    668  CE1 TYR A  79      26.173  41.197   6.783  1.00 15.59           C  
ATOM    669  CE2 TYR A  79      25.536  39.289   8.070  1.00 16.26           C  
ATOM    670  CZ  TYR A  79      26.367  39.868   7.111  1.00 15.41           C  
ATOM    671  OH  TYR A  79      27.300  39.140   6.451  1.00 17.77           O  
ATOM    672  N   PHE A  80      21.995  41.069   6.137  1.00 13.05           N  
ATOM    673  CA  PHE A  80      21.505  39.939   5.346  1.00 15.14           C  
ATOM    674  C   PHE A  80      22.618  38.924   5.219  1.00 15.38           C  
ATOM    675  O   PHE A  80      23.570  39.124   4.503  1.00 15.73           O  
ATOM    676  CB  PHE A  80      21.080  40.441   3.969  1.00 15.35           C  
ATOM    677  CG  PHE A  80      19.781  41.181   3.979  1.00 12.83           C  
ATOM    678  CD1 PHE A  80      18.594  40.522   3.850  1.00 15.11           C  
ATOM    679  CD2 PHE A  80      19.753  42.557   4.155  1.00 14.25           C  
ATOM    680  CE1 PHE A  80      17.359  41.226   3.843  1.00 16.99           C  
ATOM    681  CE2 PHE A  80      18.567  43.260   4.191  1.00 16.21           C  
ATOM    682  CZ  PHE A  80      17.367  42.612   4.001  1.00 15.71           C  
ATOM    683  N   PRO A  81      22.515  37.810   5.972  1.00 16.54           N  
ATOM    684  CA  PRO A  81      23.661  36.936   6.079  1.00 18.70           C  
ATOM    685  C   PRO A  81      24.063  36.126   4.876  1.00 18.40           C  
ATOM    686  O   PRO A  81      25.245  35.824   4.722  1.00 19.14           O  
ATOM    687  CB  PRO A  81      23.307  36.027   7.271  1.00 20.30           C  
ATOM    688  CG  PRO A  81      22.286  36.648   7.970  1.00 23.16           C  
ATOM    689  CD  PRO A  81      21.458  37.448   6.926  1.00 18.58           C  
ATOM    690  N   ASN A  82      23.126  35.818   3.982  1.00 17.55           N  
ATOM    691  CA  ASN A  82      23.460  34.993   2.824  1.00 18.88           C  
ATOM    692  C   ASN A  82      24.179  35.805   1.747  1.00 20.34           C  
ATOM    693  O   ASN A  82      24.953  35.302   0.975  1.00 24.37           O  
ATOM    694  CB  ASN A  82      22.194  34.457   2.169  1.00 22.73           C  
ATOM    695  CG  ASN A  82      21.872  33.062   2.541  1.00 34.66           C  
ATOM    696  OD1 ASN A  82      22.585  32.423   3.305  1.00 33.61           O  
ATOM    697  ND2 ASN A  82      20.759  32.566   1.986  1.00 40.02           N  
ATOM    698  N   THR A  83      23.854  37.084   1.656  1.00 15.49           N  
ATOM    699  CA  THR A  83      24.453  37.956   0.676  1.00 14.81           C  
ATOM    700  C   THR A  83      25.483  38.923   1.239  1.00 15.63           C  
ATOM    701  O   THR A  83      26.110  39.637   0.467  1.00 16.19           O  
ATOM    702  CB  THR A  83      23.363  38.747  -0.051  1.00 14.71           C  
ATOM    703  OG1 THR A  83      22.536  39.394   0.905  1.00 15.82           O  
ATOM    704  CG2 THR A  83      22.482  37.787  -0.922  1.00 16.20           C  
ATOM    705  N   ARG A  84      25.691  38.905   2.560  1.00 15.26           N  
ATOM    706  CA  ARG A  84      26.752  39.722   3.198  1.00 16.34           C  
ATOM    707  C   ARG A  84      26.582  41.214   2.855  1.00 15.26           C  
ATOM    708  O   ARG A  84      27.513  41.899   2.432  1.00 15.99           O  
ATOM    709  CB  ARG A  84      28.144  39.200   2.838  1.00 15.44           C  
ATOM    710  CG  ARG A  84      28.362  37.751   3.235  1.00 19.29           C  
ATOM    711  CD  ARG A  84      29.821  37.288   2.935  1.00 23.33           C  
ATOM    712  NE  ARG A  84      30.806  38.023   3.723  1.00 30.92           N  
ATOM    713  CZ  ARG A  84      31.919  38.608   3.273  1.00 36.91           C  
ATOM    714  NH1 ARG A  84      32.327  38.562   1.987  1.00 38.43           N  
ATOM    715  NH2 ARG A  84      32.666  39.249   4.149  1.00 39.72           N  
ATOM    716  N   GLU A  85      25.355  41.717   3.053  1.00 13.77           N  
ATOM    717  CA  GLU A  85      25.056  43.127   2.831  1.00 13.56           C  
ATOM    718  C   GLU A  85      24.327  43.742   4.001  1.00 13.59           C  
ATOM    719  O   GLU A  85      23.608  43.030   4.716  1.00 14.83           O  
ATOM    720  CB  GLU A  85      24.292  43.315   1.529  1.00 16.89           C  
ATOM    721  CG  GLU A  85      22.963  42.738   1.511  1.00 17.60           C  
ATOM    722  CD  GLU A  85      22.356  42.718   0.087  1.00 20.02           C  
ATOM    723  OE1 GLU A  85      22.273  43.782  -0.559  1.00 18.92           O  
ATOM    724  OE2 GLU A  85      21.907  41.631  -0.332  1.00 17.97           O  
ATOM    725  N   GLN A  86      24.518  45.035   4.215  1.00 12.96           N  
ATOM    726  CA  GLN A  86      23.937  45.732   5.306  1.00 13.88           C  
ATOM    727  C   GLN A  86      23.205  46.959   4.786  1.00 13.86           C  
ATOM    728  O   GLN A  86      23.715  47.639   3.894  1.00 14.12           O  
ATOM    729  CB  GLN A  86      25.036  46.183   6.256  1.00 15.16           C  
ATOM    730  CG  GLN A  86      24.628  47.127   7.393  1.00 16.56           C  
ATOM    731  CD  GLN A  86      25.788  47.479   8.276  1.00 16.35           C  
ATOM    732  OE1 GLN A  86      25.912  46.912   9.368  1.00 17.86           O  
ATOM    733  NE2 GLN A  86      26.622  48.384   7.834  1.00 17.37           N  
ATOM    734  N   PHE A  87      22.006  47.210   5.316  1.00 12.94           N  
ATOM    735  CA  PHE A  87      21.297  48.461   5.110  1.00 12.47           C  
ATOM    736  C   PHE A  87      21.151  49.172   6.450  1.00 14.39           C  
ATOM    737  O   PHE A  87      20.648  48.603   7.429  1.00 15.57           O  
ATOM    738  CB  PHE A  87      19.918  48.261   4.509  1.00 13.57           C  
ATOM    739  CG  PHE A  87      19.899  47.641   3.168  1.00 13.74           C  
ATOM    740  CD1 PHE A  87      20.111  46.292   2.992  1.00 17.15           C  
ATOM    741  CD2 PHE A  87      19.670  48.447   2.045  1.00 15.08           C  
ATOM    742  CE1 PHE A  87      20.068  45.705   1.702  1.00 15.78           C  
ATOM    743  CE2 PHE A  87      19.612  47.858   0.766  1.00 13.49           C  
ATOM    744  CZ  PHE A  87      19.792  46.485   0.613  1.00 14.14           C  
ATOM    745  N   ARG A  88      21.568  50.410   6.486  1.00 12.45           N  
ATOM    746  CA  ARG A  88      21.314  51.290   7.625  1.00 13.14           C  
ATOM    747  C   ARG A  88      20.306  52.305   7.149  1.00 14.33           C  
ATOM    748  O   ARG A  88      20.483  52.856   6.064  1.00 14.11           O  
ATOM    749  CB  ARG A  88      22.596  51.974   8.101  1.00 14.33           C  
ATOM    750  CG  ARG A  88      23.573  51.008   8.679  1.00 15.38           C  
ATOM    751  CD  ARG A  88      24.949  51.650   8.872  1.00 16.99           C  
ATOM    752  NE  ARG A  88      24.869  52.768   9.825  1.00 17.17           N  
ATOM    753  CZ  ARG A  88      25.897  53.534  10.194  1.00 18.73           C  
ATOM    754  NH1 ARG A  88      27.016  53.366   9.589  1.00 20.09           N  
ATOM    755  NH2 ARG A  88      25.736  54.501  11.109  1.00 20.21           N  
HETATM  756  N   MSE A  89      19.226  52.498   7.863  1.00 14.06           N  
HETATM  757  CA  MSE A  89      18.149  53.352   7.405  0.50 14.79           C  
HETATM  759  C   MSE A  89      17.726  54.251   8.578  1.00 15.48           C  
HETATM  760  O   MSE A  89      17.333  53.751   9.627  1.00 15.83           O  
HETATM  761  CB  MSE A  89      16.988  52.502   6.826  0.50 16.34           C  
HETATM  763  CG  MSE A  89      17.456  51.261   6.012  0.50 12.10           C  
HETATM  765 SE   MSE A  89      16.042  50.009   5.500  0.37 22.49          SE  
HETATM  767  CE  MSE A  89      15.562  50.795   3.795  0.50 24.58           C  
ATOM    769  N   ALA A  90      17.793  55.555   8.370  1.00 15.19           N  
ATOM    770  CA  ALA A  90      17.497  56.515   9.418  1.00 15.22           C  
ATOM    771  C   ALA A  90      16.321  57.361   9.008  1.00 17.30           C  
ATOM    772  O   ALA A  90      16.222  57.748   7.861  1.00 15.73           O  
ATOM    773  CB  ALA A  90      18.658  57.399   9.640  1.00 15.31           C  
ATOM    774  N   GLY A  91      15.425  57.642   9.945  1.00 16.08           N  
ATOM    775  CA  GLY A  91      14.304  58.514   9.660  1.00 16.35           C  
ATOM    776  C   GLY A  91      13.323  58.539  10.805  1.00 16.44           C  
ATOM    777  O   GLY A  91      13.617  58.093  11.910  1.00 17.00           O  
ATOM    778  N   ASP A  92      12.184  59.164  10.539  1.00 19.78           N  
ATOM    779  CA  ASP A  92      11.220  59.378  11.603  0.50 18.47           C  
ATOM    781  C   ASP A  92      10.274  58.206  11.749  1.00 17.35           C  
ATOM    782  O   ASP A  92       9.871  57.558  10.792  1.00 18.00           O  
ATOM    783  CB  ASP A  92      10.417  60.644  11.398  0.50 21.83           C  
ATOM    785  CG  ASP A  92      11.172  61.877  11.821  0.50 28.64           C  
ATOM    787  OD1 ASP A  92      11.656  61.969  12.984  0.50 29.86           O  
ATOM    789  OD2 ASP A  92      11.270  62.746  10.967  0.50 22.73           O  
ATOM    791  N   LEU A  93      10.001  57.907  13.006  1.00 20.15           N  
ATOM    792  CA  LEU A  93       9.041  56.920  13.395  1.00 17.10           C  
ATOM    793  C   LEU A  93       7.667  57.512  13.598  1.00 18.98           C  
ATOM    794  O   LEU A  93       7.517  58.594  14.089  1.00 18.52           O  
ATOM    795  CB  LEU A  93       9.455  56.232  14.695  1.00 17.98           C  
ATOM    796  CG  LEU A  93      10.747  55.392  14.599  1.00 20.63           C  
ATOM    797  CD1 LEU A  93      11.257  54.967  16.007  1.00 23.48           C  
ATOM    798  CD2 LEU A  93      10.579  54.191  13.685  1.00 24.18           C  
ATOM    799  N   THR A  94       6.649  56.734  13.287  1.00 16.07           N  
ATOM    800  CA  THR A  94       5.266  57.023  13.661  1.00 15.92           C  
ATOM    801  C   THR A  94       4.743  55.837  14.484  1.00 15.71           C  
ATOM    802  O   THR A  94       4.811  54.713  14.018  1.00 16.39           O  
ATOM    803  CB  THR A  94       4.386  57.194  12.416  1.00 16.42           C  
ATOM    804  OG1 THR A  94       4.914  58.195  11.530  1.00 20.36           O  
ATOM    805  CG2 THR A  94       2.958  57.622  12.792  1.00 20.42           C  
ATOM    806  N   LEU A  95       4.243  56.082  15.674  1.00 15.54           N  
ATOM    807  CA  LEU A  95       3.729  55.052  16.546  1.00 16.65           C  
ATOM    808  C   LEU A  95       2.215  55.221  16.587  1.00 16.67           C  
ATOM    809  O   LEU A  95       1.709  56.259  17.020  1.00 17.54           O  
ATOM    810  CB  LEU A  95       4.318  55.211  17.949  1.00 17.29           C  
ATOM    811  CG  LEU A  95       4.082  54.095  18.961  1.00 23.27           C  
ATOM    812  CD1 LEU A  95       4.721  52.751  18.585  1.00 23.84           C  
ATOM    813  CD2 LEU A  95       4.582  54.538  20.348  1.00 26.05           C  
ATOM    814  N   ILE A  96       1.529  54.235  16.041  1.00 16.03           N  
ATOM    815  CA  ILE A  96       0.068  54.247  15.948  1.00 15.36           C  
ATOM    816  C   ILE A  96      -0.462  53.242  16.968  1.00 14.59           C  
ATOM    817  O   ILE A  96      -0.347  52.017  16.800  1.00 15.41           O  
ATOM    818  CB  ILE A  96      -0.416  53.907  14.511  1.00 15.82           C  
ATOM    819  CG1 ILE A  96       0.268  54.782  13.471  1.00 20.07           C  
ATOM    820  CG2 ILE A  96      -1.946  54.087  14.349  1.00 15.53           C  
ATOM    821  CD1 ILE A  96       1.420  54.153  12.864  1.00 27.68           C  
ATOM    822  N   SER A  97      -1.062  53.773  18.022  1.00 16.36           N  
ATOM    823  CA  SER A  97      -1.584  52.990  19.149  1.00 15.96           C  
ATOM    824  C   SER A  97      -3.098  53.120  19.137  1.00 18.02           C  
ATOM    825  O   SER A  97      -3.675  53.463  18.112  1.00 17.03           O  
ATOM    826  CB  SER A  97      -1.006  53.509  20.459  1.00 18.69           C  
ATOM    827  OG  SER A  97      -1.446  54.831  20.694  1.00 19.13           O  
ATOM    828  N   SER A  98      -3.748  52.920  20.272  1.00 17.19           N  
ATOM    829  CA  SER A  98      -5.175  53.173  20.348  1.00 20.06           C  
ATOM    830  C   SER A  98      -5.479  54.619  20.727  1.00 21.09           C  
ATOM    831  O   SER A  98      -6.657  54.998  20.804  1.00 24.32           O  
ATOM    832  CB  SER A  98      -5.833  52.236  21.367  1.00 22.80           C  
ATOM    833  OG  SER A  98      -5.193  52.382  22.623  1.00 28.37           O  
ATOM    834  N   ASP A  99      -4.465  55.435  20.984  1.00 20.95           N  
ATOM    835  CA  ASP A  99      -4.746  56.855  21.243  1.00 22.51           C  
ATOM    836  C   ASP A  99      -5.154  57.592  19.951  1.00 24.52           C  
ATOM    837  O   ASP A  99      -5.148  56.998  18.874  1.00 24.10           O  
ATOM    838  CB  ASP A  99      -3.610  57.517  21.994  1.00 28.13           C  
ATOM    839  CG  ASP A  99      -2.463  57.890  21.139  1.00 28.02           C  
ATOM    840  OD1 ASP A  99      -2.566  57.920  19.885  1.00 30.51           O  
ATOM    841  OD2 ASP A  99      -1.410  58.180  21.756  1.00 43.29           O  
ATOM    842  N   ASP A 100      -5.551  58.861  20.049  1.00 23.12           N  
ATOM    843  CA  ASP A 100      -6.140  59.548  18.885  1.00 23.46           C  
ATOM    844  C   ASP A 100      -5.160  60.388  18.052  1.00 24.78           C  
ATOM    845  O   ASP A 100      -5.583  61.220  17.258  1.00 26.17           O  
ATOM    846  CB  ASP A 100      -7.353  60.387  19.323  1.00 25.36           C  
ATOM    847  CG  ASP A 100      -6.986  61.532  20.216  1.00 33.27           C  
ATOM    848  OD1 ASP A 100      -5.785  61.858  20.338  1.00 31.81           O  
ATOM    849  OD2 ASP A 100      -7.928  62.125  20.800  1.00 41.23           O  
ATOM    850  N   SER A 101      -3.870  60.134  18.212  1.00 22.69           N  
ATOM    851  CA  SER A 101      -2.811  60.897  17.543  1.00 22.87           C  
ATOM    852  C   SER A 101      -2.711  60.689  16.039  1.00 23.17           C  
ATOM    853  O   SER A 101      -2.196  61.534  15.332  1.00 23.60           O  
ATOM    854  CB  SER A 101      -1.455  60.531  18.187  1.00 27.11           C  
ATOM    855  OG  SER A 101      -1.440  60.937  19.548  1.00 35.94           O  
ATOM    856  N   HIS A 102      -3.146  59.538  15.537  1.00 20.65           N  
ATOM    857  CA  HIS A 102      -2.941  59.196  14.131  1.00 17.73           C  
ATOM    858  C   HIS A 102      -4.165  58.496  13.570  1.00 19.86           C  
ATOM    859  O   HIS A 102      -4.072  57.388  13.046  1.00 17.13           O  
ATOM    860  CB  HIS A 102      -1.734  58.309  14.009  1.00 18.92           C  
ATOM    861  CG  HIS A 102      -0.466  58.980  14.438  1.00 20.87           C  
ATOM    862  ND1 HIS A 102       0.086  60.028  13.735  1.00 22.84           N  
ATOM    863  CD2 HIS A 102       0.332  58.769  15.509  1.00 22.07           C  
ATOM    864  CE1 HIS A 102       1.208  60.399  14.334  1.00 20.56           C  
ATOM    865  NE2 HIS A 102       1.371  59.659  15.420  1.00 22.51           N  
ATOM    866  N   GLN A 103      -5.295  59.182  13.616  1.00 18.67           N  
ATOM    867  CA  GLN A 103      -6.579  58.569  13.232  1.00 19.09           C  
ATOM    868  C   GLN A 103      -6.585  58.132  11.801  1.00 19.03           C  
ATOM    869  O   GLN A 103      -7.171  57.078  11.470  1.00 17.75           O  
ATOM    870  CB  GLN A 103      -7.746  59.518  13.498  1.00 21.26           C  
ATOM    871  CG  GLN A 103      -8.186  59.499  14.923  1.00 24.44           C  
ATOM    872  CD  GLN A 103      -8.423  58.074  15.451  1.00 32.08           C  
ATOM    873  OE1 GLN A 103      -7.609  57.582  16.229  1.00 35.33           O  
ATOM    874  NE2 GLN A 103      -9.487  57.374  14.962  1.00 26.18           N  
ATOM    875  N   ASP A 104      -5.926  58.894  10.939  1.00 17.90           N  
ATOM    876  CA  ASP A 104      -5.806  58.534   9.538  1.00 20.87           C  
ATOM    877  C   ASP A 104      -5.090  57.219   9.270  1.00 21.71           C  
ATOM    878  O   ASP A 104      -5.248  56.653   8.205  1.00 22.48           O  
ATOM    879  CB  ASP A 104      -5.125  59.642   8.720  1.00 24.75           C  
ATOM    880  CG  ASP A 104      -3.729  60.022   9.251  1.00 36.98           C  
ATOM    881  OD1 ASP A 104      -3.512  60.051  10.487  1.00 45.63           O  
ATOM    882  OD2 ASP A 104      -2.852  60.341   8.416  1.00 54.72           O  
ATOM    883  N   LEU A 105      -4.287  56.738  10.227  1.00 17.10           N  
ATOM    884  CA  LEU A 105      -3.575  55.497  10.054  1.00 16.63           C  
ATOM    885  C   LEU A 105      -4.211  54.342  10.847  1.00 12.58           C  
ATOM    886  O   LEU A 105      -3.616  53.268  10.940  1.00 14.48           O  
ATOM    887  CB  LEU A 105      -2.107  55.661  10.493  1.00 17.44           C  
ATOM    888  CG  LEU A 105      -1.282  56.506   9.491  1.00 22.22           C  
ATOM    889  CD1 LEU A 105      -0.008  56.997  10.109  1.00 21.92           C  
ATOM    890  CD2 LEU A 105      -0.978  55.610   8.280  1.00 25.48           C  
ATOM    891  N   GLN A 106      -5.377  54.563  11.424  1.00 12.87           N  
ATOM    892  CA  GLN A 106      -6.033  53.412  12.107  1.00 11.12           C  
ATOM    893  C   GLN A 106      -6.294  52.254  11.149  1.00 11.96           C  
ATOM    894  O   GLN A 106      -6.097  51.109  11.525  1.00 13.09           O  
ATOM    895  CB  GLN A 106      -7.258  53.821  12.898  1.00 12.59           C  
ATOM    896  CG  GLN A 106      -6.879  54.609  14.147  1.00 14.66           C  
ATOM    897  CD  GLN A 106      -6.098  53.823  15.157  1.00 14.59           C  
ATOM    898  OE1 GLN A 106      -6.350  52.624  15.341  1.00 14.83           O  
ATOM    899  NE2 GLN A 106      -5.135  54.501  15.848  1.00 14.37           N  
ATOM    900  N   PRO A 107      -6.783  52.493   9.901  1.00 12.23           N  
ATOM    901  CA  PRO A 107      -6.960  51.367   9.014  1.00 13.44           C  
ATOM    902  C   PRO A 107      -5.672  50.550   8.818  1.00 12.36           C  
ATOM    903  O   PRO A 107      -5.744  49.307   8.762  1.00 12.87           O  
ATOM    904  CB  PRO A 107      -7.460  52.011   7.718  1.00 13.69           C  
ATOM    905  CG  PRO A 107      -8.144  53.263   8.185  1.00 12.85           C  
ATOM    906  CD  PRO A 107      -7.322  53.751   9.306  1.00 13.08           C  
ATOM    907  N   ALA A 108      -4.505  51.213   8.745  1.00 13.27           N  
ATOM    908  CA  ALA A 108      -3.258  50.500   8.625  1.00 12.85           C  
ATOM    909  C   ALA A 108      -2.977  49.674   9.850  1.00 12.98           C  
ATOM    910  O   ALA A 108      -2.492  48.575   9.770  1.00 13.85           O  
ATOM    911  CB  ALA A 108      -2.098  51.469   8.366  1.00 14.54           C  
ATOM    912  N   ARG A 109      -3.230  50.232  11.019  1.00 12.39           N  
ATOM    913  CA  ARG A 109      -3.038  49.492  12.272  1.00 12.21           C  
ATOM    914  C   ARG A 109      -3.935  48.259  12.376  1.00 11.82           C  
ATOM    915  O   ARG A 109      -3.489  47.173  12.781  1.00 13.27           O  
ATOM    916  CB  ARG A 109      -3.248  50.447  13.456  1.00 13.19           C  
ATOM    917  CG  ARG A 109      -3.186  49.816  14.868  1.00 12.82           C  
ATOM    918  CD  ARG A 109      -3.317  50.848  15.951  1.00 13.30           C  
ATOM    919  NE  ARG A 109      -3.451  50.235  17.267  1.00 14.88           N  
ATOM    920  CZ  ARG A 109      -4.590  50.089  17.939  1.00 15.86           C  
ATOM    921  NH1 ARG A 109      -5.752  50.540  17.455  1.00 14.17           N  
ATOM    922  NH2 ARG A 109      -4.562  49.447  19.103  1.00 15.03           N  
ATOM    923  N   ILE A 110      -5.184  48.451  12.013  1.00 11.64           N  
ATOM    924  CA  ILE A 110      -6.189  47.368  12.045  1.00 12.19           C  
ATOM    925  C   ILE A 110      -5.804  46.262  11.054  1.00 12.54           C  
ATOM    926  O   ILE A 110      -5.853  45.072  11.360  1.00 13.65           O  
ATOM    927  CB  ILE A 110      -7.598  47.916  11.734  1.00 12.12           C  
ATOM    928  CG1 ILE A 110      -8.017  48.864  12.853  1.00 11.87           C  
ATOM    929  CG2 ILE A 110      -8.598  46.745  11.610  1.00 14.30           C  
ATOM    930  CD1 ILE A 110      -9.100  49.925  12.483  1.00 12.81           C  
ATOM    931  N   ALA A 111      -5.391  46.632   9.828  1.00 12.27           N  
ATOM    932  CA  ALA A 111      -4.945  45.677   8.849  1.00 13.82           C  
ATOM    933  C   ALA A 111      -3.767  44.878   9.364  1.00 13.18           C  
ATOM    934  O   ALA A 111      -3.710  43.670   9.180  1.00 14.81           O  
ATOM    935  CB  ALA A 111      -4.575  46.399   7.515  1.00 14.95           C  
HETATM  936  N   MSE A 112      -2.784  45.559   9.957  1.00 12.87           N  
HETATM  937  CA  MSE A 112      -1.632  44.840  10.479  1.00 13.41           C  
HETATM  938  C   MSE A 112      -2.050  43.802  11.521  1.00 12.92           C  
HETATM  939  O   MSE A 112      -1.600  42.647  11.515  1.00 14.11           O  
HETATM  940  CB  MSE A 112      -0.631  45.815  11.042  1.00 15.15           C  
HETATM  941  CG  MSE A 112       0.616  45.251  11.703  1.00 15.70           C  
HETATM  942 SE   MSE A 112       2.022  44.804  10.430  0.75 20.94          SE  
HETATM  943  CE  MSE A 112       1.472  43.092  10.175  1.00 19.25           C  
ATOM    944  N   TRP A 113      -2.870  44.231  12.474  1.00 12.82           N  
ATOM    945  CA  TRP A 113      -3.385  43.326  13.509  1.00 13.42           C  
ATOM    946  C   TRP A 113      -3.994  42.083  12.897  1.00 13.14           C  
ATOM    947  O   TRP A 113      -3.764  40.955  13.338  1.00 13.47           O  
ATOM    948  CB  TRP A 113      -4.471  44.069  14.337  1.00 12.74           C  
ATOM    949  CG  TRP A 113      -5.094  43.223  15.388  1.00 11.05           C  
ATOM    950  CD1 TRP A 113      -6.361  42.691  15.360  1.00 12.69           C  
ATOM    951  CD2 TRP A 113      -4.525  42.835  16.631  1.00 12.10           C  
ATOM    952  NE1 TRP A 113      -6.613  42.025  16.524  1.00 11.91           N  
ATOM    953  CE2 TRP A 113      -5.504  42.086  17.327  1.00 11.65           C  
ATOM    954  CE3 TRP A 113      -3.287  43.028  17.225  1.00 11.48           C  
ATOM    955  CZ2 TRP A 113      -5.285  41.572  18.574  1.00 12.17           C  
ATOM    956  CZ3 TRP A 113      -3.081  42.504  18.497  1.00 13.58           C  
ATOM    957  CH2 TRP A 113      -4.074  41.778  19.138  1.00 12.62           C  
ATOM    958  N   GLN A 114      -4.848  42.289  11.900  1.00 13.34           N  
ATOM    959  CA  GLN A 114      -5.569  41.205  11.265  1.00 13.76           C  
ATOM    960  C   GLN A 114      -4.653  40.241  10.484  1.00 15.19           C  
ATOM    961  O   GLN A 114      -4.986  39.046  10.365  1.00 16.41           O  
ATOM    962  CB  GLN A 114      -6.638  41.773  10.358  1.00 15.86           C  
ATOM    963  CG  GLN A 114      -7.753  42.428  11.176  1.00 14.61           C  
ATOM    964  CD  GLN A 114      -8.855  42.953  10.305  1.00 16.70           C  
ATOM    965  OE1 GLN A 114      -8.787  42.810   9.076  1.00 20.63           O  
ATOM    966  NE2 GLN A 114      -9.845  43.622  10.893  1.00 14.23           N  
ATOM    967  N   GLU A 115      -3.544  40.759   9.973  1.00 14.84           N  
ATOM    968  CA  GLU A 115      -2.601  39.980   9.198  1.00 15.18           C  
ATOM    969  C   GLU A 115      -1.695  39.117  10.043  1.00 17.17           C  
ATOM    970  O   GLU A 115      -1.015  38.189   9.530  1.00 18.31           O  
ATOM    971  CB  GLU A 115      -1.765  40.962   8.330  1.00 16.03           C  
ATOM    972  CG  GLU A 115      -2.581  41.561   7.227  1.00 20.74           C  
ATOM    973  CD  GLU A 115      -2.053  42.842   6.563  1.00 25.22           C  
ATOM    974  OE1 GLU A 115      -0.924  43.261   6.875  1.00 26.96           O  
ATOM    975  OE2 GLU A 115      -2.794  43.413   5.701  1.00 27.23           O  
ATOM    976  N   LEU A 116      -1.594  39.413  11.321  1.00 14.89           N  
ATOM    977  CA  LEU A 116      -0.783  38.627  12.210  1.00 15.15           C  
ATOM    978  C   LEU A 116      -1.259  37.189  12.374  1.00 17.10           C  
ATOM    979  O   LEU A 116      -2.424  36.866  12.162  1.00 16.82           O  
ATOM    980  CB  LEU A 116      -0.731  39.262  13.588  1.00 15.44           C  
ATOM    981  CG  LEU A 116      -0.137  40.672  13.665  1.00 14.11           C  
ATOM    982  CD1 LEU A 116      -0.201  41.123  15.118  1.00 15.94           C  
ATOM    983  CD2 LEU A 116       1.301  40.732  13.160  1.00 17.93           C  
ATOM    984  N   SER A 117      -0.350  36.303  12.817  1.00 18.84           N  
ATOM    985  CA  SER A 117      -0.819  35.037  13.313  1.00 18.42           C  
ATOM    986  C   SER A 117      -1.508  35.120  14.690  1.00 19.14           C  
ATOM    987  O   SER A 117      -1.339  36.080  15.438  1.00 17.24           O  
ATOM    988  CB  SER A 117       0.364  34.050  13.458  1.00 20.15           C  
ATOM    989  OG  SER A 117       1.259  34.568  14.418  1.00 20.87           O  
ATOM    990  N   ASP A 118      -2.242  34.069  15.057  1.00 18.89           N  
ATOM    991  CA  ASP A 118      -2.763  33.979  16.416  1.00 20.06           C  
ATOM    992  C   ASP A 118      -1.662  34.092  17.436  1.00 20.35           C  
ATOM    993  O   ASP A 118      -1.822  34.740  18.443  1.00 20.21           O  
ATOM    994  CB  ASP A 118      -3.562  32.686  16.645  1.00 21.28           C  
ATOM    995  CG  ASP A 118      -4.918  32.688  15.983  1.00 26.27           C  
ATOM    996  OD1 ASP A 118      -5.541  33.778  15.819  1.00 29.53           O  
ATOM    997  OD2 ASP A 118      -5.426  31.572  15.703  1.00 31.28           O  
ATOM    998  N   ALA A 119      -0.541  33.411  17.188  1.00 20.39           N  
ATOM    999  CA  ALA A 119       0.564  33.457  18.152  1.00 20.55           C  
ATOM   1000  C   ALA A 119       1.061  34.873  18.418  1.00 19.62           C  
ATOM   1001  O   ALA A 119       1.353  35.264  19.575  1.00 19.95           O  
ATOM   1002  CB  ALA A 119       1.744  32.548  17.650  1.00 22.26           C  
ATOM   1003  N   ALA A 120       1.165  35.650  17.345  1.00 19.20           N  
ATOM   1004  CA  ALA A 120       1.669  36.975  17.423  1.00 18.42           C  
ATOM   1005  C   ALA A 120       0.649  37.851  18.170  1.00 19.73           C  
ATOM   1006  O   ALA A 120       1.033  38.637  19.028  1.00 18.64           O  
ATOM   1007  CB  ALA A 120       2.002  37.556  16.036  1.00 19.18           C  
ATOM   1008  N   ARG A 121      -0.652  37.707  17.865  1.00 17.19           N  
ATOM   1009  CA  ARG A 121      -1.641  38.491  18.639  1.00 14.56           C  
ATOM   1010  C   ARG A 121      -1.676  38.137  20.123  1.00 15.92           C  
ATOM   1011  O   ARG A 121      -1.846  38.995  20.973  1.00 16.85           O  
ATOM   1012  CB  ARG A 121      -3.038  38.344  18.054  1.00 15.25           C  
ATOM   1013  CG  ARG A 121      -3.266  39.073  16.727  1.00 14.61           C  
ATOM   1014  CD  ARG A 121      -4.719  39.025  16.280  1.00 13.89           C  
ATOM   1015  NE  ARG A 121      -5.096  37.708  15.746  1.00 14.66           N  
ATOM   1016  CZ  ARG A 121      -4.897  37.337  14.491  1.00 15.85           C  
ATOM   1017  NH1 ARG A 121      -4.466  38.194  13.571  1.00 15.01           N  
ATOM   1018  NH2 ARG A 121      -5.121  36.082  14.161  1.00 18.17           N  
ATOM   1019  N   LEU A 122      -1.499  36.826  20.423  1.00 18.30           N  
ATOM   1020  CA  LEU A 122      -1.582  36.316  21.802  0.50 17.84           C  
ATOM   1022  C   LEU A 122      -0.549  37.012  22.706  1.00 17.29           C  
ATOM   1023  O   LEU A 122      -0.817  37.276  23.873  1.00 17.53           O  
ATOM   1024  CB  LEU A 122      -1.365  34.782  21.843  0.50 19.92           C  
ATOM   1026  CG  LEU A 122      -2.531  33.822  21.537  0.50 23.06           C  
ATOM   1028  CD1 LEU A 122      -2.036  32.417  21.222  0.50 25.31           C  
ATOM   1030  CD2 LEU A 122      -3.515  33.745  22.699  0.50 20.78           C  
ATOM   1032  N   GLN A 123       0.618  37.321  22.180  1.00 19.06           N  
ATOM   1033  CA  GLN A 123       1.673  37.937  22.997  1.00 19.17           C  
ATOM   1034  C   GLN A 123       1.285  39.271  23.586  1.00 20.08           C  
ATOM   1035  O   GLN A 123       1.801  39.667  24.614  1.00 18.80           O  
ATOM   1036  CB  GLN A 123       2.975  38.112  22.213  1.00 21.80           C  
ATOM   1037  CG  GLN A 123       3.616  36.866  21.758  1.00 27.46           C  
ATOM   1038  CD  GLN A 123       5.099  37.058  21.353  1.00 23.98           C  
ATOM   1039  OE1 GLN A 123       5.678  38.138  21.510  1.00 34.51           O  
ATOM   1040  NE2 GLN A 123       5.700  35.995  20.848  1.00 37.32           N  
ATOM   1041  N   PHE A 124       0.342  39.978  22.953  1.00 17.48           N  
ATOM   1042  CA  PHE A 124      -0.104  41.247  23.506  1.00 17.26           C  
ATOM   1043  C   PHE A 124      -0.940  41.046  24.783  1.00 17.77           C  
ATOM   1044  O   PHE A 124      -1.157  42.008  25.517  1.00 19.22           O  
ATOM   1045  CB  PHE A 124      -0.837  42.055  22.423  1.00 15.98           C  
ATOM   1046  CG  PHE A 124       0.113  42.540  21.354  1.00 14.54           C  
ATOM   1047  CD1 PHE A 124       0.809  43.727  21.514  1.00 17.30           C  
ATOM   1048  CD2 PHE A 124       0.430  41.725  20.273  1.00 14.94           C  
ATOM   1049  CE1 PHE A 124       1.732  44.124  20.616  1.00 17.00           C  
ATOM   1050  CE2 PHE A 124       1.383  42.111  19.363  1.00 16.36           C  
ATOM   1051  CZ  PHE A 124       2.052  43.336  19.535  1.00 15.65           C  
ATOM   1052  N   GLY A 125      -1.322  39.793  25.081  1.00 18.68           N  
ATOM   1053  CA  GLY A 125      -1.997  39.471  26.325  1.00 18.79           C  
ATOM   1054  C   GLY A 125      -1.098  38.979  27.433  1.00 17.96           C  
ATOM   1055  O   GLY A 125      -1.572  38.630  28.525  1.00 21.47           O  
ATOM   1056  N   TRP A 126       0.198  38.968  27.187  1.00 17.61           N  
ATOM   1057  CA  TRP A 126       1.182  38.548  28.197  1.00 17.26           C  
ATOM   1058  C   TRP A 126       1.350  39.595  29.303  1.00 18.35           C  
ATOM   1059  O   TRP A 126       0.949  40.744  29.162  1.00 17.01           O  
ATOM   1060  CB  TRP A 126       2.534  38.289  27.530  1.00 18.45           C  
ATOM   1061  CG  TRP A 126       2.612  37.033  26.720  1.00 18.25           C  
ATOM   1062  CD1 TRP A 126       1.625  36.120  26.494  1.00 16.36           C  
ATOM   1063  CD2 TRP A 126       3.761  36.562  26.027  1.00 15.33           C  
ATOM   1064  NE1 TRP A 126       2.094  35.118  25.681  1.00 19.86           N  
ATOM   1065  CE2 TRP A 126       3.411  35.366  25.384  1.00 19.65           C  
ATOM   1066  CE3 TRP A 126       5.063  37.056  25.882  1.00 19.77           C  
ATOM   1067  CZ2 TRP A 126       4.301  34.637  24.634  1.00 19.36           C  
ATOM   1068  CZ3 TRP A 126       5.939  36.351  25.104  1.00 21.27           C  
ATOM   1069  CH2 TRP A 126       5.567  35.137  24.511  1.00 20.16           C  
ATOM   1070  N   PRO A 127       1.872  39.176  30.466  1.00 17.62           N  
ATOM   1071  CA  PRO A 127       2.045  40.147  31.530  1.00 18.04           C  
ATOM   1072  C   PRO A 127       3.022  41.254  31.208  1.00 18.79           C  
ATOM   1073  O   PRO A 127       3.768  41.148  30.247  1.00 20.93           O  
ATOM   1074  CB  PRO A 127       2.527  39.303  32.722  1.00 20.67           C  
ATOM   1075  CG  PRO A 127       2.899  38.011  32.192  1.00 23.92           C  
ATOM   1076  CD  PRO A 127       2.232  37.811  30.855  1.00 19.62           C  
ATOM   1077  N   TYR A 128       2.959  42.311  32.013  1.00 20.25           N  
ATOM   1078  CA  TYR A 128       3.627  43.580  31.761  1.00 19.31           C  
ATOM   1079  C   TYR A 128       5.137  43.400  31.519  1.00 20.30           C  
ATOM   1080  O   TYR A 128       5.856  42.948  32.388  1.00 19.43           O  
ATOM   1081  CB  TYR A 128       3.414  44.528  32.931  1.00 18.68           C  
ATOM   1082  CG  TYR A 128       3.483  45.980  32.557  1.00 17.09           C  
ATOM   1083  CD1 TYR A 128       4.688  46.575  32.230  1.00 21.07           C  
ATOM   1084  CD2 TYR A 128       2.350  46.763  32.538  1.00 22.44           C  
ATOM   1085  CE1 TYR A 128       4.758  47.918  31.886  1.00 18.94           C  
ATOM   1086  CE2 TYR A 128       2.415  48.115  32.190  1.00 21.22           C  
ATOM   1087  CZ  TYR A 128       3.621  48.666  31.862  1.00 25.57           C  
ATOM   1088  OH  TYR A 128       3.720  49.994  31.512  1.00 26.47           O  
ATOM   1089  N   PRO A 129       5.604  43.740  30.317  1.00 19.00           N  
ATOM   1090  CA  PRO A 129       6.997  43.503  29.991  1.00 20.50           C  
ATOM   1091  C   PRO A 129       7.942  44.220  30.931  1.00 21.63           C  
ATOM   1092  O   PRO A 129       7.701  45.378  31.309  1.00 22.84           O  
ATOM   1093  CB  PRO A 129       7.136  44.069  28.577  1.00 22.23           C  
ATOM   1094  CG  PRO A 129       6.050  45.010  28.427  1.00 23.29           C  
ATOM   1095  CD  PRO A 129       4.899  44.401  29.212  1.00 20.63           C  
ATOM   1096  N   GLY A 130       9.010  43.525  31.316  1.00 20.82           N  
ATOM   1097  CA  GLY A 130      10.034  44.092  32.199  1.00 21.21           C  
ATOM   1098  C   GLY A 130       9.810  44.000  33.700  1.00 22.51           C  
ATOM   1099  O   GLY A 130      10.697  44.304  34.478  1.00 24.68           O  
ATOM   1100  N   LYS A 131       8.629  43.597  34.132  1.00 20.10           N  
ATOM   1101  CA  LYS A 131       8.378  43.459  35.539  1.00 20.50           C  
ATOM   1102  C   LYS A 131       8.887  42.099  35.979  1.00 22.39           C  
ATOM   1103  O   LYS A 131       9.161  41.273  35.152  1.00 18.81           O  
ATOM   1104  CB  LYS A 131       6.871  43.594  35.815  1.00 21.81           C  
ATOM   1105  CG  LYS A 131       6.294  44.938  35.395  1.00 24.68           C  
ATOM   1106  CD  LYS A 131       6.993  46.106  36.032  1.00 34.13           C  
ATOM   1107  CE  LYS A 131       6.244  47.412  35.760  1.00 41.24           C  
ATOM   1108  NZ  LYS A 131       6.707  48.496  36.660  1.00 36.23           N  
ATOM   1109  N   PRO A 132       8.996  41.858  37.299  1.00 20.31           N  
ATOM   1110  CA  PRO A 132       9.407  40.542  37.791  1.00 20.91           C  
ATOM   1111  C   PRO A 132       8.640  39.386  37.181  1.00 17.95           C  
ATOM   1112  O   PRO A 132       7.416  39.441  37.090  1.00 22.36           O  
ATOM   1113  CB  PRO A 132       9.110  40.649  39.292  1.00 23.22           C  
ATOM   1114  CG  PRO A 132       9.457  42.118  39.576  1.00 24.10           C  
ATOM   1115  CD  PRO A 132       8.791  42.809  38.423  1.00 22.49           C  
ATOM   1116  N   ARG A 133       9.353  38.346  36.768  1.00 17.74           N  
ATOM   1117  CA  ARG A 133       8.784  37.269  35.958  1.00 15.74           C  
ATOM   1118  C   ARG A 133       7.664  36.565  36.721  1.00 19.26           C  
ATOM   1119  O   ARG A 133       7.869  36.103  37.849  1.00 20.99           O  
ATOM   1120  CB  ARG A 133       9.858  36.253  35.589  1.00 18.97           C  
ATOM   1121  CG  ARG A 133       9.326  34.982  34.878  1.00 19.90           C  
ATOM   1122  CD  ARG A 133       8.473  35.307  33.694  1.00 17.48           C  
ATOM   1123  NE  ARG A 133       7.935  34.113  33.091  1.00 16.15           N  
ATOM   1124  CZ  ARG A 133       8.433  33.454  32.060  1.00 22.81           C  
ATOM   1125  NH1 ARG A 133       9.567  33.843  31.489  1.00 22.43           N  
ATOM   1126  NH2 ARG A 133       7.774  32.384  31.607  1.00 25.84           N  
ATOM   1127  N   ILE A 134       6.476  36.537  36.121  1.00 19.36           N  
ATOM   1128  CA  ILE A 134       5.360  35.736  36.618  1.00 18.11           C  
ATOM   1129  C   ILE A 134       5.736  34.267  36.424  1.00 19.87           C  
ATOM   1130  O   ILE A 134       6.014  33.848  35.308  1.00 19.25           O  
ATOM   1131  CB  ILE A 134       4.088  36.079  35.848  1.00 19.39           C  
ATOM   1132  CG1 ILE A 134       3.635  37.511  36.186  1.00 22.92           C  
ATOM   1133  CG2 ILE A 134       2.949  35.077  36.160  1.00 23.26           C  
ATOM   1134  CD1 ILE A 134       3.239  37.686  37.651  1.00 28.47           C  
ATOM   1135  N   LYS A 135       5.671  33.478  37.497  1.00 22.78           N  
ATOM   1136  CA  LYS A 135       6.189  32.096  37.461  1.00 27.22           C  
ATOM   1137  C   LYS A 135       5.165  31.062  36.969  1.00 29.80           C  
ATOM   1138  O   LYS A 135       5.553  29.952  36.571  1.00 29.88           O  
ATOM   1139  CB  LYS A 135       6.695  31.669  38.827  1.00 26.96           C  
ATOM   1140  CG  LYS A 135       8.001  32.338  39.248  1.00 25.39           C  
ATOM   1141  CD  LYS A 135       8.335  31.933  40.701  1.00 31.68           C  
ATOM   1142  CE  LYS A 135       9.542  32.677  41.243  1.00 40.66           C  
ATOM   1143  NZ  LYS A 135       9.253  34.132  41.456  1.00 48.50           N  
ATOM   1144  N   GLU A 136       3.887  31.423  36.951  1.00 29.27           N  
ATOM   1145  CA  GLU A 136       2.849  30.501  36.495  1.00 32.36           C  
ATOM   1146  C   GLU A 136       2.710  30.566  34.967  1.00 33.16           C  
ATOM   1147  O   GLU A 136       2.510  31.641  34.389  1.00 33.14           O  
ATOM   1148  CB  GLU A 136       1.511  30.806  37.170  1.00 33.81           C  
ATOM   1149  CG  GLU A 136       1.531  30.522  38.677  1.00 36.72           C  
ATOM   1150  CD  GLU A 136       2.372  31.522  39.482  1.00 45.25           C  
ATOM   1151  OE1 GLU A 136       2.507  32.683  39.019  1.00 41.95           O  
ATOM   1152  OE2 GLU A 136       2.888  31.146  40.576  1.00 39.02           O  
ATOM   1153  N   SER A 137       2.786  29.401  34.320  1.00 33.90           N  
ATOM   1154  CA  SER A 137       2.725  29.317  32.858  1.00 33.01           C  
ATOM   1155  C   SER A 137       1.398  29.847  32.312  1.00 31.78           C  
ATOM   1156  O   SER A 137       1.339  30.311  31.167  1.00 33.24           O  
ATOM   1157  N   GLY A 138       0.346  29.771  33.131  1.00 29.70           N  
ATOM   1158  CA  GLY A 138      -0.989  30.214  32.741  1.00 28.29           C  
ATOM   1159  C   GLY A 138      -1.066  31.649  32.232  1.00 25.88           C  
ATOM   1160  O   GLY A 138      -1.807  31.935  31.292  1.00 26.12           O  
ATOM   1161  N   ALA A 139      -0.284  32.540  32.855  1.00 24.83           N  
ATOM   1162  CA  ALA A 139      -0.258  33.965  32.505  1.00 24.47           C  
ATOM   1163  C   ALA A 139       0.222  34.185  31.081  1.00 21.89           C  
ATOM   1164  O   ALA A 139      -0.050  35.210  30.492  1.00 22.31           O  
ATOM   1165  CB  ALA A 139       0.645  34.729  33.472  1.00 26.17           C  
ATOM   1166  N   PHE A 140       0.931  33.200  30.528  1.00 21.83           N  
ATOM   1167  CA  PHE A 140       1.463  33.277  29.170  1.00 19.71           C  
ATOM   1168  C   PHE A 140       0.646  32.502  28.149  1.00 20.47           C  
ATOM   1169  O   PHE A 140       1.015  32.458  26.970  1.00 23.61           O  
ATOM   1170  CB  PHE A 140       2.932  32.833  29.179  1.00 22.83           C  
ATOM   1171  CG  PHE A 140       3.798  33.795  29.910  1.00 19.32           C  
ATOM   1172  CD1 PHE A 140       4.335  34.885  29.245  1.00 22.60           C  
ATOM   1173  CD2 PHE A 140       4.042  33.662  31.275  1.00 19.89           C  
ATOM   1174  CE1 PHE A 140       5.090  35.825  29.901  1.00 20.74           C  
ATOM   1175  CE2 PHE A 140       4.783  34.599  31.936  1.00 22.17           C  
ATOM   1176  CZ  PHE A 140       5.338  35.682  31.231  1.00 22.73           C  
ATOM   1177  N   GLU A 141      -0.496  31.977  28.602  1.00 20.12           N  
ATOM   1178  CA  GLU A 141      -1.421  31.185  27.787  1.00 20.86           C  
ATOM   1179  C   GLU A 141      -2.818  31.770  27.830  1.00 17.75           C  
ATOM   1180  O   GLU A 141      -3.768  31.064  28.074  1.00 19.04           O  
ATOM   1181  CB  GLU A 141      -1.473  29.741  28.330  1.00 20.16           C  
ATOM   1182  CG  GLU A 141      -0.112  29.051  28.314  1.00 25.36           C  
ATOM   1183  CD  GLU A 141      -0.097  27.679  28.971  1.00 30.33           C  
ATOM   1184  OE1 GLU A 141      -1.047  27.327  29.705  1.00 41.84           O  
ATOM   1185  OE2 GLU A 141       0.917  26.965  28.781  1.00 46.76           O  
ATOM   1186  N   PRO A 142      -2.939  33.095  27.568  1.00 18.67           N  
ATOM   1187  CA  PRO A 142      -4.290  33.662  27.565  1.00 20.82           C  
ATOM   1188  C   PRO A 142      -5.109  33.173  26.376  1.00 17.27           C  
ATOM   1189  O   PRO A 142      -4.543  32.700  25.403  1.00 19.32           O  
ATOM   1190  CB  PRO A 142      -4.018  35.164  27.440  1.00 23.14           C  
ATOM   1191  CG  PRO A 142      -2.796  35.251  26.696  1.00 24.38           C  
ATOM   1192  CD  PRO A 142      -1.923  34.103  27.226  1.00 21.35           C  
ATOM   1193  N   SER A 143      -6.426  33.299  26.431  1.00 16.33           N  
ATOM   1194  CA  SER A 143      -7.273  33.015  25.262  1.00 17.25           C  
ATOM   1195  C   SER A 143      -6.927  34.025  24.188  1.00 17.93           C  
ATOM   1196  O   SER A 143      -6.568  35.158  24.483  1.00 16.98           O  
ATOM   1197  CB  SER A 143      -8.718  33.218  25.645  1.00 19.38           C  
ATOM   1198  OG  SER A 143      -9.603  32.588  24.747  1.00 21.75           O  
ATOM   1199  N   PRO A 144      -7.036  33.626  22.911  1.00 20.87           N  
ATOM   1200  CA  PRO A 144      -6.659  34.557  21.850  1.00 19.90           C  
ATOM   1201  C   PRO A 144      -7.507  35.789  21.907  1.00 14.71           C  
ATOM   1202  O   PRO A 144      -8.689  35.705  22.172  1.00 18.35           O  
ATOM   1203  CB  PRO A 144      -7.092  33.804  20.570  1.00 23.06           C  
ATOM   1204  CG  PRO A 144      -8.126  32.831  21.029  1.00 29.04           C  
ATOM   1205  CD  PRO A 144      -7.574  32.374  22.347  1.00 23.71           C  
ATOM   1206  N   PRO A 145      -6.913  36.953  21.624  1.00 13.93           N  
ATOM   1207  CA  PRO A 145      -7.748  38.126  21.523  1.00 14.17           C  
ATOM   1208  C   PRO A 145      -8.617  38.131  20.257  1.00 13.30           C  
ATOM   1209  O   PRO A 145      -8.432  37.315  19.336  1.00 15.27           O  
ATOM   1210  CB  PRO A 145      -6.739  39.263  21.518  1.00 15.93           C  
ATOM   1211  CG  PRO A 145      -5.606  38.709  20.888  1.00 16.71           C  
ATOM   1212  CD  PRO A 145      -5.514  37.275  21.385  1.00 16.38           C  
ATOM   1213  N   ASP A 146      -9.516  39.093  20.187  1.00 12.71           N  
ATOM   1214  CA  ASP A 146     -10.333  39.315  18.978  1.00 12.43           C  
ATOM   1215  C   ASP A 146      -9.390  39.468  17.780  1.00 12.81           C  
ATOM   1216  O   ASP A 146      -8.528  40.317  17.798  1.00 13.02           O  
ATOM   1217  CB  ASP A 146     -11.107  40.625  19.181  1.00 11.07           C  
ATOM   1218  CG  ASP A 146     -12.107  40.903  18.141  1.00 12.14           C  
ATOM   1219  OD1 ASP A 146     -11.810  40.631  16.968  1.00 15.27           O  
ATOM   1220  OD2 ASP A 146     -13.165  41.441  18.429  1.00 11.80           O  
ATOM   1221  N   PRO A 147      -9.535  38.616  16.758  1.00 12.74           N  
ATOM   1222  CA  PRO A 147      -8.594  38.673  15.642  1.00 13.85           C  
ATOM   1223  C   PRO A 147      -8.923  39.753  14.622  1.00 12.45           C  
ATOM   1224  O   PRO A 147      -8.144  39.985  13.689  1.00 13.94           O  
ATOM   1225  CB  PRO A 147      -8.743  37.282  15.020  1.00 15.15           C  
ATOM   1226  CG  PRO A 147     -10.178  36.914  15.286  1.00 14.57           C  
ATOM   1227  CD  PRO A 147     -10.419  37.428  16.687  1.00 13.55           C  
ATOM   1228  N   ILE A 148     -10.020  40.458  14.847  1.00 11.68           N  
ATOM   1229  CA  ILE A 148     -10.486  41.529  13.964  1.00 12.32           C  
ATOM   1230  C   ILE A 148     -10.105  42.915  14.521  1.00 12.42           C  
ATOM   1231  O   ILE A 148      -9.781  43.858  13.786  1.00 13.41           O  
ATOM   1232  CB  ILE A 148     -12.025  41.448  13.769  1.00 12.72           C  
ATOM   1233  CG1 ILE A 148     -12.404  40.088  13.208  1.00 17.96           C  
ATOM   1234  CG2 ILE A 148     -12.582  42.591  12.918  1.00 12.12           C  
ATOM   1235  CD1 ILE A 148     -11.741  39.750  11.936  1.00 22.06           C  
ATOM   1236  N   GLU A 149     -10.195  43.071  15.851  1.00 12.37           N  
ATOM   1237  CA  GLU A 149     -10.138  44.368  16.517  1.00 11.96           C  
ATOM   1238  C   GLU A 149      -8.932  44.444  17.424  1.00 12.21           C  
ATOM   1239  O   GLU A 149      -8.844  43.678  18.375  1.00 12.30           O  
ATOM   1240  CB  GLU A 149     -11.419  44.542  17.345  1.00 12.84           C  
ATOM   1241  CG  GLU A 149     -12.681  44.366  16.504  1.00 11.33           C  
ATOM   1242  CD  GLU A 149     -13.935  45.011  17.001  1.00 11.80           C  
ATOM   1243  OE1 GLU A 149     -13.938  45.729  18.028  1.00 13.21           O  
ATOM   1244  OE2 GLU A 149     -14.995  44.854  16.344  1.00 13.06           O  
ATOM   1245  N   PRO A 150      -7.975  45.329  17.171  1.00 12.73           N  
ATOM   1246  CA  PRO A 150      -6.743  45.361  17.946  1.00 12.71           C  
ATOM   1247  C   PRO A 150      -6.935  45.705  19.398  1.00 11.14           C  
ATOM   1248  O   PRO A 150      -7.784  46.511  19.737  1.00 13.40           O  
ATOM   1249  CB  PRO A 150      -5.879  46.411  17.231  1.00 14.43           C  
ATOM   1250  CG  PRO A 150      -6.809  47.204  16.413  1.00 16.47           C  
ATOM   1251  CD  PRO A 150      -7.971  46.315  16.060  1.00 14.38           C  
ATOM   1252  N   VAL A 151      -6.083  45.120  20.255  1.00 13.49           N  
ATOM   1253  CA  VAL A 151      -6.115  45.425  21.680  1.00 13.03           C  
ATOM   1254  C   VAL A 151      -5.413  46.762  21.934  1.00 13.49           C  
ATOM   1255  O   VAL A 151      -4.607  47.201  21.123  1.00 13.40           O  
ATOM   1256  CB  VAL A 151      -5.477  44.266  22.487  1.00 13.67           C  
ATOM   1257  CG1 VAL A 151      -6.277  42.966  22.312  1.00 16.20           C  
ATOM   1258  CG2 VAL A 151      -4.024  44.092  22.099  1.00 12.85           C  
ATOM   1259  N   PRO A 152      -5.736  47.417  23.048  1.00 14.78           N  
ATOM   1260  CA  PRO A 152      -5.258  48.778  23.248  1.00 15.19           C  
ATOM   1261  C   PRO A 152      -3.771  48.923  23.346  1.00 15.86           C  
ATOM   1262  O   PRO A 152      -3.257  49.971  22.994  1.00 20.84           O  
ATOM   1263  CB  PRO A 152      -5.889  49.192  24.564  1.00 15.77           C  
ATOM   1264  CG  PRO A 152      -7.026  48.293  24.764  1.00 18.43           C  
ATOM   1265  CD  PRO A 152      -6.710  47.020  24.073  1.00 15.19           C  
ATOM   1266  N   ASN A 153      -3.054  47.868  23.728  1.00 13.95           N  
ATOM   1267  CA  ASN A 153      -1.614  47.940  23.828  1.00 16.05           C  
ATOM   1268  C   ASN A 153      -0.892  47.523  22.540  1.00 17.07           C  
ATOM   1269  O   ASN A 153       0.327  47.484  22.509  1.00 17.29           O  
ATOM   1270  CB  ASN A 153      -1.092  47.125  24.988  1.00 16.08           C  
ATOM   1271  CG  ASN A 153      -1.516  45.670  24.954  1.00 18.46           C  
ATOM   1272  OD1 ASN A 153      -2.716  45.369  24.866  1.00 20.08           O  
ATOM   1273  ND2 ASN A 153      -0.569  44.766  25.106  1.00 21.23           N  
ATOM   1274  N   PHE A 154      -1.640  47.212  21.496  1.00 14.69           N  
ATOM   1275  CA  PHE A 154      -1.043  46.955  20.187  1.00 14.10           C  
ATOM   1276  C   PHE A 154      -0.737  48.225  19.436  1.00 14.30           C  
ATOM   1277  O   PHE A 154      -1.642  49.042  19.214  1.00 14.77           O  
ATOM   1278  CB  PHE A 154      -2.034  46.162  19.332  1.00 12.61           C  
ATOM   1279  CG  PHE A 154      -1.527  45.910  17.931  1.00 14.95           C  
ATOM   1280  CD1 PHE A 154      -0.490  44.992  17.696  1.00 13.20           C  
ATOM   1281  CD2 PHE A 154      -2.107  46.532  16.827  1.00 13.33           C  
ATOM   1282  CE1 PHE A 154      -0.023  44.766  16.416  1.00 14.23           C  
ATOM   1283  CE2 PHE A 154      -1.606  46.328  15.558  1.00 13.13           C  
ATOM   1284  CZ  PHE A 154      -0.597  45.429  15.345  1.00 13.56           C  
ATOM   1285  N   CYS A 155       0.530  48.370  18.984  1.00 14.22           N  
ATOM   1286  CA  CYS A 155       0.934  49.460  18.140  1.00 13.54           C  
ATOM   1287  C   CYS A 155       1.484  48.975  16.830  1.00 16.40           C  
ATOM   1288  O   CYS A 155       2.202  47.967  16.755  1.00 15.84           O  
ATOM   1289  CB  CYS A 155       2.097  50.179  18.758  1.00 16.50           C  
ATOM   1290  SG  CYS A 155       1.758  50.888  20.307  1.00 21.76           S  
ATOM   1291  N   LEU A 156       1.150  49.721  15.788  1.00 13.91           N  
ATOM   1292  CA  LEU A 156       1.838  49.670  14.487  1.00 16.23           C  
ATOM   1293  C   LEU A 156       2.918  50.775  14.546  1.00 15.15           C  
ATOM   1294  O   LEU A 156       2.683  51.905  14.904  1.00 17.84           O  
ATOM   1295  CB  LEU A 156       0.880  49.957  13.326  1.00 14.66           C  
ATOM   1296  CG  LEU A 156       1.535  50.135  11.941  1.00 15.39           C  
ATOM   1297  CD1 LEU A 156       2.291  48.901  11.464  1.00 16.45           C  
ATOM   1298  CD2 LEU A 156       0.432  50.513  10.913  1.00 17.48           C  
ATOM   1299  N   LEU A 157       4.127  50.389  14.234  1.00 14.78           N  
ATOM   1300  CA  LEU A 157       5.280  51.312  14.197  1.00 15.97           C  
ATOM   1301  C   LEU A 157       5.741  51.418  12.752  1.00 15.59           C  
ATOM   1302  O   LEU A 157       6.020  50.383  12.106  1.00 16.73           O  
ATOM   1303  CB  LEU A 157       6.348  50.793  15.137  1.00 16.46           C  
ATOM   1304  CG  LEU A 157       7.641  51.550  15.207  1.00 19.40           C  
ATOM   1305  CD1 LEU A 157       7.376  52.990  15.681  1.00 19.90           C  
ATOM   1306  CD2 LEU A 157       8.596  50.783  16.183  1.00 21.38           C  
ATOM   1307  N   LEU A 158       5.780  52.632  12.221  1.00 14.79           N  
ATOM   1308  CA  LEU A 158       6.283  52.896  10.860  1.00 15.96           C  
ATOM   1309  C   LEU A 158       7.598  53.638  10.929  1.00 16.26           C  
ATOM   1310  O   LEU A 158       7.709  54.595  11.709  1.00 16.87           O  
ATOM   1311  CB  LEU A 158       5.302  53.745  10.115  1.00 16.32           C  
ATOM   1312  CG  LEU A 158       3.921  53.148   9.943  1.00 14.97           C  
ATOM   1313  CD1 LEU A 158       2.987  54.236   9.290  1.00 18.88           C  
ATOM   1314  CD2 LEU A 158       3.875  51.828   9.152  1.00 16.51           C  
ATOM   1315  N   LEU A 159       8.538  53.272  10.067  1.00 15.27           N  
ATOM   1316  CA  LEU A 159       9.744  54.036   9.812  1.00 15.45           C  
ATOM   1317  C   LEU A 159       9.722  54.567   8.388  1.00 14.93           C  
ATOM   1318  O   LEU A 159       9.526  53.807   7.431  1.00 16.61           O  
ATOM   1319  CB  LEU A 159      10.976  53.153  10.021  1.00 14.98           C  
ATOM   1320  CG  LEU A 159      12.281  53.877   9.649  1.00 19.52           C  
ATOM   1321  CD1 LEU A 159      12.596  54.896  10.658  1.00 20.26           C  
ATOM   1322  CD2 LEU A 159      13.411  52.796   9.574  1.00 24.12           C  
ATOM   1323  N   ASP A 160       9.923  55.877   8.263  1.00 16.21           N  
ATOM   1324  CA  ASP A 160      10.025  56.557   6.958  1.00 16.54           C  
ATOM   1325  C   ASP A 160      11.470  56.971   6.714  1.00 16.70           C  
ATOM   1326  O   ASP A 160      11.893  58.010   7.240  1.00 17.12           O  
ATOM   1327  CB  ASP A 160       9.148  57.800   6.907  1.00 18.32           C  
ATOM   1328  CG  ASP A 160       9.045  58.382   5.473  1.00 20.93           C  
ATOM   1329  OD1 ASP A 160       9.161  57.618   4.468  1.00 30.29           O  
ATOM   1330  OD2 ASP A 160       8.716  59.577   5.387  1.00 35.80           O  
ATOM   1331  N   PRO A 161      12.233  56.148   5.968  1.00 17.31           N  
ATOM   1332  CA  PRO A 161      13.639  56.509   5.805  1.00 14.70           C  
ATOM   1333  C   PRO A 161      13.880  57.811   5.050  1.00 16.11           C  
ATOM   1334  O   PRO A 161      13.246  58.062   4.036  1.00 16.75           O  
ATOM   1335  CB  PRO A 161      14.208  55.342   5.002  1.00 16.27           C  
ATOM   1336  CG  PRO A 161      13.292  54.196   5.259  1.00 17.84           C  
ATOM   1337  CD  PRO A 161      11.939  54.861   5.300  1.00 18.23           C  
ATOM   1338  N   VAL A 162      14.784  58.611   5.594  1.00 14.35           N  
ATOM   1339  CA  VAL A 162      15.280  59.726   4.804  0.50 13.51           C  
ATOM   1341  C   VAL A 162      16.748  59.604   4.445  1.00 15.71           C  
ATOM   1342  O   VAL A 162      17.223  60.337   3.594  1.00 15.45           O  
ATOM   1343  CB  VAL A 162      14.978  61.086   5.455  0.50 12.94           C  
ATOM   1345  CG1 VAL A 162      13.503  61.241   5.688  0.50 17.08           C  
ATOM   1347  CG2 VAL A 162      15.766  61.260   6.739  0.50 20.10           C  
ATOM   1349  N   GLN A 163      17.453  58.633   5.018  1.00 14.36           N  
ATOM   1350  CA  GLN A 163      18.814  58.363   4.635  1.00 13.93           C  
ATOM   1351  C   GLN A 163      19.022  56.867   4.702  1.00 13.91           C  
ATOM   1352  O   GLN A 163      18.605  56.230   5.682  1.00 15.23           O  
ATOM   1353  CB  GLN A 163      19.842  59.062   5.534  1.00 17.34           C  
ATOM   1354  CG  GLN A 163      21.278  58.964   5.009  1.00 19.55           C  
ATOM   1355  CD  GLN A 163      22.234  60.012   5.536  1.00 26.51           C  
ATOM   1356  OE1 GLN A 163      23.270  59.682   6.106  1.00 31.74           O  
ATOM   1357  NE2 GLN A 163      21.914  61.272   5.308  1.00 26.41           N  
ATOM   1358  N   VAL A 164      19.649  56.297   3.667  1.00 13.60           N  
ATOM   1359  CA  VAL A 164      19.923  54.873   3.602  1.00 13.57           C  
ATOM   1360  C   VAL A 164      21.386  54.679   3.187  1.00 14.74           C  
ATOM   1361  O   VAL A 164      21.832  55.287   2.208  1.00 16.10           O  
ATOM   1362  CB  VAL A 164      18.978  54.174   2.624  1.00 13.83           C  
ATOM   1363  CG1 VAL A 164      19.350  52.675   2.444  1.00 14.89           C  
ATOM   1364  CG2 VAL A 164      17.535  54.335   3.102  1.00 15.28           C  
ATOM   1365  N   ASP A 165      22.127  53.849   3.903  1.00 14.37           N  
ATOM   1366  CA  ASP A 165      23.548  53.488   3.608  1.00 14.19           C  
ATOM   1367  C   ASP A 165      23.529  51.995   3.336  1.00 15.63           C  
ATOM   1368  O   ASP A 165      23.166  51.202   4.226  1.00 17.22           O  
ATOM   1369  CB  ASP A 165      24.345  53.846   4.866  1.00 15.31           C  
ATOM   1370  CG  ASP A 165      25.840  53.642   4.789  1.00 25.14           C  
ATOM   1371  OD1 ASP A 165      26.351  53.023   3.877  1.00 29.15           O  
ATOM   1372  OD2 ASP A 165      26.492  54.074   5.781  1.00 31.78           O  
ATOM   1373  N   HIS A 166      23.847  51.595   2.120  1.00 12.87           N  
ATOM   1374  CA  HIS A 166      23.888  50.196   1.707  1.00 12.64           C  
ATOM   1375  C   HIS A 166      25.315  49.748   1.461  1.00 12.80           C  
ATOM   1376  O   HIS A 166      25.979  50.288   0.578  1.00 13.49           O  
ATOM   1377  CB  HIS A 166      23.078  50.040   0.436  1.00 14.06           C  
ATOM   1378  CG  HIS A 166      23.009  48.643  -0.083  1.00 15.32           C  
ATOM   1379  ND1 HIS A 166      22.841  48.372  -1.431  1.00 16.71           N  
ATOM   1380  CD2 HIS A 166      23.041  47.444   0.553  1.00 14.81           C  
ATOM   1381  CE1 HIS A 166      22.793  47.061  -1.601  1.00 18.85           C  
ATOM   1382  NE2 HIS A 166      22.909  46.472  -0.413  1.00 16.39           N  
ATOM   1383  N   LEU A 167      25.775  48.768   2.220  1.00 13.52           N  
ATOM   1384  CA  LEU A 167      27.124  48.245   2.161  1.00 12.68           C  
ATOM   1385  C   LEU A 167      27.035  46.799   1.681  1.00 13.50           C  
ATOM   1386  O   LEU A 167      26.333  45.983   2.281  1.00 14.22           O  
ATOM   1387  CB  LEU A 167      27.758  48.289   3.543  1.00 13.78           C  
ATOM   1388  CG  LEU A 167      29.150  47.676   3.672  1.00 15.55           C  
ATOM   1389  CD1 LEU A 167      30.175  48.467   2.862  1.00 15.91           C  
ATOM   1390  CD2 LEU A 167      29.554  47.630   5.141  1.00 16.23           C  
ATOM   1391  N   GLU A 168      27.731  46.512   0.584  1.00 14.54           N  
ATOM   1392  CA  GLU A 168      27.868  45.169   0.015  1.00 13.99           C  
ATOM   1393  C   GLU A 168      29.281  44.683   0.295  1.00 15.94           C  
ATOM   1394  O   GLU A 168      30.240  45.234  -0.246  1.00 15.92           O  
ATOM   1395  CB  GLU A 168      27.619  45.217  -1.491  1.00 16.35           C  
ATOM   1396  CG  GLU A 168      26.185  45.454  -1.825  1.00 18.69           C  
ATOM   1397  CD  GLU A 168      25.909  45.508  -3.306  1.00 28.39           C  
ATOM   1398  OE1 GLU A 168      26.836  45.808  -4.082  1.00 32.52           O  
ATOM   1399  OE2 GLU A 168      24.744  45.250  -3.675  1.00 29.97           O  
ATOM   1400  N   LEU A 169      29.427  43.647   1.117  1.00 15.43           N  
ATOM   1401  CA  LEU A 169      30.754  43.131   1.385  1.00 15.89           C  
ATOM   1402  C   LEU A 169      31.277  42.312   0.227  1.00 18.49           C  
ATOM   1403  O   LEU A 169      32.498  42.100   0.159  1.00 18.52           O  
ATOM   1404  CB  LEU A 169      30.768  42.315   2.662  1.00 15.73           C  
ATOM   1405  CG  LEU A 169      30.376  43.085   3.919  1.00 16.49           C  
ATOM   1406  CD1 LEU A 169      30.397  42.133   5.136  1.00 20.87           C  
ATOM   1407  CD2 LEU A 169      31.269  44.294   4.162  1.00 18.62           C  
ATOM   1408  N   ARG A 170      30.412  41.810  -0.642  1.00 18.37           N  
ATOM   1409  CA  ARG A 170      30.836  41.063  -1.835  0.50 22.54           C  
ATOM   1411  C   ARG A 170      30.947  42.023  -3.006  1.00 23.25           C  
ATOM   1412  O   ARG A 170      30.109  41.993  -3.904  1.00 27.36           O  
ATOM   1413  CB  ARG A 170      29.821  39.973  -2.208  0.50 23.72           C  
ATOM   1415  CG  ARG A 170      29.727  38.815  -1.241  0.50 29.68           C  
ATOM   1417  CD  ARG A 170      28.281  38.480  -0.868  0.50 34.16           C  
ATOM   1419  NE  ARG A 170      27.533  37.617  -1.790  0.50 30.32           N  
ATOM   1421  CZ  ARG A 170      26.384  37.919  -2.395  0.50 28.03           C  
ATOM   1423  NH1 ARG A 170      25.802  39.098  -2.232  0.50 37.00           N  
ATOM   1425  NH2 ARG A 170      25.800  37.026  -3.189  0.50 32.21           N  
ATOM   1427  N   GLY A 171      31.962  42.872  -2.997  1.00 23.68           N  
ATOM   1428  CA  GLY A 171      32.167  43.876  -4.054  1.00 23.75           C  
ATOM   1429  C   GLY A 171      33.551  43.794  -4.654  1.00 23.48           C  
ATOM   1430  O   GLY A 171      34.156  42.729  -4.733  1.00 24.63           O  
ATOM   1431  N   GLU A 172      34.087  44.947  -5.051  1.00 25.82           N  
ATOM   1432  CA  GLU A 172      35.398  45.004  -5.676  1.00 28.91           C  
ATOM   1433  C   GLU A 172      36.261  46.108  -5.047  1.00 28.79           C  
ATOM   1434  O   GLU A 172      36.653  47.071  -5.722  1.00 31.27           O  
ATOM   1435  CB  GLU A 172      35.252  45.185  -7.201  1.00 33.05           C  
ATOM   1436  CG  GLU A 172      34.756  43.904  -7.913  1.00 34.19           C  
ATOM   1437  N   PRO A 173      36.604  45.954  -3.760  1.00 22.40           N  
ATOM   1438  CA  PRO A 173      36.348  44.804  -2.893  1.00 21.24           C  
ATOM   1439  C   PRO A 173      35.007  44.833  -2.127  1.00 20.28           C  
ATOM   1440  O   PRO A 173      34.487  43.766  -1.730  1.00 19.27           O  
ATOM   1441  CB  PRO A 173      37.521  44.867  -1.905  1.00 23.76           C  
ATOM   1442  CG  PRO A 173      37.889  46.301  -1.824  1.00 25.16           C  
ATOM   1443  CD  PRO A 173      37.444  46.978  -3.106  1.00 23.50           C  
ATOM   1444  N   GLN A 174      34.499  46.035  -1.896  1.00 19.09           N  
ATOM   1445  CA  GLN A 174      33.198  46.264  -1.268  1.00 16.74           C  
ATOM   1446  C   GLN A 174      32.572  47.432  -1.949  1.00 17.73           C  
ATOM   1447  O   GLN A 174      33.288  48.260  -2.529  1.00 19.70           O  
ATOM   1448  CB  GLN A 174      33.344  46.616   0.206  1.00 17.35           C  
ATOM   1449  CG  GLN A 174      34.080  45.570   1.013  1.00 17.73           C  
ATOM   1450  CD  GLN A 174      34.132  45.883   2.521  1.00 18.71           C  
ATOM   1451  OE1 GLN A 174      34.661  45.103   3.330  1.00 20.59           O  
ATOM   1452  NE2 GLN A 174      33.597  47.055   2.899  1.00 20.62           N  
ATOM   1453  N   ASN A 175      31.252  47.509  -1.936  1.00 18.17           N  
ATOM   1454  CA  ASN A 175      30.527  48.633  -2.530  1.00 18.24           C  
ATOM   1455  C   ASN A 175      29.698  49.287  -1.428  1.00 16.38           C  
ATOM   1456  O   ASN A 175      29.132  48.591  -0.587  1.00 17.04           O  
ATOM   1457  CB  ASN A 175      29.570  48.153  -3.636  1.00 18.12           C  
ATOM   1458  CG  ASN A 175      30.263  47.324  -4.711  1.00 28.90           C  
ATOM   1459  OD1 ASN A 175      31.334  47.667  -5.131  1.00 32.27           O  
ATOM   1460  ND2 ASN A 175      29.634  46.229  -5.147  1.00 28.91           N  
ATOM   1461  N   ARG A 176      29.650  50.607  -1.405  1.00 16.02           N  
ATOM   1462  CA  ARG A 176      28.845  51.340  -0.448  1.00 15.12           C  
ATOM   1463  C   ARG A 176      28.167  52.496  -1.154  1.00 16.20           C  
ATOM   1464  O   ARG A 176      28.817  53.238  -1.904  1.00 16.46           O  
ATOM   1465  CB  ARG A 176      29.751  51.841   0.658  1.00 15.81           C  
ATOM   1466  CG  ARG A 176      28.992  52.376   1.861  1.00 16.60           C  
ATOM   1467  CD  ARG A 176      29.915  52.750   2.942  1.00 18.00           C  
ATOM   1468  NE  ARG A 176      29.257  53.373   4.081  1.00 19.60           N  
ATOM   1469  CZ  ARG A 176      29.894  54.133   4.971  1.00 22.52           C  
ATOM   1470  NH1 ARG A 176      31.190  54.332   4.841  1.00 22.52           N  
ATOM   1471  NH2 ARG A 176      29.250  54.691   5.976  1.00 21.92           N  
ATOM   1472  N   TRP A 177      26.858  52.613  -0.957  1.00 16.70           N  
ATOM   1473  CA  TRP A 177      26.036  53.640  -1.557  1.00 16.22           C  
ATOM   1474  C   TRP A 177      25.245  54.341  -0.488  1.00 16.80           C  
ATOM   1475  O   TRP A 177      24.695  53.688   0.398  1.00 16.09           O  
ATOM   1476  CB  TRP A 177      25.072  53.035  -2.573  1.00 18.84           C  
ATOM   1477  CG  TRP A 177      25.687  52.723  -3.843  1.00 24.48           C  
ATOM   1478  CD1 TRP A 177      26.334  51.574  -4.188  1.00 28.21           C  
ATOM   1479  CD2 TRP A 177      25.725  53.567  -4.999  1.00 24.71           C  
ATOM   1480  NE1 TRP A 177      26.800  51.670  -5.484  1.00 31.48           N  
ATOM   1481  CE2 TRP A 177      26.429  52.877  -5.999  1.00 27.00           C  
ATOM   1482  CE3 TRP A 177      25.227  54.842  -5.283  1.00 29.59           C  
ATOM   1483  CZ2 TRP A 177      26.643  53.424  -7.280  1.00 30.80           C  
ATOM   1484  CZ3 TRP A 177      25.444  55.387  -6.547  1.00 32.90           C  
ATOM   1485  CH2 TRP A 177      26.148  54.678  -7.524  1.00 28.96           C  
ATOM   1486  N   LEU A 178      25.171  55.664  -0.580  1.00 15.00           N  
ATOM   1487  CA  LEU A 178      24.398  56.490   0.301  1.00 14.47           C  
ATOM   1488  C   LEU A 178      23.262  57.103  -0.484  1.00 16.28           C  
ATOM   1489  O   LEU A 178      23.462  57.648  -1.564  1.00 16.48           O  
ATOM   1490  CB  LEU A 178      25.276  57.597   0.874  1.00 16.25           C  
ATOM   1491  CG  LEU A 178      24.765  58.497   1.963  1.00 22.41           C  
ATOM   1492  CD1 LEU A 178      24.373  57.722   3.252  1.00 26.96           C  
ATOM   1493  CD2 LEU A 178      25.888  59.557   2.218  1.00 25.46           C  
ATOM   1494  N   TYR A 179      22.077  57.052   0.089  1.00 14.95           N  
ATOM   1495  CA  TYR A 179      20.877  57.634  -0.497  1.00 14.83           C  
ATOM   1496  C   TYR A 179      20.347  58.654   0.495  1.00 14.59           C  
ATOM   1497  O   TYR A 179      20.267  58.386   1.693  1.00 15.06           O  
ATOM   1498  CB  TYR A 179      19.824  56.542  -0.701  1.00 13.91           C  
ATOM   1499  CG  TYR A 179      20.183  55.387  -1.588  1.00 13.75           C  
ATOM   1500  CD1 TYR A 179      20.890  54.310  -1.100  1.00 16.32           C  
ATOM   1501  CD2 TYR A 179      19.787  55.396  -2.937  1.00 16.53           C  
ATOM   1502  CE1 TYR A 179      21.208  53.263  -1.896  1.00 17.22           C  
ATOM   1503  CE2 TYR A 179      20.087  54.333  -3.751  1.00 22.68           C  
ATOM   1504  CZ  TYR A 179      20.795  53.262  -3.222  1.00 21.57           C  
ATOM   1505  OH  TYR A 179      21.140  52.196  -4.048  1.00 23.22           O  
ATOM   1506  N   HIS A 180      19.931  59.822   0.015  1.00 14.19           N  
ATOM   1507  CA  HIS A 180      19.372  60.860   0.881  1.00 14.74           C  
ATOM   1508  C   HIS A 180      18.124  61.492   0.252  1.00 16.40           C  
ATOM   1509  O   HIS A 180      18.099  61.730  -0.933  1.00 17.93           O  
ATOM   1510  CB  HIS A 180      20.440  61.908   1.179  1.00 20.64           C  
ATOM   1511  CG  HIS A 180      19.968  63.005   2.076  1.00 25.98           C  
ATOM   1512  ND1 HIS A 180      19.853  62.862   3.442  1.00 38.14           N  
ATOM   1513  CD2 HIS A 180      19.530  64.253   1.785  1.00 29.78           C  
ATOM   1514  CE1 HIS A 180      19.364  63.981   3.953  1.00 36.68           C  
ATOM   1515  NE2 HIS A 180      19.174  64.844   2.970  1.00 32.90           N  
ATOM   1516  N   ARG A 181      17.117  61.751   1.072  1.00 15.63           N  
ATOM   1517  CA  ARG A 181      15.877  62.385   0.643  1.00 17.43           C  
ATOM   1518  C   ARG A 181      15.893  63.841   1.102  1.00 20.05           C  
ATOM   1519  O   ARG A 181      16.152  64.108   2.279  1.00 20.18           O  
ATOM   1520  CB  ARG A 181      14.671  61.674   1.253  1.00 17.47           C  
ATOM   1521  CG  ARG A 181      13.403  62.046   0.544  1.00 20.70           C  
ATOM   1522  CD  ARG A 181      12.243  61.376   1.078  1.00 19.06           C  
ATOM   1523  NE  ARG A 181      11.889  61.880   2.403  1.00 21.23           N  
ATOM   1524  CZ  ARG A 181      10.997  61.280   3.183  1.00 30.41           C  
ATOM   1525  NH1 ARG A 181      10.432  60.156   2.771  1.00 29.17           N  
ATOM   1526  NH2 ARG A 181      10.697  61.787   4.366  1.00 33.80           N  
ATOM   1527  N   ASN A 182      15.660  64.767   0.171  1.00 23.13           N  
ATOM   1528  CA  ASN A 182      15.698  66.185   0.528  1.00 24.77           C  
ATOM   1529  C   ASN A 182      14.327  66.665   0.990  1.00 28.59           C  
ATOM   1530  O   ASN A 182      13.383  65.869   1.144  1.00 24.60           O  
ATOM   1531  CB  ASN A 182      16.293  67.016  -0.631  1.00 27.50           C  
ATOM   1532  CG  ASN A 182      15.410  67.074  -1.875  1.00 28.66           C  
ATOM   1533  OD1 ASN A 182      14.241  66.744  -1.855  1.00 22.70           O  
ATOM   1534  ND2 ASN A 182      16.013  67.502  -2.986  1.00 31.00           N  
ATOM   1535  N   ASP A 183      14.228  67.973   1.236  1.00 30.90           N  
ATOM   1536  CA  ASP A 183      12.980  68.587   1.691  1.00 35.13           C  
ATOM   1537  C   ASP A 183      11.828  68.520   0.684  1.00 34.36           C  
ATOM   1538  O   ASP A 183      10.655  68.614   1.078  1.00 36.50           O  
ATOM   1539  CB  ASP A 183      13.229  70.056   2.045  1.00 38.87           C  
ATOM   1540  CG  ASP A 183      13.620  70.884   0.839  1.00 45.78           C  
ATOM   1541  OD1 ASP A 183      14.638  70.544   0.192  1.00 51.82           O  
ATOM   1542  OD2 ASP A 183      12.915  71.878   0.539  1.00 60.39           O  
ATOM   1543  N   GLN A 184      12.157  68.370  -0.601  1.00 32.92           N  
ATOM   1544  CA  GLN A 184      11.154  68.164  -1.674  1.00 33.05           C  
ATOM   1545  C   GLN A 184      10.780  66.709  -1.922  1.00 32.33           C  
ATOM   1546  O   GLN A 184      10.086  66.399  -2.900  1.00 29.79           O  
ATOM   1547  CB  GLN A 184      11.659  68.751  -3.003  1.00 35.10           C  
ATOM   1548  CG  GLN A 184      11.651  70.272  -3.072  1.00 41.82           C  
ATOM   1549  CD  GLN A 184      12.862  70.914  -2.442  1.00 50.13           C  
ATOM   1550  OE1 GLN A 184      13.944  70.322  -2.380  1.00 56.20           O  
ATOM   1551  NE2 GLN A 184      12.695  72.152  -1.982  1.00 58.70           N  
ATOM   1552  N   GLN A 185      11.258  65.808  -1.054  1.00 29.20           N  
ATOM   1553  CA  GLN A 185      10.960  64.375  -1.140  1.00 26.97           C  
ATOM   1554  C   GLN A 185      11.663  63.675  -2.317  1.00 24.25           C  
ATOM   1555  O   GLN A 185      11.308  62.564  -2.697  1.00 27.23           O  
ATOM   1556  CB  GLN A 185       9.470  64.098  -1.115  1.00 29.97           C  
ATOM   1557  CG  GLN A 185       8.795  64.562   0.185  1.00 33.22           C  
ATOM   1558  CD  GLN A 185       9.217  63.745   1.405  1.00 38.74           C  
ATOM   1559  N   GLU A 186      12.695  64.321  -2.838  1.00 24.41           N  
ATOM   1560  CA  GLU A 186      13.458  63.789  -3.944  1.00 22.21           C  
ATOM   1561  C   GLU A 186      14.682  63.045  -3.383  1.00 21.41           C  
ATOM   1562  O   GLU A 186      15.376  63.561  -2.501  1.00 20.13           O  
ATOM   1563  CB  GLU A 186      13.916  64.894  -4.864  1.00 24.70           C  
ATOM   1564  CG  GLU A 186      12.743  65.696  -5.424  1.00 31.85           C  
ATOM   1565  CD  GLU A 186      13.167  66.993  -6.075  1.00 41.75           C  
ATOM   1566  OE1 GLU A 186      14.243  67.536  -5.729  1.00 44.54           O  
ATOM   1567  OE2 GLU A 186      12.401  67.489  -6.926  1.00 57.91           O  
ATOM   1568  N   TRP A 187      14.935  61.853  -3.927  1.00 19.54           N  
ATOM   1569  CA  TRP A 187      16.102  61.056  -3.528  1.00 19.21           C  
ATOM   1570  C   TRP A 187      17.312  61.321  -4.411  1.00 21.09           C  
ATOM   1571  O   TRP A 187      17.192  61.515  -5.630  1.00 25.52           O  
ATOM   1572  CB  TRP A 187      15.764  59.565  -3.565  1.00 17.27           C  
ATOM   1573  CG  TRP A 187      14.891  59.127  -2.477  1.00 17.18           C  
ATOM   1574  CD1 TRP A 187      13.509  59.046  -2.493  1.00 17.10           C  
ATOM   1575  CD2 TRP A 187      15.293  58.708  -1.163  1.00 15.46           C  
ATOM   1576  NE1 TRP A 187      13.062  58.610  -1.271  1.00 18.19           N  
ATOM   1577  CE2 TRP A 187      14.136  58.394  -0.442  1.00 15.76           C  
ATOM   1578  CE3 TRP A 187      16.541  58.567  -0.533  1.00 16.74           C  
ATOM   1579  CZ2 TRP A 187      14.185  57.953   0.876  1.00 15.54           C  
ATOM   1580  CZ3 TRP A 187      16.592  58.134   0.777  1.00 14.35           C  
ATOM   1581  CH2 TRP A 187      15.428  57.835   1.466  1.00 13.78           C  
ATOM   1582  N   SER A 188      18.484  61.356  -3.777  1.00 17.96           N  
ATOM   1583  CA  SER A 188      19.772  61.383  -4.475  1.00 20.30           C  
ATOM   1584  C   SER A 188      20.581  60.199  -3.986  1.00 18.30           C  
ATOM   1585  O   SER A 188      20.285  59.627  -2.930  1.00 17.61           O  
ATOM   1586  CB  SER A 188      20.502  62.690  -4.182  1.00 24.35           C  
ATOM   1587  OG  SER A 188      20.797  62.826  -2.814  1.00 34.36           O  
ATOM   1588  N   SER A 189      21.520  59.747  -4.805  1.00 17.36           N  
ATOM   1589  CA  SER A 189      22.427  58.688  -4.386  1.00 17.56           C  
ATOM   1590  C   SER A 189      23.852  58.927  -4.802  1.00 18.47           C  
ATOM   1591  O   SER A 189      24.111  59.664  -5.752  1.00 19.02           O  
ATOM   1592  CB  SER A 189      21.966  57.359  -4.900  1.00 21.43           C  
ATOM   1593  OG  SER A 189      22.069  57.276  -6.277  1.00 26.83           O  
ATOM   1594  N   GLU A 190      24.782  58.317  -4.080  1.00 17.48           N  
ATOM   1595  CA  GLU A 190      26.189  58.463  -4.389  1.00 20.27           C  
ATOM   1596  C   GLU A 190      26.987  57.284  -3.879  1.00 18.94           C  
ATOM   1597  O   GLU A 190      26.739  56.781  -2.780  1.00 17.41           O  
ATOM   1598  CB  GLU A 190      26.790  59.747  -3.833  1.00 23.48           C  
ATOM   1599  CG  GLU A 190      26.816  59.936  -2.346  1.00 33.17           C  
ATOM   1600  CD  GLU A 190      27.817  61.018  -1.906  1.00 33.15           C  
ATOM   1601  OE1 GLU A 190      28.717  61.373  -2.696  1.00 45.13           O  
ATOM   1602  OE2 GLU A 190      27.692  61.502  -0.753  1.00 48.08           O  
ATOM   1603  N   ALA A 191      27.907  56.822  -4.692  1.00 18.25           N  
ATOM   1604  CA  ALA A 191      28.834  55.790  -4.279  1.00 16.75           C  
ATOM   1605  C   ALA A 191      29.897  56.449  -3.387  1.00 17.31           C  
ATOM   1606  O   ALA A 191      30.509  57.491  -3.739  1.00 17.98           O  
ATOM   1607  CB  ALA A 191      29.472  55.126  -5.508  1.00 18.33           C  
ATOM   1608  N   ILE A 192      30.168  55.795  -2.246  1.00 15.04           N  
ATOM   1609  CA  ILE A 192      31.115  56.316  -1.256  1.00 16.32           C  
ATOM   1610  C   ILE A 192      32.107  55.238  -0.865  1.00 17.05           C  
ATOM   1611  O   ILE A 192      31.917  54.044  -1.129  1.00 16.09           O  
ATOM   1612  CB  ILE A 192      30.420  56.880  -0.005  1.00 16.34           C  
ATOM   1613  CG1 ILE A 192      29.463  55.857   0.640  1.00 17.68           C  
ATOM   1614  CG2 ILE A 192      29.593  58.150  -0.375  1.00 17.33           C  
ATOM   1615  CD1 ILE A 192      28.990  56.165   2.072  1.00 18.37           C  
ATOM   1616  N   ASN A 193      33.222  55.653  -0.275  1.00 16.06           N  
ATOM   1617  CA  ASN A 193      34.212  54.676   0.138  1.00 16.47           C  
ATOM   1618  C   ASN A 193      33.703  53.827   1.305  1.00 17.13           C  
ATOM   1619  O   ASN A 193      33.229  54.394   2.293  1.00 18.93           O  
ATOM   1620  CB  ASN A 193      35.518  55.357   0.557  1.00 16.04           C  
ATOM   1621  CG  ASN A 193      36.231  56.016  -0.608  1.00 20.14           C  
ATOM   1622  OD1 ASN A 193      36.176  55.525  -1.765  1.00 18.68           O  
ATOM   1623  ND2 ASN A 193      36.973  57.094  -0.307  1.00 18.17           N  
ATOM   1624  N   PRO A 194      33.882  52.496   1.223  1.00 18.30           N  
ATOM   1625  CA  PRO A 194      33.496  51.639   2.344  1.00 22.93           C  
ATOM   1626  C   PRO A 194      34.038  52.095   3.700  1.00 31.79           C  
ATOM   1627  O   PRO A 194      35.189  52.511   3.795  1.00 32.36           O  
ATOM   1628  CB  PRO A 194      34.052  50.288   1.969  1.00 24.68           C  
ATOM   1629  CG  PRO A 194      34.371  50.331   0.535  1.00 28.18           C  
ATOM   1630  CD  PRO A 194      34.390  51.741   0.068  1.00 20.20           C  
ATOM   1631  OXT PRO A 194      33.309  52.106   4.728  1.00 34.86           O  
TER    1632      PRO A 194                                                      
END
MOLECULE T0506.pdb
ATOM      1  N   VAL     4      16.223  74.529   6.413  1.00 43.65           N  
ATOM      2  CA  VAL     4      17.370  74.880   7.304  1.00 43.82           C  
ATOM      3  C   VAL     4      17.963  73.638   8.008  1.00 43.97           C  
ATOM      4  O   VAL     4      19.114  73.665   8.459  1.00 44.37           O  
ATOM      5  CB  VAL     4      16.969  76.004   8.316  1.00 43.84           C  
ATOM      6  CG1 VAL     4      18.109  76.346   9.267  1.00 44.06           C  
ATOM      7  CG2 VAL     4      16.529  77.270   7.571  1.00 43.89           C  
ATOM      8  N   ALA     5      17.192  72.548   8.063  1.00 43.79           N  
ATOM      9  CA  ALA     5      17.573  71.332   8.805  1.00 43.55           C  
ATOM     10  C   ALA     5      18.661  70.477   8.131  1.00 43.26           C  
ATOM     11  O   ALA     5      18.524  70.078   6.973  1.00 42.98           O  
ATOM     12  CB  ALA     5      16.339  70.479   9.111  1.00 43.90           C  
ATOM     13  N   PRO     6      19.740  70.170   8.871  1.00 43.22           N  
ATOM     14  CA  PRO     6      20.844  69.368   8.331  1.00 42.95           C  
ATOM     15  C   PRO     6      20.447  67.919   7.950  1.00 42.45           C  
ATOM     16  O   PRO     6      19.464  67.374   8.487  1.00 41.77           O  
ATOM     17  CB  PRO     6      21.854  69.359   9.484  1.00 43.23           C  
ATOM     18  CG  PRO     6      21.006  69.553  10.707  1.00 43.87           C  
ATOM     19  CD  PRO     6      19.985  70.552  10.274  1.00 43.24           C  
ATOM     20  N   PRO     7      21.198  67.301   7.015  1.00 41.83           N  
ATOM     21  CA  PRO     7      20.961  65.893   6.726  1.00 41.46           C  
ATOM     22  C   PRO     7      20.933  65.068   8.016  1.00 40.74           C  
ATOM     23  O   PRO     7      21.728  65.315   8.930  1.00 40.20           O  
ATOM     24  CB  PRO     7      22.164  65.498   5.854  1.00 42.16           C  
ATOM     25  CG  PRO     7      23.099  66.664   5.880  1.00 41.75           C  
ATOM     26  CD  PRO     7      22.276  67.858   6.180  1.00 41.68           C  
ATOM     27  N   VAL     8      19.999  64.129   8.112  1.00 40.33           N  
ATOM     28  CA  VAL     8      19.881  63.318   9.347  1.00 39.91           C  
ATOM     29  C   VAL     8      21.138  62.431   9.570  1.00 40.27           C  
ATOM     30  O   VAL     8      21.506  62.089  10.707  1.00 40.37           O  
ATOM     31  CB  VAL     8      18.516  62.556   9.435  1.00 39.67           C  
ATOM     32  CG1 VAL     8      17.329  63.555   9.348  1.00 36.98           C  
ATOM     33  CG2 VAL     8      18.390  61.517   8.365  1.00 38.22           C  
ATOM     34  N   ILE     9      21.801  62.086   8.475  1.00 40.55           N  
ATOM     35  CA  ILE     9      23.080  61.402   8.548  1.00 40.74           C  
ATOM     36  C   ILE     9      24.104  62.396   8.056  1.00 40.78           C  
ATOM     37  O   ILE     9      24.011  62.841   6.917  1.00 41.63           O  
ATOM     38  CB  ILE     9      23.118  60.143   7.647  1.00 40.61           C  
ATOM     39  CG1 ILE     9      21.953  59.189   7.985  1.00 41.00           C  
ATOM     40  CG2 ILE     9      24.517  59.462   7.731  1.00 39.79           C  
ATOM     41  CD1 ILE     9      21.690  58.061   6.971  1.00 40.63           C  
ATOM     42  N   THR    10      25.056  62.771   8.909  1.00 40.43           N  
ATOM     43  CA  THR    10      26.176  63.599   8.483  1.00 40.73           C  
ATOM     44  C   THR    10      27.078  62.807   7.534  1.00 40.81           C  
ATOM     45  O   THR    10      27.550  61.725   7.907  1.00 41.55           O  
ATOM     46  CB  THR    10      26.948  64.128   9.696  1.00 40.40           C  
ATOM     47  OG1 THR    10      26.031  64.861  10.516  1.00 39.93           O  
ATOM     48  CG2 THR    10      28.134  65.030   9.289  1.00 40.89           C  
ATOM     49  N   PRO    11      27.264  63.306   6.290  1.00 40.27           N  
ATOM     50  CA  PRO    11      28.106  62.635   5.300  1.00 40.30           C  
ATOM     51  C   PRO    11      29.531  62.424   5.796  1.00 40.59           C  
ATOM     52  O   PRO    11      30.089  63.270   6.519  1.00 40.09           O  
ATOM     53  CB  PRO    11      28.124  63.627   4.123  1.00 39.98           C  
ATOM     54  CG  PRO    11      26.898  64.368   4.249  1.00 39.70           C  
ATOM     55  CD  PRO    11      26.687  64.541   5.731  1.00 40.75           C  
ATOM     56  N   ARG    12      30.113  61.303   5.387  1.00 41.07           N  
ATOM     57  CA  ARG    12      31.472  60.953   5.767  1.00 41.14           C  
ATOM     58  C   ARG    12      32.453  61.993   5.258  1.00 41.53           C  
ATOM     59  O   ARG    12      33.228  62.542   6.035  1.00 41.73           O  
ATOM     60  CB  ARG    12      31.835  59.577   5.213  1.00 41.12           C  
ATOM     61  CG  ARG    12      32.473  58.648   6.214  1.00 39.82           C  
ATOM     62  CD  ARG    12      33.423  59.386   7.103  1.00 37.35           C  
ATOM     63  NE  ARG    12      34.538  58.566   7.537  1.00 35.24           N  
ATOM     64  CZ  ARG    12      35.491  59.009   8.340  1.00 36.29           C  
ATOM     65  NH1 ARG    12      35.452  60.263   8.767  1.00 35.93           N  
ATOM     66  NH2 ARG    12      36.488  58.210   8.710  1.00 36.57           N  
ATOM     67  N   PHE    24      26.609  45.777  -8.751  1.00 49.65           N  
ATOM     68  CA  PHE    24      26.051  46.396  -7.541  1.00 49.63           C  
ATOM     69  C   PHE    24      25.420  47.733  -7.925  1.00 48.93           C  
ATOM     70  O   PHE    24      26.123  48.667  -8.335  1.00 49.03           O  
ATOM     71  CB  PHE    24      27.132  46.601  -6.452  1.00 49.78           C  
ATOM     72  CG  PHE    24      26.616  47.272  -5.196  1.00 50.83           C  
ATOM     73  CD1 PHE    24      26.081  46.515  -4.146  1.00 50.02           C  
ATOM     74  CD2 PHE    24      26.659  48.674  -5.061  1.00 51.88           C  
ATOM     75  CE1 PHE    24      25.585  47.152  -2.977  1.00 50.73           C  
ATOM     76  CE2 PHE    24      26.163  49.313  -3.901  1.00 50.87           C  
ATOM     77  CZ  PHE    24      25.627  48.551  -2.863  1.00 49.25           C  
ATOM     78  N   GLU    25      24.099  47.813  -7.832  1.00 47.53           N  
ATOM     79  CA  GLU    25      23.428  49.088  -8.068  1.00 46.43           C  
ATOM     80  C   GLU    25      22.710  49.488  -6.817  1.00 44.86           C  
ATOM     81  O   GLU    25      21.685  48.901  -6.451  1.00 45.13           O  
ATOM     82  CB  GLU    25      22.471  49.047  -9.256  1.00 47.06           C  
ATOM     83  CG  GLU    25      22.225  50.443  -9.881  1.00 47.24           C  
ATOM     84  CD  GLU    25      21.172  51.248  -9.119  1.00 46.10           C  
ATOM     85  OE1 GLU    25      21.561  52.100  -8.295  1.00 45.74           O  
ATOM     86  OE2 GLU    25      19.958  51.022  -9.342  1.00 44.94           O  
ATOM     87  N   ALA    26      23.264  50.509  -6.181  1.00 43.10           N  
ATOM     88  CA  ALA    26      22.889  50.896  -4.846  1.00 42.10           C  
ATOM     89  C   ALA    26      21.383  50.862  -4.620  1.00 41.22           C  
ATOM     90  O   ALA    26      20.938  50.241  -3.667  1.00 41.52           O  
ATOM     91  CB  ALA    26      23.459  52.259  -4.514  1.00 42.27           C  
ATOM     92  N   VAL    27      20.618  51.503  -5.507  1.00 39.82           N  
ATOM     93  CA  VAL    27      19.170  51.685  -5.330  1.00 38.62           C  
ATOM     94  C   VAL    27      18.441  50.333  -5.389  1.00 38.25           C  
ATOM     95  O   VAL    27      17.627  50.011  -4.527  1.00 38.38           O  
ATOM     96  CB  VAL    27      18.586  52.704  -6.353  1.00 37.58           C  
ATOM     97  CG1 VAL    27      17.069  52.638  -6.404  1.00 37.20           C  
ATOM     98  CG2 VAL    27      19.050  54.113  -6.001  1.00 37.77           C  
ATOM     99  N   ARG    28      18.794  49.533  -6.374  1.00 38.45           N  
ATOM    100  CA  ARG    28      18.189  48.223  -6.565  1.00 39.15           C  
ATOM    101  C   ARG    28      18.541  47.242  -5.432  1.00 38.81           C  
ATOM    102  O   ARG    28      17.647  46.634  -4.831  1.00 39.72           O  
ATOM    103  CB  ARG    28      18.559  47.687  -7.963  1.00 38.85           C  
ATOM    104  CG  ARG    28      18.278  46.216  -8.142  1.00 41.94           C  
ATOM    105  CD  ARG    28      16.816  45.790  -7.837  1.00 45.21           C  
ATOM    106  NE  ARG    28      16.439  44.831  -8.874  1.00 51.01           N  
ATOM    107  CZ  ARG    28      16.676  43.525  -8.835  1.00 49.95           C  
ATOM    108  NH1 ARG    28      17.225  42.961  -7.766  1.00 50.06           N  
ATOM    109  NH2 ARG    28      16.313  42.783  -9.854  1.00 49.70           N  
ATOM    110  N   VAL    29      19.822  47.129  -5.087  1.00 38.22           N  
ATOM    111  CA  VAL    29      20.219  46.316  -3.927  1.00 37.36           C  
ATOM    112  C   VAL    29      19.496  46.775  -2.649  1.00 36.79           C  
ATOM    113  O   VAL    29      19.018  45.955  -1.848  1.00 36.89           O  
ATOM    114  CB  VAL    29      21.772  46.348  -3.708  1.00 37.56           C  
ATOM    115  CG1 VAL    29      22.144  45.746  -2.370  1.00 37.50           C  
ATOM    116  CG2 VAL    29      22.494  45.612  -4.819  1.00 37.85           C  
ATOM    117  N   ALA    30      19.421  48.097  -2.454  1.00 35.35           N  
ATOM    118  CA  ALA    30      18.687  48.682  -1.336  1.00 34.46           C  
ATOM    119  C   ALA    30      17.203  48.317  -1.292  1.00 33.63           C  
ATOM    120  O   ALA    30      16.700  47.953  -0.243  1.00 33.01           O  
ATOM    121  CB  ALA    30      18.851  50.228  -1.333  1.00 33.58           C  
ATOM    122  N   ARG    31      16.515  48.424  -2.422  1.00 32.99           N  
ATOM    123  CA  ARG    31      15.084  48.146  -2.496  1.00 34.07           C  
ATOM    124  C   ARG    31      14.826  46.663  -2.284  1.00 33.95           C  
ATOM    125  O   ARG    31      13.803  46.281  -1.725  1.00 35.51           O  
ATOM    126  CB  ARG    31      14.481  48.670  -3.812  1.00 33.27           C  
ATOM    127  CG  ARG    31      14.226  50.179  -3.744  1.00 34.01           C  
ATOM    128  CD  ARG    31      13.577  50.726  -5.019  1.00 35.99           C  
ATOM    129  NE  ARG    31      12.143  50.433  -5.017  1.00 33.98           N  
ATOM    130  CZ  ARG    31      11.416  50.411  -6.115  1.00 38.90           C  
ATOM    131  NH1 ARG    31      12.005  50.704  -7.262  1.00 31.97           N  
ATOM    132  NH2 ARG    31      10.110  50.128  -6.060  1.00 42.34           N  
ATOM    133  N   ASP    32      15.778  45.838  -2.686  1.00 34.58           N  
ATOM    134  CA  ASP    32      15.679  44.398  -2.466  0.50 35.02           C  
ATOM    136  C   ASP    32      15.826  44.056  -1.006  1.00 34.99           C  
ATOM    137  O   ASP    32      15.045  43.274  -0.480  1.00 35.71           O  
ATOM    138  CB  ASP    32      16.723  43.631  -3.275  0.50 34.91           C  
ATOM    140  CG  ASP    32      16.252  42.240  -3.643  0.50 37.60           C  
ATOM    142  OD1 ASP    32      15.113  42.109  -4.168  0.50 37.96           O  
ATOM    144  OD2 ASP    32      17.027  41.278  -3.431  0.50 39.94           O  
ATOM    146  N   VAL    33      16.799  44.665  -0.335  1.00 35.69           N  
ATOM    147  CA  VAL    33      16.952  44.479   1.129  1.00 35.38           C  
ATOM    148  C   VAL    33      15.725  44.991   1.852  1.00 36.91           C  
ATOM    149  O   VAL    33      15.266  44.403   2.861  1.00 37.01           O  
ATOM    150  CB  VAL    33      18.200  45.234   1.681  1.00 35.08           C  
ATOM    151  CG1 VAL    33      18.291  45.100   3.203  1.00 35.22           C  
ATOM    152  CG2 VAL    33      19.474  44.688   1.037  1.00 33.53           C  
ATOM    153  N   LEU    34      15.223  46.132   1.383  1.00 36.92           N  
ATOM    154  CA  LEU    34      14.044  46.713   1.963  1.00 37.55           C  
ATOM    155  C   LEU    34      12.872  45.725   1.973  1.00 37.09           C  
ATOM    156  O   LEU    34      12.183  45.569   3.011  1.00 37.29           O  
ATOM    157  CB  LEU    34      13.635  47.981   1.239  1.00 37.10           C  
ATOM    158  CG  LEU    34      12.325  48.656   1.652  1.00 36.56           C  
ATOM    159  CD1 LEU    34      12.382  49.294   3.019  1.00 35.33           C  
ATOM    160  CD2 LEU    34      12.021  49.705   0.548  1.00 33.63           C  
ATOM    161  N   HIS    35      12.674  45.055   0.852  1.00 36.94           N  
ATOM    162  CA  HIS    35      11.488  44.235   0.692  1.00 37.17           C  
ATOM    163  C   HIS    35      11.613  42.812   1.221  1.00 37.43           C  
ATOM    164  O   HIS    35      10.598  42.106   1.372  1.00 36.36           O  
ATOM    165  CB  HIS    35      11.031  44.238  -0.765  1.00 36.90           C  
ATOM    166  CG  HIS    35      10.298  45.502  -1.165  1.00 37.86           C  
ATOM    167  ND1 HIS    35       8.920  45.593  -1.165  1.00 38.07           N  
ATOM    168  CD2 HIS    35      10.751  46.717  -1.569  1.00 36.41           C  
ATOM    169  CE1 HIS    35       8.553  46.819  -1.526  1.00 36.43           C  
ATOM    170  NE2 HIS    35       9.647  47.517  -1.784  1.00 36.29           N  
ATOM    171  N   THR    36      12.843  42.372   1.438  1.00 36.97           N  
ATOM    172  CA  THR    36      13.079  40.969   1.718  1.00 37.62           C  
ATOM    173  C   THR    36      13.741  40.752   3.075  1.00 38.16           C  
ATOM    174  O   THR    36      14.194  39.635   3.373  1.00 38.65           O  
ATOM    175  CB  THR    36      13.897  40.253   0.588  1.00 39.04           C  
ATOM    176  OG1 THR    36      15.189  40.884   0.435  1.00 37.71           O  
ATOM    177  CG2 THR    36      13.146  40.274  -0.759  1.00 37.27           C  
ATOM    178  N   SER    37      13.811  41.788   3.890  1.00 37.79           N  
ATOM    179  CA  SER    37      14.363  41.613   5.263  1.00 39.48           C  
ATOM    180  C   SER    37      13.260  41.475   6.314  1.00 38.86           C  
ATOM    181  O   SER    37      12.412  42.358   6.422  1.00 38.51           O  
ATOM    182  CB  SER    37      15.345  42.762   5.618  1.00 38.38           C  
ATOM    183  OG  SER    37      16.371  42.838   4.608  1.00 41.05           O  
ATOM    184  N   ARG    38      13.268  40.369   7.076  1.00 39.77           N  
ATOM    185  CA  ARG    38      12.327  40.179   8.211  1.00 41.34           C  
ATOM    186  C   ARG    38      12.758  40.914   9.477  1.00 42.43           C  
ATOM    187  O   ARG    38      11.968  41.608  10.100  1.00 42.17           O  
ATOM    188  CB  ARG    38      12.100  38.691   8.578  1.00 41.21           C  
ATOM    189  CG  ARG    38      10.919  38.002   7.837  1.00 42.35           C  
ATOM    190  CD  ARG    38      10.623  36.515   8.413  1.00 44.16           C  
ATOM    191  NE  ARG    38       9.250  36.088   8.125  1.00 48.27           N  
ATOM    192  CZ  ARG    38       8.909  35.290   7.123  1.00 48.91           C  
ATOM    193  NH1 ARG    38       7.635  34.955   6.942  1.00 48.62           N  
ATOM    194  NH2 ARG    38       9.846  34.775   6.322  1.00 51.54           N  
ATOM    195  N   THR    39      14.015  40.742   9.867  1.00 43.04           N  
ATOM    196  CA  THR    39      14.487  41.282  11.126  1.00 43.56           C  
ATOM    197  C   THR    39      15.269  42.567  10.903  1.00 43.75           C  
ATOM    198  O   THR    39      16.001  42.696   9.921  1.00 43.67           O  
ATOM    199  CB  THR    39      15.318  40.257  11.910  1.00 43.91           C  
ATOM    200  OG1 THR    39      14.552  39.053  12.056  1.00 45.50           O  
ATOM    201  CG2 THR    39      15.640  40.777  13.315  1.00 44.70           C  
ATOM    202  N   ALA    40      15.033  43.524  11.799  1.00 41.52           N  
ATOM    203  CA  ALA    40      15.651  44.828  11.787  1.00 40.98           C  
ATOM    204  C   ALA    40      16.237  45.164  13.169  1.00 40.63           C  
ATOM    205  O   ALA    40      15.643  44.853  14.180  1.00 40.12           O  
ATOM    206  CB  ALA    40      14.604  45.873  11.432  1.00 41.19           C  
ATOM    207  N   ALA    41      17.418  45.765  13.177  1.00 39.80           N  
ATOM    208  CA  ALA    41      17.920  46.465  14.324  1.00 38.78           C  
ATOM    209  C   ALA    41      17.158  47.790  14.407  1.00 39.25           C  
ATOM    210  O   ALA    41      16.861  48.426  13.397  1.00 38.98           O  
ATOM    211  CB  ALA    41      19.416  46.708  14.140  1.00 39.12           C  
ATOM    212  N   LEU    42      16.797  48.193  15.623  1.00 38.68           N  
ATOM    213  CA  LEU    42      16.037  49.406  15.853  1.00 39.79           C  
ATOM    214  C   LEU    42      16.785  50.125  16.957  1.00 39.98           C  
ATOM    215  O   LEU    42      17.011  49.536  18.044  1.00 38.61           O  
ATOM    216  CB  LEU    42      14.655  49.049  16.433  1.00 40.02           C  
ATOM    217  CG  LEU    42      13.458  50.015  16.368  1.00 43.63           C  
ATOM    218  CD1 LEU    42      12.539  49.898  17.612  1.00 42.40           C  
ATOM    219  CD2 LEU    42      13.771  51.474  16.022  1.00 39.93           C  
ATOM    220  N   ALA    43      17.123  51.378  16.688  1.00 38.14           N  
ATOM    221  CA  ALA    43      17.741  52.250  17.656  1.00 38.67           C  
ATOM    222  C   ALA    43      16.827  53.423  17.999  1.00 39.37           C  
ATOM    223  O   ALA    43      16.177  54.035  17.134  1.00 40.23           O  
ATOM    224  CB  ALA    43      19.111  52.747  17.153  1.00 38.06           C  
ATOM    225  N   THR    44      16.877  53.783  19.273  1.00 39.46           N  
ATOM    226  CA  THR    44      15.964  54.691  19.898  1.00 38.96           C  
ATOM    227  C   THR    44      16.884  55.530  20.822  1.00 38.63           C  
ATOM    228  O   THR    44      18.054  55.168  21.043  1.00 38.06           O  
ATOM    229  CB  THR    44      14.985  53.702  20.568  1.00 40.23           C  
ATOM    230  OG1 THR    44      13.679  53.682  19.961  1.00 45.89           O  
ATOM    231  CG2 THR    44      15.079  53.504  22.014  1.00 33.78           C  
ATOM    232  N   LEU    45      16.389  56.659  21.328  1.00 38.88           N  
ATOM    233  CA  LEU    45      17.207  57.508  22.210  1.00 38.18           C  
ATOM    234  C   LEU    45      16.689  57.522  23.642  1.00 38.60           C  
ATOM    235  O   LEU    45      15.488  57.696  23.887  1.00 39.08           O  
ATOM    236  CB  LEU    45      17.306  58.953  21.676  1.00 38.20           C  
ATOM    237  CG  LEU    45      17.965  59.257  20.311  1.00 38.94           C  
ATOM    238  CD1 LEU    45      17.732  60.739  19.933  1.00 35.37           C  
ATOM    239  CD2 LEU    45      19.475  58.944  20.302  1.00 34.51           C  
ATOM    240  N   ASP    46      17.602  57.365  24.594  1.00 38.81           N  
ATOM    241  CA  ASP    46      17.234  57.458  25.978  1.00 38.11           C  
ATOM    242  C   ASP    46      16.965  58.919  26.355  1.00 38.82           C  
ATOM    243  O   ASP    46      17.782  59.804  26.077  1.00 39.17           O  
ATOM    244  CB  ASP    46      18.269  56.823  26.873  1.00 37.52           C  
ATOM    245  CG  ASP    46      17.782  56.687  28.297  1.00 38.27           C  
ATOM    246  OD1 ASP    46      17.801  57.702  29.037  1.00 39.29           O  
ATOM    247  OD2 ASP    46      17.353  55.572  28.670  1.00 39.12           O  
ATOM    248  N   PRO    47      15.793  59.181  26.968  1.00 39.51           N  
ATOM    249  CA  PRO    47      15.406  60.562  27.316  1.00 39.59           C  
ATOM    250  C   PRO    47      16.261  61.296  28.350  1.00 39.85           C  
ATOM    251  O   PRO    47      16.218  62.528  28.393  1.00 41.11           O  
ATOM    252  CB  PRO    47      13.972  60.421  27.810  1.00 39.48           C  
ATOM    253  CG  PRO    47      13.786  59.014  28.136  1.00 39.84           C  
ATOM    254  CD  PRO    47      14.738  58.210  27.302  1.00 39.29           C  
ATOM    255  N   VAL    48      16.978  60.575  29.215  1.00 39.58           N  
ATOM    256  CA  VAL    48      17.764  61.207  30.288  1.00 38.34           C  
ATOM    257  C   VAL    48      19.253  61.154  29.955  1.00 37.75           C  
ATOM    258  O   VAL    48      19.960  62.160  30.031  1.00 36.21           O  
ATOM    259  CB  VAL    48      17.522  60.535  31.703  1.00 38.53           C  
ATOM    260  CG1 VAL    48      18.371  61.189  32.800  1.00 38.22           C  
ATOM    261  CG2 VAL    48      16.045  60.571  32.106  1.00 38.99           C  
ATOM    262  N   SER    49      19.719  59.969  29.570  1.00 37.22           N  
ATOM    263  CA  SER    49      21.152  59.725  29.436  1.00 37.08           C  
ATOM    264  C   SER    49      21.684  60.192  28.093  1.00 37.18           C  
ATOM    265  O   SER    49      22.841  60.545  27.976  1.00 37.79           O  
ATOM    266  CB  SER    49      21.474  58.250  29.669  1.00 37.19           C  
ATOM    267  OG  SER    49      20.872  57.441  28.663  1.00 35.06           O  
ATOM    268  N   GLY    50      20.835  60.174  27.079  1.00 38.39           N  
ATOM    269  CA  GLY    50      21.214  60.622  25.742  1.00 38.15           C  
ATOM    270  C   GLY    50      21.913  59.521  24.969  1.00 36.98           C  
ATOM    271  O   GLY    50      22.166  59.670  23.775  1.00 37.41           O  
ATOM    272  N   TYR    51      22.211  58.412  25.651  1.00 35.98           N  
ATOM    273  CA  TYR    51      22.733  57.203  25.004  1.00 34.74           C  
ATOM    274  C   TYR    51      21.698  56.630  24.013  1.00 34.55           C  
ATOM    275  O   TYR    51      20.453  56.775  24.230  1.00 35.08           O  
ATOM    276  CB  TYR    51      23.047  56.109  26.039  1.00 33.87           C  
ATOM    277  CG  TYR    51      24.321  56.276  26.852  1.00 33.36           C  
ATOM    278  CD1 TYR    51      25.393  55.409  26.676  1.00 32.99           C  
ATOM    279  CD2 TYR    51      24.442  57.298  27.780  1.00 33.00           C  
ATOM    280  CE1 TYR    51      26.558  55.551  27.429  1.00 34.11           C  
ATOM    281  CE2 TYR    51      25.600  57.456  28.550  1.00 35.12           C  
ATOM    282  CZ  TYR    51      26.653  56.575  28.352  1.00 34.84           C  
ATOM    283  OH  TYR    51      27.786  56.715  29.074  1.00 32.74           O  
ATOM    284  N   PRO    52      22.191  55.951  22.950  1.00 34.99           N  
ATOM    285  CA  PRO    52      21.241  55.231  22.109  1.00 34.67           C  
ATOM    286  C   PRO    52      20.776  53.982  22.843  1.00 35.35           C  
ATOM    287  O   PRO    52      21.419  53.563  23.835  1.00 34.36           O  
ATOM    288  CB  PRO    52      22.052  54.874  20.842  1.00 35.16           C  
ATOM    289  CG  PRO    52      23.495  54.940  21.259  1.00 34.77           C  
ATOM    290  CD  PRO    52      23.602  55.799  22.497  1.00 34.82           C  
ATOM    291  N   TYR    53      19.673  53.403  22.378  1.00 35.86           N  
ATOM    292  CA  TYR    53      19.173  52.180  22.965  1.00 36.96           C  
ATOM    293  C   TYR    53      18.667  51.328  21.811  1.00 36.80           C  
ATOM    294  O   TYR    53      17.880  51.791  21.003  1.00 37.91           O  
ATOM    295  CB  TYR    53      18.040  52.462  24.003  1.00 36.72           C  
ATOM    296  CG  TYR    53      17.422  51.187  24.528  1.00 38.05           C  
ATOM    297  CD1 TYR    53      17.975  50.523  25.627  1.00 38.59           C  
ATOM    298  CD2 TYR    53      16.305  50.606  23.893  1.00 37.83           C  
ATOM    299  CE1 TYR    53      17.424  49.341  26.105  1.00 39.91           C  
ATOM    300  CE2 TYR    53      15.747  49.416  24.370  1.00 39.19           C  
ATOM    301  CZ  TYR    53      16.310  48.792  25.458  1.00 38.48           C  
ATOM    302  OH  TYR    53      15.774  47.610  25.907  1.00 40.55           O  
ATOM    303  N   THR    54      19.131  50.080  21.734  1.00 37.35           N  
ATOM    304  CA  THR    54      18.820  49.210  20.616  1.00 36.80           C  
ATOM    305  C   THR    54      17.924  48.044  20.993  1.00 37.74           C  
ATOM    306  O   THR    54      17.930  47.569  22.152  1.00 37.88           O  
ATOM    307  CB  THR    54      20.095  48.663  19.947  1.00 37.33           C  
ATOM    308  OG1 THR    54      20.944  48.083  20.945  1.00 36.66           O  
ATOM    309  CG2 THR    54      20.831  49.750  19.249  1.00 37.47           C  
ATOM    310  N   THR    55      17.168  47.563  20.005  1.00 37.99           N  
ATOM    311  CA  THR    55      16.482  46.258  20.101  1.00 38.74           C  
ATOM    312  C   THR    55      16.468  45.581  18.733  1.00 38.58           C  
ATOM    313  O   THR    55      16.991  46.145  17.767  1.00 38.75           O  
ATOM    314  CB  THR    55      15.031  46.362  20.760  1.00 39.15           C  
ATOM    315  OG1 THR    55      14.547  45.043  21.053  1.00 42.34           O  
ATOM    316  CG2 THR    55      14.021  47.094  19.861  1.00 37.54           C  
ATOM    317  N   ALA    56      15.919  44.370  18.666  1.00 37.63           N  
ATOM    318  CA  ALA    56      15.601  43.697  17.415  1.00 38.20           C  
ATOM    319  C   ALA    56      14.083  43.590  17.259  1.00 38.64           C  
ATOM    320  O   ALA    56      13.374  43.290  18.226  1.00 38.50           O  
ATOM    321  CB  ALA    56      16.243  42.301  17.344  1.00 37.34           C  
ATOM    322  N   THR    57      13.593  43.808  16.043  1.00 38.00           N  
ATOM    323  CA  THR    57      12.144  43.750  15.804  1.00 39.69           C  
ATOM    324  C   THR    57      11.844  43.200  14.405  1.00 40.17           C  
ATOM    325  O   THR    57      12.767  43.030  13.611  1.00 39.47           O  
ATOM    326  CB  THR    57      11.479  45.144  16.054  1.00 39.51           C  
ATOM    327  OG1 THR    57      10.075  44.982  16.284  1.00 42.44           O  
ATOM    328  CG2 THR    57      11.769  46.175  14.922  1.00 37.64           C  
ATOM    329  N   ASN    58      10.569  42.905  14.141  1.00 39.45           N  
ATOM    330  CA  ASN    58      10.140  42.384  12.852  1.00 40.47           C  
ATOM    331  C   ASN    58       9.653  43.550  11.984  1.00 39.86           C  
ATOM    332  O   ASN    58       8.995  44.471  12.473  1.00 39.32           O  
ATOM    333  CB  ASN    58       8.964  41.419  13.043  1.00 39.87           C  
ATOM    334  CG  ASN    58       9.261  40.264  13.997  1.00 42.71           C  
ATOM    335  OD1 ASN    58      10.325  39.625  13.945  1.00 43.20           O  
ATOM    336  ND2 ASN    58       8.253  39.910  14.811  1.00 41.63           N  
ATOM    337  N   ILE    59       9.872  43.453  10.689  1.00 40.97           N  
ATOM    338  CA  ILE    59       9.529  44.518   9.723  1.00 41.64           C  
ATOM    339  C   ILE    59       8.358  44.133   8.821  1.00 42.78           C  
ATOM    340  O   ILE    59       8.394  43.067   8.117  1.00 41.24           O  
ATOM    341  CB  ILE    59      10.792  44.815   8.837  1.00 41.35           C  
ATOM    342  CG1 ILE    59      11.835  45.573   9.675  1.00 42.44           C  
ATOM    343  CG2 ILE    59      10.454  45.666   7.603  1.00 44.65           C  
ATOM    344  CD1 ILE    59      11.346  46.945  10.221  1.00 39.10           C  
ATOM    345  N   GLY    60       7.314  44.975   8.847  1.00 43.54           N  
ATOM    346  CA  GLY    60       6.265  44.917   7.809  1.00 43.52           C  
ATOM    347  C   GLY    60       6.563  45.946   6.702  1.00 43.16           C  
ATOM    348  O   GLY    60       7.319  46.877   6.917  1.00 41.80           O  
ATOM    349  N   ILE    61       6.013  45.756   5.504  1.00 42.96           N  
ATOM    350  CA  ILE    61       6.196  46.748   4.436  1.00 44.08           C  
ATOM    351  C   ILE    61       4.826  47.088   3.847  1.00 43.86           C  
ATOM    352  O   ILE    61       4.039  46.184   3.546  1.00 45.44           O  
ATOM    353  CB  ILE    61       7.164  46.288   3.289  1.00 45.00           C  
ATOM    354  CG1 ILE    61       8.525  45.853   3.795  1.00 47.28           C  
ATOM    355  CG2 ILE    61       7.534  47.453   2.427  1.00 44.58           C  
ATOM    356  CD1 ILE    61       9.499  47.050   4.107  1.00 51.63           C  
ATOM    357  N   GLU    62       4.548  48.376   3.660  1.00 41.87           N  
ATOM    358  CA  GLU    62       3.316  48.797   3.016  1.00 41.07           C  
ATOM    359  C   GLU    62       3.499  48.862   1.468  1.00 41.15           C  
ATOM    360  O   GLU    62       4.639  48.887   0.990  1.00 41.34           O  
ATOM    361  CB  GLU    62       2.863  50.132   3.623  1.00 39.56           C  
ATOM    362  CG  GLU    62       2.863  50.081   5.181  1.00 39.44           C  
ATOM    363  CD  GLU    62       2.347  51.371   5.819  1.00 42.98           C  
ATOM    364  OE1 GLU    62       1.600  51.268   6.823  1.00 43.58           O  
ATOM    365  OE2 GLU    62       2.685  52.470   5.299  1.00 39.51           O  
ATOM    366  N   PRO    63       2.390  48.847   0.695  1.00 40.53           N  
ATOM    367  CA  PRO    63       2.460  48.832  -0.787  1.00 40.41           C  
ATOM    368  C   PRO    63       3.454  49.832  -1.394  1.00 39.89           C  
ATOM    369  O   PRO    63       4.140  49.476  -2.317  1.00 40.56           O  
ATOM    370  CB  PRO    63       1.033  49.157  -1.198  1.00 39.57           C  
ATOM    371  CG  PRO    63       0.213  48.552  -0.087  1.00 40.59           C  
ATOM    372  CD  PRO    63       0.995  48.773   1.160  1.00 40.41           C  
ATOM    373  N   ASP    64       3.560  51.048  -0.853  1.00 40.36           N  
ATOM    374  CA  ASP    64       4.530  52.054  -1.340  1.00 40.96           C  
ATOM    375  C   ASP    64       5.987  51.837  -0.852  1.00 41.65           C  
ATOM    376  O   ASP    64       6.844  52.696  -1.079  1.00 43.12           O  
ATOM    377  CB  ASP    64       4.066  53.493  -1.017  1.00 39.69           C  
ATOM    378  CG  ASP    64       4.138  53.809   0.465  1.00 40.09           C  
ATOM    379  OD1 ASP    64       3.820  54.926   0.865  1.00 40.33           O  
ATOM    380  OD2 ASP    64       4.498  52.913   1.241  1.00 36.40           O  
ATOM    381  N   GLY    65       6.228  50.735  -0.150  1.00 42.72           N  
ATOM    382  CA  GLY    65       7.554  50.370   0.345  1.00 44.04           C  
ATOM    383  C   GLY    65       7.891  50.838   1.747  1.00 44.29           C  
ATOM    384  O   GLY    65       8.999  50.566   2.222  1.00 45.96           O  
ATOM    385  N   THR    66       6.937  51.499   2.422  1.00 42.92           N  
ATOM    386  CA  THR    66       7.145  52.061   3.760  1.00 40.94           C  
ATOM    387  C   THR    66       7.233  50.965   4.834  1.00 40.64           C  
ATOM    388  O   THR    66       6.277  50.188   4.993  1.00 39.14           O  
ATOM    389  CB  THR    66       6.021  53.044   4.171  1.00 40.87           C  
ATOM    390  OG1 THR    66       5.955  54.140   3.252  1.00 40.45           O  
ATOM    391  CG2 THR    66       6.306  53.607   5.551  1.00 39.21           C  
ATOM    392  N   PRO    67       8.368  50.910   5.573  1.00 40.41           N  
ATOM    393  CA  PRO    67       8.465  49.942   6.647  1.00 41.38           C  
ATOM    394  C   PRO    67       7.598  50.307   7.843  1.00 41.41           C  
ATOM    395  O   PRO    67       7.431  51.490   8.173  1.00 40.86           O  
ATOM    396  CB  PRO    67       9.946  49.979   7.045  1.00 41.94           C  
ATOM    397  CG  PRO    67      10.638  50.775   6.040  1.00 41.43           C  
ATOM    398  CD  PRO    67       9.595  51.719   5.491  1.00 40.36           C  
ATOM    399  N   PHE    68       7.052  49.277   8.506  1.00 40.81           N  
ATOM    400  CA  PHE    68       6.285  49.530   9.723  1.00 39.59           C  
ATOM    401  C   PHE    68       6.606  48.413  10.691  1.00 39.37           C  
ATOM    402  O   PHE    68       7.122  47.356  10.315  1.00 38.92           O  
ATOM    403  CB  PHE    68       4.757  49.696   9.440  1.00 38.61           C  
ATOM    404  CG  PHE    68       4.008  48.388   9.182  1.00 38.40           C  
ATOM    405  CD1 PHE    68       3.373  47.706  10.228  1.00 39.53           C  
ATOM    406  CD2 PHE    68       3.910  47.857   7.890  1.00 37.81           C  
ATOM    407  CE1 PHE    68       2.642  46.505   9.975  1.00 40.30           C  
ATOM    408  CE2 PHE    68       3.216  46.680   7.637  1.00 39.43           C  
ATOM    409  CZ  PHE    68       2.582  45.996   8.692  1.00 40.88           C  
ATOM    410  N   PHE    69       6.294  48.640  11.947  1.00 39.54           N  
ATOM    411  CA  PHE    69       6.642  47.671  12.957  1.00 39.34           C  
ATOM    412  C   PHE    69       5.764  47.887  14.204  1.00 38.68           C  
ATOM    413  O   PHE    69       5.059  48.905  14.332  1.00 38.42           O  
ATOM    414  CB  PHE    69       8.148  47.734  13.285  1.00 39.39           C  
ATOM    415  CG  PHE    69       8.605  49.071  13.808  1.00 40.13           C  
ATOM    416  CD1 PHE    69       8.609  49.334  15.181  1.00 37.66           C  
ATOM    417  CD2 PHE    69       9.055  50.060  12.934  1.00 40.27           C  
ATOM    418  CE1 PHE    69       9.039  50.590  15.678  1.00 40.43           C  
ATOM    419  CE2 PHE    69       9.487  51.301  13.407  1.00 39.29           C  
ATOM    420  CZ  PHE    69       9.483  51.566  14.796  1.00 42.12           C  
ATOM    421  N   PHE    70       5.835  46.889  15.076  1.00 38.05           N  
ATOM    422  CA  PHE    70       5.076  46.866  16.296  0.50 38.37           C  
ATOM    424  C   PHE    70       6.038  46.859  17.464  1.00 38.87           C  
ATOM    425  O   PHE    70       7.149  46.304  17.360  1.00 38.01           O  
ATOM    426  CB  PHE    70       4.186  45.615  16.328  0.50 38.34           C  
ATOM    428  CG  PHE    70       4.063  44.995  17.679  0.50 37.72           C  
ATOM    430  CD1 PHE    70       3.134  45.471  18.599  0.50 36.50           C  
ATOM    432  CD2 PHE    70       4.879  43.917  18.036  0.50 38.31           C  
ATOM    434  CE1 PHE    70       3.023  44.878  19.863  0.50 37.53           C  
ATOM    436  CE2 PHE    70       4.773  43.321  19.307  0.50 36.98           C  
ATOM    438  CZ  PHE    70       3.851  43.807  20.216  0.50 36.69           C  
ATOM    440  N   ALA    71       5.596  47.458  18.571  1.00 38.29           N  
ATOM    441  CA  ALA    71       6.344  47.406  19.823  1.00 38.96           C  
ATOM    442  C   ALA    71       5.331  47.251  20.949  1.00 39.61           C  
ATOM    443  O   ALA    71       4.312  47.936  20.937  1.00 40.47           O  
ATOM    444  CB  ALA    71       7.151  48.660  20.043  1.00 38.39           C  
ATOM    445  N   ALA    72       5.592  46.345  21.892  1.00 39.98           N  
ATOM    446  CA  ALA    72       4.775  46.269  23.119  1.00 41.01           C  
ATOM    447  C   ALA    72       4.906  47.607  23.852  1.00 41.50           C  
ATOM    448  O   ALA    72       6.005  48.142  23.924  1.00 42.57           O  
ATOM    449  CB  ALA    72       5.262  45.138  23.991  1.00 40.44           C  
ATOM    450  N   GLY    73       3.808  48.150  24.386  1.00 41.80           N  
ATOM    451  CA  GLY    73       3.846  49.469  25.049  1.00 41.25           C  
ATOM    452  C   GLY    73       4.707  49.578  26.305  1.00 41.94           C  
ATOM    453  O   GLY    73       5.268  50.647  26.616  1.00 41.43           O  
ATOM    454  N   LEU    74       4.819  48.486  27.054  1.00 41.99           N  
ATOM    455  CA  LEU    74       5.571  48.544  28.315  1.00 43.68           C  
ATOM    456  C   LEU    74       7.093  48.305  28.146  1.00 43.63           C  
ATOM    457  O   LEU    74       7.759  47.837  29.053  1.00 44.67           O  
ATOM    458  CB  LEU    74       4.930  47.605  29.352  1.00 44.01           C  
ATOM    459  CG  LEU    74       3.413  47.749  29.578  1.00 46.05           C  
ATOM    460  CD1 LEU    74       2.965  46.988  30.851  1.00 49.35           C  
ATOM    461  CD2 LEU    74       2.939  49.230  29.653  1.00 48.89           C  
ATOM    462  N   THR    75       7.626  48.623  26.970  1.00 43.11           N  
ATOM    463  CA  THR    75       9.046  48.418  26.701  1.00 42.65           C  
ATOM    464  C   THR    75       9.824  49.744  26.683  1.00 42.24           C  
ATOM    465  O   THR    75       9.263  50.835  26.438  1.00 41.76           O  
ATOM    466  CB  THR    75       9.306  47.632  25.409  1.00 42.39           C  
ATOM    467  OG1 THR    75       8.924  48.421  24.270  1.00 44.12           O  
ATOM    468  CG2 THR    75       8.570  46.277  25.420  1.00 41.79           C  
ATOM    469  N   LEU    76      11.114  49.633  26.971  1.00 40.77           N  
ATOM    470  CA  LEU    76      12.015  50.766  26.924  1.00 41.14           C  
ATOM    471  C   LEU    76      12.007  51.489  25.574  1.00 40.66           C  
ATOM    472  O   LEU    76      11.944  52.711  25.542  1.00 39.81           O  
ATOM    473  CB  LEU    76      13.425  50.295  27.255  1.00 41.59           C  
ATOM    474  CG  LEU    76      14.009  50.414  28.673  1.00 43.88           C  
ATOM    475  CD1 LEU    76      13.137  51.171  29.678  1.00 45.72           C  
ATOM    476  CD2 LEU    76      14.462  49.068  29.235  1.00 45.24           C  
ATOM    477  N   HIS    77      12.082  50.753  24.458  1.00 39.75           N  
ATOM    478  CA  HIS    77      12.104  51.447  23.167  1.00 39.95           C  
ATOM    479  C   HIS    77      10.777  52.175  22.905  1.00 39.38           C  
ATOM    480  O   HIS    77      10.792  53.307  22.464  1.00 40.18           O  
ATOM    481  CB  HIS    77      12.509  50.543  21.992  1.00 39.44           C  
ATOM    482  CG  HIS    77      11.775  49.241  21.944  1.00 39.43           C  
ATOM    483  ND1 HIS    77      11.884  48.284  22.934  1.00 40.59           N  
ATOM    484  CD2 HIS    77      10.954  48.718  21.004  1.00 41.59           C  
ATOM    485  CE1 HIS    77      11.144  47.235  22.614  1.00 38.83           C  
ATOM    486  NE2 HIS    77      10.565  47.473  21.448  1.00 39.75           N  
ATOM    487  N   ALA    78       9.640  51.531  23.189  1.00 39.56           N  
ATOM    488  CA  ALA    78       8.326  52.206  23.113  1.00 38.93           C  
ATOM    489  C   ALA    78       8.338  53.516  23.887  1.00 38.55           C  
ATOM    490  O   ALA    78       7.962  54.567  23.330  1.00 39.14           O  
ATOM    491  CB  ALA    78       7.207  51.312  23.617  1.00 38.80           C  
ATOM    492  N   ARG    79       8.770  53.448  25.163  1.00 37.66           N  
ATOM    493  CA  ARG    79       8.928  54.611  26.013  1.00 37.31           C  
ATOM    494  C   ARG    79       9.798  55.654  25.329  1.00 37.34           C  
ATOM    495  O   ARG    79       9.412  56.836  25.268  1.00 36.32           O  
ATOM    496  CB  ARG    79       9.554  54.227  27.373  1.00 36.74           C  
ATOM    497  CG  ARG    79       9.456  55.287  28.537  1.00 37.11           C  
ATOM    498  CD  ARG    79      10.594  56.342  28.549  1.00 38.08           C  
ATOM    499  NE  ARG    79      11.916  55.725  28.313  1.00 40.43           N  
ATOM    500  CZ  ARG    79      12.646  55.127  29.241  1.00 38.21           C  
ATOM    501  NH1 ARG    79      12.214  55.069  30.506  1.00 37.01           N  
ATOM    502  NH2 ARG    79      13.817  54.592  28.914  1.00 38.84           N  
ATOM    503  N   ASN    80      10.978  55.233  24.861  1.00 37.06           N  
ATOM    504  CA  ASN    80      11.944  56.179  24.276  1.00 38.46           C  
ATOM    505  C   ASN    80      11.301  56.927  23.122  1.00 39.46           C  
ATOM    506  O   ASN    80      11.364  58.170  23.060  1.00 39.42           O  
ATOM    507  CB  ASN    80      13.239  55.484  23.823  1.00 38.83           C  
ATOM    508  CG  ASN    80      14.083  54.995  24.983  1.00 37.97           C  
ATOM    509  OD1 ASN    80      13.876  55.410  26.113  1.00 38.02           O  
ATOM    510  ND2 ASN    80      15.026  54.079  24.712  1.00 33.92           N  
ATOM    511  N   MET    81      10.639  56.167  22.250  1.00 40.14           N  
ATOM    512  CA  MET    81       9.919  56.713  21.108  1.00 42.73           C  
ATOM    513  C   MET    81       8.765  57.675  21.467  1.00 43.11           C  
ATOM    514  O   MET    81       8.520  58.618  20.730  1.00 42.53           O  
ATOM    515  CB  MET    81       9.432  55.580  20.198  1.00 42.61           C  
ATOM    516  CG  MET    81      10.568  54.902  19.431  1.00 43.80           C  
ATOM    517  SD  MET    81       9.974  53.560  18.134  0.90 48.49          SE  
ATOM    518  CE  MET    81       9.395  52.112  19.373  1.00 41.87           C  
ATOM    519  N   GLU    82       8.087  57.458  22.601  1.00 44.27           N  
ATOM    520  CA  GLU    82       7.135  58.466  23.137  1.00 45.85           C  
ATOM    521  C   GLU    82       7.860  59.782  23.394  1.00 45.91           C  
ATOM    522  O   GLU    82       7.403  60.843  22.989  1.00 46.79           O  
ATOM    523  CB  GLU    82       6.489  58.039  24.470  1.00 45.53           C  
ATOM    524  CG  GLU    82       5.217  57.205  24.406  1.00 48.85           C  
ATOM    525  CD  GLU    82       4.247  57.594  23.266  1.00 54.63           C  
ATOM    526  OE1 GLU    82       3.253  58.314  23.531  1.00 55.24           O  
ATOM    527  OE2 GLU    82       4.470  57.147  22.101  1.00 57.39           O  
ATOM    528  N   THR    83       8.992  59.693  24.080  1.00 46.45           N  
ATOM    529  CA  THR    83       9.771  60.867  24.475  1.00 45.76           C  
ATOM    530  C   THR    83      10.447  61.603  23.288  1.00 45.32           C  
ATOM    531  O   THR    83      10.521  62.828  23.305  1.00 45.43           O  
ATOM    532  CB  THR    83      10.795  60.516  25.590  1.00 46.00           C  
ATOM    533  OG1 THR    83      11.720  59.527  25.129  1.00 46.47           O  
ATOM    534  CG2 THR    83      10.084  59.971  26.841  1.00 46.29           C  
ATOM    535  N   ASP    84      10.895  60.857  22.263  1.00 43.62           N  
ATOM    536  CA  ASP    84      11.665  61.391  21.128  1.00 41.98           C  
ATOM    537  C   ASP    84      11.534  60.402  19.962  1.00 41.59           C  
ATOM    538  O   ASP    84      11.974  59.236  20.064  1.00 40.45           O  
ATOM    539  CB  ASP    84      13.139  61.539  21.541  1.00 42.13           C  
ATOM    540  CG  ASP    84      14.009  62.236  20.488  1.00 42.54           C  
ATOM    541  OD1 ASP    84      13.770  62.126  19.266  1.00 43.26           O  
ATOM    542  OD2 ASP    84      14.984  62.892  20.912  1.00 44.27           O  
ATOM    543  N   ALA    85      10.941  60.861  18.856  1.00 39.53           N  
ATOM    544  CA  ALA    85      10.596  59.949  17.752  1.00 38.78           C  
ATOM    545  C   ALA    85      11.753  59.634  16.791  1.00 38.06           C  
ATOM    546  O   ALA    85      11.574  58.840  15.886  1.00 38.40           O  
ATOM    547  CB  ALA    85       9.356  60.477  16.964  1.00 38.66           C  
ATOM    548  N   ARG    86      12.921  60.255  16.968  1.00 37.49           N  
ATOM    549  CA  ARG    86      14.075  59.998  16.101  1.00 37.80           C  
ATOM    550  C   ARG    86      14.598  58.573  16.313  1.00 37.79           C  
ATOM    551  O   ARG    86      14.936  58.172  17.447  1.00 38.77           O  
ATOM    552  CB  ARG    86      15.191  61.015  16.337  1.00 37.29           C  
ATOM    553  CG  ARG    86      14.782  62.423  15.962  1.00 37.81           C  
ATOM    554  CD  ARG    86      15.909  63.377  16.220  1.00 40.31           C  
ATOM    555  NE  ARG    86      16.150  63.542  17.639  1.00 40.47           N  
ATOM    556  CZ  ARG    86      17.144  64.262  18.153  1.00 42.65           C  
ATOM    557  NH1 ARG    86      17.257  64.358  19.461  1.00 40.10           N  
ATOM    558  NH2 ARG    86      18.022  64.881  17.368  1.00 43.73           N  
ATOM    559  N   ILE    87      14.606  57.800  15.230  1.00 38.06           N  
ATOM    560  CA  ILE    87      15.018  56.378  15.256  1.00 36.98           C  
ATOM    561  C   ILE    87      15.927  56.047  14.083  1.00 38.03           C  
ATOM    562  O   ILE    87      16.014  56.818  13.113  1.00 37.74           O  
ATOM    563  CB  ILE    87      13.797  55.385  15.235  1.00 36.88           C  
ATOM    564  CG1 ILE    87      12.957  55.462  13.944  1.00 36.90           C  
ATOM    565  CG2 ILE    87      12.886  55.630  16.470  1.00 36.77           C  
ATOM    566  CD1 ILE    87      12.027  54.186  13.735  1.00 34.81           C  
ATOM    567  N   SER    88      16.604  54.893  14.173  1.00 38.43           N  
ATOM    568  CA  SER    88      17.331  54.328  13.048  1.00 37.90           C  
ATOM    569  C   SER    88      17.026  52.830  12.974  1.00 38.40           C  
ATOM    570  O   SER    88      16.896  52.180  14.008  1.00 38.37           O  
ATOM    571  CB  SER    88      18.842  54.556  13.197  1.00 36.88           C  
ATOM    572  OG  SER    88      19.560  54.036  12.078  1.00 36.15           O  
ATOM    573  N   VAL    89      16.930  52.277  11.760  1.00 38.48           N  
ATOM    574  CA  VAL    89      16.787  50.813  11.601  1.00 38.88           C  
ATOM    575  C   VAL    89      17.830  50.302  10.631  1.00 38.06           C  
ATOM    576  O   VAL    89      18.230  51.035   9.725  1.00 36.88           O  
ATOM    577  CB  VAL    89      15.369  50.373  11.097  1.00 40.20           C  
ATOM    578  CG1 VAL    89      14.302  50.819  12.041  1.00 38.37           C  
ATOM    579  CG2 VAL    89      15.078  50.950   9.696  1.00 40.61           C  
ATOM    580  N   THR    90      18.312  49.087  10.863  1.00 37.53           N  
ATOM    581  CA  THR    90      19.163  48.436   9.884  1.00 37.70           C  
ATOM    582  C   THR    90      18.491  47.149   9.499  1.00 37.66           C  
ATOM    583  O   THR    90      18.180  46.320  10.339  1.00 38.80           O  
ATOM    584  CB  THR    90      20.601  48.220  10.352  1.00 35.79           C  
ATOM    585  OG1 THR    90      21.173  49.505  10.639  1.00 36.06           O  
ATOM    586  CG2 THR    90      21.482  47.492   9.246  1.00 37.44           C  
ATOM    587  N   LEU    91      18.250  47.032   8.200  1.00 38.53           N  
ATOM    588  CA  LEU    91      17.699  45.849   7.614  1.00 39.28           C  
ATOM    589  C   LEU    91      18.794  45.059   6.917  1.00 40.62           C  
ATOM    590  O   LEU    91      19.650  45.631   6.225  1.00 40.09           O  
ATOM    591  CB  LEU    91      16.605  46.249   6.647  1.00 40.01           C  
ATOM    592  CG  LEU    91      15.246  46.573   7.263  1.00 38.97           C  
ATOM    593  CD1 LEU    91      15.310  47.813   8.152  1.00 43.01           C  
ATOM    594  CD2 LEU    91      14.252  46.840   6.101  1.00 40.75           C  
ATOM    595  N   ALA    92      18.781  43.736   7.095  1.00 41.61           N  
ATOM    596  CA  ALA    92      19.736  42.893   6.387  1.00 43.96           C  
ATOM    597  C   ALA    92      19.142  41.498   6.171  1.00 46.03           C  
ATOM    598  O   ALA    92      18.278  41.098   6.966  1.00 47.72           O  
ATOM    599  CB  ALA    92      21.036  42.818   7.155  1.00 42.95           C  
ATOM    600  N   PRO    93      19.572  40.763   5.108  1.00 47.15           N  
ATOM    601  CA  PRO    93      19.204  39.332   5.006  1.00 47.61           C  
ATOM    602  C   PRO    93      19.973  38.543   6.092  1.00 47.80           C  
ATOM    603  O   PRO    93      20.882  37.772   5.765  1.00 47.05           O  
ATOM    604  CB  PRO    93      19.687  38.934   3.596  1.00 47.22           C  
ATOM    605  CG  PRO    93      20.845  39.877   3.317  1.00 47.42           C  
ATOM    606  CD  PRO    93      20.406  41.189   3.950  1.00 47.69           C  
ATOM    607  N   PHE    94      19.635  38.785   7.367  1.00 47.53           N  
ATOM    608  CA  PHE    94      20.393  38.209   8.489  1.00 48.62           C  
ATOM    609  C   PHE    94      20.432  36.678   8.505  1.00 50.08           C  
ATOM    610  O   PHE    94      21.419  36.076   8.964  1.00 51.13           O  
ATOM    611  CB  PHE    94      19.810  38.662   9.811  1.00 48.35           C  
ATOM    612  CG  PHE    94      20.107  40.061  10.144  1.00 48.23           C  
ATOM    613  CD1 PHE    94      21.394  40.456  10.421  1.00 47.44           C  
ATOM    614  CD2 PHE    94      19.080  41.006  10.192  1.00 46.55           C  
ATOM    615  CE1 PHE    94      21.655  41.793  10.741  1.00 49.24           C  
ATOM    616  CE2 PHE    94      19.329  42.325  10.524  1.00 47.35           C  
ATOM    617  CZ  PHE    94      20.607  42.724  10.797  1.00 48.46           C  
ATOM    618  N   GLY    95      19.369  36.036   8.025  1.00 50.07           N  
ATOM    619  CA  GLY    95      19.398  34.572   7.973  1.00 52.05           C  
ATOM    620  C   GLY    95      20.520  34.009   7.112  1.00 52.20           C  
ATOM    621  O   GLY    95      20.907  32.844   7.284  1.00 52.90           O  
ATOM    622  N   LYS    96      21.045  34.824   6.187  1.00 52.00           N  
ATOM    623  CA  LYS    96      21.969  34.329   5.148  1.00 51.83           C  
ATOM    624  C   LYS    96      23.437  34.283   5.579  1.00 51.44           C  
ATOM    625  O   LYS    96      24.319  34.006   4.770  1.00 51.70           O  
ATOM    626  CB  LYS    96      21.802  35.142   3.824  1.00 51.81           C  
ATOM    627  N   GLY    97      23.713  34.551   6.847  1.00 50.94           N  
ATOM    628  CA  GLY    97      25.090  34.414   7.308  1.00 50.33           C  
ATOM    629  C   GLY    97      25.611  35.687   7.922  1.00 49.54           C  
ATOM    630  O   GLY    97      24.831  36.573   8.261  1.00 50.33           O  
ATOM    631  N   ASP    98      26.932  35.782   8.047  1.00 49.05           N  
ATOM    632  CA  ASP    98      27.539  36.781   8.924  1.00 48.11           C  
ATOM    633  C   ASP    98      27.244  38.226   8.526  1.00 47.99           C  
ATOM    634  O   ASP    98      27.201  38.544   7.338  1.00 47.68           O  
ATOM    635  CB  ASP    98      29.033  36.507   9.105  1.00 47.96           C  
ATOM    636  CG  ASP    98      29.289  35.466  10.185  1.00 47.86           C  
ATOM    637  OD1 ASP    98      28.397  35.330  11.066  1.00 49.44           O  
ATOM    638  OD2 ASP    98      30.344  34.796  10.165  1.00 42.64           O  
ATOM    639  N   ALA    99      27.013  39.085   9.526  1.00 47.12           N  
ATOM    640  CA  ALA    99      26.613  40.475   9.280  1.00 47.62           C  
ATOM    641  C   ALA    99      27.544  41.255   8.332  1.00 47.81           C  
ATOM    642  O   ALA    99      27.066  41.994   7.462  1.00 49.11           O  
ATOM    643  CB  ALA    99      26.414  41.247  10.612  1.00 46.67           C  
ATOM    644  N   LEU   100      28.854  41.108   8.500  1.00 47.20           N  
ATOM    645  CA  LEU   100      29.784  41.843   7.668  1.00 47.26           C  
ATOM    646  C   LEU   100      29.881  41.320   6.208  1.00 47.34           C  
ATOM    647  O   LEU   100      30.537  41.933   5.366  1.00 47.80           O  
ATOM    648  CB  LEU   100      31.156  41.957   8.363  1.00 47.63           C  
ATOM    649  CG  LEU   100      31.246  42.793   9.655  1.00 47.37           C  
ATOM    650  CD1 LEU   100      32.698  42.945  10.097  1.00 44.40           C  
ATOM    651  CD2 LEU   100      30.603  44.166   9.523  1.00 47.96           C  
ATOM    652  N   THR   101      29.225  40.196   5.918  1.00 47.25           N  
ATOM    653  CA  THR   101      29.122  39.670   4.543  1.00 47.24           C  
ATOM    654  C   THR   101      27.868  40.174   3.822  1.00 47.24           C  
ATOM    655  O   THR   101      27.753  40.062   2.608  1.00 48.04           O  
ATOM    656  CB  THR   101      29.068  38.093   4.506  1.00 47.64           C  
ATOM    657  OG1 THR   101      27.862  37.639   5.158  1.00 47.49           O  
ATOM    658  CG2 THR   101      30.274  37.470   5.169  1.00 44.40           C  
ATOM    659  N   LEU   102      26.921  40.710   4.562  1.00 47.23           N  
ATOM    660  CA  LEU   102      25.623  41.022   4.011  1.00 47.59           C  
ATOM    661  C   LEU   102      25.497  42.449   3.542  1.00 46.58           C  
ATOM    662  O   LEU   102      26.127  43.302   4.092  1.00 46.32           O  
ATOM    663  CB  LEU   102      24.556  40.797   5.080  1.00 48.18           C  
ATOM    664  CG  LEU   102      24.513  39.508   5.876  1.00 49.29           C  
ATOM    665  CD1 LEU   102      23.450  39.497   6.890  1.00 47.88           C  
ATOM    666  CD2 LEU   102      24.375  38.361   4.974  1.00 48.28           C  
ATOM    667  N   PRO   103      24.634  42.711   2.567  1.00 45.68           N  
ATOM    668  CA  PRO   103      24.248  44.107   2.342  1.00 44.98           C  
ATOM    669  C   PRO   103      23.440  44.570   3.544  1.00 44.51           C  
ATOM    670  O   PRO   103      22.679  43.789   4.116  1.00 45.61           O  
ATOM    671  CB  PRO   103      23.360  44.042   1.099  1.00 45.24           C  
ATOM    672  CG  PRO   103      22.818  42.660   1.098  1.00 46.09           C  
ATOM    673  CD  PRO   103      23.959  41.807   1.626  1.00 45.51           C  
ATOM    674  N   ARG   104      23.642  45.803   3.964  1.00 42.27           N  
ATOM    675  CA  ARG   104      23.009  46.293   5.151  1.00 42.38           C  
ATOM    676  C   ARG   104      22.432  47.658   4.826  1.00 40.76           C  
ATOM    677  O   ARG   104      23.163  48.568   4.419  1.00 40.88           O  
ATOM    678  CB  ARG   104      24.002  46.412   6.307  1.00 42.35           C  
ATOM    679  CG  ARG   104      24.269  45.116   7.027  1.00 45.67           C  
ATOM    680  CD  ARG   104      25.616  44.582   6.761  1.00 47.32           C  
ATOM    681  NE  ARG   104      26.661  45.481   7.210  1.00 49.89           N  
ATOM    682  CZ  ARG   104      27.859  45.565   6.657  1.00 50.47           C  
ATOM    683  NH1 ARG   104      28.731  46.415   7.158  1.00 52.92           N  
ATOM    684  NH2 ARG   104      28.191  44.799   5.609  1.00 54.70           N  
ATOM    685  N   LEU   105      21.116  47.757   4.962  1.00 38.88           N  
ATOM    686  CA  LEU   105      20.420  48.984   4.661  1.00 37.14           C  
ATOM    687  C   LEU   105      20.077  49.715   5.945  1.00 37.01           C  
ATOM    688  O   LEU   105      19.348  49.180   6.791  1.00 36.52           O  
ATOM    689  CB  LEU   105      19.189  48.688   3.787  1.00 37.18           C  
ATOM    690  CG  LEU   105      18.183  49.809   3.601  1.00 37.12           C  
ATOM    691  CD1 LEU   105      18.777  50.834   2.609  1.00 38.71           C  
ATOM    692  CD2 LEU   105      16.883  49.254   3.095  1.00 39.88           C  
ATOM    693  N   THR   106      20.646  50.912   6.115  1.00 36.12           N  
ATOM    694  CA  THR   106      20.308  51.740   7.269  1.00 36.15           C  
ATOM    695  C   THR   106      19.352  52.861   6.858  1.00 36.02           C  
ATOM    696  O   THR   106      19.630  53.603   5.923  1.00 34.58           O  
ATOM    697  CB  THR   106      21.576  52.300   7.981  1.00 36.43           C  
ATOM    698  OG1 THR   106      22.362  51.202   8.439  1.00 37.67           O  
ATOM    699  CG2 THR   106      21.183  53.136   9.188  1.00 35.63           C  
ATOM    700  N   LEU   107      18.220  52.959   7.562  1.00 36.38           N  
ATOM    701  CA  LEU   107      17.226  53.997   7.322  1.00 37.39           C  
ATOM    702  C   LEU   107      17.071  54.808   8.598  1.00 37.59           C  
ATOM    703  O   LEU   107      16.786  54.255   9.658  1.00 38.36           O  
ATOM    704  CB  LEU   107      15.883  53.386   6.890  1.00 37.42           C  
ATOM    705  CG  LEU   107      15.888  52.335   5.754  1.00 38.96           C  
ATOM    706  CD1 LEU   107      14.515  51.683   5.658  1.00 38.73           C  
ATOM    707  CD2 LEU   107      16.225  52.995   4.407  1.00 37.32           C  
ATOM    708  N   VAL   108      17.306  56.117   8.486  1.00 37.38           N  
ATOM    709  CA  VAL   108      17.208  57.028   9.609  1.00 36.50           C  
ATOM    710  C   VAL   108      15.982  57.912   9.428  1.00 36.44           C  
ATOM    711  O   VAL   108      15.771  58.434   8.349  1.00 36.83           O  
ATOM    712  CB  VAL   108      18.506  57.843   9.752  1.00 35.47           C  
ATOM    713  CG1 VAL   108      18.391  58.875  10.868  1.00 35.13           C  
ATOM    714  CG2 VAL   108      19.692  56.899   9.952  1.00 33.05           C  
ATOM    715  N   GLY   109      15.178  58.090  10.478  1.00 37.67           N  
ATOM    716  CA  GLY   109      14.016  58.998  10.380  1.00 37.60           C  
ATOM    717  C   GLY   109      13.194  59.088  11.645  1.00 38.67           C  
ATOM    718  O   GLY   109      13.748  59.065  12.745  1.00 38.44           O  
ATOM    719  N   ARG   110      11.873  59.219  11.496  1.00 39.40           N  
ATOM    720  CA  ARG   110      10.971  59.310  12.660  1.00 39.19           C  
ATOM    721  C   ARG   110       9.996  58.148  12.742  1.00 39.98           C  
ATOM    722  O   ARG   110       9.556  57.623  11.725  1.00 40.59           O  
ATOM    723  CB  ARG   110      10.250  60.665  12.723  1.00 38.94           C  
ATOM    724  CG  ARG   110      11.188  61.811  13.077  1.00 37.80           C  
ATOM    725  CD  ARG   110      10.575  63.184  12.887  1.00 38.81           C  
ATOM    726  NE  ARG   110      11.606  64.173  13.201  1.00 40.29           N  
ATOM    727  CZ  ARG   110      11.942  64.569  14.432  1.00 41.25           C  
ATOM    728  NH1 ARG   110      12.941  65.434  14.584  1.00 40.86           N  
ATOM    729  NH2 ARG   110      11.291  64.117  15.507  1.00 40.51           N  
ATOM    730  N   ALA   111       9.739  57.698  13.974  1.00 39.87           N  
ATOM    731  CA  ALA   111       8.742  56.686  14.255  1.00 39.24           C  
ATOM    732  C   ALA   111       7.410  57.388  14.427  1.00 39.28           C  
ATOM    733  O   ALA   111       7.158  58.004  15.488  1.00 39.27           O  
ATOM    734  CB  ALA   111       9.101  55.963  15.524  1.00 40.42           C  
ATOM    735  N   ASP   112       6.564  57.297  13.400  1.00 37.97           N  
ATOM    736  CA  ASP   112       5.245  57.869  13.413  1.00 37.66           C  
ATOM    737  C   ASP   112       4.263  56.791  13.859  1.00 39.07           C  
ATOM    738  O   ASP   112       4.145  55.730  13.241  1.00 37.57           O  
ATOM    739  CB  ASP   112       4.845  58.330  12.005  1.00 37.47           C  
ATOM    740  CG  ASP   112       5.527  59.613  11.572  1.00 38.12           C  
ATOM    741  OD1 ASP   112       5.787  60.485  12.423  1.00 34.00           O  
ATOM    742  OD2 ASP   112       5.797  59.778  10.356  1.00 37.81           O  
ATOM    743  N   ARG   113       3.500  57.090  14.888  1.00 39.45           N  
ATOM    744  CA  ARG   113       2.459  56.184  15.313  1.00 40.59           C  
ATOM    745  C   ARG   113       1.341  56.051  14.258  1.00 40.91           C  
ATOM    746  O   ARG   113       0.798  57.048  13.762  1.00 40.36           O  
ATOM    747  CB  ARG   113       1.932  56.668  16.654  1.00 42.56           C  
ATOM    748  CG  ARG   113       1.322  55.580  17.451  1.00 46.63           C  
ATOM    749  CD  ARG   113       2.301  54.882  18.378  1.00 48.90           C  
ATOM    750  NE  ARG   113       1.434  54.340  19.405  1.00 53.60           N  
ATOM    751  CZ  ARG   113       1.151  54.953  20.547  1.00 53.42           C  
ATOM    752  NH1 ARG   113       1.738  56.096  20.858  1.00 55.23           N  
ATOM    753  NH2 ARG   113       0.299  54.401  21.390  1.00 54.54           N  
ATOM    754  N   ILE   114       1.048  54.812  13.868  1.00 40.30           N  
ATOM    755  CA  ILE   114      -0.049  54.545  12.963  1.00 40.96           C  
ATOM    756  C   ILE   114      -1.386  54.812  13.695  1.00 41.58           C  
ATOM    757  O   ILE   114      -1.612  54.259  14.774  1.00 42.47           O  
ATOM    758  CB  ILE   114       0.042  53.108  12.411  1.00 40.38           C  
ATOM    759  CG1 ILE   114       1.260  52.984  11.459  1.00 41.25           C  
ATOM    760  CG2 ILE   114      -1.249  52.703  11.686  1.00 39.00           C  
ATOM    761  CD1 ILE   114       1.469  51.610  10.872  1.00 40.00           C  
ATOM    762  N   GLY   115      -2.227  55.688  13.131  1.00 41.83           N  
ATOM    763  CA  GLY   115      -3.554  56.030  13.692  1.00 41.15           C  
ATOM    764  C   GLY   115      -4.538  54.858  13.797  1.00 41.00           C  
ATOM    765  O   GLY   115      -4.438  53.905  13.029  1.00 40.08           O  
ATOM    766  N   PRO   116      -5.480  54.923  14.770  1.00 41.33           N  
ATOM    767  CA  PRO   116      -6.488  53.900  15.110  1.00 41.12           C  
ATOM    768  C   PRO   116      -7.162  53.226  13.897  1.00 41.75           C  
ATOM    769  O   PRO   116      -7.274  51.988  13.861  1.00 40.88           O  
ATOM    770  CB  PRO   116      -7.537  54.687  15.910  1.00 41.97           C  
ATOM    771  CG  PRO   116      -6.830  55.877  16.457  1.00 41.54           C  
ATOM    772  CD  PRO   116      -5.555  56.093  15.673  1.00 41.00           C  
ATOM    773  N   ASP   117      -7.599  54.026  12.918  1.00 41.48           N  
ATOM    774  CA  ASP   117      -8.340  53.487  11.759  1.00 42.14           C  
ATOM    775  C   ASP   117      -7.572  52.469  10.922  1.00 41.56           C  
ATOM    776  O   ASP   117      -8.163  51.581  10.314  1.00 40.67           O  
ATOM    777  CB  ASP   117      -8.893  54.602  10.847  1.00 42.62           C  
ATOM    778  CG  ASP   117      -9.916  55.509  11.548  1.00 44.68           C  
ATOM    779  OD1 ASP   117     -10.339  56.488  10.904  1.00 47.01           O  
ATOM    780  OD2 ASP   117     -10.294  55.273  12.721  1.00 46.41           O  
ATOM    781  N   GLU   118      -6.247  52.616  10.907  1.00 42.25           N  
ATOM    782  CA  GLU   118      -5.363  51.789  10.115  1.00 42.48           C  
ATOM    783  C   GLU   118      -4.801  50.593  10.880  1.00 41.49           C  
ATOM    784  O   GLU   118      -4.125  49.758  10.287  1.00 40.69           O  
ATOM    785  CB  GLU   118      -4.195  52.638   9.616  1.00 43.11           C  
ATOM    786  CG  GLU   118      -4.617  53.969   8.963  1.00 45.99           C  
ATOM    787  CD  GLU   118      -3.407  54.741   8.501  1.00 51.55           C  
ATOM    788  OE1 GLU   118      -2.791  54.297   7.508  1.00 53.87           O  
ATOM    789  OE2 GLU   118      -3.024  55.742   9.151  1.00 51.97           O  
ATOM    790  N   VAL   119      -5.055  50.470  12.180  1.00 40.47           N  
ATOM    791  CA  VAL   119      -4.452  49.289  12.818  1.00 39.77           C  
ATOM    792  C   VAL   119      -4.970  47.927  12.305  1.00 38.62           C  
ATOM    793  O   VAL   119      -4.153  47.050  12.063  1.00 37.65           O  
ATOM    794  CB  VAL   119      -4.130  49.368  14.343  1.00 39.16           C  
ATOM    795  CG1 VAL   119      -3.759  50.786  14.742  1.00 39.45           C  
ATOM    796  CG2 VAL   119      -5.185  48.829  15.167  1.00 41.43           C  
ATOM    797  N   PRO   120      -6.304  47.757  12.134  1.00 38.16           N  
ATOM    798  CA  PRO   120      -6.766  46.493  11.532  1.00 37.43           C  
ATOM    799  C   PRO   120      -6.020  46.047  10.227  1.00 37.74           C  
ATOM    800  O   PRO   120      -5.633  44.876  10.099  1.00 36.09           O  
ATOM    801  CB  PRO   120      -8.245  46.752  11.284  1.00 37.07           C  
ATOM    802  CG  PRO   120      -8.634  47.730  12.397  1.00 38.18           C  
ATOM    803  CD  PRO   120      -7.440  48.628  12.532  1.00 37.57           C  
ATOM    804  N   LEU   121      -5.823  46.977   9.301  1.00 37.13           N  
ATOM    805  CA  LEU   121      -5.069  46.685   8.080  1.00 38.71           C  
ATOM    806  C   LEU   121      -3.622  46.312   8.376  1.00 37.67           C  
ATOM    807  O   LEU   121      -3.110  45.342   7.819  1.00 37.67           O  
ATOM    808  CB  LEU   121      -5.126  47.883   7.139  1.00 38.61           C  
ATOM    809  CG  LEU   121      -4.512  47.752   5.759  1.00 39.30           C  
ATOM    810  CD1 LEU   121      -5.110  46.579   4.936  1.00 35.77           C  
ATOM    811  CD2 LEU   121      -4.764  49.121   5.140  1.00 41.31           C  
ATOM    812  N   ALA   122      -2.980  47.061   9.274  1.00 36.98           N  
ATOM    813  CA  ALA   122      -1.574  46.854   9.582  1.00 36.59           C  
ATOM    814  C   ALA   122      -1.386  45.497  10.265  1.00 37.61           C  
ATOM    815  O   ALA   122      -0.397  44.789  10.033  1.00 36.60           O  
ATOM    816  CB  ALA   122      -1.034  48.017  10.459  1.00 37.41           C  
ATOM    817  N   ILE   123      -2.358  45.125  11.089  1.00 37.52           N  
ATOM    818  CA  ILE   123      -2.385  43.802  11.748  1.00 38.61           C  
ATOM    819  C   ILE   123      -2.406  42.675  10.741  1.00 37.17           C  
ATOM    820  O   ILE   123      -1.649  41.710  10.838  1.00 37.42           O  
ATOM    821  CB  ILE   123      -3.657  43.639  12.672  1.00 39.07           C  
ATOM    822  CG1 ILE   123      -3.511  44.499  13.927  1.00 41.23           C  
ATOM    823  CG2 ILE   123      -3.890  42.180  13.098  1.00 40.52           C  
ATOM    824  CD1 ILE   123      -2.270  44.198  14.646  1.00 45.57           C  
ATOM    825  N   ALA   124      -3.313  42.752   9.795  1.00 36.81           N  
ATOM    826  CA  ALA   124      -3.427  41.659   8.857  1.00 37.23           C  
ATOM    827  C   ALA   124      -2.128  41.553   8.001  1.00 37.64           C  
ATOM    828  O   ALA   124      -1.590  40.452   7.800  1.00 36.63           O  
ATOM    829  CB  ALA   124      -4.654  41.830   7.999  1.00 37.00           C  
ATOM    830  N   ARG   125      -1.607  42.702   7.579  1.00 37.64           N  
ATOM    831  CA  ARG   125      -0.338  42.736   6.830  1.00 38.74           C  
ATOM    832  C   ARG   125       0.839  42.139   7.607  1.00 39.32           C  
ATOM    833  O   ARG   125       1.660  41.394   7.056  1.00 39.10           O  
ATOM    834  CB  ARG   125       0.003  44.157   6.428  1.00 39.12           C  
ATOM    835  CG  ARG   125      -0.760  44.677   5.279  1.00 39.31           C  
ATOM    836  CD  ARG   125      -0.540  46.186   5.178  1.00 42.21           C  
ATOM    837  NE  ARG   125      -1.251  46.747   4.033  1.00 42.02           N  
ATOM    838  CZ  ARG   125      -1.330  48.041   3.735  1.00 44.09           C  
ATOM    839  NH1 ARG   125      -0.787  48.966   4.539  1.00 42.23           N  
ATOM    840  NH2 ARG   125      -1.989  48.402   2.627  1.00 43.74           N  
ATOM    841  N   TYR   126       0.913  42.455   8.901  1.00 38.91           N  
ATOM    842  CA  TYR   126       1.965  41.957   9.741  1.00 38.50           C  
ATOM    843  C   TYR   126       1.883  40.445  10.004  1.00 38.28           C  
ATOM    844  O   TYR   126       2.888  39.738   9.921  1.00 37.03           O  
ATOM    845  CB  TYR   126       1.882  42.701  11.070  1.00 38.18           C  
ATOM    846  CG  TYR   126       3.073  42.563  11.972  1.00 38.12           C  
ATOM    847  CD1 TYR   126       4.130  43.481  11.909  1.00 38.79           C  
ATOM    848  CD2 TYR   126       3.099  41.592  12.959  1.00 38.98           C  
ATOM    849  CE1 TYR   126       5.217  43.383  12.779  1.00 38.36           C  
ATOM    850  CE2 TYR   126       4.154  41.486  13.840  1.00 39.29           C  
ATOM    851  CZ  TYR   126       5.211  42.397  13.757  1.00 39.80           C  
ATOM    852  OH  TYR   126       6.241  42.303  14.671  1.00 40.32           O  
ATOM    853  N   ILE   127       0.680  39.970  10.361  1.00 38.68           N  
ATOM    854  CA  ILE   127       0.370  38.560  10.561  1.00 38.24           C  
ATOM    855  C   ILE   127       0.751  37.693   9.356  1.00 38.71           C  
ATOM    856  O   ILE   127       1.212  36.567   9.513  1.00 37.24           O  
ATOM    857  CB  ILE   127      -1.169  38.356  10.836  1.00 39.14           C  
ATOM    858  CG1 ILE   127      -1.566  38.755  12.282  1.00 39.78           C  
ATOM    859  CG2 ILE   127      -1.614  36.931  10.590  1.00 38.81           C  
ATOM    860  CD1 ILE   127      -0.651  38.299  13.287  1.00 41.39           C  
ATOM    861  N   ALA   128       0.536  38.247   8.170  1.00 38.28           N  
ATOM    862  CA  ALA   128       0.881  37.603   6.892  1.00 39.64           C  
ATOM    863  C   ALA   128       2.362  37.196   6.864  1.00 39.77           C  
ATOM    864  O   ALA   128       2.692  36.160   6.326  1.00 40.73           O  
ATOM    865  CB  ALA   128       0.538  38.544   5.716  1.00 37.72           C  
ATOM    866  N   ARG   129       3.239  37.977   7.501  1.00 39.93           N  
ATOM    867  CA  ARG   129       4.663  37.665   7.535  1.00 40.44           C  
ATOM    868  C   ARG   129       5.092  36.935   8.789  1.00 41.02           C  
ATOM    869  O   ARG   129       6.078  36.186   8.762  1.00 41.36           O  
ATOM    870  CB  ARG   129       5.504  38.953   7.385  1.00 40.36           C  
ATOM    871  CG  ARG   129       5.631  39.460   6.006  1.00 40.68           C  
ATOM    872  CD  ARG   129       6.516  40.731   6.028  1.00 42.98           C  
ATOM    873  NE  ARG   129       7.005  41.042   4.703  1.00 42.54           N  
ATOM    874  CZ  ARG   129       8.005  41.881   4.428  1.00 40.53           C  
ATOM    875  NH1 ARG   129       8.668  42.496   5.400  1.00 35.92           N  
ATOM    876  NH2 ARG   129       8.369  42.072   3.162  1.00 40.85           N  
ATOM    877  N   TYR   130       4.355  37.171   9.879  1.00 40.43           N  
ATOM    878  CA  TYR   130       4.744  36.787  11.237  1.00 40.69           C  
ATOM    879  C   TYR   130       3.545  36.101  11.899  1.00 40.82           C  
ATOM    880  O   TYR   130       2.832  36.721  12.718  1.00 39.21           O  
ATOM    881  CB  TYR   130       5.205  38.026  12.053  1.00 40.55           C  
ATOM    882  CG  TYR   130       6.263  38.783  11.311  1.00 40.43           C  
ATOM    883  CD1 TYR   130       7.511  38.180  11.078  1.00 41.13           C  
ATOM    884  CD2 TYR   130       6.016  40.050  10.782  1.00 36.37           C  
ATOM    885  CE1 TYR   130       8.468  38.794  10.335  1.00 42.15           C  
ATOM    886  CE2 TYR   130       6.996  40.693  10.025  1.00 37.26           C  
ATOM    887  CZ  TYR   130       8.215  40.051   9.809  1.00 39.60           C  
ATOM    888  OH  TYR   130       9.191  40.643   9.072  1.00 41.60           O  
ATOM    889  N   PRO   131       3.306  34.817  11.540  1.00 42.16           N  
ATOM    890  CA  PRO   131       2.096  34.165  12.065  1.00 42.41           C  
ATOM    891  C   PRO   131       2.062  34.024  13.586  1.00 43.43           C  
ATOM    892  O   PRO   131       0.988  33.896  14.156  1.00 43.70           O  
ATOM    893  CB  PRO   131       2.077  32.794  11.349  1.00 42.87           C  
ATOM    894  CG  PRO   131       3.453  32.545  10.957  1.00 42.32           C  
ATOM    895  CD  PRO   131       4.065  33.913  10.654  1.00 41.32           C  
ATOM    896  N   LYS   132       3.210  34.079  14.254  1.00 44.16           N  
ATOM    897  CA  LYS   132       3.206  34.014  15.703  1.00 45.24           C  
ATOM    898  C   LYS   132       2.663  35.298  16.324  1.00 44.82           C  
ATOM    899  O   LYS   132       2.263  35.304  17.487  1.00 43.69           O  
ATOM    900  CB  LYS   132       4.595  33.704  16.260  1.00 45.12           C  
ATOM    901  CG  LYS   132       4.842  32.232  16.432  1.00 47.27           C  
ATOM    902  CD  LYS   132       6.196  31.909  17.119  1.00 48.39           C  
ATOM    903  CE  LYS   132       7.430  32.170  16.226  1.00 52.49           C  
ATOM    904  NZ  LYS   132       7.137  32.521  14.768  1.00 53.17           N  
ATOM    905  N   ALA   133       2.641  36.376  15.540  1.00 44.82           N  
ATOM    906  CA  ALA   133       2.119  37.640  16.033  1.00 45.86           C  
ATOM    907  C   ALA   133       0.639  37.487  16.421  1.00 46.28           C  
ATOM    908  O   ALA   133       0.119  38.284  17.187  1.00 46.88           O  
ATOM    909  CB  ALA   133       2.317  38.750  15.011  1.00 44.40           C  
ATOM    910  N   LYS   134      -0.011  36.451  15.885  1.00 46.67           N  
ATOM    911  CA  LYS   134      -1.416  36.157  16.164  1.00 47.61           C  
ATOM    912  C   LYS   134      -1.651  36.137  17.651  1.00 47.75           C  
ATOM    913  O   LYS   134      -2.757  36.404  18.112  1.00 47.97           O  
ATOM    914  CB  LYS   134      -1.842  34.813  15.552  1.00 47.52           C  
ATOM    915  CG  LYS   134      -1.859  34.804  14.020  1.00 47.47           C  
ATOM    916  CD  LYS   134      -2.287  33.432  13.483  1.00 49.07           C  
ATOM    917  CE  LYS   134      -1.445  32.992  12.281  1.00 51.18           C  
ATOM    918  NZ  LYS   134      -1.843  33.616  10.967  1.00 49.86           N  
ATOM    919  N   LEU   135      -0.579  35.853  18.390  1.00 48.06           N  
ATOM    920  CA  LEU   135      -0.617  35.721  19.826  1.00 47.97           C  
ATOM    921  C   LEU   135      -0.192  37.001  20.519  1.00 47.15           C  
ATOM    922  O   LEU   135      -0.969  37.551  21.300  1.00 46.82           O  
ATOM    923  CB  LEU   135       0.261  34.537  20.278  1.00 48.70           C  
ATOM    924  CG  LEU   135       0.035  33.874  21.647  1.00 50.11           C  
ATOM    925  CD1 LEU   135       0.774  34.634  22.791  1.00 50.84           C  
ATOM    926  CD2 LEU   135      -1.474  33.663  21.956  1.00 50.85           C  
ATOM    927  N   TYR   136       1.031  37.462  20.260  1.00 46.11           N  
ATOM    928  CA  TYR   136       1.581  38.606  21.013  1.00 45.99           C  
ATOM    929  C   TYR   136       1.034  39.993  20.657  1.00 46.23           C  
ATOM    930  O   TYR   136       1.253  40.941  21.400  1.00 47.04           O  
ATOM    931  CB  TYR   136       3.109  38.615  21.041  1.00 45.39           C  
ATOM    932  CG  TYR   136       3.790  38.700  19.693  1.00 46.29           C  
ATOM    933  CD1 TYR   136       3.885  39.920  19.003  1.00 46.59           C  
ATOM    934  CD2 TYR   136       4.382  37.560  19.114  1.00 47.90           C  
ATOM    935  CE1 TYR   136       4.510  40.011  17.768  1.00 45.30           C  
ATOM    936  CE2 TYR   136       5.021  37.640  17.878  1.00 45.08           C  
ATOM    937  CZ  TYR   136       5.087  38.863  17.214  1.00 45.87           C  
ATOM    938  OH  TYR   136       5.715  38.938  15.992  1.00 41.33           O  
ATOM    939  N   LEU   137       0.359  40.122  19.511  1.00 46.65           N  
ATOM    940  CA  LEU   137      -0.418  41.332  19.204  1.00 46.13           C  
ATOM    941  C   LEU   137      -1.735  41.311  20.000  1.00 46.60           C  
ATOM    942  O   LEU   137      -2.290  42.359  20.306  1.00 46.98           O  
ATOM    943  CB  LEU   137      -0.713  41.459  17.704  1.00 45.65           C  
ATOM    944  CG  LEU   137       0.437  41.531  16.695  1.00 44.77           C  
ATOM    945  CD1 LEU   137      -0.089  41.595  15.239  1.00 43.62           C  
ATOM    946  CD2 LEU   137       1.283  42.731  17.005  1.00 44.94           C  
ATOM    947  N   SER   138      -2.232  40.115  20.331  1.00 46.62           N  
ATOM    948  CA  SER   138      -3.452  39.978  21.138  1.00 46.51           C  
ATOM    949  C   SER   138      -3.169  40.269  22.616  1.00 46.44           C  
ATOM    950  O   SER   138      -4.035  40.077  23.474  1.00 45.70           O  
ATOM    951  CB  SER   138      -4.083  38.578  20.979  1.00 46.73           C  
ATOM    952  OG  SER   138      -4.835  38.461  19.779  1.00 45.66           O  
ATOM    953  N   LEU   139      -1.955  40.729  22.906  1.00 46.67           N  
ATOM    954  CA  LEU   139      -1.587  41.082  24.277  1.00 47.11           C  
ATOM    955  C   LEU   139      -1.803  42.577  24.520  1.00 47.01           C  
ATOM    956  O   LEU   139      -1.718  43.355  23.579  1.00 47.26           O  
ATOM    957  CB  LEU   139      -0.132  40.673  24.561  1.00 47.38           C  
ATOM    958  CG  LEU   139       0.075  39.157  24.775  1.00 48.22           C  
ATOM    959  CD1 LEU   139       1.557  38.734  24.649  1.00 48.29           C  
ATOM    960  CD2 LEU   139      -0.538  38.697  26.101  1.00 46.80           C  
ATOM    961  N   PRO   140      -2.098  42.982  25.772  1.00 46.85           N  
ATOM    962  CA  PRO   140      -2.243  44.405  26.123  1.00 47.11           C  
ATOM    963  C   PRO   140      -1.185  45.383  25.554  1.00 46.98           C  
ATOM    964  O   PRO   140      -0.054  44.997  25.304  1.00 46.95           O  
ATOM    965  CB  PRO   140      -2.208  44.384  27.670  1.00 47.08           C  
ATOM    966  CG  PRO   140      -2.900  43.086  27.999  1.00 46.63           C  
ATOM    967  CD  PRO   140      -2.367  42.116  26.942  1.00 47.39           C  
ATOM    968  N   ASP   141      -1.623  46.629  25.332  1.00 47.12           N  
ATOM    969  CA  ASP   141      -0.824  47.794  24.899  1.00 46.88           C  
ATOM    970  C   ASP   141       0.037  47.641  23.642  1.00 45.67           C  
ATOM    971  O   ASP   141       1.088  48.244  23.545  1.00 45.12           O  
ATOM    972  CB  ASP   141      -0.028  48.431  26.058  1.00 47.97           C  
ATOM    973  CG  ASP   141       0.312  49.933  25.794  1.00 51.71           C  
ATOM    974  OD1 ASP   141       0.123  50.416  24.640  1.00 56.09           O  
ATOM    975  OD2 ASP   141       0.765  50.642  26.726  1.00 53.23           O  
ATOM    976  N   THR   142      -0.433  46.872  22.665  1.00 45.38           N  
ATOM    977  CA  THR   142       0.298  46.738  21.399  1.00 44.64           C  
ATOM    978  C   THR   142       0.354  48.133  20.750  1.00 43.67           C  
ATOM    979  O   THR   142      -0.661  48.835  20.706  1.00 42.32           O  
ATOM    980  CB  THR   142      -0.322  45.645  20.432  1.00 45.28           C  
ATOM    981  OG1 THR   142      -1.500  46.129  19.764  1.00 50.55           O  
ATOM    982  CG2 THR   142      -0.691  44.384  21.154  1.00 43.67           C  
ATOM    983  N   ARG   143       1.543  48.544  20.302  1.00 42.84           N  
ATOM    984  CA  ARG   143       1.752  49.844  19.613  1.00 41.55           C  
ATOM    985  C   ARG   143       2.296  49.644  18.197  1.00 41.15           C  
ATOM    986  O   ARG   143       3.172  48.825  17.972  1.00 39.56           O  
ATOM    987  CB  ARG   143       2.693  50.754  20.397  1.00 41.33           C  
ATOM    988  CG  ARG   143       2.105  51.238  21.716  1.00 42.76           C  
ATOM    989  CD  ARG   143       2.837  52.418  22.285  1.00 41.74           C  
ATOM    990  NE  ARG   143       2.324  52.678  23.626  1.00 43.71           N  
ATOM    991  CZ  ARG   143       2.963  53.384  24.552  1.00 44.78           C  
ATOM    992  NH1 ARG   143       4.143  53.932  24.282  1.00 44.95           N  
ATOM    993  NH2 ARG   143       2.417  53.540  25.749  1.00 44.32           N  
ATOM    994  N   LEU   144       1.784  50.424  17.263  1.00 40.42           N  
ATOM    995  CA  LEU   144       2.074  50.247  15.850  1.00 40.95           C  
ATOM    996  C   LEU   144       2.702  51.530  15.277  1.00 40.06           C  
ATOM    997  O   LEU   144       2.163  52.615  15.462  1.00 38.91           O  
ATOM    998  CB  LEU   144       0.751  49.987  15.181  1.00 42.20           C  
ATOM    999  CG  LEU   144       0.619  49.097  13.969  1.00 46.50           C  
ATOM   1000  CD1 LEU   144       1.875  48.287  13.671  1.00 49.12           C  
ATOM   1001  CD2 LEU   144      -0.608  48.216  14.255  1.00 48.62           C  
ATOM   1002  N   TYR   145       3.817  51.406  14.564  1.00 39.79           N  
ATOM   1003  CA  TYR   145       4.558  52.599  14.078  1.00 40.16           C  
ATOM   1004  C   TYR   145       4.959  52.432  12.632  1.00 40.01           C  
ATOM   1005  O   TYR   145       5.267  51.349  12.243  1.00 39.76           O  
ATOM   1006  CB  TYR   145       5.867  52.724  14.824  1.00 39.53           C  
ATOM   1007  CG  TYR   145       5.781  52.715  16.319  1.00 40.63           C  
ATOM   1008  CD1 TYR   145       5.830  53.908  17.048  1.00 39.84           C  
ATOM   1009  CD2 TYR   145       5.749  51.505  17.013  1.00 40.60           C  
ATOM   1010  CE1 TYR   145       5.801  53.895  18.451  1.00 40.06           C  
ATOM   1011  CE2 TYR   145       5.697  51.480  18.355  1.00 39.43           C  
ATOM   1012  CZ  TYR   145       5.730  52.671  19.081  1.00 39.67           C  
ATOM   1013  OH  TYR   145       5.702  52.587  20.428  1.00 42.40           O  
ATOM   1014  N   ARG   146       5.015  53.506  11.843  1.00 39.59           N  
ATOM   1015  CA  ARG   146       5.738  53.386  10.573  1.00 39.78           C  
ATOM   1016  C   ARG   146       6.938  54.325  10.546  1.00 39.11           C  
ATOM   1017  O   ARG   146       6.964  55.378  11.224  1.00 39.10           O  
ATOM   1018  CB  ARG   146       4.811  53.511   9.324  1.00 40.31           C  
ATOM   1019  CG  ARG   146       4.060  54.788   9.265  1.00 39.82           C  
ATOM   1020  CD  ARG   146       3.345  55.018   7.916  1.00 38.92           C  
ATOM   1021  NE  ARG   146       2.211  54.139   7.701  1.00 37.29           N  
ATOM   1022  CZ  ARG   146       0.949  54.414   8.052  1.00 39.59           C  
ATOM   1023  NH1 ARG   146       0.620  55.547   8.670  1.00 36.29           N  
ATOM   1024  NH2 ARG   146       0.002  53.529   7.806  1.00 38.02           N  
ATOM   1025  N   LEU   147       7.953  53.898   9.812  1.00 38.46           N  
ATOM   1026  CA  LEU   147       9.159  54.674   9.672  1.00 39.22           C  
ATOM   1027  C   LEU   147       8.892  55.779   8.668  1.00 39.28           C  
ATOM   1028  O   LEU   147       8.458  55.507   7.541  1.00 40.23           O  
ATOM   1029  CB  LEU   147      10.337  53.786   9.223  1.00 38.32           C  
ATOM   1030  CG  LEU   147      11.633  54.552   8.934  1.00 40.43           C  
ATOM   1031  CD1 LEU   147      12.162  55.301  10.146  1.00 40.13           C  
ATOM   1032  CD2 LEU   147      12.676  53.585   8.383  1.00 39.88           C  
ATOM   1033  N   ARG   148       9.128  57.019   9.093  1.00 38.60           N  
ATOM   1034  CA  ARG   148       9.226  58.123   8.164  1.00 38.77           C  
ATOM   1035  C   ARG   148      10.701  58.279   7.820  1.00 38.33           C  
ATOM   1036  O   ARG   148      11.459  58.805   8.619  1.00 38.32           O  
ATOM   1037  CB  ARG   148       8.725  59.410   8.813  1.00 38.13           C  
ATOM   1038  CG  ARG   148       8.409  60.481   7.803  1.00 37.78           C  
ATOM   1039  CD  ARG   148       8.179  61.861   8.399  1.00 38.22           C  
ATOM   1040  NE  ARG   148       7.600  61.872   9.745  1.00 37.75           N  
ATOM   1041  CZ  ARG   148       7.628  62.927  10.557  1.00 37.04           C  
ATOM   1042  NH1 ARG   148       8.198  64.048  10.163  1.00 39.09           N  
ATOM   1043  NH2 ARG   148       7.088  62.877  11.769  1.00 37.72           N  
ATOM   1044  N   THR   149      11.112  57.813   6.646  1.00 38.59           N  
ATOM   1045  CA  THR   149      12.545  57.748   6.309  1.00 37.96           C  
ATOM   1046  C   THR   149      13.029  59.141   5.922  1.00 38.33           C  
ATOM   1047  O   THR   149      12.405  59.803   5.065  1.00 36.50           O  
ATOM   1048  CB  THR   149      12.806  56.757   5.154  1.00 38.31           C  
ATOM   1049  OG1 THR   149      12.509  55.419   5.604  1.00 41.10           O  
ATOM   1050  CG2 THR   149      14.270  56.801   4.713  1.00 35.97           C  
ATOM   1051  N   GLU   150      14.136  59.582   6.538  1.00 37.61           N  
ATOM   1052  CA  GLU   150      14.712  60.870   6.226  1.00 37.27           C  
ATOM   1053  C   GLU   150      16.117  60.754   5.641  1.00 36.61           C  
ATOM   1054  O   GLU   150      16.620  61.694   5.038  1.00 35.99           O  
ATOM   1055  CB  GLU   150      14.728  61.781   7.469  1.00 37.85           C  
ATOM   1056  CG  GLU   150      13.363  62.026   8.039  1.00 40.67           C  
ATOM   1057  CD  GLU   150      13.392  62.918   9.236  1.00 43.99           C  
ATOM   1058  OE1 GLU   150      13.697  62.446  10.343  1.00 45.92           O  
ATOM   1059  OE2 GLU   150      13.083  64.103   9.075  1.00 47.26           O  
ATOM   1060  N   GLY   151      16.754  59.605   5.811  1.00 36.37           N  
ATOM   1061  CA  GLY   151      18.106  59.438   5.304  1.00 35.42           C  
ATOM   1062  C   GLY   151      18.391  57.979   5.175  1.00 36.25           C  
ATOM   1063  O   GLY   151      17.818  57.157   5.916  1.00 36.80           O  
ATOM   1064  N   VAL   152      19.238  57.639   4.215  1.00 36.10           N  
ATOM   1065  CA  VAL   152      19.430  56.227   3.805  1.00 35.33           C  
ATOM   1066  C   VAL   152      20.918  55.988   3.648  1.00 35.97           C  
ATOM   1067  O   VAL   152      21.619  56.816   3.048  1.00 35.63           O  
ATOM   1068  CB  VAL   152      18.795  55.952   2.411  1.00 34.93           C  
ATOM   1069  CG1 VAL   152      19.039  54.483   1.920  1.00 32.95           C  
ATOM   1070  CG2 VAL   152      17.350  56.272   2.423  1.00 35.09           C  
ATOM   1071  N   GLN   153      21.393  54.850   4.145  1.00 36.44           N  
ATOM   1072  CA  GLN   153      22.734  54.355   3.769  1.00 37.39           C  
ATOM   1073  C   GLN   153      22.655  52.879   3.356  1.00 36.80           C  
ATOM   1074  O   GLN   153      22.052  52.100   4.058  1.00 36.40           O  
ATOM   1075  CB  GLN   153      23.665  54.515   4.963  1.00 37.50           C  
ATOM   1076  CG  GLN   153      25.127  54.524   4.640  1.00 41.65           C  
ATOM   1077  CD  GLN   153      25.556  55.736   3.810  1.00 41.98           C  
ATOM   1078  OE1 GLN   153      24.964  56.831   3.864  1.00 45.79           O  
ATOM   1079  NE2 GLN   153      26.583  55.533   3.041  1.00 42.54           N  
ATOM   1080  N   ILE   154      23.241  52.503   2.226  1.00 37.17           N  
ATOM   1081  CA  ILE   154      23.331  51.090   1.860  1.00 39.21           C  
ATOM   1082  C   ILE   154      24.785  50.640   1.815  1.00 41.79           C  
ATOM   1083  O   ILE   154      25.679  51.367   1.372  1.00 41.41           O  
ATOM   1084  CB  ILE   154      22.601  50.741   0.538  1.00 38.42           C  
ATOM   1085  CG1 ILE   154      22.646  49.226   0.255  1.00 38.22           C  
ATOM   1086  CG2 ILE   154      23.205  51.475  -0.643  1.00 38.65           C  
ATOM   1087  CD1 ILE   154      21.854  48.347   1.229  1.00 39.83           C  
ATOM   1088  N   ASN   155      25.004  49.399   2.225  1.00 44.68           N  
ATOM   1089  CA  ASN   155      26.328  48.960   2.615  1.00 46.88           C  
ATOM   1090  C   ASN   155      26.582  47.483   2.353  1.00 47.70           C  
ATOM   1091  O   ASN   155      25.686  46.663   2.509  1.00 46.80           O  
ATOM   1092  CB  ASN   155      26.426  49.207   4.104  1.00 47.14           C  
ATOM   1093  CG  ASN   155      27.647  49.882   4.462  1.00 50.04           C  
ATOM   1094  OD1 ASN   155      28.705  49.253   4.585  1.00 55.54           O  
ATOM   1095  ND2 ASN   155      27.558  51.195   4.622  1.00 52.46           N  
ATOM   1096  N   GLY   156      27.811  47.151   1.959  1.00 49.84           N  
ATOM   1097  CA  GLY   156      28.226  45.753   1.770  1.00 51.52           C  
ATOM   1098  C   GLY   156      27.617  45.115   0.522  1.00 52.58           C  
ATOM   1099  O   GLY   156      27.855  43.933   0.213  1.00 53.20           O  
ATOM   1100  N   SER   163      26.464  54.270  -1.177  1.00 60.56           N  
ATOM   1101  CA  SER   163      26.432  55.140  -2.358  1.00 60.69           C  
ATOM   1102  C   SER   163      25.807  56.505  -2.030  1.00 60.30           C  
ATOM   1103  O   SER   163      25.996  57.018  -0.913  1.00 60.50           O  
ATOM   1104  CB  SER   163      25.691  54.453  -3.512  1.00 60.82           C  
ATOM   1105  N   ASN   164      25.077  57.098  -2.983  1.00 59.18           N  
ATOM   1106  CA  ASN   164      24.316  58.305  -2.663  1.00 57.87           C  
ATOM   1107  C   ASN   164      22.811  58.245  -2.973  1.00 56.64           C  
ATOM   1108  O   ASN   164      22.310  58.927  -3.882  1.00 56.74           O  
ATOM   1109  CB  ASN   164      24.991  59.557  -3.217  1.00 58.18           C  
ATOM   1110  CG  ASN   164      25.093  60.662  -2.170  1.00 59.61           C  
ATOM   1111  OD1 ASN   164      24.452  60.581  -1.102  1.00 61.55           O  
ATOM   1112  ND2 ASN   164      25.898  61.696  -2.459  1.00 58.37           N  
ATOM   1113  N   ILE   165      22.119  57.431  -2.171  1.00 54.60           N  
ATOM   1114  CA  ILE   165      20.681  57.144  -2.264  1.00 52.78           C  
ATOM   1115  C   ILE   165      19.834  58.029  -1.349  1.00 51.56           C  
ATOM   1116  O   ILE   165      20.213  58.327  -0.218  1.00 51.45           O  
ATOM   1117  CB  ILE   165      20.383  55.679  -1.835  1.00 52.71           C  
ATOM   1118  CG1 ILE   165      21.223  54.685  -2.617  1.00 52.48           C  
ATOM   1119  CG2 ILE   165      18.870  55.346  -1.944  1.00 52.17           C  
ATOM   1120  CD1 ILE   165      21.075  53.276  -2.069  1.00 53.76           C  
ATOM   1121  N   THR   166      18.659  58.387  -1.850  1.00 49.82           N  
ATOM   1122  CA  THR   166      17.685  59.221  -1.167  1.00 47.99           C  
ATOM   1123  C   THR   166      16.460  58.402  -0.707  1.00 46.53           C  
ATOM   1124  O   THR   166      16.163  57.365  -1.305  1.00 45.87           O  
ATOM   1125  CB  THR   166      17.195  60.292  -2.160  1.00 48.47           C  
ATOM   1126  OG1 THR   166      16.247  61.157  -1.526  1.00 50.18           O  
ATOM   1127  CG2 THR   166      16.526  59.641  -3.353  1.00 47.03           C  
ATOM   1128  N   PRO   167      15.736  58.879   0.335  1.00 44.87           N  
ATOM   1129  CA  PRO   167      14.458  58.290   0.720  1.00 43.50           C  
ATOM   1130  C   PRO   167      13.494  58.042  -0.451  1.00 42.73           C  
ATOM   1131  O   PRO   167      12.872  56.980  -0.511  1.00 41.20           O  
ATOM   1132  CB  PRO   167      13.899  59.320   1.701  1.00 43.49           C  
ATOM   1133  CG  PRO   167      15.121  59.813   2.394  1.00 43.85           C  
ATOM   1134  CD  PRO   167      16.106  59.979   1.255  1.00 44.61           C  
ATOM   1135  N   ALA   168      13.394  59.003  -1.376  1.00 41.20           N  
ATOM   1136  CA  ALA   168      12.558  58.884  -2.575  1.00 40.36           C  
ATOM   1137  C   ALA   168      12.945  57.702  -3.447  1.00 40.15           C  
ATOM   1138  O   ALA   168      12.078  57.091  -4.074  1.00 39.71           O  
ATOM   1139  CB  ALA   168      12.623  60.191  -3.420  1.00 39.95           C  
ATOM   1140  N   ASP   169      14.248  57.401  -3.501  1.00 40.01           N  
ATOM   1141  CA  ASP   169      14.760  56.285  -4.307  1.00 40.40           C  
ATOM   1142  C   ASP   169      14.215  54.952  -3.813  1.00 39.36           C  
ATOM   1143  O   ASP   169      14.077  54.007  -4.570  1.00 38.74           O  
ATOM   1144  CB  ASP   169      16.286  56.201  -4.240  1.00 40.55           C  
ATOM   1145  CG  ASP   169      16.984  57.170  -5.175  1.00 44.16           C  
ATOM   1146  OD1 ASP   169      16.370  57.686  -6.141  1.00 46.62           O  
ATOM   1147  OD2 ASP   169      18.177  57.426  -4.917  1.00 46.46           O  
ATOM   1148  N   LEU   170      13.938  54.869  -2.520  1.00 39.88           N  
ATOM   1149  CA  LEU   170      13.470  53.617  -1.971  1.00 40.30           C  
ATOM   1150  C   LEU   170      11.977  53.420  -2.130  1.00 41.43           C  
ATOM   1151  O   LEU   170      11.506  52.272  -2.117  1.00 43.10           O  
ATOM   1152  CB  LEU   170      13.843  53.477  -0.496  1.00 39.86           C  
ATOM   1153  CG  LEU   170      15.310  53.540  -0.134  1.00 41.26           C  
ATOM   1154  CD1 LEU   170      15.403  53.049   1.308  1.00 38.50           C  
ATOM   1155  CD2 LEU   170      16.132  52.668  -1.055  1.00 41.75           C  
ATOM   1156  N   ARG   171      11.220  54.508  -2.225  1.00 41.64           N  
ATOM   1157  CA  ARG   171       9.757  54.400  -2.276  1.00 42.86           C  
ATOM   1158  C   ARG   171       9.224  53.862  -3.570  1.00 41.94           C  
ATOM   1159  O   ARG   171       9.793  54.126  -4.624  1.00 42.66           O  
ATOM   1160  CB  ARG   171       9.090  55.745  -2.037  1.00 44.35           C  
ATOM   1161  CG  ARG   171       8.629  55.926  -0.589  1.00 48.08           C  
ATOM   1162  CD  ARG   171       7.734  57.174  -0.489  1.00 55.26           C  
ATOM   1163  NE  ARG   171       8.159  58.232  -1.413  1.00 59.23           N  
ATOM   1164  CZ  ARG   171       9.087  59.155  -1.153  1.00 60.97           C  
ATOM   1165  NH1 ARG   171       9.718  59.190   0.027  1.00 59.89           N  
ATOM   1166  NH2 ARG   171       9.385  60.056  -2.088  1.00 61.23           N  
ATOM   1167  N   THR   172       8.104  53.136  -3.502  1.00 39.89           N  
ATOM   1168  CA  THR   172       7.400  52.778  -4.733  1.00 37.54           C  
ATOM   1169  C   THR   172       6.310  53.770  -5.091  1.00 36.45           C  
ATOM   1170  O   THR   172       5.388  53.982  -4.324  1.00 35.85           O  
ATOM   1171  CB  THR   172       6.777  51.374  -4.624  1.00 37.27           C  
ATOM   1172  OG1 THR   172       7.811  50.456  -4.280  1.00 36.73           O  
ATOM   1173  CG2 THR   172       6.129  50.979  -5.942  1.00 37.43           C  
ATOM   1174  N   ASP   173       6.386  54.342  -6.290  1.00 35.89           N  
ATOM   1175  CA  ASP   173       5.430  55.349  -6.699  1.00 35.73           C  
ATOM   1176  C   ASP   173       4.100  54.712  -7.127  1.00 35.45           C  
ATOM   1177  O   ASP   173       4.050  53.928  -8.081  1.00 34.18           O  
ATOM   1178  CB  ASP   173       6.040  56.182  -7.820  1.00 36.16           C  
ATOM   1179  CG  ASP   173       5.205  57.399  -8.183  1.00 37.67           C  
ATOM   1180  OD1 ASP   173       4.108  57.608  -7.606  1.00 38.56           O  
ATOM   1181  OD2 ASP   173       5.674  58.164  -9.053  1.00 40.65           O  
ATOM   1182  N   LEU   174       3.020  55.082  -6.432  1.00 35.60           N  
ATOM   1183  CA  LEU   174       1.699  54.491  -6.690  1.00 36.94           C  
ATOM   1184  C   LEU   174       0.820  55.341  -7.622  1.00 37.73           C  
ATOM   1185  O   LEU   174      -0.223  54.871  -8.064  1.00 38.70           O  
ATOM   1186  CB  LEU   174       0.955  54.137  -5.392  1.00 35.87           C  
ATOM   1187  CG  LEU   174       1.652  53.225  -4.335  1.00 37.10           C  
ATOM   1188  CD1 LEU   174       0.739  52.947  -3.138  1.00 42.05           C  
ATOM   1189  CD2 LEU   174       2.199  51.941  -4.887  1.00 34.58           C  
ATOM   1190  N   SER   175       1.250  56.578  -7.903  1.00 39.29           N  
ATOM   1191  CA  SER   175       0.577  57.509  -8.835  1.00 39.41           C  
ATOM   1192  C   SER   175       0.497  56.903 -10.201  1.00 38.81           C  
ATOM   1193  O   SER   175       1.480  56.338 -10.665  1.00 39.39           O  
ATOM   1194  CB  SER   175       1.393  58.781  -8.985  1.00 40.30           C  
ATOM   1195  OG  SER   175       1.749  59.250  -7.720  1.00 44.26           O  
ATOM   1196  N   GLY   176      -0.657  57.005 -10.851  1.00 38.00           N  
ATOM   1197  CA  GLY   176      -0.818  56.431 -12.193  1.00 36.90           C  
ATOM   1198  C   GLY   176      -1.274  54.983 -12.166  1.00 36.94           C  
ATOM   1199  O   GLY   176      -1.785  54.486 -13.161  1.00 36.75           O  
ATOM   1200  N   ALA   177      -1.121  54.326 -11.017  1.00 35.74           N  
ATOM   1201  CA  ALA   177      -1.447  52.891 -10.828  1.00 36.90           C  
ATOM   1202  C   ALA   177      -2.671  52.600  -9.946  1.00 37.11           C  
ATOM   1203  O   ALA   177      -2.825  51.471  -9.488  1.00 35.89           O  
ATOM   1204  CB  ALA   177      -0.241  52.139 -10.254  1.00 34.41           C  
ATOM   1205  N   GLU   178      -3.561  53.581  -9.759  1.00 38.00           N  
ATOM   1206  CA  GLU   178      -4.748  53.361  -8.912  1.00 39.26           C  
ATOM   1207  C   GLU   178      -5.582  52.148  -9.317  1.00 39.46           C  
ATOM   1208  O   GLU   178      -6.096  51.457  -8.448  1.00 39.25           O  
ATOM   1209  CB  GLU   178      -5.639  54.605  -8.793  1.00 40.40           C  
ATOM   1210  CG  GLU   178      -5.522  55.617  -9.915  1.00 43.04           C  
ATOM   1211  CD  GLU   178      -4.197  56.362  -9.892  1.00 44.81           C  
ATOM   1212  OE1 GLU   178      -3.412  56.160 -10.831  1.00 45.64           O  
ATOM   1213  OE2 GLU   178      -3.929  57.129  -8.943  1.00 47.96           O  
ATOM   1214  N   GLU   179      -5.709  51.882 -10.626  1.00 39.61           N  
ATOM   1215  CA  GLU   179      -6.423  50.683 -11.098  1.00 40.08           C  
ATOM   1216  C   GLU   179      -5.830  49.369 -10.565  1.00 39.89           C  
ATOM   1217  O   GLU   179      -6.570  48.512 -10.047  1.00 40.80           O  
ATOM   1218  CB  GLU   179      -6.540  50.655 -12.636  1.00 40.11           C  
ATOM   1219  CG  GLU   179      -6.507  49.214 -13.179  1.00 43.47           C  
ATOM   1220  CD  GLU   179      -7.351  48.973 -14.415  1.00 46.41           C  
ATOM   1221  OE1 GLU   179      -7.880  49.960 -14.980  1.00 50.62           O  
ATOM   1222  OE2 GLU   179      -7.486  47.788 -14.810  1.00 46.82           O  
ATOM   1223  N   LEU   180      -4.510  49.194 -10.691  1.00 39.48           N  
ATOM   1224  CA  LEU   180      -3.811  48.025 -10.098  1.00 39.31           C  
ATOM   1225  C   LEU   180      -4.002  47.941  -8.583  1.00 39.44           C  
ATOM   1226  O   LEU   180      -4.246  46.872  -8.015  1.00 38.38           O  
ATOM   1227  CB  LEU   180      -2.304  48.141 -10.358  1.00 39.30           C  
ATOM   1228  CG  LEU   180      -1.441  47.036  -9.750  1.00 38.15           C  
ATOM   1229  CD1 LEU   180      -1.658  45.717 -10.486  1.00 33.34           C  
ATOM   1230  CD2 LEU   180       0.046  47.422  -9.780  1.00 40.22           C  
ATOM   1231  N   MET   181      -3.847  49.086  -7.932  1.00 38.84           N  
ATOM   1232  CA  MET   181      -3.893  49.139  -6.471  1.00 39.22           C  
ATOM   1233  C   MET   181      -5.316  48.856  -5.978  1.00 39.12           C  
ATOM   1234  O   MET   181      -5.490  48.219  -4.945  1.00 38.93           O  
ATOM   1235  CB  MET   181      -3.352  50.496  -5.973  1.00 39.28           C  
ATOM   1236  CG  MET   181      -1.848  50.761  -6.347  1.00 39.80           C  
ATOM   1237  SD  MET   181      -0.644  49.150  -6.207  0.80 50.03          SE  
ATOM   1238  CE  MET   181      -0.749  48.741  -4.304  1.00 43.54           C  
ATOM   1239  N   ALA   182      -6.324  49.314  -6.730  1.00 38.66           N  
ATOM   1240  CA  ALA   182      -7.714  48.950  -6.445  1.00 38.95           C  
ATOM   1241  C   ALA   182      -7.947  47.426  -6.575  1.00 39.20           C  
ATOM   1242  O   ALA   182      -8.852  46.885  -5.948  1.00 39.76           O  
ATOM   1243  CB  ALA   182      -8.685  49.737  -7.336  1.00 38.72           C  
ATOM   1244  N   ALA   183      -7.113  46.736  -7.337  1.00 39.12           N  
ATOM   1245  CA  ALA   183      -7.270  45.262  -7.542  1.00 39.14           C  
ATOM   1246  C   ALA   183      -6.224  44.408  -6.838  1.00 39.39           C  
ATOM   1247  O   ALA   183      -6.325  43.165  -6.826  1.00 38.95           O  
ATOM   1248  CB  ALA   183      -7.291  44.929  -9.019  1.00 38.99           C  
ATOM   1249  N   ALA   184      -5.240  45.051  -6.210  1.00 39.22           N  
ATOM   1250  CA  ALA   184      -4.066  44.328  -5.747  1.00 38.88           C  
ATOM   1251  C   ALA   184      -4.423  43.297  -4.675  1.00 40.07           C  
ATOM   1252  O   ALA   184      -3.806  42.227  -4.618  1.00 38.32           O  
ATOM   1253  CB  ALA   184      -3.035  45.275  -5.244  1.00 39.29           C  
ATOM   1254  N   GLU   185      -5.384  43.627  -3.809  1.00 40.14           N  
ATOM   1255  CA  GLU   185      -5.765  42.693  -2.732  1.00 42.11           C  
ATOM   1256  C   GLU   185      -6.500  41.436  -3.275  1.00 41.53           C  
ATOM   1257  O   GLU   185      -6.199  40.301  -2.894  1.00 39.45           O  
ATOM   1258  CB  GLU   185      -6.582  43.433  -1.678  1.00 43.22           C  
ATOM   1259  CG  GLU   185      -6.269  43.043  -0.223  1.00 50.16           C  
ATOM   1260  CD  GLU   185      -4.758  43.002   0.076  1.00 57.11           C  
ATOM   1261  OE1 GLU   185      -4.074  44.003  -0.245  1.00 60.08           O  
ATOM   1262  OE2 GLU   185      -4.260  41.967   0.605  1.00 60.58           O  
ATOM   1263  N   SER   186      -7.432  41.647  -4.199  1.00 41.32           N  
ATOM   1264  CA  SER   186      -8.175  40.535  -4.777  1.00 42.46           C  
ATOM   1265  C   SER   186      -7.328  39.745  -5.782  1.00 42.08           C  
ATOM   1266  O   SER   186      -7.512  38.536  -5.919  1.00 41.71           O  
ATOM   1267  CB  SER   186      -9.474  41.018  -5.415  1.00 42.62           C  
ATOM   1268  OG  SER   186      -9.174  41.911  -6.461  1.00 44.62           O  
ATOM   1269  N   GLU   187      -6.398  40.404  -6.467  1.00 41.08           N  
ATOM   1270  CA  GLU   187      -5.419  39.646  -7.263  1.00 40.35           C  
ATOM   1271  C   GLU   187      -4.514  38.748  -6.418  1.00 39.77           C  
ATOM   1272  O   GLU   187      -4.302  37.599  -6.783  1.00 38.95           O  
ATOM   1273  CB  GLU   187      -4.589  40.552  -8.164  1.00 41.17           C  
ATOM   1274  CG  GLU   187      -5.388  41.079  -9.337  1.00 42.00           C  
ATOM   1275  CD  GLU   187      -5.830  39.962 -10.258  1.00 47.88           C  
ATOM   1276  OE1 GLU   187      -5.005  39.505 -11.069  1.00 47.76           O  
ATOM   1277  OE2 GLU   187      -6.990  39.526 -10.166  1.00 47.91           O  
ATOM   1278  N   ALA   188      -4.021  39.248  -5.275  1.00 39.62           N  
ATOM   1279  CA  ALA   188      -3.208  38.428  -4.354  1.00 39.36           C  
ATOM   1280  C   ALA   188      -3.986  37.181  -3.925  1.00 39.81           C  
ATOM   1281  O   ALA   188      -3.456  36.069  -3.961  1.00 39.51           O  
ATOM   1282  CB  ALA   188      -2.779  39.257  -3.093  1.00 38.66           C  
ATOM   1283  N   THR   189      -5.235  37.384  -3.502  1.00 38.54           N  
ATOM   1284  CA  THR   189      -6.118  36.310  -3.087  1.00 39.26           C  
ATOM   1285  C   THR   189      -6.334  35.303  -4.210  1.00 39.11           C  
ATOM   1286  O   THR   189      -6.262  34.090  -3.988  1.00 37.88           O  
ATOM   1287  CB  THR   189      -7.494  36.855  -2.631  1.00 39.24           C  
ATOM   1288  OG1 THR   189      -7.288  37.830  -1.619  1.00 40.65           O  
ATOM   1289  CG2 THR   189      -8.378  35.765  -2.068  1.00 40.14           C  
ATOM   1290  N   ARG   190      -6.581  35.820  -5.393  1.00 39.23           N  
ATOM   1291  CA  ARG   190      -6.801  35.025  -6.570  1.00 40.56           C  
ATOM   1292  C   ARG   190      -5.633  34.123  -6.835  1.00 40.07           C  
ATOM   1293  O   ARG   190      -5.788  32.956  -6.975  1.00 40.14           O  
ATOM   1294  CB  ARG   190      -6.993  35.918  -7.779  1.00 41.29           C  
ATOM   1295  CG  ARG   190      -8.079  35.488  -8.702  1.00 44.05           C  
ATOM   1296  CD  ARG   190      -7.768  35.575 -10.156  1.00 46.79           C  
ATOM   1297  NE  ARG   190      -6.739  36.506 -10.516  1.00 51.37           N  
ATOM   1298  CZ  ARG   190      -5.737  36.223 -11.314  1.00 47.62           C  
ATOM   1299  NH1 ARG   190      -5.642  35.058 -11.853  1.00 49.34           N  
ATOM   1300  NH2 ARG   190      -4.843  37.121 -11.564  1.00 47.10           N  
ATOM   1301  N   LEU   191      -4.467  34.720  -6.926  1.00 38.98           N  
ATOM   1302  CA  LEU   191      -3.217  34.037  -7.202  1.00 38.93           C  
ATOM   1303  C   LEU   191      -2.794  33.073  -6.116  1.00 39.02           C  
ATOM   1304  O   LEU   191      -2.290  31.994  -6.440  1.00 38.62           O  
ATOM   1305  CB  LEU   191      -2.075  35.040  -7.476  1.00 39.93           C  
ATOM   1306  CG  LEU   191      -2.305  35.806  -8.793  1.00 40.44           C  
ATOM   1307  CD1 LEU   191      -1.294  36.936  -8.975  1.00 43.47           C  
ATOM   1308  CD2 LEU   191      -2.281  34.785  -9.946  1.00 44.54           C  
ATOM   1309  N   ASN   192      -2.993  33.452  -4.850  1.00 37.70           N  
ATOM   1310  CA  ASN   192      -2.697  32.567  -3.715  1.00 36.83           C  
ATOM   1311  C   ASN   192      -3.572  31.343  -3.723  1.00 37.14           C  
ATOM   1312  O   ASN   192      -3.220  30.335  -3.109  1.00 38.40           O  
ATOM   1313  CB  ASN   192      -2.803  33.285  -2.328  1.00 36.57           C  
ATOM   1314  CG  ASN   192      -1.633  34.215  -2.047  1.00 36.66           C  
ATOM   1315  OD1 ASN   192      -0.523  33.959  -2.494  1.00 38.01           O  
ATOM   1316  ND2 ASN   192      -1.882  35.340  -1.331  1.00 36.35           N  
ATOM   1317  N   ALA   193      -4.720  31.401  -4.391  1.00 37.30           N  
ATOM   1318  CA  ALA   193      -5.619  30.241  -4.494  1.00 36.33           C  
ATOM   1319  C   ALA   193      -5.196  29.261  -5.595  1.00 35.42           C  
ATOM   1320  O   ALA   193      -5.751  28.146  -5.717  1.00 34.15           O  
ATOM   1321  CB  ALA   193      -7.096  30.722  -4.711  1.00 37.39           C  
ATOM   1322  N   ILE   194      -4.213  29.656  -6.408  1.00 34.06           N  
ATOM   1323  CA  ILE   194      -3.711  28.735  -7.433  1.00 34.61           C  
ATOM   1324  C   ILE   194      -2.594  27.985  -6.706  1.00 33.90           C  
ATOM   1325  O   ILE   194      -1.568  28.560  -6.394  1.00 33.32           O  
ATOM   1326  CB  ILE   194      -3.222  29.454  -8.746  1.00 34.05           C  
ATOM   1327  CG1 ILE   194      -4.363  30.303  -9.345  1.00 35.03           C  
ATOM   1328  CG2 ILE   194      -2.699  28.418  -9.802  1.00 33.21           C  
ATOM   1329  CD1 ILE   194      -3.961  31.173 -10.615  1.00 33.84           C  
ATOM   1330  N   LYS   195      -2.847  26.728  -6.374  1.00 35.20           N  
ATOM   1331  CA  LYS   195      -1.876  25.930  -5.637  1.00 35.60           C  
ATOM   1332  C   LYS   195      -0.505  25.965  -6.346  1.00 36.08           C  
ATOM   1333  O   LYS   195      -0.411  25.714  -7.565  1.00 35.81           O  
ATOM   1334  CB  LYS   195      -2.387  24.514  -5.446  1.00 35.34           C  
ATOM   1335  CG  LYS   195      -1.460  23.600  -4.645  1.00 36.94           C  
ATOM   1336  CD  LYS   195      -2.201  22.407  -4.192  1.00 34.56           C  
ATOM   1337  CE  LYS   195      -1.351  21.448  -3.450  1.00 34.63           C  
ATOM   1338  NZ  LYS   195      -2.210  20.321  -3.050  1.00 30.40           N  
ATOM   1339  N   GLY   196       0.531  26.345  -5.599  1.00 36.12           N  
ATOM   1340  CA  GLY   196       1.898  26.289  -6.099  1.00 35.91           C  
ATOM   1341  C   GLY   196       2.305  27.551  -6.816  1.00 36.65           C  
ATOM   1342  O   GLY   196       3.507  27.740  -7.088  1.00 36.86           O  
ATOM   1343  N   GLU   197       1.344  28.426  -7.125  1.00 36.33           N  
ATOM   1344  CA  GLU   197       1.667  29.605  -7.943  1.00 37.55           C  
ATOM   1345  C   GLU   197       2.560  30.629  -7.204  1.00 38.59           C  
ATOM   1346  O   GLU   197       3.497  31.163  -7.798  1.00 38.33           O  
ATOM   1347  CB  GLU   197       0.419  30.300  -8.468  1.00 37.82           C  
ATOM   1348  CG  GLU   197       0.668  31.114  -9.722  1.00 43.40           C  
ATOM   1349  CD  GLU   197       0.559  30.264 -11.018  1.00 49.01           C  
ATOM   1350  OE1 GLU   197      -0.187  30.686 -11.921  1.00 51.75           O  
ATOM   1351  OE2 GLU   197       1.177  29.164 -11.156  1.00 52.34           O  
ATOM   1352  N   ALA   198       2.291  30.892  -5.920  1.00 38.82           N  
ATOM   1353  CA  ALA   198       3.132  31.857  -5.162  1.00 39.20           C  
ATOM   1354  C   ALA   198       4.581  31.318  -5.068  1.00 40.28           C  
ATOM   1355  O   ALA   198       5.559  32.067  -5.197  1.00 39.92           O  
ATOM   1356  CB  ALA   198       2.568  32.073  -3.828  1.00 39.55           C  
ATOM   1357  N   SER   199       4.705  30.011  -4.877  1.00 39.80           N  
ATOM   1358  CA  SER   199       6.017  29.356  -4.808  1.00 41.18           C  
ATOM   1359  C   SER   199       6.752  29.410  -6.164  1.00 40.92           C  
ATOM   1360  O   SER   199       7.961  29.702  -6.200  1.00 41.81           O  
ATOM   1361  CB  SER   199       5.854  27.933  -4.303  1.00 40.29           C  
ATOM   1362  OG  SER   199       7.118  27.325  -4.118  1.00 44.86           O  
ATOM   1363  N   ARG   200       6.030  29.226  -7.276  1.00 40.52           N  
ATOM   1364  CA  ARG   200       6.615  29.459  -8.615  1.00 40.24           C  
ATOM   1365  C   ARG   200       7.175  30.877  -8.784  1.00 39.77           C  
ATOM   1366  O   ARG   200       8.250  31.065  -9.381  1.00 39.36           O  
ATOM   1367  CB  ARG   200       5.632  29.137  -9.745  1.00 40.01           C  
ATOM   1368  CG  ARG   200       5.495  27.640  -9.987  1.00 41.00           C  
ATOM   1369  CD  ARG   200       4.264  27.239 -10.825  1.00 42.99           C  
ATOM   1370  NE  ARG   200       4.142  28.008 -12.068  1.00 49.55           N  
ATOM   1371  CZ  ARG   200       3.651  27.538 -13.224  1.00 52.36           C  
ATOM   1372  NH1 ARG   200       3.581  28.348 -14.283  1.00 52.08           N  
ATOM   1373  NH2 ARG   200       3.251  26.265 -13.339  1.00 51.69           N  
ATOM   1374  N   LEU   201       6.440  31.860  -8.295  1.00 37.63           N  
ATOM   1375  CA  LEU   201       6.869  33.279  -8.351  1.00 39.30           C  
ATOM   1376  C   LEU   201       8.065  33.524  -7.449  1.00 39.33           C  
ATOM   1377  O   LEU   201       8.985  34.253  -7.837  1.00 38.96           O  
ATOM   1378  CB  LEU   201       5.730  34.241  -7.952  1.00 37.79           C  
ATOM   1379  CG  LEU   201       4.440  34.162  -8.770  1.00 40.78           C  
ATOM   1380  CD1 LEU   201       3.361  35.029  -8.131  1.00 38.26           C  
ATOM   1381  CD2 LEU   201       4.702  34.616 -10.232  1.00 39.91           C  
ATOM   1382  N   ALA   202       8.062  32.902  -6.263  1.00 39.34           N  
ATOM   1383  CA  ALA   202       9.182  33.054  -5.347  1.00 40.13           C  
ATOM   1384  C   ALA   202      10.467  32.448  -5.938  1.00 41.27           C  
ATOM   1385  O   ALA   202      11.551  33.034  -5.818  1.00 41.45           O  
ATOM   1386  CB  ALA   202       8.861  32.465  -4.019  1.00 39.97           C  
ATOM   1387  N   VAL   203      10.339  31.298  -6.600  1.00 41.74           N  
ATOM   1388  CA  VAL   203      11.497  30.685  -7.267  1.00 42.08           C  
ATOM   1389  C   VAL   203      12.026  31.580  -8.399  1.00 41.70           C  
ATOM   1390  O   VAL   203      13.220  31.783  -8.475  1.00 41.07           O  
ATOM   1391  CB  VAL   203      11.276  29.184  -7.667  1.00 42.31           C  
ATOM   1392  CG1 VAL   203      10.766  28.360  -6.474  1.00 41.59           C  
ATOM   1393  CG2 VAL   203      10.334  29.057  -8.821  1.00 44.04           C  
ATOM   1394  N   LEU   204      11.135  32.148  -9.229  1.00 42.28           N  
ATOM   1395  CA  LEU   204      11.501  33.205 -10.217  1.00 42.77           C  
ATOM   1396  C   LEU   204      12.250  34.379  -9.590  1.00 42.88           C  
ATOM   1397  O   LEU   204      13.131  34.975 -10.208  1.00 42.99           O  
ATOM   1398  CB  LEU   204      10.258  33.789 -10.906  1.00 43.24           C  
ATOM   1399  CG  LEU   204       9.650  33.355 -12.246  1.00 46.48           C  
ATOM   1400  CD1 LEU   204       8.426  32.557 -12.066  1.00 47.32           C  
ATOM   1401  CD2 LEU   204       9.289  34.637 -13.021  1.00 48.31           C  
ATOM   1402  N   ALA   205      11.845  34.737  -8.373  1.00 41.99           N  
ATOM   1403  CA  ALA   205      12.465  35.806  -7.612  1.00 42.75           C  
ATOM   1404  C   ALA   205      13.871  35.462  -7.077  1.00 42.85           C  
ATOM   1405  O   ALA   205      14.571  36.350  -6.561  1.00 44.20           O  
ATOM   1406  CB  ALA   205      11.544  36.181  -6.480  1.00 41.31           C  
ATOM   1407  N   GLY   206      14.252  34.186  -7.176  1.00 42.19           N  
ATOM   1408  CA  GLY   206      15.535  33.667  -6.718  1.00 42.09           C  
ATOM   1409  C   GLY   206      15.461  32.901  -5.405  1.00 42.11           C  
ATOM   1410  O   GLY   206      16.487  32.569  -4.842  1.00 41.96           O  
ATOM   1411  N   ALA   207      14.258  32.640  -4.900  1.00 42.14           N  
ATOM   1412  CA  ALA   207      14.086  31.971  -3.599  1.00 43.13           C  
ATOM   1413  C   ALA   207      13.941  30.435  -3.687  1.00 44.04           C  
ATOM   1414  O   ALA   207      13.926  29.858  -4.771  1.00 43.67           O  
ATOM   1415  CB  ALA   207      12.901  32.560  -2.844  1.00 43.20           C  
ATOM   1416  N   LYS   208      13.858  29.784  -2.528  1.00 45.85           N  
ATOM   1417  CA  LYS   208      13.705  28.329  -2.474  1.00 47.85           C  
ATOM   1418  C   LYS   208      12.243  27.932  -2.333  1.00 48.78           C  
ATOM   1419  O   LYS   208      11.493  28.568  -1.602  1.00 48.17           O  
ATOM   1420  CB  LYS   208      14.510  27.734  -1.313  1.00 48.57           C  
ATOM   1421  CG  LYS   208      15.886  27.145  -1.690  1.00 50.53           C  
ATOM   1422  CD  LYS   208      17.062  28.075  -1.389  1.00 55.23           C  
ATOM   1423  CE  LYS   208      17.400  28.165   0.123  1.00 57.03           C  
ATOM   1424  NZ  LYS   208      16.408  29.004   0.917  1.00 54.74           N  
ATOM   1425  N   THR   209      11.856  26.854  -3.017  1.00 50.43           N  
ATOM   1426  CA  THR   209      10.494  26.310  -2.927  1.00 51.48           C  
ATOM   1427  C   THR   209      10.035  26.159  -1.464  1.00 51.51           C  
ATOM   1428  O   THR   209      10.851  26.107  -0.522  1.00 51.65           O  
ATOM   1429  CB  THR   209      10.333  24.991  -3.735  1.00 52.21           C  
ATOM   1430  OG1 THR   209       8.940  24.634  -3.819  1.00 53.28           O  
ATOM   1431  CG2 THR   209      11.159  23.850  -3.116  1.00 52.02           C  
ATOM   1432  N   GLY   210       8.723  26.145  -1.276  1.00 50.99           N  
ATOM   1433  CA  GLY   210       8.183  26.203   0.072  1.00 50.54           C  
ATOM   1434  C   GLY   210       6.723  26.562   0.048  1.00 49.29           C  
ATOM   1435  O   GLY   210       6.091  26.552  -1.014  1.00 48.86           O  
ATOM   1436  N   ARG   211       6.181  26.857   1.225  1.00 48.70           N  
ATOM   1437  CA  ARG   211       4.782  27.252   1.299  1.00 48.23           C  
ATOM   1438  C   ARG   211       4.771  28.768   1.288  1.00 45.98           C  
ATOM   1439  O   ARG   211       4.824  29.430   2.335  1.00 47.07           O  
ATOM   1440  CB  ARG   211       4.040  26.622   2.493  1.00 48.33           C  
ATOM   1441  CG  ARG   211       4.079  25.034   2.560  1.00 52.97           C  
ATOM   1442  CD  ARG   211       4.151  24.292   1.176  1.00 61.21           C  
ATOM   1443  NE  ARG   211       2.925  24.332   0.342  1.00 66.10           N  
ATOM   1444  CZ  ARG   211       2.842  24.786  -0.919  1.00 69.04           C  
ATOM   1445  NH1 ARG   211       3.911  25.278  -1.544  1.00 70.03           N  
ATOM   1446  NH2 ARG   211       1.671  24.742  -1.576  1.00 70.00           N  
ATOM   1447  N   TRP   212       4.775  29.298   0.067  1.00 43.67           N  
ATOM   1448  CA  TRP   212       4.775  30.749  -0.205  1.00 41.76           C  
ATOM   1449  C   TRP   212       3.382  31.352  -0.350  1.00 40.77           C  
ATOM   1450  O   TRP   212       2.448  30.677  -0.800  1.00 40.44           O  
ATOM   1451  CB  TRP   212       5.553  31.004  -1.494  1.00 41.37           C  
ATOM   1452  CG  TRP   212       7.006  30.766  -1.310  1.00 39.46           C  
ATOM   1453  CD1 TRP   212       7.678  29.606  -1.529  1.00 38.11           C  
ATOM   1454  CD2 TRP   212       7.962  31.698  -0.787  1.00 39.28           C  
ATOM   1455  NE1 TRP   212       9.008  29.772  -1.236  1.00 37.62           N  
ATOM   1456  CE2 TRP   212       9.212  31.037  -0.758  1.00 40.47           C  
ATOM   1457  CE3 TRP   212       7.893  33.032  -0.374  1.00 36.46           C  
ATOM   1458  CZ2 TRP   212      10.390  31.671  -0.314  1.00 39.98           C  
ATOM   1459  CZ3 TRP   212       9.054  33.663   0.048  1.00 38.84           C  
ATOM   1460  CH2 TRP   212      10.290  32.983   0.070  1.00 39.28           C  
ATOM   1461  N   LYS   213       3.249  32.622   0.017  1.00 40.58           N  
ATOM   1462  CA  LYS   213       2.059  33.422  -0.275  1.00 40.25           C  
ATOM   1463  C   LYS   213       2.484  34.787  -0.791  1.00 39.48           C  
ATOM   1464  O   LYS   213       3.498  35.318  -0.343  1.00 39.04           O  
ATOM   1465  CB  LYS   213       1.194  33.602   0.979  1.00 40.47           C  
ATOM   1466  CG  LYS   213       0.446  32.298   1.467  1.00 43.77           C  
ATOM   1467  CD  LYS   213      -0.666  31.854   0.470  1.00 48.68           C  
ATOM   1468  CE  LYS   213      -1.257  30.458   0.783  1.00 45.97           C  
ATOM   1469  NZ  LYS   213      -2.195  29.896  -0.272  1.00 44.84           N  
ATOM   1470  N   ILE   214       1.723  35.334  -1.746  1.00 38.84           N  
ATOM   1471  CA  ILE   214       1.833  36.736  -2.134  1.00 38.25           C  
ATOM   1472  C   ILE   214       1.308  37.565  -1.016  1.00 39.46           C  
ATOM   1473  O   ILE   214       0.191  37.315  -0.538  1.00 39.34           O  
ATOM   1474  CB  ILE   214       1.020  37.045  -3.356  1.00 38.32           C  
ATOM   1475  CG1 ILE   214       1.577  36.244  -4.537  1.00 41.05           C  
ATOM   1476  CG2 ILE   214       0.995  38.591  -3.651  1.00 36.16           C  
ATOM   1477  CD1 ILE   214       0.735  36.298  -5.751  1.00 42.99           C  
ATOM   1478  N   THR   215       2.118  38.522  -0.572  1.00 40.09           N  
ATOM   1479  CA  THR   215       1.717  39.429   0.495  1.00 39.19           C  
ATOM   1480  C   THR   215       1.306  40.776  -0.058  1.00 40.01           C  
ATOM   1481  O   THR   215       0.474  41.460   0.565  1.00 40.47           O  
ATOM   1482  CB  THR   215       2.810  39.584   1.605  1.00 38.67           C  
ATOM   1483  OG1 THR   215       4.030  40.065   1.019  1.00 36.42           O  
ATOM   1484  CG2 THR   215       3.081  38.205   2.256  1.00 39.25           C  
ATOM   1485  N   SER   216       1.859  41.163  -1.219  1.00 40.46           N  
ATOM   1486  CA  SER   216       1.661  42.478  -1.733  1.00 40.62           C  
ATOM   1487  C   SER   216       2.031  42.554  -3.192  1.00 41.47           C  
ATOM   1488  O   SER   216       3.074  42.032  -3.593  1.00 41.94           O  
ATOM   1489  CB  SER   216       2.497  43.491  -0.907  1.00 39.86           C  
ATOM   1490  OG  SER   216       2.128  44.823  -1.153  1.00 41.34           O  
ATOM   1491  N   ILE   217       1.172  43.215  -3.992  1.00 41.47           N  
ATOM   1492  CA  ILE   217       1.457  43.510  -5.417  1.00 40.32           C  
ATOM   1493  C   ILE   217       1.534  45.018  -5.557  1.00 40.31           C  
ATOM   1494  O   ILE   217       0.694  45.723  -5.002  1.00 39.84           O  
ATOM   1495  CB  ILE   217       0.343  42.980  -6.348  1.00 40.39           C  
ATOM   1496  CG1 ILE   217       0.187  41.443  -6.165  1.00 39.41           C  
ATOM   1497  CG2 ILE   217       0.598  43.426  -7.811  1.00 39.89           C  
ATOM   1498  CD1 ILE   217      -1.090  40.855  -6.724  1.00 41.51           C  
ATOM   1499  N   ASP   218       2.548  45.504  -6.273  1.00 39.30           N  
ATOM   1500  CA  ASP   218       2.705  46.956  -6.484  1.00 38.73           C  
ATOM   1501  C   ASP   218       3.151  47.210  -7.933  1.00 37.93           C  
ATOM   1502  O   ASP   218       3.416  46.255  -8.685  1.00 37.25           O  
ATOM   1503  CB  ASP   218       3.623  47.588  -5.385  1.00 37.51           C  
ATOM   1504  CG  ASP   218       5.058  47.024  -5.398  1.00 40.93           C  
ATOM   1505  OD1 ASP   218       5.778  47.238  -6.414  1.00 42.23           O  
ATOM   1506  OD2 ASP   218       5.485  46.367  -4.407  1.00 40.91           O  
ATOM   1507  N   PRO   219       3.198  48.476  -8.359  1.00 37.21           N  
ATOM   1508  CA  PRO   219       3.591  48.663  -9.760  1.00 37.75           C  
ATOM   1509  C   PRO   219       4.951  48.083 -10.199  1.00 37.92           C  
ATOM   1510  O   PRO   219       5.164  47.847 -11.405  1.00 38.51           O  
ATOM   1511  CB  PRO   219       3.597  50.203  -9.907  1.00 38.18           C  
ATOM   1512  CG  PRO   219       2.574  50.651  -8.926  1.00 36.94           C  
ATOM   1513  CD  PRO   219       2.808  49.758  -7.722  1.00 36.21           C  
ATOM   1514  N   ASP   220       5.859  47.883  -9.259  1.00 37.98           N  
ATOM   1515  CA  ASP   220       7.228  47.454  -9.589  1.00 39.01           C  
ATOM   1516  C   ASP   220       7.467  45.947  -9.367  1.00 38.51           C  
ATOM   1517  O   ASP   220       8.460  45.362  -9.868  1.00 37.46           O  
ATOM   1518  CB  ASP   220       8.245  48.271  -8.767  1.00 38.35           C  
ATOM   1519  CG  ASP   220       8.330  49.724  -9.217  1.00 39.07           C  
ATOM   1520  OD1 ASP   220       7.923  50.038 -10.360  1.00 39.95           O  
ATOM   1521  OD2 ASP   220       8.803  50.553  -8.411  1.00 42.67           O  
ATOM   1522  N   GLY   221       6.533  45.310  -8.679  1.00 37.64           N  
ATOM   1523  CA  GLY   221       6.634  43.860  -8.472  1.00 38.70           C  
ATOM   1524  C   GLY   221       5.776  43.311  -7.351  1.00 39.35           C  
ATOM   1525  O   GLY   221       4.787  43.925  -6.960  1.00 39.63           O  
ATOM   1526  N   ILE   222       6.190  42.163  -6.812  1.00 39.81           N  
ATOM   1527  CA  ILE   222       5.341  41.364  -5.958  1.00 40.03           C  
ATOM   1528  C   ILE   222       6.174  40.894  -4.775  1.00 40.65           C  
ATOM   1529  O   ILE   222       7.272  40.320  -4.965  1.00 41.65           O  
ATOM   1530  CB  ILE   222       4.790  40.075  -6.716  1.00 39.93           C  
ATOM   1531  CG1 ILE   222       4.009  40.441  -7.999  1.00 38.13           C  
ATOM   1532  CG2 ILE   222       3.929  39.192  -5.700  1.00 38.68           C  
ATOM   1533  CD1 ILE   222       3.752  39.227  -8.997  1.00 40.00           C  
ATOM   1534  N   ASP   223       5.645  41.080  -3.567  1.00 39.32           N  
ATOM   1535  CA  ASP   223       6.358  40.638  -2.403  1.00 39.52           C  
ATOM   1536  C   ASP   223       5.741  39.337  -2.046  1.00 38.95           C  
ATOM   1537  O   ASP   223       4.511  39.211  -2.116  1.00 38.85           O  
ATOM   1538  CB  ASP   223       6.196  41.623  -1.251  1.00 39.17           C  
ATOM   1539  CG  ASP   223       7.141  42.848  -1.375  1.00 42.76           C  
ATOM   1540  OD1 ASP   223       8.022  42.907  -2.249  1.00 47.48           O  
ATOM   1541  OD2 ASP   223       6.998  43.742  -0.557  1.00 44.98           O  
ATOM   1542  N   LEU   224       6.580  38.377  -1.633  1.00 39.80           N  
ATOM   1543  CA  LEU   224       6.111  37.053  -1.146  1.00 38.74           C  
ATOM   1544  C   LEU   224       6.722  36.680   0.186  1.00 39.35           C  
ATOM   1545  O   LEU   224       7.821  37.137   0.512  1.00 38.40           O  
ATOM   1546  CB  LEU   224       6.378  35.942  -2.182  1.00 39.02           C  
ATOM   1547  CG  LEU   224       5.897  36.304  -3.590  1.00 37.93           C  
ATOM   1548  CD1 LEU   224       7.068  36.608  -4.460  1.00 39.11           C  
ATOM   1549  CD2 LEU   224       5.071  35.150  -4.101  1.00 40.89           C  
ATOM   1550  N   ALA   225       5.995  35.870   0.966  1.00 37.56           N  
ATOM   1551  CA  ALA   225       6.510  35.322   2.200  1.00 38.71           C  
ATOM   1552  C   ALA   225       6.232  33.820   2.347  1.00 40.11           C  
ATOM   1553  O   ALA   225       5.213  33.284   1.854  1.00 39.61           O  
ATOM   1554  CB  ALA   225       5.984  36.121   3.449  1.00 38.10           C  
ATOM   1555  N   SER   226       7.187  33.150   2.992  1.00 41.63           N  
ATOM   1556  CA  SER   226       7.013  31.793   3.510  1.00 41.51           C  
ATOM   1557  C   SER   226       7.324  31.904   4.982  1.00 42.46           C  
ATOM   1558  O   SER   226       7.537  33.010   5.479  1.00 43.34           O  
ATOM   1559  CB  SER   226       7.970  30.828   2.842  1.00 41.83           C  
ATOM   1560  OG  SER   226       9.300  31.081   3.257  1.00 42.39           O  
ATOM   1561  N   ALA   227       7.342  30.774   5.689  1.00 42.16           N  
ATOM   1562  CA  ALA   227       7.669  30.767   7.106  1.00 42.59           C  
ATOM   1563  C   ALA   227       9.110  31.220   7.433  1.00 42.71           C  
ATOM   1564  O   ALA   227       9.305  32.007   8.356  1.00 42.36           O  
ATOM   1565  CB  ALA   227       7.402  29.404   7.699  1.00 43.21           C  
ATOM   1566  N   SER   228      10.105  30.715   6.694  1.00 42.72           N  
ATOM   1567  CA  SER   228      11.510  31.070   6.946  1.00 42.93           C  
ATOM   1568  C   SER   228      12.085  32.193   6.075  1.00 42.11           C  
ATOM   1569  O   SER   228      13.103  32.779   6.454  1.00 42.02           O  
ATOM   1570  CB  SER   228      12.418  29.834   6.879  1.00 43.93           C  
ATOM   1571  OG  SER   228      12.426  29.254   5.581  1.00 46.22           O  
ATOM   1572  N   ASP   229      11.432  32.518   4.949  1.00 41.72           N  
ATOM   1573  CA  ASP   229      11.994  33.464   3.977  1.00 39.90           C  
ATOM   1574  C   ASP   229      11.038  34.518   3.395  1.00 38.59           C  
ATOM   1575  O   ASP   229       9.824  34.418   3.499  1.00 37.75           O  
ATOM   1576  CB  ASP   229      12.660  32.689   2.838  1.00 40.44           C  
ATOM   1577  CG  ASP   229      13.926  33.373   2.310  1.00 44.68           C  
ATOM   1578  OD1 ASP   229      14.608  32.727   1.477  1.00 49.71           O  
ATOM   1579  OD2 ASP   229      14.260  34.531   2.722  1.00 43.59           O  
ATOM   1580  N   LEU   230      11.617  35.547   2.781  1.00 36.54           N  
ATOM   1581  CA  LEU   230      10.867  36.577   2.051  1.00 36.28           C  
ATOM   1582  C   LEU   230      11.476  36.665   0.654  1.00 36.24           C  
ATOM   1583  O   LEU   230      12.709  36.487   0.502  1.00 36.39           O  
ATOM   1584  CB  LEU   230      10.960  37.968   2.743  1.00 34.87           C  
ATOM   1585  CG  LEU   230      10.459  38.126   4.187  1.00 34.46           C  
ATOM   1586  CD1 LEU   230      10.799  39.517   4.729  1.00 32.33           C  
ATOM   1587  CD2 LEU   230       8.953  37.824   4.324  1.00 35.09           C  
ATOM   1588  N   ALA   231      10.630  36.971  -0.330  1.00 36.69           N  
ATOM   1589  CA  ALA   231      11.059  37.169  -1.718  1.00 37.63           C  
ATOM   1590  C   ALA   231      10.385  38.400  -2.322  1.00 37.88           C  
ATOM   1591  O   ALA   231       9.292  38.845  -1.850  1.00 36.74           O  
ATOM   1592  CB  ALA   231      10.745  35.917  -2.578  1.00 38.16           C  
ATOM   1593  N   ARG   232      11.063  38.987  -3.312  1.00 37.21           N  
ATOM   1594  CA  ARG   232      10.468  40.025  -4.146  1.00 37.53           C  
ATOM   1595  C   ARG   232      10.745  39.728  -5.616  1.00 37.39           C  
ATOM   1596  O   ARG   232      11.906  39.647  -6.036  1.00 38.13           O  
ATOM   1597  CB  ARG   232      10.957  41.450  -3.789  1.00 38.48           C  
ATOM   1598  CG  ARG   232      10.221  42.472  -4.667  1.00 41.60           C  
ATOM   1599  CD  ARG   232      10.480  43.857  -4.294  1.00 44.96           C  
ATOM   1600  NE  ARG   232       9.842  44.856  -5.158  1.00 45.46           N  
ATOM   1601  CZ  ARG   232       8.545  45.201  -5.198  1.00 44.81           C  
ATOM   1602  NH1 ARG   232       7.613  44.591  -4.445  1.00 40.67           N  
ATOM   1603  NH2 ARG   232       8.185  46.204  -6.021  1.00 40.08           N  
ATOM   1604  N   LEU   233       9.680  39.585  -6.392  1.00 37.74           N  
ATOM   1605  CA  LEU   233       9.800  39.394  -7.866  1.00 37.36           C  
ATOM   1606  C   LEU   233       9.638  40.752  -8.532  1.00 38.69           C  
ATOM   1607  O   LEU   233       8.593  41.362  -8.387  1.00 39.15           O  
ATOM   1608  CB  LEU   233       8.739  38.415  -8.393  1.00 38.10           C  
ATOM   1609  CG  LEU   233       8.736  38.007  -9.900  1.00 37.23           C  
ATOM   1610  CD1 LEU   233      10.041  37.435 -10.324  1.00 36.14           C  
ATOM   1611  CD2 LEU   233       7.602  36.987 -10.196  1.00 36.27           C  
ATOM   1612  N   TRP   234      10.659  41.219  -9.269  1.00 38.24           N  
ATOM   1613  CA  TRP   234      10.559  42.485  -9.974  1.00 39.13           C  
ATOM   1614  C   TRP   234       9.999  42.342 -11.361  1.00 39.09           C  
ATOM   1615  O   TRP   234      10.421  41.458 -12.124  1.00 40.17           O  
ATOM   1616  CB  TRP   234      11.916  43.181 -10.045  1.00 39.39           C  
ATOM   1617  CG  TRP   234      12.446  43.508  -8.659  1.00 39.51           C  
ATOM   1618  CD1 TRP   234      13.161  42.667  -7.823  1.00 40.36           C  
ATOM   1619  CD2 TRP   234      12.292  44.740  -7.949  1.00 40.13           C  
ATOM   1620  NE1 TRP   234      13.498  43.317  -6.657  1.00 35.87           N  
ATOM   1621  CE2 TRP   234      12.967  44.585  -6.692  1.00 41.06           C  
ATOM   1622  CE3 TRP   234      11.668  45.966  -8.244  1.00 39.24           C  
ATOM   1623  CZ2 TRP   234      13.023  45.616  -5.731  1.00 42.27           C  
ATOM   1624  CZ3 TRP   234      11.732  47.019  -7.270  1.00 42.22           C  
ATOM   1625  CH2 TRP   234      12.398  46.825  -6.044  1.00 40.34           C  
ATOM   1626  N   PHE   235       9.043  43.203 -11.706  1.00 38.84           N  
ATOM   1627  CA  PHE   235       8.515  43.208 -13.084  1.00 38.96           C  
ATOM   1628  C   PHE   235       9.582  43.700 -14.033  1.00 38.59           C  
ATOM   1629  O   PHE   235      10.443  44.516 -13.632  1.00 38.93           O  
ATOM   1630  CB  PHE   235       7.276  44.094 -13.183  1.00 38.97           C  
ATOM   1631  CG  PHE   235       6.112  43.615 -12.341  1.00 40.90           C  
ATOM   1632  CD1 PHE   235       5.797  42.235 -12.271  1.00 40.09           C  
ATOM   1633  CD2 PHE   235       5.322  44.534 -11.636  1.00 39.05           C  
ATOM   1634  CE1 PHE   235       4.745  41.781 -11.549  1.00 39.69           C  
ATOM   1635  CE2 PHE   235       4.223  44.079 -10.871  1.00 37.48           C  
ATOM   1636  CZ  PHE   235       3.940  42.720 -10.819  1.00 40.48           C  
ATOM   1637  N   ALA   236       9.543  43.231 -15.280  1.00 38.45           N  
ATOM   1638  CA  ALA   236      10.436  43.786 -16.290  1.00 37.70           C  
ATOM   1639  C   ALA   236      10.100  45.249 -16.627  1.00 37.64           C  
ATOM   1640  O   ALA   236      10.982  46.013 -16.965  1.00 37.01           O  
ATOM   1641  CB  ALA   236      10.483  42.913 -17.582  1.00 38.00           C  
ATOM   1642  N   GLU   237       8.824  45.611 -16.580  1.00 37.50           N  
ATOM   1643  CA  GLU   237       8.438  47.005 -16.714  1.00 38.69           C  
ATOM   1644  C   GLU   237       7.311  47.345 -15.745  1.00 38.00           C  
ATOM   1645  O   GLU   237       6.660  46.443 -15.220  1.00 38.35           O  
ATOM   1646  CB  GLU   237       8.133  47.404 -18.174  1.00 38.07           C  
ATOM   1647  CG  GLU   237       7.000  46.656 -18.820  1.00 38.95           C  
ATOM   1648  CD  GLU   237       6.900  46.949 -20.306  1.00 40.50           C  
ATOM   1649  OE1 GLU   237       6.063  46.300 -20.980  1.00 44.17           O  
ATOM   1650  OE2 GLU   237       7.648  47.820 -20.803  1.00 39.99           O  
ATOM   1651  N   ARG   238       7.144  48.649 -15.473  1.00 38.50           N  
ATOM   1652  CA  ARG   238       6.249  49.148 -14.421  1.00 38.23           C  
ATOM   1653  C   ARG   238       4.837  48.801 -14.832  1.00 38.36           C  
ATOM   1654  O   ARG   238       4.489  48.922 -15.997  1.00 36.49           O  
ATOM   1655  CB  ARG   238       6.398  50.684 -14.283  1.00 39.03           C  
ATOM   1656  CG  ARG   238       5.456  51.361 -13.290  1.00 38.45           C  
ATOM   1657  CD  ARG   238       5.582  52.918 -13.308  1.00 40.35           C  
ATOM   1658  NE  ARG   238       4.427  53.521 -12.639  1.00 40.39           N  
ATOM   1659  CZ  ARG   238       4.292  53.621 -11.319  1.00 38.31           C  
ATOM   1660  NH1 ARG   238       5.236  53.158 -10.511  1.00 40.01           N  
ATOM   1661  NH2 ARG   238       3.199  54.153 -10.810  1.00 35.26           N  
ATOM   1662  N   VAL   239       4.014  48.410 -13.876  1.00 39.17           N  
ATOM   1663  CA  VAL   239       2.653  47.913 -14.163  1.00 40.40           C  
ATOM   1664  C   VAL   239       1.617  48.878 -13.543  1.00 40.56           C  
ATOM   1665  O   VAL   239       1.759  49.304 -12.403  1.00 38.13           O  
ATOM   1666  CB  VAL   239       2.495  46.455 -13.636  1.00 40.92           C  
ATOM   1667  CG1 VAL   239       1.032  46.075 -13.500  1.00 41.13           C  
ATOM   1668  CG2 VAL   239       3.219  45.489 -14.602  1.00 41.64           C  
ATOM   1669  N   GLU   240       0.599  49.262 -14.314  1.00 39.99           N  
ATOM   1670  CA  GLU   240      -0.309  50.325 -13.830  1.00 40.55           C  
ATOM   1671  C   GLU   240      -1.774  49.914 -13.806  1.00 40.06           C  
ATOM   1672  O   GLU   240      -2.584  50.452 -13.040  1.00 38.77           O  
ATOM   1673  CB  GLU   240      -0.098  51.614 -14.631  1.00 41.11           C  
ATOM   1674  CG  GLU   240       1.092  52.415 -14.105  1.00 40.98           C  
ATOM   1675  CD  GLU   240       1.240  53.750 -14.788  1.00 42.99           C  
ATOM   1676  OE1 GLU   240       0.678  53.947 -15.907  1.00 43.11           O  
ATOM   1677  OE2 GLU   240       1.937  54.609 -14.198  1.00 45.89           O  
ATOM   1678  N   THR   241      -2.069  48.888 -14.592  1.00 40.56           N  
ATOM   1679  CA  THR   241      -3.427  48.407 -14.767  1.00 40.97           C  
ATOM   1680  C   THR   241      -3.498  46.920 -14.591  1.00 41.14           C  
ATOM   1681  O   THR   241      -2.471  46.206 -14.586  1.00 40.51           O  
ATOM   1682  CB  THR   241      -3.978  48.755 -16.176  1.00 41.31           C  
ATOM   1683  OG1 THR   241      -3.235  48.037 -17.173  1.00 41.19           O  
ATOM   1684  CG2 THR   241      -3.896  50.254 -16.443  1.00 40.83           C  
ATOM   1685  N   LEU   242      -4.724  46.430 -14.464  1.00 41.44           N  
ATOM   1686  CA  LEU   242      -4.923  44.999 -14.321  1.00 41.37           C  
ATOM   1687  C   LEU   242      -4.507  44.277 -15.604  1.00 40.45           C  
ATOM   1688  O   LEU   242      -3.842  43.239 -15.543  1.00 39.76           O  
ATOM   1689  CB  LEU   242      -6.383  44.686 -13.982  1.00 42.24           C  
ATOM   1690  CG  LEU   242      -6.693  43.207 -13.740  1.00 43.34           C  
ATOM   1691  CD1 LEU   242      -6.140  42.777 -12.389  1.00 47.07           C  
ATOM   1692  CD2 LEU   242      -8.186  43.008 -13.766  1.00 45.50           C  
ATOM   1693  N   LYS   243      -4.917  44.817 -16.755  1.00 39.92           N  
ATOM   1694  CA  LYS   243      -4.502  44.262 -18.042  1.00 39.83           C  
ATOM   1695  C   LYS   243      -2.986  44.123 -18.089  1.00 39.07           C  
ATOM   1696  O   LYS   243      -2.484  43.076 -18.483  1.00 38.24           O  
ATOM   1697  CB  LYS   243      -4.976  45.110 -19.240  1.00 40.23           C  
ATOM   1698  CG  LYS   243      -4.818  44.352 -20.557  1.00 43.46           C  
ATOM   1699  CD  LYS   243      -5.697  44.891 -21.694  1.00 46.25           C  
ATOM   1700  CE  LYS   243      -6.112  43.753 -22.612  1.00 49.30           C  
ATOM   1701  NZ  LYS   243      -6.790  42.665 -21.842  1.00 50.82           N  
ATOM   1702  N   GLN   244      -2.270  45.172 -17.665  1.00 38.67           N  
ATOM   1703  CA  GLN   244      -0.815  45.166 -17.687  1.00 38.68           C  
ATOM   1704  C   GLN   244      -0.265  44.151 -16.698  1.00 39.31           C  
ATOM   1705  O   GLN   244       0.726  43.487 -16.981  1.00 39.04           O  
ATOM   1706  CB  GLN   244      -0.226  46.558 -17.442  1.00 37.90           C  
ATOM   1707  CG  GLN   244      -0.509  47.574 -18.567  1.00 37.97           C  
ATOM   1708  CD  GLN   244      -0.042  48.971 -18.208  1.00 38.18           C  
ATOM   1709  OE1 GLN   244       0.280  49.264 -17.055  1.00 37.40           O  
ATOM   1710  NE2 GLN   244      -0.004  49.850 -19.201  1.00 38.82           N  
ATOM   1711  N   PHE   245      -0.904  44.014 -15.532  1.00 40.67           N  
ATOM   1712  CA  PHE   245      -0.460  43.012 -14.562  1.00 41.10           C  
ATOM   1713  C   PHE   245      -0.560  41.581 -15.123  1.00 41.63           C  
ATOM   1714  O   PHE   245       0.404  40.810 -15.086  1.00 40.20           O  
ATOM   1715  CB  PHE   245      -1.295  43.096 -13.303  1.00 40.94           C  
ATOM   1716  CG  PHE   245      -0.929  42.085 -12.296  1.00 42.35           C  
ATOM   1717  CD1 PHE   245       0.328  42.120 -11.694  1.00 45.23           C  
ATOM   1718  CD2 PHE   245      -1.842  41.116 -11.891  1.00 43.67           C  
ATOM   1719  CE1 PHE   245       0.700  41.173 -10.739  1.00 42.02           C  
ATOM   1720  CE2 PHE   245      -1.473  40.171 -10.906  1.00 44.61           C  
ATOM   1721  CZ  PHE   245      -0.206  40.220 -10.336  1.00 39.90           C  
ATOM   1722  N   GLU   246      -1.760  41.234 -15.585  1.00 43.00           N  
ATOM   1723  CA  GLU   246      -2.042  39.927 -16.170  1.00 44.84           C  
ATOM   1724  C   GLU   246      -1.063  39.602 -17.321  1.00 44.90           C  
ATOM   1725  O   GLU   246      -0.621  38.454 -17.459  1.00 44.81           O  
ATOM   1726  CB  GLU   246      -3.526  39.860 -16.591  1.00 44.32           C  
ATOM   1727  CG  GLU   246      -3.954  38.674 -17.517  1.00 47.80           C  
ATOM   1728  CD  GLU   246      -5.251  38.946 -18.302  1.00 48.21           C  
ATOM   1729  OE1 GLU   246      -5.773  40.089 -18.210  1.00 54.42           O  
ATOM   1730  OE2 GLU   246      -5.737  38.036 -19.037  1.00 53.58           O  
ATOM   1731  N   LYS   247      -0.709  40.599 -18.135  1.00 45.50           N  
ATOM   1732  CA  LYS   247       0.238  40.365 -19.245  1.00 45.47           C  
ATOM   1733  C   LYS   247       1.616  40.052 -18.693  1.00 45.44           C  
ATOM   1734  O   LYS   247       2.220  39.049 -19.049  1.00 44.50           O  
ATOM   1735  CB  LYS   247       0.365  41.573 -20.175  1.00 45.46           C  
ATOM   1736  CG  LYS   247      -0.918  42.053 -20.865  1.00 48.64           C  
ATOM   1737  CD  LYS   247      -1.542  41.049 -21.852  1.00 50.26           C  
ATOM   1738  CE  LYS   247      -2.612  40.175 -21.151  1.00 52.86           C  
ATOM   1739  NZ  LYS   247      -3.531  40.995 -20.265  1.00 51.97           N  
ATOM   1740  N   ALA   248       2.113  40.961 -17.860  1.00 45.18           N  
ATOM   1741  CA  ALA   248       3.347  40.778 -17.103  1.00 47.11           C  
ATOM   1742  C   ALA   248       3.417  39.420 -16.390  1.00 47.71           C  
ATOM   1743  O   ALA   248       4.455  38.767 -16.415  1.00 48.59           O  
ATOM   1744  CB  ALA   248       3.510  41.906 -16.065  1.00 46.51           C  
ATOM   1745  N   LEU   249       2.324  38.999 -15.752  1.00 48.09           N  
ATOM   1746  CA  LEU   249       2.333  37.731 -15.017  1.00 49.29           C  
ATOM   1747  C   LEU   249       2.472  36.559 -15.978  1.00 48.63           C  
ATOM   1748  O   LEU   249       3.212  35.595 -15.702  1.00 48.78           O  
ATOM   1749  CB  LEU   249       1.068  37.553 -14.151  1.00 49.60           C  
ATOM   1750  CG  LEU   249       1.090  37.485 -12.610  1.00 54.43           C  
ATOM   1751  CD1 LEU   249       0.097  36.412 -12.168  1.00 55.08           C  
ATOM   1752  CD2 LEU   249       2.454  37.183 -11.983  1.00 55.79           C  
ATOM   1753  N   ALA   250       1.760  36.656 -17.101  1.00 48.14           N  
ATOM   1754  CA  ALA   250       1.699  35.597 -18.113  1.00 47.71           C  
ATOM   1755  C   ALA   250       3.049  35.394 -18.810  1.00 47.83           C  
ATOM   1756  O   ALA   250       3.456  34.250 -19.061  1.00 47.90           O  
ATOM   1757  CB  ALA   250       0.585  35.891 -19.145  1.00 47.10           C  
ATOM   1758  N   GLN   251       3.714  36.499 -19.150  1.00 47.40           N  
ATOM   1759  CA  GLN   251       5.108  36.485 -19.619  1.00 47.72           C  
ATOM   1760  C   GLN   251       5.992  35.752 -18.607  1.00 47.15           C  
ATOM   1761  O   GLN   251       6.709  34.823 -18.961  1.00 47.30           O  
ATOM   1762  CB  GLN   251       5.616  37.924 -19.883  1.00 47.82           C  
ATOM   1763  CG  GLN   251       7.139  38.186 -19.666  1.00 50.16           C  
ATOM   1764  CD  GLN   251       7.488  39.108 -18.448  1.00 55.43           C  
ATOM   1765  OE1 GLN   251       8.672  39.397 -18.198  1.00 57.79           O  
ATOM   1766  NE2 GLN   251       6.471  39.574 -17.717  1.00 51.70           N  
ATOM   1767  N   LEU   252       5.888  36.124 -17.345  1.00 46.40           N  
ATOM   1768  CA  LEU   252       6.785  35.611 -16.347  1.00 45.83           C  
ATOM   1769  C   LEU   252       6.648  34.127 -16.155  1.00 45.15           C  
ATOM   1770  O   LEU   252       7.614  33.437 -15.989  1.00 45.08           O  
ATOM   1771  CB  LEU   252       6.532  36.290 -15.001  1.00 45.21           C  
ATOM   1772  CG  LEU   252       7.059  37.678 -14.736  1.00 47.10           C  
ATOM   1773  CD1 LEU   252       6.263  38.387 -13.704  1.00 50.45           C  
ATOM   1774  CD2 LEU   252       8.474  37.620 -14.342  1.00 46.31           C  
ATOM   1775  N   LEU   253       5.428  33.655 -16.131  1.00 44.83           N  
ATOM   1776  CA  LEU   253       5.173  32.277 -15.753  1.00 45.50           C  
ATOM   1777  C   LEU   253       5.338  31.295 -16.921  1.00 47.33           C  
ATOM   1778  O   LEU   253       4.850  30.149 -16.882  1.00 47.87           O  
ATOM   1779  CB  LEU   253       3.790  32.160 -15.118  1.00 45.04           C  
ATOM   1780  CG  LEU   253       3.754  32.686 -13.679  1.00 44.08           C  
ATOM   1781  CD1 LEU   253       2.335  32.971 -13.207  1.00 41.18           C  
ATOM   1782  CD2 LEU   253       4.480  31.688 -12.774  1.00 44.27           C  
ATOM   1783  N   LYS   254       6.051  31.725 -17.954  1.00 48.81           N  
ATOM   1784  CA  LYS   254       6.266  30.875 -19.122  1.00 49.32           C  
ATOM   1785  C   LYS   254       7.219  29.706 -18.901  1.00 49.52           C  
ATOM   1786  O   LYS   254       7.221  28.754 -19.695  1.00 49.50           O  
ATOM   1787  CB  LYS   254       6.687  31.703 -20.338  1.00 49.85           C  
ATOM   1788  CG  LYS   254       5.620  31.769 -21.438  1.00 51.80           C  
ATOM   1789  CD  LYS   254       4.301  32.361 -20.926  1.00 53.96           C  
ATOM   1790  CE  LYS   254       3.413  31.331 -20.190  1.00 54.77           C  
ATOM   1791  NZ  LYS   254       2.785  31.953 -18.947  1.00 53.07           N  
END
