
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  126 ( 1061),  selected  126 , name 1coz_A
# Molecule2: number of CA atoms  135 ( 1088),  selected  135 , name T0507.pdb
# PARAMETERS: 1coz_A.T0507.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    K     2_A      M       1           #
LGA    K     3_A      K       2          1.489
LGA    V     4_A      V       3          0.736
LGA    I     5_A      A       4          0.934
LGA    T     6_A      L       5          1.201
LGA    Y     7_A      G       6          1.405
LGA    G     8_A      G       7          0.988
LGA    T     9_A      T       8          0.836
LGA    F    10_A      F       9          0.528
LGA    D    11_A      E      10          1.092
LGA    L    12_A      P      11          1.538
LGA    L    13_A      L      12          1.646
LGA    H    14_A      H      13          2.232
LGA    W    15_A      E      14          2.266
LGA    G    16_A      G      15          2.270
LGA    H    17_A      H      16          1.602
LGA    I    18_A      K      17          1.221
LGA    K    19_A      K      18          1.727
LGA    L    20_A      L      19          1.667
LGA    L    21_A      I      20          0.628
LGA    E    22_A      D      21          0.467
LGA    R    23_A      V      22          1.326
LGA    A    24_A      A      23          1.832
LGA    K    25_A      I      24          1.493
LGA    Q    26_A      K      25          1.346
LGA    L    27_A      L      26          1.764
LGA    G    28_A      G      27          1.900
LGA    D    29_A      G      28          2.722
LGA    Y    30_A      R      29          3.169
LGA    -       -      D      30           -
LGA    L    31_A      I      31          2.042
LGA    V    32_A      T      32          1.275
LGA    V    33_A      I      33          1.189
LGA    A    34_A      G      34          0.759
LGA    I    35_A      V      35          1.215
LGA    S    36_A      T      36          1.237
LGA    T    37_A      S      37          1.055
LGA    D    38_A      D      38          0.831
LGA    E    39_A      R      39          1.723
LGA    F    40_A      M      40          1.733
LGA    N    41_A      A      41          2.464
LGA    L    42_A      R      42          3.300
LGA    Q    43_A      A      43          4.044
LGA    K    44_A      R      44          4.163
LGA    Q    45_A      -       -           -
LGA    K    46_A      I      45          2.164
LGA    K    47_A      R      46          2.480
LGA    A    48_A      S      47          1.638
LGA    Y    49_A      V      48          2.574
LGA    H    50_A      L      49          1.703
LGA    S    51_A      P      50          1.305
LGA    Y    52_A      F      51          0.734
LGA    E    53_A      A      52          0.516
LGA    H    54_A      I      53          0.565
LGA    R    55_A      R      54          0.674
LGA    K    56_A      A      55          0.472
LGA    L    57_A      E      56          0.941
LGA    I    58_A      N      57          1.495
LGA    L    59_A      V      58          0.937
LGA    E    60_A      K      59          1.226
LGA    T    61_A      R      60          1.956
LGA    I    62_A      Y      61          2.686
LGA    R    63_A      V      62          2.891
LGA    -       -      M      63           -
LGA    -       -      R      64           -
LGA    -       -      K      65           -
LGA    Y    64_A      Y      66          4.767
LGA    -       -      G      67           -
LGA    -       -      F      68           -
LGA    V    65_A      E      69           #
LGA    D    66_A      P      70          1.898
LGA    E    67_A      E      71          1.055
LGA    V    68_A      I      72          1.000
LGA    I    69_A      V      73          0.799
LGA    P    70_A      K      74          0.765
LGA    E    71_A      I      75          1.214
LGA    K    72_A      T      76          1.353
LGA    N    73_A      N      77          1.980
LGA    W    74_A      P      78          1.617
LGA    E    75_A      Y      79          4.256
LGA    Q    76_A      G      80          3.508
LGA    K    77_A      -       -           -
LGA    K    78_A      -       -           -
LGA    Q    79_A      K      81          3.927
LGA    D    80_A      T      82          3.403
LGA    I    81_A      L      83          4.914
LGA    I    82_A      D      84          2.461
LGA    D    83_A      V      85          3.566
LGA    H    84_A      -       -           -
LGA    N    85_A      D      86          3.494
LGA    I    86_A      F      87          1.833
LGA    D    87_A      E      88          1.520
LGA    V    88_A      Y      89          0.939
LGA    F    89_A      L      90          0.793
LGA    V    90_A      V      91          1.152
LGA    M    91_A      V      92          0.803
LGA    G    92_A      S      93          0.423
LGA    D    93_A      P      94          2.491
LGA    D    94_A      E      95          3.465
LGA    W    95_A      T      96          3.653
LGA    E    96_A      Y      97          3.507
LGA    G    97_A      E      98          4.268
LGA    K    98_A      M      99          3.894
LGA    F    99_A      A     100          2.301
LGA    D   100_A      L     101          2.246
LGA    F   101_A      K     102          4.510
LGA    L   102_A      I     103          3.911
LGA    K   103_A      N     104          4.065
LGA    -       -      Q     105           -
LGA    -       -      K     106           -
LGA    D   104_A      R     107           #
LGA    -       -      E     108           -
LGA    -       -      E     109           -
LGA    -       -      L     110           -
LGA    -       -      G     111           -
LGA    -       -      K     112           -
LGA    Q   105_A      R     113          2.673
LGA    C   106_A      K     114          4.003
LGA    -       -      I     115           -
LGA    E   107_A      T     116          1.176
LGA    V   108_A      I     117          1.343
LGA    V   109_A      V     118          1.400
LGA    Y   110_A      K     119          1.041
LGA    L   111_A      V     120          0.951
LGA    P   112_A      D     121          0.527
LGA    R   113_A      W     122          1.276
LGA    T   114_A      M     123          2.931
LGA    E   115_A      -       -           -
LGA    G   116_A      -       -           -
LGA    I   117_A      M     124          4.504
LGA    S   118_A      S     132           -
LGA    T   119_A      S     133           -
LGA    T   120_A      T     134           -
LGA    K   121_A      R     135           -
LGA    I   122_A      I     136           -
LGA    K   123_A      K     137           -
LGA    E   124_A      R     138           -
LGA    E   125_A      G     139           -
LGA    I   126_A      E     140           -
LGA    -       -      I     141           -
LGA    -       -      D     142           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  126  135    5.0    107    2.28    19.63     59.982     4.492

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.557825 * X  +  -0.524366 * Y  +  -0.643329 * Z  +  36.031879
  Y_new =  -0.360604 * X  +  -0.545020 * Y  +   0.756913 * Z  +  48.251751
  Z_new =  -0.747527 * X  +   0.654212 * Y  +   0.114937 * Z  +  36.890762 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.396883   -1.744709  [ DEG:    80.0355    -99.9645 ]
  Theta =   0.844330    2.297262  [ DEG:    48.3766    131.6234 ]
  Phi   =  -2.567719    0.573873  [ DEG:  -147.1195     32.8805 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1coz_A                                        
REMARK     2: T0507.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1coz_A.T0507.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  126  135   5.0  107   2.28   19.63  59.982
REMARK  ---------------------------------------------------------- 
MOLECULE 1coz_A
HEADER    TRANSFERASE                             29-MAY-99   1COZ              
TITLE     CTP:GLYCEROL-3-PHOSPHATE CYTIDYLYLTRANSFERASE FROM BACILLUS           
TITLE    2 SUBTILIS                                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN (GLYCEROL-3-PHOSPHATE                              
COMPND   3 CYTIDYLYLTRANSFERASE);                                               
COMPND   4 CHAIN: A, B;                                                         
COMPND   5 EC: 2.7.7.39;                                                        
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 STRAIN: BR151-ESC168;                                                
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: PET-11A                                   
KEYWDS    TRANSFERASE                                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.H.WEBER,Y.S.PARK,S.SANKER,C.KENT,M.L.LUDWIG                         
REVDAT   1   06-OCT-99 1COZ    0                                                
JRNL        AUTH   C.H.WEBER,Y.S.PARK,S.SANKER,C.KENT,M.L.LUDWIG                
JRNL        TITL   A PROTOTYPICAL CYTIDYLYLTRANSFERASE:                         
JRNL        TITL 2 CTP:GLYCEROL-3-PHOSPHATE CYTIDYLYLTRANSFERASE FROM           
JRNL        TITL 3 BACILLUS SUBTILIS.                                           
JRNL        REF    STRUCTURE FOLD.DES.           V.   7  1113 1999              
JRNL        REFN   ASTM FODEFH  UK ISSN 1359-0278                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1COZ A    1   129  UNP    P27623   TAGD_BACSU       1    129             
DBREF  1COZ B  501   629  UNP    P27623   TAGD_BACSU       1    129             
SEQRES   1 A  129  MET LYS LYS VAL ILE THR TYR GLY THR PHE ASP LEU LEU          
SEQRES   2 A  129  HIS TRP GLY HIS ILE LYS LEU LEU GLU ARG ALA LYS GLN          
SEQRES   3 A  129  LEU GLY ASP TYR LEU VAL VAL ALA ILE SER THR ASP GLU          
SEQRES   4 A  129  PHE ASN LEU GLN LYS GLN LYS LYS ALA TYR HIS SER TYR          
SEQRES   5 A  129  GLU HIS ARG LYS LEU ILE LEU GLU THR ILE ARG TYR VAL          
SEQRES   6 A  129  ASP GLU VAL ILE PRO GLU LYS ASN TRP GLU GLN LYS LYS          
SEQRES   7 A  129  GLN ASP ILE ILE ASP HIS ASN ILE ASP VAL PHE VAL MET          
SEQRES   8 A  129  GLY ASP ASP TRP GLU GLY LYS PHE ASP PHE LEU LYS ASP          
SEQRES   9 A  129  GLN CYS GLU VAL VAL TYR LEU PRO ARG THR GLU GLY ILE          
SEQRES  10 A  129  SER THR THR LYS ILE LYS GLU GLU ILE ALA GLY LEU              
SEQRES   1 B  129  MET LYS LYS VAL ILE THR TYR GLY THR PHE ASP LEU LEU          
SEQRES   2 B  129  HIS TRP GLY HIS ILE LYS LEU LEU GLU ARG ALA LYS GLN          
SEQRES   3 B  129  LEU GLY ASP TYR LEU VAL VAL ALA ILE SER THR ASP GLU          
SEQRES   4 B  129  PHE ASN LEU GLN LYS GLN LYS LYS ALA TYR HIS SER TYR          
SEQRES   5 B  129  GLU HIS ARG LYS LEU ILE LEU GLU THR ILE ARG TYR VAL          
SEQRES   6 B  129  ASP GLU VAL ILE PRO GLU LYS ASN TRP GLU GLN LYS LYS          
SEQRES   7 B  129  GLN ASP ILE ILE ASP HIS ASN ILE ASP VAL PHE VAL MET          
SEQRES   8 B  129  GLY ASP ASP TRP GLU GLY LYS PHE ASP PHE LEU LYS ASP          
SEQRES   9 B  129  GLN CYS GLU VAL VAL TYR LEU PRO ARG THR GLU GLY ILE          
SEQRES  10 B  129  SER THR THR LYS ILE LYS GLU GLU ILE ALA GLY LEU              
HET    CTP    130      29                                                       
HET    CTP    630      29                                                       
HETNAM     CTP CYTIDINE-5'-TRIPHOSPHATE                                         
FORMUL   3  CTP    2(C9 H16 N3 O14 P3)                                          
FORMUL   5  HOH   *106(H2 O)                                                    
CRYST1   44.500   61.400   56.400  90.00 113.10  90.00 P 1 21 1      4          
ATOM      1  N   MET A   1       6.335  13.437  15.384  1.00 28.92           N  
ATOM      2  CA  MET A   1       7.484  13.086  16.257  1.00 29.72           C  
ATOM      3  C   MET A   1       7.471  13.914  17.550  1.00 27.28           C  
ATOM      4  O   MET A   1       7.519  15.135  17.514  1.00 25.51           O  
ATOM      5  CB  MET A   1       8.798  13.303  15.505  1.00 30.82           C  
ATOM      6  CG  MET A   1      10.016  13.043  16.356  1.00 40.55           C  
ATOM      7  SD  MET A   1      11.523  13.128  15.404  1.00 57.81           S  
ATOM      8  CE  MET A   1      11.528  14.848  14.924  1.00 58.87           C  
ATOM      9  N   LYS A   2       7.441  13.230  18.688  1.00 21.25           N  
ATOM     10  CA  LYS A   2       7.424  13.887  19.989  1.00 16.73           C  
ATOM     11  C   LYS A   2       8.868  14.162  20.480  1.00 19.36           C  
ATOM     12  O   LYS A   2       9.592  13.242  20.876  1.00 17.00           O  
ATOM     13  CB  LYS A   2       6.650  13.011  20.958  1.00 11.08           C  
ATOM     14  CG  LYS A   2       6.278  13.680  22.236  1.00 19.83           C  
ATOM     15  CD  LYS A   2       5.191  12.912  22.909  1.00 23.84           C  
ATOM     16  CE  LYS A   2       4.703  13.666  24.126  1.00 35.46           C  
ATOM     17  NZ  LYS A   2       3.549  12.985  24.786  1.00 44.64           N  
ATOM     18  N   LYS A   3       9.286  15.426  20.394  1.00 15.47           N  
ATOM     19  CA  LYS A   3      10.614  15.823  20.807  1.00 12.35           C  
ATOM     20  C   LYS A   3      10.711  16.249  22.266  1.00 16.32           C  
ATOM     21  O   LYS A   3       9.831  16.923  22.800  1.00 16.87           O  
ATOM     22  CB  LYS A   3      11.127  16.893  19.874  1.00  9.95           C  
ATOM     23  CG  LYS A   3      11.112  16.412  18.439  1.00 12.66           C  
ATOM     24  CD  LYS A   3      11.661  17.433  17.501  1.00 12.41           C  
ATOM     25  CE  LYS A   3      13.139  17.584  17.653  1.00 15.54           C  
ATOM     26  NZ  LYS A   3      13.640  18.565  16.653  1.00 16.08           N  
ATOM     27  N   VAL A   4      11.785  15.819  22.914  1.00 17.24           N  
ATOM     28  CA  VAL A   4      12.039  16.097  24.328  1.00 14.52           C  
ATOM     29  C   VAL A   4      13.343  16.877  24.473  1.00 13.67           C  
ATOM     30  O   VAL A   4      14.245  16.716  23.665  1.00 18.27           O  
ATOM     31  CB  VAL A   4      12.196  14.764  25.121  1.00 13.88           C  
ATOM     32  CG1 VAL A   4      12.341  15.034  26.603  1.00 13.27           C  
ATOM     33  CG2 VAL A   4      11.005  13.838  24.877  1.00  6.22           C  
ATOM     34  N   ILE A   5      13.433  17.760  25.459  1.00 15.93           N  
ATOM     35  CA  ILE A   5      14.687  18.502  25.688  1.00 13.99           C  
ATOM     36  C   ILE A   5      14.974  18.500  27.185  1.00 12.42           C  
ATOM     37  O   ILE A   5      14.052  18.350  27.994  1.00 12.83           O  
ATOM     38  CB  ILE A   5      14.650  19.976  25.123  1.00 10.27           C  
ATOM     39  CG1 ILE A   5      16.068  20.547  25.018  1.00  7.82           C  
ATOM     40  CG2 ILE A   5      13.781  20.872  25.987  1.00 14.46           C  
ATOM     41  CD1 ILE A   5      16.173  21.807  24.167  1.00  4.16           C  
ATOM     42  N   THR A   6      16.254  18.576  27.538  1.00 13.43           N  
ATOM     43  CA  THR A   6      16.680  18.615  28.931  1.00 10.02           C  
ATOM     44  C   THR A   6      18.018  19.366  28.946  1.00 12.48           C  
ATOM     45  O   THR A   6      18.689  19.469  27.909  1.00 10.32           O  
ATOM     46  CB  THR A   6      16.739  17.197  29.574  1.00  9.31           C  
ATOM     47  OG1 THR A   6      16.821  17.326  30.986  1.00 10.15           O  
ATOM     48  CG2 THR A   6      17.917  16.370  29.089  1.00  7.25           C  
ATOM     49  N   TYR A   7      18.314  20.031  30.062  1.00 11.09           N  
ATOM     50  CA  TYR A   7      19.538  20.815  30.191  1.00 12.71           C  
ATOM     51  C   TYR A   7      20.403  20.347  31.349  1.00  7.36           C  
ATOM     52  O   TYR A   7      19.896  19.910  32.374  1.00 11.15           O  
ATOM     53  CB  TYR A   7      19.193  22.276  30.420  1.00 11.46           C  
ATOM     54  CG  TYR A   7      18.459  22.929  29.292  1.00 15.28           C  
ATOM     55  CD1 TYR A   7      17.104  22.633  29.035  1.00 16.70           C  
ATOM     56  CD2 TYR A   7      19.109  23.846  28.471  1.00  9.69           C  
ATOM     57  CE1 TYR A   7      16.426  23.243  27.972  1.00 12.86           C  
ATOM     58  CE2 TYR A   7      18.449  24.457  27.419  1.00 14.39           C  
ATOM     59  CZ  TYR A   7      17.107  24.145  27.177  1.00 15.24           C  
ATOM     60  OH  TYR A   7      16.469  24.732  26.123  1.00 17.36           O  
ATOM     61  N   GLY A   8      21.712  20.490  31.197  1.00 10.96           N  
ATOM     62  CA  GLY A   8      22.608  20.073  32.255  1.00 12.11           C  
ATOM     63  C   GLY A   8      24.056  20.226  31.864  1.00 12.11           C  
ATOM     64  O   GLY A   8      24.370  20.680  30.772  1.00 11.11           O  
ATOM     65  N   THR A   9      24.946  19.808  32.753  1.00 16.77           N  
ATOM     66  CA  THR A   9      26.386  19.902  32.487  1.00 14.61           C  
ATOM     67  C   THR A   9      26.951  18.548  32.061  1.00  8.11           C  
ATOM     68  O   THR A   9      27.766  18.478  31.149  1.00 10.61           O  
ATOM     69  CB  THR A   9      27.147  20.420  33.719  1.00 18.54           C  
ATOM     70  OG1 THR A   9      26.615  21.699  34.089  1.00 22.73           O  
ATOM     71  CG2 THR A   9      28.641  20.560  33.421  1.00 15.97           C  
ATOM     72  N   PHE A  10      26.488  17.490  32.720  1.00  7.30           N  
ATOM     73  CA  PHE A  10      26.916  16.125  32.417  1.00 18.14           C  
ATOM     74  C   PHE A  10      28.438  16.046  32.342  1.00 18.62           C  
ATOM     75  O   PHE A  10      29.000  15.620  31.349  1.00 19.85           O  
ATOM     76  CB  PHE A  10      26.278  15.655  31.089  1.00 16.78           C  
ATOM     77  CG  PHE A  10      24.768  15.630  31.113  1.00 12.54           C  
ATOM     78  CD1 PHE A  10      24.088  14.553  31.664  1.00 13.35           C  
ATOM     79  CD2 PHE A  10      24.033  16.712  30.636  1.00 13.43           C  
ATOM     80  CE1 PHE A  10      22.696  14.551  31.748  1.00 13.72           C  
ATOM     81  CE2 PHE A  10      22.646  16.720  30.717  1.00 10.02           C  
ATOM     82  CZ  PHE A  10      21.979  15.648  31.271  1.00 11.11           C  
ATOM     83  N   ASP A  11      29.099  16.472  33.405  1.00 18.35           N  
ATOM     84  CA  ASP A  11      30.559  16.478  33.436  1.00 21.52           C  
ATOM     85  C   ASP A  11      31.250  15.127  33.668  1.00 21.92           C  
ATOM     86  O   ASP A  11      32.082  14.729  32.872  1.00 30.91           O  
ATOM     87  CB  ASP A  11      31.052  17.520  34.444  1.00 17.55           C  
ATOM     88  CG  ASP A  11      32.561  17.651  34.469  1.00 13.80           C  
ATOM     89  OD1 ASP A  11      33.228  17.485  33.432  1.00 13.96           O  
ATOM     90  OD2 ASP A  11      33.072  17.950  35.549  1.00 13.95           O  
ATOM     91  N   LEU A  12      31.043  14.508  34.821  1.00 21.74           N  
ATOM     92  CA  LEU A  12      31.662  13.213  35.074  1.00 24.86           C  
ATOM     93  C   LEU A  12      30.478  12.257  35.034  1.00 24.75           C  
ATOM     94  O   LEU A  12      29.850  11.987  36.054  1.00 24.62           O  
ATOM     95  CB  LEU A  12      32.382  13.187  36.436  1.00 22.18           C  
ATOM     96  CG  LEU A  12      33.588  14.124  36.615  1.00 17.94           C  
ATOM     97  CD1 LEU A  12      34.136  14.006  38.017  1.00 23.97           C  
ATOM     98  CD2 LEU A  12      34.657  13.805  35.638  1.00 21.36           C  
ATOM     99  N   LEU A  13      30.135  11.832  33.820  1.00 27.50           N  
ATOM    100  CA  LEU A  13      28.992  10.957  33.554  1.00 29.66           C  
ATOM    101  C   LEU A  13      28.868   9.795  34.533  1.00 29.79           C  
ATOM    102  O   LEU A  13      29.789   9.001  34.709  1.00 34.98           O  
ATOM    103  CB  LEU A  13      29.019  10.479  32.089  1.00 31.19           C  
ATOM    104  CG  LEU A  13      27.714  10.056  31.397  1.00 28.15           C  
ATOM    105  CD1 LEU A  13      26.779  11.237  31.199  1.00 26.99           C  
ATOM    106  CD2 LEU A  13      28.050   9.462  30.058  1.00 31.96           C  
ATOM    107  N   HIS A  14      27.733   9.740  35.222  1.00 26.22           N  
ATOM    108  CA  HIS A  14      27.473   8.689  36.202  1.00 21.99           C  
ATOM    109  C   HIS A  14      26.081   8.095  35.984  1.00 18.75           C  
ATOM    110  O   HIS A  14      25.320   8.588  35.168  1.00 19.75           O  
ATOM    111  CB  HIS A  14      27.619   9.232  37.640  1.00 18.55           C  
ATOM    112  CG  HIS A  14      26.873  10.512  37.905  1.00 19.54           C  
ATOM    113  ND1 HIS A  14      25.534  10.542  38.243  1.00 18.50           N  
ATOM    114  CD2 HIS A  14      27.292  11.800  37.934  1.00 21.67           C  
ATOM    115  CE1 HIS A  14      25.166  11.790  38.473  1.00 15.57           C  
ATOM    116  NE2 HIS A  14      26.212  12.573  38.291  1.00 16.38           N  
ATOM    117  N   TRP A  15      25.757   7.046  36.726  1.00 20.84           N  
ATOM    118  CA  TRP A  15      24.470   6.368  36.625  1.00 26.43           C  
ATOM    119  C   TRP A  15      23.236   7.241  36.897  1.00 27.04           C  
ATOM    120  O   TRP A  15      22.134   6.887  36.469  1.00 26.79           O  
ATOM    121  CB  TRP A  15      24.453   5.115  37.507  1.00 33.82           C  
ATOM    122  CG  TRP A  15      25.051   5.340  38.857  1.00 46.68           C  
ATOM    123  CD1 TRP A  15      26.377   5.543  39.140  1.00 51.92           C  
ATOM    124  CD2 TRP A  15      24.358   5.417  40.108  1.00 52.10           C  
ATOM    125  NE1 TRP A  15      26.549   5.746  40.486  1.00 57.37           N  
ATOM    126  CE2 TRP A  15      25.329   5.676  41.108  1.00 57.42           C  
ATOM    127  CE3 TRP A  15      23.015   5.290  40.488  1.00 56.97           C  
ATOM    128  CZ2 TRP A  15      24.996   5.812  42.471  1.00 60.07           C  
ATOM    129  CZ3 TRP A  15      22.683   5.423  41.848  1.00 60.14           C  
ATOM    130  CH2 TRP A  15      23.675   5.683  42.819  1.00 61.01           C  
ATOM    131  N   GLY A  16      23.399   8.336  37.644  1.00 24.59           N  
ATOM    132  CA  GLY A  16      22.269   9.221  37.899  1.00 15.20           C  
ATOM    133  C   GLY A  16      21.927   9.938  36.601  1.00 15.28           C  
ATOM    134  O   GLY A  16      20.766  10.144  36.277  1.00 16.53           O  
ATOM    135  N   HIS A  17      22.954  10.371  35.875  1.00 14.02           N  
ATOM    136  CA  HIS A  17      22.764  11.035  34.598  1.00 14.40           C  
ATOM    137  C   HIS A  17      22.085  10.074  33.628  1.00 18.94           C  
ATOM    138  O   HIS A  17      21.230  10.492  32.863  1.00 17.95           O  
ATOM    139  CB  HIS A  17      24.116  11.429  33.980  1.00 18.15           C  
ATOM    140  CG  HIS A  17      24.805  12.559  34.678  1.00 20.58           C  
ATOM    141  ND1 HIS A  17      26.176  12.680  34.720  1.00 19.83           N  
ATOM    142  CD2 HIS A  17      24.313  13.651  35.306  1.00 24.23           C  
ATOM    143  CE1 HIS A  17      26.500  13.802  35.336  1.00 22.75           C  
ATOM    144  NE2 HIS A  17      25.388  14.410  35.703  1.00 20.09           N  
ATOM    145  N   ILE A  18      22.525   8.808  33.625  1.00 19.34           N  
ATOM    146  CA  ILE A  18      21.997   7.769  32.727  1.00 19.57           C  
ATOM    147  C   ILE A  18      20.514   7.519  32.951  1.00 19.97           C  
ATOM    148  O   ILE A  18      19.739   7.443  31.994  1.00 17.29           O  
ATOM    149  CB  ILE A  18      22.796   6.428  32.838  1.00 19.74           C  
ATOM    150  CG1 ILE A  18      24.252   6.623  32.392  1.00 13.51           C  
ATOM    151  CG2 ILE A  18      22.171   5.352  31.980  1.00 25.26           C  
ATOM    152  CD1 ILE A  18      24.449   7.257  31.029  1.00 15.09           C  
ATOM    153  N   LYS A  19      20.127   7.409  34.216  1.00 16.37           N  
ATOM    154  CA  LYS A  19      18.732   7.194  34.572  1.00 20.95           C  
ATOM    155  C   LYS A  19      17.847   8.380  34.187  1.00 20.26           C  
ATOM    156  O   LYS A  19      16.655   8.210  33.902  1.00 20.52           O  
ATOM    157  CB  LYS A  19      18.595   6.899  36.062  1.00 23.41           C  
ATOM    158  CG  LYS A  19      18.721   5.421  36.399  1.00 41.91           C  
ATOM    159  CD  LYS A  19      17.593   4.581  35.747  1.00 53.25           C  
ATOM    160  CE  LYS A  19      16.188   5.045  36.180  1.00 58.13           C  
ATOM    161  NZ  LYS A  19      15.060   4.253  35.585  1.00 63.05           N  
ATOM    162  N   LEU A  20      18.418   9.579  34.212  1.00 19.57           N  
ATOM    163  CA  LEU A  20      17.672  10.762  33.841  1.00 16.51           C  
ATOM    164  C   LEU A  20      17.443  10.678  32.343  1.00 13.86           C  
ATOM    165  O   LEU A  20      16.315  10.846  31.887  1.00 17.54           O  
ATOM    166  CB  LEU A  20      18.457  12.027  34.188  1.00 15.18           C  
ATOM    167  CG  LEU A  20      17.879  13.423  33.899  1.00 12.78           C  
ATOM    168  CD1 LEU A  20      17.996  13.804  32.440  1.00 13.53           C  
ATOM    169  CD2 LEU A  20      16.467  13.511  34.389  1.00 17.57           C  
ATOM    170  N   LEU A  21      18.519  10.433  31.589  1.00 10.31           N  
ATOM    171  CA  LEU A  21      18.440  10.330  30.129  1.00 17.10           C  
ATOM    172  C   LEU A  21      17.503   9.214  29.667  1.00 16.19           C  
ATOM    173  O   LEU A  21      16.843   9.328  28.632  1.00 18.18           O  
ATOM    174  CB  LEU A  21      19.823  10.116  29.514  1.00 16.05           C  
ATOM    175  CG  LEU A  21      20.796  11.287  29.702  1.00 21.64           C  
ATOM    176  CD1 LEU A  21      22.194  10.923  29.168  1.00 22.79           C  
ATOM    177  CD2 LEU A  21      20.255  12.531  29.007  1.00 12.90           C  
ATOM    178  N   GLU A  22      17.486   8.128  30.422  1.00 13.96           N  
ATOM    179  CA  GLU A  22      16.637   7.005  30.114  1.00 18.07           C  
ATOM    180  C   GLU A  22      15.165   7.414  30.258  1.00 22.23           C  
ATOM    181  O   GLU A  22      14.350   7.201  29.360  1.00 20.38           O  
ATOM    182  CB  GLU A  22      16.958   5.880  31.072  1.00 19.23           C  
ATOM    183  CG  GLU A  22      16.152   4.633  30.836  1.00 32.11           C  
ATOM    184  CD  GLU A  22      16.426   3.561  31.861  1.00 36.72           C  
ATOM    185  OE1 GLU A  22      17.447   3.654  32.581  1.00 42.42           O  
ATOM    186  OE2 GLU A  22      15.622   2.614  31.934  1.00 44.07           O  
ATOM    187  N   ARG A  23      14.831   7.994  31.401  1.00 17.26           N  
ATOM    188  CA  ARG A  23      13.471   8.419  31.648  1.00 18.01           C  
ATOM    189  C   ARG A  23      13.020   9.562  30.747  1.00 17.02           C  
ATOM    190  O   ARG A  23      11.863   9.621  30.348  1.00 21.54           O  
ATOM    191  CB  ARG A  23      13.318   8.782  33.111  1.00 19.44           C  
ATOM    192  CG  ARG A  23      13.505   7.582  34.031  1.00 25.54           C  
ATOM    193  CD  ARG A  23      13.430   7.977  35.515  1.00 29.23           C  
ATOM    194  NE  ARG A  23      14.565   8.808  35.932  1.00 35.33           N  
ATOM    195  CZ  ARG A  23      14.550   9.666  36.951  1.00 29.50           C  
ATOM    196  NH1 ARG A  23      13.451   9.825  37.679  1.00 34.14           N  
ATOM    197  NH2 ARG A  23      15.635  10.373  37.232  1.00 26.39           N  
ATOM    198  N   ALA A  24      13.921  10.483  30.429  1.00 15.52           N  
ATOM    199  CA  ALA A  24      13.555  11.589  29.542  1.00 16.35           C  
ATOM    200  C   ALA A  24      13.203  11.057  28.144  1.00 21.57           C  
ATOM    201  O   ALA A  24      12.213  11.481  27.531  1.00 17.21           O  
ATOM    202  CB  ALA A  24      14.684  12.601  29.436  1.00  9.85           C  
ATOM    203  N   LYS A  25      14.049  10.170  27.627  1.00 19.94           N  
ATOM    204  CA  LYS A  25      13.825   9.600  26.315  1.00 19.23           C  
ATOM    205  C   LYS A  25      12.496   8.870  26.252  1.00 22.51           C  
ATOM    206  O   LYS A  25      11.789   8.996  25.261  1.00 26.15           O  
ATOM    207  CB  LYS A  25      14.965   8.663  25.923  1.00 18.42           C  
ATOM    208  CG  LYS A  25      14.821   8.001  24.532  1.00 16.56           C  
ATOM    209  CD  LYS A  25      14.640   9.029  23.434  1.00 13.96           C  
ATOM    210  CE  LYS A  25      14.679   8.404  22.069  1.00 20.34           C  
ATOM    211  NZ  LYS A  25      16.065   8.139  21.609  1.00 18.76           N  
ATOM    212  N   GLN A  26      12.114   8.170  27.314  1.00 22.34           N  
ATOM    213  CA  GLN A  26      10.852   7.441  27.281  1.00 26.70           C  
ATOM    214  C   GLN A  26       9.604   8.319  27.274  1.00 24.93           C  
ATOM    215  O   GLN A  26       8.485   7.817  27.218  1.00 23.51           O  
ATOM    216  CB  GLN A  26      10.772   6.380  28.380  1.00 34.56           C  
ATOM    217  CG  GLN A  26      10.454   6.892  29.773  1.00 54.06           C  
ATOM    218  CD  GLN A  26      10.029   5.771  30.723  1.00 62.93           C  
ATOM    219  OE1 GLN A  26      10.853   5.204  31.457  1.00 64.15           O  
ATOM    220  NE2 GLN A  26       8.735   5.423  30.691  1.00 67.24           N  
ATOM    221  N   LEU A  27       9.793   9.631  27.286  1.00 22.73           N  
ATOM    222  CA  LEU A  27       8.678  10.571  27.253  1.00 20.56           C  
ATOM    223  C   LEU A  27       8.432  11.065  25.815  1.00 19.48           C  
ATOM    224  O   LEU A  27       7.509  11.841  25.557  1.00 23.61           O  
ATOM    225  CB  LEU A  27       8.967  11.752  28.186  1.00 19.17           C  
ATOM    226  CG  LEU A  27       8.425  11.751  29.624  1.00 23.35           C  
ATOM    227  CD1 LEU A  27       8.183  10.364  30.120  1.00 27.39           C  
ATOM    228  CD2 LEU A  27       9.388  12.487  30.554  1.00 21.12           C  
ATOM    229  N   GLY A  28       9.259  10.616  24.877  1.00 17.81           N  
ATOM    230  CA  GLY A  28       9.098  11.036  23.498  1.00 16.03           C  
ATOM    231  C   GLY A  28       9.752  10.086  22.511  1.00 14.80           C  
ATOM    232  O   GLY A  28       9.996   8.918  22.816  1.00 18.49           O  
ATOM    233  N   ASP A  29      10.044  10.595  21.324  1.00 15.75           N  
ATOM    234  CA  ASP A  29      10.660   9.800  20.272  1.00 18.44           C  
ATOM    235  C   ASP A  29      12.050  10.280  19.964  1.00 17.97           C  
ATOM    236  O   ASP A  29      12.834   9.579  19.328  1.00 18.71           O  
ATOM    237  CB  ASP A  29       9.857   9.931  18.971  1.00 26.15           C  
ATOM    238  CG  ASP A  29       8.424   9.443  19.107  1.00 30.74           C  
ATOM    239  OD1 ASP A  29       8.213   8.281  19.524  1.00 36.98           O  
ATOM    240  OD2 ASP A  29       7.508  10.225  18.777  1.00 33.95           O  
ATOM    241  N   TYR A  30      12.354  11.486  20.404  1.00 15.86           N  
ATOM    242  CA  TYR A  30      13.630  12.078  20.096  1.00 15.39           C  
ATOM    243  C   TYR A  30      14.054  12.961  21.282  1.00 18.83           C  
ATOM    244  O   TYR A  30      13.274  13.788  21.736  1.00 18.07           O  
ATOM    245  CB  TYR A  30      13.415  12.882  18.809  1.00 11.58           C  
ATOM    246  CG  TYR A  30      14.635  13.473  18.179  1.00 13.00           C  
ATOM    247  CD1 TYR A  30      15.199  14.653  18.670  1.00 15.23           C  
ATOM    248  CD2 TYR A  30      15.182  12.910  17.038  1.00 15.16           C  
ATOM    249  CE1 TYR A  30      16.270  15.260  18.026  1.00 12.29           C  
ATOM    250  CE2 TYR A  30      16.253  13.512  16.385  1.00 12.20           C  
ATOM    251  CZ  TYR A  30      16.784  14.686  16.881  1.00 14.35           C  
ATOM    252  OH  TYR A  30      17.790  15.314  16.191  1.00 15.51           O  
ATOM    253  N   LEU A  31      15.279  12.765  21.773  1.00 15.14           N  
ATOM    254  CA  LEU A  31      15.816  13.515  22.916  1.00 12.16           C  
ATOM    255  C   LEU A  31      16.987  14.417  22.550  1.00 11.94           C  
ATOM    256  O   LEU A  31      17.982  13.960  21.991  1.00 12.72           O  
ATOM    257  CB  LEU A  31      16.260  12.543  24.012  1.00 11.95           C  
ATOM    258  CG  LEU A  31      16.993  13.113  25.227  1.00 16.40           C  
ATOM    259  CD1 LEU A  31      16.049  14.005  26.011  1.00 11.98           C  
ATOM    260  CD2 LEU A  31      17.507  11.977  26.103  1.00 12.91           C  
ATOM    261  N   VAL A  32      16.831  15.711  22.815  1.00  9.22           N  
ATOM    262  CA  VAL A  32      17.862  16.708  22.566  1.00  9.61           C  
ATOM    263  C   VAL A  32      18.390  17.099  23.951  1.00 13.28           C  
ATOM    264  O   VAL A  32      17.602  17.302  24.876  1.00 10.84           O  
ATOM    265  CB  VAL A  32      17.294  17.997  21.906  1.00 11.35           C  
ATOM    266  CG1 VAL A  32      18.408  19.008  21.654  1.00  7.01           C  
ATOM    267  CG2 VAL A  32      16.588  17.672  20.611  1.00 14.78           C  
ATOM    268  N   VAL A  33      19.714  17.116  24.115  1.00 15.43           N  
ATOM    269  CA  VAL A  33      20.323  17.499  25.389  1.00 13.12           C  
ATOM    270  C   VAL A  33      21.127  18.770  25.184  1.00 10.72           C  
ATOM    271  O   VAL A  33      22.008  18.829  24.331  1.00 11.65           O  
ATOM    272  CB  VAL A  33      21.251  16.389  25.973  1.00 17.63           C  
ATOM    273  CG1 VAL A  33      21.694  16.758  27.414  1.00 13.59           C  
ATOM    274  CG2 VAL A  33      20.525  15.062  25.993  1.00 17.31           C  
ATOM    275  N   ALA A  34      20.756  19.819  25.900  1.00 13.51           N  
ATOM    276  CA  ALA A  34      21.478  21.076  25.800  1.00 12.87           C  
ATOM    277  C   ALA A  34      22.474  21.087  26.973  1.00 10.80           C  
ATOM    278  O   ALA A  34      22.084  20.928  28.119  1.00 10.25           O  
ATOM    279  CB  ALA A  34      20.503  22.254  25.877  1.00  9.39           C  
ATOM    280  N   ILE A  35      23.769  21.160  26.680  1.00 14.69           N  
ATOM    281  CA  ILE A  35      24.767  21.163  27.750  1.00 15.72           C  
ATOM    282  C   ILE A  35      25.562  22.469  27.843  1.00 14.54           C  
ATOM    283  O   ILE A  35      25.915  23.082  26.835  1.00 12.03           O  
ATOM    284  CB  ILE A  35      25.738  19.951  27.638  1.00 14.54           C  
ATOM    285  CG1 ILE A  35      26.609  20.062  26.392  1.00 19.82           C  
ATOM    286  CG2 ILE A  35      24.951  18.646  27.584  1.00 13.26           C  
ATOM    287  CD1 ILE A  35      27.663  18.985  26.299  1.00 20.64           C  
ATOM    288  N   SER A  36      25.846  22.887  29.071  1.00 18.00           N  
ATOM    289  CA  SER A  36      26.601  24.115  29.317  1.00 15.08           C  
ATOM    290  C   SER A  36      27.927  24.152  28.594  1.00 11.03           C  
ATOM    291  O   SER A  36      28.708  23.196  28.644  1.00 13.28           O  
ATOM    292  CB  SER A  36      26.889  24.273  30.807  1.00 13.43           C  
ATOM    293  OG  SER A  36      25.692  24.267  31.537  1.00 32.77           O  
ATOM    294  N   THR A  37      28.159  25.258  27.901  1.00 11.78           N  
ATOM    295  CA  THR A  37      29.405  25.484  27.209  1.00 11.95           C  
ATOM    296  C   THR A  37      30.424  25.864  28.295  1.00 17.54           C  
ATOM    297  O   THR A  37      30.063  26.126  29.442  1.00 13.55           O  
ATOM    298  CB  THR A  37      29.278  26.654  26.231  1.00 14.76           C  
ATOM    299  OG1 THR A  37      28.933  27.844  26.958  1.00 18.13           O  
ATOM    300  CG2 THR A  37      28.187  26.362  25.204  1.00 14.02           C  
ATOM    301  N   ASP A  38      31.701  25.861  27.948  1.00 21.16           N  
ATOM    302  CA  ASP A  38      32.705  26.228  28.932  1.00 23.44           C  
ATOM    303  C   ASP A  38      32.593  27.713  29.285  1.00 20.49           C  
ATOM    304  O   ASP A  38      32.870  28.097  30.412  1.00 31.42           O  
ATOM    305  CB  ASP A  38      34.107  25.861  28.432  1.00 23.51           C  
ATOM    306  CG  ASP A  38      34.251  24.364  28.160  1.00 22.91           C  
ATOM    307  OD1 ASP A  38      33.854  23.544  29.031  1.00 29.61           O  
ATOM    308  OD2 ASP A  38      34.748  24.023  27.069  1.00 18.28           O  
ATOM    309  N   GLU A  39      32.177  28.544  28.331  1.00 18.76           N  
ATOM    310  CA  GLU A  39      32.013  29.978  28.579  1.00 15.58           C  
ATOM    311  C   GLU A  39      30.899  30.223  29.583  1.00 15.04           C  
ATOM    312  O   GLU A  39      31.033  31.040  30.482  1.00 15.95           O  
ATOM    313  CB  GLU A  39      31.681  30.722  27.290  1.00 15.81           C  
ATOM    314  CG  GLU A  39      32.817  30.848  26.318  1.00 22.02           C  
ATOM    315  CD  GLU A  39      33.195  29.535  25.648  1.00 32.48           C  
ATOM    316  OE1 GLU A  39      32.361  28.599  25.588  1.00 29.50           O  
ATOM    317  OE2 GLU A  39      34.343  29.446  25.166  1.00 37.63           O  
ATOM    318  N   PHE A  40      29.805  29.484  29.440  1.00 15.93           N  
ATOM    319  CA  PHE A  40      28.670  29.634  30.327  1.00 13.29           C  
ATOM    320  C   PHE A  40      29.090  29.160  31.695  1.00 16.84           C  
ATOM    321  O   PHE A  40      28.709  29.745  32.702  1.00 14.40           O  
ATOM    322  CB  PHE A  40      27.481  28.834  29.804  1.00 13.57           C  
ATOM    323  CG  PHE A  40      26.190  29.101  30.526  1.00 17.44           C  
ATOM    324  CD1 PHE A  40      25.977  30.298  31.197  1.00 18.86           C  
ATOM    325  CD2 PHE A  40      25.179  28.147  30.533  1.00 14.27           C  
ATOM    326  CE1 PHE A  40      24.786  30.533  31.862  1.00 15.38           C  
ATOM    327  CE2 PHE A  40      23.985  28.373  31.194  1.00 18.21           C  
ATOM    328  CZ  PHE A  40      23.787  29.570  31.862  1.00 17.92           C  
ATOM    329  N   ASN A  41      29.840  28.068  31.737  1.00 16.92           N  
ATOM    330  CA  ASN A  41      30.349  27.551  33.016  1.00 20.44           C  
ATOM    331  C   ASN A  41      31.247  28.588  33.716  1.00 16.62           C  
ATOM    332  O   ASN A  41      31.257  28.694  34.940  1.00 22.54           O  
ATOM    333  CB  ASN A  41      31.168  26.281  32.804  1.00 19.16           C  
ATOM    334  CG  ASN A  41      30.328  25.056  32.708  1.00 20.03           C  
ATOM    335  OD1 ASN A  41      30.796  24.022  32.239  1.00 25.96           O  
ATOM    336  ND2 ASN A  41      29.093  25.136  33.179  1.00 16.08           N  
ATOM    337  N   LEU A  42      32.050  29.310  32.952  1.00 17.27           N  
ATOM    338  CA  LEU A  42      32.899  30.322  33.567  1.00 23.86           C  
ATOM    339  C   LEU A  42      31.968  31.364  34.190  1.00 26.81           C  
ATOM    340  O   LEU A  42      32.217  31.836  35.300  1.00 25.05           O  
ATOM    341  CB  LEU A  42      33.788  30.992  32.528  1.00 20.28           C  
ATOM    342  CG  LEU A  42      35.194  31.429  32.960  1.00 28.21           C  
ATOM    343  CD1 LEU A  42      35.672  32.575  32.078  1.00 28.60           C  
ATOM    344  CD2 LEU A  42      35.211  31.858  34.407  1.00 31.69           C  
ATOM    345  N   GLN A  43      30.916  31.732  33.453  1.00 26.87           N  
ATOM    346  CA  GLN A  43      29.932  32.703  33.923  1.00 26.85           C  
ATOM    347  C   GLN A  43      29.221  32.219  35.175  1.00 25.37           C  
ATOM    348  O   GLN A  43      28.877  33.018  36.031  1.00 26.43           O  
ATOM    349  CB  GLN A  43      28.913  33.018  32.833  1.00 31.13           C  
ATOM    350  CG  GLN A  43      29.453  33.954  31.777  1.00 44.96           C  
ATOM    351  CD  GLN A  43      28.600  34.030  30.508  1.00 57.52           C  
ATOM    352  OE1 GLN A  43      29.029  34.623  29.512  1.00 63.70           O  
ATOM    353  NE2 GLN A  43      27.412  33.428  30.526  1.00 64.28           N  
ATOM    354  N   LYS A  44      29.014  30.913  35.284  1.00 19.16           N  
ATOM    355  CA  LYS A  44      28.368  30.347  36.460  1.00 19.18           C  
ATOM    356  C   LYS A  44      29.396  30.039  37.564  1.00 18.52           C  
ATOM    357  O   LYS A  44      29.012  29.650  38.660  1.00 18.74           O  
ATOM    358  CB  LYS A  44      27.602  29.059  36.098  1.00 18.45           C  
ATOM    359  CG  LYS A  44      26.483  29.269  35.076  1.00 23.61           C  
ATOM    360  CD  LYS A  44      25.553  28.071  34.959  1.00 23.27           C  
ATOM    361  CE  LYS A  44      26.213  26.885  34.311  1.00 27.15           C  
ATOM    362  NZ  LYS A  44      25.248  25.750  34.311  1.00 31.85           N  
ATOM    363  N   GLN A  45      30.686  30.243  37.271  1.00 24.92           N  
ATOM    364  CA  GLN A  45      31.792  29.955  38.197  1.00 27.73           C  
ATOM    365  C   GLN A  45      31.764  28.503  38.681  1.00 31.29           C  
ATOM    366  O   GLN A  45      32.219  28.173  39.778  1.00 32.23           O  
ATOM    367  CB  GLN A  45      31.831  30.964  39.346  1.00 30.66           C  
ATOM    368  CG  GLN A  45      32.483  32.279  38.891  1.00 41.96           C  
ATOM    369  CD  GLN A  45      32.647  33.312  39.991  1.00 49.28           C  
ATOM    370  OE1 GLN A  45      32.713  34.508  39.711  1.00 54.61           O  
ATOM    371  NE2 GLN A  45      32.738  32.860  41.243  1.00 52.52           N  
ATOM    372  N   LYS A  46      31.337  27.637  37.761  1.00 34.07           N  
ATOM    373  CA  LYS A  46      31.184  26.201  37.971  1.00 37.36           C  
ATOM    374  C   LYS A  46      31.961  25.540  36.855  1.00 35.90           C  
ATOM    375  O   LYS A  46      31.408  25.237  35.799  1.00 39.61           O  
ATOM    376  CB  LYS A  46      29.701  25.824  37.841  1.00 43.64           C  
ATOM    377  CG  LYS A  46      29.361  24.357  38.061  1.00 48.79           C  
ATOM    378  CD  LYS A  46      29.462  23.994  39.528  1.00 51.81           C  
ATOM    379  CE  LYS A  46      28.747  22.685  39.811  1.00 59.66           C  
ATOM    380  NZ  LYS A  46      27.285  22.755  39.489  1.00 64.93           N  
ATOM    381  N   LYS A  47      33.239  25.319  37.100  1.00 34.06           N  
ATOM    382  CA  LYS A  47      34.116  24.716  36.119  1.00 40.96           C  
ATOM    383  C   LYS A  47      33.974  23.187  36.036  1.00 36.52           C  
ATOM    384  O   LYS A  47      34.017  22.483  37.045  1.00 38.31           O  
ATOM    385  CB  LYS A  47      35.567  25.136  36.405  1.00 51.10           C  
ATOM    386  CG  LYS A  47      36.520  25.092  35.196  1.00 61.55           C  
ATOM    387  CD  LYS A  47      37.081  23.684  34.948  1.00 68.21           C  
ATOM    388  CE  LYS A  47      37.993  23.625  33.723  1.00 72.53           C  
ATOM    389  NZ  LYS A  47      38.519  22.248  33.466  1.00 73.70           N  
ATOM    390  N   ALA A  48      33.801  22.693  34.811  1.00 34.13           N  
ATOM    391  CA  ALA A  48      33.647  21.265  34.532  1.00 29.57           C  
ATOM    392  C   ALA A  48      34.997  20.623  34.317  1.00 24.00           C  
ATOM    393  O   ALA A  48      35.885  21.223  33.718  1.00 25.71           O  
ATOM    394  CB  ALA A  48      32.798  21.061  33.287  1.00 25.96           C  
ATOM    395  N   TYR A  49      35.156  19.391  34.775  1.00 24.37           N  
ATOM    396  CA  TYR A  49      36.426  18.734  34.569  1.00 25.68           C  
ATOM    397  C   TYR A  49      36.635  18.540  33.066  1.00 24.59           C  
ATOM    398  O   TYR A  49      37.669  18.942  32.539  1.00 21.79           O  
ATOM    399  CB  TYR A  49      36.524  17.400  35.329  1.00 30.44           C  
ATOM    400  CG  TYR A  49      37.880  16.784  35.128  1.00 37.73           C  
ATOM    401  CD1 TYR A  49      38.987  17.236  35.854  1.00 39.29           C  
ATOM    402  CD2 TYR A  49      38.100  15.873  34.094  1.00 35.79           C  
ATOM    403  CE1 TYR A  49      40.285  16.801  35.532  1.00 44.68           C  
ATOM    404  CE2 TYR A  49      39.381  15.437  33.767  1.00 35.77           C  
ATOM    405  CZ  TYR A  49      40.470  15.903  34.479  1.00 43.65           C  
ATOM    406  OH  TYR A  49      41.738  15.502  34.105  1.00 47.02           O  
ATOM    407  N   HIS A  50      35.637  17.981  32.372  1.00 23.44           N  
ATOM    408  CA  HIS A  50      35.743  17.756  30.922  1.00 18.11           C  
ATOM    409  C   HIS A  50      35.242  18.940  30.135  1.00 15.99           C  
ATOM    410  O   HIS A  50      34.276  19.588  30.523  1.00 20.11           O  
ATOM    411  CB  HIS A  50      34.968  16.506  30.491  1.00 18.82           C  
ATOM    412  CG  HIS A  50      35.525  15.225  31.038  1.00 20.50           C  
ATOM    413  ND1 HIS A  50      34.806  14.399  31.872  1.00 24.36           N  
ATOM    414  CD2 HIS A  50      36.716  14.609  30.838  1.00 19.48           C  
ATOM    415  CE1 HIS A  50      35.523  13.326  32.160  1.00 18.13           C  
ATOM    416  NE2 HIS A  50      36.688  13.431  31.546  1.00 19.56           N  
ATOM    417  N   SER A  51      35.895  19.212  29.017  1.00 13.95           N  
ATOM    418  CA  SER A  51      35.515  20.315  28.155  1.00 16.49           C  
ATOM    419  C   SER A  51      34.159  20.072  27.499  1.00 16.07           C  
ATOM    420  O   SER A  51      33.611  18.971  27.550  1.00 16.13           O  
ATOM    421  CB  SER A  51      36.576  20.537  27.070  1.00 19.53           C  
ATOM    422  OG  SER A  51      36.631  19.432  26.196  1.00 27.81           O  
ATOM    423  N   TYR A  52      33.597  21.133  26.939  1.00 16.26           N  
ATOM    424  CA  TYR A  52      32.320  21.047  26.258  1.00 17.53           C  
ATOM    425  C   TYR A  52      32.428  20.044  25.119  1.00 15.62           C  
ATOM    426  O   TYR A  52      31.539  19.215  24.947  1.00 18.05           O  
ATOM    427  CB  TYR A  52      31.917  22.418  25.717  1.00 16.06           C  
ATOM    428  CG  TYR A  52      30.758  22.365  24.771  1.00 13.90           C  
ATOM    429  CD1 TYR A  52      29.455  22.303  25.243  1.00 16.42           C  
ATOM    430  CD2 TYR A  52      30.967  22.335  23.394  1.00 16.65           C  
ATOM    431  CE1 TYR A  52      28.391  22.208  24.366  1.00 16.93           C  
ATOM    432  CE2 TYR A  52      29.910  22.234  22.509  1.00 17.05           C  
ATOM    433  CZ  TYR A  52      28.626  22.170  23.005  1.00 18.82           C  
ATOM    434  OH  TYR A  52      27.573  22.069  22.133  1.00 18.05           O  
ATOM    435  N   GLU A  53      33.510  20.121  24.349  1.00 15.12           N  
ATOM    436  CA  GLU A  53      33.703  19.202  23.240  1.00 20.68           C  
ATOM    437  C   GLU A  53      33.750  17.745  23.670  1.00 20.90           C  
ATOM    438  O   GLU A  53      33.205  16.878  22.988  1.00 22.73           O  
ATOM    439  CB  GLU A  53      34.932  19.556  22.419  1.00 26.81           C  
ATOM    440  CG  GLU A  53      34.644  20.562  21.289  1.00 50.77           C  
ATOM    441  CD  GLU A  53      33.564  20.095  20.268  1.00 61.39           C  
ATOM    442  OE1 GLU A  53      33.455  18.879  19.969  1.00 65.46           O  
ATOM    443  OE2 GLU A  53      32.825  20.967  19.748  1.00 66.54           O  
ATOM    444  N   HIS A  54      34.380  17.461  24.800  1.00 17.01           N  
ATOM    445  CA  HIS A  54      34.432  16.094  25.257  1.00 13.65           C  
ATOM    446  C   HIS A  54      33.185  15.617  25.939  1.00 17.71           C  
ATOM    447  O   HIS A  54      32.890  14.433  25.878  1.00 20.36           O  
ATOM    448  CB  HIS A  54      35.659  15.863  26.101  1.00 22.81           C  
ATOM    449  CG  HIS A  54      36.912  15.946  25.301  1.00 29.84           C  
ATOM    450  ND1 HIS A  54      38.121  16.340  25.832  1.00 27.60           N  
ATOM    451  CD2 HIS A  54      37.123  15.749  23.979  1.00 32.55           C  
ATOM    452  CE1 HIS A  54      39.020  16.395  24.867  1.00 33.30           C  
ATOM    453  NE2 HIS A  54      38.441  16.038  23.732  1.00 39.60           N  
ATOM    454  N   ARG A  55      32.459  16.524  26.587  1.00 14.72           N  
ATOM    455  CA  ARG A  55      31.196  16.175  27.242  1.00 13.89           C  
ATOM    456  C   ARG A  55      30.125  15.859  26.175  1.00 13.99           C  
ATOM    457  O   ARG A  55      29.312  14.961  26.344  1.00 14.68           O  
ATOM    458  CB  ARG A  55      30.731  17.315  28.156  1.00 12.26           C  
ATOM    459  CG  ARG A  55      31.508  17.396  29.481  1.00  8.44           C  
ATOM    460  CD  ARG A  55      30.996  18.524  30.443  1.00 12.10           C  
ATOM    461  NE  ARG A  55      31.442  19.854  30.023  1.00  9.64           N  
ATOM    462  CZ  ARG A  55      30.629  20.863  29.727  1.00 10.28           C  
ATOM    463  NH1 ARG A  55      29.318  20.718  29.835  1.00 14.14           N  
ATOM    464  NH2 ARG A  55      31.133  22.028  29.345  1.00 11.61           N  
ATOM    465  N   LYS A  56      30.145  16.615  25.083  1.00 10.89           N  
ATOM    466  CA  LYS A  56      29.220  16.449  23.971  1.00 13.06           C  
ATOM    467  C   LYS A  56      29.517  15.121  23.257  1.00 15.88           C  
ATOM    468  O   LYS A  56      28.612  14.350  22.944  1.00 19.41           O  
ATOM    469  CB  LYS A  56      29.419  17.610  23.005  1.00 11.56           C  
ATOM    470  CG  LYS A  56      28.716  17.471  21.648  1.00 15.50           C  
ATOM    471  CD  LYS A  56      28.987  18.714  20.842  1.00 18.24           C  
ATOM    472  CE  LYS A  56      27.938  18.961  19.779  1.00 20.55           C  
ATOM    473  NZ  LYS A  56      28.214  18.206  18.531  1.00 27.29           N  
ATOM    474  N   LEU A  57      30.794  14.904  22.965  1.00 17.32           N  
ATOM    475  CA  LEU A  57      31.288  13.705  22.312  1.00 19.52           C  
ATOM    476  C   LEU A  57      30.808  12.454  23.050  1.00 19.94           C  
ATOM    477  O   LEU A  57      30.338  11.502  22.434  1.00 19.15           O  
ATOM    478  CB  LEU A  57      32.823  13.755  22.289  1.00 31.47           C  
ATOM    479  CG  LEU A  57      33.755  12.680  21.690  1.00 40.60           C  
ATOM    480  CD1 LEU A  57      35.179  13.221  21.730  1.00 46.59           C  
ATOM    481  CD2 LEU A  57      33.714  11.355  22.440  1.00 44.42           C  
ATOM    482  N   ILE A  58      30.971  12.436  24.366  1.00 13.63           N  
ATOM    483  CA  ILE A  58      30.547  11.297  25.162  1.00 12.30           C  
ATOM    484  C   ILE A  58      29.032  11.188  25.199  1.00 14.66           C  
ATOM    485  O   ILE A  58      28.492  10.085  25.149  1.00 15.26           O  
ATOM    486  CB  ILE A  58      31.132  11.359  26.606  1.00 19.18           C  
ATOM    487  CG1 ILE A  58      32.662  11.226  26.556  1.00 18.11           C  
ATOM    488  CG2 ILE A  58      30.556  10.258  27.472  1.00 18.80           C  
ATOM    489  CD1 ILE A  58      33.333  11.479  27.872  1.00 26.23           C  
ATOM    490  N   LEU A  59      28.333  12.312  25.279  1.00 13.99           N  
ATOM    491  CA  LEU A  59      26.863  12.250  25.322  1.00 18.97           C  
ATOM    492  C   LEU A  59      26.264  11.717  24.012  1.00 18.19           C  
ATOM    493  O   LEU A  59      25.228  11.046  24.003  1.00 16.00           O  
ATOM    494  CB  LEU A  59      26.249  13.617  25.667  1.00 18.01           C  
ATOM    495  CG  LEU A  59      26.031  13.919  27.154  1.00 18.78           C  
ATOM    496  CD1 LEU A  59      25.390  15.266  27.291  1.00 25.18           C  
ATOM    497  CD2 LEU A  59      25.152  12.876  27.806  1.00 16.28           C  
ATOM    498  N   GLU A  60      26.919  12.029  22.907  1.00 17.60           N  
ATOM    499  CA  GLU A  60      26.449  11.574  21.620  1.00 19.21           C  
ATOM    500  C   GLU A  60      26.543  10.069  21.413  1.00 22.65           C  
ATOM    501  O   GLU A  60      25.958   9.560  20.464  1.00 24.75           O  
ATOM    502  CB  GLU A  60      27.179  12.317  20.515  1.00 17.95           C  
ATOM    503  CG  GLU A  60      26.845  13.801  20.523  1.00 20.46           C  
ATOM    504  CD  GLU A  60      27.603  14.571  19.495  1.00 18.50           C  
ATOM    505  OE1 GLU A  60      28.752  14.184  19.203  1.00 27.72           O  
ATOM    506  OE2 GLU A  60      27.059  15.572  18.985  1.00 19.90           O  
ATOM    507  N   THR A  61      27.268   9.357  22.279  1.00 19.63           N  
ATOM    508  CA  THR A  61      27.395   7.903  22.150  1.00 15.91           C  
ATOM    509  C   THR A  61      26.381   7.153  23.011  1.00 15.82           C  
ATOM    510  O   THR A  61      26.256   5.929  22.893  1.00 17.54           O  
ATOM    511  CB  THR A  61      28.831   7.382  22.479  1.00 13.27           C  
ATOM    512  OG1 THR A  61      29.030   7.384  23.888  1.00 19.04           O  
ATOM    513  CG2 THR A  61      29.891   8.246  21.849  1.00 13.93           C  
ATOM    514  N   ILE A  62      25.659   7.869  23.877  1.00 10.33           N  
ATOM    515  CA  ILE A  62      24.649   7.233  24.725  1.00 11.15           C  
ATOM    516  C   ILE A  62      23.460   6.941  23.815  1.00 13.41           C  
ATOM    517  O   ILE A  62      23.006   7.813  23.082  1.00 15.06           O  
ATOM    518  CB  ILE A  62      24.165   8.171  25.876  1.00 12.65           C  
ATOM    519  CG1 ILE A  62      25.357   8.717  26.668  1.00 21.08           C  
ATOM    520  CG2 ILE A  62      23.204   7.455  26.794  1.00  3.70           C  
ATOM    521  CD1 ILE A  62      26.240   7.657  27.252  1.00 25.77           C  
ATOM    522  N   ARG A  63      22.950   5.725  23.885  1.00 13.90           N  
ATOM    523  CA  ARG A  63      21.832   5.306  23.051  1.00 20.84           C  
ATOM    524  C   ARG A  63      20.611   6.200  23.083  1.00 20.48           C  
ATOM    525  O   ARG A  63      19.931   6.342  22.074  1.00 22.24           O  
ATOM    526  CB  ARG A  63      21.388   3.908  23.455  1.00 23.76           C  
ATOM    527  CG  ARG A  63      22.352   2.837  23.070  1.00 30.44           C  
ATOM    528  CD  ARG A  63      22.051   1.522  23.798  1.00 38.53           C  
ATOM    529  NE  ARG A  63      23.222   0.649  23.737  1.00 43.15           N  
ATOM    530  CZ  ARG A  63      23.674   0.083  22.624  1.00 51.15           C  
ATOM    531  NH1 ARG A  63      23.040   0.266  21.468  1.00 56.45           N  
ATOM    532  NH2 ARG A  63      24.822  -0.574  22.642  1.00 54.05           N  
ATOM    533  N   TYR A  64      20.316   6.752  24.257  1.00 17.73           N  
ATOM    534  CA  TYR A  64      19.148   7.604  24.463  1.00 19.11           C  
ATOM    535  C   TYR A  64      19.214   9.003  23.853  1.00 16.77           C  
ATOM    536  O   TYR A  64      18.193   9.667  23.667  1.00 22.39           O  
ATOM    537  CB  TYR A  64      18.906   7.785  25.965  1.00 18.21           C  
ATOM    538  CG  TYR A  64      18.869   6.516  26.752  1.00 15.84           C  
ATOM    539  CD1 TYR A  64      17.961   5.516  26.446  1.00 19.97           C  
ATOM    540  CD2 TYR A  64      19.755   6.307  27.808  1.00 12.24           C  
ATOM    541  CE1 TYR A  64      17.935   4.328  27.164  1.00 20.81           C  
ATOM    542  CE2 TYR A  64      19.737   5.123  28.536  1.00 17.47           C  
ATOM    543  CZ  TYR A  64      18.829   4.136  28.208  1.00 18.06           C  
ATOM    544  OH  TYR A  64      18.825   2.952  28.908  1.00 20.24           O  
ATOM    545  N   VAL A  65      20.417   9.478  23.601  1.00 15.67           N  
ATOM    546  CA  VAL A  65      20.573  10.824  23.117  1.00 13.08           C  
ATOM    547  C   VAL A  65      20.552  10.938  21.610  1.00 18.22           C  
ATOM    548  O   VAL A  65      21.348  10.310  20.922  1.00 21.25           O  
ATOM    549  CB  VAL A  65      21.841  11.439  23.724  1.00 12.64           C  
ATOM    550  CG1 VAL A  65      22.015  12.861  23.266  1.00 16.05           C  
ATOM    551  CG2 VAL A  65      21.735  11.392  25.251  1.00  9.11           C  
ATOM    552  N   ASP A  66      19.664  11.783  21.100  1.00 15.15           N  
ATOM    553  CA  ASP A  66      19.533  11.960  19.665  1.00 13.52           C  
ATOM    554  C   ASP A  66      20.304  13.129  19.136  1.00 15.10           C  
ATOM    555  O   ASP A  66      20.860  13.073  18.029  1.00 16.68           O  
ATOM    556  CB  ASP A  66      18.047  12.083  19.286  1.00 17.21           C  
ATOM    557  CG  ASP A  66      17.300  10.780  19.465  1.00 11.53           C  
ATOM    558  OD1 ASP A  66      17.564   9.849  18.677  1.00 22.75           O  
ATOM    559  OD2 ASP A  66      16.494  10.661  20.411  1.00 13.97           O  
ATOM    560  N   GLU A  67      20.371  14.181  19.942  1.00 11.66           N  
ATOM    561  CA  GLU A  67      21.060  15.384  19.524  1.00 12.66           C  
ATOM    562  C   GLU A  67      21.542  16.127  20.760  1.00 13.98           C  
ATOM    563  O   GLU A  67      20.940  16.000  21.827  1.00 11.56           O  
ATOM    564  CB  GLU A  67      20.081  16.240  18.742  1.00  9.56           C  
ATOM    565  CG  GLU A  67      20.645  17.533  18.199  1.00 17.41           C  
ATOM    566  CD  GLU A  67      19.641  18.274  17.313  1.00 23.27           C  
ATOM    567  OE1 GLU A  67      18.495  17.802  17.158  1.00 18.70           O  
ATOM    568  OE2 GLU A  67      20.000  19.330  16.763  1.00 27.11           O  
ATOM    569  N   VAL A  68      22.666  16.823  20.621  1.00 16.81           N  
ATOM    570  CA  VAL A  68      23.271  17.626  21.690  1.00 17.86           C  
ATOM    571  C   VAL A  68      23.488  19.059  21.175  1.00 15.94           C  
ATOM    572  O   VAL A  68      24.089  19.259  20.130  1.00 17.50           O  
ATOM    573  CB  VAL A  68      24.646  17.044  22.131  1.00 15.29           C  
ATOM    574  CG1 VAL A  68      25.326  17.978  23.127  1.00 16.07           C  
ATOM    575  CG2 VAL A  68      24.463  15.672  22.761  1.00 15.74           C  
ATOM    576  N   ILE A  69      22.958  20.056  21.878  1.00 16.85           N  
ATOM    577  CA  ILE A  69      23.140  21.451  21.463  1.00 10.99           C  
ATOM    578  C   ILE A  69      23.806  22.222  22.604  1.00 11.26           C  
ATOM    579  O   ILE A  69      23.811  21.775  23.750  1.00 13.34           O  
ATOM    580  CB  ILE A  69      21.788  22.134  21.095  1.00 17.37           C  
ATOM    581  CG1 ILE A  69      20.818  22.112  22.286  1.00 10.67           C  
ATOM    582  CG2 ILE A  69      21.184  21.461  19.874  1.00 14.90           C  
ATOM    583  CD1 ILE A  69      19.525  22.857  22.054  1.00 14.46           C  
ATOM    584  N   PRO A  70      24.398  23.374  22.305  1.00 11.76           N  
ATOM    585  CA  PRO A  70      25.049  24.119  23.394  1.00 12.51           C  
ATOM    586  C   PRO A  70      24.094  24.964  24.236  1.00 17.25           C  
ATOM    587  O   PRO A  70      23.108  25.488  23.712  1.00 17.85           O  
ATOM    588  CB  PRO A  70      26.048  24.996  22.647  1.00 10.55           C  
ATOM    589  CG  PRO A  70      25.352  25.268  21.331  1.00 13.70           C  
ATOM    590  CD  PRO A  70      24.744  23.922  20.980  1.00  7.48           C  
ATOM    591  N   GLU A  71      24.306  24.986  25.549  1.00 13.73           N  
ATOM    592  CA  GLU A  71      23.509  25.853  26.432  1.00 16.44           C  
ATOM    593  C   GLU A  71      24.487  26.998  26.748  1.00 17.84           C  
ATOM    594  O   GLU A  71      25.481  26.789  27.453  1.00 17.71           O  
ATOM    595  CB  GLU A  71      23.097  25.151  27.716  1.00  9.13           C  
ATOM    596  CG  GLU A  71      22.313  26.076  28.667  1.00  7.61           C  
ATOM    597  CD  GLU A  71      22.179  25.517  30.057  1.00 10.73           C  
ATOM    598  OE1 GLU A  71      23.029  24.699  30.458  1.00 20.18           O  
ATOM    599  OE2 GLU A  71      21.239  25.902  30.776  1.00 16.82           O  
ATOM    600  N   LYS A  72      24.200  28.189  26.228  1.00 15.53           N  
ATOM    601  CA  LYS A  72      25.078  29.347  26.373  1.00 19.62           C  
ATOM    602  C   LYS A  72      24.684  30.376  27.418  1.00 20.11           C  
ATOM    603  O   LYS A  72      25.524  31.167  27.853  1.00 22.11           O  
ATOM    604  CB  LYS A  72      25.195  30.074  25.028  1.00 21.87           C  
ATOM    605  CG  LYS A  72      25.399  29.173  23.836  1.00 27.43           C  
ATOM    606  CD  LYS A  72      25.490  29.973  22.566  1.00 29.61           C  
ATOM    607  CE  LYS A  72      25.682  29.063  21.375  1.00 40.20           C  
ATOM    608  NZ  LYS A  72      25.720  29.825  20.087  1.00 48.15           N  
ATOM    609  N   ASN A  73      23.403  30.410  27.769  1.00 16.64           N  
ATOM    610  CA  ASN A  73      22.905  31.367  28.745  1.00 13.63           C  
ATOM    611  C   ASN A  73      21.599  30.895  29.361  1.00 16.78           C  
ATOM    612  O   ASN A  73      21.067  29.867  28.954  1.00 22.00           O  
ATOM    613  CB  ASN A  73      22.761  32.758  28.118  1.00 17.96           C  
ATOM    614  CG  ASN A  73      21.851  32.771  26.895  1.00 18.39           C  
ATOM    615  OD1 ASN A  73      20.682  32.387  26.964  1.00 24.07           O  
ATOM    616  ND2 ASN A  73      22.383  33.240  25.774  1.00 17.51           N  
ATOM    617  N   TRP A  74      21.118  31.613  30.376  1.00 18.17           N  
ATOM    618  CA  TRP A  74      19.887  31.257  31.091  1.00 17.44           C  
ATOM    619  C   TRP A  74      18.603  31.596  30.325  1.00 21.21           C  
ATOM    620  O   TRP A  74      17.555  31.013  30.556  1.00 23.56           O  
ATOM    621  CB  TRP A  74      19.823  31.988  32.441  1.00 15.38           C  
ATOM    622  CG  TRP A  74      20.888  31.652  33.472  1.00 10.43           C  
ATOM    623  CD1 TRP A  74      21.974  32.409  33.797  1.00 18.81           C  
ATOM    624  CD2 TRP A  74      20.912  30.526  34.359  1.00  9.07           C  
ATOM    625  NE1 TRP A  74      22.672  31.830  34.840  1.00 11.09           N  
ATOM    626  CE2 TRP A  74      22.041  30.672  35.199  1.00  9.00           C  
ATOM    627  CE3 TRP A  74      20.093  29.400  34.518  1.00 11.84           C  
ATOM    628  CZ2 TRP A  74      22.375  29.743  36.181  1.00  8.41           C  
ATOM    629  CZ3 TRP A  74      20.426  28.467  35.499  1.00 16.81           C  
ATOM    630  CH2 TRP A  74      21.565  28.650  36.320  1.00 12.39           C  
ATOM    631  N   GLU A  75      18.680  32.591  29.451  1.00 22.70           N  
ATOM    632  CA  GLU A  75      17.516  33.052  28.708  1.00 28.07           C  
ATOM    633  C   GLU A  75      17.123  32.295  27.442  1.00 27.10           C  
ATOM    634  O   GLU A  75      16.040  32.512  26.922  1.00 28.25           O  
ATOM    635  CB  GLU A  75      17.686  34.543  28.365  1.00 36.41           C  
ATOM    636  CG  GLU A  75      17.534  35.515  29.561  1.00 53.34           C  
ATOM    637  CD  GLU A  75      16.083  35.643  30.048  1.00 62.80           C  
ATOM    638  OE1 GLU A  75      15.186  35.884  29.203  1.00 68.61           O  
ATOM    639  OE2 GLU A  75      15.838  35.501  31.271  1.00 66.78           O  
ATOM    640  N   GLN A  76      17.978  31.406  26.961  1.00 19.24           N  
ATOM    641  CA  GLN A  76      17.686  30.706  25.722  1.00 22.16           C  
ATOM    642  C   GLN A  76      16.569  29.666  25.695  1.00 18.23           C  
ATOM    643  O   GLN A  76      16.138  29.270  24.615  1.00 21.25           O  
ATOM    644  CB  GLN A  76      18.965  30.073  25.176  1.00 18.11           C  
ATOM    645  CG  GLN A  76      19.439  28.874  25.976  1.00 16.87           C  
ATOM    646  CD  GLN A  76      20.661  28.256  25.366  1.00 17.84           C  
ATOM    647  OE1 GLN A  76      21.740  28.825  25.410  1.00 23.22           O  
ATOM    648  NE2 GLN A  76      20.492  27.096  24.746  1.00 19.95           N  
ATOM    649  N   LYS A  77      16.100  29.213  26.851  1.00 16.59           N  
ATOM    650  CA  LYS A  77      15.071  28.177  26.885  1.00 17.86           C  
ATOM    651  C   LYS A  77      13.805  28.313  26.020  1.00 23.28           C  
ATOM    652  O   LYS A  77      13.425  27.368  25.334  1.00 23.13           O  
ATOM    653  CB  LYS A  77      14.700  27.828  28.328  1.00 20.31           C  
ATOM    654  CG  LYS A  77      15.834  27.177  29.103  1.00 13.39           C  
ATOM    655  CD  LYS A  77      15.343  26.697  30.431  1.00 15.14           C  
ATOM    656  CE  LYS A  77      16.450  25.939  31.137  1.00 19.38           C  
ATOM    657  NZ  LYS A  77      17.616  26.823  31.439  1.00 21.92           N  
ATOM    658  N   LYS A  78      13.138  29.455  26.053  1.00 24.42           N  
ATOM    659  CA  LYS A  78      11.931  29.621  25.254  1.00 28.60           C  
ATOM    660  C   LYS A  78      12.176  29.518  23.740  1.00 25.91           C  
ATOM    661  O   LYS A  78      11.385  28.914  23.022  1.00 25.22           O  
ATOM    662  CB  LYS A  78      11.222  30.931  25.610  1.00 35.25           C  
ATOM    663  CG  LYS A  78       9.971  31.194  24.783  1.00 45.01           C  
ATOM    664  CD  LYS A  78       9.019  32.164  25.464  1.00 55.94           C  
ATOM    665  CE  LYS A  78       8.495  31.581  26.779  1.00 66.43           C  
ATOM    666  NZ  LYS A  78       7.188  32.177  27.235  1.00 72.99           N  
ATOM    667  N   GLN A  79      13.275  30.085  23.263  1.00 21.04           N  
ATOM    668  CA  GLN A  79      13.594  30.031  21.851  1.00 22.35           C  
ATOM    669  C   GLN A  79      14.037  28.643  21.413  1.00 23.31           C  
ATOM    670  O   GLN A  79      13.887  28.294  20.250  1.00 23.11           O  
ATOM    671  CB  GLN A  79      14.681  31.034  21.500  1.00 27.19           C  
ATOM    672  CG  GLN A  79      14.752  31.354  20.019  1.00 29.04           C  
ATOM    673  CD  GLN A  79      13.487  32.007  19.511  1.00 31.09           C  
ATOM    674  OE1 GLN A  79      12.838  32.786  20.213  1.00 36.90           O  
ATOM    675  NE2 GLN A  79      13.126  31.690  18.281  1.00 34.45           N  
ATOM    676  N   ASP A  80      14.657  27.888  22.314  1.00 21.03           N  
ATOM    677  CA  ASP A  80      15.088  26.529  22.002  1.00 15.73           C  
ATOM    678  C   ASP A  80      13.858  25.684  21.742  1.00 13.96           C  
ATOM    679  O   ASP A  80      13.874  24.843  20.860  1.00 17.20           O  
ATOM    680  CB  ASP A  80      15.816  25.920  23.194  1.00 14.24           C  
ATOM    681  CG  ASP A  80      17.262  26.332  23.276  1.00 16.83           C  
ATOM    682  OD1 ASP A  80      17.778  27.022  22.360  1.00 17.03           O  
ATOM    683  OD2 ASP A  80      17.887  25.949  24.286  1.00 19.63           O  
ATOM    684  N   ILE A  81      12.852  25.833  22.606  1.00 12.64           N  
ATOM    685  CA  ILE A  81      11.590  25.108  22.499  1.00 16.56           C  
ATOM    686  C   ILE A  81      10.958  25.404  21.139  1.00 20.26           C  
ATOM    687  O   ILE A  81      10.364  24.515  20.522  1.00 21.67           O  
ATOM    688  CB  ILE A  81      10.631  25.460  23.669  1.00 19.01           C  
ATOM    689  CG1 ILE A  81      10.906  24.550  24.870  1.00 22.67           C  
ATOM    690  CG2 ILE A  81       9.173  25.253  23.272  1.00 20.11           C  
ATOM    691  CD1 ILE A  81      12.316  24.554  25.338  1.00 35.64           C  
ATOM    692  N   ILE A  82      11.114  26.644  20.671  1.00 21.64           N  
ATOM    693  CA  ILE A  82      10.601  27.077  19.370  1.00 22.81           C  
ATOM    694  C   ILE A  82      11.489  26.547  18.251  1.00 22.44           C  
ATOM    695  O   ILE A  82      11.025  25.825  17.380  1.00 24.72           O  
ATOM    696  CB  ILE A  82      10.499  28.623  19.273  1.00 23.71           C  
ATOM    697  CG1 ILE A  82       9.472  29.130  20.294  1.00 22.51           C  
ATOM    698  CG2 ILE A  82      10.115  29.060  17.845  1.00 19.30           C  
ATOM    699  CD1 ILE A  82       9.279  30.642  20.297  1.00 27.67           C  
ATOM    700  N   ASP A  83      12.776  26.862  18.318  1.00 21.43           N  
ATOM    701  CA  ASP A  83      13.738  26.417  17.319  1.00 21.66           C  
ATOM    702  C   ASP A  83      13.802  24.900  17.064  1.00 20.70           C  
ATOM    703  O   ASP A  83      14.041  24.466  15.946  1.00 22.32           O  
ATOM    704  CB  ASP A  83      15.135  26.919  17.690  1.00 20.81           C  
ATOM    705  CG  ASP A  83      15.287  28.431  17.537  1.00 28.30           C  
ATOM    706  OD1 ASP A  83      14.324  29.120  17.128  1.00 28.92           O  
ATOM    707  OD2 ASP A  83      16.393  28.935  17.825  1.00 30.35           O  
ATOM    708  N   HIS A  84      13.627  24.093  18.099  1.00 17.15           N  
ATOM    709  CA  HIS A  84      13.719  22.651  17.938  1.00 12.24           C  
ATOM    710  C   HIS A  84      12.398  21.936  17.987  1.00 13.31           C  
ATOM    711  O   HIS A  84      12.349  20.711  18.109  1.00 13.54           O  
ATOM    712  CB  HIS A  84      14.636  22.099  19.019  1.00 16.08           C  
ATOM    713  CG  HIS A  84      16.039  22.591  18.899  1.00 16.40           C  
ATOM    714  ND1 HIS A  84      16.956  22.002  18.062  1.00 19.95           N  
ATOM    715  CD2 HIS A  84      16.658  23.665  19.439  1.00 18.64           C  
ATOM    716  CE1 HIS A  84      18.079  22.696  18.077  1.00 17.71           C  
ATOM    717  NE2 HIS A  84      17.925  23.712  18.906  1.00 18.15           N  
ATOM    718  N   ASN A  85      11.326  22.717  17.995  1.00 18.41           N  
ATOM    719  CA  ASN A  85       9.961  22.196  18.046  1.00 15.97           C  
ATOM    720  C   ASN A  85       9.784  21.171  19.126  1.00 14.30           C  
ATOM    721  O   ASN A  85       9.280  20.079  18.894  1.00 12.86           O  
ATOM    722  CB  ASN A  85       9.555  21.645  16.680  1.00 20.79           C  
ATOM    723  CG  ASN A  85       9.519  22.725  15.627  1.00 21.14           C  
ATOM    724  OD1 ASN A  85       8.807  23.725  15.772  1.00 25.57           O  
ATOM    725  ND2 ASN A  85      10.322  22.564  14.591  1.00 23.85           N  
ATOM    726  N   ILE A  86      10.144  21.572  20.340  1.00 12.93           N  
ATOM    727  CA  ILE A  86      10.063  20.703  21.500  1.00 11.40           C  
ATOM    728  C   ILE A  86       8.631  20.515  22.008  1.00 15.45           C  
ATOM    729  O   ILE A  86       7.867  21.484  22.138  1.00 16.53           O  
ATOM    730  CB  ILE A  86      10.978  21.252  22.666  1.00  9.37           C  
ATOM    731  CG1 ILE A  86      12.437  21.320  22.219  1.00  9.62           C  
ATOM    732  CG2 ILE A  86      10.795  20.441  23.929  1.00  9.64           C  
ATOM    733  CD1 ILE A  86      13.003  20.025  21.643  1.00  9.99           C  
ATOM    734  N   ASP A  87       8.294  19.273  22.348  1.00 12.30           N  
ATOM    735  CA  ASP A  87       6.978  18.939  22.875  1.00 14.31           C  
ATOM    736  C   ASP A  87       7.014  18.701  24.374  1.00 14.20           C  
ATOM    737  O   ASP A  87       6.027  18.938  25.076  1.00 13.51           O  
ATOM    738  CB  ASP A  87       6.442  17.689  22.181  1.00 15.64           C  
ATOM    739  CG  ASP A  87       6.324  17.880  20.682  1.00 21.78           C  
ATOM    740  OD1 ASP A  87       5.391  18.597  20.273  1.00 19.72           O  
ATOM    741  OD2 ASP A  87       7.195  17.370  19.927  1.00 20.66           O  
ATOM    742  N   VAL A  88       8.139  18.179  24.861  1.00 14.02           N  
ATOM    743  CA  VAL A  88       8.290  17.887  26.287  1.00 13.16           C  
ATOM    744  C   VAL A  88       9.600  18.492  26.793  1.00 16.64           C  
ATOM    745  O   VAL A  88      10.636  18.348  26.151  1.00 14.81           O  
ATOM    746  CB  VAL A  88       8.338  16.355  26.573  1.00 15.06           C  
ATOM    747  CG1 VAL A  88       8.356  16.101  28.067  1.00 11.93           C  
ATOM    748  CG2 VAL A  88       7.149  15.628  25.934  1.00 16.19           C  
ATOM    749  N   PHE A  89       9.530  19.200  27.923  1.00 18.33           N  
ATOM    750  CA  PHE A  89      10.703  19.820  28.564  1.00 15.82           C  
ATOM    751  C   PHE A  89      10.891  19.077  29.893  1.00 13.26           C  
ATOM    752  O   PHE A  89       9.970  19.016  30.710  1.00 11.96           O  
ATOM    753  CB  PHE A  89      10.422  21.311  28.800  1.00 19.41           C  
ATOM    754  CG  PHE A  89      11.467  22.026  29.608  1.00 10.79           C  
ATOM    755  CD1 PHE A  89      11.364  22.088  30.992  1.00 17.07           C  
ATOM    756  CD2 PHE A  89      12.516  22.677  28.989  1.00 13.05           C  
ATOM    757  CE1 PHE A  89      12.290  22.790  31.758  1.00 14.93           C  
ATOM    758  CE2 PHE A  89      13.458  23.391  29.742  1.00 21.88           C  
ATOM    759  CZ  PHE A  89      13.342  23.445  31.134  1.00 16.65           C  
ATOM    760  N   VAL A  90      12.061  18.480  30.093  1.00 12.31           N  
ATOM    761  CA  VAL A  90      12.308  17.726  31.323  1.00 10.89           C  
ATOM    762  C   VAL A  90      13.478  18.282  32.115  1.00 12.51           C  
ATOM    763  O   VAL A  90      14.491  18.661  31.537  1.00 12.55           O  
ATOM    764  CB  VAL A  90      12.590  16.220  31.033  1.00 16.67           C  
ATOM    765  CG1 VAL A  90      12.609  15.430  32.322  1.00 15.55           C  
ATOM    766  CG2 VAL A  90      11.533  15.654  30.141  1.00 15.29           C  
ATOM    767  N   MET A  91      13.295  18.400  33.431  1.00 17.68           N  
ATOM    768  CA  MET A  91      14.329  18.894  34.357  1.00 21.03           C  
ATOM    769  C   MET A  91      14.233  18.105  35.648  1.00 20.34           C  
ATOM    770  O   MET A  91      13.222  17.452  35.915  1.00 18.37           O  
ATOM    771  CB  MET A  91      14.158  20.382  34.697  1.00 18.75           C  
ATOM    772  CG  MET A  91      14.617  21.345  33.614  1.00 23.44           C  
ATOM    773  SD  MET A  91      16.317  21.107  33.014  1.00 22.57           S  
ATOM    774  CE  MET A  91      17.186  22.349  34.045  1.00 25.53           C  
ATOM    775  N   GLY A  92      15.293  18.152  36.449  1.00 22.36           N  
ATOM    776  CA  GLY A  92      15.276  17.428  37.708  1.00 19.75           C  
ATOM    777  C   GLY A  92      14.304  18.161  38.596  1.00 17.94           C  
ATOM    778  O   GLY A  92      14.128  19.367  38.426  1.00 19.85           O  
ATOM    779  N   ASP A  93      13.687  17.464  39.544  1.00 24.62           N  
ATOM    780  CA  ASP A  93      12.720  18.115  40.422  1.00 25.71           C  
ATOM    781  C   ASP A  93      13.323  19.170  41.356  1.00 28.96           C  
ATOM    782  O   ASP A  93      12.607  19.801  42.131  1.00 26.18           O  
ATOM    783  CB  ASP A  93      11.877  17.092  41.187  1.00 26.44           C  
ATOM    784  CG  ASP A  93      12.683  16.252  42.164  1.00 33.62           C  
ATOM    785  OD1 ASP A  93      13.932  16.356  42.241  1.00 35.41           O  
ATOM    786  OD2 ASP A  93      12.031  15.463  42.876  1.00 43.04           O  
ATOM    787  N   ASP A  94      14.647  19.308  41.327  1.00 30.70           N  
ATOM    788  CA  ASP A  94      15.313  20.335  42.116  1.00 34.70           C  
ATOM    789  C   ASP A  94      15.080  21.693  41.439  1.00 35.51           C  
ATOM    790  O   ASP A  94      15.541  22.728  41.921  1.00 37.43           O  
ATOM    791  CB  ASP A  94      16.821  20.041  42.316  1.00 37.11           C  
ATOM    792  CG  ASP A  94      17.549  19.616  41.033  1.00 44.09           C  
ATOM    793  OD1 ASP A  94      17.064  18.718  40.311  1.00 50.02           O  
ATOM    794  OD2 ASP A  94      18.657  20.139  40.772  1.00 49.84           O  
ATOM    795  N   TRP A  95      14.360  21.664  40.313  1.00 34.33           N  
ATOM    796  CA  TRP A  95      14.004  22.847  39.527  1.00 26.81           C  
ATOM    797  C   TRP A  95      12.482  22.982  39.497  1.00 25.83           C  
ATOM    798  O   TRP A  95      11.929  23.830  38.803  1.00 23.49           O  
ATOM    799  CB  TRP A  95      14.512  22.700  38.103  1.00 23.69           C  
ATOM    800  CG  TRP A  95      15.964  22.565  38.016  1.00 23.40           C  
ATOM    801  CD1 TRP A  95      16.673  21.406  37.972  1.00 25.55           C  
ATOM    802  CD2 TRP A  95      16.913  23.625  37.923  1.00 31.32           C  
ATOM    803  NE1 TRP A  95      18.014  21.672  37.849  1.00 28.67           N  
ATOM    804  CE2 TRP A  95      18.190  23.033  37.817  1.00 33.78           C  
ATOM    805  CE3 TRP A  95      16.812  25.024  37.906  1.00 37.48           C  
ATOM    806  CZ2 TRP A  95      19.367  23.794  37.697  1.00 40.02           C  
ATOM    807  CZ3 TRP A  95      17.979  25.781  37.783  1.00 44.13           C  
ATOM    808  CH2 TRP A  95      19.242  25.160  37.680  1.00 42.93           C  
ATOM    809  N   GLU A  96      11.823  22.113  40.244  1.00 26.90           N  
ATOM    810  CA  GLU A  96      10.382  22.069  40.339  1.00 32.62           C  
ATOM    811  C   GLU A  96       9.755  23.444  40.462  1.00 33.84           C  
ATOM    812  O   GLU A  96       9.932  24.115  41.475  1.00 40.49           O  
ATOM    813  CB  GLU A  96      10.022  21.195  41.535  1.00 41.03           C  
ATOM    814  CG  GLU A  96       8.611  21.315  42.041  1.00 58.64           C  
ATOM    815  CD  GLU A  96       7.590  20.764  41.077  1.00 67.16           C  
ATOM    816  OE1 GLU A  96       7.675  19.561  40.733  1.00 70.11           O  
ATOM    817  OE2 GLU A  96       6.694  21.539  40.676  1.00 76.52           O  
ATOM    818  N   GLY A  97       9.008  23.853  39.440  1.00 29.08           N  
ATOM    819  CA  GLY A  97       8.351  25.153  39.471  1.00 26.25           C  
ATOM    820  C   GLY A  97       9.066  26.363  38.858  1.00 24.76           C  
ATOM    821  O   GLY A  97       8.431  27.384  38.578  1.00 21.32           O  
ATOM    822  N   LYS A  98      10.365  26.246  38.608  1.00 21.38           N  
ATOM    823  CA  LYS A  98      11.134  27.343  38.046  1.00 21.52           C  
ATOM    824  C   LYS A  98      10.847  27.591  36.561  1.00 26.95           C  
ATOM    825  O   LYS A  98      10.954  28.713  36.073  1.00 28.51           O  
ATOM    826  CB  LYS A  98      12.622  27.080  38.260  1.00 18.82           C  
ATOM    827  CG  LYS A  98      13.494  28.255  37.914  1.00 22.40           C  
ATOM    828  CD  LYS A  98      14.876  28.112  38.492  1.00 22.72           C  
ATOM    829  CE  LYS A  98      15.663  29.376  38.235  1.00 25.80           C  
ATOM    830  NZ  LYS A  98      16.925  29.465  39.007  1.00 32.17           N  
ATOM    831  N   PHE A  99      10.480  26.540  35.836  1.00 25.52           N  
ATOM    832  CA  PHE A  99      10.222  26.694  34.416  1.00 20.38           C  
ATOM    833  C   PHE A  99       8.773  26.482  34.023  1.00 20.99           C  
ATOM    834  O   PHE A  99       8.479  26.176  32.861  1.00 20.86           O  
ATOM    835  CB  PHE A  99      11.116  25.737  33.652  1.00 18.65           C  
ATOM    836  CG  PHE A  99      12.564  25.839  34.031  1.00 19.93           C  
ATOM    837  CD1 PHE A  99      13.292  26.986  33.742  1.00 24.18           C  
ATOM    838  CD2 PHE A  99      13.208  24.783  34.653  1.00 23.42           C  
ATOM    839  CE1 PHE A  99      14.652  27.083  34.067  1.00 26.96           C  
ATOM    840  CE2 PHE A  99      14.565  24.868  34.982  1.00 29.01           C  
ATOM    841  CZ  PHE A  99      15.287  26.023  34.686  1.00 28.57           C  
ATOM    842  N   ASP A 100       7.861  26.675  34.971  1.00 22.60           N  
ATOM    843  CA  ASP A 100       6.443  26.476  34.699  1.00 22.30           C  
ATOM    844  C   ASP A 100       5.875  27.446  33.693  1.00 21.47           C  
ATOM    845  O   ASP A 100       4.774  27.231  33.213  1.00 23.78           O  
ATOM    846  CB  ASP A 100       5.608  26.482  35.980  1.00 24.21           C  
ATOM    847  CG  ASP A 100       5.833  25.241  36.833  1.00 24.17           C  
ATOM    848  OD1 ASP A 100       6.887  24.601  36.688  1.00 30.03           O  
ATOM    849  OD2 ASP A 100       4.961  24.900  37.659  1.00 30.02           O  
ATOM    850  N   PHE A 101       6.641  28.476  33.342  1.00 21.69           N  
ATOM    851  CA  PHE A 101       6.186  29.471  32.369  1.00 24.84           C  
ATOM    852  C   PHE A 101       6.259  28.972  30.922  1.00 26.96           C  
ATOM    853  O   PHE A 101       5.841  29.675  29.992  1.00 28.06           O  
ATOM    854  CB  PHE A 101       6.968  30.787  32.504  1.00 19.56           C  
ATOM    855  CG  PHE A 101       8.394  30.688  32.104  1.00 16.66           C  
ATOM    856  CD1 PHE A 101       9.345  30.178  32.990  1.00 18.89           C  
ATOM    857  CD2 PHE A 101       8.793  31.089  30.846  1.00 14.78           C  
ATOM    858  CE1 PHE A 101      10.668  30.071  32.617  1.00 14.06           C  
ATOM    859  CE2 PHE A 101      10.115  30.986  30.468  1.00 18.56           C  
ATOM    860  CZ  PHE A 101      11.058  30.475  31.357  1.00 16.55           C  
ATOM    861  N   LEU A 102       6.901  27.818  30.729  1.00 25.56           N  
ATOM    862  CA  LEU A 102       7.023  27.215  29.399  1.00 21.69           C  
ATOM    863  C   LEU A 102       5.820  26.306  29.122  1.00 16.10           C  
ATOM    864  O   LEU A 102       5.703  25.750  28.040  1.00 15.44           O  
ATOM    865  CB  LEU A 102       8.322  26.408  29.291  1.00 12.56           C  
ATOM    866  CG  LEU A 102       9.641  27.186  29.367  1.00 16.70           C  
ATOM    867  CD1 LEU A 102      10.788  26.212  29.547  1.00 19.22           C  
ATOM    868  CD2 LEU A 102       9.844  28.034  28.126  1.00 13.43           C  
ATOM    869  N   LYS A 103       4.943  26.161  30.106  1.00 14.17           N  
ATOM    870  CA  LYS A 103       3.771  25.319  29.975  1.00 11.23           C  
ATOM    871  C   LYS A 103       2.765  25.679  28.894  1.00 16.10           C  
ATOM    872  O   LYS A 103       1.966  24.846  28.495  1.00 17.90           O  
ATOM    873  CB  LYS A 103       3.079  25.153  31.316  1.00 12.23           C  
ATOM    874  CG  LYS A 103       3.791  24.168  32.207  1.00  9.93           C  
ATOM    875  CD  LYS A 103       3.123  24.024  33.534  1.00 17.22           C  
ATOM    876  CE  LYS A 103       3.860  23.005  34.371  1.00 19.31           C  
ATOM    877  NZ  LYS A 103       3.029  22.593  35.523  1.00 29.92           N  
ATOM    878  N   ASP A 104       2.793  26.905  28.405  1.00 14.44           N  
ATOM    879  CA  ASP A 104       1.856  27.273  27.357  1.00 18.74           C  
ATOM    880  C   ASP A 104       2.455  26.892  26.012  1.00 21.75           C  
ATOM    881  O   ASP A 104       1.830  27.075  24.971  1.00 23.12           O  
ATOM    882  CB  ASP A 104       1.563  28.771  27.390  1.00 21.87           C  
ATOM    883  CG  ASP A 104       2.801  29.620  27.134  1.00 33.61           C  
ATOM    884  OD1 ASP A 104       3.855  29.357  27.757  1.00 36.68           O  
ATOM    885  OD2 ASP A 104       2.715  30.559  26.305  1.00 40.14           O  
ATOM    886  N   GLN A 105       3.686  26.396  26.021  1.00 20.01           N  
ATOM    887  CA  GLN A 105       4.332  26.022  24.779  1.00 22.87           C  
ATOM    888  C   GLN A 105       4.587  24.538  24.645  1.00 21.27           C  
ATOM    889  O   GLN A 105       4.706  24.042  23.534  1.00 25.86           O  
ATOM    890  CB  GLN A 105       5.659  26.755  24.615  1.00 26.69           C  
ATOM    891  CG  GLN A 105       5.551  28.242  24.507  1.00 36.02           C  
ATOM    892  CD  GLN A 105       6.731  28.899  25.159  1.00 51.74           C  
ATOM    893  OE1 GLN A 105       6.627  29.413  26.279  1.00 57.94           O  
ATOM    894  NE2 GLN A 105       7.887  28.847  24.490  1.00 54.32           N  
ATOM    895  N   CYS A 106       4.686  23.839  25.766  1.00 16.72           N  
ATOM    896  CA  CYS A 106       4.966  22.411  25.739  1.00 14.04           C  
ATOM    897  C   CYS A 106       4.723  21.812  27.101  1.00 13.68           C  
ATOM    898  O   CYS A 106       4.472  22.533  28.055  1.00 18.25           O  
ATOM    899  CB  CYS A 106       6.436  22.187  25.348  1.00 20.68           C  
ATOM    900  SG  CYS A 106       7.698  22.930  26.486  1.00 20.25           S  
ATOM    901  N   GLU A 107       4.827  20.494  27.207  1.00 12.23           N  
ATOM    902  CA  GLU A 107       4.648  19.836  28.492  1.00 16.14           C  
ATOM    903  C   GLU A 107       5.948  20.006  29.268  1.00 17.02           C  
ATOM    904  O   GLU A 107       7.039  19.917  28.693  1.00 14.65           O  
ATOM    905  CB  GLU A 107       4.367  18.343  28.306  1.00 21.18           C  
ATOM    906  CG  GLU A 107       3.166  18.048  27.413  1.00 42.77           C  
ATOM    907  CD  GLU A 107       3.021  16.565  27.053  1.00 51.65           C  
ATOM    908  OE1 GLU A 107       3.041  15.718  27.983  1.00 57.39           O  
ATOM    909  OE2 GLU A 107       2.880  16.251  25.842  1.00 48.45           O  
ATOM    910  N   VAL A 108       5.822  20.281  30.561  1.00 17.79           N  
ATOM    911  CA  VAL A 108       6.964  20.466  31.456  1.00 17.48           C  
ATOM    912  C   VAL A 108       6.903  19.346  32.497  1.00 16.17           C  
ATOM    913  O   VAL A 108       5.907  19.195  33.206  1.00 18.81           O  
ATOM    914  CB  VAL A 108       6.932  21.879  32.139  1.00 15.52           C  
ATOM    915  CG1 VAL A 108       8.003  21.986  33.230  1.00 17.07           C  
ATOM    916  CG2 VAL A 108       7.153  22.951  31.094  1.00  8.21           C  
ATOM    917  N   VAL A 109       7.977  18.561  32.586  1.00 19.59           N  
ATOM    918  CA  VAL A 109       8.030  17.435  33.514  1.00 16.09           C  
ATOM    919  C   VAL A 109       9.285  17.493  34.398  1.00 18.13           C  
ATOM    920  O   VAL A 109      10.390  17.686  33.902  1.00 18.91           O  
ATOM    921  CB  VAL A 109       8.044  16.115  32.717  1.00 15.44           C  
ATOM    922  CG1 VAL A 109       8.017  14.928  33.638  1.00 14.13           C  
ATOM    923  CG2 VAL A 109       6.875  16.081  31.749  1.00 15.84           C  
ATOM    924  N   TYR A 110       9.108  17.331  35.703  1.00 21.72           N  
ATOM    925  CA  TYR A 110      10.212  17.350  36.675  1.00 18.90           C  
ATOM    926  C   TYR A 110      10.381  15.932  37.164  1.00 17.61           C  
ATOM    927  O   TYR A 110       9.452  15.345  37.699  1.00 17.78           O  
ATOM    928  CB  TYR A 110       9.888  18.283  37.857  1.00 10.40           C  
ATOM    929  CG  TYR A 110       9.724  19.714  37.421  1.00 11.41           C  
ATOM    930  CD1 TYR A 110      10.813  20.471  37.025  1.00 11.60           C  
ATOM    931  CD2 TYR A 110       8.463  20.294  37.351  1.00 16.31           C  
ATOM    932  CE1 TYR A 110      10.652  21.776  36.570  1.00 13.74           C  
ATOM    933  CE2 TYR A 110       8.297  21.591  36.895  1.00 10.82           C  
ATOM    934  CZ  TYR A 110       9.386  22.320  36.512  1.00 11.38           C  
ATOM    935  OH  TYR A 110       9.209  23.608  36.080  1.00 17.81           O  
ATOM    936  N   LEU A 111      11.539  15.352  36.885  1.00 22.02           N  
ATOM    937  CA  LEU A 111      11.820  13.986  37.298  1.00 22.25           C  
ATOM    938  C   LEU A 111      12.672  13.957  38.567  1.00 23.98           C  
ATOM    939  O   LEU A 111      13.604  14.765  38.738  1.00 26.68           O  
ATOM    940  CB  LEU A 111      12.541  13.230  36.175  1.00 24.57           C  
ATOM    941  CG  LEU A 111      11.822  13.025  34.838  1.00 19.92           C  
ATOM    942  CD1 LEU A 111      12.802  12.465  33.829  1.00 18.92           C  
ATOM    943  CD2 LEU A 111      10.650  12.094  35.009  1.00 22.28           C  
ATOM    944  N   PRO A 112      12.364  13.032  39.477  1.00 18.97           N  
ATOM    945  CA  PRO A 112      13.152  12.957  40.707  1.00 23.67           C  
ATOM    946  C   PRO A 112      14.584  12.526  40.434  1.00 24.21           C  
ATOM    947  O   PRO A 112      14.823  11.662  39.609  1.00 23.81           O  
ATOM    948  CB  PRO A 112      12.397  11.921  41.537  1.00 22.87           C  
ATOM    949  CG  PRO A 112      11.710  11.081  40.510  1.00 24.98           C  
ATOM    950  CD  PRO A 112      11.236  12.093  39.513  1.00 22.62           C  
ATOM    951  N   ARG A 113      15.528  13.195  41.078  1.00 27.42           N  
ATOM    952  CA  ARG A 113      16.939  12.865  40.924  1.00 30.42           C  
ATOM    953  C   ARG A 113      17.221  11.500  41.528  1.00 31.00           C  
ATOM    954  O   ARG A 113      16.452  11.007  42.363  1.00 35.08           O  
ATOM    955  CB  ARG A 113      17.809  13.887  41.661  1.00 30.30           C  
ATOM    956  CG  ARG A 113      17.865  15.268  41.038  1.00 28.57           C  
ATOM    957  CD  ARG A 113      18.638  16.236  41.929  1.00 31.58           C  
ATOM    958  NE  ARG A 113      20.015  15.817  42.196  1.00 31.25           N  
ATOM    959  CZ  ARG A 113      21.091  16.332  41.607  1.00 33.57           C  
ATOM    960  NH1 ARG A 113      20.958  17.293  40.700  1.00 38.26           N  
ATOM    961  NH2 ARG A 113      22.300  15.906  41.950  1.00 35.69           N  
ATOM    962  N   THR A 114      18.348  10.921  41.128  1.00 32.43           N  
ATOM    963  CA  THR A 114      18.798   9.640  41.651  1.00 29.36           C  
ATOM    964  C   THR A 114      19.583   9.924  42.938  1.00 32.59           C  
ATOM    965  O   THR A 114      20.523  10.731  42.947  1.00 34.15           O  
ATOM    966  CB  THR A 114      19.677   8.929  40.639  1.00 24.81           C  
ATOM    967  OG1 THR A 114      18.843   8.316  39.660  1.00 29.25           O  
ATOM    968  CG2 THR A 114      20.508   7.864  41.297  1.00 28.30           C  
ATOM    969  N   GLU A 115      19.155   9.307  44.033  1.00 34.75           N  
ATOM    970  CA  GLU A 115      19.805   9.496  45.325  1.00 40.88           C  
ATOM    971  C   GLU A 115      21.198   8.877  45.436  1.00 41.04           C  
ATOM    972  O   GLU A 115      21.499   7.865  44.788  1.00 40.89           O  
ATOM    973  CB  GLU A 115      18.922   8.927  46.431  1.00 47.46           C  
ATOM    974  CG  GLU A 115      17.669   9.741  46.725  1.00 64.52           C  
ATOM    975  CD  GLU A 115      17.919  10.884  47.702  1.00 72.35           C  
ATOM    976  OE1 GLU A 115      18.437  11.945  47.276  1.00 76.47           O  
ATOM    977  OE2 GLU A 115      17.592  10.713  48.901  1.00 77.43           O  
ATOM    978  N   GLY A 116      22.035   9.501  46.266  1.00 42.68           N  
ATOM    979  CA  GLY A 116      23.378   9.004  46.522  1.00 40.65           C  
ATOM    980  C   GLY A 116      24.469   9.194  45.491  1.00 42.05           C  
ATOM    981  O   GLY A 116      25.548   8.621  45.637  1.00 44.34           O  
ATOM    982  N   ILE A 117      24.240  10.045  44.497  1.00 40.39           N  
ATOM    983  CA  ILE A 117      25.244  10.267  43.462  1.00 33.61           C  
ATOM    984  C   ILE A 117      25.104  11.634  42.796  1.00 33.89           C  
ATOM    985  O   ILE A 117      23.995  12.091  42.501  1.00 36.63           O  
ATOM    986  CB  ILE A 117      25.181   9.139  42.363  1.00 31.14           C  
ATOM    987  CG1 ILE A 117      26.297   9.313  41.332  1.00 28.35           C  
ATOM    988  CG2 ILE A 117      23.843   9.153  41.648  1.00 25.89           C  
ATOM    989  CD1 ILE A 117      27.681   9.185  41.892  1.00 31.71           C  
ATOM    990  N   SER A 118      26.240  12.285  42.574  1.00 29.56           N  
ATOM    991  CA  SER A 118      26.281  13.576  41.891  1.00 25.94           C  
ATOM    992  C   SER A 118      27.704  13.844  41.498  1.00 21.74           C  
ATOM    993  O   SER A 118      28.625  13.191  41.984  1.00 30.24           O  
ATOM    994  CB  SER A 118      25.733  14.725  42.758  1.00 32.91           C  
ATOM    995  OG  SER A 118      26.425  14.848  43.992  1.00 42.73           O  
ATOM    996  N   THR A 119      27.884  14.761  40.569  1.00 19.82           N  
ATOM    997  CA  THR A 119      29.205  15.116  40.124  1.00 22.98           C  
ATOM    998  C   THR A 119      30.066  15.771  41.234  1.00 30.58           C  
ATOM    999  O   THR A 119      31.268  15.496  41.314  1.00 32.87           O  
ATOM   1000  CB  THR A 119      29.120  15.967  38.851  1.00 23.81           C  
ATOM   1001  OG1 THR A 119      28.574  15.152  37.806  1.00 26.31           O  
ATOM   1002  CG2 THR A 119      30.477  16.480  38.431  1.00 21.06           C  
ATOM   1003  N   THR A 120      29.490  16.582  42.122  1.00 30.78           N  
ATOM   1004  CA  THR A 120      30.350  17.180  43.159  1.00 34.38           C  
ATOM   1005  C   THR A 120      30.814  16.157  44.182  1.00 28.23           C  
ATOM   1006  O   THR A 120      31.947  16.212  44.630  1.00 31.65           O  
ATOM   1007  CB  THR A 120      29.739  18.415  43.889  1.00 38.07           C  
ATOM   1008  OG1 THR A 120      28.625  18.021  44.698  1.00 43.48           O  
ATOM   1009  CG2 THR A 120      29.319  19.491  42.887  1.00 33.07           C  
ATOM   1010  N   LYS A 121      29.948  15.220  44.538  1.00 26.79           N  
ATOM   1011  CA  LYS A 121      30.313  14.195  45.505  1.00 31.44           C  
ATOM   1012  C   LYS A 121      31.467  13.370  44.968  1.00 33.96           C  
ATOM   1013  O   LYS A 121      32.335  12.953  45.728  1.00 36.17           O  
ATOM   1014  CB  LYS A 121      29.131  13.275  45.798  1.00 35.54           C  
ATOM   1015  CG  LYS A 121      29.481  12.078  46.669  1.00 39.88           C  
ATOM   1016  CD  LYS A 121      28.320  11.104  46.760  1.00 45.77           C  
ATOM   1017  CE  LYS A 121      28.663   9.915  47.645  1.00 48.21           C  
ATOM   1018  NZ  LYS A 121      27.575   8.912  47.675  1.00 51.04           N  
ATOM   1019  N   ILE A 122      31.443  13.089  43.669  1.00 32.50           N  
ATOM   1020  CA  ILE A 122      32.509  12.320  43.049  1.00 29.04           C  
ATOM   1021  C   ILE A 122      33.794  13.104  43.244  1.00 31.08           C  
ATOM   1022  O   ILE A 122      34.810  12.536  43.640  1.00 31.23           O  
ATOM   1023  CB  ILE A 122      32.259  12.095  41.530  1.00 25.50           C  
ATOM   1024  CG1 ILE A 122      31.051  11.171  41.318  1.00 25.77           C  
ATOM   1025  CG2 ILE A 122      33.490  11.495  40.863  1.00 20.09           C  
ATOM   1026  CD1 ILE A 122      30.672  11.007  39.868  1.00 27.11           C  
ATOM   1027  N   LYS A 123      33.745  14.401  42.942  1.00 32.26           N  
ATOM   1028  CA  LYS A 123      34.904  15.291  43.080  1.00 35.94           C  
ATOM   1029  C   LYS A 123      35.356  15.448  44.535  1.00 37.88           C  
ATOM   1030  O   LYS A 123      36.550  15.589  44.815  1.00 35.82           O  
ATOM   1031  CB  LYS A 123      34.602  16.664  42.471  1.00 34.16           C  
ATOM   1032  CG  LYS A 123      34.738  16.688  40.962  1.00 38.34           C  
ATOM   1033  CD  LYS A 123      34.021  17.871  40.354  1.00 44.82           C  
ATOM   1034  CE  LYS A 123      34.256  17.966  38.843  1.00 47.35           C  
ATOM   1035  NZ  LYS A 123      35.620  18.486  38.484  1.00 53.73           N  
ATOM   1036  N   GLU A 124      34.392  15.471  45.447  1.00 40.52           N  
ATOM   1037  CA  GLU A 124      34.684  15.588  46.867  1.00 46.87           C  
ATOM   1038  C   GLU A 124      35.293  14.299  47.409  1.00 49.20           C  
ATOM   1039  O   GLU A 124      36.118  14.328  48.326  1.00 49.95           O  
ATOM   1040  CB  GLU A 124      33.418  15.917  47.648  1.00 48.20           C  
ATOM   1041  CG  GLU A 124      32.983  17.361  47.511  1.00 54.32           C  
ATOM   1042  CD  GLU A 124      31.799  17.700  48.399  1.00 57.62           C  
ATOM   1043  OE1 GLU A 124      31.183  16.771  48.976  1.00 58.75           O  
ATOM   1044  OE2 GLU A 124      31.480  18.902  48.510  1.00 60.80           O  
ATOM   1045  N   GLU A 125      34.831  13.168  46.891  1.00 48.20           N  
ATOM   1046  CA  GLU A 125      35.351  11.883  47.315  1.00 46.83           C  
ATOM   1047  C   GLU A 125      36.624  11.477  46.567  1.00 50.04           C  
ATOM   1048  O   GLU A 125      37.062  10.325  46.656  1.00 55.81           O  
ATOM   1049  CB  GLU A 125      34.285  10.814  47.182  1.00 43.55           C  
ATOM   1050  CG  GLU A 125      33.090  11.060  48.069  1.00 45.32           C  
ATOM   1051  CD  GLU A 125      32.214   9.836  48.223  1.00 51.19           C  
ATOM   1052  OE1 GLU A 125      32.360   8.874  47.432  1.00 51.64           O  
ATOM   1053  OE2 GLU A 125      31.378   9.830  49.149  1.00 55.21           O  
ATOM   1054  N   ILE A 126      37.208  12.417  45.831  1.00 49.24           N  
ATOM   1055  CA  ILE A 126      38.444  12.180  45.094  1.00 50.04           C  
ATOM   1056  C   ILE A 126      39.418  13.335  45.359  1.00 53.18           C  
ATOM   1057  O   ILE A 126      39.819  13.519  46.532  1.00 56.23           O  
ATOM   1058  CB  ILE A 126      38.199  12.076  43.573  1.00 49.49           C  
ATOM   1059  CG1 ILE A 126      37.390  10.820  43.240  1.00 49.06           C  
ATOM   1060  CG2 ILE A 126      39.520  12.044  42.828  1.00 46.19           C  
ATOM   1061  CD1 ILE A 126      37.040  10.709  41.761  1.00 46.49           C  
TER    1062      ILE A 126                                                      
END
MOLECULE T0507.pdb
ATOM      1  N   MET     1       9.471  19.383  17.859  1.00 28.75           N  
ATOM      2  CA  MET     1      10.467  18.472  18.443  1.00 28.28           C  
ATOM      3  C   MET     1       9.863  17.832  19.708  1.00 25.85           C  
ATOM      4  O   MET     1       9.220  18.505  20.472  1.00 26.57           O  
ATOM      5  CB  MET     1      11.682  19.345  18.718  1.00 30.12           C  
ATOM      6  CG  MET     1      12.926  18.747  18.287  1.00 32.38           C  
ATOM      7  SD  MET     1      13.141  17.583  19.609  1.00 34.54           S  
ATOM      8  CE  MET     1      14.154  16.363  18.798  1.00 34.68           C  
ATOM      9  N   LYS     2      10.005  16.529  19.935  1.00 23.67           N  
ATOM     10  CA  LYS     2       9.130  15.928  20.868  1.00 21.04           C  
ATOM     11  C   LYS     2       9.632  16.314  22.285  1.00 18.36           C  
ATOM     12  O   LYS     2       8.829  16.790  23.089  1.00 17.95           O  
ATOM     13  CB  LYS     2       8.952  14.397  20.695  1.00 20.99           C  
ATOM     14  CG  LYS     2       7.689  13.889  21.336  1.00 25.93           C  
ATOM     15  CD  LYS     2       7.379  12.460  20.935  1.00 25.23           C  
ATOM     16  CE  LYS     2       6.225  11.894  21.721  1.00 28.95           C  
ATOM     17  NZ  LYS     2       4.952  12.062  20.997  1.00 30.26           N  
ATOM     18  N   VAL     3      10.932  16.116  22.588  1.00 14.40           N  
ATOM     19  CA  VAL     3      11.392  16.209  23.996  1.00 14.06           C  
ATOM     20  C   VAL     3      12.682  17.038  24.127  1.00 12.89           C  
ATOM     21  O   VAL     3      13.653  16.793  23.395  1.00 14.14           O  
ATOM     22  CB  VAL     3      11.667  14.816  24.604  1.00 13.71           C  
ATOM     23  CG1 VAL     3      12.079  14.962  26.073  1.00 15.31           C  
ATOM     24  CG2 VAL     3      10.474  13.891  24.441  1.00 16.19           C  
ATOM     25  N   ALA     4      12.676  17.999  25.057  1.00 12.21           N  
ATOM     26  CA  ALA     4      13.827  18.798  25.476  1.00 12.13           C  
ATOM     27  C   ALA     4      14.427  18.297  26.783  1.00 11.99           C  
ATOM     28  O   ALA     4      13.701  17.956  27.685  1.00 12.37           O  
ATOM     29  CB  ALA     4      13.425  20.213  25.670  1.00 12.90           C  
ATOM     30  N   LEU     5      15.751  18.232  26.822  1.00 13.40           N  
ATOM     31  CA  LEU     5      16.530  17.887  27.989  1.00 12.60           C  
ATOM     32  C   LEU     5      17.799  18.716  27.901  1.00 12.39           C  
ATOM     33  O   LEU     5      18.362  18.838  26.851  1.00 13.27           O  
ATOM     34  CB  LEU     5      16.940  16.393  27.940  1.00 13.90           C  
ATOM     35  CG  LEU     5      17.961  15.886  28.931  1.00 16.06           C  
ATOM     36  CD1 LEU     5      17.473  16.062  30.368  1.00 16.87           C  
ATOM     37  CD2 LEU     5      18.254  14.463  28.636  1.00 14.54           C  
ATOM     38  N   GLY     6      18.267  19.240  29.016  1.00 12.20           N  
ATOM     39  CA  GLY     6      19.496  20.016  29.036  1.00 13.19           C  
ATOM     40  C   GLY     6      20.337  19.768  30.258  1.00 13.49           C  
ATOM     41  O   GLY     6      19.846  19.263  31.259  1.00 15.10           O  
ATOM     42  N   GLY     7      21.616  20.105  30.157  1.00 12.80           N  
ATOM     43  CA  GLY     7      22.516  19.947  31.279  1.00 14.21           C  
ATOM     44  C   GLY     7      23.944  20.314  30.945  1.00 13.50           C  
ATOM     45  O   GLY     7      24.270  20.652  29.816  1.00 13.18           O  
ATOM     46  N   THR     8      24.777  20.264  31.978  1.00 14.15           N  
ATOM     47  CA  THR     8      26.216  20.411  31.846  1.00 14.26           C  
ATOM     48  C   THR     8      26.868  19.026  31.710  1.00 14.59           C  
ATOM     49  O   THR     8      27.789  18.873  30.955  1.00 14.76           O  
ATOM     50  CB  THR     8      26.793  21.177  33.055  1.00 15.05           C  
ATOM     51  OG1 THR     8      26.310  22.511  33.028  1.00 15.52           O  
ATOM     52  CG2 THR     8      28.296  21.183  33.016  1.00 15.72           C  
ATOM     53  N   PHE     9      26.361  18.037  32.439  1.00 14.99           N  
ATOM     54  CA  PHE     9      26.787  16.626  32.312  1.00 15.71           C  
ATOM     55  C   PHE     9      28.238  16.446  32.693  1.00 16.39           C  
ATOM     56  O   PHE     9      28.979  15.688  32.027  1.00 17.49           O  
ATOM     57  CB  PHE     9      26.516  16.061  30.900  1.00 15.53           C  
ATOM     58  CG  PHE     9      25.068  16.132  30.484  1.00 15.67           C  
ATOM     59  CD1 PHE     9      24.133  15.228  30.982  1.00 15.89           C  
ATOM     60  CD2 PHE     9      24.627  17.115  29.605  1.00 13.72           C  
ATOM     61  CE1 PHE     9      22.778  15.297  30.589  1.00 14.96           C  
ATOM     62  CE2 PHE     9      23.308  17.216  29.252  1.00 14.05           C  
ATOM     63  CZ  PHE     9      22.370  16.310  29.724  1.00 14.38           C  
ATOM     64  N   GLU    10      28.654  17.083  33.785  1.00 16.74           N  
ATOM     65  CA  GLU    10      30.018  16.900  34.286  1.00 17.49           C  
ATOM     66  C   GLU    10      30.013  16.604  35.768  1.00 18.37           C  
ATOM     67  O   GLU    10      29.660  17.486  36.554  1.00 19.65           O  
ATOM     68  CB  GLU    10      30.907  18.116  34.014  1.00 17.97           C  
ATOM     69  CG  GLU    10      32.345  17.926  34.536  1.00 18.05           C  
ATOM     70  CD  GLU    10      33.225  19.113  34.340  1.00 18.80           C  
ATOM     71  OE1 GLU    10      33.029  19.855  33.355  1.00 20.13           O  
ATOM     72  OE2 GLU    10      34.130  19.331  35.199  1.00 20.91           O  
ATOM     73  N   PRO    11      30.372  15.374  36.155  1.00 17.40           N  
ATOM     74  CA  PRO    11      30.526  14.230  35.271  1.00 17.68           C  
ATOM     75  C   PRO    11      29.125  13.733  34.888  1.00 17.09           C  
ATOM     76  O   PRO    11      28.112  14.261  35.367  1.00 17.46           O  
ATOM     77  CB  PRO    11      31.211  13.195  36.146  1.00 18.11           C  
ATOM     78  CG  PRO    11      30.719  13.480  37.453  1.00 19.56           C  
ATOM     79  CD  PRO    11      30.512  14.970  37.556  1.00 18.87           C  
ATOM     80  N   LEU    12      29.090  12.757  33.995  1.00 17.04           N  
ATOM     81  CA  LEU    12      27.846  12.138  33.573  1.00 16.16           C  
ATOM     82  C   LEU    12      27.485  11.059  34.586  1.00 15.29           C  
ATOM     83  O   LEU    12      28.085   9.967  34.578  1.00 16.60           O  
ATOM     84  CB  LEU    12      28.011  11.558  32.175  1.00 16.49           C  
ATOM     85  CG  LEU    12      26.753  11.002  31.491  1.00 18.74           C  
ATOM     86  CD1 LEU    12      26.056   9.867  32.230  1.00 25.35           C  
ATOM     87  CD2 LEU    12      25.771  12.045  31.269  1.00 20.51           C  
ATOM     88  N   HIS    13      26.546  11.364  35.482  1.00 14.14           N  
ATOM     89  CA  HIS    13      26.262  10.510  36.644  1.00 15.00           C  
ATOM     90  C   HIS    13      24.923   9.821  36.533  1.00 13.50           C  
ATOM     91  O   HIS    13      24.206   9.983  35.525  1.00 13.42           O  
ATOM     92  CB  HIS    13      26.385  11.302  37.951  1.00 15.48           C  
ATOM     93  CG  HIS    13      25.492  12.499  38.057  1.00 15.70           C  
ATOM     94  ND1 HIS    13      24.118  12.442  37.912  1.00 17.16           N  
ATOM     95  CD2 HIS    13      25.788  13.801  38.302  1.00 17.76           C  
ATOM     96  CE1 HIS    13      23.614  13.651  38.092  1.00 18.91           C  
ATOM     97  NE2 HIS    13      24.606  14.494  38.326  1.00 18.16           N  
ATOM     98  N   GLU    14      24.583   9.033  37.540  1.00 14.72           N  
ATOM     99  CA  GLU    14      23.409   8.172  37.492  1.00 14.66           C  
ATOM    100  C   GLU    14      22.125   8.999  37.368  1.00 13.85           C  
ATOM    101  O   GLU    14      21.181   8.597  36.687  1.00 14.59           O  
ATOM    102  CB  GLU    14      23.363   7.236  38.715  1.00 15.83           C  
ATOM    103  CG  GLU    14      22.078   6.395  38.788  1.00 19.31           C  
ATOM    104  CD  GLU    14      21.791   5.604  37.498  1.00 27.14           C  
ATOM    105  OE1 GLU    14      22.767   5.087  36.878  1.00 35.57           O  
ATOM    106  OE2 GLU    14      20.596   5.476  37.105  1.00 31.01           O  
ATOM    107  N   GLY    15      22.119  10.179  37.976  1.00 13.70           N  
ATOM    108  CA  GLY    15      21.008  11.107  37.818  1.00 13.84           C  
ATOM    109  C   GLY    15      20.783  11.491  36.365  1.00 13.31           C  
ATOM    110  O   GLY    15      19.653  11.437  35.840  1.00 13.77           O  
ATOM    111  N   HIS    16      21.863  11.900  35.691  1.00 12.59           N  
ATOM    112  CA  HIS    16      21.774  12.253  34.280  1.00 13.43           C  
ATOM    113  C   HIS    16      21.246  11.064  33.480  1.00 13.14           C  
ATOM    114  O   HIS    16      20.460  11.217  32.541  1.00 13.69           O  
ATOM    115  CB  HIS    16      23.104  12.650  33.660  1.00 13.25           C  
ATOM    116  CG  HIS    16      23.758  13.845  34.273  1.00 14.67           C  
ATOM    117  ND1 HIS    16      23.184  15.101  34.310  1.00 16.09           N  
ATOM    118  CD2 HIS    16      24.989  13.974  34.818  1.00 13.92           C  
ATOM    119  CE1 HIS    16      24.036  15.942  34.882  1.00 14.34           C  
ATOM    120  NE2 HIS    16      25.124  15.276  35.216  1.00 18.20           N  
ATOM    121  N   LYS    17      21.728   9.871  33.794  1.00 12.70           N  
ATOM    122  CA  LYS    17      21.279   8.685  33.095  1.00 13.29           C  
ATOM    123  C   LYS    17      19.782   8.429  33.269  1.00 12.95           C  
ATOM    124  O   LYS    17      19.103   7.992  32.317  1.00 13.58           O  
ATOM    125  CB  LYS    17      22.145   7.499  33.449  1.00 13.51           C  
ATOM    126  CG  LYS    17      23.607   7.759  33.065  1.00 14.06           C  
ATOM    127  CD  LYS    17      24.525   6.618  33.488  1.00 15.90           C  
ATOM    128  CE  LYS    17      25.976   6.918  33.192  1.00 17.87           C  
ATOM    129  NZ  LYS    17      26.924   5.828  33.630  1.00 18.53           N  
ATOM    130  N   LYS    18      19.235   8.761  34.440  1.00 12.91           N  
ATOM    131  CA  LYS    18      17.788   8.639  34.619  1.00 13.91           C  
ATOM    132  C   LYS    18      17.054   9.637  33.738  1.00 13.08           C  
ATOM    133  O   LYS    18      16.049   9.302  33.103  1.00 13.01           O  
ATOM    134  CB  LYS    18      17.391   8.814  36.069  1.00 14.14           C  
ATOM    135  CG  LYS    18      17.885   7.705  36.985  1.00 16.78           C  
ATOM    136  CD  LYS    18      17.640   7.995  38.461  1.00 19.10           C  
ATOM    137  CE  LYS    18      17.835   6.722  39.301  1.00 22.60           C  
ATOM    138  NZ  LYS    18      17.548   7.034  40.723  1.00 27.88           N  
ATOM    139  N   LEU    19      17.544  10.867  33.706  1.00 12.55           N  
ATOM    140  CA  LEU    19      16.926  11.891  32.868  1.00 12.88           C  
ATOM    141  C   LEU    19      16.922  11.447  31.399  1.00 12.80           C  
ATOM    142  O   LEU    19      15.931  11.608  30.677  1.00 12.07           O  
ATOM    143  CB  LEU    19      17.689  13.206  32.974  1.00 14.18           C  
ATOM    144  CG  LEU    19      17.718  13.965  34.287  1.00 17.04           C  
ATOM    145  CD1 LEU    19      18.262  15.407  34.070  1.00 18.47           C  
ATOM    146  CD2 LEU    19      16.344  13.966  34.919  1.00 19.93           C  
ATOM    147  N   ILE    20      18.070  10.956  30.954  1.00 12.27           N  
ATOM    148  CA  ILE    20      18.235  10.539  29.573  1.00 12.20           C  
ATOM    149  C   ILE    20      17.285   9.380  29.261  1.00 11.45           C  
ATOM    150  O   ILE    20      16.659   9.345  28.172  1.00 12.52           O  
ATOM    151  CB  ILE    20      19.722  10.157  29.272  1.00 11.20           C  
ATOM    152  CG1 ILE    20      20.578  11.420  29.228  1.00 12.10           C  
ATOM    153  CG2 ILE    20      19.867   9.382  27.962  1.00 12.79           C  
ATOM    154  CD1 ILE    20      22.083  11.206  29.352  1.00 12.89           C  
ATOM    155  N   ASP    21      17.155   8.428  30.197  1.00 11.22           N  
ATOM    156  CA  ASP    21      16.278   7.264  29.966  1.00 10.93           C  
ATOM    157  C   ASP    21      14.840   7.747  29.786  1.00 10.42           C  
ATOM    158  O   ASP    21      14.126   7.308  28.906  1.00 11.06           O  
ATOM    159  CB  ASP    21      16.325   6.293  31.145  1.00 11.64           C  
ATOM    160  CG  ASP    21      15.650   4.968  30.834  1.00 12.80           C  
ATOM    161  OD1 ASP    21      16.098   4.298  29.871  1.00 15.25           O  
ATOM    162  OD2 ASP    21      14.673   4.598  31.565  1.00 14.13           O  
ATOM    163  N   VAL    22      14.401   8.615  30.679  1.00 10.55           N  
ATOM    164  CA  VAL    22      13.020   9.119  30.616  1.00 11.13           C  
ATOM    165  C   VAL    22      12.833   9.877  29.283  1.00 10.90           C  
ATOM    166  O   VAL    22      11.865   9.666  28.577  1.00 11.79           O  
ATOM    167  CB  VAL    22      12.657  10.003  31.860  1.00 11.06           C  
ATOM    168  CG1 VAL    22      11.361  10.773  31.631  1.00 12.23           C  
ATOM    169  CG2 VAL    22      12.627   9.157  33.134  1.00 11.82           C  
ATOM    170  N   ALA    23      13.775  10.739  28.929  1.00 11.24           N  
ATOM    171  CA  ALA    23      13.644  11.541  27.713  1.00 11.85           C  
ATOM    172  C   ALA    23      13.551  10.647  26.477  1.00 11.80           C  
ATOM    173  O   ALA    23      12.741  10.900  25.594  1.00 12.41           O  
ATOM    174  CB  ALA    23      14.792  12.530  27.571  1.00 12.84           C  
ATOM    175  N   ILE    24      14.387   9.605  26.399  1.00 12.42           N  
ATOM    176  CA  ILE    24      14.387   8.721  25.248  1.00 12.68           C  
ATOM    177  C   ILE    24      13.144   7.848  25.179  1.00 12.17           C  
ATOM    178  O   ILE    24      12.615   7.594  24.090  1.00 13.55           O  
ATOM    179  CB  ILE    24      15.690   7.887  25.165  1.00 13.00           C  
ATOM    180  CG1 ILE    24      16.865   8.845  24.909  1.00 13.51           C  
ATOM    181  CG2 ILE    24      15.573   6.843  24.091  1.00 13.87           C  
ATOM    182  CD1 ILE    24      18.274   8.223  24.900  1.00 12.90           C  
ATOM    183  N   LYS    25      12.670   7.386  26.325  1.00 12.40           N  
ATOM    184  CA  LYS    25      11.431   6.646  26.361  1.00 13.51           C  
ATOM    185  C   LYS    25      10.273   7.527  25.891  1.00 13.03           C  
ATOM    186  O   LYS    25       9.383   7.055  25.166  1.00 15.22           O  
ATOM    187  CB  LYS    25      11.211   6.009  27.742  1.00 13.95           C  
ATOM    188  CG  LYS    25      12.140   4.801  27.947  1.00 14.39           C  
ATOM    189  CD  LYS    25      12.160   4.232  29.338  1.00 15.16           C  
ATOM    190  CE  LYS    25      12.990   2.939  29.347  1.00 17.97           C  
ATOM    191  NZ  LYS    25      13.339   2.490  30.713  1.00 19.33           N  
ATOM    192  N   LEU    26      10.292   8.812  26.235  1.00 13.14           N  
ATOM    193  CA  LEU    26       9.227   9.714  25.813  1.00 13.62           C  
ATOM    194  C   LEU    26       9.317  10.078  24.349  1.00 14.05           C  
ATOM    195  O   LEU    26       8.277  10.198  23.693  1.00 16.58           O  
ATOM    196  CB  LEU    26       9.226  11.021  26.634  1.00 12.95           C  
ATOM    197  CG  LEU    26       8.786  10.894  28.085  1.00 13.32           C  
ATOM    198  CD1 LEU    26       8.978  12.246  28.826  1.00 15.92           C  
ATOM    199  CD2 LEU    26       7.344  10.390  28.204  1.00 18.05           C  
ATOM    200  N   GLY    27      10.537  10.327  23.856  1.00 15.19           N  
ATOM    201  CA  GLY    27      10.745  10.968  22.553  1.00 15.35           C  
ATOM    202  C   GLY    27      11.401  10.144  21.470  1.00 16.01           C  
ATOM    203  O   GLY    27      11.377  10.531  20.299  1.00 15.93           O  
ATOM    204  N   GLY    28      12.018   9.029  21.850  1.00 15.76           N  
ATOM    205  CA  GLY    28      12.791   8.229  20.905  1.00 16.84           C  
ATOM    206  C   GLY    28      13.929   9.057  20.354  1.00 16.82           C  
ATOM    207  O   GLY    28      14.622   9.718  21.086  1.00 18.04           O  
ATOM    208  N   ARG    29      14.087   9.057  19.028  1.00 17.64           N  
ATOM    209  CA  ARG    29      15.088   9.871  18.351  1.00 19.03           C  
ATOM    210  C   ARG    29      14.685  11.351  18.236  1.00 19.02           C  
ATOM    211  O   ARG    29      15.500  12.184  17.796  1.00 20.44           O  
ATOM    212  CB  ARG    29      15.288   9.360  16.951  1.00 20.25           C  
ATOM    213  CG  ARG    29      15.520   7.842  16.811  1.00 24.86           C  
ATOM    214  CD  ARG    29      16.913   7.453  17.006  1.00 27.48           C  
ATOM    215  NE  ARG    29      17.833   8.195  16.128  1.00 29.06           N  
ATOM    216  CZ  ARG    29      18.392   7.754  15.001  1.00 29.08           C  
ATOM    217  NH1 ARG    29      19.223   8.563  14.350  1.00 29.21           N  
ATOM    218  NH2 ARG    29      18.164   6.525  14.537  1.00 26.69           N  
ATOM    219  N   ASP    30      13.457  11.683  18.640  1.00 18.63           N  
ATOM    220  CA  ASP    30      12.897  13.029  18.471  1.00 19.92           C  
ATOM    221  C   ASP    30      13.160  13.790  19.754  1.00 20.38           C  
ATOM    222  O   ASP    30      12.260  14.372  20.349  1.00 21.75           O  
ATOM    223  CB  ASP    30      11.382  12.919  18.204  1.00 20.66           C  
ATOM    224  CG  ASP    30      10.770  14.161  17.535  1.00 22.83           C  
ATOM    225  OD1 ASP    30      11.468  15.180  17.351  1.00 27.63           O  
ATOM    226  OD2 ASP    30       9.543  14.095  17.201  1.00 28.91           O  
ATOM    227  N   ILE    31      14.391  13.746  20.194  1.00 20.35           N  
ATOM    228  CA  ILE    31      14.835  14.459  21.393  1.00 19.54           C  
ATOM    229  C   ILE    31      15.976  15.364  20.970  1.00 18.50           C  
ATOM    230  O   ILE    31      16.686  15.090  19.998  1.00 16.83           O  
ATOM    231  CB  ILE    31      15.317  13.524  22.499  1.00 20.15           C  
ATOM    232  CG1 ILE    31      16.598  12.757  22.116  1.00 20.47           C  
ATOM    233  CG2 ILE    31      14.218  12.514  22.866  1.00 22.69           C  
ATOM    234  CD1 ILE    31      17.156  12.008  23.299  1.00 23.46           C  
ATOM    235  N   THR    32      16.120  16.435  21.725  1.00 16.49           N  
ATOM    236  CA  THR    32      17.258  17.324  21.627  1.00 16.34           C  
ATOM    237  C   THR    32      17.855  17.426  22.987  1.00 14.94           C  
ATOM    238  O   THR    32      17.136  17.750  23.954  1.00 15.40           O  
ATOM    239  CB  THR    32      16.845  18.713  21.123  1.00 16.82           C  
ATOM    240  OG1 THR    32      16.188  18.568  19.858  1.00 21.43           O  
ATOM    241  CG2 THR    32      18.015  19.583  20.935  1.00 19.14           C  
ATOM    242  N   ILE    33      19.155  17.107  23.083  1.00 14.18           N  
ATOM    243  CA  ILE    33      19.886  17.237  24.315  1.00 13.20           C  
ATOM    244  C   ILE    33      20.753  18.497  24.237  1.00 13.18           C  
ATOM    245  O   ILE    33      21.657  18.578  23.400  1.00 13.87           O  
ATOM    246  CB  ILE    33      20.797  16.007  24.617  1.00 12.09           C  
ATOM    247  CG1 ILE    33      19.972  14.705  24.610  1.00 12.71           C  
ATOM    248  CG2 ILE    33      21.490  16.221  25.951  1.00 14.20           C  
ATOM    249  CD1 ILE    33      20.795  13.467  24.973  1.00 15.21           C  
ATOM    250  N   GLY    34      20.462  19.463  25.096  1.00 12.18           N  
ATOM    251  CA  GLY    34      21.263  20.657  25.205  1.00 12.70           C  
ATOM    252  C   GLY    34      22.406  20.389  26.154  1.00 13.13           C  
ATOM    253  O   GLY    34      22.198  19.822  27.245  1.00 12.92           O  
ATOM    254  N   VAL    35      23.606  20.801  25.746  1.00 12.36           N  
ATOM    255  CA  VAL    35      24.775  20.735  26.613  1.00 13.23           C  
ATOM    256  C   VAL    35      25.301  22.172  26.781  1.00 13.64           C  
ATOM    257  O   VAL    35      25.510  22.896  25.792  1.00 13.78           O  
ATOM    258  CB  VAL    35      25.818  19.779  26.007  1.00 12.50           C  
ATOM    259  CG1 VAL    35      27.133  19.843  26.810  1.00 13.44           C  
ATOM    260  CG2 VAL    35      25.219  18.351  25.932  1.00 12.66           C  
ATOM    261  N   THR    36      25.515  22.585  28.028  1.00 13.52           N  
ATOM    262  CA  THR    36      25.899  23.965  28.310  1.00 14.83           C  
ATOM    263  C   THR    36      27.250  24.311  27.679  1.00 15.63           C  
ATOM    264  O   THR    36      28.190  23.509  27.683  1.00 15.00           O  
ATOM    265  CB  THR    36      25.976  24.216  29.824  1.00 15.02           C  
ATOM    266  OG1 THR    36      26.807  23.225  30.420  1.00 15.22           O  
ATOM    267  CG2 THR    36      24.593  24.178  30.476  1.00 15.83           C  
ATOM    268  N   SER    37      27.359  25.526  27.161  1.00 16.83           N  
ATOM    269  CA  SER    37      28.653  26.063  26.750  1.00 17.62           C  
ATOM    270  C   SER    37      29.622  26.117  27.949  1.00 18.72           C  
ATOM    271  O   SER    37      29.196  26.083  29.118  1.00 17.64           O  
ATOM    272  CB  SER    37      28.435  27.477  26.194  1.00 17.99           C  
ATOM    273  OG  SER    37      28.134  28.333  27.273  1.00 17.35           O  
ATOM    274  N   ASP    38      30.917  26.236  27.673  1.00 20.81           N  
ATOM    275  CA  ASP    38      31.910  26.387  28.752  1.00 23.11           C  
ATOM    276  C   ASP    38      31.576  27.575  29.665  1.00 24.66           C  
ATOM    277  O   ASP    38      31.659  27.478  30.886  1.00 24.12           O  
ATOM    278  CB  ASP    38      33.306  26.577  28.162  1.00 23.55           C  
ATOM    279  CG  ASP    38      33.832  25.336  27.487  1.00 25.05           C  
ATOM    280  OD1 ASP    38      33.213  24.272  27.650  1.00 23.99           O  
ATOM    281  OD2 ASP    38      34.852  25.429  26.775  1.00 29.86           O  
ATOM    282  N   ARG    39      31.162  28.680  29.065  1.00 26.98           N  
ATOM    283  CA  ARG    39      30.840  29.891  29.838  1.00 29.48           C  
ATOM    284  C   ARG    39      29.791  29.597  30.890  1.00 29.96           C  
ATOM    285  O   ARG    39      29.948  29.890  32.074  1.00 29.97           O  
ATOM    286  CB  ARG    39      30.301  30.974  28.924  1.00 30.19           C  
ATOM    287  CG  ARG    39      31.332  31.904  28.373  1.00 33.88           C  
ATOM    288  CD  ARG    39      30.702  33.272  28.049  1.00 35.35           C  
ATOM    289  NE  ARG    39      31.282  33.864  26.839  1.00 41.19           N  
ATOM    290  CZ  ARG    39      32.560  34.234  26.696  1.00 43.21           C  
ATOM    291  NH1 ARG    39      33.449  34.074  27.685  1.00 45.26           N  
ATOM    292  NH2 ARG    39      32.960  34.759  25.537  1.00 42.87           N  
ATOM    293  N   MET    40      28.732  28.953  30.422  1.00 30.37           N  
ATOM    294  CA  MET    40      27.575  28.630  31.218  1.00 31.30           C  
ATOM    295  C   MET    40      27.853  27.561  32.274  1.00 32.15           C  
ATOM    296  O   MET    40      27.332  27.616  33.398  1.00 31.89           O  
ATOM    297  CB  MET    40      26.522  28.142  30.235  1.00 31.25           C  
ATOM    298  CG  MET    40      25.135  28.065  30.731  1.00 32.22           C  
ATOM    299  SD  MET    40      24.037  28.593  29.385  1.00 29.64           S  
ATOM    300  CE  MET    40      24.332  30.375  29.744  1.00 14.80           C  
ATOM    301  N   ALA    41      28.653  26.563  31.907  1.00 32.56           N  
ATOM    302  CA  ALA    41      29.001  25.498  32.827  1.00 34.18           C  
ATOM    303  C   ALA    41      29.751  26.059  34.045  1.00 35.19           C  
ATOM    304  O   ALA    41      29.487  25.666  35.180  1.00 35.38           O  
ATOM    305  CB  ALA    41      29.849  24.466  32.111  1.00 32.62           C  
ATOM    306  N   ARG    42      30.665  26.988  33.783  1.00 37.06           N  
ATOM    307  CA  ARG    42      31.529  27.591  34.812  1.00 38.62           C  
ATOM    308  C   ARG    42      30.791  28.428  35.869  1.00 39.64           C  
ATOM    309  O   ARG    42      31.287  28.584  37.001  1.00 39.95           O  
ATOM    310  CB  ARG    42      32.572  28.485  34.152  1.00 38.65           C  
ATOM    311  CG  ARG    42      33.751  27.754  33.556  1.00 39.99           C  
ATOM    312  CD  ARG    42      34.908  28.731  33.286  1.00 41.19           C  
ATOM    313  NE  ARG    42      34.645  29.613  32.138  1.00 43.78           N  
ATOM    314  CZ  ARG    42      34.921  29.314  30.863  1.00 44.28           C  
ATOM    315  NH1 ARG    42      35.480  28.148  30.541  1.00 44.54           N  
ATOM    316  NH2 ARG    42      34.638  30.187  29.898  1.00 44.28           N  
ATOM    317  N   ALA    43      29.637  28.986  35.503  1.00 40.08           N  
ATOM    318  CA  ALA    43      28.816  29.749  36.451  1.00 40.56           C  
ATOM    319  C   ALA    43      28.117  28.841  37.461  1.00 41.25           C  
ATOM    320  O   ALA    43      27.709  29.288  38.530  1.00 41.86           O  
ATOM    321  CB  ALA    43      27.786  30.595  35.710  1.00 40.30           C  
ATOM    322  N   ARG    44      27.961  27.568  37.124  1.00 41.72           N  
ATOM    323  CA  ARG    44      27.250  26.641  37.991  1.00 42.08           C  
ATOM    324  C   ARG    44      28.242  25.825  38.817  1.00 41.58           C  
ATOM    325  O   ARG    44      28.100  25.732  40.039  1.00 41.95           O  
ATOM    326  CB  ARG    44      26.340  25.723  37.164  1.00 43.09           C  
ATOM    327  CG  ARG    44      25.335  26.462  36.245  1.00 44.40           C  
ATOM    328  CD  ARG    44      24.118  25.581  35.871  1.00 45.76           C  
ATOM    329  NE  ARG    44      22.872  26.349  35.625  1.00 48.01           N  
ATOM    330  CZ  ARG    44      22.026  26.793  36.573  1.00 49.56           C  
ATOM    331  NH1 ARG    44      22.262  26.593  37.873  1.00 49.60           N  
ATOM    332  NH2 ARG    44      20.928  27.462  36.221  1.00 51.13           N  
ATOM    333  N   ILE    45      29.240  25.244  38.138  1.00 40.39           N  
ATOM    334  CA  ILE    45      30.274  24.410  38.776  1.00 39.11           C  
ATOM    335  C   ILE    45      31.687  24.850  38.379  1.00 38.08           C  
ATOM    336  O   ILE    45      31.865  25.683  37.491  1.00 38.36           O  
ATOM    337  CB  ILE    45      30.119  22.918  38.390  1.00 38.99           C  
ATOM    338  CG1 ILE    45      30.099  22.748  36.860  1.00 39.09           C  
ATOM    339  CG2 ILE    45      28.864  22.341  39.018  1.00 39.15           C  
ATOM    340  CD1 ILE    45      30.683  21.438  36.372  1.00 38.25           C  
ATOM    341  N   ARG    46      32.693  24.287  39.041  1.00 37.31           N  
ATOM    342  CA  ARG    46      34.071  24.437  38.583  1.00 36.07           C  
ATOM    343  C   ARG    46      34.280  23.353  37.530  1.00 34.15           C  
ATOM    344  O   ARG    46      34.767  22.268  37.832  1.00 34.04           O  
ATOM    345  CB  ARG    46      35.078  24.291  39.727  1.00 37.07           C  
ATOM    346  CG  ARG    46      36.557  24.488  39.298  1.00 38.01           C  
ATOM    347  CD  ARG    46      37.533  23.937  40.331  1.00 39.96           C  
ATOM    348  NE  ARG    46      38.902  23.815  39.802  1.00 42.24           N  
ATOM    349  CZ  ARG    46      39.565  22.672  39.610  1.00 44.17           C  
ATOM    350  NH1 ARG    46      39.016  21.496  39.903  1.00 44.92           N  
ATOM    351  NH2 ARG    46      40.812  22.707  39.136  1.00 46.21           N  
ATOM    352  N   SER    47      33.907  23.681  36.300  1.00 31.63           N  
ATOM    353  CA  SER    47      33.938  22.741  35.180  1.00 29.04           C  
ATOM    354  C   SER    47      35.338  22.625  34.620  1.00 27.09           C  
ATOM    355  O   SER    47      35.970  23.633  34.285  1.00 27.12           O  
ATOM    356  CB  SER    47      32.997  23.211  34.066  1.00 29.26           C  
ATOM    357  OG  SER    47      33.096  22.391  32.907  1.00 27.78           O  
ATOM    358  N   VAL    48      35.807  21.393  34.496  1.00 23.46           N  
ATOM    359  CA  VAL    48      37.115  21.127  33.918  1.00 22.51           C  
ATOM    360  C   VAL    48      37.078  20.419  32.563  1.00 20.54           C  
ATOM    361  O   VAL    48      38.143  20.221  31.966  1.00 21.74           O  
ATOM    362  CB  VAL    48      37.995  20.342  34.897  1.00 20.94           C  
ATOM    363  CG1 VAL    48      38.195  21.199  36.190  1.00 22.29           C  
ATOM    364  CG2 VAL    48      37.409  18.967  35.206  1.00 20.58           C  
ATOM    365  N   LEU    49      35.883  20.089  32.047  1.00 18.18           N  
ATOM    366  CA  LEU    49      35.761  19.448  30.736  1.00 17.39           C  
ATOM    367  C   LEU    49      35.203  20.429  29.717  1.00 16.50           C  
ATOM    368  O   LEU    49      34.129  21.020  29.973  1.00 15.92           O  
ATOM    369  CB  LEU    49      34.819  18.236  30.791  1.00 15.84           C  
ATOM    370  CG  LEU    49      35.151  17.123  31.790  1.00 16.96           C  
ATOM    371  CD1 LEU    49      34.098  16.007  31.674  1.00 14.35           C  
ATOM    372  CD2 LEU    49      36.594  16.607  31.611  1.00 16.62           C  
ATOM    373  N   PRO    50      35.896  20.603  28.579  1.00 16.79           N  
ATOM    374  CA  PRO    50      35.350  21.431  27.498  1.00 16.48           C  
ATOM    375  C   PRO    50      34.006  20.916  26.994  1.00 15.58           C  
ATOM    376  O   PRO    50      33.717  19.718  27.099  1.00 14.54           O  
ATOM    377  CB  PRO    50      36.381  21.295  26.394  1.00 16.78           C  
ATOM    378  CG  PRO    50      37.671  21.021  27.119  1.00 18.81           C  
ATOM    379  CD  PRO    50      37.237  20.089  28.220  1.00 17.39           C  
ATOM    380  N   PHE    51      33.207  21.836  26.445  1.00 15.67           N  
ATOM    381  CA  PHE    51      31.951  21.486  25.801  1.00 15.66           C  
ATOM    382  C   PHE    51      32.093  20.272  24.886  1.00 15.09           C  
ATOM    383  O   PHE    51      31.305  19.340  24.980  1.00 13.72           O  
ATOM    384  CB  PHE    51      31.409  22.692  25.019  1.00 15.91           C  
ATOM    385  CG  PHE    51      30.303  22.335  24.073  1.00 15.44           C  
ATOM    386  CD1 PHE    51      29.004  22.246  24.535  1.00 14.85           C  
ATOM    387  CD2 PHE    51      30.566  22.058  22.734  1.00 15.25           C  
ATOM    388  CE1 PHE    51      27.982  21.903  23.678  1.00 14.77           C  
ATOM    389  CE2 PHE    51      29.544  21.669  21.876  1.00 15.34           C  
ATOM    390  CZ  PHE    51      28.254  21.595  22.357  1.00 15.95           C  
ATOM    391  N   ALA    52      33.074  20.278  23.986  1.00 14.56           N  
ATOM    392  CA  ALA    52      33.231  19.191  23.033  1.00 14.97           C  
ATOM    393  C   ALA    52      33.367  17.829  23.722  1.00 14.32           C  
ATOM    394  O   ALA    52      32.832  16.826  23.240  1.00 15.48           O  
ATOM    395  CB  ALA    52      34.431  19.461  22.079  1.00 16.41           C  
ATOM    396  N   ILE    53      34.070  17.799  24.858  1.00 13.52           N  
ATOM    397  CA  ILE    53      34.293  16.541  25.575  1.00 13.10           C  
ATOM    398  C   ILE    53      32.998  16.098  26.271  1.00 12.98           C  
ATOM    399  O   ILE    53      32.618  14.930  26.206  1.00 12.86           O  
ATOM    400  CB  ILE    53      35.439  16.689  26.600  1.00 14.32           C  
ATOM    401  CG1 ILE    53      36.765  16.928  25.877  1.00 13.09           C  
ATOM    402  CG2 ILE    53      35.510  15.491  27.543  1.00 13.71           C  
ATOM    403  CD1 ILE    53      37.232  15.819  24.997  1.00 16.75           C  
ATOM    404  N   ARG    54      32.309  17.035  26.918  1.00 11.96           N  
ATOM    405  CA  ARG    54      31.023  16.739  27.569  1.00 13.00           C  
ATOM    406  C   ARG    54      29.969  16.253  26.553  1.00 12.32           C  
ATOM    407  O   ARG    54      29.275  15.261  26.784  1.00 13.11           O  
ATOM    408  CB  ARG    54      30.535  17.944  28.385  1.00 12.76           C  
ATOM    409  CG  ARG    54      31.468  18.239  29.556  1.00 14.19           C  
ATOM    410  CD  ARG    54      31.037  19.427  30.396  1.00 14.34           C  
ATOM    411  NE  ARG    54      31.269  20.704  29.747  1.00 14.76           N  
ATOM    412  CZ  ARG    54      30.337  21.519  29.277  1.00 15.21           C  
ATOM    413  NH1 ARG    54      29.048  21.208  29.324  1.00 15.32           N  
ATOM    414  NH2 ARG    54      30.732  22.668  28.736  1.00 14.70           N  
ATOM    415  N   ALA    55      29.867  16.944  25.431  1.00 12.64           N  
ATOM    416  CA  ALA    55      28.956  16.531  24.353  1.00 12.66           C  
ATOM    417  C   ALA    55      29.296  15.126  23.856  1.00 13.07           C  
ATOM    418  O   ALA    55      28.404  14.301  23.694  1.00 12.99           O  
ATOM    419  CB  ALA    55      28.965  17.548  23.195  1.00 12.53           C  
ATOM    420  N   GLU    56      30.579  14.839  23.633  1.00 13.42           N  
ATOM    421  CA  GLU    56      30.973  13.494  23.174  1.00 14.14           C  
ATOM    422  C   GLU    56      30.703  12.426  24.218  1.00 13.71           C  
ATOM    423  O   GLU    56      30.287  11.312  23.895  1.00 13.72           O  
ATOM    424  CB  GLU    56      32.448  13.464  22.728  1.00 16.10           C  
ATOM    425  CG  GLU    56      32.710  14.116  21.386  1.00 22.93           C  
ATOM    426  CD  GLU    56      31.888  13.493  20.234  1.00 26.82           C  
ATOM    427  OE1 GLU    56      31.798  12.232  20.137  1.00 30.93           O  
ATOM    428  OE2 GLU    56      31.331  14.272  19.434  1.00 33.09           O  
ATOM    429  N   ASN    57      30.898  12.771  25.487  1.00 12.65           N  
ATOM    430  CA  ASN    57      30.575  11.832  26.558  1.00 12.31           C  
ATOM    431  C   ASN    57      29.107  11.444  26.536  1.00 11.13           C  
ATOM    432  O   ASN    57      28.754  10.269  26.685  1.00 12.57           O  
ATOM    433  CB  ASN    57      30.971  12.375  27.925  1.00 12.47           C  
ATOM    434  CG  ASN    57      32.492  12.434  28.113  1.00 13.75           C  
ATOM    435  OD1 ASN    57      33.256  11.797  27.353  1.00 15.72           O  
ATOM    436  ND2 ASN    57      32.949  13.216  29.124  1.00 13.88           N  
ATOM    437  N   VAL    58      28.240  12.433  26.322  1.00 11.74           N  
ATOM    438  CA  VAL    58      26.794  12.165  26.253  1.00 11.83           C  
ATOM    439  C   VAL    58      26.484  11.325  25.009  1.00 12.12           C  
ATOM    440  O   VAL    58      25.775  10.324  25.079  1.00 11.96           O  
ATOM    441  CB  VAL    58      25.977  13.447  26.227  1.00 11.58           C  
ATOM    442  CG1 VAL    58      24.468  13.142  25.954  1.00 12.05           C  
ATOM    443  CG2 VAL    58      26.146  14.209  27.560  1.00 11.65           C  
ATOM    444  N   LYS    59      27.055  11.715  23.888  1.00 13.04           N  
ATOM    445  CA  LYS    59      26.827  10.994  22.631  1.00 14.82           C  
ATOM    446  C   LYS    59      27.242   9.532  22.730  1.00 13.71           C  
ATOM    447  O   LYS    59      26.483   8.644  22.303  1.00 13.83           O  
ATOM    448  CB  LYS    59      27.534  11.682  21.467  1.00 15.36           C  
ATOM    449  CG  LYS    59      26.817  12.936  21.013  1.00 18.62           C  
ATOM    450  CD  LYS    59      27.364  13.425  19.668  1.00 21.46           C  
ATOM    451  CE  LYS    59      28.705  13.980  19.800  1.00 26.55           C  
ATOM    452  NZ  LYS    59      29.234  14.414  18.433  1.00 28.78           N  
ATOM    453  N   ARG    60      28.412   9.267  23.326  1.00 13.45           N  
ATOM    454  CA  ARG    60      28.898   7.893  23.402  1.00 14.28           C  
ATOM    455  C   ARG    60      28.053   7.041  24.312  1.00 13.44           C  
ATOM    456  O   ARG    60      27.846   5.842  24.073  1.00 14.12           O  
ATOM    457  CB  ARG    60      30.337   7.839  23.869  1.00 14.99           C  
ATOM    458  CG  ARG    60      31.298   8.336  22.863  1.00 16.69           C  
ATOM    459  CD  ARG    60      32.716   7.892  23.243  1.00 20.50           C  
ATOM    460  NE  ARG    60      33.703   8.633  22.463  1.00 27.44           N  
ATOM    461  CZ  ARG    60      34.350   9.712  22.895  1.00 29.25           C  
ATOM    462  NH1 ARG    60      34.112  10.197  24.117  1.00 26.46           N  
ATOM    463  NH2 ARG    60      35.210  10.315  22.087  1.00 32.48           N  
ATOM    464  N   TYR    61      27.605   7.659  25.401  1.00 11.76           N  
ATOM    465  CA  TYR    61      26.743   6.966  26.386  1.00 12.36           C  
ATOM    466  C   TYR    61      25.424   6.559  25.724  1.00 11.63           C  
ATOM    467  O   TYR    61      24.978   5.403  25.808  1.00 12.36           O  
ATOM    468  CB  TYR    61      26.496   7.836  27.631  1.00 13.47           C  
ATOM    469  CG  TYR    61      25.439   7.212  28.496  1.00 11.48           C  
ATOM    470  CD1 TYR    61      25.740   6.132  29.305  1.00 12.93           C  
ATOM    471  CD2 TYR    61      24.113   7.653  28.455  1.00 11.47           C  
ATOM    472  CE1 TYR    61      24.790   5.512  30.036  1.00 15.21           C  
ATOM    473  CE2 TYR    61      23.122   7.040  29.213  1.00 11.88           C  
ATOM    474  CZ  TYR    61      23.478   5.954  30.014  1.00 13.60           C  
ATOM    475  OH  TYR    61      22.578   5.264  30.773  1.00 15.02           O  
ATOM    476  N   VAL    62      24.778   7.521  25.071  1.00 11.58           N  
ATOM    477  CA  VAL    62      23.527   7.245  24.365  1.00 11.94           C  
ATOM    478  C   VAL    62      23.693   6.190  23.250  1.00 12.08           C  
ATOM    479  O   VAL    62      22.854   5.298  23.104  1.00 13.31           O  
ATOM    480  CB  VAL    62      22.869   8.537  23.866  1.00 11.30           C  
ATOM    481  CG1 VAL    62      21.642   8.212  22.993  1.00 11.56           C  
ATOM    482  CG2 VAL    62      22.508   9.428  25.105  1.00 11.07           C  
ATOM    483  N   MET    63      24.763   6.286  22.469  1.00 12.42           N  
ATOM    484  CA  MET    63      25.029   5.263  21.453  1.00 13.34           C  
ATOM    485  C   MET    63      25.147   3.884  22.090  1.00 13.30           C  
ATOM    486  O   MET    63      24.519   2.928  21.631  1.00 13.71           O  
ATOM    487  CB  MET    63      26.291   5.595  20.653  1.00 12.85           C  
ATOM    488  CG  MET    63      26.621   4.559  19.570  1.00 14.82           C  
ATOM    489  SD  MET    63      25.317   4.258  18.278  1.00 17.76           S  
ATOM    490  CE  MET    63      25.709   5.680  17.656  1.00  8.33           C  
ATOM    491  N   ARG    64      25.964   3.799  23.141  0.50 13.72           N  
ATOM    493  CA  ARG    64      26.241   2.533  23.838  0.50 14.56           C  
ATOM    495  C   ARG    64      24.987   1.859  24.408  0.50 14.42           C  
ATOM    497  O   ARG    64      24.824   0.644  24.263  0.50 14.42           O  
ATOM    499  CB  ARG    64      27.265   2.801  24.940  0.50 15.09           C  
ATOM    501  CG  ARG    64      27.853   1.605  25.618  0.50 15.34           C  
ATOM    503  CD  ARG    64      29.210   1.947  26.276  0.50 17.30           C  
ATOM    505  NE  ARG    64      29.169   3.050  27.259  0.50 16.86           N  
ATOM    507  CZ  ARG    64      29.507   4.331  27.022  0.50 17.38           C  
ATOM    509  NH1 ARG    64      29.899   4.716  25.812  0.50 13.17           N  
ATOM    511  NH2 ARG    64      29.448   5.247  28.014  0.50 20.95           N  
ATOM    513  N   LYS    65      24.094   2.649  25.020  1.00 13.80           N  
ATOM    514  CA  LYS    65      22.887   2.146  25.716  1.00 14.41           C  
ATOM    515  C   LYS    65      21.624   2.121  24.874  1.00 14.43           C  
ATOM    516  O   LYS    65      20.746   1.303  25.112  1.00 16.33           O  
ATOM    517  CB  LYS    65      22.623   2.939  26.999  1.00 15.92           C  
ATOM    518  CG  LYS    65      23.678   2.760  28.045  1.00 19.23           C  
ATOM    519  CD  LYS    65      23.737   1.341  28.574  1.00 21.94           C  
ATOM    520  CE  LYS    65      24.663   1.222  29.780  1.00 23.96           C  
ATOM    521  NZ  LYS    65      24.661  -0.194  30.289  1.00 25.58           N  
ATOM    522  N   TYR    66      21.528   3.011  23.896  1.00 13.32           N  
ATOM    523  CA  TYR    66      20.300   3.181  23.111  1.00 13.30           C  
ATOM    524  C   TYR    66      20.442   3.008  21.616  1.00 13.49           C  
ATOM    525  O   TYR    66      19.426   2.968  20.911  1.00 13.88           O  
ATOM    526  CB  TYR    66      19.638   4.540  23.378  1.00 13.48           C  
ATOM    527  CG  TYR    66      19.282   4.697  24.838  1.00 11.89           C  
ATOM    528  CD1 TYR    66      18.062   4.231  25.336  1.00 11.09           C  
ATOM    529  CD2 TYR    66      20.170   5.276  25.758  1.00 11.93           C  
ATOM    530  CE1 TYR    66      17.734   4.359  26.701  1.00 11.94           C  
ATOM    531  CE2 TYR    66      19.839   5.385  27.100  1.00 13.26           C  
ATOM    532  CZ  TYR    66      18.645   4.893  27.579  1.00 11.02           C  
ATOM    533  OH  TYR    66      18.347   5.055  28.942  1.00 11.73           O  
ATOM    534  N   GLY    67      21.674   2.903  21.136  1.00 13.02           N  
ATOM    535  CA  GLY    67      21.922   2.550  19.739  1.00 13.78           C  
ATOM    536  C   GLY    67      21.686   3.655  18.734  1.00 14.04           C  
ATOM    537  O   GLY    67      21.559   3.372  17.530  1.00 15.18           O  
ATOM    538  N   PHE    68      21.678   4.924  19.181  1.00 13.26           N  
ATOM    539  CA  PHE    68      21.738   6.047  18.237  1.00 13.90           C  
ATOM    540  C   PHE    68      22.568   7.203  18.773  1.00 14.46           C  
ATOM    541  O   PHE    68      22.832   7.286  19.974  1.00 13.19           O  
ATOM    542  CB  PHE    68      20.337   6.507  17.850  1.00 14.20           C  
ATOM    543  CG  PHE    68      19.596   7.193  18.936  1.00 13.61           C  
ATOM    544  CD1 PHE    68      19.516   8.576  18.964  1.00 14.78           C  
ATOM    545  CD2 PHE    68      18.916   6.483  19.917  1.00 13.82           C  
ATOM    546  CE1 PHE    68      18.793   9.232  19.964  1.00 13.23           C  
ATOM    547  CE2 PHE    68      18.205   7.159  20.922  1.00 13.92           C  
ATOM    548  CZ  PHE    68      18.125   8.533  20.898  1.00 14.22           C  
ATOM    549  N   GLU    69      23.016   8.045  17.853  1.00 15.92           N  
ATOM    550  CA  GLU    69      23.665   9.293  18.209  1.00 17.21           C  
ATOM    551  C   GLU    69      22.617  10.410  18.348  1.00 16.92           C  
ATOM    552  O   GLU    69      21.981  10.808  17.346  1.00 17.49           O  
ATOM    553  CB  GLU    69      24.628   9.713  17.103  1.00 18.08           C  
ATOM    554  CG  GLU    69      25.473  10.934  17.498  1.00 20.54           C  
ATOM    555  CD  GLU    69      26.255  11.510  16.317  1.00 23.59           C  
ATOM    556  OE1 GLU    69      26.780  10.698  15.531  1.00 31.39           O  
ATOM    557  OE2 GLU    69      26.327  12.755  16.176  1.00 31.71           O  
ATOM    558  N   PRO    70      22.444  10.965  19.563  1.00 16.76           N  
ATOM    559  CA  PRO    70      21.428  11.994  19.781  1.00 16.70           C  
ATOM    560  C   PRO    70      21.843  13.338  19.195  1.00 17.28           C  
ATOM    561  O   PRO    70      23.032  13.625  19.113  1.00 17.29           O  
ATOM    562  CB  PRO    70      21.370  12.117  21.316  1.00 16.88           C  
ATOM    563  CG  PRO    70      22.738  11.763  21.745  1.00 16.50           C  
ATOM    564  CD  PRO    70      23.243  10.708  20.774  1.00 17.16           C  
ATOM    565  N   GLU    71      20.852  14.149  18.838  1.00 17.75           N  
ATOM    566  CA  GLU    71      21.089  15.538  18.481  1.00 18.43           C  
ATOM    567  C   GLU    71      21.540  16.292  19.741  1.00 17.06           C  
ATOM    568  O   GLU    71      20.790  16.345  20.733  1.00 17.40           O  
ATOM    569  CB  GLU    71      19.815  16.218  17.918  1.00 18.79           C  
ATOM    570  CG  GLU    71      20.024  17.725  17.587  1.00 20.45           C  
ATOM    571  CD  GLU    71      18.779  18.509  17.176  1.00 23.94           C  
ATOM    572  OE1 GLU    71      17.629  18.145  17.560  1.00 30.68           O  
ATOM    573  OE2 GLU    71      18.987  19.547  16.475  1.00 30.11           O  
ATOM    574  N   ILE    72      22.717  16.915  19.662  1.00 17.07           N  
ATOM    575  CA  ILE    72      23.248  17.793  20.705  1.00 16.89           C  
ATOM    576  C   ILE    72      23.207  19.233  20.216  1.00 17.09           C  
ATOM    577  O   ILE    72      23.688  19.549  19.113  1.00 17.97           O  
ATOM    578  CB  ILE    72      24.764  17.518  21.065  1.00 17.10           C  
ATOM    579  CG1 ILE    72      24.980  16.083  21.537  1.00 18.57           C  
ATOM    580  CG2 ILE    72      25.287  18.504  22.133  1.00 17.34           C  
ATOM    581  CD1 ILE    72      24.184  15.707  22.628  1.00 18.29           C  
ATOM    582  N   VAL    73      22.716  20.107  21.058  1.00 16.13           N  
ATOM    583  CA  VAL    73      22.765  21.537  20.763  1.00 17.66           C  
ATOM    584  C   VAL    73      23.485  22.241  21.915  1.00 16.58           C  
ATOM    585  O   VAL    73      23.312  21.877  23.084  1.00 16.35           O  
ATOM    586  CB  VAL    73      21.345  22.092  20.523  1.00 18.63           C  
ATOM    587  CG1 VAL    73      20.644  21.332  19.375  1.00 22.38           C  
ATOM    588  CG2 VAL    73      20.534  21.982  21.742  1.00 19.90           C  
ATOM    589  N   LYS    74      24.365  23.187  21.602  1.00 16.47           N  
ATOM    590  CA  LYS    74      24.999  23.974  22.645  1.00 16.56           C  
ATOM    591  C   LYS    74      23.994  24.952  23.226  1.00 16.03           C  
ATOM    592  O   LYS    74      23.319  25.703  22.477  1.00 16.09           O  
ATOM    593  CB  LYS    74      26.206  24.748  22.098  1.00 16.48           C  
ATOM    594  CG  LYS    74      26.997  25.464  23.135  1.00 16.70           C  
ATOM    595  CD  LYS    74      28.140  26.283  22.521  1.00 18.90           C  
ATOM    596  CE  LYS    74      29.236  25.419  21.913  1.00 19.91           C  
ATOM    597  NZ  LYS    74      30.425  26.220  21.394  1.00 21.89           N  
ATOM    598  N   ILE    75      23.901  24.945  24.549  1.00 15.14           N  
ATOM    599  CA  ILE    75      23.079  25.906  25.298  1.00 15.73           C  
ATOM    600  C   ILE    75      23.963  27.119  25.607  1.00 15.81           C  
ATOM    601  O   ILE    75      24.993  26.990  26.257  1.00 15.11           O  
ATOM    602  CB  ILE    75      22.539  25.284  26.610  1.00 15.47           C  
ATOM    603  CG1 ILE    75      21.617  24.098  26.342  1.00 16.98           C  
ATOM    604  CG2 ILE    75      21.769  26.311  27.426  1.00 16.63           C  
ATOM    605  CD1 ILE    75      21.311  23.242  27.597  1.00 17.89           C  
ATOM    606  N   THR    76      23.574  28.284  25.088  1.00 15.68           N  
ATOM    607  CA  THR    76      24.336  29.527  25.255  1.00 16.59           C  
ATOM    608  C   THR    76      23.535  30.635  25.969  1.00 17.47           C  
ATOM    609  O   THR    76      24.002  31.765  26.127  1.00 18.88           O  
ATOM    610  CB  THR    76      24.801  30.007  23.877  1.00 16.61           C  
ATOM    611  OG1 THR    76      23.646  30.271  23.070  1.00 17.91           O  
ATOM    612  CG2 THR    76      25.679  28.903  23.215  1.00 18.43           C  
ATOM    613  N   ASN    77      22.335  30.302  26.422  1.00 16.68           N  
ATOM    614  CA  ASN    77      21.570  31.172  27.297  1.00 16.46           C  
ATOM    615  C   ASN    77      20.719  30.263  28.177  1.00 17.27           C  
ATOM    616  O   ASN    77      20.585  29.063  27.885  1.00 15.70           O  
ATOM    617  CB  ASN    77      20.742  32.152  26.443  1.00 15.99           C  
ATOM    618  CG  ASN    77      19.507  31.502  25.847  1.00 15.62           C  
ATOM    619  OD1 ASN    77      18.517  31.327  26.536  1.00 16.24           O  
ATOM    620  ND2 ASN    77      19.549  31.165  24.556  1.00 17.12           N  
ATOM    621  N   PRO    78      20.145  30.812  29.264  1.00 18.76           N  
ATOM    622  CA  PRO    78      19.420  29.969  30.232  1.00 19.15           C  
ATOM    623  C   PRO    78      18.264  29.140  29.657  1.00 18.58           C  
ATOM    624  O   PRO    78      17.904  28.090  30.199  1.00 20.15           O  
ATOM    625  CB  PRO    78      18.861  30.980  31.226  1.00 19.82           C  
ATOM    626  CG  PRO    78      19.736  32.142  31.133  1.00 21.04           C  
ATOM    627  CD  PRO    78      20.206  32.223  29.690  1.00 19.89           C  
ATOM    628  N   TYR    79      17.661  29.628  28.588  1.00 17.34           N  
ATOM    629  CA  TYR    79      16.519  28.976  27.991  1.00 16.20           C  
ATOM    630  C   TYR    79      16.861  28.000  26.901  1.00 15.47           C  
ATOM    631  O   TYR    79      15.985  27.238  26.466  1.00 15.10           O  
ATOM    632  CB  TYR    79      15.597  30.010  27.352  1.00 15.90           C  
ATOM    633  CG  TYR    79      15.011  30.950  28.345  1.00 15.48           C  
ATOM    634  CD1 TYR    79      13.769  30.704  28.911  1.00 17.45           C  
ATOM    635  CD2 TYR    79      15.698  32.086  28.743  1.00 14.04           C  
ATOM    636  CE1 TYR    79      13.247  31.569  29.830  1.00 16.85           C  
ATOM    637  CE2 TYR    79      15.180  32.944  29.667  1.00 16.91           C  
ATOM    638  CZ  TYR    79      13.951  32.687  30.215  1.00 15.93           C  
ATOM    639  OH  TYR    79      13.422  33.585  31.115  1.00 18.91           O  
ATOM    640  N   GLY    80      18.092  28.053  26.408  1.00 15.25           N  
ATOM    641  CA  GLY    80      18.435  27.321  25.183  1.00 15.81           C  
ATOM    642  C   GLY    80      17.470  27.711  24.100  1.00 15.93           C  
ATOM    643  O   GLY    80      17.229  28.904  23.883  1.00 15.35           O  
ATOM    644  N   LYS    81      16.896  26.705  23.444  1.00 15.81           N  
ATOM    645  CA  LYS    81      15.927  26.917  22.377  1.00 17.49           C  
ATOM    646  C   LYS    81      14.467  26.838  22.838  1.00 15.60           C  
ATOM    647  O   LYS    81      13.548  26.860  22.027  1.00 15.50           O  
ATOM    648  CB  LYS    81      16.108  25.871  21.272  1.00 18.87           C  
ATOM    649  CG  LYS    81      17.442  25.873  20.529  1.00 23.70           C  
ATOM    650  CD  LYS    81      17.345  24.877  19.355  1.00 24.41           C  
ATOM    651  CE  LYS    81      17.208  23.371  19.816  1.00 29.76           C  
ATOM    652  NZ  LYS    81      16.368  22.506  18.879  1.00 31.50           N  
ATOM    653  N   THR    82      14.247  26.741  24.138  1.00 14.47           N  
ATOM    654  CA  THR    82      12.922  26.387  24.622  1.00 14.90           C  
ATOM    655  C   THR    82      11.891  27.506  24.569  1.00 14.91           C  
ATOM    656  O   THR    82      10.742  27.263  24.840  1.00 15.20           O  
ATOM    657  CB  THR    82      12.971  25.865  26.071  1.00 14.78           C  
ATOM    658  OG1 THR    82      13.427  26.918  26.913  1.00 13.78           O  
ATOM    659  CG2 THR    82      13.856  24.607  26.195  1.00 14.24           C  
ATOM    660  N   LEU    83      12.277  28.739  24.191  1.00 14.68           N  
ATOM    661  CA  LEU    83      11.285  29.788  23.967  1.00 16.16           C  
ATOM    662  C   LEU    83      10.883  29.888  22.509  1.00 17.95           C  
ATOM    663  O   LEU    83      10.008  30.664  22.167  1.00 19.26           O  
ATOM    664  CB  LEU    83      11.822  31.145  24.427  1.00 15.28           C  
ATOM    665  CG  LEU    83      12.125  31.268  25.910  1.00 13.89           C  
ATOM    666  CD1 LEU    83      12.576  32.666  26.258  1.00 14.46           C  
ATOM    667  CD2 LEU    83      10.934  30.832  26.753  1.00 15.10           C  
ATOM    668  N   ASP    84      11.548  29.121  21.654  1.00 18.26           N  
ATOM    669  CA  ASP    84      11.417  29.242  20.207  1.00 19.93           C  
ATOM    670  C   ASP    84      10.801  27.950  19.651  1.00 20.58           C  
ATOM    671  O   ASP    84       9.717  27.960  19.040  1.00 23.22           O  
ATOM    672  CB  ASP    84      12.823  29.503  19.631  1.00 20.41           C  
ATOM    673  CG  ASP    84      12.804  30.124  18.266  1.00 23.44           C  
ATOM    674  OD1 ASP    84      11.772  30.721  17.880  1.00 24.14           O  
ATOM    675  OD2 ASP    84      13.849  30.020  17.590  1.00 28.03           O  
ATOM    676  N   VAL    85      11.448  26.835  19.926  1.00 19.96           N  
ATOM    677  CA  VAL    85      11.002  25.535  19.429  1.00 20.01           C  
ATOM    678  C   VAL    85       9.839  25.044  20.248  1.00 19.61           C  
ATOM    679  O   VAL    85       9.802  25.242  21.486  1.00 20.17           O  
ATOM    680  CB  VAL    85      12.156  24.504  19.500  1.00 20.71           C  
ATOM    681  CG1 VAL    85      11.684  23.068  19.069  1.00 20.75           C  
ATOM    682  CG2 VAL    85      13.355  24.973  18.702  1.00 21.26           C  
ATOM    683  N   ASP    86       8.904  24.360  19.591  1.00 18.57           N  
ATOM    684  CA  ASP    86       7.778  23.773  20.272  1.00 18.03           C  
ATOM    685  C   ASP    86       8.215  22.357  20.629  1.00 18.31           C  
ATOM    686  O   ASP    86       8.616  21.555  19.737  1.00 23.07           O  
ATOM    687  CB  ASP    86       6.488  23.770  19.447  1.00 18.24           C  
ATOM    688  CG  ASP    86       5.892  25.171  19.250  1.00 19.60           C  
ATOM    689  OD1 ASP    86       6.122  26.073  20.083  1.00 20.00           O  
ATOM    690  OD2 ASP    86       5.164  25.373  18.247  1.00 26.95           O  
ATOM    691  N   PHE    87       8.274  22.110  21.921  1.00 15.77           N  
ATOM    692  CA  PHE    87       8.522  20.796  22.489  1.00 14.97           C  
ATOM    693  C   PHE    87       7.238  20.306  23.139  1.00 14.36           C  
ATOM    694  O   PHE    87       6.475  21.101  23.715  1.00 16.07           O  
ATOM    695  CB  PHE    87       9.616  20.868  23.578  1.00 15.50           C  
ATOM    696  CG  PHE    87      10.971  21.209  23.058  1.00 13.43           C  
ATOM    697  CD1 PHE    87      11.752  20.245  22.439  1.00 13.21           C  
ATOM    698  CD2 PHE    87      11.496  22.490  23.219  1.00 15.72           C  
ATOM    699  CE1 PHE    87      13.005  20.557  21.948  1.00 14.34           C  
ATOM    700  CE2 PHE    87      12.758  22.807  22.744  1.00 17.48           C  
ATOM    701  CZ  PHE    87      13.516  21.837  22.100  1.00 17.13           C  
ATOM    702  N   GLU    88       7.011  19.003  23.075  1.00 13.81           N  
ATOM    703  CA  GLU    88       5.893  18.411  23.800  1.00 14.23           C  
ATOM    704  C   GLU    88       6.193  18.236  25.306  1.00 12.95           C  
ATOM    705  O   GLU    88       5.342  18.519  26.146  1.00 13.84           O  
ATOM    706  CB  GLU    88       5.515  17.067  23.187  1.00 15.08           C  
ATOM    707  CG  GLU    88       4.282  16.458  23.785  1.00 17.83           C  
ATOM    708  CD  GLU    88       3.724  15.289  22.946  1.00 20.60           C  
ATOM    709  OE1 GLU    88       4.189  15.082  21.791  1.00 27.86           O  
ATOM    710  OE2 GLU    88       2.828  14.573  23.439  1.00 28.57           O  
ATOM    711  N   TYR    89       7.396  17.755  25.620  1.00 11.81           N  
ATOM    712  CA  TYR    89       7.822  17.477  26.990  1.00 11.27           C  
ATOM    713  C   TYR    89       9.185  18.150  27.213  1.00 11.40           C  
ATOM    714  O   TYR    89      10.022  18.186  26.305  1.00 10.90           O  
ATOM    715  CB  TYR    89       8.001  15.959  27.202  1.00 11.70           C  
ATOM    716  CG  TYR    89       6.701  15.179  27.204  1.00 12.19           C  
ATOM    717  CD1 TYR    89       5.759  15.378  28.197  1.00 12.35           C  
ATOM    718  CD2 TYR    89       6.420  14.245  26.208  1.00 13.35           C  
ATOM    719  CE1 TYR    89       4.590  14.667  28.227  1.00 13.25           C  
ATOM    720  CE2 TYR    89       5.223  13.539  26.212  1.00 15.02           C  
ATOM    721  CZ  TYR    89       4.314  13.757  27.240  1.00 13.79           C  
ATOM    722  OH  TYR    89       3.100  13.075  27.329  1.00 15.53           O  
ATOM    723  N   LEU    90       9.390  18.599  28.444  1.00 10.72           N  
ATOM    724  CA  LEU    90      10.661  19.111  28.917  1.00 11.33           C  
ATOM    725  C   LEU    90      10.997  18.313  30.166  1.00 10.59           C  
ATOM    726  O   LEU    90      10.265  18.374  31.171  1.00 10.36           O  
ATOM    727  CB  LEU    90      10.537  20.595  29.263  1.00 11.48           C  
ATOM    728  CG  LEU    90      11.730  21.327  29.933  1.00 13.14           C  
ATOM    729  CD1 LEU    90      13.088  21.124  29.246  1.00 16.06           C  
ATOM    730  CD2 LEU    90      11.381  22.844  30.128  1.00 14.77           C  
ATOM    731  N   VAL    91      12.056  17.523  30.073  1.00 11.25           N  
ATOM    732  CA  VAL    91      12.467  16.603  31.118  1.00 11.78           C  
ATOM    733  C   VAL    91      13.546  17.294  31.947  1.00 12.13           C  
ATOM    734  O   VAL    91      14.563  17.728  31.398  1.00 13.11           O  
ATOM    735  CB  VAL    91      13.013  15.263  30.558  1.00 11.91           C  
ATOM    736  CG1 VAL    91      13.604  14.415  31.728  1.00 14.39           C  
ATOM    737  CG2 VAL    91      11.892  14.530  29.836  1.00 13.13           C  
ATOM    738  N   VAL    92      13.292  17.388  33.255  1.00 11.12           N  
ATOM    739  CA  VAL    92      14.135  18.135  34.179  1.00 11.34           C  
ATOM    740  C   VAL    92      14.345  17.380  35.487  1.00 12.37           C  
ATOM    741  O   VAL    92      13.673  16.429  35.767  1.00 12.98           O  
ATOM    742  CB  VAL    92      13.537  19.547  34.477  1.00 11.68           C  
ATOM    743  CG1 VAL    92      13.545  20.355  33.200  1.00 13.42           C  
ATOM    744  CG2 VAL    92      12.166  19.458  35.073  1.00 12.28           C  
ATOM    745  N   SER    93      15.339  17.818  36.244  1.00 14.03           N  
ATOM    746  CA  SER    93      15.642  17.281  37.555  1.00 14.54           C  
ATOM    747  C   SER    93      15.206  18.301  38.588  1.00 15.11           C  
ATOM    748  O   SER    93      14.753  19.388  38.238  1.00 15.71           O  
ATOM    749  CB  SER    93      17.135  17.060  37.674  1.00 16.06           C  
ATOM    750  OG  SER    93      17.804  18.285  37.808  1.00 18.04           O  
ATOM    751  N   PRO    94      15.332  17.972  39.877  1.00 15.47           N  
ATOM    752  CA  PRO    94      15.004  18.996  40.883  1.00 16.58           C  
ATOM    753  C   PRO    94      15.843  20.256  40.761  1.00 17.77           C  
ATOM    754  O   PRO    94      15.346  21.342  41.078  1.00 20.38           O  
ATOM    755  CB  PRO    94      15.260  18.267  42.217  1.00 17.45           C  
ATOM    756  CG  PRO    94      15.055  16.804  41.873  1.00 17.30           C  
ATOM    757  CD  PRO    94      15.645  16.658  40.487  1.00 16.19           C  
ATOM    758  N   GLU    95      17.050  20.129  40.222  1.00 18.27           N  
ATOM    759  CA  GLU    95      17.962  21.254  40.080  1.00 20.11           C  
ATOM    760  C   GLU    95      17.563  22.185  38.942  1.00 19.08           C  
ATOM    761  O   GLU    95      17.938  23.379  38.936  1.00 20.74           O  
ATOM    762  CB  GLU    95      19.392  20.766  39.820  1.00 21.60           C  
ATOM    763  CG  GLU    95      20.026  20.044  40.999  1.00 25.73           C  
ATOM    764  CD  GLU    95      21.471  19.634  40.725  1.00 27.29           C  
ATOM    765  OE1 GLU    95      22.036  20.018  39.662  1.00 35.14           O  
ATOM    766  OE2 GLU    95      22.058  18.923  41.578  1.00 35.97           O  
ATOM    767  N   THR    96      16.789  21.659  37.997  1.00 16.64           N  
ATOM    768  CA  THR    96      16.410  22.448  36.808  1.00 16.79           C  
ATOM    769  C   THR    96      14.883  22.697  36.720  1.00 15.67           C  
ATOM    770  O   THR    96      14.382  23.320  35.776  1.00 15.11           O  
ATOM    771  CB  THR    96      16.957  21.794  35.520  1.00 18.25           C  
ATOM    772  OG1 THR    96      16.578  20.416  35.468  1.00 19.93           O  
ATOM    773  CG2 THR    96      18.488  21.879  35.488  1.00 19.96           C  
ATOM    774  N   TYR    97      14.149  22.267  37.736  1.00 13.50           N  
ATOM    775  CA  TYR    97      12.688  22.405  37.718  1.00 14.27           C  
ATOM    776  C   TYR    97      12.217  23.869  37.810  1.00 13.74           C  
ATOM    777  O   TYR    97      11.298  24.282  37.100  1.00 12.80           O  
ATOM    778  CB  TYR    97      12.083  21.556  38.829  1.00 14.67           C  
ATOM    779  CG  TYR    97      10.585  21.625  38.948  1.00 14.02           C  
ATOM    780  CD1 TYR    97       9.744  21.153  37.955  1.00 14.72           C  
ATOM    781  CD2 TYR    97       9.998  22.157  40.065  1.00 15.94           C  
ATOM    782  CE1 TYR    97       8.372  21.226  38.070  1.00 14.52           C  
ATOM    783  CE2 TYR    97       8.630  22.227  40.192  1.00 17.94           C  
ATOM    784  CZ  TYR    97       7.814  21.752  39.195  1.00 17.04           C  
ATOM    785  OH  TYR    97       6.452  21.827  39.333  1.00 17.72           O  
ATOM    786  N   GLU    98      12.856  24.672  38.666  1.00 14.09           N  
ATOM    787  CA  GLU    98      12.456  26.072  38.750  1.00 14.94           C  
ATOM    788  C   GLU    98      12.639  26.753  37.394  1.00 13.33           C  
ATOM    789  O   GLU    98      11.807  27.588  36.991  1.00 14.13           O  
ATOM    790  CB  GLU    98      13.238  26.792  39.848  1.00 15.29           C  
ATOM    791  CG  GLU    98      12.734  26.400  41.225  1.00 18.61           C  
ATOM    792  CD  GLU    98      13.658  26.851  42.363  1.00 19.35           C  
ATOM    793  OE1 GLU    98      14.796  26.347  42.441  1.00 27.21           O  
ATOM    794  OE2 GLU    98      13.235  27.698  43.164  1.00 25.66           O  
ATOM    795  N   MET    99      13.703  26.403  36.675  1.00 14.45           N  
ATOM    796  CA  MET    99      13.956  27.028  35.381  1.00 13.61           C  
ATOM    797  C   MET    99      12.881  26.572  34.387  1.00 13.41           C  
ATOM    798  O   MET    99      12.441  27.364  33.539  1.00 12.92           O  
ATOM    799  CB  MET    99      15.348  26.744  34.847  1.00 13.90           C  
ATOM    800  CG  MET    99      15.663  27.451  33.512  1.00 15.51           C  
ATOM    801  SD  MET    99      15.889  29.262  33.666  1.00 13.60           S  
ATOM    802  CE  MET    99      15.240  29.846  32.084  1.00 19.76           C  
ATOM    803  N   ALA   100      12.452  25.316  34.480  1.00 11.89           N  
ATOM    804  CA  ALA   100      11.332  24.834  33.639  1.00 12.65           C  
ATOM    805  C   ALA   100      10.066  25.663  33.854  1.00 12.02           C  
ATOM    806  O   ALA   100       9.364  26.011  32.916  1.00 11.38           O  
ATOM    807  CB  ALA   100      11.025  23.393  33.950  1.00 13.36           C  
ATOM    808  N   LEU   101       9.740  25.944  35.107  1.00 12.49           N  
ATOM    809  CA  LEU   101       8.566  26.776  35.367  1.00 12.91           C  
ATOM    810  C   LEU   101       8.731  28.160  34.734  1.00 12.58           C  
ATOM    811  O   LEU   101       7.790  28.699  34.160  1.00 13.21           O  
ATOM    812  CB  LEU   101       8.307  26.920  36.854  1.00 13.70           C  
ATOM    813  CG  LEU   101       7.965  25.594  37.567  1.00 14.39           C  
ATOM    814  CD1 LEU   101       7.941  25.869  39.084  1.00 17.21           C  
ATOM    815  CD2 LEU   101       6.666  24.971  37.060  1.00 15.43           C  
ATOM    816  N   LYS   102       9.936  28.697  34.821  1.00 12.71           N  
ATOM    817  CA  LYS   102      10.269  30.007  34.210  1.00 13.30           C  
ATOM    818  C   LYS   102      10.116  29.974  32.672  1.00 12.90           C  
ATOM    819  O   LYS   102       9.587  30.925  32.047  1.00 12.75           O  
ATOM    820  CB  LYS   102      11.676  30.467  34.625  1.00 14.96           C  
ATOM    821  CG  LYS   102      12.126  31.790  34.060  1.00 16.12           C  
ATOM    822  CD  LYS   102      11.341  32.917  34.623  1.00 20.18           C  
ATOM    823  CE  LYS   102      12.098  34.236  34.497  1.00 20.75           C  
ATOM    824  NZ  LYS   102      11.340  35.316  35.172  1.00 23.62           N  
ATOM    825  N   ILE   103      10.605  28.895  32.084  1.00 11.64           N  
ATOM    826  CA  ILE   103      10.440  28.652  30.646  1.00 11.86           C  
ATOM    827  C   ILE   103       8.949  28.760  30.240  1.00 11.89           C  
ATOM    828  O   ILE   103       8.607  29.472  29.300  1.00 11.81           O  
ATOM    829  CB  ILE   103      11.081  27.329  30.208  1.00 11.04           C  
ATOM    830  CG1 ILE   103      12.632  27.440  30.216  1.00 11.84           C  
ATOM    831  CG2 ILE   103      10.561  26.907  28.838  1.00 12.00           C  
ATOM    832  CD1 ILE   103      13.414  26.109  30.239  1.00 11.87           C  
ATOM    833  N   ASN   104       8.059  28.078  30.966  1.00 11.29           N  
ATOM    834  CA  ASN   104       6.640  28.127  30.617  1.00 12.57           C  
ATOM    835  C   ASN   104       6.045  29.514  30.861  1.00 12.86           C  
ATOM    836  O   ASN   104       5.206  29.965  30.091  1.00 13.08           O  
ATOM    837  CB  ASN   104       5.828  27.054  31.347  1.00 13.28           C  
ATOM    838  CG  ASN   104       5.804  25.750  30.587  1.00 11.78           C  
ATOM    839  OD1 ASN   104       6.081  25.739  29.355  1.00 13.35           O  
ATOM    840  ND2 ASN   104       5.440  24.664  31.259  1.00 12.46           N  
ATOM    841  N   GLN   105       6.527  30.212  31.895  1.00 13.24           N  
ATOM    842  CA  GLN   105       6.027  31.575  32.183  1.00 14.94           C  
ATOM    843  C   GLN   105       6.349  32.487  31.015  1.00 14.48           C  
ATOM    844  O   GLN   105       5.466  33.220  30.507  1.00 14.27           O  
ATOM    845  CB  GLN   105       6.623  32.126  33.470  1.00 15.54           C  
ATOM    846  CG  GLN   105       6.048  31.483  34.684  1.00 19.27           C  
ATOM    847  CD  GLN   105       6.812  31.779  35.953  1.00 21.05           C  
ATOM    848  OE1 GLN   105       7.813  32.507  35.950  1.00 27.77           O  
ATOM    849  NE2 GLN   105       6.340  31.210  37.060  1.00 31.26           N  
ATOM    850  N   LYS   106       7.597  32.386  30.539  1.00 14.13           N  
ATOM    851  CA  LYS   106       8.028  33.210  29.404  1.00 13.78           C  
ATOM    852  C   LYS   106       7.352  32.801  28.102  1.00 13.10           C  
ATOM    853  O   LYS   106       7.029  33.652  27.273  1.00 11.97           O  
ATOM    854  CB  LYS   106       9.543  33.208  29.228  1.00 14.19           C  
ATOM    855  CG  LYS   106      10.259  33.941  30.303  1.00 18.32           C  
ATOM    856  CD  LYS   106      10.060  35.427  30.112  1.00 21.04           C  
ATOM    857  CE  LYS   106      10.546  36.193  31.255  1.00 24.98           C  
ATOM    858  NZ  LYS   106      10.128  37.610  31.050  1.00 26.40           N  
ATOM    859  N   ARG   107       7.190  31.505  27.886  1.00 12.79           N  
ATOM    860  CA  ARG   107       6.443  31.067  26.714  1.00 13.42           C  
ATOM    861  C   ARG   107       5.045  31.685  26.736  1.00 14.01           C  
ATOM    862  O   ARG   107       4.575  32.194  25.714  1.00 13.64           O  
ATOM    863  CB  ARG   107       6.385  29.547  26.629  1.00 12.63           C  
ATOM    864  CG  ARG   107       7.713  28.952  26.186  1.00 12.41           C  
ATOM    865  CD  ARG   107       7.684  27.448  26.118  1.00 13.49           C  
ATOM    866  NE  ARG   107       6.808  26.931  25.059  1.00 13.18           N  
ATOM    867  CZ  ARG   107       7.163  26.635  23.808  1.00 13.92           C  
ATOM    868  NH1 ARG   107       8.401  26.810  23.385  1.00 13.78           N  
ATOM    869  NH2 ARG   107       6.260  26.127  22.963  1.00 14.25           N  
ATOM    870  N   GLU   108       4.392  31.657  27.887  1.00 15.11           N  
ATOM    871  CA  GLU   108       3.042  32.245  27.939  1.00 16.75           C  
ATOM    872  C   GLU   108       3.090  33.736  27.614  1.00 16.81           C  
ATOM    873  O   GLU   108       2.224  34.249  26.894  1.00 17.86           O  
ATOM    874  CB  GLU   108       2.356  31.985  29.274  1.00 17.37           C  
ATOM    875  CG  GLU   108       0.890  32.480  29.273  1.00 19.28           C  
ATOM    876  CD  GLU   108       0.089  31.985  30.476  1.00 23.61           C  
ATOM    877  OE1 GLU   108       0.678  31.472  31.428  1.00 31.69           O  
ATOM    878  OE2 GLU   108      -1.163  32.139  30.460  1.00 35.89           O  
ATOM    879  N   GLU   109       4.083  34.437  28.133  1.00 16.41           N  
ATOM    880  CA  GLU   109       4.211  35.871  27.856  1.00 17.00           C  
ATOM    881  C   GLU   109       4.443  36.162  26.370  1.00 16.36           C  
ATOM    882  O   GLU   109       3.997  37.203  25.854  1.00 15.75           O  
ATOM    883  CB  GLU   109       5.353  36.488  28.667  1.00 17.44           C  
ATOM    884  CG  GLU   109       5.110  36.502  30.157  1.00 20.52           C  
ATOM    885  CD  GLU   109       6.262  37.091  30.937  1.00 21.92           C  
ATOM    886  OE1 GLU   109       7.149  37.757  30.345  1.00 25.86           O  
ATOM    887  OE2 GLU   109       6.264  36.909  32.183  1.00 31.37           O  
ATOM    888  N   LEU   110       5.183  35.284  25.701  1.00 14.42           N  
ATOM    889  CA  LEU   110       5.557  35.468  24.307  1.00 15.12           C  
ATOM    890  C   LEU   110       4.475  35.023  23.320  1.00 14.70           C  
ATOM    891  O   LEU   110       4.491  35.440  22.147  1.00 16.14           O  
ATOM    892  CB  LEU   110       6.833  34.694  24.000  1.00 15.98           C  
ATOM    893  CG  LEU   110       8.086  35.231  24.705  1.00 16.10           C  
ATOM    894  CD1 LEU   110       9.207  34.213  24.475  1.00 18.76           C  
ATOM    895  CD2 LEU   110       8.442  36.645  24.222  1.00 15.74           C  
ATOM    896  N   GLY   111       3.535  34.215  23.790  1.00 13.69           N  
ATOM    897  CA  GLY   111       2.463  33.680  22.955  1.00 14.39           C  
ATOM    898  C   GLY   111       2.781  32.328  22.364  1.00 14.54           C  
ATOM    899  O   GLY   111       2.374  32.015  21.233  1.00 14.85           O  
ATOM    900  N   LYS   112       3.517  31.527  23.144  1.00 14.09           N  
ATOM    901  CA  LYS   112       3.825  30.140  22.785  1.00 16.27           C  
ATOM    902  C   LYS   112       3.070  29.189  23.697  1.00 16.18           C  
ATOM    903  O   LYS   112       2.888  29.466  24.894  1.00 17.12           O  
ATOM    904  CB  LYS   112       5.314  29.895  22.963  1.00 16.35           C  
ATOM    905  CG  LYS   112       6.211  30.796  22.207  1.00 18.82           C  
ATOM    906  CD  LYS   112       6.196  30.503  20.751  1.00 21.02           C  
ATOM    907  CE  LYS   112       6.995  29.250  20.414  1.00 22.96           C  
ATOM    908  NZ  LYS   112       6.780  28.819  19.010  1.00 22.04           N  
ATOM    909  N   ARG   113       2.670  28.043  23.169  1.00 16.05           N  
ATOM    910  CA  ARG   113       1.990  27.063  24.020  1.00 18.05           C  
ATOM    911  C   ARG   113       2.943  26.507  25.064  1.00 15.90           C  
ATOM    912  O   ARG   113       4.093  26.301  24.796  1.00 14.60           O  
ATOM    913  CB  ARG   113       1.438  25.912  23.228  1.00 18.52           C  
ATOM    914  CG  ARG   113       2.433  25.132  22.454  1.00 24.08           C  
ATOM    915  CD  ARG   113       1.831  23.772  22.103  1.00 27.52           C  
ATOM    916  NE  ARG   113       2.536  23.126  20.998  1.00 31.99           N  
ATOM    917  CZ  ARG   113       2.442  23.504  19.721  1.00 34.87           C  
ATOM    918  NH1 ARG   113       1.714  24.554  19.373  1.00 35.19           N  
ATOM    919  NH2 ARG   113       3.112  22.843  18.789  1.00 36.68           N  
ATOM    920  N   LYS   114       2.419  26.217  26.229  1.00 15.91           N  
ATOM    921  CA  LYS   114       3.230  25.669  27.288  1.00 16.73           C  
ATOM    922  C   LYS   114       3.722  24.263  26.894  1.00 15.85           C  
ATOM    923  O   LYS   114       3.129  23.561  26.056  1.00 16.72           O  
ATOM    924  CB  LYS   114       2.468  25.702  28.616  1.00 18.98           C  
ATOM    925  CG  LYS   114       2.443  27.127  29.242  1.00 20.81           C  
ATOM    926  CD  LYS   114       1.656  27.170  30.548  1.00 22.74           C  
ATOM    927  CE  LYS   114       1.697  28.497  31.205  1.00 27.34           C  
ATOM    928  NZ  LYS   114       3.104  29.026  31.381  1.00 35.08           N  
ATOM    929  N   ILE   115       4.853  23.899  27.469  1.00 13.60           N  
ATOM    930  CA  ILE   115       5.431  22.549  27.355  1.00 12.90           C  
ATOM    931  C   ILE   115       5.060  21.752  28.611  1.00 12.54           C  
ATOM    932  O   ILE   115       5.055  22.298  29.711  1.00 13.46           O  
ATOM    933  CB  ILE   115       6.989  22.638  27.258  1.00 12.66           C  
ATOM    934  CG1 ILE   115       7.465  23.593  26.126  1.00 13.12           C  
ATOM    935  CG2 ILE   115       7.615  21.243  27.106  1.00 14.45           C  
ATOM    936  CD1 ILE   115       8.906  23.931  26.217  1.00 14.24           C  
ATOM    937  N   THR   116       4.769  20.464  28.457  1.00 11.56           N  
ATOM    938  CA  THR   116       4.528  19.618  29.641  1.00 11.56           C  
ATOM    939  C   THR   116       5.857  19.319  30.348  1.00 11.81           C  
ATOM    940  O   THR   116       6.731  18.695  29.761  1.00 11.11           O  
ATOM    941  CB  THR   116       3.796  18.319  29.281  1.00 11.18           C  
ATOM    942  OG1 THR   116       2.512  18.661  28.748  1.00 13.86           O  
ATOM    943  CG2 THR   116       3.584  17.463  30.528  1.00 13.88           C  
ATOM    944  N   ILE   117       5.970  19.745  31.602  1.00 11.30           N  
ATOM    945  CA  ILE   117       7.169  19.518  32.386  1.00 11.61           C  
ATOM    946  C   ILE   117       7.092  18.153  33.041  1.00 11.11           C  
ATOM    947  O   ILE   117       6.079  17.797  33.721  1.00 11.60           O  
ATOM    948  CB  ILE   117       7.388  20.612  33.451  1.00 10.94           C  
ATOM    949  CG1 ILE   117       7.501  21.997  32.775  1.00 12.97           C  
ATOM    950  CG2 ILE   117       8.618  20.329  34.312  1.00 12.41           C  
ATOM    951  CD1 ILE   117       7.480  23.183  33.732  1.00 14.48           C  
ATOM    952  N   VAL   118       8.187  17.416  32.859  1.00 10.62           N  
ATOM    953  CA  VAL   118       8.361  16.078  33.426  1.00 10.94           C  
ATOM    954  C   VAL   118       9.561  16.135  34.370  1.00 11.43           C  
ATOM    955  O   VAL   118      10.700  16.224  33.931  1.00 10.90           O  
ATOM    956  CB  VAL   118       8.543  15.003  32.311  1.00 10.92           C  
ATOM    957  CG1 VAL   118       8.762  13.606  32.953  1.00 13.15           C  
ATOM    958  CG2 VAL   118       7.363  15.080  31.324  1.00 11.48           C  
ATOM    959  N   LYS   119       9.287  16.165  35.678  1.00 12.44           N  
ATOM    960  CA  LYS   119      10.324  16.315  36.670  1.00 13.48           C  
ATOM    961  C   LYS   119      10.714  14.948  37.164  1.00 13.19           C  
ATOM    962  O   LYS   119       9.896  14.205  37.702  1.00 14.25           O  
ATOM    963  CB  LYS   119       9.820  17.125  37.855  1.00 13.74           C  
ATOM    964  CG  LYS   119      10.874  17.417  38.891  1.00 15.58           C  
ATOM    965  CD  LYS   119      10.211  18.017  40.107  1.00 18.31           C  
ATOM    966  CE  LYS   119      11.208  18.356  41.190  1.00 20.31           C  
ATOM    967  NZ  LYS   119      10.758  17.806  42.523  1.00 23.66           N  
ATOM    968  N   VAL   120      11.968  14.612  36.979  1.00 12.63           N  
ATOM    969  CA  VAL   120      12.475  13.308  37.419  1.00 12.70           C  
ATOM    970  C   VAL   120      13.243  13.555  38.713  1.00 13.51           C  
ATOM    971  O   VAL   120      14.254  14.272  38.718  1.00 13.69           O  
ATOM    972  CB  VAL   120      13.381  12.724  36.361  1.00 13.24           C  
ATOM    973  CG1 VAL   120      14.002  11.370  36.790  1.00 14.26           C  
ATOM    974  CG2 VAL   120      12.617  12.652  35.001  1.00 12.67           C  
ATOM    975  N   ASP   121      12.754  12.987  39.813  1.00 14.37           N  
ATOM    976  CA  ASP   121      13.442  13.113  41.118  1.00 15.32           C  
ATOM    977  C   ASP   121      14.594  12.118  41.113  1.00 17.32           C  
ATOM    978  O   ASP   121      14.467  10.949  41.457  1.00 17.19           O  
ATOM    979  CB  ASP   121      12.483  12.872  42.272  1.00 16.09           C  
ATOM    980  CG  ASP   121      11.665  14.116  42.666  1.00 18.26           C  
ATOM    981  OD1 ASP   121      11.726  15.184  42.015  1.00 21.24           O  
ATOM    982  OD2 ASP   121      10.964  14.012  43.684  1.00 20.26           O  
ATOM    983  N   TRP   122      15.723  12.608  40.673  1.00 18.89           N  
ATOM    984  CA  TRP   122      16.839  11.748  40.315  1.00 21.45           C  
ATOM    985  C   TRP   122      17.708  11.290  41.481  1.00 23.46           C  
ATOM    986  O   TRP   122      18.703  10.588  41.244  1.00 26.08           O  
ATOM    987  CB  TRP   122      17.674  12.455  39.231  1.00 21.27           C  
ATOM    988  CG  TRP   122      18.435  13.670  39.685  1.00 20.91           C  
ATOM    989  CD1 TRP   122      18.413  14.263  40.926  1.00 21.94           C  
ATOM    990  CD2 TRP   122      19.314  14.461  38.884  1.00 18.43           C  
ATOM    991  NE1 TRP   122      19.242  15.366  40.942  1.00 21.32           N  
ATOM    992  CE2 TRP   122      19.822  15.495  39.708  1.00 19.46           C  
ATOM    993  CE3 TRP   122      19.724  14.398  37.556  1.00 20.93           C  
ATOM    994  CZ2 TRP   122      20.712  16.453  39.238  1.00 20.59           C  
ATOM    995  CZ3 TRP   122      20.624  15.336  37.097  1.00 21.26           C  
ATOM    996  CH2 TRP   122      21.104  16.353  37.928  1.00 21.96           C  
ATOM    997  N   MET   123      17.358  11.725  42.693  1.00 24.68           N  
ATOM    998  CA  MET   123      17.989  11.261  43.955  1.00 26.89           C  
ATOM    999  C   MET   123      19.515  11.269  43.954  1.00 28.23           C  
ATOM   1000  O   MET   123      20.186  10.245  44.212  1.00 29.78           O  
ATOM   1001  CB  MET   123      17.435   9.895  44.310  1.00 27.02           C  
ATOM   1002  CG  MET   123      15.929   9.962  44.589  1.00 27.90           C  
ATOM   1003  SD  MET   123      15.170   8.373  44.882  1.00 26.88           S  
ATOM   1004  CE  MET   123      15.568   7.452  43.417  1.00 29.23           C  
ATOM   1005  N   MET   124      20.047  12.453  43.691  1.00 29.64           N  
ATOM   1006  CA  MET   124      21.477  12.711  43.813  1.00 29.16           C  
ATOM   1007  C   MET   124      21.761  13.504  45.087  1.00 31.10           C  
ATOM   1008  O   MET   124      20.827  13.962  45.749  1.00 33.47           O  
ATOM   1009  CB  MET   124      21.960  13.487  42.589  1.00 29.35           C  
ATOM   1010  CG  MET   124      21.953  12.669  41.304  1.00 26.66           C  
ATOM   1011  SD  MET   124      23.042  11.220  41.329  1.00 22.40           S  
ATOM   1012  CE  MET   124      24.641  12.015  41.477  1.00 25.10           C  
ATOM   1013  N   SER   132      20.403   5.281  47.254  1.00 41.27           N  
ATOM   1014  CA  SER   132      19.763   4.126  46.622  1.00 40.97           C  
ATOM   1015  C   SER   132      18.908   4.544  45.458  1.00 40.68           C  
ATOM   1016  O   SER   132      18.484   5.714  45.357  1.00 41.99           O  
ATOM   1017  CB  SER   132      18.767   3.453  47.568  1.00 41.61           C  
ATOM   1018  OG  SER   132      17.445   3.986  47.312  1.00 37.11           O  
ATOM   1019  N   SER   133      18.618   3.567  44.606  1.00 39.36           N  
ATOM   1020  CA  SER   133      17.362   3.562  43.850  1.00 37.48           C  
ATOM   1021  C   SER   133      17.184   2.210  43.174  1.00 36.63           C  
ATOM   1022  O   SER   133      18.170   1.502  42.898  1.00 35.35           O  
ATOM   1023  CB  SER   133      17.279   4.704  42.830  1.00 38.16           C  
ATOM   1024  OG  SER   133      18.396   4.712  41.964  1.00 39.15           O  
ATOM   1025  N   THR   134      15.922   1.838  42.965  1.00 35.08           N  
ATOM   1026  CA  THR   134      15.572   0.596  42.289  1.00 34.89           C  
ATOM   1027  C   THR   134      16.225   0.613  40.905  1.00 34.89           C  
ATOM   1028  O   THR   134      16.419   1.687  40.304  1.00 33.50           O  
ATOM   1029  CB  THR   134      14.042   0.447  42.098  1.00 34.27           C  
ATOM   1030  OG1 THR   134      13.534   1.650  41.521  1.00 31.71           O  
ATOM   1031  CG2 THR   134      13.321   0.186  43.411  1.00 32.67           C  
ATOM   1032  N   ARG   135      16.542  -0.579  40.405  1.00 35.42           N  
ATOM   1033  CA  ARG   135      17.177  -0.713  39.109  1.00 35.80           C  
ATOM   1034  C   ARG   135      16.184  -0.279  38.039  1.00 35.19           C  
ATOM   1035  O   ARG   135      14.969  -0.516  38.168  1.00 33.59           O  
ATOM   1036  CB  ARG   135      17.624  -2.153  38.860  1.00 36.40           C  
ATOM   1037  CG  ARG   135      18.366  -2.330  37.535  1.00 37.17           C  
ATOM   1038  CD  ARG   135      19.167  -3.644  37.484  1.00 40.02           C  
ATOM   1039  NE  ARG   135      20.228  -3.599  36.466  1.00 42.01           N  
ATOM   1040  CZ  ARG   135      21.482  -3.172  36.657  1.00 44.41           C  
ATOM   1041  NH1 ARG   135      21.901  -2.745  37.850  1.00 45.28           N  
ATOM   1042  NH2 ARG   135      22.338  -3.181  35.634  1.00 45.26           N  
ATOM   1043  N   ILE   136      16.702   0.409  37.020  1.00 34.68           N  
ATOM   1044  CA  ILE   136      15.930   0.736  35.833  1.00 35.32           C  
ATOM   1045  C   ILE   136      16.605   0.082  34.630  1.00 35.33           C  
ATOM   1046  O   ILE   136      17.804   0.282  34.391  1.00 34.30           O  
ATOM   1047  CB  ILE   136      15.859   2.245  35.568  1.00 34.95           C  
ATOM   1048  CG1 ILE   136      15.115   2.975  36.696  1.00 35.36           C  
ATOM   1049  CG2 ILE   136      15.171   2.496  34.238  1.00 33.98           C  
ATOM   1050  CD1 ILE   136      15.539   4.427  36.861  1.00 35.48           C  
ATOM   1051  N   LYS   137      15.836  -0.698  33.880  1.00 36.12           N  
ATOM   1052  CA  LYS   137      16.334  -1.292  32.653  1.00 37.00           C  
ATOM   1053  C   LYS   137      16.368  -0.225  31.550  1.00 37.12           C  
ATOM   1054  O   LYS   137      15.318   0.193  31.043  1.00 35.06           O  
ATOM   1055  CB  LYS   137      15.460  -2.480  32.261  1.00 37.28           C  
ATOM   1056  CG  LYS   137      15.483  -3.600  33.312  1.00 40.05           C  
ATOM   1057  CD  LYS   137      16.604  -4.606  33.077  1.00 42.12           C  
ATOM   1058  CE  LYS   137      16.258  -5.571  31.948  1.00 43.64           C  
ATOM   1059  NZ  LYS   137      17.054  -6.835  32.012  1.00 44.11           N  
ATOM   1060  N   ARG   138      17.580   0.228  31.212  1.00 37.98           N  
ATOM   1061  CA  ARG   138      17.776   1.234  30.156  1.00 39.66           C  
ATOM   1062  C   ARG   138      17.485   0.664  28.790  1.00 40.40           C  
ATOM   1063  O   ARG   138      17.824  -0.479  28.495  1.00 40.43           O  
ATOM   1064  CB  ARG   138      19.217   1.753  30.121  1.00 39.88           C  
ATOM   1065  CG  ARG   138      19.727   2.312  31.416  1.00 42.38           C  
ATOM   1066  CD  ARG   138      18.686   3.135  32.109  1.00 46.21           C  
ATOM   1067  NE  ARG   138      19.280   3.952  33.164  1.00 48.49           N  
ATOM   1068  CZ  ARG   138      18.596   4.742  33.988  1.00 49.41           C  
ATOM   1069  NH1 ARG   138      17.266   4.834  33.920  1.00 50.16           N  
ATOM   1070  NH2 ARG   138      19.251   5.435  34.895  1.00 49.38           N  
ATOM   1071  N   GLY   139      16.872   1.487  27.953  1.00 41.34           N  
ATOM   1072  CA  GLY   139      16.580   1.125  26.576  1.00 41.93           C  
ATOM   1073  C   GLY   139      15.272   1.760  26.164  1.00 42.65           C  
ATOM   1074  O   GLY   139      14.637   2.461  26.945  1.00 43.33           O  
ATOM   1075  N   GLU   140      14.890   1.552  24.914  1.00 43.46           N  
ATOM   1076  CA  GLU   140      13.549   1.871  24.476  1.00 44.10           C  
ATOM   1077  C   GLU   140      12.734   0.613  24.774  1.00 44.44           C  
ATOM   1078  O   GLU   140      13.300  -0.481  24.843  1.00 43.94           O  
ATOM   1079  CB  GLU   140      13.570   2.260  22.998  1.00 44.30           C  
ATOM   1080  CG  GLU   140      14.430   3.505  22.784  1.00 44.82           C  
ATOM   1081  CD  GLU   140      14.630   3.902  21.330  1.00 45.48           C  
ATOM   1082  OE1 GLU   140      15.622   3.424  20.719  1.00 49.01           O  
ATOM   1083  OE2 GLU   140      13.829   4.734  20.828  1.00 45.76           O  
ATOM   1084  N   ILE   141      11.434   0.770  25.008  1.00 45.06           N  
ATOM   1085  CA  ILE   141      10.588  -0.357  25.417  1.00 45.61           C  
ATOM   1086  C   ILE   141       9.930  -1.091  24.219  1.00 46.00           C  
ATOM   1087  O   ILE   141       9.712  -2.303  24.283  1.00 45.98           O  
ATOM   1088  CB  ILE   141       9.490   0.091  26.452  1.00 45.80           C  
ATOM   1089  CG1 ILE   141       8.421   0.955  25.788  1.00 45.56           C  
ATOM   1090  CG2 ILE   141      10.109   0.847  27.647  1.00 45.98           C  
ATOM   1091  CD1 ILE   141       7.340   1.365  26.726  1.00 46.03           C  
ATOM   1092  N   ASP   142       9.635  -0.345  23.149  1.00 46.35           N  
ATOM   1093  CA  ASP   142       8.785  -0.785  21.997  1.00 46.69           C  
ATOM   1094  C   ASP   142       8.351  -2.260  21.929  1.00 47.17           C  
ATOM   1095  O   ASP   142       7.674  -2.685  20.959  1.00 47.33           O  
ATOM   1096  CB  ASP   142       9.434  -0.372  20.656  1.00 46.94           C  
ATOM   1097  CG  ASP   142      10.843  -0.891  20.500  1.00 47.31           C  
ATOM   1098  OD1 ASP   142      11.423  -1.249  21.533  1.00 51.17           O  
ATOM   1099  OD2 ASP   142      11.380  -0.945  19.365  1.00 47.19           O  
END
