
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  227 ( 1822),  selected  227 , name 2nnw_D
# Molecule2: number of CA atoms  174 ( 1400),  selected  174 , name T0508.pdb
# PARAMETERS: 2nnw_D.T0508.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_D      -       -           -
LGA    V     2_D      -       -           -
LGA    E     3_D      -       -           -
LGA    V     4_D      -       -           -
LGA    K     5_D      -       -           -
LGA    K     6_D      -       -           -
LGA    H     7_D      -       -           -
LGA    K     8_D      -       -           -
LGA    F     9_D      -       -           -
LGA    P    10_D      -       -           -
LGA    G    11_D      -       -           -
LGA    V    12_D      -       -           -
LGA    Y    13_D      -       -           -
LGA    V    14_D      -       -           -
LGA    V    15_D      -       -           -
LGA    I    16_D      -       -           -
LGA    D    17_D      -       -           -
LGA    D    18_D      -       -           -
LGA    D    19_D      -       -           -
LGA    G    20_D      -       -           -
LGA    S    21_D      -       -           -
LGA    E    22_D      -       -           -
LGA    K    23_D      -       -           -
LGA    I    24_D      -       -           -
LGA    A    25_D      -       -           -
LGA    T    26_D      -       -           -
LGA    K    27_D      -       -           -
LGA    N    28_D      -       -           -
LGA    L    29_D      -       -           -
LGA    V    30_D      -       -           -
LGA    P    31_D      -       -           -
LGA    G    32_D      -       -           -
LGA    Q    33_D      -       -           -
LGA    R    34_D      -       -           -
LGA    V    35_D      Q      17          3.601
LGA    Y    36_D      L      18           #
LGA    G    37_D      -       -           -
LGA    E    38_D      R      19          3.433
LGA    R    39_D      -       -           -
LGA    V    40_D      -       -           -
LGA    I    41_D      -       -           -
LGA    K    42_D      -       -           -
LGA    W    43_D      -       -           -
LGA    E    44_D      -       -           -
LGA    G    45_D      -       -           -
LGA    E    46_D      -       -           -
LGA    E    47_D      -       -           -
LGA    Y    48_D      -       -           -
LGA    R    49_D      -       -           -
LGA    I    50_D      -       -           -
LGA    W    51_D      -       -           -
LGA    N    52_D      S      20          4.644
LGA    P    53_D      R      21          3.897
LGA    H    54_D      -       -           -
LGA    R    55_D      -       -           -
LGA    S    56_D      A      22          0.900
LGA    K    57_D      A      23           #
LGA    L    58_D      F      24           #
LGA    G    59_D      K      25          2.060
LGA    A    60_D      L      26           #
LGA    A    61_D      E      27           #
LGA    -       -      F      28           -
LGA    I    62_D      L      29          3.071
LGA    V    63_D      L      30           -
LGA    N    64_D      -       -           -
LGA    G    65_D      D      31           #
LGA    L    66_D      R      32          3.136
LGA    K    67_D      -       -           -
LGA    N    68_D      Y      33          1.851
LGA    F    69_D      R      34          1.703
LGA    P    70_D      V      35          2.481
LGA    I    71_D      V      36          1.247
LGA    K    72_D      R      37          1.901
LGA    P    73_D      K      38          1.632
LGA    G    74_D      G      39          1.219
LGA    K    75_D      D      40          1.068
LGA    S    76_D      A      41          0.709
LGA    V    77_D      V      42          0.534
LGA    L    78_D      I      43          0.413
LGA    Y    79_D      E      44          0.204
LGA    L    80_D      I      45          0.683
LGA    G    81_D      G      46          0.762
LGA    I    82_D      S      47          0.752
LGA    A    83_D      S      48          1.199
LGA    S    84_D      P      49          1.018
LGA    G    85_D      G      50          0.662
LGA    T    86_D      G      51          1.290
LGA    T    87_D      W      52          1.796
LGA    A    88_D      T      53          1.285
LGA    S    89_D      Q      54          0.432
LGA    H    90_D      V      55          0.856
LGA    V    91_D      L      56          1.160
LGA    S    92_D      N      57          0.774
LGA    D    93_D      S      58          1.512
LGA    I    94_D      L      59          2.476
LGA    V    95_D      A      60          2.500
LGA    G    96_D      -       -           -
LGA    W    97_D      -       -           -
LGA    E    98_D      -       -           -
LGA    G    99_D      R      61          0.864
LGA    K   100_D      K      62          0.335
LGA    I   101_D      I      63          0.329
LGA    Y   102_D      I      64          0.256
LGA    G   103_D      S      65          0.184
LGA    I   104_D      I      66          0.556
LGA    E   105_D      D      67          0.738
LGA    F   106_D      L      68          1.486
LGA    S   107_D      Q      69          2.395
LGA    P   108_D      -       -           -
LGA    R   109_D      -       -           -
LGA    V   110_D      -       -           -
LGA    L   111_D      E      70          1.851
LGA    R   112_D      M      71          3.525
LGA    E   113_D      -       -           -
LGA    L   114_D      E      72          1.839
LGA    V   115_D      E      73          2.276
LGA    P   116_D      -       -           -
LGA    I   117_D      -       -           -
LGA    V   118_D      I      74          1.673
LGA    E   119_D      -       -           -
LGA    E   120_D      -       -           -
LGA    R   121_D      -       -           -
LGA    R   122_D      A      75          2.162
LGA    N   123_D      G      76          2.938
LGA    I   124_D      V      77          1.079
LGA    I   125_D      R      78          1.082
LGA    P   126_D      F      79          1.251
LGA    I   127_D      I      80          1.025
LGA    L   128_D      R      81          0.812
LGA    G   129_D      C      82          1.389
LGA    D   130_D      D      83          2.000
LGA    A   131_D      I      84          1.998
LGA    T   132_D      F      85          2.622
LGA    K   133_D      K      86          4.440
LGA    -       -      E      87           -
LGA    -       -      T      88           -
LGA    P   134_D      I      89          2.907
LGA    E   135_D      F      90          1.483
LGA    E   136_D      D      91          3.420
LGA    Y   137_D      D      92          0.686
LGA    R   138_D      I      93          3.324
LGA    -       -      D      94           -
LGA    A   139_D      R      95          0.805
LGA    L   140_D      A      96          1.551
LGA    V   141_D      L      97          2.583
LGA    -       -      R      98           -
LGA    -       -      E      99           -
LGA    -       -      E     100           -
LGA    -       -      G     101           -
LGA    T   142_D      I     102          3.703
LGA    K   143_D      E     103          4.007
LGA    -       -      K     104           -
LGA    V   144_D      V     105          0.962
LGA    D   145_D      D     106          0.458
LGA    V   146_D      D     107          0.768
LGA    I   147_D      V     108          0.484
LGA    F   148_D      V     109          0.406
LGA    E   149_D      S     110          0.995
LGA    D   150_D      D     111          1.610
LGA    V   151_D      A     112          1.443
LGA    A   152_D      M     113          1.821
LGA    Q   153_D      A     114          5.791
LGA    -       -      K     115           -
LGA    -       -      V     116           -
LGA    -       -      S     117           -
LGA    -       -      G     118           -
LGA    -       -      I     119           -
LGA    -       -      P     120           -
LGA    -       -      S     121           -
LGA    -       -      R     122           -
LGA    -       -      D     123           -
LGA    -       -      H     124           -
LGA    -       -      A     125           -
LGA    P   154_D      V     126          2.911
LGA    -       -      S     127           -
LGA    -       -      Y     128           -
LGA    T   155_D      Q     129          1.426
LGA    Q   156_D      I     130          2.196
LGA    A   157_D      G     131          2.616
LGA    K   158_D      Q     132          1.993
LGA    I   159_D      R     133          1.402
LGA    L   160_D      V     134          2.275
LGA    I   161_D      M     135          2.047
LGA    D   162_D      E     136          1.388
LGA    N   163_D      I     137          0.783
LGA    A   164_D      A     138          1.331
LGA    K   165_D      V     139          2.246
LGA    A   166_D      R     140          1.909
LGA    Y   167_D      Y     141          1.420
LGA    L   168_D      L     142          1.063
LGA    K   169_D      R     143          0.987
LGA    R   170_D      N     144          1.426
LGA    G   171_D      G     145          1.408
LGA    G   172_D      G     146          0.559
LGA    Y   173_D      N     147          0.609
LGA    G   174_D      V     148          0.724
LGA    M   175_D      L     149          0.668
LGA    I   176_D      L     150          0.616
LGA    A   177_D      K     151          1.172
LGA    V   178_D      Q     152          0.899
LGA    K   179_D      F     153          1.883
LGA    S   180_D      Q     154          3.030
LGA    R   181_D      -       -           -
LGA    S   182_D      -       -           -
LGA    I   183_D      -       -           -
LGA    D   184_D      -       -           -
LGA    V   185_D      -       -           -
LGA    T   186_D      -       -           -
LGA    K   187_D      -       -           -
LGA    E   188_D      -       -           -
LGA    P   189_D      -       -           -
LGA    E   190_D      G     155          5.101
LGA    Q   191_D      D     156          3.195
LGA    V   192_D      M     157          3.529
LGA    F   193_D      T     158          2.461
LGA    K   194_D      N     159          1.491
LGA    E   195_D      D     160          2.341
LGA    V   196_D      F     161          2.257
LGA    E   197_D      I     162          1.092
LGA    R   198_D      A     163          2.026
LGA    E   199_D      I     164          3.160
LGA    L   200_D      W     165          2.054
LGA    S   201_D      R     166          2.200
LGA    E   202_D      K     167          4.087
LGA    Y   203_D      N     168          3.193
LGA    F   204_D      F     169          3.443
LGA    E   205_D      S     170          3.920
LGA    V   206_D      S     171          3.983
LGA    I   207_D      Y     172          1.966
LGA    E   208_D      K     173          0.869
LGA    R   209_D      I     174          0.843
LGA    L   210_D      S     175          0.835
LGA    N   211_D      K     176          1.894
LGA    L   212_D      P     177          3.154
LGA    E   213_D      -       -           -
LGA    P   214_D      -       -           -
LGA    Y   215_D      -       -           -
LGA    E   216_D      -       -           -
LGA    K   217_D      S     184          1.466
LGA    D   218_D      S     185          0.472
LGA    H   219_D      E     186          1.042
LGA    A   220_D      I     187          1.091
LGA    L   221_D      Y     188          0.659
LGA    F   222_D      I     189          1.118
LGA    V   223_D      M     190          1.061
LGA    V   224_D      F     191          0.636
LGA    R   225_D      F     192          2.817
LGA    -       -      G     193           -
LGA    K   226_D      F     194          1.143
LGA    P   227_D      K     195          1.059
LGA    -       -      A     196           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  227  174    5.0    143    2.09    13.29     69.564     6.533

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.321151 * X  +   0.839376 * Y  +   0.438532 * Z  + -140.430527
  Y_new =   0.593117 * X  +   0.539268 * Y  +  -0.597831 * Z  +  15.864710
  Z_new =  -0.738292 * X  +   0.068107 * Y  +  -0.671034 * Z  +  63.277534 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   3.040443   -0.101149  [ DEG:   174.2046     -5.7954 ]
  Theta =   0.830534    2.311059  [ DEG:    47.5861    132.4139 ]
  Phi   =   2.067061   -1.074532  [ DEG:   118.4339    -61.5661 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2nnw_D                                        
REMARK     2: T0508.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2nnw_D.T0508.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  227  174   5.0  143   2.09   13.29  69.564
REMARK  ---------------------------------------------------------- 
MOLECULE 2nnw_D
HEADER    TRANSFERASE                             24-OCT-06   2NNW              
TITLE     ALTERNATIVE CONFORMATIONS OF NOP56/58-FIBRILLARIN COMPLEX             
TITLE    2 AND IMPLICATION FOR INDUCED-FIT ASSENLY OF BOX C/D RNPS              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: NOP5/NOP56 RELATED PROTEIN;                                
COMPND   3 CHAIN: A, C;                                                         
COMPND   4 ENGINEERED: YES;                                                     
COMPND   5 MOL_ID: 2;                                                           
COMPND   6 MOLECULE: FIBRILLARIN-LIKE RRNA/TRNA 2'-O-                           
COMPND   7 METHYLTRANSFERASE;                                                   
COMPND   8 CHAIN: B, D;                                                         
COMPND   9 EC: 2.1.1.-;                                                         
COMPND  10 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS FURIOSUS;                            
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 MOL_ID: 2;                                                           
SOURCE   7 ORGANISM_SCIENTIFIC: PYROCOCCUS FURIOSUS;                            
SOURCE   8 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   9 GENE: FLPA;                                                          
SOURCE  10 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  11 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    BOX C/D, TRANSFERASE                                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.ORUGANTI,Y.ZHANG,R.TERNS,M.P.TERNS,H.LI                             
REVDAT   1   21-AUG-07 2NNW    0                                                
JRNL        AUTH   S.ORUGANTI,Y.ZHANG,H.LI,H.ROBINSON,M.P.TERNS,                
JRNL        AUTH 2 R.M.TERNS,W.YANG,H.LI                                        
JRNL        TITL   ALTERNATIVE CONFORMATIONS OF THE ARCHAEAL                    
JRNL        TITL 2 NOP56/58-FIBRILLARIN COMPLEX IMPLY FLEXIBILITY IN            
JRNL        TITL 3 BOX C/D RNPS.                                                
JRNL        REF    J.MOL.BIOL.                   V. 371  1141 2007              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.70 ANGSTROMS.                                          
DBREF  2NNW A    5   369  UNP    Q8U4M1   Q8U4M1_PYRFU     1    366             
DBREF  2NNW C    5   369  UNP    Q8U4M1   Q8U4M1_PYRFU     1    366             
DBREF  2NNW B    1   227  UNP    Q8U4M2   FLPA_PYRFU       1    227             
DBREF  2NNW D    1   227  UNP    Q8U4M2   FLPA_PYRFU       1    227             
SEQRES   1 A  376  MET HIS HIS HIS HIS HIS HIS VAL MET ILE MET LYS ALA          
SEQRES   2 A  376  PHE ILE SER GLU ASN VAL ARG GLY ILE TYR ALA PHE ASP          
SEQRES   3 A  376  GLU ASN GLY ASN LEU ILE GLU LYS ARG TYR PHE THR ASP          
SEQRES   4 A  376  LYS PRO GLU LYS VAL LEU ASP GLN LEU LEU LYS GLY GLU          
SEQRES   5 A  376  ILE THR LYS ASP LEU GLU GLU LEU LEU ASN SER LEU LYS          
SEQRES   6 A  376  GLU LYS GLY TYR ASP GLU PHE VAL PHE GLU HIS PRO GLU          
SEQRES   7 A  376  LEU SER ARG ARG ALA LYS GLU LEU GLY PHE SER ALA THR          
SEQRES   8 A  376  THR GLU PHE PRO ASN ILE ALA GLY GLU ARG LEU ARG SER          
SEQRES   9 A  376  ASN PRO GLU GLU PHE LEU GLY GLU ASN TRP PHE GLU GLU          
SEQRES  10 A  376  TYR TYR LYS VAL GLY VAL ALA LEU THR ARG MET ARG ILE          
SEQRES  11 A  376  GLN GLU GLN SER GLY ALA ARG ASP LYS MET VAL ILE GLN          
SEQRES  12 A  376  ALA ILE GLU ALA LEU ASP ASP VAL ASP LYS VAL ILE ASN          
SEQRES  13 A  376  LEU LEU VAL ALA ARG LEU ARG GLU TRP TYR SER LEU HIS          
SEQRES  14 A  376  PHE PRO GLU LEU ASP GLU LEU LEU PRO LYS HIS PRO GLN          
SEQRES  15 A  376  TYR VAL ALA PHE VAL LYS THR VAL GLY HIS ARG ASP ASN          
SEQRES  16 A  376  ILE ASN GLU GLU VAL LEU ARG GLU LEU GLY LEU SER GLU          
SEQRES  17 A  376  GLU LYS ILE LYS LYS ILE LEU GLU ALA LYS GLU LYS THR          
SEQRES  18 A  376  MET GLY ALA TRP MET ASP GLN THR ASP ILE GLU VAL VAL          
SEQRES  19 A  376  ARG GLN LEU ALA GLU GLU ILE ASP ARG LEU TYR GLN LEU          
SEQRES  20 A  376  ARG LYS LYS LEU GLU ASP TYR ILE ASP ARG ALA MET ASP          
SEQRES  21 A  376  ASP VAL ALA PRO ASN LEU LYS ALA LEU VAL GLY ALA LYS          
SEQRES  22 A  376  LEU ALA ALA ARG LEU ILE SER LEU ALA GLY GLY LEU ARG          
SEQRES  23 A  376  GLU LEU ALA MET MET PRO SER SER THR ILE GLN VAL LEU          
SEQRES  24 A  376  GLY ALA GLU LYS ALA LEU PHE ARG HIS LEU ARG THR GLY          
SEQRES  25 A  376  ALA LYS PRO PRO LYS HIS GLY VAL ILE TYR GLN TYR PRO          
SEQRES  26 A  376  ALA ILE ASN ARG SER PRO TRP TRP GLN ARG GLY LYS ILE          
SEQRES  27 A  376  ALA ARG ALA LEU ALA GLY LYS LEU ALA ILE ALA ALA ARG          
SEQRES  28 A  376  VAL ASP TYR PHE SER GLY GLU TYR ILE ALA GLU GLU LEU          
SEQRES  29 A  376  LYS LYS GLU LEU GLU ALA ARG ILE ARG GLU ILE LYS              
SEQRES   1 B  234  MET HIS HIS HIS HIS HIS HIS MET VAL GLU VAL LYS LYS          
SEQRES   2 B  234  HIS LYS PHE PRO GLY VAL TYR VAL VAL ILE ASP ASP ASP          
SEQRES   3 B  234  GLY SER GLU LYS ILE ALA THR LYS ASN LEU VAL PRO GLY          
SEQRES   4 B  234  GLN ARG VAL TYR GLY GLU ARG VAL ILE LYS TRP GLU GLY          
SEQRES   5 B  234  GLU GLU TYR ARG ILE TRP ASN PRO HIS ARG SER LYS LEU          
SEQRES   6 B  234  GLY ALA ALA ILE VAL ASN GLY LEU LYS ASN PHE PRO ILE          
SEQRES   7 B  234  LYS PRO GLY LYS SER VAL LEU TYR LEU GLY ILE ALA SER          
SEQRES   8 B  234  GLY THR THR ALA SER HIS VAL SER ASP ILE VAL GLY TRP          
SEQRES   9 B  234  GLU GLY LYS ILE TYR GLY ILE GLU PHE SER PRO ARG VAL          
SEQRES  10 B  234  LEU ARG GLU LEU VAL PRO ILE VAL GLU GLU ARG ARG ASN          
SEQRES  11 B  234  ILE ILE PRO ILE LEU GLY ASP ALA THR LYS PRO GLU GLU          
SEQRES  12 B  234  TYR ARG ALA LEU VAL THR LYS VAL ASP VAL ILE PHE GLU          
SEQRES  13 B  234  ASP VAL ALA GLN PRO THR GLN ALA LYS ILE LEU ILE ASP          
SEQRES  14 B  234  ASN ALA LYS ALA TYR LEU LYS ARG GLY GLY TYR GLY MET          
SEQRES  15 B  234  ILE ALA VAL LYS SER ARG SER ILE ASP VAL THR LYS GLU          
SEQRES  16 B  234  PRO GLU GLN VAL PHE LYS GLU VAL GLU ARG GLU LEU SER          
SEQRES  17 B  234  GLU TYR PHE GLU VAL ILE GLU ARG LEU ASN LEU GLU PRO          
SEQRES  18 B  234  TYR GLU LYS ASP HIS ALA LEU PHE VAL VAL ARG LYS PRO          
SEQRES   1 C  376  MET HIS HIS HIS HIS HIS HIS VAL MET ILE MET LYS ALA          
SEQRES   2 C  376  PHE ILE SER GLU ASN VAL ARG GLY ILE TYR ALA PHE ASP          
SEQRES   3 C  376  GLU ASN GLY ASN LEU ILE GLU LYS ARG TYR PHE THR ASP          
SEQRES   4 C  376  LYS PRO GLU LYS VAL LEU ASP GLN LEU LEU LYS GLY GLU          
SEQRES   5 C  376  ILE THR LYS ASP LEU GLU GLU LEU LEU ASN SER LEU LYS          
SEQRES   6 C  376  GLU LYS GLY TYR ASP GLU PHE VAL PHE GLU HIS PRO GLU          
SEQRES   7 C  376  LEU SER ARG ARG ALA LYS GLU LEU GLY PHE SER ALA THR          
SEQRES   8 C  376  THR GLU PHE PRO ASN ILE ALA GLY GLU ARG LEU ARG SER          
SEQRES   9 C  376  ASN PRO GLU GLU PHE LEU GLY GLU ASN TRP PHE GLU GLU          
SEQRES  10 C  376  TYR TYR LYS VAL GLY VAL ALA LEU THR ARG MET ARG ILE          
SEQRES  11 C  376  GLN GLU GLN SER GLY ALA ARG ASP LYS MET VAL ILE GLN          
SEQRES  12 C  376  ALA ILE GLU ALA LEU ASP ASP VAL ASP LYS VAL ILE ASN          
SEQRES  13 C  376  LEU LEU VAL ALA ARG LEU ARG GLU TRP TYR SER LEU HIS          
SEQRES  14 C  376  PHE PRO GLU LEU ASP GLU LEU LEU PRO LYS HIS PRO GLN          
SEQRES  15 C  376  TYR VAL ALA PHE VAL LYS THR VAL GLY HIS ARG ASP ASN          
SEQRES  16 C  376  ILE ASN GLU GLU VAL LEU ARG GLU LEU GLY LEU SER GLU          
SEQRES  17 C  376  GLU LYS ILE LYS LYS ILE LEU GLU ALA LYS GLU LYS THR          
SEQRES  18 C  376  MET GLY ALA TRP MET ASP GLN THR ASP ILE GLU VAL VAL          
SEQRES  19 C  376  ARG GLN LEU ALA GLU GLU ILE ASP ARG LEU TYR GLN LEU          
SEQRES  20 C  376  ARG LYS LYS LEU GLU ASP TYR ILE ASP ARG ALA MET ASP          
SEQRES  21 C  376  ASP VAL ALA PRO ASN LEU LYS ALA LEU VAL GLY ALA LYS          
SEQRES  22 C  376  LEU ALA ALA ARG LEU ILE SER LEU ALA GLY GLY LEU ARG          
SEQRES  23 C  376  GLU LEU ALA MET MET PRO SER SER THR ILE GLN VAL LEU          
SEQRES  24 C  376  GLY ALA GLU LYS ALA LEU PHE ARG HIS LEU ARG THR GLY          
SEQRES  25 C  376  ALA LYS PRO PRO LYS HIS GLY VAL ILE TYR GLN TYR PRO          
SEQRES  26 C  376  ALA ILE ASN ARG SER PRO TRP TRP GLN ARG GLY LYS ILE          
SEQRES  27 C  376  ALA ARG ALA LEU ALA GLY LYS LEU ALA ILE ALA ALA ARG          
SEQRES  28 C  376  VAL ASP TYR PHE SER GLY GLU TYR ILE ALA GLU GLU LEU          
SEQRES  29 C  376  LYS LYS GLU LEU GLU ALA ARG ILE ARG GLU ILE LYS              
SEQRES   1 D  234  MET HIS HIS HIS HIS HIS HIS MET VAL GLU VAL LYS LYS          
SEQRES   2 D  234  HIS LYS PHE PRO GLY VAL TYR VAL VAL ILE ASP ASP ASP          
SEQRES   3 D  234  GLY SER GLU LYS ILE ALA THR LYS ASN LEU VAL PRO GLY          
SEQRES   4 D  234  GLN ARG VAL TYR GLY GLU ARG VAL ILE LYS TRP GLU GLY          
SEQRES   5 D  234  GLU GLU TYR ARG ILE TRP ASN PRO HIS ARG SER LYS LEU          
SEQRES   6 D  234  GLY ALA ALA ILE VAL ASN GLY LEU LYS ASN PHE PRO ILE          
SEQRES   7 D  234  LYS PRO GLY LYS SER VAL LEU TYR LEU GLY ILE ALA SER          
SEQRES   8 D  234  GLY THR THR ALA SER HIS VAL SER ASP ILE VAL GLY TRP          
SEQRES   9 D  234  GLU GLY LYS ILE TYR GLY ILE GLU PHE SER PRO ARG VAL          
SEQRES  10 D  234  LEU ARG GLU LEU VAL PRO ILE VAL GLU GLU ARG ARG ASN          
SEQRES  11 D  234  ILE ILE PRO ILE LEU GLY ASP ALA THR LYS PRO GLU GLU          
SEQRES  12 D  234  TYR ARG ALA LEU VAL THR LYS VAL ASP VAL ILE PHE GLU          
SEQRES  13 D  234  ASP VAL ALA GLN PRO THR GLN ALA LYS ILE LEU ILE ASP          
SEQRES  14 D  234  ASN ALA LYS ALA TYR LEU LYS ARG GLY GLY TYR GLY MET          
SEQRES  15 D  234  ILE ALA VAL LYS SER ARG SER ILE ASP VAL THR LYS GLU          
SEQRES  16 D  234  PRO GLU GLN VAL PHE LYS GLU VAL GLU ARG GLU LEU SER          
SEQRES  17 D  234  GLU TYR PHE GLU VAL ILE GLU ARG LEU ASN LEU GLU PRO          
SEQRES  18 D  234  TYR GLU LYS ASP HIS ALA LEU PHE VAL VAL ARG LYS PRO          
CRYST1  120.712  120.712  297.741  90.00  90.00 120.00 P 31 1 2     12          
ATOM   7518  N   MET D   1      28.915  36.198  37.125  1.00126.54           N  
ATOM   7519  CA  MET D   1      27.753  35.864  38.003  1.00126.91           C  
ATOM   7520  C   MET D   1      26.922  34.684  37.441  1.00126.13           C  
ATOM   7521  O   MET D   1      25.700  34.795  37.304  1.00126.40           O  
ATOM   7522  CB  MET D   1      26.858  37.112  38.152  1.00128.69           C  
ATOM   7523  CG  MET D   1      25.822  37.063  39.309  1.00130.42           C  
ATOM   7524  SD  MET D   1      24.079  37.588  38.893  1.00131.59           S  
ATOM   7525  CE  MET D   1      24.213  39.421  38.854  1.00130.17           C  
ATOM   7526  N   VAL D   2      27.575  33.565  37.113  1.00124.72           N  
ATOM   7527  CA  VAL D   2      26.890  32.379  36.572  1.00123.01           C  
ATOM   7528  C   VAL D   2      25.926  31.746  37.587  1.00122.04           C  
ATOM   7529  O   VAL D   2      26.110  31.899  38.792  1.00122.62           O  
ATOM   7530  CB  VAL D   2      27.912  31.335  36.123  1.00122.74           C  
ATOM   7531  CG1 VAL D   2      28.601  31.817  34.873  1.00122.21           C  
ATOM   7532  CG2 VAL D   2      28.946  31.109  37.227  1.00122.24           C  
ATOM   7533  N   GLU D   3      24.905  31.031  37.124  1.00119.97           N  
ATOM   7534  CA  GLU D   3      23.948  30.453  38.066  1.00118.06           C  
ATOM   7535  C   GLU D   3      22.950  29.566  37.354  1.00115.20           C  
ATOM   7536  O   GLU D   3      22.409  29.932  36.320  1.00114.96           O  
ATOM   7537  CB  GLU D   3      23.213  31.583  38.788  1.00120.35           C  
ATOM   7538  CG  GLU D   3      22.253  31.167  39.898  1.00123.74           C  
ATOM   7539  CD  GLU D   3      21.745  32.379  40.704  1.00125.86           C  
ATOM   7540  OE1 GLU D   3      20.930  33.174  40.165  1.00126.15           O  
ATOM   7541  OE2 GLU D   3      22.178  32.543  41.875  1.00126.74           O  
ATOM   7542  N   VAL D   4      22.692  28.405  37.928  1.00111.74           N  
ATOM   7543  CA  VAL D   4      21.773  27.462  37.323  1.00108.28           C  
ATOM   7544  C   VAL D   4      20.597  27.113  38.204  1.00105.77           C  
ATOM   7545  O   VAL D   4      20.730  27.000  39.413  1.00105.81           O  
ATOM   7546  CB  VAL D   4      22.490  26.170  36.979  1.00108.17           C  
ATOM   7547  CG1 VAL D   4      21.478  25.077  36.667  1.00107.65           C  
ATOM   7548  CG2 VAL D   4      23.423  26.413  35.822  1.00107.61           C  
ATOM   7549  N   LYS D   5      19.450  26.911  37.586  1.00102.43           N  
ATOM   7550  CA  LYS D   5      18.280  26.574  38.345  1.00 99.56           C  
ATOM   7551  C   LYS D   5      17.431  25.607  37.546  1.00 97.10           C  
ATOM   7552  O   LYS D   5      17.607  25.494  36.342  1.00 97.23           O  
ATOM   7553  CB  LYS D   5      17.508  27.848  38.680  1.00101.02           C  
ATOM   7554  CG  LYS D   5      17.093  28.661  37.468  1.00103.24           C  
ATOM   7555  CD  LYS D   5      16.576  30.060  37.851  1.00104.56           C  
ATOM   7556  CE  LYS D   5      17.683  31.128  37.832  1.00105.70           C  
ATOM   7557  NZ  LYS D   5      18.060  31.618  36.454  1.00105.22           N  
ATOM   7558  N   LYS D   6      16.527  24.899  38.220  1.00 93.89           N  
ATOM   7559  CA  LYS D   6      15.650  23.926  37.574  1.00 90.04           C  
ATOM   7560  C   LYS D   6      14.760  24.594  36.527  1.00 86.80           C  
ATOM   7561  O   LYS D   6      14.761  25.820  36.408  1.00 86.72           O  
ATOM   7562  CB  LYS D   6      14.788  23.207  38.627  1.00 91.75           C  
ATOM   7563  CG  LYS D   6      13.783  22.194  38.055  1.00 93.40           C  
ATOM   7564  CD  LYS D   6      14.478  21.233  37.051  1.00 95.05           C  
ATOM   7565  CE  LYS D   6      13.522  20.216  36.364  1.00 93.91           C  
ATOM   7566  NZ  LYS D   6      14.203  19.410  35.296  1.00 91.20           N  
ATOM   7567  N   HIS D   7      14.007  23.783  35.781  1.00 82.20           N  
ATOM   7568  CA  HIS D   7      13.120  24.253  34.719  1.00 77.85           C  
ATOM   7569  C   HIS D   7      11.846  23.407  34.721  1.00 75.70           C  
ATOM   7570  O   HIS D   7      11.881  22.274  35.170  1.00 74.12           O  
ATOM   7571  CB  HIS D   7      13.856  24.132  33.369  1.00 76.82           C  
ATOM   7572  CG  HIS D   7      13.019  24.504  32.181  1.00 74.54           C  
ATOM   7573  ND1 HIS D   7      12.018  23.690  31.688  1.00 72.26           N  
ATOM   7574  CD2 HIS D   7      12.988  25.631  31.429  1.00 72.47           C  
ATOM   7575  CE1 HIS D   7      11.404  24.305  30.696  1.00 71.28           C  
ATOM   7576  NE2 HIS D   7      11.973  25.486  30.517  1.00 70.84           N  
ATOM   7577  N   LYS D   8      10.727  23.947  34.231  1.00 74.07           N  
ATOM   7578  CA  LYS D   8       9.466  23.188  34.202  1.00 73.82           C  
ATOM   7579  C   LYS D   8       9.676  21.720  33.836  1.00 73.75           C  
ATOM   7580  O   LYS D   8       9.222  20.803  34.512  1.00 73.92           O  
ATOM   7581  CB  LYS D   8       8.499  23.742  33.167  1.00 74.04           C  
ATOM   7582  CG  LYS D   8       8.326  25.213  33.153  1.00 76.13           C  
ATOM   7583  CD  LYS D   8       7.615  25.621  31.864  1.00 78.76           C  
ATOM   7584  CE  LYS D   8       6.271  24.932  31.709  1.00 80.17           C  
ATOM   7585  NZ  LYS D   8       5.893  24.880  30.270  1.00 81.16           N  
ATOM   7586  N   PHE D   9      10.377  21.524  32.727  1.00 74.03           N  
ATOM   7587  CA  PHE D   9      10.661  20.211  32.157  1.00 71.89           C  
ATOM   7588  C   PHE D   9      11.813  19.420  32.778  1.00 70.88           C  
ATOM   7589  O   PHE D   9      12.955  19.906  32.889  1.00 69.46           O  
ATOM   7590  CB  PHE D   9      10.920  20.411  30.676  1.00 72.02           C  
ATOM   7591  CG  PHE D   9       9.770  21.041  29.948  1.00 72.04           C  
ATOM   7592  CD1 PHE D   9       9.996  21.814  28.813  1.00 71.40           C  
ATOM   7593  CD2 PHE D   9       8.456  20.777  30.334  1.00 71.08           C  
ATOM   7594  CE1 PHE D   9       8.927  22.314  28.070  1.00 71.55           C  
ATOM   7595  CE2 PHE D   9       7.384  21.268  29.598  1.00 70.85           C  
ATOM   7596  CZ  PHE D   9       7.613  22.031  28.463  1.00 71.48           C  
ATOM   7597  N   PRO D  10      11.521  18.179  33.198  1.00 70.13           N  
ATOM   7598  CA  PRO D  10      12.535  17.309  33.802  1.00 70.50           C  
ATOM   7599  C   PRO D  10      13.704  17.119  32.808  1.00 71.29           C  
ATOM   7600  O   PRO D  10      13.465  16.788  31.652  1.00 71.14           O  
ATOM   7601  CB  PRO D  10      11.769  16.000  34.009  1.00 68.97           C  
ATOM   7602  CG  PRO D  10      10.358  16.435  34.139  1.00 67.88           C  
ATOM   7603  CD  PRO D  10      10.218  17.495  33.115  1.00 68.28           C  
ATOM   7604  N   GLY D  11      14.942  17.321  33.243  1.00 71.81           N  
ATOM   7605  CA  GLY D  11      16.063  17.131  32.343  1.00 73.23           C  
ATOM   7606  C   GLY D  11      16.597  18.423  31.780  1.00 74.77           C  
ATOM   7607  O   GLY D  11      17.747  18.487  31.295  1.00 75.36           O  
ATOM   7608  N   VAL D  12      15.748  19.450  31.847  1.00 75.61           N  
ATOM   7609  CA  VAL D  12      16.074  20.792  31.383  1.00 75.83           C  
ATOM   7610  C   VAL D  12      16.402  21.666  32.571  1.00 76.60           C  
ATOM   7611  O   VAL D  12      15.867  21.488  33.657  1.00 77.12           O  
ATOM   7612  CB  VAL D  12      14.906  21.424  30.648  1.00 75.29           C  
ATOM   7613  CG1 VAL D  12      15.330  22.743  30.060  1.00 75.04           C  
ATOM   7614  CG2 VAL D  12      14.410  20.485  29.569  1.00 75.63           C  
ATOM   7615  N   TYR D  13      17.280  22.620  32.335  1.00 77.93           N  
ATOM   7616  CA  TYR D  13      17.734  23.531  33.359  1.00 79.13           C  
ATOM   7617  C   TYR D  13      17.833  24.924  32.778  1.00 79.16           C  
ATOM   7618  O   TYR D  13      18.174  25.090  31.608  1.00 79.50           O  
ATOM   7619  CB  TYR D  13      19.121  23.113  33.842  1.00 81.09           C  
ATOM   7620  CG  TYR D  13      19.166  21.781  34.537  1.00 82.98           C  
ATOM   7621  CD1 TYR D  13      19.390  21.701  35.911  1.00 83.79           C  
ATOM   7622  CD2 TYR D  13      18.997  20.600  33.831  1.00 83.20           C  
ATOM   7623  CE1 TYR D  13      19.447  20.470  36.560  1.00 85.52           C  
ATOM   7624  CE2 TYR D  13      19.049  19.373  34.470  1.00 85.21           C  
ATOM   7625  CZ  TYR D  13      19.276  19.308  35.831  1.00 85.50           C  
ATOM   7626  OH  TYR D  13      19.345  18.077  36.442  1.00 86.84           O  
ATOM   7627  N   VAL D  14      17.549  25.930  33.595  1.00 79.08           N  
ATOM   7628  CA  VAL D  14      17.632  27.311  33.144  1.00 78.45           C  
ATOM   7629  C   VAL D  14      18.955  27.841  33.640  1.00 78.17           C  
ATOM   7630  O   VAL D  14      19.399  27.462  34.709  1.00 78.42           O  
ATOM   7631  CB  VAL D  14      16.486  28.128  33.730  1.00 77.83           C  
ATOM   7632  CG1 VAL D  14      16.516  29.522  33.187  1.00 78.08           C  
ATOM   7633  CG2 VAL D  14      15.170  27.453  33.409  1.00 77.80           C  
ATOM   7634  N   VAL D  15      19.605  28.697  32.871  1.00 78.58           N  
ATOM   7635  CA  VAL D  15      20.891  29.218  33.319  1.00 80.15           C  
ATOM   7636  C   VAL D  15      21.136  30.674  32.908  1.00 81.62           C  
ATOM   7637  O   VAL D  15      20.989  31.029  31.744  1.00 82.46           O  
ATOM   7638  CB  VAL D  15      22.069  28.295  32.834  1.00 78.48           C  
ATOM   7639  CG1 VAL D  15      21.523  27.107  32.082  1.00 77.66           C  
ATOM   7640  CG2 VAL D  15      23.062  29.071  31.989  1.00 75.94           C  
ATOM   7641  N   ILE D  16      21.496  31.521  33.874  1.00 82.98           N  
ATOM   7642  CA  ILE D  16      21.755  32.931  33.600  1.00 83.90           C  
ATOM   7643  C   ILE D  16      23.208  33.208  33.874  1.00 84.93           C  
ATOM   7644  O   ILE D  16      23.717  32.853  34.931  1.00 84.90           O  
ATOM   7645  CB  ILE D  16      20.887  33.849  34.493  1.00 84.36           C  
ATOM   7646  CG1 ILE D  16      21.211  33.627  35.979  1.00 83.86           C  
ATOM   7647  CG2 ILE D  16      19.397  33.538  34.268  1.00 84.07           C  
ATOM   7648  CD1 ILE D  16      20.759  32.289  36.538  1.00 84.70           C  
ATOM   7649  N   ASP D  17      23.890  33.828  32.923  1.00 86.74           N  
ATOM   7650  CA  ASP D  17      25.298  34.109  33.139  1.00 89.08           C  
ATOM   7651  C   ASP D  17      25.687  35.570  33.253  1.00 89.76           C  
ATOM   7652  O   ASP D  17      24.892  36.414  33.686  1.00 89.71           O  
ATOM   7653  CB  ASP D  17      26.191  33.387  32.085  1.00 90.69           C  
ATOM   7654  CG  ASP D  17      25.627  33.424  30.646  1.00 91.82           C  
ATOM   7655  OD1 ASP D  17      24.442  33.057  30.441  1.00 92.72           O  
ATOM   7656  OD2 ASP D  17      26.399  33.784  29.712  1.00 91.30           O  
ATOM   7657  N   ASP D  18      26.944  35.831  32.885  1.00 91.25           N  
ATOM   7658  CA  ASP D  18      27.567  37.157  32.916  1.00 92.25           C  
ATOM   7659  C   ASP D  18      26.749  38.251  32.242  1.00 91.67           C  
ATOM   7660  O   ASP D  18      26.388  39.237  32.896  1.00 92.58           O  
ATOM   7661  CB  ASP D  18      28.967  37.105  32.266  1.00 94.39           C  
ATOM   7662  CG  ASP D  18      29.359  35.695  31.811  1.00 96.34           C  
ATOM   7663  OD1 ASP D  18      29.412  35.449  30.573  1.00 97.18           O  
ATOM   7664  OD2 ASP D  18      29.608  34.835  32.701  1.00 96.61           O  
ATOM   7665  N   ASP D  19      26.465  38.082  30.943  1.00 89.45           N  
ATOM   7666  CA  ASP D  19      25.702  39.084  30.192  1.00 86.81           C  
ATOM   7667  C   ASP D  19      24.261  39.283  30.715  1.00 84.36           C  
ATOM   7668  O   ASP D  19      23.470  40.006  30.131  1.00 82.96           O  
ATOM   7669  CB  ASP D  19      25.716  38.736  28.695  1.00 86.72           C  
ATOM   7670  CG  ASP D  19      25.279  37.319  28.418  1.00 87.21           C  
ATOM   7671  OD1 ASP D  19      25.018  36.565  29.383  1.00 86.97           O  
ATOM   7672  OD2 ASP D  19      25.197  36.957  27.225  1.00 87.81           O  
ATOM   7673  N   GLY D  20      23.958  38.642  31.836  1.00 82.71           N  
ATOM   7674  CA  GLY D  20      22.669  38.790  32.451  1.00 81.47           C  
ATOM   7675  C   GLY D  20      21.534  38.127  31.745  1.00 81.28           C  
ATOM   7676  O   GLY D  20      20.393  38.176  32.215  1.00 81.53           O  
ATOM   7677  N   SER D  21      21.818  37.505  30.612  1.00 81.04           N  
ATOM   7678  CA  SER D  21      20.758  36.812  29.864  1.00 81.19           C  
ATOM   7679  C   SER D  21      20.476  35.427  30.438  1.00 80.22           C  
ATOM   7680  O   SER D  21      21.314  34.868  31.135  1.00 80.77           O  
ATOM   7681  CB  SER D  21      21.176  36.691  28.414  1.00 81.62           C  
ATOM   7682  OG  SER D  21      22.544  36.374  28.364  1.00 83.44           O  
ATOM   7683  N   GLU D  22      19.289  34.896  30.168  1.00 79.75           N  
ATOM   7684  CA  GLU D  22      18.927  33.567  30.654  1.00 80.45           C  
ATOM   7685  C   GLU D  22      18.907  32.580  29.469  1.00 78.81           C  
ATOM   7686  O   GLU D  22      18.560  32.948  28.340  1.00 78.76           O  
ATOM   7687  CB  GLU D  22      17.564  33.583  31.376  1.00 83.76           C  
ATOM   7688  CG  GLU D  22      16.326  33.499  30.481  1.00 90.18           C  
ATOM   7689  CD  GLU D  22      15.488  34.788  30.484  1.00 94.15           C  
ATOM   7690  OE1 GLU D  22      15.343  35.415  31.574  1.00 97.06           O  
ATOM   7691  OE2 GLU D  22      14.961  35.171  29.398  1.00 94.98           O  
ATOM   7692  N   LYS D  23      19.288  31.329  29.730  1.00 75.95           N  
ATOM   7693  CA  LYS D  23      19.359  30.314  28.684  1.00 72.43           C  
ATOM   7694  C   LYS D  23      18.893  28.920  29.075  1.00 71.14           C  
ATOM   7695  O   LYS D  23      18.596  28.639  30.229  1.00 71.96           O  
ATOM   7696  CB  LYS D  23      20.797  30.199  28.179  1.00 70.86           C  
ATOM   7697  CG  LYS D  23      21.353  31.458  27.565  1.00 68.42           C  
ATOM   7698  CD  LYS D  23      22.758  31.207  27.102  1.00 67.76           C  
ATOM   7699  CE  LYS D  23      23.297  32.361  26.266  1.00 68.31           C  
ATOM   7700  NZ  LYS D  23      23.564  33.587  27.080  1.00 69.11           N  
ATOM   7701  N   ILE D  24      18.860  28.032  28.094  1.00 70.08           N  
ATOM   7702  CA  ILE D  24      18.449  26.656  28.329  1.00 68.15           C  
ATOM   7703  C   ILE D  24      19.668  25.742  28.425  1.00 66.37           C  
ATOM   7704  O   ILE D  24      20.762  26.058  27.934  1.00 65.48           O  
ATOM   7705  CB  ILE D  24      17.479  26.184  27.189  1.00 68.40           C  
ATOM   7706  CG1 ILE D  24      16.080  26.641  27.522  1.00 69.07           C  
ATOM   7707  CG2 ILE D  24      17.381  24.692  27.107  1.00 70.72           C  
ATOM   7708  CD1 ILE D  24      15.694  26.278  28.934  1.00 68.43           C  
ATOM   7709  N   ALA D  25      19.503  24.602  29.076  1.00 64.53           N  
ATOM   7710  CA  ALA D  25      20.627  23.682  29.156  1.00 62.91           C  
ATOM   7711  C   ALA D  25      20.155  22.325  29.581  1.00 60.70           C  
ATOM   7712  O   ALA D  25      18.988  22.144  29.904  1.00 59.27           O  
ATOM   7713  CB  ALA D  25      21.698  24.211  30.121  1.00 61.72           C  
ATOM   7714  N   THR D  26      21.064  21.363  29.517  1.00 60.46           N  
ATOM   7715  CA  THR D  26      20.775  20.005  29.943  1.00 59.82           C  
ATOM   7716  C   THR D  26      22.015  19.464  30.659  1.00 60.69           C  
ATOM   7717  O   THR D  26      23.136  20.025  30.572  1.00 58.57           O  
ATOM   7718  CB  THR D  26      20.380  19.067  28.764  1.00 59.29           C  
ATOM   7719  OG1 THR D  26      21.281  19.287  27.672  1.00 59.74           O  
ATOM   7720  CG2 THR D  26      18.937  19.293  28.324  1.00 55.34           C  
ATOM   7721  N   LYS D  27      21.774  18.386  31.400  1.00 61.71           N  
ATOM   7722  CA  LYS D  27      22.784  17.701  32.204  1.00 63.39           C  
ATOM   7723  C   LYS D  27      23.542  16.691  31.336  1.00 62.03           C  
ATOM   7724  O   LYS D  27      23.021  15.609  30.994  1.00 60.41           O  
ATOM   7725  CB  LYS D  27      22.072  16.964  33.356  1.00 67.46           C  
ATOM   7726  CG  LYS D  27      20.711  16.244  32.885  1.00 73.02           C  
ATOM   7727  CD  LYS D  27      20.404  14.778  33.488  1.00 76.41           C  
ATOM   7728  CE  LYS D  27      20.926  13.530  32.610  1.00 75.95           C  
ATOM   7729  NZ  LYS D  27      22.262  12.908  32.962  1.00 74.08           N  
ATOM   7730  N   ASN D  28      24.781  17.043  31.011  1.00 60.34           N  
ATOM   7731  CA  ASN D  28      25.642  16.194  30.188  1.00 60.24           C  
ATOM   7732  C   ASN D  28      25.773  14.720  30.634  1.00 60.38           C  
ATOM   7733  O   ASN D  28      26.476  14.413  31.598  1.00 60.34           O  
ATOM   7734  CB  ASN D  28      27.040  16.803  30.081  1.00 58.85           C  
ATOM   7735  CG  ASN D  28      27.899  16.094  29.047  1.00 58.39           C  
ATOM   7736  OD1 ASN D  28      29.071  16.411  28.892  1.00 60.21           O  
ATOM   7737  ND2 ASN D  28      27.316  15.141  28.334  1.00 55.98           N  
ATOM   7738  N   LEU D  29      25.118  13.822  29.897  1.00 59.51           N  
ATOM   7739  CA  LEU D  29      25.147  12.397  30.185  1.00 58.46           C  
ATOM   7740  C   LEU D  29      26.549  11.810  30.052  1.00 56.97           C  
ATOM   7741  O   LEU D  29      26.855  10.764  30.598  1.00 58.70           O  
ATOM   7742  CB  LEU D  29      24.223  11.651  29.232  1.00 59.42           C  
ATOM   7743  CG  LEU D  29      24.062  10.176  29.574  1.00 60.00           C  
ATOM   7744  CD1 LEU D  29      23.538  10.156  30.973  1.00 59.86           C  
ATOM   7745  CD2 LEU D  29      23.081   9.419  28.632  1.00 59.73           C  
ATOM   7746  N   VAL D  30      27.411  12.477  29.332  1.00 54.80           N  
ATOM   7747  CA  VAL D  30      28.725  11.935  29.144  1.00 54.94           C  
ATOM   7748  C   VAL D  30      29.671  13.062  29.374  1.00 56.24           C  
ATOM   7749  O   VAL D  30      30.159  13.714  28.428  1.00 56.37           O  
ATOM   7750  CB  VAL D  30      28.900  11.408  27.713  1.00 54.67           C  
ATOM   7751  CG1 VAL D  30      30.332  10.922  27.508  1.00 52.63           C  
ATOM   7752  CG2 VAL D  30      27.860  10.313  27.446  1.00 52.29           C  
ATOM   7753  N   PRO D  31      29.936  13.326  30.646  1.00 57.50           N  
ATOM   7754  CA  PRO D  31      30.836  14.396  31.055  1.00 58.02           C  
ATOM   7755  C   PRO D  31      32.093  14.423  30.206  1.00 58.40           C  
ATOM   7756  O   PRO D  31      32.657  13.374  29.901  1.00 58.59           O  
ATOM   7757  CB  PRO D  31      31.106  14.057  32.505  1.00 58.32           C  
ATOM   7758  CG  PRO D  31      29.795  13.447  32.939  1.00 57.85           C  
ATOM   7759  CD  PRO D  31      29.467  12.543  31.803  1.00 57.87           C  
ATOM   7760  N   GLY D  32      32.509  15.628  29.826  1.00 58.72           N  
ATOM   7761  CA  GLY D  32      33.687  15.787  29.003  1.00 60.71           C  
ATOM   7762  C   GLY D  32      33.430  15.652  27.499  1.00 63.38           C  
ATOM   7763  O   GLY D  32      34.324  15.927  26.682  1.00 63.43           O  
ATOM   7764  N   GLN D  33      32.217  15.236  27.117  1.00 63.96           N  
ATOM   7765  CA  GLN D  33      31.904  15.064  25.708  1.00 63.00           C  
ATOM   7766  C   GLN D  33      31.178  16.236  25.093  1.00 63.73           C  
ATOM   7767  O   GLN D  33      30.149  16.682  25.600  1.00 62.67           O  
ATOM   7768  CB  GLN D  33      31.078  13.799  25.483  1.00 62.26           C  
ATOM   7769  CG  GLN D  33      30.829  13.484  23.991  1.00 60.91           C  
ATOM   7770  CD  GLN D  33      29.681  12.490  23.766  1.00 60.62           C  
ATOM   7771  OE1 GLN D  33      29.906  11.330  23.404  1.00 59.59           O  
ATOM   7772  NE2 GLN D  33      28.447  12.945  23.981  1.00 60.30           N  
ATOM   7773  N   ARG D  34      31.726  16.730  23.981  1.00 64.90           N  
ATOM   7774  CA  ARG D  34      31.097  17.825  23.250  1.00 66.10           C  
ATOM   7775  C   ARG D  34      30.628  17.327  21.860  1.00 63.87           C  
ATOM   7776  O   ARG D  34      31.384  16.702  21.125  1.00 64.50           O  
ATOM   7777  CB  ARG D  34      32.056  19.021  23.136  1.00 68.83           C  
ATOM   7778  CG  ARG D  34      32.312  19.726  24.484  1.00 74.66           C  
ATOM   7779  CD  ARG D  34      32.360  21.258  24.365  1.00 79.23           C  
ATOM   7780  NE  ARG D  34      33.375  21.727  23.408  1.00 83.74           N  
ATOM   7781  CZ  ARG D  34      33.498  22.992  22.976  1.00 85.75           C  
ATOM   7782  NH1 ARG D  34      32.664  23.945  23.417  1.00 85.66           N  
ATOM   7783  NH2 ARG D  34      34.464  23.305  22.098  1.00 85.65           N  
ATOM   7784  N   VAL D  35      29.363  17.581  21.536  1.00 61.11           N  
ATOM   7785  CA  VAL D  35      28.788  17.152  20.263  1.00 58.94           C  
ATOM   7786  C   VAL D  35      28.868  18.213  19.170  1.00 57.89           C  
ATOM   7787  O   VAL D  35      29.338  17.941  18.057  1.00 57.96           O  
ATOM   7788  CB  VAL D  35      27.298  16.755  20.407  1.00 57.88           C  
ATOM   7789  CG1 VAL D  35      26.697  16.406  19.061  1.00 56.36           C  
ATOM   7790  CG2 VAL D  35      27.172  15.600  21.353  1.00 58.52           C  
ATOM   7791  N   TYR D  36      28.424  19.425  19.462  1.00 56.23           N  
ATOM   7792  CA  TYR D  36      28.455  20.406  18.417  1.00 55.97           C  
ATOM   7793  C   TYR D  36      29.138  21.716  18.701  1.00 57.03           C  
ATOM   7794  O   TYR D  36      28.775  22.750  18.114  1.00 57.48           O  
ATOM   7795  CB  TYR D  36      27.047  20.666  17.937  1.00 53.31           C  
ATOM   7796  CG  TYR D  36      26.104  21.183  18.965  1.00 51.76           C  
ATOM   7797  CD1 TYR D  36      25.450  20.306  19.832  1.00 53.37           C  
ATOM   7798  CD2 TYR D  36      25.813  22.543  19.035  1.00 50.37           C  
ATOM   7799  CE1 TYR D  36      24.509  20.772  20.750  1.00 53.22           C  
ATOM   7800  CE2 TYR D  36      24.883  23.036  19.942  1.00 51.36           C  
ATOM   7801  CZ  TYR D  36      24.224  22.153  20.804  1.00 52.71           C  
ATOM   7802  OH  TYR D  36      23.278  22.630  21.700  1.00 50.77           O  
ATOM   7803  N   GLY D  37      30.151  21.675  19.561  1.00 57.61           N  
ATOM   7804  CA  GLY D  37      30.850  22.897  19.928  1.00 58.24           C  
ATOM   7805  C   GLY D  37      30.030  23.755  20.893  1.00 59.11           C  
ATOM   7806  O   GLY D  37      30.261  24.954  21.005  1.00 57.50           O  
ATOM   7807  N   GLU D  38      29.079  23.125  21.587  1.00 61.34           N  
ATOM   7808  CA  GLU D  38      28.220  23.805  22.545  1.00 64.65           C  
ATOM   7809  C   GLU D  38      29.013  24.424  23.672  1.00 68.17           C  
ATOM   7810  O   GLU D  38      30.215  24.214  23.809  1.00 68.20           O  
ATOM   7811  CB  GLU D  38      27.200  22.864  23.192  1.00 62.87           C  
ATOM   7812  CG  GLU D  38      26.973  21.538  22.500  1.00 64.15           C  
ATOM   7813  CD  GLU D  38      27.965  20.468  22.894  1.00 65.51           C  
ATOM   7814  OE1 GLU D  38      29.063  20.432  22.302  1.00 65.85           O  
ATOM   7815  OE2 GLU D  38      27.660  19.658  23.806  1.00 65.68           O  
ATOM   7816  N   ARG D  39      28.309  25.193  24.491  1.00 72.71           N  
ATOM   7817  CA  ARG D  39      28.895  25.836  25.659  1.00 75.60           C  
ATOM   7818  C   ARG D  39      28.565  24.938  26.851  1.00 76.59           C  
ATOM   7819  O   ARG D  39      27.405  24.578  27.086  1.00 75.41           O  
ATOM   7820  CB  ARG D  39      28.274  27.224  25.842  1.00 78.03           C  
ATOM   7821  CG  ARG D  39      28.581  27.937  27.169  1.00 80.62           C  
ATOM   7822  CD  ARG D  39      29.674  29.006  27.029  1.00 82.83           C  
ATOM   7823  NE  ARG D  39      29.176  30.350  27.290  1.00 84.01           N  
ATOM   7824  CZ  ARG D  39      28.542  30.710  28.400  1.00 84.50           C  
ATOM   7825  NH1 ARG D  39      28.326  29.817  29.356  1.00 86.09           N  
ATOM   7826  NH2 ARG D  39      28.130  31.969  28.557  1.00 85.84           N  
ATOM   7827  N   VAL D  40      29.594  24.559  27.592  1.00 78.91           N  
ATOM   7828  CA  VAL D  40      29.383  23.717  28.754  1.00 81.52           C  
ATOM   7829  C   VAL D  40      29.887  24.465  29.985  1.00 82.49           C  
ATOM   7830  O   VAL D  40      30.998  25.019  29.992  1.00 82.06           O  
ATOM   7831  CB  VAL D  40      30.104  22.351  28.621  1.00 82.12           C  
ATOM   7832  CG1 VAL D  40      29.674  21.439  29.754  1.00 82.09           C  
ATOM   7833  CG2 VAL D  40      29.770  21.700  27.270  1.00 83.35           C  
ATOM   7834  N   ILE D  41      29.027  24.490  31.005  1.00 83.71           N  
ATOM   7835  CA  ILE D  41      29.274  25.159  32.283  1.00 84.35           C  
ATOM   7836  C   ILE D  41      29.138  24.149  33.424  1.00 85.65           C  
ATOM   7837  O   ILE D  41      28.168  23.388  33.472  1.00 85.47           O  
ATOM   7838  CB  ILE D  41      28.232  26.281  32.532  1.00 82.87           C  
ATOM   7839  CG1 ILE D  41      26.829  25.696  32.336  1.00 82.63           C  
ATOM   7840  CG2 ILE D  41      28.468  27.472  31.592  1.00 81.14           C  
ATOM   7841  CD1 ILE D  41      25.730  26.382  33.102  1.00 81.20           C  
ATOM   7842  N   LYS D  42      30.121  24.143  34.325  1.00 87.76           N  
ATOM   7843  CA  LYS D  42      30.123  23.263  35.501  1.00 89.66           C  
ATOM   7844  C   LYS D  42      29.421  24.010  36.647  1.00 90.68           C  
ATOM   7845  O   LYS D  42      29.789  25.145  36.978  1.00 89.68           O  
ATOM   7846  CB  LYS D  42      31.559  22.883  35.907  1.00 89.37           C  
ATOM   7847  CG  LYS D  42      32.531  24.028  35.815  1.00 90.04           C  
ATOM   7848  CD  LYS D  42      32.908  24.294  34.352  1.00 92.06           C  
ATOM   7849  CE  LYS D  42      33.069  25.806  33.993  1.00 92.11           C  
ATOM   7850  NZ  LYS D  42      31.786  26.562  33.819  1.00 90.36           N  
ATOM   7851  N   TRP D  43      28.391  23.370  37.214  1.00 92.76           N  
ATOM   7852  CA  TRP D  43      27.596  23.936  38.305  1.00 94.89           C  
ATOM   7853  C   TRP D  43      28.306  23.684  39.604  1.00 96.62           C  
ATOM   7854  O   TRP D  43      28.806  24.601  40.262  1.00 98.04           O  
ATOM   7855  CB  TRP D  43      26.223  23.268  38.425  1.00 95.25           C  
ATOM   7856  CG  TRP D  43      25.229  24.032  39.318  1.00 96.68           C  
ATOM   7857  CD1 TRP D  43      24.112  23.518  39.947  1.00 96.73           C  
ATOM   7858  CD2 TRP D  43      25.188  25.459  39.548  1.00 96.86           C  
ATOM   7859  NE1 TRP D  43      23.382  24.535  40.533  1.00 96.64           N  
ATOM   7860  CE2 TRP D  43      24.016  25.731  40.301  1.00 96.76           C  
ATOM   7861  CE3 TRP D  43      26.021  26.530  39.180  1.00 96.62           C  
ATOM   7862  CZ2 TRP D  43      23.658  27.033  40.688  1.00 96.80           C  
ATOM   7863  CZ3 TRP D  43      25.666  27.826  39.564  1.00 96.75           C  
ATOM   7864  CH2 TRP D  43      24.494  28.064  40.310  1.00 97.08           C  
ATOM   7865  N   GLU D  44      28.345  22.419  39.974  1.00 96.48           N  
ATOM   7866  CA  GLU D  44      28.981  22.052  41.205  1.00 96.38           C  
ATOM   7867  C   GLU D  44      29.392  20.595  41.101  1.00 95.61           C  
ATOM   7868  O   GLU D  44      28.740  19.706  41.649  1.00 96.39           O  
ATOM   7869  CB  GLU D  44      28.012  22.325  42.377  1.00 97.57           C  
ATOM   7870  CG  GLU D  44      26.532  22.172  42.049  1.00 99.39           C  
ATOM   7871  CD  GLU D  44      26.236  20.850  41.332  1.00101.95           C  
ATOM   7872  OE1 GLU D  44      26.158  20.849  40.059  1.00102.65           O  
ATOM   7873  OE2 GLU D  44      26.092  19.815  42.040  1.00101.74           O  
ATOM   7874  N   GLY D  45      30.476  20.356  40.368  1.00 94.41           N  
ATOM   7875  CA  GLY D  45      30.963  18.997  40.178  1.00 93.07           C  
ATOM   7876  C   GLY D  45      30.221  18.305  39.040  1.00 91.75           C  
ATOM   7877  O   GLY D  45      30.513  17.153  38.683  1.00 92.03           O  
ATOM   7878  N   GLU D  46      29.247  19.024  38.486  1.00 89.60           N  
ATOM   7879  CA  GLU D  46      28.447  18.534  37.384  1.00 86.55           C  
ATOM   7880  C   GLU D  46      28.468  19.492  36.200  1.00 83.31           C  
ATOM   7881  O   GLU D  46      28.542  20.710  36.367  1.00 82.66           O  
ATOM   7882  CB  GLU D  46      27.023  18.273  37.833  1.00 87.43           C  
ATOM   7883  CG  GLU D  46      26.860  16.892  38.406  1.00 88.21           C  
ATOM   7884  CD  GLU D  46      25.508  16.719  39.023  1.00 90.00           C  
ATOM   7885  OE1 GLU D  46      25.242  17.429  40.023  1.00 91.96           O  
ATOM   7886  OE2 GLU D  46      24.706  15.892  38.518  1.00 88.97           O  
ATOM   7887  N   GLU D  47      28.419  18.894  35.009  1.00 79.93           N  
ATOM   7888  CA  GLU D  47      28.468  19.577  33.731  1.00 75.46           C  
ATOM   7889  C   GLU D  47      27.090  19.779  33.114  1.00 73.74           C  
ATOM   7890  O   GLU D  47      26.223  18.886  33.150  1.00 72.45           O  
ATOM   7891  CB  GLU D  47      29.334  18.770  32.791  1.00 73.67           C  
ATOM   7892  CG  GLU D  47      30.508  19.505  32.258  1.00 74.15           C  
ATOM   7893  CD  GLU D  47      31.372  18.619  31.360  1.00 74.98           C  
ATOM   7894  OE1 GLU D  47      30.804  17.687  30.731  1.00 75.16           O  
ATOM   7895  OE2 GLU D  47      32.607  18.860  31.275  1.00 74.59           O  
ATOM   7896  N   TYR D  48      26.891  20.980  32.570  1.00 71.91           N  
ATOM   7897  CA  TYR D  48      25.643  21.359  31.903  1.00 70.23           C  
ATOM   7898  C   TYR D  48      25.983  21.882  30.511  1.00 68.03           C  
ATOM   7899  O   TYR D  48      26.942  22.651  30.323  1.00 67.76           O  
ATOM   7900  CB  TYR D  48      24.888  22.435  32.701  1.00 72.23           C  
ATOM   7901  CG  TYR D  48      24.318  21.941  34.008  1.00 73.50           C  
ATOM   7902  CD1 TYR D  48      25.130  21.861  35.143  1.00 73.17           C  
ATOM   7903  CD2 TYR D  48      22.998  21.446  34.084  1.00 73.11           C  
ATOM   7904  CE1 TYR D  48      24.667  21.292  36.328  1.00 74.69           C  
ATOM   7905  CE2 TYR D  48      22.514  20.868  35.273  1.00 75.03           C  
ATOM   7906  CZ  TYR D  48      23.370  20.789  36.401  1.00 75.22           C  
ATOM   7907  OH  TYR D  48      22.982  20.188  37.586  1.00 74.59           O  
ATOM   7908  N   ARG D  49      25.208  21.452  29.523  1.00 64.71           N  
ATOM   7909  CA  ARG D  49      25.462  21.892  28.151  1.00 60.38           C  
ATOM   7910  C   ARG D  49      24.345  22.846  27.769  1.00 58.38           C  
ATOM   7911  O   ARG D  49      23.161  22.523  27.890  1.00 56.89           O  
ATOM   7912  CB  ARG D  49      25.499  20.684  27.195  1.00 59.44           C  
ATOM   7913  CG  ARG D  49      26.369  19.499  27.641  1.00 56.31           C  
ATOM   7914  CD  ARG D  49      26.444  18.390  26.561  1.00 53.36           C  
ATOM   7915  NE  ARG D  49      25.147  17.931  26.072  1.00 50.21           N  
ATOM   7916  CZ  ARG D  49      24.761  17.982  24.781  1.00 49.46           C  
ATOM   7917  NH1 ARG D  49      23.544  17.530  24.423  1.00 44.17           N  
ATOM   7918  NH2 ARG D  49      25.582  18.492  23.854  1.00 42.69           N  
ATOM   7919  N   ILE D  50      24.738  24.036  27.339  1.00 57.05           N  
ATOM   7920  CA  ILE D  50      23.782  25.060  26.943  1.00 57.28           C  
ATOM   7921  C   ILE D  50      23.121  24.662  25.638  1.00 56.32           C  
ATOM   7922  O   ILE D  50      23.757  24.572  24.563  1.00 55.91           O  
ATOM   7923  CB  ILE D  50      24.458  26.438  26.726  1.00 59.71           C  
ATOM   7924  CG1 ILE D  50      25.119  26.919  28.023  1.00 61.30           C  
ATOM   7925  CG2 ILE D  50      23.423  27.449  26.290  1.00 59.66           C  
ATOM   7926  CD1 ILE D  50      24.164  26.889  29.210  1.00 63.70           C  
ATOM   7927  N   TRP D  51      21.829  24.440  25.737  1.00 53.32           N  
ATOM   7928  CA  TRP D  51      21.053  24.033  24.601  1.00 51.01           C  
ATOM   7929  C   TRP D  51      20.726  25.234  23.687  1.00 50.62           C  
ATOM   7930  O   TRP D  51      19.702  25.892  23.863  1.00 51.07           O  
ATOM   7931  CB  TRP D  51      19.786  23.361  25.130  1.00 48.64           C  
ATOM   7932  CG  TRP D  51      19.017  22.625  24.135  1.00 47.54           C  
ATOM   7933  CD1 TRP D  51      19.162  22.673  22.772  1.00 47.39           C  
ATOM   7934  CD2 TRP D  51      17.915  21.755  24.392  1.00 47.44           C  
ATOM   7935  NE1 TRP D  51      18.205  21.885  22.175  1.00 47.37           N  
ATOM   7936  CE2 TRP D  51      17.426  21.312  23.140  1.00 46.17           C  
ATOM   7937  CE3 TRP D  51      17.284  21.313  25.558  1.00 46.53           C  
ATOM   7938  CZ2 TRP D  51      16.345  20.441  23.019  1.00 46.32           C  
ATOM   7939  CZ3 TRP D  51      16.187  20.436  25.440  1.00 46.39           C  
ATOM   7940  CH2 TRP D  51      15.731  20.015  24.176  1.00 45.58           C  
ATOM   7941  N   ASN D  52      21.588  25.503  22.707  1.00 49.93           N  
ATOM   7942  CA  ASN D  52      21.423  26.615  21.749  1.00 49.70           C  
ATOM   7943  C   ASN D  52      20.184  26.561  20.837  1.00 49.80           C  
ATOM   7944  O   ASN D  52      20.077  25.715  19.963  1.00 51.07           O  
ATOM   7945  CB  ASN D  52      22.631  26.666  20.856  1.00 50.28           C  
ATOM   7946  CG  ASN D  52      22.659  27.903  20.023  1.00 52.81           C  
ATOM   7947  OD1 ASN D  52      21.590  28.442  19.645  1.00 53.15           O  
ATOM   7948  ND2 ASN D  52      23.875  28.385  19.716  1.00 51.24           N  
ATOM   7949  N   PRO D  53      19.249  27.495  20.994  1.00 49.54           N  
ATOM   7950  CA  PRO D  53      18.051  27.443  20.119  1.00 48.71           C  
ATOM   7951  C   PRO D  53      18.300  27.871  18.646  1.00 46.89           C  
ATOM   7952  O   PRO D  53      17.435  27.734  17.809  1.00 45.29           O  
ATOM   7953  CB  PRO D  53      17.047  28.356  20.842  1.00 48.29           C  
ATOM   7954  CG  PRO D  53      17.957  29.449  21.378  1.00 49.04           C  
ATOM   7955  CD  PRO D  53      19.269  28.720  21.821  1.00 49.29           C  
ATOM   7956  N   HIS D  54      19.484  28.378  18.358  1.00 46.59           N  
ATOM   7957  CA  HIS D  54      19.814  28.747  17.013  1.00 49.46           C  
ATOM   7958  C   HIS D  54      20.273  27.526  16.228  1.00 50.97           C  
ATOM   7959  O   HIS D  54      20.366  27.567  15.004  1.00 50.77           O  
ATOM   7960  CB  HIS D  54      20.936  29.767  16.987  1.00 51.37           C  
ATOM   7961  CG  HIS D  54      20.531  31.110  17.492  1.00 54.71           C  
ATOM   7962  ND1 HIS D  54      19.399  31.759  17.053  1.00 55.40           N  
ATOM   7963  CD2 HIS D  54      21.141  31.962  18.354  1.00 56.23           C  
ATOM   7964  CE1 HIS D  54      19.332  32.948  17.611  1.00 56.75           C  
ATOM   7965  NE2 HIS D  54      20.375  33.101  18.403  1.00 56.75           N  
ATOM   7966  N   ARG D  55      20.592  26.451  16.946  1.00 52.90           N  
ATOM   7967  CA  ARG D  55      21.064  25.210  16.350  1.00 53.44           C  
ATOM   7968  C   ARG D  55      20.065  24.089  16.543  1.00 52.90           C  
ATOM   7969  O   ARG D  55      20.137  23.102  15.856  1.00 55.12           O  
ATOM   7970  CB  ARG D  55      22.373  24.745  16.982  1.00 55.66           C  
ATOM   7971  CG  ARG D  55      23.473  25.737  17.015  1.00 60.34           C  
ATOM   7972  CD  ARG D  55      24.024  26.011  15.663  1.00 66.06           C  
ATOM   7973  NE  ARG D  55      25.051  27.054  15.722  1.00 75.07           N  
ATOM   7974  CZ  ARG D  55      26.250  26.917  16.309  1.00 79.22           C  
ATOM   7975  NH1 ARG D  55      27.126  27.941  16.316  1.00 79.39           N  
ATOM   7976  NH2 ARG D  55      26.572  25.751  16.888  1.00 81.54           N  
ATOM   7977  N   SER D  56      19.146  24.204  17.481  1.00 51.09           N  
ATOM   7978  CA  SER D  56      18.216  23.124  17.659  1.00 50.35           C  
ATOM   7979  C   SER D  56      16.791  23.643  17.603  1.00 50.61           C  
ATOM   7980  O   SER D  56      16.430  24.552  18.353  1.00 51.36           O  
ATOM   7981  CB  SER D  56      18.476  22.425  18.997  1.00 49.80           C  
ATOM   7982  OG  SER D  56      17.427  21.493  19.287  1.00 49.72           O  
ATOM   7983  N   LYS D  57      15.995  23.073  16.704  1.00 50.29           N  
ATOM   7984  CA  LYS D  57      14.608  23.452  16.555  1.00 49.72           C  
ATOM   7985  C   LYS D  57      13.887  23.131  17.860  1.00 50.38           C  
ATOM   7986  O   LYS D  57      13.137  23.964  18.338  1.00 51.07           O  
ATOM   7987  CB  LYS D  57      13.936  22.690  15.404  1.00 49.37           C  
ATOM   7988  CG  LYS D  57      13.442  23.586  14.286  1.00 48.65           C  
ATOM   7989  CD  LYS D  57      14.382  23.607  13.128  1.00 49.18           C  
ATOM   7990  CE  LYS D  57      13.900  22.630  12.066  1.00 52.24           C  
ATOM   7991  NZ  LYS D  57      15.050  22.038  11.278  1.00 56.03           N  
ATOM   7992  N   LEU D  58      14.103  21.948  18.446  1.00 51.69           N  
ATOM   7993  CA  LEU D  58      13.430  21.597  19.703  1.00 51.69           C  
ATOM   7994  C   LEU D  58      13.761  22.666  20.725  1.00 52.52           C  
ATOM   7995  O   LEU D  58      12.865  23.215  21.360  1.00 52.18           O  
ATOM   7996  CB  LEU D  58      13.893  20.257  20.238  1.00 52.70           C  
ATOM   7997  CG  LEU D  58      12.845  19.362  20.948  1.00 53.03           C  
ATOM   7998  CD1 LEU D  58      13.611  18.385  21.830  1.00 51.69           C  
ATOM   7999  CD2 LEU D  58      11.865  20.175  21.783  1.00 51.17           C  
ATOM   8000  N   GLY D  59      15.051  22.973  20.864  1.00 53.85           N  
ATOM   8001  CA  GLY D  59      15.490  24.028  21.772  1.00 54.84           C  
ATOM   8002  C   GLY D  59      14.762  25.356  21.514  1.00 55.73           C  
ATOM   8003  O   GLY D  59      14.194  25.950  22.434  1.00 55.78           O  
ATOM   8004  N   ALA D  60      14.770  25.849  20.280  1.00 55.94           N  
ATOM   8005  CA  ALA D  60      14.047  27.083  20.006  1.00 55.87           C  
ATOM   8006  C   ALA D  60      12.601  26.960  20.536  1.00 56.28           C  
ATOM   8007  O   ALA D  60      12.125  27.848  21.261  1.00 55.85           O  
ATOM   8008  CB  ALA D  60      14.039  27.375  18.535  1.00 54.92           C  
ATOM   8009  N   ALA D  61      11.919  25.856  20.209  1.00 56.02           N  
ATOM   8010  CA  ALA D  61      10.534  25.612  20.667  1.00 56.81           C  
ATOM   8011  C   ALA D  61      10.374  25.791  22.186  1.00 58.40           C  
ATOM   8012  O   ALA D  61       9.472  26.497  22.664  1.00 58.64           O  
ATOM   8013  CB  ALA D  61      10.085  24.211  20.283  1.00 53.37           C  
ATOM   8014  N   ILE D  62      11.246  25.130  22.942  1.00 59.16           N  
ATOM   8015  CA  ILE D  62      11.234  25.224  24.390  1.00 59.69           C  
ATOM   8016  C   ILE D  62      11.436  26.691  24.762  1.00 60.30           C  
ATOM   8017  O   ILE D  62      10.584  27.261  25.446  1.00 62.42           O  
ATOM   8018  CB  ILE D  62      12.338  24.317  24.999  1.00 59.54           C  
ATOM   8019  CG1 ILE D  62      11.797  22.901  25.111  1.00 59.28           C  
ATOM   8020  CG2 ILE D  62      12.807  24.838  26.360  1.00 59.37           C  
ATOM   8021  CD1 ILE D  62      12.877  21.868  25.352  1.00 59.01           C  
ATOM   8022  N   VAL D  63      12.528  27.303  24.300  1.00 58.52           N  
ATOM   8023  CA  VAL D  63      12.765  28.718  24.570  1.00 58.31           C  
ATOM   8024  C   VAL D  63      11.553  29.586  24.190  1.00 59.02           C  
ATOM   8025  O   VAL D  63      11.326  30.619  24.792  1.00 59.04           O  
ATOM   8026  CB  VAL D  63      13.992  29.272  23.796  1.00 57.99           C  
ATOM   8027  CG1 VAL D  63      14.051  30.778  23.887  1.00 58.38           C  
ATOM   8028  CG2 VAL D  63      15.250  28.715  24.359  1.00 57.76           C  
ATOM   8029  N   ASN D  64      10.775  29.193  23.191  1.00 60.50           N  
ATOM   8030  CA  ASN D  64       9.621  29.993  22.836  1.00 62.32           C  
ATOM   8031  C   ASN D  64       8.452  29.627  23.675  1.00 64.53           C  
ATOM   8032  O   ASN D  64       7.318  29.892  23.289  1.00 66.35           O  
ATOM   8033  CB  ASN D  64       9.221  29.801  21.388  1.00 62.60           C  
ATOM   8034  CG  ASN D  64       9.957  30.734  20.468  1.00 62.78           C  
ATOM   8035  OD1 ASN D  64       9.855  30.605  19.251  1.00 63.33           O  
ATOM   8036  ND2 ASN D  64      10.707  31.694  21.043  1.00 63.63           N  
ATOM   8037  N   GLY D  65       8.713  29.010  24.818  1.00 65.62           N  
ATOM   8038  CA  GLY D  65       7.630  28.614  25.690  1.00 67.78           C  
ATOM   8039  C   GLY D  65       6.785  27.463  25.151  1.00 71.00           C  
ATOM   8040  O   GLY D  65       5.578  27.605  24.950  1.00 71.50           O  
ATOM   8041  N   LEU D  66       7.401  26.312  24.894  1.00 73.32           N  
ATOM   8042  CA  LEU D  66       6.632  25.161  24.437  1.00 74.77           C  
ATOM   8043  C   LEU D  66       5.860  24.681  25.685  1.00 76.68           C  
ATOM   8044  O   LEU D  66       6.389  24.778  26.806  1.00 76.16           O  
ATOM   8045  CB  LEU D  66       7.594  24.075  23.949  1.00 73.66           C  
ATOM   8046  CG  LEU D  66       7.029  22.644  23.956  1.00 72.38           C  
ATOM   8047  CD1 LEU D  66       6.088  22.423  22.791  1.00 70.54           C  
ATOM   8048  CD2 LEU D  66       8.203  21.683  23.944  1.00 72.03           C  
ATOM   8049  N   LYS D  67       4.630  24.186  25.519  1.00 78.75           N  
ATOM   8050  CA  LYS D  67       3.842  23.700  26.671  1.00 80.48           C  
ATOM   8051  C   LYS D  67       4.071  22.221  26.988  1.00 80.17           C  
ATOM   8052  O   LYS D  67       4.528  21.895  28.084  1.00 80.50           O  
ATOM   8053  CB  LYS D  67       2.336  23.944  26.449  1.00 83.33           C  
ATOM   8054  CG  LYS D  67       1.902  25.446  26.507  1.00 87.04           C  
ATOM   8055  CD  LYS D  67       0.357  25.621  26.495  1.00 89.18           C  
ATOM   8056  CE  LYS D  67      -0.304  24.931  25.266  1.00 89.71           C  
ATOM   8057  NZ  LYS D  67      -1.661  24.360  25.566  1.00 90.05           N  
ATOM   8058  N   ASN D  68       3.754  21.340  26.025  1.00 79.35           N  
ATOM   8059  CA  ASN D  68       3.913  19.875  26.186  1.00 78.20           C  
ATOM   8060  C   ASN D  68       5.220  19.328  25.629  1.00 76.65           C  
ATOM   8061  O   ASN D  68       5.501  19.470  24.433  1.00 77.15           O  
ATOM   8062  CB  ASN D  68       2.791  19.112  25.497  1.00 77.79           C  
ATOM   8063  CG  ASN D  68       1.463  19.800  25.623  1.00 78.45           C  
ATOM   8064  OD1 ASN D  68       0.454  19.280  25.160  1.00 79.16           O  
ATOM   8065  ND2 ASN D  68       1.450  20.986  26.236  1.00 76.51           N  
ATOM   8066  N   PHE D  69       5.976  18.669  26.510  1.00 73.87           N  
ATOM   8067  CA  PHE D  69       7.257  18.068  26.194  1.00 70.65           C  
ATOM   8068  C   PHE D  69       7.286  16.603  26.625  1.00 68.82           C  
ATOM   8069  O   PHE D  69       7.789  16.293  27.723  1.00 68.78           O  
ATOM   8070  CB  PHE D  69       8.371  18.819  26.922  1.00 69.98           C  
ATOM   8071  CG  PHE D  69       9.738  18.494  26.413  1.00 70.13           C  
ATOM   8072  CD1 PHE D  69      10.842  18.546  27.254  1.00 70.03           C  
ATOM   8073  CD2 PHE D  69       9.929  18.175  25.074  1.00 69.81           C  
ATOM   8074  CE1 PHE D  69      12.120  18.285  26.766  1.00 70.16           C  
ATOM   8075  CE2 PHE D  69      11.195  17.916  24.584  1.00 69.95           C  
ATOM   8076  CZ  PHE D  69      12.295  17.973  25.428  1.00 69.64           C  
ATOM   8077  N   PRO D  70       6.765  15.690  25.777  1.00 66.73           N  
ATOM   8078  CA  PRO D  70       6.686  14.237  25.986  1.00 65.73           C  
ATOM   8079  C   PRO D  70       8.019  13.535  26.270  1.00 65.07           C  
ATOM   8080  O   PRO D  70       8.062  12.449  26.860  1.00 64.37           O  
ATOM   8081  CB  PRO D  70       6.055  13.748  24.700  1.00 64.61           C  
ATOM   8082  CG  PRO D  70       5.211  14.907  24.314  1.00 64.69           C  
ATOM   8083  CD  PRO D  70       6.116  16.049  24.516  1.00 65.89           C  
ATOM   8084  N   ILE D  71       9.110  14.158  25.854  1.00 65.08           N  
ATOM   8085  CA  ILE D  71      10.422  13.579  26.050  1.00 64.87           C  
ATOM   8086  C   ILE D  71      10.895  13.787  27.470  1.00 65.25           C  
ATOM   8087  O   ILE D  71      11.446  14.824  27.810  1.00 64.04           O  
ATOM   8088  CB  ILE D  71      11.423  14.184  25.051  1.00 63.32           C  
ATOM   8089  CG1 ILE D  71      10.934  13.903  23.642  1.00 60.22           C  
ATOM   8090  CG2 ILE D  71      12.809  13.591  25.255  1.00 61.53           C  
ATOM   8091  CD1 ILE D  71      11.726  14.577  22.624  1.00 58.75           C  
ATOM   8092  N   LYS D  72      10.671  12.776  28.296  1.00 67.56           N  
ATOM   8093  CA  LYS D  72      11.058  12.818  29.706  1.00 70.02           C  
ATOM   8094  C   LYS D  72      12.055  11.678  30.008  1.00 70.25           C  
ATOM   8095  O   LYS D  72      12.237  10.750  29.207  1.00 69.75           O  
ATOM   8096  CB  LYS D  72       9.803  12.653  30.593  1.00 70.34           C  
ATOM   8097  CG  LYS D  72       8.684  13.669  30.386  1.00 71.44           C  
ATOM   8098  CD  LYS D  72       7.319  12.993  30.537  1.00 73.47           C  
ATOM   8099  CE  LYS D  72       6.348  13.767  31.454  1.00 74.59           C  
ATOM   8100  NZ  LYS D  72       5.869  15.055  30.861  1.00 74.83           N  
ATOM   8101  N   PRO D  73      12.695  11.720  31.190  1.00 70.99           N  
ATOM   8102  CA  PRO D  73      13.654  10.644  31.511  1.00 70.15           C  
ATOM   8103  C   PRO D  73      13.038   9.241  31.422  1.00 68.80           C  
ATOM   8104  O   PRO D  73      11.847   9.051  31.692  1.00 67.29           O  
ATOM   8105  CB  PRO D  73      14.119  10.994  32.932  1.00 69.62           C  
ATOM   8106  CG  PRO D  73      14.000  12.501  32.973  1.00 69.78           C  
ATOM   8107  CD  PRO D  73      12.669  12.754  32.252  1.00 70.72           C  
ATOM   8108  N   GLY D  74      13.874   8.284  31.011  1.00 68.25           N  
ATOM   8109  CA  GLY D  74      13.466   6.906  30.879  1.00 66.42           C  
ATOM   8110  C   GLY D  74      12.590   6.620  29.683  1.00 66.25           C  
ATOM   8111  O   GLY D  74      12.217   5.471  29.462  1.00 66.51           O  
ATOM   8112  N   LYS D  75      12.253   7.654  28.913  1.00 66.07           N  
ATOM   8113  CA  LYS D  75      11.415   7.497  27.710  1.00 65.73           C  
ATOM   8114  C   LYS D  75      12.206   6.972  26.487  1.00 64.96           C  
ATOM   8115  O   LYS D  75      13.435   7.117  26.392  1.00 63.72           O  
ATOM   8116  CB  LYS D  75      10.779   8.834  27.326  1.00 66.72           C  
ATOM   8117  CG  LYS D  75       9.795   9.402  28.307  1.00 68.55           C  
ATOM   8118  CD  LYS D  75       8.562   8.520  28.398  1.00 70.06           C  
ATOM   8119  CE  LYS D  75       7.430   9.255  29.084  1.00 71.49           C  
ATOM   8120  NZ  LYS D  75       7.892   9.899  30.362  1.00 73.34           N  
ATOM   8121  N   SER D  76      11.489   6.360  25.555  1.00 63.40           N  
ATOM   8122  CA  SER D  76      12.116   5.847  24.350  1.00 63.19           C  
ATOM   8123  C   SER D  76      11.621   6.706  23.176  1.00 62.87           C  
ATOM   8124  O   SER D  76      10.415   6.920  23.025  1.00 63.47           O  
ATOM   8125  CB  SER D  76      11.735   4.379  24.151  1.00 63.05           C  
ATOM   8126  OG  SER D  76      10.325   4.241  23.973  1.00 64.81           O  
ATOM   8127  N   VAL D  77      12.527   7.231  22.357  1.00 60.77           N  
ATOM   8128  CA  VAL D  77      12.075   8.063  21.251  1.00 59.00           C  
ATOM   8129  C   VAL D  77      12.627   7.593  19.932  1.00 57.19           C  
ATOM   8130  O   VAL D  77      13.786   7.188  19.853  1.00 57.20           O  
ATOM   8131  CB  VAL D  77      12.484   9.561  21.455  1.00 59.34           C  
ATOM   8132  CG1 VAL D  77      12.053  10.041  22.836  1.00 58.45           C  
ATOM   8133  CG2 VAL D  77      13.986   9.729  21.332  1.00 59.77           C  
ATOM   8134  N   LEU D  78      11.776   7.633  18.910  1.00 55.65           N  
ATOM   8135  CA  LEU D  78      12.146   7.278  17.520  1.00 53.67           C  
ATOM   8136  C   LEU D  78      12.354   8.649  16.841  1.00 52.97           C  
ATOM   8137  O   LEU D  78      11.379   9.309  16.439  1.00 52.74           O  
ATOM   8138  CB  LEU D  78      11.013   6.534  16.803  1.00 51.23           C  
ATOM   8139  CG  LEU D  78      11.355   5.639  15.616  1.00 51.32           C  
ATOM   8140  CD1 LEU D  78      10.255   5.766  14.582  1.00 51.76           C  
ATOM   8141  CD2 LEU D  78      12.715   5.955  15.021  1.00 49.05           C  
ATOM   8142  N   TYR D  79      13.622   9.067  16.720  1.00 51.15           N  
ATOM   8143  CA  TYR D  79      13.986  10.364  16.136  1.00 48.70           C  
ATOM   8144  C   TYR D  79      14.227  10.220  14.638  1.00 47.27           C  
ATOM   8145  O   TYR D  79      15.207   9.625  14.236  1.00 47.57           O  
ATOM   8146  CB  TYR D  79      15.236  10.886  16.862  1.00 48.79           C  
ATOM   8147  CG  TYR D  79      15.611  12.338  16.642  1.00 51.20           C  
ATOM   8148  CD1 TYR D  79      16.032  13.148  17.709  1.00 52.14           C  
ATOM   8149  CD2 TYR D  79      15.602  12.883  15.371  1.00 51.13           C  
ATOM   8150  CE1 TYR D  79      16.437  14.491  17.496  1.00 54.41           C  
ATOM   8151  CE2 TYR D  79      15.999  14.177  15.137  1.00 52.80           C  
ATOM   8152  CZ  TYR D  79      16.419  14.997  16.194  1.00 54.64           C  
ATOM   8153  OH  TYR D  79      16.793  16.299  15.889  1.00 54.40           O  
ATOM   8154  N   LEU D  80      13.316  10.753  13.823  1.00 46.29           N  
ATOM   8155  CA  LEU D  80      13.442  10.713  12.355  1.00 45.21           C  
ATOM   8156  C   LEU D  80      14.159  11.960  11.874  1.00 44.74           C  
ATOM   8157  O   LEU D  80      13.657  13.045  12.071  1.00 45.80           O  
ATOM   8158  CB  LEU D  80      12.066  10.676  11.706  1.00 43.50           C  
ATOM   8159  CG  LEU D  80      11.233   9.551  12.285  1.00 42.59           C  
ATOM   8160  CD1 LEU D  80       9.864   9.673  11.733  1.00 43.25           C  
ATOM   8161  CD2 LEU D  80      11.832   8.194  11.952  1.00 41.04           C  
ATOM   8162  N   GLY D  81      15.324  11.806  11.256  1.00 45.18           N  
ATOM   8163  CA  GLY D  81      16.067  12.956  10.778  1.00 44.42           C  
ATOM   8164  C   GLY D  81      17.131  13.367  11.775  1.00 45.44           C  
ATOM   8165  O   GLY D  81      17.490  14.554  11.874  1.00 46.61           O  
ATOM   8166  N   ILE D  82      17.649  12.375  12.502  1.00 44.57           N  
ATOM   8167  CA  ILE D  82      18.650  12.570  13.545  1.00 43.18           C  
ATOM   8168  C   ILE D  82      19.888  13.307  13.111  1.00 41.68           C  
ATOM   8169  O   ILE D  82      20.628  13.830  13.941  1.00 41.86           O  
ATOM   8170  CB  ILE D  82      19.052  11.214  14.198  1.00 45.24           C  
ATOM   8171  CG1 ILE D  82      19.742  11.509  15.551  1.00 45.88           C  
ATOM   8172  CG2 ILE D  82      19.930  10.373  13.250  1.00 41.36           C  
ATOM   8173  CD1 ILE D  82      19.675  10.393  16.542  1.00 45.60           C  
ATOM   8174  N   ALA D  83      20.131  13.343  11.814  1.00 40.58           N  
ATOM   8175  CA  ALA D  83      21.266  14.090  11.301  1.00 40.61           C  
ATOM   8176  C   ALA D  83      22.541  13.823  12.071  1.00 42.06           C  
ATOM   8177  O   ALA D  83      22.926  12.687  12.247  1.00 43.02           O  
ATOM   8178  CB  ALA D  83      20.943  15.559  11.342  1.00 37.74           C  
ATOM   8179  N   SER D  84      23.190  14.892  12.518  1.00 43.18           N  
ATOM   8180  CA  SER D  84      24.429  14.835  13.272  1.00 44.09           C  
ATOM   8181  C   SER D  84      24.290  14.603  14.781  1.00 45.81           C  
ATOM   8182  O   SER D  84      25.288  14.428  15.491  1.00 45.19           O  
ATOM   8183  CB  SER D  84      25.180  16.137  13.076  1.00 44.20           C  
ATOM   8184  OG  SER D  84      26.349  15.882  12.381  1.00 47.86           O  
ATOM   8185  N   GLY D  85      23.063  14.652  15.279  1.00 47.07           N  
ATOM   8186  CA  GLY D  85      22.844  14.465  16.705  1.00 48.49           C  
ATOM   8187  C   GLY D  85      22.902  15.701  17.619  1.00 48.62           C  
ATOM   8188  O   GLY D  85      22.895  15.536  18.840  1.00 49.52           O  
ATOM   8189  N   THR D  86      22.988  16.913  17.050  1.00 47.24           N  
ATOM   8190  CA  THR D  86      22.997  18.141  17.838  1.00 45.31           C  
ATOM   8191  C   THR D  86      21.823  18.204  18.801  1.00 45.70           C  
ATOM   8192  O   THR D  86      22.007  18.264  20.030  1.00 47.27           O  
ATOM   8193  CB  THR D  86      22.892  19.417  16.985  1.00 43.05           C  
ATOM   8194  OG1 THR D  86      24.146  19.671  16.369  1.00 43.74           O  
ATOM   8195  CG2 THR D  86      22.497  20.624  17.848  1.00 39.90           C  
ATOM   8196  N   THR D  87      20.615  18.216  18.269  1.00 45.15           N  
ATOM   8197  CA  THR D  87      19.536  18.260  19.187  1.00 46.80           C  
ATOM   8198  C   THR D  87      19.288  16.903  19.800  1.00 47.43           C  
ATOM   8199  O   THR D  87      18.901  16.828  20.954  1.00 49.28           O  
ATOM   8200  CB  THR D  87      18.211  18.882  18.593  1.00 46.66           C  
ATOM   8201  OG1 THR D  87      17.116  17.975  18.841  1.00 47.00           O  
ATOM   8202  CG2 THR D  87      18.376  19.247  17.144  1.00 45.63           C  
ATOM   8203  N   ALA D  88      19.550  15.830  19.080  1.00 49.18           N  
ATOM   8204  CA  ALA D  88      19.326  14.503  19.671  1.00 49.54           C  
ATOM   8205  C   ALA D  88      20.220  14.262  20.894  1.00 48.84           C  
ATOM   8206  O   ALA D  88      19.888  13.432  21.751  1.00 47.66           O  
ATOM   8207  CB  ALA D  88      19.587  13.400  18.633  1.00 51.54           C  
ATOM   8208  N   SER D  89      21.342  14.975  20.976  1.00 47.04           N  
ATOM   8209  CA  SER D  89      22.220  14.784  22.107  1.00 47.37           C  
ATOM   8210  C   SER D  89      21.560  15.386  23.336  1.00 49.81           C  
ATOM   8211  O   SER D  89      21.748  14.891  24.435  1.00 50.29           O  
ATOM   8212  CB  SER D  89      23.596  15.435  21.879  1.00 47.34           C  
ATOM   8213  OG  SER D  89      23.573  16.842  21.990  1.00 43.00           O  
ATOM   8214  N   HIS D  90      20.804  16.470  23.161  1.00 50.94           N  
ATOM   8215  CA  HIS D  90      20.135  17.064  24.306  1.00 51.57           C  
ATOM   8216  C   HIS D  90      18.985  16.146  24.723  1.00 52.45           C  
ATOM   8217  O   HIS D  90      18.730  16.008  25.909  1.00 54.31           O  
ATOM   8218  CB  HIS D  90      19.615  18.472  24.003  1.00 50.93           C  
ATOM   8219  CG  HIS D  90      20.698  19.492  23.931  1.00 52.25           C  
ATOM   8220  ND1 HIS D  90      21.374  19.933  25.050  1.00 52.76           N  
ATOM   8221  CD2 HIS D  90      21.319  20.069  22.869  1.00 53.39           C  
ATOM   8222  CE1 HIS D  90      22.367  20.732  24.682  1.00 52.40           C  
ATOM   8223  NE2 HIS D  90      22.355  20.830  23.368  1.00 52.64           N  
ATOM   8224  N   VAL D  91      18.298  15.495  23.786  1.00 51.90           N  
ATOM   8225  CA  VAL D  91      17.225  14.629  24.229  1.00 52.21           C  
ATOM   8226  C   VAL D  91      17.849  13.378  24.888  1.00 54.88           C  
ATOM   8227  O   VAL D  91      17.223  12.718  25.727  1.00 56.29           O  
ATOM   8228  CB  VAL D  91      16.163  14.345  23.071  1.00 48.66           C  
ATOM   8229  CG1 VAL D  91      16.531  15.127  21.840  1.00 47.34           C  
ATOM   8230  CG2 VAL D  91      16.001  12.884  22.802  1.00 44.63           C  
ATOM   8231  N   SER D  92      19.099  13.074  24.554  1.00 56.84           N  
ATOM   8232  CA  SER D  92      19.816  11.939  25.177  1.00 58.84           C  
ATOM   8233  C   SER D  92      20.092  12.287  26.676  1.00 59.59           C  
ATOM   8234  O   SER D  92      19.924  11.464  27.576  1.00 58.25           O  
ATOM   8235  CB  SER D  92      21.143  11.695  24.432  1.00 59.38           C  
ATOM   8236  OG  SER D  92      22.055  10.916  25.186  1.00 59.86           O  
ATOM   8237  N   ASP D  93      20.525  13.531  26.899  1.00 60.26           N  
ATOM   8238  CA  ASP D  93      20.783  14.087  28.214  1.00 59.51           C  
ATOM   8239  C   ASP D  93      19.505  13.966  29.054  1.00 60.59           C  
ATOM   8240  O   ASP D  93      19.536  13.550  30.215  1.00 62.86           O  
ATOM   8241  CB  ASP D  93      21.188  15.559  28.076  1.00 57.70           C  
ATOM   8242  CG  ASP D  93      22.646  15.728  27.653  1.00 58.64           C  
ATOM   8243  OD1 ASP D  93      23.088  16.862  27.311  1.00 57.94           O  
ATOM   8244  OD2 ASP D  93      23.363  14.711  27.678  1.00 58.96           O  
ATOM   8245  N   ILE D  94      18.378  14.301  28.446  1.00 59.81           N  
ATOM   8246  CA  ILE D  94      17.091  14.286  29.120  1.00 59.37           C  
ATOM   8247  C   ILE D  94      16.559  12.907  29.343  1.00 60.68           C  
ATOM   8248  O   ILE D  94      16.104  12.553  30.426  1.00 62.74           O  
ATOM   8249  CB  ILE D  94      16.017  15.058  28.289  1.00 59.23           C  
ATOM   8250  CG1 ILE D  94      16.412  16.547  28.237  1.00 56.17           C  
ATOM   8251  CG2 ILE D  94      14.584  14.775  28.840  1.00 54.53           C  
ATOM   8252  CD1 ILE D  94      15.563  17.371  27.354  1.00 55.94           C  
ATOM   8253  N   VAL D  95      16.584  12.111  28.301  1.00 60.89           N  
ATOM   8254  CA  VAL D  95      16.031  10.794  28.421  1.00 59.35           C  
ATOM   8255  C   VAL D  95      16.854   9.925  29.415  1.00 60.04           C  
ATOM   8256  O   VAL D  95      16.321   8.973  30.003  1.00 59.23           O  
ATOM   8257  CB  VAL D  95      15.919  10.231  27.011  1.00 58.86           C  
ATOM   8258  CG1 VAL D  95      17.227   9.563  26.577  1.00 57.73           C  
ATOM   8259  CG2 VAL D  95      14.716   9.363  26.918  1.00 57.99           C  
ATOM   8260  N   GLY D  96      18.135  10.275  29.608  1.00 60.03           N  
ATOM   8261  CA  GLY D  96      19.010   9.566  30.539  1.00 60.56           C  
ATOM   8262  C   GLY D  96      19.361   8.125  30.206  1.00 61.62           C  
ATOM   8263  O   GLY D  96      19.008   7.643  29.136  1.00 62.48           O  
ATOM   8264  N   TRP D  97      20.052   7.422  31.112  1.00 61.86           N  
ATOM   8265  CA  TRP D  97      20.440   6.034  30.854  1.00 60.05           C  
ATOM   8266  C   TRP D  97      19.301   5.053  30.811  1.00 61.61           C  
ATOM   8267  O   TRP D  97      19.494   3.911  30.465  1.00 61.26           O  
ATOM   8268  CB  TRP D  97      21.460   5.559  31.854  1.00 55.48           C  
ATOM   8269  CG  TRP D  97      22.717   6.243  31.711  1.00 54.41           C  
ATOM   8270  CD1 TRP D  97      23.338   7.027  32.645  1.00 55.49           C  
ATOM   8271  CD2 TRP D  97      23.574   6.211  30.581  1.00 54.34           C  
ATOM   8272  NE1 TRP D  97      24.543   7.482  32.170  1.00 53.89           N  
ATOM   8273  CE2 TRP D  97      24.712   7.000  30.896  1.00 54.21           C  
ATOM   8274  CE3 TRP D  97      23.503   5.597  29.330  1.00 53.89           C  
ATOM   8275  CZ2 TRP D  97      25.772   7.191  29.994  1.00 53.32           C  
ATOM   8276  CZ3 TRP D  97      24.561   5.784  28.429  1.00 53.70           C  
ATOM   8277  CH2 TRP D  97      25.677   6.577  28.769  1.00 53.04           C  
ATOM   8278  N   GLU D  98      18.102   5.464  31.167  1.00 65.32           N  
ATOM   8279  CA  GLU D  98      17.024   4.498  31.074  1.00 69.23           C  
ATOM   8280  C   GLU D  98      16.317   4.727  29.736  1.00 68.94           C  
ATOM   8281  O   GLU D  98      15.522   3.895  29.286  1.00 68.07           O  
ATOM   8282  CB  GLU D  98      16.035   4.675  32.232  1.00 75.56           C  
ATOM   8283  CG  GLU D  98      14.858   3.666  32.186  1.00 83.97           C  
ATOM   8284  CD  GLU D  98      15.348   2.202  32.063  1.00 89.98           C  
ATOM   8285  OE1 GLU D  98      16.138   1.738  32.961  1.00 93.50           O  
ATOM   8286  OE2 GLU D  98      14.955   1.520  31.064  1.00 92.00           O  
ATOM   8287  N   GLY D  99      16.624   5.875  29.118  1.00 67.97           N  
ATOM   8288  CA  GLY D  99      16.043   6.239  27.845  1.00 67.00           C  
ATOM   8289  C   GLY D  99      16.725   5.538  26.693  1.00 66.86           C  
ATOM   8290  O   GLY D  99      17.860   5.082  26.811  1.00 66.07           O  
ATOM   8291  N   LYS D 100      16.012   5.452  25.575  1.00 67.00           N  
ATOM   8292  CA  LYS D 100      16.504   4.796  24.360  1.00 66.39           C  
ATOM   8293  C   LYS D 100      16.178   5.711  23.169  1.00 64.33           C  
ATOM   8294  O   LYS D 100      15.089   6.307  23.085  1.00 64.06           O  
ATOM   8295  CB  LYS D 100      15.792   3.450  24.170  1.00 67.29           C  
ATOM   8296  CG  LYS D 100      15.715   2.645  25.435  1.00 69.39           C  
ATOM   8297  CD  LYS D 100      14.972   1.320  25.264  1.00 71.92           C  
ATOM   8298  CE  LYS D 100      14.320   0.874  26.611  1.00 72.91           C  
ATOM   8299  NZ  LYS D 100      15.239   0.863  27.821  1.00 72.66           N  
ATOM   8300  N   ILE D 101      17.123   5.837  22.250  1.00 61.00           N  
ATOM   8301  CA  ILE D 101      16.871   6.669  21.092  1.00 56.20           C  
ATOM   8302  C   ILE D 101      17.309   5.967  19.829  1.00 54.61           C  
ATOM   8303  O   ILE D 101      18.494   5.659  19.664  1.00 53.86           O  
ATOM   8304  CB  ILE D 101      17.604   8.011  21.172  1.00 55.01           C  
ATOM   8305  CG1 ILE D 101      17.174   8.786  22.421  1.00 53.71           C  
ATOM   8306  CG2 ILE D 101      17.311   8.823  19.958  1.00 52.59           C  
ATOM   8307  CD1 ILE D 101      18.107   9.968  22.726  1.00 52.00           C  
ATOM   8308  N   TYR D 102      16.332   5.684  18.958  1.00 52.44           N  
ATOM   8309  CA  TYR D 102      16.578   5.075  17.651  1.00 50.06           C  
ATOM   8310  C   TYR D 102      16.640   6.256  16.684  1.00 48.10           C  
ATOM   8311  O   TYR D 102      15.608   6.832  16.342  1.00 48.37           O  
ATOM   8312  CB  TYR D 102      15.430   4.176  17.244  1.00 51.07           C  
ATOM   8313  CG  TYR D 102      15.224   3.010  18.154  1.00 54.09           C  
ATOM   8314  CD1 TYR D 102      14.076   2.914  18.925  1.00 55.49           C  
ATOM   8315  CD2 TYR D 102      16.179   2.015  18.271  1.00 56.76           C  
ATOM   8316  CE1 TYR D 102      13.876   1.868  19.793  1.00 57.37           C  
ATOM   8317  CE2 TYR D 102      15.986   0.960  19.143  1.00 58.62           C  
ATOM   8318  CZ  TYR D 102      14.833   0.892  19.904  1.00 58.24           C  
ATOM   8319  OH  TYR D 102      14.644  -0.133  20.793  1.00 60.01           O  
ATOM   8320  N   GLY D 103      17.840   6.636  16.264  1.00 45.47           N  
ATOM   8321  CA  GLY D 103      17.977   7.764  15.354  1.00 43.95           C  
ATOM   8322  C   GLY D 103      18.070   7.368  13.888  1.00 42.32           C  
ATOM   8323  O   GLY D 103      18.962   6.639  13.479  1.00 42.09           O  
ATOM   8324  N   ILE D 104      17.145   7.851  13.081  1.00 41.91           N  
ATOM   8325  CA  ILE D 104      17.165   7.515  11.662  1.00 41.07           C  
ATOM   8326  C   ILE D 104      17.688   8.676  10.849  1.00 38.60           C  
ATOM   8327  O   ILE D 104      17.309   9.803  11.085  1.00 38.55           O  
ATOM   8328  CB  ILE D 104      15.791   7.221  11.188  1.00 42.61           C  
ATOM   8329  CG1 ILE D 104      15.112   6.253  12.189  1.00 41.33           C  
ATOM   8330  CG2 ILE D 104      15.864   6.791   9.739  1.00 41.97           C  
ATOM   8331  CD1 ILE D 104      15.526   4.790  12.078  1.00 40.83           C  
ATOM   8332  N   GLU D 105      18.547   8.395   9.895  1.00 37.53           N  
ATOM   8333  CA  GLU D 105      19.123   9.443   9.091  1.00 37.33           C  
ATOM   8334  C   GLU D 105      19.466   8.856   7.718  1.00 37.79           C  
ATOM   8335  O   GLU D 105      20.069   7.778   7.599  1.00 37.22           O  
ATOM   8336  CB  GLU D 105      20.341   9.995   9.803  1.00 38.03           C  
ATOM   8337  CG  GLU D 105      21.239  10.896   9.000  1.00 40.98           C  
ATOM   8338  CD  GLU D 105      20.497  12.065   8.404  1.00 44.57           C  
ATOM   8339  OE1 GLU D 105      19.752  12.780   9.142  1.00 45.22           O  
ATOM   8340  OE2 GLU D 105      20.663  12.278   7.172  1.00 44.64           O  
ATOM   8341  N   PHE D 106      19.043   9.578   6.681  1.00 37.82           N  
ATOM   8342  CA  PHE D 106      19.211   9.156   5.302  1.00 36.05           C  
ATOM   8343  C   PHE D 106      20.592   9.424   4.724  1.00 36.34           C  
ATOM   8344  O   PHE D 106      21.139   8.566   4.016  1.00 36.15           O  
ATOM   8345  CB  PHE D 106      18.141   9.863   4.475  1.00 35.33           C  
ATOM   8346  CG  PHE D 106      18.201   9.588   2.982  1.00 34.67           C  
ATOM   8347  CD1 PHE D 106      19.203  10.148   2.192  1.00 30.85           C  
ATOM   8348  CD2 PHE D 106      17.217   8.797   2.362  1.00 34.34           C  
ATOM   8349  CE1 PHE D 106      19.227   9.950   0.830  1.00 31.22           C  
ATOM   8350  CE2 PHE D 106      17.228   8.592   0.986  1.00 31.63           C  
ATOM   8351  CZ  PHE D 106      18.240   9.163   0.221  1.00 31.92           C  
ATOM   8352  N   SER D 107      21.150  10.598   5.002  1.00 35.59           N  
ATOM   8353  CA  SER D 107      22.439  10.911   4.423  1.00 37.64           C  
ATOM   8354  C   SER D 107      23.607  10.339   5.232  1.00 38.05           C  
ATOM   8355  O   SER D 107      23.957  10.861   6.269  1.00 38.40           O  
ATOM   8356  CB  SER D 107      22.606  12.413   4.257  1.00 37.08           C  
ATOM   8357  OG  SER D 107      23.837  12.683   3.571  1.00 40.87           O  
ATOM   8358  N   PRO D 108      24.272   9.296   4.716  1.00 38.96           N  
ATOM   8359  CA  PRO D 108      25.390   8.662   5.426  1.00 40.00           C  
ATOM   8360  C   PRO D 108      26.498   9.576   5.926  1.00 40.60           C  
ATOM   8361  O   PRO D 108      26.945   9.434   7.054  1.00 39.99           O  
ATOM   8362  CB  PRO D 108      25.884   7.632   4.431  1.00 38.68           C  
ATOM   8363  CG  PRO D 108      25.655   8.339   3.097  1.00 37.39           C  
ATOM   8364  CD  PRO D 108      24.268   8.916   3.287  1.00 38.58           C  
ATOM   8365  N   ARG D 109      26.963  10.498   5.095  1.00 42.10           N  
ATOM   8366  CA  ARG D 109      28.035  11.388   5.538  1.00 43.14           C  
ATOM   8367  C   ARG D 109      27.566  12.232   6.720  1.00 44.26           C  
ATOM   8368  O   ARG D 109      28.382  12.767   7.474  1.00 45.40           O  
ATOM   8369  CB  ARG D 109      28.417  12.308   4.409  1.00 43.32           C  
ATOM   8370  CG  ARG D 109      29.705  13.018   4.579  1.00 42.09           C  
ATOM   8371  CD  ARG D 109      30.125  13.466   3.187  1.00 42.79           C  
ATOM   8372  NE  ARG D 109      29.786  14.830   3.006  1.00 46.52           N  
ATOM   8373  CZ  ARG D 109      29.218  15.372   1.933  1.00 48.69           C  
ATOM   8374  NH1 ARG D 109      28.888  14.658   0.865  1.00 44.16           N  
ATOM   8375  NH2 ARG D 109      28.980  16.688   1.952  1.00 51.50           N  
ATOM   8376  N   VAL D 110      26.255  12.381   6.866  1.00 41.86           N  
ATOM   8377  CA  VAL D 110      25.773  13.158   7.975  1.00 41.56           C  
ATOM   8378  C   VAL D 110      25.695  12.233   9.204  1.00 41.60           C  
ATOM   8379  O   VAL D 110      26.223  12.561  10.248  1.00 43.26           O  
ATOM   8380  CB  VAL D 110      24.410  13.830   7.625  1.00 41.60           C  
ATOM   8381  CG1 VAL D 110      23.794  14.446   8.854  1.00 38.39           C  
ATOM   8382  CG2 VAL D 110      24.647  14.899   6.561  1.00 38.95           C  
ATOM   8383  N   LEU D 111      25.062  11.078   9.050  1.00 39.60           N  
ATOM   8384  CA  LEU D 111      24.966  10.121  10.101  1.00 38.02           C  
ATOM   8385  C   LEU D 111      26.357   9.739  10.587  1.00 38.50           C  
ATOM   8386  O   LEU D 111      26.547   9.400  11.733  1.00 38.49           O  
ATOM   8387  CB  LEU D 111      24.321   8.854   9.611  1.00 37.51           C  
ATOM   8388  CG  LEU D 111      23.407   8.206  10.636  1.00 37.69           C  
ATOM   8389  CD1 LEU D 111      23.377   6.682  10.454  1.00 38.02           C  
ATOM   8390  CD2 LEU D 111      23.859   8.578  12.000  1.00 36.99           C  
ATOM   8391  N   ARG D 112      27.344   9.793   9.712  1.00 38.53           N  
ATOM   8392  CA  ARG D 112      28.673   9.405  10.120  1.00 38.96           C  
ATOM   8393  C   ARG D 112      29.196  10.183  11.315  1.00 40.50           C  
ATOM   8394  O   ARG D 112      29.855   9.620  12.176  1.00 38.74           O  
ATOM   8395  CB  ARG D 112      29.671   9.500   8.954  1.00 37.64           C  
ATOM   8396  CG  ARG D 112      30.960   8.776   9.257  1.00 34.63           C  
ATOM   8397  CD  ARG D 112      31.793   8.690   8.054  1.00 38.68           C  
ATOM   8398  NE  ARG D 112      32.168   9.999   7.566  1.00 41.67           N  
ATOM   8399  CZ  ARG D 112      32.357  10.271   6.278  1.00 43.20           C  
ATOM   8400  NH1 ARG D 112      32.707  11.496   5.897  1.00 42.99           N  
ATOM   8401  NH2 ARG D 112      32.184   9.314   5.366  1.00 45.83           N  
ATOM   8402  N   GLU D 113      28.900  11.470  11.395  1.00 43.96           N  
ATOM   8403  CA  GLU D 113      29.408  12.242  12.523  1.00 47.72           C  
ATOM   8404  C   GLU D 113      28.898  11.822  13.906  1.00 46.27           C  
ATOM   8405  O   GLU D 113      29.593  11.978  14.913  1.00 44.70           O  
ATOM   8406  CB  GLU D 113      29.130  13.709  12.311  1.00 51.31           C  
ATOM   8407  CG  GLU D 113      30.223  14.405  11.582  1.00 59.61           C  
ATOM   8408  CD  GLU D 113      29.909  15.891  11.467  1.00 66.93           C  
ATOM   8409  OE1 GLU D 113      29.602  16.518  12.546  1.00 68.83           O  
ATOM   8410  OE2 GLU D 113      29.978  16.436  10.318  1.00 69.34           O  
ATOM   8411  N   LEU D 114      27.698  11.280  13.948  1.00 45.76           N  
ATOM   8412  CA  LEU D 114      27.126  10.849  15.205  1.00 46.63           C  
ATOM   8413  C   LEU D 114      27.719   9.516  15.703  1.00 48.30           C  
ATOM   8414  O   LEU D 114      27.752   9.268  16.898  1.00 50.37           O  
ATOM   8415  CB  LEU D 114      25.615  10.701  15.042  1.00 44.96           C  
ATOM   8416  CG  LEU D 114      24.781  10.164  16.193  1.00 43.29           C  
ATOM   8417  CD1 LEU D 114      24.920  11.123  17.361  1.00 38.28           C  
ATOM   8418  CD2 LEU D 114      23.319  10.018  15.764  1.00 42.33           C  
ATOM   8419  N   VAL D 115      28.185   8.662  14.801  1.00 48.59           N  
ATOM   8420  CA  VAL D 115      28.710   7.381  15.205  1.00 48.81           C  
ATOM   8421  C   VAL D 115      29.754   7.429  16.323  1.00 49.10           C  
ATOM   8422  O   VAL D 115      29.590   6.747  17.330  1.00 48.50           O  
ATOM   8423  CB  VAL D 115      29.173   6.625  13.959  1.00 49.34           C  
ATOM   8424  CG1 VAL D 115      29.853   5.316  14.308  1.00 45.97           C  
ATOM   8425  CG2 VAL D 115      27.905   6.385  13.081  1.00 48.69           C  
ATOM   8426  N   PRO D 116      30.804   8.256  16.208  1.00 50.16           N  
ATOM   8427  CA  PRO D 116      31.811   8.317  17.284  1.00 51.30           C  
ATOM   8428  C   PRO D 116      31.163   8.681  18.620  1.00 52.14           C  
ATOM   8429  O   PRO D 116      31.538   8.149  19.652  1.00 55.07           O  
ATOM   8430  CB  PRO D 116      32.764   9.411  16.824  1.00 49.42           C  
ATOM   8431  CG  PRO D 116      32.669   9.303  15.356  1.00 50.45           C  
ATOM   8432  CD  PRO D 116      31.168   9.164  15.126  1.00 49.54           C  
ATOM   8433  N   ILE D 117      30.188   9.584  18.582  1.00 52.02           N  
ATOM   8434  CA  ILE D 117      29.466  10.028  19.768  1.00 51.00           C  
ATOM   8435  C   ILE D 117      28.738   8.914  20.496  1.00 51.25           C  
ATOM   8436  O   ILE D 117      28.787   8.852  21.731  1.00 51.97           O  
ATOM   8437  CB  ILE D 117      28.427  11.203  19.421  1.00 49.44           C  
ATOM   8438  CG1 ILE D 117      29.083  12.542  19.624  1.00 47.65           C  
ATOM   8439  CG2 ILE D 117      27.185  11.176  20.312  1.00 47.37           C  
ATOM   8440  CD1 ILE D 117      30.302  12.681  18.840  1.00 47.48           C  
ATOM   8441  N   VAL D 118      28.070   8.034  19.760  1.00 51.37           N  
ATOM   8442  CA  VAL D 118      27.317   6.991  20.423  1.00 53.17           C  
ATOM   8443  C   VAL D 118      28.186   5.930  21.091  1.00 55.81           C  
ATOM   8444  O   VAL D 118      27.678   5.048  21.812  1.00 55.25           O  
ATOM   8445  CB  VAL D 118      26.348   6.319  19.471  1.00 52.96           C  
ATOM   8446  CG1 VAL D 118      25.386   7.338  18.969  1.00 52.61           C  
ATOM   8447  CG2 VAL D 118      27.089   5.660  18.337  1.00 52.43           C  
ATOM   8448  N   GLU D 119      29.494   6.005  20.867  1.00 57.35           N  
ATOM   8449  CA  GLU D 119      30.367   5.060  21.510  1.00 60.07           C  
ATOM   8450  C   GLU D 119      30.224   5.201  23.030  1.00 60.85           C  
ATOM   8451  O   GLU D 119      30.054   4.206  23.727  1.00 60.82           O  
ATOM   8452  CB  GLU D 119      31.788   5.325  21.137  1.00 63.25           C  
ATOM   8453  CG  GLU D 119      32.687   4.598  22.053  1.00 69.87           C  
ATOM   8454  CD  GLU D 119      33.920   4.133  21.342  1.00 75.32           C  
ATOM   8455  OE1 GLU D 119      34.502   3.077  21.777  1.00 76.41           O  
ATOM   8456  OE2 GLU D 119      34.297   4.840  20.343  1.00 78.21           O  
ATOM   8457  N   GLU D 120      30.303   6.433  23.538  1.00 61.01           N  
ATOM   8458  CA  GLU D 120      30.141   6.671  24.961  1.00 60.90           C  
ATOM   8459  C   GLU D 120      28.714   7.035  25.310  1.00 58.91           C  
ATOM   8460  O   GLU D 120      28.280   6.884  26.442  1.00 57.98           O  
ATOM   8461  CB  GLU D 120      31.055   7.770  25.424  1.00 64.46           C  
ATOM   8462  CG  GLU D 120      32.465   7.310  25.404  1.00 73.81           C  
ATOM   8463  CD  GLU D 120      33.359   8.124  26.328  1.00 80.61           C  
ATOM   8464  OE1 GLU D 120      32.954   8.347  27.519  1.00 84.26           O  
ATOM   8465  OE2 GLU D 120      34.477   8.533  25.875  1.00 83.85           O  
ATOM   8466  N   ARG D 121      27.983   7.526  24.331  1.00 57.28           N  
ATOM   8467  CA  ARG D 121      26.615   7.885  24.549  1.00 56.73           C  
ATOM   8468  C   ARG D 121      25.768   6.725  24.056  1.00 56.95           C  
ATOM   8469  O   ARG D 121      24.910   6.882  23.171  1.00 56.55           O  
ATOM   8470  CB  ARG D 121      26.320   9.158  23.769  1.00 55.71           C  
ATOM   8471  CG  ARG D 121      24.962   9.754  24.050  1.00 55.06           C  
ATOM   8472  CD  ARG D 121      24.881  11.101  23.407  1.00 56.09           C  
ATOM   8473  NE  ARG D 121      25.655  12.157  24.076  1.00 55.21           N  
ATOM   8474  CZ  ARG D 121      25.198  12.870  25.111  1.00 55.68           C  
ATOM   8475  NH1 ARG D 121      25.965  13.821  25.654  1.00 52.30           N  
ATOM   8476  NH2 ARG D 121      23.978  12.600  25.611  1.00 53.59           N  
ATOM   8477  N   ARG D 122      26.015   5.554  24.634  1.00 57.61           N  
ATOM   8478  CA  ARG D 122      25.360   4.290  24.216  1.00 58.11           C  
ATOM   8479  C   ARG D 122      23.867   4.334  24.357  1.00 56.67           C  
ATOM   8480  O   ARG D 122      23.164   3.335  24.348  1.00 56.77           O  
ATOM   8481  CB  ARG D 122      25.955   3.144  25.028  1.00 59.10           C  
ATOM   8482  CG  ARG D 122      27.375   3.478  25.464  1.00 59.27           C  
ATOM   8483  CD  ARG D 122      28.157   2.297  26.000  1.00 60.93           C  
ATOM   8484  NE  ARG D 122      28.695   1.433  24.941  1.00 62.59           N  
ATOM   8485  CZ  ARG D 122      28.129   0.292  24.547  1.00 64.42           C  
ATOM   8486  NH1 ARG D 122      26.988  -0.131  25.120  1.00 63.45           N  
ATOM   8487  NH2 ARG D 122      28.715  -0.425  23.591  1.00 62.98           N  
ATOM   8488  N   ASN D 123      23.412   5.556  24.432  1.00 56.99           N  
ATOM   8489  CA  ASN D 123      22.035   5.929  24.593  1.00 56.56           C  
ATOM   8490  C   ASN D 123      21.243   5.933  23.289  1.00 54.95           C  
ATOM   8491  O   ASN D 123      20.012   5.738  23.250  1.00 54.33           O  
ATOM   8492  CB  ASN D 123      22.077   7.344  25.111  1.00 58.98           C  
ATOM   8493  CG  ASN D 123      20.892   7.652  25.847  1.00 63.02           C  
ATOM   8494  OD1 ASN D 123      20.680   8.781  26.293  1.00 66.16           O  
ATOM   8495  ND2 ASN D 123      20.055   6.624  26.020  1.00 64.70           N  
ATOM   8496  N   ILE D 124      22.008   6.222  22.243  1.00 51.75           N  
ATOM   8497  CA  ILE D 124      21.540   6.399  20.900  1.00 49.40           C  
ATOM   8498  C   ILE D 124      22.061   5.355  19.909  1.00 47.91           C  
ATOM   8499  O   ILE D 124      23.259   5.046  19.873  1.00 46.27           O  
ATOM   8500  CB  ILE D 124      22.010   7.787  20.404  1.00 49.79           C  
ATOM   8501  CG1 ILE D 124      21.531   8.863  21.356  1.00 50.38           C  
ATOM   8502  CG2 ILE D 124      21.475   8.085  19.034  1.00 48.82           C  
ATOM   8503  CD1 ILE D 124      22.409  10.113  21.312  1.00 50.28           C  
ATOM   8504  N   ILE D 125      21.146   4.852  19.088  1.00 45.84           N  
ATOM   8505  CA  ILE D 125      21.486   3.916  18.055  1.00 45.07           C  
ATOM   8506  C   ILE D 125      21.406   4.638  16.700  1.00 44.97           C  
ATOM   8507  O   ILE D 125      20.316   4.896  16.194  1.00 44.67           O  
ATOM   8508  CB  ILE D 125      20.501   2.742  17.996  1.00 45.00           C  
ATOM   8509  CG1 ILE D 125      20.496   1.988  19.331  1.00 43.47           C  
ATOM   8510  CG2 ILE D 125      20.917   1.805  16.838  1.00 44.39           C  
ATOM   8511  CD1 ILE D 125      19.709   0.729  19.303  1.00 40.02           C  
ATOM   8512  N   PRO D 126      22.552   4.966  16.095  1.00 44.33           N  
ATOM   8513  CA  PRO D 126      22.561   5.650  14.800  1.00 45.02           C  
ATOM   8514  C   PRO D 126      22.136   4.608  13.785  1.00 45.43           C  
ATOM   8515  O   PRO D 126      22.699   3.533  13.728  1.00 46.19           O  
ATOM   8516  CB  PRO D 126      24.022   6.037  14.638  1.00 44.78           C  
ATOM   8517  CG  PRO D 126      24.704   4.827  15.220  1.00 44.58           C  
ATOM   8518  CD  PRO D 126      23.922   4.603  16.493  1.00 44.47           C  
ATOM   8519  N   ILE D 127      21.133   4.921  13.003  1.00 44.90           N  
ATOM   8520  CA  ILE D 127      20.646   3.999  12.006  1.00 44.15           C  
ATOM   8521  C   ILE D 127      20.524   4.686  10.621  1.00 45.01           C  
ATOM   8522  O   ILE D 127      19.814   5.688  10.490  1.00 47.04           O  
ATOM   8523  CB  ILE D 127      19.257   3.531  12.390  1.00 43.27           C  
ATOM   8524  CG1 ILE D 127      19.314   2.852  13.748  1.00 43.52           C  
ATOM   8525  CG2 ILE D 127      18.655   2.657  11.264  1.00 39.88           C  
ATOM   8526  CD1 ILE D 127      18.005   2.067  14.125  1.00 44.53           C  
ATOM   8527  N   LEU D 128      21.183   4.167   9.596  1.00 44.05           N  
ATOM   8528  CA  LEU D 128      21.045   4.765   8.286  1.00 44.72           C  
ATOM   8529  C   LEU D 128      19.728   4.275   7.714  1.00 45.59           C  
ATOM   8530  O   LEU D 128      19.545   3.082   7.549  1.00 48.04           O  
ATOM   8531  CB  LEU D 128      22.157   4.317   7.390  1.00 42.56           C  
ATOM   8532  CG  LEU D 128      22.245   4.983   6.033  1.00 38.91           C  
ATOM   8533  CD1 LEU D 128      22.715   6.428   6.130  1.00 36.15           C  
ATOM   8534  CD2 LEU D 128      23.283   4.188   5.284  1.00 38.41           C  
ATOM   8535  N   GLY D 129      18.806   5.181   7.441  1.00 45.75           N  
ATOM   8536  CA  GLY D 129      17.534   4.762   6.909  1.00 46.88           C  
ATOM   8537  C   GLY D 129      16.819   5.902   6.221  1.00 48.77           C  
ATOM   8538  O   GLY D 129      17.263   7.059   6.269  1.00 47.68           O  
ATOM   8539  N   ASP D 130      15.697   5.562   5.590  1.00 50.23           N  
ATOM   8540  CA  ASP D 130      14.861   6.498   4.849  1.00 51.13           C  
ATOM   8541  C   ASP D 130      13.524   6.556   5.586  1.00 51.58           C  
ATOM   8542  O   ASP D 130      12.772   5.592   5.578  1.00 51.65           O  
ATOM   8543  CB  ASP D 130      14.648   5.952   3.440  1.00 52.70           C  
ATOM   8544  CG  ASP D 130      13.834   6.873   2.553  1.00 55.66           C  
ATOM   8545  OD1 ASP D 130      12.874   7.535   3.041  1.00 57.55           O  
ATOM   8546  OD2 ASP D 130      14.159   6.916   1.337  1.00 56.59           O  
ATOM   8547  N   ALA D 131      13.208   7.686   6.208  1.00 52.46           N  
ATOM   8548  CA  ALA D 131      11.962   7.783   6.964  1.00 53.23           C  
ATOM   8549  C   ALA D 131      10.708   7.494   6.148  1.00 53.61           C  
ATOM   8550  O   ALA D 131       9.654   7.227   6.728  1.00 53.33           O  
ATOM   8551  CB  ALA D 131      11.857   9.145   7.648  1.00 51.65           C  
ATOM   8552  N   THR D 132      10.804   7.542   4.820  1.00 53.82           N  
ATOM   8553  CA  THR D 132       9.615   7.283   4.007  1.00 54.45           C  
ATOM   8554  C   THR D 132       9.346   5.786   3.830  1.00 56.18           C  
ATOM   8555  O   THR D 132       8.275   5.398   3.332  1.00 58.78           O  
ATOM   8556  CB  THR D 132       9.701   7.934   2.589  1.00 52.31           C  
ATOM   8557  OG1 THR D 132      10.688   7.259   1.794  1.00 50.60           O  
ATOM   8558  CG2 THR D 132      10.038   9.398   2.695  1.00 51.01           C  
ATOM   8559  N   LYS D 133      10.313   4.950   4.226  1.00 55.67           N  
ATOM   8560  CA  LYS D 133      10.215   3.484   4.116  1.00 54.05           C  
ATOM   8561  C   LYS D 133      10.499   2.815   5.464  1.00 54.51           C  
ATOM   8562  O   LYS D 133      11.420   2.014   5.596  1.00 53.68           O  
ATOM   8563  CB  LYS D 133      11.214   2.959   3.083  1.00 53.13           C  
ATOM   8564  CG  LYS D 133      11.197   3.689   1.775  1.00 53.31           C  
ATOM   8565  CD  LYS D 133      11.935   2.940   0.704  1.00 54.03           C  
ATOM   8566  CE  LYS D 133      13.179   3.677   0.253  1.00 56.97           C  
ATOM   8567  NZ  LYS D 133      13.922   2.927  -0.830  1.00 60.14           N  
ATOM   8568  N   PRO D 134       9.689   3.123   6.485  1.00 55.89           N  
ATOM   8569  CA  PRO D 134       9.867   2.549   7.833  1.00 56.73           C  
ATOM   8570  C   PRO D 134      10.189   1.043   7.871  1.00 57.16           C  
ATOM   8571  O   PRO D 134      11.057   0.618   8.629  1.00 55.57           O  
ATOM   8572  CB  PRO D 134       8.550   2.913   8.548  1.00 57.03           C  
ATOM   8573  CG  PRO D 134       7.564   3.100   7.435  1.00 56.83           C  
ATOM   8574  CD  PRO D 134       8.380   3.792   6.365  1.00 56.21           C  
ATOM   8575  N   GLU D 135       9.497   0.258   7.045  1.00 57.13           N  
ATOM   8576  CA  GLU D 135       9.767  -1.163   6.977  1.00 57.83           C  
ATOM   8577  C   GLU D 135      11.266  -1.451   6.918  1.00 56.18           C  
ATOM   8578  O   GLU D 135      11.746  -2.357   7.607  1.00 56.11           O  
ATOM   8579  CB  GLU D 135       9.155  -1.802   5.738  1.00 60.32           C  
ATOM   8580  CG  GLU D 135       7.992  -1.056   5.167  1.00 67.50           C  
ATOM   8581  CD  GLU D 135       8.432   0.078   4.262  1.00 72.06           C  
ATOM   8582  OE1 GLU D 135       9.136  -0.192   3.233  1.00 74.66           O  
ATOM   8583  OE2 GLU D 135       8.066   1.243   4.574  1.00 73.88           O  
ATOM   8584  N   GLU D 136      12.015  -0.706   6.110  1.00 53.53           N  
ATOM   8585  CA  GLU D 136      13.431  -1.001   6.001  1.00 51.58           C  
ATOM   8586  C   GLU D 136      14.291  -0.861   7.242  1.00 49.61           C  
ATOM   8587  O   GLU D 136      15.498  -0.942   7.178  1.00 48.19           O  
ATOM   8588  CB  GLU D 136      14.044  -0.294   4.785  1.00 52.16           C  
ATOM   8589  CG  GLU D 136      13.299  -0.759   3.524  1.00 54.36           C  
ATOM   8590  CD  GLU D 136      13.914  -0.388   2.160  1.00 56.75           C  
ATOM   8591  OE1 GLU D 136      13.492  -1.058   1.174  1.00 56.08           O  
ATOM   8592  OE2 GLU D 136      14.778   0.546   2.046  1.00 57.17           O  
ATOM   8593  N   TYR D 137      13.677  -0.647   8.384  1.00 49.71           N  
ATOM   8594  CA  TYR D 137      14.449  -0.657   9.599  1.00 51.56           C  
ATOM   8595  C   TYR D 137      13.569  -1.229  10.734  1.00 52.64           C  
ATOM   8596  O   TYR D 137      13.726  -0.881  11.907  1.00 54.62           O  
ATOM   8597  CB  TYR D 137      15.060   0.734   9.914  1.00 52.86           C  
ATOM   8598  CG  TYR D 137      14.101   1.922   9.899  1.00 53.11           C  
ATOM   8599  CD1 TYR D 137      13.289   2.192  10.992  1.00 51.36           C  
ATOM   8600  CD2 TYR D 137      14.006   2.781   8.773  1.00 54.09           C  
ATOM   8601  CE1 TYR D 137      12.409   3.263  10.979  1.00 51.53           C  
ATOM   8602  CE2 TYR D 137      13.125   3.862   8.752  1.00 51.91           C  
ATOM   8603  CZ  TYR D 137      12.330   4.084   9.854  1.00 52.02           C  
ATOM   8604  OH  TYR D 137      11.410   5.084   9.842  1.00 51.96           O  
ATOM   8605  N   ARG D 138      12.665  -2.144  10.360  1.00 52.73           N  
ATOM   8606  CA  ARG D 138      11.719  -2.805  11.280  1.00 53.40           C  
ATOM   8607  C   ARG D 138      12.417  -3.672  12.333  1.00 54.42           C  
ATOM   8608  O   ARG D 138      11.986  -3.772  13.493  1.00 55.83           O  
ATOM   8609  CB  ARG D 138      10.764  -3.686  10.484  1.00 51.73           C  
ATOM   8610  CG  ARG D 138      11.457  -4.639   9.512  1.00 51.72           C  
ATOM   8611  CD  ARG D 138      10.430  -5.296   8.542  1.00 50.99           C  
ATOM   8612  NE  ARG D 138      10.988  -6.364   7.719  1.00 49.42           N  
ATOM   8613  CZ  ARG D 138      11.828  -6.194   6.696  1.00 50.78           C  
ATOM   8614  NH1 ARG D 138      12.279  -7.255   6.028  1.00 51.35           N  
ATOM   8615  NH2 ARG D 138      12.236  -4.982   6.330  1.00 49.90           N  
ATOM   8616  N   ALA D 139      13.497  -4.302  11.896  1.00 53.82           N  
ATOM   8617  CA  ALA D 139      14.289  -5.161  12.731  1.00 53.41           C  
ATOM   8618  C   ALA D 139      15.185  -4.386  13.657  1.00 54.06           C  
ATOM   8619  O   ALA D 139      15.734  -4.977  14.582  1.00 53.91           O  
ATOM   8620  CB  ALA D 139      15.153  -6.059  11.869  1.00 52.05           C  
ATOM   8621  N   LEU D 140      15.349  -3.076  13.449  1.00 53.00           N  
ATOM   8622  CA  LEU D 140      16.294  -2.359  14.307  1.00 51.32           C  
ATOM   8623  C   LEU D 140      15.718  -1.480  15.380  1.00 52.34           C  
ATOM   8624  O   LEU D 140      16.474  -0.901  16.150  1.00 51.79           O  
ATOM   8625  CB  LEU D 140      17.267  -1.560  13.448  1.00 48.91           C  
ATOM   8626  CG  LEU D 140      17.568  -2.270  12.124  1.00 47.83           C  
ATOM   8627  CD1 LEU D 140      18.371  -1.414  11.164  1.00 44.51           C  
ATOM   8628  CD2 LEU D 140      18.288  -3.522  12.441  1.00 44.75           C  
ATOM   8629  N   VAL D 141      14.394  -1.375  15.448  1.00 54.86           N  
ATOM   8630  CA  VAL D 141      13.754  -0.532  16.471  1.00 57.01           C  
ATOM   8631  C   VAL D 141      12.599  -1.282  17.162  1.00 58.81           C  
ATOM   8632  O   VAL D 141      12.175  -2.366  16.725  1.00 59.16           O  
ATOM   8633  CB  VAL D 141      13.214   0.824  15.836  1.00 56.44           C  
ATOM   8634  CG1 VAL D 141      14.347   1.578  15.158  1.00 55.52           C  
ATOM   8635  CG2 VAL D 141      12.117   0.548  14.811  1.00 54.31           C  
ATOM   8636  N   THR D 142      12.094  -0.705  18.244  1.00 60.07           N  
ATOM   8637  CA  THR D 142      10.992  -1.312  19.002  1.00 61.47           C  
ATOM   8638  C   THR D 142       9.987  -0.193  19.276  1.00 61.70           C  
ATOM   8639  O   THR D 142      10.346   0.962  19.160  1.00 61.94           O  
ATOM   8640  CB  THR D 142      11.514  -1.870  20.373  1.00 61.87           C  
ATOM   8641  OG1 THR D 142      12.195  -0.821  21.094  1.00 60.70           O  
ATOM   8642  CG2 THR D 142      12.486  -3.043  20.158  1.00 61.30           C  
ATOM   8643  N   LYS D 143       8.749  -0.525  19.634  1.00 61.37           N  
ATOM   8644  CA  LYS D 143       7.760   0.502  19.931  1.00 62.68           C  
ATOM   8645  C   LYS D 143       8.302   1.583  20.869  1.00 63.13           C  
ATOM   8646  O   LYS D 143       8.955   1.282  21.866  1.00 63.29           O  
ATOM   8647  CB  LYS D 143       6.528  -0.106  20.570  1.00 62.68           C  
ATOM   8648  CG  LYS D 143       5.929  -1.193  19.748  1.00 65.28           C  
ATOM   8649  CD  LYS D 143       5.466  -0.664  18.414  1.00 68.30           C  
ATOM   8650  CE  LYS D 143       4.038  -1.104  18.128  1.00 69.23           C  
ATOM   8651  NZ  LYS D 143       3.123  -0.623  19.209  1.00 70.22           N  
ATOM   8652  N   VAL D 144       8.017   2.849  20.560  1.00 63.31           N  
ATOM   8653  CA  VAL D 144       8.510   3.952  21.373  1.00 62.92           C  
ATOM   8654  C   VAL D 144       7.408   4.756  22.022  1.00 63.67           C  
ATOM   8655  O   VAL D 144       6.212   4.649  21.673  1.00 62.32           O  
ATOM   8656  CB  VAL D 144       9.325   4.967  20.532  1.00 62.46           C  
ATOM   8657  CG1 VAL D 144      10.705   4.463  20.264  1.00 62.42           C  
ATOM   8658  CG2 VAL D 144       8.599   5.253  19.231  1.00 61.17           C  
ATOM   8659  N   ASP D 145       7.847   5.577  22.965  1.00 63.78           N  
ATOM   8660  CA  ASP D 145       6.970   6.510  23.664  1.00 65.50           C  
ATOM   8661  C   ASP D 145       6.769   7.757  22.789  1.00 64.52           C  
ATOM   8662  O   ASP D 145       5.661   8.182  22.543  1.00 64.76           O  
ATOM   8663  CB  ASP D 145       7.601   6.977  24.985  1.00 66.93           C  
ATOM   8664  CG  ASP D 145       7.898   5.843  25.931  1.00 68.32           C  
ATOM   8665  OD1 ASP D 145       7.064   4.913  26.019  1.00 69.11           O  
ATOM   8666  OD2 ASP D 145       8.961   5.889  26.596  1.00 69.86           O  
ATOM   8667  N   VAL D 146       7.865   8.325  22.317  1.00 64.23           N  
ATOM   8668  CA  VAL D 146       7.792   9.525  21.522  1.00 63.03           C  
ATOM   8669  C   VAL D 146       8.453   9.344  20.166  1.00 62.47           C  
ATOM   8670  O   VAL D 146       9.474   8.648  20.070  1.00 63.31           O  
ATOM   8671  CB  VAL D 146       8.519  10.670  22.260  1.00 62.60           C  
ATOM   8672  CG1 VAL D 146       8.335  11.999  21.538  1.00 63.55           C  
ATOM   8673  CG2 VAL D 146       8.018  10.749  23.687  1.00 62.35           C  
ATOM   8674  N   ILE D 147       7.863   9.938  19.118  1.00 61.05           N  
ATOM   8675  CA  ILE D 147       8.462   9.948  17.768  1.00 58.11           C  
ATOM   8676  C   ILE D 147       8.833  11.423  17.558  1.00 57.99           C  
ATOM   8677  O   ILE D 147       7.974  12.273  17.699  1.00 58.86           O  
ATOM   8678  CB  ILE D 147       7.478   9.588  16.634  1.00 55.65           C  
ATOM   8679  CG1 ILE D 147       7.059   8.128  16.706  1.00 54.77           C  
ATOM   8680  CG2 ILE D 147       8.130   9.925  15.281  1.00 54.80           C  
ATOM   8681  CD1 ILE D 147       6.375   7.599  15.429  1.00 51.67           C  
ATOM   8682  N   PHE D 148      10.090  11.745  17.271  1.00 56.94           N  
ATOM   8683  CA  PHE D 148      10.434  13.146  17.003  1.00 55.14           C  
ATOM   8684  C   PHE D 148      10.853  13.196  15.549  1.00 54.62           C  
ATOM   8685  O   PHE D 148      11.766  12.480  15.139  1.00 54.02           O  
ATOM   8686  CB  PHE D 148      11.582  13.635  17.847  1.00 55.35           C  
ATOM   8687  CG  PHE D 148      11.968  15.043  17.557  1.00 56.88           C  
ATOM   8688  CD1 PHE D 148      11.198  16.093  18.033  1.00 57.64           C  
ATOM   8689  CD2 PHE D 148      13.066  15.329  16.766  1.00 56.30           C  
ATOM   8690  CE1 PHE D 148      11.532  17.412  17.738  1.00 57.73           C  
ATOM   8691  CE2 PHE D 148      13.404  16.653  16.467  1.00 57.37           C  
ATOM   8692  CZ  PHE D 148      12.631  17.692  16.942  1.00 57.40           C  
ATOM   8693  N   GLU D 149      10.204  14.050  14.772  1.00 54.35           N  
ATOM   8694  CA  GLU D 149      10.497  14.125  13.344  1.00 54.17           C  
ATOM   8695  C   GLU D 149      10.933  15.490  12.891  1.00 54.83           C  
ATOM   8696  O   GLU D 149      10.285  16.479  13.176  1.00 55.55           O  
ATOM   8697  CB  GLU D 149       9.271  13.738  12.551  1.00 52.31           C  
ATOM   8698  CG  GLU D 149       9.525  13.497  11.119  1.00 52.77           C  
ATOM   8699  CD  GLU D 149       8.237  13.387  10.337  1.00 54.38           C  
ATOM   8700  OE1 GLU D 149       7.316  12.684  10.803  1.00 53.38           O  
ATOM   8701  OE2 GLU D 149       8.144  14.000   9.242  1.00 55.69           O  
ATOM   8702  N   ASP D 150      12.036  15.542  12.178  1.00 55.07           N  
ATOM   8703  CA  ASP D 150      12.518  16.795  11.693  1.00 56.05           C  
ATOM   8704  C   ASP D 150      13.224  16.501  10.368  1.00 56.80           C  
ATOM   8705  O   ASP D 150      14.450  16.423  10.324  1.00 57.40           O  
ATOM   8706  CB  ASP D 150      13.459  17.395  12.723  1.00 57.47           C  
ATOM   8707  CG  ASP D 150      14.113  18.687  12.252  1.00 60.52           C  
ATOM   8708  OD1 ASP D 150      13.771  19.166  11.147  1.00 60.09           O  
ATOM   8709  OD2 ASP D 150      14.983  19.227  13.002  1.00 61.15           O  
ATOM   8710  N   VAL D 151      12.450  16.321   9.291  1.00 57.20           N  
ATOM   8711  CA  VAL D 151      13.013  16.007   7.966  1.00 58.37           C  
ATOM   8712  C   VAL D 151      12.653  16.958   6.813  1.00 60.64           C  
ATOM   8713  O   VAL D 151      11.561  17.534   6.763  1.00 61.68           O  
ATOM   8714  CB  VAL D 151      12.614  14.570   7.532  1.00 57.63           C  
ATOM   8715  CG1 VAL D 151      13.171  13.538   8.517  1.00 55.84           C  
ATOM   8716  CG2 VAL D 151      11.086  14.435   7.437  1.00 56.44           C  
ATOM   8717  N   ALA D 152      13.572  17.170   5.881  1.00 63.34           N  
ATOM   8718  CA  ALA D 152      13.218  18.034   4.733  1.00 65.20           C  
ATOM   8719  C   ALA D 152      12.489  17.103   3.776  1.00 65.42           C  
ATOM   8720  O   ALA D 152      13.102  16.439   2.912  1.00 64.80           O  
ATOM   8721  CB  ALA D 152      14.486  18.616   4.030  1.00 66.50           C  
ATOM   8722  N   GLN D 153      11.182  17.039   3.945  1.00 64.30           N  
ATOM   8723  CA  GLN D 153      10.407  16.171   3.094  1.00 64.60           C  
ATOM   8724  C   GLN D 153       9.000  16.686   2.959  1.00 63.20           C  
ATOM   8725  O   GLN D 153       8.351  17.026   3.962  1.00 62.19           O  
ATOM   8726  CB  GLN D 153      10.379  14.746   3.671  1.00 66.50           C  
ATOM   8727  CG  GLN D 153      11.717  14.025   3.675  1.00 68.92           C  
ATOM   8728  CD  GLN D 153      12.016  13.299   2.354  1.00 71.52           C  
ATOM   8729  OE1 GLN D 153      11.154  12.587   1.812  1.00 72.50           O  
ATOM   8730  NE2 GLN D 153      13.244  13.466   1.840  1.00 72.13           N  
ATOM   8731  N   PRO D 154       8.529  16.792   1.717  1.00 61.77           N  
ATOM   8732  CA  PRO D 154       7.186  17.265   1.436  1.00 62.12           C  
ATOM   8733  C   PRO D 154       6.146  16.381   2.112  1.00 62.96           C  
ATOM   8734  O   PRO D 154       5.158  16.865   2.687  1.00 63.02           O  
ATOM   8735  CB  PRO D 154       7.154  17.214  -0.070  1.00 61.02           C  
ATOM   8736  CG  PRO D 154       8.527  17.691  -0.388  1.00 60.74           C  
ATOM   8737  CD  PRO D 154       9.353  16.835   0.505  1.00 61.54           C  
ATOM   8738  N   THR D 155       6.414  15.082   2.063  1.00 63.82           N  
ATOM   8739  CA  THR D 155       5.571  14.043   2.643  1.00 64.87           C  
ATOM   8740  C   THR D 155       5.571  14.072   4.179  1.00 65.19           C  
ATOM   8741  O   THR D 155       4.834  13.331   4.841  1.00 66.26           O  
ATOM   8742  CB  THR D 155       6.063  12.706   2.135  1.00 66.13           C  
ATOM   8743  OG1 THR D 155       7.351  12.905   1.505  1.00 68.94           O  
ATOM   8744  CG2 THR D 155       5.092  12.158   1.123  1.00 65.88           C  
ATOM   8745  N   GLN D 156       6.416  14.936   4.731  1.00 64.67           N  
ATOM   8746  CA  GLN D 156       6.551  15.187   6.165  1.00 64.91           C  
ATOM   8747  C   GLN D 156       5.417  14.674   7.062  1.00 65.81           C  
ATOM   8748  O   GLN D 156       5.626  14.043   8.095  1.00 63.83           O  
ATOM   8749  CB  GLN D 156       6.620  16.691   6.340  1.00 65.15           C  
ATOM   8750  CG  GLN D 156       7.683  17.145   7.243  1.00 65.62           C  
ATOM   8751  CD  GLN D 156       7.849  18.627   7.190  1.00 64.64           C  
ATOM   8752  OE1 GLN D 156       7.952  19.207   6.112  1.00 63.17           O  
ATOM   8753  NE2 GLN D 156       7.891  19.254   8.354  1.00 65.46           N  
ATOM   8754  N   ALA D 157       4.202  15.023   6.653  1.00 67.68           N  
ATOM   8755  CA  ALA D 157       2.981  14.683   7.361  1.00 68.59           C  
ATOM   8756  C   ALA D 157       2.714  13.196   7.476  1.00 68.66           C  
ATOM   8757  O   ALA D 157       2.621  12.680   8.579  1.00 68.76           O  
ATOM   8758  CB  ALA D 157       1.818  15.361   6.689  1.00 70.21           C  
ATOM   8759  N   LYS D 158       2.556  12.510   6.349  1.00 69.00           N  
ATOM   8760  CA  LYS D 158       2.286  11.074   6.398  1.00 70.62           C  
ATOM   8761  C   LYS D 158       3.469  10.307   6.968  1.00 69.96           C  
ATOM   8762  O   LYS D 158       3.286   9.239   7.567  1.00 70.52           O  
ATOM   8763  CB  LYS D 158       1.919  10.507   5.015  1.00 72.80           C  
ATOM   8764  CG  LYS D 158       2.402  11.344   3.859  1.00 77.32           C  
ATOM   8765  CD  LYS D 158       1.635  11.035   2.567  1.00 80.31           C  
ATOM   8766  CE  LYS D 158       1.638  12.272   1.621  1.00 81.73           C  
ATOM   8767  NZ  LYS D 158       0.935  13.482   2.191  1.00 81.78           N  
ATOM   8768  N   ILE D 159       4.681  10.843   6.788  1.00 67.89           N  
ATOM   8769  CA  ILE D 159       5.874  10.187   7.323  1.00 63.88           C  
ATOM   8770  C   ILE D 159       5.678   9.980   8.825  1.00 63.99           C  
ATOM   8771  O   ILE D 159       5.969   8.908   9.347  1.00 64.37           O  
ATOM   8772  CB  ILE D 159       7.148  11.009   7.056  1.00 60.94           C  
ATOM   8773  CG1 ILE D 159       7.488  10.948   5.564  1.00 58.91           C  
ATOM   8774  CG2 ILE D 159       8.283  10.503   7.903  1.00 57.29           C  
ATOM   8775  CD1 ILE D 159       8.780  11.675   5.180  1.00 56.34           C  
ATOM   8776  N   LEU D 160       5.136  10.983   9.506  1.00 63.73           N  
ATOM   8777  CA  LEU D 160       4.891  10.883  10.936  1.00 63.89           C  
ATOM   8778  C   LEU D 160       3.789   9.895  11.250  1.00 64.56           C  
ATOM   8779  O   LEU D 160       3.779   9.282  12.310  1.00 64.76           O  
ATOM   8780  CB  LEU D 160       4.488  12.230  11.501  1.00 63.37           C  
ATOM   8781  CG  LEU D 160       4.288  12.153  13.008  1.00 62.72           C  
ATOM   8782  CD1 LEU D 160       5.643  12.074  13.727  1.00 61.68           C  
ATOM   8783  CD2 LEU D 160       3.527  13.378  13.453  1.00 63.47           C  
ATOM   8784  N   ILE D 161       2.853   9.746  10.326  1.00 65.41           N  
ATOM   8785  CA  ILE D 161       1.750   8.829  10.535  1.00 66.83           C  
ATOM   8786  C   ILE D 161       2.175   7.396  10.281  1.00 67.37           C  
ATOM   8787  O   ILE D 161       1.843   6.508  11.059  1.00 67.38           O  
ATOM   8788  CB  ILE D 161       0.579   9.152   9.608  1.00 67.59           C  
ATOM   8789  CG1 ILE D 161      -0.011  10.509   9.987  1.00 67.36           C  
ATOM   8790  CG2 ILE D 161      -0.457   8.030   9.675  1.00 66.42           C  
ATOM   8791  CD1 ILE D 161      -0.837  11.098   8.896  1.00 67.43           C  
ATOM   8792  N   ASP D 162       2.889   7.186   9.181  1.00 67.96           N  
ATOM   8793  CA  ASP D 162       3.375   5.872   8.816  1.00 69.48           C  
ATOM   8794  C   ASP D 162       4.238   5.330   9.943  1.00 68.66           C  
ATOM   8795  O   ASP D 162       4.013   4.232  10.444  1.00 67.89           O  
ATOM   8796  CB  ASP D 162       4.213   5.963   7.547  1.00 73.49           C  
ATOM   8797  CG  ASP D 162       3.379   6.284   6.313  1.00 77.79           C  
ATOM   8798  OD1 ASP D 162       3.985   6.527   5.233  1.00 78.80           O  
ATOM   8799  OD2 ASP D 162       2.122   6.279   6.436  1.00 79.87           O  
ATOM   8800  N   ASN D 163       5.235   6.121  10.321  1.00 68.30           N  
ATOM   8801  CA  ASN D 163       6.133   5.754  11.393  1.00 68.00           C  
ATOM   8802  C   ASN D 163       5.390   5.624  12.728  1.00 68.30           C  
ATOM   8803  O   ASN D 163       5.849   4.927  13.628  1.00 69.17           O  
ATOM   8804  CB  ASN D 163       7.258   6.786  11.527  1.00 66.93           C  
ATOM   8805  CG  ASN D 163       8.421   6.503  10.611  1.00 66.63           C  
ATOM   8806  OD1 ASN D 163       9.022   5.445  10.682  1.00 66.97           O  
ATOM   8807  ND2 ASN D 163       8.760   7.456   9.755  1.00 67.60           N  
ATOM   8808  N   ALA D 164       4.252   6.292  12.875  1.00 67.74           N  
ATOM   8809  CA  ALA D 164       3.522   6.206  14.127  1.00 67.15           C  
ATOM   8810  C   ALA D 164       2.655   4.961  14.187  1.00 67.61           C  
ATOM   8811  O   ALA D 164       2.507   4.354  15.249  1.00 67.53           O  
ATOM   8812  CB  ALA D 164       2.675   7.410  14.314  1.00 67.12           C  
ATOM   8813  N   LYS D 165       2.070   4.587  13.056  1.00 67.95           N  
ATOM   8814  CA  LYS D 165       1.225   3.414  13.023  1.00 68.75           C  
ATOM   8815  C   LYS D 165       2.076   2.184  12.822  1.00 68.62           C  
ATOM   8816  O   LYS D 165       1.620   1.189  12.285  1.00 71.08           O  
ATOM   8817  CB  LYS D 165       0.146   3.518  11.925  1.00 69.20           C  
ATOM   8818  CG  LYS D 165       0.645   4.075  10.607  1.00 71.79           C  
ATOM   8819  CD  LYS D 165      -0.419   4.057   9.485  1.00 72.35           C  
ATOM   8820  CE  LYS D 165      -1.746   4.732   9.851  1.00 72.24           C  
ATOM   8821  NZ  LYS D 165      -2.605   4.864   8.615  1.00 73.14           N  
ATOM   8822  N   ALA D 166       3.323   2.246  13.254  1.00 67.81           N  
ATOM   8823  CA  ALA D 166       4.197   1.102  13.125  1.00 66.06           C  
ATOM   8824  C   ALA D 166       5.168   1.021  14.281  1.00 65.78           C  
ATOM   8825  O   ALA D 166       5.699  -0.039  14.534  1.00 67.15           O  
ATOM   8826  CB  ALA D 166       4.957   1.163  11.828  1.00 65.26           C  
ATOM   8827  N   TYR D 167       5.372   2.111  15.012  1.00 65.28           N  
ATOM   8828  CA  TYR D 167       6.347   2.106  16.100  1.00 65.46           C  
ATOM   8829  C   TYR D 167       5.929   2.909  17.331  1.00 65.56           C  
ATOM   8830  O   TYR D 167       6.568   2.836  18.380  1.00 64.61           O  
ATOM   8831  CB  TYR D 167       7.700   2.656  15.576  1.00 64.44           C  
ATOM   8832  CG  TYR D 167       8.271   1.947  14.347  1.00 63.77           C  
ATOM   8833  CD1 TYR D 167       8.509   0.567  14.358  1.00 64.07           C  
ATOM   8834  CD2 TYR D 167       8.588   2.652  13.181  1.00 63.10           C  
ATOM   8835  CE1 TYR D 167       9.051  -0.107  13.238  1.00 63.79           C  
ATOM   8836  CE2 TYR D 167       9.136   1.986  12.049  1.00 63.40           C  
ATOM   8837  CZ  TYR D 167       9.362   0.598  12.086  1.00 62.80           C  
ATOM   8838  OH  TYR D 167       9.882  -0.071  10.988  1.00 59.25           O  
ATOM   8839  N   LEU D 168       4.869   3.697  17.217  1.00 66.58           N  
ATOM   8840  CA  LEU D 168       4.464   4.504  18.357  1.00 67.74           C  
ATOM   8841  C   LEU D 168       3.516   3.738  19.236  1.00 69.75           C  
ATOM   8842  O   LEU D 168       2.561   3.109  18.760  1.00 70.04           O  
ATOM   8843  CB  LEU D 168       3.807   5.819  17.901  1.00 65.35           C  
ATOM   8844  CG  LEU D 168       3.548   6.891  18.971  1.00 65.62           C  
ATOM   8845  CD1 LEU D 168       4.832   7.272  19.735  1.00 63.79           C  
ATOM   8846  CD2 LEU D 168       2.971   8.118  18.298  1.00 65.23           C  
ATOM   8847  N   LYS D 169       3.806   3.771  20.526  1.00 71.66           N  
ATOM   8848  CA  LYS D 169       2.954   3.123  21.511  1.00 74.28           C  
ATOM   8849  C   LYS D 169       1.626   3.868  21.550  1.00 76.22           C  
ATOM   8850  O   LYS D 169       1.600   5.098  21.445  1.00 76.59           O  
ATOM   8851  CB  LYS D 169       3.593   3.210  22.890  1.00 73.91           C  
ATOM   8852  CG  LYS D 169       4.760   2.282  23.098  1.00 74.74           C  
ATOM   8853  CD  LYS D 169       5.655   2.830  24.196  1.00 74.43           C  
ATOM   8854  CE  LYS D 169       6.436   1.727  24.856  1.00 73.93           C  
ATOM   8855  NZ  LYS D 169       7.549   2.273  25.673  1.00 74.72           N  
ATOM   8856  N   ARG D 170       0.517   3.138  21.706  1.00 78.24           N  
ATOM   8857  CA  ARG D 170      -0.787   3.791  21.774  1.00 78.51           C  
ATOM   8858  C   ARG D 170      -0.773   4.745  22.937  1.00 78.39           C  
ATOM   8859  O   ARG D 170      -0.166   4.477  23.987  1.00 77.10           O  
ATOM   8860  CB  ARG D 170      -1.896   2.780  21.960  1.00 80.16           C  
ATOM   8861  CG  ARG D 170      -2.060   1.843  20.782  1.00 84.17           C  
ATOM   8862  CD  ARG D 170      -3.452   1.267  20.782  1.00 86.98           C  
ATOM   8863  NE  ARG D 170      -4.428   2.356  20.864  1.00 90.85           N  
ATOM   8864  CZ  ARG D 170      -5.586   2.290  21.523  1.00 91.91           C  
ATOM   8865  NH1 ARG D 170      -5.929   1.182  22.174  1.00 92.52           N  
ATOM   8866  NH2 ARG D 170      -6.403   3.336  21.532  1.00 92.06           N  
ATOM   8867  N   GLY D 171      -1.440   5.872  22.740  1.00 78.55           N  
ATOM   8868  CA  GLY D 171      -1.471   6.874  23.782  1.00 79.76           C  
ATOM   8869  C   GLY D 171      -0.082   7.465  23.905  1.00 80.36           C  
ATOM   8870  O   GLY D 171       0.316   7.974  24.957  1.00 80.50           O  
ATOM   8871  N   GLY D 172       0.672   7.386  22.813  1.00 80.50           N  
ATOM   8872  CA  GLY D 172       2.021   7.926  22.805  1.00 78.82           C  
ATOM   8873  C   GLY D 172       2.039   9.255  22.075  1.00 77.50           C  
ATOM   8874  O   GLY D 172       1.170   9.543  21.254  1.00 78.02           O  
ATOM   8875  N   TYR D 173       3.056  10.049  22.362  1.00 76.09           N  
ATOM   8876  CA  TYR D 173       3.204  11.359  21.773  1.00 74.57           C  
ATOM   8877  C   TYR D 173       4.074  11.397  20.517  1.00 72.87           C  
ATOM   8878  O   TYR D 173       4.934  10.529  20.287  1.00 72.88           O  
ATOM   8879  CB  TYR D 173       3.772  12.291  22.830  1.00 76.22           C  
ATOM   8880  CG  TYR D 173       2.828  12.583  23.969  1.00 78.13           C  
ATOM   8881  CD1 TYR D 173       2.191  13.818  24.056  1.00 79.72           C  
ATOM   8882  CD2 TYR D 173       2.580  11.641  24.965  1.00 79.41           C  
ATOM   8883  CE1 TYR D 173       1.328  14.127  25.113  1.00 80.53           C  
ATOM   8884  CE2 TYR D 173       1.711  11.932  26.033  1.00 80.90           C  
ATOM   8885  CZ  TYR D 173       1.093  13.182  26.100  1.00 81.44           C  
ATOM   8886  OH  TYR D 173       0.266  13.503  27.157  1.00 82.30           O  
ATOM   8887  N   GLY D 174       3.836  12.421  19.697  1.00 70.62           N  
ATOM   8888  CA  GLY D 174       4.587  12.609  18.463  1.00 65.73           C  
ATOM   8889  C   GLY D 174       4.927  14.076  18.322  1.00 62.37           C  
ATOM   8890  O   GLY D 174       4.055  14.900  18.447  1.00 61.28           O  
ATOM   8891  N   MET D 175       6.187  14.419  18.108  1.00 60.78           N  
ATOM   8892  CA  MET D 175       6.570  15.822  17.931  1.00 59.21           C  
ATOM   8893  C   MET D 175       7.188  16.038  16.527  1.00 59.69           C  
ATOM   8894  O   MET D 175       8.222  15.436  16.182  1.00 60.27           O  
ATOM   8895  CB  MET D 175       7.587  16.256  18.992  1.00 54.96           C  
ATOM   8896  CG  MET D 175       7.112  16.219  20.401  1.00 52.31           C  
ATOM   8897  SD  MET D 175       8.467  16.304  21.569  1.00 51.08           S  
ATOM   8898  CE  MET D 175       8.982  17.970  21.333  1.00 51.20           C  
ATOM   8899  N   ILE D 176       6.564  16.888  15.713  1.00 58.68           N  
ATOM   8900  CA  ILE D 176       7.118  17.172  14.388  1.00 56.79           C  
ATOM   8901  C   ILE D 176       7.378  18.666  14.153  1.00 55.79           C  
ATOM   8902  O   ILE D 176       6.527  19.500  14.410  1.00 55.66           O  
ATOM   8903  CB  ILE D 176       6.206  16.629  13.268  1.00 55.78           C  
ATOM   8904  CG1 ILE D 176       6.699  17.114  11.911  1.00 54.40           C  
ATOM   8905  CG2 ILE D 176       4.772  17.064  13.493  1.00 55.92           C  
ATOM   8906  CD1 ILE D 176       5.929  16.560  10.776  1.00 50.85           C  
ATOM   8907  N   ALA D 177       8.575  18.991  13.687  1.00 55.27           N  
ATOM   8908  CA  ALA D 177       8.941  20.374  13.364  1.00 54.82           C  
ATOM   8909  C   ALA D 177       8.633  20.515  11.872  1.00 54.59           C  
ATOM   8910  O   ALA D 177       9.353  19.959  11.039  1.00 54.17           O  
ATOM   8911  CB  ALA D 177      10.438  20.616  13.620  1.00 52.91           C  
ATOM   8912  N   VAL D 178       7.564  21.237  11.539  1.00 54.78           N  
ATOM   8913  CA  VAL D 178       7.157  21.408  10.147  1.00 54.78           C  
ATOM   8914  C   VAL D 178       7.655  22.654   9.453  1.00 55.58           C  
ATOM   8915  O   VAL D 178       7.487  23.764   9.947  1.00 55.56           O  
ATOM   8916  CB  VAL D 178       5.643  21.449  10.002  1.00 53.86           C  
ATOM   8917  CG1 VAL D 178       5.290  21.522   8.537  1.00 52.63           C  
ATOM   8918  CG2 VAL D 178       5.029  20.258  10.664  1.00 54.01           C  
ATOM   8919  N   LYS D 179       8.257  22.472   8.295  1.00 57.47           N  
ATOM   8920  CA  LYS D 179       8.734  23.615   7.536  1.00 60.78           C  
ATOM   8921  C   LYS D 179       7.736  23.829   6.412  1.00 62.63           C  
ATOM   8922  O   LYS D 179       7.597  22.988   5.518  1.00 63.96           O  
ATOM   8923  CB  LYS D 179      10.107  23.344   6.954  1.00 60.52           C  
ATOM   8924  CG  LYS D 179      10.667  24.520   6.225  1.00 61.53           C  
ATOM   8925  CD  LYS D 179      12.002  24.195   5.578  1.00 62.66           C  
ATOM   8926  CE  LYS D 179      12.741  25.492   5.184  1.00 64.26           C  
ATOM   8927  NZ  LYS D 179      13.823  25.331   4.149  1.00 64.52           N  
ATOM   8928  N   SER D 180       7.041  24.952   6.466  1.00 63.45           N  
ATOM   8929  CA  SER D 180       6.015  25.274   5.495  1.00 64.99           C  
ATOM   8930  C   SER D 180       6.457  25.167   4.021  1.00 67.12           C  
ATOM   8931  O   SER D 180       5.800  24.495   3.192  1.00 65.04           O  
ATOM   8932  CB  SER D 180       5.483  26.680   5.793  1.00 64.59           C  
ATOM   8933  OG  SER D 180       4.567  27.088   4.794  1.00 64.90           O  
ATOM   8934  N   ARG D 181       7.582  25.810   3.703  1.00 69.36           N  
ATOM   8935  CA  ARG D 181       8.078  25.815   2.337  1.00 72.61           C  
ATOM   8936  C   ARG D 181       8.689  24.510   1.830  1.00 73.40           C  
ATOM   8937  O   ARG D 181       9.172  24.449   0.697  1.00 73.75           O  
ATOM   8938  CB  ARG D 181       9.051  26.987   2.121  1.00 74.72           C  
ATOM   8939  CG  ARG D 181      10.042  27.206   3.215  1.00 79.92           C  
ATOM   8940  CD  ARG D 181       9.398  27.638   4.553  1.00 84.71           C  
ATOM   8941  NE  ARG D 181      10.441  27.677   5.576  1.00 89.23           N  
ATOM   8942  CZ  ARG D 181      11.373  28.628   5.673  1.00 91.31           C  
ATOM   8943  NH1 ARG D 181      12.306  28.552   6.631  1.00 91.97           N  
ATOM   8944  NH2 ARG D 181      11.343  29.677   4.846  1.00 92.46           N  
ATOM   8945  N   SER D 182       8.640  23.465   2.656  1.00 74.99           N  
ATOM   8946  CA  SER D 182       9.168  22.130   2.328  1.00 75.02           C  
ATOM   8947  C   SER D 182       7.970  21.357   1.777  1.00 75.10           C  
ATOM   8948  O   SER D 182       8.076  20.557   0.848  1.00 73.78           O  
ATOM   8949  CB  SER D 182       9.720  21.467   3.615  1.00 75.52           C  
ATOM   8950  OG  SER D 182      10.244  20.147   3.419  1.00 74.61           O  
ATOM   8951  N   ILE D 183       6.819  21.646   2.363  1.00 76.09           N  
ATOM   8952  CA  ILE D 183       5.570  21.028   1.971  1.00 77.91           C  
ATOM   8953  C   ILE D 183       5.054  21.637   0.653  1.00 79.41           C  
ATOM   8954  O   ILE D 183       4.762  20.914  -0.308  1.00 79.26           O  
ATOM   8955  CB  ILE D 183       4.540  21.215   3.107  1.00 77.24           C  
ATOM   8956  CG1 ILE D 183       5.051  20.500   4.369  1.00 75.53           C  
ATOM   8957  CG2 ILE D 183       3.176  20.718   2.666  1.00 75.94           C  
ATOM   8958  CD1 ILE D 183       4.253  20.739   5.600  1.00 73.49           C  
ATOM   8959  N   ASP D 184       4.961  22.969   0.618  1.00 81.38           N  
ATOM   8960  CA  ASP D 184       4.500  23.706  -0.571  1.00 82.56           C  
ATOM   8961  C   ASP D 184       5.177  25.077  -0.674  1.00 81.81           C  
ATOM   8962  O   ASP D 184       4.805  26.024   0.028  1.00 80.80           O  
ATOM   8963  CB  ASP D 184       2.986  23.910  -0.523  1.00 85.22           C  
ATOM   8964  CG  ASP D 184       2.367  24.019  -1.911  1.00 87.61           C  
ATOM   8965  OD1 ASP D 184       2.953  24.712  -2.789  1.00 88.48           O  
ATOM   8966  OD2 ASP D 184       1.288  23.411  -2.116  1.00 88.65           O  
ATOM   8967  N   VAL D 185       6.152  25.173  -1.575  1.00 81.73           N  
ATOM   8968  CA  VAL D 185       6.927  26.389  -1.763  1.00 82.28           C  
ATOM   8969  C   VAL D 185       6.075  27.577  -2.224  1.00 84.01           C  
ATOM   8970  O   VAL D 185       6.429  28.737  -1.974  1.00 84.29           O  
ATOM   8971  CB  VAL D 185       8.148  26.128  -2.741  1.00 81.18           C  
ATOM   8972  CG1 VAL D 185       7.663  25.905  -4.165  1.00 80.17           C  
ATOM   8973  CG2 VAL D 185       9.144  27.262  -2.656  1.00 79.54           C  
ATOM   8974  N   THR D 186       4.936  27.306  -2.867  1.00 85.60           N  
ATOM   8975  CA  THR D 186       4.041  28.377  -3.367  1.00 85.24           C  
ATOM   8976  C   THR D 186       3.008  28.826  -2.318  1.00 85.13           C  
ATOM   8977  O   THR D 186       2.891  30.017  -2.046  1.00 85.97           O  
ATOM   8978  CB  THR D 186       3.289  27.934  -4.697  1.00 85.29           C  
ATOM   8979  OG1 THR D 186       2.126  27.145  -4.396  1.00 85.58           O  
ATOM   8980  CG2 THR D 186       4.218  27.103  -5.593  1.00 84.61           C  
ATOM   8981  N   LYS D 187       2.298  27.866  -1.714  1.00 84.12           N  
ATOM   8982  CA  LYS D 187       1.261  28.153  -0.718  1.00 82.72           C  
ATOM   8983  C   LYS D 187       1.699  29.035   0.446  1.00 82.03           C  
ATOM   8984  O   LYS D 187       2.885  29.234   0.704  1.00 81.18           O  
ATOM   8985  CB  LYS D 187       0.674  26.850  -0.192  1.00 82.37           C  
ATOM   8986  CG  LYS D 187      -0.675  26.994   0.477  1.00 83.01           C  
ATOM   8987  CD  LYS D 187      -1.281  25.626   0.802  1.00 84.44           C  
ATOM   8988  CE  LYS D 187      -1.837  24.930  -0.438  1.00 84.89           C  
ATOM   8989  NZ  LYS D 187      -0.935  25.030  -1.631  1.00 85.47           N  
ATOM   8990  N   GLU D 188       0.718  29.556   1.158  1.00 82.00           N  
ATOM   8991  CA  GLU D 188       0.989  30.444   2.263  1.00 82.38           C  
ATOM   8992  C   GLU D 188       1.278  29.670   3.535  1.00 80.77           C  
ATOM   8993  O   GLU D 188       0.623  28.676   3.822  1.00 79.79           O  
ATOM   8994  CB  GLU D 188      -0.216  31.388   2.460  1.00 85.79           C  
ATOM   8995  CG  GLU D 188      -0.036  32.455   3.554  1.00 90.33           C  
ATOM   8996  CD  GLU D 188       0.937  33.578   3.157  1.00 92.94           C  
ATOM   8997  OE1 GLU D 188       1.417  34.304   4.071  1.00 93.88           O  
ATOM   8998  OE2 GLU D 188       1.214  33.737   1.935  1.00 94.10           O  
ATOM   8999  N   PRO D 189       2.279  30.108   4.311  1.00 79.89           N  
ATOM   9000  CA  PRO D 189       2.602  29.411   5.546  1.00 80.03           C  
ATOM   9001  C   PRO D 189       1.379  29.105   6.388  1.00 81.10           C  
ATOM   9002  O   PRO D 189       1.164  27.960   6.791  1.00 80.97           O  
ATOM   9003  CB  PRO D 189       3.571  30.359   6.228  1.00 78.71           C  
ATOM   9004  CG  PRO D 189       4.351  30.855   5.077  1.00 78.24           C  
ATOM   9005  CD  PRO D 189       3.261  31.172   4.062  1.00 79.78           C  
ATOM   9006  N   GLU D 190       0.553  30.110   6.645  1.00 82.54           N  
ATOM   9007  CA  GLU D 190      -0.627  29.866   7.460  1.00 83.53           C  
ATOM   9008  C   GLU D 190      -1.594  28.905   6.783  1.00 82.79           C  
ATOM   9009  O   GLU D 190      -2.361  28.203   7.432  1.00 81.65           O  
ATOM   9010  CB  GLU D 190      -1.328  31.183   7.776  1.00 86.05           C  
ATOM   9011  CG  GLU D 190      -2.361  31.019   8.865  1.00 90.52           C  
ATOM   9012  CD  GLU D 190      -1.988  29.890   9.837  1.00 92.95           C  
ATOM   9013  OE1 GLU D 190      -0.870  29.932  10.395  1.00 93.85           O  
ATOM   9014  OE2 GLU D 190      -2.811  28.957  10.037  1.00 94.69           O  
ATOM   9015  N   GLN D 191      -1.552  28.885   5.465  1.00 83.35           N  
ATOM   9016  CA  GLN D 191      -2.410  28.009   4.695  1.00 84.34           C  
ATOM   9017  C   GLN D 191      -1.899  26.574   4.880  1.00 84.06           C  
ATOM   9018  O   GLN D 191      -2.682  25.653   5.102  1.00 84.44           O  
ATOM   9019  CB  GLN D 191      -2.333  28.411   3.218  1.00 86.53           C  
ATOM   9020  CG  GLN D 191      -3.667  28.639   2.527  1.00 88.49           C  
ATOM   9021  CD  GLN D 191      -4.563  27.410   2.575  1.00 89.75           C  
ATOM   9022  OE1 GLN D 191      -5.125  27.067   3.630  1.00 90.12           O  
ATOM   9023  NE2 GLN D 191      -4.694  26.732   1.431  1.00 89.82           N  
ATOM   9024  N   VAL D 192      -0.575  26.403   4.793  1.00 82.66           N  
ATOM   9025  CA  VAL D 192       0.056  25.092   4.930  1.00 80.68           C  
ATOM   9026  C   VAL D 192      -0.177  24.496   6.312  1.00 80.18           C  
ATOM   9027  O   VAL D 192      -0.732  23.412   6.421  1.00 80.29           O  
ATOM   9028  CB  VAL D 192       1.568  25.159   4.659  1.00 80.01           C  
ATOM   9029  CG1 VAL D 192       2.158  23.778   4.744  1.00 79.94           C  
ATOM   9030  CG2 VAL D 192       1.838  25.743   3.289  1.00 78.53           C  
ATOM   9031  N   PHE D 193       0.233  25.195   7.360  1.00 79.57           N  
ATOM   9032  CA  PHE D 193       0.040  24.698   8.717  1.00 79.94           C  
ATOM   9033  C   PHE D 193      -1.397  24.304   8.974  1.00 82.03           C  
ATOM   9034  O   PHE D 193      -1.666  23.430   9.790  1.00 82.24           O  
ATOM   9035  CB  PHE D 193       0.409  25.752   9.749  1.00 77.55           C  
ATOM   9036  CG  PHE D 193       1.849  26.132   9.737  1.00 75.61           C  
ATOM   9037  CD1 PHE D 193       2.225  27.446   9.971  1.00 74.13           C  
ATOM   9038  CD2 PHE D 193       2.831  25.187   9.483  1.00 74.75           C  
ATOM   9039  CE1 PHE D 193       3.549  27.822   9.926  1.00 73.06           C  
ATOM   9040  CE2 PHE D 193       4.158  25.555   9.439  1.00 73.67           C  
ATOM   9041  CZ  PHE D 193       4.521  26.880   9.667  1.00 73.12           C  
ATOM   9042  N   LYS D 194      -2.329  24.957   8.294  1.00 84.49           N  
ATOM   9043  CA  LYS D 194      -3.739  24.659   8.503  1.00 86.69           C  
ATOM   9044  C   LYS D 194      -4.079  23.259   7.970  1.00 87.17           C  
ATOM   9045  O   LYS D 194      -4.787  22.500   8.629  1.00 86.64           O  
ATOM   9046  CB  LYS D 194      -4.602  25.737   7.820  1.00 88.90           C  
ATOM   9047  CG  LYS D 194      -6.077  25.822   8.297  1.00 91.06           C  
ATOM   9048  CD  LYS D 194      -6.938  26.767   7.400  1.00 92.85           C  
ATOM   9049  CE  LYS D 194      -7.069  26.246   5.930  1.00 93.32           C  
ATOM   9050  NZ  LYS D 194      -7.857  27.126   4.992  1.00 92.49           N  
ATOM   9051  N   GLU D 195      -3.542  22.919   6.800  1.00 88.17           N  
ATOM   9052  CA  GLU D 195      -3.786  21.629   6.154  1.00 90.04           C  
ATOM   9053  C   GLU D 195      -3.007  20.468   6.779  1.00 89.89           C  
ATOM   9054  O   GLU D 195      -3.409  19.300   6.676  1.00 89.59           O  
ATOM   9055  CB  GLU D 195      -3.446  21.738   4.671  1.00 91.93           C  
ATOM   9056  CG  GLU D 195      -3.450  23.168   4.211  1.00 95.38           C  
ATOM   9057  CD  GLU D 195      -3.860  23.337   2.772  1.00 98.10           C  
ATOM   9058  OE1 GLU D 195      -3.013  23.123   1.869  1.00 99.66           O  
ATOM   9059  OE2 GLU D 195      -5.042  23.680   2.539  1.00 99.86           O  
ATOM   9060  N   VAL D 196      -1.881  20.794   7.407  1.00 90.03           N  
ATOM   9061  CA  VAL D 196      -1.064  19.787   8.069  1.00 89.74           C  
ATOM   9062  C   VAL D 196      -1.841  19.383   9.311  1.00 90.62           C  
ATOM   9063  O   VAL D 196      -2.084  18.203   9.512  1.00 91.87           O  
ATOM   9064  CB  VAL D 196       0.347  20.331   8.487  1.00 88.69           C  
ATOM   9065  CG1 VAL D 196       0.965  19.451   9.552  1.00 86.75           C  
ATOM   9066  CG2 VAL D 196       1.271  20.386   7.289  1.00 86.75           C  
ATOM   9067  N   GLU D 197      -2.248  20.351  10.130  1.00 91.02           N  
ATOM   9068  CA  GLU D 197      -3.000  20.053  11.351  1.00 92.34           C  
ATOM   9069  C   GLU D 197      -4.288  19.298  11.086  1.00 92.71           C  
ATOM   9070  O   GLU D 197      -4.865  18.700  11.985  1.00 92.39           O  
ATOM   9071  CB  GLU D 197      -3.350  21.331  12.101  1.00 93.30           C  
ATOM   9072  CG  GLU D 197      -4.091  21.074  13.405  1.00 95.14           C  
ATOM   9073  CD  GLU D 197      -4.048  22.283  14.325  1.00 97.13           C  
ATOM   9074  OE1 GLU D 197      -4.431  22.150  15.526  1.00 97.60           O  
ATOM   9075  OE2 GLU D 197      -3.625  23.370  13.838  1.00 97.32           O  
ATOM   9076  N   ARG D 198      -4.741  19.346   9.842  1.00 93.88           N  
ATOM   9077  CA  ARG D 198      -5.960  18.664   9.452  1.00 94.43           C  
ATOM   9078  C   ARG D 198      -5.584  17.213   9.120  1.00 93.73           C  
ATOM   9079  O   ARG D 198      -6.175  16.278   9.661  1.00 93.53           O  
ATOM   9080  CB  ARG D 198      -6.585  19.381   8.237  1.00 96.10           C  
ATOM   9081  CG  ARG D 198      -8.037  18.992   7.922  1.00 98.70           C  
ATOM   9082  CD  ARG D 198      -8.178  18.251   6.585  1.00101.71           C  
ATOM   9083  NE  ARG D 198      -7.121  17.257   6.371  1.00104.94           N  
ATOM   9084  CZ  ARG D 198      -7.131  16.310   5.426  1.00105.93           C  
ATOM   9085  NH1 ARG D 198      -8.154  16.203   4.589  1.00106.89           N  
ATOM   9086  NH2 ARG D 198      -6.103  15.472   5.308  1.00106.06           N  
ATOM   9087  N   GLU D 199      -4.580  17.050   8.252  1.00 92.66           N  
ATOM   9088  CA  GLU D 199      -4.084  15.737   7.826  1.00 91.62           C  
ATOM   9089  C   GLU D 199      -3.551  14.965   9.015  1.00 90.72           C  
ATOM   9090  O   GLU D 199      -3.576  13.740   9.056  1.00 89.94           O  
ATOM   9091  CB  GLU D 199      -2.973  15.914   6.804  1.00 91.65           C  
ATOM   9092  CG  GLU D 199      -2.356  14.636   6.297  1.00 92.97           C  
ATOM   9093  CD  GLU D 199      -1.249  14.925   5.299  1.00 95.03           C  
ATOM   9094  OE1 GLU D 199      -0.908  16.124   5.150  1.00 96.24           O  
ATOM   9095  OE2 GLU D 199      -0.711  13.979   4.660  1.00 96.16           O  
ATOM   9096  N   LEU D 200      -3.067  15.712   9.987  1.00 90.26           N  
ATOM   9097  CA  LEU D 200      -2.528  15.137  11.187  1.00 90.92           C  
ATOM   9098  C   LEU D 200      -3.645  14.765  12.154  1.00 92.13           C  
ATOM   9099  O   LEU D 200      -3.498  13.823  12.922  1.00 92.64           O  
ATOM   9100  CB  LEU D 200      -1.569  16.131  11.845  1.00 90.50           C  
ATOM   9101  CG  LEU D 200      -0.104  15.742  12.062  1.00 89.81           C  
ATOM   9102  CD1 LEU D 200       0.540  15.267  10.760  1.00 89.39           C  
ATOM   9103  CD2 LEU D 200       0.631  16.938  12.634  1.00 89.55           C  
ATOM   9104  N   SER D 201      -4.768  15.486  12.126  1.00 93.85           N  
ATOM   9105  CA  SER D 201      -5.878  15.191  13.050  1.00 94.85           C  
ATOM   9106  C   SER D 201      -6.676  13.956  12.665  1.00 95.17           C  
ATOM   9107  O   SER D 201      -7.423  13.395  13.479  1.00 95.09           O  
ATOM   9108  CB  SER D 201      -6.814  16.394  13.156  1.00 95.74           C  
ATOM   9109  OG  SER D 201      -6.479  17.180  14.295  1.00 97.26           O  
ATOM   9110  N   GLU D 202      -6.495  13.537  11.419  1.00 95.44           N  
ATOM   9111  CA  GLU D 202      -7.154  12.365  10.875  1.00 95.60           C  
ATOM   9112  C   GLU D 202      -6.738  11.084  11.593  1.00 94.23           C  
ATOM   9113  O   GLU D 202      -7.452  10.085  11.548  1.00 94.22           O  
ATOM   9114  CB  GLU D 202      -6.799  12.257   9.411  1.00 98.05           C  
ATOM   9115  CG  GLU D 202      -7.409  11.071   8.733  1.00102.43           C  
ATOM   9116  CD  GLU D 202      -7.935  11.442   7.367  1.00105.07           C  
ATOM   9117  OE1 GLU D 202      -8.199  10.511   6.567  1.00106.00           O  
ATOM   9118  OE2 GLU D 202      -8.086  12.670   7.103  1.00106.61           O  
ATOM   9119  N   TYR D 203      -5.570  11.125  12.232  1.00 92.53           N  
ATOM   9120  CA  TYR D 203      -5.024   9.988  12.958  1.00 91.03           C  
ATOM   9121  C   TYR D 203      -4.559  10.417  14.336  1.00 90.25           C  
ATOM   9122  O   TYR D 203      -4.454   9.593  15.232  1.00 91.44           O  
ATOM   9123  CB  TYR D 203      -3.853   9.357  12.172  1.00 90.54           C  
ATOM   9124  CG  TYR D 203      -3.118   8.196  12.852  1.00 90.27           C  
ATOM   9125  CD1 TYR D 203      -2.108   8.424  13.793  1.00 89.93           C  
ATOM   9126  CD2 TYR D 203      -3.465   6.870  12.581  1.00 90.45           C  
ATOM   9127  CE1 TYR D 203      -1.468   7.357  14.458  1.00 90.61           C  
ATOM   9128  CE2 TYR D 203      -2.828   5.793  13.240  1.00 91.01           C  
ATOM   9129  CZ  TYR D 203      -1.837   6.043  14.183  1.00 91.14           C  
ATOM   9130  OH  TYR D 203      -1.258   4.993  14.885  1.00 90.62           O  
ATOM   9131  N   PHE D 204      -4.290  11.699  14.531  1.00 89.61           N  
ATOM   9132  CA  PHE D 204      -3.819  12.156  15.847  1.00 89.49           C  
ATOM   9133  C   PHE D 204      -4.752  13.130  16.563  1.00 88.32           C  
ATOM   9134  O   PHE D 204      -5.704  13.673  16.002  1.00 88.21           O  
ATOM   9135  CB  PHE D 204      -2.434  12.845  15.737  1.00 90.65           C  
ATOM   9136  CG  PHE D 204      -1.287  11.915  15.416  1.00 90.38           C  
ATOM   9137  CD1 PHE D 204      -0.558  12.065  14.234  1.00 90.08           C  
ATOM   9138  CD2 PHE D 204      -0.909  10.925  16.305  1.00 90.40           C  
ATOM   9139  CE1 PHE D 204       0.510  11.222  13.929  1.00 89.55           C  
ATOM   9140  CE2 PHE D 204       0.160  10.076  16.004  1.00 90.83           C  
ATOM   9141  CZ  PHE D 204       0.875  10.244  14.816  1.00 90.04           C  
ATOM   9142  N   GLU D 205      -4.433  13.357  17.820  1.00 87.23           N  
ATOM   9143  CA  GLU D 205      -5.180  14.281  18.642  1.00 87.38           C  
ATOM   9144  C   GLU D 205      -4.239  15.483  18.800  1.00 86.57           C  
ATOM   9145  O   GLU D 205      -3.503  15.568  19.780  1.00 87.52           O  
ATOM   9146  CB  GLU D 205      -5.445  13.611  19.986  1.00 88.43           C  
ATOM   9147  CG  GLU D 205      -6.106  14.458  21.057  1.00 91.13           C  
ATOM   9148  CD  GLU D 205      -5.912  13.857  22.463  1.00 93.59           C  
ATOM   9149  OE1 GLU D 205      -5.956  12.597  22.589  1.00 94.49           O  
ATOM   9150  OE2 GLU D 205      -5.722  14.636  23.440  1.00 93.74           O  
ATOM   9151  N   VAL D 206      -4.229  16.399  17.835  1.00 84.65           N  
ATOM   9152  CA  VAL D 206      -3.327  17.565  17.902  1.00 83.06           C  
ATOM   9153  C   VAL D 206      -3.287  18.283  19.263  1.00 81.91           C  
ATOM   9154  O   VAL D 206      -4.116  19.134  19.543  1.00 82.58           O  
ATOM   9155  CB  VAL D 206      -3.713  18.602  16.858  1.00 82.64           C  
ATOM   9156  CG1 VAL D 206      -2.722  19.757  16.909  1.00 82.63           C  
ATOM   9157  CG2 VAL D 206      -3.767  17.958  15.488  1.00 81.32           C  
ATOM   9158  N   ILE D 207      -2.287  17.983  20.072  1.00 80.68           N  
ATOM   9159  CA  ILE D 207      -2.170  18.544  21.410  1.00 80.01           C  
ATOM   9160  C   ILE D 207      -1.611  19.962  21.545  1.00 78.69           C  
ATOM   9161  O   ILE D 207      -1.851  20.664  22.541  1.00 77.60           O  
ATOM   9162  CB  ILE D 207      -1.329  17.579  22.276  1.00 81.74           C  
ATOM   9163  CG1 ILE D 207      -2.055  16.228  22.325  1.00 83.51           C  
ATOM   9164  CG2 ILE D 207      -1.130  18.113  23.668  1.00 81.27           C  
ATOM   9165  CD1 ILE D 207      -1.526  15.275  23.382  1.00 86.66           C  
ATOM   9166  N   GLU D 208      -0.867  20.401  20.544  1.00 77.07           N  
ATOM   9167  CA  GLU D 208      -0.298  21.727  20.609  1.00 75.51           C  
ATOM   9168  C   GLU D 208       0.353  22.091  19.291  1.00 74.59           C  
ATOM   9169  O   GLU D 208       0.613  21.241  18.453  1.00 75.05           O  
ATOM   9170  CB  GLU D 208       0.719  21.790  21.739  1.00 74.88           C  
ATOM   9171  CG  GLU D 208       1.292  23.161  21.969  1.00 76.97           C  
ATOM   9172  CD  GLU D 208       2.388  23.173  23.030  1.00 78.92           C  
ATOM   9173  OE1 GLU D 208       2.659  22.099  23.621  1.00 79.87           O  
ATOM   9174  OE2 GLU D 208       2.983  24.262  23.277  1.00 79.35           O  
ATOM   9175  N   ARG D 209       0.574  23.379  19.099  1.00 73.93           N  
ATOM   9176  CA  ARG D 209       1.226  23.889  17.911  1.00 72.93           C  
ATOM   9177  C   ARG D 209       1.957  25.121  18.396  1.00 72.27           C  
ATOM   9178  O   ARG D 209       1.400  25.905  19.149  1.00 73.62           O  
ATOM   9179  CB  ARG D 209       0.225  24.268  16.848  1.00 72.55           C  
ATOM   9180  CG  ARG D 209       0.818  25.195  15.830  1.00 73.89           C  
ATOM   9181  CD  ARG D 209      -0.131  25.315  14.684  1.00 76.69           C  
ATOM   9182  NE  ARG D 209       0.080  26.545  13.917  1.00 78.14           N  
ATOM   9183  CZ  ARG D 209      -0.648  26.876  12.854  1.00 79.64           C  
ATOM   9184  NH1 ARG D 209      -1.626  26.067  12.431  1.00 79.06           N  
ATOM   9185  NH2 ARG D 209      -0.398  28.012  12.223  1.00 79.74           N  
ATOM   9186  N   LEU D 210       3.205  25.282  17.984  1.00 70.86           N  
ATOM   9187  CA  LEU D 210       3.987  26.410  18.428  1.00 69.28           C  
ATOM   9188  C   LEU D 210       4.816  26.939  17.269  1.00 68.16           C  
ATOM   9189  O   LEU D 210       5.366  26.164  16.509  1.00 68.55           O  
ATOM   9190  CB  LEU D 210       4.881  25.981  19.590  1.00 70.06           C  
ATOM   9191  CG  LEU D 210       5.951  26.943  20.102  1.00 71.93           C  
ATOM   9192  CD1 LEU D 210       5.371  28.329  20.260  1.00 74.03           C  
ATOM   9193  CD2 LEU D 210       6.480  26.453  21.437  1.00 72.83           C  
ATOM   9194  N   ASN D 211       4.889  28.256  17.109  1.00 66.43           N  
ATOM   9195  CA  ASN D 211       5.657  28.813  16.027  1.00 64.93           C  
ATOM   9196  C   ASN D 211       7.094  28.962  16.491  1.00 63.13           C  
ATOM   9197  O   ASN D 211       7.338  29.184  17.675  1.00 63.30           O  
ATOM   9198  CB  ASN D 211       5.117  30.175  15.617  1.00 67.26           C  
ATOM   9199  CG  ASN D 211       5.629  30.596  14.246  1.00 70.51           C  
ATOM   9200  OD1 ASN D 211       5.054  30.193  13.207  1.00 71.87           O  
ATOM   9201  ND2 ASN D 211       6.737  31.365  14.218  1.00 69.26           N  
ATOM   9202  N   LEU D 212       8.046  28.879  15.568  1.00 60.51           N  
ATOM   9203  CA  LEU D 212       9.439  28.981  15.960  1.00 59.53           C  
ATOM   9204  C   LEU D 212      10.128  30.328  15.800  1.00 58.64           C  
ATOM   9205  O   LEU D 212      11.318  30.446  16.073  1.00 57.17           O  
ATOM   9206  CB  LEU D 212      10.268  27.888  15.264  1.00 60.53           C  
ATOM   9207  CG  LEU D 212      10.313  26.456  15.887  1.00 61.16           C  
ATOM   9208  CD1 LEU D 212      10.457  26.543  17.415  1.00 60.42           C  
ATOM   9209  CD2 LEU D 212       9.067  25.687  15.570  1.00 61.02           C  
ATOM   9210  N   GLU D 213       9.393  31.352  15.360  1.00 58.27           N  
ATOM   9211  CA  GLU D 213       9.981  32.697  15.207  1.00 57.84           C  
ATOM   9212  C   GLU D 213      10.366  33.202  16.583  1.00 56.26           C  
ATOM   9213  O   GLU D 213       9.669  32.944  17.552  1.00 55.54           O  
ATOM   9214  CB  GLU D 213       8.955  33.678  14.644  1.00 59.06           C  
ATOM   9215  CG  GLU D 213       8.355  33.316  13.286  1.00 61.88           C  
ATOM   9216  CD  GLU D 213       9.209  33.767  12.097  1.00 65.65           C  
ATOM   9217  OE1 GLU D 213       8.699  33.635  10.932  1.00 66.20           O  
ATOM   9218  OE2 GLU D 213      10.378  34.247  12.311  1.00 66.56           O  
ATOM   9219  N   PRO D 214      11.466  33.959  16.685  1.00 56.12           N  
ATOM   9220  CA  PRO D 214      12.358  34.494  15.635  1.00 56.41           C  
ATOM   9221  C   PRO D 214      13.520  33.580  15.226  1.00 56.50           C  
ATOM   9222  O   PRO D 214      14.389  33.970  14.419  1.00 55.12           O  
ATOM   9223  CB  PRO D 214      12.896  35.773  16.260  1.00 56.00           C  
ATOM   9224  CG  PRO D 214      13.111  35.334  17.697  1.00 55.66           C  
ATOM   9225  CD  PRO D 214      11.897  34.425  18.023  1.00 54.91           C  
ATOM   9226  N   TYR D 215      13.527  32.384  15.802  1.00 56.81           N  
ATOM   9227  CA  TYR D 215      14.564  31.384  15.568  1.00 56.35           C  
ATOM   9228  C   TYR D 215      14.502  30.782  14.163  1.00 55.75           C  
ATOM   9229  O   TYR D 215      15.527  30.708  13.488  1.00 54.30           O  
ATOM   9230  CB  TYR D 215      14.455  30.329  16.673  1.00 54.52           C  
ATOM   9231  CG  TYR D 215      14.859  30.918  17.996  1.00 54.98           C  
ATOM   9232  CD1 TYR D 215      16.200  31.333  18.197  1.00 53.61           C  
ATOM   9233  CD2 TYR D 215      13.903  31.138  19.023  1.00 54.13           C  
ATOM   9234  CE1 TYR D 215      16.593  31.962  19.378  1.00 54.48           C  
ATOM   9235  CE2 TYR D 215      14.271  31.775  20.222  1.00 55.03           C  
ATOM   9236  CZ  TYR D 215      15.632  32.194  20.398  1.00 56.16           C  
ATOM   9237  OH  TYR D 215      16.010  32.870  21.564  1.00 55.53           O  
ATOM   9238  N   GLU D 216      13.296  30.410  13.731  1.00 56.74           N  
ATOM   9239  CA  GLU D 216      13.067  29.830  12.406  1.00 58.18           C  
ATOM   9240  C   GLU D 216      11.962  30.538  11.617  1.00 59.22           C  
ATOM   9241  O   GLU D 216      10.894  30.838  12.161  1.00 59.67           O  
ATOM   9242  CB  GLU D 216      12.677  28.347  12.516  1.00 58.40           C  
ATOM   9243  CG  GLU D 216      13.748  27.427  13.082  1.00 60.96           C  
ATOM   9244  CD  GLU D 216      15.100  27.560  12.395  1.00 61.46           C  
ATOM   9245  OE1 GLU D 216      16.095  27.082  12.986  1.00 62.37           O  
ATOM   9246  OE2 GLU D 216      15.179  28.140  11.282  1.00 62.95           O  
ATOM   9247  N   LYS D 217      12.184  30.769  10.325  1.00 59.69           N  
ATOM   9248  CA  LYS D 217      11.139  31.409   9.540  1.00 61.47           C  
ATOM   9249  C   LYS D 217      10.073  30.448   9.011  1.00 61.65           C  
ATOM   9250  O   LYS D 217      10.373  29.462   8.366  1.00 60.70           O  
ATOM   9251  CB  LYS D 217      11.750  32.222   8.383  1.00 61.69           C  
ATOM   9252  CG  LYS D 217      12.127  33.692   8.816  1.00 65.15           C  
ATOM   9253  CD  LYS D 217      13.660  33.966   8.896  1.00 62.68           C  
ATOM   9254  CE  LYS D 217      13.974  34.944   9.971  1.00 58.03           C  
ATOM   9255  NZ  LYS D 217      13.639  34.343  11.265  1.00 57.36           N  
ATOM   9256  N   ASP D 218       8.814  30.709   9.325  1.00 62.36           N  
ATOM   9257  CA  ASP D 218       7.766  29.858   8.781  1.00 63.22           C  
ATOM   9258  C   ASP D 218       7.903  28.424   9.154  1.00 62.17           C  
ATOM   9259  O   ASP D 218       7.773  27.549   8.305  1.00 60.24           O  
ATOM   9260  CB  ASP D 218       7.800  29.934   7.265  1.00 66.19           C  
ATOM   9261  CG  ASP D 218       7.427  31.304   6.746  1.00 67.02           C  
ATOM   9262  OD1 ASP D 218       8.012  31.688   5.694  1.00 66.33           O  
ATOM   9263  OD2 ASP D 218       6.558  31.960   7.397  1.00 67.45           O  
ATOM   9264  N   HIS D 219       8.148  28.193  10.430  1.00 63.27           N  
ATOM   9265  CA  HIS D 219       8.336  26.850  10.947  1.00 62.35           C  
ATOM   9266  C   HIS D 219       7.375  26.634  12.094  1.00 61.97           C  
ATOM   9267  O   HIS D 219       7.168  27.519  12.891  1.00 61.93           O  
ATOM   9268  CB  HIS D 219       9.754  26.732  11.479  1.00 61.94           C  
ATOM   9269  CG  HIS D 219      10.761  26.266  10.476  1.00 61.01           C  
ATOM   9270  ND1 HIS D 219      11.156  24.949  10.388  1.00 59.93           N  
ATOM   9271  CD2 HIS D 219      11.536  26.953   9.610  1.00 60.00           C  
ATOM   9272  CE1 HIS D 219      12.141  24.845   9.515  1.00 59.69           C  
ATOM   9273  NE2 HIS D 219      12.389  26.046   9.030  1.00 60.69           N  
ATOM   9274  N   ALA D 220       6.792  25.461  12.186  1.00 62.32           N  
ATOM   9275  CA  ALA D 220       5.903  25.210  13.298  1.00 63.35           C  
ATOM   9276  C   ALA D 220       6.122  23.809  13.846  1.00 64.03           C  
ATOM   9277  O   ALA D 220       6.145  22.819  13.087  1.00 64.55           O  
ATOM   9278  CB  ALA D 220       4.454  25.374  12.883  1.00 63.81           C  
ATOM   9279  N   LEU D 221       6.279  23.729  15.167  1.00 63.62           N  
ATOM   9280  CA  LEU D 221       6.472  22.466  15.854  1.00 63.94           C  
ATOM   9281  C   LEU D 221       5.120  21.983  16.366  1.00 64.87           C  
ATOM   9282  O   LEU D 221       4.493  22.669  17.154  1.00 65.22           O  
ATOM   9283  CB  LEU D 221       7.415  22.673  17.034  1.00 63.31           C  
ATOM   9284  CG  LEU D 221       7.205  21.655  18.169  1.00 64.43           C  
ATOM   9285  CD1 LEU D 221       7.658  20.304  17.719  1.00 64.39           C  
ATOM   9286  CD2 LEU D 221       7.965  22.057  19.416  1.00 65.43           C  
ATOM   9287  N   PHE D 222       4.648  20.828  15.925  1.00 66.30           N  
ATOM   9288  CA  PHE D 222       3.365  20.312  16.442  1.00 68.33           C  
ATOM   9289  C   PHE D 222       3.622  19.175  17.446  1.00 68.21           C  
ATOM   9290  O   PHE D 222       4.690  18.578  17.430  1.00 68.45           O  
ATOM   9291  CB  PHE D 222       2.496  19.730  15.316  1.00 69.25           C  
ATOM   9292  CG  PHE D 222       2.073  20.728  14.290  1.00 71.44           C  
ATOM   9293  CD1 PHE D 222       3.002  21.330  13.457  1.00 73.19           C  
ATOM   9294  CD2 PHE D 222       0.734  21.062  14.145  1.00 71.97           C  
ATOM   9295  CE1 PHE D 222       2.600  22.255  12.484  1.00 74.34           C  
ATOM   9296  CE2 PHE D 222       0.328  21.973  13.190  1.00 72.67           C  
ATOM   9297  CZ  PHE D 222       1.260  22.574  12.353  1.00 73.28           C  
ATOM   9298  N   VAL D 223       2.669  18.906  18.339  1.00 68.25           N  
ATOM   9299  CA  VAL D 223       2.774  17.758  19.252  1.00 69.06           C  
ATOM   9300  C   VAL D 223       1.421  17.097  19.144  1.00 69.29           C  
ATOM   9301  O   VAL D 223       0.399  17.767  19.074  1.00 69.58           O  
ATOM   9302  CB  VAL D 223       3.050  18.082  20.738  1.00 68.65           C  
ATOM   9303  CG1 VAL D 223       4.238  19.009  20.858  1.00 69.21           C  
ATOM   9304  CG2 VAL D 223       1.807  18.631  21.397  1.00 70.69           C  
ATOM   9305  N   VAL D 224       1.408  15.782  19.119  1.00 70.31           N  
ATOM   9306  CA  VAL D 224       0.163  15.088  18.957  1.00 71.67           C  
ATOM   9307  C   VAL D 224       0.230  13.847  19.834  1.00 73.79           C  
ATOM   9308  O   VAL D 224       1.291  13.528  20.373  1.00 73.90           O  
ATOM   9309  CB  VAL D 224      -0.004  14.724  17.458  1.00 71.12           C  
ATOM   9310  CG1 VAL D 224       0.230  15.973  16.590  1.00 68.63           C  
ATOM   9311  CG2 VAL D 224       0.990  13.631  17.079  1.00 69.67           C  
ATOM   9312  N   ARG D 225      -0.900  13.173  20.020  1.00 76.71           N  
ATOM   9313  CA  ARG D 225      -0.915  11.929  20.789  1.00 79.11           C  
ATOM   9314  C   ARG D 225      -1.606  10.858  19.976  1.00 79.49           C  
ATOM   9315  O   ARG D 225      -2.549  11.144  19.237  1.00 78.71           O  
ATOM   9316  CB  ARG D 225      -1.615  12.091  22.131  1.00 80.39           C  
ATOM   9317  CG  ARG D 225      -0.649  11.989  23.282  1.00 82.08           C  
ATOM   9318  CD  ARG D 225      -1.383  12.116  24.576  1.00 84.75           C  
ATOM   9319  NE  ARG D 225      -2.139  10.916  24.898  1.00 87.64           N  
ATOM   9320  CZ  ARG D 225      -1.948  10.220  26.015  1.00 88.19           C  
ATOM   9321  NH1 ARG D 225      -2.672   9.133  26.263  1.00 88.58           N  
ATOM   9322  NH2 ARG D 225      -1.020  10.616  26.879  1.00 87.59           N  
ATOM   9323  N   LYS D 226      -1.097   9.635  20.093  1.00 80.86           N  
ATOM   9324  CA  LYS D 226      -1.662   8.515  19.368  1.00 83.15           C  
ATOM   9325  C   LYS D 226      -2.916   8.096  20.124  1.00 86.33           C  
ATOM   9326  O   LYS D 226      -2.872   7.917  21.362  1.00 87.45           O  
ATOM   9327  CB  LYS D 226      -0.663   7.351  19.289  1.00 81.01           C  
ATOM   9328  CG  LYS D 226      -1.162   6.182  18.439  1.00 78.70           C  
ATOM   9329  CD  LYS D 226      -0.029   5.283  17.982  1.00 76.91           C  
ATOM   9330  CE  LYS D 226      -0.543   3.985  17.393  1.00 75.22           C  
ATOM   9331  NZ  LYS D 226       0.588   3.111  17.039  1.00 73.95           N  
ATOM   9332  N   PRO D 227      -4.062   7.968  19.406  1.00 88.00           N  
ATOM   9333  CA  PRO D 227      -5.284   7.565  20.106  1.00 88.88           C  
ATOM   9334  C   PRO D 227      -5.028   6.339  21.010  1.00 91.01           C  
ATOM   9335  O   PRO D 227      -4.360   5.361  20.539  1.00 92.23           O  
ATOM   9336  CB  PRO D 227      -6.244   7.258  18.958  1.00 88.37           C  
ATOM   9337  CG  PRO D 227      -5.334   6.828  17.837  1.00 87.87           C  
ATOM   9338  CD  PRO D 227      -4.247   7.871  17.945  1.00 87.91           C  
ATOM   9339  OXT PRO D 227      -5.516   6.380  22.172  1.00 91.10           O  
TER    9340      PRO D 227                                                      
END
MOLECULE T0508.pdb
ATOM      1  N   GLN    17      27.341  18.956  20.266  1.00 28.55           N  
ATOM      2  CA  GLN    17      26.133  19.476  19.544  1.00 26.35           C  
ATOM      3  C   GLN    17      25.067  19.993  20.513  1.00 30.77           C  
ATOM      4  O   GLN    17      24.034  20.543  20.088  1.00 24.08           O  
ATOM      5  CB  GLN    17      25.542  18.382  18.646  1.00 27.54           C  
ATOM      6  CG  GLN    17      26.434  17.946  17.479  1.00 28.33           C  
ATOM      7  CD  GLN    17      26.586  19.019  16.411  1.00 35.79           C  
ATOM      8  OE1 GLN    17      25.718  19.891  16.241  1.00 34.30           O  
ATOM      9  NE2 GLN    17      27.692  18.953  15.672  1.00 38.09           N  
ATOM     10  N   LEU    18      25.329  19.819  21.814  1.00 31.52           N  
ATOM     11  CA  LEU    18      24.433  20.242  22.907  1.00 36.19           C  
ATOM     12  C   LEU    18      24.053  21.718  22.876  1.00 37.06           C  
ATOM     13  O   LEU    18      23.038  22.126  23.448  1.00 36.28           O  
ATOM     14  CB  LEU    18      25.085  19.950  24.263  1.00 40.29           C  
ATOM     15  CG  LEU    18      25.116  18.500  24.733  1.00 40.46           C  
ATOM     16  CD1 LEU    18      25.963  18.381  25.991  1.00 45.09           C  
ATOM     17  CD2 LEU    18      23.700  18.005  24.965  1.00 39.67           C  
ATOM     18  N   ARG    19      24.888  22.495  22.199  1.00 35.74           N  
ATOM     19  CA  ARG    19      24.812  23.945  22.161  1.00 37.88           C  
ATOM     20  C   ARG    19      24.334  24.487  20.806  1.00 29.39           C  
ATOM     21  O   ARG    19      24.321  25.705  20.601  1.00 29.87           O  
ATOM     22  CB  ARG    19      26.205  24.493  22.466  1.00 42.33           C  
ATOM     23  CG  ARG    19      27.341  23.712  21.765  1.00 53.58           C  
ATOM     24  CD  ARG    19      27.752  24.332  20.429  1.00 61.77           C  
ATOM     25  NE  ARG    19      28.576  23.428  19.629  1.00 75.01           N  
ATOM     26  CZ  ARG    19      28.165  22.800  18.529  1.00 80.38           C  
ATOM     27  NH1 ARG    19      26.931  22.978  18.067  1.00 80.36           N  
ATOM     28  NH2 ARG    19      28.996  21.994  17.880  1.00 82.30           N  
ATOM     29  N   SER    20      23.992  23.591  19.877  1.00 22.34           N  
ATOM     30  CA  SER    20      23.537  23.996  18.549  1.00 20.35           C  
ATOM     31  C   SER    20      22.175  24.689  18.593  1.00 18.47           C  
ATOM     32  O   SER    20      21.426  24.558  19.561  1.00 18.01           O  
ATOM     33  CB  SER    20      23.472  22.799  17.611  1.00 22.60           C  
ATOM     34  OG  SER    20      22.316  22.019  17.885  1.00 20.95           O  
ATOM     35  N   ARG    21      21.846  25.410  17.528  1.00 18.65           N  
ATOM     36  CA  ARG    21      20.566  26.116  17.455  1.00 19.51           C  
ATOM     37  C   ARG    21      19.421  25.111  17.556  1.00 17.07           C  
ATOM     38  O   ARG    21      18.440  25.343  18.268  1.00 19.73           O  
ATOM     39  CB  ARG    21      20.473  26.874  16.130  1.00 23.77           C  
ATOM     40  CG  ARG    21      19.192  27.666  15.945  1.00 31.80           C  
ATOM     41  CD  ARG    21      19.340  28.620  14.778  1.00 45.60           C  
ATOM     42  NE  ARG    21      18.350  29.692  14.818  1.00 57.03           N  
ATOM     43  CZ  ARG    21      18.418  30.803  14.089  1.00 65.61           C  
ATOM     44  NH1 ARG    21      19.437  30.999  13.257  1.00 66.62           N  
ATOM     45  NH2 ARG    21      17.468  31.723  14.194  1.00 68.54           N  
ATOM     46  N   ALA    22      19.578  23.995  16.850  1.00 17.83           N  
ATOM     47  CA  ALA    22      18.573  22.948  16.851  1.00 15.55           C  
ATOM     48  C   ALA    22      18.381  22.371  18.258  1.00 16.33           C  
ATOM     49  O   ALA    22      17.249  22.202  18.720  1.00 17.50           O  
ATOM     50  CB  ALA    22      18.933  21.869  15.862  1.00 19.42           C  
ATOM     51  N   ALA    23      19.481  22.100  18.964  1.00 16.59           N  
ATOM     52  CA  ALA    23      19.386  21.661  20.362  1.00 15.10           C  
ATOM     53  C   ALA    23      18.604  22.656  21.238  1.00 16.51           C  
ATOM     54  O   ALA    23      17.775  22.244  22.038  1.00 15.64           O  
ATOM     55  CB  ALA    23      20.787  21.427  20.948  1.00 15.49           C  
ATOM     56  N   PHE    24      18.867  23.967  21.093  1.00 15.01           N  
ATOM     57  CA  PHE    24      18.139  24.958  21.887  1.00 20.00           C  
ATOM     58  C   PHE    24      16.644  24.967  21.591  1.00 14.73           C  
ATOM     59  O   PHE    24      15.815  25.130  22.508  1.00 18.39           O  
ATOM     60  CB  PHE    24      18.733  26.367  21.714  1.00 25.77           C  
ATOM     61  CG  PHE    24      19.868  26.656  22.659  1.00 37.19           C  
ATOM     62  CD1 PHE    24      19.615  27.052  23.971  1.00 47.97           C  
ATOM     63  CD2 PHE    24      21.193  26.508  22.245  1.00 46.26           C  
ATOM     64  CE1 PHE    24      20.666  27.309  24.857  1.00 54.49           C  
ATOM     65  CE2 PHE    24      22.251  26.764  23.120  1.00 49.16           C  
ATOM     66  CZ  PHE    24      21.989  27.165  24.428  1.00 48.58           C  
ATOM     67  N   LYS    25      16.301  24.766  20.314  1.00 15.96           N  
ATOM     68  CA  LYS    25      14.893  24.667  19.907  1.00 15.07           C  
ATOM     69  C   LYS    25      14.239  23.492  20.622  1.00 14.67           C  
ATOM     70  O   LYS    25      13.147  23.626  21.185  1.00 14.53           O  
ATOM     71  CB  LYS    25      14.751  24.520  18.391  1.00 16.88           C  
ATOM     72  CG  LYS    25      15.042  25.803  17.590  1.00 24.44           C  
ATOM     73  CD  LYS    25      14.706  25.620  16.105  1.00 27.14           C  
ATOM     74  CE  LYS    25      15.959  25.479  15.249  1.00 35.96           C  
ATOM     75  NZ  LYS    25      15.649  25.049  13.851  1.00 38.22           N  
ATOM     76  N   LEU    26      14.912  22.340  20.648  1.00 13.44           N  
ATOM     77  CA  LEU    26      14.307  21.207  21.341  1.00 12.47           C  
ATOM     78  C   LEU    26      14.186  21.435  22.842  1.00 12.58           C  
ATOM     79  O   LEU    26      13.165  21.067  23.427  1.00 13.35           O  
ATOM     80  CB  LEU    26      15.051  19.889  21.058  1.00 14.07           C  
ATOM     81  CG  LEU    26      14.419  18.650  21.686  1.00 12.73           C  
ATOM     82  CD1 LEU    26      13.020  18.452  21.173  1.00 13.01           C  
ATOM     83  CD2 LEU    26      15.264  17.428  21.366  1.00 13.66           C  
ATOM     84  N   GLU    27      15.197  22.047  23.463  1.00 14.16           N  
ATOM     85  CA  GLU    27      15.124  22.335  24.902  1.00 15.27           C  
ATOM     86  C   GLU    27      13.907  23.219  25.231  1.00 12.64           C  
ATOM     87  O   GLU    27      13.205  22.990  26.204  1.00 14.02           O  
ATOM     88  CB  GLU    27      16.428  22.989  25.382  1.00 16.28           C  
ATOM     89  CG  GLU    27      17.600  21.998  25.485  1.00 27.56           C  
ATOM     90  CD  GLU    27      18.915  22.632  25.940  1.00 38.21           C  
ATOM     91  OE1 GLU    27      19.405  23.577  25.272  1.00 49.67           O  
ATOM     92  OE2 GLU    27      19.469  22.163  26.960  1.00 51.34           O  
ATOM     93  N   PHE    28      13.670  24.214  24.380  1.00 14.06           N  
ATOM     94  CA  PHE    28      12.541  25.133  24.517  1.00 12.72           C  
ATOM     95  C   PHE    28      11.221  24.373  24.460  1.00 13.27           C  
ATOM     96  O   PHE    28      10.360  24.568  25.306  1.00 13.48           O  
ATOM     97  CB  PHE    28      12.682  26.168  23.405  1.00 13.96           C  
ATOM     98  CG  PHE    28      11.502  27.087  23.215  1.00 14.57           C  
ATOM     99  CD1 PHE    28      11.408  28.290  23.917  1.00 19.84           C  
ATOM    100  CD2 PHE    28      10.536  26.793  22.258  1.00 17.11           C  
ATOM    101  CE1 PHE    28      10.346  29.167  23.677  1.00 17.75           C  
ATOM    102  CE2 PHE    28       9.457  27.663  22.024  1.00 16.94           C  
ATOM    103  CZ  PHE    28       9.381  28.850  22.735  1.00 20.66           C  
ATOM    104  N   LEU    29      11.108  23.480  23.476  1.00 13.95           N  
ATOM    105  CA  LEU    29       9.905  22.672  23.317  1.00 11.98           C  
ATOM    106  C   LEU    29       9.685  21.692  24.466  1.00 12.60           C  
ATOM    107  O   LEU    29       8.537  21.496  24.882  1.00 13.48           O  
ATOM    108  CB  LEU    29       9.940  21.899  21.982  1.00 13.29           C  
ATOM    109  CG  LEU    29       9.955  22.790  20.727  1.00 13.34           C  
ATOM    110  CD1 LEU    29      10.381  21.990  19.476  1.00 14.82           C  
ATOM    111  CD2 LEU    29       8.600  23.481  20.463  1.00 14.32           C  
ATOM    112  N   LEU    30      10.753  21.064  24.967  1.00 10.58           N  
ATOM    113  CA  LEU    30      10.602  20.155  26.121  1.00 12.83           C  
ATOM    114  C   LEU    30      10.172  20.920  27.372  1.00 12.29           C  
ATOM    115  O   LEU    30       9.300  20.465  28.111  1.00 14.05           O  
ATOM    116  CB  LEU    30      11.895  19.370  26.400  1.00 15.66           C  
ATOM    117  CG  LEU    30      12.359  18.479  25.258  1.00 16.16           C  
ATOM    118  CD1 LEU    30      13.759  17.903  25.567  1.00 17.08           C  
ATOM    119  CD2 LEU    30      11.320  17.389  24.963  1.00 19.76           C  
ATOM    120  N   ASP    31      10.738  22.115  27.577  1.00 13.31           N  
ATOM    121  CA  ASP    31      10.380  22.953  28.748  1.00 12.70           C  
ATOM    122  C   ASP    31       8.916  23.346  28.710  1.00 13.57           C  
ATOM    123  O   ASP    31       8.207  23.347  29.728  1.00 13.47           O  
ATOM    124  CB  ASP    31      11.213  24.239  28.773  1.00 16.51           C  
ATOM    125  CG  ASP    31      12.593  24.044  29.368  1.00 23.03           C  
ATOM    126  OD1 ASP    31      12.832  23.035  30.067  1.00 27.41           O  
ATOM    127  OD2 ASP    31      13.448  24.930  29.141  1.00 27.84           O  
ATOM    128  N   ARG    32       8.452  23.717  27.535  1.00 12.67           N  
ATOM    129  CA  ARG    32       7.103  24.226  27.393  1.00 12.84           C  
ATOM    130  C   ARG    32       6.040  23.146  27.326  1.00 13.39           C  
ATOM    131  O   ARG    32       4.932  23.349  27.808  1.00 13.37           O  
ATOM    132  CB  ARG    32       7.000  25.023  26.116  1.00 12.72           C  
ATOM    133  CG  ARG    32       7.559  26.433  26.139  1.00 14.78           C  
ATOM    134  CD  ARG    32       7.075  27.174  24.878  1.00 14.18           C  
ATOM    135  NE  ARG    32       7.107  28.621  25.069  1.00 18.87           N  
ATOM    136  CZ  ARG    32       6.487  29.493  24.283  1.00 19.83           C  
ATOM    137  NH1 ARG    32       6.604  30.782  24.540  1.00 27.51           N  
ATOM    138  NH2 ARG    32       5.760  29.077  23.246  1.00 19.18           N  
ATOM    139  N   TYR    33       6.361  22.031  26.665  1.00 10.84           N  
ATOM    140  CA  TYR    33       5.349  21.039  26.290  1.00 11.98           C  
ATOM    141  C   TYR    33       5.577  19.599  26.760  1.00 12.64           C  
ATOM    142  O   TYR    33       4.688  18.759  26.572  1.00 13.17           O  
ATOM    143  CB  TYR    33       5.177  21.027  24.770  1.00 11.87           C  
ATOM    144  CG  TYR    33       4.950  22.401  24.210  1.00 12.45           C  
ATOM    145  CD1 TYR    33       3.748  23.065  24.432  1.00 12.73           C  
ATOM    146  CD2 TYR    33       5.941  23.052  23.490  1.00 11.65           C  
ATOM    147  CE1 TYR    33       3.525  24.350  23.915  1.00 13.75           C  
ATOM    148  CE2 TYR    33       5.720  24.343  22.958  1.00 13.97           C  
ATOM    149  CZ  TYR    33       4.524  24.980  23.189  1.00 14.82           C  
ATOM    150  OH  TYR    33       4.331  26.250  22.673  1.00 17.07           O  
ATOM    151  N   ARG    34       6.737  19.329  27.320  1.00 11.94           N  
ATOM    152  CA  ARG    34       7.075  17.987  27.885  0.50 12.60           C  
ATOM    154  C   ARG    34       6.752  16.863  26.836  1.00 15.29           C  
ATOM    155  O   ARG    34       6.265  15.838  27.180  1.00 16.34           O  
ATOM    156  CB  ARG    34       6.341  17.730  29.206  0.50 15.27           C  
ATOM    158  CG  ARG    34       6.715  18.721  30.308  0.50 18.80           C  
ATOM    160  CD  ARG    34       6.251  18.251  31.685  0.50 24.09           C  
ATOM    162  NE  ARG    34       7.080  17.171  32.217  0.50 29.99           N  
ATOM    164  CZ  ARG    34       6.723  15.887  32.260  0.50 35.77           C  
ATOM    166  NH1 ARG    34       7.554  14.986  32.768  0.50 30.23           N  
ATOM    168  NH2 ARG    34       5.538  15.495  31.800  0.50 39.31           N  
ATOM    170  N   VAL    35       7.093  17.136  25.601  1.00 14.33           N  
ATOM    171  CA  VAL    35       6.681  16.252  24.539  1.00 16.23           C  
ATOM    172  C   VAL    35       7.397  14.907  24.563  1.00 15.87           C  
ATOM    173  O   VAL    35       6.842  13.935  24.164  1.00 18.60           O  
ATOM    174  CB  VAL    35       6.614  16.981  23.155  1.00 20.79           C  
ATOM    175  CG1 VAL    35       7.901  17.453  22.753  1.00 19.27           C  
ATOM    176  CG2 VAL    35       5.962  16.095  22.079  1.00 22.03           C  
ATOM    177  N   VAL    36       8.620  14.904  25.063  1.00 14.69           N  
ATOM    178  CA  VAL    36       9.323  13.708  25.475  1.00 14.45           C  
ATOM    179  C   VAL    36       9.549  13.719  27.008  1.00 14.37           C  
ATOM    180  O   VAL    36       9.873  14.725  27.537  1.00 16.00           O  
ATOM    181  CB  VAL    36      10.688  13.600  24.695  1.00 15.76           C  
ATOM    182  CG1 VAL    36      11.501  12.407  25.134  1.00 14.06           C  
ATOM    183  CG2 VAL    36      10.462  13.571  23.222  1.00 13.18           C  
ATOM    184  N   ARG    37       9.328  12.593  27.672  1.00 13.64           N  
ATOM    185  CA  ARG    37       9.333  12.429  29.008  0.50 18.53           C  
ATOM    187  C   ARG    37      10.496  11.527  29.402  1.00 15.77           C  
ATOM    188  O   ARG    37      10.863  10.667  28.672  1.00 14.89           O  
ATOM    189  CB  ARG    37       7.994  11.913  29.555  0.50 20.65           C  
ATOM    191  CG  ARG    37       6.819  12.854  29.252  0.50 30.27           C  
ATOM    193  CD  ARG    37       5.434  12.185  29.360  0.50 33.11           C  
ATOM    195  NE  ARG    37       5.097  11.095  28.417  0.50 42.98           N  
ATOM    197  CZ  ARG    37       5.375  11.018  27.107  0.50 40.65           C  
ATOM    199  NH1 ARG    37       6.040  11.964  26.456  0.50 28.66           N  
ATOM    201  NH2 ARG    37       4.975   9.949  26.427  0.50 44.72           N  
ATOM    203  N   LYS    38      11.067  11.751  30.563  1.00 15.15           N  
ATOM    204  CA  LYS    38      12.094  10.917  31.115  1.00 13.26           C  
ATOM    205  C   LYS    38      11.741   9.422  31.039  1.00 14.54           C  
ATOM    206  O   LYS    38      10.728   9.042  31.504  1.00 15.92           O  
ATOM    207  CB  LYS    38      12.289  11.304  32.594  1.00 16.09           C  
ATOM    208  CG  LYS    38      13.380  10.611  33.234  1.00 22.87           C  
ATOM    209  CD  LYS    38      14.598  11.183  32.785  1.00 36.52           C  
ATOM    210  CE  LYS    38      15.770  10.611  33.427  1.00 45.52           C  
ATOM    211  NZ  LYS    38      16.989  11.533  33.326  1.00 52.07           N  
ATOM    212  N   GLY    39      12.616   8.645  30.434  1.00 14.73           N  
ATOM    213  CA  GLY    39      12.416   7.193  30.331  1.00 13.34           C  
ATOM    214  C   GLY    39      11.741   6.729  29.047  1.00 14.96           C  
ATOM    215  O   GLY    39      11.562   5.538  28.824  1.00 12.59           O  
ATOM    216  N   ASP    40      11.334   7.670  28.208  1.00 11.88           N  
ATOM    217  CA  ASP    40      10.695   7.357  26.933  1.00  9.89           C  
ATOM    218  C   ASP    40      11.656   6.706  25.958  1.00 10.44           C  
ATOM    219  O   ASP    40      12.871   6.965  25.986  1.00 11.68           O  
ATOM    220  CB  ASP    40      10.168   8.642  26.291  1.00  9.60           C  
ATOM    221  CG  ASP    40       8.825   9.075  26.855  1.00 15.15           C  
ATOM    222  OD1 ASP    40       8.300   8.390  27.768  1.00 15.94           O  
ATOM    223  OD2 ASP    40       8.287  10.116  26.398  1.00 13.89           O  
ATOM    224  N   ALA    41      11.087   5.869  25.081  1.00  9.23           N  
ATOM    225  CA  ALA    41      11.803   5.381  23.917  1.00 10.66           C  
ATOM    226  C   ALA    41      11.312   6.214  22.746  1.00 10.39           C  
ATOM    227  O   ALA    41      10.097   6.409  22.593  1.00 10.52           O  
ATOM    228  CB  ALA    41      11.509   3.893  23.655  1.00 11.78           C  
ATOM    229  N   VAL    42      12.251   6.703  21.934  1.00  9.29           N  
ATOM    230  CA  VAL    42      11.966   7.691  20.884  1.00  9.19           C  
ATOM    231  C   VAL    42      12.535   7.249  19.544  1.00  9.09           C  
ATOM    232  O   VAL    42      13.680   6.824  19.477  1.00 10.43           O  
ATOM    233  CB  VAL    42      12.634   9.041  21.259  1.00 10.87           C  
ATOM    234  CG1 VAL    42      12.350  10.120  20.216  1.00 10.02           C  
ATOM    235  CG2 VAL    42      12.159   9.507  22.641  1.00  9.93           C  
ATOM    236  N   ILE    43      11.714   7.336  18.489  1.00  9.23           N  
ATOM    237  CA  ILE    43      12.233   7.267  17.117  1.00  8.55           C  
ATOM    238  C   ILE    43      12.455   8.724  16.690  1.00  9.88           C  
ATOM    239  O   ILE    43      11.523   9.538  16.716  1.00 10.54           O  
ATOM    240  CB  ILE    43      11.247   6.608  16.168  1.00  9.68           C  
ATOM    241  CG1 ILE    43      11.134   5.117  16.514  1.00 11.32           C  
ATOM    242  CG2 ILE    43      11.709   6.781  14.705  1.00 13.11           C  
ATOM    243  CD1 ILE    43       9.953   4.437  15.835  1.00 12.08           C  
ATOM    244  N   GLU    44      13.695   9.056  16.345  1.00 10.06           N  
ATOM    245  CA  GLU    44      14.079  10.401  15.958  1.00 10.36           C  
ATOM    246  C   GLU    44      14.415  10.427  14.478  1.00 11.21           C  
ATOM    247  O   GLU    44      15.330   9.729  14.050  1.00 12.60           O  
ATOM    248  CB  GLU    44      15.301  10.844  16.764  1.00 11.21           C  
ATOM    249  CG  GLU    44      15.747  12.224  16.301  1.00 11.70           C  
ATOM    250  CD  GLU    44      17.120  12.636  16.766  1.00 13.48           C  
ATOM    251  OE1 GLU    44      17.897  11.771  17.255  1.00 15.29           O  
ATOM    252  OE2 GLU    44      17.420  13.836  16.601  1.00 17.75           O  
ATOM    253  N   ILE    45      13.664  11.191  13.701  1.00  9.39           N  
ATOM    254  CA  ILE    45      13.837  11.257  12.237  1.00  9.26           C  
ATOM    255  C   ILE    45      14.554  12.550  11.852  1.00 10.33           C  
ATOM    256  O   ILE    45      14.161  13.633  12.285  1.00 12.16           O  
ATOM    257  CB  ILE    45      12.486  11.132  11.523  1.00 10.48           C  
ATOM    258  CG1 ILE    45      11.919   9.730  11.811  1.00 14.98           C  
ATOM    259  CG2 ILE    45      12.642  11.353  10.015  1.00 13.76           C  
ATOM    260  CD1 ILE    45      10.461   9.557  11.499  1.00 20.21           C  
ATOM    261  N   GLY    46      15.643  12.439  11.084  1.00 11.67           N  
ATOM    262  CA  GLY    46      16.424  13.628  10.739  1.00 10.89           C  
ATOM    263  C   GLY    46      17.394  14.013  11.850  1.00 11.86           C  
ATOM    264  O   GLY    46      17.433  15.156  12.283  1.00 14.16           O  
ATOM    265  N   SER    47      18.192  13.047  12.287  1.00 14.11           N  
ATOM    266  CA  SER    47      19.016  13.223  13.476  1.00 13.31           C  
ATOM    267  C   SER    47      20.367  13.896  13.288  1.00 12.81           C  
ATOM    268  O   SER    47      20.932  14.398  14.248  1.00 14.54           O  
ATOM    269  CB  SER    47      19.277  11.857  14.108  1.00 11.08           C  
ATOM    270  OG  SER    47      19.928  10.995  13.176  1.00 14.23           O  
ATOM    271  N   SER    48      20.890  13.926  12.065  1.00 12.35           N  
ATOM    272  CA  SER    48      22.264  14.391  11.892  0.50 12.78           C  
ATOM    274  C   SER    48      22.363  15.908  11.904  1.00 12.43           C  
ATOM    275  O   SER    48      21.495  16.587  11.361  1.00 16.33           O  
ATOM    276  CB  SER    48      22.855  13.821  10.613  0.50 13.15           C  
ATOM    278  OG  SER    48      22.792  12.407  10.651  0.50 12.11           O  
ATOM    280  N   PRO    49      23.431  16.454  12.534  1.00 13.69           N  
ATOM    281  CA  PRO    49      24.584  15.838  13.196  1.00 14.45           C  
ATOM    282  C   PRO    49      24.402  15.350  14.622  1.00 15.17           C  
ATOM    283  O   PRO    49      25.297  14.696  15.125  1.00 18.41           O  
ATOM    284  CB  PRO    49      25.646  16.960  13.158  1.00 13.96           C  
ATOM    285  CG  PRO    49      24.828  18.216  13.270  1.00 16.02           C  
ATOM    286  CD  PRO    49      23.555  17.932  12.489  1.00 16.62           C  
ATOM    287  N   GLY    50      23.286  15.668  15.282  1.00 14.24           N  
ATOM    288  CA  GLY    50      23.063  15.082  16.608  1.00 11.34           C  
ATOM    289  C   GLY    50      22.701  16.000  17.754  1.00 13.31           C  
ATOM    290  O   GLY    50      22.751  15.585  18.900  1.00 13.91           O  
ATOM    291  N   GLY    51      22.342  17.254  17.466  1.00 12.78           N  
ATOM    292  CA  GLY    51      21.909  18.171  18.531  1.00 12.63           C  
ATOM    293  C   GLY    51      20.682  17.708  19.307  1.00 13.36           C  
ATOM    294  O   GLY    51      20.701  17.634  20.539  1.00 13.73           O  
ATOM    295  N   TRP    52      19.601  17.405  18.587  1.00 11.89           N  
ATOM    296  CA  TRP    52      18.441  16.839  19.275  1.00 11.79           C  
ATOM    297  C   TRP    52      18.798  15.531  19.953  1.00 11.80           C  
ATOM    298  O   TRP    52      18.345  15.262  21.057  1.00 13.79           O  
ATOM    299  CB  TRP    52      17.276  16.596  18.323  1.00 12.99           C  
ATOM    300  CG  TRP    52      16.480  17.814  17.965  1.00 13.11           C  
ATOM    301  CD1 TRP    52      16.894  19.126  17.985  1.00 11.58           C  
ATOM    302  CD2 TRP    52      15.125  17.829  17.523  1.00 12.99           C  
ATOM    303  NE1 TRP    52      15.878  19.948  17.579  1.00 13.19           N  
ATOM    304  CE2 TRP    52      14.777  19.177  17.287  1.00 13.10           C  
ATOM    305  CE3 TRP    52      14.164  16.825  17.299  1.00 13.89           C  
ATOM    306  CZ2 TRP    52      13.496  19.554  16.851  1.00 12.31           C  
ATOM    307  CZ3 TRP    52      12.906  17.193  16.854  1.00 14.51           C  
ATOM    308  CH2 TRP    52      12.586  18.547  16.632  1.00 12.23           C  
ATOM    309  N   THR    53      19.602  14.703  19.281  1.00 11.88           N  
ATOM    310  CA  THR    53      19.935  13.386  19.848  1.00 13.53           C  
ATOM    311  C   THR    53      20.637  13.514  21.192  1.00 11.78           C  
ATOM    312  O   THR    53      20.307  12.798  22.142  1.00 15.17           O  
ATOM    313  CB  THR    53      20.836  12.558  18.891  1.00 13.39           C  
ATOM    314  OG1 THR    53      20.362  12.667  17.548  1.00 15.73           O  
ATOM    315  CG2 THR    53      20.864  11.092  19.305  1.00 15.16           C  
ATOM    316  N   GLN    54      21.570  14.460  21.279  1.00 13.11           N  
ATOM    317  CA  GLN    54      22.293  14.685  22.521  1.00 14.80           C  
ATOM    318  C   GLN    54      21.366  15.235  23.616  1.00 14.98           C  
ATOM    319  O   GLN    54      21.513  14.867  24.783  1.00 17.30           O  
ATOM    320  CB  GLN    54      23.494  15.605  22.274  1.00 15.90           C  
ATOM    321  CG  GLN    54      24.615  14.902  21.537  1.00 17.43           C  
ATOM    322  CD  GLN    54      25.871  15.739  21.359  1.00 23.10           C  
ATOM    323  OE1 GLN    54      26.032  16.792  21.966  1.00 27.50           O  
ATOM    324  NE2 GLN    54      26.777  15.252  20.521  1.00 36.12           N  
ATOM    325  N   VAL    55      20.407  16.085  23.253  1.00 13.38           N  
ATOM    326  CA  VAL    55      19.436  16.577  24.224  1.00 13.23           C  
ATOM    327  C   VAL    55      18.549  15.413  24.682  1.00 16.58           C  
ATOM    328  O   VAL    55      18.325  15.241  25.881  1.00 19.21           O  
ATOM    329  CB  VAL    55      18.568  17.734  23.646  1.00 14.91           C  
ATOM    330  CG1 VAL    55      17.342  18.049  24.540  1.00 15.77           C  
ATOM    331  CG2 VAL    55      19.428  18.996  23.464  1.00 18.22           C  
ATOM    332  N   LEU    56      18.064  14.627  23.718  1.00 13.47           N  
ATOM    333  CA  LEU    56      17.193  13.485  24.034  1.00 16.57           C  
ATOM    334  C   LEU    56      17.903  12.413  24.853  1.00 14.44           C  
ATOM    335  O   LEU    56      17.277  11.761  25.667  1.00 13.36           O  
ATOM    336  CB  LEU    56      16.608  12.859  22.769  1.00 14.57           C  
ATOM    337  CG  LEU    56      15.627  13.647  21.890  1.00 16.91           C  
ATOM    338  CD1 LEU    56      15.467  12.948  20.538  1.00 18.51           C  
ATOM    339  CD2 LEU    56      14.279  13.842  22.594  1.00 24.21           C  
ATOM    340  N   ASN    57      19.208  12.243  24.651  1.00 16.18           N  
ATOM    341  CA  ASN    57      19.983  11.196  25.321  1.00 15.31           C  
ATOM    342  C   ASN    57      20.077  11.415  26.823  1.00 21.90           C  
ATOM    343  O   ASN    57      20.399  10.493  27.563  1.00 25.60           O  
ATOM    344  CB  ASN    57      21.370  11.128  24.689  1.00 17.13           C  
ATOM    345  CG  ASN    57      22.121   9.851  25.011  1.00 20.72           C  
ATOM    346  OD1 ASN    57      23.343   9.875  25.184  1.00 24.28           O  
ATOM    347  ND2 ASN    57      21.411   8.736  25.084  1.00 17.68           N  
ATOM    348  N   SER    58      19.746  12.635  27.241  1.00 20.84           N  
ATOM    349  CA  SER    58      19.785  13.036  28.646  0.50 22.94           C  
ATOM    351  C   SER    58      18.504  12.628  29.365  1.00 23.93           C  
ATOM    352  O   SER    58      18.425  12.706  30.598  1.00 27.24           O  
ATOM    353  CB  SER    58      20.006  14.557  28.772  0.50 25.02           C  
ATOM    355  OG  SER    58      18.881  15.303  28.321  0.50 21.84           O  
ATOM    357  N   LEU    59      17.512  12.169  28.595  1.00 15.23           N  
ATOM    358  CA  LEU    59      16.141  12.000  29.080  1.00 14.65           C  
ATOM    359  C   LEU    59      15.541  10.635  28.673  1.00 14.87           C  
ATOM    360  O   LEU    59      14.897   9.940  29.474  1.00 15.65           O  
ATOM    361  CB  LEU    59      15.324  13.132  28.429  1.00 25.84           C  
ATOM    362  CG  LEU    59      13.879  13.493  28.741  1.00 25.18           C  
ATOM    363  CD1 LEU    59      13.803  14.181  30.089  1.00 29.94           C  
ATOM    364  CD2 LEU    59      13.301  14.413  27.667  1.00 26.06           C  
ATOM    365  N   ALA    60      15.735  10.265  27.407  1.00 13.09           N  
ATOM    366  CA  ALA    60      15.152   9.037  26.874  1.00 13.19           C  
ATOM    367  C   ALA    60      15.880   7.798  27.391  1.00 12.67           C  
ATOM    368  O   ALA    60      17.097   7.835  27.650  1.00 12.83           O  
ATOM    369  CB  ALA    60      15.211   9.067  25.359  1.00 11.38           C  
ATOM    370  N   ARG    61      15.153   6.674  27.513  1.00 12.32           N  
ATOM    371  CA  ARG    61      15.834   5.402  27.814  1.00 11.46           C  
ATOM    372  C   ARG    61      16.487   4.775  26.579  1.00 10.52           C  
ATOM    373  O   ARG    61      17.451   4.018  26.691  1.00 13.25           O  
ATOM    374  CB  ARG    61      14.887   4.389  28.488  1.00 10.24           C  
ATOM    375  CG  ARG    61      13.912   3.659  27.577  1.00 13.10           C  
ATOM    376  CD  ARG    61      13.040   2.670  28.379  1.00 13.71           C  
ATOM    377  NE  ARG    61      12.274   1.828  27.468  1.00 12.52           N  
ATOM    378  CZ  ARG    61      11.148   2.200  26.863  1.00 10.75           C  
ATOM    379  NH1 ARG    61      10.592   3.392  27.102  1.00 11.33           N  
ATOM    380  NH2 ARG    61      10.528   1.359  26.026  1.00 12.41           N  
ATOM    381  N   LYS    62      15.955   5.090  25.394  1.00 10.76           N  
ATOM    382  CA  LYS    62      16.456   4.537  24.153  1.00 10.80           C  
ATOM    383  C   LYS    62      16.015   5.435  23.008  1.00 10.46           C  
ATOM    384  O   LYS    62      14.887   5.903  22.985  1.00 11.00           O  
ATOM    385  CB  LYS    62      15.908   3.128  23.926  1.00 11.68           C  
ATOM    386  CG  LYS    62      16.537   2.368  22.731  1.00 14.08           C  
ATOM    387  CD  LYS    62      18.069   2.338  22.718  1.00 15.23           C  
ATOM    388  CE  LYS    62      18.694   1.776  24.000  1.00 16.71           C  
ATOM    389  NZ  LYS    62      20.167   1.507  23.839  1.00 19.21           N  
ATOM    390  N   ILE    63      16.956   5.708  22.103  1.00 10.53           N  
ATOM    391  CA  ILE    63      16.669   6.490  20.903  1.00 10.94           C  
ATOM    392  C   ILE    63      17.062   5.657  19.694  1.00 10.88           C  
ATOM    393  O   ILE    63      18.155   5.100  19.632  1.00 11.23           O  
ATOM    394  CB  ILE    63      17.478   7.812  20.873  1.00 11.95           C  
ATOM    395  CG1 ILE    63      17.197   8.628  22.130  1.00 12.48           C  
ATOM    396  CG2 ILE    63      17.111   8.626  19.607  1.00 11.36           C  
ATOM    397  CD1 ILE    63      18.239   9.693  22.421  1.00 14.22           C  
ATOM    398  N   ILE    64      16.164   5.593  18.725  1.00 10.48           N  
ATOM    399  CA  ILE    64      16.486   5.060  17.412  1.00 10.88           C  
ATOM    400  C   ILE    64      16.486   6.269  16.504  1.00 10.93           C  
ATOM    401  O   ILE    64      15.419   6.864  16.260  1.00 11.03           O  
ATOM    402  CB  ILE    64      15.416   4.042  16.960  1.00 11.86           C  
ATOM    403  CG1 ILE    64      15.450   2.832  17.899  1.00 15.49           C  
ATOM    404  CG2 ILE    64      15.662   3.608  15.514  1.00 16.09           C  
ATOM    405  CD1 ILE    64      14.287   1.900  17.713  1.00 19.46           C  
ATOM    406  N   SER    65      17.668   6.635  16.021  1.00 10.83           N  
ATOM    407  CA  SER    65      17.876   7.846  15.224  1.00 10.05           C  
ATOM    408  C   SER    65      18.068   7.492  13.751  1.00 10.66           C  
ATOM    409  O   SER    65      18.777   6.522  13.452  1.00 12.61           O  
ATOM    410  CB  SER    65      19.134   8.568  15.720  1.00 10.73           C  
ATOM    411  OG  SER    65      18.920   9.202  16.979  1.00 13.77           O  
ATOM    412  N   ILE    66      17.450   8.258  12.851  1.00  9.40           N  
ATOM    413  CA  ILE    66      17.439   7.937  11.425  1.00 10.04           C  
ATOM    414  C   ILE    66      17.853   9.169  10.617  1.00 11.20           C  
ATOM    415  O   ILE    66      17.303  10.259  10.835  1.00 11.03           O  
ATOM    416  CB  ILE    66      16.023   7.511  10.961  1.00 10.72           C  
ATOM    417  CG1 ILE    66      15.571   6.266  11.760  1.00 13.63           C  
ATOM    418  CG2 ILE    66      16.044   7.193   9.456  1.00 15.71           C  
ATOM    419  CD1 ILE    66      14.091   5.931  11.698  1.00 16.82           C  
ATOM    420  N   ASP    67      18.776   9.007   9.672  1.00 11.18           N  
ATOM    421  CA  ASP    67      19.114  10.119   8.794  1.00 11.30           C  
ATOM    422  C   ASP    67      19.697   9.605   7.495  1.00 11.71           C  
ATOM    423  O   ASP    67      20.207   8.493   7.440  1.00 12.81           O  
ATOM    424  CB  ASP    67      20.142  11.041   9.475  1.00 13.14           C  
ATOM    425  CG  ASP    67      20.150  12.447   8.900  1.00 12.63           C  
ATOM    426  OD1 ASP    67      20.680  12.687   7.798  1.00 14.91           O  
ATOM    427  OD2 ASP    67      19.609  13.342   9.554  1.00 12.57           O  
ATOM    428  N   LEU    68      19.618  10.433   6.454  1.00 11.57           N  
ATOM    429  CA  LEU    68      20.321  10.139   5.195  1.00 12.52           C  
ATOM    430  C   LEU    68      21.838  10.180   5.347  1.00 15.17           C  
ATOM    431  O   LEU    68      22.553   9.453   4.634  1.00 16.52           O  
ATOM    432  CB  LEU    68      19.948  11.168   4.126  1.00 12.94           C  
ATOM    433  CG  LEU    68      18.525  11.192   3.601  1.00 13.40           C  
ATOM    434  CD1 LEU    68      18.271  12.492   2.840  1.00 16.72           C  
ATOM    435  CD2 LEU    68      18.308  10.018   2.701  1.00 16.24           C  
ATOM    436  N   GLN    69      22.310  11.046   6.234  1.00 14.15           N  
ATOM    437  CA  GLN    69      23.728  11.351   6.393  0.50 15.08           C  
ATOM    439  C   GLN    69      24.290  10.685   7.630  1.00 16.76           C  
ATOM    440  O   GLN    69      23.584  10.523   8.611  1.00 16.67           O  
ATOM    441  CB  GLN    69      23.913  12.867   6.539  0.50 14.48           C  
ATOM    443  CG  GLN    69      23.303  13.684   5.409  0.50 17.02           C  
ATOM    445  CD  GLN    69      23.454  15.188   5.597  0.50 21.02           C  
ATOM    447  OE1 GLN    69      24.102  15.855   4.791  0.50 26.25           O  
ATOM    449  NE2 GLN    69      22.855  15.728   6.661  0.50 23.75           N  
ATOM    451  N   GLU    70      25.572  10.325   7.596  1.00 18.94           N  
ATOM    452  CA  GLU    70      26.232   9.832   8.782  1.00 22.18           C  
ATOM    453  C   GLU    70      26.240  10.901   9.868  1.00 20.61           C  
ATOM    454  O   GLU    70      26.174  12.106   9.592  1.00 22.85           O  
ATOM    455  CB  GLU    70      27.677   9.422   8.457  1.00 28.88           C  
ATOM    456  CG  GLU    70      27.852   7.941   8.115  1.00 41.08           C  
ATOM    457  CD  GLU    70      27.435   7.003   9.249  1.00 47.85           C  
ATOM    458  OE1 GLU    70      26.837   5.947   8.953  1.00 44.50           O  
ATOM    459  OE2 GLU    70      27.701   7.316  10.433  1.00 53.10           O  
ATOM    460  N   MET    71      26.268  10.446  11.111  1.00 22.46           N  
ATOM    461  CA  MET    71      26.587  11.326  12.213  1.00 25.42           C  
ATOM    462  C   MET    71      27.448  10.554  13.197  1.00 23.59           C  
ATOM    463  O   MET    71      27.522   9.316  13.134  1.00 26.19           O  
ATOM    464  CB  MET    71      25.322  11.862  12.878  1.00 23.96           C  
ATOM    465  CG  MET    71      24.476  10.818  13.500  1.00 17.30           C  
ATOM    466  SD  MET    71      23.049  11.579  14.604  0.70 26.40          SE  
ATOM    467  CE  MET    71      22.642   9.910  15.033  1.00 10.60           C  
ATOM    468  N   GLU    72      28.096  11.285  14.094  1.00 26.79           N  
ATOM    469  CA  GLU    72      28.953  10.671  15.095  1.00 33.65           C  
ATOM    470  C   GLU    72      28.145   9.796  16.045  1.00 30.46           C  
ATOM    471  O   GLU    72      26.991  10.116  16.373  1.00 25.47           O  
ATOM    472  CB  GLU    72      29.745  11.727  15.868  1.00 37.99           C  
ATOM    473  CG  GLU    72      31.107  12.025  15.258  1.00 50.28           C  
ATOM    474  CD  GLU    72      32.059  12.668  16.247  1.00 59.79           C  
ATOM    475  OE1 GLU    72      32.889  11.938  16.833  1.00 58.00           O  
ATOM    476  OE2 GLU    72      31.968  13.900  16.446  1.00 64.90           O  
ATOM    477  N   GLU    73      28.759   8.679  16.436  1.00 31.06           N  
ATOM    478  CA  GLU    73      28.176   7.737  17.389  1.00 33.36           C  
ATOM    479  C   GLU    73      27.967   8.371  18.761  1.00 28.63           C  
ATOM    480  O   GLU    73      28.727   9.226  19.207  1.00 23.68           O  
ATOM    481  CB  GLU    73      29.018   6.449  17.491  1.00 36.66           C  
ATOM    482  CG  GLU    73      30.441   6.610  18.065  1.00 54.51           C  
ATOM    483  CD  GLU    73      31.506   7.002  17.029  1.00 65.94           C  
ATOM    484  OE1 GLU    73      31.163   7.273  15.854  1.00 68.44           O  
ATOM    485  OE2 GLU    73      32.701   7.039  17.403  1.00 69.26           O  
ATOM    486  N   ILE    74      26.872   7.991  19.401  1.00 22.88           N  
ATOM    487  CA  ILE    74      26.562   8.449  20.743  1.00 19.83           C  
ATOM    488  C   ILE    74      26.268   7.153  21.468  1.00 21.56           C  
ATOM    489  O   ILE    74      25.559   6.292  20.937  1.00 20.26           O  
ATOM    490  CB  ILE    74      25.373   9.459  20.768  1.00 18.50           C  
ATOM    491  CG1 ILE    74      25.750  10.731  20.004  1.00 19.31           C  
ATOM    492  CG2 ILE    74      25.007   9.835  22.203  1.00 19.70           C  
ATOM    493  CD1 ILE    74      24.565  11.626  19.648  1.00 16.30           C  
ATOM    494  N   ALA    75      26.864   6.985  22.648  1.00 20.90           N  
ATOM    495  CA  ALA    75      26.737   5.721  23.362  1.00 24.22           C  
ATOM    496  C   ALA    75      25.269   5.387  23.594  1.00 16.89           C  
ATOM    497  O   ALA    75      24.505   6.211  24.078  1.00 19.33           O  
ATOM    498  CB  ALA    75      27.493   5.779  24.688  1.00 24.81           C  
ATOM    499  N   GLY    76      24.889   4.172  23.202  1.00 19.08           N  
ATOM    500  CA  GLY    76      23.548   3.677  23.464  1.00 17.20           C  
ATOM    501  C   GLY    76      22.463   4.103  22.491  1.00 15.30           C  
ATOM    502  O   GLY    76      21.329   3.646  22.609  1.00 15.69           O  
ATOM    503  N   VAL    77      22.806   4.973  21.542  1.00 14.31           N  
ATOM    504  CA  VAL    77      21.842   5.431  20.531  1.00 13.17           C  
ATOM    505  C   VAL    77      21.950   4.492  19.341  1.00 13.37           C  
ATOM    506  O   VAL    77      23.080   4.158  18.899  1.00 15.18           O  
ATOM    507  CB  VAL    77      22.116   6.883  20.066  1.00 12.43           C  
ATOM    508  CG1 VAL    77      21.270   7.236  18.841  1.00 12.61           C  
ATOM    509  CG2 VAL    77      21.880   7.889  21.205  1.00 14.75           C  
ATOM    510  N   ARG    78      20.800   4.033  18.840  1.00 11.93           N  
ATOM    511  CA  ARG    78      20.811   3.143  17.711  1.00 12.60           C  
ATOM    512  C   ARG    78      20.600   3.982  16.467  1.00 14.57           C  
ATOM    513  O   ARG    78      19.518   4.500  16.242  1.00 15.17           O  
ATOM    514  CB  ARG    78      19.687   2.130  17.870  1.00 13.99           C  
ATOM    515  CG  ARG    78      19.597   1.139  16.749  1.00 22.12           C  
ATOM    516  CD  ARG    78      18.604   0.066  17.103  1.00 33.92           C  
ATOM    517  NE  ARG    78      19.095  -0.893  18.091  1.00 36.42           N  
ATOM    518  CZ  ARG    78      19.566  -2.102  17.801  1.00 40.20           C  
ATOM    519  NH1 ARG    78      19.627  -2.522  16.538  1.00 33.04           N  
ATOM    520  NH2 ARG    78      19.979  -2.893  18.783  1.00 34.30           N  
ATOM    521  N   PHE    79      21.639   4.139  15.673  1.00 12.80           N  
ATOM    522  CA  PHE    79      21.557   4.970  14.492  1.00 12.11           C  
ATOM    523  C   PHE    79      21.322   4.109  13.255  1.00 15.59           C  
ATOM    524  O   PHE    79      21.970   3.080  13.073  1.00 18.23           O  
ATOM    525  CB  PHE    79      22.824   5.823  14.349  1.00 13.66           C  
ATOM    526  CG  PHE    79      22.852   6.660  13.095  1.00 13.92           C  
ATOM    527  CD1 PHE    79      21.877   7.611  12.857  1.00 14.07           C  
ATOM    528  CD2 PHE    79      23.848   6.472  12.138  1.00 16.12           C  
ATOM    529  CE1 PHE    79      21.892   8.377  11.684  1.00 14.81           C  
ATOM    530  CE2 PHE    79      23.858   7.213  10.961  1.00 19.04           C  
ATOM    531  CZ  PHE    79      22.879   8.168  10.732  1.00 18.26           C  
ATOM    532  N   ILE    80      20.403   4.548  12.398  1.00 13.67           N  
ATOM    533  CA  ILE    80      20.103   3.867  11.146  1.00 14.45           C  
ATOM    534  C   ILE    80      20.258   4.895  10.030  1.00 14.03           C  
ATOM    535  O   ILE    80      19.560   5.907  10.008  1.00 13.61           O  
ATOM    536  CB  ILE    80      18.662   3.349  11.105  1.00 13.42           C  
ATOM    537  CG1 ILE    80      18.360   2.431  12.311  1.00 16.58           C  
ATOM    538  CG2 ILE    80      18.406   2.615   9.777  1.00 18.22           C  
ATOM    539  CD1 ILE    80      16.914   2.000  12.421  1.00 19.95           C  
ATOM    540  N   ARG    81      21.150   4.631   9.083  1.00 13.88           N  
ATOM    541  CA  ARG    81      21.227   5.441   7.874  1.00 13.30           C  
ATOM    542  C   ARG    81      20.158   4.928   6.915  1.00 15.06           C  
ATOM    543  O   ARG    81      20.173   3.759   6.520  1.00 13.56           O  
ATOM    544  CB  ARG    81      22.615   5.338   7.223  1.00 16.75           C  
ATOM    545  CG  ARG    81      23.450   6.594   7.390  1.00 33.80           C  
ATOM    546  CD  ARG    81      24.652   6.576   6.480  1.00 32.17           C  
ATOM    547  NE  ARG    81      24.561   7.513   5.368  1.00 23.99           N  
ATOM    548  CZ  ARG    81      25.551   7.722   4.507  1.00 24.73           C  
ATOM    549  NH1 ARG    81      26.692   7.059   4.649  1.00 32.42           N  
ATOM    550  NH2 ARG    81      25.417   8.590   3.517  1.00 33.32           N  
ATOM    551  N   CYS    82      19.225   5.793   6.535  1.00 12.53           N  
ATOM    552  CA  CYS    82      18.074   5.359   5.777  1.00 13.00           C  
ATOM    553  C   CYS    82      17.358   6.563   5.184  1.00 13.41           C  
ATOM    554  O   CYS    82      17.306   7.620   5.834  1.00 14.05           O  
ATOM    555  CB  CYS    82      17.112   4.609   6.690  1.00 14.25           C  
ATOM    556  SG  CYS    82      15.720   3.923   5.762  1.00 19.53           S  
ATOM    557  N   ASP    83      16.812   6.411   3.971  1.00 11.70           N  
ATOM    558  CA  ASP    83      15.918   7.424   3.426  1.00 13.14           C  
ATOM    559  C   ASP    83      14.520   6.983   3.823  1.00 12.87           C  
ATOM    560  O   ASP    83      14.055   5.923   3.397  1.00 13.51           O  
ATOM    561  CB  ASP    83      16.049   7.465   1.892  1.00 11.45           C  
ATOM    562  CG  ASP    83      15.148   8.506   1.230  1.00 15.18           C  
ATOM    563  OD1 ASP    83      14.130   8.930   1.810  1.00 14.62           O  
ATOM    564  OD2 ASP    83      15.471   8.904   0.089  1.00 18.70           O  
ATOM    565  N   ILE    84      13.815   7.793   4.614  1.00 12.08           N  
ATOM    566  CA  ILE    84      12.487   7.374   5.080  1.00 10.97           C  
ATOM    567  C   ILE    84      11.473   7.126   3.959  1.00 13.47           C  
ATOM    568  O   ILE    84      10.482   6.462   4.189  1.00 13.31           O  
ATOM    569  CB  ILE    84      11.885   8.365   6.121  1.00 13.38           C  
ATOM    570  CG1 ILE    84      11.602   9.759   5.495  1.00 12.86           C  
ATOM    571  CG2 ILE    84      12.798   8.462   7.361  1.00 13.54           C  
ATOM    572  CD1 ILE    84      10.751  10.702   6.380  1.00 14.69           C  
ATOM    573  N   PHE    85      11.714   7.676   2.777  1.00 13.02           N  
ATOM    574  CA  PHE    85      10.765   7.515   1.662  1.00 12.85           C  
ATOM    575  C   PHE    85      10.973   6.201   0.908  1.00 15.25           C  
ATOM    576  O   PHE    85      10.124   5.806   0.095  1.00 17.25           O  
ATOM    577  CB  PHE    85      10.912   8.669   0.671  1.00 12.29           C  
ATOM    578  CG  PHE    85      10.433   9.989   1.201  1.00 11.32           C  
ATOM    579  CD1 PHE    85       9.089  10.185   1.493  1.00 12.76           C  
ATOM    580  CD2 PHE    85      11.325  11.028   1.391  1.00 11.72           C  
ATOM    581  CE1 PHE    85       8.653  11.410   1.982  1.00 15.78           C  
ATOM    582  CE2 PHE    85      10.888  12.257   1.881  1.00 14.28           C  
ATOM    583  CZ  PHE    85       9.542  12.440   2.161  1.00 16.43           C  
ATOM    584  N   LYS    86      12.090   5.521   1.161  1.00 15.12           N  
ATOM    585  CA  LYS    86      12.431   4.349   0.368  1.00 15.16           C  
ATOM    586  C   LYS    86      11.876   3.069   1.009  1.00 15.80           C  
ATOM    587  O   LYS    86      11.010   3.133   1.883  1.00 17.52           O  
ATOM    588  CB  LYS    86      13.945   4.285   0.104  1.00 15.21           C  
ATOM    589  CG  LYS    86      14.498   5.434  -0.749  1.00 18.74           C  
ATOM    590  CD  LYS    86      13.847   5.550  -2.129  1.00 25.60           C  
ATOM    591  CE  LYS    86      14.376   6.798  -2.845  1.00 30.31           C  
ATOM    592  NZ  LYS    86      13.560   7.154  -4.039  1.00 39.14           N  
ATOM    593  N   GLU    87      12.352   1.907   0.555  1.00 14.35           N  
ATOM    594  CA  GLU    87      11.668   0.641   0.825  1.00 18.83           C  
ATOM    595  C   GLU    87      12.058  -0.083   2.092  1.00 16.10           C  
ATOM    596  O   GLU    87      11.344  -1.014   2.497  1.00 18.86           O  
ATOM    597  CB  GLU    87      11.829  -0.343  -0.352  1.00 16.40           C  
ATOM    598  CG  GLU    87      11.473   0.263  -1.727  1.00 24.26           C  
ATOM    599  CD  GLU    87      11.768  -0.673  -2.915  1.00 32.24           C  
ATOM    600  OE1 GLU    87      12.880  -1.247  -3.018  1.00 22.27           O  
ATOM    601  OE2 GLU    87      10.871  -0.822  -3.769  1.00 38.54           O  
ATOM    602  N   THR    88      13.181   0.284   2.702  1.00 14.31           N  
ATOM    603  CA  THR    88      13.659  -0.478   3.865  1.00 12.35           C  
ATOM    604  C   THR    88      13.197   0.081   5.223  1.00 14.22           C  
ATOM    605  O   THR    88      13.419  -0.547   6.228  1.00 14.68           O  
ATOM    606  CB  THR    88      15.204  -0.564   3.925  1.00 13.50           C  
ATOM    607  OG1 THR    88      15.751   0.750   4.057  1.00 14.98           O  
ATOM    608  CG2 THR    88      15.779  -1.252   2.680  1.00 16.24           C  
ATOM    609  N   ILE    89      12.594   1.267   5.235  1.00 12.41           N  
ATOM    610  CA  ILE    89      12.386   2.013   6.486  1.00 11.93           C  
ATOM    611  C   ILE    89      11.652   1.215   7.561  1.00 13.83           C  
ATOM    612  O   ILE    89      12.071   1.204   8.727  1.00 13.99           O  
ATOM    613  CB  ILE    89      11.719   3.394   6.209  1.00 14.69           C  
ATOM    614  CG1 ILE    89      11.573   4.220   7.504  1.00 12.66           C  
ATOM    615  CG2 ILE    89      10.379   3.264   5.465  1.00 15.13           C  
ATOM    616  CD1 ILE    89      12.869   4.423   8.248  1.00 14.32           C  
ATOM    617  N   PHE    90      10.607   0.498   7.154  1.00 14.71           N  
ATOM    618  CA  PHE    90       9.821  -0.247   8.141  1.00 14.60           C  
ATOM    619  C   PHE    90      10.538  -1.480   8.612  1.00 16.51           C  
ATOM    620  O   PHE    90      10.508  -1.789   9.792  1.00 16.36           O  
ATOM    621  CB  PHE    90       8.431  -0.572   7.621  1.00 14.85           C  
ATOM    622  CG  PHE    90       7.667   0.634   7.185  1.00 15.88           C  
ATOM    623  CD1 PHE    90       7.239   1.592   8.107  1.00 17.54           C  
ATOM    624  CD2 PHE    90       7.402   0.845   5.835  1.00 19.99           C  
ATOM    625  CE1 PHE    90       6.530   2.729   7.673  1.00 20.12           C  
ATOM    626  CE2 PHE    90       6.701   1.964   5.402  1.00 24.98           C  
ATOM    627  CZ  PHE    90       6.264   2.908   6.314  1.00 18.82           C  
ATOM    628  N   ASP    91      11.219  -2.166   7.698  1.00 13.68           N  
ATOM    629  CA  ASP    91      12.028  -3.312   8.096  1.00 13.68           C  
ATOM    630  C   ASP    91      13.162  -2.919   9.047  1.00 14.80           C  
ATOM    631  O   ASP    91      13.516  -3.670   9.977  1.00 16.34           O  
ATOM    632  CB  ASP    91      12.633  -3.997   6.862  1.00 17.52           C  
ATOM    633  CG  ASP    91      11.588  -4.694   5.996  1.00 24.50           C  
ATOM    634  OD1 ASP    91      10.492  -5.018   6.497  1.00 21.30           O  
ATOM    635  OD2 ASP    91      11.869  -4.923   4.799  1.00 25.94           O  
ATOM    636  N   ASP    92      13.744  -1.741   8.792  1.00 13.74           N  
ATOM    637  CA  ASP    92      14.841  -1.220   9.576  1.00 12.72           C  
ATOM    638  C   ASP    92      14.374  -0.880  10.980  1.00 13.13           C  
ATOM    639  O   ASP    92      15.044  -1.216  11.962  1.00 14.01           O  
ATOM    640  CB  ASP    92      15.394   0.057   8.928  1.00 13.56           C  
ATOM    641  CG  ASP    92      16.180  -0.193   7.654  1.00 17.23           C  
ATOM    642  OD1 ASP    92      16.647  -1.335   7.426  1.00 16.56           O  
ATOM    643  OD2 ASP    92      16.330   0.788   6.886  1.00 16.08           O  
ATOM    644  N   ILE    93      13.230  -0.204  11.067  1.00 12.18           N  
ATOM    645  CA  ILE    93      12.724   0.159  12.399  1.00 14.15           C  
ATOM    646  C   ILE    93      12.235  -1.093  13.129  1.00 17.32           C  
ATOM    647  O   ILE    93      12.549  -1.268  14.324  1.00 15.16           O  
ATOM    648  CB  ILE    93      11.617   1.219  12.327  1.00 13.03           C  
ATOM    649  CG1 ILE    93      12.191   2.564  11.848  1.00 12.61           C  
ATOM    650  CG2 ILE    93      11.000   1.412  13.719  1.00 14.05           C  
ATOM    651  CD1 ILE    93      11.121   3.600  11.455  1.00 12.35           C  
ATOM    652  N   ASP    94      11.502  -1.963  12.419  1.00 14.05           N  
ATOM    653  CA  ASP    94      11.083  -3.250  13.017  1.00 16.18           C  
ATOM    654  C   ASP    94      12.256  -3.979  13.665  1.00 15.42           C  
ATOM    655  O   ASP    94      12.155  -4.422  14.814  1.00 17.28           O  
ATOM    656  CB  ASP    94      10.513  -4.217  11.974  1.00 17.07           C  
ATOM    657  CG  ASP    94       9.121  -3.855  11.489  1.00 17.35           C  
ATOM    658  OD1 ASP    94       8.505  -2.885  11.987  1.00 18.27           O  
ATOM    659  OD2 ASP    94       8.633  -4.548  10.555  1.00 21.85           O  
ATOM    660  N   ARG    95      13.367  -4.122  12.932  1.00 15.58           N  
ATOM    661  CA  ARG    95      14.535  -4.842  13.428  1.00 16.07           C  
ATOM    662  C   ARG    95      15.118  -4.171  14.663  1.00 19.11           C  
ATOM    663  O   ARG    95      15.440  -4.833  15.641  1.00 18.91           O  
ATOM    664  CB  ARG    95      15.615  -4.981  12.348  1.00 20.99           C  
ATOM    665  CG  ARG    95      16.734  -5.950  12.716  1.00 29.41           C  
ATOM    666  CD  ARG    95      17.846  -6.022  11.666  1.00 35.92           C  
ATOM    667  NE  ARG    95      19.041  -5.272  12.063  1.00 53.69           N  
ATOM    668  CZ  ARG    95      20.279  -5.526  11.631  1.00 57.40           C  
ATOM    669  NH1 ARG    95      20.511  -6.528  10.781  1.00 50.29           N  
ATOM    670  NH2 ARG    95      21.295  -4.777  12.056  1.00 50.88           N  
ATOM    671  N   ALA    96      15.224  -2.839  14.627  1.00 15.34           N  
ATOM    672  CA  ALA    96      15.780  -2.102  15.748  1.00 15.93           C  
ATOM    673  C   ALA    96      14.919  -2.271  17.000  1.00 16.84           C  
ATOM    674  O   ALA    96      15.439  -2.511  18.081  1.00 17.65           O  
ATOM    675  CB  ALA    96      15.873  -0.633  15.370  1.00 16.45           C  
ATOM    676  N   LEU    97      13.605  -2.139  16.847  1.00 15.40           N  
ATOM    677  CA  LEU    97      12.680  -2.321  17.994  1.00 13.08           C  
ATOM    678  C   LEU    97      12.750  -3.730  18.579  1.00 16.91           C  
ATOM    679  O   LEU    97      12.794  -3.905  19.802  1.00 16.10           O  
ATOM    680  CB  LEU    97      11.253  -1.987  17.596  1.00 13.95           C  
ATOM    681  CG  LEU    97      11.014  -0.503  17.284  1.00 15.23           C  
ATOM    682  CD1 LEU    97       9.596  -0.311  16.828  1.00 17.81           C  
ATOM    683  CD2 LEU    97      11.298   0.351  18.487  1.00 16.90           C  
ATOM    684  N   ARG    98      12.784  -4.716  17.691  1.00 19.05           N  
ATOM    685  CA  ARG    98      12.877  -6.131  18.092  1.00 20.68           C  
ATOM    686  C   ARG    98      14.131  -6.358  18.933  1.00 20.56           C  
ATOM    687  O   ARG    98      14.065  -6.934  20.021  1.00 20.37           O  
ATOM    688  CB  ARG    98      12.881  -7.022  16.843  1.00 19.15           C  
ATOM    689  CG  ARG    98      12.874  -8.519  17.105  1.00 36.63           C  
ATOM    690  CD  ARG    98      12.535  -9.327  15.828  1.00 35.92           C  
ATOM    691  NE  ARG    98      13.244  -8.889  14.616  1.00 42.00           N  
ATOM    692  CZ  ARG    98      12.657  -8.384  13.527  1.00 49.87           C  
ATOM    693  NH1 ARG    98      11.336  -8.239  13.470  1.00 49.31           N  
ATOM    694  NH2 ARG    98      13.394  -8.022  12.482  1.00 44.13           N  
ATOM    695  N   GLU    99      15.250  -5.823  18.468  1.00 16.76           N  
ATOM    696  CA  GLU    99      16.506  -5.965  19.184  1.00 18.98           C  
ATOM    697  C   GLU    99      16.523  -5.234  20.527  1.00 21.82           C  
ATOM    698  O   GLU    99      17.222  -5.656  21.456  1.00 22.66           O  
ATOM    699  CB  GLU    99      17.666  -5.544  18.293  1.00 20.90           C  
ATOM    700  CG  GLU    99      17.841  -6.543  17.134  1.00 26.92           C  
ATOM    701  CD  GLU    99      18.967  -6.203  16.182  1.00 37.81           C  
ATOM    702  OE1 GLU    99      19.767  -5.310  16.503  1.00 37.69           O  
ATOM    703  OE2 GLU    99      19.052  -6.841  15.109  1.00 39.69           O  
ATOM    704  N   GLU   100      15.730  -4.167  20.641  1.00 17.11           N  
ATOM    705  CA  GLU   100      15.619  -3.454  21.902  1.00 17.75           C  
ATOM    706  C   GLU   100      14.556  -4.001  22.837  1.00 16.86           C  
ATOM    707  O   GLU   100      14.469  -3.550  23.983  1.00 20.47           O  
ATOM    708  CB  GLU   100      15.371  -1.964  21.640  1.00 18.83           C  
ATOM    709  CG  GLU   100      16.493  -1.253  20.883  1.00 18.10           C  
ATOM    710  CD  GLU   100      17.824  -1.244  21.638  1.00 31.26           C  
ATOM    711  OE1 GLU   100      17.809  -1.279  22.895  1.00 24.65           O  
ATOM    712  OE2 GLU   100      18.883  -1.200  20.968  1.00 30.33           O  
ATOM    713  N   GLY   101      13.760  -4.962  22.366  1.00 15.44           N  
ATOM    714  CA  GLY   101      12.667  -5.499  23.175  1.00 15.63           C  
ATOM    715  C   GLY   101      11.522  -4.517  23.332  1.00 15.58           C  
ATOM    716  O   GLY   101      10.802  -4.537  24.330  1.00 18.18           O  
ATOM    717  N   ILE   102      11.326  -3.662  22.335  1.00 14.55           N  
ATOM    718  CA  ILE   102      10.278  -2.661  22.376  1.00 12.71           C  
ATOM    719  C   ILE   102       9.208  -3.041  21.358  1.00 15.93           C  
ATOM    720  O   ILE   102       9.564  -3.350  20.214  1.00 16.82           O  
ATOM    721  CB  ILE   102      10.837  -1.270  22.004  1.00 13.71           C  
ATOM    722  CG1 ILE   102      11.898  -0.824  23.021  1.00 15.46           C  
ATOM    723  CG2 ILE   102       9.698  -0.240  21.874  1.00 13.97           C  
ATOM    724  CD1 ILE   102      12.686   0.444  22.609  1.00 13.84           C  
ATOM    725  N   GLU   103       7.930  -3.051  21.762  1.00 14.80           N  
ATOM    726  CA  GLU   103       6.819  -3.287  20.834  1.00 14.37           C  
ATOM    727  C   GLU   103       6.346  -1.975  20.207  1.00 16.25           C  
ATOM    728  O   GLU   103       6.170  -1.894  18.980  1.00 16.50           O  
ATOM    729  CB  GLU   103       5.666  -4.007  21.536  1.00 14.59           C  
ATOM    730  CG  GLU   103       4.478  -4.362  20.618  1.00 23.31           C  
ATOM    731  CD  GLU   103       4.731  -5.541  19.690  1.00 38.88           C  
ATOM    732  OE1 GLU   103       5.747  -6.263  19.848  1.00 40.58           O  
ATOM    733  OE2 GLU   103       3.890  -5.744  18.787  1.00 44.02           O  
ATOM    734  N   LYS   104       6.144  -0.967  21.058  1.00 11.97           N  
ATOM    735  CA  LYS   104       5.641   0.354  20.654  1.00 12.65           C  
ATOM    736  C   LYS   104       6.441   1.416  21.368  1.00 12.46           C  
ATOM    737  O   LYS   104       6.720   1.289  22.552  1.00 12.40           O  
ATOM    738  CB  LYS   104       4.160   0.551  20.980  1.00 14.66           C  
ATOM    739  CG  LYS   104       3.184  -0.415  20.278  1.00 15.66           C  
ATOM    740  CD  LYS   104       3.093  -0.147  18.783  1.00 17.92           C  
ATOM    741  CE  LYS   104       1.964  -0.991  18.176  1.00 18.93           C  
ATOM    742  NZ  LYS   104       1.927  -0.784  16.721  1.00 22.15           N  
ATOM    743  N   VAL   105       6.847   2.455  20.631  1.00 12.16           N  
ATOM    744  CA  VAL   105       7.670   3.513  21.208  1.00 10.51           C  
ATOM    745  C   VAL   105       6.772   4.544  21.856  1.00  9.96           C  
ATOM    746  O   VAL   105       5.568   4.609  21.587  1.00 12.50           O  
ATOM    747  CB  VAL   105       8.559   4.211  20.136  1.00 11.01           C  
ATOM    748  CG1 VAL   105       9.606   3.235  19.613  1.00 13.10           C  
ATOM    749  CG2 VAL   105       7.688   4.808  19.026  1.00 12.29           C  
ATOM    750  N   ASP   106       7.380   5.387  22.687  1.00 11.09           N  
ATOM    751  CA  ASP   106       6.613   6.395  23.402  1.00  9.99           C  
ATOM    752  C   ASP   106       6.445   7.655  22.573  1.00 12.17           C  
ATOM    753  O   ASP   106       5.420   8.311  22.669  1.00 12.24           O  
ATOM    754  CB  ASP   106       7.297   6.743  24.721  1.00 11.76           C  
ATOM    755  CG  ASP   106       7.472   5.526  25.608  1.00 10.29           C  
ATOM    756  OD1 ASP   106       6.536   5.239  26.395  1.00 14.19           O  
ATOM    757  OD2 ASP   106       8.523   4.866  25.562  1.00 10.87           O  
ATOM    758  N   ASP   107       7.462   8.022  21.776  1.00 10.50           N  
ATOM    759  CA  ASP   107       7.385   9.240  20.937  1.00 11.36           C  
ATOM    760  C   ASP   107       8.046   9.027  19.596  1.00  9.58           C  
ATOM    761  O   ASP   107       8.985   8.248  19.481  1.00 10.07           O  
ATOM    762  CB  ASP   107       8.101  10.413  21.595  1.00 11.91           C  
ATOM    763  CG  ASP   107       7.779  10.538  23.051  1.00 11.98           C  
ATOM    764  OD1 ASP   107       6.625  10.852  23.399  1.00 15.21           O  
ATOM    765  OD2 ASP   107       8.690  10.276  23.851  1.00 13.81           O  
ATOM    766  N   VAL   108       7.560   9.755  18.589  1.00  9.74           N  
ATOM    767  CA  VAL   108       8.268   9.888  17.329  1.00  8.61           C  
ATOM    768  C   VAL   108       8.518  11.387  17.167  1.00 11.05           C  
ATOM    769  O   VAL   108       7.583  12.208  17.282  1.00 11.94           O  
ATOM    770  CB  VAL   108       7.426   9.325  16.155  1.00 11.46           C  
ATOM    771  CG1 VAL   108       8.110   9.616  14.804  1.00 14.09           C  
ATOM    772  CG2 VAL   108       7.177   7.803  16.292  1.00 14.03           C  
ATOM    773  N   VAL   109       9.778  11.775  16.978  1.00  9.92           N  
ATOM    774  CA  VAL   109      10.097  13.186  16.779  1.00 11.54           C  
ATOM    775  C   VAL   109      10.829  13.345  15.470  1.00 10.98           C  
ATOM    776  O   VAL   109      11.574  12.456  15.072  1.00 12.56           O  
ATOM    777  CB  VAL   109      10.912  13.788  17.938  1.00 11.55           C  
ATOM    778  CG1 VAL   109      10.234  13.524  19.285  1.00 14.62           C  
ATOM    779  CG2 VAL   109      12.324  13.234  17.963  1.00 13.66           C  
ATOM    780  N   SER   110      10.605  14.469  14.782  1.00  9.10           N  
ATOM    781  CA  SER   110      11.280  14.712  13.524  1.00  9.63           C  
ATOM    782  C   SER   110      11.697  16.168  13.394  1.00  9.21           C  
ATOM    783  O   SER   110      10.871  17.076  13.572  1.00 10.64           O  
ATOM    784  CB  SER   110      10.339  14.386  12.377  1.00 11.38           C  
ATOM    785  OG  SER   110      10.906  14.752  11.108  1.00 12.49           O  
ATOM    786  N   ASP   111      12.975  16.367  13.054  1.00  9.78           N  
ATOM    787  CA  ASP   111      13.502  17.661  12.628  1.00 10.30           C  
ATOM    788  C   ASP   111      13.948  17.541  11.174  1.00 12.59           C  
ATOM    789  O   ASP   111      14.731  18.370  10.700  1.00 14.21           O  
ATOM    790  CB  ASP   111      14.678  18.042  13.517  1.00 12.34           C  
ATOM    791  CG  ASP   111      14.999  19.521  13.476  1.00 17.14           C  
ATOM    792  OD1 ASP   111      14.082  20.342  13.247  1.00 16.72           O  
ATOM    793  OD2 ASP   111      16.181  19.859  13.708  1.00 19.06           O  
ATOM    794  N   ALA   112      13.454  16.527  10.465  1.00 11.25           N  
ATOM    795  CA  ALA   112      13.892  16.275   9.078  1.00 11.10           C  
ATOM    796  C   ALA   112      13.422  17.377   8.141  1.00 13.86           C  
ATOM    797  O   ALA   112      12.283  17.843   8.214  1.00 13.37           O  
ATOM    798  CB  ALA   112      13.363  14.945   8.591  1.00 11.26           C  
ATOM    799  N   MET   113      14.327  17.730   7.238  1.00 13.40           N  
ATOM    800  CA  MET   113      14.080  18.704   6.191  1.00 13.40           C  
ATOM    801  C   MET   113      15.114  18.498   5.091  1.00 13.11           C  
ATOM    802  O   MET   113      16.267  18.145   5.370  1.00 13.85           O  
ATOM    803  CB  MET   113      14.123  20.131   6.730  1.00 14.46           C  
ATOM    804  CG  MET   113      13.833  21.222   5.677  1.00 13.23           C  
ATOM    805  SD  MET   113      12.116  20.916   4.727  0.70 15.43          SE  
ATOM    806  CE  MET   113      12.287  22.453   3.505  1.00 17.59           C  
ATOM    807  N   ALA   114      14.695  18.720   3.846  1.00 13.67           N  
ATOM    808  CA  ALA   114      15.638  18.631   2.739  1.00 16.40           C  
ATOM    809  C   ALA   114      16.282  19.987   2.529  1.00 15.41           C  
ATOM    810  O   ALA   114      16.163  20.856   3.367  1.00 14.70           O  
ATOM    811  CB  ALA   114      14.941  18.156   1.487  1.00 21.46           C  
ATOM    812  N   LYS   115      16.985  20.170   1.419  1.00 15.14           N  
ATOM    813  CA  LYS   115      17.557  21.487   1.150  1.00 15.78           C  
ATOM    814  C   LYS   115      16.471  22.577   1.046  1.00 13.07           C  
ATOM    815  O   LYS   115      15.398  22.359   0.466  1.00 14.83           O  
ATOM    816  CB  LYS   115      18.384  21.466  -0.133  1.00 17.66           C  
ATOM    817  CG  LYS   115      19.659  20.652  -0.013  1.00 20.06           C  
ATOM    818  CD  LYS   115      20.393  20.629  -1.344  1.00 19.58           C  
ATOM    819  CE  LYS   115      21.714  19.898  -1.250  1.00 29.22           C  
ATOM    820  NZ  LYS   115      22.368  19.836  -2.592  1.00 33.84           N  
ATOM    821  N   VAL   116      16.777  23.723   1.653  1.00 13.59           N  
ATOM    822  CA  VAL   116      15.891  24.882   1.767  0.50 13.96           C  
ATOM    824  C   VAL   116      16.070  25.782   0.530  1.00 15.19           C  
ATOM    825  O   VAL   116      17.210  26.085   0.148  1.00 14.70           O  
ATOM    826  CB  VAL   116      16.231  25.658   3.074  0.50 14.92           C  
ATOM    828  CG1 VAL   116      15.448  26.948   3.196  0.50 15.69           C  
ATOM    830  CG2 VAL   116      15.990  24.771   4.328  0.50 17.33           C  
ATOM    832  N   SER   117      14.963  26.201  -0.072  1.00 13.54           N  
ATOM    833  CA  SER   117      15.001  27.069  -1.247  1.00 11.53           C  
ATOM    834  C   SER   117      14.856  28.544  -0.888  1.00 13.31           C  
ATOM    835  O   SER   117      15.171  29.404  -1.713  1.00 15.65           O  
ATOM    836  CB  SER   117      13.865  26.696  -2.189  1.00 13.27           C  
ATOM    837  OG  SER   117      12.606  27.050  -1.610  1.00 13.68           O  
ATOM    838  N   GLY   118      14.357  28.833   0.316  1.00 13.72           N  
ATOM    839  CA  GLY   118      14.073  30.198   0.724  1.00 17.52           C  
ATOM    840  C   GLY   118      12.734  30.709   0.218  1.00 15.20           C  
ATOM    841  O   GLY   118      12.437  31.912   0.363  1.00 18.36           O  
ATOM    842  N   ILE   119      11.923  29.814  -0.356  1.00 13.99           N  
ATOM    843  CA  ILE   119      10.619  30.178  -0.913  1.00 14.12           C  
ATOM    844  C   ILE   119       9.579  29.446  -0.056  1.00 13.80           C  
ATOM    845  O   ILE   119       9.548  28.229  -0.039  1.00 13.42           O  
ATOM    846  CB  ILE   119      10.467  29.693  -2.378  1.00 11.69           C  
ATOM    847  CG1 ILE   119      11.576  30.223  -3.304  1.00 14.24           C  
ATOM    848  CG2 ILE   119       9.084  30.029  -2.926  1.00 13.99           C  
ATOM    849  CD1 ILE   119      11.731  31.748  -3.313  1.00 16.18           C  
ATOM    850  N   PRO   120       8.764  30.194   0.701  1.00 14.28           N  
ATOM    851  CA  PRO   120       7.815  29.543   1.612  1.00 14.71           C  
ATOM    852  C   PRO   120       6.972  28.435   0.981  1.00 13.91           C  
ATOM    853  O   PRO   120       6.846  27.379   1.580  1.00 13.07           O  
ATOM    854  CB  PRO   120       6.942  30.713   2.088  1.00 16.54           C  
ATOM    855  CG  PRO   120       7.921  31.876   2.108  1.00 20.48           C  
ATOM    856  CD  PRO   120       8.742  31.667   0.847  1.00 16.71           C  
ATOM    857  N   SER   121       6.428  28.623  -0.221  1.00 12.41           N  
ATOM    858  CA  SER   121       5.595  27.600  -0.829  1.00 13.18           C  
ATOM    859  C   SER   121       6.374  26.329  -1.122  1.00 13.95           C  
ATOM    860  O   SER   121       5.860  25.244  -0.874  1.00 13.03           O  
ATOM    861  CB  SER   121       4.922  28.091  -2.125  1.00 18.33           C  
ATOM    862  OG  SER   121       5.883  28.515  -3.077  1.00 19.51           O  
ATOM    863  N   ARG   122       7.592  26.473  -1.666  1.00 12.92           N  
ATOM    864  CA  ARG   122       8.398  25.294  -1.995  1.00 13.33           C  
ATOM    865  C   ARG   122       8.831  24.590  -0.738  1.00 12.54           C  
ATOM    866  O   ARG   122       8.801  23.361  -0.669  1.00 13.01           O  
ATOM    867  CB  ARG   122       9.651  25.680  -2.775  1.00 15.70           C  
ATOM    868  CG  ARG   122       9.384  26.107  -4.191  1.00 15.72           C  
ATOM    869  CD  ARG   122      10.687  26.421  -4.930  1.00 14.92           C  
ATOM    870  NE  ARG   122      11.477  25.204  -5.093  1.00 17.78           N  
ATOM    871  CZ  ARG   122      12.717  25.156  -5.578  1.00 17.08           C  
ATOM    872  NH1 ARG   122      13.334  26.269  -5.966  1.00 14.73           N  
ATOM    873  NH2 ARG   122      13.349  23.986  -5.663  1.00 17.62           N  
ATOM    874  N   ASP   123       9.271  25.360   0.249  1.00 10.85           N  
ATOM    875  CA  ASP   123       9.774  24.725   1.459  1.00 10.72           C  
ATOM    876  C   ASP   123       8.636  24.052   2.227  1.00 12.40           C  
ATOM    877  O   ASP   123       8.812  22.953   2.789  1.00 11.60           O  
ATOM    878  CB  ASP   123      10.555  25.712   2.309  1.00 12.96           C  
ATOM    879  CG  ASP   123      11.841  26.184   1.616  1.00 13.68           C  
ATOM    880  OD1 ASP   123      12.315  25.471   0.695  1.00 13.31           O  
ATOM    881  OD2 ASP   123      12.333  27.262   2.001  1.00 15.24           O  
ATOM    882  N   HIS   124       7.440  24.643   2.168  1.00 12.54           N  
ATOM    883  CA  HIS   124       6.249  23.987   2.702  1.00 11.00           C  
ATOM    884  C   HIS   124       6.013  22.648   2.010  1.00 10.83           C  
ATOM    885  O   HIS   124       5.754  21.621   2.647  1.00 11.93           O  
ATOM    886  CB  HIS   124       5.015  24.864   2.495  1.00 11.21           C  
ATOM    887  CG  HIS   124       3.734  24.178   2.840  1.00 10.23           C  
ATOM    888  ND1 HIS   124       3.462  23.724   4.115  1.00 11.30           N  
ATOM    889  CD2 HIS   124       2.654  23.865   2.088  1.00 11.04           C  
ATOM    890  CE1 HIS   124       2.268  23.155   4.129  1.00  9.49           C  
ATOM    891  NE2 HIS   124       1.770  23.205   2.906  1.00 10.84           N  
ATOM    892  N   ALA   125       6.081  22.645   0.677  1.00 11.36           N  
ATOM    893  CA  ALA   125       5.718  21.453  -0.065  1.00 12.11           C  
ATOM    894  C   ALA   125       6.604  20.251   0.294  1.00 11.47           C  
ATOM    895  O   ALA   125       6.107  19.136   0.534  1.00 13.45           O  
ATOM    896  CB  ALA   125       5.759  21.738  -1.578  1.00 13.21           C  
ATOM    897  N   VAL   126       7.910  20.508   0.352  1.00 11.41           N  
ATOM    898  CA  VAL   126       8.910  19.489   0.690  0.50 11.13           C  
ATOM    900  C   VAL   126       8.685  19.016   2.122  1.00 13.15           C  
ATOM    901  O   VAL   126       8.677  17.830   2.410  1.00 13.62           O  
ATOM    902  CB  VAL   126      10.345  20.061   0.529  0.50 10.09           C  
ATOM    904  CG1 VAL   126      11.411  19.100   1.079  0.50 11.60           C  
ATOM    906  CG2 VAL   126      10.613  20.356  -0.940  0.50 10.13           C  
ATOM    908  N   SER   127       8.487  19.987   3.015  1.00 11.21           N  
ATOM    909  CA  SER   127       8.267  19.704   4.430  0.50 10.89           C  
ATOM    911  C   SER   127       6.994  18.889   4.674  1.00 11.26           C  
ATOM    912  O   SER   127       6.967  18.010   5.536  1.00 11.71           O  
ATOM    913  CB  SER   127       8.213  21.012   5.205  0.50 13.85           C  
ATOM    915  OG  SER   127       8.144  20.775   6.582  0.50 12.04           O  
ATOM    917  N   TYR   128       5.929  19.213   3.931  1.00 10.99           N  
ATOM    918  CA  TYR   128       4.664  18.487   4.046  1.00 10.36           C  
ATOM    919  C   TYR   128       4.840  17.017   3.689  1.00 12.02           C  
ATOM    920  O   TYR   128       4.337  16.137   4.415  1.00 12.45           O  
ATOM    921  CB  TYR   128       3.616  19.131   3.143  1.00  9.90           C  
ATOM    922  CG  TYR   128       2.374  18.311   2.989  1.00 10.64           C  
ATOM    923  CD1 TYR   128       1.401  18.313   3.990  1.00 12.75           C  
ATOM    924  CD2 TYR   128       2.149  17.576   1.838  1.00 10.69           C  
ATOM    925  CE1 TYR   128       0.231  17.571   3.847  1.00 12.99           C  
ATOM    926  CE2 TYR   128       1.000  16.796   1.690  1.00 14.34           C  
ATOM    927  CZ  TYR   128       0.037  16.811   2.701  1.00 14.74           C  
ATOM    928  OH  TYR   128      -1.130  16.062   2.554  1.00 19.35           O  
ATOM    929  N   GLN   129       5.561  16.745   2.587  1.00 12.30           N  
ATOM    930  CA  GLN   129       5.778  15.368   2.159  0.50 11.89           C  
ATOM    932  C   GLN   129       6.551  14.579   3.213  1.00 11.90           C  
ATOM    933  O   GLN   129       6.223  13.433   3.494  1.00 13.97           O  
ATOM    934  CB  GLN   129       6.463  15.319   0.790  0.50 17.43           C  
ATOM    936  CG  GLN   129       5.564  15.766  -0.373  0.50 21.28           C  
ATOM    938  CD  GLN   129       4.328  14.888  -0.571  0.50 27.50           C  
ATOM    940  OE1 GLN   129       3.227  15.395  -0.790  0.50 37.10           O  
ATOM    942  NE2 GLN   129       4.507  13.573  -0.502  0.50 39.43           N  
ATOM    944  N   ILE   130       7.546  15.214   3.816  1.00 10.99           N  
ATOM    945  CA  ILE   130       8.265  14.597   4.924  1.00 11.28           C  
ATOM    946  C   ILE   130       7.298  14.331   6.093  1.00 10.32           C  
ATOM    947  O   ILE   130       7.309  13.247   6.687  1.00 11.94           O  
ATOM    948  CB  ILE   130       9.456  15.480   5.369  1.00 10.79           C  
ATOM    949  CG1 ILE   130      10.539  15.476   4.263  1.00 12.69           C  
ATOM    950  CG2 ILE   130       9.987  15.048   6.769  1.00 11.24           C  
ATOM    951  CD1 ILE   130      11.663  16.488   4.451  1.00 13.94           C  
ATOM    952  N   GLY   131       6.468  15.325   6.412  1.00 10.56           N  
ATOM    953  CA  GLY   131       5.536  15.217   7.541  1.00 10.56           C  
ATOM    954  C   GLY   131       4.578  14.052   7.347  1.00 12.07           C  
ATOM    955  O   GLY   131       4.317  13.291   8.292  1.00 12.17           O  
ATOM    956  N   GLN   132       4.050  13.892   6.134  1.00 12.52           N  
ATOM    957  CA  GLN   132       3.177  12.763   5.827  1.00 13.85           C  
ATOM    958  C   GLN   132       3.827  11.420   6.131  1.00 11.58           C  
ATOM    959  O   GLN   132       3.199  10.536   6.740  1.00 13.19           O  
ATOM    960  CB  GLN   132       2.736  12.814   4.359  1.00 13.17           C  
ATOM    961  CG  GLN   132       1.733  13.902   4.071  1.00 16.82           C  
ATOM    962  CD  GLN   132       0.401  13.611   4.732  1.00 20.54           C  
ATOM    963  OE1 GLN   132       0.089  14.171   5.780  1.00 22.06           O  
ATOM    964  NE2 GLN   132      -0.378  12.700   4.144  1.00 24.13           N  
ATOM    965  N   ARG   133       5.088  11.261   5.723  1.00 11.88           N  
ATOM    966  CA  ARG   133       5.782   9.999   5.936  1.00 11.18           C  
ATOM    967  C   ARG   133       6.121   9.800   7.426  1.00 10.84           C  
ATOM    968  O   ARG   133       6.039   8.693   7.944  1.00 12.01           O  
ATOM    969  CB  ARG   133       7.005   9.914   5.020  1.00 12.43           C  
ATOM    970  CG  ARG   133       7.758   8.586   5.061  1.00 13.14           C  
ATOM    971  CD  ARG   133       6.902   7.426   4.535  1.00 14.39           C  
ATOM    972  NE  ARG   133       7.781   6.378   4.031  1.00 18.04           N  
ATOM    973  CZ  ARG   133       7.380   5.306   3.371  1.00 15.95           C  
ATOM    974  NH1 ARG   133       6.083   5.109   3.148  1.00 18.22           N  
ATOM    975  NH2 ARG   133       8.277   4.420   2.952  1.00 17.71           N  
ATOM    976  N   VAL   134       6.483  10.879   8.117  1.00 11.86           N  
ATOM    977  CA  VAL   134       6.704  10.813   9.564  1.00 11.94           C  
ATOM    978  C   VAL   134       5.443  10.329  10.269  1.00 10.69           C  
ATOM    979  O   VAL   134       5.500   9.471  11.160  1.00 12.44           O  
ATOM    980  CB  VAL   134       7.171  12.173  10.137  1.00 11.36           C  
ATOM    981  CG1 VAL   134       7.164  12.156  11.665  1.00 11.92           C  
ATOM    982  CG2 VAL   134       8.567  12.493   9.608  1.00 13.37           C  
ATOM    983  N   MET   135       4.291  10.852   9.860  1.00 11.80           N  
ATOM    984  CA  MET   135       3.045  10.414  10.507  1.00 12.72           C  
ATOM    985  C   MET   135       2.715   8.968  10.190  1.00 12.07           C  
ATOM    986  O   MET   135       2.195   8.258  11.064  1.00 12.57           O  
ATOM    987  CB  MET   135       1.880  11.317  10.131  1.00 13.33           C  
ATOM    988  CG  MET   135       2.034  12.771  10.541  1.00 14.97           C  
ATOM    989  SD  MET   135       2.476  12.977  12.442  0.70 14.74          SE  
ATOM    990  CE  MET   135       0.918  12.078  13.211  1.00 17.71           C  
ATOM    991  N   GLU   136       3.011   8.522   8.968  1.00 13.34           N  
ATOM    992  CA  GLU   136       2.786   7.116   8.638  1.00 14.66           C  
ATOM    993  C   GLU   136       3.637   6.218   9.539  1.00 13.86           C  
ATOM    994  O   GLU   136       3.169   5.190  10.048  1.00 14.68           O  
ATOM    995  CB  GLU   136       3.073   6.851   7.158  1.00 14.11           C  
ATOM    996  CG  GLU   136       2.850   5.419   6.721  1.00 19.12           C  
ATOM    997  CD  GLU   136       3.271   5.132   5.281  1.00 25.99           C  
ATOM    998  OE1 GLU   136       3.825   6.028   4.592  1.00 22.32           O  
ATOM    999  OE2 GLU   136       3.039   3.978   4.856  1.00 26.05           O  
ATOM   1000  N   ILE   137       4.866   6.651   9.806  1.00 11.87           N  
ATOM   1001  CA  ILE   137       5.759   5.917  10.725  1.00 12.27           C  
ATOM   1002  C   ILE   137       5.200   5.972  12.152  1.00 14.18           C  
ATOM   1003  O   ILE   137       5.159   4.958  12.879  1.00 14.08           O  
ATOM   1004  CB  ILE   137       7.197   6.523  10.671  1.00 14.79           C  
ATOM   1005  CG1 ILE   137       7.818   6.226   9.301  1.00 14.66           C  
ATOM   1006  CG2 ILE   137       8.092   6.057  11.823  1.00 17.41           C  
ATOM   1007  CD1 ILE   137       9.049   7.054   8.968  1.00 14.56           C  
ATOM   1008  N   ALA   138       4.756   7.155  12.564  1.00 13.36           N  
ATOM   1009  CA  ALA   138       4.239   7.308  13.920  1.00 15.50           C  
ATOM   1010  C   ALA   138       3.055   6.392  14.183  1.00 17.10           C  
ATOM   1011  O   ALA   138       3.029   5.691  15.197  1.00 17.07           O  
ATOM   1012  CB  ALA   138       3.863   8.740  14.187  1.00 14.77           C  
ATOM   1013  N   VAL   139       2.076   6.364  13.290  1.00 14.22           N  
ATOM   1014  CA  VAL   139       0.893   5.559  13.602  1.00 17.81           C  
ATOM   1015  C   VAL   139       1.211   4.051  13.593  1.00 16.57           C  
ATOM   1016  O   VAL   139       0.520   3.268  14.255  1.00 18.88           O  
ATOM   1017  CB  VAL   139      -0.350   5.940  12.747  1.00 25.03           C  
ATOM   1018  CG1 VAL   139      -0.700   7.418  12.942  1.00 23.47           C  
ATOM   1019  CG2 VAL   139      -0.116   5.632  11.315  1.00 23.85           C  
ATOM   1020  N   ARG   140       2.260   3.651  12.881  1.00 14.60           N  
ATOM   1021  CA  ARG   140       2.713   2.272  12.855  1.00 14.63           C  
ATOM   1022  C   ARG   140       3.375   1.842  14.176  1.00 14.50           C  
ATOM   1023  O   ARG   140       3.273   0.670  14.584  1.00 16.94           O  
ATOM   1024  CB  ARG   140       3.722   2.106  11.729  1.00 17.48           C  
ATOM   1025  CG  ARG   140       4.114   0.710  11.407  1.00 23.55           C  
ATOM   1026  CD  ARG   140       4.253   0.612   9.922  1.00 28.61           C  
ATOM   1027  NE  ARG   140       4.768  -0.681   9.510  1.00 35.75           N  
ATOM   1028  CZ  ARG   140       4.692  -1.131   8.267  1.00 23.47           C  
ATOM   1029  NH1 ARG   140       4.095  -0.390   7.329  1.00 25.25           N  
ATOM   1030  NH2 ARG   140       5.191  -2.319   7.969  1.00 33.07           N  
ATOM   1031  N   TYR   141       4.078   2.770  14.845  1.00 12.86           N  
ATOM   1032  CA  TYR   141       4.960   2.361  15.935  1.00 12.52           C  
ATOM   1033  C   TYR   141       4.629   2.955  17.296  1.00 10.49           C  
ATOM   1034  O   TYR   141       5.192   2.517  18.288  1.00 11.91           O  
ATOM   1035  CB  TYR   141       6.417   2.676  15.606  1.00 11.72           C  
ATOM   1036  CG  TYR   141       6.939   1.896  14.435  1.00 15.03           C  
ATOM   1037  CD1 TYR   141       7.106   0.514  14.520  1.00 15.39           C  
ATOM   1038  CD2 TYR   141       7.242   2.533  13.239  1.00 15.09           C  
ATOM   1039  CE1 TYR   141       7.577  -0.210  13.439  1.00 16.45           C  
ATOM   1040  CE2 TYR   141       7.712   1.832  12.159  1.00 17.80           C  
ATOM   1041  CZ  TYR   141       7.872   0.467  12.249  1.00 17.33           C  
ATOM   1042  OH  TYR   141       8.350  -0.169  11.125  1.00 18.29           O  
ATOM   1043  N   LEU   142       3.742   3.950  17.349  1.00 10.86           N  
ATOM   1044  CA  LEU   142       3.441   4.618  18.622  0.50 11.36           C  
ATOM   1046  C   LEU   142       2.571   3.806  19.548  1.00 13.48           C  
ATOM   1047  O   LEU   142       1.594   3.191  19.112  1.00 14.78           O  
ATOM   1048  CB  LEU   142       2.723   5.941  18.416  0.50 11.66           C  
ATOM   1050  CG  LEU   142       3.563   7.179  18.176  0.50  9.60           C  
ATOM   1052  CD1 LEU   142       2.600   8.224  17.674  0.50 14.73           C  
ATOM   1054  CD2 LEU   142       4.278   7.649  19.457  0.50 11.81           C  
ATOM   1056  N   ARG   143       2.901   3.846  20.837  1.00 12.69           N  
ATOM   1057  CA  ARG   143       2.033   3.237  21.845  1.00 13.33           C  
ATOM   1058  C   ARG   143       0.826   4.130  22.018  1.00 14.30           C  
ATOM   1059  O   ARG   143       0.884   5.351  21.765  1.00 14.62           O  
ATOM   1060  CB  ARG   143       2.752   3.055  23.194  1.00 15.19           C  
ATOM   1061  CG  ARG   143       3.082   4.318  23.972  1.00 13.79           C  
ATOM   1062  CD  ARG   143       3.539   3.944  25.394  1.00 16.54           C  
ATOM   1063  NE  ARG   143       3.892   5.104  26.190  1.00 18.51           N  
ATOM   1064  CZ  ARG   143       3.032   5.816  26.914  1.00 20.32           C  
ATOM   1065  NH1 ARG   143       1.738   5.491  26.943  1.00 23.94           N  
ATOM   1066  NH2 ARG   143       3.464   6.847  27.622  1.00 24.25           N  
ATOM   1067  N   ASN   144      -0.271   3.530  22.476  1.00 15.98           N  
ATOM   1068  CA  ASN   144      -1.406   4.304  22.952  0.50 16.67           C  
ATOM   1070  C   ASN   144      -0.921   5.238  24.030  1.00 14.32           C  
ATOM   1071  O   ASN   144      -0.252   4.786  24.965  1.00 16.71           O  
ATOM   1072  CB  ASN   144      -2.467   3.388  23.551  0.50 15.10           C  
ATOM   1074  CG  ASN   144      -3.203   2.613  22.509  0.50 27.23           C  
ATOM   1076  OD1 ASN   144      -3.474   3.128  21.432  0.50 29.27           O  
ATOM   1078  ND2 ASN   144      -3.542   1.362  22.818  0.50 20.43           N  
ATOM   1080  N   GLY   145      -1.245   6.519  23.892  1.00 13.95           N  
ATOM   1081  CA  GLY   145      -0.760   7.549  24.793  1.00 13.60           C  
ATOM   1082  C   GLY   145       0.538   8.244  24.347  1.00 15.52           C  
ATOM   1083  O   GLY   145       1.003   9.170  25.010  1.00 19.43           O  
ATOM   1084  N   GLY   146       1.119   7.788  23.235  1.00 14.32           N  
ATOM   1085  CA  GLY   146       2.390   8.342  22.745  1.00 14.96           C  
ATOM   1086  C   GLY   146       2.242   9.696  22.063  1.00 12.11           C  
ATOM   1087  O   GLY   146       1.129  10.096  21.713  1.00 12.15           O  
ATOM   1088  N   ASN   147       3.368  10.378  21.882  1.00 12.02           N  
ATOM   1089  CA  ASN   147       3.384  11.718  21.315  1.00 10.79           C  
ATOM   1090  C   ASN   147       4.188  11.817  20.029  1.00 11.00           C  
ATOM   1091  O   ASN   147       5.095  11.005  19.790  1.00 10.12           O  
ATOM   1092  CB  ASN   147       4.028  12.711  22.298  1.00 13.03           C  
ATOM   1093  CG  ASN   147       3.254  12.859  23.595  1.00 14.49           C  
ATOM   1094  OD1 ASN   147       2.062  12.540  23.674  1.00 14.43           O  
ATOM   1095  ND2 ASN   147       3.935  13.349  24.618  1.00 15.04           N  
ATOM   1096  N   VAL   148       3.875  12.836  19.229  1.00 10.08           N  
ATOM   1097  CA  VAL   148       4.678  13.200  18.054  1.00 10.32           C  
ATOM   1098  C   VAL   148       5.112  14.659  18.127  1.00 10.96           C  
ATOM   1099  O   VAL   148       4.328  15.526  18.524  1.00 12.33           O  
ATOM   1100  CB  VAL   148       3.911  12.970  16.729  1.00 11.82           C  
ATOM   1101  CG1 VAL   148       4.750  13.388  15.517  1.00 13.57           C  
ATOM   1102  CG2 VAL   148       3.550  11.547  16.594  1.00 13.33           C  
ATOM   1103  N   LEU   149       6.360  14.917  17.737  1.00  9.54           N  
ATOM   1104  CA  LEU   149       6.847  16.284  17.535  1.00 10.13           C  
ATOM   1105  C   LEU   149       7.401  16.330  16.129  1.00  9.76           C  
ATOM   1106  O   LEU   149       8.202  15.491  15.769  1.00 10.76           O  
ATOM   1107  CB  LEU   149       7.977  16.622  18.518  1.00 12.13           C  
ATOM   1108  CG  LEU   149       8.880  17.829  18.198  1.00 11.89           C  
ATOM   1109  CD1 LEU   149       8.058  19.099  18.208  1.00 13.01           C  
ATOM   1110  CD2 LEU   149      10.021  17.909  19.210  1.00 14.70           C  
ATOM   1111  N   LEU   150       6.970  17.296  15.313  1.00  8.99           N  
ATOM   1112  CA  LEU   150       7.511  17.380  13.962  0.50 11.44           C  
ATOM   1114  C   LEU   150       7.656  18.800  13.473  1.00 12.24           C  
ATOM   1115  O   LEU   150       6.793  19.675  13.686  1.00 12.49           O  
ATOM   1116  CB  LEU   150       6.712  16.536  12.949  0.50 20.07           C  
ATOM   1118  CG  LEU   150       5.352  17.056  12.470  0.50 21.76           C  
ATOM   1120  CD1 LEU   150       5.133  16.793  10.984  0.50 23.31           C  
ATOM   1122  CD2 LEU   150       4.213  16.474  13.281  0.50 26.23           C  
ATOM   1124  N   LYS   151       8.809  19.031  12.839  1.00 11.05           N  
ATOM   1125  CA  LYS   151       9.069  20.312  12.200  1.00 12.47           C  
ATOM   1126  C   LYS   151       8.279  20.375  10.888  1.00 12.07           C  
ATOM   1127  O   LYS   151       8.258  19.406  10.103  1.00 11.40           O  
ATOM   1128  CB  LYS   151      10.563  20.476  11.890  1.00 15.74           C  
ATOM   1129  CG  LYS   151      10.857  21.850  11.284  1.00 15.82           C  
ATOM   1130  CD  LYS   151      12.303  22.226  11.298  1.00 23.41           C  
ATOM   1131  CE  LYS   151      13.066  21.415  10.296  1.00 23.56           C  
ATOM   1132  NZ  LYS   151      14.517  21.541  10.640  1.00 28.21           N  
ATOM   1133  N   GLN   152       7.663  21.529  10.632  1.00 11.33           N  
ATOM   1134  CA  GLN   152       7.024  21.794   9.346  1.00  9.32           C  
ATOM   1135  C   GLN   152       7.236  23.254   8.961  1.00 13.53           C  
ATOM   1136  O   GLN   152       7.270  24.131   9.811  1.00 16.85           O  
ATOM   1137  CB  GLN   152       5.521  21.478   9.397  1.00 11.40           C  
ATOM   1138  CG  GLN   152       4.805  21.567   8.029  1.00 12.88           C  
ATOM   1139  CD  GLN   152       3.428  20.909   7.999  1.00 15.18           C  
ATOM   1140  OE1 GLN   152       2.407  21.585   7.807  1.00 16.33           O  
ATOM   1141  NE2 GLN   152       3.394  19.588   8.162  1.00 13.42           N  
ATOM   1142  N   PHE   153       7.390  23.505   7.673  1.00 11.92           N  
ATOM   1143  CA  PHE   153       7.368  24.860   7.177  1.00 13.28           C  
ATOM   1144  C   PHE   153       5.909  25.142   6.823  1.00 12.52           C  
ATOM   1145  O   PHE   153       5.315  24.398   6.033  1.00 14.65           O  
ATOM   1146  CB  PHE   153       8.313  24.968   5.976  1.00 16.75           C  
ATOM   1147  CG  PHE   153       9.772  25.034   6.367  1.00 15.41           C  
ATOM   1148  CD1 PHE   153      10.418  26.266   6.415  1.00 23.92           C  
ATOM   1149  CD2 PHE   153      10.488  23.902   6.733  1.00 18.53           C  
ATOM   1150  CE1 PHE   153      11.767  26.364   6.787  1.00 25.02           C  
ATOM   1151  CE2 PHE   153      11.851  24.006   7.130  1.00 18.44           C  
ATOM   1152  CZ  PHE   153      12.476  25.232   7.132  1.00 23.62           C  
ATOM   1153  N   GLN   154       5.336  26.191   7.414  1.00 12.75           N  
ATOM   1154  CA  GLN   154       3.898  26.435   7.325  1.00 14.37           C  
ATOM   1155  C   GLN   154       3.474  26.798   5.902  1.00 14.38           C  
ATOM   1156  O   GLN   154       4.179  27.504   5.181  1.00 13.34           O  
ATOM   1157  CB  GLN   154       3.497  27.565   8.284  1.00 18.17           C  
ATOM   1158  CG  GLN   154       1.971  27.723   8.437  1.00 23.89           C  
ATOM   1159  CD  GLN   154       1.567  28.266   9.789  1.00 37.14           C  
ATOM   1160  OE1 GLN   154       2.246  29.124  10.356  1.00 41.97           O  
ATOM   1161  NE2 GLN   154       0.451  27.766  10.318  1.00 46.60           N  
ATOM   1162  N   GLY   155       2.301  26.314   5.515  1.00 11.64           N  
ATOM   1163  CA  GLY   155       1.732  26.708   4.223  1.00 11.82           C  
ATOM   1164  C   GLY   155       0.327  26.182   4.073  1.00 11.40           C  
ATOM   1165  O   GLY   155      -0.336  25.849   5.060  1.00 12.08           O  
ATOM   1166  N   ASP   156      -0.138  26.104   2.830  1.00 11.38           N  
ATOM   1167  CA  ASP   156      -1.538  25.804   2.554  1.00 12.44           C  
ATOM   1168  C   ASP   156      -1.982  24.534   3.272  1.00 13.47           C  
ATOM   1169  O   ASP   156      -3.104  24.452   3.772  1.00 14.62           O  
ATOM   1170  CB  ASP   156      -1.768  25.664   1.048  1.00 11.62           C  
ATOM   1171  CG  ASP   156      -1.751  26.999   0.330  1.00 14.84           C  
ATOM   1172  OD1 ASP   156      -1.882  28.041   1.006  1.00 13.69           O  
ATOM   1173  OD2 ASP   156      -1.606  27.007  -0.911  1.00 14.10           O  
ATOM   1174  N   MET   157      -1.095  23.545   3.319  1.00 11.53           N  
ATOM   1175  CA  MET   157      -1.484  22.182   3.659  1.00 12.40           C  
ATOM   1176  C   MET   157      -1.526  21.982   5.170  1.00 10.48           C  
ATOM   1177  O   MET   157      -1.946  20.932   5.656  1.00 12.88           O  
ATOM   1178  CB  MET   157      -0.524  21.176   3.022  1.00 13.36           C  
ATOM   1179  CG  MET   157      -0.571  21.150   1.503  1.00 11.62           C  
ATOM   1180  SD  MET   157      -2.370  20.854   0.810  0.70 16.42          SE  
ATOM   1181  CE  MET   157      -2.754  19.154   1.684  1.00 16.01           C  
ATOM   1182  N   THR   158      -1.087  22.996   5.909  1.00 11.91           N  
ATOM   1183  CA  THR   158      -0.832  22.849   7.346  1.00 11.22           C  
ATOM   1184  C   THR   158      -2.101  22.627   8.154  1.00 13.90           C  
ATOM   1185  O   THR   158      -2.183  21.670   8.935  1.00 11.92           O  
ATOM   1186  CB  THR   158      -0.027  24.021   7.916  1.00 12.96           C  
ATOM   1187  OG1 THR   158       1.250  24.065   7.252  1.00 12.46           O  
ATOM   1188  CG2 THR   158       0.188  23.831   9.441  1.00 15.05           C  
ATOM   1189  N   ASN   159      -3.103  23.472   7.928  1.00 13.35           N  
ATOM   1190  CA  ASN   159      -4.340  23.307   8.693  1.00 14.30           C  
ATOM   1191  C   ASN   159      -5.052  22.013   8.390  1.00 12.35           C  
ATOM   1192  O   ASN   159      -5.561  21.352   9.306  1.00 15.82           O  
ATOM   1193  CB  ASN   159      -5.285  24.484   8.480  1.00 16.47           C  
ATOM   1194  CG  ASN   159      -4.833  25.709   9.213  1.00 21.05           C  
ATOM   1195  OD1 ASN   159      -3.877  25.658   9.986  1.00 22.39           O  
ATOM   1196  ND2 ASN   159      -5.512  26.828   8.978  1.00 24.55           N  
ATOM   1197  N   ASP   160      -5.045  21.608   7.117  1.00 13.38           N  
ATOM   1198  CA  ASP   160      -5.652  20.343   6.741  0.50 12.59           C  
ATOM   1200  C   ASP   160      -4.886  19.124   7.297  1.00 14.86           C  
ATOM   1201  O   ASP   160      -5.504  18.139   7.723  1.00 17.44           O  
ATOM   1202  CB  ASP   160      -5.838  20.269   5.214  0.50 16.57           C  
ATOM   1204  CG  ASP   160      -7.056  21.076   4.719  0.50 22.87           C  
ATOM   1206  OD1 ASP   160      -7.115  22.314   4.906  0.50 15.88           O  
ATOM   1208  OD2 ASP   160      -7.956  20.470   4.094  0.50 19.25           O  
ATOM   1210  N   PHE   161      -3.549  19.211   7.316  1.00 14.31           N  
ATOM   1211  CA  PHE   161      -2.656  18.197   7.890  1.00 14.03           C  
ATOM   1212  C   PHE   161      -3.006  17.995   9.378  1.00 11.91           C  
ATOM   1213  O   PHE   161      -3.197  16.851   9.829  1.00 14.86           O  
ATOM   1214  CB  PHE   161      -1.192  18.665   7.692  1.00 12.85           C  
ATOM   1215  CG  PHE   161      -0.150  17.778   8.326  1.00 12.52           C  
ATOM   1216  CD1 PHE   161       0.404  16.743   7.591  1.00 15.17           C  
ATOM   1217  CD2 PHE   161       0.321  18.003   9.640  1.00 12.26           C  
ATOM   1218  CE1 PHE   161       1.376  15.926   8.139  1.00 15.39           C  
ATOM   1219  CE2 PHE   161       1.292  17.175  10.192  1.00 14.73           C  
ATOM   1220  CZ  PHE   161       1.819  16.153   9.435  1.00 14.16           C  
ATOM   1221  N   ILE   162      -3.104  19.107  10.108  1.00 12.59           N  
ATOM   1222  CA  ILE   162      -3.429  19.063  11.516  1.00 13.26           C  
ATOM   1223  C   ILE   162      -4.823  18.505  11.726  1.00 14.67           C  
ATOM   1224  O   ILE   162      -4.990  17.642  12.585  1.00 17.12           O  
ATOM   1225  CB  ILE   162      -3.250  20.441  12.162  1.00 13.98           C  
ATOM   1226  CG1 ILE   162      -1.761  20.787  12.181  1.00 15.65           C  
ATOM   1227  CG2 ILE   162      -3.835  20.489  13.604  1.00 16.81           C  
ATOM   1228  CD1 ILE   162      -1.495  22.170  12.613  1.00 16.81           C  
ATOM   1229  N   ALA   163      -5.789  18.953  10.912  1.00 13.67           N  
ATOM   1230  CA  ALA   163      -7.183  18.497  11.059  1.00 15.76           C  
ATOM   1231  C   ALA   163      -7.291  16.988  10.871  1.00 17.54           C  
ATOM   1232  O   ALA   163      -8.055  16.321  11.584  1.00 20.78           O  
ATOM   1233  CB  ALA   163      -8.095  19.224  10.095  1.00 17.98           C  
ATOM   1234  N   ILE   164      -6.536  16.441   9.913  1.00 15.90           N  
ATOM   1235  CA  ILE   164      -6.589  15.011   9.610  1.00 16.22           C  
ATOM   1236  C   ILE   164      -5.888  14.208  10.704  1.00 19.24           C  
ATOM   1237  O   ILE   164      -6.469  13.282  11.287  1.00 20.94           O  
ATOM   1238  CB  ILE   164      -6.008  14.690   8.200  1.00 19.88           C  
ATOM   1239  CG1 ILE   164      -6.947  15.210   7.097  1.00 22.44           C  
ATOM   1240  CG2 ILE   164      -5.752  13.191   8.028  1.00 22.35           C  
ATOM   1241  CD1 ILE   164      -6.292  15.382   5.739  1.00 28.45           C  
ATOM   1242  N   TRP   165      -4.650  14.577  11.016  1.00 15.75           N  
ATOM   1243  CA  TRP   165      -3.852  13.749  11.922  1.00 19.10           C  
ATOM   1244  C   TRP   165      -4.288  13.829  13.376  1.00 15.64           C  
ATOM   1245  O   TRP   165      -4.101  12.864  14.129  1.00 18.93           O  
ATOM   1246  CB  TRP   165      -2.349  14.030  11.765  1.00 16.07           C  
ATOM   1247  CG  TRP   165      -1.815  13.501  10.472  1.00 15.98           C  
ATOM   1248  CD1 TRP   165      -1.403  14.233   9.384  1.00 17.48           C  
ATOM   1249  CD2 TRP   165      -1.671  12.121  10.097  1.00 14.31           C  
ATOM   1250  NE1 TRP   165      -0.997  13.397   8.376  1.00 16.98           N  
ATOM   1251  CE2 TRP   165      -1.163  12.098   8.779  1.00 17.19           C  
ATOM   1252  CE3 TRP   165      -1.905  10.903  10.753  1.00 18.10           C  
ATOM   1253  CZ2 TRP   165      -0.875  10.903   8.105  1.00 17.54           C  
ATOM   1254  CZ3 TRP   165      -1.634   9.719  10.074  1.00 17.05           C  
ATOM   1255  CH2 TRP   165      -1.119   9.728   8.771  1.00 19.78           C  
ATOM   1256  N   ARG   166      -4.891  14.955  13.767  1.00 14.46           N  
ATOM   1257  CA  ARG   166      -5.303  15.123  15.173  1.00 17.91           C  
ATOM   1258  C   ARG   166      -6.444  14.205  15.583  1.00 18.87           C  
ATOM   1259  O   ARG   166      -6.679  14.029  16.777  1.00 22.29           O  
ATOM   1260  CB  ARG   166      -5.641  16.572  15.522  1.00 22.23           C  
ATOM   1261  CG  ARG   166      -6.984  17.076  15.044  1.00 22.75           C  
ATOM   1262  CD  ARG   166      -7.045  18.555  15.325  1.00 33.12           C  
ATOM   1263  NE  ARG   166      -8.271  19.178  14.863  1.00 34.39           N  
ATOM   1264  CZ  ARG   166      -9.360  19.321  15.608  1.00 42.29           C  
ATOM   1265  NH1 ARG   166     -10.426  19.909  15.088  1.00 44.12           N  
ATOM   1266  NH2 ARG   166      -9.383  18.880  16.860  1.00 38.24           N  
ATOM   1267  N   LYS   167      -7.109  13.605  14.595  1.00 20.24           N  
ATOM   1268  CA  LYS   167      -8.148  12.593  14.833  1.00 22.36           C  
ATOM   1269  C   LYS   167      -7.604  11.337  15.528  1.00 23.24           C  
ATOM   1270  O   LYS   167      -8.370  10.587  16.133  1.00 23.92           O  
ATOM   1271  CB  LYS   167      -8.811  12.209  13.513  1.00 21.65           C  
ATOM   1272  CG  LYS   167      -9.668  13.306  12.912  1.00 25.38           C  
ATOM   1273  CD  LYS   167     -10.216  12.866  11.556  1.00 37.24           C  
ATOM   1274  CE  LYS   167     -11.133  13.921  10.960  1.00 47.22           C  
ATOM   1275  NZ  LYS   167     -11.554  13.576   9.571  1.00 57.19           N  
ATOM   1276  N   ASN   168      -6.291  11.106  15.434  1.00 20.02           N  
ATOM   1277  CA  ASN   168      -5.632   9.961  16.092  1.00 21.18           C  
ATOM   1278  C   ASN   168      -5.032  10.308  17.460  1.00 17.20           C  
ATOM   1279  O   ASN   168      -4.284   9.511  18.038  1.00 18.97           O  
ATOM   1280  CB  ASN   168      -4.524   9.384  15.204  1.00 24.01           C  
ATOM   1281  CG  ASN   168      -4.997   9.070  13.807  1.00 29.97           C  
ATOM   1282  OD1 ASN   168      -5.571   8.016  13.556  1.00 38.36           O  
ATOM   1283  ND2 ASN   168      -4.750   9.988  12.884  1.00 35.11           N  
ATOM   1284  N   PHE   169      -5.329  11.504  17.958  1.00 17.50           N  
ATOM   1285  CA  PHE   169      -4.700  12.009  19.172  1.00 19.00           C  
ATOM   1286  C   PHE   169      -5.681  12.734  20.095  1.00 19.40           C  
ATOM   1287  O   PHE   169      -6.741  13.197  19.659  1.00 22.92           O  
ATOM   1288  CB  PHE   169      -3.525  12.940  18.830  1.00 15.77           C  
ATOM   1289  CG  PHE   169      -2.365  12.233  18.154  1.00 13.65           C  
ATOM   1290  CD1 PHE   169      -1.297  11.733  18.900  1.00 12.61           C  
ATOM   1291  CD2 PHE   169      -2.314  12.125  16.767  1.00 12.39           C  
ATOM   1292  CE1 PHE   169      -0.211  11.096  18.262  1.00 12.66           C  
ATOM   1293  CE2 PHE   169      -1.247  11.496  16.134  1.00 12.84           C  
ATOM   1294  CZ  PHE   169      -0.203  10.980  16.878  1.00 13.03           C  
ATOM   1295  N   SER   170      -5.303  12.819  21.366  1.00 17.70           N  
ATOM   1296  CA  SER   170      -6.109  13.503  22.370  0.50 20.33           C  
ATOM   1298  C   SER   170      -6.104  15.017  22.173  1.00 23.24           C  
ATOM   1299  O   SER   170      -7.136  15.682  22.371  1.00 22.67           O  
ATOM   1300  CB  SER   170      -5.616  13.134  23.771  0.50 21.72           C  
ATOM   1302  OG  SER   170      -5.662  11.732  23.953  0.50 23.48           O  
ATOM   1304  N   SER   171      -4.957  15.564  21.759  1.00 17.62           N  
ATOM   1305  CA  SER   171      -4.808  16.999  21.555  1.00 17.90           C  
ATOM   1306  C   SER   171      -3.626  17.327  20.640  1.00 17.62           C  
ATOM   1307  O   SER   171      -2.849  16.447  20.276  1.00 16.20           O  
ATOM   1308  CB  SER   171      -4.610  17.718  22.896  1.00 18.97           C  
ATOM   1309  OG  SER   171      -3.388  17.332  23.527  1.00 20.91           O  
ATOM   1310  N   TYR   172      -3.493  18.594  20.270  1.00 15.71           N  
ATOM   1311  CA  TYR   172      -2.332  19.040  19.515  1.00 14.60           C  
ATOM   1312  C   TYR   172      -1.932  20.430  19.958  1.00 17.02           C  
ATOM   1313  O   TYR   172      -2.754  21.163  20.549  1.00 16.90           O  
ATOM   1314  CB  TYR   172      -2.604  19.043  17.992  1.00 15.60           C  
ATOM   1315  CG  TYR   172      -3.399  20.235  17.502  1.00 19.02           C  
ATOM   1316  CD1 TYR   172      -2.763  21.389  17.030  1.00 20.38           C  
ATOM   1317  CD2 TYR   172      -4.788  20.208  17.515  1.00 25.26           C  
ATOM   1318  CE1 TYR   172      -3.497  22.490  16.604  1.00 18.75           C  
ATOM   1319  CE2 TYR   172      -5.525  21.289  17.071  1.00 25.40           C  
ATOM   1320  CZ  TYR   172      -4.884  22.419  16.629  1.00 23.67           C  
ATOM   1321  OH  TYR   172      -5.637  23.489  16.188  1.00 26.51           O  
ATOM   1322  N   LYS   173      -0.678  20.787  19.672  1.00 16.10           N  
ATOM   1323  CA  LYS   173      -0.171  22.147  19.859  0.50 15.36           C  
ATOM   1325  C   LYS   173       0.734  22.529  18.698  1.00 16.51           C  
ATOM   1326  O   LYS   173       1.356  21.658  18.076  1.00 15.47           O  
ATOM   1327  CB  LYS   173       0.607  22.279  21.172  0.50 17.13           C  
ATOM   1329  CG  LYS   173      -0.230  22.012  22.410  0.50 21.46           C  
ATOM   1331  CD  LYS   173       0.334  22.672  23.637  0.50 30.27           C  
ATOM   1333  CE  LYS   173      -0.307  22.140  24.905  0.50 31.83           C  
ATOM   1335  NZ  LYS   173      -1.758  22.461  24.978  0.50 23.82           N  
ATOM   1337  N   ILE   174       0.794  23.824  18.398  1.00 13.68           N  
ATOM   1338  CA  ILE   174       1.722  24.383  17.440  1.00 14.31           C  
ATOM   1339  C   ILE   174       2.597  25.396  18.178  1.00 15.81           C  
ATOM   1340  O   ILE   174       2.093  26.174  19.012  1.00 17.33           O  
ATOM   1341  CB  ILE   174       1.006  25.076  16.237  1.00 18.32           C  
ATOM   1342  CG1 ILE   174       0.082  24.091  15.519  1.00 22.53           C  
ATOM   1343  CG2 ILE   174       2.014  25.674  15.248  1.00 22.62           C  
ATOM   1344  CD1 ILE   174      -1.106  24.804  14.872  1.00 36.94           C  
ATOM   1345  N   SER   175       3.893  25.376  17.889  1.00 16.05           N  
ATOM   1346  CA  SER   175       4.820  26.356  18.433  1.00 16.42           C  
ATOM   1347  C   SER   175       5.801  26.935  17.420  1.00 24.16           C  
ATOM   1348  O   SER   175       6.188  26.265  16.461  1.00 19.16           O  
ATOM   1349  CB  SER   175       5.643  25.705  19.546  1.00 19.60           C  
ATOM   1350  OG  SER   175       6.513  26.650  20.151  1.00 23.47           O  
ATOM   1351  N   LYS   176       6.232  28.170  17.687  1.00 30.96           N  
ATOM   1352  CA  LYS   176       7.315  28.823  16.943  0.50 37.46           C  
ATOM   1354  C   LYS   176       8.448  29.228  17.907  1.00 40.47           C  
ATOM   1355  O   LYS   176       8.335  30.246  18.600  1.00 45.07           O  
ATOM   1356  CB  LYS   176       6.798  30.064  16.190  0.50 38.18           C  
ATOM   1358  CG  LYS   176       5.703  29.805  15.147  0.50 39.96           C  
ATOM   1360  CD  LYS   176       4.298  30.018  15.707  0.50 42.89           C  
ATOM   1362  CE  LYS   176       3.237  29.878  14.626  0.50 42.91           C  
ATOM   1364  NZ  LYS   176       1.858  30.045  15.160  0.50 44.53           N  
ATOM   1366  N   PRO   177       9.544  28.429  17.976  1.00 44.39           N  
ATOM   1367  CA  PRO   177      10.685  28.789  18.851  1.00 46.09           C  
ATOM   1368  C   PRO   177      11.475  30.021  18.408  1.00 45.73           C  
ATOM   1369  O   PRO   177      11.329  30.472  17.274  1.00 44.57           O  
ATOM   1370  CB  PRO   177      11.591  27.550  18.789  1.00 46.13           C  
ATOM   1371  CG  PRO   177      10.723  26.457  18.270  1.00 45.78           C  
ATOM   1372  CD  PRO   177       9.781  27.134  17.319  1.00 47.03           C  
ATOM   1373  N   SER   184      11.206  32.146   8.615  1.00 47.14           N  
ATOM   1374  CA  SER   184      10.221  32.550   9.614  1.00 43.59           C  
ATOM   1375  C   SER   184       8.890  31.810   9.444  1.00 36.29           C  
ATOM   1376  O   SER   184       7.917  32.105  10.148  1.00 37.97           O  
ATOM   1377  CB  SER   184      10.008  34.074   9.592  1.00 48.80           C  
ATOM   1378  OG  SER   184       9.332  34.502   8.416  1.00 50.96           O  
ATOM   1379  N   SER   185       8.850  30.856   8.508  1.00 30.41           N  
ATOM   1380  CA  SER   185       7.675  29.994   8.338  1.00 26.29           C  
ATOM   1381  C   SER   185       7.817  28.621   9.031  1.00 21.47           C  
ATOM   1382  O   SER   185       6.892  27.818   8.996  1.00 18.11           O  
ATOM   1383  CB  SER   185       7.316  29.817   6.853  1.00 28.47           C  
ATOM   1384  OG  SER   185       8.319  29.111   6.138  1.00 27.82           O  
ATOM   1385  N   GLU   186       8.963  28.371   9.663  1.00 18.19           N  
ATOM   1386  CA  GLU   186       9.182  27.112  10.398  1.00 18.84           C  
ATOM   1387  C   GLU   186       8.323  27.056  11.661  1.00 17.96           C  
ATOM   1388  O   GLU   186       8.293  28.003  12.456  1.00 19.32           O  
ATOM   1389  CB  GLU   186      10.659  27.004  10.755  1.00 23.73           C  
ATOM   1390  CG  GLU   186      11.044  25.796  11.583  1.00 28.26           C  
ATOM   1391  CD  GLU   186      12.518  25.820  11.930  1.00 36.25           C  
ATOM   1392  OE1 GLU   186      13.340  25.634  11.009  1.00 41.09           O  
ATOM   1393  OE2 GLU   186      12.845  26.037  13.116  1.00 27.26           O  
ATOM   1394  N   ILE   187       7.595  25.952  11.832  1.00 12.61           N  
ATOM   1395  CA  ILE   187       6.822  25.734  13.033  1.00 14.48           C  
ATOM   1396  C   ILE   187       7.046  24.310  13.512  1.00 11.25           C  
ATOM   1397  O   ILE   187       7.566  23.463  12.777  1.00 12.69           O  
ATOM   1398  CB  ILE   187       5.292  25.927  12.794  1.00 13.62           C  
ATOM   1399  CG1 ILE   187       4.748  24.936  11.756  1.00 16.83           C  
ATOM   1400  CG2 ILE   187       4.981  27.380  12.355  1.00 16.35           C  
ATOM   1401  CD1 ILE   187       3.219  24.939  11.638  1.00 16.25           C  
ATOM   1402  N   TYR   188       6.645  24.058  14.740  1.00 12.52           N  
ATOM   1403  CA  TYR   188       6.685  22.709  15.280  1.00 11.12           C  
ATOM   1404  C   TYR   188       5.284  22.293  15.669  1.00 13.07           C  
ATOM   1405  O   TYR   188       4.590  23.002  16.389  1.00 15.22           O  
ATOM   1406  CB  TYR   188       7.650  22.636  16.469  1.00 12.16           C  
ATOM   1407  CG  TYR   188       9.091  22.682  15.995  1.00 14.96           C  
ATOM   1408  CD1 TYR   188       9.742  21.518  15.624  1.00 14.22           C  
ATOM   1409  CD2 TYR   188       9.788  23.895  15.877  1.00 24.10           C  
ATOM   1410  CE1 TYR   188      11.058  21.533  15.162  1.00 20.23           C  
ATOM   1411  CE2 TYR   188      11.132  23.920  15.405  1.00 17.23           C  
ATOM   1412  CZ  TYR   188      11.740  22.728  15.060  1.00 20.20           C  
ATOM   1413  OH  TYR   188      13.040  22.688  14.585  1.00 22.77           O  
ATOM   1414  N   ILE   189       4.848  21.170  15.112  1.00 10.86           N  
ATOM   1415  CA  ILE   189       3.551  20.614  15.382  1.00 11.58           C  
ATOM   1416  C   ILE   189       3.700  19.439  16.344  1.00 12.48           C  
ATOM   1417  O   ILE   189       4.542  18.576  16.131  1.00 10.76           O  
ATOM   1418  CB  ILE   189       2.904  20.096  14.062  1.00 12.23           C  
ATOM   1419  CG1 ILE   189       2.816  21.238  13.017  1.00 13.52           C  
ATOM   1420  CG2 ILE   189       1.567  19.495  14.350  1.00 13.92           C  
ATOM   1421  CD1 ILE   189       2.330  20.833  11.608  1.00 13.20           C  
ATOM   1422  N   MET   190       2.902  19.413  17.410  1.00 10.89           N  
ATOM   1423  CA  MET   190       2.932  18.331  18.373  1.00 10.73           C  
ATOM   1424  C   MET   190       1.579  17.719  18.511  1.00 11.66           C  
ATOM   1425  O   MET   190       0.586  18.426  18.642  1.00 14.15           O  
ATOM   1426  CB  MET   190       3.391  18.873  19.717  1.00 14.40           C  
ATOM   1427  CG  MET   190       4.825  19.361  19.671  1.00 11.28           C  
ATOM   1428  SD  MET   190       5.290  20.609  21.075  0.70 15.68          SE  
ATOM   1429  CE  MET   190       4.616  22.239  20.199  1.00 15.83           C  
ATOM   1430  N   PHE   191       1.553  16.402  18.473  1.00 10.91           N  
ATOM   1431  CA  PHE   191       0.346  15.645  18.712  1.00 11.71           C  
ATOM   1432  C   PHE   191       0.498  14.847  19.997  1.00 13.28           C  
ATOM   1433  O   PHE   191       1.502  14.154  20.182  1.00 12.81           O  
ATOM   1434  CB  PHE   191       0.085  14.710  17.541  1.00 13.21           C  
ATOM   1435  CG  PHE   191      -0.197  15.410  16.236  1.00 12.64           C  
ATOM   1436  CD1 PHE   191      -1.429  16.065  15.992  1.00 14.49           C  
ATOM   1437  CD2 PHE   191       0.749  15.408  15.237  1.00 14.78           C  
ATOM   1438  CE1 PHE   191      -1.683  16.692  14.767  1.00 15.89           C  
ATOM   1439  CE2 PHE   191       0.502  16.023  14.015  1.00 13.87           C  
ATOM   1440  CZ  PHE   191      -0.714  16.678  13.776  1.00 14.54           C  
ATOM   1441  N   PHE   192      -0.491  14.916  20.882  1.00 12.86           N  
ATOM   1442  CA  PHE   192      -0.370  14.302  22.207  1.00 14.39           C  
ATOM   1443  C   PHE   192      -1.384  13.187  22.416  1.00 12.55           C  
ATOM   1444  O   PHE   192      -2.570  13.360  22.102  1.00 16.09           O  
ATOM   1445  CB  PHE   192      -0.564  15.354  23.309  1.00 12.50           C  
ATOM   1446  CG  PHE   192       0.479  16.433  23.302  1.00 11.60           C  
ATOM   1447  CD1 PHE   192       1.676  16.297  24.024  1.00 11.91           C  
ATOM   1448  CD2 PHE   192       0.284  17.586  22.557  1.00 13.16           C  
ATOM   1449  CE1 PHE   192       2.655  17.302  23.997  1.00 13.78           C  
ATOM   1450  CE2 PHE   192       1.245  18.597  22.520  1.00 12.61           C  
ATOM   1451  CZ  PHE   192       2.436  18.460  23.242  1.00 15.38           C  
ATOM   1452  N   GLY   193      -0.922  12.057  22.946  1.00 13.98           N  
ATOM   1453  CA  GLY   193      -1.843  11.007  23.383  1.00 15.36           C  
ATOM   1454  C   GLY   193      -2.468  10.213  22.256  1.00 13.95           C  
ATOM   1455  O   GLY   193      -3.678  10.295  21.999  1.00 16.05           O  
ATOM   1456  N   PHE   194      -1.636   9.445  21.562  1.00 13.46           N  
ATOM   1457  CA  PHE   194      -2.059   8.635  20.433  1.00 11.69           C  
ATOM   1458  C   PHE   194      -3.164   7.669  20.824  1.00 13.52           C  
ATOM   1459  O   PHE   194      -3.112   7.089  21.889  1.00 16.71           O  
ATOM   1460  CB  PHE   194      -0.862   7.833  19.914  1.00 13.82           C  
ATOM   1461  CG  PHE   194      -1.163   6.995  18.710  1.00 16.03           C  
ATOM   1462  CD1 PHE   194      -1.590   7.578  17.524  1.00 14.81           C  
ATOM   1463  CD2 PHE   194      -1.003   5.620  18.770  1.00 16.98           C  
ATOM   1464  CE1 PHE   194      -1.858   6.788  16.397  1.00 18.56           C  
ATOM   1465  CE2 PHE   194      -1.271   4.813  17.657  1.00 23.43           C  
ATOM   1466  CZ  PHE   194      -1.702   5.406  16.461  1.00 18.74           C  
ATOM   1467  N   LYS   195      -4.139   7.516  19.967  1.00 18.76           N  
ATOM   1468  CA  LYS   195      -5.181   6.511  20.100  1.00 24.68           C  
ATOM   1469  C   LYS   195      -5.265   5.710  18.826  1.00 26.91           C  
ATOM   1470  O   LYS   195      -5.695   6.190  17.864  1.00 28.15           O  
ATOM   1471  CB  LYS   195      -6.557   7.140  20.275  1.00 28.13           C  
ATOM   1472  CG  LYS   195      -6.727   8.370  21.094  1.00 36.83           C  
ATOM   1473  CD  LYS   195      -8.202   8.847  21.108  1.00 38.91           C  
ATOM   1474  CE  LYS   195      -8.420  10.211  20.514  1.00 50.63           C  
ATOM   1475  NZ  LYS   195      -9.752  10.881  20.750  1.00 53.49           N  
ATOM   1476  N   ALA   196      -4.888   4.461  18.873  1.00 33.64           N  
ATOM   1477  CA  ALA   196      -5.097   3.537  17.757  1.00 41.41           C  
ATOM   1478  C   ALA   196      -6.586   3.396  17.404  1.00 43.93           C  
ATOM   1479  O   ALA   196      -6.926   3.095  16.260  1.00 48.00           O  
ATOM   1480  CB  ALA   196      -4.494   2.188  18.068  1.00 40.11           C  
END
