
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  219 ( 1719),  selected  219 , name 3bkw_A
# Molecule2: number of CA atoms  174 ( 1400),  selected  174 , name T0508.pdb
# PARAMETERS: 3bkw_A.T0508.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      Q      17           -
LGA    -       -      L      18           -
LGA    -       -      R      19           -
LGA    G    24_A      S      20          1.380
LGA    -       -      R      21           -
LGA    L    25_A      A      22          3.787
LGA    D    26_A      A      23          5.135
LGA    G    27_A      F      24           #
LGA    A    28_A      -       -           -
LGA    A    29_A      -       -           -
LGA    E    30_A      K      25          3.629
LGA    W    31_A      L      26          3.488
LGA    P    32_A      E      27          4.071
LGA    A    33_A      F      28          3.562
LGA    L    34_A      L      29          2.405
LGA    R    35_A      L      30          2.579
LGA    A    36_A      D      31          3.001
LGA    -       -      R      32           -
LGA    X    37_A      Y      33          2.463
LGA    L    38_A      R      34          3.436
LGA    P    39_A      V      35          3.114
LGA    E    40_A      V      36          4.683
LGA    V    41_A      R      37          2.801
LGA    G    42_A      K      38          1.489
LGA    G    43_A      G      39          1.120
LGA    L    44_A      D      40          1.011
LGA    R    45_A      A      41          0.614
LGA    I    46_A      V      42          0.777
LGA    V    47_A      I      43          0.983
LGA    D    48_A      E      44          0.632
LGA    L    49_A      I      45          0.450
LGA    G    50_A      G      46          0.711
LGA    C    51_A      S      47          0.505
LGA    G    52_A      S      48          0.961
LGA    F    53_A      P      49          1.026
LGA    G    54_A      G      50          1.655
LGA    W    55_A      G      51          1.517
LGA    F    56_A      W      52          1.296
LGA    C    57_A      T      53          1.438
LGA    R    58_A      Q      54          1.706
LGA    W    59_A      V      55          1.389
LGA    A    60_A      L      56          1.268
LGA    H    61_A      N      57          1.327
LGA    E    62_A      S      58          1.886
LGA    H    63_A      L      59          2.654
LGA    G    64_A      -       -           -
LGA    A    65_A      A      60          1.383
LGA    S    66_A      R      61          1.005
LGA    Y    67_A      K      62          0.540
LGA    V    68_A      I      63          0.574
LGA    L    69_A      I      64          0.636
LGA    G    70_A      S      65          0.626
LGA    L    71_A      I      66          0.164
LGA    D    72_A      D      67          0.281
LGA    L    73_A      L      68          1.093
LGA    S    74_A      Q      69          1.656
LGA    E    75_A      E      70          3.559
LGA    K    76_A      -       -           -
LGA    X    77_A      -       -           -
LGA    L    78_A      M      71          2.820
LGA    A    79_A      -       -           -
LGA    R    80_A      -       -           -
LGA    A    81_A      E      72          2.046
LGA    R    82_A      E      73          1.086
LGA    A    83_A      -       -           -
LGA    A    84_A      -       -           -
LGA    G    85_A      I      74          2.768
LGA    P    86_A      A      75          2.336
LGA    D    87_A      -       -           -
LGA    T    88_A      -       -           -
LGA    G    89_A      G      76          2.200
LGA    I    90_A      V      77          0.566
LGA    T    91_A      R      78          0.739
LGA    Y    92_A      F      79          0.465
LGA    E    93_A      I      80          0.501
LGA    R    94_A      R      81          1.056
LGA    A    95_A      C      82          1.534
LGA    D    96_A      D      83          1.249
LGA    L    97_A      I      84          1.857
LGA    D    98_A      F      85          1.620
LGA    K    99_A      K      86          3.265
LGA    -       -      E      87           -
LGA    -       -      T      88           -
LGA    L   100_A      I      89          3.669
LGA    H   101_A      F      90          1.817
LGA    -       -      D      91           -
LGA    -       -      D      92           -
LGA    L   102_A      I      93          3.713
LGA    P   103_A      D      94          3.257
LGA    Q   104_A      R      95           -
LGA    -       -      A      96           -
LGA    -       -      L      97           -
LGA    -       -      R      98           -
LGA    -       -      E      99           -
LGA    -       -      E     100           -
LGA    -       -      G     101           -
LGA    -       -      I     102           -
LGA    D   105_A      E     103          3.953
LGA    S   106_A      K     104          2.696
LGA    F   107_A      V     105          0.977
LGA    D   108_A      D     106          0.414
LGA    L   109_A      D     107          0.986
LGA    A   110_A      V     108          0.914
LGA    Y   111_A      V     109          0.958
LGA    S   112_A      S     110          0.985
LGA    S   113_A      D     111          1.406
LGA    L   114_A      A     112          4.302
LGA    A   115_A      M     113          2.848
LGA    L   116_A      A     114           -
LGA    H   117_A      K     115           -
LGA    -       -      V     116           -
LGA    -       -      S     117           -
LGA    -       -      G     118           -
LGA    -       -      I     119           -
LGA    -       -      P     120           -
LGA    -       -      S     121           -
LGA    -       -      R     122           -
LGA    -       -      D     123           -
LGA    -       -      H     124           -
LGA    -       -      A     125           -
LGA    Y   118_A      V     126          3.403
LGA    -       -      S     127           -
LGA    -       -      Y     128           -
LGA    V   119_A      Q     129          2.956
LGA    E   120_A      I     130           #
LGA    D   121_A      -       -           -
LGA    V   122_A      G     131          4.029
LGA    A   123_A      Q     132          3.290
LGA    R   124_A      R     133          4.449
LGA    L   125_A      V     134          3.491
LGA    F   126_A      M     135          1.074
LGA    R   127_A      E     136          2.626
LGA    T   128_A      I     137          2.251
LGA    V   129_A      A     138          0.969
LGA    H   130_A      V     139          1.338
LGA    Q   131_A      R     140          1.969
LGA    A   132_A      Y     141          0.468
LGA    L   133_A      L     142          0.745
LGA    S   134_A      R     143          0.853
LGA    P   135_A      N     144          0.868
LGA    G   136_A      G     145          0.364
LGA    G   137_A      G     146          0.552
LGA    H   138_A      N     147          0.407
LGA    F   139_A      V     148          0.472
LGA    V   140_A      L     149          0.864
LGA    F   141_A      L     150          1.519
LGA    S   142_A      K     151          1.652
LGA    T   143_A      Q     152          1.761
LGA    E   144_A      F     153          1.774
LGA    H   145_A      Q     154          2.233
LGA    P   146_A      G     155          2.171
LGA    I   147_A      -       -           -
LGA    Y   148_A      -       -           -
LGA    X   149_A      -       -           -
LGA    A   150_A      -       -           -
LGA    P   151_A      -       -           -
LGA    A   152_A      -       -           -
LGA    R   153_A      -       -           -
LGA    P   154_A      -       -           -
LGA    G   155_A      -       -           -
LGA    W   156_A      -       -           -
LGA    A   157_A      -       -           -
LGA    I   158_A      -       -           -
LGA    D   159_A      -       -           -
LGA    A   160_A      -       -           -
LGA    E   161_A      -       -           -
LGA    G   162_A      -       -           -
LGA    R   163_A      -       -           -
LGA    R   164_A      -       -           -
LGA    T   165_A      -       -           -
LGA    W   166_A      -       -           -
LGA    P   167_A      -       -           -
LGA    I   168_A      -       -           -
LGA    D   169_A      -       -           -
LGA    R   170_A      -       -           -
LGA    Y   171_A      -       -           -
LGA    L   172_A      -       -           -
LGA    V   173_A      -       -           -
LGA    E   174_A      -       -           -
LGA    G   175_A      -       -           -
LGA    P   176_A      -       -           -
LGA    R   177_A      -       -           -
LGA    K   178_A      -       -           -
LGA    T   179_A      -       -           -
LGA    D   180_A      -       -           -
LGA    W   181_A      -       -           -
LGA    L   182_A      -       -           -
LGA    A   183_A      -       -           -
LGA    K   184_A      -       -           -
LGA    G   185_A      -       -           -
LGA    V   186_A      -       -           -
LGA    V   187_A      -       -           -
LGA    K   188_A      -       -           -
LGA    H   189_A      -       -           -
LGA    H   190_A      -       -           -
LGA    R   191_A      D     156          4.366
LGA    T   192_A      M     157          2.777
LGA    V   193_A      T     158          2.175
LGA    G   194_A      N     159          0.884
LGA    T   195_A      D     160          2.066
LGA    T   196_A      F     161          1.938
LGA    L   197_A      I     162          0.285
LGA    N   198_A      A     163          2.346
LGA    A   199_A      I     164          3.336
LGA    L   200_A      W     165          1.389
LGA    I   201_A      R     166          2.880
LGA    R   202_A      K     167          5.174
LGA    S   203_A      -       -           -
LGA    G   204_A      N     168          2.229
LGA    F   205_A      F     169          3.081
LGA    A   206_A      S     170          3.743
LGA    I   207_A      S     171          3.398
LGA    E   208_A      Y     172          2.329
LGA    H   209_A      K     173          1.231
LGA    V   210_A      I     174          1.555
LGA    E   211_A      S     175          2.081
LGA    E   212_A      -       -           -
LGA    F   213_A      K     176          1.151
LGA    C   214_A      P     177          5.432
LGA    P   215_A      -       -           -
LGA    T   216_A      -       -           -
LGA    D   217_A      -       -           -
LGA    A   218_A      -       -           -
LGA    Q   219_A      -       -           -
LGA    I   220_A      -       -           -
LGA    T   221_A      -       -           -
LGA    A   222_A      -       -           -
LGA    R   223_A      -       -           -
LGA    P   224_A      -       -           -
LGA    E   225_A      -       -           -
LGA    L   226_A      -       -           -
LGA    A   227_A      -       -           -
LGA    E   228_A      -       -           -
LGA    E   229_A      -       -           -
LGA    L   230_A      -       -           -
LGA    D   231_A      -       -           -
LGA    R   232_A      -       -           -
LGA    P   233_A      S     184          3.883
LGA    X   234_A      S     185          2.582
LGA    F   235_A      E     186          1.611
LGA    L   236_A      I     187          1.492
LGA    L   237_A      Y     188          1.258
LGA    V   238_A      I     189          1.199
LGA    S   239_A      M     190          1.067
LGA    A   240_A      F     191          0.565
LGA    R   241_A      F     192          2.528
LGA    -       -      G     193           -
LGA    R   242_A      F     194          0.543
LGA    -       -      K     195           -
LGA    -       -      A     196           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  219  174    5.0    138    2.29    13.77     61.090     5.763

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.447431 * X  +  -0.889969 * Y  +   0.088092 * Z  +  21.922625
  Y_new =  -0.779407 * X  +  -0.436347 * Y  +  -0.449585 * Z  +  66.948479
  Z_new =   0.438555 * X  +   0.132499 * Y  +  -0.888883 * Z  +  14.562644 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.993620   -0.147973  [ DEG:   171.5218     -8.4782 ]
  Theta =  -0.453990   -2.687602  [ DEG:   -26.0117   -153.9883 ]
  Phi   =  -1.049664    2.091928  [ DEG:   -60.1413    119.8587 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3bkw_A                                        
REMARK     2: T0508.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3bkw_A.T0508.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  219  174   5.0  138   2.29   13.77  61.090
REMARK  ---------------------------------------------------------- 
MOLECULE 3bkw_A
HEADER    TRANSFERASE                             07-DEC-07   3BKW              
TITLE     CRYSTAL STRUCTURE OF S-ADENOSYLMETHIONINE DEPENDENT                   
TITLE    2 METHYLTRANSFERASE (NP_104914.1) FROM MESORHIZOBIUM LOTI AT           
TITLE    3 1.60 A RESOLUTION                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: S-ADENOSYLMETHIONINE DEPENDENT METHYLTRANSFERASE;          
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: MLL3908 PROTEIN;                                            
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MESORHIZOBIUM LOTI MAFF303099;                  
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: MAFF303099;                                                  
SOURCE   5 GENE: NP_104914.1, MLL3908;                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    NP_104914.1, S-ADENOSYLMETHIONINE DEPENDENT                           
KEYWDS   2 METHYLTRANSFERASE, METHYLTRANSFERASE DOMAIN, STRUCTURAL              
KEYWDS   3 GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG,                
KEYWDS   4 PROTEIN STRUCTURE INITIATIVE, PSI-2                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   18-DEC-07 3BKW    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF S-ADENOSYLMETHIONINE                    
JRNL        TITL 2 DEPENDENT METHYLTRANSFERASE (NP_104914.1) FROM               
JRNL        TITL 3 MESORHIZOBIUM LOTI AT 1.60 A RESOLUTION                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
DBREF  3BKW A    1   242  UNP    Q98F67   Q98F67_RHILO     1    242             
DBREF  3BKW B    1   242  UNP    Q98F67   Q98F67_RHILO     1    242             
SEQRES   1 A  243  GLY MSE ALA GLN ASN ILE TYR ASP GLN PRO ASP PHE PHE          
SEQRES   2 A  243  ALA GLY TYR SER GLN LEU GLY ARG SER ILE GLU GLY LEU          
SEQRES   3 A  243  ASP GLY ALA ALA GLU TRP PRO ALA LEU ARG ALA MSE LEU          
SEQRES   4 A  243  PRO GLU VAL GLY GLY LEU ARG ILE VAL ASP LEU GLY CYS          
SEQRES   5 A  243  GLY PHE GLY TRP PHE CYS ARG TRP ALA HIS GLU HIS GLY          
SEQRES   6 A  243  ALA SER TYR VAL LEU GLY LEU ASP LEU SER GLU LYS MSE          
SEQRES   7 A  243  LEU ALA ARG ALA ARG ALA ALA GLY PRO ASP THR GLY ILE          
SEQRES   8 A  243  THR TYR GLU ARG ALA ASP LEU ASP LYS LEU HIS LEU PRO          
SEQRES   9 A  243  GLN ASP SER PHE ASP LEU ALA TYR SER SER LEU ALA LEU          
SEQRES  10 A  243  HIS TYR VAL GLU ASP VAL ALA ARG LEU PHE ARG THR VAL          
SEQRES  11 A  243  HIS GLN ALA LEU SER PRO GLY GLY HIS PHE VAL PHE SER          
SEQRES  12 A  243  THR GLU HIS PRO ILE TYR MSE ALA PRO ALA ARG PRO GLY          
SEQRES  13 A  243  TRP ALA ILE ASP ALA GLU GLY ARG ARG THR TRP PRO ILE          
SEQRES  14 A  243  ASP ARG TYR LEU VAL GLU GLY PRO ARG LYS THR ASP TRP          
SEQRES  15 A  243  LEU ALA LYS GLY VAL VAL LYS HIS HIS ARG THR VAL GLY          
SEQRES  16 A  243  THR THR LEU ASN ALA LEU ILE ARG SER GLY PHE ALA ILE          
SEQRES  17 A  243  GLU HIS VAL GLU GLU PHE CYS PRO THR ASP ALA GLN ILE          
SEQRES  18 A  243  THR ALA ARG PRO GLU LEU ALA GLU GLU LEU ASP ARG PRO          
SEQRES  19 A  243  MSE PHE LEU LEU VAL SER ALA ARG ARG                          
SEQRES   1 B  243  GLY MSE ALA GLN ASN ILE TYR ASP GLN PRO ASP PHE PHE          
SEQRES   2 B  243  ALA GLY TYR SER GLN LEU GLY ARG SER ILE GLU GLY LEU          
SEQRES   3 B  243  ASP GLY ALA ALA GLU TRP PRO ALA LEU ARG ALA MSE LEU          
SEQRES   4 B  243  PRO GLU VAL GLY GLY LEU ARG ILE VAL ASP LEU GLY CYS          
SEQRES   5 B  243  GLY PHE GLY TRP PHE CYS ARG TRP ALA HIS GLU HIS GLY          
SEQRES   6 B  243  ALA SER TYR VAL LEU GLY LEU ASP LEU SER GLU LYS MSE          
SEQRES   7 B  243  LEU ALA ARG ALA ARG ALA ALA GLY PRO ASP THR GLY ILE          
SEQRES   8 B  243  THR TYR GLU ARG ALA ASP LEU ASP LYS LEU HIS LEU PRO          
SEQRES   9 B  243  GLN ASP SER PHE ASP LEU ALA TYR SER SER LEU ALA LEU          
SEQRES  10 B  243  HIS TYR VAL GLU ASP VAL ALA ARG LEU PHE ARG THR VAL          
SEQRES  11 B  243  HIS GLN ALA LEU SER PRO GLY GLY HIS PHE VAL PHE SER          
SEQRES  12 B  243  THR GLU HIS PRO ILE TYR MSE ALA PRO ALA ARG PRO GLY          
SEQRES  13 B  243  TRP ALA ILE ASP ALA GLU GLY ARG ARG THR TRP PRO ILE          
SEQRES  14 B  243  ASP ARG TYR LEU VAL GLU GLY PRO ARG LYS THR ASP TRP          
SEQRES  15 B  243  LEU ALA LYS GLY VAL VAL LYS HIS HIS ARG THR VAL GLY          
SEQRES  16 B  243  THR THR LEU ASN ALA LEU ILE ARG SER GLY PHE ALA ILE          
SEQRES  17 B  243  GLU HIS VAL GLU GLU PHE CYS PRO THR ASP ALA GLN ILE          
SEQRES  18 B  243  THR ALA ARG PRO GLU LEU ALA GLU GLU LEU ASP ARG PRO          
SEQRES  19 B  243  MSE PHE LEU LEU VAL SER ALA ARG ARG                          
HET    MSE  A  37       8                                                       
HET    MSE  A  77      13                                                       
HET    MSE  A 149       8                                                       
HET    MSE  A 234       8                                                       
HET    MSE  B  37       8                                                       
HET    MSE  B  77       8                                                       
HET    MSE  B 149       8                                                       
HET    MSE  B 234       8                                                       
HET    EDO  A 243       4                                                       
HET    EDO  A 244       4                                                       
HET    EDO  B 243       4                                                       
HET    EDO  A 245       4                                                       
HET    EDO  A 246       4                                                       
HET    EDO  B 244       4                                                       
HET    EDO  A 247       4                                                       
HET    EDO  A 248       4                                                       
HET    EDO  B 245       4                                                       
HET    EDO  B 246       4                                                       
HET    EDO  A 249       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   3  EDO    11(C2 H6 O2)                                                 
FORMUL  14  HOH   *486(H2 O)                                                    
CRYST1   58.330   58.480  142.030  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   GLY A  24      24.856  23.808  18.330  1.00 50.50           N  
ATOM      2  CA  GLY A  24      23.843  22.730  18.093  1.00 49.36           C  
ATOM      3  C   GLY A  24      22.453  23.167  18.522  1.00 49.03           C  
ATOM      4  O   GLY A  24      21.887  24.090  17.920  1.00 49.54           O  
ATOM      5  N   LEU A  25      21.904  22.515  19.555  1.00 47.68           N  
ATOM      6  CA  LEU A  25      20.553  22.842  20.078  1.00 47.63           C  
ATOM      7  C   LEU A  25      20.486  24.248  20.666  1.00 47.37           C  
ATOM      8  O   LEU A  25      19.514  24.968  20.437  1.00 48.03           O  
ATOM      9  CB  LEU A  25      20.098  21.824  21.131  1.00 47.69           C  
ATOM     10  CG  LEU A  25      19.925  20.381  20.668  1.00 44.71           C  
ATOM     11  CD1 LEU A  25      19.620  19.506  21.846  1.00 37.74           C  
ATOM     12  CD2 LEU A  25      18.841  20.272  19.606  1.00 43.63           C  
ATOM     13  N   ASP A  26      21.530  24.643  21.391  1.00 48.06           N  
ATOM     14  CA  ASP A  26      21.608  26.003  21.970  1.00 49.41           C  
ATOM     15  C   ASP A  26      21.670  27.124  20.905  1.00 48.51           C  
ATOM     16  O   ASP A  26      21.412  28.288  21.228  1.00 50.31           O  
ATOM     17  CB  ASP A  26      22.777  26.112  22.967  1.00 51.71           C  
ATOM     18  CG  ASP A  26      22.618  25.175  24.171  1.00 56.61           C  
ATOM     19  OD1 ASP A  26      21.477  24.979  24.660  1.00 62.81           O  
ATOM     20  OD2 ASP A  26      23.649  24.635  24.631  1.00 66.89           O  
ATOM     21  N   GLY A  27      22.025  26.771  19.664  1.00 45.87           N  
ATOM     22  CA  GLY A  27      22.012  27.690  18.533  1.00 44.84           C  
ATOM     23  C   GLY A  27      20.656  27.809  17.834  1.00 44.33           C  
ATOM     24  O   GLY A  27      20.430  28.798  17.130  1.00 45.75           O  
ATOM     25  N   ALA A  28      19.768  26.819  18.007  1.00 39.30           N  
ATOM     26  CA  ALA A  28      18.442  26.807  17.352  1.00 38.11           C  
ATOM     27  C   ALA A  28      17.448  27.608  18.177  1.00 34.93           C  
ATOM     28  O   ALA A  28      17.091  27.202  19.284  1.00 33.09           O  
ATOM     29  CB  ALA A  28      17.938  25.384  17.162  1.00 36.63           C  
ATOM     30  N   ALA A  29      16.990  28.732  17.617  1.00 33.36           N  
ATOM     31  CA  ALA A  29      16.041  29.638  18.274  1.00 33.41           C  
ATOM     32  C   ALA A  29      14.766  28.953  18.705  1.00 31.11           C  
ATOM     33  O   ALA A  29      14.219  29.282  19.759  1.00 31.00           O  
ATOM     34  CB  ALA A  29      15.684  30.812  17.347  1.00 33.90           C  
ATOM     35  N   GLU A  30      14.301  28.016  17.873  1.00 32.16           N  
ATOM     36  CA  GLU A  30      13.077  27.263  18.139  1.00 30.59           C  
ATOM     37  C   GLU A  30      13.217  26.046  19.063  1.00 31.95           C  
ATOM     38  O   GLU A  30      12.195  25.446  19.413  1.00 30.66           O  
ATOM     39  CB  GLU A  30      12.379  26.832  16.831  1.00 31.62           C  
ATOM     40  CG  GLU A  30      12.905  25.606  16.075  1.00 32.40           C  
ATOM     41  CD  GLU A  30      14.282  25.751  15.420  1.00 36.32           C  
ATOM     42  OE1 GLU A  30      14.926  26.831  15.496  1.00 33.16           O  
ATOM     43  OE2 GLU A  30      14.716  24.745  14.810  1.00 38.03           O  
ATOM     44  N   TRP A  31      14.442  25.688  19.450  1.00 30.75           N  
ATOM     45  CA  TRP A  31      14.649  24.529  20.332  1.00 30.91           C  
ATOM     46  C   TRP A  31      13.944  24.640  21.689  1.00 29.96           C  
ATOM     47  O   TRP A  31      13.243  23.706  22.058  1.00 30.09           O  
ATOM     48  CB  TRP A  31      16.125  24.137  20.464  1.00 30.52           C  
ATOM     49  CG  TRP A  31      16.414  23.221  21.613  1.00 28.23           C  
ATOM     50  CD1 TRP A  31      17.146  23.516  22.698  1.00 30.28           C  
ATOM     51  CD2 TRP A  31      15.932  21.881  21.795  1.00 27.05           C  
ATOM     52  NE1 TRP A  31      17.178  22.454  23.547  1.00 29.60           N  
ATOM     53  CE2 TRP A  31      16.431  21.435  23.033  1.00 28.44           C  
ATOM     54  CE3 TRP A  31      15.110  21.025  21.046  1.00 29.84           C  
ATOM     55  CZ2 TRP A  31      16.182  20.154  23.533  1.00 29.95           C  
ATOM     56  CZ3 TRP A  31      14.835  19.730  21.551  1.00 29.30           C  
ATOM     57  CH2 TRP A  31      15.368  19.319  22.793  1.00 27.66           C  
ATOM     58  N   PRO A  32      14.137  25.744  22.439  1.00 30.24           N  
ATOM     59  CA  PRO A  32      13.427  25.843  23.723  1.00 30.93           C  
ATOM     60  C   PRO A  32      11.906  25.664  23.667  1.00 30.22           C  
ATOM     61  O   PRO A  32      11.339  24.988  24.531  1.00 31.58           O  
ATOM     62  CB  PRO A  32      13.810  27.233  24.216  1.00 31.82           C  
ATOM     63  CG  PRO A  32      15.140  27.485  23.587  1.00 33.90           C  
ATOM     64  CD  PRO A  32      15.037  26.892  22.235  1.00 32.28           C  
ATOM     65  N   ALA A  33      11.269  26.241  22.649  1.00 31.69           N  
ATOM     66  CA  ALA A  33       9.823  26.093  22.424  1.00 31.59           C  
ATOM     67  C   ALA A  33       9.435  24.657  22.121  1.00 29.15           C  
ATOM     68  O   ALA A  33       8.447  24.159  22.661  1.00 32.25           O  
ATOM     69  CB  ALA A  33       9.378  26.981  21.287  1.00 31.84           C  
ATOM     70  N   LEU A  34      10.229  23.991  21.287  1.00 27.90           N  
ATOM     71  CA  LEU A  34       9.967  22.589  20.914  1.00 29.79           C  
ATOM     72  C   LEU A  34      10.252  21.668  22.106  1.00 27.87           C  
ATOM     73  O   LEU A  34       9.456  20.771  22.413  1.00 29.07           O  
ATOM     74  CB  LEU A  34      10.782  22.210  19.671  1.00 29.78           C  
ATOM     75  CG  LEU A  34      10.360  20.943  18.937  1.00 32.94           C  
ATOM     76  CD1 LEU A  34       8.917  21.077  18.451  1.00 29.68           C  
ATOM     77  CD2 LEU A  34      11.336  20.623  17.797  1.00 33.79           C  
ATOM     78  N   ARG A  35      11.354  21.939  22.823  1.00 29.10           N  
ATOM     79  CA  ARG A  35      11.716  21.189  24.037  1.00 29.76           C  
ATOM     80  C   ARG A  35      10.586  21.243  25.081  1.00 27.87           C  
ATOM     81  O   ARG A  35      10.260  20.234  25.705  1.00 30.26           O  
ATOM     82  CB  ARG A  35      12.998  21.748  24.642  1.00 30.97           C  
ATOM     83  CG  ARG A  35      13.464  21.035  25.927  1.00 28.66           C  
ATOM     84  CD  ARG A  35      14.693  21.721  26.491  1.00 32.46           C  
ATOM     85  NE  ARG A  35      14.424  23.114  26.820  1.00 34.70           N  
ATOM     86  CZ  ARG A  35      15.340  24.076  26.990  1.00 39.29           C  
ATOM     87  NH1 ARG A  35      16.653  23.834  26.860  1.00 48.61           N  
ATOM     88  NH2 ARG A  35      14.941  25.315  27.282  1.00 43.36           N  
ATOM     89  N   ALA A  36       9.984  22.427  25.236  1.00 28.70           N  
ATOM     90  CA  ALA A  36       8.871  22.630  26.174  1.00 29.67           C  
ATOM     91  C   ALA A  36       7.632  21.787  25.860  1.00 29.35           C  
ATOM     92  O   ALA A  36       6.852  21.464  26.766  1.00 30.18           O  
ATOM     93  CB  ALA A  36       8.501  24.087  26.238  1.00 30.18           C  
HETATM   94  N   MSE A  37       7.485  21.413  24.584  1.00 27.95           N  
HETATM   95  CA  MSE A  37       6.372  20.605  24.092  1.00 28.21           C  
HETATM   96  C   MSE A  37       6.573  19.105  24.259  1.00 27.73           C  
HETATM   97  O   MSE A  37       5.612  18.335  24.184  1.00 29.37           O  
HETATM   98  CB  MSE A  37       6.123  20.950  22.634  1.00 29.44           C  
HETATM   99  CG  MSE A  37       5.686  22.382  22.441  1.00 27.48           C  
HETATM  100 SE   MSE A  37       5.790  22.956  20.614  0.75 29.44          SE  
HETATM  101  CE  MSE A  37       4.697  21.590  19.768  1.00 29.87           C  
ATOM    102  N   LEU A  38       7.809  18.686  24.522  1.00 28.63           N  
ATOM    103  CA  LEU A  38       8.119  17.278  24.689  1.00 28.51           C  
ATOM    104  C   LEU A  38       7.559  16.743  25.985  1.00 29.18           C  
ATOM    105  O   LEU A  38       7.397  17.494  26.943  1.00 30.35           O  
ATOM    106  CB  LEU A  38       9.634  17.063  24.752  1.00 28.54           C  
ATOM    107  CG  LEU A  38      10.466  17.451  23.536  1.00 27.44           C  
ATOM    108  CD1 LEU A  38      11.956  17.348  23.921  1.00 28.23           C  
ATOM    109  CD2 LEU A  38      10.099  16.558  22.335  1.00 30.40           C  
ATOM    110  N   PRO A  39       7.265  15.434  26.027  1.00 30.17           N  
ATOM    111  CA  PRO A  39       6.925  14.840  27.304  1.00 30.66           C  
ATOM    112  C   PRO A  39       8.234  14.697  28.111  1.00 31.81           C  
ATOM    113  O   PRO A  39       9.316  14.916  27.558  1.00 30.81           O  
ATOM    114  CB  PRO A  39       6.417  13.459  26.894  1.00 30.71           C  
ATOM    115  CG  PRO A  39       7.230  13.146  25.687  1.00 31.74           C  
ATOM    116  CD  PRO A  39       7.280  14.421  24.952  1.00 31.41           C  
ATOM    117  N   GLU A  40       8.141  14.352  29.391  1.00 31.81           N  
ATOM    118  CA  GLU A  40       9.345  14.009  30.148  1.00 31.90           C  
ATOM    119  C   GLU A  40      10.015  12.814  29.424  1.00 31.75           C  
ATOM    120  O   GLU A  40       9.380  11.787  29.213  1.00 32.32           O  
ATOM    121  CB  GLU A  40       8.987  13.667  31.598  1.00 33.49           C  
ATOM    122  CG  GLU A  40      10.132  13.071  32.417  1.00 37.98           C  
ATOM    123  CD  GLU A  40      11.353  13.961  32.479  1.00 44.64           C  
ATOM    124  OE1 GLU A  40      11.201  15.143  32.863  1.00 45.81           O  
ATOM    125  OE2 GLU A  40      12.452  13.465  32.157  1.00 43.35           O  
ATOM    126  N   VAL A  41      11.280  12.969  29.042  1.00 30.68           N  
ATOM    127  CA  VAL A  41      11.985  11.947  28.244  1.00 30.44           C  
ATOM    128  C   VAL A  41      12.614  10.829  29.065  1.00 29.59           C  
ATOM    129  O   VAL A  41      13.041   9.827  28.493  1.00 30.18           O  
ATOM    130  CB  VAL A  41      13.034  12.560  27.260  1.00 30.51           C  
ATOM    131  CG1 VAL A  41      12.355  13.550  26.266  1.00 28.94           C  
ATOM    132  CG2 VAL A  41      14.211  13.212  27.998  1.00 29.99           C  
ATOM    133  N   GLY A  42      12.660  10.984  30.396  1.00 30.34           N  
ATOM    134  CA  GLY A  42      13.249   9.991  31.268  1.00 29.11           C  
ATOM    135  C   GLY A  42      12.579   8.635  31.135  1.00 30.19           C  
ATOM    136  O   GLY A  42      11.354   8.530  31.268  1.00 31.69           O  
ATOM    137  N   GLY A  43      13.386   7.631  30.798  1.00 28.46           N  
ATOM    138  CA  GLY A  43      12.942   6.258  30.653  1.00 29.65           C  
ATOM    139  C   GLY A  43      12.239   5.929  29.351  1.00 27.76           C  
ATOM    140  O   GLY A  43      11.836   4.769  29.158  1.00 31.77           O  
ATOM    141  N   LEU A  44      12.131   6.895  28.427  1.00 27.28           N  
ATOM    142  CA  LEU A  44      11.389   6.668  27.188  1.00 27.01           C  
ATOM    143  C   LEU A  44      12.224   6.050  26.086  1.00 28.51           C  
ATOM    144  O   LEU A  44      13.442   6.200  26.045  1.00 27.39           O  
ATOM    145  CB  LEU A  44      10.775   7.971  26.635  1.00 27.17           C  
ATOM    146  CG  LEU A  44       9.788   8.761  27.498  1.00 27.14           C  
ATOM    147  CD1 LEU A  44       9.126   9.834  26.610  1.00 30.81           C  
ATOM    148  CD2 LEU A  44       8.737   7.857  28.153  1.00 28.61           C  
ATOM    149  N   ARG A  45      11.517   5.363  25.195  1.00 27.80           N  
ATOM    150  CA  ARG A  45      12.055   4.823  23.959  1.00 26.26           C  
ATOM    151  C   ARG A  45      11.707   5.905  22.938  1.00 26.13           C  
ATOM    152  O   ARG A  45      10.531   6.270  22.801  1.00 26.94           O  
ATOM    153  CB  ARG A  45      11.384   3.523  23.604  1.00 26.95           C  
ATOM    154  CG  ARG A  45      11.567   2.436  24.680  1.00 30.03           C  
ATOM    155  CD  ARG A  45      10.639   1.290  24.401  1.00 34.36           C  
ATOM    156  NE  ARG A  45       9.249   1.725  24.547  1.00 32.21           N  
ATOM    157  CZ  ARG A  45       8.186   1.076  24.075  1.00 36.26           C  
ATOM    158  NH1 ARG A  45       8.286  -0.094  23.447  1.00 36.61           N  
ATOM    159  NH2 ARG A  45       6.990   1.606  24.255  1.00 35.61           N  
ATOM    160  N   ILE A  46      12.726   6.421  22.249  1.00 26.67           N  
ATOM    161  CA  ILE A  46      12.573   7.567  21.354  1.00 27.19           C  
ATOM    162  C   ILE A  46      13.139   7.307  19.972  1.00 26.98           C  
ATOM    163  O   ILE A  46      14.195   6.677  19.841  1.00 27.92           O  
ATOM    164  CB  ILE A  46      13.304   8.802  21.954  1.00 26.49           C  
ATOM    165  CG1 ILE A  46      12.837   9.083  23.391  1.00 26.24           C  
ATOM    166  CG2 ILE A  46      13.109  10.056  21.059  1.00 28.32           C  
ATOM    167  CD1 ILE A  46      13.557  10.241  24.102  1.00 25.47           C  
ATOM    168  N   VAL A  47      12.434   7.790  18.939  1.00 26.30           N  
ATOM    169  CA  VAL A  47      12.949   7.761  17.576  1.00 27.33           C  
ATOM    170  C   VAL A  47      13.078   9.213  17.095  1.00 26.57           C  
ATOM    171  O   VAL A  47      12.147  10.000  17.275  1.00 27.49           O  
ATOM    172  CB  VAL A  47      12.126   6.873  16.607  1.00 25.39           C  
ATOM    173  CG1 VAL A  47      10.658   7.311  16.509  1.00 26.23           C  
ATOM    174  CG2 VAL A  47      12.789   6.834  15.223  1.00 29.16           C  
ATOM    175  N   ASP A  48      14.228   9.538  16.490  1.00 26.75           N  
ATOM    176  CA  ASP A  48      14.524  10.849  15.948  1.00 27.74           C  
ATOM    177  C   ASP A  48      14.544  10.721  14.443  1.00 26.79           C  
ATOM    178  O   ASP A  48      15.431  10.076  13.896  1.00 26.87           O  
ATOM    179  CB  ASP A  48      15.876  11.342  16.483  1.00 26.68           C  
ATOM    180  CG  ASP A  48      16.230  12.733  16.020  1.00 28.96           C  
ATOM    181  OD1 ASP A  48      15.528  13.285  15.160  1.00 29.56           O  
ATOM    182  OD2 ASP A  48      17.196  13.298  16.550  1.00 31.07           O  
ATOM    183  N   LEU A  49      13.542  11.307  13.780  1.00 27.70           N  
ATOM    184  CA  LEU A  49      13.399  11.220  12.330  1.00 26.79           C  
ATOM    185  C   LEU A  49      14.114  12.388  11.669  1.00 28.60           C  
ATOM    186  O   LEU A  49      13.648  13.531  11.750  1.00 28.91           O  
ATOM    187  CB  LEU A  49      11.912  11.186  11.934  1.00 28.19           C  
ATOM    188  CG  LEU A  49      11.004  10.140  12.576  1.00 31.11           C  
ATOM    189  CD1 LEU A  49       9.540  10.353  12.215  1.00 35.60           C  
ATOM    190  CD2 LEU A  49      11.443   8.757  12.196  1.00 29.33           C  
ATOM    191  N   GLY A  50      15.251  12.096  11.033  1.00 28.52           N  
ATOM    192  CA  GLY A  50      16.106  13.108  10.374  1.00 28.50           C  
ATOM    193  C   GLY A  50      17.017  13.662  11.453  1.00 28.17           C  
ATOM    194  O   GLY A  50      17.079  14.872  11.685  1.00 29.03           O  
ATOM    195  N   CYS A  51      17.766  12.759  12.077  1.00 28.87           N  
ATOM    196  CA  CYS A  51      18.587  13.095  13.242  1.00 28.23           C  
ATOM    197  C   CYS A  51      19.856  13.917  12.979  1.00 27.51           C  
ATOM    198  O   CYS A  51      20.439  14.468  13.929  1.00 28.21           O  
ATOM    199  CB  CYS A  51      18.976  11.812  13.989  1.00 28.11           C  
ATOM    200  SG  CYS A  51      20.081  10.719  13.109  1.00 27.97           S  
ATOM    201  N   GLY A  52      20.303  13.958  11.724  1.00 28.72           N  
ATOM    202  CA  GLY A  52      21.515  14.666  11.357  1.00 29.01           C  
ATOM    203  C   GLY A  52      22.694  14.198  12.185  1.00 28.29           C  
ATOM    204  O   GLY A  52      22.917  12.992  12.347  1.00 27.96           O  
ATOM    205  N   PHE A  53      23.430  15.158  12.747  1.00 30.17           N  
ATOM    206  CA  PHE A  53      24.596  14.893  13.595  1.00 31.77           C  
ATOM    207  C   PHE A  53      24.230  14.289  14.965  1.00 30.92           C  
ATOM    208  O   PHE A  53      25.122  13.945  15.717  1.00 30.52           O  
ATOM    209  CB  PHE A  53      25.410  16.197  13.744  1.00 34.07           C  
ATOM    210  CG  PHE A  53      26.712  16.057  14.515  1.00 37.88           C  
ATOM    211  CD1 PHE A  53      27.656  15.082  14.192  1.00 44.39           C  
ATOM    212  CD2 PHE A  53      27.012  16.952  15.537  1.00 43.81           C  
ATOM    213  CE1 PHE A  53      28.870  14.985  14.925  1.00 42.69           C  
ATOM    214  CE2 PHE A  53      28.217  16.870  16.267  1.00 42.18           C  
ATOM    215  CZ  PHE A  53      29.144  15.887  15.958  1.00 40.99           C  
ATOM    216  N   GLY A  54      22.936  14.167  15.281  1.00 30.15           N  
ATOM    217  CA  GLY A  54      22.479  13.536  16.516  1.00 30.45           C  
ATOM    218  C   GLY A  54      22.390  14.422  17.738  1.00 30.43           C  
ATOM    219  O   GLY A  54      22.393  13.911  18.854  1.00 30.58           O  
ATOM    220  N   TRP A  55      22.256  15.736  17.541  1.00 30.95           N  
ATOM    221  CA  TRP A  55      22.187  16.685  18.658  1.00 30.81           C  
ATOM    222  C   TRP A  55      21.045  16.352  19.630  1.00 29.98           C  
ATOM    223  O   TRP A  55      21.257  16.302  20.846  1.00 29.94           O  
ATOM    224  CB  TRP A  55      21.999  18.128  18.177  1.00 34.73           C  
ATOM    225  CG  TRP A  55      23.080  18.698  17.346  1.00 40.07           C  
ATOM    226  CD1 TRP A  55      23.032  18.953  16.003  1.00 46.56           C  
ATOM    227  CD2 TRP A  55      24.368  19.124  17.793  1.00 43.48           C  
ATOM    228  NE1 TRP A  55      24.222  19.508  15.583  1.00 45.58           N  
ATOM    229  CE2 TRP A  55      25.057  19.636  16.662  1.00 45.58           C  
ATOM    230  CE3 TRP A  55      25.013  19.127  19.041  1.00 45.77           C  
ATOM    231  CZ2 TRP A  55      26.372  20.138  16.740  1.00 45.85           C  
ATOM    232  CZ3 TRP A  55      26.324  19.631  19.125  1.00 47.30           C  
ATOM    233  CH2 TRP A  55      26.988  20.126  17.974  1.00 47.21           C  
ATOM    234  N   PHE A  56      19.860  16.087  19.080  1.00 27.40           N  
ATOM    235  CA  PHE A  56      18.707  15.734  19.898  1.00 26.83           C  
ATOM    236  C   PHE A  56      18.900  14.354  20.548  1.00 26.69           C  
ATOM    237  O   PHE A  56      18.508  14.167  21.710  1.00 27.53           O  
ATOM    238  CB  PHE A  56      17.378  15.783  19.118  1.00 26.08           C  
ATOM    239  CG  PHE A  56      16.229  15.228  19.894  1.00 27.31           C  
ATOM    240  CD1 PHE A  56      15.573  16.002  20.836  1.00 30.83           C  
ATOM    241  CD2 PHE A  56      15.861  13.892  19.744  1.00 28.48           C  
ATOM    242  CE1 PHE A  56      14.516  15.470  21.600  1.00 29.77           C  
ATOM    243  CE2 PHE A  56      14.816  13.347  20.491  1.00 30.05           C  
ATOM    244  CZ  PHE A  56      14.136  14.150  21.422  1.00 31.05           C  
ATOM    245  N   CYS A  57      19.452  13.402  19.787  1.00 25.10           N  
ATOM    246  CA  CYS A  57      19.694  12.038  20.287  1.00 25.42           C  
ATOM    247  C   CYS A  57      20.534  12.070  21.560  1.00 25.83           C  
ATOM    248  O   CYS A  57      20.177  11.429  22.561  1.00 27.43           O  
ATOM    249  CB  CYS A  57      20.375  11.166  19.233  1.00 26.05           C  
ATOM    250  SG  CYS A  57      19.323  10.847  17.820  1.00 30.98           S  
ATOM    251  N   ARG A  58      21.635  12.829  21.524  1.00 26.82           N  
ATOM    252  CA  ARG A  58      22.496  13.000  22.689  1.00 26.95           C  
ATOM    253  C   ARG A  58      21.804  13.741  23.828  1.00 26.49           C  
ATOM    254  O   ARG A  58      21.953  13.348  24.978  1.00 27.62           O  
ATOM    255  CB  ARG A  58      23.829  13.659  22.335  1.00 26.82           C  
ATOM    256  CG  ARG A  58      24.740  12.740  21.522  1.00 29.47           C  
ATOM    257  CD  ARG A  58      26.119  13.335  21.307  1.00 29.36           C  
ATOM    258  NE  ARG A  58      26.087  14.509  20.446  1.00 28.90           N  
ATOM    259  CZ  ARG A  58      25.891  14.491  19.125  1.00 33.95           C  
ATOM    260  NH1 ARG A  58      25.720  13.354  18.464  1.00 33.73           N  
ATOM    261  NH2 ARG A  58      25.874  15.639  18.454  1.00 36.01           N  
ATOM    262  N   TRP A  59      21.047  14.790  23.512  1.00 28.40           N  
ATOM    263  CA  TRP A  59      20.272  15.514  24.538  1.00 27.36           C  
ATOM    264  C   TRP A  59      19.314  14.558  25.254  1.00 27.24           C  
ATOM    265  O   TRP A  59      19.248  14.545  26.482  1.00 27.99           O  
ATOM    266  CB  TRP A  59      19.509  16.714  23.933  1.00 27.78           C  
ATOM    267  CG  TRP A  59      18.616  17.414  24.925  1.00 28.02           C  
ATOM    268  CD1 TRP A  59      18.962  18.449  25.728  1.00 30.41           C  
ATOM    269  CD2 TRP A  59      17.249  17.090  25.246  1.00 27.79           C  
ATOM    270  NE1 TRP A  59      17.899  18.802  26.519  1.00 29.84           N  
ATOM    271  CE2 TRP A  59      16.843  17.973  26.266  1.00 31.68           C  
ATOM    272  CE3 TRP A  59      16.346  16.131  24.780  1.00 30.27           C  
ATOM    273  CZ2 TRP A  59      15.546  17.955  26.810  1.00 31.56           C  
ATOM    274  CZ3 TRP A  59      15.054  16.100  25.317  1.00 29.15           C  
ATOM    275  CH2 TRP A  59      14.675  17.003  26.336  1.00 31.38           C  
ATOM    276  N   ALA A  60      18.584  13.759  24.481  1.00 25.93           N  
ATOM    277  CA  ALA A  60      17.606  12.824  25.034  1.00 26.01           C  
ATOM    278  C   ALA A  60      18.269  11.787  25.931  1.00 26.79           C  
ATOM    279  O   ALA A  60      17.755  11.479  27.019  1.00 28.27           O  
ATOM    280  CB  ALA A  60      16.820  12.145  23.923  1.00 26.44           C  
ATOM    281  N   HIS A  61      19.396  11.241  25.474  1.00 27.55           N  
ATOM    282  CA  HIS A  61      20.172  10.294  26.276  1.00 28.82           C  
ATOM    283  C   HIS A  61      20.657  10.958  27.577  1.00 29.55           C  
ATOM    284  O   HIS A  61      20.481  10.403  28.664  1.00 27.81           O  
ATOM    285  CB  HIS A  61      21.369   9.740  25.497  1.00 28.77           C  
ATOM    286  CG  HIS A  61      22.183   8.759  26.284  1.00 32.61           C  
ATOM    287  ND1 HIS A  61      21.836   7.430  26.399  1.00 34.75           N  
ATOM    288  CD2 HIS A  61      23.290   8.926  27.047  1.00 37.84           C  
ATOM    289  CE1 HIS A  61      22.718   6.813  27.167  1.00 37.17           C  
ATOM    290  NE2 HIS A  61      23.614   7.696  27.570  1.00 34.88           N  
ATOM    291  N   GLU A  62      21.228  12.153  27.464  1.00 28.43           N  
ATOM    292  CA  GLU A  62      21.667  12.911  28.655  1.00 31.71           C  
ATOM    293  C   GLU A  62      20.539  13.119  29.675  1.00 29.52           C  
ATOM    294  O   GLU A  62      20.794  13.101  30.889  1.00 31.86           O  
ATOM    295  CB  GLU A  62      22.234  14.271  28.264  1.00 32.22           C  
ATOM    296  CG  GLU A  62      23.558  14.228  27.556  1.00 38.87           C  
ATOM    297  CD  GLU A  62      23.877  15.509  26.772  1.00 41.59           C  
ATOM    298  OE1 GLU A  62      23.262  16.577  27.033  1.00 55.36           O  
ATOM    299  OE2 GLU A  62      24.763  15.444  25.886  1.00 59.37           O  
ATOM    300  N   HIS A  63      19.306  13.275  29.188  1.00 29.17           N  
ATOM    301  CA  HIS A  63      18.124  13.487  30.030  1.00 29.81           C  
ATOM    302  C   HIS A  63      17.355  12.211  30.406  1.00 30.84           C  
ATOM    303  O   HIS A  63      16.186  12.267  30.810  1.00 31.83           O  
ATOM    304  CB  HIS A  63      17.252  14.593  29.418  1.00 31.11           C  
ATOM    305  CG  HIS A  63      17.898  15.937  29.498  1.00 30.65           C  
ATOM    306  ND1 HIS A  63      18.920  16.327  28.658  1.00 33.51           N  
ATOM    307  CD2 HIS A  63      17.712  16.959  30.365  1.00 40.29           C  
ATOM    308  CE1 HIS A  63      19.322  17.540  28.995  1.00 39.22           C  
ATOM    309  NE2 HIS A  63      18.598  17.951  30.020  1.00 33.94           N  
ATOM    310  N   GLY A  64      18.018  11.061  30.278  1.00 30.26           N  
ATOM    311  CA  GLY A  64      17.523   9.803  30.786  1.00 30.78           C  
ATOM    312  C   GLY A  64      16.720   8.898  29.897  1.00 28.67           C  
ATOM    313  O   GLY A  64      16.124   7.951  30.413  1.00 27.76           O  
ATOM    314  N   ALA A  65      16.709   9.143  28.585  1.00 29.49           N  
ATOM    315  CA  ALA A  65      15.999   8.266  27.650  1.00 27.23           C  
ATOM    316  C   ALA A  65      16.557   6.844  27.724  1.00 28.72           C  
ATOM    317  O   ALA A  65      17.783   6.668  27.739  1.00 30.80           O  
ATOM    318  CB  ALA A  65      16.100   8.799  26.206  1.00 27.38           C  
ATOM    319  N   SER A  66      15.676   5.845  27.816  1.00 28.26           N  
ATOM    320  CA  SER A  66      16.111   4.440  27.894  1.00 29.66           C  
ATOM    321  C   SER A  66      16.743   3.969  26.596  1.00 29.08           C  
ATOM    322  O   SER A  66      17.698   3.197  26.620  1.00 31.04           O  
ATOM    323  CB  SER A  66      14.972   3.484  28.305  1.00 29.69           C  
ATOM    324  OG  SER A  66      13.943   3.429  27.336  1.00 39.06           O  
ATOM    325  N   TYR A  67      16.213   4.443  25.471  1.00 28.98           N  
ATOM    326  CA  TYR A  67      16.684   4.048  24.157  1.00 28.30           C  
ATOM    327  C   TYR A  67      16.355   5.126  23.133  1.00 27.24           C  
ATOM    328  O   TYR A  67      15.253   5.658  23.146  1.00 26.86           O  
ATOM    329  CB  TYR A  67      16.023   2.727  23.756  1.00 27.59           C  
ATOM    330  CG  TYR A  67      16.278   2.301  22.322  1.00 30.21           C  
ATOM    331  CD1 TYR A  67      17.577   2.033  21.886  1.00 36.40           C  
ATOM    332  CD2 TYR A  67      15.224   2.160  21.402  1.00 33.04           C  
ATOM    333  CE1 TYR A  67      17.835   1.639  20.558  1.00 34.62           C  
ATOM    334  CE2 TYR A  67      15.472   1.757  20.061  1.00 33.02           C  
ATOM    335  CZ  TYR A  67      16.782   1.503  19.660  1.00 33.90           C  
ATOM    336  OH  TYR A  67      17.061   1.109  18.371  1.00 37.77           O  
ATOM    337  N   VAL A  68      17.328   5.442  22.274  1.00 27.15           N  
ATOM    338  CA  VAL A  68      17.157   6.429  21.199  1.00 28.22           C  
ATOM    339  C   VAL A  68      17.601   5.809  19.871  1.00 27.69           C  
ATOM    340  O   VAL A  68      18.704   5.275  19.779  1.00 28.46           O  
ATOM    341  CB  VAL A  68      17.949   7.743  21.442  1.00 29.00           C  
ATOM    342  CG1 VAL A  68      17.621   8.762  20.337  1.00 32.02           C  
ATOM    343  CG2 VAL A  68      17.591   8.337  22.801  1.00 28.09           C  
ATOM    344  N   LEU A  69      16.715   5.848  18.870  1.00 27.91           N  
ATOM    345  CA  LEU A  69      17.008   5.413  17.499  1.00 27.15           C  
ATOM    346  C   LEU A  69      17.041   6.695  16.665  1.00 27.18           C  
ATOM    347  O   LEU A  69      16.015   7.376  16.539  1.00 27.62           O  
ATOM    348  CB  LEU A  69      15.944   4.461  16.968  1.00 27.54           C  
ATOM    349  CG  LEU A  69      16.075   4.046  15.485  1.00 29.59           C  
ATOM    350  CD1 LEU A  69      17.417   3.327  15.194  1.00 27.65           C  
ATOM    351  CD2 LEU A  69      14.891   3.181  15.086  1.00 30.07           C  
ATOM    352  N   GLY A  70      18.210   7.024  16.134  1.00 26.30           N  
ATOM    353  CA  GLY A  70      18.395   8.191  15.274  1.00 26.21           C  
ATOM    354  C   GLY A  70      18.443   7.730  13.835  1.00 26.02           C  
ATOM    355  O   GLY A  70      19.264   6.883  13.491  1.00 27.01           O  
ATOM    356  N   LEU A  71      17.566   8.287  12.998  1.00 26.20           N  
ATOM    357  CA  LEU A  71      17.483   7.937  11.583  1.00 26.72           C  
ATOM    358  C   LEU A  71      17.801   9.122  10.678  1.00 27.98           C  
ATOM    359  O   LEU A  71      17.282  10.211  10.885  1.00 28.51           O  
ATOM    360  CB  LEU A  71      16.089   7.436  11.260  1.00 27.40           C  
ATOM    361  CG  LEU A  71      15.581   6.242  12.063  1.00 26.59           C  
ATOM    362  CD1 LEU A  71      14.175   5.834  11.543  1.00 28.42           C  
ATOM    363  CD2 LEU A  71      16.543   5.072  12.004  1.00 27.01           C  
ATOM    364  N   ASP A  72      18.621   8.879   9.651  1.00 29.36           N  
ATOM    365  CA  ASP A  72      18.980   9.905   8.672  1.00 29.32           C  
ATOM    366  C   ASP A  72      19.364   9.198   7.359  1.00 29.87           C  
ATOM    367  O   ASP A  72      19.714   8.028   7.366  1.00 31.22           O  
ATOM    368  CB  ASP A  72      20.131  10.775   9.208  1.00 32.51           C  
ATOM    369  CG  ASP A  72      20.204  12.134   8.539  1.00 34.89           C  
ATOM    370  OD1 ASP A  72      19.616  13.098   9.090  1.00 33.41           O  
ATOM    371  OD2 ASP A  72      20.812  12.228   7.449  1.00 45.36           O  
ATOM    372  N   LEU A  73      19.257   9.913   6.250  1.00 32.65           N  
ATOM    373  CA  LEU A  73      19.602   9.358   4.934  1.00 35.22           C  
ATOM    374  C   LEU A  73      21.114   9.306   4.712  1.00 34.73           C  
ATOM    375  O   LEU A  73      21.580   8.424   4.013  1.00 36.48           O  
ATOM    376  CB  LEU A  73      18.935  10.175   3.821  1.00 34.65           C  
ATOM    377  CG  LEU A  73      18.987   9.613   2.386  1.00 34.33           C  
ATOM    378  CD1 LEU A  73      18.301   8.249   2.250  1.00 40.70           C  
ATOM    379  CD2 LEU A  73      18.326  10.615   1.455  1.00 39.81           C  
ATOM    380  N   SER A  74      21.861  10.223   5.334  1.00 34.87           N  
ATOM    381  CA  SER A  74      23.317  10.343   5.145  1.00 36.27           C  
ATOM    382  C   SER A  74      24.148   9.419   6.032  1.00 36.31           C  
ATOM    383  O   SER A  74      24.238   9.641   7.244  1.00 34.81           O  
ATOM    384  CB  SER A  74      23.755  11.799   5.380  1.00 37.06           C  
ATOM    385  OG  SER A  74      25.156  11.920   5.260  1.00 40.34           O  
ATOM    386  N   GLU A  75      24.777   8.410   5.429  1.00 38.21           N  
ATOM    387  CA  GLU A  75      25.650   7.484   6.172  1.00 39.31           C  
ATOM    388  C   GLU A  75      26.836   8.217   6.807  1.00 40.60           C  
ATOM    389  O   GLU A  75      27.189   7.935   7.954  1.00 39.64           O  
ATOM    390  CB  GLU A  75      26.152   6.343   5.271  1.00 39.86           C  
ATOM    391  CG  GLU A  75      27.023   5.277   5.973  1.00 40.76           C  
ATOM    392  CD  GLU A  75      26.327   4.587   7.144  1.00 46.95           C  
ATOM    393  OE1 GLU A  75      25.089   4.455   7.109  1.00 42.49           O  
ATOM    394  OE2 GLU A  75      27.024   4.159   8.089  1.00 46.38           O  
ATOM    395  N   LYS A  76      27.434   9.145   6.056  1.00 42.98           N  
ATOM    396  CA  LYS A  76      28.556   9.959   6.552  1.00 43.96           C  
ATOM    397  C   LYS A  76      28.180  10.797   7.775  1.00 42.91           C  
ATOM    398  O   LYS A  76      28.981  10.903   8.707  1.00 43.88           O  
ATOM    399  CB  LYS A  76      29.137  10.853   5.447  1.00 44.82           C  
ATOM    400  CG  LYS A  76      29.904  10.065   4.396  1.00 48.66           C  
ATOM    401  CD  LYS A  76      30.463  10.961   3.301  1.00 48.08           C  
ATOM    402  CE  LYS A  76      31.279  10.154   2.296  1.00 52.68           C  
ATOM    403  NZ  LYS A  76      31.817  11.007   1.195  1.00 55.90           N  
HETATM  404  N   MSE A  77      26.958  11.342   7.779  1.00 41.63           N  
HETATM  405  CA  MSE A  77      26.499  12.143   8.906  0.50 39.83           C  
HETATM  407  C   MSE A  77      26.240  11.250  10.122  1.00 38.87           C  
HETATM  408  O   MSE A  77      26.552  11.635  11.256  1.00 38.51           O  
HETATM  409  CB  MSE A  77      25.278  12.990   8.548  0.50 39.28           C  
HETATM  411  CG  MSE A  77      24.869  13.915   9.663  0.50 39.62           C  
HETATM  413 SE   MSE A  77      26.312  15.054  10.312  0.38 37.17          SE  
HETATM  415  CE  MSE A  77      26.218  16.352   8.871  0.50 36.32           C  
ATOM    417  N   LEU A  78      25.711  10.046   9.884  1.00 36.09           N  
ATOM    418  CA  LEU A  78      25.492   9.055  10.950  1.00 36.65           C  
ATOM    419  C   LEU A  78      26.826   8.580  11.539  1.00 35.47           C  
ATOM    420  O   LEU A  78      26.901   8.307  12.738  1.00 34.04           O  
ATOM    421  CB  LEU A  78      24.676   7.855  10.447  1.00 35.78           C  
ATOM    422  CG  LEU A  78      23.225   8.117  10.027  1.00 35.85           C  
ATOM    423  CD1 LEU A  78      22.599   6.852   9.488  1.00 33.85           C  
ATOM    424  CD2 LEU A  78      22.390   8.672  11.165  1.00 34.55           C  
ATOM    425  N   ALA A  79      27.869   8.486  10.706  1.00 36.31           N  
ATOM    426  CA  ALA A  79      29.216   8.107  11.168  1.00 36.39           C  
ATOM    427  C   ALA A  79      29.768   9.124  12.173  1.00 36.97           C  
ATOM    428  O   ALA A  79      30.356   8.725  13.192  1.00 36.91           O  
ATOM    429  CB  ALA A  79      30.195   7.925   9.976  1.00 35.72           C  
ATOM    430  N   ARG A  80      29.557  10.415  11.889  1.00 37.02           N  
ATOM    431  CA  ARG A  80      29.967  11.509  12.795  1.00 38.08           C  
ATOM    432  C   ARG A  80      29.145  11.474  14.092  1.00 37.04           C  
ATOM    433  O   ARG A  80      29.687  11.673  15.179  1.00 34.19           O  
ATOM    434  CB  ARG A  80      29.866  12.897  12.122  1.00 40.45           C  
ATOM    435  CG  ARG A  80      30.649  13.003  10.803  1.00 42.47           C  
ATOM    436  CD  ARG A  80      31.153  14.401  10.442  1.00 45.62           C  
ATOM    437  NE  ARG A  80      30.125  15.445  10.384  1.00 57.30           N  
ATOM    438  CZ  ARG A  80      29.820  16.331  11.346  1.00 61.50           C  
ATOM    439  NH1 ARG A  80      28.854  17.230  11.117  1.00 62.69           N  
ATOM    440  NH2 ARG A  80      30.450  16.357  12.530  1.00 66.20           N  
ATOM    441  N   ALA A  81      27.843  11.206  13.968  1.00 35.81           N  
ATOM    442  CA  ALA A  81      26.946  11.067  15.126  1.00 36.21           C  
ATOM    443  C   ALA A  81      27.401   9.943  16.062  1.00 35.08           C  
ATOM    444  O   ALA A  81      27.485  10.153  17.269  1.00 36.18           O  
ATOM    445  CB  ALA A  81      25.502  10.821  14.677  1.00 34.19           C  
ATOM    446  N   ARG A  82      27.706   8.769  15.502  1.00 36.22           N  
ATOM    447  CA  ARG A  82      28.196   7.624  16.309  1.00 37.75           C  
ATOM    448  C   ARG A  82      29.466   7.975  17.082  1.00 38.96           C  
ATOM    449  O   ARG A  82      29.535   7.750  18.299  1.00 40.24           O  
ATOM    450  CB  ARG A  82      28.465   6.390  15.445  1.00 37.83           C  
ATOM    451  CG  ARG A  82      27.218   5.734  14.916  1.00 37.44           C  
ATOM    452  CD  ARG A  82      27.546   4.476  14.142  1.00 36.67           C  
ATOM    453  NE  ARG A  82      26.406   4.038  13.335  1.00 35.11           N  
ATOM    454  CZ  ARG A  82      26.203   4.315  12.043  1.00 38.47           C  
ATOM    455  NH1 ARG A  82      27.080   4.989  11.292  1.00 41.07           N  
ATOM    456  NH2 ARG A  82      25.092   3.867  11.472  1.00 35.72           N  
ATOM    457  N   ALA A  83      30.437   8.548  16.363  1.00 39.46           N  
ATOM    458  CA  ALA A  83      31.727   8.999  16.929  1.00 40.51           C  
ATOM    459  C   ALA A  83      31.582   9.964  18.116  1.00 40.88           C  
ATOM    460  O   ALA A  83      32.393   9.915  19.052  1.00 40.67           O  
ATOM    461  CB  ALA A  83      32.589   9.642  15.846  1.00 39.11           C  
ATOM    462  N   ALA A  84      30.547  10.810  18.080  1.00 40.80           N  
ATOM    463  CA  ALA A  84      30.272  11.774  19.157  1.00 40.97           C  
ATOM    464  C   ALA A  84      29.794  11.158  20.488  1.00 42.15           C  
ATOM    465  O   ALA A  84      29.697  11.885  21.482  1.00 43.76           O  
ATOM    466  CB  ALA A  84      29.287  12.849  18.678  1.00 40.56           C  
ATOM    467  N   GLY A  85      29.452   9.859  20.499  1.00 42.48           N  
ATOM    468  CA  GLY A  85      29.058   9.133  21.723  1.00 42.34           C  
ATOM    469  C   GLY A  85      27.610   9.350  22.131  1.00 40.78           C  
ATOM    470  O   GLY A  85      26.896  10.119  21.487  1.00 42.84           O  
ATOM    471  N   PRO A  86      27.142   8.655  23.187  1.00 38.03           N  
ATOM    472  CA  PRO A  86      27.810   7.682  24.041  1.00 37.82           C  
ATOM    473  C   PRO A  86      27.861   6.288  23.407  1.00 36.12           C  
ATOM    474  O   PRO A  86      27.268   6.060  22.355  1.00 35.59           O  
ATOM    475  CB  PRO A  86      26.912   7.659  25.271  1.00 37.81           C  
ATOM    476  CG  PRO A  86      25.580   7.818  24.693  1.00 39.43           C  
ATOM    477  CD  PRO A  86      25.733   8.805  23.584  1.00 39.06           C  
ATOM    478  N   ASP A  87      28.525   5.368  24.091  1.00 36.22           N  
ATOM    479  CA  ASP A  87      28.699   3.994  23.605  1.00 35.48           C  
ATOM    480  C   ASP A  87      27.444   3.121  23.686  1.00 34.91           C  
ATOM    481  O   ASP A  87      27.325   2.191  22.891  1.00 34.53           O  
ATOM    482  CB  ASP A  87      29.902   3.333  24.298  1.00 37.66           C  
ATOM    483  CG  ASP A  87      31.229   4.048  23.978  1.00 42.92           C  
ATOM    484  OD1 ASP A  87      31.219   5.223  23.531  1.00 55.07           O  
ATOM    485  OD2 ASP A  87      32.291   3.433  24.168  1.00 54.03           O  
ATOM    486  N   THR A  88      26.530   3.401  24.629  1.00 31.59           N  
ATOM    487  CA  THR A  88      25.262   2.667  24.741  1.00 30.27           C  
ATOM    488  C   THR A  88      24.048   3.581  24.859  1.00 28.81           C  
ATOM    489  O   THR A  88      24.151   4.731  25.289  1.00 30.64           O  
ATOM    490  CB  THR A  88      25.210   1.667  25.935  1.00 30.38           C  
ATOM    491  OG1 THR A  88      25.156   2.382  27.176  1.00 29.95           O  
ATOM    492  CG2 THR A  88      26.406   0.730  25.915  1.00 31.99           C  
ATOM    493  N   GLY A  89      22.904   3.046  24.438  1.00 26.73           N  
ATOM    494  CA  GLY A  89      21.620   3.730  24.524  1.00 26.91           C  
ATOM    495  C   GLY A  89      21.149   4.464  23.290  1.00 27.43           C  
ATOM    496  O   GLY A  89      19.959   4.786  23.225  1.00 29.51           O  
ATOM    497  N   ILE A  90      22.059   4.753  22.340  1.00 28.15           N  
ATOM    498  CA  ILE A  90      21.717   5.415  21.083  1.00 28.51           C  
ATOM    499  C   ILE A  90      22.171   4.555  19.904  1.00 27.20           C  
ATOM    500  O   ILE A  90      23.353   4.225  19.800  1.00 30.26           O  
ATOM    501  CB  ILE A  90      22.365   6.814  20.920  1.00 27.73           C  
ATOM    502  CG1 ILE A  90      22.091   7.698  22.141  1.00 30.78           C  
ATOM    503  CG2 ILE A  90      21.833   7.468  19.628  1.00 30.07           C  
ATOM    504  CD1 ILE A  90      22.679   9.103  22.017  1.00 30.35           C  
ATOM    505  N   THR A  91      21.223   4.200  19.038  1.00 28.47           N  
ATOM    506  CA  THR A  91      21.475   3.455  17.803  1.00 27.34           C  
ATOM    507  C   THR A  91      21.203   4.396  16.643  1.00 26.95           C  
ATOM    508  O   THR A  91      20.185   5.092  16.654  1.00 27.58           O  
ATOM    509  CB  THR A  91      20.554   2.236  17.686  1.00 28.28           C  
ATOM    510  OG1 THR A  91      20.856   1.324  18.747  1.00 31.73           O  
ATOM    511  CG2 THR A  91      20.719   1.517  16.325  1.00 28.68           C  
ATOM    512  N   TYR A  92      22.115   4.424  15.662  1.00 27.04           N  
ATOM    513  CA  TYR A  92      21.942   5.226  14.442  1.00 26.70           C  
ATOM    514  C   TYR A  92      21.796   4.278  13.272  1.00 27.31           C  
ATOM    515  O   TYR A  92      22.555   3.323  13.162  1.00 26.17           O  
ATOM    516  CB  TYR A  92      23.116   6.159  14.207  1.00 25.99           C  
ATOM    517  CG  TYR A  92      23.196   7.273  15.220  1.00 25.37           C  
ATOM    518  CD1 TYR A  92      22.373   8.400  15.113  1.00 27.11           C  
ATOM    519  CD2 TYR A  92      24.070   7.198  16.301  1.00 26.89           C  
ATOM    520  CE1 TYR A  92      22.442   9.438  16.062  1.00 25.68           C  
ATOM    521  CE2 TYR A  92      24.139   8.224  17.253  1.00 26.71           C  
ATOM    522  CZ  TYR A  92      23.325   9.343  17.121  1.00 28.12           C  
ATOM    523  OH  TYR A  92      23.401  10.364  18.051  1.00 30.08           O  
ATOM    524  N   GLU A  93      20.790   4.517  12.434  1.00 27.56           N  
ATOM    525  CA  GLU A  93      20.560   3.685  11.245  1.00 30.05           C  
ATOM    526  C   GLU A  93      20.199   4.557  10.073  1.00 30.97           C  
ATOM    527  O   GLU A  93      19.516   5.571  10.232  1.00 29.32           O  
ATOM    528  CB  GLU A  93      19.436   2.679  11.474  1.00 31.58           C  
ATOM    529  CG  GLU A  93      19.715   1.625  12.539  1.00 35.20           C  
ATOM    530  CD  GLU A  93      18.595   0.589  12.670  1.00 35.84           C  
ATOM    531  OE1 GLU A  93      17.536   0.745  12.031  1.00 45.11           O  
ATOM    532  OE2 GLU A  93      18.771  -0.388  13.434  1.00 45.78           O  
ATOM    533  N   ARG A  94      20.647   4.155   8.887  1.00 33.17           N  
ATOM    534  CA  ARG A  94      20.348   4.893   7.667  1.00 35.96           C  
ATOM    535  C   ARG A  94      18.892   4.592   7.288  1.00 34.24           C  
ATOM    536  O   ARG A  94      18.449   3.444   7.392  1.00 36.90           O  
ATOM    537  CB  ARG A  94      21.314   4.517   6.540  1.00 36.51           C  
ATOM    538  CG  ARG A  94      21.257   5.470   5.365  1.00 41.31           C  
ATOM    539  CD  ARG A  94      22.097   4.985   4.205  1.00 43.05           C  
ATOM    540  NE  ARG A  94      21.767   5.690   2.966  1.00 54.63           N  
ATOM    541  CZ  ARG A  94      20.680   5.473   2.210  1.00 62.47           C  
ATOM    542  NH1 ARG A  94      19.736   4.582   2.559  1.00 66.72           N  
ATOM    543  NH2 ARG A  94      20.514   6.182   1.088  1.00 64.12           N  
ATOM    544  N   ALA A  95      18.141   5.631   6.926  1.00 33.49           N  
ATOM    545  CA  ALA A  95      16.741   5.481   6.526  1.00 34.34           C  
ATOM    546  C   ALA A  95      16.295   6.597   5.603  1.00 32.76           C  
ATOM    547  O   ALA A  95      16.796   7.715   5.690  1.00 32.33           O  
ATOM    548  CB  ALA A  95      15.833   5.427   7.738  1.00 35.97           C  
ATOM    549  N   ASP A  96      15.353   6.262   4.720  1.00 33.50           N  
ATOM    550  CA  ASP A  96      14.742   7.202   3.784  1.00 33.11           C  
ATOM    551  C   ASP A  96      13.368   7.487   4.361  1.00 30.98           C  
ATOM    552  O   ASP A  96      12.519   6.593   4.395  1.00 33.16           O  
ATOM    553  CB  ASP A  96      14.609   6.557   2.394  1.00 32.63           C  
ATOM    554  CG  ASP A  96      14.010   7.501   1.339  1.00 38.28           C  
ATOM    555  OD1 ASP A  96      13.559   8.631   1.652  1.00 42.44           O  
ATOM    556  OD2 ASP A  96      13.989   7.088   0.159  1.00 47.60           O  
ATOM    557  N   LEU A  97      13.141   8.718   4.821  1.00 30.93           N  
ATOM    558  CA  LEU A  97      11.839   9.080   5.419  1.00 31.35           C  
ATOM    559  C   LEU A  97      10.642   8.973   4.448  1.00 32.51           C  
ATOM    560  O   LEU A  97       9.500   8.849   4.908  1.00 34.04           O  
ATOM    561  CB  LEU A  97      11.879  10.457   6.071  1.00 29.79           C  
ATOM    562  CG  LEU A  97      12.860  10.678   7.230  1.00 30.90           C  
ATOM    563  CD1 LEU A  97      12.668  12.104   7.769  1.00 30.45           C  
ATOM    564  CD2 LEU A  97      12.729   9.657   8.363  1.00 34.72           C  
ATOM    565  N   ASP A  98      10.901   9.018   3.136  1.00 34.54           N  
ATOM    566  CA  ASP A  98       9.862   8.781   2.115  1.00 35.84           C  
ATOM    567  C   ASP A  98       9.449   7.319   2.011  1.00 36.58           C  
ATOM    568  O   ASP A  98       8.397   7.042   1.452  1.00 37.76           O  
ATOM    569  CB  ASP A  98      10.325   9.237   0.723  1.00 36.79           C  
ATOM    570  CG  ASP A  98      10.469  10.727   0.618  1.00 37.44           C  
ATOM    571  OD1 ASP A  98       9.520  11.444   0.989  1.00 39.39           O  
ATOM    572  OD2 ASP A  98      11.507  11.198   0.109  1.00 47.62           O  
ATOM    573  N   LYS A  99      10.279   6.398   2.506  1.00 35.90           N  
ATOM    574  CA  LYS A  99      10.015   4.951   2.479  1.00 38.63           C  
ATOM    575  C   LYS A  99      10.218   4.379   3.889  1.00 35.99           C  
ATOM    576  O   LYS A  99      10.752   3.286   4.061  1.00 37.69           O  
ATOM    577  CB  LYS A  99      10.985   4.276   1.499  1.00 38.71           C  
ATOM    578  CG  LYS A  99      11.001   4.848   0.085  1.00 44.44           C  
ATOM    579  CD  LYS A  99      12.036   4.129  -0.764  1.00 41.98           C  
ATOM    580  N   LEU A 100       9.753   5.119   4.894  1.00 34.51           N  
ATOM    581  CA  LEU A 100       9.983   4.779   6.287  1.00 34.43           C  
ATOM    582  C   LEU A 100       9.210   3.558   6.774  1.00 34.62           C  
ATOM    583  O   LEU A 100       8.000   3.442   6.538  1.00 33.25           O  
ATOM    584  CB  LEU A 100       9.609   5.967   7.187  1.00 35.34           C  
ATOM    585  CG  LEU A 100       9.812   5.865   8.712  1.00 35.05           C  
ATOM    586  CD1 LEU A 100      11.296   5.800   9.072  1.00 37.89           C  
ATOM    587  CD2 LEU A 100       9.116   7.016   9.456  1.00 33.24           C  
ATOM    588  N   HIS A 101       9.944   2.675   7.454  1.00 33.53           N  
ATOM    589  CA  HIS A 101       9.378   1.514   8.110  0.50 34.50           C  
ATOM    591  C   HIS A 101       9.849   1.574   9.562  1.00 34.08           C  
ATOM    592  O   HIS A 101      11.006   1.890   9.830  1.00 34.44           O  
ATOM    593  CB  HIS A 101       9.791   0.230   7.392  0.50 35.60           C  
ATOM    595  CG  HIS A 101       9.228   0.120   6.006  0.50 35.91           C  
ATOM    597  ND1 HIS A 101       9.900   0.575   4.890  0.50 40.58           N  
ATOM    599  CD2 HIS A 101       8.043  -0.363   5.559  0.50 36.59           C  
ATOM    601  CE1 HIS A 101       9.161   0.364   3.815  0.50 36.62           C  
ATOM    603  NE2 HIS A 101       8.031  -0.203   4.193  0.50 38.45           N  
ATOM    605  N   LEU A 102       8.927   1.327  10.493  1.00 33.03           N  
ATOM    606  CA  LEU A 102       9.233   1.328  11.917  1.00 33.25           C  
ATOM    607  C   LEU A 102       8.542   0.134  12.555  1.00 33.95           C  
ATOM    608  O   LEU A 102       7.414  -0.201  12.149  1.00 34.03           O  
ATOM    609  CB  LEU A 102       8.777   2.627  12.602  1.00 32.37           C  
ATOM    610  CG  LEU A 102       9.527   3.941  12.329  1.00 35.24           C  
ATOM    611  CD1 LEU A 102       8.831   5.103  13.059  1.00 33.58           C  
ATOM    612  CD2 LEU A 102      10.985   3.838  12.755  1.00 34.22           C  
ATOM    613  N   PRO A 103       9.198  -0.511  13.548  1.00 33.88           N  
ATOM    614  CA  PRO A 103       8.555  -1.605  14.246  1.00 33.90           C  
ATOM    615  C   PRO A 103       7.375  -1.096  15.073  1.00 33.37           C  
ATOM    616  O   PRO A 103       7.430   0.001  15.634  1.00 32.36           O  
ATOM    617  CB  PRO A 103       9.669  -2.156  15.146  1.00 34.76           C  
ATOM    618  CG  PRO A 103      10.569  -1.042  15.345  1.00 35.13           C  
ATOM    619  CD  PRO A 103      10.558  -0.274  14.078  1.00 35.38           C  
ATOM    620  N   GLN A 104       6.318  -1.893  15.120  1.00 34.11           N  
ATOM    621  CA  GLN A 104       5.075  -1.529  15.793  1.00 34.22           C  
ATOM    622  C   GLN A 104       5.244  -1.473  17.309  1.00 32.58           C  
ATOM    623  O   GLN A 104       6.025  -2.255  17.858  1.00 31.90           O  
ATOM    624  CB  GLN A 104       4.002  -2.574  15.455  1.00 36.19           C  
ATOM    625  CG  GLN A 104       2.593  -2.242  15.908  1.00 40.84           C  
ATOM    626  CD  GLN A 104       1.592  -3.369  15.630  1.00 41.34           C  
ATOM    627  OE1 GLN A 104       1.916  -4.376  14.995  1.00 54.52           O  
ATOM    628  NE2 GLN A 104       0.366  -3.190  16.113  1.00 52.76           N  
ATOM    629  N   ASP A 105       4.553  -0.521  17.955  1.00 31.75           N  
ATOM    630  CA  ASP A 105       4.474  -0.435  19.422  1.00 32.28           C  
ATOM    631  C   ASP A 105       5.867  -0.448  20.093  1.00 30.99           C  
ATOM    632  O   ASP A 105       6.076  -1.105  21.121  1.00 34.42           O  
ATOM    633  CB  ASP A 105       3.592  -1.632  19.869  1.00 34.51           C  
ATOM    634  CG  ASP A 105       3.197  -1.604  21.333  1.00 39.47           C  
ATOM    635  OD1 ASP A 105       3.102  -0.529  21.928  1.00 40.25           O  
ATOM    636  OD2 ASP A 105       2.959  -2.698  21.891  1.00 40.88           O  
ATOM    637  N   SER A 106       6.813   0.265  19.480  1.00 29.95           N  
ATOM    638  CA  SER A 106       8.228   0.269  19.900  1.00 31.48           C  
ATOM    639  C   SER A 106       8.798   1.565  20.456  1.00 30.38           C  
ATOM    640  O   SER A 106       9.957   1.575  20.935  1.00 30.67           O  
ATOM    641  CB  SER A 106       9.074  -0.198  18.721  1.00 32.21           C  
ATOM    642  OG  SER A 106       8.798  -1.563  18.471  1.00 36.68           O  
ATOM    643  N   PHE A 107       8.020   2.649  20.401  1.00 29.86           N  
ATOM    644  CA  PHE A 107       8.478   3.956  20.883  1.00 27.69           C  
ATOM    645  C   PHE A 107       7.427   4.677  21.686  1.00 28.31           C  
ATOM    646  O   PHE A 107       6.242   4.506  21.464  1.00 28.84           O  
ATOM    647  CB  PHE A 107       8.948   4.822  19.704  1.00 29.33           C  
ATOM    648  CG  PHE A 107      10.057   4.202  18.946  1.00 28.20           C  
ATOM    649  CD1 PHE A 107      11.363   4.319  19.403  1.00 29.57           C  
ATOM    650  CD2 PHE A 107       9.801   3.433  17.812  1.00 31.86           C  
ATOM    651  CE1 PHE A 107      12.404   3.706  18.723  1.00 26.73           C  
ATOM    652  CE2 PHE A 107      10.838   2.833  17.124  1.00 31.20           C  
ATOM    653  CZ  PHE A 107      12.147   2.966  17.587  1.00 28.83           C  
ATOM    654  N   ASP A 108       7.881   5.471  22.643  1.00 27.52           N  
ATOM    655  CA  ASP A 108       7.015   6.314  23.459  1.00 27.50           C  
ATOM    656  C   ASP A 108       6.958   7.729  22.892  1.00 26.84           C  
ATOM    657  O   ASP A 108       6.012   8.465  23.172  1.00 28.67           O  
ATOM    658  CB  ASP A 108       7.553   6.376  24.884  1.00 25.13           C  
ATOM    659  CG  ASP A 108       7.666   5.021  25.500  1.00 31.21           C  
ATOM    660  OD1 ASP A 108       6.607   4.380  25.656  1.00 30.66           O  
ATOM    661  OD2 ASP A 108       8.802   4.593  25.798  1.00 30.05           O  
ATOM    662  N   LEU A 109       8.004   8.128  22.150  1.00 27.03           N  
ATOM    663  CA  LEU A 109       8.107   9.458  21.572  1.00 26.94           C  
ATOM    664  C   LEU A 109       8.771   9.398  20.217  1.00 26.98           C  
ATOM    665  O   LEU A 109       9.788   8.739  20.071  1.00 27.07           O  
ATOM    666  CB  LEU A 109       8.969  10.358  22.488  1.00 26.57           C  
ATOM    667  CG  LEU A 109       9.376  11.767  22.014  1.00 29.36           C  
ATOM    668  CD1 LEU A 109       8.138  12.627  21.743  1.00 29.40           C  
ATOM    669  CD2 LEU A 109      10.333  12.419  22.995  1.00 28.65           C  
ATOM    670  N   ALA A 110       8.178  10.082  19.244  1.00 26.03           N  
ATOM    671  CA  ALA A 110       8.786  10.315  17.949  1.00 26.22           C  
ATOM    672  C   ALA A 110       9.067  11.821  17.867  1.00 27.01           C  
ATOM    673  O   ALA A 110       8.201  12.643  18.178  1.00 26.62           O  
ATOM    674  CB  ALA A 110       7.894   9.848  16.810  1.00 27.10           C  
ATOM    675  N   TYR A 111      10.298  12.166  17.524  1.00 26.28           N  
ATOM    676  CA  TYR A 111      10.753  13.547  17.376  1.00 27.04           C  
ATOM    677  C   TYR A 111      11.294  13.780  15.985  1.00 26.87           C  
ATOM    678  O   TYR A 111      11.916  12.904  15.421  1.00 26.47           O  
ATOM    679  CB  TYR A 111      11.854  13.820  18.382  1.00 26.78           C  
ATOM    680  CG  TYR A 111      12.537  15.176  18.281  1.00 26.34           C  
ATOM    681  CD1 TYR A 111      12.016  16.292  18.958  1.00 27.86           C  
ATOM    682  CD2 TYR A 111      13.691  15.362  17.497  1.00 26.45           C  
ATOM    683  CE1 TYR A 111      12.655  17.550  18.880  1.00 29.27           C  
ATOM    684  CE2 TYR A 111      14.334  16.615  17.414  1.00 26.74           C  
ATOM    685  CZ  TYR A 111      13.814  17.696  18.109  1.00 28.65           C  
ATOM    686  OH  TYR A 111      14.488  18.916  18.016  1.00 29.37           O  
ATOM    687  N   SER A 112      11.074  14.977  15.447  1.00 27.15           N  
ATOM    688  CA  SER A 112      11.660  15.352  14.169  1.00 25.97           C  
ATOM    689  C   SER A 112      11.844  16.852  14.039  1.00 27.56           C  
ATOM    690  O   SER A 112      10.884  17.601  14.153  1.00 27.87           O  
ATOM    691  CB  SER A 112      10.799  14.851  13.026  1.00 25.90           C  
ATOM    692  OG  SER A 112      11.432  15.116  11.778  1.00 28.06           O  
ATOM    693  N   SER A 113      13.079  17.280  13.807  1.00 25.77           N  
ATOM    694  CA  SER A 113      13.399  18.682  13.588  1.00 26.25           C  
ATOM    695  C   SER A 113      13.651  18.977  12.112  1.00 25.89           C  
ATOM    696  O   SER A 113      14.625  18.486  11.528  1.00 26.16           O  
ATOM    697  CB  SER A 113      14.631  19.081  14.395  1.00 28.03           C  
ATOM    698  OG  SER A 113      15.062  20.391  14.042  1.00 29.09           O  
ATOM    699  N   LEU A 114      12.747  19.755  11.525  1.00 26.33           N  
ATOM    700  CA  LEU A 114      12.939  20.321  10.187  1.00 27.08           C  
ATOM    701  C   LEU A 114      13.276  19.314   9.097  1.00 29.35           C  
ATOM    702  O   LEU A 114      14.190  19.518   8.286  1.00 29.65           O  
ATOM    703  CB  LEU A 114      13.992  21.433  10.288  1.00 27.76           C  
ATOM    704  CG  LEU A 114      13.715  22.540  11.311  1.00 29.13           C  
ATOM    705  CD1 LEU A 114      14.855  23.577  11.304  1.00 30.00           C  
ATOM    706  CD2 LEU A 114      12.357  23.191  11.070  1.00 30.54           C  
ATOM    707  N   ALA A 115      12.530  18.220   9.100  1.00 27.58           N  
ATOM    708  CA  ALA A 115      12.677  17.140   8.114  1.00 27.71           C  
ATOM    709  C   ALA A 115      11.410  16.855   7.312  1.00 26.22           C  
ATOM    710  O   ALA A 115      11.495  16.526   6.145  1.00 28.96           O  
ATOM    711  CB  ALA A 115      13.119  15.839   8.814  1.00 28.95           C  
ATOM    712  N   LEU A 116      10.239  16.950   7.949  1.00 27.78           N  
ATOM    713  CA  LEU A 116       9.001  16.529   7.328  1.00 28.27           C  
ATOM    714  C   LEU A 116       8.522  17.386   6.185  1.00 26.66           C  
ATOM    715  O   LEU A 116       7.809  16.875   5.329  1.00 26.64           O  
ATOM    716  CB  LEU A 116       7.893  16.306   8.349  1.00 28.78           C  
ATOM    717  CG  LEU A 116       8.148  15.259   9.446  1.00 35.18           C  
ATOM    718  CD1 LEU A 116       6.768  14.916  10.038  1.00 39.55           C  
ATOM    719  CD2 LEU A 116       8.863  14.015   9.016  1.00 36.71           C  
ATOM    720  N   HIS A 117       8.988  18.639   6.105  1.00 27.43           N  
ATOM    721  CA  HIS A 117       8.678  19.478   4.940  1.00 28.10           C  
ATOM    722  C   HIS A 117       9.326  18.988   3.639  1.00 27.92           C  
ATOM    723  O   HIS A 117       8.983  19.485   2.577  1.00 30.18           O  
ATOM    724  CB  HIS A 117       8.894  20.971   5.162  1.00 28.20           C  
ATOM    725  CG  HIS A 117      10.243  21.327   5.676  1.00 31.19           C  
ATOM    726  ND1 HIS A 117      10.489  21.535   7.008  1.00 34.83           N  
ATOM    727  CD2 HIS A 117      11.424  21.501   5.049  1.00 41.95           C  
ATOM    728  CE1 HIS A 117      11.759  21.848   7.183  1.00 31.48           C  
ATOM    729  NE2 HIS A 117      12.356  21.811   6.013  1.00 36.90           N  
ATOM    730  N   TYR A 118      10.267  18.038   3.725  1.00 27.32           N  
ATOM    731  CA  TYR A 118      10.870  17.409   2.537  1.00 27.25           C  
ATOM    732  C   TYR A 118      10.227  16.074   2.122  1.00 26.27           C  
ATOM    733  O   TYR A 118      10.621  15.489   1.117  1.00 28.29           O  
ATOM    734  CB  TYR A 118      12.376  17.218   2.751  1.00 28.66           C  
ATOM    735  CG  TYR A 118      13.095  18.512   3.093  1.00 31.44           C  
ATOM    736  CD1 TYR A 118      13.013  19.628   2.244  1.00 28.67           C  
ATOM    737  CD2 TYR A 118      13.857  18.631   4.260  1.00 32.95           C  
ATOM    738  CE1 TYR A 118      13.670  20.838   2.547  1.00 34.48           C  
ATOM    739  CE2 TYR A 118      14.532  19.846   4.562  1.00 34.26           C  
ATOM    740  CZ  TYR A 118      14.423  20.939   3.691  1.00 36.36           C  
ATOM    741  OH  TYR A 118      15.041  22.162   3.960  1.00 36.94           O  
ATOM    742  N   VAL A 119       9.198  15.640   2.868  1.00 26.22           N  
ATOM    743  CA  VAL A 119       8.516  14.360   2.632  1.00 27.29           C  
ATOM    744  C   VAL A 119       7.264  14.637   1.820  1.00 27.81           C  
ATOM    745  O   VAL A 119       6.402  15.345   2.303  1.00 28.46           O  
ATOM    746  CB  VAL A 119       8.187  13.658   3.982  1.00 28.11           C  
ATOM    747  CG1 VAL A 119       7.376  12.392   3.753  1.00 28.03           C  
ATOM    748  CG2 VAL A 119       9.489  13.311   4.717  1.00 25.91           C  
ATOM    749  N   GLU A 120       7.147  14.045   0.628  1.00 27.12           N  
ATOM    750  CA  GLU A 120       6.001  14.293  -0.244  0.50 27.74           C  
ATOM    752  C   GLU A 120       4.708  13.720   0.324  1.00 27.90           C  
ATOM    753  O   GLU A 120       3.706  14.438   0.419  1.00 28.62           O  
ATOM    754  CB  GLU A 120       6.243  13.752  -1.654  0.50 27.98           C  
ATOM    756  CG  GLU A 120       5.175  14.174  -2.660  0.50 28.58           C  
ATOM    758  CD  GLU A 120       5.548  13.894  -4.109  0.50 30.79           C  
ATOM    760  OE1 GLU A 120       6.404  13.021  -4.374  0.50 36.44           O  
ATOM    762  OE2 GLU A 120       4.960  14.559  -4.991  0.50 39.73           O  
ATOM    764  N   ASP A 121       4.739  12.434   0.682  1.00 28.46           N  
ATOM    765  CA  ASP A 121       3.562  11.738   1.232  1.00 28.80           C  
ATOM    766  C   ASP A 121       3.671  11.731   2.756  1.00 28.66           C  
ATOM    767  O   ASP A 121       3.983  10.709   3.379  1.00 26.56           O  
ATOM    768  CB  ASP A 121       3.459  10.330   0.627  1.00 31.44           C  
ATOM    769  CG  ASP A 121       2.141   9.636   0.950  1.00 29.93           C  
ATOM    770  OD1 ASP A 121       1.308  10.206   1.697  1.00 29.72           O  
ATOM    771  OD2 ASP A 121       1.961   8.509   0.437  1.00 31.13           O  
ATOM    772  N   VAL A 122       3.380  12.883   3.354  1.00 27.17           N  
ATOM    773  CA  VAL A 122       3.548  13.036   4.798  1.00 27.77           C  
ATOM    774  C   VAL A 122       2.521  12.216   5.574  1.00 27.85           C  
ATOM    775  O   VAL A 122       2.836  11.717   6.644  1.00 28.03           O  
ATOM    776  CB  VAL A 122       3.591  14.516   5.227  1.00 28.63           C  
ATOM    777  CG1 VAL A 122       2.210  15.148   5.265  1.00 30.74           C  
ATOM    778  CG2 VAL A 122       4.297  14.641   6.554  1.00 30.43           C  
ATOM    779  N   ALA A 123       1.311  12.070   5.021  1.00 28.07           N  
ATOM    780  CA  ALA A 123       0.260  11.252   5.648  1.00 28.55           C  
ATOM    781  C   ALA A 123       0.712   9.803   5.853  1.00 25.76           C  
ATOM    782  O   ALA A 123       0.480   9.230   6.930  1.00 25.73           O  
ATOM    783  CB  ALA A 123      -1.052  11.306   4.862  1.00 29.71           C  
ATOM    784  N   ARG A 124       1.418   9.246   4.869  1.00 25.05           N  
ATOM    785  CA  ARG A 124       1.984   7.891   4.974  0.50 24.38           C  
ATOM    787  C   ARG A 124       2.951   7.826   6.154  1.00 25.26           C  
ATOM    788  O   ARG A 124       2.893   6.908   6.975  1.00 26.47           O  
ATOM    789  CB  ARG A 124       2.668   7.475   3.669  0.50 24.43           C  
ATOM    791  CG  ARG A 124       3.310   6.100   3.679  0.50 24.72           C  
ATOM    793  CD  ARG A 124       3.841   5.758   2.305  0.50 30.11           C  
ATOM    795  NE  ARG A 124       4.325   4.378   2.183  0.50 40.57           N  
ATOM    797  CZ  ARG A 124       5.524   3.919   2.559  0.50 43.46           C  
ATOM    799  NH1 ARG A 124       6.429   4.705   3.154  0.50 48.90           N  
ATOM    801  NH2 ARG A 124       5.818   2.630   2.361  0.50 42.39           N  
ATOM    803  N   LEU A 125       3.837   8.814   6.233  1.00 25.20           N  
ATOM    804  CA  LEU A 125       4.786   8.907   7.356  1.00 26.01           C  
ATOM    805  C   LEU A 125       4.046   9.003   8.704  1.00 26.55           C  
ATOM    806  O   LEU A 125       4.417   8.314   9.650  1.00 26.28           O  
ATOM    807  CB  LEU A 125       5.791  10.052   7.144  1.00 27.51           C  
ATOM    808  CG  LEU A 125       6.854  10.255   8.227  1.00 27.34           C  
ATOM    809  CD1 LEU A 125       8.176  10.817   7.640  1.00 31.02           C  
ATOM    810  CD2 LEU A 125       6.344  11.142   9.374  1.00 29.05           C  
ATOM    811  N   PHE A 126       3.008   9.833   8.785  1.00 25.71           N  
ATOM    812  CA  PHE A 126       2.215   9.947  10.012  1.00 25.26           C  
ATOM    813  C   PHE A 126       1.609   8.603  10.429  1.00 26.96           C  
ATOM    814  O   PHE A 126       1.627   8.247  11.607  1.00 26.86           O  
ATOM    815  CB  PHE A 126       1.062  10.960   9.858  1.00 27.73           C  
ATOM    816  CG  PHE A 126       1.467  12.409   9.700  1.00 28.70           C  
ATOM    817  CD1 PHE A 126       2.712  12.896  10.099  1.00 28.91           C  
ATOM    818  CD2 PHE A 126       0.520  13.331   9.252  1.00 29.25           C  
ATOM    819  CE1 PHE A 126       3.028  14.249   9.989  1.00 31.79           C  
ATOM    820  CE2 PHE A 126       0.821  14.685   9.133  1.00 29.16           C  
ATOM    821  CZ  PHE A 126       2.065  15.151   9.517  1.00 28.90           C  
ATOM    822  N   ARG A 127       1.064   7.856   9.471  1.00 27.16           N  
ATOM    823  CA  ARG A 127       0.494   6.531   9.778  1.00 27.52           C  
ATOM    824  C   ARG A 127       1.554   5.565  10.292  1.00 27.71           C  
ATOM    825  O   ARG A 127       1.294   4.790  11.215  1.00 28.31           O  
ATOM    826  CB  ARG A 127      -0.247   5.942   8.588  1.00 27.59           C  
ATOM    827  CG  ARG A 127      -1.452   6.780   8.191  1.00 26.41           C  
ATOM    828  CD  ARG A 127      -2.215   6.146   7.047  1.00 25.07           C  
ATOM    829  NE  ARG A 127      -1.491   5.985   5.763  1.00 26.28           N  
ATOM    830  CZ  ARG A 127      -1.526   6.825   4.721  1.00 26.35           C  
ATOM    831  NH1 ARG A 127      -2.205   7.957   4.765  1.00 28.63           N  
ATOM    832  NH2 ARG A 127      -0.850   6.522   3.606  1.00 27.55           N  
ATOM    833  N   THR A 128       2.749   5.647   9.717  1.00 27.56           N  
ATOM    834  CA  THR A 128       3.884   4.821  10.134  1.00 28.16           C  
ATOM    835  C   THR A 128       4.310   5.163  11.555  1.00 28.98           C  
ATOM    836  O   THR A 128       4.520   4.260  12.383  1.00 28.39           O  
ATOM    837  CB  THR A 128       5.037   4.963   9.128  1.00 26.76           C  
ATOM    838  OG1 THR A 128       4.599   4.409   7.881  1.00 28.55           O  
ATOM    839  CG2 THR A 128       6.288   4.221   9.569  1.00 27.84           C  
ATOM    840  N   VAL A 129       4.410   6.457  11.845  1.00 27.55           N  
ATOM    841  CA  VAL A 129       4.748   6.910  13.197  1.00 25.94           C  
ATOM    842  C   VAL A 129       3.653   6.491  14.183  1.00 26.90           C  
ATOM    843  O   VAL A 129       3.962   5.998  15.271  1.00 27.26           O  
ATOM    844  CB  VAL A 129       5.063   8.424  13.229  1.00 27.10           C  
ATOM    845  CG1 VAL A 129       5.227   8.936  14.688  1.00 25.01           C  
ATOM    846  CG2 VAL A 129       6.327   8.727  12.418  1.00 27.10           C  
ATOM    847  N   HIS A 130       2.385   6.638  13.794  1.00 28.63           N  
ATOM    848  CA  HIS A 130       1.276   6.258  14.677  1.00 26.87           C  
ATOM    849  C   HIS A 130       1.386   4.791  15.120  1.00 27.25           C  
ATOM    850  O   HIS A 130       1.315   4.508  16.315  1.00 29.34           O  
ATOM    851  CB  HIS A 130      -0.081   6.550  14.024  1.00 28.74           C  
ATOM    852  CG  HIS A 130      -1.253   6.238  14.897  1.00 29.01           C  
ATOM    853  ND1 HIS A 130      -1.828   4.987  14.952  1.00 34.09           N  
ATOM    854  CD2 HIS A 130      -1.977   7.021  15.727  1.00 28.55           C  
ATOM    855  CE1 HIS A 130      -2.851   5.012  15.787  1.00 32.94           C  
ATOM    856  NE2 HIS A 130      -2.961   6.233  16.274  1.00 31.22           N  
ATOM    857  N   GLN A 131       1.602   3.871  14.181  1.00 26.95           N  
ATOM    858  CA  GLN A 131       1.709   2.433  14.541  1.00 28.67           C  
ATOM    859  C   GLN A 131       2.972   2.081  15.354  1.00 28.56           C  
ATOM    860  O   GLN A 131       2.957   1.116  16.123  1.00 27.86           O  
ATOM    861  CB  GLN A 131       1.531   1.511  13.325  1.00 29.09           C  
ATOM    862  CG  GLN A 131       2.581   1.573  12.233  1.00 35.13           C  
ATOM    863  CD  GLN A 131       3.836   0.767  12.516  1.00 39.27           C  
ATOM    864  OE1 GLN A 131       3.764  -0.423  12.851  1.00 36.38           O  
ATOM    865  NE2 GLN A 131       4.993   1.392  12.337  1.00 30.94           N  
ATOM    866  N   ALA A 132       4.042   2.862  15.167  1.00 29.40           N  
ATOM    867  CA  ALA A 132       5.295   2.686  15.900  1.00 28.48           C  
ATOM    868  C   ALA A 132       5.191   3.141  17.351  1.00 27.58           C  
ATOM    869  O   ALA A 132       5.957   2.662  18.192  1.00 28.41           O  
ATOM    870  CB  ALA A 132       6.441   3.454  15.201  1.00 28.63           C  
ATOM    871  N   LEU A 133       4.266   4.058  17.636  1.00 25.51           N  
ATOM    872  CA  LEU A 133       4.087   4.591  18.992  1.00 26.34           C  
ATOM    873  C   LEU A 133       3.188   3.698  19.830  1.00 27.73           C  
ATOM    874  O   LEU A 133       2.175   3.167  19.338  1.00 29.71           O  
ATOM    875  CB  LEU A 133       3.503   6.009  18.951  1.00 27.80           C  
ATOM    876  CG  LEU A 133       4.437   7.128  18.485  1.00 30.21           C  
ATOM    877  CD1 LEU A 133       3.676   8.423  18.184  1.00 26.24           C  
ATOM    878  CD2 LEU A 133       5.525   7.359  19.515  1.00 30.44           C  
ATOM    879  N   SER A 134       3.568   3.513  21.091  1.00 31.02           N  
ATOM    880  CA  SER A 134       2.722   2.772  22.034  1.00 31.51           C  
ATOM    881  C   SER A 134       1.572   3.683  22.454  1.00 32.60           C  
ATOM    882  O   SER A 134       1.702   4.908  22.358  1.00 32.20           O  
ATOM    883  CB  SER A 134       3.529   2.311  23.238  1.00 31.96           C  
ATOM    884  OG  SER A 134       4.483   1.367  22.810  1.00 35.41           O  
ATOM    885  N   PRO A 135       0.430   3.105  22.902  1.00 34.19           N  
ATOM    886  CA  PRO A 135      -0.718   3.920  23.315  1.00 34.05           C  
ATOM    887  C   PRO A 135      -0.309   5.023  24.299  1.00 34.00           C  
ATOM    888  O   PRO A 135       0.484   4.760  25.202  1.00 33.94           O  
ATOM    889  CB  PRO A 135      -1.647   2.887  23.956  1.00 35.59           C  
ATOM    890  CG  PRO A 135      -1.339   1.651  23.227  1.00 34.03           C  
ATOM    891  CD  PRO A 135       0.132   1.667  23.052  1.00 37.07           C  
ATOM    892  N   GLY A 136      -0.784   6.248  24.058  1.00 34.33           N  
ATOM    893  CA  GLY A 136      -0.423   7.424  24.853  1.00 34.51           C  
ATOM    894  C   GLY A 136       0.898   8.079  24.453  1.00 33.24           C  
ATOM    895  O   GLY A 136       1.313   9.065  25.075  1.00 35.37           O  
ATOM    896  N   GLY A 137       1.566   7.550  23.423  1.00 31.62           N  
ATOM    897  CA  GLY A 137       2.835   8.101  22.966  1.00 30.08           C  
ATOM    898  C   GLY A 137       2.636   9.389  22.202  1.00 30.24           C  
ATOM    899  O   GLY A 137       1.516   9.687  21.781  1.00 31.71           O  
ATOM    900  N   HIS A 138       3.728  10.145  22.017  1.00 28.34           N  
ATOM    901  CA  HIS A 138       3.690  11.452  21.350  1.00 28.78           C  
ATOM    902  C   HIS A 138       4.586  11.548  20.128  1.00 26.79           C  
ATOM    903  O   HIS A 138       5.531  10.807  19.995  1.00 28.30           O  
ATOM    904  CB  HIS A 138       4.072  12.581  22.302  1.00 29.55           C  
ATOM    905  CG  HIS A 138       3.082  12.800  23.401  1.00 36.17           C  
ATOM    906  ND1 HIS A 138       3.157  12.143  24.605  1.00 36.66           N  
ATOM    907  CD2 HIS A 138       1.990  13.597  23.473  1.00 42.78           C  
ATOM    908  CE1 HIS A 138       2.155  12.525  25.378  1.00 38.27           C  
ATOM    909  NE2 HIS A 138       1.429  13.407  24.713  1.00 39.77           N  
ATOM    910  N   PHE A 139       4.210  12.460  19.236  1.00 27.25           N  
ATOM    911  CA  PHE A 139       4.959  12.822  18.040  1.00 26.94           C  
ATOM    912  C   PHE A 139       5.092  14.338  18.108  1.00 27.78           C  
ATOM    913  O   PHE A 139       4.077  15.029  18.091  1.00 29.05           O  
ATOM    914  CB  PHE A 139       4.223  12.344  16.798  1.00 29.25           C  
ATOM    915  CG  PHE A 139       4.921  12.630  15.486  1.00 30.11           C  
ATOM    916  CD1 PHE A 139       6.314  12.789  15.367  1.00 30.28           C  
ATOM    917  CD2 PHE A 139       4.163  12.616  14.314  1.00 34.62           C  
ATOM    918  CE1 PHE A 139       6.923  13.005  14.126  1.00 31.48           C  
ATOM    919  CE2 PHE A 139       4.775  12.811  13.091  1.00 32.87           C  
ATOM    920  CZ  PHE A 139       6.141  13.005  12.991  1.00 34.40           C  
ATOM    921  N   VAL A 140       6.322  14.825  18.226  1.00 26.56           N  
ATOM    922  CA  VAL A 140       6.607  16.244  18.364  1.00 26.43           C  
ATOM    923  C   VAL A 140       7.573  16.612  17.252  1.00 27.50           C  
ATOM    924  O   VAL A 140       8.648  16.012  17.116  1.00 27.70           O  
ATOM    925  CB  VAL A 140       7.207  16.543  19.741  1.00 26.36           C  
ATOM    926  CG1 VAL A 140       7.561  18.033  19.879  1.00 28.35           C  
ATOM    927  CG2 VAL A 140       6.243  16.131  20.847  1.00 27.15           C  
ATOM    928  N   PHE A 141       7.184  17.567  16.411  1.00 26.92           N  
ATOM    929  CA  PHE A 141       8.007  17.931  15.288  1.00 26.24           C  
ATOM    930  C   PHE A 141       7.910  19.384  14.865  1.00 28.36           C  
ATOM    931  O   PHE A 141       6.904  20.058  15.130  1.00 27.76           O  
ATOM    932  CB  PHE A 141       7.683  17.003  14.100  1.00 26.76           C  
ATOM    933  CG  PHE A 141       6.282  17.165  13.520  1.00 27.41           C  
ATOM    934  CD1 PHE A 141       6.070  18.028  12.442  1.00 31.26           C  
ATOM    935  CD2 PHE A 141       5.179  16.453  14.032  1.00 28.47           C  
ATOM    936  CE1 PHE A 141       4.792  18.180  11.862  1.00 32.55           C  
ATOM    937  CE2 PHE A 141       3.882  16.601  13.454  1.00 29.58           C  
ATOM    938  CZ  PHE A 141       3.703  17.480  12.369  1.00 29.53           C  
ATOM    939  N   SER A 142       8.973  19.836  14.191  1.00 26.30           N  
ATOM    940  CA  SER A 142       9.031  21.164  13.615  1.00 26.69           C  
ATOM    941  C   SER A 142       9.165  21.052  12.116  1.00 28.13           C  
ATOM    942  O   SER A 142       9.807  20.127  11.598  1.00 27.60           O  
ATOM    943  CB  SER A 142      10.189  21.964  14.176  1.00 28.07           C  
ATOM    944  OG  SER A 142      11.424  21.328  13.909  1.00 28.72           O  
ATOM    945  N   THR A 143       8.527  21.988  11.429  1.00 27.17           N  
ATOM    946  CA  THR A 143       8.630  22.133   9.984  1.00 27.52           C  
ATOM    947  C   THR A 143       8.650  23.619   9.645  1.00 27.00           C  
ATOM    948  O   THR A 143       8.293  24.455  10.459  1.00 26.57           O  
ATOM    949  CB  THR A 143       7.424  21.464   9.222  1.00 28.51           C  
ATOM    950  OG1 THR A 143       6.173  21.933   9.770  1.00 30.37           O  
ATOM    951  CG2 THR A 143       7.468  19.927   9.328  1.00 31.01           C  
ATOM    952  N   GLU A 144       9.067  23.943   8.432  1.00 28.05           N  
ATOM    953  CA  GLU A 144       8.915  25.294   7.928  1.00 28.58           C  
ATOM    954  C   GLU A 144       7.427  25.602   7.879  1.00 27.87           C  
ATOM    955  O   GLU A 144       6.608  24.768   7.497  1.00 29.14           O  
ATOM    956  CB  GLU A 144       9.506  25.467   6.532  1.00 27.47           C  
ATOM    957  CG  GLU A 144      11.012  25.571   6.550  1.00 28.52           C  
ATOM    958  CD  GLU A 144      11.656  25.752   5.204  1.00 31.40           C  
ATOM    959  OE1 GLU A 144      10.968  26.123   4.244  1.00 31.56           O  
ATOM    960  OE2 GLU A 144      12.866  25.511   5.133  1.00 33.17           O  
ATOM    961  N   HIS A 145       7.088  26.799   8.319  1.00 28.30           N  
ATOM    962  CA  HIS A 145       5.689  27.253   8.379  1.00 26.40           C  
ATOM    963  C   HIS A 145       5.185  27.527   6.954  1.00 26.14           C  
ATOM    964  O   HIS A 145       5.966  27.979   6.113  1.00 28.42           O  
ATOM    965  CB  HIS A 145       5.634  28.548   9.200  1.00 26.84           C  
ATOM    966  CG  HIS A 145       4.262  28.943   9.633  1.00 28.15           C  
ATOM    967  ND1 HIS A 145       3.337  29.504   8.779  1.00 27.47           N  
ATOM    968  CD2 HIS A 145       3.674  28.902  10.852  1.00 29.48           C  
ATOM    969  CE1 HIS A 145       2.227  29.762   9.446  1.00 29.98           C  
ATOM    970  NE2 HIS A 145       2.404  29.407  10.706  1.00 28.03           N  
ATOM    971  N   PRO A 146       3.896  27.209   6.664  1.00 26.28           N  
ATOM    972  CA  PRO A 146       3.409  27.545   5.318  1.00 25.88           C  
ATOM    973  C   PRO A 146       3.489  29.038   4.900  1.00 25.49           C  
ATOM    974  O   PRO A 146       3.611  29.336   3.717  1.00 26.67           O  
ATOM    975  CB  PRO A 146       1.971  26.974   5.318  1.00 26.26           C  
ATOM    976  CG  PRO A 146       1.616  26.844   6.732  1.00 28.22           C  
ATOM    977  CD  PRO A 146       2.865  26.516   7.458  1.00 28.96           C  
ATOM    978  N   ILE A 147       3.436  29.977   5.850  1.00 25.58           N  
ATOM    979  CA  ILE A 147       3.648  31.401   5.531  1.00 25.66           C  
ATOM    980  C   ILE A 147       5.041  31.595   4.915  1.00 25.26           C  
ATOM    981  O   ILE A 147       5.203  32.337   3.961  1.00 26.65           O  
ATOM    982  CB  ILE A 147       3.494  32.301   6.766  1.00 27.56           C  
ATOM    983  CG1 ILE A 147       2.010  32.428   7.107  1.00 28.02           C  
ATOM    984  CG2 ILE A 147       4.117  33.708   6.505  1.00 27.30           C  
ATOM    985  CD1 ILE A 147       1.730  33.079   8.426  1.00 26.83           C  
ATOM    986  N   TYR A 148       6.033  30.915   5.485  1.00 26.07           N  
ATOM    987  CA  TYR A 148       7.394  30.956   5.008  1.00 27.43           C  
ATOM    988  C   TYR A 148       7.570  30.207   3.678  1.00 26.84           C  
ATOM    989  O   TYR A 148       8.306  30.682   2.795  1.00 27.90           O  
ATOM    990  CB  TYR A 148       8.327  30.401   6.096  1.00 27.57           C  
ATOM    991  CG  TYR A 148       9.789  30.479   5.757  1.00 27.94           C  
ATOM    992  CD1 TYR A 148      10.519  31.654   5.951  1.00 27.73           C  
ATOM    993  CD2 TYR A 148      10.458  29.365   5.251  1.00 29.15           C  
ATOM    994  CE1 TYR A 148      11.889  31.719   5.626  1.00 32.10           C  
ATOM    995  CE2 TYR A 148      11.813  29.421   4.911  1.00 31.58           C  
ATOM    996  CZ  TYR A 148      12.528  30.596   5.121  1.00 29.78           C  
ATOM    997  OH  TYR A 148      13.865  30.656   4.779  1.00 35.62           O  
HETATM  998  N   MSE A 149       6.924  29.056   3.526  1.00 27.43           N  
HETATM  999  CA  MSE A 149       7.052  28.234   2.307  1.00 27.67           C  
HETATM 1000  C   MSE A 149       6.231  28.681   1.102  1.00 28.82           C  
HETATM 1001  O   MSE A 149       6.597  28.392  -0.031  1.00 28.92           O  
HETATM 1002  CB  MSE A 149       6.647  26.785   2.596  1.00 28.42           C  
HETATM 1003  CG  MSE A 149       7.525  26.077   3.594  1.00 28.95           C  
HETATM 1004 SE   MSE A 149       7.080  24.181   3.654  0.75 30.89          SE  
HETATM 1005  CE  MSE A 149       5.223  24.316   4.377  1.00 30.98           C  
ATOM   1006  N   ALA A 150       5.094  29.327   1.348  1.00 28.78           N  
ATOM   1007  CA  ALA A 150       4.157  29.707   0.275  1.00 27.44           C  
ATOM   1008  C   ALA A 150       4.684  30.515  -0.912  1.00 28.66           C  
ATOM   1009  O   ALA A 150       4.425  30.148  -2.053  1.00 29.96           O  
ATOM   1010  CB  ALA A 150       2.951  30.458   0.866  1.00 28.09           C  
ATOM   1011  N   PRO A 151       5.403  31.621  -0.652  1.00 28.16           N  
ATOM   1012  CA  PRO A 151       5.687  32.540  -1.764  1.00 27.75           C  
ATOM   1013  C   PRO A 151       6.553  32.025  -2.920  1.00 29.93           C  
ATOM   1014  O   PRO A 151       7.492  31.259  -2.700  1.00 31.56           O  
ATOM   1015  CB  PRO A 151       6.349  33.743  -1.072  1.00 29.00           C  
ATOM   1016  CG  PRO A 151       6.057  33.587   0.371  1.00 28.73           C  
ATOM   1017  CD  PRO A 151       5.965  32.121   0.616  1.00 28.03           C  
ATOM   1018  N   ALA A 152       6.213  32.446  -4.135  1.00 30.40           N  
ATOM   1019  CA  ALA A 152       7.004  32.098  -5.320  1.00 30.95           C  
ATOM   1020  C   ALA A 152       8.387  32.758  -5.254  1.00 31.75           C  
ATOM   1021  O   ALA A 152       9.373  32.181  -5.728  1.00 32.73           O  
ATOM   1022  CB  ALA A 152       6.273  32.524  -6.559  1.00 28.18           C  
ATOM   1023  N   ARG A 153       8.453  33.961  -4.683  1.00 30.48           N  
ATOM   1024  CA  ARG A 153       9.685  34.726  -4.510  1.00 33.98           C  
ATOM   1025  C   ARG A 153       9.756  35.130  -3.037  1.00 33.91           C  
ATOM   1026  O   ARG A 153       9.480  36.282  -2.702  1.00 35.25           O  
ATOM   1027  CB  ARG A 153       9.654  35.960  -5.418  1.00 33.89           C  
ATOM   1028  CG  ARG A 153       9.654  35.650  -6.900  1.00 40.83           C  
ATOM   1029  CD  ARG A 153       9.628  36.925  -7.759  1.00 39.46           C  
ATOM   1030  NE  ARG A 153      10.768  37.812  -7.519  1.00 51.54           N  
ATOM   1031  N   PRO A 154      10.132  34.188  -2.145  1.00 32.72           N  
ATOM   1032  CA  PRO A 154      10.112  34.497  -0.721  1.00 32.55           C  
ATOM   1033  C   PRO A 154      11.193  35.488  -0.345  1.00 33.55           C  
ATOM   1034  O   PRO A 154      12.292  35.463  -0.905  1.00 34.77           O  
ATOM   1035  CB  PRO A 154      10.357  33.145  -0.059  1.00 32.43           C  
ATOM   1036  CG  PRO A 154      11.120  32.388  -1.067  1.00 36.26           C  
ATOM   1037  CD  PRO A 154      10.628  32.822  -2.389  1.00 34.42           C  
ATOM   1038  N   GLY A 155      10.847  36.376   0.571  1.00 32.13           N  
ATOM   1039  CA  GLY A 155      11.761  37.390   1.052  1.00 31.57           C  
ATOM   1040  C   GLY A 155      11.034  38.543   1.681  1.00 30.89           C  
ATOM   1041  O   GLY A 155       9.826  38.667   1.564  1.00 32.53           O  
ATOM   1042  N   TRP A 156      11.795  39.398   2.342  1.00 30.02           N  
ATOM   1043  CA  TRP A 156      11.241  40.597   2.943  1.00 29.28           C  
ATOM   1044  C   TRP A 156      11.063  41.686   1.890  1.00 29.89           C  
ATOM   1045  O   TRP A 156      11.849  41.794   0.944  1.00 32.10           O  
ATOM   1046  CB  TRP A 156      12.155  41.140   4.023  1.00 28.64           C  
ATOM   1047  CG  TRP A 156      12.399  40.205   5.165  1.00 30.81           C  
ATOM   1048  CD1 TRP A 156      13.542  39.513   5.418  1.00 30.92           C  
ATOM   1049  CD2 TRP A 156      11.479  39.849   6.207  1.00 29.02           C  
ATOM   1050  NE1 TRP A 156      13.402  38.766   6.558  1.00 32.93           N  
ATOM   1051  CE2 TRP A 156      12.151  38.958   7.069  1.00 31.20           C  
ATOM   1052  CE3 TRP A 156      10.165  40.226   6.517  1.00 26.61           C  
ATOM   1053  CZ2 TRP A 156      11.556  38.428   8.216  1.00 32.44           C  
ATOM   1054  CZ3 TRP A 156       9.566  39.698   7.671  1.00 30.47           C  
ATOM   1055  CH2 TRP A 156      10.259  38.805   8.498  1.00 29.41           C  
ATOM   1056  N   ALA A 157      10.023  42.489   2.080  1.00 29.71           N  
ATOM   1057  CA  ALA A 157       9.738  43.671   1.271  1.00 30.63           C  
ATOM   1058  C   ALA A 157       9.674  44.859   2.236  1.00 34.17           C  
ATOM   1059  O   ALA A 157       9.219  44.712   3.369  1.00 36.12           O  
ATOM   1060  CB  ALA A 157       8.429  43.501   0.513  1.00 30.14           C  
ATOM   1061  N   ILE A 158      10.178  46.013   1.810  1.00 38.60           N  
ATOM   1062  CA  ILE A 158      10.142  47.244   2.607  1.00 40.64           C  
ATOM   1063  C   ILE A 158       9.139  48.139   1.892  1.00 42.04           C  
ATOM   1064  O   ILE A 158       9.390  48.547   0.754  1.00 43.62           O  
ATOM   1065  CB  ILE A 158      11.525  47.948   2.698  1.00 40.46           C  
ATOM   1066  CG1 ILE A 158      12.546  47.100   3.464  1.00 42.77           C  
ATOM   1067  CG2 ILE A 158      11.392  49.296   3.402  1.00 42.77           C  
ATOM   1068  CD1 ILE A 158      13.100  45.882   2.718  1.00 43.55           C  
ATOM   1069  N   ASP A 159       8.010  48.421   2.549  1.00 43.01           N  
ATOM   1070  CA  ASP A 159       6.944  49.242   1.955  1.00 44.42           C  
ATOM   1071  C   ASP A 159       7.289  50.743   1.926  1.00 44.41           C  
ATOM   1072  O   ASP A 159       8.353  51.144   2.407  1.00 42.83           O  
ATOM   1073  CB  ASP A 159       5.573  48.939   2.606  1.00 44.67           C  
ATOM   1074  CG  ASP A 159       5.397  49.509   4.022  1.00 45.56           C  
ATOM   1075  OD1 ASP A 159       6.160  50.384   4.505  1.00 42.88           O  
ATOM   1076  OD2 ASP A 159       4.425  49.069   4.665  1.00 43.27           O  
ATOM   1077  N   ALA A 160       6.380  51.544   1.361  1.00 46.46           N  
ATOM   1078  CA  ALA A 160       6.528  53.020   1.240  1.00 45.77           C  
ATOM   1079  C   ALA A 160       6.873  53.748   2.544  1.00 45.37           C  
ATOM   1080  O   ALA A 160       7.648  54.710   2.532  1.00 46.21           O  
ATOM   1081  CB  ALA A 160       5.253  53.637   0.638  1.00 46.63           C  
ATOM   1082  N   GLU A 161       6.308  53.272   3.654  1.00 43.53           N  
ATOM   1083  CA  GLU A 161       6.545  53.849   4.985  1.00 42.74           C  
ATOM   1084  C   GLU A 161       7.839  53.363   5.686  1.00 40.42           C  
ATOM   1085  O   GLU A 161       8.146  53.850   6.774  1.00 39.17           O  
ATOM   1086  CB  GLU A 161       5.354  53.547   5.895  1.00 42.69           C  
ATOM   1087  CG  GLU A 161       4.026  54.089   5.370  1.00 48.24           C  
ATOM   1088  CD  GLU A 161       2.864  53.645   6.225  1.00 48.86           C  
ATOM   1089  OE1 GLU A 161       2.889  53.910   7.451  1.00 58.41           O  
ATOM   1090  OE2 GLU A 161       1.921  53.041   5.669  1.00 59.24           O  
ATOM   1091  N   GLY A 162       8.580  52.433   5.067  1.00 37.74           N  
ATOM   1092  CA  GLY A 162       9.775  51.826   5.661  1.00 36.34           C  
ATOM   1093  C   GLY A 162       9.482  50.619   6.543  1.00 34.04           C  
ATOM   1094  O   GLY A 162      10.365  50.107   7.228  1.00 29.56           O  
ATOM   1095  N   ARG A 163       8.241  50.137   6.533  1.00 33.65           N  
ATOM   1096  CA  ARG A 163       7.868  48.987   7.341  1.00 34.30           C  
ATOM   1097  C   ARG A 163       8.292  47.686   6.649  1.00 30.58           C  
ATOM   1098  O   ARG A 163       8.118  47.531   5.436  1.00 32.20           O  
ATOM   1099  CB  ARG A 163       6.352  48.980   7.575  1.00 34.99           C  
ATOM   1100  CG  ARG A 163       5.837  47.874   8.465  1.00 38.51           C  
ATOM   1101  CD  ARG A 163       4.314  47.894   8.561  1.00 42.49           C  
ATOM   1102  NE  ARG A 163       3.805  49.103   9.223  1.00 51.49           N  
ATOM   1103  CZ  ARG A 163       3.207  50.154   8.643  1.00 53.40           C  
ATOM   1104  NH1 ARG A 163       2.965  50.213   7.329  1.00 57.71           N  
ATOM   1105  NH2 ARG A 163       2.811  51.169   9.411  1.00 55.39           N  
ATOM   1106  N   ARG A 164       8.845  46.764   7.438  1.00 31.22           N  
ATOM   1107  CA  ARG A 164       9.250  45.448   6.950  0.50 29.69           C  
ATOM   1109  C   ARG A 164       7.992  44.589   6.814  1.00 29.84           C  
ATOM   1110  O   ARG A 164       7.209  44.503   7.743  1.00 28.45           O  
ATOM   1111  CB  ARG A 164      10.232  44.787   7.929  0.50 30.99           C  
ATOM   1113  CG  ARG A 164      10.665  43.361   7.575  0.50 30.52           C  
ATOM   1115  CD  ARG A 164      11.704  42.775   8.543  0.50 30.83           C  
ATOM   1117  NE  ARG A 164      11.275  42.842   9.949  0.50 31.41           N  
ATOM   1119  CZ  ARG A 164      11.615  43.783  10.845  0.50 35.26           C  
ATOM   1121  NH1 ARG A 164      12.437  44.800  10.554  0.50 41.13           N  
ATOM   1123  NH2 ARG A 164      11.118  43.704  12.080  0.50 30.46           N  
ATOM   1125  N   THR A 165       7.822  43.948   5.649  1.00 27.07           N  
ATOM   1126  CA  THR A 165       6.678  43.044   5.398  1.00 27.07           C  
ATOM   1127  C   THR A 165       7.140  41.774   4.714  1.00 26.89           C  
ATOM   1128  O   THR A 165       8.222  41.732   4.120  1.00 27.16           O  
ATOM   1129  CB  THR A 165       5.585  43.685   4.534  1.00 29.02           C  
ATOM   1130  OG1 THR A 165       6.063  43.862   3.189  1.00 27.79           O  
ATOM   1131  CG2 THR A 165       5.167  45.019   5.107  1.00 29.04           C  
ATOM   1132  N   TRP A 166       6.286  40.753   4.797  1.00 25.71           N  
ATOM   1133  CA  TRP A 166       6.521  39.440   4.201  1.00 25.07           C  
ATOM   1134  C   TRP A 166       5.381  39.151   3.234  1.00 24.81           C  
ATOM   1135  O   TRP A 166       4.288  38.708   3.665  1.00 26.39           O  
ATOM   1136  CB  TRP A 166       6.615  38.360   5.285  1.00 26.38           C  
ATOM   1137  CG  TRP A 166       6.928  36.987   4.748  1.00 28.01           C  
ATOM   1138  CD1 TRP A 166       6.040  36.007   4.446  1.00 27.54           C  
ATOM   1139  CD2 TRP A 166       8.225  36.463   4.421  1.00 26.38           C  
ATOM   1140  NE1 TRP A 166       6.697  34.903   3.999  1.00 26.84           N  
ATOM   1141  CE2 TRP A 166       8.037  35.146   3.956  1.00 25.94           C  
ATOM   1142  CE3 TRP A 166       9.533  36.968   4.521  1.00 24.70           C  
ATOM   1143  CZ2 TRP A 166       9.107  34.312   3.562  1.00 27.45           C  
ATOM   1144  CZ3 TRP A 166      10.621  36.143   4.114  1.00 27.14           C  
ATOM   1145  CH2 TRP A 166      10.390  34.828   3.636  1.00 29.21           C  
ATOM   1146  N   PRO A 167       5.584  39.436   1.932  1.00 26.87           N  
ATOM   1147  CA  PRO A 167       4.549  39.160   0.932  1.00 28.62           C  
ATOM   1148  C   PRO A 167       4.255  37.678   0.728  1.00 30.56           C  
ATOM   1149  O   PRO A 167       5.177  36.884   0.534  1.00 31.78           O  
ATOM   1150  CB  PRO A 167       5.111  39.798  -0.342  1.00 30.37           C  
ATOM   1151  CG  PRO A 167       6.062  40.793   0.121  1.00 29.54           C  
ATOM   1152  CD  PRO A 167       6.712  40.159   1.305  1.00 27.13           C  
ATOM   1153  N   ILE A 168       2.973  37.337   0.774  1.00 29.50           N  
ATOM   1154  CA  ILE A 168       2.487  35.984   0.605  1.00 30.98           C  
ATOM   1155  C   ILE A 168       1.740  35.884  -0.723  1.00 31.33           C  
ATOM   1156  O   ILE A 168       0.996  36.787  -1.081  1.00 31.97           O  
ATOM   1157  CB  ILE A 168       1.515  35.612   1.787  1.00 33.68           C  
ATOM   1158  CG1 ILE A 168       2.300  35.508   3.116  1.00 35.78           C  
ATOM   1159  CG2 ILE A 168       0.816  34.292   1.546  1.00 38.90           C  
ATOM   1160  CD1 ILE A 168       1.397  35.429   4.398  1.00 35.69           C  
ATOM   1161  N   ASP A 169       1.999  34.815  -1.469  1.00 27.55           N  
ATOM   1162  CA  ASP A 169       1.174  34.425  -2.619  1.00 27.57           C  
ATOM   1163  C   ASP A 169       1.020  32.900  -2.596  1.00 28.24           C  
ATOM   1164  O   ASP A 169       1.812  32.185  -1.946  1.00 28.82           O  
ATOM   1165  CB  ASP A 169       1.740  34.890  -3.967  1.00 28.80           C  
ATOM   1166  CG  ASP A 169       3.008  34.151  -4.344  1.00 28.17           C  
ATOM   1167  OD1 ASP A 169       4.060  34.491  -3.802  1.00 36.25           O  
ATOM   1168  OD2 ASP A 169       2.941  33.227  -5.181  1.00 40.46           O  
ATOM   1169  N   ARG A 170      -0.027  32.427  -3.274  1.00 30.21           N  
ATOM   1170  CA  ARG A 170      -0.345  31.002  -3.427  1.00 32.29           C  
ATOM   1171  C   ARG A 170      -0.341  30.180  -2.123  1.00 29.76           C  
ATOM   1172  O   ARG A 170      -0.023  28.997  -2.122  1.00 28.77           O  
ATOM   1173  CB  ARG A 170       0.592  30.400  -4.492  1.00 35.39           C  
ATOM   1174  CG  ARG A 170       0.423  31.070  -5.870  1.00 37.18           C  
ATOM   1175  CD  ARG A 170       1.344  30.541  -6.963  1.00 42.33           C  
ATOM   1176  NE  ARG A 170       1.068  29.154  -7.371  1.00 52.14           N  
ATOM   1177  CZ  ARG A 170       1.840  28.070  -7.169  1.00 57.26           C  
ATOM   1178  NH1 ARG A 170       3.030  28.118  -6.557  1.00 57.34           N  
ATOM   1179  NH2 ARG A 170       1.411  26.890  -7.626  1.00 58.54           N  
ATOM   1180  N   TYR A 171      -0.715  30.804  -1.008  1.00 28.88           N  
ATOM   1181  CA  TYR A 171      -0.765  30.086   0.271  1.00 27.50           C  
ATOM   1182  C   TYR A 171      -1.674  28.869   0.230  1.00 27.58           C  
ATOM   1183  O   TYR A 171      -1.363  27.843   0.855  1.00 28.74           O  
ATOM   1184  CB  TYR A 171      -1.199  31.019   1.391  1.00 28.18           C  
ATOM   1185  CG  TYR A 171      -1.195  30.409   2.784  1.00 29.34           C  
ATOM   1186  CD1 TYR A 171      -0.052  30.463   3.593  1.00 27.39           C  
ATOM   1187  CD2 TYR A 171      -2.348  29.818   3.302  1.00 27.81           C  
ATOM   1188  CE1 TYR A 171      -0.067  29.938   4.890  1.00 26.77           C  
ATOM   1189  CE2 TYR A 171      -2.381  29.292   4.594  1.00 29.84           C  
ATOM   1190  CZ  TYR A 171      -1.235  29.352   5.389  1.00 27.09           C  
ATOM   1191  OH  TYR A 171      -1.254  28.828   6.663  1.00 28.95           O  
ATOM   1192  N   LEU A 172      -2.779  28.960  -0.517  1.00 29.74           N  
ATOM   1193  CA  LEU A 172      -3.729  27.844  -0.610  1.00 29.66           C  
ATOM   1194  C   LEU A 172      -3.457  26.879  -1.761  1.00 32.33           C  
ATOM   1195  O   LEU A 172      -4.223  25.906  -1.946  1.00 34.75           O  
ATOM   1196  CB  LEU A 172      -5.172  28.356  -0.649  1.00 29.84           C  
ATOM   1197  CG  LEU A 172      -5.752  29.073   0.580  1.00 32.24           C  
ATOM   1198  CD1 LEU A 172      -5.595  28.213   1.845  1.00 35.59           C  
ATOM   1199  CD2 LEU A 172      -5.198  30.469   0.813  1.00 40.46           C  
ATOM   1200  N   VAL A 173      -2.377  27.117  -2.520  1.00 28.78           N  
ATOM   1201  CA  VAL A 173      -2.003  26.241  -3.631  1.00 29.45           C  
ATOM   1202  C   VAL A 173      -0.904  25.347  -3.085  1.00 29.06           C  
ATOM   1203  O   VAL A 173       0.242  25.761  -2.970  1.00 31.61           O  
ATOM   1204  CB  VAL A 173      -1.519  27.017  -4.866  1.00 30.22           C  
ATOM   1205  CG1 VAL A 173      -1.233  26.046  -6.009  1.00 33.63           C  
ATOM   1206  CG2 VAL A 173      -2.546  28.040  -5.265  1.00 32.45           C  
ATOM   1207  N   GLU A 174      -1.256  24.110  -2.750  1.00 29.68           N  
ATOM   1208  CA  GLU A 174      -0.319  23.178  -2.137  1.00 31.03           C  
ATOM   1209  C   GLU A 174       0.467  22.442  -3.180  1.00 31.57           C  
ATOM   1210  O   GLU A 174       0.009  22.283  -4.319  1.00 31.17           O  
ATOM   1211  CB  GLU A 174      -1.057  22.230  -1.205  1.00 31.26           C  
ATOM   1212  CG  GLU A 174      -1.651  22.952  -0.005  1.00 28.90           C  
ATOM   1213  CD  GLU A 174      -2.412  22.049   0.935  1.00 34.15           C  
ATOM   1214  OE1 GLU A 174      -3.043  21.058   0.478  1.00 38.43           O  
ATOM   1215  OE2 GLU A 174      -2.389  22.336   2.140  1.00 33.17           O  
ATOM   1216  N   GLY A 175       1.657  21.993  -2.790  1.00 28.77           N  
ATOM   1217  CA  GLY A 175       2.537  21.262  -3.677  1.00 29.27           C  
ATOM   1218  C   GLY A 175       3.998  21.586  -3.473  1.00 28.66           C  
ATOM   1219  O   GLY A 175       4.361  22.367  -2.595  1.00 29.60           O  
ATOM   1220  N   PRO A 176       4.855  20.987  -4.316  1.00 30.79           N  
ATOM   1221  CA  PRO A 176       6.281  21.220  -4.239  1.00 31.95           C  
ATOM   1222  C   PRO A 176       6.676  22.670  -4.494  1.00 32.47           C  
ATOM   1223  O   PRO A 176       6.082  23.323  -5.357  1.00 32.72           O  
ATOM   1224  CB  PRO A 176       6.854  20.349  -5.368  1.00 32.85           C  
ATOM   1225  CG  PRO A 176       5.822  19.443  -5.757  1.00 35.11           C  
ATOM   1226  CD  PRO A 176       4.520  20.026  -5.387  1.00 31.56           C  
ATOM   1227  N   ARG A 177       7.653  23.147  -3.727  1.00 31.80           N  
ATOM   1228  CA  ARG A 177       8.243  24.460  -3.914  1.00 30.90           C  
ATOM   1229  C   ARG A 177       9.726  24.242  -4.177  1.00 29.51           C  
ATOM   1230  O   ARG A 177      10.393  23.490  -3.451  1.00 29.66           O  
ATOM   1231  CB  ARG A 177       8.056  25.324  -2.679  1.00 30.95           C  
ATOM   1232  CG  ARG A 177       6.610  25.704  -2.380  1.00 32.28           C  
ATOM   1233  CD  ARG A 177       6.057  26.608  -3.441  1.00 32.94           C  
ATOM   1234  NE  ARG A 177       4.850  27.316  -3.021  1.00 33.13           N  
ATOM   1235  CZ  ARG A 177       3.598  26.858  -3.081  1.00 34.46           C  
ATOM   1236  NH1 ARG A 177       3.321  25.613  -3.478  1.00 34.62           N  
ATOM   1237  NH2 ARG A 177       2.609  27.657  -2.686  1.00 34.29           N  
ATOM   1238  N   LYS A 178      10.226  24.895  -5.221  1.00 30.48           N  
ATOM   1239  CA  LYS A 178      11.638  24.815  -5.630  1.00 31.83           C  
ATOM   1240  C   LYS A 178      12.412  26.070  -5.243  1.00 28.91           C  
ATOM   1241  O   LYS A 178      13.525  26.279  -5.697  1.00 26.81           O  
ATOM   1242  CB  LYS A 178      11.712  24.557  -7.132  1.00 32.49           C  
ATOM   1243  CG  LYS A 178      11.074  23.232  -7.525  1.00 36.67           C  
ATOM   1244  CD  LYS A 178      11.363  22.867  -8.958  1.00 39.17           C  
ATOM   1245  CE  LYS A 178      10.792  21.493  -9.314  1.00 47.36           C  
ATOM   1246  NZ  LYS A 178      11.168  21.115 -10.713  1.00 49.94           N  
ATOM   1247  N   THR A 179      11.872  26.855  -4.311  1.00 28.42           N  
ATOM   1248  CA  THR A 179      12.482  28.125  -3.917  1.00 28.65           C  
ATOM   1249  C   THR A 179      13.816  27.995  -3.162  1.00 29.95           C  
ATOM   1250  O   THR A 179      14.578  28.966  -3.114  1.00 30.79           O  
ATOM   1251  CB  THR A 179      11.453  28.978  -3.157  1.00 32.26           C  
ATOM   1252  OG1 THR A 179      10.864  28.167  -2.150  1.00 30.29           O  
ATOM   1253  CG2 THR A 179      10.345  29.448  -4.105  1.00 34.11           C  
ATOM   1254  N   ASP A 180      14.105  26.811  -2.598  1.00 28.08           N  
ATOM   1255  CA  ASP A 180      15.395  26.497  -1.960  1.00 27.03           C  
ATOM   1256  C   ASP A 180      16.203  25.486  -2.784  1.00 25.85           C  
ATOM   1257  O   ASP A 180      17.240  25.002  -2.316  1.00 27.87           O  
ATOM   1258  CB  ASP A 180      15.192  25.950  -0.549  1.00 27.82           C  
ATOM   1259  CG  ASP A 180      14.794  27.016   0.453  1.00 31.78           C  
ATOM   1260  OD1 ASP A 180      15.058  28.223   0.229  1.00 39.35           O  
ATOM   1261  OD2 ASP A 180      14.228  26.636   1.498  1.00 34.86           O  
ATOM   1262  N   TRP A 181      15.768  25.196  -4.013  1.00 26.30           N  
ATOM   1263  CA  TRP A 181      16.467  24.223  -4.860  1.00 26.37           C  
ATOM   1264  C   TRP A 181      17.874  24.681  -5.220  1.00 26.69           C  
ATOM   1265  O   TRP A 181      18.808  23.930  -5.023  1.00 24.46           O  
ATOM   1266  CB  TRP A 181      15.663  23.882  -6.120  1.00 26.19           C  
ATOM   1267  CG  TRP A 181      16.405  22.992  -7.053  1.00 27.23           C  
ATOM   1268  CD1 TRP A 181      16.956  23.352  -8.251  1.00 27.53           C  
ATOM   1269  CD2 TRP A 181      16.766  21.622  -6.842  1.00 29.26           C  
ATOM   1270  NE1 TRP A 181      17.597  22.282  -8.818  1.00 30.45           N  
ATOM   1271  CE2 TRP A 181      17.505  21.208  -7.979  1.00 30.21           C  
ATOM   1272  CE3 TRP A 181      16.519  20.697  -5.820  1.00 30.60           C  
ATOM   1273  CZ2 TRP A 181      18.019  19.900  -8.120  1.00 30.12           C  
ATOM   1274  CZ3 TRP A 181      17.027  19.383  -5.960  1.00 31.44           C  
ATOM   1275  CH2 TRP A 181      17.769  19.009  -7.103  1.00 31.00           C  
ATOM   1276  N   LEU A 182      18.036  25.915  -5.707  1.00 27.58           N  
ATOM   1277  CA  LEU A 182      19.365  26.406  -6.063  1.00 27.08           C  
ATOM   1278  C   LEU A 182      20.289  26.490  -4.857  1.00 27.05           C  
ATOM   1279  O   LEU A 182      21.350  25.912  -4.894  1.00 28.91           O  
ATOM   1280  CB  LEU A 182      19.319  27.763  -6.781  1.00 27.80           C  
ATOM   1281  CG  LEU A 182      18.608  27.843  -8.134  1.00 27.10           C  
ATOM   1282  CD1 LEU A 182      18.802  29.248  -8.690  1.00 26.17           C  
ATOM   1283  CD2 LEU A 182      19.116  26.811  -9.118  1.00 28.86           C  
ATOM   1284  N   ALA A 183      19.854  27.144  -3.785  1.00 28.97           N  
ATOM   1285  CA  ALA A 183      20.710  27.351  -2.604  1.00 32.39           C  
ATOM   1286  C   ALA A 183      21.036  26.093  -1.805  1.00 31.25           C  
ATOM   1287  O   ALA A 183      22.190  25.896  -1.417  1.00 32.66           O  
ATOM   1288  CB  ALA A 183      20.087  28.404  -1.664  1.00 33.73           C  
ATOM   1289  N   LYS A 184      20.026  25.247  -1.604  1.00 31.73           N  
ATOM   1290  CA  LYS A 184      20.116  24.060  -0.724  1.00 31.94           C  
ATOM   1291  C   LYS A 184      20.017  22.677  -1.408  1.00 31.10           C  
ATOM   1292  O   LYS A 184      20.346  21.677  -0.780  1.00 32.41           O  
ATOM   1293  CB  LYS A 184      19.052  24.188   0.386  1.00 34.23           C  
ATOM   1294  CG  LYS A 184      19.161  25.502   1.185  1.00 37.56           C  
ATOM   1295  CD  LYS A 184      18.096  25.621   2.256  1.00 40.76           C  
ATOM   1296  CE  LYS A 184      18.273  26.903   3.060  1.00 46.65           C  
ATOM   1297  N   GLY A 185      19.586  22.610  -2.672  1.00 27.22           N  
ATOM   1298  CA  GLY A 185      19.414  21.337  -3.380  1.00 28.91           C  
ATOM   1299  C   GLY A 185      18.260  20.491  -2.865  1.00 30.97           C  
ATOM   1300  O   GLY A 185      18.315  19.266  -2.966  1.00 34.41           O  
ATOM   1301  N   VAL A 186      17.221  21.146  -2.350  1.00 30.67           N  
ATOM   1302  CA  VAL A 186      16.039  20.495  -1.757  1.00 31.31           C  
ATOM   1303  C   VAL A 186      14.742  21.046  -2.352  1.00 30.85           C  
ATOM   1304  O   VAL A 186      14.681  22.227  -2.748  1.00 29.25           O  
ATOM   1305  CB  VAL A 186      15.990  20.682  -0.200  1.00 29.87           C  
ATOM   1306  CG1 VAL A 186      17.245  20.074   0.444  1.00 37.65           C  
ATOM   1307  CG2 VAL A 186      15.800  22.171   0.202  1.00 32.58           C  
ATOM   1308  N   VAL A 187      13.747  20.159  -2.462  1.00 32.88           N  
ATOM   1309  CA  VAL A 187      12.373  20.498  -2.857  1.00 31.24           C  
ATOM   1310  C   VAL A 187      11.581  20.300  -1.570  1.00 30.73           C  
ATOM   1311  O   VAL A 187      11.685  19.251  -0.945  1.00 32.00           O  
ATOM   1312  CB  VAL A 187      11.812  19.555  -3.941  1.00 32.38           C  
ATOM   1313  CG1 VAL A 187      10.342  19.853  -4.217  1.00 31.03           C  
ATOM   1314  CG2 VAL A 187      12.627  19.665  -5.242  1.00 31.50           C  
ATOM   1315  N   LYS A 188      10.839  21.323  -1.176  1.00 29.73           N  
ATOM   1316  CA  LYS A 188       9.985  21.272   0.015  1.00 32.33           C  
ATOM   1317  C   LYS A 188       8.551  21.188  -0.431  1.00 30.84           C  
ATOM   1318  O   LYS A 188       8.232  21.512  -1.578  1.00 31.86           O  
ATOM   1319  CB  LYS A 188      10.237  22.446   0.940  1.00 34.65           C  
ATOM   1320  CG  LYS A 188      10.070  23.845   0.364  1.00 35.80           C  
ATOM   1321  CD  LYS A 188      10.639  24.833   1.371  1.00 38.23           C  
ATOM   1322  CE  LYS A 188      10.753  26.200   0.838  1.00 34.71           C  
ATOM   1323  NZ  LYS A 188      11.493  27.057   1.849  1.00 31.12           N  
ATOM   1324  N   HIS A 189       7.691  20.742   0.474  1.00 31.15           N  
ATOM   1325  CA  HIS A 189       6.281  20.504   0.184  1.00 29.90           C  
ATOM   1326  C   HIS A 189       5.431  21.423   0.996  1.00 29.19           C  
ATOM   1327  O   HIS A 189       5.347  21.312   2.217  1.00 28.96           O  
ATOM   1328  CB  HIS A 189       5.974  19.034   0.435  1.00 29.25           C  
ATOM   1329  CG  HIS A 189       6.753  18.155  -0.483  1.00 27.37           C  
ATOM   1330  ND1 HIS A 189       6.350  17.885  -1.772  1.00 33.73           N  
ATOM   1331  CD2 HIS A 189       7.992  17.631  -0.358  1.00 28.87           C  
ATOM   1332  CE1 HIS A 189       7.269  17.151  -2.368  1.00 32.89           C  
ATOM   1333  NE2 HIS A 189       8.275  16.980  -1.531  1.00 33.47           N  
ATOM   1334  N   HIS A 190       4.815  22.366   0.281  1.00 28.55           N  
ATOM   1335  CA  HIS A 190       3.970  23.353   0.883  1.00 28.10           C  
ATOM   1336  C   HIS A 190       2.623  22.742   1.193  1.00 27.89           C  
ATOM   1337  O   HIS A 190       1.936  22.238   0.296  1.00 29.52           O  
ATOM   1338  CB  HIS A 190       3.791  24.569  -0.018  1.00 28.72           C  
ATOM   1339  CG  HIS A 190       2.842  25.570   0.543  1.00 27.01           C  
ATOM   1340  ND1 HIS A 190       3.099  26.287   1.697  1.00 27.52           N  
ATOM   1341  CD2 HIS A 190       1.621  25.960   0.120  1.00 27.63           C  
ATOM   1342  CE1 HIS A 190       2.069  27.077   1.945  1.00 28.15           C  
ATOM   1343  NE2 HIS A 190       1.159  26.895   1.010  1.00 26.47           N  
ATOM   1344  N   ARG A 191       2.278  22.762   2.482  1.00 28.63           N  
ATOM   1345  CA  ARG A 191       0.997  22.275   2.983  1.00 28.23           C  
ATOM   1346  C   ARG A 191       0.570  23.284   4.025  1.00 27.67           C  
ATOM   1347  O   ARG A 191       1.395  23.689   4.858  1.00 28.36           O  
ATOM   1348  CB  ARG A 191       1.132  20.897   3.633  1.00 28.72           C  
ATOM   1349  CG  ARG A 191       1.318  19.752   2.640  1.00 29.65           C  
ATOM   1350  CD  ARG A 191       1.539  18.415   3.341  1.00 30.47           C  
ATOM   1351  NE  ARG A 191       2.909  18.252   3.856  1.00 31.08           N  
ATOM   1352  CZ  ARG A 191       3.896  17.524   3.303  1.00 27.17           C  
ATOM   1353  NH1 ARG A 191       3.717  16.794   2.202  1.00 28.64           N  
ATOM   1354  NH2 ARG A 191       5.076  17.480   3.927  1.00 28.47           N  
ATOM   1355  N   THR A 192      -0.716  23.638   4.020  1.00 27.37           N  
ATOM   1356  CA  THR A 192      -1.241  24.609   4.986  1.00 27.67           C  
ATOM   1357  C   THR A 192      -1.258  23.977   6.393  1.00 27.18           C  
ATOM   1358  O   THR A 192      -1.152  22.753   6.536  1.00 27.86           O  
ATOM   1359  CB  THR A 192      -2.672  25.053   4.593  1.00 29.95           C  
ATOM   1360  OG1 THR A 192      -3.570  23.944   4.727  1.00 30.78           O  
ATOM   1361  CG2 THR A 192      -2.732  25.629   3.146  1.00 28.48           C  
ATOM   1362  N   VAL A 193      -1.393  24.809   7.427  1.00 28.05           N  
ATOM   1363  CA  VAL A 193      -1.490  24.311   8.816  1.00 28.25           C  
ATOM   1364  C   VAL A 193      -2.673  23.328   8.921  1.00 28.00           C  
ATOM   1365  O   VAL A 193      -2.544  22.252   9.495  1.00 27.98           O  
ATOM   1366  CB  VAL A 193      -1.662  25.453   9.862  1.00 28.75           C  
ATOM   1367  CG1 VAL A 193      -1.761  24.884  11.292  1.00 30.02           C  
ATOM   1368  CG2 VAL A 193      -0.514  26.478   9.781  1.00 28.59           C  
ATOM   1369  N   GLY A 194      -3.827  23.695   8.363  1.00 29.05           N  
ATOM   1370  CA  GLY A 194      -5.004  22.808   8.389  1.00 28.33           C  
ATOM   1371  C   GLY A 194      -4.746  21.460   7.748  1.00 28.19           C  
ATOM   1372  O   GLY A 194      -5.115  20.436   8.304  1.00 28.58           O  
ATOM   1373  N   THR A 195      -4.090  21.461   6.593  1.00 27.11           N  
ATOM   1374  CA  THR A 195      -3.767  20.202   5.907  1.00 25.23           C  
ATOM   1375  C   THR A 195      -2.907  19.300   6.797  1.00 26.39           C  
ATOM   1376  O   THR A 195      -3.168  18.120   6.933  1.00 27.28           O  
ATOM   1377  CB  THR A 195      -3.073  20.476   4.579  1.00 27.73           C  
ATOM   1378  OG1 THR A 195      -4.009  21.113   3.690  1.00 30.43           O  
ATOM   1379  CG2 THR A 195      -2.542  19.173   3.938  1.00 28.96           C  
ATOM   1380  N   THR A 196      -1.869  19.864   7.401  1.00 26.59           N  
ATOM   1381  CA  THR A 196      -0.992  19.104   8.293  1.00 26.62           C  
ATOM   1382  C   THR A 196      -1.744  18.528   9.477  1.00 26.57           C  
ATOM   1383  O   THR A 196      -1.598  17.356   9.807  1.00 27.03           O  
ATOM   1384  CB  THR A 196       0.163  20.005   8.782  1.00 28.44           C  
ATOM   1385  OG1 THR A 196       0.936  20.384   7.646  1.00 28.87           O  
ATOM   1386  CG2 THR A 196       1.059  19.343   9.855  1.00 27.43           C  
ATOM   1387  N   LEU A 197      -2.543  19.369  10.130  1.00 26.74           N  
ATOM   1388  CA  LEU A 197      -3.294  18.927  11.305  1.00 25.23           C  
ATOM   1389  C   LEU A 197      -4.369  17.905  10.964  1.00 24.24           C  
ATOM   1390  O   LEU A 197      -4.536  16.902  11.673  1.00 24.92           O  
ATOM   1391  CB  LEU A 197      -3.895  20.111  12.050  1.00 26.25           C  
ATOM   1392  CG  LEU A 197      -2.884  21.143  12.582  1.00 26.74           C  
ATOM   1393  CD1 LEU A 197      -3.642  22.289  13.265  1.00 27.86           C  
ATOM   1394  CD2 LEU A 197      -1.838  20.549  13.493  1.00 28.99           C  
ATOM   1395  N   ASN A 198      -5.088  18.139   9.870  1.00 26.87           N  
ATOM   1396  CA  ASN A 198      -6.120  17.187   9.429  1.00 26.12           C  
ATOM   1397  C   ASN A 198      -5.526  15.819   9.086  1.00 25.89           C  
ATOM   1398  O   ASN A 198      -6.109  14.793   9.402  1.00 26.25           O  
ATOM   1399  CB  ASN A 198      -6.869  17.739   8.230  1.00 26.25           C  
ATOM   1400  CG  ASN A 198      -7.732  18.937   8.568  1.00 28.91           C  
ATOM   1401  OD1 ASN A 198      -8.052  19.189   9.737  1.00 27.46           O  
ATOM   1402  ND2 ASN A 198      -8.154  19.658   7.533  1.00 29.27           N  
ATOM   1403  N   ALA A 199      -4.334  15.825   8.488  1.00 26.10           N  
ATOM   1404  CA  ALA A 199      -3.612  14.588   8.164  1.00 26.88           C  
ATOM   1405  C   ALA A 199      -3.206  13.825   9.430  1.00 25.84           C  
ATOM   1406  O   ALA A 199      -3.338  12.598   9.488  1.00 27.30           O  
ATOM   1407  CB  ALA A 199      -2.414  14.885   7.294  1.00 26.00           C  
ATOM   1408  N   LEU A 200      -2.756  14.546  10.459  1.00 25.86           N  
ATOM   1409  CA  LEU A 200      -2.483  13.918  11.757  1.00 25.78           C  
ATOM   1410  C   LEU A 200      -3.729  13.283  12.350  1.00 26.13           C  
ATOM   1411  O   LEU A 200      -3.697  12.148  12.797  1.00 26.64           O  
ATOM   1412  CB  LEU A 200      -1.914  14.933  12.745  1.00 27.49           C  
ATOM   1413  CG  LEU A 200      -0.460  15.368  12.536  1.00 27.27           C  
ATOM   1414  CD1 LEU A 200      -0.130  16.615  13.375  1.00 26.42           C  
ATOM   1415  CD2 LEU A 200       0.465  14.222  12.902  1.00 26.56           C  
ATOM   1416  N   ILE A 201      -4.829  14.028  12.321  1.00 25.83           N  
ATOM   1417  CA  ILE A 201      -6.108  13.559  12.892  1.00 25.84           C  
ATOM   1418  C   ILE A 201      -6.611  12.311  12.146  1.00 26.22           C  
ATOM   1419  O   ILE A 201      -6.941  11.299  12.774  1.00 27.13           O  
ATOM   1420  CB  ILE A 201      -7.160  14.711  12.889  1.00 26.20           C  
ATOM   1421  CG1 ILE A 201      -6.757  15.817  13.868  1.00 26.32           C  
ATOM   1422  CG2 ILE A 201      -8.574  14.202  13.286  1.00 28.53           C  
ATOM   1423  CD1 ILE A 201      -7.529  17.117  13.641  1.00 24.80           C  
ATOM   1424  N   ARG A 202      -6.611  12.367  10.810  1.00 28.59           N  
ATOM   1425  CA  ARG A 202      -7.035  11.227   9.968  1.00 28.12           C  
ATOM   1426  C   ARG A 202      -6.143   9.985  10.197  1.00 27.15           C  
ATOM   1427  O   ARG A 202      -6.611   8.845  10.097  1.00 26.97           O  
ATOM   1428  CB  ARG A 202      -7.008  11.640   8.488  1.00 29.35           C  
ATOM   1429  CG  ARG A 202      -7.664  10.718   7.500  1.00 34.93           C  
ATOM   1430  CD  ARG A 202      -7.627  11.299   6.071  1.00 41.26           C  
ATOM   1431  NE  ARG A 202      -8.234  12.642   5.997  1.00 50.55           N  
ATOM   1432  CZ  ARG A 202      -7.608  13.831   5.900  1.00 54.48           C  
ATOM   1433  NH1 ARG A 202      -6.272  13.957   5.786  1.00 38.44           N  
ATOM   1434  NH2 ARG A 202      -8.359  14.944   5.875  1.00 55.46           N  
ATOM   1435  N   SER A 203      -4.872  10.231  10.506  1.00 26.68           N  
ATOM   1436  CA  SER A 203      -3.884   9.188  10.809  1.00 27.58           C  
ATOM   1437  C   SER A 203      -4.022   8.564  12.215  1.00 31.48           C  
ATOM   1438  O   SER A 203      -3.320   7.599  12.516  1.00 33.47           O  
ATOM   1439  CB  SER A 203      -2.459   9.726  10.578  1.00 27.19           C  
ATOM   1440  OG  SER A 203      -2.268  10.071   9.210  1.00 30.05           O  
ATOM   1441  N   GLY A 204      -4.893   9.105  13.067  1.00 28.87           N  
ATOM   1442  CA  GLY A 204      -5.161   8.575  14.411  1.00 30.06           C  
ATOM   1443  C   GLY A 204      -4.662   9.374  15.600  1.00 29.98           C  
ATOM   1444  O   GLY A 204      -4.872   8.953  16.744  1.00 30.38           O  
ATOM   1445  N   PHE A 205      -4.062  10.538  15.347  1.00 27.38           N  
ATOM   1446  CA  PHE A 205      -3.502  11.383  16.403  1.00 27.61           C  
ATOM   1447  C   PHE A 205      -4.522  12.383  16.917  1.00 28.86           C  
ATOM   1448  O   PHE A 205      -5.416  12.815  16.184  1.00 30.57           O  
ATOM   1449  CB  PHE A 205      -2.283  12.188  15.900  1.00 28.85           C  
ATOM   1450  CG  PHE A 205      -1.053  11.364  15.645  1.00 27.77           C  
ATOM   1451  CD1 PHE A 205      -0.199  11.033  16.698  1.00 27.24           C  
ATOM   1452  CD2 PHE A 205      -0.717  10.955  14.356  1.00 28.83           C  
ATOM   1453  CE1 PHE A 205       0.964  10.291  16.482  1.00 27.28           C  
ATOM   1454  CE2 PHE A 205       0.472  10.228  14.117  1.00 28.24           C  
ATOM   1455  CZ  PHE A 205       1.308   9.887  15.193  1.00 26.94           C  
ATOM   1456  N   ALA A 206      -4.360  12.744  18.185  1.00 27.60           N  
ATOM   1457  CA  ALA A 206      -5.088  13.844  18.785  1.00 26.59           C  
ATOM   1458  C   ALA A 206      -4.093  14.997  18.773  1.00 26.93           C  
ATOM   1459  O   ALA A 206      -2.942  14.801  19.146  1.00 30.89           O  
ATOM   1460  CB  ALA A 206      -5.473  13.517  20.177  1.00 29.06           C  
ATOM   1461  N   ILE A 207      -4.508  16.189  18.345  1.00 25.82           N  
ATOM   1462  CA  ILE A 207      -3.622  17.375  18.393  1.00 26.52           C  
ATOM   1463  C   ILE A 207      -3.512  17.805  19.862  1.00 27.24           C  
ATOM   1464  O   ILE A 207      -4.527  17.986  20.554  1.00 27.25           O  
ATOM   1465  CB  ILE A 207      -4.161  18.578  17.566  1.00 27.28           C  
ATOM   1466  CG1 ILE A 207      -4.503  18.157  16.127  1.00 29.09           C  
ATOM   1467  CG2 ILE A 207      -3.192  19.779  17.620  1.00 26.52           C  
ATOM   1468  CD1 ILE A 207      -3.357  17.421  15.384  1.00 28.95           C  
ATOM   1469  N   GLU A 208      -2.283  17.949  20.341  1.00 27.90           N  
ATOM   1470  CA  GLU A 208      -1.999  18.353  21.716  1.00 29.82           C  
ATOM   1471  C   GLU A 208      -1.572  19.819  21.839  1.00 29.64           C  
ATOM   1472  O   GLU A 208      -1.976  20.506  22.776  1.00 28.17           O  
ATOM   1473  CB  GLU A 208      -0.945  17.422  22.320  1.00 30.64           C  
ATOM   1474  CG  GLU A 208      -0.592  17.724  23.772  1.00 36.43           C  
ATOM   1475  CD  GLU A 208       0.213  16.623  24.430  1.00 43.04           C  
ATOM   1476  OE1 GLU A 208      -0.298  15.489  24.500  1.00 51.61           O  
ATOM   1477  OE2 GLU A 208       1.334  16.904  24.921  1.00 62.26           O  
ATOM   1478  N   HIS A 209      -0.740  20.290  20.920  1.00 27.63           N  
ATOM   1479  CA  HIS A 209      -0.228  21.666  20.991  1.00 28.74           C  
ATOM   1480  C   HIS A 209       0.258  22.086  19.612  1.00 28.31           C  
ATOM   1481  O   HIS A 209       0.865  21.297  18.897  1.00 28.03           O  
ATOM   1482  CB  HIS A 209       0.926  21.744  22.009  1.00 28.52           C  
ATOM   1483  CG  HIS A 209       1.401  23.133  22.313  1.00 30.45           C  
ATOM   1484  ND1 HIS A 209       0.878  23.895  23.336  1.00 32.02           N  
ATOM   1485  CD2 HIS A 209       2.383  23.876  21.752  1.00 29.63           C  
ATOM   1486  CE1 HIS A 209       1.501  25.062  23.368  1.00 35.02           C  
ATOM   1487  NE2 HIS A 209       2.422  25.073  22.420  1.00 31.49           N  
ATOM   1488  N   VAL A 210      -0.062  23.315  19.227  1.00 28.84           N  
ATOM   1489  CA  VAL A 210       0.340  23.880  17.946  1.00 27.88           C  
ATOM   1490  C   VAL A 210       0.950  25.260  18.220  1.00 29.83           C  
ATOM   1491  O   VAL A 210       0.315  26.100  18.847  1.00 28.89           O  
ATOM   1492  CB  VAL A 210      -0.858  24.010  16.985  1.00 28.62           C  
ATOM   1493  CG1 VAL A 210      -0.419  24.621  15.636  1.00 28.89           C  
ATOM   1494  CG2 VAL A 210      -1.524  22.663  16.756  1.00 32.69           C  
ATOM   1495  N   GLU A 211       2.159  25.489  17.733  1.00 28.87           N  
ATOM   1496  CA  GLU A 211       2.828  26.754  17.979  1.00 30.51           C  
ATOM   1497  C   GLU A 211       3.488  27.255  16.715  1.00 29.71           C  
ATOM   1498  O   GLU A 211       4.236  26.529  16.051  1.00 29.51           O  
ATOM   1499  CB  GLU A 211       3.812  26.543  19.108  1.00 33.21           C  
ATOM   1500  CG  GLU A 211       4.407  27.770  19.689  1.00 38.16           C  
ATOM   1501  CD  GLU A 211       5.078  27.504  21.033  1.00 36.34           C  
ATOM   1502  OE1 GLU A 211       4.505  26.795  21.907  1.00 40.56           O  
ATOM   1503  OE2 GLU A 211       6.168  28.049  21.243  1.00 47.20           O  
ATOM   1504  N   GLU A 212       3.148  28.495  16.358  1.00 27.88           N  
ATOM   1505  CA  GLU A 212       3.770  29.185  15.224  1.00 28.05           C  
ATOM   1506  C   GLU A 212       4.838  29.955  15.959  1.00 30.09           C  
ATOM   1507  O   GLU A 212       4.545  30.926  16.670  1.00 31.11           O  
ATOM   1508  CB  GLU A 212       2.741  30.022  14.480  1.00 29.90           C  
ATOM   1509  CG  GLU A 212       1.566  29.156  14.060  1.00 29.27           C  
ATOM   1510  CD  GLU A 212       0.428  29.936  13.498  1.00 30.44           C  
ATOM   1511  OE1 GLU A 212       0.513  30.353  12.335  1.00 31.25           O  
ATOM   1512  OE2 GLU A 212      -0.578  30.093  14.202  1.00 30.39           O  
ATOM   1513  N   PHE A 213       6.081  29.488  15.801  1.00 31.78           N  
ATOM   1514  CA  PHE A 213       7.184  29.925  16.638  1.00 33.33           C  
ATOM   1515  C   PHE A 213       7.360  31.427  16.653  1.00 33.39           C  
ATOM   1516  O   PHE A 213       7.259  32.072  15.621  1.00 35.03           O  
ATOM   1517  CB  PHE A 213       8.502  29.186  16.330  1.00 35.69           C  
ATOM   1518  CG  PHE A 213       9.713  29.816  16.990  1.00 33.47           C  
ATOM   1519  CD1 PHE A 213       9.849  29.756  18.365  1.00 42.03           C  
ATOM   1520  CD2 PHE A 213      10.668  30.498  16.245  1.00 45.09           C  
ATOM   1521  CE1 PHE A 213      10.942  30.360  19.006  1.00 42.06           C  
ATOM   1522  CE2 PHE A 213      11.775  31.101  16.881  1.00 43.91           C  
ATOM   1523  CZ  PHE A 213      11.898  31.027  18.259  1.00 43.12           C  
ATOM   1524  N   CYS A 214       7.544  31.953  17.862  1.00 34.25           N  
ATOM   1525  CA  CYS A 214       7.835  33.352  18.097  1.00 32.96           C  
ATOM   1526  C   CYS A 214       8.932  33.425  19.150  1.00 34.24           C  
ATOM   1527  O   CYS A 214       8.753  32.901  20.271  1.00 32.87           O  
ATOM   1528  CB  CYS A 214       6.600  34.085  18.601  1.00 34.88           C  
ATOM   1529  SG  CYS A 214       6.916  35.843  18.866  1.00 37.75           S  
ATOM   1530  N   PRO A 215      10.062  34.089  18.824  1.00 33.84           N  
ATOM   1531  CA  PRO A 215      11.096  34.212  19.839  1.00 33.29           C  
ATOM   1532  C   PRO A 215      10.616  35.105  20.995  1.00 33.60           C  
ATOM   1533  O   PRO A 215       9.788  36.013  20.792  1.00 34.62           O  
ATOM   1534  CB  PRO A 215      12.245  34.865  19.077  1.00 33.56           C  
ATOM   1535  CG  PRO A 215      11.598  35.640  18.050  1.00 34.71           C  
ATOM   1536  CD  PRO A 215      10.444  34.807  17.592  1.00 35.50           C  
ATOM   1537  N   THR A 216      11.115  34.839  22.196  1.00 33.25           N  
ATOM   1538  CA  THR A 216      10.737  35.638  23.356  1.00 32.14           C  
ATOM   1539  C   THR A 216      11.522  36.958  23.306  1.00 33.68           C  
ATOM   1540  O   THR A 216      12.539  37.060  22.594  1.00 34.93           O  
ATOM   1541  CB  THR A 216      11.068  34.927  24.685  1.00 33.08           C  
ATOM   1542  OG1 THR A 216      12.482  34.785  24.823  1.00 34.49           O  
ATOM   1543  CG2 THR A 216      10.409  33.556  24.750  1.00 31.83           C  
ATOM   1544  N   ASP A 217      11.047  37.963  24.048  1.00 36.59           N  
ATOM   1545  CA  ASP A 217      11.767  39.236  24.165  1.00 36.20           C  
ATOM   1546  C   ASP A 217      13.193  39.009  24.686  1.00 36.02           C  
ATOM   1547  O   ASP A 217      14.129  39.632  24.186  1.00 35.92           O  
ATOM   1548  CB  ASP A 217      11.011  40.240  25.055  1.00 38.33           C  
ATOM   1549  CG  ASP A 217       9.731  40.788  24.405  1.00 44.49           C  
ATOM   1550  OD1 ASP A 217       9.436  40.498  23.218  1.00 46.92           O  
ATOM   1551  OD2 ASP A 217       9.012  41.545  25.097  1.00 52.40           O  
ATOM   1552  N   ALA A 218      13.354  38.093  25.655  1.00 35.14           N  
ATOM   1553  CA  ALA A 218      14.681  37.725  26.182  1.00 33.16           C  
ATOM   1554  C   ALA A 218      15.602  37.134  25.103  1.00 32.53           C  
ATOM   1555  O   ALA A 218      16.791  37.419  25.092  1.00 33.07           O  
ATOM   1556  CB  ALA A 218      14.561  36.772  27.363  1.00 31.77           C  
ATOM   1557  N   GLN A 219      15.051  36.310  24.212  1.00 31.66           N  
ATOM   1558  CA  GLN A 219      15.824  35.752  23.076  1.00 32.77           C  
ATOM   1559  C   GLN A 219      16.275  36.856  22.110  1.00 33.52           C  
ATOM   1560  O   GLN A 219      17.397  36.813  21.597  1.00 34.55           O  
ATOM   1561  CB  GLN A 219      15.044  34.692  22.302  1.00 32.33           C  
ATOM   1562  CG  GLN A 219      14.962  33.367  23.010  1.00 33.95           C  
ATOM   1563  CD  GLN A 219      14.196  32.359  22.202  1.00 33.79           C  
ATOM   1564  OE1 GLN A 219      12.996  32.538  21.935  1.00 32.04           O  
ATOM   1565  NE2 GLN A 219      14.875  31.286  21.796  1.00 36.56           N  
ATOM   1566  N   ILE A 220      15.376  37.809  21.858  1.00 34.14           N  
ATOM   1567  CA  ILE A 220      15.651  38.952  20.972  1.00 35.53           C  
ATOM   1568  C   ILE A 220      16.734  39.857  21.579  1.00 36.22           C  
ATOM   1569  O   ILE A 220      17.556  40.394  20.842  1.00 37.00           O  
ATOM   1570  CB  ILE A 220      14.356  39.746  20.640  1.00 35.17           C  
ATOM   1571  CG1 ILE A 220      13.397  38.867  19.818  1.00 35.41           C  
ATOM   1572  CG2 ILE A 220      14.674  41.031  19.839  1.00 33.85           C  
ATOM   1573  CD1 ILE A 220      11.976  39.393  19.686  1.00 37.11           C  
ATOM   1574  N   THR A 221      16.742  40.023  22.903  1.00 37.23           N  
ATOM   1575  CA  THR A 221      17.778  40.821  23.579  1.00 37.00           C  
ATOM   1576  C   THR A 221      19.152  40.148  23.439  1.00 37.22           C  
ATOM   1577  O   THR A 221      20.154  40.829  23.189  1.00 36.59           O  
ATOM   1578  CB  THR A 221      17.418  41.074  25.060  1.00 37.06           C  
ATOM   1579  OG1 THR A 221      16.161  41.758  25.111  1.00 36.29           O  
ATOM   1580  CG2 THR A 221      18.487  41.917  25.767  1.00 38.39           C  
ATOM   1581  N   ALA A 222      19.181  38.823  23.587  1.00 38.01           N  
ATOM   1582  CA  ALA A 222      20.398  38.017  23.425  1.00 38.73           C  
ATOM   1583  C   ALA A 222      20.866  37.933  21.963  1.00 40.64           C  
ATOM   1584  O   ALA A 222      22.071  37.942  21.697  1.00 41.78           O  
ATOM   1585  CB  ALA A 222      20.189  36.608  23.996  1.00 37.35           C  
ATOM   1586  N   ARG A 223      19.902  37.832  21.037  1.00 40.71           N  
ATOM   1587  CA  ARG A 223      20.142  37.720  19.600  1.00 40.69           C  
ATOM   1588  C   ARG A 223      19.243  38.727  18.860  1.00 39.47           C  
ATOM   1589  O   ARG A 223      18.135  38.375  18.447  1.00 36.92           O  
ATOM   1590  CB  ARG A 223      19.836  36.302  19.142  1.00 41.10           C  
ATOM   1591  CG  ARG A 223      20.794  35.240  19.692  1.00 47.14           C  
ATOM   1592  CD  ARG A 223      20.434  33.862  19.139  1.00 47.49           C  
ATOM   1593  NE  ARG A 223      20.486  33.860  17.675  1.00 53.61           N  
ATOM   1594  CZ  ARG A 223      20.032  32.890  16.879  1.00 58.23           C  
ATOM   1595  NH1 ARG A 223      19.496  31.766  17.377  1.00 59.39           N  
ATOM   1596  NH2 ARG A 223      20.130  33.048  15.555  1.00 54.88           N  
ATOM   1597  N   PRO A 224      19.690  39.997  18.731  1.00 36.73           N  
ATOM   1598  CA  PRO A 224      18.940  41.068  18.036  1.00 36.55           C  
ATOM   1599  C   PRO A 224      18.351  40.720  16.663  1.00 34.22           C  
ATOM   1600  O   PRO A 224      17.276  41.223  16.312  1.00 34.27           O  
ATOM   1601  CB  PRO A 224      19.984  42.173  17.898  1.00 36.29           C  
ATOM   1602  CG  PRO A 224      20.847  41.981  19.088  1.00 36.73           C  
ATOM   1603  CD  PRO A 224      20.944  40.520  19.316  1.00 36.48           C  
ATOM   1604  N   GLU A 225      19.043  39.868  15.910  1.00 34.44           N  
ATOM   1605  CA  GLU A 225      18.573  39.437  14.581  1.00 35.23           C  
ATOM   1606  C   GLU A 225      17.227  38.701  14.602  1.00 35.66           C  
ATOM   1607  O   GLU A 225      16.554  38.643  13.575  1.00 37.52           O  
ATOM   1608  CB  GLU A 225      19.628  38.613  13.812  1.00 36.49           C  
ATOM   1609  CG  GLU A 225      19.980  37.211  14.344  1.00 38.17           C  
ATOM   1610  CD  GLU A 225      20.984  37.197  15.494  1.00 47.52           C  
ATOM   1611  OE1 GLU A 225      21.089  38.187  16.256  1.00 51.13           O  
ATOM   1612  OE2 GLU A 225      21.668  36.165  15.636  1.00 55.36           O  
ATOM   1613  N   LEU A 226      16.845  38.139  15.756  1.00 35.48           N  
ATOM   1614  CA  LEU A 226      15.540  37.491  15.906  1.00 34.29           C  
ATOM   1615  C   LEU A 226      14.341  38.464  15.924  1.00 34.01           C  
ATOM   1616  O   LEU A 226      13.207  38.004  15.795  1.00 33.09           O  
ATOM   1617  CB  LEU A 226      15.502  36.634  17.179  1.00 33.56           C  
ATOM   1618  CG  LEU A 226      16.492  35.466  17.259  1.00 32.05           C  
ATOM   1619  CD1 LEU A 226      16.396  34.825  18.640  1.00 31.27           C  
ATOM   1620  CD2 LEU A 226      16.236  34.449  16.155  1.00 36.70           C  
ATOM   1621  N   ALA A 227      14.569  39.773  16.110  1.00 34.10           N  
ATOM   1622  CA  ALA A 227      13.482  40.779  16.089  1.00 33.73           C  
ATOM   1623  C   ALA A 227      12.577  40.689  14.837  1.00 33.91           C  
ATOM   1624  O   ALA A 227      11.351  40.810  14.947  1.00 33.61           O  
ATOM   1625  CB  ALA A 227      14.050  42.213  16.251  1.00 36.90           C  
ATOM   1626  N   GLU A 228      13.173  40.431  13.667  1.00 32.88           N  
ATOM   1627  CA  GLU A 228      12.394  40.288  12.418  1.00 33.00           C  
ATOM   1628  C   GLU A 228      11.416  39.098  12.432  1.00 32.29           C  
ATOM   1629  O   GLU A 228      10.414  39.112  11.729  1.00 33.07           O  
ATOM   1630  CB  GLU A 228      13.313  40.231  11.182  1.00 32.29           C  
ATOM   1631  CG  GLU A 228      14.106  38.956  11.025  1.00 31.81           C  
ATOM   1632  CD  GLU A 228      15.039  38.991   9.835  1.00 35.87           C  
ATOM   1633  OE1 GLU A 228      15.745  40.003   9.631  1.00 36.79           O  
ATOM   1634  OE2 GLU A 228      15.080  37.985   9.112  1.00 34.59           O  
ATOM   1635  N   GLU A 229      11.681  38.102  13.274  1.00 32.95           N  
ATOM   1636  CA  GLU A 229      10.828  36.913  13.384  1.00 31.07           C  
ATOM   1637  C   GLU A 229       9.443  37.250  13.980  1.00 30.12           C  
ATOM   1638  O   GLU A 229       8.535  36.445  13.868  1.00 32.30           O  
ATOM   1639  CB  GLU A 229      11.524  35.795  14.183  1.00 31.53           C  
ATOM   1640  CG  GLU A 229      12.980  35.435  13.720  1.00 31.76           C  
ATOM   1641  CD  GLU A 229      13.065  34.953  12.282  1.00 37.35           C  
ATOM   1642  OE1 GLU A 229      12.043  34.495  11.747  1.00 31.87           O  
ATOM   1643  OE2 GLU A 229      14.171  34.993  11.695  1.00 35.05           O  
ATOM   1644  N   LEU A 230       9.289  38.437  14.597  1.00 30.08           N  
ATOM   1645  CA  LEU A 230       7.968  38.903  15.079  1.00 28.64           C  
ATOM   1646  C   LEU A 230       6.963  39.161  13.951  1.00 28.17           C  
ATOM   1647  O   LEU A 230       5.742  39.089  14.168  1.00 28.70           O  
ATOM   1648  CB  LEU A 230       8.093  40.164  15.933  1.00 29.58           C  
ATOM   1649  CG  LEU A 230       8.892  40.003  17.236  1.00 32.01           C  
ATOM   1650  CD1 LEU A 230       8.906  41.331  17.991  1.00 35.99           C  
ATOM   1651  CD2 LEU A 230       8.342  38.912  18.130  1.00 35.63           C  
ATOM   1652  N   ASP A 231       7.453  39.436  12.744  1.00 26.02           N  
ATOM   1653  CA  ASP A 231       6.588  39.768  11.612  1.00 25.73           C  
ATOM   1654  C   ASP A 231       5.977  38.585  10.895  1.00 27.01           C  
ATOM   1655  O   ASP A 231       4.848  38.683  10.428  1.00 27.60           O  
ATOM   1656  CB  ASP A 231       7.314  40.692  10.637  1.00 26.79           C  
ATOM   1657  CG  ASP A 231       7.476  42.081  11.198  1.00 29.92           C  
ATOM   1658  OD1 ASP A 231       6.505  42.627  11.771  1.00 27.07           O  
ATOM   1659  OD2 ASP A 231       8.558  42.640  11.030  1.00 34.22           O  
ATOM   1660  N   ARG A 232       6.718  37.488  10.798  1.00 28.13           N  
ATOM   1661  CA  ARG A 232       6.201  36.278  10.188  1.00 26.80           C  
ATOM   1662  C   ARG A 232       6.918  35.050  10.763  1.00 25.90           C  
ATOM   1663  O   ARG A 232       8.113  35.122  11.006  1.00 27.87           O  
ATOM   1664  CB  ARG A 232       6.341  36.336   8.658  1.00 26.52           C  
ATOM   1665  CG  ARG A 232       7.779  36.338   8.124  1.00 26.89           C  
ATOM   1666  CD  ARG A 232       8.228  34.947   7.686  1.00 27.91           C  
ATOM   1667  NE  ARG A 232       9.607  34.993   7.233  1.00 27.03           N  
ATOM   1668  CZ  ARG A 232      10.684  34.930   8.007  1.00 28.69           C  
ATOM   1669  NH1 ARG A 232      10.587  34.814   9.315  1.00 28.87           N  
ATOM   1670  NH2 ARG A 232      11.894  35.019   7.448  1.00 27.91           N  
ATOM   1671  N   PRO A 233       6.197  33.933  10.915  1.00 27.90           N  
ATOM   1672  CA  PRO A 233       6.813  32.738  11.466  1.00 28.09           C  
ATOM   1673  C   PRO A 233       7.602  31.946  10.429  1.00 29.93           C  
ATOM   1674  O   PRO A 233       7.117  31.736   9.311  1.00 30.16           O  
ATOM   1675  CB  PRO A 233       5.613  31.923  11.941  1.00 28.06           C  
ATOM   1676  CG  PRO A 233       4.526  32.276  11.024  1.00 28.30           C  
ATOM   1677  CD  PRO A 233       4.773  33.710  10.611  1.00 30.20           C  
HETATM 1678  N   MSE A 234       8.802  31.513  10.798  1.00 29.50           N  
HETATM 1679  CA  MSE A 234       9.582  30.620   9.962  1.00 28.76           C  
HETATM 1680  C   MSE A 234       9.158  29.167  10.186  1.00 28.58           C  
HETATM 1681  O   MSE A 234       9.252  28.356   9.252  1.00 26.99           O  
HETATM 1682  CB  MSE A 234      11.075  30.735  10.246  1.00 29.22           C  
HETATM 1683  CG  MSE A 234      11.929  29.973   9.278  1.00 31.30           C  
HETATM 1684 SE   MSE A 234      13.792  30.406   9.490  0.75 36.79          SE  
HETATM 1685  CE  MSE A 234      13.708  32.264   9.040  1.00 33.98           C  
ATOM   1686  N   PHE A 235       8.722  28.843  11.411  1.00 27.27           N  
ATOM   1687  CA  PHE A 235       8.446  27.455  11.790  1.00 27.57           C  
ATOM   1688  C   PHE A 235       7.092  27.197  12.392  1.00 27.42           C  
ATOM   1689  O   PHE A 235       6.522  28.051  13.066  1.00 27.90           O  
ATOM   1690  CB  PHE A 235       9.489  26.977  12.816  1.00 28.36           C  
ATOM   1691  CG  PHE A 235      10.908  27.194  12.395  1.00 28.23           C  
ATOM   1692  CD1 PHE A 235      11.382  26.551  11.261  1.00 28.84           C  
ATOM   1693  CD2 PHE A 235      11.770  27.995  13.139  1.00 34.12           C  
ATOM   1694  CE1 PHE A 235      12.711  26.723  10.847  1.00 32.82           C  
ATOM   1695  CE2 PHE A 235      13.096  28.171  12.734  1.00 30.59           C  
ATOM   1696  CZ  PHE A 235      13.554  27.534  11.579  1.00 29.11           C  
ATOM   1697  N   LEU A 236       6.592  25.996  12.115  1.00 27.34           N  
ATOM   1698  CA  LEU A 236       5.394  25.434  12.722  1.00 27.05           C  
ATOM   1699  C   LEU A 236       5.869  24.300  13.633  1.00 27.22           C  
ATOM   1700  O   LEU A 236       6.607  23.413  13.173  1.00 27.50           O  
ATOM   1701  CB  LEU A 236       4.436  24.878  11.666  1.00 26.47           C  
ATOM   1702  CG  LEU A 236       3.130  24.263  12.196  1.00 27.38           C  
ATOM   1703  CD1 LEU A 236       2.238  25.342  12.867  1.00 28.75           C  
ATOM   1704  CD2 LEU A 236       2.349  23.521  11.100  1.00 29.63           C  
ATOM   1705  N   LEU A 237       5.442  24.339  14.888  1.00 26.88           N  
ATOM   1706  CA  LEU A 237       5.777  23.328  15.893  1.00 26.53           C  
ATOM   1707  C   LEU A 237       4.480  22.609  16.262  1.00 27.45           C  
ATOM   1708  O   LEU A 237       3.476  23.265  16.597  1.00 27.95           O  
ATOM   1709  CB  LEU A 237       6.410  23.971  17.116  1.00 28.44           C  
ATOM   1710  CG  LEU A 237       7.504  25.010  16.869  1.00 27.17           C  
ATOM   1711  CD1 LEU A 237       8.034  25.527  18.234  1.00 26.56           C  
ATOM   1712  CD2 LEU A 237       8.657  24.529  16.032  1.00 31.72           C  
ATOM   1713  N   VAL A 238       4.474  21.281  16.202  1.00 26.43           N  
ATOM   1714  CA  VAL A 238       3.273  20.508  16.544  1.00 25.83           C  
ATOM   1715  C   VAL A 238       3.594  19.321  17.458  1.00 27.11           C  
ATOM   1716  O   VAL A 238       4.623  18.660  17.272  1.00 27.13           O  
ATOM   1717  CB  VAL A 238       2.576  19.916  15.270  1.00 26.53           C  
ATOM   1718  CG1 VAL A 238       1.290  19.160  15.641  1.00 26.63           C  
ATOM   1719  CG2 VAL A 238       2.263  20.985  14.228  1.00 26.79           C  
ATOM   1720  N   SER A 239       2.730  19.109  18.457  1.00 26.26           N  
ATOM   1721  CA  SER A 239       2.746  17.942  19.349  0.50 25.92           C  
ATOM   1723  C   SER A 239       1.414  17.222  19.161  1.00 27.66           C  
ATOM   1724  O   SER A 239       0.365  17.866  19.222  1.00 26.88           O  
ATOM   1725  CB  SER A 239       2.864  18.362  20.807  0.50 27.35           C  
ATOM   1727  OG  SER A 239       2.748  17.230  21.664  0.50 24.12           O  
ATOM   1729  N   ALA A 240       1.461  15.916  18.940  1.00 26.62           N  
ATOM   1730  CA  ALA A 240       0.272  15.087  18.756  1.00 28.28           C  
ATOM   1731  C   ALA A 240       0.434  13.844  19.609  1.00 30.47           C  
ATOM   1732  O   ALA A 240       1.564  13.399  19.856  1.00 34.69           O  
ATOM   1733  CB  ALA A 240       0.098  14.721  17.316  1.00 31.63           C  
ATOM   1734  N   ARG A 241      -0.688  13.323  20.086  1.00 29.39           N  
ATOM   1735  CA  ARG A 241      -0.707  12.145  20.933  1.00 30.76           C  
ATOM   1736  C   ARG A 241      -1.486  11.033  20.265  1.00 30.53           C  
ATOM   1737  O   ARG A 241      -2.464  11.291  19.576  1.00 29.46           O  
ATOM   1738  CB  ARG A 241      -1.379  12.496  22.250  1.00 31.48           C  
ATOM   1739  CG  ARG A 241      -1.310  11.414  23.307  1.00 36.13           C  
ATOM   1740  CD  ARG A 241      -2.083  11.779  24.571  1.00 39.40           C  
ATOM   1741  NE  ARG A 241      -3.492  12.073  24.266  1.00 45.11           N  
ATOM   1742  CZ  ARG A 241      -4.049  13.287  24.140  1.00 48.82           C  
ATOM   1743  NH1 ARG A 241      -3.346  14.408  24.317  1.00 51.07           N  
ATOM   1744  NH2 ARG A 241      -5.344  13.380  23.834  1.00 49.80           N  
ATOM   1745  N   ARG A 242      -1.058   9.793  20.453  1.00 33.46           N  
ATOM   1746  CA  ARG A 242      -1.836   8.666  19.939  1.00 36.33           C  
ATOM   1747  C   ARG A 242      -2.481   7.910  21.101  1.00 39.51           C  
ATOM   1748  O   ARG A 242      -3.366   7.091  20.864  1.00 43.79           O  
ATOM   1749  CB  ARG A 242      -0.967   7.804  19.028  1.00 38.05           C  
ATOM   1750  CG  ARG A 242       0.051   6.952  19.715  1.00 41.81           C  
ATOM   1751  CD  ARG A 242      -0.520   5.589  20.035  1.00 47.66           C  
ATOM   1752  NE  ARG A 242      -0.469   4.658  18.933  1.00 46.47           N  
ATOM   1753  CZ  ARG A 242      -1.275   3.605  18.740  1.00 42.54           C  
ATOM   1754  NH1 ARG A 242      -2.327   3.351  19.521  1.00 49.18           N  
ATOM   1755  NH2 ARG A 242      -1.060   2.817  17.695  1.00 42.49           N  
ATOM   1756  OXT ARG A 242      -2.156   8.056  22.282  1.00 38.91           O  
TER    1757      ARG A 242                                                      
END
MOLECULE T0508.pdb
ATOM      1  N   GLN    17      27.341  18.956  20.266  1.00 28.55           N  
ATOM      2  CA  GLN    17      26.133  19.476  19.544  1.00 26.35           C  
ATOM      3  C   GLN    17      25.067  19.993  20.513  1.00 30.77           C  
ATOM      4  O   GLN    17      24.034  20.543  20.088  1.00 24.08           O  
ATOM      5  CB  GLN    17      25.542  18.382  18.646  1.00 27.54           C  
ATOM      6  CG  GLN    17      26.434  17.946  17.479  1.00 28.33           C  
ATOM      7  CD  GLN    17      26.586  19.019  16.411  1.00 35.79           C  
ATOM      8  OE1 GLN    17      25.718  19.891  16.241  1.00 34.30           O  
ATOM      9  NE2 GLN    17      27.692  18.953  15.672  1.00 38.09           N  
ATOM     10  N   LEU    18      25.329  19.819  21.814  1.00 31.52           N  
ATOM     11  CA  LEU    18      24.433  20.242  22.907  1.00 36.19           C  
ATOM     12  C   LEU    18      24.053  21.718  22.876  1.00 37.06           C  
ATOM     13  O   LEU    18      23.038  22.126  23.448  1.00 36.28           O  
ATOM     14  CB  LEU    18      25.085  19.950  24.263  1.00 40.29           C  
ATOM     15  CG  LEU    18      25.116  18.500  24.733  1.00 40.46           C  
ATOM     16  CD1 LEU    18      25.963  18.381  25.991  1.00 45.09           C  
ATOM     17  CD2 LEU    18      23.700  18.005  24.965  1.00 39.67           C  
ATOM     18  N   ARG    19      24.888  22.495  22.199  1.00 35.74           N  
ATOM     19  CA  ARG    19      24.812  23.945  22.161  1.00 37.88           C  
ATOM     20  C   ARG    19      24.334  24.487  20.806  1.00 29.39           C  
ATOM     21  O   ARG    19      24.321  25.705  20.601  1.00 29.87           O  
ATOM     22  CB  ARG    19      26.205  24.493  22.466  1.00 42.33           C  
ATOM     23  CG  ARG    19      27.341  23.712  21.765  1.00 53.58           C  
ATOM     24  CD  ARG    19      27.752  24.332  20.429  1.00 61.77           C  
ATOM     25  NE  ARG    19      28.576  23.428  19.629  1.00 75.01           N  
ATOM     26  CZ  ARG    19      28.165  22.800  18.529  1.00 80.38           C  
ATOM     27  NH1 ARG    19      26.931  22.978  18.067  1.00 80.36           N  
ATOM     28  NH2 ARG    19      28.996  21.994  17.880  1.00 82.30           N  
ATOM     29  N   SER    20      23.992  23.591  19.877  1.00 22.34           N  
ATOM     30  CA  SER    20      23.537  23.996  18.549  1.00 20.35           C  
ATOM     31  C   SER    20      22.175  24.689  18.593  1.00 18.47           C  
ATOM     32  O   SER    20      21.426  24.558  19.561  1.00 18.01           O  
ATOM     33  CB  SER    20      23.472  22.799  17.611  1.00 22.60           C  
ATOM     34  OG  SER    20      22.316  22.019  17.885  1.00 20.95           O  
ATOM     35  N   ARG    21      21.846  25.410  17.528  1.00 18.65           N  
ATOM     36  CA  ARG    21      20.566  26.116  17.455  1.00 19.51           C  
ATOM     37  C   ARG    21      19.421  25.111  17.556  1.00 17.07           C  
ATOM     38  O   ARG    21      18.440  25.343  18.268  1.00 19.73           O  
ATOM     39  CB  ARG    21      20.473  26.874  16.130  1.00 23.77           C  
ATOM     40  CG  ARG    21      19.192  27.666  15.945  1.00 31.80           C  
ATOM     41  CD  ARG    21      19.340  28.620  14.778  1.00 45.60           C  
ATOM     42  NE  ARG    21      18.350  29.692  14.818  1.00 57.03           N  
ATOM     43  CZ  ARG    21      18.418  30.803  14.089  1.00 65.61           C  
ATOM     44  NH1 ARG    21      19.437  30.999  13.257  1.00 66.62           N  
ATOM     45  NH2 ARG    21      17.468  31.723  14.194  1.00 68.54           N  
ATOM     46  N   ALA    22      19.578  23.995  16.850  1.00 17.83           N  
ATOM     47  CA  ALA    22      18.573  22.948  16.851  1.00 15.55           C  
ATOM     48  C   ALA    22      18.381  22.371  18.258  1.00 16.33           C  
ATOM     49  O   ALA    22      17.249  22.202  18.720  1.00 17.50           O  
ATOM     50  CB  ALA    22      18.933  21.869  15.862  1.00 19.42           C  
ATOM     51  N   ALA    23      19.481  22.100  18.964  1.00 16.59           N  
ATOM     52  CA  ALA    23      19.386  21.661  20.362  1.00 15.10           C  
ATOM     53  C   ALA    23      18.604  22.656  21.238  1.00 16.51           C  
ATOM     54  O   ALA    23      17.775  22.244  22.038  1.00 15.64           O  
ATOM     55  CB  ALA    23      20.787  21.427  20.948  1.00 15.49           C  
ATOM     56  N   PHE    24      18.867  23.967  21.093  1.00 15.01           N  
ATOM     57  CA  PHE    24      18.139  24.958  21.887  1.00 20.00           C  
ATOM     58  C   PHE    24      16.644  24.967  21.591  1.00 14.73           C  
ATOM     59  O   PHE    24      15.815  25.130  22.508  1.00 18.39           O  
ATOM     60  CB  PHE    24      18.733  26.367  21.714  1.00 25.77           C  
ATOM     61  CG  PHE    24      19.868  26.656  22.659  1.00 37.19           C  
ATOM     62  CD1 PHE    24      19.615  27.052  23.971  1.00 47.97           C  
ATOM     63  CD2 PHE    24      21.193  26.508  22.245  1.00 46.26           C  
ATOM     64  CE1 PHE    24      20.666  27.309  24.857  1.00 54.49           C  
ATOM     65  CE2 PHE    24      22.251  26.764  23.120  1.00 49.16           C  
ATOM     66  CZ  PHE    24      21.989  27.165  24.428  1.00 48.58           C  
ATOM     67  N   LYS    25      16.301  24.766  20.314  1.00 15.96           N  
ATOM     68  CA  LYS    25      14.893  24.667  19.907  1.00 15.07           C  
ATOM     69  C   LYS    25      14.239  23.492  20.622  1.00 14.67           C  
ATOM     70  O   LYS    25      13.147  23.626  21.185  1.00 14.53           O  
ATOM     71  CB  LYS    25      14.751  24.520  18.391  1.00 16.88           C  
ATOM     72  CG  LYS    25      15.042  25.803  17.590  1.00 24.44           C  
ATOM     73  CD  LYS    25      14.706  25.620  16.105  1.00 27.14           C  
ATOM     74  CE  LYS    25      15.959  25.479  15.249  1.00 35.96           C  
ATOM     75  NZ  LYS    25      15.649  25.049  13.851  1.00 38.22           N  
ATOM     76  N   LEU    26      14.912  22.340  20.648  1.00 13.44           N  
ATOM     77  CA  LEU    26      14.307  21.207  21.341  1.00 12.47           C  
ATOM     78  C   LEU    26      14.186  21.435  22.842  1.00 12.58           C  
ATOM     79  O   LEU    26      13.165  21.067  23.427  1.00 13.35           O  
ATOM     80  CB  LEU    26      15.051  19.889  21.058  1.00 14.07           C  
ATOM     81  CG  LEU    26      14.419  18.650  21.686  1.00 12.73           C  
ATOM     82  CD1 LEU    26      13.020  18.452  21.173  1.00 13.01           C  
ATOM     83  CD2 LEU    26      15.264  17.428  21.366  1.00 13.66           C  
ATOM     84  N   GLU    27      15.197  22.047  23.463  1.00 14.16           N  
ATOM     85  CA  GLU    27      15.124  22.335  24.902  1.00 15.27           C  
ATOM     86  C   GLU    27      13.907  23.219  25.231  1.00 12.64           C  
ATOM     87  O   GLU    27      13.205  22.990  26.204  1.00 14.02           O  
ATOM     88  CB  GLU    27      16.428  22.989  25.382  1.00 16.28           C  
ATOM     89  CG  GLU    27      17.600  21.998  25.485  1.00 27.56           C  
ATOM     90  CD  GLU    27      18.915  22.632  25.940  1.00 38.21           C  
ATOM     91  OE1 GLU    27      19.405  23.577  25.272  1.00 49.67           O  
ATOM     92  OE2 GLU    27      19.469  22.163  26.960  1.00 51.34           O  
ATOM     93  N   PHE    28      13.670  24.214  24.380  1.00 14.06           N  
ATOM     94  CA  PHE    28      12.541  25.133  24.517  1.00 12.72           C  
ATOM     95  C   PHE    28      11.221  24.373  24.460  1.00 13.27           C  
ATOM     96  O   PHE    28      10.360  24.568  25.306  1.00 13.48           O  
ATOM     97  CB  PHE    28      12.682  26.168  23.405  1.00 13.96           C  
ATOM     98  CG  PHE    28      11.502  27.087  23.215  1.00 14.57           C  
ATOM     99  CD1 PHE    28      11.408  28.290  23.917  1.00 19.84           C  
ATOM    100  CD2 PHE    28      10.536  26.793  22.258  1.00 17.11           C  
ATOM    101  CE1 PHE    28      10.346  29.167  23.677  1.00 17.75           C  
ATOM    102  CE2 PHE    28       9.457  27.663  22.024  1.00 16.94           C  
ATOM    103  CZ  PHE    28       9.381  28.850  22.735  1.00 20.66           C  
ATOM    104  N   LEU    29      11.108  23.480  23.476  1.00 13.95           N  
ATOM    105  CA  LEU    29       9.905  22.672  23.317  1.00 11.98           C  
ATOM    106  C   LEU    29       9.685  21.692  24.466  1.00 12.60           C  
ATOM    107  O   LEU    29       8.537  21.496  24.882  1.00 13.48           O  
ATOM    108  CB  LEU    29       9.940  21.899  21.982  1.00 13.29           C  
ATOM    109  CG  LEU    29       9.955  22.790  20.727  1.00 13.34           C  
ATOM    110  CD1 LEU    29      10.381  21.990  19.476  1.00 14.82           C  
ATOM    111  CD2 LEU    29       8.600  23.481  20.463  1.00 14.32           C  
ATOM    112  N   LEU    30      10.753  21.064  24.967  1.00 10.58           N  
ATOM    113  CA  LEU    30      10.602  20.155  26.121  1.00 12.83           C  
ATOM    114  C   LEU    30      10.172  20.920  27.372  1.00 12.29           C  
ATOM    115  O   LEU    30       9.300  20.465  28.111  1.00 14.05           O  
ATOM    116  CB  LEU    30      11.895  19.370  26.400  1.00 15.66           C  
ATOM    117  CG  LEU    30      12.359  18.479  25.258  1.00 16.16           C  
ATOM    118  CD1 LEU    30      13.759  17.903  25.567  1.00 17.08           C  
ATOM    119  CD2 LEU    30      11.320  17.389  24.963  1.00 19.76           C  
ATOM    120  N   ASP    31      10.738  22.115  27.577  1.00 13.31           N  
ATOM    121  CA  ASP    31      10.380  22.953  28.748  1.00 12.70           C  
ATOM    122  C   ASP    31       8.916  23.346  28.710  1.00 13.57           C  
ATOM    123  O   ASP    31       8.207  23.347  29.728  1.00 13.47           O  
ATOM    124  CB  ASP    31      11.213  24.239  28.773  1.00 16.51           C  
ATOM    125  CG  ASP    31      12.593  24.044  29.368  1.00 23.03           C  
ATOM    126  OD1 ASP    31      12.832  23.035  30.067  1.00 27.41           O  
ATOM    127  OD2 ASP    31      13.448  24.930  29.141  1.00 27.84           O  
ATOM    128  N   ARG    32       8.452  23.717  27.535  1.00 12.67           N  
ATOM    129  CA  ARG    32       7.103  24.226  27.393  1.00 12.84           C  
ATOM    130  C   ARG    32       6.040  23.146  27.326  1.00 13.39           C  
ATOM    131  O   ARG    32       4.932  23.349  27.808  1.00 13.37           O  
ATOM    132  CB  ARG    32       7.000  25.023  26.116  1.00 12.72           C  
ATOM    133  CG  ARG    32       7.559  26.433  26.139  1.00 14.78           C  
ATOM    134  CD  ARG    32       7.075  27.174  24.878  1.00 14.18           C  
ATOM    135  NE  ARG    32       7.107  28.621  25.069  1.00 18.87           N  
ATOM    136  CZ  ARG    32       6.487  29.493  24.283  1.00 19.83           C  
ATOM    137  NH1 ARG    32       6.604  30.782  24.540  1.00 27.51           N  
ATOM    138  NH2 ARG    32       5.760  29.077  23.246  1.00 19.18           N  
ATOM    139  N   TYR    33       6.361  22.031  26.665  1.00 10.84           N  
ATOM    140  CA  TYR    33       5.349  21.039  26.290  1.00 11.98           C  
ATOM    141  C   TYR    33       5.577  19.599  26.760  1.00 12.64           C  
ATOM    142  O   TYR    33       4.688  18.759  26.572  1.00 13.17           O  
ATOM    143  CB  TYR    33       5.177  21.027  24.770  1.00 11.87           C  
ATOM    144  CG  TYR    33       4.950  22.401  24.210  1.00 12.45           C  
ATOM    145  CD1 TYR    33       3.748  23.065  24.432  1.00 12.73           C  
ATOM    146  CD2 TYR    33       5.941  23.052  23.490  1.00 11.65           C  
ATOM    147  CE1 TYR    33       3.525  24.350  23.915  1.00 13.75           C  
ATOM    148  CE2 TYR    33       5.720  24.343  22.958  1.00 13.97           C  
ATOM    149  CZ  TYR    33       4.524  24.980  23.189  1.00 14.82           C  
ATOM    150  OH  TYR    33       4.331  26.250  22.673  1.00 17.07           O  
ATOM    151  N   ARG    34       6.737  19.329  27.320  1.00 11.94           N  
ATOM    152  CA  ARG    34       7.075  17.987  27.885  0.50 12.60           C  
ATOM    154  C   ARG    34       6.752  16.863  26.836  1.00 15.29           C  
ATOM    155  O   ARG    34       6.265  15.838  27.180  1.00 16.34           O  
ATOM    156  CB  ARG    34       6.341  17.730  29.206  0.50 15.27           C  
ATOM    158  CG  ARG    34       6.715  18.721  30.308  0.50 18.80           C  
ATOM    160  CD  ARG    34       6.251  18.251  31.685  0.50 24.09           C  
ATOM    162  NE  ARG    34       7.080  17.171  32.217  0.50 29.99           N  
ATOM    164  CZ  ARG    34       6.723  15.887  32.260  0.50 35.77           C  
ATOM    166  NH1 ARG    34       7.554  14.986  32.768  0.50 30.23           N  
ATOM    168  NH2 ARG    34       5.538  15.495  31.800  0.50 39.31           N  
ATOM    170  N   VAL    35       7.093  17.136  25.601  1.00 14.33           N  
ATOM    171  CA  VAL    35       6.681  16.252  24.539  1.00 16.23           C  
ATOM    172  C   VAL    35       7.397  14.907  24.563  1.00 15.87           C  
ATOM    173  O   VAL    35       6.842  13.935  24.164  1.00 18.60           O  
ATOM    174  CB  VAL    35       6.614  16.981  23.155  1.00 20.79           C  
ATOM    175  CG1 VAL    35       7.901  17.453  22.753  1.00 19.27           C  
ATOM    176  CG2 VAL    35       5.962  16.095  22.079  1.00 22.03           C  
ATOM    177  N   VAL    36       8.620  14.904  25.063  1.00 14.69           N  
ATOM    178  CA  VAL    36       9.323  13.708  25.475  1.00 14.45           C  
ATOM    179  C   VAL    36       9.549  13.719  27.008  1.00 14.37           C  
ATOM    180  O   VAL    36       9.873  14.725  27.537  1.00 16.00           O  
ATOM    181  CB  VAL    36      10.688  13.600  24.695  1.00 15.76           C  
ATOM    182  CG1 VAL    36      11.501  12.407  25.134  1.00 14.06           C  
ATOM    183  CG2 VAL    36      10.462  13.571  23.222  1.00 13.18           C  
ATOM    184  N   ARG    37       9.328  12.593  27.672  1.00 13.64           N  
ATOM    185  CA  ARG    37       9.333  12.429  29.008  0.50 18.53           C  
ATOM    187  C   ARG    37      10.496  11.527  29.402  1.00 15.77           C  
ATOM    188  O   ARG    37      10.863  10.667  28.672  1.00 14.89           O  
ATOM    189  CB  ARG    37       7.994  11.913  29.555  0.50 20.65           C  
ATOM    191  CG  ARG    37       6.819  12.854  29.252  0.50 30.27           C  
ATOM    193  CD  ARG    37       5.434  12.185  29.360  0.50 33.11           C  
ATOM    195  NE  ARG    37       5.097  11.095  28.417  0.50 42.98           N  
ATOM    197  CZ  ARG    37       5.375  11.018  27.107  0.50 40.65           C  
ATOM    199  NH1 ARG    37       6.040  11.964  26.456  0.50 28.66           N  
ATOM    201  NH2 ARG    37       4.975   9.949  26.427  0.50 44.72           N  
ATOM    203  N   LYS    38      11.067  11.751  30.563  1.00 15.15           N  
ATOM    204  CA  LYS    38      12.094  10.917  31.115  1.00 13.26           C  
ATOM    205  C   LYS    38      11.741   9.422  31.039  1.00 14.54           C  
ATOM    206  O   LYS    38      10.728   9.042  31.504  1.00 15.92           O  
ATOM    207  CB  LYS    38      12.289  11.304  32.594  1.00 16.09           C  
ATOM    208  CG  LYS    38      13.380  10.611  33.234  1.00 22.87           C  
ATOM    209  CD  LYS    38      14.598  11.183  32.785  1.00 36.52           C  
ATOM    210  CE  LYS    38      15.770  10.611  33.427  1.00 45.52           C  
ATOM    211  NZ  LYS    38      16.989  11.533  33.326  1.00 52.07           N  
ATOM    212  N   GLY    39      12.616   8.645  30.434  1.00 14.73           N  
ATOM    213  CA  GLY    39      12.416   7.193  30.331  1.00 13.34           C  
ATOM    214  C   GLY    39      11.741   6.729  29.047  1.00 14.96           C  
ATOM    215  O   GLY    39      11.562   5.538  28.824  1.00 12.59           O  
ATOM    216  N   ASP    40      11.334   7.670  28.208  1.00 11.88           N  
ATOM    217  CA  ASP    40      10.695   7.357  26.933  1.00  9.89           C  
ATOM    218  C   ASP    40      11.656   6.706  25.958  1.00 10.44           C  
ATOM    219  O   ASP    40      12.871   6.965  25.986  1.00 11.68           O  
ATOM    220  CB  ASP    40      10.168   8.642  26.291  1.00  9.60           C  
ATOM    221  CG  ASP    40       8.825   9.075  26.855  1.00 15.15           C  
ATOM    222  OD1 ASP    40       8.300   8.390  27.768  1.00 15.94           O  
ATOM    223  OD2 ASP    40       8.287  10.116  26.398  1.00 13.89           O  
ATOM    224  N   ALA    41      11.087   5.869  25.081  1.00  9.23           N  
ATOM    225  CA  ALA    41      11.803   5.381  23.917  1.00 10.66           C  
ATOM    226  C   ALA    41      11.312   6.214  22.746  1.00 10.39           C  
ATOM    227  O   ALA    41      10.097   6.409  22.593  1.00 10.52           O  
ATOM    228  CB  ALA    41      11.509   3.893  23.655  1.00 11.78           C  
ATOM    229  N   VAL    42      12.251   6.703  21.934  1.00  9.29           N  
ATOM    230  CA  VAL    42      11.966   7.691  20.884  1.00  9.19           C  
ATOM    231  C   VAL    42      12.535   7.249  19.544  1.00  9.09           C  
ATOM    232  O   VAL    42      13.680   6.824  19.477  1.00 10.43           O  
ATOM    233  CB  VAL    42      12.634   9.041  21.259  1.00 10.87           C  
ATOM    234  CG1 VAL    42      12.350  10.120  20.216  1.00 10.02           C  
ATOM    235  CG2 VAL    42      12.159   9.507  22.641  1.00  9.93           C  
ATOM    236  N   ILE    43      11.714   7.336  18.489  1.00  9.23           N  
ATOM    237  CA  ILE    43      12.233   7.267  17.117  1.00  8.55           C  
ATOM    238  C   ILE    43      12.455   8.724  16.690  1.00  9.88           C  
ATOM    239  O   ILE    43      11.523   9.538  16.716  1.00 10.54           O  
ATOM    240  CB  ILE    43      11.247   6.608  16.168  1.00  9.68           C  
ATOM    241  CG1 ILE    43      11.134   5.117  16.514  1.00 11.32           C  
ATOM    242  CG2 ILE    43      11.709   6.781  14.705  1.00 13.11           C  
ATOM    243  CD1 ILE    43       9.953   4.437  15.835  1.00 12.08           C  
ATOM    244  N   GLU    44      13.695   9.056  16.345  1.00 10.06           N  
ATOM    245  CA  GLU    44      14.079  10.401  15.958  1.00 10.36           C  
ATOM    246  C   GLU    44      14.415  10.427  14.478  1.00 11.21           C  
ATOM    247  O   GLU    44      15.330   9.729  14.050  1.00 12.60           O  
ATOM    248  CB  GLU    44      15.301  10.844  16.764  1.00 11.21           C  
ATOM    249  CG  GLU    44      15.747  12.224  16.301  1.00 11.70           C  
ATOM    250  CD  GLU    44      17.120  12.636  16.766  1.00 13.48           C  
ATOM    251  OE1 GLU    44      17.897  11.771  17.255  1.00 15.29           O  
ATOM    252  OE2 GLU    44      17.420  13.836  16.601  1.00 17.75           O  
ATOM    253  N   ILE    45      13.664  11.191  13.701  1.00  9.39           N  
ATOM    254  CA  ILE    45      13.837  11.257  12.237  1.00  9.26           C  
ATOM    255  C   ILE    45      14.554  12.550  11.852  1.00 10.33           C  
ATOM    256  O   ILE    45      14.161  13.633  12.285  1.00 12.16           O  
ATOM    257  CB  ILE    45      12.486  11.132  11.523  1.00 10.48           C  
ATOM    258  CG1 ILE    45      11.919   9.730  11.811  1.00 14.98           C  
ATOM    259  CG2 ILE    45      12.642  11.353  10.015  1.00 13.76           C  
ATOM    260  CD1 ILE    45      10.461   9.557  11.499  1.00 20.21           C  
ATOM    261  N   GLY    46      15.643  12.439  11.084  1.00 11.67           N  
ATOM    262  CA  GLY    46      16.424  13.628  10.739  1.00 10.89           C  
ATOM    263  C   GLY    46      17.394  14.013  11.850  1.00 11.86           C  
ATOM    264  O   GLY    46      17.433  15.156  12.283  1.00 14.16           O  
ATOM    265  N   SER    47      18.192  13.047  12.287  1.00 14.11           N  
ATOM    266  CA  SER    47      19.016  13.223  13.476  1.00 13.31           C  
ATOM    267  C   SER    47      20.367  13.896  13.288  1.00 12.81           C  
ATOM    268  O   SER    47      20.932  14.398  14.248  1.00 14.54           O  
ATOM    269  CB  SER    47      19.277  11.857  14.108  1.00 11.08           C  
ATOM    270  OG  SER    47      19.928  10.995  13.176  1.00 14.23           O  
ATOM    271  N   SER    48      20.890  13.926  12.065  1.00 12.35           N  
ATOM    272  CA  SER    48      22.264  14.391  11.892  0.50 12.78           C  
ATOM    274  C   SER    48      22.363  15.908  11.904  1.00 12.43           C  
ATOM    275  O   SER    48      21.495  16.587  11.361  1.00 16.33           O  
ATOM    276  CB  SER    48      22.855  13.821  10.613  0.50 13.15           C  
ATOM    278  OG  SER    48      22.792  12.407  10.651  0.50 12.11           O  
ATOM    280  N   PRO    49      23.431  16.454  12.534  1.00 13.69           N  
ATOM    281  CA  PRO    49      24.584  15.838  13.196  1.00 14.45           C  
ATOM    282  C   PRO    49      24.402  15.350  14.622  1.00 15.17           C  
ATOM    283  O   PRO    49      25.297  14.696  15.125  1.00 18.41           O  
ATOM    284  CB  PRO    49      25.646  16.960  13.158  1.00 13.96           C  
ATOM    285  CG  PRO    49      24.828  18.216  13.270  1.00 16.02           C  
ATOM    286  CD  PRO    49      23.555  17.932  12.489  1.00 16.62           C  
ATOM    287  N   GLY    50      23.286  15.668  15.282  1.00 14.24           N  
ATOM    288  CA  GLY    50      23.063  15.082  16.608  1.00 11.34           C  
ATOM    289  C   GLY    50      22.701  16.000  17.754  1.00 13.31           C  
ATOM    290  O   GLY    50      22.751  15.585  18.900  1.00 13.91           O  
ATOM    291  N   GLY    51      22.342  17.254  17.466  1.00 12.78           N  
ATOM    292  CA  GLY    51      21.909  18.171  18.531  1.00 12.63           C  
ATOM    293  C   GLY    51      20.682  17.708  19.307  1.00 13.36           C  
ATOM    294  O   GLY    51      20.701  17.634  20.539  1.00 13.73           O  
ATOM    295  N   TRP    52      19.601  17.405  18.587  1.00 11.89           N  
ATOM    296  CA  TRP    52      18.441  16.839  19.275  1.00 11.79           C  
ATOM    297  C   TRP    52      18.798  15.531  19.953  1.00 11.80           C  
ATOM    298  O   TRP    52      18.345  15.262  21.057  1.00 13.79           O  
ATOM    299  CB  TRP    52      17.276  16.596  18.323  1.00 12.99           C  
ATOM    300  CG  TRP    52      16.480  17.814  17.965  1.00 13.11           C  
ATOM    301  CD1 TRP    52      16.894  19.126  17.985  1.00 11.58           C  
ATOM    302  CD2 TRP    52      15.125  17.829  17.523  1.00 12.99           C  
ATOM    303  NE1 TRP    52      15.878  19.948  17.579  1.00 13.19           N  
ATOM    304  CE2 TRP    52      14.777  19.177  17.287  1.00 13.10           C  
ATOM    305  CE3 TRP    52      14.164  16.825  17.299  1.00 13.89           C  
ATOM    306  CZ2 TRP    52      13.496  19.554  16.851  1.00 12.31           C  
ATOM    307  CZ3 TRP    52      12.906  17.193  16.854  1.00 14.51           C  
ATOM    308  CH2 TRP    52      12.586  18.547  16.632  1.00 12.23           C  
ATOM    309  N   THR    53      19.602  14.703  19.281  1.00 11.88           N  
ATOM    310  CA  THR    53      19.935  13.386  19.848  1.00 13.53           C  
ATOM    311  C   THR    53      20.637  13.514  21.192  1.00 11.78           C  
ATOM    312  O   THR    53      20.307  12.798  22.142  1.00 15.17           O  
ATOM    313  CB  THR    53      20.836  12.558  18.891  1.00 13.39           C  
ATOM    314  OG1 THR    53      20.362  12.667  17.548  1.00 15.73           O  
ATOM    315  CG2 THR    53      20.864  11.092  19.305  1.00 15.16           C  
ATOM    316  N   GLN    54      21.570  14.460  21.279  1.00 13.11           N  
ATOM    317  CA  GLN    54      22.293  14.685  22.521  1.00 14.80           C  
ATOM    318  C   GLN    54      21.366  15.235  23.616  1.00 14.98           C  
ATOM    319  O   GLN    54      21.513  14.867  24.783  1.00 17.30           O  
ATOM    320  CB  GLN    54      23.494  15.605  22.274  1.00 15.90           C  
ATOM    321  CG  GLN    54      24.615  14.902  21.537  1.00 17.43           C  
ATOM    322  CD  GLN    54      25.871  15.739  21.359  1.00 23.10           C  
ATOM    323  OE1 GLN    54      26.032  16.792  21.966  1.00 27.50           O  
ATOM    324  NE2 GLN    54      26.777  15.252  20.521  1.00 36.12           N  
ATOM    325  N   VAL    55      20.407  16.085  23.253  1.00 13.38           N  
ATOM    326  CA  VAL    55      19.436  16.577  24.224  1.00 13.23           C  
ATOM    327  C   VAL    55      18.549  15.413  24.682  1.00 16.58           C  
ATOM    328  O   VAL    55      18.325  15.241  25.881  1.00 19.21           O  
ATOM    329  CB  VAL    55      18.568  17.734  23.646  1.00 14.91           C  
ATOM    330  CG1 VAL    55      17.342  18.049  24.540  1.00 15.77           C  
ATOM    331  CG2 VAL    55      19.428  18.996  23.464  1.00 18.22           C  
ATOM    332  N   LEU    56      18.064  14.627  23.718  1.00 13.47           N  
ATOM    333  CA  LEU    56      17.193  13.485  24.034  1.00 16.57           C  
ATOM    334  C   LEU    56      17.903  12.413  24.853  1.00 14.44           C  
ATOM    335  O   LEU    56      17.277  11.761  25.667  1.00 13.36           O  
ATOM    336  CB  LEU    56      16.608  12.859  22.769  1.00 14.57           C  
ATOM    337  CG  LEU    56      15.627  13.647  21.890  1.00 16.91           C  
ATOM    338  CD1 LEU    56      15.467  12.948  20.538  1.00 18.51           C  
ATOM    339  CD2 LEU    56      14.279  13.842  22.594  1.00 24.21           C  
ATOM    340  N   ASN    57      19.208  12.243  24.651  1.00 16.18           N  
ATOM    341  CA  ASN    57      19.983  11.196  25.321  1.00 15.31           C  
ATOM    342  C   ASN    57      20.077  11.415  26.823  1.00 21.90           C  
ATOM    343  O   ASN    57      20.399  10.493  27.563  1.00 25.60           O  
ATOM    344  CB  ASN    57      21.370  11.128  24.689  1.00 17.13           C  
ATOM    345  CG  ASN    57      22.121   9.851  25.011  1.00 20.72           C  
ATOM    346  OD1 ASN    57      23.343   9.875  25.184  1.00 24.28           O  
ATOM    347  ND2 ASN    57      21.411   8.736  25.084  1.00 17.68           N  
ATOM    348  N   SER    58      19.746  12.635  27.241  1.00 20.84           N  
ATOM    349  CA  SER    58      19.785  13.036  28.646  0.50 22.94           C  
ATOM    351  C   SER    58      18.504  12.628  29.365  1.00 23.93           C  
ATOM    352  O   SER    58      18.425  12.706  30.598  1.00 27.24           O  
ATOM    353  CB  SER    58      20.006  14.557  28.772  0.50 25.02           C  
ATOM    355  OG  SER    58      18.881  15.303  28.321  0.50 21.84           O  
ATOM    357  N   LEU    59      17.512  12.169  28.595  1.00 15.23           N  
ATOM    358  CA  LEU    59      16.141  12.000  29.080  1.00 14.65           C  
ATOM    359  C   LEU    59      15.541  10.635  28.673  1.00 14.87           C  
ATOM    360  O   LEU    59      14.897   9.940  29.474  1.00 15.65           O  
ATOM    361  CB  LEU    59      15.324  13.132  28.429  1.00 25.84           C  
ATOM    362  CG  LEU    59      13.879  13.493  28.741  1.00 25.18           C  
ATOM    363  CD1 LEU    59      13.803  14.181  30.089  1.00 29.94           C  
ATOM    364  CD2 LEU    59      13.301  14.413  27.667  1.00 26.06           C  
ATOM    365  N   ALA    60      15.735  10.265  27.407  1.00 13.09           N  
ATOM    366  CA  ALA    60      15.152   9.037  26.874  1.00 13.19           C  
ATOM    367  C   ALA    60      15.880   7.798  27.391  1.00 12.67           C  
ATOM    368  O   ALA    60      17.097   7.835  27.650  1.00 12.83           O  
ATOM    369  CB  ALA    60      15.211   9.067  25.359  1.00 11.38           C  
ATOM    370  N   ARG    61      15.153   6.674  27.513  1.00 12.32           N  
ATOM    371  CA  ARG    61      15.834   5.402  27.814  1.00 11.46           C  
ATOM    372  C   ARG    61      16.487   4.775  26.579  1.00 10.52           C  
ATOM    373  O   ARG    61      17.451   4.018  26.691  1.00 13.25           O  
ATOM    374  CB  ARG    61      14.887   4.389  28.488  1.00 10.24           C  
ATOM    375  CG  ARG    61      13.912   3.659  27.577  1.00 13.10           C  
ATOM    376  CD  ARG    61      13.040   2.670  28.379  1.00 13.71           C  
ATOM    377  NE  ARG    61      12.274   1.828  27.468  1.00 12.52           N  
ATOM    378  CZ  ARG    61      11.148   2.200  26.863  1.00 10.75           C  
ATOM    379  NH1 ARG    61      10.592   3.392  27.102  1.00 11.33           N  
ATOM    380  NH2 ARG    61      10.528   1.359  26.026  1.00 12.41           N  
ATOM    381  N   LYS    62      15.955   5.090  25.394  1.00 10.76           N  
ATOM    382  CA  LYS    62      16.456   4.537  24.153  1.00 10.80           C  
ATOM    383  C   LYS    62      16.015   5.435  23.008  1.00 10.46           C  
ATOM    384  O   LYS    62      14.887   5.903  22.985  1.00 11.00           O  
ATOM    385  CB  LYS    62      15.908   3.128  23.926  1.00 11.68           C  
ATOM    386  CG  LYS    62      16.537   2.368  22.731  1.00 14.08           C  
ATOM    387  CD  LYS    62      18.069   2.338  22.718  1.00 15.23           C  
ATOM    388  CE  LYS    62      18.694   1.776  24.000  1.00 16.71           C  
ATOM    389  NZ  LYS    62      20.167   1.507  23.839  1.00 19.21           N  
ATOM    390  N   ILE    63      16.956   5.708  22.103  1.00 10.53           N  
ATOM    391  CA  ILE    63      16.669   6.490  20.903  1.00 10.94           C  
ATOM    392  C   ILE    63      17.062   5.657  19.694  1.00 10.88           C  
ATOM    393  O   ILE    63      18.155   5.100  19.632  1.00 11.23           O  
ATOM    394  CB  ILE    63      17.478   7.812  20.873  1.00 11.95           C  
ATOM    395  CG1 ILE    63      17.197   8.628  22.130  1.00 12.48           C  
ATOM    396  CG2 ILE    63      17.111   8.626  19.607  1.00 11.36           C  
ATOM    397  CD1 ILE    63      18.239   9.693  22.421  1.00 14.22           C  
ATOM    398  N   ILE    64      16.164   5.593  18.725  1.00 10.48           N  
ATOM    399  CA  ILE    64      16.486   5.060  17.412  1.00 10.88           C  
ATOM    400  C   ILE    64      16.486   6.269  16.504  1.00 10.93           C  
ATOM    401  O   ILE    64      15.419   6.864  16.260  1.00 11.03           O  
ATOM    402  CB  ILE    64      15.416   4.042  16.960  1.00 11.86           C  
ATOM    403  CG1 ILE    64      15.450   2.832  17.899  1.00 15.49           C  
ATOM    404  CG2 ILE    64      15.662   3.608  15.514  1.00 16.09           C  
ATOM    405  CD1 ILE    64      14.287   1.900  17.713  1.00 19.46           C  
ATOM    406  N   SER    65      17.668   6.635  16.021  1.00 10.83           N  
ATOM    407  CA  SER    65      17.876   7.846  15.224  1.00 10.05           C  
ATOM    408  C   SER    65      18.068   7.492  13.751  1.00 10.66           C  
ATOM    409  O   SER    65      18.777   6.522  13.452  1.00 12.61           O  
ATOM    410  CB  SER    65      19.134   8.568  15.720  1.00 10.73           C  
ATOM    411  OG  SER    65      18.920   9.202  16.979  1.00 13.77           O  
ATOM    412  N   ILE    66      17.450   8.258  12.851  1.00  9.40           N  
ATOM    413  CA  ILE    66      17.439   7.937  11.425  1.00 10.04           C  
ATOM    414  C   ILE    66      17.853   9.169  10.617  1.00 11.20           C  
ATOM    415  O   ILE    66      17.303  10.259  10.835  1.00 11.03           O  
ATOM    416  CB  ILE    66      16.023   7.511  10.961  1.00 10.72           C  
ATOM    417  CG1 ILE    66      15.571   6.266  11.760  1.00 13.63           C  
ATOM    418  CG2 ILE    66      16.044   7.193   9.456  1.00 15.71           C  
ATOM    419  CD1 ILE    66      14.091   5.931  11.698  1.00 16.82           C  
ATOM    420  N   ASP    67      18.776   9.007   9.672  1.00 11.18           N  
ATOM    421  CA  ASP    67      19.114  10.119   8.794  1.00 11.30           C  
ATOM    422  C   ASP    67      19.697   9.605   7.495  1.00 11.71           C  
ATOM    423  O   ASP    67      20.207   8.493   7.440  1.00 12.81           O  
ATOM    424  CB  ASP    67      20.142  11.041   9.475  1.00 13.14           C  
ATOM    425  CG  ASP    67      20.150  12.447   8.900  1.00 12.63           C  
ATOM    426  OD1 ASP    67      20.680  12.687   7.798  1.00 14.91           O  
ATOM    427  OD2 ASP    67      19.609  13.342   9.554  1.00 12.57           O  
ATOM    428  N   LEU    68      19.618  10.433   6.454  1.00 11.57           N  
ATOM    429  CA  LEU    68      20.321  10.139   5.195  1.00 12.52           C  
ATOM    430  C   LEU    68      21.838  10.180   5.347  1.00 15.17           C  
ATOM    431  O   LEU    68      22.553   9.453   4.634  1.00 16.52           O  
ATOM    432  CB  LEU    68      19.948  11.168   4.126  1.00 12.94           C  
ATOM    433  CG  LEU    68      18.525  11.192   3.601  1.00 13.40           C  
ATOM    434  CD1 LEU    68      18.271  12.492   2.840  1.00 16.72           C  
ATOM    435  CD2 LEU    68      18.308  10.018   2.701  1.00 16.24           C  
ATOM    436  N   GLN    69      22.310  11.046   6.234  1.00 14.15           N  
ATOM    437  CA  GLN    69      23.728  11.351   6.393  0.50 15.08           C  
ATOM    439  C   GLN    69      24.290  10.685   7.630  1.00 16.76           C  
ATOM    440  O   GLN    69      23.584  10.523   8.611  1.00 16.67           O  
ATOM    441  CB  GLN    69      23.913  12.867   6.539  0.50 14.48           C  
ATOM    443  CG  GLN    69      23.303  13.684   5.409  0.50 17.02           C  
ATOM    445  CD  GLN    69      23.454  15.188   5.597  0.50 21.02           C  
ATOM    447  OE1 GLN    69      24.102  15.855   4.791  0.50 26.25           O  
ATOM    449  NE2 GLN    69      22.855  15.728   6.661  0.50 23.75           N  
ATOM    451  N   GLU    70      25.572  10.325   7.596  1.00 18.94           N  
ATOM    452  CA  GLU    70      26.232   9.832   8.782  1.00 22.18           C  
ATOM    453  C   GLU    70      26.240  10.901   9.868  1.00 20.61           C  
ATOM    454  O   GLU    70      26.174  12.106   9.592  1.00 22.85           O  
ATOM    455  CB  GLU    70      27.677   9.422   8.457  1.00 28.88           C  
ATOM    456  CG  GLU    70      27.852   7.941   8.115  1.00 41.08           C  
ATOM    457  CD  GLU    70      27.435   7.003   9.249  1.00 47.85           C  
ATOM    458  OE1 GLU    70      26.837   5.947   8.953  1.00 44.50           O  
ATOM    459  OE2 GLU    70      27.701   7.316  10.433  1.00 53.10           O  
ATOM    460  N   MET    71      26.268  10.446  11.111  1.00 22.46           N  
ATOM    461  CA  MET    71      26.587  11.326  12.213  1.00 25.42           C  
ATOM    462  C   MET    71      27.448  10.554  13.197  1.00 23.59           C  
ATOM    463  O   MET    71      27.522   9.316  13.134  1.00 26.19           O  
ATOM    464  CB  MET    71      25.322  11.862  12.878  1.00 23.96           C  
ATOM    465  CG  MET    71      24.476  10.818  13.500  1.00 17.30           C  
ATOM    466  SD  MET    71      23.049  11.579  14.604  0.70 26.40          SE  
ATOM    467  CE  MET    71      22.642   9.910  15.033  1.00 10.60           C  
ATOM    468  N   GLU    72      28.096  11.285  14.094  1.00 26.79           N  
ATOM    469  CA  GLU    72      28.953  10.671  15.095  1.00 33.65           C  
ATOM    470  C   GLU    72      28.145   9.796  16.045  1.00 30.46           C  
ATOM    471  O   GLU    72      26.991  10.116  16.373  1.00 25.47           O  
ATOM    472  CB  GLU    72      29.745  11.727  15.868  1.00 37.99           C  
ATOM    473  CG  GLU    72      31.107  12.025  15.258  1.00 50.28           C  
ATOM    474  CD  GLU    72      32.059  12.668  16.247  1.00 59.79           C  
ATOM    475  OE1 GLU    72      32.889  11.938  16.833  1.00 58.00           O  
ATOM    476  OE2 GLU    72      31.968  13.900  16.446  1.00 64.90           O  
ATOM    477  N   GLU    73      28.759   8.679  16.436  1.00 31.06           N  
ATOM    478  CA  GLU    73      28.176   7.737  17.389  1.00 33.36           C  
ATOM    479  C   GLU    73      27.967   8.371  18.761  1.00 28.63           C  
ATOM    480  O   GLU    73      28.727   9.226  19.207  1.00 23.68           O  
ATOM    481  CB  GLU    73      29.018   6.449  17.491  1.00 36.66           C  
ATOM    482  CG  GLU    73      30.441   6.610  18.065  1.00 54.51           C  
ATOM    483  CD  GLU    73      31.506   7.002  17.029  1.00 65.94           C  
ATOM    484  OE1 GLU    73      31.163   7.273  15.854  1.00 68.44           O  
ATOM    485  OE2 GLU    73      32.701   7.039  17.403  1.00 69.26           O  
ATOM    486  N   ILE    74      26.872   7.991  19.401  1.00 22.88           N  
ATOM    487  CA  ILE    74      26.562   8.449  20.743  1.00 19.83           C  
ATOM    488  C   ILE    74      26.268   7.153  21.468  1.00 21.56           C  
ATOM    489  O   ILE    74      25.559   6.292  20.937  1.00 20.26           O  
ATOM    490  CB  ILE    74      25.373   9.459  20.768  1.00 18.50           C  
ATOM    491  CG1 ILE    74      25.750  10.731  20.004  1.00 19.31           C  
ATOM    492  CG2 ILE    74      25.007   9.835  22.203  1.00 19.70           C  
ATOM    493  CD1 ILE    74      24.565  11.626  19.648  1.00 16.30           C  
ATOM    494  N   ALA    75      26.864   6.985  22.648  1.00 20.90           N  
ATOM    495  CA  ALA    75      26.737   5.721  23.362  1.00 24.22           C  
ATOM    496  C   ALA    75      25.269   5.387  23.594  1.00 16.89           C  
ATOM    497  O   ALA    75      24.505   6.211  24.078  1.00 19.33           O  
ATOM    498  CB  ALA    75      27.493   5.779  24.688  1.00 24.81           C  
ATOM    499  N   GLY    76      24.889   4.172  23.202  1.00 19.08           N  
ATOM    500  CA  GLY    76      23.548   3.677  23.464  1.00 17.20           C  
ATOM    501  C   GLY    76      22.463   4.103  22.491  1.00 15.30           C  
ATOM    502  O   GLY    76      21.329   3.646  22.609  1.00 15.69           O  
ATOM    503  N   VAL    77      22.806   4.973  21.542  1.00 14.31           N  
ATOM    504  CA  VAL    77      21.842   5.431  20.531  1.00 13.17           C  
ATOM    505  C   VAL    77      21.950   4.492  19.341  1.00 13.37           C  
ATOM    506  O   VAL    77      23.080   4.158  18.899  1.00 15.18           O  
ATOM    507  CB  VAL    77      22.116   6.883  20.066  1.00 12.43           C  
ATOM    508  CG1 VAL    77      21.270   7.236  18.841  1.00 12.61           C  
ATOM    509  CG2 VAL    77      21.880   7.889  21.205  1.00 14.75           C  
ATOM    510  N   ARG    78      20.800   4.033  18.840  1.00 11.93           N  
ATOM    511  CA  ARG    78      20.811   3.143  17.711  1.00 12.60           C  
ATOM    512  C   ARG    78      20.600   3.982  16.467  1.00 14.57           C  
ATOM    513  O   ARG    78      19.518   4.500  16.242  1.00 15.17           O  
ATOM    514  CB  ARG    78      19.687   2.130  17.870  1.00 13.99           C  
ATOM    515  CG  ARG    78      19.597   1.139  16.749  1.00 22.12           C  
ATOM    516  CD  ARG    78      18.604   0.066  17.103  1.00 33.92           C  
ATOM    517  NE  ARG    78      19.095  -0.893  18.091  1.00 36.42           N  
ATOM    518  CZ  ARG    78      19.566  -2.102  17.801  1.00 40.20           C  
ATOM    519  NH1 ARG    78      19.627  -2.522  16.538  1.00 33.04           N  
ATOM    520  NH2 ARG    78      19.979  -2.893  18.783  1.00 34.30           N  
ATOM    521  N   PHE    79      21.639   4.139  15.673  1.00 12.80           N  
ATOM    522  CA  PHE    79      21.557   4.970  14.492  1.00 12.11           C  
ATOM    523  C   PHE    79      21.322   4.109  13.255  1.00 15.59           C  
ATOM    524  O   PHE    79      21.970   3.080  13.073  1.00 18.23           O  
ATOM    525  CB  PHE    79      22.824   5.823  14.349  1.00 13.66           C  
ATOM    526  CG  PHE    79      22.852   6.660  13.095  1.00 13.92           C  
ATOM    527  CD1 PHE    79      21.877   7.611  12.857  1.00 14.07           C  
ATOM    528  CD2 PHE    79      23.848   6.472  12.138  1.00 16.12           C  
ATOM    529  CE1 PHE    79      21.892   8.377  11.684  1.00 14.81           C  
ATOM    530  CE2 PHE    79      23.858   7.213  10.961  1.00 19.04           C  
ATOM    531  CZ  PHE    79      22.879   8.168  10.732  1.00 18.26           C  
ATOM    532  N   ILE    80      20.403   4.548  12.398  1.00 13.67           N  
ATOM    533  CA  ILE    80      20.103   3.867  11.146  1.00 14.45           C  
ATOM    534  C   ILE    80      20.258   4.895  10.030  1.00 14.03           C  
ATOM    535  O   ILE    80      19.560   5.907  10.008  1.00 13.61           O  
ATOM    536  CB  ILE    80      18.662   3.349  11.105  1.00 13.42           C  
ATOM    537  CG1 ILE    80      18.360   2.431  12.311  1.00 16.58           C  
ATOM    538  CG2 ILE    80      18.406   2.615   9.777  1.00 18.22           C  
ATOM    539  CD1 ILE    80      16.914   2.000  12.421  1.00 19.95           C  
ATOM    540  N   ARG    81      21.150   4.631   9.083  1.00 13.88           N  
ATOM    541  CA  ARG    81      21.227   5.441   7.874  1.00 13.30           C  
ATOM    542  C   ARG    81      20.158   4.928   6.915  1.00 15.06           C  
ATOM    543  O   ARG    81      20.173   3.759   6.520  1.00 13.56           O  
ATOM    544  CB  ARG    81      22.615   5.338   7.223  1.00 16.75           C  
ATOM    545  CG  ARG    81      23.450   6.594   7.390  1.00 33.80           C  
ATOM    546  CD  ARG    81      24.652   6.576   6.480  1.00 32.17           C  
ATOM    547  NE  ARG    81      24.561   7.513   5.368  1.00 23.99           N  
ATOM    548  CZ  ARG    81      25.551   7.722   4.507  1.00 24.73           C  
ATOM    549  NH1 ARG    81      26.692   7.059   4.649  1.00 32.42           N  
ATOM    550  NH2 ARG    81      25.417   8.590   3.517  1.00 33.32           N  
ATOM    551  N   CYS    82      19.225   5.793   6.535  1.00 12.53           N  
ATOM    552  CA  CYS    82      18.074   5.359   5.777  1.00 13.00           C  
ATOM    553  C   CYS    82      17.358   6.563   5.184  1.00 13.41           C  
ATOM    554  O   CYS    82      17.306   7.620   5.834  1.00 14.05           O  
ATOM    555  CB  CYS    82      17.112   4.609   6.690  1.00 14.25           C  
ATOM    556  SG  CYS    82      15.720   3.923   5.762  1.00 19.53           S  
ATOM    557  N   ASP    83      16.812   6.411   3.971  1.00 11.70           N  
ATOM    558  CA  ASP    83      15.918   7.424   3.426  1.00 13.14           C  
ATOM    559  C   ASP    83      14.520   6.983   3.823  1.00 12.87           C  
ATOM    560  O   ASP    83      14.055   5.923   3.397  1.00 13.51           O  
ATOM    561  CB  ASP    83      16.049   7.465   1.892  1.00 11.45           C  
ATOM    562  CG  ASP    83      15.148   8.506   1.230  1.00 15.18           C  
ATOM    563  OD1 ASP    83      14.130   8.930   1.810  1.00 14.62           O  
ATOM    564  OD2 ASP    83      15.471   8.904   0.089  1.00 18.70           O  
ATOM    565  N   ILE    84      13.815   7.793   4.614  1.00 12.08           N  
ATOM    566  CA  ILE    84      12.487   7.374   5.080  1.00 10.97           C  
ATOM    567  C   ILE    84      11.473   7.126   3.959  1.00 13.47           C  
ATOM    568  O   ILE    84      10.482   6.462   4.189  1.00 13.31           O  
ATOM    569  CB  ILE    84      11.885   8.365   6.121  1.00 13.38           C  
ATOM    570  CG1 ILE    84      11.602   9.759   5.495  1.00 12.86           C  
ATOM    571  CG2 ILE    84      12.798   8.462   7.361  1.00 13.54           C  
ATOM    572  CD1 ILE    84      10.751  10.702   6.380  1.00 14.69           C  
ATOM    573  N   PHE    85      11.714   7.676   2.777  1.00 13.02           N  
ATOM    574  CA  PHE    85      10.765   7.515   1.662  1.00 12.85           C  
ATOM    575  C   PHE    85      10.973   6.201   0.908  1.00 15.25           C  
ATOM    576  O   PHE    85      10.124   5.806   0.095  1.00 17.25           O  
ATOM    577  CB  PHE    85      10.912   8.669   0.671  1.00 12.29           C  
ATOM    578  CG  PHE    85      10.433   9.989   1.201  1.00 11.32           C  
ATOM    579  CD1 PHE    85       9.089  10.185   1.493  1.00 12.76           C  
ATOM    580  CD2 PHE    85      11.325  11.028   1.391  1.00 11.72           C  
ATOM    581  CE1 PHE    85       8.653  11.410   1.982  1.00 15.78           C  
ATOM    582  CE2 PHE    85      10.888  12.257   1.881  1.00 14.28           C  
ATOM    583  CZ  PHE    85       9.542  12.440   2.161  1.00 16.43           C  
ATOM    584  N   LYS    86      12.090   5.521   1.161  1.00 15.12           N  
ATOM    585  CA  LYS    86      12.431   4.349   0.368  1.00 15.16           C  
ATOM    586  C   LYS    86      11.876   3.069   1.009  1.00 15.80           C  
ATOM    587  O   LYS    86      11.010   3.133   1.883  1.00 17.52           O  
ATOM    588  CB  LYS    86      13.945   4.285   0.104  1.00 15.21           C  
ATOM    589  CG  LYS    86      14.498   5.434  -0.749  1.00 18.74           C  
ATOM    590  CD  LYS    86      13.847   5.550  -2.129  1.00 25.60           C  
ATOM    591  CE  LYS    86      14.376   6.798  -2.845  1.00 30.31           C  
ATOM    592  NZ  LYS    86      13.560   7.154  -4.039  1.00 39.14           N  
ATOM    593  N   GLU    87      12.352   1.907   0.555  1.00 14.35           N  
ATOM    594  CA  GLU    87      11.668   0.641   0.825  1.00 18.83           C  
ATOM    595  C   GLU    87      12.058  -0.083   2.092  1.00 16.10           C  
ATOM    596  O   GLU    87      11.344  -1.014   2.497  1.00 18.86           O  
ATOM    597  CB  GLU    87      11.829  -0.343  -0.352  1.00 16.40           C  
ATOM    598  CG  GLU    87      11.473   0.263  -1.727  1.00 24.26           C  
ATOM    599  CD  GLU    87      11.768  -0.673  -2.915  1.00 32.24           C  
ATOM    600  OE1 GLU    87      12.880  -1.247  -3.018  1.00 22.27           O  
ATOM    601  OE2 GLU    87      10.871  -0.822  -3.769  1.00 38.54           O  
ATOM    602  N   THR    88      13.181   0.284   2.702  1.00 14.31           N  
ATOM    603  CA  THR    88      13.659  -0.478   3.865  1.00 12.35           C  
ATOM    604  C   THR    88      13.197   0.081   5.223  1.00 14.22           C  
ATOM    605  O   THR    88      13.419  -0.547   6.228  1.00 14.68           O  
ATOM    606  CB  THR    88      15.204  -0.564   3.925  1.00 13.50           C  
ATOM    607  OG1 THR    88      15.751   0.750   4.057  1.00 14.98           O  
ATOM    608  CG2 THR    88      15.779  -1.252   2.680  1.00 16.24           C  
ATOM    609  N   ILE    89      12.594   1.267   5.235  1.00 12.41           N  
ATOM    610  CA  ILE    89      12.386   2.013   6.486  1.00 11.93           C  
ATOM    611  C   ILE    89      11.652   1.215   7.561  1.00 13.83           C  
ATOM    612  O   ILE    89      12.071   1.204   8.727  1.00 13.99           O  
ATOM    613  CB  ILE    89      11.719   3.394   6.209  1.00 14.69           C  
ATOM    614  CG1 ILE    89      11.573   4.220   7.504  1.00 12.66           C  
ATOM    615  CG2 ILE    89      10.379   3.264   5.465  1.00 15.13           C  
ATOM    616  CD1 ILE    89      12.869   4.423   8.248  1.00 14.32           C  
ATOM    617  N   PHE    90      10.607   0.498   7.154  1.00 14.71           N  
ATOM    618  CA  PHE    90       9.821  -0.247   8.141  1.00 14.60           C  
ATOM    619  C   PHE    90      10.538  -1.480   8.612  1.00 16.51           C  
ATOM    620  O   PHE    90      10.508  -1.789   9.792  1.00 16.36           O  
ATOM    621  CB  PHE    90       8.431  -0.572   7.621  1.00 14.85           C  
ATOM    622  CG  PHE    90       7.667   0.634   7.185  1.00 15.88           C  
ATOM    623  CD1 PHE    90       7.239   1.592   8.107  1.00 17.54           C  
ATOM    624  CD2 PHE    90       7.402   0.845   5.835  1.00 19.99           C  
ATOM    625  CE1 PHE    90       6.530   2.729   7.673  1.00 20.12           C  
ATOM    626  CE2 PHE    90       6.701   1.964   5.402  1.00 24.98           C  
ATOM    627  CZ  PHE    90       6.264   2.908   6.314  1.00 18.82           C  
ATOM    628  N   ASP    91      11.219  -2.166   7.698  1.00 13.68           N  
ATOM    629  CA  ASP    91      12.028  -3.312   8.096  1.00 13.68           C  
ATOM    630  C   ASP    91      13.162  -2.919   9.047  1.00 14.80           C  
ATOM    631  O   ASP    91      13.516  -3.670   9.977  1.00 16.34           O  
ATOM    632  CB  ASP    91      12.633  -3.997   6.862  1.00 17.52           C  
ATOM    633  CG  ASP    91      11.588  -4.694   5.996  1.00 24.50           C  
ATOM    634  OD1 ASP    91      10.492  -5.018   6.497  1.00 21.30           O  
ATOM    635  OD2 ASP    91      11.869  -4.923   4.799  1.00 25.94           O  
ATOM    636  N   ASP    92      13.744  -1.741   8.792  1.00 13.74           N  
ATOM    637  CA  ASP    92      14.841  -1.220   9.576  1.00 12.72           C  
ATOM    638  C   ASP    92      14.374  -0.880  10.980  1.00 13.13           C  
ATOM    639  O   ASP    92      15.044  -1.216  11.962  1.00 14.01           O  
ATOM    640  CB  ASP    92      15.394   0.057   8.928  1.00 13.56           C  
ATOM    641  CG  ASP    92      16.180  -0.193   7.654  1.00 17.23           C  
ATOM    642  OD1 ASP    92      16.647  -1.335   7.426  1.00 16.56           O  
ATOM    643  OD2 ASP    92      16.330   0.788   6.886  1.00 16.08           O  
ATOM    644  N   ILE    93      13.230  -0.204  11.067  1.00 12.18           N  
ATOM    645  CA  ILE    93      12.724   0.159  12.399  1.00 14.15           C  
ATOM    646  C   ILE    93      12.235  -1.093  13.129  1.00 17.32           C  
ATOM    647  O   ILE    93      12.549  -1.268  14.324  1.00 15.16           O  
ATOM    648  CB  ILE    93      11.617   1.219  12.327  1.00 13.03           C  
ATOM    649  CG1 ILE    93      12.191   2.564  11.848  1.00 12.61           C  
ATOM    650  CG2 ILE    93      11.000   1.412  13.719  1.00 14.05           C  
ATOM    651  CD1 ILE    93      11.121   3.600  11.455  1.00 12.35           C  
ATOM    652  N   ASP    94      11.502  -1.963  12.419  1.00 14.05           N  
ATOM    653  CA  ASP    94      11.083  -3.250  13.017  1.00 16.18           C  
ATOM    654  C   ASP    94      12.256  -3.979  13.665  1.00 15.42           C  
ATOM    655  O   ASP    94      12.155  -4.422  14.814  1.00 17.28           O  
ATOM    656  CB  ASP    94      10.513  -4.217  11.974  1.00 17.07           C  
ATOM    657  CG  ASP    94       9.121  -3.855  11.489  1.00 17.35           C  
ATOM    658  OD1 ASP    94       8.505  -2.885  11.987  1.00 18.27           O  
ATOM    659  OD2 ASP    94       8.633  -4.548  10.555  1.00 21.85           O  
ATOM    660  N   ARG    95      13.367  -4.122  12.932  1.00 15.58           N  
ATOM    661  CA  ARG    95      14.535  -4.842  13.428  1.00 16.07           C  
ATOM    662  C   ARG    95      15.118  -4.171  14.663  1.00 19.11           C  
ATOM    663  O   ARG    95      15.440  -4.833  15.641  1.00 18.91           O  
ATOM    664  CB  ARG    95      15.615  -4.981  12.348  1.00 20.99           C  
ATOM    665  CG  ARG    95      16.734  -5.950  12.716  1.00 29.41           C  
ATOM    666  CD  ARG    95      17.846  -6.022  11.666  1.00 35.92           C  
ATOM    667  NE  ARG    95      19.041  -5.272  12.063  1.00 53.69           N  
ATOM    668  CZ  ARG    95      20.279  -5.526  11.631  1.00 57.40           C  
ATOM    669  NH1 ARG    95      20.511  -6.528  10.781  1.00 50.29           N  
ATOM    670  NH2 ARG    95      21.295  -4.777  12.056  1.00 50.88           N  
ATOM    671  N   ALA    96      15.224  -2.839  14.627  1.00 15.34           N  
ATOM    672  CA  ALA    96      15.780  -2.102  15.748  1.00 15.93           C  
ATOM    673  C   ALA    96      14.919  -2.271  17.000  1.00 16.84           C  
ATOM    674  O   ALA    96      15.439  -2.511  18.081  1.00 17.65           O  
ATOM    675  CB  ALA    96      15.873  -0.633  15.370  1.00 16.45           C  
ATOM    676  N   LEU    97      13.605  -2.139  16.847  1.00 15.40           N  
ATOM    677  CA  LEU    97      12.680  -2.321  17.994  1.00 13.08           C  
ATOM    678  C   LEU    97      12.750  -3.730  18.579  1.00 16.91           C  
ATOM    679  O   LEU    97      12.794  -3.905  19.802  1.00 16.10           O  
ATOM    680  CB  LEU    97      11.253  -1.987  17.596  1.00 13.95           C  
ATOM    681  CG  LEU    97      11.014  -0.503  17.284  1.00 15.23           C  
ATOM    682  CD1 LEU    97       9.596  -0.311  16.828  1.00 17.81           C  
ATOM    683  CD2 LEU    97      11.298   0.351  18.487  1.00 16.90           C  
ATOM    684  N   ARG    98      12.784  -4.716  17.691  1.00 19.05           N  
ATOM    685  CA  ARG    98      12.877  -6.131  18.092  1.00 20.68           C  
ATOM    686  C   ARG    98      14.131  -6.358  18.933  1.00 20.56           C  
ATOM    687  O   ARG    98      14.065  -6.934  20.021  1.00 20.37           O  
ATOM    688  CB  ARG    98      12.881  -7.022  16.843  1.00 19.15           C  
ATOM    689  CG  ARG    98      12.874  -8.519  17.105  1.00 36.63           C  
ATOM    690  CD  ARG    98      12.535  -9.327  15.828  1.00 35.92           C  
ATOM    691  NE  ARG    98      13.244  -8.889  14.616  1.00 42.00           N  
ATOM    692  CZ  ARG    98      12.657  -8.384  13.527  1.00 49.87           C  
ATOM    693  NH1 ARG    98      11.336  -8.239  13.470  1.00 49.31           N  
ATOM    694  NH2 ARG    98      13.394  -8.022  12.482  1.00 44.13           N  
ATOM    695  N   GLU    99      15.250  -5.823  18.468  1.00 16.76           N  
ATOM    696  CA  GLU    99      16.506  -5.965  19.184  1.00 18.98           C  
ATOM    697  C   GLU    99      16.523  -5.234  20.527  1.00 21.82           C  
ATOM    698  O   GLU    99      17.222  -5.656  21.456  1.00 22.66           O  
ATOM    699  CB  GLU    99      17.666  -5.544  18.293  1.00 20.90           C  
ATOM    700  CG  GLU    99      17.841  -6.543  17.134  1.00 26.92           C  
ATOM    701  CD  GLU    99      18.967  -6.203  16.182  1.00 37.81           C  
ATOM    702  OE1 GLU    99      19.767  -5.310  16.503  1.00 37.69           O  
ATOM    703  OE2 GLU    99      19.052  -6.841  15.109  1.00 39.69           O  
ATOM    704  N   GLU   100      15.730  -4.167  20.641  1.00 17.11           N  
ATOM    705  CA  GLU   100      15.619  -3.454  21.902  1.00 17.75           C  
ATOM    706  C   GLU   100      14.556  -4.001  22.837  1.00 16.86           C  
ATOM    707  O   GLU   100      14.469  -3.550  23.983  1.00 20.47           O  
ATOM    708  CB  GLU   100      15.371  -1.964  21.640  1.00 18.83           C  
ATOM    709  CG  GLU   100      16.493  -1.253  20.883  1.00 18.10           C  
ATOM    710  CD  GLU   100      17.824  -1.244  21.638  1.00 31.26           C  
ATOM    711  OE1 GLU   100      17.809  -1.279  22.895  1.00 24.65           O  
ATOM    712  OE2 GLU   100      18.883  -1.200  20.968  1.00 30.33           O  
ATOM    713  N   GLY   101      13.760  -4.962  22.366  1.00 15.44           N  
ATOM    714  CA  GLY   101      12.667  -5.499  23.175  1.00 15.63           C  
ATOM    715  C   GLY   101      11.522  -4.517  23.332  1.00 15.58           C  
ATOM    716  O   GLY   101      10.802  -4.537  24.330  1.00 18.18           O  
ATOM    717  N   ILE   102      11.326  -3.662  22.335  1.00 14.55           N  
ATOM    718  CA  ILE   102      10.278  -2.661  22.376  1.00 12.71           C  
ATOM    719  C   ILE   102       9.208  -3.041  21.358  1.00 15.93           C  
ATOM    720  O   ILE   102       9.564  -3.350  20.214  1.00 16.82           O  
ATOM    721  CB  ILE   102      10.837  -1.270  22.004  1.00 13.71           C  
ATOM    722  CG1 ILE   102      11.898  -0.824  23.021  1.00 15.46           C  
ATOM    723  CG2 ILE   102       9.698  -0.240  21.874  1.00 13.97           C  
ATOM    724  CD1 ILE   102      12.686   0.444  22.609  1.00 13.84           C  
ATOM    725  N   GLU   103       7.930  -3.051  21.762  1.00 14.80           N  
ATOM    726  CA  GLU   103       6.819  -3.287  20.834  1.00 14.37           C  
ATOM    727  C   GLU   103       6.346  -1.975  20.207  1.00 16.25           C  
ATOM    728  O   GLU   103       6.170  -1.894  18.980  1.00 16.50           O  
ATOM    729  CB  GLU   103       5.666  -4.007  21.536  1.00 14.59           C  
ATOM    730  CG  GLU   103       4.478  -4.362  20.618  1.00 23.31           C  
ATOM    731  CD  GLU   103       4.731  -5.541  19.690  1.00 38.88           C  
ATOM    732  OE1 GLU   103       5.747  -6.263  19.848  1.00 40.58           O  
ATOM    733  OE2 GLU   103       3.890  -5.744  18.787  1.00 44.02           O  
ATOM    734  N   LYS   104       6.144  -0.967  21.058  1.00 11.97           N  
ATOM    735  CA  LYS   104       5.641   0.354  20.654  1.00 12.65           C  
ATOM    736  C   LYS   104       6.441   1.416  21.368  1.00 12.46           C  
ATOM    737  O   LYS   104       6.720   1.289  22.552  1.00 12.40           O  
ATOM    738  CB  LYS   104       4.160   0.551  20.980  1.00 14.66           C  
ATOM    739  CG  LYS   104       3.184  -0.415  20.278  1.00 15.66           C  
ATOM    740  CD  LYS   104       3.093  -0.147  18.783  1.00 17.92           C  
ATOM    741  CE  LYS   104       1.964  -0.991  18.176  1.00 18.93           C  
ATOM    742  NZ  LYS   104       1.927  -0.784  16.721  1.00 22.15           N  
ATOM    743  N   VAL   105       6.847   2.455  20.631  1.00 12.16           N  
ATOM    744  CA  VAL   105       7.670   3.513  21.208  1.00 10.51           C  
ATOM    745  C   VAL   105       6.772   4.544  21.856  1.00  9.96           C  
ATOM    746  O   VAL   105       5.568   4.609  21.587  1.00 12.50           O  
ATOM    747  CB  VAL   105       8.559   4.211  20.136  1.00 11.01           C  
ATOM    748  CG1 VAL   105       9.606   3.235  19.613  1.00 13.10           C  
ATOM    749  CG2 VAL   105       7.688   4.808  19.026  1.00 12.29           C  
ATOM    750  N   ASP   106       7.380   5.387  22.687  1.00 11.09           N  
ATOM    751  CA  ASP   106       6.613   6.395  23.402  1.00  9.99           C  
ATOM    752  C   ASP   106       6.445   7.655  22.573  1.00 12.17           C  
ATOM    753  O   ASP   106       5.420   8.311  22.669  1.00 12.24           O  
ATOM    754  CB  ASP   106       7.297   6.743  24.721  1.00 11.76           C  
ATOM    755  CG  ASP   106       7.472   5.526  25.608  1.00 10.29           C  
ATOM    756  OD1 ASP   106       6.536   5.239  26.395  1.00 14.19           O  
ATOM    757  OD2 ASP   106       8.523   4.866  25.562  1.00 10.87           O  
ATOM    758  N   ASP   107       7.462   8.022  21.776  1.00 10.50           N  
ATOM    759  CA  ASP   107       7.385   9.240  20.937  1.00 11.36           C  
ATOM    760  C   ASP   107       8.046   9.027  19.596  1.00  9.58           C  
ATOM    761  O   ASP   107       8.985   8.248  19.481  1.00 10.07           O  
ATOM    762  CB  ASP   107       8.101  10.413  21.595  1.00 11.91           C  
ATOM    763  CG  ASP   107       7.779  10.538  23.051  1.00 11.98           C  
ATOM    764  OD1 ASP   107       6.625  10.852  23.399  1.00 15.21           O  
ATOM    765  OD2 ASP   107       8.690  10.276  23.851  1.00 13.81           O  
ATOM    766  N   VAL   108       7.560   9.755  18.589  1.00  9.74           N  
ATOM    767  CA  VAL   108       8.268   9.888  17.329  1.00  8.61           C  
ATOM    768  C   VAL   108       8.518  11.387  17.167  1.00 11.05           C  
ATOM    769  O   VAL   108       7.583  12.208  17.282  1.00 11.94           O  
ATOM    770  CB  VAL   108       7.426   9.325  16.155  1.00 11.46           C  
ATOM    771  CG1 VAL   108       8.110   9.616  14.804  1.00 14.09           C  
ATOM    772  CG2 VAL   108       7.177   7.803  16.292  1.00 14.03           C  
ATOM    773  N   VAL   109       9.778  11.775  16.978  1.00  9.92           N  
ATOM    774  CA  VAL   109      10.097  13.186  16.779  1.00 11.54           C  
ATOM    775  C   VAL   109      10.829  13.345  15.470  1.00 10.98           C  
ATOM    776  O   VAL   109      11.574  12.456  15.072  1.00 12.56           O  
ATOM    777  CB  VAL   109      10.912  13.788  17.938  1.00 11.55           C  
ATOM    778  CG1 VAL   109      10.234  13.524  19.285  1.00 14.62           C  
ATOM    779  CG2 VAL   109      12.324  13.234  17.963  1.00 13.66           C  
ATOM    780  N   SER   110      10.605  14.469  14.782  1.00  9.10           N  
ATOM    781  CA  SER   110      11.280  14.712  13.524  1.00  9.63           C  
ATOM    782  C   SER   110      11.697  16.168  13.394  1.00  9.21           C  
ATOM    783  O   SER   110      10.871  17.076  13.572  1.00 10.64           O  
ATOM    784  CB  SER   110      10.339  14.386  12.377  1.00 11.38           C  
ATOM    785  OG  SER   110      10.906  14.752  11.108  1.00 12.49           O  
ATOM    786  N   ASP   111      12.975  16.367  13.054  1.00  9.78           N  
ATOM    787  CA  ASP   111      13.502  17.661  12.628  1.00 10.30           C  
ATOM    788  C   ASP   111      13.948  17.541  11.174  1.00 12.59           C  
ATOM    789  O   ASP   111      14.731  18.370  10.700  1.00 14.21           O  
ATOM    790  CB  ASP   111      14.678  18.042  13.517  1.00 12.34           C  
ATOM    791  CG  ASP   111      14.999  19.521  13.476  1.00 17.14           C  
ATOM    792  OD1 ASP   111      14.082  20.342  13.247  1.00 16.72           O  
ATOM    793  OD2 ASP   111      16.181  19.859  13.708  1.00 19.06           O  
ATOM    794  N   ALA   112      13.454  16.527  10.465  1.00 11.25           N  
ATOM    795  CA  ALA   112      13.892  16.275   9.078  1.00 11.10           C  
ATOM    796  C   ALA   112      13.422  17.377   8.141  1.00 13.86           C  
ATOM    797  O   ALA   112      12.283  17.843   8.214  1.00 13.37           O  
ATOM    798  CB  ALA   112      13.363  14.945   8.591  1.00 11.26           C  
ATOM    799  N   MET   113      14.327  17.730   7.238  1.00 13.40           N  
ATOM    800  CA  MET   113      14.080  18.704   6.191  1.00 13.40           C  
ATOM    801  C   MET   113      15.114  18.498   5.091  1.00 13.11           C  
ATOM    802  O   MET   113      16.267  18.145   5.370  1.00 13.85           O  
ATOM    803  CB  MET   113      14.123  20.131   6.730  1.00 14.46           C  
ATOM    804  CG  MET   113      13.833  21.222   5.677  1.00 13.23           C  
ATOM    805  SD  MET   113      12.116  20.916   4.727  0.70 15.43          SE  
ATOM    806  CE  MET   113      12.287  22.453   3.505  1.00 17.59           C  
ATOM    807  N   ALA   114      14.695  18.720   3.846  1.00 13.67           N  
ATOM    808  CA  ALA   114      15.638  18.631   2.739  1.00 16.40           C  
ATOM    809  C   ALA   114      16.282  19.987   2.529  1.00 15.41           C  
ATOM    810  O   ALA   114      16.163  20.856   3.367  1.00 14.70           O  
ATOM    811  CB  ALA   114      14.941  18.156   1.487  1.00 21.46           C  
ATOM    812  N   LYS   115      16.985  20.170   1.419  1.00 15.14           N  
ATOM    813  CA  LYS   115      17.557  21.487   1.150  1.00 15.78           C  
ATOM    814  C   LYS   115      16.471  22.577   1.046  1.00 13.07           C  
ATOM    815  O   LYS   115      15.398  22.359   0.466  1.00 14.83           O  
ATOM    816  CB  LYS   115      18.384  21.466  -0.133  1.00 17.66           C  
ATOM    817  CG  LYS   115      19.659  20.652  -0.013  1.00 20.06           C  
ATOM    818  CD  LYS   115      20.393  20.629  -1.344  1.00 19.58           C  
ATOM    819  CE  LYS   115      21.714  19.898  -1.250  1.00 29.22           C  
ATOM    820  NZ  LYS   115      22.368  19.836  -2.592  1.00 33.84           N  
ATOM    821  N   VAL   116      16.777  23.723   1.653  1.00 13.59           N  
ATOM    822  CA  VAL   116      15.891  24.882   1.767  0.50 13.96           C  
ATOM    824  C   VAL   116      16.070  25.782   0.530  1.00 15.19           C  
ATOM    825  O   VAL   116      17.210  26.085   0.148  1.00 14.70           O  
ATOM    826  CB  VAL   116      16.231  25.658   3.074  0.50 14.92           C  
ATOM    828  CG1 VAL   116      15.448  26.948   3.196  0.50 15.69           C  
ATOM    830  CG2 VAL   116      15.990  24.771   4.328  0.50 17.33           C  
ATOM    832  N   SER   117      14.963  26.201  -0.072  1.00 13.54           N  
ATOM    833  CA  SER   117      15.001  27.069  -1.247  1.00 11.53           C  
ATOM    834  C   SER   117      14.856  28.544  -0.888  1.00 13.31           C  
ATOM    835  O   SER   117      15.171  29.404  -1.713  1.00 15.65           O  
ATOM    836  CB  SER   117      13.865  26.696  -2.189  1.00 13.27           C  
ATOM    837  OG  SER   117      12.606  27.050  -1.610  1.00 13.68           O  
ATOM    838  N   GLY   118      14.357  28.833   0.316  1.00 13.72           N  
ATOM    839  CA  GLY   118      14.073  30.198   0.724  1.00 17.52           C  
ATOM    840  C   GLY   118      12.734  30.709   0.218  1.00 15.20           C  
ATOM    841  O   GLY   118      12.437  31.912   0.363  1.00 18.36           O  
ATOM    842  N   ILE   119      11.923  29.814  -0.356  1.00 13.99           N  
ATOM    843  CA  ILE   119      10.619  30.178  -0.913  1.00 14.12           C  
ATOM    844  C   ILE   119       9.579  29.446  -0.056  1.00 13.80           C  
ATOM    845  O   ILE   119       9.548  28.229  -0.039  1.00 13.42           O  
ATOM    846  CB  ILE   119      10.467  29.693  -2.378  1.00 11.69           C  
ATOM    847  CG1 ILE   119      11.576  30.223  -3.304  1.00 14.24           C  
ATOM    848  CG2 ILE   119       9.084  30.029  -2.926  1.00 13.99           C  
ATOM    849  CD1 ILE   119      11.731  31.748  -3.313  1.00 16.18           C  
ATOM    850  N   PRO   120       8.764  30.194   0.701  1.00 14.28           N  
ATOM    851  CA  PRO   120       7.815  29.543   1.612  1.00 14.71           C  
ATOM    852  C   PRO   120       6.972  28.435   0.981  1.00 13.91           C  
ATOM    853  O   PRO   120       6.846  27.379   1.580  1.00 13.07           O  
ATOM    854  CB  PRO   120       6.942  30.713   2.088  1.00 16.54           C  
ATOM    855  CG  PRO   120       7.921  31.876   2.108  1.00 20.48           C  
ATOM    856  CD  PRO   120       8.742  31.667   0.847  1.00 16.71           C  
ATOM    857  N   SER   121       6.428  28.623  -0.221  1.00 12.41           N  
ATOM    858  CA  SER   121       5.595  27.600  -0.829  1.00 13.18           C  
ATOM    859  C   SER   121       6.374  26.329  -1.122  1.00 13.95           C  
ATOM    860  O   SER   121       5.860  25.244  -0.874  1.00 13.03           O  
ATOM    861  CB  SER   121       4.922  28.091  -2.125  1.00 18.33           C  
ATOM    862  OG  SER   121       5.883  28.515  -3.077  1.00 19.51           O  
ATOM    863  N   ARG   122       7.592  26.473  -1.666  1.00 12.92           N  
ATOM    864  CA  ARG   122       8.398  25.294  -1.995  1.00 13.33           C  
ATOM    865  C   ARG   122       8.831  24.590  -0.738  1.00 12.54           C  
ATOM    866  O   ARG   122       8.801  23.361  -0.669  1.00 13.01           O  
ATOM    867  CB  ARG   122       9.651  25.680  -2.775  1.00 15.70           C  
ATOM    868  CG  ARG   122       9.384  26.107  -4.191  1.00 15.72           C  
ATOM    869  CD  ARG   122      10.687  26.421  -4.930  1.00 14.92           C  
ATOM    870  NE  ARG   122      11.477  25.204  -5.093  1.00 17.78           N  
ATOM    871  CZ  ARG   122      12.717  25.156  -5.578  1.00 17.08           C  
ATOM    872  NH1 ARG   122      13.334  26.269  -5.966  1.00 14.73           N  
ATOM    873  NH2 ARG   122      13.349  23.986  -5.663  1.00 17.62           N  
ATOM    874  N   ASP   123       9.271  25.360   0.249  1.00 10.85           N  
ATOM    875  CA  ASP   123       9.774  24.725   1.459  1.00 10.72           C  
ATOM    876  C   ASP   123       8.636  24.052   2.227  1.00 12.40           C  
ATOM    877  O   ASP   123       8.812  22.953   2.789  1.00 11.60           O  
ATOM    878  CB  ASP   123      10.555  25.712   2.309  1.00 12.96           C  
ATOM    879  CG  ASP   123      11.841  26.184   1.616  1.00 13.68           C  
ATOM    880  OD1 ASP   123      12.315  25.471   0.695  1.00 13.31           O  
ATOM    881  OD2 ASP   123      12.333  27.262   2.001  1.00 15.24           O  
ATOM    882  N   HIS   124       7.440  24.643   2.168  1.00 12.54           N  
ATOM    883  CA  HIS   124       6.249  23.987   2.702  1.00 11.00           C  
ATOM    884  C   HIS   124       6.013  22.648   2.010  1.00 10.83           C  
ATOM    885  O   HIS   124       5.754  21.621   2.647  1.00 11.93           O  
ATOM    886  CB  HIS   124       5.015  24.864   2.495  1.00 11.21           C  
ATOM    887  CG  HIS   124       3.734  24.178   2.840  1.00 10.23           C  
ATOM    888  ND1 HIS   124       3.462  23.724   4.115  1.00 11.30           N  
ATOM    889  CD2 HIS   124       2.654  23.865   2.088  1.00 11.04           C  
ATOM    890  CE1 HIS   124       2.268  23.155   4.129  1.00  9.49           C  
ATOM    891  NE2 HIS   124       1.770  23.205   2.906  1.00 10.84           N  
ATOM    892  N   ALA   125       6.081  22.645   0.677  1.00 11.36           N  
ATOM    893  CA  ALA   125       5.718  21.453  -0.065  1.00 12.11           C  
ATOM    894  C   ALA   125       6.604  20.251   0.294  1.00 11.47           C  
ATOM    895  O   ALA   125       6.107  19.136   0.534  1.00 13.45           O  
ATOM    896  CB  ALA   125       5.759  21.738  -1.578  1.00 13.21           C  
ATOM    897  N   VAL   126       7.910  20.508   0.352  1.00 11.41           N  
ATOM    898  CA  VAL   126       8.910  19.489   0.690  0.50 11.13           C  
ATOM    900  C   VAL   126       8.685  19.016   2.122  1.00 13.15           C  
ATOM    901  O   VAL   126       8.677  17.830   2.410  1.00 13.62           O  
ATOM    902  CB  VAL   126      10.345  20.061   0.529  0.50 10.09           C  
ATOM    904  CG1 VAL   126      11.411  19.100   1.079  0.50 11.60           C  
ATOM    906  CG2 VAL   126      10.613  20.356  -0.940  0.50 10.13           C  
ATOM    908  N   SER   127       8.487  19.987   3.015  1.00 11.21           N  
ATOM    909  CA  SER   127       8.267  19.704   4.430  0.50 10.89           C  
ATOM    911  C   SER   127       6.994  18.889   4.674  1.00 11.26           C  
ATOM    912  O   SER   127       6.967  18.010   5.536  1.00 11.71           O  
ATOM    913  CB  SER   127       8.213  21.012   5.205  0.50 13.85           C  
ATOM    915  OG  SER   127       8.144  20.775   6.582  0.50 12.04           O  
ATOM    917  N   TYR   128       5.929  19.213   3.931  1.00 10.99           N  
ATOM    918  CA  TYR   128       4.664  18.487   4.046  1.00 10.36           C  
ATOM    919  C   TYR   128       4.840  17.017   3.689  1.00 12.02           C  
ATOM    920  O   TYR   128       4.337  16.137   4.415  1.00 12.45           O  
ATOM    921  CB  TYR   128       3.616  19.131   3.143  1.00  9.90           C  
ATOM    922  CG  TYR   128       2.374  18.311   2.989  1.00 10.64           C  
ATOM    923  CD1 TYR   128       1.401  18.313   3.990  1.00 12.75           C  
ATOM    924  CD2 TYR   128       2.149  17.576   1.838  1.00 10.69           C  
ATOM    925  CE1 TYR   128       0.231  17.571   3.847  1.00 12.99           C  
ATOM    926  CE2 TYR   128       1.000  16.796   1.690  1.00 14.34           C  
ATOM    927  CZ  TYR   128       0.037  16.811   2.701  1.00 14.74           C  
ATOM    928  OH  TYR   128      -1.130  16.062   2.554  1.00 19.35           O  
ATOM    929  N   GLN   129       5.561  16.745   2.587  1.00 12.30           N  
ATOM    930  CA  GLN   129       5.778  15.368   2.159  0.50 11.89           C  
ATOM    932  C   GLN   129       6.551  14.579   3.213  1.00 11.90           C  
ATOM    933  O   GLN   129       6.223  13.433   3.494  1.00 13.97           O  
ATOM    934  CB  GLN   129       6.463  15.319   0.790  0.50 17.43           C  
ATOM    936  CG  GLN   129       5.564  15.766  -0.373  0.50 21.28           C  
ATOM    938  CD  GLN   129       4.328  14.888  -0.571  0.50 27.50           C  
ATOM    940  OE1 GLN   129       3.227  15.395  -0.790  0.50 37.10           O  
ATOM    942  NE2 GLN   129       4.507  13.573  -0.502  0.50 39.43           N  
ATOM    944  N   ILE   130       7.546  15.214   3.816  1.00 10.99           N  
ATOM    945  CA  ILE   130       8.265  14.597   4.924  1.00 11.28           C  
ATOM    946  C   ILE   130       7.298  14.331   6.093  1.00 10.32           C  
ATOM    947  O   ILE   130       7.309  13.247   6.687  1.00 11.94           O  
ATOM    948  CB  ILE   130       9.456  15.480   5.369  1.00 10.79           C  
ATOM    949  CG1 ILE   130      10.539  15.476   4.263  1.00 12.69           C  
ATOM    950  CG2 ILE   130       9.987  15.048   6.769  1.00 11.24           C  
ATOM    951  CD1 ILE   130      11.663  16.488   4.451  1.00 13.94           C  
ATOM    952  N   GLY   131       6.468  15.325   6.412  1.00 10.56           N  
ATOM    953  CA  GLY   131       5.536  15.217   7.541  1.00 10.56           C  
ATOM    954  C   GLY   131       4.578  14.052   7.347  1.00 12.07           C  
ATOM    955  O   GLY   131       4.317  13.291   8.292  1.00 12.17           O  
ATOM    956  N   GLN   132       4.050  13.892   6.134  1.00 12.52           N  
ATOM    957  CA  GLN   132       3.177  12.763   5.827  1.00 13.85           C  
ATOM    958  C   GLN   132       3.827  11.420   6.131  1.00 11.58           C  
ATOM    959  O   GLN   132       3.199  10.536   6.740  1.00 13.19           O  
ATOM    960  CB  GLN   132       2.736  12.814   4.359  1.00 13.17           C  
ATOM    961  CG  GLN   132       1.733  13.902   4.071  1.00 16.82           C  
ATOM    962  CD  GLN   132       0.401  13.611   4.732  1.00 20.54           C  
ATOM    963  OE1 GLN   132       0.089  14.171   5.780  1.00 22.06           O  
ATOM    964  NE2 GLN   132      -0.378  12.700   4.144  1.00 24.13           N  
ATOM    965  N   ARG   133       5.088  11.261   5.723  1.00 11.88           N  
ATOM    966  CA  ARG   133       5.782   9.999   5.936  1.00 11.18           C  
ATOM    967  C   ARG   133       6.121   9.800   7.426  1.00 10.84           C  
ATOM    968  O   ARG   133       6.039   8.693   7.944  1.00 12.01           O  
ATOM    969  CB  ARG   133       7.005   9.914   5.020  1.00 12.43           C  
ATOM    970  CG  ARG   133       7.758   8.586   5.061  1.00 13.14           C  
ATOM    971  CD  ARG   133       6.902   7.426   4.535  1.00 14.39           C  
ATOM    972  NE  ARG   133       7.781   6.378   4.031  1.00 18.04           N  
ATOM    973  CZ  ARG   133       7.380   5.306   3.371  1.00 15.95           C  
ATOM    974  NH1 ARG   133       6.083   5.109   3.148  1.00 18.22           N  
ATOM    975  NH2 ARG   133       8.277   4.420   2.952  1.00 17.71           N  
ATOM    976  N   VAL   134       6.483  10.879   8.117  1.00 11.86           N  
ATOM    977  CA  VAL   134       6.704  10.813   9.564  1.00 11.94           C  
ATOM    978  C   VAL   134       5.443  10.329  10.269  1.00 10.69           C  
ATOM    979  O   VAL   134       5.500   9.471  11.160  1.00 12.44           O  
ATOM    980  CB  VAL   134       7.171  12.173  10.137  1.00 11.36           C  
ATOM    981  CG1 VAL   134       7.164  12.156  11.665  1.00 11.92           C  
ATOM    982  CG2 VAL   134       8.567  12.493   9.608  1.00 13.37           C  
ATOM    983  N   MET   135       4.291  10.852   9.860  1.00 11.80           N  
ATOM    984  CA  MET   135       3.045  10.414  10.507  1.00 12.72           C  
ATOM    985  C   MET   135       2.715   8.968  10.190  1.00 12.07           C  
ATOM    986  O   MET   135       2.195   8.258  11.064  1.00 12.57           O  
ATOM    987  CB  MET   135       1.880  11.317  10.131  1.00 13.33           C  
ATOM    988  CG  MET   135       2.034  12.771  10.541  1.00 14.97           C  
ATOM    989  SD  MET   135       2.476  12.977  12.442  0.70 14.74          SE  
ATOM    990  CE  MET   135       0.918  12.078  13.211  1.00 17.71           C  
ATOM    991  N   GLU   136       3.011   8.522   8.968  1.00 13.34           N  
ATOM    992  CA  GLU   136       2.786   7.116   8.638  1.00 14.66           C  
ATOM    993  C   GLU   136       3.637   6.218   9.539  1.00 13.86           C  
ATOM    994  O   GLU   136       3.169   5.190  10.048  1.00 14.68           O  
ATOM    995  CB  GLU   136       3.073   6.851   7.158  1.00 14.11           C  
ATOM    996  CG  GLU   136       2.850   5.419   6.721  1.00 19.12           C  
ATOM    997  CD  GLU   136       3.271   5.132   5.281  1.00 25.99           C  
ATOM    998  OE1 GLU   136       3.825   6.028   4.592  1.00 22.32           O  
ATOM    999  OE2 GLU   136       3.039   3.978   4.856  1.00 26.05           O  
ATOM   1000  N   ILE   137       4.866   6.651   9.806  1.00 11.87           N  
ATOM   1001  CA  ILE   137       5.759   5.917  10.725  1.00 12.27           C  
ATOM   1002  C   ILE   137       5.200   5.972  12.152  1.00 14.18           C  
ATOM   1003  O   ILE   137       5.159   4.958  12.879  1.00 14.08           O  
ATOM   1004  CB  ILE   137       7.197   6.523  10.671  1.00 14.79           C  
ATOM   1005  CG1 ILE   137       7.818   6.226   9.301  1.00 14.66           C  
ATOM   1006  CG2 ILE   137       8.092   6.057  11.823  1.00 17.41           C  
ATOM   1007  CD1 ILE   137       9.049   7.054   8.968  1.00 14.56           C  
ATOM   1008  N   ALA   138       4.756   7.155  12.564  1.00 13.36           N  
ATOM   1009  CA  ALA   138       4.239   7.308  13.920  1.00 15.50           C  
ATOM   1010  C   ALA   138       3.055   6.392  14.183  1.00 17.10           C  
ATOM   1011  O   ALA   138       3.029   5.691  15.197  1.00 17.07           O  
ATOM   1012  CB  ALA   138       3.863   8.740  14.187  1.00 14.77           C  
ATOM   1013  N   VAL   139       2.076   6.364  13.290  1.00 14.22           N  
ATOM   1014  CA  VAL   139       0.893   5.559  13.602  1.00 17.81           C  
ATOM   1015  C   VAL   139       1.211   4.051  13.593  1.00 16.57           C  
ATOM   1016  O   VAL   139       0.520   3.268  14.255  1.00 18.88           O  
ATOM   1017  CB  VAL   139      -0.350   5.940  12.747  1.00 25.03           C  
ATOM   1018  CG1 VAL   139      -0.700   7.418  12.942  1.00 23.47           C  
ATOM   1019  CG2 VAL   139      -0.116   5.632  11.315  1.00 23.85           C  
ATOM   1020  N   ARG   140       2.260   3.651  12.881  1.00 14.60           N  
ATOM   1021  CA  ARG   140       2.713   2.272  12.855  1.00 14.63           C  
ATOM   1022  C   ARG   140       3.375   1.842  14.176  1.00 14.50           C  
ATOM   1023  O   ARG   140       3.273   0.670  14.584  1.00 16.94           O  
ATOM   1024  CB  ARG   140       3.722   2.106  11.729  1.00 17.48           C  
ATOM   1025  CG  ARG   140       4.114   0.710  11.407  1.00 23.55           C  
ATOM   1026  CD  ARG   140       4.253   0.612   9.922  1.00 28.61           C  
ATOM   1027  NE  ARG   140       4.768  -0.681   9.510  1.00 35.75           N  
ATOM   1028  CZ  ARG   140       4.692  -1.131   8.267  1.00 23.47           C  
ATOM   1029  NH1 ARG   140       4.095  -0.390   7.329  1.00 25.25           N  
ATOM   1030  NH2 ARG   140       5.191  -2.319   7.969  1.00 33.07           N  
ATOM   1031  N   TYR   141       4.078   2.770  14.845  1.00 12.86           N  
ATOM   1032  CA  TYR   141       4.960   2.361  15.935  1.00 12.52           C  
ATOM   1033  C   TYR   141       4.629   2.955  17.296  1.00 10.49           C  
ATOM   1034  O   TYR   141       5.192   2.517  18.288  1.00 11.91           O  
ATOM   1035  CB  TYR   141       6.417   2.676  15.606  1.00 11.72           C  
ATOM   1036  CG  TYR   141       6.939   1.896  14.435  1.00 15.03           C  
ATOM   1037  CD1 TYR   141       7.106   0.514  14.520  1.00 15.39           C  
ATOM   1038  CD2 TYR   141       7.242   2.533  13.239  1.00 15.09           C  
ATOM   1039  CE1 TYR   141       7.577  -0.210  13.439  1.00 16.45           C  
ATOM   1040  CE2 TYR   141       7.712   1.832  12.159  1.00 17.80           C  
ATOM   1041  CZ  TYR   141       7.872   0.467  12.249  1.00 17.33           C  
ATOM   1042  OH  TYR   141       8.350  -0.169  11.125  1.00 18.29           O  
ATOM   1043  N   LEU   142       3.742   3.950  17.349  1.00 10.86           N  
ATOM   1044  CA  LEU   142       3.441   4.618  18.622  0.50 11.36           C  
ATOM   1046  C   LEU   142       2.571   3.806  19.548  1.00 13.48           C  
ATOM   1047  O   LEU   142       1.594   3.191  19.112  1.00 14.78           O  
ATOM   1048  CB  LEU   142       2.723   5.941  18.416  0.50 11.66           C  
ATOM   1050  CG  LEU   142       3.563   7.179  18.176  0.50  9.60           C  
ATOM   1052  CD1 LEU   142       2.600   8.224  17.674  0.50 14.73           C  
ATOM   1054  CD2 LEU   142       4.278   7.649  19.457  0.50 11.81           C  
ATOM   1056  N   ARG   143       2.901   3.846  20.837  1.00 12.69           N  
ATOM   1057  CA  ARG   143       2.033   3.237  21.845  1.00 13.33           C  
ATOM   1058  C   ARG   143       0.826   4.130  22.018  1.00 14.30           C  
ATOM   1059  O   ARG   143       0.884   5.351  21.765  1.00 14.62           O  
ATOM   1060  CB  ARG   143       2.752   3.055  23.194  1.00 15.19           C  
ATOM   1061  CG  ARG   143       3.082   4.318  23.972  1.00 13.79           C  
ATOM   1062  CD  ARG   143       3.539   3.944  25.394  1.00 16.54           C  
ATOM   1063  NE  ARG   143       3.892   5.104  26.190  1.00 18.51           N  
ATOM   1064  CZ  ARG   143       3.032   5.816  26.914  1.00 20.32           C  
ATOM   1065  NH1 ARG   143       1.738   5.491  26.943  1.00 23.94           N  
ATOM   1066  NH2 ARG   143       3.464   6.847  27.622  1.00 24.25           N  
ATOM   1067  N   ASN   144      -0.271   3.530  22.476  1.00 15.98           N  
ATOM   1068  CA  ASN   144      -1.406   4.304  22.952  0.50 16.67           C  
ATOM   1070  C   ASN   144      -0.921   5.238  24.030  1.00 14.32           C  
ATOM   1071  O   ASN   144      -0.252   4.786  24.965  1.00 16.71           O  
ATOM   1072  CB  ASN   144      -2.467   3.388  23.551  0.50 15.10           C  
ATOM   1074  CG  ASN   144      -3.203   2.613  22.509  0.50 27.23           C  
ATOM   1076  OD1 ASN   144      -3.474   3.128  21.432  0.50 29.27           O  
ATOM   1078  ND2 ASN   144      -3.542   1.362  22.818  0.50 20.43           N  
ATOM   1080  N   GLY   145      -1.245   6.519  23.892  1.00 13.95           N  
ATOM   1081  CA  GLY   145      -0.760   7.549  24.793  1.00 13.60           C  
ATOM   1082  C   GLY   145       0.538   8.244  24.347  1.00 15.52           C  
ATOM   1083  O   GLY   145       1.003   9.170  25.010  1.00 19.43           O  
ATOM   1084  N   GLY   146       1.119   7.788  23.235  1.00 14.32           N  
ATOM   1085  CA  GLY   146       2.390   8.342  22.745  1.00 14.96           C  
ATOM   1086  C   GLY   146       2.242   9.696  22.063  1.00 12.11           C  
ATOM   1087  O   GLY   146       1.129  10.096  21.713  1.00 12.15           O  
ATOM   1088  N   ASN   147       3.368  10.378  21.882  1.00 12.02           N  
ATOM   1089  CA  ASN   147       3.384  11.718  21.315  1.00 10.79           C  
ATOM   1090  C   ASN   147       4.188  11.817  20.029  1.00 11.00           C  
ATOM   1091  O   ASN   147       5.095  11.005  19.790  1.00 10.12           O  
ATOM   1092  CB  ASN   147       4.028  12.711  22.298  1.00 13.03           C  
ATOM   1093  CG  ASN   147       3.254  12.859  23.595  1.00 14.49           C  
ATOM   1094  OD1 ASN   147       2.062  12.540  23.674  1.00 14.43           O  
ATOM   1095  ND2 ASN   147       3.935  13.349  24.618  1.00 15.04           N  
ATOM   1096  N   VAL   148       3.875  12.836  19.229  1.00 10.08           N  
ATOM   1097  CA  VAL   148       4.678  13.200  18.054  1.00 10.32           C  
ATOM   1098  C   VAL   148       5.112  14.659  18.127  1.00 10.96           C  
ATOM   1099  O   VAL   148       4.328  15.526  18.524  1.00 12.33           O  
ATOM   1100  CB  VAL   148       3.911  12.970  16.729  1.00 11.82           C  
ATOM   1101  CG1 VAL   148       4.750  13.388  15.517  1.00 13.57           C  
ATOM   1102  CG2 VAL   148       3.550  11.547  16.594  1.00 13.33           C  
ATOM   1103  N   LEU   149       6.360  14.917  17.737  1.00  9.54           N  
ATOM   1104  CA  LEU   149       6.847  16.284  17.535  1.00 10.13           C  
ATOM   1105  C   LEU   149       7.401  16.330  16.129  1.00  9.76           C  
ATOM   1106  O   LEU   149       8.202  15.491  15.769  1.00 10.76           O  
ATOM   1107  CB  LEU   149       7.977  16.622  18.518  1.00 12.13           C  
ATOM   1108  CG  LEU   149       8.880  17.829  18.198  1.00 11.89           C  
ATOM   1109  CD1 LEU   149       8.058  19.099  18.208  1.00 13.01           C  
ATOM   1110  CD2 LEU   149      10.021  17.909  19.210  1.00 14.70           C  
ATOM   1111  N   LEU   150       6.970  17.296  15.313  1.00  8.99           N  
ATOM   1112  CA  LEU   150       7.511  17.380  13.962  0.50 11.44           C  
ATOM   1114  C   LEU   150       7.656  18.800  13.473  1.00 12.24           C  
ATOM   1115  O   LEU   150       6.793  19.675  13.686  1.00 12.49           O  
ATOM   1116  CB  LEU   150       6.712  16.536  12.949  0.50 20.07           C  
ATOM   1118  CG  LEU   150       5.352  17.056  12.470  0.50 21.76           C  
ATOM   1120  CD1 LEU   150       5.133  16.793  10.984  0.50 23.31           C  
ATOM   1122  CD2 LEU   150       4.213  16.474  13.281  0.50 26.23           C  
ATOM   1124  N   LYS   151       8.809  19.031  12.839  1.00 11.05           N  
ATOM   1125  CA  LYS   151       9.069  20.312  12.200  1.00 12.47           C  
ATOM   1126  C   LYS   151       8.279  20.375  10.888  1.00 12.07           C  
ATOM   1127  O   LYS   151       8.258  19.406  10.103  1.00 11.40           O  
ATOM   1128  CB  LYS   151      10.563  20.476  11.890  1.00 15.74           C  
ATOM   1129  CG  LYS   151      10.857  21.850  11.284  1.00 15.82           C  
ATOM   1130  CD  LYS   151      12.303  22.226  11.298  1.00 23.41           C  
ATOM   1131  CE  LYS   151      13.066  21.415  10.296  1.00 23.56           C  
ATOM   1132  NZ  LYS   151      14.517  21.541  10.640  1.00 28.21           N  
ATOM   1133  N   GLN   152       7.663  21.529  10.632  1.00 11.33           N  
ATOM   1134  CA  GLN   152       7.024  21.794   9.346  1.00  9.32           C  
ATOM   1135  C   GLN   152       7.236  23.254   8.961  1.00 13.53           C  
ATOM   1136  O   GLN   152       7.270  24.131   9.811  1.00 16.85           O  
ATOM   1137  CB  GLN   152       5.521  21.478   9.397  1.00 11.40           C  
ATOM   1138  CG  GLN   152       4.805  21.567   8.029  1.00 12.88           C  
ATOM   1139  CD  GLN   152       3.428  20.909   7.999  1.00 15.18           C  
ATOM   1140  OE1 GLN   152       2.407  21.585   7.807  1.00 16.33           O  
ATOM   1141  NE2 GLN   152       3.394  19.588   8.162  1.00 13.42           N  
ATOM   1142  N   PHE   153       7.390  23.505   7.673  1.00 11.92           N  
ATOM   1143  CA  PHE   153       7.368  24.860   7.177  1.00 13.28           C  
ATOM   1144  C   PHE   153       5.909  25.142   6.823  1.00 12.52           C  
ATOM   1145  O   PHE   153       5.315  24.398   6.033  1.00 14.65           O  
ATOM   1146  CB  PHE   153       8.313  24.968   5.976  1.00 16.75           C  
ATOM   1147  CG  PHE   153       9.772  25.034   6.367  1.00 15.41           C  
ATOM   1148  CD1 PHE   153      10.418  26.266   6.415  1.00 23.92           C  
ATOM   1149  CD2 PHE   153      10.488  23.902   6.733  1.00 18.53           C  
ATOM   1150  CE1 PHE   153      11.767  26.364   6.787  1.00 25.02           C  
ATOM   1151  CE2 PHE   153      11.851  24.006   7.130  1.00 18.44           C  
ATOM   1152  CZ  PHE   153      12.476  25.232   7.132  1.00 23.62           C  
ATOM   1153  N   GLN   154       5.336  26.191   7.414  1.00 12.75           N  
ATOM   1154  CA  GLN   154       3.898  26.435   7.325  1.00 14.37           C  
ATOM   1155  C   GLN   154       3.474  26.798   5.902  1.00 14.38           C  
ATOM   1156  O   GLN   154       4.179  27.504   5.181  1.00 13.34           O  
ATOM   1157  CB  GLN   154       3.497  27.565   8.284  1.00 18.17           C  
ATOM   1158  CG  GLN   154       1.971  27.723   8.437  1.00 23.89           C  
ATOM   1159  CD  GLN   154       1.567  28.266   9.789  1.00 37.14           C  
ATOM   1160  OE1 GLN   154       2.246  29.124  10.356  1.00 41.97           O  
ATOM   1161  NE2 GLN   154       0.451  27.766  10.318  1.00 46.60           N  
ATOM   1162  N   GLY   155       2.301  26.314   5.515  1.00 11.64           N  
ATOM   1163  CA  GLY   155       1.732  26.708   4.223  1.00 11.82           C  
ATOM   1164  C   GLY   155       0.327  26.182   4.073  1.00 11.40           C  
ATOM   1165  O   GLY   155      -0.336  25.849   5.060  1.00 12.08           O  
ATOM   1166  N   ASP   156      -0.138  26.104   2.830  1.00 11.38           N  
ATOM   1167  CA  ASP   156      -1.538  25.804   2.554  1.00 12.44           C  
ATOM   1168  C   ASP   156      -1.982  24.534   3.272  1.00 13.47           C  
ATOM   1169  O   ASP   156      -3.104  24.452   3.772  1.00 14.62           O  
ATOM   1170  CB  ASP   156      -1.768  25.664   1.048  1.00 11.62           C  
ATOM   1171  CG  ASP   156      -1.751  26.999   0.330  1.00 14.84           C  
ATOM   1172  OD1 ASP   156      -1.882  28.041   1.006  1.00 13.69           O  
ATOM   1173  OD2 ASP   156      -1.606  27.007  -0.911  1.00 14.10           O  
ATOM   1174  N   MET   157      -1.095  23.545   3.319  1.00 11.53           N  
ATOM   1175  CA  MET   157      -1.484  22.182   3.659  1.00 12.40           C  
ATOM   1176  C   MET   157      -1.526  21.982   5.170  1.00 10.48           C  
ATOM   1177  O   MET   157      -1.946  20.932   5.656  1.00 12.88           O  
ATOM   1178  CB  MET   157      -0.524  21.176   3.022  1.00 13.36           C  
ATOM   1179  CG  MET   157      -0.571  21.150   1.503  1.00 11.62           C  
ATOM   1180  SD  MET   157      -2.370  20.854   0.810  0.70 16.42          SE  
ATOM   1181  CE  MET   157      -2.754  19.154   1.684  1.00 16.01           C  
ATOM   1182  N   THR   158      -1.087  22.996   5.909  1.00 11.91           N  
ATOM   1183  CA  THR   158      -0.832  22.849   7.346  1.00 11.22           C  
ATOM   1184  C   THR   158      -2.101  22.627   8.154  1.00 13.90           C  
ATOM   1185  O   THR   158      -2.183  21.670   8.935  1.00 11.92           O  
ATOM   1186  CB  THR   158      -0.027  24.021   7.916  1.00 12.96           C  
ATOM   1187  OG1 THR   158       1.250  24.065   7.252  1.00 12.46           O  
ATOM   1188  CG2 THR   158       0.188  23.831   9.441  1.00 15.05           C  
ATOM   1189  N   ASN   159      -3.103  23.472   7.928  1.00 13.35           N  
ATOM   1190  CA  ASN   159      -4.340  23.307   8.693  1.00 14.30           C  
ATOM   1191  C   ASN   159      -5.052  22.013   8.390  1.00 12.35           C  
ATOM   1192  O   ASN   159      -5.561  21.352   9.306  1.00 15.82           O  
ATOM   1193  CB  ASN   159      -5.285  24.484   8.480  1.00 16.47           C  
ATOM   1194  CG  ASN   159      -4.833  25.709   9.213  1.00 21.05           C  
ATOM   1195  OD1 ASN   159      -3.877  25.658   9.986  1.00 22.39           O  
ATOM   1196  ND2 ASN   159      -5.512  26.828   8.978  1.00 24.55           N  
ATOM   1197  N   ASP   160      -5.045  21.608   7.117  1.00 13.38           N  
ATOM   1198  CA  ASP   160      -5.652  20.343   6.741  0.50 12.59           C  
ATOM   1200  C   ASP   160      -4.886  19.124   7.297  1.00 14.86           C  
ATOM   1201  O   ASP   160      -5.504  18.139   7.723  1.00 17.44           O  
ATOM   1202  CB  ASP   160      -5.838  20.269   5.214  0.50 16.57           C  
ATOM   1204  CG  ASP   160      -7.056  21.076   4.719  0.50 22.87           C  
ATOM   1206  OD1 ASP   160      -7.115  22.314   4.906  0.50 15.88           O  
ATOM   1208  OD2 ASP   160      -7.956  20.470   4.094  0.50 19.25           O  
ATOM   1210  N   PHE   161      -3.549  19.211   7.316  1.00 14.31           N  
ATOM   1211  CA  PHE   161      -2.656  18.197   7.890  1.00 14.03           C  
ATOM   1212  C   PHE   161      -3.006  17.995   9.378  1.00 11.91           C  
ATOM   1213  O   PHE   161      -3.197  16.851   9.829  1.00 14.86           O  
ATOM   1214  CB  PHE   161      -1.192  18.665   7.692  1.00 12.85           C  
ATOM   1215  CG  PHE   161      -0.150  17.778   8.326  1.00 12.52           C  
ATOM   1216  CD1 PHE   161       0.404  16.743   7.591  1.00 15.17           C  
ATOM   1217  CD2 PHE   161       0.321  18.003   9.640  1.00 12.26           C  
ATOM   1218  CE1 PHE   161       1.376  15.926   8.139  1.00 15.39           C  
ATOM   1219  CE2 PHE   161       1.292  17.175  10.192  1.00 14.73           C  
ATOM   1220  CZ  PHE   161       1.819  16.153   9.435  1.00 14.16           C  
ATOM   1221  N   ILE   162      -3.104  19.107  10.108  1.00 12.59           N  
ATOM   1222  CA  ILE   162      -3.429  19.063  11.516  1.00 13.26           C  
ATOM   1223  C   ILE   162      -4.823  18.505  11.726  1.00 14.67           C  
ATOM   1224  O   ILE   162      -4.990  17.642  12.585  1.00 17.12           O  
ATOM   1225  CB  ILE   162      -3.250  20.441  12.162  1.00 13.98           C  
ATOM   1226  CG1 ILE   162      -1.761  20.787  12.181  1.00 15.65           C  
ATOM   1227  CG2 ILE   162      -3.835  20.489  13.604  1.00 16.81           C  
ATOM   1228  CD1 ILE   162      -1.495  22.170  12.613  1.00 16.81           C  
ATOM   1229  N   ALA   163      -5.789  18.953  10.912  1.00 13.67           N  
ATOM   1230  CA  ALA   163      -7.183  18.497  11.059  1.00 15.76           C  
ATOM   1231  C   ALA   163      -7.291  16.988  10.871  1.00 17.54           C  
ATOM   1232  O   ALA   163      -8.055  16.321  11.584  1.00 20.78           O  
ATOM   1233  CB  ALA   163      -8.095  19.224  10.095  1.00 17.98           C  
ATOM   1234  N   ILE   164      -6.536  16.441   9.913  1.00 15.90           N  
ATOM   1235  CA  ILE   164      -6.589  15.011   9.610  1.00 16.22           C  
ATOM   1236  C   ILE   164      -5.888  14.208  10.704  1.00 19.24           C  
ATOM   1237  O   ILE   164      -6.469  13.282  11.287  1.00 20.94           O  
ATOM   1238  CB  ILE   164      -6.008  14.690   8.200  1.00 19.88           C  
ATOM   1239  CG1 ILE   164      -6.947  15.210   7.097  1.00 22.44           C  
ATOM   1240  CG2 ILE   164      -5.752  13.191   8.028  1.00 22.35           C  
ATOM   1241  CD1 ILE   164      -6.292  15.382   5.739  1.00 28.45           C  
ATOM   1242  N   TRP   165      -4.650  14.577  11.016  1.00 15.75           N  
ATOM   1243  CA  TRP   165      -3.852  13.749  11.922  1.00 19.10           C  
ATOM   1244  C   TRP   165      -4.288  13.829  13.376  1.00 15.64           C  
ATOM   1245  O   TRP   165      -4.101  12.864  14.129  1.00 18.93           O  
ATOM   1246  CB  TRP   165      -2.349  14.030  11.765  1.00 16.07           C  
ATOM   1247  CG  TRP   165      -1.815  13.501  10.472  1.00 15.98           C  
ATOM   1248  CD1 TRP   165      -1.403  14.233   9.384  1.00 17.48           C  
ATOM   1249  CD2 TRP   165      -1.671  12.121  10.097  1.00 14.31           C  
ATOM   1250  NE1 TRP   165      -0.997  13.397   8.376  1.00 16.98           N  
ATOM   1251  CE2 TRP   165      -1.163  12.098   8.779  1.00 17.19           C  
ATOM   1252  CE3 TRP   165      -1.905  10.903  10.753  1.00 18.10           C  
ATOM   1253  CZ2 TRP   165      -0.875  10.903   8.105  1.00 17.54           C  
ATOM   1254  CZ3 TRP   165      -1.634   9.719  10.074  1.00 17.05           C  
ATOM   1255  CH2 TRP   165      -1.119   9.728   8.771  1.00 19.78           C  
ATOM   1256  N   ARG   166      -4.891  14.955  13.767  1.00 14.46           N  
ATOM   1257  CA  ARG   166      -5.303  15.123  15.173  1.00 17.91           C  
ATOM   1258  C   ARG   166      -6.444  14.205  15.583  1.00 18.87           C  
ATOM   1259  O   ARG   166      -6.679  14.029  16.777  1.00 22.29           O  
ATOM   1260  CB  ARG   166      -5.641  16.572  15.522  1.00 22.23           C  
ATOM   1261  CG  ARG   166      -6.984  17.076  15.044  1.00 22.75           C  
ATOM   1262  CD  ARG   166      -7.045  18.555  15.325  1.00 33.12           C  
ATOM   1263  NE  ARG   166      -8.271  19.178  14.863  1.00 34.39           N  
ATOM   1264  CZ  ARG   166      -9.360  19.321  15.608  1.00 42.29           C  
ATOM   1265  NH1 ARG   166     -10.426  19.909  15.088  1.00 44.12           N  
ATOM   1266  NH2 ARG   166      -9.383  18.880  16.860  1.00 38.24           N  
ATOM   1267  N   LYS   167      -7.109  13.605  14.595  1.00 20.24           N  
ATOM   1268  CA  LYS   167      -8.148  12.593  14.833  1.00 22.36           C  
ATOM   1269  C   LYS   167      -7.604  11.337  15.528  1.00 23.24           C  
ATOM   1270  O   LYS   167      -8.370  10.587  16.133  1.00 23.92           O  
ATOM   1271  CB  LYS   167      -8.811  12.209  13.513  1.00 21.65           C  
ATOM   1272  CG  LYS   167      -9.668  13.306  12.912  1.00 25.38           C  
ATOM   1273  CD  LYS   167     -10.216  12.866  11.556  1.00 37.24           C  
ATOM   1274  CE  LYS   167     -11.133  13.921  10.960  1.00 47.22           C  
ATOM   1275  NZ  LYS   167     -11.554  13.576   9.571  1.00 57.19           N  
ATOM   1276  N   ASN   168      -6.291  11.106  15.434  1.00 20.02           N  
ATOM   1277  CA  ASN   168      -5.632   9.961  16.092  1.00 21.18           C  
ATOM   1278  C   ASN   168      -5.032  10.308  17.460  1.00 17.20           C  
ATOM   1279  O   ASN   168      -4.284   9.511  18.038  1.00 18.97           O  
ATOM   1280  CB  ASN   168      -4.524   9.384  15.204  1.00 24.01           C  
ATOM   1281  CG  ASN   168      -4.997   9.070  13.807  1.00 29.97           C  
ATOM   1282  OD1 ASN   168      -5.571   8.016  13.556  1.00 38.36           O  
ATOM   1283  ND2 ASN   168      -4.750   9.988  12.884  1.00 35.11           N  
ATOM   1284  N   PHE   169      -5.329  11.504  17.958  1.00 17.50           N  
ATOM   1285  CA  PHE   169      -4.700  12.009  19.172  1.00 19.00           C  
ATOM   1286  C   PHE   169      -5.681  12.734  20.095  1.00 19.40           C  
ATOM   1287  O   PHE   169      -6.741  13.197  19.659  1.00 22.92           O  
ATOM   1288  CB  PHE   169      -3.525  12.940  18.830  1.00 15.77           C  
ATOM   1289  CG  PHE   169      -2.365  12.233  18.154  1.00 13.65           C  
ATOM   1290  CD1 PHE   169      -1.297  11.733  18.900  1.00 12.61           C  
ATOM   1291  CD2 PHE   169      -2.314  12.125  16.767  1.00 12.39           C  
ATOM   1292  CE1 PHE   169      -0.211  11.096  18.262  1.00 12.66           C  
ATOM   1293  CE2 PHE   169      -1.247  11.496  16.134  1.00 12.84           C  
ATOM   1294  CZ  PHE   169      -0.203  10.980  16.878  1.00 13.03           C  
ATOM   1295  N   SER   170      -5.303  12.819  21.366  1.00 17.70           N  
ATOM   1296  CA  SER   170      -6.109  13.503  22.370  0.50 20.33           C  
ATOM   1298  C   SER   170      -6.104  15.017  22.173  1.00 23.24           C  
ATOM   1299  O   SER   170      -7.136  15.682  22.371  1.00 22.67           O  
ATOM   1300  CB  SER   170      -5.616  13.134  23.771  0.50 21.72           C  
ATOM   1302  OG  SER   170      -5.662  11.732  23.953  0.50 23.48           O  
ATOM   1304  N   SER   171      -4.957  15.564  21.759  1.00 17.62           N  
ATOM   1305  CA  SER   171      -4.808  16.999  21.555  1.00 17.90           C  
ATOM   1306  C   SER   171      -3.626  17.327  20.640  1.00 17.62           C  
ATOM   1307  O   SER   171      -2.849  16.447  20.276  1.00 16.20           O  
ATOM   1308  CB  SER   171      -4.610  17.718  22.896  1.00 18.97           C  
ATOM   1309  OG  SER   171      -3.388  17.332  23.527  1.00 20.91           O  
ATOM   1310  N   TYR   172      -3.493  18.594  20.270  1.00 15.71           N  
ATOM   1311  CA  TYR   172      -2.332  19.040  19.515  1.00 14.60           C  
ATOM   1312  C   TYR   172      -1.932  20.430  19.958  1.00 17.02           C  
ATOM   1313  O   TYR   172      -2.754  21.163  20.549  1.00 16.90           O  
ATOM   1314  CB  TYR   172      -2.604  19.043  17.992  1.00 15.60           C  
ATOM   1315  CG  TYR   172      -3.399  20.235  17.502  1.00 19.02           C  
ATOM   1316  CD1 TYR   172      -2.763  21.389  17.030  1.00 20.38           C  
ATOM   1317  CD2 TYR   172      -4.788  20.208  17.515  1.00 25.26           C  
ATOM   1318  CE1 TYR   172      -3.497  22.490  16.604  1.00 18.75           C  
ATOM   1319  CE2 TYR   172      -5.525  21.289  17.071  1.00 25.40           C  
ATOM   1320  CZ  TYR   172      -4.884  22.419  16.629  1.00 23.67           C  
ATOM   1321  OH  TYR   172      -5.637  23.489  16.188  1.00 26.51           O  
ATOM   1322  N   LYS   173      -0.678  20.787  19.672  1.00 16.10           N  
ATOM   1323  CA  LYS   173      -0.171  22.147  19.859  0.50 15.36           C  
ATOM   1325  C   LYS   173       0.734  22.529  18.698  1.00 16.51           C  
ATOM   1326  O   LYS   173       1.356  21.658  18.076  1.00 15.47           O  
ATOM   1327  CB  LYS   173       0.607  22.279  21.172  0.50 17.13           C  
ATOM   1329  CG  LYS   173      -0.230  22.012  22.410  0.50 21.46           C  
ATOM   1331  CD  LYS   173       0.334  22.672  23.637  0.50 30.27           C  
ATOM   1333  CE  LYS   173      -0.307  22.140  24.905  0.50 31.83           C  
ATOM   1335  NZ  LYS   173      -1.758  22.461  24.978  0.50 23.82           N  
ATOM   1337  N   ILE   174       0.794  23.824  18.398  1.00 13.68           N  
ATOM   1338  CA  ILE   174       1.722  24.383  17.440  1.00 14.31           C  
ATOM   1339  C   ILE   174       2.597  25.396  18.178  1.00 15.81           C  
ATOM   1340  O   ILE   174       2.093  26.174  19.012  1.00 17.33           O  
ATOM   1341  CB  ILE   174       1.006  25.076  16.237  1.00 18.32           C  
ATOM   1342  CG1 ILE   174       0.082  24.091  15.519  1.00 22.53           C  
ATOM   1343  CG2 ILE   174       2.014  25.674  15.248  1.00 22.62           C  
ATOM   1344  CD1 ILE   174      -1.106  24.804  14.872  1.00 36.94           C  
ATOM   1345  N   SER   175       3.893  25.376  17.889  1.00 16.05           N  
ATOM   1346  CA  SER   175       4.820  26.356  18.433  1.00 16.42           C  
ATOM   1347  C   SER   175       5.801  26.935  17.420  1.00 24.16           C  
ATOM   1348  O   SER   175       6.188  26.265  16.461  1.00 19.16           O  
ATOM   1349  CB  SER   175       5.643  25.705  19.546  1.00 19.60           C  
ATOM   1350  OG  SER   175       6.513  26.650  20.151  1.00 23.47           O  
ATOM   1351  N   LYS   176       6.232  28.170  17.687  1.00 30.96           N  
ATOM   1352  CA  LYS   176       7.315  28.823  16.943  0.50 37.46           C  
ATOM   1354  C   LYS   176       8.448  29.228  17.907  1.00 40.47           C  
ATOM   1355  O   LYS   176       8.335  30.246  18.600  1.00 45.07           O  
ATOM   1356  CB  LYS   176       6.798  30.064  16.190  0.50 38.18           C  
ATOM   1358  CG  LYS   176       5.703  29.805  15.147  0.50 39.96           C  
ATOM   1360  CD  LYS   176       4.298  30.018  15.707  0.50 42.89           C  
ATOM   1362  CE  LYS   176       3.237  29.878  14.626  0.50 42.91           C  
ATOM   1364  NZ  LYS   176       1.858  30.045  15.160  0.50 44.53           N  
ATOM   1366  N   PRO   177       9.544  28.429  17.976  1.00 44.39           N  
ATOM   1367  CA  PRO   177      10.685  28.789  18.851  1.00 46.09           C  
ATOM   1368  C   PRO   177      11.475  30.021  18.408  1.00 45.73           C  
ATOM   1369  O   PRO   177      11.329  30.472  17.274  1.00 44.57           O  
ATOM   1370  CB  PRO   177      11.591  27.550  18.789  1.00 46.13           C  
ATOM   1371  CG  PRO   177      10.723  26.457  18.270  1.00 45.78           C  
ATOM   1372  CD  PRO   177       9.781  27.134  17.319  1.00 47.03           C  
ATOM   1373  N   SER   184      11.206  32.146   8.615  1.00 47.14           N  
ATOM   1374  CA  SER   184      10.221  32.550   9.614  1.00 43.59           C  
ATOM   1375  C   SER   184       8.890  31.810   9.444  1.00 36.29           C  
ATOM   1376  O   SER   184       7.917  32.105  10.148  1.00 37.97           O  
ATOM   1377  CB  SER   184      10.008  34.074   9.592  1.00 48.80           C  
ATOM   1378  OG  SER   184       9.332  34.502   8.416  1.00 50.96           O  
ATOM   1379  N   SER   185       8.850  30.856   8.508  1.00 30.41           N  
ATOM   1380  CA  SER   185       7.675  29.994   8.338  1.00 26.29           C  
ATOM   1381  C   SER   185       7.817  28.621   9.031  1.00 21.47           C  
ATOM   1382  O   SER   185       6.892  27.818   8.996  1.00 18.11           O  
ATOM   1383  CB  SER   185       7.316  29.817   6.853  1.00 28.47           C  
ATOM   1384  OG  SER   185       8.319  29.111   6.138  1.00 27.82           O  
ATOM   1385  N   GLU   186       8.963  28.371   9.663  1.00 18.19           N  
ATOM   1386  CA  GLU   186       9.182  27.112  10.398  1.00 18.84           C  
ATOM   1387  C   GLU   186       8.323  27.056  11.661  1.00 17.96           C  
ATOM   1388  O   GLU   186       8.293  28.003  12.456  1.00 19.32           O  
ATOM   1389  CB  GLU   186      10.659  27.004  10.755  1.00 23.73           C  
ATOM   1390  CG  GLU   186      11.044  25.796  11.583  1.00 28.26           C  
ATOM   1391  CD  GLU   186      12.518  25.820  11.930  1.00 36.25           C  
ATOM   1392  OE1 GLU   186      13.340  25.634  11.009  1.00 41.09           O  
ATOM   1393  OE2 GLU   186      12.845  26.037  13.116  1.00 27.26           O  
ATOM   1394  N   ILE   187       7.595  25.952  11.832  1.00 12.61           N  
ATOM   1395  CA  ILE   187       6.822  25.734  13.033  1.00 14.48           C  
ATOM   1396  C   ILE   187       7.046  24.310  13.512  1.00 11.25           C  
ATOM   1397  O   ILE   187       7.566  23.463  12.777  1.00 12.69           O  
ATOM   1398  CB  ILE   187       5.292  25.927  12.794  1.00 13.62           C  
ATOM   1399  CG1 ILE   187       4.748  24.936  11.756  1.00 16.83           C  
ATOM   1400  CG2 ILE   187       4.981  27.380  12.355  1.00 16.35           C  
ATOM   1401  CD1 ILE   187       3.219  24.939  11.638  1.00 16.25           C  
ATOM   1402  N   TYR   188       6.645  24.058  14.740  1.00 12.52           N  
ATOM   1403  CA  TYR   188       6.685  22.709  15.280  1.00 11.12           C  
ATOM   1404  C   TYR   188       5.284  22.293  15.669  1.00 13.07           C  
ATOM   1405  O   TYR   188       4.590  23.002  16.389  1.00 15.22           O  
ATOM   1406  CB  TYR   188       7.650  22.636  16.469  1.00 12.16           C  
ATOM   1407  CG  TYR   188       9.091  22.682  15.995  1.00 14.96           C  
ATOM   1408  CD1 TYR   188       9.742  21.518  15.624  1.00 14.22           C  
ATOM   1409  CD2 TYR   188       9.788  23.895  15.877  1.00 24.10           C  
ATOM   1410  CE1 TYR   188      11.058  21.533  15.162  1.00 20.23           C  
ATOM   1411  CE2 TYR   188      11.132  23.920  15.405  1.00 17.23           C  
ATOM   1412  CZ  TYR   188      11.740  22.728  15.060  1.00 20.20           C  
ATOM   1413  OH  TYR   188      13.040  22.688  14.585  1.00 22.77           O  
ATOM   1414  N   ILE   189       4.848  21.170  15.112  1.00 10.86           N  
ATOM   1415  CA  ILE   189       3.551  20.614  15.382  1.00 11.58           C  
ATOM   1416  C   ILE   189       3.700  19.439  16.344  1.00 12.48           C  
ATOM   1417  O   ILE   189       4.542  18.576  16.131  1.00 10.76           O  
ATOM   1418  CB  ILE   189       2.904  20.096  14.062  1.00 12.23           C  
ATOM   1419  CG1 ILE   189       2.816  21.238  13.017  1.00 13.52           C  
ATOM   1420  CG2 ILE   189       1.567  19.495  14.350  1.00 13.92           C  
ATOM   1421  CD1 ILE   189       2.330  20.833  11.608  1.00 13.20           C  
ATOM   1422  N   MET   190       2.902  19.413  17.410  1.00 10.89           N  
ATOM   1423  CA  MET   190       2.932  18.331  18.373  1.00 10.73           C  
ATOM   1424  C   MET   190       1.579  17.719  18.511  1.00 11.66           C  
ATOM   1425  O   MET   190       0.586  18.426  18.642  1.00 14.15           O  
ATOM   1426  CB  MET   190       3.391  18.873  19.717  1.00 14.40           C  
ATOM   1427  CG  MET   190       4.825  19.361  19.671  1.00 11.28           C  
ATOM   1428  SD  MET   190       5.290  20.609  21.075  0.70 15.68          SE  
ATOM   1429  CE  MET   190       4.616  22.239  20.199  1.00 15.83           C  
ATOM   1430  N   PHE   191       1.553  16.402  18.473  1.00 10.91           N  
ATOM   1431  CA  PHE   191       0.346  15.645  18.712  1.00 11.71           C  
ATOM   1432  C   PHE   191       0.498  14.847  19.997  1.00 13.28           C  
ATOM   1433  O   PHE   191       1.502  14.154  20.182  1.00 12.81           O  
ATOM   1434  CB  PHE   191       0.085  14.710  17.541  1.00 13.21           C  
ATOM   1435  CG  PHE   191      -0.197  15.410  16.236  1.00 12.64           C  
ATOM   1436  CD1 PHE   191      -1.429  16.065  15.992  1.00 14.49           C  
ATOM   1437  CD2 PHE   191       0.749  15.408  15.237  1.00 14.78           C  
ATOM   1438  CE1 PHE   191      -1.683  16.692  14.767  1.00 15.89           C  
ATOM   1439  CE2 PHE   191       0.502  16.023  14.015  1.00 13.87           C  
ATOM   1440  CZ  PHE   191      -0.714  16.678  13.776  1.00 14.54           C  
ATOM   1441  N   PHE   192      -0.491  14.916  20.882  1.00 12.86           N  
ATOM   1442  CA  PHE   192      -0.370  14.302  22.207  1.00 14.39           C  
ATOM   1443  C   PHE   192      -1.384  13.187  22.416  1.00 12.55           C  
ATOM   1444  O   PHE   192      -2.570  13.360  22.102  1.00 16.09           O  
ATOM   1445  CB  PHE   192      -0.564  15.354  23.309  1.00 12.50           C  
ATOM   1446  CG  PHE   192       0.479  16.433  23.302  1.00 11.60           C  
ATOM   1447  CD1 PHE   192       1.676  16.297  24.024  1.00 11.91           C  
ATOM   1448  CD2 PHE   192       0.284  17.586  22.557  1.00 13.16           C  
ATOM   1449  CE1 PHE   192       2.655  17.302  23.997  1.00 13.78           C  
ATOM   1450  CE2 PHE   192       1.245  18.597  22.520  1.00 12.61           C  
ATOM   1451  CZ  PHE   192       2.436  18.460  23.242  1.00 15.38           C  
ATOM   1452  N   GLY   193      -0.922  12.057  22.946  1.00 13.98           N  
ATOM   1453  CA  GLY   193      -1.843  11.007  23.383  1.00 15.36           C  
ATOM   1454  C   GLY   193      -2.468  10.213  22.256  1.00 13.95           C  
ATOM   1455  O   GLY   193      -3.678  10.295  21.999  1.00 16.05           O  
ATOM   1456  N   PHE   194      -1.636   9.445  21.562  1.00 13.46           N  
ATOM   1457  CA  PHE   194      -2.059   8.635  20.433  1.00 11.69           C  
ATOM   1458  C   PHE   194      -3.164   7.669  20.824  1.00 13.52           C  
ATOM   1459  O   PHE   194      -3.112   7.089  21.889  1.00 16.71           O  
ATOM   1460  CB  PHE   194      -0.862   7.833  19.914  1.00 13.82           C  
ATOM   1461  CG  PHE   194      -1.163   6.995  18.710  1.00 16.03           C  
ATOM   1462  CD1 PHE   194      -1.590   7.578  17.524  1.00 14.81           C  
ATOM   1463  CD2 PHE   194      -1.003   5.620  18.770  1.00 16.98           C  
ATOM   1464  CE1 PHE   194      -1.858   6.788  16.397  1.00 18.56           C  
ATOM   1465  CE2 PHE   194      -1.271   4.813  17.657  1.00 23.43           C  
ATOM   1466  CZ  PHE   194      -1.702   5.406  16.461  1.00 18.74           C  
ATOM   1467  N   LYS   195      -4.139   7.516  19.967  1.00 18.76           N  
ATOM   1468  CA  LYS   195      -5.181   6.511  20.100  1.00 24.68           C  
ATOM   1469  C   LYS   195      -5.265   5.710  18.826  1.00 26.91           C  
ATOM   1470  O   LYS   195      -5.695   6.190  17.864  1.00 28.15           O  
ATOM   1471  CB  LYS   195      -6.557   7.140  20.275  1.00 28.13           C  
ATOM   1472  CG  LYS   195      -6.727   8.370  21.094  1.00 36.83           C  
ATOM   1473  CD  LYS   195      -8.202   8.847  21.108  1.00 38.91           C  
ATOM   1474  CE  LYS   195      -8.420  10.211  20.514  1.00 50.63           C  
ATOM   1475  NZ  LYS   195      -9.752  10.881  20.750  1.00 53.49           N  
ATOM   1476  N   ALA   196      -4.888   4.461  18.873  1.00 33.64           N  
ATOM   1477  CA  ALA   196      -5.097   3.537  17.757  1.00 41.41           C  
ATOM   1478  C   ALA   196      -6.586   3.396  17.404  1.00 43.93           C  
ATOM   1479  O   ALA   196      -6.926   3.095  16.260  1.00 48.00           O  
ATOM   1480  CB  ALA   196      -4.494   2.188  18.068  1.00 40.11           C  
END
