
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  209 ( 1710),  selected  209 , name 1nt2_A
# Molecule2: number of CA atoms  174 ( 1400),  selected  174 , name T0508.pdb
# PARAMETERS: 1nt2_A.T0508.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     2_A      -       -           -
LGA    E     3_A      -       -           -
LGA    L     4_A      -       -           -
LGA    M     5_A      -       -           -
LGA    R     6_A      -       -           -
LGA    N     7_A      -       -           -
LGA    V     8_A      -       -           -
LGA    Y     9_A      -       -           -
LGA    L    10_A      -       -           -
LGA    L    11_A      -       -           -
LGA    D    12_A      -       -           -
LGA    D    13_A      -       -           -
LGA    T    14_A      -       -           -
LGA    L    15_A      -       -           -
LGA    V    16_A      -       -           -
LGA    T    17_A      -       -           -
LGA    K    18_A      -       -           -
LGA    S    19_A      -       -           -
LGA    K    20_A      -       -           -
LGA    Y    21_A      -       -           -
LGA    G    22_A      -       -           -
LGA    S    23_A      -       -           -
LGA    H    24_A      Q      17          3.327
LGA    Y    25_A      L      18          5.392
LGA    G    26_A      R      19          3.539
LGA    E    27_A      -       -           -
LGA    K    28_A      -       -           -
LGA    V    29_A      -       -           -
LGA    F    30_A      -       -           -
LGA    D    31_A      -       -           -
LGA    G    32_A      -       -           -
LGA    Y    33_A      -       -           -
LGA    R    34_A      -       -           -
LGA    E    35_A      -       -           -
LGA    W    36_A      -       -           -
LGA    V    37_A      -       -           -
LGA    P    38_A      S      20           #
LGA    W    39_A      R      21          2.914
LGA    R    40_A      A      22          2.843
LGA    S    41_A      A      23          2.902
LGA    -       -      F      24           -
LGA    K    42_A      K      25          2.997
LGA    L    43_A      L      26          1.241
LGA    A    44_A      E      27          1.906
LGA    A    45_A      F      28          3.108
LGA    M    46_A      L      29          2.141
LGA    I    47_A      L      30          3.902
LGA    L    48_A      D      31          5.601
LGA    K    49_A      -       -           -
LGA    G    50_A      R      32          3.045
LGA    H    51_A      Y      33          2.679
LGA    R    52_A      R      34          2.869
LGA    L    53_A      V      35          3.188
LGA    K    54_A      V      36           #
LGA    L    55_A      R      37          2.164
LGA    R    56_A      K      38          3.054
LGA    G    57_A      G      39          2.454
LGA    D    58_A      -       -           -
LGA    E    59_A      D      40          1.934
LGA    R    60_A      A      41          1.214
LGA    V    61_A      V      42          1.172
LGA    L    62_A      I      43          0.814
LGA    Y    63_A      E      44          0.590
LGA    L    64_A      I      45          0.918
LGA    G    65_A      G      46          1.053
LGA    A    66_A      S      47          0.679
LGA    A    67_A      S      48          1.571
LGA    S    68_A      P      49          0.284
LGA    G    69_A      G      50          0.324
LGA    T    70_A      G      51          0.562
LGA    T    71_A      W      52          1.252
LGA    V    72_A      T      53          1.064
LGA    S    73_A      Q      54          0.384
LGA    H    74_A      V      55          0.790
LGA    L    75_A      L      56          0.601
LGA    A    76_A      N      57          0.356
LGA    D    77_A      S      58          0.499
LGA    I    78_A      L      59          1.525
LGA    V    79_A      A      60          1.959
LGA    D    80_A      -       -           -
LGA    E    81_A      -       -           -
LGA    G    82_A      R      61          0.738
LGA    I    83_A      K      62          0.681
LGA    I    84_A      I      63          0.556
LGA    Y    85_A      I      64          0.409
LGA    A    86_A      S      65          0.532
LGA    V    87_A      I      66          0.593
LGA    E    88_A      D      67          0.659
LGA    Y    89_A      L      68          1.294
LGA    S    90_A      Q      69          2.083
LGA    A    91_A      E      70          3.486
LGA    K    92_A      -       -           -
LGA    P    93_A      -       -           -
LGA    F    94_A      -       -           -
LGA    E    95_A      M      71          3.604
LGA    K    96_A      E      72          3.744
LGA    L    97_A      -       -           -
LGA    L    98_A      E      73          2.437
LGA    E    99_A      -       -           -
LGA    L   100_A      -       -           -
LGA    V   101_A      I      74          1.454
LGA    R   102_A      -       -           -
LGA    E   103_A      -       -           -
LGA    R   104_A      -       -           -
LGA    N   105_A      A      75          2.442
LGA    N   106_A      G      76          2.538
LGA    I   107_A      V      77          0.915
LGA    I   108_A      R      78          0.750
LGA    P   109_A      F      79          0.663
LGA    L   110_A      I      80          0.782
LGA    L   111_A      R      81          0.869
LGA    F   112_A      C      82          1.337
LGA    D   113_A      D      83          1.780
LGA    A   114_A      I      84          2.215
LGA    S   115_A      F      85          2.740
LGA    K   116_A      K      86          4.893
LGA    -       -      E      87           -
LGA    -       -      T      88           -
LGA    P   117_A      I      89          3.039
LGA    W   118_A      F      90          1.685
LGA    K   119_A      D      91          3.196
LGA    Y   120_A      D      92          0.923
LGA    S   121_A      I      93          3.523
LGA    G   122_A      D      94          2.707
LGA    -       -      R      95           -
LGA    I   123_A      A      96          1.898
LGA    V   124_A      L      97          2.650
LGA    -       -      R      98           -
LGA    -       -      E      99           -
LGA    -       -      E     100           -
LGA    -       -      G     101           -
LGA    E   125_A      I     102          3.589
LGA    K   126_A      E     103          3.054
LGA    -       -      K     104           -
LGA    V   127_A      V     105          0.728
LGA    D   128_A      D     106          0.878
LGA    L   129_A      D     107          0.780
LGA    I   130_A      V     108          0.639
LGA    Y   131_A      V     109          0.860
LGA    Q   132_A      S     110          1.258
LGA    D   133_A      D     111          1.400
LGA    I   134_A      A     112          1.617
LGA    A   135_A      M     113          2.236
LGA    -       -      A     114           -
LGA    -       -      K     115           -
LGA    -       -      V     116           -
LGA    -       -      S     117           -
LGA    -       -      G     118           -
LGA    -       -      I     119           -
LGA    -       -      P     120           -
LGA    -       -      S     121           -
LGA    -       -      R     122           -
LGA    -       -      D     123           -
LGA    -       -      H     124           -
LGA    -       -      A     125           -
LGA    Q   136_A      V     126          3.569
LGA    K   137_A      S     127          3.893
LGA    -       -      Y     128           -
LGA    N   138_A      Q     129          1.123
LGA    Q   139_A      I     130          2.294
LGA    I   140_A      G     131          2.671
LGA    E   141_A      Q     132          1.843
LGA    I   142_A      R     133          1.292
LGA    L   143_A      V     134          1.635
LGA    K   144_A      M     135          1.939
LGA    A   145_A      E     136          1.728
LGA    N   146_A      I     137          0.758
LGA    A   147_A      A     138          1.631
LGA    E   148_A      V     139          3.012
LGA    F   149_A      R     140          2.580
LGA    F   150_A      Y     141          1.378
LGA    L   151_A      L     142          0.974
LGA    K   152_A      R     143          1.708
LGA    E   153_A      N     144          2.236
LGA    K   154_A      G     145          2.281
LGA    G   155_A      G     146          1.553
LGA    E   156_A      N     147          1.480
LGA    V   157_A      V     148          1.369
LGA    V   158_A      L     149          1.302
LGA    I   159_A      L     150          1.360
LGA    M   160_A      K     151          1.718
LGA    V   161_A      Q     152          1.306
LGA    K   162_A      F     153          1.868
LGA    A   163_A      Q     154          2.361
LGA    R   164_A      -       -           -
LGA    S   165_A      -       -           -
LGA    I   166_A      -       -           -
LGA    D   167_A      -       -           -
LGA    S   168_A      -       -           -
LGA    T   169_A      -       -           -
LGA    A   170_A      -       -           -
LGA    E   171_A      -       -           -
LGA    P   172_A      -       -           -
LGA    E   173_A      G     155           #
LGA    E   174_A      D     156          4.108
LGA    V   175_A      M     157          4.173
LGA    F   176_A      T     158          2.999
LGA    K   177_A      N     159          2.193
LGA    S   178_A      D     160          2.795
LGA    V   179_A      F     161          2.535
LGA    L   180_A      I     162          1.534
LGA    K   181_A      A     163          1.907
LGA    E   182_A      I     164          3.324
LGA    M   183_A      W     165          2.233
LGA    E   184_A      R     166          2.204
LGA    G   185_A      K     167          3.703
LGA    D   186_A      N     168          3.067
LGA    F   187_A      F     169          3.158
LGA    K   188_A      S     170          3.493
LGA    I   189_A      S     171          2.578
LGA    V   190_A      Y     172          2.997
LGA    K   191_A      K     173          1.592
LGA    H   192_A      I     174          1.440
LGA    G   193_A      S     175          1.909
LGA    S   194_A      K     176          1.741
LGA    L   195_A      P     177          1.853
LGA    M   196_A      -       -           -
LGA    P   197_A      -       -           -
LGA    Y   198_A      -       -           -
LGA    H   199_A      -       -           -
LGA    R   200_A      S     184          2.749
LGA    D   201_A      S     185          2.630
LGA    H   202_A      E     186          1.943
LGA    I   203_A      I     187          1.687
LGA    F   204_A      Y     188          1.853
LGA    I   205_A      I     189          1.963
LGA    H   206_A      M     190          1.886
LGA    A   207_A      F     191          1.440
LGA    Y   208_A      F     192          3.595
LGA    -       -      G     193           -
LGA    R   209_A      F     194          1.684
LGA    F   210_A      K     195          1.143
LGA    -       -      A     196           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  209  174    5.0    147    2.28    14.97     63.023     6.177

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.521647 * X  +  -0.763367 * Y  +   0.380992 * Z  +  12.029744
  Y_new =  -0.447304 * X  +   0.135559 * Y  +   0.884049 * Z  +   0.317886
  Z_new =  -0.726501 * X  +  -0.631581 * Y  +  -0.270743 * Z  +  68.253242 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.975775    1.165817  [ DEG:  -113.2036     66.7964 ]
  Theta =   0.813216    2.328376  [ DEG:    46.5939    133.4061 ]
  Phi   =  -0.708823    2.432770  [ DEG:   -40.6125    139.3875 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1nt2_A                                        
REMARK     2: T0508.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1nt2_A.T0508.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  209  174   5.0  147   2.28   14.97  63.023
REMARK  ---------------------------------------------------------- 
MOLECULE 1nt2_A
HEADER    RNA BINDING PROTEIN                     28-JAN-03   1NT2              
TITLE     CRYSTAL STRUCTURE OF FIBRILLARIN/NOP5P COMPLEX                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: FIBRILLARIN-LIKE PRE-RRNA PROCESSING PROTEIN;              
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES;                                                     
COMPND   5 MOL_ID: 2;                                                           
COMPND   6 MOLECULE: CONSERVED HYPOTHETICAL PROTEIN;                            
COMPND   7 CHAIN: B;                                                            
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ARCHAEOGLOBUS FULGIDUS;                         
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 STRAIN: DSM4304;                                                     
SOURCE   5 GENE: AF2087;                                                        
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BLR21(DE3);                                
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET13B;                                   
SOURCE  11 MOL_ID: 2;                                                           
SOURCE  12 ORGANISM_SCIENTIFIC: ARCHAEOGLOBUS FULGIDUS;                         
SOURCE  13 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE  14 GENE: AF2088;                                                        
SOURCE  15 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  16 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE  17 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  18 EXPRESSION_SYSTEM_PLASMID: PBR                                       
KEYWDS    ADEMET, BINDING MOTIF, COILED COIL                                    
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.AITTALEB,R.RASHID,Q.CHEN,J.R.PALMER,C.J.DANIELS,H.LI                
REVDAT   1   01-APR-03 1NT2    0                                                
JRNL        AUTH   M.AITTALEB,R.RASHID,Q.CHEN,J.R.PALMER,C.J.DANIELS,           
JRNL        AUTH 2 H.LI                                                         
JRNL        TITL   STRUCTURE AND FUNCTION OF ARCHAEAL BOX C/D SRNP              
JRNL        TITL 2 CORE PROTEINS.                                               
JRNL        REF    NAT.STRUCT.BIOL.              V.  10   256 2003              
JRNL        REFN   ASTM NSBIEW  US ISSN 1072-8368                               
REMARK   2 RESOLUTION. 2.90 ANGSTROMS.                                          
DBREF  1NT2 A    1   210  UNP    O28192   FLPA_ARCFU       1    210             
DBREF  1NT2 B   12   269  UNP    O28191   O28191_ARCFU     4    261             
SEQRES   1 A  210  MET LYS GLU LEU MET ARG ASN VAL TYR LEU LEU ASP ASP          
SEQRES   2 A  210  THR LEU VAL THR LYS SER LYS TYR GLY SER HIS TYR GLY          
SEQRES   3 A  210  GLU LYS VAL PHE ASP GLY TYR ARG GLU TRP VAL PRO TRP          
SEQRES   4 A  210  ARG SER LYS LEU ALA ALA MET ILE LEU LYS GLY HIS ARG          
SEQRES   5 A  210  LEU LYS LEU ARG GLY ASP GLU ARG VAL LEU TYR LEU GLY          
SEQRES   6 A  210  ALA ALA SER GLY THR THR VAL SER HIS LEU ALA ASP ILE          
SEQRES   7 A  210  VAL ASP GLU GLY ILE ILE TYR ALA VAL GLU TYR SER ALA          
SEQRES   8 A  210  LYS PRO PHE GLU LYS LEU LEU GLU LEU VAL ARG GLU ARG          
SEQRES   9 A  210  ASN ASN ILE ILE PRO LEU LEU PHE ASP ALA SER LYS PRO          
SEQRES  10 A  210  TRP LYS TYR SER GLY ILE VAL GLU LYS VAL ASP LEU ILE          
SEQRES  11 A  210  TYR GLN ASP ILE ALA GLN LYS ASN GLN ILE GLU ILE LEU          
SEQRES  12 A  210  LYS ALA ASN ALA GLU PHE PHE LEU LYS GLU LYS GLY GLU          
SEQRES  13 A  210  VAL VAL ILE MET VAL LYS ALA ARG SER ILE ASP SER THR          
SEQRES  14 A  210  ALA GLU PRO GLU GLU VAL PHE LYS SER VAL LEU LYS GLU          
SEQRES  15 A  210  MET GLU GLY ASP PHE LYS ILE VAL LYS HIS GLY SER LEU          
SEQRES  16 A  210  MET PRO TYR HIS ARG ASP HIS ILE PHE ILE HIS ALA TYR          
SEQRES  17 A  210  ARG PHE                                                      
SEQRES   1 B  258  LEU ARG TYR ASN LEU TRP PHE GLY VAL TYR ASP GLY LYS          
SEQRES   2 B  258  GLU ILE LYS LEU SER GLU ASN PHE GLU GLU SER PHE LEU          
SEQRES   3 B  258  LYS ALA GLU ASN PRO SER PRO LEU PRO PHE ASN VAL SER          
SEQRES   4 B  258  GLU VAL GLY ALA LYS ALA LEU GLY LYS ASP TYR TYR ARG          
SEQRES   5 B  258  ILE LEU ARG LYS THR ALA LEU ALA VAL SER GLU LYS MET          
SEQRES   6 B  258  VAL GLU LYS GLU LEU ARG ARG GLU ASP ARG TYR VAL VAL          
SEQRES   7 B  258  ALA LEU VAL LYS ALA LEU GLU GLU ILE ASP GLU SER ILE          
SEQRES   8 B  258  ASN MET LEU ASN GLU LYS LEU GLU ASP ILE ARG ALA VAL          
SEQRES   9 B  258  LYS GLU SER GLU ILE THR GLU LYS PHE GLU LYS LYS ILE          
SEQRES  10 B  258  ARG GLU LEU ARG GLU LEU ARG ARG ASP VAL GLU ARG GLU          
SEQRES  11 B  258  ILE GLU GLU VAL MET GLU LYS ILE ALA PRO ASN MET THR          
SEQRES  12 B  258  GLU LEU VAL GLY ALA LYS VAL ALA ALA LYS LEU LEU GLU          
SEQRES  13 B  258  ARG ALA GLY SER MET GLU ARG LEU VAL ARG LEU PRO ALA          
SEQRES  14 B  258  SER LYS ILE GLN VAL ILE GLY ALA GLU LYS SER LEU TYR          
SEQRES  15 B  258  LYS ALA PHE ALA ARG MET LYS LYS GLY LYS LYS ALA LYS          
SEQRES  16 B  258  ILE PRO LYS HIS GLY ILE ILE PHE LEU HIS PRO PHE ILE          
SEQRES  17 B  258  ARG THR LEU PRO LYS ALA LYS ARG GLY LYS MET ALA ARG          
SEQRES  18 B  258  PHE LEU ALA ALA LYS LEU ALA ILE ALA ALA LYS ILE ASP          
SEQRES  19 B  258  TYR PHE ARG GLY GLU ILE ASP GLU SER LEU TYR GLU SER          
SEQRES  20 B  258  ILE ARG ARG ARG TYR GLU GLU LEU ARG ARG LYS                  
HET    SAM    301      27                                                       
HETNAM     SAM S-ADENOSYLMETHIONINE                                             
FORMUL   3  SAM    C15 H22 N6 O5 S                                              
CRYST1  125.308  125.308   87.482  90.00  90.00  90.00 P 42 21 2     8          
ATOM      1  N   LYS A   2      14.657  27.100  37.788  1.00 70.58           N  
ATOM      2  CA  LYS A   2      13.445  26.235  37.697  1.00 71.11           C  
ATOM      3  C   LYS A   2      13.695  24.856  37.081  1.00 72.12           C  
ATOM      4  O   LYS A   2      14.781  24.565  36.583  1.00 72.74           O  
ATOM      5  CB  LYS A   2      12.347  26.944  36.897  1.00 69.96           C  
ATOM      6  CG  LYS A   2      11.422  27.809  37.734  1.00 68.76           C  
ATOM      7  CD  LYS A   2      10.259  28.363  36.911  1.00 66.45           C  
ATOM      8  CE  LYS A   2      10.745  29.313  35.823  1.00 64.12           C  
ATOM      9  NZ  LYS A   2       9.621  30.002  35.143  1.00 61.15           N  
ATOM     10  N   GLU A   3      12.665  24.016  37.125  1.00 73.17           N  
ATOM     11  CA  GLU A   3      12.710  22.660  36.588  1.00 74.17           C  
ATOM     12  C   GLU A   3      11.467  22.464  35.708  1.00 74.58           C  
ATOM     13  O   GLU A   3      10.336  22.570  36.190  1.00 75.82           O  
ATOM     14  CB  GLU A   3      12.717  21.646  37.745  1.00 75.81           C  
ATOM     15  CG  GLU A   3      11.521  21.748  38.733  1.00 79.41           C  
ATOM     16  CD  GLU A   3      11.620  22.892  39.768  1.00 80.92           C  
ATOM     17  OE1 GLU A   3      12.501  22.832  40.659  1.00 82.33           O  
ATOM     18  OE2 GLU A   3      10.806  23.847  39.700  1.00 80.17           O  
ATOM     19  N   LEU A   4      11.661  22.190  34.421  1.00 73.63           N  
ATOM     20  CA  LEU A   4      10.516  22.013  33.524  1.00 72.18           C  
ATOM     21  C   LEU A   4      10.353  20.578  33.060  1.00 70.79           C  
ATOM     22  O   LEU A   4       9.241  20.118  32.806  1.00 69.63           O  
ATOM     23  CB  LEU A   4      10.670  22.899  32.284  1.00 73.23           C  
ATOM     24  CG  LEU A   4      10.797  24.416  32.427  1.00 73.41           C  
ATOM     25  CD1 LEU A   4      11.409  24.990  31.163  1.00 73.75           C  
ATOM     26  CD2 LEU A   4       9.433  25.025  32.691  1.00 73.72           C  
ATOM     27  N   MET A   5      11.474  19.877  32.946  1.00 69.94           N  
ATOM     28  CA  MET A   5      11.456  18.510  32.460  1.00 69.01           C  
ATOM     29  C   MET A   5      12.307  17.542  33.243  1.00 67.00           C  
ATOM     30  O   MET A   5      12.896  17.878  34.266  1.00 67.03           O  
ATOM     31  CB  MET A   5      11.938  18.462  31.012  1.00 71.76           C  
ATOM     32  CG  MET A   5      11.141  19.281  30.021  1.00 73.84           C  
ATOM     33  SD  MET A   5      10.237  18.222  28.877  1.00 75.59           S  
ATOM     34  CE  MET A   5      11.422  16.887  28.629  1.00 74.29           C  
ATOM     35  N   ARG A   6      12.380  16.337  32.687  1.00 64.83           N  
ATOM     36  CA  ARG A   6      13.118  15.217  33.238  1.00 62.87           C  
ATOM     37  C   ARG A   6      14.465  15.638  33.784  1.00 61.68           C  
ATOM     38  O   ARG A   6      14.723  15.496  34.974  1.00 63.28           O  
ATOM     39  CB  ARG A   6      13.285  14.151  32.160  1.00 63.28           C  
ATOM     40  CG  ARG A   6      13.093  12.725  32.659  1.00 62.14           C  
ATOM     41  CD  ARG A   6      14.305  12.258  33.421  1.00 61.53           C  
ATOM     42  NE  ARG A   6      14.152  10.909  33.945  1.00 60.85           N  
ATOM     43  CZ  ARG A   6      15.133  10.236  34.537  1.00 61.63           C  
ATOM     44  NH1 ARG A   6      16.332  10.788  34.676  1.00 61.68           N  
ATOM     45  NH2 ARG A   6      14.918   9.014  34.997  1.00 62.06           N  
ATOM     46  N   ASN A   7      15.337  16.136  32.925  1.00 59.03           N  
ATOM     47  CA  ASN A   7      16.635  16.592  33.399  1.00 58.09           C  
ATOM     48  C   ASN A   7      16.860  17.964  32.796  1.00 57.66           C  
ATOM     49  O   ASN A   7      17.968  18.326  32.391  1.00 56.46           O  
ATOM     50  CB  ASN A   7      17.737  15.610  32.991  1.00 57.57           C  
ATOM     51  CG  ASN A   7      17.742  14.352  33.848  1.00 56.10           C  
ATOM     52  OD1 ASN A   7      17.758  14.424  35.078  1.00 54.78           O  
ATOM     53  ND2 ASN A   7      17.737  13.194  33.201  1.00 55.75           N  
ATOM     54  N   VAL A   8      15.767  18.724  32.763  1.00 57.54           N  
ATOM     55  CA  VAL A   8      15.744  20.062  32.198  1.00 57.65           C  
ATOM     56  C   VAL A   8      15.538  21.158  33.238  1.00 58.52           C  
ATOM     57  O   VAL A   8      14.517  21.198  33.932  1.00 58.63           O  
ATOM     58  CB  VAL A   8      14.636  20.169  31.139  1.00 56.73           C  
ATOM     59  CG1 VAL A   8      14.530  21.589  30.636  1.00 57.36           C  
ATOM     60  CG2 VAL A   8      14.921  19.213  29.991  1.00 55.84           C  
ATOM     61  N   TYR A   9      16.518  22.051  33.320  1.00 59.36           N  
ATOM     62  CA  TYR A   9      16.486  23.163  34.253  1.00 60.05           C  
ATOM     63  C   TYR A   9      16.878  24.444  33.535  1.00 61.21           C  
ATOM     64  O   TYR A   9      17.322  24.411  32.384  1.00 61.53           O  
ATOM     65  CB  TYR A   9      17.458  22.915  35.404  1.00 59.49           C  
ATOM     66  CG  TYR A   9      17.213  21.625  36.130  1.00 59.77           C  
ATOM     67  CD1 TYR A   9      16.006  21.384  36.774  1.00 60.88           C  
ATOM     68  CD2 TYR A   9      18.183  20.633  36.157  1.00 61.22           C  
ATOM     69  CE1 TYR A   9      15.767  20.179  37.430  1.00 61.99           C  
ATOM     70  CE2 TYR A   9      17.958  19.423  36.808  1.00 62.27           C  
ATOM     71  CZ  TYR A   9      16.748  19.202  37.442  1.00 62.58           C  
ATOM     72  OH  TYR A   9      16.524  18.006  38.087  1.00 63.44           O  
ATOM     73  N   LEU A  10      16.715  25.566  34.234  1.00 62.00           N  
ATOM     74  CA  LEU A  10      17.042  26.882  33.703  1.00 62.66           C  
ATOM     75  C   LEU A  10      18.143  27.574  34.513  1.00 64.44           C  
ATOM     76  O   LEU A  10      17.868  28.538  35.227  1.00 65.66           O  
ATOM     77  CB  LEU A  10      15.795  27.765  33.702  1.00 60.74           C  
ATOM     78  CG  LEU A  10      14.626  27.302  32.840  1.00 60.21           C  
ATOM     79  CD1 LEU A  10      13.337  27.927  33.324  1.00 61.03           C  
ATOM     80  CD2 LEU A  10      14.893  27.670  31.405  1.00 59.98           C  
ATOM     81  N   LEU A  11      19.379  27.082  34.421  1.00 65.55           N  
ATOM     82  CA  LEU A  11      20.491  27.711  35.134  1.00 66.26           C  
ATOM     83  C   LEU A  11      20.416  29.202  34.853  1.00 66.47           C  
ATOM     84  O   LEU A  11      20.446  29.615  33.700  1.00 66.68           O  
ATOM     85  CB  LEU A  11      21.825  27.180  34.629  1.00 67.33           C  
ATOM     86  CG  LEU A  11      22.026  25.687  34.837  1.00 70.10           C  
ATOM     87  CD1 LEU A  11      23.474  25.338  34.531  1.00 71.95           C  
ATOM     88  CD2 LEU A  11      21.678  25.314  36.273  1.00 70.92           C  
ATOM     89  N   ASP A  12      20.339  30.002  35.910  1.00 66.33           N  
ATOM     90  CA  ASP A  12      20.206  31.447  35.781  1.00 65.58           C  
ATOM     91  C   ASP A  12      19.180  31.710  34.682  1.00 64.77           C  
ATOM     92  O   ASP A  12      18.013  31.948  34.979  1.00 64.74           O  
ATOM     93  CB  ASP A  12      21.544  32.108  35.455  1.00 65.74           C  
ATOM     94  CG  ASP A  12      21.671  33.478  36.098  1.00 65.96           C  
ATOM     95  OD1 ASP A  12      20.834  34.357  35.804  1.00 65.56           O  
ATOM     96  OD2 ASP A  12      22.600  33.673  36.907  1.00 67.00           O  
ATOM     97  N   ASP A  13      19.605  31.661  33.422  1.00 63.63           N  
ATOM     98  CA  ASP A  13      18.682  31.852  32.307  1.00 62.80           C  
ATOM     99  C   ASP A  13      19.066  31.048  31.072  1.00 61.17           C  
ATOM    100  O   ASP A  13      18.566  31.284  29.973  1.00 61.47           O  
ATOM    101  CB  ASP A  13      18.557  33.328  31.957  1.00 64.44           C  
ATOM    102  CG  ASP A  13      17.296  33.941  32.521  1.00 66.84           C  
ATOM    103  OD1 ASP A  13      17.095  33.847  33.752  1.00 67.31           O  
ATOM    104  OD2 ASP A  13      16.504  34.512  31.735  1.00 68.99           O  
ATOM    105  N   THR A  14      19.952  30.082  31.276  1.00 58.49           N  
ATOM    106  CA  THR A  14      20.425  29.210  30.213  1.00 55.36           C  
ATOM    107  C   THR A  14      19.734  27.853  30.328  1.00 54.21           C  
ATOM    108  O   THR A  14      19.876  27.172  31.336  1.00 56.21           O  
ATOM    109  CB  THR A  14      21.962  29.007  30.321  1.00 54.02           C  
ATOM    110  OG1 THR A  14      22.638  30.158  29.801  1.00 52.71           O  
ATOM    111  CG2 THR A  14      22.407  27.775  29.562  1.00 53.54           C  
ATOM    112  N   LEU A  15      18.978  27.461  29.307  1.00 51.48           N  
ATOM    113  CA  LEU A  15      18.310  26.166  29.331  1.00 47.83           C  
ATOM    114  C   LEU A  15      19.430  25.131  29.285  1.00 46.80           C  
ATOM    115  O   LEU A  15      20.374  25.280  28.508  1.00 44.93           O  
ATOM    116  CB  LEU A  15      17.404  26.021  28.101  1.00 46.40           C  
ATOM    117  CG  LEU A  15      16.439  24.837  28.042  1.00 44.75           C  
ATOM    118  CD1 LEU A  15      15.230  25.128  28.905  1.00 43.27           C  
ATOM    119  CD2 LEU A  15      16.012  24.589  26.606  1.00 43.61           C  
ATOM    120  N   VAL A  16      19.350  24.106  30.130  1.00 47.07           N  
ATOM    121  CA  VAL A  16      20.379  23.056  30.150  1.00 48.34           C  
ATOM    122  C   VAL A  16      19.827  21.707  30.585  1.00 48.96           C  
ATOM    123  O   VAL A  16      18.738  21.629  31.158  1.00 48.43           O  
ATOM    124  CB  VAL A  16      21.552  23.383  31.116  1.00 47.61           C  
ATOM    125  CG1 VAL A  16      22.220  24.682  30.718  1.00 46.27           C  
ATOM    126  CG2 VAL A  16      21.045  23.431  32.552  1.00 47.20           C  
ATOM    127  N   THR A  17      20.589  20.649  30.314  1.00 49.99           N  
ATOM    128  CA  THR A  17      20.192  19.297  30.704  1.00 51.59           C  
ATOM    129  C   THR A  17      21.258  18.666  31.610  1.00 52.41           C  
ATOM    130  O   THR A  17      22.465  18.812  31.371  1.00 51.93           O  
ATOM    131  CB  THR A  17      19.955  18.360  29.471  1.00 51.15           C  
ATOM    132  OG1 THR A  17      21.154  18.261  28.689  1.00 50.80           O  
ATOM    133  CG2 THR A  17      18.820  18.888  28.605  1.00 50.17           C  
ATOM    134  N   LYS A  18      20.799  17.984  32.660  1.00 52.13           N  
ATOM    135  CA  LYS A  18      21.694  17.324  33.602  1.00 51.44           C  
ATOM    136  C   LYS A  18      22.469  16.255  32.859  1.00 50.28           C  
ATOM    137  O   LYS A  18      21.899  15.240  32.456  1.00 50.21           O  
ATOM    138  CB  LYS A  18      20.896  16.663  34.737  1.00 53.62           C  
ATOM    139  CG  LYS A  18      21.693  15.624  35.550  1.00 54.81           C  
ATOM    140  CD  LYS A  18      20.804  14.682  36.377  1.00 55.76           C  
ATOM    141  CE  LYS A  18      20.091  15.399  37.524  1.00 57.45           C  
ATOM    142  NZ  LYS A  18      19.262  14.470  38.358  1.00 57.79           N  
ATOM    143  N   SER A  19      23.761  16.479  32.661  1.00 49.00           N  
ATOM    144  CA  SER A  19      24.582  15.489  31.980  1.00 48.82           C  
ATOM    145  C   SER A  19      25.973  15.428  32.574  1.00 49.32           C  
ATOM    146  O   SER A  19      26.334  16.229  33.434  1.00 49.09           O  
ATOM    147  CB  SER A  19      24.701  15.790  30.484  1.00 47.86           C  
ATOM    148  OG  SER A  19      25.533  14.828  29.849  1.00 44.67           O  
ATOM    149  N   LYS A  20      26.744  14.452  32.115  1.00 49.44           N  
ATOM    150  CA  LYS A  20      28.108  14.276  32.567  1.00 50.38           C  
ATOM    151  C   LYS A  20      28.881  13.971  31.308  1.00 51.02           C  
ATOM    152  O   LYS A  20      29.880  13.254  31.337  1.00 51.89           O  
ATOM    153  CB  LYS A  20      28.207  13.111  33.552  1.00 50.55           C  
ATOM    154  CG  LYS A  20      27.528  11.853  33.065  1.00 52.06           C  
ATOM    155  CD  LYS A  20      27.506  10.777  34.137  1.00 52.89           C  
ATOM    156  CE  LYS A  20      26.489   9.690  33.796  1.00 53.42           C  
ATOM    157  NZ  LYS A  20      26.689   9.140  32.420  1.00 53.12           N  
ATOM    158  N   TYR A  21      28.389  14.520  30.198  1.00 51.67           N  
ATOM    159  CA  TYR A  21      29.007  14.333  28.892  1.00 52.44           C  
ATOM    160  C   TYR A  21      29.500  15.633  28.255  1.00 53.50           C  
ATOM    161  O   TYR A  21      29.113  16.735  28.659  1.00 52.16           O  
ATOM    162  CB  TYR A  21      28.039  13.634  27.939  1.00 51.91           C  
ATOM    163  CG  TYR A  21      27.851  12.156  28.220  1.00 51.91           C  
ATOM    164  CD1 TYR A  21      26.692  11.678  28.843  1.00 51.43           C  
ATOM    165  CD2 TYR A  21      28.822  11.230  27.835  1.00 51.01           C  
ATOM    166  CE1 TYR A  21      26.511  10.315  29.065  1.00 49.66           C  
ATOM    167  CE2 TYR A  21      28.646   9.872  28.053  1.00 49.62           C  
ATOM    168  CZ  TYR A  21      27.494   9.425  28.661  1.00 49.27           C  
ATOM    169  OH  TYR A  21      27.335   8.081  28.835  1.00 50.03           O  
ATOM    170  N   GLY A  22      30.354  15.477  27.242  1.00 55.19           N  
ATOM    171  CA  GLY A  22      30.946  16.611  26.550  1.00 55.82           C  
ATOM    172  C   GLY A  22      30.057  17.440  25.646  1.00 55.98           C  
ATOM    173  O   GLY A  22      28.844  17.218  25.562  1.00 55.99           O  
ATOM    174  N   SER A  23      30.677  18.408  24.972  1.00 55.97           N  
ATOM    175  CA  SER A  23      29.971  19.303  24.062  1.00 55.48           C  
ATOM    176  C   SER A  23      30.036  18.768  22.646  1.00 55.21           C  
ATOM    177  O   SER A  23      31.108  18.697  22.037  1.00 54.98           O  
ATOM    178  CB  SER A  23      30.584  20.699  24.093  1.00 55.15           C  
ATOM    179  OG  SER A  23      31.801  20.740  23.372  1.00 54.93           O  
ATOM    180  N   HIS A  24      28.871  18.398  22.131  1.00 54.88           N  
ATOM    181  CA  HIS A  24      28.755  17.851  20.792  1.00 53.51           C  
ATOM    182  C   HIS A  24      28.835  18.971  19.770  1.00 53.34           C  
ATOM    183  O   HIS A  24      29.437  18.809  18.707  1.00 53.28           O  
ATOM    184  CB  HIS A  24      27.425  17.124  20.657  1.00 52.70           C  
ATOM    185  CG  HIS A  24      27.266  16.405  19.363  1.00 53.09           C  
ATOM    186  ND1 HIS A  24      28.133  15.415  18.957  1.00 54.27           N  
ATOM    187  CD2 HIS A  24      26.342  16.527  18.381  1.00 54.03           C  
ATOM    188  CE1 HIS A  24      27.750  14.957  17.779  1.00 55.29           C  
ATOM    189  NE2 HIS A  24      26.665  15.615  17.407  1.00 55.29           N  
ATOM    190  N   TYR A  25      28.229  20.107  20.105  1.00 52.37           N  
ATOM    191  CA  TYR A  25      28.230  21.255  19.215  1.00 52.02           C  
ATOM    192  C   TYR A  25      28.644  22.545  19.942  1.00 55.14           C  
ATOM    193  O   TYR A  25      29.549  23.256  19.498  1.00 55.56           O  
ATOM    194  CB  TYR A  25      26.846  21.391  18.577  1.00 46.15           C  
ATOM    195  CG  TYR A  25      25.735  21.625  19.561  1.00 40.94           C  
ATOM    196  CD1 TYR A  25      25.343  22.912  19.899  1.00 40.97           C  
ATOM    197  CD2 TYR A  25      25.073  20.569  20.154  1.00 39.20           C  
ATOM    198  CE1 TYR A  25      24.316  23.145  20.797  1.00 38.37           C  
ATOM    199  CE2 TYR A  25      24.039  20.794  21.061  1.00 39.01           C  
ATOM    200  CZ  TYR A  25      23.663  22.090  21.374  1.00 37.88           C  
ATOM    201  OH  TYR A  25      22.617  22.342  22.232  1.00 35.68           O  
ATOM    202  N   GLY A  26      27.995  22.841  21.064  1.00 58.26           N  
ATOM    203  CA  GLY A  26      28.332  24.038  21.807  1.00 59.94           C  
ATOM    204  C   GLY A  26      29.014  23.619  23.085  1.00 62.70           C  
ATOM    205  O   GLY A  26      28.386  22.986  23.933  1.00 62.58           O  
ATOM    206  N   GLU A  27      30.297  23.960  23.207  1.00 65.35           N  
ATOM    207  CA  GLU A  27      31.121  23.634  24.381  1.00 67.83           C  
ATOM    208  C   GLU A  27      30.476  24.110  25.685  1.00 67.97           C  
ATOM    209  O   GLU A  27      31.146  24.253  26.714  1.00 68.09           O  
ATOM    210  CB  GLU A  27      32.517  24.274  24.264  1.00 70.11           C  
ATOM    211  CG  GLU A  27      33.290  23.996  22.966  1.00 73.81           C  
ATOM    212  CD  GLU A  27      32.944  24.956  21.820  1.00 75.31           C  
ATOM    213  OE1 GLU A  27      33.016  26.194  22.018  1.00 74.78           O  
ATOM    214  OE2 GLU A  27      32.615  24.467  20.715  1.00 76.57           O  
ATOM    215  N   LYS A  28      29.175  24.354  25.622  1.00 67.44           N  
ATOM    216  CA  LYS A  28      28.391  24.831  26.746  1.00 67.49           C  
ATOM    217  C   LYS A  28      28.196  23.769  27.835  1.00 67.76           C  
ATOM    218  O   LYS A  28      27.059  23.377  28.126  1.00 67.38           O  
ATOM    219  CB  LYS A  28      27.041  25.276  26.214  1.00 68.08           C  
ATOM    220  CG  LYS A  28      27.106  25.873  24.820  1.00 69.30           C  
ATOM    221  CD  LYS A  28      27.892  27.176  24.808  1.00 70.16           C  
ATOM    222  CE  LYS A  28      27.789  27.862  23.454  1.00 70.32           C  
ATOM    223  NZ  LYS A  28      28.377  29.231  23.460  1.00 70.14           N  
ATOM    224  N   VAL A  29      29.291  23.315  28.445  1.00 67.14           N  
ATOM    225  CA  VAL A  29      29.214  22.290  29.487  1.00 66.42           C  
ATOM    226  C   VAL A  29      29.850  22.663  30.829  1.00 66.09           C  
ATOM    227  O   VAL A  29      31.069  22.679  30.970  1.00 65.36           O  
ATOM    228  CB  VAL A  29      29.846  20.976  28.998  1.00 66.14           C  
ATOM    229  CG1 VAL A  29      31.227  21.244  28.451  1.00 67.29           C  
ATOM    230  CG2 VAL A  29      29.922  19.984  30.139  1.00 66.80           C  
ATOM    231  N   PHE A  30      29.002  22.941  31.817  1.00 66.83           N  
ATOM    232  CA  PHE A  30      29.438  23.308  33.165  1.00 67.55           C  
ATOM    233  C   PHE A  30      28.905  22.339  34.225  1.00 68.18           C  
ATOM    234  O   PHE A  30      27.767  21.895  34.144  1.00 70.28           O  
ATOM    235  CB  PHE A  30      28.985  24.738  33.503  1.00 67.27           C  
ATOM    236  CG  PHE A  30      27.787  25.217  32.707  1.00 67.06           C  
ATOM    237  CD1 PHE A  30      26.614  24.474  32.656  1.00 66.96           C  
ATOM    238  CD2 PHE A  30      27.834  26.427  32.020  1.00 67.40           C  
ATOM    239  CE1 PHE A  30      25.505  24.930  31.932  1.00 67.42           C  
ATOM    240  CE2 PHE A  30      26.732  26.892  31.294  1.00 67.16           C  
ATOM    241  CZ  PHE A  30      25.567  26.141  31.251  1.00 67.14           C  
ATOM    242  N   ASP A  31      29.740  22.023  35.212  1.00 67.72           N  
ATOM    243  CA  ASP A  31      29.412  21.112  36.322  1.00 67.42           C  
ATOM    244  C   ASP A  31      28.112  20.281  36.271  1.00 66.64           C  
ATOM    245  O   ASP A  31      27.153  20.552  37.008  1.00 66.66           O  
ATOM    246  CB  ASP A  31      29.445  21.891  37.646  1.00 68.64           C  
ATOM    247  CG  ASP A  31      30.321  21.218  38.711  1.00 69.44           C  
ATOM    248  OD1 ASP A  31      30.104  20.020  39.017  1.00 69.42           O  
ATOM    249  OD2 ASP A  31      31.226  21.898  39.246  1.00 68.70           O  
ATOM    250  N   GLY A  32      28.087  19.264  35.413  1.00 65.14           N  
ATOM    251  CA  GLY A  32      26.916  18.402  35.319  1.00 64.45           C  
ATOM    252  C   GLY A  32      25.725  18.918  34.532  1.00 63.47           C  
ATOM    253  O   GLY A  32      24.592  18.461  34.722  1.00 63.30           O  
ATOM    254  N   TYR A  33      25.972  19.865  33.636  1.00 62.21           N  
ATOM    255  CA  TYR A  33      24.913  20.442  32.817  1.00 60.71           C  
ATOM    256  C   TYR A  33      25.451  20.888  31.466  1.00 58.88           C  
ATOM    257  O   TYR A  33      26.595  21.333  31.353  1.00 58.24           O  
ATOM    258  CB  TYR A  33      24.291  21.640  33.532  1.00 61.56           C  
ATOM    259  CG  TYR A  33      23.604  21.272  34.811  1.00 62.66           C  
ATOM    260  CD1 TYR A  33      22.257  20.935  34.818  1.00 64.33           C  
ATOM    261  CD2 TYR A  33      24.313  21.205  36.007  1.00 62.94           C  
ATOM    262  CE1 TYR A  33      21.628  20.538  35.983  1.00 66.07           C  
ATOM    263  CE2 TYR A  33      23.701  20.808  37.179  1.00 65.10           C  
ATOM    264  CZ  TYR A  33      22.356  20.473  37.163  1.00 66.35           C  
ATOM    265  OH  TYR A  33      21.736  20.063  38.317  1.00 67.59           O  
ATOM    266  N   ARG A  34      24.620  20.753  30.442  1.00 56.58           N  
ATOM    267  CA  ARG A  34      24.993  21.161  29.099  1.00 53.64           C  
ATOM    268  C   ARG A  34      23.970  22.205  28.665  1.00 52.66           C  
ATOM    269  O   ARG A  34      22.763  21.985  28.789  1.00 52.58           O  
ATOM    270  CB  ARG A  34      24.965  19.951  28.148  1.00 52.48           C  
ATOM    271  CG  ARG A  34      26.168  19.012  28.275  1.00 49.19           C  
ATOM    272  CD  ARG A  34      25.994  17.681  27.526  1.00 47.42           C  
ATOM    273  NE  ARG A  34      25.804  17.818  26.078  1.00 44.81           N  
ATOM    274  CZ  ARG A  34      24.630  18.020  25.483  1.00 43.03           C  
ATOM    275  NH1 ARG A  34      23.516  18.115  26.200  1.00 42.11           N  
ATOM    276  NH2 ARG A  34      24.564  18.115  24.165  1.00 40.83           N  
ATOM    277  N   GLU A  35      24.443  23.354  28.193  1.00 50.58           N  
ATOM    278  CA  GLU A  35      23.519  24.382  27.740  1.00 49.58           C  
ATOM    279  C   GLU A  35      22.844  23.909  26.467  1.00 47.56           C  
ATOM    280  O   GLU A  35      23.508  23.473  25.530  1.00 47.61           O  
ATOM    281  CB  GLU A  35      24.233  25.700  27.432  1.00 51.76           C  
ATOM    282  CG  GLU A  35      23.319  26.702  26.705  1.00 53.35           C  
ATOM    283  CD  GLU A  35      24.052  27.839  25.996  1.00 53.78           C  
ATOM    284  OE1 GLU A  35      23.355  28.766  25.521  1.00 53.56           O  
ATOM    285  OE2 GLU A  35      25.301  27.813  25.905  1.00 52.80           O  
ATOM    286  N   TRP A  36      21.525  24.001  26.429  1.00 45.17           N  
ATOM    287  CA  TRP A  36      20.773  23.595  25.252  1.00 42.52           C  
ATOM    288  C   TRP A  36      20.567  24.868  24.436  1.00 40.11           C  
ATOM    289  O   TRP A  36      19.729  25.697  24.796  1.00 40.91           O  
ATOM    290  CB  TRP A  36      19.419  23.036  25.683  1.00 43.36           C  
ATOM    291  CG  TRP A  36      18.836  22.025  24.759  1.00 44.42           C  
ATOM    292  CD1 TRP A  36      19.208  21.770  23.470  1.00 43.87           C  
ATOM    293  CD2 TRP A  36      17.737  21.156  25.041  1.00 45.41           C  
ATOM    294  NE1 TRP A  36      18.405  20.795  22.932  1.00 44.04           N  
ATOM    295  CE2 TRP A  36      17.493  20.402  23.875  1.00 45.17           C  
ATOM    296  CE3 TRP A  36      16.931  20.944  26.168  1.00 46.13           C  
ATOM    297  CZ2 TRP A  36      16.472  19.448  23.803  1.00 46.07           C  
ATOM    298  CZ3 TRP A  36      15.915  19.997  26.097  1.00 46.03           C  
ATOM    299  CH2 TRP A  36      15.694  19.262  24.922  1.00 46.31           C  
ATOM    300  N   VAL A  37      21.323  25.033  23.351  1.00 35.98           N  
ATOM    301  CA  VAL A  37      21.195  26.240  22.534  1.00 32.17           C  
ATOM    302  C   VAL A  37      19.886  26.266  21.759  1.00 32.15           C  
ATOM    303  O   VAL A  37      19.767  25.655  20.706  1.00 31.13           O  
ATOM    304  CB  VAL A  37      22.336  26.366  21.533  1.00 28.57           C  
ATOM    305  CG1 VAL A  37      22.488  27.804  21.122  1.00 25.60           C  
ATOM    306  CG2 VAL A  37      23.601  25.859  22.134  1.00 26.80           C  
ATOM    307  N   PRO A  38      18.885  26.993  22.264  1.00 33.01           N  
ATOM    308  CA  PRO A  38      17.608  27.036  21.547  1.00 34.76           C  
ATOM    309  C   PRO A  38      17.716  27.487  20.085  1.00 36.30           C  
ATOM    310  O   PRO A  38      16.763  27.336  19.312  1.00 38.20           O  
ATOM    311  CB  PRO A  38      16.762  27.973  22.409  1.00 33.86           C  
ATOM    312  CG  PRO A  38      17.787  28.855  23.062  1.00 32.93           C  
ATOM    313  CD  PRO A  38      18.873  27.901  23.425  1.00 32.55           C  
ATOM    314  N   TRP A  39      18.874  28.024  19.703  1.00 36.02           N  
ATOM    315  CA  TRP A  39      19.103  28.480  18.329  1.00 34.88           C  
ATOM    316  C   TRP A  39      19.623  27.325  17.475  1.00 34.56           C  
ATOM    317  O   TRP A  39      19.777  27.444  16.264  1.00 35.53           O  
ATOM    318  CB  TRP A  39      20.128  29.621  18.305  1.00 33.80           C  
ATOM    319  CG  TRP A  39      19.729  30.771  19.147  1.00 32.98           C  
ATOM    320  CD1 TRP A  39      20.109  31.018  20.435  1.00 32.95           C  
ATOM    321  CD2 TRP A  39      18.789  31.789  18.801  1.00 33.20           C  
ATOM    322  NE1 TRP A  39      19.458  32.127  20.914  1.00 33.31           N  
ATOM    323  CE2 TRP A  39      18.640  32.620  19.930  1.00 33.01           C  
ATOM    324  CE3 TRP A  39      18.056  32.079  17.643  1.00 33.73           C  
ATOM    325  CZ2 TRP A  39      17.784  33.725  19.938  1.00 32.91           C  
ATOM    326  CZ3 TRP A  39      17.209  33.176  17.648  1.00 33.24           C  
ATOM    327  CH2 TRP A  39      17.079  33.989  18.791  1.00 32.98           C  
ATOM    328  N   ARG A  40      19.896  26.205  18.118  1.00 33.14           N  
ATOM    329  CA  ARG A  40      20.400  25.051  17.414  1.00 32.72           C  
ATOM    330  C   ARG A  40      19.604  23.825  17.853  1.00 32.03           C  
ATOM    331  O   ARG A  40      20.156  22.725  17.956  1.00 32.47           O  
ATOM    332  CB  ARG A  40      21.883  24.885  17.746  1.00 33.35           C  
ATOM    333  CG  ARG A  40      22.752  26.045  17.288  1.00 37.17           C  
ATOM    334  CD  ARG A  40      23.299  25.839  15.873  1.00 42.14           C  
ATOM    335  NE  ARG A  40      24.121  24.630  15.782  1.00 48.36           N  
ATOM    336  CZ  ARG A  40      24.819  24.258  14.706  1.00 52.46           C  
ATOM    337  NH1 ARG A  40      24.804  25.006  13.606  1.00 54.81           N  
ATOM    338  NH2 ARG A  40      25.530  23.128  14.722  1.00 52.79           N  
ATOM    339  N   SER A  41      18.310  24.010  18.101  1.00 29.67           N  
ATOM    340  CA  SER A  41      17.478  22.907  18.566  1.00 28.85           C  
ATOM    341  C   SER A  41      16.007  23.284  18.617  1.00 29.76           C  
ATOM    342  O   SER A  41      15.551  23.961  19.545  1.00 29.76           O  
ATOM    343  CB  SER A  41      17.939  22.472  19.960  1.00 27.32           C  
ATOM    344  OG  SER A  41      17.197  21.368  20.440  1.00 26.15           O  
ATOM    345  N   LYS A  42      15.259  22.829  17.622  1.00 29.75           N  
ATOM    346  CA  LYS A  42      13.841  23.128  17.560  1.00 29.90           C  
ATOM    347  C   LYS A  42      13.110  22.576  18.769  1.00 31.20           C  
ATOM    348  O   LYS A  42      11.926  22.843  18.960  1.00 32.23           O  
ATOM    349  CB  LYS A  42      13.250  22.558  16.273  1.00 29.02           C  
ATOM    350  CG  LYS A  42      13.435  23.465  15.081  1.00 28.30           C  
ATOM    351  CD  LYS A  42      13.359  22.700  13.779  1.00 29.85           C  
ATOM    352  CE  LYS A  42      14.744  22.526  13.151  1.00 31.64           C  
ATOM    353  NZ  LYS A  42      15.714  21.798  14.033  1.00 32.66           N  
ATOM    354  N   LEU A  43      13.814  21.807  19.592  1.00 32.24           N  
ATOM    355  CA  LEU A  43      13.198  21.232  20.784  1.00 32.57           C  
ATOM    356  C   LEU A  43      13.413  22.151  21.979  1.00 32.40           C  
ATOM    357  O   LEU A  43      12.452  22.523  22.658  1.00 32.04           O  
ATOM    358  CB  LEU A  43      13.773  19.844  21.080  1.00 31.90           C  
ATOM    359  CG  LEU A  43      12.845  18.904  21.866  1.00 33.79           C  
ATOM    360  CD1 LEU A  43      12.715  19.354  23.311  1.00 35.35           C  
ATOM    361  CD2 LEU A  43      11.475  18.870  21.197  1.00 33.79           C  
ATOM    362  N   ALA A  44      14.669  22.516  22.230  1.00 31.77           N  
ATOM    363  CA  ALA A  44      14.984  23.412  23.335  1.00 31.06           C  
ATOM    364  C   ALA A  44      14.146  24.672  23.153  1.00 30.77           C  
ATOM    365  O   ALA A  44      13.826  25.367  24.117  1.00 29.88           O  
ATOM    366  CB  ALA A  44      16.459  23.757  23.333  1.00 30.35           C  
ATOM    367  N   ALA A  45      13.785  24.954  21.907  1.00 31.09           N  
ATOM    368  CA  ALA A  45      12.969  26.120  21.602  1.00 32.63           C  
ATOM    369  C   ALA A  45      11.518  25.895  22.034  1.00 32.89           C  
ATOM    370  O   ALA A  45      10.901  26.766  22.644  1.00 31.43           O  
ATOM    371  CB  ALA A  45      13.031  26.418  20.113  1.00 33.98           C  
ATOM    372  N   MET A  46      10.975  24.723  21.710  1.00 34.65           N  
ATOM    373  CA  MET A  46       9.598  24.393  22.081  1.00 36.28           C  
ATOM    374  C   MET A  46       9.453  24.512  23.591  1.00 36.84           C  
ATOM    375  O   MET A  46       8.466  25.046  24.097  1.00 36.69           O  
ATOM    376  CB  MET A  46       9.246  22.964  21.660  1.00 35.70           C  
ATOM    377  CG  MET A  46       7.886  22.511  22.176  1.00 36.05           C  
ATOM    378  SD  MET A  46       7.752  20.720  22.218  1.00 38.94           S  
ATOM    379  CE  MET A  46       9.085  20.307  23.389  1.00 36.75           C  
ATOM    380  N   ILE A  47      10.444  23.982  24.301  1.00 37.30           N  
ATOM    381  CA  ILE A  47      10.459  24.036  25.751  1.00 36.56           C  
ATOM    382  C   ILE A  47      10.354  25.498  26.176  1.00 37.17           C  
ATOM    383  O   ILE A  47       9.463  25.857  26.946  1.00 37.41           O  
ATOM    384  CB  ILE A  47      11.760  23.422  26.309  1.00 35.35           C  
ATOM    385  CG1 ILE A  47      11.710  21.902  26.171  1.00 33.19           C  
ATOM    386  CG2 ILE A  47      11.959  23.820  27.756  1.00 35.23           C  
ATOM    387  CD1 ILE A  47      12.973  21.223  26.630  1.00 31.76           C  
ATOM    388  N   LEU A  48      11.246  26.342  25.658  1.00 37.12           N  
ATOM    389  CA  LEU A  48      11.228  27.762  26.004  1.00 37.29           C  
ATOM    390  C   LEU A  48       9.928  28.443  25.617  1.00 38.24           C  
ATOM    391  O   LEU A  48       9.443  29.300  26.353  1.00 38.50           O  
ATOM    392  CB  LEU A  48      12.387  28.501  25.349  1.00 35.01           C  
ATOM    393  CG  LEU A  48      13.783  28.042  25.754  1.00 35.44           C  
ATOM    394  CD1 LEU A  48      14.796  28.974  25.120  1.00 35.11           C  
ATOM    395  CD2 LEU A  48      13.933  28.037  27.271  1.00 35.44           C  
ATOM    396  N   LYS A  49       9.373  28.072  24.466  1.00 39.84           N  
ATOM    397  CA  LYS A  49       8.115  28.654  23.997  1.00 41.64           C  
ATOM    398  C   LYS A  49       6.985  28.367  24.965  1.00 42.97           C  
ATOM    399  O   LYS A  49       5.899  28.934  24.842  1.00 41.59           O  
ATOM    400  CB  LYS A  49       7.726  28.098  22.625  1.00 42.19           C  
ATOM    401  CG  LYS A  49       8.374  28.795  21.470  1.00 41.89           C  
ATOM    402  CD  LYS A  49       7.927  30.234  21.405  1.00 41.34           C  
ATOM    403  CE  LYS A  49       8.853  31.031  20.510  1.00 41.98           C  
ATOM    404  NZ  LYS A  49       8.395  32.429  20.362  1.00 42.57           N  
ATOM    405  N   GLY A  50       7.247  27.468  25.913  1.00 45.77           N  
ATOM    406  CA  GLY A  50       6.247  27.107  26.904  1.00 49.79           C  
ATOM    407  C   GLY A  50       6.051  25.611  27.045  1.00 52.69           C  
ATOM    408  O   GLY A  50       6.719  24.960  27.856  1.00 53.45           O  
ATOM    409  N   HIS A  51       5.130  25.076  26.244  1.00 54.88           N  
ATOM    410  CA  HIS A  51       4.782  23.656  26.231  1.00 56.81           C  
ATOM    411  C   HIS A  51       5.985  22.721  26.375  1.00 56.42           C  
ATOM    412  O   HIS A  51       6.958  22.827  25.627  1.00 55.86           O  
ATOM    413  CB  HIS A  51       4.024  23.346  24.939  1.00 59.73           C  
ATOM    414  CG  HIS A  51       3.458  21.961  24.880  1.00 63.38           C  
ATOM    415  ND1 HIS A  51       4.248  20.831  24.878  1.00 65.08           N  
ATOM    416  CD2 HIS A  51       2.179  21.527  24.802  1.00 64.12           C  
ATOM    417  CE1 HIS A  51       3.478  19.759  24.795  1.00 65.28           C  
ATOM    418  NE2 HIS A  51       2.219  20.155  24.746  1.00 65.33           N  
ATOM    419  N   ARG A  52       5.893  21.799  27.334  1.00 56.38           N  
ATOM    420  CA  ARG A  52       6.960  20.841  27.621  1.00 57.10           C  
ATOM    421  C   ARG A  52       6.524  19.370  27.426  1.00 56.45           C  
ATOM    422  O   ARG A  52       5.401  19.091  27.000  1.00 56.62           O  
ATOM    423  CB  ARG A  52       7.453  21.054  29.057  1.00 58.68           C  
ATOM    424  CG  ARG A  52       7.361  22.504  29.530  1.00 61.66           C  
ATOM    425  CD  ARG A  52       6.724  22.583  30.913  1.00 65.44           C  
ATOM    426  NE  ARG A  52       5.635  21.612  31.069  1.00 68.08           N  
ATOM    427  CZ  ARG A  52       4.506  21.601  30.358  1.00 68.34           C  
ATOM    428  NH1 ARG A  52       4.287  22.519  29.424  1.00 68.33           N  
ATOM    429  NH2 ARG A  52       3.597  20.656  30.578  1.00 67.50           N  
ATOM    430  N   LEU A  53       7.421  18.439  27.749  1.00 54.96           N  
ATOM    431  CA  LEU A  53       7.167  17.001  27.599  1.00 53.37           C  
ATOM    432  C   LEU A  53       7.400  16.198  28.896  1.00 54.26           C  
ATOM    433  O   LEU A  53       8.546  16.020  29.309  1.00 55.39           O  
ATOM    434  CB  LEU A  53       8.082  16.443  26.499  1.00 49.93           C  
ATOM    435  CG  LEU A  53       7.540  16.087  25.113  1.00 48.05           C  
ATOM    436  CD1 LEU A  53       6.908  14.722  25.154  1.00 48.99           C  
ATOM    437  CD2 LEU A  53       6.542  17.123  24.650  1.00 47.71           C  
ATOM    438  N   LYS A  54       6.337  15.711  29.539  1.00 54.13           N  
ATOM    439  CA  LYS A  54       6.506  14.913  30.764  1.00 54.07           C  
ATOM    440  C   LYS A  54       7.011  13.551  30.313  1.00 54.23           C  
ATOM    441  O   LYS A  54       6.632  13.087  29.244  1.00 54.85           O  
ATOM    442  CB  LYS A  54       5.172  14.681  31.488  1.00 54.26           C  
ATOM    443  CG  LYS A  54       4.316  15.898  31.731  1.00 53.60           C  
ATOM    444  CD  LYS A  54       4.825  16.735  32.868  1.00 52.47           C  
ATOM    445  CE  LYS A  54       3.917  17.923  33.050  1.00 53.31           C  
ATOM    446  NZ  LYS A  54       4.658  19.204  32.895  1.00 53.63           N  
ATOM    447  N   LEU A  55       7.849  12.902  31.112  1.00 54.37           N  
ATOM    448  CA  LEU A  55       8.349  11.580  30.738  1.00 54.78           C  
ATOM    449  C   LEU A  55       9.428  11.047  31.668  1.00 55.21           C  
ATOM    450  O   LEU A  55      10.299  11.791  32.123  1.00 55.81           O  
ATOM    451  CB  LEU A  55       8.869  11.581  29.286  1.00 54.14           C  
ATOM    452  CG  LEU A  55       9.914  12.590  28.785  1.00 53.20           C  
ATOM    453  CD1 LEU A  55      11.251  11.910  28.527  1.00 52.42           C  
ATOM    454  CD2 LEU A  55       9.413  13.213  27.495  1.00 52.25           C  
ATOM    455  N   ARG A  56       9.357   9.749  31.950  1.00 54.90           N  
ATOM    456  CA  ARG A  56      10.328   9.100  32.819  1.00 54.68           C  
ATOM    457  C   ARG A  56      11.558   8.730  32.002  1.00 53.87           C  
ATOM    458  O   ARG A  56      11.469   8.520  30.797  1.00 54.24           O  
ATOM    459  CB  ARG A  56       9.724   7.834  33.439  1.00 56.42           C  
ATOM    460  CG  ARG A  56       9.269   6.761  32.426  1.00 58.19           C  
ATOM    461  CD  ARG A  56       9.268   5.372  33.075  1.00 58.92           C  
ATOM    462  NE  ARG A  56       8.863   4.275  32.190  1.00 59.30           N  
ATOM    463  CZ  ARG A  56       7.600   3.971  31.890  1.00 60.46           C  
ATOM    464  NH1 ARG A  56       6.599   4.682  32.396  1.00 60.42           N  
ATOM    465  NH2 ARG A  56       7.337   2.935  31.103  1.00 60.33           N  
ATOM    466  N   GLY A  57      12.708   8.646  32.654  1.00 53.05           N  
ATOM    467  CA  GLY A  57      13.917   8.290  31.933  1.00 52.88           C  
ATOM    468  C   GLY A  57      13.804   6.965  31.199  1.00 53.17           C  
ATOM    469  O   GLY A  57      14.467   6.764  30.184  1.00 52.38           O  
ATOM    470  N   ASP A  58      12.965   6.066  31.715  1.00 55.24           N  
ATOM    471  CA  ASP A  58      12.753   4.738  31.122  1.00 55.87           C  
ATOM    472  C   ASP A  58      11.866   4.859  29.877  1.00 55.38           C  
ATOM    473  O   ASP A  58      10.779   4.284  29.837  1.00 56.58           O  
ATOM    474  CB  ASP A  58      12.050   3.771  32.113  1.00 57.08           C  
ATOM    475  CG  ASP A  58      12.505   3.941  33.578  1.00 58.93           C  
ATOM    476  OD1 ASP A  58      11.835   4.672  34.345  1.00 59.29           O  
ATOM    477  OD2 ASP A  58      13.525   3.337  33.974  1.00 59.29           O  
ATOM    478  N   GLU A  59      12.319   5.594  28.866  1.00 53.62           N  
ATOM    479  CA  GLU A  59      11.520   5.764  27.657  1.00 52.13           C  
ATOM    480  C   GLU A  59      12.175   5.190  26.390  1.00 51.90           C  
ATOM    481  O   GLU A  59      13.405   5.134  26.275  1.00 51.40           O  
ATOM    482  CB  GLU A  59      11.227   7.245  27.449  1.00 51.85           C  
ATOM    483  CG  GLU A  59       9.773   7.566  27.165  1.00 53.10           C  
ATOM    484  CD  GLU A  59       9.040   8.097  28.386  1.00 53.83           C  
ATOM    485  OE1 GLU A  59       9.707   8.389  29.395  1.00 53.92           O  
ATOM    486  OE2 GLU A  59       7.798   8.239  28.341  1.00 53.60           O  
ATOM    487  N   ARG A  60      11.337   4.757  25.447  1.00 50.84           N  
ATOM    488  CA  ARG A  60      11.797   4.195  24.173  1.00 49.48           C  
ATOM    489  C   ARG A  60      11.533   5.213  23.081  1.00 47.85           C  
ATOM    490  O   ARG A  60      10.398   5.339  22.605  1.00 48.39           O  
ATOM    491  CB  ARG A  60      11.048   2.896  23.833  1.00 50.92           C  
ATOM    492  CG  ARG A  60      11.813   1.623  24.171  1.00 52.62           C  
ATOM    493  CD  ARG A  60      12.055   1.521  25.663  1.00 54.60           C  
ATOM    494  NE  ARG A  60      13.203   0.680  25.990  1.00 56.91           N  
ATOM    495  CZ  ARG A  60      13.830   0.716  27.163  1.00 58.88           C  
ATOM    496  NH1 ARG A  60      13.407   1.555  28.103  1.00 60.25           N  
ATOM    497  NH2 ARG A  60      14.882  -0.069  27.394  1.00 57.82           N  
ATOM    498  N   VAL A  61      12.586   5.913  22.666  1.00 44.99           N  
ATOM    499  CA  VAL A  61      12.461   6.953  21.648  1.00 41.03           C  
ATOM    500  C   VAL A  61      12.905   6.649  20.214  1.00 38.58           C  
ATOM    501  O   VAL A  61      13.966   6.063  19.962  1.00 35.95           O  
ATOM    502  CB  VAL A  61      13.200   8.219  22.092  1.00 39.78           C  
ATOM    503  CG1 VAL A  61      12.773   9.391  21.235  1.00 39.32           C  
ATOM    504  CG2 VAL A  61      12.924   8.485  23.549  1.00 40.21           C  
ATOM    505  N   LEU A  62      12.061   7.078  19.281  1.00 36.23           N  
ATOM    506  CA  LEU A  62      12.317   6.936  17.856  1.00 33.62           C  
ATOM    507  C   LEU A  62      12.436   8.358  17.341  1.00 32.52           C  
ATOM    508  O   LEU A  62      11.450   9.108  17.331  1.00 31.55           O  
ATOM    509  CB  LEU A  62      11.150   6.252  17.139  1.00 32.66           C  
ATOM    510  CG  LEU A  62      11.305   6.210  15.614  1.00 29.21           C  
ATOM    511  CD1 LEU A  62      12.444   5.273  15.271  1.00 26.57           C  
ATOM    512  CD2 LEU A  62      10.007   5.777  14.946  1.00 26.29           C  
ATOM    513  N   TYR A  63      13.643   8.724  16.923  1.00 31.26           N  
ATOM    514  CA  TYR A  63      13.917  10.062  16.413  1.00 29.71           C  
ATOM    515  C   TYR A  63      14.072  10.007  14.890  1.00 28.55           C  
ATOM    516  O   TYR A  63      14.956   9.323  14.364  1.00 28.94           O  
ATOM    517  CB  TYR A  63      15.193  10.597  17.086  1.00 29.70           C  
ATOM    518  CG  TYR A  63      15.498  12.070  16.875  1.00 30.15           C  
ATOM    519  CD1 TYR A  63      15.764  12.573  15.602  1.00 30.82           C  
ATOM    520  CD2 TYR A  63      15.584  12.951  17.955  1.00 29.93           C  
ATOM    521  CE1 TYR A  63      16.108  13.910  15.406  1.00 30.52           C  
ATOM    522  CE2 TYR A  63      15.935  14.297  17.765  1.00 30.28           C  
ATOM    523  CZ  TYR A  63      16.194  14.765  16.485  1.00 31.06           C  
ATOM    524  OH  TYR A  63      16.528  16.080  16.256  1.00 32.81           O  
ATOM    525  N   LEU A  64      13.191  10.702  14.180  1.00 26.37           N  
ATOM    526  CA  LEU A  64      13.262  10.735  12.727  1.00 25.32           C  
ATOM    527  C   LEU A  64      13.873  12.055  12.228  1.00 25.14           C  
ATOM    528  O   LEU A  64      13.164  13.049  12.031  1.00 23.26           O  
ATOM    529  CB  LEU A  64      11.873  10.553  12.138  1.00 25.18           C  
ATOM    530  CG  LEU A  64      11.191   9.235  12.479  1.00 24.88           C  
ATOM    531  CD1 LEU A  64       9.774   9.261  11.914  1.00 27.19           C  
ATOM    532  CD2 LEU A  64      11.974   8.079  11.900  1.00 24.02           C  
ATOM    533  N   GLY A  65      15.194  12.045  12.029  1.00 24.91           N  
ATOM    534  CA  GLY A  65      15.917  13.219  11.566  1.00 25.66           C  
ATOM    535  C   GLY A  65      17.084  13.586  12.478  1.00 26.20           C  
ATOM    536  O   GLY A  65      17.407  14.766  12.653  1.00 27.44           O  
ATOM    537  N   ALA A  66      17.720  12.575  13.060  1.00 25.41           N  
ATOM    538  CA  ALA A  66      18.842  12.785  13.965  1.00 26.32           C  
ATOM    539  C   ALA A  66      19.728  13.921  13.529  1.00 27.25           C  
ATOM    540  O   ALA A  66      20.162  14.717  14.361  1.00 29.27           O  
ATOM    541  CB  ALA A  66      19.674  11.527  14.080  1.00 27.16           C  
ATOM    542  N   ALA A  67      20.000  13.994  12.232  1.00 27.23           N  
ATOM    543  CA  ALA A  67      20.849  15.047  11.700  1.00 29.06           C  
ATOM    544  C   ALA A  67      22.252  14.828  12.239  1.00 30.41           C  
ATOM    545  O   ALA A  67      22.677  13.687  12.383  1.00 30.98           O  
ATOM    546  CB  ALA A  67      20.330  16.401  12.130  1.00 28.24           C  
ATOM    547  N   SER A  68      22.967  15.914  12.543  1.00 32.08           N  
ATOM    548  CA  SER A  68      24.325  15.809  13.084  1.00 32.97           C  
ATOM    549  C   SER A  68      24.236  15.206  14.483  1.00 33.23           C  
ATOM    550  O   SER A  68      25.178  14.584  14.967  1.00 31.92           O  
ATOM    551  CB  SER A  68      24.983  17.187  13.177  1.00 32.89           C  
ATOM    552  OG  SER A  68      24.421  17.936  14.245  1.00 33.73           O  
ATOM    553  N   GLY A  69      23.085  15.407  15.119  1.00 34.70           N  
ATOM    554  CA  GLY A  69      22.859  14.884  16.452  1.00 36.00           C  
ATOM    555  C   GLY A  69      22.927  15.931  17.552  1.00 36.83           C  
ATOM    556  O   GLY A  69      23.464  15.664  18.631  1.00 36.11           O  
ATOM    557  N   THR A  70      22.395  17.123  17.305  1.00 36.94           N  
ATOM    558  CA  THR A  70      22.439  18.131  18.349  1.00 37.73           C  
ATOM    559  C   THR A  70      21.172  18.041  19.195  1.00 36.94           C  
ATOM    560  O   THR A  70      21.253  17.856  20.406  1.00 37.00           O  
ATOM    561  CB  THR A  70      22.623  19.572  17.787  1.00 38.57           C  
ATOM    562  OG1 THR A  70      21.363  20.097  17.365  1.00 40.48           O  
ATOM    563  CG2 THR A  70      23.598  19.568  16.610  1.00 38.63           C  
ATOM    564  N   THR A  71      20.001  18.152  18.579  1.00 36.58           N  
ATOM    565  CA  THR A  71      18.767  18.045  19.360  1.00 36.51           C  
ATOM    566  C   THR A  71      18.756  16.649  20.015  1.00 37.10           C  
ATOM    567  O   THR A  71      18.265  16.475  21.125  1.00 37.61           O  
ATOM    568  CB  THR A  71      17.489  18.206  18.473  1.00 36.09           C  
ATOM    569  OG1 THR A  71      17.476  19.494  17.838  1.00 34.76           O  
ATOM    570  CG2 THR A  71      16.244  18.071  19.317  1.00 34.83           C  
ATOM    571  N   VAL A  72      19.314  15.660  19.322  1.00 37.23           N  
ATOM    572  CA  VAL A  72      19.372  14.289  19.833  1.00 36.09           C  
ATOM    573  C   VAL A  72      20.207  14.186  21.107  1.00 35.97           C  
ATOM    574  O   VAL A  72      19.713  13.731  22.137  1.00 36.29           O  
ATOM    575  CB  VAL A  72      19.972  13.310  18.780  1.00 35.33           C  
ATOM    576  CG1 VAL A  72      20.341  11.994  19.437  1.00 31.51           C  
ATOM    577  CG2 VAL A  72      18.977  13.073  17.659  1.00 33.72           C  
ATOM    578  N   SER A  73      21.468  14.608  21.031  1.00 35.51           N  
ATOM    579  CA  SER A  73      22.373  14.541  22.174  1.00 35.18           C  
ATOM    580  C   SER A  73      21.712  14.959  23.481  1.00 34.17           C  
ATOM    581  O   SER A  73      22.073  14.459  24.529  1.00 32.54           O  
ATOM    582  CB  SER A  73      23.627  15.397  21.933  1.00 36.41           C  
ATOM    583  OG  SER A  73      23.366  16.788  22.066  1.00 38.75           O  
ATOM    584  N   HIS A  74      20.745  15.870  23.422  1.00 34.47           N  
ATOM    585  CA  HIS A  74      20.055  16.306  24.633  1.00 34.71           C  
ATOM    586  C   HIS A  74      18.968  15.332  25.025  1.00 34.35           C  
ATOM    587  O   HIS A  74      18.843  14.950  26.186  1.00 35.09           O  
ATOM    588  CB  HIS A  74      19.445  17.692  24.451  1.00 36.62           C  
ATOM    589  CG  HIS A  74      20.447  18.795  24.551  1.00 40.53           C  
ATOM    590  ND1 HIS A  74      21.373  19.051  23.563  1.00 41.75           N  
ATOM    591  CD2 HIS A  74      20.714  19.666  25.552  1.00 41.79           C  
ATOM    592  CE1 HIS A  74      22.166  20.031  23.951  1.00 42.21           C  
ATOM    593  NE2 HIS A  74      21.789  20.422  25.155  1.00 42.60           N  
ATOM    594  N   LEU A  75      18.172  14.922  24.055  1.00 33.32           N  
ATOM    595  CA  LEU A  75      17.115  13.986  24.356  1.00 32.00           C  
ATOM    596  C   LEU A  75      17.729  12.802  25.096  1.00 32.35           C  
ATOM    597  O   LEU A  75      17.115  12.236  25.995  1.00 32.45           O  
ATOM    598  CB  LEU A  75      16.441  13.542  23.065  1.00 29.63           C  
ATOM    599  CG  LEU A  75      14.981  13.131  23.221  1.00 27.78           C  
ATOM    600  CD1 LEU A  75      14.293  14.017  24.233  1.00 26.20           C  
ATOM    601  CD2 LEU A  75      14.300  13.222  21.873  1.00 28.13           C  
ATOM    602  N   ALA A  76      18.961  12.461  24.730  1.00 32.31           N  
ATOM    603  CA  ALA A  76      19.665  11.353  25.351  1.00 33.19           C  
ATOM    604  C   ALA A  76      19.924  11.618  26.829  1.00 35.21           C  
ATOM    605  O   ALA A  76      20.061  10.680  27.619  1.00 35.96           O  
ATOM    606  CB  ALA A  76      20.969  11.103  24.626  1.00 32.44           C  
ATOM    607  N   ASP A  77      20.008  12.891  27.204  1.00 36.43           N  
ATOM    608  CA  ASP A  77      20.235  13.246  28.601  1.00 38.84           C  
ATOM    609  C   ASP A  77      18.917  13.193  29.350  1.00 40.93           C  
ATOM    610  O   ASP A  77      18.883  12.908  30.550  1.00 41.53           O  
ATOM    611  CB  ASP A  77      20.806  14.657  28.732  1.00 39.61           C  
ATOM    612  CG  ASP A  77      22.262  14.739  28.344  1.00 39.89           C  
ATOM    613  OD1 ASP A  77      22.948  13.695  28.420  1.00 39.80           O  
ATOM    614  OD2 ASP A  77      22.716  15.855  27.986  1.00 39.35           O  
ATOM    615  N   ILE A  78      17.838  13.492  28.635  1.00 42.82           N  
ATOM    616  CA  ILE A  78      16.501  13.477  29.205  1.00 45.66           C  
ATOM    617  C   ILE A  78      16.106  12.024  29.459  1.00 48.11           C  
ATOM    618  O   ILE A  78      15.734  11.656  30.574  1.00 49.60           O  
ATOM    619  CB  ILE A  78      15.501  14.140  28.244  1.00 46.26           C  
ATOM    620  CG1 ILE A  78      15.940  15.588  27.980  1.00 46.69           C  
ATOM    621  CG2 ILE A  78      14.097  14.092  28.830  1.00 47.00           C  
ATOM    622  CD1 ILE A  78      15.040  16.376  27.037  1.00 45.49           C  
ATOM    623  N   VAL A  79      16.204  11.198  28.424  1.00 49.99           N  
ATOM    624  CA  VAL A  79      15.892   9.773  28.532  1.00 51.08           C  
ATOM    625  C   VAL A  79      17.197   9.007  28.804  1.00 51.68           C  
ATOM    626  O   VAL A  79      17.698   8.293  27.943  1.00 51.72           O  
ATOM    627  CB  VAL A  79      15.236   9.264  27.219  1.00 50.41           C  
ATOM    628  CG1 VAL A  79      15.013   7.768  27.278  1.00 50.84           C  
ATOM    629  CG2 VAL A  79      13.911   9.976  27.003  1.00 49.68           C  
ATOM    630  N   ASP A  80      17.748   9.172  30.003  1.00 52.83           N  
ATOM    631  CA  ASP A  80      19.003   8.513  30.375  1.00 54.76           C  
ATOM    632  C   ASP A  80      18.832   7.046  30.748  1.00 56.20           C  
ATOM    633  O   ASP A  80      19.810   6.292  30.817  1.00 56.16           O  
ATOM    634  CB  ASP A  80      19.652   9.251  31.548  1.00 54.28           C  
ATOM    635  CG  ASP A  80      18.708   9.424  32.724  1.00 53.15           C  
ATOM    636  OD1 ASP A  80      17.632  10.038  32.539  1.00 50.77           O  
ATOM    637  OD2 ASP A  80      19.049   8.952  33.830  1.00 52.69           O  
ATOM    638  N   GLU A  81      17.585   6.658  30.998  1.00 57.16           N  
ATOM    639  CA  GLU A  81      17.250   5.290  31.376  1.00 57.80           C  
ATOM    640  C   GLU A  81      16.333   4.702  30.304  1.00 56.87           C  
ATOM    641  O   GLU A  81      15.463   3.872  30.591  1.00 57.33           O  
ATOM    642  CB  GLU A  81      16.536   5.281  32.737  1.00 59.84           C  
ATOM    643  CG  GLU A  81      17.230   6.101  33.840  1.00 62.46           C  
ATOM    644  CD  GLU A  81      18.105   5.264  34.765  1.00 63.34           C  
ATOM    645  OE1 GLU A  81      17.560   4.355  35.424  1.00 63.83           O  
ATOM    646  OE2 GLU A  81      19.329   5.521  34.837  1.00 64.30           O  
ATOM    647  N   GLY A  82      16.529   5.161  29.071  1.00 54.75           N  
ATOM    648  CA  GLY A  82      15.736   4.683  27.950  1.00 51.56           C  
ATOM    649  C   GLY A  82      16.656   4.412  26.775  1.00 49.39           C  
ATOM    650  O   GLY A  82      17.867   4.264  26.966  1.00 49.09           O  
ATOM    651  N   ILE A  83      16.100   4.339  25.567  1.00 46.66           N  
ATOM    652  CA  ILE A  83      16.919   4.093  24.381  1.00 44.16           C  
ATOM    653  C   ILE A  83      16.427   4.920  23.188  1.00 42.84           C  
ATOM    654  O   ILE A  83      15.223   5.083  22.986  1.00 42.51           O  
ATOM    655  CB  ILE A  83      16.954   2.574  24.029  1.00 43.37           C  
ATOM    656  CG1 ILE A  83      18.317   2.220  23.447  1.00 42.77           C  
ATOM    657  CG2 ILE A  83      15.860   2.217  23.036  1.00 44.44           C  
ATOM    658  CD1 ILE A  83      19.456   2.596  24.360  1.00 42.17           C  
ATOM    659  N   ILE A  84      17.368   5.444  22.406  1.00 41.15           N  
ATOM    660  CA  ILE A  84      17.043   6.280  21.257  1.00 40.14           C  
ATOM    661  C   ILE A  84      17.426   5.679  19.912  1.00 39.97           C  
ATOM    662  O   ILE A  84      18.608   5.454  19.654  1.00 39.77           O  
ATOM    663  CB  ILE A  84      17.759   7.632  21.361  1.00 40.43           C  
ATOM    664  CG1 ILE A  84      17.320   8.356  22.633  1.00 40.78           C  
ATOM    665  CG2 ILE A  84      17.465   8.474  20.127  1.00 41.27           C  
ATOM    666  CD1 ILE A  84      18.039   9.671  22.865  1.00 40.79           C  
ATOM    667  N   TYR A  85      16.437   5.436  19.051  1.00 39.71           N  
ATOM    668  CA  TYR A  85      16.705   4.890  17.713  1.00 39.19           C  
ATOM    669  C   TYR A  85      16.746   6.069  16.745  1.00 37.23           C  
ATOM    670  O   TYR A  85      15.737   6.409  16.133  1.00 38.03           O  
ATOM    671  CB  TYR A  85      15.602   3.914  17.264  1.00 40.99           C  
ATOM    672  CG  TYR A  85      15.426   2.663  18.115  1.00 43.11           C  
ATOM    673  CD1 TYR A  85      14.477   2.617  19.132  1.00 44.56           C  
ATOM    674  CD2 TYR A  85      16.189   1.520  17.883  1.00 43.98           C  
ATOM    675  CE1 TYR A  85      14.290   1.464  19.893  1.00 45.51           C  
ATOM    676  CE2 TYR A  85      16.009   0.366  18.639  1.00 45.07           C  
ATOM    677  CZ  TYR A  85      15.057   0.346  19.642  1.00 46.42           C  
ATOM    678  OH  TYR A  85      14.860  -0.795  20.390  1.00 48.85           O  
ATOM    679  N   ALA A  86      17.909   6.691  16.606  1.00 33.99           N  
ATOM    680  CA  ALA A  86      18.027   7.847  15.734  1.00 31.83           C  
ATOM    681  C   ALA A  86      18.272   7.481  14.277  1.00 30.33           C  
ATOM    682  O   ALA A  86      19.247   6.805  13.962  1.00 27.97           O  
ATOM    683  CB  ALA A  86      19.132   8.744  16.242  1.00 32.64           C  
ATOM    684  N   VAL A  87      17.381   7.941  13.396  1.00 30.26           N  
ATOM    685  CA  VAL A  87      17.488   7.674  11.954  1.00 31.18           C  
ATOM    686  C   VAL A  87      17.844   8.931  11.140  1.00 32.57           C  
ATOM    687  O   VAL A  87      17.245   9.993  11.322  1.00 33.62           O  
ATOM    688  CB  VAL A  87      16.170   7.082  11.382  1.00 28.94           C  
ATOM    689  CG1 VAL A  87      15.673   5.959  12.277  1.00 27.42           C  
ATOM    690  CG2 VAL A  87      15.123   8.167  11.241  1.00 26.96           C  
ATOM    691  N   GLU A  88      18.820   8.794  10.244  1.00 33.03           N  
ATOM    692  CA  GLU A  88      19.285   9.887   9.387  1.00 32.92           C  
ATOM    693  C   GLU A  88      19.883   9.240   8.143  1.00 33.48           C  
ATOM    694  O   GLU A  88      20.739   8.367   8.260  1.00 34.42           O  
ATOM    695  CB  GLU A  88      20.350  10.703  10.118  1.00 32.11           C  
ATOM    696  CG  GLU A  88      21.099  11.676   9.241  1.00 34.17           C  
ATOM    697  CD  GLU A  88      20.189  12.686   8.576  1.00 35.39           C  
ATOM    698  OE1 GLU A  88      19.652  13.570   9.276  1.00 36.31           O  
ATOM    699  OE2 GLU A  88      20.009  12.586   7.347  1.00 36.30           O  
ATOM    700  N   TYR A  89      19.453   9.656   6.953  1.00 33.49           N  
ATOM    701  CA  TYR A  89      19.981   9.020   5.750  1.00 33.39           C  
ATOM    702  C   TYR A  89      21.078   9.705   4.958  1.00 34.07           C  
ATOM    703  O   TYR A  89      21.553   9.143   3.968  1.00 33.88           O  
ATOM    704  CB  TYR A  89      18.842   8.642   4.795  1.00 32.16           C  
ATOM    705  CG  TYR A  89      18.156   9.763   4.048  1.00 29.15           C  
ATOM    706  CD1 TYR A  89      18.547  11.083   4.193  1.00 28.16           C  
ATOM    707  CD2 TYR A  89      17.099   9.482   3.186  1.00 28.76           C  
ATOM    708  CE1 TYR A  89      17.898  12.093   3.499  1.00 29.22           C  
ATOM    709  CE2 TYR A  89      16.448  10.479   2.490  1.00 28.58           C  
ATOM    710  CZ  TYR A  89      16.846  11.782   2.649  1.00 28.84           C  
ATOM    711  OH  TYR A  89      16.180  12.774   1.967  1.00 29.81           O  
ATOM    712  N   SER A  90      21.481  10.902   5.381  1.00 34.85           N  
ATOM    713  CA  SER A  90      22.552  11.622   4.696  1.00 35.53           C  
ATOM    714  C   SER A  90      23.844  11.381   5.454  1.00 35.08           C  
ATOM    715  O   SER A  90      23.933  11.671   6.646  1.00 33.54           O  
ATOM    716  CB  SER A  90      22.265  13.126   4.642  1.00 37.25           C  
ATOM    717  OG  SER A  90      23.272  13.810   3.902  1.00 39.19           O  
ATOM    718  N   ALA A  91      24.841  10.847   4.755  1.00 35.20           N  
ATOM    719  CA  ALA A  91      26.122  10.544   5.371  1.00 36.07           C  
ATOM    720  C   ALA A  91      26.831  11.769   5.939  1.00 36.68           C  
ATOM    721  O   ALA A  91      27.382  11.706   7.035  1.00 37.66           O  
ATOM    722  CB  ALA A  91      27.022   9.834   4.372  1.00 35.58           C  
ATOM    723  N   LYS A  92      26.817  12.879   5.210  1.00 37.16           N  
ATOM    724  CA  LYS A  92      27.488  14.089   5.678  1.00 38.70           C  
ATOM    725  C   LYS A  92      27.260  14.351   7.174  1.00 38.03           C  
ATOM    726  O   LYS A  92      28.197  14.301   7.976  1.00 38.31           O  
ATOM    727  CB  LYS A  92      27.025  15.299   4.854  1.00 41.47           C  
ATOM    728  CG  LYS A  92      27.522  16.664   5.354  1.00 45.46           C  
ATOM    729  CD  LYS A  92      29.008  16.899   5.069  1.00 47.95           C  
ATOM    730  CE  LYS A  92      29.471  18.274   5.573  1.00 48.42           C  
ATOM    731  NZ  LYS A  92      29.388  18.405   7.064  1.00 48.81           N  
ATOM    732  N   PRO A  93      26.004  14.603   7.571  1.00 36.21           N  
ATOM    733  CA  PRO A  93      25.682  14.871   8.972  1.00 35.46           C  
ATOM    734  C   PRO A  93      25.893  13.644   9.840  1.00 35.64           C  
ATOM    735  O   PRO A  93      26.323  13.732  10.991  1.00 35.73           O  
ATOM    736  CB  PRO A  93      24.218  15.253   8.901  1.00 35.64           C  
ATOM    737  CG  PRO A  93      23.711  14.317   7.857  1.00 35.26           C  
ATOM    738  CD  PRO A  93      24.770  14.420   6.786  1.00 35.25           C  
ATOM    739  N   PHE A  94      25.571  12.497   9.262  1.00 35.60           N  
ATOM    740  CA  PHE A  94      25.682  11.231   9.953  1.00 34.66           C  
ATOM    741  C   PHE A  94      27.100  11.005  10.431  1.00 33.89           C  
ATOM    742  O   PHE A  94      27.313  10.435  11.490  1.00 35.83           O  
ATOM    743  CB  PHE A  94      25.262  10.090   9.026  1.00 36.55           C  
ATOM    744  CG  PHE A  94      24.799   8.871   9.752  1.00 37.80           C  
ATOM    745  CD1 PHE A  94      23.500   8.794  10.245  1.00 37.68           C  
ATOM    746  CD2 PHE A  94      25.683   7.829  10.017  1.00 38.68           C  
ATOM    747  CE1 PHE A  94      23.088   7.700  10.997  1.00 38.46           C  
ATOM    748  CE2 PHE A  94      25.284   6.732  10.768  1.00 39.13           C  
ATOM    749  CZ  PHE A  94      23.984   6.667  11.262  1.00 39.19           C  
ATOM    750  N   GLU A  95      28.075  11.452   9.653  1.00 32.30           N  
ATOM    751  CA  GLU A  95      29.458  11.264  10.035  1.00 31.44           C  
ATOM    752  C   GLU A  95      29.679  11.872  11.408  1.00 29.41           C  
ATOM    753  O   GLU A  95      30.393  11.313  12.231  1.00 28.57           O  
ATOM    754  CB  GLU A  95      30.378  11.911   9.003  1.00 35.13           C  
ATOM    755  CG  GLU A  95      31.860  11.767   9.319  1.00 41.97           C  
ATOM    756  CD  GLU A  95      32.760  12.416   8.268  1.00 46.67           C  
ATOM    757  OE1 GLU A  95      32.458  13.553   7.832  1.00 49.04           O  
ATOM    758  OE2 GLU A  95      33.778  11.791   7.885  1.00 49.40           O  
ATOM    759  N   LYS A  96      29.046  13.014  11.651  1.00 28.33           N  
ATOM    760  CA  LYS A  96      29.159  13.716  12.926  1.00 27.61           C  
ATOM    761  C   LYS A  96      28.320  13.041  14.000  1.00 26.32           C  
ATOM    762  O   LYS A  96      28.620  13.151  15.185  1.00 25.85           O  
ATOM    763  CB  LYS A  96      28.701  15.173  12.773  1.00 29.29           C  
ATOM    764  CG  LYS A  96      28.754  16.018  14.056  1.00 30.99           C  
ATOM    765  CD  LYS A  96      30.177  16.112  14.594  1.00 33.68           C  
ATOM    766  CE  LYS A  96      30.399  17.307  15.525  1.00 34.12           C  
ATOM    767  NZ  LYS A  96      31.873  17.530  15.762  1.00 34.45           N  
ATOM    768  N   LEU A  97      27.264  12.349  13.577  1.00 25.31           N  
ATOM    769  CA  LEU A  97      26.366  11.661  14.504  1.00 24.42           C  
ATOM    770  C   LEU A  97      27.072  10.538  15.254  1.00 24.47           C  
ATOM    771  O   LEU A  97      26.987  10.453  16.480  1.00 25.81           O  
ATOM    772  CB  LEU A  97      25.150  11.080  13.758  1.00 21.07           C  
ATOM    773  CG  LEU A  97      23.980  10.556  14.610  1.00 18.51           C  
ATOM    774  CD1 LEU A  97      23.119  11.707  15.112  1.00 17.01           C  
ATOM    775  CD2 LEU A  97      23.130   9.618  13.792  1.00 17.70           C  
ATOM    776  N   LEU A  98      27.765   9.679  14.516  1.00 24.62           N  
ATOM    777  CA  LEU A  98      28.476   8.549  15.111  1.00 26.05           C  
ATOM    778  C   LEU A  98      29.345   8.946  16.296  1.00 25.86           C  
ATOM    779  O   LEU A  98      29.567   8.150  17.206  1.00 25.42           O  
ATOM    780  CB  LEU A  98      29.338   7.831  14.057  1.00 26.87           C  
ATOM    781  CG  LEU A  98      28.645   6.925  13.028  1.00 26.03           C  
ATOM    782  CD1 LEU A  98      29.695   6.291  12.140  1.00 26.74           C  
ATOM    783  CD2 LEU A  98      27.846   5.845  13.729  1.00 24.78           C  
ATOM    784  N   GLU A  99      29.838  10.176  16.277  1.00 25.91           N  
ATOM    785  CA  GLU A  99      30.670  10.665  17.354  1.00 28.18           C  
ATOM    786  C   GLU A  99      29.870  10.772  18.639  1.00 30.22           C  
ATOM    787  O   GLU A  99      30.424  10.639  19.735  1.00 32.75           O  
ATOM    788  CB  GLU A  99      31.240  12.019  16.997  1.00 29.52           C  
ATOM    789  CG  GLU A  99      32.323  11.948  15.968  1.00 32.77           C  
ATOM    790  CD  GLU A  99      32.865  13.309  15.650  1.00 35.15           C  
ATOM    791  OE1 GLU A  99      32.959  14.141  16.585  1.00 36.37           O  
ATOM    792  OE2 GLU A  99      33.204  13.542  14.472  1.00 36.42           O  
ATOM    793  N   LEU A 100      28.571  11.030  18.511  1.00 29.69           N  
ATOM    794  CA  LEU A 100      27.714  11.114  19.680  1.00 28.54           C  
ATOM    795  C   LEU A 100      27.432   9.690  20.161  1.00 30.31           C  
ATOM    796  O   LEU A 100      27.742   9.337  21.302  1.00 31.17           O  
ATOM    797  CB  LEU A 100      26.402  11.806  19.336  1.00 27.15           C  
ATOM    798  CG  LEU A 100      25.457  11.971  20.528  1.00 26.02           C  
ATOM    799  CD1 LEU A 100      26.165  12.727  21.621  1.00 26.07           C  
ATOM    800  CD2 LEU A 100      24.193  12.708  20.110  1.00 26.76           C  
ATOM    801  N   VAL A 101      26.859   8.865  19.286  1.00 31.27           N  
ATOM    802  CA  VAL A 101      26.551   7.485  19.655  1.00 32.65           C  
ATOM    803  C   VAL A 101      27.785   6.769  20.183  1.00 31.99           C  
ATOM    804  O   VAL A 101      27.675   5.759  20.868  1.00 31.39           O  
ATOM    805  CB  VAL A 101      25.989   6.665  18.462  1.00 34.03           C  
ATOM    806  CG1 VAL A 101      24.732   7.325  17.929  1.00 33.36           C  
ATOM    807  CG2 VAL A 101      27.044   6.521  17.371  1.00 33.15           C  
ATOM    808  N   ARG A 102      28.958   7.284  19.848  1.00 32.21           N  
ATOM    809  CA  ARG A 102      30.194   6.682  20.317  1.00 33.94           C  
ATOM    810  C   ARG A 102      30.393   7.109  21.768  1.00 34.78           C  
ATOM    811  O   ARG A 102      30.635   6.278  22.651  1.00 34.68           O  
ATOM    812  CB  ARG A 102      31.377   7.156  19.470  1.00 33.88           C  
ATOM    813  CG  ARG A 102      32.120   6.042  18.752  1.00 33.78           C  
ATOM    814  CD  ARG A 102      33.396   6.574  18.088  1.00 36.58           C  
ATOM    815  NE  ARG A 102      33.157   7.412  16.905  1.00 35.52           N  
ATOM    816  CZ  ARG A 102      32.711   6.952  15.737  1.00 33.98           C  
ATOM    817  NH1 ARG A 102      32.453   5.658  15.590  1.00 31.47           N  
ATOM    818  NH2 ARG A 102      32.527   7.785  14.715  1.00 31.83           N  
ATOM    819  N   GLU A 103      30.274   8.411  22.009  1.00 35.40           N  
ATOM    820  CA  GLU A 103      30.441   8.952  23.349  1.00 36.96           C  
ATOM    821  C   GLU A 103      29.366   8.430  24.289  1.00 37.64           C  
ATOM    822  O   GLU A 103      29.659   7.949  25.383  1.00 38.31           O  
ATOM    823  CB  GLU A 103      30.381  10.477  23.327  1.00 36.71           C  
ATOM    824  CG  GLU A 103      30.421  11.082  24.710  1.00 37.06           C  
ATOM    825  CD  GLU A 103      29.528  12.305  24.853  1.00 37.94           C  
ATOM    826  OE1 GLU A 103      28.350  12.245  24.422  1.00 34.71           O  
ATOM    827  OE2 GLU A 103      30.008  13.315  25.416  1.00 38.88           O  
ATOM    828  N   ARG A 104      28.118   8.526  23.853  1.00 38.32           N  
ATOM    829  CA  ARG A 104      27.011   8.074  24.671  1.00 39.99           C  
ATOM    830  C   ARG A 104      26.645   6.639  24.390  1.00 40.13           C  
ATOM    831  O   ARG A 104      26.926   6.123  23.320  1.00 42.00           O  
ATOM    832  CB  ARG A 104      25.812   8.973  24.446  1.00 40.86           C  
ATOM    833  CG  ARG A 104      26.159  10.406  24.673  1.00 41.11           C  
ATOM    834  CD  ARG A 104      25.082  11.094  25.420  1.00 42.01           C  
ATOM    835  NE  ARG A 104      25.330  12.518  25.398  1.00 45.80           N  
ATOM    836  CZ  ARG A 104      24.399  13.425  25.643  1.00 49.26           C  
ATOM    837  NH1 ARG A 104      23.168  13.026  25.930  1.00 50.94           N  
ATOM    838  NH2 ARG A 104      24.690  14.721  25.579  1.00 51.38           N  
ATOM    839  N   ASN A 105      25.992   6.004  25.353  1.00 40.35           N  
ATOM    840  CA  ASN A 105      25.615   4.599  25.218  1.00 40.58           C  
ATOM    841  C   ASN A 105      24.114   4.304  25.200  1.00 39.01           C  
ATOM    842  O   ASN A 105      23.706   3.205  25.559  1.00 36.99           O  
ATOM    843  CB  ASN A 105      26.256   3.794  26.358  1.00 42.70           C  
ATOM    844  CG  ASN A 105      25.740   4.211  27.747  1.00 44.07           C  
ATOM    845  OD1 ASN A 105      26.121   3.618  28.762  1.00 43.13           O  
ATOM    846  ND2 ASN A 105      24.875   5.234  27.792  1.00 43.16           N  
ATOM    847  N   ASN A 106      23.290   5.260  24.787  1.00 38.36           N  
ATOM    848  CA  ASN A 106      21.846   5.030  24.774  1.00 38.07           C  
ATOM    849  C   ASN A 106      21.182   5.436  23.477  1.00 37.65           C  
ATOM    850  O   ASN A 106      19.954   5.548  23.411  1.00 37.18           O  
ATOM    851  CB  ASN A 106      21.180   5.765  25.936  1.00 39.87           C  
ATOM    852  CG  ASN A 106      21.551   7.238  25.992  1.00 42.21           C  
ATOM    853  OD1 ASN A 106      22.733   7.605  26.104  1.00 44.22           O  
ATOM    854  ND2 ASN A 106      20.540   8.094  25.927  1.00 42.52           N  
ATOM    855  N   ILE A 107      22.003   5.658  22.452  1.00 37.03           N  
ATOM    856  CA  ILE A 107      21.514   6.042  21.129  1.00 34.12           C  
ATOM    857  C   ILE A 107      21.913   4.983  20.103  1.00 31.76           C  
ATOM    858  O   ILE A 107      23.083   4.586  20.015  1.00 29.00           O  
ATOM    859  CB  ILE A 107      22.075   7.426  20.684  1.00 34.75           C  
ATOM    860  CG1 ILE A 107      21.731   8.495  21.732  1.00 32.15           C  
ATOM    861  CG2 ILE A 107      21.475   7.822  19.322  1.00 33.81           C  
ATOM    862  CD1 ILE A 107      22.474   9.785  21.551  1.00 29.15           C  
ATOM    863  N   ILE A 108      20.910   4.533  19.349  1.00 30.11           N  
ATOM    864  CA  ILE A 108      21.064   3.520  18.309  1.00 28.95           C  
ATOM    865  C   ILE A 108      20.932   4.152  16.919  1.00 28.06           C  
ATOM    866  O   ILE A 108      19.877   4.689  16.554  1.00 26.86           O  
ATOM    867  CB  ILE A 108      19.994   2.426  18.444  1.00 30.36           C  
ATOM    868  CG1 ILE A 108      19.988   1.861  19.873  1.00 30.08           C  
ATOM    869  CG2 ILE A 108      20.251   1.339  17.408  1.00 32.61           C  
ATOM    870  CD1 ILE A 108      21.302   1.218  20.306  1.00 29.56           C  
ATOM    871  N   PRO A 109      22.008   4.080  16.119  1.00 27.46           N  
ATOM    872  CA  PRO A 109      22.061   4.640  14.769  1.00 25.50           C  
ATOM    873  C   PRO A 109      21.404   3.821  13.671  1.00 25.60           C  
ATOM    874  O   PRO A 109      21.703   2.652  13.473  1.00 23.50           O  
ATOM    875  CB  PRO A 109      23.552   4.816  14.545  1.00 25.80           C  
ATOM    876  CG  PRO A 109      24.112   3.611  15.223  1.00 26.54           C  
ATOM    877  CD  PRO A 109      23.319   3.522  16.508  1.00 26.86           C  
ATOM    878  N   LEU A 110      20.489   4.468  12.963  1.00 28.23           N  
ATOM    879  CA  LEU A 110      19.771   3.857  11.854  1.00 28.95           C  
ATOM    880  C   LEU A 110      20.002   4.765  10.659  1.00 28.61           C  
ATOM    881  O   LEU A 110      19.358   5.801  10.501  1.00 29.38           O  
ATOM    882  CB  LEU A 110      18.274   3.749  12.160  1.00 29.73           C  
ATOM    883  CG  LEU A 110      17.877   2.985  13.436  1.00 31.68           C  
ATOM    884  CD1 LEU A 110      16.368   2.699  13.415  1.00 32.13           C  
ATOM    885  CD2 LEU A 110      18.663   1.678  13.542  1.00 30.53           C  
ATOM    886  N   LEU A 111      20.951   4.355   9.838  1.00 26.59           N  
ATOM    887  CA  LEU A 111      21.365   5.058   8.642  1.00 26.50           C  
ATOM    888  C   LEU A 111      20.485   4.718   7.444  1.00 26.52           C  
ATOM    889  O   LEU A 111      20.985   4.502   6.336  1.00 25.26           O  
ATOM    890  CB  LEU A 111      22.800   4.663   8.353  1.00 28.06           C  
ATOM    891  CG  LEU A 111      23.130   3.249   8.856  1.00 29.15           C  
ATOM    892  CD1 LEU A 111      23.114   3.216  10.385  1.00 28.98           C  
ATOM    893  CD2 LEU A 111      22.135   2.251   8.293  1.00 28.14           C  
ATOM    894  N   PHE A 112      19.174   4.692   7.677  1.00 27.07           N  
ATOM    895  CA  PHE A 112      18.198   4.351   6.646  1.00 25.66           C  
ATOM    896  C   PHE A 112      17.224   5.463   6.341  1.00 24.14           C  
ATOM    897  O   PHE A 112      17.070   6.395   7.122  1.00 22.48           O  
ATOM    898  CB  PHE A 112      17.405   3.133   7.085  1.00 24.86           C  
ATOM    899  CG  PHE A 112      18.257   1.983   7.486  1.00 25.69           C  
ATOM    900  CD1 PHE A 112      19.043   1.325   6.548  1.00 26.24           C  
ATOM    901  CD2 PHE A 112      18.274   1.549   8.799  1.00 26.78           C  
ATOM    902  CE1 PHE A 112      19.840   0.239   6.912  1.00 27.47           C  
ATOM    903  CE2 PHE A 112      19.067   0.461   9.180  1.00 29.23           C  
ATOM    904  CZ  PHE A 112      19.854  -0.195   8.230  1.00 28.02           C  
ATOM    905  N   ASP A 113      16.557   5.340   5.198  1.00 24.61           N  
ATOM    906  CA  ASP A 113      15.566   6.324   4.780  1.00 25.47           C  
ATOM    907  C   ASP A 113      14.341   6.203   5.671  1.00 24.03           C  
ATOM    908  O   ASP A 113      13.714   5.146   5.734  1.00 24.61           O  
ATOM    909  CB  ASP A 113      15.174   6.095   3.315  1.00 28.77           C  
ATOM    910  CG  ASP A 113      14.149   7.107   2.812  1.00 31.62           C  
ATOM    911  OD1 ASP A 113      14.128   8.232   3.348  1.00 35.88           O  
ATOM    912  OD2 ASP A 113      13.379   6.795   1.873  1.00 32.14           O  
ATOM    913  N   ALA A 114      14.009   7.282   6.369  1.00 22.60           N  
ATOM    914  CA  ALA A 114      12.857   7.278   7.262  1.00 22.20           C  
ATOM    915  C   ALA A 114      11.553   7.148   6.482  1.00 21.37           C  
ATOM    916  O   ALA A 114      10.563   6.636   6.990  1.00 20.11           O  
ATOM    917  CB  ALA A 114      12.841   8.549   8.095  1.00 21.15           C  
ATOM    918  N   SER A 115      11.575   7.602   5.237  1.00 22.10           N  
ATOM    919  CA  SER A 115      10.399   7.579   4.377  1.00 23.40           C  
ATOM    920  C   SER A 115       9.697   6.242   4.261  1.00 23.67           C  
ATOM    921  O   SER A 115       8.521   6.191   3.889  1.00 23.85           O  
ATOM    922  CB  SER A 115      10.762   8.057   2.979  1.00 24.56           C  
ATOM    923  OG  SER A 115       9.616   8.025   2.155  1.00 28.27           O  
ATOM    924  N   LYS A 116      10.419   5.166   4.565  1.00 23.30           N  
ATOM    925  CA  LYS A 116       9.866   3.818   4.501  1.00 23.73           C  
ATOM    926  C   LYS A 116      10.330   2.987   5.701  1.00 24.09           C  
ATOM    927  O   LYS A 116      11.337   2.283   5.631  1.00 22.71           O  
ATOM    928  CB  LYS A 116      10.266   3.152   3.182  1.00 22.49           C  
ATOM    929  CG  LYS A 116      11.707   3.355   2.790  1.00 23.61           C  
ATOM    930  CD  LYS A 116      11.929   3.030   1.320  1.00 25.32           C  
ATOM    931  CE  LYS A 116      11.180   4.000   0.409  1.00 25.06           C  
ATOM    932  NZ  LYS A 116      11.807   5.347   0.394  1.00 25.13           N  
ATOM    933  N   PRO A 117       9.572   3.058   6.818  1.00 25.31           N  
ATOM    934  CA  PRO A 117       9.825   2.359   8.085  1.00 25.01           C  
ATOM    935  C   PRO A 117       9.901   0.838   7.988  1.00 25.24           C  
ATOM    936  O   PRO A 117      10.684   0.202   8.694  1.00 25.52           O  
ATOM    937  CB  PRO A 117       8.668   2.833   8.972  1.00 24.02           C  
ATOM    938  CG  PRO A 117       7.561   3.011   7.999  1.00 23.04           C  
ATOM    939  CD  PRO A 117       8.253   3.727   6.862  1.00 24.79           C  
ATOM    940  N   TRP A 118       9.085   0.255   7.120  1.00 25.28           N  
ATOM    941  CA  TRP A 118       9.077  -1.190   6.959  1.00 24.86           C  
ATOM    942  C   TRP A 118      10.475  -1.718   6.670  1.00 23.36           C  
ATOM    943  O   TRP A 118      10.795  -2.868   6.970  1.00 22.97           O  
ATOM    944  CB  TRP A 118       8.105  -1.585   5.845  1.00 26.60           C  
ATOM    945  CG  TRP A 118       8.260  -0.807   4.589  1.00 30.85           C  
ATOM    946  CD1 TRP A 118       9.142  -1.046   3.570  1.00 33.22           C  
ATOM    947  CD2 TRP A 118       7.509   0.349   4.209  1.00 33.51           C  
ATOM    948  NE1 TRP A 118       8.980  -0.108   2.571  1.00 34.68           N  
ATOM    949  CE2 TRP A 118       7.984   0.759   2.940  1.00 34.99           C  
ATOM    950  CE3 TRP A 118       6.479   1.082   4.817  1.00 33.57           C  
ATOM    951  CZ2 TRP A 118       7.460   1.873   2.267  1.00 36.15           C  
ATOM    952  CZ3 TRP A 118       5.960   2.188   4.150  1.00 34.41           C  
ATOM    953  CH2 TRP A 118       6.450   2.572   2.888  1.00 35.43           C  
ATOM    954  N   LYS A 119      11.306  -0.861   6.098  1.00 21.58           N  
ATOM    955  CA  LYS A 119      12.667  -1.225   5.762  1.00 20.43           C  
ATOM    956  C   LYS A 119      13.489  -1.554   7.006  1.00 19.79           C  
ATOM    957  O   LYS A 119      14.362  -2.414   6.969  1.00 19.90           O  
ATOM    958  CB  LYS A 119      13.321  -0.075   5.012  1.00 22.28           C  
ATOM    959  CG  LYS A 119      14.147  -0.497   3.834  1.00 22.48           C  
ATOM    960  CD  LYS A 119      13.253  -0.967   2.717  1.00 22.79           C  
ATOM    961  CE  LYS A 119      14.055  -1.156   1.443  1.00 23.94           C  
ATOM    962  NZ  LYS A 119      14.723   0.093   0.992  1.00 21.69           N  
ATOM    963  N   TYR A 120      13.223  -0.861   8.105  1.00 19.88           N  
ATOM    964  CA  TYR A 120      13.955  -1.100   9.349  1.00 22.32           C  
ATOM    965  C   TYR A 120      13.002  -1.565  10.469  1.00 24.43           C  
ATOM    966  O   TYR A 120      13.368  -1.623  11.650  1.00 25.07           O  
ATOM    967  CB  TYR A 120      14.728   0.175   9.760  1.00 19.90           C  
ATOM    968  CG  TYR A 120      13.881   1.428   9.895  1.00 17.68           C  
ATOM    969  CD1 TYR A 120      12.960   1.563  10.935  1.00 17.31           C  
ATOM    970  CD2 TYR A 120      13.966   2.458   8.962  1.00 15.01           C  
ATOM    971  CE1 TYR A 120      12.142   2.687  11.037  1.00 15.03           C  
ATOM    972  CE2 TYR A 120      13.151   3.585   9.059  1.00 13.83           C  
ATOM    973  CZ  TYR A 120      12.242   3.692  10.098  1.00 13.67           C  
ATOM    974  OH  TYR A 120      11.432   4.799  10.205  1.00 12.24           O  
ATOM    975  N   SER A 121      11.782  -1.915  10.064  1.00 25.73           N  
ATOM    976  CA  SER A 121      10.731  -2.370  10.969  1.00 26.34           C  
ATOM    977  C   SER A 121      11.141  -3.528  11.863  1.00 27.74           C  
ATOM    978  O   SER A 121      10.489  -3.795  12.870  1.00 28.16           O  
ATOM    979  CB  SER A 121       9.499  -2.803  10.178  1.00 25.45           C  
ATOM    980  OG  SER A 121       9.534  -4.198   9.930  1.00 21.74           O  
ATOM    981  N   GLY A 122      12.196  -4.239  11.487  1.00 29.23           N  
ATOM    982  CA  GLY A 122      12.635  -5.352  12.310  1.00 31.82           C  
ATOM    983  C   GLY A 122      13.755  -4.983  13.275  1.00 33.09           C  
ATOM    984  O   GLY A 122      14.464  -5.862  13.776  1.00 32.46           O  
ATOM    985  N   ILE A 123      13.915  -3.684  13.531  1.00 33.34           N  
ATOM    986  CA  ILE A 123      14.958  -3.186  14.424  1.00 33.15           C  
ATOM    987  C   ILE A 123      14.325  -2.313  15.492  1.00 33.68           C  
ATOM    988  O   ILE A 123      14.673  -2.381  16.673  1.00 33.84           O  
ATOM    989  CB  ILE A 123      16.000  -2.317  13.663  1.00 32.47           C  
ATOM    990  CG1 ILE A 123      16.706  -3.144  12.586  1.00 30.60           C  
ATOM    991  CG2 ILE A 123      17.026  -1.760  14.640  1.00 33.02           C  
ATOM    992  CD1 ILE A 123      17.729  -2.363  11.792  1.00 27.53           C  
ATOM    993  N   VAL A 124      13.393  -1.479  15.065  1.00 34.16           N  
ATOM    994  CA  VAL A 124      12.727  -0.589  15.989  1.00 35.75           C  
ATOM    995  C   VAL A 124      11.643  -1.339  16.747  1.00 37.28           C  
ATOM    996  O   VAL A 124      10.849  -2.068  16.156  1.00 37.55           O  
ATOM    997  CB  VAL A 124      12.112   0.603  15.241  1.00 34.73           C  
ATOM    998  CG1 VAL A 124      11.445   1.546  16.214  1.00 33.70           C  
ATOM    999  CG2 VAL A 124      13.198   1.320  14.460  1.00 34.65           C  
ATOM   1000  N   GLU A 125      11.631  -1.170  18.065  1.00 38.76           N  
ATOM   1001  CA  GLU A 125      10.635  -1.813  18.907  1.00 39.85           C  
ATOM   1002  C   GLU A 125       9.455  -0.870  19.046  1.00 40.81           C  
ATOM   1003  O   GLU A 125       9.424   0.189  18.419  1.00 42.92           O  
ATOM   1004  CB  GLU A 125      11.206  -2.097  20.291  1.00 40.84           C  
ATOM   1005  CG  GLU A 125      11.434  -0.868  21.140  1.00 41.20           C  
ATOM   1006  CD  GLU A 125      11.896  -1.233  22.534  1.00 43.32           C  
ATOM   1007  OE1 GLU A 125      13.060  -1.672  22.683  1.00 41.83           O  
ATOM   1008  OE2 GLU A 125      11.082  -1.093  23.476  1.00 43.94           O  
ATOM   1009  N   LYS A 126       8.474  -1.249  19.858  1.00 40.68           N  
ATOM   1010  CA  LYS A 126       7.327  -0.377  20.060  1.00 38.94           C  
ATOM   1011  C   LYS A 126       7.862   0.788  20.883  1.00 37.94           C  
ATOM   1012  O   LYS A 126       8.367   0.598  21.988  1.00 36.69           O  
ATOM   1013  CB  LYS A 126       6.214  -1.118  20.802  1.00 37.81           C  
ATOM   1014  CG  LYS A 126       5.563  -2.230  19.987  1.00 35.60           C  
ATOM   1015  CD  LYS A 126       4.850  -1.677  18.770  1.00 33.95           C  
ATOM   1016  CE  LYS A 126       4.120  -2.773  18.010  1.00 35.13           C  
ATOM   1017  NZ  LYS A 126       3.383  -2.245  16.815  1.00 34.79           N  
ATOM   1018  N   VAL A 127       7.777   1.985  20.315  1.00 37.66           N  
ATOM   1019  CA  VAL A 127       8.275   3.189  20.965  1.00 38.06           C  
ATOM   1020  C   VAL A 127       7.176   3.980  21.683  1.00 38.87           C  
ATOM   1021  O   VAL A 127       5.993   3.924  21.300  1.00 37.79           O  
ATOM   1022  CB  VAL A 127       8.977   4.107  19.930  1.00 38.65           C  
ATOM   1023  CG1 VAL A 127      10.166   3.388  19.329  1.00 36.71           C  
ATOM   1024  CG2 VAL A 127       8.001   4.503  18.823  1.00 38.44           C  
ATOM   1025  N   ASP A 128       7.589   4.717  22.719  1.00 38.40           N  
ATOM   1026  CA  ASP A 128       6.693   5.532  23.546  1.00 38.91           C  
ATOM   1027  C   ASP A 128       6.458   6.925  22.964  1.00 39.37           C  
ATOM   1028  O   ASP A 128       5.527   7.640  23.364  1.00 37.85           O  
ATOM   1029  CB  ASP A 128       7.284   5.689  24.944  1.00 39.02           C  
ATOM   1030  CG  ASP A 128       7.614   4.364  25.587  1.00 40.24           C  
ATOM   1031  OD1 ASP A 128       6.717   3.493  25.623  1.00 39.38           O  
ATOM   1032  OD2 ASP A 128       8.762   4.199  26.063  1.00 40.37           O  
ATOM   1033  N   LEU A 129       7.327   7.309  22.032  1.00 39.88           N  
ATOM   1034  CA  LEU A 129       7.249   8.613  21.380  1.00 39.10           C  
ATOM   1035  C   LEU A 129       8.125   8.706  20.134  1.00 39.72           C  
ATOM   1036  O   LEU A 129       9.275   8.238  20.123  1.00 39.38           O  
ATOM   1037  CB  LEU A 129       7.625   9.720  22.371  1.00 35.70           C  
ATOM   1038  CG  LEU A 129       8.371  10.938  21.832  1.00 32.30           C  
ATOM   1039  CD1 LEU A 129       7.799  12.208  22.426  1.00 30.64           C  
ATOM   1040  CD2 LEU A 129       9.849  10.790  22.147  1.00 28.72           C  
ATOM   1041  N   ILE A 130       7.559   9.307  19.086  1.00 38.97           N  
ATOM   1042  CA  ILE A 130       8.264   9.489  17.827  1.00 39.07           C  
ATOM   1043  C   ILE A 130       8.514  10.971  17.646  1.00 40.43           C  
ATOM   1044  O   ILE A 130       7.567  11.733  17.443  1.00 40.91           O  
ATOM   1045  CB  ILE A 130       7.432   9.058  16.618  1.00 38.28           C  
ATOM   1046  CG1 ILE A 130       6.735   7.729  16.883  1.00 39.95           C  
ATOM   1047  CG2 ILE A 130       8.337   8.918  15.413  1.00 38.40           C  
ATOM   1048  CD1 ILE A 130       5.791   7.311  15.765  1.00 38.70           C  
ATOM   1049  N   TYR A 131       9.780  11.382  17.728  1.00 40.87           N  
ATOM   1050  CA  TYR A 131      10.142  12.788  17.540  1.00 40.03           C  
ATOM   1051  C   TYR A 131      10.582  12.948  16.093  1.00 40.34           C  
ATOM   1052  O   TYR A 131      11.486  12.244  15.634  1.00 40.24           O  
ATOM   1053  CB  TYR A 131      11.293  13.199  18.473  1.00 38.97           C  
ATOM   1054  CG  TYR A 131      11.695  14.652  18.334  1.00 38.43           C  
ATOM   1055  CD1 TYR A 131      10.783  15.680  18.585  1.00 38.52           C  
ATOM   1056  CD2 TYR A 131      12.967  15.003  17.896  1.00 38.35           C  
ATOM   1057  CE1 TYR A 131      11.131  17.023  18.392  1.00 38.78           C  
ATOM   1058  CE2 TYR A 131      13.331  16.342  17.700  1.00 37.84           C  
ATOM   1059  CZ  TYR A 131      12.409  17.347  17.946  1.00 38.53           C  
ATOM   1060  OH  TYR A 131      12.755  18.664  17.729  1.00 37.57           O  
ATOM   1061  N   GLN A 132       9.930  13.848  15.364  1.00 40.53           N  
ATOM   1062  CA  GLN A 132      10.304  14.058  13.975  1.00 41.66           C  
ATOM   1063  C   GLN A 132      10.633  15.515  13.687  1.00 42.48           C  
ATOM   1064  O   GLN A 132       9.904  16.437  14.073  1.00 42.32           O  
ATOM   1065  CB  GLN A 132       9.204  13.585  13.023  1.00 41.81           C  
ATOM   1066  CG  GLN A 132       9.734  13.231  11.633  1.00 42.25           C  
ATOM   1067  CD  GLN A 132       8.630  13.024  10.614  1.00 44.41           C  
ATOM   1068  OE1 GLN A 132       8.009  13.983  10.149  1.00 44.69           O  
ATOM   1069  NE2 GLN A 132       8.369  11.769  10.266  1.00 45.51           N  
ATOM   1070  N   ASP A 133      11.753  15.694  12.995  1.00 42.97           N  
ATOM   1071  CA  ASP A 133      12.269  16.999  12.613  1.00 41.17           C  
ATOM   1072  C   ASP A 133      12.793  16.837  11.196  1.00 38.69           C  
ATOM   1073  O   ASP A 133      13.949  17.138  10.918  1.00 37.35           O  
ATOM   1074  CB  ASP A 133      13.421  17.383  13.543  1.00 44.73           C  
ATOM   1075  CG  ASP A 133      13.792  18.840  13.447  1.00 45.20           C  
ATOM   1076  OD1 ASP A 133      13.715  19.391  12.330  1.00 45.49           O  
ATOM   1077  OD2 ASP A 133      14.174  19.418  14.492  1.00 45.83           O  
ATOM   1078  N   ILE A 134      11.945  16.308  10.321  1.00 37.13           N  
ATOM   1079  CA  ILE A 134      12.292  16.106   8.918  1.00 36.68           C  
ATOM   1080  C   ILE A 134      11.617  17.209   8.123  1.00 36.82           C  
ATOM   1081  O   ILE A 134      10.439  17.503   8.329  1.00 37.56           O  
ATOM   1082  CB  ILE A 134      11.781  14.759   8.365  1.00 35.71           C  
ATOM   1083  CG1 ILE A 134      12.627  13.605   8.887  1.00 36.22           C  
ATOM   1084  CG2 ILE A 134      11.847  14.762   6.860  1.00 34.32           C  
ATOM   1085  CD1 ILE A 134      12.155  12.260   8.375  1.00 35.39           C  
ATOM   1086  N   ALA A 135      12.371  17.817   7.218  1.00 36.66           N  
ATOM   1087  CA  ALA A 135      11.861  18.892   6.394  1.00 36.14           C  
ATOM   1088  C   ALA A 135      11.714  18.431   4.949  1.00 36.78           C  
ATOM   1089  O   ALA A 135      12.647  18.545   4.151  1.00 35.98           O  
ATOM   1090  CB  ALA A 135      12.796  20.078   6.480  1.00 36.46           C  
ATOM   1091  N   GLN A 136      10.540  17.890   4.632  1.00 38.55           N  
ATOM   1092  CA  GLN A 136      10.218  17.413   3.283  1.00 40.61           C  
ATOM   1093  C   GLN A 136       8.719  17.526   3.023  1.00 41.00           C  
ATOM   1094  O   GLN A 136       7.920  17.548   3.954  1.00 40.75           O  
ATOM   1095  CB  GLN A 136      10.633  15.951   3.086  1.00 41.32           C  
ATOM   1096  CG  GLN A 136      12.131  15.695   3.005  1.00 40.53           C  
ATOM   1097  CD  GLN A 136      12.437  14.359   2.355  1.00 40.20           C  
ATOM   1098  OE1 GLN A 136      11.768  13.356   2.629  1.00 39.18           O  
ATOM   1099  NE2 GLN A 136      13.447  14.336   1.489  1.00 39.60           N  
ATOM   1100  N   LYS A 137       8.349  17.590   1.750  1.00 41.64           N  
ATOM   1101  CA  LYS A 137       6.950  17.701   1.363  1.00 43.24           C  
ATOM   1102  C   LYS A 137       6.025  16.685   2.049  1.00 43.13           C  
ATOM   1103  O   LYS A 137       5.036  17.066   2.668  1.00 43.91           O  
ATOM   1104  CB  LYS A 137       6.829  17.556  -0.154  1.00 45.48           C  
ATOM   1105  CG  LYS A 137       7.315  18.763  -0.955  1.00 46.51           C  
ATOM   1106  CD  LYS A 137       6.186  19.751  -1.185  1.00 46.86           C  
ATOM   1107  CE  LYS A 137       4.986  19.079  -1.861  1.00 46.69           C  
ATOM   1108  NZ  LYS A 137       3.860  20.022  -2.148  1.00 47.07           N  
ATOM   1109  N   ASN A 138       6.341  15.397   1.941  1.00 42.22           N  
ATOM   1110  CA  ASN A 138       5.510  14.345   2.538  1.00 40.72           C  
ATOM   1111  C   ASN A 138       5.741  14.126   4.036  1.00 39.40           C  
ATOM   1112  O   ASN A 138       5.564  13.020   4.544  1.00 37.34           O  
ATOM   1113  CB  ASN A 138       5.764  13.038   1.803  1.00 40.73           C  
ATOM   1114  CG  ASN A 138       7.200  12.602   1.898  1.00 40.58           C  
ATOM   1115  OD1 ASN A 138       8.110  13.347   1.542  1.00 40.93           O  
ATOM   1116  ND2 ASN A 138       7.415  11.392   2.386  1.00 41.70           N  
ATOM   1117  N   GLN A 139       6.135  15.186   4.732  1.00 38.69           N  
ATOM   1118  CA  GLN A 139       6.405  15.118   6.162  1.00 37.32           C  
ATOM   1119  C   GLN A 139       5.393  14.283   6.922  1.00 36.04           C  
ATOM   1120  O   GLN A 139       5.709  13.194   7.406  1.00 37.05           O  
ATOM   1121  CB  GLN A 139       6.433  16.527   6.763  1.00 38.24           C  
ATOM   1122  CG  GLN A 139       7.765  17.251   6.649  1.00 38.92           C  
ATOM   1123  CD  GLN A 139       7.733  18.616   7.304  1.00 40.02           C  
ATOM   1124  OE1 GLN A 139       8.767  19.267   7.480  1.00 41.19           O  
ATOM   1125  NE2 GLN A 139       6.536  19.061   7.668  1.00 40.21           N  
ATOM   1126  N   ILE A 140       4.176  14.806   7.019  1.00 33.27           N  
ATOM   1127  CA  ILE A 140       3.095  14.152   7.741  1.00 30.35           C  
ATOM   1128  C   ILE A 140       2.878  12.678   7.385  1.00 29.83           C  
ATOM   1129  O   ILE A 140       2.427  11.886   8.214  1.00 27.03           O  
ATOM   1130  CB  ILE A 140       1.800  14.938   7.547  1.00 28.85           C  
ATOM   1131  CG1 ILE A 140       2.060  16.410   7.835  1.00 27.25           C  
ATOM   1132  CG2 ILE A 140       0.745  14.444   8.501  1.00 29.92           C  
ATOM   1133  CD1 ILE A 140       2.746  16.649   9.165  1.00 26.90           C  
ATOM   1134  N   GLU A 141       3.196  12.310   6.151  1.00 30.75           N  
ATOM   1135  CA  GLU A 141       3.055  10.927   5.731  1.00 31.55           C  
ATOM   1136  C   GLU A 141       4.088  10.087   6.477  1.00 30.46           C  
ATOM   1137  O   GLU A 141       3.749   9.114   7.140  1.00 30.01           O  
ATOM   1138  CB  GLU A 141       3.293  10.802   4.229  1.00 34.08           C  
ATOM   1139  CG  GLU A 141       2.228  11.449   3.359  1.00 38.87           C  
ATOM   1140  CD  GLU A 141       1.268  10.431   2.748  1.00 41.73           C  
ATOM   1141  OE1 GLU A 141       0.533   9.760   3.518  1.00 42.28           O  
ATOM   1142  OE2 GLU A 141       1.252  10.304   1.497  1.00 42.07           O  
ATOM   1143  N   ILE A 142       5.352  10.476   6.365  1.00 30.07           N  
ATOM   1144  CA  ILE A 142       6.431   9.752   7.026  1.00 29.11           C  
ATOM   1145  C   ILE A 142       6.156   9.686   8.513  1.00 28.80           C  
ATOM   1146  O   ILE A 142       6.401   8.664   9.157  1.00 29.74           O  
ATOM   1147  CB  ILE A 142       7.810  10.429   6.805  1.00 28.21           C  
ATOM   1148  CG1 ILE A 142       8.074  10.593   5.310  1.00 28.26           C  
ATOM   1149  CG2 ILE A 142       8.918   9.575   7.395  1.00 25.49           C  
ATOM   1150  CD1 ILE A 142       9.376  11.281   5.002  1.00 28.03           C  
ATOM   1151  N   LEU A 143       5.643  10.770   9.071  1.00 27.23           N  
ATOM   1152  CA  LEU A 143       5.356  10.746  10.486  1.00 28.00           C  
ATOM   1153  C   LEU A 143       4.211   9.772  10.782  1.00 29.28           C  
ATOM   1154  O   LEU A 143       4.207   9.100  11.819  1.00 30.00           O  
ATOM   1155  CB  LEU A 143       5.024  12.150  10.987  1.00 26.49           C  
ATOM   1156  CG  LEU A 143       4.641  12.282  12.465  1.00 26.31           C  
ATOM   1157  CD1 LEU A 143       3.137  12.125  12.606  1.00 26.55           C  
ATOM   1158  CD2 LEU A 143       5.399  11.265  13.324  1.00 24.18           C  
ATOM   1159  N   LYS A 144       3.251   9.676   9.865  1.00 30.22           N  
ATOM   1160  CA  LYS A 144       2.113   8.775  10.055  1.00 29.66           C  
ATOM   1161  C   LYS A 144       2.506   7.315   9.971  1.00 28.30           C  
ATOM   1162  O   LYS A 144       2.285   6.561  10.910  1.00 27.42           O  
ATOM   1163  CB  LYS A 144       1.008   9.068   9.037  1.00 30.24           C  
ATOM   1164  CG  LYS A 144       0.253  10.338   9.343  1.00 31.30           C  
ATOM   1165  CD  LYS A 144      -1.005  10.450   8.519  1.00 34.17           C  
ATOM   1166  CE  LYS A 144      -1.824  11.650   8.973  1.00 36.44           C  
ATOM   1167  NZ  LYS A 144      -3.062  11.843   8.169  1.00 38.38           N  
ATOM   1168  N   ALA A 145       3.083   6.924   8.838  1.00 28.91           N  
ATOM   1169  CA  ALA A 145       3.508   5.546   8.626  1.00 28.53           C  
ATOM   1170  C   ALA A 145       4.470   5.114   9.714  1.00 28.62           C  
ATOM   1171  O   ALA A 145       4.418   3.977  10.163  1.00 28.86           O  
ATOM   1172  CB  ALA A 145       4.158   5.391   7.261  1.00 26.55           C  
ATOM   1173  N   ASN A 146       5.343   6.013  10.152  1.00 29.51           N  
ATOM   1174  CA  ASN A 146       6.282   5.649  11.203  1.00 31.84           C  
ATOM   1175  C   ASN A 146       5.537   5.365  12.507  1.00 33.28           C  
ATOM   1176  O   ASN A 146       5.980   4.560  13.327  1.00 32.74           O  
ATOM   1177  CB  ASN A 146       7.327   6.752  11.404  1.00 31.63           C  
ATOM   1178  CG  ASN A 146       8.755   6.256  11.160  1.00 31.85           C  
ATOM   1179  OD1 ASN A 146       9.526   6.023  12.098  1.00 28.84           O  
ATOM   1180  ND2 ASN A 146       9.101   6.077   9.891  1.00 31.79           N  
ATOM   1181  N   ALA A 147       4.391   6.015  12.684  1.00 36.08           N  
ATOM   1182  CA  ALA A 147       3.571   5.821  13.880  1.00 38.01           C  
ATOM   1183  C   ALA A 147       2.894   4.445  13.854  1.00 38.25           C  
ATOM   1184  O   ALA A 147       2.906   3.711  14.845  1.00 36.92           O  
ATOM   1185  CB  ALA A 147       2.512   6.931  13.974  1.00 39.23           C  
ATOM   1186  N   GLU A 148       2.302   4.111  12.711  1.00 39.42           N  
ATOM   1187  CA  GLU A 148       1.627   2.836  12.544  1.00 41.45           C  
ATOM   1188  C   GLU A 148       2.561   1.740  13.025  1.00 40.77           C  
ATOM   1189  O   GLU A 148       2.273   1.021  13.985  1.00 41.69           O  
ATOM   1190  CB  GLU A 148       1.308   2.597  11.072  1.00 44.30           C  
ATOM   1191  CG  GLU A 148       0.180   1.601  10.831  1.00 49.74           C  
ATOM   1192  CD  GLU A 148      -1.183   2.281  10.684  1.00 53.36           C  
ATOM   1193  OE1 GLU A 148      -2.208   1.562  10.581  1.00 53.49           O  
ATOM   1194  OE2 GLU A 148      -1.223   3.537  10.662  1.00 55.26           O  
ATOM   1195  N   PHE A 149       3.696   1.634  12.351  1.00 39.71           N  
ATOM   1196  CA  PHE A 149       4.694   0.628  12.675  1.00 38.51           C  
ATOM   1197  C   PHE A 149       5.156   0.521  14.119  1.00 38.00           C  
ATOM   1198  O   PHE A 149       5.163  -0.575  14.671  1.00 37.59           O  
ATOM   1199  CB  PHE A 149       5.934   0.798  11.791  1.00 36.63           C  
ATOM   1200  CG  PHE A 149       5.834   0.091  10.477  1.00 36.09           C  
ATOM   1201  CD1 PHE A 149       4.933   0.522   9.503  1.00 35.99           C  
ATOM   1202  CD2 PHE A 149       6.626  -1.021  10.212  1.00 35.07           C  
ATOM   1203  CE1 PHE A 149       4.820  -0.142   8.278  1.00 33.95           C  
ATOM   1204  CE2 PHE A 149       6.522  -1.695   8.994  1.00 34.84           C  
ATOM   1205  CZ  PHE A 149       5.615  -1.253   8.024  1.00 34.67           C  
ATOM   1206  N   PHE A 150       5.519   1.637  14.746  1.00 37.28           N  
ATOM   1207  CA  PHE A 150       6.061   1.548  16.097  1.00 37.73           C  
ATOM   1208  C   PHE A 150       5.407   2.306  17.261  1.00 38.38           C  
ATOM   1209  O   PHE A 150       5.564   1.920  18.422  1.00 37.13           O  
ATOM   1210  CB  PHE A 150       7.551   1.901  16.017  1.00 35.75           C  
ATOM   1211  CG  PHE A 150       8.225   1.387  14.769  1.00 32.60           C  
ATOM   1212  CD1 PHE A 150       8.359   0.028  14.543  1.00 32.40           C  
ATOM   1213  CD2 PHE A 150       8.680   2.262  13.798  1.00 32.06           C  
ATOM   1214  CE1 PHE A 150       8.931  -0.445  13.369  1.00 32.32           C  
ATOM   1215  CE2 PHE A 150       9.255   1.795  12.617  1.00 30.82           C  
ATOM   1216  CZ  PHE A 150       9.378   0.444  12.404  1.00 30.85           C  
ATOM   1217  N   LEU A 151       4.682   3.377  16.974  1.00 39.82           N  
ATOM   1218  CA  LEU A 151       4.068   4.130  18.059  1.00 41.81           C  
ATOM   1219  C   LEU A 151       3.019   3.316  18.807  1.00 43.73           C  
ATOM   1220  O   LEU A 151       1.871   3.186  18.363  1.00 43.38           O  
ATOM   1221  CB  LEU A 151       3.434   5.424  17.545  1.00 41.03           C  
ATOM   1222  CG  LEU A 151       2.662   6.184  18.629  1.00 38.62           C  
ATOM   1223  CD1 LEU A 151       3.609   6.609  19.736  1.00 37.88           C  
ATOM   1224  CD2 LEU A 151       1.979   7.380  18.020  1.00 38.75           C  
ATOM   1225  N   LYS A 152       3.421   2.788  19.959  1.00 44.92           N  
ATOM   1226  CA  LYS A 152       2.534   1.988  20.793  1.00 45.56           C  
ATOM   1227  C   LYS A 152       1.264   2.756  21.200  1.00 47.67           C  
ATOM   1228  O   LYS A 152       1.334   3.911  21.616  1.00 48.14           O  
ATOM   1229  CB  LYS A 152       3.297   1.526  22.033  1.00 42.58           C  
ATOM   1230  CG  LYS A 152       3.745   2.659  22.916  1.00 39.36           C  
ATOM   1231  CD  LYS A 152       5.011   2.321  23.663  1.00 36.77           C  
ATOM   1232  CE  LYS A 152       4.891   1.037  24.445  1.00 34.40           C  
ATOM   1233  NZ  LYS A 152       6.100   0.795  25.282  1.00 33.45           N  
ATOM   1234  N   GLU A 153       0.109   2.101  21.070  1.00 50.99           N  
ATOM   1235  CA  GLU A 153      -1.190   2.694  21.416  1.00 52.74           C  
ATOM   1236  C   GLU A 153      -1.103   3.568  22.652  1.00 52.54           C  
ATOM   1237  O   GLU A 153      -0.648   3.130  23.709  1.00 52.41           O  
ATOM   1238  CB  GLU A 153      -2.253   1.605  21.649  1.00 54.19           C  
ATOM   1239  CG  GLU A 153      -3.209   1.384  20.468  1.00 55.79           C  
ATOM   1240  CD  GLU A 153      -4.681   1.278  20.888  1.00 56.25           C  
ATOM   1241  OE1 GLU A 153      -5.547   1.137  19.996  1.00 55.74           O  
ATOM   1242  OE2 GLU A 153      -4.978   1.339  22.103  1.00 55.96           O  
ATOM   1243  N   LYS A 154      -1.560   4.803  22.506  1.00 52.73           N  
ATOM   1244  CA  LYS A 154      -1.537   5.775  23.589  1.00 54.11           C  
ATOM   1245  C   LYS A 154      -0.111   6.298  23.750  1.00 53.73           C  
ATOM   1246  O   LYS A 154       0.332   6.635  24.850  1.00 54.51           O  
ATOM   1247  CB  LYS A 154      -2.038   5.151  24.902  1.00 55.10           C  
ATOM   1248  CG  LYS A 154      -2.681   6.157  25.856  1.00 57.23           C  
ATOM   1249  CD  LYS A 154      -3.883   6.849  25.200  1.00 60.17           C  
ATOM   1250  CE  LYS A 154      -4.428   8.014  26.038  1.00 62.32           C  
ATOM   1251  NZ  LYS A 154      -5.184   7.579  27.249  1.00 62.71           N  
ATOM   1252  N   GLY A 155       0.605   6.345  22.631  1.00 52.74           N  
ATOM   1253  CA  GLY A 155       1.961   6.854  22.630  1.00 51.39           C  
ATOM   1254  C   GLY A 155       1.870   8.285  22.142  1.00 50.98           C  
ATOM   1255  O   GLY A 155       0.846   8.685  21.584  1.00 50.35           O  
ATOM   1256  N   GLU A 156       2.927   9.064  22.335  1.00 50.32           N  
ATOM   1257  CA  GLU A 156       2.898  10.456  21.916  1.00 50.42           C  
ATOM   1258  C   GLU A 156       3.995  10.843  20.922  1.00 49.40           C  
ATOM   1259  O   GLU A 156       5.068  10.235  20.889  1.00 48.28           O  
ATOM   1260  CB  GLU A 156       2.961  11.356  23.158  1.00 52.60           C  
ATOM   1261  CG  GLU A 156       4.027  10.940  24.173  1.00 55.69           C  
ATOM   1262  CD  GLU A 156       4.037  11.810  25.428  1.00 56.92           C  
ATOM   1263  OE1 GLU A 156       3.057  11.766  26.209  1.00 56.45           O  
ATOM   1264  OE2 GLU A 156       5.035  12.536  25.630  1.00 57.50           O  
ATOM   1265  N   VAL A 157       3.710  11.857  20.106  1.00 47.73           N  
ATOM   1266  CA  VAL A 157       4.668  12.335  19.116  1.00 46.17           C  
ATOM   1267  C   VAL A 157       4.806  13.849  19.099  1.00 44.32           C  
ATOM   1268  O   VAL A 157       3.880  14.581  19.438  1.00 44.01           O  
ATOM   1269  CB  VAL A 157       4.305  11.889  17.661  1.00 46.39           C  
ATOM   1270  CG1 VAL A 157       4.424  10.387  17.529  1.00 46.79           C  
ATOM   1271  CG2 VAL A 157       2.907  12.361  17.289  1.00 44.44           C  
ATOM   1272  N   VAL A 158       5.991  14.296  18.701  1.00 42.84           N  
ATOM   1273  CA  VAL A 158       6.315  15.710  18.575  1.00 40.45           C  
ATOM   1274  C   VAL A 158       6.906  15.800  17.177  1.00 38.70           C  
ATOM   1275  O   VAL A 158       7.821  15.051  16.823  1.00 37.81           O  
ATOM   1276  CB  VAL A 158       7.384  16.162  19.596  1.00 39.78           C  
ATOM   1277  CG1 VAL A 158       7.476  17.671  19.605  1.00 38.21           C  
ATOM   1278  CG2 VAL A 158       7.050  15.631  20.977  1.00 40.00           C  
ATOM   1279  N   ILE A 159       6.376  16.701  16.372  1.00 36.64           N  
ATOM   1280  CA  ILE A 159       6.867  16.822  15.022  1.00 36.51           C  
ATOM   1281  C   ILE A 159       7.092  18.282  14.679  1.00 37.39           C  
ATOM   1282  O   ILE A 159       6.202  19.116  14.861  1.00 38.01           O  
ATOM   1283  CB  ILE A 159       5.860  16.198  14.031  1.00 35.48           C  
ATOM   1284  CG1 ILE A 159       6.434  16.205  12.612  1.00 35.11           C  
ATOM   1285  CG2 ILE A 159       4.539  16.950  14.099  1.00 35.05           C  
ATOM   1286  CD1 ILE A 159       5.474  15.670  11.552  1.00 34.42           C  
ATOM   1287  N   MET A 160       8.293  18.594  14.200  1.00 36.97           N  
ATOM   1288  CA  MET A 160       8.608  19.960  13.817  1.00 36.99           C  
ATOM   1289  C   MET A 160       8.237  20.123  12.334  1.00 37.38           C  
ATOM   1290  O   MET A 160       8.399  19.197  11.534  1.00 38.59           O  
ATOM   1291  CB  MET A 160      10.093  20.248  14.052  1.00 37.26           C  
ATOM   1292  CG  MET A 160      10.586  20.005  15.490  1.00 38.56           C  
ATOM   1293  SD  MET A 160       9.570  20.706  16.836  1.00 38.63           S  
ATOM   1294  CE  MET A 160       9.456  22.401  16.334  1.00 39.15           C  
ATOM   1295  N   VAL A 161       7.730  21.292  11.968  1.00 36.78           N  
ATOM   1296  CA  VAL A 161       7.315  21.527  10.590  1.00 36.82           C  
ATOM   1297  C   VAL A 161       7.775  22.867  10.017  1.00 38.10           C  
ATOM   1298  O   VAL A 161       7.658  23.915  10.655  1.00 39.12           O  
ATOM   1299  CB  VAL A 161       5.766  21.429  10.477  1.00 34.89           C  
ATOM   1300  CG1 VAL A 161       5.291  21.827   9.092  1.00 32.23           C  
ATOM   1301  CG2 VAL A 161       5.329  20.023  10.798  1.00 33.85           C  
ATOM   1302  N   LYS A 162       8.306  22.824   8.803  1.00 37.96           N  
ATOM   1303  CA  LYS A 162       8.746  24.026   8.124  1.00 38.41           C  
ATOM   1304  C   LYS A 162       7.725  24.251   7.027  1.00 40.37           C  
ATOM   1305  O   LYS A 162       7.752  23.553   6.016  1.00 41.77           O  
ATOM   1306  CB  LYS A 162      10.129  23.812   7.513  1.00 37.58           C  
ATOM   1307  CG  LYS A 162      10.618  24.956   6.650  1.00 35.08           C  
ATOM   1308  CD  LYS A 162      12.089  24.797   6.342  1.00 35.52           C  
ATOM   1309  CE  LYS A 162      12.568  25.883   5.401  1.00 36.45           C  
ATOM   1310  NZ  LYS A 162      12.339  27.255   5.927  1.00 35.70           N  
ATOM   1311  N   ALA A 163       6.817  25.202   7.235  1.00 41.06           N  
ATOM   1312  CA  ALA A 163       5.782  25.503   6.248  1.00 42.03           C  
ATOM   1313  C   ALA A 163       6.259  25.329   4.804  1.00 42.89           C  
ATOM   1314  O   ALA A 163       5.718  24.499   4.076  1.00 42.38           O  
ATOM   1315  CB  ALA A 163       5.260  26.918   6.456  1.00 42.81           C  
ATOM   1316  N   ARG A 164       7.270  26.100   4.400  1.00 43.90           N  
ATOM   1317  CA  ARG A 164       7.812  26.031   3.041  1.00 45.97           C  
ATOM   1318  C   ARG A 164       8.178  24.618   2.576  1.00 46.38           C  
ATOM   1319  O   ARG A 164       8.091  24.304   1.390  1.00 46.17           O  
ATOM   1320  CB  ARG A 164       9.059  26.907   2.915  1.00 47.99           C  
ATOM   1321  CG  ARG A 164       8.949  28.261   3.553  1.00 51.84           C  
ATOM   1322  CD  ARG A 164       9.978  29.210   2.958  1.00 55.51           C  
ATOM   1323  NE  ARG A 164       9.488  29.823   1.725  1.00 58.84           N  
ATOM   1324  CZ  ARG A 164       8.448  30.658   1.665  1.00 61.13           C  
ATOM   1325  NH1 ARG A 164       7.785  30.986   2.771  1.00 61.95           N  
ATOM   1326  NH2 ARG A 164       8.066  31.166   0.497  1.00 62.32           N  
ATOM   1327  N   SER A 165       8.611  23.780   3.509  1.00 47.45           N  
ATOM   1328  CA  SER A 165       8.997  22.398   3.220  1.00 48.86           C  
ATOM   1329  C   SER A 165       7.876  21.643   2.504  1.00 49.44           C  
ATOM   1330  O   SER A 165       8.104  20.766   1.669  1.00 47.16           O  
ATOM   1331  CB  SER A 165       9.339  21.701   4.543  1.00 48.96           C  
ATOM   1332  OG  SER A 165       9.524  20.312   4.377  1.00 50.49           O  
ATOM   1333  N   ILE A 166       6.656  22.021   2.850  1.00 52.61           N  
ATOM   1334  CA  ILE A 166       5.441  21.430   2.317  1.00 55.53           C  
ATOM   1335  C   ILE A 166       4.875  22.225   1.135  1.00 58.91           C  
ATOM   1336  O   ILE A 166       4.641  21.669   0.065  1.00 59.26           O  
ATOM   1337  CB  ILE A 166       4.396  21.347   3.442  1.00 53.81           C  
ATOM   1338  CG1 ILE A 166       4.959  20.490   4.576  1.00 52.03           C  
ATOM   1339  CG2 ILE A 166       3.091  20.791   2.916  1.00 53.52           C  
ATOM   1340  CD1 ILE A 166       4.235  20.642   5.881  1.00 51.08           C  
ATOM   1341  N   ASP A 167       4.653  23.524   1.328  1.00 62.81           N  
ATOM   1342  CA  ASP A 167       4.115  24.362   0.259  1.00 67.25           C  
ATOM   1343  C   ASP A 167       5.054  25.522  -0.086  1.00 69.01           C  
ATOM   1344  O   ASP A 167       5.162  26.500   0.662  1.00 68.82           O  
ATOM   1345  CB  ASP A 167       2.734  24.910   0.651  1.00 69.73           C  
ATOM   1346  CG  ASP A 167       1.876  25.271  -0.565  1.00 71.98           C  
ATOM   1347  OD1 ASP A 167       2.279  26.161  -1.350  1.00 72.64           O  
ATOM   1348  OD2 ASP A 167       0.796  24.656  -0.731  1.00 71.90           O  
ATOM   1349  N   SER A 168       5.722  25.398  -1.231  1.00 70.98           N  
ATOM   1350  CA  SER A 168       6.663  26.405  -1.715  1.00 72.33           C  
ATOM   1351  C   SER A 168       6.127  27.831  -1.583  1.00 73.07           C  
ATOM   1352  O   SER A 168       6.724  28.670  -0.904  1.00 72.69           O  
ATOM   1353  CB  SER A 168       7.004  26.129  -3.184  1.00 72.38           C  
ATOM   1354  OG  SER A 168       7.391  24.779  -3.374  1.00 72.14           O  
ATOM   1355  N   THR A 169       4.998  28.096  -2.236  1.00 74.20           N  
ATOM   1356  CA  THR A 169       4.382  29.420  -2.213  1.00 75.06           C  
ATOM   1357  C   THR A 169       2.938  29.409  -1.696  1.00 75.33           C  
ATOM   1358  O   THR A 169       1.987  29.239  -2.462  1.00 75.75           O  
ATOM   1359  CB  THR A 169       4.414  30.055  -3.624  1.00 75.67           C  
ATOM   1360  OG1 THR A 169       3.897  29.120  -4.582  1.00 75.15           O  
ATOM   1361  CG2 THR A 169       5.846  30.434  -4.010  1.00 75.82           C  
ATOM   1362  N   ALA A 170       2.794  29.590  -0.386  1.00 74.95           N  
ATOM   1363  CA  ALA A 170       1.494  29.614   0.273  1.00 74.08           C  
ATOM   1364  C   ALA A 170       1.751  30.102   1.682  1.00 74.22           C  
ATOM   1365  O   ALA A 170       2.655  29.610   2.358  1.00 73.59           O  
ATOM   1366  CB  ALA A 170       0.881  28.233   0.303  1.00 73.29           C  
ATOM   1367  N   GLU A 171       0.955  31.074   2.111  1.00 75.49           N  
ATOM   1368  CA  GLU A 171       1.097  31.678   3.431  1.00 76.93           C  
ATOM   1369  C   GLU A 171       1.255  30.659   4.550  1.00 77.57           C  
ATOM   1370  O   GLU A 171       0.382  29.813   4.752  1.00 78.13           O  
ATOM   1371  CB  GLU A 171      -0.098  32.593   3.708  1.00 77.43           C  
ATOM   1372  CG  GLU A 171      -0.015  33.364   5.012  1.00 79.18           C  
ATOM   1373  CD  GLU A 171      -0.898  34.600   5.013  1.00 80.43           C  
ATOM   1374  OE1 GLU A 171      -0.993  35.266   6.068  1.00 80.83           O  
ATOM   1375  OE2 GLU A 171      -1.490  34.911   3.954  1.00 81.41           O  
ATOM   1376  N   PRO A 172       2.381  30.732   5.291  1.00 77.95           N  
ATOM   1377  CA  PRO A 172       2.739  29.856   6.413  1.00 78.03           C  
ATOM   1378  C   PRO A 172       1.551  29.491   7.300  1.00 78.44           C  
ATOM   1379  O   PRO A 172       1.496  28.402   7.880  1.00 77.73           O  
ATOM   1380  CB  PRO A 172       3.791  30.676   7.148  1.00 77.66           C  
ATOM   1381  CG  PRO A 172       4.526  31.306   6.017  1.00 76.91           C  
ATOM   1382  CD  PRO A 172       3.406  31.781   5.116  1.00 77.42           C  
ATOM   1383  N   GLU A 173       0.605  30.419   7.396  1.00 79.21           N  
ATOM   1384  CA  GLU A 173      -0.600  30.226   8.190  1.00 80.13           C  
ATOM   1385  C   GLU A 173      -1.497  29.169   7.550  1.00 80.06           C  
ATOM   1386  O   GLU A 173      -1.919  28.221   8.202  1.00 80.62           O  
ATOM   1387  CB  GLU A 173      -1.365  31.553   8.315  1.00 80.18           C  
ATOM   1388  CG  GLU A 173      -1.039  32.372   9.573  1.00 79.20           C  
ATOM   1389  CD  GLU A 173       0.449  32.595   9.782  1.00 78.19           C  
ATOM   1390  OE1 GLU A 173       1.089  33.217   8.907  1.00 77.92           O  
ATOM   1391  OE2 GLU A 173       0.974  32.143  10.824  1.00 76.21           O  
ATOM   1392  N   GLU A 174      -1.776  29.337   6.264  1.00 80.29           N  
ATOM   1393  CA  GLU A 174      -2.628  28.410   5.537  1.00 79.98           C  
ATOM   1394  C   GLU A 174      -1.996  27.036   5.403  1.00 78.68           C  
ATOM   1395  O   GLU A 174      -2.700  26.027   5.369  1.00 77.80           O  
ATOM   1396  CB  GLU A 174      -2.948  28.996   4.170  1.00 81.80           C  
ATOM   1397  CG  GLU A 174      -3.655  30.337   4.290  1.00 86.11           C  
ATOM   1398  CD  GLU A 174      -3.667  31.125   2.999  1.00 88.45           C  
ATOM   1399  OE1 GLU A 174      -2.572  31.458   2.490  1.00 90.08           O  
ATOM   1400  OE2 GLU A 174      -4.774  31.415   2.496  1.00 89.94           O  
ATOM   1401  N   VAL A 175      -0.669  26.999   5.333  1.00 77.65           N  
ATOM   1402  CA  VAL A 175       0.049  25.733   5.228  1.00 76.66           C  
ATOM   1403  C   VAL A 175      -0.047  25.027   6.569  1.00 75.73           C  
ATOM   1404  O   VAL A 175      -0.315  23.830   6.638  1.00 76.37           O  
ATOM   1405  CB  VAL A 175       1.532  25.941   4.888  1.00 76.78           C  
ATOM   1406  CG1 VAL A 175       2.241  24.595   4.848  1.00 77.25           C  
ATOM   1407  CG2 VAL A 175       1.666  26.650   3.553  1.00 77.20           C  
ATOM   1408  N   PHE A 176       0.179  25.773   7.641  1.00 74.35           N  
ATOM   1409  CA  PHE A 176       0.079  25.201   8.968  1.00 74.03           C  
ATOM   1410  C   PHE A 176      -1.392  24.887   9.252  1.00 73.81           C  
ATOM   1411  O   PHE A 176      -1.710  24.002  10.045  1.00 74.00           O  
ATOM   1412  CB  PHE A 176       0.623  26.186  10.005  1.00 74.80           C  
ATOM   1413  CG  PHE A 176       2.122  26.313  10.003  1.00 75.14           C  
ATOM   1414  CD1 PHE A 176       2.749  27.259  10.805  1.00 74.89           C  
ATOM   1415  CD2 PHE A 176       2.910  25.475   9.218  1.00 75.56           C  
ATOM   1416  CE1 PHE A 176       4.132  27.372  10.827  1.00 74.45           C  
ATOM   1417  CE2 PHE A 176       4.296  25.578   9.233  1.00 75.14           C  
ATOM   1418  CZ  PHE A 176       4.908  26.528  10.038  1.00 75.06           C  
ATOM   1419  N   LYS A 177      -2.287  25.616   8.593  1.00 73.27           N  
ATOM   1420  CA  LYS A 177      -3.722  25.410   8.767  1.00 72.11           C  
ATOM   1421  C   LYS A 177      -4.090  24.030   8.238  1.00 70.49           C  
ATOM   1422  O   LYS A 177      -4.775  23.256   8.908  1.00 69.86           O  
ATOM   1423  CB  LYS A 177      -4.509  26.477   7.997  1.00 74.28           C  
ATOM   1424  CG  LYS A 177      -6.031  26.313   8.062  1.00 77.39           C  
ATOM   1425  CD  LYS A 177      -6.782  27.402   7.269  1.00 78.58           C  
ATOM   1426  CE  LYS A 177      -6.753  27.172   5.751  1.00 79.03           C  
ATOM   1427  NZ  LYS A 177      -7.641  26.052   5.301  1.00 78.21           N  
ATOM   1428  N   SER A 178      -3.616  23.739   7.028  1.00 68.13           N  
ATOM   1429  CA  SER A 178      -3.875  22.467   6.363  1.00 65.48           C  
ATOM   1430  C   SER A 178      -3.245  21.296   7.104  1.00 63.83           C  
ATOM   1431  O   SER A 178      -3.946  20.401   7.580  1.00 63.79           O  
ATOM   1432  CB  SER A 178      -3.336  22.510   4.929  1.00 64.85           C  
ATOM   1433  OG  SER A 178      -3.613  21.303   4.240  1.00 64.11           O  
ATOM   1434  N   VAL A 179      -1.919  21.312   7.195  1.00 61.20           N  
ATOM   1435  CA  VAL A 179      -1.169  20.250   7.853  1.00 58.82           C  
ATOM   1436  C   VAL A 179      -1.766  19.793   9.167  1.00 58.45           C  
ATOM   1437  O   VAL A 179      -1.880  18.597   9.423  1.00 58.68           O  
ATOM   1438  CB  VAL A 179       0.257  20.673   8.133  1.00 57.49           C  
ATOM   1439  CG1 VAL A 179       0.999  19.536   8.803  1.00 56.53           C  
ATOM   1440  CG2 VAL A 179       0.929  21.084   6.844  1.00 57.73           C  
ATOM   1441  N   LEU A 180      -2.130  20.745  10.012  1.00 57.83           N  
ATOM   1442  CA  LEU A 180      -2.710  20.400  11.295  1.00 58.38           C  
ATOM   1443  C   LEU A 180      -3.980  19.575  11.071  1.00 60.12           C  
ATOM   1444  O   LEU A 180      -4.230  18.591  11.773  1.00 60.21           O  
ATOM   1445  CB  LEU A 180      -3.033  21.671  12.083  1.00 55.82           C  
ATOM   1446  CG  LEU A 180      -3.000  21.529  13.604  1.00 53.56           C  
ATOM   1447  CD1 LEU A 180      -3.991  20.465  14.044  1.00 53.11           C  
ATOM   1448  CD2 LEU A 180      -1.593  21.159  14.047  1.00 52.45           C  
ATOM   1449  N   LYS A 181      -4.777  19.975  10.084  1.00 62.17           N  
ATOM   1450  CA  LYS A 181      -6.015  19.272   9.766  1.00 63.97           C  
ATOM   1451  C   LYS A 181      -5.707  17.879   9.226  1.00 64.91           C  
ATOM   1452  O   LYS A 181      -6.334  16.894   9.626  1.00 65.09           O  
ATOM   1453  CB  LYS A 181      -6.826  20.064   8.732  1.00 64.90           C  
ATOM   1454  CG  LYS A 181      -7.165  21.487   9.176  1.00 67.26           C  
ATOM   1455  CD  LYS A 181      -8.017  22.248   8.155  1.00 67.52           C  
ATOM   1456  CE  LYS A 181      -8.298  23.675   8.633  1.00 66.89           C  
ATOM   1457  NZ  LYS A 181      -9.181  24.443   7.711  1.00 66.14           N  
ATOM   1458  N   GLU A 182      -4.730  17.805   8.326  1.00 65.52           N  
ATOM   1459  CA  GLU A 182      -4.326  16.542   7.717  1.00 66.11           C  
ATOM   1460  C   GLU A 182      -3.796  15.543   8.749  1.00 66.13           C  
ATOM   1461  O   GLU A 182      -4.001  14.335   8.622  1.00 65.71           O  
ATOM   1462  CB  GLU A 182      -3.253  16.794   6.649  1.00 66.31           C  
ATOM   1463  CG  GLU A 182      -3.016  15.615   5.701  1.00 67.53           C  
ATOM   1464  CD  GLU A 182      -1.794  14.780   6.055  1.00 67.60           C  
ATOM   1465  OE1 GLU A 182      -0.661  15.302   5.972  1.00 67.75           O  
ATOM   1466  OE2 GLU A 182      -1.964  13.594   6.411  1.00 67.51           O  
ATOM   1467  N   MET A 183      -3.125  16.052   9.777  1.00 66.14           N  
ATOM   1468  CA  MET A 183      -2.563  15.189  10.803  1.00 66.08           C  
ATOM   1469  C   MET A 183      -3.553  14.832  11.901  1.00 66.76           C  
ATOM   1470  O   MET A 183      -3.345  13.880  12.655  1.00 66.99           O  
ATOM   1471  CB  MET A 183      -1.334  15.842  11.427  1.00 64.39           C  
ATOM   1472  CG  MET A 183      -0.598  14.912  12.352  1.00 62.85           C  
ATOM   1473  SD  MET A 183       0.888  15.630  12.974  1.00 61.50           S  
ATOM   1474  CE  MET A 183       0.372  16.125  14.591  1.00 61.14           C  
ATOM   1475  N   GLU A 184      -4.631  15.598  11.993  1.00 67.67           N  
ATOM   1476  CA  GLU A 184      -5.641  15.342  13.006  1.00 68.49           C  
ATOM   1477  C   GLU A 184      -6.279  13.962  12.827  1.00 67.32           C  
ATOM   1478  O   GLU A 184      -6.535  13.256  13.802  1.00 67.12           O  
ATOM   1479  CB  GLU A 184      -6.724  16.421  12.950  1.00 71.18           C  
ATOM   1480  CG  GLU A 184      -7.763  16.281  14.045  1.00 74.84           C  
ATOM   1481  CD  GLU A 184      -7.132  16.245  15.428  1.00 76.71           C  
ATOM   1482  OE1 GLU A 184      -6.616  17.291  15.881  1.00 77.80           O  
ATOM   1483  OE2 GLU A 184      -7.143  15.162  16.054  1.00 77.54           O  
ATOM   1484  N   GLY A 185      -6.518  13.583  11.575  1.00 65.43           N  
ATOM   1485  CA  GLY A 185      -7.136  12.303  11.283  1.00 63.31           C  
ATOM   1486  C   GLY A 185      -6.526  11.059  11.909  1.00 62.60           C  
ATOM   1487  O   GLY A 185      -7.104   9.980  11.812  1.00 62.98           O  
ATOM   1488  N   ASP A 186      -5.375  11.182  12.558  1.00 62.00           N  
ATOM   1489  CA  ASP A 186      -4.736  10.011  13.159  1.00 60.82           C  
ATOM   1490  C   ASP A 186      -4.305  10.258  14.593  1.00 59.62           C  
ATOM   1491  O   ASP A 186      -4.244   9.338  15.404  1.00 58.32           O  
ATOM   1492  CB  ASP A 186      -3.504   9.608  12.345  1.00 62.31           C  
ATOM   1493  CG  ASP A 186      -3.841   9.190  10.918  1.00 63.91           C  
ATOM   1494  OD1 ASP A 186      -4.750   9.792  10.298  1.00 64.06           O  
ATOM   1495  OD2 ASP A 186      -3.173   8.264  10.408  1.00 64.48           O  
ATOM   1496  N   PHE A 187      -4.004  11.509  14.904  1.00 59.74           N  
ATOM   1497  CA  PHE A 187      -3.547  11.862  16.235  1.00 60.52           C  
ATOM   1498  C   PHE A 187      -4.507  12.790  16.948  1.00 60.86           C  
ATOM   1499  O   PHE A 187      -5.428  13.340  16.344  1.00 60.40           O  
ATOM   1500  CB  PHE A 187      -2.180  12.537  16.135  1.00 60.81           C  
ATOM   1501  CG  PHE A 187      -1.161  11.719  15.403  1.00 61.65           C  
ATOM   1502  CD1 PHE A 187      -0.395  10.770  16.076  1.00 62.53           C  
ATOM   1503  CD2 PHE A 187      -1.009  11.848  14.031  1.00 61.83           C  
ATOM   1504  CE1 PHE A 187       0.510   9.957  15.389  1.00 62.24           C  
ATOM   1505  CE2 PHE A 187      -0.109  11.041  13.331  1.00 62.26           C  
ATOM   1506  CZ  PHE A 187       0.651  10.092  14.012  1.00 62.49           C  
ATOM   1507  N   LYS A 188      -4.292  12.945  18.247  1.00 61.00           N  
ATOM   1508  CA  LYS A 188      -5.102  13.843  19.043  1.00 61.48           C  
ATOM   1509  C   LYS A 188      -4.176  14.980  19.419  1.00 61.78           C  
ATOM   1510  O   LYS A 188      -3.170  14.752  20.091  1.00 62.77           O  
ATOM   1511  CB  LYS A 188      -5.596  13.172  20.315  1.00 62.29           C  
ATOM   1512  CG  LYS A 188      -6.321  14.151  21.219  1.00 64.06           C  
ATOM   1513  CD  LYS A 188      -6.781  13.509  22.497  1.00 64.88           C  
ATOM   1514  CE  LYS A 188      -7.276  14.559  23.458  1.00 65.85           C  
ATOM   1515  NZ  LYS A 188      -7.608  13.946  24.766  1.00 66.86           N  
ATOM   1516  N   ILE A 189      -4.510  16.193  18.980  1.00 60.61           N  
ATOM   1517  CA  ILE A 189      -3.705  17.385  19.257  1.00 59.03           C  
ATOM   1518  C   ILE A 189      -3.513  17.686  20.742  1.00 57.25           C  
ATOM   1519  O   ILE A 189      -4.381  17.405  21.567  1.00 58.10           O  
ATOM   1520  CB  ILE A 189      -4.326  18.619  18.593  1.00 60.04           C  
ATOM   1521  CG1 ILE A 189      -5.851  18.585  18.772  1.00 60.41           C  
ATOM   1522  CG2 ILE A 189      -3.940  18.661  17.127  1.00 60.36           C  
ATOM   1523  CD1 ILE A 189      -6.572  19.849  18.325  1.00 61.22           C  
ATOM   1524  N   VAL A 190      -2.370  18.264  21.082  1.00 54.57           N  
ATOM   1525  CA  VAL A 190      -2.083  18.595  22.468  1.00 52.97           C  
ATOM   1526  C   VAL A 190      -1.634  20.040  22.550  1.00 54.02           C  
ATOM   1527  O   VAL A 190      -1.821  20.694  23.575  1.00 54.28           O  
ATOM   1528  CB  VAL A 190      -0.977  17.691  23.050  1.00 51.01           C  
ATOM   1529  CG1 VAL A 190      -0.613  18.138  24.442  1.00 49.22           C  
ATOM   1530  CG2 VAL A 190      -1.451  16.267  23.090  1.00 50.35           C  
ATOM   1531  N   LYS A 191      -1.043  20.527  21.461  1.00 54.21           N  
ATOM   1532  CA  LYS A 191      -0.559  21.901  21.383  1.00 54.77           C  
ATOM   1533  C   LYS A 191       0.276  22.119  20.145  1.00 55.00           C  
ATOM   1534  O   LYS A 191       0.960  21.223  19.658  1.00 54.69           O  
ATOM   1535  CB  LYS A 191       0.320  22.253  22.581  1.00 56.24           C  
ATOM   1536  CG  LYS A 191      -0.298  23.168  23.620  1.00 57.73           C  
ATOM   1537  CD  LYS A 191      -0.525  24.579  23.117  1.00 59.19           C  
ATOM   1538  CE  LYS A 191      -1.036  25.466  24.259  1.00 61.01           C  
ATOM   1539  NZ  LYS A 191      -1.402  26.853  23.835  1.00 62.65           N  
ATOM   1540  N   HIS A 192       0.212  23.337  19.643  1.00 55.36           N  
ATOM   1541  CA  HIS A 192       0.990  23.732  18.496  1.00 56.19           C  
ATOM   1542  C   HIS A 192       1.396  25.149  18.835  1.00 56.90           C  
ATOM   1543  O   HIS A 192       0.696  25.839  19.577  1.00 58.08           O  
ATOM   1544  CB  HIS A 192       0.157  23.704  17.212  1.00 56.99           C  
ATOM   1545  CG  HIS A 192      -1.109  24.498  17.288  1.00 58.45           C  
ATOM   1546  ND1 HIS A 192      -1.844  24.827  16.170  1.00 59.24           N  
ATOM   1547  CD2 HIS A 192      -1.781  25.013  18.345  1.00 59.76           C  
ATOM   1548  CE1 HIS A 192      -2.914  25.511  16.535  1.00 60.49           C  
ATOM   1549  NE2 HIS A 192      -2.900  25.639  17.850  1.00 60.46           N  
ATOM   1550  N   GLY A 193       2.537  25.575  18.322  1.00 56.68           N  
ATOM   1551  CA  GLY A 193       3.002  26.918  18.594  1.00 55.90           C  
ATOM   1552  C   GLY A 193       4.275  27.093  17.815  1.00 55.37           C  
ATOM   1553  O   GLY A 193       5.074  26.163  17.738  1.00 55.96           O  
ATOM   1554  N   SER A 194       4.470  28.263  17.223  1.00 54.35           N  
ATOM   1555  CA  SER A 194       5.680  28.484  16.451  1.00 53.77           C  
ATOM   1556  C   SER A 194       6.794  28.834  17.403  1.00 54.49           C  
ATOM   1557  O   SER A 194       6.547  29.297  18.521  1.00 54.48           O  
ATOM   1558  CB  SER A 194       5.505  29.626  15.460  1.00 53.20           C  
ATOM   1559  OG  SER A 194       5.780  30.863  16.083  1.00 52.82           O  
ATOM   1560  N   LEU A 195       8.019  28.607  16.945  1.00 55.51           N  
ATOM   1561  CA  LEU A 195       9.225  28.887  17.715  1.00 56.72           C  
ATOM   1562  C   LEU A 195       9.734  30.224  17.209  1.00 56.41           C  
ATOM   1563  O   LEU A 195      10.937  30.437  17.104  1.00 56.50           O  
ATOM   1564  CB  LEU A 195      10.266  27.808  17.430  1.00 58.08           C  
ATOM   1565  CG  LEU A 195       9.664  26.403  17.331  1.00 58.98           C  
ATOM   1566  CD1 LEU A 195      10.619  25.463  16.600  1.00 58.09           C  
ATOM   1567  CD2 LEU A 195       9.331  25.906  18.732  1.00 58.67           C  
ATOM   1568  N   MET A 196       8.792  31.114  16.916  1.00 56.52           N  
ATOM   1569  CA  MET A 196       9.062  32.428  16.351  1.00 57.57           C  
ATOM   1570  C   MET A 196      10.435  33.084  16.516  1.00 56.64           C  
ATOM   1571  O   MET A 196      11.061  33.442  15.511  1.00 58.28           O  
ATOM   1572  CB  MET A 196       7.952  33.405  16.743  1.00 60.80           C  
ATOM   1573  CG  MET A 196       7.522  34.282  15.554  1.00 64.63           C  
ATOM   1574  SD  MET A 196       7.838  33.500  13.897  1.00 68.91           S  
ATOM   1575  CE  MET A 196       9.300  34.415  13.352  1.00 65.04           C  
ATOM   1576  N   PRO A 197      10.922  33.293  17.753  1.00 54.51           N  
ATOM   1577  CA  PRO A 197      12.251  33.918  17.736  1.00 52.98           C  
ATOM   1578  C   PRO A 197      13.328  32.973  17.173  1.00 52.56           C  
ATOM   1579  O   PRO A 197      14.014  33.280  16.185  1.00 52.30           O  
ATOM   1580  CB  PRO A 197      12.489  34.254  19.204  1.00 51.08           C  
ATOM   1581  CG  PRO A 197      11.129  34.576  19.684  1.00 51.59           C  
ATOM   1582  CD  PRO A 197      10.283  33.482  19.062  1.00 52.10           C  
ATOM   1583  N   TYR A 198      13.435  31.806  17.802  1.00 51.56           N  
ATOM   1584  CA  TYR A 198      14.417  30.789  17.459  1.00 50.80           C  
ATOM   1585  C   TYR A 198      14.380  30.213  16.048  1.00 50.87           C  
ATOM   1586  O   TYR A 198      15.430  30.078  15.417  1.00 50.79           O  
ATOM   1587  CB  TYR A 198      14.321  29.686  18.499  1.00 50.72           C  
ATOM   1588  CG  TYR A 198      14.389  30.268  19.887  1.00 50.45           C  
ATOM   1589  CD1 TYR A 198      15.601  30.705  20.418  1.00 50.55           C  
ATOM   1590  CD2 TYR A 198      13.234  30.478  20.632  1.00 49.91           C  
ATOM   1591  CE1 TYR A 198      15.657  31.341  21.652  1.00 49.34           C  
ATOM   1592  CE2 TYR A 198      13.282  31.116  21.865  1.00 49.00           C  
ATOM   1593  CZ  TYR A 198      14.497  31.544  22.367  1.00 48.80           C  
ATOM   1594  OH  TYR A 198      14.554  32.188  23.577  1.00 49.54           O  
ATOM   1595  N   HIS A 199      13.191  29.875  15.554  1.00 51.05           N  
ATOM   1596  CA  HIS A 199      13.050  29.326  14.207  1.00 51.81           C  
ATOM   1597  C   HIS A 199      11.892  29.961  13.465  1.00 53.00           C  
ATOM   1598  O   HIS A 199      10.791  29.428  13.454  1.00 53.15           O  
ATOM   1599  CB  HIS A 199      12.866  27.817  14.282  1.00 50.66           C  
ATOM   1600  CG  HIS A 199      14.020  27.121  14.924  1.00 49.96           C  
ATOM   1601  ND1 HIS A 199      14.290  27.221  16.272  1.00 49.33           N  
ATOM   1602  CD2 HIS A 199      15.019  26.377  14.394  1.00 49.09           C  
ATOM   1603  CE1 HIS A 199      15.407  26.571  16.546  1.00 49.09           C  
ATOM   1604  NE2 HIS A 199      15.869  26.050  15.424  1.00 49.87           N  
ATOM   1605  N   ARG A 200      12.165  31.098  12.829  1.00 55.25           N  
ATOM   1606  CA  ARG A 200      11.155  31.867  12.108  1.00 58.27           C  
ATOM   1607  C   ARG A 200      10.379  31.175  10.981  1.00 58.70           C  
ATOM   1608  O   ARG A 200       9.758  31.852  10.166  1.00 58.14           O  
ATOM   1609  CB  ARG A 200      11.776  33.161  11.544  1.00 60.83           C  
ATOM   1610  CG  ARG A 200      12.335  34.151  12.574  1.00 62.89           C  
ATOM   1611  CD  ARG A 200      12.117  35.611  12.117  1.00 66.62           C  
ATOM   1612  NE  ARG A 200      12.835  35.979  10.888  1.00 68.69           N  
ATOM   1613  CZ  ARG A 200      12.653  37.118  10.210  1.00 68.86           C  
ATOM   1614  NH1 ARG A 200      11.770  38.020  10.625  1.00 68.08           N  
ATOM   1615  NH2 ARG A 200      13.361  37.363   9.114  1.00 68.81           N  
ATOM   1616  N   ASP A 201      10.389  29.848  10.924  1.00 59.83           N  
ATOM   1617  CA  ASP A 201       9.655  29.164   9.857  1.00 61.13           C  
ATOM   1618  C   ASP A 201       9.026  27.844  10.315  1.00 61.17           C  
ATOM   1619  O   ASP A 201       8.206  27.262   9.604  1.00 61.64           O  
ATOM   1620  CB  ASP A 201      10.593  28.910   8.668  1.00 63.68           C  
ATOM   1621  CG  ASP A 201       9.852  28.826   7.323  1.00 65.28           C  
ATOM   1622  OD1 ASP A 201       8.925  27.991   7.195  1.00 65.19           O  
ATOM   1623  OD2 ASP A 201      10.211  29.596   6.394  1.00 64.06           O  
ATOM   1624  N   HIS A 202       9.406  27.379  11.503  1.00 60.26           N  
ATOM   1625  CA  HIS A 202       8.886  26.125  12.046  1.00 58.37           C  
ATOM   1626  C   HIS A 202       7.776  26.305  13.097  1.00 57.37           C  
ATOM   1627  O   HIS A 202       7.578  27.396  13.627  1.00 57.46           O  
ATOM   1628  CB  HIS A 202      10.040  25.324  12.666  1.00 58.12           C  
ATOM   1629  CG  HIS A 202      11.074  24.878  11.680  1.00 57.65           C  
ATOM   1630  ND1 HIS A 202      11.859  25.763  10.974  1.00 57.99           N  
ATOM   1631  CD2 HIS A 202      11.456  23.638  11.286  1.00 57.73           C  
ATOM   1632  CE1 HIS A 202      12.679  25.087  10.186  1.00 59.10           C  
ATOM   1633  NE2 HIS A 202      12.455  23.796  10.356  1.00 57.85           N  
ATOM   1634  N   ILE A 203       7.052  25.220  13.384  1.00 56.31           N  
ATOM   1635  CA  ILE A 203       5.995  25.202  14.403  1.00 54.93           C  
ATOM   1636  C   ILE A 203       5.895  23.778  14.931  1.00 53.55           C  
ATOM   1637  O   ILE A 203       5.860  22.839  14.144  1.00 53.90           O  
ATOM   1638  CB  ILE A 203       4.612  25.615  13.850  1.00 55.74           C  
ATOM   1639  CG1 ILE A 203       3.614  25.693  15.008  1.00 55.44           C  
ATOM   1640  CG2 ILE A 203       4.121  24.600  12.819  1.00 56.11           C  
ATOM   1641  CD1 ILE A 203       2.277  26.287  14.646  1.00 55.96           C  
ATOM   1642  N   PHE A 204       5.853  23.608  16.251  1.00 52.50           N  
ATOM   1643  CA  PHE A 204       5.783  22.270  16.838  1.00 51.53           C  
ATOM   1644  C   PHE A 204       4.358  21.827  17.136  1.00 52.17           C  
ATOM   1645  O   PHE A 204       3.533  22.599  17.630  1.00 52.95           O  
ATOM   1646  CB  PHE A 204       6.610  22.209  18.121  1.00 49.97           C  
ATOM   1647  CG  PHE A 204       5.922  22.818  19.315  1.00 51.19           C  
ATOM   1648  CD1 PHE A 204       5.166  22.028  20.178  1.00 50.79           C  
ATOM   1649  CD2 PHE A 204       6.005  24.187  19.565  1.00 50.81           C  
ATOM   1650  CE1 PHE A 204       4.505  22.591  21.267  1.00 49.76           C  
ATOM   1651  CE2 PHE A 204       5.348  24.760  20.651  1.00 48.96           C  
ATOM   1652  CZ  PHE A 204       4.599  23.959  21.501  1.00 49.96           C  
ATOM   1653  N   ILE A 205       4.069  20.572  16.831  1.00 52.31           N  
ATOM   1654  CA  ILE A 205       2.748  20.032  17.076  1.00 52.90           C  
ATOM   1655  C   ILE A 205       2.915  18.817  17.974  1.00 54.54           C  
ATOM   1656  O   ILE A 205       3.581  17.852  17.600  1.00 54.91           O  
ATOM   1657  CB  ILE A 205       2.067  19.566  15.772  1.00 52.50           C  
ATOM   1658  CG1 ILE A 205       2.217  20.610  14.671  1.00 51.37           C  
ATOM   1659  CG2 ILE A 205       0.588  19.345  16.017  1.00 53.25           C  
ATOM   1660  CD1 ILE A 205       1.593  20.178  13.350  1.00 49.37           C  
ATOM   1661  N   HIS A 206       2.331  18.871  19.166  1.00 56.50           N  
ATOM   1662  CA  HIS A 206       2.409  17.744  20.087  1.00 57.97           C  
ATOM   1663  C   HIS A 206       1.088  17.017  19.953  1.00 60.77           C  
ATOM   1664  O   HIS A 206       0.043  17.654  19.801  1.00 61.92           O  
ATOM   1665  CB  HIS A 206       2.575  18.211  21.530  1.00 55.00           C  
ATOM   1666  CG  HIS A 206       2.797  17.091  22.494  1.00 53.07           C  
ATOM   1667  ND1 HIS A 206       2.138  17.004  23.699  1.00 52.56           N  
ATOM   1668  CD2 HIS A 206       3.618  16.015  22.435  1.00 52.81           C  
ATOM   1669  CE1 HIS A 206       2.542  15.921  24.341  1.00 53.04           C  
ATOM   1670  NE2 HIS A 206       3.440  15.303  23.595  1.00 52.08           N  
ATOM   1671  N   ALA A 207       1.126  15.691  20.001  1.00 63.68           N  
ATOM   1672  CA  ALA A 207      -0.094  14.906  19.867  1.00 66.68           C  
ATOM   1673  C   ALA A 207       0.136  13.432  20.161  1.00 68.65           C  
ATOM   1674  O   ALA A 207       1.261  13.002  20.414  1.00 68.58           O  
ATOM   1675  CB  ALA A 207      -0.667  15.075  18.460  1.00 66.28           C  
ATOM   1676  N   TYR A 208      -0.940  12.658  20.125  1.00 71.57           N  
ATOM   1677  CA  TYR A 208      -0.840  11.236  20.389  1.00 75.13           C  
ATOM   1678  C   TYR A 208      -2.014  10.502  19.762  1.00 76.59           C  
ATOM   1679  O   TYR A 208      -3.039  11.109  19.438  1.00 76.39           O  
ATOM   1680  CB  TYR A 208      -0.796  10.992  21.901  1.00 77.05           C  
ATOM   1681  CG  TYR A 208      -2.103  11.231  22.625  1.00 79.77           C  
ATOM   1682  CD1 TYR A 208      -2.935  10.165  22.969  1.00 81.39           C  
ATOM   1683  CD2 TYR A 208      -2.511  12.520  22.966  1.00 80.77           C  
ATOM   1684  CE1 TYR A 208      -4.142  10.373  23.635  1.00 83.01           C  
ATOM   1685  CE2 TYR A 208      -3.720  12.742  23.634  1.00 82.83           C  
ATOM   1686  CZ  TYR A 208      -4.532  11.662  23.963  1.00 83.68           C  
ATOM   1687  OH  TYR A 208      -5.737  11.864  24.604  1.00 83.66           O  
ATOM   1688  N   ARG A 209      -1.852   9.196  19.579  1.00 77.88           N  
ATOM   1689  CA  ARG A 209      -2.902   8.384  18.997  1.00 79.81           C  
ATOM   1690  C   ARG A 209      -3.499   7.475  20.055  1.00 81.02           C  
ATOM   1691  O   ARG A 209      -2.784   6.734  20.734  1.00 79.97           O  
ATOM   1692  CB  ARG A 209      -2.357   7.541  17.846  1.00 80.88           C  
ATOM   1693  CG  ARG A 209      -1.219   6.613  18.230  1.00 83.25           C  
ATOM   1694  CD  ARG A 209      -0.934   5.612  17.117  1.00 84.50           C  
ATOM   1695  NE  ARG A 209      -1.980   4.597  17.026  1.00 85.67           N  
ATOM   1696  CZ  ARG A 209      -2.111   3.742  16.018  1.00 85.74           C  
ATOM   1697  NH1 ARG A 209      -1.258   3.776  15.000  1.00 85.35           N  
ATOM   1698  NH2 ARG A 209      -3.095   2.852  16.029  1.00 85.44           N  
ATOM   1699  N   PHE A 210      -4.819   7.547  20.192  1.00 83.38           N  
ATOM   1700  CA  PHE A 210      -5.550   6.734  21.158  1.00 85.90           C  
ATOM   1701  C   PHE A 210      -5.803   5.358  20.533  1.00 87.66           C  
ATOM   1702  O   PHE A 210      -5.354   5.137  19.382  1.00 88.27           O  
ATOM   1703  CB  PHE A 210      -6.888   7.408  21.505  1.00 85.38           C  
ATOM   1704  CG  PHE A 210      -7.206   7.422  22.981  1.00 84.33           C  
ATOM   1705  CD1 PHE A 210      -7.326   6.236  23.694  1.00 83.46           C  
ATOM   1706  CD2 PHE A 210      -7.393   8.628  23.653  1.00 84.52           C  
ATOM   1707  CE1 PHE A 210      -7.626   6.248  25.056  1.00 83.60           C  
ATOM   1708  CE2 PHE A 210      -7.694   8.653  25.016  1.00 84.17           C  
ATOM   1709  CZ  PHE A 210      -7.811   7.458  25.720  1.00 83.97           C  
ATOM   1710  OXT PHE A 210      -6.448   4.515  21.197  1.00 90.05           O  
TER    1711      PHE A 210                                                      
END
MOLECULE T0508.pdb
ATOM      1  N   GLN    17      27.341  18.956  20.266  1.00 28.55           N  
ATOM      2  CA  GLN    17      26.133  19.476  19.544  1.00 26.35           C  
ATOM      3  C   GLN    17      25.067  19.993  20.513  1.00 30.77           C  
ATOM      4  O   GLN    17      24.034  20.543  20.088  1.00 24.08           O  
ATOM      5  CB  GLN    17      25.542  18.382  18.646  1.00 27.54           C  
ATOM      6  CG  GLN    17      26.434  17.946  17.479  1.00 28.33           C  
ATOM      7  CD  GLN    17      26.586  19.019  16.411  1.00 35.79           C  
ATOM      8  OE1 GLN    17      25.718  19.891  16.241  1.00 34.30           O  
ATOM      9  NE2 GLN    17      27.692  18.953  15.672  1.00 38.09           N  
ATOM     10  N   LEU    18      25.329  19.819  21.814  1.00 31.52           N  
ATOM     11  CA  LEU    18      24.433  20.242  22.907  1.00 36.19           C  
ATOM     12  C   LEU    18      24.053  21.718  22.876  1.00 37.06           C  
ATOM     13  O   LEU    18      23.038  22.126  23.448  1.00 36.28           O  
ATOM     14  CB  LEU    18      25.085  19.950  24.263  1.00 40.29           C  
ATOM     15  CG  LEU    18      25.116  18.500  24.733  1.00 40.46           C  
ATOM     16  CD1 LEU    18      25.963  18.381  25.991  1.00 45.09           C  
ATOM     17  CD2 LEU    18      23.700  18.005  24.965  1.00 39.67           C  
ATOM     18  N   ARG    19      24.888  22.495  22.199  1.00 35.74           N  
ATOM     19  CA  ARG    19      24.812  23.945  22.161  1.00 37.88           C  
ATOM     20  C   ARG    19      24.334  24.487  20.806  1.00 29.39           C  
ATOM     21  O   ARG    19      24.321  25.705  20.601  1.00 29.87           O  
ATOM     22  CB  ARG    19      26.205  24.493  22.466  1.00 42.33           C  
ATOM     23  CG  ARG    19      27.341  23.712  21.765  1.00 53.58           C  
ATOM     24  CD  ARG    19      27.752  24.332  20.429  1.00 61.77           C  
ATOM     25  NE  ARG    19      28.576  23.428  19.629  1.00 75.01           N  
ATOM     26  CZ  ARG    19      28.165  22.800  18.529  1.00 80.38           C  
ATOM     27  NH1 ARG    19      26.931  22.978  18.067  1.00 80.36           N  
ATOM     28  NH2 ARG    19      28.996  21.994  17.880  1.00 82.30           N  
ATOM     29  N   SER    20      23.992  23.591  19.877  1.00 22.34           N  
ATOM     30  CA  SER    20      23.537  23.996  18.549  1.00 20.35           C  
ATOM     31  C   SER    20      22.175  24.689  18.593  1.00 18.47           C  
ATOM     32  O   SER    20      21.426  24.558  19.561  1.00 18.01           O  
ATOM     33  CB  SER    20      23.472  22.799  17.611  1.00 22.60           C  
ATOM     34  OG  SER    20      22.316  22.019  17.885  1.00 20.95           O  
ATOM     35  N   ARG    21      21.846  25.410  17.528  1.00 18.65           N  
ATOM     36  CA  ARG    21      20.566  26.116  17.455  1.00 19.51           C  
ATOM     37  C   ARG    21      19.421  25.111  17.556  1.00 17.07           C  
ATOM     38  O   ARG    21      18.440  25.343  18.268  1.00 19.73           O  
ATOM     39  CB  ARG    21      20.473  26.874  16.130  1.00 23.77           C  
ATOM     40  CG  ARG    21      19.192  27.666  15.945  1.00 31.80           C  
ATOM     41  CD  ARG    21      19.340  28.620  14.778  1.00 45.60           C  
ATOM     42  NE  ARG    21      18.350  29.692  14.818  1.00 57.03           N  
ATOM     43  CZ  ARG    21      18.418  30.803  14.089  1.00 65.61           C  
ATOM     44  NH1 ARG    21      19.437  30.999  13.257  1.00 66.62           N  
ATOM     45  NH2 ARG    21      17.468  31.723  14.194  1.00 68.54           N  
ATOM     46  N   ALA    22      19.578  23.995  16.850  1.00 17.83           N  
ATOM     47  CA  ALA    22      18.573  22.948  16.851  1.00 15.55           C  
ATOM     48  C   ALA    22      18.381  22.371  18.258  1.00 16.33           C  
ATOM     49  O   ALA    22      17.249  22.202  18.720  1.00 17.50           O  
ATOM     50  CB  ALA    22      18.933  21.869  15.862  1.00 19.42           C  
ATOM     51  N   ALA    23      19.481  22.100  18.964  1.00 16.59           N  
ATOM     52  CA  ALA    23      19.386  21.661  20.362  1.00 15.10           C  
ATOM     53  C   ALA    23      18.604  22.656  21.238  1.00 16.51           C  
ATOM     54  O   ALA    23      17.775  22.244  22.038  1.00 15.64           O  
ATOM     55  CB  ALA    23      20.787  21.427  20.948  1.00 15.49           C  
ATOM     56  N   PHE    24      18.867  23.967  21.093  1.00 15.01           N  
ATOM     57  CA  PHE    24      18.139  24.958  21.887  1.00 20.00           C  
ATOM     58  C   PHE    24      16.644  24.967  21.591  1.00 14.73           C  
ATOM     59  O   PHE    24      15.815  25.130  22.508  1.00 18.39           O  
ATOM     60  CB  PHE    24      18.733  26.367  21.714  1.00 25.77           C  
ATOM     61  CG  PHE    24      19.868  26.656  22.659  1.00 37.19           C  
ATOM     62  CD1 PHE    24      19.615  27.052  23.971  1.00 47.97           C  
ATOM     63  CD2 PHE    24      21.193  26.508  22.245  1.00 46.26           C  
ATOM     64  CE1 PHE    24      20.666  27.309  24.857  1.00 54.49           C  
ATOM     65  CE2 PHE    24      22.251  26.764  23.120  1.00 49.16           C  
ATOM     66  CZ  PHE    24      21.989  27.165  24.428  1.00 48.58           C  
ATOM     67  N   LYS    25      16.301  24.766  20.314  1.00 15.96           N  
ATOM     68  CA  LYS    25      14.893  24.667  19.907  1.00 15.07           C  
ATOM     69  C   LYS    25      14.239  23.492  20.622  1.00 14.67           C  
ATOM     70  O   LYS    25      13.147  23.626  21.185  1.00 14.53           O  
ATOM     71  CB  LYS    25      14.751  24.520  18.391  1.00 16.88           C  
ATOM     72  CG  LYS    25      15.042  25.803  17.590  1.00 24.44           C  
ATOM     73  CD  LYS    25      14.706  25.620  16.105  1.00 27.14           C  
ATOM     74  CE  LYS    25      15.959  25.479  15.249  1.00 35.96           C  
ATOM     75  NZ  LYS    25      15.649  25.049  13.851  1.00 38.22           N  
ATOM     76  N   LEU    26      14.912  22.340  20.648  1.00 13.44           N  
ATOM     77  CA  LEU    26      14.307  21.207  21.341  1.00 12.47           C  
ATOM     78  C   LEU    26      14.186  21.435  22.842  1.00 12.58           C  
ATOM     79  O   LEU    26      13.165  21.067  23.427  1.00 13.35           O  
ATOM     80  CB  LEU    26      15.051  19.889  21.058  1.00 14.07           C  
ATOM     81  CG  LEU    26      14.419  18.650  21.686  1.00 12.73           C  
ATOM     82  CD1 LEU    26      13.020  18.452  21.173  1.00 13.01           C  
ATOM     83  CD2 LEU    26      15.264  17.428  21.366  1.00 13.66           C  
ATOM     84  N   GLU    27      15.197  22.047  23.463  1.00 14.16           N  
ATOM     85  CA  GLU    27      15.124  22.335  24.902  1.00 15.27           C  
ATOM     86  C   GLU    27      13.907  23.219  25.231  1.00 12.64           C  
ATOM     87  O   GLU    27      13.205  22.990  26.204  1.00 14.02           O  
ATOM     88  CB  GLU    27      16.428  22.989  25.382  1.00 16.28           C  
ATOM     89  CG  GLU    27      17.600  21.998  25.485  1.00 27.56           C  
ATOM     90  CD  GLU    27      18.915  22.632  25.940  1.00 38.21           C  
ATOM     91  OE1 GLU    27      19.405  23.577  25.272  1.00 49.67           O  
ATOM     92  OE2 GLU    27      19.469  22.163  26.960  1.00 51.34           O  
ATOM     93  N   PHE    28      13.670  24.214  24.380  1.00 14.06           N  
ATOM     94  CA  PHE    28      12.541  25.133  24.517  1.00 12.72           C  
ATOM     95  C   PHE    28      11.221  24.373  24.460  1.00 13.27           C  
ATOM     96  O   PHE    28      10.360  24.568  25.306  1.00 13.48           O  
ATOM     97  CB  PHE    28      12.682  26.168  23.405  1.00 13.96           C  
ATOM     98  CG  PHE    28      11.502  27.087  23.215  1.00 14.57           C  
ATOM     99  CD1 PHE    28      11.408  28.290  23.917  1.00 19.84           C  
ATOM    100  CD2 PHE    28      10.536  26.793  22.258  1.00 17.11           C  
ATOM    101  CE1 PHE    28      10.346  29.167  23.677  1.00 17.75           C  
ATOM    102  CE2 PHE    28       9.457  27.663  22.024  1.00 16.94           C  
ATOM    103  CZ  PHE    28       9.381  28.850  22.735  1.00 20.66           C  
ATOM    104  N   LEU    29      11.108  23.480  23.476  1.00 13.95           N  
ATOM    105  CA  LEU    29       9.905  22.672  23.317  1.00 11.98           C  
ATOM    106  C   LEU    29       9.685  21.692  24.466  1.00 12.60           C  
ATOM    107  O   LEU    29       8.537  21.496  24.882  1.00 13.48           O  
ATOM    108  CB  LEU    29       9.940  21.899  21.982  1.00 13.29           C  
ATOM    109  CG  LEU    29       9.955  22.790  20.727  1.00 13.34           C  
ATOM    110  CD1 LEU    29      10.381  21.990  19.476  1.00 14.82           C  
ATOM    111  CD2 LEU    29       8.600  23.481  20.463  1.00 14.32           C  
ATOM    112  N   LEU    30      10.753  21.064  24.967  1.00 10.58           N  
ATOM    113  CA  LEU    30      10.602  20.155  26.121  1.00 12.83           C  
ATOM    114  C   LEU    30      10.172  20.920  27.372  1.00 12.29           C  
ATOM    115  O   LEU    30       9.300  20.465  28.111  1.00 14.05           O  
ATOM    116  CB  LEU    30      11.895  19.370  26.400  1.00 15.66           C  
ATOM    117  CG  LEU    30      12.359  18.479  25.258  1.00 16.16           C  
ATOM    118  CD1 LEU    30      13.759  17.903  25.567  1.00 17.08           C  
ATOM    119  CD2 LEU    30      11.320  17.389  24.963  1.00 19.76           C  
ATOM    120  N   ASP    31      10.738  22.115  27.577  1.00 13.31           N  
ATOM    121  CA  ASP    31      10.380  22.953  28.748  1.00 12.70           C  
ATOM    122  C   ASP    31       8.916  23.346  28.710  1.00 13.57           C  
ATOM    123  O   ASP    31       8.207  23.347  29.728  1.00 13.47           O  
ATOM    124  CB  ASP    31      11.213  24.239  28.773  1.00 16.51           C  
ATOM    125  CG  ASP    31      12.593  24.044  29.368  1.00 23.03           C  
ATOM    126  OD1 ASP    31      12.832  23.035  30.067  1.00 27.41           O  
ATOM    127  OD2 ASP    31      13.448  24.930  29.141  1.00 27.84           O  
ATOM    128  N   ARG    32       8.452  23.717  27.535  1.00 12.67           N  
ATOM    129  CA  ARG    32       7.103  24.226  27.393  1.00 12.84           C  
ATOM    130  C   ARG    32       6.040  23.146  27.326  1.00 13.39           C  
ATOM    131  O   ARG    32       4.932  23.349  27.808  1.00 13.37           O  
ATOM    132  CB  ARG    32       7.000  25.023  26.116  1.00 12.72           C  
ATOM    133  CG  ARG    32       7.559  26.433  26.139  1.00 14.78           C  
ATOM    134  CD  ARG    32       7.075  27.174  24.878  1.00 14.18           C  
ATOM    135  NE  ARG    32       7.107  28.621  25.069  1.00 18.87           N  
ATOM    136  CZ  ARG    32       6.487  29.493  24.283  1.00 19.83           C  
ATOM    137  NH1 ARG    32       6.604  30.782  24.540  1.00 27.51           N  
ATOM    138  NH2 ARG    32       5.760  29.077  23.246  1.00 19.18           N  
ATOM    139  N   TYR    33       6.361  22.031  26.665  1.00 10.84           N  
ATOM    140  CA  TYR    33       5.349  21.039  26.290  1.00 11.98           C  
ATOM    141  C   TYR    33       5.577  19.599  26.760  1.00 12.64           C  
ATOM    142  O   TYR    33       4.688  18.759  26.572  1.00 13.17           O  
ATOM    143  CB  TYR    33       5.177  21.027  24.770  1.00 11.87           C  
ATOM    144  CG  TYR    33       4.950  22.401  24.210  1.00 12.45           C  
ATOM    145  CD1 TYR    33       3.748  23.065  24.432  1.00 12.73           C  
ATOM    146  CD2 TYR    33       5.941  23.052  23.490  1.00 11.65           C  
ATOM    147  CE1 TYR    33       3.525  24.350  23.915  1.00 13.75           C  
ATOM    148  CE2 TYR    33       5.720  24.343  22.958  1.00 13.97           C  
ATOM    149  CZ  TYR    33       4.524  24.980  23.189  1.00 14.82           C  
ATOM    150  OH  TYR    33       4.331  26.250  22.673  1.00 17.07           O  
ATOM    151  N   ARG    34       6.737  19.329  27.320  1.00 11.94           N  
ATOM    152  CA  ARG    34       7.075  17.987  27.885  0.50 12.60           C  
ATOM    154  C   ARG    34       6.752  16.863  26.836  1.00 15.29           C  
ATOM    155  O   ARG    34       6.265  15.838  27.180  1.00 16.34           O  
ATOM    156  CB  ARG    34       6.341  17.730  29.206  0.50 15.27           C  
ATOM    158  CG  ARG    34       6.715  18.721  30.308  0.50 18.80           C  
ATOM    160  CD  ARG    34       6.251  18.251  31.685  0.50 24.09           C  
ATOM    162  NE  ARG    34       7.080  17.171  32.217  0.50 29.99           N  
ATOM    164  CZ  ARG    34       6.723  15.887  32.260  0.50 35.77           C  
ATOM    166  NH1 ARG    34       7.554  14.986  32.768  0.50 30.23           N  
ATOM    168  NH2 ARG    34       5.538  15.495  31.800  0.50 39.31           N  
ATOM    170  N   VAL    35       7.093  17.136  25.601  1.00 14.33           N  
ATOM    171  CA  VAL    35       6.681  16.252  24.539  1.00 16.23           C  
ATOM    172  C   VAL    35       7.397  14.907  24.563  1.00 15.87           C  
ATOM    173  O   VAL    35       6.842  13.935  24.164  1.00 18.60           O  
ATOM    174  CB  VAL    35       6.614  16.981  23.155  1.00 20.79           C  
ATOM    175  CG1 VAL    35       7.901  17.453  22.753  1.00 19.27           C  
ATOM    176  CG2 VAL    35       5.962  16.095  22.079  1.00 22.03           C  
ATOM    177  N   VAL    36       8.620  14.904  25.063  1.00 14.69           N  
ATOM    178  CA  VAL    36       9.323  13.708  25.475  1.00 14.45           C  
ATOM    179  C   VAL    36       9.549  13.719  27.008  1.00 14.37           C  
ATOM    180  O   VAL    36       9.873  14.725  27.537  1.00 16.00           O  
ATOM    181  CB  VAL    36      10.688  13.600  24.695  1.00 15.76           C  
ATOM    182  CG1 VAL    36      11.501  12.407  25.134  1.00 14.06           C  
ATOM    183  CG2 VAL    36      10.462  13.571  23.222  1.00 13.18           C  
ATOM    184  N   ARG    37       9.328  12.593  27.672  1.00 13.64           N  
ATOM    185  CA  ARG    37       9.333  12.429  29.008  0.50 18.53           C  
ATOM    187  C   ARG    37      10.496  11.527  29.402  1.00 15.77           C  
ATOM    188  O   ARG    37      10.863  10.667  28.672  1.00 14.89           O  
ATOM    189  CB  ARG    37       7.994  11.913  29.555  0.50 20.65           C  
ATOM    191  CG  ARG    37       6.819  12.854  29.252  0.50 30.27           C  
ATOM    193  CD  ARG    37       5.434  12.185  29.360  0.50 33.11           C  
ATOM    195  NE  ARG    37       5.097  11.095  28.417  0.50 42.98           N  
ATOM    197  CZ  ARG    37       5.375  11.018  27.107  0.50 40.65           C  
ATOM    199  NH1 ARG    37       6.040  11.964  26.456  0.50 28.66           N  
ATOM    201  NH2 ARG    37       4.975   9.949  26.427  0.50 44.72           N  
ATOM    203  N   LYS    38      11.067  11.751  30.563  1.00 15.15           N  
ATOM    204  CA  LYS    38      12.094  10.917  31.115  1.00 13.26           C  
ATOM    205  C   LYS    38      11.741   9.422  31.039  1.00 14.54           C  
ATOM    206  O   LYS    38      10.728   9.042  31.504  1.00 15.92           O  
ATOM    207  CB  LYS    38      12.289  11.304  32.594  1.00 16.09           C  
ATOM    208  CG  LYS    38      13.380  10.611  33.234  1.00 22.87           C  
ATOM    209  CD  LYS    38      14.598  11.183  32.785  1.00 36.52           C  
ATOM    210  CE  LYS    38      15.770  10.611  33.427  1.00 45.52           C  
ATOM    211  NZ  LYS    38      16.989  11.533  33.326  1.00 52.07           N  
ATOM    212  N   GLY    39      12.616   8.645  30.434  1.00 14.73           N  
ATOM    213  CA  GLY    39      12.416   7.193  30.331  1.00 13.34           C  
ATOM    214  C   GLY    39      11.741   6.729  29.047  1.00 14.96           C  
ATOM    215  O   GLY    39      11.562   5.538  28.824  1.00 12.59           O  
ATOM    216  N   ASP    40      11.334   7.670  28.208  1.00 11.88           N  
ATOM    217  CA  ASP    40      10.695   7.357  26.933  1.00  9.89           C  
ATOM    218  C   ASP    40      11.656   6.706  25.958  1.00 10.44           C  
ATOM    219  O   ASP    40      12.871   6.965  25.986  1.00 11.68           O  
ATOM    220  CB  ASP    40      10.168   8.642  26.291  1.00  9.60           C  
ATOM    221  CG  ASP    40       8.825   9.075  26.855  1.00 15.15           C  
ATOM    222  OD1 ASP    40       8.300   8.390  27.768  1.00 15.94           O  
ATOM    223  OD2 ASP    40       8.287  10.116  26.398  1.00 13.89           O  
ATOM    224  N   ALA    41      11.087   5.869  25.081  1.00  9.23           N  
ATOM    225  CA  ALA    41      11.803   5.381  23.917  1.00 10.66           C  
ATOM    226  C   ALA    41      11.312   6.214  22.746  1.00 10.39           C  
ATOM    227  O   ALA    41      10.097   6.409  22.593  1.00 10.52           O  
ATOM    228  CB  ALA    41      11.509   3.893  23.655  1.00 11.78           C  
ATOM    229  N   VAL    42      12.251   6.703  21.934  1.00  9.29           N  
ATOM    230  CA  VAL    42      11.966   7.691  20.884  1.00  9.19           C  
ATOM    231  C   VAL    42      12.535   7.249  19.544  1.00  9.09           C  
ATOM    232  O   VAL    42      13.680   6.824  19.477  1.00 10.43           O  
ATOM    233  CB  VAL    42      12.634   9.041  21.259  1.00 10.87           C  
ATOM    234  CG1 VAL    42      12.350  10.120  20.216  1.00 10.02           C  
ATOM    235  CG2 VAL    42      12.159   9.507  22.641  1.00  9.93           C  
ATOM    236  N   ILE    43      11.714   7.336  18.489  1.00  9.23           N  
ATOM    237  CA  ILE    43      12.233   7.267  17.117  1.00  8.55           C  
ATOM    238  C   ILE    43      12.455   8.724  16.690  1.00  9.88           C  
ATOM    239  O   ILE    43      11.523   9.538  16.716  1.00 10.54           O  
ATOM    240  CB  ILE    43      11.247   6.608  16.168  1.00  9.68           C  
ATOM    241  CG1 ILE    43      11.134   5.117  16.514  1.00 11.32           C  
ATOM    242  CG2 ILE    43      11.709   6.781  14.705  1.00 13.11           C  
ATOM    243  CD1 ILE    43       9.953   4.437  15.835  1.00 12.08           C  
ATOM    244  N   GLU    44      13.695   9.056  16.345  1.00 10.06           N  
ATOM    245  CA  GLU    44      14.079  10.401  15.958  1.00 10.36           C  
ATOM    246  C   GLU    44      14.415  10.427  14.478  1.00 11.21           C  
ATOM    247  O   GLU    44      15.330   9.729  14.050  1.00 12.60           O  
ATOM    248  CB  GLU    44      15.301  10.844  16.764  1.00 11.21           C  
ATOM    249  CG  GLU    44      15.747  12.224  16.301  1.00 11.70           C  
ATOM    250  CD  GLU    44      17.120  12.636  16.766  1.00 13.48           C  
ATOM    251  OE1 GLU    44      17.897  11.771  17.255  1.00 15.29           O  
ATOM    252  OE2 GLU    44      17.420  13.836  16.601  1.00 17.75           O  
ATOM    253  N   ILE    45      13.664  11.191  13.701  1.00  9.39           N  
ATOM    254  CA  ILE    45      13.837  11.257  12.237  1.00  9.26           C  
ATOM    255  C   ILE    45      14.554  12.550  11.852  1.00 10.33           C  
ATOM    256  O   ILE    45      14.161  13.633  12.285  1.00 12.16           O  
ATOM    257  CB  ILE    45      12.486  11.132  11.523  1.00 10.48           C  
ATOM    258  CG1 ILE    45      11.919   9.730  11.811  1.00 14.98           C  
ATOM    259  CG2 ILE    45      12.642  11.353  10.015  1.00 13.76           C  
ATOM    260  CD1 ILE    45      10.461   9.557  11.499  1.00 20.21           C  
ATOM    261  N   GLY    46      15.643  12.439  11.084  1.00 11.67           N  
ATOM    262  CA  GLY    46      16.424  13.628  10.739  1.00 10.89           C  
ATOM    263  C   GLY    46      17.394  14.013  11.850  1.00 11.86           C  
ATOM    264  O   GLY    46      17.433  15.156  12.283  1.00 14.16           O  
ATOM    265  N   SER    47      18.192  13.047  12.287  1.00 14.11           N  
ATOM    266  CA  SER    47      19.016  13.223  13.476  1.00 13.31           C  
ATOM    267  C   SER    47      20.367  13.896  13.288  1.00 12.81           C  
ATOM    268  O   SER    47      20.932  14.398  14.248  1.00 14.54           O  
ATOM    269  CB  SER    47      19.277  11.857  14.108  1.00 11.08           C  
ATOM    270  OG  SER    47      19.928  10.995  13.176  1.00 14.23           O  
ATOM    271  N   SER    48      20.890  13.926  12.065  1.00 12.35           N  
ATOM    272  CA  SER    48      22.264  14.391  11.892  0.50 12.78           C  
ATOM    274  C   SER    48      22.363  15.908  11.904  1.00 12.43           C  
ATOM    275  O   SER    48      21.495  16.587  11.361  1.00 16.33           O  
ATOM    276  CB  SER    48      22.855  13.821  10.613  0.50 13.15           C  
ATOM    278  OG  SER    48      22.792  12.407  10.651  0.50 12.11           O  
ATOM    280  N   PRO    49      23.431  16.454  12.534  1.00 13.69           N  
ATOM    281  CA  PRO    49      24.584  15.838  13.196  1.00 14.45           C  
ATOM    282  C   PRO    49      24.402  15.350  14.622  1.00 15.17           C  
ATOM    283  O   PRO    49      25.297  14.696  15.125  1.00 18.41           O  
ATOM    284  CB  PRO    49      25.646  16.960  13.158  1.00 13.96           C  
ATOM    285  CG  PRO    49      24.828  18.216  13.270  1.00 16.02           C  
ATOM    286  CD  PRO    49      23.555  17.932  12.489  1.00 16.62           C  
ATOM    287  N   GLY    50      23.286  15.668  15.282  1.00 14.24           N  
ATOM    288  CA  GLY    50      23.063  15.082  16.608  1.00 11.34           C  
ATOM    289  C   GLY    50      22.701  16.000  17.754  1.00 13.31           C  
ATOM    290  O   GLY    50      22.751  15.585  18.900  1.00 13.91           O  
ATOM    291  N   GLY    51      22.342  17.254  17.466  1.00 12.78           N  
ATOM    292  CA  GLY    51      21.909  18.171  18.531  1.00 12.63           C  
ATOM    293  C   GLY    51      20.682  17.708  19.307  1.00 13.36           C  
ATOM    294  O   GLY    51      20.701  17.634  20.539  1.00 13.73           O  
ATOM    295  N   TRP    52      19.601  17.405  18.587  1.00 11.89           N  
ATOM    296  CA  TRP    52      18.441  16.839  19.275  1.00 11.79           C  
ATOM    297  C   TRP    52      18.798  15.531  19.953  1.00 11.80           C  
ATOM    298  O   TRP    52      18.345  15.262  21.057  1.00 13.79           O  
ATOM    299  CB  TRP    52      17.276  16.596  18.323  1.00 12.99           C  
ATOM    300  CG  TRP    52      16.480  17.814  17.965  1.00 13.11           C  
ATOM    301  CD1 TRP    52      16.894  19.126  17.985  1.00 11.58           C  
ATOM    302  CD2 TRP    52      15.125  17.829  17.523  1.00 12.99           C  
ATOM    303  NE1 TRP    52      15.878  19.948  17.579  1.00 13.19           N  
ATOM    304  CE2 TRP    52      14.777  19.177  17.287  1.00 13.10           C  
ATOM    305  CE3 TRP    52      14.164  16.825  17.299  1.00 13.89           C  
ATOM    306  CZ2 TRP    52      13.496  19.554  16.851  1.00 12.31           C  
ATOM    307  CZ3 TRP    52      12.906  17.193  16.854  1.00 14.51           C  
ATOM    308  CH2 TRP    52      12.586  18.547  16.632  1.00 12.23           C  
ATOM    309  N   THR    53      19.602  14.703  19.281  1.00 11.88           N  
ATOM    310  CA  THR    53      19.935  13.386  19.848  1.00 13.53           C  
ATOM    311  C   THR    53      20.637  13.514  21.192  1.00 11.78           C  
ATOM    312  O   THR    53      20.307  12.798  22.142  1.00 15.17           O  
ATOM    313  CB  THR    53      20.836  12.558  18.891  1.00 13.39           C  
ATOM    314  OG1 THR    53      20.362  12.667  17.548  1.00 15.73           O  
ATOM    315  CG2 THR    53      20.864  11.092  19.305  1.00 15.16           C  
ATOM    316  N   GLN    54      21.570  14.460  21.279  1.00 13.11           N  
ATOM    317  CA  GLN    54      22.293  14.685  22.521  1.00 14.80           C  
ATOM    318  C   GLN    54      21.366  15.235  23.616  1.00 14.98           C  
ATOM    319  O   GLN    54      21.513  14.867  24.783  1.00 17.30           O  
ATOM    320  CB  GLN    54      23.494  15.605  22.274  1.00 15.90           C  
ATOM    321  CG  GLN    54      24.615  14.902  21.537  1.00 17.43           C  
ATOM    322  CD  GLN    54      25.871  15.739  21.359  1.00 23.10           C  
ATOM    323  OE1 GLN    54      26.032  16.792  21.966  1.00 27.50           O  
ATOM    324  NE2 GLN    54      26.777  15.252  20.521  1.00 36.12           N  
ATOM    325  N   VAL    55      20.407  16.085  23.253  1.00 13.38           N  
ATOM    326  CA  VAL    55      19.436  16.577  24.224  1.00 13.23           C  
ATOM    327  C   VAL    55      18.549  15.413  24.682  1.00 16.58           C  
ATOM    328  O   VAL    55      18.325  15.241  25.881  1.00 19.21           O  
ATOM    329  CB  VAL    55      18.568  17.734  23.646  1.00 14.91           C  
ATOM    330  CG1 VAL    55      17.342  18.049  24.540  1.00 15.77           C  
ATOM    331  CG2 VAL    55      19.428  18.996  23.464  1.00 18.22           C  
ATOM    332  N   LEU    56      18.064  14.627  23.718  1.00 13.47           N  
ATOM    333  CA  LEU    56      17.193  13.485  24.034  1.00 16.57           C  
ATOM    334  C   LEU    56      17.903  12.413  24.853  1.00 14.44           C  
ATOM    335  O   LEU    56      17.277  11.761  25.667  1.00 13.36           O  
ATOM    336  CB  LEU    56      16.608  12.859  22.769  1.00 14.57           C  
ATOM    337  CG  LEU    56      15.627  13.647  21.890  1.00 16.91           C  
ATOM    338  CD1 LEU    56      15.467  12.948  20.538  1.00 18.51           C  
ATOM    339  CD2 LEU    56      14.279  13.842  22.594  1.00 24.21           C  
ATOM    340  N   ASN    57      19.208  12.243  24.651  1.00 16.18           N  
ATOM    341  CA  ASN    57      19.983  11.196  25.321  1.00 15.31           C  
ATOM    342  C   ASN    57      20.077  11.415  26.823  1.00 21.90           C  
ATOM    343  O   ASN    57      20.399  10.493  27.563  1.00 25.60           O  
ATOM    344  CB  ASN    57      21.370  11.128  24.689  1.00 17.13           C  
ATOM    345  CG  ASN    57      22.121   9.851  25.011  1.00 20.72           C  
ATOM    346  OD1 ASN    57      23.343   9.875  25.184  1.00 24.28           O  
ATOM    347  ND2 ASN    57      21.411   8.736  25.084  1.00 17.68           N  
ATOM    348  N   SER    58      19.746  12.635  27.241  1.00 20.84           N  
ATOM    349  CA  SER    58      19.785  13.036  28.646  0.50 22.94           C  
ATOM    351  C   SER    58      18.504  12.628  29.365  1.00 23.93           C  
ATOM    352  O   SER    58      18.425  12.706  30.598  1.00 27.24           O  
ATOM    353  CB  SER    58      20.006  14.557  28.772  0.50 25.02           C  
ATOM    355  OG  SER    58      18.881  15.303  28.321  0.50 21.84           O  
ATOM    357  N   LEU    59      17.512  12.169  28.595  1.00 15.23           N  
ATOM    358  CA  LEU    59      16.141  12.000  29.080  1.00 14.65           C  
ATOM    359  C   LEU    59      15.541  10.635  28.673  1.00 14.87           C  
ATOM    360  O   LEU    59      14.897   9.940  29.474  1.00 15.65           O  
ATOM    361  CB  LEU    59      15.324  13.132  28.429  1.00 25.84           C  
ATOM    362  CG  LEU    59      13.879  13.493  28.741  1.00 25.18           C  
ATOM    363  CD1 LEU    59      13.803  14.181  30.089  1.00 29.94           C  
ATOM    364  CD2 LEU    59      13.301  14.413  27.667  1.00 26.06           C  
ATOM    365  N   ALA    60      15.735  10.265  27.407  1.00 13.09           N  
ATOM    366  CA  ALA    60      15.152   9.037  26.874  1.00 13.19           C  
ATOM    367  C   ALA    60      15.880   7.798  27.391  1.00 12.67           C  
ATOM    368  O   ALA    60      17.097   7.835  27.650  1.00 12.83           O  
ATOM    369  CB  ALA    60      15.211   9.067  25.359  1.00 11.38           C  
ATOM    370  N   ARG    61      15.153   6.674  27.513  1.00 12.32           N  
ATOM    371  CA  ARG    61      15.834   5.402  27.814  1.00 11.46           C  
ATOM    372  C   ARG    61      16.487   4.775  26.579  1.00 10.52           C  
ATOM    373  O   ARG    61      17.451   4.018  26.691  1.00 13.25           O  
ATOM    374  CB  ARG    61      14.887   4.389  28.488  1.00 10.24           C  
ATOM    375  CG  ARG    61      13.912   3.659  27.577  1.00 13.10           C  
ATOM    376  CD  ARG    61      13.040   2.670  28.379  1.00 13.71           C  
ATOM    377  NE  ARG    61      12.274   1.828  27.468  1.00 12.52           N  
ATOM    378  CZ  ARG    61      11.148   2.200  26.863  1.00 10.75           C  
ATOM    379  NH1 ARG    61      10.592   3.392  27.102  1.00 11.33           N  
ATOM    380  NH2 ARG    61      10.528   1.359  26.026  1.00 12.41           N  
ATOM    381  N   LYS    62      15.955   5.090  25.394  1.00 10.76           N  
ATOM    382  CA  LYS    62      16.456   4.537  24.153  1.00 10.80           C  
ATOM    383  C   LYS    62      16.015   5.435  23.008  1.00 10.46           C  
ATOM    384  O   LYS    62      14.887   5.903  22.985  1.00 11.00           O  
ATOM    385  CB  LYS    62      15.908   3.128  23.926  1.00 11.68           C  
ATOM    386  CG  LYS    62      16.537   2.368  22.731  1.00 14.08           C  
ATOM    387  CD  LYS    62      18.069   2.338  22.718  1.00 15.23           C  
ATOM    388  CE  LYS    62      18.694   1.776  24.000  1.00 16.71           C  
ATOM    389  NZ  LYS    62      20.167   1.507  23.839  1.00 19.21           N  
ATOM    390  N   ILE    63      16.956   5.708  22.103  1.00 10.53           N  
ATOM    391  CA  ILE    63      16.669   6.490  20.903  1.00 10.94           C  
ATOM    392  C   ILE    63      17.062   5.657  19.694  1.00 10.88           C  
ATOM    393  O   ILE    63      18.155   5.100  19.632  1.00 11.23           O  
ATOM    394  CB  ILE    63      17.478   7.812  20.873  1.00 11.95           C  
ATOM    395  CG1 ILE    63      17.197   8.628  22.130  1.00 12.48           C  
ATOM    396  CG2 ILE    63      17.111   8.626  19.607  1.00 11.36           C  
ATOM    397  CD1 ILE    63      18.239   9.693  22.421  1.00 14.22           C  
ATOM    398  N   ILE    64      16.164   5.593  18.725  1.00 10.48           N  
ATOM    399  CA  ILE    64      16.486   5.060  17.412  1.00 10.88           C  
ATOM    400  C   ILE    64      16.486   6.269  16.504  1.00 10.93           C  
ATOM    401  O   ILE    64      15.419   6.864  16.260  1.00 11.03           O  
ATOM    402  CB  ILE    64      15.416   4.042  16.960  1.00 11.86           C  
ATOM    403  CG1 ILE    64      15.450   2.832  17.899  1.00 15.49           C  
ATOM    404  CG2 ILE    64      15.662   3.608  15.514  1.00 16.09           C  
ATOM    405  CD1 ILE    64      14.287   1.900  17.713  1.00 19.46           C  
ATOM    406  N   SER    65      17.668   6.635  16.021  1.00 10.83           N  
ATOM    407  CA  SER    65      17.876   7.846  15.224  1.00 10.05           C  
ATOM    408  C   SER    65      18.068   7.492  13.751  1.00 10.66           C  
ATOM    409  O   SER    65      18.777   6.522  13.452  1.00 12.61           O  
ATOM    410  CB  SER    65      19.134   8.568  15.720  1.00 10.73           C  
ATOM    411  OG  SER    65      18.920   9.202  16.979  1.00 13.77           O  
ATOM    412  N   ILE    66      17.450   8.258  12.851  1.00  9.40           N  
ATOM    413  CA  ILE    66      17.439   7.937  11.425  1.00 10.04           C  
ATOM    414  C   ILE    66      17.853   9.169  10.617  1.00 11.20           C  
ATOM    415  O   ILE    66      17.303  10.259  10.835  1.00 11.03           O  
ATOM    416  CB  ILE    66      16.023   7.511  10.961  1.00 10.72           C  
ATOM    417  CG1 ILE    66      15.571   6.266  11.760  1.00 13.63           C  
ATOM    418  CG2 ILE    66      16.044   7.193   9.456  1.00 15.71           C  
ATOM    419  CD1 ILE    66      14.091   5.931  11.698  1.00 16.82           C  
ATOM    420  N   ASP    67      18.776   9.007   9.672  1.00 11.18           N  
ATOM    421  CA  ASP    67      19.114  10.119   8.794  1.00 11.30           C  
ATOM    422  C   ASP    67      19.697   9.605   7.495  1.00 11.71           C  
ATOM    423  O   ASP    67      20.207   8.493   7.440  1.00 12.81           O  
ATOM    424  CB  ASP    67      20.142  11.041   9.475  1.00 13.14           C  
ATOM    425  CG  ASP    67      20.150  12.447   8.900  1.00 12.63           C  
ATOM    426  OD1 ASP    67      20.680  12.687   7.798  1.00 14.91           O  
ATOM    427  OD2 ASP    67      19.609  13.342   9.554  1.00 12.57           O  
ATOM    428  N   LEU    68      19.618  10.433   6.454  1.00 11.57           N  
ATOM    429  CA  LEU    68      20.321  10.139   5.195  1.00 12.52           C  
ATOM    430  C   LEU    68      21.838  10.180   5.347  1.00 15.17           C  
ATOM    431  O   LEU    68      22.553   9.453   4.634  1.00 16.52           O  
ATOM    432  CB  LEU    68      19.948  11.168   4.126  1.00 12.94           C  
ATOM    433  CG  LEU    68      18.525  11.192   3.601  1.00 13.40           C  
ATOM    434  CD1 LEU    68      18.271  12.492   2.840  1.00 16.72           C  
ATOM    435  CD2 LEU    68      18.308  10.018   2.701  1.00 16.24           C  
ATOM    436  N   GLN    69      22.310  11.046   6.234  1.00 14.15           N  
ATOM    437  CA  GLN    69      23.728  11.351   6.393  0.50 15.08           C  
ATOM    439  C   GLN    69      24.290  10.685   7.630  1.00 16.76           C  
ATOM    440  O   GLN    69      23.584  10.523   8.611  1.00 16.67           O  
ATOM    441  CB  GLN    69      23.913  12.867   6.539  0.50 14.48           C  
ATOM    443  CG  GLN    69      23.303  13.684   5.409  0.50 17.02           C  
ATOM    445  CD  GLN    69      23.454  15.188   5.597  0.50 21.02           C  
ATOM    447  OE1 GLN    69      24.102  15.855   4.791  0.50 26.25           O  
ATOM    449  NE2 GLN    69      22.855  15.728   6.661  0.50 23.75           N  
ATOM    451  N   GLU    70      25.572  10.325   7.596  1.00 18.94           N  
ATOM    452  CA  GLU    70      26.232   9.832   8.782  1.00 22.18           C  
ATOM    453  C   GLU    70      26.240  10.901   9.868  1.00 20.61           C  
ATOM    454  O   GLU    70      26.174  12.106   9.592  1.00 22.85           O  
ATOM    455  CB  GLU    70      27.677   9.422   8.457  1.00 28.88           C  
ATOM    456  CG  GLU    70      27.852   7.941   8.115  1.00 41.08           C  
ATOM    457  CD  GLU    70      27.435   7.003   9.249  1.00 47.85           C  
ATOM    458  OE1 GLU    70      26.837   5.947   8.953  1.00 44.50           O  
ATOM    459  OE2 GLU    70      27.701   7.316  10.433  1.00 53.10           O  
ATOM    460  N   MET    71      26.268  10.446  11.111  1.00 22.46           N  
ATOM    461  CA  MET    71      26.587  11.326  12.213  1.00 25.42           C  
ATOM    462  C   MET    71      27.448  10.554  13.197  1.00 23.59           C  
ATOM    463  O   MET    71      27.522   9.316  13.134  1.00 26.19           O  
ATOM    464  CB  MET    71      25.322  11.862  12.878  1.00 23.96           C  
ATOM    465  CG  MET    71      24.476  10.818  13.500  1.00 17.30           C  
ATOM    466  SD  MET    71      23.049  11.579  14.604  0.70 26.40          SE  
ATOM    467  CE  MET    71      22.642   9.910  15.033  1.00 10.60           C  
ATOM    468  N   GLU    72      28.096  11.285  14.094  1.00 26.79           N  
ATOM    469  CA  GLU    72      28.953  10.671  15.095  1.00 33.65           C  
ATOM    470  C   GLU    72      28.145   9.796  16.045  1.00 30.46           C  
ATOM    471  O   GLU    72      26.991  10.116  16.373  1.00 25.47           O  
ATOM    472  CB  GLU    72      29.745  11.727  15.868  1.00 37.99           C  
ATOM    473  CG  GLU    72      31.107  12.025  15.258  1.00 50.28           C  
ATOM    474  CD  GLU    72      32.059  12.668  16.247  1.00 59.79           C  
ATOM    475  OE1 GLU    72      32.889  11.938  16.833  1.00 58.00           O  
ATOM    476  OE2 GLU    72      31.968  13.900  16.446  1.00 64.90           O  
ATOM    477  N   GLU    73      28.759   8.679  16.436  1.00 31.06           N  
ATOM    478  CA  GLU    73      28.176   7.737  17.389  1.00 33.36           C  
ATOM    479  C   GLU    73      27.967   8.371  18.761  1.00 28.63           C  
ATOM    480  O   GLU    73      28.727   9.226  19.207  1.00 23.68           O  
ATOM    481  CB  GLU    73      29.018   6.449  17.491  1.00 36.66           C  
ATOM    482  CG  GLU    73      30.441   6.610  18.065  1.00 54.51           C  
ATOM    483  CD  GLU    73      31.506   7.002  17.029  1.00 65.94           C  
ATOM    484  OE1 GLU    73      31.163   7.273  15.854  1.00 68.44           O  
ATOM    485  OE2 GLU    73      32.701   7.039  17.403  1.00 69.26           O  
ATOM    486  N   ILE    74      26.872   7.991  19.401  1.00 22.88           N  
ATOM    487  CA  ILE    74      26.562   8.449  20.743  1.00 19.83           C  
ATOM    488  C   ILE    74      26.268   7.153  21.468  1.00 21.56           C  
ATOM    489  O   ILE    74      25.559   6.292  20.937  1.00 20.26           O  
ATOM    490  CB  ILE    74      25.373   9.459  20.768  1.00 18.50           C  
ATOM    491  CG1 ILE    74      25.750  10.731  20.004  1.00 19.31           C  
ATOM    492  CG2 ILE    74      25.007   9.835  22.203  1.00 19.70           C  
ATOM    493  CD1 ILE    74      24.565  11.626  19.648  1.00 16.30           C  
ATOM    494  N   ALA    75      26.864   6.985  22.648  1.00 20.90           N  
ATOM    495  CA  ALA    75      26.737   5.721  23.362  1.00 24.22           C  
ATOM    496  C   ALA    75      25.269   5.387  23.594  1.00 16.89           C  
ATOM    497  O   ALA    75      24.505   6.211  24.078  1.00 19.33           O  
ATOM    498  CB  ALA    75      27.493   5.779  24.688  1.00 24.81           C  
ATOM    499  N   GLY    76      24.889   4.172  23.202  1.00 19.08           N  
ATOM    500  CA  GLY    76      23.548   3.677  23.464  1.00 17.20           C  
ATOM    501  C   GLY    76      22.463   4.103  22.491  1.00 15.30           C  
ATOM    502  O   GLY    76      21.329   3.646  22.609  1.00 15.69           O  
ATOM    503  N   VAL    77      22.806   4.973  21.542  1.00 14.31           N  
ATOM    504  CA  VAL    77      21.842   5.431  20.531  1.00 13.17           C  
ATOM    505  C   VAL    77      21.950   4.492  19.341  1.00 13.37           C  
ATOM    506  O   VAL    77      23.080   4.158  18.899  1.00 15.18           O  
ATOM    507  CB  VAL    77      22.116   6.883  20.066  1.00 12.43           C  
ATOM    508  CG1 VAL    77      21.270   7.236  18.841  1.00 12.61           C  
ATOM    509  CG2 VAL    77      21.880   7.889  21.205  1.00 14.75           C  
ATOM    510  N   ARG    78      20.800   4.033  18.840  1.00 11.93           N  
ATOM    511  CA  ARG    78      20.811   3.143  17.711  1.00 12.60           C  
ATOM    512  C   ARG    78      20.600   3.982  16.467  1.00 14.57           C  
ATOM    513  O   ARG    78      19.518   4.500  16.242  1.00 15.17           O  
ATOM    514  CB  ARG    78      19.687   2.130  17.870  1.00 13.99           C  
ATOM    515  CG  ARG    78      19.597   1.139  16.749  1.00 22.12           C  
ATOM    516  CD  ARG    78      18.604   0.066  17.103  1.00 33.92           C  
ATOM    517  NE  ARG    78      19.095  -0.893  18.091  1.00 36.42           N  
ATOM    518  CZ  ARG    78      19.566  -2.102  17.801  1.00 40.20           C  
ATOM    519  NH1 ARG    78      19.627  -2.522  16.538  1.00 33.04           N  
ATOM    520  NH2 ARG    78      19.979  -2.893  18.783  1.00 34.30           N  
ATOM    521  N   PHE    79      21.639   4.139  15.673  1.00 12.80           N  
ATOM    522  CA  PHE    79      21.557   4.970  14.492  1.00 12.11           C  
ATOM    523  C   PHE    79      21.322   4.109  13.255  1.00 15.59           C  
ATOM    524  O   PHE    79      21.970   3.080  13.073  1.00 18.23           O  
ATOM    525  CB  PHE    79      22.824   5.823  14.349  1.00 13.66           C  
ATOM    526  CG  PHE    79      22.852   6.660  13.095  1.00 13.92           C  
ATOM    527  CD1 PHE    79      21.877   7.611  12.857  1.00 14.07           C  
ATOM    528  CD2 PHE    79      23.848   6.472  12.138  1.00 16.12           C  
ATOM    529  CE1 PHE    79      21.892   8.377  11.684  1.00 14.81           C  
ATOM    530  CE2 PHE    79      23.858   7.213  10.961  1.00 19.04           C  
ATOM    531  CZ  PHE    79      22.879   8.168  10.732  1.00 18.26           C  
ATOM    532  N   ILE    80      20.403   4.548  12.398  1.00 13.67           N  
ATOM    533  CA  ILE    80      20.103   3.867  11.146  1.00 14.45           C  
ATOM    534  C   ILE    80      20.258   4.895  10.030  1.00 14.03           C  
ATOM    535  O   ILE    80      19.560   5.907  10.008  1.00 13.61           O  
ATOM    536  CB  ILE    80      18.662   3.349  11.105  1.00 13.42           C  
ATOM    537  CG1 ILE    80      18.360   2.431  12.311  1.00 16.58           C  
ATOM    538  CG2 ILE    80      18.406   2.615   9.777  1.00 18.22           C  
ATOM    539  CD1 ILE    80      16.914   2.000  12.421  1.00 19.95           C  
ATOM    540  N   ARG    81      21.150   4.631   9.083  1.00 13.88           N  
ATOM    541  CA  ARG    81      21.227   5.441   7.874  1.00 13.30           C  
ATOM    542  C   ARG    81      20.158   4.928   6.915  1.00 15.06           C  
ATOM    543  O   ARG    81      20.173   3.759   6.520  1.00 13.56           O  
ATOM    544  CB  ARG    81      22.615   5.338   7.223  1.00 16.75           C  
ATOM    545  CG  ARG    81      23.450   6.594   7.390  1.00 33.80           C  
ATOM    546  CD  ARG    81      24.652   6.576   6.480  1.00 32.17           C  
ATOM    547  NE  ARG    81      24.561   7.513   5.368  1.00 23.99           N  
ATOM    548  CZ  ARG    81      25.551   7.722   4.507  1.00 24.73           C  
ATOM    549  NH1 ARG    81      26.692   7.059   4.649  1.00 32.42           N  
ATOM    550  NH2 ARG    81      25.417   8.590   3.517  1.00 33.32           N  
ATOM    551  N   CYS    82      19.225   5.793   6.535  1.00 12.53           N  
ATOM    552  CA  CYS    82      18.074   5.359   5.777  1.00 13.00           C  
ATOM    553  C   CYS    82      17.358   6.563   5.184  1.00 13.41           C  
ATOM    554  O   CYS    82      17.306   7.620   5.834  1.00 14.05           O  
ATOM    555  CB  CYS    82      17.112   4.609   6.690  1.00 14.25           C  
ATOM    556  SG  CYS    82      15.720   3.923   5.762  1.00 19.53           S  
ATOM    557  N   ASP    83      16.812   6.411   3.971  1.00 11.70           N  
ATOM    558  CA  ASP    83      15.918   7.424   3.426  1.00 13.14           C  
ATOM    559  C   ASP    83      14.520   6.983   3.823  1.00 12.87           C  
ATOM    560  O   ASP    83      14.055   5.923   3.397  1.00 13.51           O  
ATOM    561  CB  ASP    83      16.049   7.465   1.892  1.00 11.45           C  
ATOM    562  CG  ASP    83      15.148   8.506   1.230  1.00 15.18           C  
ATOM    563  OD1 ASP    83      14.130   8.930   1.810  1.00 14.62           O  
ATOM    564  OD2 ASP    83      15.471   8.904   0.089  1.00 18.70           O  
ATOM    565  N   ILE    84      13.815   7.793   4.614  1.00 12.08           N  
ATOM    566  CA  ILE    84      12.487   7.374   5.080  1.00 10.97           C  
ATOM    567  C   ILE    84      11.473   7.126   3.959  1.00 13.47           C  
ATOM    568  O   ILE    84      10.482   6.462   4.189  1.00 13.31           O  
ATOM    569  CB  ILE    84      11.885   8.365   6.121  1.00 13.38           C  
ATOM    570  CG1 ILE    84      11.602   9.759   5.495  1.00 12.86           C  
ATOM    571  CG2 ILE    84      12.798   8.462   7.361  1.00 13.54           C  
ATOM    572  CD1 ILE    84      10.751  10.702   6.380  1.00 14.69           C  
ATOM    573  N   PHE    85      11.714   7.676   2.777  1.00 13.02           N  
ATOM    574  CA  PHE    85      10.765   7.515   1.662  1.00 12.85           C  
ATOM    575  C   PHE    85      10.973   6.201   0.908  1.00 15.25           C  
ATOM    576  O   PHE    85      10.124   5.806   0.095  1.00 17.25           O  
ATOM    577  CB  PHE    85      10.912   8.669   0.671  1.00 12.29           C  
ATOM    578  CG  PHE    85      10.433   9.989   1.201  1.00 11.32           C  
ATOM    579  CD1 PHE    85       9.089  10.185   1.493  1.00 12.76           C  
ATOM    580  CD2 PHE    85      11.325  11.028   1.391  1.00 11.72           C  
ATOM    581  CE1 PHE    85       8.653  11.410   1.982  1.00 15.78           C  
ATOM    582  CE2 PHE    85      10.888  12.257   1.881  1.00 14.28           C  
ATOM    583  CZ  PHE    85       9.542  12.440   2.161  1.00 16.43           C  
ATOM    584  N   LYS    86      12.090   5.521   1.161  1.00 15.12           N  
ATOM    585  CA  LYS    86      12.431   4.349   0.368  1.00 15.16           C  
ATOM    586  C   LYS    86      11.876   3.069   1.009  1.00 15.80           C  
ATOM    587  O   LYS    86      11.010   3.133   1.883  1.00 17.52           O  
ATOM    588  CB  LYS    86      13.945   4.285   0.104  1.00 15.21           C  
ATOM    589  CG  LYS    86      14.498   5.434  -0.749  1.00 18.74           C  
ATOM    590  CD  LYS    86      13.847   5.550  -2.129  1.00 25.60           C  
ATOM    591  CE  LYS    86      14.376   6.798  -2.845  1.00 30.31           C  
ATOM    592  NZ  LYS    86      13.560   7.154  -4.039  1.00 39.14           N  
ATOM    593  N   GLU    87      12.352   1.907   0.555  1.00 14.35           N  
ATOM    594  CA  GLU    87      11.668   0.641   0.825  1.00 18.83           C  
ATOM    595  C   GLU    87      12.058  -0.083   2.092  1.00 16.10           C  
ATOM    596  O   GLU    87      11.344  -1.014   2.497  1.00 18.86           O  
ATOM    597  CB  GLU    87      11.829  -0.343  -0.352  1.00 16.40           C  
ATOM    598  CG  GLU    87      11.473   0.263  -1.727  1.00 24.26           C  
ATOM    599  CD  GLU    87      11.768  -0.673  -2.915  1.00 32.24           C  
ATOM    600  OE1 GLU    87      12.880  -1.247  -3.018  1.00 22.27           O  
ATOM    601  OE2 GLU    87      10.871  -0.822  -3.769  1.00 38.54           O  
ATOM    602  N   THR    88      13.181   0.284   2.702  1.00 14.31           N  
ATOM    603  CA  THR    88      13.659  -0.478   3.865  1.00 12.35           C  
ATOM    604  C   THR    88      13.197   0.081   5.223  1.00 14.22           C  
ATOM    605  O   THR    88      13.419  -0.547   6.228  1.00 14.68           O  
ATOM    606  CB  THR    88      15.204  -0.564   3.925  1.00 13.50           C  
ATOM    607  OG1 THR    88      15.751   0.750   4.057  1.00 14.98           O  
ATOM    608  CG2 THR    88      15.779  -1.252   2.680  1.00 16.24           C  
ATOM    609  N   ILE    89      12.594   1.267   5.235  1.00 12.41           N  
ATOM    610  CA  ILE    89      12.386   2.013   6.486  1.00 11.93           C  
ATOM    611  C   ILE    89      11.652   1.215   7.561  1.00 13.83           C  
ATOM    612  O   ILE    89      12.071   1.204   8.727  1.00 13.99           O  
ATOM    613  CB  ILE    89      11.719   3.394   6.209  1.00 14.69           C  
ATOM    614  CG1 ILE    89      11.573   4.220   7.504  1.00 12.66           C  
ATOM    615  CG2 ILE    89      10.379   3.264   5.465  1.00 15.13           C  
ATOM    616  CD1 ILE    89      12.869   4.423   8.248  1.00 14.32           C  
ATOM    617  N   PHE    90      10.607   0.498   7.154  1.00 14.71           N  
ATOM    618  CA  PHE    90       9.821  -0.247   8.141  1.00 14.60           C  
ATOM    619  C   PHE    90      10.538  -1.480   8.612  1.00 16.51           C  
ATOM    620  O   PHE    90      10.508  -1.789   9.792  1.00 16.36           O  
ATOM    621  CB  PHE    90       8.431  -0.572   7.621  1.00 14.85           C  
ATOM    622  CG  PHE    90       7.667   0.634   7.185  1.00 15.88           C  
ATOM    623  CD1 PHE    90       7.239   1.592   8.107  1.00 17.54           C  
ATOM    624  CD2 PHE    90       7.402   0.845   5.835  1.00 19.99           C  
ATOM    625  CE1 PHE    90       6.530   2.729   7.673  1.00 20.12           C  
ATOM    626  CE2 PHE    90       6.701   1.964   5.402  1.00 24.98           C  
ATOM    627  CZ  PHE    90       6.264   2.908   6.314  1.00 18.82           C  
ATOM    628  N   ASP    91      11.219  -2.166   7.698  1.00 13.68           N  
ATOM    629  CA  ASP    91      12.028  -3.312   8.096  1.00 13.68           C  
ATOM    630  C   ASP    91      13.162  -2.919   9.047  1.00 14.80           C  
ATOM    631  O   ASP    91      13.516  -3.670   9.977  1.00 16.34           O  
ATOM    632  CB  ASP    91      12.633  -3.997   6.862  1.00 17.52           C  
ATOM    633  CG  ASP    91      11.588  -4.694   5.996  1.00 24.50           C  
ATOM    634  OD1 ASP    91      10.492  -5.018   6.497  1.00 21.30           O  
ATOM    635  OD2 ASP    91      11.869  -4.923   4.799  1.00 25.94           O  
ATOM    636  N   ASP    92      13.744  -1.741   8.792  1.00 13.74           N  
ATOM    637  CA  ASP    92      14.841  -1.220   9.576  1.00 12.72           C  
ATOM    638  C   ASP    92      14.374  -0.880  10.980  1.00 13.13           C  
ATOM    639  O   ASP    92      15.044  -1.216  11.962  1.00 14.01           O  
ATOM    640  CB  ASP    92      15.394   0.057   8.928  1.00 13.56           C  
ATOM    641  CG  ASP    92      16.180  -0.193   7.654  1.00 17.23           C  
ATOM    642  OD1 ASP    92      16.647  -1.335   7.426  1.00 16.56           O  
ATOM    643  OD2 ASP    92      16.330   0.788   6.886  1.00 16.08           O  
ATOM    644  N   ILE    93      13.230  -0.204  11.067  1.00 12.18           N  
ATOM    645  CA  ILE    93      12.724   0.159  12.399  1.00 14.15           C  
ATOM    646  C   ILE    93      12.235  -1.093  13.129  1.00 17.32           C  
ATOM    647  O   ILE    93      12.549  -1.268  14.324  1.00 15.16           O  
ATOM    648  CB  ILE    93      11.617   1.219  12.327  1.00 13.03           C  
ATOM    649  CG1 ILE    93      12.191   2.564  11.848  1.00 12.61           C  
ATOM    650  CG2 ILE    93      11.000   1.412  13.719  1.00 14.05           C  
ATOM    651  CD1 ILE    93      11.121   3.600  11.455  1.00 12.35           C  
ATOM    652  N   ASP    94      11.502  -1.963  12.419  1.00 14.05           N  
ATOM    653  CA  ASP    94      11.083  -3.250  13.017  1.00 16.18           C  
ATOM    654  C   ASP    94      12.256  -3.979  13.665  1.00 15.42           C  
ATOM    655  O   ASP    94      12.155  -4.422  14.814  1.00 17.28           O  
ATOM    656  CB  ASP    94      10.513  -4.217  11.974  1.00 17.07           C  
ATOM    657  CG  ASP    94       9.121  -3.855  11.489  1.00 17.35           C  
ATOM    658  OD1 ASP    94       8.505  -2.885  11.987  1.00 18.27           O  
ATOM    659  OD2 ASP    94       8.633  -4.548  10.555  1.00 21.85           O  
ATOM    660  N   ARG    95      13.367  -4.122  12.932  1.00 15.58           N  
ATOM    661  CA  ARG    95      14.535  -4.842  13.428  1.00 16.07           C  
ATOM    662  C   ARG    95      15.118  -4.171  14.663  1.00 19.11           C  
ATOM    663  O   ARG    95      15.440  -4.833  15.641  1.00 18.91           O  
ATOM    664  CB  ARG    95      15.615  -4.981  12.348  1.00 20.99           C  
ATOM    665  CG  ARG    95      16.734  -5.950  12.716  1.00 29.41           C  
ATOM    666  CD  ARG    95      17.846  -6.022  11.666  1.00 35.92           C  
ATOM    667  NE  ARG    95      19.041  -5.272  12.063  1.00 53.69           N  
ATOM    668  CZ  ARG    95      20.279  -5.526  11.631  1.00 57.40           C  
ATOM    669  NH1 ARG    95      20.511  -6.528  10.781  1.00 50.29           N  
ATOM    670  NH2 ARG    95      21.295  -4.777  12.056  1.00 50.88           N  
ATOM    671  N   ALA    96      15.224  -2.839  14.627  1.00 15.34           N  
ATOM    672  CA  ALA    96      15.780  -2.102  15.748  1.00 15.93           C  
ATOM    673  C   ALA    96      14.919  -2.271  17.000  1.00 16.84           C  
ATOM    674  O   ALA    96      15.439  -2.511  18.081  1.00 17.65           O  
ATOM    675  CB  ALA    96      15.873  -0.633  15.370  1.00 16.45           C  
ATOM    676  N   LEU    97      13.605  -2.139  16.847  1.00 15.40           N  
ATOM    677  CA  LEU    97      12.680  -2.321  17.994  1.00 13.08           C  
ATOM    678  C   LEU    97      12.750  -3.730  18.579  1.00 16.91           C  
ATOM    679  O   LEU    97      12.794  -3.905  19.802  1.00 16.10           O  
ATOM    680  CB  LEU    97      11.253  -1.987  17.596  1.00 13.95           C  
ATOM    681  CG  LEU    97      11.014  -0.503  17.284  1.00 15.23           C  
ATOM    682  CD1 LEU    97       9.596  -0.311  16.828  1.00 17.81           C  
ATOM    683  CD2 LEU    97      11.298   0.351  18.487  1.00 16.90           C  
ATOM    684  N   ARG    98      12.784  -4.716  17.691  1.00 19.05           N  
ATOM    685  CA  ARG    98      12.877  -6.131  18.092  1.00 20.68           C  
ATOM    686  C   ARG    98      14.131  -6.358  18.933  1.00 20.56           C  
ATOM    687  O   ARG    98      14.065  -6.934  20.021  1.00 20.37           O  
ATOM    688  CB  ARG    98      12.881  -7.022  16.843  1.00 19.15           C  
ATOM    689  CG  ARG    98      12.874  -8.519  17.105  1.00 36.63           C  
ATOM    690  CD  ARG    98      12.535  -9.327  15.828  1.00 35.92           C  
ATOM    691  NE  ARG    98      13.244  -8.889  14.616  1.00 42.00           N  
ATOM    692  CZ  ARG    98      12.657  -8.384  13.527  1.00 49.87           C  
ATOM    693  NH1 ARG    98      11.336  -8.239  13.470  1.00 49.31           N  
ATOM    694  NH2 ARG    98      13.394  -8.022  12.482  1.00 44.13           N  
ATOM    695  N   GLU    99      15.250  -5.823  18.468  1.00 16.76           N  
ATOM    696  CA  GLU    99      16.506  -5.965  19.184  1.00 18.98           C  
ATOM    697  C   GLU    99      16.523  -5.234  20.527  1.00 21.82           C  
ATOM    698  O   GLU    99      17.222  -5.656  21.456  1.00 22.66           O  
ATOM    699  CB  GLU    99      17.666  -5.544  18.293  1.00 20.90           C  
ATOM    700  CG  GLU    99      17.841  -6.543  17.134  1.00 26.92           C  
ATOM    701  CD  GLU    99      18.967  -6.203  16.182  1.00 37.81           C  
ATOM    702  OE1 GLU    99      19.767  -5.310  16.503  1.00 37.69           O  
ATOM    703  OE2 GLU    99      19.052  -6.841  15.109  1.00 39.69           O  
ATOM    704  N   GLU   100      15.730  -4.167  20.641  1.00 17.11           N  
ATOM    705  CA  GLU   100      15.619  -3.454  21.902  1.00 17.75           C  
ATOM    706  C   GLU   100      14.556  -4.001  22.837  1.00 16.86           C  
ATOM    707  O   GLU   100      14.469  -3.550  23.983  1.00 20.47           O  
ATOM    708  CB  GLU   100      15.371  -1.964  21.640  1.00 18.83           C  
ATOM    709  CG  GLU   100      16.493  -1.253  20.883  1.00 18.10           C  
ATOM    710  CD  GLU   100      17.824  -1.244  21.638  1.00 31.26           C  
ATOM    711  OE1 GLU   100      17.809  -1.279  22.895  1.00 24.65           O  
ATOM    712  OE2 GLU   100      18.883  -1.200  20.968  1.00 30.33           O  
ATOM    713  N   GLY   101      13.760  -4.962  22.366  1.00 15.44           N  
ATOM    714  CA  GLY   101      12.667  -5.499  23.175  1.00 15.63           C  
ATOM    715  C   GLY   101      11.522  -4.517  23.332  1.00 15.58           C  
ATOM    716  O   GLY   101      10.802  -4.537  24.330  1.00 18.18           O  
ATOM    717  N   ILE   102      11.326  -3.662  22.335  1.00 14.55           N  
ATOM    718  CA  ILE   102      10.278  -2.661  22.376  1.00 12.71           C  
ATOM    719  C   ILE   102       9.208  -3.041  21.358  1.00 15.93           C  
ATOM    720  O   ILE   102       9.564  -3.350  20.214  1.00 16.82           O  
ATOM    721  CB  ILE   102      10.837  -1.270  22.004  1.00 13.71           C  
ATOM    722  CG1 ILE   102      11.898  -0.824  23.021  1.00 15.46           C  
ATOM    723  CG2 ILE   102       9.698  -0.240  21.874  1.00 13.97           C  
ATOM    724  CD1 ILE   102      12.686   0.444  22.609  1.00 13.84           C  
ATOM    725  N   GLU   103       7.930  -3.051  21.762  1.00 14.80           N  
ATOM    726  CA  GLU   103       6.819  -3.287  20.834  1.00 14.37           C  
ATOM    727  C   GLU   103       6.346  -1.975  20.207  1.00 16.25           C  
ATOM    728  O   GLU   103       6.170  -1.894  18.980  1.00 16.50           O  
ATOM    729  CB  GLU   103       5.666  -4.007  21.536  1.00 14.59           C  
ATOM    730  CG  GLU   103       4.478  -4.362  20.618  1.00 23.31           C  
ATOM    731  CD  GLU   103       4.731  -5.541  19.690  1.00 38.88           C  
ATOM    732  OE1 GLU   103       5.747  -6.263  19.848  1.00 40.58           O  
ATOM    733  OE2 GLU   103       3.890  -5.744  18.787  1.00 44.02           O  
ATOM    734  N   LYS   104       6.144  -0.967  21.058  1.00 11.97           N  
ATOM    735  CA  LYS   104       5.641   0.354  20.654  1.00 12.65           C  
ATOM    736  C   LYS   104       6.441   1.416  21.368  1.00 12.46           C  
ATOM    737  O   LYS   104       6.720   1.289  22.552  1.00 12.40           O  
ATOM    738  CB  LYS   104       4.160   0.551  20.980  1.00 14.66           C  
ATOM    739  CG  LYS   104       3.184  -0.415  20.278  1.00 15.66           C  
ATOM    740  CD  LYS   104       3.093  -0.147  18.783  1.00 17.92           C  
ATOM    741  CE  LYS   104       1.964  -0.991  18.176  1.00 18.93           C  
ATOM    742  NZ  LYS   104       1.927  -0.784  16.721  1.00 22.15           N  
ATOM    743  N   VAL   105       6.847   2.455  20.631  1.00 12.16           N  
ATOM    744  CA  VAL   105       7.670   3.513  21.208  1.00 10.51           C  
ATOM    745  C   VAL   105       6.772   4.544  21.856  1.00  9.96           C  
ATOM    746  O   VAL   105       5.568   4.609  21.587  1.00 12.50           O  
ATOM    747  CB  VAL   105       8.559   4.211  20.136  1.00 11.01           C  
ATOM    748  CG1 VAL   105       9.606   3.235  19.613  1.00 13.10           C  
ATOM    749  CG2 VAL   105       7.688   4.808  19.026  1.00 12.29           C  
ATOM    750  N   ASP   106       7.380   5.387  22.687  1.00 11.09           N  
ATOM    751  CA  ASP   106       6.613   6.395  23.402  1.00  9.99           C  
ATOM    752  C   ASP   106       6.445   7.655  22.573  1.00 12.17           C  
ATOM    753  O   ASP   106       5.420   8.311  22.669  1.00 12.24           O  
ATOM    754  CB  ASP   106       7.297   6.743  24.721  1.00 11.76           C  
ATOM    755  CG  ASP   106       7.472   5.526  25.608  1.00 10.29           C  
ATOM    756  OD1 ASP   106       6.536   5.239  26.395  1.00 14.19           O  
ATOM    757  OD2 ASP   106       8.523   4.866  25.562  1.00 10.87           O  
ATOM    758  N   ASP   107       7.462   8.022  21.776  1.00 10.50           N  
ATOM    759  CA  ASP   107       7.385   9.240  20.937  1.00 11.36           C  
ATOM    760  C   ASP   107       8.046   9.027  19.596  1.00  9.58           C  
ATOM    761  O   ASP   107       8.985   8.248  19.481  1.00 10.07           O  
ATOM    762  CB  ASP   107       8.101  10.413  21.595  1.00 11.91           C  
ATOM    763  CG  ASP   107       7.779  10.538  23.051  1.00 11.98           C  
ATOM    764  OD1 ASP   107       6.625  10.852  23.399  1.00 15.21           O  
ATOM    765  OD2 ASP   107       8.690  10.276  23.851  1.00 13.81           O  
ATOM    766  N   VAL   108       7.560   9.755  18.589  1.00  9.74           N  
ATOM    767  CA  VAL   108       8.268   9.888  17.329  1.00  8.61           C  
ATOM    768  C   VAL   108       8.518  11.387  17.167  1.00 11.05           C  
ATOM    769  O   VAL   108       7.583  12.208  17.282  1.00 11.94           O  
ATOM    770  CB  VAL   108       7.426   9.325  16.155  1.00 11.46           C  
ATOM    771  CG1 VAL   108       8.110   9.616  14.804  1.00 14.09           C  
ATOM    772  CG2 VAL   108       7.177   7.803  16.292  1.00 14.03           C  
ATOM    773  N   VAL   109       9.778  11.775  16.978  1.00  9.92           N  
ATOM    774  CA  VAL   109      10.097  13.186  16.779  1.00 11.54           C  
ATOM    775  C   VAL   109      10.829  13.345  15.470  1.00 10.98           C  
ATOM    776  O   VAL   109      11.574  12.456  15.072  1.00 12.56           O  
ATOM    777  CB  VAL   109      10.912  13.788  17.938  1.00 11.55           C  
ATOM    778  CG1 VAL   109      10.234  13.524  19.285  1.00 14.62           C  
ATOM    779  CG2 VAL   109      12.324  13.234  17.963  1.00 13.66           C  
ATOM    780  N   SER   110      10.605  14.469  14.782  1.00  9.10           N  
ATOM    781  CA  SER   110      11.280  14.712  13.524  1.00  9.63           C  
ATOM    782  C   SER   110      11.697  16.168  13.394  1.00  9.21           C  
ATOM    783  O   SER   110      10.871  17.076  13.572  1.00 10.64           O  
ATOM    784  CB  SER   110      10.339  14.386  12.377  1.00 11.38           C  
ATOM    785  OG  SER   110      10.906  14.752  11.108  1.00 12.49           O  
ATOM    786  N   ASP   111      12.975  16.367  13.054  1.00  9.78           N  
ATOM    787  CA  ASP   111      13.502  17.661  12.628  1.00 10.30           C  
ATOM    788  C   ASP   111      13.948  17.541  11.174  1.00 12.59           C  
ATOM    789  O   ASP   111      14.731  18.370  10.700  1.00 14.21           O  
ATOM    790  CB  ASP   111      14.678  18.042  13.517  1.00 12.34           C  
ATOM    791  CG  ASP   111      14.999  19.521  13.476  1.00 17.14           C  
ATOM    792  OD1 ASP   111      14.082  20.342  13.247  1.00 16.72           O  
ATOM    793  OD2 ASP   111      16.181  19.859  13.708  1.00 19.06           O  
ATOM    794  N   ALA   112      13.454  16.527  10.465  1.00 11.25           N  
ATOM    795  CA  ALA   112      13.892  16.275   9.078  1.00 11.10           C  
ATOM    796  C   ALA   112      13.422  17.377   8.141  1.00 13.86           C  
ATOM    797  O   ALA   112      12.283  17.843   8.214  1.00 13.37           O  
ATOM    798  CB  ALA   112      13.363  14.945   8.591  1.00 11.26           C  
ATOM    799  N   MET   113      14.327  17.730   7.238  1.00 13.40           N  
ATOM    800  CA  MET   113      14.080  18.704   6.191  1.00 13.40           C  
ATOM    801  C   MET   113      15.114  18.498   5.091  1.00 13.11           C  
ATOM    802  O   MET   113      16.267  18.145   5.370  1.00 13.85           O  
ATOM    803  CB  MET   113      14.123  20.131   6.730  1.00 14.46           C  
ATOM    804  CG  MET   113      13.833  21.222   5.677  1.00 13.23           C  
ATOM    805  SD  MET   113      12.116  20.916   4.727  0.70 15.43          SE  
ATOM    806  CE  MET   113      12.287  22.453   3.505  1.00 17.59           C  
ATOM    807  N   ALA   114      14.695  18.720   3.846  1.00 13.67           N  
ATOM    808  CA  ALA   114      15.638  18.631   2.739  1.00 16.40           C  
ATOM    809  C   ALA   114      16.282  19.987   2.529  1.00 15.41           C  
ATOM    810  O   ALA   114      16.163  20.856   3.367  1.00 14.70           O  
ATOM    811  CB  ALA   114      14.941  18.156   1.487  1.00 21.46           C  
ATOM    812  N   LYS   115      16.985  20.170   1.419  1.00 15.14           N  
ATOM    813  CA  LYS   115      17.557  21.487   1.150  1.00 15.78           C  
ATOM    814  C   LYS   115      16.471  22.577   1.046  1.00 13.07           C  
ATOM    815  O   LYS   115      15.398  22.359   0.466  1.00 14.83           O  
ATOM    816  CB  LYS   115      18.384  21.466  -0.133  1.00 17.66           C  
ATOM    817  CG  LYS   115      19.659  20.652  -0.013  1.00 20.06           C  
ATOM    818  CD  LYS   115      20.393  20.629  -1.344  1.00 19.58           C  
ATOM    819  CE  LYS   115      21.714  19.898  -1.250  1.00 29.22           C  
ATOM    820  NZ  LYS   115      22.368  19.836  -2.592  1.00 33.84           N  
ATOM    821  N   VAL   116      16.777  23.723   1.653  1.00 13.59           N  
ATOM    822  CA  VAL   116      15.891  24.882   1.767  0.50 13.96           C  
ATOM    824  C   VAL   116      16.070  25.782   0.530  1.00 15.19           C  
ATOM    825  O   VAL   116      17.210  26.085   0.148  1.00 14.70           O  
ATOM    826  CB  VAL   116      16.231  25.658   3.074  0.50 14.92           C  
ATOM    828  CG1 VAL   116      15.448  26.948   3.196  0.50 15.69           C  
ATOM    830  CG2 VAL   116      15.990  24.771   4.328  0.50 17.33           C  
ATOM    832  N   SER   117      14.963  26.201  -0.072  1.00 13.54           N  
ATOM    833  CA  SER   117      15.001  27.069  -1.247  1.00 11.53           C  
ATOM    834  C   SER   117      14.856  28.544  -0.888  1.00 13.31           C  
ATOM    835  O   SER   117      15.171  29.404  -1.713  1.00 15.65           O  
ATOM    836  CB  SER   117      13.865  26.696  -2.189  1.00 13.27           C  
ATOM    837  OG  SER   117      12.606  27.050  -1.610  1.00 13.68           O  
ATOM    838  N   GLY   118      14.357  28.833   0.316  1.00 13.72           N  
ATOM    839  CA  GLY   118      14.073  30.198   0.724  1.00 17.52           C  
ATOM    840  C   GLY   118      12.734  30.709   0.218  1.00 15.20           C  
ATOM    841  O   GLY   118      12.437  31.912   0.363  1.00 18.36           O  
ATOM    842  N   ILE   119      11.923  29.814  -0.356  1.00 13.99           N  
ATOM    843  CA  ILE   119      10.619  30.178  -0.913  1.00 14.12           C  
ATOM    844  C   ILE   119       9.579  29.446  -0.056  1.00 13.80           C  
ATOM    845  O   ILE   119       9.548  28.229  -0.039  1.00 13.42           O  
ATOM    846  CB  ILE   119      10.467  29.693  -2.378  1.00 11.69           C  
ATOM    847  CG1 ILE   119      11.576  30.223  -3.304  1.00 14.24           C  
ATOM    848  CG2 ILE   119       9.084  30.029  -2.926  1.00 13.99           C  
ATOM    849  CD1 ILE   119      11.731  31.748  -3.313  1.00 16.18           C  
ATOM    850  N   PRO   120       8.764  30.194   0.701  1.00 14.28           N  
ATOM    851  CA  PRO   120       7.815  29.543   1.612  1.00 14.71           C  
ATOM    852  C   PRO   120       6.972  28.435   0.981  1.00 13.91           C  
ATOM    853  O   PRO   120       6.846  27.379   1.580  1.00 13.07           O  
ATOM    854  CB  PRO   120       6.942  30.713   2.088  1.00 16.54           C  
ATOM    855  CG  PRO   120       7.921  31.876   2.108  1.00 20.48           C  
ATOM    856  CD  PRO   120       8.742  31.667   0.847  1.00 16.71           C  
ATOM    857  N   SER   121       6.428  28.623  -0.221  1.00 12.41           N  
ATOM    858  CA  SER   121       5.595  27.600  -0.829  1.00 13.18           C  
ATOM    859  C   SER   121       6.374  26.329  -1.122  1.00 13.95           C  
ATOM    860  O   SER   121       5.860  25.244  -0.874  1.00 13.03           O  
ATOM    861  CB  SER   121       4.922  28.091  -2.125  1.00 18.33           C  
ATOM    862  OG  SER   121       5.883  28.515  -3.077  1.00 19.51           O  
ATOM    863  N   ARG   122       7.592  26.473  -1.666  1.00 12.92           N  
ATOM    864  CA  ARG   122       8.398  25.294  -1.995  1.00 13.33           C  
ATOM    865  C   ARG   122       8.831  24.590  -0.738  1.00 12.54           C  
ATOM    866  O   ARG   122       8.801  23.361  -0.669  1.00 13.01           O  
ATOM    867  CB  ARG   122       9.651  25.680  -2.775  1.00 15.70           C  
ATOM    868  CG  ARG   122       9.384  26.107  -4.191  1.00 15.72           C  
ATOM    869  CD  ARG   122      10.687  26.421  -4.930  1.00 14.92           C  
ATOM    870  NE  ARG   122      11.477  25.204  -5.093  1.00 17.78           N  
ATOM    871  CZ  ARG   122      12.717  25.156  -5.578  1.00 17.08           C  
ATOM    872  NH1 ARG   122      13.334  26.269  -5.966  1.00 14.73           N  
ATOM    873  NH2 ARG   122      13.349  23.986  -5.663  1.00 17.62           N  
ATOM    874  N   ASP   123       9.271  25.360   0.249  1.00 10.85           N  
ATOM    875  CA  ASP   123       9.774  24.725   1.459  1.00 10.72           C  
ATOM    876  C   ASP   123       8.636  24.052   2.227  1.00 12.40           C  
ATOM    877  O   ASP   123       8.812  22.953   2.789  1.00 11.60           O  
ATOM    878  CB  ASP   123      10.555  25.712   2.309  1.00 12.96           C  
ATOM    879  CG  ASP   123      11.841  26.184   1.616  1.00 13.68           C  
ATOM    880  OD1 ASP   123      12.315  25.471   0.695  1.00 13.31           O  
ATOM    881  OD2 ASP   123      12.333  27.262   2.001  1.00 15.24           O  
ATOM    882  N   HIS   124       7.440  24.643   2.168  1.00 12.54           N  
ATOM    883  CA  HIS   124       6.249  23.987   2.702  1.00 11.00           C  
ATOM    884  C   HIS   124       6.013  22.648   2.010  1.00 10.83           C  
ATOM    885  O   HIS   124       5.754  21.621   2.647  1.00 11.93           O  
ATOM    886  CB  HIS   124       5.015  24.864   2.495  1.00 11.21           C  
ATOM    887  CG  HIS   124       3.734  24.178   2.840  1.00 10.23           C  
ATOM    888  ND1 HIS   124       3.462  23.724   4.115  1.00 11.30           N  
ATOM    889  CD2 HIS   124       2.654  23.865   2.088  1.00 11.04           C  
ATOM    890  CE1 HIS   124       2.268  23.155   4.129  1.00  9.49           C  
ATOM    891  NE2 HIS   124       1.770  23.205   2.906  1.00 10.84           N  
ATOM    892  N   ALA   125       6.081  22.645   0.677  1.00 11.36           N  
ATOM    893  CA  ALA   125       5.718  21.453  -0.065  1.00 12.11           C  
ATOM    894  C   ALA   125       6.604  20.251   0.294  1.00 11.47           C  
ATOM    895  O   ALA   125       6.107  19.136   0.534  1.00 13.45           O  
ATOM    896  CB  ALA   125       5.759  21.738  -1.578  1.00 13.21           C  
ATOM    897  N   VAL   126       7.910  20.508   0.352  1.00 11.41           N  
ATOM    898  CA  VAL   126       8.910  19.489   0.690  0.50 11.13           C  
ATOM    900  C   VAL   126       8.685  19.016   2.122  1.00 13.15           C  
ATOM    901  O   VAL   126       8.677  17.830   2.410  1.00 13.62           O  
ATOM    902  CB  VAL   126      10.345  20.061   0.529  0.50 10.09           C  
ATOM    904  CG1 VAL   126      11.411  19.100   1.079  0.50 11.60           C  
ATOM    906  CG2 VAL   126      10.613  20.356  -0.940  0.50 10.13           C  
ATOM    908  N   SER   127       8.487  19.987   3.015  1.00 11.21           N  
ATOM    909  CA  SER   127       8.267  19.704   4.430  0.50 10.89           C  
ATOM    911  C   SER   127       6.994  18.889   4.674  1.00 11.26           C  
ATOM    912  O   SER   127       6.967  18.010   5.536  1.00 11.71           O  
ATOM    913  CB  SER   127       8.213  21.012   5.205  0.50 13.85           C  
ATOM    915  OG  SER   127       8.144  20.775   6.582  0.50 12.04           O  
ATOM    917  N   TYR   128       5.929  19.213   3.931  1.00 10.99           N  
ATOM    918  CA  TYR   128       4.664  18.487   4.046  1.00 10.36           C  
ATOM    919  C   TYR   128       4.840  17.017   3.689  1.00 12.02           C  
ATOM    920  O   TYR   128       4.337  16.137   4.415  1.00 12.45           O  
ATOM    921  CB  TYR   128       3.616  19.131   3.143  1.00  9.90           C  
ATOM    922  CG  TYR   128       2.374  18.311   2.989  1.00 10.64           C  
ATOM    923  CD1 TYR   128       1.401  18.313   3.990  1.00 12.75           C  
ATOM    924  CD2 TYR   128       2.149  17.576   1.838  1.00 10.69           C  
ATOM    925  CE1 TYR   128       0.231  17.571   3.847  1.00 12.99           C  
ATOM    926  CE2 TYR   128       1.000  16.796   1.690  1.00 14.34           C  
ATOM    927  CZ  TYR   128       0.037  16.811   2.701  1.00 14.74           C  
ATOM    928  OH  TYR   128      -1.130  16.062   2.554  1.00 19.35           O  
ATOM    929  N   GLN   129       5.561  16.745   2.587  1.00 12.30           N  
ATOM    930  CA  GLN   129       5.778  15.368   2.159  0.50 11.89           C  
ATOM    932  C   GLN   129       6.551  14.579   3.213  1.00 11.90           C  
ATOM    933  O   GLN   129       6.223  13.433   3.494  1.00 13.97           O  
ATOM    934  CB  GLN   129       6.463  15.319   0.790  0.50 17.43           C  
ATOM    936  CG  GLN   129       5.564  15.766  -0.373  0.50 21.28           C  
ATOM    938  CD  GLN   129       4.328  14.888  -0.571  0.50 27.50           C  
ATOM    940  OE1 GLN   129       3.227  15.395  -0.790  0.50 37.10           O  
ATOM    942  NE2 GLN   129       4.507  13.573  -0.502  0.50 39.43           N  
ATOM    944  N   ILE   130       7.546  15.214   3.816  1.00 10.99           N  
ATOM    945  CA  ILE   130       8.265  14.597   4.924  1.00 11.28           C  
ATOM    946  C   ILE   130       7.298  14.331   6.093  1.00 10.32           C  
ATOM    947  O   ILE   130       7.309  13.247   6.687  1.00 11.94           O  
ATOM    948  CB  ILE   130       9.456  15.480   5.369  1.00 10.79           C  
ATOM    949  CG1 ILE   130      10.539  15.476   4.263  1.00 12.69           C  
ATOM    950  CG2 ILE   130       9.987  15.048   6.769  1.00 11.24           C  
ATOM    951  CD1 ILE   130      11.663  16.488   4.451  1.00 13.94           C  
ATOM    952  N   GLY   131       6.468  15.325   6.412  1.00 10.56           N  
ATOM    953  CA  GLY   131       5.536  15.217   7.541  1.00 10.56           C  
ATOM    954  C   GLY   131       4.578  14.052   7.347  1.00 12.07           C  
ATOM    955  O   GLY   131       4.317  13.291   8.292  1.00 12.17           O  
ATOM    956  N   GLN   132       4.050  13.892   6.134  1.00 12.52           N  
ATOM    957  CA  GLN   132       3.177  12.763   5.827  1.00 13.85           C  
ATOM    958  C   GLN   132       3.827  11.420   6.131  1.00 11.58           C  
ATOM    959  O   GLN   132       3.199  10.536   6.740  1.00 13.19           O  
ATOM    960  CB  GLN   132       2.736  12.814   4.359  1.00 13.17           C  
ATOM    961  CG  GLN   132       1.733  13.902   4.071  1.00 16.82           C  
ATOM    962  CD  GLN   132       0.401  13.611   4.732  1.00 20.54           C  
ATOM    963  OE1 GLN   132       0.089  14.171   5.780  1.00 22.06           O  
ATOM    964  NE2 GLN   132      -0.378  12.700   4.144  1.00 24.13           N  
ATOM    965  N   ARG   133       5.088  11.261   5.723  1.00 11.88           N  
ATOM    966  CA  ARG   133       5.782   9.999   5.936  1.00 11.18           C  
ATOM    967  C   ARG   133       6.121   9.800   7.426  1.00 10.84           C  
ATOM    968  O   ARG   133       6.039   8.693   7.944  1.00 12.01           O  
ATOM    969  CB  ARG   133       7.005   9.914   5.020  1.00 12.43           C  
ATOM    970  CG  ARG   133       7.758   8.586   5.061  1.00 13.14           C  
ATOM    971  CD  ARG   133       6.902   7.426   4.535  1.00 14.39           C  
ATOM    972  NE  ARG   133       7.781   6.378   4.031  1.00 18.04           N  
ATOM    973  CZ  ARG   133       7.380   5.306   3.371  1.00 15.95           C  
ATOM    974  NH1 ARG   133       6.083   5.109   3.148  1.00 18.22           N  
ATOM    975  NH2 ARG   133       8.277   4.420   2.952  1.00 17.71           N  
ATOM    976  N   VAL   134       6.483  10.879   8.117  1.00 11.86           N  
ATOM    977  CA  VAL   134       6.704  10.813   9.564  1.00 11.94           C  
ATOM    978  C   VAL   134       5.443  10.329  10.269  1.00 10.69           C  
ATOM    979  O   VAL   134       5.500   9.471  11.160  1.00 12.44           O  
ATOM    980  CB  VAL   134       7.171  12.173  10.137  1.00 11.36           C  
ATOM    981  CG1 VAL   134       7.164  12.156  11.665  1.00 11.92           C  
ATOM    982  CG2 VAL   134       8.567  12.493   9.608  1.00 13.37           C  
ATOM    983  N   MET   135       4.291  10.852   9.860  1.00 11.80           N  
ATOM    984  CA  MET   135       3.045  10.414  10.507  1.00 12.72           C  
ATOM    985  C   MET   135       2.715   8.968  10.190  1.00 12.07           C  
ATOM    986  O   MET   135       2.195   8.258  11.064  1.00 12.57           O  
ATOM    987  CB  MET   135       1.880  11.317  10.131  1.00 13.33           C  
ATOM    988  CG  MET   135       2.034  12.771  10.541  1.00 14.97           C  
ATOM    989  SD  MET   135       2.476  12.977  12.442  0.70 14.74          SE  
ATOM    990  CE  MET   135       0.918  12.078  13.211  1.00 17.71           C  
ATOM    991  N   GLU   136       3.011   8.522   8.968  1.00 13.34           N  
ATOM    992  CA  GLU   136       2.786   7.116   8.638  1.00 14.66           C  
ATOM    993  C   GLU   136       3.637   6.218   9.539  1.00 13.86           C  
ATOM    994  O   GLU   136       3.169   5.190  10.048  1.00 14.68           O  
ATOM    995  CB  GLU   136       3.073   6.851   7.158  1.00 14.11           C  
ATOM    996  CG  GLU   136       2.850   5.419   6.721  1.00 19.12           C  
ATOM    997  CD  GLU   136       3.271   5.132   5.281  1.00 25.99           C  
ATOM    998  OE1 GLU   136       3.825   6.028   4.592  1.00 22.32           O  
ATOM    999  OE2 GLU   136       3.039   3.978   4.856  1.00 26.05           O  
ATOM   1000  N   ILE   137       4.866   6.651   9.806  1.00 11.87           N  
ATOM   1001  CA  ILE   137       5.759   5.917  10.725  1.00 12.27           C  
ATOM   1002  C   ILE   137       5.200   5.972  12.152  1.00 14.18           C  
ATOM   1003  O   ILE   137       5.159   4.958  12.879  1.00 14.08           O  
ATOM   1004  CB  ILE   137       7.197   6.523  10.671  1.00 14.79           C  
ATOM   1005  CG1 ILE   137       7.818   6.226   9.301  1.00 14.66           C  
ATOM   1006  CG2 ILE   137       8.092   6.057  11.823  1.00 17.41           C  
ATOM   1007  CD1 ILE   137       9.049   7.054   8.968  1.00 14.56           C  
ATOM   1008  N   ALA   138       4.756   7.155  12.564  1.00 13.36           N  
ATOM   1009  CA  ALA   138       4.239   7.308  13.920  1.00 15.50           C  
ATOM   1010  C   ALA   138       3.055   6.392  14.183  1.00 17.10           C  
ATOM   1011  O   ALA   138       3.029   5.691  15.197  1.00 17.07           O  
ATOM   1012  CB  ALA   138       3.863   8.740  14.187  1.00 14.77           C  
ATOM   1013  N   VAL   139       2.076   6.364  13.290  1.00 14.22           N  
ATOM   1014  CA  VAL   139       0.893   5.559  13.602  1.00 17.81           C  
ATOM   1015  C   VAL   139       1.211   4.051  13.593  1.00 16.57           C  
ATOM   1016  O   VAL   139       0.520   3.268  14.255  1.00 18.88           O  
ATOM   1017  CB  VAL   139      -0.350   5.940  12.747  1.00 25.03           C  
ATOM   1018  CG1 VAL   139      -0.700   7.418  12.942  1.00 23.47           C  
ATOM   1019  CG2 VAL   139      -0.116   5.632  11.315  1.00 23.85           C  
ATOM   1020  N   ARG   140       2.260   3.651  12.881  1.00 14.60           N  
ATOM   1021  CA  ARG   140       2.713   2.272  12.855  1.00 14.63           C  
ATOM   1022  C   ARG   140       3.375   1.842  14.176  1.00 14.50           C  
ATOM   1023  O   ARG   140       3.273   0.670  14.584  1.00 16.94           O  
ATOM   1024  CB  ARG   140       3.722   2.106  11.729  1.00 17.48           C  
ATOM   1025  CG  ARG   140       4.114   0.710  11.407  1.00 23.55           C  
ATOM   1026  CD  ARG   140       4.253   0.612   9.922  1.00 28.61           C  
ATOM   1027  NE  ARG   140       4.768  -0.681   9.510  1.00 35.75           N  
ATOM   1028  CZ  ARG   140       4.692  -1.131   8.267  1.00 23.47           C  
ATOM   1029  NH1 ARG   140       4.095  -0.390   7.329  1.00 25.25           N  
ATOM   1030  NH2 ARG   140       5.191  -2.319   7.969  1.00 33.07           N  
ATOM   1031  N   TYR   141       4.078   2.770  14.845  1.00 12.86           N  
ATOM   1032  CA  TYR   141       4.960   2.361  15.935  1.00 12.52           C  
ATOM   1033  C   TYR   141       4.629   2.955  17.296  1.00 10.49           C  
ATOM   1034  O   TYR   141       5.192   2.517  18.288  1.00 11.91           O  
ATOM   1035  CB  TYR   141       6.417   2.676  15.606  1.00 11.72           C  
ATOM   1036  CG  TYR   141       6.939   1.896  14.435  1.00 15.03           C  
ATOM   1037  CD1 TYR   141       7.106   0.514  14.520  1.00 15.39           C  
ATOM   1038  CD2 TYR   141       7.242   2.533  13.239  1.00 15.09           C  
ATOM   1039  CE1 TYR   141       7.577  -0.210  13.439  1.00 16.45           C  
ATOM   1040  CE2 TYR   141       7.712   1.832  12.159  1.00 17.80           C  
ATOM   1041  CZ  TYR   141       7.872   0.467  12.249  1.00 17.33           C  
ATOM   1042  OH  TYR   141       8.350  -0.169  11.125  1.00 18.29           O  
ATOM   1043  N   LEU   142       3.742   3.950  17.349  1.00 10.86           N  
ATOM   1044  CA  LEU   142       3.441   4.618  18.622  0.50 11.36           C  
ATOM   1046  C   LEU   142       2.571   3.806  19.548  1.00 13.48           C  
ATOM   1047  O   LEU   142       1.594   3.191  19.112  1.00 14.78           O  
ATOM   1048  CB  LEU   142       2.723   5.941  18.416  0.50 11.66           C  
ATOM   1050  CG  LEU   142       3.563   7.179  18.176  0.50  9.60           C  
ATOM   1052  CD1 LEU   142       2.600   8.224  17.674  0.50 14.73           C  
ATOM   1054  CD2 LEU   142       4.278   7.649  19.457  0.50 11.81           C  
ATOM   1056  N   ARG   143       2.901   3.846  20.837  1.00 12.69           N  
ATOM   1057  CA  ARG   143       2.033   3.237  21.845  1.00 13.33           C  
ATOM   1058  C   ARG   143       0.826   4.130  22.018  1.00 14.30           C  
ATOM   1059  O   ARG   143       0.884   5.351  21.765  1.00 14.62           O  
ATOM   1060  CB  ARG   143       2.752   3.055  23.194  1.00 15.19           C  
ATOM   1061  CG  ARG   143       3.082   4.318  23.972  1.00 13.79           C  
ATOM   1062  CD  ARG   143       3.539   3.944  25.394  1.00 16.54           C  
ATOM   1063  NE  ARG   143       3.892   5.104  26.190  1.00 18.51           N  
ATOM   1064  CZ  ARG   143       3.032   5.816  26.914  1.00 20.32           C  
ATOM   1065  NH1 ARG   143       1.738   5.491  26.943  1.00 23.94           N  
ATOM   1066  NH2 ARG   143       3.464   6.847  27.622  1.00 24.25           N  
ATOM   1067  N   ASN   144      -0.271   3.530  22.476  1.00 15.98           N  
ATOM   1068  CA  ASN   144      -1.406   4.304  22.952  0.50 16.67           C  
ATOM   1070  C   ASN   144      -0.921   5.238  24.030  1.00 14.32           C  
ATOM   1071  O   ASN   144      -0.252   4.786  24.965  1.00 16.71           O  
ATOM   1072  CB  ASN   144      -2.467   3.388  23.551  0.50 15.10           C  
ATOM   1074  CG  ASN   144      -3.203   2.613  22.509  0.50 27.23           C  
ATOM   1076  OD1 ASN   144      -3.474   3.128  21.432  0.50 29.27           O  
ATOM   1078  ND2 ASN   144      -3.542   1.362  22.818  0.50 20.43           N  
ATOM   1080  N   GLY   145      -1.245   6.519  23.892  1.00 13.95           N  
ATOM   1081  CA  GLY   145      -0.760   7.549  24.793  1.00 13.60           C  
ATOM   1082  C   GLY   145       0.538   8.244  24.347  1.00 15.52           C  
ATOM   1083  O   GLY   145       1.003   9.170  25.010  1.00 19.43           O  
ATOM   1084  N   GLY   146       1.119   7.788  23.235  1.00 14.32           N  
ATOM   1085  CA  GLY   146       2.390   8.342  22.745  1.00 14.96           C  
ATOM   1086  C   GLY   146       2.242   9.696  22.063  1.00 12.11           C  
ATOM   1087  O   GLY   146       1.129  10.096  21.713  1.00 12.15           O  
ATOM   1088  N   ASN   147       3.368  10.378  21.882  1.00 12.02           N  
ATOM   1089  CA  ASN   147       3.384  11.718  21.315  1.00 10.79           C  
ATOM   1090  C   ASN   147       4.188  11.817  20.029  1.00 11.00           C  
ATOM   1091  O   ASN   147       5.095  11.005  19.790  1.00 10.12           O  
ATOM   1092  CB  ASN   147       4.028  12.711  22.298  1.00 13.03           C  
ATOM   1093  CG  ASN   147       3.254  12.859  23.595  1.00 14.49           C  
ATOM   1094  OD1 ASN   147       2.062  12.540  23.674  1.00 14.43           O  
ATOM   1095  ND2 ASN   147       3.935  13.349  24.618  1.00 15.04           N  
ATOM   1096  N   VAL   148       3.875  12.836  19.229  1.00 10.08           N  
ATOM   1097  CA  VAL   148       4.678  13.200  18.054  1.00 10.32           C  
ATOM   1098  C   VAL   148       5.112  14.659  18.127  1.00 10.96           C  
ATOM   1099  O   VAL   148       4.328  15.526  18.524  1.00 12.33           O  
ATOM   1100  CB  VAL   148       3.911  12.970  16.729  1.00 11.82           C  
ATOM   1101  CG1 VAL   148       4.750  13.388  15.517  1.00 13.57           C  
ATOM   1102  CG2 VAL   148       3.550  11.547  16.594  1.00 13.33           C  
ATOM   1103  N   LEU   149       6.360  14.917  17.737  1.00  9.54           N  
ATOM   1104  CA  LEU   149       6.847  16.284  17.535  1.00 10.13           C  
ATOM   1105  C   LEU   149       7.401  16.330  16.129  1.00  9.76           C  
ATOM   1106  O   LEU   149       8.202  15.491  15.769  1.00 10.76           O  
ATOM   1107  CB  LEU   149       7.977  16.622  18.518  1.00 12.13           C  
ATOM   1108  CG  LEU   149       8.880  17.829  18.198  1.00 11.89           C  
ATOM   1109  CD1 LEU   149       8.058  19.099  18.208  1.00 13.01           C  
ATOM   1110  CD2 LEU   149      10.021  17.909  19.210  1.00 14.70           C  
ATOM   1111  N   LEU   150       6.970  17.296  15.313  1.00  8.99           N  
ATOM   1112  CA  LEU   150       7.511  17.380  13.962  0.50 11.44           C  
ATOM   1114  C   LEU   150       7.656  18.800  13.473  1.00 12.24           C  
ATOM   1115  O   LEU   150       6.793  19.675  13.686  1.00 12.49           O  
ATOM   1116  CB  LEU   150       6.712  16.536  12.949  0.50 20.07           C  
ATOM   1118  CG  LEU   150       5.352  17.056  12.470  0.50 21.76           C  
ATOM   1120  CD1 LEU   150       5.133  16.793  10.984  0.50 23.31           C  
ATOM   1122  CD2 LEU   150       4.213  16.474  13.281  0.50 26.23           C  
ATOM   1124  N   LYS   151       8.809  19.031  12.839  1.00 11.05           N  
ATOM   1125  CA  LYS   151       9.069  20.312  12.200  1.00 12.47           C  
ATOM   1126  C   LYS   151       8.279  20.375  10.888  1.00 12.07           C  
ATOM   1127  O   LYS   151       8.258  19.406  10.103  1.00 11.40           O  
ATOM   1128  CB  LYS   151      10.563  20.476  11.890  1.00 15.74           C  
ATOM   1129  CG  LYS   151      10.857  21.850  11.284  1.00 15.82           C  
ATOM   1130  CD  LYS   151      12.303  22.226  11.298  1.00 23.41           C  
ATOM   1131  CE  LYS   151      13.066  21.415  10.296  1.00 23.56           C  
ATOM   1132  NZ  LYS   151      14.517  21.541  10.640  1.00 28.21           N  
ATOM   1133  N   GLN   152       7.663  21.529  10.632  1.00 11.33           N  
ATOM   1134  CA  GLN   152       7.024  21.794   9.346  1.00  9.32           C  
ATOM   1135  C   GLN   152       7.236  23.254   8.961  1.00 13.53           C  
ATOM   1136  O   GLN   152       7.270  24.131   9.811  1.00 16.85           O  
ATOM   1137  CB  GLN   152       5.521  21.478   9.397  1.00 11.40           C  
ATOM   1138  CG  GLN   152       4.805  21.567   8.029  1.00 12.88           C  
ATOM   1139  CD  GLN   152       3.428  20.909   7.999  1.00 15.18           C  
ATOM   1140  OE1 GLN   152       2.407  21.585   7.807  1.00 16.33           O  
ATOM   1141  NE2 GLN   152       3.394  19.588   8.162  1.00 13.42           N  
ATOM   1142  N   PHE   153       7.390  23.505   7.673  1.00 11.92           N  
ATOM   1143  CA  PHE   153       7.368  24.860   7.177  1.00 13.28           C  
ATOM   1144  C   PHE   153       5.909  25.142   6.823  1.00 12.52           C  
ATOM   1145  O   PHE   153       5.315  24.398   6.033  1.00 14.65           O  
ATOM   1146  CB  PHE   153       8.313  24.968   5.976  1.00 16.75           C  
ATOM   1147  CG  PHE   153       9.772  25.034   6.367  1.00 15.41           C  
ATOM   1148  CD1 PHE   153      10.418  26.266   6.415  1.00 23.92           C  
ATOM   1149  CD2 PHE   153      10.488  23.902   6.733  1.00 18.53           C  
ATOM   1150  CE1 PHE   153      11.767  26.364   6.787  1.00 25.02           C  
ATOM   1151  CE2 PHE   153      11.851  24.006   7.130  1.00 18.44           C  
ATOM   1152  CZ  PHE   153      12.476  25.232   7.132  1.00 23.62           C  
ATOM   1153  N   GLN   154       5.336  26.191   7.414  1.00 12.75           N  
ATOM   1154  CA  GLN   154       3.898  26.435   7.325  1.00 14.37           C  
ATOM   1155  C   GLN   154       3.474  26.798   5.902  1.00 14.38           C  
ATOM   1156  O   GLN   154       4.179  27.504   5.181  1.00 13.34           O  
ATOM   1157  CB  GLN   154       3.497  27.565   8.284  1.00 18.17           C  
ATOM   1158  CG  GLN   154       1.971  27.723   8.437  1.00 23.89           C  
ATOM   1159  CD  GLN   154       1.567  28.266   9.789  1.00 37.14           C  
ATOM   1160  OE1 GLN   154       2.246  29.124  10.356  1.00 41.97           O  
ATOM   1161  NE2 GLN   154       0.451  27.766  10.318  1.00 46.60           N  
ATOM   1162  N   GLY   155       2.301  26.314   5.515  1.00 11.64           N  
ATOM   1163  CA  GLY   155       1.732  26.708   4.223  1.00 11.82           C  
ATOM   1164  C   GLY   155       0.327  26.182   4.073  1.00 11.40           C  
ATOM   1165  O   GLY   155      -0.336  25.849   5.060  1.00 12.08           O  
ATOM   1166  N   ASP   156      -0.138  26.104   2.830  1.00 11.38           N  
ATOM   1167  CA  ASP   156      -1.538  25.804   2.554  1.00 12.44           C  
ATOM   1168  C   ASP   156      -1.982  24.534   3.272  1.00 13.47           C  
ATOM   1169  O   ASP   156      -3.104  24.452   3.772  1.00 14.62           O  
ATOM   1170  CB  ASP   156      -1.768  25.664   1.048  1.00 11.62           C  
ATOM   1171  CG  ASP   156      -1.751  26.999   0.330  1.00 14.84           C  
ATOM   1172  OD1 ASP   156      -1.882  28.041   1.006  1.00 13.69           O  
ATOM   1173  OD2 ASP   156      -1.606  27.007  -0.911  1.00 14.10           O  
ATOM   1174  N   MET   157      -1.095  23.545   3.319  1.00 11.53           N  
ATOM   1175  CA  MET   157      -1.484  22.182   3.659  1.00 12.40           C  
ATOM   1176  C   MET   157      -1.526  21.982   5.170  1.00 10.48           C  
ATOM   1177  O   MET   157      -1.946  20.932   5.656  1.00 12.88           O  
ATOM   1178  CB  MET   157      -0.524  21.176   3.022  1.00 13.36           C  
ATOM   1179  CG  MET   157      -0.571  21.150   1.503  1.00 11.62           C  
ATOM   1180  SD  MET   157      -2.370  20.854   0.810  0.70 16.42          SE  
ATOM   1181  CE  MET   157      -2.754  19.154   1.684  1.00 16.01           C  
ATOM   1182  N   THR   158      -1.087  22.996   5.909  1.00 11.91           N  
ATOM   1183  CA  THR   158      -0.832  22.849   7.346  1.00 11.22           C  
ATOM   1184  C   THR   158      -2.101  22.627   8.154  1.00 13.90           C  
ATOM   1185  O   THR   158      -2.183  21.670   8.935  1.00 11.92           O  
ATOM   1186  CB  THR   158      -0.027  24.021   7.916  1.00 12.96           C  
ATOM   1187  OG1 THR   158       1.250  24.065   7.252  1.00 12.46           O  
ATOM   1188  CG2 THR   158       0.188  23.831   9.441  1.00 15.05           C  
ATOM   1189  N   ASN   159      -3.103  23.472   7.928  1.00 13.35           N  
ATOM   1190  CA  ASN   159      -4.340  23.307   8.693  1.00 14.30           C  
ATOM   1191  C   ASN   159      -5.052  22.013   8.390  1.00 12.35           C  
ATOM   1192  O   ASN   159      -5.561  21.352   9.306  1.00 15.82           O  
ATOM   1193  CB  ASN   159      -5.285  24.484   8.480  1.00 16.47           C  
ATOM   1194  CG  ASN   159      -4.833  25.709   9.213  1.00 21.05           C  
ATOM   1195  OD1 ASN   159      -3.877  25.658   9.986  1.00 22.39           O  
ATOM   1196  ND2 ASN   159      -5.512  26.828   8.978  1.00 24.55           N  
ATOM   1197  N   ASP   160      -5.045  21.608   7.117  1.00 13.38           N  
ATOM   1198  CA  ASP   160      -5.652  20.343   6.741  0.50 12.59           C  
ATOM   1200  C   ASP   160      -4.886  19.124   7.297  1.00 14.86           C  
ATOM   1201  O   ASP   160      -5.504  18.139   7.723  1.00 17.44           O  
ATOM   1202  CB  ASP   160      -5.838  20.269   5.214  0.50 16.57           C  
ATOM   1204  CG  ASP   160      -7.056  21.076   4.719  0.50 22.87           C  
ATOM   1206  OD1 ASP   160      -7.115  22.314   4.906  0.50 15.88           O  
ATOM   1208  OD2 ASP   160      -7.956  20.470   4.094  0.50 19.25           O  
ATOM   1210  N   PHE   161      -3.549  19.211   7.316  1.00 14.31           N  
ATOM   1211  CA  PHE   161      -2.656  18.197   7.890  1.00 14.03           C  
ATOM   1212  C   PHE   161      -3.006  17.995   9.378  1.00 11.91           C  
ATOM   1213  O   PHE   161      -3.197  16.851   9.829  1.00 14.86           O  
ATOM   1214  CB  PHE   161      -1.192  18.665   7.692  1.00 12.85           C  
ATOM   1215  CG  PHE   161      -0.150  17.778   8.326  1.00 12.52           C  
ATOM   1216  CD1 PHE   161       0.404  16.743   7.591  1.00 15.17           C  
ATOM   1217  CD2 PHE   161       0.321  18.003   9.640  1.00 12.26           C  
ATOM   1218  CE1 PHE   161       1.376  15.926   8.139  1.00 15.39           C  
ATOM   1219  CE2 PHE   161       1.292  17.175  10.192  1.00 14.73           C  
ATOM   1220  CZ  PHE   161       1.819  16.153   9.435  1.00 14.16           C  
ATOM   1221  N   ILE   162      -3.104  19.107  10.108  1.00 12.59           N  
ATOM   1222  CA  ILE   162      -3.429  19.063  11.516  1.00 13.26           C  
ATOM   1223  C   ILE   162      -4.823  18.505  11.726  1.00 14.67           C  
ATOM   1224  O   ILE   162      -4.990  17.642  12.585  1.00 17.12           O  
ATOM   1225  CB  ILE   162      -3.250  20.441  12.162  1.00 13.98           C  
ATOM   1226  CG1 ILE   162      -1.761  20.787  12.181  1.00 15.65           C  
ATOM   1227  CG2 ILE   162      -3.835  20.489  13.604  1.00 16.81           C  
ATOM   1228  CD1 ILE   162      -1.495  22.170  12.613  1.00 16.81           C  
ATOM   1229  N   ALA   163      -5.789  18.953  10.912  1.00 13.67           N  
ATOM   1230  CA  ALA   163      -7.183  18.497  11.059  1.00 15.76           C  
ATOM   1231  C   ALA   163      -7.291  16.988  10.871  1.00 17.54           C  
ATOM   1232  O   ALA   163      -8.055  16.321  11.584  1.00 20.78           O  
ATOM   1233  CB  ALA   163      -8.095  19.224  10.095  1.00 17.98           C  
ATOM   1234  N   ILE   164      -6.536  16.441   9.913  1.00 15.90           N  
ATOM   1235  CA  ILE   164      -6.589  15.011   9.610  1.00 16.22           C  
ATOM   1236  C   ILE   164      -5.888  14.208  10.704  1.00 19.24           C  
ATOM   1237  O   ILE   164      -6.469  13.282  11.287  1.00 20.94           O  
ATOM   1238  CB  ILE   164      -6.008  14.690   8.200  1.00 19.88           C  
ATOM   1239  CG1 ILE   164      -6.947  15.210   7.097  1.00 22.44           C  
ATOM   1240  CG2 ILE   164      -5.752  13.191   8.028  1.00 22.35           C  
ATOM   1241  CD1 ILE   164      -6.292  15.382   5.739  1.00 28.45           C  
ATOM   1242  N   TRP   165      -4.650  14.577  11.016  1.00 15.75           N  
ATOM   1243  CA  TRP   165      -3.852  13.749  11.922  1.00 19.10           C  
ATOM   1244  C   TRP   165      -4.288  13.829  13.376  1.00 15.64           C  
ATOM   1245  O   TRP   165      -4.101  12.864  14.129  1.00 18.93           O  
ATOM   1246  CB  TRP   165      -2.349  14.030  11.765  1.00 16.07           C  
ATOM   1247  CG  TRP   165      -1.815  13.501  10.472  1.00 15.98           C  
ATOM   1248  CD1 TRP   165      -1.403  14.233   9.384  1.00 17.48           C  
ATOM   1249  CD2 TRP   165      -1.671  12.121  10.097  1.00 14.31           C  
ATOM   1250  NE1 TRP   165      -0.997  13.397   8.376  1.00 16.98           N  
ATOM   1251  CE2 TRP   165      -1.163  12.098   8.779  1.00 17.19           C  
ATOM   1252  CE3 TRP   165      -1.905  10.903  10.753  1.00 18.10           C  
ATOM   1253  CZ2 TRP   165      -0.875  10.903   8.105  1.00 17.54           C  
ATOM   1254  CZ3 TRP   165      -1.634   9.719  10.074  1.00 17.05           C  
ATOM   1255  CH2 TRP   165      -1.119   9.728   8.771  1.00 19.78           C  
ATOM   1256  N   ARG   166      -4.891  14.955  13.767  1.00 14.46           N  
ATOM   1257  CA  ARG   166      -5.303  15.123  15.173  1.00 17.91           C  
ATOM   1258  C   ARG   166      -6.444  14.205  15.583  1.00 18.87           C  
ATOM   1259  O   ARG   166      -6.679  14.029  16.777  1.00 22.29           O  
ATOM   1260  CB  ARG   166      -5.641  16.572  15.522  1.00 22.23           C  
ATOM   1261  CG  ARG   166      -6.984  17.076  15.044  1.00 22.75           C  
ATOM   1262  CD  ARG   166      -7.045  18.555  15.325  1.00 33.12           C  
ATOM   1263  NE  ARG   166      -8.271  19.178  14.863  1.00 34.39           N  
ATOM   1264  CZ  ARG   166      -9.360  19.321  15.608  1.00 42.29           C  
ATOM   1265  NH1 ARG   166     -10.426  19.909  15.088  1.00 44.12           N  
ATOM   1266  NH2 ARG   166      -9.383  18.880  16.860  1.00 38.24           N  
ATOM   1267  N   LYS   167      -7.109  13.605  14.595  1.00 20.24           N  
ATOM   1268  CA  LYS   167      -8.148  12.593  14.833  1.00 22.36           C  
ATOM   1269  C   LYS   167      -7.604  11.337  15.528  1.00 23.24           C  
ATOM   1270  O   LYS   167      -8.370  10.587  16.133  1.00 23.92           O  
ATOM   1271  CB  LYS   167      -8.811  12.209  13.513  1.00 21.65           C  
ATOM   1272  CG  LYS   167      -9.668  13.306  12.912  1.00 25.38           C  
ATOM   1273  CD  LYS   167     -10.216  12.866  11.556  1.00 37.24           C  
ATOM   1274  CE  LYS   167     -11.133  13.921  10.960  1.00 47.22           C  
ATOM   1275  NZ  LYS   167     -11.554  13.576   9.571  1.00 57.19           N  
ATOM   1276  N   ASN   168      -6.291  11.106  15.434  1.00 20.02           N  
ATOM   1277  CA  ASN   168      -5.632   9.961  16.092  1.00 21.18           C  
ATOM   1278  C   ASN   168      -5.032  10.308  17.460  1.00 17.20           C  
ATOM   1279  O   ASN   168      -4.284   9.511  18.038  1.00 18.97           O  
ATOM   1280  CB  ASN   168      -4.524   9.384  15.204  1.00 24.01           C  
ATOM   1281  CG  ASN   168      -4.997   9.070  13.807  1.00 29.97           C  
ATOM   1282  OD1 ASN   168      -5.571   8.016  13.556  1.00 38.36           O  
ATOM   1283  ND2 ASN   168      -4.750   9.988  12.884  1.00 35.11           N  
ATOM   1284  N   PHE   169      -5.329  11.504  17.958  1.00 17.50           N  
ATOM   1285  CA  PHE   169      -4.700  12.009  19.172  1.00 19.00           C  
ATOM   1286  C   PHE   169      -5.681  12.734  20.095  1.00 19.40           C  
ATOM   1287  O   PHE   169      -6.741  13.197  19.659  1.00 22.92           O  
ATOM   1288  CB  PHE   169      -3.525  12.940  18.830  1.00 15.77           C  
ATOM   1289  CG  PHE   169      -2.365  12.233  18.154  1.00 13.65           C  
ATOM   1290  CD1 PHE   169      -1.297  11.733  18.900  1.00 12.61           C  
ATOM   1291  CD2 PHE   169      -2.314  12.125  16.767  1.00 12.39           C  
ATOM   1292  CE1 PHE   169      -0.211  11.096  18.262  1.00 12.66           C  
ATOM   1293  CE2 PHE   169      -1.247  11.496  16.134  1.00 12.84           C  
ATOM   1294  CZ  PHE   169      -0.203  10.980  16.878  1.00 13.03           C  
ATOM   1295  N   SER   170      -5.303  12.819  21.366  1.00 17.70           N  
ATOM   1296  CA  SER   170      -6.109  13.503  22.370  0.50 20.33           C  
ATOM   1298  C   SER   170      -6.104  15.017  22.173  1.00 23.24           C  
ATOM   1299  O   SER   170      -7.136  15.682  22.371  1.00 22.67           O  
ATOM   1300  CB  SER   170      -5.616  13.134  23.771  0.50 21.72           C  
ATOM   1302  OG  SER   170      -5.662  11.732  23.953  0.50 23.48           O  
ATOM   1304  N   SER   171      -4.957  15.564  21.759  1.00 17.62           N  
ATOM   1305  CA  SER   171      -4.808  16.999  21.555  1.00 17.90           C  
ATOM   1306  C   SER   171      -3.626  17.327  20.640  1.00 17.62           C  
ATOM   1307  O   SER   171      -2.849  16.447  20.276  1.00 16.20           O  
ATOM   1308  CB  SER   171      -4.610  17.718  22.896  1.00 18.97           C  
ATOM   1309  OG  SER   171      -3.388  17.332  23.527  1.00 20.91           O  
ATOM   1310  N   TYR   172      -3.493  18.594  20.270  1.00 15.71           N  
ATOM   1311  CA  TYR   172      -2.332  19.040  19.515  1.00 14.60           C  
ATOM   1312  C   TYR   172      -1.932  20.430  19.958  1.00 17.02           C  
ATOM   1313  O   TYR   172      -2.754  21.163  20.549  1.00 16.90           O  
ATOM   1314  CB  TYR   172      -2.604  19.043  17.992  1.00 15.60           C  
ATOM   1315  CG  TYR   172      -3.399  20.235  17.502  1.00 19.02           C  
ATOM   1316  CD1 TYR   172      -2.763  21.389  17.030  1.00 20.38           C  
ATOM   1317  CD2 TYR   172      -4.788  20.208  17.515  1.00 25.26           C  
ATOM   1318  CE1 TYR   172      -3.497  22.490  16.604  1.00 18.75           C  
ATOM   1319  CE2 TYR   172      -5.525  21.289  17.071  1.00 25.40           C  
ATOM   1320  CZ  TYR   172      -4.884  22.419  16.629  1.00 23.67           C  
ATOM   1321  OH  TYR   172      -5.637  23.489  16.188  1.00 26.51           O  
ATOM   1322  N   LYS   173      -0.678  20.787  19.672  1.00 16.10           N  
ATOM   1323  CA  LYS   173      -0.171  22.147  19.859  0.50 15.36           C  
ATOM   1325  C   LYS   173       0.734  22.529  18.698  1.00 16.51           C  
ATOM   1326  O   LYS   173       1.356  21.658  18.076  1.00 15.47           O  
ATOM   1327  CB  LYS   173       0.607  22.279  21.172  0.50 17.13           C  
ATOM   1329  CG  LYS   173      -0.230  22.012  22.410  0.50 21.46           C  
ATOM   1331  CD  LYS   173       0.334  22.672  23.637  0.50 30.27           C  
ATOM   1333  CE  LYS   173      -0.307  22.140  24.905  0.50 31.83           C  
ATOM   1335  NZ  LYS   173      -1.758  22.461  24.978  0.50 23.82           N  
ATOM   1337  N   ILE   174       0.794  23.824  18.398  1.00 13.68           N  
ATOM   1338  CA  ILE   174       1.722  24.383  17.440  1.00 14.31           C  
ATOM   1339  C   ILE   174       2.597  25.396  18.178  1.00 15.81           C  
ATOM   1340  O   ILE   174       2.093  26.174  19.012  1.00 17.33           O  
ATOM   1341  CB  ILE   174       1.006  25.076  16.237  1.00 18.32           C  
ATOM   1342  CG1 ILE   174       0.082  24.091  15.519  1.00 22.53           C  
ATOM   1343  CG2 ILE   174       2.014  25.674  15.248  1.00 22.62           C  
ATOM   1344  CD1 ILE   174      -1.106  24.804  14.872  1.00 36.94           C  
ATOM   1345  N   SER   175       3.893  25.376  17.889  1.00 16.05           N  
ATOM   1346  CA  SER   175       4.820  26.356  18.433  1.00 16.42           C  
ATOM   1347  C   SER   175       5.801  26.935  17.420  1.00 24.16           C  
ATOM   1348  O   SER   175       6.188  26.265  16.461  1.00 19.16           O  
ATOM   1349  CB  SER   175       5.643  25.705  19.546  1.00 19.60           C  
ATOM   1350  OG  SER   175       6.513  26.650  20.151  1.00 23.47           O  
ATOM   1351  N   LYS   176       6.232  28.170  17.687  1.00 30.96           N  
ATOM   1352  CA  LYS   176       7.315  28.823  16.943  0.50 37.46           C  
ATOM   1354  C   LYS   176       8.448  29.228  17.907  1.00 40.47           C  
ATOM   1355  O   LYS   176       8.335  30.246  18.600  1.00 45.07           O  
ATOM   1356  CB  LYS   176       6.798  30.064  16.190  0.50 38.18           C  
ATOM   1358  CG  LYS   176       5.703  29.805  15.147  0.50 39.96           C  
ATOM   1360  CD  LYS   176       4.298  30.018  15.707  0.50 42.89           C  
ATOM   1362  CE  LYS   176       3.237  29.878  14.626  0.50 42.91           C  
ATOM   1364  NZ  LYS   176       1.858  30.045  15.160  0.50 44.53           N  
ATOM   1366  N   PRO   177       9.544  28.429  17.976  1.00 44.39           N  
ATOM   1367  CA  PRO   177      10.685  28.789  18.851  1.00 46.09           C  
ATOM   1368  C   PRO   177      11.475  30.021  18.408  1.00 45.73           C  
ATOM   1369  O   PRO   177      11.329  30.472  17.274  1.00 44.57           O  
ATOM   1370  CB  PRO   177      11.591  27.550  18.789  1.00 46.13           C  
ATOM   1371  CG  PRO   177      10.723  26.457  18.270  1.00 45.78           C  
ATOM   1372  CD  PRO   177       9.781  27.134  17.319  1.00 47.03           C  
ATOM   1373  N   SER   184      11.206  32.146   8.615  1.00 47.14           N  
ATOM   1374  CA  SER   184      10.221  32.550   9.614  1.00 43.59           C  
ATOM   1375  C   SER   184       8.890  31.810   9.444  1.00 36.29           C  
ATOM   1376  O   SER   184       7.917  32.105  10.148  1.00 37.97           O  
ATOM   1377  CB  SER   184      10.008  34.074   9.592  1.00 48.80           C  
ATOM   1378  OG  SER   184       9.332  34.502   8.416  1.00 50.96           O  
ATOM   1379  N   SER   185       8.850  30.856   8.508  1.00 30.41           N  
ATOM   1380  CA  SER   185       7.675  29.994   8.338  1.00 26.29           C  
ATOM   1381  C   SER   185       7.817  28.621   9.031  1.00 21.47           C  
ATOM   1382  O   SER   185       6.892  27.818   8.996  1.00 18.11           O  
ATOM   1383  CB  SER   185       7.316  29.817   6.853  1.00 28.47           C  
ATOM   1384  OG  SER   185       8.319  29.111   6.138  1.00 27.82           O  
ATOM   1385  N   GLU   186       8.963  28.371   9.663  1.00 18.19           N  
ATOM   1386  CA  GLU   186       9.182  27.112  10.398  1.00 18.84           C  
ATOM   1387  C   GLU   186       8.323  27.056  11.661  1.00 17.96           C  
ATOM   1388  O   GLU   186       8.293  28.003  12.456  1.00 19.32           O  
ATOM   1389  CB  GLU   186      10.659  27.004  10.755  1.00 23.73           C  
ATOM   1390  CG  GLU   186      11.044  25.796  11.583  1.00 28.26           C  
ATOM   1391  CD  GLU   186      12.518  25.820  11.930  1.00 36.25           C  
ATOM   1392  OE1 GLU   186      13.340  25.634  11.009  1.00 41.09           O  
ATOM   1393  OE2 GLU   186      12.845  26.037  13.116  1.00 27.26           O  
ATOM   1394  N   ILE   187       7.595  25.952  11.832  1.00 12.61           N  
ATOM   1395  CA  ILE   187       6.822  25.734  13.033  1.00 14.48           C  
ATOM   1396  C   ILE   187       7.046  24.310  13.512  1.00 11.25           C  
ATOM   1397  O   ILE   187       7.566  23.463  12.777  1.00 12.69           O  
ATOM   1398  CB  ILE   187       5.292  25.927  12.794  1.00 13.62           C  
ATOM   1399  CG1 ILE   187       4.748  24.936  11.756  1.00 16.83           C  
ATOM   1400  CG2 ILE   187       4.981  27.380  12.355  1.00 16.35           C  
ATOM   1401  CD1 ILE   187       3.219  24.939  11.638  1.00 16.25           C  
ATOM   1402  N   TYR   188       6.645  24.058  14.740  1.00 12.52           N  
ATOM   1403  CA  TYR   188       6.685  22.709  15.280  1.00 11.12           C  
ATOM   1404  C   TYR   188       5.284  22.293  15.669  1.00 13.07           C  
ATOM   1405  O   TYR   188       4.590  23.002  16.389  1.00 15.22           O  
ATOM   1406  CB  TYR   188       7.650  22.636  16.469  1.00 12.16           C  
ATOM   1407  CG  TYR   188       9.091  22.682  15.995  1.00 14.96           C  
ATOM   1408  CD1 TYR   188       9.742  21.518  15.624  1.00 14.22           C  
ATOM   1409  CD2 TYR   188       9.788  23.895  15.877  1.00 24.10           C  
ATOM   1410  CE1 TYR   188      11.058  21.533  15.162  1.00 20.23           C  
ATOM   1411  CE2 TYR   188      11.132  23.920  15.405  1.00 17.23           C  
ATOM   1412  CZ  TYR   188      11.740  22.728  15.060  1.00 20.20           C  
ATOM   1413  OH  TYR   188      13.040  22.688  14.585  1.00 22.77           O  
ATOM   1414  N   ILE   189       4.848  21.170  15.112  1.00 10.86           N  
ATOM   1415  CA  ILE   189       3.551  20.614  15.382  1.00 11.58           C  
ATOM   1416  C   ILE   189       3.700  19.439  16.344  1.00 12.48           C  
ATOM   1417  O   ILE   189       4.542  18.576  16.131  1.00 10.76           O  
ATOM   1418  CB  ILE   189       2.904  20.096  14.062  1.00 12.23           C  
ATOM   1419  CG1 ILE   189       2.816  21.238  13.017  1.00 13.52           C  
ATOM   1420  CG2 ILE   189       1.567  19.495  14.350  1.00 13.92           C  
ATOM   1421  CD1 ILE   189       2.330  20.833  11.608  1.00 13.20           C  
ATOM   1422  N   MET   190       2.902  19.413  17.410  1.00 10.89           N  
ATOM   1423  CA  MET   190       2.932  18.331  18.373  1.00 10.73           C  
ATOM   1424  C   MET   190       1.579  17.719  18.511  1.00 11.66           C  
ATOM   1425  O   MET   190       0.586  18.426  18.642  1.00 14.15           O  
ATOM   1426  CB  MET   190       3.391  18.873  19.717  1.00 14.40           C  
ATOM   1427  CG  MET   190       4.825  19.361  19.671  1.00 11.28           C  
ATOM   1428  SD  MET   190       5.290  20.609  21.075  0.70 15.68          SE  
ATOM   1429  CE  MET   190       4.616  22.239  20.199  1.00 15.83           C  
ATOM   1430  N   PHE   191       1.553  16.402  18.473  1.00 10.91           N  
ATOM   1431  CA  PHE   191       0.346  15.645  18.712  1.00 11.71           C  
ATOM   1432  C   PHE   191       0.498  14.847  19.997  1.00 13.28           C  
ATOM   1433  O   PHE   191       1.502  14.154  20.182  1.00 12.81           O  
ATOM   1434  CB  PHE   191       0.085  14.710  17.541  1.00 13.21           C  
ATOM   1435  CG  PHE   191      -0.197  15.410  16.236  1.00 12.64           C  
ATOM   1436  CD1 PHE   191      -1.429  16.065  15.992  1.00 14.49           C  
ATOM   1437  CD2 PHE   191       0.749  15.408  15.237  1.00 14.78           C  
ATOM   1438  CE1 PHE   191      -1.683  16.692  14.767  1.00 15.89           C  
ATOM   1439  CE2 PHE   191       0.502  16.023  14.015  1.00 13.87           C  
ATOM   1440  CZ  PHE   191      -0.714  16.678  13.776  1.00 14.54           C  
ATOM   1441  N   PHE   192      -0.491  14.916  20.882  1.00 12.86           N  
ATOM   1442  CA  PHE   192      -0.370  14.302  22.207  1.00 14.39           C  
ATOM   1443  C   PHE   192      -1.384  13.187  22.416  1.00 12.55           C  
ATOM   1444  O   PHE   192      -2.570  13.360  22.102  1.00 16.09           O  
ATOM   1445  CB  PHE   192      -0.564  15.354  23.309  1.00 12.50           C  
ATOM   1446  CG  PHE   192       0.479  16.433  23.302  1.00 11.60           C  
ATOM   1447  CD1 PHE   192       1.676  16.297  24.024  1.00 11.91           C  
ATOM   1448  CD2 PHE   192       0.284  17.586  22.557  1.00 13.16           C  
ATOM   1449  CE1 PHE   192       2.655  17.302  23.997  1.00 13.78           C  
ATOM   1450  CE2 PHE   192       1.245  18.597  22.520  1.00 12.61           C  
ATOM   1451  CZ  PHE   192       2.436  18.460  23.242  1.00 15.38           C  
ATOM   1452  N   GLY   193      -0.922  12.057  22.946  1.00 13.98           N  
ATOM   1453  CA  GLY   193      -1.843  11.007  23.383  1.00 15.36           C  
ATOM   1454  C   GLY   193      -2.468  10.213  22.256  1.00 13.95           C  
ATOM   1455  O   GLY   193      -3.678  10.295  21.999  1.00 16.05           O  
ATOM   1456  N   PHE   194      -1.636   9.445  21.562  1.00 13.46           N  
ATOM   1457  CA  PHE   194      -2.059   8.635  20.433  1.00 11.69           C  
ATOM   1458  C   PHE   194      -3.164   7.669  20.824  1.00 13.52           C  
ATOM   1459  O   PHE   194      -3.112   7.089  21.889  1.00 16.71           O  
ATOM   1460  CB  PHE   194      -0.862   7.833  19.914  1.00 13.82           C  
ATOM   1461  CG  PHE   194      -1.163   6.995  18.710  1.00 16.03           C  
ATOM   1462  CD1 PHE   194      -1.590   7.578  17.524  1.00 14.81           C  
ATOM   1463  CD2 PHE   194      -1.003   5.620  18.770  1.00 16.98           C  
ATOM   1464  CE1 PHE   194      -1.858   6.788  16.397  1.00 18.56           C  
ATOM   1465  CE2 PHE   194      -1.271   4.813  17.657  1.00 23.43           C  
ATOM   1466  CZ  PHE   194      -1.702   5.406  16.461  1.00 18.74           C  
ATOM   1467  N   LYS   195      -4.139   7.516  19.967  1.00 18.76           N  
ATOM   1468  CA  LYS   195      -5.181   6.511  20.100  1.00 24.68           C  
ATOM   1469  C   LYS   195      -5.265   5.710  18.826  1.00 26.91           C  
ATOM   1470  O   LYS   195      -5.695   6.190  17.864  1.00 28.15           O  
ATOM   1471  CB  LYS   195      -6.557   7.140  20.275  1.00 28.13           C  
ATOM   1472  CG  LYS   195      -6.727   8.370  21.094  1.00 36.83           C  
ATOM   1473  CD  LYS   195      -8.202   8.847  21.108  1.00 38.91           C  
ATOM   1474  CE  LYS   195      -8.420  10.211  20.514  1.00 50.63           C  
ATOM   1475  NZ  LYS   195      -9.752  10.881  20.750  1.00 53.49           N  
ATOM   1476  N   ALA   196      -4.888   4.461  18.873  1.00 33.64           N  
ATOM   1477  CA  ALA   196      -5.097   3.537  17.757  1.00 41.41           C  
ATOM   1478  C   ALA   196      -6.586   3.396  17.404  1.00 43.93           C  
ATOM   1479  O   ALA   196      -6.926   3.095  16.260  1.00 48.00           O  
ATOM   1480  CB  ALA   196      -4.494   2.188  18.068  1.00 40.11           C  
END
