
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  227 ( 1807),  selected  227 , name 1sui_A
# Molecule2: number of CA atoms  211 ( 1569),  selected  211 , name T0509.pdb
# PARAMETERS: 1sui_A.T0509.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K    21_A      -       -           -
LGA    S    22_A      -       -           -
LGA    L    23_A      -       -           -
LGA    L    24_A      N       3           #
LGA    Q    25_A      A       4          4.765
LGA    S    26_A      F       5          4.658
LGA    D    27_A      E       6          3.206
LGA    A    28_A      Y       7          3.113
LGA    L    29_A      L       8          3.374
LGA    Y    30_A      R       9          2.242
LGA    Q    31_A      T      10          1.489
LGA    Y    32_A      Y      11          2.146
LGA    I    33_A      V      12          2.524
LGA    L    34_A      E      13          1.639
LGA    E    35_A      S      14          1.788
LGA    T    36_A      T      15          3.005
LGA    S    37_A      -       -           -
LGA    V    38_A      -       -           -
LGA    F    39_A      -       -           -
LGA    P    40_A      T      16          2.728
LGA    R    41_A      E      17          2.445
LGA    E    42_A      T      18          4.346
LGA    H    43_A      D      19          3.118
LGA    E    44_A      A      20          2.414
LGA    A    45_A      A      21          1.129
LGA    M    46_A      V      22          0.726
LGA    K    47_A      A      23          1.343
LGA    E    48_A      R      24          1.675
LGA    L    49_A      A      25          1.301
LGA    R    50_A      R      26          1.165
LGA    E    51_A      E      27          1.788
LGA    V    52_A      D      28          2.271
LGA    T    53_A      A      29          2.242
LGA    A    54_A      A      30          2.335
LGA    K    55_A      E      31          1.862
LGA    H    56_A      F      32          1.848
LGA    P    57_A      G      33          3.102
LGA    W    58_A      L      34          3.784
LGA    N    59_A      -       -           -
LGA    I    60_A      -       -           -
LGA    M    61_A      P      35          0.827
LGA    T    62_A      A      36          1.071
LGA    T    63_A      P      37          1.495
LGA    S    64_A      D      38          1.109
LGA    A    65_A      E      39          1.127
LGA    D    66_A      M      40          0.901
LGA    E    67_A      T      41          0.538
LGA    G    68_A      G      42          0.550
LGA    Q    69_A      Q      43          0.697
LGA    F    70_A      L      44          0.748
LGA    L    71_A      L      45          0.570
LGA    S    72_A      T      46          0.462
LGA    M    73_A      T      47          1.280
LGA    L    74_A      L      48          1.642
LGA    L    75_A      A      49          1.257
LGA    K    76_A      A      50          0.939
LGA    L    77_A      T      51          1.720
LGA    I    78_A      T      52          1.998
LGA    N    79_A      N      53          3.837
LGA    A    80_A      G      54          3.781
LGA    -       -      N      55           -
LGA    -       -      G      56           -
LGA    K    81_A      S      57          5.459
LGA    N    82_A      T      58          2.919
LGA    T    83_A      G      59          3.038
LGA    -       -      A      60           -
LGA    M    84_A      I      61          1.274
LGA    E    85_A      A      62          1.624
LGA    I    86_A      I      63          1.433
LGA    G    87_A      T      64          1.616
LGA    V    88_A      P      65          3.720
LGA    Y    89_A      A      66          2.255
LGA    T    90_A      A      67          5.353
LGA    G    91_A      G      68          1.651
LGA    Y    92_A      L      69          1.049
LGA    S    93_A      V      70          0.790
LGA    L    94_A      G      71          1.217
LGA    L    95_A      L      72          1.656
LGA    A    96_A      Y      73          1.307
LGA    T    97_A      I      74          1.167
LGA    A    98_A      L      75          1.873
LGA    L    99_A      N      76          2.538
LGA    A   100_A      G      77          2.083
LGA    I   101_A      L      78          1.312
LGA    P   102_A      A      79          2.605
LGA    E   103_A      D      80          2.633
LGA    D   104_A      N      81          2.684
LGA    G   105_A      T      82          2.049
LGA    K   106_A      T      83          0.519
LGA    I   107_A      L      84          1.584
LGA    L   108_A      T      85          1.679
LGA    A   109_A      C      86          1.187
LGA    M   110_A      I      87          0.754
LGA    D   111_A      D      88          0.775
LGA    I   112_A      P      89          1.923
LGA    N   113_A      E      90          1.587
LGA    K   114_A      S      91          2.782
LGA    E   115_A      E      92          0.939
LGA    N   116_A      H      93          2.697
LGA    Y   117_A      Q      94          3.663
LGA    E   118_A      R      95          1.898
LGA    L   119_A      Q      96          2.517
LGA    G   120_A      A      97          4.196
LGA    L   121_A      K      98          2.984
LGA    P   122_A      A      99          2.142
LGA    V   123_A      L     100          2.291
LGA    I   124_A      F     101          1.353
LGA    K   125_A      R     102          0.581
LGA    K   126_A      E     103          1.474
LGA    A   127_A      A     104          1.114
LGA    G   128_A      G     105          2.025
LGA    V   129_A      Y     106          1.851
LGA    D   130_A      S     107          4.920
LGA    H   131_A      P     108          1.991
LGA    -       -      S     109           -
LGA    K   132_A      R     110          1.355
LGA    I   133_A      V     111          1.299
LGA    D   134_A      R     112          0.780
LGA    F   135_A      F     113          0.472
LGA    R   136_A      L     114          0.774
LGA    E   137_A      L     115          0.989
LGA    G   138_A      S     116          1.545
LGA    P   139_A      R     117          0.994
LGA    A   140_A      P     118          1.352
LGA    L   141_A      L     119          1.477
LGA    P   142_A      D     120          1.750
LGA    V   143_A      V     121          1.245
LGA    L   144_A      M     122          1.753
LGA    D   145_A      S     123          2.152
LGA    E   146_A      R     124          3.086
LGA    M   147_A      L     125          3.194
LGA    I   148_A      -       -           -
LGA    K   149_A      -       -           -
LGA    D   150_A      -       -           -
LGA    E   151_A      -       -           -
LGA    K   152_A      -       -           -
LGA    N   153_A      A     126          2.113
LGA    H   154_A      N     127          1.959
LGA    G   155_A      D     128          0.927
LGA    S   156_A      S     129          0.958
LGA    Y   157_A      Y     130          0.887
LGA    D   158_A      Q     131          0.987
LGA    F   159_A      L     132          1.005
LGA    I   160_A      V     133          1.165
LGA    F   161_A      F     134          1.218
LGA    V   162_A      G     135          1.457
LGA    D   163_A      Q     136          1.364
LGA    A   164_A      V     137          1.924
LGA    D   165_A      S     138          3.054
LGA    K   166_A      P     139          2.621
LGA    D   167_A      M     140          1.191
LGA    N   168_A      D     141          1.707
LGA    Y   169_A      L     142          1.857
LGA    L   170_A      K     143          1.154
LGA    N   171_A      A     144          1.442
LGA    Y   172_A      L     145          2.189
LGA    H   173_A      V     146          1.782
LGA    K   174_A      D     147          1.853
LGA    R   175_A      A     148          3.072
LGA    L   176_A      A     149          1.772
LGA    I   177_A      W     150          1.589
LGA    D   178_A      P     151          1.565
LGA    L   179_A      L     152          1.291
LGA    V   180_A      L     153          0.729
LGA    K   181_A      R     154          1.348
LGA    V   182_A      R     155          1.567
LGA    G   183_A      G     156          2.372
LGA    G   184_A      G     157          1.977
LGA    V   185_A      A     158          1.159
LGA    I   186_A      L     159          1.143
LGA    G   187_A      V     160          1.190
LGA    Y   188_A      L     161          1.461
LGA    D   189_A      A     162          1.465
LGA    N   190_A      D     163          0.968
LGA    T   191_A      A     164          1.933
LGA    L   192_A      L     165          1.840
LGA    W   193_A      L     166          1.272
LGA    N   194_A      D     167          2.879
LGA    G   195_A      G     168          3.095
LGA    S   196_A      T     169          2.065
LGA    V   197_A      I     170          2.061
LGA    V   198_A      A     171          4.881
LGA    A   199_A      D     172          5.448
LGA    P   200_A      Q     173           #
LGA    P   201_A      T     174          1.396
LGA    D   202_A      R     175           #
LGA    A   203_A      -       -           -
LGA    P   204_A      -       -           -
LGA    L   205_A      K     176           #
LGA    R   206_A      -       -           -
LGA    K   207_A      -       -           -
LGA    Y   208_A      -       -           -
LGA    V   209_A      -       -           -
LGA    R   210_A      D     177          4.224
LGA    Y   211_A      R     178          3.460
LGA    Y   212_A      D     179          2.086
LGA    R   213_A      T     180          1.565
LGA    D   214_A      Q     181          1.333
LGA    F   215_A      A     182          1.236
LGA    V   216_A      A     183          1.017
LGA    L   217_A      R     184          1.001
LGA    E   218_A      D     185          0.809
LGA    L   219_A      A     186          0.543
LGA    N   220_A      D     187          0.483
LGA    K   221_A      E     188          0.548
LGA    A   222_A      Y     189          0.737
LGA    L   223_A      I     190          0.880
LGA    A   224_A      R     191          1.031
LGA    V   225_A      S     192          1.430
LGA    D   226_A      I     193          0.936
LGA    P   227_A      E     194          1.062
LGA    R   228_A      G     195          2.908
LGA    I   229_A      A     196          0.906
LGA    E   230_A      H     197          1.226
LGA    I   231_A      V     198          1.048
LGA    C   232_A      A     199          0.734
LGA    M   233_A      R     200          0.703
LGA    L   234_A      L     201          1.400
LGA    P   235_A      P     202          1.293
LGA    V   236_A      L     203          1.636
LGA    G   237_A      G     204          2.121
LGA    D   238_A      A     205          2.321
LGA    G   239_A      G     206          2.220
LGA    I   240_A      L     207          1.934
LGA    T   241_A      T     208          1.389
LGA    I   242_A      V     209          1.535
LGA    C   243_A      V     210          1.184
LGA    R   244_A      T     211          1.596
LGA    R   245_A      K     212          1.077
LGA    I   246_A      A     213          2.579
LGA    K   247_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  227  211    5.0    203    2.11    17.24     75.132     9.199

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.778675 * X  +   0.096452 * Y  +   0.619970 * Z  + -30.741865
  Y_new =  -0.210676 * X  +   0.970939 * Y  +   0.113552 * Z  +  -5.219227
  Z_new =  -0.591001 * X  +  -0.219032 * Y  +   0.776365 * Z  + 168.110184 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.274979    2.866614  [ DEG:   -15.7551    164.2449 ]
  Theta =   0.632299    2.509294  [ DEG:    36.2280    143.7720 ]
  Phi   =  -0.264231    2.877362  [ DEG:   -15.1393    164.8607 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1sui_A                                        
REMARK     2: T0509.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1sui_A.T0509.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  227  211   5.0  203   2.11   17.24  75.132
REMARK  ---------------------------------------------------------- 
MOLECULE 1sui_A
HEADER    TRANSFERASE                             26-MAR-04   1SUI              
TITLE     ALFALFA CAFFEOYL COENZYME A 3-O-METHYLTRANSFERASE                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CAFFEOYL-COA O-METHYLTRANSFERASE;                          
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: TRANS-CAFFEOYL-COA 3-O-METHYLTRANSFERASE, CCOAMT,           
COMPND   5 CCOAOMT;                                                             
COMPND   6 EC: 2.1.1.104;                                                       
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MEDICAGO SATIVA;                                
SOURCE   3 ORGANISM_COMMON: ALFALFA;                                            
SOURCE   4 GENE: CCOMT;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    ROSSMANN FOLD, PROTEIN-COFACTOR-SUBSTRATE COMPLEX                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.-L.FERRER,C.ZUBIETA,R.A.DIXON,J.P.NOEL                              
REVDAT   2   29-MAR-05 1SUI    1       JRNL                                     
REVDAT   1   15-MAR-05 1SUI    0                                                
JRNL        AUTH   J.-L.FERRER,C.ZUBIETA,R.A.DIXON,J.P.NOEL                     
JRNL        TITL   CRYSTAL STRUCTURES OF ALFALFA CAFFEOYL COENZYME A            
JRNL        TITL 2 3-O-METHYLTRANSFERASE                                        
JRNL        REF    PLANT PHYSIOL.                V. 137  1009 2005              
JRNL        REFN   ASTM PLPHAY  US ISSN 1532-2548                               
REMARK   2 RESOLUTION. 2.70 ANGSTROMS.                                          
DBREF  1SUI A    1   247  UNP    Q40313   CAMT_MEDSA       1    247             
DBREF  1SUI B    1   247  UNP    Q40313   CAMT_MEDSA       1    247             
DBREF  1SUI C    1   247  UNP    Q40313   CAMT_MEDSA       1    247             
DBREF  1SUI D    1   247  UNP    Q40313   CAMT_MEDSA       1    247             
SEQRES   1 A  247  MET ALA THR ASN GLU ASP GLN LYS GLN THR GLU SER GLY          
SEQRES   2 A  247  ARG HIS GLN GLU VAL GLY HIS LYS SER LEU LEU GLN SER          
SEQRES   3 A  247  ASP ALA LEU TYR GLN TYR ILE LEU GLU THR SER VAL PHE          
SEQRES   4 A  247  PRO ARG GLU HIS GLU ALA MET LYS GLU LEU ARG GLU VAL          
SEQRES   5 A  247  THR ALA LYS HIS PRO TRP ASN ILE MET THR THR SER ALA          
SEQRES   6 A  247  ASP GLU GLY GLN PHE LEU SER MET LEU LEU LYS LEU ILE          
SEQRES   7 A  247  ASN ALA LYS ASN THR MET GLU ILE GLY VAL TYR THR GLY          
SEQRES   8 A  247  TYR SER LEU LEU ALA THR ALA LEU ALA ILE PRO GLU ASP          
SEQRES   9 A  247  GLY LYS ILE LEU ALA MET ASP ILE ASN LYS GLU ASN TYR          
SEQRES  10 A  247  GLU LEU GLY LEU PRO VAL ILE LYS LYS ALA GLY VAL ASP          
SEQRES  11 A  247  HIS LYS ILE ASP PHE ARG GLU GLY PRO ALA LEU PRO VAL          
SEQRES  12 A  247  LEU ASP GLU MET ILE LYS ASP GLU LYS ASN HIS GLY SER          
SEQRES  13 A  247  TYR ASP PHE ILE PHE VAL ASP ALA ASP LYS ASP ASN TYR          
SEQRES  14 A  247  LEU ASN TYR HIS LYS ARG LEU ILE ASP LEU VAL LYS VAL          
SEQRES  15 A  247  GLY GLY VAL ILE GLY TYR ASP ASN THR LEU TRP ASN GLY          
SEQRES  16 A  247  SER VAL VAL ALA PRO PRO ASP ALA PRO LEU ARG LYS TYR          
SEQRES  17 A  247  VAL ARG TYR TYR ARG ASP PHE VAL LEU GLU LEU ASN LYS          
SEQRES  18 A  247  ALA LEU ALA VAL ASP PRO ARG ILE GLU ILE CYS MET LEU          
SEQRES  19 A  247  PRO VAL GLY ASP GLY ILE THR ILE CYS ARG ARG ILE LYS          
SEQRES   1 B  247  MET ALA THR ASN GLU ASP GLN LYS GLN THR GLU SER GLY          
SEQRES   2 B  247  ARG HIS GLN GLU VAL GLY HIS LYS SER LEU LEU GLN SER          
SEQRES   3 B  247  ASP ALA LEU TYR GLN TYR ILE LEU GLU THR SER VAL PHE          
SEQRES   4 B  247  PRO ARG GLU HIS GLU ALA MET LYS GLU LEU ARG GLU VAL          
SEQRES   5 B  247  THR ALA LYS HIS PRO TRP ASN ILE MET THR THR SER ALA          
SEQRES   6 B  247  ASP GLU GLY GLN PHE LEU SER MET LEU LEU LYS LEU ILE          
SEQRES   7 B  247  ASN ALA LYS ASN THR MET GLU ILE GLY VAL TYR THR GLY          
SEQRES   8 B  247  TYR SER LEU LEU ALA THR ALA LEU ALA ILE PRO GLU ASP          
SEQRES   9 B  247  GLY LYS ILE LEU ALA MET ASP ILE ASN LYS GLU ASN TYR          
SEQRES  10 B  247  GLU LEU GLY LEU PRO VAL ILE LYS LYS ALA GLY VAL ASP          
SEQRES  11 B  247  HIS LYS ILE ASP PHE ARG GLU GLY PRO ALA LEU PRO VAL          
SEQRES  12 B  247  LEU ASP GLU MET ILE LYS ASP GLU LYS ASN HIS GLY SER          
SEQRES  13 B  247  TYR ASP PHE ILE PHE VAL ASP ALA ASP LYS ASP ASN TYR          
SEQRES  14 B  247  LEU ASN TYR HIS LYS ARG LEU ILE ASP LEU VAL LYS VAL          
SEQRES  15 B  247  GLY GLY VAL ILE GLY TYR ASP ASN THR LEU TRP ASN GLY          
SEQRES  16 B  247  SER VAL VAL ALA PRO PRO ASP ALA PRO LEU ARG LYS TYR          
SEQRES  17 B  247  VAL ARG TYR TYR ARG ASP PHE VAL LEU GLU LEU ASN LYS          
SEQRES  18 B  247  ALA LEU ALA VAL ASP PRO ARG ILE GLU ILE CYS MET LEU          
SEQRES  19 B  247  PRO VAL GLY ASP GLY ILE THR ILE CYS ARG ARG ILE LYS          
SEQRES   1 C  247  MET ALA THR ASN GLU ASP GLN LYS GLN THR GLU SER GLY          
SEQRES   2 C  247  ARG HIS GLN GLU VAL GLY HIS LYS SER LEU LEU GLN SER          
SEQRES   3 C  247  ASP ALA LEU TYR GLN TYR ILE LEU GLU THR SER VAL PHE          
SEQRES   4 C  247  PRO ARG GLU HIS GLU ALA MET LYS GLU LEU ARG GLU VAL          
SEQRES   5 C  247  THR ALA LYS HIS PRO TRP ASN ILE MET THR THR SER ALA          
SEQRES   6 C  247  ASP GLU GLY GLN PHE LEU SER MET LEU LEU LYS LEU ILE          
SEQRES   7 C  247  ASN ALA LYS ASN THR MET GLU ILE GLY VAL TYR THR GLY          
SEQRES   8 C  247  TYR SER LEU LEU ALA THR ALA LEU ALA ILE PRO GLU ASP          
SEQRES   9 C  247  GLY LYS ILE LEU ALA MET ASP ILE ASN LYS GLU ASN TYR          
SEQRES  10 C  247  GLU LEU GLY LEU PRO VAL ILE LYS LYS ALA GLY VAL ASP          
SEQRES  11 C  247  HIS LYS ILE ASP PHE ARG GLU GLY PRO ALA LEU PRO VAL          
SEQRES  12 C  247  LEU ASP GLU MET ILE LYS ASP GLU LYS ASN HIS GLY SER          
SEQRES  13 C  247  TYR ASP PHE ILE PHE VAL ASP ALA ASP LYS ASP ASN TYR          
SEQRES  14 C  247  LEU ASN TYR HIS LYS ARG LEU ILE ASP LEU VAL LYS VAL          
SEQRES  15 C  247  GLY GLY VAL ILE GLY TYR ASP ASN THR LEU TRP ASN GLY          
SEQRES  16 C  247  SER VAL VAL ALA PRO PRO ASP ALA PRO LEU ARG LYS TYR          
SEQRES  17 C  247  VAL ARG TYR TYR ARG ASP PHE VAL LEU GLU LEU ASN LYS          
SEQRES  18 C  247  ALA LEU ALA VAL ASP PRO ARG ILE GLU ILE CYS MET LEU          
SEQRES  19 C  247  PRO VAL GLY ASP GLY ILE THR ILE CYS ARG ARG ILE LYS          
SEQRES   1 D  247  MET ALA THR ASN GLU ASP GLN LYS GLN THR GLU SER GLY          
SEQRES   2 D  247  ARG HIS GLN GLU VAL GLY HIS LYS SER LEU LEU GLN SER          
SEQRES   3 D  247  ASP ALA LEU TYR GLN TYR ILE LEU GLU THR SER VAL PHE          
SEQRES   4 D  247  PRO ARG GLU HIS GLU ALA MET LYS GLU LEU ARG GLU VAL          
SEQRES   5 D  247  THR ALA LYS HIS PRO TRP ASN ILE MET THR THR SER ALA          
SEQRES   6 D  247  ASP GLU GLY GLN PHE LEU SER MET LEU LEU LYS LEU ILE          
SEQRES   7 D  247  ASN ALA LYS ASN THR MET GLU ILE GLY VAL TYR THR GLY          
SEQRES   8 D  247  TYR SER LEU LEU ALA THR ALA LEU ALA ILE PRO GLU ASP          
SEQRES   9 D  247  GLY LYS ILE LEU ALA MET ASP ILE ASN LYS GLU ASN TYR          
SEQRES  10 D  247  GLU LEU GLY LEU PRO VAL ILE LYS LYS ALA GLY VAL ASP          
SEQRES  11 D  247  HIS LYS ILE ASP PHE ARG GLU GLY PRO ALA LEU PRO VAL          
SEQRES  12 D  247  LEU ASP GLU MET ILE LYS ASP GLU LYS ASN HIS GLY SER          
SEQRES  13 D  247  TYR ASP PHE ILE PHE VAL ASP ALA ASP LYS ASP ASN TYR          
SEQRES  14 D  247  LEU ASN TYR HIS LYS ARG LEU ILE ASP LEU VAL LYS VAL          
SEQRES  15 D  247  GLY GLY VAL ILE GLY TYR ASP ASN THR LEU TRP ASN GLY          
SEQRES  16 D  247  SER VAL VAL ALA PRO PRO ASP ALA PRO LEU ARG LYS TYR          
SEQRES  17 D  247  VAL ARG TYR TYR ARG ASP PHE VAL LEU GLU LEU ASN LYS          
SEQRES  18 D  247  ALA LEU ALA VAL ASP PRO ARG ILE GLU ILE CYS MET LEU          
SEQRES  19 D  247  PRO VAL GLY ASP GLY ILE THR ILE CYS ARG ARG ILE LYS          
HET     CA  A 305       1                                                       
HET     CA  B 306       1                                                       
HET     CA  C 307       1                                                       
HET     CA  D 308       1                                                       
HET    SAH    301      26                                                       
HET    SAH    302      26                                                       
HET    SAH    303      26                                                       
HET    SAH    304      26                                                       
HET    FRE    305      62                                                       
HETNAM      CA CALCIUM ION                                                      
HETNAM     SAH S-ADENOSYL-L-HOMOCYSTEINE                                        
HETNAM     FRE FERULOYL COENZYME A                                              
FORMUL   5   CA    4(CA 2+)                                                     
FORMUL   9  SAH    4(C14 H20 N6 O5 S)                                           
FORMUL  13  FRE    C31 H44 N7 O20 P3 S                                          
FORMUL  14  HOH   *66(H2 O)                                                     
CRYST1   60.854  136.486  332.778  90.00  90.00  90.00 C 2 2 21     32          
ATOM      1  N   LYS A  21      21.633  35.072 167.284  1.00 97.33           N  
ATOM      2  CA  LYS A  21      21.351  35.850 168.528  1.00 97.42           C  
ATOM      3  C   LYS A  21      19.946  35.564 169.087  1.00 97.20           C  
ATOM      4  O   LYS A  21      19.282  34.599 168.672  1.00 98.03           O  
ATOM      5  CB  LYS A  21      21.515  37.353 168.254  1.00 97.16           C  
ATOM      6  CG  LYS A  21      22.912  37.734 167.794  1.00 97.34           C  
ATOM      7  CD  LYS A  21      23.155  39.233 167.845  1.00 97.96           C  
ATOM      8  CE  LYS A  21      24.593  39.550 167.442  1.00 98.33           C  
ATOM      9  NZ  LYS A  21      24.975  40.963 167.716  1.00 97.49           N  
ATOM     10  N   SER A  22      19.506  36.401 170.032  1.00 95.26           N  
ATOM     11  CA  SER A  22      18.190  36.268 170.667  1.00 91.68           C  
ATOM     12  C   SER A  22      17.676  37.623 171.147  1.00 88.96           C  
ATOM     13  O   SER A  22      18.348  38.642 170.987  1.00 88.47           O  
ATOM     14  CB  SER A  22      18.267  35.291 171.847  1.00 91.77           C  
ATOM     15  OG  SER A  22      19.404  35.556 172.655  1.00 91.42           O  
ATOM     16  N   LEU A  23      16.482  37.628 171.731  1.00 85.81           N  
ATOM     17  CA  LEU A  23      15.872  38.862 172.229  1.00 83.05           C  
ATOM     18  C   LEU A  23      16.215  39.163 173.683  1.00 80.88           C  
ATOM     19  O   LEU A  23      15.668  40.089 174.283  1.00 79.39           O  
ATOM     20  CB  LEU A  23      14.349  38.789 172.110  1.00 83.61           C  
ATOM     21  CG  LEU A  23      13.707  38.753 170.734  1.00 83.03           C  
ATOM     22  CD1 LEU A  23      12.204  38.874 170.901  1.00 83.17           C  
ATOM     23  CD2 LEU A  23      14.243  39.892 169.893  1.00 83.74           C  
ATOM     24  N   LEU A  24      17.113  38.374 174.252  1.00 79.15           N  
ATOM     25  CA  LEU A  24      17.498  38.568 175.635  1.00 77.55           C  
ATOM     26  C   LEU A  24      18.730  39.461 175.750  1.00 79.01           C  
ATOM     27  O   LEU A  24      19.265  39.933 174.747  1.00 79.59           O  
ATOM     28  CB  LEU A  24      17.724  37.205 176.296  1.00 73.47           C  
ATOM     29  CG  LEU A  24      16.455  36.351 176.385  1.00 68.70           C  
ATOM     30  CD1 LEU A  24      16.758  34.993 176.949  1.00 66.94           C  
ATOM     31  CD2 LEU A  24      15.453  37.052 177.251  1.00 68.66           C  
ATOM     32  N   GLN A  25      19.169  39.698 176.979  1.00 80.66           N  
ATOM     33  CA  GLN A  25      20.315  40.559 177.235  1.00 81.80           C  
ATOM     34  C   GLN A  25      21.669  39.960 176.863  1.00 82.33           C  
ATOM     35  O   GLN A  25      22.597  40.687 176.529  1.00 83.10           O  
ATOM     36  CB  GLN A  25      20.325  40.963 178.711  1.00 82.73           C  
ATOM     37  CG  GLN A  25      20.495  39.799 179.683  1.00 83.80           C  
ATOM     38  CD  GLN A  25      20.213  40.192 181.129  1.00 84.47           C  
ATOM     39  OE1 GLN A  25      20.353  39.378 182.044  1.00 84.51           O  
ATOM     40  NE2 GLN A  25      19.804  41.444 181.337  1.00 84.05           N  
ATOM     41  N   SER A  26      21.790  38.640 176.915  1.00 82.34           N  
ATOM     42  CA  SER A  26      23.061  38.007 176.599  1.00 82.75           C  
ATOM     43  C   SER A  26      22.867  36.655 175.939  1.00 82.92           C  
ATOM     44  O   SER A  26      21.861  35.984 176.168  1.00 82.66           O  
ATOM     45  CB  SER A  26      23.870  37.825 177.881  1.00 84.01           C  
ATOM     46  OG  SER A  26      23.158  37.025 178.814  1.00 84.96           O  
ATOM     47  N   ASP A  27      23.838  36.246 175.131  1.00 82.99           N  
ATOM     48  CA  ASP A  27      23.745  34.959 174.464  1.00 83.79           C  
ATOM     49  C   ASP A  27      23.965  33.830 175.462  1.00 83.31           C  
ATOM     50  O   ASP A  27      23.648  32.670 175.177  1.00 84.11           O  
ATOM     51  CB  ASP A  27      24.772  34.852 173.334  1.00 85.69           C  
ATOM     52  CG  ASP A  27      24.555  35.888 172.250  1.00 88.59           C  
ATOM     53  OD1 ASP A  27      23.417  35.981 171.735  1.00 90.40           O  
ATOM     54  OD2 ASP A  27      25.522  36.607 171.908  1.00 90.52           O  
ATOM     55  N   ALA A  28      24.502  34.162 176.633  1.00 80.69           N  
ATOM     56  CA  ALA A  28      24.746  33.137 177.631  1.00 78.66           C  
ATOM     57  C   ALA A  28      23.526  32.888 178.508  1.00 77.57           C  
ATOM     58  O   ALA A  28      23.337  31.776 178.998  1.00 77.76           O  
ATOM     59  CB  ALA A  28      25.929  33.507 178.474  1.00 77.87           C  
ATOM     60  N   LEU A  29      22.696  33.911 178.703  1.00 75.75           N  
ATOM     61  CA  LEU A  29      21.497  33.750 179.525  1.00 75.25           C  
ATOM     62  C   LEU A  29      20.551  32.855 178.749  1.00 75.47           C  
ATOM     63  O   LEU A  29      19.960  31.914 179.290  1.00 74.30           O  
ATOM     64  CB  LEU A  29      20.812  35.097 179.773  1.00 74.12           C  
ATOM     65  CG  LEU A  29      19.781  35.219 180.910  1.00 73.13           C  
ATOM     66  CD1 LEU A  29      18.971  36.470 180.671  1.00 72.81           C  
ATOM     67  CD2 LEU A  29      18.850  34.026 180.981  1.00 73.79           C  
ATOM     68  N   TYR A  30      20.412  33.172 177.466  1.00 76.17           N  
ATOM     69  CA  TYR A  30      19.550  32.414 176.581  1.00 77.16           C  
ATOM     70  C   TYR A  30      20.012  30.961 176.553  1.00 77.68           C  
ATOM     71  O   TYR A  30      19.213  30.028 176.727  1.00 78.55           O  
ATOM     72  CB  TYR A  30      19.589  33.005 175.173  1.00 77.72           C  
ATOM     73  CG  TYR A  30      18.757  32.223 174.194  1.00 79.24           C  
ATOM     74  CD1 TYR A  30      17.391  32.036 174.410  1.00 80.37           C  
ATOM     75  CD2 TYR A  30      19.341  31.620 173.087  1.00 79.30           C  
ATOM     76  CE1 TYR A  30      16.629  31.260 173.551  1.00 81.25           C  
ATOM     77  CE2 TYR A  30      18.589  30.845 172.220  1.00 80.67           C  
ATOM     78  CZ  TYR A  30      17.236  30.666 172.459  1.00 81.46           C  
ATOM     79  OH  TYR A  30      16.491  29.882 171.611  1.00 83.57           O  
ATOM     80  N   GLN A  31      21.310  30.773 176.343  1.00 76.58           N  
ATOM     81  CA  GLN A  31      21.867  29.434 176.309  1.00 75.38           C  
ATOM     82  C   GLN A  31      21.534  28.672 177.589  1.00 73.64           C  
ATOM     83  O   GLN A  31      21.194  27.485 177.542  1.00 72.85           O  
ATOM     84  CB  GLN A  31      23.377  29.508 176.103  1.00 77.36           C  
ATOM     85  CG  GLN A  31      23.802  29.543 174.637  1.00 79.73           C  
ATOM     86  CD  GLN A  31      23.485  28.244 173.917  1.00 82.01           C  
ATOM     87  OE1 GLN A  31      22.341  27.997 173.531  1.00 83.61           O  
ATOM     88  NE2 GLN A  31      24.497  27.394 173.749  1.00 83.08           N  
ATOM     89  N   TYR A  32      21.617  29.363 178.725  1.00 72.08           N  
ATOM     90  CA  TYR A  32      21.318  28.757 180.023  1.00 70.80           C  
ATOM     91  C   TYR A  32      19.929  28.133 180.022  1.00 69.04           C  
ATOM     92  O   TYR A  32      19.737  27.044 180.559  1.00 68.57           O  
ATOM     93  CB  TYR A  32      21.412  29.805 181.149  1.00 71.83           C  
ATOM     94  CG  TYR A  32      20.909  29.325 182.503  1.00 71.29           C  
ATOM     95  CD1 TYR A  32      21.565  28.309 183.200  1.00 71.53           C  
ATOM     96  CD2 TYR A  32      19.747  29.856 183.061  1.00 70.97           C  
ATOM     97  CE1 TYR A  32      21.068  27.831 184.414  1.00 71.68           C  
ATOM     98  CE2 TYR A  32      19.243  29.386 184.270  1.00 71.62           C  
ATOM     99  CZ  TYR A  32      19.905  28.374 184.939  1.00 72.10           C  
ATOM    100  OH  TYR A  32      19.386  27.894 186.120  1.00 73.15           O  
ATOM    101  N   ILE A  33      18.967  28.821 179.414  1.00 67.71           N  
ATOM    102  CA  ILE A  33      17.596  28.324 179.359  1.00 66.49           C  
ATOM    103  C   ILE A  33      17.525  27.051 178.533  1.00 67.14           C  
ATOM    104  O   ILE A  33      16.847  26.083 178.898  1.00 66.45           O  
ATOM    105  CB  ILE A  33      16.661  29.374 178.749  1.00 64.19           C  
ATOM    106  CG1 ILE A  33      16.760  30.670 179.553  1.00 64.03           C  
ATOM    107  CG2 ILE A  33      15.240  28.867 178.766  1.00 63.81           C  
ATOM    108  CD1 ILE A  33      15.862  31.781 179.082  1.00 61.59           C  
ATOM    109  N   LEU A  34      18.252  27.063 177.421  1.00 67.86           N  
ATOM    110  CA  LEU A  34      18.305  25.935 176.500  1.00 68.16           C  
ATOM    111  C   LEU A  34      18.990  24.730 177.110  1.00 68.59           C  
ATOM    112  O   LEU A  34      18.454  23.616 177.100  1.00 67.15           O  
ATOM    113  CB  LEU A  34      19.058  26.346 175.245  1.00 67.53           C  
ATOM    114  CG  LEU A  34      18.434  27.548 174.556  1.00 68.26           C  
ATOM    115  CD1 LEU A  34      19.402  28.112 173.545  1.00 68.15           C  
ATOM    116  CD2 LEU A  34      17.123  27.130 173.912  1.00 67.89           C  
ATOM    117  N   GLU A  35      20.189  24.962 177.631  1.00 70.07           N  
ATOM    118  CA  GLU A  35      20.967  23.893 178.229  1.00 72.53           C  
ATOM    119  C   GLU A  35      20.352  23.279 179.485  1.00 72.28           C  
ATOM    120  O   GLU A  35      20.582  22.106 179.775  1.00 72.82           O  
ATOM    121  CB  GLU A  35      22.393  24.381 178.531  1.00 74.10           C  
ATOM    122  CG  GLU A  35      23.321  24.488 177.297  1.00 77.76           C  
ATOM    123  CD  GLU A  35      23.498  23.158 176.541  1.00 79.60           C  
ATOM    124  OE1 GLU A  35      23.572  22.094 177.199  1.00 81.32           O  
ATOM    125  OE2 GLU A  35      23.579  23.172 175.290  1.00 79.77           O  
ATOM    126  N   THR A  36      19.548  24.042 180.217  1.00 72.02           N  
ATOM    127  CA  THR A  36      18.980  23.502 181.440  1.00 72.08           C  
ATOM    128  C   THR A  36      17.529  23.067 181.393  1.00 71.48           C  
ATOM    129  O   THR A  36      17.175  22.064 182.003  1.00 72.75           O  
ATOM    130  CB  THR A  36      19.139  24.490 182.629  1.00 73.02           C  
ATOM    131  OG1 THR A  36      18.282  25.623 182.435  1.00 73.81           O  
ATOM    132  CG2 THR A  36      20.600  24.960 182.750  1.00 73.31           C  
ATOM    133  N   SER A  37      16.677  23.791 180.682  1.00 70.65           N  
ATOM    134  CA  SER A  37      15.276  23.399 180.675  1.00 69.75           C  
ATOM    135  C   SER A  37      14.682  23.069 179.328  1.00 69.05           C  
ATOM    136  O   SER A  37      13.480  22.833 179.232  1.00 68.47           O  
ATOM    137  CB  SER A  37      14.443  24.480 181.325  1.00 70.26           C  
ATOM    138  OG  SER A  37      14.655  25.693 180.639  1.00 74.24           O  
ATOM    139  N   VAL A  38      15.507  23.049 178.286  1.00 68.99           N  
ATOM    140  CA  VAL A  38      14.996  22.713 176.960  1.00 68.07           C  
ATOM    141  C   VAL A  38      15.624  21.451 176.362  1.00 66.94           C  
ATOM    142  O   VAL A  38      14.954  20.429 176.231  1.00 66.00           O  
ATOM    143  CB  VAL A  38      15.175  23.886 175.954  1.00 68.40           C  
ATOM    144  CG1 VAL A  38      14.515  23.534 174.631  1.00 66.22           C  
ATOM    145  CG2 VAL A  38      14.574  25.173 176.523  1.00 66.81           C  
ATOM    146  N   PHE A  39      16.905  21.506 176.020  1.00 66.81           N  
ATOM    147  CA  PHE A  39      17.546  20.351 175.400  1.00 68.32           C  
ATOM    148  C   PHE A  39      17.345  19.007 176.110  1.00 70.61           C  
ATOM    149  O   PHE A  39      16.949  18.019 175.485  1.00 70.10           O  
ATOM    150  CB  PHE A  39      19.033  20.633 175.176  1.00 65.35           C  
ATOM    151  CG  PHE A  39      19.289  21.800 174.272  1.00 63.20           C  
ATOM    152  CD1 PHE A  39      18.500  22.008 173.145  1.00 62.78           C  
ATOM    153  CD2 PHE A  39      20.309  22.697 174.545  1.00 62.53           C  
ATOM    154  CE1 PHE A  39      18.721  23.099 172.302  1.00 62.66           C  
ATOM    155  CE2 PHE A  39      20.543  23.796 173.707  1.00 63.56           C  
ATOM    156  CZ  PHE A  39      19.745  23.997 172.584  1.00 62.52           C  
ATOM    157  N   PRO A  40      17.627  18.944 177.420  1.00 73.25           N  
ATOM    158  CA  PRO A  40      17.440  17.675 178.134  1.00 74.89           C  
ATOM    159  C   PRO A  40      15.955  17.355 178.123  1.00 77.18           C  
ATOM    160  O   PRO A  40      15.145  18.152 178.602  1.00 78.63           O  
ATOM    161  CB  PRO A  40      17.939  17.998 179.533  1.00 74.68           C  
ATOM    162  CG  PRO A  40      18.971  19.076 179.279  1.00 74.19           C  
ATOM    163  CD  PRO A  40      18.276  19.944 178.285  1.00 73.38           C  
ATOM    164  N   ARG A  41      15.585  16.201 177.585  1.00 79.16           N  
ATOM    165  CA  ARG A  41      14.163  15.832 177.509  1.00 81.15           C  
ATOM    166  C   ARG A  41      13.476  16.670 176.436  1.00 80.78           C  
ATOM    167  O   ARG A  41      12.710  17.580 176.760  1.00 81.52           O  
ATOM    168  CB  ARG A  41      13.422  16.110 178.827  1.00 83.33           C  
ATOM    169  CG  ARG A  41      14.138  15.704 180.108  1.00 84.85           C  
ATOM    170  CD  ARG A  41      13.390  16.235 181.323  1.00 85.05           C  
ATOM    171  NE  ARG A  41      12.068  15.632 181.463  1.00 86.40           N  
ATOM    172  CZ  ARG A  41      11.128  16.064 182.302  1.00 87.99           C  
ATOM    173  NH1 ARG A  41      11.351  17.115 183.091  1.00 87.35           N  
ATOM    174  NH2 ARG A  41       9.958  15.440 182.358  1.00 89.24           N  
ATOM    175  N   GLU A  42      13.762  16.383 175.171  1.00 80.02           N  
ATOM    176  CA  GLU A  42      13.130  17.101 174.075  1.00 79.09           C  
ATOM    177  C   GLU A  42      12.960  16.124 172.926  1.00 77.83           C  
ATOM    178  O   GLU A  42      13.547  16.232 171.847  1.00 78.64           O  
ATOM    179  CB  GLU A  42      13.963  18.312 173.647  1.00 79.48           C  
ATOM    180  CG  GLU A  42      15.165  17.974 172.823  1.00 81.58           C  
ATOM    181  CD  GLU A  42      15.651  19.161 172.023  1.00 82.01           C  
ATOM    182  OE1 GLU A  42      14.805  19.873 171.428  1.00 81.43           O  
ATOM    183  OE2 GLU A  42      16.880  19.366 171.986  1.00 82.19           O  
ATOM    184  N   HIS A  43      12.136  15.136 173.194  1.00 75.06           N  
ATOM    185  CA  HIS A  43      11.832  14.101 172.234  1.00 72.49           C  
ATOM    186  C   HIS A  43      12.969  13.414 171.446  1.00 72.22           C  
ATOM    187  O   HIS A  43      13.151  12.190 171.562  1.00 72.20           O  
ATOM    188  CB  HIS A  43      10.769  14.588 171.260  1.00 67.45           C  
ATOM    189  CG  HIS A  43       9.963  13.466 170.708  1.00 64.23           C  
ATOM    190  ND1 HIS A  43      10.458  12.612 169.746  1.00 62.12           N  
ATOM    191  CD2 HIS A  43       8.798  12.921 171.132  1.00 63.28           C  
ATOM    192  CE1 HIS A  43       9.641  11.585 169.612  1.00 62.83           C  
ATOM    193  NE2 HIS A  43       8.626  11.746 170.445  1.00 62.79           N  
ATOM    194  N   GLU A  44      13.695  14.181 170.633  1.00 70.05           N  
ATOM    195  CA  GLU A  44      14.811  13.693 169.822  1.00 68.82           C  
ATOM    196  C   GLU A  44      14.514  14.072 168.394  1.00 66.28           C  
ATOM    197  O   GLU A  44      15.384  14.582 167.693  1.00 65.76           O  
ATOM    198  CB  GLU A  44      14.982  12.168 169.897  1.00 72.02           C  
ATOM    199  CG  GLU A  44      13.988  11.377 169.043  1.00 77.87           C  
ATOM    200  CD  GLU A  44      14.311   9.887 168.980  1.00 81.07           C  
ATOM    201  OE1 GLU A  44      14.229   9.217 170.038  1.00 82.78           O  
ATOM    202  OE2 GLU A  44      14.648   9.389 167.876  1.00 82.42           O  
ATOM    203  N   ALA A  45      13.272  13.825 167.975  1.00 63.07           N  
ATOM    204  CA  ALA A  45      12.828  14.166 166.631  1.00 60.16           C  
ATOM    205  C   ALA A  45      13.158  15.629 166.379  1.00 58.80           C  
ATOM    206  O   ALA A  45      13.574  16.007 165.287  1.00 57.88           O  
ATOM    207  CB  ALA A  45      11.345  13.942 166.508  1.00 59.10           C  
ATOM    208  N   MET A  46      12.965  16.447 167.406  1.00 58.35           N  
ATOM    209  CA  MET A  46      13.260  17.866 167.325  1.00 58.64           C  
ATOM    210  C   MET A  46      14.765  18.000 167.141  1.00 59.22           C  
ATOM    211  O   MET A  46      15.237  18.806 166.356  1.00 59.34           O  
ATOM    212  CB  MET A  46      12.857  18.572 168.615  1.00 58.18           C  
ATOM    213  CG  MET A  46      11.515  18.176 169.172  1.00 59.00           C  
ATOM    214  SD  MET A  46      10.173  18.560 168.064  1.00 61.09           S  
ATOM    215  CE  MET A  46      10.350  20.257 167.923  1.00 61.66           C  
ATOM    216  N   LYS A  47      15.518  17.197 167.875  1.00 61.24           N  
ATOM    217  CA  LYS A  47      16.966  17.236 167.788  1.00 63.54           C  
ATOM    218  C   LYS A  47      17.365  16.921 166.348  1.00 63.74           C  
ATOM    219  O   LYS A  47      18.158  17.639 165.741  1.00 63.78           O  
ATOM    220  CB  LYS A  47      17.562  16.203 168.747  1.00 67.03           C  
ATOM    221  CG  LYS A  47      18.985  16.491 169.230  1.00 71.05           C  
ATOM    222  CD  LYS A  47      19.373  15.551 170.400  1.00 74.71           C  
ATOM    223  CE  LYS A  47      18.476  15.729 171.659  1.00 76.84           C  
ATOM    224  NZ  LYS A  47      18.684  17.022 172.407  1.00 77.29           N  
ATOM    225  N   GLU A  48      16.803  15.849 165.802  1.00 62.80           N  
ATOM    226  CA  GLU A  48      17.109  15.449 164.440  1.00 62.37           C  
ATOM    227  C   GLU A  48      16.766  16.566 163.492  1.00 61.52           C  
ATOM    228  O   GLU A  48      17.642  17.176 162.889  1.00 61.39           O  
ATOM    229  CB  GLU A  48      16.291  14.229 164.029  1.00 65.13           C  
ATOM    230  CG  GLU A  48      16.655  12.933 164.711  1.00 69.74           C  
ATOM    231  CD  GLU A  48      15.737  11.797 164.294  1.00 73.23           C  
ATOM    232  OE1 GLU A  48      15.641  11.525 163.071  1.00 74.53           O  
ATOM    233  OE2 GLU A  48      15.113  11.178 165.191  1.00 74.75           O  
ATOM    234  N   LEU A  49      15.467  16.815 163.363  1.00 60.79           N  
ATOM    235  CA  LEU A  49      14.951  17.839 162.465  1.00 59.02           C  
ATOM    236  C   LEU A  49      15.736  19.143 162.552  1.00 58.88           C  
ATOM    237  O   LEU A  49      15.949  19.820 161.545  1.00 58.47           O  
ATOM    238  CB  LEU A  49      13.471  18.086 162.748  1.00 56.50           C  
ATOM    239  CG  LEU A  49      12.814  19.053 161.767  1.00 56.78           C  
ATOM    240  CD1 LEU A  49      13.091  18.617 160.345  1.00 56.85           C  
ATOM    241  CD2 LEU A  49      11.330  19.101 162.023  1.00 56.81           C  
ATOM    242  N   ARG A  50      16.181  19.485 163.751  1.00 58.27           N  
ATOM    243  CA  ARG A  50      16.944  20.703 163.945  1.00 58.97           C  
ATOM    244  C   ARG A  50      18.323  20.575 163.304  1.00 59.30           C  
ATOM    245  O   ARG A  50      18.955  21.575 162.989  1.00 60.01           O  
ATOM    246  CB  ARG A  50      17.067  21.003 165.443  1.00 59.14           C  
ATOM    247  CG  ARG A  50      17.719  22.325 165.783  1.00 60.84           C  
ATOM    248  CD  ARG A  50      17.358  22.783 167.193  1.00 63.24           C  
ATOM    249  NE  ARG A  50      17.706  21.796 168.210  1.00 66.02           N  
ATOM    250  CZ  ARG A  50      16.821  21.158 168.977  1.00 68.32           C  
ATOM    251  NH1 ARG A  50      15.518  21.398 168.859  1.00 67.66           N  
ATOM    252  NH2 ARG A  50      17.240  20.257 169.859  1.00 68.08           N  
ATOM    253  N   GLU A  51      18.773  19.339 163.102  1.00 60.69           N  
ATOM    254  CA  GLU A  51      20.075  19.051 162.494  1.00 61.83           C  
ATOM    255  C   GLU A  51      19.980  19.077 160.979  1.00 60.82           C  
ATOM    256  O   GLU A  51      20.868  19.595 160.287  1.00 61.19           O  
ATOM    257  CB  GLU A  51      20.567  17.676 162.928  1.00 65.36           C  
ATOM    258  CG  GLU A  51      21.269  17.648 164.269  1.00 71.19           C  
ATOM    259  CD  GLU A  51      21.601  16.229 164.704  1.00 74.40           C  
ATOM    260  OE1 GLU A  51      21.911  15.390 163.820  1.00 75.16           O  
ATOM    261  OE2 GLU A  51      21.558  15.959 165.929  1.00 76.03           O  
ATOM    262  N   VAL A  52      18.905  18.483 160.475  1.00 58.60           N  
ATOM    263  CA  VAL A  52      18.619  18.445 159.050  1.00 55.89           C  
ATOM    264  C   VAL A  52      18.540  19.891 158.549  1.00 56.44           C  
ATOM    265  O   VAL A  52      19.221  20.274 157.604  1.00 57.06           O  
ATOM    266  CB  VAL A  52      17.266  17.748 158.814  1.00 54.44           C  
ATOM    267  CG1 VAL A  52      16.730  18.057 157.437  1.00 53.55           C  
ATOM    268  CG2 VAL A  52      17.425  16.267 159.014  1.00 52.52           C  
ATOM    269  N   THR A  53      17.722  20.694 159.224  1.00 56.10           N  
ATOM    270  CA  THR A  53      17.512  22.088 158.862  1.00 55.56           C  
ATOM    271  C   THR A  53      18.766  22.928 158.954  1.00 55.88           C  
ATOM    272  O   THR A  53      18.920  23.889 158.209  1.00 56.03           O  
ATOM    273  CB  THR A  53      16.400  22.724 159.746  1.00 55.36           C  
ATOM    274  OG1 THR A  53      15.208  21.944 159.635  1.00 53.00           O  
ATOM    275  CG2 THR A  53      16.071  24.143 159.299  1.00 53.73           C  
ATOM    276  N   ALA A  54      19.677  22.569 159.848  1.00 57.04           N  
ATOM    277  CA  ALA A  54      20.902  23.354 160.000  1.00 59.06           C  
ATOM    278  C   ALA A  54      21.768  23.432 158.750  1.00 60.34           C  
ATOM    279  O   ALA A  54      22.554  24.362 158.606  1.00 59.80           O  
ATOM    280  CB  ALA A  54      21.722  22.824 161.156  1.00 58.55           C  
ATOM    281  N   LYS A  55      21.624  22.462 157.850  1.00 63.09           N  
ATOM    282  CA  LYS A  55      22.408  22.431 156.617  1.00 66.14           C  
ATOM    283  C   LYS A  55      21.761  23.237 155.478  1.00 67.04           C  
ATOM    284  O   LYS A  55      22.396  23.525 154.453  1.00 67.11           O  
ATOM    285  CB  LYS A  55      22.620  20.976 156.178  1.00 68.43           C  
ATOM    286  CG  LYS A  55      23.546  20.798 154.954  1.00 73.68           C  
ATOM    287  CD  LYS A  55      22.817  21.013 153.614  1.00 75.44           C  
ATOM    288  CE  LYS A  55      23.732  20.767 152.418  1.00 76.43           C  
ATOM    289  NZ  LYS A  55      22.960  20.581 151.146  1.00 77.20           N  
ATOM    290  N   HIS A  56      20.500  23.606 155.680  1.00 67.71           N  
ATOM    291  CA  HIS A  56      19.727  24.361 154.700  1.00 67.74           C  
ATOM    292  C   HIS A  56      20.077  25.848 154.766  1.00 68.06           C  
ATOM    293  O   HIS A  56      20.241  26.413 155.849  1.00 68.07           O  
ATOM    294  CB  HIS A  56      18.239  24.139 154.975  1.00 67.99           C  
ATOM    295  CG  HIS A  56      17.343  24.509 153.836  1.00 68.80           C  
ATOM    296  ND1 HIS A  56      17.015  25.815 153.537  1.00 68.46           N  
ATOM    297  CD2 HIS A  56      16.678  23.739 152.942  1.00 68.22           C  
ATOM    298  CE1 HIS A  56      16.184  25.833 152.511  1.00 68.91           C  
ATOM    299  NE2 HIS A  56      15.962  24.587 152.131  1.00 68.42           N  
ATOM    300  N   PRO A  57      20.187  26.503 153.599  1.00 68.58           N  
ATOM    301  CA  PRO A  57      20.522  27.927 153.453  1.00 68.54           C  
ATOM    302  C   PRO A  57      19.720  28.908 154.309  1.00 68.59           C  
ATOM    303  O   PRO A  57      20.297  29.735 155.010  1.00 69.18           O  
ATOM    304  CB  PRO A  57      20.304  28.188 151.964  1.00 68.17           C  
ATOM    305  CG  PRO A  57      20.572  26.869 151.348  1.00 68.97           C  
ATOM    306  CD  PRO A  57      19.899  25.902 152.284  1.00 68.20           C  
ATOM    307  N   TRP A  58      18.393  28.824 154.242  1.00 68.58           N  
ATOM    308  CA  TRP A  58      17.546  29.743 154.994  1.00 68.05           C  
ATOM    309  C   TRP A  58      17.215  29.276 156.392  1.00 66.28           C  
ATOM    310  O   TRP A  58      16.187  29.650 156.949  1.00 65.04           O  
ATOM    311  CB  TRP A  58      16.259  30.019 154.210  1.00 70.55           C  
ATOM    312  CG  TRP A  58      16.521  30.757 152.935  1.00 73.18           C  
ATOM    313  CD1 TRP A  58      17.011  32.034 152.802  1.00 74.21           C  
ATOM    314  CD2 TRP A  58      16.406  30.235 151.613  1.00 74.40           C  
ATOM    315  NE1 TRP A  58      17.216  32.331 151.475  1.00 74.91           N  
ATOM    316  CE2 TRP A  58      16.854  31.244 150.722  1.00 75.49           C  
ATOM    317  CE3 TRP A  58      15.969  29.012 151.091  1.00 75.65           C  
ATOM    318  CZ2 TRP A  58      16.880  31.063 149.337  1.00 76.50           C  
ATOM    319  CZ3 TRP A  58      15.990  28.829 149.712  1.00 78.00           C  
ATOM    320  CH2 TRP A  58      16.444  29.853 148.849  1.00 78.15           C  
ATOM    321  N   ASN A  59      18.105  28.480 156.970  1.00 64.96           N  
ATOM    322  CA  ASN A  59      17.877  27.959 158.309  1.00 64.89           C  
ATOM    323  C   ASN A  59      17.582  29.043 159.359  1.00 63.57           C  
ATOM    324  O   ASN A  59      17.100  28.738 160.452  1.00 63.86           O  
ATOM    325  CB  ASN A  59      19.070  27.105 158.748  1.00 65.17           C  
ATOM    326  CG  ASN A  59      20.315  27.921 158.979  1.00 66.60           C  
ATOM    327  OD1 ASN A  59      20.416  28.650 159.967  1.00 67.20           O  
ATOM    328  ND2 ASN A  59      21.274  27.812 158.066  1.00 67.08           N  
ATOM    329  N   ILE A  60      17.844  30.303 159.031  1.00 60.99           N  
ATOM    330  CA  ILE A  60      17.590  31.374 159.984  1.00 59.69           C  
ATOM    331  C   ILE A  60      16.117  31.500 160.357  1.00 59.29           C  
ATOM    332  O   ILE A  60      15.776  32.083 161.392  1.00 59.74           O  
ATOM    333  CB  ILE A  60      18.048  32.734 159.445  1.00 59.80           C  
ATOM    334  CG1 ILE A  60      17.829  33.807 160.510  1.00 60.55           C  
ATOM    335  CG2 ILE A  60      17.268  33.092 158.189  1.00 58.79           C  
ATOM    336  CD1 ILE A  60      18.181  35.194 160.047  1.00 61.05           C  
ATOM    337  N   MET A  61      15.248  30.945 159.518  1.00 57.76           N  
ATOM    338  CA  MET A  61      13.812  31.031 159.743  1.00 55.35           C  
ATOM    339  C   MET A  61      13.254  29.973 160.680  1.00 54.02           C  
ATOM    340  O   MET A  61      12.164  30.128 161.222  1.00 55.50           O  
ATOM    341  CB  MET A  61      13.082  30.955 158.407  1.00 54.74           C  
ATOM    342  CG  MET A  61      13.532  32.000 157.408  1.00 55.55           C  
ATOM    343  SD  MET A  61      12.569  32.009 155.874  1.00 58.21           S  
ATOM    344  CE  MET A  61      12.315  30.192 155.598  1.00 57.38           C  
ATOM    345  N   THR A  62      13.990  28.895 160.889  1.00 51.59           N  
ATOM    346  CA  THR A  62      13.479  27.854 161.765  1.00 51.36           C  
ATOM    347  C   THR A  62      13.134  28.356 163.168  1.00 51.56           C  
ATOM    348  O   THR A  62      13.870  29.123 163.777  1.00 52.62           O  
ATOM    349  CB  THR A  62      14.480  26.702 161.903  1.00 50.85           C  
ATOM    350  OG1 THR A  62      13.865  25.613 162.600  1.00 48.53           O  
ATOM    351  CG2 THR A  62      15.701  27.160 162.668  1.00 50.72           C  
ATOM    352  N   THR A  63      11.995  27.930 163.674  1.00 51.11           N  
ATOM    353  CA  THR A  63      11.592  28.308 165.010  1.00 52.89           C  
ATOM    354  C   THR A  63      12.664  27.852 166.016  1.00 52.81           C  
ATOM    355  O   THR A  63      13.278  26.797 165.838  1.00 51.49           O  
ATOM    356  CB  THR A  63      10.224  27.657 165.332  1.00 54.57           C  
ATOM    357  OG1 THR A  63       9.188  28.454 164.743  1.00 58.07           O  
ATOM    358  CG2 THR A  63       9.994  27.525 166.835  1.00 54.93           C  
ATOM    359  N   SER A  64      12.888  28.652 167.062  1.00 52.90           N  
ATOM    360  CA  SER A  64      13.874  28.324 168.096  1.00 53.51           C  
ATOM    361  C   SER A  64      13.398  27.189 169.012  1.00 53.11           C  
ATOM    362  O   SER A  64      12.193  26.957 169.160  1.00 51.52           O  
ATOM    363  CB  SER A  64      14.184  29.558 168.945  1.00 55.22           C  
ATOM    364  OG  SER A  64      13.021  30.015 169.621  1.00 59.32           O  
ATOM    365  N   ALA A  65      14.354  26.494 169.626  1.00 52.46           N  
ATOM    366  CA  ALA A  65      14.050  25.380 170.514  1.00 53.41           C  
ATOM    367  C   ALA A  65      13.193  25.782 171.724  1.00 54.20           C  
ATOM    368  O   ALA A  65      12.315  25.019 172.149  1.00 54.00           O  
ATOM    369  CB  ALA A  65      15.343  24.727 170.980  1.00 53.14           C  
ATOM    370  N   ASP A  66      13.438  26.966 172.281  1.00 53.60           N  
ATOM    371  CA  ASP A  66      12.655  27.419 173.427  1.00 54.31           C  
ATOM    372  C   ASP A  66      11.224  27.781 173.031  1.00 53.97           C  
ATOM    373  O   ASP A  66      10.294  27.648 173.826  1.00 53.04           O  
ATOM    374  CB  ASP A  66      13.341  28.610 174.111  1.00 56.60           C  
ATOM    375  CG  ASP A  66      13.331  29.874 173.264  1.00 60.44           C  
ATOM    376  OD1 ASP A  66      13.712  29.801 172.072  1.00 61.91           O  
ATOM    377  OD2 ASP A  66      12.954  30.946 173.804  1.00 62.04           O  
ATOM    378  N   GLU A  67      11.044  28.238 171.797  1.00 55.28           N  
ATOM    379  CA  GLU A  67       9.713  28.583 171.321  1.00 56.20           C  
ATOM    380  C   GLU A  67       8.939  27.317 170.942  1.00 55.00           C  
ATOM    381  O   GLU A  67       7.711  27.290 170.984  1.00 53.99           O  
ATOM    382  CB  GLU A  67       9.778  29.519 170.115  1.00 57.74           C  
ATOM    383  CG  GLU A  67       8.424  30.165 169.841  1.00 59.73           C  
ATOM    384  CD  GLU A  67       8.394  31.039 168.605  1.00 61.97           C  
ATOM    385  OE1 GLU A  67       9.409  31.712 168.287  1.00 61.83           O  
ATOM    386  OE2 GLU A  67       7.321  31.059 167.963  1.00 63.69           O  
ATOM    387  N   GLY A  68       9.658  26.276 170.550  1.00 54.03           N  
ATOM    388  CA  GLY A  68       8.986  25.043 170.217  1.00 53.47           C  
ATOM    389  C   GLY A  68       8.455  24.522 171.530  1.00 54.36           C  
ATOM    390  O   GLY A  68       7.347  23.999 171.604  1.00 55.19           O  
ATOM    391  N   GLN A  69       9.262  24.687 172.578  1.00 55.52           N  
ATOM    392  CA  GLN A  69       8.906  24.262 173.934  1.00 55.07           C  
ATOM    393  C   GLN A  69       7.673  25.015 174.450  1.00 54.43           C  
ATOM    394  O   GLN A  69       6.763  24.418 175.032  1.00 53.91           O  
ATOM    395  CB  GLN A  69      10.075  24.498 174.882  1.00 55.73           C  
ATOM    396  CG  GLN A  69      10.424  23.276 175.704  1.00 59.68           C  
ATOM    397  CD  GLN A  69      10.543  23.590 177.177  1.00 60.67           C  
ATOM    398  OE1 GLN A  69      11.107  24.611 177.557  1.00 62.52           O  
ATOM    399  NE2 GLN A  69      10.024  22.705 178.016  1.00 61.73           N  
ATOM    400  N   PHE A  70       7.644  26.327 174.246  1.00 53.51           N  
ATOM    401  CA  PHE A  70       6.500  27.102 174.672  1.00 54.14           C  
ATOM    402  C   PHE A  70       5.230  26.649 173.941  1.00 54.97           C  
ATOM    403  O   PHE A  70       4.170  26.526 174.554  1.00 56.95           O  
ATOM    404  CB  PHE A  70       6.727  28.589 174.431  1.00 55.43           C  
ATOM    405  CG  PHE A  70       5.558  29.432 174.830  1.00 56.14           C  
ATOM    406  CD1 PHE A  70       5.062  29.376 176.127  1.00 55.05           C  
ATOM    407  CD2 PHE A  70       4.909  30.231 173.898  1.00 55.43           C  
ATOM    408  CE1 PHE A  70       3.935  30.097 176.485  1.00 55.77           C  
ATOM    409  CE2 PHE A  70       3.776  30.958 174.250  1.00 54.92           C  
ATOM    410  CZ  PHE A  70       3.290  30.891 175.538  1.00 55.48           C  
ATOM    411  N   LEU A  71       5.324  26.405 172.635  1.00 54.48           N  
ATOM    412  CA  LEU A  71       4.168  25.947 171.876  1.00 52.42           C  
ATOM    413  C   LEU A  71       3.677  24.615 172.432  1.00 52.66           C  
ATOM    414  O   LEU A  71       2.471  24.408 172.622  1.00 51.47           O  
ATOM    415  CB  LEU A  71       4.521  25.783 170.398  1.00 52.37           C  
ATOM    416  CG  LEU A  71       4.841  27.049 169.601  1.00 53.37           C  
ATOM    417  CD1 LEU A  71       4.997  26.681 168.129  1.00 54.13           C  
ATOM    418  CD2 LEU A  71       3.732  28.074 169.768  1.00 52.33           C  
ATOM    419  N   SER A  72       4.609  23.704 172.696  1.00 52.77           N  
ATOM    420  CA  SER A  72       4.222  22.408 173.244  1.00 54.83           C  
ATOM    421  C   SER A  72       3.419  22.590 174.528  1.00 55.17           C  
ATOM    422  O   SER A  72       2.367  21.971 174.712  1.00 55.74           O  
ATOM    423  CB  SER A  72       5.453  21.547 173.519  1.00 54.81           C  
ATOM    424  OG  SER A  72       6.012  21.072 172.308  1.00 56.37           O  
ATOM    425  N   MET A  73       3.926  23.443 175.411  1.00 54.59           N  
ATOM    426  CA  MET A  73       3.265  23.726 176.673  1.00 54.35           C  
ATOM    427  C   MET A  73       1.871  24.278 176.399  1.00 53.58           C  
ATOM    428  O   MET A  73       0.860  23.723 176.837  1.00 52.75           O  
ATOM    429  CB  MET A  73       4.080  24.755 177.462  1.00 56.29           C  
ATOM    430  CG  MET A  73       3.507  25.114 178.825  1.00 59.42           C  
ATOM    431  SD  MET A  73       3.480  23.686 179.944  1.00 64.83           S  
ATOM    432  CE  MET A  73       5.195  23.663 180.481  1.00 62.85           C  
ATOM    433  N   LEU A  74       1.836  25.378 175.659  1.00 52.17           N  
ATOM    434  CA  LEU A  74       0.600  26.053 175.326  1.00 51.13           C  
ATOM    435  C   LEU A  74      -0.434  25.096 174.724  1.00 51.19           C  
ATOM    436  O   LEU A  74      -1.604  25.105 175.131  1.00 50.11           O  
ATOM    437  CB  LEU A  74       0.914  27.203 174.367  1.00 51.86           C  
ATOM    438  CG  LEU A  74      -0.182  28.172 173.921  1.00 53.92           C  
ATOM    439  CD1 LEU A  74      -0.716  28.962 175.101  1.00 56.04           C  
ATOM    440  CD2 LEU A  74       0.401  29.128 172.893  1.00 56.19           C  
ATOM    441  N   LEU A  75      -0.002  24.265 173.774  1.00 49.51           N  
ATOM    442  CA  LEU A  75      -0.913  23.329 173.121  1.00 49.41           C  
ATOM    443  C   LEU A  75      -1.500  22.337 174.118  1.00 50.35           C  
ATOM    444  O   LEU A  75      -2.693  22.030 174.078  1.00 49.74           O  
ATOM    445  CB  LEU A  75      -0.202  22.603 171.964  1.00 47.30           C  
ATOM    446  CG  LEU A  75      -0.006  23.422 170.672  1.00 46.66           C  
ATOM    447  CD1 LEU A  75       0.971  22.725 169.729  1.00 44.08           C  
ATOM    448  CD2 LEU A  75      -1.351  23.643 169.992  1.00 42.15           C  
ATOM    449  N   LYS A  76      -0.660  21.840 175.019  1.00 52.19           N  
ATOM    450  CA  LYS A  76      -1.101  20.910 176.057  1.00 52.89           C  
ATOM    451  C   LYS A  76      -2.103  21.573 177.011  1.00 52.94           C  
ATOM    452  O   LYS A  76      -3.159  21.014 177.285  1.00 53.53           O  
ATOM    453  CB  LYS A  76       0.101  20.422 176.850  1.00 54.60           C  
ATOM    454  CG  LYS A  76       1.050  19.571 176.055  1.00 56.67           C  
ATOM    455  CD  LYS A  76       0.589  18.126 176.038  1.00 58.05           C  
ATOM    456  CE  LYS A  76       1.520  17.307 175.171  1.00 59.95           C  
ATOM    457  NZ  LYS A  76       2.943  17.682 175.442  1.00 60.66           N  
ATOM    458  N   LEU A  77      -1.773  22.763 177.509  1.00 52.91           N  
ATOM    459  CA  LEU A  77      -2.659  23.476 178.430  1.00 53.49           C  
ATOM    460  C   LEU A  77      -4.042  23.821 177.862  1.00 54.64           C  
ATOM    461  O   LEU A  77      -5.002  23.932 178.613  1.00 55.23           O  
ATOM    462  CB  LEU A  77      -2.004  24.769 178.910  1.00 51.55           C  
ATOM    463  CG  LEU A  77      -0.634  24.647 179.563  1.00 51.80           C  
ATOM    464  CD1 LEU A  77      -0.050  26.024 179.763  1.00 49.29           C  
ATOM    465  CD2 LEU A  77      -0.749  23.914 180.883  1.00 52.69           C  
ATOM    466  N   ILE A  78      -4.167  24.003 176.553  1.00 54.80           N  
ATOM    467  CA  ILE A  78      -5.483  24.345 176.023  1.00 55.03           C  
ATOM    468  C   ILE A  78      -6.165  23.151 175.387  1.00 55.21           C  
ATOM    469  O   ILE A  78      -7.234  23.269 174.790  1.00 55.53           O  
ATOM    470  CB  ILE A  78      -5.417  25.533 175.007  1.00 54.53           C  
ATOM    471  CG1 ILE A  78      -4.672  25.121 173.735  1.00 54.45           C  
ATOM    472  CG2 ILE A  78      -4.726  26.723 175.654  1.00 54.23           C  
ATOM    473  CD1 ILE A  78      -4.578  26.210 172.691  1.00 53.29           C  
ATOM    474  N   ASN A  79      -5.543  21.991 175.530  1.00 56.43           N  
ATOM    475  CA  ASN A  79      -6.099  20.765 174.982  1.00 58.41           C  
ATOM    476  C   ASN A  79      -6.475  20.874 173.515  1.00 58.12           C  
ATOM    477  O   ASN A  79      -7.472  20.299 173.077  1.00 58.01           O  
ATOM    478  CB  ASN A  79      -7.316  20.343 175.799  1.00 61.77           C  
ATOM    479  CG  ASN A  79      -7.039  19.123 176.659  1.00 67.07           C  
ATOM    480  OD1 ASN A  79      -7.208  17.974 176.212  1.00 68.22           O  
ATOM    481  ND2 ASN A  79      -6.589  19.363 177.897  1.00 68.25           N  
ATOM    482  N   ALA A  80      -5.652  21.594 172.757  1.00 58.16           N  
ATOM    483  CA  ALA A  80      -5.880  21.787 171.331  1.00 56.90           C  
ATOM    484  C   ALA A  80      -5.833  20.460 170.602  1.00 55.43           C  
ATOM    485  O   ALA A  80      -4.930  19.651 170.812  1.00 55.37           O  
ATOM    486  CB  ALA A  80      -4.841  22.732 170.761  1.00 57.70           C  
ATOM    487  N   LYS A  81      -6.823  20.247 169.749  1.00 54.38           N  
ATOM    488  CA  LYS A  81      -6.924  19.021 168.976  1.00 53.54           C  
ATOM    489  C   LYS A  81      -6.858  19.337 167.487  1.00 52.29           C  
ATOM    490  O   LYS A  81      -6.142  18.679 166.732  1.00 51.39           O  
ATOM    491  CB  LYS A  81      -8.243  18.306 169.283  1.00 54.65           C  
ATOM    492  CG  LYS A  81      -8.081  16.943 169.936  1.00 59.18           C  
ATOM    493  CD  LYS A  81      -9.413  16.194 170.040  1.00 62.32           C  
ATOM    494  CE  LYS A  81      -9.970  15.805 168.665  1.00 64.94           C  
ATOM    495  NZ  LYS A  81     -11.385  15.275 168.712  1.00 66.14           N  
ATOM    496  N   ASN A  82      -7.597  20.364 167.079  1.00 50.56           N  
ATOM    497  CA  ASN A  82      -7.663  20.758 165.684  1.00 48.81           C  
ATOM    498  C   ASN A  82      -6.940  22.072 165.449  1.00 48.21           C  
ATOM    499  O   ASN A  82      -7.391  23.114 165.906  1.00 49.75           O  
ATOM    500  CB  ASN A  82      -9.128  20.875 165.298  1.00 50.11           C  
ATOM    501  CG  ASN A  82      -9.324  20.992 163.820  1.00 52.40           C  
ATOM    502  OD1 ASN A  82      -8.724  20.243 163.041  1.00 53.56           O  
ATOM    503  ND2 ASN A  82     -10.181  21.929 163.410  1.00 53.72           N  
ATOM    504  N   THR A  83      -5.831  22.038 164.717  1.00 47.31           N  
ATOM    505  CA  THR A  83      -5.060  23.258 164.483  1.00 45.78           C  
ATOM    506  C   THR A  83      -4.688  23.567 163.032  1.00 45.84           C  
ATOM    507  O   THR A  83      -4.908  22.767 162.123  1.00 45.79           O  
ATOM    508  CB  THR A  83      -3.756  23.231 165.290  1.00 45.70           C  
ATOM    509  OG1 THR A  83      -2.748  22.538 164.549  1.00 45.47           O  
ATOM    510  CG2 THR A  83      -3.966  22.502 166.605  1.00 45.83           C  
ATOM    511  N   MET A  84      -4.105  24.750 162.843  1.00 46.60           N  
ATOM    512  CA  MET A  84      -3.680  25.239 161.534  1.00 46.02           C  
ATOM    513  C   MET A  84      -2.341  25.939 161.702  1.00 47.08           C  
ATOM    514  O   MET A  84      -2.140  26.650 162.694  1.00 45.66           O  
ATOM    515  CB  MET A  84      -4.682  26.267 161.000  1.00 44.00           C  
ATOM    516  CG  MET A  84      -4.407  26.723 159.583  1.00 42.73           C  
ATOM    517  SD  MET A  84      -5.346  28.197 159.115  1.00 43.99           S  
ATOM    518  CE  MET A  84      -7.035  27.604 159.157  1.00 41.46           C  
ATOM    519  N   GLU A  85      -1.442  25.736 160.736  1.00 47.80           N  
ATOM    520  CA  GLU A  85      -0.130  26.375 160.729  1.00 49.55           C  
ATOM    521  C   GLU A  85       0.142  27.040 159.376  1.00 48.88           C  
ATOM    522  O   GLU A  85       0.030  26.398 158.334  1.00 49.59           O  
ATOM    523  CB  GLU A  85       0.979  25.362 161.019  1.00 53.25           C  
ATOM    524  CG  GLU A  85       2.388  26.003 160.995  1.00 63.97           C  
ATOM    525  CD  GLU A  85       3.423  25.307 161.917  1.00 69.65           C  
ATOM    526  OE1 GLU A  85       3.093  25.035 163.109  1.00 69.94           O  
ATOM    527  OE2 GLU A  85       4.567  25.055 161.447  1.00 70.83           O  
ATOM    528  N   ILE A  86       0.484  28.327 159.386  1.00 47.00           N  
ATOM    529  CA  ILE A  86       0.791  29.040 158.148  1.00 45.27           C  
ATOM    530  C   ILE A  86       2.276  29.386 158.171  1.00 45.46           C  
ATOM    531  O   ILE A  86       2.724  30.204 158.979  1.00 45.22           O  
ATOM    532  CB  ILE A  86      -0.023  30.342 157.998  1.00 43.34           C  
ATOM    533  CG1 ILE A  86      -1.515  30.039 158.051  1.00 42.12           C  
ATOM    534  CG2 ILE A  86       0.289  30.991 156.659  1.00 41.55           C  
ATOM    535  CD1 ILE A  86      -2.380  31.270 157.927  1.00 41.27           C  
ATOM    536  N   GLY A  87       3.020  28.771 157.256  1.00 45.02           N  
ATOM    537  CA  GLY A  87       4.457  28.954 157.198  1.00 44.94           C  
ATOM    538  C   GLY A  87       5.005  27.698 157.861  1.00 47.10           C  
ATOM    539  O   GLY A  87       5.091  27.624 159.092  1.00 47.17           O  
ATOM    540  N   VAL A  88       5.356  26.695 157.057  1.00 46.90           N  
ATOM    541  CA  VAL A  88       5.831  25.418 157.588  1.00 46.02           C  
ATOM    542  C   VAL A  88       7.329  25.235 157.578  1.00 47.48           C  
ATOM    543  O   VAL A  88       7.901  24.797 158.573  1.00 47.77           O  
ATOM    544  CB  VAL A  88       5.243  24.238 156.821  1.00 43.55           C  
ATOM    545  CG1 VAL A  88       5.735  22.954 157.429  1.00 42.68           C  
ATOM    546  CG2 VAL A  88       3.732  24.306 156.830  1.00 43.63           C  
ATOM    547  N   TYR A  89       7.935  25.521 156.430  1.00 50.28           N  
ATOM    548  CA  TYR A  89       9.374  25.423 156.224  1.00 51.29           C  
ATOM    549  C   TYR A  89      10.030  24.308 156.997  1.00 53.45           C  
ATOM    550  O   TYR A  89      10.053  24.348 158.231  1.00 59.17           O  
ATOM    551  CB  TYR A  89      10.050  26.735 156.649  1.00 49.46           C  
ATOM    552  CG  TYR A  89      11.563  26.706 156.596  1.00 47.14           C  
ATOM    553  CD1 TYR A  89      12.230  26.617 155.381  1.00 50.91           C  
ATOM    554  CD2 TYR A  89      12.327  26.781 157.748  1.00 46.69           C  
ATOM    555  CE1 TYR A  89      13.629  26.608 155.307  1.00 50.44           C  
ATOM    556  CE2 TYR A  89      13.727  26.773 157.694  1.00 47.70           C  
ATOM    557  CZ  TYR A  89      14.367  26.688 156.463  1.00 49.93           C  
ATOM    558  OH  TYR A  89      15.740  26.697 156.363  1.00 48.62           O  
ATOM    559  N   THR A  90      10.566  23.308 156.319  1.00 52.30           N  
ATOM    560  CA  THR A  90      11.287  22.268 157.060  1.00 50.49           C  
ATOM    561  C   THR A  90      10.502  21.462 158.099  1.00 49.50           C  
ATOM    562  O   THR A  90      10.722  20.262 158.230  1.00 50.48           O  
ATOM    563  CB  THR A  90      12.505  22.890 157.724  1.00 49.30           C  
ATOM    564  OG1 THR A  90      13.639  22.713 156.873  1.00 49.10           O  
ATOM    565  CG2 THR A  90      12.738  22.292 159.071  1.00 50.14           C  
ATOM    566  N   GLY A  91       9.646  22.118 158.876  1.00 48.61           N  
ATOM    567  CA  GLY A  91       8.808  21.382 159.807  1.00 47.92           C  
ATOM    568  C   GLY A  91       8.923  21.482 161.309  1.00 47.37           C  
ATOM    569  O   GLY A  91       8.186  20.785 162.004  1.00 47.30           O  
ATOM    570  N   TYR A  92       9.796  22.336 161.827  1.00 46.94           N  
ATOM    571  CA  TYR A  92       9.957  22.428 163.272  1.00 47.44           C  
ATOM    572  C   TYR A  92       8.709  22.738 164.124  1.00 46.99           C  
ATOM    573  O   TYR A  92       8.428  22.018 165.083  1.00 46.16           O  
ATOM    574  CB  TYR A  92      11.076  23.403 163.603  1.00 49.14           C  
ATOM    575  CG  TYR A  92      11.612  23.188 164.991  1.00 53.15           C  
ATOM    576  CD1 TYR A  92      10.955  23.714 166.099  1.00 54.35           C  
ATOM    577  CD2 TYR A  92      12.757  22.420 165.208  1.00 53.10           C  
ATOM    578  CE1 TYR A  92      11.424  23.484 167.390  1.00 55.15           C  
ATOM    579  CE2 TYR A  92      13.231  22.187 166.495  1.00 53.36           C  
ATOM    580  CZ  TYR A  92      12.561  22.723 167.582  1.00 53.84           C  
ATOM    581  OH  TYR A  92      13.016  22.513 168.867  1.00 55.36           O  
ATOM    582  N   SER A  93       7.974  23.799 163.801  1.00 47.46           N  
ATOM    583  CA  SER A  93       6.756  24.146 164.549  1.00 47.47           C  
ATOM    584  C   SER A  93       5.757  22.994 164.433  1.00 47.40           C  
ATOM    585  O   SER A  93       5.094  22.608 165.405  1.00 45.67           O  
ATOM    586  CB  SER A  93       6.080  25.386 163.958  1.00 47.57           C  
ATOM    587  OG  SER A  93       7.007  26.412 163.701  1.00 53.68           O  
ATOM    588  N   LEU A  94       5.644  22.481 163.210  1.00 47.26           N  
ATOM    589  CA  LEU A  94       4.738  21.397 162.883  1.00 46.62           C  
ATOM    590  C   LEU A  94       5.014  20.180 163.728  1.00 46.93           C  
ATOM    591  O   LEU A  94       4.119  19.662 164.395  1.00 48.25           O  
ATOM    592  CB  LEU A  94       4.893  21.015 161.420  1.00 47.65           C  
ATOM    593  CG  LEU A  94       3.618  21.058 160.587  1.00 48.17           C  
ATOM    594  CD1 LEU A  94       3.805  20.192 159.358  1.00 47.04           C  
ATOM    595  CD2 LEU A  94       2.440  20.582 161.420  1.00 47.63           C  
ATOM    596  N   LEU A  95       6.261  19.721 163.682  1.00 45.55           N  
ATOM    597  CA  LEU A  95       6.681  18.556 164.443  1.00 44.00           C  
ATOM    598  C   LEU A  95       6.302  18.752 165.899  1.00 44.81           C  
ATOM    599  O   LEU A  95       5.682  17.883 166.510  1.00 45.92           O  
ATOM    600  CB  LEU A  95       8.192  18.376 164.349  1.00 41.21           C  
ATOM    601  CG  LEU A  95       8.774  16.969 164.489  1.00 37.80           C  
ATOM    602  CD1 LEU A  95      10.079  17.110 165.215  1.00 35.94           C  
ATOM    603  CD2 LEU A  95       7.848  16.030 165.220  1.00 35.58           C  
ATOM    604  N   ALA A  96       6.677  19.901 166.452  1.00 44.58           N  
ATOM    605  CA  ALA A  96       6.368  20.192 167.841  1.00 45.17           C  
ATOM    606  C   ALA A  96       4.868  20.093 168.096  1.00 45.99           C  
ATOM    607  O   ALA A  96       4.440  19.484 169.076  1.00 48.41           O  
ATOM    608  CB  ALA A  96       6.876  21.586 168.223  1.00 44.23           C  
ATOM    609  N   THR A  97       4.069  20.679 167.212  1.00 45.10           N  
ATOM    610  CA  THR A  97       2.630  20.654 167.381  1.00 43.93           C  
ATOM    611  C   THR A  97       2.070  19.240 167.296  1.00 45.37           C  
ATOM    612  O   THR A  97       1.260  18.832 168.134  1.00 45.93           O  
ATOM    613  CB  THR A  97       1.953  21.504 166.317  1.00 42.43           C  
ATOM    614  OG1 THR A  97       2.554  22.798 166.305  1.00 43.13           O  
ATOM    615  CG2 THR A  97       0.465  21.639 166.600  1.00 40.20           C  
ATOM    616  N   ALA A  98       2.497  18.490 166.285  1.00 45.41           N  
ATOM    617  CA  ALA A  98       1.998  17.135 166.093  1.00 45.12           C  
ATOM    618  C   ALA A  98       2.342  16.218 167.268  1.00 46.06           C  
ATOM    619  O   ALA A  98       1.572  15.320 167.608  1.00 46.70           O  
ATOM    620  CB  ALA A  98       2.538  16.573 164.808  1.00 43.76           C  
ATOM    621  N   LEU A  99       3.489  16.445 167.894  1.00 45.45           N  
ATOM    622  CA  LEU A  99       3.885  15.633 169.033  1.00 45.03           C  
ATOM    623  C   LEU A  99       3.131  16.057 170.289  1.00 46.74           C  
ATOM    624  O   LEU A  99       3.051  15.298 171.254  1.00 50.05           O  
ATOM    625  CB  LEU A  99       5.387  15.761 169.301  1.00 42.09           C  
ATOM    626  CG  LEU A  99       6.376  15.163 168.302  1.00 40.38           C  
ATOM    627  CD1 LEU A  99       7.783  15.665 168.587  1.00 37.30           C  
ATOM    628  CD2 LEU A  99       6.303  13.658 168.371  1.00 37.38           C  
ATOM    629  N   ALA A 100       2.579  17.264 170.296  1.00 46.58           N  
ATOM    630  CA  ALA A 100       1.879  17.723 171.489  1.00 45.76           C  
ATOM    631  C   ALA A 100       0.387  17.434 171.496  1.00 46.01           C  
ATOM    632  O   ALA A 100      -0.184  17.196 172.552  1.00 46.80           O  
ATOM    633  CB  ALA A 100       2.135  19.202 171.711  1.00 43.49           C  
ATOM    634  N   ILE A 101      -0.257  17.443 170.336  1.00 47.01           N  
ATOM    635  CA  ILE A 101      -1.690  17.162 170.317  1.00 48.44           C  
ATOM    636  C   ILE A 101      -1.927  15.652 170.423  1.00 49.19           C  
ATOM    637  O   ILE A 101      -1.005  14.856 170.228  1.00 49.60           O  
ATOM    638  CB  ILE A 101      -2.376  17.741 169.041  1.00 47.36           C  
ATOM    639  CG1 ILE A 101      -1.654  17.272 167.777  1.00 48.33           C  
ATOM    640  CG2 ILE A 101      -2.359  19.260 169.096  1.00 48.06           C  
ATOM    641  CD1 ILE A 101      -2.271  17.787 166.488  1.00 45.69           C  
ATOM    642  N   PRO A 102      -3.155  15.239 170.779  1.00 49.51           N  
ATOM    643  CA  PRO A 102      -3.488  13.820 170.907  1.00 50.21           C  
ATOM    644  C   PRO A 102      -3.354  13.014 169.618  1.00 51.97           C  
ATOM    645  O   PRO A 102      -3.202  13.576 168.531  1.00 51.37           O  
ATOM    646  CB  PRO A 102      -4.905  13.845 171.472  1.00 48.62           C  
ATOM    647  CG  PRO A 102      -5.421  15.173 171.095  1.00 48.33           C  
ATOM    648  CD  PRO A 102      -4.250  16.069 171.295  1.00 49.67           C  
ATOM    649  N   GLU A 103      -3.414  11.692 169.756  1.00 54.78           N  
ATOM    650  CA  GLU A 103      -3.239  10.786 168.630  1.00 57.39           C  
ATOM    651  C   GLU A 103      -4.186  11.005 167.457  1.00 58.06           C  
ATOM    652  O   GLU A 103      -3.870  10.627 166.317  1.00 56.85           O  
ATOM    653  CB  GLU A 103      -3.320   9.337 169.112  1.00 59.54           C  
ATOM    654  CG  GLU A 103      -2.636   8.334 168.175  1.00 66.50           C  
ATOM    655  CD  GLU A 103      -1.104   8.547 168.041  1.00 70.60           C  
ATOM    656  OE1 GLU A 103      -0.666   9.625 167.571  1.00 71.47           O  
ATOM    657  OE2 GLU A 103      -0.333   7.626 168.401  1.00 72.53           O  
ATOM    658  N   ASP A 104      -5.332  11.623 167.733  1.00 58.95           N  
ATOM    659  CA  ASP A 104      -6.336  11.897 166.703  1.00 60.68           C  
ATOM    660  C   ASP A 104      -6.400  13.384 166.349  1.00 59.98           C  
ATOM    661  O   ASP A 104      -7.408  13.872 165.822  1.00 58.82           O  
ATOM    662  CB  ASP A 104      -7.707  11.419 167.180  1.00 63.96           C  
ATOM    663  CG  ASP A 104      -8.084  11.997 168.528  1.00 67.61           C  
ATOM    664  OD1 ASP A 104      -7.198  12.034 169.413  1.00 68.39           O  
ATOM    665  OD2 ASP A 104      -9.256  12.405 168.707  1.00 69.69           O  
ATOM    666  N   GLY A 105      -5.314  14.091 166.651  1.00 59.39           N  
ATOM    667  CA  GLY A 105      -5.237  15.507 166.363  1.00 58.59           C  
ATOM    668  C   GLY A 105      -4.979  15.767 164.893  1.00 57.86           C  
ATOM    669  O   GLY A 105      -4.384  14.935 164.197  1.00 58.57           O  
ATOM    670  N   LYS A 106      -5.424  16.927 164.419  1.00 56.07           N  
ATOM    671  CA  LYS A 106      -5.254  17.300 163.023  1.00 53.79           C  
ATOM    672  C   LYS A 106      -4.671  18.688 162.864  1.00 50.89           C  
ATOM    673  O   LYS A 106      -4.991  19.610 163.608  1.00 49.72           O  
ATOM    674  CB  LYS A 106      -6.595  17.206 162.295  1.00 55.31           C  
ATOM    675  CG  LYS A 106      -7.082  15.779 162.150  1.00 58.21           C  
ATOM    676  CD  LYS A 106      -8.575  15.713 161.922  1.00 61.83           C  
ATOM    677  CE  LYS A 106      -9.049  14.279 162.009  1.00 64.87           C  
ATOM    678  NZ  LYS A 106      -8.466  13.605 163.213  1.00 68.12           N  
ATOM    679  N   ILE A 107      -3.814  18.820 161.866  1.00 48.56           N  
ATOM    680  CA  ILE A 107      -3.151  20.071 161.576  1.00 47.01           C  
ATOM    681  C   ILE A 107      -3.247  20.404 160.097  1.00 47.05           C  
ATOM    682  O   ILE A 107      -2.864  19.591 159.256  1.00 47.15           O  
ATOM    683  CB  ILE A 107      -1.647  19.985 161.902  1.00 45.32           C  
ATOM    684  CG1 ILE A 107      -1.438  19.378 163.279  1.00 43.65           C  
ATOM    685  CG2 ILE A 107      -1.017  21.363 161.813  1.00 43.38           C  
ATOM    686  CD1 ILE A 107      -0.003  19.044 163.567  1.00 43.08           C  
ATOM    687  N   LEU A 108      -3.752  21.593 159.780  1.00 47.30           N  
ATOM    688  CA  LEU A 108      -3.815  22.045 158.390  1.00 47.11           C  
ATOM    689  C   LEU A 108      -2.558  22.912 158.203  1.00 46.29           C  
ATOM    690  O   LEU A 108      -2.500  24.033 158.713  1.00 46.69           O  
ATOM    691  CB  LEU A 108      -5.078  22.878 158.149  1.00 47.73           C  
ATOM    692  CG  LEU A 108      -5.141  23.580 156.788  1.00 49.64           C  
ATOM    693  CD1 LEU A 108      -5.090  22.543 155.685  1.00 49.53           C  
ATOM    694  CD2 LEU A 108      -6.401  24.407 156.681  1.00 50.52           C  
ATOM    695  N   ALA A 109      -1.558  22.392 157.489  1.00 44.49           N  
ATOM    696  CA  ALA A 109      -0.301  23.107 157.286  1.00 44.05           C  
ATOM    697  C   ALA A 109      -0.147  23.689 155.887  1.00 45.25           C  
ATOM    698  O   ALA A 109      -0.187  22.957 154.901  1.00 46.24           O  
ATOM    699  CB  ALA A 109       0.854  22.184 157.584  1.00 43.64           C  
ATOM    700  N   MET A 110       0.071  25.002 155.812  1.00 44.83           N  
ATOM    701  CA  MET A 110       0.201  25.709 154.542  1.00 43.87           C  
ATOM    702  C   MET A 110       1.558  26.372 154.293  1.00 44.21           C  
ATOM    703  O   MET A 110       2.072  27.071 155.152  1.00 46.78           O  
ATOM    704  CB  MET A 110      -0.888  26.780 154.463  1.00 44.59           C  
ATOM    705  CG  MET A 110      -2.301  26.236 154.314  1.00 48.02           C  
ATOM    706  SD  MET A 110      -3.593  27.527 154.405  1.00 51.98           S  
ATOM    707  CE  MET A 110      -4.488  27.008 155.910  1.00 52.35           C  
ATOM    708  N   ASP A 111       2.142  26.160 153.120  1.00 43.76           N  
ATOM    709  CA  ASP A 111       3.406  26.807 152.786  1.00 45.37           C  
ATOM    710  C   ASP A 111       3.603  26.881 151.264  1.00 47.10           C  
ATOM    711  O   ASP A 111       3.268  25.952 150.547  1.00 48.36           O  
ATOM    712  CB  ASP A 111       4.579  26.092 153.452  1.00 43.95           C  
ATOM    713  CG  ASP A 111       5.833  26.955 153.491  1.00 46.77           C  
ATOM    714  OD1 ASP A 111       6.414  27.215 152.415  1.00 47.16           O  
ATOM    715  OD2 ASP A 111       6.235  27.396 154.594  1.00 46.74           O  
ATOM    716  N   ILE A 112       4.131  27.994 150.769  1.00 48.68           N  
ATOM    717  CA  ILE A 112       4.330  28.163 149.333  1.00 52.24           C  
ATOM    718  C   ILE A 112       5.424  27.310 148.704  1.00 55.03           C  
ATOM    719  O   ILE A 112       5.367  26.990 147.515  1.00 55.11           O  
ATOM    720  CB  ILE A 112       4.666  29.615 148.977  1.00 51.25           C  
ATOM    721  CG1 ILE A 112       5.849  30.079 149.818  1.00 51.69           C  
ATOM    722  CG2 ILE A 112       3.448  30.490 149.139  1.00 50.30           C  
ATOM    723  CD1 ILE A 112       6.298  31.480 149.524  1.00 52.74           C  
ATOM    724  N   ASN A 113       6.425  26.943 149.489  1.00 58.85           N  
ATOM    725  CA  ASN A 113       7.524  26.161 148.948  1.00 61.69           C  
ATOM    726  C   ASN A 113       7.217  24.667 148.761  1.00 63.85           C  
ATOM    727  O   ASN A 113       6.846  24.251 147.651  1.00 66.43           O  
ATOM    728  CB  ASN A 113       8.777  26.362 149.805  1.00 59.78           C  
ATOM    729  CG  ASN A 113      10.001  25.731 149.190  1.00 58.75           C  
ATOM    730  OD1 ASN A 113      10.161  24.513 149.220  1.00 59.65           O  
ATOM    731  ND2 ASN A 113      10.866  26.550 148.618  1.00 55.15           N  
ATOM    732  N   LYS A 114       7.382  23.878 149.826  1.00 62.79           N  
ATOM    733  CA  LYS A 114       7.141  22.428 149.816  1.00 62.63           C  
ATOM    734  C   LYS A 114       8.372  21.536 149.622  1.00 61.57           C  
ATOM    735  O   LYS A 114       8.378  20.401 150.087  1.00 60.39           O  
ATOM    736  CB  LYS A 114       6.082  22.015 148.792  1.00 62.51           C  
ATOM    737  CG  LYS A 114       5.938  20.503 148.721  1.00 64.57           C  
ATOM    738  CD  LYS A 114       4.602  20.065 148.169  1.00 67.95           C  
ATOM    739  CE  LYS A 114       4.433  18.555 148.320  1.00 68.70           C  
ATOM    740  NZ  LYS A 114       3.055  18.103 147.966  1.00 69.19           N  
ATOM    741  N   GLU A 115       9.399  21.998 148.916  1.00 60.98           N  
ATOM    742  CA  GLU A 115      10.581  21.156 148.801  1.00 61.04           C  
ATOM    743  C   GLU A 115      11.068  21.149 150.245  1.00 59.45           C  
ATOM    744  O   GLU A 115      11.314  20.088 150.825  1.00 59.44           O  
ATOM    745  CB  GLU A 115      11.658  21.772 147.899  1.00 63.41           C  
ATOM    746  CG  GLU A 115      11.229  22.056 146.451  1.00 70.67           C  
ATOM    747  CD  GLU A 115      11.302  23.561 146.092  1.00 75.40           C  
ATOM    748  OE1 GLU A 115      12.377  24.193 146.299  1.00 74.89           O  
ATOM    749  OE2 GLU A 115      10.281  24.111 145.600  1.00 77.69           O  
ATOM    750  N   ASN A 116      11.159  22.347 150.827  1.00 56.55           N  
ATOM    751  CA  ASN A 116      11.601  22.518 152.204  1.00 53.86           C  
ATOM    752  C   ASN A 116      10.845  21.608 153.165  1.00 53.32           C  
ATOM    753  O   ASN A 116      11.454  20.921 153.977  1.00 54.30           O  
ATOM    754  CB  ASN A 116      11.410  23.963 152.672  1.00 54.20           C  
ATOM    755  CG  ASN A 116      12.243  24.966 151.891  1.00 54.04           C  
ATOM    756  OD1 ASN A 116      13.330  24.652 151.402  1.00 55.75           O  
ATOM    757  ND2 ASN A 116      11.742  26.196 151.798  1.00 51.13           N  
ATOM    758  N   TYR A 117       9.518  21.609 153.087  1.00 51.74           N  
ATOM    759  CA  TYR A 117       8.712  20.776 153.974  1.00 50.64           C  
ATOM    760  C   TYR A 117       9.059  19.294 153.905  1.00 51.50           C  
ATOM    761  O   TYR A 117       9.029  18.597 154.912  1.00 52.24           O  
ATOM    762  CB  TYR A 117       7.226  20.958 153.667  1.00 49.90           C  
ATOM    763  CG  TYR A 117       6.337  19.897 154.284  1.00 49.42           C  
ATOM    764  CD1 TYR A 117       6.320  19.679 155.665  1.00 49.32           C  
ATOM    765  CD2 TYR A 117       5.542  19.083 153.486  1.00 48.98           C  
ATOM    766  CE1 TYR A 117       5.532  18.666 156.223  1.00 47.99           C  
ATOM    767  CE2 TYR A 117       4.757  18.075 154.036  1.00 48.15           C  
ATOM    768  CZ  TYR A 117       4.760  17.871 155.397  1.00 47.34           C  
ATOM    769  OH  TYR A 117       4.010  16.851 155.924  1.00 47.36           O  
ATOM    770  N   GLU A 118       9.392  18.805 152.722  1.00 52.62           N  
ATOM    771  CA  GLU A 118       9.714  17.395 152.581  1.00 54.33           C  
ATOM    772  C   GLU A 118      11.104  17.087 153.095  1.00 53.45           C  
ATOM    773  O   GLU A 118      11.468  15.929 153.288  1.00 52.56           O  
ATOM    774  CB  GLU A 118       9.579  16.970 151.123  1.00 56.38           C  
ATOM    775  CG  GLU A 118       8.157  17.074 150.614  1.00 60.24           C  
ATOM    776  CD  GLU A 118       8.080  16.912 149.116  1.00 64.47           C  
ATOM    777  OE1 GLU A 118       9.138  17.095 148.453  1.00 65.65           O  
ATOM    778  OE2 GLU A 118       6.970  16.617 148.607  1.00 65.58           O  
ATOM    779  N   LEU A 119      11.877  18.134 153.323  1.00 53.35           N  
ATOM    780  CA  LEU A 119      13.222  17.967 153.825  1.00 54.72           C  
ATOM    781  C   LEU A 119      13.128  17.393 155.231  1.00 55.99           C  
ATOM    782  O   LEU A 119      13.986  16.614 155.651  1.00 57.50           O  
ATOM    783  CB  LEU A 119      13.915  19.313 153.890  1.00 55.21           C  
ATOM    784  CG  LEU A 119      15.415  19.269 153.718  1.00 55.77           C  
ATOM    785  CD1 LEU A 119      15.681  18.800 152.297  1.00 56.18           C  
ATOM    786  CD2 LEU A 119      16.018  20.652 153.977  1.00 55.65           C  
ATOM    787  N   GLY A 120      12.077  17.783 155.952  1.00 55.69           N  
ATOM    788  CA  GLY A 120      11.888  17.318 157.313  1.00 54.65           C  
ATOM    789  C   GLY A 120      10.823  16.255 157.493  1.00 54.26           C  
ATOM    790  O   GLY A 120      10.718  15.643 158.563  1.00 54.03           O  
ATOM    791  N   LEU A 121      10.028  16.029 156.455  1.00 53.45           N  
ATOM    792  CA  LEU A 121       8.972  15.035 156.529  1.00 52.62           C  
ATOM    793  C   LEU A 121       9.501  13.669 156.942  1.00 53.61           C  
ATOM    794  O   LEU A 121       8.832  12.932 157.668  1.00 54.58           O  
ATOM    795  CB  LEU A 121       8.245  14.916 155.190  1.00 51.25           C  
ATOM    796  CG  LEU A 121       7.005  14.014 155.245  1.00 50.01           C  
ATOM    797  CD1 LEU A 121       6.059  14.468 156.340  1.00 47.69           C  
ATOM    798  CD2 LEU A 121       6.309  14.045 153.914  1.00 48.64           C  
ATOM    799  N   PRO A 122      10.709  13.300 156.485  1.00 53.89           N  
ATOM    800  CA  PRO A 122      11.207  11.983 156.894  1.00 54.23           C  
ATOM    801  C   PRO A 122      11.218  11.840 158.424  1.00 54.47           C  
ATOM    802  O   PRO A 122      10.878  10.782 158.974  1.00 55.17           O  
ATOM    803  CB  PRO A 122      12.610  11.946 156.284  1.00 53.01           C  
ATOM    804  CG  PRO A 122      12.458  12.762 155.063  1.00 51.47           C  
ATOM    805  CD  PRO A 122      11.649  13.939 155.548  1.00 52.89           C  
ATOM    806  N   VAL A 123      11.596  12.920 159.100  1.00 52.76           N  
ATOM    807  CA  VAL A 123      11.654  12.928 160.546  1.00 51.30           C  
ATOM    808  C   VAL A 123      10.258  12.811 161.147  1.00 51.35           C  
ATOM    809  O   VAL A 123      10.011  11.986 162.018  1.00 52.16           O  
ATOM    810  CB  VAL A 123      12.332  14.214 161.050  1.00 51.14           C  
ATOM    811  CG1 VAL A 123      12.432  14.193 162.569  1.00 50.28           C  
ATOM    812  CG2 VAL A 123      13.714  14.346 160.417  1.00 49.78           C  
ATOM    813  N   ILE A 124       9.332  13.626 160.676  1.00 51.17           N  
ATOM    814  CA  ILE A 124       7.986  13.573 161.211  1.00 51.43           C  
ATOM    815  C   ILE A 124       7.413  12.160 161.078  1.00 52.71           C  
ATOM    816  O   ILE A 124       6.690  11.683 161.971  1.00 51.99           O  
ATOM    817  CB  ILE A 124       7.094  14.623 160.508  1.00 51.09           C  
ATOM    818  CG1 ILE A 124       7.595  16.028 160.869  1.00 51.34           C  
ATOM    819  CG2 ILE A 124       5.642  14.451 160.908  1.00 48.74           C  
ATOM    820  CD1 ILE A 124       6.928  17.154 160.089  1.00 52.39           C  
ATOM    821  N   LYS A 125       7.753  11.487 159.978  1.00 53.76           N  
ATOM    822  CA  LYS A 125       7.284  10.119 159.741  1.00 54.94           C  
ATOM    823  C   LYS A 125       7.989   9.147 160.693  1.00 55.28           C  
ATOM    824  O   LYS A 125       7.387   8.189 161.197  1.00 54.73           O  
ATOM    825  CB  LYS A 125       7.534   9.701 158.289  1.00 55.45           C  
ATOM    826  CG  LYS A 125       6.417  10.099 157.323  1.00 57.56           C  
ATOM    827  CD  LYS A 125       6.775   9.715 155.886  1.00 59.82           C  
ATOM    828  CE  LYS A 125       5.843  10.349 154.858  1.00 58.61           C  
ATOM    829  NZ  LYS A 125       6.432  10.330 153.475  1.00 57.75           N  
ATOM    830  N   LYS A 126       9.270   9.403 160.939  1.00 54.15           N  
ATOM    831  CA  LYS A 126      10.026   8.564 161.846  1.00 53.93           C  
ATOM    832  C   LYS A 126       9.494   8.751 163.274  1.00 53.64           C  
ATOM    833  O   LYS A 126       9.582   7.845 164.105  1.00 54.27           O  
ATOM    834  CB  LYS A 126      11.511   8.918 161.781  1.00 53.96           C  
ATOM    835  CG  LYS A 126      12.358   8.073 162.680  1.00 54.26           C  
ATOM    836  CD  LYS A 126      13.785   8.549 162.702  1.00 58.17           C  
ATOM    837  CE  LYS A 126      14.538   7.897 163.870  1.00 59.45           C  
ATOM    838  NZ  LYS A 126      15.960   8.351 163.963  1.00 62.75           N  
ATOM    839  N   ALA A 127       8.946   9.926 163.563  1.00 52.74           N  
ATOM    840  CA  ALA A 127       8.398  10.183 164.891  1.00 52.15           C  
ATOM    841  C   ALA A 127       6.978   9.639 164.926  1.00 51.23           C  
ATOM    842  O   ALA A 127       6.273   9.762 165.935  1.00 49.80           O  
ATOM    843  CB  ALA A 127       8.405  11.682 165.197  1.00 52.88           C  
ATOM    844  N   GLY A 128       6.578   9.044 163.803  1.00 50.20           N  
ATOM    845  CA  GLY A 128       5.257   8.460 163.671  1.00 51.91           C  
ATOM    846  C   GLY A 128       4.084   9.398 163.886  1.00 53.39           C  
ATOM    847  O   GLY A 128       3.022   8.978 164.351  1.00 52.99           O  
ATOM    848  N   VAL A 129       4.243  10.665 163.518  1.00 54.62           N  
ATOM    849  CA  VAL A 129       3.160  11.619 163.735  1.00 54.51           C  
ATOM    850  C   VAL A 129       2.727  12.367 162.460  1.00 55.08           C  
ATOM    851  O   VAL A 129       1.899  13.292 162.496  1.00 54.66           O  
ATOM    852  CB  VAL A 129       3.568  12.602 164.863  1.00 53.23           C  
ATOM    853  CG1 VAL A 129       4.620  13.588 164.359  1.00 51.51           C  
ATOM    854  CG2 VAL A 129       2.340  13.271 165.429  1.00 52.87           C  
ATOM    855  N   ASP A 130       3.275  11.934 161.330  1.00 54.40           N  
ATOM    856  CA  ASP A 130       2.949  12.534 160.057  1.00 54.68           C  
ATOM    857  C   ASP A 130       1.482  12.326 159.689  1.00 53.97           C  
ATOM    858  O   ASP A 130       0.963  13.006 158.812  1.00 55.94           O  
ATOM    859  CB  ASP A 130       3.847  11.959 158.950  1.00 57.79           C  
ATOM    860  CG  ASP A 130       3.580  10.473 158.666  1.00 61.13           C  
ATOM    861  OD1 ASP A 130       3.850   9.627 159.549  1.00 62.67           O  
ATOM    862  OD2 ASP A 130       3.107  10.149 157.551  1.00 61.92           O  
ATOM    863  N   HIS A 131       0.803  11.399 160.350  1.00 52.46           N  
ATOM    864  CA  HIS A 131      -0.597  11.142 160.028  1.00 50.69           C  
ATOM    865  C   HIS A 131      -1.540  12.258 160.453  1.00 50.94           C  
ATOM    866  O   HIS A 131      -2.689  12.286 160.029  1.00 52.01           O  
ATOM    867  CB  HIS A 131      -1.073   9.829 160.659  1.00 48.76           C  
ATOM    868  CG  HIS A 131      -1.045   9.832 162.154  1.00 48.50           C  
ATOM    869  ND1 HIS A 131       0.127   9.756 162.880  1.00 49.57           N  
ATOM    870  CD2 HIS A 131      -2.043   9.941 163.063  1.00 48.61           C  
ATOM    871  CE1 HIS A 131      -0.149   9.822 164.171  1.00 49.20           C  
ATOM    872  NE2 HIS A 131      -1.460   9.936 164.310  1.00 49.84           N  
ATOM    873  N   LYS A 132      -1.072  13.179 161.285  1.00 50.98           N  
ATOM    874  CA  LYS A 132      -1.932  14.262 161.752  1.00 50.66           C  
ATOM    875  C   LYS A 132      -1.862  15.473 160.847  1.00 51.49           C  
ATOM    876  O   LYS A 132      -2.695  16.368 160.938  1.00 53.46           O  
ATOM    877  CB  LYS A 132      -1.527  14.706 163.156  1.00 48.47           C  
ATOM    878  CG  LYS A 132      -1.568  13.635 164.203  1.00 45.71           C  
ATOM    879  CD  LYS A 132      -1.046  14.146 165.528  1.00 43.25           C  
ATOM    880  CE  LYS A 132      -0.755  12.996 166.463  1.00 39.97           C  
ATOM    881  NZ  LYS A 132      -0.366  13.495 167.784  1.00 35.34           N  
ATOM    882  N   ILE A 133      -0.862  15.491 159.977  1.00 51.22           N  
ATOM    883  CA  ILE A 133      -0.628  16.606 159.079  1.00 50.41           C  
ATOM    884  C   ILE A 133      -1.331  16.540 157.728  1.00 50.43           C  
ATOM    885  O   ILE A 133      -1.286  15.528 157.052  1.00 50.87           O  
ATOM    886  CB  ILE A 133       0.890  16.749 158.828  1.00 49.72           C  
ATOM    887  CG1 ILE A 133       1.613  16.925 160.167  1.00 48.55           C  
ATOM    888  CG2 ILE A 133       1.171  17.908 157.874  1.00 47.56           C  
ATOM    889  CD1 ILE A 133       3.124  16.803 160.076  1.00 47.34           C  
ATOM    890  N   ASP A 134      -1.986  17.637 157.357  1.00 51.94           N  
ATOM    891  CA  ASP A 134      -2.645  17.788 156.057  1.00 51.48           C  
ATOM    892  C   ASP A 134      -1.904  18.966 155.409  1.00 50.40           C  
ATOM    893  O   ASP A 134      -2.266  20.136 155.602  1.00 49.59           O  
ATOM    894  CB  ASP A 134      -4.131  18.138 156.217  1.00 54.08           C  
ATOM    895  CG  ASP A 134      -4.821  18.442 154.868  1.00 58.09           C  
ATOM    896  OD1 ASP A 134      -4.178  18.272 153.800  1.00 59.42           O  
ATOM    897  OD2 ASP A 134      -6.009  18.851 154.875  1.00 59.13           O  
ATOM    898  N   PHE A 135      -0.847  18.668 154.663  1.00 48.18           N  
ATOM    899  CA  PHE A 135      -0.082  19.741 154.050  1.00 47.94           C  
ATOM    900  C   PHE A 135      -0.706  20.199 152.752  1.00 47.88           C  
ATOM    901  O   PHE A 135      -1.189  19.393 151.974  1.00 48.46           O  
ATOM    902  CB  PHE A 135       1.350  19.303 153.789  1.00 45.80           C  
ATOM    903  CG  PHE A 135       2.221  20.395 153.247  1.00 45.10           C  
ATOM    904  CD1 PHE A 135       2.804  21.321 154.098  1.00 43.83           C  
ATOM    905  CD2 PHE A 135       2.496  20.466 151.888  1.00 46.04           C  
ATOM    906  CE1 PHE A 135       3.658  22.296 153.618  1.00 44.02           C  
ATOM    907  CE2 PHE A 135       3.352  21.443 151.385  1.00 46.40           C  
ATOM    908  CZ  PHE A 135       3.939  22.361 152.252  1.00 46.22           C  
ATOM    909  N   ARG A 136      -0.686  21.504 152.527  1.00 48.68           N  
ATOM    910  CA  ARG A 136      -1.250  22.092 151.324  1.00 49.39           C  
ATOM    911  C   ARG A 136      -0.244  23.072 150.744  1.00 50.36           C  
ATOM    912  O   ARG A 136       0.067  24.086 151.371  1.00 51.15           O  
ATOM    913  CB  ARG A 136      -2.544  22.848 151.644  1.00 47.79           C  
ATOM    914  CG  ARG A 136      -3.831  22.101 151.371  1.00 49.44           C  
ATOM    915  CD  ARG A 136      -4.266  21.297 152.571  1.00 53.96           C  
ATOM    916  NE  ARG A 136      -5.668  20.878 152.524  1.00 55.95           N  
ATOM    917  CZ  ARG A 136      -6.687  21.665 152.180  1.00 58.41           C  
ATOM    918  NH1 ARG A 136      -6.494  22.931 151.825  1.00 59.35           N  
ATOM    919  NH2 ARG A 136      -7.921  21.193 152.232  1.00 62.18           N  
ATOM    920  N   GLU A 137       0.270  22.791 149.553  1.00 51.11           N  
ATOM    921  CA  GLU A 137       1.226  23.722 148.968  1.00 53.24           C  
ATOM    922  C   GLU A 137       0.527  24.928 148.373  1.00 53.55           C  
ATOM    923  O   GLU A 137      -0.517  24.791 147.738  1.00 53.66           O  
ATOM    924  CB  GLU A 137       2.056  23.056 147.881  1.00 54.34           C  
ATOM    925  CG  GLU A 137       2.946  24.032 147.158  1.00 56.32           C  
ATOM    926  CD  GLU A 137       3.886  23.348 146.181  1.00 61.73           C  
ATOM    927  OE1 GLU A 137       3.435  22.404 145.480  1.00 62.91           O  
ATOM    928  OE2 GLU A 137       5.070  23.765 146.108  1.00 61.63           O  
ATOM    929  N   GLY A 138       1.099  26.110 148.600  1.00 53.94           N  
ATOM    930  CA  GLY A 138       0.522  27.324 148.050  1.00 53.07           C  
ATOM    931  C   GLY A 138       0.260  28.468 149.008  1.00 51.87           C  
ATOM    932  O   GLY A 138       0.263  28.291 150.228  1.00 53.33           O  
ATOM    933  N   PRO A 139       0.016  29.666 148.466  1.00 50.01           N  
ATOM    934  CA  PRO A 139      -0.263  30.888 149.224  1.00 49.70           C  
ATOM    935  C   PRO A 139      -1.420  30.647 150.189  1.00 48.95           C  
ATOM    936  O   PRO A 139      -2.426  30.031 149.824  1.00 48.26           O  
ATOM    937  CB  PRO A 139      -0.635  31.893 148.135  1.00 49.63           C  
ATOM    938  CG  PRO A 139       0.108  31.399 146.936  1.00 48.68           C  
ATOM    939  CD  PRO A 139      -0.087  29.916 147.017  1.00 49.72           C  
ATOM    940  N   ALA A 140      -1.296  31.161 151.406  1.00 48.17           N  
ATOM    941  CA  ALA A 140      -2.330  30.963 152.416  1.00 47.11           C  
ATOM    942  C   ALA A 140      -3.662  31.709 152.236  1.00 46.37           C  
ATOM    943  O   ALA A 140      -4.723  31.102 152.411  1.00 45.36           O  
ATOM    944  CB  ALA A 140      -1.752  31.259 153.793  1.00 47.06           C  
ATOM    945  N   LEU A 141      -3.611  33.003 151.889  1.00 46.31           N  
ATOM    946  CA  LEU A 141      -4.821  33.823 151.726  1.00 45.19           C  
ATOM    947  C   LEU A 141      -5.927  33.190 150.899  1.00 46.49           C  
ATOM    948  O   LEU A 141      -7.072  33.132 151.339  1.00 47.69           O  
ATOM    949  CB  LEU A 141      -4.487  35.171 151.132  1.00 45.01           C  
ATOM    950  CG  LEU A 141      -4.474  36.373 152.069  1.00 48.15           C  
ATOM    951  CD1 LEU A 141      -4.511  37.622 151.184  1.00 48.02           C  
ATOM    952  CD2 LEU A 141      -5.666  36.366 153.043  1.00 46.91           C  
ATOM    953  N   PRO A 142      -5.610  32.730 149.675  1.00 46.41           N  
ATOM    954  CA  PRO A 142      -6.617  32.099 148.822  1.00 45.63           C  
ATOM    955  C   PRO A 142      -7.399  31.041 149.603  1.00 45.77           C  
ATOM    956  O   PRO A 142      -8.627  31.088 149.709  1.00 44.20           O  
ATOM    957  CB  PRO A 142      -5.765  31.477 147.727  1.00 45.03           C  
ATOM    958  CG  PRO A 142      -4.691  32.464 147.559  1.00 44.50           C  
ATOM    959  CD  PRO A 142      -4.317  32.814 148.967  1.00 46.00           C  
ATOM    960  N   VAL A 143      -6.652  30.085 150.150  1.00 47.10           N  
ATOM    961  CA  VAL A 143      -7.220  28.990 150.926  1.00 47.21           C  
ATOM    962  C   VAL A 143      -8.071  29.522 152.060  1.00 47.44           C  
ATOM    963  O   VAL A 143      -9.161  29.018 152.308  1.00 48.10           O  
ATOM    964  CB  VAL A 143      -6.116  28.094 151.516  1.00 46.14           C  
ATOM    965  CG1 VAL A 143      -6.738  26.929 152.276  1.00 44.39           C  
ATOM    966  CG2 VAL A 143      -5.211  27.599 150.407  1.00 44.13           C  
ATOM    967  N   LEU A 144      -7.564  30.538 152.748  1.00 47.35           N  
ATOM    968  CA  LEU A 144      -8.299  31.127 153.852  1.00 49.02           C  
ATOM    969  C   LEU A 144      -9.633  31.648 153.349  1.00 51.74           C  
ATOM    970  O   LEU A 144     -10.691  31.297 153.874  1.00 51.49           O  
ATOM    971  CB  LEU A 144      -7.500  32.274 154.466  1.00 46.89           C  
ATOM    972  CG  LEU A 144      -6.885  32.066 155.846  1.00 45.13           C  
ATOM    973  CD1 LEU A 144      -7.143  30.642 156.320  1.00 46.07           C  
ATOM    974  CD2 LEU A 144      -5.409  32.357 155.785  1.00 43.06           C  
ATOM    975  N   ASP A 145      -9.574  32.491 152.324  1.00 55.20           N  
ATOM    976  CA  ASP A 145     -10.771  33.060 151.751  1.00 58.38           C  
ATOM    977  C   ASP A 145     -11.789  31.995 151.376  1.00 61.99           C  
ATOM    978  O   ASP A 145     -12.996  32.201 151.512  1.00 64.16           O  
ATOM    979  CB  ASP A 145     -10.419  33.903 150.538  1.00 57.10           C  
ATOM    980  CG  ASP A 145      -9.951  35.286 150.920  1.00 57.92           C  
ATOM    981  OD1 ASP A 145     -10.388  35.774 151.985  1.00 57.91           O  
ATOM    982  OD2 ASP A 145      -9.166  35.894 150.156  1.00 57.17           O  
ATOM    983  N   GLU A 146     -11.313  30.845 150.919  1.00 64.65           N  
ATOM    984  CA  GLU A 146     -12.225  29.776 150.544  1.00 66.64           C  
ATOM    985  C   GLU A 146     -12.910  29.165 151.769  1.00 65.16           C  
ATOM    986  O   GLU A 146     -14.115  28.921 151.754  1.00 63.34           O  
ATOM    987  CB  GLU A 146     -11.460  28.729 149.750  1.00 70.89           C  
ATOM    988  CG  GLU A 146     -10.687  29.375 148.606  1.00 78.36           C  
ATOM    989  CD  GLU A 146     -10.040  28.373 147.661  1.00 82.83           C  
ATOM    990  OE1 GLU A 146     -10.789  27.588 147.028  1.00 85.04           O  
ATOM    991  OE2 GLU A 146      -8.786  28.378 147.550  1.00 85.20           O  
ATOM    992  N   MET A 147     -12.149  28.945 152.836  1.00 65.08           N  
ATOM    993  CA  MET A 147     -12.714  28.380 154.057  1.00 65.38           C  
ATOM    994  C   MET A 147     -13.784  29.299 154.626  1.00 66.10           C  
ATOM    995  O   MET A 147     -14.810  28.843 155.125  1.00 65.80           O  
ATOM    996  CB  MET A 147     -11.623  28.163 155.101  1.00 64.27           C  
ATOM    997  CG  MET A 147     -10.498  27.262 154.629  1.00 65.86           C  
ATOM    998  SD  MET A 147      -9.314  26.838 155.931  1.00 67.35           S  
ATOM    999  CE  MET A 147     -10.336  25.729 156.926  1.00 68.14           C  
ATOM   1000  N   ILE A 148     -13.544  30.599 154.540  1.00 67.43           N  
ATOM   1001  CA  ILE A 148     -14.492  31.571 155.060  1.00 69.70           C  
ATOM   1002  C   ILE A 148     -15.894  31.434 154.468  1.00 72.01           C  
ATOM   1003  O   ILE A 148     -16.885  31.659 155.169  1.00 72.64           O  
ATOM   1004  CB  ILE A 148     -13.974  33.017 154.836  1.00 68.16           C  
ATOM   1005  CG1 ILE A 148     -12.865  33.311 155.838  1.00 66.72           C  
ATOM   1006  CG2 ILE A 148     -15.100  34.036 155.004  1.00 66.95           C  
ATOM   1007  CD1 ILE A 148     -13.309  33.185 157.274  1.00 65.58           C  
ATOM   1008  N   LYS A 149     -15.978  31.059 153.191  1.00 74.27           N  
ATOM   1009  CA  LYS A 149     -17.269  30.916 152.513  1.00 76.05           C  
ATOM   1010  C   LYS A 149     -18.180  29.862 153.138  1.00 77.78           C  
ATOM   1011  O   LYS A 149     -19.393  30.045 153.202  1.00 77.72           O  
ATOM   1012  CB  LYS A 149     -17.055  30.599 151.037  1.00 75.63           C  
ATOM   1013  CG  LYS A 149     -16.302  31.677 150.271  1.00 75.31           C  
ATOM   1014  CD  LYS A 149     -16.078  31.231 148.835  1.00 75.92           C  
ATOM   1015  CE  LYS A 149     -15.179  32.184 148.077  1.00 75.91           C  
ATOM   1016  NZ  LYS A 149     -15.007  31.728 146.670  1.00 76.66           N  
ATOM   1017  N   ASP A 150     -17.604  28.754 153.594  1.00 80.31           N  
ATOM   1018  CA  ASP A 150     -18.397  27.708 154.235  1.00 82.70           C  
ATOM   1019  C   ASP A 150     -18.554  28.093 155.705  1.00 83.30           C  
ATOM   1020  O   ASP A 150     -17.569  28.196 156.433  1.00 83.03           O  
ATOM   1021  CB  ASP A 150     -17.691  26.355 154.124  1.00 84.66           C  
ATOM   1022  CG  ASP A 150     -18.569  25.197 154.576  1.00 86.69           C  
ATOM   1023  OD1 ASP A 150     -19.150  25.269 155.685  1.00 88.25           O  
ATOM   1024  OD2 ASP A 150     -18.671  24.209 153.819  1.00 86.80           O  
ATOM   1025  N   GLU A 151     -19.793  28.307 156.133  1.00 84.60           N  
ATOM   1026  CA  GLU A 151     -20.078  28.711 157.507  1.00 85.60           C  
ATOM   1027  C   GLU A 151     -19.677  27.672 158.553  1.00 83.60           C  
ATOM   1028  O   GLU A 151     -19.355  28.015 159.695  1.00 82.23           O  
ATOM   1029  CB  GLU A 151     -21.573  29.029 157.654  1.00 89.38           C  
ATOM   1030  N   LYS A 152     -19.694  26.403 158.167  1.00 81.28           N  
ATOM   1031  CA  LYS A 152     -19.355  25.351 159.103  1.00 79.33           C  
ATOM   1032  C   LYS A 152     -17.892  25.364 159.507  1.00 77.07           C  
ATOM   1033  O   LYS A 152     -17.518  24.720 160.482  1.00 77.37           O  
ATOM   1034  CB  LYS A 152     -19.749  23.987 158.526  1.00 81.44           C  
ATOM   1035  CG  LYS A 152     -21.248  23.898 158.185  1.00 85.24           C  
ATOM   1036  CD  LYS A 152     -21.845  22.492 158.394  1.00 86.44           C  
ATOM   1037  CE  LYS A 152     -22.105  22.172 159.878  1.00 86.85           C  
ATOM   1038  NZ  LYS A 152     -23.134  23.051 160.510  1.00 85.03           N  
ATOM   1039  N   ASN A 153     -17.068  26.101 158.767  1.00 74.36           N  
ATOM   1040  CA  ASN A 153     -15.641  26.199 159.071  1.00 71.81           C  
ATOM   1041  C   ASN A 153     -15.370  27.224 160.173  1.00 69.30           C  
ATOM   1042  O   ASN A 153     -14.352  27.166 160.861  1.00 68.42           O  
ATOM   1043  CB  ASN A 153     -14.843  26.598 157.824  1.00 73.73           C  
ATOM   1044  CG  ASN A 153     -14.667  25.456 156.845  1.00 74.21           C  
ATOM   1045  OD1 ASN A 153     -14.241  24.363 157.217  1.00 75.27           O  
ATOM   1046  ND2 ASN A 153     -14.977  25.713 155.580  1.00 74.77           N  
ATOM   1047  N   HIS A 154     -16.282  28.170 160.334  1.00 66.93           N  
ATOM   1048  CA  HIS A 154     -16.116  29.195 161.349  1.00 64.16           C  
ATOM   1049  C   HIS A 154     -15.984  28.572 162.722  1.00 62.11           C  
ATOM   1050  O   HIS A 154     -16.636  27.584 163.031  1.00 63.06           O  
ATOM   1051  CB  HIS A 154     -17.293  30.169 161.311  1.00 64.00           C  
ATOM   1052  CG  HIS A 154     -17.367  30.963 160.046  1.00 64.30           C  
ATOM   1053  ND1 HIS A 154     -17.904  32.230 159.993  1.00 64.67           N  
ATOM   1054  CD2 HIS A 154     -16.950  30.676 158.789  1.00 64.85           C  
ATOM   1055  CE1 HIS A 154     -17.812  32.692 158.757  1.00 66.37           C  
ATOM   1056  NE2 HIS A 154     -17.237  31.767 158.007  1.00 66.22           N  
ATOM   1057  N   GLY A 155     -15.121  29.151 163.538  1.00 59.70           N  
ATOM   1058  CA  GLY A 155     -14.904  28.633 164.872  1.00 56.98           C  
ATOM   1059  C   GLY A 155     -14.591  27.146 164.964  1.00 55.56           C  
ATOM   1060  O   GLY A 155     -14.975  26.511 165.946  1.00 55.73           O  
ATOM   1061  N   SER A 156     -13.880  26.584 163.988  1.00 53.74           N  
ATOM   1062  CA  SER A 156     -13.583  25.155 164.034  1.00 53.47           C  
ATOM   1063  C   SER A 156     -12.157  24.790 164.418  1.00 53.27           C  
ATOM   1064  O   SER A 156     -11.800  23.604 164.420  1.00 53.04           O  
ATOM   1065  CB  SER A 156     -13.905  24.500 162.690  1.00 53.62           C  
ATOM   1066  OG  SER A 156     -13.043  24.973 161.673  1.00 52.81           O  
ATOM   1067  N   TYR A 157     -11.346  25.798 164.733  1.00 52.46           N  
ATOM   1068  CA  TYR A 157      -9.952  25.573 165.108  1.00 50.64           C  
ATOM   1069  C   TYR A 157      -9.690  25.972 166.539  1.00 50.72           C  
ATOM   1070  O   TYR A 157     -10.250  26.956 167.023  1.00 51.65           O  
ATOM   1071  CB  TYR A 157      -9.017  26.369 164.204  1.00 48.53           C  
ATOM   1072  CG  TYR A 157      -8.982  25.868 162.786  1.00 48.85           C  
ATOM   1073  CD1 TYR A 157      -9.900  26.309 161.841  1.00 49.14           C  
ATOM   1074  CD2 TYR A 157      -8.035  24.936 162.395  1.00 48.97           C  
ATOM   1075  CE1 TYR A 157      -9.862  25.828 160.549  1.00 50.56           C  
ATOM   1076  CE2 TYR A 157      -7.988  24.451 161.117  1.00 48.91           C  
ATOM   1077  CZ  TYR A 157      -8.896  24.894 160.196  1.00 51.42           C  
ATOM   1078  OH  TYR A 157      -8.811  24.400 158.916  1.00 54.37           O  
ATOM   1079  N   ASP A 158      -8.832  25.210 167.212  1.00 50.13           N  
ATOM   1080  CA  ASP A 158      -8.490  25.495 168.597  1.00 49.21           C  
ATOM   1081  C   ASP A 158      -7.263  26.360 168.643  1.00 47.45           C  
ATOM   1082  O   ASP A 158      -7.125  27.185 169.535  1.00 47.75           O  
ATOM   1083  CB  ASP A 158      -8.143  24.225 169.376  1.00 52.53           C  
ATOM   1084  CG  ASP A 158      -9.191  23.162 169.270  1.00 54.89           C  
ATOM   1085  OD1 ASP A 158     -10.394  23.494 169.382  1.00 56.26           O  
ATOM   1086  OD2 ASP A 158      -8.795  21.989 169.088  1.00 55.91           O  
ATOM   1087  N   PHE A 159      -6.360  26.145 167.691  1.00 45.80           N  
ATOM   1088  CA  PHE A 159      -5.092  26.868 167.645  1.00 45.39           C  
ATOM   1089  C   PHE A 159      -4.646  27.177 166.205  1.00 45.76           C  
ATOM   1090  O   PHE A 159      -4.781  26.343 165.304  1.00 46.98           O  
ATOM   1091  CB  PHE A 159      -4.034  26.023 168.370  1.00 43.63           C  
ATOM   1092  CG  PHE A 159      -2.680  26.645 168.422  1.00 42.18           C  
ATOM   1093  CD1 PHE A 159      -2.451  27.772 169.186  1.00 41.28           C  
ATOM   1094  CD2 PHE A 159      -1.627  26.110 167.678  1.00 42.28           C  
ATOM   1095  CE1 PHE A 159      -1.188  28.369 169.213  1.00 41.88           C  
ATOM   1096  CE2 PHE A 159      -0.360  26.695 167.693  1.00 40.15           C  
ATOM   1097  CZ  PHE A 159      -0.140  27.825 168.460  1.00 41.86           C  
ATOM   1098  N   ILE A 160      -4.128  28.382 165.985  1.00 44.19           N  
ATOM   1099  CA  ILE A 160      -3.659  28.770 164.662  1.00 42.37           C  
ATOM   1100  C   ILE A 160      -2.333  29.497 164.781  1.00 40.66           C  
ATOM   1101  O   ILE A 160      -2.253  30.571 165.366  1.00 41.87           O  
ATOM   1102  CB  ILE A 160      -4.672  29.696 163.945  1.00 41.87           C  
ATOM   1103  CG1 ILE A 160      -5.975  28.938 163.701  1.00 43.48           C  
ATOM   1104  CG2 ILE A 160      -4.101  30.170 162.613  1.00 40.67           C  
ATOM   1105  CD1 ILE A 160      -7.103  29.767 163.050  1.00 43.33           C  
ATOM   1106  N   PHE A 161      -1.290  28.914 164.215  1.00 39.23           N  
ATOM   1107  CA  PHE A 161       0.029  29.525 164.270  1.00 38.12           C  
ATOM   1108  C   PHE A 161       0.347  30.204 162.943  1.00 37.62           C  
ATOM   1109  O   PHE A 161       0.274  29.586 161.891  1.00 37.90           O  
ATOM   1110  CB  PHE A 161       1.074  28.461 164.573  1.00 37.16           C  
ATOM   1111  CG  PHE A 161       2.411  29.015 164.929  1.00 38.25           C  
ATOM   1112  CD1 PHE A 161       2.540  29.936 165.948  1.00 38.73           C  
ATOM   1113  CD2 PHE A 161       3.557  28.571 164.284  1.00 39.76           C  
ATOM   1114  CE1 PHE A 161       3.805  30.410 166.329  1.00 41.60           C  
ATOM   1115  CE2 PHE A 161       4.824  29.036 164.660  1.00 41.11           C  
ATOM   1116  CZ  PHE A 161       4.948  29.956 165.681  1.00 40.17           C  
ATOM   1117  N   VAL A 162       0.700  31.481 163.001  1.00 37.08           N  
ATOM   1118  CA  VAL A 162       1.029  32.246 161.813  1.00 37.02           C  
ATOM   1119  C   VAL A 162       2.497  32.644 161.884  1.00 38.07           C  
ATOM   1120  O   VAL A 162       2.870  33.508 162.671  1.00 37.09           O  
ATOM   1121  CB  VAL A 162       0.161  33.529 161.721  1.00 36.97           C  
ATOM   1122  CG1 VAL A 162       0.449  34.274 160.445  1.00 36.99           C  
ATOM   1123  CG2 VAL A 162      -1.290  33.171 161.780  1.00 37.01           C  
ATOM   1124  N   ASP A 163       3.322  31.996 161.064  1.00 39.72           N  
ATOM   1125  CA  ASP A 163       4.756  32.273 161.010  1.00 42.26           C  
ATOM   1126  C   ASP A 163       5.121  32.342 159.527  1.00 43.33           C  
ATOM   1127  O   ASP A 163       6.012  31.644 159.074  1.00 43.97           O  
ATOM   1128  CB  ASP A 163       5.544  31.142 161.712  1.00 41.50           C  
ATOM   1129  CG  ASP A 163       6.981  31.536 162.059  1.00 43.43           C  
ATOM   1130  OD1 ASP A 163       7.328  32.730 162.051  1.00 44.86           O  
ATOM   1131  OD2 ASP A 163       7.784  30.645 162.375  1.00 47.62           O  
ATOM   1132  N   ALA A 164       4.425  33.185 158.774  1.00 45.28           N  
ATOM   1133  CA  ALA A 164       4.678  33.303 157.344  1.00 47.24           C  
ATOM   1134  C   ALA A 164       5.033  34.723 156.935  1.00 48.75           C  
ATOM   1135  O   ALA A 164       5.810  35.378 157.608  1.00 49.53           O  
ATOM   1136  CB  ALA A 164       3.461  32.827 156.573  1.00 46.31           C  
ATOM   1137  N   ASP A 165       4.456  35.187 155.829  1.00 51.17           N  
ATOM   1138  CA  ASP A 165       4.685  36.527 155.286  1.00 52.78           C  
ATOM   1139  C   ASP A 165       5.132  37.619 156.239  1.00 55.39           C  
ATOM   1140  O   ASP A 165       6.335  37.806 156.469  1.00 59.51           O  
ATOM   1141  CB  ASP A 165       3.436  37.017 154.602  1.00 52.04           C  
ATOM   1142  CG  ASP A 165       2.922  36.036 153.602  1.00 51.88           C  
ATOM   1143  OD1 ASP A 165       2.381  35.005 154.049  1.00 50.23           O  
ATOM   1144  OD2 ASP A 165       3.069  36.292 152.383  1.00 50.57           O  
ATOM   1145  N   LYS A 166       4.158  38.360 156.761  1.00 54.93           N  
ATOM   1146  CA  LYS A 166       4.397  39.478 157.691  1.00 54.91           C  
ATOM   1147  C   LYS A 166       3.588  40.627 157.120  1.00 54.42           C  
ATOM   1148  O   LYS A 166       2.746  41.216 157.808  1.00 51.77           O  
ATOM   1149  CB  LYS A 166       5.870  39.874 157.739  1.00 54.27           C  
ATOM   1150  CG  LYS A 166       6.387  40.124 159.127  1.00 56.65           C  
ATOM   1151  CD  LYS A 166       6.353  38.857 159.969  1.00 60.64           C  
ATOM   1152  CE  LYS A 166       7.391  37.819 159.523  1.00 63.17           C  
ATOM   1153  NZ  LYS A 166       7.404  36.578 160.390  1.00 63.33           N  
ATOM   1154  N   ASP A 167       3.839  40.923 155.843  1.00 53.53           N  
ATOM   1155  CA  ASP A 167       3.095  41.967 155.166  1.00 52.71           C  
ATOM   1156  C   ASP A 167       1.732  41.399 154.799  1.00 51.37           C  
ATOM   1157  O   ASP A 167       0.994  41.987 154.014  1.00 51.12           O  
ATOM   1158  CB  ASP A 167       3.843  42.475 153.928  1.00 53.18           C  
ATOM   1159  CG  ASP A 167       4.201  41.371 152.961  1.00 56.19           C  
ATOM   1160  OD1 ASP A 167       4.450  40.237 153.416  1.00 55.67           O  
ATOM   1161  OD2 ASP A 167       4.255  41.646 151.743  1.00 57.18           O  
ATOM   1162  N   ASN A 168       1.401  40.253 155.394  1.00 50.26           N  
ATOM   1163  CA  ASN A 168       0.109  39.608 155.180  1.00 49.78           C  
ATOM   1164  C   ASN A 168      -0.611  39.212 156.471  1.00 49.55           C  
ATOM   1165  O   ASN A 168      -1.708  38.658 156.417  1.00 49.79           O  
ATOM   1166  CB  ASN A 168       0.257  38.361 154.319  1.00 49.55           C  
ATOM   1167  CG  ASN A 168      -0.119  38.604 152.882  1.00 49.27           C  
ATOM   1168  OD1 ASN A 168      -1.209  39.090 152.589  1.00 49.05           O  
ATOM   1169  ND2 ASN A 168       0.782  38.263 151.969  1.00 49.87           N  
ATOM   1170  N   TYR A 169      -0.010  39.498 157.626  1.00 48.47           N  
ATOM   1171  CA  TYR A 169      -0.609  39.132 158.910  1.00 46.03           C  
ATOM   1172  C   TYR A 169      -1.958  39.794 159.150  1.00 44.17           C  
ATOM   1173  O   TYR A 169      -2.911  39.144 159.552  1.00 43.37           O  
ATOM   1174  CB  TYR A 169       0.356  39.469 160.052  1.00 47.56           C  
ATOM   1175  CG  TYR A 169       1.499  38.479 160.222  1.00 48.74           C  
ATOM   1176  CD1 TYR A 169       1.986  37.753 159.138  1.00 49.08           C  
ATOM   1177  CD2 TYR A 169       2.114  38.295 161.462  1.00 49.07           C  
ATOM   1178  CE1 TYR A 169       3.051  36.874 159.277  1.00 49.43           C  
ATOM   1179  CE2 TYR A 169       3.184  37.419 161.607  1.00 49.20           C  
ATOM   1180  CZ  TYR A 169       3.644  36.718 160.507  1.00 50.12           C  
ATOM   1181  OH  TYR A 169       4.720  35.877 160.624  1.00 53.08           O  
ATOM   1182  N   LEU A 170      -2.035  41.092 158.900  1.00 44.42           N  
ATOM   1183  CA  LEU A 170      -3.269  41.840 159.082  1.00 43.37           C  
ATOM   1184  C   LEU A 170      -4.327  41.241 158.188  1.00 43.37           C  
ATOM   1185  O   LEU A 170      -5.489  41.170 158.560  1.00 42.36           O  
ATOM   1186  CB  LEU A 170      -3.055  43.301 158.703  1.00 45.95           C  
ATOM   1187  CG  LEU A 170      -3.305  44.324 159.802  1.00 47.90           C  
ATOM   1188  CD1 LEU A 170      -4.748  44.216 160.271  1.00 52.11           C  
ATOM   1189  CD2 LEU A 170      -2.363  44.075 160.959  1.00 49.62           C  
ATOM   1190  N   ASN A 171      -3.926  40.824 156.993  1.00 44.35           N  
ATOM   1191  CA  ASN A 171      -4.872  40.219 156.073  1.00 45.48           C  
ATOM   1192  C   ASN A 171      -5.328  38.870 156.580  1.00 45.82           C  
ATOM   1193  O   ASN A 171      -6.508  38.549 156.479  1.00 47.37           O  
ATOM   1194  CB  ASN A 171      -4.280  40.063 154.678  1.00 46.31           C  
ATOM   1195  CG  ASN A 171      -4.090  41.389 153.985  1.00 46.53           C  
ATOM   1196  OD1 ASN A 171      -4.864  42.332 154.190  1.00 46.53           O  
ATOM   1197  ND2 ASN A 171      -3.066  41.470 153.147  1.00 48.04           N  
ATOM   1198  N   TYR A 172      -4.399  38.078 157.116  1.00 45.25           N  
ATOM   1199  CA  TYR A 172      -4.746  36.770 157.662  1.00 44.62           C  
ATOM   1200  C   TYR A 172      -5.736  36.968 158.797  1.00 45.70           C  
ATOM   1201  O   TYR A 172      -6.795  36.331 158.838  1.00 45.19           O  
ATOM   1202  CB  TYR A 172      -3.505  36.060 158.195  1.00 43.54           C  
ATOM   1203  CG  TYR A 172      -2.559  35.643 157.112  1.00 43.58           C  
ATOM   1204  CD1 TYR A 172      -3.030  34.994 155.968  1.00 44.87           C  
ATOM   1205  CD2 TYR A 172      -1.196  35.895 157.215  1.00 43.87           C  
ATOM   1206  CE1 TYR A 172      -2.169  34.606 154.948  1.00 45.69           C  
ATOM   1207  CE2 TYR A 172      -0.316  35.514 156.197  1.00 46.39           C  
ATOM   1208  CZ  TYR A 172      -0.813  34.872 155.064  1.00 47.69           C  
ATOM   1209  OH  TYR A 172       0.035  34.518 154.038  1.00 49.67           O  
ATOM   1210  N   HIS A 173      -5.387  37.872 159.711  1.00 45.78           N  
ATOM   1211  CA  HIS A 173      -6.223  38.180 160.860  1.00 46.67           C  
ATOM   1212  C   HIS A 173      -7.685  38.450 160.495  1.00 46.97           C  
ATOM   1213  O   HIS A 173      -8.589  37.996 161.189  1.00 46.96           O  
ATOM   1214  CB  HIS A 173      -5.651  39.378 161.614  1.00 46.68           C  
ATOM   1215  CG  HIS A 173      -6.205  39.538 162.993  1.00 47.28           C  
ATOM   1216  ND1 HIS A 173      -6.151  38.534 163.934  1.00 49.31           N  
ATOM   1217  CD2 HIS A 173      -6.826  40.581 163.590  1.00 47.12           C  
ATOM   1218  CE1 HIS A 173      -6.715  38.949 165.052  1.00 49.98           C  
ATOM   1219  NE2 HIS A 173      -7.134  40.188 164.869  1.00 49.86           N  
ATOM   1220  N   LYS A 174      -7.921  39.192 159.418  1.00 47.99           N  
ATOM   1221  CA  LYS A 174      -9.289  39.486 159.002  1.00 49.12           C  
ATOM   1222  C   LYS A 174     -10.132  38.224 158.936  1.00 48.17           C  
ATOM   1223  O   LYS A 174     -11.276  38.230 159.391  1.00 48.40           O  
ATOM   1224  CB  LYS A 174      -9.306  40.204 157.650  1.00 50.72           C  
ATOM   1225  CG  LYS A 174      -9.195  41.696 157.793  1.00 57.05           C  
ATOM   1226  CD  LYS A 174      -8.733  42.395 156.509  1.00 62.65           C  
ATOM   1227  CE  LYS A 174      -8.578  43.920 156.732  1.00 64.51           C  
ATOM   1228  NZ  LYS A 174      -7.660  44.290 157.875  1.00 65.12           N  
ATOM   1229  N   ARG A 175      -9.576  37.149 158.378  1.00 47.28           N  
ATOM   1230  CA  ARG A 175     -10.320  35.898 158.291  1.00 48.39           C  
ATOM   1231  C   ARG A 175      -9.952  34.879 159.352  1.00 47.73           C  
ATOM   1232  O   ARG A 175     -10.773  34.037 159.715  1.00 48.83           O  
ATOM   1233  CB  ARG A 175     -10.194  35.246 156.907  1.00 48.71           C  
ATOM   1234  CG  ARG A 175      -8.987  35.630 156.108  1.00 50.75           C  
ATOM   1235  CD  ARG A 175      -9.116  37.022 155.524  1.00 48.90           C  
ATOM   1236  NE  ARG A 175      -9.153  36.999 154.067  1.00 48.78           N  
ATOM   1237  CZ  ARG A 175      -8.677  37.971 153.293  1.00 48.21           C  
ATOM   1238  NH1 ARG A 175      -8.123  39.049 153.832  1.00 49.45           N  
ATOM   1239  NH2 ARG A 175      -8.751  37.869 151.977  1.00 46.88           N  
ATOM   1240  N   LEU A 176      -8.731  34.930 159.863  1.00 47.08           N  
ATOM   1241  CA  LEU A 176      -8.364  33.967 160.896  1.00 46.41           C  
ATOM   1242  C   LEU A 176      -9.266  34.126 162.115  1.00 46.43           C  
ATOM   1243  O   LEU A 176      -9.602  33.142 162.745  1.00 46.05           O  
ATOM   1244  CB  LEU A 176      -6.900  34.135 161.304  1.00 43.89           C  
ATOM   1245  CG  LEU A 176      -5.906  33.044 160.892  1.00 43.02           C  
ATOM   1246  CD1 LEU A 176      -6.420  32.236 159.703  1.00 41.54           C  
ATOM   1247  CD2 LEU A 176      -4.569  33.699 160.577  1.00 41.03           C  
ATOM   1248  N   ILE A 177      -9.680  35.358 162.410  1.00 47.02           N  
ATOM   1249  CA  ILE A 177     -10.528  35.662 163.564  1.00 48.27           C  
ATOM   1250  C   ILE A 177     -11.900  35.005 163.574  1.00 50.10           C  
ATOM   1251  O   ILE A 177     -12.503  34.866 164.638  1.00 49.91           O  
ATOM   1252  CB  ILE A 177     -10.776  37.169 163.705  1.00 48.95           C  
ATOM   1253  CG1 ILE A 177     -11.299  37.469 165.106  1.00 48.66           C  
ATOM   1254  CG2 ILE A 177     -11.811  37.635 162.679  1.00 47.59           C  
ATOM   1255  CD1 ILE A 177     -10.306  37.144 166.181  1.00 49.19           C  
ATOM   1256  N   ASP A 178     -12.416  34.644 162.401  1.00 51.02           N  
ATOM   1257  CA  ASP A 178     -13.717  33.985 162.326  1.00 52.13           C  
ATOM   1258  C   ASP A 178     -13.535  32.473 162.301  1.00 51.67           C  
ATOM   1259  O   ASP A 178     -14.468  31.720 162.581  1.00 52.14           O  
ATOM   1260  CB  ASP A 178     -14.503  34.438 161.084  1.00 54.64           C  
ATOM   1261  CG  ASP A 178     -15.244  35.764 161.299  1.00 59.14           C  
ATOM   1262  OD1 ASP A 178     -15.915  35.920 162.353  1.00 60.01           O  
ATOM   1263  OD2 ASP A 178     -15.171  36.647 160.407  1.00 59.69           O  
ATOM   1264  N   LEU A 179     -12.323  32.035 161.971  1.00 50.93           N  
ATOM   1265  CA  LEU A 179     -12.003  30.618 161.912  1.00 49.69           C  
ATOM   1266  C   LEU A 179     -11.528  30.087 163.263  1.00 50.90           C  
ATOM   1267  O   LEU A 179     -11.612  28.892 163.527  1.00 51.11           O  
ATOM   1268  CB  LEU A 179     -10.928  30.377 160.864  1.00 47.84           C  
ATOM   1269  CG  LEU A 179     -11.308  30.700 159.424  1.00 44.21           C  
ATOM   1270  CD1 LEU A 179     -10.104  30.502 158.526  1.00 41.68           C  
ATOM   1271  CD2 LEU A 179     -12.436  29.800 158.989  1.00 44.26           C  
ATOM   1272  N   VAL A 180     -10.989  30.967 164.100  1.00 53.19           N  
ATOM   1273  CA  VAL A 180     -10.574  30.568 165.446  1.00 54.48           C  
ATOM   1274  C   VAL A 180     -11.903  30.479 166.148  1.00 56.85           C  
ATOM   1275  O   VAL A 180     -12.770  31.318 165.920  1.00 60.64           O  
ATOM   1276  CB  VAL A 180      -9.888  31.678 166.260  1.00 53.85           C  
ATOM   1277  CG1 VAL A 180      -8.807  31.085 167.087  1.00 54.52           C  
ATOM   1278  CG2 VAL A 180      -9.411  32.811 165.385  1.00 55.77           C  
ATOM   1279  N   LYS A 181     -12.094  29.516 167.022  1.00 56.77           N  
ATOM   1280  CA  LYS A 181     -13.356  29.516 167.728  1.00 57.57           C  
ATOM   1281  C   LYS A 181     -13.102  30.312 169.011  1.00 56.82           C  
ATOM   1282  O   LYS A 181     -11.946  30.523 169.373  1.00 56.31           O  
ATOM   1283  CB  LYS A 181     -13.778  28.085 168.022  1.00 59.46           C  
ATOM   1284  CG  LYS A 181     -13.388  27.566 169.372  1.00 60.78           C  
ATOM   1285  CD  LYS A 181     -11.905  27.413 169.531  1.00 62.76           C  
ATOM   1286  CE  LYS A 181     -11.620  26.393 170.624  1.00 63.82           C  
ATOM   1287  NZ  LYS A 181     -12.154  25.056 170.225  1.00 64.35           N  
ATOM   1288  N   VAL A 182     -14.152  30.765 169.687  1.00 55.79           N  
ATOM   1289  CA  VAL A 182     -13.974  31.556 170.904  1.00 55.70           C  
ATOM   1290  C   VAL A 182     -12.930  31.030 171.879  1.00 55.45           C  
ATOM   1291  O   VAL A 182     -12.271  31.818 172.558  1.00 54.07           O  
ATOM   1292  CB  VAL A 182     -15.273  31.704 171.637  1.00 57.44           C  
ATOM   1293  CG1 VAL A 182     -16.154  32.727 170.921  1.00 55.69           C  
ATOM   1294  CG2 VAL A 182     -15.948  30.338 171.725  1.00 60.57           C  
ATOM   1295  N   GLY A 183     -12.788  29.706 171.973  1.00 56.03           N  
ATOM   1296  CA  GLY A 183     -11.755  29.144 172.845  1.00 53.81           C  
ATOM   1297  C   GLY A 183     -10.544  30.026 172.609  1.00 50.68           C  
ATOM   1298  O   GLY A 183      -9.945  30.542 173.550  1.00 50.09           O  
ATOM   1299  N   GLY A 184     -10.189  30.183 171.335  1.00 48.29           N  
ATOM   1300  CA  GLY A 184      -9.128  31.099 170.970  1.00 47.76           C  
ATOM   1301  C   GLY A 184      -7.726  30.677 170.637  1.00 46.49           C  
ATOM   1302  O   GLY A 184      -7.446  29.565 170.231  1.00 48.67           O  
ATOM   1303  N   VAL A 185      -6.833  31.629 170.810  1.00 46.50           N  
ATOM   1304  CA  VAL A 185      -5.416  31.455 170.546  1.00 45.70           C  
ATOM   1305  C   VAL A 185      -5.025  31.368 169.073  1.00 44.99           C  
ATOM   1306  O   VAL A 185      -5.340  30.413 168.353  1.00 44.94           O  
ATOM   1307  CB  VAL A 185      -4.828  30.261 171.281  1.00 44.26           C  
ATOM   1308  CG1 VAL A 185      -3.339  30.267 171.090  1.00 45.03           C  
ATOM   1309  CG2 VAL A 185      -5.144  30.346 172.753  1.00 43.58           C  
ATOM   1310  N   ILE A 186      -4.346  32.427 168.657  1.00 42.90           N  
ATOM   1311  CA  ILE A 186      -3.824  32.602 167.326  1.00 41.21           C  
ATOM   1312  C   ILE A 186      -2.440  33.112 167.667  1.00 40.76           C  
ATOM   1313  O   ILE A 186      -2.306  34.034 168.467  1.00 40.59           O  
ATOM   1314  CB  ILE A 186      -4.580  33.711 166.559  1.00 40.40           C  
ATOM   1315  CG1 ILE A 186      -5.997  33.260 166.258  1.00 39.01           C  
ATOM   1316  CG2 ILE A 186      -3.855  34.061 165.259  1.00 38.42           C  
ATOM   1317  CD1 ILE A 186      -6.748  34.270 165.474  1.00 38.77           C  
ATOM   1318  N   GLY A 187      -1.407  32.529 167.091  1.00 39.20           N  
ATOM   1319  CA  GLY A 187      -0.100  33.019 167.437  1.00 40.60           C  
ATOM   1320  C   GLY A 187       0.603  33.689 166.292  1.00 42.49           C  
ATOM   1321  O   GLY A 187       0.784  33.076 165.247  1.00 43.39           O  
ATOM   1322  N   TYR A 188       0.987  34.949 166.476  1.00 43.13           N  
ATOM   1323  CA  TYR A 188       1.723  35.669 165.445  1.00 43.74           C  
ATOM   1324  C   TYR A 188       3.206  35.664 165.845  1.00 44.72           C  
ATOM   1325  O   TYR A 188       3.586  36.117 166.933  1.00 45.70           O  
ATOM   1326  CB  TYR A 188       1.188  37.089 165.301  1.00 43.99           C  
ATOM   1327  CG  TYR A 188      -0.183  37.120 164.688  1.00 46.70           C  
ATOM   1328  CD1 TYR A 188      -0.371  36.827 163.343  1.00 48.72           C  
ATOM   1329  CD2 TYR A 188      -1.309  37.373 165.468  1.00 48.32           C  
ATOM   1330  CE1 TYR A 188      -1.656  36.777 162.788  1.00 50.14           C  
ATOM   1331  CE2 TYR A 188      -2.597  37.328 164.926  1.00 48.73           C  
ATOM   1332  CZ  TYR A 188      -2.766  37.029 163.590  1.00 49.73           C  
ATOM   1333  OH  TYR A 188      -4.038  36.981 163.063  1.00 48.88           O  
ATOM   1334  N   ASP A 189       4.039  35.139 164.957  1.00 44.17           N  
ATOM   1335  CA  ASP A 189       5.455  35.028 165.218  1.00 43.85           C  
ATOM   1336  C   ASP A 189       6.326  36.170 164.726  1.00 43.95           C  
ATOM   1337  O   ASP A 189       6.022  36.822 163.728  1.00 43.17           O  
ATOM   1338  CB  ASP A 189       5.953  33.717 164.629  1.00 46.25           C  
ATOM   1339  CG  ASP A 189       6.927  33.029 165.526  1.00 50.05           C  
ATOM   1340  OD1 ASP A 189       6.725  33.134 166.757  1.00 54.81           O  
ATOM   1341  OD2 ASP A 189       7.879  32.384 165.027  1.00 52.68           O  
ATOM   1342  N   ASN A 190       7.425  36.387 165.443  1.00 44.83           N  
ATOM   1343  CA  ASN A 190       8.413  37.419 165.138  1.00 45.90           C  
ATOM   1344  C   ASN A 190       7.860  38.822 165.292  1.00 44.72           C  
ATOM   1345  O   ASN A 190       8.259  39.749 164.598  1.00 44.17           O  
ATOM   1346  CB  ASN A 190       8.981  37.227 163.729  1.00 49.14           C  
ATOM   1347  CG  ASN A 190       9.470  35.813 163.487  1.00 52.04           C  
ATOM   1348  OD1 ASN A 190       8.718  34.952 163.032  1.00 55.54           O  
ATOM   1349  ND2 ASN A 190      10.733  35.563 163.805  1.00 55.18           N  
ATOM   1350  N   THR A 191       6.947  38.948 166.237  1.00 44.76           N  
ATOM   1351  CA  THR A 191       6.274  40.184 166.579  1.00 46.06           C  
ATOM   1352  C   THR A 191       7.209  41.307 167.093  1.00 47.87           C  
ATOM   1353  O   THR A 191       6.838  42.493 167.123  1.00 46.02           O  
ATOM   1354  CB  THR A 191       5.219  39.825 167.603  1.00 45.21           C  
ATOM   1355  OG1 THR A 191       4.232  39.037 166.946  1.00 47.48           O  
ATOM   1356  CG2 THR A 191       4.580  41.039 168.209  1.00 49.86           C  
ATOM   1357  N   LEU A 192       8.421  40.929 167.497  1.00 49.50           N  
ATOM   1358  CA  LEU A 192       9.390  41.897 167.991  1.00 50.43           C  
ATOM   1359  C   LEU A 192      10.471  42.068 166.941  1.00 51.34           C  
ATOM   1360  O   LEU A 192      11.467  42.746 167.164  1.00 51.93           O  
ATOM   1361  CB  LEU A 192       9.993  41.433 169.320  1.00 51.19           C  
ATOM   1362  CG  LEU A 192       9.016  41.402 170.507  1.00 51.59           C  
ATOM   1363  CD1 LEU A 192       9.781  41.074 171.792  1.00 52.17           C  
ATOM   1364  CD2 LEU A 192       8.318  42.745 170.646  1.00 49.23           C  
ATOM   1365  N   TRP A 193      10.242  41.422 165.799  1.00 52.48           N  
ATOM   1366  CA  TRP A 193      11.096  41.472 164.607  1.00 51.92           C  
ATOM   1367  C   TRP A 193      12.587  41.775 164.829  1.00 52.24           C  
ATOM   1368  O   TRP A 193      13.145  42.736 164.275  1.00 51.40           O  
ATOM   1369  CB  TRP A 193      10.483  42.492 163.635  1.00 50.73           C  
ATOM   1370  CG  TRP A 193      10.976  42.412 162.236  1.00 49.63           C  
ATOM   1371  CD1 TRP A 193      11.441  43.436 161.476  1.00 49.06           C  
ATOM   1372  CD2 TRP A 193      11.010  41.254 161.408  1.00 48.42           C  
ATOM   1373  NE1 TRP A 193      11.763  42.990 160.220  1.00 48.30           N  
ATOM   1374  CE2 TRP A 193      11.504  41.653 160.152  1.00 47.93           C  
ATOM   1375  CE3 TRP A 193      10.662  39.920 161.605  1.00 49.98           C  
ATOM   1376  CZ2 TRP A 193      11.659  40.776 159.103  1.00 49.89           C  
ATOM   1377  CZ3 TRP A 193      10.808  39.060 160.572  1.00 48.36           C  
ATOM   1378  CH2 TRP A 193      11.305  39.489 159.326  1.00 50.00           C  
ATOM   1379  N   ASN A 194      13.236  40.947 165.637  1.00 52.64           N  
ATOM   1380  CA  ASN A 194      14.655  41.120 165.905  1.00 53.56           C  
ATOM   1381  C   ASN A 194      14.896  42.466 166.557  1.00 53.92           C  
ATOM   1382  O   ASN A 194      15.885  43.114 166.267  1.00 56.05           O  
ATOM   1383  CB  ASN A 194      15.445  41.050 164.594  1.00 55.03           C  
ATOM   1384  CG  ASN A 194      16.946  40.864 164.815  1.00 58.39           C  
ATOM   1385  OD1 ASN A 194      17.537  41.482 165.693  1.00 60.94           O  
ATOM   1386  ND2 ASN A 194      17.569  40.024 164.000  1.00 59.86           N  
ATOM   1387  N   GLY A 195      13.991  42.900 167.425  1.00 54.15           N  
ATOM   1388  CA  GLY A 195      14.164  44.185 168.081  1.00 53.23           C  
ATOM   1389  C   GLY A 195      14.143  45.395 167.158  1.00 54.03           C  
ATOM   1390  O   GLY A 195      14.043  46.526 167.629  1.00 53.57           O  
ATOM   1391  N   SER A 196      14.231  45.181 165.846  1.00 55.08           N  
ATOM   1392  CA  SER A 196      14.225  46.305 164.903  1.00 55.67           C  
ATOM   1393  C   SER A 196      13.032  47.242 165.128  1.00 55.84           C  
ATOM   1394  O   SER A 196      12.979  48.326 164.562  1.00 55.70           O  
ATOM   1395  CB  SER A 196      14.238  45.802 163.441  1.00 54.68           C  
ATOM   1396  OG  SER A 196      13.052  45.116 163.085  1.00 53.10           O  
ATOM   1397  N   VAL A 197      12.089  46.826 165.966  1.00 56.54           N  
ATOM   1398  CA  VAL A 197      10.915  47.636 166.253  1.00 58.07           C  
ATOM   1399  C   VAL A 197      11.204  48.877 167.108  1.00 59.98           C  
ATOM   1400  O   VAL A 197      10.316  49.700 167.334  1.00 61.05           O  
ATOM   1401  CB  VAL A 197       9.842  46.799 166.953  1.00 56.76           C  
ATOM   1402  CG1 VAL A 197       9.348  45.727 166.017  1.00 56.09           C  
ATOM   1403  CG2 VAL A 197      10.407  46.178 168.196  1.00 55.68           C  
ATOM   1404  N   VAL A 198      12.438  49.009 167.587  1.00 61.22           N  
ATOM   1405  CA  VAL A 198      12.832  50.156 168.406  1.00 61.77           C  
ATOM   1406  C   VAL A 198      14.249  50.584 168.030  1.00 64.35           C  
ATOM   1407  O   VAL A 198      14.894  51.320 168.768  1.00 64.95           O  
ATOM   1408  CB  VAL A 198      12.816  49.816 169.922  1.00 60.84           C  
ATOM   1409  CG1 VAL A 198      11.409  49.476 170.377  1.00 59.94           C  
ATOM   1410  CG2 VAL A 198      13.743  48.650 170.207  1.00 57.91           C  
ATOM   1411  N   ALA A 199      14.719  50.117 166.875  1.00 67.71           N  
ATOM   1412  CA  ALA A 199      16.062  50.423 166.387  1.00 70.97           C  
ATOM   1413  C   ALA A 199      16.244  51.895 166.045  1.00 74.17           C  
ATOM   1414  O   ALA A 199      15.337  52.539 165.500  1.00 73.13           O  
ATOM   1415  CB  ALA A 199      16.391  49.563 165.170  1.00 70.35           C  
ATOM   1416  N   PRO A 200      17.442  52.440 166.349  1.00 77.43           N  
ATOM   1417  CA  PRO A 200      17.845  53.833 166.119  1.00 79.18           C  
ATOM   1418  C   PRO A 200      17.763  54.290 164.664  1.00 81.71           C  
ATOM   1419  O   PRO A 200      18.374  53.695 163.771  1.00 81.36           O  
ATOM   1420  CB  PRO A 200      19.266  53.870 166.667  1.00 78.34           C  
ATOM   1421  CG  PRO A 200      19.761  52.489 166.393  1.00 77.95           C  
ATOM   1422  CD  PRO A 200      18.591  51.648 166.830  1.00 77.58           C  
ATOM   1423  N   PRO A 201      16.996  55.365 164.417  1.00 84.44           N  
ATOM   1424  CA  PRO A 201      16.780  55.968 163.094  1.00 85.99           C  
ATOM   1425  C   PRO A 201      18.088  56.451 162.481  1.00 87.48           C  
ATOM   1426  O   PRO A 201      18.245  57.650 162.229  1.00 89.08           O  
ATOM   1427  CB  PRO A 201      15.839  57.139 163.394  1.00 85.53           C  
ATOM   1428  CG  PRO A 201      15.111  56.698 164.633  1.00 85.86           C  
ATOM   1429  CD  PRO A 201      16.209  56.070 165.448  1.00 85.27           C  
ATOM   1430  N   ASP A 202      19.023  55.531 162.247  1.00 88.15           N  
ATOM   1431  CA  ASP A 202      20.326  55.881 161.675  1.00 88.45           C  
ATOM   1432  C   ASP A 202      21.283  54.702 161.737  1.00 87.73           C  
ATOM   1433  O   ASP A 202      22.474  54.849 161.455  1.00 87.28           O  
ATOM   1434  CB  ASP A 202      20.953  57.077 162.425  1.00 90.66           C  
ATOM   1435  CG  ASP A 202      21.280  56.763 163.900  1.00 92.81           C  
ATOM   1436  OD1 ASP A 202      22.197  55.949 164.164  1.00 93.73           O  
ATOM   1437  OD2 ASP A 202      20.622  57.339 164.799  1.00 92.78           O  
ATOM   1438  N   ALA A 203      20.764  53.538 162.116  1.00 86.87           N  
ATOM   1439  CA  ALA A 203      21.584  52.339 162.216  1.00 86.67           C  
ATOM   1440  C   ALA A 203      21.145  51.346 161.159  1.00 86.77           C  
ATOM   1441  O   ALA A 203      20.558  50.320 161.485  1.00 87.71           O  
ATOM   1442  CB  ALA A 203      21.433  51.727 163.591  1.00 86.25           C  
ATOM   1443  N   PRO A 204      21.445  51.626 159.876  1.00 86.75           N  
ATOM   1444  CA  PRO A 204      21.050  50.726 158.787  1.00 85.28           C  
ATOM   1445  C   PRO A 204      21.017  49.236 159.144  1.00 82.92           C  
ATOM   1446  O   PRO A 204      21.921  48.704 159.809  1.00 81.94           O  
ATOM   1447  CB  PRO A 204      22.045  51.071 157.679  1.00 86.82           C  
ATOM   1448  CG  PRO A 204      22.187  52.562 157.847  1.00 87.03           C  
ATOM   1449  CD  PRO A 204      22.343  52.685 159.369  1.00 87.71           C  
ATOM   1450  N   LEU A 205      19.938  48.598 158.692  1.00 79.39           N  
ATOM   1451  CA  LEU A 205      19.664  47.190 158.917  1.00 75.45           C  
ATOM   1452  C   LEU A 205      19.526  46.514 157.569  1.00 74.37           C  
ATOM   1453  O   LEU A 205      19.453  47.189 156.547  1.00 73.62           O  
ATOM   1454  CB  LEU A 205      18.360  47.047 159.708  1.00 73.09           C  
ATOM   1455  CG  LEU A 205      17.678  48.352 160.134  1.00 69.61           C  
ATOM   1456  CD1 LEU A 205      16.710  48.792 159.077  1.00 68.47           C  
ATOM   1457  CD2 LEU A 205      16.942  48.157 161.426  1.00 68.42           C  
ATOM   1458  N   ARG A 206      19.491  45.184 157.562  1.00 74.54           N  
ATOM   1459  CA  ARG A 206      19.346  44.442 156.310  1.00 74.85           C  
ATOM   1460  C   ARG A 206      18.106  44.929 155.553  1.00 73.17           C  
ATOM   1461  O   ARG A 206      17.096  45.307 156.148  1.00 73.22           O  
ATOM   1462  CB  ARG A 206      19.220  42.934 156.571  1.00 77.97           C  
ATOM   1463  CG  ARG A 206      20.309  42.318 157.447  1.00 84.04           C  
ATOM   1464  CD  ARG A 206      21.693  42.876 157.124  1.00 89.11           C  
ATOM   1465  NE  ARG A 206      22.043  43.997 157.999  1.00 93.73           N  
ATOM   1466  CZ  ARG A 206      23.052  44.842 157.785  1.00 95.50           C  
ATOM   1467  NH1 ARG A 206      23.823  44.702 156.707  1.00 95.96           N  
ATOM   1468  NH2 ARG A 206      23.299  45.819 158.657  1.00 95.77           N  
ATOM   1469  N   LYS A 207      18.186  44.912 154.233  1.00 70.82           N  
ATOM   1470  CA  LYS A 207      17.083  45.362 153.409  1.00 68.51           C  
ATOM   1471  C   LYS A 207      15.730  44.713 153.731  1.00 66.92           C  
ATOM   1472  O   LYS A 207      14.711  45.405 153.739  1.00 67.22           O  
ATOM   1473  CB  LYS A 207      17.453  45.158 151.938  1.00 70.42           C  
ATOM   1474  CG  LYS A 207      16.411  45.598 150.924  1.00 72.22           C  
ATOM   1475  CD  LYS A 207      17.043  45.917 149.558  1.00 75.07           C  
ATOM   1476  CE  LYS A 207      17.916  44.778 148.984  1.00 76.70           C  
ATOM   1477  NZ  LYS A 207      19.334  44.734 149.494  1.00 76.47           N  
ATOM   1478  N   TYR A 208      15.691  43.410 154.016  1.00 63.88           N  
ATOM   1479  CA  TYR A 208      14.397  42.787 154.296  1.00 61.17           C  
ATOM   1480  C   TYR A 208      13.832  43.066 155.681  1.00 59.57           C  
ATOM   1481  O   TYR A 208      12.621  43.165 155.834  1.00 59.34           O  
ATOM   1482  CB  TYR A 208      14.427  41.275 154.049  1.00 61.64           C  
ATOM   1483  CG  TYR A 208      15.099  40.464 155.126  1.00 65.52           C  
ATOM   1484  CD1 TYR A 208      16.495  40.428 155.247  1.00 67.20           C  
ATOM   1485  CD2 TYR A 208      14.343  39.714 156.029  1.00 67.81           C  
ATOM   1486  CE1 TYR A 208      17.122  39.652 156.248  1.00 67.23           C  
ATOM   1487  CE2 TYR A 208      14.959  38.938 157.035  1.00 67.92           C  
ATOM   1488  CZ  TYR A 208      16.342  38.912 157.132  1.00 67.19           C  
ATOM   1489  OH  TYR A 208      16.933  38.133 158.096  1.00 67.75           O  
ATOM   1490  N   VAL A 209      14.676  43.190 156.701  1.00 57.32           N  
ATOM   1491  CA  VAL A 209      14.128  43.488 158.022  1.00 56.32           C  
ATOM   1492  C   VAL A 209      13.597  44.923 157.998  1.00 54.53           C  
ATOM   1493  O   VAL A 209      12.604  45.249 158.652  1.00 53.28           O  
ATOM   1494  CB  VAL A 209      15.176  43.338 159.151  1.00 55.62           C  
ATOM   1495  CG1 VAL A 209      16.494  43.890 158.712  1.00 57.84           C  
ATOM   1496  CG2 VAL A 209      14.710  44.094 160.399  1.00 54.41           C  
ATOM   1497  N   ARG A 210      14.269  45.773 157.235  1.00 53.34           N  
ATOM   1498  CA  ARG A 210      13.856  47.162 157.089  1.00 53.24           C  
ATOM   1499  C   ARG A 210      12.475  47.216 156.431  1.00 53.17           C  
ATOM   1500  O   ARG A 210      11.634  48.044 156.783  1.00 53.02           O  
ATOM   1501  CB  ARG A 210      14.873  47.906 156.234  1.00 53.76           C  
ATOM   1502  CG  ARG A 210      14.464  49.310 155.846  1.00 54.70           C  
ATOM   1503  CD  ARG A 210      15.691  50.112 155.461  1.00 55.36           C  
ATOM   1504  NE  ARG A 210      15.778  51.299 156.299  1.00 56.68           N  
ATOM   1505  CZ  ARG A 210      16.909  51.780 156.790  1.00 58.38           C  
ATOM   1506  NH1 ARG A 210      18.065  51.177 156.536  1.00 59.21           N  
ATOM   1507  NH2 ARG A 210      16.880  52.872 157.534  1.00 62.31           N  
ATOM   1508  N   TYR A 211      12.257  46.318 155.475  1.00 52.44           N  
ATOM   1509  CA  TYR A 211      10.995  46.225 154.752  1.00 51.45           C  
ATOM   1510  C   TYR A 211       9.835  45.740 155.622  1.00 50.54           C  
ATOM   1511  O   TYR A 211       8.820  46.412 155.722  1.00 51.36           O  
ATOM   1512  CB  TYR A 211      11.146  45.275 153.562  1.00 51.79           C  
ATOM   1513  CG  TYR A 211       9.872  45.084 152.774  1.00 50.94           C  
ATOM   1514  CD1 TYR A 211       9.487  46.008 151.805  1.00 50.78           C  
ATOM   1515  CD2 TYR A 211       9.029  44.004 153.031  1.00 50.14           C  
ATOM   1516  CE1 TYR A 211       8.296  45.866 151.116  1.00 51.57           C  
ATOM   1517  CE2 TYR A 211       7.837  43.850 152.348  1.00 51.25           C  
ATOM   1518  CZ  TYR A 211       7.474  44.786 151.392  1.00 51.51           C  
ATOM   1519  OH  TYR A 211       6.280  44.661 150.720  1.00 52.82           O  
ATOM   1520  N   TYR A 212       9.981  44.566 156.232  1.00 49.48           N  
ATOM   1521  CA  TYR A 212       8.932  44.007 157.075  1.00 50.81           C  
ATOM   1522  C   TYR A 212       8.700  44.745 158.399  1.00 51.40           C  
ATOM   1523  O   TYR A 212       7.696  44.516 159.075  1.00 51.20           O  
ATOM   1524  CB  TYR A 212       9.221  42.535 157.372  1.00 52.31           C  
ATOM   1525  CG  TYR A 212       9.035  41.612 156.195  1.00 54.80           C  
ATOM   1526  CD1 TYR A 212       7.775  41.407 155.636  1.00 57.02           C  
ATOM   1527  CD2 TYR A 212      10.117  40.960 155.625  1.00 56.26           C  
ATOM   1528  CE1 TYR A 212       7.597  40.578 154.542  1.00 56.79           C  
ATOM   1529  CE2 TYR A 212       9.953  40.131 154.523  1.00 57.16           C  
ATOM   1530  CZ  TYR A 212       8.694  39.947 153.989  1.00 57.78           C  
ATOM   1531  OH  TYR A 212       8.542  39.153 152.875  1.00 61.04           O  
ATOM   1532  N   ARG A 213       9.613  45.627 158.783  1.00 51.99           N  
ATOM   1533  CA  ARG A 213       9.434  46.347 160.028  1.00 52.89           C  
ATOM   1534  C   ARG A 213       8.196  47.251 160.037  1.00 54.09           C  
ATOM   1535  O   ARG A 213       7.488  47.338 161.054  1.00 55.07           O  
ATOM   1536  CB  ARG A 213      10.657  47.185 160.347  1.00 52.66           C  
ATOM   1537  CG  ARG A 213      10.535  47.852 161.695  1.00 55.77           C  
ATOM   1538  CD  ARG A 213      11.768  48.640 162.032  1.00 59.00           C  
ATOM   1539  NE  ARG A 213      11.844  49.878 161.276  1.00 61.86           N  
ATOM   1540  CZ  ARG A 213      12.935  50.625 161.207  1.00 64.26           C  
ATOM   1541  NH1 ARG A 213      14.035  50.249 161.849  1.00 65.58           N  
ATOM   1542  NH2 ARG A 213      12.929  51.744 160.498  1.00 65.59           N  
ATOM   1543  N   ASP A 214       7.935  47.932 158.923  1.00 52.55           N  
ATOM   1544  CA  ASP A 214       6.775  48.812 158.857  1.00 51.69           C  
ATOM   1545  C   ASP A 214       5.524  47.959 159.065  1.00 51.05           C  
ATOM   1546  O   ASP A 214       4.564  48.372 159.727  1.00 49.81           O  
ATOM   1547  CB  ASP A 214       6.726  49.523 157.503  1.00 52.06           C  
ATOM   1548  CG  ASP A 214       8.054  50.156 157.131  1.00 53.48           C  
ATOM   1549  OD1 ASP A 214       8.724  50.710 158.026  1.00 55.57           O  
ATOM   1550  OD2 ASP A 214       8.429  50.110 155.940  1.00 54.94           O  
ATOM   1551  N   PHE A 215       5.553  46.752 158.506  1.00 49.66           N  
ATOM   1552  CA  PHE A 215       4.440  45.822 158.633  1.00 48.02           C  
ATOM   1553  C   PHE A 215       4.224  45.310 160.047  1.00 47.21           C  
ATOM   1554  O   PHE A 215       3.093  45.315 160.539  1.00 47.75           O  
ATOM   1555  CB  PHE A 215       4.638  44.660 157.674  1.00 45.92           C  
ATOM   1556  CG  PHE A 215       4.379  45.037 156.275  1.00 44.52           C  
ATOM   1557  CD1 PHE A 215       3.095  45.405 155.889  1.00 43.10           C  
ATOM   1558  CD2 PHE A 215       5.427  45.165 155.366  1.00 44.45           C  
ATOM   1559  CE1 PHE A 215       2.851  45.911 154.624  1.00 42.46           C  
ATOM   1560  CE2 PHE A 215       5.199  45.671 154.088  1.00 44.70           C  
ATOM   1561  CZ  PHE A 215       3.903  46.049 153.716  1.00 43.60           C  
ATOM   1562  N   VAL A 216       5.299  44.871 160.693  1.00 44.75           N  
ATOM   1563  CA  VAL A 216       5.199  44.379 162.044  1.00 44.49           C  
ATOM   1564  C   VAL A 216       4.651  45.468 162.959  1.00 43.53           C  
ATOM   1565  O   VAL A 216       3.648  45.253 163.639  1.00 42.54           O  
ATOM   1566  CB  VAL A 216       6.563  43.891 162.549  1.00 45.52           C  
ATOM   1567  CG1 VAL A 216       6.467  43.441 164.003  1.00 44.60           C  
ATOM   1568  CG2 VAL A 216       7.029  42.725 161.687  1.00 46.25           C  
ATOM   1569  N   LEU A 217       5.286  46.637 162.974  1.00 44.21           N  
ATOM   1570  CA  LEU A 217       4.806  47.740 163.817  1.00 45.99           C  
ATOM   1571  C   LEU A 217       3.301  47.958 163.602  1.00 48.05           C  
ATOM   1572  O   LEU A 217       2.530  48.052 164.566  1.00 48.27           O  
ATOM   1573  CB  LEU A 217       5.548  49.041 163.497  1.00 42.67           C  
ATOM   1574  CG  LEU A 217       7.065  49.104 163.628  1.00 41.64           C  
ATOM   1575  CD1 LEU A 217       7.497  50.554 163.553  1.00 40.20           C  
ATOM   1576  CD2 LEU A 217       7.504  48.523 164.948  1.00 42.25           C  
ATOM   1577  N   GLU A 218       2.907  48.038 162.328  1.00 50.90           N  
ATOM   1578  CA  GLU A 218       1.513  48.221 161.904  1.00 53.10           C  
ATOM   1579  C   GLU A 218       0.638  47.109 162.499  1.00 52.25           C  
ATOM   1580  O   GLU A 218      -0.432  47.372 163.051  1.00 51.91           O  
ATOM   1581  CB  GLU A 218       1.424  48.172 160.372  1.00 56.89           C  
ATOM   1582  CG  GLU A 218       0.000  48.299 159.823  1.00 65.78           C  
ATOM   1583  CD  GLU A 218      -0.161  47.762 158.387  1.00 70.36           C  
ATOM   1584  OE1 GLU A 218       0.261  46.611 158.116  1.00 72.73           O  
ATOM   1585  OE2 GLU A 218      -0.730  48.488 157.535  1.00 73.34           O  
ATOM   1586  N   LEU A 219       1.114  45.869 162.362  1.00 50.19           N  
ATOM   1587  CA  LEU A 219       0.436  44.686 162.874  1.00 46.79           C  
ATOM   1588  C   LEU A 219       0.221  44.833 164.368  1.00 46.84           C  
ATOM   1589  O   LEU A 219      -0.899  44.710 164.853  1.00 47.34           O  
ATOM   1590  CB  LEU A 219       1.290  43.433 162.599  1.00 45.73           C  
ATOM   1591  CG  LEU A 219       0.806  42.003 162.904  1.00 42.54           C  
ATOM   1592  CD1 LEU A 219       1.320  41.555 164.219  1.00 42.34           C  
ATOM   1593  CD2 LEU A 219      -0.705  41.930 162.887  1.00 42.07           C  
ATOM   1594  N   ASN A 220       1.294  45.113 165.098  1.00 45.76           N  
ATOM   1595  CA  ASN A 220       1.193  45.235 166.545  1.00 45.46           C  
ATOM   1596  C   ASN A 220       0.145  46.224 167.021  1.00 45.85           C  
ATOM   1597  O   ASN A 220      -0.657  45.902 167.903  1.00 44.15           O  
ATOM   1598  CB  ASN A 220       2.562  45.558 167.144  1.00 44.48           C  
ATOM   1599  CG  ASN A 220       3.535  44.407 166.984  1.00 43.42           C  
ATOM   1600  OD1 ASN A 220       3.134  43.245 167.027  1.00 45.15           O  
ATOM   1601  ND2 ASN A 220       4.810  44.717 166.811  1.00 41.94           N  
ATOM   1602  N   LYS A 221       0.133  47.416 166.431  1.00 46.52           N  
ATOM   1603  CA  LYS A 221      -0.852  48.413 166.808  1.00 48.02           C  
ATOM   1604  C   LYS A 221      -2.291  47.902 166.580  1.00 48.08           C  
ATOM   1605  O   LYS A 221      -3.149  47.976 167.467  1.00 48.29           O  
ATOM   1606  CB  LYS A 221      -0.613  49.708 166.029  1.00 50.71           C  
ATOM   1607  CG  LYS A 221       0.724  50.397 166.338  1.00 55.35           C  
ATOM   1608  CD  LYS A 221       0.735  51.865 165.837  1.00 59.68           C  
ATOM   1609  CE  LYS A 221       2.040  52.610 166.217  1.00 62.14           C  
ATOM   1610  NZ  LYS A 221       1.843  54.070 166.559  1.00 62.19           N  
ATOM   1611  N   ALA A 222      -2.560  47.364 165.400  1.00 47.60           N  
ATOM   1612  CA  ALA A 222      -3.899  46.864 165.126  1.00 47.28           C  
ATOM   1613  C   ALA A 222      -4.290  45.827 166.164  1.00 46.94           C  
ATOM   1614  O   ALA A 222      -5.392  45.862 166.704  1.00 45.56           O  
ATOM   1615  CB  ALA A 222      -3.967  46.257 163.723  1.00 46.34           C  
ATOM   1616  N   LEU A 223      -3.372  44.907 166.443  1.00 47.56           N  
ATOM   1617  CA  LEU A 223      -3.616  43.839 167.402  1.00 47.93           C  
ATOM   1618  C   LEU A 223      -3.870  44.353 168.819  1.00 49.10           C  
ATOM   1619  O   LEU A 223      -4.791  43.891 169.499  1.00 49.21           O  
ATOM   1620  CB  LEU A 223      -2.434  42.878 167.394  1.00 46.48           C  
ATOM   1621  CG  LEU A 223      -2.699  41.432 166.998  1.00 44.46           C  
ATOM   1622  CD1 LEU A 223      -3.789  41.345 165.947  1.00 43.40           C  
ATOM   1623  CD2 LEU A 223      -1.393  40.843 166.506  1.00 43.24           C  
ATOM   1624  N   ALA A 224      -3.070  45.316 169.262  1.00 49.43           N  
ATOM   1625  CA  ALA A 224      -3.245  45.868 170.597  1.00 49.11           C  
ATOM   1626  C   ALA A 224      -4.573  46.596 170.759  1.00 50.17           C  
ATOM   1627  O   ALA A 224      -5.007  46.837 171.878  1.00 52.35           O  
ATOM   1628  CB  ALA A 224      -2.128  46.807 170.904  1.00 48.25           C  
ATOM   1629  N   VAL A 225      -5.218  46.930 169.645  1.00 50.06           N  
ATOM   1630  CA  VAL A 225      -6.480  47.665 169.658  1.00 49.24           C  
ATOM   1631  C   VAL A 225      -7.703  46.870 169.175  1.00 48.92           C  
ATOM   1632  O   VAL A 225      -8.792  47.422 169.040  1.00 48.95           O  
ATOM   1633  CB  VAL A 225      -6.329  48.967 168.795  1.00 48.97           C  
ATOM   1634  CG1 VAL A 225      -7.645  49.671 168.642  1.00 50.32           C  
ATOM   1635  CG2 VAL A 225      -5.346  49.911 169.448  1.00 48.36           C  
ATOM   1636  N   ASP A 226      -7.543  45.576 168.919  1.00 49.92           N  
ATOM   1637  CA  ASP A 226      -8.670  44.761 168.442  1.00 48.80           C  
ATOM   1638  C   ASP A 226      -9.531  44.278 169.607  1.00 47.97           C  
ATOM   1639  O   ASP A 226      -9.093  43.487 170.441  1.00 45.82           O  
ATOM   1640  CB  ASP A 226      -8.172  43.556 167.626  1.00 48.72           C  
ATOM   1641  CG  ASP A 226      -9.310  42.771 166.976  1.00 50.24           C  
ATOM   1642  OD1 ASP A 226     -10.489  42.955 167.354  1.00 52.74           O  
ATOM   1643  OD2 ASP A 226      -9.029  41.948 166.086  1.00 50.23           O  
ATOM   1644  N   PRO A 227     -10.781  44.760 169.668  1.00 48.77           N  
ATOM   1645  CA  PRO A 227     -11.763  44.428 170.701  1.00 48.63           C  
ATOM   1646  C   PRO A 227     -12.071  42.950 170.756  1.00 48.93           C  
ATOM   1647  O   PRO A 227     -12.416  42.432 171.812  1.00 50.11           O  
ATOM   1648  CB  PRO A 227     -12.989  45.228 170.281  1.00 48.78           C  
ATOM   1649  CG  PRO A 227     -12.414  46.384 169.547  1.00 49.08           C  
ATOM   1650  CD  PRO A 227     -11.345  45.737 168.720  1.00 48.79           C  
ATOM   1651  N   ARG A 228     -11.944  42.269 169.623  1.00 48.80           N  
ATOM   1652  CA  ARG A 228     -12.256  40.850 169.576  1.00 50.44           C  
ATOM   1653  C   ARG A 228     -11.232  39.880 170.174  1.00 50.85           C  
ATOM   1654  O   ARG A 228     -11.505  38.684 170.267  1.00 50.95           O  
ATOM   1655  CB  ARG A 228     -12.550  40.440 168.139  1.00 51.11           C  
ATOM   1656  CG  ARG A 228     -13.581  41.303 167.482  1.00 52.05           C  
ATOM   1657  CD  ARG A 228     -13.925  40.800 166.090  1.00 54.51           C  
ATOM   1658  NE  ARG A 228     -14.566  39.485 166.106  1.00 54.63           N  
ATOM   1659  CZ  ARG A 228     -15.020  38.869 165.018  1.00 54.30           C  
ATOM   1660  NH1 ARG A 228     -14.906  39.451 163.835  1.00 52.91           N  
ATOM   1661  NH2 ARG A 228     -15.573  37.667 165.111  1.00 56.15           N  
ATOM   1662  N   ILE A 229     -10.070  40.377 170.588  1.00 51.22           N  
ATOM   1663  CA  ILE A 229      -9.051  39.500 171.154  1.00 51.06           C  
ATOM   1664  C   ILE A 229      -8.497  39.971 172.508  1.00 53.38           C  
ATOM   1665  O   ILE A 229      -8.825  41.058 172.977  1.00 52.95           O  
ATOM   1666  CB  ILE A 229      -7.884  39.306 170.154  1.00 48.36           C  
ATOM   1667  CG1 ILE A 229      -7.288  40.660 169.781  1.00 46.23           C  
ATOM   1668  CG2 ILE A 229      -8.369  38.561 168.926  1.00 46.60           C  
ATOM   1669  CD1 ILE A 229      -6.244  40.590 168.709  1.00 44.92           C  
ATOM   1670  N   GLU A 230      -7.649  39.131 173.112  1.00 55.55           N  
ATOM   1671  CA  GLU A 230      -7.034  39.367 174.414  1.00 55.87           C  
ATOM   1672  C   GLU A 230      -5.545  39.752 174.324  1.00 55.76           C  
ATOM   1673  O   GLU A 230      -5.104  40.695 174.976  1.00 56.76           O  
ATOM   1674  CB  GLU A 230      -7.183  38.098 175.242  1.00 60.53           C  
ATOM   1675  CG  GLU A 230      -7.359  38.289 176.748  1.00 66.25           C  
ATOM   1676  CD  GLU A 230      -8.682  38.929 177.090  1.00 67.57           C  
ATOM   1677  OE1 GLU A 230      -8.858  40.102 176.718  1.00 68.77           O  
ATOM   1678  OE2 GLU A 230      -9.537  38.258 177.718  1.00 68.45           O  
ATOM   1679  N   ILE A 231      -4.770  39.004 173.543  1.00 54.40           N  
ATOM   1680  CA  ILE A 231      -3.323  39.255 173.326  1.00 54.38           C  
ATOM   1681  C   ILE A 231      -2.313  39.341 174.482  1.00 53.78           C  
ATOM   1682  O   ILE A 231      -2.570  39.939 175.523  1.00 53.74           O  
ATOM   1683  CB  ILE A 231      -3.058  40.530 172.456  1.00 52.95           C  
ATOM   1684  CG1 ILE A 231      -3.191  41.791 173.299  1.00 52.43           C  
ATOM   1685  CG2 ILE A 231      -4.027  40.586 171.288  1.00 54.84           C  
ATOM   1686  CD1 ILE A 231      -2.766  43.050 172.583  1.00 52.36           C  
ATOM   1687  N   CYS A 232      -1.143  38.746 174.245  1.00 53.23           N  
ATOM   1688  CA  CYS A 232      -0.019  38.735 175.176  1.00 52.72           C  
ATOM   1689  C   CYS A 232       1.245  38.647 174.317  1.00 52.05           C  
ATOM   1690  O   CYS A 232       1.378  37.736 173.512  1.00 51.80           O  
ATOM   1691  CB  CYS A 232      -0.100  37.516 176.111  1.00 54.27           C  
ATOM   1692  SG  CYS A 232       1.271  37.364 177.343  1.00 54.40           S  
ATOM   1693  N   MET A 233       2.164  39.591 174.478  1.00 52.06           N  
ATOM   1694  CA  MET A 233       3.406  39.593 173.704  1.00 54.16           C  
ATOM   1695  C   MET A 233       4.574  38.939 174.437  1.00 55.33           C  
ATOM   1696  O   MET A 233       5.278  39.615 175.185  1.00 58.18           O  
ATOM   1697  CB  MET A 233       3.823  41.023 173.372  1.00 54.90           C  
ATOM   1698  CG  MET A 233       3.431  41.514 172.012  1.00 57.64           C  
ATOM   1699  SD  MET A 233       4.220  43.104 171.666  1.00 65.06           S  
ATOM   1700  CE  MET A 233       2.797  44.139 171.429  1.00 62.43           C  
ATOM   1701  N   LEU A 234       4.808  37.648 174.230  1.00 54.30           N  
ATOM   1702  CA  LEU A 234       5.921  36.987 174.909  1.00 52.52           C  
ATOM   1703  C   LEU A 234       7.240  37.165 174.195  1.00 52.29           C  
ATOM   1704  O   LEU A 234       7.349  36.892 173.011  1.00 53.68           O  
ATOM   1705  CB  LEU A 234       5.677  35.498 175.028  1.00 52.88           C  
ATOM   1706  CG  LEU A 234       4.701  34.988 176.063  1.00 54.24           C  
ATOM   1707  CD1 LEU A 234       5.123  33.565 176.368  1.00 55.39           C  
ATOM   1708  CD2 LEU A 234       4.736  35.832 177.324  1.00 54.39           C  
ATOM   1709  N   PRO A 235       8.274  37.604 174.904  1.00 51.80           N  
ATOM   1710  CA  PRO A 235       9.538  37.759 174.194  1.00 52.80           C  
ATOM   1711  C   PRO A 235      10.332  36.464 173.975  1.00 53.85           C  
ATOM   1712  O   PRO A 235      11.565  36.481 173.997  1.00 55.90           O  
ATOM   1713  CB  PRO A 235      10.280  38.772 175.051  1.00 52.47           C  
ATOM   1714  CG  PRO A 235       9.786  38.449 176.413  1.00 52.69           C  
ATOM   1715  CD  PRO A 235       8.312  38.315 176.186  1.00 51.97           C  
ATOM   1716  N   VAL A 236       9.643  35.340 173.771  1.00 53.20           N  
ATOM   1717  CA  VAL A 236      10.339  34.075 173.501  1.00 52.16           C  
ATOM   1718  C   VAL A 236      10.588  34.023 172.007  1.00 51.94           C  
ATOM   1719  O   VAL A 236       9.769  34.502 171.236  1.00 51.41           O  
ATOM   1720  CB  VAL A 236       9.500  32.851 173.836  1.00 51.36           C  
ATOM   1721  CG1 VAL A 236       9.506  32.603 175.315  1.00 52.62           C  
ATOM   1722  CG2 VAL A 236       8.102  33.052 173.335  1.00 51.15           C  
ATOM   1723  N   GLY A 237      11.706  33.432 171.600  1.00 52.09           N  
ATOM   1724  CA  GLY A 237      12.025  33.351 170.184  1.00 51.41           C  
ATOM   1725  C   GLY A 237      12.208  34.749 169.642  1.00 51.33           C  
ATOM   1726  O   GLY A 237      13.060  35.500 170.108  1.00 52.98           O  
ATOM   1727  N   ASP A 238      11.409  35.119 168.657  1.00 50.72           N  
ATOM   1728  CA  ASP A 238      11.512  36.452 168.112  1.00 49.90           C  
ATOM   1729  C   ASP A 238      10.249  37.188 168.528  1.00 49.37           C  
ATOM   1730  O   ASP A 238       9.880  38.215 167.963  1.00 50.61           O  
ATOM   1731  CB  ASP A 238      11.639  36.382 166.600  1.00 52.02           C  
ATOM   1732  CG  ASP A 238      12.066  37.691 166.011  1.00 55.03           C  
ATOM   1733  OD1 ASP A 238      12.865  38.373 166.691  1.00 55.33           O  
ATOM   1734  OD2 ASP A 238      11.618  38.036 164.884  1.00 56.88           O  
ATOM   1735  N   GLY A 239       9.604  36.649 169.552  1.00 48.10           N  
ATOM   1736  CA  GLY A 239       8.382  37.225 170.057  1.00 46.87           C  
ATOM   1737  C   GLY A 239       7.185  36.558 169.410  1.00 46.90           C  
ATOM   1738  O   GLY A 239       7.181  36.335 168.203  1.00 47.91           O  
ATOM   1739  N   ILE A 240       6.189  36.204 170.211  1.00 45.26           N  
ATOM   1740  CA  ILE A 240       4.972  35.605 169.697  1.00 46.28           C  
ATOM   1741  C   ILE A 240       3.922  36.462 170.328  1.00 45.79           C  
ATOM   1742  O   ILE A 240       4.031  36.763 171.510  1.00 46.34           O  
ATOM   1743  CB  ILE A 240       4.683  34.205 170.272  1.00 49.96           C  
ATOM   1744  CG1 ILE A 240       5.924  33.673 170.976  1.00 52.56           C  
ATOM   1745  CG2 ILE A 240       4.146  33.259 169.174  1.00 47.55           C  
ATOM   1746  CD1 ILE A 240       7.098  33.451 170.058  1.00 57.83           C  
ATOM   1747  N   THR A 241       2.925  36.892 169.572  1.00 44.07           N  
ATOM   1748  CA  THR A 241       1.844  37.626 170.211  1.00 42.84           C  
ATOM   1749  C   THR A 241       0.703  36.614 170.287  1.00 43.43           C  
ATOM   1750  O   THR A 241       0.160  36.217 169.260  1.00 43.82           O  
ATOM   1751  CB  THR A 241       1.406  38.852 169.415  1.00 41.42           C  
ATOM   1752  OG1 THR A 241       2.374  39.893 169.573  1.00 41.27           O  
ATOM   1753  CG2 THR A 241       0.078  39.348 169.913  1.00 40.44           C  
ATOM   1754  N   ILE A 242       0.378  36.160 171.495  1.00 43.18           N  
ATOM   1755  CA  ILE A 242      -0.695  35.187 171.671  1.00 45.13           C  
ATOM   1756  C   ILE A 242      -2.047  35.874 171.799  1.00 45.31           C  
ATOM   1757  O   ILE A 242      -2.275  36.643 172.719  1.00 45.58           O  
ATOM   1758  CB  ILE A 242      -0.451  34.280 172.910  1.00 45.73           C  
ATOM   1759  CG1 ILE A 242       0.480  33.128 172.546  1.00 46.09           C  
ATOM   1760  CG2 ILE A 242      -1.749  33.661 173.364  1.00 45.14           C  
ATOM   1761  CD1 ILE A 242       1.801  33.584 172.001  1.00 51.61           C  
ATOM   1762  N   CYS A 243      -2.947  35.567 170.875  1.00 47.07           N  
ATOM   1763  CA  CYS A 243      -4.272  36.179 170.848  1.00 48.50           C  
ATOM   1764  C   CYS A 243      -5.380  35.209 171.199  1.00 49.68           C  
ATOM   1765  O   CYS A 243      -5.530  34.171 170.567  1.00 46.89           O  
ATOM   1766  CB  CYS A 243      -4.550  36.754 169.454  1.00 46.89           C  
ATOM   1767  SG  CYS A 243      -3.260  37.856 168.864  1.00 46.45           S  
ATOM   1768  N   ARG A 244      -6.164  35.566 172.206  1.00 52.66           N  
ATOM   1769  CA  ARG A 244      -7.280  34.739 172.623  1.00 54.86           C  
ATOM   1770  C   ARG A 244      -8.524  35.426 172.102  1.00 56.28           C  
ATOM   1771  O   ARG A 244      -8.772  36.600 172.390  1.00 55.09           O  
ATOM   1772  CB  ARG A 244      -7.332  34.638 174.144  1.00 56.13           C  
ATOM   1773  CG  ARG A 244      -8.380  33.690 174.655  1.00 59.30           C  
ATOM   1774  CD  ARG A 244      -8.321  33.544 176.170  1.00 63.86           C  
ATOM   1775  NE  ARG A 244      -9.671  33.341 176.683  1.00 66.82           N  
ATOM   1776  CZ  ARG A 244     -10.499  34.332 176.997  1.00 67.41           C  
ATOM   1777  NH1 ARG A 244     -10.103  35.600 176.872  1.00 66.57           N  
ATOM   1778  NH2 ARG A 244     -11.740  34.057 177.378  1.00 67.20           N  
ATOM   1779  N   ARG A 245      -9.299  34.708 171.305  1.00 57.75           N  
ATOM   1780  CA  ARG A 245     -10.507  35.300 170.770  1.00 59.98           C  
ATOM   1781  C   ARG A 245     -11.573  35.348 171.849  1.00 62.51           C  
ATOM   1782  O   ARG A 245     -11.797  34.360 172.539  1.00 63.59           O  
ATOM   1783  CB  ARG A 245     -11.015  34.494 169.596  1.00 58.46           C  
ATOM   1784  CG  ARG A 245     -12.188  35.138 168.953  1.00 56.48           C  
ATOM   1785  CD  ARG A 245     -12.842  34.208 167.999  1.00 56.59           C  
ATOM   1786  NE  ARG A 245     -14.113  34.771 167.587  1.00 57.57           N  
ATOM   1787  CZ  ARG A 245     -14.969  34.157 166.789  1.00 56.86           C  
ATOM   1788  NH1 ARG A 245     -14.681  32.957 166.319  1.00 57.55           N  
ATOM   1789  NH2 ARG A 245     -16.107  34.749 166.464  1.00 56.18           N  
ATOM   1790  N   ILE A 246     -12.230  36.493 172.000  1.00 66.18           N  
ATOM   1791  CA  ILE A 246     -13.266  36.619 173.015  1.00 68.38           C  
ATOM   1792  C   ILE A 246     -14.651  36.732 172.397  1.00 70.03           C  
ATOM   1793  O   ILE A 246     -15.656  36.588 173.092  1.00 70.82           O  
ATOM   1794  CB  ILE A 246     -12.976  37.800 173.969  1.00 68.04           C  
ATOM   1795  CG1 ILE A 246     -12.938  39.114 173.204  1.00 68.28           C  
ATOM   1796  CG2 ILE A 246     -11.625  37.572 174.650  1.00 67.75           C  
ATOM   1797  CD1 ILE A 246     -12.534  40.307 174.054  1.00 67.90           C  
ATOM   1798  N   LYS A 247     -14.688  36.950 171.081  1.00 72.00           N  
ATOM   1799  CA  LYS A 247     -15.933  37.016 170.307  1.00 73.66           C  
ATOM   1800  C   LYS A 247     -15.711  37.460 168.856  1.00 74.70           C  
ATOM   1801  O   LYS A 247     -14.650  38.063 168.554  1.00 74.51           O  
ATOM   1802  CB  LYS A 247     -16.964  37.929 170.995  1.00 73.36           C  
ATOM   1803  CG  LYS A 247     -16.532  39.366 171.219  1.00 73.51           C  
ATOM   1804  CD  LYS A 247     -16.842  40.241 170.016  1.00 75.13           C  
ATOM   1805  CE  LYS A 247     -16.599  41.721 170.315  1.00 75.14           C  
ATOM   1806  NZ  LYS A 247     -17.444  42.205 171.442  1.00 74.74           N  
ATOM   1807  OXT LYS A 247     -16.614  37.191 168.029  1.00 75.67           O  
TER    1808      LYS A 247                                                      
END
MOLECULE T0509.pdb
ATOM      1  N   ASN     3      22.807  39.978 177.332  1.00 85.83           N  
ATOM      2  CA  ASN     3      23.661  39.212 178.288  1.00 85.41           C  
ATOM      3  C   ASN     3      22.931  38.088 179.010  1.00 84.96           C  
ATOM      4  O   ASN     3      23.158  36.907 178.737  1.00 84.71           O  
ATOM      5  CB  ASN     3      24.283  40.169 179.320  1.00 85.60           C  
ATOM      6  N   ALA     4      22.046  38.464 179.926  1.00 84.06           N  
ATOM      7  CA  ALA     4      21.329  37.491 180.736  1.00 83.06           C  
ATOM      8  C   ALA     4      20.380  36.562 180.006  1.00 82.36           C  
ATOM      9  O   ALA     4      20.103  35.452 180.462  1.00 82.26           O  
ATOM     10  CB  ALA     4      20.607  38.203 181.891  1.00 82.85           C  
ATOM     11  N   PHE     5      19.905  37.014 178.857  1.00 81.23           N  
ATOM     12  CA  PHE     5      19.008  36.219 178.041  1.00 79.90           C  
ATOM     13  C   PHE     5      19.689  34.923 177.583  1.00 78.36           C  
ATOM     14  O   PHE     5      19.070  33.859 177.581  1.00 77.95           O  
ATOM     15  CB  PHE     5      18.590  37.011 176.806  1.00 80.49           C  
ATOM     16  CG  PHE     5      17.733  36.228 175.838  1.00 82.32           C  
ATOM     17  CD1 PHE     5      16.356  36.140 176.022  1.00 83.80           C  
ATOM     18  CD2 PHE     5      18.306  35.556 174.759  1.00 83.29           C  
ATOM     19  CE1 PHE     5      15.564  35.398 175.148  1.00 85.48           C  
ATOM     20  CE2 PHE     5      17.522  34.810 173.883  1.00 84.01           C  
ATOM     21  CZ  PHE     5      16.149  34.731 174.079  1.00 84.46           C  
ATOM     22  N   GLU     6      20.960  35.016 177.195  1.00 77.13           N  
ATOM     23  CA  GLU     6      21.696  33.867 176.675  1.00 75.49           C  
ATOM     24  C   GLU     6      22.150  32.844 177.700  1.00 73.34           C  
ATOM     25  O   GLU     6      22.237  31.656 177.384  1.00 73.19           O  
ATOM     26  CB  GLU     6      22.890  34.355 175.852  1.00 76.28           C  
ATOM     27  CG  GLU     6      22.530  35.380 174.776  1.00 80.27           C  
ATOM     28  CD  GLU     6      23.464  36.574 174.805  1.00 85.77           C  
ATOM     29  OE1 GLU     6      23.350  37.389 175.746  1.00 88.31           O  
ATOM     30  OE2 GLU     6      24.317  36.691 173.899  1.00 86.53           O  
ATOM     31  N   TYR     7      22.433  33.303 178.915  1.00 71.13           N  
ATOM     32  CA  TYR     7      22.835  32.402 179.977  1.00 68.99           C  
ATOM     33  C   TYR     7      21.579  31.589 180.326  1.00 65.55           C  
ATOM     34  O   TYR     7      21.657  30.395 180.624  1.00 65.44           O  
ATOM     35  CB  TYR     7      23.336  33.190 181.196  1.00 70.74           C  
ATOM     36  CG  TYR     7      24.578  32.584 181.806  1.00 76.24           C  
ATOM     37  CD1 TYR     7      25.455  33.360 182.555  1.00 82.00           C  
ATOM     38  CD2 TYR     7      24.886  31.230 181.618  1.00 81.17           C  
ATOM     39  CE1 TYR     7      26.612  32.812 183.107  1.00 85.04           C  
ATOM     40  CE2 TYR     7      26.039  30.671 182.169  1.00 84.74           C  
ATOM     41  CZ  TYR     7      26.897  31.469 182.910  1.00 86.92           C  
ATOM     42  OH  TYR     7      28.037  30.923 183.455  1.00 89.05           O  
ATOM     43  N   LEU     8      20.416  32.239 180.292  1.00 61.60           N  
ATOM     44  CA  LEU     8      19.157  31.545 180.549  1.00 57.37           C  
ATOM     45  C   LEU     8      18.973  30.589 179.350  1.00 54.56           C  
ATOM     46  O   LEU     8      18.710  29.399 179.527  1.00 52.14           O  
ATOM     47  CB  LEU     8      17.989  32.541 180.606  1.00 57.65           C  
ATOM     48  CG  LEU     8      16.729  32.079 181.345  1.00 56.45           C  
ATOM     49  CD1 LEU     8      17.110  31.130 182.479  1.00 55.09           C  
ATOM     50  CD2 LEU     8      15.999  33.299 181.898  1.00 57.98           C  
ATOM     51  N   ARG     9      19.120  31.107 178.129  1.00 52.49           N  
ATOM     52  CA  ARG     9      18.958  30.280 176.932  1.00 52.08           C  
ATOM     53  C   ARG     9      19.926  29.104 176.942  1.00 51.11           C  
ATOM     54  O   ARG     9      19.532  27.959 176.699  1.00 50.55           O  
ATOM     55  CB  ARG     9      19.141  31.125 175.658  1.00 52.07           C  
ATOM     56  CG  ARG     9      19.009  30.335 174.364  1.00 54.77           C  
ATOM     57  CD  ARG     9      18.455  31.194 173.237  1.00 60.14           C  
ATOM     58  NE  ARG     9      19.283  32.362 172.952  1.00 64.34           N  
ATOM     59  CZ  ARG     9      20.451  32.322 172.316  1.00 68.63           C  
ATOM     60  NH1 ARG     9      20.939  31.164 171.888  1.00 69.94           N  
ATOM     61  NH2 ARG     9      21.131  33.441 172.107  1.00 68.03           N  
ATOM     62  N   THR    10      21.189  29.388 177.240  1.00 50.60           N  
ATOM     63  CA  THR    10      22.217  28.357 177.275  1.00 50.83           C  
ATOM     64  C   THR    10      21.903  27.262 178.291  1.00 49.87           C  
ATOM     65  O   THR    10      22.003  26.074 177.983  1.00 50.46           O  
ATOM     66  CB  THR    10      23.603  28.971 177.581  1.00 51.38           C  
ATOM     67  OG1 THR    10      23.896  29.986 176.608  1.00 51.78           O  
ATOM     68  CG2 THR    10      24.680  27.904 177.521  1.00 50.61           C  
ATOM     69  N   TYR    11      21.521  27.657 179.499  1.00 48.77           N  
ATOM     70  CA  TYR    11      21.185  26.675 180.524  1.00 48.46           C  
ATOM     71  C   TYR    11      19.954  25.857 180.130  1.00 46.71           C  
ATOM     72  O   TYR    11      19.919  24.643 180.332  1.00 46.43           O  
ATOM     73  CB  TYR    11      20.893  27.339 181.860  1.00 50.01           C  
ATOM     74  CG  TYR    11      20.510  26.319 182.902  1.00 52.08           C  
ATOM     75  CD1 TYR    11      21.471  25.474 183.449  1.00 54.43           C  
ATOM     76  CD2 TYR    11      19.173  26.115 183.256  1.00 52.57           C  
ATOM     77  CE1 TYR    11      21.121  24.459 184.331  1.00 56.00           C  
ATOM     78  CE2 TYR    11      18.812  25.101 184.141  1.00 56.55           C  
ATOM     79  CZ  TYR    11      19.795  24.275 184.668  1.00 55.82           C  
ATOM     80  OH  TYR    11      19.458  23.278 185.549  1.00 57.24           O  
ATOM     81  N   VAL    12      18.942  26.515 179.570  1.00 45.29           N  
ATOM     82  CA  VAL    12      17.728  25.810 179.173  1.00 43.79           C  
ATOM     83  C   VAL    12      17.970  24.915 177.964  1.00 44.31           C  
ATOM     84  O   VAL    12      17.489  23.784 177.919  1.00 44.59           O  
ATOM     85  CB  VAL    12      16.575  26.796 178.864  1.00 44.09           C  
ATOM     86  CG1 VAL    12      15.364  26.044 178.307  1.00 38.90           C  
ATOM     87  CG2 VAL    12      16.187  27.557 180.138  1.00 40.82           C  
ATOM     88  N   GLU    13      18.706  25.418 176.982  1.00 45.77           N  
ATOM     89  CA  GLU    13      18.991  24.621 175.801  1.00 47.52           C  
ATOM     90  C   GLU    13      19.917  23.460 176.170  1.00 48.95           C  
ATOM     91  O   GLU    13      19.657  22.312 175.826  1.00 49.14           O  
ATOM     92  CB  GLU    13      19.621  25.491 174.701  1.00 47.27           C  
ATOM     93  CG  GLU    13      18.594  26.143 173.776  1.00 46.73           C  
ATOM     94  CD  GLU    13      19.213  27.051 172.733  1.00 47.14           C  
ATOM     95  OE1 GLU    13      18.462  27.802 172.070  1.00 46.58           O  
ATOM     96  OE2 GLU    13      20.451  27.011 172.568  1.00 48.58           O  
ATOM     97  N   SER    14      20.991  23.759 176.893  1.00 50.77           N  
ATOM     98  CA  SER    14      21.962  22.741 177.291  1.00 52.40           C  
ATOM     99  C   SER    14      21.408  21.764 178.315  1.00 52.24           C  
ATOM    100  O   SER    14      22.111  20.838 178.732  1.00 52.54           O  
ATOM    101  CB  SER    14      23.201  23.405 177.884  1.00 53.25           C  
ATOM    102  OG  SER    14      22.943  23.882 179.203  1.00 55.29           O  
ATOM    103  N   THR    15      20.152  21.956 178.709  1.00 51.44           N  
ATOM    104  CA  THR    15      19.565  21.104 179.726  1.00 50.00           C  
ATOM    105  C   THR    15      18.254  20.425 179.338  1.00 49.00           C  
ATOM    106  O   THR    15      17.740  19.581 180.077  1.00 48.09           O  
ATOM    107  CB  THR    15      19.421  21.928 181.040  1.00 50.48           C  
ATOM    108  OG1 THR    15      19.790  21.124 182.163  1.00 53.93           O  
ATOM    109  CG2 THR    15      18.042  22.429 181.224  1.00 49.25           C  
ATOM    110  N   THR    16      17.709  20.805 178.186  1.00 47.75           N  
ATOM    111  CA  THR    16      16.482  20.191 177.693  1.00 48.20           C  
ATOM    112  C   THR    16      16.843  18.834 177.065  1.00 50.22           C  
ATOM    113  O   THR    16      17.668  18.759 176.143  1.00 52.31           O  
ATOM    114  CB  THR    16      15.795  21.062 176.622  1.00 46.53           C  
ATOM    115  OG1 THR    16      15.318  22.271 177.220  1.00 45.88           O  
ATOM    116  CG2 THR    16      14.625  20.317 175.997  1.00 42.52           C  
ATOM    117  N   GLU    17      16.228  17.764 177.563  1.00 51.38           N  
ATOM    118  CA  GLU    17      16.493  16.421 177.062  1.00 53.69           C  
ATOM    119  C   GLU    17      16.282  16.387 175.556  1.00 54.77           C  
ATOM    120  O   GLU    17      15.184  16.632 175.051  1.00 53.95           O  
ATOM    121  CB  GLU    17      15.569  15.413 177.748  1.00 54.69           C  
ATOM    122  CG  GLU    17      15.799  13.980 177.324  1.00 57.95           C  
ATOM    123  CD  GLU    17      14.636  13.081 177.692  1.00 63.33           C  
ATOM    124  OE1 GLU    17      14.500  12.002 177.075  1.00 66.36           O  
ATOM    125  OE2 GLU    17      13.861  13.451 178.601  1.00 65.09           O  
ATOM    126  N   THR    18      17.345  16.068 174.836  1.00 56.14           N  
ATOM    127  CA  THR    18      17.289  16.046 173.385  1.00 57.87           C  
ATOM    128  C   THR    18      16.318  15.040 172.775  1.00 57.45           C  
ATOM    129  O   THR    18      16.215  13.904 173.238  1.00 57.97           O  
ATOM    130  CB  THR    18      18.709  15.817 172.779  1.00 58.68           C  
ATOM    131  OG1 THR    18      19.251  14.577 173.255  1.00 60.50           O  
ATOM    132  CG2 THR    18      19.660  16.960 173.166  1.00 57.87           C  
ATOM    133  N   ASP    19      15.587  15.481 171.752  1.00 56.51           N  
ATOM    134  CA  ASP    19      14.670  14.600 171.041  1.00 56.34           C  
ATOM    135  C   ASP    19      15.294  14.421 169.648  1.00 55.42           C  
ATOM    136  O   ASP    19      15.637  15.401 168.973  1.00 56.44           O  
ATOM    137  CB  ASP    19      13.263  15.210 170.904  1.00 55.60           C  
ATOM    138  CG  ASP    19      12.348  14.348 170.050  1.00 57.72           C  
ATOM    139  OD1 ASP    19      12.857  13.661 169.136  1.00 62.68           O  
ATOM    140  OD2 ASP    19      11.122  14.363 170.272  1.00 59.68           O  
ATOM    141  N   ALA    20      15.442  13.171 169.218  1.00 53.78           N  
ATOM    142  CA  ALA    20      16.054  12.863 167.926  1.00 51.44           C  
ATOM    143  C   ALA    20      15.281  13.437 166.750  1.00 49.39           C  
ATOM    144  O   ALA    20      15.857  14.097 165.881  1.00 47.69           O  
ATOM    145  CB  ALA    20      16.208  11.346 167.765  1.00 51.74           C  
ATOM    146  N   ALA    21      13.978  13.189 166.728  1.00 46.99           N  
ATOM    147  CA  ALA    21      13.140  13.693 165.655  1.00 44.89           C  
ATOM    148  C   ALA    21      13.208  15.221 165.610  1.00 43.57           C  
ATOM    149  O   ALA    21      13.247  15.812 164.534  1.00 43.64           O  
ATOM    150  CB  ALA    21      11.692  13.224 165.853  1.00 44.67           C  
ATOM    151  N   VAL    22      13.229  15.860 166.779  1.00 41.64           N  
ATOM    152  CA  VAL    22      13.292  17.319 166.849  1.00 39.09           C  
ATOM    153  C   VAL    22      14.655  17.846 166.414  1.00 38.15           C  
ATOM    154  O   VAL    22      14.745  18.838 165.688  1.00 36.18           O  
ATOM    155  CB  VAL    22      12.990  17.834 168.282  1.00 38.83           C  
ATOM    156  CG1 VAL    22      13.345  19.328 168.388  1.00 37.70           C  
ATOM    157  CG2 VAL    22      11.520  17.610 168.622  1.00 36.88           C  
ATOM    158  N   ALA    23      15.719  17.184 166.860  1.00 38.78           N  
ATOM    159  CA  ALA    23      17.070  17.602 166.500  1.00 39.37           C  
ATOM    160  C   ALA    23      17.260  17.469 164.984  1.00 38.28           C  
ATOM    161  O   ALA    23      17.908  18.299 164.359  1.00 37.20           O  
ATOM    162  CB  ALA    23      18.100  16.748 167.239  1.00 39.71           C  
ATOM    163  N   ARG    24      16.692  16.419 164.402  1.00 39.08           N  
ATOM    164  CA  ARG    24      16.800  16.188 162.969  1.00 40.86           C  
ATOM    165  C   ARG    24      16.093  17.324 162.217  1.00 40.75           C  
ATOM    166  O   ARG    24      16.635  17.874 161.249  1.00 40.53           O  
ATOM    167  CB  ARG    24      16.183  14.820 162.628  1.00 41.74           C  
ATOM    168  CG  ARG    24      16.075  14.501 161.150  1.00 49.23           C  
ATOM    169  CD  ARG    24      17.421  14.551 160.446  1.00 54.35           C  
ATOM    170  NE  ARG    24      17.462  13.599 159.339  1.00 59.94           N  
ATOM    171  CZ  ARG    24      18.095  13.812 158.194  1.00 59.09           C  
ATOM    172  NH1 ARG    24      18.742  14.952 158.002  1.00 62.71           N  
ATOM    173  NH2 ARG    24      18.073  12.890 157.241  1.00 60.22           N  
ATOM    174  N   ALA    25      14.891  17.680 162.668  1.00 40.03           N  
ATOM    175  CA  ALA    25      14.128  18.752 162.037  1.00 40.19           C  
ATOM    176  C   ALA    25      14.839  20.105 162.157  1.00 40.52           C  
ATOM    177  O   ALA    25      14.731  20.951 161.261  1.00 41.05           O  
ATOM    178  CB  ALA    25      12.728  18.829 162.649  1.00 40.91           C  
ATOM    179  N   ARG    26      15.564  20.307 163.256  1.00 40.54           N  
ATOM    180  CA  ARG    26      16.300  21.552 163.475  1.00 40.67           C  
ATOM    181  C   ARG    26      17.542  21.569 162.573  1.00 41.44           C  
ATOM    182  O   ARG    26      17.953  22.620 162.081  1.00 43.15           O  
ATOM    183  CB  ARG    26      16.716  21.666 164.945  1.00 40.06           C  
ATOM    184  CG  ARG    26      17.206  23.049 165.344  1.00 41.06           C  
ATOM    185  CD  ARG    26      17.244  23.192 166.860  1.00 39.59           C  
ATOM    186  NE  ARG    26      15.918  23.381 167.448  1.00 36.02           N  
ATOM    187  CZ  ARG    26      15.195  24.489 167.308  1.00 35.63           C  
ATOM    188  NH1 ARG    26      15.676  25.501 166.600  1.00 33.06           N  
ATOM    189  NH2 ARG    26      14.002  24.588 167.884  1.00 31.51           N  
ATOM    190  N   GLU    27      18.141  20.402 162.354  1.00 43.09           N  
ATOM    191  CA  GLU    27      19.306  20.309 161.483  1.00 45.53           C  
ATOM    192  C   GLU    27      18.829  20.549 160.048  1.00 44.47           C  
ATOM    193  O   GLU    27      19.434  21.325 159.304  1.00 44.94           O  
ATOM    194  CB  GLU    27      19.947  18.925 161.590  1.00 47.21           C  
ATOM    195  CG  GLU    27      21.435  18.965 161.907  1.00 56.44           C  
ATOM    196  CD  GLU    27      22.265  19.573 160.788  1.00 64.19           C  
ATOM    197  OE1 GLU    27      22.345  20.818 160.694  1.00 65.65           O  
ATOM    198  OE2 GLU    27      22.830  18.791 159.994  1.00 68.30           O  
ATOM    199  N   ASP    28      17.742  19.882 159.656  1.00 43.22           N  
ATOM    200  CA  ASP    28      17.198  20.053 158.307  1.00 42.84           C  
ATOM    201  C   ASP    28      16.904  21.517 157.990  1.00 42.31           C  
ATOM    202  O   ASP    28      17.295  22.014 156.935  1.00 42.99           O  
ATOM    203  CB  ASP    28      15.924  19.225 158.124  1.00 41.28           C  
ATOM    204  CG  ASP    28      16.209  17.744 157.975  1.00 42.74           C  
ATOM    205  OD1 ASP    28      17.404  17.380 157.943  1.00 44.72           O  
ATOM    206  OD2 ASP    28      15.246  16.946 157.885  1.00 45.45           O  
ATOM    207  N   ALA    29      16.225  22.209 158.902  1.00 41.52           N  
ATOM    208  CA  ALA    29      15.882  23.616 158.687  1.00 40.18           C  
ATOM    209  C   ALA    29      17.117  24.477 158.480  1.00 39.57           C  
ATOM    210  O   ALA    29      17.132  25.362 157.620  1.00 39.63           O  
ATOM    211  CB  ALA    29      15.058  24.154 159.864  1.00 40.56           C  
ATOM    212  N   ALA    30      18.146  24.209 159.275  1.00 39.17           N  
ATOM    213  CA  ALA    30      19.398  24.949 159.198  1.00 40.05           C  
ATOM    214  C   ALA    30      20.107  24.679 157.868  1.00 39.78           C  
ATOM    215  O   ALA    30      20.666  25.591 157.260  1.00 40.00           O  
ATOM    216  CB  ALA    30      20.305  24.561 160.365  1.00 40.11           C  
ATOM    217  N   GLU    31      20.085  23.427 157.422  1.00 38.65           N  
ATOM    218  CA  GLU    31      20.718  23.066 156.159  1.00 38.87           C  
ATOM    219  C   GLU    31      20.078  23.764 154.959  1.00 38.60           C  
ATOM    220  O   GLU    31      20.739  23.995 153.950  1.00 39.71           O  
ATOM    221  CB  GLU    31      20.668  21.552 155.963  1.00 39.36           C  
ATOM    222  CG  GLU    31      21.691  20.795 156.786  1.00 38.74           C  
ATOM    223  CD  GLU    31      21.437  19.310 156.790  1.00 43.41           C  
ATOM    224  OE1 GLU    31      20.865  18.809 155.803  1.00 47.35           O  
ATOM    225  OE2 GLU    31      21.820  18.637 157.764  1.00 48.92           O  
ATOM    226  N   PHE    32      18.796  24.105 155.072  1.00 37.78           N  
ATOM    227  CA  PHE    32      18.071  24.765 153.985  1.00 36.92           C  
ATOM    228  C   PHE    32      17.846  26.256 154.223  1.00 37.72           C  
ATOM    229  O   PHE    32      17.134  26.913 153.457  1.00 36.82           O  
ATOM    230  CB  PHE    32      16.727  24.064 153.758  1.00 35.46           C  
ATOM    231  CG  PHE    32      16.852  22.714 153.100  1.00 35.81           C  
ATOM    232  CD1 PHE    32      16.814  22.592 151.708  1.00 32.38           C  
ATOM    233  CD2 PHE    32      16.998  21.562 153.873  1.00 29.85           C  
ATOM    234  CE1 PHE    32      16.925  21.341 151.098  1.00 34.55           C  
ATOM    235  CE2 PHE    32      17.113  20.313 153.274  1.00 32.22           C  
ATOM    236  CZ  PHE    32      17.074  20.200 151.884  1.00 34.18           C  
ATOM    237  N   GLY    33      18.448  26.777 155.289  1.00 38.67           N  
ATOM    238  CA  GLY    33      18.321  28.190 155.623  1.00 38.55           C  
ATOM    239  C   GLY    33      16.923  28.661 155.983  1.00 37.08           C  
ATOM    240  O   GLY    33      16.572  29.818 155.756  1.00 36.54           O  
ATOM    241  N   LEU    34      16.129  27.765 156.564  1.00 38.38           N  
ATOM    242  CA  LEU    34      14.751  28.092 156.938  1.00 38.59           C  
ATOM    243  C   LEU    34      14.629  28.720 158.321  1.00 37.66           C  
ATOM    244  O   LEU    34      15.399  28.397 159.220  1.00 39.17           O  
ATOM    245  CB  LEU    34      13.887  26.827 156.897  1.00 38.83           C  
ATOM    246  CG  LEU    34      13.963  25.954 155.641  1.00 38.72           C  
ATOM    247  CD1 LEU    34      13.204  24.651 155.855  1.00 40.78           C  
ATOM    248  CD2 LEU    34      13.393  26.715 154.462  1.00 38.26           C  
ATOM    249  N   PRO    35      13.655  29.627 158.500  1.00 38.39           N  
ATOM    250  CA  PRO    35      13.416  30.306 159.780  1.00 39.03           C  
ATOM    251  C   PRO    35      12.913  29.261 160.777  1.00 40.77           C  
ATOM    252  O   PRO    35      11.820  28.713 160.611  1.00 41.07           O  
ATOM    253  CB  PRO    35      12.323  31.328 159.454  1.00 39.92           C  
ATOM    254  CG  PRO    35      12.269  31.377 157.939  1.00 39.36           C  
ATOM    255  CD  PRO    35      12.651  30.009 157.495  1.00 37.58           C  
ATOM    256  N   ALA    36      13.702  29.004 161.819  1.00 41.01           N  
ATOM    257  CA  ALA    36      13.344  27.997 162.818  1.00 40.99           C  
ATOM    258  C   ALA    36      13.320  28.519 164.250  1.00 40.41           C  
ATOM    259  O   ALA    36      14.364  28.860 164.803  1.00 41.47           O  
ATOM    260  CB  ALA    36      14.304  26.820 162.726  1.00 39.29           C  
ATOM    261  N   PRO    37      12.131  28.565 164.869  1.00 39.76           N  
ATOM    262  CA  PRO    37      11.992  29.042 166.250  1.00 37.91           C  
ATOM    263  C   PRO    37      12.926  28.246 167.151  1.00 36.44           C  
ATOM    264  O   PRO    37      13.077  27.035 166.962  1.00 35.90           O  
ATOM    265  CB  PRO    37      10.524  28.755 166.578  1.00 38.50           C  
ATOM    266  CG  PRO    37       9.850  28.774 165.250  1.00 40.52           C  
ATOM    267  CD  PRO    37      10.840  28.108 164.325  1.00 40.07           C  
ATOM    268  N   ASP    38      13.533  28.908 168.135  1.00 34.43           N  
ATOM    269  CA  ASP    38      14.448  28.213 169.038  1.00 34.87           C  
ATOM    270  C   ASP    38      13.717  27.211 169.936  1.00 35.84           C  
ATOM    271  O   ASP    38      12.491  27.094 169.887  1.00 34.82           O  
ATOM    272  CB  ASP    38      15.273  29.226 169.873  1.00 35.43           C  
ATOM    273  CG  ASP    38      14.428  30.055 170.830  1.00 37.24           C  
ATOM    274  OD1 ASP    38      13.181  30.018 170.734  1.00 39.36           O  
ATOM    275  OD2 ASP    38      15.029  30.747 171.687  1.00 41.15           O  
ATOM    276  N   GLU    39      14.478  26.489 170.752  1.00 35.27           N  
ATOM    277  CA  GLU    39      13.916  25.474 171.629  1.00 35.36           C  
ATOM    278  C   GLU    39      12.890  25.983 172.629  1.00 34.78           C  
ATOM    279  O   GLU    39      11.907  25.298 172.910  1.00 35.10           O  
ATOM    280  CB  GLU    39      15.040  24.754 172.372  1.00 36.46           C  
ATOM    281  CG  GLU    39      14.579  23.753 173.433  1.00 39.24           C  
ATOM    282  CD  GLU    39      13.757  22.609 172.864  1.00 42.52           C  
ATOM    283  OE1 GLU    39      14.081  22.141 171.754  1.00 46.69           O  
ATOM    284  OE2 GLU    39      12.795  22.167 173.532  1.00 44.19           O  
ATOM    285  N   MET    40      13.120  27.181 173.155  1.00 33.85           N  
ATOM    286  CA  MET    40      12.224  27.769 174.137  1.00 33.31           C  
ATOM    287  C   MET    40      10.880  28.153 173.523  1.00 31.59           C  
ATOM    288  O   MET    40       9.831  27.983 174.152  1.00 30.49           O  
ATOM    289  CB  MET    40      12.890  28.989 174.807  1.00 32.67           C  
ATOM    290  CG  MET    40      13.914  28.637 175.903  1.00 37.51           C  
ATOM    291  SD  MET    40      14.599  30.227 176.837  1.00 48.82          SE  
ATOM    292  CE  MET    40      16.150  29.483 177.672  1.00 47.77           C  
ATOM    293  N   THR    41      10.918  28.669 172.297  1.00 29.68           N  
ATOM    294  CA  THR    41       9.699  29.043 171.600  1.00 27.32           C  
ATOM    295  C   THR    41       8.914  27.755 171.285  1.00 26.43           C  
ATOM    296  O   THR    41       7.687  27.737 171.383  1.00 27.19           O  
ATOM    297  CB  THR    41      10.025  29.797 170.296  1.00 28.66           C  
ATOM    298  OG1 THR    41      10.738  30.996 170.619  1.00 26.10           O  
ATOM    299  CG2 THR    41       8.741  30.156 169.536  1.00 25.19           C  
ATOM    300  N   GLY    42       9.621  26.685 170.914  1.00 24.88           N  
ATOM    301  CA  GLY    42       8.967  25.414 170.622  1.00 26.74           C  
ATOM    302  C   GLY    42       8.266  24.847 171.858  1.00 27.45           C  
ATOM    303  O   GLY    42       7.145  24.339 171.751  1.00 27.33           O  
ATOM    304  N   GLN    43       8.910  24.928 173.025  1.00 26.78           N  
ATOM    305  CA  GLN    43       8.324  24.434 174.276  1.00 28.12           C  
ATOM    306  C   GLN    43       7.010  25.190 174.550  1.00 27.73           C  
ATOM    307  O   GLN    43       6.005  24.584 174.947  1.00 27.06           O  
ATOM    308  CB  GLN    43       9.332  24.610 175.437  1.00 27.92           C  
ATOM    309  CG  GLN    43      10.505  23.632 175.352  1.00 28.63           C  
ATOM    310  CD  GLN    43      11.578  23.886 176.399  1.00 34.03           C  
ATOM    311  OE1 GLN    43      11.355  24.607 177.373  1.00 36.82           O  
ATOM    312  NE2 GLN    43      12.752  23.290 176.204  1.00 32.59           N  
ATOM    313  N   LEU    44       7.014  26.508 174.335  1.00 27.40           N  
ATOM    314  CA  LEU    44       5.796  27.299 174.512  1.00 27.16           C  
ATOM    315  C   LEU    44       4.729  26.819 173.503  1.00 26.87           C  
ATOM    316  O   LEU    44       3.531  26.837 173.811  1.00 27.06           O  
ATOM    317  CB  LEU    44       6.061  28.795 174.302  1.00 25.60           C  
ATOM    318  CG  LEU    44       4.779  29.647 174.278  1.00 29.19           C  
ATOM    319  CD1 LEU    44       4.004  29.444 175.576  1.00 27.74           C  
ATOM    320  CD2 LEU    44       5.128  31.120 174.085  1.00 24.87           C  
ATOM    321  N   LEU    45       5.143  26.401 172.301  1.00 27.58           N  
ATOM    322  CA  LEU    45       4.174  25.911 171.307  1.00 29.21           C  
ATOM    323  C   LEU    45       3.531  24.614 171.836  1.00 28.50           C  
ATOM    324  O   LEU    45       2.331  24.399 171.691  1.00 29.78           O  
ATOM    325  CB  LEU    45       4.850  25.671 169.936  1.00 27.83           C  
ATOM    326  CG  LEU    45       5.300  26.957 169.216  1.00 30.54           C  
ATOM    327  CD1 LEU    45       5.894  26.601 167.853  1.00 32.59           C  
ATOM    328  CD2 LEU    45       4.104  27.908 169.041  1.00 29.82           C  
ATOM    329  N   THR    46       4.333  23.758 172.457  1.00 27.80           N  
ATOM    330  CA  THR    46       3.826  22.513 173.030  1.00 28.58           C  
ATOM    331  C   THR    46       2.826  22.835 174.150  1.00 27.31           C  
ATOM    332  O   THR    46       1.801  22.178 174.283  1.00 28.48           O  
ATOM    333  CB  THR    46       4.977  21.679 173.620  1.00 27.74           C  
ATOM    334  OG1 THR    46       5.956  21.451 172.604  1.00 28.37           O  
ATOM    335  CG2 THR    46       4.473  20.348 174.134  1.00 28.82           C  
ATOM    336  N   THR    47       3.136  23.852 174.953  1.00 28.69           N  
ATOM    337  CA  THR    47       2.279  24.266 176.060  1.00 27.73           C  
ATOM    338  C   THR    47       0.915  24.733 175.570  1.00 27.47           C  
ATOM    339  O   THR    47      -0.114  24.348 176.127  1.00 27.23           O  
ATOM    340  CB  THR    47       2.920  25.417 176.865  1.00 28.09           C  
ATOM    341  OG1 THR    47       4.170  24.984 177.415  1.00 27.40           O  
ATOM    342  CG2 THR    47       1.993  25.863 178.001  1.00 23.26           C  
ATOM    343  N   LEU    48       0.904  25.562 174.529  1.00 26.00           N  
ATOM    344  CA  LEU    48      -0.357  26.062 173.992  1.00 24.82           C  
ATOM    345  C   LEU    48      -1.138  24.957 173.294  1.00 24.93           C  
ATOM    346  O   LEU    48      -2.370  24.923 173.361  1.00 24.34           O  
ATOM    347  CB  LEU    48      -0.108  27.225 173.025  1.00 26.01           C  
ATOM    348  CG  LEU    48       0.505  28.475 173.683  1.00 30.70           C  
ATOM    349  CD1 LEU    48       0.765  29.551 172.624  1.00 30.77           C  
ATOM    350  CD2 LEU    48      -0.440  29.004 174.770  1.00 26.08           C  
ATOM    351  N   ALA    49      -0.428  24.053 172.620  1.00 25.73           N  
ATOM    352  CA  ALA    49      -1.091  22.953 171.935  1.00 26.68           C  
ATOM    353  C   ALA    49      -1.715  22.043 172.989  1.00 26.17           C  
ATOM    354  O   ALA    49      -2.765  21.445 172.761  1.00 25.74           O  
ATOM    355  CB  ALA    49      -0.084  22.163 171.077  1.00 24.82           C  
ATOM    356  N   ALA    50      -1.056  21.941 174.143  1.00 27.11           N  
ATOM    357  CA  ALA    50      -1.529  21.106 175.245  1.00 27.80           C  
ATOM    358  C   ALA    50      -2.642  21.769 176.057  1.00 29.60           C  
ATOM    359  O   ALA    50      -3.560  21.095 176.516  1.00 32.07           O  
ATOM    360  CB  ALA    50      -0.368  20.750 176.165  1.00 29.92           C  
ATOM    361  N   THR    51      -2.567  23.083 176.235  1.00 29.29           N  
ATOM    362  CA  THR    51      -3.576  23.787 177.009  1.00 30.18           C  
ATOM    363  C   THR    51      -4.841  24.127 176.208  1.00 32.02           C  
ATOM    364  O   THR    51      -5.941  24.063 176.767  1.00 31.22           O  
ATOM    365  CB  THR    51      -2.987  25.075 177.666  1.00 29.68           C  
ATOM    366  OG1 THR    51      -2.623  26.035 176.658  1.00 29.87           O  
ATOM    367  CG2 THR    51      -1.740  24.711 178.484  1.00 27.26           C  
ATOM    368  N   THR    52      -4.701  24.475 174.924  1.00 31.53           N  
ATOM    369  CA  THR    52      -5.877  24.802 174.119  1.00 31.58           C  
ATOM    370  C   THR    52      -6.810  23.597 174.026  1.00 33.91           C  
ATOM    371  O   THR    52      -6.387  22.444 174.151  1.00 34.00           O  
ATOM    372  CB  THR    52      -5.499  25.330 172.708  1.00 30.61           C  
ATOM    373  OG1 THR    52      -4.605  24.419 172.059  1.00 27.87           O  
ATOM    374  CG2 THR    52      -4.853  26.704 172.834  1.00 28.08           C  
ATOM    375  N   ASN    53      -8.085  23.868 173.784  1.00 36.96           N  
ATOM    376  CA  ASN    53      -9.107  22.823 173.780  1.00 41.28           C  
ATOM    377  C   ASN    53      -9.338  21.999 172.524  1.00 42.44           C  
ATOM    378  O   ASN    53      -9.875  22.501 171.540  1.00 42.24           O  
ATOM    379  CB  ASN    53     -10.426  23.449 174.254  1.00 41.27           C  
ATOM    380  CG  ASN    53     -11.429  22.416 174.745  1.00 44.44           C  
ATOM    381  OD1 ASN    53     -11.209  21.212 174.615  1.00 47.26           O  
ATOM    382  ND2 ASN    53     -12.548  22.888 175.303  1.00 47.57           N  
ATOM    383  N   GLY    54      -8.948  20.725 172.586  1.00 43.60           N  
ATOM    384  CA  GLY    54      -9.118  19.838 171.450  1.00 43.79           C  
ATOM    385  C   GLY    54     -10.568  19.477 171.184  1.00 46.01           C  
ATOM    386  O   GLY    54     -10.922  19.091 170.063  1.00 45.16           O  
ATOM    387  N   ASN    55     -11.408  19.603 172.213  1.00 46.67           N  
ATOM    388  CA  ASN    55     -12.834  19.294 172.096  1.00 46.74           C  
ATOM    389  C   ASN    55     -13.559  20.234 171.133  1.00 45.02           C  
ATOM    390  O   ASN    55     -13.647  21.441 171.374  1.00 46.21           O  
ATOM    391  CB  ASN    55     -13.509  19.362 173.473  1.00 48.61           C  
ATOM    392  CG  ASN    55     -13.087  18.220 174.394  1.00 52.70           C  
ATOM    393  OD1 ASN    55     -12.242  18.388 175.277  1.00 56.39           O  
ATOM    394  ND2 ASN    55     -13.671  17.045 174.179  1.00 58.74           N  
ATOM    395  N   GLY    56     -14.082  19.666 170.047  1.00 43.79           N  
ATOM    396  CA  GLY    56     -14.800  20.441 169.044  1.00 40.35           C  
ATOM    397  C   GLY    56     -13.862  21.143 168.080  1.00 38.97           C  
ATOM    398  O   GLY    56     -14.285  21.869 167.182  1.00 39.42           O  
ATOM    399  N   SER    57     -12.571  20.899 168.262  1.00 38.33           N  
ATOM    400  CA  SER    57     -11.535  21.505 167.437  1.00 35.50           C  
ATOM    401  C   SER    57     -10.963  20.557 166.387  1.00 33.56           C  
ATOM    402  O   SER    57     -10.777  19.374 166.646  1.00 31.18           O  
ATOM    403  CB  SER    57     -10.415  22.011 168.349  1.00 35.48           C  
ATOM    404  OG  SER    57      -9.243  22.356 167.632  1.00 34.61           O  
ATOM    405  N   THR    58     -10.681  21.087 165.200  1.00 32.90           N  
ATOM    406  CA  THR    58     -10.094  20.281 164.142  1.00 31.69           C  
ATOM    407  C   THR    58      -8.624  20.066 164.515  1.00 31.06           C  
ATOM    408  O   THR    58      -8.024  19.038 164.175  1.00 31.61           O  
ATOM    409  CB  THR    58     -10.180  20.998 162.777  1.00 32.99           C  
ATOM    410  OG1 THR    58     -11.548  21.305 162.487  1.00 32.94           O  
ATOM    411  CG2 THR    58      -9.628  20.102 161.665  1.00 33.92           C  
ATOM    412  N   GLY    59      -8.051  21.038 165.226  1.00 29.22           N  
ATOM    413  CA  GLY    59      -6.655  20.940 165.629  1.00 27.38           C  
ATOM    414  C   GLY    59      -5.873  22.231 165.456  1.00 28.44           C  
ATOM    415  O   GLY    59      -6.366  23.328 165.734  1.00 27.05           O  
ATOM    416  N   ALA    60      -4.650  22.104 164.964  1.00 27.51           N  
ATOM    417  CA  ALA    60      -3.798  23.261 164.784  1.00 28.53           C  
ATOM    418  C   ALA    60      -3.383  23.494 163.344  1.00 27.12           C  
ATOM    419  O   ALA    60      -3.470  22.598 162.499  1.00 26.54           O  
ATOM    420  CB  ALA    60      -2.553  23.121 165.676  1.00 26.61           C  
ATOM    421  N   ILE    61      -2.936  24.716 163.076  1.00 26.85           N  
ATOM    422  CA  ILE    61      -2.436  25.079 161.757  1.00 25.89           C  
ATOM    423  C   ILE    61      -1.026  25.662 161.925  1.00 26.23           C  
ATOM    424  O   ILE    61      -0.795  26.518 162.789  1.00 24.01           O  
ATOM    425  CB  ILE    61      -3.291  26.156 161.062  1.00 24.77           C  
ATOM    426  CG1 ILE    61      -4.711  25.646 160.832  1.00 26.17           C  
ATOM    427  CG2 ILE    61      -2.667  26.511 159.695  1.00 28.08           C  
ATOM    428  CD1 ILE    61      -5.649  26.690 160.250  1.00 24.83           C  
ATOM    429  N   ALA    62      -0.086  25.172 161.120  1.00 24.83           N  
ATOM    430  CA  ALA    62       1.285  25.687 161.129  1.00 27.04           C  
ATOM    431  C   ALA    62       1.558  26.266 159.728  1.00 26.93           C  
ATOM    432  O   ALA    62       1.616  25.537 158.737  1.00 27.63           O  
ATOM    433  CB  ALA    62       2.302  24.572 161.447  1.00 24.51           C  
ATOM    434  N   ILE    63       1.703  27.582 159.650  1.00 29.03           N  
ATOM    435  CA  ILE    63       1.974  28.269 158.397  1.00 30.40           C  
ATOM    436  C   ILE    63       3.430  28.702 158.444  1.00 30.95           C  
ATOM    437  O   ILE    63       3.771  29.745 159.002  1.00 32.03           O  
ATOM    438  CB  ILE    63       1.057  29.488 158.246  1.00 31.41           C  
ATOM    439  CG1 ILE    63      -0.394  29.016 158.112  1.00 33.10           C  
ATOM    440  CG2 ILE    63       1.472  30.306 157.044  1.00 33.12           C  
ATOM    441  CD1 ILE    63      -1.389  29.915 158.811  1.00 34.01           C  
ATOM    442  N   THR    64       4.289  27.911 157.812  1.00 31.33           N  
ATOM    443  CA  THR    64       5.721  28.179 157.842  1.00 31.25           C  
ATOM    444  C   THR    64       6.492  27.262 156.895  1.00 31.37           C  
ATOM    445  O   THR    64       6.055  26.147 156.621  1.00 31.07           O  
ATOM    446  CB  THR    64       6.248  27.938 159.275  1.00 30.66           C  
ATOM    447  OG1 THR    64       7.678  27.951 159.289  1.00 31.03           O  
ATOM    448  CG2 THR    64       5.768  26.557 159.795  1.00 30.49           C  
ATOM    449  N   PRO    65       7.651  27.719 156.398  1.00 32.35           N  
ATOM    450  CA  PRO    65       8.500  26.936 155.489  1.00 32.48           C  
ATOM    451  C   PRO    65       9.084  25.724 156.212  1.00 33.51           C  
ATOM    452  O   PRO    65       9.439  24.734 155.590  1.00 35.67           O  
ATOM    453  CB  PRO    65       9.603  27.913 155.089  1.00 31.90           C  
ATOM    454  CG  PRO    65       8.961  29.242 155.205  1.00 34.17           C  
ATOM    455  CD  PRO    65       8.050  29.140 156.412  1.00 32.46           C  
ATOM    456  N   ALA    66       9.209  25.823 157.529  1.00 33.82           N  
ATOM    457  CA  ALA    66       9.751  24.726 158.336  1.00 33.47           C  
ATOM    458  C   ALA    66       8.656  24.140 159.222  1.00 34.22           C  
ATOM    459  O   ALA    66       8.747  24.175 160.443  1.00 32.79           O  
ATOM    460  CB  ALA    66      10.897  25.226 159.206  1.00 34.03           C  
ATOM    461  N   ALA    67       7.622  23.586 158.600  1.00 34.58           N  
ATOM    462  CA  ALA    67       6.496  23.008 159.329  1.00 34.68           C  
ATOM    463  C   ALA    67       6.851  21.748 160.101  1.00 35.19           C  
ATOM    464  O   ALA    67       6.146  21.366 161.041  1.00 33.42           O  
ATOM    465  CB  ALA    67       5.348  22.721 158.365  1.00 33.52           C  
ATOM    466  N   GLY    68       7.944  21.108 159.698  1.00 34.05           N  
ATOM    467  CA  GLY    68       8.365  19.888 160.351  1.00 33.14           C  
ATOM    468  C   GLY    68       8.839  20.106 161.776  1.00 33.00           C  
ATOM    469  O   GLY    68       8.451  19.368 162.690  1.00 31.77           O  
ATOM    470  N   LEU    69       9.685  21.111 161.967  1.00 31.47           N  
ATOM    471  CA  LEU    69      10.206  21.409 163.290  1.00 32.26           C  
ATOM    472  C   LEU    69       9.049  21.904 164.167  1.00 33.07           C  
ATOM    473  O   LEU    69       8.747  21.322 165.202  1.00 33.37           O  
ATOM    474  CB  LEU    69      11.316  22.469 163.199  1.00 30.74           C  
ATOM    475  CG  LEU    69      11.850  23.000 164.535  1.00 32.20           C  
ATOM    476  CD1 LEU    69      12.571  21.903 165.298  1.00 32.82           C  
ATOM    477  CD2 LEU    69      12.786  24.161 164.273  1.00 29.97           C  
ATOM    478  N   VAL    70       8.404  22.979 163.737  1.00 33.16           N  
ATOM    479  CA  VAL    70       7.270  23.553 164.456  1.00 34.67           C  
ATOM    480  C   VAL    70       6.188  22.511 164.772  1.00 34.31           C  
ATOM    481  O   VAL    70       5.713  22.433 165.910  1.00 33.10           O  
ATOM    482  CB  VAL    70       6.641  24.707 163.632  1.00 35.05           C  
ATOM    483  CG1 VAL    70       5.295  25.134 164.236  1.00 37.65           C  
ATOM    484  CG2 VAL    70       7.594  25.883 163.595  1.00 33.13           C  
ATOM    485  N   GLY    71       5.818  21.730 163.755  1.00 32.90           N  
ATOM    486  CA  GLY    71       4.791  20.711 163.886  1.00 30.68           C  
ATOM    487  C   GLY    71       5.058  19.658 164.935  1.00 30.85           C  
ATOM    488  O   GLY    71       4.128  19.144 165.564  1.00 31.53           O  
ATOM    489  N   LEU    72       6.329  19.312 165.101  1.00 29.51           N  
ATOM    490  CA  LEU    72       6.718  18.310 166.080  1.00 30.07           C  
ATOM    491  C   LEU    72       6.456  18.822 167.497  1.00 28.95           C  
ATOM    492  O   LEU    72       6.056  18.058 168.379  1.00 29.63           O  
ATOM    493  CB  LEU    72       8.199  17.931 165.905  1.00 28.25           C  
ATOM    494  CG  LEU    72       8.495  17.019 164.697  1.00 28.77           C  
ATOM    495  CD1 LEU    72      10.006  16.853 164.530  1.00 31.04           C  
ATOM    496  CD2 LEU    72       7.842  15.648 164.901  1.00 27.33           C  
ATOM    497  N   TYR    73       6.689  20.111 167.721  1.00 29.65           N  
ATOM    498  CA  TYR    73       6.457  20.703 169.041  1.00 29.58           C  
ATOM    499  C   TYR    73       4.964  20.741 169.333  1.00 28.26           C  
ATOM    500  O   TYR    73       4.531  20.474 170.441  1.00 29.39           O  
ATOM    501  CB  TYR    73       7.009  22.121 169.087  1.00 29.72           C  
ATOM    502  CG  TYR    73       8.499  22.183 169.239  1.00 29.82           C  
ATOM    503  CD1 TYR    73       9.111  21.787 170.432  1.00 29.49           C  
ATOM    504  CD2 TYR    73       9.299  22.677 168.210  1.00 29.76           C  
ATOM    505  CE1 TYR    73      10.485  21.890 170.597  1.00 30.20           C  
ATOM    506  CE2 TYR    73      10.678  22.785 168.362  1.00 28.61           C  
ATOM    507  CZ  TYR    73      11.261  22.396 169.553  1.00 29.90           C  
ATOM    508  OH  TYR    73      12.613  22.544 169.717  1.00 35.40           O  
ATOM    509  N   ILE    74       4.187  21.075 168.313  1.00 27.05           N  
ATOM    510  CA  ILE    74       2.742  21.150 168.431  1.00 26.50           C  
ATOM    511  C   ILE    74       2.135  19.761 168.633  1.00 26.41           C  
ATOM    512  O   ILE    74       1.286  19.576 169.502  1.00 28.29           O  
ATOM    513  CB  ILE    74       2.133  21.843 167.173  1.00 25.58           C  
ATOM    514  CG1 ILE    74       2.499  23.330 167.185  1.00 23.49           C  
ATOM    515  CG2 ILE    74       0.621  21.655 167.133  1.00 22.85           C  
ATOM    516  CD1 ILE    74       1.908  24.129 166.028  1.00 28.06           C  
ATOM    517  N   LEU    75       2.578  18.785 167.838  1.00 29.11           N  
ATOM    518  CA  LEU    75       2.070  17.417 167.943  1.00 31.04           C  
ATOM    519  C   LEU    75       2.324  16.801 169.317  1.00 31.90           C  
ATOM    520  O   LEU    75       1.556  15.959 169.776  1.00 32.45           O  
ATOM    521  CB  LEU    75       2.669  16.541 166.827  1.00 29.40           C  
ATOM    522  CG  LEU    75       2.073  16.841 165.443  1.00 32.38           C  
ATOM    523  CD1 LEU    75       2.908  16.176 164.343  1.00 30.38           C  
ATOM    524  CD2 LEU    75       0.623  16.352 165.404  1.00 29.98           C  
ATOM    525  N   ASN    76       3.395  17.230 169.975  1.00 33.41           N  
ATOM    526  CA  ASN    76       3.712  16.733 171.314  1.00 35.17           C  
ATOM    527  C   ASN    76       2.572  17.013 172.296  1.00 35.09           C  
ATOM    528  O   ASN    76       2.253  16.169 173.134  1.00 36.99           O  
ATOM    529  CB  ASN    76       4.985  17.396 171.838  1.00 34.72           C  
ATOM    530  CG  ASN    76       6.245  16.662 171.424  1.00 39.54           C  
ATOM    531  OD1 ASN    76       7.342  17.238 171.396  1.00 43.81           O  
ATOM    532  ND2 ASN    76       6.101  15.382 171.115  1.00 43.80           N  
ATOM    533  N   GLY    77       1.956  18.193 172.195  1.00 32.65           N  
ATOM    534  CA  GLY    77       0.886  18.548 173.123  1.00 31.47           C  
ATOM    535  C   GLY    77      -0.552  18.330 172.695  1.00 32.40           C  
ATOM    536  O   GLY    77      -1.423  18.051 173.515  1.00 32.95           O  
ATOM    537  N   LEU    78      -0.793  18.459 171.402  1.00 31.49           N  
ATOM    538  CA  LEU    78      -2.120  18.294 170.822  1.00 32.19           C  
ATOM    539  C   LEU    78      -2.823  16.975 171.191  1.00 32.44           C  
ATOM    540  O   LEU    78      -2.192  15.920 171.231  1.00 33.08           O  
ATOM    541  CB  LEU    78      -2.002  18.403 169.302  1.00 29.81           C  
ATOM    542  CG  LEU    78      -2.898  19.317 168.462  1.00 36.01           C  
ATOM    543  CD1 LEU    78      -3.015  20.694 169.104  1.00 31.57           C  
ATOM    544  CD2 LEU    78      -2.310  19.420 167.051  1.00 33.99           C  
ATOM    545  N   ALA    79      -4.125  17.038 171.467  1.00 32.64           N  
ATOM    546  CA  ALA    79      -4.892  15.832 171.782  1.00 34.44           C  
ATOM    547  C   ALA    79      -4.895  14.941 170.513  1.00 36.11           C  
ATOM    548  O   ALA    79      -4.945  15.436 169.369  1.00 34.62           O  
ATOM    549  CB  ALA    79      -6.313  16.202 172.177  1.00 33.20           C  
ATOM    550  N   ASP    80      -4.855  13.626 170.720  1.00 37.28           N  
ATOM    551  CA  ASP    80      -4.807  12.657 169.619  1.00 38.96           C  
ATOM    552  C   ASP    80      -5.900  12.729 168.569  1.00 39.23           C  
ATOM    553  O   ASP    80      -5.662  12.390 167.403  1.00 40.09           O  
ATOM    554  CB  ASP    80      -4.733  11.229 170.168  1.00 39.60           C  
ATOM    555  CG  ASP    80      -3.476  10.985 170.982  1.00 42.87           C  
ATOM    556  OD1 ASP    80      -2.538  11.801 170.863  1.00 44.38           O  
ATOM    557  OD2 ASP    80      -3.422   9.972 171.723  1.00 45.18           O  
ATOM    558  N   ASN    81      -7.082  13.184 168.970  1.00 39.54           N  
ATOM    559  CA  ASN    81      -8.204  13.278 168.047  1.00 39.87           C  
ATOM    560  C   ASN    81      -8.299  14.609 167.305  1.00 39.74           C  
ATOM    561  O   ASN    81      -9.394  15.121 167.052  1.00 39.36           O  
ATOM    562  CB  ASN    81      -9.514  12.983 168.783  1.00 41.88           C  
ATOM    563  CG  ASN    81      -9.823  13.994 169.858  1.00 43.68           C  
ATOM    564  OD1 ASN    81      -8.920  14.588 170.441  1.00 47.17           O  
ATOM    565  ND2 ASN    81     -11.110  14.181 170.145  1.00 46.32           N  
ATOM    566  N   THR    82      -7.140  15.166 166.966  1.00 38.30           N  
ATOM    567  CA  THR    82      -7.066  16.420 166.219  1.00 36.46           C  
ATOM    568  C   THR    82      -5.965  16.231 165.179  1.00 37.02           C  
ATOM    569  O   THR    82      -5.215  15.253 165.228  1.00 35.72           O  
ATOM    570  CB  THR    82      -6.673  17.620 167.113  1.00 36.23           C  
ATOM    571  OG1 THR    82      -5.346  17.421 167.621  1.00 36.98           O  
ATOM    572  CG2 THR    82      -7.648  17.775 168.276  1.00 32.89           C  
ATOM    573  N   THR    83      -5.870  17.152 164.229  1.00 35.99           N  
ATOM    574  CA  THR    83      -4.833  17.056 163.204  1.00 36.94           C  
ATOM    575  C   THR    83      -3.979  18.323 163.161  1.00 35.17           C  
ATOM    576  O   THR    83      -4.354  19.372 163.704  1.00 34.96           O  
ATOM    577  CB  THR    83      -5.419  16.869 161.772  1.00 36.92           C  
ATOM    578  OG1 THR    83      -6.172  18.035 161.406  1.00 39.44           O  
ATOM    579  CG2 THR    83      -6.322  15.639 161.695  1.00 37.40           C  
ATOM    580  N   LEU    84      -2.814  18.214 162.535  1.00 33.33           N  
ATOM    581  CA  LEU    84      -1.956  19.373 162.347  1.00 32.12           C  
ATOM    582  C   LEU    84      -2.042  19.650 160.851  1.00 31.40           C  
ATOM    583  O   LEU    84      -1.809  18.764 160.022  1.00 32.33           O  
ATOM    584  CB  LEU    84      -0.491  19.090 162.727  1.00 32.68           C  
ATOM    585  CG  LEU    84       0.523  20.154 162.264  1.00 29.79           C  
ATOM    586  CD1 LEU    84       0.307  21.474 163.009  1.00 30.01           C  
ATOM    587  CD2 LEU    84       1.929  19.629 162.515  1.00 28.22           C  
ATOM    588  N   THR    85      -2.406  20.875 160.501  1.00 32.14           N  
ATOM    589  CA  THR    85      -2.507  21.273 159.104  1.00 30.98           C  
ATOM    590  C   THR    85      -1.329  22.197 158.812  1.00 31.89           C  
ATOM    591  O   THR    85      -1.208  23.272 159.401  1.00 32.68           O  
ATOM    592  CB  THR    85      -3.837  22.004 158.831  1.00 30.16           C  
ATOM    593  OG1 THR    85      -4.924  21.091 159.026  1.00 30.62           O  
ATOM    594  CG2 THR    85      -3.875  22.553 157.416  1.00 30.92           C  
ATOM    595  N   CYS    86      -0.458  21.762 157.906  1.00 32.18           N  
ATOM    596  CA  CYS    86       0.714  22.537 157.518  1.00 31.91           C  
ATOM    597  C   CYS    86       0.448  23.205 156.180  1.00 32.73           C  
ATOM    598  O   CYS    86      -0.146  22.612 155.283  1.00 33.43           O  
ATOM    599  CB  CYS    86       1.939  21.633 157.398  1.00 31.46           C  
ATOM    600  SG  CYS    86       2.309  20.684 158.888  1.00 30.56           S  
ATOM    601  N   ILE    87       0.900  24.445 156.047  1.00 32.21           N  
ATOM    602  CA  ILE    87       0.681  25.199 154.820  1.00 32.24           C  
ATOM    603  C   ILE    87       1.921  25.904 154.279  1.00 34.38           C  
ATOM    604  O   ILE    87       2.488  26.779 154.948  1.00 35.36           O  
ATOM    605  CB  ILE    87      -0.392  26.294 155.018  1.00 31.54           C  
ATOM    606  CG1 ILE    87      -1.607  25.723 155.753  1.00 28.05           C  
ATOM    607  CG2 ILE    87      -0.785  26.889 153.665  1.00 28.77           C  
ATOM    608  CD1 ILE    87      -2.753  26.703 155.903  1.00 31.08           C  
ATOM    609  N   ASP    88       2.344  25.505 153.082  1.00 34.03           N  
ATOM    610  CA  ASP    88       3.466  26.138 152.400  1.00 34.37           C  
ATOM    611  C   ASP    88       3.368  25.786 150.906  1.00 33.50           C  
ATOM    612  O   ASP    88       2.976  24.679 150.548  1.00 33.15           O  
ATOM    613  CB  ASP    88       4.823  25.687 152.965  1.00 32.69           C  
ATOM    614  CG  ASP    88       5.983  26.521 152.414  1.00 32.83           C  
ATOM    615  OD1 ASP    88       6.150  27.677 152.852  1.00 33.51           O  
ATOM    616  OD2 ASP    88       6.707  26.028 151.526  1.00 31.22           O  
ATOM    617  N   PRO    89       3.705  26.738 150.021  1.00 35.06           N  
ATOM    618  CA  PRO    89       3.654  26.536 148.564  1.00 37.30           C  
ATOM    619  C   PRO    89       4.796  25.746 147.929  1.00 39.95           C  
ATOM    620  O   PRO    89       4.690  25.310 146.781  1.00 40.65           O  
ATOM    621  CB  PRO    89       3.600  27.962 148.019  1.00 36.50           C  
ATOM    622  CG  PRO    89       4.416  28.736 149.005  1.00 33.94           C  
ATOM    623  CD  PRO    89       4.032  28.139 150.356  1.00 35.74           C  
ATOM    624  N   GLU    90       5.882  25.561 148.672  1.00 40.63           N  
ATOM    625  CA  GLU    90       7.049  24.865 148.164  1.00 41.49           C  
ATOM    626  C   GLU    90       6.934  23.361 148.357  1.00 41.43           C  
ATOM    627  O   GLU    90       6.688  22.892 149.464  1.00 42.37           O  
ATOM    628  CB  GLU    90       8.290  25.445 148.855  1.00 42.68           C  
ATOM    629  CG  GLU    90       9.148  26.359 147.968  1.00 47.20           C  
ATOM    630  CD  GLU    90       8.355  27.215 146.988  1.00 50.57           C  
ATOM    631  OE1 GLU    90       7.985  28.356 147.335  1.00 54.15           O  
ATOM    632  OE2 GLU    90       8.093  26.733 145.867  1.00 51.33           O  
ATOM    633  N   SER    91       7.118  22.606 147.277  1.00 40.04           N  
ATOM    634  CA  SER    91       6.974  21.159 147.346  1.00 40.28           C  
ATOM    635  C   SER    91       8.046  20.403 148.106  1.00 39.22           C  
ATOM    636  O   SER    91       7.757  19.360 148.698  1.00 38.91           O  
ATOM    637  CB  SER    91       6.795  20.574 145.938  1.00 40.80           C  
ATOM    638  OG  SER    91       7.828  20.986 145.076  1.00 47.75           O  
ATOM    639  N   GLU    92       9.273  20.917 148.105  1.00 38.40           N  
ATOM    640  CA  GLU    92      10.328  20.254 148.855  1.00 37.79           C  
ATOM    641  C   GLU    92      10.055  20.488 150.350  1.00 35.86           C  
ATOM    642  O   GLU    92      10.494  19.697 151.190  1.00 34.88           O  
ATOM    643  CB  GLU    92      11.724  20.777 148.458  1.00 37.99           C  
ATOM    644  CG  GLU    92      12.018  22.231 148.746  1.00 38.66           C  
ATOM    645  CD  GLU    92      13.401  22.629 148.226  1.00 39.16           C  
ATOM    646  OE1 GLU    92      13.730  23.832 148.234  1.00 44.47           O  
ATOM    647  OE2 GLU    92      14.165  21.728 147.819  1.00 39.56           O  
ATOM    648  N   HIS    93       9.339  21.565 150.689  1.00 34.44           N  
ATOM    649  CA  HIS    93       8.997  21.824 152.087  1.00 34.73           C  
ATOM    650  C   HIS    93       7.952  20.787 152.502  1.00 36.07           C  
ATOM    651  O   HIS    93       7.934  20.348 153.652  1.00 37.25           O  
ATOM    652  CB  HIS    93       8.472  23.258 152.258  1.00 34.41           C  
ATOM    653  CG  HIS    93       9.545  24.294 152.134  1.00 32.27           C  
ATOM    654  ND1 HIS    93       9.280  25.639 152.016  1.00 30.35           N  
ATOM    655  CD2 HIS    93      10.892  24.171 152.097  1.00 24.41           C  
ATOM    656  CE1 HIS    93      10.418  26.300 151.907  1.00 27.66           C  
ATOM    657  NE2 HIS    93      11.411  25.432 151.952  1.00 27.44           N  
ATOM    658  N   GLN    94       7.085  20.385 151.569  1.00 36.34           N  
ATOM    659  CA  GLN    94       6.070  19.368 151.863  1.00 36.30           C  
ATOM    660  C   GLN    94       6.777  18.026 152.075  1.00 37.32           C  
ATOM    661  O   GLN    94       6.414  17.252 152.974  1.00 36.92           O  
ATOM    662  CB  GLN    94       5.061  19.248 150.715  1.00 36.05           C  
ATOM    663  CG  GLN    94       4.217  17.979 150.781  1.00 38.03           C  
ATOM    664  CD  GLN    94       2.981  18.054 149.912  1.00 41.92           C  
ATOM    665  OE1 GLN    94       3.067  18.249 148.695  1.00 43.15           O  
ATOM    666  NE2 GLN    94       1.815  17.904 150.534  1.00 42.69           N  
ATOM    667  N   ARG    95       7.783  17.749 151.242  1.00 37.73           N  
ATOM    668  CA  ARG    95       8.554  16.513 151.365  1.00 38.04           C  
ATOM    669  C   ARG    95       9.350  16.566 152.664  1.00 36.71           C  
ATOM    670  O   ARG    95       9.433  15.578 153.389  1.00 37.54           O  
ATOM    671  CB  ARG    95       9.522  16.343 150.190  1.00 37.76           C  
ATOM    672  CG  ARG    95       8.981  15.501 149.051  1.00 41.07           C  
ATOM    673  CD  ARG    95      10.112  14.864 148.251  1.00 41.47           C  
ATOM    674  NE  ARG    95      10.210  13.421 148.471  1.00 44.73           N  
ATOM    675  CZ  ARG    95      11.303  12.697 148.238  1.00 48.22           C  
ATOM    676  NH1 ARG    95      12.405  13.277 147.777  1.00 43.75           N  
ATOM    677  NH2 ARG    95      11.300  11.388 148.466  1.00 50.29           N  
ATOM    678  N   GLN    96       9.929  17.729 152.950  1.00 36.06           N  
ATOM    679  CA  GLN    96      10.728  17.925 154.160  1.00 36.78           C  
ATOM    680  C   GLN    96       9.918  17.667 155.432  1.00 37.11           C  
ATOM    681  O   GLN    96      10.404  17.022 156.363  1.00 38.28           O  
ATOM    682  CB  GLN    96      11.321  19.352 154.177  1.00 36.09           C  
ATOM    683  CG  GLN    96      12.559  19.528 153.281  1.00 35.76           C  
ATOM    684  CD  GLN    96      12.876  20.987 152.938  1.00 37.87           C  
ATOM    685  OE1 GLN    96      12.553  21.902 153.695  1.00 37.55           O  
ATOM    686  NE2 GLN    96      13.521  21.202 151.787  1.00 37.71           N  
ATOM    687  N   ALA    97       8.685  18.164 155.459  1.00 36.86           N  
ATOM    688  CA  ALA    97       7.808  18.008 156.618  1.00 38.73           C  
ATOM    689  C   ALA    97       7.274  16.589 156.803  1.00 39.18           C  
ATOM    690  O   ALA    97       7.426  16.003 157.871  1.00 40.70           O  
ATOM    691  CB  ALA    97       6.642  18.998 156.527  1.00 38.41           C  
ATOM    692  N   LYS    98       6.643  16.043 155.767  1.00 41.29           N  
ATOM    693  CA  LYS    98       6.092  14.691 155.829  1.00 42.21           C  
ATOM    694  C   LYS    98       7.160  13.660 156.207  1.00 41.35           C  
ATOM    695  O   LYS    98       6.868  12.667 156.882  1.00 41.72           O  
ATOM    696  CB  LYS    98       5.452  14.320 154.489  1.00 42.60           C  
ATOM    697  CG  LYS    98       4.132  15.045 154.207  1.00 46.99           C  
ATOM    698  CD  LYS    98       3.701  14.826 152.757  1.00 50.33           C  
ATOM    699  CE  LYS    98       2.273  14.316 152.636  1.00 52.72           C  
ATOM    700  NZ  LYS    98       1.300  15.394 152.311  1.00 55.75           N  
ATOM    701  N   ALA    99       8.395  13.899 155.776  1.00 40.82           N  
ATOM    702  CA  ALA    99       9.501  13.005 156.096  1.00 40.65           C  
ATOM    703  C   ALA    99       9.746  13.051 157.612  1.00 41.49           C  
ATOM    704  O   ALA    99       9.763  12.015 158.279  1.00 42.92           O  
ATOM    705  CB  ALA    99      10.761  13.443 155.353  1.00 39.72           C  
ATOM    706  N   LEU   100       9.944  14.253 158.155  1.00 41.47           N  
ATOM    707  CA  LEU   100      10.195  14.414 159.590  1.00 42.16           C  
ATOM    708  C   LEU   100       9.088  13.802 160.454  1.00 43.10           C  
ATOM    709  O   LEU   100       9.366  13.216 161.504  1.00 44.57           O  
ATOM    710  CB  LEU   100      10.390  15.899 159.931  1.00 40.19           C  
ATOM    711  CG  LEU   100      11.760  16.459 159.539  1.00 40.76           C  
ATOM    712  CD1 LEU   100      11.733  17.979 159.622  1.00 38.21           C  
ATOM    713  CD2 LEU   100      12.845  15.879 160.463  1.00 39.23           C  
ATOM    714  N   PHE   101       7.837  13.937 160.017  1.00 43.20           N  
ATOM    715  CA  PHE   101       6.726  13.365 160.764  1.00 42.25           C  
ATOM    716  C   PHE   101       6.823  11.845 160.643  1.00 44.41           C  
ATOM    717  O   PHE   101       6.658  11.123 161.621  1.00 43.24           O  
ATOM    718  CB  PHE   101       5.385  13.879 160.217  1.00 41.31           C  
ATOM    719  CG  PHE   101       5.197  15.367 160.365  1.00 39.00           C  
ATOM    720  CD1 PHE   101       5.665  16.033 161.502  1.00 34.66           C  
ATOM    721  CD2 PHE   101       4.571  16.105 159.369  1.00 36.49           C  
ATOM    722  CE1 PHE   101       5.495  17.412 161.645  1.00 34.60           C  
ATOM    723  CE2 PHE   101       4.399  17.484 159.500  1.00 34.58           C  
ATOM    724  CZ  PHE   101       4.870  18.142 160.633  1.00 32.21           C  
ATOM    725  N   ARG   102       7.102  11.360 159.435  1.00 46.41           N  
ATOM    726  CA  ARG   102       7.242   9.923 159.196  1.00 48.11           C  
ATOM    727  C   ARG   102       8.348   9.354 160.107  1.00 48.36           C  
ATOM    728  O   ARG   102       8.139   8.336 160.770  1.00 48.43           O  
ATOM    729  CB  ARG   102       7.627   9.660 157.741  1.00 49.29           C  
ATOM    730  CG  ARG   102       7.634   8.184 157.333  1.00 51.02           C  
ATOM    731  CD  ARG   102       8.792   7.853 156.388  1.00 53.05           C  
ATOM    732  NE  ARG   102       9.139   8.969 155.508  1.00 52.14           N  
ATOM    733  CZ  ARG   102       8.311   9.516 154.622  1.00 55.54           C  
ATOM    734  NH1 ARG   102       7.078   9.047 154.486  1.00 53.38           N  
ATOM    735  NH2 ARG   102       8.711  10.542 153.882  1.00 51.50           N  
ATOM    736  N   GLU   103       9.516  10.005 160.131  1.00 48.96           N  
ATOM    737  CA  GLU   103      10.645   9.551 160.943  1.00 49.81           C  
ATOM    738  C   GLU   103      10.291   9.567 162.426  1.00 50.89           C  
ATOM    739  O   GLU   103      10.596   8.606 163.141  1.00 50.34           O  
ATOM    740  CB  GLU   103      11.893  10.388 160.616  1.00 50.09           C  
ATOM    741  CG  GLU   103      12.643   9.818 159.415  1.00 51.67           C  
ATOM    742  CD  GLU   103      13.347  10.890 158.626  1.00 51.76           C  
ATOM    743  OE1 GLU   103      13.899  11.825 159.251  1.00 48.29           O  
ATOM    744  OE2 GLU   103      13.354  10.796 157.383  1.00 55.16           O  
ATOM    745  N   ALA   104       9.667  10.652 162.892  1.00 51.35           N  
ATOM    746  CA  ALA   104       9.177  10.675 164.265  1.00 52.00           C  
ATOM    747  C   ALA   104       8.091   9.565 164.126  1.00 52.43           C  
ATOM    748  O   ALA   104       7.679   9.211 163.007  1.00 53.80           O  
ATOM    749  CB  ALA   104       8.528  12.007 164.577  1.00 52.52           C  
ATOM    750  N   GLY   105       7.572   9.038 165.222  1.00 51.99           N  
ATOM    751  CA  GLY   105       6.611   7.951 165.088  1.00 52.42           C  
ATOM    752  C   GLY   105       5.192   8.281 164.726  1.00 51.41           C  
ATOM    753  O   GLY   105       4.281   7.504 165.013  1.00 52.46           O  
ATOM    754  N   TYR   106       5.022   9.381 164.007  1.00 49.01           N  
ATOM    755  CA  TYR   106       3.692   9.848 163.660  1.00 48.06           C  
ATOM    756  C   TYR   106       2.927   9.292 162.481  1.00 48.12           C  
ATOM    757  O   TYR   106       3.453   9.190 161.388  1.00 48.28           O  
ATOM    758  CB  TYR   106       3.704  11.371 163.567  1.00 46.71           C  
ATOM    759  CG  TYR   106       3.873  12.108 164.893  1.00 46.02           C  
ATOM    760  CD1 TYR   106       2.832  12.165 165.824  1.00 45.78           C  
ATOM    761  CD2 TYR   106       5.077  12.743 165.217  1.00 45.53           C  
ATOM    762  CE1 TYR   106       2.987  12.828 167.043  1.00 43.89           C  
ATOM    763  CE2 TYR   106       5.242  13.401 166.435  1.00 45.18           C  
ATOM    764  CZ  TYR   106       4.194  13.441 167.339  1.00 47.22           C  
ATOM    765  OH  TYR   106       4.358  14.096 168.537  1.00 44.15           O  
ATOM    766  N   SER   107       1.663   8.960 162.731  1.00 48.48           N  
ATOM    767  CA  SER   107       0.783   8.435 161.702  1.00 49.27           C  
ATOM    768  C   SER   107       0.425   9.539 160.706  1.00 49.37           C  
ATOM    769  O   SER   107       0.319  10.710 161.073  1.00 49.53           O  
ATOM    770  CB  SER   107      -0.491   7.870 162.342  1.00 49.50           C  
ATOM    771  OG  SER   107      -1.474   7.588 161.364  1.00 52.70           O  
ATOM    772  N   PRO   108       0.235   9.176 159.429  1.00 49.21           N  
ATOM    773  CA  PRO   108      -0.110  10.142 158.376  1.00 48.45           C  
ATOM    774  C   PRO   108      -1.477  10.785 158.603  1.00 47.09           C  
ATOM    775  O   PRO   108      -1.770  11.856 158.079  1.00 46.18           O  
ATOM    776  CB  PRO   108      -0.096   9.296 157.096  1.00 49.07           C  
ATOM    777  CG  PRO   108       0.786   8.137 157.438  1.00 48.53           C  
ATOM    778  CD  PRO   108       0.450   7.831 158.867  1.00 48.40           C  
ATOM    779  N   SER   109      -2.314  10.103 159.375  1.00 45.54           N  
ATOM    780  CA  SER   109      -3.663  10.569 159.685  1.00 44.50           C  
ATOM    781  C   SER   109      -3.706  11.769 160.631  1.00 43.25           C  
ATOM    782  O   SER   109      -4.730  12.445 160.743  1.00 42.75           O  
ATOM    783  CB  SER   109      -4.464   9.421 160.291  1.00 44.79           C  
ATOM    784  OG  SER   109      -3.645   8.662 161.166  1.00 45.92           O  
ATOM    785  N   ARG   110      -2.588  12.025 161.304  1.00 42.31           N  
ATOM    786  CA  ARG   110      -2.488  13.132 162.250  1.00 41.07           C  
ATOM    787  C   ARG   110      -2.082  14.447 161.587  1.00 40.37           C  
ATOM    788  O   ARG   110      -2.299  15.523 162.138  1.00 38.73           O  
ATOM    789  CB  ARG   110      -1.468  12.805 163.339  1.00 41.93           C  
ATOM    790  CG  ARG   110      -1.842  11.684 164.295  1.00 39.91           C  
ATOM    791  CD  ARG   110      -3.104  12.011 165.079  1.00 39.10           C  
ATOM    792  NE  ARG   110      -3.127  13.356 165.664  1.00 35.37           N  
ATOM    793  CZ  ARG   110      -2.421  13.741 166.723  1.00 36.20           C  
ATOM    794  NH1 ARG   110      -1.620  12.889 167.337  1.00 32.35           N  
ATOM    795  NH2 ARG   110      -2.556  14.974 167.196  1.00 34.00           N  
ATOM    796  N   VAL   111      -1.499  14.351 160.399  1.00 39.59           N  
ATOM    797  CA  VAL   111      -1.040  15.528 159.674  1.00 38.83           C  
ATOM    798  C   VAL   111      -1.701  15.708 158.309  1.00 38.15           C  
ATOM    799  O   VAL   111      -2.128  14.745 157.676  1.00 37.24           O  
ATOM    800  CB  VAL   111       0.491  15.488 159.473  1.00 38.00           C  
ATOM    801  CG1 VAL   111       0.929  16.615 158.551  1.00 42.01           C  
ATOM    802  CG2 VAL   111       1.206  15.614 160.820  1.00 38.16           C  
ATOM    803  N   ARG   112      -1.765  16.957 157.867  1.00 36.98           N  
ATOM    804  CA  ARG   112      -2.351  17.300 156.590  1.00 36.33           C  
ATOM    805  C   ARG   112      -1.513  18.435 156.001  1.00 35.66           C  
ATOM    806  O   ARG   112      -1.324  19.472 156.648  1.00 36.99           O  
ATOM    807  CB  ARG   112      -3.798  17.750 156.830  1.00 36.34           C  
ATOM    808  CG  ARG   112      -4.485  18.397 155.660  1.00 37.42           C  
ATOM    809  CD  ARG   112      -5.397  19.503 156.170  1.00 40.20           C  
ATOM    810  NE  ARG   112      -6.749  19.400 155.634  1.00 45.44           N  
ATOM    811  CZ  ARG   112      -7.756  20.191 155.991  1.00 48.74           C  
ATOM    812  NH1 ARG   112      -7.573  21.156 156.889  1.00 49.80           N  
ATOM    813  NH2 ARG   112      -8.947  20.016 155.443  1.00 49.68           N  
ATOM    814  N   PHE   113      -1.009  18.253 154.784  1.00 34.58           N  
ATOM    815  CA  PHE   113      -0.209  19.303 154.170  1.00 35.15           C  
ATOM    816  C   PHE   113      -0.932  19.949 152.991  1.00 35.07           C  
ATOM    817  O   PHE   113      -1.384  19.270 152.067  1.00 37.67           O  
ATOM    818  CB  PHE   113       1.151  18.766 153.708  1.00 34.40           C  
ATOM    819  CG  PHE   113       2.229  19.827 153.643  1.00 36.00           C  
ATOM    820  CD1 PHE   113       3.235  19.879 154.609  1.00 36.27           C  
ATOM    821  CD2 PHE   113       2.207  20.800 152.650  1.00 32.65           C  
ATOM    822  CE1 PHE   113       4.199  20.895 154.590  1.00 33.82           C  
ATOM    823  CE2 PHE   113       3.163  21.815 152.616  1.00 34.72           C  
ATOM    824  CZ  PHE   113       4.163  21.865 153.589  1.00 33.01           C  
ATOM    825  N   LEU   114      -1.054  21.268 153.029  1.00 35.24           N  
ATOM    826  CA  LEU   114      -1.704  21.989 151.942  1.00 35.75           C  
ATOM    827  C   LEU   114      -0.634  22.776 151.168  1.00 36.12           C  
ATOM    828  O   LEU   114      -0.129  23.802 151.642  1.00 33.29           O  
ATOM    829  CB  LEU   114      -2.781  22.950 152.484  1.00 35.98           C  
ATOM    830  CG  LEU   114      -3.800  22.374 153.479  1.00 35.98           C  
ATOM    831  CD1 LEU   114      -4.787  23.453 153.902  1.00 30.83           C  
ATOM    832  CD2 LEU   114      -4.537  21.206 152.840  1.00 37.70           C  
ATOM    833  N   LEU   115      -0.291  22.272 149.982  1.00 36.66           N  
ATOM    834  CA  LEU   115       0.698  22.896 149.101  1.00 36.42           C  
ATOM    835  C   LEU   115       0.067  24.159 148.511  1.00 37.94           C  
ATOM    836  O   LEU   115      -0.413  24.156 147.371  1.00 37.92           O  
ATOM    837  CB  LEU   115       1.058  21.957 147.946  1.00 36.58           C  
ATOM    838  CG  LEU   115       2.472  21.414 147.736  1.00 37.22           C  
ATOM    839  CD1 LEU   115       2.652  21.168 146.230  1.00 32.33           C  
ATOM    840  CD2 LEU   115       3.537  22.398 148.235  1.00 31.00           C  
ATOM    841  N   SER   116       0.089  25.248 149.270  1.00 38.17           N  
ATOM    842  CA  SER   116      -0.526  26.495 148.825  1.00 39.28           C  
ATOM    843  C   SER   116       0.103  27.704 149.496  1.00 41.12           C  
ATOM    844  O   SER   116       0.891  27.567 150.442  1.00 40.46           O  
ATOM    845  CB  SER   116      -2.007  26.513 149.183  1.00 40.19           C  
ATOM    846  OG  SER   116      -2.470  25.254 149.656  1.00 42.22           O  
ATOM    847  N   ARG   117      -0.255  28.884 149.007  1.00 41.80           N  
ATOM    848  CA  ARG   117       0.210  30.105 149.614  1.00 42.60           C  
ATOM    849  C   ARG   117      -0.825  30.243 150.739  1.00 40.98           C  
ATOM    850  O   ARG   117      -2.039  30.078 150.529  1.00 41.28           O  
ATOM    851  CB  ARG   117       0.122  31.272 148.622  1.00 43.51           C  
ATOM    852  CG  ARG   117       0.859  30.961 147.339  1.00 49.76           C  
ATOM    853  CD  ARG   117       0.563  31.978 146.265  1.00 60.03           C  
ATOM    854  NE  ARG   117       0.982  33.320 146.662  1.00 67.32           N  
ATOM    855  CZ  ARG   117       1.017  34.367 145.842  1.00 67.66           C  
ATOM    856  NH1 ARG   117       0.659  34.231 144.571  1.00 67.92           N  
ATOM    857  NH2 ARG   117       1.413  35.550 146.293  1.00 68.00           N  
ATOM    858  N   PRO   118      -0.364  30.529 151.957  1.00 41.33           N  
ATOM    859  CA  PRO   118      -1.223  30.686 153.140  1.00 40.61           C  
ATOM    860  C   PRO   118      -2.504  31.479 152.927  1.00 39.64           C  
ATOM    861  O   PRO   118      -3.607  30.990 153.181  1.00 39.78           O  
ATOM    862  CB  PRO   118      -0.316  31.394 154.142  1.00 40.65           C  
ATOM    863  CG  PRO   118       1.041  30.954 153.775  1.00 41.68           C  
ATOM    864  CD  PRO   118       1.033  30.880 152.272  1.00 40.50           C  
ATOM    865  N   LEU   119      -2.343  32.715 152.460  1.00 41.33           N  
ATOM    866  CA  LEU   119      -3.471  33.595 152.279  1.00 43.36           C  
ATOM    867  C   LEU   119      -4.460  33.221 151.192  1.00 43.28           C  
ATOM    868  O   LEU   119      -5.565  33.763 151.135  1.00 43.18           O  
ATOM    869  CB  LEU   119      -2.962  35.032 152.110  1.00 44.68           C  
ATOM    870  CG  LEU   119      -2.149  35.568 153.306  1.00 47.79           C  
ATOM    871  CD1 LEU   119      -1.613  36.954 152.971  1.00 48.36           C  
ATOM    872  CD2 LEU   119      -3.017  35.620 154.562  1.00 48.43           C  
ATOM    873  N   ASP   120      -4.069  32.285 150.344  1.00 42.99           N  
ATOM    874  CA  ASP   120      -4.950  31.832 149.284  1.00 43.56           C  
ATOM    875  C   ASP   120      -5.859  30.709 149.778  1.00 42.46           C  
ATOM    876  O   ASP   120      -7.049  30.704 149.496  1.00 42.73           O  
ATOM    877  CB  ASP   120      -4.136  31.320 148.091  1.00 45.08           C  
ATOM    878  CG  ASP   120      -3.630  32.435 147.194  1.00 47.02           C  
ATOM    879  OD1 ASP   120      -2.502  32.322 146.665  1.00 52.57           O  
ATOM    880  OD2 ASP   120      -4.368  33.418 147.002  1.00 54.08           O  
ATOM    881  N   VAL   121      -5.295  29.775 150.541  1.00 41.31           N  
ATOM    882  CA  VAL   121      -6.037  28.611 151.013  1.00 39.94           C  
ATOM    883  C   VAL   121      -6.808  28.725 152.327  1.00 40.84           C  
ATOM    884  O   VAL   121      -7.690  27.907 152.604  1.00 38.80           O  
ATOM    885  CB  VAL   121      -5.094  27.400 151.086  1.00 39.13           C  
ATOM    886  CG1 VAL   121      -4.188  27.521 152.303  1.00 37.68           C  
ATOM    887  CG2 VAL   121      -5.882  26.106 151.110  1.00 37.94           C  
ATOM    888  N   MET   122      -6.475  29.722 153.134  1.00 42.29           N  
ATOM    889  CA  MET   122      -7.166  29.906 154.395  1.00 43.80           C  
ATOM    890  C   MET   122      -8.616  30.270 154.106  1.00 44.00           C  
ATOM    891  O   MET   122      -9.498  30.116 154.952  1.00 42.06           O  
ATOM    892  CB  MET   122      -6.466  30.986 155.225  1.00 44.01           C  
ATOM    893  CG  MET   122      -5.380  30.396 156.117  1.00 49.56           C  
ATOM    894  SD  MET   122      -4.119  31.725 156.693  1.00 61.27          SE  
ATOM    895  CE  MET   122      -2.501  30.840 156.177  1.00 61.36           C  
ATOM    896  N   SER   123      -8.852  30.740 152.885  1.00 45.14           N  
ATOM    897  CA  SER   123     -10.192  31.101 152.429  1.00 44.45           C  
ATOM    898  C   SER   123     -11.012  29.812 152.270  1.00 42.51           C  
ATOM    899  O   SER   123     -12.239  29.841 152.214  1.00 42.47           O  
ATOM    900  CB  SER   123     -10.104  31.792 151.072  1.00 44.03           C  
ATOM    901  OG  SER   123     -11.332  32.400 150.721  1.00 50.55           O  
ATOM    902  N   ARG   124     -10.320  28.682 152.204  1.00 39.98           N  
ATOM    903  CA  ARG   124     -10.938  27.375 151.993  1.00 39.77           C  
ATOM    904  C   ARG   124     -11.079  26.481 153.218  1.00 39.26           C  
ATOM    905  O   ARG   124     -11.430  25.302 153.091  1.00 38.53           O  
ATOM    906  CB  ARG   124     -10.144  26.624 150.927  1.00 39.41           C  
ATOM    907  CG  ARG   124     -10.516  26.921 149.478  1.00 39.67           C  
ATOM    908  CD  ARG   124     -10.214  28.346 149.054  1.00 34.87           C  
ATOM    909  NE  ARG   124     -10.183  28.446 147.599  1.00 37.32           N  
ATOM    910  CZ  ARG   124     -10.506  29.535 146.908  1.00 38.08           C  
ATOM    911  NH1 ARG   124     -10.895  30.633 147.538  1.00 40.47           N  
ATOM    912  NH2 ARG   124     -10.456  29.519 145.584  1.00 35.95           N  
ATOM    913  N   LEU   125     -10.807  27.038 154.392  1.00 38.20           N  
ATOM    914  CA  LEU   125     -10.896  26.266 155.616  1.00 37.17           C  
ATOM    915  C   LEU   125     -12.133  26.675 156.405  1.00 35.40           C  
ATOM    916  O   LEU   125     -12.668  27.759 156.217  1.00 35.38           O  
ATOM    917  CB  LEU   125      -9.612  26.457 156.446  1.00 36.51           C  
ATOM    918  CG  LEU   125      -8.289  26.098 155.744  1.00 34.19           C  
ATOM    919  CD1 LEU   125      -7.122  26.588 156.596  1.00 35.46           C  
ATOM    920  CD2 LEU   125      -8.189  24.592 155.505  1.00 33.35           C  
ATOM    921  N   ALA   126     -12.583  25.798 157.291  1.00 36.45           N  
ATOM    922  CA  ALA   126     -13.782  26.061 158.076  1.00 37.46           C  
ATOM    923  C   ALA   126     -13.588  27.043 159.223  1.00 37.94           C  
ATOM    924  O   ALA   126     -12.660  26.912 160.014  1.00 36.91           O  
ATOM    925  CB  ALA   126     -14.351  24.735 158.604  1.00 38.14           C  
ATOM    926  N   ASN   127     -14.479  28.026 159.299  1.00 37.51           N  
ATOM    927  CA  ASN   127     -14.436  29.028 160.357  1.00 39.25           C  
ATOM    928  C   ASN   127     -14.698  28.410 161.736  1.00 38.25           C  
ATOM    929  O   ASN   127     -15.415  27.410 161.853  1.00 37.89           O  
ATOM    930  CB  ASN   127     -15.499  30.104 160.130  1.00 38.20           C  
ATOM    931  CG  ASN   127     -15.109  31.115 159.077  1.00 45.54           C  
ATOM    932  OD1 ASN   127     -13.925  31.365 158.846  1.00 47.80           O  
ATOM    933  ND2 ASN   127     -16.114  31.728 158.440  1.00 50.71           N  
ATOM    934  N   ASP   128     -14.100  28.996 162.773  1.00 39.07           N  
ATOM    935  CA  ASP   128     -14.333  28.545 164.147  1.00 39.00           C  
ATOM    936  C   ASP   128     -14.037  27.068 164.369  1.00 37.42           C  
ATOM    937  O   ASP   128     -14.761  26.386 165.099  1.00 36.97           O  
ATOM    938  CB  ASP   128     -15.802  28.840 164.494  1.00 40.06           C  
ATOM    939  CG  ASP   128     -16.097  28.760 165.988  1.00 42.55           C  
ATOM    940  OD1 ASP   128     -15.284  29.278 166.781  1.00 42.74           O  
ATOM    941  OD2 ASP   128     -17.152  28.195 166.370  1.00 38.11           O  
ATOM    942  N   SER   129     -12.967  26.573 163.763  1.00 35.37           N  
ATOM    943  CA  SER   129     -12.636  25.160 163.890  1.00 34.54           C  
ATOM    944  C   SER   129     -11.245  24.857 164.426  1.00 31.43           C  
ATOM    945  O   SER   129     -10.918  23.699 164.679  1.00 32.63           O  
ATOM    946  CB  SER   129     -12.782  24.477 162.536  1.00 35.03           C  
ATOM    947  OG  SER   129     -14.099  24.034 162.294  1.00 37.23           O  
ATOM    948  N   TYR   130     -10.431  25.884 164.620  1.00 29.68           N  
ATOM    949  CA  TYR   130      -9.071  25.668 165.066  1.00 28.67           C  
ATOM    950  C   TYR   130      -8.751  26.269 166.423  1.00 28.72           C  
ATOM    951  O   TYR   130      -9.163  27.382 166.738  1.00 29.68           O  
ATOM    952  CB  TYR   130      -8.121  26.196 163.986  1.00 28.26           C  
ATOM    953  CG  TYR   130      -8.274  25.464 162.664  1.00 29.26           C  
ATOM    954  CD1 TYR   130      -7.600  24.263 162.430  1.00 29.35           C  
ATOM    955  CD2 TYR   130      -9.172  25.915 161.692  1.00 28.46           C  
ATOM    956  CE1 TYR   130      -7.803  23.531 161.259  1.00 26.56           C  
ATOM    957  CE2 TYR   130      -9.386  25.194 160.518  1.00 29.12           C  
ATOM    958  CZ  TYR   130      -8.700  23.994 160.313  1.00 29.08           C  
ATOM    959  OH  TYR   130      -8.905  23.276 159.154  1.00 27.26           O  
ATOM    960  N   GLN   131      -7.995  25.514 167.214  1.00 28.03           N  
ATOM    961  CA  GLN   131      -7.601  25.922 168.557  1.00 27.77           C  
ATOM    962  C   GLN   131      -6.230  26.599 168.607  1.00 27.85           C  
ATOM    963  O   GLN   131      -5.884  27.249 169.598  1.00 29.71           O  
ATOM    964  CB  GLN   131      -7.569  24.700 169.472  1.00 26.77           C  
ATOM    965  CG  GLN   131      -6.362  23.790 169.188  1.00 26.44           C  
ATOM    966  CD  GLN   131      -6.491  22.396 169.781  1.00 24.98           C  
ATOM    967  OE1 GLN   131      -5.943  22.106 170.843  1.00 24.78           O  
ATOM    968  NE2 GLN   131      -7.231  21.533 169.101  1.00 20.94           N  
ATOM    969  N   LEU   132      -5.446  26.448 167.546  1.00 27.47           N  
ATOM    970  CA  LEU   132      -4.105  27.023 167.532  1.00 26.57           C  
ATOM    971  C   LEU   132      -3.590  27.236 166.115  1.00 27.51           C  
ATOM    972  O   LEU   132      -3.679  26.349 165.264  1.00 29.60           O  
ATOM    973  CB  LEU   132      -3.137  26.104 168.301  1.00 25.75           C  
ATOM    974  CG  LEU   132      -1.629  26.415 168.296  1.00 29.37           C  
ATOM    975  CD1 LEU   132      -1.363  27.685 169.099  1.00 27.98           C  
ATOM    976  CD2 LEU   132      -0.842  25.243 168.885  1.00 27.03           C  
ATOM    977  N   VAL   133      -3.055  28.424 165.864  1.00 26.58           N  
ATOM    978  CA  VAL   133      -2.498  28.739 164.566  1.00 25.15           C  
ATOM    979  C   VAL   133      -1.139  29.410 164.763  1.00 26.35           C  
ATOM    980  O   VAL   133      -1.017  30.422 165.456  1.00 26.47           O  
ATOM    981  CB  VAL   133      -3.439  29.670 163.752  1.00 25.87           C  
ATOM    982  CG1 VAL   133      -2.807  30.010 162.398  1.00 25.01           C  
ATOM    983  CG2 VAL   133      -4.791  28.987 163.550  1.00 20.36           C  
ATOM    984  N   PHE   134      -0.113  28.818 164.169  1.00 25.32           N  
ATOM    985  CA  PHE   134       1.234  29.356 164.232  1.00 26.86           C  
ATOM    986  C   PHE   134       1.555  29.901 162.847  1.00 27.34           C  
ATOM    987  O   PHE   134       1.374  29.218 161.827  1.00 28.20           O  
ATOM    988  CB  PHE   134       2.266  28.275 164.582  1.00 26.10           C  
ATOM    989  CG  PHE   134       3.687  28.747 164.450  1.00 25.49           C  
ATOM    990  CD1 PHE   134       4.311  29.429 165.490  1.00 24.26           C  
ATOM    991  CD2 PHE   134       4.389  28.539 163.263  1.00 29.08           C  
ATOM    992  CE1 PHE   134       5.619  29.914 165.342  1.00 28.36           C  
ATOM    993  CE2 PHE   134       5.692  29.020 163.101  1.00 32.22           C  
ATOM    994  CZ  PHE   134       6.312  29.704 164.146  1.00 32.15           C  
ATOM    995  N   GLY   135       2.023  31.142 162.815  1.00 28.79           N  
ATOM    996  CA  GLY   135       2.375  31.753 161.551  1.00 28.63           C  
ATOM    997  C   GLY   135       3.800  32.285 161.495  1.00 29.23           C  
ATOM    998  O   GLY   135       4.256  32.988 162.400  1.00 26.26           O  
ATOM    999  N   GLN   136       4.525  31.894 160.454  1.00 30.13           N  
ATOM   1000  CA  GLN   136       5.876  32.386 160.239  1.00 33.40           C  
ATOM   1001  C   GLN   136       5.803  33.029 158.850  1.00 35.44           C  
ATOM   1002  O   GLN   136       5.966  32.367 157.820  1.00 36.80           O  
ATOM   1003  CB  GLN   136       6.918  31.255 160.234  1.00 32.41           C  
ATOM   1004  CG  GLN   136       8.323  31.769 159.955  1.00 33.06           C  
ATOM   1005  CD  GLN   136       9.078  32.162 161.210  1.00 33.64           C  
ATOM   1006  OE1 GLN   136       9.444  33.324 161.394  1.00 35.68           O  
ATOM   1007  NE2 GLN   136       9.320  31.192 162.080  1.00 29.90           N  
ATOM   1008  N   VAL   137       5.562  34.331 158.825  1.00 36.19           N  
ATOM   1009  CA  VAL   137       5.419  35.064 157.572  1.00 38.42           C  
ATOM   1010  C   VAL   137       6.248  36.342 157.564  1.00 41.25           C  
ATOM   1011  O   VAL   137       6.896  36.680 158.560  1.00 41.64           O  
ATOM   1012  CB  VAL   137       3.930  35.432 157.329  1.00 36.88           C  
ATOM   1013  CG1 VAL   137       3.080  34.166 157.285  1.00 34.48           C  
ATOM   1014  CG2 VAL   137       3.421  36.348 158.450  1.00 35.11           C  
ATOM   1015  N   SER   138       6.228  37.044 156.433  1.00 41.77           N  
ATOM   1016  CA  SER   138       6.941  38.307 156.320  1.00 41.93           C  
ATOM   1017  C   SER   138       6.078  39.351 157.022  1.00 41.25           C  
ATOM   1018  O   SER   138       4.846  39.232 157.063  1.00 40.59           O  
ATOM   1019  CB  SER   138       7.123  38.712 154.859  1.00 42.90           C  
ATOM   1020  OG  SER   138       8.000  37.823 154.205  1.00 48.55           O  
ATOM   1021  N   PRO   139       6.712  40.382 157.589  1.00 42.32           N  
ATOM   1022  CA  PRO   139       6.007  41.457 158.292  1.00 43.29           C  
ATOM   1023  C   PRO   139       4.924  42.111 157.442  1.00 45.67           C  
ATOM   1024  O   PRO   139       3.968  42.681 157.974  1.00 46.01           O  
ATOM   1025  CB  PRO   139       7.131  42.436 158.684  1.00 43.98           C  
ATOM   1026  CG  PRO   139       8.358  41.958 157.932  1.00 42.13           C  
ATOM   1027  CD  PRO   139       8.170  40.487 157.766  1.00 41.37           C  
ATOM   1028  N   MET   140       5.071  42.035 156.123  1.00 47.45           N  
ATOM   1029  CA  MET   140       4.076  42.638 155.239  1.00 49.28           C  
ATOM   1030  C   MET   140       2.823  41.772 155.122  1.00 47.01           C  
ATOM   1031  O   MET   140       1.779  42.231 154.660  1.00 47.15           O  
ATOM   1032  CB  MET   140       4.690  42.930 153.855  1.00 51.82           C  
ATOM   1033  CG  MET   140       5.654  44.141 153.862  1.00 59.82           C  
ATOM   1034  SD  MET   140       5.021  45.728 152.904  1.00 78.54          SE  
ATOM   1035  CE  MET   140       3.104  45.465 153.043  1.00 71.46           C  
ATOM   1036  N   ASP   141       2.921  40.519 155.556  1.00 44.94           N  
ATOM   1037  CA  ASP   141       1.783  39.606 155.512  1.00 41.78           C  
ATOM   1038  C   ASP   141       1.064  39.456 156.859  1.00 40.48           C  
ATOM   1039  O   ASP   141      -0.003  38.844 156.926  1.00 39.11           O  
ATOM   1040  CB  ASP   141       2.233  38.221 155.051  1.00 42.04           C  
ATOM   1041  CG  ASP   141       2.523  38.160 153.568  1.00 43.17           C  
ATOM   1042  OD1 ASP   141       1.754  38.773 152.809  1.00 41.63           O  
ATOM   1043  OD2 ASP   141       3.497  37.487 153.159  1.00 43.95           O  
ATOM   1044  N   LEU   142       1.630  40.029 157.922  1.00 40.15           N  
ATOM   1045  CA  LEU   142       1.058  39.873 159.259  1.00 39.48           C  
ATOM   1046  C   LEU   142      -0.394  40.231 159.457  1.00 39.93           C  
ATOM   1047  O   LEU   142      -1.167  39.431 159.997  1.00 40.66           O  
ATOM   1048  CB  LEU   142       1.924  40.590 160.300  1.00 38.67           C  
ATOM   1049  CG  LEU   142       3.300  39.975 160.600  1.00 38.68           C  
ATOM   1050  CD1 LEU   142       4.112  40.933 161.458  1.00 42.38           C  
ATOM   1051  CD2 LEU   142       3.129  38.637 161.311  1.00 38.58           C  
ATOM   1052  N   LYS   143      -0.757  41.420 159.004  1.00 38.96           N  
ATOM   1053  CA  LYS   143      -2.117  41.903 159.110  1.00 39.51           C  
ATOM   1054  C   LYS   143      -3.068  40.971 158.364  1.00 39.15           C  
ATOM   1055  O   LYS   143      -4.116  40.575 158.884  1.00 40.10           O  
ATOM   1056  CB  LYS   143      -2.215  43.303 158.502  1.00 40.31           C  
ATOM   1057  CG  LYS   143      -3.030  44.294 159.323  1.00 43.90           C  
ATOM   1058  CD  LYS   143      -4.008  45.096 158.470  1.00 49.29           C  
ATOM   1059  CE  LYS   143      -5.421  44.522 158.568  1.00 53.76           C  
ATOM   1060  NZ  LYS   143      -6.429  45.319 157.813  1.00 56.00           N  
ATOM   1061  N   ALA   144      -2.700  40.623 157.138  1.00 39.14           N  
ATOM   1062  CA  ALA   144      -3.530  39.752 156.316  1.00 38.68           C  
ATOM   1063  C   ALA   144      -3.670  38.382 156.968  1.00 38.00           C  
ATOM   1064  O   ALA   144      -4.731  37.759 156.900  1.00 38.66           O  
ATOM   1065  CB  ALA   144      -2.929  39.621 154.911  1.00 37.15           C  
ATOM   1066  N   LEU   145      -2.602  37.918 157.611  1.00 37.83           N  
ATOM   1067  CA  LEU   145      -2.646  36.621 158.263  1.00 37.23           C  
ATOM   1068  C   LEU   145      -3.621  36.667 159.451  1.00 37.14           C  
ATOM   1069  O   LEU   145      -4.358  35.707 159.691  1.00 36.62           O  
ATOM   1070  CB  LEU   145      -1.235  36.188 158.718  1.00 36.77           C  
ATOM   1071  CG  LEU   145      -1.168  34.756 159.271  1.00 39.44           C  
ATOM   1072  CD1 LEU   145      -1.620  33.766 158.186  1.00 37.20           C  
ATOM   1073  CD2 LEU   145       0.252  34.435 159.742  1.00 35.79           C  
ATOM   1074  N   VAL   146      -3.629  37.782 160.184  1.00 37.71           N  
ATOM   1075  CA  VAL   146      -4.521  37.956 161.337  1.00 37.17           C  
ATOM   1076  C   VAL   146      -5.980  37.944 160.885  1.00 38.38           C  
ATOM   1077  O   VAL   146      -6.835  37.306 161.498  1.00 37.63           O  
ATOM   1078  CB  VAL   146      -4.253  39.297 162.050  1.00 36.80           C  
ATOM   1079  CG1 VAL   146      -5.205  39.467 163.214  1.00 35.48           C  
ATOM   1080  CG2 VAL   146      -2.811  39.358 162.525  1.00 37.51           C  
ATOM   1081  N   ASP   147      -6.256  38.672 159.807  1.00 39.95           N  
ATOM   1082  CA  ASP   147      -7.606  38.754 159.260  1.00 38.92           C  
ATOM   1083  C   ASP   147      -8.037  37.403 158.725  1.00 38.35           C  
ATOM   1084  O   ASP   147      -9.206  37.036 158.812  1.00 42.00           O  
ATOM   1085  CB  ASP   147      -7.668  39.792 158.136  1.00 40.05           C  
ATOM   1086  CG  ASP   147      -7.366  41.190 158.624  1.00 41.34           C  
ATOM   1087  OD1 ASP   147      -7.807  41.532 159.743  1.00 43.67           O  
ATOM   1088  OD2 ASP   147      -6.697  41.948 157.892  1.00 43.65           O  
ATOM   1089  N   ALA   148      -7.085  36.658 158.171  1.00 36.95           N  
ATOM   1090  CA  ALA   148      -7.374  35.335 157.625  1.00 34.18           C  
ATOM   1091  C   ALA   148      -7.538  34.295 158.726  1.00 34.08           C  
ATOM   1092  O   ALA   148      -8.441  33.463 158.683  1.00 31.80           O  
ATOM   1093  CB  ALA   148      -6.259  34.907 156.667  1.00 33.64           C  
ATOM   1094  N   ALA   149      -6.658  34.343 159.716  1.00 33.69           N  
ATOM   1095  CA  ALA   149      -6.696  33.377 160.798  1.00 33.43           C  
ATOM   1096  C   ALA   149      -7.799  33.579 161.834  1.00 33.55           C  
ATOM   1097  O   ALA   149      -8.396  32.609 162.312  1.00 34.44           O  
ATOM   1098  CB  ALA   149      -5.327  33.330 161.489  1.00 34.63           C  
ATOM   1099  N   TRP   150      -8.088  34.830 162.172  1.00 35.02           N  
ATOM   1100  CA  TRP   150      -9.084  35.104 163.208  1.00 35.52           C  
ATOM   1101  C   TRP   150     -10.392  34.341 163.089  1.00 36.07           C  
ATOM   1102  O   TRP   150     -10.829  33.698 164.051  1.00 36.77           O  
ATOM   1103  CB  TRP   150      -9.368  36.609 163.312  1.00 36.87           C  
ATOM   1104  CG  TRP   150      -9.881  37.006 164.678  1.00 39.34           C  
ATOM   1105  CD1 TRP   150     -11.103  37.530 164.976  1.00 38.91           C  
ATOM   1106  CD2 TRP   150      -9.185  36.875 165.928  1.00 38.85           C  
ATOM   1107  NE1 TRP   150     -11.213  37.738 166.333  1.00 40.42           N  
ATOM   1108  CE2 TRP   150     -10.049  37.348 166.940  1.00 39.56           C  
ATOM   1109  CE3 TRP   150      -7.910  36.414 166.288  1.00 40.01           C  
ATOM   1110  CZ2 TRP   150      -9.686  37.359 168.296  1.00 38.56           C  
ATOM   1111  CZ3 TRP   150      -7.546  36.428 167.635  1.00 41.47           C  
ATOM   1112  CH2 TRP   150      -8.431  36.904 168.620  1.00 41.64           C  
ATOM   1113  N   PRO   151     -11.030  34.386 161.912  1.00 36.28           N  
ATOM   1114  CA  PRO   151     -12.297  33.668 161.748  1.00 36.18           C  
ATOM   1115  C   PRO   151     -12.183  32.164 161.992  1.00 34.50           C  
ATOM   1116  O   PRO   151     -13.130  31.534 162.451  1.00 34.71           O  
ATOM   1117  CB  PRO   151     -12.690  33.958 160.295  1.00 37.11           C  
ATOM   1118  CG  PRO   151     -11.968  35.221 159.959  1.00 37.77           C  
ATOM   1119  CD  PRO   151     -10.652  35.100 160.679  1.00 35.64           C  
ATOM   1120  N   LEU   152     -11.022  31.593 161.679  1.00 34.79           N  
ATOM   1121  CA  LEU   152     -10.801  30.153 161.836  1.00 35.06           C  
ATOM   1122  C   LEU   152     -10.602  29.733 163.289  1.00 34.90           C  
ATOM   1123  O   LEU   152     -10.874  28.596 163.669  1.00 35.83           O  
ATOM   1124  CB  LEU   152      -9.588  29.721 161.011  1.00 35.31           C  
ATOM   1125  CG  LEU   152      -9.532  30.146 159.535  1.00 32.06           C  
ATOM   1126  CD1 LEU   152      -8.139  29.863 158.949  1.00 28.65           C  
ATOM   1127  CD2 LEU   152     -10.608  29.410 158.747  1.00 30.78           C  
ATOM   1128  N   LEU   153     -10.130  30.668 164.101  1.00 36.20           N  
ATOM   1129  CA  LEU   153      -9.865  30.413 165.514  1.00 35.55           C  
ATOM   1130  C   LEU   153     -11.086  30.273 166.380  1.00 35.15           C  
ATOM   1131  O   LEU   153     -12.043  31.021 166.223  1.00 36.38           O  
ATOM   1132  CB  LEU   153      -9.014  31.525 166.110  1.00 34.73           C  
ATOM   1133  CG  LEU   153      -7.490  31.460 166.042  1.00 35.40           C  
ATOM   1134  CD1 LEU   153      -6.906  32.700 166.722  1.00 37.52           C  
ATOM   1135  CD2 LEU   153      -6.991  30.175 166.744  1.00 23.36           C  
ATOM   1136  N   ARG   154     -11.058  29.310 167.296  1.00 36.30           N  
ATOM   1137  CA  ARG   154     -12.162  29.145 168.232  1.00 36.51           C  
ATOM   1138  C   ARG   154     -11.818  30.000 169.474  1.00 36.76           C  
ATOM   1139  O   ARG   154     -10.651  30.379 169.676  1.00 33.72           O  
ATOM   1140  CB  ARG   154     -12.319  27.674 168.634  1.00 36.75           C  
ATOM   1141  CG  ARG   154     -12.718  26.785 167.478  1.00 37.06           C  
ATOM   1142  CD  ARG   154     -12.577  25.313 167.811  1.00 37.83           C  
ATOM   1143  NE  ARG   154     -13.585  24.850 168.759  1.00 45.05           N  
ATOM   1144  CZ  ARG   154     -14.877  24.707 168.473  1.00 47.28           C  
ATOM   1145  NH1 ARG   154     -15.331  24.991 167.257  1.00 41.82           N  
ATOM   1146  NH2 ARG   154     -15.710  24.265 169.404  1.00 47.48           N  
ATOM   1147  N   ARG   155     -12.823  30.308 170.295  1.00 37.44           N  
ATOM   1148  CA  ARG   155     -12.610  31.086 171.514  1.00 37.17           C  
ATOM   1149  C   ARG   155     -11.747  30.192 172.403  1.00 35.22           C  
ATOM   1150  O   ARG   155     -11.978  28.975 172.493  1.00 36.48           O  
ATOM   1151  CB  ARG   155     -13.961  31.403 172.183  1.00 38.81           C  
ATOM   1152  CG  ARG   155     -14.937  32.087 171.233  1.00 42.34           C  
ATOM   1153  CD  ARG   155     -16.218  32.427 171.953  1.00 47.96           C  
ATOM   1154  NE  ARG   155     -16.064  33.616 172.784  1.00 54.25           N  
ATOM   1155  CZ  ARG   155     -16.418  34.843 172.409  1.00 56.26           C  
ATOM   1156  NH1 ARG   155     -16.953  35.045 171.210  1.00 56.53           N  
ATOM   1157  NH2 ARG   155     -16.230  35.868 173.234  1.00 56.32           N  
ATOM   1158  N   GLY   156     -10.764  30.799 173.062  1.00 32.13           N  
ATOM   1159  CA  GLY   156      -9.822  30.049 173.880  1.00 30.79           C  
ATOM   1160  C   GLY   156      -8.670  29.644 172.940  1.00 29.86           C  
ATOM   1161  O   GLY   156      -7.673  29.034 173.361  1.00 28.96           O  
ATOM   1162  N   GLY   157      -8.795  30.009 171.657  1.00 28.58           N  
ATOM   1163  CA  GLY   157      -7.783  29.685 170.652  1.00 26.53           C  
ATOM   1164  C   GLY   157      -6.719  30.750 170.521  1.00 26.35           C  
ATOM   1165  O   GLY   157      -6.981  31.934 170.724  1.00 26.49           O  
ATOM   1166  N   ALA   158      -5.517  30.330 170.143  1.00 26.28           N  
ATOM   1167  CA  ALA   158      -4.402  31.253 170.021  1.00 26.53           C  
ATOM   1168  C   ALA   158      -3.752  31.338 168.663  1.00 27.37           C  
ATOM   1169  O   ALA   158      -3.498  30.317 168.023  1.00 27.64           O  
ATOM   1170  CB  ALA   158      -3.333  30.924 171.057  1.00 24.38           C  
ATOM   1171  N   LEU   159      -3.468  32.568 168.245  1.00 28.32           N  
ATOM   1172  CA  LEU   159      -2.747  32.823 167.013  1.00 28.11           C  
ATOM   1173  C   LEU   159      -1.342  33.223 167.503  1.00 27.21           C  
ATOM   1174  O   LEU   159      -1.189  34.162 168.296  1.00 26.79           O  
ATOM   1175  CB  LEU   159      -3.371  33.994 166.234  1.00 28.52           C  
ATOM   1176  CG  LEU   159      -2.577  34.518 165.030  1.00 31.81           C  
ATOM   1177  CD1 LEU   159      -2.417  33.424 163.973  1.00 33.87           C  
ATOM   1178  CD2 LEU   159      -3.322  35.715 164.451  1.00 31.17           C  
ATOM   1179  N   VAL   160      -0.322  32.501 167.047  1.00 25.88           N  
ATOM   1180  CA  VAL   160       1.064  32.772 167.428  1.00 24.79           C  
ATOM   1181  C   VAL   160       1.858  33.296 166.232  1.00 27.75           C  
ATOM   1182  O   VAL   160       2.033  32.591 165.232  1.00 26.63           O  
ATOM   1183  CB  VAL   160       1.738  31.501 167.987  1.00 24.17           C  
ATOM   1184  CG1 VAL   160       3.150  31.821 168.438  1.00 23.11           C  
ATOM   1185  CG2 VAL   160       0.923  30.964 169.163  1.00 19.43           C  
ATOM   1186  N   LEU   161       2.338  34.537 166.340  1.00 29.92           N  
ATOM   1187  CA  LEU   161       3.088  35.183 165.258  1.00 31.39           C  
ATOM   1188  C   LEU   161       4.569  35.347 165.580  1.00 33.08           C  
ATOM   1189  O   LEU   161       4.957  36.203 166.376  1.00 32.56           O  
ATOM   1190  CB  LEU   161       2.467  36.550 164.943  1.00 31.04           C  
ATOM   1191  CG  LEU   161       0.954  36.513 164.655  1.00 29.82           C  
ATOM   1192  CD1 LEU   161       0.395  37.937 164.570  1.00 26.88           C  
ATOM   1193  CD2 LEU   161       0.693  35.749 163.363  1.00 26.34           C  
ATOM   1194  N   ALA   162       5.394  34.522 164.946  1.00 33.46           N  
ATOM   1195  CA  ALA   162       6.841  34.557 165.155  1.00 35.04           C  
ATOM   1196  C   ALA   162       7.519  35.821 164.628  1.00 36.17           C  
ATOM   1197  O   ALA   162       7.108  36.373 163.604  1.00 36.48           O  
ATOM   1198  CB  ALA   162       7.484  33.337 164.511  1.00 35.01           C  
ATOM   1199  N   ASP   163       8.559  36.260 165.343  1.00 35.67           N  
ATOM   1200  CA  ASP   163       9.367  37.428 164.980  1.00 35.23           C  
ATOM   1201  C   ASP   163       8.577  38.664 164.556  1.00 34.80           C  
ATOM   1202  O   ASP   163       9.082  39.491 163.803  1.00 37.18           O  
ATOM   1203  CB  ASP   163      10.324  37.063 163.848  1.00 36.36           C  
ATOM   1204  CG  ASP   163      11.103  35.796 164.126  1.00 38.68           C  
ATOM   1205  OD1 ASP   163      11.514  35.602 165.286  1.00 41.88           O  
ATOM   1206  OD2 ASP   163      11.319  34.996 163.186  1.00 44.47           O  
ATOM   1207  N   ALA   164       7.352  38.800 165.048  1.00 34.25           N  
ATOM   1208  CA  ALA   164       6.485  39.911 164.677  1.00 35.10           C  
ATOM   1209  C   ALA   164       6.843  41.287 165.218  1.00 37.45           C  
ATOM   1210  O   ALA   164       6.275  42.297 164.783  1.00 36.35           O  
ATOM   1211  CB  ALA   164       5.058  39.579 165.062  1.00 34.18           C  
ATOM   1212  N   LEU   165       7.782  41.327 166.155  1.00 38.68           N  
ATOM   1213  CA  LEU   165       8.179  42.576 166.783  1.00 41.51           C  
ATOM   1214  C   LEU   165       9.527  43.091 166.299  1.00 43.63           C  
ATOM   1215  O   LEU   165       9.965  44.174 166.688  1.00 44.67           O  
ATOM   1216  CB  LEU   165       8.215  42.389 168.300  1.00 40.59           C  
ATOM   1217  CG  LEU   165       6.898  42.048 169.005  1.00 37.73           C  
ATOM   1218  CD1 LEU   165       7.169  41.504 170.401  1.00 39.58           C  
ATOM   1219  CD2 LEU   165       6.026  43.291 169.080  1.00 42.32           C  
ATOM   1220  N   LEU   166      10.172  42.306 165.446  1.00 46.20           N  
ATOM   1221  CA  LEU   166      11.477  42.650 164.900  1.00 47.74           C  
ATOM   1222  C   LEU   166      12.459  43.155 165.952  1.00 49.34           C  
ATOM   1223  O   LEU   166      13.031  44.241 165.822  1.00 48.89           O  
ATOM   1224  CB  LEU   166      11.326  43.671 163.760  1.00 47.18           C  
ATOM   1225  CG  LEU   166      10.589  43.140 162.518  1.00 47.23           C  
ATOM   1226  CD1 LEU   166      10.505  44.215 161.444  1.00 48.55           C  
ATOM   1227  CD2 LEU   166      11.325  41.922 161.986  1.00 48.26           C  
ATOM   1228  N   ASP   167      12.632  42.357 167.004  1.00 51.27           N  
ATOM   1229  CA  ASP   167      13.570  42.673 168.073  1.00 52.31           C  
ATOM   1230  C   ASP   167      13.333  44.014 168.764  1.00 53.19           C  
ATOM   1231  O   ASP   167      14.231  44.548 169.422  1.00 53.46           O  
ATOM   1232  CB  ASP   167      14.992  42.629 167.513  1.00 53.31           C  
ATOM   1233  CG  ASP   167      15.465  41.213 167.224  1.00 54.32           C  
ATOM   1234  OD1 ASP   167      15.400  40.377 168.146  1.00 57.29           O  
ATOM   1235  OD2 ASP   167      15.913  40.938 166.089  1.00 59.10           O  
ATOM   1236  N   GLY   168      12.123  44.545 168.614  1.00 54.04           N  
ATOM   1237  CA  GLY   168      11.793  45.823 169.209  1.00 56.23           C  
ATOM   1238  C   GLY   168      12.089  46.953 168.235  1.00 58.04           C  
ATOM   1239  O   GLY   168      11.750  48.110 168.482  1.00 57.65           O  
ATOM   1240  N   THR   169      12.735  46.611 167.124  1.00 59.91           N  
ATOM   1241  CA  THR   169      13.095  47.571 166.079  1.00 61.31           C  
ATOM   1242  C   THR   169      12.033  48.640 165.864  1.00 62.28           C  
ATOM   1243  O   THR   169      12.365  49.803 165.619  1.00 63.59           O  
ATOM   1244  CB  THR   169      13.342  46.846 164.726  1.00 60.94           C  
ATOM   1245  OG1 THR   169      14.680  46.335 164.684  1.00 60.61           O  
ATOM   1246  CG2 THR   169      13.109  47.780 163.544  1.00 62.48           C  
ATOM   1247  N   ILE   170      10.762  48.250 165.954  1.00 63.65           N  
ATOM   1248  CA  ILE   170       9.677  49.198 165.728  1.00 65.26           C  
ATOM   1249  C   ILE   170       9.646  50.344 166.743  1.00 67.56           C  
ATOM   1250  O   ILE   170      10.360  50.315 167.740  1.00 67.27           O  
ATOM   1251  CB  ILE   170       8.300  48.465 165.611  1.00 64.43           C  
ATOM   1252  CG1 ILE   170       8.059  47.560 166.808  1.00 65.08           C  
ATOM   1253  CG2 ILE   170       8.284  47.632 164.319  1.00 63.91           C  
ATOM   1254  CD1 ILE   170       6.824  46.694 166.661  1.00 61.22           C  
ATOM   1255  N   ALA   171       8.815  51.349 166.477  1.00 71.03           N  
ATOM   1256  CA  ALA   171       8.732  52.562 167.298  1.00 74.04           C  
ATOM   1257  C   ALA   171      10.147  53.153 167.376  1.00 76.78           C  
ATOM   1258  O   ALA   171      10.730  53.279 168.460  1.00 77.43           O  
ATOM   1259  CB  ALA   171       8.222  52.258 168.694  1.00 74.35           C  
ATOM   1260  N   ASP   172      10.699  53.525 166.223  1.00 79.39           N  
ATOM   1261  CA  ASP   172      12.045  54.097 166.162  1.00 81.44           C  
ATOM   1262  C   ASP   172      12.123  55.050 164.972  1.00 82.22           C  
ATOM   1263  O   ASP   172      12.056  54.625 163.819  1.00 83.14           O  
ATOM   1264  CB  ASP   172      13.070  52.972 165.995  1.00 81.68           C  
ATOM   1265  CG  ASP   172      14.447  53.340 166.498  1.00 85.84           C  
ATOM   1266  OD1 ASP   172      14.833  54.516 166.380  1.00 90.92           O  
ATOM   1267  OD2 ASP   172      15.153  52.441 166.997  1.00 87.39           O  
ATOM   1268  N   GLN   173      12.282  56.336 165.262  1.00 82.92           N  
ATOM   1269  CA  GLN   173      12.352  57.356 164.224  1.00 83.98           C  
ATOM   1270  C   GLN   173      13.324  57.023 163.106  1.00 83.45           C  
ATOM   1271  O   GLN   173      12.969  57.063 161.933  1.00 83.90           O  
ATOM   1272  CB  GLN   173      12.712  58.717 164.834  1.00 84.72           C  
ATOM   1273  CG  GLN   173      11.607  59.350 165.690  1.00 88.73           C  
ATOM   1274  CD  GLN   173      11.323  58.578 166.965  1.00 91.02           C  
ATOM   1275  OE1 GLN   173      12.243  58.150 167.655  1.00 91.29           O  
ATOM   1276  NE2 GLN   173      10.044  58.415 167.295  1.00 90.94           N  
ATOM   1277  N   THR   174      14.550  56.679 163.477  1.00 82.77           N  
ATOM   1278  CA  THR   174      15.575  56.341 162.498  1.00 82.11           C  
ATOM   1279  C   THR   174      15.135  55.223 161.573  1.00 81.93           C  
ATOM   1280  O   THR   174      15.240  55.333 160.348  1.00 81.65           O  
ATOM   1281  CB  THR   174      16.901  55.902 163.178  1.00 82.03           C  
ATOM   1282  OG1 THR   174      16.664  54.764 164.022  1.00 82.87           O  
ATOM   1283  CG2 THR   174      17.494  57.036 164.004  1.00 80.61           C  
ATOM   1284  N   ARG   175      14.620  54.155 162.170  1.00 81.42           N  
ATOM   1285  CA  ARG   175      14.203  52.990 161.400  1.00 80.76           C  
ATOM   1286  C   ARG   175      13.016  53.134 160.457  1.00 80.26           C  
ATOM   1287  O   ARG   175      11.901  52.742 160.806  1.00 80.41           O  
ATOM   1288  CB  ARG   175      13.966  51.805 162.341  1.00 80.91           C  
ATOM   1289  CG  ARG   175      14.234  50.422 161.726  1.00 82.08           C  
ATOM   1290  CD  ARG   175      15.675  49.988 161.956  1.00 84.76           C  
ATOM   1291  NE  ARG   175      16.086  50.219 163.341  1.00 85.35           N  
ATOM   1292  CZ  ARG   175      17.050  49.545 163.962  1.00 86.15           C  
ATOM   1293  NH1 ARG   175      17.712  48.585 163.327  1.00 83.31           N  
ATOM   1294  NH2 ARG   175      17.346  49.826 165.226  1.00 86.88           N  
ATOM   1295  N   LYS   176      13.252  53.728 159.283  1.00 79.32           N  
ATOM   1296  CA  LYS   176      12.200  53.819 158.277  1.00 77.64           C  
ATOM   1297  C   LYS   176      12.482  52.544 157.460  1.00 76.67           C  
ATOM   1298  O   LYS   176      13.654  52.147 157.250  1.00 76.95           O  
ATOM   1299  CB  LYS   176      12.349  55.063 157.415  1.00 78.36           C  
ATOM   1300  N   ASP   177      11.419  51.901 156.986  1.00 73.97           N  
ATOM   1301  CA  ASP   177      11.555  50.614 156.296  1.00 71.10           C  
ATOM   1302  C   ASP   177      10.173  50.140 155.855  1.00 69.68           C  
ATOM   1303  O   ASP   177       9.176  50.354 156.551  1.00 69.25           O  
ATOM   1304  CB  ASP   177      12.096  49.619 157.317  1.00 71.15           C  
ATOM   1305  CG  ASP   177      13.030  48.583 156.729  1.00 71.21           C  
ATOM   1306  OD1 ASP   177      13.875  48.966 155.902  1.00 71.86           O  
ATOM   1307  OD2 ASP   177      12.938  47.392 157.122  1.00 69.21           O  
ATOM   1308  N   ARG   178      10.122  49.464 154.716  1.00 67.48           N  
ATOM   1309  CA  ARG   178       8.873  48.908 154.231  1.00 65.11           C  
ATOM   1310  C   ARG   178       8.368  47.952 155.319  1.00 62.93           C  
ATOM   1311  O   ARG   178       7.205  47.995 155.716  1.00 61.37           O  
ATOM   1312  CB  ARG   178       9.120  48.129 152.934  1.00 65.76           C  
ATOM   1313  N   ASP   179       9.258  47.081 155.789  1.00 61.40           N  
ATOM   1314  CA  ASP   179       8.914  46.072 156.785  1.00 61.31           C  
ATOM   1315  C   ASP   179       8.565  46.570 158.176  1.00 61.77           C  
ATOM   1316  O   ASP   179       7.499  46.240 158.708  1.00 62.54           O  
ATOM   1317  CB  ASP   179      10.025  45.013 156.857  1.00 60.28           C  
ATOM   1318  CG  ASP   179       9.996  44.057 155.657  1.00 60.29           C  
ATOM   1319  OD1 ASP   179       8.969  44.025 154.933  1.00 56.76           O  
ATOM   1320  OD2 ASP   179      10.993  43.330 155.451  1.00 58.00           O  
ATOM   1321  N   THR   180       9.457  47.362 158.756  1.00 61.26           N  
ATOM   1322  CA  THR   180       9.238  47.899 160.085  1.00 60.59           C  
ATOM   1323  C   THR   180       7.871  48.589 160.156  1.00 59.22           C  
ATOM   1324  O   THR   180       7.154  48.475 161.156  1.00 59.51           O  
ATOM   1325  CB  THR   180      10.351  48.910 160.457  1.00 60.28           C  
ATOM   1326  OG1 THR   180      10.457  48.997 161.881  1.00 63.84           O  
ATOM   1327  CG2 THR   180      10.034  50.299 159.913  1.00 62.53           C  
ATOM   1328  N   GLN   181       7.517  49.301 159.089  1.00 57.42           N  
ATOM   1329  CA  GLN   181       6.250  50.026 159.021  1.00 56.34           C  
ATOM   1330  C   GLN   181       5.053  49.083 158.956  1.00 54.30           C  
ATOM   1331  O   GLN   181       3.980  49.394 159.486  1.00 55.01           O  
ATOM   1332  CB  GLN   181       6.247  50.951 157.799  1.00 56.61           C  
ATOM   1333  CG  GLN   181       5.074  51.905 157.722  1.00 60.31           C  
ATOM   1334  CD  GLN   181       5.224  52.896 156.579  1.00 66.50           C  
ATOM   1335  OE1 GLN   181       6.338  53.162 156.123  1.00 68.79           O  
ATOM   1336  NE2 GLN   181       4.108  53.467 156.131  1.00 65.27           N  
ATOM   1337  N   ALA   182       5.241  47.936 158.308  1.00 52.30           N  
ATOM   1338  CA  ALA   182       4.177  46.945 158.188  1.00 51.70           C  
ATOM   1339  C   ALA   182       4.042  46.221 159.534  1.00 49.61           C  
ATOM   1340  O   ALA   182       2.929  45.999 160.011  1.00 48.87           O  
ATOM   1341  CB  ALA   182       4.504  45.948 157.068  1.00 51.18           C  
ATOM   1342  N   ALA   183       5.175  45.864 160.141  1.00 47.78           N  
ATOM   1343  CA  ALA   183       5.170  45.196 161.439  1.00 49.10           C  
ATOM   1344  C   ALA   183       4.535  46.152 162.474  1.00 50.05           C  
ATOM   1345  O   ALA   183       3.764  45.721 163.333  1.00 49.60           O  
ATOM   1346  CB  ALA   183       6.601  44.831 161.846  1.00 47.67           C  
ATOM   1347  N   ARG   184       4.849  47.448 162.392  1.00 51.31           N  
ATOM   1348  CA  ARG   184       4.283  48.433 163.319  1.00 52.65           C  
ATOM   1349  C   ARG   184       2.760  48.504 163.162  1.00 53.41           C  
ATOM   1350  O   ARG   184       2.031  48.534 164.157  1.00 53.91           O  
ATOM   1351  CB  ARG   184       4.872  49.820 163.066  1.00 54.06           C  
ATOM   1352  CG  ARG   184       5.157  50.600 164.341  1.00 57.28           C  
ATOM   1353  CD  ARG   184       5.260  52.096 164.094  1.00 59.50           C  
ATOM   1354  NE  ARG   184       6.262  52.446 163.092  1.00 61.89           N  
ATOM   1355  CZ  ARG   184       7.549  52.123 163.171  1.00 65.18           C  
ATOM   1356  NH1 ARG   184       8.000  51.441 164.209  1.00 66.46           N  
ATOM   1357  NH2 ARG   184       8.390  52.486 162.210  1.00 67.83           N  
ATOM   1358  N   ASP   185       2.280  48.532 161.917  1.00 53.41           N  
ATOM   1359  CA  ASP   185       0.838  48.596 161.664  1.00 54.19           C  
ATOM   1360  C   ASP   185       0.141  47.321 162.135  1.00 52.11           C  
ATOM   1361  O   ASP   185      -0.988  47.361 162.637  1.00 51.76           O  
ATOM   1362  CB  ASP   185       0.545  48.817 160.177  1.00 55.83           C  
ATOM   1363  CG  ASP   185      -0.940  48.873 159.884  1.00 63.25           C  
ATOM   1364  OD1 ASP   185      -1.551  47.806 159.669  1.00 71.31           O  
ATOM   1365  OD2 ASP   185      -1.503  49.988 159.886  1.00 73.27           O  
ATOM   1366  N   ALA   186       0.817  46.189 161.972  1.00 50.23           N  
ATOM   1367  CA  ALA   186       0.269  44.908 162.407  1.00 48.60           C  
ATOM   1368  C   ALA   186       0.097  44.960 163.936  1.00 46.32           C  
ATOM   1369  O   ALA   186      -0.975  44.666 164.459  1.00 45.88           O  
ATOM   1370  CB  ALA   186       1.220  43.776 162.022  1.00 47.52           C  
ATOM   1371  N   ASP   187       1.157  45.336 164.646  1.00 45.93           N  
ATOM   1372  CA  ASP   187       1.121  45.421 166.106  1.00 46.57           C  
ATOM   1373  C   ASP   187      -0.020  46.353 166.537  1.00 46.63           C  
ATOM   1374  O   ASP   187      -0.879  45.975 167.341  1.00 46.91           O  
ATOM   1375  CB  ASP   187       2.474  45.939 166.620  1.00 45.25           C  
ATOM   1376  CG  ASP   187       2.575  45.923 168.138  1.00 49.55           C  
ATOM   1377  OD1 ASP   187       2.652  44.821 168.735  1.00 45.87           O  
ATOM   1378  OD2 ASP   187       2.569  47.024 168.736  1.00 50.96           O  
ATOM   1379  N   GLU   188      -0.024  47.571 166.001  1.00 46.68           N  
ATOM   1380  CA  GLU   188      -1.064  48.545 166.320  1.00 46.47           C  
ATOM   1381  C   GLU   188      -2.450  47.988 165.972  1.00 45.29           C  
ATOM   1382  O   GLU   188      -3.409  48.177 166.717  1.00 44.23           O  
ATOM   1383  CB  GLU   188      -0.806  49.845 165.548  1.00 47.29           C  
ATOM   1384  CG  GLU   188      -1.912  50.873 165.661  1.00 52.14           C  
ATOM   1385  CD  GLU   188      -1.559  52.167 164.960  1.00 58.46           C  
ATOM   1386  OE1 GLU   188      -0.450  52.686 165.211  1.00 60.41           O  
ATOM   1387  OE2 GLU   188      -2.388  52.672 164.171  1.00 57.72           O  
ATOM   1388  N   TYR   189      -2.552  47.304 164.835  1.00 44.78           N  
ATOM   1389  CA  TYR   189      -3.822  46.712 164.409  1.00 43.79           C  
ATOM   1390  C   TYR   189      -4.226  45.571 165.343  1.00 42.73           C  
ATOM   1391  O   TYR   189      -5.385  45.467 165.753  1.00 43.44           O  
ATOM   1392  CB  TYR   189      -3.716  46.157 162.994  1.00 43.66           C  
ATOM   1393  CG  TYR   189      -4.990  45.489 162.538  1.00 43.06           C  
ATOM   1394  CD1 TYR   189      -6.135  46.241 162.280  1.00 45.51           C  
ATOM   1395  CD2 TYR   189      -5.064  44.104 162.395  1.00 40.70           C  
ATOM   1396  CE1 TYR   189      -7.320  45.635 161.886  1.00 48.14           C  
ATOM   1397  CE2 TYR   189      -6.248  43.483 162.003  1.00 43.88           C  
ATOM   1398  CZ  TYR   189      -7.370  44.256 161.751  1.00 46.56           C  
ATOM   1399  OH  TYR   189      -8.540  43.659 161.351  1.00 45.85           O  
ATOM   1400  N   ILE   190      -3.268  44.710 165.676  1.00 41.78           N  
ATOM   1401  CA  ILE   190      -3.536  43.587 166.562  1.00 39.45           C  
ATOM   1402  C   ILE   190      -4.024  44.084 167.931  1.00 39.67           C  
ATOM   1403  O   ILE   190      -4.950  43.518 168.511  1.00 38.60           O  
ATOM   1404  CB  ILE   190      -2.267  42.701 166.725  1.00 40.19           C  
ATOM   1405  CG1 ILE   190      -2.089  41.824 165.479  1.00 36.29           C  
ATOM   1406  CG2 ILE   190      -2.366  41.848 167.998  1.00 37.83           C  
ATOM   1407  CD1 ILE   190      -0.753  41.100 165.413  1.00 26.27           C  
ATOM   1408  N   ARG   191      -3.404  45.142 168.445  1.00 40.01           N  
ATOM   1409  CA  ARG   191      -3.792  45.684 169.743  1.00 43.13           C  
ATOM   1410  C   ARG   191      -5.132  46.419 169.725  1.00 44.80           C  
ATOM   1411  O   ARG   191      -5.630  46.842 170.766  1.00 44.64           O  
ATOM   1412  CB  ARG   191      -2.695  46.611 170.265  1.00 41.94           C  
ATOM   1413  CG  ARG   191      -1.437  45.882 170.742  1.00 42.77           C  
ATOM   1414  CD  ARG   191      -0.238  46.814 170.764  1.00 46.32           C  
ATOM   1415  NE  ARG   191      -0.668  48.195 170.934  1.00 51.32           N  
ATOM   1416  CZ  ARG   191      -0.136  49.228 170.292  1.00 50.72           C  
ATOM   1417  NH1 ARG   191       0.853  49.047 169.427  1.00 50.42           N  
ATOM   1418  NH2 ARG   191      -0.598  50.446 170.515  1.00 53.35           N  
ATOM   1419  N   SER   192      -5.725  46.543 168.543  1.00 45.68           N  
ATOM   1420  CA  SER   192      -6.994  47.240 168.393  1.00 46.18           C  
ATOM   1421  C   SER   192      -8.188  46.294 168.323  1.00 46.25           C  
ATOM   1422  O   SER   192      -9.328  46.721 168.519  1.00 46.21           O  
ATOM   1423  CB  SER   192      -6.979  48.097 167.124  1.00 47.71           C  
ATOM   1424  OG  SER   192      -7.303  47.324 165.967  1.00 47.27           O  
ATOM   1425  N   ILE   193      -7.944  45.015 168.046  1.00 47.19           N  
ATOM   1426  CA  ILE   193      -9.054  44.092 167.912  1.00 46.69           C  
ATOM   1427  C   ILE   193      -9.698  43.766 169.246  1.00 45.97           C  
ATOM   1428  O   ILE   193      -9.027  43.638 170.263  1.00 45.13           O  
ATOM   1429  CB  ILE   193      -8.627  42.829 167.096  1.00 46.55           C  
ATOM   1430  CG1 ILE   193      -9.275  41.581 167.659  1.00 48.58           C  
ATOM   1431  CG2 ILE   193      -7.122  42.735 167.017  1.00 48.52           C  
ATOM   1432  CD1 ILE   193      -8.374  40.370 167.601  1.00 53.08           C  
ATOM   1433  N   GLU   194     -11.020  43.641 169.220  1.00 46.10           N  
ATOM   1434  CA  GLU   194     -11.803  43.405 170.419  1.00 46.72           C  
ATOM   1435  C   GLU   194     -12.074  41.944 170.734  1.00 45.13           C  
ATOM   1436  O   GLU   194     -12.243  41.126 169.834  1.00 44.75           O  
ATOM   1437  CB  GLU   194     -13.119  44.175 170.299  1.00 48.29           C  
ATOM   1438  CG  GLU   194     -13.732  44.629 171.616  1.00 53.72           C  
ATOM   1439  CD  GLU   194     -13.127  45.922 172.135  1.00 60.45           C  
ATOM   1440  OE1 GLU   194     -12.510  46.656 171.332  1.00 61.44           O  
ATOM   1441  OE2 GLU   194     -13.287  46.211 173.341  1.00 63.38           O  
ATOM   1442  N   GLY   195     -12.123  41.631 172.022  1.00 42.68           N  
ATOM   1443  CA  GLY   195     -12.355  40.262 172.422  1.00 41.19           C  
ATOM   1444  C   GLY   195     -11.115  39.427 172.149  1.00 38.96           C  
ATOM   1445  O   GLY   195     -11.204  38.228 171.879  1.00 38.68           O  
ATOM   1446  N   ALA   196      -9.949  40.069 172.193  1.00 37.97           N  
ATOM   1447  CA  ALA   196      -8.669  39.386 171.968  1.00 38.03           C  
ATOM   1448  C   ALA   196      -7.746  39.616 173.142  1.00 38.17           C  
ATOM   1449  O   ALA   196      -7.723  40.713 173.714  1.00 39.15           O  
ATOM   1450  CB  ALA   196      -7.979  39.904 170.722  1.00 37.01           C  
ATOM   1451  N   HIS   197      -6.990  38.587 173.518  1.00 36.67           N  
ATOM   1452  CA  HIS   197      -5.979  38.759 174.559  1.00 34.86           C  
ATOM   1453  C   HIS   197      -4.672  38.817 173.766  1.00 34.12           C  
ATOM   1454  O   HIS   197      -4.383  37.946 172.928  1.00 34.95           O  
ATOM   1455  CB  HIS   197      -5.904  37.572 175.516  1.00 34.32           C  
ATOM   1456  CG  HIS   197      -7.163  37.314 176.261  1.00 30.53           C  
ATOM   1457  ND1 HIS   197      -7.739  38.243 177.100  1.00 28.83           N  
ATOM   1458  CD2 HIS   197      -7.935  36.209 176.330  1.00 32.70           C  
ATOM   1459  CE1 HIS   197      -8.814  37.717 177.656  1.00 29.31           C  
ATOM   1460  NE2 HIS   197      -8.955  36.484 177.205  1.00 27.66           N  
ATOM   1461  N   VAL   198      -3.887  39.856 174.006  1.00 32.85           N  
ATOM   1462  CA  VAL   198      -2.614  40.026 173.315  1.00 31.44           C  
ATOM   1463  C   VAL   198      -1.459  39.870 174.291  1.00 31.83           C  
ATOM   1464  O   VAL   198      -1.404  40.553 175.311  1.00 33.09           O  
ATOM   1465  CB  VAL   198      -2.521  41.420 172.641  1.00 32.23           C  
ATOM   1466  CG1 VAL   198      -1.167  41.590 171.962  1.00 29.85           C  
ATOM   1467  CG2 VAL   198      -3.662  41.584 171.629  1.00 31.51           C  
ATOM   1468  N   ALA   199      -0.555  38.942 173.991  1.00 31.03           N  
ATOM   1469  CA  ALA   199       0.623  38.735 174.820  1.00 30.46           C  
ATOM   1470  C   ALA   199       1.808  38.865 173.865  1.00 30.64           C  
ATOM   1471  O   ALA   199       1.832  38.228 172.812  1.00 30.97           O  
ATOM   1472  CB  ALA   199       0.609  37.340 175.471  1.00 28.20           C  
ATOM   1473  N   ARG   200       2.775  39.707 174.212  1.00 30.50           N  
ATOM   1474  CA  ARG   200       3.949  39.902 173.383  1.00 31.66           C  
ATOM   1475  C   ARG   200       5.137  39.535 174.265  1.00 32.61           C  
ATOM   1476  O   ARG   200       5.411  40.170 175.282  1.00 33.33           O  
ATOM   1477  CB  ARG   200       3.962  41.351 172.862  1.00 31.67           C  
ATOM   1478  CG  ARG   200       2.891  41.543 171.766  1.00 36.13           C  
ATOM   1479  CD  ARG   200       2.761  43.000 171.353  1.00 37.83           C  
ATOM   1480  NE  ARG   200       2.310  43.827 172.467  1.00 38.02           N  
ATOM   1481  CZ  ARG   200       2.536  45.129 172.561  1.00 37.23           C  
ATOM   1482  NH1 ARG   200       3.209  45.752 171.599  1.00 37.07           N  
ATOM   1483  NH2 ARG   200       2.122  45.793 173.631  1.00 35.20           N  
ATOM   1484  N   LEU   201       5.848  38.501 173.837  1.00 31.75           N  
ATOM   1485  CA  LEU   201       6.921  37.919 174.608  1.00 31.41           C  
ATOM   1486  C   LEU   201       8.335  37.984 174.037  1.00 31.43           C  
ATOM   1487  O   LEU   201       8.513  38.065 172.835  1.00 31.82           O  
ATOM   1488  CB  LEU   201       6.513  36.467 174.892  1.00 29.43           C  
ATOM   1489  CG  LEU   201       5.021  36.302 175.288  1.00 32.44           C  
ATOM   1490  CD1 LEU   201       4.614  34.815 175.271  1.00 26.90           C  
ATOM   1491  CD2 LEU   201       4.773  36.920 176.667  1.00 27.08           C  
ATOM   1492  N   PRO   202       9.352  37.925 174.917  1.00 30.80           N  
ATOM   1493  CA  PRO   202      10.767  37.978 174.532  1.00 30.32           C  
ATOM   1494  C   PRO   202      11.335  36.677 173.954  1.00 30.34           C  
ATOM   1495  O   PRO   202      12.359  36.191 174.416  1.00 30.23           O  
ATOM   1496  CB  PRO   202      11.457  38.373 175.834  1.00 30.91           C  
ATOM   1497  CG  PRO   202      10.656  37.632 176.860  1.00 28.45           C  
ATOM   1498  CD  PRO   202       9.205  37.859 176.387  1.00 30.07           C  
ATOM   1499  N   LEU   203      10.667  36.118 172.952  1.00 30.48           N  
ATOM   1500  CA  LEU   203      11.123  34.883 172.314  1.00 30.84           C  
ATOM   1501  C   LEU   203      11.410  35.167 170.839  1.00 31.51           C  
ATOM   1502  O   LEU   203      10.659  35.887 170.186  1.00 30.41           O  
ATOM   1503  CB  LEU   203      10.053  33.790 172.456  1.00 30.29           C  
ATOM   1504  CG  LEU   203       9.891  33.170 173.843  1.00 32.44           C  
ATOM   1505  CD1 LEU   203       8.508  32.527 173.937  1.00 32.55           C  
ATOM   1506  CD2 LEU   203      11.009  32.152 174.088  1.00 23.45           C  
ATOM   1507  N   GLY   204      12.497  34.596 170.326  1.00 32.37           N  
ATOM   1508  CA  GLY   204      12.882  34.847 168.949  1.00 34.19           C  
ATOM   1509  C   GLY   204      13.081  36.350 168.798  1.00 35.62           C  
ATOM   1510  O   GLY   204      13.706  36.997 169.647  1.00 35.96           O  
ATOM   1511  N   ALA   205      12.557  36.924 167.719  1.00 35.06           N  
ATOM   1512  CA  ALA   205      12.671  38.366 167.495  1.00 35.51           C  
ATOM   1513  C   ALA   205      11.446  39.095 168.071  1.00 35.05           C  
ATOM   1514  O   ALA   205      11.159  40.235 167.697  1.00 34.58           O  
ATOM   1515  CB  ALA   205      12.804  38.661 165.991  1.00 35.87           C  
ATOM   1516  N   GLY   206      10.724  38.440 168.978  1.00 35.87           N  
ATOM   1517  CA  GLY   206       9.545  39.052 169.571  1.00 34.61           C  
ATOM   1518  C   GLY   206       8.283  38.367 169.082  1.00 35.34           C  
ATOM   1519  O   GLY   206       7.853  38.570 167.954  1.00 34.47           O  
ATOM   1520  N   LEU   207       7.677  37.575 169.958  1.00 34.79           N  
ATOM   1521  CA  LEU   207       6.491  36.801 169.637  1.00 31.42           C  
ATOM   1522  C   LEU   207       5.192  37.467 170.024  1.00 30.81           C  
ATOM   1523  O   LEU   207       5.061  37.984 171.123  1.00 31.83           O  
ATOM   1524  CB  LEU   207       6.606  35.445 170.336  1.00 33.46           C  
ATOM   1525  CG  LEU   207       5.572  34.340 170.108  1.00 33.46           C  
ATOM   1526  CD1 LEU   207       5.830  33.688 168.753  1.00 37.83           C  
ATOM   1527  CD2 LEU   207       5.667  33.296 171.214  1.00 30.57           C  
ATOM   1528  N   THR   208       4.228  37.466 169.113  1.00 30.32           N  
ATOM   1529  CA  THR   208       2.928  38.023 169.439  1.00 28.64           C  
ATOM   1530  C   THR   208       1.915  36.888 169.395  1.00 29.95           C  
ATOM   1531  O   THR   208       1.733  36.237 168.356  1.00 29.31           O  
ATOM   1532  CB  THR   208       2.457  39.112 168.449  1.00 30.18           C  
ATOM   1533  OG1 THR   208       3.403  40.185 168.423  1.00 30.22           O  
ATOM   1534  CG2 THR   208       1.104  39.671 168.893  1.00 26.07           C  
ATOM   1535  N   VAL   209       1.290  36.608 170.530  1.00 29.09           N  
ATOM   1536  CA  VAL   209       0.264  35.589 170.541  1.00 29.88           C  
ATOM   1537  C   VAL   209      -1.036  36.292 170.927  1.00 30.32           C  
ATOM   1538  O   VAL   209      -1.116  37.033 171.909  1.00 32.33           O  
ATOM   1539  CB  VAL   209       0.622  34.361 171.478  1.00 29.48           C  
ATOM   1540  CG1 VAL   209       1.798  34.685 172.342  1.00 29.65           C  
ATOM   1541  CG2 VAL   209      -0.590  33.915 172.266  1.00 25.94           C  
ATOM   1542  N   VAL   210      -2.055  36.092 170.111  1.00 30.08           N  
ATOM   1543  CA  VAL   210      -3.324  36.706 170.372  1.00 30.95           C  
ATOM   1544  C   VAL   210      -4.362  35.599 170.439  1.00 31.19           C  
ATOM   1545  O   VAL   210      -4.602  34.856 169.474  1.00 31.19           O  
ATOM   1546  CB  VAL   210      -3.619  37.855 169.309  1.00 32.54           C  
ATOM   1547  CG1 VAL   210      -2.689  37.714 168.126  1.00 29.10           C  
ATOM   1548  CG2 VAL   210      -5.061  37.887 168.913  1.00 30.41           C  
ATOM   1549  N   THR   211      -4.970  35.474 171.610  1.00 31.26           N  
ATOM   1550  CA  THR   211      -5.956  34.445 171.782  1.00 33.16           C  
ATOM   1551  C   THR   211      -7.354  35.046 171.827  1.00 33.51           C  
ATOM   1552  O   THR   211      -7.553  36.165 172.310  1.00 34.80           O  
ATOM   1553  CB  THR   211      -5.607  33.534 173.019  1.00 33.51           C  
ATOM   1554  OG1 THR   211      -6.632  33.598 174.013  1.00 32.53           O  
ATOM   1555  CG2 THR   211      -4.269  33.914 173.600  1.00 26.11           C  
ATOM   1556  N   LYS   212      -8.314  34.304 171.283  1.00 33.14           N  
ATOM   1557  CA  LYS   212      -9.690  34.759 171.217  1.00 32.21           C  
ATOM   1558  C   LYS   212     -10.338  34.586 172.574  1.00 33.16           C  
ATOM   1559  O   LYS   212     -10.486  33.483 173.093  1.00 31.48           O  
ATOM   1560  CB  LYS   212     -10.451  33.983 170.126  1.00 30.67           C  
ATOM   1561  CG  LYS   212     -11.848  34.499 169.856  1.00 31.48           C  
ATOM   1562  CD  LYS   212     -12.519  33.780 168.685  1.00 33.82           C  
ATOM   1563  CE  LYS   212     -11.949  34.223 167.341  1.00 34.01           C  
ATOM   1564  NZ  LYS   212     -12.701  33.627 166.197  1.00 35.69           N  
ATOM   1565  N   ALA   213     -10.723  35.710 173.156  1.00 35.52           N  
ATOM   1566  CA  ALA   213     -11.339  35.718 174.472  1.00 36.71           C  
ATOM   1567  C   ALA   213     -12.641  34.939 174.553  1.00 38.53           C  
ATOM   1568  O   ALA   213     -13.372  34.834 173.570  1.00 39.30           O  
ATOM   1569  CB  ALA   213     -11.569  37.170 174.922  1.00 37.58           C  
END
