
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  192 ( 1566),  selected  192 , name 2gpy_B
# Molecule2: number of CA atoms  211 ( 1569),  selected  211 , name T0509.pdb
# PARAMETERS: 2gpy_B.T0509.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    L     8_B      N       3           -
LGA    K     9_B      A       4          3.992
LGA    -       -      F       5           -
LGA    H    10_B      E       6          5.508
LGA    Y    11_B      Y       7          5.368
LGA    L    12_B      L       8          2.644
LGA    E    13_B      R       9          1.637
LGA    K    14_B      T      10          3.052
LGA    -       -      Y      11           -
LGA    Q    15_B      V      12          1.272
LGA    I    16_B      E      13          3.032
LGA    -       -      S      14           -
LGA    -       -      T      15           -
LGA    P    17_B      T      16          1.050
LGA    A    18_B      E      17          2.973
LGA    R    19_B      T      18          2.799
LGA    D    20_B      D      19          2.175
LGA    Q    21_B      A      20          2.107
LGA    Y    22_B      A      21          3.115
LGA    I    23_B      V      22          2.036
LGA    E    24_B      A      23          1.017
LGA    Q    25_B      R      24          2.252
LGA    X    26_B      A      25          2.056
LGA    E    27_B      R      26          1.063
LGA    R    28_B      E      27          1.972
LGA    E    29_B      D      28          2.354
LGA    A    30_B      A      29          1.395
LGA    H    31_B      A      30          1.441
LGA    E    32_B      E      31          2.588
LGA    Q    33_B      F      32          2.029
LGA    Q    34_B      G      33          0.400
LGA    V    35_B      L      34          1.376
LGA    P    36_B      P      35          1.829
LGA    I    37_B      A      36          1.268
LGA    X    38_B      P      37          1.137
LGA    D    39_B      D      38          1.816
LGA    L    40_B      E      39          2.081
LGA    L    41_B      M      40          2.250
LGA    G    42_B      T      41          1.751
LGA    X    43_B      G      42          1.642
LGA    E    44_B      Q      43          2.111
LGA    S    45_B      L      44          2.853
LGA    L    46_B      L      45          2.971
LGA    L    47_B      T      46          2.169
LGA    H    48_B      T      47          2.822
LGA    L    49_B      L      48          3.991
LGA    L    50_B      A      49          3.533
LGA    K    51_B      A      50          2.753
LGA    X    52_B      T      51          3.561
LGA    A    53_B      T      52          3.591
LGA    A    54_B      N      53           #
LGA    P    55_B      G      54          4.450
LGA    A    56_B      N      55           #
LGA    -       -      G      56           -
LGA    -       -      S      57           -
LGA    -       -      T      58           -
LGA    R    57_B      G      59          1.366
LGA    I    58_B      A      60          0.956
LGA    L    59_B      I      61          1.568
LGA    E    60_B      A      62          1.937
LGA    I    61_B      I      63          1.763
LGA    G    62_B      T      64          2.235
LGA    T    63_B      P      65           #
LGA    A    64_B      A      66          2.625
LGA    I    65_B      A      67          4.703
LGA    G    66_B      G      68          1.448
LGA    Y    67_B      L      69          1.062
LGA    S    68_B      V      70          0.557
LGA    A    69_B      G      71          0.979
LGA    I    70_B      L      72          1.798
LGA    R    71_B      Y      73          1.980
LGA    X    72_B      I      74          1.080
LGA    A    73_B      L      75          0.453
LGA    Q    74_B      N      76          2.161
LGA    A    75_B      G      77          3.198
LGA    L    76_B      L      78          2.988
LGA    P    77_B      A      79          5.001
LGA    E    78_B      D      80          2.553
LGA    A    79_B      N      81          5.653
LGA    -       -      T      82           -
LGA    T    80_B      T      83          2.297
LGA    I    81_B      L      84          1.256
LGA    V    82_B      T      85          1.238
LGA    S    83_B      C      86          1.466
LGA    I    84_B      I      87          1.027
LGA    E    85_B      D      88          1.141
LGA    R    86_B      P      89          0.980
LGA    D    87_B      E      90          1.049
LGA    E    88_B      S      91          1.428
LGA    R    89_B      E      92          1.447
LGA    R    90_B      H      93          0.912
LGA    Y    91_B      Q      94          1.225
LGA    E    92_B      R      95          1.763
LGA    E    93_B      Q      96          1.649
LGA    A    94_B      A      97          1.089
LGA    H    95_B      K      98          1.615
LGA    K    96_B      A      99          1.720
LGA    H    97_B      L     100          1.631
LGA    V    98_B      F     101          1.605
LGA    K    99_B      R     102          1.754
LGA    A   100_B      E     103          1.900
LGA    L   101_B      A     104          1.926
LGA    G   102_B      G     105          3.255
LGA    L   103_B      Y     106          1.930
LGA    E   104_B      S     107          3.523
LGA    -       -      P     108           -
LGA    S   105_B      S     109          2.007
LGA    R   106_B      R     110          1.286
LGA    I   107_B      V     111          1.564
LGA    E   108_B      R     112          1.350
LGA    L   109_B      F     113          1.361
LGA    L   110_B      L     114          1.355
LGA    F   111_B      L     115          1.180
LGA    G   112_B      S     116          1.288
LGA    D   113_B      R     117          1.905
LGA    A   114_B      P     118          2.277
LGA    L   115_B      L     119          2.075
LGA    Q   116_B      D     120          2.098
LGA    L   117_B      V     121          1.479
LGA    G   118_B      M     122          3.110
LGA    E   119_B      S     123          4.114
LGA    K   120_B      R     124          2.683
LGA    L   121_B      L     125          0.951
LGA    E   122_B      A     126          2.113
LGA    L   123_B      -       -           -
LGA    Y   124_B      N     127           #
LGA    P   125_B      D     128           #
LGA    L   126_B      S     129          0.644
LGA    F   127_B      Y     130          0.578
LGA    D   128_B      Q     131          0.912
LGA    V   129_B      L     132          1.174
LGA    L   130_B      V     133          1.526
LGA    F   131_B      F     134          1.350
LGA    I   132_B      G     135          1.232
LGA    D   133_B      Q     136          2.479
LGA    A   134_B      -       -           -
LGA    A   135_B      V     137          4.273
LGA    K   136_B      S     138          2.901
LGA    G   137_B      P     139           #
LGA    -       -      M     140           -
LGA    Q   138_B      D     141          2.211
LGA    Y   139_B      L     142          2.412
LGA    R   140_B      K     143          1.825
LGA    R   141_B      A     144          1.425
LGA    F   142_B      L     145          1.874
LGA    F   143_B      V     146          1.529
LGA    D   144_B      D     147          0.691
LGA    X   145_B      A     148          1.480
LGA    Y   146_B      A     149          2.120
LGA    S   147_B      W     150          1.091
LGA    P   148_B      P     151          0.294
LGA    X   149_B      L     152          0.893
LGA    V   150_B      L     153          0.670
LGA    R   151_B      R     154          0.986
LGA    P   152_B      R     155          1.818
LGA    G   153_B      G     156          2.330
LGA    G   154_B      G     157          1.394
LGA    L   155_B      A     158          1.213
LGA    I   156_B      L     159          1.120
LGA    L   157_B      V     160          1.220
LGA    S   158_B      L     161          1.088
LGA    D   159_B      A     162          1.139
LGA    N   160_B      D     163          0.900
LGA    V   161_B      A     164          2.087
LGA    L   162_B      L     165          2.745
LGA    F   163_B      L     166          3.204
LGA    -       -      D     167           -
LGA    -       -      G     168           -
LGA    -       -      T     169           -
LGA    -       -      I     170           -
LGA    -       -      A     171           -
LGA    -       -      D     172           -
LGA    -       -      Q     173           -
LGA    -       -      T     174           -
LGA    -       -      R     175           -
LGA    -       -      K     176           -
LGA    -       -      D     177           -
LGA    -       -      R     178           -
LGA    -       -      D     179           -
LGA    -       -      T     180           -
LGA    -       -      Q     181           -
LGA    -       -      A     182           -
LGA    -       -      A     183           -
LGA    -       -      R     184           -
LGA    -       -      D     185           -
LGA    -       -      A     186           -
LGA    N   188_B      D     187          1.596
LGA    Q   189_B      E     188          1.226
LGA    W   190_B      Y     189          1.361
LGA    L   191_B      I     190          1.373
LGA    L   192_B      R     191          1.543
LGA    E   193_B      S     192          1.508
LGA    H   194_B      I     193          2.054
LGA    P   195_B      E     194          2.421
LGA    Q   196_B      G     195          3.838
LGA    Y   197_B      A     196          1.666
LGA    D   198_B      H     197          2.040
LGA    T   199_B      V     198          1.045
LGA    R   200_B      A     199          1.889
LGA    I   201_B      R     200          0.457
LGA    F   202_B      L     201          1.519
LGA    P   203_B      P     202          1.665
LGA    V   204_B      L     203          2.539
LGA    G   205_B      G     204          3.068
LGA    D   206_B      A     205          2.679
LGA    G   207_B      G     206          1.980
LGA    I   208_B      L     207          1.727
LGA    A   209_B      T     208          1.295
LGA    I   210_B      V     209          1.725
LGA    S   211_B      V     210          0.844
LGA    I   212_B      T     211          1.718
LGA    K   213_B      K     212          0.997
LGA    R   214_B      A     213          2.982
LGA    E   215_B      -       -           -
LGA    E   226_B      -       -           -
LGA    G   227_B      -       -           -
LGA    H   228_B      -       -           -
LGA    H   229_B      -       -           -
LGA    H   230_B      -       -           -
LGA    H   231_B      -       -           -
LGA    H   232_B      -       -           -
LGA    H   233_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  192  211    5.0    174    2.20    18.97     58.806     7.580

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.905766 * X  +   0.412660 * Y  +   0.096435 * Z  + -48.297215
  Y_new =   0.199483 * X  +  -0.615952 * Y  +   0.762109 * Z  +  29.861027
  Z_new =   0.373891 * X  +  -0.671055 * Y  +  -0.640227 * Z  + 196.155182 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.332689    0.808904  [ DEG:  -133.6532     46.3468 ]
  Theta =  -0.383201   -2.758392  [ DEG:   -21.9558   -158.0442 ]
  Phi   =   0.216776   -2.924816  [ DEG:    12.4204   -167.5796 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gpy_B                                        
REMARK     2: T0509.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gpy_B.T0509.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  192  211   5.0  174   2.20   18.97  58.806
REMARK  ---------------------------------------------------------- 
MOLECULE 2gpy_B
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   18-APR-06   2GPY              
TITLE     CRYSTAL STRUCTURE OF PUTATIVE O-METHYLTRANSFERASE FROM                
TITLE    2 BACILLUS HALODURANS                                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: O-METHYLTRANSFERASE;                                       
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS HALODURANS;                            
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: C-125;                                                       
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE INITIATIVE, NEW           
KEYWDS   2 YORK STRUCTURAL GENOMIX RESEARCH CONSORTIUM, NYSGXRC                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    U.A.RAMAGOPAL,PATSKOVSKY Y.V.,S.C.ALMO,S.K.BURLEY,NEW YORK            
AUTHOR   2 STRUCTURAL GENOMIX RESEARCH CONSORTIUM (NYSGXRC)                     
REVDAT   1   06-JUN-06 2GPY    0                                                
JRNL        AUTH   U.A.RAMAGOPAL,PATSKOVSKY Y.V.,S.C.ALMO                       
JRNL        TITL   CRYSTAL STRUCTURE OF PUTATIVE O-METHYLTRANSFERASE            
JRNL        TITL 2 FROM BACILLUS HALODURANS                                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  2GPY A    4   225  GB     10173888 BAB04991         2    223             
DBREF  2GPY B    4   225  GB     10173888 BAB04991         2    223             
SEQRES   1 A  233  MSE SER LEU ILE GLU GLU ARG LEU LYS HIS TYR LEU GLU          
SEQRES   2 A  233  LYS GLN ILE PRO ALA ARG ASP GLN TYR ILE GLU GLN MSE          
SEQRES   3 A  233  GLU ARG GLU ALA HIS GLU GLN GLN VAL PRO ILE MSE ASP          
SEQRES   4 A  233  LEU LEU GLY MSE GLU SER LEU LEU HIS LEU LEU LYS MSE          
SEQRES   5 A  233  ALA ALA PRO ALA ARG ILE LEU GLU ILE GLY THR ALA ILE          
SEQRES   6 A  233  GLY TYR SER ALA ILE ARG MSE ALA GLN ALA LEU PRO GLU          
SEQRES   7 A  233  ALA THR ILE VAL SER ILE GLU ARG ASP GLU ARG ARG TYR          
SEQRES   8 A  233  GLU GLU ALA HIS LYS HIS VAL LYS ALA LEU GLY LEU GLU          
SEQRES   9 A  233  SER ARG ILE GLU LEU LEU PHE GLY ASP ALA LEU GLN LEU          
SEQRES  10 A  233  GLY GLU LYS LEU GLU LEU TYR PRO LEU PHE ASP VAL LEU          
SEQRES  11 A  233  PHE ILE ASP ALA ALA LYS GLY GLN TYR ARG ARG PHE PHE          
SEQRES  12 A  233  ASP MSE TYR SER PRO MSE VAL ARG PRO GLY GLY LEU ILE          
SEQRES  13 A  233  LEU SER ASP ASN VAL LEU PHE ARG GLY LEU VAL ALA GLU          
SEQRES  14 A  233  THR ASP ILE GLU HIS LYS ARG HIS LYS GLN LEU ALA THR          
SEQRES  15 A  233  LYS ILE ASP THR TYR ASN GLN TRP LEU LEU GLU HIS PRO          
SEQRES  16 A  233  GLN TYR ASP THR ARG ILE PHE PRO VAL GLY ASP GLY ILE          
SEQRES  17 A  233  ALA ILE SER ILE LYS ARG GLU THR LYS GLY ASP THR ASP          
SEQRES  18 A  233  ASP GLU LYS ALA GLU GLY HIS HIS HIS HIS HIS HIS              
SEQRES   1 B  233  MSE SER LEU ILE GLU GLU ARG LEU LYS HIS TYR LEU GLU          
SEQRES   2 B  233  LYS GLN ILE PRO ALA ARG ASP GLN TYR ILE GLU GLN MSE          
SEQRES   3 B  233  GLU ARG GLU ALA HIS GLU GLN GLN VAL PRO ILE MSE ASP          
SEQRES   4 B  233  LEU LEU GLY MSE GLU SER LEU LEU HIS LEU LEU LYS MSE          
SEQRES   5 B  233  ALA ALA PRO ALA ARG ILE LEU GLU ILE GLY THR ALA ILE          
SEQRES   6 B  233  GLY TYR SER ALA ILE ARG MSE ALA GLN ALA LEU PRO GLU          
SEQRES   7 B  233  ALA THR ILE VAL SER ILE GLU ARG ASP GLU ARG ARG TYR          
SEQRES   8 B  233  GLU GLU ALA HIS LYS HIS VAL LYS ALA LEU GLY LEU GLU          
SEQRES   9 B  233  SER ARG ILE GLU LEU LEU PHE GLY ASP ALA LEU GLN LEU          
SEQRES  10 B  233  GLY GLU LYS LEU GLU LEU TYR PRO LEU PHE ASP VAL LEU          
SEQRES  11 B  233  PHE ILE ASP ALA ALA LYS GLY GLN TYR ARG ARG PHE PHE          
SEQRES  12 B  233  ASP MSE TYR SER PRO MSE VAL ARG PRO GLY GLY LEU ILE          
SEQRES  13 B  233  LEU SER ASP ASN VAL LEU PHE ARG GLY LEU VAL ALA GLU          
SEQRES  14 B  233  THR ASP ILE GLU HIS LYS ARG HIS LYS GLN LEU ALA THR          
SEQRES  15 B  233  LYS ILE ASP THR TYR ASN GLN TRP LEU LEU GLU HIS PRO          
SEQRES  16 B  233  GLN TYR ASP THR ARG ILE PHE PRO VAL GLY ASP GLY ILE          
SEQRES  17 B  233  ALA ILE SER ILE LYS ARG GLU THR LYS GLY ASP THR ASP          
SEQRES  18 B  233  ASP GLU LYS ALA GLU GLY HIS HIS HIS HIS HIS HIS              
HET    MSE  A  26       8                                                       
HET    MSE  A  38       8                                                       
HET    MSE  A  43       8                                                       
HET    MSE  A  52      16                                                       
HET    MSE  A  72       8                                                       
HET    MSE  A 145       8                                                       
HET    MSE  A 149       8                                                       
HET    MSE  B  26       8                                                       
HET    MSE  B  38       8                                                       
HET    MSE  B  43       8                                                       
HET    MSE  B  52       8                                                       
HET    MSE  B  72       8                                                       
HET    MSE  B 145       8                                                       
HET    MSE  B 149       8                                                       
HET     MG    301       1                                                       
HET     ZN    302       1                                                       
HET     ZN    303       1                                                       
HET     ZN    304       1                                                       
HET     ZN    305       1                                                       
HET     ZN    306       1                                                       
HET     ZN    307       1                                                       
HET     ZN    308       1                                                       
HET     ZN    309       1                                                       
HET     ZN    310       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      MG MAGNESIUM ION                                                    
HETNAM      ZN ZINC ION                                                         
FORMUL   1  MSE    14(C5 H11 N O2 SE)                                           
FORMUL   3   MG    MG 2+                                                        
FORMUL   4   ZN    9(ZN 2+)                                                     
FORMUL  13  HOH   *179(H2 O)                                                    
CRYST1   50.567   62.807  137.746  90.00  90.00  90.00 P 21 21 21    8          
ATOM   1595  N   LEU B   8      19.726  34.831 186.563  1.00 72.92           N  
ATOM   1596  CA  LEU B   8      18.327  34.496 186.143  1.00 73.03           C  
ATOM   1597  C   LEU B   8      18.207  34.341 184.624  1.00 73.02           C  
ATOM   1598  O   LEU B   8      17.818  33.280 184.134  1.00 72.84           O  
ATOM   1599  CB  LEU B   8      17.323  35.547 186.659  1.00 73.06           C  
ATOM   1600  CG  LEU B   8      15.886  35.584 186.095  1.00 73.11           C  
ATOM   1601  CD1 LEU B   8      15.142  34.257 186.274  1.00 72.63           C  
ATOM   1602  CD2 LEU B   8      15.079  36.742 186.697  1.00 73.14           C  
ATOM   1603  N   LYS B   9      18.536  35.398 183.886  1.00 72.94           N  
ATOM   1604  CA  LYS B   9      18.409  35.360 182.430  1.00 73.14           C  
ATOM   1605  C   LYS B   9      19.456  34.433 181.800  1.00 72.87           C  
ATOM   1606  O   LYS B   9      19.258  33.926 180.698  1.00 72.83           O  
ATOM   1607  CB  LYS B   9      18.424  36.776 181.828  1.00 73.38           C  
ATOM   1608  CG  LYS B   9      19.787  37.458 181.732  1.00 74.07           C  
ATOM   1609  CD  LYS B   9      20.465  37.208 180.375  1.00 75.64           C  
ATOM   1610  CE  LYS B   9      19.624  37.694 179.190  1.00 75.88           C  
ATOM   1611  NZ  LYS B   9      20.323  37.468 177.897  1.00 75.82           N  
ATOM   1612  N   HIS B  10      20.556  34.213 182.520  1.00 72.50           N  
ATOM   1613  CA  HIS B  10      21.562  33.225 182.144  1.00 72.19           C  
ATOM   1614  C   HIS B  10      21.041  31.800 182.375  1.00 71.53           C  
ATOM   1615  O   HIS B  10      21.332  30.892 181.594  1.00 71.31           O  
ATOM   1616  CB  HIS B  10      22.853  33.466 182.936  1.00 72.53           C  
ATOM   1617  CG  HIS B  10      24.074  32.870 182.306  1.00 73.64           C  
ATOM   1618  ND1 HIS B  10      24.858  33.559 181.403  1.00 74.70           N  
ATOM   1619  CD2 HIS B  10      24.652  31.655 182.455  1.00 74.70           C  
ATOM   1620  CE1 HIS B  10      25.861  32.791 181.019  1.00 75.32           C  
ATOM   1621  NE2 HIS B  10      25.761  31.631 181.644  1.00 75.29           N  
ATOM   1622  N   TYR B  11      20.276  31.616 183.452  1.00 70.82           N  
ATOM   1623  CA  TYR B  11      19.641  30.330 183.762  1.00 70.12           C  
ATOM   1624  C   TYR B  11      18.587  29.973 182.713  1.00 69.55           C  
ATOM   1625  O   TYR B  11      18.519  28.828 182.254  1.00 69.48           O  
ATOM   1626  CB  TYR B  11      19.009  30.345 185.170  1.00 70.25           C  
ATOM   1627  CG  TYR B  11      18.135  29.134 185.451  1.00 70.28           C  
ATOM   1628  CD1 TYR B  11      16.775  29.130 185.107  1.00 69.63           C  
ATOM   1629  CD2 TYR B  11      18.672  27.982 186.036  1.00 70.15           C  
ATOM   1630  CE1 TYR B  11      15.976  28.014 185.345  1.00 69.74           C  
ATOM   1631  CE2 TYR B  11      17.876  26.861 186.280  1.00 69.75           C  
ATOM   1632  CZ  TYR B  11      16.534  26.886 185.937  1.00 70.13           C  
ATOM   1633  OH  TYR B  11      15.750  25.781 186.179  1.00 70.34           O  
ATOM   1634  N   LEU B  12      17.765  30.961 182.356  1.00 68.85           N  
ATOM   1635  CA  LEU B  12      16.739  30.808 181.321  1.00 68.37           C  
ATOM   1636  C   LEU B  12      17.351  30.493 179.950  1.00 68.03           C  
ATOM   1637  O   LEU B  12      16.761  29.740 179.173  1.00 67.96           O  
ATOM   1638  CB  LEU B  12      15.845  32.058 181.240  1.00 68.34           C  
ATOM   1639  CG  LEU B  12      15.045  32.423 182.502  1.00 68.44           C  
ATOM   1640  CD1 LEU B  12      14.620  33.893 182.505  1.00 69.21           C  
ATOM   1641  CD2 LEU B  12      13.842  31.498 182.708  1.00 68.35           C  
ATOM   1642  N   GLU B  13      18.530  31.062 179.676  1.00 67.14           N  
ATOM   1643  CA  GLU B  13      19.293  30.806 178.446  1.00 66.51           C  
ATOM   1644  C   GLU B  13      19.560  29.324 178.204  1.00 65.40           C  
ATOM   1645  O   GLU B  13      19.607  28.872 177.059  1.00 65.46           O  
ATOM   1646  CB  GLU B  13      20.656  31.509 178.498  1.00 66.65           C  
ATOM   1647  CG  GLU B  13      20.644  33.009 178.291  1.00 67.22           C  
ATOM   1648  CD  GLU B  13      22.002  33.648 178.580  1.00 67.61           C  
ATOM   1649  OE1 GLU B  13      23.004  32.899 178.711  1.00 68.50           O  
ATOM   1650  OE2 GLU B  13      22.062  34.897 178.675  1.00 68.47           O  
ATOM   1651  N   LYS B  14      19.752  28.579 179.289  1.00 64.21           N  
ATOM   1652  CA  LYS B  14      20.167  27.182 179.207  1.00 63.07           C  
ATOM   1653  C   LYS B  14      19.035  26.169 179.375  1.00 61.77           C  
ATOM   1654  O   LYS B  14      19.283  24.965 179.339  1.00 61.60           O  
ATOM   1655  CB  LYS B  14      21.273  26.896 180.237  1.00 63.39           C  
ATOM   1656  CG  LYS B  14      22.683  27.245 179.777  1.00 64.29           C  
ATOM   1657  CD  LYS B  14      23.330  26.106 178.975  1.00 65.85           C  
ATOM   1658  CE  LYS B  14      23.073  26.241 177.470  1.00 66.30           C  
ATOM   1659  NZ  LYS B  14      23.516  25.042 176.712  1.00 66.63           N  
ATOM   1660  N   GLN B  15      17.808  26.657 179.554  1.00 60.41           N  
ATOM   1661  CA  GLN B  15      16.668  25.793 179.876  1.00 58.42           C  
ATOM   1662  C   GLN B  15      16.171  24.976 178.668  1.00 58.87           C  
ATOM   1663  O   GLN B  15      15.111  25.271 178.097  1.00 58.72           O  
ATOM   1664  CB  GLN B  15      15.526  26.620 180.492  1.00 58.46           C  
ATOM   1665  CG  GLN B  15      14.525  25.786 181.298  1.00 56.11           C  
ATOM   1666  CD  GLN B  15      13.343  26.590 181.844  1.00 55.63           C  
ATOM   1667  OE1 GLN B  15      12.631  26.120 182.727  1.00 48.05           O  
ATOM   1668  NE2 GLN B  15      13.123  27.790 181.308  1.00 51.97           N  
ATOM   1669  N   ILE B  16      16.933  23.944 178.294  1.00 58.47           N  
ATOM   1670  CA  ILE B  16      16.665  23.156 177.078  1.00 58.07           C  
ATOM   1671  C   ILE B  16      16.986  21.667 177.277  1.00 57.18           C  
ATOM   1672  O   ILE B  16      18.137  21.320 177.534  1.00 57.83           O  
ATOM   1673  CB  ILE B  16      17.472  23.693 175.853  1.00 58.11           C  
ATOM   1674  CG1 ILE B  16      18.986  23.732 176.142  1.00 59.16           C  
ATOM   1675  CG2 ILE B  16      16.986  25.080 175.446  1.00 58.34           C  
ATOM   1676  CD1 ILE B  16      19.866  24.133 174.936  1.00 58.76           C  
ATOM   1677  N   PRO B  17      15.973  20.784 177.177  1.00 56.07           N  
ATOM   1678  CA  PRO B  17      16.218  19.334 177.146  1.00 55.01           C  
ATOM   1679  C   PRO B  17      16.508  18.793 175.741  1.00 53.99           C  
ATOM   1680  O   PRO B  17      16.014  19.342 174.759  1.00 53.19           O  
ATOM   1681  CB  PRO B  17      14.898  18.739 177.643  1.00 55.20           C  
ATOM   1682  CG  PRO B  17      13.884  19.838 177.551  1.00 55.19           C  
ATOM   1683  CD  PRO B  17      14.539  21.103 177.105  1.00 55.83           C  
ATOM   1684  N   ALA B  18      17.286  17.710 175.661  1.00 52.74           N  
ATOM   1685  CA  ALA B  18      17.588  17.062 174.373  1.00 51.53           C  
ATOM   1686  C   ALA B  18      16.331  16.596 173.629  1.00 50.37           C  
ATOM   1687  O   ALA B  18      15.355  16.127 174.234  1.00 49.82           O  
ATOM   1688  CB  ALA B  18      18.556  15.895 174.560  1.00 52.14           C  
ATOM   1689  N   ARG B  19      16.352  16.763 172.312  1.00 49.01           N  
ATOM   1690  CA  ARG B  19      15.257  16.304 171.477  1.00 47.73           C  
ATOM   1691  C   ARG B  19      15.636  14.903 170.971  1.00 46.94           C  
ATOM   1692  O   ARG B  19      16.775  14.473 171.135  1.00 46.43           O  
ATOM   1693  CB  ARG B  19      15.013  17.286 170.316  1.00 47.56           C  
ATOM   1694  CG  ARG B  19      14.204  18.586 170.640  1.00 45.37           C  
ATOM   1695  CD  ARG B  19      15.017  19.633 171.396  1.00 42.51           C  
ATOM   1696  NE  ARG B  19      16.172  20.107 170.629  1.00 40.42           N  
ATOM   1697  CZ  ARG B  19      17.368  20.387 171.144  1.00 42.05           C  
ATOM   1698  NH1 ARG B  19      17.600  20.237 172.447  1.00 40.75           N  
ATOM   1699  NH2 ARG B  19      18.348  20.802 170.349  1.00 41.09           N  
ATOM   1700  N   ASP B  20      14.678  14.184 170.401  1.00 46.64           N  
ATOM   1701  CA  ASP B  20      14.967  12.957 169.647  1.00 46.76           C  
ATOM   1702  C   ASP B  20      16.053  13.268 168.611  1.00 45.58           C  
ATOM   1703  O   ASP B  20      16.046  14.349 168.007  1.00 45.31           O  
ATOM   1704  CB  ASP B  20      13.667  12.451 168.991  1.00 47.63           C  
ATOM   1705  CG  ASP B  20      13.898  11.443 167.847  1.00 50.58           C  
ATOM   1706  OD1 ASP B  20      14.895  10.683 167.837  1.00 55.48           O  
ATOM   1707  OD2 ASP B  20      13.042  11.408 166.939  1.00 55.30           O  
ATOM   1708  N   GLN B  21      16.997  12.347 168.409  1.00 44.14           N  
ATOM   1709  CA  GLN B  21      18.094  12.609 167.463  1.00 43.20           C  
ATOM   1710  C   GLN B  21      17.569  13.098 166.092  1.00 42.04           C  
ATOM   1711  O   GLN B  21      18.208  13.935 165.412  1.00 40.97           O  
ATOM   1712  CB  GLN B  21      19.038  11.388 167.340  1.00 43.65           C  
ATOM   1713  CG  GLN B  21      18.693  10.370 166.239  1.00 45.64           C  
ATOM   1714  CD  GLN B  21      19.607   9.116 166.203  1.00 44.96           C  
ATOM   1715  OE1 GLN B  21      20.821   9.226 166.029  1.00 50.24           O  
ATOM   1716  NE2 GLN B  21      19.005   7.922 166.324  1.00 43.21           N  
ATOM   1717  N   TYR B  22      16.411  12.585 165.682  1.00 40.30           N  
ATOM   1718  CA  TYR B  22      15.862  12.929 164.348  1.00 39.41           C  
ATOM   1719  C   TYR B  22      15.475  14.400 164.275  1.00 39.13           C  
ATOM   1720  O   TYR B  22      15.671  15.039 163.237  1.00 38.97           O  
ATOM   1721  CB  TYR B  22      14.648  12.074 163.998  1.00 37.50           C  
ATOM   1722  CG  TYR B  22      14.211  12.163 162.538  1.00 37.06           C  
ATOM   1723  CD1 TYR B  22      14.757  11.309 161.572  1.00 37.19           C  
ATOM   1724  CD2 TYR B  22      13.234  13.079 162.131  1.00 36.58           C  
ATOM   1725  CE1 TYR B  22      14.356  11.370 160.225  1.00 37.97           C  
ATOM   1726  CE2 TYR B  22      12.808  13.137 160.801  1.00 36.28           C  
ATOM   1727  CZ  TYR B  22      13.390  12.289 159.853  1.00 37.14           C  
ATOM   1728  OH  TYR B  22      13.008  12.315 158.540  1.00 36.35           O  
ATOM   1729  N   ILE B  23      14.887  14.895 165.368  1.00 40.14           N  
ATOM   1730  CA  ILE B  23      14.517  16.313 165.571  1.00 40.23           C  
ATOM   1731  C   ILE B  23      15.769  17.191 165.601  1.00 40.94           C  
ATOM   1732  O   ILE B  23      15.813  18.221 164.937  1.00 40.17           O  
ATOM   1733  CB  ILE B  23      13.723  16.460 166.874  1.00 40.94           C  
ATOM   1734  CG1 ILE B  23      12.568  15.444 166.901  1.00 43.18           C  
ATOM   1735  CG2 ILE B  23      13.195  17.916 167.096  1.00 39.19           C  
ATOM   1736  CD1 ILE B  23      11.373  15.875 166.151  1.00 41.20           C  
ATOM   1737  N   GLU B  24      16.798  16.758 166.341  1.00 40.30           N  
ATOM   1738  CA  GLU B  24      18.070  17.472 166.366  1.00 41.30           C  
ATOM   1739  C   GLU B  24      18.697  17.573 164.977  1.00 41.04           C  
ATOM   1740  O   GLU B  24      19.293  18.596 164.641  1.00 41.38           O  
ATOM   1741  CB  GLU B  24      19.044  16.844 167.374  1.00 41.28           C  
ATOM   1742  CG  GLU B  24      18.466  16.888 168.782  1.00 44.13           C  
ATOM   1743  CD  GLU B  24      19.496  16.837 169.883  1.00 47.04           C  
ATOM   1744  OE1 GLU B  24      20.506  16.139 169.740  1.00 47.36           O  
ATOM   1745  OE2 GLU B  24      19.266  17.494 170.918  1.00 51.35           O  
ATOM   1746  N   GLN B  25      18.549  16.511 164.180  1.00 41.13           N  
ATOM   1747  CA  GLN B  25      19.027  16.480 162.814  1.00 41.38           C  
ATOM   1748  C   GLN B  25      18.235  17.442 161.928  1.00 40.89           C  
ATOM   1749  O   GLN B  25      18.801  18.053 161.010  1.00 40.01           O  
ATOM   1750  CB  GLN B  25      18.956  15.050 162.260  1.00 42.29           C  
ATOM   1751  CG  GLN B  25      19.522  14.852 160.834  1.00 45.97           C  
ATOM   1752  CD  GLN B  25      21.051  14.991 160.735  1.00 50.68           C  
ATOM   1753  OE1 GLN B  25      21.781  14.825 161.717  1.00 52.74           O  
ATOM   1754  NE2 GLN B  25      21.537  15.284 159.530  1.00 53.96           N  
HETATM 1755  N   MSE B  26      16.937  17.563 162.184  1.00 39.97           N  
HETATM 1756  CA  MSE B  26      16.094  18.554 161.470  1.00 39.88           C  
HETATM 1757  C   MSE B  26      16.524  19.992 161.773  1.00 39.53           C  
HETATM 1758  O   MSE B  26      16.534  20.852 160.882  1.00 38.93           O  
HETATM 1759  CB  MSE B  26      14.610  18.366 161.806  1.00 39.23           C  
HETATM 1760  CG  MSE B  26      13.964  17.167 161.111  1.00 40.22           C  
HETATM 1761 SE   MSE B  26      12.114  16.945 161.717  1.00 42.78          SE  
HETATM 1762  CE  MSE B  26      11.379  18.454 160.908  1.00 39.71           C  
ATOM   1763  N   GLU B  27      16.884  20.247 163.028  1.00 39.92           N  
ATOM   1764  CA  GLU B  27      17.362  21.571 163.434  1.00 40.02           C  
ATOM   1765  C   GLU B  27      18.653  21.955 162.736  1.00 40.41           C  
ATOM   1766  O   GLU B  27      18.759  23.067 162.216  1.00 40.42           O  
ATOM   1767  CB  GLU B  27      17.564  21.650 164.940  1.00 39.89           C  
ATOM   1768  CG  GLU B  27      16.269  21.450 165.709  1.00 38.62           C  
ATOM   1769  CD  GLU B  27      16.521  21.132 167.152  1.00 39.76           C  
ATOM   1770  OE1 GLU B  27      17.696  20.874 167.504  1.00 40.54           O  
ATOM   1771  OE2 GLU B  27      15.560  21.124 167.926  1.00 41.78           O  
ATOM   1772  N   ARG B  28      19.636  21.055 162.749  1.00 40.81           N  
ATOM   1773  CA  ARG B  28      20.908  21.300 162.068  1.00 41.79           C  
ATOM   1774  C   ARG B  28      20.699  21.450 160.566  1.00 41.09           C  
ATOM   1775  O   ARG B  28      21.341  22.284 159.926  1.00 41.11           O  
ATOM   1776  CB  ARG B  28      21.929  20.195 162.359  1.00 41.87           C  
ATOM   1777  CG  ARG B  28      22.552  20.279 163.760  1.00 43.47           C  
ATOM   1778  CD  ARG B  28      23.766  19.327 163.876  1.00 44.13           C  
ATOM   1779  NE  ARG B  28      23.395  17.945 163.543  1.00 49.86           N  
ATOM   1780  CZ  ARG B  28      22.803  17.092 164.384  1.00 51.40           C  
ATOM   1781  NH1 ARG B  28      22.514  17.454 165.632  1.00 51.85           N  
ATOM   1782  NH2 ARG B  28      22.495  15.867 163.973  1.00 52.51           N  
ATOM   1783  N   GLU B  29      19.780  20.664 160.015  1.00 40.60           N  
ATOM   1784  CA  GLU B  29      19.429  20.744 158.600  1.00 41.18           C  
ATOM   1785  C   GLU B  29      18.805  22.083 158.184  1.00 40.53           C  
ATOM   1786  O   GLU B  29      19.136  22.637 157.128  1.00 41.07           O  
ATOM   1787  CB  GLU B  29      18.444  19.645 158.245  1.00 41.33           C  
ATOM   1788  CG  GLU B  29      18.215  19.539 156.759  1.00 44.88           C  
ATOM   1789  CD  GLU B  29      16.890  18.902 156.393  1.00 48.45           C  
ATOM   1790  OE1 GLU B  29      16.533  17.820 156.918  1.00 50.24           O  
ATOM   1791  OE2 GLU B  29      16.210  19.494 155.544  1.00 49.42           O  
ATOM   1792  N   ALA B  30      17.876  22.571 158.992  1.00 40.53           N  
ATOM   1793  CA  ALA B  30      17.253  23.864 158.766  1.00 39.62           C  
ATOM   1794  C   ALA B  30      18.333  24.932 158.743  1.00 39.83           C  
ATOM   1795  O   ALA B  30      18.312  25.808 157.865  1.00 38.37           O  
ATOM   1796  CB  ALA B  30      16.233  24.159 159.860  1.00 40.16           C  
ATOM   1797  N   HIS B  31      19.257  24.866 159.709  1.00 40.00           N  
ATOM   1798  CA  HIS B  31      20.370  25.832 159.793  1.00 40.91           C  
ATOM   1799  C   HIS B  31      21.298  25.754 158.587  1.00 41.81           C  
ATOM   1800  O   HIS B  31      21.540  26.767 157.932  1.00 42.53           O  
ATOM   1801  CB  HIS B  31      21.161  25.716 161.114  1.00 40.55           C  
ATOM   1802  CG  HIS B  31      22.436  26.514 161.126  1.00 41.17           C  
ATOM   1803  ND1 HIS B  31      23.675  25.928 160.983  1.00 40.52           N  
ATOM   1804  CD2 HIS B  31      22.664  27.846 161.237  1.00 39.91           C  
ATOM   1805  CE1 HIS B  31      24.612  26.861 161.004  1.00 41.01           C  
ATOM   1806  NE2 HIS B  31      24.025  28.034 161.152  1.00 41.35           N  
ATOM   1807  N   GLU B  32      21.802  24.558 158.282  1.00 42.93           N  
ATOM   1808  CA  GLU B  32      22.718  24.369 157.159  1.00 43.69           C  
ATOM   1809  C   GLU B  32      22.087  24.741 155.814  1.00 43.35           C  
ATOM   1810  O   GLU B  32      22.790  25.213 154.902  1.00 43.28           O  
ATOM   1811  CB  GLU B  32      23.280  22.940 157.123  1.00 44.62           C  
ATOM   1812  CG  GLU B  32      22.256  21.882 156.739  1.00 48.25           C  
ATOM   1813  CD  GLU B  32      22.823  20.706 155.953  1.00 53.25           C  
ATOM   1814  OE1 GLU B  32      24.058  20.592 155.841  1.00 56.14           O  
ATOM   1815  OE2 GLU B  32      22.018  19.890 155.439  1.00 56.18           O  
ATOM   1816  N   GLN B  33      20.778  24.536 155.699  1.00 43.26           N  
ATOM   1817  CA  GLN B  33      20.044  24.802 154.459  1.00 43.76           C  
ATOM   1818  C   GLN B  33      19.241  26.117 154.484  1.00 43.59           C  
ATOM   1819  O   GLN B  33      18.512  26.422 153.529  1.00 44.03           O  
ATOM   1820  CB  GLN B  33      19.139  23.613 154.099  1.00 43.72           C  
ATOM   1821  CG  GLN B  33      19.834  22.233 154.089  1.00 46.13           C  
ATOM   1822  CD  GLN B  33      20.697  21.955 152.850  1.00 51.30           C  
ATOM   1823  OE1 GLN B  33      21.857  21.515 152.963  1.00 53.42           O  
ATOM   1824  NE2 GLN B  33      20.128  22.179 151.666  1.00 51.72           N  
ATOM   1825  N   GLN B  34      19.377  26.883 155.574  1.00 42.65           N  
ATOM   1826  CA  GLN B  34      18.695  28.176 155.763  1.00 42.96           C  
ATOM   1827  C   GLN B  34      17.173  28.142 155.497  1.00 43.16           C  
ATOM   1828  O   GLN B  34      16.611  28.942 154.747  1.00 42.25           O  
ATOM   1829  CB  GLN B  34      19.429  29.315 155.023  1.00 43.68           C  
ATOM   1830  CG  GLN B  34      20.808  29.632 155.650  1.00 45.63           C  
ATOM   1831  CD  GLN B  34      20.678  30.167 157.086  1.00 49.58           C  
ATOM   1832  OE1 GLN B  34      20.910  29.451 158.067  1.00 49.88           O  
ATOM   1833  NE2 GLN B  34      20.276  31.424 157.205  1.00 51.78           N  
ATOM   1834  N   VAL B  35      16.521  27.180 156.141  1.00 43.02           N  
ATOM   1835  CA  VAL B  35      15.085  27.052 156.101  1.00 43.77           C  
ATOM   1836  C   VAL B  35      14.557  27.677 157.398  1.00 44.09           C  
ATOM   1837  O   VAL B  35      15.066  27.349 158.470  1.00 42.94           O  
ATOM   1838  CB  VAL B  35      14.674  25.562 156.031  1.00 43.45           C  
ATOM   1839  CG1 VAL B  35      13.193  25.402 156.227  1.00 45.83           C  
ATOM   1840  CG2 VAL B  35      15.108  24.950 154.696  1.00 44.75           C  
ATOM   1841  N   PRO B  36      13.532  28.561 157.302  1.00 44.98           N  
ATOM   1842  CA  PRO B  36      12.872  29.146 158.475  1.00 45.84           C  
ATOM   1843  C   PRO B  36      12.520  28.119 159.541  1.00 45.51           C  
ATOM   1844  O   PRO B  36      11.874  27.128 159.234  1.00 46.30           O  
ATOM   1845  CB  PRO B  36      11.556  29.692 157.890  1.00 46.69           C  
ATOM   1846  CG  PRO B  36      11.942  30.115 156.504  1.00 46.05           C  
ATOM   1847  CD  PRO B  36      12.929  29.054 156.046  1.00 45.22           C  
ATOM   1848  N   ILE B  37      12.975  28.343 160.766  1.00 45.40           N  
ATOM   1849  CA  ILE B  37      12.694  27.443 161.881  1.00 45.43           C  
ATOM   1850  C   ILE B  37      12.571  28.306 163.114  1.00 45.56           C  
ATOM   1851  O   ILE B  37      13.295  29.295 163.239  1.00 45.59           O  
ATOM   1852  CB  ILE B  37      13.830  26.383 162.065  1.00 46.03           C  
ATOM   1853  CG1 ILE B  37      13.492  25.374 163.149  1.00 46.67           C  
ATOM   1854  CG2 ILE B  37      15.182  27.034 162.354  1.00 46.07           C  
ATOM   1855  CD1 ILE B  37      14.428  24.144 163.163  1.00 45.27           C  
HETATM 1856  N   MSE B  38      11.636  27.965 164.003  1.00 44.86           N  
HETATM 1857  CA  MSE B  38      11.543  28.668 165.275  1.00 45.38           C  
HETATM 1858  C   MSE B  38      12.758  28.381 166.117  1.00 44.38           C  
HETATM 1859  O   MSE B  38      13.219  27.236 166.210  1.00 44.67           O  
HETATM 1860  CB  MSE B  38      10.275  28.260 166.052  1.00 45.00           C  
HETATM 1861  CG  MSE B  38       9.891  29.276 167.071  1.00 45.43           C  
HETATM 1862 SE   MSE B  38       8.172  28.772 167.827  1.00 49.41          SE  
HETATM 1863  CE  MSE B  38       8.003  30.349 168.868  1.00 49.59           C  
ATOM   1864  N   ASP B  39      13.289  29.433 166.731  1.00 44.05           N  
ATOM   1865  CA  ASP B  39      14.445  29.310 167.592  1.00 42.82           C  
ATOM   1866  C   ASP B  39      14.109  28.406 168.757  1.00 42.64           C  
ATOM   1867  O   ASP B  39      12.948  28.303 169.169  1.00 41.75           O  
ATOM   1868  CB  ASP B  39      14.900  30.678 168.098  1.00 42.96           C  
ATOM   1869  CG  ASP B  39      13.953  31.273 169.113  1.00 42.83           C  
ATOM   1870  OD1 ASP B  39      12.883  31.802 168.718  1.00 44.26           O  
ATOM   1871  OD2 ASP B  39      14.294  31.223 170.322  1.00 42.39           O  
ATOM   1872  N   LEU B  40      15.129  27.743 169.284  1.00 41.77           N  
ATOM   1873  CA  LEU B  40      14.903  26.684 170.253  1.00 41.67           C  
ATOM   1874  C   LEU B  40      14.234  27.143 171.560  1.00 41.13           C  
ATOM   1875  O   LEU B  40      13.328  26.469 172.064  1.00 40.03           O  
ATOM   1876  CB  LEU B  40      16.237  26.007 170.556  1.00 41.90           C  
ATOM   1877  CG  LEU B  40      16.254  24.621 171.188  1.00 44.58           C  
ATOM   1878  CD1 LEU B  40      17.675  24.047 171.100  1.00 48.56           C  
ATOM   1879  CD2 LEU B  40      15.818  24.670 172.606  1.00 50.05           C  
ATOM   1880  N   LEU B  41      14.722  28.236 172.146  1.00 40.32           N  
ATOM   1881  CA  LEU B  41      14.093  28.755 173.366  1.00 41.01           C  
ATOM   1882  C   LEU B  41      12.667  29.214 173.204  1.00 40.82           C  
ATOM   1883  O   LEU B  41      11.852  28.928 174.069  1.00 42.16           O  
ATOM   1884  CB  LEU B  41      14.943  29.813 174.067  1.00 42.10           C  
ATOM   1885  CG  LEU B  41      15.270  29.246 175.466  1.00 44.61           C  
ATOM   1886  CD1 LEU B  41      16.637  28.658 175.541  1.00 47.61           C  
ATOM   1887  CD2 LEU B  41      15.114  30.305 176.521  1.00 47.84           C  
ATOM   1888  N   GLY B  42      12.353  29.898 172.106  1.00 40.11           N  
ATOM   1889  CA  GLY B  42      10.959  30.245 171.785  1.00 40.11           C  
ATOM   1890  C   GLY B  42      10.087  29.005 171.614  1.00 41.12           C  
ATOM   1891  O   GLY B  42       8.915  28.981 172.022  1.00 40.61           O  
HETATM 1892  N   MSE B  43      10.650  27.985 170.967  1.00 40.07           N  
HETATM 1893  CA  MSE B  43       9.890  26.771 170.680  1.00 39.88           C  
HETATM 1894  C   MSE B  43       9.544  26.075 171.993  1.00 39.20           C  
HETATM 1895  O   MSE B  43       8.418  25.622 172.184  1.00 37.92           O  
HETATM 1896  CB  MSE B  43      10.682  25.825 169.739  1.00 40.01           C  
HETATM 1897  CG  MSE B  43      10.008  24.451 169.648  1.00 42.60           C  
HETATM 1898 SE   MSE B  43       8.303  24.628 168.698  1.00 58.52          SE  
HETATM 1899  CE  MSE B  43       8.882  24.658 167.449  1.00 20.82           C  
ATOM   1900  N   GLU B  44      10.520  25.952 172.891  1.00 39.07           N  
ATOM   1901  CA  GLU B  44      10.266  25.253 174.151  1.00 40.93           C  
ATOM   1902  C   GLU B  44       9.189  25.985 174.959  1.00 40.73           C  
ATOM   1903  O   GLU B  44       8.304  25.362 175.564  1.00 39.25           O  
ATOM   1904  CB  GLU B  44      11.551  25.104 174.966  1.00 41.07           C  
ATOM   1905  CG  GLU B  44      12.573  24.166 174.297  1.00 45.31           C  
ATOM   1906  CD  GLU B  44      12.114  22.691 174.246  1.00 48.82           C  
ATOM   1907  OE1 GLU B  44      11.304  22.267 175.098  1.00 49.30           O  
ATOM   1908  OE2 GLU B  44      12.578  21.956 173.351  1.00 50.87           O  
ATOM   1909  N   SER B  45       9.291  27.308 174.980  1.00 40.61           N  
ATOM   1910  CA  SER B  45       8.274  28.124 175.660  1.00 40.62           C  
ATOM   1911  C   SER B  45       6.920  28.000 175.025  1.00 40.47           C  
ATOM   1912  O   SER B  45       5.914  27.837 175.741  1.00 40.51           O  
ATOM   1913  CB  SER B  45       8.708  29.589 175.728  1.00 41.77           C  
ATOM   1914  OG  SER B  45       9.710  29.695 176.707  1.00 43.02           O  
ATOM   1915  N   LEU B  46       6.870  28.051 173.697  1.00 39.91           N  
ATOM   1916  CA  LEU B  46       5.606  27.893 172.994  1.00 40.66           C  
ATOM   1917  C   LEU B  46       4.958  26.555 173.297  1.00 39.94           C  
ATOM   1918  O   LEU B  46       3.750  26.484 173.520  1.00 40.69           O  
ATOM   1919  CB  LEU B  46       5.756  28.051 171.474  1.00 41.47           C  
ATOM   1920  CG  LEU B  46       4.416  28.160 170.736  1.00 45.12           C  
ATOM   1921  CD1 LEU B  46       3.741  29.488 171.144  1.00 51.66           C  
ATOM   1922  CD2 LEU B  46       4.545  28.051 169.244  1.00 50.94           C  
ATOM   1923  N   LEU B  47       5.743  25.484 173.263  1.00 37.49           N  
ATOM   1924  CA  LEU B  47       5.167  24.156 173.484  1.00 36.91           C  
ATOM   1925  C   LEU B  47       4.599  24.070 174.904  1.00 37.30           C  
ATOM   1926  O   LEU B  47       3.531  23.477 175.157  1.00 38.10           O  
ATOM   1927  CB  LEU B  47       6.260  23.102 173.297  1.00 36.15           C  
ATOM   1928  CG  LEU B  47       6.738  22.985 171.843  1.00 34.41           C  
ATOM   1929  CD1 LEU B  47       7.891  22.006 171.864  1.00 37.27           C  
ATOM   1930  CD2 LEU B  47       5.594  22.492 170.911  1.00 38.11           C  
ATOM   1931  N   HIS B  48       5.307  24.661 175.852  1.00 37.14           N  
ATOM   1932  CA  HIS B  48       4.812  24.642 177.245  1.00 38.15           C  
ATOM   1933  C   HIS B  48       3.490  25.419 177.395  1.00 39.05           C  
ATOM   1934  O   HIS B  48       2.555  24.987 178.113  1.00 39.08           O  
ATOM   1935  CB  HIS B  48       5.869  25.184 178.190  1.00 38.46           C  
ATOM   1936  CG  HIS B  48       5.690  24.722 179.609  1.00 37.50           C  
ATOM   1937  ND1 HIS B  48       5.912  23.422 179.985  1.00 38.79           N  
ATOM   1938  CD2 HIS B  48       5.277  25.372 180.721  1.00 37.41           C  
ATOM   1939  CE1 HIS B  48       5.658  23.286 181.277  1.00 38.35           C  
ATOM   1940  NE2 HIS B  48       5.282  24.458 181.749  1.00 36.33           N  
ATOM   1941  N   LEU B  49       3.411  26.575 176.750  1.00 38.43           N  
ATOM   1942  CA  LEU B  49       2.180  27.375 176.778  1.00 39.99           C  
ATOM   1943  C   LEU B  49       1.032  26.615 176.100  1.00 39.69           C  
ATOM   1944  O   LEU B  49      -0.112  26.632 176.570  1.00 39.15           O  
ATOM   1945  CB  LEU B  49       2.403  28.717 176.097  1.00 40.79           C  
ATOM   1946  CG  LEU B  49       3.403  29.684 176.771  1.00 41.63           C  
ATOM   1947  CD1 LEU B  49       3.690  30.818 175.794  1.00 45.68           C  
ATOM   1948  CD2 LEU B  49       2.922  30.207 178.099  1.00 45.46           C  
ATOM   1949  N   LEU B  50       1.334  25.929 175.009  1.00 38.96           N  
ATOM   1950  CA  LEU B  50       0.329  25.082 174.371  1.00 39.62           C  
ATOM   1951  C   LEU B  50      -0.157  23.980 175.307  1.00 39.77           C  
ATOM   1952  O   LEU B  50      -1.356  23.724 175.373  1.00 40.64           O  
ATOM   1953  CB  LEU B  50       0.850  24.481 173.061  1.00 39.18           C  
ATOM   1954  CG  LEU B  50       1.028  25.424 171.872  1.00 41.59           C  
ATOM   1955  CD1 LEU B  50       1.900  24.768 170.794  1.00 45.76           C  
ATOM   1956  CD2 LEU B  50      -0.315  25.854 171.285  1.00 43.18           C  
ATOM   1957  N   LYS B  51       0.755  23.296 176.010  1.00 38.88           N  
ATOM   1958  CA  LYS B  51       0.353  22.230 176.911  1.00 39.86           C  
ATOM   1959  C   LYS B  51      -0.578  22.774 177.975  1.00 40.29           C  
ATOM   1960  O   LYS B  51      -1.515  22.081 178.422  1.00 40.05           O  
ATOM   1961  CB  LYS B  51       1.558  21.560 177.592  1.00 39.08           C  
ATOM   1962  CG  LYS B  51       2.426  20.706 176.655  1.00 42.58           C  
ATOM   1963  CD  LYS B  51       3.533  20.088 177.480  1.00 44.74           C  
ATOM   1964  CE  LYS B  51       4.789  19.919 176.685  1.00 47.82           C  
ATOM   1965  NZ  LYS B  51       5.808  19.174 177.553  1.00 49.14           N  
HETATM 1966  N   MSE B  52      -0.311  24.013 178.382  1.00 39.40           N  
HETATM 1967  CA  MSE B  52      -1.088  24.671 179.398  1.00 42.73           C  
HETATM 1968  C   MSE B  52      -2.508  24.937 178.895  1.00 41.70           C  
HETATM 1969  O   MSE B  52      -3.477  24.794 179.656  1.00 42.69           O  
HETATM 1970  CB  MSE B  52      -0.393  25.994 179.745  1.00 41.13           C  
HETATM 1971  CG  MSE B  52      -0.827  26.582 180.954  1.00 43.98           C  
HETATM 1972 SE   MSE B  52       0.035  28.314 181.214  1.00 49.35          SE  
HETATM 1973  CE  MSE B  52       1.441  28.172 180.295  1.00 20.86           C  
ATOM   1974  N   ALA B  53      -2.613  25.380 177.643  1.00 41.10           N  
ATOM   1975  CA  ALA B  53      -3.900  25.640 176.997  1.00 40.72           C  
ATOM   1976  C   ALA B  53      -4.637  24.387 176.519  1.00 40.40           C  
ATOM   1977  O   ALA B  53      -5.844  24.450 176.330  1.00 41.70           O  
ATOM   1978  CB  ALA B  53      -3.726  26.605 175.854  1.00 41.19           C  
ATOM   1979  N   ALA B  54      -3.922  23.272 176.307  1.00 39.66           N  
ATOM   1980  CA  ALA B  54      -4.526  21.958 175.952  1.00 38.99           C  
ATOM   1981  C   ALA B  54      -5.437  21.993 174.703  1.00 38.75           C  
ATOM   1982  O   ALA B  54      -6.588  21.513 174.742  1.00 38.75           O  
ATOM   1983  CB  ALA B  54      -5.267  21.326 177.164  1.00 38.60           C  
ATOM   1984  N   PRO B  55      -4.937  22.549 173.591  1.00 38.93           N  
ATOM   1985  CA  PRO B  55      -5.802  22.649 172.403  1.00 38.48           C  
ATOM   1986  C   PRO B  55      -5.973  21.278 171.745  1.00 38.90           C  
ATOM   1987  O   PRO B  55      -5.074  20.448 171.846  1.00 37.59           O  
ATOM   1988  CB  PRO B  55      -5.038  23.606 171.503  1.00 39.33           C  
ATOM   1989  CG  PRO B  55      -3.573  23.404 171.867  1.00 39.08           C  
ATOM   1990  CD  PRO B  55      -3.591  23.112 173.350  1.00 38.80           C  
ATOM   1991  N   ALA B  56      -7.130  21.036 171.123  1.00 38.34           N  
ATOM   1992  CA  ALA B  56      -7.354  19.802 170.374  1.00 38.75           C  
ATOM   1993  C   ALA B  56      -7.040  19.930 168.877  1.00 38.51           C  
ATOM   1994  O   ALA B  56      -6.748  18.927 168.223  1.00 37.21           O  
ATOM   1995  CB  ALA B  56      -8.811  19.325 170.563  1.00 38.71           C  
ATOM   1996  N   ARG B  57      -7.150  21.139 168.330  1.00 38.30           N  
ATOM   1997  CA  ARG B  57      -7.064  21.343 166.868  1.00 38.49           C  
ATOM   1998  C   ARG B  57      -6.235  22.601 166.619  1.00 37.97           C  
ATOM   1999  O   ARG B  57      -6.571  23.681 167.127  1.00 37.14           O  
ATOM   2000  CB  ARG B  57      -8.462  21.526 166.268  1.00 38.06           C  
ATOM   2001  CG  ARG B  57      -9.372  20.264 166.318  1.00 39.54           C  
ATOM   2002  CD  ARG B  57     -10.745  20.548 165.716  1.00 41.86           C  
ATOM   2003  NE  ARG B  57     -10.662  21.154 164.382  1.00 49.12           N  
ATOM   2004  CZ  ARG B  57     -10.199  20.555 163.285  1.00 51.30           C  
ATOM   2005  NH1 ARG B  57      -9.745  19.299 163.314  1.00 52.33           N  
ATOM   2006  NH2 ARG B  57     -10.184  21.224 162.140  1.00 52.67           N  
ATOM   2007  N   ILE B  58      -5.151  22.456 165.860  1.00 35.71           N  
ATOM   2008  CA  ILE B  58      -4.214  23.564 165.590  1.00 35.81           C  
ATOM   2009  C   ILE B  58      -4.098  23.728 164.078  1.00 35.90           C  
ATOM   2010  O   ILE B  58      -3.965  22.731 163.332  1.00 35.60           O  
ATOM   2011  CB  ILE B  58      -2.825  23.261 166.175  1.00 35.53           C  
ATOM   2012  CG1 ILE B  58      -2.937  23.060 167.699  1.00 36.06           C  
ATOM   2013  CG2 ILE B  58      -1.781  24.381 165.788  1.00 36.05           C  
ATOM   2014  CD1 ILE B  58      -1.707  22.342 168.337  1.00 37.59           C  
ATOM   2015  N   LEU B  59      -4.183  24.974 163.618  1.00 36.06           N  
ATOM   2016  CA  LEU B  59      -3.920  25.307 162.212  1.00 35.81           C  
ATOM   2017  C   LEU B  59      -2.642  26.157 162.123  1.00 36.31           C  
ATOM   2018  O   LEU B  59      -2.475  27.151 162.842  1.00 35.32           O  
ATOM   2019  CB  LEU B  59      -5.103  26.074 161.619  1.00 36.32           C  
ATOM   2020  CG  LEU B  59      -4.866  26.633 160.212  1.00 34.51           C  
ATOM   2021  CD1 LEU B  59      -4.614  25.512 159.184  1.00 33.39           C  
ATOM   2022  CD2 LEU B  59      -6.031  27.497 159.805  1.00 36.22           C  
ATOM   2023  N   GLU B  60      -1.730  25.752 161.249  1.00 35.99           N  
ATOM   2024  CA  GLU B  60      -0.485  26.473 161.062  1.00 37.37           C  
ATOM   2025  C   GLU B  60      -0.349  26.917 159.621  1.00 36.97           C  
ATOM   2026  O   GLU B  60      -0.581  26.127 158.711  1.00 36.45           O  
ATOM   2027  CB  GLU B  60       0.704  25.563 161.419  1.00 36.63           C  
ATOM   2028  CG  GLU B  60       2.049  26.029 160.871  1.00 39.83           C  
ATOM   2029  CD  GLU B  60       3.156  25.071 161.276  1.00 40.81           C  
ATOM   2030  OE1 GLU B  60       3.216  23.953 160.722  1.00 40.21           O  
ATOM   2031  OE2 GLU B  60       3.903  25.435 162.215  1.00 45.62           O  
ATOM   2032  N   ILE B  61       0.045  28.168 159.419  1.00 36.85           N  
ATOM   2033  CA  ILE B  61       0.284  28.650 158.068  1.00 37.63           C  
ATOM   2034  C   ILE B  61       1.784  28.775 157.891  1.00 37.83           C  
ATOM   2035  O   ILE B  61       2.415  29.614 158.547  1.00 37.37           O  
ATOM   2036  CB  ILE B  61      -0.361  30.026 157.830  1.00 37.43           C  
ATOM   2037  CG1 ILE B  61      -1.837  30.046 158.313  1.00 39.53           C  
ATOM   2038  CG2 ILE B  61      -0.189  30.456 156.340  1.00 38.67           C  
ATOM   2039  CD1 ILE B  61      -2.769  29.009 157.693  1.00 40.74           C  
ATOM   2040  N   GLY B  62       2.348  27.948 157.006  1.00 37.25           N  
ATOM   2041  CA  GLY B  62       3.780  27.974 156.752  1.00 38.33           C  
ATOM   2042  C   GLY B  62       4.494  26.814 157.408  1.00 38.52           C  
ATOM   2043  O   GLY B  62       5.216  26.997 158.390  1.00 39.99           O  
ATOM   2044  N   THR B  63       4.312  25.611 156.859  1.00 38.32           N  
ATOM   2045  CA  THR B  63       4.904  24.416 157.464  1.00 38.51           C  
ATOM   2046  C   THR B  63       6.412  24.343 157.400  1.00 37.60           C  
ATOM   2047  O   THR B  63       7.034  23.763 158.293  1.00 36.71           O  
ATOM   2048  CB  THR B  63       4.121  23.077 157.162  1.00 41.29           C  
ATOM   2049  OG1 THR B  63       4.964  21.906 157.061  1.00 43.28           O  
ATOM   2050  CG2 THR B  63       3.175  23.208 156.110  1.00 33.84           C  
ATOM   2051  N   ALA B  64       6.981  24.953 156.363  1.00 37.39           N  
ATOM   2052  CA  ALA B  64       8.413  24.912 156.086  1.00 38.57           C  
ATOM   2053  C   ALA B  64       8.781  23.419 155.993  1.00 38.35           C  
ATOM   2054  O   ALA B  64       8.127  22.712 155.228  1.00 38.38           O  
ATOM   2055  CB  ALA B  64       9.212  25.723 157.177  1.00 38.48           C  
ATOM   2056  N   ILE B  65       9.731  22.896 156.772  1.00 38.54           N  
ATOM   2057  CA  ILE B  65      10.036  21.454 156.651  1.00 38.69           C  
ATOM   2058  C   ILE B  65       9.351  20.604 157.723  1.00 37.29           C  
ATOM   2059  O   ILE B  65       9.729  19.452 157.948  1.00 37.37           O  
ATOM   2060  CB  ILE B  65      11.581  21.135 156.530  1.00 38.60           C  
ATOM   2061  CG1 ILE B  65      12.335  21.605 157.785  1.00 40.77           C  
ATOM   2062  CG2 ILE B  65      12.146  21.691 155.192  1.00 39.80           C  
ATOM   2063  CD1 ILE B  65      13.671  20.899 158.006  1.00 41.04           C  
ATOM   2064  N   GLY B  66       8.365  21.199 158.410  1.00 37.12           N  
ATOM   2065  CA  GLY B  66       7.509  20.466 159.337  1.00 36.56           C  
ATOM   2066  C   GLY B  66       7.989  20.416 160.786  1.00 36.01           C  
ATOM   2067  O   GLY B  66       7.394  19.721 161.607  1.00 34.49           O  
ATOM   2068  N   TYR B  67       9.022  21.181 161.119  1.00 36.39           N  
ATOM   2069  CA  TYR B  67       9.554  21.164 162.489  1.00 36.52           C  
ATOM   2070  C   TYR B  67       8.531  21.565 163.566  1.00 37.28           C  
ATOM   2071  O   TYR B  67       8.328  20.813 164.544  1.00 36.45           O  
ATOM   2072  CB  TYR B  67      10.782  22.051 162.549  1.00 37.62           C  
ATOM   2073  CG  TYR B  67      11.445  22.099 163.905  1.00 36.46           C  
ATOM   2074  CD1 TYR B  67      12.302  21.091 164.311  1.00 36.48           C  
ATOM   2075  CD2 TYR B  67      11.224  23.175 164.753  1.00 36.91           C  
ATOM   2076  CE1 TYR B  67      12.922  21.149 165.576  1.00 36.39           C  
ATOM   2077  CE2 TYR B  67      11.846  23.257 165.990  1.00 40.57           C  
ATOM   2078  CZ  TYR B  67      12.689  22.252 166.392  1.00 38.38           C  
ATOM   2079  OH  TYR B  67      13.308  22.400 167.612  1.00 38.47           O  
ATOM   2080  N   SER B  68       7.861  22.708 163.379  0.50 36.78           N  
ATOM   2082  CA  SER B  68       6.878  23.163 164.387  0.50 37.78           C  
ATOM   2084  C   SER B  68       5.660  22.237 164.473  0.50 37.57           C  
ATOM   2086  O   SER B  68       5.197  21.943 165.572  0.50 37.85           O  
ATOM   2088  CB  SER B  68       6.468  24.628 164.187  0.50 37.77           C  
ATOM   2090  OG  SER B  68       7.556  25.489 164.485  0.50 41.22           O  
ATOM   2092  N   ALA B  69       5.170  21.754 163.326  1.00 37.51           N  
ATOM   2093  CA  ALA B  69       4.020  20.847 163.297  1.00 37.46           C  
ATOM   2094  C   ALA B  69       4.378  19.591 164.090  1.00 36.56           C  
ATOM   2095  O   ALA B  69       3.605  19.121 164.923  1.00 37.41           O  
ATOM   2096  CB  ALA B  69       3.636  20.454 161.864  1.00 37.21           C  
ATOM   2097  N   ILE B  70       5.552  19.031 163.795  1.00 35.30           N  
ATOM   2098  CA  ILE B  70       6.041  17.836 164.483  1.00 34.77           C  
ATOM   2099  C   ILE B  70       6.193  18.024 165.984  1.00 35.37           C  
ATOM   2100  O   ILE B  70       5.692  17.202 166.758  1.00 35.25           O  
ATOM   2101  CB  ILE B  70       7.344  17.291 163.838  1.00 33.58           C  
ATOM   2102  CG1 ILE B  70       6.979  16.627 162.496  1.00 35.32           C  
ATOM   2103  CG2 ILE B  70       8.046  16.301 164.759  1.00 34.63           C  
ATOM   2104  CD1 ILE B  70       8.181  16.361 161.569  1.00 33.82           C  
ATOM   2105  N   ARG B  71       6.883  19.086 166.396  1.00 35.10           N  
ATOM   2106  CA  ARG B  71       7.115  19.299 167.811  1.00 36.32           C  
ATOM   2107  C   ARG B  71       5.832  19.585 168.584  1.00 36.02           C  
ATOM   2108  O   ARG B  71       5.673  19.123 169.732  1.00 35.02           O  
ATOM   2109  CB  ARG B  71       8.153  20.396 167.986  1.00 36.55           C  
ATOM   2110  CG  ARG B  71       9.494  19.828 167.537  1.00 39.94           C  
ATOM   2111  CD  ARG B  71      10.635  20.315 168.323  1.00 42.42           C  
ATOM   2112  NE  ARG B  71      10.533  19.979 169.740  1.00 39.49           N  
ATOM   2113  CZ  ARG B  71      11.195  20.636 170.675  1.00 39.18           C  
ATOM   2114  NH1 ARG B  71      11.995  21.617 170.313  1.00 37.49           N  
ATOM   2115  NH2 ARG B  71      11.058  20.319 171.975  1.00 39.16           N  
HETATM 2116  N   MSE B  72       4.890  20.298 167.957  1.00 35.55           N  
HETATM 2117  CA  MSE B  72       3.563  20.465 168.583  1.00 37.11           C  
HETATM 2118  C   MSE B  72       2.789  19.149 168.710  1.00 36.86           C  
HETATM 2119  O   MSE B  72       2.182  18.875 169.784  1.00 35.64           O  
HETATM 2120  CB  MSE B  72       2.692  21.489 167.816  1.00 37.62           C  
HETATM 2121  CG  MSE B  72       3.277  22.888 167.901  1.00 38.25           C  
HETATM 2122 SE   MSE B  72       2.086  24.258 167.079  1.00 43.42          SE  
HETATM 2123  CE  MSE B  72       2.190  23.706 165.179  1.00 38.79           C  
ATOM   2124  N   ALA B  73       2.800  18.337 167.643  1.00 35.11           N  
ATOM   2125  CA  ALA B  73       2.126  17.039 167.701  1.00 35.98           C  
ATOM   2126  C   ALA B  73       2.736  16.162 168.800  1.00 36.08           C  
ATOM   2127  O   ALA B  73       2.016  15.474 169.515  1.00 36.06           O  
ATOM   2128  CB  ALA B  73       2.185  16.308 166.333  1.00 36.04           C  
ATOM   2129  N   GLN B  74       4.063  16.182 168.924  1.00 36.61           N  
ATOM   2130  CA  GLN B  74       4.723  15.386 169.960  1.00 37.08           C  
ATOM   2131  C   GLN B  74       4.382  15.895 171.360  1.00 37.44           C  
ATOM   2132  O   GLN B  74       4.229  15.087 172.291  1.00 36.04           O  
ATOM   2133  CB  GLN B  74       6.232  15.384 169.763  1.00 37.39           C  
ATOM   2134  CG  GLN B  74       6.684  14.573 168.571  1.00 40.35           C  
ATOM   2135  CD  GLN B  74       8.197  14.569 168.457  1.00 45.31           C  
ATOM   2136  OE1 GLN B  74       8.799  13.529 168.222  1.00 51.62           O  
ATOM   2137  NE2 GLN B  74       8.817  15.733 168.636  1.00 49.95           N  
ATOM   2138  N   ALA B  75       4.252  17.211 171.519  1.00 36.62           N  
ATOM   2139  CA  ALA B  75       3.979  17.784 172.849  1.00 37.85           C  
ATOM   2140  C   ALA B  75       2.533  17.588 173.271  1.00 38.25           C  
ATOM   2141  O   ALA B  75       2.224  17.599 174.467  1.00 38.69           O  
ATOM   2142  CB  ALA B  75       4.323  19.275 172.876  1.00 38.32           C  
ATOM   2143  N   LEU B  76       1.648  17.465 172.274  1.00 38.31           N  
ATOM   2144  CA  LEU B  76       0.203  17.368 172.457  1.00 38.38           C  
ATOM   2145  C   LEU B  76      -0.318  16.093 171.770  1.00 38.61           C  
ATOM   2146  O   LEU B  76      -0.942  16.160 170.704  1.00 36.55           O  
ATOM   2147  CB  LEU B  76      -0.471  18.603 171.844  1.00 38.77           C  
ATOM   2148  CG  LEU B  76      -0.089  19.971 172.452  1.00 41.15           C  
ATOM   2149  CD1 LEU B  76      -0.409  21.136 171.492  1.00 43.91           C  
ATOM   2150  CD2 LEU B  76      -0.780  20.162 173.818  1.00 43.65           C  
ATOM   2151  N   PRO B  77      -0.107  14.931 172.396  1.00 39.70           N  
ATOM   2152  CA  PRO B  77      -0.403  13.628 171.714  1.00 40.58           C  
ATOM   2153  C   PRO B  77      -1.869  13.445 171.289  1.00 41.51           C  
ATOM   2154  O   PRO B  77      -2.165  12.639 170.401  1.00 41.14           O  
ATOM   2155  CB  PRO B  77      -0.009  12.575 172.757  1.00 40.65           C  
ATOM   2156  CG  PRO B  77       0.856  13.340 173.796  1.00 41.28           C  
ATOM   2157  CD  PRO B  77       0.402  14.757 173.770  1.00 39.94           C  
ATOM   2158  N   GLU B  78      -2.766  14.197 171.916  1.00 42.08           N  
ATOM   2159  CA  GLU B  78      -4.198  14.150 171.599  1.00 43.76           C  
ATOM   2160  C   GLU B  78      -4.659  15.092 170.471  1.00 43.55           C  
ATOM   2161  O   GLU B  78      -5.758  14.914 169.919  1.00 44.16           O  
ATOM   2162  CB  GLU B  78      -5.001  14.456 172.863  1.00 44.44           C  
ATOM   2163  CG  GLU B  78      -4.820  13.429 173.953  1.00 48.31           C  
ATOM   2164  CD  GLU B  78      -5.322  12.072 173.527  1.00 54.34           C  
ATOM   2165  OE1 GLU B  78      -4.533  11.293 172.930  1.00 57.02           O  
ATOM   2166  OE2 GLU B  78      -6.516  11.782 173.789  1.00 57.58           O  
ATOM   2167  N   ALA B  79      -3.830  16.072 170.129  1.00 41.14           N  
ATOM   2168  CA  ALA B  79      -4.251  17.139 169.238  1.00 40.67           C  
ATOM   2169  C   ALA B  79      -4.029  16.756 167.785  1.00 39.82           C  
ATOM   2170  O   ALA B  79      -3.251  15.861 167.474  1.00 39.08           O  
ATOM   2171  CB  ALA B  79      -3.476  18.434 169.547  1.00 40.72           C  
ATOM   2172  N   THR B  80      -4.742  17.423 166.904  1.00 39.81           N  
ATOM   2173  CA  THR B  80      -4.500  17.278 165.466  1.00 41.11           C  
ATOM   2174  C   THR B  80      -4.059  18.619 164.947  1.00 40.55           C  
ATOM   2175  O   THR B  80      -4.463  19.682 165.473  1.00 40.44           O  
ATOM   2176  CB  THR B  80      -5.720  16.751 164.678  1.00 41.97           C  
ATOM   2177  OG1 THR B  80      -6.783  17.700 164.731  1.00 45.38           O  
ATOM   2178  CG2 THR B  80      -6.208  15.440 165.243  1.00 42.85           C  
ATOM   2179  N   ILE B  81      -3.190  18.557 163.947  1.00 39.26           N  
ATOM   2180  CA  ILE B  81      -2.610  19.725 163.360  1.00 39.03           C  
ATOM   2181  C   ILE B  81      -2.934  19.685 161.855  1.00 38.42           C  
ATOM   2182  O   ILE B  81      -2.897  18.618 161.208  1.00 37.22           O  
ATOM   2183  CB  ILE B  81      -1.100  19.731 163.600  1.00 39.85           C  
ATOM   2184  CG1 ILE B  81      -0.842  19.625 165.135  1.00 42.65           C  
ATOM   2185  CG2 ILE B  81      -0.466  20.988 163.001  1.00 40.54           C  
ATOM   2186  CD1 ILE B  81       0.544  19.782 165.529  1.00 47.84           C  
ATOM   2187  N   VAL B  82      -3.302  20.843 161.331  1.00 36.25           N  
ATOM   2188  CA  VAL B  82      -3.427  21.026 159.894  1.00 36.21           C  
ATOM   2189  C   VAL B  82      -2.374  22.091 159.578  1.00 35.63           C  
ATOM   2190  O   VAL B  82      -2.301  23.099 160.273  1.00 35.32           O  
ATOM   2191  CB  VAL B  82      -4.821  21.521 159.496  1.00 35.57           C  
ATOM   2192  CG1 VAL B  82      -4.876  21.808 157.974  1.00 36.55           C  
ATOM   2193  CG2 VAL B  82      -5.883  20.486 159.874  1.00 37.16           C  
ATOM   2194  N   SER B  83      -1.546  21.884 158.561  1.00 34.70           N  
ATOM   2195  CA  SER B  83      -0.517  22.892 158.231  1.00 35.45           C  
ATOM   2196  C   SER B  83      -0.396  23.119 156.711  1.00 36.38           C  
ATOM   2197  O   SER B  83      -0.520  22.171 155.941  1.00 36.63           O  
ATOM   2198  CB  SER B  83       0.823  22.446 158.809  1.00 36.15           C  
ATOM   2199  OG  SER B  83       1.849  23.445 158.660  1.00 36.32           O  
ATOM   2200  N   ILE B  84      -0.168  24.368 156.294  1.00 35.76           N  
ATOM   2201  CA  ILE B  84      -0.241  24.753 154.903  1.00 35.80           C  
ATOM   2202  C   ILE B  84       1.122  25.283 154.473  1.00 35.97           C  
ATOM   2203  O   ILE B  84       1.735  26.058 155.200  1.00 36.06           O  
ATOM   2204  CB  ILE B  84      -1.295  25.846 154.659  1.00 35.95           C  
ATOM   2205  CG1 ILE B  84      -2.693  25.360 155.053  1.00 36.16           C  
ATOM   2206  CG2 ILE B  84      -1.323  26.193 153.176  1.00 34.65           C  
ATOM   2207  CD1 ILE B  84      -3.748  26.513 155.071  1.00 35.70           C  
ATOM   2208  N   GLU B  85       1.610  24.802 153.333  1.00 35.73           N  
ATOM   2209  CA  GLU B  85       2.902  25.226 152.791  1.00 36.09           C  
ATOM   2210  C   GLU B  85       2.800  25.465 151.282  1.00 36.28           C  
ATOM   2211  O   GLU B  85       2.254  24.645 150.550  1.00 36.27           O  
ATOM   2212  CB  GLU B  85       3.970  24.160 153.092  1.00 36.76           C  
ATOM   2213  CG  GLU B  85       5.383  24.424 152.483  1.00 38.17           C  
ATOM   2214  CD  GLU B  85       5.940  25.779 152.880  1.00 39.19           C  
ATOM   2215  OE1 GLU B  85       5.886  26.161 154.088  1.00 40.33           O  
ATOM   2216  OE2 GLU B  85       6.409  26.472 151.972  1.00 41.13           O  
ATOM   2217  N   ARG B  86       3.355  26.572 150.820  1.00 36.37           N  
ATOM   2218  CA  ARG B  86       3.301  26.884 149.409  1.00 38.34           C  
ATOM   2219  C   ARG B  86       4.532  26.477 148.604  1.00 37.71           C  
ATOM   2220  O   ARG B  86       4.451  26.397 147.386  1.00 37.51           O  
ATOM   2221  CB  ARG B  86       2.980  28.374 149.208  1.00 40.10           C  
ATOM   2222  CG  ARG B  86       4.102  29.340 149.551  1.00 44.21           C  
ATOM   2223  CD  ARG B  86       3.988  30.583 148.622  1.00 53.06           C  
ATOM   2224  NE  ARG B  86       4.888  31.653 149.047  1.00 58.05           N  
ATOM   2225  CZ  ARG B  86       4.776  32.936 148.706  1.00 60.68           C  
ATOM   2226  NH1 ARG B  86       3.785  33.355 147.923  1.00 62.56           N  
ATOM   2227  NH2 ARG B  86       5.661  33.814 149.162  1.00 62.53           N  
ATOM   2228  N   ASP B  87       5.668  26.220 149.261  1.00 37.67           N  
ATOM   2229  CA  ASP B  87       6.889  25.834 148.533  1.00 38.67           C  
ATOM   2230  C   ASP B  87       6.895  24.320 148.324  1.00 37.86           C  
ATOM   2231  O   ASP B  87       6.910  23.575 149.306  1.00 37.03           O  
ATOM   2232  CB  ASP B  87       8.156  26.280 149.300  1.00 39.32           C  
ATOM   2233  CG  ASP B  87       9.440  25.868 148.597  1.00 42.18           C  
ATOM   2234  OD1 ASP B  87       9.805  24.681 148.607  1.00 42.62           O  
ATOM   2235  OD2 ASP B  87      10.100  26.732 147.991  1.00 49.06           O  
ATOM   2236  N   GLU B  88       6.919  23.865 147.065  1.00 37.77           N  
ATOM   2237  CA  GLU B  88       6.700  22.441 146.779  1.00 36.75           C  
ATOM   2238  C   GLU B  88       7.785  21.532 147.358  1.00 37.85           C  
ATOM   2239  O   GLU B  88       7.479  20.459 147.892  1.00 37.16           O  
ATOM   2240  CB  GLU B  88       6.489  22.167 145.280  1.00 37.96           C  
ATOM   2241  CG  GLU B  88       5.811  20.824 145.017  1.00 37.25           C  
ATOM   2242  CD  GLU B  88       5.238  20.702 143.607  1.00 45.88           C  
ATOM   2243  OE1 GLU B  88       5.660  21.436 142.672  1.00 40.74           O  
ATOM   2244  OE2 GLU B  88       4.400  19.793 143.415  1.00 45.82           O  
ATOM   2245  N   ARG B  89       9.043  21.956 147.234  1.00 37.61           N  
ATOM   2246  CA  ARG B  89      10.193  21.237 147.802  1.00 39.28           C  
ATOM   2247  C   ARG B  89      10.076  21.107 149.345  1.00 37.62           C  
ATOM   2248  O   ARG B  89      10.295  20.014 149.916  1.00 36.22           O  
ATOM   2249  CB  ARG B  89      11.457  21.999 147.389  1.00 38.84           C  
ATOM   2250  CG  ARG B  89      12.773  21.618 148.035  1.00 42.79           C  
ATOM   2251  CD  ARG B  89      13.919  22.300 147.260  1.00 44.55           C  
ATOM   2252  NE  ARG B  89      14.976  22.773 148.158  1.00 54.10           N  
ATOM   2253  CZ  ARG B  89      16.189  22.231 148.260  1.00 56.50           C  
ATOM   2254  NH1 ARG B  89      16.534  21.187 147.514  1.00 56.56           N  
ATOM   2255  NH2 ARG B  89      17.069  22.742 149.116  1.00 58.81           N  
ATOM   2256  N   ARG B  90       9.758  22.211 150.019  1.00 36.28           N  
ATOM   2257  CA  ARG B  90       9.587  22.166 151.481  1.00 36.64           C  
ATOM   2258  C   ARG B  90       8.440  21.258 151.900  1.00 36.12           C  
ATOM   2259  O   ARG B  90       8.602  20.444 152.824  1.00 35.12           O  
ATOM   2260  CB  ARG B  90       9.430  23.562 152.095  1.00 37.60           C  
ATOM   2261  CG  ARG B  90      10.702  24.378 151.988  1.00 40.31           C  
ATOM   2262  CD  ARG B  90      10.561  25.757 152.566  1.00 44.48           C  
ATOM   2263  NE  ARG B  90      11.828  26.481 152.414  1.00 47.22           N  
ATOM   2264  CZ  ARG B  90      12.040  27.750 152.770  1.00 49.27           C  
ATOM   2265  NH1 ARG B  90      11.073  28.476 153.297  1.00 50.67           N  
ATOM   2266  NH2 ARG B  90      13.236  28.300 152.577  1.00 51.97           N  
ATOM   2267  N   TYR B  91       7.301  21.385 151.215  1.00 34.61           N  
ATOM   2268  CA  TYR B  91       6.129  20.533 151.491  1.00 35.09           C  
ATOM   2269  C   TYR B  91       6.485  19.031 151.392  1.00 34.90           C  
ATOM   2270  O   TYR B  91       6.101  18.249 152.263  1.00 34.24           O  
ATOM   2271  CB  TYR B  91       4.958  20.889 150.559  1.00 36.10           C  
ATOM   2272  CG  TYR B  91       3.918  19.800 150.478  1.00 36.14           C  
ATOM   2273  CD1 TYR B  91       2.936  19.659 151.466  1.00 37.48           C  
ATOM   2274  CD2 TYR B  91       3.931  18.893 149.418  1.00 36.97           C  
ATOM   2275  CE1 TYR B  91       1.980  18.615 151.389  1.00 37.75           C  
ATOM   2276  CE2 TYR B  91       3.008  17.867 149.338  1.00 37.12           C  
ATOM   2277  CZ  TYR B  91       2.036  17.733 150.324  1.00 38.31           C  
ATOM   2278  OH  TYR B  91       1.129  16.701 150.182  1.00 38.54           O  
ATOM   2279  N   GLU B  92       7.189  18.650 150.324  1.00 34.84           N  
ATOM   2280  CA  GLU B  92       7.581  17.251 150.094  1.00 35.17           C  
ATOM   2281  C   GLU B  92       8.514  16.775 151.186  1.00 35.11           C  
ATOM   2282  O   GLU B  92       8.410  15.642 151.655  1.00 33.84           O  
ATOM   2283  CB  GLU B  92       8.214  17.074 148.703  1.00 36.02           C  
ATOM   2284  CG  GLU B  92       7.239  17.302 147.539  1.00 38.46           C  
ATOM   2285  CD  GLU B  92       6.118  16.252 147.432  1.00 46.38           C  
ATOM   2286  OE1 GLU B  92       6.114  15.264 148.200  1.00 49.21           O  
ATOM   2287  OE2 GLU B  92       5.238  16.398 146.545  1.00 48.90           O  
ATOM   2288  N   GLU B  93       9.416  17.649 151.621  1.00 35.40           N  
ATOM   2289  CA  GLU B  93      10.315  17.258 152.710  1.00 36.22           C  
ATOM   2290  C   GLU B  93       9.569  17.101 154.034  1.00 35.61           C  
ATOM   2291  O   GLU B  93       9.796  16.150 154.796  1.00 36.10           O  
ATOM   2292  CB  GLU B  93      11.436  18.275 152.878  1.00 37.33           C  
ATOM   2293  CG  GLU B  93      12.450  17.767 153.916  1.00 40.20           C  
ATOM   2294  CD  GLU B  93      13.662  18.666 154.118  1.00 47.46           C  
ATOM   2295  OE1 GLU B  93      13.971  19.506 153.229  1.00 48.88           O  
ATOM   2296  OE2 GLU B  93      14.319  18.525 155.191  1.00 48.42           O  
ATOM   2297  N   ALA B  94       8.717  18.074 154.336  1.00 34.29           N  
ATOM   2298  CA  ALA B  94       7.889  18.036 155.533  1.00 34.53           C  
ATOM   2299  C   ALA B  94       7.057  16.767 155.562  1.00 34.69           C  
ATOM   2300  O   ALA B  94       6.909  16.149 156.594  1.00 34.45           O  
ATOM   2301  CB  ALA B  94       6.974  19.278 155.566  1.00 33.54           C  
ATOM   2302  N   HIS B  95       6.524  16.364 154.411  1.00 35.41           N  
ATOM   2303  CA  HIS B  95       5.678  15.181 154.347  1.00 35.45           C  
ATOM   2304  C   HIS B  95       6.484  13.922 154.732  1.00 34.85           C  
ATOM   2305  O   HIS B  95       5.988  13.054 155.441  1.00 33.04           O  
ATOM   2306  CB  HIS B  95       5.083  15.072 152.948  1.00 38.00           C  
ATOM   2307  CG  HIS B  95       3.855  14.226 152.873  1.00 44.05           C  
ATOM   2308  ND1 HIS B  95       3.859  12.962 152.327  1.00 50.90           N  
ATOM   2309  CD2 HIS B  95       2.577  14.469 153.252  1.00 50.13           C  
ATOM   2310  CE1 HIS B  95       2.636  12.462 152.369  1.00 53.00           C  
ATOM   2311  NE2 HIS B  95       1.840  13.357 152.930  1.00 52.34           N  
ATOM   2312  N   LYS B  96       7.729  13.844 154.269  1.00 33.61           N  
ATOM   2313  CA  LYS B  96       8.625  12.751 154.638  1.00 33.32           C  
ATOM   2314  C   LYS B  96       8.995  12.758 156.125  1.00 33.88           C  
ATOM   2315  O   LYS B  96       9.013  11.698 156.777  1.00 33.78           O  
ATOM   2316  CB  LYS B  96       9.898  12.770 153.775  1.00 32.93           C  
ATOM   2317  CG  LYS B  96       9.623  12.503 152.298  1.00 33.33           C  
ATOM   2318  CD  LYS B  96      10.889  12.616 151.477  1.00 35.31           C  
ATOM   2319  CE  LYS B  96      10.638  12.227 150.017  1.00 39.34           C  
ATOM   2320  NZ  LYS B  96      10.169  13.393 149.283  1.00 41.07           N  
ATOM   2321  N   HIS B  97       9.308  13.930 156.678  1.00 32.79           N  
ATOM   2322  CA  HIS B  97       9.588  13.983 158.139  1.00 33.00           C  
ATOM   2323  C   HIS B  97       8.401  13.550 159.007  1.00 33.50           C  
ATOM   2324  O   HIS B  97       8.552  12.873 160.026  1.00 34.39           O  
ATOM   2325  CB  HIS B  97      10.000  15.399 158.523  1.00 32.82           C  
ATOM   2326  CG  HIS B  97      11.337  15.766 157.981  1.00 35.36           C  
ATOM   2327  ND1 HIS B  97      11.651  17.033 157.555  1.00 38.30           N  
ATOM   2328  CD2 HIS B  97      12.448  15.016 157.801  1.00 35.14           C  
ATOM   2329  CE1 HIS B  97      12.904  17.050 157.130  1.00 32.68           C  
ATOM   2330  NE2 HIS B  97      13.405  15.840 157.270  1.00 37.41           N  
ATOM   2331  N   VAL B  98       7.215  13.980 158.622  1.00 33.62           N  
ATOM   2332  CA  VAL B  98       6.002  13.579 159.347  1.00 34.78           C  
ATOM   2333  C   VAL B  98       5.867  12.043 159.295  1.00 34.55           C  
ATOM   2334  O   VAL B  98       5.599  11.392 160.314  1.00 35.13           O  
ATOM   2335  CB  VAL B  98       4.764  14.318 158.779  1.00 34.18           C  
ATOM   2336  CG1 VAL B  98       3.485  13.655 159.259  1.00 35.21           C  
ATOM   2337  CG2 VAL B  98       4.796  15.800 159.203  1.00 34.41           C  
ATOM   2338  N   LYS B  99       6.080  11.463 158.110  1.00 35.39           N  
ATOM   2339  CA  LYS B  99       6.025  10.022 157.937  1.00 35.57           C  
ATOM   2340  C   LYS B  99       7.107   9.319 158.749  1.00 35.63           C  
ATOM   2341  O   LYS B  99       6.843   8.281 159.370  1.00 35.56           O  
ATOM   2342  CB  LYS B  99       6.170   9.645 156.457  1.00 36.12           C  
ATOM   2343  CG  LYS B  99       4.888   9.811 155.641  1.00 37.59           C  
ATOM   2344  CD  LYS B  99       5.115   9.521 154.140  1.00 37.92           C  
ATOM   2345  CE  LYS B  99       5.006   8.040 153.832  1.00 42.46           C  
ATOM   2346  NZ  LYS B  99       4.911   7.755 152.351  1.00 46.57           N  
ATOM   2347  N   ALA B 100       8.321   9.878 158.743  1.00 34.73           N  
ATOM   2348  CA  ALA B 100       9.450   9.304 159.487  1.00 35.03           C  
ATOM   2349  C   ALA B 100       9.103   9.018 160.944  1.00 35.72           C  
ATOM   2350  O   ALA B 100       9.554   8.012 161.512  1.00 34.87           O  
ATOM   2351  CB  ALA B 100      10.632  10.244 159.436  1.00 34.91           C  
ATOM   2352  N   LEU B 101       8.333   9.936 161.539  1.00 35.41           N  
ATOM   2353  CA  LEU B 101       8.011   9.900 162.942  1.00 36.89           C  
ATOM   2354  C   LEU B 101       6.663   9.261 163.226  1.00 36.63           C  
ATOM   2355  O   LEU B 101       6.221   9.274 164.360  1.00 38.49           O  
ATOM   2356  CB  LEU B 101       8.122  11.303 163.564  1.00 36.65           C  
ATOM   2357  CG  LEU B 101       9.552  11.846 163.416  1.00 40.44           C  
ATOM   2358  CD1 LEU B 101       9.603  13.330 163.667  1.00 41.93           C  
ATOM   2359  CD2 LEU B 101      10.549  11.051 164.367  1.00 43.28           C  
ATOM   2360  N   GLY B 102       6.011   8.715 162.213  1.00 36.54           N  
ATOM   2361  CA  GLY B 102       4.746   7.998 162.421  1.00 37.43           C  
ATOM   2362  C   GLY B 102       3.603   8.946 162.779  1.00 36.70           C  
ATOM   2363  O   GLY B 102       2.658   8.542 163.433  1.00 37.26           O  
ATOM   2364  N   LEU B 103       3.675  10.187 162.311  1.00 37.01           N  
ATOM   2365  CA  LEU B 103       2.716  11.232 162.734  1.00 37.11           C  
ATOM   2366  C   LEU B 103       1.618  11.593 161.710  1.00 37.51           C  
ATOM   2367  O   LEU B 103       0.840  12.541 161.913  1.00 37.01           O  
ATOM   2368  CB  LEU B 103       3.472  12.493 163.177  1.00 36.99           C  
ATOM   2369  CG  LEU B 103       4.310  12.354 164.465  1.00 37.65           C  
ATOM   2370  CD1 LEU B 103       5.223  13.624 164.691  1.00 36.43           C  
ATOM   2371  CD2 LEU B 103       3.394  12.163 165.655  1.00 40.91           C  
ATOM   2372  N   GLU B 104       1.520  10.839 160.625  1.00 37.39           N  
ATOM   2373  CA  GLU B 104       0.605  11.217 159.548  1.00 39.49           C  
ATOM   2374  C   GLU B 104      -0.875  11.254 159.963  1.00 40.29           C  
ATOM   2375  O   GLU B 104      -1.684  11.986 159.360  1.00 40.11           O  
ATOM   2376  CB  GLU B 104       0.778  10.290 158.342  1.00 40.40           C  
ATOM   2377  CG  GLU B 104       1.027  11.081 157.067  1.00 44.40           C  
ATOM   2378  CD  GLU B 104       1.180  10.209 155.837  1.00 47.78           C  
ATOM   2379  OE1 GLU B 104       1.173   8.956 155.972  1.00 53.38           O  
ATOM   2380  OE2 GLU B 104       1.305  10.778 154.736  1.00 50.78           O  
ATOM   2381  N   SER B 105      -1.234  10.473 160.984  1.00 40.27           N  
ATOM   2382  CA  SER B 105      -2.632  10.401 161.399  1.00 41.16           C  
ATOM   2383  C   SER B 105      -3.029  11.630 162.210  1.00 40.77           C  
ATOM   2384  O   SER B 105      -4.210  11.860 162.466  1.00 41.48           O  
ATOM   2385  CB  SER B 105      -2.947   9.089 162.151  1.00 41.65           C  
ATOM   2386  OG  SER B 105      -2.297   9.071 163.416  1.00 45.72           O  
ATOM   2387  N   ARG B 106      -2.044  12.431 162.602  1.00 38.93           N  
ATOM   2388  CA  ARG B 106      -2.300  13.579 163.441  1.00 39.70           C  
ATOM   2389  C   ARG B 106      -1.816  14.901 162.844  1.00 39.47           C  
ATOM   2390  O   ARG B 106      -2.137  15.970 163.357  1.00 40.36           O  
ATOM   2391  CB  ARG B 106      -1.658  13.355 164.800  1.00 40.09           C  
ATOM   2392  CG  ARG B 106      -2.358  12.235 165.574  1.00 40.50           C  
ATOM   2393  CD  ARG B 106      -2.207  12.455 167.043  1.00 43.07           C  
ATOM   2394  NE  ARG B 106      -0.817  12.307 167.468  1.00 44.36           N  
ATOM   2395  CZ  ARG B 106      -0.069  13.250 168.036  1.00 44.53           C  
ATOM   2396  NH1 ARG B 106       1.164  12.910 168.380  1.00 45.42           N  
ATOM   2397  NH2 ARG B 106      -0.520  14.528 168.241  1.00 40.38           N  
ATOM   2398  N   ILE B 107      -1.059  14.829 161.759  1.00 37.59           N  
ATOM   2399  CA  ILE B 107      -0.609  16.054 161.083  1.00 36.96           C  
ATOM   2400  C   ILE B 107      -1.056  15.980 159.638  1.00 37.42           C  
ATOM   2401  O   ILE B 107      -0.618  15.074 158.885  1.00 36.89           O  
ATOM   2402  CB  ILE B 107       0.912  16.229 161.142  1.00 37.01           C  
ATOM   2403  CG1 ILE B 107       1.403  16.296 162.601  1.00 36.63           C  
ATOM   2404  CG2 ILE B 107       1.356  17.455 160.281  1.00 34.58           C  
ATOM   2405  CD1 ILE B 107       2.942  16.384 162.723  1.00 37.58           C  
ATOM   2406  N   GLU B 108      -1.953  16.885 159.264  1.00 35.90           N  
ATOM   2407  CA  GLU B 108      -2.455  16.923 157.882  1.00 37.67           C  
ATOM   2408  C   GLU B 108      -1.733  18.053 157.142  1.00 37.37           C  
ATOM   2409  O   GLU B 108      -1.856  19.206 157.517  1.00 36.38           O  
ATOM   2410  CB  GLU B 108      -3.972  17.164 157.844  1.00 37.65           C  
ATOM   2411  CG  GLU B 108      -4.528  17.202 156.404  1.00 39.35           C  
ATOM   2412  CD  GLU B 108      -6.021  17.522 156.318  1.00 40.72           C  
ATOM   2413  OE1 GLU B 108      -6.696  17.678 157.363  1.00 45.55           O  
ATOM   2414  OE2 GLU B 108      -6.526  17.611 155.176  1.00 45.84           O  
ATOM   2415  N   LEU B 109      -0.976  17.722 156.106  1.00 35.75           N  
ATOM   2416  CA  LEU B 109      -0.215  18.750 155.413  1.00 35.56           C  
ATOM   2417  C   LEU B 109      -0.904  19.107 154.110  1.00 35.27           C  
ATOM   2418  O   LEU B 109      -1.223  18.237 153.298  1.00 36.01           O  
ATOM   2419  CB  LEU B 109       1.219  18.286 155.103  1.00 35.97           C  
ATOM   2420  CG  LEU B 109       2.107  17.929 156.288  1.00 36.81           C  
ATOM   2421  CD1 LEU B 109       3.508  17.585 155.734  1.00 37.62           C  
ATOM   2422  CD2 LEU B 109       2.164  19.109 157.291  1.00 37.17           C  
ATOM   2423  N   LEU B 110      -1.105  20.395 153.916  1.00 35.01           N  
ATOM   2424  CA  LEU B 110      -1.733  20.877 152.715  1.00 35.16           C  
ATOM   2425  C   LEU B 110      -0.687  21.633 151.906  1.00 35.26           C  
ATOM   2426  O   LEU B 110       0.094  22.422 152.432  1.00 35.33           O  
ATOM   2427  CB  LEU B 110      -2.931  21.769 153.046  1.00 35.47           C  
ATOM   2428  CG  LEU B 110      -4.116  21.115 153.781  1.00 36.49           C  
ATOM   2429  CD1 LEU B 110      -5.230  22.129 153.976  1.00 37.83           C  
ATOM   2430  CD2 LEU B 110      -4.632  19.909 153.021  1.00 38.34           C  
ATOM   2431  N   PHE B 111      -0.654  21.334 150.625  1.00 35.10           N  
ATOM   2432  CA  PHE B 111       0.218  22.025 149.735  1.00 34.33           C  
ATOM   2433  C   PHE B 111      -0.609  23.050 149.000  1.00 34.67           C  
ATOM   2434  O   PHE B 111      -1.480  22.695 148.201  1.00 35.06           O  
ATOM   2435  CB  PHE B 111       0.803  21.032 148.746  1.00 34.58           C  
ATOM   2436  CG  PHE B 111       1.552  21.672 147.642  1.00 34.25           C  
ATOM   2437  CD1 PHE B 111       2.592  22.553 147.916  1.00 32.56           C  
ATOM   2438  CD2 PHE B 111       1.224  21.392 146.308  1.00 35.09           C  
ATOM   2439  CE1 PHE B 111       3.305  23.147 146.859  1.00 36.56           C  
ATOM   2440  CE2 PHE B 111       1.920  21.986 145.281  1.00 35.80           C  
ATOM   2441  CZ  PHE B 111       2.971  22.869 145.565  1.00 35.09           C  
ATOM   2442  N   GLY B 112      -0.287  24.318 149.197  1.00 34.73           N  
ATOM   2443  CA  GLY B 112      -0.992  25.351 148.458  1.00 35.47           C  
ATOM   2444  C   GLY B 112      -0.696  26.711 148.997  1.00 36.02           C  
ATOM   2445  O   GLY B 112       0.011  26.855 149.977  1.00 34.52           O  
ATOM   2446  N   ASP B 113      -1.252  27.720 148.337  1.00 36.66           N  
ATOM   2447  CA  ASP B 113      -1.190  29.087 148.820  1.00 38.96           C  
ATOM   2448  C   ASP B 113      -2.332  29.299 149.816  1.00 38.87           C  
ATOM   2449  O   ASP B 113      -3.508  29.215 149.436  1.00 38.98           O  
ATOM   2450  CB  ASP B 113      -1.363  30.026 147.620  1.00 40.12           C  
ATOM   2451  CG  ASP B 113      -1.186  31.496 147.984  1.00 43.07           C  
ATOM   2452  OD1 ASP B 113      -1.643  31.933 149.058  1.00 48.12           O  
ATOM   2453  OD2 ASP B 113      -0.602  32.220 147.149  1.00 49.78           O  
ATOM   2454  N   ALA B 114      -2.005  29.591 151.075  1.00 39.42           N  
ATOM   2455  CA  ALA B 114      -3.032  29.756 152.115  1.00 40.08           C  
ATOM   2456  C   ALA B 114      -4.092  30.796 151.781  1.00 41.08           C  
ATOM   2457  O   ALA B 114      -5.239  30.662 152.194  1.00 40.92           O  
ATOM   2458  CB  ALA B 114      -2.387  30.065 153.473  1.00 40.71           C  
ATOM   2459  N   LEU B 115      -3.707  31.829 151.038  1.00 41.92           N  
ATOM   2460  CA  LEU B 115      -4.629  32.917 150.696  1.00 43.39           C  
ATOM   2461  C   LEU B 115      -5.628  32.468 149.643  1.00 44.06           C  
ATOM   2462  O   LEU B 115      -6.637  33.116 149.421  1.00 44.35           O  
ATOM   2463  CB  LEU B 115      -3.850  34.139 150.231  1.00 43.35           C  
ATOM   2464  CG  LEU B 115      -3.880  35.395 151.116  1.00 44.70           C  
ATOM   2465  CD1 LEU B 115      -4.061  35.128 152.614  1.00 42.69           C  
ATOM   2466  CD2 LEU B 115      -2.648  36.234 150.846  1.00 46.30           C  
ATOM   2467  N   GLN B 116      -5.340  31.328 149.017  1.00 45.15           N  
ATOM   2468  CA  GLN B 116      -6.228  30.733 148.034  1.00 46.09           C  
ATOM   2469  C   GLN B 116      -7.003  29.536 148.597  1.00 46.20           C  
ATOM   2470  O   GLN B 116      -7.864  28.970 147.905  1.00 46.00           O  
ATOM   2471  CB  GLN B 116      -5.426  30.340 146.790  1.00 46.57           C  
ATOM   2472  CG  GLN B 116      -4.730  31.544 146.153  1.00 49.05           C  
ATOM   2473  CD  GLN B 116      -4.243  31.280 144.752  1.00 50.81           C  
ATOM   2474  OE1 GLN B 116      -4.802  31.806 143.798  1.00 53.25           O  
ATOM   2475  NE2 GLN B 116      -3.205  30.441 144.612  1.00 51.62           N  
ATOM   2476  N   LEU B 117      -6.705  29.172 149.847  1.00 45.91           N  
ATOM   2477  CA  LEU B 117      -7.259  27.967 150.483  1.00 46.38           C  
ATOM   2478  C   LEU B 117      -8.322  28.231 151.545  1.00 46.67           C  
ATOM   2479  O   LEU B 117      -8.749  27.305 152.237  1.00 46.56           O  
ATOM   2480  CB  LEU B 117      -6.141  27.118 151.112  1.00 46.13           C  
ATOM   2481  CG  LEU B 117      -5.224  26.291 150.201  1.00 46.87           C  
ATOM   2482  CD1 LEU B 117      -4.342  25.405 151.039  1.00 47.45           C  
ATOM   2483  CD2 LEU B 117      -5.993  25.466 149.176  1.00 47.20           C  
ATOM   2484  N   GLY B 118      -8.752  29.486 151.667  1.00 47.10           N  
ATOM   2485  CA  GLY B 118      -9.750  29.877 152.664  1.00 47.73           C  
ATOM   2486  C   GLY B 118     -11.037  29.063 152.613  1.00 48.10           C  
ATOM   2487  O   GLY B 118     -11.507  28.564 153.643  1.00 47.89           O  
ATOM   2488  N   GLU B 119     -11.593  28.906 151.412  1.00 48.32           N  
ATOM   2489  CA  GLU B 119     -12.875  28.220 151.232  1.00 48.69           C  
ATOM   2490  C   GLU B 119     -12.793  26.730 151.587  1.00 48.40           C  
ATOM   2491  O   GLU B 119     -13.763  26.153 152.084  1.00 48.29           O  
ATOM   2492  CB  GLU B 119     -13.413  28.419 149.806  1.00 49.23           C  
ATOM   2493  CG  GLU B 119     -13.184  29.816 149.210  1.00 50.92           C  
ATOM   2494  CD  GLU B 119     -14.305  30.804 149.511  1.00 53.65           C  
ATOM   2495  OE1 GLU B 119     -14.611  31.057 150.705  1.00 55.06           O  
ATOM   2496  OE2 GLU B 119     -14.880  31.342 148.535  1.00 55.34           O  
ATOM   2497  N   LYS B 120     -11.632  26.124 151.346  1.00 48.21           N  
ATOM   2498  CA  LYS B 120     -11.359  24.739 151.720  1.00 48.61           C  
ATOM   2499  C   LYS B 120     -11.321  24.619 153.246  1.00 48.64           C  
ATOM   2500  O   LYS B 120     -11.896  23.708 153.848  1.00 48.47           O  
ATOM   2501  CB  LYS B 120      -9.994  24.324 151.158  1.00 48.74           C  
ATOM   2502  CG  LYS B 120      -9.638  22.863 151.337  1.00 50.64           C  
ATOM   2503  CD  LYS B 120      -8.187  22.624 150.949  1.00 52.72           C  
ATOM   2504  CE  LYS B 120      -7.786  21.164 151.104  1.00 55.00           C  
ATOM   2505  NZ  LYS B 120      -8.096  20.388 149.858  1.00 56.38           N  
ATOM   2506  N   LEU B 121     -10.631  25.555 153.872  1.00 48.20           N  
ATOM   2507  CA  LEU B 121     -10.446  25.486 155.310  1.00 48.34           C  
ATOM   2508  C   LEU B 121     -11.687  25.838 156.115  1.00 48.53           C  
ATOM   2509  O   LEU B 121     -11.859  25.342 157.226  1.00 48.72           O  
ATOM   2510  CB  LEU B 121      -9.203  26.274 155.710  1.00 48.12           C  
ATOM   2511  CG  LEU B 121      -8.103  25.217 155.511  1.00 48.38           C  
ATOM   2512  CD1 LEU B 121      -7.037  25.574 154.476  1.00 49.07           C  
ATOM   2513  CD2 LEU B 121      -7.535  24.773 156.844  1.00 44.21           C  
ATOM   2514  N   GLU B 122     -12.559  26.664 155.548  1.00 49.00           N  
ATOM   2515  CA  GLU B 122     -13.845  26.961 156.165  1.00 49.71           C  
ATOM   2516  C   GLU B 122     -14.630  25.690 156.447  1.00 49.66           C  
ATOM   2517  O   GLU B 122     -15.423  25.649 157.386  1.00 50.53           O  
ATOM   2518  CB  GLU B 122     -14.668  27.896 155.276  1.00 49.73           C  
ATOM   2519  CG  GLU B 122     -14.423  29.371 155.534  1.00 51.31           C  
ATOM   2520  CD  GLU B 122     -14.534  30.219 154.277  1.00 54.49           C  
ATOM   2521  OE1 GLU B 122     -15.457  29.981 153.471  1.00 54.77           O  
ATOM   2522  OE2 GLU B 122     -13.693  31.127 154.095  1.00 55.82           O  
ATOM   2523  N   LEU B 123     -14.401  24.660 155.635  1.00 49.62           N  
ATOM   2524  CA  LEU B 123     -15.111  23.381 155.757  1.00 49.35           C  
ATOM   2525  C   LEU B 123     -14.744  22.640 157.045  1.00 48.71           C  
ATOM   2526  O   LEU B 123     -15.557  21.887 157.576  1.00 48.33           O  
ATOM   2527  CB  LEU B 123     -14.857  22.473 154.531  1.00 49.49           C  
ATOM   2528  CG  LEU B 123     -15.252  22.865 153.088  1.00 50.30           C  
ATOM   2529  CD1 LEU B 123     -15.063  21.686 152.120  1.00 48.43           C  
ATOM   2530  CD2 LEU B 123     -16.678  23.403 152.978  1.00 49.97           C  
ATOM   2531  N   TYR B 124     -13.527  22.870 157.550  1.00 47.56           N  
ATOM   2532  CA  TYR B 124     -13.035  22.184 158.736  1.00 46.86           C  
ATOM   2533  C   TYR B 124     -13.699  22.722 160.003  1.00 46.39           C  
ATOM   2534  O   TYR B 124     -14.141  23.868 160.036  1.00 45.83           O  
ATOM   2535  CB  TYR B 124     -11.510  22.370 158.877  1.00 46.54           C  
ATOM   2536  CG  TYR B 124     -10.641  21.582 157.905  1.00 46.98           C  
ATOM   2537  CD1 TYR B 124     -10.760  21.761 156.525  1.00 47.84           C  
ATOM   2538  CD2 TYR B 124      -9.662  20.696 158.373  1.00 46.81           C  
ATOM   2539  CE1 TYR B 124      -9.954  21.051 155.630  1.00 47.11           C  
ATOM   2540  CE2 TYR B 124      -8.844  19.983 157.485  1.00 45.94           C  
ATOM   2541  CZ  TYR B 124      -8.994  20.170 156.125  1.00 47.04           C  
ATOM   2542  OH  TYR B 124      -8.205  19.475 155.242  1.00 47.33           O  
ATOM   2543  N   PRO B 125     -13.728  21.907 161.071  1.00 46.33           N  
ATOM   2544  CA  PRO B 125     -14.238  22.419 162.341  1.00 45.95           C  
ATOM   2545  C   PRO B 125     -13.326  23.540 162.827  1.00 44.99           C  
ATOM   2546  O   PRO B 125     -12.164  23.611 162.408  1.00 45.05           O  
ATOM   2547  CB  PRO B 125     -14.137  21.212 163.284  1.00 46.46           C  
ATOM   2548  CG  PRO B 125     -13.942  20.023 162.410  1.00 46.26           C  
ATOM   2549  CD  PRO B 125     -13.284  20.506 161.165  1.00 46.42           C  
ATOM   2550  N   LEU B 126     -13.843  24.406 163.690  1.00 43.85           N  
ATOM   2551  CA  LEU B 126     -13.055  25.526 164.215  1.00 41.83           C  
ATOM   2552  C   LEU B 126     -11.795  25.021 164.924  1.00 41.00           C  
ATOM   2553  O   LEU B 126     -11.775  23.935 165.497  1.00 40.22           O  
ATOM   2554  CB  LEU B 126     -13.896  26.391 165.167  1.00 42.61           C  
ATOM   2555  CG  LEU B 126     -15.089  27.184 164.618  1.00 41.91           C  
ATOM   2556  CD1 LEU B 126     -15.843  27.850 165.750  1.00 42.21           C  
ATOM   2557  CD2 LEU B 126     -14.664  28.218 163.563  1.00 42.65           C  
ATOM   2558  N   PHE B 127     -10.737  25.823 164.846  1.00 39.00           N  
ATOM   2559  CA  PHE B 127      -9.466  25.529 165.465  1.00 38.26           C  
ATOM   2560  C   PHE B 127      -9.360  26.209 166.836  1.00 37.48           C  
ATOM   2561  O   PHE B 127      -9.960  27.246 167.059  1.00 38.20           O  
ATOM   2562  CB  PHE B 127      -8.348  25.998 164.521  1.00 37.99           C  
ATOM   2563  CG  PHE B 127      -8.259  25.189 163.255  1.00 36.27           C  
ATOM   2564  CD1 PHE B 127      -7.551  23.988 163.236  1.00 37.40           C  
ATOM   2565  CD2 PHE B 127      -8.929  25.602 162.087  1.00 37.98           C  
ATOM   2566  CE1 PHE B 127      -7.473  23.198 162.046  1.00 38.80           C  
ATOM   2567  CE2 PHE B 127      -8.858  24.830 160.897  1.00 38.97           C  
ATOM   2568  CZ  PHE B 127      -8.129  23.624 160.886  1.00 38.79           C  
ATOM   2569  N   ASP B 128      -8.624  25.589 167.752  1.00 37.29           N  
ATOM   2570  CA  ASP B 128      -8.326  26.165 169.055  1.00 37.45           C  
ATOM   2571  C   ASP B 128      -7.144  27.106 168.973  1.00 37.16           C  
ATOM   2572  O   ASP B 128      -7.009  27.978 169.808  1.00 36.57           O  
ATOM   2573  CB  ASP B 128      -7.987  25.058 170.061  1.00 37.08           C  
ATOM   2574  CG  ASP B 128      -9.122  24.072 170.215  1.00 39.76           C  
ATOM   2575  OD1 ASP B 128     -10.213  24.542 170.539  1.00 38.68           O  
ATOM   2576  OD2 ASP B 128      -8.926  22.852 169.961  1.00 38.18           O  
ATOM   2577  N   VAL B 129      -6.271  26.881 167.988  1.00 36.47           N  
ATOM   2578  CA  VAL B 129      -5.036  27.662 167.851  1.00 36.59           C  
ATOM   2579  C   VAL B 129      -4.778  27.886 166.362  1.00 36.80           C  
ATOM   2580  O   VAL B 129      -4.901  26.949 165.572  1.00 36.07           O  
ATOM   2581  CB  VAL B 129      -3.787  26.902 168.467  1.00 37.34           C  
ATOM   2582  CG1 VAL B 129      -2.456  27.638 168.122  1.00 38.71           C  
ATOM   2583  CG2 VAL B 129      -3.919  26.686 169.984  1.00 37.20           C  
ATOM   2584  N   LEU B 130      -4.383  29.119 166.007  1.00 36.35           N  
ATOM   2585  CA  LEU B 130      -3.843  29.448 164.702  1.00 36.74           C  
ATOM   2586  C   LEU B 130      -2.420  29.923 164.928  1.00 37.35           C  
ATOM   2587  O   LEU B 130      -2.193  30.791 165.765  1.00 37.46           O  
ATOM   2588  CB  LEU B 130      -4.671  30.605 164.070  1.00 35.72           C  
ATOM   2589  CG  LEU B 130      -4.088  31.232 162.800  1.00 35.32           C  
ATOM   2590  CD1 LEU B 130      -3.950  30.146 161.634  1.00 33.23           C  
ATOM   2591  CD2 LEU B 130      -4.885  32.465 162.298  1.00 37.20           C  
ATOM   2592  N   PHE B 131      -1.464  29.368 164.198  1.00 37.71           N  
ATOM   2593  CA  PHE B 131      -0.057  29.713 164.396  1.00 39.11           C  
ATOM   2594  C   PHE B 131       0.455  30.330 163.101  1.00 39.77           C  
ATOM   2595  O   PHE B 131       0.461  29.665 162.064  1.00 38.83           O  
ATOM   2596  CB  PHE B 131       0.725  28.414 164.749  1.00 39.88           C  
ATOM   2597  CG  PHE B 131       2.191  28.625 165.063  1.00 43.09           C  
ATOM   2598  CD1 PHE B 131       2.661  29.829 165.566  1.00 45.50           C  
ATOM   2599  CD2 PHE B 131       3.100  27.582 164.895  1.00 47.25           C  
ATOM   2600  CE1 PHE B 131       4.041  30.008 165.866  1.00 45.95           C  
ATOM   2601  CE2 PHE B 131       4.492  27.760 165.173  1.00 47.91           C  
ATOM   2602  CZ  PHE B 131       4.946  28.970 165.653  1.00 46.24           C  
ATOM   2603  N   ILE B 132       0.870  31.601 163.171  1.00 39.39           N  
ATOM   2604  CA  ILE B 132       1.392  32.323 162.025  1.00 40.28           C  
ATOM   2605  C   ILE B 132       2.680  33.056 162.401  1.00 40.56           C  
ATOM   2606  O   ILE B 132       3.058  33.113 163.566  1.00 39.89           O  
ATOM   2607  CB  ILE B 132       0.354  33.313 161.447  1.00 39.52           C  
ATOM   2608  CG1 ILE B 132      -0.132  34.287 162.531  1.00 39.51           C  
ATOM   2609  CG2 ILE B 132      -0.841  32.547 160.836  1.00 41.12           C  
ATOM   2610  CD1 ILE B 132      -1.215  35.293 162.041  1.00 39.87           C  
ATOM   2611  N   ASP B 133       3.328  33.634 161.404  1.00 41.43           N  
ATOM   2612  CA  ASP B 133       4.687  34.118 161.555  1.00 42.61           C  
ATOM   2613  C   ASP B 133       4.751  35.541 161.032  1.00 43.28           C  
ATOM   2614  O   ASP B 133       4.586  35.783 159.820  1.00 43.05           O  
ATOM   2615  CB  ASP B 133       5.659  33.212 160.779  1.00 43.43           C  
ATOM   2616  CG  ASP B 133       7.129  33.578 161.002  1.00 45.98           C  
ATOM   2617  OD1 ASP B 133       7.443  34.720 161.412  1.00 44.41           O  
ATOM   2618  OD2 ASP B 133       7.976  32.689 160.777  1.00 49.66           O  
ATOM   2619  N   ALA B 134       4.990  36.482 161.947  1.00 43.74           N  
ATOM   2620  CA  ALA B 134       5.102  37.895 161.580  1.00 44.84           C  
ATOM   2621  C   ALA B 134       6.294  38.181 160.665  1.00 45.80           C  
ATOM   2622  O   ALA B 134       6.405  39.293 160.128  1.00 46.59           O  
ATOM   2623  CB  ALA B 134       5.162  38.765 162.822  1.00 44.15           C  
ATOM   2624  N   ALA B 135       7.176  37.194 160.499  1.00 46.88           N  
ATOM   2625  CA  ALA B 135       8.378  37.336 159.655  1.00 48.19           C  
ATOM   2626  C   ALA B 135       8.211  36.736 158.255  1.00 48.64           C  
ATOM   2627  O   ALA B 135       9.069  36.937 157.375  1.00 49.11           O  
ATOM   2628  CB  ALA B 135       9.593  36.719 160.345  1.00 48.32           C  
ATOM   2629  N   LYS B 136       7.136  35.978 158.051  1.00 48.55           N  
ATOM   2630  CA  LYS B 136       6.806  35.436 156.714  1.00 48.23           C  
ATOM   2631  C   LYS B 136       5.878  36.408 155.993  1.00 47.85           C  
ATOM   2632  O   LYS B 136       5.236  37.245 156.623  1.00 48.05           O  
ATOM   2633  CB  LYS B 136       6.188  34.033 156.808  1.00 47.95           C  
ATOM   2634  CG  LYS B 136       7.172  32.957 157.271  1.00 48.57           C  
ATOM   2635  CD  LYS B 136       6.527  31.577 157.392  1.00 48.60           C  
ATOM   2636  CE  LYS B 136       7.254  30.716 158.461  1.00 53.99           C  
ATOM   2637  NZ  LYS B 136       7.174  29.222 158.255  1.00 53.31           N  
ATOM   2638  N   GLY B 137       5.844  36.331 154.665  1.00 47.60           N  
ATOM   2639  CA  GLY B 137       5.066  37.278 153.864  1.00 45.95           C  
ATOM   2640  C   GLY B 137       3.587  37.091 154.123  1.00 45.35           C  
ATOM   2641  O   GLY B 137       3.161  35.999 154.561  1.00 46.56           O  
ATOM   2642  N   GLN B 138       2.812  38.155 153.903  1.00 43.40           N  
ATOM   2643  CA  GLN B 138       1.353  38.093 153.957  1.00 42.64           C  
ATOM   2644  C   GLN B 138       0.760  37.882 155.360  1.00 41.58           C  
ATOM   2645  O   GLN B 138      -0.397  37.492 155.500  1.00 40.67           O  
ATOM   2646  CB  GLN B 138       0.828  37.025 152.995  1.00 42.48           C  
ATOM   2647  CG  GLN B 138       1.094  37.367 151.507  1.00 45.70           C  
ATOM   2648  CD  GLN B 138       1.019  36.146 150.633  1.00 49.56           C  
ATOM   2649  OE1 GLN B 138       1.690  35.134 150.882  1.00 51.32           O  
ATOM   2650  NE2 GLN B 138       0.202  36.225 149.589  1.00 52.41           N  
ATOM   2651  N   TYR B 139       1.556  38.174 156.383  1.00 41.05           N  
ATOM   2652  CA  TYR B 139       1.168  37.970 157.781  1.00 40.22           C  
ATOM   2653  C   TYR B 139      -0.225  38.566 158.106  1.00 40.09           C  
ATOM   2654  O   TYR B 139      -1.085  37.897 158.662  1.00 38.63           O  
ATOM   2655  CB  TYR B 139       2.243  38.593 158.683  1.00 41.12           C  
ATOM   2656  CG  TYR B 139       1.897  38.699 160.149  1.00 41.70           C  
ATOM   2657  CD1 TYR B 139       1.630  37.565 160.913  1.00 43.88           C  
ATOM   2658  CD2 TYR B 139       1.874  39.938 160.782  1.00 44.31           C  
ATOM   2659  CE1 TYR B 139       1.321  37.673 162.292  1.00 43.91           C  
ATOM   2660  CE2 TYR B 139       1.595  40.055 162.138  1.00 44.10           C  
ATOM   2661  CZ  TYR B 139       1.300  38.929 162.882  1.00 43.75           C  
ATOM   2662  OH  TYR B 139       1.021  39.077 164.234  1.00 42.79           O  
ATOM   2663  N   ARG B 140      -0.440  39.817 157.734  1.00 39.72           N  
ATOM   2664  CA  ARG B 140      -1.715  40.490 158.027  1.00 40.53           C  
ATOM   2665  C   ARG B 140      -2.891  39.860 157.280  1.00 40.09           C  
ATOM   2666  O   ARG B 140      -3.983  39.727 157.840  1.00 40.43           O  
ATOM   2667  CB  ARG B 140      -1.657  41.935 157.588  1.00 40.77           C  
ATOM   2668  CG  ARG B 140      -0.948  42.860 158.496  1.00 43.39           C  
ATOM   2669  CD  ARG B 140      -1.841  44.080 158.640  1.00 48.07           C  
ATOM   2670  NE  ARG B 140      -1.124  45.342 158.529  1.00 51.57           N  
ATOM   2671  CZ  ARG B 140      -1.638  46.523 158.855  1.00 52.24           C  
ATOM   2672  NH1 ARG B 140      -2.874  46.609 159.334  1.00 53.55           N  
ATOM   2673  NH2 ARG B 140      -0.908  47.617 158.711  1.00 54.45           N  
ATOM   2674  N   ARG B 141      -2.676  39.515 156.009  1.00 38.88           N  
ATOM   2675  CA  ARG B 141      -3.719  38.873 155.210  1.00 38.31           C  
ATOM   2676  C   ARG B 141      -4.051  37.508 155.796  1.00 37.11           C  
ATOM   2677  O   ARG B 141      -5.223  37.143 155.863  1.00 35.94           O  
ATOM   2678  CB  ARG B 141      -3.319  38.742 153.729  1.00 38.18           C  
ATOM   2679  CG  ARG B 141      -3.216  40.078 153.009  1.00 41.93           C  
ATOM   2680  CD  ARG B 141      -3.090  39.843 151.525  1.00 46.57           C  
ATOM   2681  NE  ARG B 141      -4.389  39.961 150.866  1.00 51.38           N  
ATOM   2682  CZ  ARG B 141      -4.627  39.601 149.607  1.00 52.82           C  
ATOM   2683  NH1 ARG B 141      -3.659  39.063 148.863  1.00 52.80           N  
ATOM   2684  NH2 ARG B 141      -5.840  39.766 149.092  1.00 53.13           N  
ATOM   2685  N   PHE B 142      -3.028  36.774 156.260  1.00 36.40           N  
ATOM   2686  CA  PHE B 142      -3.263  35.485 156.906  1.00 36.72           C  
ATOM   2687  C   PHE B 142      -4.078  35.630 158.185  1.00 36.87           C  
ATOM   2688  O   PHE B 142      -4.982  34.818 158.465  1.00 37.06           O  
ATOM   2689  CB  PHE B 142      -1.952  34.775 157.270  1.00 36.82           C  
ATOM   2690  CG  PHE B 142      -1.154  34.319 156.088  1.00 39.97           C  
ATOM   2691  CD1 PHE B 142      -1.776  34.026 154.875  1.00 38.32           C  
ATOM   2692  CD2 PHE B 142       0.224  34.165 156.200  1.00 40.68           C  
ATOM   2693  CE1 PHE B 142      -1.028  33.587 153.781  1.00 41.64           C  
ATOM   2694  CE2 PHE B 142       0.988  33.741 155.090  1.00 40.53           C  
ATOM   2695  CZ  PHE B 142       0.357  33.450 153.900  1.00 40.73           C  
ATOM   2696  N   PHE B 143      -3.730  36.643 158.974  1.00 36.53           N  
ATOM   2697  CA  PHE B 143      -4.474  36.940 160.195  1.00 36.99           C  
ATOM   2698  C   PHE B 143      -5.957  37.185 159.874  1.00 37.13           C  
ATOM   2699  O   PHE B 143      -6.825  36.546 160.457  1.00 36.48           O  
ATOM   2700  CB  PHE B 143      -3.879  38.135 160.954  1.00 36.87           C  
ATOM   2701  CG  PHE B 143      -4.515  38.372 162.319  1.00 37.01           C  
ATOM   2702  CD1 PHE B 143      -5.728  39.040 162.450  1.00 35.08           C  
ATOM   2703  CD2 PHE B 143      -3.912  37.894 163.458  1.00 34.74           C  
ATOM   2704  CE1 PHE B 143      -6.312  39.238 163.718  1.00 35.98           C  
ATOM   2705  CE2 PHE B 143      -4.483  38.076 164.725  1.00 37.23           C  
ATOM   2706  CZ  PHE B 143      -5.680  38.776 164.855  1.00 37.85           C  
ATOM   2707  N   ASP B 144      -6.236  38.097 158.944  1.00 37.65           N  
ATOM   2708  CA  ASP B 144      -7.627  38.463 158.633  1.00 38.16           C  
ATOM   2709  C   ASP B 144      -8.434  37.275 158.100  1.00 38.55           C  
ATOM   2710  O   ASP B 144      -9.616  37.110 158.427  1.00 37.66           O  
ATOM   2711  CB  ASP B 144      -7.650  39.624 157.634  1.00 38.55           C  
ATOM   2712  CG  ASP B 144      -7.406  40.974 158.307  1.00 41.71           C  
ATOM   2713  OD1 ASP B 144      -7.338  41.013 159.552  1.00 45.77           O  
ATOM   2714  OD2 ASP B 144      -7.280  41.998 157.613  1.00 40.48           O  
HETATM 2715  N   MSE B 145      -7.783  36.471 157.272  1.00 38.98           N  
HETATM 2716  CA  MSE B 145      -8.416  35.353 156.574  1.00 41.74           C  
HETATM 2717  C   MSE B 145      -8.735  34.166 157.476  1.00 40.13           C  
HETATM 2718  O   MSE B 145      -9.781  33.533 157.318  1.00 38.97           O  
HETATM 2719  CB  MSE B 145      -7.531  34.865 155.421  1.00 41.27           C  
HETATM 2720  CG  MSE B 145      -8.061  33.609 154.764  1.00 44.63           C  
HETATM 2721 SE   MSE B 145      -7.418  33.332 152.952  1.00 49.69          SE  
HETATM 2722  CE  MSE B 145      -8.121  34.975 152.134  1.00 47.11           C  
ATOM   2723  N   TYR B 146      -7.813  33.853 158.391  1.00 39.59           N  
ATOM   2724  CA  TYR B 146      -7.897  32.647 159.211  1.00 39.91           C  
ATOM   2725  C   TYR B 146      -8.349  32.864 160.649  1.00 40.85           C  
ATOM   2726  O   TYR B 146      -8.708  31.921 161.333  1.00 40.81           O  
ATOM   2727  CB  TYR B 146      -6.562  31.881 159.161  1.00 39.57           C  
ATOM   2728  CG  TYR B 146      -6.403  31.232 157.806  1.00 38.55           C  
ATOM   2729  CD1 TYR B 146      -7.128  30.099 157.493  1.00 38.18           C  
ATOM   2730  CD2 TYR B 146      -5.603  31.805 156.812  1.00 36.87           C  
ATOM   2731  CE1 TYR B 146      -7.036  29.505 156.224  1.00 39.02           C  
ATOM   2732  CE2 TYR B 146      -5.501  31.220 155.538  1.00 38.66           C  
ATOM   2733  CZ  TYR B 146      -6.238  30.072 155.258  1.00 39.70           C  
ATOM   2734  OH  TYR B 146      -6.161  29.453 154.024  1.00 41.87           O  
ATOM   2735  N   SER B 147      -8.380  34.110 161.093  1.00 41.55           N  
ATOM   2736  CA  SER B 147      -8.828  34.365 162.447  1.00 42.93           C  
ATOM   2737  C   SER B 147     -10.324  33.999 162.659  1.00 43.06           C  
ATOM   2738  O   SER B 147     -10.685  33.547 163.742  1.00 42.26           O  
ATOM   2739  CB  SER B 147      -8.481  35.788 162.880  1.00 42.98           C  
ATOM   2740  OG  SER B 147      -9.233  36.746 162.191  1.00 44.50           O  
ATOM   2741  N   PRO B 148     -11.182  34.124 161.619  1.00 43.51           N  
ATOM   2742  CA  PRO B 148     -12.573  33.710 161.839  1.00 43.70           C  
ATOM   2743  C   PRO B 148     -12.732  32.196 161.972  1.00 44.03           C  
ATOM   2744  O   PRO B 148     -13.797  31.714 162.354  1.00 44.44           O  
ATOM   2745  CB  PRO B 148     -13.299  34.208 160.574  1.00 44.13           C  
ATOM   2746  CG  PRO B 148     -12.353  35.158 159.934  1.00 44.19           C  
ATOM   2747  CD  PRO B 148     -11.009  34.630 160.243  1.00 43.72           C  
HETATM 2748  N   MSE B 149     -11.668  31.460 161.680  1.00 43.83           N  
HETATM 2749  CA  MSE B 149     -11.683  30.018 161.801  1.00 44.93           C  
HETATM 2750  C   MSE B 149     -11.157  29.508 163.168  1.00 42.07           C  
HETATM 2751  O   MSE B 149     -11.085  28.303 163.423  1.00 41.68           O  
HETATM 2752  CB  MSE B 149     -10.944  29.443 160.611  1.00 44.04           C  
HETATM 2753  CG  MSE B 149     -11.517  30.031 159.283  1.00 45.44           C  
HETATM 2754 SE   MSE B 149     -10.902  28.850 157.977  1.00 54.88          SE  
HETATM 2755  CE  MSE B 149     -10.914  30.101 156.398  1.00 47.84           C  
ATOM   2756  N   VAL B 150     -10.833  30.450 164.042  1.00 40.15           N  
ATOM   2757  CA  VAL B 150     -10.473  30.145 165.427  1.00 38.62           C  
ATOM   2758  C   VAL B 150     -11.722  30.320 166.340  1.00 38.32           C  
ATOM   2759  O   VAL B 150     -12.462  31.297 166.211  1.00 36.94           O  
ATOM   2760  CB  VAL B 150      -9.365  31.107 165.899  1.00 38.96           C  
ATOM   2761  CG1 VAL B 150      -9.039  30.922 167.409  1.00 36.00           C  
ATOM   2762  CG2 VAL B 150      -8.077  30.945 165.005  1.00 37.43           C  
ATOM   2763  N   ARG B 151     -11.942  29.387 167.259  1.00 38.31           N  
ATOM   2764  CA  ARG B 151     -13.096  29.460 168.187  1.00 39.27           C  
ATOM   2765  C   ARG B 151     -12.923  30.624 169.169  1.00 38.69           C  
ATOM   2766  O   ARG B 151     -11.807  31.022 169.433  1.00 38.27           O  
ATOM   2767  CB  ARG B 151     -13.246  28.155 168.974  1.00 39.23           C  
ATOM   2768  CG  ARG B 151     -12.068  27.820 169.842  1.00 41.57           C  
ATOM   2769  CD  ARG B 151     -12.438  26.968 171.047  1.00 43.93           C  
ATOM   2770  NE  ARG B 151     -11.245  26.665 171.852  1.00 42.29           N  
ATOM   2771  CZ  ARG B 151     -10.970  27.227 173.026  1.00 44.80           C  
ATOM   2772  NH1 ARG B 151     -11.809  28.123 173.555  1.00 43.33           N  
ATOM   2773  NH2 ARG B 151      -9.868  26.880 173.676  1.00 46.94           N  
ATOM   2774  N   PRO B 152     -14.032  31.192 169.690  1.00 39.35           N  
ATOM   2775  CA  PRO B 152     -13.937  32.118 170.819  1.00 38.91           C  
ATOM   2776  C   PRO B 152     -13.166  31.474 171.963  1.00 39.06           C  
ATOM   2777  O   PRO B 152     -13.348  30.282 172.249  1.00 39.22           O  
ATOM   2778  CB  PRO B 152     -15.403  32.344 171.216  1.00 39.48           C  
ATOM   2779  CG  PRO B 152     -16.163  32.121 169.974  1.00 39.61           C  
ATOM   2780  CD  PRO B 152     -15.425  31.048 169.216  1.00 39.65           C  
ATOM   2781  N   GLY B 153     -12.272  32.245 172.574  1.00 39.01           N  
ATOM   2782  CA  GLY B 153     -11.406  31.739 173.628  1.00 38.67           C  
ATOM   2783  C   GLY B 153     -10.154  31.063 173.100  1.00 38.61           C  
ATOM   2784  O   GLY B 153      -9.234  30.745 173.870  1.00 39.56           O  
ATOM   2785  N   GLY B 154     -10.112  30.846 171.787  1.00 38.36           N  
ATOM   2786  CA  GLY B 154      -8.963  30.248 171.137  1.00 37.14           C  
ATOM   2787  C   GLY B 154      -7.844  31.249 170.985  1.00 36.49           C  
ATOM   2788  O   GLY B 154      -7.984  32.396 171.359  1.00 36.72           O  
ATOM   2789  N   LEU B 155      -6.737  30.809 170.412  1.00 36.77           N  
ATOM   2790  CA  LEU B 155      -5.509  31.593 170.380  1.00 36.78           C  
ATOM   2791  C   LEU B 155      -5.009  31.771 168.970  1.00 36.86           C  
ATOM   2792  O   LEU B 155      -4.978  30.828 168.189  1.00 38.20           O  
ATOM   2793  CB  LEU B 155      -4.391  30.866 171.134  1.00 36.91           C  
ATOM   2794  CG  LEU B 155      -4.757  30.459 172.565  1.00 38.86           C  
ATOM   2795  CD1 LEU B 155      -3.643  29.625 173.238  1.00 39.92           C  
ATOM   2796  CD2 LEU B 155      -5.110  31.698 173.412  1.00 39.21           C  
ATOM   2797  N   ILE B 156      -4.528  32.964 168.690  1.00 37.35           N  
ATOM   2798  CA  ILE B 156      -3.667  33.178 167.544  1.00 37.19           C  
ATOM   2799  C   ILE B 156      -2.274  33.488 168.087  1.00 37.58           C  
ATOM   2800  O   ILE B 156      -2.089  34.423 168.876  1.00 36.11           O  
ATOM   2801  CB  ILE B 156      -4.185  34.298 166.620  1.00 37.46           C  
ATOM   2802  CG1 ILE B 156      -5.586  33.920 166.131  1.00 38.25           C  
ATOM   2803  CG2 ILE B 156      -3.226  34.428 165.392  1.00 37.32           C  
ATOM   2804  CD1 ILE B 156      -6.277  34.975 165.368  1.00 43.26           C  
ATOM   2805  N   LEU B 157      -1.309  32.667 167.689  1.00 37.46           N  
ATOM   2806  CA  LEU B 157       0.074  32.833 168.137  1.00 39.41           C  
ATOM   2807  C   LEU B 157       0.893  33.360 166.971  1.00 39.88           C  
ATOM   2808  O   LEU B 157       0.869  32.774 165.866  1.00 39.55           O  
ATOM   2809  CB  LEU B 157       0.642  31.483 168.593  1.00 39.76           C  
ATOM   2810  CG  LEU B 157      -0.189  30.740 169.627  1.00 42.58           C  
ATOM   2811  CD1 LEU B 157       0.389  29.320 169.797  1.00 47.18           C  
ATOM   2812  CD2 LEU B 157      -0.224  31.510 170.920  1.00 45.44           C  
ATOM   2813  N   SER B 158       1.591  34.475 167.180  1.00 40.35           N  
ATOM   2814  CA  SER B 158       2.433  35.030 166.114  1.00 41.11           C  
ATOM   2815  C   SER B 158       3.910  34.963 166.525  1.00 41.32           C  
ATOM   2816  O   SER B 158       4.293  35.556 167.529  1.00 41.24           O  
ATOM   2817  CB  SER B 158       2.069  36.483 165.835  1.00 41.32           C  
ATOM   2818  OG  SER B 158       0.697  36.670 165.516  1.00 42.12           O  
ATOM   2819  N   ASP B 159       4.725  34.243 165.759  1.00 40.50           N  
ATOM   2820  CA  ASP B 159       6.164  34.185 165.992  1.00 39.65           C  
ATOM   2821  C   ASP B 159       6.876  35.429 165.426  1.00 39.73           C  
ATOM   2822  O   ASP B 159       6.343  36.092 164.521  1.00 38.50           O  
ATOM   2823  CB  ASP B 159       6.744  32.920 165.332  1.00 40.45           C  
ATOM   2824  CG  ASP B 159       8.149  32.605 165.809  1.00 42.25           C  
ATOM   2825  OD1 ASP B 159       8.585  33.160 166.854  1.00 44.73           O  
ATOM   2826  OD2 ASP B 159       8.823  31.814 165.119  1.00 46.04           O  
ATOM   2827  N   ASN B 160       8.072  35.723 165.950  1.00 38.17           N  
ATOM   2828  CA  ASN B 160       8.960  36.745 165.402  1.00 38.71           C  
ATOM   2829  C   ASN B 160       8.390  38.154 165.434  1.00 38.43           C  
ATOM   2830  O   ASN B 160       8.642  38.965 164.520  1.00 38.15           O  
ATOM   2831  CB  ASN B 160       9.444  36.362 163.975  1.00 38.09           C  
ATOM   2832  CG  ASN B 160      10.182  35.037 163.951  1.00 39.59           C  
ATOM   2833  OD1 ASN B 160      11.138  34.842 164.717  1.00 40.17           O  
ATOM   2834  ND2 ASN B 160       9.751  34.100 163.070  1.00 40.24           N  
ATOM   2835  N   VAL B 161       7.666  38.465 166.517  1.00 38.43           N  
ATOM   2836  CA  VAL B 161       7.030  39.773 166.687  1.00 39.54           C  
ATOM   2837  C   VAL B 161       7.959  40.856 167.280  1.00 40.79           C  
ATOM   2838  O   VAL B 161       7.654  42.052 167.157  1.00 41.01           O  
ATOM   2839  CB  VAL B 161       5.727  39.714 167.555  1.00 39.28           C  
ATOM   2840  CG1 VAL B 161       4.666  38.842 166.903  1.00 38.17           C  
ATOM   2841  CG2 VAL B 161       6.037  39.215 168.937  1.00 39.42           C  
ATOM   2842  N   LEU B 162       9.044  40.454 167.949  1.00 41.51           N  
ATOM   2843  CA  LEU B 162      10.007  41.425 168.477  1.00 43.16           C  
ATOM   2844  C   LEU B 162      11.308  41.512 167.669  1.00 45.29           C  
ATOM   2845  O   LEU B 162      11.851  42.609 167.507  1.00 46.06           O  
ATOM   2846  CB  LEU B 162      10.320  41.188 169.960  1.00 42.71           C  
ATOM   2847  CG  LEU B 162       9.161  41.351 170.950  1.00 41.87           C  
ATOM   2848  CD1 LEU B 162       9.593  40.858 172.335  1.00 42.79           C  
ATOM   2849  CD2 LEU B 162       8.619  42.795 171.017  1.00 42.07           C  
ATOM   2850  N   PHE B 163      11.806  40.372 167.184  1.00 46.57           N  
ATOM   2851  CA  PHE B 163      13.059  40.310 166.411  1.00 48.24           C  
ATOM   2852  C   PHE B 163      12.851  39.634 165.067  1.00 48.53           C  
ATOM   2853  O   PHE B 163      12.098  38.662 164.964  1.00 48.94           O  
ATOM   2854  CB  PHE B 163      14.165  39.579 167.192  1.00 49.20           C  
ATOM   2855  CG  PHE B 163      14.648  40.330 168.401  1.00 51.24           C  
ATOM   2856  CD1 PHE B 163      15.554  41.395 168.264  1.00 53.73           C  
ATOM   2857  CD2 PHE B 163      14.199  39.992 169.675  1.00 53.40           C  
ATOM   2858  CE1 PHE B 163      16.005  42.110 169.379  1.00 54.88           C  
ATOM   2859  CE2 PHE B 163      14.639  40.706 170.803  1.00 55.48           C  
ATOM   2860  CZ  PHE B 163      15.544  41.769 170.654  1.00 53.26           C  
ATOM   2861  N   ASN B 188       3.724  46.516 165.361  1.00 48.99           N  
ATOM   2862  CA  ASN B 188       2.690  45.678 165.966  1.00 48.19           C  
ATOM   2863  C   ASN B 188       1.398  46.403 166.332  1.00 47.65           C  
ATOM   2864  O   ASN B 188       0.451  45.779 166.818  1.00 46.63           O  
ATOM   2865  CB  ASN B 188       3.250  44.960 167.194  1.00 48.65           C  
ATOM   2866  CG  ASN B 188       4.276  43.916 166.832  1.00 49.92           C  
ATOM   2867  OD1 ASN B 188       4.238  43.350 165.738  1.00 52.92           O  
ATOM   2868  ND2 ASN B 188       5.204  43.652 167.745  1.00 50.46           N  
ATOM   2869  N   GLN B 189       1.329  47.712 166.091  1.00 47.33           N  
ATOM   2870  CA  GLN B 189       0.139  48.438 166.532  1.00 47.62           C  
ATOM   2871  C   GLN B 189      -1.170  47.823 166.028  1.00 46.80           C  
ATOM   2872  O   GLN B 189      -2.113  47.709 166.814  1.00 46.50           O  
ATOM   2873  CB  GLN B 189       0.214  49.947 166.270  1.00 48.02           C  
ATOM   2874  CG  GLN B 189       0.826  50.734 167.454  1.00 51.58           C  
ATOM   2875  CD  GLN B 189       0.356  50.238 168.842  1.00 55.27           C  
ATOM   2876  OE1 GLN B 189       1.135  49.656 169.598  1.00 56.72           O  
ATOM   2877  NE2 GLN B 189      -0.917  50.461 169.159  1.00 56.70           N  
ATOM   2878  N   TRP B 190      -1.194  47.342 164.751  1.00 46.51           N  
ATOM   2879  CA  TRP B 190      -2.490  46.902 164.203  1.00 46.63           C  
ATOM   2880  C   TRP B 190      -2.933  45.666 164.950  1.00 46.27           C  
ATOM   2881  O   TRP B 190      -4.114  45.481 165.217  1.00 45.75           O  
ATOM   2882  CB  TRP B 190      -2.433  46.636 162.682  1.00 47.68           C  
ATOM   2883  CG  TRP B 190      -1.709  45.383 162.306  1.00 49.32           C  
ATOM   2884  CD1 TRP B 190      -0.421  45.280 161.868  1.00 51.06           C  
ATOM   2885  CD2 TRP B 190      -2.226  44.032 162.356  1.00 50.57           C  
ATOM   2886  NE1 TRP B 190      -0.099  43.946 161.646  1.00 52.69           N  
ATOM   2887  CE2 TRP B 190      -1.189  43.168 161.936  1.00 51.13           C  
ATOM   2888  CE3 TRP B 190      -3.463  43.475 162.710  1.00 49.42           C  
ATOM   2889  CZ2 TRP B 190      -1.352  41.778 161.869  1.00 50.55           C  
ATOM   2890  CZ3 TRP B 190      -3.619  42.087 162.640  1.00 50.71           C  
ATOM   2891  CH2 TRP B 190      -2.567  41.261 162.224  1.00 49.30           C  
ATOM   2892  N   LEU B 191      -1.968  44.830 165.313  1.00 45.74           N  
ATOM   2893  CA  LEU B 191      -2.277  43.609 166.015  1.00 45.98           C  
ATOM   2894  C   LEU B 191      -2.779  43.947 167.413  1.00 46.37           C  
ATOM   2895  O   LEU B 191      -3.788  43.408 167.870  1.00 45.99           O  
ATOM   2896  CB  LEU B 191      -1.030  42.721 166.105  1.00 45.94           C  
ATOM   2897  CG  LEU B 191      -1.276  41.429 166.871  1.00 45.39           C  
ATOM   2898  CD1 LEU B 191      -2.415  40.609 166.226  1.00 44.64           C  
ATOM   2899  CD2 LEU B 191       0.027  40.626 166.926  1.00 47.12           C  
ATOM   2900  N   LEU B 192      -2.077  44.863 168.078  1.00 46.72           N  
ATOM   2901  CA  LEU B 192      -2.365  45.160 169.480  1.00 47.31           C  
ATOM   2902  C   LEU B 192      -3.723  45.836 169.716  1.00 47.65           C  
ATOM   2903  O   LEU B 192      -4.267  45.743 170.829  1.00 48.64           O  
ATOM   2904  CB  LEU B 192      -1.215  45.958 170.095  1.00 48.10           C  
ATOM   2905  CG  LEU B 192       0.093  45.153 170.115  1.00 48.30           C  
ATOM   2906  CD1 LEU B 192       1.319  46.026 170.385  1.00 50.09           C  
ATOM   2907  CD2 LEU B 192       0.017  43.987 171.085  1.00 49.87           C  
ATOM   2908  N   GLU B 193      -4.273  46.497 168.691  1.00 46.54           N  
ATOM   2909  CA  GLU B 193      -5.550  47.221 168.827  1.00 45.85           C  
ATOM   2910  C   GLU B 193      -6.718  46.650 168.001  1.00 44.33           C  
ATOM   2911  O   GLU B 193      -7.805  47.246 167.926  1.00 43.21           O  
ATOM   2912  CB  GLU B 193      -5.368  48.728 168.587  1.00 46.40           C  
ATOM   2913  CG  GLU B 193      -4.823  49.144 167.233  1.00 47.79           C  
ATOM   2914  CD  GLU B 193      -4.711  50.668 167.110  1.00 48.41           C  
ATOM   2915  OE1 GLU B 193      -4.533  51.358 168.149  1.00 51.97           O  
ATOM   2916  OE2 GLU B 193      -4.810  51.190 165.974  1.00 51.72           O  
ATOM   2917  N   HIS B 194      -6.485  45.482 167.404  1.00 42.50           N  
ATOM   2918  CA  HIS B 194      -7.512  44.718 166.709  1.00 40.93           C  
ATOM   2919  C   HIS B 194      -8.587  44.288 167.706  1.00 40.28           C  
ATOM   2920  O   HIS B 194      -8.281  43.592 168.694  1.00 39.22           O  
ATOM   2921  CB  HIS B 194      -6.886  43.444 166.137  1.00 40.45           C  
ATOM   2922  CG  HIS B 194      -7.410  43.080 164.792  1.00 39.54           C  
ATOM   2923  ND1 HIS B 194      -8.631  42.461 164.611  1.00 38.97           N  
ATOM   2924  CD2 HIS B 194      -6.897  43.280 163.555  1.00 38.02           C  
ATOM   2925  CE1 HIS B 194      -8.837  42.281 163.319  1.00 37.58           C  
ATOM   2926  NE2 HIS B 194      -7.806  42.776 162.657  1.00 37.16           N  
ATOM   2927  N   PRO B 195      -9.840  44.688 167.468  1.00 39.63           N  
ATOM   2928  CA  PRO B 195     -10.848  44.574 168.527  1.00 40.45           C  
ATOM   2929  C   PRO B 195     -11.274  43.182 169.042  1.00 40.14           C  
ATOM   2930  O   PRO B 195     -11.597  43.063 170.230  1.00 42.29           O  
ATOM   2931  CB  PRO B 195     -12.052  45.332 167.953  1.00 40.05           C  
ATOM   2932  CG  PRO B 195     -11.850  45.323 166.499  1.00 39.65           C  
ATOM   2933  CD  PRO B 195     -10.377  45.383 166.286  1.00 40.24           C  
ATOM   2934  N   GLN B 196     -11.315  42.162 168.207  1.00 39.55           N  
ATOM   2935  CA  GLN B 196     -11.890  40.886 168.664  1.00 39.88           C  
ATOM   2936  C   GLN B 196     -10.876  40.038 169.458  1.00 38.64           C  
ATOM   2937  O   GLN B 196     -11.155  38.886 169.808  1.00 37.75           O  
ATOM   2938  CB  GLN B 196     -12.440  40.085 167.473  1.00 40.12           C  
ATOM   2939  CG  GLN B 196     -13.659  39.209 167.797  1.00 41.56           C  
ATOM   2940  CD  GLN B 196     -14.341  38.607 166.556  1.00 42.09           C  
ATOM   2941  OE1 GLN B 196     -13.793  38.605 165.441  1.00 44.75           O  
ATOM   2942  NE2 GLN B 196     -15.536  38.070 166.761  1.00 43.99           N  
ATOM   2943  N   TYR B 197      -9.715  40.620 169.739  1.00 37.99           N  
ATOM   2944  CA  TYR B 197      -8.632  39.879 170.377  1.00 38.39           C  
ATOM   2945  C   TYR B 197      -8.058  40.639 171.529  1.00 38.67           C  
ATOM   2946  O   TYR B 197      -8.056  41.871 171.552  1.00 37.71           O  
ATOM   2947  CB  TYR B 197      -7.530  39.548 169.375  1.00 38.98           C  
ATOM   2948  CG  TYR B 197      -8.040  38.582 168.357  1.00 40.60           C  
ATOM   2949  CD1 TYR B 197      -8.702  39.027 167.207  1.00 41.33           C  
ATOM   2950  CD2 TYR B 197      -7.938  37.216 168.578  1.00 41.62           C  
ATOM   2951  CE1 TYR B 197      -9.215  38.107 166.284  1.00 42.48           C  
ATOM   2952  CE2 TYR B 197      -8.434  36.305 167.662  1.00 41.71           C  
ATOM   2953  CZ  TYR B 197      -9.078  36.753 166.537  1.00 41.72           C  
ATOM   2954  OH  TYR B 197      -9.573  35.811 165.644  1.00 45.54           O  
ATOM   2955  N   ASP B 198      -7.610  39.856 172.502  1.00 38.44           N  
ATOM   2956  CA  ASP B 198      -6.943  40.321 173.669  1.00 38.98           C  
ATOM   2957  C   ASP B 198      -5.497  39.894 173.422  1.00 38.77           C  
ATOM   2958  O   ASP B 198      -5.181  38.723 173.537  1.00 37.22           O  
ATOM   2959  CB  ASP B 198      -7.513  39.514 174.815  1.00 40.49           C  
ATOM   2960  CG  ASP B 198      -7.320  40.156 176.094  1.00 44.26           C  
ATOM   2961  OD1 ASP B 198      -6.196  40.677 176.319  1.00 49.90           O  
ATOM   2962  OD2 ASP B 198      -8.294  40.130 176.871  1.00 48.85           O  
ATOM   2963  N   THR B 199      -4.626  40.824 173.067  1.00 38.42           N  
ATOM   2964  CA  THR B 199      -3.273  40.440 172.617  1.00 39.68           C  
ATOM   2965  C   THR B 199      -2.186  40.962 173.555  1.00 39.91           C  
ATOM   2966  O   THR B 199      -2.196  42.137 173.936  1.00 40.36           O  
ATOM   2967  CB  THR B 199      -3.002  40.934 171.172  1.00 39.45           C  
ATOM   2968  OG1 THR B 199      -3.943  40.334 170.272  1.00 39.84           O  
ATOM   2969  CG2 THR B 199      -1.563  40.573 170.714  1.00 40.14           C  
ATOM   2970  N   ARG B 200      -1.268  40.082 173.940  0.50 40.26           N  
ATOM   2972  CA  ARG B 200      -0.060  40.489 174.657  0.50 40.36           C  
ATOM   2974  C   ARG B 200       1.148  39.897 173.958  0.50 40.94           C  
ATOM   2976  O   ARG B 200       1.041  38.857 173.286  0.50 40.48           O  
ATOM   2978  CB  ARG B 200      -0.090  40.039 176.120  0.50 40.21           C  
ATOM   2980  CG  ARG B 200      -1.336  40.505 176.861  0.50 40.63           C  
ATOM   2982  CD  ARG B 200      -1.033  40.943 178.268  0.50 40.84           C  
ATOM   2984  NE  ARG B 200      -0.597  42.332 178.303  0.50 42.55           N  
ATOM   2986  CZ  ARG B 200       0.619  42.735 178.642  0.50 41.30           C  
ATOM   2988  NH1 ARG B 200       1.544  41.851 178.993  0.50 41.69           N  
ATOM   2990  NH2 ARG B 200       0.905  44.029 178.634  0.50 38.80           N  
ATOM   2992  N   ILE B 201       2.291  40.568 174.101  1.00 41.33           N  
ATOM   2993  CA  ILE B 201       3.547  40.079 173.509  1.00 42.11           C  
ATOM   2994  C   ILE B 201       4.431  39.554 174.612  1.00 42.97           C  
ATOM   2995  O   ILE B 201       4.701  40.287 175.565  1.00 42.41           O  
ATOM   2996  CB  ILE B 201       4.320  41.193 172.755  1.00 43.51           C  
ATOM   2997  CG1 ILE B 201       3.483  41.699 171.546  1.00 41.87           C  
ATOM   2998  CG2 ILE B 201       5.697  40.624 172.282  1.00 43.00           C  
ATOM   2999  CD1 ILE B 201       3.994  42.947 170.943  1.00 48.00           C  
ATOM   3000  N   PHE B 202       4.861  38.294 174.494  1.00 43.68           N  
ATOM   3001  CA  PHE B 202       5.723  37.666 175.507  1.00 44.42           C  
ATOM   3002  C   PHE B 202       7.178  37.701 175.051  1.00 43.79           C  
ATOM   3003  O   PHE B 202       7.467  37.314 173.927  1.00 43.49           O  
ATOM   3004  CB  PHE B 202       5.306  36.209 175.759  1.00 46.01           C  
ATOM   3005  CG  PHE B 202       4.106  36.050 176.675  1.00 49.05           C  
ATOM   3006  CD1 PHE B 202       3.493  37.158 177.267  1.00 51.57           C  
ATOM   3007  CD2 PHE B 202       3.621  34.783 176.980  1.00 52.64           C  
ATOM   3008  CE1 PHE B 202       2.387  37.010 178.110  1.00 51.53           C  
ATOM   3009  CE2 PHE B 202       2.519  34.621 177.827  1.00 53.52           C  
ATOM   3010  CZ  PHE B 202       1.904  35.743 178.396  1.00 51.64           C  
ATOM   3011  N   PRO B 203       8.095  38.158 175.927  1.00 43.58           N  
ATOM   3012  CA  PRO B 203       9.504  38.303 175.566  1.00 43.52           C  
ATOM   3013  C   PRO B 203      10.274  36.978 175.690  1.00 43.56           C  
ATOM   3014  O   PRO B 203      11.172  36.847 176.543  1.00 43.67           O  
ATOM   3015  CB  PRO B 203      10.016  39.330 176.588  1.00 42.88           C  
ATOM   3016  CG  PRO B 203       9.187  39.080 177.807  1.00 43.96           C  
ATOM   3017  CD  PRO B 203       7.844  38.568 177.322  1.00 43.39           C  
ATOM   3018  N   VAL B 204       9.909  36.016 174.852  1.00 43.02           N  
ATOM   3019  CA  VAL B 204      10.582  34.732 174.790  1.00 43.47           C  
ATOM   3020  C   VAL B 204      10.922  34.435 173.327  1.00 43.07           C  
ATOM   3021  O   VAL B 204      10.137  34.749 172.427  1.00 42.65           O  
ATOM   3022  CB  VAL B 204       9.711  33.619 175.397  1.00 44.09           C  
ATOM   3023  CG1 VAL B 204       8.344  33.516 174.690  1.00 44.35           C  
ATOM   3024  CG2 VAL B 204      10.441  32.322 175.385  1.00 45.43           C  
ATOM   3025  N   GLY B 205      12.084  33.832 173.099  1.00 42.45           N  
ATOM   3026  CA  GLY B 205      12.574  33.611 171.741  1.00 41.64           C  
ATOM   3027  C   GLY B 205      12.665  34.946 171.027  1.00 41.14           C  
ATOM   3028  O   GLY B 205      13.234  35.896 171.561  1.00 41.01           O  
ATOM   3029  N   ASP B 206      12.079  35.021 169.832  1.00 40.09           N  
ATOM   3030  CA  ASP B 206      12.078  36.249 169.027  1.00 39.35           C  
ATOM   3031  C   ASP B 206      10.838  37.128 169.263  1.00 39.61           C  
ATOM   3032  O   ASP B 206      10.546  38.042 168.489  1.00 39.68           O  
ATOM   3033  CB  ASP B 206      12.232  35.873 167.539  1.00 38.88           C  
ATOM   3034  CG  ASP B 206      13.630  35.373 167.215  1.00 38.02           C  
ATOM   3035  OD1 ASP B 206      14.567  35.784 167.931  1.00 38.68           O  
ATOM   3036  OD2 ASP B 206      13.825  34.595 166.251  1.00 36.14           O  
ATOM   3037  N   GLY B 207      10.114  36.853 170.346  1.00 39.88           N  
ATOM   3038  CA  GLY B 207       8.846  37.520 170.612  1.00 40.47           C  
ATOM   3039  C   GLY B 207       7.708  36.685 170.048  1.00 41.90           C  
ATOM   3040  O   GLY B 207       7.732  36.274 168.859  1.00 41.07           O  
ATOM   3041  N   ILE B 208       6.748  36.388 170.917  1.00 41.95           N  
ATOM   3042  CA  ILE B 208       5.556  35.659 170.535  1.00 42.43           C  
ATOM   3043  C   ILE B 208       4.361  36.479 170.978  1.00 43.41           C  
ATOM   3044  O   ILE B 208       4.238  36.791 172.167  1.00 43.38           O  
ATOM   3045  CB  ILE B 208       5.482  34.296 171.202  1.00 43.19           C  
ATOM   3046  CG1 ILE B 208       6.744  33.452 170.888  1.00 43.05           C  
ATOM   3047  CG2 ILE B 208       4.192  33.557 170.725  1.00 43.71           C  
ATOM   3048  CD1 ILE B 208       6.789  32.152 171.693  1.00 45.64           C  
ATOM   3049  N   ALA B 209       3.503  36.859 170.034  1.00 42.88           N  
ATOM   3050  CA  ALA B 209       2.255  37.519 170.424  1.00 42.91           C  
ATOM   3051  C   ALA B 209       1.217  36.440 170.639  1.00 42.80           C  
ATOM   3052  O   ALA B 209       1.129  35.480 169.848  1.00 42.93           O  
ATOM   3053  CB  ALA B 209       1.803  38.460 169.354  1.00 43.90           C  
ATOM   3054  N   ILE B 210       0.472  36.558 171.727  1.00 41.54           N  
ATOM   3055  CA  ILE B 210      -0.614  35.618 172.026  1.00 41.19           C  
ATOM   3056  C   ILE B 210      -1.893  36.421 172.034  1.00 39.93           C  
ATOM   3057  O   ILE B 210      -2.120  37.253 172.918  1.00 39.29           O  
ATOM   3058  CB  ILE B 210      -0.411  34.942 173.373  1.00 42.04           C  
ATOM   3059  CG1 ILE B 210       0.936  34.204 173.364  1.00 43.57           C  
ATOM   3060  CG2 ILE B 210      -1.523  33.944 173.645  1.00 42.46           C  
ATOM   3061  CD1 ILE B 210       1.649  34.434 174.618  1.00 51.29           C  
ATOM   3062  N   SER B 211      -2.699  36.209 171.005  1.00 38.81           N  
ATOM   3063  CA  SER B 211      -3.968  36.912 170.877  1.00 38.35           C  
ATOM   3064  C   SER B 211      -5.074  35.966 171.285  1.00 37.98           C  
ATOM   3065  O   SER B 211      -5.240  34.905 170.687  1.00 38.37           O  
ATOM   3066  CB  SER B 211      -4.177  37.362 169.415  1.00 38.74           C  
ATOM   3067  OG  SER B 211      -3.068  38.123 168.968  1.00 39.98           O  
ATOM   3068  N   ILE B 212      -5.826  36.327 172.320  1.00 35.26           N  
ATOM   3069  CA  ILE B 212      -6.903  35.479 172.775  1.00 34.83           C  
ATOM   3070  C   ILE B 212      -8.243  35.998 172.239  1.00 34.75           C  
ATOM   3071  O   ILE B 212      -8.637  37.132 172.504  1.00 33.27           O  
ATOM   3072  CB  ILE B 212      -6.970  35.419 174.326  1.00 34.77           C  
ATOM   3073  CG1 ILE B 212      -5.562  35.142 174.907  1.00 33.78           C  
ATOM   3074  CG2 ILE B 212      -7.988  34.359 174.780  1.00 33.88           C  
ATOM   3075  CD1 ILE B 212      -5.576  35.019 176.469  1.00 35.71           C  
ATOM   3076  N   LYS B 213      -8.941  35.136 171.519  1.00 34.21           N  
ATOM   3077  CA  LYS B 213     -10.156  35.547 170.823  1.00 35.12           C  
ATOM   3078  C   LYS B 213     -11.279  35.783 171.812  1.00 36.12           C  
ATOM   3079  O   LYS B 213     -11.600  34.917 172.640  1.00 35.25           O  
ATOM   3080  CB  LYS B 213     -10.554  34.524 169.760  1.00 34.74           C  
ATOM   3081  CG  LYS B 213     -11.688  35.024 168.860  1.00 35.44           C  
ATOM   3082  CD  LYS B 213     -11.805  34.197 167.615  1.00 34.38           C  
ATOM   3083  CE  LYS B 213     -12.699  34.912 166.609  1.00 33.29           C  
ATOM   3084  NZ  LYS B 213     -12.881  34.062 165.403  1.00 33.64           N  
ATOM   3085  N   ARG B 214     -11.863  36.986 171.722  1.00 37.78           N  
ATOM   3086  CA  ARG B 214     -12.950  37.395 172.604  1.00 39.35           C  
ATOM   3087  C   ARG B 214     -14.240  36.713 172.192  1.00 40.07           C  
ATOM   3088  O   ARG B 214     -14.383  36.271 171.042  1.00 40.21           O  
ATOM   3089  CB  ARG B 214     -13.133  38.917 172.593  1.00 39.75           C  
ATOM   3090  CG  ARG B 214     -11.996  39.679 173.246  1.00 43.20           C  
ATOM   3091  CD  ARG B 214     -12.375  41.122 173.540  1.00 49.41           C  
ATOM   3092  NE  ARG B 214     -11.309  41.771 174.301  1.00 55.43           N  
ATOM   3093  CZ  ARG B 214     -10.322  42.483 173.759  1.00 57.94           C  
ATOM   3094  NH1 ARG B 214     -10.278  42.669 172.447  1.00 59.04           N  
ATOM   3095  NH2 ARG B 214      -9.387  43.028 174.535  1.00 59.59           N  
ATOM   3096  N   GLU B 215     -15.178  36.639 173.135  1.00 40.89           N  
ATOM   3097  CA  GLU B 215     -16.460  35.983 172.923  1.00 42.32           C  
ATOM   3098  C   GLU B 215     -17.288  36.610 171.794  1.00 42.91           C  
ATOM   3099  O   GLU B 215     -17.681  37.776 171.860  1.00 43.65           O  
ATOM   3100  CB  GLU B 215     -17.255  35.964 174.233  1.00 42.40           C  
ATOM   3101  CG  GLU B 215     -18.698  35.513 174.081  1.00 44.31           C  
ATOM   3102  CD  GLU B 215     -19.135  34.600 175.203  1.00 45.46           C  
ATOM   3103  OE1 GLU B 215     -18.250  33.991 175.852  1.00 47.50           O  
ATOM   3104  OE2 GLU B 215     -20.352  34.481 175.437  1.00 47.79           O  
ATOM   3105  N   GLU B 226     -34.752  50.283 158.378  1.00 31.21           N  
ATOM   3106  CA  GLU B 226     -36.187  50.358 158.070  1.00 31.18           C  
ATOM   3107  C   GLU B 226     -36.459  51.472 157.049  1.00 31.79           C  
ATOM   3108  O   GLU B 226     -35.707  52.459 156.983  1.00 31.09           O  
ATOM   3109  CB  GLU B 226     -37.002  50.597 159.359  1.00 30.78           C  
ATOM   3110  CG  GLU B 226     -36.392  51.629 160.313  1.00 30.65           C  
ATOM   3111  CD  GLU B 226     -37.283  52.020 161.489  1.00 30.75           C  
ATOM   3112  OE1 GLU B 226     -38.285  51.333 161.787  1.00 30.45           O  
ATOM   3113  OE2 GLU B 226     -36.968  53.030 162.141  1.00 28.43           O  
ATOM   3114  N   GLY B 227     -37.513  51.306 156.245  1.00 31.78           N  
ATOM   3115  CA  GLY B 227     -38.072  52.411 155.447  1.00 32.73           C  
ATOM   3116  C   GLY B 227     -39.485  52.727 155.927  1.00 33.56           C  
ATOM   3117  O   GLY B 227     -39.657  53.246 157.034  1.00 33.99           O  
ATOM   3118  N   HIS B 228     -40.486  52.391 155.091  1.00 33.64           N  
ATOM   3119  CA  HIS B 228     -41.932  52.400 155.429  1.00 33.73           C  
ATOM   3120  C   HIS B 228     -42.237  51.677 156.740  1.00 33.76           C  
ATOM   3121  O   HIS B 228     -43.298  51.878 157.353  1.00 33.46           O  
ATOM   3122  CB  HIS B 228     -42.740  51.703 154.325  1.00 33.79           C  
ATOM   3123  CG  HIS B 228     -43.232  52.619 153.252  1.00 33.69           C  
ATOM   3124  ND1 HIS B 228     -42.693  52.635 151.983  1.00 34.14           N  
ATOM   3125  CD2 HIS B 228     -44.227  53.536 153.249  1.00 33.91           C  
ATOM   3126  CE1 HIS B 228     -43.332  53.528 151.247  1.00 34.18           C  
ATOM   3127  NE2 HIS B 228     -44.267  54.089 151.991  1.00 34.27           N  
ATOM   3128  N   HIS B 229     -41.308  50.800 157.115  1.00 33.90           N  
ATOM   3129  CA  HIS B 229     -41.245  50.136 158.409  1.00 33.93           C  
ATOM   3130  C   HIS B 229     -41.335  51.128 159.563  1.00 33.98           C  
ATOM   3131  O   HIS B 229     -41.857  50.799 160.630  1.00 33.65           O  
ATOM   3132  CB  HIS B 229     -39.900  49.401 158.544  1.00 34.20           C  
ATOM   3133  CG  HIS B 229     -39.589  48.460 157.420  1.00 34.85           C  
ATOM   3134  ND1 HIS B 229     -40.542  47.656 156.842  1.00 34.48           N  
ATOM   3135  CD2 HIS B 229     -38.421  48.162 156.800  1.00 34.03           C  
ATOM   3136  CE1 HIS B 229     -39.987  46.917 155.899  1.00 34.28           C  
ATOM   3137  NE2 HIS B 229     -38.701  47.202 155.854  1.00 36.88           N  
ATOM   3138  N   HIS B 230     -40.794  52.329 159.347  1.00 34.27           N  
ATOM   3139  CA  HIS B 230     -40.728  53.350 160.387  1.00 34.58           C  
ATOM   3140  C   HIS B 230     -42.099  53.900 160.755  1.00 35.22           C  
ATOM   3141  O   HIS B 230     -42.325  54.253 161.912  1.00 35.04           O  
ATOM   3142  CB  HIS B 230     -39.793  54.499 159.998  1.00 34.57           C  
ATOM   3143  CG  HIS B 230     -39.792  55.619 160.988  1.00 33.95           C  
ATOM   3144  ND1 HIS B 230     -39.335  55.465 162.281  1.00 32.88           N  
ATOM   3145  CD2 HIS B 230     -40.235  56.895 160.890  1.00 32.82           C  
ATOM   3146  CE1 HIS B 230     -39.483  56.608 162.931  1.00 33.31           C  
ATOM   3147  NE2 HIS B 230     -40.021  57.493 162.107  1.00 32.69           N  
ATOM   3148  N   HIS B 231     -42.994  53.987 159.770  1.00 36.18           N  
ATOM   3149  CA  HIS B 231     -44.417  54.200 160.029  1.00 37.27           C  
ATOM   3150  C   HIS B 231     -44.889  53.075 160.942  1.00 37.98           C  
ATOM   3151  O   HIS B 231     -44.246  52.026 161.000  1.00 38.34           O  
ATOM   3152  CB  HIS B 231     -45.217  54.144 158.725  1.00 37.34           C  
ATOM   3153  CG  HIS B 231     -45.477  55.480 158.102  1.00 37.51           C  
ATOM   3154  ND1 HIS B 231     -44.878  55.881 156.927  1.00 37.64           N  
ATOM   3155  CD2 HIS B 231     -46.294  56.493 158.473  1.00 37.68           C  
ATOM   3156  CE1 HIS B 231     -45.305  57.091 156.609  1.00 37.54           C  
ATOM   3157  NE2 HIS B 231     -46.164  57.486 157.532  1.00 37.62           N  
ATOM   3158  N   HIS B 232     -45.999  53.299 161.647  1.00 38.74           N  
ATOM   3159  CA  HIS B 232     -46.660  52.290 162.506  1.00 39.42           C  
ATOM   3160  C   HIS B 232     -45.797  51.612 163.585  1.00 39.59           C  
ATOM   3161  O   HIS B 232     -46.298  51.289 164.680  1.00 39.94           O  
ATOM   3162  CB  HIS B 232     -47.420  51.228 161.674  1.00 39.65           C  
ATOM   3163  CG  HIS B 232     -46.569  50.511 160.662  1.00 40.37           C  
ATOM   3164  ND1 HIS B 232     -45.551  49.643 161.016  1.00 40.79           N  
ATOM   3165  CD2 HIS B 232     -46.587  50.536 159.307  1.00 41.05           C  
ATOM   3166  CE1 HIS B 232     -44.981  49.162 159.923  1.00 40.85           C  
ATOM   3167  NE2 HIS B 232     -45.590  49.689 158.872  1.00 40.73           N  
ATOM   3168  N   HIS B 233     -44.514  51.412 163.256  1.00 39.59           N  
ATOM   3169  CA  HIS B 233     -43.589  50.539 163.982  1.00 39.62           C  
ATOM   3170  C   HIS B 233     -44.073  49.106 164.254  1.00 39.75           C  
ATOM   3171  O   HIS B 233     -43.479  48.109 163.702  1.00 39.66           O  
ATOM   3172  CB  HIS B 233     -42.999  51.195 165.229  1.00 39.77           C  
ATOM   3173  CG  HIS B 233     -41.733  51.948 164.961  1.00 38.90           C  
ATOM   3174  ND1 HIS B 233     -41.580  53.282 165.277  1.00 39.37           N  
ATOM   3175  CD2 HIS B 233     -40.568  51.560 164.389  1.00 39.41           C  
ATOM   3176  CE1 HIS B 233     -40.372  53.681 164.916  1.00 40.05           C  
ATOM   3177  NE2 HIS B 233     -39.739  52.657 164.367  1.00 38.89           N  
TER    3178      HIS B 233                                                      
END
MOLECULE T0509.pdb
ATOM      1  N   ASN     3      22.807  39.978 177.332  1.00 85.83           N  
ATOM      2  CA  ASN     3      23.661  39.212 178.288  1.00 85.41           C  
ATOM      3  C   ASN     3      22.931  38.088 179.010  1.00 84.96           C  
ATOM      4  O   ASN     3      23.158  36.907 178.737  1.00 84.71           O  
ATOM      5  CB  ASN     3      24.283  40.169 179.320  1.00 85.60           C  
ATOM      6  N   ALA     4      22.046  38.464 179.926  1.00 84.06           N  
ATOM      7  CA  ALA     4      21.329  37.491 180.736  1.00 83.06           C  
ATOM      8  C   ALA     4      20.380  36.562 180.006  1.00 82.36           C  
ATOM      9  O   ALA     4      20.103  35.452 180.462  1.00 82.26           O  
ATOM     10  CB  ALA     4      20.607  38.203 181.891  1.00 82.85           C  
ATOM     11  N   PHE     5      19.905  37.014 178.857  1.00 81.23           N  
ATOM     12  CA  PHE     5      19.008  36.219 178.041  1.00 79.90           C  
ATOM     13  C   PHE     5      19.689  34.923 177.583  1.00 78.36           C  
ATOM     14  O   PHE     5      19.070  33.859 177.581  1.00 77.95           O  
ATOM     15  CB  PHE     5      18.590  37.011 176.806  1.00 80.49           C  
ATOM     16  CG  PHE     5      17.733  36.228 175.838  1.00 82.32           C  
ATOM     17  CD1 PHE     5      16.356  36.140 176.022  1.00 83.80           C  
ATOM     18  CD2 PHE     5      18.306  35.556 174.759  1.00 83.29           C  
ATOM     19  CE1 PHE     5      15.564  35.398 175.148  1.00 85.48           C  
ATOM     20  CE2 PHE     5      17.522  34.810 173.883  1.00 84.01           C  
ATOM     21  CZ  PHE     5      16.149  34.731 174.079  1.00 84.46           C  
ATOM     22  N   GLU     6      20.960  35.016 177.195  1.00 77.13           N  
ATOM     23  CA  GLU     6      21.696  33.867 176.675  1.00 75.49           C  
ATOM     24  C   GLU     6      22.150  32.844 177.700  1.00 73.34           C  
ATOM     25  O   GLU     6      22.237  31.656 177.384  1.00 73.19           O  
ATOM     26  CB  GLU     6      22.890  34.355 175.852  1.00 76.28           C  
ATOM     27  CG  GLU     6      22.530  35.380 174.776  1.00 80.27           C  
ATOM     28  CD  GLU     6      23.464  36.574 174.805  1.00 85.77           C  
ATOM     29  OE1 GLU     6      23.350  37.389 175.746  1.00 88.31           O  
ATOM     30  OE2 GLU     6      24.317  36.691 173.899  1.00 86.53           O  
ATOM     31  N   TYR     7      22.433  33.303 178.915  1.00 71.13           N  
ATOM     32  CA  TYR     7      22.835  32.402 179.977  1.00 68.99           C  
ATOM     33  C   TYR     7      21.579  31.589 180.326  1.00 65.55           C  
ATOM     34  O   TYR     7      21.657  30.395 180.624  1.00 65.44           O  
ATOM     35  CB  TYR     7      23.336  33.190 181.196  1.00 70.74           C  
ATOM     36  CG  TYR     7      24.578  32.584 181.806  1.00 76.24           C  
ATOM     37  CD1 TYR     7      25.455  33.360 182.555  1.00 82.00           C  
ATOM     38  CD2 TYR     7      24.886  31.230 181.618  1.00 81.17           C  
ATOM     39  CE1 TYR     7      26.612  32.812 183.107  1.00 85.04           C  
ATOM     40  CE2 TYR     7      26.039  30.671 182.169  1.00 84.74           C  
ATOM     41  CZ  TYR     7      26.897  31.469 182.910  1.00 86.92           C  
ATOM     42  OH  TYR     7      28.037  30.923 183.455  1.00 89.05           O  
ATOM     43  N   LEU     8      20.416  32.239 180.292  1.00 61.60           N  
ATOM     44  CA  LEU     8      19.157  31.545 180.549  1.00 57.37           C  
ATOM     45  C   LEU     8      18.973  30.589 179.350  1.00 54.56           C  
ATOM     46  O   LEU     8      18.710  29.399 179.527  1.00 52.14           O  
ATOM     47  CB  LEU     8      17.989  32.541 180.606  1.00 57.65           C  
ATOM     48  CG  LEU     8      16.729  32.079 181.345  1.00 56.45           C  
ATOM     49  CD1 LEU     8      17.110  31.130 182.479  1.00 55.09           C  
ATOM     50  CD2 LEU     8      15.999  33.299 181.898  1.00 57.98           C  
ATOM     51  N   ARG     9      19.120  31.107 178.129  1.00 52.49           N  
ATOM     52  CA  ARG     9      18.958  30.280 176.932  1.00 52.08           C  
ATOM     53  C   ARG     9      19.926  29.104 176.942  1.00 51.11           C  
ATOM     54  O   ARG     9      19.532  27.959 176.699  1.00 50.55           O  
ATOM     55  CB  ARG     9      19.141  31.125 175.658  1.00 52.07           C  
ATOM     56  CG  ARG     9      19.009  30.335 174.364  1.00 54.77           C  
ATOM     57  CD  ARG     9      18.455  31.194 173.237  1.00 60.14           C  
ATOM     58  NE  ARG     9      19.283  32.362 172.952  1.00 64.34           N  
ATOM     59  CZ  ARG     9      20.451  32.322 172.316  1.00 68.63           C  
ATOM     60  NH1 ARG     9      20.939  31.164 171.888  1.00 69.94           N  
ATOM     61  NH2 ARG     9      21.131  33.441 172.107  1.00 68.03           N  
ATOM     62  N   THR    10      21.189  29.388 177.240  1.00 50.60           N  
ATOM     63  CA  THR    10      22.217  28.357 177.275  1.00 50.83           C  
ATOM     64  C   THR    10      21.903  27.262 178.291  1.00 49.87           C  
ATOM     65  O   THR    10      22.003  26.074 177.983  1.00 50.46           O  
ATOM     66  CB  THR    10      23.603  28.971 177.581  1.00 51.38           C  
ATOM     67  OG1 THR    10      23.896  29.986 176.608  1.00 51.78           O  
ATOM     68  CG2 THR    10      24.680  27.904 177.521  1.00 50.61           C  
ATOM     69  N   TYR    11      21.521  27.657 179.499  1.00 48.77           N  
ATOM     70  CA  TYR    11      21.185  26.675 180.524  1.00 48.46           C  
ATOM     71  C   TYR    11      19.954  25.857 180.130  1.00 46.71           C  
ATOM     72  O   TYR    11      19.919  24.643 180.332  1.00 46.43           O  
ATOM     73  CB  TYR    11      20.893  27.339 181.860  1.00 50.01           C  
ATOM     74  CG  TYR    11      20.510  26.319 182.902  1.00 52.08           C  
ATOM     75  CD1 TYR    11      21.471  25.474 183.449  1.00 54.43           C  
ATOM     76  CD2 TYR    11      19.173  26.115 183.256  1.00 52.57           C  
ATOM     77  CE1 TYR    11      21.121  24.459 184.331  1.00 56.00           C  
ATOM     78  CE2 TYR    11      18.812  25.101 184.141  1.00 56.55           C  
ATOM     79  CZ  TYR    11      19.795  24.275 184.668  1.00 55.82           C  
ATOM     80  OH  TYR    11      19.458  23.278 185.549  1.00 57.24           O  
ATOM     81  N   VAL    12      18.942  26.515 179.570  1.00 45.29           N  
ATOM     82  CA  VAL    12      17.728  25.810 179.173  1.00 43.79           C  
ATOM     83  C   VAL    12      17.970  24.915 177.964  1.00 44.31           C  
ATOM     84  O   VAL    12      17.489  23.784 177.919  1.00 44.59           O  
ATOM     85  CB  VAL    12      16.575  26.796 178.864  1.00 44.09           C  
ATOM     86  CG1 VAL    12      15.364  26.044 178.307  1.00 38.90           C  
ATOM     87  CG2 VAL    12      16.187  27.557 180.138  1.00 40.82           C  
ATOM     88  N   GLU    13      18.706  25.418 176.982  1.00 45.77           N  
ATOM     89  CA  GLU    13      18.991  24.621 175.801  1.00 47.52           C  
ATOM     90  C   GLU    13      19.917  23.460 176.170  1.00 48.95           C  
ATOM     91  O   GLU    13      19.657  22.312 175.826  1.00 49.14           O  
ATOM     92  CB  GLU    13      19.621  25.491 174.701  1.00 47.27           C  
ATOM     93  CG  GLU    13      18.594  26.143 173.776  1.00 46.73           C  
ATOM     94  CD  GLU    13      19.213  27.051 172.733  1.00 47.14           C  
ATOM     95  OE1 GLU    13      18.462  27.802 172.070  1.00 46.58           O  
ATOM     96  OE2 GLU    13      20.451  27.011 172.568  1.00 48.58           O  
ATOM     97  N   SER    14      20.991  23.759 176.893  1.00 50.77           N  
ATOM     98  CA  SER    14      21.962  22.741 177.291  1.00 52.40           C  
ATOM     99  C   SER    14      21.408  21.764 178.315  1.00 52.24           C  
ATOM    100  O   SER    14      22.111  20.838 178.732  1.00 52.54           O  
ATOM    101  CB  SER    14      23.201  23.405 177.884  1.00 53.25           C  
ATOM    102  OG  SER    14      22.943  23.882 179.203  1.00 55.29           O  
ATOM    103  N   THR    15      20.152  21.956 178.709  1.00 51.44           N  
ATOM    104  CA  THR    15      19.565  21.104 179.726  1.00 50.00           C  
ATOM    105  C   THR    15      18.254  20.425 179.338  1.00 49.00           C  
ATOM    106  O   THR    15      17.740  19.581 180.077  1.00 48.09           O  
ATOM    107  CB  THR    15      19.421  21.928 181.040  1.00 50.48           C  
ATOM    108  OG1 THR    15      19.790  21.124 182.163  1.00 53.93           O  
ATOM    109  CG2 THR    15      18.042  22.429 181.224  1.00 49.25           C  
ATOM    110  N   THR    16      17.709  20.805 178.186  1.00 47.75           N  
ATOM    111  CA  THR    16      16.482  20.191 177.693  1.00 48.20           C  
ATOM    112  C   THR    16      16.843  18.834 177.065  1.00 50.22           C  
ATOM    113  O   THR    16      17.668  18.759 176.143  1.00 52.31           O  
ATOM    114  CB  THR    16      15.795  21.062 176.622  1.00 46.53           C  
ATOM    115  OG1 THR    16      15.318  22.271 177.220  1.00 45.88           O  
ATOM    116  CG2 THR    16      14.625  20.317 175.997  1.00 42.52           C  
ATOM    117  N   GLU    17      16.228  17.764 177.563  1.00 51.38           N  
ATOM    118  CA  GLU    17      16.493  16.421 177.062  1.00 53.69           C  
ATOM    119  C   GLU    17      16.282  16.387 175.556  1.00 54.77           C  
ATOM    120  O   GLU    17      15.184  16.632 175.051  1.00 53.95           O  
ATOM    121  CB  GLU    17      15.569  15.413 177.748  1.00 54.69           C  
ATOM    122  CG  GLU    17      15.799  13.980 177.324  1.00 57.95           C  
ATOM    123  CD  GLU    17      14.636  13.081 177.692  1.00 63.33           C  
ATOM    124  OE1 GLU    17      14.500  12.002 177.075  1.00 66.36           O  
ATOM    125  OE2 GLU    17      13.861  13.451 178.601  1.00 65.09           O  
ATOM    126  N   THR    18      17.345  16.068 174.836  1.00 56.14           N  
ATOM    127  CA  THR    18      17.289  16.046 173.385  1.00 57.87           C  
ATOM    128  C   THR    18      16.318  15.040 172.775  1.00 57.45           C  
ATOM    129  O   THR    18      16.215  13.904 173.238  1.00 57.97           O  
ATOM    130  CB  THR    18      18.709  15.817 172.779  1.00 58.68           C  
ATOM    131  OG1 THR    18      19.251  14.577 173.255  1.00 60.50           O  
ATOM    132  CG2 THR    18      19.660  16.960 173.166  1.00 57.87           C  
ATOM    133  N   ASP    19      15.587  15.481 171.752  1.00 56.51           N  
ATOM    134  CA  ASP    19      14.670  14.600 171.041  1.00 56.34           C  
ATOM    135  C   ASP    19      15.294  14.421 169.648  1.00 55.42           C  
ATOM    136  O   ASP    19      15.637  15.401 168.973  1.00 56.44           O  
ATOM    137  CB  ASP    19      13.263  15.210 170.904  1.00 55.60           C  
ATOM    138  CG  ASP    19      12.348  14.348 170.050  1.00 57.72           C  
ATOM    139  OD1 ASP    19      12.857  13.661 169.136  1.00 62.68           O  
ATOM    140  OD2 ASP    19      11.122  14.363 170.272  1.00 59.68           O  
ATOM    141  N   ALA    20      15.442  13.171 169.218  1.00 53.78           N  
ATOM    142  CA  ALA    20      16.054  12.863 167.926  1.00 51.44           C  
ATOM    143  C   ALA    20      15.281  13.437 166.750  1.00 49.39           C  
ATOM    144  O   ALA    20      15.857  14.097 165.881  1.00 47.69           O  
ATOM    145  CB  ALA    20      16.208  11.346 167.765  1.00 51.74           C  
ATOM    146  N   ALA    21      13.978  13.189 166.728  1.00 46.99           N  
ATOM    147  CA  ALA    21      13.140  13.693 165.655  1.00 44.89           C  
ATOM    148  C   ALA    21      13.208  15.221 165.610  1.00 43.57           C  
ATOM    149  O   ALA    21      13.247  15.812 164.534  1.00 43.64           O  
ATOM    150  CB  ALA    21      11.692  13.224 165.853  1.00 44.67           C  
ATOM    151  N   VAL    22      13.229  15.860 166.779  1.00 41.64           N  
ATOM    152  CA  VAL    22      13.292  17.319 166.849  1.00 39.09           C  
ATOM    153  C   VAL    22      14.655  17.846 166.414  1.00 38.15           C  
ATOM    154  O   VAL    22      14.745  18.838 165.688  1.00 36.18           O  
ATOM    155  CB  VAL    22      12.990  17.834 168.282  1.00 38.83           C  
ATOM    156  CG1 VAL    22      13.345  19.328 168.388  1.00 37.70           C  
ATOM    157  CG2 VAL    22      11.520  17.610 168.622  1.00 36.88           C  
ATOM    158  N   ALA    23      15.719  17.184 166.860  1.00 38.78           N  
ATOM    159  CA  ALA    23      17.070  17.602 166.500  1.00 39.37           C  
ATOM    160  C   ALA    23      17.260  17.469 164.984  1.00 38.28           C  
ATOM    161  O   ALA    23      17.908  18.299 164.359  1.00 37.20           O  
ATOM    162  CB  ALA    23      18.100  16.748 167.239  1.00 39.71           C  
ATOM    163  N   ARG    24      16.692  16.419 164.402  1.00 39.08           N  
ATOM    164  CA  ARG    24      16.800  16.188 162.969  1.00 40.86           C  
ATOM    165  C   ARG    24      16.093  17.324 162.217  1.00 40.75           C  
ATOM    166  O   ARG    24      16.635  17.874 161.249  1.00 40.53           O  
ATOM    167  CB  ARG    24      16.183  14.820 162.628  1.00 41.74           C  
ATOM    168  CG  ARG    24      16.075  14.501 161.150  1.00 49.23           C  
ATOM    169  CD  ARG    24      17.421  14.551 160.446  1.00 54.35           C  
ATOM    170  NE  ARG    24      17.462  13.599 159.339  1.00 59.94           N  
ATOM    171  CZ  ARG    24      18.095  13.812 158.194  1.00 59.09           C  
ATOM    172  NH1 ARG    24      18.742  14.952 158.002  1.00 62.71           N  
ATOM    173  NH2 ARG    24      18.073  12.890 157.241  1.00 60.22           N  
ATOM    174  N   ALA    25      14.891  17.680 162.668  1.00 40.03           N  
ATOM    175  CA  ALA    25      14.128  18.752 162.037  1.00 40.19           C  
ATOM    176  C   ALA    25      14.839  20.105 162.157  1.00 40.52           C  
ATOM    177  O   ALA    25      14.731  20.951 161.261  1.00 41.05           O  
ATOM    178  CB  ALA    25      12.728  18.829 162.649  1.00 40.91           C  
ATOM    179  N   ARG    26      15.564  20.307 163.256  1.00 40.54           N  
ATOM    180  CA  ARG    26      16.300  21.552 163.475  1.00 40.67           C  
ATOM    181  C   ARG    26      17.542  21.569 162.573  1.00 41.44           C  
ATOM    182  O   ARG    26      17.953  22.620 162.081  1.00 43.15           O  
ATOM    183  CB  ARG    26      16.716  21.666 164.945  1.00 40.06           C  
ATOM    184  CG  ARG    26      17.206  23.049 165.344  1.00 41.06           C  
ATOM    185  CD  ARG    26      17.244  23.192 166.860  1.00 39.59           C  
ATOM    186  NE  ARG    26      15.918  23.381 167.448  1.00 36.02           N  
ATOM    187  CZ  ARG    26      15.195  24.489 167.308  1.00 35.63           C  
ATOM    188  NH1 ARG    26      15.676  25.501 166.600  1.00 33.06           N  
ATOM    189  NH2 ARG    26      14.002  24.588 167.884  1.00 31.51           N  
ATOM    190  N   GLU    27      18.141  20.402 162.354  1.00 43.09           N  
ATOM    191  CA  GLU    27      19.306  20.309 161.483  1.00 45.53           C  
ATOM    192  C   GLU    27      18.829  20.549 160.048  1.00 44.47           C  
ATOM    193  O   GLU    27      19.434  21.325 159.304  1.00 44.94           O  
ATOM    194  CB  GLU    27      19.947  18.925 161.590  1.00 47.21           C  
ATOM    195  CG  GLU    27      21.435  18.965 161.907  1.00 56.44           C  
ATOM    196  CD  GLU    27      22.265  19.573 160.788  1.00 64.19           C  
ATOM    197  OE1 GLU    27      22.345  20.818 160.694  1.00 65.65           O  
ATOM    198  OE2 GLU    27      22.830  18.791 159.994  1.00 68.30           O  
ATOM    199  N   ASP    28      17.742  19.882 159.656  1.00 43.22           N  
ATOM    200  CA  ASP    28      17.198  20.053 158.307  1.00 42.84           C  
ATOM    201  C   ASP    28      16.904  21.517 157.990  1.00 42.31           C  
ATOM    202  O   ASP    28      17.295  22.014 156.935  1.00 42.99           O  
ATOM    203  CB  ASP    28      15.924  19.225 158.124  1.00 41.28           C  
ATOM    204  CG  ASP    28      16.209  17.744 157.975  1.00 42.74           C  
ATOM    205  OD1 ASP    28      17.404  17.380 157.943  1.00 44.72           O  
ATOM    206  OD2 ASP    28      15.246  16.946 157.885  1.00 45.45           O  
ATOM    207  N   ALA    29      16.225  22.209 158.902  1.00 41.52           N  
ATOM    208  CA  ALA    29      15.882  23.616 158.687  1.00 40.18           C  
ATOM    209  C   ALA    29      17.117  24.477 158.480  1.00 39.57           C  
ATOM    210  O   ALA    29      17.132  25.362 157.620  1.00 39.63           O  
ATOM    211  CB  ALA    29      15.058  24.154 159.864  1.00 40.56           C  
ATOM    212  N   ALA    30      18.146  24.209 159.275  1.00 39.17           N  
ATOM    213  CA  ALA    30      19.398  24.949 159.198  1.00 40.05           C  
ATOM    214  C   ALA    30      20.107  24.679 157.868  1.00 39.78           C  
ATOM    215  O   ALA    30      20.666  25.591 157.260  1.00 40.00           O  
ATOM    216  CB  ALA    30      20.305  24.561 160.365  1.00 40.11           C  
ATOM    217  N   GLU    31      20.085  23.427 157.422  1.00 38.65           N  
ATOM    218  CA  GLU    31      20.718  23.066 156.159  1.00 38.87           C  
ATOM    219  C   GLU    31      20.078  23.764 154.959  1.00 38.60           C  
ATOM    220  O   GLU    31      20.739  23.995 153.950  1.00 39.71           O  
ATOM    221  CB  GLU    31      20.668  21.552 155.963  1.00 39.36           C  
ATOM    222  CG  GLU    31      21.691  20.795 156.786  1.00 38.74           C  
ATOM    223  CD  GLU    31      21.437  19.310 156.790  1.00 43.41           C  
ATOM    224  OE1 GLU    31      20.865  18.809 155.803  1.00 47.35           O  
ATOM    225  OE2 GLU    31      21.820  18.637 157.764  1.00 48.92           O  
ATOM    226  N   PHE    32      18.796  24.105 155.072  1.00 37.78           N  
ATOM    227  CA  PHE    32      18.071  24.765 153.985  1.00 36.92           C  
ATOM    228  C   PHE    32      17.846  26.256 154.223  1.00 37.72           C  
ATOM    229  O   PHE    32      17.134  26.913 153.457  1.00 36.82           O  
ATOM    230  CB  PHE    32      16.727  24.064 153.758  1.00 35.46           C  
ATOM    231  CG  PHE    32      16.852  22.714 153.100  1.00 35.81           C  
ATOM    232  CD1 PHE    32      16.814  22.592 151.708  1.00 32.38           C  
ATOM    233  CD2 PHE    32      16.998  21.562 153.873  1.00 29.85           C  
ATOM    234  CE1 PHE    32      16.925  21.341 151.098  1.00 34.55           C  
ATOM    235  CE2 PHE    32      17.113  20.313 153.274  1.00 32.22           C  
ATOM    236  CZ  PHE    32      17.074  20.200 151.884  1.00 34.18           C  
ATOM    237  N   GLY    33      18.448  26.777 155.289  1.00 38.67           N  
ATOM    238  CA  GLY    33      18.321  28.190 155.623  1.00 38.55           C  
ATOM    239  C   GLY    33      16.923  28.661 155.983  1.00 37.08           C  
ATOM    240  O   GLY    33      16.572  29.818 155.756  1.00 36.54           O  
ATOM    241  N   LEU    34      16.129  27.765 156.564  1.00 38.38           N  
ATOM    242  CA  LEU    34      14.751  28.092 156.938  1.00 38.59           C  
ATOM    243  C   LEU    34      14.629  28.720 158.321  1.00 37.66           C  
ATOM    244  O   LEU    34      15.399  28.397 159.220  1.00 39.17           O  
ATOM    245  CB  LEU    34      13.887  26.827 156.897  1.00 38.83           C  
ATOM    246  CG  LEU    34      13.963  25.954 155.641  1.00 38.72           C  
ATOM    247  CD1 LEU    34      13.204  24.651 155.855  1.00 40.78           C  
ATOM    248  CD2 LEU    34      13.393  26.715 154.462  1.00 38.26           C  
ATOM    249  N   PRO    35      13.655  29.627 158.500  1.00 38.39           N  
ATOM    250  CA  PRO    35      13.416  30.306 159.780  1.00 39.03           C  
ATOM    251  C   PRO    35      12.913  29.261 160.777  1.00 40.77           C  
ATOM    252  O   PRO    35      11.820  28.713 160.611  1.00 41.07           O  
ATOM    253  CB  PRO    35      12.323  31.328 159.454  1.00 39.92           C  
ATOM    254  CG  PRO    35      12.269  31.377 157.939  1.00 39.36           C  
ATOM    255  CD  PRO    35      12.651  30.009 157.495  1.00 37.58           C  
ATOM    256  N   ALA    36      13.702  29.004 161.819  1.00 41.01           N  
ATOM    257  CA  ALA    36      13.344  27.997 162.818  1.00 40.99           C  
ATOM    258  C   ALA    36      13.320  28.519 164.250  1.00 40.41           C  
ATOM    259  O   ALA    36      14.364  28.860 164.803  1.00 41.47           O  
ATOM    260  CB  ALA    36      14.304  26.820 162.726  1.00 39.29           C  
ATOM    261  N   PRO    37      12.131  28.565 164.869  1.00 39.76           N  
ATOM    262  CA  PRO    37      11.992  29.042 166.250  1.00 37.91           C  
ATOM    263  C   PRO    37      12.926  28.246 167.151  1.00 36.44           C  
ATOM    264  O   PRO    37      13.077  27.035 166.962  1.00 35.90           O  
ATOM    265  CB  PRO    37      10.524  28.755 166.578  1.00 38.50           C  
ATOM    266  CG  PRO    37       9.850  28.774 165.250  1.00 40.52           C  
ATOM    267  CD  PRO    37      10.840  28.108 164.325  1.00 40.07           C  
ATOM    268  N   ASP    38      13.533  28.908 168.135  1.00 34.43           N  
ATOM    269  CA  ASP    38      14.448  28.213 169.038  1.00 34.87           C  
ATOM    270  C   ASP    38      13.717  27.211 169.936  1.00 35.84           C  
ATOM    271  O   ASP    38      12.491  27.094 169.887  1.00 34.82           O  
ATOM    272  CB  ASP    38      15.273  29.226 169.873  1.00 35.43           C  
ATOM    273  CG  ASP    38      14.428  30.055 170.830  1.00 37.24           C  
ATOM    274  OD1 ASP    38      13.181  30.018 170.734  1.00 39.36           O  
ATOM    275  OD2 ASP    38      15.029  30.747 171.687  1.00 41.15           O  
ATOM    276  N   GLU    39      14.478  26.489 170.752  1.00 35.27           N  
ATOM    277  CA  GLU    39      13.916  25.474 171.629  1.00 35.36           C  
ATOM    278  C   GLU    39      12.890  25.983 172.629  1.00 34.78           C  
ATOM    279  O   GLU    39      11.907  25.298 172.910  1.00 35.10           O  
ATOM    280  CB  GLU    39      15.040  24.754 172.372  1.00 36.46           C  
ATOM    281  CG  GLU    39      14.579  23.753 173.433  1.00 39.24           C  
ATOM    282  CD  GLU    39      13.757  22.609 172.864  1.00 42.52           C  
ATOM    283  OE1 GLU    39      14.081  22.141 171.754  1.00 46.69           O  
ATOM    284  OE2 GLU    39      12.795  22.167 173.532  1.00 44.19           O  
ATOM    285  N   MET    40      13.120  27.181 173.155  1.00 33.85           N  
ATOM    286  CA  MET    40      12.224  27.769 174.137  1.00 33.31           C  
ATOM    287  C   MET    40      10.880  28.153 173.523  1.00 31.59           C  
ATOM    288  O   MET    40       9.831  27.983 174.152  1.00 30.49           O  
ATOM    289  CB  MET    40      12.890  28.989 174.807  1.00 32.67           C  
ATOM    290  CG  MET    40      13.914  28.637 175.903  1.00 37.51           C  
ATOM    291  SD  MET    40      14.599  30.227 176.837  1.00 48.82          SE  
ATOM    292  CE  MET    40      16.150  29.483 177.672  1.00 47.77           C  
ATOM    293  N   THR    41      10.918  28.669 172.297  1.00 29.68           N  
ATOM    294  CA  THR    41       9.699  29.043 171.600  1.00 27.32           C  
ATOM    295  C   THR    41       8.914  27.755 171.285  1.00 26.43           C  
ATOM    296  O   THR    41       7.687  27.737 171.383  1.00 27.19           O  
ATOM    297  CB  THR    41      10.025  29.797 170.296  1.00 28.66           C  
ATOM    298  OG1 THR    41      10.738  30.996 170.619  1.00 26.10           O  
ATOM    299  CG2 THR    41       8.741  30.156 169.536  1.00 25.19           C  
ATOM    300  N   GLY    42       9.621  26.685 170.914  1.00 24.88           N  
ATOM    301  CA  GLY    42       8.967  25.414 170.622  1.00 26.74           C  
ATOM    302  C   GLY    42       8.266  24.847 171.858  1.00 27.45           C  
ATOM    303  O   GLY    42       7.145  24.339 171.751  1.00 27.33           O  
ATOM    304  N   GLN    43       8.910  24.928 173.025  1.00 26.78           N  
ATOM    305  CA  GLN    43       8.324  24.434 174.276  1.00 28.12           C  
ATOM    306  C   GLN    43       7.010  25.190 174.550  1.00 27.73           C  
ATOM    307  O   GLN    43       6.005  24.584 174.947  1.00 27.06           O  
ATOM    308  CB  GLN    43       9.332  24.610 175.437  1.00 27.92           C  
ATOM    309  CG  GLN    43      10.505  23.632 175.352  1.00 28.63           C  
ATOM    310  CD  GLN    43      11.578  23.886 176.399  1.00 34.03           C  
ATOM    311  OE1 GLN    43      11.355  24.607 177.373  1.00 36.82           O  
ATOM    312  NE2 GLN    43      12.752  23.290 176.204  1.00 32.59           N  
ATOM    313  N   LEU    44       7.014  26.508 174.335  1.00 27.40           N  
ATOM    314  CA  LEU    44       5.796  27.299 174.512  1.00 27.16           C  
ATOM    315  C   LEU    44       4.729  26.819 173.503  1.00 26.87           C  
ATOM    316  O   LEU    44       3.531  26.837 173.811  1.00 27.06           O  
ATOM    317  CB  LEU    44       6.061  28.795 174.302  1.00 25.60           C  
ATOM    318  CG  LEU    44       4.779  29.647 174.278  1.00 29.19           C  
ATOM    319  CD1 LEU    44       4.004  29.444 175.576  1.00 27.74           C  
ATOM    320  CD2 LEU    44       5.128  31.120 174.085  1.00 24.87           C  
ATOM    321  N   LEU    45       5.143  26.401 172.301  1.00 27.58           N  
ATOM    322  CA  LEU    45       4.174  25.911 171.307  1.00 29.21           C  
ATOM    323  C   LEU    45       3.531  24.614 171.836  1.00 28.50           C  
ATOM    324  O   LEU    45       2.331  24.399 171.691  1.00 29.78           O  
ATOM    325  CB  LEU    45       4.850  25.671 169.936  1.00 27.83           C  
ATOM    326  CG  LEU    45       5.300  26.957 169.216  1.00 30.54           C  
ATOM    327  CD1 LEU    45       5.894  26.601 167.853  1.00 32.59           C  
ATOM    328  CD2 LEU    45       4.104  27.908 169.041  1.00 29.82           C  
ATOM    329  N   THR    46       4.333  23.758 172.457  1.00 27.80           N  
ATOM    330  CA  THR    46       3.826  22.513 173.030  1.00 28.58           C  
ATOM    331  C   THR    46       2.826  22.835 174.150  1.00 27.31           C  
ATOM    332  O   THR    46       1.801  22.178 174.283  1.00 28.48           O  
ATOM    333  CB  THR    46       4.977  21.679 173.620  1.00 27.74           C  
ATOM    334  OG1 THR    46       5.956  21.451 172.604  1.00 28.37           O  
ATOM    335  CG2 THR    46       4.473  20.348 174.134  1.00 28.82           C  
ATOM    336  N   THR    47       3.136  23.852 174.953  1.00 28.69           N  
ATOM    337  CA  THR    47       2.279  24.266 176.060  1.00 27.73           C  
ATOM    338  C   THR    47       0.915  24.733 175.570  1.00 27.47           C  
ATOM    339  O   THR    47      -0.114  24.348 176.127  1.00 27.23           O  
ATOM    340  CB  THR    47       2.920  25.417 176.865  1.00 28.09           C  
ATOM    341  OG1 THR    47       4.170  24.984 177.415  1.00 27.40           O  
ATOM    342  CG2 THR    47       1.993  25.863 178.001  1.00 23.26           C  
ATOM    343  N   LEU    48       0.904  25.562 174.529  1.00 26.00           N  
ATOM    344  CA  LEU    48      -0.357  26.062 173.992  1.00 24.82           C  
ATOM    345  C   LEU    48      -1.138  24.957 173.294  1.00 24.93           C  
ATOM    346  O   LEU    48      -2.370  24.923 173.361  1.00 24.34           O  
ATOM    347  CB  LEU    48      -0.108  27.225 173.025  1.00 26.01           C  
ATOM    348  CG  LEU    48       0.505  28.475 173.683  1.00 30.70           C  
ATOM    349  CD1 LEU    48       0.765  29.551 172.624  1.00 30.77           C  
ATOM    350  CD2 LEU    48      -0.440  29.004 174.770  1.00 26.08           C  
ATOM    351  N   ALA    49      -0.428  24.053 172.620  1.00 25.73           N  
ATOM    352  CA  ALA    49      -1.091  22.953 171.935  1.00 26.68           C  
ATOM    353  C   ALA    49      -1.715  22.043 172.989  1.00 26.17           C  
ATOM    354  O   ALA    49      -2.765  21.445 172.761  1.00 25.74           O  
ATOM    355  CB  ALA    49      -0.084  22.163 171.077  1.00 24.82           C  
ATOM    356  N   ALA    50      -1.056  21.941 174.143  1.00 27.11           N  
ATOM    357  CA  ALA    50      -1.529  21.106 175.245  1.00 27.80           C  
ATOM    358  C   ALA    50      -2.642  21.769 176.057  1.00 29.60           C  
ATOM    359  O   ALA    50      -3.560  21.095 176.516  1.00 32.07           O  
ATOM    360  CB  ALA    50      -0.368  20.750 176.165  1.00 29.92           C  
ATOM    361  N   THR    51      -2.567  23.083 176.235  1.00 29.29           N  
ATOM    362  CA  THR    51      -3.576  23.787 177.009  1.00 30.18           C  
ATOM    363  C   THR    51      -4.841  24.127 176.208  1.00 32.02           C  
ATOM    364  O   THR    51      -5.941  24.063 176.767  1.00 31.22           O  
ATOM    365  CB  THR    51      -2.987  25.075 177.666  1.00 29.68           C  
ATOM    366  OG1 THR    51      -2.623  26.035 176.658  1.00 29.87           O  
ATOM    367  CG2 THR    51      -1.740  24.711 178.484  1.00 27.26           C  
ATOM    368  N   THR    52      -4.701  24.475 174.924  1.00 31.53           N  
ATOM    369  CA  THR    52      -5.877  24.802 174.119  1.00 31.58           C  
ATOM    370  C   THR    52      -6.810  23.597 174.026  1.00 33.91           C  
ATOM    371  O   THR    52      -6.387  22.444 174.151  1.00 34.00           O  
ATOM    372  CB  THR    52      -5.499  25.330 172.708  1.00 30.61           C  
ATOM    373  OG1 THR    52      -4.605  24.419 172.059  1.00 27.87           O  
ATOM    374  CG2 THR    52      -4.853  26.704 172.834  1.00 28.08           C  
ATOM    375  N   ASN    53      -8.085  23.868 173.784  1.00 36.96           N  
ATOM    376  CA  ASN    53      -9.107  22.823 173.780  1.00 41.28           C  
ATOM    377  C   ASN    53      -9.338  21.999 172.524  1.00 42.44           C  
ATOM    378  O   ASN    53      -9.875  22.501 171.540  1.00 42.24           O  
ATOM    379  CB  ASN    53     -10.426  23.449 174.254  1.00 41.27           C  
ATOM    380  CG  ASN    53     -11.429  22.416 174.745  1.00 44.44           C  
ATOM    381  OD1 ASN    53     -11.209  21.212 174.615  1.00 47.26           O  
ATOM    382  ND2 ASN    53     -12.548  22.888 175.303  1.00 47.57           N  
ATOM    383  N   GLY    54      -8.948  20.725 172.586  1.00 43.60           N  
ATOM    384  CA  GLY    54      -9.118  19.838 171.450  1.00 43.79           C  
ATOM    385  C   GLY    54     -10.568  19.477 171.184  1.00 46.01           C  
ATOM    386  O   GLY    54     -10.922  19.091 170.063  1.00 45.16           O  
ATOM    387  N   ASN    55     -11.408  19.603 172.213  1.00 46.67           N  
ATOM    388  CA  ASN    55     -12.834  19.294 172.096  1.00 46.74           C  
ATOM    389  C   ASN    55     -13.559  20.234 171.133  1.00 45.02           C  
ATOM    390  O   ASN    55     -13.647  21.441 171.374  1.00 46.21           O  
ATOM    391  CB  ASN    55     -13.509  19.362 173.473  1.00 48.61           C  
ATOM    392  CG  ASN    55     -13.087  18.220 174.394  1.00 52.70           C  
ATOM    393  OD1 ASN    55     -12.242  18.388 175.277  1.00 56.39           O  
ATOM    394  ND2 ASN    55     -13.671  17.045 174.179  1.00 58.74           N  
ATOM    395  N   GLY    56     -14.082  19.666 170.047  1.00 43.79           N  
ATOM    396  CA  GLY    56     -14.800  20.441 169.044  1.00 40.35           C  
ATOM    397  C   GLY    56     -13.862  21.143 168.080  1.00 38.97           C  
ATOM    398  O   GLY    56     -14.285  21.869 167.182  1.00 39.42           O  
ATOM    399  N   SER    57     -12.571  20.899 168.262  1.00 38.33           N  
ATOM    400  CA  SER    57     -11.535  21.505 167.437  1.00 35.50           C  
ATOM    401  C   SER    57     -10.963  20.557 166.387  1.00 33.56           C  
ATOM    402  O   SER    57     -10.777  19.374 166.646  1.00 31.18           O  
ATOM    403  CB  SER    57     -10.415  22.011 168.349  1.00 35.48           C  
ATOM    404  OG  SER    57      -9.243  22.356 167.632  1.00 34.61           O  
ATOM    405  N   THR    58     -10.681  21.087 165.200  1.00 32.90           N  
ATOM    406  CA  THR    58     -10.094  20.281 164.142  1.00 31.69           C  
ATOM    407  C   THR    58      -8.624  20.066 164.515  1.00 31.06           C  
ATOM    408  O   THR    58      -8.024  19.038 164.175  1.00 31.61           O  
ATOM    409  CB  THR    58     -10.180  20.998 162.777  1.00 32.99           C  
ATOM    410  OG1 THR    58     -11.548  21.305 162.487  1.00 32.94           O  
ATOM    411  CG2 THR    58      -9.628  20.102 161.665  1.00 33.92           C  
ATOM    412  N   GLY    59      -8.051  21.038 165.226  1.00 29.22           N  
ATOM    413  CA  GLY    59      -6.655  20.940 165.629  1.00 27.38           C  
ATOM    414  C   GLY    59      -5.873  22.231 165.456  1.00 28.44           C  
ATOM    415  O   GLY    59      -6.366  23.328 165.734  1.00 27.05           O  
ATOM    416  N   ALA    60      -4.650  22.104 164.964  1.00 27.51           N  
ATOM    417  CA  ALA    60      -3.798  23.261 164.784  1.00 28.53           C  
ATOM    418  C   ALA    60      -3.383  23.494 163.344  1.00 27.12           C  
ATOM    419  O   ALA    60      -3.470  22.598 162.499  1.00 26.54           O  
ATOM    420  CB  ALA    60      -2.553  23.121 165.676  1.00 26.61           C  
ATOM    421  N   ILE    61      -2.936  24.716 163.076  1.00 26.85           N  
ATOM    422  CA  ILE    61      -2.436  25.079 161.757  1.00 25.89           C  
ATOM    423  C   ILE    61      -1.026  25.662 161.925  1.00 26.23           C  
ATOM    424  O   ILE    61      -0.795  26.518 162.789  1.00 24.01           O  
ATOM    425  CB  ILE    61      -3.291  26.156 161.062  1.00 24.77           C  
ATOM    426  CG1 ILE    61      -4.711  25.646 160.832  1.00 26.17           C  
ATOM    427  CG2 ILE    61      -2.667  26.511 159.695  1.00 28.08           C  
ATOM    428  CD1 ILE    61      -5.649  26.690 160.250  1.00 24.83           C  
ATOM    429  N   ALA    62      -0.086  25.172 161.120  1.00 24.83           N  
ATOM    430  CA  ALA    62       1.285  25.687 161.129  1.00 27.04           C  
ATOM    431  C   ALA    62       1.558  26.266 159.728  1.00 26.93           C  
ATOM    432  O   ALA    62       1.616  25.537 158.737  1.00 27.63           O  
ATOM    433  CB  ALA    62       2.302  24.572 161.447  1.00 24.51           C  
ATOM    434  N   ILE    63       1.703  27.582 159.650  1.00 29.03           N  
ATOM    435  CA  ILE    63       1.974  28.269 158.397  1.00 30.40           C  
ATOM    436  C   ILE    63       3.430  28.702 158.444  1.00 30.95           C  
ATOM    437  O   ILE    63       3.771  29.745 159.002  1.00 32.03           O  
ATOM    438  CB  ILE    63       1.057  29.488 158.246  1.00 31.41           C  
ATOM    439  CG1 ILE    63      -0.394  29.016 158.112  1.00 33.10           C  
ATOM    440  CG2 ILE    63       1.472  30.306 157.044  1.00 33.12           C  
ATOM    441  CD1 ILE    63      -1.389  29.915 158.811  1.00 34.01           C  
ATOM    442  N   THR    64       4.289  27.911 157.812  1.00 31.33           N  
ATOM    443  CA  THR    64       5.721  28.179 157.842  1.00 31.25           C  
ATOM    444  C   THR    64       6.492  27.262 156.895  1.00 31.37           C  
ATOM    445  O   THR    64       6.055  26.147 156.621  1.00 31.07           O  
ATOM    446  CB  THR    64       6.248  27.938 159.275  1.00 30.66           C  
ATOM    447  OG1 THR    64       7.678  27.951 159.289  1.00 31.03           O  
ATOM    448  CG2 THR    64       5.768  26.557 159.795  1.00 30.49           C  
ATOM    449  N   PRO    65       7.651  27.719 156.398  1.00 32.35           N  
ATOM    450  CA  PRO    65       8.500  26.936 155.489  1.00 32.48           C  
ATOM    451  C   PRO    65       9.084  25.724 156.212  1.00 33.51           C  
ATOM    452  O   PRO    65       9.439  24.734 155.590  1.00 35.67           O  
ATOM    453  CB  PRO    65       9.603  27.913 155.089  1.00 31.90           C  
ATOM    454  CG  PRO    65       8.961  29.242 155.205  1.00 34.17           C  
ATOM    455  CD  PRO    65       8.050  29.140 156.412  1.00 32.46           C  
ATOM    456  N   ALA    66       9.209  25.823 157.529  1.00 33.82           N  
ATOM    457  CA  ALA    66       9.751  24.726 158.336  1.00 33.47           C  
ATOM    458  C   ALA    66       8.656  24.140 159.222  1.00 34.22           C  
ATOM    459  O   ALA    66       8.747  24.175 160.443  1.00 32.79           O  
ATOM    460  CB  ALA    66      10.897  25.226 159.206  1.00 34.03           C  
ATOM    461  N   ALA    67       7.622  23.586 158.600  1.00 34.58           N  
ATOM    462  CA  ALA    67       6.496  23.008 159.329  1.00 34.68           C  
ATOM    463  C   ALA    67       6.851  21.748 160.101  1.00 35.19           C  
ATOM    464  O   ALA    67       6.146  21.366 161.041  1.00 33.42           O  
ATOM    465  CB  ALA    67       5.348  22.721 158.365  1.00 33.52           C  
ATOM    466  N   GLY    68       7.944  21.108 159.698  1.00 34.05           N  
ATOM    467  CA  GLY    68       8.365  19.888 160.351  1.00 33.14           C  
ATOM    468  C   GLY    68       8.839  20.106 161.776  1.00 33.00           C  
ATOM    469  O   GLY    68       8.451  19.368 162.690  1.00 31.77           O  
ATOM    470  N   LEU    69       9.685  21.111 161.967  1.00 31.47           N  
ATOM    471  CA  LEU    69      10.206  21.409 163.290  1.00 32.26           C  
ATOM    472  C   LEU    69       9.049  21.904 164.167  1.00 33.07           C  
ATOM    473  O   LEU    69       8.747  21.322 165.202  1.00 33.37           O  
ATOM    474  CB  LEU    69      11.316  22.469 163.199  1.00 30.74           C  
ATOM    475  CG  LEU    69      11.850  23.000 164.535  1.00 32.20           C  
ATOM    476  CD1 LEU    69      12.571  21.903 165.298  1.00 32.82           C  
ATOM    477  CD2 LEU    69      12.786  24.161 164.273  1.00 29.97           C  
ATOM    478  N   VAL    70       8.404  22.979 163.737  1.00 33.16           N  
ATOM    479  CA  VAL    70       7.270  23.553 164.456  1.00 34.67           C  
ATOM    480  C   VAL    70       6.188  22.511 164.772  1.00 34.31           C  
ATOM    481  O   VAL    70       5.713  22.433 165.910  1.00 33.10           O  
ATOM    482  CB  VAL    70       6.641  24.707 163.632  1.00 35.05           C  
ATOM    483  CG1 VAL    70       5.295  25.134 164.236  1.00 37.65           C  
ATOM    484  CG2 VAL    70       7.594  25.883 163.595  1.00 33.13           C  
ATOM    485  N   GLY    71       5.818  21.730 163.755  1.00 32.90           N  
ATOM    486  CA  GLY    71       4.791  20.711 163.886  1.00 30.68           C  
ATOM    487  C   GLY    71       5.058  19.658 164.935  1.00 30.85           C  
ATOM    488  O   GLY    71       4.128  19.144 165.564  1.00 31.53           O  
ATOM    489  N   LEU    72       6.329  19.312 165.101  1.00 29.51           N  
ATOM    490  CA  LEU    72       6.718  18.310 166.080  1.00 30.07           C  
ATOM    491  C   LEU    72       6.456  18.822 167.497  1.00 28.95           C  
ATOM    492  O   LEU    72       6.056  18.058 168.379  1.00 29.63           O  
ATOM    493  CB  LEU    72       8.199  17.931 165.905  1.00 28.25           C  
ATOM    494  CG  LEU    72       8.495  17.019 164.697  1.00 28.77           C  
ATOM    495  CD1 LEU    72      10.006  16.853 164.530  1.00 31.04           C  
ATOM    496  CD2 LEU    72       7.842  15.648 164.901  1.00 27.33           C  
ATOM    497  N   TYR    73       6.689  20.111 167.721  1.00 29.65           N  
ATOM    498  CA  TYR    73       6.457  20.703 169.041  1.00 29.58           C  
ATOM    499  C   TYR    73       4.964  20.741 169.333  1.00 28.26           C  
ATOM    500  O   TYR    73       4.531  20.474 170.441  1.00 29.39           O  
ATOM    501  CB  TYR    73       7.009  22.121 169.087  1.00 29.72           C  
ATOM    502  CG  TYR    73       8.499  22.183 169.239  1.00 29.82           C  
ATOM    503  CD1 TYR    73       9.111  21.787 170.432  1.00 29.49           C  
ATOM    504  CD2 TYR    73       9.299  22.677 168.210  1.00 29.76           C  
ATOM    505  CE1 TYR    73      10.485  21.890 170.597  1.00 30.20           C  
ATOM    506  CE2 TYR    73      10.678  22.785 168.362  1.00 28.61           C  
ATOM    507  CZ  TYR    73      11.261  22.396 169.553  1.00 29.90           C  
ATOM    508  OH  TYR    73      12.613  22.544 169.717  1.00 35.40           O  
ATOM    509  N   ILE    74       4.187  21.075 168.313  1.00 27.05           N  
ATOM    510  CA  ILE    74       2.742  21.150 168.431  1.00 26.50           C  
ATOM    511  C   ILE    74       2.135  19.761 168.633  1.00 26.41           C  
ATOM    512  O   ILE    74       1.286  19.576 169.502  1.00 28.29           O  
ATOM    513  CB  ILE    74       2.133  21.843 167.173  1.00 25.58           C  
ATOM    514  CG1 ILE    74       2.499  23.330 167.185  1.00 23.49           C  
ATOM    515  CG2 ILE    74       0.621  21.655 167.133  1.00 22.85           C  
ATOM    516  CD1 ILE    74       1.908  24.129 166.028  1.00 28.06           C  
ATOM    517  N   LEU    75       2.578  18.785 167.838  1.00 29.11           N  
ATOM    518  CA  LEU    75       2.070  17.417 167.943  1.00 31.04           C  
ATOM    519  C   LEU    75       2.324  16.801 169.317  1.00 31.90           C  
ATOM    520  O   LEU    75       1.556  15.959 169.776  1.00 32.45           O  
ATOM    521  CB  LEU    75       2.669  16.541 166.827  1.00 29.40           C  
ATOM    522  CG  LEU    75       2.073  16.841 165.443  1.00 32.38           C  
ATOM    523  CD1 LEU    75       2.908  16.176 164.343  1.00 30.38           C  
ATOM    524  CD2 LEU    75       0.623  16.352 165.404  1.00 29.98           C  
ATOM    525  N   ASN    76       3.395  17.230 169.975  1.00 33.41           N  
ATOM    526  CA  ASN    76       3.712  16.733 171.314  1.00 35.17           C  
ATOM    527  C   ASN    76       2.572  17.013 172.296  1.00 35.09           C  
ATOM    528  O   ASN    76       2.253  16.169 173.134  1.00 36.99           O  
ATOM    529  CB  ASN    76       4.985  17.396 171.838  1.00 34.72           C  
ATOM    530  CG  ASN    76       6.245  16.662 171.424  1.00 39.54           C  
ATOM    531  OD1 ASN    76       7.342  17.238 171.396  1.00 43.81           O  
ATOM    532  ND2 ASN    76       6.101  15.382 171.115  1.00 43.80           N  
ATOM    533  N   GLY    77       1.956  18.193 172.195  1.00 32.65           N  
ATOM    534  CA  GLY    77       0.886  18.548 173.123  1.00 31.47           C  
ATOM    535  C   GLY    77      -0.552  18.330 172.695  1.00 32.40           C  
ATOM    536  O   GLY    77      -1.423  18.051 173.515  1.00 32.95           O  
ATOM    537  N   LEU    78      -0.793  18.459 171.402  1.00 31.49           N  
ATOM    538  CA  LEU    78      -2.120  18.294 170.822  1.00 32.19           C  
ATOM    539  C   LEU    78      -2.823  16.975 171.191  1.00 32.44           C  
ATOM    540  O   LEU    78      -2.192  15.920 171.231  1.00 33.08           O  
ATOM    541  CB  LEU    78      -2.002  18.403 169.302  1.00 29.81           C  
ATOM    542  CG  LEU    78      -2.898  19.317 168.462  1.00 36.01           C  
ATOM    543  CD1 LEU    78      -3.015  20.694 169.104  1.00 31.57           C  
ATOM    544  CD2 LEU    78      -2.310  19.420 167.051  1.00 33.99           C  
ATOM    545  N   ALA    79      -4.125  17.038 171.467  1.00 32.64           N  
ATOM    546  CA  ALA    79      -4.892  15.832 171.782  1.00 34.44           C  
ATOM    547  C   ALA    79      -4.895  14.941 170.513  1.00 36.11           C  
ATOM    548  O   ALA    79      -4.945  15.436 169.369  1.00 34.62           O  
ATOM    549  CB  ALA    79      -6.313  16.202 172.177  1.00 33.20           C  
ATOM    550  N   ASP    80      -4.855  13.626 170.720  1.00 37.28           N  
ATOM    551  CA  ASP    80      -4.807  12.657 169.619  1.00 38.96           C  
ATOM    552  C   ASP    80      -5.900  12.729 168.569  1.00 39.23           C  
ATOM    553  O   ASP    80      -5.662  12.390 167.403  1.00 40.09           O  
ATOM    554  CB  ASP    80      -4.733  11.229 170.168  1.00 39.60           C  
ATOM    555  CG  ASP    80      -3.476  10.985 170.982  1.00 42.87           C  
ATOM    556  OD1 ASP    80      -2.538  11.801 170.863  1.00 44.38           O  
ATOM    557  OD2 ASP    80      -3.422   9.972 171.723  1.00 45.18           O  
ATOM    558  N   ASN    81      -7.082  13.184 168.970  1.00 39.54           N  
ATOM    559  CA  ASN    81      -8.204  13.278 168.047  1.00 39.87           C  
ATOM    560  C   ASN    81      -8.299  14.609 167.305  1.00 39.74           C  
ATOM    561  O   ASN    81      -9.394  15.121 167.052  1.00 39.36           O  
ATOM    562  CB  ASN    81      -9.514  12.983 168.783  1.00 41.88           C  
ATOM    563  CG  ASN    81      -9.823  13.994 169.858  1.00 43.68           C  
ATOM    564  OD1 ASN    81      -8.920  14.588 170.441  1.00 47.17           O  
ATOM    565  ND2 ASN    81     -11.110  14.181 170.145  1.00 46.32           N  
ATOM    566  N   THR    82      -7.140  15.166 166.966  1.00 38.30           N  
ATOM    567  CA  THR    82      -7.066  16.420 166.219  1.00 36.46           C  
ATOM    568  C   THR    82      -5.965  16.231 165.179  1.00 37.02           C  
ATOM    569  O   THR    82      -5.215  15.253 165.228  1.00 35.72           O  
ATOM    570  CB  THR    82      -6.673  17.620 167.113  1.00 36.23           C  
ATOM    571  OG1 THR    82      -5.346  17.421 167.621  1.00 36.98           O  
ATOM    572  CG2 THR    82      -7.648  17.775 168.276  1.00 32.89           C  
ATOM    573  N   THR    83      -5.870  17.152 164.229  1.00 35.99           N  
ATOM    574  CA  THR    83      -4.833  17.056 163.204  1.00 36.94           C  
ATOM    575  C   THR    83      -3.979  18.323 163.161  1.00 35.17           C  
ATOM    576  O   THR    83      -4.354  19.372 163.704  1.00 34.96           O  
ATOM    577  CB  THR    83      -5.419  16.869 161.772  1.00 36.92           C  
ATOM    578  OG1 THR    83      -6.172  18.035 161.406  1.00 39.44           O  
ATOM    579  CG2 THR    83      -6.322  15.639 161.695  1.00 37.40           C  
ATOM    580  N   LEU    84      -2.814  18.214 162.535  1.00 33.33           N  
ATOM    581  CA  LEU    84      -1.956  19.373 162.347  1.00 32.12           C  
ATOM    582  C   LEU    84      -2.042  19.650 160.851  1.00 31.40           C  
ATOM    583  O   LEU    84      -1.809  18.764 160.022  1.00 32.33           O  
ATOM    584  CB  LEU    84      -0.491  19.090 162.727  1.00 32.68           C  
ATOM    585  CG  LEU    84       0.523  20.154 162.264  1.00 29.79           C  
ATOM    586  CD1 LEU    84       0.307  21.474 163.009  1.00 30.01           C  
ATOM    587  CD2 LEU    84       1.929  19.629 162.515  1.00 28.22           C  
ATOM    588  N   THR    85      -2.406  20.875 160.501  1.00 32.14           N  
ATOM    589  CA  THR    85      -2.507  21.273 159.104  1.00 30.98           C  
ATOM    590  C   THR    85      -1.329  22.197 158.812  1.00 31.89           C  
ATOM    591  O   THR    85      -1.208  23.272 159.401  1.00 32.68           O  
ATOM    592  CB  THR    85      -3.837  22.004 158.831  1.00 30.16           C  
ATOM    593  OG1 THR    85      -4.924  21.091 159.026  1.00 30.62           O  
ATOM    594  CG2 THR    85      -3.875  22.553 157.416  1.00 30.92           C  
ATOM    595  N   CYS    86      -0.458  21.762 157.906  1.00 32.18           N  
ATOM    596  CA  CYS    86       0.714  22.537 157.518  1.00 31.91           C  
ATOM    597  C   CYS    86       0.448  23.205 156.180  1.00 32.73           C  
ATOM    598  O   CYS    86      -0.146  22.612 155.283  1.00 33.43           O  
ATOM    599  CB  CYS    86       1.939  21.633 157.398  1.00 31.46           C  
ATOM    600  SG  CYS    86       2.309  20.684 158.888  1.00 30.56           S  
ATOM    601  N   ILE    87       0.900  24.445 156.047  1.00 32.21           N  
ATOM    602  CA  ILE    87       0.681  25.199 154.820  1.00 32.24           C  
ATOM    603  C   ILE    87       1.921  25.904 154.279  1.00 34.38           C  
ATOM    604  O   ILE    87       2.488  26.779 154.948  1.00 35.36           O  
ATOM    605  CB  ILE    87      -0.392  26.294 155.018  1.00 31.54           C  
ATOM    606  CG1 ILE    87      -1.607  25.723 155.753  1.00 28.05           C  
ATOM    607  CG2 ILE    87      -0.785  26.889 153.665  1.00 28.77           C  
ATOM    608  CD1 ILE    87      -2.753  26.703 155.903  1.00 31.08           C  
ATOM    609  N   ASP    88       2.344  25.505 153.082  1.00 34.03           N  
ATOM    610  CA  ASP    88       3.466  26.138 152.400  1.00 34.37           C  
ATOM    611  C   ASP    88       3.368  25.786 150.906  1.00 33.50           C  
ATOM    612  O   ASP    88       2.976  24.679 150.548  1.00 33.15           O  
ATOM    613  CB  ASP    88       4.823  25.687 152.965  1.00 32.69           C  
ATOM    614  CG  ASP    88       5.983  26.521 152.414  1.00 32.83           C  
ATOM    615  OD1 ASP    88       6.150  27.677 152.852  1.00 33.51           O  
ATOM    616  OD2 ASP    88       6.707  26.028 151.526  1.00 31.22           O  
ATOM    617  N   PRO    89       3.705  26.738 150.021  1.00 35.06           N  
ATOM    618  CA  PRO    89       3.654  26.536 148.564  1.00 37.30           C  
ATOM    619  C   PRO    89       4.796  25.746 147.929  1.00 39.95           C  
ATOM    620  O   PRO    89       4.690  25.310 146.781  1.00 40.65           O  
ATOM    621  CB  PRO    89       3.600  27.962 148.019  1.00 36.50           C  
ATOM    622  CG  PRO    89       4.416  28.736 149.005  1.00 33.94           C  
ATOM    623  CD  PRO    89       4.032  28.139 150.356  1.00 35.74           C  
ATOM    624  N   GLU    90       5.882  25.561 148.672  1.00 40.63           N  
ATOM    625  CA  GLU    90       7.049  24.865 148.164  1.00 41.49           C  
ATOM    626  C   GLU    90       6.934  23.361 148.357  1.00 41.43           C  
ATOM    627  O   GLU    90       6.688  22.892 149.464  1.00 42.37           O  
ATOM    628  CB  GLU    90       8.290  25.445 148.855  1.00 42.68           C  
ATOM    629  CG  GLU    90       9.148  26.359 147.968  1.00 47.20           C  
ATOM    630  CD  GLU    90       8.355  27.215 146.988  1.00 50.57           C  
ATOM    631  OE1 GLU    90       7.985  28.356 147.335  1.00 54.15           O  
ATOM    632  OE2 GLU    90       8.093  26.733 145.867  1.00 51.33           O  
ATOM    633  N   SER    91       7.118  22.606 147.277  1.00 40.04           N  
ATOM    634  CA  SER    91       6.974  21.159 147.346  1.00 40.28           C  
ATOM    635  C   SER    91       8.046  20.403 148.106  1.00 39.22           C  
ATOM    636  O   SER    91       7.757  19.360 148.698  1.00 38.91           O  
ATOM    637  CB  SER    91       6.795  20.574 145.938  1.00 40.80           C  
ATOM    638  OG  SER    91       7.828  20.986 145.076  1.00 47.75           O  
ATOM    639  N   GLU    92       9.273  20.917 148.105  1.00 38.40           N  
ATOM    640  CA  GLU    92      10.328  20.254 148.855  1.00 37.79           C  
ATOM    641  C   GLU    92      10.055  20.488 150.350  1.00 35.86           C  
ATOM    642  O   GLU    92      10.494  19.697 151.190  1.00 34.88           O  
ATOM    643  CB  GLU    92      11.724  20.777 148.458  1.00 37.99           C  
ATOM    644  CG  GLU    92      12.018  22.231 148.746  1.00 38.66           C  
ATOM    645  CD  GLU    92      13.401  22.629 148.226  1.00 39.16           C  
ATOM    646  OE1 GLU    92      13.730  23.832 148.234  1.00 44.47           O  
ATOM    647  OE2 GLU    92      14.165  21.728 147.819  1.00 39.56           O  
ATOM    648  N   HIS    93       9.339  21.565 150.689  1.00 34.44           N  
ATOM    649  CA  HIS    93       8.997  21.824 152.087  1.00 34.73           C  
ATOM    650  C   HIS    93       7.952  20.787 152.502  1.00 36.07           C  
ATOM    651  O   HIS    93       7.934  20.348 153.652  1.00 37.25           O  
ATOM    652  CB  HIS    93       8.472  23.258 152.258  1.00 34.41           C  
ATOM    653  CG  HIS    93       9.545  24.294 152.134  1.00 32.27           C  
ATOM    654  ND1 HIS    93       9.280  25.639 152.016  1.00 30.35           N  
ATOM    655  CD2 HIS    93      10.892  24.171 152.097  1.00 24.41           C  
ATOM    656  CE1 HIS    93      10.418  26.300 151.907  1.00 27.66           C  
ATOM    657  NE2 HIS    93      11.411  25.432 151.952  1.00 27.44           N  
ATOM    658  N   GLN    94       7.085  20.385 151.569  1.00 36.34           N  
ATOM    659  CA  GLN    94       6.070  19.368 151.863  1.00 36.30           C  
ATOM    660  C   GLN    94       6.777  18.026 152.075  1.00 37.32           C  
ATOM    661  O   GLN    94       6.414  17.252 152.974  1.00 36.92           O  
ATOM    662  CB  GLN    94       5.061  19.248 150.715  1.00 36.05           C  
ATOM    663  CG  GLN    94       4.217  17.979 150.781  1.00 38.03           C  
ATOM    664  CD  GLN    94       2.981  18.054 149.912  1.00 41.92           C  
ATOM    665  OE1 GLN    94       3.067  18.249 148.695  1.00 43.15           O  
ATOM    666  NE2 GLN    94       1.815  17.904 150.534  1.00 42.69           N  
ATOM    667  N   ARG    95       7.783  17.749 151.242  1.00 37.73           N  
ATOM    668  CA  ARG    95       8.554  16.513 151.365  1.00 38.04           C  
ATOM    669  C   ARG    95       9.350  16.566 152.664  1.00 36.71           C  
ATOM    670  O   ARG    95       9.433  15.578 153.389  1.00 37.54           O  
ATOM    671  CB  ARG    95       9.522  16.343 150.190  1.00 37.76           C  
ATOM    672  CG  ARG    95       8.981  15.501 149.051  1.00 41.07           C  
ATOM    673  CD  ARG    95      10.112  14.864 148.251  1.00 41.47           C  
ATOM    674  NE  ARG    95      10.210  13.421 148.471  1.00 44.73           N  
ATOM    675  CZ  ARG    95      11.303  12.697 148.238  1.00 48.22           C  
ATOM    676  NH1 ARG    95      12.405  13.277 147.777  1.00 43.75           N  
ATOM    677  NH2 ARG    95      11.300  11.388 148.466  1.00 50.29           N  
ATOM    678  N   GLN    96       9.929  17.729 152.950  1.00 36.06           N  
ATOM    679  CA  GLN    96      10.728  17.925 154.160  1.00 36.78           C  
ATOM    680  C   GLN    96       9.918  17.667 155.432  1.00 37.11           C  
ATOM    681  O   GLN    96      10.404  17.022 156.363  1.00 38.28           O  
ATOM    682  CB  GLN    96      11.321  19.352 154.177  1.00 36.09           C  
ATOM    683  CG  GLN    96      12.559  19.528 153.281  1.00 35.76           C  
ATOM    684  CD  GLN    96      12.876  20.987 152.938  1.00 37.87           C  
ATOM    685  OE1 GLN    96      12.553  21.902 153.695  1.00 37.55           O  
ATOM    686  NE2 GLN    96      13.521  21.202 151.787  1.00 37.71           N  
ATOM    687  N   ALA    97       8.685  18.164 155.459  1.00 36.86           N  
ATOM    688  CA  ALA    97       7.808  18.008 156.618  1.00 38.73           C  
ATOM    689  C   ALA    97       7.274  16.589 156.803  1.00 39.18           C  
ATOM    690  O   ALA    97       7.426  16.003 157.871  1.00 40.70           O  
ATOM    691  CB  ALA    97       6.642  18.998 156.527  1.00 38.41           C  
ATOM    692  N   LYS    98       6.643  16.043 155.767  1.00 41.29           N  
ATOM    693  CA  LYS    98       6.092  14.691 155.829  1.00 42.21           C  
ATOM    694  C   LYS    98       7.160  13.660 156.207  1.00 41.35           C  
ATOM    695  O   LYS    98       6.868  12.667 156.882  1.00 41.72           O  
ATOM    696  CB  LYS    98       5.452  14.320 154.489  1.00 42.60           C  
ATOM    697  CG  LYS    98       4.132  15.045 154.207  1.00 46.99           C  
ATOM    698  CD  LYS    98       3.701  14.826 152.757  1.00 50.33           C  
ATOM    699  CE  LYS    98       2.273  14.316 152.636  1.00 52.72           C  
ATOM    700  NZ  LYS    98       1.300  15.394 152.311  1.00 55.75           N  
ATOM    701  N   ALA    99       8.395  13.899 155.776  1.00 40.82           N  
ATOM    702  CA  ALA    99       9.501  13.005 156.096  1.00 40.65           C  
ATOM    703  C   ALA    99       9.746  13.051 157.612  1.00 41.49           C  
ATOM    704  O   ALA    99       9.763  12.015 158.279  1.00 42.92           O  
ATOM    705  CB  ALA    99      10.761  13.443 155.353  1.00 39.72           C  
ATOM    706  N   LEU   100       9.944  14.253 158.155  1.00 41.47           N  
ATOM    707  CA  LEU   100      10.195  14.414 159.590  1.00 42.16           C  
ATOM    708  C   LEU   100       9.088  13.802 160.454  1.00 43.10           C  
ATOM    709  O   LEU   100       9.366  13.216 161.504  1.00 44.57           O  
ATOM    710  CB  LEU   100      10.390  15.899 159.931  1.00 40.19           C  
ATOM    711  CG  LEU   100      11.760  16.459 159.539  1.00 40.76           C  
ATOM    712  CD1 LEU   100      11.733  17.979 159.622  1.00 38.21           C  
ATOM    713  CD2 LEU   100      12.845  15.879 160.463  1.00 39.23           C  
ATOM    714  N   PHE   101       7.837  13.937 160.017  1.00 43.20           N  
ATOM    715  CA  PHE   101       6.726  13.365 160.764  1.00 42.25           C  
ATOM    716  C   PHE   101       6.823  11.845 160.643  1.00 44.41           C  
ATOM    717  O   PHE   101       6.658  11.123 161.621  1.00 43.24           O  
ATOM    718  CB  PHE   101       5.385  13.879 160.217  1.00 41.31           C  
ATOM    719  CG  PHE   101       5.197  15.367 160.365  1.00 39.00           C  
ATOM    720  CD1 PHE   101       5.665  16.033 161.502  1.00 34.66           C  
ATOM    721  CD2 PHE   101       4.571  16.105 159.369  1.00 36.49           C  
ATOM    722  CE1 PHE   101       5.495  17.412 161.645  1.00 34.60           C  
ATOM    723  CE2 PHE   101       4.399  17.484 159.500  1.00 34.58           C  
ATOM    724  CZ  PHE   101       4.870  18.142 160.633  1.00 32.21           C  
ATOM    725  N   ARG   102       7.102  11.360 159.435  1.00 46.41           N  
ATOM    726  CA  ARG   102       7.242   9.923 159.196  1.00 48.11           C  
ATOM    727  C   ARG   102       8.348   9.354 160.107  1.00 48.36           C  
ATOM    728  O   ARG   102       8.139   8.336 160.770  1.00 48.43           O  
ATOM    729  CB  ARG   102       7.627   9.660 157.741  1.00 49.29           C  
ATOM    730  CG  ARG   102       7.634   8.184 157.333  1.00 51.02           C  
ATOM    731  CD  ARG   102       8.792   7.853 156.388  1.00 53.05           C  
ATOM    732  NE  ARG   102       9.139   8.969 155.508  1.00 52.14           N  
ATOM    733  CZ  ARG   102       8.311   9.516 154.622  1.00 55.54           C  
ATOM    734  NH1 ARG   102       7.078   9.047 154.486  1.00 53.38           N  
ATOM    735  NH2 ARG   102       8.711  10.542 153.882  1.00 51.50           N  
ATOM    736  N   GLU   103       9.516  10.005 160.131  1.00 48.96           N  
ATOM    737  CA  GLU   103      10.645   9.551 160.943  1.00 49.81           C  
ATOM    738  C   GLU   103      10.291   9.567 162.426  1.00 50.89           C  
ATOM    739  O   GLU   103      10.596   8.606 163.141  1.00 50.34           O  
ATOM    740  CB  GLU   103      11.893  10.388 160.616  1.00 50.09           C  
ATOM    741  CG  GLU   103      12.643   9.818 159.415  1.00 51.67           C  
ATOM    742  CD  GLU   103      13.347  10.890 158.626  1.00 51.76           C  
ATOM    743  OE1 GLU   103      13.899  11.825 159.251  1.00 48.29           O  
ATOM    744  OE2 GLU   103      13.354  10.796 157.383  1.00 55.16           O  
ATOM    745  N   ALA   104       9.667  10.652 162.892  1.00 51.35           N  
ATOM    746  CA  ALA   104       9.177  10.675 164.265  1.00 52.00           C  
ATOM    747  C   ALA   104       8.091   9.565 164.126  1.00 52.43           C  
ATOM    748  O   ALA   104       7.679   9.211 163.007  1.00 53.80           O  
ATOM    749  CB  ALA   104       8.528  12.007 164.577  1.00 52.52           C  
ATOM    750  N   GLY   105       7.572   9.038 165.222  1.00 51.99           N  
ATOM    751  CA  GLY   105       6.611   7.951 165.088  1.00 52.42           C  
ATOM    752  C   GLY   105       5.192   8.281 164.726  1.00 51.41           C  
ATOM    753  O   GLY   105       4.281   7.504 165.013  1.00 52.46           O  
ATOM    754  N   TYR   106       5.022   9.381 164.007  1.00 49.01           N  
ATOM    755  CA  TYR   106       3.692   9.848 163.660  1.00 48.06           C  
ATOM    756  C   TYR   106       2.927   9.292 162.481  1.00 48.12           C  
ATOM    757  O   TYR   106       3.453   9.190 161.388  1.00 48.28           O  
ATOM    758  CB  TYR   106       3.704  11.371 163.567  1.00 46.71           C  
ATOM    759  CG  TYR   106       3.873  12.108 164.893  1.00 46.02           C  
ATOM    760  CD1 TYR   106       2.832  12.165 165.824  1.00 45.78           C  
ATOM    761  CD2 TYR   106       5.077  12.743 165.217  1.00 45.53           C  
ATOM    762  CE1 TYR   106       2.987  12.828 167.043  1.00 43.89           C  
ATOM    763  CE2 TYR   106       5.242  13.401 166.435  1.00 45.18           C  
ATOM    764  CZ  TYR   106       4.194  13.441 167.339  1.00 47.22           C  
ATOM    765  OH  TYR   106       4.358  14.096 168.537  1.00 44.15           O  
ATOM    766  N   SER   107       1.663   8.960 162.731  1.00 48.48           N  
ATOM    767  CA  SER   107       0.783   8.435 161.702  1.00 49.27           C  
ATOM    768  C   SER   107       0.425   9.539 160.706  1.00 49.37           C  
ATOM    769  O   SER   107       0.319  10.710 161.073  1.00 49.53           O  
ATOM    770  CB  SER   107      -0.491   7.870 162.342  1.00 49.50           C  
ATOM    771  OG  SER   107      -1.474   7.588 161.364  1.00 52.70           O  
ATOM    772  N   PRO   108       0.235   9.176 159.429  1.00 49.21           N  
ATOM    773  CA  PRO   108      -0.110  10.142 158.376  1.00 48.45           C  
ATOM    774  C   PRO   108      -1.477  10.785 158.603  1.00 47.09           C  
ATOM    775  O   PRO   108      -1.770  11.856 158.079  1.00 46.18           O  
ATOM    776  CB  PRO   108      -0.096   9.296 157.096  1.00 49.07           C  
ATOM    777  CG  PRO   108       0.786   8.137 157.438  1.00 48.53           C  
ATOM    778  CD  PRO   108       0.450   7.831 158.867  1.00 48.40           C  
ATOM    779  N   SER   109      -2.314  10.103 159.375  1.00 45.54           N  
ATOM    780  CA  SER   109      -3.663  10.569 159.685  1.00 44.50           C  
ATOM    781  C   SER   109      -3.706  11.769 160.631  1.00 43.25           C  
ATOM    782  O   SER   109      -4.730  12.445 160.743  1.00 42.75           O  
ATOM    783  CB  SER   109      -4.464   9.421 160.291  1.00 44.79           C  
ATOM    784  OG  SER   109      -3.645   8.662 161.166  1.00 45.92           O  
ATOM    785  N   ARG   110      -2.588  12.025 161.304  1.00 42.31           N  
ATOM    786  CA  ARG   110      -2.488  13.132 162.250  1.00 41.07           C  
ATOM    787  C   ARG   110      -2.082  14.447 161.587  1.00 40.37           C  
ATOM    788  O   ARG   110      -2.299  15.523 162.138  1.00 38.73           O  
ATOM    789  CB  ARG   110      -1.468  12.805 163.339  1.00 41.93           C  
ATOM    790  CG  ARG   110      -1.842  11.684 164.295  1.00 39.91           C  
ATOM    791  CD  ARG   110      -3.104  12.011 165.079  1.00 39.10           C  
ATOM    792  NE  ARG   110      -3.127  13.356 165.664  1.00 35.37           N  
ATOM    793  CZ  ARG   110      -2.421  13.741 166.723  1.00 36.20           C  
ATOM    794  NH1 ARG   110      -1.620  12.889 167.337  1.00 32.35           N  
ATOM    795  NH2 ARG   110      -2.556  14.974 167.196  1.00 34.00           N  
ATOM    796  N   VAL   111      -1.499  14.351 160.399  1.00 39.59           N  
ATOM    797  CA  VAL   111      -1.040  15.528 159.674  1.00 38.83           C  
ATOM    798  C   VAL   111      -1.701  15.708 158.309  1.00 38.15           C  
ATOM    799  O   VAL   111      -2.128  14.745 157.676  1.00 37.24           O  
ATOM    800  CB  VAL   111       0.491  15.488 159.473  1.00 38.00           C  
ATOM    801  CG1 VAL   111       0.929  16.615 158.551  1.00 42.01           C  
ATOM    802  CG2 VAL   111       1.206  15.614 160.820  1.00 38.16           C  
ATOM    803  N   ARG   112      -1.765  16.957 157.867  1.00 36.98           N  
ATOM    804  CA  ARG   112      -2.351  17.300 156.590  1.00 36.33           C  
ATOM    805  C   ARG   112      -1.513  18.435 156.001  1.00 35.66           C  
ATOM    806  O   ARG   112      -1.324  19.472 156.648  1.00 36.99           O  
ATOM    807  CB  ARG   112      -3.798  17.750 156.830  1.00 36.34           C  
ATOM    808  CG  ARG   112      -4.485  18.397 155.660  1.00 37.42           C  
ATOM    809  CD  ARG   112      -5.397  19.503 156.170  1.00 40.20           C  
ATOM    810  NE  ARG   112      -6.749  19.400 155.634  1.00 45.44           N  
ATOM    811  CZ  ARG   112      -7.756  20.191 155.991  1.00 48.74           C  
ATOM    812  NH1 ARG   112      -7.573  21.156 156.889  1.00 49.80           N  
ATOM    813  NH2 ARG   112      -8.947  20.016 155.443  1.00 49.68           N  
ATOM    814  N   PHE   113      -1.009  18.253 154.784  1.00 34.58           N  
ATOM    815  CA  PHE   113      -0.209  19.303 154.170  1.00 35.15           C  
ATOM    816  C   PHE   113      -0.932  19.949 152.991  1.00 35.07           C  
ATOM    817  O   PHE   113      -1.384  19.270 152.067  1.00 37.67           O  
ATOM    818  CB  PHE   113       1.151  18.766 153.708  1.00 34.40           C  
ATOM    819  CG  PHE   113       2.229  19.827 153.643  1.00 36.00           C  
ATOM    820  CD1 PHE   113       3.235  19.879 154.609  1.00 36.27           C  
ATOM    821  CD2 PHE   113       2.207  20.800 152.650  1.00 32.65           C  
ATOM    822  CE1 PHE   113       4.199  20.895 154.590  1.00 33.82           C  
ATOM    823  CE2 PHE   113       3.163  21.815 152.616  1.00 34.72           C  
ATOM    824  CZ  PHE   113       4.163  21.865 153.589  1.00 33.01           C  
ATOM    825  N   LEU   114      -1.054  21.268 153.029  1.00 35.24           N  
ATOM    826  CA  LEU   114      -1.704  21.989 151.942  1.00 35.75           C  
ATOM    827  C   LEU   114      -0.634  22.776 151.168  1.00 36.12           C  
ATOM    828  O   LEU   114      -0.129  23.802 151.642  1.00 33.29           O  
ATOM    829  CB  LEU   114      -2.781  22.950 152.484  1.00 35.98           C  
ATOM    830  CG  LEU   114      -3.800  22.374 153.479  1.00 35.98           C  
ATOM    831  CD1 LEU   114      -4.787  23.453 153.902  1.00 30.83           C  
ATOM    832  CD2 LEU   114      -4.537  21.206 152.840  1.00 37.70           C  
ATOM    833  N   LEU   115      -0.291  22.272 149.982  1.00 36.66           N  
ATOM    834  CA  LEU   115       0.698  22.896 149.101  1.00 36.42           C  
ATOM    835  C   LEU   115       0.067  24.159 148.511  1.00 37.94           C  
ATOM    836  O   LEU   115      -0.413  24.156 147.371  1.00 37.92           O  
ATOM    837  CB  LEU   115       1.058  21.957 147.946  1.00 36.58           C  
ATOM    838  CG  LEU   115       2.472  21.414 147.736  1.00 37.22           C  
ATOM    839  CD1 LEU   115       2.652  21.168 146.230  1.00 32.33           C  
ATOM    840  CD2 LEU   115       3.537  22.398 148.235  1.00 31.00           C  
ATOM    841  N   SER   116       0.089  25.248 149.270  1.00 38.17           N  
ATOM    842  CA  SER   116      -0.526  26.495 148.825  1.00 39.28           C  
ATOM    843  C   SER   116       0.103  27.704 149.496  1.00 41.12           C  
ATOM    844  O   SER   116       0.891  27.567 150.442  1.00 40.46           O  
ATOM    845  CB  SER   116      -2.007  26.513 149.183  1.00 40.19           C  
ATOM    846  OG  SER   116      -2.470  25.254 149.656  1.00 42.22           O  
ATOM    847  N   ARG   117      -0.255  28.884 149.007  1.00 41.80           N  
ATOM    848  CA  ARG   117       0.210  30.105 149.614  1.00 42.60           C  
ATOM    849  C   ARG   117      -0.825  30.243 150.739  1.00 40.98           C  
ATOM    850  O   ARG   117      -2.039  30.078 150.529  1.00 41.28           O  
ATOM    851  CB  ARG   117       0.122  31.272 148.622  1.00 43.51           C  
ATOM    852  CG  ARG   117       0.859  30.961 147.339  1.00 49.76           C  
ATOM    853  CD  ARG   117       0.563  31.978 146.265  1.00 60.03           C  
ATOM    854  NE  ARG   117       0.982  33.320 146.662  1.00 67.32           N  
ATOM    855  CZ  ARG   117       1.017  34.367 145.842  1.00 67.66           C  
ATOM    856  NH1 ARG   117       0.659  34.231 144.571  1.00 67.92           N  
ATOM    857  NH2 ARG   117       1.413  35.550 146.293  1.00 68.00           N  
ATOM    858  N   PRO   118      -0.364  30.529 151.957  1.00 41.33           N  
ATOM    859  CA  PRO   118      -1.223  30.686 153.140  1.00 40.61           C  
ATOM    860  C   PRO   118      -2.504  31.479 152.927  1.00 39.64           C  
ATOM    861  O   PRO   118      -3.607  30.990 153.181  1.00 39.78           O  
ATOM    862  CB  PRO   118      -0.316  31.394 154.142  1.00 40.65           C  
ATOM    863  CG  PRO   118       1.041  30.954 153.775  1.00 41.68           C  
ATOM    864  CD  PRO   118       1.033  30.880 152.272  1.00 40.50           C  
ATOM    865  N   LEU   119      -2.343  32.715 152.460  1.00 41.33           N  
ATOM    866  CA  LEU   119      -3.471  33.595 152.279  1.00 43.36           C  
ATOM    867  C   LEU   119      -4.460  33.221 151.192  1.00 43.28           C  
ATOM    868  O   LEU   119      -5.565  33.763 151.135  1.00 43.18           O  
ATOM    869  CB  LEU   119      -2.962  35.032 152.110  1.00 44.68           C  
ATOM    870  CG  LEU   119      -2.149  35.568 153.306  1.00 47.79           C  
ATOM    871  CD1 LEU   119      -1.613  36.954 152.971  1.00 48.36           C  
ATOM    872  CD2 LEU   119      -3.017  35.620 154.562  1.00 48.43           C  
ATOM    873  N   ASP   120      -4.069  32.285 150.344  1.00 42.99           N  
ATOM    874  CA  ASP   120      -4.950  31.832 149.284  1.00 43.56           C  
ATOM    875  C   ASP   120      -5.859  30.709 149.778  1.00 42.46           C  
ATOM    876  O   ASP   120      -7.049  30.704 149.496  1.00 42.73           O  
ATOM    877  CB  ASP   120      -4.136  31.320 148.091  1.00 45.08           C  
ATOM    878  CG  ASP   120      -3.630  32.435 147.194  1.00 47.02           C  
ATOM    879  OD1 ASP   120      -2.502  32.322 146.665  1.00 52.57           O  
ATOM    880  OD2 ASP   120      -4.368  33.418 147.002  1.00 54.08           O  
ATOM    881  N   VAL   121      -5.295  29.775 150.541  1.00 41.31           N  
ATOM    882  CA  VAL   121      -6.037  28.611 151.013  1.00 39.94           C  
ATOM    883  C   VAL   121      -6.808  28.725 152.327  1.00 40.84           C  
ATOM    884  O   VAL   121      -7.690  27.907 152.604  1.00 38.80           O  
ATOM    885  CB  VAL   121      -5.094  27.400 151.086  1.00 39.13           C  
ATOM    886  CG1 VAL   121      -4.188  27.521 152.303  1.00 37.68           C  
ATOM    887  CG2 VAL   121      -5.882  26.106 151.110  1.00 37.94           C  
ATOM    888  N   MET   122      -6.475  29.722 153.134  1.00 42.29           N  
ATOM    889  CA  MET   122      -7.166  29.906 154.395  1.00 43.80           C  
ATOM    890  C   MET   122      -8.616  30.270 154.106  1.00 44.00           C  
ATOM    891  O   MET   122      -9.498  30.116 154.952  1.00 42.06           O  
ATOM    892  CB  MET   122      -6.466  30.986 155.225  1.00 44.01           C  
ATOM    893  CG  MET   122      -5.380  30.396 156.117  1.00 49.56           C  
ATOM    894  SD  MET   122      -4.119  31.725 156.693  1.00 61.27          SE  
ATOM    895  CE  MET   122      -2.501  30.840 156.177  1.00 61.36           C  
ATOM    896  N   SER   123      -8.852  30.740 152.885  1.00 45.14           N  
ATOM    897  CA  SER   123     -10.192  31.101 152.429  1.00 44.45           C  
ATOM    898  C   SER   123     -11.012  29.812 152.270  1.00 42.51           C  
ATOM    899  O   SER   123     -12.239  29.841 152.214  1.00 42.47           O  
ATOM    900  CB  SER   123     -10.104  31.792 151.072  1.00 44.03           C  
ATOM    901  OG  SER   123     -11.332  32.400 150.721  1.00 50.55           O  
ATOM    902  N   ARG   124     -10.320  28.682 152.204  1.00 39.98           N  
ATOM    903  CA  ARG   124     -10.938  27.375 151.993  1.00 39.77           C  
ATOM    904  C   ARG   124     -11.079  26.481 153.218  1.00 39.26           C  
ATOM    905  O   ARG   124     -11.430  25.302 153.091  1.00 38.53           O  
ATOM    906  CB  ARG   124     -10.144  26.624 150.927  1.00 39.41           C  
ATOM    907  CG  ARG   124     -10.516  26.921 149.478  1.00 39.67           C  
ATOM    908  CD  ARG   124     -10.214  28.346 149.054  1.00 34.87           C  
ATOM    909  NE  ARG   124     -10.183  28.446 147.599  1.00 37.32           N  
ATOM    910  CZ  ARG   124     -10.506  29.535 146.908  1.00 38.08           C  
ATOM    911  NH1 ARG   124     -10.895  30.633 147.538  1.00 40.47           N  
ATOM    912  NH2 ARG   124     -10.456  29.519 145.584  1.00 35.95           N  
ATOM    913  N   LEU   125     -10.807  27.038 154.392  1.00 38.20           N  
ATOM    914  CA  LEU   125     -10.896  26.266 155.616  1.00 37.17           C  
ATOM    915  C   LEU   125     -12.133  26.675 156.405  1.00 35.40           C  
ATOM    916  O   LEU   125     -12.668  27.759 156.217  1.00 35.38           O  
ATOM    917  CB  LEU   125      -9.612  26.457 156.446  1.00 36.51           C  
ATOM    918  CG  LEU   125      -8.289  26.098 155.744  1.00 34.19           C  
ATOM    919  CD1 LEU   125      -7.122  26.588 156.596  1.00 35.46           C  
ATOM    920  CD2 LEU   125      -8.189  24.592 155.505  1.00 33.35           C  
ATOM    921  N   ALA   126     -12.583  25.798 157.291  1.00 36.45           N  
ATOM    922  CA  ALA   126     -13.782  26.061 158.076  1.00 37.46           C  
ATOM    923  C   ALA   126     -13.588  27.043 159.223  1.00 37.94           C  
ATOM    924  O   ALA   126     -12.660  26.912 160.014  1.00 36.91           O  
ATOM    925  CB  ALA   126     -14.351  24.735 158.604  1.00 38.14           C  
ATOM    926  N   ASN   127     -14.479  28.026 159.299  1.00 37.51           N  
ATOM    927  CA  ASN   127     -14.436  29.028 160.357  1.00 39.25           C  
ATOM    928  C   ASN   127     -14.698  28.410 161.736  1.00 38.25           C  
ATOM    929  O   ASN   127     -15.415  27.410 161.853  1.00 37.89           O  
ATOM    930  CB  ASN   127     -15.499  30.104 160.130  1.00 38.20           C  
ATOM    931  CG  ASN   127     -15.109  31.115 159.077  1.00 45.54           C  
ATOM    932  OD1 ASN   127     -13.925  31.365 158.846  1.00 47.80           O  
ATOM    933  ND2 ASN   127     -16.114  31.728 158.440  1.00 50.71           N  
ATOM    934  N   ASP   128     -14.100  28.996 162.773  1.00 39.07           N  
ATOM    935  CA  ASP   128     -14.333  28.545 164.147  1.00 39.00           C  
ATOM    936  C   ASP   128     -14.037  27.068 164.369  1.00 37.42           C  
ATOM    937  O   ASP   128     -14.761  26.386 165.099  1.00 36.97           O  
ATOM    938  CB  ASP   128     -15.802  28.840 164.494  1.00 40.06           C  
ATOM    939  CG  ASP   128     -16.097  28.760 165.988  1.00 42.55           C  
ATOM    940  OD1 ASP   128     -15.284  29.278 166.781  1.00 42.74           O  
ATOM    941  OD2 ASP   128     -17.152  28.195 166.370  1.00 38.11           O  
ATOM    942  N   SER   129     -12.967  26.573 163.763  1.00 35.37           N  
ATOM    943  CA  SER   129     -12.636  25.160 163.890  1.00 34.54           C  
ATOM    944  C   SER   129     -11.245  24.857 164.426  1.00 31.43           C  
ATOM    945  O   SER   129     -10.918  23.699 164.679  1.00 32.63           O  
ATOM    946  CB  SER   129     -12.782  24.477 162.536  1.00 35.03           C  
ATOM    947  OG  SER   129     -14.099  24.034 162.294  1.00 37.23           O  
ATOM    948  N   TYR   130     -10.431  25.884 164.620  1.00 29.68           N  
ATOM    949  CA  TYR   130      -9.071  25.668 165.066  1.00 28.67           C  
ATOM    950  C   TYR   130      -8.751  26.269 166.423  1.00 28.72           C  
ATOM    951  O   TYR   130      -9.163  27.382 166.738  1.00 29.68           O  
ATOM    952  CB  TYR   130      -8.121  26.196 163.986  1.00 28.26           C  
ATOM    953  CG  TYR   130      -8.274  25.464 162.664  1.00 29.26           C  
ATOM    954  CD1 TYR   130      -7.600  24.263 162.430  1.00 29.35           C  
ATOM    955  CD2 TYR   130      -9.172  25.915 161.692  1.00 28.46           C  
ATOM    956  CE1 TYR   130      -7.803  23.531 161.259  1.00 26.56           C  
ATOM    957  CE2 TYR   130      -9.386  25.194 160.518  1.00 29.12           C  
ATOM    958  CZ  TYR   130      -8.700  23.994 160.313  1.00 29.08           C  
ATOM    959  OH  TYR   130      -8.905  23.276 159.154  1.00 27.26           O  
ATOM    960  N   GLN   131      -7.995  25.514 167.214  1.00 28.03           N  
ATOM    961  CA  GLN   131      -7.601  25.922 168.557  1.00 27.77           C  
ATOM    962  C   GLN   131      -6.230  26.599 168.607  1.00 27.85           C  
ATOM    963  O   GLN   131      -5.884  27.249 169.598  1.00 29.71           O  
ATOM    964  CB  GLN   131      -7.569  24.700 169.472  1.00 26.77           C  
ATOM    965  CG  GLN   131      -6.362  23.790 169.188  1.00 26.44           C  
ATOM    966  CD  GLN   131      -6.491  22.396 169.781  1.00 24.98           C  
ATOM    967  OE1 GLN   131      -5.943  22.106 170.843  1.00 24.78           O  
ATOM    968  NE2 GLN   131      -7.231  21.533 169.101  1.00 20.94           N  
ATOM    969  N   LEU   132      -5.446  26.448 167.546  1.00 27.47           N  
ATOM    970  CA  LEU   132      -4.105  27.023 167.532  1.00 26.57           C  
ATOM    971  C   LEU   132      -3.590  27.236 166.115  1.00 27.51           C  
ATOM    972  O   LEU   132      -3.679  26.349 165.264  1.00 29.60           O  
ATOM    973  CB  LEU   132      -3.137  26.104 168.301  1.00 25.75           C  
ATOM    974  CG  LEU   132      -1.629  26.415 168.296  1.00 29.37           C  
ATOM    975  CD1 LEU   132      -1.363  27.685 169.099  1.00 27.98           C  
ATOM    976  CD2 LEU   132      -0.842  25.243 168.885  1.00 27.03           C  
ATOM    977  N   VAL   133      -3.055  28.424 165.864  1.00 26.58           N  
ATOM    978  CA  VAL   133      -2.498  28.739 164.566  1.00 25.15           C  
ATOM    979  C   VAL   133      -1.139  29.410 164.763  1.00 26.35           C  
ATOM    980  O   VAL   133      -1.017  30.422 165.456  1.00 26.47           O  
ATOM    981  CB  VAL   133      -3.439  29.670 163.752  1.00 25.87           C  
ATOM    982  CG1 VAL   133      -2.807  30.010 162.398  1.00 25.01           C  
ATOM    983  CG2 VAL   133      -4.791  28.987 163.550  1.00 20.36           C  
ATOM    984  N   PHE   134      -0.113  28.818 164.169  1.00 25.32           N  
ATOM    985  CA  PHE   134       1.234  29.356 164.232  1.00 26.86           C  
ATOM    986  C   PHE   134       1.555  29.901 162.847  1.00 27.34           C  
ATOM    987  O   PHE   134       1.374  29.218 161.827  1.00 28.20           O  
ATOM    988  CB  PHE   134       2.266  28.275 164.582  1.00 26.10           C  
ATOM    989  CG  PHE   134       3.687  28.747 164.450  1.00 25.49           C  
ATOM    990  CD1 PHE   134       4.311  29.429 165.490  1.00 24.26           C  
ATOM    991  CD2 PHE   134       4.389  28.539 163.263  1.00 29.08           C  
ATOM    992  CE1 PHE   134       5.619  29.914 165.342  1.00 28.36           C  
ATOM    993  CE2 PHE   134       5.692  29.020 163.101  1.00 32.22           C  
ATOM    994  CZ  PHE   134       6.312  29.704 164.146  1.00 32.15           C  
ATOM    995  N   GLY   135       2.023  31.142 162.815  1.00 28.79           N  
ATOM    996  CA  GLY   135       2.375  31.753 161.551  1.00 28.63           C  
ATOM    997  C   GLY   135       3.800  32.285 161.495  1.00 29.23           C  
ATOM    998  O   GLY   135       4.256  32.988 162.400  1.00 26.26           O  
ATOM    999  N   GLN   136       4.525  31.894 160.454  1.00 30.13           N  
ATOM   1000  CA  GLN   136       5.876  32.386 160.239  1.00 33.40           C  
ATOM   1001  C   GLN   136       5.803  33.029 158.850  1.00 35.44           C  
ATOM   1002  O   GLN   136       5.966  32.367 157.820  1.00 36.80           O  
ATOM   1003  CB  GLN   136       6.918  31.255 160.234  1.00 32.41           C  
ATOM   1004  CG  GLN   136       8.323  31.769 159.955  1.00 33.06           C  
ATOM   1005  CD  GLN   136       9.078  32.162 161.210  1.00 33.64           C  
ATOM   1006  OE1 GLN   136       9.444  33.324 161.394  1.00 35.68           O  
ATOM   1007  NE2 GLN   136       9.320  31.192 162.080  1.00 29.90           N  
ATOM   1008  N   VAL   137       5.562  34.331 158.825  1.00 36.19           N  
ATOM   1009  CA  VAL   137       5.419  35.064 157.572  1.00 38.42           C  
ATOM   1010  C   VAL   137       6.248  36.342 157.564  1.00 41.25           C  
ATOM   1011  O   VAL   137       6.896  36.680 158.560  1.00 41.64           O  
ATOM   1012  CB  VAL   137       3.930  35.432 157.329  1.00 36.88           C  
ATOM   1013  CG1 VAL   137       3.080  34.166 157.285  1.00 34.48           C  
ATOM   1014  CG2 VAL   137       3.421  36.348 158.450  1.00 35.11           C  
ATOM   1015  N   SER   138       6.228  37.044 156.433  1.00 41.77           N  
ATOM   1016  CA  SER   138       6.941  38.307 156.320  1.00 41.93           C  
ATOM   1017  C   SER   138       6.078  39.351 157.022  1.00 41.25           C  
ATOM   1018  O   SER   138       4.846  39.232 157.063  1.00 40.59           O  
ATOM   1019  CB  SER   138       7.123  38.712 154.859  1.00 42.90           C  
ATOM   1020  OG  SER   138       8.000  37.823 154.205  1.00 48.55           O  
ATOM   1021  N   PRO   139       6.712  40.382 157.589  1.00 42.32           N  
ATOM   1022  CA  PRO   139       6.007  41.457 158.292  1.00 43.29           C  
ATOM   1023  C   PRO   139       4.924  42.111 157.442  1.00 45.67           C  
ATOM   1024  O   PRO   139       3.968  42.681 157.974  1.00 46.01           O  
ATOM   1025  CB  PRO   139       7.131  42.436 158.684  1.00 43.98           C  
ATOM   1026  CG  PRO   139       8.358  41.958 157.932  1.00 42.13           C  
ATOM   1027  CD  PRO   139       8.170  40.487 157.766  1.00 41.37           C  
ATOM   1028  N   MET   140       5.071  42.035 156.123  1.00 47.45           N  
ATOM   1029  CA  MET   140       4.076  42.638 155.239  1.00 49.28           C  
ATOM   1030  C   MET   140       2.823  41.772 155.122  1.00 47.01           C  
ATOM   1031  O   MET   140       1.779  42.231 154.660  1.00 47.15           O  
ATOM   1032  CB  MET   140       4.690  42.930 153.855  1.00 51.82           C  
ATOM   1033  CG  MET   140       5.654  44.141 153.862  1.00 59.82           C  
ATOM   1034  SD  MET   140       5.021  45.728 152.904  1.00 78.54          SE  
ATOM   1035  CE  MET   140       3.104  45.465 153.043  1.00 71.46           C  
ATOM   1036  N   ASP   141       2.921  40.519 155.556  1.00 44.94           N  
ATOM   1037  CA  ASP   141       1.783  39.606 155.512  1.00 41.78           C  
ATOM   1038  C   ASP   141       1.064  39.456 156.859  1.00 40.48           C  
ATOM   1039  O   ASP   141      -0.003  38.844 156.926  1.00 39.11           O  
ATOM   1040  CB  ASP   141       2.233  38.221 155.051  1.00 42.04           C  
ATOM   1041  CG  ASP   141       2.523  38.160 153.568  1.00 43.17           C  
ATOM   1042  OD1 ASP   141       1.754  38.773 152.809  1.00 41.63           O  
ATOM   1043  OD2 ASP   141       3.497  37.487 153.159  1.00 43.95           O  
ATOM   1044  N   LEU   142       1.630  40.029 157.922  1.00 40.15           N  
ATOM   1045  CA  LEU   142       1.058  39.873 159.259  1.00 39.48           C  
ATOM   1046  C   LEU   142      -0.394  40.231 159.457  1.00 39.93           C  
ATOM   1047  O   LEU   142      -1.167  39.431 159.997  1.00 40.66           O  
ATOM   1048  CB  LEU   142       1.924  40.590 160.300  1.00 38.67           C  
ATOM   1049  CG  LEU   142       3.300  39.975 160.600  1.00 38.68           C  
ATOM   1050  CD1 LEU   142       4.112  40.933 161.458  1.00 42.38           C  
ATOM   1051  CD2 LEU   142       3.129  38.637 161.311  1.00 38.58           C  
ATOM   1052  N   LYS   143      -0.757  41.420 159.004  1.00 38.96           N  
ATOM   1053  CA  LYS   143      -2.117  41.903 159.110  1.00 39.51           C  
ATOM   1054  C   LYS   143      -3.068  40.971 158.364  1.00 39.15           C  
ATOM   1055  O   LYS   143      -4.116  40.575 158.884  1.00 40.10           O  
ATOM   1056  CB  LYS   143      -2.215  43.303 158.502  1.00 40.31           C  
ATOM   1057  CG  LYS   143      -3.030  44.294 159.323  1.00 43.90           C  
ATOM   1058  CD  LYS   143      -4.008  45.096 158.470  1.00 49.29           C  
ATOM   1059  CE  LYS   143      -5.421  44.522 158.568  1.00 53.76           C  
ATOM   1060  NZ  LYS   143      -6.429  45.319 157.813  1.00 56.00           N  
ATOM   1061  N   ALA   144      -2.700  40.623 157.138  1.00 39.14           N  
ATOM   1062  CA  ALA   144      -3.530  39.752 156.316  1.00 38.68           C  
ATOM   1063  C   ALA   144      -3.670  38.382 156.968  1.00 38.00           C  
ATOM   1064  O   ALA   144      -4.731  37.759 156.900  1.00 38.66           O  
ATOM   1065  CB  ALA   144      -2.929  39.621 154.911  1.00 37.15           C  
ATOM   1066  N   LEU   145      -2.602  37.918 157.611  1.00 37.83           N  
ATOM   1067  CA  LEU   145      -2.646  36.621 158.263  1.00 37.23           C  
ATOM   1068  C   LEU   145      -3.621  36.667 159.451  1.00 37.14           C  
ATOM   1069  O   LEU   145      -4.358  35.707 159.691  1.00 36.62           O  
ATOM   1070  CB  LEU   145      -1.235  36.188 158.718  1.00 36.77           C  
ATOM   1071  CG  LEU   145      -1.168  34.756 159.271  1.00 39.44           C  
ATOM   1072  CD1 LEU   145      -1.620  33.766 158.186  1.00 37.20           C  
ATOM   1073  CD2 LEU   145       0.252  34.435 159.742  1.00 35.79           C  
ATOM   1074  N   VAL   146      -3.629  37.782 160.184  1.00 37.71           N  
ATOM   1075  CA  VAL   146      -4.521  37.956 161.337  1.00 37.17           C  
ATOM   1076  C   VAL   146      -5.980  37.944 160.885  1.00 38.38           C  
ATOM   1077  O   VAL   146      -6.835  37.306 161.498  1.00 37.63           O  
ATOM   1078  CB  VAL   146      -4.253  39.297 162.050  1.00 36.80           C  
ATOM   1079  CG1 VAL   146      -5.205  39.467 163.214  1.00 35.48           C  
ATOM   1080  CG2 VAL   146      -2.811  39.358 162.525  1.00 37.51           C  
ATOM   1081  N   ASP   147      -6.256  38.672 159.807  1.00 39.95           N  
ATOM   1082  CA  ASP   147      -7.606  38.754 159.260  1.00 38.92           C  
ATOM   1083  C   ASP   147      -8.037  37.403 158.725  1.00 38.35           C  
ATOM   1084  O   ASP   147      -9.206  37.036 158.812  1.00 42.00           O  
ATOM   1085  CB  ASP   147      -7.668  39.792 158.136  1.00 40.05           C  
ATOM   1086  CG  ASP   147      -7.366  41.190 158.624  1.00 41.34           C  
ATOM   1087  OD1 ASP   147      -7.807  41.532 159.743  1.00 43.67           O  
ATOM   1088  OD2 ASP   147      -6.697  41.948 157.892  1.00 43.65           O  
ATOM   1089  N   ALA   148      -7.085  36.658 158.171  1.00 36.95           N  
ATOM   1090  CA  ALA   148      -7.374  35.335 157.625  1.00 34.18           C  
ATOM   1091  C   ALA   148      -7.538  34.295 158.726  1.00 34.08           C  
ATOM   1092  O   ALA   148      -8.441  33.463 158.683  1.00 31.80           O  
ATOM   1093  CB  ALA   148      -6.259  34.907 156.667  1.00 33.64           C  
ATOM   1094  N   ALA   149      -6.658  34.343 159.716  1.00 33.69           N  
ATOM   1095  CA  ALA   149      -6.696  33.377 160.798  1.00 33.43           C  
ATOM   1096  C   ALA   149      -7.799  33.579 161.834  1.00 33.55           C  
ATOM   1097  O   ALA   149      -8.396  32.609 162.312  1.00 34.44           O  
ATOM   1098  CB  ALA   149      -5.327  33.330 161.489  1.00 34.63           C  
ATOM   1099  N   TRP   150      -8.088  34.830 162.172  1.00 35.02           N  
ATOM   1100  CA  TRP   150      -9.084  35.104 163.208  1.00 35.52           C  
ATOM   1101  C   TRP   150     -10.392  34.341 163.089  1.00 36.07           C  
ATOM   1102  O   TRP   150     -10.829  33.698 164.051  1.00 36.77           O  
ATOM   1103  CB  TRP   150      -9.368  36.609 163.312  1.00 36.87           C  
ATOM   1104  CG  TRP   150      -9.881  37.006 164.678  1.00 39.34           C  
ATOM   1105  CD1 TRP   150     -11.103  37.530 164.976  1.00 38.91           C  
ATOM   1106  CD2 TRP   150      -9.185  36.875 165.928  1.00 38.85           C  
ATOM   1107  NE1 TRP   150     -11.213  37.738 166.333  1.00 40.42           N  
ATOM   1108  CE2 TRP   150     -10.049  37.348 166.940  1.00 39.56           C  
ATOM   1109  CE3 TRP   150      -7.910  36.414 166.288  1.00 40.01           C  
ATOM   1110  CZ2 TRP   150      -9.686  37.359 168.296  1.00 38.56           C  
ATOM   1111  CZ3 TRP   150      -7.546  36.428 167.635  1.00 41.47           C  
ATOM   1112  CH2 TRP   150      -8.431  36.904 168.620  1.00 41.64           C  
ATOM   1113  N   PRO   151     -11.030  34.386 161.912  1.00 36.28           N  
ATOM   1114  CA  PRO   151     -12.297  33.668 161.748  1.00 36.18           C  
ATOM   1115  C   PRO   151     -12.183  32.164 161.992  1.00 34.50           C  
ATOM   1116  O   PRO   151     -13.130  31.534 162.451  1.00 34.71           O  
ATOM   1117  CB  PRO   151     -12.690  33.958 160.295  1.00 37.11           C  
ATOM   1118  CG  PRO   151     -11.968  35.221 159.959  1.00 37.77           C  
ATOM   1119  CD  PRO   151     -10.652  35.100 160.679  1.00 35.64           C  
ATOM   1120  N   LEU   152     -11.022  31.593 161.679  1.00 34.79           N  
ATOM   1121  CA  LEU   152     -10.801  30.153 161.836  1.00 35.06           C  
ATOM   1122  C   LEU   152     -10.602  29.733 163.289  1.00 34.90           C  
ATOM   1123  O   LEU   152     -10.874  28.596 163.669  1.00 35.83           O  
ATOM   1124  CB  LEU   152      -9.588  29.721 161.011  1.00 35.31           C  
ATOM   1125  CG  LEU   152      -9.532  30.146 159.535  1.00 32.06           C  
ATOM   1126  CD1 LEU   152      -8.139  29.863 158.949  1.00 28.65           C  
ATOM   1127  CD2 LEU   152     -10.608  29.410 158.747  1.00 30.78           C  
ATOM   1128  N   LEU   153     -10.130  30.668 164.101  1.00 36.20           N  
ATOM   1129  CA  LEU   153      -9.865  30.413 165.514  1.00 35.55           C  
ATOM   1130  C   LEU   153     -11.086  30.273 166.380  1.00 35.15           C  
ATOM   1131  O   LEU   153     -12.043  31.021 166.223  1.00 36.38           O  
ATOM   1132  CB  LEU   153      -9.014  31.525 166.110  1.00 34.73           C  
ATOM   1133  CG  LEU   153      -7.490  31.460 166.042  1.00 35.40           C  
ATOM   1134  CD1 LEU   153      -6.906  32.700 166.722  1.00 37.52           C  
ATOM   1135  CD2 LEU   153      -6.991  30.175 166.744  1.00 23.36           C  
ATOM   1136  N   ARG   154     -11.058  29.310 167.296  1.00 36.30           N  
ATOM   1137  CA  ARG   154     -12.162  29.145 168.232  1.00 36.51           C  
ATOM   1138  C   ARG   154     -11.818  30.000 169.474  1.00 36.76           C  
ATOM   1139  O   ARG   154     -10.651  30.379 169.676  1.00 33.72           O  
ATOM   1140  CB  ARG   154     -12.319  27.674 168.634  1.00 36.75           C  
ATOM   1141  CG  ARG   154     -12.718  26.785 167.478  1.00 37.06           C  
ATOM   1142  CD  ARG   154     -12.577  25.313 167.811  1.00 37.83           C  
ATOM   1143  NE  ARG   154     -13.585  24.850 168.759  1.00 45.05           N  
ATOM   1144  CZ  ARG   154     -14.877  24.707 168.473  1.00 47.28           C  
ATOM   1145  NH1 ARG   154     -15.331  24.991 167.257  1.00 41.82           N  
ATOM   1146  NH2 ARG   154     -15.710  24.265 169.404  1.00 47.48           N  
ATOM   1147  N   ARG   155     -12.823  30.308 170.295  1.00 37.44           N  
ATOM   1148  CA  ARG   155     -12.610  31.086 171.514  1.00 37.17           C  
ATOM   1149  C   ARG   155     -11.747  30.192 172.403  1.00 35.22           C  
ATOM   1150  O   ARG   155     -11.978  28.975 172.493  1.00 36.48           O  
ATOM   1151  CB  ARG   155     -13.961  31.403 172.183  1.00 38.81           C  
ATOM   1152  CG  ARG   155     -14.937  32.087 171.233  1.00 42.34           C  
ATOM   1153  CD  ARG   155     -16.218  32.427 171.953  1.00 47.96           C  
ATOM   1154  NE  ARG   155     -16.064  33.616 172.784  1.00 54.25           N  
ATOM   1155  CZ  ARG   155     -16.418  34.843 172.409  1.00 56.26           C  
ATOM   1156  NH1 ARG   155     -16.953  35.045 171.210  1.00 56.53           N  
ATOM   1157  NH2 ARG   155     -16.230  35.868 173.234  1.00 56.32           N  
ATOM   1158  N   GLY   156     -10.764  30.799 173.062  1.00 32.13           N  
ATOM   1159  CA  GLY   156      -9.822  30.049 173.880  1.00 30.79           C  
ATOM   1160  C   GLY   156      -8.670  29.644 172.940  1.00 29.86           C  
ATOM   1161  O   GLY   156      -7.673  29.034 173.361  1.00 28.96           O  
ATOM   1162  N   GLY   157      -8.795  30.009 171.657  1.00 28.58           N  
ATOM   1163  CA  GLY   157      -7.783  29.685 170.652  1.00 26.53           C  
ATOM   1164  C   GLY   157      -6.719  30.750 170.521  1.00 26.35           C  
ATOM   1165  O   GLY   157      -6.981  31.934 170.724  1.00 26.49           O  
ATOM   1166  N   ALA   158      -5.517  30.330 170.143  1.00 26.28           N  
ATOM   1167  CA  ALA   158      -4.402  31.253 170.021  1.00 26.53           C  
ATOM   1168  C   ALA   158      -3.752  31.338 168.663  1.00 27.37           C  
ATOM   1169  O   ALA   158      -3.498  30.317 168.023  1.00 27.64           O  
ATOM   1170  CB  ALA   158      -3.333  30.924 171.057  1.00 24.38           C  
ATOM   1171  N   LEU   159      -3.468  32.568 168.245  1.00 28.32           N  
ATOM   1172  CA  LEU   159      -2.747  32.823 167.013  1.00 28.11           C  
ATOM   1173  C   LEU   159      -1.342  33.223 167.503  1.00 27.21           C  
ATOM   1174  O   LEU   159      -1.189  34.162 168.296  1.00 26.79           O  
ATOM   1175  CB  LEU   159      -3.371  33.994 166.234  1.00 28.52           C  
ATOM   1176  CG  LEU   159      -2.577  34.518 165.030  1.00 31.81           C  
ATOM   1177  CD1 LEU   159      -2.417  33.424 163.973  1.00 33.87           C  
ATOM   1178  CD2 LEU   159      -3.322  35.715 164.451  1.00 31.17           C  
ATOM   1179  N   VAL   160      -0.322  32.501 167.047  1.00 25.88           N  
ATOM   1180  CA  VAL   160       1.064  32.772 167.428  1.00 24.79           C  
ATOM   1181  C   VAL   160       1.858  33.296 166.232  1.00 27.75           C  
ATOM   1182  O   VAL   160       2.033  32.591 165.232  1.00 26.63           O  
ATOM   1183  CB  VAL   160       1.738  31.501 167.987  1.00 24.17           C  
ATOM   1184  CG1 VAL   160       3.150  31.821 168.438  1.00 23.11           C  
ATOM   1185  CG2 VAL   160       0.923  30.964 169.163  1.00 19.43           C  
ATOM   1186  N   LEU   161       2.338  34.537 166.340  1.00 29.92           N  
ATOM   1187  CA  LEU   161       3.088  35.183 165.258  1.00 31.39           C  
ATOM   1188  C   LEU   161       4.569  35.347 165.580  1.00 33.08           C  
ATOM   1189  O   LEU   161       4.957  36.203 166.376  1.00 32.56           O  
ATOM   1190  CB  LEU   161       2.467  36.550 164.943  1.00 31.04           C  
ATOM   1191  CG  LEU   161       0.954  36.513 164.655  1.00 29.82           C  
ATOM   1192  CD1 LEU   161       0.395  37.937 164.570  1.00 26.88           C  
ATOM   1193  CD2 LEU   161       0.693  35.749 163.363  1.00 26.34           C  
ATOM   1194  N   ALA   162       5.394  34.522 164.946  1.00 33.46           N  
ATOM   1195  CA  ALA   162       6.841  34.557 165.155  1.00 35.04           C  
ATOM   1196  C   ALA   162       7.519  35.821 164.628  1.00 36.17           C  
ATOM   1197  O   ALA   162       7.108  36.373 163.604  1.00 36.48           O  
ATOM   1198  CB  ALA   162       7.484  33.337 164.511  1.00 35.01           C  
ATOM   1199  N   ASP   163       8.559  36.260 165.343  1.00 35.67           N  
ATOM   1200  CA  ASP   163       9.367  37.428 164.980  1.00 35.23           C  
ATOM   1201  C   ASP   163       8.577  38.664 164.556  1.00 34.80           C  
ATOM   1202  O   ASP   163       9.082  39.491 163.803  1.00 37.18           O  
ATOM   1203  CB  ASP   163      10.324  37.063 163.848  1.00 36.36           C  
ATOM   1204  CG  ASP   163      11.103  35.796 164.126  1.00 38.68           C  
ATOM   1205  OD1 ASP   163      11.514  35.602 165.286  1.00 41.88           O  
ATOM   1206  OD2 ASP   163      11.319  34.996 163.186  1.00 44.47           O  
ATOM   1207  N   ALA   164       7.352  38.800 165.048  1.00 34.25           N  
ATOM   1208  CA  ALA   164       6.485  39.911 164.677  1.00 35.10           C  
ATOM   1209  C   ALA   164       6.843  41.287 165.218  1.00 37.45           C  
ATOM   1210  O   ALA   164       6.275  42.297 164.783  1.00 36.35           O  
ATOM   1211  CB  ALA   164       5.058  39.579 165.062  1.00 34.18           C  
ATOM   1212  N   LEU   165       7.782  41.327 166.155  1.00 38.68           N  
ATOM   1213  CA  LEU   165       8.179  42.576 166.783  1.00 41.51           C  
ATOM   1214  C   LEU   165       9.527  43.091 166.299  1.00 43.63           C  
ATOM   1215  O   LEU   165       9.965  44.174 166.688  1.00 44.67           O  
ATOM   1216  CB  LEU   165       8.215  42.389 168.300  1.00 40.59           C  
ATOM   1217  CG  LEU   165       6.898  42.048 169.005  1.00 37.73           C  
ATOM   1218  CD1 LEU   165       7.169  41.504 170.401  1.00 39.58           C  
ATOM   1219  CD2 LEU   165       6.026  43.291 169.080  1.00 42.32           C  
ATOM   1220  N   LEU   166      10.172  42.306 165.446  1.00 46.20           N  
ATOM   1221  CA  LEU   166      11.477  42.650 164.900  1.00 47.74           C  
ATOM   1222  C   LEU   166      12.459  43.155 165.952  1.00 49.34           C  
ATOM   1223  O   LEU   166      13.031  44.241 165.822  1.00 48.89           O  
ATOM   1224  CB  LEU   166      11.326  43.671 163.760  1.00 47.18           C  
ATOM   1225  CG  LEU   166      10.589  43.140 162.518  1.00 47.23           C  
ATOM   1226  CD1 LEU   166      10.505  44.215 161.444  1.00 48.55           C  
ATOM   1227  CD2 LEU   166      11.325  41.922 161.986  1.00 48.26           C  
ATOM   1228  N   ASP   167      12.632  42.357 167.004  1.00 51.27           N  
ATOM   1229  CA  ASP   167      13.570  42.673 168.073  1.00 52.31           C  
ATOM   1230  C   ASP   167      13.333  44.014 168.764  1.00 53.19           C  
ATOM   1231  O   ASP   167      14.231  44.548 169.422  1.00 53.46           O  
ATOM   1232  CB  ASP   167      14.992  42.629 167.513  1.00 53.31           C  
ATOM   1233  CG  ASP   167      15.465  41.213 167.224  1.00 54.32           C  
ATOM   1234  OD1 ASP   167      15.400  40.377 168.146  1.00 57.29           O  
ATOM   1235  OD2 ASP   167      15.913  40.938 166.089  1.00 59.10           O  
ATOM   1236  N   GLY   168      12.123  44.545 168.614  1.00 54.04           N  
ATOM   1237  CA  GLY   168      11.793  45.823 169.209  1.00 56.23           C  
ATOM   1238  C   GLY   168      12.089  46.953 168.235  1.00 58.04           C  
ATOM   1239  O   GLY   168      11.750  48.110 168.482  1.00 57.65           O  
ATOM   1240  N   THR   169      12.735  46.611 167.124  1.00 59.91           N  
ATOM   1241  CA  THR   169      13.095  47.571 166.079  1.00 61.31           C  
ATOM   1242  C   THR   169      12.033  48.640 165.864  1.00 62.28           C  
ATOM   1243  O   THR   169      12.365  49.803 165.619  1.00 63.59           O  
ATOM   1244  CB  THR   169      13.342  46.846 164.726  1.00 60.94           C  
ATOM   1245  OG1 THR   169      14.680  46.335 164.684  1.00 60.61           O  
ATOM   1246  CG2 THR   169      13.109  47.780 163.544  1.00 62.48           C  
ATOM   1247  N   ILE   170      10.762  48.250 165.954  1.00 63.65           N  
ATOM   1248  CA  ILE   170       9.677  49.198 165.728  1.00 65.26           C  
ATOM   1249  C   ILE   170       9.646  50.344 166.743  1.00 67.56           C  
ATOM   1250  O   ILE   170      10.360  50.315 167.740  1.00 67.27           O  
ATOM   1251  CB  ILE   170       8.300  48.465 165.611  1.00 64.43           C  
ATOM   1252  CG1 ILE   170       8.059  47.560 166.808  1.00 65.08           C  
ATOM   1253  CG2 ILE   170       8.284  47.632 164.319  1.00 63.91           C  
ATOM   1254  CD1 ILE   170       6.824  46.694 166.661  1.00 61.22           C  
ATOM   1255  N   ALA   171       8.815  51.349 166.477  1.00 71.03           N  
ATOM   1256  CA  ALA   171       8.732  52.562 167.298  1.00 74.04           C  
ATOM   1257  C   ALA   171      10.147  53.153 167.376  1.00 76.78           C  
ATOM   1258  O   ALA   171      10.730  53.279 168.460  1.00 77.43           O  
ATOM   1259  CB  ALA   171       8.222  52.258 168.694  1.00 74.35           C  
ATOM   1260  N   ASP   172      10.699  53.525 166.223  1.00 79.39           N  
ATOM   1261  CA  ASP   172      12.045  54.097 166.162  1.00 81.44           C  
ATOM   1262  C   ASP   172      12.123  55.050 164.972  1.00 82.22           C  
ATOM   1263  O   ASP   172      12.056  54.625 163.819  1.00 83.14           O  
ATOM   1264  CB  ASP   172      13.070  52.972 165.995  1.00 81.68           C  
ATOM   1265  CG  ASP   172      14.447  53.340 166.498  1.00 85.84           C  
ATOM   1266  OD1 ASP   172      14.833  54.516 166.380  1.00 90.92           O  
ATOM   1267  OD2 ASP   172      15.153  52.441 166.997  1.00 87.39           O  
ATOM   1268  N   GLN   173      12.282  56.336 165.262  1.00 82.92           N  
ATOM   1269  CA  GLN   173      12.352  57.356 164.224  1.00 83.98           C  
ATOM   1270  C   GLN   173      13.324  57.023 163.106  1.00 83.45           C  
ATOM   1271  O   GLN   173      12.969  57.063 161.933  1.00 83.90           O  
ATOM   1272  CB  GLN   173      12.712  58.717 164.834  1.00 84.72           C  
ATOM   1273  CG  GLN   173      11.607  59.350 165.690  1.00 88.73           C  
ATOM   1274  CD  GLN   173      11.323  58.578 166.965  1.00 91.02           C  
ATOM   1275  OE1 GLN   173      12.243  58.150 167.655  1.00 91.29           O  
ATOM   1276  NE2 GLN   173      10.044  58.415 167.295  1.00 90.94           N  
ATOM   1277  N   THR   174      14.550  56.679 163.477  1.00 82.77           N  
ATOM   1278  CA  THR   174      15.575  56.341 162.498  1.00 82.11           C  
ATOM   1279  C   THR   174      15.135  55.223 161.573  1.00 81.93           C  
ATOM   1280  O   THR   174      15.240  55.333 160.348  1.00 81.65           O  
ATOM   1281  CB  THR   174      16.901  55.902 163.178  1.00 82.03           C  
ATOM   1282  OG1 THR   174      16.664  54.764 164.022  1.00 82.87           O  
ATOM   1283  CG2 THR   174      17.494  57.036 164.004  1.00 80.61           C  
ATOM   1284  N   ARG   175      14.620  54.155 162.170  1.00 81.42           N  
ATOM   1285  CA  ARG   175      14.203  52.990 161.400  1.00 80.76           C  
ATOM   1286  C   ARG   175      13.016  53.134 160.457  1.00 80.26           C  
ATOM   1287  O   ARG   175      11.901  52.742 160.806  1.00 80.41           O  
ATOM   1288  CB  ARG   175      13.966  51.805 162.341  1.00 80.91           C  
ATOM   1289  CG  ARG   175      14.234  50.422 161.726  1.00 82.08           C  
ATOM   1290  CD  ARG   175      15.675  49.988 161.956  1.00 84.76           C  
ATOM   1291  NE  ARG   175      16.086  50.219 163.341  1.00 85.35           N  
ATOM   1292  CZ  ARG   175      17.050  49.545 163.962  1.00 86.15           C  
ATOM   1293  NH1 ARG   175      17.712  48.585 163.327  1.00 83.31           N  
ATOM   1294  NH2 ARG   175      17.346  49.826 165.226  1.00 86.88           N  
ATOM   1295  N   LYS   176      13.252  53.728 159.283  1.00 79.32           N  
ATOM   1296  CA  LYS   176      12.200  53.819 158.277  1.00 77.64           C  
ATOM   1297  C   LYS   176      12.482  52.544 157.460  1.00 76.67           C  
ATOM   1298  O   LYS   176      13.654  52.147 157.250  1.00 76.95           O  
ATOM   1299  CB  LYS   176      12.349  55.063 157.415  1.00 78.36           C  
ATOM   1300  N   ASP   177      11.419  51.901 156.986  1.00 73.97           N  
ATOM   1301  CA  ASP   177      11.555  50.614 156.296  1.00 71.10           C  
ATOM   1302  C   ASP   177      10.173  50.140 155.855  1.00 69.68           C  
ATOM   1303  O   ASP   177       9.176  50.354 156.551  1.00 69.25           O  
ATOM   1304  CB  ASP   177      12.096  49.619 157.317  1.00 71.15           C  
ATOM   1305  CG  ASP   177      13.030  48.583 156.729  1.00 71.21           C  
ATOM   1306  OD1 ASP   177      13.875  48.966 155.902  1.00 71.86           O  
ATOM   1307  OD2 ASP   177      12.938  47.392 157.122  1.00 69.21           O  
ATOM   1308  N   ARG   178      10.122  49.464 154.716  1.00 67.48           N  
ATOM   1309  CA  ARG   178       8.873  48.908 154.231  1.00 65.11           C  
ATOM   1310  C   ARG   178       8.368  47.952 155.319  1.00 62.93           C  
ATOM   1311  O   ARG   178       7.205  47.995 155.716  1.00 61.37           O  
ATOM   1312  CB  ARG   178       9.120  48.129 152.934  1.00 65.76           C  
ATOM   1313  N   ASP   179       9.258  47.081 155.789  1.00 61.40           N  
ATOM   1314  CA  ASP   179       8.914  46.072 156.785  1.00 61.31           C  
ATOM   1315  C   ASP   179       8.565  46.570 158.176  1.00 61.77           C  
ATOM   1316  O   ASP   179       7.499  46.240 158.708  1.00 62.54           O  
ATOM   1317  CB  ASP   179      10.025  45.013 156.857  1.00 60.28           C  
ATOM   1318  CG  ASP   179       9.996  44.057 155.657  1.00 60.29           C  
ATOM   1319  OD1 ASP   179       8.969  44.025 154.933  1.00 56.76           O  
ATOM   1320  OD2 ASP   179      10.993  43.330 155.451  1.00 58.00           O  
ATOM   1321  N   THR   180       9.457  47.362 158.756  1.00 61.26           N  
ATOM   1322  CA  THR   180       9.238  47.899 160.085  1.00 60.59           C  
ATOM   1323  C   THR   180       7.871  48.589 160.156  1.00 59.22           C  
ATOM   1324  O   THR   180       7.154  48.475 161.156  1.00 59.51           O  
ATOM   1325  CB  THR   180      10.351  48.910 160.457  1.00 60.28           C  
ATOM   1326  OG1 THR   180      10.457  48.997 161.881  1.00 63.84           O  
ATOM   1327  CG2 THR   180      10.034  50.299 159.913  1.00 62.53           C  
ATOM   1328  N   GLN   181       7.517  49.301 159.089  1.00 57.42           N  
ATOM   1329  CA  GLN   181       6.250  50.026 159.021  1.00 56.34           C  
ATOM   1330  C   GLN   181       5.053  49.083 158.956  1.00 54.30           C  
ATOM   1331  O   GLN   181       3.980  49.394 159.486  1.00 55.01           O  
ATOM   1332  CB  GLN   181       6.247  50.951 157.799  1.00 56.61           C  
ATOM   1333  CG  GLN   181       5.074  51.905 157.722  1.00 60.31           C  
ATOM   1334  CD  GLN   181       5.224  52.896 156.579  1.00 66.50           C  
ATOM   1335  OE1 GLN   181       6.338  53.162 156.123  1.00 68.79           O  
ATOM   1336  NE2 GLN   181       4.108  53.467 156.131  1.00 65.27           N  
ATOM   1337  N   ALA   182       5.241  47.936 158.308  1.00 52.30           N  
ATOM   1338  CA  ALA   182       4.177  46.945 158.188  1.00 51.70           C  
ATOM   1339  C   ALA   182       4.042  46.221 159.534  1.00 49.61           C  
ATOM   1340  O   ALA   182       2.929  45.999 160.011  1.00 48.87           O  
ATOM   1341  CB  ALA   182       4.504  45.948 157.068  1.00 51.18           C  
ATOM   1342  N   ALA   183       5.175  45.864 160.141  1.00 47.78           N  
ATOM   1343  CA  ALA   183       5.170  45.196 161.439  1.00 49.10           C  
ATOM   1344  C   ALA   183       4.535  46.152 162.474  1.00 50.05           C  
ATOM   1345  O   ALA   183       3.764  45.721 163.333  1.00 49.60           O  
ATOM   1346  CB  ALA   183       6.601  44.831 161.846  1.00 47.67           C  
ATOM   1347  N   ARG   184       4.849  47.448 162.392  1.00 51.31           N  
ATOM   1348  CA  ARG   184       4.283  48.433 163.319  1.00 52.65           C  
ATOM   1349  C   ARG   184       2.760  48.504 163.162  1.00 53.41           C  
ATOM   1350  O   ARG   184       2.031  48.534 164.157  1.00 53.91           O  
ATOM   1351  CB  ARG   184       4.872  49.820 163.066  1.00 54.06           C  
ATOM   1352  CG  ARG   184       5.157  50.600 164.341  1.00 57.28           C  
ATOM   1353  CD  ARG   184       5.260  52.096 164.094  1.00 59.50           C  
ATOM   1354  NE  ARG   184       6.262  52.446 163.092  1.00 61.89           N  
ATOM   1355  CZ  ARG   184       7.549  52.123 163.171  1.00 65.18           C  
ATOM   1356  NH1 ARG   184       8.000  51.441 164.209  1.00 66.46           N  
ATOM   1357  NH2 ARG   184       8.390  52.486 162.210  1.00 67.83           N  
ATOM   1358  N   ASP   185       2.280  48.532 161.917  1.00 53.41           N  
ATOM   1359  CA  ASP   185       0.838  48.596 161.664  1.00 54.19           C  
ATOM   1360  C   ASP   185       0.141  47.321 162.135  1.00 52.11           C  
ATOM   1361  O   ASP   185      -0.988  47.361 162.637  1.00 51.76           O  
ATOM   1362  CB  ASP   185       0.545  48.817 160.177  1.00 55.83           C  
ATOM   1363  CG  ASP   185      -0.940  48.873 159.884  1.00 63.25           C  
ATOM   1364  OD1 ASP   185      -1.551  47.806 159.669  1.00 71.31           O  
ATOM   1365  OD2 ASP   185      -1.503  49.988 159.886  1.00 73.27           O  
ATOM   1366  N   ALA   186       0.817  46.189 161.972  1.00 50.23           N  
ATOM   1367  CA  ALA   186       0.269  44.908 162.407  1.00 48.60           C  
ATOM   1368  C   ALA   186       0.097  44.960 163.936  1.00 46.32           C  
ATOM   1369  O   ALA   186      -0.975  44.666 164.459  1.00 45.88           O  
ATOM   1370  CB  ALA   186       1.220  43.776 162.022  1.00 47.52           C  
ATOM   1371  N   ASP   187       1.157  45.336 164.646  1.00 45.93           N  
ATOM   1372  CA  ASP   187       1.121  45.421 166.106  1.00 46.57           C  
ATOM   1373  C   ASP   187      -0.020  46.353 166.537  1.00 46.63           C  
ATOM   1374  O   ASP   187      -0.879  45.975 167.341  1.00 46.91           O  
ATOM   1375  CB  ASP   187       2.474  45.939 166.620  1.00 45.25           C  
ATOM   1376  CG  ASP   187       2.575  45.923 168.138  1.00 49.55           C  
ATOM   1377  OD1 ASP   187       2.652  44.821 168.735  1.00 45.87           O  
ATOM   1378  OD2 ASP   187       2.569  47.024 168.736  1.00 50.96           O  
ATOM   1379  N   GLU   188      -0.024  47.571 166.001  1.00 46.68           N  
ATOM   1380  CA  GLU   188      -1.064  48.545 166.320  1.00 46.47           C  
ATOM   1381  C   GLU   188      -2.450  47.988 165.972  1.00 45.29           C  
ATOM   1382  O   GLU   188      -3.409  48.177 166.717  1.00 44.23           O  
ATOM   1383  CB  GLU   188      -0.806  49.845 165.548  1.00 47.29           C  
ATOM   1384  CG  GLU   188      -1.912  50.873 165.661  1.00 52.14           C  
ATOM   1385  CD  GLU   188      -1.559  52.167 164.960  1.00 58.46           C  
ATOM   1386  OE1 GLU   188      -0.450  52.686 165.211  1.00 60.41           O  
ATOM   1387  OE2 GLU   188      -2.388  52.672 164.171  1.00 57.72           O  
ATOM   1388  N   TYR   189      -2.552  47.304 164.835  1.00 44.78           N  
ATOM   1389  CA  TYR   189      -3.822  46.712 164.409  1.00 43.79           C  
ATOM   1390  C   TYR   189      -4.226  45.571 165.343  1.00 42.73           C  
ATOM   1391  O   TYR   189      -5.385  45.467 165.753  1.00 43.44           O  
ATOM   1392  CB  TYR   189      -3.716  46.157 162.994  1.00 43.66           C  
ATOM   1393  CG  TYR   189      -4.990  45.489 162.538  1.00 43.06           C  
ATOM   1394  CD1 TYR   189      -6.135  46.241 162.280  1.00 45.51           C  
ATOM   1395  CD2 TYR   189      -5.064  44.104 162.395  1.00 40.70           C  
ATOM   1396  CE1 TYR   189      -7.320  45.635 161.886  1.00 48.14           C  
ATOM   1397  CE2 TYR   189      -6.248  43.483 162.003  1.00 43.88           C  
ATOM   1398  CZ  TYR   189      -7.370  44.256 161.751  1.00 46.56           C  
ATOM   1399  OH  TYR   189      -8.540  43.659 161.351  1.00 45.85           O  
ATOM   1400  N   ILE   190      -3.268  44.710 165.676  1.00 41.78           N  
ATOM   1401  CA  ILE   190      -3.536  43.587 166.562  1.00 39.45           C  
ATOM   1402  C   ILE   190      -4.024  44.084 167.931  1.00 39.67           C  
ATOM   1403  O   ILE   190      -4.950  43.518 168.511  1.00 38.60           O  
ATOM   1404  CB  ILE   190      -2.267  42.701 166.725  1.00 40.19           C  
ATOM   1405  CG1 ILE   190      -2.089  41.824 165.479  1.00 36.29           C  
ATOM   1406  CG2 ILE   190      -2.366  41.848 167.998  1.00 37.83           C  
ATOM   1407  CD1 ILE   190      -0.753  41.100 165.413  1.00 26.27           C  
ATOM   1408  N   ARG   191      -3.404  45.142 168.445  1.00 40.01           N  
ATOM   1409  CA  ARG   191      -3.792  45.684 169.743  1.00 43.13           C  
ATOM   1410  C   ARG   191      -5.132  46.419 169.725  1.00 44.80           C  
ATOM   1411  O   ARG   191      -5.630  46.842 170.766  1.00 44.64           O  
ATOM   1412  CB  ARG   191      -2.695  46.611 170.265  1.00 41.94           C  
ATOM   1413  CG  ARG   191      -1.437  45.882 170.742  1.00 42.77           C  
ATOM   1414  CD  ARG   191      -0.238  46.814 170.764  1.00 46.32           C  
ATOM   1415  NE  ARG   191      -0.668  48.195 170.934  1.00 51.32           N  
ATOM   1416  CZ  ARG   191      -0.136  49.228 170.292  1.00 50.72           C  
ATOM   1417  NH1 ARG   191       0.853  49.047 169.427  1.00 50.42           N  
ATOM   1418  NH2 ARG   191      -0.598  50.446 170.515  1.00 53.35           N  
ATOM   1419  N   SER   192      -5.725  46.543 168.543  1.00 45.68           N  
ATOM   1420  CA  SER   192      -6.994  47.240 168.393  1.00 46.18           C  
ATOM   1421  C   SER   192      -8.188  46.294 168.323  1.00 46.25           C  
ATOM   1422  O   SER   192      -9.328  46.721 168.519  1.00 46.21           O  
ATOM   1423  CB  SER   192      -6.979  48.097 167.124  1.00 47.71           C  
ATOM   1424  OG  SER   192      -7.303  47.324 165.967  1.00 47.27           O  
ATOM   1425  N   ILE   193      -7.944  45.015 168.046  1.00 47.19           N  
ATOM   1426  CA  ILE   193      -9.054  44.092 167.912  1.00 46.69           C  
ATOM   1427  C   ILE   193      -9.698  43.766 169.246  1.00 45.97           C  
ATOM   1428  O   ILE   193      -9.027  43.638 170.263  1.00 45.13           O  
ATOM   1429  CB  ILE   193      -8.627  42.829 167.096  1.00 46.55           C  
ATOM   1430  CG1 ILE   193      -9.275  41.581 167.659  1.00 48.58           C  
ATOM   1431  CG2 ILE   193      -7.122  42.735 167.017  1.00 48.52           C  
ATOM   1432  CD1 ILE   193      -8.374  40.370 167.601  1.00 53.08           C  
ATOM   1433  N   GLU   194     -11.020  43.641 169.220  1.00 46.10           N  
ATOM   1434  CA  GLU   194     -11.803  43.405 170.419  1.00 46.72           C  
ATOM   1435  C   GLU   194     -12.074  41.944 170.734  1.00 45.13           C  
ATOM   1436  O   GLU   194     -12.243  41.126 169.834  1.00 44.75           O  
ATOM   1437  CB  GLU   194     -13.119  44.175 170.299  1.00 48.29           C  
ATOM   1438  CG  GLU   194     -13.732  44.629 171.616  1.00 53.72           C  
ATOM   1439  CD  GLU   194     -13.127  45.922 172.135  1.00 60.45           C  
ATOM   1440  OE1 GLU   194     -12.510  46.656 171.332  1.00 61.44           O  
ATOM   1441  OE2 GLU   194     -13.287  46.211 173.341  1.00 63.38           O  
ATOM   1442  N   GLY   195     -12.123  41.631 172.022  1.00 42.68           N  
ATOM   1443  CA  GLY   195     -12.355  40.262 172.422  1.00 41.19           C  
ATOM   1444  C   GLY   195     -11.115  39.427 172.149  1.00 38.96           C  
ATOM   1445  O   GLY   195     -11.204  38.228 171.879  1.00 38.68           O  
ATOM   1446  N   ALA   196      -9.949  40.069 172.193  1.00 37.97           N  
ATOM   1447  CA  ALA   196      -8.669  39.386 171.968  1.00 38.03           C  
ATOM   1448  C   ALA   196      -7.746  39.616 173.142  1.00 38.17           C  
ATOM   1449  O   ALA   196      -7.723  40.713 173.714  1.00 39.15           O  
ATOM   1450  CB  ALA   196      -7.979  39.904 170.722  1.00 37.01           C  
ATOM   1451  N   HIS   197      -6.990  38.587 173.518  1.00 36.67           N  
ATOM   1452  CA  HIS   197      -5.979  38.759 174.559  1.00 34.86           C  
ATOM   1453  C   HIS   197      -4.672  38.817 173.766  1.00 34.12           C  
ATOM   1454  O   HIS   197      -4.383  37.946 172.928  1.00 34.95           O  
ATOM   1455  CB  HIS   197      -5.904  37.572 175.516  1.00 34.32           C  
ATOM   1456  CG  HIS   197      -7.163  37.314 176.261  1.00 30.53           C  
ATOM   1457  ND1 HIS   197      -7.739  38.243 177.100  1.00 28.83           N  
ATOM   1458  CD2 HIS   197      -7.935  36.209 176.330  1.00 32.70           C  
ATOM   1459  CE1 HIS   197      -8.814  37.717 177.656  1.00 29.31           C  
ATOM   1460  NE2 HIS   197      -8.955  36.484 177.205  1.00 27.66           N  
ATOM   1461  N   VAL   198      -3.887  39.856 174.006  1.00 32.85           N  
ATOM   1462  CA  VAL   198      -2.614  40.026 173.315  1.00 31.44           C  
ATOM   1463  C   VAL   198      -1.459  39.870 174.291  1.00 31.83           C  
ATOM   1464  O   VAL   198      -1.404  40.553 175.311  1.00 33.09           O  
ATOM   1465  CB  VAL   198      -2.521  41.420 172.641  1.00 32.23           C  
ATOM   1466  CG1 VAL   198      -1.167  41.590 171.962  1.00 29.85           C  
ATOM   1467  CG2 VAL   198      -3.662  41.584 171.629  1.00 31.51           C  
ATOM   1468  N   ALA   199      -0.555  38.942 173.991  1.00 31.03           N  
ATOM   1469  CA  ALA   199       0.623  38.735 174.820  1.00 30.46           C  
ATOM   1470  C   ALA   199       1.808  38.865 173.865  1.00 30.64           C  
ATOM   1471  O   ALA   199       1.832  38.228 172.812  1.00 30.97           O  
ATOM   1472  CB  ALA   199       0.609  37.340 175.471  1.00 28.20           C  
ATOM   1473  N   ARG   200       2.775  39.707 174.212  1.00 30.50           N  
ATOM   1474  CA  ARG   200       3.949  39.902 173.383  1.00 31.66           C  
ATOM   1475  C   ARG   200       5.137  39.535 174.265  1.00 32.61           C  
ATOM   1476  O   ARG   200       5.411  40.170 175.282  1.00 33.33           O  
ATOM   1477  CB  ARG   200       3.962  41.351 172.862  1.00 31.67           C  
ATOM   1478  CG  ARG   200       2.891  41.543 171.766  1.00 36.13           C  
ATOM   1479  CD  ARG   200       2.761  43.000 171.353  1.00 37.83           C  
ATOM   1480  NE  ARG   200       2.310  43.827 172.467  1.00 38.02           N  
ATOM   1481  CZ  ARG   200       2.536  45.129 172.561  1.00 37.23           C  
ATOM   1482  NH1 ARG   200       3.209  45.752 171.599  1.00 37.07           N  
ATOM   1483  NH2 ARG   200       2.122  45.793 173.631  1.00 35.20           N  
ATOM   1484  N   LEU   201       5.848  38.501 173.837  1.00 31.75           N  
ATOM   1485  CA  LEU   201       6.921  37.919 174.608  1.00 31.41           C  
ATOM   1486  C   LEU   201       8.335  37.984 174.037  1.00 31.43           C  
ATOM   1487  O   LEU   201       8.513  38.065 172.835  1.00 31.82           O  
ATOM   1488  CB  LEU   201       6.513  36.467 174.892  1.00 29.43           C  
ATOM   1489  CG  LEU   201       5.021  36.302 175.288  1.00 32.44           C  
ATOM   1490  CD1 LEU   201       4.614  34.815 175.271  1.00 26.90           C  
ATOM   1491  CD2 LEU   201       4.773  36.920 176.667  1.00 27.08           C  
ATOM   1492  N   PRO   202       9.352  37.925 174.917  1.00 30.80           N  
ATOM   1493  CA  PRO   202      10.767  37.978 174.532  1.00 30.32           C  
ATOM   1494  C   PRO   202      11.335  36.677 173.954  1.00 30.34           C  
ATOM   1495  O   PRO   202      12.359  36.191 174.416  1.00 30.23           O  
ATOM   1496  CB  PRO   202      11.457  38.373 175.834  1.00 30.91           C  
ATOM   1497  CG  PRO   202      10.656  37.632 176.860  1.00 28.45           C  
ATOM   1498  CD  PRO   202       9.205  37.859 176.387  1.00 30.07           C  
ATOM   1499  N   LEU   203      10.667  36.118 172.952  1.00 30.48           N  
ATOM   1500  CA  LEU   203      11.123  34.883 172.314  1.00 30.84           C  
ATOM   1501  C   LEU   203      11.410  35.167 170.839  1.00 31.51           C  
ATOM   1502  O   LEU   203      10.659  35.887 170.186  1.00 30.41           O  
ATOM   1503  CB  LEU   203      10.053  33.790 172.456  1.00 30.29           C  
ATOM   1504  CG  LEU   203       9.891  33.170 173.843  1.00 32.44           C  
ATOM   1505  CD1 LEU   203       8.508  32.527 173.937  1.00 32.55           C  
ATOM   1506  CD2 LEU   203      11.009  32.152 174.088  1.00 23.45           C  
ATOM   1507  N   GLY   204      12.497  34.596 170.326  1.00 32.37           N  
ATOM   1508  CA  GLY   204      12.882  34.847 168.949  1.00 34.19           C  
ATOM   1509  C   GLY   204      13.081  36.350 168.798  1.00 35.62           C  
ATOM   1510  O   GLY   204      13.706  36.997 169.647  1.00 35.96           O  
ATOM   1511  N   ALA   205      12.557  36.924 167.719  1.00 35.06           N  
ATOM   1512  CA  ALA   205      12.671  38.366 167.495  1.00 35.51           C  
ATOM   1513  C   ALA   205      11.446  39.095 168.071  1.00 35.05           C  
ATOM   1514  O   ALA   205      11.159  40.235 167.697  1.00 34.58           O  
ATOM   1515  CB  ALA   205      12.804  38.661 165.991  1.00 35.87           C  
ATOM   1516  N   GLY   206      10.724  38.440 168.978  1.00 35.87           N  
ATOM   1517  CA  GLY   206       9.545  39.052 169.571  1.00 34.61           C  
ATOM   1518  C   GLY   206       8.283  38.367 169.082  1.00 35.34           C  
ATOM   1519  O   GLY   206       7.853  38.570 167.954  1.00 34.47           O  
ATOM   1520  N   LEU   207       7.677  37.575 169.958  1.00 34.79           N  
ATOM   1521  CA  LEU   207       6.491  36.801 169.637  1.00 31.42           C  
ATOM   1522  C   LEU   207       5.192  37.467 170.024  1.00 30.81           C  
ATOM   1523  O   LEU   207       5.061  37.984 171.123  1.00 31.83           O  
ATOM   1524  CB  LEU   207       6.606  35.445 170.336  1.00 33.46           C  
ATOM   1525  CG  LEU   207       5.572  34.340 170.108  1.00 33.46           C  
ATOM   1526  CD1 LEU   207       5.830  33.688 168.753  1.00 37.83           C  
ATOM   1527  CD2 LEU   207       5.667  33.296 171.214  1.00 30.57           C  
ATOM   1528  N   THR   208       4.228  37.466 169.113  1.00 30.32           N  
ATOM   1529  CA  THR   208       2.928  38.023 169.439  1.00 28.64           C  
ATOM   1530  C   THR   208       1.915  36.888 169.395  1.00 29.95           C  
ATOM   1531  O   THR   208       1.733  36.237 168.356  1.00 29.31           O  
ATOM   1532  CB  THR   208       2.457  39.112 168.449  1.00 30.18           C  
ATOM   1533  OG1 THR   208       3.403  40.185 168.423  1.00 30.22           O  
ATOM   1534  CG2 THR   208       1.104  39.671 168.893  1.00 26.07           C  
ATOM   1535  N   VAL   209       1.290  36.608 170.530  1.00 29.09           N  
ATOM   1536  CA  VAL   209       0.264  35.589 170.541  1.00 29.88           C  
ATOM   1537  C   VAL   209      -1.036  36.292 170.927  1.00 30.32           C  
ATOM   1538  O   VAL   209      -1.116  37.033 171.909  1.00 32.33           O  
ATOM   1539  CB  VAL   209       0.622  34.361 171.478  1.00 29.48           C  
ATOM   1540  CG1 VAL   209       1.798  34.685 172.342  1.00 29.65           C  
ATOM   1541  CG2 VAL   209      -0.590  33.915 172.266  1.00 25.94           C  
ATOM   1542  N   VAL   210      -2.055  36.092 170.111  1.00 30.08           N  
ATOM   1543  CA  VAL   210      -3.324  36.706 170.372  1.00 30.95           C  
ATOM   1544  C   VAL   210      -4.362  35.599 170.439  1.00 31.19           C  
ATOM   1545  O   VAL   210      -4.602  34.856 169.474  1.00 31.19           O  
ATOM   1546  CB  VAL   210      -3.619  37.855 169.309  1.00 32.54           C  
ATOM   1547  CG1 VAL   210      -2.689  37.714 168.126  1.00 29.10           C  
ATOM   1548  CG2 VAL   210      -5.061  37.887 168.913  1.00 30.41           C  
ATOM   1549  N   THR   211      -4.970  35.474 171.610  1.00 31.26           N  
ATOM   1550  CA  THR   211      -5.956  34.445 171.782  1.00 33.16           C  
ATOM   1551  C   THR   211      -7.354  35.046 171.827  1.00 33.51           C  
ATOM   1552  O   THR   211      -7.553  36.165 172.310  1.00 34.80           O  
ATOM   1553  CB  THR   211      -5.607  33.534 173.019  1.00 33.51           C  
ATOM   1554  OG1 THR   211      -6.632  33.598 174.013  1.00 32.53           O  
ATOM   1555  CG2 THR   211      -4.269  33.914 173.600  1.00 26.11           C  
ATOM   1556  N   LYS   212      -8.314  34.304 171.283  1.00 33.14           N  
ATOM   1557  CA  LYS   212      -9.690  34.759 171.217  1.00 32.21           C  
ATOM   1558  C   LYS   212     -10.338  34.586 172.574  1.00 33.16           C  
ATOM   1559  O   LYS   212     -10.486  33.483 173.093  1.00 31.48           O  
ATOM   1560  CB  LYS   212     -10.451  33.983 170.126  1.00 30.67           C  
ATOM   1561  CG  LYS   212     -11.848  34.499 169.856  1.00 31.48           C  
ATOM   1562  CD  LYS   212     -12.519  33.780 168.685  1.00 33.82           C  
ATOM   1563  CE  LYS   212     -11.949  34.223 167.341  1.00 34.01           C  
ATOM   1564  NZ  LYS   212     -12.701  33.627 166.197  1.00 35.69           N  
ATOM   1565  N   ALA   213     -10.723  35.710 173.156  1.00 35.52           N  
ATOM   1566  CA  ALA   213     -11.339  35.718 174.472  1.00 36.71           C  
ATOM   1567  C   ALA   213     -12.641  34.939 174.553  1.00 38.53           C  
ATOM   1568  O   ALA   213     -13.372  34.834 173.570  1.00 39.30           O  
ATOM   1569  CB  ALA   213     -11.569  37.170 174.922  1.00 37.58           C  
END
