
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  214 ( 1670),  selected  214 , name 3bwm_A
# Molecule2: number of CA atoms  211 ( 1569),  selected  211 , name T0509.pdb
# PARAMETERS: 3bwm_A.T0509.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     2_A      N       3           -
LGA    D     3_A      A       4           -
LGA    T     4_A      F       5           -
LGA    K     5_A      E       6           -
LGA    E     6_A      Y       7           -
LGA    Q     7_A      L       8           -
LGA    R     8_A      R       9           -
LGA    I     9_A      T      10           -
LGA    L    10_A      Y      11           -
LGA    N    11_A      V      12           -
LGA    H    12_A      E      13           -
LGA    V    13_A      S      14           -
LGA    L    14_A      T      15           -
LGA    Q    15_A      T      16           -
LGA    H    16_A      E      17           -
LGA    A    17_A      T      18           -
LGA    E    18_A      -       -           -
LGA    P    19_A      -       -           -
LGA    G    20_A      -       -           -
LGA    N    21_A      -       -           -
LGA    A    22_A      -       -           -
LGA    Q    23_A      D      19          2.793
LGA    S    24_A      A      20          1.440
LGA    V    25_A      A      21          1.141
LGA    L    26_A      V      22          0.746
LGA    E    27_A      A      23          2.291
LGA    A    28_A      R      24          3.296
LGA    I    29_A      A      25          3.792
LGA    D    30_A      R      26          3.697
LGA    T    31_A      -       -           -
LGA    Y    32_A      -       -           -
LGA    C    33_A      E      27          4.497
LGA    E    34_A      D      28           -
LGA    Q    35_A      A      29           -
LGA    K    36_A      -       -           -
LGA    E    37_A      -       -           -
LGA    W    38_A      A      30          4.041
LGA    A    39_A      E      31           #
LGA    -       -      F      32           -
LGA    -       -      G      33           -
LGA    -       -      L      34           -
LGA    M    40_A      P      35          1.566
LGA    N    41_A      A      36          1.395
LGA    V    42_A      P      37          1.356
LGA    G    43_A      D      38          2.570
LGA    D    44_A      E      39          0.899
LGA    K    45_A      M      40          2.102
LGA    K    46_A      T      41          1.405
LGA    G    47_A      G      42          1.024
LGA    K    48_A      Q      43          1.618
LGA    I    49_A      L      44          1.851
LGA    V    50_A      L      45          1.570
LGA    D    51_A      T      46          1.826
LGA    A    52_A      T      47          1.985
LGA    V    53_A      L      48          1.870
LGA    I    54_A      A      49          1.830
LGA    Q    55_A      A      50          2.167
LGA    E    56_A      T      51          2.178
LGA    H    57_A      T      52          1.623
LGA    Q    58_A      N      53          4.121
LGA    P    59_A      G      54          4.048
LGA    -       -      N      55           -
LGA    -       -      G      56           -
LGA    S    60_A      S      57          3.986
LGA    V    61_A      T      58          2.924
LGA    -       -      G      59           -
LGA    L    62_A      A      60          0.826
LGA    L    63_A      I      61          1.217
LGA    E    64_A      A      62          1.381
LGA    L    65_A      I      63          1.090
LGA    G    66_A      T      64          1.366
LGA    A    67_A      P      65          4.037
LGA    Y    68_A      A      66          2.293
LGA    C    69_A      A      67          5.390
LGA    G    70_A      G      68          0.937
LGA    Y    71_A      L      69          0.516
LGA    S    72_A      V      70          0.465
LGA    A    73_A      G      71          1.046
LGA    V    74_A      L      72          1.571
LGA    R    75_A      Y      73          1.661
LGA    M    76_A      I      74          0.879
LGA    A    77_A      L      75          1.290
LGA    R    78_A      N      76          2.435
LGA    L    79_A      G      77          1.979
LGA    L    80_A      L      78          1.656
LGA    S    81_A      A      79          1.646
LGA    P    82_A      D      80          1.427
LGA    G    83_A      N      81          1.143
LGA    A    84_A      T      82          1.203
LGA    R    85_A      T      83          0.922
LGA    L    86_A      L      84          0.974
LGA    I    87_A      T      85          0.866
LGA    T    88_A      C      86          1.087
LGA    I    89_A      I      87          0.680
LGA    E    90_A      D      88          0.748
LGA    I    91_A      P      89          1.480
LGA    N    92_A      E      90          1.075
LGA    P    93_A      S      91          1.321
LGA    D    94_A      E      92          1.446
LGA    C    95_A      H      93          1.005
LGA    A    96_A      Q      94          1.240
LGA    A    97_A      R      95          1.392
LGA    I    98_A      Q      96          1.013
LGA    T    99_A      A      97          0.915
LGA    Q   100_A      K      98          1.127
LGA    R   101_A      A      99          0.982
LGA    M   102_A      L     100          1.173
LGA    V   103_A      F     101          1.203
LGA    D   104_A      R     102          1.070
LGA    F   105_A      E     103          1.029
LGA    A   106_A      A     104          1.160
LGA    G   107_A      G     105          1.894
LGA    V   108_A      Y     106          2.159
LGA    K   109_A      S     107          3.590
LGA    D   110_A      P     108          3.639
LGA    -       -      S     109           -
LGA    K   111_A      R     110          1.482
LGA    V   112_A      V     111          0.964
LGA    T   113_A      R     112          0.661
LGA    L   114_A      F     113          0.780
LGA    V   115_A      L     114          0.667
LGA    V   116_A      L     115          0.373
LGA    G   117_A      S     116          0.345
LGA    A   118_A      R     117          0.689
LGA    S   119_A      P     118          0.873
LGA    Q   120_A      L     119          1.091
LGA    D   121_A      D     120          1.064
LGA    I   122_A      V     121          0.568
LGA    I   123_A      M     122          0.586
LGA    P   124_A      S     123          0.867
LGA    Q   125_A      R     124          0.841
LGA    L   126_A      L     125          1.104
LGA    K   127_A      A     126          2.796
LGA    K   128_A      -       -           -
LGA    K   129_A      -       -           -
LGA    Y   130_A      -       -           -
LGA    D   131_A      -       -           -
LGA    V   132_A      N     127          6.281
LGA    D   133_A      D     128          4.983
LGA    T   134_A      S     129          2.156
LGA    L   135_A      Y     130          1.627
LGA    D   136_A      Q     131          1.399
LGA    M   137_A      L     132          1.356
LGA    V   138_A      V     133          0.769
LGA    F   139_A      F     134          0.679
LGA    L   140_A      G     135          0.975
LGA    D   141_A      Q     136          1.209
LGA    H   142_A      V     137          2.653
LGA    W   143_A      S     138          2.763
LGA    K   144_A      P     139          3.010
LGA    D   145_A      M     140          2.002
LGA    R   146_A      D     141          1.707
LGA    Y   147_A      L     142          1.893
LGA    L   148_A      K     143          1.084
LGA    P   149_A      A     144          0.540
LGA    D   150_A      L     145          1.928
LGA    T   151_A      V     146          1.416
LGA    L   152_A      D     147          0.980
LGA    L   153_A      A     148          2.426
LGA    L   154_A      A     149          3.177
LGA    E   155_A      W     150          3.712
LGA    E   156_A      -       -           -
LGA    C   157_A      -       -           -
LGA    G   158_A      P     151          3.619
LGA    L   159_A      L     152          2.100
LGA    L   160_A      L     153          3.129
LGA    R   161_A      R     154          3.510
LGA    K   162_A      R     155          2.572
LGA    G   163_A      G     156          2.257
LGA    T   164_A      G     157          2.198
LGA    V   165_A      A     158          1.008
LGA    L   166_A      L     159          0.723
LGA    L   167_A      V     160          1.009
LGA    A   168_A      L     161          1.081
LGA    D   169_A      A     162          0.969
LGA    N   170_A      D     163          0.812
LGA    V   171_A      A     164          1.775
LGA    I   172_A      L     165          2.600
LGA    C   173_A      L     166          3.123
LGA    P   174_A      -       -           -
LGA    G   175_A      D     167          6.391
LGA    A   176_A      G     168           -
LGA    -       -      T     169           -
LGA    -       -      I     170           -
LGA    -       -      A     171           -
LGA    -       -      D     172           -
LGA    -       -      Q     173           -
LGA    -       -      T     174           -
LGA    -       -      R     175           -
LGA    -       -      K     176           -
LGA    -       -      D     177           -
LGA    -       -      R     178           -
LGA    -       -      D     179           -
LGA    -       -      T     180           -
LGA    -       -      Q     181           -
LGA    -       -      A     182           -
LGA    P   177_A      A     183          2.377
LGA    -       -      R     184           -
LGA    D   178_A      D     185          2.665
LGA    F   179_A      A     186          2.366
LGA    L   180_A      D     187          1.928
LGA    A   181_A      E     188          1.652
LGA    H   182_A      Y     189          1.466
LGA    V   183_A      I     190          1.591
LGA    R   184_A      R     191          1.596
LGA    G   185_A      S     192          2.576
LGA    S   186_A      I     193          2.297
LGA    S   187_A      E     194          2.256
LGA    C   188_A      G     195          3.225
LGA    F   189_A      A     196          1.509
LGA    E   190_A      H     197          0.984
LGA    C   191_A      V     198          0.670
LGA    T   192_A      A     199          1.064
LGA    H   193_A      R     200          1.671
LGA    Y   194_A      L     201          1.832
LGA    Q   195_A      P     202          0.747
LGA    S   196_A      L     203          2.497
LGA    F   197_A      G     204          3.846
LGA    L   198_A      -       -           -
LGA    E   199_A      -       -           -
LGA    Y   200_A      -       -           -
LGA    R   201_A      -       -           -
LGA    E   202_A      -       -           -
LGA    V   203_A      -       -           -
LGA    V   204_A      -       -           -
LGA    D   205_A      A     205          2.119
LGA    G   206_A      G     206          2.306
LGA    L   207_A      L     207          1.373
LGA    E   208_A      T     208          1.377
LGA    K   209_A      V     209          1.440
LGA    A   210_A      V     210          0.407
LGA    I   211_A      T     211          1.153
LGA    Y   212_A      K     212          1.947
LGA    K   213_A      A     213          3.163
LGA    G   214_A      -       -           -
LGA    P   215_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  214  211    5.0    169    2.14    13.61     65.415     7.560

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.220780 * X  +  -0.850659 * Y  +  -0.477112 * Z  +  -6.996419
  Y_new =   0.968316 * X  +  -0.132640 * Y  +  -0.211591 * Z  +  32.576157
  Z_new =   0.116708 * X  +  -0.508710 * Y  +   0.852991 * Z  + 169.507492 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.537757    2.603836  [ DEG:   -30.8112    149.1888 ]
  Theta =  -0.116974   -3.024618  [ DEG:    -6.7021   -173.2979 ]
  Phi   =   1.794968   -1.346625  [ DEG:   102.8441    -77.1559 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3bwm_A                                        
REMARK     2: T0509.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3bwm_A.T0509.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  214  211   5.0  169   2.14   13.61  65.415
REMARK  ---------------------------------------------------------- 
MOLECULE 3bwm_A
HEADER    TRANSFERASE                             09-JAN-08   3BWM              
TITLE     CRYSTAL STRUCTURE OF HUMAN CATECHOL O-METHYLTRANSFERASE               
TITLE    2 WITH BOUND SAM AND DNC                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CATECHOL O-METHYLTRANSFERASE;                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 EC: 2.1.1.6;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: COMT;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)STAR;                             
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET22B(+)                                 
KEYWDS    COMT, ROSSMANN FOLD, SAM, DNC, ALTERNATIVE INITIATION,                
KEYWDS   2 CATECHOLAMINE METABOLISM, CYTOPLASM, MAGNESIUM, MEMBRANE,            
KEYWDS   3 METHYLTRANSFERASE, NEUROTRANSMITTER DEGRADATION,                     
KEYWDS   4 POLYMORPHISM, S-ADENOSYL-L-METHIONINE, TRANSFERASE,                  
KEYWDS   5 TRANSMEMBRANE                                                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.RUTHERFORD,I.LE TRONG,R.E.STENKAMP,W.W.PARSON                       
REVDAT   1   03-JUN-08 3BWM    0                                                
JRNL        AUTH   K.RUTHERFORD,I.LE TRONG,R.E.STENKAMP,W.W.PARSON              
JRNL        TITL   CRYSTAL STRUCTURES OF HUMAN 108V AND 108M CATECHOL           
JRNL        TITL 2 O-METHYLTRANSFERASE.                                         
JRNL        REF    J.MOL.BIOL.                                2008              
JRNL        REFN   ASTM JMOBAK  UK ESSN 1089-8638                               
REMARK   2 RESOLUTION. 1.98 ANGSTROMS.                                          
DBREF  3BWM A    2   215  UNP    P21964   COMT_HUMAN      52    265             
SEQRES   1 A  214  GLY ASP THR LYS GLU GLN ARG ILE LEU ASN HIS VAL LEU          
SEQRES   2 A  214  GLN HIS ALA GLU PRO GLY ASN ALA GLN SER VAL LEU GLU          
SEQRES   3 A  214  ALA ILE ASP THR TYR CYS GLU GLN LYS GLU TRP ALA MET          
SEQRES   4 A  214  ASN VAL GLY ASP LYS LYS GLY LYS ILE VAL ASP ALA VAL          
SEQRES   5 A  214  ILE GLN GLU HIS GLN PRO SER VAL LEU LEU GLU LEU GLY          
SEQRES   6 A  214  ALA TYR CYS GLY TYR SER ALA VAL ARG MET ALA ARG LEU          
SEQRES   7 A  214  LEU SER PRO GLY ALA ARG LEU ILE THR ILE GLU ILE ASN          
SEQRES   8 A  214  PRO ASP CYS ALA ALA ILE THR GLN ARG MET VAL ASP PHE          
SEQRES   9 A  214  ALA GLY VAL LYS ASP LYS VAL THR LEU VAL VAL GLY ALA          
SEQRES  10 A  214  SER GLN ASP ILE ILE PRO GLN LEU LYS LYS LYS TYR ASP          
SEQRES  11 A  214  VAL ASP THR LEU ASP MET VAL PHE LEU ASP HIS TRP LYS          
SEQRES  12 A  214  ASP ARG TYR LEU PRO ASP THR LEU LEU LEU GLU GLU CYS          
SEQRES  13 A  214  GLY LEU LEU ARG LYS GLY THR VAL LEU LEU ALA ASP ASN          
SEQRES  14 A  214  VAL ILE CYS PRO GLY ALA PRO ASP PHE LEU ALA HIS VAL          
SEQRES  15 A  214  ARG GLY SER SER CYS PHE GLU CYS THR HIS TYR GLN SER          
SEQRES  16 A  214  PHE LEU GLU TYR ARG GLU VAL VAL ASP GLY LEU GLU LYS          
SEQRES  17 A  214  ALA ILE TYR LYS GLY PRO                                      
HET     MG  A 300       1                                                       
HET      K  A 303       1                                                       
HET    SAM  A 301      27                                                       
HET    DNC  A 302      14                                                       
HETNAM      MG MAGNESIUM ION                                                    
HETNAM       K POTASSIUM ION                                                    
HETNAM     SAM S-ADENOSYLMETHIONINE                                             
HETNAM     DNC 3,5-DINITROCATECHOL                                              
FORMUL   2   MG    MG 2+                                                        
FORMUL   3    K    K 1+                                                         
FORMUL   4  SAM    C15 H22 N6 O5 S                                              
FORMUL   5  DNC    C6 H4 N2 O6                                                  
FORMUL   6  HOH   *110(H2 O)                                                    
CRYST1   43.284   66.648   68.046  90.00  90.00  90.00 P 21 21 21    4          
ATOM      1  N   GLY A   2      24.026  18.192 143.304  1.00 36.72           N  
ATOM      2  CA  GLY A   2      24.092  19.143 144.458  1.00 36.30           C  
ATOM      3  C   GLY A   2      22.930  18.893 145.395  1.00 36.28           C  
ATOM      4  O   GLY A   2      22.148  17.963 145.188  1.00 36.16           O  
ATOM      5  N   ASP A   3      22.822  19.712 146.437  1.00 36.35           N  
ATOM      6  CA  ASP A   3      21.663  19.660 147.342  1.00 36.19           C  
ATOM      7  C   ASP A   3      21.428  20.978 148.054  1.00 35.50           C  
ATOM      8  O   ASP A   3      22.267  21.873 148.029  1.00 35.38           O  
ATOM      9  CB  ASP A   3      21.787  18.507 148.351  1.00 36.61           C  
ATOM     10  CG  ASP A   3      23.054  18.570 149.175  1.00 37.24           C  
ATOM     11  OD1 ASP A   3      23.634  19.664 149.355  1.00 36.40           O  
ATOM     12  OD2 ASP A   3      23.464  17.497 149.666  1.00 39.41           O  
ATOM     13  N   THR A   4      20.264  21.095 148.675  1.00 35.07           N  
ATOM     14  CA  THR A   4      19.883  22.316 149.357  1.00 34.30           C  
ATOM     15  C   THR A   4      20.088  22.151 150.842  1.00 34.03           C  
ATOM     16  O   THR A   4      20.236  21.033 151.340  1.00 34.45           O  
ATOM     17  CB  THR A   4      18.407  22.626 149.129  1.00 34.26           C  
ATOM     18  OG1 THR A   4      17.624  21.603 149.757  1.00 33.10           O  
ATOM     19  CG2 THR A   4      18.097  22.689 147.637  1.00 33.72           C  
ATOM     20  N   LYS A   5      20.042  23.267 151.556  1.00 33.37           N  
ATOM     21  CA  LYS A   5      20.161  23.245 153.003  1.00 32.99           C  
ATOM     22  C   LYS A   5      19.076  22.416 153.669  1.00 32.55           C  
ATOM     23  O   LYS A   5      19.339  21.751 154.667  1.00 31.77           O  
ATOM     24  CB  LYS A   5      20.124  24.656 153.541  1.00 33.08           C  
ATOM     25  CG  LYS A   5      20.179  24.750 155.051  1.00 33.02           C  
ATOM     26  CD  LYS A   5      20.512  26.156 155.470  1.00 32.80           C  
ATOM     27  CE  LYS A   5      19.363  27.091 155.187  1.00 32.54           C  
ATOM     28  NZ  LYS A   5      19.620  28.475 155.706  1.00 33.04           N  
ATOM     29  N   GLU A   6      17.876  22.455 153.097  1.00 32.26           N  
ATOM     30  CA  GLU A   6      16.720  21.771 153.653  1.00 32.68           C  
ATOM     31  C   GLU A   6      16.842  20.256 153.502  1.00 32.91           C  
ATOM     32  O   GLU A   6      16.484  19.505 154.402  1.00 32.38           O  
ATOM     33  CB  GLU A   6      15.433  22.256 152.980  1.00 32.85           C  
ATOM     34  CG  GLU A   6      15.066  23.691 153.310  1.00 32.87           C  
ATOM     35  CD  GLU A   6      15.921  24.725 152.593  1.00 33.81           C  
ATOM     36  OE1 GLU A   6      16.366  24.450 151.450  1.00 31.71           O  
ATOM     37  OE2 GLU A   6      16.142  25.811 153.183  1.00 32.19           O  
ATOM     38  N   GLN A   7      17.341  19.822 152.347  1.00 33.48           N  
ATOM     39  CA  GLN A   7      17.714  18.425 152.130  1.00 33.60           C  
ATOM     40  C   GLN A   7      18.833  17.998 153.085  1.00 32.66           C  
ATOM     41  O   GLN A   7      18.822  16.886 153.582  1.00 32.48           O  
ATOM     42  CB  GLN A   7      18.138  18.205 150.670  1.00 33.92           C  
ATOM     43  CG  GLN A   7      16.975  18.402 149.698  1.00 36.33           C  
ATOM     44  CD  GLN A   7      17.378  18.407 148.225  1.00 39.60           C  
ATOM     45  OE1 GLN A   7      18.574  18.500 147.870  1.00 39.98           O  
ATOM     46  NE2 GLN A   7      16.363  18.305 147.352  1.00 39.14           N  
ATOM     47  N   ARG A   8      19.784  18.893 153.339  1.00 32.20           N  
ATOM     48  CA  ARG A   8      20.868  18.607 154.265  1.00 31.54           C  
ATOM     49  C   ARG A   8      20.389  18.461 155.714  1.00 30.82           C  
ATOM     50  O   ARG A   8      20.863  17.601 156.430  1.00 30.11           O  
ATOM     51  CB  ARG A   8      21.958  19.658 154.155  1.00 31.87           C  
ATOM     52  CG  ARG A   8      22.718  19.609 152.835  1.00 32.23           C  
ATOM     53  CD  ARG A   8      23.978  20.430 152.905  1.00 33.55           C  
ATOM     54  NE  ARG A   8      23.709  21.860 152.994  1.00 34.47           N  
ATOM     55  CZ  ARG A   8      23.495  22.665 151.948  1.00 36.28           C  
ATOM     56  NH1 ARG A   8      23.519  22.212 150.701  1.00 37.50           N  
ATOM     57  NH2 ARG A   8      23.257  23.950 152.152  1.00 36.47           N  
ATOM     58  N   ILE A   9      19.434  19.286 156.129  1.00 30.31           N  
ATOM     59  CA  ILE A   9      18.780  19.133 157.442  1.00 29.99           C  
ATOM     60  C   ILE A   9      18.030  17.791 157.514  1.00 30.32           C  
ATOM     61  O   ILE A   9      18.182  17.034 158.483  1.00 29.49           O  
ATOM     62  CB  ILE A   9      17.805  20.310 157.713  1.00 30.17           C  
ATOM     63  CG1 ILE A   9      18.582  21.622 157.873  1.00 29.82           C  
ATOM     64  CG2 ILE A   9      16.957  20.035 158.938  1.00 28.97           C  
ATOM     65  CD1 ILE A   9      17.708  22.871 157.849  1.00 30.54           C  
ATOM     66  N   LEU A  10      17.233  17.492 156.480  1.00 30.64           N  
ATOM     67  CA  LEU A  10      16.507  16.221 156.418  1.00 31.09           C  
ATOM     68  C   LEU A  10      17.487  15.028 156.438  1.00 31.24           C  
ATOM     69  O   LEU A  10      17.323  14.104 157.232  1.00 31.47           O  
ATOM     70  CB  LEU A  10      15.591  16.162 155.188  1.00 31.22           C  
ATOM     71  CG  LEU A  10      14.833  14.839 154.971  1.00 31.59           C  
ATOM     72  CD1 LEU A  10      13.740  14.637 156.015  1.00 32.52           C  
ATOM     73  CD2 LEU A  10      14.276  14.750 153.551  1.00 29.67           C  
ATOM     74  N   ASN A  11      18.522  15.071 155.600  1.00 31.42           N  
ATOM     75  CA  ASN A  11      19.558  14.013 155.614  1.00 31.85           C  
ATOM     76  C   ASN A  11      20.131  13.748 157.002  1.00 31.92           C  
ATOM     77  O   ASN A  11      20.230  12.597 157.426  1.00 31.83           O  
ATOM     78  CB  ASN A  11      20.689  14.347 154.627  0.50 31.66           C  
ATOM     80  CG  ASN A  11      20.233  14.314 153.173  0.50 31.91           C  
ATOM     82  OD1 ASN A  11      19.151  13.813 152.859  0.50 30.37           O  
ATOM     84  ND2 ASN A  11      21.058  14.861 152.278  0.50 31.25           N  
ATOM     86  N   HIS A  12      20.523  14.814 157.697  1.00 32.18           N  
ATOM     87  CA  HIS A  12      21.039  14.698 159.065  1.00 32.33           C  
ATOM     88  C   HIS A  12      20.060  13.964 159.995  1.00 31.96           C  
ATOM     89  O   HIS A  12      20.465  13.092 160.766  1.00 30.71           O  
ATOM     90  CB  HIS A  12      21.357  16.082 159.642  1.00 32.24           C  
ATOM     91  CG  HIS A  12      21.933  16.034 161.023  1.00 34.01           C  
ATOM     92  ND1 HIS A  12      23.284  15.882 161.261  1.00 34.54           N  
ATOM     93  CD2 HIS A  12      21.341  16.110 162.240  1.00 35.47           C  
ATOM     94  CE1 HIS A  12      23.496  15.866 162.566  1.00 35.52           C  
ATOM     95  NE2 HIS A  12      22.334  15.997 163.184  1.00 35.43           N  
ATOM     96  N   VAL A  13      18.777  14.322 159.924  1.00 31.96           N  
ATOM     97  CA  VAL A  13      17.769  13.675 160.775  1.00 32.10           C  
ATOM     98  C   VAL A  13      17.643  12.185 160.430  1.00 33.06           C  
ATOM     99  O   VAL A  13      17.658  11.333 161.314  1.00 32.57           O  
ATOM    100  CB  VAL A  13      16.369  14.352 160.674  1.00 31.85           C  
ATOM    101  CG1 VAL A  13      15.284  13.463 161.315  1.00 30.73           C  
ATOM    102  CG2 VAL A  13      16.382  15.739 161.318  1.00 30.99           C  
ATOM    103  N   LEU A  14      17.501  11.888 159.142  1.00 34.64           N  
ATOM    104  CA  LEU A  14      17.307  10.507 158.673  1.00 35.95           C  
ATOM    105  C   LEU A  14      18.470   9.635 159.101  1.00 37.37           C  
ATOM    106  O   LEU A  14      18.281   8.464 159.433  1.00 37.29           O  
ATOM    107  CB  LEU A  14      17.171  10.455 157.152  1.00 35.81           C  
ATOM    108  CG  LEU A  14      15.876  11.043 156.598  1.00 36.37           C  
ATOM    109  CD1 LEU A  14      15.959  11.169 155.062  1.00 36.84           C  
ATOM    110  CD2 LEU A  14      14.642  10.225 157.034  1.00 35.08           C  
ATOM    111  N   GLN A  15      19.657  10.243 159.127  1.00 38.85           N  
ATOM    112  CA  GLN A  15      20.887   9.546 159.456  1.00 40.15           C  
ATOM    113  C   GLN A  15      21.243   9.506 160.945  1.00 40.36           C  
ATOM    114  O   GLN A  15      21.994   8.629 161.351  1.00 41.01           O  
ATOM    115  CB  GLN A  15      22.036  10.149 158.639  1.00 40.81           C  
ATOM    116  CG  GLN A  15      21.849   9.962 157.107  1.00 42.52           C  
ATOM    117  CD  GLN A  15      22.905  10.680 156.280  1.00 45.72           C  
ATOM    118  OE1 GLN A  15      23.796  11.349 156.813  1.00 49.18           O  
ATOM    119  NE2 GLN A  15      22.822  10.525 154.967  1.00 48.17           N  
ATOM    120  N   HIS A  16      20.717  10.424 161.760  1.00 40.35           N  
ATOM    121  CA  HIS A  16      21.114  10.517 163.184  1.00 40.15           C  
ATOM    122  C   HIS A  16      19.994  10.391 164.221  1.00 39.28           C  
ATOM    123  O   HIS A  16      20.260  10.058 165.378  1.00 39.65           O  
ATOM    124  CB  HIS A  16      21.815  11.856 163.441  1.00 40.66           C  
ATOM    125  CG  HIS A  16      23.130  11.988 162.746  1.00 43.69           C  
ATOM    126  ND1 HIS A  16      24.311  12.196 163.428  1.00 46.10           N  
ATOM    127  CD2 HIS A  16      23.458  11.922 161.433  1.00 46.68           C  
ATOM    128  CE1 HIS A  16      25.308  12.258 162.561  1.00 47.71           C  
ATOM    129  NE2 HIS A  16      24.820  12.081 161.346  1.00 47.53           N  
ATOM    130  N   ALA A  17      18.761  10.707 163.846  1.00 37.70           N  
ATOM    131  CA  ALA A  17      17.659  10.658 164.794  1.00 36.81           C  
ATOM    132  C   ALA A  17      17.093   9.240 164.848  1.00 36.27           C  
ATOM    133  O   ALA A  17      17.310   8.443 163.938  1.00 36.28           O  
ATOM    134  CB  ALA A  17      16.575  11.674 164.417  1.00 35.97           C  
ATOM    135  N   GLU A  18      16.387   8.940 165.933  1.00 35.96           N  
ATOM    136  CA  GLU A  18      15.734   7.648 166.137  1.00 35.72           C  
ATOM    137  C   GLU A  18      14.398   7.645 165.391  1.00 35.07           C  
ATOM    138  O   GLU A  18      13.488   8.401 165.748  1.00 34.44           O  
ATOM    139  CB  GLU A  18      15.537   7.407 167.645  1.00 36.11           C  
ATOM    140  CG  GLU A  18      14.584   6.264 168.018  0.50 36.20           C  
ATOM    142  CD  GLU A  18      14.528   6.024 169.523  0.50 37.52           C  
ATOM    144  OE1 GLU A  18      13.405   5.974 170.093  0.50 35.80           O  
ATOM    146  OE2 GLU A  18      15.616   5.895 170.141  0.50 38.77           O  
ATOM    148  N   PRO A  19      14.274   6.801 164.340  1.00 34.56           N  
ATOM    149  CA  PRO A  19      12.986   6.677 163.644  1.00 33.75           C  
ATOM    150  C   PRO A  19      11.815   6.549 164.622  1.00 33.03           C  
ATOM    151  O   PRO A  19      11.921   5.844 165.626  1.00 32.18           O  
ATOM    152  CB  PRO A  19      13.150   5.395 162.829  1.00 33.73           C  
ATOM    153  CG  PRO A  19      14.601   5.279 162.594  1.00 34.51           C  
ATOM    154  CD  PRO A  19      15.284   5.875 163.791  1.00 34.47           C  
ATOM    155  N   GLY A  20      10.728   7.264 164.344  1.00 32.51           N  
ATOM    156  CA  GLY A  20       9.542   7.244 165.196  1.00 32.18           C  
ATOM    157  C   GLY A  20       9.621   8.015 166.507  1.00 31.90           C  
ATOM    158  O   GLY A  20       8.667   8.018 167.266  1.00 31.77           O  
ATOM    159  N   ASN A  21      10.750   8.655 166.791  1.00 31.88           N  
ATOM    160  CA  ASN A  21      10.914   9.410 168.040  1.00 31.92           C  
ATOM    161  C   ASN A  21      10.950  10.901 167.728  1.00 31.73           C  
ATOM    162  O   ASN A  21      11.947  11.406 167.194  1.00 31.82           O  
ATOM    163  CB  ASN A  21      12.195   8.969 168.737  1.00 32.35           C  
ATOM    164  CG  ASN A  21      12.355   9.565 170.105  1.00 33.19           C  
ATOM    165  OD1 ASN A  21      12.052  10.732 170.332  1.00 31.89           O  
ATOM    166  ND2 ASN A  21      12.851   8.762 171.033  1.00 34.16           N  
ATOM    167  N   ALA A  22       9.864  11.594 168.066  1.00 30.90           N  
ATOM    168  CA  ALA A  22       9.684  13.003 167.724  1.00 30.58           C  
ATOM    169  C   ALA A  22      10.707  13.911 168.434  1.00 30.46           C  
ATOM    170  O   ALA A  22      11.299  14.771 167.810  1.00 29.80           O  
ATOM    171  CB  ALA A  22       8.252  13.435 168.044  1.00 30.18           C  
ATOM    172  N   GLN A  23      10.946  13.688 169.722  1.00 30.97           N  
ATOM    173  CA  GLN A  23      11.940  14.473 170.467  1.00 31.82           C  
ATOM    174  C   GLN A  23      13.329  14.333 169.861  1.00 31.23           C  
ATOM    175  O   GLN A  23      14.096  15.291 169.804  1.00 31.17           O  
ATOM    176  CB  GLN A  23      11.971  14.046 171.940  1.00 32.58           C  
ATOM    177  CG  GLN A  23      12.925  14.859 172.825  1.00 36.06           C  
ATOM    178  CD  GLN A  23      12.530  16.312 172.949  1.00 40.50           C  
ATOM    179  OE1 GLN A  23      11.909  16.706 173.928  1.00 45.57           O  
ATOM    180  NE2 GLN A  23      12.878  17.122 171.945  1.00 43.73           N  
ATOM    181  N   SER A  24      13.646  13.119 169.430  1.00 30.55           N  
ATOM    182  CA  SER A  24      14.912  12.810 168.802  1.00 30.29           C  
ATOM    183  C   SER A  24      15.075  13.612 167.504  1.00 30.00           C  
ATOM    184  O   SER A  24      16.136  14.184 167.236  1.00 30.32           O  
ATOM    185  CB  SER A  24      14.962  11.309 168.516  1.00 29.96           C  
ATOM    186  OG  SER A  24      16.192  10.933 167.957  1.00 32.08           O  
ATOM    187  N   VAL A  25      14.010  13.657 166.709  1.00 29.42           N  
ATOM    188  CA  VAL A  25      14.002  14.415 165.459  1.00 28.82           C  
ATOM    189  C   VAL A  25      14.266  15.891 165.725  1.00 28.52           C  
ATOM    190  O   VAL A  25      15.094  16.486 165.063  1.00 27.76           O  
ATOM    191  CB  VAL A  25      12.671  14.239 164.692  1.00 28.80           C  
ATOM    192  CG1 VAL A  25      12.583  15.231 163.494  1.00 28.46           C  
ATOM    193  CG2 VAL A  25      12.534  12.796 164.231  1.00 27.72           C  
ATOM    194  N   LEU A  26      13.585  16.454 166.721  1.00 28.56           N  
ATOM    195  CA  LEU A  26      13.746  17.867 167.072  1.00 29.21           C  
ATOM    196  C   LEU A  26      15.170  18.186 167.523  1.00 29.18           C  
ATOM    197  O   LEU A  26      15.728  19.187 167.125  1.00 29.28           O  
ATOM    198  CB  LEU A  26      12.741  18.294 168.159  1.00 28.96           C  
ATOM    199  CG  LEU A  26      11.264  18.130 167.794  1.00 29.04           C  
ATOM    200  CD1 LEU A  26      10.388  18.381 169.017  1.00 29.72           C  
ATOM    201  CD2 LEU A  26      10.859  19.025 166.615  1.00 30.11           C  
ATOM    202  N   GLU A  27      15.750  17.324 168.346  1.00 30.07           N  
ATOM    203  CA  GLU A  27      17.131  17.503 168.788  1.00 30.50           C  
ATOM    204  C   GLU A  27      18.138  17.379 167.648  1.00 29.88           C  
ATOM    205  O   GLU A  27      19.130  18.115 167.592  1.00 29.50           O  
ATOM    206  CB  GLU A  27      17.472  16.499 169.876  1.00 30.92           C  
ATOM    207  CG  GLU A  27      16.783  16.811 171.167  1.00 34.13           C  
ATOM    208  CD  GLU A  27      17.124  15.842 172.278  1.00 36.62           C  
ATOM    209  OE1 GLU A  27      18.194  15.196 172.242  1.00 38.75           O  
ATOM    210  OE2 GLU A  27      16.298  15.737 173.204  1.00 41.30           O  
ATOM    211  N   ALA A  28      17.889  16.443 166.749  1.00 29.34           N  
ATOM    212  CA  ALA A  28      18.773  16.268 165.607  1.00 29.50           C  
ATOM    213  C   ALA A  28      18.777  17.548 164.752  1.00 29.24           C  
ATOM    214  O   ALA A  28      19.846  18.051 164.404  1.00 29.93           O  
ATOM    215  CB  ALA A  28      18.371  15.033 164.795  1.00 29.35           C  
ATOM    216  N   ILE A  29      17.594  18.104 164.478  1.00 28.89           N  
ATOM    217  CA  ILE A  29      17.469  19.369 163.721  1.00 28.55           C  
ATOM    218  C   ILE A  29      18.149  20.535 164.439  1.00 28.70           C  
ATOM    219  O   ILE A  29      18.950  21.261 163.842  1.00 28.30           O  
ATOM    220  CB  ILE A  29      15.985  19.748 163.440  1.00 28.28           C  
ATOM    221  CG1 ILE A  29      15.280  18.674 162.605  1.00 27.14           C  
ATOM    222  CG2 ILE A  29      15.892  21.122 162.720  1.00 27.20           C  
ATOM    223  CD1 ILE A  29      13.749  18.878 162.446  1.00 26.45           C  
ATOM    224  N   ASP A  30      17.858  20.707 165.727  1.00 28.93           N  
ATOM    225  CA  ASP A  30      18.440  21.815 166.478  1.00 29.22           C  
ATOM    226  C   ASP A  30      19.969  21.735 166.552  1.00 29.95           C  
ATOM    227  O   ASP A  30      20.654  22.752 166.354  1.00 28.83           O  
ATOM    228  CB  ASP A  30      17.823  21.922 167.877  1.00 29.36           C  
ATOM    229  CG  ASP A  30      16.409  22.458 167.849  1.00 29.65           C  
ATOM    230  OD1 ASP A  30      16.090  23.267 166.952  1.00 29.79           O  
ATOM    231  OD2 ASP A  30      15.609  22.077 168.727  1.00 30.38           O  
ATOM    232  N   THR A  31      20.500  20.534 166.797  1.00 30.40           N  
ATOM    233  CA  THR A  31      21.957  20.346 166.871  1.00 31.11           C  
ATOM    234  C   THR A  31      22.642  20.649 165.540  1.00 31.42           C  
ATOM    235  O   THR A  31      23.645  21.361 165.509  1.00 31.25           O  
ATOM    236  CB  THR A  31      22.319  18.931 167.304  1.00 31.39           C  
ATOM    237  OG1 THR A  31      21.805  18.710 168.613  1.00 32.26           O  
ATOM    238  CG2 THR A  31      23.829  18.729 167.315  1.00 30.84           C  
ATOM    239  N   TYR A  32      22.089  20.119 164.451  1.00 31.85           N  
ATOM    240  CA  TYR A  32      22.566  20.447 163.108  1.00 32.05           C  
ATOM    241  C   TYR A  32      22.588  21.955 162.859  1.00 32.64           C  
ATOM    242  O   TYR A  32      23.562  22.498 162.332  1.00 32.58           O  
ATOM    243  CB  TYR A  32      21.694  19.777 162.024  1.00 32.09           C  
ATOM    244  CG  TYR A  32      22.284  19.965 160.635  1.00 32.58           C  
ATOM    245  CD1 TYR A  32      23.325  19.151 160.193  1.00 32.76           C  
ATOM    246  CD2 TYR A  32      21.852  20.991 159.790  1.00 33.31           C  
ATOM    247  CE1 TYR A  32      23.891  19.324 158.954  1.00 32.07           C  
ATOM    248  CE2 TYR A  32      22.431  21.184 158.534  1.00 32.96           C  
ATOM    249  CZ  TYR A  32      23.454  20.338 158.128  1.00 32.98           C  
ATOM    250  OH  TYR A  32      24.044  20.476 156.898  1.00 31.59           O  
ATOM    251  N   CYS A  33      21.508  22.633 163.222  1.00 33.14           N  
ATOM    252  CA  CYS A  33      21.362  24.051 162.893  1.00 33.73           C  
ATOM    253  C   CYS A  33      22.205  24.957 163.769  1.00 34.78           C  
ATOM    254  O   CYS A  33      22.637  26.019 163.325  1.00 34.26           O  
ATOM    255  CB  CYS A  33      19.895  24.457 162.941  1.00 33.52           C  
ATOM    256  SG  CYS A  33      19.025  23.723 161.567  1.00 32.08           S  
ATOM    257  N   GLU A  34      22.421  24.520 165.009  1.00 35.77           N  
ATOM    258  CA  GLU A  34      23.345  25.160 165.924  1.00 37.00           C  
ATOM    259  C   GLU A  34      24.787  25.004 165.461  1.00 37.57           C  
ATOM    260  O   GLU A  34      25.577  25.931 165.592  1.00 37.53           O  
ATOM    261  CB  GLU A  34      23.236  24.549 167.322  1.00 36.90           C  
ATOM    262  CG  GLU A  34      22.134  25.139 168.172  1.00 38.61           C  
ATOM    263  CD  GLU A  34      21.577  24.151 169.196  0.50 38.89           C  
ATOM    264  OE1 GLU A  34      22.348  23.291 169.679  0.50 38.72           O  
ATOM    265  OE2 GLU A  34      20.365  24.236 169.511  0.50 38.80           O  
ATOM    266  N   GLN A  35      25.126  23.831 164.941  1.00 38.11           N  
ATOM    267  CA  GLN A  35      26.517  23.476 164.713  1.00 39.01           C  
ATOM    268  C   GLN A  35      26.987  23.564 163.276  1.00 39.10           C  
ATOM    269  O   GLN A  35      28.170  23.793 163.036  1.00 40.14           O  
ATOM    270  CB  GLN A  35      26.778  22.068 165.231  1.00 39.36           C  
ATOM    271  CG  GLN A  35      26.657  21.984 166.747  1.00 41.73           C  
ATOM    272  CD  GLN A  35      26.862  20.591 167.270  1.00 45.16           C  
ATOM    273  OE1 GLN A  35      27.163  19.665 166.510  1.00 48.79           O  
ATOM    274  NE2 GLN A  35      26.699  20.425 168.580  1.00 46.96           N  
ATOM    275  N   LYS A  36      26.090  23.354 162.322  1.00 38.61           N  
ATOM    276  CA  LYS A  36      26.478  23.265 160.920  1.00 38.31           C  
ATOM    277  C   LYS A  36      25.991  24.472 160.129  1.00 37.14           C  
ATOM    278  O   LYS A  36      26.808  25.203 159.585  1.00 37.28           O  
ATOM    279  CB  LYS A  36      25.966  21.968 160.295  1.00 38.44           C  
ATOM    280  CG  LYS A  36      26.319  20.689 161.086  1.00 41.07           C  
ATOM    281  CD  LYS A  36      27.801  20.325 161.071  1.00 44.16           C  
ATOM    282  CE  LYS A  36      28.331  20.111 159.655  1.00 46.21           C  
ATOM    283  NZ  LYS A  36      28.715  21.418 159.037  1.00 47.43           N  
ATOM    284  N   GLU A  37      24.667  24.658 160.053  1.00 35.64           N  
ATOM    285  CA  GLU A  37      24.059  25.765 159.302  1.00 34.50           C  
ATOM    286  C   GLU A  37      22.765  26.220 159.940  1.00 33.10           C  
ATOM    287  O   GLU A  37      21.866  25.413 160.173  1.00 32.84           O  
ATOM    288  CB  GLU A  37      23.683  25.387 157.858  1.00 34.74           C  
ATOM    289  CG  GLU A  37      24.408  24.238 157.218  1.00 35.42           C  
ATOM    290  CD  GLU A  37      23.771  23.869 155.885  1.00 34.93           C  
ATOM    291  OE1 GLU A  37      23.698  24.749 155.010  1.00 35.73           O  
ATOM    292  OE2 GLU A  37      23.354  22.704 155.720  1.00 32.85           O  
ATOM    293  N   TRP A  38      22.651  27.527 160.144  1.00 31.41           N  
ATOM    294  CA  TRP A  38      21.429  28.142 160.616  1.00 30.54           C  
ATOM    295  C   TRP A  38      20.240  27.884 159.650  1.00 30.32           C  
ATOM    296  O   TRP A  38      20.392  27.870 158.422  1.00 30.03           O  
ATOM    297  CB  TRP A  38      21.666  29.651 160.792  1.00 30.66           C  
ATOM    298  CG  TRP A  38      20.530  30.384 161.438  1.00 28.94           C  
ATOM    299  CD1 TRP A  38      20.395  30.670 162.754  1.00 28.45           C  
ATOM    300  CD2 TRP A  38      19.392  30.952 160.780  1.00 26.49           C  
ATOM    301  NE1 TRP A  38      19.232  31.378 162.970  1.00 27.55           N  
ATOM    302  CE2 TRP A  38      18.592  31.550 161.775  1.00 27.29           C  
ATOM    303  CE3 TRP A  38      18.962  30.995 159.447  1.00 25.85           C  
ATOM    304  CZ2 TRP A  38      17.385  32.195 161.484  1.00 27.63           C  
ATOM    305  CZ3 TRP A  38      17.766  31.636 159.151  1.00 26.36           C  
ATOM    306  CH2 TRP A  38      16.986  32.223 160.168  1.00 26.98           C  
ATOM    307  N   ALA A  39      19.066  27.645 160.223  1.00 29.12           N  
ATOM    308  CA  ALA A  39      17.831  27.581 159.460  1.00 28.58           C  
ATOM    309  C   ALA A  39      16.697  28.167 160.297  1.00 28.17           C  
ATOM    310  O   ALA A  39      16.761  28.213 161.523  1.00 28.11           O  
ATOM    311  CB  ALA A  39      17.512  26.139 159.017  1.00 28.29           C  
ATOM    312  N   MET A  40      15.638  28.580 159.621  1.00 28.34           N  
ATOM    313  CA  MET A  40      14.607  29.397 160.236  1.00 28.36           C  
ATOM    314  C   MET A  40      13.515  28.571 160.930  1.00 28.00           C  
ATOM    315  O   MET A  40      12.336  28.946 160.908  1.00 27.77           O  
ATOM    316  CB  MET A  40      14.011  30.351 159.195  1.00 28.94           C  
ATOM    317  CG  MET A  40      13.390  29.675 157.982  1.00 31.26           C  
ATOM    318  SD  MET A  40      12.859  30.856 156.722  1.00 36.59           S  
ATOM    319  CE  MET A  40      12.328  29.715 155.478  1.00 35.64           C  
ATOM    320  N   ASN A  41      13.913  27.459 161.545  1.00 27.39           N  
ATOM    321  CA  ASN A  41      13.011  26.701 162.425  1.00 27.44           C  
ATOM    322  C   ASN A  41      12.768  27.520 163.680  1.00 27.20           C  
ATOM    323  O   ASN A  41      13.642  28.283 164.099  1.00 27.75           O  
ATOM    324  CB  ASN A  41      13.631  25.382 162.874  1.00 27.32           C  
ATOM    325  CG  ASN A  41      14.286  24.609 161.750  1.00 27.51           C  
ATOM    326  OD1 ASN A  41      15.481  24.311 161.819  1.00 29.70           O  
ATOM    327  ND2 ASN A  41      13.521  24.267 160.730  1.00 25.77           N  
ATOM    328  N   VAL A  42      11.619  27.341 164.315  1.00 27.05           N  
ATOM    329  CA  VAL A  42      11.338  28.089 165.540  1.00 26.90           C  
ATOM    330  C   VAL A  42      12.401  27.763 166.631  1.00 26.97           C  
ATOM    331  O   VAL A  42      12.749  28.614 167.440  1.00 26.85           O  
ATOM    332  CB  VAL A  42       9.862  27.880 166.008  1.00 26.89           C  
ATOM    333  CG1 VAL A  42       9.661  26.516 166.679  1.00 25.91           C  
ATOM    334  CG2 VAL A  42       9.431  28.990 166.920  1.00 28.02           C  
ATOM    335  N   GLY A  43      12.949  26.554 166.614  1.00 27.13           N  
ATOM    336  CA  GLY A  43      14.044  26.189 167.508  1.00 27.74           C  
ATOM    337  C   GLY A  43      13.628  25.857 168.935  1.00 28.58           C  
ATOM    338  O   GLY A  43      12.462  25.972 169.300  1.00 28.04           O  
ATOM    339  N   ASP A  44      14.596  25.450 169.747  1.00 29.74           N  
ATOM    340  CA  ASP A  44      14.296  24.885 171.066  1.00 31.21           C  
ATOM    341  C   ASP A  44      13.828  25.902 172.096  1.00 30.82           C  
ATOM    342  O   ASP A  44      12.925  25.623 172.848  1.00 31.08           O  
ATOM    343  CB  ASP A  44      15.485  24.100 171.644  1.00 32.09           C  
ATOM    344  CG  ASP A  44      15.136  23.435 172.979  1.00 36.66           C  
ATOM    345  OD1 ASP A  44      14.148  22.648 173.016  1.00 42.59           O  
ATOM    346  OD2 ASP A  44      15.819  23.715 174.000  1.00 42.44           O  
ATOM    347  N   LYS A  45      14.425  27.078 172.139  1.00 31.17           N  
ATOM    348  CA  LYS A  45      14.082  28.037 173.192  1.00 31.38           C  
ATOM    349  C   LYS A  45      12.654  28.568 173.018  1.00 30.55           C  
ATOM    350  O   LYS A  45      11.838  28.497 173.945  1.00 30.32           O  
ATOM    351  CB  LYS A  45      15.077  29.192 173.213  1.00 31.75           C  
ATOM    352  CG  LYS A  45      16.452  28.837 173.740  1.00 34.59           C  
ATOM    353  CD  LYS A  45      17.118  30.105 174.297  1.00 37.03           C  
ATOM    354  CE  LYS A  45      18.519  29.827 174.812  1.00 38.59           C  
ATOM    355  NZ  LYS A  45      19.119  31.034 175.479  0.50 38.30           N  
ATOM    356  N   LYS A  46      12.365  29.080 171.825  1.00 29.61           N  
ATOM    357  CA  LYS A  46      11.017  29.513 171.473  1.00 29.24           C  
ATOM    358  C   LYS A  46      10.058  28.331 171.369  1.00 29.60           C  
ATOM    359  O   LYS A  46       8.868  28.482 171.643  1.00 29.45           O  
ATOM    360  CB  LYS A  46      11.025  30.312 170.169  1.00 28.64           C  
ATOM    361  CG  LYS A  46      11.770  31.626 170.279  1.00 27.45           C  
ATOM    362  CD  LYS A  46      11.515  32.552 169.102  1.00 25.74           C  
ATOM    363  CE  LYS A  46      12.319  32.122 167.888  1.00 25.93           C  
ATOM    364  NZ  LYS A  46      11.971  32.905 166.700  1.00 24.91           N  
ATOM    365  N   GLY A  47      10.582  27.174 170.956  1.00 29.82           N  
ATOM    366  CA  GLY A  47       9.805  25.945 170.877  1.00 30.64           C  
ATOM    367  C   GLY A  47       9.191  25.559 172.210  1.00 30.90           C  
ATOM    368  O   GLY A  47       8.100  25.013 172.241  1.00 31.08           O  
ATOM    369  N   LYS A  48       9.899  25.847 173.300  1.00 31.40           N  
ATOM    370  CA  LYS A  48       9.389  25.590 174.657  1.00 32.20           C  
ATOM    371  C   LYS A  48       8.192  26.461 174.984  1.00 31.80           C  
ATOM    372  O   LYS A  48       7.254  26.015 175.642  1.00 31.87           O  
ATOM    373  CB  LYS A  48      10.463  25.837 175.715  1.00 32.63           C  
ATOM    374  CG  LYS A  48      11.492  24.740 175.824  1.00 35.81           C  
ATOM    375  CD  LYS A  48      12.126  24.731 177.214  1.00 40.01           C  
ATOM    376  CE  LYS A  48      11.163  24.137 178.291  1.00 43.05           C  
ATOM    377  NZ  LYS A  48      11.067  22.618 178.310  1.00 43.71           N  
ATOM    378  N   ILE A  49       8.235  27.705 174.525  1.00 31.20           N  
ATOM    379  CA  ILE A  49       7.100  28.602 174.673  1.00 30.88           C  
ATOM    380  C   ILE A  49       5.923  28.083 173.837  1.00 30.71           C  
ATOM    381  O   ILE A  49       4.776  28.075 174.298  1.00 31.35           O  
ATOM    382  CB  ILE A  49       7.474  30.035 174.307  1.00 30.66           C  
ATOM    383  CG1 ILE A  49       8.556  30.555 175.273  1.00 31.25           C  
ATOM    384  CG2 ILE A  49       6.243  30.926 174.337  1.00 30.01           C  
ATOM    385  CD1 ILE A  49       9.229  31.832 174.839  1.00 32.65           C  
ATOM    386  N   VAL A  50       6.206  27.636 172.621  1.00 30.00           N  
ATOM    387  CA  VAL A  50       5.174  27.026 171.779  1.00 29.88           C  
ATOM    388  C   VAL A  50       4.547  25.795 172.450  1.00 29.80           C  
ATOM    389  O   VAL A  50       3.341  25.610 172.367  1.00 29.99           O  
ATOM    390  CB  VAL A  50       5.726  26.634 170.378  1.00 29.97           C  
ATOM    391  CG1 VAL A  50       4.670  25.849 169.589  1.00 29.79           C  
ATOM    392  CG2 VAL A  50       6.198  27.881 169.603  1.00 29.22           C  
ATOM    393  N   ASP A  51       5.370  24.963 173.094  1.00 30.11           N  
ATOM    394  CA  ASP A  51       4.891  23.767 173.820  1.00 30.28           C  
ATOM    395  C   ASP A  51       3.939  24.152 174.937  1.00 30.16           C  
ATOM    396  O   ASP A  51       2.891  23.544 175.073  1.00 29.94           O  
ATOM    397  CB  ASP A  51       6.039  22.972 174.476  1.00 30.68           C  
ATOM    398  CG  ASP A  51       6.998  22.356 173.482  1.00 31.55           C  
ATOM    399  OD1 ASP A  51       6.681  22.239 172.285  1.00 31.95           O  
ATOM    400  OD2 ASP A  51       8.090  21.951 173.936  1.00 35.02           O  
ATOM    401  N   ALA A  52       4.317  25.160 175.732  1.00 30.05           N  
ATOM    402  CA  ALA A  52       3.495  25.622 176.850  1.00 29.94           C  
ATOM    403  C   ALA A  52       2.116  26.112 176.407  1.00 30.04           C  
ATOM    404  O   ALA A  52       1.109  25.808 177.054  1.00 30.49           O  
ATOM    405  CB  ALA A  52       4.221  26.715 177.646  1.00 30.11           C  
ATOM    406  N   VAL A  53       2.060  26.852 175.305  1.00 29.58           N  
ATOM    407  CA  VAL A  53       0.781  27.322 174.775  1.00 29.77           C  
ATOM    408  C   VAL A  53      -0.099  26.139 174.291  1.00 30.38           C  
ATOM    409  O   VAL A  53      -1.308  26.129 174.519  1.00 30.53           O  
ATOM    410  CB  VAL A  53       0.992  28.355 173.645  1.00 29.74           C  
ATOM    411  CG1 VAL A  53      -0.323  28.757 173.030  1.00 29.26           C  
ATOM    412  CG2 VAL A  53       1.784  29.583 174.174  1.00 29.05           C  
ATOM    413  N   ILE A  54       0.495  25.144 173.640  1.00 30.85           N  
ATOM    414  CA  ILE A  54      -0.268  23.960 173.223  1.00 31.37           C  
ATOM    415  C   ILE A  54      -0.794  23.170 174.448  1.00 32.48           C  
ATOM    416  O   ILE A  54      -1.975  22.841 174.520  1.00 31.73           O  
ATOM    417  CB  ILE A  54       0.566  23.026 172.325  1.00 31.48           C  
ATOM    418  CG1 ILE A  54       0.937  23.760 171.024  0.50 31.37           C  
ATOM    420  CG2 ILE A  54      -0.190  21.712 172.057  1.00 30.96           C  
ATOM    421  CD1 ILE A  54       0.760  22.958 169.768  0.50 31.26           C  
ATOM    423  N   GLN A  55       0.082  22.893 175.408  1.00 33.60           N  
ATOM    424  CA  GLN A  55      -0.315  22.224 176.651  1.00 35.37           C  
ATOM    425  C   GLN A  55      -1.360  23.009 177.462  1.00 35.51           C  
ATOM    426  O   GLN A  55      -2.182  22.417 178.153  1.00 35.98           O  
ATOM    427  CB  GLN A  55       0.910  21.949 177.528  1.00 35.98           C  
ATOM    428  CG  GLN A  55       1.872  20.928 176.941  1.00 38.61           C  
ATOM    429  CD  GLN A  55       3.261  20.985 177.556  1.00 42.35           C  
ATOM    430  OE1 GLN A  55       3.632  21.961 178.229  1.00 45.73           O  
ATOM    431  NE2 GLN A  55       4.039  19.935 177.328  1.00 43.76           N  
ATOM    432  N   GLU A  56      -1.325  24.329 177.365  1.00 35.70           N  
ATOM    433  CA  GLU A  56      -2.279  25.178 178.072  1.00 36.44           C  
ATOM    434  C   GLU A  56      -3.652  25.245 177.385  1.00 36.05           C  
ATOM    435  O   GLU A  56      -4.681  25.387 178.053  1.00 36.14           O  
ATOM    436  CB  GLU A  56      -1.709  26.587 178.227  1.00 36.63           C  
ATOM    437  CG  GLU A  56      -2.607  27.543 178.996  1.00 39.76           C  
ATOM    438  CD  GLU A  56      -2.062  28.963 179.063  1.00 42.89           C  
ATOM    439  OE1 GLU A  56      -2.840  29.882 179.420  1.00 45.46           O  
ATOM    440  OE2 GLU A  56      -0.866  29.162 178.763  1.00 45.59           O  
ATOM    441  N   HIS A  57      -3.678  25.162 176.059  1.00 35.36           N  
ATOM    442  CA  HIS A  57      -4.937  25.306 175.343  1.00 34.93           C  
ATOM    443  C   HIS A  57      -5.519  24.025 174.755  1.00 34.74           C  
ATOM    444  O   HIS A  57      -6.711  23.980 174.417  1.00 34.74           O  
ATOM    445  CB  HIS A  57      -4.804  26.402 174.304  1.00 34.94           C  
ATOM    446  CG  HIS A  57      -4.763  27.764 174.910  1.00 34.65           C  
ATOM    447  ND1 HIS A  57      -5.899  28.498 175.166  1.00 35.29           N  
ATOM    448  CD2 HIS A  57      -3.725  28.505 175.364  1.00 34.03           C  
ATOM    449  CE1 HIS A  57      -5.558  29.645 175.728  1.00 34.76           C  
ATOM    450  NE2 HIS A  57      -4.245  29.675 175.856  1.00 33.00           N  
ATOM    451  N   GLN A  58      -4.706  22.980 174.662  1.00 34.59           N  
ATOM    452  CA  GLN A  58      -5.168  21.683 174.193  1.00 34.64           C  
ATOM    453  C   GLN A  58      -6.015  21.812 172.924  1.00 34.05           C  
ATOM    454  O   GLN A  58      -7.141  21.319 172.879  1.00 33.29           O  
ATOM    455  CB  GLN A  58      -5.979  20.987 175.294  1.00 35.37           C  
ATOM    456  CG  GLN A  58      -5.176  20.686 176.560  1.00 37.24           C  
ATOM    457  CD  GLN A  58      -4.158  19.594 176.341  1.00 39.39           C  
ATOM    458  OE1 GLN A  58      -4.503  18.505 175.890  1.00 42.97           O  
ATOM    459  NE2 GLN A  58      -2.900  19.877 176.644  1.00 39.59           N  
ATOM    460  N   PRO A  59      -5.473  22.461 171.879  1.00 33.53           N  
ATOM    461  CA  PRO A  59      -6.260  22.592 170.653  1.00 33.63           C  
ATOM    462  C   PRO A  59      -6.527  21.251 169.975  1.00 33.46           C  
ATOM    463  O   PRO A  59      -5.655  20.387 169.939  1.00 33.04           O  
ATOM    464  CB  PRO A  59      -5.378  23.475 169.756  1.00 33.57           C  
ATOM    465  CG  PRO A  59      -3.984  23.235 170.260  1.00 33.18           C  
ATOM    466  CD  PRO A  59      -4.141  23.075 171.743  1.00 33.38           C  
ATOM    467  N   SER A  60      -7.729  21.105 169.428  1.00 33.61           N  
ATOM    468  CA  SER A  60      -8.091  19.914 168.662  1.00 33.82           C  
ATOM    469  C   SER A  60      -8.038  20.168 167.155  1.00 33.17           C  
ATOM    470  O   SER A  60      -7.924  19.227 166.381  1.00 33.19           O  
ATOM    471  CB  SER A  60      -9.473  19.406 169.088  1.00 34.12           C  
ATOM    472  OG  SER A  60      -9.340  18.622 170.261  1.00 35.99           O  
ATOM    473  N   VAL A  61      -8.110  21.436 166.749  1.00 32.54           N  
ATOM    474  CA  VAL A  61      -7.921  21.817 165.354  1.00 31.61           C  
ATOM    475  C   VAL A  61      -6.896  22.950 165.304  1.00 31.04           C  
ATOM    476  O   VAL A  61      -7.200  24.091 165.650  1.00 30.65           O  
ATOM    477  CB  VAL A  61      -9.272  22.225 164.701  1.00 31.93           C  
ATOM    478  CG1 VAL A  61      -9.087  22.593 163.220  1.00 31.29           C  
ATOM    479  CG2 VAL A  61     -10.292  21.078 164.839  1.00 31.83           C  
ATOM    480  N   LEU A  62      -5.673  22.616 164.900  1.00 30.31           N  
ATOM    481  CA  LEU A  62      -4.558  23.569 164.877  1.00 30.39           C  
ATOM    482  C   LEU A  62      -4.134  23.870 163.434  1.00 29.92           C  
ATOM    483  O   LEU A  62      -3.978  22.951 162.627  1.00 29.81           O  
ATOM    484  CB  LEU A  62      -3.385  23.012 165.695  1.00 30.65           C  
ATOM    485  CG  LEU A  62      -2.037  23.741 165.759  1.00 31.28           C  
ATOM    486  CD1 LEU A  62      -2.140  25.175 166.211  1.00 30.77           C  
ATOM    487  CD2 LEU A  62      -1.092  22.975 166.675  1.00 32.20           C  
ATOM    488  N   LEU A  63      -3.992  25.158 163.105  1.00 28.84           N  
ATOM    489  CA  LEU A  63      -3.546  25.577 161.791  1.00 28.04           C  
ATOM    490  C   LEU A  63      -2.143  26.161 161.877  1.00 28.48           C  
ATOM    491  O   LEU A  63      -1.863  27.013 162.718  1.00 28.40           O  
ATOM    492  CB  LEU A  63      -4.493  26.628 161.203  1.00 28.24           C  
ATOM    493  CG  LEU A  63      -4.178  27.140 159.788  1.00 26.20           C  
ATOM    494  CD1 LEU A  63      -4.247  26.044 158.754  1.00 27.55           C  
ATOM    495  CD2 LEU A  63      -5.121  28.278 159.391  1.00 25.68           C  
ATOM    496  N   GLU A  64      -1.262  25.716 160.994  1.00 28.11           N  
ATOM    497  CA  GLU A  64       0.064  26.294 160.905  1.00 28.31           C  
ATOM    498  C   GLU A  64       0.248  26.953 159.565  1.00 27.74           C  
ATOM    499  O   GLU A  64      -0.099  26.394 158.530  1.00 27.67           O  
ATOM    500  CB  GLU A  64       1.129  25.240 161.131  1.00 28.45           C  
ATOM    501  CG  GLU A  64       2.556  25.677 160.732  1.00 30.84           C  
ATOM    502  CD  GLU A  64       3.607  24.686 161.207  1.00 32.54           C  
ATOM    503  OE1 GLU A  64       4.026  23.806 160.413  1.00 33.53           O  
ATOM    504  OE2 GLU A  64       3.985  24.767 162.397  1.00 33.87           O  
ATOM    505  N   LEU A  65       0.789  28.164 159.599  1.00 27.65           N  
ATOM    506  CA  LEU A  65       1.092  28.910 158.396  1.00 27.42           C  
ATOM    507  C   LEU A  65       2.604  28.973 158.290  1.00 27.28           C  
ATOM    508  O   LEU A  65       3.257  29.699 159.051  1.00 27.08           O  
ATOM    509  CB  LEU A  65       0.511  30.323 158.482  1.00 27.26           C  
ATOM    510  CG  LEU A  65      -0.995  30.464 158.666  1.00 27.45           C  
ATOM    511  CD1 LEU A  65      -1.409  31.937 158.495  1.00 26.81           C  
ATOM    512  CD2 LEU A  65      -1.761  29.576 157.687  1.00 25.78           C  
ATOM    513  N   GLY A  66       3.142  28.235 157.327  1.00 27.69           N  
ATOM    514  CA  GLY A  66       4.580  28.161 157.091  1.00 28.10           C  
ATOM    515  C   GLY A  66       5.174  26.934 157.746  1.00 28.90           C  
ATOM    516  O   GLY A  66       5.411  26.933 158.954  1.00 28.70           O  
ATOM    517  N   ALA A  67       5.428  25.891 156.953  1.00 29.51           N  
ATOM    518  CA  ALA A  67       5.898  24.592 157.497  1.00 29.89           C  
ATOM    519  C   ALA A  67       7.406  24.383 157.415  1.00 29.93           C  
ATOM    520  O   ALA A  67       7.997  23.719 158.274  1.00 30.10           O  
ATOM    521  CB  ALA A  67       5.202  23.449 156.789  1.00 30.22           C  
ATOM    522  N   TYR A  68       8.003  24.914 156.352  1.00 30.06           N  
ATOM    523  CA  TYR A  68       9.432  24.780 156.066  1.00 29.46           C  
ATOM    524  C   TYR A  68       9.914  23.307 156.059  1.00 29.61           C  
ATOM    525  O   TYR A  68       9.593  22.566 155.131  1.00 29.25           O  
ATOM    526  CB  TYR A  68      10.224  25.702 157.000  1.00 29.16           C  
ATOM    527  CG  TYR A  68      11.676  25.887 156.629  1.00 28.83           C  
ATOM    528  CD1 TYR A  68      12.052  26.204 155.327  1.00 29.67           C  
ATOM    529  CD2 TYR A  68      12.670  25.751 157.577  1.00 28.38           C  
ATOM    530  CE1 TYR A  68      13.381  26.355 154.980  1.00 28.76           C  
ATOM    531  CE2 TYR A  68      13.990  25.901 157.243  1.00 29.16           C  
ATOM    532  CZ  TYR A  68      14.347  26.205 155.941  1.00 29.78           C  
ATOM    533  OH  TYR A  68      15.680  26.384 155.622  1.00 31.24           O  
ATOM    534  N   CYS A  69      10.680  22.887 157.066  1.00 29.76           N  
ATOM    535  CA  CYS A  69      11.185  21.507 157.135  1.00 30.05           C  
ATOM    536  C   CYS A  69      10.376  20.616 158.078  1.00 29.83           C  
ATOM    537  O   CYS A  69      10.665  19.429 158.208  1.00 29.83           O  
ATOM    538  CB  CYS A  69      12.671  21.495 157.515  1.00 30.21           C  
ATOM    539  SG  CYS A  69      13.750  22.182 156.213  1.00 32.76           S  
ATOM    540  N   GLY A  70       9.359  21.180 158.730  1.00 29.64           N  
ATOM    541  CA  GLY A  70       8.439  20.383 159.558  1.00 29.57           C  
ATOM    542  C   GLY A  70       8.794  20.364 161.035  1.00 29.33           C  
ATOM    543  O   GLY A  70       8.200  19.605 161.806  1.00 29.63           O  
ATOM    544  N   TYR A  71       9.746  21.208 161.438  1.00 28.70           N  
ATOM    545  CA  TYR A  71      10.234  21.204 162.818  1.00 28.25           C  
ATOM    546  C   TYR A  71       9.091  21.519 163.773  1.00 27.93           C  
ATOM    547  O   TYR A  71       8.811  20.747 164.712  1.00 27.52           O  
ATOM    548  CB  TYR A  71      11.404  22.192 162.990  1.00 28.13           C  
ATOM    549  CG  TYR A  71      11.888  22.361 164.407  1.00 27.43           C  
ATOM    550  CD1 TYR A  71      12.957  21.613 164.899  1.00 28.25           C  
ATOM    551  CD2 TYR A  71      11.289  23.287 165.254  1.00 27.13           C  
ATOM    552  CE1 TYR A  71      13.409  21.777 166.208  1.00 28.08           C  
ATOM    553  CE2 TYR A  71      11.723  23.457 166.551  1.00 28.72           C  
ATOM    554  CZ  TYR A  71      12.788  22.705 167.029  1.00 28.59           C  
ATOM    555  OH  TYR A  71      13.199  22.882 168.331  1.00 27.80           O  
ATOM    556  N   SER A  72       8.424  22.642 163.517  1.00 27.91           N  
ATOM    557  CA  SER A  72       7.340  23.100 164.373  1.00 28.03           C  
ATOM    558  C   SER A  72       6.101  22.208 164.230  1.00 27.66           C  
ATOM    559  O   SER A  72       5.356  22.008 165.203  1.00 27.80           O  
ATOM    560  CB  SER A  72       6.992  24.570 164.101  1.00 28.25           C  
ATOM    561  OG  SER A  72       6.378  24.739 162.834  1.00 28.18           O  
ATOM    562  N   ALA A  73       5.877  21.668 163.037  1.00 27.61           N  
ATOM    563  CA  ALA A  73       4.799  20.679 162.841  1.00 27.86           C  
ATOM    564  C   ALA A  73       4.991  19.506 163.808  1.00 28.10           C  
ATOM    565  O   ALA A  73       4.120  19.191 164.627  1.00 28.48           O  
ATOM    566  CB  ALA A  73       4.770  20.176 161.382  1.00 27.63           C  
ATOM    567  N   VAL A  74       6.171  18.906 163.737  1.00 28.39           N  
ATOM    568  CA  VAL A  74       6.538  17.806 164.603  1.00 28.66           C  
ATOM    569  C   VAL A  74       6.461  18.254 166.054  1.00 29.33           C  
ATOM    570  O   VAL A  74       5.875  17.567 166.886  1.00 29.60           O  
ATOM    571  CB  VAL A  74       7.959  17.302 164.281  1.00 28.71           C  
ATOM    572  CG1 VAL A  74       8.420  16.278 165.294  1.00 27.77           C  
ATOM    573  CG2 VAL A  74       8.006  16.729 162.877  1.00 29.54           C  
ATOM    574  N   ARG A  75       7.041  19.418 166.346  1.00 29.84           N  
ATOM    575  CA  ARG A  75       7.076  19.937 167.703  1.00 30.17           C  
ATOM    576  C   ARG A  75       5.674  20.034 168.303  1.00 30.42           C  
ATOM    577  O   ARG A  75       5.453  19.642 169.439  1.00 30.07           O  
ATOM    578  CB  ARG A  75       7.773  21.296 167.725  1.00 30.62           C  
ATOM    579  CG  ARG A  75       7.860  21.904 169.110  1.00 32.51           C  
ATOM    580  CD  ARG A  75       9.233  22.469 169.432  1.00 33.37           C  
ATOM    581  NE  ARG A  75       9.475  22.374 170.871  1.00 33.19           N  
ATOM    582  CZ  ARG A  75      10.665  22.209 171.427  1.00 35.40           C  
ATOM    583  NH1 ARG A  75      11.760  22.120 170.676  1.00 35.70           N  
ATOM    584  NH2 ARG A  75      10.765  22.140 172.753  1.00 37.24           N  
ATOM    585  N   MET A  76       4.721  20.523 167.521  1.00 31.21           N  
ATOM    586  CA  MET A  76       3.352  20.684 168.003  1.00 31.56           C  
ATOM    587  C   MET A  76       2.542  19.376 167.933  1.00 31.72           C  
ATOM    588  O   MET A  76       1.832  19.035 168.875  1.00 32.08           O  
ATOM    589  CB  MET A  76       2.670  21.799 167.221  1.00 31.44           C  
ATOM    590  CG  MET A  76       3.325  23.176 167.454  1.00 32.38           C  
ATOM    591  SD  MET A  76       2.420  24.539 166.689  1.00 33.39           S  
ATOM    592  CE  MET A  76       2.647  24.146 164.954  1.00 30.78           C  
ATOM    593  N   ALA A  77       2.648  18.641 166.835  1.00 32.00           N  
ATOM    594  CA  ALA A  77       1.834  17.418 166.675  1.00 32.74           C  
ATOM    595  C   ALA A  77       2.121  16.400 167.782  1.00 33.57           C  
ATOM    596  O   ALA A  77       1.222  15.685 168.219  1.00 33.45           O  
ATOM    597  CB  ALA A  77       2.050  16.790 165.317  1.00 32.13           C  
ATOM    598  N   ARG A  78       3.365  16.373 168.259  1.00 34.28           N  
ATOM    599  CA  ARG A  78       3.770  15.408 169.272  1.00 35.15           C  
ATOM    600  C   ARG A  78       3.045  15.628 170.597  1.00 35.71           C  
ATOM    601  O   ARG A  78       2.969  14.714 171.407  1.00 35.86           O  
ATOM    602  CB  ARG A  78       5.294  15.425 169.483  1.00 35.25           C  
ATOM    603  CG  ARG A  78       5.789  16.334 170.598  1.00 36.31           C  
ATOM    604  CD  ARG A  78       7.296  16.472 170.575  1.00 38.33           C  
ATOM    605  NE  ARG A  78       7.824  17.052 171.821  1.00 40.93           N  
ATOM    606  CZ  ARG A  78       7.717  18.336 172.164  1.00 41.72           C  
ATOM    607  NH1 ARG A  78       7.094  19.195 171.374  1.00 41.25           N  
ATOM    608  NH2 ARG A  78       8.226  18.763 173.314  1.00 42.83           N  
ATOM    609  N   LEU A  79       2.536  16.840 170.815  1.00 36.43           N  
ATOM    610  CA  LEU A  79       1.843  17.190 172.048  1.00 37.22           C  
ATOM    611  C   LEU A  79       0.324  17.070 171.968  1.00 38.16           C  
ATOM    612  O   LEU A  79      -0.352  17.305 172.972  1.00 38.88           O  
ATOM    613  CB  LEU A  79       2.193  18.628 172.448  1.00 37.10           C  
ATOM    614  CG  LEU A  79       3.647  18.923 172.823  1.00 37.64           C  
ATOM    615  CD1 LEU A  79       3.877  20.424 172.830  1.00 36.64           C  
ATOM    616  CD2 LEU A  79       4.016  18.305 174.157  1.00 37.07           C  
ATOM    617  N   LEU A  80      -0.218  16.714 170.802  1.00 39.20           N  
ATOM    618  CA  LEU A  80      -1.678  16.716 170.589  1.00 40.15           C  
ATOM    619  C   LEU A  80      -2.345  15.398 171.002  1.00 41.21           C  
ATOM    620  O   LEU A  80      -1.796  14.321 170.776  1.00 41.41           O  
ATOM    621  CB  LEU A  80      -2.007  16.985 169.115  1.00 39.55           C  
ATOM    622  CG  LEU A  80      -1.562  18.300 168.481  1.00 38.74           C  
ATOM    623  CD1 LEU A  80      -2.039  18.342 167.040  1.00 38.87           C  
ATOM    624  CD2 LEU A  80      -2.060  19.520 169.254  1.00 38.11           C  
ATOM    625  N   SER A  81      -3.553  15.489 171.563  1.00 42.57           N  
ATOM    626  CA  SER A  81      -4.326  14.294 171.929  1.00 43.49           C  
ATOM    627  C   SER A  81      -4.779  13.538 170.684  1.00 43.94           C  
ATOM    628  O   SER A  81      -4.829  14.122 169.600  1.00 44.23           O  
ATOM    629  CB  SER A  81      -5.549  14.676 172.762  1.00 43.92           C  
ATOM    630  OG  SER A  81      -5.186  15.550 173.822  1.00 45.28           O  
ATOM    631  N   PRO A  82      -5.112  12.238 170.828  1.00 44.37           N  
ATOM    632  CA  PRO A  82      -5.590  11.465 169.673  1.00 44.49           C  
ATOM    633  C   PRO A  82      -6.875  12.057 169.093  1.00 44.22           C  
ATOM    634  O   PRO A  82      -7.731  12.538 169.843  1.00 44.08           O  
ATOM    635  CB  PRO A  82      -5.852  10.061 170.254  1.00 44.65           C  
ATOM    636  CG  PRO A  82      -5.020  10.002 171.507  1.00 44.87           C  
ATOM    637  CD  PRO A  82      -5.064  11.410 172.050  1.00 44.81           C  
ATOM    638  N   GLY A  83      -6.987  12.029 167.768  1.00 43.74           N  
ATOM    639  CA  GLY A  83      -8.079  12.698 167.071  1.00 43.52           C  
ATOM    640  C   GLY A  83      -7.868  14.193 166.837  1.00 43.15           C  
ATOM    641  O   GLY A  83      -8.582  14.800 166.028  1.00 43.27           O  
ATOM    642  N   ALA A  84      -6.913  14.798 167.546  1.00 42.48           N  
ATOM    643  CA  ALA A  84      -6.517  16.176 167.261  1.00 42.00           C  
ATOM    644  C   ALA A  84      -5.829  16.200 165.906  1.00 41.65           C  
ATOM    645  O   ALA A  84      -5.228  15.205 165.483  1.00 41.77           O  
ATOM    646  CB  ALA A  84      -5.609  16.715 168.331  1.00 41.93           C  
ATOM    647  N   ARG A  85      -5.950  17.316 165.196  1.00 41.02           N  
ATOM    648  CA  ARG A  85      -5.275  17.429 163.922  1.00 40.64           C  
ATOM    649  C   ARG A  85      -4.604  18.787 163.691  1.00 39.30           C  
ATOM    650  O   ARG A  85      -5.123  19.846 164.055  1.00 39.17           O  
ATOM    651  CB  ARG A  85      -6.207  17.066 162.771  1.00 41.21           C  
ATOM    652  CG  ARG A  85      -7.466  17.873 162.695  1.00 43.28           C  
ATOM    653  CD  ARG A  85      -8.053  17.769 161.295  1.00 46.71           C  
ATOM    654  NE  ARG A  85      -9.396  18.350 161.212  1.00 49.17           N  
ATOM    655  CZ  ARG A  85      -9.999  18.698 160.078  1.00 50.62           C  
ATOM    656  NH1 ARG A  85     -11.221  19.221 160.120  1.00 50.96           N  
ATOM    657  NH2 ARG A  85      -9.382  18.530 158.907  1.00 51.00           N  
ATOM    658  N   LEU A  86      -3.425  18.720 163.090  1.00 37.61           N  
ATOM    659  CA  LEU A  86      -2.695  19.897 162.704  1.00 36.34           C  
ATOM    660  C   LEU A  86      -2.838  20.009 161.204  1.00 34.83           C  
ATOM    661  O   LEU A  86      -2.532  19.069 160.486  1.00 34.52           O  
ATOM    662  CB  LEU A  86      -1.217  19.781 163.104  1.00 36.32           C  
ATOM    663  CG  LEU A  86      -0.274  20.804 162.469  1.00 37.12           C  
ATOM    664  CD1 LEU A  86      -0.825  22.201 162.647  1.00 37.20           C  
ATOM    665  CD2 LEU A  86       1.120  20.687 163.061  1.00 38.71           C  
ATOM    666  N   ILE A  87      -3.332  21.156 160.745  1.00 33.24           N  
ATOM    667  CA  ILE A  87      -3.309  21.491 159.346  1.00 31.95           C  
ATOM    668  C   ILE A  87      -2.193  22.496 159.145  1.00 30.93           C  
ATOM    669  O   ILE A  87      -2.191  23.543 159.773  1.00 30.27           O  
ATOM    670  CB  ILE A  87      -4.656  22.067 158.885  1.00 32.36           C  
ATOM    671  CG1 ILE A  87      -5.778  21.026 159.083  1.00 32.34           C  
ATOM    672  CG2 ILE A  87      -4.555  22.526 157.425  1.00 31.21           C  
ATOM    673  CD1 ILE A  87      -7.180  21.579 158.868  1.00 32.79           C  
ATOM    674  N   THR A  88      -1.222  22.155 158.300  1.00 29.75           N  
ATOM    675  CA  THR A  88      -0.103  23.045 158.022  1.00 29.17           C  
ATOM    676  C   THR A  88      -0.088  23.387 156.546  1.00 28.29           C  
ATOM    677  O   THR A  88      -0.202  22.504 155.694  1.00 28.51           O  
ATOM    678  CB  THR A  88       1.267  22.395 158.411  0.50 29.24           C  
ATOM    680  OG1 THR A  88       1.334  21.054 157.918  0.50 30.38           O  
ATOM    682  CG2 THR A  88       1.436  22.329 159.903  0.50 29.58           C  
ATOM    684  N   ILE A  89       0.016  24.687 156.264  1.00 27.97           N  
ATOM    685  CA  ILE A  89       0.007  25.211 154.908  1.00 27.32           C  
ATOM    686  C   ILE A  89       1.402  25.696 154.571  1.00 27.41           C  
ATOM    687  O   ILE A  89       2.014  26.406 155.366  1.00 27.23           O  
ATOM    688  CB  ILE A  89      -0.978  26.400 154.739  1.00 26.84           C  
ATOM    689  CG1 ILE A  89      -2.363  26.041 155.292  1.00 25.74           C  
ATOM    690  CG2 ILE A  89      -1.013  26.828 153.283  1.00 25.56           C  
ATOM    691  CD1 ILE A  89      -3.397  27.162 155.202  1.00 25.66           C  
ATOM    692  N   GLU A  90       1.878  25.313 153.383  1.00 27.80           N  
ATOM    693  CA  GLU A  90       3.207  25.646 152.901  1.00 28.28           C  
ATOM    694  C   GLU A  90       3.160  25.921 151.404  1.00 29.26           C  
ATOM    695  O   GLU A  90       2.660  25.106 150.624  1.00 29.40           O  
ATOM    696  CB  GLU A  90       4.170  24.495 153.192  1.00 28.14           C  
ATOM    697  CG  GLU A  90       5.526  24.625 152.533  1.00 28.03           C  
ATOM    698  CD  GLU A  90       6.262  25.894 152.942  1.00 27.02           C  
ATOM    699  OE1 GLU A  90       6.417  26.124 154.166  1.00 24.80           O  
ATOM    700  OE2 GLU A  90       6.687  26.654 152.031  1.00 22.73           O  
ATOM    701  N   ILE A  91       3.707  27.063 151.009  1.00 30.91           N  
ATOM    702  CA  ILE A  91       3.598  27.549 149.641  1.00 32.24           C  
ATOM    703  C   ILE A  91       4.631  26.876 148.733  1.00 33.65           C  
ATOM    704  O   ILE A  91       4.416  26.746 147.525  1.00 34.08           O  
ATOM    705  CB  ILE A  91       3.727  29.094 149.597  1.00 32.07           C  
ATOM    706  CG1 ILE A  91       3.231  29.655 148.256  1.00 31.61           C  
ATOM    707  CG2 ILE A  91       5.164  29.556 149.920  1.00 31.79           C  
ATOM    708  CD1 ILE A  91       3.320  31.178 148.187  1.00 27.59           C  
ATOM    709  N   ASN A  92       5.741  26.443 149.334  1.00 34.76           N  
ATOM    710  CA  ASN A  92       6.843  25.820 148.613  1.00 35.39           C  
ATOM    711  C   ASN A  92       6.723  24.291 148.603  1.00 35.30           C  
ATOM    712  O   ASN A  92       6.841  23.645 149.657  1.00 35.07           O  
ATOM    713  CB  ASN A  92       8.178  26.249 149.224  1.00 35.70           C  
ATOM    714  CG  ASN A  92       9.351  25.941 148.311  1.00 37.40           C  
ATOM    715  OD1 ASN A  92       9.765  24.797 148.172  1.00 36.35           O  
ATOM    716  ND2 ASN A  92       9.883  26.975 147.676  1.00 40.49           N  
ATOM    717  N   PRO A  93       6.466  23.705 147.417  1.00 35.29           N  
ATOM    718  CA  PRO A  93       6.254  22.263 147.261  1.00 35.02           C  
ATOM    719  C   PRO A  93       7.431  21.414 147.712  1.00 35.05           C  
ATOM    720  O   PRO A  93       7.245  20.306 148.218  1.00 34.70           O  
ATOM    721  CB  PRO A  93       6.076  22.099 145.744  1.00 35.23           C  
ATOM    722  CG  PRO A  93       5.805  23.415 145.221  1.00 35.13           C  
ATOM    723  CD  PRO A  93       6.453  24.390 146.114  1.00 35.49           C  
ATOM    724  N   ASP A  94       8.637  21.927 147.503  1.00 35.32           N  
ATOM    725  CA  ASP A  94       9.840  21.215 147.892  1.00 35.82           C  
ATOM    726  C   ASP A  94       9.997  21.163 149.416  1.00 35.77           C  
ATOM    727  O   ASP A  94      10.308  20.107 149.975  1.00 35.72           O  
ATOM    728  CB  ASP A  94      11.056  21.837 147.203  1.00 36.10           C  
ATOM    729  CG  ASP A  94      11.073  21.545 145.704  1.00 36.71           C  
ATOM    730  OD1 ASP A  94      10.785  20.400 145.301  1.00 38.97           O  
ATOM    731  OD2 ASP A  94      11.362  22.458 144.923  1.00 38.71           O  
ATOM    732  N   CYS A  95       9.732  22.284 150.086  1.00 35.47           N  
ATOM    733  CA  CYS A  95       9.705  22.305 151.560  1.00 35.27           C  
ATOM    734  C   CYS A  95       8.609  21.392 152.095  1.00 34.50           C  
ATOM    735  O   CYS A  95       8.805  20.672 153.080  1.00 33.83           O  
ATOM    736  CB  CYS A  95       9.478  23.725 152.064  1.00 35.09           C  
ATOM    737  SG  CYS A  95      10.892  24.786 151.838  1.00 37.71           S  
ATOM    738  N   ALA A  96       7.461  21.428 151.424  1.00 33.69           N  
ATOM    739  CA  ALA A  96       6.333  20.575 151.754  1.00 33.48           C  
ATOM    740  C   ALA A  96       6.689  19.091 151.625  1.00 33.77           C  
ATOM    741  O   ALA A  96       6.233  18.270 152.435  1.00 33.59           O  
ATOM    742  CB  ALA A  96       5.129  20.916 150.866  1.00 33.65           C  
ATOM    743  N   ALA A  97       7.484  18.748 150.609  1.00 33.14           N  
ATOM    744  CA  ALA A  97       7.948  17.374 150.454  1.00 33.04           C  
ATOM    745  C   ALA A  97       8.816  16.986 151.649  1.00 32.61           C  
ATOM    746  O   ALA A  97       8.645  15.913 152.216  1.00 33.30           O  
ATOM    747  CB  ALA A  97       8.703  17.195 149.145  1.00 32.65           C  
ATOM    748  N   ILE A  98       9.710  17.886 152.058  1.00 32.64           N  
ATOM    749  CA  ILE A  98      10.603  17.638 153.197  1.00 31.77           C  
ATOM    750  C   ILE A  98       9.817  17.569 154.496  1.00 31.56           C  
ATOM    751  O   ILE A  98      10.013  16.647 155.284  1.00 31.72           O  
ATOM    752  CB  ILE A  98      11.747  18.685 153.266  1.00 31.96           C  
ATOM    753  CG1 ILE A  98      12.823  18.335 152.229  1.00 32.34           C  
ATOM    754  CG2 ILE A  98      12.380  18.745 154.655  1.00 30.26           C  
ATOM    755  CD1 ILE A  98      13.726  19.502 151.889  1.00 32.88           C  
ATOM    756  N   THR A  99       8.920  18.527 154.712  1.00 31.16           N  
ATOM    757  CA  THR A  99       8.032  18.507 155.884  1.00 30.55           C  
ATOM    758  C   THR A  99       7.323  17.146 156.006  1.00 31.33           C  
ATOM    759  O   THR A  99       7.220  16.580 157.095  1.00 30.79           O  
ATOM    760  CB  THR A  99       6.982  19.654 155.828  1.00 30.12           C  
ATOM    761  OG1 THR A  99       7.639  20.922 156.025  1.00 29.09           O  
ATOM    762  CG2 THR A  99       5.888  19.481 156.894  1.00 27.36           C  
ATOM    763  N   GLN A 100       6.834  16.623 154.891  1.00 32.38           N  
ATOM    764  CA  GLN A 100       6.054  15.381 154.939  1.00 33.21           C  
ATOM    765  C   GLN A 100       6.919  14.203 155.379  1.00 33.68           C  
ATOM    766  O   GLN A 100       6.504  13.393 156.202  1.00 34.12           O  
ATOM    767  CB  GLN A 100       5.421  15.074 153.590  1.00 33.28           C  
ATOM    768  CG  GLN A 100       4.570  13.807 153.606  1.00 34.13           C  
ATOM    769  CD  GLN A 100       3.373  13.902 154.551  1.00 34.22           C  
ATOM    770  OE1 GLN A 100       3.324  13.236 155.593  1.00 36.81           O  
ATOM    771  NE2 GLN A 100       2.408  14.731 154.189  1.00 31.97           N  
ATOM    772  N   ARG A 101       8.112  14.112 154.812  1.00 34.42           N  
ATOM    773  CA  ARG A 101       9.084  13.104 155.212  1.00 35.13           C  
ATOM    774  C   ARG A 101       9.513  13.265 156.655  1.00 34.43           C  
ATOM    775  O   ARG A 101       9.667  12.269 157.360  1.00 34.48           O  
ATOM    776  CB  ARG A 101      10.323  13.185 154.336  1.00 35.68           C  
ATOM    777  CG  ARG A 101      10.097  12.662 152.969  1.00 39.74           C  
ATOM    778  CD  ARG A 101      11.382  12.693 152.186  1.00 45.61           C  
ATOM    779  NE  ARG A 101      11.263  11.934 150.947  1.00 50.75           N  
ATOM    780  CZ  ARG A 101      12.200  11.881 150.003  1.00 54.45           C  
ATOM    781  NH1 ARG A 101      13.347  12.550 150.158  1.00 55.47           N  
ATOM    782  NH2 ARG A 101      11.979  11.154 148.904  1.00 55.60           N  
ATOM    783  N   MET A 102       9.720  14.513 157.090  1.00 33.87           N  
ATOM    784  CA  MET A 102      10.116  14.781 158.479  1.00 33.04           C  
ATOM    785  C   MET A 102       9.036  14.304 159.450  1.00 32.91           C  
ATOM    786  O   MET A 102       9.330  13.654 160.468  1.00 32.13           O  
ATOM    787  CB  MET A 102      10.394  16.277 158.672  1.00 32.96           C  
ATOM    788  CG  MET A 102      11.176  16.608 159.933  1.00 31.67           C  
ATOM    789  SD  MET A 102      12.910  16.137 159.842  1.00 30.16           S  
ATOM    790  CE  MET A 102      13.584  17.477 158.858  1.00 26.38           C  
ATOM    791  N   VAL A 103       7.786  14.606 159.110  1.00 33.05           N  
ATOM    792  CA  VAL A 103       6.610  14.193 159.899  1.00 33.08           C  
ATOM    793  C   VAL A 103       6.412  12.668 159.920  1.00 33.39           C  
ATOM    794  O   VAL A 103       6.073  12.088 160.963  1.00 33.05           O  
ATOM    795  CB  VAL A 103       5.329  14.879 159.339  1.00 33.42           C  
ATOM    796  CG1 VAL A 103       4.075  14.182 159.792  1.00 32.65           C  
ATOM    797  CG2 VAL A 103       5.312  16.368 159.722  1.00 32.61           C  
ATOM    798  N   ASP A 104       6.611  12.031 158.768  1.00 33.55           N  
ATOM    799  CA  ASP A 104       6.568  10.567 158.672  1.00 34.06           C  
ATOM    800  C   ASP A 104       7.603   9.931 159.582  1.00 33.56           C  
ATOM    801  O   ASP A 104       7.277   9.033 160.357  1.00 33.33           O  
ATOM    802  CB  ASP A 104       6.822  10.083 157.233  1.00 34.09           C  
ATOM    803  CG  ASP A 104       5.671  10.405 156.280  1.00 35.96           C  
ATOM    804  OD1 ASP A 104       4.603  10.874 156.748  1.00 36.58           O  
ATOM    805  OD2 ASP A 104       5.846  10.196 155.056  1.00 36.09           O  
ATOM    806  N   PHE A 105       8.839  10.412 159.475  1.00 33.22           N  
ATOM    807  CA  PHE A 105       9.973   9.873 160.234  1.00 33.40           C  
ATOM    808  C   PHE A 105       9.790  10.054 161.746  1.00 33.72           C  
ATOM    809  O   PHE A 105      10.212   9.202 162.539  1.00 33.68           O  
ATOM    810  CB  PHE A 105      11.284  10.524 159.772  1.00 33.17           C  
ATOM    811  CG  PHE A 105      12.515   9.844 160.309  1.00 32.32           C  
ATOM    812  CD1 PHE A 105      13.026   8.718 159.691  1.00 34.08           C  
ATOM    813  CD2 PHE A 105      13.160  10.318 161.438  1.00 33.29           C  
ATOM    814  CE1 PHE A 105      14.165   8.083 160.181  1.00 34.18           C  
ATOM    815  CE2 PHE A 105      14.301   9.662 161.941  1.00 32.37           C  
ATOM    816  CZ  PHE A 105      14.795   8.552 161.299  1.00 31.49           C  
ATOM    817  N   ALA A 106       9.133  11.148 162.120  1.00 34.10           N  
ATOM    818  CA  ALA A 106       8.901  11.520 163.520  1.00 34.47           C  
ATOM    819  C   ALA A 106       7.776  10.731 164.174  1.00 34.69           C  
ATOM    820  O   ALA A 106       7.637  10.759 165.397  1.00 35.45           O  
ATOM    821  CB  ALA A 106       8.598  13.037 163.621  1.00 34.11           C  
ATOM    822  N   GLY A 107       6.955  10.066 163.370  1.00 35.01           N  
ATOM    823  CA  GLY A 107       5.883   9.217 163.883  1.00 35.64           C  
ATOM    824  C   GLY A 107       4.593   9.937 164.220  1.00 36.14           C  
ATOM    825  O   GLY A 107       3.785   9.429 164.996  1.00 36.32           O  
ATOM    826  N   VAL A 108       4.388  11.116 163.641  1.00 36.55           N  
ATOM    827  CA  VAL A 108       3.222  11.934 163.954  1.00 37.06           C  
ATOM    828  C   VAL A 108       2.377  12.199 162.704  1.00 37.57           C  
ATOM    829  O   VAL A 108       1.544  13.106 162.701  1.00 37.34           O  
ATOM    830  CB  VAL A 108       3.643  13.274 164.630  1.00 37.14           C  
ATOM    831  CG1 VAL A 108       4.486  12.998 165.873  1.00 37.38           C  
ATOM    832  CG2 VAL A 108       4.418  14.169 163.660  1.00 36.96           C  
ATOM    833  N   LYS A 109       2.559  11.375 161.667  1.00 38.23           N  
ATOM    834  CA  LYS A 109       1.877  11.591 160.386  1.00 38.91           C  
ATOM    835  C   LYS A 109       0.361  11.478 160.500  1.00 39.19           C  
ATOM    836  O   LYS A 109      -0.370  12.111 159.728  1.00 39.07           O  
ATOM    837  CB  LYS A 109       2.429  10.677 159.276  1.00 39.01           C  
ATOM    838  CG  LYS A 109       1.865   9.262 159.225  1.00 39.90           C  
ATOM    839  CD  LYS A 109       2.500   8.451 158.069  1.00 41.74           C  
ATOM    840  CE  LYS A 109       2.971   7.061 158.543  1.00 43.17           C  
ATOM    841  NZ  LYS A 109       3.727   6.242 157.528  1.00 43.98           N  
ATOM    842  N   ASP A 110      -0.116  10.702 161.472  1.00 39.63           N  
ATOM    843  CA  ASP A 110      -1.552  10.574 161.689  1.00 40.26           C  
ATOM    844  C   ASP A 110      -2.210  11.859 162.185  1.00 39.62           C  
ATOM    845  O   ASP A 110      -3.411  12.017 162.039  1.00 39.37           O  
ATOM    846  CB  ASP A 110      -1.873   9.424 162.651  1.00 40.93           C  
ATOM    847  CG  ASP A 110      -1.399   9.686 164.080  1.00 44.14           C  
ATOM    848  OD1 ASP A 110      -0.291  10.246 164.269  1.00 48.57           O  
ATOM    849  OD2 ASP A 110      -2.128   9.303 165.024  1.00 47.65           O  
ATOM    850  N   LYS A 111      -1.427  12.765 162.769  1.00 39.12           N  
ATOM    851  CA  LYS A 111      -1.958  14.017 163.314  1.00 38.71           C  
ATOM    852  C   LYS A 111      -1.896  15.176 162.330  1.00 37.78           C  
ATOM    853  O   LYS A 111      -2.524  16.209 162.548  1.00 37.67           O  
ATOM    854  CB  LYS A 111      -1.171  14.422 164.559  1.00 39.18           C  
ATOM    855  CG  LYS A 111      -1.184  13.396 165.683  1.00 39.98           C  
ATOM    856  CD  LYS A 111      -2.473  13.423 166.440  1.00 41.06           C  
ATOM    857  CE  LYS A 111      -2.279  12.904 167.861  1.00 42.13           C  
ATOM    858  NZ  LYS A 111      -1.744  11.511 167.921  1.00 43.70           N  
ATOM    859  N   VAL A 112      -1.135  15.011 161.254  1.00 36.87           N  
ATOM    860  CA  VAL A 112      -0.799  16.132 160.385  1.00 36.04           C  
ATOM    861  C   VAL A 112      -1.491  16.021 159.033  1.00 35.59           C  
ATOM    862  O   VAL A 112      -1.536  14.949 158.439  1.00 35.24           O  
ATOM    863  CB  VAL A 112       0.726  16.214 160.180  1.00 35.78           C  
ATOM    864  CG1 VAL A 112       1.091  17.302 159.168  1.00 35.06           C  
ATOM    865  CG2 VAL A 112       1.407  16.441 161.512  1.00 35.57           C  
ATOM    866  N   THR A 113      -2.017  17.148 158.567  1.00 35.01           N  
ATOM    867  CA  THR A 113      -2.541  17.277 157.223  1.00 35.27           C  
ATOM    868  C   THR A 113      -1.804  18.425 156.540  1.00 34.91           C  
ATOM    869  O   THR A 113      -2.025  19.591 156.854  1.00 34.55           O  
ATOM    870  CB  THR A 113      -4.052  17.577 157.232  1.00 35.23           C  
ATOM    871  OG1 THR A 113      -4.749  16.503 157.873  1.00 36.61           O  
ATOM    872  CG2 THR A 113      -4.578  17.756 155.805  1.00 36.42           C  
ATOM    873  N   LEU A 114      -0.918  18.077 155.615  1.00 35.07           N  
ATOM    874  CA  LEU A 114      -0.101  19.055 154.901  1.00 35.07           C  
ATOM    875  C   LEU A 114      -0.834  19.524 153.652  1.00 34.45           C  
ATOM    876  O   LEU A 114      -1.280  18.698 152.860  1.00 35.02           O  
ATOM    877  CB  LEU A 114       1.238  18.399 154.530  1.00 35.17           C  
ATOM    878  CG  LEU A 114       2.296  19.174 153.744  1.00 36.19           C  
ATOM    879  CD1 LEU A 114       2.588  20.563 154.328  1.00 37.95           C  
ATOM    880  CD2 LEU A 114       3.574  18.336 153.696  1.00 37.01           C  
ATOM    881  N   VAL A 115      -0.977  20.835 153.487  1.00 34.19           N  
ATOM    882  CA  VAL A 115      -1.554  21.427 152.269  1.00 33.55           C  
ATOM    883  C   VAL A 115      -0.529  22.300 151.533  1.00 33.10           C  
ATOM    884  O   VAL A 115       0.051  23.217 152.119  1.00 32.84           O  
ATOM    885  CB  VAL A 115      -2.760  22.317 152.597  1.00 33.82           C  
ATOM    886  CG1 VAL A 115      -3.353  22.910 151.295  1.00 33.68           C  
ATOM    887  CG2 VAL A 115      -3.801  21.530 153.389  1.00 33.43           C  
ATOM    888  N   VAL A 116      -0.309  22.020 150.248  1.00 32.85           N  
ATOM    889  CA  VAL A 116       0.615  22.810 149.455  1.00 32.58           C  
ATOM    890  C   VAL A 116      -0.158  23.958 148.823  1.00 32.89           C  
ATOM    891  O   VAL A 116      -1.139  23.747 148.114  1.00 33.58           O  
ATOM    892  CB  VAL A 116       1.339  21.961 148.390  1.00 32.77           C  
ATOM    893  CG1 VAL A 116       2.420  22.759 147.695  1.00 31.28           C  
ATOM    894  CG2 VAL A 116       1.933  20.697 149.037  1.00 32.88           C  
ATOM    895  N   GLY A 117       0.273  25.179 149.114  1.00 32.75           N  
ATOM    896  CA  GLY A 117      -0.339  26.372 148.563  1.00 32.55           C  
ATOM    897  C   GLY A 117      -0.100  27.561 149.471  1.00 32.22           C  
ATOM    898  O   GLY A 117       0.431  27.409 150.568  1.00 32.01           O  
ATOM    899  N   ALA A 118      -0.489  28.739 148.994  1.00 31.77           N  
ATOM    900  CA  ALA A 118      -0.444  29.967 149.778  1.00 31.16           C  
ATOM    901  C   ALA A 118      -1.531  30.013 150.856  1.00 30.68           C  
ATOM    902  O   ALA A 118      -2.669  29.599 150.637  1.00 30.65           O  
ATOM    903  CB  ALA A 118      -0.572  31.163 148.871  1.00 31.41           C  
ATOM    904  N   SER A 119      -1.168  30.549 152.017  1.00 30.31           N  
ATOM    905  CA  SER A 119      -2.094  30.741 153.117  1.00 29.65           C  
ATOM    906  C   SER A 119      -3.332  31.530 152.667  1.00 30.03           C  
ATOM    907  O   SER A 119      -4.475  31.082 152.874  1.00 29.82           O  
ATOM    908  CB  SER A 119      -1.375  31.438 154.278  1.00 29.67           C  
ATOM    909  OG  SER A 119      -0.635  32.563 153.841  1.00 28.07           O  
ATOM    910  N   GLN A 120      -3.106  32.665 152.004  1.00 30.09           N  
ATOM    911  CA  GLN A 120      -4.215  33.495 151.487  1.00 30.69           C  
ATOM    912  C   GLN A 120      -5.167  32.761 150.515  1.00 31.10           C  
ATOM    913  O   GLN A 120      -6.363  33.053 150.469  1.00 31.79           O  
ATOM    914  CB  GLN A 120      -3.678  34.773 150.839  1.00 30.71           C  
ATOM    915  CG  GLN A 120      -2.812  34.592 149.586  1.00 30.73           C  
ATOM    916  CD  GLN A 120      -1.335  34.497 149.889  1.00 32.31           C  
ATOM    917  OE1 GLN A 120      -0.918  33.961 150.939  1.00 33.70           O  
ATOM    918  NE2 GLN A 120      -0.521  34.996 148.971  1.00 30.53           N  
ATOM    919  N   ASP A 121      -4.642  31.800 149.763  1.00 31.35           N  
ATOM    920  CA  ASP A 121      -5.462  31.009 148.844  1.00 31.27           C  
ATOM    921  C   ASP A 121      -6.198  29.899 149.562  1.00 31.29           C  
ATOM    922  O   ASP A 121      -7.341  29.607 149.242  1.00 31.75           O  
ATOM    923  CB  ASP A 121      -4.593  30.392 147.740  1.00 31.55           C  
ATOM    924  CG  ASP A 121      -4.005  31.438 146.813  1.00 32.02           C  
ATOM    925  OD1 ASP A 121      -4.647  32.501 146.664  1.00 32.76           O  
ATOM    926  OD2 ASP A 121      -2.913  31.201 146.234  1.00 31.26           O  
ATOM    927  N   ILE A 122      -5.542  29.265 150.526  1.00 31.43           N  
ATOM    928  CA  ILE A 122      -6.105  28.067 151.163  1.00 31.31           C  
ATOM    929  C   ILE A 122      -7.104  28.405 152.264  1.00 31.24           C  
ATOM    930  O   ILE A 122      -8.094  27.695 152.439  1.00 30.64           O  
ATOM    931  CB  ILE A 122      -4.980  27.147 151.723  1.00 31.39           C  
ATOM    932  CG1 ILE A 122      -4.025  26.715 150.597  1.00 31.44           C  
ATOM    933  CG2 ILE A 122      -5.571  25.949 152.457  1.00 30.37           C  
ATOM    934  CD1 ILE A 122      -4.684  25.910 149.447  1.00 32.39           C  
ATOM    935  N   ILE A 123      -6.855  29.490 152.993  1.00 31.56           N  
ATOM    936  CA  ILE A 123      -7.692  29.867 154.139  1.00 31.93           C  
ATOM    937  C   ILE A 123      -9.191  29.973 153.787  1.00 32.85           C  
ATOM    938  O   ILE A 123     -10.032  29.437 154.512  1.00 32.87           O  
ATOM    939  CB  ILE A 123      -7.157  31.174 154.847  1.00 31.81           C  
ATOM    940  CG1 ILE A 123      -5.940  30.856 155.713  1.00 31.79           C  
ATOM    941  CG2 ILE A 123      -8.233  31.839 155.699  1.00 30.42           C  
ATOM    942  CD1 ILE A 123      -5.136  32.087 156.119  1.00 30.94           C  
ATOM    943  N   PRO A 124      -9.531  30.653 152.678  1.00 33.83           N  
ATOM    944  CA  PRO A 124     -10.950  30.705 152.283  1.00 34.79           C  
ATOM    945  C   PRO A 124     -11.560  29.362 151.860  1.00 36.34           C  
ATOM    946  O   PRO A 124     -12.774  29.289 151.690  1.00 36.82           O  
ATOM    947  CB  PRO A 124     -10.955  31.682 151.102  1.00 34.47           C  
ATOM    948  CG  PRO A 124      -9.736  32.503 151.258  1.00 33.89           C  
ATOM    949  CD  PRO A 124      -8.715  31.629 151.929  1.00 33.88           C  
ATOM    950  N   GLN A 125     -10.725  28.330 151.677  1.00 37.82           N  
ATOM    951  CA  GLN A 125     -11.177  26.994 151.282  1.00 39.00           C  
ATOM    952  C   GLN A 125     -11.272  26.026 152.466  1.00 39.61           C  
ATOM    953  O   GLN A 125     -11.669  24.878 152.281  1.00 39.67           O  
ATOM    954  CB  GLN A 125     -10.223  26.400 150.229  1.00 39.21           C  
ATOM    955  CG  GLN A 125     -10.087  27.221 148.940  1.00 41.31           C  
ATOM    956  CD  GLN A 125      -8.958  26.735 148.020  1.00 44.47           C  
ATOM    957  OE1 GLN A 125      -8.436  25.629 148.175  1.00 47.30           O  
ATOM    958  NE2 GLN A 125      -8.569  27.579 147.064  1.00 46.62           N  
ATOM    959  N   LEU A 126     -10.920  26.469 153.677  1.00 40.52           N  
ATOM    960  CA  LEU A 126     -10.773  25.526 154.807  1.00 41.32           C  
ATOM    961  C   LEU A 126     -12.099  24.906 155.251  1.00 42.52           C  
ATOM    962  O   LEU A 126     -12.140  23.738 155.633  1.00 42.33           O  
ATOM    963  CB  LEU A 126     -10.049  26.167 155.999  1.00 41.09           C  
ATOM    964  CG  LEU A 126      -8.532  26.361 155.852  1.00 40.62           C  
ATOM    965  CD1 LEU A 126      -7.977  27.245 156.964  1.00 39.72           C  
ATOM    966  CD2 LEU A 126      -7.775  25.022 155.811  1.00 39.51           C  
ATOM    967  N   LYS A 127     -13.181  25.674 155.178  1.00 44.01           N  
ATOM    968  CA  LYS A 127     -14.501  25.153 155.531  1.00 45.40           C  
ATOM    969  C   LYS A 127     -15.042  24.199 154.460  1.00 46.50           C  
ATOM    970  O   LYS A 127     -15.515  23.119 154.785  1.00 46.41           O  
ATOM    971  CB  LYS A 127     -15.495  26.288 155.757  1.00 45.62           C  
ATOM    972  CG  LYS A 127     -15.271  27.098 157.032  1.00 46.66           C  
ATOM    973  CD  LYS A 127     -16.336  28.174 157.167  1.00 48.61           C  
ATOM    974  CE  LYS A 127     -16.142  29.027 158.412  1.00 48.90           C  
ATOM    975  NZ  LYS A 127     -16.772  28.387 159.591  1.00 50.30           N  
ATOM    976  N   LYS A 128     -14.973  24.599 153.189  1.00 47.93           N  
ATOM    977  CA  LYS A 128     -15.524  23.779 152.112  1.00 49.20           C  
ATOM    978  C   LYS A 128     -14.638  22.566 151.796  1.00 49.50           C  
ATOM    979  O   LYS A 128     -15.128  21.439 151.747  1.00 49.59           O  
ATOM    980  CB  LYS A 128     -15.829  24.622 150.852  1.00 49.69           C  
ATOM    981  CG  LYS A 128     -14.628  25.159 150.039  1.00 51.72           C  
ATOM    982  CD  LYS A 128     -15.087  26.236 149.005  1.00 53.79           C  
ATOM    983  CE  LYS A 128     -13.951  26.762 148.098  1.00 54.93           C  
ATOM    984  NZ  LYS A 128     -13.376  28.074 148.564  1.00 55.70           N  
ATOM    985  N   LYS A 129     -13.340  22.793 151.630  1.00 49.74           N  
ATOM    986  CA  LYS A 129     -12.429  21.747 151.170  1.00 50.18           C  
ATOM    987  C   LYS A 129     -11.776  20.907 152.273  1.00 50.16           C  
ATOM    988  O   LYS A 129     -11.271  19.827 151.991  1.00 50.69           O  
ATOM    989  CB  LYS A 129     -11.319  22.353 150.308  1.00 50.28           C  
ATOM    990  CG  LYS A 129     -11.805  23.034 149.039  1.00 51.20           C  
ATOM    991  CD  LYS A 129     -10.649  23.250 148.069  1.00 52.10           C  
ATOM    992  CE  LYS A 129     -11.078  23.999 146.819  1.00 52.50           C  
ATOM    993  NZ  LYS A 129      -9.907  24.297 145.929  1.00 52.76           N  
ATOM    994  N   TYR A 130     -11.745  21.392 153.510  1.00 50.17           N  
ATOM    995  CA  TYR A 130     -10.984  20.693 154.558  1.00 49.99           C  
ATOM    996  C   TYR A 130     -11.789  20.386 155.811  1.00 49.66           C  
ATOM    997  O   TYR A 130     -11.225  19.971 156.820  1.00 49.23           O  
ATOM    998  CB  TYR A 130      -9.702  21.475 154.886  1.00 50.21           C  
ATOM    999  CG  TYR A 130      -8.758  21.520 153.703  1.00 51.15           C  
ATOM   1000  CD1 TYR A 130      -7.824  20.509 153.496  1.00 51.98           C  
ATOM   1001  CD2 TYR A 130      -8.837  22.544 152.762  1.00 52.76           C  
ATOM   1002  CE1 TYR A 130      -6.977  20.531 152.405  1.00 52.82           C  
ATOM   1003  CE2 TYR A 130      -7.986  22.580 151.658  1.00 52.98           C  
ATOM   1004  CZ  TYR A 130      -7.061  21.568 151.490  1.00 53.52           C  
ATOM   1005  OH  TYR A 130      -6.217  21.583 150.402  1.00 55.78           O  
ATOM   1006  N   ASP A 131     -13.108  20.567 155.723  1.00 49.34           N  
ATOM   1007  CA  ASP A 131     -14.042  20.239 156.805  1.00 49.37           C  
ATOM   1008  C   ASP A 131     -13.811  20.975 158.127  1.00 48.52           C  
ATOM   1009  O   ASP A 131     -14.186  20.475 159.182  1.00 48.81           O  
ATOM   1010  CB  ASP A 131     -14.086  18.719 157.038  1.00 49.80           C  
ATOM   1011  CG  ASP A 131     -14.747  17.971 155.880  1.00 51.63           C  
ATOM   1012  OD1 ASP A 131     -14.537  18.371 154.705  1.00 53.49           O  
ATOM   1013  OD2 ASP A 131     -15.479  16.988 156.149  1.00 53.30           O  
ATOM   1014  N   VAL A 132     -13.219  22.167 158.068  1.00 47.47           N  
ATOM   1015  CA  VAL A 132     -13.043  23.003 159.258  1.00 46.59           C  
ATOM   1016  C   VAL A 132     -14.308  23.809 159.524  1.00 45.50           C  
ATOM   1017  O   VAL A 132     -14.920  24.334 158.598  1.00 45.63           O  
ATOM   1018  CB  VAL A 132     -11.864  23.983 159.089  1.00 46.56           C  
ATOM   1019  CG1 VAL A 132     -11.774  24.926 160.273  1.00 46.19           C  
ATOM   1020  CG2 VAL A 132     -10.565  23.210 158.904  1.00 47.03           C  
ATOM   1021  N   ASP A 133     -14.700  23.895 160.788  1.00 44.10           N  
ATOM   1022  CA  ASP A 133     -15.765  24.791 161.199  1.00 43.40           C  
ATOM   1023  C   ASP A 133     -15.104  26.073 161.734  1.00 41.79           C  
ATOM   1024  O   ASP A 133     -15.180  27.132 161.098  1.00 41.26           O  
ATOM   1025  CB  ASP A 133     -16.655  24.123 162.254  1.00 43.93           C  
ATOM   1026  CG  ASP A 133     -17.925  24.913 162.530  1.00 46.58           C  
ATOM   1027  OD1 ASP A 133     -17.859  26.167 162.675  1.00 48.65           O  
ATOM   1028  OD2 ASP A 133     -19.002  24.269 162.604  1.00 50.35           O  
ATOM   1029  N   THR A 134     -14.451  25.955 162.891  1.00 39.61           N  
ATOM   1030  CA  THR A 134     -13.631  27.020 163.449  1.00 38.08           C  
ATOM   1031  C   THR A 134     -12.301  26.431 163.907  1.00 36.48           C  
ATOM   1032  O   THR A 134     -12.175  25.224 164.132  1.00 36.16           O  
ATOM   1033  CB  THR A 134     -14.328  27.768 164.627  1.00 38.13           C  
ATOM   1034  OG1 THR A 134     -14.595  26.860 165.700  1.00 38.53           O  
ATOM   1035  CG2 THR A 134     -15.626  28.437 164.176  1.00 37.58           C  
ATOM   1036  N   LEU A 135     -11.301  27.291 164.028  1.00 34.77           N  
ATOM   1037  CA  LEU A 135      -9.981  26.877 164.467  1.00 33.52           C  
ATOM   1038  C   LEU A 135      -9.862  27.098 165.961  1.00 32.51           C  
ATOM   1039  O   LEU A 135     -10.412  28.062 166.497  1.00 32.93           O  
ATOM   1040  CB  LEU A 135      -8.897  27.669 163.724  1.00 33.34           C  
ATOM   1041  CG  LEU A 135      -8.928  27.527 162.205  1.00 32.74           C  
ATOM   1042  CD1 LEU A 135      -8.031  28.545 161.520  1.00 31.57           C  
ATOM   1043  CD2 LEU A 135      -8.535  26.121 161.836  1.00 32.95           C  
ATOM   1044  N   ASP A 136      -9.146  26.198 166.622  1.00 31.46           N  
ATOM   1045  CA  ASP A 136      -8.838  26.331 168.048  1.00 30.96           C  
ATOM   1046  C   ASP A 136      -7.558  27.113 168.270  1.00 30.18           C  
ATOM   1047  O   ASP A 136      -7.447  27.855 169.241  1.00 30.02           O  
ATOM   1048  CB  ASP A 136      -8.693  24.958 168.691  1.00 31.16           C  
ATOM   1049  CG  ASP A 136      -9.955  24.138 168.595  1.00 32.11           C  
ATOM   1050  OD1 ASP A 136     -11.056  24.718 168.719  1.00 33.70           O  
ATOM   1051  OD2 ASP A 136      -9.848  22.919 168.390  1.00 34.42           O  
ATOM   1052  N   MET A 137      -6.597  26.941 167.361  1.00 29.62           N  
ATOM   1053  CA  MET A 137      -5.318  27.623 167.439  1.00 28.85           C  
ATOM   1054  C   MET A 137      -4.674  27.755 166.046  1.00 28.22           C  
ATOM   1055  O   MET A 137      -4.908  26.934 165.149  1.00 26.72           O  
ATOM   1056  CB  MET A 137      -4.383  26.868 168.390  1.00 29.34           C  
ATOM   1057  CG  MET A 137      -3.039  27.583 168.684  1.00 30.57           C  
ATOM   1058  SD  MET A 137      -1.997  26.684 169.851  1.00 32.87           S  
ATOM   1059  CE  MET A 137      -0.376  27.303 169.378  1.00 35.36           C  
ATOM   1060  N   VAL A 138      -3.886  28.821 165.888  1.00 27.71           N  
ATOM   1061  CA  VAL A 138      -3.159  29.124 164.651  1.00 26.91           C  
ATOM   1062  C   VAL A 138      -1.736  29.514 165.028  1.00 27.17           C  
ATOM   1063  O   VAL A 138      -1.548  30.380 165.878  1.00 27.70           O  
ATOM   1064  CB  VAL A 138      -3.780  30.308 163.858  1.00 27.13           C  
ATOM   1065  CG1 VAL A 138      -2.990  30.574 162.563  1.00 25.60           C  
ATOM   1066  CG2 VAL A 138      -5.256  30.050 163.541  1.00 25.02           C  
ATOM   1067  N   PHE A 139      -0.745  28.868 164.417  1.00 26.27           N  
ATOM   1068  CA  PHE A 139       0.646  29.285 164.565  1.00 26.20           C  
ATOM   1069  C   PHE A 139       1.075  30.007 163.292  1.00 25.92           C  
ATOM   1070  O   PHE A 139       1.100  29.408 162.210  1.00 25.43           O  
ATOM   1071  CB  PHE A 139       1.553  28.075 164.819  1.00 25.81           C  
ATOM   1072  CG  PHE A 139       3.007  28.429 165.039  1.00 26.91           C  
ATOM   1073  CD1 PHE A 139       3.374  29.424 165.940  1.00 26.15           C  
ATOM   1074  CD2 PHE A 139       4.014  27.724 164.381  1.00 25.91           C  
ATOM   1075  CE1 PHE A 139       4.724  29.734 166.147  1.00 28.02           C  
ATOM   1076  CE2 PHE A 139       5.356  28.025 164.585  1.00 25.63           C  
ATOM   1077  CZ  PHE A 139       5.713  29.029 165.466  1.00 26.49           C  
ATOM   1078  N   LEU A 140       1.410  31.286 163.428  1.00 25.69           N  
ATOM   1079  CA  LEU A 140       1.823  32.087 162.282  1.00 26.49           C  
ATOM   1080  C   LEU A 140       3.333  32.173 162.265  1.00 26.36           C  
ATOM   1081  O   LEU A 140       3.936  32.734 163.180  1.00 26.53           O  
ATOM   1082  CB  LEU A 140       1.249  33.507 162.348  1.00 26.36           C  
ATOM   1083  CG  LEU A 140      -0.276  33.707 162.355  1.00 27.23           C  
ATOM   1084  CD1 LEU A 140      -0.846  33.613 163.777  1.00 26.49           C  
ATOM   1085  CD2 LEU A 140      -0.609  35.051 161.749  1.00 26.95           C  
ATOM   1086  N   ASP A 141       3.938  31.656 161.205  1.00 26.81           N  
ATOM   1087  CA  ASP A 141       5.401  31.663 161.083  1.00 27.25           C  
ATOM   1088  C   ASP A 141       5.852  31.606 159.616  1.00 27.60           C  
ATOM   1089  O   ASP A 141       6.808  30.924 159.266  1.00 28.32           O  
ATOM   1090  CB  ASP A 141       5.976  30.493 161.875  1.00 26.92           C  
ATOM   1091  CG  ASP A 141       7.453  30.592 162.069  1.00 26.44           C  
ATOM   1092  OD1 ASP A 141       7.981  31.717 162.046  1.00 27.04           O  
ATOM   1093  OD2 ASP A 141       8.094  29.539 162.256  1.00 26.23           O  
ATOM   1094  N   HIS A 142       5.164  32.358 158.773  1.00 27.85           N  
ATOM   1095  CA  HIS A 142       5.463  32.421 157.347  1.00 28.25           C  
ATOM   1096  C   HIS A 142       6.053  33.808 157.084  1.00 28.66           C  
ATOM   1097  O   HIS A 142       6.605  34.389 158.008  1.00 28.76           O  
ATOM   1098  CB  HIS A 142       4.232  32.035 156.489  1.00 28.18           C  
ATOM   1099  CG  HIS A 142       2.972  32.790 156.796  1.00 28.17           C  
ATOM   1100  ND1 HIS A 142       2.663  33.283 158.049  1.00 27.45           N  
ATOM   1101  CD2 HIS A 142       1.906  33.081 156.008  1.00 26.91           C  
ATOM   1102  CE1 HIS A 142       1.482  33.880 158.007  1.00 27.25           C  
ATOM   1103  NE2 HIS A 142       1.004  33.770 156.779  1.00 26.17           N  
ATOM   1104  N   TRP A 143       5.992  34.338 155.864  1.00 29.08           N  
ATOM   1105  CA  TRP A 143       6.550  35.664 155.614  1.00 29.84           C  
ATOM   1106  C   TRP A 143       5.746  36.715 156.405  1.00 29.98           C  
ATOM   1107  O   TRP A 143       4.510  36.705 156.418  1.00 29.79           O  
ATOM   1108  CB  TRP A 143       6.569  36.019 154.118  1.00 30.65           C  
ATOM   1109  CG  TRP A 143       7.420  35.132 153.163  1.00 31.21           C  
ATOM   1110  CD1 TRP A 143       7.260  35.039 151.803  1.00 31.93           C  
ATOM   1111  CD2 TRP A 143       8.529  34.253 153.488  1.00 32.98           C  
ATOM   1112  NE1 TRP A 143       8.176  34.166 151.270  1.00 32.52           N  
ATOM   1113  CE2 TRP A 143       8.972  33.674 152.272  1.00 33.52           C  
ATOM   1114  CE3 TRP A 143       9.166  33.878 154.682  1.00 34.15           C  
ATOM   1115  CZ2 TRP A 143      10.033  32.748 152.211  1.00 34.54           C  
ATOM   1116  CZ3 TRP A 143      10.251  32.971 154.619  1.00 35.19           C  
ATOM   1117  CH2 TRP A 143      10.658  32.410 153.389  1.00 35.63           C  
ATOM   1118  N   LYS A 144       6.461  37.617 157.069  1.00 29.84           N  
ATOM   1119  CA  LYS A 144       5.869  38.456 158.107  1.00 30.08           C  
ATOM   1120  C   LYS A 144       4.825  39.453 157.571  1.00 30.26           C  
ATOM   1121  O   LYS A 144       3.934  39.884 158.320  1.00 29.63           O  
ATOM   1122  CB  LYS A 144       6.975  39.167 158.900  1.00 30.10           C  
ATOM   1123  CG  LYS A 144       8.122  38.225 159.379  1.00 30.45           C  
ATOM   1124  CD  LYS A 144       7.618  36.886 159.986  1.00 28.85           C  
ATOM   1125  CE  LYS A 144       8.710  35.827 160.095  1.00 28.43           C  
ATOM   1126  NZ  LYS A 144       8.161  34.444 160.404  1.00 25.79           N  
ATOM   1127  N   ASP A 145       4.903  39.780 156.275  1.00 30.74           N  
ATOM   1128  CA  ASP A 145       3.918  40.686 155.657  1.00 31.33           C  
ATOM   1129  C   ASP A 145       2.546  40.030 155.447  1.00 30.82           C  
ATOM   1130  O   ASP A 145       1.565  40.714 155.151  1.00 32.09           O  
ATOM   1131  CB  ASP A 145       4.460  41.366 154.370  1.00 31.70           C  
ATOM   1132  CG  ASP A 145       4.801  40.377 153.233  1.00 34.65           C  
ATOM   1133  OD1 ASP A 145       4.994  39.162 153.469  1.00 38.48           O  
ATOM   1134  OD2 ASP A 145       4.891  40.836 152.067  1.00 38.79           O  
ATOM   1135  N   ARG A 146       2.457  38.724 155.656  1.00 30.14           N  
ATOM   1136  CA  ARG A 146       1.176  38.012 155.591  1.00 29.99           C  
ATOM   1137  C   ARG A 146       0.467  37.900 156.946  1.00 29.00           C  
ATOM   1138  O   ARG A 146      -0.704  37.515 156.990  1.00 28.71           O  
ATOM   1139  CB  ARG A 146       1.391  36.604 155.035  1.00 30.35           C  
ATOM   1140  CG  ARG A 146       1.842  36.553 153.567  1.00 32.72           C  
ATOM   1141  CD  ARG A 146       0.877  37.280 152.621  1.00 34.63           C  
ATOM   1142  NE  ARG A 146      -0.545  36.993 152.877  1.00 35.91           N  
ATOM   1143  CZ  ARG A 146      -1.542  37.736 152.390  1.00 37.32           C  
ATOM   1144  NH1 ARG A 146      -1.266  38.774 151.622  1.00 37.40           N  
ATOM   1145  NH2 ARG A 146      -2.822  37.472 152.682  1.00 37.98           N  
ATOM   1146  N   TYR A 147       1.167  38.220 158.037  1.00 27.67           N  
ATOM   1147  CA  TYR A 147       0.611  38.038 159.379  1.00 27.71           C  
ATOM   1148  C   TYR A 147      -0.701  38.788 159.526  1.00 27.99           C  
ATOM   1149  O   TYR A 147      -1.726  38.188 159.836  1.00 28.42           O  
ATOM   1150  CB  TYR A 147       1.573  38.520 160.468  1.00 27.54           C  
ATOM   1151  CG  TYR A 147       2.682  37.561 160.868  1.00 27.18           C  
ATOM   1152  CD1 TYR A 147       3.190  36.603 159.986  1.00 27.73           C  
ATOM   1153  CD2 TYR A 147       3.282  37.682 162.110  1.00 27.72           C  
ATOM   1154  CE1 TYR A 147       4.232  35.761 160.368  1.00 27.81           C  
ATOM   1155  CE2 TYR A 147       4.333  36.857 162.493  1.00 27.88           C  
ATOM   1156  CZ  TYR A 147       4.799  35.893 161.629  1.00 27.36           C  
ATOM   1157  OH  TYR A 147       5.854  35.077 162.035  1.00 27.86           O  
ATOM   1158  N   LEU A 148      -0.668  40.100 159.319  1.00 28.21           N  
ATOM   1159  CA  LEU A 148      -1.888  40.903 159.458  1.00 28.47           C  
ATOM   1160  C   LEU A 148      -2.984  40.510 158.450  1.00 28.33           C  
ATOM   1161  O   LEU A 148      -4.079  40.135 158.869  1.00 28.53           O  
ATOM   1162  CB  LEU A 148      -1.563  42.404 159.436  1.00 28.58           C  
ATOM   1163  CG  LEU A 148      -2.737  43.373 159.589  1.00 29.69           C  
ATOM   1164  CD1 LEU A 148      -3.607  43.034 160.803  1.00 28.74           C  
ATOM   1165  CD2 LEU A 148      -2.222  44.806 159.651  1.00 31.85           C  
ATOM   1166  N   PRO A 149      -2.703  40.547 157.126  1.00 28.13           N  
ATOM   1167  CA  PRO A 149      -3.805  40.206 156.217  1.00 28.23           C  
ATOM   1168  C   PRO A 149      -4.347  38.770 156.333  1.00 28.02           C  
ATOM   1169  O   PRO A 149      -5.518  38.568 156.057  1.00 28.61           O  
ATOM   1170  CB  PRO A 149      -3.229  40.487 154.807  1.00 28.25           C  
ATOM   1171  CG  PRO A 149      -1.792  40.622 154.978  1.00 27.98           C  
ATOM   1172  CD  PRO A 149      -1.558  41.105 156.386  1.00 28.56           C  
ATOM   1173  N   ASP A 150      -3.545  37.796 156.759  1.00 28.49           N  
ATOM   1174  CA  ASP A 150      -4.079  36.438 156.986  1.00 29.07           C  
ATOM   1175  C   ASP A 150      -4.973  36.366 158.230  1.00 29.15           C  
ATOM   1176  O   ASP A 150      -5.958  35.610 158.254  1.00 29.00           O  
ATOM   1177  CB  ASP A 150      -2.961  35.384 157.080  1.00 29.25           C  
ATOM   1178  CG  ASP A 150      -2.333  35.054 155.717  1.00 30.96           C  
ATOM   1179  OD1 ASP A 150      -2.853  35.512 154.667  1.00 31.63           O  
ATOM   1180  OD2 ASP A 150      -1.324  34.321 155.700  1.00 31.70           O  
ATOM   1181  N   THR A 151      -4.604  37.127 159.261  1.00 29.01           N  
ATOM   1182  CA  THR A 151      -5.396  37.252 160.474  1.00 28.85           C  
ATOM   1183  C   THR A 151      -6.771  37.844 160.147  1.00 29.38           C  
ATOM   1184  O   THR A 151      -7.794  37.326 160.605  1.00 28.55           O  
ATOM   1185  CB  THR A 151      -4.671  38.138 161.543  1.00 28.98           C  
ATOM   1186  OG1 THR A 151      -3.457  37.492 161.975  1.00 28.48           O  
ATOM   1187  CG2 THR A 151      -5.573  38.396 162.761  1.00 27.64           C  
ATOM   1188  N   LEU A 152      -6.774  38.938 159.376  1.00 29.59           N  
ATOM   1189  CA  LEU A 152      -8.023  39.570 158.911  1.00 30.21           C  
ATOM   1190  C   LEU A 152      -8.812  38.613 158.029  1.00 30.00           C  
ATOM   1191  O   LEU A 152     -10.030  38.573 158.122  1.00 29.81           O  
ATOM   1192  CB  LEU A 152      -7.759  40.890 158.163  1.00 29.80           C  
ATOM   1193  CG  LEU A 152      -7.092  42.016 158.974  1.00 31.45           C  
ATOM   1194  CD1 LEU A 152      -6.732  43.183 158.064  1.00 30.93           C  
ATOM   1195  CD2 LEU A 152      -7.965  42.499 160.158  1.00 32.13           C  
ATOM   1196  N   LEU A 153      -8.117  37.829 157.197  1.00 30.24           N  
ATOM   1197  CA  LEU A 153      -8.790  36.834 156.347  1.00 30.09           C  
ATOM   1198  C   LEU A 153      -9.458  35.771 157.203  1.00 30.61           C  
ATOM   1199  O   LEU A 153     -10.621  35.455 157.002  1.00 30.40           O  
ATOM   1200  CB  LEU A 153      -7.791  36.182 155.387  0.50 30.19           C  
ATOM   1202  CG  LEU A 153      -8.371  35.379 154.229  0.50 29.05           C  
ATOM   1204  CD1 LEU A 153      -9.192  36.294 153.308  0.50 28.31           C  
ATOM   1206  CD2 LEU A 153      -7.241  34.716 153.466  0.50 29.03           C  
ATOM   1208  N   LEU A 154      -8.708  35.227 158.162  1.00 31.38           N  
ATOM   1209  CA  LEU A 154      -9.235  34.220 159.085  1.00 31.77           C  
ATOM   1210  C   LEU A 154     -10.523  34.723 159.756  1.00 32.42           C  
ATOM   1211  O   LEU A 154     -11.541  34.037 159.768  1.00 32.01           O  
ATOM   1212  CB  LEU A 154      -8.174  33.856 160.132  1.00 31.93           C  
ATOM   1213  CG  LEU A 154      -7.034  32.950 159.640  1.00 31.60           C  
ATOM   1214  CD1 LEU A 154      -5.782  33.101 160.510  1.00 31.82           C  
ATOM   1215  CD2 LEU A 154      -7.472  31.499 159.580  1.00 30.38           C  
ATOM   1216  N   GLU A 155     -10.470  35.936 160.285  1.00 33.11           N  
ATOM   1217  CA  GLU A 155     -11.625  36.544 160.917  1.00 34.26           C  
ATOM   1218  C   GLU A 155     -12.815  36.656 159.949  1.00 34.55           C  
ATOM   1219  O   GLU A 155     -13.910  36.157 160.236  1.00 33.89           O  
ATOM   1220  CB  GLU A 155     -11.264  37.920 161.494  1.00 34.64           C  
ATOM   1221  CG  GLU A 155     -12.297  38.409 162.482  1.00 36.65           C  
ATOM   1222  CD  GLU A 155     -12.022  39.781 163.066  1.00 39.34           C  
ATOM   1223  OE1 GLU A 155     -11.038  40.454 162.656  1.00 39.40           O  
ATOM   1224  OE2 GLU A 155     -12.832  40.176 163.947  1.00 40.92           O  
ATOM   1225  N   GLU A 156     -12.580  37.301 158.812  1.00 35.23           N  
ATOM   1226  CA  GLU A 156     -13.591  37.473 157.766  1.00 36.08           C  
ATOM   1227  C   GLU A 156     -14.142  36.184 157.178  1.00 35.61           C  
ATOM   1228  O   GLU A 156     -15.292  36.147 156.750  1.00 35.53           O  
ATOM   1229  CB  GLU A 156     -13.026  38.304 156.620  1.00 36.65           C  
ATOM   1230  CG  GLU A 156     -13.118  39.764 156.872  1.00 40.06           C  
ATOM   1231  CD  GLU A 156     -12.298  40.571 155.896  1.00 45.20           C  
ATOM   1232  OE1 GLU A 156     -11.825  39.973 154.884  1.00 47.12           O  
ATOM   1233  OE2 GLU A 156     -12.120  41.790 156.159  1.00 47.02           O  
ATOM   1234  N   CYS A 157     -13.333  35.132 157.135  1.00 34.99           N  
ATOM   1235  CA  CYS A 157     -13.830  33.851 156.663  1.00 34.92           C  
ATOM   1236  C   CYS A 157     -14.596  33.121 157.772  1.00 34.50           C  
ATOM   1237  O   CYS A 157     -15.117  32.034 157.550  1.00 34.70           O  
ATOM   1238  CB  CYS A 157     -12.690  33.019 156.090  1.00 34.57           C  
ATOM   1239  SG  CYS A 157     -12.030  33.806 154.579  1.00 36.12           S  
ATOM   1240  N   GLY A 158     -14.690  33.743 158.951  1.00 33.96           N  
ATOM   1241  CA  GLY A 158     -15.462  33.189 160.060  1.00 33.61           C  
ATOM   1242  C   GLY A 158     -14.784  32.019 160.741  1.00 33.35           C  
ATOM   1243  O   GLY A 158     -15.453  31.213 161.399  1.00 33.40           O  
ATOM   1244  N   LEU A 159     -13.456  31.936 160.609  1.00 32.79           N  
ATOM   1245  CA  LEU A 159     -12.676  30.819 161.163  1.00 32.30           C  
ATOM   1246  C   LEU A 159     -12.239  30.987 162.618  1.00 31.96           C  
ATOM   1247  O   LEU A 159     -11.708  30.043 163.220  1.00 31.49           O  
ATOM   1248  CB  LEU A 159     -11.443  30.563 160.297  1.00 32.39           C  
ATOM   1249  CG  LEU A 159     -11.785  29.924 158.948  1.00 32.38           C  
ATOM   1250  CD1 LEU A 159     -10.700  30.162 157.918  1.00 32.35           C  
ATOM   1251  CD2 LEU A 159     -12.023  28.459 159.149  1.00 31.76           C  
ATOM   1252  N   LEU A 160     -12.447  32.172 163.185  1.00 31.23           N  
ATOM   1253  CA  LEU A 160     -12.081  32.413 164.576  1.00 31.24           C  
ATOM   1254  C   LEU A 160     -13.316  32.416 165.470  1.00 30.86           C  
ATOM   1255  O   LEU A 160     -14.388  32.832 165.062  1.00 30.22           O  
ATOM   1256  CB  LEU A 160     -11.332  33.744 164.733  1.00 31.20           C  
ATOM   1257  CG  LEU A 160     -10.077  34.025 163.887  1.00 31.59           C  
ATOM   1258  CD1 LEU A 160      -9.580  35.419 164.228  1.00 30.00           C  
ATOM   1259  CD2 LEU A 160      -8.950  32.993 164.089  1.00 31.07           C  
ATOM   1260  N   ARG A 161     -13.139  31.940 166.694  1.00 31.31           N  
ATOM   1261  CA  ARG A 161     -14.181  31.967 167.704  1.00 31.29           C  
ATOM   1262  C   ARG A 161     -13.590  32.457 169.010  1.00 31.68           C  
ATOM   1263  O   ARG A 161     -12.371  32.608 169.143  1.00 32.35           O  
ATOM   1264  CB  ARG A 161     -14.859  30.591 167.861  1.00 31.22           C  
ATOM   1265  CG  ARG A 161     -13.938  29.373 168.020  1.00 30.87           C  
ATOM   1266  CD  ARG A 161     -13.601  29.079 169.478  1.00 30.26           C  
ATOM   1267  NE  ARG A 161     -12.736  27.918 169.648  1.00 30.56           N  
ATOM   1268  CZ  ARG A 161     -12.086  27.626 170.778  1.00 30.88           C  
ATOM   1269  NH1 ARG A 161     -12.154  28.420 171.839  1.00 32.53           N  
ATOM   1270  NH2 ARG A 161     -11.329  26.547 170.839  1.00 31.90           N  
ATOM   1271  N   LYS A 162     -14.460  32.737 169.973  1.00 31.81           N  
ATOM   1272  CA  LYS A 162     -14.016  33.226 171.264  1.00 31.55           C  
ATOM   1273  C   LYS A 162     -13.105  32.186 171.884  1.00 30.68           C  
ATOM   1274  O   LYS A 162     -13.481  31.027 172.010  1.00 30.67           O  
ATOM   1275  CB  LYS A 162     -15.214  33.484 172.161  1.00 32.14           C  
ATOM   1276  CG  LYS A 162     -14.890  34.053 173.517  1.00 34.25           C  
ATOM   1277  CD  LYS A 162     -16.147  34.647 174.155  1.00 37.76           C  
ATOM   1278  CE  LYS A 162     -15.844  35.192 175.547  1.00 40.16           C  
ATOM   1279  NZ  LYS A 162     -16.947  36.065 176.061  1.00 41.80           N  
ATOM   1280  N   GLY A 163     -11.898  32.606 172.248  1.00 29.88           N  
ATOM   1281  CA  GLY A 163     -10.909  31.714 172.813  1.00 28.98           C  
ATOM   1282  C   GLY A 163      -9.920  31.151 171.811  1.00 28.73           C  
ATOM   1283  O   GLY A 163      -8.967  30.476 172.212  1.00 28.43           O  
ATOM   1284  N   THR A 164     -10.121  31.413 170.514  1.00 28.65           N  
ATOM   1285  CA  THR A 164      -9.139  30.984 169.510  1.00 28.20           C  
ATOM   1286  C   THR A 164      -7.808  31.681 169.781  1.00 28.03           C  
ATOM   1287  O   THR A 164      -7.762  32.891 169.986  1.00 28.11           O  
ATOM   1288  CB  THR A 164      -9.588  31.227 168.043  1.00 28.03           C  
ATOM   1289  OG1 THR A 164     -10.743  30.433 167.762  1.00 26.92           O  
ATOM   1290  CG2 THR A 164      -8.451  30.832 167.041  1.00 27.69           C  
ATOM   1291  N   VAL A 165      -6.743  30.883 169.799  1.00 27.95           N  
ATOM   1292  CA  VAL A 165      -5.402  31.342 170.117  1.00 28.15           C  
ATOM   1293  C   VAL A 165      -4.591  31.566 168.830  1.00 27.74           C  
ATOM   1294  O   VAL A 165      -4.424  30.652 168.031  1.00 27.57           O  
ATOM   1295  CB  VAL A 165      -4.678  30.308 171.034  1.00 28.59           C  
ATOM   1296  CG1 VAL A 165      -3.242  30.757 171.355  1.00 27.76           C  
ATOM   1297  CG2 VAL A 165      -5.473  30.088 172.318  1.00 28.72           C  
ATOM   1298  N   LEU A 166      -4.115  32.791 168.625  1.00 27.52           N  
ATOM   1299  CA  LEU A 166      -3.149  33.079 167.557  1.00 27.66           C  
ATOM   1300  C   LEU A 166      -1.812  33.187 168.233  1.00 26.99           C  
ATOM   1301  O   LEU A 166      -1.682  33.915 169.205  1.00 27.48           O  
ATOM   1302  CB  LEU A 166      -3.443  34.411 166.839  1.00 27.22           C  
ATOM   1303  CG  LEU A 166      -4.796  34.617 166.158  1.00 28.77           C  
ATOM   1304  CD1 LEU A 166      -4.790  35.948 165.338  1.00 28.77           C  
ATOM   1305  CD2 LEU A 166      -5.190  33.457 165.277  1.00 28.48           C  
ATOM   1306  N   LEU A 167      -0.832  32.445 167.742  1.00 26.67           N  
ATOM   1307  CA  LEU A 167       0.533  32.531 168.252  1.00 26.48           C  
ATOM   1308  C   LEU A 167       1.447  32.856 167.066  1.00 26.51           C  
ATOM   1309  O   LEU A 167       1.499  32.107 166.092  1.00 26.15           O  
ATOM   1310  CB  LEU A 167       0.951  31.217 168.943  1.00 25.88           C  
ATOM   1311  CG  LEU A 167       2.299  31.246 169.673  1.00 26.72           C  
ATOM   1312  CD1 LEU A 167       2.288  32.197 170.886  1.00 24.50           C  
ATOM   1313  CD2 LEU A 167       2.759  29.831 170.072  1.00 23.25           C  
ATOM   1314  N   ALA A 168       2.137  33.992 167.147  1.00 26.68           N  
ATOM   1315  CA  ALA A 168       2.992  34.466 166.061  1.00 26.59           C  
ATOM   1316  C   ALA A 168       4.444  34.484 166.465  1.00 26.49           C  
ATOM   1317  O   ALA A 168       4.800  35.054 167.484  1.00 26.09           O  
ATOM   1318  CB  ALA A 168       2.571  35.845 165.627  1.00 26.47           C  
ATOM   1319  N   ASP A 169       5.285  33.863 165.645  1.00 27.11           N  
ATOM   1320  CA  ASP A 169       6.735  33.899 165.858  1.00 27.43           C  
ATOM   1321  C   ASP A 169       7.302  35.199 165.289  1.00 27.75           C  
ATOM   1322  O   ASP A 169       6.643  35.862 164.493  1.00 26.67           O  
ATOM   1323  CB  ASP A 169       7.400  32.700 165.181  1.00 27.52           C  
ATOM   1324  CG  ASP A 169       8.851  32.524 165.598  1.00 27.28           C  
ATOM   1325  OD1 ASP A 169       9.239  33.015 166.673  1.00 26.10           O  
ATOM   1326  OD2 ASP A 169       9.602  31.884 164.847  1.00 28.56           O  
ATOM   1327  N   ASN A 170       8.502  35.568 165.736  1.00 28.22           N  
ATOM   1328  CA  ASN A 170       9.292  36.629 165.103  1.00 28.75           C  
ATOM   1329  C   ASN A 170       8.676  38.010 165.172  1.00 29.88           C  
ATOM   1330  O   ASN A 170       8.854  38.809 164.250  1.00 30.13           O  
ATOM   1331  CB  ASN A 170       9.537  36.314 163.624  1.00 28.38           C  
ATOM   1332  CG  ASN A 170      10.150  34.988 163.414  1.00 26.03           C  
ATOM   1333  OD1 ASN A 170       9.586  34.138 162.713  1.00 24.86           O  
ATOM   1334  ND2 ASN A 170      11.312  34.773 164.016  1.00 21.66           N  
ATOM   1335  N   VAL A 171       7.929  38.308 166.229  1.00 30.87           N  
ATOM   1336  CA  VAL A 171       7.230  39.594 166.256  1.00 31.61           C  
ATOM   1337  C   VAL A 171       8.180  40.742 166.586  1.00 32.24           C  
ATOM   1338  O   VAL A 171       7.834  41.903 166.351  1.00 32.98           O  
ATOM   1339  CB  VAL A 171       5.969  39.596 167.166  1.00 31.33           C  
ATOM   1340  CG1 VAL A 171       5.039  38.466 166.743  1.00 31.14           C  
ATOM   1341  CG2 VAL A 171       6.348  39.520 168.669  1.00 30.92           C  
ATOM   1342  N   ILE A 172       9.373  40.416 167.085  1.00 32.98           N  
ATOM   1343  CA  ILE A 172      10.450  41.396 167.246  1.00 33.36           C  
ATOM   1344  C   ILE A 172      11.475  41.306 166.102  1.00 33.60           C  
ATOM   1345  O   ILE A 172      11.789  42.318 165.472  1.00 33.71           O  
ATOM   1346  CB  ILE A 172      11.164  41.232 168.612  1.00 33.58           C  
ATOM   1347  CG1 ILE A 172      10.181  41.445 169.766  1.00 33.65           C  
ATOM   1348  CG2 ILE A 172      12.312  42.223 168.750  1.00 33.07           C  
ATOM   1349  CD1 ILE A 172      10.765  41.081 171.109  1.00 36.13           C  
ATOM   1350  N   CYS A 173      11.986  40.106 165.825  1.00 33.79           N  
ATOM   1351  CA  CYS A 173      12.961  39.907 164.730  1.00 34.03           C  
ATOM   1352  C   CYS A 173      12.640  38.689 163.837  1.00 33.69           C  
ATOM   1353  O   CYS A 173      12.566  37.563 164.346  1.00 33.47           O  
ATOM   1354  CB  CYS A 173      14.354  39.741 165.332  1.00 34.21           C  
ATOM   1355  SG  CYS A 173      15.650  39.419 164.112  1.00 35.89           S  
ATOM   1356  N   PRO A 174      12.461  38.890 162.508  1.00 33.50           N  
ATOM   1357  CA  PRO A 174      12.504  40.124 161.706  1.00 33.78           C  
ATOM   1358  C   PRO A 174      11.485  41.186 162.099  1.00 33.77           C  
ATOM   1359  O   PRO A 174      11.663  42.347 161.745  1.00 33.85           O  
ATOM   1360  CB  PRO A 174      12.178  39.646 160.287  1.00 33.86           C  
ATOM   1361  CG  PRO A 174      12.511  38.208 160.275  1.00 34.14           C  
ATOM   1362  CD  PRO A 174      12.317  37.697 161.655  1.00 33.29           C  
ATOM   1363  N   GLY A 175      10.417  40.782 162.792  1.00 33.34           N  
ATOM   1364  CA  GLY A 175       9.422  41.713 163.308  1.00 33.21           C  
ATOM   1365  C   GLY A 175       8.117  41.629 162.541  1.00 33.08           C  
ATOM   1366  O   GLY A 175       8.110  41.335 161.342  1.00 33.11           O  
ATOM   1367  N   ALA A 176       7.015  41.907 163.236  1.00 32.74           N  
ATOM   1368  CA  ALA A 176       5.682  41.954 162.627  1.00 32.68           C  
ATOM   1369  C   ALA A 176       4.843  43.105 163.235  1.00 33.03           C  
ATOM   1370  O   ALA A 176       3.784  42.865 163.843  1.00 33.26           O  
ATOM   1371  CB  ALA A 176       4.983  40.609 162.814  1.00 32.77           C  
ATOM   1372  N   PRO A 177       5.309  44.363 163.054  1.00 33.15           N  
ATOM   1373  CA  PRO A 177       4.757  45.536 163.755  1.00 33.21           C  
ATOM   1374  C   PRO A 177       3.282  45.839 163.488  1.00 33.21           C  
ATOM   1375  O   PRO A 177       2.563  46.225 164.403  1.00 32.31           O  
ATOM   1376  CB  PRO A 177       5.627  46.699 163.250  1.00 33.32           C  
ATOM   1377  CG  PRO A 177       6.223  46.232 161.978  1.00 33.62           C  
ATOM   1378  CD  PRO A 177       6.371  44.742 162.099  1.00 32.99           C  
ATOM   1379  N   ASP A 178       2.837  45.664 162.250  1.00 33.34           N  
ATOM   1380  CA  ASP A 178       1.466  46.016 161.891  1.00 33.85           C  
ATOM   1381  C   ASP A 178       0.465  44.976 162.399  1.00 32.99           C  
ATOM   1382  O   ASP A 178      -0.698  45.307 162.687  1.00 32.83           O  
ATOM   1383  CB  ASP A 178       1.356  46.229 160.381  1.00 34.37           C  
ATOM   1384  CG  ASP A 178       2.361  47.264 159.873  1.00 37.41           C  
ATOM   1385  OD1 ASP A 178       2.578  48.315 160.558  1.00 38.96           O  
ATOM   1386  OD2 ASP A 178       2.963  47.001 158.804  1.00 41.78           O  
ATOM   1387  N   PHE A 179       0.923  43.728 162.498  1.00 31.91           N  
ATOM   1388  CA  PHE A 179       0.172  42.667 163.157  1.00 31.21           C  
ATOM   1389  C   PHE A 179       0.042  42.955 164.656  1.00 30.85           C  
ATOM   1390  O   PHE A 179      -1.067  42.891 165.213  1.00 30.42           O  
ATOM   1391  CB  PHE A 179       0.840  41.302 162.926  1.00 30.82           C  
ATOM   1392  CG  PHE A 179       0.304  40.216 163.796  1.00 30.71           C  
ATOM   1393  CD1 PHE A 179      -0.889  39.567 163.471  1.00 30.26           C  
ATOM   1394  CD2 PHE A 179       0.975  39.846 164.962  1.00 30.31           C  
ATOM   1395  CE1 PHE A 179      -1.395  38.564 164.289  1.00 29.93           C  
ATOM   1396  CE2 PHE A 179       0.463  38.852 165.792  1.00 29.86           C  
ATOM   1397  CZ  PHE A 179      -0.723  38.204 165.455  1.00 29.61           C  
ATOM   1398  N   LEU A 180       1.170  43.271 165.297  1.00 30.21           N  
ATOM   1399  CA  LEU A 180       1.180  43.593 166.716  1.00 30.40           C  
ATOM   1400  C   LEU A 180       0.285  44.772 167.038  1.00 30.67           C  
ATOM   1401  O   LEU A 180      -0.446  44.726 168.008  1.00 30.68           O  
ATOM   1402  CB  LEU A 180       2.583  43.922 167.225  1.00 30.73           C  
ATOM   1403  CG  LEU A 180       3.542  42.752 167.419  1.00 29.57           C  
ATOM   1404  CD1 LEU A 180       4.842  43.328 167.908  1.00 29.66           C  
ATOM   1405  CD2 LEU A 180       2.977  41.707 168.378  1.00 28.88           C  
ATOM   1406  N   ALA A 181       0.361  45.828 166.234  1.00 30.70           N  
ATOM   1407  CA  ALA A 181      -0.486  47.002 166.439  1.00 30.66           C  
ATOM   1408  C   ALA A 181      -1.966  46.648 166.333  1.00 30.74           C  
ATOM   1409  O   ALA A 181      -2.788  47.118 167.130  1.00 29.66           O  
ATOM   1410  CB  ALA A 181      -0.126  48.103 165.445  1.00 30.88           C  
ATOM   1411  N   HIS A 182      -2.308  45.804 165.357  1.00 31.22           N  
ATOM   1412  CA  HIS A 182      -3.696  45.452 165.146  1.00 31.45           C  
ATOM   1413  C   HIS A 182      -4.254  44.635 166.311  1.00 31.11           C  
ATOM   1414  O   HIS A 182      -5.309  44.959 166.829  1.00 30.89           O  
ATOM   1415  CB  HIS A 182      -3.901  44.691 163.846  1.00 32.23           C  
ATOM   1416  CG  HIS A 182      -5.292  44.165 163.694  1.00 34.10           C  
ATOM   1417  ND1 HIS A 182      -6.377  44.990 163.485  1.00 36.60           N  
ATOM   1418  CD2 HIS A 182      -5.782  42.904 163.768  1.00 35.71           C  
ATOM   1419  CE1 HIS A 182      -7.473  44.257 163.412  1.00 36.13           C  
ATOM   1420  NE2 HIS A 182      -7.140  42.989 163.581  1.00 35.48           N  
ATOM   1421  N   VAL A 183      -3.558  43.578 166.718  1.00 31.00           N  
ATOM   1422  CA  VAL A 183      -4.099  42.701 167.757  1.00 30.79           C  
ATOM   1423  C   VAL A 183      -4.011  43.371 169.126  1.00 30.78           C  
ATOM   1424  O   VAL A 183      -4.901  43.181 169.954  1.00 30.36           O  
ATOM   1425  CB  VAL A 183      -3.440  41.278 167.784  1.00 30.92           C  
ATOM   1426  CG1 VAL A 183      -3.670  40.542 166.461  1.00 30.57           C  
ATOM   1427  CG2 VAL A 183      -1.955  41.335 168.135  1.00 30.03           C  
ATOM   1428  N   ARG A 184      -2.950  44.151 169.361  1.00 30.92           N  
ATOM   1429  CA  ARG A 184      -2.783  44.843 170.650  1.00 31.59           C  
ATOM   1430  C   ARG A 184      -3.753  46.016 170.825  1.00 31.97           C  
ATOM   1431  O   ARG A 184      -4.258  46.246 171.919  1.00 32.02           O  
ATOM   1432  CB  ARG A 184      -1.352  45.325 170.865  1.00 31.60           C  
ATOM   1433  CG  ARG A 184      -0.370  44.187 171.099  1.00 31.35           C  
ATOM   1434  CD  ARG A 184       1.036  44.716 171.145  1.00 32.02           C  
ATOM   1435  NE  ARG A 184       2.032  43.683 171.458  1.00 32.40           N  
ATOM   1436  CZ  ARG A 184       3.336  43.928 171.555  1.00 31.57           C  
ATOM   1437  NH1 ARG A 184       3.795  45.153 171.385  1.00 30.88           N  
ATOM   1438  NH2 ARG A 184       4.188  42.951 171.822  1.00 31.10           N  
ATOM   1439  N   GLY A 185      -4.015  46.745 169.759  1.00 32.67           N  
ATOM   1440  CA  GLY A 185      -4.942  47.879 169.813  1.00 33.65           C  
ATOM   1441  C   GLY A 185      -6.414  47.485 169.786  1.00 34.34           C  
ATOM   1442  O   GLY A 185      -7.263  48.258 170.223  1.00 34.82           O  
ATOM   1443  N   SER A 186      -6.710  46.288 169.274  1.00 35.10           N  
ATOM   1444  CA  SER A 186      -8.083  45.850 169.027  1.00 35.64           C  
ATOM   1445  C   SER A 186      -8.748  45.265 170.253  1.00 36.42           C  
ATOM   1446  O   SER A 186      -8.138  44.480 170.993  1.00 36.67           O  
ATOM   1447  CB  SER A 186      -8.118  44.798 167.929  1.00 35.67           C  
ATOM   1448  OG  SER A 186      -9.374  44.148 167.898  1.00 35.28           O  
ATOM   1449  N   SER A 187     -10.016  45.621 170.445  1.00 37.20           N  
ATOM   1450  CA  SER A 187     -10.812  45.086 171.551  1.00 37.86           C  
ATOM   1451  C   SER A 187     -11.171  43.611 171.331  1.00 37.68           C  
ATOM   1452  O   SER A 187     -11.544  42.920 172.273  1.00 38.38           O  
ATOM   1453  CB  SER A 187     -12.085  45.917 171.739  1.00 38.00           C  
ATOM   1454  OG  SER A 187     -12.819  45.971 170.525  1.00 39.42           O  
ATOM   1455  N   CYS A 188     -11.023  43.134 170.095  1.00 37.23           N  
ATOM   1456  CA  CYS A 188     -11.308  41.742 169.755  1.00 37.16           C  
ATOM   1457  C   CYS A 188     -10.161  40.743 170.080  1.00 35.55           C  
ATOM   1458  O   CYS A 188     -10.302  39.560 169.809  1.00 35.47           O  
ATOM   1459  CB  CYS A 188     -11.704  41.644 168.274  1.00 37.16           C  
ATOM   1460  SG  CYS A 188     -13.277  42.523 167.841  1.00 42.69           S  
ATOM   1461  N   PHE A 189      -9.057  41.201 170.673  1.00 34.33           N  
ATOM   1462  CA  PHE A 189      -7.931  40.297 171.019  1.00 33.34           C  
ATOM   1463  C   PHE A 189      -7.354  40.578 172.394  1.00 32.81           C  
ATOM   1464  O   PHE A 189      -7.156  41.722 172.745  1.00 32.95           O  
ATOM   1465  CB  PHE A 189      -6.790  40.412 169.995  1.00 32.87           C  
ATOM   1466  CG  PHE A 189      -7.162  39.977 168.613  1.00 31.47           C  
ATOM   1467  CD1 PHE A 189      -7.002  38.653 168.219  1.00 31.20           C  
ATOM   1468  CD2 PHE A 189      -7.682  40.890 167.698  1.00 32.45           C  
ATOM   1469  CE1 PHE A 189      -7.348  38.241 166.938  1.00 30.57           C  
ATOM   1470  CE2 PHE A 189      -8.041  40.492 166.405  1.00 31.14           C  
ATOM   1471  CZ  PHE A 189      -7.868  39.155 166.026  1.00 30.50           C  
ATOM   1472  N   GLU A 190      -7.064  39.536 173.164  1.00 32.56           N  
ATOM   1473  CA  GLU A 190      -6.312  39.673 174.415  1.00 32.79           C  
ATOM   1474  C   GLU A 190      -4.891  39.165 174.180  1.00 32.10           C  
ATOM   1475  O   GLU A 190      -4.688  37.969 173.927  1.00 30.52           O  
ATOM   1476  CB  GLU A 190      -6.976  38.854 175.532  1.00 33.29           C  
ATOM   1477  CG  GLU A 190      -6.074  39.022 176.777  0.50 33.58           C  
ATOM   1479  CD  GLU A 190      -6.379  40.272 177.583  0.40 35.16           C  
ATOM   1481  OE1 GLU A 190      -7.368  40.979 177.277  0.40 35.38           O  
ATOM   1483  OE2 GLU A 190      -5.603  40.561 178.520  0.40 36.11           O  
ATOM   1485  N   CYS A 191      -3.913  40.064 174.274  1.00 31.63           N  
ATOM   1486  CA  CYS A 191      -2.531  39.719 173.905  1.00 32.19           C  
ATOM   1487  C   CYS A 191      -1.567  39.555 175.073  1.00 32.26           C  
ATOM   1488  O   CYS A 191      -1.632  40.304 176.056  1.00 32.03           O  
ATOM   1489  CB  CYS A 191      -1.956  40.758 172.951  1.00 31.93           C  
ATOM   1490  SG  CYS A 191      -2.961  41.023 171.507  1.00 32.94           S  
ATOM   1491  N   THR A 192      -0.649  38.598 174.917  1.00 32.47           N  
ATOM   1492  CA  THR A 192       0.493  38.398 175.821  1.00 32.41           C  
ATOM   1493  C   THR A 192       1.795  38.279 175.008  1.00 32.84           C  
ATOM   1494  O   THR A 192       1.852  37.541 174.024  1.00 32.41           O  
ATOM   1495  CB  THR A 192       0.312  37.130 176.663  1.00 32.25           C  
ATOM   1496  OG1 THR A 192      -0.972  37.162 177.290  1.00 33.38           O  
ATOM   1497  CG2 THR A 192       1.407  37.005 177.742  1.00 31.86           C  
ATOM   1498  N   HIS A 193       2.837  39.006 175.411  1.00 33.17           N  
ATOM   1499  CA  HIS A 193       4.130  38.916 174.720  1.00 33.85           C  
ATOM   1500  C   HIS A 193       5.069  37.972 175.464  1.00 33.63           C  
ATOM   1501  O   HIS A 193       5.141  38.016 176.674  1.00 33.97           O  
ATOM   1502  CB  HIS A 193       4.774  40.303 174.566  1.00 33.95           C  
ATOM   1503  CG  HIS A 193       6.049  40.284 173.777  1.00 34.31           C  
ATOM   1504  ND1 HIS A 193       6.071  40.283 172.401  1.00 35.58           N  
ATOM   1505  CD2 HIS A 193       7.345  40.236 174.174  1.00 34.59           C  
ATOM   1506  CE1 HIS A 193       7.325  40.256 171.982  1.00 35.63           C  
ATOM   1507  NE2 HIS A 193       8.117  40.221 173.037  1.00 34.55           N  
ATOM   1508  N   TYR A 194       5.771  37.109 174.736  1.00 34.34           N  
ATOM   1509  CA  TYR A 194       6.797  36.237 175.326  1.00 34.78           C  
ATOM   1510  C   TYR A 194       8.156  36.548 174.714  1.00 34.96           C  
ATOM   1511  O   TYR A 194       8.437  36.147 173.584  1.00 34.42           O  
ATOM   1512  CB  TYR A 194       6.470  34.768 175.081  1.00 35.06           C  
ATOM   1513  CG  TYR A 194       5.183  34.318 175.714  1.00 36.75           C  
ATOM   1514  CD1 TYR A 194       4.016  34.199 174.966  1.00 37.16           C  
ATOM   1515  CD2 TYR A 194       5.130  34.023 177.071  1.00 39.84           C  
ATOM   1516  CE1 TYR A 194       2.831  33.782 175.546  1.00 39.38           C  
ATOM   1517  CE2 TYR A 194       3.943  33.613 177.670  1.00 41.48           C  
ATOM   1518  CZ  TYR A 194       2.795  33.494 176.903  1.00 41.21           C  
ATOM   1519  OH  TYR A 194       1.615  33.090 177.500  1.00 44.22           O  
ATOM   1520  N   GLN A 195       9.000  37.257 175.460  1.00 34.78           N  
ATOM   1521  CA  GLN A 195      10.334  37.577 174.990  1.00 34.78           C  
ATOM   1522  C   GLN A 195      11.219  36.339 175.044  1.00 34.02           C  
ATOM   1523  O   GLN A 195      11.129  35.530 175.957  1.00 34.17           O  
ATOM   1524  CB  GLN A 195      10.955  38.723 175.801  1.00 35.26           C  
ATOM   1525  CG  GLN A 195      12.380  39.057 175.352  1.00 37.52           C  
ATOM   1526  CD  GLN A 195      12.925  40.366 175.919  1.00 40.41           C  
ATOM   1527  OE1 GLN A 195      12.209  41.362 176.027  1.00 41.39           O  
ATOM   1528  NE2 GLN A 195      14.215  40.369 176.258  1.00 41.86           N  
ATOM   1529  N   SER A 196      12.077  36.189 174.051  1.00 32.91           N  
ATOM   1530  CA  SER A 196      12.958  35.037 174.000  1.00 32.49           C  
ATOM   1531  C   SER A 196      14.138  35.413 173.120  1.00 31.44           C  
ATOM   1532  O   SER A 196      14.574  36.556 173.152  1.00 30.73           O  
ATOM   1533  CB  SER A 196      12.194  33.820 173.460  1.00 32.35           C  
ATOM   1534  OG  SER A 196      12.986  32.655 173.458  1.00 32.16           O  
ATOM   1535  N   PHE A 197      14.632  34.463 172.335  1.00 30.56           N  
ATOM   1536  CA  PHE A 197      15.784  34.689 171.468  1.00 30.25           C  
ATOM   1537  C   PHE A 197      15.515  34.150 170.063  1.00 29.67           C  
ATOM   1538  O   PHE A 197      14.733  33.202 169.880  1.00 28.74           O  
ATOM   1539  CB  PHE A 197      17.020  34.014 172.071  1.00 30.25           C  
ATOM   1540  CG  PHE A 197      17.476  34.627 173.380  1.00 31.50           C  
ATOM   1541  CD1 PHE A 197      17.115  34.059 174.598  1.00 34.44           C  
ATOM   1542  CD2 PHE A 197      18.242  35.782 173.391  1.00 32.73           C  
ATOM   1543  CE1 PHE A 197      17.532  34.630 175.832  1.00 34.26           C  
ATOM   1544  CE2 PHE A 197      18.670  36.364 174.607  1.00 34.27           C  
ATOM   1545  CZ  PHE A 197      18.315  35.786 175.827  1.00 34.29           C  
ATOM   1546  N   LEU A 198      16.141  34.770 169.069  1.00 28.67           N  
ATOM   1547  CA  LEU A 198      16.111  34.238 167.724  1.00 28.66           C  
ATOM   1548  C   LEU A 198      16.722  32.838 167.745  1.00 28.43           C  
ATOM   1549  O   LEU A 198      17.713  32.592 168.445  1.00 28.72           O  
ATOM   1550  CB  LEU A 198      16.875  35.133 166.751  1.00 28.52           C  
ATOM   1551  CG  LEU A 198      16.673  34.863 165.250  1.00 29.25           C  
ATOM   1552  CD1 LEU A 198      15.329  35.366 164.782  1.00 28.99           C  
ATOM   1553  CD2 LEU A 198      17.794  35.497 164.409  1.00 29.57           C  
ATOM   1554  N   GLU A 199      16.112  31.930 166.997  1.00 28.10           N  
ATOM   1555  CA  GLU A 199      16.562  30.544 166.932  1.00 27.76           C  
ATOM   1556  C   GLU A 199      18.065  30.463 166.693  1.00 28.10           C  
ATOM   1557  O   GLU A 199      18.590  31.093 165.766  1.00 28.69           O  
ATOM   1558  CB  GLU A 199      15.814  29.767 165.840  1.00 27.85           C  
ATOM   1559  CG  GLU A 199      15.799  30.426 164.440  1.00 26.84           C  
ATOM   1560  CD  GLU A 199      14.511  31.138 164.107  1.00 26.09           C  
ATOM   1561  OE1 GLU A 199      13.899  31.724 165.021  1.00 28.32           O  
ATOM   1562  OE2 GLU A 199      14.097  31.124 162.926  1.00 24.30           O  
ATOM   1563  N   TYR A 200      18.742  29.709 167.560  1.00 28.11           N  
ATOM   1564  CA  TYR A 200      20.171  29.387 167.449  1.00 28.61           C  
ATOM   1565  C   TYR A 200      21.088  30.595 167.686  1.00 28.83           C  
ATOM   1566  O   TYR A 200      22.293  30.523 167.470  1.00 28.93           O  
ATOM   1567  CB  TYR A 200      20.472  28.684 166.108  1.00 28.62           C  
ATOM   1568  CG  TYR A 200      19.430  27.627 165.748  1.00 28.58           C  
ATOM   1569  CD1 TYR A 200      19.191  26.548 166.595  1.00 30.45           C  
ATOM   1570  CD2 TYR A 200      18.668  27.725 164.595  1.00 28.19           C  
ATOM   1571  CE1 TYR A 200      18.232  25.583 166.297  1.00 29.85           C  
ATOM   1572  CE2 TYR A 200      17.706  26.765 164.279  1.00 27.16           C  
ATOM   1573  CZ  TYR A 200      17.487  25.704 165.133  1.00 29.67           C  
ATOM   1574  OH  TYR A 200      16.536  24.760 164.821  1.00 29.52           O  
ATOM   1575  N   ARG A 201      20.518  31.696 168.150  1.00 29.16           N  
ATOM   1576  CA  ARG A 201      21.258  32.944 168.280  1.00 29.62           C  
ATOM   1577  C   ARG A 201      20.917  33.661 169.588  1.00 30.26           C  
ATOM   1578  O   ARG A 201      20.042  33.235 170.345  1.00 30.24           O  
ATOM   1579  CB  ARG A 201      20.973  33.865 167.087  1.00 29.43           C  
ATOM   1580  CG  ARG A 201      21.428  33.337 165.744  1.00 29.39           C  
ATOM   1581  CD  ARG A 201      22.947  33.368 165.604  1.00 29.55           C  
ATOM   1582  NE  ARG A 201      23.382  32.878 164.296  1.00 28.40           N  
ATOM   1583  CZ  ARG A 201      23.728  31.619 164.030  1.00 31.38           C  
ATOM   1584  NH1 ARG A 201      23.679  30.677 164.963  1.00 31.73           N  
ATOM   1585  NH2 ARG A 201      24.112  31.292 162.809  1.00 32.34           N  
ATOM   1586  N   GLU A 202      21.633  34.748 169.845  1.00 31.16           N  
ATOM   1587  CA  GLU A 202      21.425  35.545 171.041  1.00 32.28           C  
ATOM   1588  C   GLU A 202      20.726  36.866 170.711  1.00 32.00           C  
ATOM   1589  O   GLU A 202      20.406  37.657 171.599  1.00 32.94           O  
ATOM   1590  CB  GLU A 202      22.769  35.717 171.757  1.00 33.12           C  
ATOM   1591  CG  GLU A 202      23.320  34.388 172.297  0.50 33.59           C  
ATOM   1593  CD  GLU A 202      24.805  34.432 172.640  0.50 35.27           C  
ATOM   1595  OE1 GLU A 202      25.642  34.177 171.740  0.50 36.64           O  
ATOM   1597  OE2 GLU A 202      25.142  34.700 173.809  0.50 35.19           O  
ATOM   1599  N   VAL A 203      20.459  37.090 169.429  1.00 31.56           N  
ATOM   1600  CA  VAL A 203      19.567  38.157 169.003  1.00 31.13           C  
ATOM   1601  C   VAL A 203      18.232  37.950 169.715  1.00 31.53           C  
ATOM   1602  O   VAL A 203      17.715  36.828 169.758  1.00 31.72           O  
ATOM   1603  CB  VAL A 203      19.352  38.131 167.472  1.00 30.77           C  
ATOM   1604  CG1 VAL A 203      18.353  39.218 167.025  1.00 29.64           C  
ATOM   1605  CG2 VAL A 203      20.695  38.271 166.731  1.00 30.54           C  
ATOM   1606  N   VAL A 204      17.696  39.018 170.298  1.00 31.77           N  
ATOM   1607  CA  VAL A 204      16.414  38.937 171.005  1.00 31.54           C  
ATOM   1608  C   VAL A 204      15.294  38.849 169.972  1.00 31.26           C  
ATOM   1609  O   VAL A 204      15.344  39.483 168.916  1.00 31.14           O  
ATOM   1610  CB  VAL A 204      16.197  40.120 172.011  1.00 31.76           C  
ATOM   1611  CG1 VAL A 204      14.703  40.330 172.339  1.00 31.55           C  
ATOM   1612  CG2 VAL A 204      16.982  39.872 173.306  1.00 31.97           C  
ATOM   1613  N   ASP A 205      14.330  37.982 170.265  1.00 30.94           N  
ATOM   1614  CA  ASP A 205      13.092  37.886 169.516  1.00 30.60           C  
ATOM   1615  C   ASP A 205      11.952  37.683 170.523  1.00 30.59           C  
ATOM   1616  O   ASP A 205      12.169  37.747 171.734  1.00 30.93           O  
ATOM   1617  CB  ASP A 205      13.169  36.728 168.525  1.00 30.26           C  
ATOM   1618  CG  ASP A 205      12.125  36.810 167.444  1.00 30.16           C  
ATOM   1619  OD1 ASP A 205      11.441  37.868 167.323  1.00 29.07           O  
ATOM   1620  OD2 ASP A 205      11.955  35.794 166.739  1.00 29.82           O  
ATOM   1621  N   GLY A 206      10.743  37.489 170.019  1.00 29.87           N  
ATOM   1622  CA  GLY A 206       9.611  37.127 170.840  1.00 29.40           C  
ATOM   1623  C   GLY A 206       8.456  36.587 170.023  1.00 28.90           C  
ATOM   1624  O   GLY A 206       8.447  36.694 168.798  1.00 28.56           O  
ATOM   1625  N   LEU A 207       7.501  35.987 170.724  1.00 28.56           N  
ATOM   1626  CA  LEU A 207       6.248  35.550 170.148  1.00 28.41           C  
ATOM   1627  C   LEU A 207       5.112  36.364 170.729  1.00 28.60           C  
ATOM   1628  O   LEU A 207       5.215  36.891 171.841  1.00 29.17           O  
ATOM   1629  CB  LEU A 207       5.997  34.067 170.423  1.00 28.16           C  
ATOM   1630  CG  LEU A 207       7.053  33.103 169.874  1.00 27.32           C  
ATOM   1631  CD1 LEU A 207       8.082  32.712 170.945  1.00 25.44           C  
ATOM   1632  CD2 LEU A 207       6.385  31.852 169.281  1.00 27.77           C  
ATOM   1633  N   GLU A 208       4.027  36.472 169.975  1.00 28.41           N  
ATOM   1634  CA  GLU A 208       2.821  37.122 170.474  1.00 28.56           C  
ATOM   1635  C   GLU A 208       1.676  36.117 170.536  1.00 28.40           C  
ATOM   1636  O   GLU A 208       1.406  35.406 169.563  1.00 27.51           O  
ATOM   1637  CB  GLU A 208       2.443  38.303 169.599  1.00 28.18           C  
ATOM   1638  CG  GLU A 208       1.499  39.293 170.265  1.00 28.42           C  
ATOM   1639  CD  GLU A 208       2.167  40.145 171.359  1.00 29.66           C  
ATOM   1640  OE1 GLU A 208       3.419  40.122 171.501  1.00 29.20           O  
ATOM   1641  OE2 GLU A 208       1.420  40.832 172.073  1.00 26.88           O  
ATOM   1642  N   LYS A 209       1.040  36.032 171.702  1.00 28.58           N  
ATOM   1643  CA  LYS A 209      -0.180  35.235 171.865  1.00 28.67           C  
ATOM   1644  C   LYS A 209      -1.363  36.189 171.858  1.00 28.51           C  
ATOM   1645  O   LYS A 209      -1.440  37.087 172.683  1.00 27.43           O  
ATOM   1646  CB  LYS A 209      -0.140  34.412 173.154  1.00 28.88           C  
ATOM   1647  CG  LYS A 209      -1.336  33.435 173.298  1.00 29.81           C  
ATOM   1648  CD  LYS A 209      -1.295  32.609 174.559  1.00 31.23           C  
ATOM   1649  CE  LYS A 209      -1.485  33.457 175.809  1.00 34.56           C  
ATOM   1650  NZ  LYS A 209      -1.053  32.709 177.014  1.00 36.27           N  
ATOM   1651  N   ALA A 210      -2.239  36.040 170.869  1.00 29.03           N  
ATOM   1652  CA  ALA A 210      -3.399  36.909 170.716  1.00 29.48           C  
ATOM   1653  C   ALA A 210      -4.669  36.063 170.768  1.00 30.54           C  
ATOM   1654  O   ALA A 210      -4.967  35.325 169.830  1.00 30.53           O  
ATOM   1655  CB  ALA A 210      -3.316  37.690 169.407  1.00 29.12           C  
ATOM   1656  N   ILE A 211      -5.403  36.150 171.876  1.00 31.59           N  
ATOM   1657  CA  ILE A 211      -6.624  35.352 172.028  1.00 32.72           C  
ATOM   1658  C   ILE A 211      -7.815  36.155 171.510  1.00 33.81           C  
ATOM   1659  O   ILE A 211      -8.082  37.264 171.982  1.00 33.60           O  
ATOM   1660  CB  ILE A 211      -6.840  34.869 173.497  1.00 32.90           C  
ATOM   1661  CG1 ILE A 211      -5.610  34.092 173.998  1.00 32.78           C  
ATOM   1662  CG2 ILE A 211      -8.098  33.979 173.606  1.00 31.99           C  
ATOM   1663  CD1 ILE A 211      -5.685  33.678 175.482  1.00 33.87           C  
ATOM   1664  N   TYR A 212      -8.508  35.608 170.514  1.00 35.37           N  
ATOM   1665  CA  TYR A 212      -9.697  36.253 169.969  1.00 37.08           C  
ATOM   1666  C   TYR A 212     -10.834  36.258 171.004  1.00 39.06           C  
ATOM   1667  O   TYR A 212     -11.158  35.228 171.596  1.00 38.46           O  
ATOM   1668  CB  TYR A 212     -10.136  35.545 168.685  1.00 37.18           C  
ATOM   1669  CG  TYR A 212     -11.174  36.273 167.870  1.00 36.64           C  
ATOM   1670  CD1 TYR A 212     -10.920  37.526 167.331  1.00 37.05           C  
ATOM   1671  CD2 TYR A 212     -12.405  35.694 167.611  1.00 38.20           C  
ATOM   1672  CE1 TYR A 212     -11.879  38.186 166.573  1.00 36.97           C  
ATOM   1673  CE2 TYR A 212     -13.357  36.334 166.846  1.00 38.23           C  
ATOM   1674  CZ  TYR A 212     -13.092  37.577 166.329  1.00 37.95           C  
ATOM   1675  OH  TYR A 212     -14.064  38.202 165.576  1.00 40.80           O  
ATOM   1676  N   LYS A 213     -11.425  37.431 171.211  1.00 41.97           N  
ATOM   1677  CA  LYS A 213     -12.471  37.621 172.212  1.00 44.61           C  
ATOM   1678  C   LYS A 213     -13.873  37.643 171.599  1.00 46.67           C  
ATOM   1679  O   LYS A 213     -14.869  37.740 172.321  1.00 47.31           O  
ATOM   1680  CB  LYS A 213     -12.210  38.911 172.984  1.00 44.97           C  
ATOM   1681  CG  LYS A 213     -10.998  38.830 173.902  1.00 46.35           C  
ATOM   1682  CD  LYS A 213     -10.509  40.206 174.326  1.00 48.74           C  
ATOM   1683  CE  LYS A 213     -11.410  40.864 175.370  1.00 49.68           C  
ATOM   1684  NZ  LYS A 213     -11.057  42.307 175.527  1.00 49.23           N  
ATOM   1685  N   GLY A 214     -13.949  37.528 170.276  1.00 48.83           N  
ATOM   1686  CA  GLY A 214     -15.222  37.538 169.572  1.00 50.57           C  
ATOM   1687  C   GLY A 214     -15.357  38.849 168.828  1.00 52.13           C  
ATOM   1688  O   GLY A 214     -14.557  39.770 169.048  1.00 53.08           O  
ATOM   1689  N   PRO A 215     -16.366  38.950 167.939  1.00 53.56           N  
ATOM   1690  CA  PRO A 215     -16.522  40.132 167.079  1.00 54.12           C  
ATOM   1691  C   PRO A 215     -17.172  41.324 167.792  1.00 54.67           C  
ATOM   1692  O   PRO A 215     -18.402  41.453 167.803  1.00 55.60           O  
ATOM   1693  CB  PRO A 215     -17.394  39.613 165.932  1.00 54.32           C  
ATOM   1694  CG  PRO A 215     -18.223  38.521 166.563  1.00 54.26           C  
ATOM   1695  CD  PRO A 215     -17.367  37.903 167.642  1.00 53.73           C  
TER    1696      PRO A 215                                                      
END
MOLECULE T0509.pdb
ATOM      1  N   ASN     3      22.807  39.978 177.332  1.00 85.83           N  
ATOM      2  CA  ASN     3      23.661  39.212 178.288  1.00 85.41           C  
ATOM      3  C   ASN     3      22.931  38.088 179.010  1.00 84.96           C  
ATOM      4  O   ASN     3      23.158  36.907 178.737  1.00 84.71           O  
ATOM      5  CB  ASN     3      24.283  40.169 179.320  1.00 85.60           C  
ATOM      6  N   ALA     4      22.046  38.464 179.926  1.00 84.06           N  
ATOM      7  CA  ALA     4      21.329  37.491 180.736  1.00 83.06           C  
ATOM      8  C   ALA     4      20.380  36.562 180.006  1.00 82.36           C  
ATOM      9  O   ALA     4      20.103  35.452 180.462  1.00 82.26           O  
ATOM     10  CB  ALA     4      20.607  38.203 181.891  1.00 82.85           C  
ATOM     11  N   PHE     5      19.905  37.014 178.857  1.00 81.23           N  
ATOM     12  CA  PHE     5      19.008  36.219 178.041  1.00 79.90           C  
ATOM     13  C   PHE     5      19.689  34.923 177.583  1.00 78.36           C  
ATOM     14  O   PHE     5      19.070  33.859 177.581  1.00 77.95           O  
ATOM     15  CB  PHE     5      18.590  37.011 176.806  1.00 80.49           C  
ATOM     16  CG  PHE     5      17.733  36.228 175.838  1.00 82.32           C  
ATOM     17  CD1 PHE     5      16.356  36.140 176.022  1.00 83.80           C  
ATOM     18  CD2 PHE     5      18.306  35.556 174.759  1.00 83.29           C  
ATOM     19  CE1 PHE     5      15.564  35.398 175.148  1.00 85.48           C  
ATOM     20  CE2 PHE     5      17.522  34.810 173.883  1.00 84.01           C  
ATOM     21  CZ  PHE     5      16.149  34.731 174.079  1.00 84.46           C  
ATOM     22  N   GLU     6      20.960  35.016 177.195  1.00 77.13           N  
ATOM     23  CA  GLU     6      21.696  33.867 176.675  1.00 75.49           C  
ATOM     24  C   GLU     6      22.150  32.844 177.700  1.00 73.34           C  
ATOM     25  O   GLU     6      22.237  31.656 177.384  1.00 73.19           O  
ATOM     26  CB  GLU     6      22.890  34.355 175.852  1.00 76.28           C  
ATOM     27  CG  GLU     6      22.530  35.380 174.776  1.00 80.27           C  
ATOM     28  CD  GLU     6      23.464  36.574 174.805  1.00 85.77           C  
ATOM     29  OE1 GLU     6      23.350  37.389 175.746  1.00 88.31           O  
ATOM     30  OE2 GLU     6      24.317  36.691 173.899  1.00 86.53           O  
ATOM     31  N   TYR     7      22.433  33.303 178.915  1.00 71.13           N  
ATOM     32  CA  TYR     7      22.835  32.402 179.977  1.00 68.99           C  
ATOM     33  C   TYR     7      21.579  31.589 180.326  1.00 65.55           C  
ATOM     34  O   TYR     7      21.657  30.395 180.624  1.00 65.44           O  
ATOM     35  CB  TYR     7      23.336  33.190 181.196  1.00 70.74           C  
ATOM     36  CG  TYR     7      24.578  32.584 181.806  1.00 76.24           C  
ATOM     37  CD1 TYR     7      25.455  33.360 182.555  1.00 82.00           C  
ATOM     38  CD2 TYR     7      24.886  31.230 181.618  1.00 81.17           C  
ATOM     39  CE1 TYR     7      26.612  32.812 183.107  1.00 85.04           C  
ATOM     40  CE2 TYR     7      26.039  30.671 182.169  1.00 84.74           C  
ATOM     41  CZ  TYR     7      26.897  31.469 182.910  1.00 86.92           C  
ATOM     42  OH  TYR     7      28.037  30.923 183.455  1.00 89.05           O  
ATOM     43  N   LEU     8      20.416  32.239 180.292  1.00 61.60           N  
ATOM     44  CA  LEU     8      19.157  31.545 180.549  1.00 57.37           C  
ATOM     45  C   LEU     8      18.973  30.589 179.350  1.00 54.56           C  
ATOM     46  O   LEU     8      18.710  29.399 179.527  1.00 52.14           O  
ATOM     47  CB  LEU     8      17.989  32.541 180.606  1.00 57.65           C  
ATOM     48  CG  LEU     8      16.729  32.079 181.345  1.00 56.45           C  
ATOM     49  CD1 LEU     8      17.110  31.130 182.479  1.00 55.09           C  
ATOM     50  CD2 LEU     8      15.999  33.299 181.898  1.00 57.98           C  
ATOM     51  N   ARG     9      19.120  31.107 178.129  1.00 52.49           N  
ATOM     52  CA  ARG     9      18.958  30.280 176.932  1.00 52.08           C  
ATOM     53  C   ARG     9      19.926  29.104 176.942  1.00 51.11           C  
ATOM     54  O   ARG     9      19.532  27.959 176.699  1.00 50.55           O  
ATOM     55  CB  ARG     9      19.141  31.125 175.658  1.00 52.07           C  
ATOM     56  CG  ARG     9      19.009  30.335 174.364  1.00 54.77           C  
ATOM     57  CD  ARG     9      18.455  31.194 173.237  1.00 60.14           C  
ATOM     58  NE  ARG     9      19.283  32.362 172.952  1.00 64.34           N  
ATOM     59  CZ  ARG     9      20.451  32.322 172.316  1.00 68.63           C  
ATOM     60  NH1 ARG     9      20.939  31.164 171.888  1.00 69.94           N  
ATOM     61  NH2 ARG     9      21.131  33.441 172.107  1.00 68.03           N  
ATOM     62  N   THR    10      21.189  29.388 177.240  1.00 50.60           N  
ATOM     63  CA  THR    10      22.217  28.357 177.275  1.00 50.83           C  
ATOM     64  C   THR    10      21.903  27.262 178.291  1.00 49.87           C  
ATOM     65  O   THR    10      22.003  26.074 177.983  1.00 50.46           O  
ATOM     66  CB  THR    10      23.603  28.971 177.581  1.00 51.38           C  
ATOM     67  OG1 THR    10      23.896  29.986 176.608  1.00 51.78           O  
ATOM     68  CG2 THR    10      24.680  27.904 177.521  1.00 50.61           C  
ATOM     69  N   TYR    11      21.521  27.657 179.499  1.00 48.77           N  
ATOM     70  CA  TYR    11      21.185  26.675 180.524  1.00 48.46           C  
ATOM     71  C   TYR    11      19.954  25.857 180.130  1.00 46.71           C  
ATOM     72  O   TYR    11      19.919  24.643 180.332  1.00 46.43           O  
ATOM     73  CB  TYR    11      20.893  27.339 181.860  1.00 50.01           C  
ATOM     74  CG  TYR    11      20.510  26.319 182.902  1.00 52.08           C  
ATOM     75  CD1 TYR    11      21.471  25.474 183.449  1.00 54.43           C  
ATOM     76  CD2 TYR    11      19.173  26.115 183.256  1.00 52.57           C  
ATOM     77  CE1 TYR    11      21.121  24.459 184.331  1.00 56.00           C  
ATOM     78  CE2 TYR    11      18.812  25.101 184.141  1.00 56.55           C  
ATOM     79  CZ  TYR    11      19.795  24.275 184.668  1.00 55.82           C  
ATOM     80  OH  TYR    11      19.458  23.278 185.549  1.00 57.24           O  
ATOM     81  N   VAL    12      18.942  26.515 179.570  1.00 45.29           N  
ATOM     82  CA  VAL    12      17.728  25.810 179.173  1.00 43.79           C  
ATOM     83  C   VAL    12      17.970  24.915 177.964  1.00 44.31           C  
ATOM     84  O   VAL    12      17.489  23.784 177.919  1.00 44.59           O  
ATOM     85  CB  VAL    12      16.575  26.796 178.864  1.00 44.09           C  
ATOM     86  CG1 VAL    12      15.364  26.044 178.307  1.00 38.90           C  
ATOM     87  CG2 VAL    12      16.187  27.557 180.138  1.00 40.82           C  
ATOM     88  N   GLU    13      18.706  25.418 176.982  1.00 45.77           N  
ATOM     89  CA  GLU    13      18.991  24.621 175.801  1.00 47.52           C  
ATOM     90  C   GLU    13      19.917  23.460 176.170  1.00 48.95           C  
ATOM     91  O   GLU    13      19.657  22.312 175.826  1.00 49.14           O  
ATOM     92  CB  GLU    13      19.621  25.491 174.701  1.00 47.27           C  
ATOM     93  CG  GLU    13      18.594  26.143 173.776  1.00 46.73           C  
ATOM     94  CD  GLU    13      19.213  27.051 172.733  1.00 47.14           C  
ATOM     95  OE1 GLU    13      18.462  27.802 172.070  1.00 46.58           O  
ATOM     96  OE2 GLU    13      20.451  27.011 172.568  1.00 48.58           O  
ATOM     97  N   SER    14      20.991  23.759 176.893  1.00 50.77           N  
ATOM     98  CA  SER    14      21.962  22.741 177.291  1.00 52.40           C  
ATOM     99  C   SER    14      21.408  21.764 178.315  1.00 52.24           C  
ATOM    100  O   SER    14      22.111  20.838 178.732  1.00 52.54           O  
ATOM    101  CB  SER    14      23.201  23.405 177.884  1.00 53.25           C  
ATOM    102  OG  SER    14      22.943  23.882 179.203  1.00 55.29           O  
ATOM    103  N   THR    15      20.152  21.956 178.709  1.00 51.44           N  
ATOM    104  CA  THR    15      19.565  21.104 179.726  1.00 50.00           C  
ATOM    105  C   THR    15      18.254  20.425 179.338  1.00 49.00           C  
ATOM    106  O   THR    15      17.740  19.581 180.077  1.00 48.09           O  
ATOM    107  CB  THR    15      19.421  21.928 181.040  1.00 50.48           C  
ATOM    108  OG1 THR    15      19.790  21.124 182.163  1.00 53.93           O  
ATOM    109  CG2 THR    15      18.042  22.429 181.224  1.00 49.25           C  
ATOM    110  N   THR    16      17.709  20.805 178.186  1.00 47.75           N  
ATOM    111  CA  THR    16      16.482  20.191 177.693  1.00 48.20           C  
ATOM    112  C   THR    16      16.843  18.834 177.065  1.00 50.22           C  
ATOM    113  O   THR    16      17.668  18.759 176.143  1.00 52.31           O  
ATOM    114  CB  THR    16      15.795  21.062 176.622  1.00 46.53           C  
ATOM    115  OG1 THR    16      15.318  22.271 177.220  1.00 45.88           O  
ATOM    116  CG2 THR    16      14.625  20.317 175.997  1.00 42.52           C  
ATOM    117  N   GLU    17      16.228  17.764 177.563  1.00 51.38           N  
ATOM    118  CA  GLU    17      16.493  16.421 177.062  1.00 53.69           C  
ATOM    119  C   GLU    17      16.282  16.387 175.556  1.00 54.77           C  
ATOM    120  O   GLU    17      15.184  16.632 175.051  1.00 53.95           O  
ATOM    121  CB  GLU    17      15.569  15.413 177.748  1.00 54.69           C  
ATOM    122  CG  GLU    17      15.799  13.980 177.324  1.00 57.95           C  
ATOM    123  CD  GLU    17      14.636  13.081 177.692  1.00 63.33           C  
ATOM    124  OE1 GLU    17      14.500  12.002 177.075  1.00 66.36           O  
ATOM    125  OE2 GLU    17      13.861  13.451 178.601  1.00 65.09           O  
ATOM    126  N   THR    18      17.345  16.068 174.836  1.00 56.14           N  
ATOM    127  CA  THR    18      17.289  16.046 173.385  1.00 57.87           C  
ATOM    128  C   THR    18      16.318  15.040 172.775  1.00 57.45           C  
ATOM    129  O   THR    18      16.215  13.904 173.238  1.00 57.97           O  
ATOM    130  CB  THR    18      18.709  15.817 172.779  1.00 58.68           C  
ATOM    131  OG1 THR    18      19.251  14.577 173.255  1.00 60.50           O  
ATOM    132  CG2 THR    18      19.660  16.960 173.166  1.00 57.87           C  
ATOM    133  N   ASP    19      15.587  15.481 171.752  1.00 56.51           N  
ATOM    134  CA  ASP    19      14.670  14.600 171.041  1.00 56.34           C  
ATOM    135  C   ASP    19      15.294  14.421 169.648  1.00 55.42           C  
ATOM    136  O   ASP    19      15.637  15.401 168.973  1.00 56.44           O  
ATOM    137  CB  ASP    19      13.263  15.210 170.904  1.00 55.60           C  
ATOM    138  CG  ASP    19      12.348  14.348 170.050  1.00 57.72           C  
ATOM    139  OD1 ASP    19      12.857  13.661 169.136  1.00 62.68           O  
ATOM    140  OD2 ASP    19      11.122  14.363 170.272  1.00 59.68           O  
ATOM    141  N   ALA    20      15.442  13.171 169.218  1.00 53.78           N  
ATOM    142  CA  ALA    20      16.054  12.863 167.926  1.00 51.44           C  
ATOM    143  C   ALA    20      15.281  13.437 166.750  1.00 49.39           C  
ATOM    144  O   ALA    20      15.857  14.097 165.881  1.00 47.69           O  
ATOM    145  CB  ALA    20      16.208  11.346 167.765  1.00 51.74           C  
ATOM    146  N   ALA    21      13.978  13.189 166.728  1.00 46.99           N  
ATOM    147  CA  ALA    21      13.140  13.693 165.655  1.00 44.89           C  
ATOM    148  C   ALA    21      13.208  15.221 165.610  1.00 43.57           C  
ATOM    149  O   ALA    21      13.247  15.812 164.534  1.00 43.64           O  
ATOM    150  CB  ALA    21      11.692  13.224 165.853  1.00 44.67           C  
ATOM    151  N   VAL    22      13.229  15.860 166.779  1.00 41.64           N  
ATOM    152  CA  VAL    22      13.292  17.319 166.849  1.00 39.09           C  
ATOM    153  C   VAL    22      14.655  17.846 166.414  1.00 38.15           C  
ATOM    154  O   VAL    22      14.745  18.838 165.688  1.00 36.18           O  
ATOM    155  CB  VAL    22      12.990  17.834 168.282  1.00 38.83           C  
ATOM    156  CG1 VAL    22      13.345  19.328 168.388  1.00 37.70           C  
ATOM    157  CG2 VAL    22      11.520  17.610 168.622  1.00 36.88           C  
ATOM    158  N   ALA    23      15.719  17.184 166.860  1.00 38.78           N  
ATOM    159  CA  ALA    23      17.070  17.602 166.500  1.00 39.37           C  
ATOM    160  C   ALA    23      17.260  17.469 164.984  1.00 38.28           C  
ATOM    161  O   ALA    23      17.908  18.299 164.359  1.00 37.20           O  
ATOM    162  CB  ALA    23      18.100  16.748 167.239  1.00 39.71           C  
ATOM    163  N   ARG    24      16.692  16.419 164.402  1.00 39.08           N  
ATOM    164  CA  ARG    24      16.800  16.188 162.969  1.00 40.86           C  
ATOM    165  C   ARG    24      16.093  17.324 162.217  1.00 40.75           C  
ATOM    166  O   ARG    24      16.635  17.874 161.249  1.00 40.53           O  
ATOM    167  CB  ARG    24      16.183  14.820 162.628  1.00 41.74           C  
ATOM    168  CG  ARG    24      16.075  14.501 161.150  1.00 49.23           C  
ATOM    169  CD  ARG    24      17.421  14.551 160.446  1.00 54.35           C  
ATOM    170  NE  ARG    24      17.462  13.599 159.339  1.00 59.94           N  
ATOM    171  CZ  ARG    24      18.095  13.812 158.194  1.00 59.09           C  
ATOM    172  NH1 ARG    24      18.742  14.952 158.002  1.00 62.71           N  
ATOM    173  NH2 ARG    24      18.073  12.890 157.241  1.00 60.22           N  
ATOM    174  N   ALA    25      14.891  17.680 162.668  1.00 40.03           N  
ATOM    175  CA  ALA    25      14.128  18.752 162.037  1.00 40.19           C  
ATOM    176  C   ALA    25      14.839  20.105 162.157  1.00 40.52           C  
ATOM    177  O   ALA    25      14.731  20.951 161.261  1.00 41.05           O  
ATOM    178  CB  ALA    25      12.728  18.829 162.649  1.00 40.91           C  
ATOM    179  N   ARG    26      15.564  20.307 163.256  1.00 40.54           N  
ATOM    180  CA  ARG    26      16.300  21.552 163.475  1.00 40.67           C  
ATOM    181  C   ARG    26      17.542  21.569 162.573  1.00 41.44           C  
ATOM    182  O   ARG    26      17.953  22.620 162.081  1.00 43.15           O  
ATOM    183  CB  ARG    26      16.716  21.666 164.945  1.00 40.06           C  
ATOM    184  CG  ARG    26      17.206  23.049 165.344  1.00 41.06           C  
ATOM    185  CD  ARG    26      17.244  23.192 166.860  1.00 39.59           C  
ATOM    186  NE  ARG    26      15.918  23.381 167.448  1.00 36.02           N  
ATOM    187  CZ  ARG    26      15.195  24.489 167.308  1.00 35.63           C  
ATOM    188  NH1 ARG    26      15.676  25.501 166.600  1.00 33.06           N  
ATOM    189  NH2 ARG    26      14.002  24.588 167.884  1.00 31.51           N  
ATOM    190  N   GLU    27      18.141  20.402 162.354  1.00 43.09           N  
ATOM    191  CA  GLU    27      19.306  20.309 161.483  1.00 45.53           C  
ATOM    192  C   GLU    27      18.829  20.549 160.048  1.00 44.47           C  
ATOM    193  O   GLU    27      19.434  21.325 159.304  1.00 44.94           O  
ATOM    194  CB  GLU    27      19.947  18.925 161.590  1.00 47.21           C  
ATOM    195  CG  GLU    27      21.435  18.965 161.907  1.00 56.44           C  
ATOM    196  CD  GLU    27      22.265  19.573 160.788  1.00 64.19           C  
ATOM    197  OE1 GLU    27      22.345  20.818 160.694  1.00 65.65           O  
ATOM    198  OE2 GLU    27      22.830  18.791 159.994  1.00 68.30           O  
ATOM    199  N   ASP    28      17.742  19.882 159.656  1.00 43.22           N  
ATOM    200  CA  ASP    28      17.198  20.053 158.307  1.00 42.84           C  
ATOM    201  C   ASP    28      16.904  21.517 157.990  1.00 42.31           C  
ATOM    202  O   ASP    28      17.295  22.014 156.935  1.00 42.99           O  
ATOM    203  CB  ASP    28      15.924  19.225 158.124  1.00 41.28           C  
ATOM    204  CG  ASP    28      16.209  17.744 157.975  1.00 42.74           C  
ATOM    205  OD1 ASP    28      17.404  17.380 157.943  1.00 44.72           O  
ATOM    206  OD2 ASP    28      15.246  16.946 157.885  1.00 45.45           O  
ATOM    207  N   ALA    29      16.225  22.209 158.902  1.00 41.52           N  
ATOM    208  CA  ALA    29      15.882  23.616 158.687  1.00 40.18           C  
ATOM    209  C   ALA    29      17.117  24.477 158.480  1.00 39.57           C  
ATOM    210  O   ALA    29      17.132  25.362 157.620  1.00 39.63           O  
ATOM    211  CB  ALA    29      15.058  24.154 159.864  1.00 40.56           C  
ATOM    212  N   ALA    30      18.146  24.209 159.275  1.00 39.17           N  
ATOM    213  CA  ALA    30      19.398  24.949 159.198  1.00 40.05           C  
ATOM    214  C   ALA    30      20.107  24.679 157.868  1.00 39.78           C  
ATOM    215  O   ALA    30      20.666  25.591 157.260  1.00 40.00           O  
ATOM    216  CB  ALA    30      20.305  24.561 160.365  1.00 40.11           C  
ATOM    217  N   GLU    31      20.085  23.427 157.422  1.00 38.65           N  
ATOM    218  CA  GLU    31      20.718  23.066 156.159  1.00 38.87           C  
ATOM    219  C   GLU    31      20.078  23.764 154.959  1.00 38.60           C  
ATOM    220  O   GLU    31      20.739  23.995 153.950  1.00 39.71           O  
ATOM    221  CB  GLU    31      20.668  21.552 155.963  1.00 39.36           C  
ATOM    222  CG  GLU    31      21.691  20.795 156.786  1.00 38.74           C  
ATOM    223  CD  GLU    31      21.437  19.310 156.790  1.00 43.41           C  
ATOM    224  OE1 GLU    31      20.865  18.809 155.803  1.00 47.35           O  
ATOM    225  OE2 GLU    31      21.820  18.637 157.764  1.00 48.92           O  
ATOM    226  N   PHE    32      18.796  24.105 155.072  1.00 37.78           N  
ATOM    227  CA  PHE    32      18.071  24.765 153.985  1.00 36.92           C  
ATOM    228  C   PHE    32      17.846  26.256 154.223  1.00 37.72           C  
ATOM    229  O   PHE    32      17.134  26.913 153.457  1.00 36.82           O  
ATOM    230  CB  PHE    32      16.727  24.064 153.758  1.00 35.46           C  
ATOM    231  CG  PHE    32      16.852  22.714 153.100  1.00 35.81           C  
ATOM    232  CD1 PHE    32      16.814  22.592 151.708  1.00 32.38           C  
ATOM    233  CD2 PHE    32      16.998  21.562 153.873  1.00 29.85           C  
ATOM    234  CE1 PHE    32      16.925  21.341 151.098  1.00 34.55           C  
ATOM    235  CE2 PHE    32      17.113  20.313 153.274  1.00 32.22           C  
ATOM    236  CZ  PHE    32      17.074  20.200 151.884  1.00 34.18           C  
ATOM    237  N   GLY    33      18.448  26.777 155.289  1.00 38.67           N  
ATOM    238  CA  GLY    33      18.321  28.190 155.623  1.00 38.55           C  
ATOM    239  C   GLY    33      16.923  28.661 155.983  1.00 37.08           C  
ATOM    240  O   GLY    33      16.572  29.818 155.756  1.00 36.54           O  
ATOM    241  N   LEU    34      16.129  27.765 156.564  1.00 38.38           N  
ATOM    242  CA  LEU    34      14.751  28.092 156.938  1.00 38.59           C  
ATOM    243  C   LEU    34      14.629  28.720 158.321  1.00 37.66           C  
ATOM    244  O   LEU    34      15.399  28.397 159.220  1.00 39.17           O  
ATOM    245  CB  LEU    34      13.887  26.827 156.897  1.00 38.83           C  
ATOM    246  CG  LEU    34      13.963  25.954 155.641  1.00 38.72           C  
ATOM    247  CD1 LEU    34      13.204  24.651 155.855  1.00 40.78           C  
ATOM    248  CD2 LEU    34      13.393  26.715 154.462  1.00 38.26           C  
ATOM    249  N   PRO    35      13.655  29.627 158.500  1.00 38.39           N  
ATOM    250  CA  PRO    35      13.416  30.306 159.780  1.00 39.03           C  
ATOM    251  C   PRO    35      12.913  29.261 160.777  1.00 40.77           C  
ATOM    252  O   PRO    35      11.820  28.713 160.611  1.00 41.07           O  
ATOM    253  CB  PRO    35      12.323  31.328 159.454  1.00 39.92           C  
ATOM    254  CG  PRO    35      12.269  31.377 157.939  1.00 39.36           C  
ATOM    255  CD  PRO    35      12.651  30.009 157.495  1.00 37.58           C  
ATOM    256  N   ALA    36      13.702  29.004 161.819  1.00 41.01           N  
ATOM    257  CA  ALA    36      13.344  27.997 162.818  1.00 40.99           C  
ATOM    258  C   ALA    36      13.320  28.519 164.250  1.00 40.41           C  
ATOM    259  O   ALA    36      14.364  28.860 164.803  1.00 41.47           O  
ATOM    260  CB  ALA    36      14.304  26.820 162.726  1.00 39.29           C  
ATOM    261  N   PRO    37      12.131  28.565 164.869  1.00 39.76           N  
ATOM    262  CA  PRO    37      11.992  29.042 166.250  1.00 37.91           C  
ATOM    263  C   PRO    37      12.926  28.246 167.151  1.00 36.44           C  
ATOM    264  O   PRO    37      13.077  27.035 166.962  1.00 35.90           O  
ATOM    265  CB  PRO    37      10.524  28.755 166.578  1.00 38.50           C  
ATOM    266  CG  PRO    37       9.850  28.774 165.250  1.00 40.52           C  
ATOM    267  CD  PRO    37      10.840  28.108 164.325  1.00 40.07           C  
ATOM    268  N   ASP    38      13.533  28.908 168.135  1.00 34.43           N  
ATOM    269  CA  ASP    38      14.448  28.213 169.038  1.00 34.87           C  
ATOM    270  C   ASP    38      13.717  27.211 169.936  1.00 35.84           C  
ATOM    271  O   ASP    38      12.491  27.094 169.887  1.00 34.82           O  
ATOM    272  CB  ASP    38      15.273  29.226 169.873  1.00 35.43           C  
ATOM    273  CG  ASP    38      14.428  30.055 170.830  1.00 37.24           C  
ATOM    274  OD1 ASP    38      13.181  30.018 170.734  1.00 39.36           O  
ATOM    275  OD2 ASP    38      15.029  30.747 171.687  1.00 41.15           O  
ATOM    276  N   GLU    39      14.478  26.489 170.752  1.00 35.27           N  
ATOM    277  CA  GLU    39      13.916  25.474 171.629  1.00 35.36           C  
ATOM    278  C   GLU    39      12.890  25.983 172.629  1.00 34.78           C  
ATOM    279  O   GLU    39      11.907  25.298 172.910  1.00 35.10           O  
ATOM    280  CB  GLU    39      15.040  24.754 172.372  1.00 36.46           C  
ATOM    281  CG  GLU    39      14.579  23.753 173.433  1.00 39.24           C  
ATOM    282  CD  GLU    39      13.757  22.609 172.864  1.00 42.52           C  
ATOM    283  OE1 GLU    39      14.081  22.141 171.754  1.00 46.69           O  
ATOM    284  OE2 GLU    39      12.795  22.167 173.532  1.00 44.19           O  
ATOM    285  N   MET    40      13.120  27.181 173.155  1.00 33.85           N  
ATOM    286  CA  MET    40      12.224  27.769 174.137  1.00 33.31           C  
ATOM    287  C   MET    40      10.880  28.153 173.523  1.00 31.59           C  
ATOM    288  O   MET    40       9.831  27.983 174.152  1.00 30.49           O  
ATOM    289  CB  MET    40      12.890  28.989 174.807  1.00 32.67           C  
ATOM    290  CG  MET    40      13.914  28.637 175.903  1.00 37.51           C  
ATOM    291  SD  MET    40      14.599  30.227 176.837  1.00 48.82          SE  
ATOM    292  CE  MET    40      16.150  29.483 177.672  1.00 47.77           C  
ATOM    293  N   THR    41      10.918  28.669 172.297  1.00 29.68           N  
ATOM    294  CA  THR    41       9.699  29.043 171.600  1.00 27.32           C  
ATOM    295  C   THR    41       8.914  27.755 171.285  1.00 26.43           C  
ATOM    296  O   THR    41       7.687  27.737 171.383  1.00 27.19           O  
ATOM    297  CB  THR    41      10.025  29.797 170.296  1.00 28.66           C  
ATOM    298  OG1 THR    41      10.738  30.996 170.619  1.00 26.10           O  
ATOM    299  CG2 THR    41       8.741  30.156 169.536  1.00 25.19           C  
ATOM    300  N   GLY    42       9.621  26.685 170.914  1.00 24.88           N  
ATOM    301  CA  GLY    42       8.967  25.414 170.622  1.00 26.74           C  
ATOM    302  C   GLY    42       8.266  24.847 171.858  1.00 27.45           C  
ATOM    303  O   GLY    42       7.145  24.339 171.751  1.00 27.33           O  
ATOM    304  N   GLN    43       8.910  24.928 173.025  1.00 26.78           N  
ATOM    305  CA  GLN    43       8.324  24.434 174.276  1.00 28.12           C  
ATOM    306  C   GLN    43       7.010  25.190 174.550  1.00 27.73           C  
ATOM    307  O   GLN    43       6.005  24.584 174.947  1.00 27.06           O  
ATOM    308  CB  GLN    43       9.332  24.610 175.437  1.00 27.92           C  
ATOM    309  CG  GLN    43      10.505  23.632 175.352  1.00 28.63           C  
ATOM    310  CD  GLN    43      11.578  23.886 176.399  1.00 34.03           C  
ATOM    311  OE1 GLN    43      11.355  24.607 177.373  1.00 36.82           O  
ATOM    312  NE2 GLN    43      12.752  23.290 176.204  1.00 32.59           N  
ATOM    313  N   LEU    44       7.014  26.508 174.335  1.00 27.40           N  
ATOM    314  CA  LEU    44       5.796  27.299 174.512  1.00 27.16           C  
ATOM    315  C   LEU    44       4.729  26.819 173.503  1.00 26.87           C  
ATOM    316  O   LEU    44       3.531  26.837 173.811  1.00 27.06           O  
ATOM    317  CB  LEU    44       6.061  28.795 174.302  1.00 25.60           C  
ATOM    318  CG  LEU    44       4.779  29.647 174.278  1.00 29.19           C  
ATOM    319  CD1 LEU    44       4.004  29.444 175.576  1.00 27.74           C  
ATOM    320  CD2 LEU    44       5.128  31.120 174.085  1.00 24.87           C  
ATOM    321  N   LEU    45       5.143  26.401 172.301  1.00 27.58           N  
ATOM    322  CA  LEU    45       4.174  25.911 171.307  1.00 29.21           C  
ATOM    323  C   LEU    45       3.531  24.614 171.836  1.00 28.50           C  
ATOM    324  O   LEU    45       2.331  24.399 171.691  1.00 29.78           O  
ATOM    325  CB  LEU    45       4.850  25.671 169.936  1.00 27.83           C  
ATOM    326  CG  LEU    45       5.300  26.957 169.216  1.00 30.54           C  
ATOM    327  CD1 LEU    45       5.894  26.601 167.853  1.00 32.59           C  
ATOM    328  CD2 LEU    45       4.104  27.908 169.041  1.00 29.82           C  
ATOM    329  N   THR    46       4.333  23.758 172.457  1.00 27.80           N  
ATOM    330  CA  THR    46       3.826  22.513 173.030  1.00 28.58           C  
ATOM    331  C   THR    46       2.826  22.835 174.150  1.00 27.31           C  
ATOM    332  O   THR    46       1.801  22.178 174.283  1.00 28.48           O  
ATOM    333  CB  THR    46       4.977  21.679 173.620  1.00 27.74           C  
ATOM    334  OG1 THR    46       5.956  21.451 172.604  1.00 28.37           O  
ATOM    335  CG2 THR    46       4.473  20.348 174.134  1.00 28.82           C  
ATOM    336  N   THR    47       3.136  23.852 174.953  1.00 28.69           N  
ATOM    337  CA  THR    47       2.279  24.266 176.060  1.00 27.73           C  
ATOM    338  C   THR    47       0.915  24.733 175.570  1.00 27.47           C  
ATOM    339  O   THR    47      -0.114  24.348 176.127  1.00 27.23           O  
ATOM    340  CB  THR    47       2.920  25.417 176.865  1.00 28.09           C  
ATOM    341  OG1 THR    47       4.170  24.984 177.415  1.00 27.40           O  
ATOM    342  CG2 THR    47       1.993  25.863 178.001  1.00 23.26           C  
ATOM    343  N   LEU    48       0.904  25.562 174.529  1.00 26.00           N  
ATOM    344  CA  LEU    48      -0.357  26.062 173.992  1.00 24.82           C  
ATOM    345  C   LEU    48      -1.138  24.957 173.294  1.00 24.93           C  
ATOM    346  O   LEU    48      -2.370  24.923 173.361  1.00 24.34           O  
ATOM    347  CB  LEU    48      -0.108  27.225 173.025  1.00 26.01           C  
ATOM    348  CG  LEU    48       0.505  28.475 173.683  1.00 30.70           C  
ATOM    349  CD1 LEU    48       0.765  29.551 172.624  1.00 30.77           C  
ATOM    350  CD2 LEU    48      -0.440  29.004 174.770  1.00 26.08           C  
ATOM    351  N   ALA    49      -0.428  24.053 172.620  1.00 25.73           N  
ATOM    352  CA  ALA    49      -1.091  22.953 171.935  1.00 26.68           C  
ATOM    353  C   ALA    49      -1.715  22.043 172.989  1.00 26.17           C  
ATOM    354  O   ALA    49      -2.765  21.445 172.761  1.00 25.74           O  
ATOM    355  CB  ALA    49      -0.084  22.163 171.077  1.00 24.82           C  
ATOM    356  N   ALA    50      -1.056  21.941 174.143  1.00 27.11           N  
ATOM    357  CA  ALA    50      -1.529  21.106 175.245  1.00 27.80           C  
ATOM    358  C   ALA    50      -2.642  21.769 176.057  1.00 29.60           C  
ATOM    359  O   ALA    50      -3.560  21.095 176.516  1.00 32.07           O  
ATOM    360  CB  ALA    50      -0.368  20.750 176.165  1.00 29.92           C  
ATOM    361  N   THR    51      -2.567  23.083 176.235  1.00 29.29           N  
ATOM    362  CA  THR    51      -3.576  23.787 177.009  1.00 30.18           C  
ATOM    363  C   THR    51      -4.841  24.127 176.208  1.00 32.02           C  
ATOM    364  O   THR    51      -5.941  24.063 176.767  1.00 31.22           O  
ATOM    365  CB  THR    51      -2.987  25.075 177.666  1.00 29.68           C  
ATOM    366  OG1 THR    51      -2.623  26.035 176.658  1.00 29.87           O  
ATOM    367  CG2 THR    51      -1.740  24.711 178.484  1.00 27.26           C  
ATOM    368  N   THR    52      -4.701  24.475 174.924  1.00 31.53           N  
ATOM    369  CA  THR    52      -5.877  24.802 174.119  1.00 31.58           C  
ATOM    370  C   THR    52      -6.810  23.597 174.026  1.00 33.91           C  
ATOM    371  O   THR    52      -6.387  22.444 174.151  1.00 34.00           O  
ATOM    372  CB  THR    52      -5.499  25.330 172.708  1.00 30.61           C  
ATOM    373  OG1 THR    52      -4.605  24.419 172.059  1.00 27.87           O  
ATOM    374  CG2 THR    52      -4.853  26.704 172.834  1.00 28.08           C  
ATOM    375  N   ASN    53      -8.085  23.868 173.784  1.00 36.96           N  
ATOM    376  CA  ASN    53      -9.107  22.823 173.780  1.00 41.28           C  
ATOM    377  C   ASN    53      -9.338  21.999 172.524  1.00 42.44           C  
ATOM    378  O   ASN    53      -9.875  22.501 171.540  1.00 42.24           O  
ATOM    379  CB  ASN    53     -10.426  23.449 174.254  1.00 41.27           C  
ATOM    380  CG  ASN    53     -11.429  22.416 174.745  1.00 44.44           C  
ATOM    381  OD1 ASN    53     -11.209  21.212 174.615  1.00 47.26           O  
ATOM    382  ND2 ASN    53     -12.548  22.888 175.303  1.00 47.57           N  
ATOM    383  N   GLY    54      -8.948  20.725 172.586  1.00 43.60           N  
ATOM    384  CA  GLY    54      -9.118  19.838 171.450  1.00 43.79           C  
ATOM    385  C   GLY    54     -10.568  19.477 171.184  1.00 46.01           C  
ATOM    386  O   GLY    54     -10.922  19.091 170.063  1.00 45.16           O  
ATOM    387  N   ASN    55     -11.408  19.603 172.213  1.00 46.67           N  
ATOM    388  CA  ASN    55     -12.834  19.294 172.096  1.00 46.74           C  
ATOM    389  C   ASN    55     -13.559  20.234 171.133  1.00 45.02           C  
ATOM    390  O   ASN    55     -13.647  21.441 171.374  1.00 46.21           O  
ATOM    391  CB  ASN    55     -13.509  19.362 173.473  1.00 48.61           C  
ATOM    392  CG  ASN    55     -13.087  18.220 174.394  1.00 52.70           C  
ATOM    393  OD1 ASN    55     -12.242  18.388 175.277  1.00 56.39           O  
ATOM    394  ND2 ASN    55     -13.671  17.045 174.179  1.00 58.74           N  
ATOM    395  N   GLY    56     -14.082  19.666 170.047  1.00 43.79           N  
ATOM    396  CA  GLY    56     -14.800  20.441 169.044  1.00 40.35           C  
ATOM    397  C   GLY    56     -13.862  21.143 168.080  1.00 38.97           C  
ATOM    398  O   GLY    56     -14.285  21.869 167.182  1.00 39.42           O  
ATOM    399  N   SER    57     -12.571  20.899 168.262  1.00 38.33           N  
ATOM    400  CA  SER    57     -11.535  21.505 167.437  1.00 35.50           C  
ATOM    401  C   SER    57     -10.963  20.557 166.387  1.00 33.56           C  
ATOM    402  O   SER    57     -10.777  19.374 166.646  1.00 31.18           O  
ATOM    403  CB  SER    57     -10.415  22.011 168.349  1.00 35.48           C  
ATOM    404  OG  SER    57      -9.243  22.356 167.632  1.00 34.61           O  
ATOM    405  N   THR    58     -10.681  21.087 165.200  1.00 32.90           N  
ATOM    406  CA  THR    58     -10.094  20.281 164.142  1.00 31.69           C  
ATOM    407  C   THR    58      -8.624  20.066 164.515  1.00 31.06           C  
ATOM    408  O   THR    58      -8.024  19.038 164.175  1.00 31.61           O  
ATOM    409  CB  THR    58     -10.180  20.998 162.777  1.00 32.99           C  
ATOM    410  OG1 THR    58     -11.548  21.305 162.487  1.00 32.94           O  
ATOM    411  CG2 THR    58      -9.628  20.102 161.665  1.00 33.92           C  
ATOM    412  N   GLY    59      -8.051  21.038 165.226  1.00 29.22           N  
ATOM    413  CA  GLY    59      -6.655  20.940 165.629  1.00 27.38           C  
ATOM    414  C   GLY    59      -5.873  22.231 165.456  1.00 28.44           C  
ATOM    415  O   GLY    59      -6.366  23.328 165.734  1.00 27.05           O  
ATOM    416  N   ALA    60      -4.650  22.104 164.964  1.00 27.51           N  
ATOM    417  CA  ALA    60      -3.798  23.261 164.784  1.00 28.53           C  
ATOM    418  C   ALA    60      -3.383  23.494 163.344  1.00 27.12           C  
ATOM    419  O   ALA    60      -3.470  22.598 162.499  1.00 26.54           O  
ATOM    420  CB  ALA    60      -2.553  23.121 165.676  1.00 26.61           C  
ATOM    421  N   ILE    61      -2.936  24.716 163.076  1.00 26.85           N  
ATOM    422  CA  ILE    61      -2.436  25.079 161.757  1.00 25.89           C  
ATOM    423  C   ILE    61      -1.026  25.662 161.925  1.00 26.23           C  
ATOM    424  O   ILE    61      -0.795  26.518 162.789  1.00 24.01           O  
ATOM    425  CB  ILE    61      -3.291  26.156 161.062  1.00 24.77           C  
ATOM    426  CG1 ILE    61      -4.711  25.646 160.832  1.00 26.17           C  
ATOM    427  CG2 ILE    61      -2.667  26.511 159.695  1.00 28.08           C  
ATOM    428  CD1 ILE    61      -5.649  26.690 160.250  1.00 24.83           C  
ATOM    429  N   ALA    62      -0.086  25.172 161.120  1.00 24.83           N  
ATOM    430  CA  ALA    62       1.285  25.687 161.129  1.00 27.04           C  
ATOM    431  C   ALA    62       1.558  26.266 159.728  1.00 26.93           C  
ATOM    432  O   ALA    62       1.616  25.537 158.737  1.00 27.63           O  
ATOM    433  CB  ALA    62       2.302  24.572 161.447  1.00 24.51           C  
ATOM    434  N   ILE    63       1.703  27.582 159.650  1.00 29.03           N  
ATOM    435  CA  ILE    63       1.974  28.269 158.397  1.00 30.40           C  
ATOM    436  C   ILE    63       3.430  28.702 158.444  1.00 30.95           C  
ATOM    437  O   ILE    63       3.771  29.745 159.002  1.00 32.03           O  
ATOM    438  CB  ILE    63       1.057  29.488 158.246  1.00 31.41           C  
ATOM    439  CG1 ILE    63      -0.394  29.016 158.112  1.00 33.10           C  
ATOM    440  CG2 ILE    63       1.472  30.306 157.044  1.00 33.12           C  
ATOM    441  CD1 ILE    63      -1.389  29.915 158.811  1.00 34.01           C  
ATOM    442  N   THR    64       4.289  27.911 157.812  1.00 31.33           N  
ATOM    443  CA  THR    64       5.721  28.179 157.842  1.00 31.25           C  
ATOM    444  C   THR    64       6.492  27.262 156.895  1.00 31.37           C  
ATOM    445  O   THR    64       6.055  26.147 156.621  1.00 31.07           O  
ATOM    446  CB  THR    64       6.248  27.938 159.275  1.00 30.66           C  
ATOM    447  OG1 THR    64       7.678  27.951 159.289  1.00 31.03           O  
ATOM    448  CG2 THR    64       5.768  26.557 159.795  1.00 30.49           C  
ATOM    449  N   PRO    65       7.651  27.719 156.398  1.00 32.35           N  
ATOM    450  CA  PRO    65       8.500  26.936 155.489  1.00 32.48           C  
ATOM    451  C   PRO    65       9.084  25.724 156.212  1.00 33.51           C  
ATOM    452  O   PRO    65       9.439  24.734 155.590  1.00 35.67           O  
ATOM    453  CB  PRO    65       9.603  27.913 155.089  1.00 31.90           C  
ATOM    454  CG  PRO    65       8.961  29.242 155.205  1.00 34.17           C  
ATOM    455  CD  PRO    65       8.050  29.140 156.412  1.00 32.46           C  
ATOM    456  N   ALA    66       9.209  25.823 157.529  1.00 33.82           N  
ATOM    457  CA  ALA    66       9.751  24.726 158.336  1.00 33.47           C  
ATOM    458  C   ALA    66       8.656  24.140 159.222  1.00 34.22           C  
ATOM    459  O   ALA    66       8.747  24.175 160.443  1.00 32.79           O  
ATOM    460  CB  ALA    66      10.897  25.226 159.206  1.00 34.03           C  
ATOM    461  N   ALA    67       7.622  23.586 158.600  1.00 34.58           N  
ATOM    462  CA  ALA    67       6.496  23.008 159.329  1.00 34.68           C  
ATOM    463  C   ALA    67       6.851  21.748 160.101  1.00 35.19           C  
ATOM    464  O   ALA    67       6.146  21.366 161.041  1.00 33.42           O  
ATOM    465  CB  ALA    67       5.348  22.721 158.365  1.00 33.52           C  
ATOM    466  N   GLY    68       7.944  21.108 159.698  1.00 34.05           N  
ATOM    467  CA  GLY    68       8.365  19.888 160.351  1.00 33.14           C  
ATOM    468  C   GLY    68       8.839  20.106 161.776  1.00 33.00           C  
ATOM    469  O   GLY    68       8.451  19.368 162.690  1.00 31.77           O  
ATOM    470  N   LEU    69       9.685  21.111 161.967  1.00 31.47           N  
ATOM    471  CA  LEU    69      10.206  21.409 163.290  1.00 32.26           C  
ATOM    472  C   LEU    69       9.049  21.904 164.167  1.00 33.07           C  
ATOM    473  O   LEU    69       8.747  21.322 165.202  1.00 33.37           O  
ATOM    474  CB  LEU    69      11.316  22.469 163.199  1.00 30.74           C  
ATOM    475  CG  LEU    69      11.850  23.000 164.535  1.00 32.20           C  
ATOM    476  CD1 LEU    69      12.571  21.903 165.298  1.00 32.82           C  
ATOM    477  CD2 LEU    69      12.786  24.161 164.273  1.00 29.97           C  
ATOM    478  N   VAL    70       8.404  22.979 163.737  1.00 33.16           N  
ATOM    479  CA  VAL    70       7.270  23.553 164.456  1.00 34.67           C  
ATOM    480  C   VAL    70       6.188  22.511 164.772  1.00 34.31           C  
ATOM    481  O   VAL    70       5.713  22.433 165.910  1.00 33.10           O  
ATOM    482  CB  VAL    70       6.641  24.707 163.632  1.00 35.05           C  
ATOM    483  CG1 VAL    70       5.295  25.134 164.236  1.00 37.65           C  
ATOM    484  CG2 VAL    70       7.594  25.883 163.595  1.00 33.13           C  
ATOM    485  N   GLY    71       5.818  21.730 163.755  1.00 32.90           N  
ATOM    486  CA  GLY    71       4.791  20.711 163.886  1.00 30.68           C  
ATOM    487  C   GLY    71       5.058  19.658 164.935  1.00 30.85           C  
ATOM    488  O   GLY    71       4.128  19.144 165.564  1.00 31.53           O  
ATOM    489  N   LEU    72       6.329  19.312 165.101  1.00 29.51           N  
ATOM    490  CA  LEU    72       6.718  18.310 166.080  1.00 30.07           C  
ATOM    491  C   LEU    72       6.456  18.822 167.497  1.00 28.95           C  
ATOM    492  O   LEU    72       6.056  18.058 168.379  1.00 29.63           O  
ATOM    493  CB  LEU    72       8.199  17.931 165.905  1.00 28.25           C  
ATOM    494  CG  LEU    72       8.495  17.019 164.697  1.00 28.77           C  
ATOM    495  CD1 LEU    72      10.006  16.853 164.530  1.00 31.04           C  
ATOM    496  CD2 LEU    72       7.842  15.648 164.901  1.00 27.33           C  
ATOM    497  N   TYR    73       6.689  20.111 167.721  1.00 29.65           N  
ATOM    498  CA  TYR    73       6.457  20.703 169.041  1.00 29.58           C  
ATOM    499  C   TYR    73       4.964  20.741 169.333  1.00 28.26           C  
ATOM    500  O   TYR    73       4.531  20.474 170.441  1.00 29.39           O  
ATOM    501  CB  TYR    73       7.009  22.121 169.087  1.00 29.72           C  
ATOM    502  CG  TYR    73       8.499  22.183 169.239  1.00 29.82           C  
ATOM    503  CD1 TYR    73       9.111  21.787 170.432  1.00 29.49           C  
ATOM    504  CD2 TYR    73       9.299  22.677 168.210  1.00 29.76           C  
ATOM    505  CE1 TYR    73      10.485  21.890 170.597  1.00 30.20           C  
ATOM    506  CE2 TYR    73      10.678  22.785 168.362  1.00 28.61           C  
ATOM    507  CZ  TYR    73      11.261  22.396 169.553  1.00 29.90           C  
ATOM    508  OH  TYR    73      12.613  22.544 169.717  1.00 35.40           O  
ATOM    509  N   ILE    74       4.187  21.075 168.313  1.00 27.05           N  
ATOM    510  CA  ILE    74       2.742  21.150 168.431  1.00 26.50           C  
ATOM    511  C   ILE    74       2.135  19.761 168.633  1.00 26.41           C  
ATOM    512  O   ILE    74       1.286  19.576 169.502  1.00 28.29           O  
ATOM    513  CB  ILE    74       2.133  21.843 167.173  1.00 25.58           C  
ATOM    514  CG1 ILE    74       2.499  23.330 167.185  1.00 23.49           C  
ATOM    515  CG2 ILE    74       0.621  21.655 167.133  1.00 22.85           C  
ATOM    516  CD1 ILE    74       1.908  24.129 166.028  1.00 28.06           C  
ATOM    517  N   LEU    75       2.578  18.785 167.838  1.00 29.11           N  
ATOM    518  CA  LEU    75       2.070  17.417 167.943  1.00 31.04           C  
ATOM    519  C   LEU    75       2.324  16.801 169.317  1.00 31.90           C  
ATOM    520  O   LEU    75       1.556  15.959 169.776  1.00 32.45           O  
ATOM    521  CB  LEU    75       2.669  16.541 166.827  1.00 29.40           C  
ATOM    522  CG  LEU    75       2.073  16.841 165.443  1.00 32.38           C  
ATOM    523  CD1 LEU    75       2.908  16.176 164.343  1.00 30.38           C  
ATOM    524  CD2 LEU    75       0.623  16.352 165.404  1.00 29.98           C  
ATOM    525  N   ASN    76       3.395  17.230 169.975  1.00 33.41           N  
ATOM    526  CA  ASN    76       3.712  16.733 171.314  1.00 35.17           C  
ATOM    527  C   ASN    76       2.572  17.013 172.296  1.00 35.09           C  
ATOM    528  O   ASN    76       2.253  16.169 173.134  1.00 36.99           O  
ATOM    529  CB  ASN    76       4.985  17.396 171.838  1.00 34.72           C  
ATOM    530  CG  ASN    76       6.245  16.662 171.424  1.00 39.54           C  
ATOM    531  OD1 ASN    76       7.342  17.238 171.396  1.00 43.81           O  
ATOM    532  ND2 ASN    76       6.101  15.382 171.115  1.00 43.80           N  
ATOM    533  N   GLY    77       1.956  18.193 172.195  1.00 32.65           N  
ATOM    534  CA  GLY    77       0.886  18.548 173.123  1.00 31.47           C  
ATOM    535  C   GLY    77      -0.552  18.330 172.695  1.00 32.40           C  
ATOM    536  O   GLY    77      -1.423  18.051 173.515  1.00 32.95           O  
ATOM    537  N   LEU    78      -0.793  18.459 171.402  1.00 31.49           N  
ATOM    538  CA  LEU    78      -2.120  18.294 170.822  1.00 32.19           C  
ATOM    539  C   LEU    78      -2.823  16.975 171.191  1.00 32.44           C  
ATOM    540  O   LEU    78      -2.192  15.920 171.231  1.00 33.08           O  
ATOM    541  CB  LEU    78      -2.002  18.403 169.302  1.00 29.81           C  
ATOM    542  CG  LEU    78      -2.898  19.317 168.462  1.00 36.01           C  
ATOM    543  CD1 LEU    78      -3.015  20.694 169.104  1.00 31.57           C  
ATOM    544  CD2 LEU    78      -2.310  19.420 167.051  1.00 33.99           C  
ATOM    545  N   ALA    79      -4.125  17.038 171.467  1.00 32.64           N  
ATOM    546  CA  ALA    79      -4.892  15.832 171.782  1.00 34.44           C  
ATOM    547  C   ALA    79      -4.895  14.941 170.513  1.00 36.11           C  
ATOM    548  O   ALA    79      -4.945  15.436 169.369  1.00 34.62           O  
ATOM    549  CB  ALA    79      -6.313  16.202 172.177  1.00 33.20           C  
ATOM    550  N   ASP    80      -4.855  13.626 170.720  1.00 37.28           N  
ATOM    551  CA  ASP    80      -4.807  12.657 169.619  1.00 38.96           C  
ATOM    552  C   ASP    80      -5.900  12.729 168.569  1.00 39.23           C  
ATOM    553  O   ASP    80      -5.662  12.390 167.403  1.00 40.09           O  
ATOM    554  CB  ASP    80      -4.733  11.229 170.168  1.00 39.60           C  
ATOM    555  CG  ASP    80      -3.476  10.985 170.982  1.00 42.87           C  
ATOM    556  OD1 ASP    80      -2.538  11.801 170.863  1.00 44.38           O  
ATOM    557  OD2 ASP    80      -3.422   9.972 171.723  1.00 45.18           O  
ATOM    558  N   ASN    81      -7.082  13.184 168.970  1.00 39.54           N  
ATOM    559  CA  ASN    81      -8.204  13.278 168.047  1.00 39.87           C  
ATOM    560  C   ASN    81      -8.299  14.609 167.305  1.00 39.74           C  
ATOM    561  O   ASN    81      -9.394  15.121 167.052  1.00 39.36           O  
ATOM    562  CB  ASN    81      -9.514  12.983 168.783  1.00 41.88           C  
ATOM    563  CG  ASN    81      -9.823  13.994 169.858  1.00 43.68           C  
ATOM    564  OD1 ASN    81      -8.920  14.588 170.441  1.00 47.17           O  
ATOM    565  ND2 ASN    81     -11.110  14.181 170.145  1.00 46.32           N  
ATOM    566  N   THR    82      -7.140  15.166 166.966  1.00 38.30           N  
ATOM    567  CA  THR    82      -7.066  16.420 166.219  1.00 36.46           C  
ATOM    568  C   THR    82      -5.965  16.231 165.179  1.00 37.02           C  
ATOM    569  O   THR    82      -5.215  15.253 165.228  1.00 35.72           O  
ATOM    570  CB  THR    82      -6.673  17.620 167.113  1.00 36.23           C  
ATOM    571  OG1 THR    82      -5.346  17.421 167.621  1.00 36.98           O  
ATOM    572  CG2 THR    82      -7.648  17.775 168.276  1.00 32.89           C  
ATOM    573  N   THR    83      -5.870  17.152 164.229  1.00 35.99           N  
ATOM    574  CA  THR    83      -4.833  17.056 163.204  1.00 36.94           C  
ATOM    575  C   THR    83      -3.979  18.323 163.161  1.00 35.17           C  
ATOM    576  O   THR    83      -4.354  19.372 163.704  1.00 34.96           O  
ATOM    577  CB  THR    83      -5.419  16.869 161.772  1.00 36.92           C  
ATOM    578  OG1 THR    83      -6.172  18.035 161.406  1.00 39.44           O  
ATOM    579  CG2 THR    83      -6.322  15.639 161.695  1.00 37.40           C  
ATOM    580  N   LEU    84      -2.814  18.214 162.535  1.00 33.33           N  
ATOM    581  CA  LEU    84      -1.956  19.373 162.347  1.00 32.12           C  
ATOM    582  C   LEU    84      -2.042  19.650 160.851  1.00 31.40           C  
ATOM    583  O   LEU    84      -1.809  18.764 160.022  1.00 32.33           O  
ATOM    584  CB  LEU    84      -0.491  19.090 162.727  1.00 32.68           C  
ATOM    585  CG  LEU    84       0.523  20.154 162.264  1.00 29.79           C  
ATOM    586  CD1 LEU    84       0.307  21.474 163.009  1.00 30.01           C  
ATOM    587  CD2 LEU    84       1.929  19.629 162.515  1.00 28.22           C  
ATOM    588  N   THR    85      -2.406  20.875 160.501  1.00 32.14           N  
ATOM    589  CA  THR    85      -2.507  21.273 159.104  1.00 30.98           C  
ATOM    590  C   THR    85      -1.329  22.197 158.812  1.00 31.89           C  
ATOM    591  O   THR    85      -1.208  23.272 159.401  1.00 32.68           O  
ATOM    592  CB  THR    85      -3.837  22.004 158.831  1.00 30.16           C  
ATOM    593  OG1 THR    85      -4.924  21.091 159.026  1.00 30.62           O  
ATOM    594  CG2 THR    85      -3.875  22.553 157.416  1.00 30.92           C  
ATOM    595  N   CYS    86      -0.458  21.762 157.906  1.00 32.18           N  
ATOM    596  CA  CYS    86       0.714  22.537 157.518  1.00 31.91           C  
ATOM    597  C   CYS    86       0.448  23.205 156.180  1.00 32.73           C  
ATOM    598  O   CYS    86      -0.146  22.612 155.283  1.00 33.43           O  
ATOM    599  CB  CYS    86       1.939  21.633 157.398  1.00 31.46           C  
ATOM    600  SG  CYS    86       2.309  20.684 158.888  1.00 30.56           S  
ATOM    601  N   ILE    87       0.900  24.445 156.047  1.00 32.21           N  
ATOM    602  CA  ILE    87       0.681  25.199 154.820  1.00 32.24           C  
ATOM    603  C   ILE    87       1.921  25.904 154.279  1.00 34.38           C  
ATOM    604  O   ILE    87       2.488  26.779 154.948  1.00 35.36           O  
ATOM    605  CB  ILE    87      -0.392  26.294 155.018  1.00 31.54           C  
ATOM    606  CG1 ILE    87      -1.607  25.723 155.753  1.00 28.05           C  
ATOM    607  CG2 ILE    87      -0.785  26.889 153.665  1.00 28.77           C  
ATOM    608  CD1 ILE    87      -2.753  26.703 155.903  1.00 31.08           C  
ATOM    609  N   ASP    88       2.344  25.505 153.082  1.00 34.03           N  
ATOM    610  CA  ASP    88       3.466  26.138 152.400  1.00 34.37           C  
ATOM    611  C   ASP    88       3.368  25.786 150.906  1.00 33.50           C  
ATOM    612  O   ASP    88       2.976  24.679 150.548  1.00 33.15           O  
ATOM    613  CB  ASP    88       4.823  25.687 152.965  1.00 32.69           C  
ATOM    614  CG  ASP    88       5.983  26.521 152.414  1.00 32.83           C  
ATOM    615  OD1 ASP    88       6.150  27.677 152.852  1.00 33.51           O  
ATOM    616  OD2 ASP    88       6.707  26.028 151.526  1.00 31.22           O  
ATOM    617  N   PRO    89       3.705  26.738 150.021  1.00 35.06           N  
ATOM    618  CA  PRO    89       3.654  26.536 148.564  1.00 37.30           C  
ATOM    619  C   PRO    89       4.796  25.746 147.929  1.00 39.95           C  
ATOM    620  O   PRO    89       4.690  25.310 146.781  1.00 40.65           O  
ATOM    621  CB  PRO    89       3.600  27.962 148.019  1.00 36.50           C  
ATOM    622  CG  PRO    89       4.416  28.736 149.005  1.00 33.94           C  
ATOM    623  CD  PRO    89       4.032  28.139 150.356  1.00 35.74           C  
ATOM    624  N   GLU    90       5.882  25.561 148.672  1.00 40.63           N  
ATOM    625  CA  GLU    90       7.049  24.865 148.164  1.00 41.49           C  
ATOM    626  C   GLU    90       6.934  23.361 148.357  1.00 41.43           C  
ATOM    627  O   GLU    90       6.688  22.892 149.464  1.00 42.37           O  
ATOM    628  CB  GLU    90       8.290  25.445 148.855  1.00 42.68           C  
ATOM    629  CG  GLU    90       9.148  26.359 147.968  1.00 47.20           C  
ATOM    630  CD  GLU    90       8.355  27.215 146.988  1.00 50.57           C  
ATOM    631  OE1 GLU    90       7.985  28.356 147.335  1.00 54.15           O  
ATOM    632  OE2 GLU    90       8.093  26.733 145.867  1.00 51.33           O  
ATOM    633  N   SER    91       7.118  22.606 147.277  1.00 40.04           N  
ATOM    634  CA  SER    91       6.974  21.159 147.346  1.00 40.28           C  
ATOM    635  C   SER    91       8.046  20.403 148.106  1.00 39.22           C  
ATOM    636  O   SER    91       7.757  19.360 148.698  1.00 38.91           O  
ATOM    637  CB  SER    91       6.795  20.574 145.938  1.00 40.80           C  
ATOM    638  OG  SER    91       7.828  20.986 145.076  1.00 47.75           O  
ATOM    639  N   GLU    92       9.273  20.917 148.105  1.00 38.40           N  
ATOM    640  CA  GLU    92      10.328  20.254 148.855  1.00 37.79           C  
ATOM    641  C   GLU    92      10.055  20.488 150.350  1.00 35.86           C  
ATOM    642  O   GLU    92      10.494  19.697 151.190  1.00 34.88           O  
ATOM    643  CB  GLU    92      11.724  20.777 148.458  1.00 37.99           C  
ATOM    644  CG  GLU    92      12.018  22.231 148.746  1.00 38.66           C  
ATOM    645  CD  GLU    92      13.401  22.629 148.226  1.00 39.16           C  
ATOM    646  OE1 GLU    92      13.730  23.832 148.234  1.00 44.47           O  
ATOM    647  OE2 GLU    92      14.165  21.728 147.819  1.00 39.56           O  
ATOM    648  N   HIS    93       9.339  21.565 150.689  1.00 34.44           N  
ATOM    649  CA  HIS    93       8.997  21.824 152.087  1.00 34.73           C  
ATOM    650  C   HIS    93       7.952  20.787 152.502  1.00 36.07           C  
ATOM    651  O   HIS    93       7.934  20.348 153.652  1.00 37.25           O  
ATOM    652  CB  HIS    93       8.472  23.258 152.258  1.00 34.41           C  
ATOM    653  CG  HIS    93       9.545  24.294 152.134  1.00 32.27           C  
ATOM    654  ND1 HIS    93       9.280  25.639 152.016  1.00 30.35           N  
ATOM    655  CD2 HIS    93      10.892  24.171 152.097  1.00 24.41           C  
ATOM    656  CE1 HIS    93      10.418  26.300 151.907  1.00 27.66           C  
ATOM    657  NE2 HIS    93      11.411  25.432 151.952  1.00 27.44           N  
ATOM    658  N   GLN    94       7.085  20.385 151.569  1.00 36.34           N  
ATOM    659  CA  GLN    94       6.070  19.368 151.863  1.00 36.30           C  
ATOM    660  C   GLN    94       6.777  18.026 152.075  1.00 37.32           C  
ATOM    661  O   GLN    94       6.414  17.252 152.974  1.00 36.92           O  
ATOM    662  CB  GLN    94       5.061  19.248 150.715  1.00 36.05           C  
ATOM    663  CG  GLN    94       4.217  17.979 150.781  1.00 38.03           C  
ATOM    664  CD  GLN    94       2.981  18.054 149.912  1.00 41.92           C  
ATOM    665  OE1 GLN    94       3.067  18.249 148.695  1.00 43.15           O  
ATOM    666  NE2 GLN    94       1.815  17.904 150.534  1.00 42.69           N  
ATOM    667  N   ARG    95       7.783  17.749 151.242  1.00 37.73           N  
ATOM    668  CA  ARG    95       8.554  16.513 151.365  1.00 38.04           C  
ATOM    669  C   ARG    95       9.350  16.566 152.664  1.00 36.71           C  
ATOM    670  O   ARG    95       9.433  15.578 153.389  1.00 37.54           O  
ATOM    671  CB  ARG    95       9.522  16.343 150.190  1.00 37.76           C  
ATOM    672  CG  ARG    95       8.981  15.501 149.051  1.00 41.07           C  
ATOM    673  CD  ARG    95      10.112  14.864 148.251  1.00 41.47           C  
ATOM    674  NE  ARG    95      10.210  13.421 148.471  1.00 44.73           N  
ATOM    675  CZ  ARG    95      11.303  12.697 148.238  1.00 48.22           C  
ATOM    676  NH1 ARG    95      12.405  13.277 147.777  1.00 43.75           N  
ATOM    677  NH2 ARG    95      11.300  11.388 148.466  1.00 50.29           N  
ATOM    678  N   GLN    96       9.929  17.729 152.950  1.00 36.06           N  
ATOM    679  CA  GLN    96      10.728  17.925 154.160  1.00 36.78           C  
ATOM    680  C   GLN    96       9.918  17.667 155.432  1.00 37.11           C  
ATOM    681  O   GLN    96      10.404  17.022 156.363  1.00 38.28           O  
ATOM    682  CB  GLN    96      11.321  19.352 154.177  1.00 36.09           C  
ATOM    683  CG  GLN    96      12.559  19.528 153.281  1.00 35.76           C  
ATOM    684  CD  GLN    96      12.876  20.987 152.938  1.00 37.87           C  
ATOM    685  OE1 GLN    96      12.553  21.902 153.695  1.00 37.55           O  
ATOM    686  NE2 GLN    96      13.521  21.202 151.787  1.00 37.71           N  
ATOM    687  N   ALA    97       8.685  18.164 155.459  1.00 36.86           N  
ATOM    688  CA  ALA    97       7.808  18.008 156.618  1.00 38.73           C  
ATOM    689  C   ALA    97       7.274  16.589 156.803  1.00 39.18           C  
ATOM    690  O   ALA    97       7.426  16.003 157.871  1.00 40.70           O  
ATOM    691  CB  ALA    97       6.642  18.998 156.527  1.00 38.41           C  
ATOM    692  N   LYS    98       6.643  16.043 155.767  1.00 41.29           N  
ATOM    693  CA  LYS    98       6.092  14.691 155.829  1.00 42.21           C  
ATOM    694  C   LYS    98       7.160  13.660 156.207  1.00 41.35           C  
ATOM    695  O   LYS    98       6.868  12.667 156.882  1.00 41.72           O  
ATOM    696  CB  LYS    98       5.452  14.320 154.489  1.00 42.60           C  
ATOM    697  CG  LYS    98       4.132  15.045 154.207  1.00 46.99           C  
ATOM    698  CD  LYS    98       3.701  14.826 152.757  1.00 50.33           C  
ATOM    699  CE  LYS    98       2.273  14.316 152.636  1.00 52.72           C  
ATOM    700  NZ  LYS    98       1.300  15.394 152.311  1.00 55.75           N  
ATOM    701  N   ALA    99       8.395  13.899 155.776  1.00 40.82           N  
ATOM    702  CA  ALA    99       9.501  13.005 156.096  1.00 40.65           C  
ATOM    703  C   ALA    99       9.746  13.051 157.612  1.00 41.49           C  
ATOM    704  O   ALA    99       9.763  12.015 158.279  1.00 42.92           O  
ATOM    705  CB  ALA    99      10.761  13.443 155.353  1.00 39.72           C  
ATOM    706  N   LEU   100       9.944  14.253 158.155  1.00 41.47           N  
ATOM    707  CA  LEU   100      10.195  14.414 159.590  1.00 42.16           C  
ATOM    708  C   LEU   100       9.088  13.802 160.454  1.00 43.10           C  
ATOM    709  O   LEU   100       9.366  13.216 161.504  1.00 44.57           O  
ATOM    710  CB  LEU   100      10.390  15.899 159.931  1.00 40.19           C  
ATOM    711  CG  LEU   100      11.760  16.459 159.539  1.00 40.76           C  
ATOM    712  CD1 LEU   100      11.733  17.979 159.622  1.00 38.21           C  
ATOM    713  CD2 LEU   100      12.845  15.879 160.463  1.00 39.23           C  
ATOM    714  N   PHE   101       7.837  13.937 160.017  1.00 43.20           N  
ATOM    715  CA  PHE   101       6.726  13.365 160.764  1.00 42.25           C  
ATOM    716  C   PHE   101       6.823  11.845 160.643  1.00 44.41           C  
ATOM    717  O   PHE   101       6.658  11.123 161.621  1.00 43.24           O  
ATOM    718  CB  PHE   101       5.385  13.879 160.217  1.00 41.31           C  
ATOM    719  CG  PHE   101       5.197  15.367 160.365  1.00 39.00           C  
ATOM    720  CD1 PHE   101       5.665  16.033 161.502  1.00 34.66           C  
ATOM    721  CD2 PHE   101       4.571  16.105 159.369  1.00 36.49           C  
ATOM    722  CE1 PHE   101       5.495  17.412 161.645  1.00 34.60           C  
ATOM    723  CE2 PHE   101       4.399  17.484 159.500  1.00 34.58           C  
ATOM    724  CZ  PHE   101       4.870  18.142 160.633  1.00 32.21           C  
ATOM    725  N   ARG   102       7.102  11.360 159.435  1.00 46.41           N  
ATOM    726  CA  ARG   102       7.242   9.923 159.196  1.00 48.11           C  
ATOM    727  C   ARG   102       8.348   9.354 160.107  1.00 48.36           C  
ATOM    728  O   ARG   102       8.139   8.336 160.770  1.00 48.43           O  
ATOM    729  CB  ARG   102       7.627   9.660 157.741  1.00 49.29           C  
ATOM    730  CG  ARG   102       7.634   8.184 157.333  1.00 51.02           C  
ATOM    731  CD  ARG   102       8.792   7.853 156.388  1.00 53.05           C  
ATOM    732  NE  ARG   102       9.139   8.969 155.508  1.00 52.14           N  
ATOM    733  CZ  ARG   102       8.311   9.516 154.622  1.00 55.54           C  
ATOM    734  NH1 ARG   102       7.078   9.047 154.486  1.00 53.38           N  
ATOM    735  NH2 ARG   102       8.711  10.542 153.882  1.00 51.50           N  
ATOM    736  N   GLU   103       9.516  10.005 160.131  1.00 48.96           N  
ATOM    737  CA  GLU   103      10.645   9.551 160.943  1.00 49.81           C  
ATOM    738  C   GLU   103      10.291   9.567 162.426  1.00 50.89           C  
ATOM    739  O   GLU   103      10.596   8.606 163.141  1.00 50.34           O  
ATOM    740  CB  GLU   103      11.893  10.388 160.616  1.00 50.09           C  
ATOM    741  CG  GLU   103      12.643   9.818 159.415  1.00 51.67           C  
ATOM    742  CD  GLU   103      13.347  10.890 158.626  1.00 51.76           C  
ATOM    743  OE1 GLU   103      13.899  11.825 159.251  1.00 48.29           O  
ATOM    744  OE2 GLU   103      13.354  10.796 157.383  1.00 55.16           O  
ATOM    745  N   ALA   104       9.667  10.652 162.892  1.00 51.35           N  
ATOM    746  CA  ALA   104       9.177  10.675 164.265  1.00 52.00           C  
ATOM    747  C   ALA   104       8.091   9.565 164.126  1.00 52.43           C  
ATOM    748  O   ALA   104       7.679   9.211 163.007  1.00 53.80           O  
ATOM    749  CB  ALA   104       8.528  12.007 164.577  1.00 52.52           C  
ATOM    750  N   GLY   105       7.572   9.038 165.222  1.00 51.99           N  
ATOM    751  CA  GLY   105       6.611   7.951 165.088  1.00 52.42           C  
ATOM    752  C   GLY   105       5.192   8.281 164.726  1.00 51.41           C  
ATOM    753  O   GLY   105       4.281   7.504 165.013  1.00 52.46           O  
ATOM    754  N   TYR   106       5.022   9.381 164.007  1.00 49.01           N  
ATOM    755  CA  TYR   106       3.692   9.848 163.660  1.00 48.06           C  
ATOM    756  C   TYR   106       2.927   9.292 162.481  1.00 48.12           C  
ATOM    757  O   TYR   106       3.453   9.190 161.388  1.00 48.28           O  
ATOM    758  CB  TYR   106       3.704  11.371 163.567  1.00 46.71           C  
ATOM    759  CG  TYR   106       3.873  12.108 164.893  1.00 46.02           C  
ATOM    760  CD1 TYR   106       2.832  12.165 165.824  1.00 45.78           C  
ATOM    761  CD2 TYR   106       5.077  12.743 165.217  1.00 45.53           C  
ATOM    762  CE1 TYR   106       2.987  12.828 167.043  1.00 43.89           C  
ATOM    763  CE2 TYR   106       5.242  13.401 166.435  1.00 45.18           C  
ATOM    764  CZ  TYR   106       4.194  13.441 167.339  1.00 47.22           C  
ATOM    765  OH  TYR   106       4.358  14.096 168.537  1.00 44.15           O  
ATOM    766  N   SER   107       1.663   8.960 162.731  1.00 48.48           N  
ATOM    767  CA  SER   107       0.783   8.435 161.702  1.00 49.27           C  
ATOM    768  C   SER   107       0.425   9.539 160.706  1.00 49.37           C  
ATOM    769  O   SER   107       0.319  10.710 161.073  1.00 49.53           O  
ATOM    770  CB  SER   107      -0.491   7.870 162.342  1.00 49.50           C  
ATOM    771  OG  SER   107      -1.474   7.588 161.364  1.00 52.70           O  
ATOM    772  N   PRO   108       0.235   9.176 159.429  1.00 49.21           N  
ATOM    773  CA  PRO   108      -0.110  10.142 158.376  1.00 48.45           C  
ATOM    774  C   PRO   108      -1.477  10.785 158.603  1.00 47.09           C  
ATOM    775  O   PRO   108      -1.770  11.856 158.079  1.00 46.18           O  
ATOM    776  CB  PRO   108      -0.096   9.296 157.096  1.00 49.07           C  
ATOM    777  CG  PRO   108       0.786   8.137 157.438  1.00 48.53           C  
ATOM    778  CD  PRO   108       0.450   7.831 158.867  1.00 48.40           C  
ATOM    779  N   SER   109      -2.314  10.103 159.375  1.00 45.54           N  
ATOM    780  CA  SER   109      -3.663  10.569 159.685  1.00 44.50           C  
ATOM    781  C   SER   109      -3.706  11.769 160.631  1.00 43.25           C  
ATOM    782  O   SER   109      -4.730  12.445 160.743  1.00 42.75           O  
ATOM    783  CB  SER   109      -4.464   9.421 160.291  1.00 44.79           C  
ATOM    784  OG  SER   109      -3.645   8.662 161.166  1.00 45.92           O  
ATOM    785  N   ARG   110      -2.588  12.025 161.304  1.00 42.31           N  
ATOM    786  CA  ARG   110      -2.488  13.132 162.250  1.00 41.07           C  
ATOM    787  C   ARG   110      -2.082  14.447 161.587  1.00 40.37           C  
ATOM    788  O   ARG   110      -2.299  15.523 162.138  1.00 38.73           O  
ATOM    789  CB  ARG   110      -1.468  12.805 163.339  1.00 41.93           C  
ATOM    790  CG  ARG   110      -1.842  11.684 164.295  1.00 39.91           C  
ATOM    791  CD  ARG   110      -3.104  12.011 165.079  1.00 39.10           C  
ATOM    792  NE  ARG   110      -3.127  13.356 165.664  1.00 35.37           N  
ATOM    793  CZ  ARG   110      -2.421  13.741 166.723  1.00 36.20           C  
ATOM    794  NH1 ARG   110      -1.620  12.889 167.337  1.00 32.35           N  
ATOM    795  NH2 ARG   110      -2.556  14.974 167.196  1.00 34.00           N  
ATOM    796  N   VAL   111      -1.499  14.351 160.399  1.00 39.59           N  
ATOM    797  CA  VAL   111      -1.040  15.528 159.674  1.00 38.83           C  
ATOM    798  C   VAL   111      -1.701  15.708 158.309  1.00 38.15           C  
ATOM    799  O   VAL   111      -2.128  14.745 157.676  1.00 37.24           O  
ATOM    800  CB  VAL   111       0.491  15.488 159.473  1.00 38.00           C  
ATOM    801  CG1 VAL   111       0.929  16.615 158.551  1.00 42.01           C  
ATOM    802  CG2 VAL   111       1.206  15.614 160.820  1.00 38.16           C  
ATOM    803  N   ARG   112      -1.765  16.957 157.867  1.00 36.98           N  
ATOM    804  CA  ARG   112      -2.351  17.300 156.590  1.00 36.33           C  
ATOM    805  C   ARG   112      -1.513  18.435 156.001  1.00 35.66           C  
ATOM    806  O   ARG   112      -1.324  19.472 156.648  1.00 36.99           O  
ATOM    807  CB  ARG   112      -3.798  17.750 156.830  1.00 36.34           C  
ATOM    808  CG  ARG   112      -4.485  18.397 155.660  1.00 37.42           C  
ATOM    809  CD  ARG   112      -5.397  19.503 156.170  1.00 40.20           C  
ATOM    810  NE  ARG   112      -6.749  19.400 155.634  1.00 45.44           N  
ATOM    811  CZ  ARG   112      -7.756  20.191 155.991  1.00 48.74           C  
ATOM    812  NH1 ARG   112      -7.573  21.156 156.889  1.00 49.80           N  
ATOM    813  NH2 ARG   112      -8.947  20.016 155.443  1.00 49.68           N  
ATOM    814  N   PHE   113      -1.009  18.253 154.784  1.00 34.58           N  
ATOM    815  CA  PHE   113      -0.209  19.303 154.170  1.00 35.15           C  
ATOM    816  C   PHE   113      -0.932  19.949 152.991  1.00 35.07           C  
ATOM    817  O   PHE   113      -1.384  19.270 152.067  1.00 37.67           O  
ATOM    818  CB  PHE   113       1.151  18.766 153.708  1.00 34.40           C  
ATOM    819  CG  PHE   113       2.229  19.827 153.643  1.00 36.00           C  
ATOM    820  CD1 PHE   113       3.235  19.879 154.609  1.00 36.27           C  
ATOM    821  CD2 PHE   113       2.207  20.800 152.650  1.00 32.65           C  
ATOM    822  CE1 PHE   113       4.199  20.895 154.590  1.00 33.82           C  
ATOM    823  CE2 PHE   113       3.163  21.815 152.616  1.00 34.72           C  
ATOM    824  CZ  PHE   113       4.163  21.865 153.589  1.00 33.01           C  
ATOM    825  N   LEU   114      -1.054  21.268 153.029  1.00 35.24           N  
ATOM    826  CA  LEU   114      -1.704  21.989 151.942  1.00 35.75           C  
ATOM    827  C   LEU   114      -0.634  22.776 151.168  1.00 36.12           C  
ATOM    828  O   LEU   114      -0.129  23.802 151.642  1.00 33.29           O  
ATOM    829  CB  LEU   114      -2.781  22.950 152.484  1.00 35.98           C  
ATOM    830  CG  LEU   114      -3.800  22.374 153.479  1.00 35.98           C  
ATOM    831  CD1 LEU   114      -4.787  23.453 153.902  1.00 30.83           C  
ATOM    832  CD2 LEU   114      -4.537  21.206 152.840  1.00 37.70           C  
ATOM    833  N   LEU   115      -0.291  22.272 149.982  1.00 36.66           N  
ATOM    834  CA  LEU   115       0.698  22.896 149.101  1.00 36.42           C  
ATOM    835  C   LEU   115       0.067  24.159 148.511  1.00 37.94           C  
ATOM    836  O   LEU   115      -0.413  24.156 147.371  1.00 37.92           O  
ATOM    837  CB  LEU   115       1.058  21.957 147.946  1.00 36.58           C  
ATOM    838  CG  LEU   115       2.472  21.414 147.736  1.00 37.22           C  
ATOM    839  CD1 LEU   115       2.652  21.168 146.230  1.00 32.33           C  
ATOM    840  CD2 LEU   115       3.537  22.398 148.235  1.00 31.00           C  
ATOM    841  N   SER   116       0.089  25.248 149.270  1.00 38.17           N  
ATOM    842  CA  SER   116      -0.526  26.495 148.825  1.00 39.28           C  
ATOM    843  C   SER   116       0.103  27.704 149.496  1.00 41.12           C  
ATOM    844  O   SER   116       0.891  27.567 150.442  1.00 40.46           O  
ATOM    845  CB  SER   116      -2.007  26.513 149.183  1.00 40.19           C  
ATOM    846  OG  SER   116      -2.470  25.254 149.656  1.00 42.22           O  
ATOM    847  N   ARG   117      -0.255  28.884 149.007  1.00 41.80           N  
ATOM    848  CA  ARG   117       0.210  30.105 149.614  1.00 42.60           C  
ATOM    849  C   ARG   117      -0.825  30.243 150.739  1.00 40.98           C  
ATOM    850  O   ARG   117      -2.039  30.078 150.529  1.00 41.28           O  
ATOM    851  CB  ARG   117       0.122  31.272 148.622  1.00 43.51           C  
ATOM    852  CG  ARG   117       0.859  30.961 147.339  1.00 49.76           C  
ATOM    853  CD  ARG   117       0.563  31.978 146.265  1.00 60.03           C  
ATOM    854  NE  ARG   117       0.982  33.320 146.662  1.00 67.32           N  
ATOM    855  CZ  ARG   117       1.017  34.367 145.842  1.00 67.66           C  
ATOM    856  NH1 ARG   117       0.659  34.231 144.571  1.00 67.92           N  
ATOM    857  NH2 ARG   117       1.413  35.550 146.293  1.00 68.00           N  
ATOM    858  N   PRO   118      -0.364  30.529 151.957  1.00 41.33           N  
ATOM    859  CA  PRO   118      -1.223  30.686 153.140  1.00 40.61           C  
ATOM    860  C   PRO   118      -2.504  31.479 152.927  1.00 39.64           C  
ATOM    861  O   PRO   118      -3.607  30.990 153.181  1.00 39.78           O  
ATOM    862  CB  PRO   118      -0.316  31.394 154.142  1.00 40.65           C  
ATOM    863  CG  PRO   118       1.041  30.954 153.775  1.00 41.68           C  
ATOM    864  CD  PRO   118       1.033  30.880 152.272  1.00 40.50           C  
ATOM    865  N   LEU   119      -2.343  32.715 152.460  1.00 41.33           N  
ATOM    866  CA  LEU   119      -3.471  33.595 152.279  1.00 43.36           C  
ATOM    867  C   LEU   119      -4.460  33.221 151.192  1.00 43.28           C  
ATOM    868  O   LEU   119      -5.565  33.763 151.135  1.00 43.18           O  
ATOM    869  CB  LEU   119      -2.962  35.032 152.110  1.00 44.68           C  
ATOM    870  CG  LEU   119      -2.149  35.568 153.306  1.00 47.79           C  
ATOM    871  CD1 LEU   119      -1.613  36.954 152.971  1.00 48.36           C  
ATOM    872  CD2 LEU   119      -3.017  35.620 154.562  1.00 48.43           C  
ATOM    873  N   ASP   120      -4.069  32.285 150.344  1.00 42.99           N  
ATOM    874  CA  ASP   120      -4.950  31.832 149.284  1.00 43.56           C  
ATOM    875  C   ASP   120      -5.859  30.709 149.778  1.00 42.46           C  
ATOM    876  O   ASP   120      -7.049  30.704 149.496  1.00 42.73           O  
ATOM    877  CB  ASP   120      -4.136  31.320 148.091  1.00 45.08           C  
ATOM    878  CG  ASP   120      -3.630  32.435 147.194  1.00 47.02           C  
ATOM    879  OD1 ASP   120      -2.502  32.322 146.665  1.00 52.57           O  
ATOM    880  OD2 ASP   120      -4.368  33.418 147.002  1.00 54.08           O  
ATOM    881  N   VAL   121      -5.295  29.775 150.541  1.00 41.31           N  
ATOM    882  CA  VAL   121      -6.037  28.611 151.013  1.00 39.94           C  
ATOM    883  C   VAL   121      -6.808  28.725 152.327  1.00 40.84           C  
ATOM    884  O   VAL   121      -7.690  27.907 152.604  1.00 38.80           O  
ATOM    885  CB  VAL   121      -5.094  27.400 151.086  1.00 39.13           C  
ATOM    886  CG1 VAL   121      -4.188  27.521 152.303  1.00 37.68           C  
ATOM    887  CG2 VAL   121      -5.882  26.106 151.110  1.00 37.94           C  
ATOM    888  N   MET   122      -6.475  29.722 153.134  1.00 42.29           N  
ATOM    889  CA  MET   122      -7.166  29.906 154.395  1.00 43.80           C  
ATOM    890  C   MET   122      -8.616  30.270 154.106  1.00 44.00           C  
ATOM    891  O   MET   122      -9.498  30.116 154.952  1.00 42.06           O  
ATOM    892  CB  MET   122      -6.466  30.986 155.225  1.00 44.01           C  
ATOM    893  CG  MET   122      -5.380  30.396 156.117  1.00 49.56           C  
ATOM    894  SD  MET   122      -4.119  31.725 156.693  1.00 61.27          SE  
ATOM    895  CE  MET   122      -2.501  30.840 156.177  1.00 61.36           C  
ATOM    896  N   SER   123      -8.852  30.740 152.885  1.00 45.14           N  
ATOM    897  CA  SER   123     -10.192  31.101 152.429  1.00 44.45           C  
ATOM    898  C   SER   123     -11.012  29.812 152.270  1.00 42.51           C  
ATOM    899  O   SER   123     -12.239  29.841 152.214  1.00 42.47           O  
ATOM    900  CB  SER   123     -10.104  31.792 151.072  1.00 44.03           C  
ATOM    901  OG  SER   123     -11.332  32.400 150.721  1.00 50.55           O  
ATOM    902  N   ARG   124     -10.320  28.682 152.204  1.00 39.98           N  
ATOM    903  CA  ARG   124     -10.938  27.375 151.993  1.00 39.77           C  
ATOM    904  C   ARG   124     -11.079  26.481 153.218  1.00 39.26           C  
ATOM    905  O   ARG   124     -11.430  25.302 153.091  1.00 38.53           O  
ATOM    906  CB  ARG   124     -10.144  26.624 150.927  1.00 39.41           C  
ATOM    907  CG  ARG   124     -10.516  26.921 149.478  1.00 39.67           C  
ATOM    908  CD  ARG   124     -10.214  28.346 149.054  1.00 34.87           C  
ATOM    909  NE  ARG   124     -10.183  28.446 147.599  1.00 37.32           N  
ATOM    910  CZ  ARG   124     -10.506  29.535 146.908  1.00 38.08           C  
ATOM    911  NH1 ARG   124     -10.895  30.633 147.538  1.00 40.47           N  
ATOM    912  NH2 ARG   124     -10.456  29.519 145.584  1.00 35.95           N  
ATOM    913  N   LEU   125     -10.807  27.038 154.392  1.00 38.20           N  
ATOM    914  CA  LEU   125     -10.896  26.266 155.616  1.00 37.17           C  
ATOM    915  C   LEU   125     -12.133  26.675 156.405  1.00 35.40           C  
ATOM    916  O   LEU   125     -12.668  27.759 156.217  1.00 35.38           O  
ATOM    917  CB  LEU   125      -9.612  26.457 156.446  1.00 36.51           C  
ATOM    918  CG  LEU   125      -8.289  26.098 155.744  1.00 34.19           C  
ATOM    919  CD1 LEU   125      -7.122  26.588 156.596  1.00 35.46           C  
ATOM    920  CD2 LEU   125      -8.189  24.592 155.505  1.00 33.35           C  
ATOM    921  N   ALA   126     -12.583  25.798 157.291  1.00 36.45           N  
ATOM    922  CA  ALA   126     -13.782  26.061 158.076  1.00 37.46           C  
ATOM    923  C   ALA   126     -13.588  27.043 159.223  1.00 37.94           C  
ATOM    924  O   ALA   126     -12.660  26.912 160.014  1.00 36.91           O  
ATOM    925  CB  ALA   126     -14.351  24.735 158.604  1.00 38.14           C  
ATOM    926  N   ASN   127     -14.479  28.026 159.299  1.00 37.51           N  
ATOM    927  CA  ASN   127     -14.436  29.028 160.357  1.00 39.25           C  
ATOM    928  C   ASN   127     -14.698  28.410 161.736  1.00 38.25           C  
ATOM    929  O   ASN   127     -15.415  27.410 161.853  1.00 37.89           O  
ATOM    930  CB  ASN   127     -15.499  30.104 160.130  1.00 38.20           C  
ATOM    931  CG  ASN   127     -15.109  31.115 159.077  1.00 45.54           C  
ATOM    932  OD1 ASN   127     -13.925  31.365 158.846  1.00 47.80           O  
ATOM    933  ND2 ASN   127     -16.114  31.728 158.440  1.00 50.71           N  
ATOM    934  N   ASP   128     -14.100  28.996 162.773  1.00 39.07           N  
ATOM    935  CA  ASP   128     -14.333  28.545 164.147  1.00 39.00           C  
ATOM    936  C   ASP   128     -14.037  27.068 164.369  1.00 37.42           C  
ATOM    937  O   ASP   128     -14.761  26.386 165.099  1.00 36.97           O  
ATOM    938  CB  ASP   128     -15.802  28.840 164.494  1.00 40.06           C  
ATOM    939  CG  ASP   128     -16.097  28.760 165.988  1.00 42.55           C  
ATOM    940  OD1 ASP   128     -15.284  29.278 166.781  1.00 42.74           O  
ATOM    941  OD2 ASP   128     -17.152  28.195 166.370  1.00 38.11           O  
ATOM    942  N   SER   129     -12.967  26.573 163.763  1.00 35.37           N  
ATOM    943  CA  SER   129     -12.636  25.160 163.890  1.00 34.54           C  
ATOM    944  C   SER   129     -11.245  24.857 164.426  1.00 31.43           C  
ATOM    945  O   SER   129     -10.918  23.699 164.679  1.00 32.63           O  
ATOM    946  CB  SER   129     -12.782  24.477 162.536  1.00 35.03           C  
ATOM    947  OG  SER   129     -14.099  24.034 162.294  1.00 37.23           O  
ATOM    948  N   TYR   130     -10.431  25.884 164.620  1.00 29.68           N  
ATOM    949  CA  TYR   130      -9.071  25.668 165.066  1.00 28.67           C  
ATOM    950  C   TYR   130      -8.751  26.269 166.423  1.00 28.72           C  
ATOM    951  O   TYR   130      -9.163  27.382 166.738  1.00 29.68           O  
ATOM    952  CB  TYR   130      -8.121  26.196 163.986  1.00 28.26           C  
ATOM    953  CG  TYR   130      -8.274  25.464 162.664  1.00 29.26           C  
ATOM    954  CD1 TYR   130      -7.600  24.263 162.430  1.00 29.35           C  
ATOM    955  CD2 TYR   130      -9.172  25.915 161.692  1.00 28.46           C  
ATOM    956  CE1 TYR   130      -7.803  23.531 161.259  1.00 26.56           C  
ATOM    957  CE2 TYR   130      -9.386  25.194 160.518  1.00 29.12           C  
ATOM    958  CZ  TYR   130      -8.700  23.994 160.313  1.00 29.08           C  
ATOM    959  OH  TYR   130      -8.905  23.276 159.154  1.00 27.26           O  
ATOM    960  N   GLN   131      -7.995  25.514 167.214  1.00 28.03           N  
ATOM    961  CA  GLN   131      -7.601  25.922 168.557  1.00 27.77           C  
ATOM    962  C   GLN   131      -6.230  26.599 168.607  1.00 27.85           C  
ATOM    963  O   GLN   131      -5.884  27.249 169.598  1.00 29.71           O  
ATOM    964  CB  GLN   131      -7.569  24.700 169.472  1.00 26.77           C  
ATOM    965  CG  GLN   131      -6.362  23.790 169.188  1.00 26.44           C  
ATOM    966  CD  GLN   131      -6.491  22.396 169.781  1.00 24.98           C  
ATOM    967  OE1 GLN   131      -5.943  22.106 170.843  1.00 24.78           O  
ATOM    968  NE2 GLN   131      -7.231  21.533 169.101  1.00 20.94           N  
ATOM    969  N   LEU   132      -5.446  26.448 167.546  1.00 27.47           N  
ATOM    970  CA  LEU   132      -4.105  27.023 167.532  1.00 26.57           C  
ATOM    971  C   LEU   132      -3.590  27.236 166.115  1.00 27.51           C  
ATOM    972  O   LEU   132      -3.679  26.349 165.264  1.00 29.60           O  
ATOM    973  CB  LEU   132      -3.137  26.104 168.301  1.00 25.75           C  
ATOM    974  CG  LEU   132      -1.629  26.415 168.296  1.00 29.37           C  
ATOM    975  CD1 LEU   132      -1.363  27.685 169.099  1.00 27.98           C  
ATOM    976  CD2 LEU   132      -0.842  25.243 168.885  1.00 27.03           C  
ATOM    977  N   VAL   133      -3.055  28.424 165.864  1.00 26.58           N  
ATOM    978  CA  VAL   133      -2.498  28.739 164.566  1.00 25.15           C  
ATOM    979  C   VAL   133      -1.139  29.410 164.763  1.00 26.35           C  
ATOM    980  O   VAL   133      -1.017  30.422 165.456  1.00 26.47           O  
ATOM    981  CB  VAL   133      -3.439  29.670 163.752  1.00 25.87           C  
ATOM    982  CG1 VAL   133      -2.807  30.010 162.398  1.00 25.01           C  
ATOM    983  CG2 VAL   133      -4.791  28.987 163.550  1.00 20.36           C  
ATOM    984  N   PHE   134      -0.113  28.818 164.169  1.00 25.32           N  
ATOM    985  CA  PHE   134       1.234  29.356 164.232  1.00 26.86           C  
ATOM    986  C   PHE   134       1.555  29.901 162.847  1.00 27.34           C  
ATOM    987  O   PHE   134       1.374  29.218 161.827  1.00 28.20           O  
ATOM    988  CB  PHE   134       2.266  28.275 164.582  1.00 26.10           C  
ATOM    989  CG  PHE   134       3.687  28.747 164.450  1.00 25.49           C  
ATOM    990  CD1 PHE   134       4.311  29.429 165.490  1.00 24.26           C  
ATOM    991  CD2 PHE   134       4.389  28.539 163.263  1.00 29.08           C  
ATOM    992  CE1 PHE   134       5.619  29.914 165.342  1.00 28.36           C  
ATOM    993  CE2 PHE   134       5.692  29.020 163.101  1.00 32.22           C  
ATOM    994  CZ  PHE   134       6.312  29.704 164.146  1.00 32.15           C  
ATOM    995  N   GLY   135       2.023  31.142 162.815  1.00 28.79           N  
ATOM    996  CA  GLY   135       2.375  31.753 161.551  1.00 28.63           C  
ATOM    997  C   GLY   135       3.800  32.285 161.495  1.00 29.23           C  
ATOM    998  O   GLY   135       4.256  32.988 162.400  1.00 26.26           O  
ATOM    999  N   GLN   136       4.525  31.894 160.454  1.00 30.13           N  
ATOM   1000  CA  GLN   136       5.876  32.386 160.239  1.00 33.40           C  
ATOM   1001  C   GLN   136       5.803  33.029 158.850  1.00 35.44           C  
ATOM   1002  O   GLN   136       5.966  32.367 157.820  1.00 36.80           O  
ATOM   1003  CB  GLN   136       6.918  31.255 160.234  1.00 32.41           C  
ATOM   1004  CG  GLN   136       8.323  31.769 159.955  1.00 33.06           C  
ATOM   1005  CD  GLN   136       9.078  32.162 161.210  1.00 33.64           C  
ATOM   1006  OE1 GLN   136       9.444  33.324 161.394  1.00 35.68           O  
ATOM   1007  NE2 GLN   136       9.320  31.192 162.080  1.00 29.90           N  
ATOM   1008  N   VAL   137       5.562  34.331 158.825  1.00 36.19           N  
ATOM   1009  CA  VAL   137       5.419  35.064 157.572  1.00 38.42           C  
ATOM   1010  C   VAL   137       6.248  36.342 157.564  1.00 41.25           C  
ATOM   1011  O   VAL   137       6.896  36.680 158.560  1.00 41.64           O  
ATOM   1012  CB  VAL   137       3.930  35.432 157.329  1.00 36.88           C  
ATOM   1013  CG1 VAL   137       3.080  34.166 157.285  1.00 34.48           C  
ATOM   1014  CG2 VAL   137       3.421  36.348 158.450  1.00 35.11           C  
ATOM   1015  N   SER   138       6.228  37.044 156.433  1.00 41.77           N  
ATOM   1016  CA  SER   138       6.941  38.307 156.320  1.00 41.93           C  
ATOM   1017  C   SER   138       6.078  39.351 157.022  1.00 41.25           C  
ATOM   1018  O   SER   138       4.846  39.232 157.063  1.00 40.59           O  
ATOM   1019  CB  SER   138       7.123  38.712 154.859  1.00 42.90           C  
ATOM   1020  OG  SER   138       8.000  37.823 154.205  1.00 48.55           O  
ATOM   1021  N   PRO   139       6.712  40.382 157.589  1.00 42.32           N  
ATOM   1022  CA  PRO   139       6.007  41.457 158.292  1.00 43.29           C  
ATOM   1023  C   PRO   139       4.924  42.111 157.442  1.00 45.67           C  
ATOM   1024  O   PRO   139       3.968  42.681 157.974  1.00 46.01           O  
ATOM   1025  CB  PRO   139       7.131  42.436 158.684  1.00 43.98           C  
ATOM   1026  CG  PRO   139       8.358  41.958 157.932  1.00 42.13           C  
ATOM   1027  CD  PRO   139       8.170  40.487 157.766  1.00 41.37           C  
ATOM   1028  N   MET   140       5.071  42.035 156.123  1.00 47.45           N  
ATOM   1029  CA  MET   140       4.076  42.638 155.239  1.00 49.28           C  
ATOM   1030  C   MET   140       2.823  41.772 155.122  1.00 47.01           C  
ATOM   1031  O   MET   140       1.779  42.231 154.660  1.00 47.15           O  
ATOM   1032  CB  MET   140       4.690  42.930 153.855  1.00 51.82           C  
ATOM   1033  CG  MET   140       5.654  44.141 153.862  1.00 59.82           C  
ATOM   1034  SD  MET   140       5.021  45.728 152.904  1.00 78.54          SE  
ATOM   1035  CE  MET   140       3.104  45.465 153.043  1.00 71.46           C  
ATOM   1036  N   ASP   141       2.921  40.519 155.556  1.00 44.94           N  
ATOM   1037  CA  ASP   141       1.783  39.606 155.512  1.00 41.78           C  
ATOM   1038  C   ASP   141       1.064  39.456 156.859  1.00 40.48           C  
ATOM   1039  O   ASP   141      -0.003  38.844 156.926  1.00 39.11           O  
ATOM   1040  CB  ASP   141       2.233  38.221 155.051  1.00 42.04           C  
ATOM   1041  CG  ASP   141       2.523  38.160 153.568  1.00 43.17           C  
ATOM   1042  OD1 ASP   141       1.754  38.773 152.809  1.00 41.63           O  
ATOM   1043  OD2 ASP   141       3.497  37.487 153.159  1.00 43.95           O  
ATOM   1044  N   LEU   142       1.630  40.029 157.922  1.00 40.15           N  
ATOM   1045  CA  LEU   142       1.058  39.873 159.259  1.00 39.48           C  
ATOM   1046  C   LEU   142      -0.394  40.231 159.457  1.00 39.93           C  
ATOM   1047  O   LEU   142      -1.167  39.431 159.997  1.00 40.66           O  
ATOM   1048  CB  LEU   142       1.924  40.590 160.300  1.00 38.67           C  
ATOM   1049  CG  LEU   142       3.300  39.975 160.600  1.00 38.68           C  
ATOM   1050  CD1 LEU   142       4.112  40.933 161.458  1.00 42.38           C  
ATOM   1051  CD2 LEU   142       3.129  38.637 161.311  1.00 38.58           C  
ATOM   1052  N   LYS   143      -0.757  41.420 159.004  1.00 38.96           N  
ATOM   1053  CA  LYS   143      -2.117  41.903 159.110  1.00 39.51           C  
ATOM   1054  C   LYS   143      -3.068  40.971 158.364  1.00 39.15           C  
ATOM   1055  O   LYS   143      -4.116  40.575 158.884  1.00 40.10           O  
ATOM   1056  CB  LYS   143      -2.215  43.303 158.502  1.00 40.31           C  
ATOM   1057  CG  LYS   143      -3.030  44.294 159.323  1.00 43.90           C  
ATOM   1058  CD  LYS   143      -4.008  45.096 158.470  1.00 49.29           C  
ATOM   1059  CE  LYS   143      -5.421  44.522 158.568  1.00 53.76           C  
ATOM   1060  NZ  LYS   143      -6.429  45.319 157.813  1.00 56.00           N  
ATOM   1061  N   ALA   144      -2.700  40.623 157.138  1.00 39.14           N  
ATOM   1062  CA  ALA   144      -3.530  39.752 156.316  1.00 38.68           C  
ATOM   1063  C   ALA   144      -3.670  38.382 156.968  1.00 38.00           C  
ATOM   1064  O   ALA   144      -4.731  37.759 156.900  1.00 38.66           O  
ATOM   1065  CB  ALA   144      -2.929  39.621 154.911  1.00 37.15           C  
ATOM   1066  N   LEU   145      -2.602  37.918 157.611  1.00 37.83           N  
ATOM   1067  CA  LEU   145      -2.646  36.621 158.263  1.00 37.23           C  
ATOM   1068  C   LEU   145      -3.621  36.667 159.451  1.00 37.14           C  
ATOM   1069  O   LEU   145      -4.358  35.707 159.691  1.00 36.62           O  
ATOM   1070  CB  LEU   145      -1.235  36.188 158.718  1.00 36.77           C  
ATOM   1071  CG  LEU   145      -1.168  34.756 159.271  1.00 39.44           C  
ATOM   1072  CD1 LEU   145      -1.620  33.766 158.186  1.00 37.20           C  
ATOM   1073  CD2 LEU   145       0.252  34.435 159.742  1.00 35.79           C  
ATOM   1074  N   VAL   146      -3.629  37.782 160.184  1.00 37.71           N  
ATOM   1075  CA  VAL   146      -4.521  37.956 161.337  1.00 37.17           C  
ATOM   1076  C   VAL   146      -5.980  37.944 160.885  1.00 38.38           C  
ATOM   1077  O   VAL   146      -6.835  37.306 161.498  1.00 37.63           O  
ATOM   1078  CB  VAL   146      -4.253  39.297 162.050  1.00 36.80           C  
ATOM   1079  CG1 VAL   146      -5.205  39.467 163.214  1.00 35.48           C  
ATOM   1080  CG2 VAL   146      -2.811  39.358 162.525  1.00 37.51           C  
ATOM   1081  N   ASP   147      -6.256  38.672 159.807  1.00 39.95           N  
ATOM   1082  CA  ASP   147      -7.606  38.754 159.260  1.00 38.92           C  
ATOM   1083  C   ASP   147      -8.037  37.403 158.725  1.00 38.35           C  
ATOM   1084  O   ASP   147      -9.206  37.036 158.812  1.00 42.00           O  
ATOM   1085  CB  ASP   147      -7.668  39.792 158.136  1.00 40.05           C  
ATOM   1086  CG  ASP   147      -7.366  41.190 158.624  1.00 41.34           C  
ATOM   1087  OD1 ASP   147      -7.807  41.532 159.743  1.00 43.67           O  
ATOM   1088  OD2 ASP   147      -6.697  41.948 157.892  1.00 43.65           O  
ATOM   1089  N   ALA   148      -7.085  36.658 158.171  1.00 36.95           N  
ATOM   1090  CA  ALA   148      -7.374  35.335 157.625  1.00 34.18           C  
ATOM   1091  C   ALA   148      -7.538  34.295 158.726  1.00 34.08           C  
ATOM   1092  O   ALA   148      -8.441  33.463 158.683  1.00 31.80           O  
ATOM   1093  CB  ALA   148      -6.259  34.907 156.667  1.00 33.64           C  
ATOM   1094  N   ALA   149      -6.658  34.343 159.716  1.00 33.69           N  
ATOM   1095  CA  ALA   149      -6.696  33.377 160.798  1.00 33.43           C  
ATOM   1096  C   ALA   149      -7.799  33.579 161.834  1.00 33.55           C  
ATOM   1097  O   ALA   149      -8.396  32.609 162.312  1.00 34.44           O  
ATOM   1098  CB  ALA   149      -5.327  33.330 161.489  1.00 34.63           C  
ATOM   1099  N   TRP   150      -8.088  34.830 162.172  1.00 35.02           N  
ATOM   1100  CA  TRP   150      -9.084  35.104 163.208  1.00 35.52           C  
ATOM   1101  C   TRP   150     -10.392  34.341 163.089  1.00 36.07           C  
ATOM   1102  O   TRP   150     -10.829  33.698 164.051  1.00 36.77           O  
ATOM   1103  CB  TRP   150      -9.368  36.609 163.312  1.00 36.87           C  
ATOM   1104  CG  TRP   150      -9.881  37.006 164.678  1.00 39.34           C  
ATOM   1105  CD1 TRP   150     -11.103  37.530 164.976  1.00 38.91           C  
ATOM   1106  CD2 TRP   150      -9.185  36.875 165.928  1.00 38.85           C  
ATOM   1107  NE1 TRP   150     -11.213  37.738 166.333  1.00 40.42           N  
ATOM   1108  CE2 TRP   150     -10.049  37.348 166.940  1.00 39.56           C  
ATOM   1109  CE3 TRP   150      -7.910  36.414 166.288  1.00 40.01           C  
ATOM   1110  CZ2 TRP   150      -9.686  37.359 168.296  1.00 38.56           C  
ATOM   1111  CZ3 TRP   150      -7.546  36.428 167.635  1.00 41.47           C  
ATOM   1112  CH2 TRP   150      -8.431  36.904 168.620  1.00 41.64           C  
ATOM   1113  N   PRO   151     -11.030  34.386 161.912  1.00 36.28           N  
ATOM   1114  CA  PRO   151     -12.297  33.668 161.748  1.00 36.18           C  
ATOM   1115  C   PRO   151     -12.183  32.164 161.992  1.00 34.50           C  
ATOM   1116  O   PRO   151     -13.130  31.534 162.451  1.00 34.71           O  
ATOM   1117  CB  PRO   151     -12.690  33.958 160.295  1.00 37.11           C  
ATOM   1118  CG  PRO   151     -11.968  35.221 159.959  1.00 37.77           C  
ATOM   1119  CD  PRO   151     -10.652  35.100 160.679  1.00 35.64           C  
ATOM   1120  N   LEU   152     -11.022  31.593 161.679  1.00 34.79           N  
ATOM   1121  CA  LEU   152     -10.801  30.153 161.836  1.00 35.06           C  
ATOM   1122  C   LEU   152     -10.602  29.733 163.289  1.00 34.90           C  
ATOM   1123  O   LEU   152     -10.874  28.596 163.669  1.00 35.83           O  
ATOM   1124  CB  LEU   152      -9.588  29.721 161.011  1.00 35.31           C  
ATOM   1125  CG  LEU   152      -9.532  30.146 159.535  1.00 32.06           C  
ATOM   1126  CD1 LEU   152      -8.139  29.863 158.949  1.00 28.65           C  
ATOM   1127  CD2 LEU   152     -10.608  29.410 158.747  1.00 30.78           C  
ATOM   1128  N   LEU   153     -10.130  30.668 164.101  1.00 36.20           N  
ATOM   1129  CA  LEU   153      -9.865  30.413 165.514  1.00 35.55           C  
ATOM   1130  C   LEU   153     -11.086  30.273 166.380  1.00 35.15           C  
ATOM   1131  O   LEU   153     -12.043  31.021 166.223  1.00 36.38           O  
ATOM   1132  CB  LEU   153      -9.014  31.525 166.110  1.00 34.73           C  
ATOM   1133  CG  LEU   153      -7.490  31.460 166.042  1.00 35.40           C  
ATOM   1134  CD1 LEU   153      -6.906  32.700 166.722  1.00 37.52           C  
ATOM   1135  CD2 LEU   153      -6.991  30.175 166.744  1.00 23.36           C  
ATOM   1136  N   ARG   154     -11.058  29.310 167.296  1.00 36.30           N  
ATOM   1137  CA  ARG   154     -12.162  29.145 168.232  1.00 36.51           C  
ATOM   1138  C   ARG   154     -11.818  30.000 169.474  1.00 36.76           C  
ATOM   1139  O   ARG   154     -10.651  30.379 169.676  1.00 33.72           O  
ATOM   1140  CB  ARG   154     -12.319  27.674 168.634  1.00 36.75           C  
ATOM   1141  CG  ARG   154     -12.718  26.785 167.478  1.00 37.06           C  
ATOM   1142  CD  ARG   154     -12.577  25.313 167.811  1.00 37.83           C  
ATOM   1143  NE  ARG   154     -13.585  24.850 168.759  1.00 45.05           N  
ATOM   1144  CZ  ARG   154     -14.877  24.707 168.473  1.00 47.28           C  
ATOM   1145  NH1 ARG   154     -15.331  24.991 167.257  1.00 41.82           N  
ATOM   1146  NH2 ARG   154     -15.710  24.265 169.404  1.00 47.48           N  
ATOM   1147  N   ARG   155     -12.823  30.308 170.295  1.00 37.44           N  
ATOM   1148  CA  ARG   155     -12.610  31.086 171.514  1.00 37.17           C  
ATOM   1149  C   ARG   155     -11.747  30.192 172.403  1.00 35.22           C  
ATOM   1150  O   ARG   155     -11.978  28.975 172.493  1.00 36.48           O  
ATOM   1151  CB  ARG   155     -13.961  31.403 172.183  1.00 38.81           C  
ATOM   1152  CG  ARG   155     -14.937  32.087 171.233  1.00 42.34           C  
ATOM   1153  CD  ARG   155     -16.218  32.427 171.953  1.00 47.96           C  
ATOM   1154  NE  ARG   155     -16.064  33.616 172.784  1.00 54.25           N  
ATOM   1155  CZ  ARG   155     -16.418  34.843 172.409  1.00 56.26           C  
ATOM   1156  NH1 ARG   155     -16.953  35.045 171.210  1.00 56.53           N  
ATOM   1157  NH2 ARG   155     -16.230  35.868 173.234  1.00 56.32           N  
ATOM   1158  N   GLY   156     -10.764  30.799 173.062  1.00 32.13           N  
ATOM   1159  CA  GLY   156      -9.822  30.049 173.880  1.00 30.79           C  
ATOM   1160  C   GLY   156      -8.670  29.644 172.940  1.00 29.86           C  
ATOM   1161  O   GLY   156      -7.673  29.034 173.361  1.00 28.96           O  
ATOM   1162  N   GLY   157      -8.795  30.009 171.657  1.00 28.58           N  
ATOM   1163  CA  GLY   157      -7.783  29.685 170.652  1.00 26.53           C  
ATOM   1164  C   GLY   157      -6.719  30.750 170.521  1.00 26.35           C  
ATOM   1165  O   GLY   157      -6.981  31.934 170.724  1.00 26.49           O  
ATOM   1166  N   ALA   158      -5.517  30.330 170.143  1.00 26.28           N  
ATOM   1167  CA  ALA   158      -4.402  31.253 170.021  1.00 26.53           C  
ATOM   1168  C   ALA   158      -3.752  31.338 168.663  1.00 27.37           C  
ATOM   1169  O   ALA   158      -3.498  30.317 168.023  1.00 27.64           O  
ATOM   1170  CB  ALA   158      -3.333  30.924 171.057  1.00 24.38           C  
ATOM   1171  N   LEU   159      -3.468  32.568 168.245  1.00 28.32           N  
ATOM   1172  CA  LEU   159      -2.747  32.823 167.013  1.00 28.11           C  
ATOM   1173  C   LEU   159      -1.342  33.223 167.503  1.00 27.21           C  
ATOM   1174  O   LEU   159      -1.189  34.162 168.296  1.00 26.79           O  
ATOM   1175  CB  LEU   159      -3.371  33.994 166.234  1.00 28.52           C  
ATOM   1176  CG  LEU   159      -2.577  34.518 165.030  1.00 31.81           C  
ATOM   1177  CD1 LEU   159      -2.417  33.424 163.973  1.00 33.87           C  
ATOM   1178  CD2 LEU   159      -3.322  35.715 164.451  1.00 31.17           C  
ATOM   1179  N   VAL   160      -0.322  32.501 167.047  1.00 25.88           N  
ATOM   1180  CA  VAL   160       1.064  32.772 167.428  1.00 24.79           C  
ATOM   1181  C   VAL   160       1.858  33.296 166.232  1.00 27.75           C  
ATOM   1182  O   VAL   160       2.033  32.591 165.232  1.00 26.63           O  
ATOM   1183  CB  VAL   160       1.738  31.501 167.987  1.00 24.17           C  
ATOM   1184  CG1 VAL   160       3.150  31.821 168.438  1.00 23.11           C  
ATOM   1185  CG2 VAL   160       0.923  30.964 169.163  1.00 19.43           C  
ATOM   1186  N   LEU   161       2.338  34.537 166.340  1.00 29.92           N  
ATOM   1187  CA  LEU   161       3.088  35.183 165.258  1.00 31.39           C  
ATOM   1188  C   LEU   161       4.569  35.347 165.580  1.00 33.08           C  
ATOM   1189  O   LEU   161       4.957  36.203 166.376  1.00 32.56           O  
ATOM   1190  CB  LEU   161       2.467  36.550 164.943  1.00 31.04           C  
ATOM   1191  CG  LEU   161       0.954  36.513 164.655  1.00 29.82           C  
ATOM   1192  CD1 LEU   161       0.395  37.937 164.570  1.00 26.88           C  
ATOM   1193  CD2 LEU   161       0.693  35.749 163.363  1.00 26.34           C  
ATOM   1194  N   ALA   162       5.394  34.522 164.946  1.00 33.46           N  
ATOM   1195  CA  ALA   162       6.841  34.557 165.155  1.00 35.04           C  
ATOM   1196  C   ALA   162       7.519  35.821 164.628  1.00 36.17           C  
ATOM   1197  O   ALA   162       7.108  36.373 163.604  1.00 36.48           O  
ATOM   1198  CB  ALA   162       7.484  33.337 164.511  1.00 35.01           C  
ATOM   1199  N   ASP   163       8.559  36.260 165.343  1.00 35.67           N  
ATOM   1200  CA  ASP   163       9.367  37.428 164.980  1.00 35.23           C  
ATOM   1201  C   ASP   163       8.577  38.664 164.556  1.00 34.80           C  
ATOM   1202  O   ASP   163       9.082  39.491 163.803  1.00 37.18           O  
ATOM   1203  CB  ASP   163      10.324  37.063 163.848  1.00 36.36           C  
ATOM   1204  CG  ASP   163      11.103  35.796 164.126  1.00 38.68           C  
ATOM   1205  OD1 ASP   163      11.514  35.602 165.286  1.00 41.88           O  
ATOM   1206  OD2 ASP   163      11.319  34.996 163.186  1.00 44.47           O  
ATOM   1207  N   ALA   164       7.352  38.800 165.048  1.00 34.25           N  
ATOM   1208  CA  ALA   164       6.485  39.911 164.677  1.00 35.10           C  
ATOM   1209  C   ALA   164       6.843  41.287 165.218  1.00 37.45           C  
ATOM   1210  O   ALA   164       6.275  42.297 164.783  1.00 36.35           O  
ATOM   1211  CB  ALA   164       5.058  39.579 165.062  1.00 34.18           C  
ATOM   1212  N   LEU   165       7.782  41.327 166.155  1.00 38.68           N  
ATOM   1213  CA  LEU   165       8.179  42.576 166.783  1.00 41.51           C  
ATOM   1214  C   LEU   165       9.527  43.091 166.299  1.00 43.63           C  
ATOM   1215  O   LEU   165       9.965  44.174 166.688  1.00 44.67           O  
ATOM   1216  CB  LEU   165       8.215  42.389 168.300  1.00 40.59           C  
ATOM   1217  CG  LEU   165       6.898  42.048 169.005  1.00 37.73           C  
ATOM   1218  CD1 LEU   165       7.169  41.504 170.401  1.00 39.58           C  
ATOM   1219  CD2 LEU   165       6.026  43.291 169.080  1.00 42.32           C  
ATOM   1220  N   LEU   166      10.172  42.306 165.446  1.00 46.20           N  
ATOM   1221  CA  LEU   166      11.477  42.650 164.900  1.00 47.74           C  
ATOM   1222  C   LEU   166      12.459  43.155 165.952  1.00 49.34           C  
ATOM   1223  O   LEU   166      13.031  44.241 165.822  1.00 48.89           O  
ATOM   1224  CB  LEU   166      11.326  43.671 163.760  1.00 47.18           C  
ATOM   1225  CG  LEU   166      10.589  43.140 162.518  1.00 47.23           C  
ATOM   1226  CD1 LEU   166      10.505  44.215 161.444  1.00 48.55           C  
ATOM   1227  CD2 LEU   166      11.325  41.922 161.986  1.00 48.26           C  
ATOM   1228  N   ASP   167      12.632  42.357 167.004  1.00 51.27           N  
ATOM   1229  CA  ASP   167      13.570  42.673 168.073  1.00 52.31           C  
ATOM   1230  C   ASP   167      13.333  44.014 168.764  1.00 53.19           C  
ATOM   1231  O   ASP   167      14.231  44.548 169.422  1.00 53.46           O  
ATOM   1232  CB  ASP   167      14.992  42.629 167.513  1.00 53.31           C  
ATOM   1233  CG  ASP   167      15.465  41.213 167.224  1.00 54.32           C  
ATOM   1234  OD1 ASP   167      15.400  40.377 168.146  1.00 57.29           O  
ATOM   1235  OD2 ASP   167      15.913  40.938 166.089  1.00 59.10           O  
ATOM   1236  N   GLY   168      12.123  44.545 168.614  1.00 54.04           N  
ATOM   1237  CA  GLY   168      11.793  45.823 169.209  1.00 56.23           C  
ATOM   1238  C   GLY   168      12.089  46.953 168.235  1.00 58.04           C  
ATOM   1239  O   GLY   168      11.750  48.110 168.482  1.00 57.65           O  
ATOM   1240  N   THR   169      12.735  46.611 167.124  1.00 59.91           N  
ATOM   1241  CA  THR   169      13.095  47.571 166.079  1.00 61.31           C  
ATOM   1242  C   THR   169      12.033  48.640 165.864  1.00 62.28           C  
ATOM   1243  O   THR   169      12.365  49.803 165.619  1.00 63.59           O  
ATOM   1244  CB  THR   169      13.342  46.846 164.726  1.00 60.94           C  
ATOM   1245  OG1 THR   169      14.680  46.335 164.684  1.00 60.61           O  
ATOM   1246  CG2 THR   169      13.109  47.780 163.544  1.00 62.48           C  
ATOM   1247  N   ILE   170      10.762  48.250 165.954  1.00 63.65           N  
ATOM   1248  CA  ILE   170       9.677  49.198 165.728  1.00 65.26           C  
ATOM   1249  C   ILE   170       9.646  50.344 166.743  1.00 67.56           C  
ATOM   1250  O   ILE   170      10.360  50.315 167.740  1.00 67.27           O  
ATOM   1251  CB  ILE   170       8.300  48.465 165.611  1.00 64.43           C  
ATOM   1252  CG1 ILE   170       8.059  47.560 166.808  1.00 65.08           C  
ATOM   1253  CG2 ILE   170       8.284  47.632 164.319  1.00 63.91           C  
ATOM   1254  CD1 ILE   170       6.824  46.694 166.661  1.00 61.22           C  
ATOM   1255  N   ALA   171       8.815  51.349 166.477  1.00 71.03           N  
ATOM   1256  CA  ALA   171       8.732  52.562 167.298  1.00 74.04           C  
ATOM   1257  C   ALA   171      10.147  53.153 167.376  1.00 76.78           C  
ATOM   1258  O   ALA   171      10.730  53.279 168.460  1.00 77.43           O  
ATOM   1259  CB  ALA   171       8.222  52.258 168.694  1.00 74.35           C  
ATOM   1260  N   ASP   172      10.699  53.525 166.223  1.00 79.39           N  
ATOM   1261  CA  ASP   172      12.045  54.097 166.162  1.00 81.44           C  
ATOM   1262  C   ASP   172      12.123  55.050 164.972  1.00 82.22           C  
ATOM   1263  O   ASP   172      12.056  54.625 163.819  1.00 83.14           O  
ATOM   1264  CB  ASP   172      13.070  52.972 165.995  1.00 81.68           C  
ATOM   1265  CG  ASP   172      14.447  53.340 166.498  1.00 85.84           C  
ATOM   1266  OD1 ASP   172      14.833  54.516 166.380  1.00 90.92           O  
ATOM   1267  OD2 ASP   172      15.153  52.441 166.997  1.00 87.39           O  
ATOM   1268  N   GLN   173      12.282  56.336 165.262  1.00 82.92           N  
ATOM   1269  CA  GLN   173      12.352  57.356 164.224  1.00 83.98           C  
ATOM   1270  C   GLN   173      13.324  57.023 163.106  1.00 83.45           C  
ATOM   1271  O   GLN   173      12.969  57.063 161.933  1.00 83.90           O  
ATOM   1272  CB  GLN   173      12.712  58.717 164.834  1.00 84.72           C  
ATOM   1273  CG  GLN   173      11.607  59.350 165.690  1.00 88.73           C  
ATOM   1274  CD  GLN   173      11.323  58.578 166.965  1.00 91.02           C  
ATOM   1275  OE1 GLN   173      12.243  58.150 167.655  1.00 91.29           O  
ATOM   1276  NE2 GLN   173      10.044  58.415 167.295  1.00 90.94           N  
ATOM   1277  N   THR   174      14.550  56.679 163.477  1.00 82.77           N  
ATOM   1278  CA  THR   174      15.575  56.341 162.498  1.00 82.11           C  
ATOM   1279  C   THR   174      15.135  55.223 161.573  1.00 81.93           C  
ATOM   1280  O   THR   174      15.240  55.333 160.348  1.00 81.65           O  
ATOM   1281  CB  THR   174      16.901  55.902 163.178  1.00 82.03           C  
ATOM   1282  OG1 THR   174      16.664  54.764 164.022  1.00 82.87           O  
ATOM   1283  CG2 THR   174      17.494  57.036 164.004  1.00 80.61           C  
ATOM   1284  N   ARG   175      14.620  54.155 162.170  1.00 81.42           N  
ATOM   1285  CA  ARG   175      14.203  52.990 161.400  1.00 80.76           C  
ATOM   1286  C   ARG   175      13.016  53.134 160.457  1.00 80.26           C  
ATOM   1287  O   ARG   175      11.901  52.742 160.806  1.00 80.41           O  
ATOM   1288  CB  ARG   175      13.966  51.805 162.341  1.00 80.91           C  
ATOM   1289  CG  ARG   175      14.234  50.422 161.726  1.00 82.08           C  
ATOM   1290  CD  ARG   175      15.675  49.988 161.956  1.00 84.76           C  
ATOM   1291  NE  ARG   175      16.086  50.219 163.341  1.00 85.35           N  
ATOM   1292  CZ  ARG   175      17.050  49.545 163.962  1.00 86.15           C  
ATOM   1293  NH1 ARG   175      17.712  48.585 163.327  1.00 83.31           N  
ATOM   1294  NH2 ARG   175      17.346  49.826 165.226  1.00 86.88           N  
ATOM   1295  N   LYS   176      13.252  53.728 159.283  1.00 79.32           N  
ATOM   1296  CA  LYS   176      12.200  53.819 158.277  1.00 77.64           C  
ATOM   1297  C   LYS   176      12.482  52.544 157.460  1.00 76.67           C  
ATOM   1298  O   LYS   176      13.654  52.147 157.250  1.00 76.95           O  
ATOM   1299  CB  LYS   176      12.349  55.063 157.415  1.00 78.36           C  
ATOM   1300  N   ASP   177      11.419  51.901 156.986  1.00 73.97           N  
ATOM   1301  CA  ASP   177      11.555  50.614 156.296  1.00 71.10           C  
ATOM   1302  C   ASP   177      10.173  50.140 155.855  1.00 69.68           C  
ATOM   1303  O   ASP   177       9.176  50.354 156.551  1.00 69.25           O  
ATOM   1304  CB  ASP   177      12.096  49.619 157.317  1.00 71.15           C  
ATOM   1305  CG  ASP   177      13.030  48.583 156.729  1.00 71.21           C  
ATOM   1306  OD1 ASP   177      13.875  48.966 155.902  1.00 71.86           O  
ATOM   1307  OD2 ASP   177      12.938  47.392 157.122  1.00 69.21           O  
ATOM   1308  N   ARG   178      10.122  49.464 154.716  1.00 67.48           N  
ATOM   1309  CA  ARG   178       8.873  48.908 154.231  1.00 65.11           C  
ATOM   1310  C   ARG   178       8.368  47.952 155.319  1.00 62.93           C  
ATOM   1311  O   ARG   178       7.205  47.995 155.716  1.00 61.37           O  
ATOM   1312  CB  ARG   178       9.120  48.129 152.934  1.00 65.76           C  
ATOM   1313  N   ASP   179       9.258  47.081 155.789  1.00 61.40           N  
ATOM   1314  CA  ASP   179       8.914  46.072 156.785  1.00 61.31           C  
ATOM   1315  C   ASP   179       8.565  46.570 158.176  1.00 61.77           C  
ATOM   1316  O   ASP   179       7.499  46.240 158.708  1.00 62.54           O  
ATOM   1317  CB  ASP   179      10.025  45.013 156.857  1.00 60.28           C  
ATOM   1318  CG  ASP   179       9.996  44.057 155.657  1.00 60.29           C  
ATOM   1319  OD1 ASP   179       8.969  44.025 154.933  1.00 56.76           O  
ATOM   1320  OD2 ASP   179      10.993  43.330 155.451  1.00 58.00           O  
ATOM   1321  N   THR   180       9.457  47.362 158.756  1.00 61.26           N  
ATOM   1322  CA  THR   180       9.238  47.899 160.085  1.00 60.59           C  
ATOM   1323  C   THR   180       7.871  48.589 160.156  1.00 59.22           C  
ATOM   1324  O   THR   180       7.154  48.475 161.156  1.00 59.51           O  
ATOM   1325  CB  THR   180      10.351  48.910 160.457  1.00 60.28           C  
ATOM   1326  OG1 THR   180      10.457  48.997 161.881  1.00 63.84           O  
ATOM   1327  CG2 THR   180      10.034  50.299 159.913  1.00 62.53           C  
ATOM   1328  N   GLN   181       7.517  49.301 159.089  1.00 57.42           N  
ATOM   1329  CA  GLN   181       6.250  50.026 159.021  1.00 56.34           C  
ATOM   1330  C   GLN   181       5.053  49.083 158.956  1.00 54.30           C  
ATOM   1331  O   GLN   181       3.980  49.394 159.486  1.00 55.01           O  
ATOM   1332  CB  GLN   181       6.247  50.951 157.799  1.00 56.61           C  
ATOM   1333  CG  GLN   181       5.074  51.905 157.722  1.00 60.31           C  
ATOM   1334  CD  GLN   181       5.224  52.896 156.579  1.00 66.50           C  
ATOM   1335  OE1 GLN   181       6.338  53.162 156.123  1.00 68.79           O  
ATOM   1336  NE2 GLN   181       4.108  53.467 156.131  1.00 65.27           N  
ATOM   1337  N   ALA   182       5.241  47.936 158.308  1.00 52.30           N  
ATOM   1338  CA  ALA   182       4.177  46.945 158.188  1.00 51.70           C  
ATOM   1339  C   ALA   182       4.042  46.221 159.534  1.00 49.61           C  
ATOM   1340  O   ALA   182       2.929  45.999 160.011  1.00 48.87           O  
ATOM   1341  CB  ALA   182       4.504  45.948 157.068  1.00 51.18           C  
ATOM   1342  N   ALA   183       5.175  45.864 160.141  1.00 47.78           N  
ATOM   1343  CA  ALA   183       5.170  45.196 161.439  1.00 49.10           C  
ATOM   1344  C   ALA   183       4.535  46.152 162.474  1.00 50.05           C  
ATOM   1345  O   ALA   183       3.764  45.721 163.333  1.00 49.60           O  
ATOM   1346  CB  ALA   183       6.601  44.831 161.846  1.00 47.67           C  
ATOM   1347  N   ARG   184       4.849  47.448 162.392  1.00 51.31           N  
ATOM   1348  CA  ARG   184       4.283  48.433 163.319  1.00 52.65           C  
ATOM   1349  C   ARG   184       2.760  48.504 163.162  1.00 53.41           C  
ATOM   1350  O   ARG   184       2.031  48.534 164.157  1.00 53.91           O  
ATOM   1351  CB  ARG   184       4.872  49.820 163.066  1.00 54.06           C  
ATOM   1352  CG  ARG   184       5.157  50.600 164.341  1.00 57.28           C  
ATOM   1353  CD  ARG   184       5.260  52.096 164.094  1.00 59.50           C  
ATOM   1354  NE  ARG   184       6.262  52.446 163.092  1.00 61.89           N  
ATOM   1355  CZ  ARG   184       7.549  52.123 163.171  1.00 65.18           C  
ATOM   1356  NH1 ARG   184       8.000  51.441 164.209  1.00 66.46           N  
ATOM   1357  NH2 ARG   184       8.390  52.486 162.210  1.00 67.83           N  
ATOM   1358  N   ASP   185       2.280  48.532 161.917  1.00 53.41           N  
ATOM   1359  CA  ASP   185       0.838  48.596 161.664  1.00 54.19           C  
ATOM   1360  C   ASP   185       0.141  47.321 162.135  1.00 52.11           C  
ATOM   1361  O   ASP   185      -0.988  47.361 162.637  1.00 51.76           O  
ATOM   1362  CB  ASP   185       0.545  48.817 160.177  1.00 55.83           C  
ATOM   1363  CG  ASP   185      -0.940  48.873 159.884  1.00 63.25           C  
ATOM   1364  OD1 ASP   185      -1.551  47.806 159.669  1.00 71.31           O  
ATOM   1365  OD2 ASP   185      -1.503  49.988 159.886  1.00 73.27           O  
ATOM   1366  N   ALA   186       0.817  46.189 161.972  1.00 50.23           N  
ATOM   1367  CA  ALA   186       0.269  44.908 162.407  1.00 48.60           C  
ATOM   1368  C   ALA   186       0.097  44.960 163.936  1.00 46.32           C  
ATOM   1369  O   ALA   186      -0.975  44.666 164.459  1.00 45.88           O  
ATOM   1370  CB  ALA   186       1.220  43.776 162.022  1.00 47.52           C  
ATOM   1371  N   ASP   187       1.157  45.336 164.646  1.00 45.93           N  
ATOM   1372  CA  ASP   187       1.121  45.421 166.106  1.00 46.57           C  
ATOM   1373  C   ASP   187      -0.020  46.353 166.537  1.00 46.63           C  
ATOM   1374  O   ASP   187      -0.879  45.975 167.341  1.00 46.91           O  
ATOM   1375  CB  ASP   187       2.474  45.939 166.620  1.00 45.25           C  
ATOM   1376  CG  ASP   187       2.575  45.923 168.138  1.00 49.55           C  
ATOM   1377  OD1 ASP   187       2.652  44.821 168.735  1.00 45.87           O  
ATOM   1378  OD2 ASP   187       2.569  47.024 168.736  1.00 50.96           O  
ATOM   1379  N   GLU   188      -0.024  47.571 166.001  1.00 46.68           N  
ATOM   1380  CA  GLU   188      -1.064  48.545 166.320  1.00 46.47           C  
ATOM   1381  C   GLU   188      -2.450  47.988 165.972  1.00 45.29           C  
ATOM   1382  O   GLU   188      -3.409  48.177 166.717  1.00 44.23           O  
ATOM   1383  CB  GLU   188      -0.806  49.845 165.548  1.00 47.29           C  
ATOM   1384  CG  GLU   188      -1.912  50.873 165.661  1.00 52.14           C  
ATOM   1385  CD  GLU   188      -1.559  52.167 164.960  1.00 58.46           C  
ATOM   1386  OE1 GLU   188      -0.450  52.686 165.211  1.00 60.41           O  
ATOM   1387  OE2 GLU   188      -2.388  52.672 164.171  1.00 57.72           O  
ATOM   1388  N   TYR   189      -2.552  47.304 164.835  1.00 44.78           N  
ATOM   1389  CA  TYR   189      -3.822  46.712 164.409  1.00 43.79           C  
ATOM   1390  C   TYR   189      -4.226  45.571 165.343  1.00 42.73           C  
ATOM   1391  O   TYR   189      -5.385  45.467 165.753  1.00 43.44           O  
ATOM   1392  CB  TYR   189      -3.716  46.157 162.994  1.00 43.66           C  
ATOM   1393  CG  TYR   189      -4.990  45.489 162.538  1.00 43.06           C  
ATOM   1394  CD1 TYR   189      -6.135  46.241 162.280  1.00 45.51           C  
ATOM   1395  CD2 TYR   189      -5.064  44.104 162.395  1.00 40.70           C  
ATOM   1396  CE1 TYR   189      -7.320  45.635 161.886  1.00 48.14           C  
ATOM   1397  CE2 TYR   189      -6.248  43.483 162.003  1.00 43.88           C  
ATOM   1398  CZ  TYR   189      -7.370  44.256 161.751  1.00 46.56           C  
ATOM   1399  OH  TYR   189      -8.540  43.659 161.351  1.00 45.85           O  
ATOM   1400  N   ILE   190      -3.268  44.710 165.676  1.00 41.78           N  
ATOM   1401  CA  ILE   190      -3.536  43.587 166.562  1.00 39.45           C  
ATOM   1402  C   ILE   190      -4.024  44.084 167.931  1.00 39.67           C  
ATOM   1403  O   ILE   190      -4.950  43.518 168.511  1.00 38.60           O  
ATOM   1404  CB  ILE   190      -2.267  42.701 166.725  1.00 40.19           C  
ATOM   1405  CG1 ILE   190      -2.089  41.824 165.479  1.00 36.29           C  
ATOM   1406  CG2 ILE   190      -2.366  41.848 167.998  1.00 37.83           C  
ATOM   1407  CD1 ILE   190      -0.753  41.100 165.413  1.00 26.27           C  
ATOM   1408  N   ARG   191      -3.404  45.142 168.445  1.00 40.01           N  
ATOM   1409  CA  ARG   191      -3.792  45.684 169.743  1.00 43.13           C  
ATOM   1410  C   ARG   191      -5.132  46.419 169.725  1.00 44.80           C  
ATOM   1411  O   ARG   191      -5.630  46.842 170.766  1.00 44.64           O  
ATOM   1412  CB  ARG   191      -2.695  46.611 170.265  1.00 41.94           C  
ATOM   1413  CG  ARG   191      -1.437  45.882 170.742  1.00 42.77           C  
ATOM   1414  CD  ARG   191      -0.238  46.814 170.764  1.00 46.32           C  
ATOM   1415  NE  ARG   191      -0.668  48.195 170.934  1.00 51.32           N  
ATOM   1416  CZ  ARG   191      -0.136  49.228 170.292  1.00 50.72           C  
ATOM   1417  NH1 ARG   191       0.853  49.047 169.427  1.00 50.42           N  
ATOM   1418  NH2 ARG   191      -0.598  50.446 170.515  1.00 53.35           N  
ATOM   1419  N   SER   192      -5.725  46.543 168.543  1.00 45.68           N  
ATOM   1420  CA  SER   192      -6.994  47.240 168.393  1.00 46.18           C  
ATOM   1421  C   SER   192      -8.188  46.294 168.323  1.00 46.25           C  
ATOM   1422  O   SER   192      -9.328  46.721 168.519  1.00 46.21           O  
ATOM   1423  CB  SER   192      -6.979  48.097 167.124  1.00 47.71           C  
ATOM   1424  OG  SER   192      -7.303  47.324 165.967  1.00 47.27           O  
ATOM   1425  N   ILE   193      -7.944  45.015 168.046  1.00 47.19           N  
ATOM   1426  CA  ILE   193      -9.054  44.092 167.912  1.00 46.69           C  
ATOM   1427  C   ILE   193      -9.698  43.766 169.246  1.00 45.97           C  
ATOM   1428  O   ILE   193      -9.027  43.638 170.263  1.00 45.13           O  
ATOM   1429  CB  ILE   193      -8.627  42.829 167.096  1.00 46.55           C  
ATOM   1430  CG1 ILE   193      -9.275  41.581 167.659  1.00 48.58           C  
ATOM   1431  CG2 ILE   193      -7.122  42.735 167.017  1.00 48.52           C  
ATOM   1432  CD1 ILE   193      -8.374  40.370 167.601  1.00 53.08           C  
ATOM   1433  N   GLU   194     -11.020  43.641 169.220  1.00 46.10           N  
ATOM   1434  CA  GLU   194     -11.803  43.405 170.419  1.00 46.72           C  
ATOM   1435  C   GLU   194     -12.074  41.944 170.734  1.00 45.13           C  
ATOM   1436  O   GLU   194     -12.243  41.126 169.834  1.00 44.75           O  
ATOM   1437  CB  GLU   194     -13.119  44.175 170.299  1.00 48.29           C  
ATOM   1438  CG  GLU   194     -13.732  44.629 171.616  1.00 53.72           C  
ATOM   1439  CD  GLU   194     -13.127  45.922 172.135  1.00 60.45           C  
ATOM   1440  OE1 GLU   194     -12.510  46.656 171.332  1.00 61.44           O  
ATOM   1441  OE2 GLU   194     -13.287  46.211 173.341  1.00 63.38           O  
ATOM   1442  N   GLY   195     -12.123  41.631 172.022  1.00 42.68           N  
ATOM   1443  CA  GLY   195     -12.355  40.262 172.422  1.00 41.19           C  
ATOM   1444  C   GLY   195     -11.115  39.427 172.149  1.00 38.96           C  
ATOM   1445  O   GLY   195     -11.204  38.228 171.879  1.00 38.68           O  
ATOM   1446  N   ALA   196      -9.949  40.069 172.193  1.00 37.97           N  
ATOM   1447  CA  ALA   196      -8.669  39.386 171.968  1.00 38.03           C  
ATOM   1448  C   ALA   196      -7.746  39.616 173.142  1.00 38.17           C  
ATOM   1449  O   ALA   196      -7.723  40.713 173.714  1.00 39.15           O  
ATOM   1450  CB  ALA   196      -7.979  39.904 170.722  1.00 37.01           C  
ATOM   1451  N   HIS   197      -6.990  38.587 173.518  1.00 36.67           N  
ATOM   1452  CA  HIS   197      -5.979  38.759 174.559  1.00 34.86           C  
ATOM   1453  C   HIS   197      -4.672  38.817 173.766  1.00 34.12           C  
ATOM   1454  O   HIS   197      -4.383  37.946 172.928  1.00 34.95           O  
ATOM   1455  CB  HIS   197      -5.904  37.572 175.516  1.00 34.32           C  
ATOM   1456  CG  HIS   197      -7.163  37.314 176.261  1.00 30.53           C  
ATOM   1457  ND1 HIS   197      -7.739  38.243 177.100  1.00 28.83           N  
ATOM   1458  CD2 HIS   197      -7.935  36.209 176.330  1.00 32.70           C  
ATOM   1459  CE1 HIS   197      -8.814  37.717 177.656  1.00 29.31           C  
ATOM   1460  NE2 HIS   197      -8.955  36.484 177.205  1.00 27.66           N  
ATOM   1461  N   VAL   198      -3.887  39.856 174.006  1.00 32.85           N  
ATOM   1462  CA  VAL   198      -2.614  40.026 173.315  1.00 31.44           C  
ATOM   1463  C   VAL   198      -1.459  39.870 174.291  1.00 31.83           C  
ATOM   1464  O   VAL   198      -1.404  40.553 175.311  1.00 33.09           O  
ATOM   1465  CB  VAL   198      -2.521  41.420 172.641  1.00 32.23           C  
ATOM   1466  CG1 VAL   198      -1.167  41.590 171.962  1.00 29.85           C  
ATOM   1467  CG2 VAL   198      -3.662  41.584 171.629  1.00 31.51           C  
ATOM   1468  N   ALA   199      -0.555  38.942 173.991  1.00 31.03           N  
ATOM   1469  CA  ALA   199       0.623  38.735 174.820  1.00 30.46           C  
ATOM   1470  C   ALA   199       1.808  38.865 173.865  1.00 30.64           C  
ATOM   1471  O   ALA   199       1.832  38.228 172.812  1.00 30.97           O  
ATOM   1472  CB  ALA   199       0.609  37.340 175.471  1.00 28.20           C  
ATOM   1473  N   ARG   200       2.775  39.707 174.212  1.00 30.50           N  
ATOM   1474  CA  ARG   200       3.949  39.902 173.383  1.00 31.66           C  
ATOM   1475  C   ARG   200       5.137  39.535 174.265  1.00 32.61           C  
ATOM   1476  O   ARG   200       5.411  40.170 175.282  1.00 33.33           O  
ATOM   1477  CB  ARG   200       3.962  41.351 172.862  1.00 31.67           C  
ATOM   1478  CG  ARG   200       2.891  41.543 171.766  1.00 36.13           C  
ATOM   1479  CD  ARG   200       2.761  43.000 171.353  1.00 37.83           C  
ATOM   1480  NE  ARG   200       2.310  43.827 172.467  1.00 38.02           N  
ATOM   1481  CZ  ARG   200       2.536  45.129 172.561  1.00 37.23           C  
ATOM   1482  NH1 ARG   200       3.209  45.752 171.599  1.00 37.07           N  
ATOM   1483  NH2 ARG   200       2.122  45.793 173.631  1.00 35.20           N  
ATOM   1484  N   LEU   201       5.848  38.501 173.837  1.00 31.75           N  
ATOM   1485  CA  LEU   201       6.921  37.919 174.608  1.00 31.41           C  
ATOM   1486  C   LEU   201       8.335  37.984 174.037  1.00 31.43           C  
ATOM   1487  O   LEU   201       8.513  38.065 172.835  1.00 31.82           O  
ATOM   1488  CB  LEU   201       6.513  36.467 174.892  1.00 29.43           C  
ATOM   1489  CG  LEU   201       5.021  36.302 175.288  1.00 32.44           C  
ATOM   1490  CD1 LEU   201       4.614  34.815 175.271  1.00 26.90           C  
ATOM   1491  CD2 LEU   201       4.773  36.920 176.667  1.00 27.08           C  
ATOM   1492  N   PRO   202       9.352  37.925 174.917  1.00 30.80           N  
ATOM   1493  CA  PRO   202      10.767  37.978 174.532  1.00 30.32           C  
ATOM   1494  C   PRO   202      11.335  36.677 173.954  1.00 30.34           C  
ATOM   1495  O   PRO   202      12.359  36.191 174.416  1.00 30.23           O  
ATOM   1496  CB  PRO   202      11.457  38.373 175.834  1.00 30.91           C  
ATOM   1497  CG  PRO   202      10.656  37.632 176.860  1.00 28.45           C  
ATOM   1498  CD  PRO   202       9.205  37.859 176.387  1.00 30.07           C  
ATOM   1499  N   LEU   203      10.667  36.118 172.952  1.00 30.48           N  
ATOM   1500  CA  LEU   203      11.123  34.883 172.314  1.00 30.84           C  
ATOM   1501  C   LEU   203      11.410  35.167 170.839  1.00 31.51           C  
ATOM   1502  O   LEU   203      10.659  35.887 170.186  1.00 30.41           O  
ATOM   1503  CB  LEU   203      10.053  33.790 172.456  1.00 30.29           C  
ATOM   1504  CG  LEU   203       9.891  33.170 173.843  1.00 32.44           C  
ATOM   1505  CD1 LEU   203       8.508  32.527 173.937  1.00 32.55           C  
ATOM   1506  CD2 LEU   203      11.009  32.152 174.088  1.00 23.45           C  
ATOM   1507  N   GLY   204      12.497  34.596 170.326  1.00 32.37           N  
ATOM   1508  CA  GLY   204      12.882  34.847 168.949  1.00 34.19           C  
ATOM   1509  C   GLY   204      13.081  36.350 168.798  1.00 35.62           C  
ATOM   1510  O   GLY   204      13.706  36.997 169.647  1.00 35.96           O  
ATOM   1511  N   ALA   205      12.557  36.924 167.719  1.00 35.06           N  
ATOM   1512  CA  ALA   205      12.671  38.366 167.495  1.00 35.51           C  
ATOM   1513  C   ALA   205      11.446  39.095 168.071  1.00 35.05           C  
ATOM   1514  O   ALA   205      11.159  40.235 167.697  1.00 34.58           O  
ATOM   1515  CB  ALA   205      12.804  38.661 165.991  1.00 35.87           C  
ATOM   1516  N   GLY   206      10.724  38.440 168.978  1.00 35.87           N  
ATOM   1517  CA  GLY   206       9.545  39.052 169.571  1.00 34.61           C  
ATOM   1518  C   GLY   206       8.283  38.367 169.082  1.00 35.34           C  
ATOM   1519  O   GLY   206       7.853  38.570 167.954  1.00 34.47           O  
ATOM   1520  N   LEU   207       7.677  37.575 169.958  1.00 34.79           N  
ATOM   1521  CA  LEU   207       6.491  36.801 169.637  1.00 31.42           C  
ATOM   1522  C   LEU   207       5.192  37.467 170.024  1.00 30.81           C  
ATOM   1523  O   LEU   207       5.061  37.984 171.123  1.00 31.83           O  
ATOM   1524  CB  LEU   207       6.606  35.445 170.336  1.00 33.46           C  
ATOM   1525  CG  LEU   207       5.572  34.340 170.108  1.00 33.46           C  
ATOM   1526  CD1 LEU   207       5.830  33.688 168.753  1.00 37.83           C  
ATOM   1527  CD2 LEU   207       5.667  33.296 171.214  1.00 30.57           C  
ATOM   1528  N   THR   208       4.228  37.466 169.113  1.00 30.32           N  
ATOM   1529  CA  THR   208       2.928  38.023 169.439  1.00 28.64           C  
ATOM   1530  C   THR   208       1.915  36.888 169.395  1.00 29.95           C  
ATOM   1531  O   THR   208       1.733  36.237 168.356  1.00 29.31           O  
ATOM   1532  CB  THR   208       2.457  39.112 168.449  1.00 30.18           C  
ATOM   1533  OG1 THR   208       3.403  40.185 168.423  1.00 30.22           O  
ATOM   1534  CG2 THR   208       1.104  39.671 168.893  1.00 26.07           C  
ATOM   1535  N   VAL   209       1.290  36.608 170.530  1.00 29.09           N  
ATOM   1536  CA  VAL   209       0.264  35.589 170.541  1.00 29.88           C  
ATOM   1537  C   VAL   209      -1.036  36.292 170.927  1.00 30.32           C  
ATOM   1538  O   VAL   209      -1.116  37.033 171.909  1.00 32.33           O  
ATOM   1539  CB  VAL   209       0.622  34.361 171.478  1.00 29.48           C  
ATOM   1540  CG1 VAL   209       1.798  34.685 172.342  1.00 29.65           C  
ATOM   1541  CG2 VAL   209      -0.590  33.915 172.266  1.00 25.94           C  
ATOM   1542  N   VAL   210      -2.055  36.092 170.111  1.00 30.08           N  
ATOM   1543  CA  VAL   210      -3.324  36.706 170.372  1.00 30.95           C  
ATOM   1544  C   VAL   210      -4.362  35.599 170.439  1.00 31.19           C  
ATOM   1545  O   VAL   210      -4.602  34.856 169.474  1.00 31.19           O  
ATOM   1546  CB  VAL   210      -3.619  37.855 169.309  1.00 32.54           C  
ATOM   1547  CG1 VAL   210      -2.689  37.714 168.126  1.00 29.10           C  
ATOM   1548  CG2 VAL   210      -5.061  37.887 168.913  1.00 30.41           C  
ATOM   1549  N   THR   211      -4.970  35.474 171.610  1.00 31.26           N  
ATOM   1550  CA  THR   211      -5.956  34.445 171.782  1.00 33.16           C  
ATOM   1551  C   THR   211      -7.354  35.046 171.827  1.00 33.51           C  
ATOM   1552  O   THR   211      -7.553  36.165 172.310  1.00 34.80           O  
ATOM   1553  CB  THR   211      -5.607  33.534 173.019  1.00 33.51           C  
ATOM   1554  OG1 THR   211      -6.632  33.598 174.013  1.00 32.53           O  
ATOM   1555  CG2 THR   211      -4.269  33.914 173.600  1.00 26.11           C  
ATOM   1556  N   LYS   212      -8.314  34.304 171.283  1.00 33.14           N  
ATOM   1557  CA  LYS   212      -9.690  34.759 171.217  1.00 32.21           C  
ATOM   1558  C   LYS   212     -10.338  34.586 172.574  1.00 33.16           C  
ATOM   1559  O   LYS   212     -10.486  33.483 173.093  1.00 31.48           O  
ATOM   1560  CB  LYS   212     -10.451  33.983 170.126  1.00 30.67           C  
ATOM   1561  CG  LYS   212     -11.848  34.499 169.856  1.00 31.48           C  
ATOM   1562  CD  LYS   212     -12.519  33.780 168.685  1.00 33.82           C  
ATOM   1563  CE  LYS   212     -11.949  34.223 167.341  1.00 34.01           C  
ATOM   1564  NZ  LYS   212     -12.701  33.627 166.197  1.00 35.69           N  
ATOM   1565  N   ALA   213     -10.723  35.710 173.156  1.00 35.52           N  
ATOM   1566  CA  ALA   213     -11.339  35.718 174.472  1.00 36.71           C  
ATOM   1567  C   ALA   213     -12.641  34.939 174.553  1.00 38.53           C  
ATOM   1568  O   ALA   213     -13.372  34.834 173.570  1.00 39.30           O  
ATOM   1569  CB  ALA   213     -11.569  37.170 174.922  1.00 37.58           C  
END
