
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  182 ( 2817),  selected  182 , name 1s6i_A
# Molecule2: number of CA atoms   69 (  546),  selected   69 , name T0510_166_234.pdb
# PARAMETERS: 1s6i_A.T0510_166_234.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     1_A      Q     166           -
LGA    E     2_A      H     167           -
LGA    R     3_A      K     168           -
LGA    L     4_A      I     169           -
LGA    S     5_A      N     170           -
LGA    E     6_A      P     171           -
LGA    E     7_A      Y     172           -
LGA    E     8_A      D     173           -
LGA    I     9_A      -       -           -
LGA    G    10_A      -       -           -
LGA    G    11_A      I     174           #
LGA    L    12_A      T     175          4.505
LGA    -       -      G     176           -
LGA    K    13_A      A     177          3.307
LGA    E    14_A      E     178          3.375
LGA    L    15_A      V     179          2.345
LGA    F    16_A      L     180          1.432
LGA    K    17_A      K     181          1.807
LGA    M    18_A      Y     182          2.599
LGA    I    19_A      -       -           -
LGA    D    20_A      I     183          1.658
LGA    T    21_A      -       -           -
LGA    D    22_A      -       -           -
LGA    N    23_A      -       -           -
LGA    S    24_A      -       -           -
LGA    G    25_A      D     184          2.483
LGA    T    26_A      F     185          1.758
LGA    I    27_A      N     186           -
LGA    -       -      A     187           -
LGA    -       -      G     188           -
LGA    -       -      N     189           -
LGA    T    28_A      I     190          1.659
LGA    F    29_A      A     191          2.638
LGA    D    30_A      K     192          1.468
LGA    E    31_A      Q     193          0.353
LGA    L    32_A      L     194          2.351
LGA    K    33_A      L     195          1.444
LGA    D    34_A      N     196          1.635
LGA    G    35_A      Q     197          2.627
LGA    L    36_A      F     198          1.776
LGA    K    37_A      E     199          2.803
LGA    R    38_A      -       -           -
LGA    V    39_A      -       -           -
LGA    G    40_A      -       -           -
LGA    S    41_A      -       -           -
LGA    E    42_A      G     200          0.882
LGA    L    43_A      F     201          1.908
LGA    M    44_A      S     202          1.563
LGA    E    45_A      P     203          1.067
LGA    S    46_A      L     204          1.992
LGA    E    47_A      I     205          1.758
LGA    I    48_A      T     206          1.745
LGA    K    49_A      N     207          1.619
LGA    D    50_A      E     208          1.853
LGA    L    51_A      I     209          1.838
LGA    M    52_A      V     210          1.938
LGA    D    53_A      S     211          1.767
LGA    A    54_A      R     212          3.157
LGA    A    55_A      -       -           -
LGA    D    56_A      -       -           -
LGA    I    57_A      R     213          1.299
LGA    D    58_A      Q     214          2.384
LGA    K    59_A      F     215          4.129
LGA    S    60_A      -       -           -
LGA    G    61_A      -       -           -
LGA    T    62_A      -       -           -
LGA    I    63_A      M     216          2.944
LGA    D    64_A      T     217          2.265
LGA    Y    65_A      S     218          1.698
LGA    G    66_A      S     219          1.097
LGA    E    67_A      T     220          1.551
LGA    F    68_A      L     221          1.667
LGA    I    69_A      P     222          1.653
LGA    A    70_A      E     223          0.958
LGA    A    71_A      A     224          1.042
LGA    T    72_A      F     225          2.529
LGA    V    73_A      D     226          2.347
LGA    H    74_A      E     227          0.540
LGA    L    75_A      V     228          2.902
LGA    N    76_A      M     229          4.313
LGA    K    77_A      A     230          2.803
LGA    L    78_A      -       -           -
LGA    E    79_A      E     231          2.575
LGA    R    80_A      T     232          3.390
LGA    E    81_A      K     233           -
LGA    E    82_A      L     234           -
LGA    N    83_A      -       -           -
LGA    L    84_A      -       -           -
LGA    V    85_A      -       -           -
LGA    S    86_A      -       -           -
LGA    A    87_A      -       -           -
LGA    F    88_A      -       -           -
LGA    S    89_A      -       -           -
LGA    Y    90_A      -       -           -
LGA    F    91_A      -       -           -
LGA    D    92_A      -       -           -
LGA    K    93_A      -       -           -
LGA    D    94_A      -       -           -
LGA    G    95_A      -       -           -
LGA    S    96_A      -       -           -
LGA    G    97_A      -       -           -
LGA    Y    98_A      -       -           -
LGA    I    99_A      -       -           -
LGA    T   100_A      -       -           -
LGA    L   101_A      -       -           -
LGA    D   102_A      -       -           -
LGA    E   103_A      -       -           -
LGA    I   104_A      -       -           -
LGA    Q   105_A      -       -           -
LGA    Q   106_A      -       -           -
LGA    A   107_A      -       -           -
LGA    C   108_A      -       -           -
LGA    K   109_A      -       -           -
LGA    D   110_A      -       -           -
LGA    F   111_A      -       -           -
LGA    G   112_A      -       -           -
LGA    L   113_A      -       -           -
LGA    D   114_A      -       -           -
LGA    D   115_A      -       -           -
LGA    I   116_A      -       -           -
LGA    H   117_A      -       -           -
LGA    I   118_A      -       -           -
LGA    D   119_A      -       -           -
LGA    D   120_A      -       -           -
LGA    M   121_A      -       -           -
LGA    I   122_A      -       -           -
LGA    K   123_A      -       -           -
LGA    E   124_A      -       -           -
LGA    I   125_A      -       -           -
LGA    D   126_A      -       -           -
LGA    Q   127_A      -       -           -
LGA    D   128_A      -       -           -
LGA    N   129_A      -       -           -
LGA    D   130_A      -       -           -
LGA    G   131_A      -       -           -
LGA    Q   132_A      -       -           -
LGA    I   133_A      -       -           -
LGA    D   134_A      -       -           -
LGA    Y   135_A      -       -           -
LGA    G   136_A      -       -           -
LGA    E   137_A      -       -           -
LGA    F   138_A      -       -           -
LGA    A   139_A      -       -           -
LGA    A   140_A      -       -           -
LGA    M   141_A      -       -           -
LGA    M   142_A      -       -           -
LGA    R   143_A      -       -           -
LGA    K   144_A      -       -           -
LGA    R   145_A      -       -           -
LGA    K   146_A      -       -           -
LGA    G   147_A      -       -           -
LGA    N   148_A      -       -           -
LGA    G   149_A      -       -           -
LGA    G   150_A      -       -           -
LGA    I   151_A      -       -           -
LGA    G   152_A      -       -           -
LGA    R   153_A      -       -           -
LGA    R   154_A      -       -           -
LGA    T   155_A      -       -           -
LGA    M   156_A      -       -           -
LGA    R   157_A      -       -           -
LGA    K   158_A      -       -           -
LGA    T   159_A      -       -           -
LGA    L   160_A      -       -           -
LGA    N   161_A      -       -           -
LGA    L   162_A      -       -           -
LGA    R   163_A      -       -           -
LGA    D   164_A      -       -           -
LGA    A   165_A      -       -           -
LGA    L   166_A      -       -           -
LGA    G   167_A      -       -           -
LGA    L   168_A      -       -           -
LGA    V   169_A      -       -           -
LGA    D   170_A      -       -           -
LGA    N   171_A      -       -           -
LGA    G   172_A      -       -           -
LGA    S   173_A      -       -           -
LGA    N   174_A      -       -           -
LGA    Q   175_A      -       -           -
LGA    V   176_A      -       -           -
LGA    I   177_A      -       -           -
LGA    E   178_A      -       -           -
LGA    G   179_A      -       -           -
LGA    Y   180_A      -       -           -
LGA    F   181_A      -       -           -
LGA    K   182_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  182   69    5.0     53    2.27     9.43     61.625     2.232

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.321264 * X  +  -0.851735 * Y  +   0.413929 * Z  +  66.729279
  Y_new =   0.838624 * X  +   0.458921 * Y  +   0.293431 * Z  +  47.549358
  Z_new =  -0.439886 * X  +   0.252862 * Y  +   0.861720 * Z  +  46.235909 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.285426   -2.856166  [ DEG:    16.3537   -163.6463 ]
  Theta =   0.455472    2.686121  [ DEG:    26.0966    153.9034 ]
  Phi   =   1.204957   -1.936636  [ DEG:    69.0389   -110.9611 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1s6i_A                                        
REMARK     2: T0510_166_234.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1s6i_A.T0510_166_234.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  182   69   5.0   53   2.27    9.43  61.625
REMARK  ---------------------------------------------------------- 
MOLECULE 1s6i_A
HEADER    TRANSFERASE, PLANT PROTEIN              23-JAN-04   1S6I              
TITLE     CA2+-REGULATORY REGION (CLD) FROM SOYBEAN CALCIUM-DEPENDENT           
TITLE    2 PROTEIN KINASE-ALPHA (CDPK) IN THE PRESENCE OF CA2+ AND              
TITLE    3 THE JUNCTION DOMAIN (JD)                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CALCIUM-DEPENDENT PROTEIN KINASE SK5;                      
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: CALMODULIN-LIKE DOMAIN (CLD) AND C-TERMINAL TAIL;          
COMPND   5 SYNONYM: CDPK; CALCIUM-DEPENDENT PROTEIN KINASE-ALPHA;               
COMPND   6 EC: 2.7.1.-;                                                         
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: GLYCINE MAX;                                    
SOURCE   3 ORGANISM_COMMON: SOYBEAN;                                            
SOURCE   4 GENE: CDPK  SK5;                                                     
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PT7-7;                                    
SOURCE  10 OTHER_DETAILS: CA2+-BINDING REGION AND C-TERMINAL TAIL,              
SOURCE  11 ALONG WITH HIS(6) AT C-TERMINUS                                      
KEYWDS    EF-HAND; HELIX-LOOP-HELIX; CALCIUM-BINDING; CALMODULIN                
KEYWDS   2 SUPERFAMILY                                                          
EXPDTA    NMR, 15 STRUCTURES                                                    
AUTHOR    A.M.WELJIE,H.J.VOGEL                                                  
REVDAT   2   21-DEC-04 1S6I    1       JRNL   REMARK                            
REVDAT   1   15-JUN-04 1S6I    0                                                
JRNL        AUTH   A.M.WELJIE,H.J.VOGEL                                         
JRNL        TITL   UNEXPECTED STRUCTURE OF THE CA2+-REGULATORY REGION           
JRNL        TITL 2 FROM SOYBEAN CALCIUM-DEPENDENT PROTEIN KINASE-ALPHA          
JRNL        REF    J.BIOL.CHEM.                  V. 279 35494 2004              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1S6I A    1   182  UNP    P28583   CDPK_SOYBN     329    508             
SEQRES   1 A  188  ALA GLU ARG LEU SER GLU GLU GLU ILE GLY GLY LEU LYS          
SEQRES   2 A  188  GLU LEU PHE LYS MET ILE ASP THR ASP ASN SER GLY THR          
SEQRES   3 A  188  ILE THR PHE ASP GLU LEU LYS ASP GLY LEU LYS ARG VAL          
SEQRES   4 A  188  GLY SER GLU LEU MET GLU SER GLU ILE LYS ASP LEU MET          
SEQRES   5 A  188  ASP ALA ALA ASP ILE ASP LYS SER GLY THR ILE ASP TYR          
SEQRES   6 A  188  GLY GLU PHE ILE ALA ALA THR VAL HIS LEU ASN LYS LEU          
SEQRES   7 A  188  GLU ARG GLU GLU ASN LEU VAL SER ALA PHE SER TYR PHE          
SEQRES   8 A  188  ASP LYS ASP GLY SER GLY TYR ILE THR LEU ASP GLU ILE          
SEQRES   9 A  188  GLN GLN ALA CYS LYS ASP PHE GLY LEU ASP ASP ILE HIS          
SEQRES  10 A  188  ILE ASP ASP MET ILE LYS GLU ILE ASP GLN ASP ASN ASP          
SEQRES  11 A  188  GLY GLN ILE ASP TYR GLY GLU PHE ALA ALA MET MET ARG          
SEQRES  12 A  188  LYS ARG LYS GLY ASN GLY GLY ILE GLY ARG ARG THR MET          
SEQRES  13 A  188  ARG LYS THR LEU ASN LEU ARG ASP ALA LEU GLY LEU VAL          
SEQRES  14 A  188  ASP ASN GLY SER ASN GLN VAL ILE GLU GLY TYR PHE LYS          
SEQRES  15 A  188  HIS HIS HIS HIS HIS HIS                                      
HET     CA    183       1                                                       
HET     CA    184       1                                                       
HET     CA    185       1                                                       
HET     CA    186       1                                                       
HETNAM      CA CALCIUM ION                                                      
FORMUL   2   CA    4(CA 2+)                                                     
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   ALA A   1      70.371  60.414  56.978  1.00  0.00           N  
ATOM      2  CA  ALA A   1      68.994  60.871  57.297  1.00  0.00           C  
ATOM      3  C   ALA A   1      68.789  60.973  58.806  1.00  0.00           C  
ATOM      4  O   ALA A   1      69.613  60.502  59.587  1.00  0.00           O  
ATOM      5  CB  ALA A   1      67.970  59.927  56.686  1.00  0.00           C  
ATOM      6  HA  ALA A   1      68.851  61.848  56.860  1.00  0.00           H  
ATOM      7  HB1 ALA A   1      68.162  58.920  57.025  1.00  0.00           H  
ATOM      8  HB2 ALA A   1      68.042  59.966  55.609  1.00  0.00           H  
ATOM      9  HB3 ALA A   1      66.977  60.226  56.991  1.00  0.00           H  
ATOM     10  H1  ALA A   1      70.474  59.403  57.202  1.00  0.00           H  
ATOM     11  H2  ALA A   1      71.065  60.951  57.536  1.00  0.00           H  
ATOM     12  H3  ALA A   1      70.571  60.555  55.968  1.00  0.00           H  
ATOM     13  N   GLU A   2      67.683  61.594  59.207  1.00  0.00           N  
ATOM     14  CA  GLU A   2      67.371  61.761  60.620  1.00  0.00           C  
ATOM     15  C   GLU A   2      65.973  61.236  60.938  1.00  0.00           C  
ATOM     16  O   GLU A   2      65.600  61.104  62.104  1.00  0.00           O  
ATOM     17  CB  GLU A   2      67.474  63.236  61.016  1.00  0.00           C  
ATOM     18  CG  GLU A   2      68.859  63.827  60.808  1.00  0.00           C  
ATOM     19  CD  GLU A   2      68.934  65.287  61.207  1.00  0.00           C  
ATOM     20  OE1 GLU A   2      68.673  65.594  62.388  1.00  0.00           O  
ATOM     21  OE2 GLU A   2      69.256  66.125  60.337  1.00  0.00           O  
ATOM     22  H   GLU A   2      67.064  61.951  58.535  1.00  0.00           H  
ATOM     23  HA  GLU A   2      68.093  61.194  61.187  1.00  0.00           H  
ATOM     24  HB2 GLU A   2      66.772  63.804  60.425  1.00  0.00           H  
ATOM     25  HB3 GLU A   2      67.217  63.335  62.059  1.00  0.00           H  
ATOM     26  HG2 GLU A   2      69.568  63.271  61.402  1.00  0.00           H  
ATOM     27  HG3 GLU A   2      69.121  63.740  59.763  1.00  0.00           H  
ATOM     28  N   ARG A   3      65.204  60.940  59.895  1.00  0.00           N  
ATOM     29  CA  ARG A   3      63.847  60.432  60.064  1.00  0.00           C  
ATOM     30  C   ARG A   3      63.363  59.773  58.776  1.00  0.00           C  
ATOM     31  O   ARG A   3      63.218  60.431  57.745  1.00  0.00           O  
ATOM     32  CB  ARG A   3      62.909  61.577  60.474  1.00  0.00           C  
ATOM     33  CG  ARG A   3      61.505  61.133  60.875  1.00  0.00           C  
ATOM     34  CD  ARG A   3      60.653  60.768  59.668  1.00  0.00           C  
ATOM     35  NE  ARG A   3      60.564  61.866  58.706  1.00  0.00           N  
ATOM     36  CZ  ARG A   3      60.011  63.047  58.978  1.00  0.00           C  
ATOM     37  NH1 ARG A   3      59.470  63.276  60.168  1.00  0.00           N  
ATOM     38  NH2 ARG A   3      59.993  63.999  58.055  1.00  0.00           N  
ATOM     39  H   ARG A   3      65.557  61.067  58.989  1.00  0.00           H  
ATOM     40  HA  ARG A   3      63.865  59.692  60.850  1.00  0.00           H  
ATOM     41  HB2 ARG A   3      63.347  62.098  61.313  1.00  0.00           H  
ATOM     42  HB3 ARG A   3      62.822  62.263  59.646  1.00  0.00           H  
ATOM     43  HG2 ARG A   3      61.582  60.272  61.519  1.00  0.00           H  
ATOM     44  HG3 ARG A   3      61.027  61.940  61.410  1.00  0.00           H  
ATOM     45  HD2 ARG A   3      61.092  59.911  59.180  1.00  0.00           H  
ATOM     46  HD3 ARG A   3      59.659  60.519  60.008  1.00  0.00           H  
ATOM     47  HE  ARG A   3      60.943  61.719  57.815  1.00  0.00           H  
ATOM     48 HH11 ARG A   3      59.476  62.560  60.866  1.00  0.00           H  
ATOM     49 HH12 ARG A   3      59.057  64.164  60.365  1.00  0.00           H  
ATOM     50 HH21 ARG A   3      60.396  63.829  57.154  1.00  0.00           H  
ATOM     51 HH22 ARG A   3      59.579  64.886  58.258  1.00  0.00           H  
ATOM     52  N   LEU A   4      63.115  58.468  58.845  1.00  0.00           N  
ATOM     53  CA  LEU A   4      62.647  57.716  57.686  1.00  0.00           C  
ATOM     54  C   LEU A   4      61.974  56.417  58.118  1.00  0.00           C  
ATOM     55  O   LEU A   4      60.921  56.047  57.598  1.00  0.00           O  
ATOM     56  CB  LEU A   4      63.817  57.412  56.745  1.00  0.00           C  
ATOM     57  CG  LEU A   4      63.451  56.649  55.470  1.00  0.00           C  
ATOM     58  CD1 LEU A   4      62.509  57.471  54.604  1.00  0.00           C  
ATOM     59  CD2 LEU A   4      64.707  56.281  54.692  1.00  0.00           C  
ATOM     60  H   LEU A   4      63.249  57.999  59.695  1.00  0.00           H  
ATOM     61  HA  LEU A   4      61.926  58.325  57.163  1.00  0.00           H  
ATOM     62  HB2 LEU A   4      64.273  58.349  56.461  1.00  0.00           H  
ATOM     63  HB3 LEU A   4      64.545  56.829  57.290  1.00  0.00           H  
ATOM     64  HG  LEU A   4      62.944  55.734  55.739  1.00  0.00           H  
ATOM     65 HD11 LEU A   4      62.030  56.827  53.881  1.00  0.00           H  
ATOM     66 HD12 LEU A   4      63.067  58.238  54.089  1.00  0.00           H  
ATOM     67 HD13 LEU A   4      61.757  57.932  55.228  1.00  0.00           H  
ATOM     68 HD21 LEU A   4      65.414  55.806  55.356  1.00  0.00           H  
ATOM     69 HD22 LEU A   4      65.147  57.176  54.276  1.00  0.00           H  
ATOM     70 HD23 LEU A   4      64.449  55.602  53.894  1.00  0.00           H  
ATOM     71  N   SER A   5      62.591  55.728  59.074  1.00  0.00           N  
ATOM     72  CA  SER A   5      62.056  54.470  59.582  1.00  0.00           C  
ATOM     73  C   SER A   5      61.225  54.703  60.841  1.00  0.00           C  
ATOM     74  O   SER A   5      61.085  55.836  61.302  1.00  0.00           O  
ATOM     75  CB  SER A   5      63.196  53.494  59.876  1.00  0.00           C  
ATOM     76  OG  SER A   5      62.700  52.244  60.322  1.00  0.00           O  
ATOM     77  H   SER A   5      63.426  56.077  59.449  1.00  0.00           H  
ATOM     78  HA  SER A   5      61.419  54.048  58.818  1.00  0.00           H  
ATOM     79  HB2 SER A   5      63.775  53.339  58.978  1.00  0.00           H  
ATOM     80  HB3 SER A   5      63.831  53.910  60.645  1.00  0.00           H  
ATOM     81  HG  SER A   5      62.730  51.612  59.601  1.00  0.00           H  
ATOM     82  N   GLU A   6      60.677  53.624  61.395  1.00  0.00           N  
ATOM     83  CA  GLU A   6      59.863  53.715  62.602  1.00  0.00           C  
ATOM     84  C   GLU A   6      60.593  53.110  63.800  1.00  0.00           C  
ATOM     85  O   GLU A   6      59.994  52.406  64.613  1.00  0.00           O  
ATOM     86  CB  GLU A   6      58.511  53.017  62.397  1.00  0.00           C  
ATOM     87  CG  GLU A   6      58.618  51.531  62.086  1.00  0.00           C  
ATOM     88  CD  GLU A   6      59.259  51.252  60.740  1.00  0.00           C  
ATOM     89  OE1 GLU A   6      58.707  51.705  59.715  1.00  0.00           O  
ATOM     90  OE2 GLU A   6      60.312  50.583  60.712  1.00  0.00           O  
ATOM     91  H   GLU A   6      60.826  52.749  60.982  1.00  0.00           H  
ATOM     92  HA  GLU A   6      59.685  54.762  62.799  1.00  0.00           H  
ATOM     93  HB2 GLU A   6      57.924  53.129  63.296  1.00  0.00           H  
ATOM     94  HB3 GLU A   6      57.994  53.497  61.582  1.00  0.00           H  
ATOM     95  HG2 GLU A   6      59.211  51.056  62.853  1.00  0.00           H  
ATOM     96  HG3 GLU A   6      57.624  51.106  62.088  1.00  0.00           H  
ATOM     97  N   GLU A   7      61.887  53.397  63.901  1.00  0.00           N  
ATOM     98  CA  GLU A   7      62.703  52.888  64.999  1.00  0.00           C  
ATOM     99  C   GLU A   7      62.224  53.451  66.334  1.00  0.00           C  
ATOM    100  O   GLU A   7      62.565  52.933  67.398  1.00  0.00           O  
ATOM    101  CB  GLU A   7      64.174  53.251  64.774  1.00  0.00           C  
ATOM    102  CG  GLU A   7      65.113  52.695  65.834  1.00  0.00           C  
ATOM    103  CD  GLU A   7      66.561  53.069  65.586  1.00  0.00           C  
ATOM    104  OE1 GLU A   7      66.866  54.280  65.560  1.00  0.00           O  
ATOM    105  OE2 GLU A   7      67.393  52.151  65.417  1.00  0.00           O  
ATOM    106  H   GLU A   7      62.304  53.968  63.221  1.00  0.00           H  
ATOM    107  HA  GLU A   7      62.604  51.814  65.017  1.00  0.00           H  
ATOM    108  HB2 GLU A   7      64.485  52.868  63.813  1.00  0.00           H  
ATOM    109  HB3 GLU A   7      64.270  54.327  64.770  1.00  0.00           H  
ATOM    110  HG2 GLU A   7      64.818  53.081  66.798  1.00  0.00           H  
ATOM    111  HG3 GLU A   7      65.031  51.616  65.838  1.00  0.00           H  
ATOM    112  N   GLU A   8      61.434  54.519  66.269  1.00  0.00           N  
ATOM    113  CA  GLU A   8      60.909  55.162  67.469  1.00  0.00           C  
ATOM    114  C   GLU A   8      60.016  54.203  68.256  1.00  0.00           C  
ATOM    115  O   GLU A   8      60.103  54.130  69.481  1.00  0.00           O  
ATOM    116  CB  GLU A   8      60.126  56.423  67.084  1.00  0.00           C  
ATOM    117  CG  GLU A   8      59.693  57.278  68.269  1.00  0.00           C  
ATOM    118  CD  GLU A   8      58.609  56.630  69.108  1.00  0.00           C  
ATOM    119  OE1 GLU A   8      57.520  56.353  68.561  1.00  0.00           O  
ATOM    120  OE2 GLU A   8      58.846  56.400  70.312  1.00  0.00           O  
ATOM    121  H   GLU A   8      61.201  54.886  65.390  1.00  0.00           H  
ATOM    122  HA  GLU A   8      61.746  55.445  68.088  1.00  0.00           H  
ATOM    123  HB2 GLU A   8      60.744  57.030  66.439  1.00  0.00           H  
ATOM    124  HB3 GLU A   8      59.239  56.128  66.542  1.00  0.00           H  
ATOM    125  HG2 GLU A   8      60.552  57.456  68.899  1.00  0.00           H  
ATOM    126  HG3 GLU A   8      59.324  58.222  67.897  1.00  0.00           H  
ATOM    127  N   ILE A   9      59.160  53.472  67.547  1.00  0.00           N  
ATOM    128  CA  ILE A   9      58.254  52.525  68.192  1.00  0.00           C  
ATOM    129  C   ILE A   9      59.019  51.359  68.804  1.00  0.00           C  
ATOM    130  O   ILE A   9      59.088  51.219  70.026  1.00  0.00           O  
ATOM    131  CB  ILE A   9      57.199  51.978  67.200  1.00  0.00           C  
ATOM    132  CG1 ILE A   9      56.213  53.076  66.785  1.00  0.00           C  
ATOM    133  CG2 ILE A   9      56.447  50.802  67.813  1.00  0.00           C  
ATOM    134  CD1 ILE A   9      56.831  54.185  65.960  1.00  0.00           C  
ATOM    135  H   ILE A   9      59.133  53.573  66.574  1.00  0.00           H  
ATOM    136  HA  ILE A   9      57.735  53.045  68.976  1.00  0.00           H  
ATOM    137  HB  ILE A   9      57.717  51.619  66.323  1.00  0.00           H  
ATOM    138 HG12 ILE A   9      55.421  52.634  66.198  1.00  0.00           H  
ATOM    139 HG13 ILE A   9      55.788  53.520  67.673  1.00  0.00           H  
ATOM    140 HG21 ILE A   9      55.999  51.108  68.747  1.00  0.00           H  
ATOM    141 HG22 ILE A   9      57.133  49.988  67.993  1.00  0.00           H  
ATOM    142 HG23 ILE A   9      55.672  50.476  67.133  1.00  0.00           H  
ATOM    143 HD11 ILE A   9      57.490  53.757  65.218  1.00  0.00           H  
ATOM    144 HD12 ILE A   9      57.394  54.843  66.606  1.00  0.00           H  
ATOM    145 HD13 ILE A   9      56.051  54.747  65.467  1.00  0.00           H  
ATOM    146  N   GLY A  10      59.584  50.524  67.946  1.00  0.00           N  
ATOM    147  CA  GLY A  10      60.337  49.376  68.405  1.00  0.00           C  
ATOM    148  C   GLY A  10      61.158  48.771  67.290  1.00  0.00           C  
ATOM    149  O   GLY A  10      60.931  49.085  66.123  1.00  0.00           O  
ATOM    150  H   GLY A  10      59.490  50.690  66.985  1.00  0.00           H  
ATOM    151  HA2 GLY A  10      60.997  49.682  69.204  1.00  0.00           H  
ATOM    152  HA3 GLY A  10      59.651  48.630  68.779  1.00  0.00           H  
ATOM    153  N   GLY A  11      62.104  47.904  67.638  1.00  0.00           N  
ATOM    154  CA  GLY A  11      62.926  47.266  66.626  1.00  0.00           C  
ATOM    155  C   GLY A  11      62.093  46.407  65.693  1.00  0.00           C  
ATOM    156  O   GLY A  11      62.058  45.185  65.826  1.00  0.00           O  
ATOM    157  H   GLY A  11      62.236  47.687  68.585  1.00  0.00           H  
ATOM    158  HA2 GLY A  11      63.428  48.028  66.048  1.00  0.00           H  
ATOM    159  HA3 GLY A  11      63.663  46.644  67.109  1.00  0.00           H  
ATOM    160  N   LEU A  12      61.409  47.056  64.756  1.00  0.00           N  
ATOM    161  CA  LEU A  12      60.554  46.364  63.802  1.00  0.00           C  
ATOM    162  C   LEU A  12      61.352  45.941  62.576  1.00  0.00           C  
ATOM    163  O   LEU A  12      61.262  44.795  62.137  1.00  0.00           O  
ATOM    164  CB  LEU A  12      59.384  47.269  63.401  1.00  0.00           C  
ATOM    165  CG  LEU A  12      58.288  46.590  62.574  1.00  0.00           C  
ATOM    166  CD1 LEU A  12      57.605  45.496  63.380  1.00  0.00           C  
ATOM    167  CD2 LEU A  12      57.273  47.618  62.095  1.00  0.00           C  
ATOM    168  H   LEU A  12      61.475  48.031  64.709  1.00  0.00           H  
ATOM    169  HA  LEU A  12      60.173  45.473  64.284  1.00  0.00           H  
ATOM    170  HB2 LEU A  12      58.937  47.671  64.304  1.00  0.00           H  
ATOM    171  HB3 LEU A  12      59.781  48.091  62.823  1.00  0.00           H  
ATOM    172  HG  LEU A  12      58.736  46.132  61.703  1.00  0.00           H  
ATOM    173 HD11 LEU A  12      57.590  44.583  62.806  1.00  0.00           H  
ATOM    174 HD12 LEU A  12      56.592  45.796  63.606  1.00  0.00           H  
ATOM    175 HD13 LEU A  12      58.147  45.334  64.299  1.00  0.00           H  
ATOM    176 HD21 LEU A  12      56.940  48.212  62.931  1.00  0.00           H  
ATOM    177 HD22 LEU A  12      56.427  47.110  61.655  1.00  0.00           H  
ATOM    178 HD23 LEU A  12      57.730  48.259  61.356  1.00  0.00           H  
ATOM    179  N   LYS A  13      62.150  46.861  62.039  1.00  0.00           N  
ATOM    180  CA  LYS A  13      62.978  46.548  60.883  1.00  0.00           C  
ATOM    181  C   LYS A  13      63.845  45.348  61.219  1.00  0.00           C  
ATOM    182  O   LYS A  13      64.156  44.523  60.359  1.00  0.00           O  
ATOM    183  CB  LYS A  13      63.841  47.748  60.487  1.00  0.00           C  
ATOM    184  CG  LYS A  13      64.850  47.440  59.393  1.00  0.00           C  
ATOM    185  CD  LYS A  13      65.701  48.653  59.035  1.00  0.00           C  
ATOM    186  CE  LYS A  13      66.620  49.073  60.177  1.00  0.00           C  
ATOM    187  NZ  LYS A  13      65.872  49.692  61.307  1.00  0.00           N  
ATOM    188  H   LYS A  13      62.198  47.753  62.437  1.00  0.00           H  
ATOM    189  HA  LYS A  13      62.325  46.288  60.063  1.00  0.00           H  
ATOM    190  HB2 LYS A  13      63.189  48.536  60.132  1.00  0.00           H  
ATOM    191  HB3 LYS A  13      64.376  48.099  61.357  1.00  0.00           H  
ATOM    192  HG2 LYS A  13      65.503  46.649  59.735  1.00  0.00           H  
ATOM    193  HG3 LYS A  13      64.320  47.111  58.511  1.00  0.00           H  
ATOM    194  HD2 LYS A  13      66.305  48.412  58.174  1.00  0.00           H  
ATOM    195  HD3 LYS A  13      65.044  49.478  58.794  1.00  0.00           H  
ATOM    196  HE2 LYS A  13      67.140  48.198  60.540  1.00  0.00           H  
ATOM    197  HE3 LYS A  13      67.338  49.785  59.799  1.00  0.00           H  
ATOM    198  HZ1 LYS A  13      65.410  48.955  61.877  1.00  0.00           H  
ATOM    199  HZ2 LYS A  13      65.146  50.341  60.944  1.00  0.00           H  
ATOM    200  HZ3 LYS A  13      66.526  50.226  61.916  1.00  0.00           H  
ATOM    201  N   GLU A  14      64.188  45.236  62.498  1.00  0.00           N  
ATOM    202  CA  GLU A  14      64.970  44.114  62.983  1.00  0.00           C  
ATOM    203  C   GLU A  14      64.069  42.901  63.102  1.00  0.00           C  
ATOM    204  O   GLU A  14      64.469  41.787  62.780  1.00  0.00           O  
ATOM    205  CB  GLU A  14      65.611  44.431  64.333  1.00  0.00           C  
ATOM    206  CG  GLU A  14      66.810  45.355  64.228  1.00  0.00           C  
ATOM    207  CD  GLU A  14      66.461  46.710  63.649  1.00  0.00           C  
ATOM    208  OE1 GLU A  14      65.613  47.410  64.242  1.00  0.00           O  
ATOM    209  OE2 GLU A  14      67.038  47.074  62.601  1.00  0.00           O  
ATOM    210  H   GLU A  14      63.876  45.910  63.137  1.00  0.00           H  
ATOM    211  HA  GLU A  14      65.745  43.905  62.260  1.00  0.00           H  
ATOM    212  HB2 GLU A  14      64.875  44.904  64.967  1.00  0.00           H  
ATOM    213  HB3 GLU A  14      65.932  43.510  64.793  1.00  0.00           H  
ATOM    214  HG2 GLU A  14      67.227  45.498  65.215  1.00  0.00           H  
ATOM    215  HG3 GLU A  14      67.545  44.883  63.591  1.00  0.00           H  
ATOM    216  N   LEU A  15      62.832  43.138  63.542  1.00  0.00           N  
ATOM    217  CA  LEU A  15      61.852  42.070  63.677  1.00  0.00           C  
ATOM    218  C   LEU A  15      61.705  41.340  62.354  1.00  0.00           C  
ATOM    219  O   LEU A  15      61.381  40.154  62.312  1.00  0.00           O  
ATOM    220  CB  LEU A  15      60.494  42.626  64.109  1.00  0.00           C  
ATOM    221  CG  LEU A  15      59.411  41.572  64.334  1.00  0.00           C  
ATOM    222  CD1 LEU A  15      59.831  40.598  65.421  1.00  0.00           C  
ATOM    223  CD2 LEU A  15      58.086  42.230  64.681  1.00  0.00           C  
ATOM    224  H   LEU A  15      62.571  44.057  63.759  1.00  0.00           H  
ATOM    225  HA  LEU A  15      62.210  41.378  64.426  1.00  0.00           H  
ATOM    226  HB2 LEU A  15      60.629  43.181  65.024  1.00  0.00           H  
ATOM    227  HB3 LEU A  15      60.149  43.307  63.345  1.00  0.00           H  
ATOM    228  HG  LEU A  15      59.276  41.008  63.422  1.00  0.00           H  
ATOM    229 HD11 LEU A  15      59.129  39.779  65.463  1.00  0.00           H  
ATOM    230 HD12 LEU A  15      59.847  41.107  66.374  1.00  0.00           H  
ATOM    231 HD13 LEU A  15      60.818  40.217  65.199  1.00  0.00           H  
ATOM    232 HD21 LEU A  15      57.999  43.165  64.147  1.00  0.00           H  
ATOM    233 HD22 LEU A  15      58.044  42.414  65.744  1.00  0.00           H  
ATOM    234 HD23 LEU A  15      57.274  41.576  64.397  1.00  0.00           H  
ATOM    235  N   PHE A  16      61.960  42.065  61.273  1.00  0.00           N  
ATOM    236  CA  PHE A  16      61.873  41.499  59.940  1.00  0.00           C  
ATOM    237  C   PHE A  16      63.010  40.519  59.696  1.00  0.00           C  
ATOM    238  O   PHE A  16      62.791  39.424  59.184  1.00  0.00           O  
ATOM    239  CB  PHE A  16      61.925  42.598  58.880  1.00  0.00           C  
ATOM    240  CG  PHE A  16      62.267  42.055  57.518  1.00  0.00           C  
ATOM    241  CD1 PHE A  16      61.459  41.106  56.911  1.00  0.00           C  
ATOM    242  CD2 PHE A  16      63.421  42.462  56.866  1.00  0.00           C  
ATOM    243  CE1 PHE A  16      61.794  40.574  55.682  1.00  0.00           C  
ATOM    244  CE2 PHE A  16      63.756  41.938  55.632  1.00  0.00           C  
ATOM    245  CZ  PHE A  16      62.944  40.991  55.041  1.00  0.00           C  
ATOM    246  H   PHE A  16      62.221  43.004  61.379  1.00  0.00           H  
ATOM    247  HA  PHE A  16      60.934  40.974  59.860  1.00  0.00           H  
ATOM    248  HB2 PHE A  16      60.960  43.087  58.823  1.00  0.00           H  
ATOM    249  HB3 PHE A  16      62.677  43.322  59.155  1.00  0.00           H  
ATOM    250  HD1 PHE A  16      60.559  40.780  57.409  1.00  0.00           H  
ATOM    251  HD2 PHE A  16      64.058  43.202  57.327  1.00  0.00           H  
ATOM    252  HE1 PHE A  16      61.155  39.839  55.219  1.00  0.00           H  
ATOM    253  HE2 PHE A  16      64.657  42.263  55.132  1.00  0.00           H  
ATOM    254  HZ  PHE A  16      63.208  40.574  54.081  1.00  0.00           H  
ATOM    255  N   LYS A  17      64.221  40.910  60.079  1.00  0.00           N  
ATOM    256  CA  LYS A  17      65.379  40.046  59.901  1.00  0.00           C  
ATOM    257  C   LYS A  17      65.421  39.072  61.051  1.00  0.00           C  
ATOM    258  O   LYS A  17      66.141  38.073  61.032  1.00  0.00           O  
ATOM    259  CB  LYS A  17      66.673  40.858  59.818  1.00  0.00           C  
ATOM    260  CG  LYS A  17      66.974  41.671  61.064  1.00  0.00           C  
ATOM    261  CD  LYS A  17      68.276  42.440  60.918  1.00  0.00           C  
ATOM    262  CE  LYS A  17      68.630  43.184  62.196  1.00  0.00           C  
ATOM    263  NZ  LYS A  17      69.886  43.972  62.053  1.00  0.00           N  
ATOM    264  H   LYS A  17      64.332  41.788  60.510  1.00  0.00           H  
ATOM    265  HA  LYS A  17      65.242  39.495  58.980  1.00  0.00           H  
ATOM    266  HB2 LYS A  17      67.496  40.180  59.651  1.00  0.00           H  
ATOM    267  HB3 LYS A  17      66.602  41.536  58.978  1.00  0.00           H  
ATOM    268  HG2 LYS A  17      66.169  42.370  61.228  1.00  0.00           H  
ATOM    269  HG3 LYS A  17      67.051  41.003  61.909  1.00  0.00           H  
ATOM    270  HD2 LYS A  17      69.070  41.746  60.687  1.00  0.00           H  
ATOM    271  HD3 LYS A  17      68.175  43.153  60.113  1.00  0.00           H  
ATOM    272  HE2 LYS A  17      67.822  43.857  62.442  1.00  0.00           H  
ATOM    273  HE3 LYS A  17      68.755  42.466  62.992  1.00  0.00           H  
ATOM    274  HZ1 LYS A  17      69.770  44.702  61.322  1.00  0.00           H  
ATOM    275  HZ2 LYS A  17      70.670  43.346  61.779  1.00  0.00           H  
ATOM    276  HZ3 LYS A  17      70.123  44.432  62.954  1.00  0.00           H  
ATOM    277  N   MET A  18      64.605  39.379  62.042  1.00  0.00           N  
ATOM    278  CA  MET A  18      64.474  38.563  63.221  1.00  0.00           C  
ATOM    279  C   MET A  18      63.946  37.202  62.806  1.00  0.00           C  
ATOM    280  O   MET A  18      64.177  36.190  63.468  1.00  0.00           O  
ATOM    281  CB  MET A  18      63.511  39.239  64.193  1.00  0.00           C  
ATOM    282  CG  MET A  18      63.828  39.024  65.660  1.00  0.00           C  
ATOM    283  SD  MET A  18      65.550  39.368  66.090  1.00  0.00           S  
ATOM    284  CE  MET A  18      66.333  37.794  65.737  1.00  0.00           C  
ATOM    285  H   MET A  18      64.053  40.183  61.963  1.00  0.00           H  
ATOM    286  HA  MET A  18      65.444  38.457  63.674  1.00  0.00           H  
ATOM    287  HB2 MET A  18      63.510  40.305  64.007  1.00  0.00           H  
ATOM    288  HB3 MET A  18      62.518  38.857  64.009  1.00  0.00           H  
ATOM    289  HG2 MET A  18      63.200  39.688  66.227  1.00  0.00           H  
ATOM    290  HG3 MET A  18      63.599  37.999  65.921  1.00  0.00           H  
ATOM    291  HE1 MET A  18      66.743  37.386  66.650  1.00  0.00           H  
ATOM    292  HE2 MET A  18      67.126  37.938  65.019  1.00  0.00           H  
ATOM    293  HE3 MET A  18      65.601  37.108  65.333  1.00  0.00           H  
ATOM    294  N   ILE A  19      63.235  37.200  61.680  1.00  0.00           N  
ATOM    295  CA  ILE A  19      62.661  35.987  61.120  1.00  0.00           C  
ATOM    296  C   ILE A  19      63.678  35.276  60.230  1.00  0.00           C  
ATOM    297  O   ILE A  19      64.044  34.126  60.480  1.00  0.00           O  
ATOM    298  CB  ILE A  19      61.395  36.293  60.293  1.00  0.00           C  
ATOM    299  CG1 ILE A  19      60.352  37.022  61.153  1.00  0.00           C  
ATOM    300  CG2 ILE A  19      60.826  35.011  59.707  1.00  0.00           C  
ATOM    301  CD1 ILE A  19      58.923  36.869  60.669  1.00  0.00           C  
ATOM    302  H   ILE A  19      63.098  38.048  61.202  1.00  0.00           H  
ATOM    303  HA  ILE A  19      62.388  35.335  61.937  1.00  0.00           H  
ATOM    304  HB  ILE A  19      61.679  36.934  59.469  1.00  0.00           H  
ATOM    305 HG12 ILE A  19      60.402  36.646  62.164  1.00  0.00           H  
ATOM    306 HG13 ILE A  19      60.584  38.080  61.155  1.00  0.00           H  
ATOM    307 HG21 ILE A  19      60.517  34.357  60.507  1.00  0.00           H  
ATOM    308 HG22 ILE A  19      61.583  34.520  59.113  1.00  0.00           H  
ATOM    309 HG23 ILE A  19      59.976  35.246  59.084  1.00  0.00           H  
ATOM    310 HD11 ILE A  19      58.745  37.550  59.850  1.00  0.00           H  
ATOM    311 HD12 ILE A  19      58.245  37.096  61.478  1.00  0.00           H  
ATOM    312 HD13 ILE A  19      58.758  35.856  60.336  1.00  0.00           H  
ATOM    313  N   ASP A  20      64.135  35.976  59.194  1.00  0.00           N  
ATOM    314  CA  ASP A  20      65.120  35.434  58.265  1.00  0.00           C  
ATOM    315  C   ASP A  20      66.525  35.589  58.826  1.00  0.00           C  
ATOM    316  O   ASP A  20      67.389  36.226  58.222  1.00  0.00           O  
ATOM    317  CB  ASP A  20      65.016  36.140  56.917  1.00  0.00           C  
ATOM    318  CG  ASP A  20      64.768  37.626  57.063  1.00  0.00           C  
ATOM    319  OD1 ASP A  20      63.627  38.002  57.386  1.00  0.00           O  
ATOM    320  OD2 ASP A  20      65.716  38.411  56.870  1.00  0.00           O  
ATOM    321  H   ASP A  20      63.808  36.890  59.059  1.00  0.00           H  
ATOM    322  HA  ASP A  20      64.912  34.384  58.135  1.00  0.00           H  
ATOM    323  HB2 ASP A  20      65.937  35.999  56.371  1.00  0.00           H  
ATOM    324  HB3 ASP A  20      64.200  35.710  56.357  1.00  0.00           H  
ATOM    325  N   THR A  21      66.723  35.028  60.003  1.00  0.00           N  
ATOM    326  CA  THR A  21      67.998  35.112  60.701  1.00  0.00           C  
ATOM    327  C   THR A  21      69.005  34.089  60.185  1.00  0.00           C  
ATOM    328  O   THR A  21      70.166  34.095  60.597  1.00  0.00           O  
ATOM    329  CB  THR A  21      67.768  34.897  62.193  1.00  0.00           C  
ATOM    330  OG1 THR A  21      68.937  35.204  62.934  1.00  0.00           O  
ATOM    331  CG2 THR A  21      67.367  33.478  62.537  1.00  0.00           C  
ATOM    332  H   THR A  21      65.976  34.567  60.436  1.00  0.00           H  
ATOM    333  HA  THR A  21      68.397  36.103  60.548  1.00  0.00           H  
ATOM    334  HB  THR A  21      66.972  35.550  62.518  1.00  0.00           H  
ATOM    335  HG1 THR A  21      69.304  34.396  63.301  1.00  0.00           H  
ATOM    336 HG21 THR A  21      68.104  33.046  63.198  1.00  0.00           H  
ATOM    337 HG22 THR A  21      67.310  32.892  61.632  1.00  0.00           H  
ATOM    338 HG23 THR A  21      66.404  33.483  63.025  1.00  0.00           H  
ATOM    339  N   ASP A  22      68.563  33.202  59.307  1.00  0.00           N  
ATOM    340  CA  ASP A  22      69.444  32.170  58.775  1.00  0.00           C  
ATOM    341  C   ASP A  22      69.407  32.113  57.250  1.00  0.00           C  
ATOM    342  O   ASP A  22      70.267  31.485  56.632  1.00  0.00           O  
ATOM    343  CB  ASP A  22      69.058  30.807  59.349  1.00  0.00           C  
ATOM    344  CG  ASP A  22      67.627  30.427  59.019  1.00  0.00           C  
ATOM    345  OD1 ASP A  22      66.940  31.224  58.351  1.00  0.00           O  
ATOM    346  OD2 ASP A  22      67.195  29.330  59.431  1.00  0.00           O  
ATOM    347  H   ASP A  22      67.625  33.228  59.020  1.00  0.00           H  
ATOM    348  HA  ASP A  22      70.451  32.404  59.085  1.00  0.00           H  
ATOM    349  HB2 ASP A  22      69.714  30.051  58.942  1.00  0.00           H  
ATOM    350  HB3 ASP A  22      69.167  30.831  60.423  1.00  0.00           H  
ATOM    351  N   ASN A  23      68.412  32.749  56.645  1.00  0.00           N  
ATOM    352  CA  ASN A  23      68.285  32.734  55.198  1.00  0.00           C  
ATOM    353  C   ASN A  23      69.321  33.642  54.545  1.00  0.00           C  
ATOM    354  O   ASN A  23      70.403  33.194  54.166  1.00  0.00           O  
ATOM    355  CB  ASN A  23      66.874  33.162  54.778  1.00  0.00           C  
ATOM    356  CG  ASN A  23      66.612  32.988  53.290  1.00  0.00           C  
ATOM    357  OD1 ASN A  23      65.538  33.333  52.799  1.00  0.00           O  
ATOM    358  ND2 ASN A  23      67.584  32.444  52.564  1.00  0.00           N  
ATOM    359  H   ASN A  23      67.739  33.226  57.171  1.00  0.00           H  
ATOM    360  HA  ASN A  23      68.454  31.723  54.866  1.00  0.00           H  
ATOM    361  HB2 ASN A  23      66.149  32.574  55.320  1.00  0.00           H  
ATOM    362  HB3 ASN A  23      66.732  34.202  55.028  1.00  0.00           H  
ATOM    363 HD21 ASN A  23      68.413  32.184  53.016  1.00  0.00           H  
ATOM    364 HD22 ASN A  23      67.431  32.322  51.604  1.00  0.00           H  
ATOM    365  N   SER A  24      68.973  34.917  54.408  1.00  0.00           N  
ATOM    366  CA  SER A  24      69.862  35.895  53.785  1.00  0.00           C  
ATOM    367  C   SER A  24      69.251  37.289  53.831  1.00  0.00           C  
ATOM    368  O   SER A  24      69.764  38.225  53.218  1.00  0.00           O  
ATOM    369  CB  SER A  24      70.134  35.498  52.334  1.00  0.00           C  
ATOM    370  OG  SER A  24      68.920  35.322  51.624  1.00  0.00           O  
ATOM    371  H   SER A  24      68.094  35.210  54.734  1.00  0.00           H  
ATOM    372  HA  SER A  24      70.792  35.899  54.332  1.00  0.00           H  
ATOM    373  HB2 SER A  24      70.709  36.275  51.852  1.00  0.00           H  
ATOM    374  HB3 SER A  24      70.688  34.572  52.312  1.00  0.00           H  
ATOM    375  HG  SER A  24      69.079  34.780  50.847  1.00  0.00           H  
ATOM    376  N   GLY A  25      68.126  37.405  54.525  1.00  0.00           N  
ATOM    377  CA  GLY A  25      67.421  38.664  54.603  1.00  0.00           C  
ATOM    378  C   GLY A  25      66.102  38.600  53.861  1.00  0.00           C  
ATOM    379  O   GLY A  25      65.621  39.601  53.330  1.00  0.00           O  
ATOM    380  H   GLY A  25      67.740  36.614  54.947  1.00  0.00           H  
ATOM    381  HA2 GLY A  25      67.235  38.902  55.639  1.00  0.00           H  
ATOM    382  HA3 GLY A  25      68.033  39.436  54.168  1.00  0.00           H  
ATOM    383  N   THR A  26      65.512  37.403  53.854  1.00  0.00           N  
ATOM    384  CA  THR A  26      64.225  37.163  53.209  1.00  0.00           C  
ATOM    385  C   THR A  26      63.483  36.052  53.932  1.00  0.00           C  
ATOM    386  O   THR A  26      64.093  35.131  54.471  1.00  0.00           O  
ATOM    387  CB  THR A  26      64.386  36.797  51.741  1.00  0.00           C  
ATOM    388  OG1 THR A  26      65.250  35.684  51.589  1.00  0.00           O  
ATOM    389  CG2 THR A  26      64.924  37.923  50.887  1.00  0.00           C  
ATOM    390  H   THR A  26      65.951  36.661  54.321  1.00  0.00           H  
ATOM    391  HA  THR A  26      63.646  38.073  53.285  1.00  0.00           H  
ATOM    392  HB  THR A  26      63.413  36.526  51.358  1.00  0.00           H  
ATOM    393  HG1 THR A  26      64.732  34.875  51.582  1.00  0.00           H  
ATOM    394 HG21 THR A  26      65.097  38.791  51.507  1.00  0.00           H  
ATOM    395 HG22 THR A  26      64.204  38.166  50.121  1.00  0.00           H  
ATOM    396 HG23 THR A  26      65.850  37.615  50.430  1.00  0.00           H  
ATOM    397  N   ILE A  27      62.168  36.170  53.976  1.00  0.00           N  
ATOM    398  CA  ILE A  27      61.350  35.208  54.692  1.00  0.00           C  
ATOM    399  C   ILE A  27      60.652  34.218  53.783  1.00  0.00           C  
ATOM    400  O   ILE A  27      59.646  34.527  53.164  1.00  0.00           O  
ATOM    401  CB  ILE A  27      60.285  35.952  55.490  1.00  0.00           C  
ATOM    402  CG1 ILE A  27      60.956  37.044  56.317  1.00  0.00           C  
ATOM    403  CG2 ILE A  27      59.502  34.991  56.366  1.00  0.00           C  
ATOM    404  CD1 ILE A  27      60.096  37.588  57.426  1.00  0.00           C  
ATOM    405  H   ILE A  27      61.751  36.956  53.571  1.00  0.00           H  
ATOM    406  HA  ILE A  27      61.979  34.673  55.385  1.00  0.00           H  
ATOM    407  HB  ILE A  27      59.598  36.407  54.787  1.00  0.00           H  
ATOM    408 HG12 ILE A  27      61.857  36.642  56.758  1.00  0.00           H  
ATOM    409 HG13 ILE A  27      61.214  37.869  55.665  1.00  0.00           H  
ATOM    410 HG21 ILE A  27      59.887  35.028  57.373  1.00  0.00           H  
ATOM    411 HG22 ILE A  27      59.603  33.988  55.978  1.00  0.00           H  
ATOM    412 HG23 ILE A  27      58.461  35.274  56.366  1.00  0.00           H  
ATOM    413 HD11 ILE A  27      59.974  36.830  58.186  1.00  0.00           H  
ATOM    414 HD12 ILE A  27      59.131  37.862  57.029  1.00  0.00           H  
ATOM    415 HD13 ILE A  27      60.570  38.457  57.855  1.00  0.00           H  
ATOM    416  N   THR A  28      61.166  33.010  53.739  1.00  0.00           N  
ATOM    417  CA  THR A  28      60.562  31.986  52.919  1.00  0.00           C  
ATOM    418  C   THR A  28      59.770  31.015  53.779  1.00  0.00           C  
ATOM    419  O   THR A  28      59.899  31.016  54.994  1.00  0.00           O  
ATOM    420  CB  THR A  28      61.634  31.259  52.113  1.00  0.00           C  
ATOM    421  OG1 THR A  28      62.590  30.657  52.967  1.00  0.00           O  
ATOM    422  CG2 THR A  28      62.370  32.186  51.171  1.00  0.00           C  
ATOM    423  H   THR A  28      61.959  32.803  54.278  1.00  0.00           H  
ATOM    424  HA  THR A  28      59.882  32.473  52.238  1.00  0.00           H  
ATOM    425  HB  THR A  28      61.167  30.485  51.519  1.00  0.00           H  
ATOM    426  HG1 THR A  28      62.838  29.799  52.615  1.00  0.00           H  
ATOM    427 HG21 THR A  28      62.406  31.749  50.185  1.00  0.00           H  
ATOM    428 HG22 THR A  28      63.375  32.342  51.533  1.00  0.00           H  
ATOM    429 HG23 THR A  28      61.852  33.137  51.125  1.00  0.00           H  
ATOM    430  N   PHE A  29      58.927  30.230  53.129  1.00  0.00           N  
ATOM    431  CA  PHE A  29      58.049  29.266  53.798  1.00  0.00           C  
ATOM    432  C   PHE A  29      58.691  28.650  55.047  1.00  0.00           C  
ATOM    433  O   PHE A  29      58.005  28.393  56.037  1.00  0.00           O  
ATOM    434  CB  PHE A  29      57.692  28.148  52.819  1.00  0.00           C  
ATOM    435  CG  PHE A  29      56.464  27.372  53.199  1.00  0.00           C  
ATOM    436  CD1 PHE A  29      55.215  27.779  52.763  1.00  0.00           C  
ATOM    437  CD2 PHE A  29      56.560  26.229  53.977  1.00  0.00           C  
ATOM    438  CE1 PHE A  29      54.081  27.065  53.101  1.00  0.00           C  
ATOM    439  CE2 PHE A  29      55.430  25.511  54.318  1.00  0.00           C  
ATOM    440  CZ  PHE A  29      54.188  25.929  53.880  1.00  0.00           C  
ATOM    441  H   PHE A  29      58.864  30.329  52.159  1.00  0.00           H  
ATOM    442  HA  PHE A  29      57.146  29.781  54.086  1.00  0.00           H  
ATOM    443  HB2 PHE A  29      57.525  28.578  51.844  1.00  0.00           H  
ATOM    444  HB3 PHE A  29      58.519  27.455  52.762  1.00  0.00           H  
ATOM    445  HD1 PHE A  29      55.129  28.667  52.153  1.00  0.00           H  
ATOM    446  HD2 PHE A  29      57.529  25.903  54.323  1.00  0.00           H  
ATOM    447  HE1 PHE A  29      53.113  27.396  52.758  1.00  0.00           H  
ATOM    448  HE2 PHE A  29      55.517  24.624  54.927  1.00  0.00           H  
ATOM    449  HZ  PHE A  29      53.303  25.370  54.146  1.00  0.00           H  
ATOM    450  N   ASP A  30      59.996  28.409  54.998  1.00  0.00           N  
ATOM    451  CA  ASP A  30      60.703  27.817  56.132  1.00  0.00           C  
ATOM    452  C   ASP A  30      60.938  28.838  57.247  1.00  0.00           C  
ATOM    453  O   ASP A  30      60.631  28.578  58.415  1.00  0.00           O  
ATOM    454  CB  ASP A  30      62.042  27.237  55.670  1.00  0.00           C  
ATOM    455  CG  ASP A  30      61.879  26.176  54.599  1.00  0.00           C  
ATOM    456  OD1 ASP A  30      60.724  25.885  54.217  1.00  0.00           O  
ATOM    457  OD2 ASP A  30      62.906  25.636  54.139  1.00  0.00           O  
ATOM    458  H   ASP A  30      60.492  28.627  54.183  1.00  0.00           H  
ATOM    459  HA  ASP A  30      60.091  27.017  56.523  1.00  0.00           H  
ATOM    460  HB2 ASP A  30      62.653  28.032  55.273  1.00  0.00           H  
ATOM    461  HB3 ASP A  30      62.543  26.792  56.517  1.00  0.00           H  
ATOM    462  N   GLU A  31      61.472  30.003  56.887  1.00  0.00           N  
ATOM    463  CA  GLU A  31      61.730  31.049  57.870  1.00  0.00           C  
ATOM    464  C   GLU A  31      60.444  31.741  58.274  1.00  0.00           C  
ATOM    465  O   GLU A  31      60.374  32.353  59.336  1.00  0.00           O  
ATOM    466  CB  GLU A  31      62.746  32.066  57.346  1.00  0.00           C  
ATOM    467  CG  GLU A  31      64.185  31.652  57.608  1.00  0.00           C  
ATOM    468  CD  GLU A  31      64.645  30.528  56.698  1.00  0.00           C  
ATOM    469  OE1 GLU A  31      64.080  29.419  56.789  1.00  0.00           O  
ATOM    470  OE2 GLU A  31      65.569  30.763  55.892  1.00  0.00           O  
ATOM    471  H   GLU A  31      61.681  30.165  55.943  1.00  0.00           H  
ATOM    472  HA  GLU A  31      62.141  30.579  58.744  1.00  0.00           H  
ATOM    473  HB2 GLU A  31      62.614  32.169  56.279  1.00  0.00           H  
ATOM    474  HB3 GLU A  31      62.574  33.021  57.817  1.00  0.00           H  
ATOM    475  HG2 GLU A  31      64.829  32.506  57.464  1.00  0.00           H  
ATOM    476  HG3 GLU A  31      64.263  31.316  58.632  1.00  0.00           H  
ATOM    477  N   LEU A  32      59.422  31.613  57.438  1.00  0.00           N  
ATOM    478  CA  LEU A  32      58.129  32.206  57.719  1.00  0.00           C  
ATOM    479  C   LEU A  32      57.759  31.906  59.159  1.00  0.00           C  
ATOM    480  O   LEU A  32      57.354  32.783  59.923  1.00  0.00           O  
ATOM    481  CB  LEU A  32      57.072  31.627  56.783  1.00  0.00           C  
ATOM    482  CG  LEU A  32      55.803  32.473  56.623  1.00  0.00           C  
ATOM    483  CD1 LEU A  32      54.943  32.414  57.876  1.00  0.00           C  
ATOM    484  CD2 LEU A  32      56.162  33.916  56.301  1.00  0.00           C  
ATOM    485  H   LEU A  32      59.537  31.088  56.626  1.00  0.00           H  
ATOM    486  HA  LEU A  32      58.203  33.268  57.563  1.00  0.00           H  
ATOM    487  HB2 LEU A  32      57.521  31.491  55.811  1.00  0.00           H  
ATOM    488  HB3 LEU A  32      56.789  30.658  57.168  1.00  0.00           H  
ATOM    489  HG  LEU A  32      55.222  32.085  55.798  1.00  0.00           H  
ATOM    490 HD11 LEU A  32      54.071  33.036  57.746  1.00  0.00           H  
ATOM    491 HD12 LEU A  32      55.515  32.765  58.723  1.00  0.00           H  
ATOM    492 HD13 LEU A  32      54.633  31.393  58.053  1.00  0.00           H  
ATOM    493 HD21 LEU A  32      57.116  33.944  55.795  1.00  0.00           H  
ATOM    494 HD22 LEU A  32      56.224  34.484  57.218  1.00  0.00           H  
ATOM    495 HD23 LEU A  32      55.403  34.343  55.663  1.00  0.00           H  
ATOM    496  N   LYS A  33      57.929  30.643  59.506  1.00  0.00           N  
ATOM    497  CA  LYS A  33      57.650  30.147  60.845  1.00  0.00           C  
ATOM    498  C   LYS A  33      58.846  30.346  61.777  1.00  0.00           C  
ATOM    499  O   LYS A  33      58.708  30.903  62.870  1.00  0.00           O  
ATOM    500  CB  LYS A  33      57.274  28.663  60.790  1.00  0.00           C  
ATOM    501  CG  LYS A  33      57.621  27.989  59.470  1.00  0.00           C  
ATOM    502  CD  LYS A  33      57.652  26.478  59.593  1.00  0.00           C  
ATOM    503  CE  LYS A  33      56.325  25.943  60.082  1.00  0.00           C  
ATOM    504  NZ  LYS A  33      56.277  24.455  60.046  1.00  0.00           N  
ATOM    505  H   LYS A  33      58.264  30.018  58.830  1.00  0.00           H  
ATOM    506  HA  LYS A  33      56.816  30.702  61.235  1.00  0.00           H  
ATOM    507  HB2 LYS A  33      57.791  28.142  61.580  1.00  0.00           H  
ATOM    508  HB3 LYS A  33      56.210  28.572  60.944  1.00  0.00           H  
ATOM    509  HG2 LYS A  33      56.878  28.260  58.736  1.00  0.00           H  
ATOM    510  HG3 LYS A  33      58.582  28.331  59.146  1.00  0.00           H  
ATOM    511  HD2 LYS A  33      57.866  26.051  58.625  1.00  0.00           H  
ATOM    512  HD3 LYS A  33      58.424  26.199  60.293  1.00  0.00           H  
ATOM    513  HE2 LYS A  33      56.176  26.275  61.096  1.00  0.00           H  
ATOM    514  HE3 LYS A  33      55.544  26.342  59.457  1.00  0.00           H  
ATOM    515  HZ1 LYS A  33      55.536  24.108  60.688  1.00  0.00           H  
ATOM    516  HZ2 LYS A  33      57.191  24.062  60.346  1.00  0.00           H  
ATOM    517  HZ3 LYS A  33      56.070  24.128  59.083  1.00  0.00           H  
ATOM    518  N   ASP A  34      60.018  29.884  61.338  1.00  0.00           N  
ATOM    519  CA  ASP A  34      61.244  29.985  62.131  1.00  0.00           C  
ATOM    520  C   ASP A  34      61.315  31.285  62.932  1.00  0.00           C  
ATOM    521  O   ASP A  34      61.828  31.308  64.050  1.00  0.00           O  
ATOM    522  CB  ASP A  34      62.461  29.884  61.217  1.00  0.00           C  
ATOM    523  CG  ASP A  34      62.612  28.507  60.598  1.00  0.00           C  
ATOM    524  OD1 ASP A  34      61.760  27.634  60.870  1.00  0.00           O  
ATOM    525  OD2 ASP A  34      63.584  28.303  59.839  1.00  0.00           O  
ATOM    526  H   ASP A  34      60.058  29.446  60.456  1.00  0.00           H  
ATOM    527  HA  ASP A  34      61.259  29.157  62.820  1.00  0.00           H  
ATOM    528  HB2 ASP A  34      62.360  30.605  60.422  1.00  0.00           H  
ATOM    529  HB3 ASP A  34      63.349  30.106  61.787  1.00  0.00           H  
ATOM    530  N   GLY A  35      60.816  32.363  62.349  1.00  0.00           N  
ATOM    531  CA  GLY A  35      60.848  33.651  63.012  1.00  0.00           C  
ATOM    532  C   GLY A  35      59.955  33.768  64.246  1.00  0.00           C  
ATOM    533  O   GLY A  35      60.442  34.105  65.326  1.00  0.00           O  
ATOM    534  H   GLY A  35      60.437  32.288  61.449  1.00  0.00           H  
ATOM    535  HA2 GLY A  35      61.865  33.852  63.313  1.00  0.00           H  
ATOM    536  HA3 GLY A  35      60.551  34.410  62.301  1.00  0.00           H  
ATOM    537  N   LEU A  36      58.646  33.528  64.104  1.00  0.00           N  
ATOM    538  CA  LEU A  36      57.743  33.680  65.250  1.00  0.00           C  
ATOM    539  C   LEU A  36      57.898  32.548  66.251  1.00  0.00           C  
ATOM    540  O   LEU A  36      57.674  32.737  67.446  1.00  0.00           O  
ATOM    541  CB  LEU A  36      56.268  33.867  64.818  1.00  0.00           C  
ATOM    542  CG  LEU A  36      55.462  32.622  64.399  1.00  0.00           C  
ATOM    543  CD1 LEU A  36      56.157  31.857  63.298  1.00  0.00           C  
ATOM    544  CD2 LEU A  36      55.179  31.713  65.585  1.00  0.00           C  
ATOM    545  H   LEU A  36      58.288  33.274  63.228  1.00  0.00           H  
ATOM    546  HA  LEU A  36      58.051  34.587  65.753  1.00  0.00           H  
ATOM    547  HB2 LEU A  36      55.743  34.330  65.639  1.00  0.00           H  
ATOM    548  HB3 LEU A  36      56.258  34.558  63.987  1.00  0.00           H  
ATOM    549  HG  LEU A  36      54.510  32.950  64.008  1.00  0.00           H  
ATOM    550 HD11 LEU A  36      56.362  32.522  62.472  1.00  0.00           H  
ATOM    551 HD12 LEU A  36      55.515  31.056  62.964  1.00  0.00           H  
ATOM    552 HD13 LEU A  36      57.079  31.445  63.672  1.00  0.00           H  
ATOM    553 HD21 LEU A  36      55.469  30.701  65.342  1.00  0.00           H  
ATOM    554 HD22 LEU A  36      54.124  31.739  65.815  1.00  0.00           H  
ATOM    555 HD23 LEU A  36      55.742  32.052  66.441  1.00  0.00           H  
ATOM    556  N   LYS A  37      58.295  31.375  65.778  1.00  0.00           N  
ATOM    557  CA  LYS A  37      58.488  30.246  66.664  1.00  0.00           C  
ATOM    558  C   LYS A  37      59.653  30.520  67.612  1.00  0.00           C  
ATOM    559  O   LYS A  37      59.933  29.732  68.515  1.00  0.00           O  
ATOM    560  CB  LYS A  37      58.731  28.971  65.858  1.00  0.00           C  
ATOM    561  CG  LYS A  37      59.977  29.014  64.995  1.00  0.00           C  
ATOM    562  CD  LYS A  37      60.294  27.650  64.397  1.00  0.00           C  
ATOM    563  CE  LYS A  37      59.184  27.163  63.478  1.00  0.00           C  
ATOM    564  NZ  LYS A  37      59.486  25.824  62.904  1.00  0.00           N  
ATOM    565  H   LYS A  37      58.471  31.270  64.822  1.00  0.00           H  
ATOM    566  HA  LYS A  37      57.588  30.127  67.247  1.00  0.00           H  
ATOM    567  HB2 LYS A  37      58.815  28.136  66.537  1.00  0.00           H  
ATOM    568  HB3 LYS A  37      57.882  28.814  65.209  1.00  0.00           H  
ATOM    569  HG2 LYS A  37      59.819  29.719  64.191  1.00  0.00           H  
ATOM    570  HG3 LYS A  37      60.810  29.337  65.596  1.00  0.00           H  
ATOM    571  HD2 LYS A  37      61.209  27.722  63.827  1.00  0.00           H  
ATOM    572  HD3 LYS A  37      60.423  26.939  65.199  1.00  0.00           H  
ATOM    573  HE2 LYS A  37      58.265  27.104  64.044  1.00  0.00           H  
ATOM    574  HE3 LYS A  37      59.062  27.872  62.672  1.00  0.00           H  
ATOM    575  HZ1 LYS A  37      59.101  25.752  61.940  1.00  0.00           H  
ATOM    576  HZ2 LYS A  37      59.059  25.079  63.491  1.00  0.00           H  
ATOM    577  HZ3 LYS A  37      60.514  25.674  62.868  1.00  0.00           H  
ATOM    578  N   ARG A  38      60.325  31.657  67.402  1.00  0.00           N  
ATOM    579  CA  ARG A  38      61.452  32.047  68.238  1.00  0.00           C  
ATOM    580  C   ARG A  38      60.986  32.823  69.468  1.00  0.00           C  
ATOM    581  O   ARG A  38      61.483  32.604  70.574  1.00  0.00           O  
ATOM    582  CB  ARG A  38      62.440  32.889  67.423  1.00  0.00           C  
ATOM    583  CG  ARG A  38      63.525  33.551  68.259  1.00  0.00           C  
ATOM    584  CD  ARG A  38      64.631  34.121  67.386  1.00  0.00           C  
ATOM    585  NE  ARG A  38      65.354  33.065  66.681  1.00  0.00           N  
ATOM    586  CZ  ARG A  38      66.384  33.281  65.870  1.00  0.00           C  
ATOM    587  NH1 ARG A  38      66.793  34.519  65.623  1.00  0.00           N  
ATOM    588  NH2 ARG A  38      67.002  32.256  65.299  1.00  0.00           N  
ATOM    589  H   ARG A  38      60.050  32.251  66.666  1.00  0.00           H  
ATOM    590  HA  ARG A  38      61.949  31.146  68.565  1.00  0.00           H  
ATOM    591  HB2 ARG A  38      62.917  32.252  66.695  1.00  0.00           H  
ATOM    592  HB3 ARG A  38      61.891  33.663  66.907  1.00  0.00           H  
ATOM    593  HG2 ARG A  38      63.084  34.352  68.833  1.00  0.00           H  
ATOM    594  HG3 ARG A  38      63.947  32.816  68.929  1.00  0.00           H  
ATOM    595  HD2 ARG A  38      64.195  34.795  66.662  1.00  0.00           H  
ATOM    596  HD3 ARG A  38      65.323  34.663  68.013  1.00  0.00           H  
ATOM    597  HE  ARG A  38      65.063  32.141  66.833  1.00  0.00           H  
ATOM    598 HH11 ARG A  38      66.327  35.296  66.047  1.00  0.00           H  
ATOM    599 HH12 ARG A  38      67.568  34.675  65.012  1.00  0.00           H  
ATOM    600 HH21 ARG A  38      66.692  31.323  65.478  1.00  0.00           H  
ATOM    601 HH22 ARG A  38      67.779  32.418  64.689  1.00  0.00           H  
ATOM    602  N   VAL A  39      60.039  33.738  69.274  1.00  0.00           N  
ATOM    603  CA  VAL A  39      59.519  34.552  70.368  1.00  0.00           C  
ATOM    604  C   VAL A  39      58.610  33.754  71.298  1.00  0.00           C  
ATOM    605  O   VAL A  39      58.088  34.290  72.275  1.00  0.00           O  
ATOM    606  CB  VAL A  39      58.735  35.767  69.835  1.00  0.00           C  
ATOM    607  CG1 VAL A  39      59.662  36.713  69.088  1.00  0.00           C  
ATOM    608  CG2 VAL A  39      57.593  35.315  68.939  1.00  0.00           C  
ATOM    609  H   VAL A  39      59.682  33.884  68.371  1.00  0.00           H  
ATOM    610  HA  VAL A  39      60.361  34.920  70.937  1.00  0.00           H  
ATOM    611  HB  VAL A  39      58.315  36.297  70.675  1.00  0.00           H  
ATOM    612 HG11 VAL A  39      59.086  37.309  68.397  1.00  0.00           H  
ATOM    613 HG12 VAL A  39      60.399  36.141  68.544  1.00  0.00           H  
ATOM    614 HG13 VAL A  39      60.159  37.361  69.795  1.00  0.00           H  
ATOM    615 HG21 VAL A  39      57.862  35.474  67.904  1.00  0.00           H  
ATOM    616 HG22 VAL A  39      56.705  35.886  69.172  1.00  0.00           H  
ATOM    617 HG23 VAL A  39      57.399  34.265  69.104  1.00  0.00           H  
ATOM    618  N   GLY A  40      58.420  32.476  70.993  1.00  0.00           N  
ATOM    619  CA  GLY A  40      57.567  31.641  71.820  1.00  0.00           C  
ATOM    620  C   GLY A  40      56.330  31.171  71.082  1.00  0.00           C  
ATOM    621  O   GLY A  40      55.883  30.038  71.265  1.00  0.00           O  
ATOM    622  H   GLY A  40      58.857  32.094  70.203  1.00  0.00           H  
ATOM    623  HA2 GLY A  40      58.132  30.777  72.143  1.00  0.00           H  
ATOM    624  HA3 GLY A  40      57.264  32.205  72.690  1.00  0.00           H  
ATOM    625  N   SER A  41      55.783  32.044  70.241  1.00  0.00           N  
ATOM    626  CA  SER A  41      54.594  31.721  69.457  1.00  0.00           C  
ATOM    627  C   SER A  41      54.795  30.416  68.691  1.00  0.00           C  
ATOM    628  O   SER A  41      55.925  30.047  68.374  1.00  0.00           O  
ATOM    629  CB  SER A  41      54.286  32.868  68.490  1.00  0.00           C  
ATOM    630  OG  SER A  41      53.700  33.964  69.168  1.00  0.00           O  
ATOM    631  H   SER A  41      56.196  32.927  70.137  1.00  0.00           H  
ATOM    632  HA  SER A  41      53.767  31.602  70.140  1.00  0.00           H  
ATOM    633  HB2 SER A  41      55.205  33.202  68.034  1.00  0.00           H  
ATOM    634  HB3 SER A  41      53.610  32.525  67.721  1.00  0.00           H  
ATOM    635  HG  SER A  41      53.916  33.918  70.101  1.00  0.00           H  
ATOM    636  N   GLU A  42      53.700  29.714  68.398  1.00  0.00           N  
ATOM    637  CA  GLU A  42      53.795  28.448  67.673  1.00  0.00           C  
ATOM    638  C   GLU A  42      52.635  28.254  66.699  1.00  0.00           C  
ATOM    639  O   GLU A  42      51.518  27.921  67.094  1.00  0.00           O  
ATOM    640  CB  GLU A  42      53.841  27.277  68.657  1.00  0.00           C  
ATOM    641  CG  GLU A  42      55.056  27.292  69.570  1.00  0.00           C  
ATOM    642  CD  GLU A  42      55.081  26.115  70.526  1.00  0.00           C  
ATOM    643  OE1 GLU A  42      55.104  24.962  70.048  1.00  0.00           O  
ATOM    644  OE2 GLU A  42      55.075  26.347  71.753  1.00  0.00           O  
ATOM    645  H   GLU A  42      52.822  30.049  68.671  1.00  0.00           H  
ATOM    646  HA  GLU A  42      54.716  28.463  67.110  1.00  0.00           H  
ATOM    647  HB2 GLU A  42      52.956  27.303  69.272  1.00  0.00           H  
ATOM    648  HB3 GLU A  42      53.851  26.353  68.097  1.00  0.00           H  
ATOM    649  HG2 GLU A  42      55.948  27.260  68.962  1.00  0.00           H  
ATOM    650  HG3 GLU A  42      55.046  28.204  70.146  1.00  0.00           H  
ATOM    651  N   LEU A  43      52.927  28.456  65.419  1.00  0.00           N  
ATOM    652  CA  LEU A  43      51.958  28.305  64.353  1.00  0.00           C  
ATOM    653  C   LEU A  43      52.201  27.016  63.565  1.00  0.00           C  
ATOM    654  O   LEU A  43      53.245  26.379  63.710  1.00  0.00           O  
ATOM    655  CB  LEU A  43      52.012  29.532  63.449  1.00  0.00           C  
ATOM    656  CG  LEU A  43      53.400  29.979  62.972  1.00  0.00           C  
ATOM    657  CD1 LEU A  43      54.201  28.829  62.385  1.00  0.00           C  
ATOM    658  CD2 LEU A  43      53.259  31.097  61.952  1.00  0.00           C  
ATOM    659  H   LEU A  43      53.830  28.724  65.177  1.00  0.00           H  
ATOM    660  HA  LEU A  43      50.980  28.251  64.809  1.00  0.00           H  
ATOM    661  HB2 LEU A  43      51.392  29.351  62.583  1.00  0.00           H  
ATOM    662  HB3 LEU A  43      51.590  30.344  64.010  1.00  0.00           H  
ATOM    663  HG  LEU A  43      53.952  30.370  63.815  1.00  0.00           H  
ATOM    664 HD11 LEU A  43      54.589  28.215  63.185  1.00  0.00           H  
ATOM    665 HD12 LEU A  43      55.021  29.223  61.802  1.00  0.00           H  
ATOM    666 HD13 LEU A  43      53.562  28.234  61.750  1.00  0.00           H  
ATOM    667 HD21 LEU A  43      54.011  30.985  61.186  1.00  0.00           H  
ATOM    668 HD22 LEU A  43      53.385  32.053  62.443  1.00  0.00           H  
ATOM    669 HD23 LEU A  43      52.278  31.054  61.502  1.00  0.00           H  
ATOM    670  N   MET A  44      51.241  26.638  62.725  1.00  0.00           N  
ATOM    671  CA  MET A  44      51.357  25.437  61.908  1.00  0.00           C  
ATOM    672  C   MET A  44      51.661  25.827  60.474  1.00  0.00           C  
ATOM    673  O   MET A  44      51.495  26.986  60.101  1.00  0.00           O  
ATOM    674  CB  MET A  44      50.049  24.657  61.934  1.00  0.00           C  
ATOM    675  CG  MET A  44      49.265  24.849  63.214  1.00  0.00           C  
ATOM    676  SD  MET A  44      47.892  23.691  63.372  1.00  0.00           S  
ATOM    677  CE  MET A  44      46.933  24.099  61.918  1.00  0.00           C  
ATOM    678  H   MET A  44      50.438  27.186  62.627  1.00  0.00           H  
ATOM    679  HA  MET A  44      52.155  24.827  62.298  1.00  0.00           H  
ATOM    680  HB2 MET A  44      49.435  24.985  61.105  1.00  0.00           H  
ATOM    681  HB3 MET A  44      50.265  23.607  61.822  1.00  0.00           H  
ATOM    682  HG2 MET A  44      49.935  24.720  64.044  1.00  0.00           H  
ATOM    683  HG3 MET A  44      48.871  25.856  63.229  1.00  0.00           H  
ATOM    684  HE1 MET A  44      45.943  24.412  62.215  1.00  0.00           H  
ATOM    685  HE2 MET A  44      46.859  23.231  61.279  1.00  0.00           H  
ATOM    686  HE3 MET A  44      47.417  24.901  61.381  1.00  0.00           H  
ATOM    687  N   GLU A  45      52.088  24.863  59.664  1.00  0.00           N  
ATOM    688  CA  GLU A  45      52.389  25.140  58.268  1.00  0.00           C  
ATOM    689  C   GLU A  45      51.265  25.935  57.629  1.00  0.00           C  
ATOM    690  O   GLU A  45      51.497  27.034  57.138  1.00  0.00           O  
ATOM    691  CB  GLU A  45      52.655  23.858  57.501  1.00  0.00           C  
ATOM    692  CG  GLU A  45      53.986  23.217  57.849  1.00  0.00           C  
ATOM    693  CD  GLU A  45      54.286  21.991  57.009  1.00  0.00           C  
ATOM    694  OE1 GLU A  45      53.450  21.637  56.151  1.00  0.00           O  
ATOM    695  OE2 GLU A  45      55.360  21.384  57.208  1.00  0.00           O  
ATOM    696  H   GLU A  45      52.192  23.952  60.010  1.00  0.00           H  
ATOM    697  HA  GLU A  45      53.276  25.737  58.243  1.00  0.00           H  
ATOM    698  HB2 GLU A  45      51.875  23.167  57.732  1.00  0.00           H  
ATOM    699  HB3 GLU A  45      52.642  24.070  56.442  1.00  0.00           H  
ATOM    700  HG2 GLU A  45      54.770  23.947  57.694  1.00  0.00           H  
ATOM    701  HG3 GLU A  45      53.969  22.928  58.890  1.00  0.00           H  
ATOM    702  N   SER A  46      50.051  25.381  57.609  1.00  0.00           N  
ATOM    703  CA  SER A  46      48.903  26.058  57.013  1.00  0.00           C  
ATOM    704  C   SER A  46      48.896  27.556  57.311  1.00  0.00           C  
ATOM    705  O   SER A  46      48.495  28.350  56.464  1.00  0.00           O  
ATOM    706  CB  SER A  46      47.611  25.428  57.534  1.00  0.00           C  
ATOM    707  OG  SER A  46      47.453  25.664  58.923  1.00  0.00           O  
ATOM    708  H   SER A  46      49.893  24.481  57.964  1.00  0.00           H  
ATOM    709  HA  SER A  46      48.953  25.915  55.946  1.00  0.00           H  
ATOM    710  HB2 SER A  46      46.767  25.850  57.010  1.00  0.00           H  
ATOM    711  HB3 SER A  46      47.643  24.361  57.369  1.00  0.00           H  
ATOM    712  HG  SER A  46      48.147  25.209  59.406  1.00  0.00           H  
ATOM    713  N   GLU A  47      49.356  27.944  58.500  1.00  0.00           N  
ATOM    714  CA  GLU A  47      49.407  29.353  58.869  1.00  0.00           C  
ATOM    715  C   GLU A  47      50.414  30.089  57.997  1.00  0.00           C  
ATOM    716  O   GLU A  47      50.166  31.204  57.544  1.00  0.00           O  
ATOM    717  CB  GLU A  47      49.775  29.510  60.349  1.00  0.00           C  
ATOM    718  CG  GLU A  47      48.608  29.277  61.298  1.00  0.00           C  
ATOM    719  CD  GLU A  47      48.203  27.820  61.416  1.00  0.00           C  
ATOM    720  OE1 GLU A  47      48.848  26.968  60.780  1.00  0.00           O  
ATOM    721  OE2 GLU A  47      47.236  27.534  62.154  1.00  0.00           O  
ATOM    722  H   GLU A  47      49.690  27.282  59.139  1.00  0.00           H  
ATOM    723  HA  GLU A  47      48.428  29.775  58.702  1.00  0.00           H  
ATOM    724  HB2 GLU A  47      50.552  28.801  60.588  1.00  0.00           H  
ATOM    725  HB3 GLU A  47      50.149  30.508  60.512  1.00  0.00           H  
ATOM    726  HG2 GLU A  47      48.882  29.636  62.278  1.00  0.00           H  
ATOM    727  HG3 GLU A  47      47.761  29.837  60.935  1.00  0.00           H  
ATOM    728  N   ILE A  48      51.547  29.440  57.755  1.00  0.00           N  
ATOM    729  CA  ILE A  48      52.603  29.997  56.925  1.00  0.00           C  
ATOM    730  C   ILE A  48      52.081  30.340  55.536  1.00  0.00           C  
ATOM    731  O   ILE A  48      52.122  31.495  55.111  1.00  0.00           O  
ATOM    732  CB  ILE A  48      53.782  29.008  56.787  1.00  0.00           C  
ATOM    733  CG1 ILE A  48      54.593  28.969  58.070  1.00  0.00           C  
ATOM    734  CG2 ILE A  48      54.677  29.386  55.615  1.00  0.00           C  
ATOM    735  CD1 ILE A  48      53.865  28.362  59.239  1.00  0.00           C  
ATOM    736  H   ILE A  48      51.673  28.549  58.143  1.00  0.00           H  
ATOM    737  HA  ILE A  48      52.966  30.895  57.398  1.00  0.00           H  
ATOM    738  HB  ILE A  48      53.380  28.019  56.600  1.00  0.00           H  
ATOM    739 HG12 ILE A  48      55.489  28.392  57.905  1.00  0.00           H  
ATOM    740 HG13 ILE A  48      54.863  29.977  58.333  1.00  0.00           H  
ATOM    741 HG21 ILE A  48      54.698  30.461  55.511  1.00  0.00           H  
ATOM    742 HG22 ILE A  48      54.291  28.945  54.710  1.00  0.00           H  
ATOM    743 HG23 ILE A  48      55.678  29.022  55.796  1.00  0.00           H  
ATOM    744 HD11 ILE A  48      53.120  27.669  58.879  1.00  0.00           H  
ATOM    745 HD12 ILE A  48      53.386  29.143  59.809  1.00  0.00           H  
ATOM    746 HD13 ILE A  48      54.570  27.837  59.868  1.00  0.00           H  
ATOM    747  N   LYS A  49      51.594  29.325  54.835  1.00  0.00           N  
ATOM    748  CA  LYS A  49      51.071  29.511  53.494  1.00  0.00           C  
ATOM    749  C   LYS A  49      49.838  30.404  53.527  1.00  0.00           C  
ATOM    750  O   LYS A  49      49.516  31.079  52.545  1.00  0.00           O  
ATOM    751  CB  LYS A  49      50.718  28.157  52.879  1.00  0.00           C  
ATOM    752  CG  LYS A  49      50.440  28.230  51.390  1.00  0.00           C  
ATOM    753  CD  LYS A  49      49.907  26.912  50.855  1.00  0.00           C  
ATOM    754  CE  LYS A  49      49.923  26.894  49.338  1.00  0.00           C  
ATOM    755  NZ  LYS A  49      49.346  28.141  48.766  1.00  0.00           N  
ATOM    756  H   LYS A  49      51.590  28.428  55.229  1.00  0.00           H  
ATOM    757  HA  LYS A  49      51.834  29.984  52.898  1.00  0.00           H  
ATOM    758  HB2 LYS A  49      51.543  27.478  53.039  1.00  0.00           H  
ATOM    759  HB3 LYS A  49      49.840  27.769  53.373  1.00  0.00           H  
ATOM    760  HG2 LYS A  49      49.708  29.002  51.208  1.00  0.00           H  
ATOM    761  HG3 LYS A  49      51.359  28.471  50.874  1.00  0.00           H  
ATOM    762  HD2 LYS A  49      50.524  26.108  51.225  1.00  0.00           H  
ATOM    763  HD3 LYS A  49      48.890  26.778  51.200  1.00  0.00           H  
ATOM    764  HE2 LYS A  49      50.944  26.793  49.004  1.00  0.00           H  
ATOM    765  HE3 LYS A  49      49.345  26.048  48.995  1.00  0.00           H  
ATOM    766  HZ1 LYS A  49      48.577  27.910  48.106  1.00  0.00           H  
ATOM    767  HZ2 LYS A  49      50.080  28.671  48.254  1.00  0.00           H  
ATOM    768  HZ3 LYS A  49      48.968  28.743  49.526  1.00  0.00           H  
ATOM    769  N   ASP A  50      49.158  30.417  54.671  1.00  0.00           N  
ATOM    770  CA  ASP A  50      47.967  31.240  54.836  1.00  0.00           C  
ATOM    771  C   ASP A  50      48.364  32.702  54.905  1.00  0.00           C  
ATOM    772  O   ASP A  50      47.677  33.574  54.379  1.00  0.00           O  
ATOM    773  CB  ASP A  50      47.202  30.852  56.104  1.00  0.00           C  
ATOM    774  CG  ASP A  50      45.910  31.627  56.274  1.00  0.00           C  
ATOM    775  OD1 ASP A  50      45.555  32.405  55.361  1.00  0.00           O  
ATOM    776  OD2 ASP A  50      45.246  31.451  57.316  1.00  0.00           O  
ATOM    777  H   ASP A  50      49.477  29.867  55.425  1.00  0.00           H  
ATOM    778  HA  ASP A  50      47.331  31.089  53.976  1.00  0.00           H  
ATOM    779  HB2 ASP A  50      46.963  29.798  56.062  1.00  0.00           H  
ATOM    780  HB3 ASP A  50      47.828  31.038  56.964  1.00  0.00           H  
ATOM    781  N   LEU A  51      49.490  32.959  55.554  1.00  0.00           N  
ATOM    782  CA  LEU A  51      50.000  34.307  55.696  1.00  0.00           C  
ATOM    783  C   LEU A  51      50.636  34.765  54.389  1.00  0.00           C  
ATOM    784  O   LEU A  51      50.741  35.958  54.125  1.00  0.00           O  
ATOM    785  CB  LEU A  51      51.009  34.368  56.847  1.00  0.00           C  
ATOM    786  CG  LEU A  51      51.599  35.749  57.128  1.00  0.00           C  
ATOM    787  CD1 LEU A  51      52.001  35.865  58.592  1.00  0.00           C  
ATOM    788  CD2 LEU A  51      52.803  36.008  56.239  1.00  0.00           C  
ATOM    789  H   LEU A  51      49.994  32.214  55.944  1.00  0.00           H  
ATOM    790  HA  LEU A  51      49.166  34.956  55.923  1.00  0.00           H  
ATOM    791  HB2 LEU A  51      50.518  34.021  57.743  1.00  0.00           H  
ATOM    792  HB3 LEU A  51      51.822  33.695  56.620  1.00  0.00           H  
ATOM    793  HG  LEU A  51      50.855  36.502  56.915  1.00  0.00           H  
ATOM    794 HD11 LEU A  51      51.321  35.285  59.198  1.00  0.00           H  
ATOM    795 HD12 LEU A  51      51.959  36.902  58.895  1.00  0.00           H  
ATOM    796 HD13 LEU A  51      53.006  35.492  58.721  1.00  0.00           H  
ATOM    797 HD21 LEU A  51      52.548  36.745  55.492  1.00  0.00           H  
ATOM    798 HD22 LEU A  51      53.095  35.090  55.751  1.00  0.00           H  
ATOM    799 HD23 LEU A  51      53.623  36.372  56.839  1.00  0.00           H  
ATOM    800  N   MET A  52      51.047  33.805  53.571  1.00  0.00           N  
ATOM    801  CA  MET A  52      51.662  34.108  52.287  1.00  0.00           C  
ATOM    802  C   MET A  52      50.638  34.635  51.288  1.00  0.00           C  
ATOM    803  O   MET A  52      50.888  35.601  50.575  1.00  0.00           O  
ATOM    804  CB  MET A  52      52.333  32.862  51.714  1.00  0.00           C  
ATOM    805  CG  MET A  52      53.629  32.485  52.407  1.00  0.00           C  
ATOM    806  SD  MET A  52      54.850  33.813  52.362  1.00  0.00           S  
ATOM    807  CE  MET A  52      56.282  32.990  53.052  1.00  0.00           C  
ATOM    808  H   MET A  52      50.930  32.868  53.832  1.00  0.00           H  
ATOM    809  HA  MET A  52      52.414  34.861  52.449  1.00  0.00           H  
ATOM    810  HB2 MET A  52      51.650  32.033  51.805  1.00  0.00           H  
ATOM    811  HB3 MET A  52      52.542  33.031  50.671  1.00  0.00           H  
ATOM    812  HG2 MET A  52      53.413  32.246  53.436  1.00  0.00           H  
ATOM    813  HG3 MET A  52      54.044  31.617  51.916  1.00  0.00           H  
ATOM    814  HE1 MET A  52      56.675  32.289  52.330  1.00  0.00           H  
ATOM    815  HE2 MET A  52      55.996  32.462  53.949  1.00  0.00           H  
ATOM    816  HE3 MET A  52      57.041  33.723  53.292  1.00  0.00           H  
ATOM    817  N   ASP A  53      49.490  33.985  51.220  1.00  0.00           N  
ATOM    818  CA  ASP A  53      48.454  34.399  50.279  1.00  0.00           C  
ATOM    819  C   ASP A  53      47.540  35.468  50.870  1.00  0.00           C  
ATOM    820  O   ASP A  53      46.994  36.295  50.141  1.00  0.00           O  
ATOM    821  CB  ASP A  53      47.627  33.189  49.836  1.00  0.00           C  
ATOM    822  CG  ASP A  53      46.557  33.559  48.829  1.00  0.00           C  
ATOM    823  OD1 ASP A  53      46.911  34.083  47.751  1.00  0.00           O  
ATOM    824  OD2 ASP A  53      45.364  33.325  49.117  1.00  0.00           O  
ATOM    825  H   ASP A  53      49.339  33.208  51.802  1.00  0.00           H  
ATOM    826  HA  ASP A  53      48.952  34.816  49.413  1.00  0.00           H  
ATOM    827  HB2 ASP A  53      48.282  32.459  49.388  1.00  0.00           H  
ATOM    828  HB3 ASP A  53      47.148  32.756  50.700  1.00  0.00           H  
ATOM    829  N   ALA A  54      47.358  35.435  52.184  1.00  0.00           N  
ATOM    830  CA  ALA A  54      46.485  36.396  52.848  1.00  0.00           C  
ATOM    831  C   ALA A  54      47.229  37.644  53.326  1.00  0.00           C  
ATOM    832  O   ALA A  54      46.603  38.671  53.592  1.00  0.00           O  
ATOM    833  CB  ALA A  54      45.766  35.735  54.014  1.00  0.00           C  
ATOM    834  H   ALA A  54      47.804  34.744  52.715  1.00  0.00           H  
ATOM    835  HA  ALA A  54      45.734  36.696  52.131  1.00  0.00           H  
ATOM    836  HB1 ALA A  54      45.621  34.687  53.801  1.00  0.00           H  
ATOM    837  HB2 ALA A  54      44.805  36.208  54.160  1.00  0.00           H  
ATOM    838  HB3 ALA A  54      46.358  35.841  54.910  1.00  0.00           H  
ATOM    839  N   ALA A  55      48.554  37.566  53.459  1.00  0.00           N  
ATOM    840  CA  ALA A  55      49.324  38.717  53.936  1.00  0.00           C  
ATOM    841  C   ALA A  55      50.480  39.092  53.011  1.00  0.00           C  
ATOM    842  O   ALA A  55      50.693  40.273  52.740  1.00  0.00           O  
ATOM    843  CB  ALA A  55      49.839  38.458  55.342  1.00  0.00           C  
ATOM    844  H   ALA A  55      49.015  36.725  53.252  1.00  0.00           H  
ATOM    845  HA  ALA A  55      48.649  39.557  53.985  1.00  0.00           H  
ATOM    846  HB1 ALA A  55      49.339  39.115  56.036  1.00  0.00           H  
ATOM    847  HB2 ALA A  55      50.904  38.642  55.375  1.00  0.00           H  
ATOM    848  HB3 ALA A  55      49.644  37.431  55.614  1.00  0.00           H  
ATOM    849  N   ASP A  56      51.229  38.102  52.530  1.00  0.00           N  
ATOM    850  CA  ASP A  56      52.352  38.383  51.642  1.00  0.00           C  
ATOM    851  C   ASP A  56      51.846  39.065  50.373  1.00  0.00           C  
ATOM    852  O   ASP A  56      51.387  38.405  49.439  1.00  0.00           O  
ATOM    853  CB  ASP A  56      53.118  37.098  51.302  1.00  0.00           C  
ATOM    854  CG  ASP A  56      54.412  37.368  50.559  1.00  0.00           C  
ATOM    855  OD1 ASP A  56      54.385  38.139  49.581  1.00  0.00           O  
ATOM    856  OD2 ASP A  56      55.449  36.794  50.945  1.00  0.00           O  
ATOM    857  H   ASP A  56      51.024  37.177  52.772  1.00  0.00           H  
ATOM    858  HA  ASP A  56      53.016  39.063  52.157  1.00  0.00           H  
ATOM    859  HB2 ASP A  56      53.354  36.573  52.219  1.00  0.00           H  
ATOM    860  HB3 ASP A  56      52.495  36.470  50.685  1.00  0.00           H  
ATOM    861  N   ILE A  57      51.915  40.392  50.370  1.00  0.00           N  
ATOM    862  CA  ILE A  57      51.449  41.205  49.247  1.00  0.00           C  
ATOM    863  C   ILE A  57      51.984  40.697  47.911  1.00  0.00           C  
ATOM    864  O   ILE A  57      51.408  40.968  46.857  1.00  0.00           O  
ATOM    865  CB  ILE A  57      51.873  42.677  49.426  1.00  0.00           C  
ATOM    866  CG1 ILE A  57      51.538  43.160  50.841  1.00  0.00           C  
ATOM    867  CG2 ILE A  57      51.199  43.558  48.383  1.00  0.00           C  
ATOM    868  CD1 ILE A  57      50.064  43.094  51.179  1.00  0.00           C  
ATOM    869  H   ILE A  57      52.275  40.843  51.162  1.00  0.00           H  
ATOM    870  HA  ILE A  57      50.369  41.166  49.230  1.00  0.00           H  
ATOM    871  HB  ILE A  57      52.940  42.739  49.278  1.00  0.00           H  
ATOM    872 HG12 ILE A  57      52.069  42.546  51.557  1.00  0.00           H  
ATOM    873 HG13 ILE A  57      51.859  44.187  50.948  1.00  0.00           H  
ATOM    874 HG21 ILE A  57      50.139  43.611  48.587  1.00  0.00           H  
ATOM    875 HG22 ILE A  57      51.356  43.138  47.402  1.00  0.00           H  
ATOM    876 HG23 ILE A  57      51.622  44.551  48.422  1.00  0.00           H  
ATOM    877 HD11 ILE A  57      49.918  42.452  52.035  1.00  0.00           H  
ATOM    878 HD12 ILE A  57      49.518  42.698  50.336  1.00  0.00           H  
ATOM    879 HD13 ILE A  57      49.700  44.086  51.409  1.00  0.00           H  
ATOM    880  N   ASP A  58      53.090  39.966  47.960  1.00  0.00           N  
ATOM    881  CA  ASP A  58      53.707  39.429  46.748  1.00  0.00           C  
ATOM    882  C   ASP A  58      53.973  37.933  46.892  1.00  0.00           C  
ATOM    883  O   ASP A  58      55.064  37.461  46.576  1.00  0.00           O  
ATOM    884  CB  ASP A  58      55.011  40.170  46.443  1.00  0.00           C  
ATOM    885  CG  ASP A  58      55.593  39.806  45.089  1.00  0.00           C  
ATOM    886  OD1 ASP A  58      54.963  39.006  44.366  1.00  0.00           O  
ATOM    887  OD2 ASP A  58      56.677  40.326  44.752  1.00  0.00           O  
ATOM    888  H   ASP A  58      53.506  39.788  48.835  1.00  0.00           H  
ATOM    889  HA  ASP A  58      53.018  39.582  45.932  1.00  0.00           H  
ATOM    890  HB2 ASP A  58      54.825  41.231  46.458  1.00  0.00           H  
ATOM    891  HB3 ASP A  58      55.739  39.928  47.203  1.00  0.00           H  
ATOM    892  N   LYS A  59      52.982  37.211  47.422  1.00  0.00           N  
ATOM    893  CA  LYS A  59      53.094  35.781  47.679  1.00  0.00           C  
ATOM    894  C   LYS A  59      53.980  35.068  46.663  1.00  0.00           C  
ATOM    895  O   LYS A  59      53.518  34.575  45.633  1.00  0.00           O  
ATOM    896  CB  LYS A  59      51.704  35.140  47.715  1.00  0.00           C  
ATOM    897  CG  LYS A  59      51.670  33.732  48.314  1.00  0.00           C  
ATOM    898  CD  LYS A  59      52.290  32.691  47.395  1.00  0.00           C  
ATOM    899  CE  LYS A  59      52.272  31.305  48.020  1.00  0.00           C  
ATOM    900  NZ  LYS A  59      53.065  31.252  49.279  1.00  0.00           N  
ATOM    901  H   LYS A  59      52.167  37.663  47.706  1.00  0.00           H  
ATOM    902  HA  LYS A  59      53.534  35.671  48.653  1.00  0.00           H  
ATOM    903  HB2 LYS A  59      51.060  35.768  48.308  1.00  0.00           H  
ATOM    904  HB3 LYS A  59      51.316  35.090  46.709  1.00  0.00           H  
ATOM    905  HG2 LYS A  59      52.216  33.739  49.246  1.00  0.00           H  
ATOM    906  HG3 LYS A  59      50.641  33.462  48.506  1.00  0.00           H  
ATOM    907  HD2 LYS A  59      51.731  32.665  46.473  1.00  0.00           H  
ATOM    908  HD3 LYS A  59      53.313  32.971  47.190  1.00  0.00           H  
ATOM    909  HE2 LYS A  59      51.252  31.033  48.239  1.00  0.00           H  
ATOM    910  HE3 LYS A  59      52.689  30.602  47.316  1.00  0.00           H  
ATOM    911  HZ1 LYS A  59      53.498  32.178  49.469  1.00  0.00           H  
ATOM    912  HZ2 LYS A  59      53.821  30.540  49.195  1.00  0.00           H  
ATOM    913  HZ3 LYS A  59      52.452  30.996  50.077  1.00  0.00           H  
ATOM    914  N   SER A  60      55.258  35.007  47.002  1.00  0.00           N  
ATOM    915  CA  SER A  60      56.263  34.337  46.192  1.00  0.00           C  
ATOM    916  C   SER A  60      57.016  33.359  47.082  1.00  0.00           C  
ATOM    917  O   SER A  60      58.122  32.917  46.768  1.00  0.00           O  
ATOM    918  CB  SER A  60      57.229  35.351  45.577  1.00  0.00           C  
ATOM    919  OG  SER A  60      57.901  36.091  46.581  1.00  0.00           O  
ATOM    920  H   SER A  60      55.533  35.412  47.850  1.00  0.00           H  
ATOM    921  HA  SER A  60      55.759  33.791  45.406  1.00  0.00           H  
ATOM    922  HB2 SER A  60      57.961  34.830  44.978  1.00  0.00           H  
ATOM    923  HB3 SER A  60      56.677  36.038  44.950  1.00  0.00           H  
ATOM    924  HG  SER A  60      58.557  36.662  46.173  1.00  0.00           H  
ATOM    925  N   GLY A  61      56.392  33.050  48.217  1.00  0.00           N  
ATOM    926  CA  GLY A  61      56.987  32.152  49.189  1.00  0.00           C  
ATOM    927  C   GLY A  61      58.165  32.797  49.888  1.00  0.00           C  
ATOM    928  O   GLY A  61      58.991  32.109  50.494  1.00  0.00           O  
ATOM    929  H   GLY A  61      55.520  33.460  48.392  1.00  0.00           H  
ATOM    930  HA2 GLY A  61      56.242  31.885  49.923  1.00  0.00           H  
ATOM    931  HA3 GLY A  61      57.324  31.260  48.683  1.00  0.00           H  
ATOM    932  N   THR A  62      58.233  34.128  49.796  1.00  0.00           N  
ATOM    933  CA  THR A  62      59.304  34.901  50.405  1.00  0.00           C  
ATOM    934  C   THR A  62      58.808  36.297  50.791  1.00  0.00           C  
ATOM    935  O   THR A  62      58.243  37.012  49.965  1.00  0.00           O  
ATOM    936  CB  THR A  62      60.473  35.022  49.426  1.00  0.00           C  
ATOM    937  OG1 THR A  62      60.956  33.743  49.057  1.00  0.00           O  
ATOM    938  CG2 THR A  62      61.641  35.811  49.976  1.00  0.00           C  
ATOM    939  H   THR A  62      57.537  34.605  49.303  1.00  0.00           H  
ATOM    940  HA  THR A  62      59.634  34.381  51.291  1.00  0.00           H  
ATOM    941  HB  THR A  62      60.128  35.524  48.533  1.00  0.00           H  
ATOM    942  HG1 THR A  62      60.580  33.079  49.641  1.00  0.00           H  
ATOM    943 HG21 THR A  62      62.252  35.168  50.590  1.00  0.00           H  
ATOM    944 HG22 THR A  62      61.272  36.635  50.570  1.00  0.00           H  
ATOM    945 HG23 THR A  62      62.234  36.195  49.158  1.00  0.00           H  
ATOM    946  N   ILE A  63      59.018  36.676  52.053  1.00  0.00           N  
ATOM    947  CA  ILE A  63      58.586  37.974  52.540  1.00  0.00           C  
ATOM    948  C   ILE A  63      59.768  38.902  52.767  1.00  0.00           C  
ATOM    949  O   ILE A  63      60.735  38.545  53.438  1.00  0.00           O  
ATOM    950  CB  ILE A  63      57.791  37.859  53.857  1.00  0.00           C  
ATOM    951  CG1 ILE A  63      56.464  37.140  53.622  1.00  0.00           C  
ATOM    952  CG2 ILE A  63      57.550  39.237  54.460  1.00  0.00           C  
ATOM    953  CD1 ILE A  63      55.648  36.948  54.882  1.00  0.00           C  
ATOM    954  H   ILE A  63      59.459  36.060  52.666  1.00  0.00           H  
ATOM    955  HA  ILE A  63      57.945  38.404  51.792  1.00  0.00           H  
ATOM    956  HB  ILE A  63      58.381  37.287  54.556  1.00  0.00           H  
ATOM    957 HG12 ILE A  63      55.866  37.716  52.927  1.00  0.00           H  
ATOM    958 HG13 ILE A  63      56.658  36.165  53.198  1.00  0.00           H  
ATOM    959 HG21 ILE A  63      56.497  39.361  54.667  1.00  0.00           H  
ATOM    960 HG22 ILE A  63      57.870  39.997  53.764  1.00  0.00           H  
ATOM    961 HG23 ILE A  63      58.110  39.329  55.379  1.00  0.00           H  
ATOM    962 HD11 ILE A  63      54.881  36.210  54.706  1.00  0.00           H  
ATOM    963 HD12 ILE A  63      55.189  37.886  55.158  1.00  0.00           H  
ATOM    964 HD13 ILE A  63      56.295  36.614  55.680  1.00  0.00           H  
ATOM    965  N   ASP A  64      59.672  40.100  52.215  1.00  0.00           N  
ATOM    966  CA  ASP A  64      60.723  41.091  52.365  1.00  0.00           C  
ATOM    967  C   ASP A  64      60.293  42.161  53.352  1.00  0.00           C  
ATOM    968  O   ASP A  64      59.125  42.226  53.728  1.00  0.00           O  
ATOM    969  CB  ASP A  64      61.083  41.715  51.015  1.00  0.00           C  
ATOM    970  CG  ASP A  64      61.571  40.686  50.014  1.00  0.00           C  
ATOM    971  OD1 ASP A  64      62.585  40.016  50.298  1.00  0.00           O  
ATOM    972  OD2 ASP A  64      60.937  40.550  48.946  1.00  0.00           O  
ATOM    973  H   ASP A  64      58.872  40.331  51.699  1.00  0.00           H  
ATOM    974  HA  ASP A  64      61.585  40.582  52.769  1.00  0.00           H  
ATOM    975  HB2 ASP A  64      60.211  42.203  50.605  1.00  0.00           H  
ATOM    976  HB3 ASP A  64      61.862  42.446  51.162  1.00  0.00           H  
ATOM    977  N   TYR A  65      61.248  42.984  53.783  1.00  0.00           N  
ATOM    978  CA  TYR A  65      60.980  44.045  54.748  1.00  0.00           C  
ATOM    979  C   TYR A  65      59.599  44.656  54.537  1.00  0.00           C  
ATOM    980  O   TYR A  65      58.848  44.856  55.492  1.00  0.00           O  
ATOM    981  CB  TYR A  65      62.044  45.138  54.644  1.00  0.00           C  
ATOM    982  CG  TYR A  65      61.814  46.288  55.593  1.00  0.00           C  
ATOM    983  CD1 TYR A  65      61.774  46.082  56.965  1.00  0.00           C  
ATOM    984  CD2 TYR A  65      61.628  47.579  55.117  1.00  0.00           C  
ATOM    985  CE1 TYR A  65      61.558  47.130  57.837  1.00  0.00           C  
ATOM    986  CE2 TYR A  65      61.412  48.634  55.980  1.00  0.00           C  
ATOM    987  CZ  TYR A  65      61.377  48.405  57.340  1.00  0.00           C  
ATOM    988  OH  TYR A  65      61.162  49.453  58.206  1.00  0.00           O  
ATOM    989  H   TYR A  65      62.161  42.873  53.445  1.00  0.00           H  
ATOM    990  HA  TYR A  65      61.021  43.612  55.737  1.00  0.00           H  
ATOM    991  HB2 TYR A  65      63.011  44.712  54.865  1.00  0.00           H  
ATOM    992  HB3 TYR A  65      62.049  45.530  53.636  1.00  0.00           H  
ATOM    993  HD1 TYR A  65      61.918  45.084  57.350  1.00  0.00           H  
ATOM    994  HD2 TYR A  65      61.657  47.755  54.051  1.00  0.00           H  
ATOM    995  HE1 TYR A  65      61.533  46.947  58.901  1.00  0.00           H  
ATOM    996  HE2 TYR A  65      61.268  49.629  55.590  1.00  0.00           H  
ATOM    997  HH  TYR A  65      61.531  49.240  59.066  1.00  0.00           H  
ATOM    998  N   GLY A  66      59.267  44.946  53.284  1.00  0.00           N  
ATOM    999  CA  GLY A  66      57.976  45.526  52.985  1.00  0.00           C  
ATOM   1000  C   GLY A  66      56.832  44.588  53.317  1.00  0.00           C  
ATOM   1001  O   GLY A  66      56.012  44.884  54.187  1.00  0.00           O  
ATOM   1002  H   GLY A  66      59.904  44.764  52.562  1.00  0.00           H  
ATOM   1003  HA2 GLY A  66      57.864  46.427  53.566  1.00  0.00           H  
ATOM   1004  HA3 GLY A  66      57.937  45.777  51.938  1.00  0.00           H  
ATOM   1005  N   GLU A  67      56.779  43.453  52.623  1.00  0.00           N  
ATOM   1006  CA  GLU A  67      55.733  42.463  52.849  1.00  0.00           C  
ATOM   1007  C   GLU A  67      55.633  42.103  54.329  1.00  0.00           C  
ATOM   1008  O   GLU A  67      54.573  41.698  54.807  1.00  0.00           O  
ATOM   1009  CB  GLU A  67      56.028  41.210  52.024  1.00  0.00           C  
ATOM   1010  CG  GLU A  67      56.336  41.509  50.565  1.00  0.00           C  
ATOM   1011  CD  GLU A  67      56.752  40.275  49.789  1.00  0.00           C  
ATOM   1012  OE1 GLU A  67      56.737  39.172  50.374  1.00  0.00           O  
ATOM   1013  OE2 GLU A  67      57.092  40.412  48.597  1.00  0.00           O  
ATOM   1014  H   GLU A  67      57.459  43.272  51.941  1.00  0.00           H  
ATOM   1015  HA  GLU A  67      54.795  42.887  52.523  1.00  0.00           H  
ATOM   1016  HB2 GLU A  67      56.879  40.702  52.454  1.00  0.00           H  
ATOM   1017  HB3 GLU A  67      55.170  40.557  52.063  1.00  0.00           H  
ATOM   1018  HG2 GLU A  67      55.455  41.925  50.101  1.00  0.00           H  
ATOM   1019  HG3 GLU A  67      57.139  42.230  50.521  1.00  0.00           H  
ATOM   1020  N   PHE A  68      56.742  42.261  55.052  1.00  0.00           N  
ATOM   1021  CA  PHE A  68      56.782  41.959  56.473  1.00  0.00           C  
ATOM   1022  C   PHE A  68      55.855  42.876  57.246  1.00  0.00           C  
ATOM   1023  O   PHE A  68      54.885  42.437  57.859  1.00  0.00           O  
ATOM   1024  CB  PHE A  68      58.192  42.160  57.013  1.00  0.00           C  
ATOM   1025  CG  PHE A  68      58.331  41.787  58.457  1.00  0.00           C  
ATOM   1026  CD1 PHE A  68      58.243  40.463  58.839  1.00  0.00           C  
ATOM   1027  CD2 PHE A  68      58.538  42.752  59.427  1.00  0.00           C  
ATOM   1028  CE1 PHE A  68      58.361  40.104  60.165  1.00  0.00           C  
ATOM   1029  CE2 PHE A  68      58.651  42.400  60.757  1.00  0.00           C  
ATOM   1030  CZ  PHE A  68      58.561  41.073  61.126  1.00  0.00           C  
ATOM   1031  H   PHE A  68      57.557  42.590  54.622  1.00  0.00           H  
ATOM   1032  HA  PHE A  68      56.482  40.932  56.620  1.00  0.00           H  
ATOM   1033  HB2 PHE A  68      58.877  41.560  56.453  1.00  0.00           H  
ATOM   1034  HB3 PHE A  68      58.461  43.198  56.904  1.00  0.00           H  
ATOM   1035  HD1 PHE A  68      58.090  39.704  58.083  1.00  0.00           H  
ATOM   1036  HD2 PHE A  68      58.610  43.789  59.140  1.00  0.00           H  
ATOM   1037  HE1 PHE A  68      58.289  39.066  60.451  1.00  0.00           H  
ATOM   1038  HE2 PHE A  68      58.814  43.161  61.508  1.00  0.00           H  
ATOM   1039  HZ  PHE A  68      58.651  40.793  62.166  1.00  0.00           H  
ATOM   1040  N   ILE A  69      56.202  44.152  57.224  1.00  0.00           N  
ATOM   1041  CA  ILE A  69      55.453  45.171  57.933  1.00  0.00           C  
ATOM   1042  C   ILE A  69      53.966  45.118  57.590  1.00  0.00           C  
ATOM   1043  O   ILE A  69      53.116  45.259  58.471  1.00  0.00           O  
ATOM   1044  CB  ILE A  69      55.999  46.574  57.625  1.00  0.00           C  
ATOM   1045  CG1 ILE A  69      57.533  46.588  57.644  1.00  0.00           C  
ATOM   1046  CG2 ILE A  69      55.465  47.553  58.643  1.00  0.00           C  
ATOM   1047  CD1 ILE A  69      58.135  46.148  58.962  1.00  0.00           C  
ATOM   1048  H   ILE A  69      57.003  44.414  56.728  1.00  0.00           H  
ATOM   1049  HA  ILE A  69      55.570  44.991  58.992  1.00  0.00           H  
ATOM   1050  HB  ILE A  69      55.649  46.874  56.647  1.00  0.00           H  
ATOM   1051 HG12 ILE A  69      57.902  45.927  56.876  1.00  0.00           H  
ATOM   1052 HG13 ILE A  69      57.880  47.591  57.442  1.00  0.00           H  
ATOM   1053 HG21 ILE A  69      55.651  47.164  59.631  1.00  0.00           H  
ATOM   1054 HG22 ILE A  69      54.404  47.678  58.497  1.00  0.00           H  
ATOM   1055 HG23 ILE A  69      55.964  48.500  58.525  1.00  0.00           H  
ATOM   1056 HD11 ILE A  69      57.354  45.775  59.610  1.00  0.00           H  
ATOM   1057 HD12 ILE A  69      58.622  46.988  59.434  1.00  0.00           H  
ATOM   1058 HD13 ILE A  69      58.858  45.365  58.785  1.00  0.00           H  
ATOM   1059  N   ALA A  70      53.655  44.907  56.316  1.00  0.00           N  
ATOM   1060  CA  ALA A  70      52.265  44.829  55.877  1.00  0.00           C  
ATOM   1061  C   ALA A  70      51.592  43.587  56.449  1.00  0.00           C  
ATOM   1062  O   ALA A  70      50.373  43.546  56.619  1.00  0.00           O  
ATOM   1063  CB  ALA A  70      52.187  44.827  54.357  1.00  0.00           C  
ATOM   1064  H   ALA A  70      54.373  44.796  55.657  1.00  0.00           H  
ATOM   1065  HA  ALA A  70      51.751  45.706  56.241  1.00  0.00           H  
ATOM   1066  HB1 ALA A  70      53.171  44.650  53.945  1.00  0.00           H  
ATOM   1067  HB2 ALA A  70      51.822  45.783  54.013  1.00  0.00           H  
ATOM   1068  HB3 ALA A  70      51.515  44.048  54.032  1.00  0.00           H  
ATOM   1069  N   ALA A  71      52.403  42.577  56.744  1.00  0.00           N  
ATOM   1070  CA  ALA A  71      51.905  41.325  57.304  1.00  0.00           C  
ATOM   1071  C   ALA A  71      52.004  41.329  58.827  1.00  0.00           C  
ATOM   1072  O   ALA A  71      51.435  40.467  59.496  1.00  0.00           O  
ATOM   1073  CB  ALA A  71      52.670  40.144  56.723  1.00  0.00           C  
ATOM   1074  H   ALA A  71      53.363  42.686  56.583  1.00  0.00           H  
ATOM   1075  HA  ALA A  71      50.867  41.225  57.023  1.00  0.00           H  
ATOM   1076  HB1 ALA A  71      52.152  39.229  56.962  1.00  0.00           H  
ATOM   1077  HB2 ALA A  71      53.665  40.117  57.145  1.00  0.00           H  
ATOM   1078  HB3 ALA A  71      52.736  40.252  55.651  1.00  0.00           H  
ATOM   1079  N   THR A  72      52.736  42.299  59.368  1.00  0.00           N  
ATOM   1080  CA  THR A  72      52.917  42.414  60.810  1.00  0.00           C  
ATOM   1081  C   THR A  72      51.794  43.239  61.431  1.00  0.00           C  
ATOM   1082  O   THR A  72      51.248  42.874  62.473  1.00  0.00           O  
ATOM   1083  CB  THR A  72      54.274  43.054  61.114  1.00  0.00           C  
ATOM   1084  OG1 THR A  72      55.316  42.346  60.470  1.00  0.00           O  
ATOM   1085  CG2 THR A  72      54.606  43.103  62.588  1.00  0.00           C  
ATOM   1086  H   THR A  72      53.172  42.954  58.783  1.00  0.00           H  
ATOM   1087  HA  THR A  72      52.896  41.418  61.228  1.00  0.00           H  
ATOM   1088  HB  THR A  72      54.273  44.068  60.741  1.00  0.00           H  
ATOM   1089  HG1 THR A  72      56.161  42.611  60.841  1.00  0.00           H  
ATOM   1090 HG21 THR A  72      55.675  43.193  62.712  1.00  0.00           H  
ATOM   1091 HG22 THR A  72      54.264  42.196  63.065  1.00  0.00           H  
ATOM   1092 HG23 THR A  72      54.118  43.954  63.041  1.00  0.00           H  
ATOM   1093  N   VAL A  73      51.448  44.349  60.782  1.00  0.00           N  
ATOM   1094  CA  VAL A  73      50.385  45.221  61.266  1.00  0.00           C  
ATOM   1095  C   VAL A  73      49.035  44.519  61.179  1.00  0.00           C  
ATOM   1096  O   VAL A  73      48.071  44.908  61.841  1.00  0.00           O  
ATOM   1097  CB  VAL A  73      50.327  46.537  60.462  1.00  0.00           C  
ATOM   1098  CG1 VAL A  73      49.243  47.457  61.007  1.00  0.00           C  
ATOM   1099  CG2 VAL A  73      51.679  47.233  60.479  1.00  0.00           C  
ATOM   1100  H   VAL A  73      51.918  44.581  59.954  1.00  0.00           H  
ATOM   1101  HA  VAL A  73      50.590  45.457  62.298  1.00  0.00           H  
ATOM   1102  HB  VAL A  73      50.082  46.299  59.438  1.00  0.00           H  
ATOM   1103 HG11 VAL A  73      49.419  47.640  62.057  1.00  0.00           H  
ATOM   1104 HG12 VAL A  73      48.277  46.991  60.882  1.00  0.00           H  
ATOM   1105 HG13 VAL A  73      49.262  48.393  60.470  1.00  0.00           H  
ATOM   1106 HG21 VAL A  73      51.869  47.674  59.511  1.00  0.00           H  
ATOM   1107 HG22 VAL A  73      52.452  46.514  60.704  1.00  0.00           H  
ATOM   1108 HG23 VAL A  73      51.678  48.007  61.234  1.00  0.00           H  
ATOM   1109  N   HIS A  74      48.984  43.465  60.375  1.00  0.00           N  
ATOM   1110  CA  HIS A  74      47.768  42.682  60.210  1.00  0.00           C  
ATOM   1111  C   HIS A  74      47.514  41.897  61.483  1.00  0.00           C  
ATOM   1112  O   HIS A  74      46.409  41.896  62.029  1.00  0.00           O  
ATOM   1113  CB  HIS A  74      47.904  41.724  59.026  1.00  0.00           C  
ATOM   1114  CG  HIS A  74      46.666  40.928  58.751  1.00  0.00           C  
ATOM   1115  ND1 HIS A  74      45.460  41.502  58.412  1.00  0.00           N  
ATOM   1116  CD2 HIS A  74      46.452  39.591  58.771  1.00  0.00           C  
ATOM   1117  CE1 HIS A  74      44.556  40.554  58.236  1.00  0.00           C  
ATOM   1118  NE2 HIS A  74      45.133  39.385  58.446  1.00  0.00           N  
ATOM   1119  H   HIS A  74      49.792  43.196  59.898  1.00  0.00           H  
ATOM   1120  HA  HIS A  74      46.944  43.359  60.038  1.00  0.00           H  
ATOM   1121  HB2 HIS A  74      48.138  42.293  58.139  1.00  0.00           H  
ATOM   1122  HB3 HIS A  74      48.707  41.032  59.226  1.00  0.00           H  
ATOM   1123  HD1 HIS A  74      45.289  42.462  58.316  1.00  0.00           H  
ATOM   1124  HD2 HIS A  74      47.183  38.826  58.999  1.00  0.00           H  
ATOM   1125  HE1 HIS A  74      43.522  40.708  57.963  1.00  0.00           H  
ATOM   1126  HE2 HIS A  74      44.666  38.525  58.490  1.00  0.00           H  
ATOM   1127  N   LEU A  75      48.568  41.253  61.957  1.00  0.00           N  
ATOM   1128  CA  LEU A  75      48.513  40.483  63.181  1.00  0.00           C  
ATOM   1129  C   LEU A  75      48.667  41.419  64.369  1.00  0.00           C  
ATOM   1130  O   LEU A  75      48.677  40.990  65.522  1.00  0.00           O  
ATOM   1131  CB  LEU A  75      49.629  39.437  63.189  1.00  0.00           C  
ATOM   1132  CG  LEU A  75      49.576  38.421  62.045  1.00  0.00           C  
ATOM   1133  CD1 LEU A  75      50.781  37.495  62.100  1.00  0.00           C  
ATOM   1134  CD2 LEU A  75      48.283  37.619  62.097  1.00  0.00           C  
ATOM   1135  H   LEU A  75      49.422  41.321  61.477  1.00  0.00           H  
ATOM   1136  HA  LEU A  75      47.554  39.991  63.233  1.00  0.00           H  
ATOM   1137  HB2 LEU A  75      50.577  39.956  63.135  1.00  0.00           H  
ATOM   1138  HB3 LEU A  75      49.585  38.897  64.123  1.00  0.00           H  
ATOM   1139  HG  LEU A  75      49.604  38.952  61.104  1.00  0.00           H  
ATOM   1140 HD11 LEU A  75      50.878  37.090  63.095  1.00  0.00           H  
ATOM   1141 HD12 LEU A  75      51.673  38.050  61.848  1.00  0.00           H  
ATOM   1142 HD13 LEU A  75      50.647  36.690  61.393  1.00  0.00           H  
ATOM   1143 HD21 LEU A  75      47.727  37.890  62.984  1.00  0.00           H  
ATOM   1144 HD22 LEU A  75      48.517  36.564  62.127  1.00  0.00           H  
ATOM   1145 HD23 LEU A  75      47.692  37.832  61.221  1.00  0.00           H  
ATOM   1146  N   ASN A  76      48.797  42.709  64.065  1.00  0.00           N  
ATOM   1147  CA  ASN A  76      48.960  43.725  65.093  1.00  0.00           C  
ATOM   1148  C   ASN A  76      47.655  44.484  65.324  1.00  0.00           C  
ATOM   1149  O   ASN A  76      47.508  45.630  64.899  1.00  0.00           O  
ATOM   1150  CB  ASN A  76      50.076  44.698  64.702  1.00  0.00           C  
ATOM   1151  CG  ASN A  76      50.381  45.733  65.776  1.00  0.00           C  
ATOM   1152  OD1 ASN A  76      51.194  46.634  65.566  1.00  0.00           O  
ATOM   1153  ND2 ASN A  76      49.742  45.606  66.937  1.00  0.00           N  
ATOM   1154  H   ASN A  76      48.786  42.983  63.124  1.00  0.00           H  
ATOM   1155  HA  ASN A  76      49.234  43.222  66.001  1.00  0.00           H  
ATOM   1156  HB2 ASN A  76      50.979  44.139  64.510  1.00  0.00           H  
ATOM   1157  HB3 ASN A  76      49.786  45.219  63.801  1.00  0.00           H  
ATOM   1158 HD21 ASN A  76      49.116  44.863  67.044  1.00  0.00           H  
ATOM   1159 HD22 ASN A  76      49.925  46.267  67.636  1.00  0.00           H  
ATOM   1160  N   LYS A  77      46.720  43.834  66.007  1.00  0.00           N  
ATOM   1161  CA  LYS A  77      45.425  44.434  66.316  1.00  0.00           C  
ATOM   1162  C   LYS A  77      44.608  43.500  67.203  1.00  0.00           C  
ATOM   1163  O   LYS A  77      45.165  42.650  67.899  1.00  0.00           O  
ATOM   1164  CB  LYS A  77      44.654  44.757  65.031  1.00  0.00           C  
ATOM   1165  CG  LYS A  77      44.433  43.556  64.124  1.00  0.00           C  
ATOM   1166  CD  LYS A  77      43.492  43.885  62.972  1.00  0.00           C  
ATOM   1167  CE  LYS A  77      44.047  44.991  62.084  1.00  0.00           C  
ATOM   1168  NZ  LYS A  77      45.342  44.605  61.461  1.00  0.00           N  
ATOM   1169  H   LYS A  77      46.908  42.925  66.323  1.00  0.00           H  
ATOM   1170  HA  LYS A  77      45.609  45.351  66.856  1.00  0.00           H  
ATOM   1171  HB2 LYS A  77      43.687  45.159  65.298  1.00  0.00           H  
ATOM   1172  HB3 LYS A  77      45.200  45.504  64.476  1.00  0.00           H  
ATOM   1173  HG2 LYS A  77      45.385  43.244  63.719  1.00  0.00           H  
ATOM   1174  HG3 LYS A  77      44.007  42.753  64.707  1.00  0.00           H  
ATOM   1175  HD2 LYS A  77      43.349  43.000  62.373  1.00  0.00           H  
ATOM   1176  HD3 LYS A  77      42.543  44.205  63.377  1.00  0.00           H  
ATOM   1177  HE2 LYS A  77      43.331  45.200  61.304  1.00  0.00           H  
ATOM   1178  HE3 LYS A  77      44.194  45.877  62.684  1.00  0.00           H  
ATOM   1179  HZ1 LYS A  77      45.177  44.195  60.519  1.00  0.00           H  
ATOM   1180  HZ2 LYS A  77      45.831  43.905  62.052  1.00  0.00           H  
ATOM   1181  HZ3 LYS A  77      45.951  45.444  61.358  1.00  0.00           H  
ATOM   1182  N   LEU A  78      43.288  43.656  67.169  1.00  0.00           N  
ATOM   1183  CA  LEU A  78      42.405  42.815  67.967  1.00  0.00           C  
ATOM   1184  C   LEU A  78      41.820  41.695  67.114  1.00  0.00           C  
ATOM   1185  O   LEU A  78      40.602  41.593  66.955  1.00  0.00           O  
ATOM   1186  CB  LEU A  78      41.272  43.648  68.588  1.00  0.00           C  
ATOM   1187  CG  LEU A  78      41.709  44.745  69.570  1.00  0.00           C  
ATOM   1188  CD1 LEU A  78      42.619  44.175  70.648  1.00  0.00           C  
ATOM   1189  CD2 LEU A  78      42.392  45.890  68.835  1.00  0.00           C  
ATOM   1190  H   LEU A  78      42.900  44.344  66.593  1.00  0.00           H  
ATOM   1191  HA  LEU A  78      42.992  42.376  68.761  1.00  0.00           H  
ATOM   1192  HB2 LEU A  78      40.720  44.115  67.787  1.00  0.00           H  
ATOM   1193  HB3 LEU A  78      40.608  42.976  69.112  1.00  0.00           H  
ATOM   1194  HG  LEU A  78      40.831  45.143  70.059  1.00  0.00           H  
ATOM   1195 HD11 LEU A  78      42.959  44.975  71.290  1.00  0.00           H  
ATOM   1196 HD12 LEU A  78      43.471  43.699  70.185  1.00  0.00           H  
ATOM   1197 HD13 LEU A  78      42.075  43.449  71.233  1.00  0.00           H  
ATOM   1198 HD21 LEU A  78      41.662  46.649  68.595  1.00  0.00           H  
ATOM   1199 HD22 LEU A  78      42.837  45.520  67.924  1.00  0.00           H  
ATOM   1200 HD23 LEU A  78      43.159  46.314  69.465  1.00  0.00           H  
ATOM   1201  N   GLU A  79      42.694  40.857  66.555  1.00  0.00           N  
ATOM   1202  CA  GLU A  79      42.251  39.754  65.710  1.00  0.00           C  
ATOM   1203  C   GLU A  79      42.349  38.423  66.451  1.00  0.00           C  
ATOM   1204  O   GLU A  79      43.203  38.244  67.320  1.00  0.00           O  
ATOM   1205  CB  GLU A  79      43.075  39.684  64.417  1.00  0.00           C  
ATOM   1206  CG  GLU A  79      44.448  39.042  64.583  1.00  0.00           C  
ATOM   1207  CD  GLU A  79      45.433  39.909  65.345  1.00  0.00           C  
ATOM   1208  OE1 GLU A  79      45.121  41.089  65.599  1.00  0.00           O  
ATOM   1209  OE2 GLU A  79      46.530  39.408  65.672  1.00  0.00           O  
ATOM   1210  H   GLU A  79      43.651  40.990  66.713  1.00  0.00           H  
ATOM   1211  HA  GLU A  79      41.216  39.929  65.455  1.00  0.00           H  
ATOM   1212  HB2 GLU A  79      42.525  39.113  63.686  1.00  0.00           H  
ATOM   1213  HB3 GLU A  79      43.215  40.689  64.044  1.00  0.00           H  
ATOM   1214  HG2 GLU A  79      44.329  38.111  65.117  1.00  0.00           H  
ATOM   1215  HG3 GLU A  79      44.855  38.842  63.603  1.00  0.00           H  
ATOM   1216  N   ARG A  80      41.472  37.488  66.095  1.00  0.00           N  
ATOM   1217  CA  ARG A  80      41.461  36.170  66.719  1.00  0.00           C  
ATOM   1218  C   ARG A  80      41.214  35.081  65.677  1.00  0.00           C  
ATOM   1219  O   ARG A  80      40.078  34.847  65.267  1.00  0.00           O  
ATOM   1220  CB  ARG A  80      40.392  36.105  67.811  1.00  0.00           C  
ATOM   1221  CG  ARG A  80      40.300  34.749  68.490  1.00  0.00           C  
ATOM   1222  CD  ARG A  80      39.278  34.758  69.617  1.00  0.00           C  
ATOM   1223  NE  ARG A  80      39.639  35.699  70.675  1.00  0.00           N  
ATOM   1224  CZ  ARG A  80      38.922  35.877  71.781  1.00  0.00           C  
ATOM   1225  NH1 ARG A  80      37.807  35.186  71.970  1.00  0.00           N  
ATOM   1226  NH2 ARG A  80      39.323  36.747  72.696  1.00  0.00           N  
ATOM   1227  H   ARG A  80      40.819  37.690  65.393  1.00  0.00           H  
ATOM   1228  HA  ARG A  80      42.430  36.009  67.166  1.00  0.00           H  
ATOM   1229  HB2 ARG A  80      40.619  36.847  68.563  1.00  0.00           H  
ATOM   1230  HB3 ARG A  80      39.431  36.332  67.373  1.00  0.00           H  
ATOM   1231  HG2 ARG A  80      40.008  34.011  67.761  1.00  0.00           H  
ATOM   1232  HG3 ARG A  80      41.267  34.496  68.896  1.00  0.00           H  
ATOM   1233  HD2 ARG A  80      38.316  35.037  69.212  1.00  0.00           H  
ATOM   1234  HD3 ARG A  80      39.217  33.765  70.038  1.00  0.00           H  
ATOM   1235  HE  ARG A  80      40.459  36.222  70.556  1.00  0.00           H  
ATOM   1236 HH11 ARG A  80      37.502  34.528  71.284  1.00  0.00           H  
ATOM   1237 HH12 ARG A  80      37.271  35.324  72.804  1.00  0.00           H  
ATOM   1238 HH21 ARG A  80      40.166  37.269  72.556  1.00  0.00           H  
ATOM   1239 HH22 ARG A  80      38.785  36.882  73.527  1.00  0.00           H  
ATOM   1240  N   GLU A  81      42.288  34.419  65.251  1.00  0.00           N  
ATOM   1241  CA  GLU A  81      42.186  33.359  64.253  1.00  0.00           C  
ATOM   1242  C   GLU A  81      43.471  32.535  64.194  1.00  0.00           C  
ATOM   1243  O   GLU A  81      43.915  32.137  63.117  1.00  0.00           O  
ATOM   1244  CB  GLU A  81      41.880  33.957  62.880  1.00  0.00           C  
ATOM   1245  CG  GLU A  81      42.912  34.969  62.412  1.00  0.00           C  
ATOM   1246  CD  GLU A  81      42.574  35.562  61.057  1.00  0.00           C  
ATOM   1247  OE1 GLU A  81      41.496  36.179  60.933  1.00  0.00           O  
ATOM   1248  OE2 GLU A  81      43.389  35.408  60.123  1.00  0.00           O  
ATOM   1249  H   GLU A  81      43.169  34.653  65.613  1.00  0.00           H  
ATOM   1250  HA  GLU A  81      41.372  32.710  64.543  1.00  0.00           H  
ATOM   1251  HB2 GLU A  81      41.836  33.157  62.154  1.00  0.00           H  
ATOM   1252  HB3 GLU A  81      40.918  34.446  62.920  1.00  0.00           H  
ATOM   1253  HG2 GLU A  81      42.965  35.770  63.134  1.00  0.00           H  
ATOM   1254  HG3 GLU A  81      43.873  34.480  62.346  1.00  0.00           H  
ATOM   1255  N   GLU A  82      44.060  32.286  65.359  1.00  0.00           N  
ATOM   1256  CA  GLU A  82      45.294  31.510  65.441  1.00  0.00           C  
ATOM   1257  C   GLU A  82      44.994  30.024  65.615  1.00  0.00           C  
ATOM   1258  O   GLU A  82      45.837  29.267  66.100  1.00  0.00           O  
ATOM   1259  CB  GLU A  82      46.153  32.010  66.604  1.00  0.00           C  
ATOM   1260  CG  GLU A  82      46.553  33.470  66.482  1.00  0.00           C  
ATOM   1261  CD  GLU A  82      47.395  33.945  67.652  1.00  0.00           C  
ATOM   1262  OE1 GLU A  82      47.669  33.131  68.559  1.00  0.00           O  
ATOM   1263  OE2 GLU A  82      47.781  35.134  67.662  1.00  0.00           O  
ATOM   1264  H   GLU A  82      43.657  32.630  66.181  1.00  0.00           H  
ATOM   1265  HA  GLU A  82      45.836  31.651  64.518  1.00  0.00           H  
ATOM   1266  HB2 GLU A  82      45.599  31.885  67.523  1.00  0.00           H  
ATOM   1267  HB3 GLU A  82      47.052  31.415  66.652  1.00  0.00           H  
ATOM   1268  HG2 GLU A  82      47.123  33.600  65.575  1.00  0.00           H  
ATOM   1269  HG3 GLU A  82      45.658  34.073  66.433  1.00  0.00           H  
ATOM   1270  N   ASN A  83      43.794  29.614  65.219  1.00  0.00           N  
ATOM   1271  CA  ASN A  83      43.390  28.217  65.334  1.00  0.00           C  
ATOM   1272  C   ASN A  83      43.314  27.555  63.961  1.00  0.00           C  
ATOM   1273  O   ASN A  83      43.966  27.992  63.012  1.00  0.00           O  
ATOM   1274  CB  ASN A  83      42.040  28.113  66.047  1.00  0.00           C  
ATOM   1275  CG  ASN A  83      42.097  28.633  67.470  1.00  0.00           C  
ATOM   1276  OD1 ASN A  83      42.863  28.134  68.294  1.00  0.00           O  
ATOM   1277  ND2 ASN A  83      41.281  29.637  67.768  1.00  0.00           N  
ATOM   1278  H   ASN A  83      43.167  30.265  64.841  1.00  0.00           H  
ATOM   1279  HA  ASN A  83      44.137  27.707  65.924  1.00  0.00           H  
ATOM   1280  HB2 ASN A  83      41.306  28.688  65.503  1.00  0.00           H  
ATOM   1281  HB3 ASN A  83      41.733  27.077  66.073  1.00  0.00           H  
ATOM   1282 HD21 ASN A  83      40.697  29.982  67.062  1.00  0.00           H  
ATOM   1283 HD22 ASN A  83      41.298  29.990  68.681  1.00  0.00           H  
ATOM   1284  N   LEU A  84      42.515  26.495  63.866  1.00  0.00           N  
ATOM   1285  CA  LEU A  84      42.351  25.763  62.614  1.00  0.00           C  
ATOM   1286  C   LEU A  84      41.872  26.672  61.494  1.00  0.00           C  
ATOM   1287  O   LEU A  84      42.158  26.423  60.323  1.00  0.00           O  
ATOM   1288  CB  LEU A  84      41.343  24.627  62.784  1.00  0.00           C  
ATOM   1289  CG  LEU A  84      41.810  23.439  63.624  1.00  0.00           C  
ATOM   1290  CD1 LEU A  84      42.018  23.841  65.077  1.00  0.00           C  
ATOM   1291  CD2 LEU A  84      40.793  22.318  63.517  1.00  0.00           C  
ATOM   1292  H   LEU A  84      42.024  26.197  64.660  1.00  0.00           H  
ATOM   1293  HA  LEU A  84      43.308  25.346  62.343  1.00  0.00           H  
ATOM   1294  HB2 LEU A  84      40.455  25.034  63.242  1.00  0.00           H  
ATOM   1295  HB3 LEU A  84      41.083  24.261  61.801  1.00  0.00           H  
ATOM   1296  HG  LEU A  84      42.750  23.077  63.239  1.00  0.00           H  
ATOM   1297 HD11 LEU A  84      42.339  22.981  65.645  1.00  0.00           H  
ATOM   1298 HD12 LEU A  84      41.090  24.217  65.484  1.00  0.00           H  
ATOM   1299 HD13 LEU A  84      42.775  24.611  65.132  1.00  0.00           H  
ATOM   1300 HD21 LEU A  84      41.281  21.425  63.158  1.00  0.00           H  
ATOM   1301 HD22 LEU A  84      40.013  22.606  62.825  1.00  0.00           H  
ATOM   1302 HD23 LEU A  84      40.360  22.129  64.488  1.00  0.00           H  
ATOM   1303  N   VAL A  85      41.123  27.710  61.858  1.00  0.00           N  
ATOM   1304  CA  VAL A  85      40.582  28.645  60.880  1.00  0.00           C  
ATOM   1305  C   VAL A  85      41.635  29.064  59.855  1.00  0.00           C  
ATOM   1306  O   VAL A  85      41.303  29.389  58.713  1.00  0.00           O  
ATOM   1307  CB  VAL A  85      39.996  29.894  61.562  1.00  0.00           C  
ATOM   1308  CG1 VAL A  85      41.083  30.684  62.268  1.00  0.00           C  
ATOM   1309  CG2 VAL A  85      39.257  30.756  60.550  1.00  0.00           C  
ATOM   1310  H   VAL A  85      40.919  27.840  62.807  1.00  0.00           H  
ATOM   1311  HA  VAL A  85      39.779  28.143  60.362  1.00  0.00           H  
ATOM   1312  HB  VAL A  85      39.284  29.566  62.305  1.00  0.00           H  
ATOM   1313 HG11 VAL A  85      41.359  31.536  61.663  1.00  0.00           H  
ATOM   1314 HG12 VAL A  85      41.948  30.055  62.419  1.00  0.00           H  
ATOM   1315 HG13 VAL A  85      40.714  31.027  63.225  1.00  0.00           H  
ATOM   1316 HG21 VAL A  85      39.856  30.855  59.656  1.00  0.00           H  
ATOM   1317 HG22 VAL A  85      39.075  31.732  60.972  1.00  0.00           H  
ATOM   1318 HG23 VAL A  85      38.314  30.289  60.302  1.00  0.00           H  
ATOM   1319  N   SER A  86      42.903  29.037  60.261  1.00  0.00           N  
ATOM   1320  CA  SER A  86      43.997  29.396  59.367  1.00  0.00           C  
ATOM   1321  C   SER A  86      43.883  28.623  58.059  1.00  0.00           C  
ATOM   1322  O   SER A  86      43.832  29.211  56.979  1.00  0.00           O  
ATOM   1323  CB  SER A  86      45.346  29.110  60.031  1.00  0.00           C  
ATOM   1324  OG  SER A  86      45.491  29.850  61.230  1.00  0.00           O  
ATOM   1325  H   SER A  86      43.107  28.755  61.178  1.00  0.00           H  
ATOM   1326  HA  SER A  86      43.925  30.453  59.158  1.00  0.00           H  
ATOM   1327  HB2 SER A  86      45.412  28.056  60.262  1.00  0.00           H  
ATOM   1328  HB3 SER A  86      46.142  29.379  59.354  1.00  0.00           H  
ATOM   1329  HG  SER A  86      44.876  30.587  61.227  1.00  0.00           H  
ATOM   1330  N   ALA A  87      43.817  27.299  58.169  1.00  0.00           N  
ATOM   1331  CA  ALA A  87      43.679  26.445  56.998  1.00  0.00           C  
ATOM   1332  C   ALA A  87      42.224  26.397  56.562  1.00  0.00           C  
ATOM   1333  O   ALA A  87      41.923  26.433  55.372  1.00  0.00           O  
ATOM   1334  CB  ALA A  87      44.197  25.048  57.288  1.00  0.00           C  
ATOM   1335  H   ALA A  87      43.846  26.890  59.059  1.00  0.00           H  
ATOM   1336  HA  ALA A  87      44.271  26.871  56.201  1.00  0.00           H  
ATOM   1337  HB1 ALA A  87      43.369  24.354  57.302  1.00  0.00           H  
ATOM   1338  HB2 ALA A  87      44.691  25.040  58.247  1.00  0.00           H  
ATOM   1339  HB3 ALA A  87      44.896  24.757  56.519  1.00  0.00           H  
ATOM   1340  N   PHE A  88      41.324  26.337  57.542  1.00  0.00           N  
ATOM   1341  CA  PHE A  88      39.888  26.315  57.275  1.00  0.00           C  
ATOM   1342  C   PHE A  88      39.532  27.375  56.244  1.00  0.00           C  
ATOM   1343  O   PHE A  88      38.517  27.285  55.559  1.00  0.00           O  
ATOM   1344  CB  PHE A  88      39.111  26.566  58.565  1.00  0.00           C  
ATOM   1345  CG  PHE A  88      37.732  25.996  58.537  1.00  0.00           C  
ATOM   1346  CD1 PHE A  88      37.557  24.630  58.477  1.00  0.00           C  
ATOM   1347  CD2 PHE A  88      36.615  26.816  58.565  1.00  0.00           C  
ATOM   1348  CE1 PHE A  88      36.297  24.083  58.440  1.00  0.00           C  
ATOM   1349  CE2 PHE A  88      35.346  26.274  58.531  1.00  0.00           C  
ATOM   1350  CZ  PHE A  88      35.186  24.903  58.469  1.00  0.00           C  
ATOM   1351  H   PHE A  88      41.632  26.320  58.470  1.00  0.00           H  
ATOM   1352  HA  PHE A  88      39.620  25.344  56.882  1.00  0.00           H  
ATOM   1353  HB2 PHE A  88      39.642  26.118  59.392  1.00  0.00           H  
ATOM   1354  HB3 PHE A  88      39.031  27.628  58.729  1.00  0.00           H  
ATOM   1355  HD1 PHE A  88      38.422  23.985  58.456  1.00  0.00           H  
ATOM   1356  HD2 PHE A  88      36.745  27.888  58.613  1.00  0.00           H  
ATOM   1357  HE1 PHE A  88      36.181  23.005  58.407  1.00  0.00           H  
ATOM   1358  HE2 PHE A  88      34.480  26.919  58.556  1.00  0.00           H  
ATOM   1359  HZ  PHE A  88      34.195  24.474  58.440  1.00  0.00           H  
ATOM   1360  N   SER A  89      40.382  28.380  56.140  1.00  0.00           N  
ATOM   1361  CA  SER A  89      40.170  29.448  55.189  1.00  0.00           C  
ATOM   1362  C   SER A  89      40.812  29.111  53.845  1.00  0.00           C  
ATOM   1363  O   SER A  89      40.200  29.302  52.794  1.00  0.00           O  
ATOM   1364  CB  SER A  89      40.728  30.751  55.741  1.00  0.00           C  
ATOM   1365  OG  SER A  89      40.430  31.842  54.887  1.00  0.00           O  
ATOM   1366  H   SER A  89      41.177  28.399  56.715  1.00  0.00           H  
ATOM   1367  HA  SER A  89      39.106  29.551  55.048  1.00  0.00           H  
ATOM   1368  HB2 SER A  89      40.286  30.930  56.709  1.00  0.00           H  
ATOM   1369  HB3 SER A  89      41.800  30.669  55.845  1.00  0.00           H  
ATOM   1370  HG  SER A  89      41.176  32.006  54.305  1.00  0.00           H  
ATOM   1371  N   TYR A  90      42.046  28.605  53.882  1.00  0.00           N  
ATOM   1372  CA  TYR A  90      42.752  28.245  52.665  1.00  0.00           C  
ATOM   1373  C   TYR A  90      42.449  26.795  52.287  1.00  0.00           C  
ATOM   1374  O   TYR A  90      41.827  26.537  51.257  1.00  0.00           O  
ATOM   1375  CB  TYR A  90      44.248  28.444  52.867  1.00  0.00           C  
ATOM   1376  CG  TYR A  90      44.988  28.717  51.580  1.00  0.00           C  
ATOM   1377  CD1 TYR A  90      44.955  29.980  51.006  1.00  0.00           C  
ATOM   1378  CD2 TYR A  90      45.703  27.719  50.935  1.00  0.00           C  
ATOM   1379  CE1 TYR A  90      45.616  30.247  49.825  1.00  0.00           C  
ATOM   1380  CE2 TYR A  90      46.369  27.975  49.751  1.00  0.00           C  
ATOM   1381  CZ  TYR A  90      46.321  29.240  49.200  1.00  0.00           C  
ATOM   1382  OH  TYR A  90      46.984  29.497  48.020  1.00  0.00           O  
ATOM   1383  H   TYR A  90      42.491  28.469  54.745  1.00  0.00           H  
ATOM   1384  HA  TYR A  90      42.411  28.895  51.875  1.00  0.00           H  
ATOM   1385  HB2 TYR A  90      44.406  29.285  53.526  1.00  0.00           H  
ATOM   1386  HB3 TYR A  90      44.660  27.558  53.318  1.00  0.00           H  
ATOM   1387  HD1 TYR A  90      44.403  30.766  51.498  1.00  0.00           H  
ATOM   1388  HD2 TYR A  90      45.737  26.730  51.368  1.00  0.00           H  
ATOM   1389  HE1 TYR A  90      45.577  31.237  49.396  1.00  0.00           H  
ATOM   1390  HE2 TYR A  90      46.918  27.186  49.260  1.00  0.00           H  
ATOM   1391  HH  TYR A  90      46.884  28.749  47.427  1.00  0.00           H  
ATOM   1392  N   PHE A  91      42.855  25.856  53.148  1.00  0.00           N  
ATOM   1393  CA  PHE A  91      42.578  24.437  52.917  1.00  0.00           C  
ATOM   1394  C   PHE A  91      41.088  24.279  52.654  1.00  0.00           C  
ATOM   1395  O   PHE A  91      40.683  23.902  51.554  1.00  0.00           O  
ATOM   1396  CB  PHE A  91      43.013  23.590  54.117  1.00  0.00           C  
ATOM   1397  CG  PHE A  91      44.503  23.428  54.242  1.00  0.00           C  
ATOM   1398  CD1 PHE A  91      45.356  24.516  54.107  1.00  0.00           C  
ATOM   1399  CD2 PHE A  91      45.055  22.182  54.497  1.00  0.00           C  
ATOM   1400  CE1 PHE A  91      46.725  24.362  54.224  1.00  0.00           C  
ATOM   1401  CE2 PHE A  91      46.423  22.023  54.614  1.00  0.00           C  
ATOM   1402  CZ  PHE A  91      47.258  23.114  54.477  1.00  0.00           C  
ATOM   1403  H   PHE A  91      43.320  26.129  53.963  1.00  0.00           H  
ATOM   1404  HA  PHE A  91      43.126  24.127  52.038  1.00  0.00           H  
ATOM   1405  HB2 PHE A  91      42.653  24.054  55.023  1.00  0.00           H  
ATOM   1406  HB3 PHE A  91      42.578  22.605  54.027  1.00  0.00           H  
ATOM   1407  HD1 PHE A  91      44.940  25.493  53.909  1.00  0.00           H  
ATOM   1408  HD2 PHE A  91      44.403  21.328  54.603  1.00  0.00           H  
ATOM   1409  HE1 PHE A  91      47.376  25.218  54.119  1.00  0.00           H  
ATOM   1410  HE2 PHE A  91      46.836  21.045  54.813  1.00  0.00           H  
ATOM   1411  HZ  PHE A  91      48.327  22.991  54.570  1.00  0.00           H  
ATOM   1412  N   ASP A  92      40.279  24.632  53.656  1.00  0.00           N  
ATOM   1413  CA  ASP A  92      38.824  24.611  53.513  1.00  0.00           C  
ATOM   1414  C   ASP A  92      38.422  25.829  52.689  1.00  0.00           C  
ATOM   1415  O   ASP A  92      37.641  26.669  53.132  1.00  0.00           O  
ATOM   1416  CB  ASP A  92      38.147  24.662  54.887  1.00  0.00           C  
ATOM   1417  CG  ASP A  92      37.637  23.317  55.363  1.00  0.00           C  
ATOM   1418  OD1 ASP A  92      36.670  22.805  54.760  1.00  0.00           O  
ATOM   1419  OD2 ASP A  92      38.208  22.772  56.329  1.00  0.00           O  
ATOM   1420  H   ASP A  92      40.670  24.956  54.497  1.00  0.00           H  
ATOM   1421  HA  ASP A  92      38.540  23.708  52.991  1.00  0.00           H  
ATOM   1422  HB2 ASP A  92      38.861  25.028  55.609  1.00  0.00           H  
ATOM   1423  HB3 ASP A  92      37.311  25.342  54.844  1.00  0.00           H  
ATOM   1424  N   LYS A  93      39.020  25.935  51.505  1.00  0.00           N  
ATOM   1425  CA  LYS A  93      38.802  27.053  50.608  1.00  0.00           C  
ATOM   1426  C   LYS A  93      37.328  27.423  50.486  1.00  0.00           C  
ATOM   1427  O   LYS A  93      36.960  28.580  50.679  1.00  0.00           O  
ATOM   1428  CB  LYS A  93      39.393  26.723  49.240  1.00  0.00           C  
ATOM   1429  CG  LYS A  93      39.460  27.912  48.293  1.00  0.00           C  
ATOM   1430  CD  LYS A  93      40.283  27.593  47.055  1.00  0.00           C  
ATOM   1431  CE  LYS A  93      41.746  27.344  47.403  1.00  0.00           C  
ATOM   1432  NZ  LYS A  93      42.399  28.561  47.961  1.00  0.00           N  
ATOM   1433  H   LYS A  93      39.659  25.248  51.238  1.00  0.00           H  
ATOM   1434  HA  LYS A  93      39.332  27.894  51.016  1.00  0.00           H  
ATOM   1435  HB2 LYS A  93      40.397  26.342  49.381  1.00  0.00           H  
ATOM   1436  HB3 LYS A  93      38.793  25.955  48.776  1.00  0.00           H  
ATOM   1437  HG2 LYS A  93      38.457  28.174  47.989  1.00  0.00           H  
ATOM   1438  HG3 LYS A  93      39.911  28.746  48.810  1.00  0.00           H  
ATOM   1439  HD2 LYS A  93      39.881  26.708  46.584  1.00  0.00           H  
ATOM   1440  HD3 LYS A  93      40.223  28.427  46.370  1.00  0.00           H  
ATOM   1441  HE2 LYS A  93      41.800  26.551  48.135  1.00  0.00           H  
ATOM   1442  HE3 LYS A  93      42.269  27.043  46.508  1.00  0.00           H  
ATOM   1443  HZ1 LYS A  93      42.085  29.405  47.443  1.00  0.00           H  
ATOM   1444  HZ2 LYS A  93      43.434  28.481  47.878  1.00  0.00           H  
ATOM   1445  HZ3 LYS A  93      42.152  28.670  48.965  1.00  0.00           H  
ATOM   1446  N   ASP A  94      36.486  26.447  50.169  1.00  0.00           N  
ATOM   1447  CA  ASP A  94      35.060  26.712  50.034  1.00  0.00           C  
ATOM   1448  C   ASP A  94      34.453  27.045  51.392  1.00  0.00           C  
ATOM   1449  O   ASP A  94      33.394  27.671  51.470  1.00  0.00           O  
ATOM   1450  CB  ASP A  94      34.348  25.503  49.426  1.00  0.00           C  
ATOM   1451  CG  ASP A  94      32.861  25.740  49.247  1.00  0.00           C  
ATOM   1452  OD1 ASP A  94      32.497  26.682  48.510  1.00  0.00           O  
ATOM   1453  OD2 ASP A  94      32.063  24.988  49.844  1.00  0.00           O  
ATOM   1454  H   ASP A  94      36.826  25.539  50.026  1.00  0.00           H  
ATOM   1455  HA  ASP A  94      34.941  27.561  49.379  1.00  0.00           H  
ATOM   1456  HB2 ASP A  94      34.779  25.288  48.458  1.00  0.00           H  
ATOM   1457  HB3 ASP A  94      34.482  24.649  50.074  1.00  0.00           H  
ATOM   1458  N   GLY A  95      35.136  26.621  52.457  1.00  0.00           N  
ATOM   1459  CA  GLY A  95      34.652  26.876  53.792  1.00  0.00           C  
ATOM   1460  C   GLY A  95      33.187  26.534  53.900  1.00  0.00           C  
ATOM   1461  O   GLY A  95      32.332  27.400  54.093  1.00  0.00           O  
ATOM   1462  H   GLY A  95      35.961  26.120  52.313  1.00  0.00           H  
ATOM   1463  HA2 GLY A  95      35.209  26.264  54.488  1.00  0.00           H  
ATOM   1464  HA3 GLY A  95      34.802  27.914  54.040  1.00  0.00           H  
ATOM   1465  N   SER A  96      32.928  25.245  53.814  1.00  0.00           N  
ATOM   1466  CA  SER A  96      31.594  24.697  53.940  1.00  0.00           C  
ATOM   1467  C   SER A  96      31.603  23.841  55.181  1.00  0.00           C  
ATOM   1468  O   SER A  96      30.578  23.594  55.819  1.00  0.00           O  
ATOM   1469  CB  SER A  96      31.227  23.868  52.707  1.00  0.00           C  
ATOM   1470  OG  SER A  96      32.198  22.866  52.460  1.00  0.00           O  
ATOM   1471  H   SER A  96      33.684  24.630  53.725  1.00  0.00           H  
ATOM   1472  HA  SER A  96      30.894  25.511  54.064  1.00  0.00           H  
ATOM   1473  HB2 SER A  96      30.270  23.394  52.866  1.00  0.00           H  
ATOM   1474  HB3 SER A  96      31.167  24.516  51.844  1.00  0.00           H  
ATOM   1475  HG  SER A  96      32.681  22.682  53.269  1.00  0.00           H  
ATOM   1476  N   GLY A  97      32.816  23.423  55.518  1.00  0.00           N  
ATOM   1477  CA  GLY A  97      33.052  22.628  56.683  1.00  0.00           C  
ATOM   1478  C   GLY A  97      33.889  21.403  56.392  1.00  0.00           C  
ATOM   1479  O   GLY A  97      34.252  20.672  57.303  1.00  0.00           O  
ATOM   1480  H   GLY A  97      33.575  23.684  54.958  1.00  0.00           H  
ATOM   1481  HA2 GLY A  97      33.588  23.244  57.388  1.00  0.00           H  
ATOM   1482  HA3 GLY A  97      32.108  22.325  57.112  1.00  0.00           H  
ATOM   1483  N   TYR A  98      34.201  21.187  55.116  1.00  0.00           N  
ATOM   1484  CA  TYR A  98      35.014  20.046  54.711  1.00  0.00           C  
ATOM   1485  C   TYR A  98      35.869  20.339  53.479  1.00  0.00           C  
ATOM   1486  O   TYR A  98      35.627  21.295  52.744  1.00  0.00           O  
ATOM   1487  CB  TYR A  98      34.159  18.813  54.467  1.00  0.00           C  
ATOM   1488  CG  TYR A  98      32.919  19.050  53.641  1.00  0.00           C  
ATOM   1489  CD1 TYR A  98      32.988  19.637  52.385  1.00  0.00           C  
ATOM   1490  CD2 TYR A  98      31.676  18.664  54.118  1.00  0.00           C  
ATOM   1491  CE1 TYR A  98      31.851  19.836  51.631  1.00  0.00           C  
ATOM   1492  CE2 TYR A  98      30.536  18.857  53.371  1.00  0.00           C  
ATOM   1493  CZ  TYR A  98      30.626  19.445  52.126  1.00  0.00           C  
ATOM   1494  OH  TYR A  98      29.489  19.639  51.377  1.00  0.00           O  
ATOM   1495  H   TYR A  98      33.883  21.809  54.440  1.00  0.00           H  
ATOM   1496  HA  TYR A  98      35.683  19.832  55.533  1.00  0.00           H  
ATOM   1497  HB2 TYR A  98      34.759  18.090  53.945  1.00  0.00           H  
ATOM   1498  HB3 TYR A  98      33.854  18.401  55.418  1.00  0.00           H  
ATOM   1499  HD1 TYR A  98      33.950  19.941  51.999  1.00  0.00           H  
ATOM   1500  HD2 TYR A  98      31.608  18.207  55.094  1.00  0.00           H  
ATOM   1501  HE1 TYR A  98      31.925  20.295  50.658  1.00  0.00           H  
ATOM   1502  HE2 TYR A  98      29.582  18.548  53.764  1.00  0.00           H  
ATOM   1503  HH  TYR A  98      29.587  19.202  50.527  1.00  0.00           H  
ATOM   1504  N   ILE A  99      36.888  19.501  53.291  1.00  0.00           N  
ATOM   1505  CA  ILE A  99      37.828  19.628  52.186  1.00  0.00           C  
ATOM   1506  C   ILE A  99      38.066  18.296  51.489  1.00  0.00           C  
ATOM   1507  O   ILE A  99      38.811  17.461  51.990  1.00  0.00           O  
ATOM   1508  CB  ILE A  99      39.182  20.142  52.703  1.00  0.00           C  
ATOM   1509  CG1 ILE A  99      38.965  21.321  53.621  1.00  0.00           C  
ATOM   1510  CG2 ILE A  99      40.088  20.529  51.549  1.00  0.00           C  
ATOM   1511  CD1 ILE A  99      40.212  21.708  54.381  1.00  0.00           C  
ATOM   1512  H   ILE A  99      37.007  18.764  53.926  1.00  0.00           H  
ATOM   1513  HA  ILE A  99      37.435  20.341  51.479  1.00  0.00           H  
ATOM   1514  HB  ILE A  99      39.664  19.355  53.265  1.00  0.00           H  
ATOM   1515 HG12 ILE A  99      38.648  22.179  53.036  1.00  0.00           H  
ATOM   1516 HG13 ILE A  99      38.189  21.060  54.336  1.00  0.00           H  
ATOM   1517 HG21 ILE A  99      41.108  20.598  51.901  1.00  0.00           H  
ATOM   1518 HG22 ILE A  99      39.781  21.485  51.154  1.00  0.00           H  
ATOM   1519 HG23 ILE A  99      40.026  19.781  50.774  1.00  0.00           H  
ATOM   1520 HD11 ILE A  99      40.027  22.612  54.942  1.00  0.00           H  
ATOM   1521 HD12 ILE A  99      41.017  21.878  53.680  1.00  0.00           H  
ATOM   1522 HD13 ILE A  99      40.485  20.912  55.059  1.00  0.00           H  
ATOM   1523  N   THR A 100      37.485  18.106  50.323  1.00  0.00           N  
ATOM   1524  CA  THR A 100      37.709  16.872  49.587  1.00  0.00           C  
ATOM   1525  C   THR A 100      39.126  16.885  49.030  1.00  0.00           C  
ATOM   1526  O   THR A 100      39.650  17.960  48.743  1.00  0.00           O  
ATOM   1527  CB  THR A 100      36.689  16.736  48.458  1.00  0.00           C  
ATOM   1528  OG1 THR A 100      36.860  17.769  47.503  1.00  0.00           O  
ATOM   1529  CG2 THR A 100      35.258  16.794  48.946  1.00  0.00           C  
ATOM   1530  H   THR A 100      36.928  18.812  49.938  1.00  0.00           H  
ATOM   1531  HA  THR A 100      37.603  16.043  50.272  1.00  0.00           H  
ATOM   1532  HB  THR A 100      36.835  15.785  47.965  1.00  0.00           H  
ATOM   1533  HG1 THR A 100      36.098  17.795  46.921  1.00  0.00           H  
ATOM   1534 HG21 THR A 100      34.948  15.810  49.265  1.00  0.00           H  
ATOM   1535 HG22 THR A 100      34.618  17.132  48.145  1.00  0.00           H  
ATOM   1536 HG23 THR A 100      35.190  17.482  49.778  1.00  0.00           H  
ATOM   1537  N   LEU A 101      39.766  15.715  48.932  1.00  0.00           N  
ATOM   1538  CA  LEU A 101      41.150  15.634  48.456  1.00  0.00           C  
ATOM   1539  C   LEU A 101      41.452  16.678  47.388  1.00  0.00           C  
ATOM   1540  O   LEU A 101      42.561  17.202  47.322  1.00  0.00           O  
ATOM   1541  CB  LEU A 101      41.414  14.244  47.884  1.00  0.00           C  
ATOM   1542  CG  LEU A 101      40.490  13.828  46.740  1.00  0.00           C  
ATOM   1543  CD1 LEU A 101      41.077  14.241  45.396  1.00  0.00           C  
ATOM   1544  CD2 LEU A 101      40.229  12.329  46.779  1.00  0.00           C  
ATOM   1545  H   LEU A 101      39.331  14.893  49.253  1.00  0.00           H  
ATOM   1546  HA  LEU A 101      41.804  15.795  49.298  1.00  0.00           H  
ATOM   1547  HB2 LEU A 101      42.425  14.228  47.518  1.00  0.00           H  
ATOM   1548  HB3 LEU A 101      41.319  13.523  48.680  1.00  0.00           H  
ATOM   1549  HG  LEU A 101      39.545  14.338  46.855  1.00  0.00           H  
ATOM   1550 HD11 LEU A 101      40.390  14.907  44.894  1.00  0.00           H  
ATOM   1551 HD12 LEU A 101      41.236  13.364  44.787  1.00  0.00           H  
ATOM   1552 HD13 LEU A 101      42.018  14.746  45.553  1.00  0.00           H  
ATOM   1553 HD21 LEU A 101      40.023  11.973  45.781  1.00  0.00           H  
ATOM   1554 HD22 LEU A 101      39.380  12.128  47.415  1.00  0.00           H  
ATOM   1555 HD23 LEU A 101      41.099  11.822  47.168  1.00  0.00           H  
ATOM   1556  N   ASP A 102      40.466  16.991  46.569  1.00  0.00           N  
ATOM   1557  CA  ASP A 102      40.639  17.997  45.530  1.00  0.00           C  
ATOM   1558  C   ASP A 102      41.140  19.305  46.144  1.00  0.00           C  
ATOM   1559  O   ASP A 102      42.183  19.820  45.752  1.00  0.00           O  
ATOM   1560  CB  ASP A 102      39.325  18.235  44.787  1.00  0.00           C  
ATOM   1561  CG  ASP A 102      38.777  16.968  44.163  1.00  0.00           C  
ATOM   1562  OD1 ASP A 102      39.482  16.367  43.326  1.00  0.00           O  
ATOM   1563  OD2 ASP A 102      37.643  16.578  44.510  1.00  0.00           O  
ATOM   1564  H   ASP A 102      39.601  16.545  46.674  1.00  0.00           H  
ATOM   1565  HA  ASP A 102      41.383  17.636  44.836  1.00  0.00           H  
ATOM   1566  HB2 ASP A 102      38.590  18.620  45.479  1.00  0.00           H  
ATOM   1567  HB3 ASP A 102      39.490  18.960  44.002  1.00  0.00           H  
ATOM   1568  N   GLU A 103      40.396  19.826  47.120  1.00  0.00           N  
ATOM   1569  CA  GLU A 103      40.769  21.065  47.799  1.00  0.00           C  
ATOM   1570  C   GLU A 103      41.985  20.854  48.705  1.00  0.00           C  
ATOM   1571  O   GLU A 103      42.793  21.764  48.887  1.00  0.00           O  
ATOM   1572  CB  GLU A 103      39.589  21.610  48.605  1.00  0.00           C  
ATOM   1573  CG  GLU A 103      38.421  22.070  47.748  1.00  0.00           C  
ATOM   1574  CD  GLU A 103      37.234  22.536  48.573  1.00  0.00           C  
ATOM   1575  OE1 GLU A 103      37.321  22.496  49.818  1.00  0.00           O  
ATOM   1576  OE2 GLU A 103      36.216  22.939  47.972  1.00  0.00           O  
ATOM   1577  H   GLU A 103      39.577  19.362  47.396  1.00  0.00           H  
ATOM   1578  HA  GLU A 103      41.032  21.787  47.045  1.00  0.00           H  
ATOM   1579  HB2 GLU A 103      39.234  20.834  49.267  1.00  0.00           H  
ATOM   1580  HB3 GLU A 103      39.926  22.448  49.196  1.00  0.00           H  
ATOM   1581  HG2 GLU A 103      38.750  22.889  47.126  1.00  0.00           H  
ATOM   1582  HG3 GLU A 103      38.105  21.250  47.122  1.00  0.00           H  
ATOM   1583  N   ILE A 104      42.120  19.649  49.259  1.00  0.00           N  
ATOM   1584  CA  ILE A 104      43.255  19.333  50.128  1.00  0.00           C  
ATOM   1585  C   ILE A 104      44.557  19.363  49.335  1.00  0.00           C  
ATOM   1586  O   ILE A 104      45.431  20.196  49.575  1.00  0.00           O  
ATOM   1587  CB  ILE A 104      43.105  17.941  50.793  1.00  0.00           C  
ATOM   1588  CG1 ILE A 104      42.068  17.979  51.917  1.00  0.00           C  
ATOM   1589  CG2 ILE A 104      44.442  17.456  51.333  1.00  0.00           C  
ATOM   1590  CD1 ILE A 104      41.747  16.616  52.491  1.00  0.00           C  
ATOM   1591  H   ILE A 104      41.452  18.956  49.070  1.00  0.00           H  
ATOM   1592  HA  ILE A 104      43.300  20.080  50.907  1.00  0.00           H  
ATOM   1593  HB  ILE A 104      42.778  17.242  50.038  1.00  0.00           H  
ATOM   1594 HG12 ILE A 104      42.448  18.592  52.725  1.00  0.00           H  
ATOM   1595 HG13 ILE A 104      41.152  18.408  51.542  1.00  0.00           H  
ATOM   1596 HG21 ILE A 104      44.873  16.746  50.644  1.00  0.00           H  
ATOM   1597 HG22 ILE A 104      44.294  16.984  52.293  1.00  0.00           H  
ATOM   1598 HG23 ILE A 104      45.111  18.298  51.446  1.00  0.00           H  
ATOM   1599 HD11 ILE A 104      41.006  16.719  53.270  1.00  0.00           H  
ATOM   1600 HD12 ILE A 104      42.645  16.178  52.905  1.00  0.00           H  
ATOM   1601 HD13 ILE A 104      41.362  15.978  51.709  1.00  0.00           H  
ATOM   1602  N   GLN A 105      44.671  18.436  48.392  1.00  0.00           N  
ATOM   1603  CA  GLN A 105      45.853  18.320  47.549  1.00  0.00           C  
ATOM   1604  C   GLN A 105      46.124  19.612  46.775  1.00  0.00           C  
ATOM   1605  O   GLN A 105      47.277  20.016  46.623  1.00  0.00           O  
ATOM   1606  CB  GLN A 105      45.684  17.139  46.588  1.00  0.00           C  
ATOM   1607  CG  GLN A 105      45.574  15.796  47.294  1.00  0.00           C  
ATOM   1608  CD  GLN A 105      45.494  14.630  46.327  1.00  0.00           C  
ATOM   1609  OE1 GLN A 105      44.665  14.622  45.417  1.00  0.00           O  
ATOM   1610  NE2 GLN A 105      46.340  13.625  46.533  1.00  0.00           N  
ATOM   1611  H   GLN A 105      43.939  17.803  48.264  1.00  0.00           H  
ATOM   1612  HA  GLN A 105      46.696  18.122  48.194  1.00  0.00           H  
ATOM   1613  HB2 GLN A 105      44.782  17.288  46.007  1.00  0.00           H  
ATOM   1614  HB3 GLN A 105      46.533  17.105  45.920  1.00  0.00           H  
ATOM   1615  HG2 GLN A 105      46.440  15.662  47.924  1.00  0.00           H  
ATOM   1616  HG3 GLN A 105      44.683  15.801  47.907  1.00  0.00           H  
ATOM   1617 HE21 GLN A 105      46.962  13.687  47.289  1.00  0.00           H  
ATOM   1618 HE22 GLN A 105      46.309  12.862  45.918  1.00  0.00           H  
ATOM   1619  N   GLN A 106      45.063  20.263  46.297  1.00  0.00           N  
ATOM   1620  CA  GLN A 106      45.211  21.514  45.553  1.00  0.00           C  
ATOM   1621  C   GLN A 106      45.893  22.575  46.412  1.00  0.00           C  
ATOM   1622  O   GLN A 106      46.794  23.279  45.957  1.00  0.00           O  
ATOM   1623  CB  GLN A 106      43.848  22.024  45.084  1.00  0.00           C  
ATOM   1624  CG  GLN A 106      43.914  23.334  44.317  1.00  0.00           C  
ATOM   1625  CD  GLN A 106      42.548  23.814  43.864  1.00  0.00           C  
ATOM   1626  OE1 GLN A 106      41.661  24.061  44.682  1.00  0.00           O  
ATOM   1627  NE2 GLN A 106      42.371  23.944  42.555  1.00  0.00           N  
ATOM   1628  H   GLN A 106      44.165  19.898  46.452  1.00  0.00           H  
ATOM   1629  HA  GLN A 106      45.828  21.317  44.688  1.00  0.00           H  
ATOM   1630  HB2 GLN A 106      43.400  21.281  44.441  1.00  0.00           H  
ATOM   1631  HB3 GLN A 106      43.214  22.169  45.946  1.00  0.00           H  
ATOM   1632  HG2 GLN A 106      44.350  24.087  44.957  1.00  0.00           H  
ATOM   1633  HG3 GLN A 106      44.539  23.196  43.446  1.00  0.00           H  
ATOM   1634 HE21 GLN A 106      43.121  23.728  41.962  1.00  0.00           H  
ATOM   1635 HE22 GLN A 106      41.498  24.253  42.236  1.00  0.00           H  
ATOM   1636  N   ALA A 107      45.459  22.669  47.666  1.00  0.00           N  
ATOM   1637  CA  ALA A 107      46.019  23.626  48.619  1.00  0.00           C  
ATOM   1638  C   ALA A 107      47.499  23.343  48.879  1.00  0.00           C  
ATOM   1639  O   ALA A 107      48.164  24.082  49.606  1.00  0.00           O  
ATOM   1640  CB  ALA A 107      45.237  23.591  49.923  1.00  0.00           C  
ATOM   1641  H   ALA A 107      44.743  22.071  47.963  1.00  0.00           H  
ATOM   1642  HA  ALA A 107      45.923  24.613  48.193  1.00  0.00           H  
ATOM   1643  HB1 ALA A 107      44.373  22.955  49.808  1.00  0.00           H  
ATOM   1644  HB2 ALA A 107      44.918  24.591  50.176  1.00  0.00           H  
ATOM   1645  HB3 ALA A 107      45.868  23.205  50.710  1.00  0.00           H  
ATOM   1646  N   CYS A 108      48.003  22.275  48.273  1.00  0.00           N  
ATOM   1647  CA  CYS A 108      49.399  21.890  48.427  1.00  0.00           C  
ATOM   1648  C   CYS A 108      50.145  21.999  47.097  1.00  0.00           C  
ATOM   1649  O   CYS A 108      50.917  21.114  46.731  1.00  0.00           O  
ATOM   1650  CB  CYS A 108      49.497  20.467  48.975  1.00  0.00           C  
ATOM   1651  SG  CYS A 108      48.791  20.272  50.630  1.00  0.00           S  
ATOM   1652  H   CYS A 108      47.420  21.749  47.690  1.00  0.00           H  
ATOM   1653  HA  CYS A 108      49.852  22.570  49.133  1.00  0.00           H  
ATOM   1654  HB2 CYS A 108      48.973  19.796  48.314  1.00  0.00           H  
ATOM   1655  HB3 CYS A 108      50.536  20.177  49.025  1.00  0.00           H  
ATOM   1656  HG  CYS A 108      47.563  19.794  50.496  1.00  0.00           H  
ATOM   1657  N   LYS A 109      49.905  23.096  46.384  1.00  0.00           N  
ATOM   1658  CA  LYS A 109      50.552  23.333  45.098  1.00  0.00           C  
ATOM   1659  C   LYS A 109      52.069  23.365  45.251  1.00  0.00           C  
ATOM   1660  O   LYS A 109      52.802  22.893  44.382  1.00  0.00           O  
ATOM   1661  CB  LYS A 109      50.060  24.646  44.488  1.00  0.00           C  
ATOM   1662  CG  LYS A 109      50.237  25.846  45.406  1.00  0.00           C  
ATOM   1663  CD  LYS A 109      49.765  27.135  44.747  1.00  0.00           C  
ATOM   1664  CE  LYS A 109      50.594  27.474  43.520  1.00  0.00           C  
ATOM   1665  NZ  LYS A 109      50.154  28.747  42.886  1.00  0.00           N  
ATOM   1666  H   LYS A 109      49.280  23.767  46.733  1.00  0.00           H  
ATOM   1667  HA  LYS A 109      50.287  22.520  44.439  1.00  0.00           H  
ATOM   1668  HB2 LYS A 109      50.609  24.834  43.576  1.00  0.00           H  
ATOM   1669  HB3 LYS A 109      49.010  24.550  44.254  1.00  0.00           H  
ATOM   1670  HG2 LYS A 109      49.665  25.685  46.306  1.00  0.00           H  
ATOM   1671  HG3 LYS A 109      51.284  25.944  45.657  1.00  0.00           H  
ATOM   1672  HD2 LYS A 109      48.734  27.018  44.453  1.00  0.00           H  
ATOM   1673  HD3 LYS A 109      49.848  27.941  45.461  1.00  0.00           H  
ATOM   1674  HE2 LYS A 109      51.631  27.569  43.813  1.00  0.00           H  
ATOM   1675  HE3 LYS A 109      50.498  26.673  42.803  1.00  0.00           H  
ATOM   1676  HZ1 LYS A 109      50.878  29.482  43.019  1.00  0.00           H  
ATOM   1677  HZ2 LYS A 109      49.264  29.073  43.317  1.00  0.00           H  
ATOM   1678  HZ3 LYS A 109      50.000  28.605  41.867  1.00  0.00           H  
ATOM   1679  N   ASP A 110      52.532  23.922  46.366  1.00  0.00           N  
ATOM   1680  CA  ASP A 110      53.960  24.012  46.640  1.00  0.00           C  
ATOM   1681  C   ASP A 110      54.502  22.647  47.051  1.00  0.00           C  
ATOM   1682  O   ASP A 110      55.698  22.377  46.934  1.00  0.00           O  
ATOM   1683  CB  ASP A 110      54.224  25.039  47.744  1.00  0.00           C  
ATOM   1684  CG  ASP A 110      55.703  25.313  47.949  1.00  0.00           C  
ATOM   1685  OD1 ASP A 110      56.523  24.772  47.176  1.00  0.00           O  
ATOM   1686  OD2 ASP A 110      56.041  26.075  48.878  1.00  0.00           O  
ATOM   1687  H   ASP A 110      51.896  24.277  47.022  1.00  0.00           H  
ATOM   1688  HA  ASP A 110      54.454  24.329  45.734  1.00  0.00           H  
ATOM   1689  HB2 ASP A 110      53.740  25.968  47.485  1.00  0.00           H  
ATOM   1690  HB3 ASP A 110      53.813  24.671  48.673  1.00  0.00           H  
ATOM   1691  N   PHE A 111      53.608  21.785  47.525  1.00  0.00           N  
ATOM   1692  CA  PHE A 111      53.986  20.442  47.951  1.00  0.00           C  
ATOM   1693  C   PHE A 111      54.209  19.534  46.751  1.00  0.00           C  
ATOM   1694  O   PHE A 111      54.626  18.384  46.907  1.00  0.00           O  
ATOM   1695  CB  PHE A 111      52.907  19.830  48.850  1.00  0.00           C  
ATOM   1696  CG  PHE A 111      52.828  20.439  50.225  1.00  0.00           C  
ATOM   1697  CD1 PHE A 111      52.763  21.815  50.394  1.00  0.00           C  
ATOM   1698  CD2 PHE A 111      52.813  19.630  51.350  1.00  0.00           C  
ATOM   1699  CE1 PHE A 111      52.686  22.369  51.658  1.00  0.00           C  
ATOM   1700  CE2 PHE A 111      52.737  20.178  52.616  1.00  0.00           C  
ATOM   1701  CZ  PHE A 111      52.673  21.550  52.771  1.00  0.00           C  
ATOM   1702  H   PHE A 111      52.669  22.057  47.586  1.00  0.00           H  
ATOM   1703  HA  PHE A 111      54.908  20.518  48.508  1.00  0.00           H  
ATOM   1704  HB2 PHE A 111      51.944  19.963  48.379  1.00  0.00           H  
ATOM   1705  HB3 PHE A 111      53.099  18.768  48.963  1.00  0.00           H  
ATOM   1706  HD1 PHE A 111      52.773  22.457  49.527  1.00  0.00           H  
ATOM   1707  HD2 PHE A 111      52.864  18.558  51.231  1.00  0.00           H  
ATOM   1708  HE1 PHE A 111      52.636  23.442  51.776  1.00  0.00           H  
ATOM   1709  HE2 PHE A 111      52.726  19.537  53.484  1.00  0.00           H  
ATOM   1710  HZ  PHE A 111      52.613  21.982  53.757  1.00  0.00           H  
ATOM   1711  N   GLY A 112      53.932  20.043  45.553  1.00  0.00           N  
ATOM   1712  CA  GLY A 112      54.118  19.229  44.371  1.00  0.00           C  
ATOM   1713  C   GLY A 112      53.216  18.015  44.400  1.00  0.00           C  
ATOM   1714  O   GLY A 112      53.642  16.917  44.044  1.00  0.00           O  
ATOM   1715  H   GLY A 112      53.609  20.965  45.480  1.00  0.00           H  
ATOM   1716  HA2 GLY A 112      53.893  19.819  43.494  1.00  0.00           H  
ATOM   1717  HA3 GLY A 112      55.146  18.902  44.323  1.00  0.00           H  
ATOM   1718  N   LEU A 113      51.984  18.210  44.884  1.00  0.00           N  
ATOM   1719  CA  LEU A 113      51.022  17.118  45.030  1.00  0.00           C  
ATOM   1720  C   LEU A 113      51.195  16.070  43.937  1.00  0.00           C  
ATOM   1721  O   LEU A 113      51.330  16.388  42.757  1.00  0.00           O  
ATOM   1722  CB  LEU A 113      49.578  17.653  45.048  1.00  0.00           C  
ATOM   1723  CG  LEU A 113      48.839  17.679  43.702  1.00  0.00           C  
ATOM   1724  CD1 LEU A 113      47.421  18.193  43.883  1.00  0.00           C  
ATOM   1725  CD2 LEU A 113      49.580  18.527  42.687  1.00  0.00           C  
ATOM   1726  H   LEU A 113      51.732  19.107  45.190  1.00  0.00           H  
ATOM   1727  HA  LEU A 113      51.220  16.647  45.978  1.00  0.00           H  
ATOM   1728  HB2 LEU A 113      49.006  17.044  45.729  1.00  0.00           H  
ATOM   1729  HB3 LEU A 113      49.600  18.661  45.433  1.00  0.00           H  
ATOM   1730  HG  LEU A 113      48.778  16.669  43.317  1.00  0.00           H  
ATOM   1731 HD11 LEU A 113      47.104  18.697  42.983  1.00  0.00           H  
ATOM   1732 HD12 LEU A 113      47.393  18.887  44.712  1.00  0.00           H  
ATOM   1733 HD13 LEU A 113      46.759  17.365  44.085  1.00  0.00           H  
ATOM   1734 HD21 LEU A 113      48.885  19.190  42.196  1.00  0.00           H  
ATOM   1735 HD22 LEU A 113      50.041  17.878  41.953  1.00  0.00           H  
ATOM   1736 HD23 LEU A 113      50.342  19.103  43.187  1.00  0.00           H  
ATOM   1737  N   ASP A 114      51.221  14.813  44.354  1.00  0.00           N  
ATOM   1738  CA  ASP A 114      51.403  13.707  43.424  1.00  0.00           C  
ATOM   1739  C   ASP A 114      50.443  12.572  43.727  1.00  0.00           C  
ATOM   1740  O   ASP A 114      49.807  12.537  44.780  1.00  0.00           O  
ATOM   1741  CB  ASP A 114      52.844  13.184  43.484  1.00  0.00           C  
ATOM   1742  CG  ASP A 114      53.845  14.121  42.836  1.00  0.00           C  
ATOM   1743  OD1 ASP A 114      53.418  15.106  42.201  1.00  0.00           O  
ATOM   1744  OD2 ASP A 114      55.061  13.857  42.949  1.00  0.00           O  
ATOM   1745  H   ASP A 114      51.124  14.627  45.316  1.00  0.00           H  
ATOM   1746  HA  ASP A 114      51.204  14.073  42.431  1.00  0.00           H  
ATOM   1747  HB2 ASP A 114      53.125  13.050  44.517  1.00  0.00           H  
ATOM   1748  HB3 ASP A 114      52.892  12.231  42.979  1.00  0.00           H  
ATOM   1749  N   ASP A 115      50.353  11.636  42.794  1.00  0.00           N  
ATOM   1750  CA  ASP A 115      49.485  10.486  42.951  1.00  0.00           C  
ATOM   1751  C   ASP A 115      50.179   9.413  43.784  1.00  0.00           C  
ATOM   1752  O   ASP A 115      49.574   8.403  44.149  1.00  0.00           O  
ATOM   1753  CB  ASP A 115      49.084   9.923  41.586  1.00  0.00           C  
ATOM   1754  CG  ASP A 115      48.327  10.930  40.739  1.00  0.00           C  
ATOM   1755  OD1 ASP A 115      48.113  12.066  41.213  1.00  0.00           O  
ATOM   1756  OD2 ASP A 115      47.946  10.581  39.602  1.00  0.00           O  
ATOM   1757  H   ASP A 115      50.894  11.720  41.981  1.00  0.00           H  
ATOM   1758  HA  ASP A 115      48.599  10.820  43.471  1.00  0.00           H  
ATOM   1759  HB2 ASP A 115      49.972   9.628  41.049  1.00  0.00           H  
ATOM   1760  HB3 ASP A 115      48.454   9.057  41.731  1.00  0.00           H  
ATOM   1761  N   ILE A 116      51.461   9.631  44.064  1.00  0.00           N  
ATOM   1762  CA  ILE A 116      52.250   8.685  44.841  1.00  0.00           C  
ATOM   1763  C   ILE A 116      52.239   9.017  46.335  1.00  0.00           C  
ATOM   1764  O   ILE A 116      51.751   8.232  47.148  1.00  0.00           O  
ATOM   1765  CB  ILE A 116      53.707   8.635  44.346  1.00  0.00           C  
ATOM   1766  CG1 ILE A 116      53.742   8.323  42.846  1.00  0.00           C  
ATOM   1767  CG2 ILE A 116      54.499   7.596  45.129  1.00  0.00           C  
ATOM   1768  CD1 ILE A 116      55.139   8.310  42.256  1.00  0.00           C  
ATOM   1769  H   ILE A 116      51.888  10.449  43.734  1.00  0.00           H  
ATOM   1770  HA  ILE A 116      51.817   7.703  44.704  1.00  0.00           H  
ATOM   1771  HB  ILE A 116      54.156   9.601  44.518  1.00  0.00           H  
ATOM   1772 HG12 ILE A 116      53.301   7.352  42.677  1.00  0.00           H  
ATOM   1773 HG13 ILE A 116      53.164   9.072  42.319  1.00  0.00           H  
ATOM   1774 HG21 ILE A 116      55.291   8.085  45.678  1.00  0.00           H  
ATOM   1775 HG22 ILE A 116      54.927   6.878  44.445  1.00  0.00           H  
ATOM   1776 HG23 ILE A 116      53.843   7.089  45.820  1.00  0.00           H  
ATOM   1777 HD11 ILE A 116      55.777   7.679  42.860  1.00  0.00           H  
ATOM   1778 HD12 ILE A 116      55.536   9.314  42.243  1.00  0.00           H  
ATOM   1779 HD13 ILE A 116      55.102   7.923  41.249  1.00  0.00           H  
ATOM   1780  N   HIS A 117      52.797  10.176  46.695  1.00  0.00           N  
ATOM   1781  CA  HIS A 117      52.865  10.589  48.097  1.00  0.00           C  
ATOM   1782  C   HIS A 117      51.645  11.384  48.540  1.00  0.00           C  
ATOM   1783  O   HIS A 117      50.851  10.903  49.349  1.00  0.00           O  
ATOM   1784  CB  HIS A 117      54.124  11.421  48.342  1.00  0.00           C  
ATOM   1785  CG  HIS A 117      55.313  10.606  48.731  1.00  0.00           C  
ATOM   1786  ND1 HIS A 117      55.869   9.638  47.920  1.00  0.00           N  
ATOM   1787  CD2 HIS A 117      56.049  10.616  49.864  1.00  0.00           C  
ATOM   1788  CE1 HIS A 117      56.898   9.088  48.542  1.00  0.00           C  
ATOM   1789  NE2 HIS A 117      57.028   9.663  49.723  1.00  0.00           N  
ATOM   1790  H   HIS A 117      53.184  10.753  46.005  1.00  0.00           H  
ATOM   1791  HA  HIS A 117      52.928   9.694  48.697  1.00  0.00           H  
ATOM   1792  HB2 HIS A 117      54.372  11.958  47.439  1.00  0.00           H  
ATOM   1793  HB3 HIS A 117      53.930  12.129  49.134  1.00  0.00           H  
ATOM   1794  HD1 HIS A 117      55.556   9.392  47.025  1.00  0.00           H  
ATOM   1795  HD2 HIS A 117      55.890  11.253  50.724  1.00  0.00           H  
ATOM   1796  HE1 HIS A 117      57.525   8.300  48.151  1.00  0.00           H  
ATOM   1797  HE2 HIS A 117      57.681   9.409  50.409  1.00  0.00           H  
ATOM   1798  N   ILE A 118      51.502  12.605  48.029  1.00  0.00           N  
ATOM   1799  CA  ILE A 118      50.380  13.456  48.401  1.00  0.00           C  
ATOM   1800  C   ILE A 118      49.047  12.731  48.210  1.00  0.00           C  
ATOM   1801  O   ILE A 118      48.034  13.102  48.803  1.00  0.00           O  
ATOM   1802  CB  ILE A 118      50.389  14.774  47.602  1.00  0.00           C  
ATOM   1803  CG1 ILE A 118      51.687  15.539  47.881  1.00  0.00           C  
ATOM   1804  CG2 ILE A 118      49.176  15.629  47.952  1.00  0.00           C  
ATOM   1805  CD1 ILE A 118      51.885  15.905  49.338  1.00  0.00           C  
ATOM   1806  H   ILE A 118      52.175  12.948  47.403  1.00  0.00           H  
ATOM   1807  HA  ILE A 118      50.493  13.698  49.448  1.00  0.00           H  
ATOM   1808  HB  ILE A 118      50.339  14.535  46.551  1.00  0.00           H  
ATOM   1809 HG12 ILE A 118      52.526  14.931  47.576  1.00  0.00           H  
ATOM   1810 HG13 ILE A 118      51.687  16.454  47.305  1.00  0.00           H  
ATOM   1811 HG21 ILE A 118      48.745  15.282  48.880  1.00  0.00           H  
ATOM   1812 HG22 ILE A 118      48.442  15.552  47.163  1.00  0.00           H  
ATOM   1813 HG23 ILE A 118      49.480  16.659  48.061  1.00  0.00           H  
ATOM   1814 HD11 ILE A 118      51.280  15.259  49.957  1.00  0.00           H  
ATOM   1815 HD12 ILE A 118      51.589  16.931  49.494  1.00  0.00           H  
ATOM   1816 HD13 ILE A 118      52.925  15.786  49.602  1.00  0.00           H  
ATOM   1817  N   ASP A 119      49.057  11.678  47.403  1.00  0.00           N  
ATOM   1818  CA  ASP A 119      47.853  10.892  47.179  1.00  0.00           C  
ATOM   1819  C   ASP A 119      47.533  10.103  48.438  1.00  0.00           C  
ATOM   1820  O   ASP A 119      46.403  10.106  48.913  1.00  0.00           O  
ATOM   1821  CB  ASP A 119      48.030   9.941  45.999  1.00  0.00           C  
ATOM   1822  CG  ASP A 119      46.796   9.099  45.742  1.00  0.00           C  
ATOM   1823  OD1 ASP A 119      45.722   9.680  45.475  1.00  0.00           O  
ATOM   1824  OD2 ASP A 119      46.902   7.857  45.807  1.00  0.00           O  
ATOM   1825  H   ASP A 119      49.892  11.412  46.975  1.00  0.00           H  
ATOM   1826  HA  ASP A 119      47.043  11.577  46.971  1.00  0.00           H  
ATOM   1827  HB2 ASP A 119      48.238  10.518  45.108  1.00  0.00           H  
ATOM   1828  HB3 ASP A 119      48.859   9.282  46.197  1.00  0.00           H  
ATOM   1829  N   ASP A 120      48.555   9.456  48.998  1.00  0.00           N  
ATOM   1830  CA  ASP A 120      48.387   8.702  50.232  1.00  0.00           C  
ATOM   1831  C   ASP A 120      47.974   9.669  51.332  1.00  0.00           C  
ATOM   1832  O   ASP A 120      47.304   9.299  52.293  1.00  0.00           O  
ATOM   1833  CB  ASP A 120      49.691   7.989  50.607  1.00  0.00           C  
ATOM   1834  CG  ASP A 120      49.548   7.103  51.832  1.00  0.00           C  
ATOM   1835  OD1 ASP A 120      48.423   6.993  52.362  1.00  0.00           O  
ATOM   1836  OD2 ASP A 120      50.565   6.511  52.256  1.00  0.00           O  
ATOM   1837  H   ASP A 120      49.442   9.513  48.588  1.00  0.00           H  
ATOM   1838  HA  ASP A 120      47.604   7.973  50.082  1.00  0.00           H  
ATOM   1839  HB2 ASP A 120      50.007   7.373  49.778  1.00  0.00           H  
ATOM   1840  HB3 ASP A 120      50.452   8.729  50.808  1.00  0.00           H  
ATOM   1841  N   MET A 121      48.373  10.921  51.143  1.00  0.00           N  
ATOM   1842  CA  MET A 121      48.070  12.003  52.050  1.00  0.00           C  
ATOM   1843  C   MET A 121      46.563  12.198  52.162  1.00  0.00           C  
ATOM   1844  O   MET A 121      46.054  12.571  53.208  1.00  0.00           O  
ATOM   1845  CB  MET A 121      48.775  13.267  51.567  1.00  0.00           C  
ATOM   1846  CG  MET A 121      48.048  14.555  51.890  1.00  0.00           C  
ATOM   1847  SD  MET A 121      49.013  16.008  51.444  1.00  0.00           S  
ATOM   1848  CE  MET A 121      47.714  17.223  51.279  1.00  0.00           C  
ATOM   1849  H   MET A 121      48.883  11.129  50.356  1.00  0.00           H  
ATOM   1850  HA  MET A 121      48.457  11.738  53.016  1.00  0.00           H  
ATOM   1851  HB2 MET A 121      49.751  13.308  52.021  1.00  0.00           H  
ATOM   1852  HB3 MET A 121      48.894  13.208  50.497  1.00  0.00           H  
ATOM   1853  HG2 MET A 121      47.119  14.571  51.337  1.00  0.00           H  
ATOM   1854  HG3 MET A 121      47.841  14.581  52.951  1.00  0.00           H  
ATOM   1855  HE1 MET A 121      47.475  17.347  50.230  1.00  0.00           H  
ATOM   1856  HE2 MET A 121      48.049  18.165  51.686  1.00  0.00           H  
ATOM   1857  HE3 MET A 121      46.835  16.890  51.814  1.00  0.00           H  
ATOM   1858  N   ILE A 122      45.849  11.882  51.095  1.00  0.00           N  
ATOM   1859  CA  ILE A 122      44.393  11.960  51.106  1.00  0.00           C  
ATOM   1860  C   ILE A 122      43.912  11.062  52.207  1.00  0.00           C  
ATOM   1861  O   ILE A 122      43.046  11.418  52.998  1.00  0.00           O  
ATOM   1862  CB  ILE A 122      43.831  11.459  49.769  1.00  0.00           C  
ATOM   1863  CG1 ILE A 122      44.475  12.217  48.619  1.00  0.00           C  
ATOM   1864  CG2 ILE A 122      42.323  11.581  49.724  1.00  0.00           C  
ATOM   1865  CD1 ILE A 122      44.035  11.742  47.250  1.00  0.00           C  
ATOM   1866  H   ILE A 122      46.303  11.531  50.298  1.00  0.00           H  
ATOM   1867  HA  ILE A 122      44.060  12.978  51.298  1.00  0.00           H  
ATOM   1868  HB  ILE A 122      44.090  10.414  49.682  1.00  0.00           H  
ATOM   1869 HG12 ILE A 122      44.231  13.265  48.704  1.00  0.00           H  
ATOM   1870 HG13 ILE A 122      45.542  12.091  48.690  1.00  0.00           H  
ATOM   1871 HG21 ILE A 122      42.029  12.072  48.807  1.00  0.00           H  
ATOM   1872 HG22 ILE A 122      41.985  12.164  50.568  1.00  0.00           H  
ATOM   1873 HG23 ILE A 122      41.881  10.598  49.762  1.00  0.00           H  
ATOM   1874 HD11 ILE A 122      44.057  12.570  46.557  1.00  0.00           H  
ATOM   1875 HD12 ILE A 122      43.030  11.350  47.310  1.00  0.00           H  
ATOM   1876 HD13 ILE A 122      44.702  10.967  46.906  1.00  0.00           H  
ATOM   1877  N   LYS A 123      44.531   9.901  52.248  1.00  0.00           N  
ATOM   1878  CA  LYS A 123      44.239   8.904  53.251  1.00  0.00           C  
ATOM   1879  C   LYS A 123      45.076   9.152  54.507  1.00  0.00           C  
ATOM   1880  O   LYS A 123      44.818   8.579  55.566  1.00  0.00           O  
ATOM   1881  CB  LYS A 123      44.514   7.505  52.703  1.00  0.00           C  
ATOM   1882  CG  LYS A 123      43.471   7.000  51.713  1.00  0.00           C  
ATOM   1883  CD  LYS A 123      43.275   7.943  50.535  1.00  0.00           C  
ATOM   1884  CE  LYS A 123      44.537   8.057  49.701  1.00  0.00           C  
ATOM   1885  NZ  LYS A 123      44.980   6.735  49.180  1.00  0.00           N  
ATOM   1886  H   LYS A 123      45.228   9.718  51.580  1.00  0.00           H  
ATOM   1887  HA  LYS A 123      43.195   8.991  53.496  1.00  0.00           H  
ATOM   1888  HB2 LYS A 123      45.473   7.515  52.203  1.00  0.00           H  
ATOM   1889  HB3 LYS A 123      44.560   6.812  53.530  1.00  0.00           H  
ATOM   1890  HG2 LYS A 123      43.799   6.049  51.331  1.00  0.00           H  
ATOM   1891  HG3 LYS A 123      42.529   6.879  52.228  1.00  0.00           H  
ATOM   1892  HD2 LYS A 123      42.477   7.564  49.914  1.00  0.00           H  
ATOM   1893  HD3 LYS A 123      43.009   8.920  50.910  1.00  0.00           H  
ATOM   1894  HE2 LYS A 123      44.344   8.716  48.869  1.00  0.00           H  
ATOM   1895  HE3 LYS A 123      45.321   8.475  50.317  1.00  0.00           H  
ATOM   1896  HZ1 LYS A 123      45.350   6.838  48.214  1.00  0.00           H  
ATOM   1897  HZ2 LYS A 123      44.180   6.071  49.164  1.00  0.00           H  
ATOM   1898  HZ3 LYS A 123      45.728   6.343  49.787  1.00  0.00           H  
ATOM   1899  N   GLU A 124      46.090  10.008  54.368  1.00  0.00           N  
ATOM   1900  CA  GLU A 124      46.984  10.341  55.474  1.00  0.00           C  
ATOM   1901  C   GLU A 124      46.394  11.449  56.329  1.00  0.00           C  
ATOM   1902  O   GLU A 124      46.727  11.596  57.506  1.00  0.00           O  
ATOM   1903  CB  GLU A 124      48.345  10.780  54.944  1.00  0.00           C  
ATOM   1904  CG  GLU A 124      49.317  11.219  56.024  1.00  0.00           C  
ATOM   1905  CD  GLU A 124      50.749  11.296  55.532  1.00  0.00           C  
ATOM   1906  OE1 GLU A 124      50.988  10.991  54.344  1.00  0.00           O  
ATOM   1907  OE2 GLU A 124      51.633  11.659  56.336  1.00  0.00           O  
ATOM   1908  H   GLU A 124      46.238  10.424  53.495  1.00  0.00           H  
ATOM   1909  HA  GLU A 124      47.113   9.460  56.067  1.00  0.00           H  
ATOM   1910  HB2 GLU A 124      48.789   9.969  54.396  1.00  0.00           H  
ATOM   1911  HB3 GLU A 124      48.198  11.611  54.275  1.00  0.00           H  
ATOM   1912  HG2 GLU A 124      49.022  12.202  56.359  1.00  0.00           H  
ATOM   1913  HG3 GLU A 124      49.264  10.526  56.847  1.00  0.00           H  
ATOM   1914  N   ILE A 125      45.516  12.225  55.719  1.00  0.00           N  
ATOM   1915  CA  ILE A 125      44.862  13.328  56.386  1.00  0.00           C  
ATOM   1916  C   ILE A 125      43.413  12.949  56.635  1.00  0.00           C  
ATOM   1917  O   ILE A 125      42.762  13.472  57.537  1.00  0.00           O  
ATOM   1918  CB  ILE A 125      44.969  14.601  55.532  1.00  0.00           C  
ATOM   1919  CG1 ILE A 125      46.385  14.723  54.956  1.00  0.00           C  
ATOM   1920  CG2 ILE A 125      44.638  15.819  56.368  1.00  0.00           C  
ATOM   1921  CD1 ILE A 125      47.476  14.784  56.004  1.00  0.00           C  
ATOM   1922  H   ILE A 125      45.292  12.045  54.782  1.00  0.00           H  
ATOM   1923  HA  ILE A 125      45.350  13.513  57.336  1.00  0.00           H  
ATOM   1924  HB  ILE A 125      44.258  14.538  54.724  1.00  0.00           H  
ATOM   1925 HG12 ILE A 125      46.582  13.866  54.335  1.00  0.00           H  
ATOM   1926 HG13 ILE A 125      46.452  15.612  54.354  1.00  0.00           H  
ATOM   1927 HG21 ILE A 125      44.156  15.506  57.284  1.00  0.00           H  
ATOM   1928 HG22 ILE A 125      43.967  16.462  55.812  1.00  0.00           H  
ATOM   1929 HG23 ILE A 125      45.544  16.354  56.600  1.00  0.00           H  
ATOM   1930 HD11 ILE A 125      47.215  14.140  56.831  1.00  0.00           H  
ATOM   1931 HD12 ILE A 125      47.583  15.798  56.354  1.00  0.00           H  
ATOM   1932 HD13 ILE A 125      48.406  14.451  55.570  1.00  0.00           H  
ATOM   1933  N   ASP A 126      42.936  11.984  55.846  1.00  0.00           N  
ATOM   1934  CA  ASP A 126      41.583  11.472  55.992  1.00  0.00           C  
ATOM   1935  C   ASP A 126      41.427  10.830  57.354  1.00  0.00           C  
ATOM   1936  O   ASP A 126      41.833   9.688  57.564  1.00  0.00           O  
ATOM   1937  CB  ASP A 126      41.281  10.442  54.913  1.00  0.00           C  
ATOM   1938  CG  ASP A 126      39.940   9.776  55.120  1.00  0.00           C  
ATOM   1939  OD1 ASP A 126      38.928  10.499  55.177  1.00  0.00           O  
ATOM   1940  OD2 ASP A 126      39.904   8.531  55.225  1.00  0.00           O  
ATOM   1941  H   ASP A 126      43.527  11.585  55.172  1.00  0.00           H  
ATOM   1942  HA  ASP A 126      40.893  12.299  55.905  1.00  0.00           H  
ATOM   1943  HB2 ASP A 126      41.277  10.929  53.952  1.00  0.00           H  
ATOM   1944  HB3 ASP A 126      42.047   9.684  54.926  1.00  0.00           H  
ATOM   1945  N   GLN A 127      40.863  11.575  58.282  1.00  0.00           N  
ATOM   1946  CA  GLN A 127      40.685  11.084  59.630  1.00  0.00           C  
ATOM   1947  C   GLN A 127      39.376  10.308  59.804  1.00  0.00           C  
ATOM   1948  O   GLN A 127      39.209   9.613  60.807  1.00  0.00           O  
ATOM   1949  CB  GLN A 127      40.791  12.254  60.618  1.00  0.00           C  
ATOM   1950  CG  GLN A 127      40.268  11.954  62.012  1.00  0.00           C  
ATOM   1951  CD  GLN A 127      38.764  12.120  62.110  1.00  0.00           C  
ATOM   1952  OE1 GLN A 127      38.159  11.814  63.137  1.00  0.00           O  
ATOM   1953  NE2 GLN A 127      38.156  12.622  61.040  1.00  0.00           N  
ATOM   1954  H   GLN A 127      40.576  12.486  58.059  1.00  0.00           H  
ATOM   1955  HA  GLN A 127      41.500  10.404  59.827  1.00  0.00           H  
ATOM   1956  HB2 GLN A 127      41.828  12.539  60.705  1.00  0.00           H  
ATOM   1957  HB3 GLN A 127      40.234  13.091  60.222  1.00  0.00           H  
ATOM   1958  HG2 GLN A 127      40.522  10.937  62.270  1.00  0.00           H  
ATOM   1959  HG3 GLN A 127      40.737  12.630  62.713  1.00  0.00           H  
ATOM   1960 HE21 GLN A 127      38.709  12.860  60.256  1.00  0.00           H  
ATOM   1961 HE22 GLN A 127      37.184  12.736  61.073  1.00  0.00           H  
ATOM   1962  N   ASP A 128      38.438  10.400  58.851  1.00  0.00           N  
ATOM   1963  CA  ASP A 128      37.190   9.661  59.026  1.00  0.00           C  
ATOM   1964  C   ASP A 128      36.793   8.762  57.842  1.00  0.00           C  
ATOM   1965  O   ASP A 128      36.225   7.695  58.080  1.00  0.00           O  
ATOM   1966  CB  ASP A 128      36.055  10.639  59.341  1.00  0.00           C  
ATOM   1967  CG  ASP A 128      35.857  11.676  58.255  1.00  0.00           C  
ATOM   1968  OD1 ASP A 128      36.473  11.542  57.182  1.00  0.00           O  
ATOM   1969  OD2 ASP A 128      35.077  12.624  58.479  1.00  0.00           O  
ATOM   1970  H   ASP A 128      38.584  10.953  58.056  1.00  0.00           H  
ATOM   1971  HA  ASP A 128      37.319   9.032  59.890  1.00  0.00           H  
ATOM   1972  HB2 ASP A 128      35.132  10.086  59.454  1.00  0.00           H  
ATOM   1973  HB3 ASP A 128      36.277  11.149  60.264  1.00  0.00           H  
ATOM   1974  N   ASN A 129      37.097   9.130  56.581  1.00  0.00           N  
ATOM   1975  CA  ASN A 129      36.736   8.235  55.462  1.00  0.00           C  
ATOM   1976  C   ASN A 129      37.108   8.707  54.037  1.00  0.00           C  
ATOM   1977  O   ASN A 129      37.931   8.094  53.359  1.00  0.00           O  
ATOM   1978  CB  ASN A 129      35.239   7.879  55.502  1.00  0.00           C  
ATOM   1979  CG  ASN A 129      34.310   9.078  55.647  1.00  0.00           C  
ATOM   1980  OD1 ASN A 129      33.090   8.918  55.686  1.00  0.00           O  
ATOM   1981  ND2 ASN A 129      34.868  10.279  55.729  1.00  0.00           N  
ATOM   1982  H   ASN A 129      37.575   9.968  56.417  1.00  0.00           H  
ATOM   1983  HA  ASN A 129      37.278   7.318  55.633  1.00  0.00           H  
ATOM   1984  HB2 ASN A 129      34.979   7.367  54.590  1.00  0.00           H  
ATOM   1985  HB3 ASN A 129      35.065   7.214  56.337  1.00  0.00           H  
ATOM   1986 HD21 ASN A 129      35.843  10.341  55.690  1.00  0.00           H  
ATOM   1987 HD22 ASN A 129      34.277  11.056  55.826  1.00  0.00           H  
ATOM   1988  N   ASP A 130      36.381   9.720  53.564  1.00  0.00           N  
ATOM   1989  CA  ASP A 130      36.478  10.225  52.183  1.00  0.00           C  
ATOM   1990  C   ASP A 130      37.800  10.869  51.743  1.00  0.00           C  
ATOM   1991  O   ASP A 130      37.800  11.582  50.739  1.00  0.00           O  
ATOM   1992  CB  ASP A 130      35.349  11.236  51.963  1.00  0.00           C  
ATOM   1993  CG  ASP A 130      33.975  10.590  51.997  1.00  0.00           C  
ATOM   1994  OD1 ASP A 130      33.902   9.359  52.202  1.00  0.00           O  
ATOM   1995  OD2 ASP A 130      32.975  11.315  51.819  1.00  0.00           O  
ATOM   1996  H   ASP A 130      35.682  10.089  54.134  1.00  0.00           H  
ATOM   1997  HA  ASP A 130      36.288   9.388  51.533  1.00  0.00           H  
ATOM   1998  HB2 ASP A 130      35.389  11.983  52.741  1.00  0.00           H  
ATOM   1999  HB3 ASP A 130      35.480  11.716  51.006  1.00  0.00           H  
ATOM   2000  N   GLY A 131      38.920  10.641  52.425  1.00  0.00           N  
ATOM   2001  CA  GLY A 131      40.148  11.256  51.957  1.00  0.00           C  
ATOM   2002  C   GLY A 131      39.978  12.749  51.874  1.00  0.00           C  
ATOM   2003  O   GLY A 131      40.423  13.412  50.931  1.00  0.00           O  
ATOM   2004  H   GLY A 131      38.918  10.072  53.209  1.00  0.00           H  
ATOM   2005  HA2 GLY A 131      40.950  11.020  52.640  1.00  0.00           H  
ATOM   2006  HA3 GLY A 131      40.387  10.873  50.977  1.00  0.00           H  
ATOM   2007  N   GLN A 132      39.259  13.257  52.847  1.00  0.00           N  
ATOM   2008  CA  GLN A 132      38.932  14.637  52.920  1.00  0.00           C  
ATOM   2009  C   GLN A 132      39.181  15.154  54.311  1.00  0.00           C  
ATOM   2010  O   GLN A 132      39.449  14.386  55.230  1.00  0.00           O  
ATOM   2011  CB  GLN A 132      37.490  14.853  52.571  1.00  0.00           C  
ATOM   2012  CG  GLN A 132      36.543  14.423  53.667  1.00  0.00           C  
ATOM   2013  CD  GLN A 132      35.184  15.072  53.534  1.00  0.00           C  
ATOM   2014  OE1 GLN A 132      34.436  14.798  52.597  1.00  0.00           O  
ATOM   2015  NE2 GLN A 132      34.872  15.958  54.470  1.00  0.00           N  
ATOM   2016  H   GLN A 132      38.899  12.668  53.532  1.00  0.00           H  
ATOM   2017  HA  GLN A 132      39.552  15.172  52.221  1.00  0.00           H  
ATOM   2018  HB2 GLN A 132      37.353  15.891  52.395  1.00  0.00           H  
ATOM   2019  HB3 GLN A 132      37.260  14.302  51.676  1.00  0.00           H  
ATOM   2020  HG2 GLN A 132      36.424  13.350  53.625  1.00  0.00           H  
ATOM   2021  HG3 GLN A 132      36.979  14.707  54.619  1.00  0.00           H  
ATOM   2022 HE21 GLN A 132      35.525  16.127  55.175  1.00  0.00           H  
ATOM   2023 HE22 GLN A 132      34.013  16.417  54.409  1.00  0.00           H  
ATOM   2024  N   ILE A 133      39.100  16.452  54.453  1.00  0.00           N  
ATOM   2025  CA  ILE A 133      39.314  17.075  55.716  1.00  0.00           C  
ATOM   2026  C   ILE A 133      38.234  18.085  56.006  1.00  0.00           C  
ATOM   2027  O   ILE A 133      38.064  19.058  55.295  1.00  0.00           O  
ATOM   2028  CB  ILE A 133      40.696  17.692  55.737  1.00  0.00           C  
ATOM   2029  CG1 ILE A 133      41.684  16.567  55.994  1.00  0.00           C  
ATOM   2030  CG2 ILE A 133      40.804  18.790  56.779  1.00  0.00           C  
ATOM   2031  CD1 ILE A 133      41.726  16.138  57.444  1.00  0.00           C  
ATOM   2032  H   ILE A 133      38.881  17.006  53.685  1.00  0.00           H  
ATOM   2033  HA  ILE A 133      39.280  16.305  56.475  1.00  0.00           H  
ATOM   2034  HB  ILE A 133      40.890  18.125  54.770  1.00  0.00           H  
ATOM   2035 HG12 ILE A 133      41.411  15.691  55.404  1.00  0.00           H  
ATOM   2036 HG13 ILE A 133      42.658  16.887  55.710  1.00  0.00           H  
ATOM   2037 HG21 ILE A 133      41.773  18.734  57.257  1.00  0.00           H  
ATOM   2038 HG22 ILE A 133      40.030  18.664  57.520  1.00  0.00           H  
ATOM   2039 HG23 ILE A 133      40.694  19.753  56.302  1.00  0.00           H  
ATOM   2040 HD11 ILE A 133      40.981  16.690  57.998  1.00  0.00           H  
ATOM   2041 HD12 ILE A 133      42.704  16.343  57.852  1.00  0.00           H  
ATOM   2042 HD13 ILE A 133      41.516  15.082  57.514  1.00  0.00           H  
ATOM   2043  N   ASP A 134      37.561  17.871  57.106  1.00  0.00           N  
ATOM   2044  CA  ASP A 134      36.524  18.780  57.547  1.00  0.00           C  
ATOM   2045  C   ASP A 134      36.969  19.457  58.823  1.00  0.00           C  
ATOM   2046  O   ASP A 134      37.880  18.979  59.485  1.00  0.00           O  
ATOM   2047  CB  ASP A 134      35.197  18.046  57.781  1.00  0.00           C  
ATOM   2048  CG  ASP A 134      35.180  17.245  59.063  1.00  0.00           C  
ATOM   2049  OD1 ASP A 134      35.906  16.242  59.147  1.00  0.00           O  
ATOM   2050  OD2 ASP A 134      34.433  17.626  59.986  1.00  0.00           O  
ATOM   2051  H   ASP A 134      37.842  17.134  57.676  1.00  0.00           H  
ATOM   2052  HA  ASP A 134      36.388  19.530  56.781  1.00  0.00           H  
ATOM   2053  HB2 ASP A 134      34.403  18.769  57.830  1.00  0.00           H  
ATOM   2054  HB3 ASP A 134      35.011  17.370  56.959  1.00  0.00           H  
ATOM   2055  N   TYR A 135      36.324  20.561  59.173  1.00  0.00           N  
ATOM   2056  CA  TYR A 135      36.658  21.280  60.393  1.00  0.00           C  
ATOM   2057  C   TYR A 135      36.976  20.310  61.520  1.00  0.00           C  
ATOM   2058  O   TYR A 135      37.795  20.597  62.391  1.00  0.00           O  
ATOM   2059  CB  TYR A 135      35.500  22.187  60.773  1.00  0.00           C  
ATOM   2060  CG  TYR A 135      35.511  22.653  62.211  1.00  0.00           C  
ATOM   2061  CD1 TYR A 135      36.490  23.527  62.674  1.00  0.00           C  
ATOM   2062  CD2 TYR A 135      34.538  22.226  63.107  1.00  0.00           C  
ATOM   2063  CE1 TYR A 135      36.500  23.957  63.987  1.00  0.00           C  
ATOM   2064  CE2 TYR A 135      34.542  22.651  64.421  1.00  0.00           C  
ATOM   2065  CZ  TYR A 135      35.524  23.517  64.856  1.00  0.00           C  
ATOM   2066  OH  TYR A 135      35.531  23.942  66.165  1.00  0.00           O  
ATOM   2067  H   TYR A 135      35.602  20.894  58.602  1.00  0.00           H  
ATOM   2068  HA  TYR A 135      37.531  21.885  60.195  1.00  0.00           H  
ATOM   2069  HB2 TYR A 135      35.559  23.057  60.153  1.00  0.00           H  
ATOM   2070  HB3 TYR A 135      34.566  21.675  60.579  1.00  0.00           H  
ATOM   2071  HD1 TYR A 135      37.251  23.872  61.988  1.00  0.00           H  
ATOM   2072  HD2 TYR A 135      33.772  21.546  62.763  1.00  0.00           H  
ATOM   2073  HE1 TYR A 135      37.269  24.635  64.326  1.00  0.00           H  
ATOM   2074  HE2 TYR A 135      33.777  22.308  65.101  1.00  0.00           H  
ATOM   2075  HH  TYR A 135      34.898  24.657  66.272  1.00  0.00           H  
ATOM   2076  N   GLY A 136      36.341  19.146  61.474  1.00  0.00           N  
ATOM   2077  CA  GLY A 136      36.587  18.135  62.472  1.00  0.00           C  
ATOM   2078  C   GLY A 136      37.802  17.298  62.134  1.00  0.00           C  
ATOM   2079  O   GLY A 136      38.642  17.048  62.993  1.00  0.00           O  
ATOM   2080  H   GLY A 136      35.716  18.967  60.741  1.00  0.00           H  
ATOM   2081  HA2 GLY A 136      36.752  18.622  63.418  1.00  0.00           H  
ATOM   2082  HA3 GLY A 136      35.726  17.493  62.546  1.00  0.00           H  
ATOM   2083  N   GLU A 137      37.906  16.876  60.873  1.00  0.00           N  
ATOM   2084  CA  GLU A 137      39.051  16.086  60.439  1.00  0.00           C  
ATOM   2085  C   GLU A 137      40.316  16.907  60.580  1.00  0.00           C  
ATOM   2086  O   GLU A 137      41.279  16.459  61.194  1.00  0.00           O  
ATOM   2087  CB  GLU A 137      38.906  15.624  58.995  1.00  0.00           C  
ATOM   2088  CG  GLU A 137      37.976  14.443  58.810  1.00  0.00           C  
ATOM   2089  CD  GLU A 137      37.800  14.075  57.357  1.00  0.00           C  
ATOM   2090  OE1 GLU A 137      37.161  14.855  56.621  1.00  0.00           O  
ATOM   2091  OE2 GLU A 137      38.324  13.020  56.948  1.00  0.00           O  
ATOM   2092  H   GLU A 137      37.213  17.117  60.226  1.00  0.00           H  
ATOM   2093  HA  GLU A 137      39.122  15.222  61.084  1.00  0.00           H  
ATOM   2094  HB2 GLU A 137      38.533  16.441  58.408  1.00  0.00           H  
ATOM   2095  HB3 GLU A 137      39.880  15.344  58.624  1.00  0.00           H  
ATOM   2096  HG2 GLU A 137      38.389  13.593  59.328  1.00  0.00           H  
ATOM   2097  HG3 GLU A 137      37.011  14.687  59.225  1.00  0.00           H  
ATOM   2098  N   PHE A 138      40.309  18.124  60.029  1.00  0.00           N  
ATOM   2099  CA  PHE A 138      41.471  18.985  60.142  1.00  0.00           C  
ATOM   2100  C   PHE A 138      41.807  19.181  61.611  1.00  0.00           C  
ATOM   2101  O   PHE A 138      42.919  19.576  61.966  1.00  0.00           O  
ATOM   2102  CB  PHE A 138      41.271  20.365  59.502  1.00  0.00           C  
ATOM   2103  CG  PHE A 138      42.582  21.072  59.358  1.00  0.00           C  
ATOM   2104  CD1 PHE A 138      43.659  20.441  58.736  1.00  0.00           C  
ATOM   2105  CD2 PHE A 138      42.754  22.346  59.862  1.00  0.00           C  
ATOM   2106  CE1 PHE A 138      44.876  21.082  58.624  1.00  0.00           C  
ATOM   2107  CE2 PHE A 138      43.970  22.991  59.751  1.00  0.00           C  
ATOM   2108  CZ  PHE A 138      45.032  22.358  59.130  1.00  0.00           C  
ATOM   2109  H   PHE A 138      39.511  18.443  59.557  1.00  0.00           H  
ATOM   2110  HA  PHE A 138      42.298  18.488  59.658  1.00  0.00           H  
ATOM   2111  HB2 PHE A 138      40.810  20.285  58.524  1.00  0.00           H  
ATOM   2112  HB3 PHE A 138      40.641  20.963  60.137  1.00  0.00           H  
ATOM   2113  HD1 PHE A 138      43.537  19.433  58.338  1.00  0.00           H  
ATOM   2114  HD2 PHE A 138      41.922  22.838  60.348  1.00  0.00           H  
ATOM   2115  HE1 PHE A 138      45.705  20.586  58.140  1.00  0.00           H  
ATOM   2116  HE2 PHE A 138      44.092  23.987  60.148  1.00  0.00           H  
ATOM   2117  HZ  PHE A 138      45.984  22.861  59.046  1.00  0.00           H  
ATOM   2118  N   ALA A 139      40.827  18.899  62.460  1.00  0.00           N  
ATOM   2119  CA  ALA A 139      40.985  19.032  63.894  1.00  0.00           C  
ATOM   2120  C   ALA A 139      41.589  17.767  64.501  1.00  0.00           C  
ATOM   2121  O   ALA A 139      42.440  17.840  65.384  1.00  0.00           O  
ATOM   2122  CB  ALA A 139      39.636  19.355  64.523  1.00  0.00           C  
ATOM   2123  H   ALA A 139      39.969  18.574  62.111  1.00  0.00           H  
ATOM   2124  HA  ALA A 139      41.651  19.863  64.080  1.00  0.00           H  
ATOM   2125  HB1 ALA A 139      39.783  19.976  65.394  1.00  0.00           H  
ATOM   2126  HB2 ALA A 139      39.142  18.439  64.810  1.00  0.00           H  
ATOM   2127  HB3 ALA A 139      39.023  19.885  63.802  1.00  0.00           H  
ATOM   2128  N   ALA A 140      41.140  16.605  64.024  1.00  0.00           N  
ATOM   2129  CA  ALA A 140      41.637  15.328  64.527  1.00  0.00           C  
ATOM   2130  C   ALA A 140      42.894  14.865  63.787  1.00  0.00           C  
ATOM   2131  O   ALA A 140      43.552  13.913  64.208  1.00  0.00           O  
ATOM   2132  CB  ALA A 140      40.554  14.272  64.402  1.00  0.00           C  
ATOM   2133  H   ALA A 140      40.449  16.604  63.319  1.00  0.00           H  
ATOM   2134  HA  ALA A 140      41.871  15.450  65.575  1.00  0.00           H  
ATOM   2135  HB1 ALA A 140      40.970  13.303  64.628  1.00  0.00           H  
ATOM   2136  HB2 ALA A 140      40.169  14.273  63.392  1.00  0.00           H  
ATOM   2137  HB3 ALA A 140      39.754  14.492  65.092  1.00  0.00           H  
ATOM   2138  N   MET A 141      43.210  15.523  62.677  1.00  0.00           N  
ATOM   2139  CA  MET A 141      44.369  15.161  61.874  1.00  0.00           C  
ATOM   2140  C   MET A 141      45.672  15.554  62.561  1.00  0.00           C  
ATOM   2141  O   MET A 141      46.757  15.214  62.089  1.00  0.00           O  
ATOM   2142  CB  MET A 141      44.269  15.823  60.499  1.00  0.00           C  
ATOM   2143  CG  MET A 141      44.387  17.339  60.530  1.00  0.00           C  
ATOM   2144  SD  MET A 141      46.094  17.914  60.557  1.00  0.00           S  
ATOM   2145  CE  MET A 141      46.646  17.380  58.937  1.00  0.00           C  
ATOM   2146  H   MET A 141      42.645  16.262  62.380  1.00  0.00           H  
ATOM   2147  HA  MET A 141      44.357  14.089  61.743  1.00  0.00           H  
ATOM   2148  HB2 MET A 141      45.054  15.438  59.874  1.00  0.00           H  
ATOM   2149  HB3 MET A 141      43.315  15.568  60.059  1.00  0.00           H  
ATOM   2150  HG2 MET A 141      43.904  17.741  59.653  1.00  0.00           H  
ATOM   2151  HG3 MET A 141      43.885  17.705  61.415  1.00  0.00           H  
ATOM   2152  HE1 MET A 141      47.719  17.263  58.942  1.00  0.00           H  
ATOM   2153  HE2 MET A 141      46.364  18.118  58.199  1.00  0.00           H  
ATOM   2154  HE3 MET A 141      46.182  16.434  58.694  1.00  0.00           H  
ATOM   2155  N   MET A 142      45.562  16.266  63.676  1.00  0.00           N  
ATOM   2156  CA  MET A 142      46.737  16.698  64.422  1.00  0.00           C  
ATOM   2157  C   MET A 142      46.554  16.460  65.916  1.00  0.00           C  
ATOM   2158  O   MET A 142      47.520  16.204  66.634  1.00  0.00           O  
ATOM   2159  CB  MET A 142      47.024  18.177  64.158  1.00  0.00           C  
ATOM   2160  CG  MET A 142      45.901  19.104  64.595  1.00  0.00           C  
ATOM   2161  SD  MET A 142      46.289  20.841  64.314  1.00  0.00           S  
ATOM   2162  CE  MET A 142      44.831  21.627  64.993  1.00  0.00           C  
ATOM   2163  H   MET A 142      44.669  16.506  64.005  1.00  0.00           H  
ATOM   2164  HA  MET A 142      47.578  16.113  64.078  1.00  0.00           H  
ATOM   2165  HB2 MET A 142      47.921  18.458  64.692  1.00  0.00           H  
ATOM   2166  HB3 MET A 142      47.185  18.319  63.100  1.00  0.00           H  
ATOM   2167  HG2 MET A 142      45.010  18.855  64.038  1.00  0.00           H  
ATOM   2168  HG3 MET A 142      45.718  18.955  65.649  1.00  0.00           H  
ATOM   2169  HE1 MET A 142      44.083  21.728  64.219  1.00  0.00           H  
ATOM   2170  HE2 MET A 142      45.092  22.605  65.372  1.00  0.00           H  
ATOM   2171  HE3 MET A 142      44.438  21.024  65.798  1.00  0.00           H  
ATOM   2172  N   ARG A 143      45.309  16.545  66.377  1.00  0.00           N  
ATOM   2173  CA  ARG A 143      45.006  16.338  67.787  1.00  0.00           C  
ATOM   2174  C   ARG A 143      44.198  15.051  67.977  1.00  0.00           C  
ATOM   2175  O   ARG A 143      44.498  14.031  67.351  1.00  0.00           O  
ATOM   2176  CB  ARG A 143      44.244  17.547  68.344  1.00  0.00           C  
ATOM   2177  CG  ARG A 143      44.295  17.656  69.862  1.00  0.00           C  
ATOM   2178  CD  ARG A 143      43.547  18.882  70.363  1.00  0.00           C  
ATOM   2179  NE  ARG A 143      43.562  18.971  71.822  1.00  0.00           N  
ATOM   2180  CZ  ARG A 143      42.997  19.960  72.510  1.00  0.00           C  
ATOM   2181  NH1 ARG A 143      42.377  20.947  71.875  1.00  0.00           N  
ATOM   2182  NH2 ARG A 143      43.051  19.964  73.836  1.00  0.00           N  
ATOM   2183  H   ARG A 143      44.581  16.752  65.756  1.00  0.00           H  
ATOM   2184  HA  ARG A 143      45.944  16.241  68.316  1.00  0.00           H  
ATOM   2185  HB2 ARG A 143      44.664  18.447  67.923  1.00  0.00           H  
ATOM   2186  HB3 ARG A 143      43.208  17.472  68.045  1.00  0.00           H  
ATOM   2187  HG2 ARG A 143      43.845  16.774  70.290  1.00  0.00           H  
ATOM   2188  HG3 ARG A 143      45.327  17.724  70.172  1.00  0.00           H  
ATOM   2189  HD2 ARG A 143      44.012  19.766  69.953  1.00  0.00           H  
ATOM   2190  HD3 ARG A 143      42.523  18.825  70.026  1.00  0.00           H  
ATOM   2191  HE  ARG A 143      44.017  18.257  72.316  1.00  0.00           H  
ATOM   2192 HH11 ARG A 143      42.332  20.949  70.878  1.00  0.00           H  
ATOM   2193 HH12 ARG A 143      41.954  21.688  72.396  1.00  0.00           H  
ATOM   2194 HH21 ARG A 143      43.519  19.223  74.318  1.00  0.00           H  
ATOM   2195 HH22 ARG A 143      42.628  20.707  74.351  1.00  0.00           H  
ATOM   2196  N   LYS A 144      43.178  15.095  68.830  1.00  0.00           N  
ATOM   2197  CA  LYS A 144      42.343  13.928  69.085  1.00  0.00           C  
ATOM   2198  C   LYS A 144      40.865  14.296  68.989  1.00  0.00           C  
ATOM   2199  O   LYS A 144      40.521  15.425  68.640  1.00  0.00           O  
ATOM   2200  CB  LYS A 144      42.649  13.349  70.469  1.00  0.00           C  
ATOM   2201  CG  LYS A 144      44.103  12.940  70.643  1.00  0.00           C  
ATOM   2202  CD  LYS A 144      44.362  12.377  72.031  1.00  0.00           C  
ATOM   2203  CE  LYS A 144      45.827  12.021  72.221  1.00  0.00           C  
ATOM   2204  NZ  LYS A 144      46.092  11.458  73.575  1.00  0.00           N  
ATOM   2205  H   LYS A 144      42.982  15.929  69.301  1.00  0.00           H  
ATOM   2206  HA  LYS A 144      42.568  13.187  68.334  1.00  0.00           H  
ATOM   2207  HB2 LYS A 144      42.413  14.090  71.218  1.00  0.00           H  
ATOM   2208  HB3 LYS A 144      42.032  12.478  70.627  1.00  0.00           H  
ATOM   2209  HG2 LYS A 144      44.346  12.185  69.909  1.00  0.00           H  
ATOM   2210  HG3 LYS A 144      44.731  13.806  70.493  1.00  0.00           H  
ATOM   2211  HD2 LYS A 144      44.083  13.117  72.767  1.00  0.00           H  
ATOM   2212  HD3 LYS A 144      43.764  11.489  72.165  1.00  0.00           H  
ATOM   2213  HE2 LYS A 144      46.106  11.289  71.478  1.00  0.00           H  
ATOM   2214  HE3 LYS A 144      46.421  12.913  72.088  1.00  0.00           H  
ATOM   2215  HZ1 LYS A 144      45.413  11.847  74.261  1.00  0.00           H  
ATOM   2216  HZ2 LYS A 144      47.055  11.702  73.881  1.00  0.00           H  
ATOM   2217  HZ3 LYS A 144      45.998  10.423  73.556  1.00  0.00           H  
ATOM   2218  N   ARG A 145      39.997  13.337  69.292  1.00  0.00           N  
ATOM   2219  CA  ARG A 145      38.556  13.565  69.234  1.00  0.00           C  
ATOM   2220  C   ARG A 145      37.961  13.803  70.621  1.00  0.00           C  
ATOM   2221  O   ARG A 145      37.346  12.917  71.212  1.00  0.00           O  
ATOM   2222  CB  ARG A 145      37.858  12.393  68.534  1.00  0.00           C  
ATOM   2223  CG  ARG A 145      38.552  11.044  68.701  1.00  0.00           C  
ATOM   2224  CD  ARG A 145      38.437  10.496  70.117  1.00  0.00           C  
ATOM   2225  NE  ARG A 145      39.294  11.208  71.063  1.00  0.00           N  
ATOM   2226  CZ  ARG A 145      39.370  10.911  72.358  1.00  0.00           C  
ATOM   2227  NH1 ARG A 145      38.630   9.932  72.863  1.00  0.00           N  
ATOM   2228  NH2 ARG A 145      40.184  11.597  73.147  1.00  0.00           N  
ATOM   2229  H   ARG A 145      40.332  12.457  69.561  1.00  0.00           H  
ATOM   2230  HA  ARG A 145      38.398  14.456  68.645  1.00  0.00           H  
ATOM   2231  HB2 ARG A 145      36.857  12.304  68.927  1.00  0.00           H  
ATOM   2232  HB3 ARG A 145      37.798  12.611  67.478  1.00  0.00           H  
ATOM   2233  HG2 ARG A 145      38.106  10.337  68.019  1.00  0.00           H  
ATOM   2234  HG3 ARG A 145      39.600  11.163  68.459  1.00  0.00           H  
ATOM   2235  HD2 ARG A 145      37.411  10.588  70.440  1.00  0.00           H  
ATOM   2236  HD3 ARG A 145      38.717   9.452  70.107  1.00  0.00           H  
ATOM   2237  HE  ARG A 145      39.845  11.936  70.715  1.00  0.00           H  
ATOM   2238 HH11 ARG A 145      38.014   9.413  72.273  1.00  0.00           H  
ATOM   2239 HH12 ARG A 145      38.690   9.714  73.838  1.00  0.00           H  
ATOM   2240 HH21 ARG A 145      40.742  12.336  72.771  1.00  0.00           H  
ATOM   2241 HH22 ARG A 145      40.241  11.375  74.121  1.00  0.00           H  
ATOM   2242  N   LYS A 146      38.142  15.019  71.130  1.00  0.00           N  
ATOM   2243  CA  LYS A 146      37.622  15.393  72.443  1.00  0.00           C  
ATOM   2244  C   LYS A 146      36.126  15.109  72.538  1.00  0.00           C  
ATOM   2245  O   LYS A 146      35.429  15.058  71.525  1.00  0.00           O  
ATOM   2246  CB  LYS A 146      37.885  16.878  72.728  1.00  0.00           C  
ATOM   2247  CG  LYS A 146      39.357  17.230  72.909  1.00  0.00           C  
ATOM   2248  CD  LYS A 146      40.154  17.105  71.615  1.00  0.00           C  
ATOM   2249  CE  LYS A 146      39.773  18.176  70.600  1.00  0.00           C  
ATOM   2250  NZ  LYS A 146      38.384  18.005  70.091  1.00  0.00           N  
ATOM   2251  H   LYS A 146      38.633  15.685  70.604  1.00  0.00           H  
ATOM   2252  HA  LYS A 146      38.136  14.798  73.182  1.00  0.00           H  
ATOM   2253  HB2 LYS A 146      37.498  17.462  71.906  1.00  0.00           H  
ATOM   2254  HB3 LYS A 146      37.358  17.154  73.629  1.00  0.00           H  
ATOM   2255  HG2 LYS A 146      39.429  18.249  73.259  1.00  0.00           H  
ATOM   2256  HG3 LYS A 146      39.784  16.566  73.647  1.00  0.00           H  
ATOM   2257  HD2 LYS A 146      41.206  17.201  71.843  1.00  0.00           H  
ATOM   2258  HD3 LYS A 146      39.968  16.132  71.184  1.00  0.00           H  
ATOM   2259  HE2 LYS A 146      39.857  19.144  71.070  1.00  0.00           H  
ATOM   2260  HE3 LYS A 146      40.459  18.123  69.768  1.00  0.00           H  
ATOM   2261  HZ1 LYS A 146      38.131  16.997  70.073  1.00  0.00           H  
ATOM   2262  HZ2 LYS A 146      38.307  18.390  69.129  1.00  0.00           H  
ATOM   2263  HZ3 LYS A 146      37.714  18.508  70.708  1.00  0.00           H  
ATOM   2264  N   GLY A 147      35.638  14.920  73.761  1.00  0.00           N  
ATOM   2265  CA  GLY A 147      34.229  14.639  73.969  1.00  0.00           C  
ATOM   2266  C   GLY A 147      33.384  15.896  74.062  1.00  0.00           C  
ATOM   2267  O   GLY A 147      32.160  15.823  74.156  1.00  0.00           O  
ATOM   2268  H   GLY A 147      36.244  14.970  74.531  1.00  0.00           H  
ATOM   2269  HA2 GLY A 147      33.868  14.039  73.145  1.00  0.00           H  
ATOM   2270  HA3 GLY A 147      34.117  14.075  74.883  1.00  0.00           H  
ATOM   2271  N   ASN A 148      34.042  17.051  74.043  1.00  0.00           N  
ATOM   2272  CA  ASN A 148      33.346  18.332  74.131  1.00  0.00           C  
ATOM   2273  C   ASN A 148      32.757  18.730  72.782  1.00  0.00           C  
ATOM   2274  O   ASN A 148      33.153  18.205  71.742  1.00  0.00           O  
ATOM   2275  CB  ASN A 148      34.298  19.420  74.633  1.00  0.00           C  
ATOM   2276  CG  ASN A 148      35.533  19.560  73.764  1.00  0.00           C  
ATOM   2277  OD1 ASN A 148      35.438  19.849  72.571  1.00  0.00           O  
ATOM   2278  ND2 ASN A 148      36.701  19.356  74.363  1.00  0.00           N  
ATOM   2279  H   ASN A 148      35.019  17.042  73.967  1.00  0.00           H  
ATOM   2280  HA  ASN A 148      32.542  18.218  74.840  1.00  0.00           H  
ATOM   2281  HB2 ASN A 148      33.778  20.366  74.642  1.00  0.00           H  
ATOM   2282  HB3 ASN A 148      34.613  19.178  75.637  1.00  0.00           H  
ATOM   2283 HD21 ASN A 148      36.699  19.131  75.317  1.00  0.00           H  
ATOM   2284 HD22 ASN A 148      37.516  19.440  73.825  1.00  0.00           H  
ATOM   2285  N   GLY A 149      31.799  19.658  72.814  1.00  0.00           N  
ATOM   2286  CA  GLY A 149      31.155  20.117  71.594  1.00  0.00           C  
ATOM   2287  C   GLY A 149      32.143  20.460  70.495  1.00  0.00           C  
ATOM   2288  O   GLY A 149      31.789  20.442  69.314  1.00  0.00           O  
ATOM   2289  H   GLY A 149      31.526  20.031  73.678  1.00  0.00           H  
ATOM   2290  HA2 GLY A 149      30.493  19.343  71.237  1.00  0.00           H  
ATOM   2291  HA3 GLY A 149      30.568  20.997  71.821  1.00  0.00           H  
ATOM   2292  N   GLY A 150      33.376  20.777  70.886  1.00  0.00           N  
ATOM   2293  CA  GLY A 150      34.412  21.126  69.922  1.00  0.00           C  
ATOM   2294  C   GLY A 150      34.415  20.222  68.701  1.00  0.00           C  
ATOM   2295  O   GLY A 150      34.848  20.631  67.625  1.00  0.00           O  
ATOM   2296  H   GLY A 150      33.583  20.785  71.843  1.00  0.00           H  
ATOM   2297  HA2 GLY A 150      34.256  22.145  69.599  1.00  0.00           H  
ATOM   2298  HA3 GLY A 150      35.374  21.059  70.407  1.00  0.00           H  
ATOM   2299  N   ILE A 151      33.923  18.994  68.869  1.00  0.00           N  
ATOM   2300  CA  ILE A 151      33.858  18.032  67.773  1.00  0.00           C  
ATOM   2301  C   ILE A 151      33.242  18.657  66.530  1.00  0.00           C  
ATOM   2302  O   ILE A 151      32.389  19.539  66.627  1.00  0.00           O  
ATOM   2303  CB  ILE A 151      33.048  16.778  68.176  1.00  0.00           C  
ATOM   2304  CG1 ILE A 151      33.859  15.924  69.144  1.00  0.00           C  
ATOM   2305  CG2 ILE A 151      32.650  15.959  66.953  1.00  0.00           C  
ATOM   2306  CD1 ILE A 151      33.128  14.681  69.616  1.00  0.00           C  
ATOM   2307  H   ILE A 151      33.588  18.734  69.751  1.00  0.00           H  
ATOM   2308  HA  ILE A 151      34.867  17.723  67.544  1.00  0.00           H  
ATOM   2309  HB  ILE A 151      32.146  17.104  68.671  1.00  0.00           H  
ATOM   2310 HG12 ILE A 151      34.766  15.612  68.648  1.00  0.00           H  
ATOM   2311 HG13 ILE A 151      34.111  16.515  70.012  1.00  0.00           H  
ATOM   2312 HG21 ILE A 151      33.348  15.145  66.821  1.00  0.00           H  
ATOM   2313 HG22 ILE A 151      32.661  16.586  66.075  1.00  0.00           H  
ATOM   2314 HG23 ILE A 151      31.657  15.558  67.096  1.00  0.00           H  
ATOM   2315 HD11 ILE A 151      33.018  13.990  68.792  1.00  0.00           H  
ATOM   2316 HD12 ILE A 151      32.151  14.958  69.985  1.00  0.00           H  
ATOM   2317 HD13 ILE A 151      33.692  14.210  70.408  1.00  0.00           H  
ATOM   2318  N   GLY A 152      33.671  18.190  65.362  1.00  0.00           N  
ATOM   2319  CA  GLY A 152      33.142  18.714  64.129  1.00  0.00           C  
ATOM   2320  C   GLY A 152      33.346  17.757  62.978  1.00  0.00           C  
ATOM   2321  O   GLY A 152      32.876  18.009  61.869  1.00  0.00           O  
ATOM   2322  H   GLY A 152      34.347  17.478  65.339  1.00  0.00           H  
ATOM   2323  HA2 GLY A 152      32.087  18.890  64.258  1.00  0.00           H  
ATOM   2324  HA3 GLY A 152      33.632  19.649  63.902  1.00  0.00           H  
ATOM   2325  N   ARG A 153      34.047  16.657  63.249  1.00  0.00           N  
ATOM   2326  CA  ARG A 153      34.316  15.649  62.230  1.00  0.00           C  
ATOM   2327  C   ARG A 153      33.011  15.196  61.582  1.00  0.00           C  
ATOM   2328  O   ARG A 153      31.924  15.561  62.032  1.00  0.00           O  
ATOM   2329  CB  ARG A 153      35.094  14.446  62.780  1.00  0.00           C  
ATOM   2330  CG  ARG A 153      36.410  14.789  63.470  1.00  0.00           C  
ATOM   2331  CD  ARG A 153      36.214  15.449  64.826  1.00  0.00           C  
ATOM   2332  NE  ARG A 153      37.490  15.847  65.420  1.00  0.00           N  
ATOM   2333  CZ  ARG A 153      37.610  16.399  66.623  1.00  0.00           C  
ATOM   2334  NH1 ARG A 153      36.540  16.591  67.381  1.00  0.00           N  
ATOM   2335  NH2 ARG A 153      38.806  16.757  67.072  1.00  0.00           N  
ATOM   2336  H   ARG A 153      34.387  16.521  64.156  1.00  0.00           H  
ATOM   2337  HA  ARG A 153      34.916  16.125  61.468  1.00  0.00           H  
ATOM   2338  HB2 ARG A 153      34.472  13.909  63.478  1.00  0.00           H  
ATOM   2339  HB3 ARG A 153      35.331  13.801  61.946  1.00  0.00           H  
ATOM   2340  HG2 ARG A 153      36.974  13.879  63.610  1.00  0.00           H  
ATOM   2341  HG3 ARG A 153      36.969  15.459  62.833  1.00  0.00           H  
ATOM   2342  HD2 ARG A 153      35.596  16.325  64.703  1.00  0.00           H  
ATOM   2343  HD3 ARG A 153      35.722  14.750  65.486  1.00  0.00           H  
ATOM   2344  HE  ARG A 153      38.300  15.702  64.887  1.00  0.00           H  
ATOM   2345 HH11 ARG A 153      35.638  16.318  67.050  1.00  0.00           H  
ATOM   2346 HH12 ARG A 153      36.637  17.007  68.285  1.00  0.00           H  
ATOM   2347 HH21 ARG A 153      39.617  16.612  66.505  1.00  0.00           H  
ATOM   2348 HH22 ARG A 153      38.897  17.176  67.976  1.00  0.00           H  
ATOM   2349  N   ARG A 154      33.120  14.428  60.509  1.00  0.00           N  
ATOM   2350  CA  ARG A 154      31.936  13.968  59.787  1.00  0.00           C  
ATOM   2351  C   ARG A 154      31.174  12.924  60.589  1.00  0.00           C  
ATOM   2352  O   ARG A 154      31.768  12.177  61.363  1.00  0.00           O  
ATOM   2353  CB  ARG A 154      32.318  13.396  58.421  1.00  0.00           C  
ATOM   2354  CG  ARG A 154      31.142  13.269  57.468  1.00  0.00           C  
ATOM   2355  CD  ARG A 154      30.587  14.635  57.090  1.00  0.00           C  
ATOM   2356  NE  ARG A 154      29.439  14.540  56.194  1.00  0.00           N  
ATOM   2357  CZ  ARG A 154      28.269  14.005  56.539  1.00  0.00           C  
ATOM   2358  NH1 ARG A 154      28.085  13.532  57.765  1.00  0.00           N  
ATOM   2359  NH2 ARG A 154      27.281  13.953  55.659  1.00  0.00           N  
ATOM   2360  H   ARG A 154      34.014  14.175  60.190  1.00  0.00           H  
ATOM   2361  HA  ARG A 154      31.292  14.822  59.638  1.00  0.00           H  
ATOM   2362  HB2 ARG A 154      33.055  14.042  57.966  1.00  0.00           H  
ATOM   2363  HB3 ARG A 154      32.750  12.418  58.561  1.00  0.00           H  
ATOM   2364  HG2 ARG A 154      31.467  12.763  56.572  1.00  0.00           H  
ATOM   2365  HG3 ARG A 154      30.363  12.693  57.947  1.00  0.00           H  
ATOM   2366  HD2 ARG A 154      30.284  15.146  57.992  1.00  0.00           H  
ATOM   2367  HD3 ARG A 154      31.366  15.201  56.603  1.00  0.00           H  
ATOM   2368  HE  ARG A 154      29.543  14.891  55.284  1.00  0.00           H  
ATOM   2369 HH11 ARG A 154      28.827  13.574  58.434  1.00  0.00           H  
ATOM   2370 HH12 ARG A 154      27.205  13.134  58.019  1.00  0.00           H  
ATOM   2371 HH21 ARG A 154      27.413  14.312  54.735  1.00  0.00           H  
ATOM   2372 HH22 ARG A 154      26.402  13.553  55.918  1.00  0.00           H  
ATOM   2373  N   THR A 155      29.849  12.896  60.405  1.00  0.00           N  
ATOM   2374  CA  THR A 155      28.975  11.959  61.114  1.00  0.00           C  
ATOM   2375  C   THR A 155      29.494  10.525  61.006  1.00  0.00           C  
ATOM   2376  O   THR A 155      29.013   9.733  60.195  1.00  0.00           O  
ATOM   2377  CB  THR A 155      27.552  12.041  60.561  1.00  0.00           C  
ATOM   2378  OG1 THR A 155      27.065  13.370  60.625  1.00  0.00           O  
ATOM   2379  CG2 THR A 155      26.569  11.160  61.300  1.00  0.00           C  
ATOM   2380  H   THR A 155      29.447  13.534  59.779  1.00  0.00           H  
ATOM   2381  HA  THR A 155      28.962  12.243  62.155  1.00  0.00           H  
ATOM   2382  HB  THR A 155      27.559  11.731  59.524  1.00  0.00           H  
ATOM   2383  HG1 THR A 155      27.706  13.925  61.074  1.00  0.00           H  
ATOM   2384 HG21 THR A 155      26.720  10.131  61.011  1.00  0.00           H  
ATOM   2385 HG22 THR A 155      25.561  11.459  61.056  1.00  0.00           H  
ATOM   2386 HG23 THR A 155      26.728  11.260  62.364  1.00  0.00           H  
ATOM   2387  N   MET A 156      30.476  10.211  61.836  1.00  0.00           N  
ATOM   2388  CA  MET A 156      31.087   8.891  61.868  1.00  0.00           C  
ATOM   2389  C   MET A 156      32.106   8.839  62.997  1.00  0.00           C  
ATOM   2390  O   MET A 156      32.506   7.766  63.449  1.00  0.00           O  
ATOM   2391  CB  MET A 156      31.763   8.575  60.530  1.00  0.00           C  
ATOM   2392  CG  MET A 156      32.373   7.185  60.465  1.00  0.00           C  
ATOM   2393  SD  MET A 156      33.149   6.844  58.873  1.00  0.00           S  
ATOM   2394  CE  MET A 156      33.742   5.172  59.136  1.00  0.00           C  
ATOM   2395  H   MET A 156      30.807  10.895  62.455  1.00  0.00           H  
ATOM   2396  HA  MET A 156      30.310   8.163  62.058  1.00  0.00           H  
ATOM   2397  HB2 MET A 156      31.029   8.660  59.742  1.00  0.00           H  
ATOM   2398  HB3 MET A 156      32.547   9.298  60.358  1.00  0.00           H  
ATOM   2399  HG2 MET A 156      33.122   7.098  61.238  1.00  0.00           H  
ATOM   2400  HG3 MET A 156      31.596   6.456  60.635  1.00  0.00           H  
ATOM   2401  HE1 MET A 156      34.002   4.729  58.187  1.00  0.00           H  
ATOM   2402  HE2 MET A 156      32.967   4.587  59.608  1.00  0.00           H  
ATOM   2403  HE3 MET A 156      34.614   5.196  59.772  1.00  0.00           H  
ATOM   2404  N   ARG A 157      32.518  10.024  63.444  1.00  0.00           N  
ATOM   2405  CA  ARG A 157      33.492  10.152  64.517  1.00  0.00           C  
ATOM   2406  C   ARG A 157      32.953   9.567  65.823  1.00  0.00           C  
ATOM   2407  O   ARG A 157      33.710   9.320  66.762  1.00  0.00           O  
ATOM   2408  CB  ARG A 157      33.880  11.626  64.701  1.00  0.00           C  
ATOM   2409  CG  ARG A 157      32.699  12.581  64.822  1.00  0.00           C  
ATOM   2410  CD  ARG A 157      32.030  12.493  66.186  1.00  0.00           C  
ATOM   2411  NE  ARG A 157      30.921  13.437  66.314  1.00  0.00           N  
ATOM   2412  CZ  ARG A 157      30.227  13.617  67.436  1.00  0.00           C  
ATOM   2413  NH1 ARG A 157      30.538  12.932  68.529  1.00  0.00           N  
ATOM   2414  NH2 ARG A 157      29.228  14.488  67.466  1.00  0.00           N  
ATOM   2415  H   ARG A 157      32.154  10.836  63.033  1.00  0.00           H  
ATOM   2416  HA  ARG A 157      34.369   9.601  64.222  1.00  0.00           H  
ATOM   2417  HB2 ARG A 157      34.477  11.716  65.596  1.00  0.00           H  
ATOM   2418  HB3 ARG A 157      34.475  11.933  63.853  1.00  0.00           H  
ATOM   2419  HG2 ARG A 157      33.050  13.590  64.671  1.00  0.00           H  
ATOM   2420  HG3 ARG A 157      31.972  12.333  64.059  1.00  0.00           H  
ATOM   2421  HD2 ARG A 157      31.655  11.491  66.326  1.00  0.00           H  
ATOM   2422  HD3 ARG A 157      32.766  12.712  66.947  1.00  0.00           H  
ATOM   2423  HE  ARG A 157      30.680  13.961  65.522  1.00  0.00           H  
ATOM   2424 HH11 ARG A 157      31.295  12.279  68.511  1.00  0.00           H  
ATOM   2425 HH12 ARG A 157      30.014  13.068  69.370  1.00  0.00           H  
ATOM   2426 HH21 ARG A 157      28.992  15.010  66.646  1.00  0.00           H  
ATOM   2427 HH22 ARG A 157      28.705  14.621  68.310  1.00  0.00           H  
ATOM   2428  N   LYS A 158      31.640   9.348  65.871  1.00  0.00           N  
ATOM   2429  CA  LYS A 158      30.995   8.792  67.057  1.00  0.00           C  
ATOM   2430  C   LYS A 158      29.618   8.223  66.713  1.00  0.00           C  
ATOM   2431  O   LYS A 158      29.484   7.036  66.416  1.00  0.00           O  
ATOM   2432  CB  LYS A 158      30.862   9.865  68.141  1.00  0.00           C  
ATOM   2433  CG  LYS A 158      30.175   9.382  69.411  1.00  0.00           C  
ATOM   2434  CD  LYS A 158      30.985   8.306  70.119  1.00  0.00           C  
ATOM   2435  CE  LYS A 158      32.324   8.843  70.601  1.00  0.00           C  
ATOM   2436  NZ  LYS A 158      32.157   9.992  71.533  1.00  0.00           N  
ATOM   2437  H   LYS A 158      31.093   9.565  65.088  1.00  0.00           H  
ATOM   2438  HA  LYS A 158      31.618   7.993  67.430  1.00  0.00           H  
ATOM   2439  HB2 LYS A 158      31.849  10.217  68.404  1.00  0.00           H  
ATOM   2440  HB3 LYS A 158      30.292  10.692  67.742  1.00  0.00           H  
ATOM   2441  HG2 LYS A 158      30.050  10.220  70.079  1.00  0.00           H  
ATOM   2442  HG3 LYS A 158      29.208   8.979  69.152  1.00  0.00           H  
ATOM   2443  HD2 LYS A 158      30.425   7.950  70.970  1.00  0.00           H  
ATOM   2444  HD3 LYS A 158      31.159   7.491  69.434  1.00  0.00           H  
ATOM   2445  HE2 LYS A 158      32.852   8.051  71.113  1.00  0.00           H  
ATOM   2446  HE3 LYS A 158      32.899   9.164  69.745  1.00  0.00           H  
ATOM   2447  HZ1 LYS A 158      32.478   9.728  72.487  1.00  0.00           H  
ATOM   2448  HZ2 LYS A 158      31.158  10.273  71.580  1.00  0.00           H  
ATOM   2449  HZ3 LYS A 158      32.720  10.804  71.202  1.00  0.00           H  
ATOM   2450  N   THR A 159      28.600   9.080  66.754  1.00  0.00           N  
ATOM   2451  CA  THR A 159      27.234   8.665  66.447  1.00  0.00           C  
ATOM   2452  C   THR A 159      26.352   9.877  66.156  1.00  0.00           C  
ATOM   2453  O   THR A 159      25.475   9.824  65.294  1.00  0.00           O  
ATOM   2454  CB  THR A 159      26.647   7.855  67.607  1.00  0.00           C  
ATOM   2455  OG1 THR A 159      25.310   7.482  67.331  1.00  0.00           O  
ATOM   2456  CG2 THR A 159      26.653   8.601  68.924  1.00  0.00           C  
ATOM   2457  H   THR A 159      28.772  10.014  66.995  1.00  0.00           H  
ATOM   2458  HA  THR A 159      27.270   8.042  65.565  1.00  0.00           H  
ATOM   2459  HB  THR A 159      27.231   6.956  67.734  1.00  0.00           H  
ATOM   2460  HG1 THR A 159      25.183   7.416  66.382  1.00  0.00           H  
ATOM   2461 HG21 THR A 159      26.174   9.560  68.797  1.00  0.00           H  
ATOM   2462 HG22 THR A 159      27.672   8.748  69.250  1.00  0.00           H  
ATOM   2463 HG23 THR A 159      26.118   8.025  69.665  1.00  0.00           H  
ATOM   2464  N   LEU A 160      26.595  10.969  66.878  1.00  0.00           N  
ATOM   2465  CA  LEU A 160      25.826  12.195  66.695  1.00  0.00           C  
ATOM   2466  C   LEU A 160      26.305  12.955  65.462  1.00  0.00           C  
ATOM   2467  O   LEU A 160      27.231  12.521  64.777  1.00  0.00           O  
ATOM   2468  CB  LEU A 160      25.943  13.089  67.934  1.00  0.00           C  
ATOM   2469  CG  LEU A 160      25.386  12.488  69.228  1.00  0.00           C  
ATOM   2470  CD1 LEU A 160      25.651  13.417  70.403  1.00  0.00           C  
ATOM   2471  CD2 LEU A 160      23.894  12.217  69.093  1.00  0.00           C  
ATOM   2472  H   LEU A 160      27.310  10.949  67.548  1.00  0.00           H  
ATOM   2473  HA  LEU A 160      24.792  11.921  66.555  1.00  0.00           H  
ATOM   2474  HB2 LEU A 160      26.987  13.318  68.090  1.00  0.00           H  
ATOM   2475  HB3 LEU A 160      25.417  14.011  67.739  1.00  0.00           H  
ATOM   2476  HG  LEU A 160      25.883  11.550  69.425  1.00  0.00           H  
ATOM   2477 HD11 LEU A 160      25.723  12.838  71.310  1.00  0.00           H  
ATOM   2478 HD12 LEU A 160      24.841  14.126  70.492  1.00  0.00           H  
ATOM   2479 HD13 LEU A 160      26.578  13.948  70.241  1.00  0.00           H  
ATOM   2480 HD21 LEU A 160      23.392  12.512  70.001  1.00  0.00           H  
ATOM   2481 HD22 LEU A 160      23.735  11.164  68.918  1.00  0.00           H  
ATOM   2482 HD23 LEU A 160      23.500  12.784  68.262  1.00  0.00           H  
ATOM   2483  N   ASN A 161      25.669  14.091  65.185  1.00  0.00           N  
ATOM   2484  CA  ASN A 161      26.034  14.908  64.033  1.00  0.00           C  
ATOM   2485  C   ASN A 161      26.830  16.137  64.470  1.00  0.00           C  
ATOM   2486  O   ASN A 161      28.027  16.042  64.746  1.00  0.00           O  
ATOM   2487  CB  ASN A 161      24.779  15.331  63.262  1.00  0.00           C  
ATOM   2488  CG  ASN A 161      25.106  16.154  62.031  1.00  0.00           C  
ATOM   2489  OD1 ASN A 161      25.805  15.692  61.128  1.00  0.00           O  
ATOM   2490  ND2 ASN A 161      24.601  17.381  61.987  1.00  0.00           N  
ATOM   2491  H   ASN A 161      24.939  14.384  65.769  1.00  0.00           H  
ATOM   2492  HA  ASN A 161      26.656  14.306  63.387  1.00  0.00           H  
ATOM   2493  HB2 ASN A 161      24.242  14.449  62.951  1.00  0.00           H  
ATOM   2494  HB3 ASN A 161      24.149  15.922  63.911  1.00  0.00           H  
ATOM   2495 HD21 ASN A 161      24.054  17.683  62.743  1.00  0.00           H  
ATOM   2496 HD22 ASN A 161      24.796  17.935  61.203  1.00  0.00           H  
ATOM   2497  N   LEU A 162      26.163  17.290  64.535  1.00  0.00           N  
ATOM   2498  CA  LEU A 162      26.812  18.532  64.942  1.00  0.00           C  
ATOM   2499  C   LEU A 162      25.794  19.665  65.051  1.00  0.00           C  
ATOM   2500  O   LEU A 162      24.752  19.638  64.395  1.00  0.00           O  
ATOM   2501  CB  LEU A 162      27.908  18.915  63.943  1.00  0.00           C  
ATOM   2502  CG  LEU A 162      28.714  20.163  64.309  1.00  0.00           C  
ATOM   2503  CD1 LEU A 162      29.473  19.949  65.609  1.00  0.00           C  
ATOM   2504  CD2 LEU A 162      29.671  20.527  63.184  1.00  0.00           C  
ATOM   2505  H   LEU A 162      25.210  17.304  64.307  1.00  0.00           H  
ATOM   2506  HA  LEU A 162      27.260  18.372  65.912  1.00  0.00           H  
ATOM   2507  HB2 LEU A 162      28.592  18.082  63.855  1.00  0.00           H  
ATOM   2508  HB3 LEU A 162      27.446  19.080  62.981  1.00  0.00           H  
ATOM   2509  HG  LEU A 162      28.034  20.990  64.451  1.00  0.00           H  
ATOM   2510 HD11 LEU A 162      29.383  18.917  65.913  1.00  0.00           H  
ATOM   2511 HD12 LEU A 162      29.059  20.587  66.376  1.00  0.00           H  
ATOM   2512 HD13 LEU A 162      30.514  20.193  65.463  1.00  0.00           H  
ATOM   2513 HD21 LEU A 162      30.149  21.470  63.409  1.00  0.00           H  
ATOM   2514 HD22 LEU A 162      29.123  20.613  62.258  1.00  0.00           H  
ATOM   2515 HD23 LEU A 162      30.423  19.759  63.088  1.00  0.00           H  
ATOM   2516  N   ARG A 163      26.104  20.657  65.880  1.00  0.00           N  
ATOM   2517  CA  ARG A 163      25.217  21.799  66.072  1.00  0.00           C  
ATOM   2518  C   ARG A 163      25.539  22.906  65.072  1.00  0.00           C  
ATOM   2519  O   ARG A 163      26.707  23.187  64.800  1.00  0.00           O  
ATOM   2520  CB  ARG A 163      25.342  22.335  67.501  1.00  0.00           C  
ATOM   2521  CG  ARG A 163      24.383  23.469  67.814  1.00  0.00           C  
ATOM   2522  CD  ARG A 163      24.594  24.003  69.221  1.00  0.00           C  
ATOM   2523  NE  ARG A 163      24.420  22.963  70.233  1.00  0.00           N  
ATOM   2524  CZ  ARG A 163      24.565  23.175  71.539  1.00  0.00           C  
ATOM   2525  NH1 ARG A 163      24.877  24.383  71.989  1.00  0.00           N  
ATOM   2526  NH2 ARG A 163      24.399  22.177  72.395  1.00  0.00           N  
ATOM   2527  H   ARG A 163      26.950  20.622  66.373  1.00  0.00           H  
ATOM   2528  HA  ARG A 163      24.203  21.466  65.907  1.00  0.00           H  
ATOM   2529  HB2 ARG A 163      25.150  21.528  68.191  1.00  0.00           H  
ATOM   2530  HB3 ARG A 163      26.350  22.692  67.650  1.00  0.00           H  
ATOM   2531  HG2 ARG A 163      24.542  24.270  67.109  1.00  0.00           H  
ATOM   2532  HG3 ARG A 163      23.369  23.106  67.726  1.00  0.00           H  
ATOM   2533  HD2 ARG A 163      25.595  24.399  69.296  1.00  0.00           H  
ATOM   2534  HD3 ARG A 163      23.880  24.793  69.404  1.00  0.00           H  
ATOM   2535  HE  ARG A 163      24.186  22.064  69.926  1.00  0.00           H  
ATOM   2536 HH11 ARG A 163      25.002  25.140  71.346  1.00  0.00           H  
ATOM   2537 HH12 ARG A 163      24.985  24.539  72.971  1.00  0.00           H  
ATOM   2538 HH21 ARG A 163      24.163  21.265  72.061  1.00  0.00           H  
ATOM   2539 HH22 ARG A 163      24.509  22.335  73.377  1.00  0.00           H  
ATOM   2540  N   ASP A 164      24.500  23.527  64.526  1.00  0.00           N  
ATOM   2541  CA  ASP A 164      24.675  24.601  63.556  1.00  0.00           C  
ATOM   2542  C   ASP A 164      25.048  25.907  64.252  1.00  0.00           C  
ATOM   2543  O   ASP A 164      24.599  26.176  65.366  1.00  0.00           O  
ATOM   2544  CB  ASP A 164      23.397  24.792  62.733  1.00  0.00           C  
ATOM   2545  CG  ASP A 164      23.021  23.550  61.946  1.00  0.00           C  
ATOM   2546  OD1 ASP A 164      23.762  22.547  62.026  1.00  0.00           O  
ATOM   2547  OD2 ASP A 164      21.987  23.583  61.249  1.00  0.00           O  
ATOM   2548  H   ASP A 164      23.593  23.257  64.781  1.00  0.00           H  
ATOM   2549  HA  ASP A 164      25.480  24.320  62.893  1.00  0.00           H  
ATOM   2550  HB2 ASP A 164      22.581  25.033  63.398  1.00  0.00           H  
ATOM   2551  HB3 ASP A 164      23.542  25.606  62.039  1.00  0.00           H  
ATOM   2552  N   ALA A 165      25.871  26.712  63.587  1.00  0.00           N  
ATOM   2553  CA  ALA A 165      26.307  27.988  64.142  1.00  0.00           C  
ATOM   2554  C   ALA A 165      25.135  28.953  64.282  1.00  0.00           C  
ATOM   2555  O   ALA A 165      24.068  28.738  63.706  1.00  0.00           O  
ATOM   2556  CB  ALA A 165      27.394  28.598  63.270  1.00  0.00           C  
ATOM   2557  H   ALA A 165      26.196  26.440  62.702  1.00  0.00           H  
ATOM   2558  HA  ALA A 165      26.725  27.801  65.120  1.00  0.00           H  
ATOM   2559  HB1 ALA A 165      28.243  28.862  63.884  1.00  0.00           H  
ATOM   2560  HB2 ALA A 165      27.013  29.485  62.784  1.00  0.00           H  
ATOM   2561  HB3 ALA A 165      27.701  27.882  62.522  1.00  0.00           H  
ATOM   2562  N   LEU A 166      25.342  30.019  65.050  1.00  0.00           N  
ATOM   2563  CA  LEU A 166      24.304  31.021  65.268  1.00  0.00           C  
ATOM   2564  C   LEU A 166      24.448  32.185  64.292  1.00  0.00           C  
ATOM   2565  O   LEU A 166      23.566  33.038  64.195  1.00  0.00           O  
ATOM   2566  CB  LEU A 166      24.344  31.521  66.719  1.00  0.00           C  
ATOM   2567  CG  LEU A 166      25.718  31.975  67.230  1.00  0.00           C  
ATOM   2568  CD1 LEU A 166      26.147  33.277  66.572  1.00  0.00           C  
ATOM   2569  CD2 LEU A 166      25.695  32.126  68.743  1.00  0.00           C  
ATOM   2570  H   LEU A 166      26.214  30.135  65.482  1.00  0.00           H  
ATOM   2571  HA  LEU A 166      23.351  30.544  65.093  1.00  0.00           H  
ATOM   2572  HB2 LEU A 166      23.661  32.352  66.806  1.00  0.00           H  
ATOM   2573  HB3 LEU A 166      23.994  30.725  67.358  1.00  0.00           H  
ATOM   2574  HG  LEU A 166      26.451  31.221  66.982  1.00  0.00           H  
ATOM   2575 HD11 LEU A 166      26.890  33.072  65.816  1.00  0.00           H  
ATOM   2576 HD12 LEU A 166      26.565  33.938  67.318  1.00  0.00           H  
ATOM   2577 HD13 LEU A 166      25.288  33.749  66.115  1.00  0.00           H  
ATOM   2578 HD21 LEU A 166      26.156  31.262  69.198  1.00  0.00           H  
ATOM   2579 HD22 LEU A 166      24.672  32.206  69.081  1.00  0.00           H  
ATOM   2580 HD23 LEU A 166      26.239  33.016  69.025  1.00  0.00           H  
ATOM   2581  N   GLY A 167      25.567  32.213  63.574  1.00  0.00           N  
ATOM   2582  CA  GLY A 167      25.807  33.276  62.615  1.00  0.00           C  
ATOM   2583  C   GLY A 167      27.275  33.638  62.501  1.00  0.00           C  
ATOM   2584  O   GLY A 167      28.030  33.510  63.466  1.00  0.00           O  
ATOM   2585  H   GLY A 167      26.234  31.504  63.693  1.00  0.00           H  
ATOM   2586  HA2 GLY A 167      25.451  32.959  61.646  1.00  0.00           H  
ATOM   2587  HA3 GLY A 167      25.255  34.152  62.921  1.00  0.00           H  
ATOM   2588  N   LEU A 168      27.681  34.090  61.319  1.00  0.00           N  
ATOM   2589  CA  LEU A 168      29.067  34.473  61.079  1.00  0.00           C  
ATOM   2590  C   LEU A 168      29.235  35.986  61.154  1.00  0.00           C  
ATOM   2591  O   LEU A 168      28.394  36.739  60.663  1.00  0.00           O  
ATOM   2592  CB  LEU A 168      29.532  33.964  59.710  1.00  0.00           C  
ATOM   2593  CG  LEU A 168      29.519  32.444  59.542  1.00  0.00           C  
ATOM   2594  CD1 LEU A 168      29.927  32.062  58.126  1.00  0.00           C  
ATOM   2595  CD2 LEU A 168      30.443  31.785  60.557  1.00  0.00           C  
ATOM   2596  H   LEU A 168      27.031  34.169  60.589  1.00  0.00           H  
ATOM   2597  HA  LEU A 168      29.674  34.017  61.846  1.00  0.00           H  
ATOM   2598  HB2 LEU A 168      28.891  34.396  58.955  1.00  0.00           H  
ATOM   2599  HB3 LEU A 168      30.540  34.314  59.545  1.00  0.00           H  
ATOM   2600  HG  LEU A 168      28.518  32.078  59.710  1.00  0.00           H  
ATOM   2601 HD11 LEU A 168      30.427  31.105  58.142  1.00  0.00           H  
ATOM   2602 HD12 LEU A 168      30.597  32.810  57.731  1.00  0.00           H  
ATOM   2603 HD13 LEU A 168      29.047  31.999  57.504  1.00  0.00           H  
ATOM   2604 HD21 LEU A 168      31.106  32.527  60.974  1.00  0.00           H  
ATOM   2605 HD22 LEU A 168      31.021  31.015  60.070  1.00  0.00           H  
ATOM   2606 HD23 LEU A 168      29.852  31.346  61.346  1.00  0.00           H  
ATOM   2607  N   VAL A 169      30.327  36.423  61.771  1.00  0.00           N  
ATOM   2608  CA  VAL A 169      30.613  37.846  61.911  1.00  0.00           C  
ATOM   2609  C   VAL A 169      31.823  38.243  61.075  1.00  0.00           C  
ATOM   2610  O   VAL A 169      32.729  37.437  60.855  1.00  0.00           O  
ATOM   2611  CB  VAL A 169      30.865  38.224  63.383  1.00  0.00           C  
ATOM   2612  CG1 VAL A 169      29.640  37.920  64.231  1.00  0.00           C  
ATOM   2613  CG2 VAL A 169      32.087  37.492  63.922  1.00  0.00           C  
ATOM   2614  H   VAL A 169      30.961  35.771  62.139  1.00  0.00           H  
ATOM   2615  HA  VAL A 169      29.750  38.395  61.562  1.00  0.00           H  
ATOM   2616  HB  VAL A 169      31.056  39.285  63.436  1.00  0.00           H  
ATOM   2617 HG11 VAL A 169      28.896  38.688  64.079  1.00  0.00           H  
ATOM   2618 HG12 VAL A 169      29.921  37.894  65.274  1.00  0.00           H  
ATOM   2619 HG13 VAL A 169      29.231  36.963  63.946  1.00  0.00           H  
ATOM   2620 HG21 VAL A 169      32.779  37.305  63.115  1.00  0.00           H  
ATOM   2621 HG22 VAL A 169      31.780  36.552  64.359  1.00  0.00           H  
ATOM   2622 HG23 VAL A 169      32.566  38.099  64.676  1.00  0.00           H  
ATOM   2623  N   ASP A 170      31.837  39.488  60.607  1.00  0.00           N  
ATOM   2624  CA  ASP A 170      32.941  39.985  59.794  1.00  0.00           C  
ATOM   2625  C   ASP A 170      33.033  41.506  59.860  1.00  0.00           C  
ATOM   2626  O   ASP A 170      32.046  42.186  60.146  1.00  0.00           O  
ATOM   2627  CB  ASP A 170      32.773  39.532  58.342  1.00  0.00           C  
ATOM   2628  CG  ASP A 170      31.459  39.990  57.738  1.00  0.00           C  
ATOM   2629  OD1 ASP A 170      31.234  41.215  57.661  1.00  0.00           O  
ATOM   2630  OD2 ASP A 170      30.653  39.121  57.340  1.00  0.00           O  
ATOM   2631  H   ASP A 170      31.089  40.085  60.815  1.00  0.00           H  
ATOM   2632  HA  ASP A 170      33.855  39.565  60.188  1.00  0.00           H  
ATOM   2633  HB2 ASP A 170      33.579  39.937  57.749  1.00  0.00           H  
ATOM   2634  HB3 ASP A 170      32.810  38.453  58.302  1.00  0.00           H  
ATOM   2635  N   ASN A 171      34.224  42.032  59.594  1.00  0.00           N  
ATOM   2636  CA  ASN A 171      34.451  43.471  59.622  1.00  0.00           C  
ATOM   2637  C   ASN A 171      34.438  44.045  58.208  1.00  0.00           C  
ATOM   2638  O   ASN A 171      33.754  45.032  57.934  1.00  0.00           O  
ATOM   2639  CB  ASN A 171      35.789  43.781  60.300  1.00  0.00           C  
ATOM   2640  CG  ASN A 171      36.037  45.270  60.482  1.00  0.00           C  
ATOM   2641  OD1 ASN A 171      37.111  45.676  60.928  1.00  0.00           O  
ATOM   2642  ND2 ASN A 171      35.048  46.094  60.154  1.00  0.00           N  
ATOM   2643  H   ASN A 171      34.969  41.435  59.372  1.00  0.00           H  
ATOM   2644  HA  ASN A 171      33.653  43.924  60.191  1.00  0.00           H  
ATOM   2645  HB2 ASN A 171      35.804  43.314  61.273  1.00  0.00           H  
ATOM   2646  HB3 ASN A 171      36.589  43.373  59.699  1.00  0.00           H  
ATOM   2647 HD21 ASN A 171      34.214  45.709  59.813  1.00  0.00           H  
ATOM   2648 HD22 ASN A 171      35.193  47.058  60.265  1.00  0.00           H  
ATOM   2649  N   GLY A 172      35.198  43.419  57.314  1.00  0.00           N  
ATOM   2650  CA  GLY A 172      35.259  43.881  55.940  1.00  0.00           C  
ATOM   2651  C   GLY A 172      36.447  44.785  55.685  1.00  0.00           C  
ATOM   2652  O   GLY A 172      37.290  44.977  56.563  1.00  0.00           O  
ATOM   2653  H   GLY A 172      35.720  42.638  57.591  1.00  0.00           H  
ATOM   2654  HA2 GLY A 172      35.328  43.022  55.286  1.00  0.00           H  
ATOM   2655  HA3 GLY A 172      34.352  44.421  55.712  1.00  0.00           H  
ATOM   2656  N   SER A 173      36.514  45.344  54.481  1.00  0.00           N  
ATOM   2657  CA  SER A 173      37.610  46.234  54.111  1.00  0.00           C  
ATOM   2658  C   SER A 173      37.220  47.111  52.927  1.00  0.00           C  
ATOM   2659  O   SER A 173      36.146  46.951  52.348  1.00  0.00           O  
ATOM   2660  CB  SER A 173      38.858  45.421  53.769  1.00  0.00           C  
ATOM   2661  OG  SER A 173      38.617  44.550  52.677  1.00  0.00           O  
ATOM   2662  H   SER A 173      35.814  45.152  53.826  1.00  0.00           H  
ATOM   2663  HA  SER A 173      37.825  46.868  54.960  1.00  0.00           H  
ATOM   2664  HB2 SER A 173      39.663  46.091  53.508  1.00  0.00           H  
ATOM   2665  HB3 SER A 173      39.147  44.831  54.627  1.00  0.00           H  
ATOM   2666  HG  SER A 173      39.060  44.889  51.895  1.00  0.00           H  
ATOM   2667  N   ASN A 174      38.102  48.043  52.574  1.00  0.00           N  
ATOM   2668  CA  ASN A 174      37.852  48.951  51.459  1.00  0.00           C  
ATOM   2669  C   ASN A 174      38.917  48.795  50.380  1.00  0.00           C  
ATOM   2670  O   ASN A 174      39.782  47.925  50.468  1.00  0.00           O  
ATOM   2671  CB  ASN A 174      37.818  50.398  51.950  1.00  0.00           C  
ATOM   2672  CG  ASN A 174      36.759  50.626  53.011  1.00  0.00           C  
ATOM   2673  OD1 ASN A 174      35.568  50.421  52.770  1.00  0.00           O  
ATOM   2674  ND2 ASN A 174      37.188  51.052  54.192  1.00  0.00           N  
ATOM   2675  H   ASN A 174      38.941  48.123  53.076  1.00  0.00           H  
ATOM   2676  HA  ASN A 174      36.890  48.700  51.037  1.00  0.00           H  
ATOM   2677  HB2 ASN A 174      38.780  50.651  52.371  1.00  0.00           H  
ATOM   2678  HB3 ASN A 174      37.611  51.050  51.115  1.00  0.00           H  
ATOM   2679 HD21 ASN A 174      38.149  51.196  54.312  1.00  0.00           H  
ATOM   2680 HD22 ASN A 174      36.526  51.209  54.898  1.00  0.00           H  
ATOM   2681  N   GLN A 175      38.850  49.650  49.364  1.00  0.00           N  
ATOM   2682  CA  GLN A 175      39.810  49.612  48.267  1.00  0.00           C  
ATOM   2683  C   GLN A 175      40.856  50.710  48.425  1.00  0.00           C  
ATOM   2684  O   GLN A 175      40.565  51.891  48.235  1.00  0.00           O  
ATOM   2685  CB  GLN A 175      39.091  49.764  46.925  1.00  0.00           C  
ATOM   2686  CG  GLN A 175      40.025  49.709  45.726  1.00  0.00           C  
ATOM   2687  CD  GLN A 175      39.293  49.872  44.410  1.00  0.00           C  
ATOM   2688  OE1 GLN A 175      38.638  50.889  44.171  1.00  0.00           O  
ATOM   2689  NE2 GLN A 175      39.399  48.869  43.546  1.00  0.00           N  
ATOM   2690  H   GLN A 175      38.138  50.323  49.353  1.00  0.00           H  
ATOM   2691  HA  GLN A 175      40.305  48.653  48.293  1.00  0.00           H  
ATOM   2692  HB2 GLN A 175      38.366  48.970  46.825  1.00  0.00           H  
ATOM   2693  HB3 GLN A 175      38.578  50.713  46.909  1.00  0.00           H  
ATOM   2694  HG2 GLN A 175      40.752  50.502  45.816  1.00  0.00           H  
ATOM   2695  HG3 GLN A 175      40.531  48.755  45.725  1.00  0.00           H  
ATOM   2696 HE21 GLN A 175      39.935  48.091  43.802  1.00  0.00           H  
ATOM   2697 HE22 GLN A 175      38.934  48.950  42.685  1.00  0.00           H  
ATOM   2698  N   VAL A 176      42.076  50.314  48.773  1.00  0.00           N  
ATOM   2699  CA  VAL A 176      43.166  51.262  48.958  1.00  0.00           C  
ATOM   2700  C   VAL A 176      44.396  50.858  48.150  1.00  0.00           C  
ATOM   2701  O   VAL A 176      44.720  49.674  48.044  1.00  0.00           O  
ATOM   2702  CB  VAL A 176      43.556  51.390  50.443  1.00  0.00           C  
ATOM   2703  CG1 VAL A 176      42.398  51.957  51.250  1.00  0.00           C  
ATOM   2704  CG2 VAL A 176      43.990  50.043  51.001  1.00  0.00           C  
ATOM   2705  H   VAL A 176      42.247  49.358  48.910  1.00  0.00           H  
ATOM   2706  HA  VAL A 176      42.826  52.228  48.613  1.00  0.00           H  
ATOM   2707  HB  VAL A 176      44.387  52.073  50.521  1.00  0.00           H  
ATOM   2708 HG11 VAL A 176      42.133  51.265  52.033  1.00  0.00           H  
ATOM   2709 HG12 VAL A 176      41.547  52.110  50.601  1.00  0.00           H  
ATOM   2710 HG13 VAL A 176      42.691  52.900  51.687  1.00  0.00           H  
ATOM   2711 HG21 VAL A 176      44.163  50.132  52.063  1.00  0.00           H  
ATOM   2712 HG22 VAL A 176      44.899  49.728  50.514  1.00  0.00           H  
ATOM   2713 HG23 VAL A 176      43.214  49.312  50.823  1.00  0.00           H  
ATOM   2714  N   ILE A 177      45.073  51.850  47.585  1.00  0.00           N  
ATOM   2715  CA  ILE A 177      46.269  51.602  46.787  1.00  0.00           C  
ATOM   2716  C   ILE A 177      47.459  52.387  47.333  1.00  0.00           C  
ATOM   2717  O   ILE A 177      47.364  53.591  47.576  1.00  0.00           O  
ATOM   2718  CB  ILE A 177      46.044  51.971  45.304  1.00  0.00           C  
ATOM   2719  CG1 ILE A 177      47.310  51.713  44.483  1.00  0.00           C  
ATOM   2720  CG2 ILE A 177      45.606  53.424  45.175  1.00  0.00           C  
ATOM   2721  CD1 ILE A 177      47.723  50.257  44.441  1.00  0.00           C  
ATOM   2722  H   ILE A 177      44.764  52.771  47.706  1.00  0.00           H  
ATOM   2723  HA  ILE A 177      46.491  50.546  46.842  1.00  0.00           H  
ATOM   2724  HB  ILE A 177      45.246  51.350  44.923  1.00  0.00           H  
ATOM   2725 HG12 ILE A 177      47.144  52.038  43.466  1.00  0.00           H  
ATOM   2726 HG13 ILE A 177      48.127  52.280  44.908  1.00  0.00           H  
ATOM   2727 HG21 ILE A 177      46.357  54.066  45.611  1.00  0.00           H  
ATOM   2728 HG22 ILE A 177      44.667  53.563  45.690  1.00  0.00           H  
ATOM   2729 HG23 ILE A 177      45.484  53.670  44.130  1.00  0.00           H  
ATOM   2730 HD11 ILE A 177      48.795  50.184  44.537  1.00  0.00           H  
ATOM   2731 HD12 ILE A 177      47.415  49.821  43.501  1.00  0.00           H  
ATOM   2732 HD13 ILE A 177      47.251  49.726  45.255  1.00  0.00           H  
ATOM   2733  N   GLU A 178      48.577  51.696  47.529  1.00  0.00           N  
ATOM   2734  CA  GLU A 178      49.782  52.326  48.051  1.00  0.00           C  
ATOM   2735  C   GLU A 178      51.002  51.939  47.222  1.00  0.00           C  
ATOM   2736  O   GLU A 178      51.130  50.795  46.786  1.00  0.00           O  
ATOM   2737  CB  GLU A 178      49.995  51.931  49.514  1.00  0.00           C  
ATOM   2738  CG  GLU A 178      51.210  52.584  50.156  1.00  0.00           C  
ATOM   2739  CD  GLU A 178      51.396  52.179  51.606  1.00  0.00           C  
ATOM   2740  OE1 GLU A 178      50.577  51.383  52.111  1.00  0.00           O  
ATOM   2741  OE2 GLU A 178      52.362  52.658  52.237  1.00  0.00           O  
ATOM   2742  H   GLU A 178      48.590  50.738  47.319  1.00  0.00           H  
ATOM   2743  HA  GLU A 178      49.649  53.396  47.993  1.00  0.00           H  
ATOM   2744  HB2 GLU A 178      49.121  52.214  50.082  1.00  0.00           H  
ATOM   2745  HB3 GLU A 178      50.117  50.858  49.571  1.00  0.00           H  
ATOM   2746  HG2 GLU A 178      52.091  52.295  49.601  1.00  0.00           H  
ATOM   2747  HG3 GLU A 178      51.093  53.657  50.108  1.00  0.00           H  
ATOM   2748  N   GLY A 179      51.896  52.899  47.011  1.00  0.00           N  
ATOM   2749  CA  GLY A 179      53.096  52.641  46.236  1.00  0.00           C  
ATOM   2750  C   GLY A 179      54.072  53.799  46.283  1.00  0.00           C  
ATOM   2751  O   GLY A 179      55.170  53.670  46.826  1.00  0.00           O  
ATOM   2752  H   GLY A 179      51.738  53.791  47.384  1.00  0.00           H  
ATOM   2753  HA2 GLY A 179      53.579  51.759  46.625  1.00  0.00           H  
ATOM   2754  HA3 GLY A 179      52.815  52.463  45.207  1.00  0.00           H  
ATOM   2755  N   TYR A 180      53.675  54.931  45.713  1.00  0.00           N  
ATOM   2756  CA  TYR A 180      54.524  56.118  45.693  1.00  0.00           C  
ATOM   2757  C   TYR A 180      54.159  57.064  46.830  1.00  0.00           C  
ATOM   2758  O   TYR A 180      54.898  57.999  47.135  1.00  0.00           O  
ATOM   2759  CB  TYR A 180      54.404  56.843  44.350  1.00  0.00           C  
ATOM   2760  CG  TYR A 180      54.948  56.058  43.173  1.00  0.00           C  
ATOM   2761  CD1 TYR A 180      54.474  54.785  42.877  1.00  0.00           C  
ATOM   2762  CD2 TYR A 180      55.934  56.597  42.356  1.00  0.00           C  
ATOM   2763  CE1 TYR A 180      54.971  54.071  41.802  1.00  0.00           C  
ATOM   2764  CE2 TYR A 180      56.434  55.889  41.279  1.00  0.00           C  
ATOM   2765  CZ  TYR A 180      55.948  54.628  41.009  1.00  0.00           C  
ATOM   2766  OH  TYR A 180      56.446  53.920  39.937  1.00  0.00           O  
ATOM   2767  H   TYR A 180      52.789  54.971  45.296  1.00  0.00           H  
ATOM   2768  HA  TYR A 180      55.546  55.794  45.825  1.00  0.00           H  
ATOM   2769  HB2 TYR A 180      53.363  57.050  44.154  1.00  0.00           H  
ATOM   2770  HB3 TYR A 180      54.944  57.778  44.405  1.00  0.00           H  
ATOM   2771  HD1 TYR A 180      53.708  54.352  43.503  1.00  0.00           H  
ATOM   2772  HD2 TYR A 180      56.312  57.584  42.571  1.00  0.00           H  
ATOM   2773  HE1 TYR A 180      54.592  53.083  41.591  1.00  0.00           H  
ATOM   2774  HE2 TYR A 180      57.200  56.325  40.657  1.00  0.00           H  
ATOM   2775  HH  TYR A 180      55.728  53.457  39.498  1.00  0.00           H  
ATOM   2776  N   PHE A 181      53.011  56.814  47.454  1.00  0.00           N  
ATOM   2777  CA  PHE A 181      52.545  57.643  48.559  1.00  0.00           C  
ATOM   2778  C   PHE A 181      52.600  56.874  49.875  1.00  0.00           C  
ATOM   2779  O   PHE A 181      52.224  55.705  49.939  1.00  0.00           O  
ATOM   2780  CB  PHE A 181      51.114  58.123  48.292  1.00  0.00           C  
ATOM   2781  CG  PHE A 181      50.556  58.995  49.382  1.00  0.00           C  
ATOM   2782  CD1 PHE A 181      51.257  60.103  49.834  1.00  0.00           C  
ATOM   2783  CD2 PHE A 181      49.324  58.711  49.949  1.00  0.00           C  
ATOM   2784  CE1 PHE A 181      50.742  60.905  50.833  1.00  0.00           C  
ATOM   2785  CE2 PHE A 181      48.803  59.511  50.947  1.00  0.00           C  
ATOM   2786  CZ  PHE A 181      49.514  60.610  51.390  1.00  0.00           C  
ATOM   2787  H   PHE A 181      52.466  56.053  47.164  1.00  0.00           H  
ATOM   2788  HA  PHE A 181      53.196  58.500  48.628  1.00  0.00           H  
ATOM   2789  HB2 PHE A 181      51.100  58.691  47.373  1.00  0.00           H  
ATOM   2790  HB3 PHE A 181      50.469  57.264  48.189  1.00  0.00           H  
ATOM   2791  HD1 PHE A 181      52.218  60.334  49.400  1.00  0.00           H  
ATOM   2792  HD2 PHE A 181      48.768  57.851  49.605  1.00  0.00           H  
ATOM   2793  HE1 PHE A 181      51.299  61.764  51.179  1.00  0.00           H  
ATOM   2794  HE2 PHE A 181      47.842  59.278  51.381  1.00  0.00           H  
ATOM   2795  HZ  PHE A 181      49.108  61.237  52.171  1.00  0.00           H  
ATOM   2796  N   LYS A 182      53.073  57.541  50.924  1.00  0.00           N  
ATOM   2797  CA  LYS A 182      53.178  56.924  52.241  1.00  0.00           C  
ATOM   2798  C   LYS A 182      52.993  57.961  53.343  1.00  0.00           C  
ATOM   2799  O   LYS A 182      52.487  57.591  54.424  1.00  0.00           O  
ATOM   2800  CB  LYS A 182      54.532  56.221  52.405  1.00  0.00           C  
ATOM   2801  CG  LYS A 182      55.734  57.158  52.364  1.00  0.00           C  
ATOM   2802  CD  LYS A 182      55.972  57.717  50.971  1.00  0.00           C  
ATOM   2803  CE  LYS A 182      57.172  58.650  50.941  1.00  0.00           C  
ATOM   2804  NZ  LYS A 182      57.424  59.191  49.576  1.00  0.00           N  
ATOM   2805  H   LYS A 182      53.357  58.473  50.809  1.00  0.00           H  
ATOM   2806  HA  LYS A 182      52.391  56.190  52.322  1.00  0.00           H  
ATOM   2807  HB2 LYS A 182      54.541  55.705  53.353  1.00  0.00           H  
ATOM   2808  HB3 LYS A 182      54.643  55.496  51.613  1.00  0.00           H  
ATOM   2809  HG2 LYS A 182      55.560  57.978  53.044  1.00  0.00           H  
ATOM   2810  HG3 LYS A 182      56.612  56.611  52.678  1.00  0.00           H  
ATOM   2811  HD2 LYS A 182      56.149  56.898  50.290  1.00  0.00           H  
ATOM   2812  HD3 LYS A 182      55.094  58.263  50.658  1.00  0.00           H  
ATOM   2813  HE2 LYS A 182      56.988  59.473  51.616  1.00  0.00           H  
ATOM   2814  HE3 LYS A 182      58.045  58.104  51.270  1.00  0.00           H  
ATOM   2815  HZ1 LYS A 182      58.426  59.445  49.473  1.00  0.00           H  
ATOM   2816  HZ2 LYS A 182      56.842  60.038  49.414  1.00  0.00           H  
ATOM   2817  HZ3 LYS A 182      57.181  58.477  48.858  1.00  0.00           H  
TER    2818      LYS A 182                                                      
END
MOLECULE T0510_166_234.pdb
ATOM   1246  N   GLN   166      63.833  26.217  70.711  1.00 82.23           N  
ATOM   1247  CA  GLN   166      64.911  26.599  69.853  1.00 82.71           C  
ATOM   1248  CB  GLN   166      64.584  26.346  68.391  1.00 83.43           C  
ATOM   1249  CG  GLN   166      65.557  27.031  67.420  1.00 84.04           C  
ATOM   1250  CD  GLN   166      66.187  26.085  66.393  1.00 85.23           C  
ATOM   1251  OE1 GLN   166      66.303  26.427  65.214  1.00 89.14           O  
ATOM   1252  NE2 GLN   166      66.606  24.903  66.842  1.00 86.32           N  
ATOM   1253  C   GLN   166      65.103  28.059  70.110  1.00 82.10           C  
ATOM   1254  O   GLN   166      65.514  28.802  69.254  1.00 82.11           O  
ATOM   1255  N   HIS   167      64.799  28.492  71.309  1.00 81.41           N  
ATOM   1256  CA  HIS   167      64.931  29.894  71.548  1.00 79.88           C  
ATOM   1257  CB  HIS   167      66.393  30.283  71.564  1.00 81.38           C  
ATOM   1258  C   HIS   167      64.271  30.536  70.371  1.00 75.02           C  
ATOM   1259  O   HIS   167      64.921  31.013  69.465  1.00 74.94           O  
ATOM   1260  N   LYS   168      62.956  30.528  70.391  1.00 69.80           N  
ATOM   1261  CA  LYS   168      62.182  31.163  69.375  1.00 65.51           C  
ATOM   1262  CB  LYS   168      60.985  30.305  69.049  1.00 65.08           C  
ATOM   1263  CG  LYS   168      61.320  29.019  68.389  1.00 63.18           C  
ATOM   1264  CD  LYS   168      60.253  28.638  67.420  1.00 61.15           C  
ATOM   1265  CE  LYS   168      60.114  27.171  67.291  1.00 59.96           C  
ATOM   1266  NZ  LYS   168      60.476  26.681  65.970  1.00 54.43           N  
ATOM   1267  C   LYS   168      61.736  32.456  69.982  1.00 64.26           C  
ATOM   1268  O   LYS   168      62.017  32.714  71.123  1.00 63.98           O  
ATOM   1269  N   ILE   169      61.045  33.277  69.213  1.00 61.69           N  
ATOM   1270  CA  ILE   169      60.585  34.551  69.694  1.00 60.60           C  
ATOM   1271  CB  ILE   169      61.019  35.662  68.791  1.00 60.03           C  
ATOM   1272  CG1 ILE   169      62.522  35.759  68.786  1.00 59.71           C  
ATOM   1273  CD1 ILE   169      63.129  35.486  67.475  1.00 60.27           C  
ATOM   1274  CG2 ILE   169      60.500  36.941  69.296  1.00 59.13           C  
ATOM   1275  C   ILE   169      59.089  34.560  69.755  1.00 59.72           C  
ATOM   1276  O   ILE   169      58.438  33.855  69.027  1.00 59.04           O  
ATOM   1277  N   ASN   170      58.549  35.351  70.660  1.00 58.73           N  
ATOM   1278  CA  ASN   170      57.110  35.466  70.808  1.00 58.04           C  
ATOM   1279  CB  ASN   170      56.689  35.815  72.249  1.00 57.08           C  
ATOM   1280  CG  ASN   170      55.149  35.728  72.485  1.00 58.65           C  
ATOM   1281  OD1 ASN   170      54.316  36.116  71.650  1.00 62.59           O  
ATOM   1282  ND2 ASN   170      54.776  35.201  73.630  1.00 60.85           N  
ATOM   1283  C   ASN   170      56.633  36.520  69.770  1.00 57.38           C  
ATOM   1284  O   ASN   170      56.973  37.717  69.840  1.00 56.01           O  
ATOM   1285  N   PRO   171      55.849  36.056  68.789  1.00 56.90           N  
ATOM   1286  CA  PRO   171      55.367  36.937  67.802  1.00 57.10           C  
ATOM   1287  CB  PRO   171      54.419  36.076  66.990  1.00 56.60           C  
ATOM   1288  CG  PRO   171      54.150  34.955  67.780  1.00 57.11           C  
ATOM   1289  CD  PRO   171      55.364  34.698  68.538  1.00 57.22           C  
ATOM   1290  C   PRO   171      54.626  38.081  68.399  1.00 57.21           C  
ATOM   1291  O   PRO   171      54.505  39.109  67.740  1.00 59.25           O  
ATOM   1292  N   TYR   172      54.119  37.963  69.612  1.00 56.42           N  
ATOM   1293  CA  TYR   172      53.460  39.126  70.161  1.00 55.94           C  
ATOM   1294  CB  TYR   172      52.469  38.742  71.225  1.00 55.58           C  
ATOM   1295  CG  TYR   172      51.335  38.012  70.645  1.00 54.93           C  
ATOM   1296  CD1 TYR   172      50.325  38.713  69.986  1.00 56.22           C  
ATOM   1297  CE1 TYR   172      49.269  38.079  69.383  1.00 55.35           C  
ATOM   1298  CZ  TYR   172      49.197  36.714  69.449  1.00 56.18           C  
ATOM   1299  OH  TYR   172      48.134  36.123  68.864  1.00 55.80           O  
ATOM   1300  CE2 TYR   172      50.177  35.961  70.112  1.00 56.67           C  
ATOM   1301  CD2 TYR   172      51.256  36.632  70.713  1.00 55.81           C  
ATOM   1302  C   TYR   172      54.440  40.143  70.678  1.00 56.09           C  
ATOM   1303  O   TYR   172      54.041  41.229  70.922  1.00 56.96           O  
ATOM   1304  N   ASP   173      55.722  39.824  70.827  1.00 56.70           N  
ATOM   1305  CA  ASP   173      56.677  40.762  71.464  1.00 56.94           C  
ATOM   1306  CB  ASP   173      57.619  39.987  72.378  1.00 57.07           C  
ATOM   1307  CG  ASP   173      56.891  39.343  73.584  1.00 59.70           C  
ATOM   1308  OD1 ASP   173      55.715  39.682  73.957  1.00 60.73           O  
ATOM   1309  OD2 ASP   173      57.534  38.458  74.189  1.00 64.57           O  
ATOM   1310  C   ASP   173      57.504  41.542  70.452  1.00 57.10           C  
ATOM   1311  O   ASP   173      58.517  42.160  70.764  1.00 56.92           O  
ATOM   1312  N   ILE   174      57.061  41.519  69.208  1.00 57.50           N  
ATOM   1313  CA  ILE   174      57.918  41.926  68.107  1.00 56.84           C  
ATOM   1314  CB  ILE   174      58.589  40.690  67.518  1.00 56.70           C  
ATOM   1315  CG1 ILE   174      59.599  41.092  66.467  1.00 57.77           C  
ATOM   1316  CD1 ILE   174      60.661  40.028  66.250  1.00 57.91           C  
ATOM   1317  CG2 ILE   174      57.544  39.699  66.969  1.00 55.22           C  
ATOM   1318  C   ILE   174      57.023  42.643  67.120  1.00 56.45           C  
ATOM   1319  O   ILE   174      55.813  42.344  67.064  1.00 56.87           O  
ATOM   1320  N   THR   175      57.575  43.650  66.447  1.00 55.75           N  
ATOM   1321  CA  THR   175      56.850  44.351  65.389  1.00 55.67           C  
ATOM   1322  CB  THR   175      57.084  45.848  65.362  1.00 55.12           C  
ATOM   1323  OG1 THR   175      58.475  46.140  65.204  1.00 51.68           O  
ATOM   1324  CG2 THR   175      56.585  46.411  66.591  1.00 53.75           C  
ATOM   1325  C   THR   175      57.308  43.811  64.061  1.00 56.37           C  
ATOM   1326  O   THR   175      58.357  43.136  63.971  1.00 56.76           O  
ATOM   1327  N   GLY   176      56.532  44.115  63.029  1.00 55.97           N  
ATOM   1328  CA  GLY   176      56.877  43.622  61.697  1.00 55.00           C  
ATOM   1329  C   GLY   176      58.209  44.171  61.236  1.00 54.36           C  
ATOM   1330  O   GLY   176      59.011  43.437  60.620  1.00 53.31           O  
ATOM   1331  N   ALA   177      58.447  45.467  61.523  1.00 53.85           N  
ATOM   1332  CA  ALA   177      59.708  46.112  61.110  1.00 53.00           C  
ATOM   1333  CB  ALA   177      59.786  47.477  61.598  1.00 51.26           C  
ATOM   1334  C   ALA   177      60.852  45.297  61.675  1.00 53.34           C  
ATOM   1335  O   ALA   177      61.852  45.152  61.021  1.00 53.45           O  
ATOM   1336  N   GLU   178      60.654  44.743  62.890  1.00 53.75           N  
ATOM   1337  CA  GLU   178      61.667  44.026  63.674  1.00 53.30           C  
ATOM   1338  CB  GLU   178      61.261  43.985  65.162  1.00 54.23           C  
ATOM   1339  CG  GLU   178      61.696  45.215  65.982  1.00 55.75           C  
ATOM   1340  CD  GLU   178      60.861  45.500  67.251  1.00 55.56           C  
ATOM   1341  OE1 GLU   178      59.978  44.704  67.638  1.00 59.89           O  
ATOM   1342  OE2 GLU   178      61.094  46.567  67.857  1.00 58.55           O  
ATOM   1343  C   GLU   178      61.886  42.594  63.224  1.00 52.73           C  
ATOM   1344  O   GLU   178      63.013  42.111  63.291  1.00 53.74           O  
ATOM   1345  N   VAL   179      60.813  41.916  62.800  1.00 51.25           N  
ATOM   1346  CA  VAL   179      60.897  40.591  62.128  1.00 49.92           C  
ATOM   1347  CB  VAL   179      59.570  40.200  61.494  1.00 49.14           C  
ATOM   1348  CG1 VAL   179      59.636  38.784  61.000  1.00 49.19           C  
ATOM   1349  CG2 VAL   179      58.408  40.363  62.472  1.00 48.28           C  
ATOM   1350  C   VAL   179      61.975  40.492  61.036  1.00 48.85           C  
ATOM   1351  O   VAL   179      62.642  39.467  60.876  1.00 47.13           O  
ATOM   1352  N   LEU   180      62.169  41.579  60.302  1.00 49.16           N  
ATOM   1353  CA  LEU   180      63.079  41.552  59.170  1.00 49.72           C  
ATOM   1354  CB  LEU   180      63.224  42.904  58.525  1.00 47.84           C  
ATOM   1355  CG  LEU   180      61.920  43.407  57.910  1.00 46.38           C  
ATOM   1356  CD1 LEU   180      62.200  44.695  57.167  1.00 39.97           C  
ATOM   1357  CD2 LEU   180      61.195  42.326  57.003  1.00 40.86           C  
ATOM   1358  C   LEU   180      64.403  41.027  59.583  1.00 50.70           C  
ATOM   1359  O   LEU   180      64.941  40.181  58.908  1.00 50.63           O  
ATOM   1360  N   LYS   181      64.910  41.478  60.719  1.00 52.87           N  
ATOM   1361  CA  LYS   181      66.191  40.964  61.229  1.00 54.42           C  
ATOM   1362  CB  LYS   181      66.333  41.296  62.706  1.00 54.78           C  
ATOM   1363  CG  LYS   181      66.629  42.753  62.979  1.00 56.92           C  
ATOM   1364  CD  LYS   181      66.939  43.007  64.479  1.00 57.59           C  
ATOM   1365  CE  LYS   181      65.723  42.667  65.413  1.00 60.72           C  
ATOM   1366  NZ  LYS   181      64.692  43.742  65.242  1.00 63.49           N  
ATOM   1367  C   LYS   181      66.395  39.454  61.091  1.00 54.56           C  
ATOM   1368  O   LYS   181      67.513  38.992  60.961  1.00 53.84           O  
ATOM   1369  N   TYR   182      65.318  38.689  61.150  1.00 56.05           N  
ATOM   1370  CA  TYR   182      65.417  37.223  61.204  1.00 57.04           C  
ATOM   1371  CB  TYR   182      64.478  36.678  62.328  1.00 59.52           C  
ATOM   1372  CG  TYR   182      64.688  37.390  63.652  1.00 60.32           C  
ATOM   1373  CD1 TYR   182      65.790  37.088  64.436  1.00 61.47           C  
ATOM   1374  CE1 TYR   182      66.044  37.769  65.650  1.00 63.73           C  
ATOM   1375  CZ  TYR   182      65.181  38.784  66.088  1.00 64.96           C  
ATOM   1376  OH  TYR   182      65.488  39.453  67.297  1.00 62.03           O  
ATOM   1377  CE2 TYR   182      64.043  39.109  65.279  1.00 64.00           C  
ATOM   1378  CD2 TYR   182      63.811  38.402  64.084  1.00 62.05           C  
ATOM   1379  C   TYR   182      65.094  36.516  59.878  1.00 57.36           C  
ATOM   1380  O   TYR   182      64.900  35.300  59.881  1.00 57.75           O  
ATOM   1381  N   ILE   183      64.992  37.277  58.773  1.00 56.78           N  
ATOM   1382  CA  ILE   183      64.573  36.766  57.444  1.00 55.82           C  
ATOM   1383  CB  ILE   183      63.312  37.439  56.967  1.00 55.21           C  
ATOM   1384  CG1 ILE   183      62.159  37.146  57.930  1.00 54.19           C  
ATOM   1385  CD1 ILE   183      61.775  35.692  58.042  1.00 51.90           C  
ATOM   1386  CG2 ILE   183      63.034  36.990  55.548  1.00 55.52           C  
ATOM   1387  C   ILE   183      65.604  37.086  56.379  1.00 55.41           C  
ATOM   1388  O   ILE   183      65.993  38.241  56.234  1.00 55.89           O  
ATOM   1389  N   ASP   184      66.055  36.064  55.660  1.00 54.86           N  
ATOM   1390  CA  ASP   184      66.911  36.236  54.501  1.00 54.65           C  
ATOM   1391  CB  ASP   184      68.000  35.172  54.504  1.00 54.51           C  
ATOM   1392  CG  ASP   184      68.901  35.213  53.276  1.00 56.25           C  
ATOM   1393  OD1 ASP   184      68.569  35.845  52.234  1.00 60.63           O  
ATOM   1394  OD2 ASP   184      69.958  34.561  53.341  1.00 59.14           O  
ATOM   1395  C   ASP   184      65.980  36.099  53.285  1.00 54.37           C  
ATOM   1396  O   ASP   184      65.494  35.021  52.990  1.00 54.47           O  
ATOM   1397  N   PHE   185      65.689  37.193  52.602  1.00 53.46           N  
ATOM   1398  CA  PHE   185      64.734  37.104  51.528  1.00 53.40           C  
ATOM   1399  CB  PHE   185      64.352  38.502  51.076  1.00 53.07           C  
ATOM   1400  CG  PHE   185      63.298  39.126  51.909  1.00 52.32           C  
ATOM   1401  CD1 PHE   185      63.622  39.974  52.937  1.00 53.28           C  
ATOM   1402  CE1 PHE   185      62.621  40.550  53.704  1.00 53.55           C  
ATOM   1403  CZ  PHE   185      61.290  40.261  53.454  1.00 52.75           C  
ATOM   1404  CE2 PHE   185      60.965  39.413  52.458  1.00 52.74           C  
ATOM   1405  CD2 PHE   185      61.965  38.848  51.677  1.00 52.79           C  
ATOM   1406  C   PHE   185      65.292  36.261  50.366  1.00 53.48           C  
ATOM   1407  O   PHE   185      64.534  35.574  49.655  1.00 52.94           O  
ATOM   1408  N   ASN   186      66.620  36.289  50.214  1.00 53.44           N  
ATOM   1409  CA  ASN   186      67.276  35.505  49.190  1.00 53.70           C  
ATOM   1410  CB  ASN   186      68.763  35.846  49.068  1.00 53.36           C  
ATOM   1411  CG  ASN   186      69.053  37.329  49.045  1.00 52.80           C  
ATOM   1412  OD1 ASN   186      68.879  38.015  48.037  1.00 53.85           O  
ATOM   1413  ND2 ASN   186      69.581  37.816  50.143  1.00 50.90           N  
ATOM   1414  C   ASN   186      67.196  33.990  49.427  1.00 54.10           C  
ATOM   1415  O   ASN   186      67.575  33.221  48.548  1.00 53.83           O  
ATOM   1416  N   ALA   187      66.732  33.553  50.595  1.00 54.69           N  
ATOM   1417  CA  ALA   187      66.945  32.167  50.996  1.00 55.09           C  
ATOM   1418  CB  ALA   187      66.912  32.010  52.473  1.00 54.22           C  
ATOM   1419  C   ALA   187      66.025  31.153  50.271  1.00 56.70           C  
ATOM   1420  O   ALA   187      66.495  30.044  49.982  1.00 57.59           O  
ATOM   1421  N   GLY   188      64.731  31.410  50.058  1.00 57.62           N  
ATOM   1422  CA  GLY   188      63.853  31.960  51.043  1.00 59.02           C  
ATOM   1423  C   GLY   188      62.511  31.219  50.981  1.00 59.74           C  
ATOM   1424  O   GLY   188      61.723  31.467  50.074  1.00 61.22           O  
ATOM   1425  N   ASN   189      62.211  30.293  51.881  1.00 59.50           N  
ATOM   1426  CA  ASN   189      60.813  29.870  51.972  1.00 59.43           C  
ATOM   1427  CB  ASN   189      60.668  28.385  52.248  1.00 60.14           C  
ATOM   1428  CG  ASN   189      61.261  27.525  51.126  1.00 63.26           C  
ATOM   1429  OD1 ASN   189      60.745  27.503  50.000  1.00 69.09           O  
ATOM   1430  ND2 ASN   189      62.350  26.821  51.426  1.00 64.80           N  
ATOM   1431  C   ASN   189      60.293  30.684  53.108  1.00 58.76           C  
ATOM   1432  O   ASN   189      60.330  30.263  54.271  1.00 58.80           O  
ATOM   1433  N   ILE   190      59.854  31.888  52.803  1.00 57.34           N  
ATOM   1434  CA  ILE   190      59.455  32.763  53.879  1.00 56.55           C  
ATOM   1435  CB  ILE   190      58.825  34.052  53.346  1.00 56.31           C  
ATOM   1436  CG1 ILE   190      59.806  34.830  52.424  1.00 54.63           C  
ATOM   1437  CD1 ILE   190      61.277  34.745  52.731  1.00 53.57           C  
ATOM   1438  CG2 ILE   190      58.330  34.938  54.487  1.00 56.75           C  
ATOM   1439  C   ILE   190      58.560  32.078  54.944  1.00 56.38           C  
ATOM   1440  O   ILE   190      58.859  32.153  56.122  1.00 57.24           O  
ATOM   1441  N   ALA   191      57.514  31.365  54.574  1.00 55.84           N  
ATOM   1442  CA  ALA   191      56.737  30.678  55.600  1.00 55.62           C  
ATOM   1443  CB  ALA   191      55.619  29.905  55.014  1.00 54.96           C  
ATOM   1444  C   ALA   191      57.597  29.783  56.478  1.00 55.39           C  
ATOM   1445  O   ALA   191      57.483  29.839  57.693  1.00 55.38           O  
ATOM   1446  N   LYS   192      58.472  28.983  55.886  1.00 55.73           N  
ATOM   1447  CA  LYS   192      59.364  28.075  56.674  1.00 55.84           C  
ATOM   1448  CB  LYS   192      60.210  27.239  55.726  1.00 55.97           C  
ATOM   1449  CG  LYS   192      60.980  26.090  56.341  1.00 57.41           C  
ATOM   1450  CD  LYS   192      62.020  25.514  55.282  1.00 59.41           C  
ATOM   1451  CE  LYS   192      62.867  24.265  55.819  1.00 61.74           C  
ATOM   1452  NZ  LYS   192      63.481  23.500  54.653  1.00 60.86           N  
ATOM   1453  C   LYS   192      60.297  28.797  57.679  1.00 55.26           C  
ATOM   1454  O   LYS   192      60.639  28.287  58.730  1.00 54.68           O  
ATOM   1455  N   GLN   193      60.724  29.987  57.301  1.00 55.35           N  
ATOM   1456  CA  GLN   193      61.585  30.832  58.108  1.00 54.38           C  
ATOM   1457  CB  GLN   193      62.115  31.993  57.244  1.00 53.90           C  
ATOM   1458  CG  GLN   193      63.087  31.554  56.147  1.00 52.93           C  
ATOM   1459  CD  GLN   193      63.962  32.694  55.621  1.00 53.47           C  
ATOM   1460  OE1 GLN   193      64.104  32.901  54.417  1.00 51.49           O  
ATOM   1461  NE2 GLN   193      64.528  33.451  56.529  1.00 55.09           N  
ATOM   1462  C   GLN   193      60.765  31.383  59.241  1.00 53.88           C  
ATOM   1463  O   GLN   193      61.235  31.505  60.358  1.00 54.19           O  
ATOM   1464  N   LEU   194      59.534  31.755  58.955  1.00 53.27           N  
ATOM   1465  CA  LEU   194      58.716  32.295  59.994  1.00 53.33           C  
ATOM   1466  CB  LEU   194      57.432  32.856  59.425  1.00 52.86           C  
ATOM   1467  CG  LEU   194      57.462  34.117  58.566  1.00 50.30           C  
ATOM   1468  CD1 LEU   194      56.064  34.352  58.050  1.00 46.63           C  
ATOM   1469  CD2 LEU   194      57.965  35.313  59.354  1.00 46.73           C  
ATOM   1470  C   LEU   194      58.410  31.164  60.968  1.00 54.40           C  
ATOM   1471  O   LEU   194      58.433  31.358  62.167  1.00 55.26           O  
ATOM   1472  N   LEU   195      58.145  29.964  60.459  1.00 54.97           N  
ATOM   1473  CA  LEU   195      57.936  28.819  61.335  1.00 54.73           C  
ATOM   1474  CB  LEU   195      57.570  27.579  60.531  1.00 54.24           C  
ATOM   1475  CG  LEU   195      56.787  26.499  61.269  1.00 54.25           C  
ATOM   1476  CD1 LEU   195      55.409  27.022  61.737  1.00 55.95           C  
ATOM   1477  CD2 LEU   195      56.593  25.278  60.379  1.00 53.17           C  
ATOM   1478  C   LEU   195      59.177  28.557  62.193  1.00 55.04           C  
ATOM   1479  O   LEU   195      59.069  28.261  63.341  1.00 55.82           O  
ATOM   1480  N   ASN   196      60.357  28.691  61.662  1.00 55.87           N  
ATOM   1481  CA  ASN   196      61.518  28.408  62.465  1.00 57.39           C  
ATOM   1482  CB  ASN   196      62.810  28.337  61.622  1.00 58.19           C  
ATOM   1483  CG  ASN   196      62.756  27.292  60.566  1.00 58.66           C  
ATOM   1484  OD1 ASN   196      62.148  26.244  60.766  1.00 57.74           O  
ATOM   1485  ND2 ASN   196      63.361  27.586  59.406  1.00 60.48           N  
ATOM   1486  C   ASN   196      61.823  29.422  63.529  1.00 58.16           C  
ATOM   1487  O   ASN   196      62.600  29.108  64.384  1.00 57.65           O  
ATOM   1488  N   GLN   197      61.323  30.652  63.463  1.00 59.58           N  
ATOM   1489  CA  GLN   197      61.821  31.655  64.416  1.00 60.35           C  
ATOM   1490  CB  GLN   197      62.306  32.921  63.714  1.00 61.18           C  
ATOM   1491  CG  GLN   197      63.833  33.053  63.720  1.00 63.47           C  
ATOM   1492  CD  GLN   197      64.418  32.727  62.347  1.00 65.44           C  
ATOM   1493  OE1 GLN   197      65.466  33.251  61.970  1.00 65.09           O  
ATOM   1494  NE2 GLN   197      63.710  31.894  61.575  1.00 66.60           N  
ATOM   1495  C   GLN   197      60.827  32.071  65.450  1.00 61.19           C  
ATOM   1496  O   GLN   197      61.199  32.727  66.444  1.00 61.90           O  
ATOM   1497  N   PHE   198      59.572  31.708  65.224  1.00 61.74           N  
ATOM   1498  CA  PHE   198      58.476  32.250  66.007  1.00 62.50           C  
ATOM   1499  CB  PHE   198      57.610  33.136  65.091  1.00 63.24           C  
ATOM   1500  CG  PHE   198      58.311  34.400  64.721  1.00 63.23           C  
ATOM   1501  CD1 PHE   198      58.289  35.494  65.576  1.00 64.85           C  
ATOM   1502  CE1 PHE   198      58.998  36.692  65.280  1.00 64.76           C  
ATOM   1503  CZ  PHE   198      59.769  36.766  64.135  1.00 65.71           C  
ATOM   1504  CE2 PHE   198      59.845  35.649  63.294  1.00 65.67           C  
ATOM   1505  CD2 PHE   198      59.121  34.457  63.610  1.00 64.94           C  
ATOM   1506  C   PHE   198      57.719  31.184  66.761  1.00 62.01           C  
ATOM   1507  O   PHE   198      57.315  30.164  66.204  1.00 60.95           O  
ATOM   1508  N   GLU   199      57.624  31.418  68.066  1.00 63.23           N  
ATOM   1509  CA  GLU   199      57.033  30.463  69.050  1.00 63.40           C  
ATOM   1510  CB  GLU   199      57.253  30.965  70.523  1.00 64.68           C  
ATOM   1511  CG  GLU   199      56.559  30.142  71.715  1.00 65.60           C  
ATOM   1512  CD  GLU   199      56.710  30.770  73.173  1.00 67.04           C  
ATOM   1513  OE1 GLU   199      56.751  32.040  73.366  1.00 68.38           O  
ATOM   1514  OE2 GLU   199      56.762  29.934  74.144  1.00 72.60           O  
ATOM   1515  C   GLU   199      55.568  30.284  68.756  1.00 61.53           C  
ATOM   1516  O   GLU   199      54.804  31.236  68.553  1.00 60.87           O  
ATOM   1517  N   GLY   200      55.162  29.049  68.711  1.00 60.14           N  
ATOM   1518  CA  GLY   200      53.757  28.785  68.487  1.00 59.79           C  
ATOM   1519  C   GLY   200      53.182  28.977  67.100  1.00 59.49           C  
ATOM   1520  O   GLY   200      51.968  28.862  66.927  1.00 60.69           O  
ATOM   1521  N   PHE   201      54.017  29.239  66.106  1.00 58.81           N  
ATOM   1522  CA  PHE   201      53.544  29.299  64.721  1.00 58.07           C  
ATOM   1523  CB  PHE   201      54.528  30.080  63.856  1.00 57.64           C  
ATOM   1524  CG  PHE   201      54.273  31.575  63.815  1.00 57.73           C  
ATOM   1525  CD1 PHE   201      53.175  32.160  64.476  1.00 56.03           C  
ATOM   1526  CE1 PHE   201      52.942  33.521  64.394  1.00 55.74           C  
ATOM   1527  CZ  PHE   201      53.781  34.298  63.648  1.00 56.16           C  
ATOM   1528  CE2 PHE   201      54.864  33.734  62.968  1.00 55.47           C  
ATOM   1529  CD2 PHE   201      55.099  32.387  63.041  1.00 56.26           C  
ATOM   1530  C   PHE   201      53.304  27.922  64.107  1.00 57.71           C  
ATOM   1531  O   PHE   201      53.800  26.916  64.607  1.00 58.91           O  
ATOM   1532  N   SER   202      52.493  27.903  63.056  1.00 57.12           N  
ATOM   1533  CA  SER   202      52.192  26.717  62.239  1.00 56.29           C  
ATOM   1534  CB  SER   202      50.774  26.233  62.487  1.00 55.27           C  
ATOM   1535  OG  SER   202      49.885  27.334  62.345  1.00 54.15           O  
ATOM   1536  C   SER   202      52.237  27.109  60.760  1.00 56.32           C  
ATOM   1537  O   SER   202      52.035  28.315  60.398  1.00 57.11           O  
ATOM   1538  N   PRO   203      52.417  26.096  59.899  1.00 55.17           N  
ATOM   1539  CA  PRO   203      52.217  26.169  58.489  1.00 54.93           C  
ATOM   1540  CB  PRO   203      51.982  24.718  58.157  1.00 54.79           C  
ATOM   1541  CG  PRO   203      52.900  24.041  58.998  1.00 54.00           C  
ATOM   1542  CD  PRO   203      52.830  24.741  60.271  1.00 55.35           C  
ATOM   1543  C   PRO   203      51.005  27.036  58.113  1.00 54.44           C  
ATOM   1544  O   PRO   203      51.143  28.012  57.362  1.00 54.15           O  
ATOM   1545  N   LEU   204      49.855  26.711  58.689  1.00 53.91           N  
ATOM   1546  CA  LEU   204      48.646  27.446  58.419  1.00 54.19           C  
ATOM   1547  CB  LEU   204      47.528  27.053  59.371  1.00 54.64           C  
ATOM   1548  CG  LEU   204      46.784  25.767  59.012  1.00 55.67           C  
ATOM   1549  CD1 LEU   204      46.040  25.053  60.208  1.00 56.69           C  
ATOM   1550  CD2 LEU   204      45.830  26.158  57.902  1.00 56.96           C  
ATOM   1551  C   LEU   204      48.868  28.919  58.524  1.00 54.22           C  
ATOM   1552  O   LEU   204      48.571  29.667  57.557  1.00 55.59           O  
ATOM   1553  N   ILE   205      49.395  29.365  59.659  1.00 53.53           N  
ATOM   1554  CA  ILE   205      49.485  30.804  59.859  1.00 53.25           C  
ATOM   1555  CB  ILE   205      49.535  31.177  61.363  1.00 54.03           C  
ATOM   1556  CG1 ILE   205      49.136  32.662  61.552  1.00 54.55           C  
ATOM   1557  CD1 ILE   205      47.640  32.939  61.303  1.00 53.78           C  
ATOM   1558  CG2 ILE   205      50.874  30.748  62.006  1.00 51.62           C  
ATOM   1559  C   ILE   205      50.659  31.416  59.062  1.00 53.04           C  
ATOM   1560  O   ILE   205      50.516  32.522  58.503  1.00 51.64           O  
ATOM   1561  N   THR   206      51.784  30.688  58.976  1.00 52.57           N  
ATOM   1562  CA  THR   206      52.908  31.174  58.176  1.00 52.67           C  
ATOM   1563  CB  THR   206      54.182  30.297  58.286  1.00 51.95           C  
ATOM   1564  OG1 THR   206      53.851  28.925  58.179  1.00 49.67           O  
ATOM   1565  CG2 THR   206      54.854  30.509  59.602  1.00 52.05           C  
ATOM   1566  C   THR   206      52.477  31.337  56.717  1.00 52.92           C  
ATOM   1567  O   THR   206      52.723  32.395  56.101  1.00 52.13           O  
ATOM   1568  N   ASN   207      51.790  30.327  56.183  1.00 53.15           N  
ATOM   1569  CA  ASN   207      51.316  30.435  54.801  1.00 54.24           C  
ATOM   1570  CB  ASN   207      50.835  29.093  54.231  1.00 54.50           C  
ATOM   1571  CG  ASN   207      52.028  28.074  54.013  1.00 56.95           C  
ATOM   1572  OD1 ASN   207      51.834  26.874  53.952  1.00 59.50           O  
ATOM   1573  ND2 ASN   207      53.247  28.582  53.926  1.00 60.44           N  
ATOM   1574  C   ASN   207      50.316  31.562  54.650  1.00 54.17           C  
ATOM   1575  O   ASN   207      50.413  32.390  53.761  1.00 53.25           O  
ATOM   1576  N   GLU   208      49.423  31.681  55.602  1.00 55.26           N  
ATOM   1577  CA  GLU   208      48.529  32.842  55.579  1.00 55.82           C  
ATOM   1578  CB  GLU   208      47.589  32.805  56.782  1.00 55.23           C  
ATOM   1579  CG  GLU   208      46.524  33.875  56.676  1.00 55.39           C  
ATOM   1580  CD  GLU   208      45.530  33.615  55.578  1.00 57.78           C  
ATOM   1581  OE1 GLU   208      45.527  32.488  55.000  1.00 61.34           O  
ATOM   1582  OE2 GLU   208      44.725  34.532  55.300  1.00 59.27           O  
ATOM   1583  C   GLU   208      49.214  34.244  55.495  1.00 56.13           C  
ATOM   1584  O   GLU   208      48.736  35.111  54.783  1.00 55.43           O  
ATOM   1585  N   ILE   209      50.293  34.454  56.248  1.00 56.45           N  
ATOM   1586  CA  ILE   209      50.921  35.764  56.337  1.00 56.97           C  
ATOM   1587  CB  ILE   209      52.077  35.796  57.413  1.00 57.50           C  
ATOM   1588  CG1 ILE   209      51.515  35.553  58.830  1.00 59.38           C  
ATOM   1589  CD1 ILE   209      52.487  34.822  59.808  1.00 57.46           C  
ATOM   1590  CG2 ILE   209      52.938  37.133  57.349  1.00 55.85           C  
ATOM   1591  C   ILE   209      51.542  36.104  54.991  1.00 57.60           C  
ATOM   1592  O   ILE   209      51.332  37.221  54.447  1.00 57.59           O  
ATOM   1593  N   VAL   210      52.368  35.149  54.521  1.00 57.62           N  
ATOM   1594  CA  VAL   210      53.020  35.153  53.191  1.00 56.83           C  
ATOM   1595  CB  VAL   210      53.685  33.793  52.955  1.00 56.83           C  
ATOM   1596  CG1 VAL   210      53.559  33.397  51.544  1.00 54.22           C  
ATOM   1597  CG2 VAL   210      55.141  33.802  53.465  1.00 55.48           C  
ATOM   1598  C   VAL   210      52.037  35.449  52.047  1.00 56.43           C  
ATOM   1599  O   VAL   210      52.369  36.222  51.138  1.00 56.38           O  
ATOM   1600  N   SER   211      50.825  34.896  52.176  1.00 56.10           N  
ATOM   1601  CA  SER   211      49.650  35.188  51.314  1.00 56.65           C  
ATOM   1602  CB  SER   211      48.488  34.159  51.563  1.00 57.20           C  
ATOM   1603  OG  SER   211      47.430  34.685  52.415  1.00 57.88           O  
ATOM   1604  C   SER   211      48.980  36.541  51.421  1.00 56.15           C  
ATOM   1605  O   SER   211      47.991  36.772  50.749  1.00 57.13           O  
ATOM   1606  N   ARG   212      49.418  37.423  52.280  1.00 56.20           N  
ATOM   1607  CA  ARG   212      48.653  38.654  52.443  1.00 56.74           C  
ATOM   1608  CB  ARG   212      48.574  39.061  53.890  1.00 57.22           C  
ATOM   1609  CG  ARG   212      47.779  38.125  54.691  1.00 58.39           C  
ATOM   1610  CD  ARG   212      46.342  38.213  54.418  1.00 57.78           C  
ATOM   1611  NE  ARG   212      45.687  37.309  55.350  1.00 59.16           N  
ATOM   1612  CZ  ARG   212      44.974  37.688  56.413  1.00 58.38           C  
ATOM   1613  NH1 ARG   212      44.770  38.973  56.728  1.00 59.29           N  
ATOM   1614  NH2 ARG   212      44.444  36.758  57.161  1.00 55.31           N  
ATOM   1615  C   ARG   212      49.176  39.842  51.691  1.00 56.89           C  
ATOM   1616  O   ARG   212      48.782  40.983  52.023  1.00 56.43           O  
ATOM   1617  N   ARG   213      50.040  39.600  50.732  1.00 56.80           N  
ATOM   1618  CA  ARG   213      50.444  40.585  49.789  1.00 55.88           C  
ATOM   1619  CB  ARG   213      51.626  41.359  50.283  1.00 55.66           C  
ATOM   1620  CG  ARG   213      51.444  41.958  51.590  1.00 53.64           C  
ATOM   1621  CD  ARG   213      50.824  43.276  51.511  1.00 49.04           C  
ATOM   1622  NE  ARG   213      49.670  43.276  52.368  1.00 49.77           N  
ATOM   1623  CZ  ARG   213      49.371  44.248  53.196  1.00 50.41           C  
ATOM   1624  NH1 ARG   213      50.138  45.302  53.259  1.00 49.62           N  
ATOM   1625  NH2 ARG   213      48.308  44.160  53.955  1.00 48.16           N  
ATOM   1626  C   ARG   213      50.868  39.756  48.640  1.00 56.67           C  
ATOM   1627  O   ARG   213      50.996  38.567  48.763  1.00 58.18           O  
ATOM   1628  N   GLN   214      51.092  40.377  47.507  1.00 56.00           N  
ATOM   1629  CA  GLN   214      51.368  39.615  46.330  1.00 55.49           C  
ATOM   1630  CB  GLN   214      51.215  40.484  45.119  1.00 54.93           C  
ATOM   1631  CG  GLN   214      50.206  40.006  44.178  1.00 55.12           C  
ATOM   1632  CD  GLN   214      50.193  40.836  42.972  1.00 55.17           C  
ATOM   1633  OE1 GLN   214      50.335  42.041  43.044  1.00 53.10           O  
ATOM   1634  NE2 GLN   214      50.030  40.209  41.841  1.00 54.73           N  
ATOM   1635  C   GLN   214      52.753  39.106  46.390  1.00 54.51           C  
ATOM   1636  O   GLN   214      53.058  38.083  45.829  1.00 54.95           O  
ATOM   1637  N   PHE   215      53.606  39.826  47.081  1.00 52.93           N  
ATOM   1638  CA  PHE   215      54.978  39.413  47.126  1.00 52.65           C  
ATOM   1639  CB  PHE   215      55.768  40.213  46.116  1.00 53.02           C  
ATOM   1640  CG  PHE   215      55.432  39.881  44.714  1.00 53.63           C  
ATOM   1641  CD1 PHE   215      55.779  38.669  44.192  1.00 52.64           C  
ATOM   1642  CE1 PHE   215      55.471  38.360  42.924  1.00 52.66           C  
ATOM   1643  CZ  PHE   215      54.799  39.252  42.163  1.00 52.76           C  
ATOM   1644  CE2 PHE   215      54.446  40.456  42.662  1.00 52.53           C  
ATOM   1645  CD2 PHE   215      54.755  40.771  43.925  1.00 52.47           C  
ATOM   1646  C   PHE   215      55.574  39.589  48.478  1.00 51.25           C  
ATOM   1647  O   PHE   215      55.247  40.508  49.181  1.00 52.04           O  
ATOM   1648  N   MET   216      56.475  38.708  48.843  1.00 49.64           N  
ATOM   1649  CA  MET   216      57.132  38.862  50.139  1.00 48.63           C  
ATOM   1650  CB  MET   216      57.340  37.499  50.863  1.00 48.38           C  
ATOM   1651  CG  MET   216      56.156  36.939  51.693  1.00 46.59           C  
ATOM   1652  SD  MET   216      55.469  38.048  52.940  1.00 45.50           S  
ATOM   1653  CE  MET   216      54.083  38.750  52.009  1.00 43.49           C  
ATOM   1654  C   MET   216      58.458  39.602  49.897  1.00 48.05           C  
ATOM   1655  O   MET   216      59.315  39.114  49.196  1.00 47.67           O  
ATOM   1656  N   THR   217      58.598  40.776  50.507  1.00 47.87           N  
ATOM   1657  CA  THR   217      59.778  41.664  50.388  1.00 47.34           C  
ATOM   1658  CB  THR   217      59.540  42.837  49.409  1.00 47.58           C  
ATOM   1659  OG1 THR   217      58.814  43.878  50.106  1.00 46.70           O  
ATOM   1660  CG2 THR   217      58.769  42.379  48.189  1.00 44.19           C  
ATOM   1661  C   THR   217      59.940  42.364  51.720  1.00 46.72           C  
ATOM   1662  O   THR   217      59.042  42.322  52.524  1.00 46.43           O  
ATOM   1663  N   SER   218      61.035  43.086  51.890  1.00 46.41           N  
ATOM   1664  CA  SER   218      61.265  43.907  53.080  1.00 46.19           C  
ATOM   1665  CB  SER   218      62.626  44.572  52.990  1.00 45.63           C  
ATOM   1666  OG  SER   218      62.489  45.834  52.334  1.00 47.58           O  
ATOM   1667  C   SER   218      60.199  45.006  53.327  1.00 45.74           C  
ATOM   1668  O   SER   218      59.975  45.369  54.466  1.00 44.88           O  
ATOM   1669  N   SER   219      59.553  45.542  52.290  1.00 46.35           N  
ATOM   1670  CA  SER   219      58.403  46.427  52.528  1.00 47.16           C  
ATOM   1671  CB  SER   219      58.060  47.266  51.333  1.00 46.58           C  
ATOM   1672  OG  SER   219      59.187  47.996  51.006  1.00 47.75           O  
ATOM   1673  C   SER   219      57.130  45.696  52.894  1.00 48.04           C  
ATOM   1674  O   SER   219      56.330  46.191  53.689  1.00 49.24           O  
ATOM   1675  N   THR   220      56.898  44.532  52.321  1.00 48.31           N  
ATOM   1676  CA  THR   220      55.568  43.957  52.465  1.00 48.16           C  
ATOM   1677  CB  THR   220      55.196  43.183  51.194  1.00 49.17           C  
ATOM   1678  OG1 THR   220      56.260  42.272  50.896  1.00 50.74           O  
ATOM   1679  CG2 THR   220      54.915  44.141  50.059  1.00 44.82           C  
ATOM   1680  C   THR   220      55.414  43.032  53.674  1.00 47.89           C  
ATOM   1681  O   THR   220      54.334  42.962  54.286  1.00 46.24           O  
ATOM   1682  N   LEU   221      56.504  42.311  53.989  1.00 48.20           N  
ATOM   1683  CA  LEU   221      56.461  41.256  54.996  1.00 47.61           C  
ATOM   1684  CB  LEU   221      57.782  40.557  55.155  1.00 46.48           C  
ATOM   1685  CG  LEU   221      57.800  39.426  56.203  1.00 48.75           C  
ATOM   1686  CD1 LEU   221      56.470  38.648  56.303  1.00 50.59           C  
ATOM   1687  CD2 LEU   221      58.988  38.410  56.019  1.00 48.11           C  
ATOM   1688  C   LEU   221      55.973  41.871  56.278  1.00 48.13           C  
ATOM   1689  O   LEU   221      54.985  41.394  56.819  1.00 49.36           O  
ATOM   1690  N   PRO   222      56.581  42.996  56.722  1.00 47.89           N  
ATOM   1691  CA  PRO   222      56.131  43.664  57.944  1.00 47.78           C  
ATOM   1692  CB  PRO   222      56.903  44.967  57.922  1.00 47.02           C  
ATOM   1693  CG  PRO   222      58.128  44.640  57.194  1.00 47.30           C  
ATOM   1694  CD  PRO   222      57.724  43.709  56.126  1.00 47.86           C  
ATOM   1695  C   PRO   222      54.652  43.944  57.978  1.00 47.90           C  
ATOM   1696  O   PRO   222      54.009  43.676  58.960  1.00 47.04           O  
ATOM   1697  N   GLU   223      54.132  44.468  56.881  1.00 49.09           N  
ATOM   1698  CA  GLU   223      52.702  44.741  56.726  1.00 49.82           C  
ATOM   1699  CB  GLU   223      52.448  45.250  55.307  1.00 49.45           C  
ATOM   1700  CG  GLU   223      52.447  46.710  55.118  1.00 50.59           C  
ATOM   1701  CD  GLU   223      53.025  47.136  53.768  1.00 53.79           C  
ATOM   1702  OE1 GLU   223      52.836  46.390  52.760  1.00 64.29           O  
ATOM   1703  OE2 GLU   223      53.670  48.225  53.695  1.00 58.16           O  
ATOM   1704  C   GLU   223      51.871  43.489  56.907  1.00 49.23           C  
ATOM   1705  O   GLU   223      50.849  43.520  57.560  1.00 48.47           O  
ATOM   1706  N   ALA   224      52.295  42.401  56.280  1.00 49.72           N  
ATOM   1707  CA  ALA   224      51.536  41.165  56.343  1.00 51.44           C  
ATOM   1708  CB  ALA   224      52.163  40.106  55.401  1.00 51.49           C  
ATOM   1709  C   ALA   224      51.489  40.670  57.809  1.00 52.85           C  
ATOM   1710  O   ALA   224      50.424  40.541  58.444  1.00 53.64           O  
ATOM   1711  N   PHE   225      52.678  40.456  58.361  1.00 53.76           N  
ATOM   1712  CA  PHE   225      52.831  40.121  59.747  1.00 53.65           C  
ATOM   1713  CB  PHE   225      54.281  40.295  60.124  1.00 54.17           C  
ATOM   1714  CG  PHE   225      54.598  39.801  61.504  1.00 56.69           C  
ATOM   1715  CD1 PHE   225      55.016  38.484  61.720  1.00 58.37           C  
ATOM   1716  CE1 PHE   225      55.309  38.017  63.041  1.00 55.01           C  
ATOM   1717  CZ  PHE   225      55.183  38.843  64.088  1.00 53.46           C  
ATOM   1718  CE2 PHE   225      54.802  40.145  63.889  1.00 56.52           C  
ATOM   1719  CD2 PHE   225      54.489  40.633  62.608  1.00 57.51           C  
ATOM   1720  C   PHE   225      51.904  40.951  60.679  1.00 54.04           C  
ATOM   1721  O   PHE   225      51.042  40.383  61.380  1.00 54.85           O  
ATOM   1722  N   ASP   226      52.057  42.271  60.675  1.00 53.01           N  
ATOM   1723  CA  ASP   226      51.294  43.080  61.578  1.00 53.07           C  
ATOM   1724  CB  ASP   226      51.699  44.548  61.467  1.00 52.40           C  
ATOM   1725  CG  ASP   226      53.113  44.847  62.093  1.00 53.38           C  
ATOM   1726  OD1 ASP   226      53.653  44.023  62.962  1.00 51.35           O  
ATOM   1727  OD2 ASP   226      53.669  45.934  61.699  1.00 48.55           O  
ATOM   1728  C   ASP   226      49.801  42.838  61.330  1.00 53.38           C  
ATOM   1729  O   ASP   226      49.046  42.480  62.252  1.00 53.49           O  
ATOM   1730  N   GLU   227      49.389  42.924  60.075  1.00 54.03           N  
ATOM   1731  CA  GLU   227      47.999  42.712  59.723  1.00 54.36           C  
ATOM   1732  CB  GLU   227      47.862  42.611  58.221  1.00 54.35           C  
ATOM   1733  CG  GLU   227      46.491  43.047  57.703  1.00 56.78           C  
ATOM   1734  CD  GLU   227      46.152  42.565  56.254  1.00 57.35           C  
ATOM   1735  OE1 GLU   227      45.951  43.469  55.357  1.00 59.61           O  
ATOM   1736  OE2 GLU   227      46.061  41.296  56.046  1.00 58.50           O  
ATOM   1737  C   GLU   227      47.490  41.430  60.369  1.00 54.28           C  
ATOM   1738  O   GLU   227      46.450  41.397  61.026  1.00 54.29           O  
ATOM   1739  N   VAL   228      48.235  40.356  60.215  1.00 54.34           N  
ATOM   1740  CA  VAL   228      47.744  39.093  60.752  1.00 54.56           C  
ATOM   1741  CB  VAL   228      48.543  37.901  60.244  1.00 54.76           C  
ATOM   1742  CG1 VAL   228      48.211  36.632  61.062  1.00 55.28           C  
ATOM   1743  CG2 VAL   228      48.207  37.690  58.807  1.00 54.18           C  
ATOM   1744  C   VAL   228      47.711  39.053  62.266  1.00 54.31           C  
ATOM   1745  O   VAL   228      46.734  38.589  62.825  1.00 53.90           O  
ATOM   1746  N   MET   229      48.775  39.526  62.914  1.00 54.01           N  
ATOM   1747  CA  MET   229      48.828  39.476  64.364  1.00 53.65           C  
ATOM   1748  CB  MET   229      50.200  39.810  64.905  1.00 52.89           C  
ATOM   1749  CG  MET   229      51.306  38.867  64.431  1.00 51.26           C  
ATOM   1750  SD  MET   229      51.304  37.233  65.155  1.00 46.88           S  
ATOM   1751  CE  MET   229      50.165  36.437  64.133  1.00 49.03           C  
ATOM   1752  C   MET   229      47.756  40.386  64.952  1.00 53.59           C  
ATOM   1753  O   MET   229      47.123  40.038  65.945  1.00 53.15           O  
ATOM   1754  N   ALA   230      47.464  41.500  64.303  1.00 53.86           N  
ATOM   1755  CA  ALA   230      46.270  42.282  64.731  1.00 54.04           C  
ATOM   1756  CB  ALA   230      46.140  43.542  63.948  1.00 51.66           C  
ATOM   1757  C   ALA   230      44.968  41.428  64.666  1.00 54.13           C  
ATOM   1758  O   ALA   230      44.189  41.376  65.603  1.00 53.64           O  
ATOM   1759  N   GLU   231      44.737  40.737  63.574  1.00 55.17           N  
ATOM   1760  CA  GLU   231      43.548  39.929  63.492  1.00 56.47           C  
ATOM   1761  CB  GLU   231      43.523  39.255  62.139  1.00 56.63           C  
ATOM   1762  CG  GLU   231      42.845  40.053  61.072  1.00 59.59           C  
ATOM   1763  CD  GLU   231      42.881  39.377  59.663  1.00 60.96           C  
ATOM   1764  OE1 GLU   231      42.597  38.132  59.620  1.00 61.26           O  
ATOM   1765  OE2 GLU   231      43.151  40.122  58.627  1.00 66.83           O  
ATOM   1766  C   GLU   231      43.473  38.853  64.619  1.00 56.60           C  
ATOM   1767  O   GLU   231      42.379  38.435  65.077  1.00 56.06           O  
ATOM   1768  N   THR   232      44.627  38.375  65.078  1.00 57.13           N  
ATOM   1769  CA  THR   232      44.588  37.338  66.127  1.00 56.91           C  
ATOM   1770  CB  THR   232      45.929  36.776  66.492  1.00 56.05           C  
ATOM   1771  OG1 THR   232      46.809  37.850  66.880  1.00 52.73           O  
ATOM   1772  CG2 THR   232      46.443  35.992  65.330  1.00 55.48           C  
ATOM   1773  C   THR   232      44.000  37.886  67.397  1.00 57.57           C  
ATOM   1774  O   THR   232      43.532  37.126  68.203  1.00 58.60           O  
ATOM   1775  N   LYS   233      44.049  39.199  67.570  1.00 57.71           N  
ATOM   1776  CA  LYS   233      43.540  39.844  68.767  1.00 57.50           C  
ATOM   1777  CB  LYS   233      44.251  41.167  68.975  1.00 56.79           C  
ATOM   1778  CG  LYS   233      45.682  40.926  69.191  1.00 56.33           C  
ATOM   1779  CD  LYS   233      46.407  42.182  69.201  1.00 58.05           C  
ATOM   1780  CE  LYS   233      47.861  41.950  69.602  1.00 60.79           C  
ATOM   1781  NZ  LYS   233      48.289  43.255  70.239  1.00 64.17           N  
ATOM   1782  C   LYS   233      42.067  40.103  68.675  1.00 58.38           C  
ATOM   1783  O   LYS   233      41.458  40.571  69.633  1.00 59.64           O  
ATOM   1784  N   LEU   234      41.471  39.856  67.518  1.00 58.35           N  
ATOM   1785  CA  LEU   234      40.047  40.055  67.434  1.00 57.46           C  
ATOM   1786  CB  LEU   234      39.677  40.528  66.037  1.00 57.94           C  
ATOM   1787  CG  LEU   234      39.756  42.057  65.894  1.00 58.27           C  
ATOM   1788  CD1 LEU   234      40.949  42.538  66.697  1.00 59.90           C  
ATOM   1789  CD2 LEU   234      39.837  42.465  64.449  1.00 56.72           C  
ATOM   1790  C   LEU   234      39.377  38.759  67.872  1.00 57.03           C  
ATOM   1791  O   LEU   234      40.007  37.719  67.898  1.00 56.48           O  
END
