
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   88 (  678),  selected   88 , name 1yd6_B
# Molecule2: number of CA atoms   44 (  374),  selected   44 , name T0510_235_279.pdb
# PARAMETERS: 1yd6_B.T0510_235_279.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     8_B      P     235           -
LGA    L     9_B      P     236           -
LGA    A    10_B      -       -           -
LGA    V    11_B      -       -           -
LGA    L    12_B      -       -           -
LGA    P    13_B      -       -           -
LGA    E    14_B      -       -           -
LGA    Q    15_B      T     237          1.548
LGA    P    16_B      P     238          1.080
LGA    G    17_B      I     239          1.736
LGA    C    18_B      F     240          0.605
LGA    Y    19_B      H     241          0.585
LGA    L    20_B      -       -           -
LGA    M    21_B      N     243          0.877
LGA    K    22_B      H     244          1.170
LGA    D    23_B      E     245          1.460
LGA    K    24_B      T     246           -
LGA    H    25_B      -       -           -
LGA    G    26_B      -       -           -
LGA    T    27_B      -       -           -
LGA    V    28_B      -       -           -
LGA    I    29_B      G     247          1.124
LGA    Y    30_B      K     248          0.615
LGA    V    31_B      E     249          0.806
LGA    G    32_B      D     250          0.726
LGA    K    33_B      F     251          0.859
LGA    A    34_B      Y     252          1.075
LGA    K    35_B      F     253          0.531
LGA    S    36_B      I     254          0.777
LGA    L    37_B      K     255          2.274
LGA    K    38_B      L     256          3.547
LGA    E    39_B      -       -           -
LGA    R    40_B      -       -           -
LGA    V    41_B      -       -           -
LGA    R    42_B      N     257          1.434
LGA    S    43_B      Q     258          3.796
LGA    Y    44_B      F     259           #
LGA    F    45_B      -       -           -
LGA    T    46_B      -       -           -
LGA    G    47_B      -       -           -
LGA    T    48_B      -       -           -
LGA    H    49_B      -       -           -
LGA    D    50_B      -       -           -
LGA    G    51_B      -       -           -
LGA    K    52_B      -       -           -
LGA    T    53_B      -       -           -
LGA    Q    54_B      -       -           -
LGA    R    55_B      -       -           -
LGA    L    56_B      -       -           -
LGA    V    57_B      -       -           -
LGA    E    58_B      -       -           -
LGA    E    59_B      -       -           -
LGA    I    60_B      -       -           -
LGA    A    61_B      -       -           -
LGA    D    62_B      N     260           #
LGA    F    63_B      D     261          2.513
LGA    E    64_B      D     262          0.910
LGA    Y    65_B      T     263          0.661
LGA    I    66_B      V     264          0.711
LGA    V    67_B      T     265          0.572
LGA    T    68_B      Y     266          0.483
LGA    S    69_B      D     267          0.748
LGA    S    70_B      S     268          0.697
LGA    N    71_B      L     269          0.899
LGA    A    72_B      N     270          0.995
LGA    E    73_B      D     271          0.967
LGA    A    74_B      L     272          0.862
LGA    L    75_B      L     273          0.854
LGA    I    76_B      D     274          1.081
LGA    L    77_B      R     275          1.441
LGA    E    78_B      F     276          1.063
LGA    M    79_B      Y     277          1.444
LGA    N    80_B      D     278          2.702
LGA    L    81_B      -       -           -
LGA    I    82_B      -       -           -
LGA    K    83_B      A     279          1.704
LGA    K    84_B      -       -           -
LGA    H    85_B      -       -           -
LGA    D    86_B      -       -           -
LGA    P    87_B      -       -           -
LGA    K    88_B      -       -           -
LGA    Y    89_B      -       -           -
LGA    N    90_B      -       -           -
LGA    V    91_B      -       -           -
LGA    M    92_B      -       -           -
LGA    L    93_B      -       -           -
LGA    K    94_B      -       -           -
LGA    D    95_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   88   44    5.0     39    1.45     7.69     85.785     2.517

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.557668 * X  +  -0.675323 * Y  +  -0.482644 * Z  +  44.193913
  Y_new =  -0.069966 * X  +  -0.541142 * Y  +   0.838016 * Z  +  -0.345602
  Z_new =  -0.827110 * X  +   0.501103 * Y  +   0.254527 * Z  +  88.492226 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.100821   -2.040771  [ DEG:    63.0724   -116.9276 ]
  Theta =   0.973947    2.167646  [ DEG:    55.8030    124.1970 ]
  Phi   =  -3.016782    0.124811  [ DEG:  -172.8489      7.1511 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1yd6_B                                        
REMARK     2: T0510_235_279.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1yd6_B.T0510_235_279.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   88   44   5.0   39   1.45    7.69  85.785
REMARK  ---------------------------------------------------------- 
MOLECULE 1yd6_B
HEADER    DNA BINDING PROTEIN                     23-DEC-04   1YD6              
TITLE     CRYSTAL STRUCTURE OF THE GIY-YIG N-TERMINAL ENDONUCLEASE              
TITLE    2 DOMAIN OF UVRC FROM BACILLUS CALDOTENAX                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UVRC;                                                      
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 FRAGMENT: N-TERMINAL DOMAIN;                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS CALDOTENAX;                            
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    DNA BINDING PROTEIN                                                   
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.J.TRUGLIO,B.RHAU,D.L.CROTEAU,L.WANG,M.SKORVAGA,E.KARAKAS,           
AUTHOR   2 M.J.DELLAVECCHIA,H.WANG,B.VAN HOUTEN,C.KISKER                        
REVDAT   2   29-MAR-05 1YD6    1       JRNL                                     
REVDAT   1   01-MAR-05 1YD6    0                                                
JRNL        AUTH   J.J.TRUGLIO,B.RHAU,D.L.CROTEAU,L.WANG,M.SKORVAGA,            
JRNL        AUTH 2 E.KARAKAS,M.J.DELLAVECCHIA,H.WANG,B.VAN HOUTEN,              
JRNL        AUTH 3 C.KISKER                                                     
JRNL        TITL   STRUCTURAL INSIGHTS INTO THE FIRST INCISION                  
JRNL        TITL 2 REACTION DURING NUCLEOTIDE EXCISION REPAIR                   
JRNL        REF    EMBO J.                       V.  24   885 2005              
JRNL        REFN   ASTM EMJODG  UK ISSN 0261-4189                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
SEQRES   1 A   99  MET ASN GLU ARG LEU LYS GLU LYS LEU ALA VAL LEU PRO          
SEQRES   2 A   99  GLU GLN PRO GLY CYS TYR LEU MET LYS ASP LYS HIS GLY          
SEQRES   3 A   99  THR VAL ILE TYR VAL GLY LYS ALA LYS SER LEU LYS GLU          
SEQRES   4 A   99  ARG VAL ARG SER TYR PHE THR GLY THR HIS ASP GLY LYS          
SEQRES   5 A   99  THR GLN ARG LEU VAL GLU GLU ILE ALA ASP PHE GLU TYR          
SEQRES   6 A   99  ILE VAL THR SER SER ASN ALA GLU ALA LEU ILE LEU GLU          
SEQRES   7 A   99  MET ASN LEU ILE LYS LYS HIS ASP PRO LYS TYR ASN VAL          
SEQRES   8 A   99  MET LEU LYS ASP ASP LYS SER TYR                              
SEQRES   1 B   99  MET ASN GLU ARG LEU LYS GLU LYS LEU ALA VAL LEU PRO          
SEQRES   2 B   99  GLU GLN PRO GLY CYS TYR LEU MET LYS ASP LYS HIS GLY          
SEQRES   3 B   99  THR VAL ILE TYR VAL GLY LYS ALA LYS SER LEU LYS GLU          
SEQRES   4 B   99  ARG VAL ARG SER TYR PHE THR GLY THR HIS ASP GLY LYS          
SEQRES   5 B   99  THR GLN ARG LEU VAL GLU GLU ILE ALA ASP PHE GLU TYR          
SEQRES   6 B   99  ILE VAL THR SER SER ASN ALA GLU ALA LEU ILE LEU GLU          
SEQRES   7 B   99  MET ASN LEU ILE LYS LYS HIS ASP PRO LYS TYR ASN VAL          
SEQRES   8 B   99  MET LEU LYS ASP ASP LYS SER TYR                              
SEQRES   1 C   99  MET ASN GLU ARG LEU LYS GLU LYS LEU ALA VAL LEU PRO          
SEQRES   2 C   99  GLU GLN PRO GLY CYS TYR LEU MET LYS ASP LYS HIS GLY          
SEQRES   3 C   99  THR VAL ILE TYR VAL GLY LYS ALA LYS SER LEU LYS GLU          
SEQRES   4 C   99  ARG VAL ARG SER TYR PHE THR GLY THR HIS ASP GLY LYS          
SEQRES   5 C   99  THR GLN ARG LEU VAL GLU GLU ILE ALA ASP PHE GLU TYR          
SEQRES   6 C   99  ILE VAL THR SER SER ASN ALA GLU ALA LEU ILE LEU GLU          
SEQRES   7 C   99  MET ASN LEU ILE LYS LYS HIS ASP PRO LYS TYR ASN VAL          
SEQRES   8 C   99  MET LEU LYS ASP ASP LYS SER TYR                              
SEQRES   1 D   99  MET ASN GLU ARG LEU LYS GLU LYS LEU ALA VAL LEU PRO          
SEQRES   2 D   99  GLU GLN PRO GLY CYS TYR LEU MET LYS ASP LYS HIS GLY          
SEQRES   3 D   99  THR VAL ILE TYR VAL GLY LYS ALA LYS SER LEU LYS GLU          
SEQRES   4 D   99  ARG VAL ARG SER TYR PHE THR GLY THR HIS ASP GLY LYS          
SEQRES   5 D   99  THR GLN ARG LEU VAL GLU GLU ILE ALA ASP PHE GLU TYR          
SEQRES   6 D   99  ILE VAL THR SER SER ASN ALA GLU ALA LEU ILE LEU GLU          
SEQRES   7 D   99  MET ASN LEU ILE LYS LYS HIS ASP PRO LYS TYR ASN VAL          
SEQRES   8 D   99  MET LEU LYS ASP ASP LYS SER TYR                              
HET     CL   1001       1                                                       
HET    SO4   1002       5                                                       
HET    SO4   1003       5                                                       
HET    SO4   1004       5                                                       
HET     CL   1005       1                                                       
HET     CL   1006       1                                                       
HETNAM      CL CHLORIDE ION                                                     
HETNAM     SO4 SULFATE ION                                                      
FORMUL   5   CL    3(CL 1-)                                                     
FORMUL   6  SO4    3(O4 S 2-)                                                   
FORMUL  11  HOH   *126(H2 O)                                                    
CRYST1   86.487   86.660   67.862  90.00 120.16  90.00 C 1 2 1      16          
ATOM    769  N   LYS B   8      34.708  32.480  46.301  1.00 78.06           N  
ATOM    770  CA  LYS B   8      34.653  31.740  47.597  1.00 75.92           C  
ATOM    771  C   LYS B   8      35.663  32.331  48.563  1.00 74.99           C  
ATOM    772  O   LYS B   8      35.289  32.797  49.639  1.00 74.63           O  
ATOM    773  CB  LYS B   8      34.901  30.235  47.399  1.00 75.25           C  
ATOM    774  CG  LYS B   8      34.047  29.606  46.302  1.00 76.17           C  
ATOM    775  CD  LYS B   8      33.958  28.083  46.398  1.00 74.64           C  
ATOM    776  CE  LYS B   8      32.899  27.626  47.391  1.00 72.45           C  
ATOM    777  NZ  LYS B   8      32.375  26.267  47.054  1.00 71.35           N  
ATOM    778  N   LEU B   9      36.932  32.348  48.168  1.00 75.36           N  
ATOM    779  CA  LEU B   9      37.981  32.927  49.009  1.00 74.98           C  
ATOM    780  C   LEU B   9      37.667  34.370  49.451  1.00 75.58           C  
ATOM    781  O   LEU B   9      37.967  34.745  50.584  1.00 75.14           O  
ATOM    782  CB  LEU B   9      39.340  32.868  48.308  1.00 75.71           C  
ATOM    783  CG  LEU B   9      39.910  31.478  48.021  1.00 75.01           C  
ATOM    784  CD1 LEU B   9      41.157  31.570  47.148  1.00 76.12           C  
ATOM    785  CD2 LEU B   9      40.220  30.716  49.300  1.00 73.50           C  
ATOM    786  N   ALA B  10      37.039  35.159  48.581  1.00 76.94           N  
ATOM    787  CA  ALA B  10      36.701  36.563  48.899  1.00 77.37           C  
ATOM    788  C   ALA B  10      35.568  36.735  49.923  1.00 76.01           C  
ATOM    789  O   ALA B  10      35.522  37.739  50.643  1.00 75.65           O  
ATOM    790  CB  ALA B  10      36.363  37.327  47.610  1.00 79.61           C  
ATOM    791  N   VAL B  11      34.673  35.748  49.986  1.00 74.83           N  
ATOM    792  CA  VAL B  11      33.491  35.797  50.852  1.00 73.89           C  
ATOM    793  C   VAL B  11      33.764  35.106  52.194  1.00 71.52           C  
ATOM    794  O   VAL B  11      32.906  35.116  53.086  1.00 70.91           O  
ATOM    795  CB  VAL B  11      32.260  35.101  50.183  1.00 74.58           C  
ATOM    796  CG1 VAL B  11      30.939  35.576  50.812  1.00 74.58           C  
ATOM    797  CG2 VAL B  11      32.234  35.348  48.667  1.00 77.16           C  
ATOM    798  N   LEU B  12      34.949  34.507  52.348  1.00 70.28           N  
ATOM    799  CA  LEU B  12      35.282  33.794  53.600  1.00 68.07           C  
ATOM    800  C   LEU B  12      35.196  34.725  54.793  1.00 67.14           C  
ATOM    801  O   LEU B  12      35.743  35.826  54.743  1.00 68.30           O  
ATOM    802  CB  LEU B  12      36.684  33.191  53.578  1.00 67.44           C  
ATOM    803  CG  LEU B  12      36.913  31.903  52.807  1.00 67.13           C  
ATOM    804  CD1 LEU B  12      38.396  31.627  52.768  1.00 66.59           C  
ATOM    805  CD2 LEU B  12      36.160  30.745  53.436  1.00 66.36           C  
ATOM    806  N   PRO B  13      34.530  34.277  55.873  1.00 65.29           N  
ATOM    807  CA  PRO B  13      34.392  35.088  57.072  1.00 64.21           C  
ATOM    808  C   PRO B  13      35.482  34.865  58.125  1.00 62.08           C  
ATOM    809  O   PRO B  13      36.101  33.801  58.187  1.00 61.32           O  
ATOM    810  CB  PRO B  13      33.034  34.644  57.631  1.00 63.99           C  
ATOM    811  CG  PRO B  13      32.735  33.291  57.005  1.00 64.50           C  
ATOM    812  CD  PRO B  13      33.846  32.979  56.038  1.00 64.77           C  
ATOM    813  N   GLU B  14      35.690  35.888  58.943  1.00 60.59           N  
ATOM    814  CA  GLU B  14      36.617  35.832  60.037  1.00 59.28           C  
ATOM    815  C   GLU B  14      35.854  35.296  61.242  1.00 56.74           C  
ATOM    816  O   GLU B  14      35.459  36.051  62.140  1.00 57.57           O  
ATOM    817  CB  GLU B  14      37.180  37.216  60.328  1.00 60.16           C  
ATOM    818  CG  GLU B  14      37.855  37.878  59.120  1.00 62.41           C  
ATOM    819  CD  GLU B  14      38.336  39.289  59.416  1.00 63.72           C  
ATOM    820  OE1 GLU B  14      37.927  39.848  60.461  1.00 66.58           O  
ATOM    821  OE2 GLU B  14      39.121  39.838  58.607  1.00 67.20           O  
ATOM    822  N   GLN B  15      35.612  33.989  61.234  1.00 53.63           N  
ATOM    823  CA  GLN B  15      34.941  33.320  62.334  1.00 51.13           C  
ATOM    824  C   GLN B  15      35.599  31.963  62.466  1.00 48.45           C  
ATOM    825  O   GLN B  15      36.157  31.465  61.509  1.00 47.97           O  
ATOM    826  CB  GLN B  15      33.455  33.129  62.024  1.00 51.17           C  
ATOM    827  CG  GLN B  15      32.821  34.276  61.239  1.00 53.58           C  
ATOM    828  CD  GLN B  15      31.313  34.120  61.058  0.50 53.72           C  
ATOM    829  OE1 GLN B  15      30.629  33.607  61.947  1.00 56.61           O  
ATOM    830  NE2 GLN B  15      30.787  34.572  59.909  1.00 56.06           N  
ATOM    831  N   PRO B  16      35.515  31.345  63.646  1.00 46.00           N  
ATOM    832  CA  PRO B  16      36.063  30.019  63.707  1.00 44.59           C  
ATOM    833  C   PRO B  16      35.145  29.044  62.975  1.00 43.22           C  
ATOM    834  O   PRO B  16      33.996  29.380  62.651  1.00 42.62           O  
ATOM    835  CB  PRO B  16      36.074  29.716  65.209  1.00 45.01           C  
ATOM    836  CG  PRO B  16      34.947  30.481  65.740  1.00 45.14           C  
ATOM    837  CD  PRO B  16      34.905  31.749  64.919  1.00 46.07           C  
ATOM    838  N   GLY B  17      35.653  27.843  62.747  1.00 41.26           N  
ATOM    839  CA  GLY B  17      34.856  26.796  62.131  1.00 39.70           C  
ATOM    840  C   GLY B  17      35.698  25.762  61.460  1.00 37.71           C  
ATOM    841  O   GLY B  17      36.900  25.652  61.724  1.00 37.59           O  
ATOM    842  N   CYS B  18      35.072  24.997  60.587  1.00 36.36           N  
ATOM    843  CA  CYS B  18      35.786  23.954  59.882  1.00 35.87           C  
ATOM    844  C   CYS B  18      35.645  24.119  58.391  1.00 37.14           C  
ATOM    845  O   CYS B  18      34.603  24.559  57.916  1.00 35.41           O  
ATOM    846  CB  CYS B  18      35.257  22.589  60.250  1.00 35.41           C  
ATOM    847  SG  CYS B  18      35.605  22.167  61.974  1.00 35.25           S  
ATOM    848  N   TYR B  19      36.694  23.697  57.685  1.00 38.14           N  
ATOM    849  CA  TYR B  19      36.708  23.702  56.232  1.00 40.11           C  
ATOM    850  C   TYR B  19      37.010  22.308  55.711  1.00 40.39           C  
ATOM    851  O   TYR B  19      37.732  21.533  56.336  1.00 40.98           O  
ATOM    852  CB  TYR B  19      37.716  24.701  55.699  1.00 41.03           C  
ATOM    853  CG  TYR B  19      39.117  24.491  56.162  1.00 41.55           C  
ATOM    854  CD1 TYR B  19      40.018  23.735  55.407  1.00 42.22           C  
ATOM    855  CD2 TYR B  19      39.567  25.076  57.333  1.00 42.16           C  
ATOM    856  CE1 TYR B  19      41.313  23.567  55.823  1.00 42.94           C  
ATOM    857  CE2 TYR B  19      40.864  24.897  57.764  1.00 42.66           C  
ATOM    858  CZ  TYR B  19      41.731  24.151  57.004  1.00 42.65           C  
ATOM    859  OH  TYR B  19      43.015  23.979  57.459  1.00 43.56           O  
ATOM    860  N   LEU B  20      36.397  21.993  54.583  1.00 41.31           N  
ATOM    861  CA  LEU B  20      36.540  20.719  53.957  1.00 41.64           C  
ATOM    862  C   LEU B  20      37.159  20.996  52.582  1.00 43.87           C  
ATOM    863  O   LEU B  20      36.493  21.545  51.712  1.00 44.34           O  
ATOM    864  CB  LEU B  20      35.167  20.056  53.815  1.00 41.40           C  
ATOM    865  CG  LEU B  20      34.283  19.940  55.098  1.00 40.09           C  
ATOM    866  CD1 LEU B  20      33.596  21.229  55.482  1.00 38.24           C  
ATOM    867  CD2 LEU B  20      33.218  18.905  54.861  1.00 40.69           C  
ATOM    868  N   MET B  21      38.434  20.662  52.419  1.00 45.67           N  
ATOM    869  CA  MET B  21      39.113  20.797  51.105  1.00 47.40           C  
ATOM    870  C   MET B  21      38.691  19.637  50.257  1.00 48.75           C  
ATOM    871  O   MET B  21      38.679  18.516  50.743  1.00 48.00           O  
ATOM    872  CB  MET B  21      40.619  20.741  51.280  1.00 48.01           C  
ATOM    873  CG  MET B  21      41.174  21.874  52.068  1.00 47.41           C  
ATOM    874  SD  MET B  21      40.554  23.440  51.473  1.00 50.40           S  
ATOM    875  CE  MET B  21      41.854  24.499  52.107  1.00 49.84           C  
ATOM    876  N   LYS B  22      38.356  19.884  48.990  1.00 50.98           N  
ATOM    877  CA  LYS B  22      37.854  18.822  48.113  1.00 52.29           C  
ATOM    878  C   LYS B  22      38.654  18.581  46.812  1.00 54.68           C  
ATOM    879  O   LYS B  22      39.401  19.449  46.342  1.00 55.28           O  
ATOM    880  CB  LYS B  22      36.405  19.109  47.712  1.00 52.63           C  
ATOM    881  CG  LYS B  22      35.412  19.411  48.815  1.00 52.05           C  
ATOM    882  CD  LYS B  22      34.043  19.635  48.199  1.00 53.07           C  
ATOM    883  CE  LYS B  22      32.901  19.376  49.159  1.00 55.92           C  
ATOM    884  NZ  LYS B  22      31.692  18.885  48.426  1.00 59.04           N  
ATOM    885  N   ASP B  23      38.425  17.387  46.259  1.00 56.33           N  
ATOM    886  CA  ASP B  23      38.965  16.889  44.977  1.00 59.26           C  
ATOM    887  C   ASP B  23      38.347  17.593  43.788  1.00 60.85           C  
ATOM    888  O   ASP B  23      37.337  18.281  43.933  1.00 61.12           O  
ATOM    889  CB  ASP B  23      38.605  15.392  44.808  1.00 59.25           C  
ATOM    890  CG  ASP B  23      39.769  14.471  45.047  1.00 61.49           C  
ATOM    891  OD1 ASP B  23      40.929  14.932  44.910  1.00 65.45           O  
ATOM    892  OD2 ASP B  23      39.511  13.275  45.348  1.00 63.48           O  
ATOM    893  N   LYS B  24      38.927  17.385  42.600  1.00 63.24           N  
ATOM    894  CA  LYS B  24      38.258  17.795  41.361  1.00 65.03           C  
ATOM    895  C   LYS B  24      37.028  16.898  41.207  1.00 65.41           C  
ATOM    896  O   LYS B  24      35.998  17.293  40.659  1.00 66.18           O  
ATOM    897  CB  LYS B  24      39.175  17.645  40.133  1.00 66.96           C  
ATOM    898  N   HIS B  25      37.158  15.683  41.724  1.00 64.76           N  
ATOM    899  CA  HIS B  25      36.125  14.671  41.624  1.00 65.35           C  
ATOM    900  C   HIS B  25      35.022  14.869  42.663  1.00 64.07           C  
ATOM    901  O   HIS B  25      34.002  14.176  42.602  1.00 64.81           O  
ATOM    902  CB  HIS B  25      36.779  13.282  41.701  1.00 65.71           C  
ATOM    903  CG  HIS B  25      38.122  13.226  41.022  1.00 68.31           C  
ATOM    904  ND1 HIS B  25      38.303  13.571  39.697  1.00 71.95           N  
ATOM    905  CD2 HIS B  25      39.353  12.916  41.499  1.00 69.31           C  
ATOM    906  CE1 HIS B  25      39.584  13.461  39.385  1.00 72.24           C  
ATOM    907  NE2 HIS B  25      40.242  13.058  40.457  1.00 70.76           N  
ATOM    908  N   GLY B  26      35.215  15.815  43.595  1.00 61.99           N  
ATOM    909  CA  GLY B  26      34.176  16.200  44.567  1.00 60.70           C  
ATOM    910  C   GLY B  26      34.322  15.616  45.974  1.00 58.38           C  
ATOM    911  O   GLY B  26      33.531  15.919  46.865  1.00 57.86           O  
ATOM    912  N   THR B  27      35.334  14.774  46.158  1.00 57.31           N  
ATOM    913  CA  THR B  27      35.589  14.096  47.427  1.00 55.63           C  
ATOM    914  C   THR B  27      36.269  15.019  48.436  1.00 53.35           C  
ATOM    915  O   THR B  27      37.065  15.883  48.058  1.00 53.19           O  
ATOM    916  CB  THR B  27      36.460  12.840  47.176  1.00 55.88           C  
ATOM    917  OG1 THR B  27      35.765  11.963  46.281  1.00 59.17           O  
ATOM    918  CG2 THR B  27      36.752  12.083  48.458  1.00 55.14           C  
ATOM    919  N   VAL B  28      35.960  14.825  49.728  1.00 51.35           N  
ATOM    920  CA  VAL B  28      36.585  15.606  50.778  1.00 48.96           C  
ATOM    921  C   VAL B  28      37.951  14.985  51.069  1.00 49.03           C  
ATOM    922  O   VAL B  28      38.057  13.866  51.560  1.00 48.14           O  
ATOM    923  CB  VAL B  28      35.701  15.686  52.061  1.00 48.45           C  
ATOM    924  CG1 VAL B  28      36.446  16.376  53.175  1.00 46.84           C  
ATOM    925  CG2 VAL B  28      34.374  16.417  51.760  1.00 46.59           C  
ATOM    926  N   ILE B  29      39.003  15.730  50.765  1.00 49.06           N  
ATOM    927  CA  ILE B  29      40.357  15.198  50.874  1.00 49.16           C  
ATOM    928  C   ILE B  29      41.079  15.701  52.102  1.00 47.50           C  
ATOM    929  O   ILE B  29      42.091  15.136  52.507  1.00 47.45           O  
ATOM    930  CB  ILE B  29      41.163  15.440  49.578  1.00 50.22           C  
ATOM    931  CG1 ILE B  29      41.255  16.927  49.238  1.00 51.10           C  
ATOM    932  CG2 ILE B  29      40.494  14.712  48.449  1.00 51.98           C  
ATOM    933  CD1 ILE B  29      42.248  17.227  48.121  1.00 52.70           C  
ATOM    934  N   TYR B  30      40.549  16.758  52.706  1.00 46.15           N  
ATOM    935  CA  TYR B  30      41.056  17.201  53.976  1.00 45.17           C  
ATOM    936  C   TYR B  30      39.978  17.986  54.751  1.00 44.20           C  
ATOM    937  O   TYR B  30      39.243  18.777  54.164  1.00 44.82           O  
ATOM    938  CB  TYR B  30      42.318  18.039  53.765  1.00 45.78           C  
ATOM    939  CG  TYR B  30      43.006  18.470  55.023  1.00 45.19           C  
ATOM    940  CD1 TYR B  30      43.772  17.581  55.739  1.00 46.31           C  
ATOM    941  CD2 TYR B  30      42.897  19.771  55.489  1.00 44.75           C  
ATOM    942  CE1 TYR B  30      44.407  17.962  56.886  1.00 46.01           C  
ATOM    943  CE2 TYR B  30      43.539  20.159  56.618  1.00 44.57           C  
ATOM    944  CZ  TYR B  30      44.292  19.248  57.313  1.00 45.75           C  
ATOM    945  OH  TYR B  30      44.929  19.612  58.465  1.00 47.28           O  
ATOM    946  N   VAL B  31      39.877  17.705  56.053  1.00 43.04           N  
ATOM    947  CA  VAL B  31      39.065  18.486  57.001  1.00 41.44           C  
ATOM    948  C   VAL B  31      39.992  19.192  58.009  1.00 40.62           C  
ATOM    949  O   VAL B  31      40.821  18.573  58.676  1.00 41.28           O  
ATOM    950  CB  VAL B  31      38.063  17.608  57.764  1.00 40.95           C  
ATOM    951  CG1 VAL B  31      37.285  18.436  58.792  1.00 40.41           C  
ATOM    952  CG2 VAL B  31      37.103  16.962  56.807  1.00 41.23           C  
ATOM    953  N   GLY B  32      39.857  20.501  58.123  1.00 40.36           N  
ATOM    954  CA  GLY B  32      40.643  21.237  59.082  1.00 40.08           C  
ATOM    955  C   GLY B  32      39.808  22.127  59.966  1.00 39.39           C  
ATOM    956  O   GLY B  32      38.676  22.412  59.686  1.00 37.60           O  
ATOM    957  N   LYS B  33      40.414  22.587  61.032  1.00 40.70           N  
ATOM    958  CA  LYS B  33      39.774  23.483  61.957  1.00 42.33           C  
ATOM    959  C   LYS B  33      40.500  24.806  61.861  1.00 43.24           C  
ATOM    960  O   LYS B  33      41.733  24.832  61.779  1.00 44.30           O  
ATOM    961  CB  LYS B  33      39.887  22.893  63.367  1.00 42.62           C  
ATOM    962  CG  LYS B  33      39.572  23.841  64.479  1.00 45.82           C  
ATOM    963  CD  LYS B  33      40.258  23.429  65.765  1.00 49.51           C  
ATOM    964  CE  LYS B  33      40.548  24.659  66.647  1.00 53.31           C  
ATOM    965  NZ  LYS B  33      39.353  25.249  67.333  1.00 54.94           N  
ATOM    966  N   ALA B  34      39.741  25.897  61.890  1.00 43.71           N  
ATOM    967  CA  ALA B  34      40.279  27.251  61.888  1.00 44.33           C  
ATOM    968  C   ALA B  34      39.696  28.098  63.027  1.00 44.58           C  
ATOM    969  O   ALA B  34      38.490  28.058  63.275  1.00 43.55           O  
ATOM    970  CB  ALA B  34      39.942  27.917  60.575  1.00 44.82           C  
ATOM    971  N   LYS B  35      40.559  28.863  63.697  1.00 45.79           N  
ATOM    972  CA  LYS B  35      40.145  29.984  64.563  1.00 46.64           C  
ATOM    973  C   LYS B  35      39.586  31.146  63.708  1.00 46.37           C  
ATOM    974  O   LYS B  35      38.731  31.922  64.156  1.00 46.01           O  
ATOM    975  CB  LYS B  35      41.326  30.484  65.387  1.00 48.18           C  
ATOM    976  CG  LYS B  35      41.699  29.575  66.553  1.00 49.80           C  
ATOM    977  CD  LYS B  35      43.177  29.664  66.890  1.00 53.27           C  
ATOM    978  CE  LYS B  35      43.610  28.622  67.944  1.00 54.25           C  
ATOM    979  NZ  LYS B  35      43.314  29.105  69.333  1.00 56.94           N  
ATOM    980  N   SER B  36      40.097  31.258  62.486  1.00 46.97           N  
ATOM    981  CA  SER B  36      39.544  32.170  61.482  1.00 47.61           C  
ATOM    982  C   SER B  36      39.609  31.487  60.120  1.00 47.72           C  
ATOM    983  O   SER B  36      40.687  31.271  59.569  1.00 48.29           O  
ATOM    984  CB  SER B  36      40.286  33.505  61.469  1.00 48.98           C  
ATOM    985  OG  SER B  36      39.849  34.337  60.396  1.00 50.61           O  
ATOM    986  N   LEU B  37      38.439  31.133  59.600  1.00 47.54           N  
ATOM    987  CA  LEU B  37      38.310  30.480  58.303  1.00 48.51           C  
ATOM    988  C   LEU B  37      38.979  31.306  57.194  1.00 50.68           C  
ATOM    989  O   LEU B  37      39.729  30.764  56.378  1.00 50.28           O  
ATOM    990  CB  LEU B  37      36.824  30.248  57.976  1.00 47.88           C  
ATOM    991  CG  LEU B  37      36.186  29.119  58.818  1.00 46.27           C  
ATOM    992  CD1 LEU B  37      34.712  29.110  58.682  1.00 46.27           C  
ATOM    993  CD2 LEU B  37      36.748  27.780  58.398  1.00 45.58           C  
ATOM    994  N   LYS B  38      38.710  32.613  57.189  1.00 52.78           N  
ATOM    995  CA  LYS B  38      39.273  33.541  56.188  1.00 54.94           C  
ATOM    996  C   LYS B  38      40.779  33.410  56.063  1.00 56.31           C  
ATOM    997  O   LYS B  38      41.255  33.058  55.002  1.00 58.00           O  
ATOM    998  CB  LYS B  38      38.894  34.987  56.517  1.00 55.61           C  
ATOM    999  CG  LYS B  38      39.563  36.062  55.609  1.00 57.25           C  
ATOM   1000  CD  LYS B  38      38.693  37.348  55.541  1.00 58.94           C  
ATOM   1001  CE  LYS B  38      39.531  38.619  55.504  1.00 61.54           C  
ATOM   1002  NZ  LYS B  38      38.688  39.858  55.433  1.00 63.77           N  
ATOM   1003  N   GLU B  39      41.518  33.676  57.141  1.00 57.41           N  
ATOM   1004  CA  GLU B  39      42.983  33.553  57.126  1.00 59.33           C  
ATOM   1005  C   GLU B  39      43.402  32.131  56.723  1.00 59.24           C  
ATOM   1006  O   GLU B  39      44.099  31.950  55.734  1.00 59.56           O  
ATOM   1007  CB  GLU B  39      43.669  33.868  58.477  1.00 59.77           C  
ATOM   1008  CG  GLU B  39      42.833  34.433  59.604  1.00 61.53           C  
ATOM   1009  CD  GLU B  39      42.637  35.938  59.580  1.00 64.86           C  
ATOM   1010  OE1 GLU B  39      43.639  36.664  59.406  1.00 69.15           O  
ATOM   1011  OE2 GLU B  39      41.483  36.397  59.788  1.00 66.09           O  
ATOM   1012  N   ARG B  40      42.970  31.130  57.499  1.00 58.83           N  
ATOM   1013  CA  ARG B  40      43.413  29.740  57.294  1.00 58.96           C  
ATOM   1014  C   ARG B  40      43.264  29.204  55.885  1.00 59.18           C  
ATOM   1015  O   ARG B  40      44.228  28.701  55.317  1.00 60.38           O  
ATOM   1016  CB  ARG B  40      42.729  28.770  58.260  1.00 58.21           C  
ATOM   1017  CG  ARG B  40      43.523  28.545  59.519  1.00 60.77           C  
ATOM   1018  CD  ARG B  40      44.710  27.642  59.245  1.00 64.12           C  
ATOM   1019  NE  ARG B  40      45.708  27.710  60.307  1.00 65.68           N  
ATOM   1020  CZ  ARG B  40      45.592  27.128  61.501  1.00 66.56           C  
ATOM   1021  NH1 ARG B  40      44.496  26.446  61.835  1.00 65.06           N  
ATOM   1022  NH2 ARG B  40      46.583  27.240  62.378  1.00 68.34           N  
ATOM   1023  N   VAL B  41      42.058  29.276  55.338  1.00 58.54           N  
ATOM   1024  CA  VAL B  41      41.808  28.742  54.008  1.00 59.39           C  
ATOM   1025  C   VAL B  41      42.679  29.477  52.957  1.00 61.38           C  
ATOM   1026  O   VAL B  41      43.326  28.843  52.121  1.00 61.43           O  
ATOM   1027  CB  VAL B  41      40.315  28.824  53.626  1.00 58.99           C  
ATOM   1028  CG1 VAL B  41      40.084  28.261  52.214  1.00 60.14           C  
ATOM   1029  CG2 VAL B  41      39.426  28.080  54.652  1.00 58.16           C  
ATOM   1030  N   ARG B  42      42.705  30.807  53.020  1.00 62.83           N  
ATOM   1031  CA  ARG B  42      43.528  31.593  52.093  1.00 65.14           C  
ATOM   1032  C   ARG B  42      45.014  31.264  52.218  1.00 66.42           C  
ATOM   1033  O   ARG B  42      45.714  31.229  51.206  1.00 68.33           O  
ATOM   1034  CB  ARG B  42      43.321  33.096  52.296  1.00 65.72           C  
ATOM   1035  CG  ARG B  42      41.960  33.634  51.861  1.00 65.88           C  
ATOM   1036  CD  ARG B  42      41.903  35.140  52.092  1.00 67.38           C  
ATOM   1037  NE  ARG B  42      40.580  35.731  51.887  1.00 67.67           N  
ATOM   1038  CZ  ARG B  42      40.299  37.016  52.112  1.00 69.75           C  
ATOM   1039  NH1 ARG B  42      41.244  37.847  52.549  1.00 71.39           N  
ATOM   1040  NH2 ARG B  42      39.072  37.486  51.894  1.00 69.31           N  
ATOM   1041  N   SER B  43      45.490  31.015  53.440  1.00 66.53           N  
ATOM   1042  CA  SER B  43      46.907  30.680  53.680  1.00 68.12           C  
ATOM   1043  C   SER B  43      47.436  29.553  52.773  1.00 69.50           C  
ATOM   1044  O   SER B  43      48.629  29.517  52.460  1.00 70.77           O  
ATOM   1045  CB  SER B  43      47.145  30.278  55.145  1.00 67.36           C  
ATOM   1046  OG  SER B  43      46.815  28.907  55.373  1.00 65.61           O  
ATOM   1047  N   TYR B  44      46.549  28.635  52.376  1.00 69.61           N  
ATOM   1048  CA  TYR B  44      46.908  27.492  51.517  1.00 70.80           C  
ATOM   1049  C   TYR B  44      47.362  27.886  50.119  1.00 73.53           C  
ATOM   1050  O   TYR B  44      48.110  27.143  49.474  1.00 74.67           O  
ATOM   1051  CB  TYR B  44      45.724  26.529  51.385  1.00 69.14           C  
ATOM   1052  CG  TYR B  44      45.542  25.661  52.603  1.00 67.73           C  
ATOM   1053  CD1 TYR B  44      46.226  24.456  52.722  1.00 67.53           C  
ATOM   1054  CD2 TYR B  44      44.699  26.045  53.643  1.00 66.32           C  
ATOM   1055  CE1 TYR B  44      46.082  23.652  53.835  1.00 66.27           C  
ATOM   1056  CE2 TYR B  44      44.546  25.243  54.762  1.00 65.27           C  
ATOM   1057  CZ  TYR B  44      45.241  24.045  54.851  1.00 65.40           C  
ATOM   1058  OH  TYR B  44      45.117  23.237  55.956  1.00 64.32           O  
ATOM   1059  N   PHE B  45      46.903  29.046  49.657  1.00 75.25           N  
ATOM   1060  CA  PHE B  45      47.168  29.504  48.306  1.00 77.96           C  
ATOM   1061  C   PHE B  45      48.013  30.776  48.296  1.00 80.36           C  
ATOM   1062  O   PHE B  45      47.921  31.583  47.369  1.00 81.94           O  
ATOM   1063  CB  PHE B  45      45.834  29.741  47.602  1.00 77.85           C  
ATOM   1064  CG  PHE B  45      44.803  28.700  47.913  1.00 76.17           C  
ATOM   1065  CD1 PHE B  45      43.788  28.960  48.827  1.00 75.29           C  
ATOM   1066  CD2 PHE B  45      44.862  27.447  47.317  1.00 76.26           C  
ATOM   1067  CE1 PHE B  45      42.830  28.003  49.120  1.00 73.80           C  
ATOM   1068  CE2 PHE B  45      43.915  26.482  47.603  1.00 75.55           C  
ATOM   1069  CZ  PHE B  45      42.893  26.759  48.515  1.00 74.41           C  
ATOM   1070  N   THR B  46      48.834  30.948  49.329  1.00 81.16           N  
ATOM   1071  CA  THR B  46      49.733  32.098  49.419  1.00 83.46           C  
ATOM   1072  C   THR B  46      50.969  31.739  50.246  1.00 84.38           C  
ATOM   1073  O   THR B  46      50.905  30.873  51.131  1.00 83.29           O  
ATOM   1074  CB  THR B  46      49.027  33.360  50.006  1.00 83.11           C  
ATOM   1075  OG1 THR B  46      49.948  34.460  50.026  1.00 85.48           O  
ATOM   1076  CG2 THR B  46      48.509  33.120  51.423  1.00 81.53           C  
ATOM   1077  N   GLY B  47      52.088  32.399  49.936  1.00 86.68           N  
ATOM   1078  CA  GLY B  47      53.365  32.147  50.606  1.00 87.80           C  
ATOM   1079  C   GLY B  47      53.954  30.806  50.203  1.00 88.22           C  
ATOM   1080  O   GLY B  47      53.415  30.121  49.332  1.00 87.86           O  
ATOM   1081  N   THR B  48      55.065  30.430  50.835  1.00 89.28           N  
ATOM   1082  CA  THR B  48      55.699  29.138  50.568  1.00 89.92           C  
ATOM   1083  C   THR B  48      54.951  28.052  51.337  1.00 87.78           C  
ATOM   1084  O   THR B  48      54.090  28.355  52.170  1.00 86.33           O  
ATOM   1085  CB  THR B  48      57.186  29.128  50.969  1.00 91.96           C  
ATOM   1086  N   HIS B  49      55.265  26.794  51.043  1.00 87.73           N  
ATOM   1087  CA  HIS B  49      54.625  25.652  51.709  1.00 85.71           C  
ATOM   1088  C   HIS B  49      55.547  24.430  51.773  1.00 86.12           C  
ATOM   1089  O   HIS B  49      56.366  24.216  50.873  1.00 87.98           O  
ATOM   1090  CB  HIS B  49      53.335  25.256  50.977  1.00 84.33           C  
ATOM   1091  CG  HIS B  49      52.204  26.215  51.177  1.00 83.43           C  
ATOM   1092  ND1 HIS B  49      51.400  26.188  52.296  1.00 82.54           N  
ATOM   1093  CD2 HIS B  49      51.742  27.225  50.403  1.00 84.30           C  
ATOM   1094  CE1 HIS B  49      50.490  27.140  52.203  1.00 81.91           C  
ATOM   1095  NE2 HIS B  49      50.675  27.785  51.064  1.00 83.23           N  
ATOM   1096  N   ASP B  50      55.405  23.636  52.837  1.00 84.14           N  
ATOM   1097  CA  ASP B  50      56.112  22.359  52.925  1.00 84.28           C  
ATOM   1098  C   ASP B  50      55.588  21.446  51.827  1.00 82.76           C  
ATOM   1099  O   ASP B  50      54.490  21.671  51.296  1.00 81.04           O  
ATOM   1100  CB  ASP B  50      55.941  21.684  54.296  1.00 83.48           C  
ATOM   1101  CG  ASP B  50      54.483  21.436  54.656  1.00 81.45           C  
ATOM   1102  OD1 ASP B  50      53.830  22.381  55.157  1.00 81.00           O  
ATOM   1103  OD2 ASP B  50      53.998  20.296  54.456  1.00 80.33           O  
ATOM   1104  N   GLY B  51      56.385  20.430  51.494  1.00 82.75           N  
ATOM   1105  CA  GLY B  51      56.057  19.483  50.431  1.00 81.66           C  
ATOM   1106  C   GLY B  51      54.745  18.751  50.627  1.00 78.36           C  
ATOM   1107  O   GLY B  51      53.906  18.741  49.729  1.00 77.16           O  
ATOM   1108  N   LYS B  52      54.574  18.131  51.794  1.00 76.64           N  
ATOM   1109  CA  LYS B  52      53.333  17.417  52.124  1.00 74.09           C  
ATOM   1110  C   LYS B  52      52.107  18.308  51.897  1.00 71.90           C  
ATOM   1111  O   LYS B  52      51.126  17.878  51.296  1.00 70.74           O  
ATOM   1112  CB  LYS B  52      53.342  16.950  53.576  1.00 73.49           C  
ATOM   1113  CG  LYS B  52      54.177  15.733  53.884  1.00 74.67           C  
ATOM   1114  CD  LYS B  52      54.352  15.590  55.398  1.00 74.88           C  
ATOM   1115  CE  LYS B  52      54.679  14.170  55.832  1.00 76.12           C  
ATOM   1116  NZ  LYS B  52      53.463  13.300  55.805  1.00 75.06           N  
ATOM   1117  N   THR B  53      52.177  19.549  52.381  1.00 71.33           N  
ATOM   1118  CA  THR B  53      51.087  20.523  52.218  1.00 69.59           C  
ATOM   1119  C   THR B  53      50.932  20.984  50.766  1.00 70.10           C  
ATOM   1120  O   THR B  53      49.822  21.236  50.301  1.00 68.48           O  
ATOM   1121  CB  THR B  53      51.304  21.768  53.106  1.00 69.57           C  
ATOM   1122  OG1 THR B  53      51.419  21.371  54.479  1.00 68.87           O  
ATOM   1123  CG2 THR B  53      50.147  22.751  52.958  1.00 67.93           C  
ATOM   1124  N   GLN B  54      52.054  21.085  50.053  1.00 71.95           N  
ATOM   1125  CA  GLN B  54      52.037  21.517  48.663  1.00 72.87           C  
ATOM   1126  C   GLN B  54      51.244  20.540  47.784  1.00 71.96           C  
ATOM   1127  O   GLN B  54      50.499  20.964  46.907  1.00 72.11           O  
ATOM   1128  CB  GLN B  54      53.473  21.686  48.138  1.00 75.60           C  
ATOM   1129  CG  GLN B  54      53.725  23.006  47.436  1.00 77.47           C  
ATOM   1130  CD  GLN B  54      55.158  23.491  47.614  1.00 80.98           C  
ATOM   1131  OE1 GLN B  54      56.115  22.769  47.326  1.00 83.87           O  
ATOM   1132  NE2 GLN B  54      55.308  24.723  48.094  1.00 81.77           N  
ATOM   1133  N   ARG B  55      51.397  19.241  48.029  1.00 71.37           N  
ATOM   1134  CA  ARG B  55      50.670  18.217  47.264  1.00 70.87           C  
ATOM   1135  C   ARG B  55      49.161  18.346  47.431  1.00 68.64           C  
ATOM   1136  O   ARG B  55      48.410  18.324  46.451  1.00 68.32           O  
ATOM   1137  CB  ARG B  55      51.113  16.810  47.683  1.00 71.18           C  
ATOM   1138  N   LEU B  56      48.724  18.465  48.685  1.00 66.99           N  
ATOM   1139  CA  LEU B  56      47.312  18.698  48.988  1.00 65.18           C  
ATOM   1140  C   LEU B  56      46.779  19.876  48.167  1.00 65.51           C  
ATOM   1141  O   LEU B  56      45.722  19.763  47.531  1.00 64.58           O  
ATOM   1142  CB  LEU B  56      47.127  18.953  50.492  1.00 64.05           C  
ATOM   1143  CG  LEU B  56      45.794  19.540  50.991  1.00 62.61           C  
ATOM   1144  CD1 LEU B  56      44.572  18.722  50.549  1.00 60.95           C  
ATOM   1145  CD2 LEU B  56      45.833  19.680  52.513  1.00 61.34           C  
ATOM   1146  N   VAL B  57      47.534  20.981  48.160  1.00 66.32           N  
ATOM   1147  CA  VAL B  57      47.144  22.206  47.443  1.00 67.30           C  
ATOM   1148  C   VAL B  57      46.925  21.995  45.948  1.00 68.53           C  
ATOM   1149  O   VAL B  57      45.945  22.492  45.393  1.00 68.33           O  
ATOM   1150  CB  VAL B  57      48.174  23.348  47.635  1.00 68.44           C  
ATOM   1151  CG1 VAL B  57      47.837  24.538  46.744  1.00 69.58           C  
ATOM   1152  CG2 VAL B  57      48.222  23.796  49.099  1.00 67.72           C  
ATOM   1153  N   GLU B  58      47.842  21.273  45.302  1.00 70.03           N  
ATOM   1154  CA  GLU B  58      47.723  20.982  43.866  1.00 71.75           C  
ATOM   1155  C   GLU B  58      46.491  20.131  43.595  1.00 71.01           C  
ATOM   1156  O   GLU B  58      45.856  20.257  42.544  1.00 71.72           O  
ATOM   1157  CB  GLU B  58      48.979  20.272  43.336  1.00 73.25           C  
ATOM   1158  N   GLU B  59      46.142  19.286  44.566  1.00 69.72           N  
ATOM   1159  CA  GLU B  59      45.001  18.396  44.426  1.00 69.22           C  
ATOM   1160  C   GLU B  59      43.662  19.090  44.708  1.00 68.21           C  
ATOM   1161  O   GLU B  59      42.634  18.680  44.157  1.00 68.90           O  
ATOM   1162  CB  GLU B  59      45.180  17.179  45.336  1.00 68.12           C  
ATOM   1163  CG  GLU B  59      44.323  15.988  44.934  1.00 68.32           C  
ATOM   1164  CD  GLU B  59      44.777  14.698  45.583  1.00 68.04           C  
ATOM   1165  OE1 GLU B  59      45.908  14.671  46.117  1.00 68.46           O  
ATOM   1166  OE2 GLU B  59      44.004  13.715  45.571  1.00 68.78           O  
ATOM   1167  N   ILE B  60      43.686  20.138  45.543  1.00 66.98           N  
ATOM   1168  CA  ILE B  60      42.474  20.876  45.941  1.00 65.61           C  
ATOM   1169  C   ILE B  60      41.800  21.600  44.775  1.00 65.91           C  
ATOM   1170  O   ILE B  60      42.347  22.559  44.211  1.00 67.54           O  
ATOM   1171  CB  ILE B  60      42.771  21.925  47.049  1.00 64.89           C  
ATOM   1172  CG1 ILE B  60      43.062  21.238  48.378  1.00 63.67           C  
ATOM   1173  CG2 ILE B  60      41.599  22.889  47.238  1.00 64.97           C  
ATOM   1174  CD1 ILE B  60      43.744  22.156  49.408  1.00 63.35           C  
ATOM   1175  N   ALA B  61      40.591  21.155  44.450  1.00 64.53           N  
ATOM   1176  CA  ALA B  61      39.790  21.774  43.404  1.00 64.88           C  
ATOM   1177  C   ALA B  61      38.718  22.700  43.953  1.00 63.30           C  
ATOM   1178  O   ALA B  61      38.358  23.670  43.307  1.00 64.21           O  
ATOM   1179  CB  ALA B  61      39.149  20.706  42.559  1.00 65.97           C  
ATOM   1180  N   ASP B  62      38.211  22.416  45.157  1.00 60.55           N  
ATOM   1181  CA  ASP B  62      37.080  23.162  45.692  1.00 58.76           C  
ATOM   1182  C   ASP B  62      37.058  23.019  47.229  1.00 56.57           C  
ATOM   1183  O   ASP B  62      37.932  22.363  47.789  1.00 55.30           O  
ATOM   1184  CB  ASP B  62      35.805  22.601  45.050  1.00 58.94           C  
ATOM   1185  CG  ASP B  62      34.552  23.356  45.442  1.00 58.39           C  
ATOM   1186  OD1 ASP B  62      34.641  24.533  45.846  1.00 58.23           O  
ATOM   1187  OD2 ASP B  62      33.466  22.755  45.352  1.00 59.45           O  
ATOM   1188  N   PHE B  63      36.097  23.668  47.886  1.00 55.67           N  
ATOM   1189  CA  PHE B  63      35.931  23.578  49.347  1.00 53.91           C  
ATOM   1190  C   PHE B  63      34.609  24.153  49.844  1.00 53.35           C  
ATOM   1191  O   PHE B  63      33.973  24.963  49.176  1.00 54.21           O  
ATOM   1192  CB  PHE B  63      37.051  24.341  50.075  1.00 53.62           C  
ATOM   1193  CG  PHE B  63      36.972  25.830  49.907  1.00 54.55           C  
ATOM   1194  CD1 PHE B  63      36.118  26.594  50.709  1.00 53.66           C  
ATOM   1195  CD2 PHE B  63      37.751  26.478  48.937  1.00 56.49           C  
ATOM   1196  CE1 PHE B  63      36.031  27.965  50.555  1.00 55.42           C  
ATOM   1197  CE2 PHE B  63      37.670  27.863  48.774  1.00 56.70           C  
ATOM   1198  CZ  PHE B  63      36.806  28.611  49.582  1.00 55.98           C  
ATOM   1199  N   GLU B  64      34.226  23.750  51.057  1.00 51.38           N  
ATOM   1200  CA  GLU B  64      33.152  24.414  51.772  1.00 51.00           C  
ATOM   1201  C   GLU B  64      33.618  24.591  53.211  1.00 48.33           C  
ATOM   1202  O   GLU B  64      34.657  24.074  53.608  1.00 47.69           O  
ATOM   1203  CB  GLU B  64      31.832  23.619  51.721  1.00 51.91           C  
ATOM   1204  CG  GLU B  64      30.532  24.483  51.323  1.00 55.46           C  
ATOM   1205  CD  GLU B  64      30.291  25.787  52.142  1.00 56.92           C  
ATOM   1206  OE1 GLU B  64      31.098  26.745  52.059  1.00 58.40           O  
ATOM   1207  OE2 GLU B  64      29.260  25.876  52.843  1.00 58.15           O  
ATOM   1208  N   TYR B  65      32.851  25.340  53.977  1.00 47.08           N  
ATOM   1209  CA  TYR B  65      33.144  25.542  55.386  1.00 45.35           C  
ATOM   1210  C   TYR B  65      31.855  25.559  56.194  1.00 44.20           C  
ATOM   1211  O   TYR B  65      30.774  25.807  55.648  1.00 43.97           O  
ATOM   1212  CB  TYR B  65      33.900  26.851  55.591  1.00 45.97           C  
ATOM   1213  CG  TYR B  65      33.160  28.051  55.074  1.00 47.16           C  
ATOM   1214  CD1 TYR B  65      33.345  28.488  53.756  1.00 49.81           C  
ATOM   1215  CD2 TYR B  65      32.250  28.736  55.874  1.00 46.31           C  
ATOM   1216  CE1 TYR B  65      32.684  29.587  53.272  1.00 49.60           C  
ATOM   1217  CE2 TYR B  65      31.580  29.831  55.398  1.00 49.29           C  
ATOM   1218  CZ  TYR B  65      31.801  30.253  54.080  1.00 51.04           C  
ATOM   1219  OH  TYR B  65      31.139  31.350  53.559  1.00 53.35           O  
ATOM   1220  N   ILE B  66      31.990  25.260  57.486  1.00 41.76           N  
ATOM   1221  CA  ILE B  66      30.904  25.372  58.437  1.00 40.29           C  
ATOM   1222  C   ILE B  66      31.443  26.302  59.524  1.00 39.05           C  
ATOM   1223  O   ILE B  66      32.515  26.078  60.064  1.00 37.68           O  
ATOM   1224  CB  ILE B  66      30.493  24.008  59.000  1.00 39.82           C  
ATOM   1225  CG1 ILE B  66      30.074  23.070  57.865  1.00 40.98           C  
ATOM   1226  CG2 ILE B  66      29.347  24.137  59.986  1.00 39.27           C  
ATOM   1227  CD1 ILE B  66      29.780  21.646  58.310  1.00 40.45           C  
ATOM   1228  N   VAL B  67      30.718  27.381  59.792  1.00 38.33           N  
ATOM   1229  CA  VAL B  67      31.136  28.356  60.754  1.00 38.48           C  
ATOM   1230  C   VAL B  67      30.675  27.841  62.113  1.00 37.41           C  
ATOM   1231  O   VAL B  67      29.708  27.084  62.190  1.00 37.17           O  
ATOM   1232  CB  VAL B  67      30.551  29.740  60.413  1.00 40.17           C  
ATOM   1233  CG1 VAL B  67      30.740  30.708  61.537  1.00 41.18           C  
ATOM   1234  CG2 VAL B  67      31.234  30.293  59.141  1.00 41.90           C  
ATOM   1235  N   THR B  68      31.398  28.188  63.171  1.00 36.06           N  
ATOM   1236  CA  THR B  68      30.998  27.760  64.504  1.00 35.24           C  
ATOM   1237  C   THR B  68      31.015  28.967  65.400  1.00 35.37           C  
ATOM   1238  O   THR B  68      31.544  30.004  65.025  1.00 35.20           O  
ATOM   1239  CB  THR B  68      31.886  26.647  65.093  1.00 34.64           C  
ATOM   1240  OG1 THR B  68      33.234  27.083  65.147  1.00 33.59           O  
ATOM   1241  CG2 THR B  68      31.795  25.394  64.266  1.00 33.18           C  
ATOM   1242  N   SER B  69      30.409  28.818  66.569  1.00 35.23           N  
ATOM   1243  CA  SER B  69      30.277  29.901  67.537  1.00 35.97           C  
ATOM   1244  C   SER B  69      31.458  29.983  68.453  1.00 34.69           C  
ATOM   1245  O   SER B  69      31.635  30.979  69.125  1.00 34.96           O  
ATOM   1246  CB  SER B  69      29.015  29.714  68.397  1.00 37.41           C  
ATOM   1247  OG  SER B  69      29.084  28.498  69.114  1.00 41.60           O  
ATOM   1248  N   SER B  70      32.284  28.949  68.483  1.00 33.06           N  
ATOM   1249  CA  SER B  70      33.455  28.941  69.360  1.00 31.73           C  
ATOM   1250  C   SER B  70      34.546  28.018  68.801  1.00 30.47           C  
ATOM   1251  O   SER B  70      34.310  27.232  67.890  1.00 29.20           O  
ATOM   1252  CB  SER B  70      33.053  28.502  70.763  1.00 31.30           C  
ATOM   1253  OG  SER B  70      32.576  27.159  70.760  1.00 29.38           O  
ATOM   1254  N   ASN B  71      35.744  28.142  69.347  1.00 30.83           N  
ATOM   1255  CA  ASN B  71      36.833  27.223  69.022  1.00 30.93           C  
ATOM   1256  C   ASN B  71      36.522  25.807  69.536  1.00 29.71           C  
ATOM   1257  O   ASN B  71      36.867  24.829  68.878  1.00 29.77           O  
ATOM   1258  CB  ASN B  71      38.155  27.705  69.613  1.00 32.97           C  
ATOM   1259  CG  ASN B  71      38.676  28.981  68.949  1.00 36.18           C  
ATOM   1260  OD1 ASN B  71      38.561  29.175  67.720  1.00 38.88           O  
ATOM   1261  ND2 ASN B  71      39.252  29.859  69.759  1.00 39.04           N  
ATOM   1262  N   ALA B  72      35.926  25.708  70.720  1.00 28.30           N  
ATOM   1263  CA  ALA B  72      35.436  24.417  71.239  1.00 28.38           C  
ATOM   1264  C   ALA B  72      34.524  23.718  70.259  1.00 27.10           C  
ATOM   1265  O   ALA B  72      34.700  22.541  69.965  1.00 26.74           O  
ATOM   1266  CB  ALA B  72      34.691  24.612  72.527  1.00 27.85           C  
ATOM   1267  N   GLU B  73      33.540  24.446  69.761  1.00 26.77           N  
ATOM   1268  CA  GLU B  73      32.619  23.878  68.787  1.00 27.69           C  
ATOM   1269  C   GLU B  73      33.313  23.491  67.494  1.00 26.74           C  
ATOM   1270  O   GLU B  73      32.989  22.461  66.922  1.00 27.18           O  
ATOM   1271  CB  GLU B  73      31.451  24.799  68.518  1.00 28.45           C  
ATOM   1272  CG  GLU B  73      30.381  24.114  67.674  1.00 31.34           C  
ATOM   1273  CD  GLU B  73      29.154  24.957  67.509  1.00 36.77           C  
ATOM   1274  OE1 GLU B  73      28.074  24.472  67.879  1.00 40.12           O  
ATOM   1275  OE2 GLU B  73      29.277  26.103  67.057  1.00 39.29           O  
ATOM   1276  N   ALA B  74      34.293  24.275  67.050  1.00 27.13           N  
ATOM   1277  CA  ALA B  74      35.063  23.913  65.862  1.00 26.43           C  
ATOM   1278  C   ALA B  74      35.834  22.611  66.030  1.00 26.49           C  
ATOM   1279  O   ALA B  74      35.940  21.837  65.078  1.00 27.44           O  
ATOM   1280  CB  ALA B  74      36.006  25.024  65.447  1.00 26.86           C  
ATOM   1281  N   LEU B  75      36.371  22.376  67.217  1.00 27.77           N  
ATOM   1282  CA  LEU B  75      37.116  21.156  67.468  1.00 29.03           C  
ATOM   1283  C   LEU B  75      36.198  19.930  67.456  1.00 27.82           C  
ATOM   1284  O   LEU B  75      36.533  18.893  66.853  1.00 28.44           O  
ATOM   1285  CB  LEU B  75      37.889  21.229  68.782  1.00 30.52           C  
ATOM   1286  CG  LEU B  75      38.882  20.050  68.778  1.00 36.80           C  
ATOM   1287  CD1 LEU B  75      40.334  20.501  68.907  1.00 40.76           C  
ATOM   1288  CD2 LEU B  75      38.473  18.998  69.784  1.00 38.50           C  
ATOM   1289  N   ILE B  76      35.044  20.052  68.109  1.00 25.50           N  
ATOM   1290  CA  ILE B  76      34.068  18.953  68.150  1.00 24.83           C  
ATOM   1291  C   ILE B  76      33.572  18.657  66.716  1.00 26.08           C  
ATOM   1292  O   ILE B  76      33.510  17.482  66.269  1.00 25.19           O  
ATOM   1293  CB  ILE B  76      32.900  19.333  69.060  1.00 24.61           C  
ATOM   1294  CG1 ILE B  76      33.386  19.486  70.520  1.00 22.35           C  
ATOM   1295  CG2 ILE B  76      31.738  18.286  68.971  1.00 23.56           C  
ATOM   1296  CD1 ILE B  76      32.500  20.303  71.418  1.00 24.66           C  
ATOM   1297  N   LEU B  77      33.233  19.726  66.001  1.00 26.14           N  
ATOM   1298  CA  LEU B  77      32.834  19.611  64.575  1.00 26.86           C  
ATOM   1299  C   LEU B  77      33.910  18.921  63.756  1.00 28.22           C  
ATOM   1300  O   LEU B  77      33.619  18.013  62.981  1.00 29.34           O  
ATOM   1301  CB  LEU B  77      32.513  20.980  63.989  1.00 26.63           C  
ATOM   1302  CG  LEU B  77      32.031  20.938  62.528  1.00 26.35           C  
ATOM   1303  CD1 LEU B  77      30.760  20.110  62.440  1.00 26.88           C  
ATOM   1304  CD2 LEU B  77      31.822  22.323  61.937  1.00 28.01           C  
ATOM   1305  N   GLU B  78      35.156  19.380  63.908  1.00 29.92           N  
ATOM   1306  CA  GLU B  78      36.289  18.800  63.211  1.00 29.97           C  
ATOM   1307  C   GLU B  78      36.339  17.297  63.324  1.00 29.52           C  
ATOM   1308  O   GLU B  78      36.482  16.607  62.335  1.00 28.71           O  
ATOM   1309  CB  GLU B  78      37.610  19.388  63.718  1.00 31.35           C  
ATOM   1310  CG  GLU B  78      38.837  18.778  63.052  1.00 32.49           C  
ATOM   1311  CD  GLU B  78      40.147  19.237  63.674  1.00 35.10           C  
ATOM   1312  OE1 GLU B  78      40.192  19.681  64.849  1.00 35.88           O  
ATOM   1313  OE2 GLU B  78      41.149  19.170  62.950  1.00 41.94           O  
ATOM   1314  N   MET B  79      36.234  16.775  64.544  1.00 29.06           N  
ATOM   1315  CA  MET B  79      36.392  15.365  64.757  1.00 28.57           C  
ATOM   1316  C   MET B  79      35.208  14.621  64.181  1.00 28.69           C  
ATOM   1317  O   MET B  79      35.380  13.521  63.668  1.00 28.61           O  
ATOM   1318  CB  MET B  79      36.586  15.069  66.251  1.00 29.74           C  
ATOM   1319  CG  MET B  79      37.816  15.687  66.868  1.00 31.42           C  
ATOM   1320  SD  MET B  79      39.316  15.329  65.900  1.00 35.81           S  
ATOM   1321  CE  MET B  79      39.365  13.589  65.977  1.00 34.19           C  
ATOM   1322  N   ASN B  80      34.009  15.210  64.243  1.00 27.98           N  
ATOM   1323  CA  ASN B  80      32.818  14.585  63.655  1.00 29.30           C  
ATOM   1324  C   ASN B  80      32.869  14.548  62.116  1.00 30.26           C  
ATOM   1325  O   ASN B  80      32.465  13.564  61.482  1.00 31.22           O  
ATOM   1326  CB  ASN B  80      31.531  15.267  64.164  1.00 28.82           C  
ATOM   1327  CG  ASN B  80      31.122  14.768  65.531  1.00 29.15           C  
ATOM   1328  OD1 ASN B  80      30.370  13.825  65.596  1.00 27.16           O  
ATOM   1329  ND2 ASN B  80      31.701  15.327  66.623  1.00 27.35           N  
ATOM   1330  N   LEU B  81      33.416  15.603  61.524  1.00 31.14           N  
ATOM   1331  CA  LEU B  81      33.623  15.637  60.064  1.00 31.08           C  
ATOM   1332  C   LEU B  81      34.665  14.643  59.564  1.00 31.74           C  
ATOM   1333  O   LEU B  81      34.492  14.014  58.507  1.00 31.32           O  
ATOM   1334  CB  LEU B  81      34.032  17.044  59.631  1.00 30.96           C  
ATOM   1335  CG  LEU B  81      32.970  18.129  59.721  1.00 29.83           C  
ATOM   1336  CD1 LEU B  81      33.585  19.489  59.506  1.00 29.70           C  
ATOM   1337  CD2 LEU B  81      31.848  17.876  58.740  1.00 31.78           C  
ATOM   1338  N   ILE B  82      35.766  14.536  60.296  1.00 31.85           N  
ATOM   1339  CA  ILE B  82      36.793  13.547  60.014  1.00 33.13           C  
ATOM   1340  C   ILE B  82      36.185  12.155  60.098  1.00 34.56           C  
ATOM   1341  O   ILE B  82      36.405  11.342  59.199  1.00 34.20           O  
ATOM   1342  CB  ILE B  82      38.016  13.727  60.939  1.00 33.68           C  
ATOM   1343  CG1 ILE B  82      38.698  15.067  60.627  1.00 32.73           C  
ATOM   1344  CG2 ILE B  82      38.988  12.565  60.817  1.00 35.58           C  
ATOM   1345  CD1 ILE B  82      39.815  15.457  61.597  1.00 33.92           C  
ATOM   1346  N   LYS B  83      35.393  11.867  61.141  1.00 35.35           N  
ATOM   1347  CA  LYS B  83      34.699  10.575  61.214  1.00 36.58           C  
ATOM   1348  C   LYS B  83      33.799  10.327  59.985  1.00 37.20           C  
ATOM   1349  O   LYS B  83      33.789   9.223  59.407  1.00 37.93           O  
ATOM   1350  CB  LYS B  83      33.837  10.489  62.470  1.00 37.47           C  
ATOM   1351  CG  LYS B  83      33.119   9.133  62.642  1.00 42.59           C  
ATOM   1352  CD  LYS B  83      33.760   8.211  63.696  1.00 48.10           C  
ATOM   1353  CE  LYS B  83      35.004   7.438  63.188  1.00 51.39           C  
ATOM   1354  NZ  LYS B  83      35.710   6.637  64.293  1.00 50.71           N  
ATOM   1355  N   LYS B  84      33.028  11.344  59.621  1.00 36.74           N  
ATOM   1356  CA  LYS B  84      32.111  11.266  58.501  1.00 38.55           C  
ATOM   1357  C   LYS B  84      32.842  11.023  57.181  1.00 38.90           C  
ATOM   1358  O   LYS B  84      32.522  10.097  56.451  1.00 40.92           O  
ATOM   1359  CB  LYS B  84      31.298  12.556  58.425  1.00 37.63           C  
ATOM   1360  CG  LYS B  84      30.344  12.645  57.256  1.00 40.17           C  
ATOM   1361  CD  LYS B  84      29.370  13.791  57.461  1.00 43.30           C  
ATOM   1362  CE  LYS B  84      28.141  13.614  56.587  1.00 45.92           C  
ATOM   1363  NZ  LYS B  84      28.600  13.690  55.189  1.00 48.83           N  
ATOM   1364  N   HIS B  85      33.839  11.845  56.891  1.00 40.09           N  
ATOM   1365  CA  HIS B  85      34.529  11.795  55.612  1.00 41.01           C  
ATOM   1366  C   HIS B  85      35.812  11.004  55.537  1.00 42.40           C  
ATOM   1367  O   HIS B  85      36.240  10.686  54.435  1.00 42.02           O  
ATOM   1368  CB  HIS B  85      34.804  13.209  55.163  1.00 41.24           C  
ATOM   1369  CG  HIS B  85      33.566  13.991  54.962  1.00 41.25           C  
ATOM   1370  ND1 HIS B  85      32.645  13.657  53.998  1.00 42.05           N  
ATOM   1371  CD2 HIS B  85      33.057  15.056  55.629  1.00 41.58           C  
ATOM   1372  CE1 HIS B  85      31.626  14.499  54.062  1.00 44.36           C  
ATOM   1373  NE2 HIS B  85      31.856  15.362  55.036  1.00 42.31           N  
ATOM   1374  N   ASP B  86      36.437  10.715  56.681  1.00 43.23           N  
ATOM   1375  CA  ASP B  86      37.735  10.041  56.701  1.00 45.53           C  
ATOM   1376  C   ASP B  86      38.635  10.540  55.535  1.00 46.46           C  
ATOM   1377  O   ASP B  86      38.979   9.774  54.630  1.00 47.73           O  
ATOM   1378  CB  ASP B  86      37.492   8.535  56.627  1.00 46.77           C  
ATOM   1379  CG  ASP B  86      38.739   7.703  56.899  1.00 48.93           C  
ATOM   1380  OD1 ASP B  86      39.730   8.191  57.496  1.00 49.79           O  
ATOM   1381  OD2 ASP B  86      38.703   6.526  56.498  1.00 52.68           O  
ATOM   1382  N   PRO B  87      39.009  11.833  55.553  1.00 46.45           N  
ATOM   1383  CA  PRO B  87      39.784  12.401  54.425  1.00 47.28           C  
ATOM   1384  C   PRO B  87      41.210  11.850  54.334  1.00 48.26           C  
ATOM   1385  O   PRO B  87      41.861  11.657  55.363  1.00 47.15           O  
ATOM   1386  CB  PRO B  87      39.791  13.914  54.715  1.00 46.78           C  
ATOM   1387  CG  PRO B  87      38.797  14.125  55.820  1.00 46.28           C  
ATOM   1388  CD  PRO B  87      38.733  12.845  56.585  1.00 45.75           C  
ATOM   1389  N   LYS B  88      41.688  11.627  53.102  1.00 49.51           N  
ATOM   1390  CA  LYS B  88      42.992  10.992  52.864  1.00 50.81           C  
ATOM   1391  C   LYS B  88      44.147  11.732  53.494  1.00 51.33           C  
ATOM   1392  O   LYS B  88      45.029  11.114  54.077  1.00 51.62           O  
ATOM   1393  CB  LYS B  88      43.266  10.845  51.361  1.00 52.05           C  
ATOM   1394  N   TYR B  89      44.145  13.054  53.386  1.00 52.21           N  
ATOM   1395  CA  TYR B  89      45.271  13.844  53.888  1.00 53.81           C  
ATOM   1396  C   TYR B  89      45.298  14.006  55.392  1.00 54.21           C  
ATOM   1397  O   TYR B  89      46.327  14.377  55.940  1.00 55.20           O  
ATOM   1398  CB  TYR B  89      45.333  15.218  53.225  1.00 54.84           C  
ATOM   1399  CG  TYR B  89      45.903  15.205  51.820  1.00 55.37           C  
ATOM   1400  CD1 TYR B  89      47.266  15.353  51.600  1.00 58.19           C  
ATOM   1401  CD2 TYR B  89      45.075  15.058  50.719  1.00 56.04           C  
ATOM   1402  CE1 TYR B  89      47.792  15.354  50.308  1.00 59.98           C  
ATOM   1403  CE2 TYR B  89      45.584  15.049  49.432  1.00 57.83           C  
ATOM   1404  CZ  TYR B  89      46.941  15.197  49.235  1.00 59.39           C  
ATOM   1405  OH  TYR B  89      47.432  15.186  47.965  1.00 60.20           O  
ATOM   1406  N   ASN B  90      44.173  13.765  56.064  1.00 54.18           N  
ATOM   1407  CA  ASN B  90      44.172  13.771  57.523  1.00 54.56           C  
ATOM   1408  C   ASN B  90      44.942  12.579  58.048  1.00 57.44           C  
ATOM   1409  O   ASN B  90      45.630  12.680  59.050  1.00 58.11           O  
ATOM   1410  CB  ASN B  90      42.749  13.793  58.093  1.00 53.09           C  
ATOM   1411  CG  ASN B  90      42.105  15.147  57.947  1.00 49.42           C  
ATOM   1412  OD1 ASN B  90      41.527  15.462  56.914  1.00 43.93           O  
ATOM   1413  ND2 ASN B  90      42.225  15.966  58.982  1.00 46.34           N  
ATOM   1414  N   VAL B  91      44.840  11.456  57.351  1.00 60.30           N  
ATOM   1415  CA  VAL B  91      45.588  10.252  57.724  1.00 63.57           C  
ATOM   1416  C   VAL B  91      47.100  10.466  57.601  1.00 66.39           C  
ATOM   1417  O   VAL B  91      47.858  10.123  58.520  1.00 67.82           O  
ATOM   1418  CB  VAL B  91      45.173   9.027  56.852  1.00 64.03           C  
ATOM   1419  CG1 VAL B  91      46.045   7.811  57.160  1.00 65.66           C  
ATOM   1420  CG2 VAL B  91      43.685   8.684  57.072  1.00 63.27           C  
ATOM   1421  N   MET B  92      47.530  11.058  56.492  1.00 68.43           N  
ATOM   1422  CA  MET B  92      48.958  11.131  56.161  1.00 71.74           C  
ATOM   1423  C   MET B  92      49.701  12.413  56.545  1.00 73.17           C  
ATOM   1424  O   MET B  92      50.938  12.429  56.536  1.00 74.64           O  
ATOM   1425  CB  MET B  92      49.132  10.869  54.679  1.00 72.47           C  
ATOM   1426  CG  MET B  92      48.684   9.471  54.270  1.00 72.83           C  
ATOM   1427  SD  MET B  92      48.817   9.250  52.504  1.00 74.50           S  
ATOM   1428  CE  MET B  92      47.897  10.690  51.916  1.00 72.26           C  
ATOM   1429  N   LEU B  93      48.966  13.478  56.863  1.00 73.20           N  
ATOM   1430  CA  LEU B  93      49.576  14.698  57.415  1.00 74.72           C  
ATOM   1431  C   LEU B  93      49.628  14.626  58.956  1.00 75.57           C  
ATOM   1432  O   LEU B  93      49.657  15.661  59.626  1.00 75.69           O  
ATOM   1433  CB  LEU B  93      48.810  15.961  56.974  1.00 73.69           C  
ATOM   1434  CG  LEU B  93      49.080  16.571  55.592  1.00 74.82           C  
ATOM   1435  CD1 LEU B  93      47.958  17.509  55.182  1.00 73.74           C  
ATOM   1436  CD2 LEU B  93      50.406  17.321  55.571  1.00 76.80           C  
ATOM   1437  N   LYS B  94      49.642  13.416  59.518  1.00 76.75           N  
ATOM   1438  CA  LYS B  94      49.684  13.244  60.973  1.00 77.67           C  
ATOM   1439  C   LYS B  94      50.769  14.137  61.606  1.00 79.61           C  
ATOM   1440  O   LYS B  94      51.963  13.949  61.355  1.00 81.43           O  
ATOM   1441  CB  LYS B  94      49.918  11.773  61.327  1.00 78.57           C  
ATOM   1442  N   ASP B  95      50.334  15.118  62.405  1.00 70.14           N  
ATOM   1443  CA  ASP B  95      51.237  16.087  63.039  1.00 70.38           C  
ATOM   1444  C   ASP B  95      51.944  15.474  64.243  1.00 70.60           C  
ATOM   1445  O   ASP B  95      52.965  14.796  64.091  1.00 71.02           O  
ATOM   1446  CB  ASP B  95      50.464  17.336  63.475  1.00 70.32           C  
TER    1447      ASP B  95                                                      
END
MOLECULE T0510_235_279.pdb
ATOM   1792  N   PRO   235      38.119  38.837  68.304  1.00 56.78           N  
ATOM   1793  CA  PRO   235      37.403  37.612  68.588  1.00 57.06           C  
ATOM   1794  CB  PRO   235      36.009  38.107  68.951  1.00 56.13           C  
ATOM   1795  CG  PRO   235      35.933  39.448  68.479  1.00 55.48           C  
ATOM   1796  CD  PRO   235      37.275  40.015  68.523  1.00 56.19           C  
ATOM   1797  C   PRO   235      37.351  36.729  67.327  1.00 57.69           C  
ATOM   1798  O   PRO   235      37.213  37.235  66.219  1.00 57.92           O  
ATOM   1799  N   PRO   236      37.425  35.413  67.493  1.00 58.22           N  
ATOM   1800  CA  PRO   236      37.744  34.610  66.340  1.00 58.10           C  
ATOM   1801  CB  PRO   236      38.325  33.359  66.970  1.00 58.25           C  
ATOM   1802  CG  PRO   236      37.422  33.136  68.189  1.00 58.04           C  
ATOM   1803  CD  PRO   236      37.156  34.577  68.688  1.00 58.45           C  
ATOM   1804  C   PRO   236      36.514  34.194  65.560  1.00 58.39           C  
ATOM   1805  O   PRO   236      35.378  34.320  66.042  1.00 57.01           O  
ATOM   1806  N   THR   237      36.794  33.661  64.368  1.00 58.97           N  
ATOM   1807  CA  THR   237      35.827  32.949  63.549  1.00 58.76           C  
ATOM   1808  CB  THR   237      35.868  33.463  62.189  1.00 58.85           C  
ATOM   1809  OG1 THR   237      35.466  34.831  62.260  1.00 59.79           O  
ATOM   1810  CG2 THR   237      34.924  32.670  61.320  1.00 59.79           C  
ATOM   1811  C   THR   237      36.136  31.476  63.538  1.00 58.51           C  
ATOM   1812  O   THR   237      37.034  30.979  62.852  1.00 57.58           O  
ATOM   1813  N   PRO   238      35.417  30.770  64.370  1.00 59.11           N  
ATOM   1814  CA  PRO   238      35.594  29.334  64.399  1.00 60.04           C  
ATOM   1815  CB  PRO   238      34.640  28.872  65.530  1.00 59.91           C  
ATOM   1816  CG  PRO   238      34.272  30.092  66.278  1.00 59.22           C  
ATOM   1817  CD  PRO   238      34.415  31.250  65.333  1.00 59.02           C  
ATOM   1818  C   PRO   238      35.165  28.771  63.055  1.00 60.41           C  
ATOM   1819  O   PRO   238      34.010  28.951  62.685  1.00 60.91           O  
ATOM   1820  N   ILE   239      36.068  28.097  62.346  1.00 60.56           N  
ATOM   1821  CA  ILE   239      35.797  27.704  60.989  1.00 60.68           C  
ATOM   1822  CB  ILE   239      36.312  28.777  60.065  1.00 60.69           C  
ATOM   1823  CG1 ILE   239      35.801  28.552  58.648  1.00 60.81           C  
ATOM   1824  CD1 ILE   239      35.547  29.854  57.941  1.00 61.28           C  
ATOM   1825  CG2 ILE   239      37.839  28.864  60.130  1.00 60.77           C  
ATOM   1826  C   ILE   239      36.379  26.382  60.582  1.00 60.66           C  
ATOM   1827  O   ILE   239      37.537  26.094  60.818  1.00 59.60           O  
ATOM   1828  N   PHE   240      35.525  25.600  59.937  1.00 62.55           N  
ATOM   1829  CA  PHE   240      35.832  24.268  59.367  1.00 63.50           C  
ATOM   1830  CB  PHE   240      34.651  23.342  59.646  1.00 64.12           C  
ATOM   1831  CG  PHE   240      34.790  21.970  59.051  1.00 64.17           C  
ATOM   1832  CD1 PHE   240      35.617  21.019  59.641  1.00 65.39           C  
ATOM   1833  CE1 PHE   240      35.736  19.709  59.104  1.00 65.07           C  
ATOM   1834  CZ  PHE   240      35.031  19.366  57.986  1.00 64.69           C  
ATOM   1835  CE2 PHE   240      34.191  20.315  57.388  1.00 64.75           C  
ATOM   1836  CD2 PHE   240      34.064  21.603  57.926  1.00 65.49           C  
ATOM   1837  C   PHE   240      35.990  24.317  57.873  1.00 63.92           C  
ATOM   1838  O   PHE   240      35.179  24.925  57.207  1.00 63.86           O  
ATOM   1839  N   HIS   241      36.991  23.654  57.326  1.00 65.06           N  
ATOM   1840  CA  HIS   241      37.162  23.676  55.864  1.00 66.08           C  
ATOM   1841  CB  HIS   241      38.360  24.530  55.475  1.00 65.84           C  
ATOM   1842  CG  HIS   241      38.690  24.501  54.015  1.00 65.96           C  
ATOM   1843  ND1 HIS   241      39.422  23.487  53.441  1.00 67.40           N  
ATOM   1844  CE1 HIS   241      39.578  23.736  52.150  1.00 67.07           C  
ATOM   1845  NE2 HIS   241      38.995  24.887  51.873  1.00 66.00           N  
ATOM   1846  CD2 HIS   241      38.430  25.386  53.020  1.00 66.81           C  
ATOM   1847  C   HIS   241      37.340  22.270  55.334  1.00 67.20           C  
ATOM   1848  O   HIS   241      38.108  21.479  55.908  1.00 67.42           O  
ATOM   1849  N   ASN   243      38.456  20.577  51.720  1.00 70.21           N  
ATOM   1850  CA  ASN   243      38.872  20.490  50.320  1.00 71.02           C  
ATOM   1851  CB  ASN   243      40.393  20.391  50.203  1.00 70.84           C  
ATOM   1852  CG  ASN   243      40.867  20.603  48.780  1.00 71.08           C  
ATOM   1853  OD1 ASN   243      40.097  20.402  47.830  1.00 72.94           O  
ATOM   1854  ND2 ASN   243      42.115  21.034  48.615  1.00 70.41           N  
ATOM   1855  C   ASN   243      38.239  19.275  49.636  1.00 71.03           C  
ATOM   1856  O   ASN   243      38.421  18.144  50.084  1.00 70.81           O  
ATOM   1857  N   HIS   244      37.508  19.506  48.552  1.00 71.45           N  
ATOM   1858  CA  HIS   244      36.787  18.395  47.898  1.00 72.32           C  
ATOM   1859  CB  HIS   244      35.402  18.874  47.410  1.00 72.97           C  
ATOM   1860  CG  HIS   244      34.437  19.185  48.529  1.00 74.09           C  
ATOM   1861  ND1 HIS   244      33.738  18.205  49.213  1.00 74.28           N  
ATOM   1862  CE1 HIS   244      32.964  18.768  50.126  1.00 74.00           C  
ATOM   1863  NE2 HIS   244      33.141  20.077  50.069  1.00 75.08           N  
ATOM   1864  CD2 HIS   244      34.057  20.366  49.081  1.00 74.81           C  
ATOM   1865  C   HIS   244      37.635  17.685  46.796  1.00 72.19           C  
ATOM   1866  O   HIS   244      37.529  16.485  46.585  1.00 72.01           O  
ATOM   1867  N   GLU   245      38.460  18.474  46.123  1.00 72.31           N  
ATOM   1868  CA  GLU   245      39.709  18.048  45.463  1.00 72.01           C  
ATOM   1869  CB  GLU   245      40.497  19.361  45.129  1.00 72.78           C  
ATOM   1870  CG  GLU   245      41.727  19.257  44.268  1.00 73.32           C  
ATOM   1871  CD  GLU   245      41.544  18.244  43.188  1.00 76.23           C  
ATOM   1872  OE1 GLU   245      40.636  18.444  42.340  1.00 77.40           O  
ATOM   1873  OE2 GLU   245      42.278  17.226  43.215  1.00 78.17           O  
ATOM   1874  C   GLU   245      40.606  17.052  46.293  1.00 71.77           C  
ATOM   1875  O   GLU   245      40.915  15.970  45.819  1.00 71.98           O  
ATOM   1876  N   THR   246      41.012  17.429  47.513  1.00 70.83           N  
ATOM   1877  CA  THR   246      41.894  16.631  48.390  1.00 70.07           C  
ATOM   1878  CB  THR   246      42.591  17.557  49.490  1.00 70.62           C  
ATOM   1879  OG1 THR   246      43.300  18.623  48.856  1.00 72.35           O  
ATOM   1880  CG2 THR   246      43.565  16.796  50.431  1.00 70.20           C  
ATOM   1881  C   THR   246      41.156  15.559  49.177  1.00 69.07           C  
ATOM   1882  O   THR   246      41.751  14.554  49.507  1.00 68.80           O  
ATOM   1883  N   GLY   247      39.889  15.793  49.528  1.00 68.01           N  
ATOM   1884  CA  GLY   247      39.253  15.104  50.681  1.00 67.14           C  
ATOM   1885  C   GLY   247      39.628  15.674  52.076  1.00 66.27           C  
ATOM   1886  O   GLY   247      38.914  15.442  53.062  1.00 65.47           O  
ATOM   1887  N   LYS   248      40.735  16.425  52.163  1.00 65.09           N  
ATOM   1888  CA  LYS   248      41.247  16.980  53.435  1.00 64.76           C  
ATOM   1889  CB  LYS   248      42.490  17.837  53.175  1.00 64.40           C  
ATOM   1890  CG  LYS   248      43.265  18.218  54.419  1.00 63.97           C  
ATOM   1891  CD  LYS   248      44.549  18.932  54.018  1.00 65.03           C  
ATOM   1892  CE  LYS   248      45.393  19.478  55.199  1.00 64.61           C  
ATOM   1893  NZ  LYS   248      45.491  18.476  56.271  1.00 63.97           N  
ATOM   1894  C   LYS   248      40.235  17.812  54.281  1.00 64.50           C  
ATOM   1895  O   LYS   248      39.301  18.414  53.725  1.00 65.32           O  
ATOM   1896  N   GLU   249      40.437  17.820  55.613  1.00 63.10           N  
ATOM   1897  CA  GLU   249      39.711  18.671  56.557  1.00 61.95           C  
ATOM   1898  CB  GLU   249      38.701  17.865  57.368  1.00 61.30           C  
ATOM   1899  CG  GLU   249      37.888  16.895  56.496  1.00 62.51           C  
ATOM   1900  CD  GLU   249      36.815  16.060  57.232  1.00 62.38           C  
ATOM   1901  OE1 GLU   249      35.880  15.545  56.565  1.00 62.08           O  
ATOM   1902  OE2 GLU   249      36.908  15.881  58.462  1.00 64.07           O  
ATOM   1903  C   GLU   249      40.700  19.417  57.473  1.00 61.03           C  
ATOM   1904  O   GLU   249      41.782  18.955  57.811  1.00 59.65           O  
ATOM   1905  N   ASP   250      40.328  20.630  57.814  1.00 60.84           N  
ATOM   1906  CA  ASP   250      41.147  21.490  58.624  1.00 60.75           C  
ATOM   1907  CB  ASP   250      41.973  22.444  57.760  1.00 61.33           C  
ATOM   1908  CG  ASP   250      43.219  21.792  57.185  1.00 62.98           C  
ATOM   1909  OD1 ASP   250      44.233  21.684  57.907  1.00 66.92           O  
ATOM   1910  OD2 ASP   250      43.198  21.419  56.003  1.00 62.18           O  
ATOM   1911  C   ASP   250      40.177  22.293  59.427  1.00 60.32           C  
ATOM   1912  O   ASP   250      38.978  22.281  59.123  1.00 61.17           O  
ATOM   1913  N   PHE   251      40.696  22.980  60.442  1.00 59.37           N  
ATOM   1914  CA  PHE   251      39.938  23.933  61.245  1.00 58.83           C  
ATOM   1915  CB  PHE   251      39.381  23.259  62.514  1.00 59.11           C  
ATOM   1916  CG  PHE   251      40.481  22.660  63.451  1.00 59.95           C  
ATOM   1917  CD1 PHE   251      41.111  23.442  64.424  1.00 58.79           C  
ATOM   1918  CE1 PHE   251      42.096  22.927  65.237  1.00 57.67           C  
ATOM   1919  CZ  PHE   251      42.478  21.636  65.105  1.00 58.19           C  
ATOM   1920  CE2 PHE   251      41.853  20.812  64.175  1.00 59.69           C  
ATOM   1921  CD2 PHE   251      40.863  21.319  63.354  1.00 60.37           C  
ATOM   1922  C   PHE   251      40.875  25.040  61.655  1.00 57.73           C  
ATOM   1923  O   PHE   251      42.123  24.869  61.702  1.00 57.53           O  
ATOM   1924  N   TYR   252      40.300  26.173  61.996  1.00 56.75           N  
ATOM   1925  CA  TYR   252      41.122  27.216  62.554  1.00 56.78           C  
ATOM   1926  CB  TYR   252      42.047  27.786  61.469  1.00 55.88           C  
ATOM   1927  CG  TYR   252      43.392  28.272  61.964  1.00 56.06           C  
ATOM   1928  CD1 TYR   252      44.327  27.405  62.576  1.00 55.18           C  
ATOM   1929  CE1 TYR   252      45.577  27.879  63.027  1.00 52.73           C  
ATOM   1930  CZ  TYR   252      45.863  29.213  62.896  1.00 53.97           C  
ATOM   1931  OH  TYR   252      47.041  29.791  63.292  1.00 53.82           O  
ATOM   1932  CE2 TYR   252      44.947  30.071  62.321  1.00 55.93           C  
ATOM   1933  CD2 TYR   252      43.734  29.602  61.840  1.00 55.08           C  
ATOM   1934  C   TYR   252      40.230  28.259  63.202  1.00 57.82           C  
ATOM   1935  O   TYR   252      39.044  28.023  63.417  1.00 57.92           O  
ATOM   1936  N   PHE   253      40.793  29.398  63.553  1.00 59.19           N  
ATOM   1937  CA  PHE   253      40.019  30.386  64.241  1.00 61.04           C  
ATOM   1938  CB  PHE   253      40.659  30.678  65.563  1.00 60.09           C  
ATOM   1939  CG  PHE   253      41.924  31.395  65.476  1.00 58.42           C  
ATOM   1940  CD1 PHE   253      41.959  32.751  65.633  1.00 57.78           C  
ATOM   1941  CE1 PHE   253      43.145  33.426  65.578  1.00 57.95           C  
ATOM   1942  CZ  PHE   253      44.302  32.742  65.380  1.00 58.46           C  
ATOM   1943  CE2 PHE   253      44.282  31.375  65.240  1.00 58.52           C  
ATOM   1944  CD2 PHE   253      43.099  30.710  65.302  1.00 58.84           C  
ATOM   1945  C   PHE   253      39.808  31.674  63.489  1.00 63.18           C  
ATOM   1946  O   PHE   253      39.107  32.571  64.012  1.00 64.05           O  
ATOM   1947  N   ILE   254      40.335  31.748  62.277  1.00 64.65           N  
ATOM   1948  CA  ILE   254      39.995  32.785  61.334  1.00 65.00           C  
ATOM   1949  CB  ILE   254      41.010  33.882  61.326  1.00 64.83           C  
ATOM   1950  CG1 ILE   254      42.361  33.338  60.945  1.00 65.22           C  
ATOM   1951  CD1 ILE   254      43.428  34.282  61.254  1.00 64.94           C  
ATOM   1952  CG2 ILE   254      41.097  34.504  62.662  1.00 61.98           C  
ATOM   1953  C   ILE   254      39.884  32.175  59.951  1.00 66.83           C  
ATOM   1954  O   ILE   254      40.234  31.030  59.774  1.00 66.77           O  
ATOM   1955  N   LYS   255      39.373  32.931  58.981  1.00 68.08           N  
ATOM   1956  CA  LYS   255      39.230  32.440  57.610  1.00 68.59           C  
ATOM   1957  CB  LYS   255      38.024  33.070  56.938  1.00 69.48           C  
ATOM   1958  CG  LYS   255      37.638  34.426  57.482  1.00 71.38           C  
ATOM   1959  CD  LYS   255      36.128  34.665  57.382  1.00 70.14           C  
ATOM   1960  CE  LYS   255      35.715  35.360  56.084  1.00 71.36           C  
ATOM   1961  NZ  LYS   255      34.897  36.577  56.341  1.00 71.32           N  
ATOM   1962  C   LYS   255      40.453  32.720  56.772  1.00 68.61           C  
ATOM   1963  O   LYS   255      40.916  33.833  56.714  1.00 68.72           O  
ATOM   1964  N   LEU   256      41.019  31.691  56.188  1.00 68.87           N  
ATOM   1965  CA  LEU   256      42.319  31.817  55.609  1.00 69.01           C  
ATOM   1966  CB  LEU   256      43.188  30.659  56.037  1.00 69.13           C  
ATOM   1967  CG  LEU   256      43.293  30.245  57.482  1.00 67.71           C  
ATOM   1968  CD1 LEU   256      44.203  29.095  57.529  1.00 65.84           C  
ATOM   1969  CD2 LEU   256      43.861  31.357  58.254  1.00 67.86           C  
ATOM   1970  C   LEU   256      42.226  31.754  54.136  1.00 69.34           C  
ATOM   1971  O   LEU   256      41.699  30.814  53.605  1.00 69.38           O  
ATOM   1972  N   ASN   257      42.784  32.741  53.471  1.00 70.12           N  
ATOM   1973  CA  ASN   257      42.708  32.768  52.040  1.00 71.01           C  
ATOM   1974  CB  ASN   257      43.523  33.932  51.462  1.00 72.03           C  
ATOM   1975  CG  ASN   257      44.763  33.498  50.759  1.00 74.02           C  
ATOM   1976  OD1 ASN   257      44.710  32.872  49.711  1.00 76.53           O  
ATOM   1977  ND2 ASN   257      45.906  33.863  51.315  1.00 77.28           N  
ATOM   1978  C   ASN   257      43.065  31.406  51.490  1.00 71.28           C  
ATOM   1979  O   ASN   257      42.814  31.105  50.341  1.00 71.37           O  
ATOM   1980  N   GLN   258      43.592  30.552  52.336  1.00 71.17           N  
ATOM   1981  CA  GLN   258      43.892  29.218  51.896  1.00 70.93           C  
ATOM   1982  CB  GLN   258      45.044  28.654  52.682  1.00 71.38           C  
ATOM   1983  CG  GLN   258      44.932  27.183  52.845  1.00 72.34           C  
ATOM   1984  CD  GLN   258      46.170  26.577  53.443  1.00 73.53           C  
ATOM   1985  OE1 GLN   258      46.970  27.268  54.084  1.00 75.13           O  
ATOM   1986  NE2 GLN   258      46.344  25.278  53.242  1.00 74.55           N  
ATOM   1987  C   GLN   258      42.735  28.289  52.078  1.00 69.69           C  
ATOM   1988  O   GLN   258      42.861  27.112  51.851  1.00 69.54           O  
ATOM   1989  N   PHE   259      41.608  28.808  52.510  1.00 69.38           N  
ATOM   1990  CA  PHE   259      40.513  27.936  52.871  1.00 69.56           C  
ATOM   1991  CB  PHE   259      39.897  28.350  54.189  1.00 68.92           C  
ATOM   1992  CG  PHE   259      40.420  27.581  55.352  1.00 69.40           C  
ATOM   1993  CD1 PHE   259      41.237  26.512  55.166  1.00 68.68           C  
ATOM   1994  CE1 PHE   259      41.715  25.831  56.220  1.00 67.71           C  
ATOM   1995  CZ  PHE   259      41.389  26.198  57.462  1.00 66.14           C  
ATOM   1996  CE2 PHE   259      40.595  27.245  57.666  1.00 66.90           C  
ATOM   1997  CD2 PHE   259      40.108  27.937  56.626  1.00 68.50           C  
ATOM   1998  C   PHE   259      39.431  27.722  51.843  1.00 69.83           C  
ATOM   1999  O   PHE   259      38.728  26.731  51.923  1.00 70.64           O  
ATOM   2000  N   ASN   260      39.270  28.544  50.819  1.00 69.64           N  
ATOM   2001  CA  ASN   260      38.406  28.121  49.712  1.00 69.07           C  
ATOM   2002  CB  ASN   260      38.901  28.778  48.472  1.00 68.78           C  
ATOM   2003  CG  ASN   260      40.366  28.580  48.296  1.00 68.77           C  
ATOM   2004  OD1 ASN   260      40.820  27.539  47.844  1.00 69.84           O  
ATOM   2005  ND2 ASN   260      41.129  29.576  48.676  1.00 67.16           N  
ATOM   2006  C   ASN   260      38.730  26.673  49.505  1.00 68.60           C  
ATOM   2007  O   ASN   260      39.896  26.351  49.580  1.00 69.70           O  
ATOM   2008  N   ASP   261      37.787  25.763  49.265  1.00 20.00           N  
ATOM   2009  CA  ASP   261      36.432  25.993  48.862  1.00 20.00           C  
ATOM   2010  C   ASP   261      35.494  26.017  50.021  1.00 20.00           C  
ATOM   2011  CB  ASP   261      35.994  24.860  47.930  1.00 20.00           C  
ATOM   2012  CG  ASP   261      35.219  25.367  46.686  1.00 20.00           C  
ATOM   2013  OD1 ASP   261      33.980  25.508  46.770  1.00 20.00           O  
ATOM   2014  OD2 ASP   261      35.844  25.616  45.626  1.00 20.00           O  
ATOM   2015  O   ASP   261      35.187  27.065  50.529  1.00 20.00           O  
ATOM   2016  N   ASP   262      35.026  24.846  50.424  1.00 64.93           N  
ATOM   2017  CA  ASP   262      33.905  24.709  51.355  1.00 64.67           C  
ATOM   2018  CB  ASP   262      33.327  23.319  51.213  1.00 65.08           C  
ATOM   2019  CG  ASP   262      31.987  23.204  51.831  1.00 67.04           C  
ATOM   2020  OD1 ASP   262      31.422  24.248  52.171  1.00 68.85           O  
ATOM   2021  OD2 ASP   262      31.497  22.078  51.987  1.00 69.65           O  
ATOM   2022  C   ASP   262      34.200  24.962  52.830  1.00 64.13           C  
ATOM   2023  O   ASP   262      35.268  24.639  53.292  1.00 64.65           O  
ATOM   2024  N   THR   263      33.242  25.512  53.575  1.00 62.93           N  
ATOM   2025  CA  THR   263      33.502  25.877  54.943  1.00 61.69           C  
ATOM   2026  CB  THR   263      34.331  27.099  54.983  1.00 61.53           C  
ATOM   2027  OG1 THR   263      33.462  28.225  54.936  1.00 61.15           O  
ATOM   2028  CG2 THR   263      35.207  27.120  53.801  1.00 61.02           C  
ATOM   2029  C   THR   263      32.278  26.211  55.749  1.00 60.92           C  
ATOM   2030  O   THR   263      31.459  27.009  55.357  1.00 59.95           O  
ATOM   2031  N   VAL   264      32.211  25.600  56.916  1.00 60.39           N  
ATOM   2032  CA  VAL   264      31.149  25.784  57.911  1.00 59.43           C  
ATOM   2033  CB  VAL   264      30.644  24.420  58.399  1.00 58.90           C  
ATOM   2034  CG1 VAL   264      29.514  24.541  59.441  1.00 58.61           C  
ATOM   2035  CG2 VAL   264      30.189  23.636  57.242  1.00 57.44           C  
ATOM   2036  C   VAL   264      31.821  26.563  59.042  1.00 59.13           C  
ATOM   2037  O   VAL   264      32.979  26.284  59.347  1.00 59.17           O  
ATOM   2038  N   THR   265      31.154  27.571  59.614  1.00 58.67           N  
ATOM   2039  CA  THR   265      31.700  28.259  60.780  1.00 58.60           C  
ATOM   2040  CB  THR   265      31.787  29.778  60.663  1.00 57.71           C  
ATOM   2041  OG1 THR   265      30.473  30.247  60.584  1.00 56.69           O  
ATOM   2042  CG2 THR   265      32.579  30.257  59.458  1.00 57.28           C  
ATOM   2043  C   THR   265      30.764  27.969  61.932  1.00 59.00           C  
ATOM   2044  O   THR   265      29.634  27.555  61.684  1.00 58.78           O  
ATOM   2045  N   TYR   266      31.248  28.201  63.170  1.00 59.51           N  
ATOM   2046  CA  TYR   266      30.533  27.848  64.409  1.00 59.57           C  
ATOM   2047  CB  TYR   266      31.182  26.605  64.997  1.00 58.79           C  
ATOM   2048  CG  TYR   266      31.015  25.384  64.165  1.00 57.04           C  
ATOM   2049  CD1 TYR   266      30.015  24.488  64.446  1.00 55.62           C  
ATOM   2050  CE1 TYR   266      29.841  23.355  63.692  1.00 56.67           C  
ATOM   2051  CZ  TYR   266      30.673  23.108  62.641  1.00 57.43           C  
ATOM   2052  OH  TYR   266      30.462  21.968  61.908  1.00 58.62           O  
ATOM   2053  CE2 TYR   266      31.692  23.987  62.338  1.00 57.29           C  
ATOM   2054  CD2 TYR   266      31.863  25.119  63.110  1.00 56.27           C  
ATOM   2055  C   TYR   266      30.527  28.955  65.492  1.00 60.29           C  
ATOM   2056  O   TYR   266      31.313  29.917  65.409  1.00 60.46           O  
ATOM   2057  N   ASP   267      29.669  28.783  66.510  1.00 60.67           N  
ATOM   2058  CA  ASP   267      29.561  29.716  67.646  1.00 61.45           C  
ATOM   2059  CB  ASP   267      28.484  29.244  68.607  1.00 62.20           C  
ATOM   2060  CG  ASP   267      27.113  29.811  68.290  1.00 67.02           C  
ATOM   2061  OD1 ASP   267      26.922  30.488  67.228  1.00 71.32           O  
ATOM   2062  OD2 ASP   267      26.206  29.569  69.136  1.00 72.49           O  
ATOM   2063  C   ASP   267      30.818  29.884  68.492  1.00 61.90           C  
ATOM   2064  O   ASP   267      30.989  30.920  69.159  1.00 62.49           O  
ATOM   2065  N   SER   268      31.660  28.848  68.499  1.00 61.55           N  
ATOM   2066  CA  SER   268      32.785  28.751  69.398  1.00 60.75           C  
ATOM   2067  CB  SER   268      32.300  28.268  70.761  1.00 60.98           C  
ATOM   2068  OG  SER   268      31.995  26.868  70.763  1.00 60.36           O  
ATOM   2069  C   SER   268      33.799  27.735  68.884  1.00 60.46           C  
ATOM   2070  O   SER   268      33.516  26.858  68.029  1.00 59.60           O  
ATOM   2071  N   LEU   269      34.987  27.819  69.458  1.00 59.89           N  
ATOM   2072  CA  LEU   269      36.013  26.868  69.123  1.00 59.31           C  
ATOM   2073  CB  LEU   269      37.349  27.331  69.689  1.00 59.43           C  
ATOM   2074  CG  LEU   269      38.142  28.449  68.989  1.00 58.84           C  
ATOM   2075  CD1 LEU   269      38.880  29.276  70.043  1.00 56.68           C  
ATOM   2076  CD2 LEU   269      37.284  29.319  68.138  1.00 56.26           C  
ATOM   2077  C   LEU   269      35.630  25.476  69.655  1.00 59.20           C  
ATOM   2078  O   LEU   269      36.158  24.450  69.194  1.00 59.44           O  
ATOM   2079  N   ASN   270      34.711  25.430  70.613  1.00 58.48           N  
ATOM   2080  CA  ASN   270      34.468  24.196  71.311  1.00 58.22           C  
ATOM   2081  CB  ASN   270      33.903  24.493  72.667  1.00 57.82           C  
ATOM   2082  CG  ASN   270      34.924  25.148  73.559  1.00 58.43           C  
ATOM   2083  OD1 ASN   270      36.091  24.792  73.549  1.00 60.92           O  
ATOM   2084  ND2 ASN   270      34.503  26.121  74.316  1.00 59.72           N  
ATOM   2085  C   ASN   270      33.553  23.405  70.461  1.00 58.21           C  
ATOM   2086  O   ASN   270      33.760  22.224  70.232  1.00 59.01           O  
ATOM   2087  N   ASP   271      32.547  24.085  69.943  1.00 57.90           N  
ATOM   2088  CA  ASP   271      31.720  23.536  68.891  1.00 56.76           C  
ATOM   2089  CB  ASP   271      30.777  24.632  68.412  1.00 57.53           C  
ATOM   2090  CG  ASP   271      29.667  24.921  69.382  1.00 59.49           C  
ATOM   2091  OD1 ASP   271      29.498  24.136  70.305  1.00 64.52           O  
ATOM   2092  OD2 ASP   271      28.935  25.921  69.234  1.00 64.86           O  
ATOM   2093  C   ASP   271      32.576  23.059  67.706  1.00 56.10           C  
ATOM   2094  O   ASP   271      32.422  21.928  67.226  1.00 55.45           O  
ATOM   2095  N   LEU   272      33.462  23.937  67.222  1.00 55.06           N  
ATOM   2096  CA  LEU   272      34.274  23.623  66.054  1.00 54.61           C  
ATOM   2097  CB  LEU   272      35.281  24.747  65.804  1.00 54.69           C  
ATOM   2098  CG  LEU   272      36.399  24.538  64.769  1.00 54.29           C  
ATOM   2099  CD1 LEU   272      35.733  24.269  63.429  1.00 53.12           C  
ATOM   2100  CD2 LEU   272      37.393  25.732  64.722  1.00 52.33           C  
ATOM   2101  C   LEU   272      34.970  22.291  66.283  1.00 54.28           C  
ATOM   2102  O   LEU   272      34.852  21.378  65.496  1.00 52.39           O  
ATOM   2103  N   LEU   273      35.661  22.179  67.411  1.00 55.02           N  
ATOM   2104  CA  LEU   273      36.346  20.938  67.767  1.00 55.73           C  
ATOM   2105  CB  LEU   273      37.228  21.163  69.000  1.00 55.87           C  
ATOM   2106  CG  LEU   273      38.662  21.718  68.890  1.00 56.75           C  
ATOM   2107  CD1 LEU   273      38.880  22.843  69.933  1.00 55.95           C  
ATOM   2108  CD2 LEU   273      39.002  22.213  67.507  1.00 58.78           C  
ATOM   2109  C   LEU   273      35.375  19.749  67.972  1.00 55.55           C  
ATOM   2110  O   LEU   273      35.617  18.657  67.459  1.00 54.28           O  
ATOM   2111  N   ASP   274      34.287  19.951  68.708  1.00 56.51           N  
ATOM   2112  CA  ASP   274      33.324  18.865  68.930  1.00 58.38           C  
ATOM   2113  CB  ASP   274      31.990  19.395  69.530  1.00 59.03           C  
ATOM   2114  CG  ASP   274      31.881  19.227  71.078  1.00 61.08           C  
ATOM   2115  OD1 ASP   274      32.742  18.544  71.677  1.00 64.56           O  
ATOM   2116  OD2 ASP   274      30.905  19.753  71.697  1.00 60.37           O  
ATOM   2117  C   ASP   274      33.051  18.140  67.590  1.00 59.07           C  
ATOM   2118  O   ASP   274      33.085  16.910  67.500  1.00 59.81           O  
ATOM   2119  N   ARG   275      32.807  18.921  66.546  1.00 59.66           N  
ATOM   2120  CA  ARG   275      32.506  18.378  65.244  1.00 59.52           C  
ATOM   2121  CB  ARG   275      32.022  19.508  64.328  1.00 60.24           C  
ATOM   2122  CG  ARG   275      31.590  19.067  62.950  1.00 61.21           C  
ATOM   2123  CD  ARG   275      32.727  19.218  61.965  1.00 67.01           C  
ATOM   2124  NE  ARG   275      32.213  19.478  60.618  1.00 71.17           N  
ATOM   2125  CZ  ARG   275      31.944  18.547  59.694  1.00 72.56           C  
ATOM   2126  NH1 ARG   275      32.153  17.242  59.932  1.00 75.00           N  
ATOM   2127  NH2 ARG   275      31.457  18.925  58.515  1.00 70.89           N  
ATOM   2128  C   ARG   275      33.722  17.708  64.657  1.00 59.14           C  
ATOM   2129  O   ARG   275      33.740  16.511  64.406  1.00 59.80           O  
ATOM   2130  N   PHE   276      34.759  18.484  64.467  1.00 58.47           N  
ATOM   2131  CA  PHE   276      35.925  17.991  63.796  1.00 58.58           C  
ATOM   2132  CB  PHE   276      37.005  19.028  63.885  1.00 58.63           C  
ATOM   2133  CG  PHE   276      38.173  18.731  63.029  1.00 59.60           C  
ATOM   2134  CD1 PHE   276      38.282  19.290  61.767  1.00 60.31           C  
ATOM   2135  CE1 PHE   276      39.390  19.027  60.976  1.00 61.02           C  
ATOM   2136  CZ  PHE   276      40.385  18.190  61.445  1.00 59.55           C  
ATOM   2137  CE2 PHE   276      40.268  17.640  62.682  1.00 59.82           C  
ATOM   2138  CD2 PHE   276      39.177  17.906  63.471  1.00 59.93           C  
ATOM   2139  C   PHE   276      36.492  16.664  64.309  1.00 58.62           C  
ATOM   2140  O   PHE   276      37.138  15.959  63.559  1.00 58.14           O  
ATOM   2141  N   TYR   277      36.310  16.326  65.582  1.00 59.51           N  
ATOM   2142  CA  TYR   277      36.891  15.070  66.080  1.00 59.37           C  
ATOM   2143  CB  TYR   277      37.770  15.273  67.304  1.00 58.20           C  
ATOM   2144  CG  TYR   277      39.074  15.937  66.968  1.00 56.40           C  
ATOM   2145  CD1 TYR   277      40.121  15.229  66.373  1.00 54.78           C  
ATOM   2146  CE1 TYR   277      41.331  15.843  66.051  1.00 54.66           C  
ATOM   2147  CZ  TYR   277      41.492  17.189  66.334  1.00 56.64           C  
ATOM   2148  OH  TYR   277      42.636  17.887  66.033  1.00 56.35           O  
ATOM   2149  CE2 TYR   277      40.475  17.903  66.953  1.00 57.71           C  
ATOM   2150  CD2 TYR   277      39.268  17.270  67.257  1.00 56.92           C  
ATOM   2151  C   TYR   277      35.859  14.056  66.341  1.00 61.03           C  
ATOM   2152  O   TYR   277      36.050  13.190  67.133  1.00 60.14           O  
ATOM   2153  N   ASP   278      34.773  14.125  65.604  1.00 64.34           N  
ATOM   2154  CA  ASP   278      33.793  13.055  65.657  1.00 67.25           C  
ATOM   2155  CB  ASP   278      32.428  13.590  65.181  1.00 67.49           C  
ATOM   2156  CG  ASP   278      31.256  12.980  65.954  1.00 70.02           C  
ATOM   2157  OD1 ASP   278      31.431  12.654  67.171  1.00 68.92           O  
ATOM   2158  OD2 ASP   278      30.161  12.833  65.328  1.00 73.24           O  
ATOM   2159  C   ASP   278      34.232  11.755  64.872  1.00 68.21           C  
ATOM   2160  O   ASP   278      33.794  10.633  65.242  1.00 67.92           O  
ATOM   2161  N   ALA   279      35.105  11.901  63.835  1.00 69.48           N  
ATOM   2162  CA  ALA   279      35.341  10.812  62.775  1.00 69.71           C  
ATOM   2163  CB  ALA   279      35.793  11.443  61.349  1.00 69.27           C  
ATOM   2164  C   ALA   279      36.256   9.600  63.185  1.00 69.97           C  
ATOM   2165  O   ALA   279      37.255   9.750  63.917  1.00 69.96           O  
END
