
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   96 (  766),  selected   96 , name 1yd6_D
# Molecule2: number of CA atoms   44 (  374),  selected   44 , name T0510_235_279.pdb
# PARAMETERS: 1yd6_D.T0510_235_279.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    N     2_D      P     235           -
LGA    E     3_D      P     236           -
LGA    R     4_D      -       -           -
LGA    L     5_D      -       -           -
LGA    K     6_D      -       -           -
LGA    E     7_D      -       -           -
LGA    K     8_D      -       -           -
LGA    L     9_D      -       -           -
LGA    A    10_D      -       -           -
LGA    V    11_D      -       -           -
LGA    L    12_D      -       -           -
LGA    P    13_D      -       -           -
LGA    E    14_D      -       -           -
LGA    Q    15_D      T     237          1.344
LGA    P    16_D      P     238          0.870
LGA    G    17_D      I     239          1.890
LGA    C    18_D      F     240          0.699
LGA    Y    19_D      H     241          0.627
LGA    L    20_D      -       -           -
LGA    M    21_D      N     243          0.830
LGA    K    22_D      H     244          1.188
LGA    D    23_D      E     245          1.020
LGA    K    24_D      T     246           -
LGA    H    25_D      -       -           -
LGA    G    26_D      -       -           -
LGA    T    27_D      -       -           -
LGA    V    28_D      -       -           -
LGA    I    29_D      G     247          1.041
LGA    Y    30_D      K     248          0.672
LGA    V    31_D      E     249          0.697
LGA    G    32_D      D     250          0.871
LGA    K    33_D      F     251          1.112
LGA    A    34_D      Y     252          0.889
LGA    K    35_D      F     253          0.758
LGA    S    36_D      I     254          0.704
LGA    L    37_D      K     255          2.209
LGA    K    38_D      L     256          3.338
LGA    E    39_D      -       -           -
LGA    R    40_D      -       -           -
LGA    V    41_D      -       -           -
LGA    R    42_D      N     257          1.587
LGA    S    43_D      Q     258          3.916
LGA    Y    44_D      F     259           #
LGA    F    45_D      -       -           -
LGA    T    46_D      -       -           -
LGA    G    47_D      -       -           -
LGA    T    48_D      -       -           -
LGA    H    49_D      -       -           -
LGA    D    50_D      -       -           -
LGA    G    51_D      -       -           -
LGA    K    52_D      -       -           -
LGA    T    53_D      -       -           -
LGA    Q    54_D      -       -           -
LGA    R    55_D      -       -           -
LGA    L    56_D      -       -           -
LGA    V    57_D      -       -           -
LGA    E    58_D      -       -           -
LGA    E    59_D      -       -           -
LGA    I    60_D      -       -           -
LGA    A    61_D      -       -           -
LGA    D    62_D      N     260          6.004
LGA    F    63_D      D     261          1.892
LGA    E    64_D      D     262          0.645
LGA    Y    65_D      T     263          0.602
LGA    I    66_D      V     264          0.609
LGA    V    67_D      T     265          0.710
LGA    T    68_D      Y     266          0.490
LGA    S    69_D      D     267          0.461
LGA    S    70_D      S     268          0.684
LGA    N    71_D      L     269          0.876
LGA    A    72_D      N     270          0.958
LGA    E    73_D      D     271          0.897
LGA    A    74_D      L     272          0.847
LGA    L    75_D      L     273          0.842
LGA    I    76_D      D     274          1.092
LGA    L    77_D      R     275          1.427
LGA    E    78_D      F     276          1.160
LGA    M    79_D      Y     277          1.460
LGA    N    80_D      D     278          2.689
LGA    L    81_D      -       -           -
LGA    I    82_D      -       -           -
LGA    K    83_D      A     279          1.851
LGA    K    84_D      -       -           -
LGA    H    85_D      -       -           -
LGA    D    86_D      -       -           -
LGA    P    87_D      -       -           -
LGA    K    88_D      -       -           -
LGA    Y    89_D      -       -           -
LGA    N    90_D      -       -           -
LGA    V    91_D      -       -           -
LGA    M    92_D      -       -           -
LGA    L    93_D      -       -           -
LGA    K    94_D      -       -           -
LGA    D    95_D      -       -           -
LGA    D    96_D      -       -           -
LGA    K    97_D      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   96   44    5.0     40    1.68     7.50     85.975     2.243

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.540053 * X  +   0.765370 * Y  +  -0.350072 * Z  +  30.493767
  Y_new =   0.111598 * X  +   0.347151 * Y  +   0.931146 * Z  +   1.548581
  Z_new =   0.834199 * X  +  -0.541936 * Y  +   0.102066 * Z  +  45.162155 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.384640    1.756953  [ DEG:   -79.3340    100.6660 ]
  Theta =  -0.986679   -2.154914  [ DEG:   -56.5325   -123.4675 ]
  Phi   =   0.203774   -2.937819  [ DEG:    11.6754   -168.3246 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1yd6_D                                        
REMARK     2: T0510_235_279.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1yd6_D.T0510_235_279.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   96   44   5.0   40   1.68    7.50  85.975
REMARK  ---------------------------------------------------------- 
MOLECULE 1yd6_D
HEADER    DNA BINDING PROTEIN                     23-DEC-04   1YD6              
TITLE     CRYSTAL STRUCTURE OF THE GIY-YIG N-TERMINAL ENDONUCLEASE              
TITLE    2 DOMAIN OF UVRC FROM BACILLUS CALDOTENAX                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UVRC;                                                      
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 FRAGMENT: N-TERMINAL DOMAIN;                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS CALDOTENAX;                            
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    DNA BINDING PROTEIN                                                   
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.J.TRUGLIO,B.RHAU,D.L.CROTEAU,L.WANG,M.SKORVAGA,E.KARAKAS,           
AUTHOR   2 M.J.DELLAVECCHIA,H.WANG,B.VAN HOUTEN,C.KISKER                        
REVDAT   2   29-MAR-05 1YD6    1       JRNL                                     
REVDAT   1   01-MAR-05 1YD6    0                                                
JRNL        AUTH   J.J.TRUGLIO,B.RHAU,D.L.CROTEAU,L.WANG,M.SKORVAGA,            
JRNL        AUTH 2 E.KARAKAS,M.J.DELLAVECCHIA,H.WANG,B.VAN HOUTEN,              
JRNL        AUTH 3 C.KISKER                                                     
JRNL        TITL   STRUCTURAL INSIGHTS INTO THE FIRST INCISION                  
JRNL        TITL 2 REACTION DURING NUCLEOTIDE EXCISION REPAIR                   
JRNL        REF    EMBO J.                       V.  24   885 2005              
JRNL        REFN   ASTM EMJODG  UK ISSN 0261-4189                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
SEQRES   1 A   99  MET ASN GLU ARG LEU LYS GLU LYS LEU ALA VAL LEU PRO          
SEQRES   2 A   99  GLU GLN PRO GLY CYS TYR LEU MET LYS ASP LYS HIS GLY          
SEQRES   3 A   99  THR VAL ILE TYR VAL GLY LYS ALA LYS SER LEU LYS GLU          
SEQRES   4 A   99  ARG VAL ARG SER TYR PHE THR GLY THR HIS ASP GLY LYS          
SEQRES   5 A   99  THR GLN ARG LEU VAL GLU GLU ILE ALA ASP PHE GLU TYR          
SEQRES   6 A   99  ILE VAL THR SER SER ASN ALA GLU ALA LEU ILE LEU GLU          
SEQRES   7 A   99  MET ASN LEU ILE LYS LYS HIS ASP PRO LYS TYR ASN VAL          
SEQRES   8 A   99  MET LEU LYS ASP ASP LYS SER TYR                              
SEQRES   1 B   99  MET ASN GLU ARG LEU LYS GLU LYS LEU ALA VAL LEU PRO          
SEQRES   2 B   99  GLU GLN PRO GLY CYS TYR LEU MET LYS ASP LYS HIS GLY          
SEQRES   3 B   99  THR VAL ILE TYR VAL GLY LYS ALA LYS SER LEU LYS GLU          
SEQRES   4 B   99  ARG VAL ARG SER TYR PHE THR GLY THR HIS ASP GLY LYS          
SEQRES   5 B   99  THR GLN ARG LEU VAL GLU GLU ILE ALA ASP PHE GLU TYR          
SEQRES   6 B   99  ILE VAL THR SER SER ASN ALA GLU ALA LEU ILE LEU GLU          
SEQRES   7 B   99  MET ASN LEU ILE LYS LYS HIS ASP PRO LYS TYR ASN VAL          
SEQRES   8 B   99  MET LEU LYS ASP ASP LYS SER TYR                              
SEQRES   1 C   99  MET ASN GLU ARG LEU LYS GLU LYS LEU ALA VAL LEU PRO          
SEQRES   2 C   99  GLU GLN PRO GLY CYS TYR LEU MET LYS ASP LYS HIS GLY          
SEQRES   3 C   99  THR VAL ILE TYR VAL GLY LYS ALA LYS SER LEU LYS GLU          
SEQRES   4 C   99  ARG VAL ARG SER TYR PHE THR GLY THR HIS ASP GLY LYS          
SEQRES   5 C   99  THR GLN ARG LEU VAL GLU GLU ILE ALA ASP PHE GLU TYR          
SEQRES   6 C   99  ILE VAL THR SER SER ASN ALA GLU ALA LEU ILE LEU GLU          
SEQRES   7 C   99  MET ASN LEU ILE LYS LYS HIS ASP PRO LYS TYR ASN VAL          
SEQRES   8 C   99  MET LEU LYS ASP ASP LYS SER TYR                              
SEQRES   1 D   99  MET ASN GLU ARG LEU LYS GLU LYS LEU ALA VAL LEU PRO          
SEQRES   2 D   99  GLU GLN PRO GLY CYS TYR LEU MET LYS ASP LYS HIS GLY          
SEQRES   3 D   99  THR VAL ILE TYR VAL GLY LYS ALA LYS SER LEU LYS GLU          
SEQRES   4 D   99  ARG VAL ARG SER TYR PHE THR GLY THR HIS ASP GLY LYS          
SEQRES   5 D   99  THR GLN ARG LEU VAL GLU GLU ILE ALA ASP PHE GLU TYR          
SEQRES   6 D   99  ILE VAL THR SER SER ASN ALA GLU ALA LEU ILE LEU GLU          
SEQRES   7 D   99  MET ASN LEU ILE LYS LYS HIS ASP PRO LYS TYR ASN VAL          
SEQRES   8 D   99  MET LEU LYS ASP ASP LYS SER TYR                              
HET     CL   1001       1                                                       
HET    SO4   1002       5                                                       
HET    SO4   1003       5                                                       
HET    SO4   1004       5                                                       
HET     CL   1005       1                                                       
HET     CL   1006       1                                                       
HETNAM      CL CHLORIDE ION                                                     
HETNAM     SO4 SULFATE ION                                                      
FORMUL   5   CL    3(CL 1-)                                                     
FORMUL   6  SO4    3(O4 S 2-)                                                   
FORMUL  11  HOH   *126(H2 O)                                                    
CRYST1   86.487   86.660   67.862  90.00 120.16  90.00 C 1 2 1      16          
ATOM   2204  N   ASN D   2      41.608  30.253  39.755  1.00 65.28           N  
ATOM   2205  CA  ASN D   2      40.160  30.327  39.393  1.00 65.19           C  
ATOM   2206  C   ASN D   2      39.459  31.577  39.957  1.00 64.60           C  
ATOM   2207  O   ASN D   2      39.799  32.069  41.043  1.00 64.40           O  
ATOM   2208  CB  ASN D   2      39.445  29.040  39.847  1.00 65.50           C  
ATOM   2209  CG  ASN D   2      38.010  28.966  39.378  1.00 66.09           C  
ATOM   2210  OD1 ASN D   2      37.165  29.747  39.807  1.00 67.53           O  
ATOM   2211  ND2 ASN D   2      37.719  28.002  38.515  1.00 67.92           N  
ATOM   2212  N   GLU D   3      38.467  32.057  39.205  1.00 63.46           N  
ATOM   2213  CA  GLU D   3      37.677  33.249  39.541  1.00 62.64           C  
ATOM   2214  C   GLU D   3      36.607  32.998  40.611  1.00 60.43           C  
ATOM   2215  O   GLU D   3      36.457  33.786  41.553  1.00 59.95           O  
ATOM   2216  CB  GLU D   3      37.007  33.769  38.271  1.00 62.80           C  
ATOM   2217  CG  GLU D   3      36.120  34.985  38.450  1.00 64.18           C  
ATOM   2218  CD  GLU D   3      35.512  35.455  37.134  1.00 64.92           C  
ATOM   2219  OE1 GLU D   3      35.912  34.940  36.058  1.00 68.08           O  
ATOM   2220  OE2 GLU D   3      34.631  36.346  37.177  1.00 67.49           O  
ATOM   2221  N   ARG D   4      35.837  31.925  40.444  1.00 67.62           N  
ATOM   2222  CA  ARG D   4      34.851  31.537  41.451  1.00 64.44           C  
ATOM   2223  C   ARG D   4      35.575  31.387  42.785  1.00 60.86           C  
ATOM   2224  O   ARG D   4      35.128  31.897  43.801  1.00 59.01           O  
ATOM   2225  CB  ARG D   4      34.159  30.221  41.064  1.00 64.68           C  
ATOM   2226  N   LEU D   5      36.724  30.717  42.743  1.00 58.61           N  
ATOM   2227  CA  LEU D   5      37.543  30.457  43.935  1.00 55.82           C  
ATOM   2228  C   LEU D   5      38.109  31.724  44.586  1.00 53.82           C  
ATOM   2229  O   LEU D   5      38.204  31.804  45.807  1.00 51.40           O  
ATOM   2230  CB  LEU D   5      38.708  29.538  43.585  1.00 56.10           C  
ATOM   2231  CG  LEU D   5      39.267  28.760  44.764  1.00 56.31           C  
ATOM   2232  CD1 LEU D   5      38.279  27.648  45.151  1.00 57.27           C  
ATOM   2233  CD2 LEU D   5      40.618  28.158  44.456  1.00 57.69           C  
ATOM   2234  N   LYS D   6      38.522  32.701  43.776  1.00 52.40           N  
ATOM   2235  CA  LYS D   6      38.999  33.980  44.321  1.00 50.79           C  
ATOM   2236  C   LYS D   6      37.865  34.641  45.096  1.00 48.67           C  
ATOM   2237  O   LYS D   6      38.082  35.130  46.208  1.00 47.46           O  
ATOM   2238  CB  LYS D   6      39.522  34.901  43.208  1.00 52.03           C  
ATOM   2239  N   GLU D   7      36.657  34.616  44.526  1.00 47.21           N  
ATOM   2240  CA  GLU D   7      35.472  35.184  45.166  1.00 46.83           C  
ATOM   2241  C   GLU D   7      35.130  34.496  46.479  1.00 45.16           C  
ATOM   2242  O   GLU D   7      34.718  35.153  47.434  1.00 44.07           O  
ATOM   2243  CB  GLU D   7      34.247  35.097  44.256  1.00 47.67           C  
ATOM   2244  CG  GLU D   7      33.012  35.880  44.771  1.00 48.71           C  
ATOM   2245  CD  GLU D   7      33.276  37.394  44.993  1.00 51.27           C  
ATOM   2246  OE1 GLU D   7      33.758  37.788  46.098  1.00 46.12           O  
ATOM   2247  OE2 GLU D   7      32.978  38.186  44.060  1.00 51.29           O  
ATOM   2248  N   LYS D   8      35.252  33.171  46.501  1.00 44.53           N  
ATOM   2249  CA  LYS D   8      34.988  32.398  47.731  1.00 44.09           C  
ATOM   2250  C   LYS D   8      35.968  32.832  48.789  1.00 42.38           C  
ATOM   2251  O   LYS D   8      35.571  33.083  49.920  1.00 42.56           O  
ATOM   2252  CB  LYS D   8      35.132  30.895  47.488  1.00 44.06           C  
ATOM   2253  CG  LYS D   8      34.169  30.364  46.431  1.00 45.79           C  
ATOM   2254  CD  LYS D   8      34.131  28.828  46.380  1.00 46.41           C  
ATOM   2255  CE  LYS D   8      33.116  28.267  47.377  1.00 47.49           C  
ATOM   2256  NZ  LYS D   8      32.813  26.826  47.147  1.00 48.29           N  
ATOM   2257  N   LEU D   9      37.245  32.924  48.409  1.00 41.22           N  
ATOM   2258  CA  LEU D   9      38.300  33.320  49.331  1.00 40.64           C  
ATOM   2259  C   LEU D   9      38.096  34.717  49.884  1.00 40.32           C  
ATOM   2260  O   LEU D   9      38.399  34.977  51.055  1.00 38.75           O  
ATOM   2261  CB  LEU D   9      39.677  33.242  48.667  1.00 41.08           C  
ATOM   2262  CG  LEU D   9      40.258  31.835  48.448  1.00 41.25           C  
ATOM   2263  CD1 LEU D   9      41.465  31.890  47.513  1.00 42.48           C  
ATOM   2264  CD2 LEU D   9      40.631  31.164  49.755  1.00 39.93           C  
ATOM   2265  N   ALA D  10      37.589  35.616  49.043  1.00 40.44           N  
ATOM   2266  CA  ALA D  10      37.441  37.013  49.440  1.00 40.08           C  
ATOM   2267  C   ALA D  10      36.420  37.259  50.552  1.00 38.61           C  
ATOM   2268  O   ALA D  10      36.591  38.188  51.355  1.00 37.60           O  
ATOM   2269  CB  ALA D  10      37.099  37.862  48.240  1.00 41.39           C  
ATOM   2270  N   VAL D  11      35.346  36.469  50.577  1.00 37.15           N  
ATOM   2271  CA  VAL D  11      34.265  36.724  51.511  1.00 37.02           C  
ATOM   2272  C   VAL D  11      34.306  35.748  52.709  1.00 36.20           C  
ATOM   2273  O   VAL D  11      33.340  35.660  53.442  1.00 35.90           O  
ATOM   2274  CB  VAL D  11      32.871  36.726  50.827  1.00 37.75           C  
ATOM   2275  CG1 VAL D  11      32.781  37.859  49.807  1.00 39.32           C  
ATOM   2276  CG2 VAL D  11      32.574  35.371  50.156  1.00 38.06           C  
ATOM   2277  N   LEU D  12      35.416  35.034  52.863  1.00 36.24           N  
ATOM   2278  CA  LEU D  12      35.694  34.192  54.042  1.00 35.86           C  
ATOM   2279  C   LEU D  12      35.538  34.998  55.338  1.00 36.07           C  
ATOM   2280  O   LEU D  12      36.009  36.127  55.447  1.00 36.62           O  
ATOM   2281  CB  LEU D  12      37.120  33.614  53.954  1.00 36.44           C  
ATOM   2282  CG  LEU D  12      37.421  32.371  53.084  1.00 37.35           C  
ATOM   2283  CD1 LEU D  12      38.892  32.181  52.911  1.00 38.82           C  
ATOM   2284  CD2 LEU D  12      36.854  31.098  53.730  1.00 39.31           C  
ATOM   2285  N   PRO D  13      34.836  34.434  56.334  1.00 34.76           N  
ATOM   2286  CA  PRO D  13      34.640  35.182  57.550  1.00 34.38           C  
ATOM   2287  C   PRO D  13      35.815  35.059  58.516  1.00 33.99           C  
ATOM   2288  O   PRO D  13      36.527  34.064  58.511  1.00 33.72           O  
ATOM   2289  CB  PRO D  13      33.386  34.520  58.134  1.00 33.88           C  
ATOM   2290  CG  PRO D  13      33.558  33.101  57.802  1.00 33.41           C  
ATOM   2291  CD  PRO D  13      34.190  33.114  56.401  1.00 35.15           C  
ATOM   2292  N   GLU D  14      36.041  36.094  59.309  1.00 34.93           N  
ATOM   2293  CA  GLU D  14      36.954  36.019  60.435  1.00 35.74           C  
ATOM   2294  C   GLU D  14      36.162  35.382  61.585  1.00 34.26           C  
ATOM   2295  O   GLU D  14      35.773  36.066  62.527  1.00 35.37           O  
ATOM   2296  CB  GLU D  14      37.413  37.400  60.873  1.00 37.49           C  
ATOM   2297  CG  GLU D  14      38.163  38.148  59.849  1.00 43.45           C  
ATOM   2298  CD  GLU D  14      38.842  39.393  60.414  1.00 48.77           C  
ATOM   2299  OE1 GLU D  14      38.259  40.064  61.300  1.00 51.60           O  
ATOM   2300  OE2 GLU D  14      39.981  39.678  59.978  1.00 54.17           O  
ATOM   2301  N   GLN D  15      35.904  34.084  61.495  1.00 31.86           N  
ATOM   2302  CA  GLN D  15      35.102  33.386  62.505  1.00 30.60           C  
ATOM   2303  C   GLN D  15      35.696  32.013  62.663  1.00 28.50           C  
ATOM   2304  O   GLN D  15      36.279  31.492  61.715  1.00 27.45           O  
ATOM   2305  CB  GLN D  15      33.682  33.161  61.993  1.00 30.83           C  
ATOM   2306  CG  GLN D  15      32.862  34.414  61.668  1.00 33.20           C  
ATOM   2307  CD  GLN D  15      32.177  35.053  62.845  1.00 35.45           C  
ATOM   2308  OE1 GLN D  15      32.040  34.470  63.927  1.00 38.72           O  
ATOM   2309  NE2 GLN D  15      31.693  36.256  62.633  1.00 37.43           N  
ATOM   2310  N   PRO D  16      35.468  31.368  63.821  1.00 26.89           N  
ATOM   2311  CA  PRO D  16      35.930  29.997  63.947  1.00 25.58           C  
ATOM   2312  C   PRO D  16      35.007  29.014  63.204  1.00 26.06           C  
ATOM   2313  O   PRO D  16      33.827  29.290  62.951  1.00 26.42           O  
ATOM   2314  CB  PRO D  16      35.866  29.744  65.472  1.00 25.42           C  
ATOM   2315  CG  PRO D  16      34.820  30.658  65.945  1.00 23.85           C  
ATOM   2316  CD  PRO D  16      34.750  31.833  65.031  1.00 26.93           C  
ATOM   2317  N   GLY D  17      35.551  27.859  62.878  1.00 25.97           N  
ATOM   2318  CA  GLY D  17      34.771  26.782  62.281  1.00 24.96           C  
ATOM   2319  C   GLY D  17      35.668  25.744  61.659  1.00 25.57           C  
ATOM   2320  O   GLY D  17      36.862  25.610  62.058  1.00 25.47           O  
ATOM   2321  N   CYS D  18      35.114  25.017  60.677  1.00 23.72           N  
ATOM   2322  CA  CYS D  18      35.836  23.971  60.000  1.00 24.25           C  
ATOM   2323  C   CYS D  18      35.764  24.167  58.518  1.00 24.89           C  
ATOM   2324  O   CYS D  18      34.752  24.627  58.004  1.00 23.49           O  
ATOM   2325  CB  CYS D  18      35.301  22.594  60.329  1.00 23.97           C  
ATOM   2326  SG  CYS D  18      35.462  22.190  62.066  1.00 26.39           S  
ATOM   2327  N   TYR D  19      36.851  23.828  57.841  1.00 26.66           N  
ATOM   2328  CA  TYR D  19      36.874  23.908  56.371  1.00 28.21           C  
ATOM   2329  C   TYR D  19      37.097  22.524  55.784  1.00 29.95           C  
ATOM   2330  O   TYR D  19      37.765  21.667  56.395  1.00 29.94           O  
ATOM   2331  CB  TYR D  19      37.937  24.904  55.874  1.00 29.75           C  
ATOM   2332  CG  TYR D  19      39.344  24.620  56.354  1.00 29.67           C  
ATOM   2333  CD1 TYR D  19      40.218  23.868  55.592  1.00 32.02           C  
ATOM   2334  CD2 TYR D  19      39.782  25.092  57.581  1.00 30.10           C  
ATOM   2335  CE1 TYR D  19      41.498  23.638  56.010  1.00 30.64           C  
ATOM   2336  CE2 TYR D  19      41.056  24.836  58.038  1.00 30.11           C  
ATOM   2337  CZ  TYR D  19      41.917  24.132  57.251  1.00 32.42           C  
ATOM   2338  OH  TYR D  19      43.184  23.887  57.732  1.00 32.39           O  
ATOM   2339  N   LEU D  20      36.508  22.326  54.611  1.00 30.21           N  
ATOM   2340  CA  LEU D  20      36.534  21.079  53.890  1.00 31.86           C  
ATOM   2341  C   LEU D  20      37.098  21.332  52.503  1.00 32.76           C  
ATOM   2342  O   LEU D  20      36.437  21.928  51.664  1.00 32.90           O  
ATOM   2343  CB  LEU D  20      35.130  20.504  53.759  1.00 31.42           C  
ATOM   2344  CG  LEU D  20      34.496  20.219  55.149  1.00 33.63           C  
ATOM   2345  CD1 LEU D  20      33.695  21.425  55.602  1.00 32.35           C  
ATOM   2346  CD2 LEU D  20      33.609  18.982  55.113  1.00 35.06           C  
ATOM   2347  N   MET D  21      38.321  20.900  52.299  1.00 34.03           N  
ATOM   2348  CA  MET D  21      38.967  20.974  50.987  1.00 35.19           C  
ATOM   2349  C   MET D  21      38.452  19.852  50.073  1.00 36.30           C  
ATOM   2350  O   MET D  21      38.296  18.707  50.507  1.00 33.56           O  
ATOM   2351  CB  MET D  21      40.479  20.865  51.151  1.00 35.27           C  
ATOM   2352  CG  MET D  21      41.107  21.956  51.984  1.00 36.22           C  
ATOM   2353  SD  MET D  21      40.684  23.673  51.509  1.00 38.96           S  
ATOM   2354  CE  MET D  21      41.966  24.606  52.294  1.00 34.49           C  
ATOM   2355  N   LYS D  22      38.202  20.185  48.790  1.00 38.24           N  
ATOM   2356  CA  LYS D  22      37.610  19.250  47.862  1.00 40.53           C  
ATOM   2357  C   LYS D  22      38.443  19.153  46.558  1.00 42.46           C  
ATOM   2358  O   LYS D  22      39.092  20.114  46.175  1.00 42.42           O  
ATOM   2359  CB  LYS D  22      36.175  19.678  47.542  1.00 40.99           C  
ATOM   2360  CG  LYS D  22      35.147  19.575  48.701  1.00 41.33           C  
ATOM   2361  CD  LYS D  22      33.808  20.169  48.231  1.00 42.33           C  
ATOM   2362  CE  LYS D  22      32.711  20.050  49.299  1.00 43.72           C  
ATOM   2363  NZ  LYS D  22      31.383  20.591  48.857  1.00 46.15           N  
ATOM   2364  N   ASP D  23      38.446  17.980  45.930  1.00 44.51           N  
ATOM   2365  CA  ASP D  23      39.150  17.788  44.650  1.00 46.88           C  
ATOM   2366  C   ASP D  23      38.245  18.215  43.493  1.00 49.47           C  
ATOM   2367  O   ASP D  23      37.091  18.649  43.699  1.00 47.97           O  
ATOM   2368  CB  ASP D  23      39.650  16.346  44.482  1.00 46.98           C  
ATOM   2369  CG  ASP D  23      38.540  15.340  44.344  1.00 48.64           C  
ATOM   2370  OD1 ASP D  23      37.387  15.742  44.062  1.00 53.02           O  
ATOM   2371  OD2 ASP D  23      38.819  14.130  44.516  1.00 48.92           O  
ATOM   2372  N   LYS D  24      38.769  18.099  42.267  1.00 52.41           N  
ATOM   2373  CA  LYS D  24      37.987  18.425  41.092  1.00 55.02           C  
ATOM   2374  C   LYS D  24      36.596  17.777  41.090  1.00 55.81           C  
ATOM   2375  O   LYS D  24      35.633  18.419  40.669  1.00 57.56           O  
ATOM   2376  CB  LYS D  24      38.757  18.067  39.809  1.00 56.58           C  
ATOM   2377  CG  LYS D  24      39.670  19.188  39.307  1.00 59.37           C  
ATOM   2378  CD  LYS D  24      41.021  19.274  40.050  1.00 60.02           C  
ATOM   2379  CE  LYS D  24      41.846  20.509  39.658  1.00 60.79           C  
ATOM   2380  NZ  LYS D  24      42.317  20.460  38.213  1.00 62.73           N  
ATOM   2381  N   HIS D  25      36.479  16.544  41.590  1.00 56.21           N  
ATOM   2382  CA  HIS D  25      35.198  15.798  41.582  1.00 56.79           C  
ATOM   2383  C   HIS D  25      34.262  15.998  42.797  1.00 55.80           C  
ATOM   2384  O   HIS D  25      33.193  15.366  42.880  1.00 56.23           O  
ATOM   2385  CB  HIS D  25      35.500  14.322  41.444  1.00 57.52           C  
ATOM   2386  CG  HIS D  25      36.513  14.035  40.388  1.00 60.67           C  
ATOM   2387  ND1 HIS D  25      36.556  14.738  39.201  1.00 61.21           N  
ATOM   2388  CD2 HIS D  25      37.524  13.136  40.335  1.00 62.04           C  
ATOM   2389  CE1 HIS D  25      37.555  14.289  38.467  1.00 63.21           C  
ATOM   2390  NE2 HIS D  25      38.149  13.308  39.122  1.00 63.02           N  
ATOM   2391  N   GLY D  26      34.648  16.872  43.723  1.00 54.16           N  
ATOM   2392  CA  GLY D  26      33.800  17.195  44.881  1.00 52.18           C  
ATOM   2393  C   GLY D  26      34.002  16.314  46.100  1.00 50.37           C  
ATOM   2394  O   GLY D  26      33.241  16.395  47.069  1.00 48.92           O  
ATOM   2395  N   THR D  27      35.026  15.473  46.057  1.00 48.94           N  
ATOM   2396  CA  THR D  27      35.328  14.586  47.161  1.00 47.23           C  
ATOM   2397  C   THR D  27      36.093  15.363  48.217  1.00 44.38           C  
ATOM   2398  O   THR D  27      37.019  16.098  47.914  1.00 42.73           O  
ATOM   2399  CB  THR D  27      36.129  13.368  46.676  1.00 48.50           C  
ATOM   2400  OG1 THR D  27      35.319  12.618  45.743  1.00 51.47           O  
ATOM   2401  CG2 THR D  27      36.536  12.484  47.843  1.00 48.51           C  
ATOM   2402  N   VAL D  28      35.674  15.228  49.475  1.00 41.62           N  
ATOM   2403  CA  VAL D  28      36.398  15.908  50.549  1.00 38.86           C  
ATOM   2404  C   VAL D  28      37.770  15.256  50.740  1.00 37.58           C  
ATOM   2405  O   VAL D  28      37.833  14.083  51.063  1.00 38.53           O  
ATOM   2406  CB  VAL D  28      35.586  15.869  51.881  1.00 37.12           C  
ATOM   2407  CG1 VAL D  28      36.391  16.508  53.008  1.00 37.05           C  
ATOM   2408  CG2 VAL D  28      34.250  16.555  51.700  1.00 36.45           C  
ATOM   2409  N   ILE D  29      38.854  16.021  50.596  1.00 36.85           N  
ATOM   2410  CA  ILE D  29      40.222  15.476  50.755  1.00 37.31           C  
ATOM   2411  C   ILE D  29      40.998  15.913  51.988  1.00 36.08           C  
ATOM   2412  O   ILE D  29      42.012  15.300  52.309  1.00 35.11           O  
ATOM   2413  CB  ILE D  29      41.115  15.714  49.485  1.00 38.20           C  
ATOM   2414  CG1 ILE D  29      41.222  17.195  49.137  1.00 39.16           C  
ATOM   2415  CG2 ILE D  29      40.520  14.976  48.323  1.00 39.28           C  
ATOM   2416  CD1 ILE D  29      42.252  17.501  47.985  1.00 40.31           C  
ATOM   2417  N   TYR D  30      40.548  16.980  52.654  1.00 34.66           N  
ATOM   2418  CA  TYR D  30      41.102  17.396  53.942  1.00 33.66           C  
ATOM   2419  C   TYR D  30      40.050  18.156  54.747  1.00 32.40           C  
ATOM   2420  O   TYR D  30      39.285  18.956  54.172  1.00 32.79           O  
ATOM   2421  CB  TYR D  30      42.313  18.310  53.742  1.00 34.02           C  
ATOM   2422  CG  TYR D  30      43.029  18.637  55.038  1.00 33.00           C  
ATOM   2423  CD1 TYR D  30      43.856  17.734  55.625  1.00 33.75           C  
ATOM   2424  CD2 TYR D  30      42.858  19.862  55.668  1.00 32.51           C  
ATOM   2425  CE1 TYR D  30      44.515  18.032  56.794  1.00 35.79           C  
ATOM   2426  CE2 TYR D  30      43.503  20.161  56.834  1.00 32.52           C  
ATOM   2427  CZ  TYR D  30      44.327  19.248  57.396  1.00 35.84           C  
ATOM   2428  OH  TYR D  30      44.968  19.554  58.570  1.00 34.63           O  
ATOM   2429  N   VAL D  31      39.981  17.893  56.059  1.00 31.69           N  
ATOM   2430  CA  VAL D  31      39.145  18.685  56.962  1.00 29.43           C  
ATOM   2431  C   VAL D  31      40.035  19.339  58.015  1.00 29.71           C  
ATOM   2432  O   VAL D  31      40.827  18.675  58.633  1.00 29.63           O  
ATOM   2433  CB  VAL D  31      38.114  17.790  57.667  1.00 29.32           C  
ATOM   2434  CG1 VAL D  31      37.499  18.501  58.870  1.00 28.70           C  
ATOM   2435  CG2 VAL D  31      37.052  17.380  56.646  1.00 27.86           C  
ATOM   2436  N   GLY D  32      39.883  20.625  58.230  1.00 29.47           N  
ATOM   2437  CA  GLY D  32      40.620  21.311  59.294  1.00 30.16           C  
ATOM   2438  C   GLY D  32      39.732  22.206  60.153  1.00 30.02           C  
ATOM   2439  O   GLY D  32      38.610  22.587  59.766  1.00 28.87           O  
ATOM   2440  N   LYS D  33      40.271  22.553  61.314  1.00 30.61           N  
ATOM   2441  CA  LYS D  33      39.669  23.496  62.232  1.00 31.08           C  
ATOM   2442  C   LYS D  33      40.386  24.841  62.098  1.00 31.19           C  
ATOM   2443  O   LYS D  33      41.590  24.899  61.811  1.00 30.94           O  
ATOM   2444  CB  LYS D  33      39.810  22.952  63.660  1.00 31.68           C  
ATOM   2445  CG  LYS D  33      39.746  23.997  64.778  1.00 34.15           C  
ATOM   2446  CD  LYS D  33      40.040  23.397  66.144  1.00 34.57           C  
ATOM   2447  CE  LYS D  33      39.861  24.447  67.214  1.00 37.24           C  
ATOM   2448  NZ  LYS D  33      40.920  25.489  67.108  1.00 40.99           N  
ATOM   2449  N   ALA D  34      39.664  25.918  62.339  1.00 30.22           N  
ATOM   2450  CA  ALA D  34      40.264  27.238  62.319  1.00 30.95           C  
ATOM   2451  C   ALA D  34      39.705  28.137  63.395  1.00 30.04           C  
ATOM   2452  O   ALA D  34      38.488  28.167  63.629  1.00 27.55           O  
ATOM   2453  CB  ALA D  34      40.042  27.882  60.941  1.00 31.54           C  
ATOM   2454  N   LYS D  35      40.599  28.873  64.049  1.00 30.83           N  
ATOM   2455  CA  LYS D  35      40.213  30.037  64.885  1.00 31.31           C  
ATOM   2456  C   LYS D  35      39.683  31.191  64.019  1.00 31.71           C  
ATOM   2457  O   LYS D  35      38.742  31.922  64.414  1.00 30.52           O  
ATOM   2458  CB  LYS D  35      41.407  30.489  65.757  1.00 32.20           C  
ATOM   2459  CG  LYS D  35      41.763  29.466  66.843  1.00 33.05           C  
ATOM   2460  CD  LYS D  35      42.936  29.903  67.734  1.00 33.95           C  
ATOM   2461  CE  LYS D  35      43.139  28.940  68.888  1.00 35.12           C  
ATOM   2462  NZ  LYS D  35      43.916  29.476  70.030  1.00 37.68           N  
ATOM   2463  N   SER D  36      40.283  31.360  62.833  1.00 32.48           N  
ATOM   2464  CA  SER D  36      39.778  32.314  61.810  1.00 32.63           C  
ATOM   2465  C   SER D  36      39.794  31.617  60.475  1.00 31.97           C  
ATOM   2466  O   SER D  36      40.847  31.263  59.951  1.00 33.03           O  
ATOM   2467  CB  SER D  36      40.595  33.609  61.722  1.00 35.07           C  
ATOM   2468  OG  SER D  36      40.241  34.366  60.551  1.00 36.49           O  
ATOM   2469  N   LEU D  37      38.611  31.366  59.941  1.00 31.76           N  
ATOM   2470  CA  LEU D  37      38.479  30.653  58.670  1.00 31.88           C  
ATOM   2471  C   LEU D  37      39.129  31.429  57.513  1.00 33.21           C  
ATOM   2472  O   LEU D  37      39.762  30.838  56.643  1.00 33.69           O  
ATOM   2473  CB  LEU D  37      37.007  30.356  58.378  1.00 31.04           C  
ATOM   2474  CG  LEU D  37      36.368  29.199  59.172  1.00 28.01           C  
ATOM   2475  CD1 LEU D  37      34.822  29.260  59.136  1.00 26.95           C  
ATOM   2476  CD2 LEU D  37      36.838  27.863  58.635  1.00 28.26           C  
ATOM   2477  N   LYS D  38      38.989  32.750  57.521  1.00 35.10           N  
ATOM   2478  CA  LYS D  38      39.660  33.610  56.537  1.00 37.53           C  
ATOM   2479  C   LYS D  38      41.183  33.402  56.488  1.00 38.81           C  
ATOM   2480  O   LYS D  38      41.723  33.115  55.417  1.00 38.80           O  
ATOM   2481  CB  LYS D  38      39.341  35.087  56.805  1.00 38.29           C  
ATOM   2482  CG  LYS D  38      40.051  36.040  55.854  1.00 41.74           C  
ATOM   2483  CD  LYS D  38      39.271  37.338  55.645  1.00 44.05           C  
ATOM   2484  CE  LYS D  38      39.399  38.284  56.778  1.00 45.85           C  
ATOM   2485  NZ  LYS D  38      38.616  39.560  56.509  1.00 49.54           N  
ATOM   2486  N   GLU D  39      41.854  33.544  57.630  1.00 40.21           N  
ATOM   2487  CA  GLU D  39      43.317  33.344  57.736  1.00 43.01           C  
ATOM   2488  C   GLU D  39      43.770  31.945  57.340  1.00 42.40           C  
ATOM   2489  O   GLU D  39      44.701  31.796  56.547  1.00 41.88           O  
ATOM   2490  CB  GLU D  39      43.824  33.578  59.174  1.00 43.28           C  
ATOM   2491  CG  GLU D  39      44.249  34.978  59.472  1.00 47.24           C  
ATOM   2492  CD  GLU D  39      44.969  35.109  60.817  1.00 48.91           C  
ATOM   2493  OE1 GLU D  39      44.387  34.761  61.875  1.00 53.34           O  
ATOM   2494  OE2 GLU D  39      46.133  35.588  60.808  1.00 57.75           O  
ATOM   2495  N   ARG D  40      43.135  30.924  57.922  1.00 41.07           N  
ATOM   2496  CA  ARG D  40      43.518  29.538  57.658  1.00 41.65           C  
ATOM   2497  C   ARG D  40      43.247  29.083  56.223  1.00 41.28           C  
ATOM   2498  O   ARG D  40      44.132  28.548  55.569  1.00 43.71           O  
ATOM   2499  CB  ARG D  40      42.850  28.551  58.638  1.00 41.21           C  
ATOM   2500  CG  ARG D  40      43.750  27.999  59.724  1.00 46.63           C  
ATOM   2501  CD  ARG D  40      45.117  27.549  59.212  1.00 51.42           C  
ATOM   2502  NE  ARG D  40      45.438  26.197  59.627  1.00 55.55           N  
ATOM   2503  CZ  ARG D  40      46.541  25.537  59.271  1.00 58.02           C  
ATOM   2504  NH1 ARG D  40      47.469  26.113  58.505  1.00 60.58           N  
ATOM   2505  NH2 ARG D  40      46.722  24.294  59.691  1.00 58.42           N  
ATOM   2506  N   VAL D  41      42.048  29.283  55.703  1.00 40.58           N  
ATOM   2507  CA  VAL D  41      41.784  28.817  54.323  1.00 40.60           C  
ATOM   2508  C   VAL D  41      42.684  29.522  53.267  1.00 42.79           C  
ATOM   2509  O   VAL D  41      43.239  28.856  52.365  1.00 41.60           O  
ATOM   2510  CB  VAL D  41      40.304  28.909  53.954  1.00 39.90           C  
ATOM   2511  CG1 VAL D  41      40.073  28.419  52.528  1.00 39.30           C  
ATOM   2512  CG2 VAL D  41      39.487  28.056  54.932  1.00 38.19           C  
ATOM   2513  N   ARG D  42      42.833  30.840  53.404  1.00 44.10           N  
ATOM   2514  CA  ARG D  42      43.707  31.624  52.500  1.00 45.74           C  
ATOM   2515  C   ARG D  42      45.166  31.218  52.589  1.00 47.10           C  
ATOM   2516  O   ARG D  42      45.893  31.283  51.599  1.00 48.23           O  
ATOM   2517  CB  ARG D  42      43.603  33.118  52.788  1.00 46.00           C  
ATOM   2518  CG  ARG D  42      42.300  33.725  52.393  1.00 46.48           C  
ATOM   2519  CD  ARG D  42      42.289  35.187  52.749  1.00 48.19           C  
ATOM   2520  NE  ARG D  42      41.036  35.784  52.361  1.00 48.86           N  
ATOM   2521  CZ  ARG D  42      40.778  37.085  52.387  1.00 51.72           C  
ATOM   2522  NH1 ARG D  42      41.706  37.962  52.776  1.00 54.10           N  
ATOM   2523  NH2 ARG D  42      39.594  37.518  51.997  1.00 52.31           N  
ATOM   2524  N   SER D  43      45.619  30.813  53.768  1.00 47.69           N  
ATOM   2525  CA  SER D  43      47.017  30.405  53.935  1.00 48.36           C  
ATOM   2526  C   SER D  43      47.448  29.263  52.991  1.00 49.23           C  
ATOM   2527  O   SER D  43      48.635  29.118  52.711  1.00 49.79           O  
ATOM   2528  CB  SER D  43      47.310  30.002  55.386  1.00 48.24           C  
ATOM   2529  OG  SER D  43      46.788  28.720  55.662  1.00 46.83           O  
ATOM   2530  N   TYR D  44      46.501  28.454  52.510  1.00 48.62           N  
ATOM   2531  CA  TYR D  44      46.829  27.351  51.593  1.00 49.47           C  
ATOM   2532  C   TYR D  44      47.140  27.830  50.158  1.00 51.97           C  
ATOM   2533  O   TYR D  44      47.745  27.102  49.366  1.00 52.74           O  
ATOM   2534  CB  TYR D  44      45.697  26.326  51.533  1.00 47.57           C  
ATOM   2535  CG  TYR D  44      45.548  25.469  52.782  1.00 45.50           C  
ATOM   2536  CD1 TYR D  44      46.278  24.308  52.932  1.00 44.71           C  
ATOM   2537  CD2 TYR D  44      44.668  25.819  53.790  1.00 42.58           C  
ATOM   2538  CE1 TYR D  44      46.158  23.529  54.061  1.00 44.42           C  
ATOM   2539  CE2 TYR D  44      44.522  25.034  54.928  1.00 41.61           C  
ATOM   2540  CZ  TYR D  44      45.264  23.892  55.058  1.00 43.50           C  
ATOM   2541  OH  TYR D  44      45.147  23.110  56.169  1.00 42.09           O  
ATOM   2542  N   PHE D  45      46.717  29.043  49.833  1.00 53.69           N  
ATOM   2543  CA  PHE D  45      46.830  29.567  48.481  1.00 55.96           C  
ATOM   2544  C   PHE D  45      47.853  30.705  48.380  1.00 58.53           C  
ATOM   2545  O   PHE D  45      47.851  31.468  47.415  1.00 59.72           O  
ATOM   2546  CB  PHE D  45      45.453  30.013  47.994  1.00 55.11           C  
ATOM   2547  CG  PHE D  45      44.419  28.926  48.056  1.00 54.23           C  
ATOM   2548  CD1 PHE D  45      43.537  28.844  49.131  1.00 52.12           C  
ATOM   2549  CD2 PHE D  45      44.348  27.961  47.066  1.00 54.60           C  
ATOM   2550  CE1 PHE D  45      42.586  27.847  49.191  1.00 51.15           C  
ATOM   2551  CE2 PHE D  45      43.401  26.940  47.127  1.00 54.66           C  
ATOM   2552  CZ  PHE D  45      42.508  26.891  48.200  1.00 52.33           C  
ATOM   2553  N   THR D  46      48.726  30.812  49.374  1.00 60.29           N  
ATOM   2554  CA  THR D  46      49.795  31.795  49.326  1.00 62.89           C  
ATOM   2555  C   THR D  46      50.947  31.363  50.233  1.00 64.12           C  
ATOM   2556  O   THR D  46      50.765  30.549  51.145  1.00 63.16           O  
ATOM   2557  CB  THR D  46      49.281  33.196  49.699  1.00 62.97           C  
ATOM   2558  OG1 THR D  46      50.300  34.169  49.427  1.00 65.52           O  
ATOM   2559  CG2 THR D  46      48.865  33.262  51.169  1.00 62.14           C  
ATOM   2560  N   GLY D  47      52.139  31.896  49.952  1.00 66.57           N  
ATOM   2561  CA  GLY D  47      53.342  31.548  50.705  1.00 67.79           C  
ATOM   2562  C   GLY D  47      53.875  30.189  50.297  1.00 68.63           C  
ATOM   2563  O   GLY D  47      53.560  29.692  49.218  1.00 68.52           O  
ATOM   2564  N   THR D  48      54.668  29.582  51.176  1.00 69.79           N  
ATOM   2565  CA  THR D  48      55.289  28.282  50.912  1.00 70.89           C  
ATOM   2566  C   THR D  48      54.807  27.211  51.889  1.00 70.30           C  
ATOM   2567  O   THR D  48      54.448  27.512  53.032  1.00 70.05           O  
ATOM   2568  CB  THR D  48      56.822  28.382  51.003  1.00 72.61           C  
ATOM   2569  OG1 THR D  48      57.271  29.498  50.226  1.00 73.73           O  
ATOM   2570  CG2 THR D  48      57.483  27.118  50.475  1.00 73.53           C  
ATOM   2571  N   HIS D  49      54.787  25.965  51.417  1.00 70.54           N  
ATOM   2572  CA  HIS D  49      54.393  24.810  52.228  1.00 69.73           C  
ATOM   2573  C   HIS D  49      55.340  23.627  51.975  1.00 70.65           C  
ATOM   2574  O   HIS D  49      56.022  23.577  50.945  1.00 71.47           O  
ATOM   2575  CB  HIS D  49      52.962  24.384  51.886  1.00 68.40           C  
ATOM   2576  CG  HIS D  49      51.990  25.519  51.818  1.00 67.45           C  
ATOM   2577  ND1 HIS D  49      51.881  26.335  50.711  1.00 68.41           N  
ATOM   2578  CD2 HIS D  49      51.084  25.975  52.714  1.00 66.17           C  
ATOM   2579  CE1 HIS D  49      50.950  27.247  50.930  1.00 67.47           C  
ATOM   2580  NE2 HIS D  49      50.450  27.049  52.138  1.00 65.63           N  
ATOM   2581  N   ASP D  50      55.358  22.675  52.910  1.00 70.25           N  
ATOM   2582  CA  ASP D  50      56.168  21.452  52.758  1.00 71.18           C  
ATOM   2583  C   ASP D  50      55.693  20.609  51.573  1.00 70.53           C  
ATOM   2584  O   ASP D  50      54.654  20.882  50.966  1.00 69.86           O  
ATOM   2585  CB  ASP D  50      56.195  20.601  54.048  1.00 71.01           C  
ATOM   2586  CG  ASP D  50      54.805  20.288  54.592  1.00 70.55           C  
ATOM   2587  OD1 ASP D  50      54.155  21.207  55.143  1.00 72.40           O  
ATOM   2588  OD2 ASP D  50      54.367  19.122  54.495  1.00 71.23           O  
ATOM   2589  N   GLY D  51      56.477  19.593  51.238  1.00 70.83           N  
ATOM   2590  CA  GLY D  51      56.165  18.721  50.120  1.00 70.30           C  
ATOM   2591  C   GLY D  51      54.840  17.999  50.262  1.00 68.10           C  
ATOM   2592  O   GLY D  51      54.076  17.914  49.300  1.00 68.26           O  
ATOM   2593  N   LYS D  52      54.570  17.481  51.456  1.00 66.03           N  
ATOM   2594  CA  LYS D  52      53.357  16.703  51.702  1.00 64.02           C  
ATOM   2595  C   LYS D  52      52.121  17.587  51.675  1.00 61.73           C  
ATOM   2596  O   LYS D  52      51.069  17.178  51.187  1.00 61.64           O  
ATOM   2597  CB  LYS D  52      53.434  15.984  53.047  1.00 63.66           C  
ATOM   2598  CG  LYS D  52      54.588  15.001  53.197  1.00 64.74           C  
ATOM   2599  CD  LYS D  52      54.315  14.048  54.361  1.00 64.18           C  
ATOM   2600  CE  LYS D  52      55.579  13.411  54.922  1.00 66.22           C  
ATOM   2601  NZ  LYS D  52      55.274  12.691  56.184  1.00 65.24           N  
ATOM   2602  N   THR D  53      52.259  18.797  52.208  1.00 59.99           N  
ATOM   2603  CA  THR D  53      51.188  19.782  52.191  1.00 58.05           C  
ATOM   2604  C   THR D  53      51.003  20.357  50.800  1.00 57.42           C  
ATOM   2605  O   THR D  53      49.885  20.649  50.400  1.00 55.61           O  
ATOM   2606  CB  THR D  53      51.475  20.925  53.176  1.00 58.17           C  
ATOM   2607  OG1 THR D  53      51.685  20.381  54.486  1.00 57.56           O  
ATOM   2608  CG2 THR D  53      50.319  21.909  53.222  1.00 57.10           C  
ATOM   2609  N   GLN D  54      52.098  20.512  50.049  1.00 57.75           N  
ATOM   2610  CA  GLN D  54      51.993  21.035  48.690  1.00 57.49           C  
ATOM   2611  C   GLN D  54      51.190  20.088  47.794  1.00 55.84           C  
ATOM   2612  O   GLN D  54      50.499  20.548  46.878  1.00 55.54           O  
ATOM   2613  CB  GLN D  54      53.375  21.330  48.085  1.00 59.42           C  
ATOM   2614  CG  GLN D  54      53.329  21.957  46.691  1.00 61.87           C  
ATOM   2615  CD  GLN D  54      52.655  23.330  46.647  1.00 64.75           C  
ATOM   2616  OE1 GLN D  54      52.562  24.029  47.657  1.00 67.70           O  
ATOM   2617  NE2 GLN D  54      52.198  23.725  45.459  1.00 67.73           N  
ATOM   2618  N   ARG D  55      51.255  18.786  48.065  1.00 54.62           N  
ATOM   2619  CA  ARG D  55      50.468  17.825  47.294  1.00 54.43           C  
ATOM   2620  C   ARG D  55      48.965  18.006  47.547  1.00 52.18           C  
ATOM   2621  O   ARG D  55      48.147  18.001  46.605  1.00 51.67           O  
ATOM   2622  CB  ARG D  55      50.900  16.397  47.585  1.00 55.17           C  
ATOM   2623  CG  ARG D  55      50.559  15.432  46.449  1.00 58.28           C  
ATOM   2624  CD  ARG D  55      51.399  14.142  46.544  1.00 61.94           C  
ATOM   2625  NE  ARG D  55      50.618  12.960  46.167  1.00 63.75           N  
ATOM   2626  CZ  ARG D  55      49.639  12.433  46.915  1.00 63.63           C  
ATOM   2627  NH1 ARG D  55      49.308  12.985  48.073  1.00 63.55           N  
ATOM   2628  NH2 ARG D  55      48.973  11.353  46.506  1.00 63.49           N  
ATOM   2629  N   LEU D  56      48.605  18.184  48.816  1.00 50.00           N  
ATOM   2630  CA  LEU D  56      47.238  18.588  49.157  1.00 47.96           C  
ATOM   2631  C   LEU D  56      46.856  19.803  48.321  1.00 48.29           C  
ATOM   2632  O   LEU D  56      45.869  19.781  47.576  1.00 47.25           O  
ATOM   2633  CB  LEU D  56      47.143  18.926  50.658  1.00 47.24           C  
ATOM   2634  CG  LEU D  56      45.860  19.620  51.159  1.00 45.82           C  
ATOM   2635  CD1 LEU D  56      44.650  18.856  50.735  1.00 44.26           C  
ATOM   2636  CD2 LEU D  56      45.883  19.749  52.642  1.00 45.01           C  
ATOM   2637  N   VAL D  57      47.685  20.845  48.417  1.00 49.41           N  
ATOM   2638  CA  VAL D  57      47.428  22.127  47.743  1.00 50.51           C  
ATOM   2639  C   VAL D  57      47.192  21.991  46.244  1.00 51.91           C  
ATOM   2640  O   VAL D  57      46.338  22.698  45.700  1.00 52.06           O  
ATOM   2641  CB  VAL D  57      48.574  23.125  47.956  1.00 51.27           C  
ATOM   2642  CG1 VAL D  57      48.290  24.395  47.203  1.00 52.38           C  
ATOM   2643  CG2 VAL D  57      48.754  23.443  49.439  1.00 51.13           C  
ATOM   2644  N   GLU D  58      47.984  21.124  45.594  1.00 53.22           N  
ATOM   2645  CA  GLU D  58      47.828  20.773  44.176  1.00 54.97           C  
ATOM   2646  C   GLU D  58      46.459  20.213  43.811  1.00 54.16           C  
ATOM   2647  O   GLU D  58      45.983  20.418  42.686  1.00 54.05           O  
ATOM   2648  CB  GLU D  58      48.837  19.686  43.767  1.00 56.16           C  
ATOM   2649  CG  GLU D  58      50.227  20.152  43.415  1.00 59.37           C  
ATOM   2650  CD  GLU D  58      50.984  19.096  42.587  1.00 60.33           C  
ATOM   2651  OE1 GLU D  58      51.372  18.027  43.135  1.00 62.36           O  
ATOM   2652  OE2 GLU D  58      51.181  19.343  41.375  1.00 65.34           O  
ATOM   2653  N   GLU D  59      45.854  19.451  44.729  1.00 52.66           N  
ATOM   2654  CA  GLU D  59      44.564  18.813  44.458  1.00 52.10           C  
ATOM   2655  C   GLU D  59      43.349  19.691  44.783  1.00 50.57           C  
ATOM   2656  O   GLU D  59      42.220  19.318  44.462  1.00 50.03           O  
ATOM   2657  CB  GLU D  59      44.438  17.481  45.222  1.00 51.91           C  
ATOM   2658  CG  GLU D  59      45.225  16.324  44.652  1.00 53.98           C  
ATOM   2659  CD  GLU D  59      44.813  14.993  45.263  1.00 53.77           C  
ATOM   2660  OE1 GLU D  59      45.664  14.355  45.933  1.00 56.65           O  
ATOM   2661  OE2 GLU D  59      43.637  14.587  45.094  1.00 55.96           O  
ATOM   2662  N   ILE D  60      43.551  20.836  45.425  1.00 49.86           N  
ATOM   2663  CA  ILE D  60      42.409  21.644  45.837  1.00 49.10           C  
ATOM   2664  C   ILE D  60      41.726  22.366  44.660  1.00 49.24           C  
ATOM   2665  O   ILE D  60      42.285  23.331  44.109  1.00 51.05           O  
ATOM   2666  CB  ILE D  60      42.760  22.646  46.986  1.00 48.77           C  
ATOM   2667  CG1 ILE D  60      43.296  21.916  48.224  1.00 47.64           C  
ATOM   2668  CG2 ILE D  60      41.519  23.445  47.363  1.00 48.50           C  
ATOM   2669  CD1 ILE D  60      43.897  22.827  49.314  1.00 47.34           C  
ATOM   2670  N   ALA D  61      40.530  21.885  44.286  1.00 47.95           N  
ATOM   2671  CA  ALA D  61      39.681  22.517  43.261  1.00 47.45           C  
ATOM   2672  C   ALA D  61      38.554  23.382  43.821  1.00 46.16           C  
ATOM   2673  O   ALA D  61      37.987  24.209  43.095  1.00 45.47           O  
ATOM   2674  CB  ALA D  61      39.074  21.463  42.363  1.00 48.51           C  
ATOM   2675  N   ASP D  62      38.205  23.191  45.105  1.00 43.51           N  
ATOM   2676  CA  ASP D  62      37.072  23.873  45.684  1.00 42.03           C  
ATOM   2677  C   ASP D  62      37.131  23.652  47.208  1.00 40.36           C  
ATOM   2678  O   ASP D  62      37.886  22.821  47.690  1.00 39.15           O  
ATOM   2679  CB  ASP D  62      35.787  23.264  45.112  1.00 42.29           C  
ATOM   2680  CG  ASP D  62      34.557  24.054  45.435  1.00 43.76           C  
ATOM   2681  OD1 ASP D  62      34.666  25.242  45.834  1.00 45.64           O  
ATOM   2682  OD2 ASP D  62      33.457  23.465  45.314  1.00 47.69           O  
ATOM   2683  N   PHE D  63      36.382  24.432  47.968  1.00 39.45           N  
ATOM   2684  CA  PHE D  63      36.314  24.188  49.416  1.00 38.19           C  
ATOM   2685  C   PHE D  63      35.002  24.673  49.944  1.00 37.80           C  
ATOM   2686  O   PHE D  63      34.294  25.435  49.305  1.00 36.79           O  
ATOM   2687  CB  PHE D  63      37.451  24.888  50.155  1.00 38.38           C  
ATOM   2688  CG  PHE D  63      37.385  26.377  50.072  1.00 39.14           C  
ATOM   2689  CD1 PHE D  63      36.701  27.108  51.020  1.00 41.25           C  
ATOM   2690  CD2 PHE D  63      37.991  27.055  49.009  1.00 42.39           C  
ATOM   2691  CE1 PHE D  63      36.622  28.495  50.930  1.00 42.15           C  
ATOM   2692  CE2 PHE D  63      37.912  28.442  48.907  1.00 40.10           C  
ATOM   2693  CZ  PHE D  63      37.236  29.168  49.869  1.00 39.12           C  
ATOM   2694  N   GLU D  64      34.725  24.263  51.169  1.00 37.28           N  
ATOM   2695  CA  GLU D  64      33.484  24.605  51.833  1.00 37.65           C  
ATOM   2696  C   GLU D  64      33.845  24.795  53.301  1.00 34.68           C  
ATOM   2697  O   GLU D  64      34.940  24.426  53.738  1.00 32.09           O  
ATOM   2698  CB  GLU D  64      32.489  23.467  51.538  1.00 38.27           C  
ATOM   2699  CG  GLU D  64      31.288  23.298  52.430  1.00 41.62           C  
ATOM   2700  CD  GLU D  64      30.369  22.200  51.898  1.00 43.66           C  
ATOM   2701  OE1 GLU D  64      29.424  21.783  52.605  1.00 50.16           O  
ATOM   2702  OE2 GLU D  64      30.585  21.793  50.723  1.00 52.32           O  
ATOM   2703  N   TYR D  65      33.000  25.488  54.050  1.00 33.17           N  
ATOM   2704  CA  TYR D  65      33.283  25.660  55.461  1.00 31.52           C  
ATOM   2705  C   TYR D  65      32.012  25.761  56.212  1.00 30.31           C  
ATOM   2706  O   TYR D  65      30.963  26.056  55.617  1.00 29.06           O  
ATOM   2707  CB  TYR D  65      34.185  26.848  55.742  1.00 32.35           C  
ATOM   2708  CG  TYR D  65      33.728  28.163  55.153  1.00 36.11           C  
ATOM   2709  CD1 TYR D  65      34.202  28.577  53.903  1.00 37.58           C  
ATOM   2710  CD2 TYR D  65      32.856  28.998  55.833  1.00 35.12           C  
ATOM   2711  CE1 TYR D  65      33.790  29.775  53.338  1.00 39.28           C  
ATOM   2712  CE2 TYR D  65      32.441  30.212  55.274  1.00 36.84           C  
ATOM   2713  CZ  TYR D  65      32.928  30.589  54.035  1.00 38.11           C  
ATOM   2714  OH  TYR D  65      32.579  31.783  53.475  1.00 39.63           O  
ATOM   2715  N   ILE D  66      32.110  25.474  57.514  1.00 27.97           N  
ATOM   2716  CA  ILE D  66      30.977  25.530  58.437  1.00 27.00           C  
ATOM   2717  C   ILE D  66      31.405  26.360  59.631  1.00 26.24           C  
ATOM   2718  O   ILE D  66      32.389  26.026  60.299  1.00 25.54           O  
ATOM   2719  CB  ILE D  66      30.536  24.132  58.923  1.00 27.56           C  
ATOM   2720  CG1 ILE D  66      30.209  23.245  57.733  1.00 30.56           C  
ATOM   2721  CG2 ILE D  66      29.311  24.216  59.860  1.00 27.05           C  
ATOM   2722  CD1 ILE D  66      30.117  21.839  58.116  1.00 34.49           C  
ATOM   2723  N   VAL D  67      30.708  27.478  59.846  1.00 24.86           N  
ATOM   2724  CA  VAL D  67      31.021  28.389  60.940  1.00 24.07           C  
ATOM   2725  C   VAL D  67      30.456  27.825  62.254  1.00 23.56           C  
ATOM   2726  O   VAL D  67      29.369  27.291  62.278  1.00 24.03           O  
ATOM   2727  CB  VAL D  67      30.450  29.798  60.668  1.00 23.78           C  
ATOM   2728  CG1 VAL D  67      30.737  30.727  61.790  1.00 23.81           C  
ATOM   2729  CG2 VAL D  67      31.046  30.380  59.388  1.00 23.89           C  
ATOM   2730  N   THR D  68      31.217  27.963  63.343  1.00 24.13           N  
ATOM   2731  CA  THR D  68      30.780  27.515  64.670  1.00 24.56           C  
ATOM   2732  C   THR D  68      30.691  28.698  65.621  1.00 24.99           C  
ATOM   2733  O   THR D  68      31.136  29.759  65.288  1.00 24.95           O  
ATOM   2734  CB  THR D  68      31.744  26.435  65.211  1.00 24.44           C  
ATOM   2735  OG1 THR D  68      33.078  26.953  65.243  1.00 25.00           O  
ATOM   2736  CG2 THR D  68      31.753  25.267  64.294  1.00 23.08           C  
ATOM   2737  N   SER D  69      30.099  28.519  66.797  1.00 26.66           N  
ATOM   2738  CA  SER D  69      29.989  29.597  67.771  1.00 27.77           C  
ATOM   2739  C   SER D  69      31.282  29.901  68.488  1.00 28.02           C  
ATOM   2740  O   SER D  69      31.448  31.001  69.017  1.00 29.78           O  
ATOM   2741  CB  SER D  69      28.956  29.260  68.853  1.00 29.63           C  
ATOM   2742  OG  SER D  69      29.146  27.979  69.408  1.00 29.29           O  
ATOM   2743  N   SER D  70      32.204  28.940  68.523  1.00 26.89           N  
ATOM   2744  CA  SER D  70      33.387  29.076  69.382  1.00 25.89           C  
ATOM   2745  C   SER D  70      34.466  28.133  68.896  1.00 25.36           C  
ATOM   2746  O   SER D  70      34.226  27.269  68.031  1.00 23.07           O  
ATOM   2747  CB  SER D  70      33.028  28.705  70.821  1.00 26.10           C  
ATOM   2748  OG  SER D  70      32.655  27.338  70.875  1.00 24.73           O  
ATOM   2749  N   ASN D  71      35.657  28.284  69.469  1.00 25.76           N  
ATOM   2750  CA  ASN D  71      36.733  27.367  69.145  1.00 25.51           C  
ATOM   2751  C   ASN D  71      36.377  25.980  69.653  1.00 23.78           C  
ATOM   2752  O   ASN D  71      36.707  24.987  69.028  1.00 24.98           O  
ATOM   2753  CB  ASN D  71      38.052  27.843  69.759  1.00 27.29           C  
ATOM   2754  CG  ASN D  71      38.522  29.172  69.199  1.00 32.75           C  
ATOM   2755  OD1 ASN D  71      38.210  29.512  68.068  1.00 37.55           O  
ATOM   2756  ND2 ASN D  71      39.343  29.915  69.984  1.00 38.15           N  
ATOM   2757  N   ALA D  72      35.694  25.888  70.802  1.00 23.31           N  
ATOM   2758  CA  ALA D  72      35.340  24.586  71.374  1.00 21.63           C  
ATOM   2759  C   ALA D  72      34.450  23.803  70.395  1.00 22.19           C  
ATOM   2760  O   ALA D  72      34.695  22.613  70.102  1.00 21.45           O  
ATOM   2761  CB  ALA D  72      34.663  24.752  72.673  1.00 20.42           C  
ATOM   2762  N   GLU D  73      33.461  24.495  69.827  1.00 22.90           N  
ATOM   2763  CA  GLU D  73      32.562  23.846  68.871  1.00 23.04           C  
ATOM   2764  C   GLU D  73      33.250  23.515  67.577  1.00 22.45           C  
ATOM   2765  O   GLU D  73      32.893  22.516  66.974  1.00 23.79           O  
ATOM   2766  CB  GLU D  73      31.256  24.654  68.637  1.00 24.06           C  
ATOM   2767  CG  GLU D  73      30.333  24.657  69.849  1.00 29.52           C  
ATOM   2768  CD  GLU D  73      29.958  23.234  70.368  1.00 34.72           C  
ATOM   2769  OE1 GLU D  73      29.723  22.337  69.517  1.00 32.45           O  
ATOM   2770  OE2 GLU D  73      29.892  23.022  71.622  1.00 34.73           O  
ATOM   2771  N   ALA D  74      34.223  24.323  67.130  1.00 21.80           N  
ATOM   2772  CA  ALA D  74      35.012  24.027  65.955  1.00 21.15           C  
ATOM   2773  C   ALA D  74      35.830  22.757  66.132  1.00 22.43           C  
ATOM   2774  O   ALA D  74      35.899  21.956  65.218  1.00 22.85           O  
ATOM   2775  CB  ALA D  74      35.927  25.212  65.589  1.00 22.84           C  
ATOM   2776  N   LEU D  75      36.368  22.535  67.333  1.00 22.55           N  
ATOM   2777  CA  LEU D  75      37.091  21.294  67.604  1.00 23.35           C  
ATOM   2778  C   LEU D  75      36.206  20.049  67.484  1.00 22.33           C  
ATOM   2779  O   LEU D  75      36.554  19.073  66.838  1.00 23.36           O  
ATOM   2780  CB  LEU D  75      37.804  21.331  68.974  1.00 24.03           C  
ATOM   2781  CG  LEU D  75      38.711  20.107  68.829  1.00 27.57           C  
ATOM   2782  CD1 LEU D  75      40.153  20.454  68.624  1.00 29.31           C  
ATOM   2783  CD2 LEU D  75      38.334  18.907  69.753  1.00 24.92           C  
ATOM   2784  N   ILE D  76      35.086  20.077  68.178  1.00 23.06           N  
ATOM   2785  CA  ILE D  76      34.085  19.003  68.159  1.00 21.54           C  
ATOM   2786  C   ILE D  76      33.597  18.697  66.716  1.00 21.93           C  
ATOM   2787  O   ILE D  76      33.489  17.516  66.293  1.00 20.95           O  
ATOM   2788  CB  ILE D  76      32.940  19.356  69.110  1.00 22.26           C  
ATOM   2789  CG1 ILE D  76      33.441  19.424  70.556  1.00 20.63           C  
ATOM   2790  CG2 ILE D  76      31.768  18.278  69.050  1.00 23.11           C  
ATOM   2791  CD1 ILE D  76      32.550  20.224  71.534  1.00 20.52           C  
ATOM   2792  N   LEU D  77      33.265  19.752  65.987  1.00 21.30           N  
ATOM   2793  CA  LEU D  77      32.836  19.609  64.602  1.00 21.71           C  
ATOM   2794  C   LEU D  77      33.947  19.007  63.771  1.00 22.07           C  
ATOM   2795  O   LEU D  77      33.705  18.161  62.905  1.00 22.82           O  
ATOM   2796  CB  LEU D  77      32.394  20.951  64.047  1.00 21.13           C  
ATOM   2797  CG  LEU D  77      31.932  20.951  62.603  1.00 21.37           C  
ATOM   2798  CD1 LEU D  77      30.661  20.130  62.488  1.00 20.84           C  
ATOM   2799  CD2 LEU D  77      31.684  22.327  62.132  1.00 22.72           C  
ATOM   2800  N   GLU D  78      35.171  19.461  63.993  1.00 23.69           N  
ATOM   2801  CA  GLU D  78      36.310  18.938  63.248  1.00 24.33           C  
ATOM   2802  C   GLU D  78      36.419  17.425  63.338  1.00 24.67           C  
ATOM   2803  O   GLU D  78      36.536  16.754  62.317  1.00 24.94           O  
ATOM   2804  CB  GLU D  78      37.602  19.591  63.715  1.00 26.32           C  
ATOM   2805  CG  GLU D  78      38.779  19.127  62.916  1.00 26.78           C  
ATOM   2806  CD  GLU D  78      40.136  19.303  63.607  1.00 30.90           C  
ATOM   2807  OE1 GLU D  78      40.268  19.580  64.855  1.00 29.09           O  
ATOM   2808  OE2 GLU D  78      41.074  19.159  62.818  1.00 36.99           O  
ATOM   2809  N   MET D  79      36.330  16.868  64.547  1.00 24.29           N  
ATOM   2810  CA  MET D  79      36.533  15.438  64.713  1.00 24.82           C  
ATOM   2811  C   MET D  79      35.368  14.667  64.100  1.00 24.36           C  
ATOM   2812  O   MET D  79      35.571  13.564  63.571  1.00 24.40           O  
ATOM   2813  CB  MET D  79      36.700  15.055  66.162  1.00 26.29           C  
ATOM   2814  CG  MET D  79      37.921  15.688  66.821  1.00 27.21           C  
ATOM   2815  SD  MET D  79      39.406  15.361  65.840  1.00 30.52           S  
ATOM   2816  CE  MET D  79      39.634  16.892  65.196  1.00 35.92           C  
ATOM   2817  N   ASN D  80      34.166  15.229  64.184  1.00 24.58           N  
ATOM   2818  CA  ASN D  80      32.979  14.592  63.606  1.00 23.66           C  
ATOM   2819  C   ASN D  80      33.017  14.590  62.077  1.00 23.75           C  
ATOM   2820  O   ASN D  80      32.667  13.584  61.438  1.00 24.39           O  
ATOM   2821  CB  ASN D  80      31.697  15.198  64.174  1.00 23.53           C  
ATOM   2822  CG  ASN D  80      31.394  14.678  65.567  1.00 24.41           C  
ATOM   2823  OD1 ASN D  80      30.803  13.626  65.722  1.00 24.70           O  
ATOM   2824  ND2 ASN D  80      31.827  15.394  66.578  1.00 21.64           N  
ATOM   2825  N   LEU D  81      33.488  15.679  61.501  1.00 24.30           N  
ATOM   2826  CA  LEU D  81      33.670  15.772  60.034  1.00 24.42           C  
ATOM   2827  C   LEU D  81      34.752  14.835  59.491  1.00 25.61           C  
ATOM   2828  O   LEU D  81      34.615  14.301  58.365  1.00 25.78           O  
ATOM   2829  CB  LEU D  81      33.984  17.194  59.612  1.00 23.83           C  
ATOM   2830  CG  LEU D  81      32.817  18.150  59.748  1.00 25.24           C  
ATOM   2831  CD1 LEU D  81      33.276  19.524  59.431  1.00 24.07           C  
ATOM   2832  CD2 LEU D  81      31.659  17.734  58.873  1.00 29.91           C  
ATOM   2833  N   ILE D  82      35.824  14.654  60.259  1.00 25.71           N  
ATOM   2834  CA  ILE D  82      36.896  13.684  59.918  1.00 26.98           C  
ATOM   2835  C   ILE D  82      36.304  12.243  59.923  1.00 28.00           C  
ATOM   2836  O   ILE D  82      36.556  11.455  59.007  1.00 27.77           O  
ATOM   2837  CB  ILE D  82      38.122  13.802  60.906  1.00 26.80           C  
ATOM   2838  CG1 ILE D  82      38.833  15.129  60.686  1.00 26.59           C  
ATOM   2839  CG2 ILE D  82      39.112  12.668  60.705  1.00 28.13           C  
ATOM   2840  CD1 ILE D  82      39.923  15.472  61.682  1.00 29.10           C  
ATOM   2841  N   LYS D  83      35.520  11.916  60.945  1.00 28.13           N  
ATOM   2842  CA  LYS D  83      34.828  10.628  61.006  1.00 30.17           C  
ATOM   2843  C   LYS D  83      33.893  10.442  59.817  1.00 29.83           C  
ATOM   2844  O   LYS D  83      33.833   9.368  59.219  1.00 30.69           O  
ATOM   2845  CB  LYS D  83      33.997  10.528  62.280  1.00 31.24           C  
ATOM   2846  CG  LYS D  83      33.306   9.177  62.507  1.00 34.05           C  
ATOM   2847  CD  LYS D  83      34.278   8.151  63.005  1.00 39.33           C  
ATOM   2848  CE  LYS D  83      33.672   6.774  63.242  1.00 40.92           C  
ATOM   2849  NZ  LYS D  83      34.171   5.774  62.242  1.00 44.43           N  
ATOM   2850  N   LYS D  84      33.130  11.471  59.511  1.00 29.52           N  
ATOM   2851  CA  LYS D  84      32.176  11.402  58.402  1.00 30.42           C  
ATOM   2852  C   LYS D  84      32.860  11.192  57.037  1.00 31.09           C  
ATOM   2853  O   LYS D  84      32.411  10.374  56.215  1.00 32.62           O  
ATOM   2854  CB  LYS D  84      31.351  12.677  58.350  1.00 29.53           C  
ATOM   2855  CG  LYS D  84      30.217  12.637  57.286  1.00 31.56           C  
ATOM   2856  CD  LYS D  84      29.265  13.801  57.417  1.00 31.30           C  
ATOM   2857  CE  LYS D  84      28.086  13.616  56.480  1.00 36.25           C  
ATOM   2858  NZ  LYS D  84      27.290  14.845  56.458  1.00 34.44           N  
ATOM   2859  N   HIS D  85      33.927  11.928  56.770  1.00 31.07           N  
ATOM   2860  CA  HIS D  85      34.485  11.960  55.409  1.00 32.64           C  
ATOM   2861  C   HIS D  85      35.761  11.172  55.255  1.00 33.63           C  
ATOM   2862  O   HIS D  85      36.204  10.912  54.121  1.00 34.67           O  
ATOM   2863  CB  HIS D  85      34.696  13.409  54.965  1.00 31.63           C  
ATOM   2864  CG  HIS D  85      33.428  14.205  54.884  1.00 32.34           C  
ATOM   2865  ND1 HIS D  85      32.461  13.979  53.918  1.00 30.69           N  
ATOM   2866  CD2 HIS D  85      32.967  15.229  55.649  1.00 30.66           C  
ATOM   2867  CE1 HIS D  85      31.472  14.840  54.086  1.00 33.17           C  
ATOM   2868  NE2 HIS D  85      31.746  15.599  55.138  1.00 31.33           N  
ATOM   2869  N   ASP D  86      36.374  10.829  56.375  1.00 33.47           N  
ATOM   2870  CA  ASP D  86      37.655  10.132  56.384  1.00 35.68           C  
ATOM   2871  C   ASP D  86      38.605  10.639  55.262  1.00 36.40           C  
ATOM   2872  O   ASP D  86      39.012   9.862  54.393  1.00 37.04           O  
ATOM   2873  CB  ASP D  86      37.383   8.624  56.255  1.00 36.98           C  
ATOM   2874  CG  ASP D  86      38.645   7.802  56.316  1.00 39.24           C  
ATOM   2875  OD1 ASP D  86      39.514   8.115  57.148  1.00 40.71           O  
ATOM   2876  OD2 ASP D  86      38.748   6.853  55.514  1.00 42.74           O  
ATOM   2877  N   PRO D  87      38.980  11.938  55.298  1.00 35.50           N  
ATOM   2878  CA  PRO D  87      39.673  12.573  54.169  1.00 35.87           C  
ATOM   2879  C   PRO D  87      41.114  12.101  53.993  1.00 38.00           C  
ATOM   2880  O   PRO D  87      41.840  11.997  54.978  1.00 36.69           O  
ATOM   2881  CB  PRO D  87      39.630  14.060  54.514  1.00 34.67           C  
ATOM   2882  CG  PRO D  87      38.669  14.206  55.666  1.00 34.16           C  
ATOM   2883  CD  PRO D  87      38.798  12.895  56.410  1.00 35.12           C  
ATOM   2884  N   LYS D  88      41.518  11.846  52.736  1.00 39.97           N  
ATOM   2885  CA  LYS D  88      42.824  11.234  52.467  1.00 42.27           C  
ATOM   2886  C   LYS D  88      43.954  11.996  53.119  1.00 42.17           C  
ATOM   2887  O   LYS D  88      44.839  11.397  53.701  1.00 42.83           O  
ATOM   2888  CB  LYS D  88      43.093  11.033  50.951  1.00 43.44           C  
ATOM   2889  CG  LYS D  88      43.313  12.300  50.143  1.00 45.18           C  
ATOM   2890  CD  LYS D  88      44.245  12.086  48.927  1.00 47.19           C  
ATOM   2891  CE  LYS D  88      43.517  11.650  47.675  1.00 48.87           C  
ATOM   2892  NZ  LYS D  88      44.483  11.527  46.497  1.00 51.54           N  
ATOM   2893  N   TYR D  89      43.933  13.325  53.060  1.00 42.28           N  
ATOM   2894  CA  TYR D  89      45.077  14.064  53.588  1.00 42.43           C  
ATOM   2895  C   TYR D  89      45.133  14.179  55.103  1.00 42.20           C  
ATOM   2896  O   TYR D  89      46.196  14.465  55.639  1.00 41.67           O  
ATOM   2897  CB  TYR D  89      45.229  15.413  52.899  1.00 43.07           C  
ATOM   2898  CG  TYR D  89      45.798  15.273  51.503  1.00 44.09           C  
ATOM   2899  CD1 TYR D  89      47.150  14.970  51.307  1.00 45.25           C  
ATOM   2900  CD2 TYR D  89      44.996  15.420  50.384  1.00 44.74           C  
ATOM   2901  CE1 TYR D  89      47.683  14.843  50.036  1.00 45.91           C  
ATOM   2902  CE2 TYR D  89      45.532  15.295  49.085  1.00 46.56           C  
ATOM   2903  CZ  TYR D  89      46.872  14.994  48.919  1.00 46.91           C  
ATOM   2904  OH  TYR D  89      47.398  14.869  47.625  1.00 47.28           O  
ATOM   2905  N   ASN D  90      44.011  13.953  55.795  1.00 41.38           N  
ATOM   2906  CA  ASN D  90      44.050  13.888  57.252  1.00 42.39           C  
ATOM   2907  C   ASN D  90      44.874  12.712  57.796  1.00 45.45           C  
ATOM   2908  O   ASN D  90      45.562  12.854  58.800  1.00 46.48           O  
ATOM   2909  CB  ASN D  90      42.641  13.867  57.850  1.00 40.81           C  
ATOM   2910  CG  ASN D  90      42.010  15.228  57.820  1.00 35.62           C  
ATOM   2911  OD1 ASN D  90      41.489  15.637  56.800  1.00 31.96           O  
ATOM   2912  ND2 ASN D  90      42.136  15.970  58.906  1.00 29.26           N  
ATOM   2913  N   VAL D  91      44.819  11.568  57.130  1.00 48.57           N  
ATOM   2914  CA  VAL D  91      45.607  10.408  57.573  1.00 51.69           C  
ATOM   2915  C   VAL D  91      47.075  10.542  57.116  1.00 54.10           C  
ATOM   2916  O   VAL D  91      47.986  10.244  57.882  1.00 54.94           O  
ATOM   2917  CB  VAL D  91      44.981   9.045  57.133  1.00 52.24           C  
ATOM   2918  CG1 VAL D  91      43.429   9.106  57.116  1.00 51.62           C  
ATOM   2919  CG2 VAL D  91      45.494   8.580  55.788  1.00 54.99           C  
ATOM   2920  N   MET D  92      47.296  11.041  55.895  1.00 56.71           N  
ATOM   2921  CA  MET D  92      48.659  11.172  55.336  1.00 59.22           C  
ATOM   2922  C   MET D  92      49.488  12.243  56.042  1.00 60.95           C  
ATOM   2923  O   MET D  92      50.692  12.070  56.231  1.00 61.84           O  
ATOM   2924  CB  MET D  92      48.627  11.518  53.842  1.00 59.64           C  
ATOM   2925  CG  MET D  92      47.916  10.532  52.926  1.00 60.33           C  
ATOM   2926  SD  MET D  92      48.366   8.824  53.201  1.00 64.98           S  
ATOM   2927  CE  MET D  92      50.148   8.915  53.074  1.00 67.12           C  
ATOM   2928  N   LEU D  93      48.846  13.348  56.419  1.00 61.72           N  
ATOM   2929  CA  LEU D  93      49.546  14.471  57.036  1.00 63.46           C  
ATOM   2930  C   LEU D  93      49.539  14.444  58.559  1.00 65.39           C  
ATOM   2931  O   LEU D  93      50.049  15.375  59.188  1.00 65.86           O  
ATOM   2932  CB  LEU D  93      48.922  15.790  56.573  1.00 62.60           C  
ATOM   2933  CG  LEU D  93      48.842  16.065  55.071  1.00 61.63           C  
ATOM   2934  CD1 LEU D  93      48.143  17.390  54.838  1.00 60.59           C  
ATOM   2935  CD2 LEU D  93      50.232  16.067  54.435  1.00 62.28           C  
ATOM   2936  N   LYS D  94      48.973  13.395  59.159  1.00 67.92           N  
ATOM   2937  CA  LYS D  94      48.812  13.348  60.623  1.00 69.83           C  
ATOM   2938  C   LYS D  94      50.142  13.254  61.378  1.00 72.83           C  
ATOM   2939  O   LYS D  94      50.502  14.176  62.112  1.00 73.35           O  
ATOM   2940  CB  LYS D  94      47.882  12.201  61.055  1.00 69.29           C  
ATOM   2941  CG  LYS D  94      47.336  12.389  62.459  1.00 69.14           C  
ATOM   2942  CD  LYS D  94      46.646  11.150  63.004  1.00 69.41           C  
ATOM   2943  CE  LYS D  94      45.252  10.954  62.426  1.00 69.45           C  
ATOM   2944  NZ  LYS D  94      44.491   9.927  63.202  1.00 69.64           N  
ATOM   2945  N   ASP D  95      50.865  12.147  61.196  1.00 76.12           N  
ATOM   2946  CA  ASP D  95      52.128  11.906  61.919  1.00 78.95           C  
ATOM   2947  C   ASP D  95      53.203  12.917  61.512  1.00 80.95           C  
ATOM   2948  O   ASP D  95      52.998  13.709  60.589  1.00 80.72           O  
ATOM   2949  CB  ASP D  95      52.631  10.462  61.698  1.00 80.08           C  
ATOM   2950  CG  ASP D  95      51.870   9.416  62.540  1.00 80.46           C  
ATOM   2951  OD1 ASP D  95      50.990   9.782  63.355  1.00 80.52           O  
ATOM   2952  OD2 ASP D  95      52.173   8.208  62.389  1.00 82.17           O  
ATOM   2953  N   ASP D  96      54.349  12.879  62.195  1.00 74.13           N  
ATOM   2954  CA  ASP D  96      55.415  13.882  61.983  1.00 75.23           C  
ATOM   2955  C   ASP D  96      56.104  13.771  60.608  1.00 75.82           C  
ATOM   2956  O   ASP D  96      55.748  12.910  59.793  1.00 75.93           O  
ATOM   2957  CB  ASP D  96      56.449  13.841  63.123  1.00 75.51           C  
ATOM   2958  CG  ASP D  96      57.418  12.679  62.999  1.00 76.45           C  
ATOM   2959  OD1 ASP D  96      56.977  11.508  63.125  1.00 77.86           O  
ATOM   2960  OD2 ASP D  96      58.624  12.946  62.789  1.00 78.36           O  
ATOM   2961  N   LYS D  97      57.081  14.656  60.382  1.00 76.43           N  
ATOM   2962  CA  LYS D  97      57.801  14.820  59.104  1.00 76.78           C  
ATOM   2963  C   LYS D  97      56.969  15.619  58.100  1.00 76.97           C  
ATOM   2964  O   LYS D  97      57.502  16.457  57.366  1.00 77.32           O  
ATOM   2965  CB  LYS D  97      58.248  13.486  58.484  1.00 76.81           C  
ATOM   2966  CG  LYS D  97      59.466  12.850  59.132  1.00 77.00           C  
ATOM   2967  CD  LYS D  97      59.807  11.550  58.414  1.00 77.02           C  
ATOM   2968  CE  LYS D  97      61.250  11.119  58.628  1.00 77.19           C  
ATOM   2969  NZ  LYS D  97      61.614   9.988  57.725  1.00 76.90           N  
TER    2970      LYS D  97                                                      
END
MOLECULE T0510_235_279.pdb
ATOM   1792  N   PRO   235      38.119  38.837  68.304  1.00 56.78           N  
ATOM   1793  CA  PRO   235      37.403  37.612  68.588  1.00 57.06           C  
ATOM   1794  CB  PRO   235      36.009  38.107  68.951  1.00 56.13           C  
ATOM   1795  CG  PRO   235      35.933  39.448  68.479  1.00 55.48           C  
ATOM   1796  CD  PRO   235      37.275  40.015  68.523  1.00 56.19           C  
ATOM   1797  C   PRO   235      37.351  36.729  67.327  1.00 57.69           C  
ATOM   1798  O   PRO   235      37.213  37.235  66.219  1.00 57.92           O  
ATOM   1799  N   PRO   236      37.425  35.413  67.493  1.00 58.22           N  
ATOM   1800  CA  PRO   236      37.744  34.610  66.340  1.00 58.10           C  
ATOM   1801  CB  PRO   236      38.325  33.359  66.970  1.00 58.25           C  
ATOM   1802  CG  PRO   236      37.422  33.136  68.189  1.00 58.04           C  
ATOM   1803  CD  PRO   236      37.156  34.577  68.688  1.00 58.45           C  
ATOM   1804  C   PRO   236      36.514  34.194  65.560  1.00 58.39           C  
ATOM   1805  O   PRO   236      35.378  34.320  66.042  1.00 57.01           O  
ATOM   1806  N   THR   237      36.794  33.661  64.368  1.00 58.97           N  
ATOM   1807  CA  THR   237      35.827  32.949  63.549  1.00 58.76           C  
ATOM   1808  CB  THR   237      35.868  33.463  62.189  1.00 58.85           C  
ATOM   1809  OG1 THR   237      35.466  34.831  62.260  1.00 59.79           O  
ATOM   1810  CG2 THR   237      34.924  32.670  61.320  1.00 59.79           C  
ATOM   1811  C   THR   237      36.136  31.476  63.538  1.00 58.51           C  
ATOM   1812  O   THR   237      37.034  30.979  62.852  1.00 57.58           O  
ATOM   1813  N   PRO   238      35.417  30.770  64.370  1.00 59.11           N  
ATOM   1814  CA  PRO   238      35.594  29.334  64.399  1.00 60.04           C  
ATOM   1815  CB  PRO   238      34.640  28.872  65.530  1.00 59.91           C  
ATOM   1816  CG  PRO   238      34.272  30.092  66.278  1.00 59.22           C  
ATOM   1817  CD  PRO   238      34.415  31.250  65.333  1.00 59.02           C  
ATOM   1818  C   PRO   238      35.165  28.771  63.055  1.00 60.41           C  
ATOM   1819  O   PRO   238      34.010  28.951  62.685  1.00 60.91           O  
ATOM   1820  N   ILE   239      36.068  28.097  62.346  1.00 60.56           N  
ATOM   1821  CA  ILE   239      35.797  27.704  60.989  1.00 60.68           C  
ATOM   1822  CB  ILE   239      36.312  28.777  60.065  1.00 60.69           C  
ATOM   1823  CG1 ILE   239      35.801  28.552  58.648  1.00 60.81           C  
ATOM   1824  CD1 ILE   239      35.547  29.854  57.941  1.00 61.28           C  
ATOM   1825  CG2 ILE   239      37.839  28.864  60.130  1.00 60.77           C  
ATOM   1826  C   ILE   239      36.379  26.382  60.582  1.00 60.66           C  
ATOM   1827  O   ILE   239      37.537  26.094  60.818  1.00 59.60           O  
ATOM   1828  N   PHE   240      35.525  25.600  59.937  1.00 62.55           N  
ATOM   1829  CA  PHE   240      35.832  24.268  59.367  1.00 63.50           C  
ATOM   1830  CB  PHE   240      34.651  23.342  59.646  1.00 64.12           C  
ATOM   1831  CG  PHE   240      34.790  21.970  59.051  1.00 64.17           C  
ATOM   1832  CD1 PHE   240      35.617  21.019  59.641  1.00 65.39           C  
ATOM   1833  CE1 PHE   240      35.736  19.709  59.104  1.00 65.07           C  
ATOM   1834  CZ  PHE   240      35.031  19.366  57.986  1.00 64.69           C  
ATOM   1835  CE2 PHE   240      34.191  20.315  57.388  1.00 64.75           C  
ATOM   1836  CD2 PHE   240      34.064  21.603  57.926  1.00 65.49           C  
ATOM   1837  C   PHE   240      35.990  24.317  57.873  1.00 63.92           C  
ATOM   1838  O   PHE   240      35.179  24.925  57.207  1.00 63.86           O  
ATOM   1839  N   HIS   241      36.991  23.654  57.326  1.00 65.06           N  
ATOM   1840  CA  HIS   241      37.162  23.676  55.864  1.00 66.08           C  
ATOM   1841  CB  HIS   241      38.360  24.530  55.475  1.00 65.84           C  
ATOM   1842  CG  HIS   241      38.690  24.501  54.015  1.00 65.96           C  
ATOM   1843  ND1 HIS   241      39.422  23.487  53.441  1.00 67.40           N  
ATOM   1844  CE1 HIS   241      39.578  23.736  52.150  1.00 67.07           C  
ATOM   1845  NE2 HIS   241      38.995  24.887  51.873  1.00 66.00           N  
ATOM   1846  CD2 HIS   241      38.430  25.386  53.020  1.00 66.81           C  
ATOM   1847  C   HIS   241      37.340  22.270  55.334  1.00 67.20           C  
ATOM   1848  O   HIS   241      38.108  21.479  55.908  1.00 67.42           O  
ATOM   1849  N   ASN   243      38.456  20.577  51.720  1.00 70.21           N  
ATOM   1850  CA  ASN   243      38.872  20.490  50.320  1.00 71.02           C  
ATOM   1851  CB  ASN   243      40.393  20.391  50.203  1.00 70.84           C  
ATOM   1852  CG  ASN   243      40.867  20.603  48.780  1.00 71.08           C  
ATOM   1853  OD1 ASN   243      40.097  20.402  47.830  1.00 72.94           O  
ATOM   1854  ND2 ASN   243      42.115  21.034  48.615  1.00 70.41           N  
ATOM   1855  C   ASN   243      38.239  19.275  49.636  1.00 71.03           C  
ATOM   1856  O   ASN   243      38.421  18.144  50.084  1.00 70.81           O  
ATOM   1857  N   HIS   244      37.508  19.506  48.552  1.00 71.45           N  
ATOM   1858  CA  HIS   244      36.787  18.395  47.898  1.00 72.32           C  
ATOM   1859  CB  HIS   244      35.402  18.874  47.410  1.00 72.97           C  
ATOM   1860  CG  HIS   244      34.437  19.185  48.529  1.00 74.09           C  
ATOM   1861  ND1 HIS   244      33.738  18.205  49.213  1.00 74.28           N  
ATOM   1862  CE1 HIS   244      32.964  18.768  50.126  1.00 74.00           C  
ATOM   1863  NE2 HIS   244      33.141  20.077  50.069  1.00 75.08           N  
ATOM   1864  CD2 HIS   244      34.057  20.366  49.081  1.00 74.81           C  
ATOM   1865  C   HIS   244      37.635  17.685  46.796  1.00 72.19           C  
ATOM   1866  O   HIS   244      37.529  16.485  46.585  1.00 72.01           O  
ATOM   1867  N   GLU   245      38.460  18.474  46.123  1.00 72.31           N  
ATOM   1868  CA  GLU   245      39.709  18.048  45.463  1.00 72.01           C  
ATOM   1869  CB  GLU   245      40.497  19.361  45.129  1.00 72.78           C  
ATOM   1870  CG  GLU   245      41.727  19.257  44.268  1.00 73.32           C  
ATOM   1871  CD  GLU   245      41.544  18.244  43.188  1.00 76.23           C  
ATOM   1872  OE1 GLU   245      40.636  18.444  42.340  1.00 77.40           O  
ATOM   1873  OE2 GLU   245      42.278  17.226  43.215  1.00 78.17           O  
ATOM   1874  C   GLU   245      40.606  17.052  46.293  1.00 71.77           C  
ATOM   1875  O   GLU   245      40.915  15.970  45.819  1.00 71.98           O  
ATOM   1876  N   THR   246      41.012  17.429  47.513  1.00 70.83           N  
ATOM   1877  CA  THR   246      41.894  16.631  48.390  1.00 70.07           C  
ATOM   1878  CB  THR   246      42.591  17.557  49.490  1.00 70.62           C  
ATOM   1879  OG1 THR   246      43.300  18.623  48.856  1.00 72.35           O  
ATOM   1880  CG2 THR   246      43.565  16.796  50.431  1.00 70.20           C  
ATOM   1881  C   THR   246      41.156  15.559  49.177  1.00 69.07           C  
ATOM   1882  O   THR   246      41.751  14.554  49.507  1.00 68.80           O  
ATOM   1883  N   GLY   247      39.889  15.793  49.528  1.00 68.01           N  
ATOM   1884  CA  GLY   247      39.253  15.104  50.681  1.00 67.14           C  
ATOM   1885  C   GLY   247      39.628  15.674  52.076  1.00 66.27           C  
ATOM   1886  O   GLY   247      38.914  15.442  53.062  1.00 65.47           O  
ATOM   1887  N   LYS   248      40.735  16.425  52.163  1.00 65.09           N  
ATOM   1888  CA  LYS   248      41.247  16.980  53.435  1.00 64.76           C  
ATOM   1889  CB  LYS   248      42.490  17.837  53.175  1.00 64.40           C  
ATOM   1890  CG  LYS   248      43.265  18.218  54.419  1.00 63.97           C  
ATOM   1891  CD  LYS   248      44.549  18.932  54.018  1.00 65.03           C  
ATOM   1892  CE  LYS   248      45.393  19.478  55.199  1.00 64.61           C  
ATOM   1893  NZ  LYS   248      45.491  18.476  56.271  1.00 63.97           N  
ATOM   1894  C   LYS   248      40.235  17.812  54.281  1.00 64.50           C  
ATOM   1895  O   LYS   248      39.301  18.414  53.725  1.00 65.32           O  
ATOM   1896  N   GLU   249      40.437  17.820  55.613  1.00 63.10           N  
ATOM   1897  CA  GLU   249      39.711  18.671  56.557  1.00 61.95           C  
ATOM   1898  CB  GLU   249      38.701  17.865  57.368  1.00 61.30           C  
ATOM   1899  CG  GLU   249      37.888  16.895  56.496  1.00 62.51           C  
ATOM   1900  CD  GLU   249      36.815  16.060  57.232  1.00 62.38           C  
ATOM   1901  OE1 GLU   249      35.880  15.545  56.565  1.00 62.08           O  
ATOM   1902  OE2 GLU   249      36.908  15.881  58.462  1.00 64.07           O  
ATOM   1903  C   GLU   249      40.700  19.417  57.473  1.00 61.03           C  
ATOM   1904  O   GLU   249      41.782  18.955  57.811  1.00 59.65           O  
ATOM   1905  N   ASP   250      40.328  20.630  57.814  1.00 60.84           N  
ATOM   1906  CA  ASP   250      41.147  21.490  58.624  1.00 60.75           C  
ATOM   1907  CB  ASP   250      41.973  22.444  57.760  1.00 61.33           C  
ATOM   1908  CG  ASP   250      43.219  21.792  57.185  1.00 62.98           C  
ATOM   1909  OD1 ASP   250      44.233  21.684  57.907  1.00 66.92           O  
ATOM   1910  OD2 ASP   250      43.198  21.419  56.003  1.00 62.18           O  
ATOM   1911  C   ASP   250      40.177  22.293  59.427  1.00 60.32           C  
ATOM   1912  O   ASP   250      38.978  22.281  59.123  1.00 61.17           O  
ATOM   1913  N   PHE   251      40.696  22.980  60.442  1.00 59.37           N  
ATOM   1914  CA  PHE   251      39.938  23.933  61.245  1.00 58.83           C  
ATOM   1915  CB  PHE   251      39.381  23.259  62.514  1.00 59.11           C  
ATOM   1916  CG  PHE   251      40.481  22.660  63.451  1.00 59.95           C  
ATOM   1917  CD1 PHE   251      41.111  23.442  64.424  1.00 58.79           C  
ATOM   1918  CE1 PHE   251      42.096  22.927  65.237  1.00 57.67           C  
ATOM   1919  CZ  PHE   251      42.478  21.636  65.105  1.00 58.19           C  
ATOM   1920  CE2 PHE   251      41.853  20.812  64.175  1.00 59.69           C  
ATOM   1921  CD2 PHE   251      40.863  21.319  63.354  1.00 60.37           C  
ATOM   1922  C   PHE   251      40.875  25.040  61.655  1.00 57.73           C  
ATOM   1923  O   PHE   251      42.123  24.869  61.702  1.00 57.53           O  
ATOM   1924  N   TYR   252      40.300  26.173  61.996  1.00 56.75           N  
ATOM   1925  CA  TYR   252      41.122  27.216  62.554  1.00 56.78           C  
ATOM   1926  CB  TYR   252      42.047  27.786  61.469  1.00 55.88           C  
ATOM   1927  CG  TYR   252      43.392  28.272  61.964  1.00 56.06           C  
ATOM   1928  CD1 TYR   252      44.327  27.405  62.576  1.00 55.18           C  
ATOM   1929  CE1 TYR   252      45.577  27.879  63.027  1.00 52.73           C  
ATOM   1930  CZ  TYR   252      45.863  29.213  62.896  1.00 53.97           C  
ATOM   1931  OH  TYR   252      47.041  29.791  63.292  1.00 53.82           O  
ATOM   1932  CE2 TYR   252      44.947  30.071  62.321  1.00 55.93           C  
ATOM   1933  CD2 TYR   252      43.734  29.602  61.840  1.00 55.08           C  
ATOM   1934  C   TYR   252      40.230  28.259  63.202  1.00 57.82           C  
ATOM   1935  O   TYR   252      39.044  28.023  63.417  1.00 57.92           O  
ATOM   1936  N   PHE   253      40.793  29.398  63.553  1.00 59.19           N  
ATOM   1937  CA  PHE   253      40.019  30.386  64.241  1.00 61.04           C  
ATOM   1938  CB  PHE   253      40.659  30.678  65.563  1.00 60.09           C  
ATOM   1939  CG  PHE   253      41.924  31.395  65.476  1.00 58.42           C  
ATOM   1940  CD1 PHE   253      41.959  32.751  65.633  1.00 57.78           C  
ATOM   1941  CE1 PHE   253      43.145  33.426  65.578  1.00 57.95           C  
ATOM   1942  CZ  PHE   253      44.302  32.742  65.380  1.00 58.46           C  
ATOM   1943  CE2 PHE   253      44.282  31.375  65.240  1.00 58.52           C  
ATOM   1944  CD2 PHE   253      43.099  30.710  65.302  1.00 58.84           C  
ATOM   1945  C   PHE   253      39.808  31.674  63.489  1.00 63.18           C  
ATOM   1946  O   PHE   253      39.107  32.571  64.012  1.00 64.05           O  
ATOM   1947  N   ILE   254      40.335  31.748  62.277  1.00 64.65           N  
ATOM   1948  CA  ILE   254      39.995  32.785  61.334  1.00 65.00           C  
ATOM   1949  CB  ILE   254      41.010  33.882  61.326  1.00 64.83           C  
ATOM   1950  CG1 ILE   254      42.361  33.338  60.945  1.00 65.22           C  
ATOM   1951  CD1 ILE   254      43.428  34.282  61.254  1.00 64.94           C  
ATOM   1952  CG2 ILE   254      41.097  34.504  62.662  1.00 61.98           C  
ATOM   1953  C   ILE   254      39.884  32.175  59.951  1.00 66.83           C  
ATOM   1954  O   ILE   254      40.234  31.030  59.774  1.00 66.77           O  
ATOM   1955  N   LYS   255      39.373  32.931  58.981  1.00 68.08           N  
ATOM   1956  CA  LYS   255      39.230  32.440  57.610  1.00 68.59           C  
ATOM   1957  CB  LYS   255      38.024  33.070  56.938  1.00 69.48           C  
ATOM   1958  CG  LYS   255      37.638  34.426  57.482  1.00 71.38           C  
ATOM   1959  CD  LYS   255      36.128  34.665  57.382  1.00 70.14           C  
ATOM   1960  CE  LYS   255      35.715  35.360  56.084  1.00 71.36           C  
ATOM   1961  NZ  LYS   255      34.897  36.577  56.341  1.00 71.32           N  
ATOM   1962  C   LYS   255      40.453  32.720  56.772  1.00 68.61           C  
ATOM   1963  O   LYS   255      40.916  33.833  56.714  1.00 68.72           O  
ATOM   1964  N   LEU   256      41.019  31.691  56.188  1.00 68.87           N  
ATOM   1965  CA  LEU   256      42.319  31.817  55.609  1.00 69.01           C  
ATOM   1966  CB  LEU   256      43.188  30.659  56.037  1.00 69.13           C  
ATOM   1967  CG  LEU   256      43.293  30.245  57.482  1.00 67.71           C  
ATOM   1968  CD1 LEU   256      44.203  29.095  57.529  1.00 65.84           C  
ATOM   1969  CD2 LEU   256      43.861  31.357  58.254  1.00 67.86           C  
ATOM   1970  C   LEU   256      42.226  31.754  54.136  1.00 69.34           C  
ATOM   1971  O   LEU   256      41.699  30.814  53.605  1.00 69.38           O  
ATOM   1972  N   ASN   257      42.784  32.741  53.471  1.00 70.12           N  
ATOM   1973  CA  ASN   257      42.708  32.768  52.040  1.00 71.01           C  
ATOM   1974  CB  ASN   257      43.523  33.932  51.462  1.00 72.03           C  
ATOM   1975  CG  ASN   257      44.763  33.498  50.759  1.00 74.02           C  
ATOM   1976  OD1 ASN   257      44.710  32.872  49.711  1.00 76.53           O  
ATOM   1977  ND2 ASN   257      45.906  33.863  51.315  1.00 77.28           N  
ATOM   1978  C   ASN   257      43.065  31.406  51.490  1.00 71.28           C  
ATOM   1979  O   ASN   257      42.814  31.105  50.341  1.00 71.37           O  
ATOM   1980  N   GLN   258      43.592  30.552  52.336  1.00 71.17           N  
ATOM   1981  CA  GLN   258      43.892  29.218  51.896  1.00 70.93           C  
ATOM   1982  CB  GLN   258      45.044  28.654  52.682  1.00 71.38           C  
ATOM   1983  CG  GLN   258      44.932  27.183  52.845  1.00 72.34           C  
ATOM   1984  CD  GLN   258      46.170  26.577  53.443  1.00 73.53           C  
ATOM   1985  OE1 GLN   258      46.970  27.268  54.084  1.00 75.13           O  
ATOM   1986  NE2 GLN   258      46.344  25.278  53.242  1.00 74.55           N  
ATOM   1987  C   GLN   258      42.735  28.289  52.078  1.00 69.69           C  
ATOM   1988  O   GLN   258      42.861  27.112  51.851  1.00 69.54           O  
ATOM   1989  N   PHE   259      41.608  28.808  52.510  1.00 69.38           N  
ATOM   1990  CA  PHE   259      40.513  27.936  52.871  1.00 69.56           C  
ATOM   1991  CB  PHE   259      39.897  28.350  54.189  1.00 68.92           C  
ATOM   1992  CG  PHE   259      40.420  27.581  55.352  1.00 69.40           C  
ATOM   1993  CD1 PHE   259      41.237  26.512  55.166  1.00 68.68           C  
ATOM   1994  CE1 PHE   259      41.715  25.831  56.220  1.00 67.71           C  
ATOM   1995  CZ  PHE   259      41.389  26.198  57.462  1.00 66.14           C  
ATOM   1996  CE2 PHE   259      40.595  27.245  57.666  1.00 66.90           C  
ATOM   1997  CD2 PHE   259      40.108  27.937  56.626  1.00 68.50           C  
ATOM   1998  C   PHE   259      39.431  27.722  51.843  1.00 69.83           C  
ATOM   1999  O   PHE   259      38.728  26.731  51.923  1.00 70.64           O  
ATOM   2000  N   ASN   260      39.270  28.544  50.819  1.00 69.64           N  
ATOM   2001  CA  ASN   260      38.406  28.121  49.712  1.00 69.07           C  
ATOM   2002  CB  ASN   260      38.901  28.778  48.472  1.00 68.78           C  
ATOM   2003  CG  ASN   260      40.366  28.580  48.296  1.00 68.77           C  
ATOM   2004  OD1 ASN   260      40.820  27.539  47.844  1.00 69.84           O  
ATOM   2005  ND2 ASN   260      41.129  29.576  48.676  1.00 67.16           N  
ATOM   2006  C   ASN   260      38.730  26.673  49.505  1.00 68.60           C  
ATOM   2007  O   ASN   260      39.896  26.351  49.580  1.00 69.70           O  
ATOM   2008  N   ASP   261      37.787  25.763  49.265  1.00 20.00           N  
ATOM   2009  CA  ASP   261      36.432  25.993  48.862  1.00 20.00           C  
ATOM   2010  C   ASP   261      35.494  26.017  50.021  1.00 20.00           C  
ATOM   2011  CB  ASP   261      35.994  24.860  47.930  1.00 20.00           C  
ATOM   2012  CG  ASP   261      35.219  25.367  46.686  1.00 20.00           C  
ATOM   2013  OD1 ASP   261      33.980  25.508  46.770  1.00 20.00           O  
ATOM   2014  OD2 ASP   261      35.844  25.616  45.626  1.00 20.00           O  
ATOM   2015  O   ASP   261      35.187  27.065  50.529  1.00 20.00           O  
ATOM   2016  N   ASP   262      35.026  24.846  50.424  1.00 64.93           N  
ATOM   2017  CA  ASP   262      33.905  24.709  51.355  1.00 64.67           C  
ATOM   2018  CB  ASP   262      33.327  23.319  51.213  1.00 65.08           C  
ATOM   2019  CG  ASP   262      31.987  23.204  51.831  1.00 67.04           C  
ATOM   2020  OD1 ASP   262      31.422  24.248  52.171  1.00 68.85           O  
ATOM   2021  OD2 ASP   262      31.497  22.078  51.987  1.00 69.65           O  
ATOM   2022  C   ASP   262      34.200  24.962  52.830  1.00 64.13           C  
ATOM   2023  O   ASP   262      35.268  24.639  53.292  1.00 64.65           O  
ATOM   2024  N   THR   263      33.242  25.512  53.575  1.00 62.93           N  
ATOM   2025  CA  THR   263      33.502  25.877  54.943  1.00 61.69           C  
ATOM   2026  CB  THR   263      34.331  27.099  54.983  1.00 61.53           C  
ATOM   2027  OG1 THR   263      33.462  28.225  54.936  1.00 61.15           O  
ATOM   2028  CG2 THR   263      35.207  27.120  53.801  1.00 61.02           C  
ATOM   2029  C   THR   263      32.278  26.211  55.749  1.00 60.92           C  
ATOM   2030  O   THR   263      31.459  27.009  55.357  1.00 59.95           O  
ATOM   2031  N   VAL   264      32.211  25.600  56.916  1.00 60.39           N  
ATOM   2032  CA  VAL   264      31.149  25.784  57.911  1.00 59.43           C  
ATOM   2033  CB  VAL   264      30.644  24.420  58.399  1.00 58.90           C  
ATOM   2034  CG1 VAL   264      29.514  24.541  59.441  1.00 58.61           C  
ATOM   2035  CG2 VAL   264      30.189  23.636  57.242  1.00 57.44           C  
ATOM   2036  C   VAL   264      31.821  26.563  59.042  1.00 59.13           C  
ATOM   2037  O   VAL   264      32.979  26.284  59.347  1.00 59.17           O  
ATOM   2038  N   THR   265      31.154  27.571  59.614  1.00 58.67           N  
ATOM   2039  CA  THR   265      31.700  28.259  60.780  1.00 58.60           C  
ATOM   2040  CB  THR   265      31.787  29.778  60.663  1.00 57.71           C  
ATOM   2041  OG1 THR   265      30.473  30.247  60.584  1.00 56.69           O  
ATOM   2042  CG2 THR   265      32.579  30.257  59.458  1.00 57.28           C  
ATOM   2043  C   THR   265      30.764  27.969  61.932  1.00 59.00           C  
ATOM   2044  O   THR   265      29.634  27.555  61.684  1.00 58.78           O  
ATOM   2045  N   TYR   266      31.248  28.201  63.170  1.00 59.51           N  
ATOM   2046  CA  TYR   266      30.533  27.848  64.409  1.00 59.57           C  
ATOM   2047  CB  TYR   266      31.182  26.605  64.997  1.00 58.79           C  
ATOM   2048  CG  TYR   266      31.015  25.384  64.165  1.00 57.04           C  
ATOM   2049  CD1 TYR   266      30.015  24.488  64.446  1.00 55.62           C  
ATOM   2050  CE1 TYR   266      29.841  23.355  63.692  1.00 56.67           C  
ATOM   2051  CZ  TYR   266      30.673  23.108  62.641  1.00 57.43           C  
ATOM   2052  OH  TYR   266      30.462  21.968  61.908  1.00 58.62           O  
ATOM   2053  CE2 TYR   266      31.692  23.987  62.338  1.00 57.29           C  
ATOM   2054  CD2 TYR   266      31.863  25.119  63.110  1.00 56.27           C  
ATOM   2055  C   TYR   266      30.527  28.955  65.492  1.00 60.29           C  
ATOM   2056  O   TYR   266      31.313  29.917  65.409  1.00 60.46           O  
ATOM   2057  N   ASP   267      29.669  28.783  66.510  1.00 60.67           N  
ATOM   2058  CA  ASP   267      29.561  29.716  67.646  1.00 61.45           C  
ATOM   2059  CB  ASP   267      28.484  29.244  68.607  1.00 62.20           C  
ATOM   2060  CG  ASP   267      27.113  29.811  68.290  1.00 67.02           C  
ATOM   2061  OD1 ASP   267      26.922  30.488  67.228  1.00 71.32           O  
ATOM   2062  OD2 ASP   267      26.206  29.569  69.136  1.00 72.49           O  
ATOM   2063  C   ASP   267      30.818  29.884  68.492  1.00 61.90           C  
ATOM   2064  O   ASP   267      30.989  30.920  69.159  1.00 62.49           O  
ATOM   2065  N   SER   268      31.660  28.848  68.499  1.00 61.55           N  
ATOM   2066  CA  SER   268      32.785  28.751  69.398  1.00 60.75           C  
ATOM   2067  CB  SER   268      32.300  28.268  70.761  1.00 60.98           C  
ATOM   2068  OG  SER   268      31.995  26.868  70.763  1.00 60.36           O  
ATOM   2069  C   SER   268      33.799  27.735  68.884  1.00 60.46           C  
ATOM   2070  O   SER   268      33.516  26.858  68.029  1.00 59.60           O  
ATOM   2071  N   LEU   269      34.987  27.819  69.458  1.00 59.89           N  
ATOM   2072  CA  LEU   269      36.013  26.868  69.123  1.00 59.31           C  
ATOM   2073  CB  LEU   269      37.349  27.331  69.689  1.00 59.43           C  
ATOM   2074  CG  LEU   269      38.142  28.449  68.989  1.00 58.84           C  
ATOM   2075  CD1 LEU   269      38.880  29.276  70.043  1.00 56.68           C  
ATOM   2076  CD2 LEU   269      37.284  29.319  68.138  1.00 56.26           C  
ATOM   2077  C   LEU   269      35.630  25.476  69.655  1.00 59.20           C  
ATOM   2078  O   LEU   269      36.158  24.450  69.194  1.00 59.44           O  
ATOM   2079  N   ASN   270      34.711  25.430  70.613  1.00 58.48           N  
ATOM   2080  CA  ASN   270      34.468  24.196  71.311  1.00 58.22           C  
ATOM   2081  CB  ASN   270      33.903  24.493  72.667  1.00 57.82           C  
ATOM   2082  CG  ASN   270      34.924  25.148  73.559  1.00 58.43           C  
ATOM   2083  OD1 ASN   270      36.091  24.792  73.549  1.00 60.92           O  
ATOM   2084  ND2 ASN   270      34.503  26.121  74.316  1.00 59.72           N  
ATOM   2085  C   ASN   270      33.553  23.405  70.461  1.00 58.21           C  
ATOM   2086  O   ASN   270      33.760  22.224  70.232  1.00 59.01           O  
ATOM   2087  N   ASP   271      32.547  24.085  69.943  1.00 57.90           N  
ATOM   2088  CA  ASP   271      31.720  23.536  68.891  1.00 56.76           C  
ATOM   2089  CB  ASP   271      30.777  24.632  68.412  1.00 57.53           C  
ATOM   2090  CG  ASP   271      29.667  24.921  69.382  1.00 59.49           C  
ATOM   2091  OD1 ASP   271      29.498  24.136  70.305  1.00 64.52           O  
ATOM   2092  OD2 ASP   271      28.935  25.921  69.234  1.00 64.86           O  
ATOM   2093  C   ASP   271      32.576  23.059  67.706  1.00 56.10           C  
ATOM   2094  O   ASP   271      32.422  21.928  67.226  1.00 55.45           O  
ATOM   2095  N   LEU   272      33.462  23.937  67.222  1.00 55.06           N  
ATOM   2096  CA  LEU   272      34.274  23.623  66.054  1.00 54.61           C  
ATOM   2097  CB  LEU   272      35.281  24.747  65.804  1.00 54.69           C  
ATOM   2098  CG  LEU   272      36.399  24.538  64.769  1.00 54.29           C  
ATOM   2099  CD1 LEU   272      35.733  24.269  63.429  1.00 53.12           C  
ATOM   2100  CD2 LEU   272      37.393  25.732  64.722  1.00 52.33           C  
ATOM   2101  C   LEU   272      34.970  22.291  66.283  1.00 54.28           C  
ATOM   2102  O   LEU   272      34.852  21.378  65.496  1.00 52.39           O  
ATOM   2103  N   LEU   273      35.661  22.179  67.411  1.00 55.02           N  
ATOM   2104  CA  LEU   273      36.346  20.938  67.767  1.00 55.73           C  
ATOM   2105  CB  LEU   273      37.228  21.163  69.000  1.00 55.87           C  
ATOM   2106  CG  LEU   273      38.662  21.718  68.890  1.00 56.75           C  
ATOM   2107  CD1 LEU   273      38.880  22.843  69.933  1.00 55.95           C  
ATOM   2108  CD2 LEU   273      39.002  22.213  67.507  1.00 58.78           C  
ATOM   2109  C   LEU   273      35.375  19.749  67.972  1.00 55.55           C  
ATOM   2110  O   LEU   273      35.617  18.657  67.459  1.00 54.28           O  
ATOM   2111  N   ASP   274      34.287  19.951  68.708  1.00 56.51           N  
ATOM   2112  CA  ASP   274      33.324  18.865  68.930  1.00 58.38           C  
ATOM   2113  CB  ASP   274      31.990  19.395  69.530  1.00 59.03           C  
ATOM   2114  CG  ASP   274      31.881  19.227  71.078  1.00 61.08           C  
ATOM   2115  OD1 ASP   274      32.742  18.544  71.677  1.00 64.56           O  
ATOM   2116  OD2 ASP   274      30.905  19.753  71.697  1.00 60.37           O  
ATOM   2117  C   ASP   274      33.051  18.140  67.590  1.00 59.07           C  
ATOM   2118  O   ASP   274      33.085  16.910  67.500  1.00 59.81           O  
ATOM   2119  N   ARG   275      32.807  18.921  66.546  1.00 59.66           N  
ATOM   2120  CA  ARG   275      32.506  18.378  65.244  1.00 59.52           C  
ATOM   2121  CB  ARG   275      32.022  19.508  64.328  1.00 60.24           C  
ATOM   2122  CG  ARG   275      31.590  19.067  62.950  1.00 61.21           C  
ATOM   2123  CD  ARG   275      32.727  19.218  61.965  1.00 67.01           C  
ATOM   2124  NE  ARG   275      32.213  19.478  60.618  1.00 71.17           N  
ATOM   2125  CZ  ARG   275      31.944  18.547  59.694  1.00 72.56           C  
ATOM   2126  NH1 ARG   275      32.153  17.242  59.932  1.00 75.00           N  
ATOM   2127  NH2 ARG   275      31.457  18.925  58.515  1.00 70.89           N  
ATOM   2128  C   ARG   275      33.722  17.708  64.657  1.00 59.14           C  
ATOM   2129  O   ARG   275      33.740  16.511  64.406  1.00 59.80           O  
ATOM   2130  N   PHE   276      34.759  18.484  64.467  1.00 58.47           N  
ATOM   2131  CA  PHE   276      35.925  17.991  63.796  1.00 58.58           C  
ATOM   2132  CB  PHE   276      37.005  19.028  63.885  1.00 58.63           C  
ATOM   2133  CG  PHE   276      38.173  18.731  63.029  1.00 59.60           C  
ATOM   2134  CD1 PHE   276      38.282  19.290  61.767  1.00 60.31           C  
ATOM   2135  CE1 PHE   276      39.390  19.027  60.976  1.00 61.02           C  
ATOM   2136  CZ  PHE   276      40.385  18.190  61.445  1.00 59.55           C  
ATOM   2137  CE2 PHE   276      40.268  17.640  62.682  1.00 59.82           C  
ATOM   2138  CD2 PHE   276      39.177  17.906  63.471  1.00 59.93           C  
ATOM   2139  C   PHE   276      36.492  16.664  64.309  1.00 58.62           C  
ATOM   2140  O   PHE   276      37.138  15.959  63.559  1.00 58.14           O  
ATOM   2141  N   TYR   277      36.310  16.326  65.582  1.00 59.51           N  
ATOM   2142  CA  TYR   277      36.891  15.070  66.080  1.00 59.37           C  
ATOM   2143  CB  TYR   277      37.770  15.273  67.304  1.00 58.20           C  
ATOM   2144  CG  TYR   277      39.074  15.937  66.968  1.00 56.40           C  
ATOM   2145  CD1 TYR   277      40.121  15.229  66.373  1.00 54.78           C  
ATOM   2146  CE1 TYR   277      41.331  15.843  66.051  1.00 54.66           C  
ATOM   2147  CZ  TYR   277      41.492  17.189  66.334  1.00 56.64           C  
ATOM   2148  OH  TYR   277      42.636  17.887  66.033  1.00 56.35           O  
ATOM   2149  CE2 TYR   277      40.475  17.903  66.953  1.00 57.71           C  
ATOM   2150  CD2 TYR   277      39.268  17.270  67.257  1.00 56.92           C  
ATOM   2151  C   TYR   277      35.859  14.056  66.341  1.00 61.03           C  
ATOM   2152  O   TYR   277      36.050  13.190  67.133  1.00 60.14           O  
ATOM   2153  N   ASP   278      34.773  14.125  65.604  1.00 64.34           N  
ATOM   2154  CA  ASP   278      33.793  13.055  65.657  1.00 67.25           C  
ATOM   2155  CB  ASP   278      32.428  13.590  65.181  1.00 67.49           C  
ATOM   2156  CG  ASP   278      31.256  12.980  65.954  1.00 70.02           C  
ATOM   2157  OD1 ASP   278      31.431  12.654  67.171  1.00 68.92           O  
ATOM   2158  OD2 ASP   278      30.161  12.833  65.328  1.00 73.24           O  
ATOM   2159  C   ASP   278      34.232  11.755  64.872  1.00 68.21           C  
ATOM   2160  O   ASP   278      33.794  10.633  65.242  1.00 67.92           O  
ATOM   2161  N   ALA   279      35.105  11.901  63.835  1.00 69.48           N  
ATOM   2162  CA  ALA   279      35.341  10.812  62.775  1.00 69.71           C  
ATOM   2163  CB  ALA   279      35.793  11.443  61.349  1.00 69.27           C  
ATOM   2164  C   ALA   279      36.256   9.600  63.185  1.00 69.97           C  
ATOM   2165  O   ALA   279      37.255   9.750  63.917  1.00 69.96           O  
END
