
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  125 ( 1873),  selected  125 , name 1buq_A
# Molecule2: number of CA atoms  266 ( 2165),  selected  266 , name T0510.pdb
# PARAMETERS: 1buq_A.T0510.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      A       2           -
LGA    -       -      Y       3           -
LGA    -       -      D       4           -
LGA    M     1_A      G       5           #
LGA    N     2_A      L       6          2.207
LGA    T     3_A      F       7          4.900
LGA    -       -      T       8           -
LGA    P     4_A      K       9          1.778
LGA    E     5_A      K      10          2.922
LGA    H     6_A      M      11          1.507
LGA    M     7_A      V      12          4.747
LGA    T     8_A      E      13           #
LGA    -       -      S      14           -
LGA    A     9_A      L      15          4.349
LGA    V    10_A      Q      16           -
LGA    V    11_A      F      17           -
LGA    Q    12_A      L      18           #
LGA    R    13_A      T      19           -
LGA    Y    14_A      T      20           -
LGA    -       -      G      21           -
LGA    V    15_A      R      22           #
LGA    A    16_A      -       -           -
LGA    A    17_A      -       -           -
LGA    L    18_A      -       -           -
LGA    N    19_A      V      23          1.600
LGA    A    20_A      H      24          2.436
LGA    G    21_A      K      25          1.434
LGA    D    22_A      I      26          3.271
LGA    L    23_A      N      27          0.591
LGA    D    24_A      Q      28          4.228
LGA    -       -      P      29           -
LGA    -       -      D      30           -
LGA    -       -      N      31           -
LGA    -       -      D      32           -
LGA    -       -      T      33           -
LGA    -       -      I      34           -
LGA    G    25_A      L      35          1.946
LGA    I    26_A      M      36          4.113
LGA    V    27_A      V      37           -
LGA    -       -      V      38           -
LGA    -       -      R      39           -
LGA    -       -      Q      40           -
LGA    -       -      N      41           -
LGA    -       -      R      42           -
LGA    -       -      Q      43           -
LGA    -       -      N      44           -
LGA    -       -      H      45           -
LGA    -       -      Q      46           -
LGA    A    28_A      L      47           #
LGA    L    29_A      L      48          2.221
LGA    F    30_A      L      49          3.737
LGA    A    31_A      S      50          3.048
LGA    D    32_A      -       -           -
LGA    D    33_A      -       -           -
LGA    A    34_A      I      51          2.729
LGA    T    35_A      -       -           -
LGA    V    36_A      -       -           -
LGA    E    37_A      -       -           -
LGA    D    38_A      -       -           -
LGA    P    39_A      -       -           -
LGA    V    40_A      -       -           -
LGA    G    41_A      -       -           -
LGA    S    42_A      -       -           -
LGA    E    43_A      -       -           -
LGA    P    44_A      -       -           -
LGA    R    45_A      -       -           -
LGA    S    46_A      -       -           -
LGA    G    47_A      H      52           #
LGA    T    48_A      P      53           -
LGA    A    49_A      N      54           -
LGA    A    50_A      F      55           -
LGA    I    51_A      S      56           -
LGA    -       -      R      57           -
LGA    -       -      L      58           -
LGA    -       -      Q      59           -
LGA    -       -      L      60           -
LGA    -       -      T      61           -
LGA    -       -      T      62           -
LGA    -       -      K      63           -
LGA    R    52_A      P      71           #
LGA    E    53_A      P      72          2.284
LGA    F    54_A      M      73          3.234
LGA    F    55_A      F      74          3.140
LGA    A    56_A      A      75          1.893
LGA    N    57_A      R      76          1.583
LGA    S    58_A      V      77          1.663
LGA    -       -      F      78           -
LGA    L    59_A      R      79          1.652
LGA    K    60_A      K      80          4.752
LGA    L    61_A      H      81           #
LGA    P    62_A      L      82           #
LGA    L    63_A      E      83          4.486
LGA    A    64_A      G      84          1.646
LGA    V    65_A      G      85          1.642
LGA    E    66_A      I      86          1.176
LGA    L    67_A      I      87          1.305
LGA    T    68_A      E      88          1.707
LGA    Q    69_A      S      89          3.660
LGA    E    70_A      I      90          4.770
LGA    V    71_A      K      91          2.523
LGA    R    72_A      Q      92          2.947
LGA    A    73_A      I      93          4.386
LGA    V    74_A      G      94          4.317
LGA    -       -      N      95           -
LGA    A    75_A      D      96          2.029
LGA    N    76_A      R      97          1.722
LGA    E    77_A      R      98          1.923
LGA    A    78_A      I      99          2.257
LGA    A    79_A      E     100          2.306
LGA    F    80_A      I     101          2.972
LGA    A    81_A      D     102          1.764
LGA    F    82_A      I     103          1.950
LGA    T    83_A      K     104          0.681
LGA    V    84_A      S     105          1.114
LGA    S    85_A      K     106          2.254
LGA    F    86_A      D     107          3.996
LGA    E    87_A      E     108          4.115
LGA    F    88_A      I     109          1.449
LGA    Q    89_A      -       -           -
LGA    G    90_A      -       -           -
LGA    R    91_A      -       -           -
LGA    K    92_A      G     110          1.856
LGA    T    93_A      D     111          1.193
LGA    V    94_A      T     112          1.375
LGA    V    95_A      I     113          0.346
LGA    A    96_A      Y     114          0.823
LGA    P    97_A      R     115          2.409
LGA    I    98_A      T     116          2.206
LGA    D    99_A      V     117          2.597
LGA    H   100_A      I     118          1.542
LGA    F   101_A      L     119          1.455
LGA    R   102_A      E     120          0.801
LGA    F   103_A      I     121          1.620
LGA    -       -      M     122           -
LGA    N   104_A      G     123          4.436
LGA    G   105_A      K     124           -
LGA    A   106_A      H     125           -
LGA    G   107_A      -       -           -
LGA    K   108_A      -       -           -
LGA    V   109_A      -       -           -
LGA    V   110_A      S     126          3.735
LGA    S   111_A      N     127          1.571
LGA    M   112_A      L     128          1.984
LGA    R   113_A      I     129          2.515
LGA    A   114_A      L     130          2.801
LGA    L   115_A      V     131          2.356
LGA    F   116_A      D     132          1.801
LGA    G   117_A      -       -           -
LGA    E   118_A      -       -           -
LGA    K   119_A      -       -           -
LGA    N   120_A      -       -           -
LGA    I   121_A      E     133           #
LGA    H   122_A      N     134           -
LGA    A   123_A      R     135           -
LGA    G   124_A      K     136           -
LGA    A   125_A      I     137           -
LGA    -       -      I     138           -
LGA    -       -      E     139           -
LGA    -       -      G     140           -
LGA    -       -      F     141           -
LGA    -       -      K     142           -
LGA    -       -      H     143           -
LGA    -       -      L     144           -
LGA    -       -      T     145           -
LGA    -       -      P     146           -
LGA    -       -      R     152           -
LGA    -       -      T     153           -
LGA    -       -      V     154           -
LGA    -       -      M     155           -
LGA    -       -      P     156           -
LGA    -       -      G     157           -
LGA    -       -      F     158           -
LGA    -       -      N     159           -
LGA    -       -      Y     160           -
LGA    -       -      E     161           -
LGA    -       -      A     162           -
LGA    -       -      P     163           -
LGA    -       -      P     164           -
LGA    -       -      T     165           -
LGA    -       -      Q     166           -
LGA    -       -      H     167           -
LGA    -       -      K     168           -
LGA    -       -      I     169           -
LGA    -       -      N     170           -
LGA    -       -      P     171           -
LGA    -       -      Y     172           -
LGA    -       -      D     173           -
LGA    -       -      I     174           -
LGA    -       -      T     175           -
LGA    -       -      G     176           -
LGA    -       -      A     177           -
LGA    -       -      E     178           -
LGA    -       -      V     179           -
LGA    -       -      L     180           -
LGA    -       -      K     181           -
LGA    -       -      Y     182           -
LGA    -       -      I     183           -
LGA    -       -      D     184           -
LGA    -       -      F     185           -
LGA    -       -      N     186           -
LGA    -       -      A     187           -
LGA    -       -      G     188           -
LGA    -       -      N     189           -
LGA    -       -      I     190           -
LGA    -       -      A     191           -
LGA    -       -      K     192           -
LGA    -       -      Q     193           -
LGA    -       -      L     194           -
LGA    -       -      L     195           -
LGA    -       -      N     196           -
LGA    -       -      Q     197           -
LGA    -       -      F     198           -
LGA    -       -      E     199           -
LGA    -       -      G     200           -
LGA    -       -      F     201           -
LGA    -       -      S     202           -
LGA    -       -      P     203           -
LGA    -       -      L     204           -
LGA    -       -      I     205           -
LGA    -       -      T     206           -
LGA    -       -      N     207           -
LGA    -       -      E     208           -
LGA    -       -      I     209           -
LGA    -       -      V     210           -
LGA    -       -      S     211           -
LGA    -       -      R     212           -
LGA    -       -      R     213           -
LGA    -       -      Q     214           -
LGA    -       -      F     215           -
LGA    -       -      M     216           -
LGA    -       -      T     217           -
LGA    -       -      S     218           -
LGA    -       -      S     219           -
LGA    -       -      T     220           -
LGA    -       -      L     221           -
LGA    -       -      P     222           -
LGA    -       -      E     223           -
LGA    -       -      A     224           -
LGA    -       -      F     225           -
LGA    -       -      D     226           -
LGA    -       -      E     227           -
LGA    -       -      V     228           -
LGA    -       -      M     229           -
LGA    -       -      A     230           -
LGA    -       -      E     231           -
LGA    -       -      T     232           -
LGA    -       -      K     233           -
LGA    -       -      L     234           -
LGA    -       -      P     235           -
LGA    -       -      P     236           -
LGA    -       -      T     237           -
LGA    -       -      P     238           -
LGA    -       -      I     239           -
LGA    -       -      F     240           -
LGA    -       -      H     241           -
LGA    -       -      N     243           -
LGA    -       -      H     244           -
LGA    -       -      E     245           -
LGA    -       -      T     246           -
LGA    -       -      G     247           -
LGA    -       -      K     248           -
LGA    -       -      E     249           -
LGA    -       -      D     250           -
LGA    -       -      F     251           -
LGA    -       -      Y     252           -
LGA    -       -      F     253           -
LGA    -       -      I     254           -
LGA    -       -      K     255           -
LGA    -       -      L     256           -
LGA    -       -      N     257           -
LGA    -       -      Q     258           -
LGA    -       -      F     259           -
LGA    -       -      N     260           -
LGA    -       -      D     261           -
LGA    -       -      D     262           -
LGA    -       -      T     263           -
LGA    -       -      V     264           -
LGA    -       -      T     265           -
LGA    -       -      Y     266           -
LGA    -       -      D     267           -
LGA    -       -      S     268           -
LGA    -       -      L     269           -
LGA    -       -      N     270           -
LGA    -       -      D     271           -
LGA    -       -      L     272           -
LGA    -       -      L     273           -
LGA    -       -      D     274           -
LGA    -       -      R     275           -
LGA    -       -      F     276           -
LGA    -       -      Y     277           -
LGA    -       -      D     278           -
LGA    -       -      A     279           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  125  266    5.0     73    2.71     6.85     17.172     2.601

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.790362 * X  +  -0.444816 * Y  +   0.421269 * Z  +  55.525806
  Y_new =  -0.600173 * X  +   0.424157 * Y  +  -0.678147 * Z  +  25.844753
  Z_new =   0.122966 * X  +  -0.788815 * Y  +  -0.602204 * Z  +  85.175591 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.222836    0.918756  [ DEG:  -127.3591     52.6409 ]
  Theta =  -0.123278   -3.018314  [ DEG:    -7.0633   -172.9367 ]
  Phi   =  -2.492125    0.649468  [ DEG:  -142.7882     37.2118 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1buq_A                                        
REMARK     2: T0510.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1buq_A.T0510.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  125  266   5.0   73   2.71    6.85  17.172
REMARK  ---------------------------------------------------------- 
MOLECULE 1buq_A
HEADER    ISOMERASE                               04-SEP-98   1BUQ              
TITLE     SOLUTION STRUCTURE OF DELTA-5-3-KETOSTEROID ISOMERASE                 
TITLE    2 COMPLEXED WITH THE STEROID 19-NORTESTOSTERONE-HEMISUCCINATE          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN (3-KETOSTEROID ISOMERASE-19-                       
COMPND   3 NORTESTOSTERONE-HEMISUCCINATE);                                      
COMPND   4 CHAIN: A, B;                                                         
COMPND   5 SYNONYM: KSI;                                                        
COMPND   6 EC: 5.3.3.1;                                                         
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MUTATION: YES;                                                       
COMPND   9 OTHER_DETAILS: KSI COMPLEXED WITH 19-NORTESTOSTERONE-                
COMPND  10 HEMISUCCINATE, A SUBSTRATE ANALOG.                                   
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: COMAMONAS TESTOSTERONI;                         
SOURCE   3 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   4 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   5 EXPRESSION_SYSTEM_CELL_LINE: BL21/DE3;                               
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: BACTERIAL;                            
SOURCE   7 EXPRESSION_SYSTEM_VECTOR: E.COLI;                                    
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET-25B;                                  
SOURCE   9 OTHER_DETAILS: PET-25B+GENE                                          
KEYWDS    KETOSTEROID ISOMERASE-19NTHS, ENZYME-SUBSTRATE COMPLEX,               
KEYWDS   2 ENZYMES                                                              
EXPDTA    NMR, 15 STRUCTURES                                                    
AUTHOR    M.A.MASSIAH,C.ABEYGUNAWARDANA,A.G.GITTIS,A.S.MILDVAN                  
REVDAT   3   22-MAY-02 1BUQ    1       SOURCE REMARK SHEET                      
REVDAT   2   29-DEC-99 1BUQ    4       HEADER COMPND REMARK JRNL                
REVDAT   2 2                   4       ATOM   SOURCE SEQRES                     
REVDAT   1   20-JAN-99 1BUQ    0                                                
JRNL        AUTH   M.A.MASSIAH,C.ABEYGUNAWARDANA,A.G.GITTIS,                    
JRNL        AUTH 2 A.S.MILDVAN                                                  
JRNL        TITL   SOLUTION STRUCTURE OF DELTA 5-3-KETOSTEROID                  
JRNL        TITL 2 ISOMERASE COMPLEXED WITH THE STEROID                         
JRNL        TITL 3 19-NORTESTOSTERONE HEMISUCCINATE.                            
JRNL        REF    BIOCHEMISTRY                  V.  37 14701 1998              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1BUQ A    1   125  UNP    P00947   SDIS_COMTE       1    125             
DBREF  1BUQ B  201   325  UNP    P00947   SDIS_COMTE       1    125             
SEQRES   1 A  125  MET ASN THR PRO GLU HIS MET THR ALA VAL VAL GLN ARG          
SEQRES   2 A  125  TYR VAL ALA ALA LEU ASN ALA GLY ASP LEU ASP GLY ILE          
SEQRES   3 A  125  VAL ALA LEU PHE ALA ASP ASP ALA THR VAL GLU ASP PRO          
SEQRES   4 A  125  VAL GLY SER GLU PRO ARG SER GLY THR ALA ALA ILE ARG          
SEQRES   5 A  125  GLU PHE PHE ALA ASN SER LEU LYS LEU PRO LEU ALA VAL          
SEQRES   6 A  125  GLU LEU THR GLN GLU VAL ARG ALA VAL ALA ASN GLU ALA          
SEQRES   7 A  125  ALA PHE ALA PHE THR VAL SER PHE GLU PHE GLN GLY ARG          
SEQRES   8 A  125  LYS THR VAL VAL ALA PRO ILE ASP HIS PHE ARG PHE ASN          
SEQRES   9 A  125  GLY ALA GLY LYS VAL VAL SER MET ARG ALA LEU PHE GLY          
SEQRES  10 A  125  GLU LYS ASN ILE HIS ALA GLY ALA                              
SEQRES   1 B  125  MET ASN THR PRO GLU HIS MET THR ALA VAL VAL GLN ARG          
SEQRES   2 B  125  TYR VAL ALA ALA LEU ASN ALA GLY ASP LEU ASP GLY ILE          
SEQRES   3 B  125  VAL ALA LEU PHE ALA ASP ASP ALA THR VAL GLU ASP PRO          
SEQRES   4 B  125  VAL GLY SER GLU PRO ARG SER GLY THR ALA ALA ILE ARG          
SEQRES   5 B  125  GLU PHE PHE ALA ASN SER LEU LYS LEU PRO LEU ALA VAL          
SEQRES   6 B  125  GLU LEU THR GLN GLU VAL ARG ALA VAL ALA ASN GLU ALA          
SEQRES   7 B  125  ALA PHE ALA PHE THR VAL SER PHE GLU PHE GLN GLY ARG          
SEQRES   8 B  125  LYS THR VAL VAL ALA PRO ILE ASP HIS PHE ARG PHE ASN          
SEQRES   9 B  125  GLY ALA GLY LYS VAL VAL SER MET ARG ALA LEU PHE GLY          
SEQRES  10 B  125  GLU LYS ASN ILE HIS ALA GLY ALA                              
HET    NTH    126      56                                                       
HET    NTH    326      56                                                       
HETNAM     NTH SUCCINIC ACID MONO-(13-METHYL-3-OXO-2,3,6,7,8,9,10,11,           
HETNAM   2 NTH  12,13,14,15,16,17-TETRADECAHYDRO-1H-                            
HETNAM   3 NTH  CYCLOPENTA[A]PHENANTHREN-17-YL) ESTER                           
FORMUL   3  NTH    2(C22 H30 O5)                                                
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      52.457  34.999  69.213  1.00  0.00           N  
ATOM      2  CA  MET A   1      51.152  35.659  68.921  1.00  0.00           C  
ATOM      3  C   MET A   1      50.085  34.607  68.606  1.00  0.00           C  
ATOM      4  O   MET A   1      49.945  34.169  67.481  1.00  0.00           O  
ATOM      5  CB  MET A   1      51.418  36.537  67.698  1.00  0.00           C  
ATOM      6  CG  MET A   1      50.190  37.401  67.411  1.00  0.00           C  
ATOM      7  SD  MET A   1      50.689  39.137  67.281  1.00  0.00           S  
ATOM      8  CE  MET A   1      49.057  39.863  67.570  1.00  0.00           C  
ATOM      9  HA  MET A   1      50.844  36.272  69.754  1.00  0.00           H  
ATOM     10  HB2 MET A   1      52.270  37.173  67.890  1.00  0.00           H  
ATOM     11  HB3 MET A   1      51.622  35.910  66.843  1.00  0.00           H  
ATOM     12  HG2 MET A   1      49.737  37.086  66.482  1.00  0.00           H  
ATOM     13  HG3 MET A   1      49.476  37.291  68.215  1.00  0.00           H  
ATOM     14  HE1 MET A   1      48.366  39.086  67.866  1.00  0.00           H  
ATOM     15  HE2 MET A   1      49.129  40.607  68.351  1.00  0.00           H  
ATOM     16  HE3 MET A   1      48.704  40.328  66.664  1.00  0.00           H  
ATOM     17  H1  MET A   1      52.702  34.355  68.435  1.00  0.00           H  
ATOM     18  H2  MET A   1      53.197  35.724  69.311  1.00  0.00           H  
ATOM     19  H3  MET A   1      52.381  34.457  70.097  1.00  0.00           H  
ATOM     20  N   ASN A   2      49.332  34.197  69.590  1.00  0.00           N  
ATOM     21  CA  ASN A   2      48.277  33.173  69.342  1.00  0.00           C  
ATOM     22  C   ASN A   2      47.142  33.348  70.354  1.00  0.00           C  
ATOM     23  O   ASN A   2      47.324  33.913  71.416  1.00  0.00           O  
ATOM     24  CB  ASN A   2      48.881  31.774  69.491  1.00  0.00           C  
ATOM     25  CG  ASN A   2      47.770  30.727  69.412  1.00  0.00           C  
ATOM     26  OD1 ASN A   2      47.639  30.038  68.420  1.00  0.00           O  
ATOM     27  ND2 ASN A   2      46.959  30.576  70.422  1.00  0.00           N  
ATOM     28  H   ASN A   2      49.460  34.561  70.491  1.00  0.00           H  
ATOM     29  HA  ASN A   2      47.889  33.292  68.342  1.00  0.00           H  
ATOM     30  HB2 ASN A   2      49.595  31.605  68.698  1.00  0.00           H  
ATOM     31  HB3 ASN A   2      49.380  31.697  70.446  1.00  0.00           H  
ATOM     32 HD21 ASN A   2      47.065  31.132  71.223  1.00  0.00           H  
ATOM     33 HD22 ASN A   2      46.244  29.906  70.381  1.00  0.00           H  
ATOM     34  N   THR A   3      45.971  32.870  70.032  1.00  0.00           N  
ATOM     35  CA  THR A   3      44.822  33.007  70.969  1.00  0.00           C  
ATOM     36  C   THR A   3      44.800  31.820  71.933  1.00  0.00           C  
ATOM     37  O   THR A   3      44.506  30.709  71.541  1.00  0.00           O  
ATOM     38  CB  THR A   3      43.525  33.032  70.169  1.00  0.00           C  
ATOM     39  OG1 THR A   3      43.765  33.615  68.896  1.00  0.00           O  
ATOM     40  CG2 THR A   3      42.472  33.849  70.919  1.00  0.00           C  
ATOM     41  H   THR A   3      45.846  32.419  69.171  1.00  0.00           H  
ATOM     42  HA  THR A   3      44.912  33.921  71.523  1.00  0.00           H  
ATOM     43  HB  THR A   3      43.173  32.028  70.044  1.00  0.00           H  
ATOM     44  HG1 THR A   3      43.531  34.545  68.946  1.00  0.00           H  
ATOM     45 HG21 THR A   3      42.880  34.186  71.860  1.00  0.00           H  
ATOM     46 HG22 THR A   3      42.188  34.704  70.324  1.00  0.00           H  
ATOM     47 HG23 THR A   3      41.603  33.234  71.103  1.00  0.00           H  
ATOM     48  N   PRO A   4      45.107  32.096  73.173  1.00  0.00           N  
ATOM     49  CA  PRO A   4      45.117  31.035  74.209  1.00  0.00           C  
ATOM     50  C   PRO A   4      43.684  30.616  74.551  1.00  0.00           C  
ATOM     51  O   PRO A   4      43.460  29.711  75.330  1.00  0.00           O  
ATOM     52  CB  PRO A   4      45.788  31.706  75.405  1.00  0.00           C  
ATOM     53  CG  PRO A   4      45.551  33.169  75.208  1.00  0.00           C  
ATOM     54  CD  PRO A   4      45.469  33.408  73.723  1.00  0.00           C  
ATOM     55  HA  PRO A   4      45.698  30.187  73.883  1.00  0.00           H  
ATOM     56  HB2 PRO A   4      45.334  31.368  76.327  1.00  0.00           H  
ATOM     57  HB3 PRO A   4      46.847  31.500  75.407  1.00  0.00           H  
ATOM     58  HG2 PRO A   4      44.623  33.459  75.683  1.00  0.00           H  
ATOM     59  HG3 PRO A   4      46.370  33.735  75.623  1.00  0.00           H  
ATOM     60  HD2 PRO A   4      44.706  34.141  73.500  1.00  0.00           H  
ATOM     61  HD3 PRO A   4      46.425  33.722  73.336  1.00  0.00           H  
ATOM     62  N   GLU A   5      42.713  31.268  73.972  1.00  0.00           N  
ATOM     63  CA  GLU A   5      41.296  30.909  74.263  1.00  0.00           C  
ATOM     64  C   GLU A   5      41.087  29.416  74.005  1.00  0.00           C  
ATOM     65  O   GLU A   5      40.479  28.718  74.793  1.00  0.00           O  
ATOM     66  CB  GLU A   5      40.368  31.719  73.355  1.00  0.00           C  
ATOM     67  CG  GLU A   5      38.925  31.579  73.844  1.00  0.00           C  
ATOM     68  CD  GLU A   5      37.992  31.406  72.643  1.00  0.00           C  
ATOM     69  OE1 GLU A   5      37.851  32.352  71.886  1.00  0.00           O  
ATOM     70  OE2 GLU A   5      37.435  30.330  72.501  1.00  0.00           O  
ATOM     71  H   GLU A   5      42.916  31.995  73.345  1.00  0.00           H  
ATOM     72  HA  GLU A   5      41.074  31.131  75.296  1.00  0.00           H  
ATOM     73  HB2 GLU A   5      40.658  32.760  73.381  1.00  0.00           H  
ATOM     74  HB3 GLU A   5      40.442  31.350  72.343  1.00  0.00           H  
ATOM     75  HG2 GLU A   5      38.847  30.716  74.489  1.00  0.00           H  
ATOM     76  HG3 GLU A   5      38.643  32.466  74.391  1.00  0.00           H  
ATOM     77  N   HIS A   6      41.583  28.918  72.905  1.00  0.00           N  
ATOM     78  CA  HIS A   6      41.412  27.470  72.597  1.00  0.00           C  
ATOM     79  C   HIS A   6      42.195  26.634  73.610  1.00  0.00           C  
ATOM     80  O   HIS A   6      41.651  25.769  74.268  1.00  0.00           O  
ATOM     81  CB  HIS A   6      41.934  27.182  71.188  1.00  0.00           C  
ATOM     82  CG  HIS A   6      40.962  26.289  70.466  1.00  0.00           C  
ATOM     83  ND1 HIS A   6      40.529  26.559  69.176  1.00  0.00           N  
ATOM     84  CD2 HIS A   6      40.331  25.129  70.839  1.00  0.00           C  
ATOM     85  CE1 HIS A   6      39.675  25.580  68.824  1.00  0.00           C  
ATOM     86  NE2 HIS A   6      39.519  24.682  69.801  1.00  0.00           N  
ATOM     87  H   HIS A   6      42.070  29.498  72.281  1.00  0.00           H  
ATOM     88  HA  HIS A   6      40.364  27.213  72.651  1.00  0.00           H  
ATOM     89  HB2 HIS A   6      42.041  28.111  70.647  1.00  0.00           H  
ATOM     90  HB3 HIS A   6      42.892  26.691  71.253  1.00  0.00           H  
ATOM     91  HD1 HIS A   6      40.796  27.322  68.623  1.00  0.00           H  
ATOM     92  HD2 HIS A   6      40.447  24.637  71.794  1.00  0.00           H  
ATOM     93  HE1 HIS A   6      39.176  25.528  67.867  1.00  0.00           H  
ATOM     94  N   MET A   7      43.470  26.884  73.741  1.00  0.00           N  
ATOM     95  CA  MET A   7      44.288  26.115  74.702  1.00  0.00           C  
ATOM     96  C   MET A   7      43.703  26.266  76.107  1.00  0.00           C  
ATOM     97  O   MET A   7      43.503  25.299  76.814  1.00  0.00           O  
ATOM     98  CB  MET A   7      45.707  26.668  74.667  1.00  0.00           C  
ATOM     99  CG  MET A   7      46.259  26.573  73.243  1.00  0.00           C  
ATOM    100  SD  MET A   7      47.774  27.555  73.115  1.00  0.00           S  
ATOM    101  CE  MET A   7      47.601  28.018  71.374  1.00  0.00           C  
ATOM    102  H   MET A   7      43.894  27.582  73.207  1.00  0.00           H  
ATOM    103  HA  MET A   7      44.298  25.072  74.422  1.00  0.00           H  
ATOM    104  HB2 MET A   7      45.699  27.701  74.984  1.00  0.00           H  
ATOM    105  HB3 MET A   7      46.324  26.097  75.324  1.00  0.00           H  
ATOM    106  HG2 MET A   7      46.478  25.542  73.010  1.00  0.00           H  
ATOM    107  HG3 MET A   7      45.525  26.951  72.546  1.00  0.00           H  
ATOM    108  HE1 MET A   7      46.565  28.223  71.156  1.00  0.00           H  
ATOM    109  HE2 MET A   7      48.190  28.903  71.177  1.00  0.00           H  
ATOM    110  HE3 MET A   7      47.944  27.204  70.750  1.00  0.00           H  
ATOM    111  N   THR A   8      43.423  27.473  76.515  1.00  0.00           N  
ATOM    112  CA  THR A   8      42.846  27.682  77.870  1.00  0.00           C  
ATOM    113  C   THR A   8      41.592  26.821  78.017  1.00  0.00           C  
ATOM    114  O   THR A   8      41.333  26.259  79.063  1.00  0.00           O  
ATOM    115  CB  THR A   8      42.477  29.157  78.050  1.00  0.00           C  
ATOM    116  OG1 THR A   8      43.662  29.922  78.213  1.00  0.00           O  
ATOM    117  CG2 THR A   8      41.589  29.317  79.287  1.00  0.00           C  
ATOM    118  H   THR A   8      43.588  28.238  75.928  1.00  0.00           H  
ATOM    119  HA  THR A   8      43.570  27.397  78.620  1.00  0.00           H  
ATOM    120  HB  THR A   8      41.940  29.503  77.180  1.00  0.00           H  
ATOM    121  HG1 THR A   8      43.674  30.600  77.532  1.00  0.00           H  
ATOM    122 HG21 THR A   8      41.513  28.367  79.799  1.00  0.00           H  
ATOM    123 HG22 THR A   8      42.024  30.049  79.950  1.00  0.00           H  
ATOM    124 HG23 THR A   8      40.606  29.642  78.984  1.00  0.00           H  
ATOM    125  N   ALA A   9      40.815  26.706  76.976  1.00  0.00           N  
ATOM    126  CA  ALA A   9      39.587  25.874  77.063  1.00  0.00           C  
ATOM    127  C   ALA A   9      39.961  24.522  77.661  1.00  0.00           C  
ATOM    128  O   ALA A   9      39.278  23.999  78.520  1.00  0.00           O  
ATOM    129  CB  ALA A   9      38.998  25.677  75.664  1.00  0.00           C  
ATOM    130  H   ALA A   9      41.044  27.159  76.138  1.00  0.00           H  
ATOM    131  HA  ALA A   9      38.863  26.365  77.699  1.00  0.00           H  
ATOM    132  HB1 ALA A   9      38.788  26.641  75.222  1.00  0.00           H  
ATOM    133  HB2 ALA A   9      39.706  25.145  75.047  1.00  0.00           H  
ATOM    134  HB3 ALA A   9      38.083  25.107  75.735  1.00  0.00           H  
ATOM    135  N   VAL A  10      41.055  23.960  77.227  1.00  0.00           N  
ATOM    136  CA  VAL A  10      41.486  22.651  77.788  1.00  0.00           C  
ATOM    137  C   VAL A  10      41.598  22.801  79.308  1.00  0.00           C  
ATOM    138  O   VAL A  10      41.070  22.010  80.060  1.00  0.00           O  
ATOM    139  CB  VAL A  10      42.850  22.253  77.190  1.00  0.00           C  
ATOM    140  CG1 VAL A  10      43.629  21.375  78.177  1.00  0.00           C  
ATOM    141  CG2 VAL A  10      42.636  21.465  75.895  1.00  0.00           C  
ATOM    142  H   VAL A  10      41.599  24.407  76.544  1.00  0.00           H  
ATOM    143  HA  VAL A  10      40.749  21.896  77.552  1.00  0.00           H  
ATOM    144  HB  VAL A  10      43.422  23.146  76.977  1.00  0.00           H  
ATOM    145 HG11 VAL A  10      42.934  20.819  78.790  1.00  0.00           H  
ATOM    146 HG12 VAL A  10      44.256  20.688  77.631  1.00  0.00           H  
ATOM    147 HG13 VAL A  10      44.243  21.999  78.807  1.00  0.00           H  
ATOM    148 HG21 VAL A  10      41.755  21.831  75.389  1.00  0.00           H  
ATOM    149 HG22 VAL A  10      43.497  21.586  75.253  1.00  0.00           H  
ATOM    150 HG23 VAL A  10      42.507  20.417  76.126  1.00  0.00           H  
ATOM    151  N   VAL A  11      42.283  23.819  79.755  1.00  0.00           N  
ATOM    152  CA  VAL A  11      42.439  24.037  81.223  1.00  0.00           C  
ATOM    153  C   VAL A  11      41.059  24.086  81.885  1.00  0.00           C  
ATOM    154  O   VAL A  11      40.850  23.536  82.948  1.00  0.00           O  
ATOM    155  CB  VAL A  11      43.180  25.362  81.455  1.00  0.00           C  
ATOM    156  CG1 VAL A  11      42.897  25.882  82.866  1.00  0.00           C  
ATOM    157  CG2 VAL A  11      44.686  25.137  81.291  1.00  0.00           C  
ATOM    158  H   VAL A  11      42.696  24.445  79.122  1.00  0.00           H  
ATOM    159  HA  VAL A  11      43.013  23.226  81.648  1.00  0.00           H  
ATOM    160  HB  VAL A  11      42.844  26.091  80.731  1.00  0.00           H  
ATOM    161 HG11 VAL A  11      42.534  25.071  83.481  1.00  0.00           H  
ATOM    162 HG12 VAL A  11      43.806  26.278  83.291  1.00  0.00           H  
ATOM    163 HG13 VAL A  11      42.150  26.659  82.818  1.00  0.00           H  
ATOM    164 HG21 VAL A  11      44.938  24.139  81.615  1.00  0.00           H  
ATOM    165 HG22 VAL A  11      44.957  25.258  80.253  1.00  0.00           H  
ATOM    166 HG23 VAL A  11      45.225  25.856  81.891  1.00  0.00           H  
ATOM    167  N   GLN A  12      40.115  24.731  81.260  1.00  0.00           N  
ATOM    168  CA  GLN A  12      38.752  24.808  81.842  1.00  0.00           C  
ATOM    169  C   GLN A  12      38.190  23.403  81.916  1.00  0.00           C  
ATOM    170  O   GLN A  12      38.127  22.782  82.958  1.00  0.00           O  
ATOM    171  CB  GLN A  12      37.868  25.647  80.918  1.00  0.00           C  
ATOM    172  CG  GLN A  12      36.416  25.561  81.381  1.00  0.00           C  
ATOM    173  CD  GLN A  12      35.483  25.870  80.208  1.00  0.00           C  
ATOM    174  OE1 GLN A  12      35.704  25.413  79.104  1.00  0.00           O  
ATOM    175  NE2 GLN A  12      34.441  26.632  80.401  1.00  0.00           N  
ATOM    176  H   GLN A  12      40.299  25.154  80.400  1.00  0.00           H  
ATOM    177  HA  GLN A  12      38.783  25.248  82.826  1.00  0.00           H  
ATOM    178  HB2 GLN A  12      38.196  26.672  80.941  1.00  0.00           H  
ATOM    179  HB3 GLN A  12      37.943  25.272  79.909  1.00  0.00           H  
ATOM    180  HG2 GLN A  12      36.214  24.570  81.753  1.00  0.00           H  
ATOM    181  HG3 GLN A  12      36.253  26.276  82.164  1.00  0.00           H  
ATOM    182 HE21 GLN A  12      34.262  27.002  81.291  1.00  0.00           H  
ATOM    183 HE22 GLN A  12      33.837  26.834  79.656  1.00  0.00           H  
ATOM    184  N   ARG A  13      37.804  22.903  80.791  1.00  0.00           N  
ATOM    185  CA  ARG A  13      37.258  21.533  80.716  1.00  0.00           C  
ATOM    186  C   ARG A  13      38.131  20.615  81.567  1.00  0.00           C  
ATOM    187  O   ARG A  13      37.653  19.814  82.345  1.00  0.00           O  
ATOM    188  CB  ARG A  13      37.321  21.094  79.260  1.00  0.00           C  
ATOM    189  CG  ARG A  13      35.932  21.198  78.635  1.00  0.00           C  
ATOM    190  CD  ARG A  13      35.943  20.560  77.245  1.00  0.00           C  
ATOM    191  NE  ARG A  13      35.689  19.098  77.365  1.00  0.00           N  
ATOM    192  CZ  ARG A  13      34.465  18.652  77.428  1.00  0.00           C  
ATOM    193  NH1 ARG A  13      33.619  18.927  76.473  1.00  0.00           N  
ATOM    194  NH2 ARG A  13      34.085  17.932  78.447  1.00  0.00           N  
ATOM    195  H   ARG A  13      37.893  23.434  79.977  1.00  0.00           H  
ATOM    196  HA  ARG A  13      36.239  21.516  81.067  1.00  0.00           H  
ATOM    197  HB2 ARG A  13      38.005  21.736  78.724  1.00  0.00           H  
ATOM    198  HB3 ARG A  13      37.670  20.083  79.212  1.00  0.00           H  
ATOM    199  HG2 ARG A  13      35.219  20.691  79.265  1.00  0.00           H  
ATOM    200  HG3 ARG A  13      35.656  22.239  78.548  1.00  0.00           H  
ATOM    201  HD2 ARG A  13      35.172  21.010  76.637  1.00  0.00           H  
ATOM    202  HD3 ARG A  13      36.906  20.721  76.782  1.00  0.00           H  
ATOM    203  HE  ARG A  13      36.441  18.470  77.396  1.00  0.00           H  
ATOM    204 HH11 ARG A  13      33.909  19.480  75.692  1.00  0.00           H  
ATOM    205 HH12 ARG A  13      32.681  18.584  76.522  1.00  0.00           H  
ATOM    206 HH21 ARG A  13      34.731  17.721  79.179  1.00  0.00           H  
ATOM    207 HH22 ARG A  13      33.146  17.590  78.494  1.00  0.00           H  
ATOM    208  N   TYR A  14      39.413  20.745  81.413  1.00  0.00           N  
ATOM    209  CA  TYR A  14      40.367  19.910  82.194  1.00  0.00           C  
ATOM    210  C   TYR A  14      39.974  19.956  83.669  1.00  0.00           C  
ATOM    211  O   TYR A  14      39.921  18.944  84.342  1.00  0.00           O  
ATOM    212  CB  TYR A  14      41.781  20.478  81.998  1.00  0.00           C  
ATOM    213  CG  TYR A  14      42.693  20.063  83.128  1.00  0.00           C  
ATOM    214  CD1 TYR A  14      42.593  20.693  84.373  1.00  0.00           C  
ATOM    215  CD2 TYR A  14      43.651  19.064  82.923  1.00  0.00           C  
ATOM    216  CE1 TYR A  14      43.450  20.323  85.416  1.00  0.00           C  
ATOM    217  CE2 TYR A  14      44.506  18.692  83.966  1.00  0.00           C  
ATOM    218  CZ  TYR A  14      44.408  19.322  85.216  1.00  0.00           C  
ATOM    219  OH  TYR A  14      45.260  18.962  86.250  1.00  0.00           O  
ATOM    220  H   TYR A  14      39.752  21.408  80.778  1.00  0.00           H  
ATOM    221  HA  TYR A  14      40.330  18.890  81.841  1.00  0.00           H  
ATOM    222  HB2 TYR A  14      42.184  20.115  81.065  1.00  0.00           H  
ATOM    223  HB3 TYR A  14      41.727  21.556  81.967  1.00  0.00           H  
ATOM    224  HD1 TYR A  14      41.853  21.463  84.530  1.00  0.00           H  
ATOM    225  HD2 TYR A  14      43.727  18.579  81.962  1.00  0.00           H  
ATOM    226  HE1 TYR A  14      43.369  20.812  86.373  1.00  0.00           H  
ATOM    227  HE2 TYR A  14      45.243  17.919  83.804  1.00  0.00           H  
ATOM    228  HH  TYR A  14      44.836  19.185  87.087  1.00  0.00           H  
ATOM    229  N   VAL A  15      39.690  21.122  84.175  1.00  0.00           N  
ATOM    230  CA  VAL A  15      39.294  21.234  85.604  1.00  0.00           C  
ATOM    231  C   VAL A  15      37.785  20.994  85.727  1.00  0.00           C  
ATOM    232  O   VAL A  15      37.327  20.365  86.660  1.00  0.00           O  
ATOM    233  CB  VAL A  15      39.700  22.618  86.130  1.00  0.00           C  
ATOM    234  CG1 VAL A  15      38.632  23.194  87.070  1.00  0.00           C  
ATOM    235  CG2 VAL A  15      41.020  22.495  86.890  1.00  0.00           C  
ATOM    236  H   VAL A  15      39.735  21.924  83.613  1.00  0.00           H  
ATOM    237  HA  VAL A  15      39.810  20.478  86.168  1.00  0.00           H  
ATOM    238  HB  VAL A  15      39.840  23.278  85.294  1.00  0.00           H  
ATOM    239 HG11 VAL A  15      37.677  23.204  86.566  1.00  0.00           H  
ATOM    240 HG12 VAL A  15      38.565  22.580  87.955  1.00  0.00           H  
ATOM    241 HG13 VAL A  15      38.903  24.200  87.350  1.00  0.00           H  
ATOM    242 HG21 VAL A  15      41.610  21.699  86.458  1.00  0.00           H  
ATOM    243 HG22 VAL A  15      41.565  23.424  86.818  1.00  0.00           H  
ATOM    244 HG23 VAL A  15      40.819  22.272  87.927  1.00  0.00           H  
ATOM    245  N   ALA A  16      37.007  21.460  84.787  1.00  0.00           N  
ATOM    246  CA  ALA A  16      35.542  21.211  84.872  1.00  0.00           C  
ATOM    247  C   ALA A  16      35.346  19.722  85.150  1.00  0.00           C  
ATOM    248  O   ALA A  16      34.492  19.327  85.918  1.00  0.00           O  
ATOM    249  CB  ALA A  16      34.875  21.585  83.547  1.00  0.00           C  
ATOM    250  H   ALA A  16      37.385  21.949  84.027  1.00  0.00           H  
ATOM    251  HA  ALA A  16      35.116  21.791  85.680  1.00  0.00           H  
ATOM    252  HB1 ALA A  16      35.303  22.503  83.176  1.00  0.00           H  
ATOM    253  HB2 ALA A  16      35.035  20.795  82.828  1.00  0.00           H  
ATOM    254  HB3 ALA A  16      33.814  21.719  83.705  1.00  0.00           H  
ATOM    255  N   ALA A  17      36.163  18.899  84.550  1.00  0.00           N  
ATOM    256  CA  ALA A  17      36.064  17.436  84.795  1.00  0.00           C  
ATOM    257  C   ALA A  17      36.581  17.167  86.208  1.00  0.00           C  
ATOM    258  O   ALA A  17      36.110  16.290  86.905  1.00  0.00           O  
ATOM    259  CB  ALA A  17      36.926  16.686  83.777  1.00  0.00           C  
ATOM    260  H   ALA A  17      36.858  19.248  83.954  1.00  0.00           H  
ATOM    261  HA  ALA A  17      35.035  17.118  84.715  1.00  0.00           H  
ATOM    262  HB1 ALA A  17      37.938  17.063  83.815  1.00  0.00           H  
ATOM    263  HB2 ALA A  17      36.926  15.632  84.010  1.00  0.00           H  
ATOM    264  HB3 ALA A  17      36.524  16.836  82.785  1.00  0.00           H  
ATOM    265  N   LEU A  18      37.539  17.945  86.638  1.00  0.00           N  
ATOM    266  CA  LEU A  18      38.092  17.789  88.001  1.00  0.00           C  
ATOM    267  C   LEU A  18      37.009  18.177  89.005  1.00  0.00           C  
ATOM    268  O   LEU A  18      36.590  17.393  89.833  1.00  0.00           O  
ATOM    269  CB  LEU A  18      39.270  18.747  88.146  1.00  0.00           C  
ATOM    270  CG  LEU A  18      40.555  18.092  87.637  1.00  0.00           C  
ATOM    271  CD1 LEU A  18      41.443  19.159  86.991  1.00  0.00           C  
ATOM    272  CD2 LEU A  18      41.300  17.453  88.811  1.00  0.00           C  
ATOM    273  H   LEU A  18      37.886  18.655  86.063  1.00  0.00           H  
ATOM    274  HA  LEU A  18      38.413  16.772  88.166  1.00  0.00           H  
ATOM    275  HB2 LEU A  18      39.070  19.638  87.574  1.00  0.00           H  
ATOM    276  HB3 LEU A  18      39.386  19.013  89.175  1.00  0.00           H  
ATOM    277  HG  LEU A  18      40.309  17.334  86.906  1.00  0.00           H  
ATOM    278 HD11 LEU A  18      41.187  20.131  87.390  1.00  0.00           H  
ATOM    279 HD12 LEU A  18      42.480  18.947  87.199  1.00  0.00           H  
ATOM    280 HD13 LEU A  18      41.285  19.162  85.921  1.00  0.00           H  
ATOM    281 HD21 LEU A  18      40.764  17.650  89.727  1.00  0.00           H  
ATOM    282 HD22 LEU A  18      41.368  16.386  88.656  1.00  0.00           H  
ATOM    283 HD23 LEU A  18      42.294  17.871  88.877  1.00  0.00           H  
ATOM    284  N   ASN A  19      36.548  19.394  88.915  1.00  0.00           N  
ATOM    285  CA  ASN A  19      35.481  19.875  89.832  1.00  0.00           C  
ATOM    286  C   ASN A  19      34.358  18.843  89.883  1.00  0.00           C  
ATOM    287  O   ASN A  19      33.788  18.573  90.921  1.00  0.00           O  
ATOM    288  CB  ASN A  19      34.930  21.195  89.293  1.00  0.00           C  
ATOM    289  CG  ASN A  19      34.676  22.159  90.453  1.00  0.00           C  
ATOM    290  OD1 ASN A  19      35.500  22.296  91.336  1.00  0.00           O  
ATOM    291  ND2 ASN A  19      33.562  22.836  90.491  1.00  0.00           N  
ATOM    292  H   ASN A  19      36.903  19.995  88.228  1.00  0.00           H  
ATOM    293  HA  ASN A  19      35.887  20.025  90.821  1.00  0.00           H  
ATOM    294  HB2 ASN A  19      35.649  21.626  88.614  1.00  0.00           H  
ATOM    295  HB3 ASN A  19      34.006  21.015  88.765  1.00  0.00           H  
ATOM    296 HD21 ASN A  19      32.897  22.724  89.779  1.00  0.00           H  
ATOM    297 HD22 ASN A  19      33.389  23.456  91.229  1.00  0.00           H  
ATOM    298  N   ALA A  20      34.036  18.269  88.760  1.00  0.00           N  
ATOM    299  CA  ALA A  20      32.946  17.254  88.727  1.00  0.00           C  
ATOM    300  C   ALA A  20      33.529  15.863  88.987  1.00  0.00           C  
ATOM    301  O   ALA A  20      32.841  14.865  88.902  1.00  0.00           O  
ATOM    302  CB  ALA A  20      32.274  17.274  87.352  1.00  0.00           C  
ATOM    303  H   ALA A  20      34.511  18.513  87.936  1.00  0.00           H  
ATOM    304  HA  ALA A  20      32.215  17.486  89.488  1.00  0.00           H  
ATOM    305  HB1 ALA A  20      32.551  18.178  86.828  1.00  0.00           H  
ATOM    306  HB2 ALA A  20      32.594  16.416  86.781  1.00  0.00           H  
ATOM    307  HB3 ALA A  20      31.201  17.244  87.475  1.00  0.00           H  
ATOM    308  N   GLY A  21      34.792  15.788  89.307  1.00  0.00           N  
ATOM    309  CA  GLY A  21      35.417  14.463  89.575  1.00  0.00           C  
ATOM    310  C   GLY A  21      35.039  13.487  88.460  1.00  0.00           C  
ATOM    311  O   GLY A  21      34.925  12.297  88.676  1.00  0.00           O  
ATOM    312  H   GLY A  21      35.329  16.603  89.372  1.00  0.00           H  
ATOM    313  HA2 GLY A  21      36.492  14.573  89.611  1.00  0.00           H  
ATOM    314  HA3 GLY A  21      35.062  14.080  90.520  1.00  0.00           H  
ATOM    315  N   ASP A  22      34.842  13.982  87.270  1.00  0.00           N  
ATOM    316  CA  ASP A  22      34.469  13.085  86.143  1.00  0.00           C  
ATOM    317  C   ASP A  22      35.718  12.721  85.337  1.00  0.00           C  
ATOM    318  O   ASP A  22      36.061  13.380  84.376  1.00  0.00           O  
ATOM    319  CB  ASP A  22      33.471  13.797  85.239  1.00  0.00           C  
ATOM    320  CG  ASP A  22      32.586  12.764  84.540  1.00  0.00           C  
ATOM    321  OD1 ASP A  22      32.617  11.615  84.947  1.00  0.00           O  
ATOM    322  OD2 ASP A  22      31.894  13.140  83.607  1.00  0.00           O  
ATOM    323  H   ASP A  22      34.937  14.946  87.118  1.00  0.00           H  
ATOM    324  HA  ASP A  22      34.019  12.189  86.528  1.00  0.00           H  
ATOM    325  HB2 ASP A  22      32.856  14.460  85.831  1.00  0.00           H  
ATOM    326  HB3 ASP A  22      34.008  14.363  84.505  1.00  0.00           H  
ATOM    327  N   LEU A  23      36.399  11.673  85.717  1.00  0.00           N  
ATOM    328  CA  LEU A  23      37.614  11.264  84.980  1.00  0.00           C  
ATOM    329  C   LEU A  23      37.301  11.148  83.486  1.00  0.00           C  
ATOM    330  O   LEU A  23      38.184  11.184  82.654  1.00  0.00           O  
ATOM    331  CB  LEU A  23      38.062   9.915  85.515  1.00  0.00           C  
ATOM    332  CG  LEU A  23      39.071  10.128  86.640  1.00  0.00           C  
ATOM    333  CD1 LEU A  23      40.219  11.014  86.154  1.00  0.00           C  
ATOM    334  CD2 LEU A  23      38.376  10.800  87.826  1.00  0.00           C  
ATOM    335  H   LEU A  23      36.113  11.150  86.488  1.00  0.00           H  
ATOM    336  HA  LEU A  23      38.395  11.985  85.139  1.00  0.00           H  
ATOM    337  HB2 LEU A  23      37.205   9.377  85.896  1.00  0.00           H  
ATOM    338  HB3 LEU A  23      38.516   9.351  84.726  1.00  0.00           H  
ATOM    339  HG  LEU A  23      39.464   9.180  86.943  1.00  0.00           H  
ATOM    340 HD11 LEU A  23      40.083  11.243  85.109  1.00  0.00           H  
ATOM    341 HD12 LEU A  23      40.233  11.931  86.726  1.00  0.00           H  
ATOM    342 HD13 LEU A  23      41.154  10.492  86.288  1.00  0.00           H  
ATOM    343 HD21 LEU A  23      37.792  11.637  87.475  1.00  0.00           H  
ATOM    344 HD22 LEU A  23      37.727  10.087  88.312  1.00  0.00           H  
ATOM    345 HD23 LEU A  23      39.119  11.147  88.529  1.00  0.00           H  
ATOM    346  N   ASP A  24      36.049  11.008  83.140  1.00  0.00           N  
ATOM    347  CA  ASP A  24      35.682  10.890  81.702  1.00  0.00           C  
ATOM    348  C   ASP A  24      36.041  12.188  80.981  1.00  0.00           C  
ATOM    349  O   ASP A  24      36.778  12.189  80.016  1.00  0.00           O  
ATOM    350  CB  ASP A  24      34.179  10.632  81.576  1.00  0.00           C  
ATOM    351  CG  ASP A  24      33.894   9.147  81.804  1.00  0.00           C  
ATOM    352  OD1 ASP A  24      34.266   8.646  82.853  1.00  0.00           O  
ATOM    353  OD2 ASP A  24      33.307   8.535  80.926  1.00  0.00           O  
ATOM    354  H   ASP A  24      35.350  10.981  83.826  1.00  0.00           H  
ATOM    355  HA  ASP A  24      36.227  10.069  81.259  1.00  0.00           H  
ATOM    356  HB2 ASP A  24      33.650  11.218  82.315  1.00  0.00           H  
ATOM    357  HB3 ASP A  24      33.848  10.913  80.588  1.00  0.00           H  
ATOM    358  N   GLY A  25      35.528  13.296  81.442  1.00  0.00           N  
ATOM    359  CA  GLY A  25      35.847  14.589  80.777  1.00  0.00           C  
ATOM    360  C   GLY A  25      37.356  14.803  80.791  1.00  0.00           C  
ATOM    361  O   GLY A  25      37.919  15.426  79.914  1.00  0.00           O  
ATOM    362  H   GLY A  25      34.937  13.276  82.222  1.00  0.00           H  
ATOM    363  HA2 GLY A  25      35.502  14.556  79.762  1.00  0.00           H  
ATOM    364  HA3 GLY A  25      35.365  15.398  81.299  1.00  0.00           H  
ATOM    365  N   ILE A  26      38.013  14.272  81.777  1.00  0.00           N  
ATOM    366  CA  ILE A  26      39.492  14.419  81.854  1.00  0.00           C  
ATOM    367  C   ILE A  26      40.114  13.601  80.727  1.00  0.00           C  
ATOM    368  O   ILE A  26      40.746  14.132  79.836  1.00  0.00           O  
ATOM    369  CB  ILE A  26      39.986  13.896  83.198  1.00  0.00           C  
ATOM    370  CG1 ILE A  26      39.204  14.585  84.317  1.00  0.00           C  
ATOM    371  CG2 ILE A  26      41.478  14.201  83.346  1.00  0.00           C  
ATOM    372  CD1 ILE A  26      39.857  14.271  85.658  1.00  0.00           C  
ATOM    373  H   ILE A  26      37.532  13.765  82.460  1.00  0.00           H  
ATOM    374  HA  ILE A  26      39.765  15.459  81.746  1.00  0.00           H  
ATOM    375  HB  ILE A  26      39.828  12.829  83.251  1.00  0.00           H  
ATOM    376 HG12 ILE A  26      39.208  15.654  84.154  1.00  0.00           H  
ATOM    377 HG13 ILE A  26      38.186  14.225  84.320  1.00  0.00           H  
ATOM    378 HG21 ILE A  26      41.811  14.782  82.498  1.00  0.00           H  
ATOM    379 HG22 ILE A  26      41.645  14.763  84.253  1.00  0.00           H  
ATOM    380 HG23 ILE A  26      42.032  13.275  83.388  1.00  0.00           H  
ATOM    381 HD11 ILE A  26      40.591  13.491  85.524  1.00  0.00           H  
ATOM    382 HD12 ILE A  26      40.338  15.160  86.039  1.00  0.00           H  
ATOM    383 HD13 ILE A  26      39.102  13.941  86.355  1.00  0.00           H  
ATOM    384  N   VAL A  27      39.914  12.312  80.746  1.00  0.00           N  
ATOM    385  CA  VAL A  27      40.466  11.467  79.663  1.00  0.00           C  
ATOM    386  C   VAL A  27      39.918  11.985  78.337  1.00  0.00           C  
ATOM    387  O   VAL A  27      40.612  12.039  77.340  1.00  0.00           O  
ATOM    388  CB  VAL A  27      40.021  10.023  79.881  1.00  0.00           C  
ATOM    389  CG1 VAL A  27      40.590   9.146  78.773  1.00  0.00           C  
ATOM    390  CG2 VAL A  27      40.537   9.536  81.238  1.00  0.00           C  
ATOM    391  H   VAL A  27      39.384  11.905  81.461  1.00  0.00           H  
ATOM    392  HA  VAL A  27      41.546  11.525  79.663  1.00  0.00           H  
ATOM    393  HB  VAL A  27      38.943   9.972  79.865  1.00  0.00           H  
ATOM    394 HG11 VAL A  27      41.648   9.336  78.672  1.00  0.00           H  
ATOM    395 HG12 VAL A  27      40.432   8.108  79.021  1.00  0.00           H  
ATOM    396 HG13 VAL A  27      40.091   9.375  77.844  1.00  0.00           H  
ATOM    397 HG21 VAL A  27      40.274  10.254  82.002  1.00  0.00           H  
ATOM    398 HG22 VAL A  27      40.090   8.582  81.471  1.00  0.00           H  
ATOM    399 HG23 VAL A  27      41.611   9.430  81.198  1.00  0.00           H  
ATOM    400  N   ALA A  28      38.678  12.397  78.331  1.00  0.00           N  
ATOM    401  CA  ALA A  28      38.082  12.948  77.088  1.00  0.00           C  
ATOM    402  C   ALA A  28      38.968  14.099  76.622  1.00  0.00           C  
ATOM    403  O   ALA A  28      39.474  14.108  75.518  1.00  0.00           O  
ATOM    404  CB  ALA A  28      36.674  13.469  77.387  1.00  0.00           C  
ATOM    405  H   ALA A  28      38.149  12.364  79.154  1.00  0.00           H  
ATOM    406  HA  ALA A  28      38.041  12.183  76.327  1.00  0.00           H  
ATOM    407  HB1 ALA A  28      36.704  14.113  78.255  1.00  0.00           H  
ATOM    408  HB2 ALA A  28      36.307  14.027  76.539  1.00  0.00           H  
ATOM    409  HB3 ALA A  28      36.015  12.635  77.582  1.00  0.00           H  
ATOM    410  N   LEU A  29      39.177  15.058  77.480  1.00  0.00           N  
ATOM    411  CA  LEU A  29      40.051  16.203  77.124  1.00  0.00           C  
ATOM    412  C   LEU A  29      41.441  15.665  76.783  1.00  0.00           C  
ATOM    413  O   LEU A  29      42.216  16.295  76.092  1.00  0.00           O  
ATOM    414  CB  LEU A  29      40.145  17.147  78.323  1.00  0.00           C  
ATOM    415  CG  LEU A  29      40.327  18.575  77.821  1.00  0.00           C  
ATOM    416  CD1 LEU A  29      39.044  19.034  77.129  1.00  0.00           C  
ATOM    417  CD2 LEU A  29      40.619  19.493  79.005  1.00  0.00           C  
ATOM    418  H   LEU A  29      38.770  15.015  78.370  1.00  0.00           H  
ATOM    419  HA  LEU A  29      39.643  16.731  76.276  1.00  0.00           H  
ATOM    420  HB2 LEU A  29      39.235  17.081  78.903  1.00  0.00           H  
ATOM    421  HB3 LEU A  29      40.986  16.869  78.940  1.00  0.00           H  
ATOM    422  HG  LEU A  29      41.149  18.612  77.121  1.00  0.00           H  
ATOM    423 HD11 LEU A  29      38.211  18.919  77.807  1.00  0.00           H  
ATOM    424 HD12 LEU A  29      39.138  20.072  76.847  1.00  0.00           H  
ATOM    425 HD13 LEU A  29      38.876  18.433  76.247  1.00  0.00           H  
ATOM    426 HD21 LEU A  29      41.309  19.004  79.676  1.00  0.00           H  
ATOM    427 HD22 LEU A  29      41.053  20.413  78.648  1.00  0.00           H  
ATOM    428 HD23 LEU A  29      39.699  19.704  79.526  1.00  0.00           H  
ATOM    429  N   PHE A  30      41.754  14.498  77.275  1.00  0.00           N  
ATOM    430  CA  PHE A  30      43.074  13.889  77.010  1.00  0.00           C  
ATOM    431  C   PHE A  30      43.012  13.068  75.718  1.00  0.00           C  
ATOM    432  O   PHE A  30      42.072  12.335  75.484  1.00  0.00           O  
ATOM    433  CB  PHE A  30      43.401  12.968  78.180  1.00  0.00           C  
ATOM    434  CG  PHE A  30      43.619  13.776  79.444  1.00  0.00           C  
ATOM    435  CD1 PHE A  30      43.774  15.169  79.384  1.00  0.00           C  
ATOM    436  CD2 PHE A  30      43.664  13.124  80.682  1.00  0.00           C  
ATOM    437  CE1 PHE A  30      43.974  15.903  80.559  1.00  0.00           C  
ATOM    438  CE2 PHE A  30      43.864  13.859  81.856  1.00  0.00           C  
ATOM    439  CZ  PHE A  30      44.020  15.248  81.794  1.00  0.00           C  
ATOM    440  H   PHE A  30      41.117  14.014  77.832  1.00  0.00           H  
ATOM    441  HA  PHE A  30      43.828  14.654  76.922  1.00  0.00           H  
ATOM    442  HB2 PHE A  30      42.580  12.286  78.331  1.00  0.00           H  
ATOM    443  HB3 PHE A  30      44.282  12.411  77.954  1.00  0.00           H  
ATOM    444  HD1 PHE A  30      43.740  15.677  78.432  1.00  0.00           H  
ATOM    445  HD2 PHE A  30      43.545  12.052  80.731  1.00  0.00           H  
ATOM    446  HE1 PHE A  30      44.094  16.976  80.510  1.00  0.00           H  
ATOM    447  HE2 PHE A  30      43.899  13.354  82.810  1.00  0.00           H  
ATOM    448  HZ  PHE A  30      44.174  15.815  82.700  1.00  0.00           H  
ATOM    449  N   ALA A  31      44.007  13.179  74.882  1.00  0.00           N  
ATOM    450  CA  ALA A  31      44.000  12.397  73.614  1.00  0.00           C  
ATOM    451  C   ALA A  31      43.727  10.923  73.930  1.00  0.00           C  
ATOM    452  O   ALA A  31      43.521  10.552  75.067  1.00  0.00           O  
ATOM    453  CB  ALA A  31      45.360  12.527  72.923  1.00  0.00           C  
ATOM    454  H   ALA A  31      44.758  13.773  75.089  1.00  0.00           H  
ATOM    455  HA  ALA A  31      43.227  12.775  72.961  1.00  0.00           H  
ATOM    456  HB1 ALA A  31      46.049  13.038  73.579  1.00  0.00           H  
ATOM    457  HB2 ALA A  31      45.743  11.544  72.695  1.00  0.00           H  
ATOM    458  HB3 ALA A  31      45.248  13.091  72.009  1.00  0.00           H  
ATOM    459  N   ASP A  32      43.724  10.081  72.933  1.00  0.00           N  
ATOM    460  CA  ASP A  32      43.463   8.634  73.180  1.00  0.00           C  
ATOM    461  C   ASP A  32      44.606   8.043  73.997  1.00  0.00           C  
ATOM    462  O   ASP A  32      44.458   7.044  74.674  1.00  0.00           O  
ATOM    463  CB  ASP A  32      43.366   7.902  71.846  1.00  0.00           C  
ATOM    464  CG  ASP A  32      41.952   7.348  71.666  1.00  0.00           C  
ATOM    465  OD1 ASP A  32      41.113   8.072  71.157  1.00  0.00           O  
ATOM    466  OD2 ASP A  32      41.733   6.207  72.040  1.00  0.00           O  
ATOM    467  H   ASP A  32      43.891  10.401  72.021  1.00  0.00           H  
ATOM    468  HA  ASP A  32      42.543   8.523  73.717  1.00  0.00           H  
ATOM    469  HB2 ASP A  32      43.590   8.592  71.049  1.00  0.00           H  
ATOM    470  HB3 ASP A  32      44.075   7.090  71.831  1.00  0.00           H  
ATOM    471  N   ASP A  33      45.744   8.659  73.933  1.00  0.00           N  
ATOM    472  CA  ASP A  33      46.918   8.160  74.692  1.00  0.00           C  
ATOM    473  C   ASP A  33      47.793   9.346  75.096  1.00  0.00           C  
ATOM    474  O   ASP A  33      49.000   9.321  74.952  1.00  0.00           O  
ATOM    475  CB  ASP A  33      47.727   7.206  73.811  1.00  0.00           C  
ATOM    476  CG  ASP A  33      48.186   7.943  72.552  1.00  0.00           C  
ATOM    477  OD1 ASP A  33      47.502   8.870  72.149  1.00  0.00           O  
ATOM    478  OD2 ASP A  33      49.213   7.568  72.012  1.00  0.00           O  
ATOM    479  H   ASP A  33      45.824   9.453  73.380  1.00  0.00           H  
ATOM    480  HA  ASP A  33      46.581   7.643  75.573  1.00  0.00           H  
ATOM    481  HB2 ASP A  33      48.590   6.855  74.359  1.00  0.00           H  
ATOM    482  HB3 ASP A  33      47.111   6.365  73.530  1.00  0.00           H  
ATOM    483  N   ALA A  34      47.192  10.391  75.594  1.00  0.00           N  
ATOM    484  CA  ALA A  34      47.984  11.587  75.999  1.00  0.00           C  
ATOM    485  C   ALA A  34      49.128  11.162  76.923  1.00  0.00           C  
ATOM    486  O   ALA A  34      49.311   9.996  77.208  1.00  0.00           O  
ATOM    487  CB  ALA A  34      47.076  12.577  76.731  1.00  0.00           C  
ATOM    488  H   ALA A  34      46.218  10.393  75.696  1.00  0.00           H  
ATOM    489  HA  ALA A  34      48.390  12.056  75.117  1.00  0.00           H  
ATOM    490  HB1 ALA A  34      46.139  12.096  76.972  1.00  0.00           H  
ATOM    491  HB2 ALA A  34      47.557  12.903  77.641  1.00  0.00           H  
ATOM    492  HB3 ALA A  34      46.889  13.431  76.096  1.00  0.00           H  
ATOM    493  N   THR A  35      49.901  12.106  77.391  1.00  0.00           N  
ATOM    494  CA  THR A  35      51.036  11.765  78.295  1.00  0.00           C  
ATOM    495  C   THR A  35      50.928  12.586  79.582  1.00  0.00           C  
ATOM    496  O   THR A  35      50.660  13.772  79.554  1.00  0.00           O  
ATOM    497  CB  THR A  35      52.358  12.088  77.595  1.00  0.00           C  
ATOM    498  OG1 THR A  35      52.123  13.024  76.552  1.00  0.00           O  
ATOM    499  CG2 THR A  35      52.955  10.807  77.008  1.00  0.00           C  
ATOM    500  H   THR A  35      49.734  13.041  77.147  1.00  0.00           H  
ATOM    501  HA  THR A  35      51.001  10.713  78.534  1.00  0.00           H  
ATOM    502  HB  THR A  35      53.050  12.509  78.308  1.00  0.00           H  
ATOM    503  HG1 THR A  35      52.906  13.057  75.999  1.00  0.00           H  
ATOM    504 HG21 THR A  35      52.166  10.207  76.577  1.00  0.00           H  
ATOM    505 HG22 THR A  35      53.672  11.062  76.241  1.00  0.00           H  
ATOM    506 HG23 THR A  35      53.447  10.248  77.790  1.00  0.00           H  
ATOM    507  N   VAL A  36      51.136  11.965  80.709  1.00  0.00           N  
ATOM    508  CA  VAL A  36      51.048  12.704  82.000  1.00  0.00           C  
ATOM    509  C   VAL A  36      52.438  12.752  82.648  1.00  0.00           C  
ATOM    510  O   VAL A  36      53.349  12.073  82.228  1.00  0.00           O  
ATOM    511  CB  VAL A  36      50.051  11.983  82.922  1.00  0.00           C  
ATOM    512  CG1 VAL A  36      50.298  12.368  84.383  1.00  0.00           C  
ATOM    513  CG2 VAL A  36      48.627  12.382  82.533  1.00  0.00           C  
ATOM    514  H   VAL A  36      51.351  11.010  80.708  1.00  0.00           H  
ATOM    515  HA  VAL A  36      50.704  13.712  81.816  1.00  0.00           H  
ATOM    516  HB  VAL A  36      50.169  10.915  82.809  1.00  0.00           H  
ATOM    517 HG11 VAL A  36      51.302  12.088  84.666  1.00  0.00           H  
ATOM    518 HG12 VAL A  36      50.175  13.434  84.501  1.00  0.00           H  
ATOM    519 HG13 VAL A  36      49.590  11.852  85.015  1.00  0.00           H  
ATOM    520 HG21 VAL A  36      48.554  12.457  81.458  1.00  0.00           H  
ATOM    521 HG22 VAL A  36      47.933  11.633  82.889  1.00  0.00           H  
ATOM    522 HG23 VAL A  36      48.385  13.336  82.978  1.00  0.00           H  
ATOM    523  N   GLU A  37      52.597  13.543  83.672  1.00  0.00           N  
ATOM    524  CA  GLU A  37      53.911  13.636  84.365  1.00  0.00           C  
ATOM    525  C   GLU A  37      53.626  13.978  85.818  1.00  0.00           C  
ATOM    526  O   GLU A  37      53.238  15.085  86.136  1.00  0.00           O  
ATOM    527  CB  GLU A  37      54.764  14.737  83.729  1.00  0.00           C  
ATOM    528  CG  GLU A  37      54.995  14.418  82.250  1.00  0.00           C  
ATOM    529  CD  GLU A  37      56.330  15.017  81.801  1.00  0.00           C  
ATOM    530  OE1 GLU A  37      56.857  15.845  82.525  1.00  0.00           O  
ATOM    531  OE2 GLU A  37      56.803  14.634  80.744  1.00  0.00           O  
ATOM    532  H   GLU A  37      51.841  14.074  84.003  1.00  0.00           H  
ATOM    533  HA  GLU A  37      54.426  12.690  84.306  1.00  0.00           H  
ATOM    534  HB2 GLU A  37      54.256  15.684  83.819  1.00  0.00           H  
ATOM    535  HB3 GLU A  37      55.716  14.789  84.235  1.00  0.00           H  
ATOM    536  HG2 GLU A  37      55.015  13.346  82.111  1.00  0.00           H  
ATOM    537  HG3 GLU A  37      54.196  14.844  81.660  1.00  0.00           H  
ATOM    538  N   ASP A  38      53.771  13.040  86.706  1.00  0.00           N  
ATOM    539  CA  ASP A  38      53.453  13.347  88.126  1.00  0.00           C  
ATOM    540  C   ASP A  38      53.824  12.153  89.012  1.00  0.00           C  
ATOM    541  O   ASP A  38      53.839  11.032  88.549  1.00  0.00           O  
ATOM    542  CB  ASP A  38      51.949  13.622  88.223  1.00  0.00           C  
ATOM    543  CG  ASP A  38      51.698  15.122  88.405  1.00  0.00           C  
ATOM    544  OD1 ASP A  38      52.315  15.708  89.279  1.00  0.00           O  
ATOM    545  OD2 ASP A  38      50.888  15.659  87.667  1.00  0.00           O  
ATOM    546  H   ASP A  38      54.063  12.134  86.437  1.00  0.00           H  
ATOM    547  HA  ASP A  38      53.999  14.222  88.437  1.00  0.00           H  
ATOM    548  HB2 ASP A  38      51.469  13.289  87.314  1.00  0.00           H  
ATOM    549  HB3 ASP A  38      51.538  13.085  89.056  1.00  0.00           H  
ATOM    550  N   PRO A  39      54.112  12.421  90.265  1.00  0.00           N  
ATOM    551  CA  PRO A  39      54.074  13.809  90.803  1.00  0.00           C  
ATOM    552  C   PRO A  39      55.270  14.636  90.311  1.00  0.00           C  
ATOM    553  O   PRO A  39      55.112  15.583  89.567  1.00  0.00           O  
ATOM    554  CB  PRO A  39      54.138  13.608  92.315  1.00  0.00           C  
ATOM    555  CG  PRO A  39      54.800  12.281  92.509  1.00  0.00           C  
ATOM    556  CD  PRO A  39      54.499  11.445  91.292  1.00  0.00           C  
ATOM    557  HA  PRO A  39      53.148  14.289  90.539  1.00  0.00           H  
ATOM    558  HB2 PRO A  39      54.724  14.394  92.771  1.00  0.00           H  
ATOM    559  HB3 PRO A  39      53.143  13.589  92.733  1.00  0.00           H  
ATOM    560  HG2 PRO A  39      55.867  12.414  92.615  1.00  0.00           H  
ATOM    561  HG3 PRO A  39      54.401  11.796  93.387  1.00  0.00           H  
ATOM    562  HD2 PRO A  39      55.380  10.897  90.984  1.00  0.00           H  
ATOM    563  HD3 PRO A  39      53.681  10.770  91.488  1.00  0.00           H  
ATOM    564  N   VAL A  40      56.461  14.297  90.721  1.00  0.00           N  
ATOM    565  CA  VAL A  40      57.647  15.078  90.271  1.00  0.00           C  
ATOM    566  C   VAL A  40      58.910  14.228  90.428  1.00  0.00           C  
ATOM    567  O   VAL A  40      59.580  14.275  91.440  1.00  0.00           O  
ATOM    568  CB  VAL A  40      57.774  16.347  91.118  1.00  0.00           C  
ATOM    569  CG1 VAL A  40      56.593  17.274  90.828  1.00  0.00           C  
ATOM    570  CG2 VAL A  40      57.774  15.969  92.601  1.00  0.00           C  
ATOM    571  H   VAL A  40      56.574  13.534  91.324  1.00  0.00           H  
ATOM    572  HA  VAL A  40      57.525  15.350  89.233  1.00  0.00           H  
ATOM    573  HB  VAL A  40      58.697  16.854  90.874  1.00  0.00           H  
ATOM    574 HG11 VAL A  40      56.370  17.254  89.772  1.00  0.00           H  
ATOM    575 HG12 VAL A  40      55.729  16.942  91.385  1.00  0.00           H  
ATOM    576 HG13 VAL A  40      56.846  18.282  91.124  1.00  0.00           H  
ATOM    577 HG21 VAL A  40      57.932  14.906  92.702  1.00  0.00           H  
ATOM    578 HG22 VAL A  40      58.567  16.501  93.108  1.00  0.00           H  
ATOM    579 HG23 VAL A  40      56.824  16.236  93.040  1.00  0.00           H  
ATOM    580  N   GLY A  41      59.239  13.452  89.432  1.00  0.00           N  
ATOM    581  CA  GLY A  41      60.457  12.600  89.522  1.00  0.00           C  
ATOM    582  C   GLY A  41      60.411  11.524  88.435  1.00  0.00           C  
ATOM    583  O   GLY A  41      60.796  10.392  88.651  1.00  0.00           O  
ATOM    584  H   GLY A  41      58.685  13.429  88.625  1.00  0.00           H  
ATOM    585  HA2 GLY A  41      61.336  13.215  89.384  1.00  0.00           H  
ATOM    586  HA3 GLY A  41      60.498  12.128  90.492  1.00  0.00           H  
ATOM    587  N   SER A  42      59.943  11.870  87.266  1.00  0.00           N  
ATOM    588  CA  SER A  42      59.874  10.873  86.159  1.00  0.00           C  
ATOM    589  C   SER A  42      58.747   9.871  86.427  1.00  0.00           C  
ATOM    590  O   SER A  42      58.963   8.676  86.464  1.00  0.00           O  
ATOM    591  CB  SER A  42      61.206  10.128  86.058  1.00  0.00           C  
ATOM    592  OG  SER A  42      61.808  10.410  84.801  1.00  0.00           O  
ATOM    593  H   SER A  42      59.641  12.789  87.114  1.00  0.00           H  
ATOM    594  HA  SER A  42      59.683  11.384  85.228  1.00  0.00           H  
ATOM    595  HB2 SER A  42      61.864  10.453  86.846  1.00  0.00           H  
ATOM    596  HB3 SER A  42      61.028   9.067  86.154  1.00  0.00           H  
ATOM    597  HG  SER A  42      62.748  10.229  84.875  1.00  0.00           H  
ATOM    598  N   GLU A  43      57.545  10.347  86.614  1.00  0.00           N  
ATOM    599  CA  GLU A  43      56.410   9.418  86.876  1.00  0.00           C  
ATOM    600  C   GLU A  43      55.217   9.791  85.986  1.00  0.00           C  
ATOM    601  O   GLU A  43      54.140  10.076  86.465  1.00  0.00           O  
ATOM    602  CB  GLU A  43      56.019   9.519  88.349  1.00  0.00           C  
ATOM    603  CG  GLU A  43      57.169   8.995  89.207  1.00  0.00           C  
ATOM    604  CD  GLU A  43      56.629   8.016  90.252  1.00  0.00           C  
ATOM    605  OE1 GLU A  43      55.497   7.584  90.102  1.00  0.00           O  
ATOM    606  OE2 GLU A  43      57.355   7.716  91.184  1.00  0.00           O  
ATOM    607  H   GLU A  43      57.390  11.312  86.583  1.00  0.00           H  
ATOM    608  HA  GLU A  43      56.720   8.410  86.652  1.00  0.00           H  
ATOM    609  HB2 GLU A  43      55.830  10.552  88.598  1.00  0.00           H  
ATOM    610  HB3 GLU A  43      55.133   8.931  88.532  1.00  0.00           H  
ATOM    611  HG2 GLU A  43      57.886   8.491  88.575  1.00  0.00           H  
ATOM    612  HG3 GLU A  43      57.648   9.823  89.706  1.00  0.00           H  
ATOM    613  N   PRO A  44      55.467   9.767  84.707  1.00  0.00           N  
ATOM    614  CA  PRO A  44      54.430  10.099  83.702  1.00  0.00           C  
ATOM    615  C   PRO A  44      53.489   8.912  83.461  1.00  0.00           C  
ATOM    616  O   PRO A  44      53.687   7.830  83.978  1.00  0.00           O  
ATOM    617  CB  PRO A  44      55.242  10.391  82.444  1.00  0.00           C  
ATOM    618  CG  PRO A  44      56.523   9.634  82.613  1.00  0.00           C  
ATOM    619  CD  PRO A  44      56.745   9.430  84.091  1.00  0.00           C  
ATOM    620  HA  PRO A  44      53.875  10.973  83.995  1.00  0.00           H  
ATOM    621  HB2 PRO A  44      54.712  10.045  81.568  1.00  0.00           H  
ATOM    622  HB3 PRO A  44      55.447  11.447  82.367  1.00  0.00           H  
ATOM    623  HG2 PRO A  44      56.451   8.677  82.115  1.00  0.00           H  
ATOM    624  HG3 PRO A  44      57.342  10.203  82.199  1.00  0.00           H  
ATOM    625  HD2 PRO A  44      56.994   8.406  84.298  1.00  0.00           H  
ATOM    626  HD3 PRO A  44      57.515  10.088  84.454  1.00  0.00           H  
ATOM    627  N   ARG A  45      52.472   9.115  82.667  1.00  0.00           N  
ATOM    628  CA  ARG A  45      51.510   8.017  82.367  1.00  0.00           C  
ATOM    629  C   ARG A  45      50.924   8.249  80.971  1.00  0.00           C  
ATOM    630  O   ARG A  45      50.036   9.058  80.789  1.00  0.00           O  
ATOM    631  CB  ARG A  45      50.386   8.017  83.404  1.00  0.00           C  
ATOM    632  CG  ARG A  45      50.754   7.079  84.556  1.00  0.00           C  
ATOM    633  CD  ARG A  45      50.801   5.638  84.047  1.00  0.00           C  
ATOM    634  NE  ARG A  45      51.912   4.908  84.720  1.00  0.00           N  
ATOM    635  CZ  ARG A  45      51.836   3.617  84.891  1.00  0.00           C  
ATOM    636  NH1 ARG A  45      51.825   2.822  83.855  1.00  0.00           N  
ATOM    637  NH2 ARG A  45      51.770   3.119  86.095  1.00  0.00           N  
ATOM    638  H   ARG A  45      52.343   9.996  82.258  1.00  0.00           H  
ATOM    639  HA  ARG A  45      52.027   7.068  82.389  1.00  0.00           H  
ATOM    640  HB2 ARG A  45      50.248   9.020  83.784  1.00  0.00           H  
ATOM    641  HB3 ARG A  45      49.471   7.676  82.943  1.00  0.00           H  
ATOM    642  HG2 ARG A  45      51.722   7.355  84.949  1.00  0.00           H  
ATOM    643  HG3 ARG A  45      50.012   7.159  85.335  1.00  0.00           H  
ATOM    644  HD2 ARG A  45      49.864   5.148  84.266  1.00  0.00           H  
ATOM    645  HD3 ARG A  45      50.966   5.638  82.979  1.00  0.00           H  
ATOM    646  HE  ARG A  45      52.700   5.397  85.036  1.00  0.00           H  
ATOM    647 HH11 ARG A  45      51.875   3.204  82.932  1.00  0.00           H  
ATOM    648 HH12 ARG A  45      51.767   1.832  83.984  1.00  0.00           H  
ATOM    649 HH21 ARG A  45      51.776   3.728  86.888  1.00  0.00           H  
ATOM    650 HH22 ARG A  45      51.711   2.130  86.225  1.00  0.00           H  
ATOM    651  N   SER A  46      51.422   7.559  79.984  1.00  0.00           N  
ATOM    652  CA  SER A  46      50.904   7.754  78.603  1.00  0.00           C  
ATOM    653  C   SER A  46      49.730   6.806  78.342  1.00  0.00           C  
ATOM    654  O   SER A  46      49.487   5.880  79.089  1.00  0.00           O  
ATOM    655  CB  SER A  46      52.033   7.473  77.616  1.00  0.00           C  
ATOM    656  OG  SER A  46      51.611   6.510  76.658  1.00  0.00           O  
ATOM    657  H   SER A  46      52.146   6.921  80.146  1.00  0.00           H  
ATOM    658  HA  SER A  46      50.577   8.774  78.485  1.00  0.00           H  
ATOM    659  HB2 SER A  46      52.303   8.381  77.111  1.00  0.00           H  
ATOM    660  HB3 SER A  46      52.890   7.104  78.161  1.00  0.00           H  
ATOM    661  HG  SER A  46      52.393   6.150  76.233  1.00  0.00           H  
ATOM    662  N   GLY A  47      49.001   7.036  77.282  1.00  0.00           N  
ATOM    663  CA  GLY A  47      47.840   6.154  76.966  1.00  0.00           C  
ATOM    664  C   GLY A  47      46.600   6.656  77.709  1.00  0.00           C  
ATOM    665  O   GLY A  47      46.600   7.728  78.280  1.00  0.00           O  
ATOM    666  H   GLY A  47      49.217   7.789  76.694  1.00  0.00           H  
ATOM    667  HA2 GLY A  47      47.655   6.171  75.902  1.00  0.00           H  
ATOM    668  HA3 GLY A  47      48.057   5.147  77.276  1.00  0.00           H  
ATOM    669  N   THR A  48      45.545   5.889  77.710  1.00  0.00           N  
ATOM    670  CA  THR A  48      44.313   6.321  78.419  1.00  0.00           C  
ATOM    671  C   THR A  48      44.204   5.554  79.739  1.00  0.00           C  
ATOM    672  O   THR A  48      43.946   6.123  80.781  1.00  0.00           O  
ATOM    673  CB  THR A  48      43.096   6.020  77.539  1.00  0.00           C  
ATOM    674  OG1 THR A  48      43.011   6.992  76.505  1.00  0.00           O  
ATOM    675  CG2 THR A  48      41.824   6.061  78.382  1.00  0.00           C  
ATOM    676  H   THR A  48      45.563   5.027  77.247  1.00  0.00           H  
ATOM    677  HA  THR A  48      44.363   7.381  78.620  1.00  0.00           H  
ATOM    678  HB  THR A  48      43.201   5.039  77.102  1.00  0.00           H  
ATOM    679  HG1 THR A  48      42.730   7.821  76.899  1.00  0.00           H  
ATOM    680 HG21 THR A  48      42.002   6.650  79.270  1.00  0.00           H  
ATOM    681 HG22 THR A  48      41.026   6.506  77.808  1.00  0.00           H  
ATOM    682 HG23 THR A  48      41.549   5.056  78.665  1.00  0.00           H  
ATOM    683  N   ALA A  49      44.403   4.265  79.703  1.00  0.00           N  
ATOM    684  CA  ALA A  49      44.315   3.462  80.956  1.00  0.00           C  
ATOM    685  C   ALA A  49      45.325   4.000  81.971  1.00  0.00           C  
ATOM    686  O   ALA A  49      45.172   3.827  83.163  1.00  0.00           O  
ATOM    687  CB  ALA A  49      44.632   1.998  80.646  1.00  0.00           C  
ATOM    688  H   ALA A  49      44.612   3.825  78.853  1.00  0.00           H  
ATOM    689  HA  ALA A  49      43.318   3.537  81.363  1.00  0.00           H  
ATOM    690  HB1 ALA A  49      44.658   1.854  79.576  1.00  0.00           H  
ATOM    691  HB2 ALA A  49      45.593   1.741  81.068  1.00  0.00           H  
ATOM    692  HB3 ALA A  49      43.870   1.366  81.076  1.00  0.00           H  
ATOM    693  N   ALA A  50      46.355   4.653  81.508  1.00  0.00           N  
ATOM    694  CA  ALA A  50      47.373   5.205  82.446  1.00  0.00           C  
ATOM    695  C   ALA A  50      46.973   6.625  82.852  1.00  0.00           C  
ATOM    696  O   ALA A  50      46.897   6.949  84.020  1.00  0.00           O  
ATOM    697  CB  ALA A  50      48.739   5.237  81.757  1.00  0.00           C  
ATOM    698  H   ALA A  50      46.459   4.783  80.542  1.00  0.00           H  
ATOM    699  HA  ALA A  50      47.428   4.580  83.326  1.00  0.00           H  
ATOM    700  HB1 ALA A  50      48.663   4.771  80.785  1.00  0.00           H  
ATOM    701  HB2 ALA A  50      49.060   6.262  81.640  1.00  0.00           H  
ATOM    702  HB3 ALA A  50      49.458   4.702  82.358  1.00  0.00           H  
ATOM    703  N   ILE A  51      46.715   7.475  81.895  1.00  0.00           N  
ATOM    704  CA  ILE A  51      46.316   8.873  82.224  1.00  0.00           C  
ATOM    705  C   ILE A  51      45.074   8.846  83.114  1.00  0.00           C  
ATOM    706  O   ILE A  51      45.006   9.519  84.123  1.00  0.00           O  
ATOM    707  CB  ILE A  51      46.009   9.628  80.930  1.00  0.00           C  
ATOM    708  CG1 ILE A  51      47.256   9.641  80.044  1.00  0.00           C  
ATOM    709  CG2 ILE A  51      45.604  11.067  81.253  1.00  0.00           C  
ATOM    710  CD1 ILE A  51      46.922  10.284  78.698  1.00  0.00           C  
ATOM    711  H   ILE A  51      46.779   7.192  80.959  1.00  0.00           H  
ATOM    712  HA  ILE A  51      47.123   9.364  82.748  1.00  0.00           H  
ATOM    713  HB  ILE A  51      45.201   9.135  80.408  1.00  0.00           H  
ATOM    714 HG12 ILE A  51      48.036  10.209  80.531  1.00  0.00           H  
ATOM    715 HG13 ILE A  51      47.596   8.630  79.885  1.00  0.00           H  
ATOM    716 HG21 ILE A  51      46.397  11.550  81.803  1.00  0.00           H  
ATOM    717 HG22 ILE A  51      45.424  11.605  80.333  1.00  0.00           H  
ATOM    718 HG23 ILE A  51      44.702  11.063  81.847  1.00  0.00           H  
ATOM    719 HD11 ILE A  51      45.849  10.344  78.584  1.00  0.00           H  
ATOM    720 HD12 ILE A  51      47.343  11.277  78.658  1.00  0.00           H  
ATOM    721 HD13 ILE A  51      47.335   9.685  77.899  1.00  0.00           H  
ATOM    722  N   ARG A  52      44.094   8.065  82.755  1.00  0.00           N  
ATOM    723  CA  ARG A  52      42.862   7.988  83.589  1.00  0.00           C  
ATOM    724  C   ARG A  52      43.194   7.273  84.898  1.00  0.00           C  
ATOM    725  O   ARG A  52      42.990   7.802  85.972  1.00  0.00           O  
ATOM    726  CB  ARG A  52      41.784   7.204  82.836  1.00  0.00           C  
ATOM    727  CG  ARG A  52      40.448   7.340  83.568  1.00  0.00           C  
ATOM    728  CD  ARG A  52      39.519   6.200  83.149  1.00  0.00           C  
ATOM    729  NE  ARG A  52      39.143   5.400  84.348  1.00  0.00           N  
ATOM    730  CZ  ARG A  52      38.245   4.460  84.249  1.00  0.00           C  
ATOM    731  NH1 ARG A  52      38.331   3.573  83.297  1.00  0.00           N  
ATOM    732  NH2 ARG A  52      37.259   4.407  85.102  1.00  0.00           N  
ATOM    733  H   ARG A  52      44.170   7.524  81.942  1.00  0.00           H  
ATOM    734  HA  ARG A  52      42.504   8.988  83.802  1.00  0.00           H  
ATOM    735  HB2 ARG A  52      41.689   7.594  81.834  1.00  0.00           H  
ATOM    736  HB3 ARG A  52      42.063   6.161  82.793  1.00  0.00           H  
ATOM    737  HG2 ARG A  52      40.616   7.296  84.635  1.00  0.00           H  
ATOM    738  HG3 ARG A  52      39.992   8.285  83.314  1.00  0.00           H  
ATOM    739  HD2 ARG A  52      38.628   6.609  82.695  1.00  0.00           H  
ATOM    740  HD3 ARG A  52      40.027   5.565  82.438  1.00  0.00           H  
ATOM    741  HE  ARG A  52      39.570   5.581  85.211  1.00  0.00           H  
ATOM    742 HH11 ARG A  52      39.087   3.614  82.643  1.00  0.00           H  
ATOM    743 HH12 ARG A  52      37.642   2.852  83.221  1.00  0.00           H  
ATOM    744 HH21 ARG A  52      37.192   5.087  85.832  1.00  0.00           H  
ATOM    745 HH22 ARG A  52      36.570   3.686  85.027  1.00  0.00           H  
ATOM    746  N   GLU A  53      43.713   6.079  84.822  1.00  0.00           N  
ATOM    747  CA  GLU A  53      44.066   5.345  86.069  1.00  0.00           C  
ATOM    748  C   GLU A  53      44.808   6.299  87.004  1.00  0.00           C  
ATOM    749  O   GLU A  53      44.735   6.187  88.212  1.00  0.00           O  
ATOM    750  CB  GLU A  53      44.964   4.155  85.727  1.00  0.00           C  
ATOM    751  CG  GLU A  53      45.377   3.442  87.017  1.00  0.00           C  
ATOM    752  CD  GLU A  53      46.668   2.657  86.777  1.00  0.00           C  
ATOM    753  OE1 GLU A  53      47.729   3.247  86.898  1.00  0.00           O  
ATOM    754  OE2 GLU A  53      46.574   1.478  86.476  1.00  0.00           O  
ATOM    755  H   GLU A  53      43.878   5.669  83.947  1.00  0.00           H  
ATOM    756  HA  GLU A  53      43.164   4.995  86.550  1.00  0.00           H  
ATOM    757  HB2 GLU A  53      44.424   3.468  85.093  1.00  0.00           H  
ATOM    758  HB3 GLU A  53      45.846   4.506  85.213  1.00  0.00           H  
ATOM    759  HG2 GLU A  53      45.539   4.174  87.796  1.00  0.00           H  
ATOM    760  HG3 GLU A  53      44.595   2.762  87.317  1.00  0.00           H  
ATOM    761  N   PHE A  54      45.514   7.245  86.449  1.00  0.00           N  
ATOM    762  CA  PHE A  54      46.253   8.220  87.285  1.00  0.00           C  
ATOM    763  C   PHE A  54      45.298   9.334  87.691  1.00  0.00           C  
ATOM    764  O   PHE A  54      44.907   9.456  88.835  1.00  0.00           O  
ATOM    765  CB  PHE A  54      47.382   8.819  86.452  1.00  0.00           C  
ATOM    766  CG  PHE A  54      48.615   9.002  87.309  1.00  0.00           C  
ATOM    767  CD1 PHE A  54      48.497   9.098  88.701  1.00  0.00           C  
ATOM    768  CD2 PHE A  54      49.879   9.075  86.709  1.00  0.00           C  
ATOM    769  CE1 PHE A  54      49.639   9.266  89.493  1.00  0.00           C  
ATOM    770  CE2 PHE A  54      51.022   9.244  87.501  1.00  0.00           C  
ATOM    771  CZ  PHE A  54      50.902   9.339  88.892  1.00  0.00           C  
ATOM    772  H   PHE A  54      45.551   7.322  85.474  1.00  0.00           H  
ATOM    773  HA  PHE A  54      46.655   7.733  88.159  1.00  0.00           H  
ATOM    774  HB2 PHE A  54      47.600   8.164  85.630  1.00  0.00           H  
ATOM    775  HB3 PHE A  54      47.068   9.773  86.064  1.00  0.00           H  
ATOM    776  HD1 PHE A  54      47.523   9.041  89.166  1.00  0.00           H  
ATOM    777  HD2 PHE A  54      49.972   9.003  85.636  1.00  0.00           H  
ATOM    778  HE1 PHE A  54      49.546   9.339  90.566  1.00  0.00           H  
ATOM    779  HE2 PHE A  54      51.995   9.300  87.038  1.00  0.00           H  
ATOM    780  HZ  PHE A  54      51.783   9.468  89.503  1.00  0.00           H  
ATOM    781  N   PHE A  55      44.921  10.144  86.746  1.00  0.00           N  
ATOM    782  CA  PHE A  55      43.982  11.261  87.049  1.00  0.00           C  
ATOM    783  C   PHE A  55      42.822  10.724  87.887  1.00  0.00           C  
ATOM    784  O   PHE A  55      42.232  11.434  88.677  1.00  0.00           O  
ATOM    785  CB  PHE A  55      43.459  11.860  85.741  1.00  0.00           C  
ATOM    786  CG  PHE A  55      43.853  13.318  85.676  1.00  0.00           C  
ATOM    787  CD1 PHE A  55      43.118  14.281  86.383  1.00  0.00           C  
ATOM    788  CD2 PHE A  55      44.966  13.707  84.918  1.00  0.00           C  
ATOM    789  CE1 PHE A  55      43.499  15.629  86.330  1.00  0.00           C  
ATOM    790  CE2 PHE A  55      45.343  15.055  84.865  1.00  0.00           C  
ATOM    791  CZ  PHE A  55      44.609  16.012  85.571  1.00  0.00           C  
ATOM    792  H   PHE A  55      45.255  10.011  85.832  1.00  0.00           H  
ATOM    793  HA  PHE A  55      44.500  12.022  87.610  1.00  0.00           H  
ATOM    794  HB2 PHE A  55      43.896  11.330  84.906  1.00  0.00           H  
ATOM    795  HB3 PHE A  55      42.385  11.770  85.701  1.00  0.00           H  
ATOM    796  HD1 PHE A  55      42.260  13.986  86.968  1.00  0.00           H  
ATOM    797  HD2 PHE A  55      45.532  12.968  84.372  1.00  0.00           H  
ATOM    798  HE1 PHE A  55      42.934  16.373  86.872  1.00  0.00           H  
ATOM    799  HE2 PHE A  55      46.201  15.356  84.280  1.00  0.00           H  
ATOM    800  HZ  PHE A  55      44.902  17.047  85.533  1.00  0.00           H  
ATOM    801  N   ALA A  56      42.502   9.468  87.735  1.00  0.00           N  
ATOM    802  CA  ALA A  56      41.394   8.880  88.537  1.00  0.00           C  
ATOM    803  C   ALA A  56      41.894   8.665  89.965  1.00  0.00           C  
ATOM    804  O   ALA A  56      41.274   9.088  90.921  1.00  0.00           O  
ATOM    805  CB  ALA A  56      40.975   7.539  87.932  1.00  0.00           C  
ATOM    806  H   ALA A  56      43.000   8.909  87.102  1.00  0.00           H  
ATOM    807  HA  ALA A  56      40.552   9.556  88.546  1.00  0.00           H  
ATOM    808  HB1 ALA A  56      40.733   7.676  86.888  1.00  0.00           H  
ATOM    809  HB2 ALA A  56      41.786   6.833  88.024  1.00  0.00           H  
ATOM    810  HB3 ALA A  56      40.108   7.164  88.456  1.00  0.00           H  
ATOM    811  N   ASN A  57      43.023   8.026  90.115  1.00  0.00           N  
ATOM    812  CA  ASN A  57      43.574   7.804  91.479  1.00  0.00           C  
ATOM    813  C   ASN A  57      43.704   9.159  92.170  1.00  0.00           C  
ATOM    814  O   ASN A  57      43.508   9.285  93.362  1.00  0.00           O  
ATOM    815  CB  ASN A  57      44.951   7.145  91.374  1.00  0.00           C  
ATOM    816  CG  ASN A  57      45.329   6.531  92.722  1.00  0.00           C  
ATOM    817  OD1 ASN A  57      45.513   7.237  93.694  1.00  0.00           O  
ATOM    818  ND2 ASN A  57      45.451   5.236  92.824  1.00  0.00           N  
ATOM    819  H   ASN A  57      43.514   7.706  89.330  1.00  0.00           H  
ATOM    820  HA  ASN A  57      42.907   7.169  92.044  1.00  0.00           H  
ATOM    821  HB2 ASN A  57      44.924   6.372  90.620  1.00  0.00           H  
ATOM    822  HB3 ASN A  57      45.685   7.889  91.101  1.00  0.00           H  
ATOM    823 HD21 ASN A  57      45.303   4.667  92.040  1.00  0.00           H  
ATOM    824 HD22 ASN A  57      45.692   4.832  93.684  1.00  0.00           H  
ATOM    825  N   SER A  58      44.019  10.179  91.420  1.00  0.00           N  
ATOM    826  CA  SER A  58      44.146  11.534  92.016  1.00  0.00           C  
ATOM    827  C   SER A  58      42.775  11.969  92.532  1.00  0.00           C  
ATOM    828  O   SER A  58      42.656  12.615  93.555  1.00  0.00           O  
ATOM    829  CB  SER A  58      44.620  12.516  90.943  1.00  0.00           C  
ATOM    830  OG  SER A  58      44.473  13.845  91.424  1.00  0.00           O  
ATOM    831  H   SER A  58      44.160  10.052  90.459  1.00  0.00           H  
ATOM    832  HA  SER A  58      44.853  11.511  92.831  1.00  0.00           H  
ATOM    833  HB2 SER A  58      45.657  12.334  90.717  1.00  0.00           H  
ATOM    834  HB3 SER A  58      44.030  12.381  90.047  1.00  0.00           H  
ATOM    835  HG  SER A  58      43.917  14.326  90.805  1.00  0.00           H  
ATOM    836  N   LEU A  59      41.738  11.613  91.826  1.00  0.00           N  
ATOM    837  CA  LEU A  59      40.369  11.987  92.250  1.00  0.00           C  
ATOM    838  C   LEU A  59      39.990  11.211  93.514  1.00  0.00           C  
ATOM    839  O   LEU A  59      39.087  11.586  94.236  1.00  0.00           O  
ATOM    840  CB  LEU A  59      39.406  11.636  91.120  1.00  0.00           C  
ATOM    841  CG  LEU A  59      38.262  12.644  91.093  1.00  0.00           C  
ATOM    842  CD1 LEU A  59      38.821  14.016  90.720  1.00  0.00           C  
ATOM    843  CD2 LEU A  59      37.229  12.212  90.052  1.00  0.00           C  
ATOM    844  H   LEU A  59      41.859  11.093  91.006  1.00  0.00           H  
ATOM    845  HA  LEU A  59      40.326  13.048  92.447  1.00  0.00           H  
ATOM    846  HB2 LEU A  59      39.934  11.667  90.178  1.00  0.00           H  
ATOM    847  HB3 LEU A  59      39.014  10.645  91.278  1.00  0.00           H  
ATOM    848  HG  LEU A  59      37.800  12.694  92.068  1.00  0.00           H  
ATOM    849 HD11 LEU A  59      39.890  13.943  90.581  1.00  0.00           H  
ATOM    850 HD12 LEU A  59      38.361  14.356  89.804  1.00  0.00           H  
ATOM    851 HD13 LEU A  59      38.608  14.719  91.512  1.00  0.00           H  
ATOM    852 HD21 LEU A  59      37.313  11.149  89.880  1.00  0.00           H  
ATOM    853 HD22 LEU A  59      36.237  12.439  90.413  1.00  0.00           H  
ATOM    854 HD23 LEU A  59      37.406  12.740  89.127  1.00  0.00           H  
ATOM    855  N   LYS A  60      40.672  10.133  93.788  1.00  0.00           N  
ATOM    856  CA  LYS A  60      40.347   9.337  95.007  1.00  0.00           C  
ATOM    857  C   LYS A  60      40.415  10.243  96.236  1.00  0.00           C  
ATOM    858  O   LYS A  60      39.775   9.994  97.239  1.00  0.00           O  
ATOM    859  CB  LYS A  60      41.353   8.194  95.156  1.00  0.00           C  
ATOM    860  CG  LYS A  60      41.012   7.081  94.164  1.00  0.00           C  
ATOM    861  CD  LYS A  60      41.574   5.752  94.671  1.00  0.00           C  
ATOM    862  CE  LYS A  60      43.000   5.568  94.147  1.00  0.00           C  
ATOM    863  NZ  LYS A  60      43.481   4.307  94.778  1.00  0.00           N  
ATOM    864  H   LYS A  60      41.396   9.846  93.194  1.00  0.00           H  
ATOM    865  HA  LYS A  60      39.352   8.929  94.914  1.00  0.00           H  
ATOM    866  HB2 LYS A  60      42.349   8.563  94.956  1.00  0.00           H  
ATOM    867  HB3 LYS A  60      41.309   7.804  96.161  1.00  0.00           H  
ATOM    868  HG2 LYS A  60      39.938   7.006  94.066  1.00  0.00           H  
ATOM    869  HG3 LYS A  60      41.445   7.310  93.202  1.00  0.00           H  
ATOM    870  HD2 LYS A  60      41.583   5.753  95.752  1.00  0.00           H  
ATOM    871  HD3 LYS A  60      40.955   4.941  94.317  1.00  0.00           H  
ATOM    872  HE2 LYS A  60      42.994   5.475  93.070  1.00  0.00           H  
ATOM    873  HE3 LYS A  60      43.623   6.395  94.453  1.00  0.00           H  
ATOM    874  HZ1 LYS A  60      42.673   3.682  94.966  1.00  0.00           H  
ATOM    875  HZ2 LYS A  60      44.146   3.830  94.135  1.00  0.00           H  
ATOM    876  HZ3 LYS A  60      43.961   4.528  95.673  1.00  0.00           H  
ATOM    877  N   LEU A  61      41.184  11.296  96.166  1.00  0.00           N  
ATOM    878  CA  LEU A  61      41.291  12.221  97.323  1.00  0.00           C  
ATOM    879  C   LEU A  61      40.214  13.303  97.191  1.00  0.00           C  
ATOM    880  O   LEU A  61      40.168  14.011  96.206  1.00  0.00           O  
ATOM    881  CB  LEU A  61      42.678  12.862  97.311  1.00  0.00           C  
ATOM    882  CG  LEU A  61      43.161  13.088  98.746  1.00  0.00           C  
ATOM    883  CD1 LEU A  61      44.588  12.557  98.893  1.00  0.00           C  
ATOM    884  CD2 LEU A  61      43.146  14.582  99.063  1.00  0.00           C  
ATOM    885  H   LEU A  61      41.689  11.482  95.349  1.00  0.00           H  
ATOM    886  HA  LEU A  61      41.152  11.673  98.243  1.00  0.00           H  
ATOM    887  HB2 LEU A  61      43.369  12.208  96.799  1.00  0.00           H  
ATOM    888  HB3 LEU A  61      42.630  13.806  96.793  1.00  0.00           H  
ATOM    889  HG  LEU A  61      42.510  12.564  99.431  1.00  0.00           H  
ATOM    890 HD11 LEU A  61      44.624  11.527  98.571  1.00  0.00           H  
ATOM    891 HD12 LEU A  61      45.255  13.149  98.283  1.00  0.00           H  
ATOM    892 HD13 LEU A  61      44.892  12.623  99.927  1.00  0.00           H  
ATOM    893 HD21 LEU A  61      42.194  15.001  98.778  1.00  0.00           H  
ATOM    894 HD22 LEU A  61      43.301  14.728 100.122  1.00  0.00           H  
ATOM    895 HD23 LEU A  61      43.935  15.074  98.514  1.00  0.00           H  
ATOM    896  N   PRO A  62      39.366  13.384  98.184  1.00  0.00           N  
ATOM    897  CA  PRO A  62      38.266  14.380  98.166  1.00  0.00           C  
ATOM    898  C   PRO A  62      38.794  15.793  98.431  1.00  0.00           C  
ATOM    899  O   PRO A  62      39.081  16.159  99.554  1.00  0.00           O  
ATOM    900  CB  PRO A  62      37.354  13.925  99.301  1.00  0.00           C  
ATOM    901  CG  PRO A  62      38.242  13.160 100.231  1.00  0.00           C  
ATOM    902  CD  PRO A  62      39.350  12.567  99.402  1.00  0.00           C  
ATOM    903  HA  PRO A  62      37.732  14.342  97.229  1.00  0.00           H  
ATOM    904  HB2 PRO A  62      36.926  14.782  99.804  1.00  0.00           H  
ATOM    905  HB3 PRO A  62      36.574  13.282  98.923  1.00  0.00           H  
ATOM    906  HG2 PRO A  62      38.652  13.828 100.977  1.00  0.00           H  
ATOM    907  HG3 PRO A  62      37.683  12.371 100.709  1.00  0.00           H  
ATOM    908  HD2 PRO A  62      40.295  12.643  99.925  1.00  0.00           H  
ATOM    909  HD3 PRO A  62      39.133  11.539  99.157  1.00  0.00           H  
ATOM    910  N   LEU A  63      38.911  16.596  97.407  1.00  0.00           N  
ATOM    911  CA  LEU A  63      39.403  17.989  97.605  1.00  0.00           C  
ATOM    912  C   LEU A  63      38.544  18.953  96.792  1.00  0.00           C  
ATOM    913  O   LEU A  63      37.614  18.561  96.118  1.00  0.00           O  
ATOM    914  CB  LEU A  63      40.845  18.127  97.126  1.00  0.00           C  
ATOM    915  CG  LEU A  63      41.547  16.773  97.128  1.00  0.00           C  
ATOM    916  CD1 LEU A  63      41.477  16.162  95.727  1.00  0.00           C  
ATOM    917  CD2 LEU A  63      43.011  16.975  97.522  1.00  0.00           C  
ATOM    918  H   LEU A  63      38.664  16.286  96.510  1.00  0.00           H  
ATOM    919  HA  LEU A  63      39.349  18.248  98.646  1.00  0.00           H  
ATOM    920  HB2 LEU A  63      40.842  18.525  96.129  1.00  0.00           H  
ATOM    921  HB3 LEU A  63      41.375  18.804  97.778  1.00  0.00           H  
ATOM    922  HG  LEU A  63      41.063  16.117  97.835  1.00  0.00           H  
ATOM    923 HD11 LEU A  63      41.960  16.821  95.022  1.00  0.00           H  
ATOM    924 HD12 LEU A  63      41.978  15.205  95.726  1.00  0.00           H  
ATOM    925 HD13 LEU A  63      40.444  16.028  95.444  1.00  0.00           H  
ATOM    926 HD21 LEU A  63      43.327  17.967  97.235  1.00  0.00           H  
ATOM    927 HD22 LEU A  63      43.116  16.863  98.590  1.00  0.00           H  
ATOM    928 HD23 LEU A  63      43.625  16.243  97.019  1.00  0.00           H  
ATOM    929  N   ALA A  64      38.871  20.213  96.839  1.00  0.00           N  
ATOM    930  CA  ALA A  64      38.100  21.215  96.055  1.00  0.00           C  
ATOM    931  C   ALA A  64      39.038  21.869  95.042  1.00  0.00           C  
ATOM    932  O   ALA A  64      40.098  22.354  95.385  1.00  0.00           O  
ATOM    933  CB  ALA A  64      37.530  22.281  96.990  1.00  0.00           C  
ATOM    934  H   ALA A  64      39.638  20.497  97.381  1.00  0.00           H  
ATOM    935  HA  ALA A  64      37.293  20.722  95.533  1.00  0.00           H  
ATOM    936  HB1 ALA A  64      37.642  21.958  98.014  1.00  0.00           H  
ATOM    937  HB2 ALA A  64      38.062  23.209  96.844  1.00  0.00           H  
ATOM    938  HB3 ALA A  64      36.483  22.428  96.771  1.00  0.00           H  
ATOM    939  N   VAL A  65      38.665  21.875  93.794  1.00  0.00           N  
ATOM    940  CA  VAL A  65      39.546  22.488  92.759  1.00  0.00           C  
ATOM    941  C   VAL A  65      38.845  23.689  92.126  1.00  0.00           C  
ATOM    942  O   VAL A  65      37.825  23.558  91.479  1.00  0.00           O  
ATOM    943  CB  VAL A  65      39.857  21.452  91.679  1.00  0.00           C  
ATOM    944  CG1 VAL A  65      41.038  21.934  90.833  1.00  0.00           C  
ATOM    945  CG2 VAL A  65      40.219  20.120  92.342  1.00  0.00           C  
ATOM    946  H   VAL A  65      37.811  21.473  93.537  1.00  0.00           H  
ATOM    947  HA  VAL A  65      40.468  22.812  93.220  1.00  0.00           H  
ATOM    948  HB  VAL A  65      38.991  21.319  91.047  1.00  0.00           H  
ATOM    949 HG11 VAL A  65      41.404  22.870  91.228  1.00  0.00           H  
ATOM    950 HG12 VAL A  65      41.827  21.197  90.863  1.00  0.00           H  
ATOM    951 HG13 VAL A  65      40.715  22.075  89.812  1.00  0.00           H  
ATOM    952 HG21 VAL A  65      40.786  20.309  93.241  1.00  0.00           H  
ATOM    953 HG22 VAL A  65      39.314  19.585  92.592  1.00  0.00           H  
ATOM    954 HG23 VAL A  65      40.811  19.528  91.660  1.00  0.00           H  
ATOM    955  N   GLU A  66      39.388  24.862  92.303  1.00  0.00           N  
ATOM    956  CA  GLU A  66      38.761  26.075  91.709  1.00  0.00           C  
ATOM    957  C   GLU A  66      39.849  27.104  91.399  1.00  0.00           C  
ATOM    958  O   GLU A  66      40.259  27.862  92.255  1.00  0.00           O  
ATOM    959  CB  GLU A  66      37.760  26.670  92.701  1.00  0.00           C  
ATOM    960  CG  GLU A  66      36.530  27.177  91.946  1.00  0.00           C  
ATOM    961  CD  GLU A  66      35.266  26.835  92.739  1.00  0.00           C  
ATOM    962  OE1 GLU A  66      34.881  25.678  92.732  1.00  0.00           O  
ATOM    963  OE2 GLU A  66      34.705  27.737  93.338  1.00  0.00           O  
ATOM    964  H   GLU A  66      40.214  24.945  92.825  1.00  0.00           H  
ATOM    965  HA  GLU A  66      38.249  25.805  90.797  1.00  0.00           H  
ATOM    966  HB2 GLU A  66      37.461  25.911  93.410  1.00  0.00           H  
ATOM    967  HB3 GLU A  66      38.220  27.494  93.227  1.00  0.00           H  
ATOM    968  HG2 GLU A  66      36.599  28.248  91.821  1.00  0.00           H  
ATOM    969  HG3 GLU A  66      36.483  26.703  90.977  1.00  0.00           H  
ATOM    970  N   LEU A  67      40.325  27.133  90.183  1.00  0.00           N  
ATOM    971  CA  LEU A  67      41.390  28.108  89.820  1.00  0.00           C  
ATOM    972  C   LEU A  67      41.075  29.475  90.427  1.00  0.00           C  
ATOM    973  O   LEU A  67      39.977  29.727  90.883  1.00  0.00           O  
ATOM    974  CB  LEU A  67      41.468  28.230  88.309  1.00  0.00           C  
ATOM    975  CG  LEU A  67      41.259  26.856  87.671  1.00  0.00           C  
ATOM    976  CD1 LEU A  67      41.669  26.921  86.218  1.00  0.00           C  
ATOM    977  CD2 LEU A  67      42.115  25.807  88.387  1.00  0.00           C  
ATOM    978  H   LEU A  67      39.984  26.508  89.508  1.00  0.00           H  
ATOM    979  HA  LEU A  67      42.335  27.760  90.186  1.00  0.00           H  
ATOM    980  HB2 LEU A  67      40.706  28.907  87.973  1.00  0.00           H  
ATOM    981  HB3 LEU A  67      42.439  28.611  88.029  1.00  0.00           H  
ATOM    982  HG  LEU A  67      40.217  26.581  87.732  1.00  0.00           H  
ATOM    983 HD11 LEU A  67      42.126  27.877  86.023  1.00  0.00           H  
ATOM    984 HD12 LEU A  67      42.374  26.131  86.014  1.00  0.00           H  
ATOM    985 HD13 LEU A  67      40.794  26.800  85.599  1.00  0.00           H  
ATOM    986 HD21 LEU A  67      41.978  25.891  89.454  1.00  0.00           H  
ATOM    987 HD22 LEU A  67      41.819  24.821  88.063  1.00  0.00           H  
ATOM    988 HD23 LEU A  67      43.155  25.967  88.143  1.00  0.00           H  
ATOM    989  N   THR A  68      42.031  30.363  90.433  1.00  0.00           N  
ATOM    990  CA  THR A  68      41.789  31.717  91.007  1.00  0.00           C  
ATOM    991  C   THR A  68      42.656  32.741  90.283  1.00  0.00           C  
ATOM    992  O   THR A  68      42.234  33.843  89.994  1.00  0.00           O  
ATOM    993  CB  THR A  68      42.133  31.714  92.499  1.00  0.00           C  
ATOM    994  OG1 THR A  68      42.439  33.037  92.915  1.00  0.00           O  
ATOM    995  CG2 THR A  68      43.340  30.805  92.745  1.00  0.00           C  
ATOM    996  H   THR A  68      42.907  30.139  90.057  1.00  0.00           H  
ATOM    997  HA  THR A  68      40.758  31.976  90.877  1.00  0.00           H  
ATOM    998  HB  THR A  68      41.290  31.345  93.063  1.00  0.00           H  
ATOM    999  HG1 THR A  68      41.619  33.465  93.171  1.00  0.00           H  
ATOM   1000 HG21 THR A  68      43.156  29.836  92.306  1.00  0.00           H  
ATOM   1001 HG22 THR A  68      44.218  31.244  92.294  1.00  0.00           H  
ATOM   1002 HG23 THR A  68      43.497  30.696  93.808  1.00  0.00           H  
ATOM   1003  N   GLN A  69      43.863  32.377  89.986  1.00  0.00           N  
ATOM   1004  CA  GLN A  69      44.777  33.312  89.272  1.00  0.00           C  
ATOM   1005  C   GLN A  69      44.474  33.263  87.774  1.00  0.00           C  
ATOM   1006  O   GLN A  69      43.343  33.087  87.366  1.00  0.00           O  
ATOM   1007  CB  GLN A  69      46.229  32.893  89.519  1.00  0.00           C  
ATOM   1008  CG  GLN A  69      46.512  31.578  88.790  1.00  0.00           C  
ATOM   1009  CD  GLN A  69      46.956  30.520  89.801  1.00  0.00           C  
ATOM   1010  OE1 GLN A  69      46.331  29.486  89.930  1.00  0.00           O  
ATOM   1011  NE2 GLN A  69      48.017  30.736  90.529  1.00  0.00           N  
ATOM   1012  H   GLN A  69      44.167  31.482  90.230  1.00  0.00           H  
ATOM   1013  HA  GLN A  69      44.624  34.317  89.639  1.00  0.00           H  
ATOM   1014  HB2 GLN A  69      46.893  33.661  89.149  1.00  0.00           H  
ATOM   1015  HB3 GLN A  69      46.390  32.758  90.578  1.00  0.00           H  
ATOM   1016  HG2 GLN A  69      45.614  31.244  88.289  1.00  0.00           H  
ATOM   1017  HG3 GLN A  69      47.295  31.730  88.064  1.00  0.00           H  
ATOM   1018 HE21 GLN A  69      48.521  31.570  90.426  1.00  0.00           H  
ATOM   1019 HE22 GLN A  69      48.310  30.065  91.181  1.00  0.00           H  
ATOM   1020  N   GLU A  70      45.473  33.415  86.946  1.00  0.00           N  
ATOM   1021  CA  GLU A  70      45.230  33.373  85.477  1.00  0.00           C  
ATOM   1022  C   GLU A  70      45.901  32.134  84.880  1.00  0.00           C  
ATOM   1023  O   GLU A  70      47.066  31.876  85.108  1.00  0.00           O  
ATOM   1024  CB  GLU A  70      45.809  34.627  84.823  1.00  0.00           C  
ATOM   1025  CG  GLU A  70      45.161  34.823  83.452  1.00  0.00           C  
ATOM   1026  CD  GLU A  70      45.699  36.104  82.810  1.00  0.00           C  
ATOM   1027  OE1 GLU A  70      46.893  36.164  82.564  1.00  0.00           O  
ATOM   1028  OE2 GLU A  70      44.908  37.002  82.575  1.00  0.00           O  
ATOM   1029  H   GLU A  70      46.379  33.555  87.289  1.00  0.00           H  
ATOM   1030  HA  GLU A  70      44.167  33.330  85.289  1.00  0.00           H  
ATOM   1031  HB2 GLU A  70      45.605  35.486  85.446  1.00  0.00           H  
ATOM   1032  HB3 GLU A  70      46.876  34.513  84.703  1.00  0.00           H  
ATOM   1033  HG2 GLU A  70      45.394  33.978  82.822  1.00  0.00           H  
ATOM   1034  HG3 GLU A  70      44.091  34.902  83.567  1.00  0.00           H  
ATOM   1035  N   VAL A  71      45.174  31.372  84.113  1.00  0.00           N  
ATOM   1036  CA  VAL A  71      45.764  30.154  83.492  1.00  0.00           C  
ATOM   1037  C   VAL A  71      46.805  30.581  82.456  1.00  0.00           C  
ATOM   1038  O   VAL A  71      46.720  31.647  81.881  1.00  0.00           O  
ATOM   1039  CB  VAL A  71      44.649  29.352  82.814  1.00  0.00           C  
ATOM   1040  CG1 VAL A  71      45.253  28.358  81.821  1.00  0.00           C  
ATOM   1041  CG2 VAL A  71      43.858  28.589  83.878  1.00  0.00           C  
ATOM   1042  H   VAL A  71      44.238  31.602  83.937  1.00  0.00           H  
ATOM   1043  HA  VAL A  71      46.237  29.548  84.253  1.00  0.00           H  
ATOM   1044  HB  VAL A  71      43.988  30.027  82.288  1.00  0.00           H  
ATOM   1045 HG11 VAL A  71      46.154  27.935  82.240  1.00  0.00           H  
ATOM   1046 HG12 VAL A  71      44.541  27.572  81.622  1.00  0.00           H  
ATOM   1047 HG13 VAL A  71      45.491  28.872  80.901  1.00  0.00           H  
ATOM   1048 HG21 VAL A  71      43.634  29.250  84.701  1.00  0.00           H  
ATOM   1049 HG22 VAL A  71      42.938  28.224  83.448  1.00  0.00           H  
ATOM   1050 HG23 VAL A  71      44.445  27.756  84.234  1.00  0.00           H  
ATOM   1051  N   ARG A  72      47.787  29.759  82.212  1.00  0.00           N  
ATOM   1052  CA  ARG A  72      48.828  30.131  81.211  1.00  0.00           C  
ATOM   1053  C   ARG A  72      48.761  29.174  80.020  1.00  0.00           C  
ATOM   1054  O   ARG A  72      48.653  27.974  80.178  1.00  0.00           O  
ATOM   1055  CB  ARG A  72      50.218  30.057  81.849  1.00  0.00           C  
ATOM   1056  CG  ARG A  72      50.115  30.335  83.350  1.00  0.00           C  
ATOM   1057  CD  ARG A  72      51.487  30.145  83.997  1.00  0.00           C  
ATOM   1058  NE  ARG A  72      51.339  30.112  85.480  1.00  0.00           N  
ATOM   1059  CZ  ARG A  72      51.456  31.211  86.173  1.00  0.00           C  
ATOM   1060  NH1 ARG A  72      50.691  32.234  85.908  1.00  0.00           N  
ATOM   1061  NH2 ARG A  72      52.341  31.290  87.129  1.00  0.00           N  
ATOM   1062  H   ARG A  72      47.841  28.900  82.687  1.00  0.00           H  
ATOM   1063  HA  ARG A  72      48.646  31.140  80.868  1.00  0.00           H  
ATOM   1064  HB2 ARG A  72      50.634  29.074  81.691  1.00  0.00           H  
ATOM   1065  HB3 ARG A  72      50.860  30.796  81.393  1.00  0.00           H  
ATOM   1066  HG2 ARG A  72      49.779  31.350  83.506  1.00  0.00           H  
ATOM   1067  HG3 ARG A  72      49.411  29.649  83.797  1.00  0.00           H  
ATOM   1068  HD2 ARG A  72      51.919  29.216  83.659  1.00  0.00           H  
ATOM   1069  HD3 ARG A  72      52.132  30.965  83.718  1.00  0.00           H  
ATOM   1070  HE  ARG A  72      51.155  29.264  85.934  1.00  0.00           H  
ATOM   1071 HH11 ARG A  72      50.014  32.174  85.174  1.00  0.00           H  
ATOM   1072 HH12 ARG A  72      50.778  33.076  86.440  1.00  0.00           H  
ATOM   1073 HH21 ARG A  72      52.931  30.508  87.331  1.00  0.00           H  
ATOM   1074 HH22 ARG A  72      52.431  32.133  87.661  1.00  0.00           H  
ATOM   1075  N   ALA A  73      48.826  29.698  78.827  1.00  0.00           N  
ATOM   1076  CA  ALA A  73      48.769  28.823  77.623  1.00  0.00           C  
ATOM   1077  C   ALA A  73      49.570  29.470  76.490  1.00  0.00           C  
ATOM   1078  O   ALA A  73      49.203  30.506  75.973  1.00  0.00           O  
ATOM   1079  CB  ALA A  73      47.313  28.652  77.184  1.00  0.00           C  
ATOM   1080  H   ALA A  73      48.914  30.668  78.722  1.00  0.00           H  
ATOM   1081  HA  ALA A  73      49.191  27.858  77.858  1.00  0.00           H  
ATOM   1082  HB1 ALA A  73      46.684  28.546  78.056  1.00  0.00           H  
ATOM   1083  HB2 ALA A  73      47.002  29.519  76.620  1.00  0.00           H  
ATOM   1084  HB3 ALA A  73      47.223  27.770  76.566  1.00  0.00           H  
ATOM   1085  N   VAL A  74      50.662  28.869  76.103  1.00  0.00           N  
ATOM   1086  CA  VAL A  74      51.485  29.454  75.004  1.00  0.00           C  
ATOM   1087  C   VAL A  74      51.787  28.376  73.964  1.00  0.00           C  
ATOM   1088  O   VAL A  74      51.790  27.198  74.260  1.00  0.00           O  
ATOM   1089  CB  VAL A  74      52.813  29.998  75.552  1.00  0.00           C  
ATOM   1090  CG1 VAL A  74      52.900  31.496  75.269  1.00  0.00           C  
ATOM   1091  CG2 VAL A  74      52.907  29.755  77.064  1.00  0.00           C  
ATOM   1092  H   VAL A  74      50.941  28.034  76.534  1.00  0.00           H  
ATOM   1093  HA  VAL A  74      50.936  30.257  74.535  1.00  0.00           H  
ATOM   1094  HB  VAL A  74      53.633  29.499  75.057  1.00  0.00           H  
ATOM   1095 HG11 VAL A  74      52.622  31.684  74.243  1.00  0.00           H  
ATOM   1096 HG12 VAL A  74      52.229  32.027  75.928  1.00  0.00           H  
ATOM   1097 HG13 VAL A  74      53.912  31.835  75.436  1.00  0.00           H  
ATOM   1098 HG21 VAL A  74      52.813  28.699  77.265  1.00  0.00           H  
ATOM   1099 HG22 VAL A  74      53.863  30.107  77.426  1.00  0.00           H  
ATOM   1100 HG23 VAL A  74      52.114  30.291  77.565  1.00  0.00           H  
ATOM   1101  N   ALA A  75      52.052  28.773  72.751  1.00  0.00           N  
ATOM   1102  CA  ALA A  75      52.365  27.774  71.694  1.00  0.00           C  
ATOM   1103  C   ALA A  75      51.387  26.601  71.795  1.00  0.00           C  
ATOM   1104  O   ALA A  75      50.243  26.767  72.169  1.00  0.00           O  
ATOM   1105  CB  ALA A  75      53.795  27.267  71.893  1.00  0.00           C  
ATOM   1106  H   ALA A  75      52.052  29.729  72.536  1.00  0.00           H  
ATOM   1107  HA  ALA A  75      52.278  28.235  70.722  1.00  0.00           H  
ATOM   1108  HB1 ALA A  75      54.465  28.110  71.981  1.00  0.00           H  
ATOM   1109  HB2 ALA A  75      53.843  26.673  72.793  1.00  0.00           H  
ATOM   1110  HB3 ALA A  75      54.084  26.663  71.046  1.00  0.00           H  
ATOM   1111  N   ASN A  76      51.827  25.417  71.468  1.00  0.00           N  
ATOM   1112  CA  ASN A  76      50.920  24.238  71.549  1.00  0.00           C  
ATOM   1113  C   ASN A  76      50.882  23.721  72.990  1.00  0.00           C  
ATOM   1114  O   ASN A  76      50.162  22.795  73.307  1.00  0.00           O  
ATOM   1115  CB  ASN A  76      51.438  23.132  70.627  1.00  0.00           C  
ATOM   1116  CG  ASN A  76      51.159  23.509  69.172  1.00  0.00           C  
ATOM   1117  OD1 ASN A  76      50.491  24.488  68.902  1.00  0.00           O  
ATOM   1118  ND2 ASN A  76      51.647  22.769  68.213  1.00  0.00           N  
ATOM   1119  H   ASN A  76      52.754  25.303  71.170  1.00  0.00           H  
ATOM   1120  HA  ASN A  76      49.925  24.526  71.243  1.00  0.00           H  
ATOM   1121  HB2 ASN A  76      52.502  23.012  70.771  1.00  0.00           H  
ATOM   1122  HB3 ASN A  76      50.935  22.205  70.858  1.00  0.00           H  
ATOM   1123 HD21 ASN A  76      52.187  21.981  68.430  1.00  0.00           H  
ATOM   1124 HD22 ASN A  76      51.474  23.003  67.277  1.00  0.00           H  
ATOM   1125  N   GLU A  77      51.652  24.309  73.865  1.00  0.00           N  
ATOM   1126  CA  GLU A  77      51.663  23.848  75.277  1.00  0.00           C  
ATOM   1127  C   GLU A  77      50.894  24.840  76.147  1.00  0.00           C  
ATOM   1128  O   GLU A  77      50.144  25.662  75.660  1.00  0.00           O  
ATOM   1129  CB  GLU A  77      53.107  23.769  75.765  1.00  0.00           C  
ATOM   1130  CG  GLU A  77      53.543  22.307  75.852  1.00  0.00           C  
ATOM   1131  CD  GLU A  77      55.056  22.211  75.656  1.00  0.00           C  
ATOM   1132  OE1 GLU A  77      55.571  22.922  74.807  1.00  0.00           O  
ATOM   1133  OE2 GLU A  77      55.677  21.428  76.357  1.00  0.00           O  
ATOM   1134  H   GLU A  77      52.230  25.051  73.593  1.00  0.00           H  
ATOM   1135  HA  GLU A  77      51.205  22.873  75.345  1.00  0.00           H  
ATOM   1136  HB2 GLU A  77      53.746  24.295  75.076  1.00  0.00           H  
ATOM   1137  HB3 GLU A  77      53.183  24.225  76.736  1.00  0.00           H  
ATOM   1138  HG2 GLU A  77      53.280  21.911  76.822  1.00  0.00           H  
ATOM   1139  HG3 GLU A  77      53.045  21.737  75.082  1.00  0.00           H  
ATOM   1140  N   ALA A  78      51.082  24.769  77.434  1.00  0.00           N  
ATOM   1141  CA  ALA A  78      50.370  25.707  78.349  1.00  0.00           C  
ATOM   1142  C   ALA A  78      50.736  25.382  79.799  1.00  0.00           C  
ATOM   1143  O   ALA A  78      51.291  24.342  80.091  1.00  0.00           O  
ATOM   1144  CB  ALA A  78      48.860  25.557  78.160  1.00  0.00           C  
ATOM   1145  H   ALA A  78      51.695  24.099  77.799  1.00  0.00           H  
ATOM   1146  HA  ALA A  78      50.663  26.722  78.122  1.00  0.00           H  
ATOM   1147  HB1 ALA A  78      48.623  25.598  77.108  1.00  0.00           H  
ATOM   1148  HB2 ALA A  78      48.540  24.608  78.564  1.00  0.00           H  
ATOM   1149  HB3 ALA A  78      48.352  26.358  78.676  1.00  0.00           H  
ATOM   1150  N   ALA A  79      50.426  26.264  80.709  1.00  0.00           N  
ATOM   1151  CA  ALA A  79      50.747  26.009  82.142  1.00  0.00           C  
ATOM   1152  C   ALA A  79      49.713  26.718  83.017  1.00  0.00           C  
ATOM   1153  O   ALA A  79      49.307  27.826  82.731  1.00  0.00           O  
ATOM   1154  CB  ALA A  79      52.141  26.553  82.462  1.00  0.00           C  
ATOM   1155  H   ALA A  79      49.977  27.096  80.450  1.00  0.00           H  
ATOM   1156  HA  ALA A  79      50.721  24.948  82.336  1.00  0.00           H  
ATOM   1157  HB1 ALA A  79      52.231  27.559  82.081  1.00  0.00           H  
ATOM   1158  HB2 ALA A  79      52.289  26.558  83.531  1.00  0.00           H  
ATOM   1159  HB3 ALA A  79      52.886  25.924  81.998  1.00  0.00           H  
ATOM   1160  N   PHE A  80      49.278  26.099  84.080  1.00  0.00           N  
ATOM   1161  CA  PHE A  80      48.271  26.767  84.949  1.00  0.00           C  
ATOM   1162  C   PHE A  80      48.433  26.296  86.389  1.00  0.00           C  
ATOM   1163  O   PHE A  80      49.153  25.362  86.673  1.00  0.00           O  
ATOM   1164  CB  PHE A  80      46.861  26.438  84.450  1.00  0.00           C  
ATOM   1165  CG  PHE A  80      46.539  24.984  84.730  1.00  0.00           C  
ATOM   1166  CD1 PHE A  80      45.970  24.611  85.956  1.00  0.00           C  
ATOM   1167  CD2 PHE A  80      46.802  24.010  83.759  1.00  0.00           C  
ATOM   1168  CE1 PHE A  80      45.667  23.264  86.208  1.00  0.00           C  
ATOM   1169  CE2 PHE A  80      46.498  22.666  84.010  1.00  0.00           C  
ATOM   1170  CZ  PHE A  80      45.931  22.292  85.234  1.00  0.00           C  
ATOM   1171  H   PHE A  80      49.609  25.204  84.306  1.00  0.00           H  
ATOM   1172  HA  PHE A  80      48.421  27.835  84.910  1.00  0.00           H  
ATOM   1173  HB2 PHE A  80      46.147  27.071  84.952  1.00  0.00           H  
ATOM   1174  HB3 PHE A  80      46.809  26.615  83.388  1.00  0.00           H  
ATOM   1175  HD1 PHE A  80      45.766  25.360  86.708  1.00  0.00           H  
ATOM   1176  HD2 PHE A  80      47.240  24.297  82.814  1.00  0.00           H  
ATOM   1177  HE1 PHE A  80      45.229  22.977  87.153  1.00  0.00           H  
ATOM   1178  HE2 PHE A  80      46.703  21.917  83.259  1.00  0.00           H  
ATOM   1179  HZ  PHE A  80      45.696  21.251  85.427  1.00  0.00           H  
ATOM   1180  N   ALA A  81      47.771  26.947  87.303  1.00  0.00           N  
ATOM   1181  CA  ALA A  81      47.886  26.551  88.732  1.00  0.00           C  
ATOM   1182  C   ALA A  81      46.524  26.686  89.411  1.00  0.00           C  
ATOM   1183  O   ALA A  81      45.530  26.994  88.783  1.00  0.00           O  
ATOM   1184  CB  ALA A  81      48.891  27.465  89.433  1.00  0.00           C  
ATOM   1185  H   ALA A  81      47.199  27.701  87.047  1.00  0.00           H  
ATOM   1186  HA  ALA A  81      48.222  25.526  88.797  1.00  0.00           H  
ATOM   1187  HB1 ALA A  81      49.681  27.729  88.746  1.00  0.00           H  
ATOM   1188  HB2 ALA A  81      48.391  28.362  89.767  1.00  0.00           H  
ATOM   1189  HB3 ALA A  81      49.312  26.952  90.284  1.00  0.00           H  
ATOM   1190  N   PHE A  82      46.474  26.464  90.694  1.00  0.00           N  
ATOM   1191  CA  PHE A  82      45.183  26.584  91.424  1.00  0.00           C  
ATOM   1192  C   PHE A  82      45.392  26.203  92.884  1.00  0.00           C  
ATOM   1193  O   PHE A  82      46.493  26.226  93.396  1.00  0.00           O  
ATOM   1194  CB  PHE A  82      44.146  25.646  90.806  1.00  0.00           C  
ATOM   1195  CG  PHE A  82      44.581  24.212  90.992  1.00  0.00           C  
ATOM   1196  CD1 PHE A  82      45.688  23.718  90.291  1.00  0.00           C  
ATOM   1197  CD2 PHE A  82      43.875  23.376  91.865  1.00  0.00           C  
ATOM   1198  CE1 PHE A  82      46.088  22.388  90.463  1.00  0.00           C  
ATOM   1199  CE2 PHE A  82      44.275  22.045  92.036  1.00  0.00           C  
ATOM   1200  CZ  PHE A  82      45.382  21.551  91.335  1.00  0.00           C  
ATOM   1201  H   PHE A  82      47.291  26.221  91.179  1.00  0.00           H  
ATOM   1202  HA  PHE A  82      44.829  27.601  91.366  1.00  0.00           H  
ATOM   1203  HB2 PHE A  82      43.191  25.799  91.288  1.00  0.00           H  
ATOM   1204  HB3 PHE A  82      44.051  25.859  89.758  1.00  0.00           H  
ATOM   1205  HD1 PHE A  82      46.233  24.364  89.618  1.00  0.00           H  
ATOM   1206  HD2 PHE A  82      43.021  23.756  92.405  1.00  0.00           H  
ATOM   1207  HE1 PHE A  82      46.942  22.007  89.922  1.00  0.00           H  
ATOM   1208  HE2 PHE A  82      43.730  21.399  92.709  1.00  0.00           H  
ATOM   1209  HZ  PHE A  82      45.690  20.525  91.468  1.00  0.00           H  
ATOM   1210  N   THR A  83      44.338  25.853  93.555  1.00  0.00           N  
ATOM   1211  CA  THR A  83      44.459  25.468  94.984  1.00  0.00           C  
ATOM   1212  C   THR A  83      43.590  24.246  95.263  1.00  0.00           C  
ATOM   1213  O   THR A  83      42.583  24.025  94.620  1.00  0.00           O  
ATOM   1214  CB  THR A  83      43.996  26.629  95.860  1.00  0.00           C  
ATOM   1215  OG1 THR A  83      43.292  27.571  95.062  1.00  0.00           O  
ATOM   1216  CG2 THR A  83      45.214  27.296  96.491  1.00  0.00           C  
ATOM   1217  H   THR A  83      43.463  25.845  93.116  1.00  0.00           H  
ATOM   1218  HA  THR A  83      45.489  25.237  95.209  1.00  0.00           H  
ATOM   1219  HB  THR A  83      43.349  26.258  96.640  1.00  0.00           H  
ATOM   1220  HG1 THR A  83      43.104  28.339  95.607  1.00  0.00           H  
ATOM   1221 HG21 THR A  83      46.068  27.162  95.844  1.00  0.00           H  
ATOM   1222 HG22 THR A  83      45.020  28.348  96.619  1.00  0.00           H  
ATOM   1223 HG23 THR A  83      45.414  26.842  97.450  1.00  0.00           H  
ATOM   1224  N   VAL A  84      43.968  23.453  96.225  1.00  0.00           N  
ATOM   1225  CA  VAL A  84      43.159  22.247  96.554  1.00  0.00           C  
ATOM   1226  C   VAL A  84      42.730  22.317  98.020  1.00  0.00           C  
ATOM   1227  O   VAL A  84      43.549  22.443  98.906  1.00  0.00           O  
ATOM   1228  CB  VAL A  84      43.984  20.974  96.330  1.00  0.00           C  
ATOM   1229  CG1 VAL A  84      43.091  19.900  95.716  1.00  0.00           C  
ATOM   1230  CG2 VAL A  84      45.149  21.257  95.379  1.00  0.00           C  
ATOM   1231  H   VAL A  84      44.782  23.655  96.735  1.00  0.00           H  
ATOM   1232  HA  VAL A  84      42.281  22.221  95.924  1.00  0.00           H  
ATOM   1233  HB  VAL A  84      44.368  20.623  97.278  1.00  0.00           H  
ATOM   1234 HG11 VAL A  84      42.194  19.804  96.304  1.00  0.00           H  
ATOM   1235 HG12 VAL A  84      42.832  20.180  94.707  1.00  0.00           H  
ATOM   1236 HG13 VAL A  84      43.617  18.956  95.703  1.00  0.00           H  
ATOM   1237 HG21 VAL A  84      45.768  22.039  95.792  1.00  0.00           H  
ATOM   1238 HG22 VAL A  84      45.737  20.360  95.255  1.00  0.00           H  
ATOM   1239 HG23 VAL A  84      44.762  21.570  94.421  1.00  0.00           H  
ATOM   1240  N   SER A  85      41.454  22.239  98.283  1.00  0.00           N  
ATOM   1241  CA  SER A  85      40.984  22.305  99.695  1.00  0.00           C  
ATOM   1242  C   SER A  85      40.352  20.970 100.087  1.00  0.00           C  
ATOM   1243  O   SER A  85      39.176  20.743  99.885  1.00  0.00           O  
ATOM   1244  CB  SER A  85      39.951  23.422  99.842  1.00  0.00           C  
ATOM   1245  OG  SER A  85      39.057  23.383  98.738  1.00  0.00           O  
ATOM   1246  H   SER A  85      40.808  22.139  97.553  1.00  0.00           H  
ATOM   1247  HA  SER A  85      41.824  22.504 100.342  1.00  0.00           H  
ATOM   1248  HB2 SER A  85      39.395  23.282 100.754  1.00  0.00           H  
ATOM   1249  HB3 SER A  85      40.458  24.378  99.875  1.00  0.00           H  
ATOM   1250  HG  SER A  85      38.715  24.270  98.602  1.00  0.00           H  
ATOM   1251  N   PHE A  86      41.126  20.086 100.654  1.00  0.00           N  
ATOM   1252  CA  PHE A  86      40.573  18.768 101.067  1.00  0.00           C  
ATOM   1253  C   PHE A  86      40.650  18.648 102.592  1.00  0.00           C  
ATOM   1254  O   PHE A  86      41.134  19.535 103.266  1.00  0.00           O  
ATOM   1255  CB  PHE A  86      41.383  17.650 100.409  1.00  0.00           C  
ATOM   1256  CG  PHE A  86      42.744  17.554 101.057  1.00  0.00           C  
ATOM   1257  CD1 PHE A  86      43.719  18.518 100.776  1.00  0.00           C  
ATOM   1258  CD2 PHE A  86      43.029  16.504 101.936  1.00  0.00           C  
ATOM   1259  CE1 PHE A  86      44.982  18.432 101.377  1.00  0.00           C  
ATOM   1260  CE2 PHE A  86      44.292  16.417 102.536  1.00  0.00           C  
ATOM   1261  CZ  PHE A  86      45.268  17.381 102.257  1.00  0.00           C  
ATOM   1262  H   PHE A  86      42.070  20.292 100.812  1.00  0.00           H  
ATOM   1263  HA  PHE A  86      39.542  18.698 100.753  1.00  0.00           H  
ATOM   1264  HB2 PHE A  86      40.860  16.714 100.524  1.00  0.00           H  
ATOM   1265  HB3 PHE A  86      41.502  17.864  99.359  1.00  0.00           H  
ATOM   1266  HD1 PHE A  86      43.500  19.327 100.095  1.00  0.00           H  
ATOM   1267  HD2 PHE A  86      42.276  15.760 102.151  1.00  0.00           H  
ATOM   1268  HE1 PHE A  86      45.735  19.175 101.161  1.00  0.00           H  
ATOM   1269  HE2 PHE A  86      44.512  15.606 103.216  1.00  0.00           H  
ATOM   1270  HZ  PHE A  86      46.241  17.314 102.721  1.00  0.00           H  
ATOM   1271  N   GLU A  87      40.170  17.567 103.144  1.00  0.00           N  
ATOM   1272  CA  GLU A  87      40.210  17.412 104.627  1.00  0.00           C  
ATOM   1273  C   GLU A  87      41.267  16.377 105.020  1.00  0.00           C  
ATOM   1274  O   GLU A  87      41.767  15.638 104.195  1.00  0.00           O  
ATOM   1275  CB  GLU A  87      38.839  16.950 105.125  1.00  0.00           C  
ATOM   1276  CG  GLU A  87      38.880  16.771 106.644  1.00  0.00           C  
ATOM   1277  CD  GLU A  87      37.454  16.653 107.183  1.00  0.00           C  
ATOM   1278  OE1 GLU A  87      36.871  17.680 107.492  1.00  0.00           O  
ATOM   1279  OE2 GLU A  87      36.968  15.538 107.277  1.00  0.00           O  
ATOM   1280  H   GLU A  87      39.775  16.864 102.587  1.00  0.00           H  
ATOM   1281  HA  GLU A  87      40.453  18.361 105.079  1.00  0.00           H  
ATOM   1282  HB2 GLU A  87      38.094  17.690 104.868  1.00  0.00           H  
ATOM   1283  HB3 GLU A  87      38.586  16.008 104.661  1.00  0.00           H  
ATOM   1284  HG2 GLU A  87      39.434  15.876 106.888  1.00  0.00           H  
ATOM   1285  HG3 GLU A  87      39.362  17.626 107.094  1.00  0.00           H  
ATOM   1286  N   PHE A  88      41.607  16.317 106.281  1.00  0.00           N  
ATOM   1287  CA  PHE A  88      42.627  15.331 106.735  1.00  0.00           C  
ATOM   1288  C   PHE A  88      41.981  14.345 107.712  1.00  0.00           C  
ATOM   1289  O   PHE A  88      40.775  14.205 107.760  1.00  0.00           O  
ATOM   1290  CB  PHE A  88      43.770  16.063 107.434  1.00  0.00           C  
ATOM   1291  CG  PHE A  88      45.076  15.749 106.741  1.00  0.00           C  
ATOM   1292  CD1 PHE A  88      45.296  14.475 106.205  1.00  0.00           C  
ATOM   1293  CD2 PHE A  88      46.066  16.734 106.637  1.00  0.00           C  
ATOM   1294  CE1 PHE A  88      46.507  14.185 105.564  1.00  0.00           C  
ATOM   1295  CE2 PHE A  88      47.277  16.443 105.997  1.00  0.00           C  
ATOM   1296  CZ  PHE A  88      47.497  15.169 105.460  1.00  0.00           C  
ATOM   1297  H   PHE A  88      41.190  16.922 106.929  1.00  0.00           H  
ATOM   1298  HA  PHE A  88      43.012  14.795 105.886  1.00  0.00           H  
ATOM   1299  HB2 PHE A  88      43.590  17.126 107.398  1.00  0.00           H  
ATOM   1300  HB3 PHE A  88      43.824  15.742 108.461  1.00  0.00           H  
ATOM   1301  HD1 PHE A  88      44.532  13.716 106.285  1.00  0.00           H  
ATOM   1302  HD2 PHE A  88      45.895  17.716 107.050  1.00  0.00           H  
ATOM   1303  HE1 PHE A  88      46.676  13.202 105.150  1.00  0.00           H  
ATOM   1304  HE2 PHE A  88      48.040  17.203 105.917  1.00  0.00           H  
ATOM   1305  HZ  PHE A  88      48.432  14.946 104.967  1.00  0.00           H  
ATOM   1306  N   GLN A  89      42.774  13.658 108.488  1.00  0.00           N  
ATOM   1307  CA  GLN A  89      42.204  12.680 109.458  1.00  0.00           C  
ATOM   1308  C   GLN A  89      41.434  13.423 110.551  1.00  0.00           C  
ATOM   1309  O   GLN A  89      40.774  12.822 111.376  1.00  0.00           O  
ATOM   1310  CB  GLN A  89      43.334  11.871 110.093  1.00  0.00           C  
ATOM   1311  CG  GLN A  89      44.430  12.829 110.540  1.00  0.00           C  
ATOM   1312  CD  GLN A  89      45.755  12.440 109.879  1.00  0.00           C  
ATOM   1313  OE1 GLN A  89      45.875  11.371 109.315  1.00  0.00           O  
ATOM   1314  NE2 GLN A  89      46.762  13.268 109.926  1.00  0.00           N  
ATOM   1315  H   GLN A  89      43.744  13.784 108.431  1.00  0.00           H  
ATOM   1316  HA  GLN A  89      41.538  12.015 108.942  1.00  0.00           H  
ATOM   1317  HB2 GLN A  89      42.956  11.328 110.947  1.00  0.00           H  
ATOM   1318  HB3 GLN A  89      43.736  11.178 109.369  1.00  0.00           H  
ATOM   1319  HG2 GLN A  89      44.158  13.830 110.245  1.00  0.00           H  
ATOM   1320  HG3 GLN A  89      44.536  12.783 111.613  1.00  0.00           H  
ATOM   1321 HE21 GLN A  89      46.667  14.130 110.382  1.00  0.00           H  
ATOM   1322 HE22 GLN A  89      47.614  13.028 109.506  1.00  0.00           H  
ATOM   1323  N   GLY A  90      41.511  14.726 110.569  1.00  0.00           N  
ATOM   1324  CA  GLY A  90      40.779  15.497 111.615  1.00  0.00           C  
ATOM   1325  C   GLY A  90      40.822  16.991 111.282  1.00  0.00           C  
ATOM   1326  O   GLY A  90      39.850  17.701 111.446  1.00  0.00           O  
ATOM   1327  H   GLY A  90      42.047  15.196 109.897  1.00  0.00           H  
ATOM   1328  HA2 GLY A  90      39.751  15.165 111.653  1.00  0.00           H  
ATOM   1329  HA3 GLY A  90      41.245  15.333 112.574  1.00  0.00           H  
ATOM   1330  N   ARG A  91      41.942  17.474 110.818  1.00  0.00           N  
ATOM   1331  CA  ARG A  91      42.044  18.923 110.478  1.00  0.00           C  
ATOM   1332  C   ARG A  91      41.785  19.118 108.983  1.00  0.00           C  
ATOM   1333  O   ARG A  91      41.487  18.184 108.266  1.00  0.00           O  
ATOM   1334  CB  ARG A  91      43.446  19.429 110.819  1.00  0.00           C  
ATOM   1335  CG  ARG A  91      43.446  20.027 112.227  1.00  0.00           C  
ATOM   1336  CD  ARG A  91      44.800  20.685 112.501  1.00  0.00           C  
ATOM   1337  NE  ARG A  91      45.073  20.673 113.966  1.00  0.00           N  
ATOM   1338  CZ  ARG A  91      44.195  21.165 114.797  1.00  0.00           C  
ATOM   1339  NH1 ARG A  91      44.171  22.447 115.041  1.00  0.00           N  
ATOM   1340  NH2 ARG A  91      43.339  20.374 115.386  1.00  0.00           N  
ATOM   1341  H   ARG A  91      42.717  16.887 110.694  1.00  0.00           H  
ATOM   1342  HA  ARG A  91      41.313  19.478 111.046  1.00  0.00           H  
ATOM   1343  HB2 ARG A  91      44.145  18.606 110.776  1.00  0.00           H  
ATOM   1344  HB3 ARG A  91      43.738  20.187 110.109  1.00  0.00           H  
ATOM   1345  HG2 ARG A  91      42.662  20.766 112.304  1.00  0.00           H  
ATOM   1346  HG3 ARG A  91      43.276  19.244 112.952  1.00  0.00           H  
ATOM   1347  HD2 ARG A  91      45.576  20.140 111.986  1.00  0.00           H  
ATOM   1348  HD3 ARG A  91      44.781  21.705 112.146  1.00  0.00           H  
ATOM   1349  HE  ARG A  91      45.910  20.296 114.304  1.00  0.00           H  
ATOM   1350 HH11 ARG A  91      44.827  23.054 114.591  1.00  0.00           H  
ATOM   1351 HH12 ARG A  91      43.499  22.822 115.679  1.00  0.00           H  
ATOM   1352 HH21 ARG A  91      43.356  19.391 115.200  1.00  0.00           H  
ATOM   1353 HH22 ARG A  91      42.667  20.750 116.023  1.00  0.00           H  
ATOM   1354  N   LYS A  92      41.898  20.329 108.506  1.00  0.00           N  
ATOM   1355  CA  LYS A  92      41.660  20.587 107.057  1.00  0.00           C  
ATOM   1356  C   LYS A  92      42.960  21.067 106.405  1.00  0.00           C  
ATOM   1357  O   LYS A  92      43.589  21.998 106.866  1.00  0.00           O  
ATOM   1358  CB  LYS A  92      40.584  21.663 106.903  1.00  0.00           C  
ATOM   1359  CG  LYS A  92      41.129  23.005 107.393  1.00  0.00           C  
ATOM   1360  CD  LYS A  92      41.726  23.775 106.213  1.00  0.00           C  
ATOM   1361  CE  LYS A  92      41.049  25.144 106.101  1.00  0.00           C  
ATOM   1362  NZ  LYS A  92      42.081  26.035 105.503  1.00  0.00           N  
ATOM   1363  H   LYS A  92      42.140  21.069 109.102  1.00  0.00           H  
ATOM   1364  HA  LYS A  92      41.331  19.676 106.578  1.00  0.00           H  
ATOM   1365  HB2 LYS A  92      40.304  21.745 105.862  1.00  0.00           H  
ATOM   1366  HB3 LYS A  92      39.718  21.392 107.489  1.00  0.00           H  
ATOM   1367  HG2 LYS A  92      40.328  23.581 107.832  1.00  0.00           H  
ATOM   1368  HG3 LYS A  92      41.897  22.833 108.132  1.00  0.00           H  
ATOM   1369  HD2 LYS A  92      42.786  23.909 106.369  1.00  0.00           H  
ATOM   1370  HD3 LYS A  92      41.561  23.220 105.301  1.00  0.00           H  
ATOM   1371  HE2 LYS A  92      40.182  25.082 105.457  1.00  0.00           H  
ATOM   1372  HE3 LYS A  92      40.769  25.507 107.078  1.00  0.00           H  
ATOM   1373  HZ1 LYS A  92      43.020  25.767 105.862  1.00  0.00           H  
ATOM   1374  HZ2 LYS A  92      42.064  25.938 104.467  1.00  0.00           H  
ATOM   1375  HZ3 LYS A  92      41.879  27.021 105.759  1.00  0.00           H  
ATOM   1376  N   THR A  93      43.370  20.434 105.339  1.00  0.00           N  
ATOM   1377  CA  THR A  93      44.630  20.850 104.663  1.00  0.00           C  
ATOM   1378  C   THR A  93      44.325  21.305 103.233  1.00  0.00           C  
ATOM   1379  O   THR A  93      43.487  20.742 102.557  1.00  0.00           O  
ATOM   1380  CB  THR A  93      45.587  19.660 104.620  1.00  0.00           C  
ATOM   1381  OG1 THR A  93      44.941  18.513 105.153  1.00  0.00           O  
ATOM   1382  CG2 THR A  93      46.829  19.980 105.447  1.00  0.00           C  
ATOM   1383  H   THR A  93      42.853  19.683 104.985  1.00  0.00           H  
ATOM   1384  HA  THR A  93      45.087  21.660 105.213  1.00  0.00           H  
ATOM   1385  HB  THR A  93      45.878  19.468 103.599  1.00  0.00           H  
ATOM   1386  HG1 THR A  93      44.665  18.718 106.049  1.00  0.00           H  
ATOM   1387 HG21 THR A  93      46.601  20.769 106.147  1.00  0.00           H  
ATOM   1388 HG22 THR A  93      47.138  19.097 105.988  1.00  0.00           H  
ATOM   1389 HG23 THR A  93      47.627  20.298 104.791  1.00  0.00           H  
ATOM   1390  N   VAL A  94      45.004  22.317 102.765  1.00  0.00           N  
ATOM   1391  CA  VAL A  94      44.765  22.806 101.385  1.00  0.00           C  
ATOM   1392  C   VAL A  94      46.053  22.596 100.568  1.00  0.00           C  
ATOM   1393  O   VAL A  94      47.066  22.181 101.096  1.00  0.00           O  
ATOM   1394  CB  VAL A  94      44.366  24.295 101.460  1.00  0.00           C  
ATOM   1395  CG1 VAL A  94      45.226  25.153 100.531  1.00  0.00           C  
ATOM   1396  CG2 VAL A  94      42.897  24.445 101.057  1.00  0.00           C  
ATOM   1397  H   VAL A  94      45.678  22.757 103.322  1.00  0.00           H  
ATOM   1398  HA  VAL A  94      43.962  22.238 100.940  1.00  0.00           H  
ATOM   1399  HB  VAL A  94      44.491  24.644 102.475  1.00  0.00           H  
ATOM   1400 HG11 VAL A  94      46.264  24.917 100.686  1.00  0.00           H  
ATOM   1401 HG12 VAL A  94      44.959  24.949  99.506  1.00  0.00           H  
ATOM   1402 HG13 VAL A  94      45.058  26.196 100.749  1.00  0.00           H  
ATOM   1403 HG21 VAL A  94      42.762  24.085 100.049  1.00  0.00           H  
ATOM   1404 HG22 VAL A  94      42.279  23.871 101.731  1.00  0.00           H  
ATOM   1405 HG23 VAL A  94      42.614  25.487 101.108  1.00  0.00           H  
ATOM   1406  N   VAL A  95      46.028  22.873  99.292  1.00  0.00           N  
ATOM   1407  CA  VAL A  95      47.259  22.677  98.470  1.00  0.00           C  
ATOM   1408  C   VAL A  95      47.334  23.757  97.384  1.00  0.00           C  
ATOM   1409  O   VAL A  95      46.333  24.181  96.842  1.00  0.00           O  
ATOM   1410  CB  VAL A  95      47.223  21.278  97.839  1.00  0.00           C  
ATOM   1411  CG1 VAL A  95      48.117  21.225  96.597  1.00  0.00           C  
ATOM   1412  CG2 VAL A  95      47.730  20.263  98.859  1.00  0.00           C  
ATOM   1413  H   VAL A  95      45.205  23.205  98.875  1.00  0.00           H  
ATOM   1414  HA  VAL A  95      48.126  22.756  99.108  1.00  0.00           H  
ATOM   1415  HB  VAL A  95      46.208  21.034  97.563  1.00  0.00           H  
ATOM   1416 HG11 VAL A  95      48.794  22.066  96.603  1.00  0.00           H  
ATOM   1417 HG12 VAL A  95      48.684  20.305  96.599  1.00  0.00           H  
ATOM   1418 HG13 VAL A  95      47.500  21.264  95.712  1.00  0.00           H  
ATOM   1419 HG21 VAL A  95      47.954  20.768  99.786  1.00  0.00           H  
ATOM   1420 HG22 VAL A  95      46.972  19.514  99.030  1.00  0.00           H  
ATOM   1421 HG23 VAL A  95      48.626  19.791  98.481  1.00  0.00           H  
ATOM   1422  N   ALA A  96      48.521  24.211  97.073  1.00  0.00           N  
ATOM   1423  CA  ALA A  96      48.665  25.274  96.030  1.00  0.00           C  
ATOM   1424  C   ALA A  96      49.777  24.907  95.043  1.00  0.00           C  
ATOM   1425  O   ALA A  96      50.831  25.510  95.049  1.00  0.00           O  
ATOM   1426  CB  ALA A  96      49.024  26.599  96.706  1.00  0.00           C  
ATOM   1427  H   ALA A  96      49.314  23.857  97.533  1.00  0.00           H  
ATOM   1428  HA  ALA A  96      47.732  25.386  95.498  1.00  0.00           H  
ATOM   1429  HB1 ALA A  96      49.952  26.485  97.248  1.00  0.00           H  
ATOM   1430  HB2 ALA A  96      49.138  27.366  95.954  1.00  0.00           H  
ATOM   1431  HB3 ALA A  96      48.238  26.879  97.390  1.00  0.00           H  
ATOM   1432  N   PRO A  97      49.506  23.928  94.223  1.00  0.00           N  
ATOM   1433  CA  PRO A  97      50.483  23.472  93.219  1.00  0.00           C  
ATOM   1434  C   PRO A  97      50.232  24.144  91.866  1.00  0.00           C  
ATOM   1435  O   PRO A  97      49.357  24.976  91.721  1.00  0.00           O  
ATOM   1436  CB  PRO A  97      50.179  21.981  93.123  1.00  0.00           C  
ATOM   1437  CG  PRO A  97      48.741  21.828  93.552  1.00  0.00           C  
ATOM   1438  CD  PRO A  97      48.282  23.144  94.149  1.00  0.00           C  
ATOM   1439  HA  PRO A  97      51.494  23.626  93.555  1.00  0.00           H  
ATOM   1440  HB2 PRO A  97      50.306  21.641  92.103  1.00  0.00           H  
ATOM   1441  HB3 PRO A  97      50.822  21.425  93.785  1.00  0.00           H  
ATOM   1442  HG2 PRO A  97      48.130  21.581  92.695  1.00  0.00           H  
ATOM   1443  HG3 PRO A  97      48.664  21.049  94.292  1.00  0.00           H  
ATOM   1444  HD2 PRO A  97      47.560  23.621  93.501  1.00  0.00           H  
ATOM   1445  HD3 PRO A  97      47.872  22.997  95.134  1.00  0.00           H  
ATOM   1446  N   ILE A  98      50.984  23.767  90.870  1.00  0.00           N  
ATOM   1447  CA  ILE A  98      50.791  24.347  89.511  1.00  0.00           C  
ATOM   1448  C   ILE A  98      50.893  23.214  88.488  1.00  0.00           C  
ATOM   1449  O   ILE A  98      51.715  22.330  88.616  1.00  0.00           O  
ATOM   1450  CB  ILE A  98      51.868  25.395  89.225  1.00  0.00           C  
ATOM   1451  CG1 ILE A  98      51.825  26.474  90.311  1.00  0.00           C  
ATOM   1452  CG2 ILE A  98      51.604  26.038  87.859  1.00  0.00           C  
ATOM   1453  CD1 ILE A  98      53.070  26.361  91.191  1.00  0.00           C  
ATOM   1454  H   ILE A  98      51.669  23.080  91.012  1.00  0.00           H  
ATOM   1455  HA  ILE A  98      49.814  24.803  89.450  1.00  0.00           H  
ATOM   1456  HB  ILE A  98      52.838  24.922  89.222  1.00  0.00           H  
ATOM   1457 HG12 ILE A  98      51.798  27.450  89.848  1.00  0.00           H  
ATOM   1458 HG13 ILE A  98      50.944  26.338  90.919  1.00  0.00           H  
ATOM   1459 HG21 ILE A  98      50.584  26.389  87.816  1.00  0.00           H  
ATOM   1460 HG22 ILE A  98      52.276  26.870  87.714  1.00  0.00           H  
ATOM   1461 HG23 ILE A  98      51.764  25.307  87.079  1.00  0.00           H  
ATOM   1462 HD11 ILE A  98      53.211  25.330  91.483  1.00  0.00           H  
ATOM   1463 HD12 ILE A  98      53.934  26.700  90.639  1.00  0.00           H  
ATOM   1464 HD13 ILE A  98      52.943  26.971  92.074  1.00  0.00           H  
ATOM   1465  N   ASP A  99      50.061  23.216  87.485  1.00  0.00           N  
ATOM   1466  CA  ASP A  99      50.117  22.122  86.484  1.00  0.00           C  
ATOM   1467  C   ASP A  99      50.600  22.660  85.139  1.00  0.00           C  
ATOM   1468  O   ASP A  99      50.584  23.850  84.887  1.00  0.00           O  
ATOM   1469  CB  ASP A  99      48.729  21.532  86.319  1.00  0.00           C  
ATOM   1470  CG  ASP A  99      48.838  20.045  85.974  1.00  0.00           C  
ATOM   1471  OD1 ASP A  99      49.911  19.493  86.147  1.00  0.00           O  
ATOM   1472  OD2 ASP A  99      47.706  19.419  85.488  1.00  0.00           O  
ATOM   1473  H   ASP A  99      49.392  23.927  87.394  1.00  0.00           H  
ATOM   1474  HA  ASP A  99      50.783  21.356  86.822  1.00  0.00           H  
ATOM   1475  HB2 ASP A  99      48.175  21.652  87.237  1.00  0.00           H  
ATOM   1476  HB3 ASP A  99      48.232  22.048  85.528  1.00  0.00           H  
ATOM   1477  HD2 ASP A  99      47.029  19.462  86.167  1.00  0.00           H  
ATOM   1478  N   HIS A 100      51.020  21.786  84.270  1.00  0.00           N  
ATOM   1479  CA  HIS A 100      51.496  22.225  82.931  1.00  0.00           C  
ATOM   1480  C   HIS A 100      50.570  21.643  81.869  1.00  0.00           C  
ATOM   1481  O   HIS A 100      49.651  20.909  82.173  1.00  0.00           O  
ATOM   1482  CB  HIS A 100      52.924  21.728  82.701  1.00  0.00           C  
ATOM   1483  CG  HIS A 100      53.665  22.714  81.840  1.00  0.00           C  
ATOM   1484  ND1 HIS A 100      53.811  22.538  80.474  1.00  0.00           N  
ATOM   1485  CD2 HIS A 100      54.304  23.891  82.138  1.00  0.00           C  
ATOM   1486  CE1 HIS A 100      54.513  23.585  80.003  1.00  0.00           C  
ATOM   1487  NE2 HIS A 100      54.839  24.440  80.976  1.00  0.00           N  
ATOM   1488  H   HIS A 100      51.014  20.832  84.498  1.00  0.00           H  
ATOM   1489  HA  HIS A 100      51.469  23.302  82.872  1.00  0.00           H  
ATOM   1490  HB2 HIS A 100      53.428  21.629  83.651  1.00  0.00           H  
ATOM   1491  HB3 HIS A 100      52.897  20.769  82.207  1.00  0.00           H  
ATOM   1492  HD1 HIS A 100      53.466  21.787  79.946  1.00  0.00           H  
ATOM   1493  HD2 HIS A 100      54.379  24.326  83.123  1.00  0.00           H  
ATOM   1494  HE1 HIS A 100      54.781  23.717  78.965  1.00  0.00           H  
ATOM   1495  N   PHE A 101      50.779  21.976  80.627  1.00  0.00           N  
ATOM   1496  CA  PHE A 101      49.882  21.450  79.577  1.00  0.00           C  
ATOM   1497  C   PHE A 101      50.634  21.300  78.253  1.00  0.00           C  
ATOM   1498  O   PHE A 101      51.466  22.112  77.901  1.00  0.00           O  
ATOM   1499  CB  PHE A 101      48.736  22.431  79.406  1.00  0.00           C  
ATOM   1500  CG  PHE A 101      47.447  21.758  79.798  1.00  0.00           C  
ATOM   1501  CD1 PHE A 101      47.169  20.466  79.342  1.00  0.00           C  
ATOM   1502  CD2 PHE A 101      46.534  22.421  80.626  1.00  0.00           C  
ATOM   1503  CE1 PHE A 101      45.975  19.834  79.712  1.00  0.00           C  
ATOM   1504  CE2 PHE A 101      45.340  21.791  80.996  1.00  0.00           C  
ATOM   1505  CZ  PHE A 101      45.060  20.498  80.539  1.00  0.00           C  
ATOM   1506  H   PHE A 101      51.505  22.585  80.390  1.00  0.00           H  
ATOM   1507  HA  PHE A 101      49.489  20.495  79.883  1.00  0.00           H  
ATOM   1508  HB2 PHE A 101      48.903  23.286  80.043  1.00  0.00           H  
ATOM   1509  HB3 PHE A 101      48.691  22.750  78.381  1.00  0.00           H  
ATOM   1510  HD1 PHE A 101      47.877  19.954  78.707  1.00  0.00           H  
ATOM   1511  HD2 PHE A 101      46.753  23.420  80.979  1.00  0.00           H  
ATOM   1512  HE1 PHE A 101      45.760  18.837  79.359  1.00  0.00           H  
ATOM   1513  HE2 PHE A 101      44.636  22.301  81.636  1.00  0.00           H  
ATOM   1514  HZ  PHE A 101      44.140  20.012  80.825  1.00  0.00           H  
ATOM   1515  N   ARG A 102      50.336  20.265  77.515  1.00  0.00           N  
ATOM   1516  CA  ARG A 102      51.017  20.051  76.206  1.00  0.00           C  
ATOM   1517  C   ARG A 102      49.975  19.653  75.158  1.00  0.00           C  
ATOM   1518  O   ARG A 102      49.453  18.557  75.175  1.00  0.00           O  
ATOM   1519  CB  ARG A 102      52.048  18.930  76.346  1.00  0.00           C  
ATOM   1520  CG  ARG A 102      53.393  19.395  75.788  1.00  0.00           C  
ATOM   1521  CD  ARG A 102      54.321  18.189  75.624  1.00  0.00           C  
ATOM   1522  NE  ARG A 102      54.764  17.722  76.968  1.00  0.00           N  
ATOM   1523  CZ  ARG A 102      55.627  16.750  77.071  1.00  0.00           C  
ATOM   1524  NH1 ARG A 102      55.749  15.879  76.106  1.00  0.00           N  
ATOM   1525  NH2 ARG A 102      56.366  16.648  78.141  1.00  0.00           N  
ATOM   1526  H   ARG A 102      49.657  19.627  77.822  1.00  0.00           H  
ATOM   1527  HA  ARG A 102      51.510  20.962  75.901  1.00  0.00           H  
ATOM   1528  HB2 ARG A 102      52.160  18.671  77.389  1.00  0.00           H  
ATOM   1529  HB3 ARG A 102      51.713  18.065  75.794  1.00  0.00           H  
ATOM   1530  HG2 ARG A 102      53.244  19.869  74.829  1.00  0.00           H  
ATOM   1531  HG3 ARG A 102      53.843  20.098  76.471  1.00  0.00           H  
ATOM   1532  HD2 ARG A 102      53.791  17.394  75.123  1.00  0.00           H  
ATOM   1533  HD3 ARG A 102      55.183  18.474  75.039  1.00  0.00           H  
ATOM   1534  HE  ARG A 102      54.407  18.149  77.776  1.00  0.00           H  
ATOM   1535 HH11 ARG A 102      55.182  15.959  75.286  1.00  0.00           H  
ATOM   1536 HH12 ARG A 102      56.410  15.133  76.186  1.00  0.00           H  
ATOM   1537 HH21 ARG A 102      56.272  17.315  78.880  1.00  0.00           H  
ATOM   1538 HH22 ARG A 102      57.027  15.902  78.223  1.00  0.00           H  
ATOM   1539  N   PHE A 103      49.664  20.536  74.249  1.00  0.00           N  
ATOM   1540  CA  PHE A 103      48.652  20.208  73.204  1.00  0.00           C  
ATOM   1541  C   PHE A 103      49.355  19.951  71.870  1.00  0.00           C  
ATOM   1542  O   PHE A 103      50.564  20.035  71.768  1.00  0.00           O  
ATOM   1543  CB  PHE A 103      47.684  21.383  73.053  1.00  0.00           C  
ATOM   1544  CG  PHE A 103      47.132  21.749  74.409  1.00  0.00           C  
ATOM   1545  CD1 PHE A 103      46.814  20.744  75.327  1.00  0.00           C  
ATOM   1546  CD2 PHE A 103      46.940  23.095  74.749  1.00  0.00           C  
ATOM   1547  CE1 PHE A 103      46.304  21.080  76.586  1.00  0.00           C  
ATOM   1548  CE2 PHE A 103      46.430  23.431  76.008  1.00  0.00           C  
ATOM   1549  CZ  PHE A 103      46.112  22.424  76.926  1.00  0.00           C  
ATOM   1550  H   PHE A 103      50.094  21.418  74.254  1.00  0.00           H  
ATOM   1551  HA  PHE A 103      48.101  19.326  73.500  1.00  0.00           H  
ATOM   1552  HB2 PHE A 103      48.208  22.230  72.635  1.00  0.00           H  
ATOM   1553  HB3 PHE A 103      46.873  21.101  72.400  1.00  0.00           H  
ATOM   1554  HD1 PHE A 103      46.962  19.706  75.065  1.00  0.00           H  
ATOM   1555  HD2 PHE A 103      47.187  23.871  74.040  1.00  0.00           H  
ATOM   1556  HE1 PHE A 103      46.057  20.303  77.293  1.00  0.00           H  
ATOM   1557  HE2 PHE A 103      46.282  24.468  76.271  1.00  0.00           H  
ATOM   1558  HZ  PHE A 103      45.719  22.684  77.897  1.00  0.00           H  
ATOM   1559  N   ASN A 104      48.610  19.639  70.844  1.00  0.00           N  
ATOM   1560  CA  ASN A 104      49.240  19.378  69.518  1.00  0.00           C  
ATOM   1561  C   ASN A 104      48.573  20.251  68.452  1.00  0.00           C  
ATOM   1562  O   ASN A 104      48.935  20.212  67.292  1.00  0.00           O  
ATOM   1563  CB  ASN A 104      49.065  17.903  69.148  1.00  0.00           C  
ATOM   1564  CG  ASN A 104      47.585  17.612  68.892  1.00  0.00           C  
ATOM   1565  OD1 ASN A 104      47.163  17.494  67.760  1.00  0.00           O  
ATOM   1566  ND2 ASN A 104      46.772  17.491  69.907  1.00  0.00           N  
ATOM   1567  H   ASN A 104      47.638  19.576  70.945  1.00  0.00           H  
ATOM   1568  HA  ASN A 104      50.293  19.613  69.568  1.00  0.00           H  
ATOM   1569  HB2 ASN A 104      49.634  17.686  68.256  1.00  0.00           H  
ATOM   1570  HB3 ASN A 104      49.416  17.283  69.958  1.00  0.00           H  
ATOM   1571 HD21 ASN A 104      47.111  17.586  70.821  1.00  0.00           H  
ATOM   1572 HD22 ASN A 104      45.821  17.305  69.753  1.00  0.00           H  
ATOM   1573  N   GLY A 105      47.603  21.036  68.831  1.00  0.00           N  
ATOM   1574  CA  GLY A 105      46.919  21.905  67.830  1.00  0.00           C  
ATOM   1575  C   GLY A 105      45.905  22.807  68.535  1.00  0.00           C  
ATOM   1576  O   GLY A 105      46.208  23.920  68.915  1.00  0.00           O  
ATOM   1577  H   GLY A 105      47.322  21.055  69.769  1.00  0.00           H  
ATOM   1578  HA2 GLY A 105      47.653  22.516  67.323  1.00  0.00           H  
ATOM   1579  HA3 GLY A 105      46.405  21.288  67.110  1.00  0.00           H  
ATOM   1580  N   ALA A 106      44.700  22.336  68.714  1.00  0.00           N  
ATOM   1581  CA  ALA A 106      43.670  23.170  69.393  1.00  0.00           C  
ATOM   1582  C   ALA A 106      42.329  22.432  69.390  1.00  0.00           C  
ATOM   1583  O   ALA A 106      41.281  23.033  69.268  1.00  0.00           O  
ATOM   1584  CB  ALA A 106      43.522  24.499  68.651  1.00  0.00           C  
ATOM   1585  H   ALA A 106      44.474  21.436  68.401  1.00  0.00           H  
ATOM   1586  HA  ALA A 106      43.975  23.357  70.411  1.00  0.00           H  
ATOM   1587  HB1 ALA A 106      44.011  24.431  67.691  1.00  0.00           H  
ATOM   1588  HB2 ALA A 106      42.474  24.716  68.507  1.00  0.00           H  
ATOM   1589  HB3 ALA A 106      43.976  25.287  69.233  1.00  0.00           H  
ATOM   1590  N   GLY A 107      42.353  21.135  69.525  1.00  0.00           N  
ATOM   1591  CA  GLY A 107      41.079  20.364  69.530  1.00  0.00           C  
ATOM   1592  C   GLY A 107      41.028  19.472  70.771  1.00  0.00           C  
ATOM   1593  O   GLY A 107      39.989  19.282  71.372  1.00  0.00           O  
ATOM   1594  H   GLY A 107      43.210  20.669  69.623  1.00  0.00           H  
ATOM   1595  HA2 GLY A 107      40.243  21.050  69.545  1.00  0.00           H  
ATOM   1596  HA3 GLY A 107      41.026  19.748  68.647  1.00  0.00           H  
ATOM   1597  N   LYS A 108      42.146  18.923  71.161  1.00  0.00           N  
ATOM   1598  CA  LYS A 108      42.164  18.044  72.363  1.00  0.00           C  
ATOM   1599  C   LYS A 108      43.504  18.201  73.082  1.00  0.00           C  
ATOM   1600  O   LYS A 108      44.247  19.130  72.833  1.00  0.00           O  
ATOM   1601  CB  LYS A 108      41.983  16.586  71.934  1.00  0.00           C  
ATOM   1602  CG  LYS A 108      41.095  16.524  70.690  1.00  0.00           C  
ATOM   1603  CD  LYS A 108      40.553  15.103  70.521  1.00  0.00           C  
ATOM   1604  CE  LYS A 108      41.557  14.264  69.727  1.00  0.00           C  
ATOM   1605  NZ  LYS A 108      41.717  14.979  68.431  1.00  0.00           N  
ATOM   1606  H   LYS A 108      42.972  19.090  70.663  1.00  0.00           H  
ATOM   1607  HA  LYS A 108      41.362  18.327  73.029  1.00  0.00           H  
ATOM   1608  HB2 LYS A 108      42.949  16.155  71.710  1.00  0.00           H  
ATOM   1609  HB3 LYS A 108      41.517  16.031  72.735  1.00  0.00           H  
ATOM   1610  HG2 LYS A 108      40.271  17.214  70.802  1.00  0.00           H  
ATOM   1611  HG3 LYS A 108      41.675  16.791  69.820  1.00  0.00           H  
ATOM   1612  HD2 LYS A 108      40.399  14.659  71.493  1.00  0.00           H  
ATOM   1613  HD3 LYS A 108      39.614  15.137  69.987  1.00  0.00           H  
ATOM   1614  HE2 LYS A 108      42.502  14.216  70.253  1.00  0.00           H  
ATOM   1615  HE3 LYS A 108      41.168  13.272  69.557  1.00  0.00           H  
ATOM   1616  HZ1 LYS A 108      40.837  15.485  68.203  1.00  0.00           H  
ATOM   1617  HZ2 LYS A 108      42.500  15.661  68.506  1.00  0.00           H  
ATOM   1618  HZ3 LYS A 108      41.925  14.293  67.679  1.00  0.00           H  
ATOM   1619  N   VAL A 109      43.821  17.299  73.969  1.00  0.00           N  
ATOM   1620  CA  VAL A 109      45.114  17.398  74.699  1.00  0.00           C  
ATOM   1621  C   VAL A 109      45.993  16.204  74.320  1.00  0.00           C  
ATOM   1622  O   VAL A 109      45.509  15.187  73.864  1.00  0.00           O  
ATOM   1623  CB  VAL A 109      44.849  17.379  76.204  1.00  0.00           C  
ATOM   1624  CG1 VAL A 109      46.178  17.406  76.959  1.00  0.00           C  
ATOM   1625  CG2 VAL A 109      44.020  18.606  76.587  1.00  0.00           C  
ATOM   1626  H   VAL A 109      43.209  16.556  74.154  1.00  0.00           H  
ATOM   1627  HA  VAL A 109      45.612  18.321  74.430  1.00  0.00           H  
ATOM   1628  HB  VAL A 109      44.306  16.481  76.462  1.00  0.00           H  
ATOM   1629 HG11 VAL A 109      46.773  18.238  76.612  1.00  0.00           H  
ATOM   1630 HG12 VAL A 109      45.990  17.514  78.017  1.00  0.00           H  
ATOM   1631 HG13 VAL A 109      46.712  16.483  76.780  1.00  0.00           H  
ATOM   1632 HG21 VAL A 109      44.496  19.497  76.205  1.00  0.00           H  
ATOM   1633 HG22 VAL A 109      43.030  18.518  76.163  1.00  0.00           H  
ATOM   1634 HG23 VAL A 109      43.946  18.670  77.662  1.00  0.00           H  
ATOM   1635  N   VAL A 110      47.281  16.313  74.504  1.00  0.00           N  
ATOM   1636  CA  VAL A 110      48.178  15.176  74.150  1.00  0.00           C  
ATOM   1637  C   VAL A 110      49.151  14.914  75.300  1.00  0.00           C  
ATOM   1638  O   VAL A 110      49.250  13.815  75.802  1.00  0.00           O  
ATOM   1639  CB  VAL A 110      48.961  15.510  72.879  1.00  0.00           C  
ATOM   1640  CG1 VAL A 110      48.167  15.046  71.658  1.00  0.00           C  
ATOM   1641  CG2 VAL A 110      49.190  17.023  72.792  1.00  0.00           C  
ATOM   1642  H   VAL A 110      47.657  17.139  74.874  1.00  0.00           H  
ATOM   1643  HA  VAL A 110      47.581  14.291  73.981  1.00  0.00           H  
ATOM   1644  HB  VAL A 110      49.914  15.001  72.901  1.00  0.00           H  
ATOM   1645 HG11 VAL A 110      47.881  14.012  71.786  1.00  0.00           H  
ATOM   1646 HG12 VAL A 110      47.280  15.653  71.555  1.00  0.00           H  
ATOM   1647 HG13 VAL A 110      48.776  15.145  70.773  1.00  0.00           H  
ATOM   1648 HG21 VAL A 110      48.257  17.539  72.966  1.00  0.00           H  
ATOM   1649 HG22 VAL A 110      49.911  17.322  73.537  1.00  0.00           H  
ATOM   1650 HG23 VAL A 110      49.561  17.274  71.811  1.00  0.00           H  
ATOM   1651  N   SER A 111      49.868  15.913  75.726  1.00  0.00           N  
ATOM   1652  CA  SER A 111      50.826  15.711  76.847  1.00  0.00           C  
ATOM   1653  C   SER A 111      50.554  16.753  77.929  1.00  0.00           C  
ATOM   1654  O   SER A 111      49.992  17.798  77.667  1.00  0.00           O  
ATOM   1655  CB  SER A 111      52.258  15.863  76.334  1.00  0.00           C  
ATOM   1656  OG  SER A 111      52.237  15.996  74.919  1.00  0.00           O  
ATOM   1657  H   SER A 111      49.775  16.797  75.313  1.00  0.00           H  
ATOM   1658  HA  SER A 111      50.693  14.721  77.259  1.00  0.00           H  
ATOM   1659  HB2 SER A 111      52.707  16.740  76.767  1.00  0.00           H  
ATOM   1660  HB3 SER A 111      52.835  14.993  76.615  1.00  0.00           H  
ATOM   1661  HG  SER A 111      51.794  15.225  74.555  1.00  0.00           H  
ATOM   1662  N   MET A 112      50.941  16.482  79.143  1.00  0.00           N  
ATOM   1663  CA  MET A 112      50.693  17.465  80.232  1.00  0.00           C  
ATOM   1664  C   MET A 112      51.731  17.278  81.339  1.00  0.00           C  
ATOM   1665  O   MET A 112      52.185  16.182  81.600  1.00  0.00           O  
ATOM   1666  CB  MET A 112      49.293  17.246  80.806  1.00  0.00           C  
ATOM   1667  CG  MET A 112      48.879  18.475  81.615  1.00  0.00           C  
ATOM   1668  SD  MET A 112      47.510  18.042  82.717  1.00  0.00           S  
ATOM   1669  CE  MET A 112      46.501  17.168  81.495  1.00  0.00           C  
ATOM   1670  H   MET A 112      51.390  15.633  79.338  1.00  0.00           H  
ATOM   1671  HA  MET A 112      50.766  18.466  79.836  1.00  0.00           H  
ATOM   1672  HB2 MET A 112      48.592  17.093  79.997  1.00  0.00           H  
ATOM   1673  HB3 MET A 112      49.297  16.379  81.448  1.00  0.00           H  
ATOM   1674  HG2 MET A 112      49.719  18.815  82.202  1.00  0.00           H  
ATOM   1675  HG3 MET A 112      48.566  19.260  80.942  1.00  0.00           H  
ATOM   1676  HE1 MET A 112      46.670  17.590  80.518  1.00  0.00           H  
ATOM   1677  HE2 MET A 112      46.775  16.122  81.486  1.00  0.00           H  
ATOM   1678  HE3 MET A 112      45.456  17.270  81.754  1.00  0.00           H  
ATOM   1679  N   ARG A 113      52.107  18.342  81.993  1.00  0.00           N  
ATOM   1680  CA  ARG A 113      53.113  18.227  83.084  1.00  0.00           C  
ATOM   1681  C   ARG A 113      52.525  18.791  84.378  1.00  0.00           C  
ATOM   1682  O   ARG A 113      51.440  19.335  84.392  1.00  0.00           O  
ATOM   1683  CB  ARG A 113      54.370  19.013  82.706  1.00  0.00           C  
ATOM   1684  CG  ARG A 113      55.581  18.080  82.734  1.00  0.00           C  
ATOM   1685  CD  ARG A 113      56.682  18.697  83.600  1.00  0.00           C  
ATOM   1686  NE  ARG A 113      57.637  17.634  84.019  1.00  0.00           N  
ATOM   1687  CZ  ARG A 113      57.665  17.234  85.261  1.00  0.00           C  
ATOM   1688  NH1 ARG A 113      57.600  18.107  86.230  1.00  0.00           N  
ATOM   1689  NH2 ARG A 113      57.756  15.962  85.536  1.00  0.00           N  
ATOM   1690  H   ARG A 113      51.726  19.217  81.768  1.00  0.00           H  
ATOM   1691  HA  ARG A 113      53.367  17.189  83.228  1.00  0.00           H  
ATOM   1692  HB2 ARG A 113      54.253  19.424  81.713  1.00  0.00           H  
ATOM   1693  HB3 ARG A 113      54.519  19.816  83.413  1.00  0.00           H  
ATOM   1694  HG2 ARG A 113      55.289  17.125  83.147  1.00  0.00           H  
ATOM   1695  HG3 ARG A 113      55.951  17.941  81.730  1.00  0.00           H  
ATOM   1696  HD2 ARG A 113      57.208  19.450  83.031  1.00  0.00           H  
ATOM   1697  HD3 ARG A 113      56.241  19.151  84.474  1.00  0.00           H  
ATOM   1698  HE  ARG A 113      58.243  17.233  83.362  1.00  0.00           H  
ATOM   1699 HH11 ARG A 113      57.529  19.083  86.020  1.00  0.00           H  
ATOM   1700 HH12 ARG A 113      57.621  17.801  87.181  1.00  0.00           H  
ATOM   1701 HH21 ARG A 113      57.805  15.293  84.793  1.00  0.00           H  
ATOM   1702 HH22 ARG A 113      57.778  15.655  86.487  1.00  0.00           H  
ATOM   1703  N   ALA A 114      53.232  18.664  85.467  1.00  0.00           N  
ATOM   1704  CA  ALA A 114      52.712  19.193  86.759  1.00  0.00           C  
ATOM   1705  C   ALA A 114      53.883  19.661  87.625  1.00  0.00           C  
ATOM   1706  O   ALA A 114      54.971  19.127  87.552  1.00  0.00           O  
ATOM   1707  CB  ALA A 114      51.948  18.088  87.491  1.00  0.00           C  
ATOM   1708  H   ALA A 114      54.105  18.220  85.435  1.00  0.00           H  
ATOM   1709  HA  ALA A 114      52.050  20.023  86.568  1.00  0.00           H  
ATOM   1710  HB1 ALA A 114      51.407  17.488  86.773  1.00  0.00           H  
ATOM   1711  HB2 ALA A 114      52.646  17.462  88.029  1.00  0.00           H  
ATOM   1712  HB3 ALA A 114      51.251  18.532  88.187  1.00  0.00           H  
ATOM   1713  N   LEU A 115      53.672  20.655  88.446  1.00  0.00           N  
ATOM   1714  CA  LEU A 115      54.781  21.147  89.308  1.00  0.00           C  
ATOM   1715  C   LEU A 115      54.245  21.552  90.680  1.00  0.00           C  
ATOM   1716  O   LEU A 115      53.164  22.090  90.808  1.00  0.00           O  
ATOM   1717  CB  LEU A 115      55.447  22.355  88.657  1.00  0.00           C  
ATOM   1718  CG  LEU A 115      56.698  22.730  89.448  1.00  0.00           C  
ATOM   1719  CD1 LEU A 115      57.888  22.847  88.497  1.00  0.00           C  
ATOM   1720  CD2 LEU A 115      56.472  24.070  90.151  1.00  0.00           C  
ATOM   1721  H   LEU A 115      52.788  21.076  88.492  1.00  0.00           H  
ATOM   1722  HA  LEU A 115      55.515  20.363  89.428  1.00  0.00           H  
ATOM   1723  HB2 LEU A 115      55.720  22.110  87.642  1.00  0.00           H  
ATOM   1724  HB3 LEU A 115      54.760  23.187  88.657  1.00  0.00           H  
ATOM   1725  HG  LEU A 115      56.900  21.966  90.185  1.00  0.00           H  
ATOM   1726 HD11 LEU A 115      57.618  23.473  87.659  1.00  0.00           H  
ATOM   1727 HD12 LEU A 115      58.727  23.283  89.019  1.00  0.00           H  
ATOM   1728 HD13 LEU A 115      58.160  21.865  88.139  1.00  0.00           H  
ATOM   1729 HD21 LEU A 115      55.531  24.045  90.680  1.00  0.00           H  
ATOM   1730 HD22 LEU A 115      57.275  24.249  90.851  1.00  0.00           H  
ATOM   1731 HD23 LEU A 115      56.452  24.862  89.418  1.00  0.00           H  
ATOM   1732  N   PHE A 116      55.015  21.302  91.699  1.00  0.00           N  
ATOM   1733  CA  PHE A 116      54.607  21.663  93.088  1.00  0.00           C  
ATOM   1734  C   PHE A 116      55.618  21.067  94.056  1.00  0.00           C  
ATOM   1735  O   PHE A 116      56.751  20.804  93.706  1.00  0.00           O  
ATOM   1736  CB  PHE A 116      53.216  21.106  93.411  1.00  0.00           C  
ATOM   1737  CG  PHE A 116      53.268  19.600  93.475  1.00  0.00           C  
ATOM   1738  CD1 PHE A 116      53.414  18.855  92.300  1.00  0.00           C  
ATOM   1739  CD2 PHE A 116      53.168  18.948  94.710  1.00  0.00           C  
ATOM   1740  CE1 PHE A 116      53.461  17.457  92.358  1.00  0.00           C  
ATOM   1741  CE2 PHE A 116      53.217  17.550  94.769  1.00  0.00           C  
ATOM   1742  CZ  PHE A 116      53.363  16.805  93.593  1.00  0.00           C  
ATOM   1743  H   PHE A 116      55.885  20.879  91.546  1.00  0.00           H  
ATOM   1744  HA  PHE A 116      54.600  22.736  93.198  1.00  0.00           H  
ATOM   1745  HB2 PHE A 116      52.891  21.492  94.366  1.00  0.00           H  
ATOM   1746  HB3 PHE A 116      52.520  21.410  92.652  1.00  0.00           H  
ATOM   1747  HD1 PHE A 116      53.487  19.359  91.349  1.00  0.00           H  
ATOM   1748  HD2 PHE A 116      53.054  19.524  95.619  1.00  0.00           H  
ATOM   1749  HE1 PHE A 116      53.574  16.883  91.452  1.00  0.00           H  
ATOM   1750  HE2 PHE A 116      53.139  17.047  95.722  1.00  0.00           H  
ATOM   1751  HZ  PHE A 116      53.400  15.726  93.639  1.00  0.00           H  
ATOM   1752  N   GLY A 117      55.219  20.846  95.270  1.00  0.00           N  
ATOM   1753  CA  GLY A 117      56.164  20.259  96.258  1.00  0.00           C  
ATOM   1754  C   GLY A 117      55.595  20.385  97.671  1.00  0.00           C  
ATOM   1755  O   GLY A 117      54.491  20.855  97.870  1.00  0.00           O  
ATOM   1756  H   GLY A 117      54.301  21.064  95.528  1.00  0.00           H  
ATOM   1757  HA2 GLY A 117      56.323  19.216  96.024  1.00  0.00           H  
ATOM   1758  HA3 GLY A 117      57.100  20.786  96.204  1.00  0.00           H  
ATOM   1759  N   GLU A 118      56.345  19.967  98.655  1.00  0.00           N  
ATOM   1760  CA  GLU A 118      55.859  20.058 100.058  1.00  0.00           C  
ATOM   1761  C   GLU A 118      55.801  21.527 100.485  1.00  0.00           C  
ATOM   1762  O   GLU A 118      55.327  21.856 101.554  1.00  0.00           O  
ATOM   1763  CB  GLU A 118      56.815  19.293 100.973  1.00  0.00           C  
ATOM   1764  CG  GLU A 118      56.075  18.857 102.239  1.00  0.00           C  
ATOM   1765  CD  GLU A 118      57.009  18.018 103.113  1.00  0.00           C  
ATOM   1766  OE1 GLU A 118      58.046  18.530 103.502  1.00  0.00           O  
ATOM   1767  OE2 GLU A 118      56.672  16.874 103.378  1.00  0.00           O  
ATOM   1768  H   GLU A 118      57.231  19.593  98.469  1.00  0.00           H  
ATOM   1769  HA  GLU A 118      54.874  19.627 100.125  1.00  0.00           H  
ATOM   1770  HB2 GLU A 118      57.186  18.421 100.454  1.00  0.00           H  
ATOM   1771  HB3 GLU A 118      57.642  19.931 101.242  1.00  0.00           H  
ATOM   1772  HG2 GLU A 118      55.756  19.731 102.787  1.00  0.00           H  
ATOM   1773  HG3 GLU A 118      55.213  18.267 101.967  1.00  0.00           H  
ATOM   1774  N   LYS A 119      56.278  22.411  99.653  1.00  0.00           N  
ATOM   1775  CA  LYS A 119      56.256  23.856  99.994  1.00  0.00           C  
ATOM   1776  C   LYS A 119      54.968  24.467  99.465  1.00  0.00           C  
ATOM   1777  O   LYS A 119      54.445  25.424 100.000  1.00  0.00           O  
ATOM   1778  CB  LYS A 119      57.441  24.524  99.314  1.00  0.00           C  
ATOM   1779  CG  LYS A 119      58.079  25.540 100.264  1.00  0.00           C  
ATOM   1780  CD  LYS A 119      59.326  26.138  99.610  1.00  0.00           C  
ATOM   1781  CE  LYS A 119      60.473  26.162 100.623  1.00  0.00           C  
ATOM   1782  NZ  LYS A 119      60.329  27.462 101.337  1.00  0.00           N  
ATOM   1783  H   LYS A 119      56.653  22.127  98.797  1.00  0.00           H  
ATOM   1784  HA  LYS A 119      56.316  23.985 101.056  1.00  0.00           H  
ATOM   1785  HB2 LYS A 119      58.160  23.769  99.044  1.00  0.00           H  
ATOM   1786  HB3 LYS A 119      57.100  25.022  98.424  1.00  0.00           H  
ATOM   1787  HG2 LYS A 119      57.370  26.327 100.477  1.00  0.00           H  
ATOM   1788  HG3 LYS A 119      58.359  25.048 101.183  1.00  0.00           H  
ATOM   1789  HD2 LYS A 119      59.609  25.536  98.758  1.00  0.00           H  
ATOM   1790  HD3 LYS A 119      59.114  27.146  99.285  1.00  0.00           H  
ATOM   1791  HE2 LYS A 119      60.377  25.337 101.316  1.00  0.00           H  
ATOM   1792  HE3 LYS A 119      61.424  26.122 100.117  1.00  0.00           H  
ATOM   1793  HZ1 LYS A 119      59.319  27.666 101.485  1.00  0.00           H  
ATOM   1794  HZ2 LYS A 119      60.811  27.409 102.256  1.00  0.00           H  
ATOM   1795  HZ3 LYS A 119      60.756  28.220 100.767  1.00  0.00           H  
ATOM   1796  N   ASN A 120      54.468  23.912  98.410  1.00  0.00           N  
ATOM   1797  CA  ASN A 120      53.212  24.435  97.805  1.00  0.00           C  
ATOM   1798  C   ASN A 120      52.009  23.748  98.452  1.00  0.00           C  
ATOM   1799  O   ASN A 120      50.894  23.851  97.981  1.00  0.00           O  
ATOM   1800  CB  ASN A 120      53.218  24.147  96.303  1.00  0.00           C  
ATOM   1801  CG  ASN A 120      53.349  25.460  95.531  1.00  0.00           C  
ATOM   1802  OD1 ASN A 120      53.399  26.522  96.119  1.00  0.00           O  
ATOM   1803  ND2 ASN A 120      53.409  25.432  94.228  1.00  0.00           N  
ATOM   1804  H   ASN A 120      54.929  23.148  98.009  1.00  0.00           H  
ATOM   1805  HA  ASN A 120      53.150  25.501  97.967  1.00  0.00           H  
ATOM   1806  HB2 ASN A 120      54.051  23.505  96.066  1.00  0.00           H  
ATOM   1807  HB3 ASN A 120      52.298  23.658  96.026  1.00  0.00           H  
ATOM   1808 HD21 ASN A 120      53.370  24.575  93.754  1.00  0.00           H  
ATOM   1809 HD22 ASN A 120      53.493  26.267  93.723  1.00  0.00           H  
ATOM   1810  N   ILE A 121      52.223  23.058  99.537  1.00  0.00           N  
ATOM   1811  CA  ILE A 121      51.090  22.378 100.223  1.00  0.00           C  
ATOM   1812  C   ILE A 121      50.490  23.346 101.245  1.00  0.00           C  
ATOM   1813  O   ILE A 121      50.817  24.515 101.259  1.00  0.00           O  
ATOM   1814  CB  ILE A 121      51.599  21.121 100.933  1.00  0.00           C  
ATOM   1815  CG1 ILE A 121      52.702  20.478 100.091  1.00  0.00           C  
ATOM   1816  CG2 ILE A 121      50.451  20.124 101.105  1.00  0.00           C  
ATOM   1817  CD1 ILE A 121      52.143  20.100  98.717  1.00  0.00           C  
ATOM   1818  H   ILE A 121      53.128  22.996  99.908  1.00  0.00           H  
ATOM   1819  HA  ILE A 121      50.340  22.105  99.497  1.00  0.00           H  
ATOM   1820  HB  ILE A 121      51.993  21.388 101.903  1.00  0.00           H  
ATOM   1821 HG12 ILE A 121      53.513  21.179  99.968  1.00  0.00           H  
ATOM   1822 HG13 ILE A 121      53.064  19.590 100.588  1.00  0.00           H  
ATOM   1823 HG21 ILE A 121      49.535  20.565 100.743  1.00  0.00           H  
ATOM   1824 HG22 ILE A 121      50.666  19.228 100.543  1.00  0.00           H  
ATOM   1825 HG23 ILE A 121      50.343  19.876 102.150  1.00  0.00           H  
ATOM   1826 HD11 ILE A 121      51.097  19.849  98.811  1.00  0.00           H  
ATOM   1827 HD12 ILE A 121      52.253  20.934  98.042  1.00  0.00           H  
ATOM   1828 HD13 ILE A 121      52.683  19.249  98.330  1.00  0.00           H  
ATOM   1829  N   HIS A 122      49.614  22.881 102.094  1.00  0.00           N  
ATOM   1830  CA  HIS A 122      49.008  23.794 103.104  1.00  0.00           C  
ATOM   1831  C   HIS A 122      48.617  23.000 104.351  1.00  0.00           C  
ATOM   1832  O   HIS A 122      47.588  22.355 104.388  1.00  0.00           O  
ATOM   1833  CB  HIS A 122      47.772  24.454 102.508  1.00  0.00           C  
ATOM   1834  CG  HIS A 122      47.900  25.949 102.613  1.00  0.00           C  
ATOM   1835  ND1 HIS A 122      48.179  26.746 101.513  1.00  0.00           N  
ATOM   1836  CD2 HIS A 122      47.790  26.807 103.679  1.00  0.00           C  
ATOM   1837  CE1 HIS A 122      48.227  28.022 101.940  1.00  0.00           C  
ATOM   1838  NE2 HIS A 122      47.997  28.115 103.252  1.00  0.00           N  
ATOM   1839  H   HIS A 122      49.355  21.938 102.067  1.00  0.00           H  
ATOM   1840  HA  HIS A 122      49.721  24.555 103.374  1.00  0.00           H  
ATOM   1841  HB2 HIS A 122      47.685  24.170 101.472  1.00  0.00           H  
ATOM   1842  HB3 HIS A 122      46.899  24.130 103.048  1.00  0.00           H  
ATOM   1843  HD1 HIS A 122      48.316  26.437 100.594  1.00  0.00           H  
ATOM   1844  HD2 HIS A 122      47.576  26.511 104.696  1.00  0.00           H  
ATOM   1845  HE1 HIS A 122      48.426  28.867 101.299  1.00  0.00           H  
ATOM   1846  N   ALA A 123      49.424  23.041 105.374  1.00  0.00           N  
ATOM   1847  CA  ALA A 123      49.087  22.287 106.614  1.00  0.00           C  
ATOM   1848  C   ALA A 123      48.900  23.267 107.774  1.00  0.00           C  
ATOM   1849  O   ALA A 123      49.673  24.187 107.954  1.00  0.00           O  
ATOM   1850  CB  ALA A 123      50.223  21.316 106.944  1.00  0.00           C  
ATOM   1851  H   ALA A 123      50.249  23.568 105.328  1.00  0.00           H  
ATOM   1852  HA  ALA A 123      48.173  21.732 106.460  1.00  0.00           H  
ATOM   1853  HB1 ALA A 123      50.882  21.231 106.093  1.00  0.00           H  
ATOM   1854  HB2 ALA A 123      50.778  21.686 107.794  1.00  0.00           H  
ATOM   1855  HB3 ALA A 123      49.811  20.345 107.178  1.00  0.00           H  
ATOM   1856  N   GLY A 124      47.876  23.077 108.562  1.00  0.00           N  
ATOM   1857  CA  GLY A 124      47.637  23.997 109.710  1.00  0.00           C  
ATOM   1858  C   GLY A 124      46.144  24.024 110.042  1.00  0.00           C  
ATOM   1859  O   GLY A 124      45.451  23.034 109.911  1.00  0.00           O  
ATOM   1860  H   GLY A 124      47.265  22.329 108.398  1.00  0.00           H  
ATOM   1861  HA2 GLY A 124      48.193  23.649 110.570  1.00  0.00           H  
ATOM   1862  HA3 GLY A 124      47.963  24.992 109.448  1.00  0.00           H  
ATOM   1863  N   ALA A 125      45.641  25.150 110.469  1.00  0.00           N  
ATOM   1864  CA  ALA A 125      44.193  25.238 110.807  1.00  0.00           C  
ATOM   1865  C   ALA A 125      43.443  25.925 109.665  1.00  0.00           C  
ATOM   1866  O   ALA A 125      42.340  26.390 109.901  1.00  0.00           O  
ATOM   1867  CB  ALA A 125      44.016  26.049 112.093  1.00  0.00           C  
ATOM   1868  OXT ALA A 125      43.985  25.975 108.573  1.00  0.00           O  
ATOM   1869  H   ALA A 125      46.216  25.937 110.568  1.00  0.00           H  
ATOM   1870  HA  ALA A 125      43.796  24.244 110.952  1.00  0.00           H  
ATOM   1871  HB1 ALA A 125      44.805  25.798 112.788  1.00  0.00           H  
ATOM   1872  HB2 ALA A 125      44.061  27.102 111.864  1.00  0.00           H  
ATOM   1873  HB3 ALA A 125      43.059  25.817 112.536  1.00  0.00           H  
TER    1874      ALA A 125                                                      
END
MOLECULE T0510.pdb
ATOM      1  N   MET     1      49.257  19.696  64.178  1.00 71.59           N  
ATOM      2  CA  MET     1      49.880  21.049  64.199  1.00 71.32           C  
ATOM      3  CB  MET     1      51.124  21.139  63.245  1.00 72.19           C  
ATOM      4  CG  MET     1      52.247  22.155  63.824  1.00 73.50           C  
ATOM      5  SD  MET     1      54.025  22.273  63.241  1.00 77.74           S  
ATOM      6  CE  MET     1      54.867  23.463  64.399  1.00 72.07           C  
ATOM      7  C   MET     1      48.911  22.246  63.959  1.00 70.16           C  
ATOM      8  O   MET     1      49.347  23.380  64.142  1.00 70.34           O  
ATOM      9  N   ALA     2      47.624  22.044  63.597  1.00 68.33           N  
ATOM     10  CA  ALA     2      46.650  23.199  63.468  1.00 66.15           C  
ATOM     11  CB  ALA     2      45.399  22.830  62.709  1.00 65.62           C  
ATOM     12  C   ALA     2      46.251  23.785  64.811  1.00 64.66           C  
ATOM     13  O   ALA     2      45.836  24.945  64.870  1.00 64.71           O  
ATOM     14  N   TYR     3      46.350  22.994  65.894  1.00 62.52           N  
ATOM     15  CA  TYR     3      46.376  23.554  67.272  1.00 61.30           C  
ATOM     16  CB  TYR     3      46.011  22.476  68.287  1.00 59.21           C  
ATOM     17  CG  TYR     3      45.151  22.966  69.468  1.00 59.73           C  
ATOM     18  CD1 TYR     3      45.620  23.952  70.363  1.00 56.54           C  
ATOM     19  CE1 TYR     3      44.851  24.361  71.439  1.00 55.69           C  
ATOM     20  CZ  TYR     3      43.593  23.819  71.616  1.00 54.65           C  
ATOM     21  OH  TYR     3      42.793  24.247  72.635  1.00 53.22           O  
ATOM     22  CE2 TYR     3      43.118  22.858  70.747  1.00 55.92           C  
ATOM     23  CD2 TYR     3      43.893  22.429  69.699  1.00 55.73           C  
ATOM     24  C   TYR     3      47.729  24.255  67.587  1.00 59.67           C  
ATOM     25  O   TYR     3      48.581  23.715  68.175  1.00 58.72           O  
ATOM     26  N   ASP     4      47.893  25.433  67.022  1.00 60.30           N  
ATOM     27  CA  ASP     4      48.921  26.426  67.270  1.00 60.86           C  
ATOM     28  CB  ASP     4      48.378  27.714  66.630  1.00 62.05           C  
ATOM     29  CG  ASP     4      48.520  27.734  65.241  1.00 65.80           C  
ATOM     30  OD1 ASP     4      48.719  26.637  64.727  1.00 77.23           O  
ATOM     31  OD2 ASP     4      48.470  28.816  64.648  1.00 70.98           O  
ATOM     32  C   ASP     4      49.045  26.988  68.660  1.00 60.07           C  
ATOM     33  O   ASP     4      48.120  26.896  69.489  1.00 60.10           O  
ATOM     34  N   GLY     5      50.101  27.774  68.806  1.00 58.39           N  
ATOM     35  CA  GLY     5      50.122  28.832  69.764  1.00 57.94           C  
ATOM     36  C   GLY     5      48.910  29.720  69.637  1.00 58.23           C  
ATOM     37  O   GLY     5      48.150  29.874  70.572  1.00 58.71           O  
ATOM     38  N   LEU     6      48.697  30.312  68.472  1.00 58.52           N  
ATOM     39  CA  LEU     6      47.634  31.314  68.341  1.00 57.75           C  
ATOM     40  CB  LEU     6      47.743  32.030  66.999  1.00 57.89           C  
ATOM     41  CG  LEU     6      49.140  32.572  66.649  1.00 57.71           C  
ATOM     42  CD1 LEU     6      49.054  32.837  65.257  1.00 61.64           C  
ATOM     43  CD2 LEU     6      49.579  33.869  67.351  1.00 58.69           C  
ATOM     44  C   LEU     6      46.240  30.736  68.576  1.00 57.30           C  
ATOM     45  O   LEU     6      45.381  31.380  69.187  1.00 57.23           O  
ATOM     46  N   PHE     7      46.017  29.517  68.115  1.00 56.99           N  
ATOM     47  CA  PHE     7      44.771  28.821  68.422  1.00 56.97           C  
ATOM     48  CB  PHE     7      44.756  27.457  67.759  1.00 56.68           C  
ATOM     49  CG  PHE     7      43.435  26.841  67.764  1.00 56.05           C  
ATOM     50  CD1 PHE     7      42.531  27.111  66.752  1.00 56.60           C  
ATOM     51  CE1 PHE     7      41.221  26.549  66.737  1.00 56.68           C  
ATOM     52  CZ  PHE     7      40.831  25.718  67.755  1.00 56.69           C  
ATOM     53  CE2 PHE     7      41.762  25.459  68.814  1.00 57.81           C  
ATOM     54  CD2 PHE     7      43.045  26.038  68.805  1.00 56.36           C  
ATOM     55  C   PHE     7      44.625  28.684  69.948  1.00 57.26           C  
ATOM     56  O   PHE     7      43.608  29.108  70.546  1.00 56.87           O  
ATOM     57  N   THR     8      45.671  28.145  70.583  1.00 57.17           N  
ATOM     58  CA  THR     8      45.759  28.149  72.050  1.00 57.18           C  
ATOM     59  CB  THR     8      47.131  27.719  72.501  1.00 56.83           C  
ATOM     60  OG1 THR     8      47.375  26.398  72.020  1.00 57.39           O  
ATOM     61  CG2 THR     8      47.286  27.780  74.016  1.00 57.05           C  
ATOM     62  C   THR     8      45.450  29.524  72.670  1.00 57.75           C  
ATOM     63  O   THR     8      44.653  29.629  73.613  1.00 59.34           O  
ATOM     64  N   LYS     9      46.038  30.592  72.167  1.00 57.34           N  
ATOM     65  CA  LYS     9      45.736  31.876  72.770  1.00 57.48           C  
ATOM     66  CB  LYS     9      46.396  33.066  72.021  1.00 57.50           C  
ATOM     67  CG  LYS     9      45.666  34.419  72.176  1.00 57.66           C  
ATOM     68  CD  LYS     9      46.376  35.584  71.451  1.00 58.99           C  
ATOM     69  CE  LYS     9      46.648  36.778  72.343  1.00 61.69           C  
ATOM     70  NZ  LYS     9      45.482  37.025  73.281  1.00 65.22           N  
ATOM     71  C   LYS     9      44.232  32.009  72.815  1.00 57.29           C  
ATOM     72  O   LYS     9      43.694  32.429  73.829  1.00 57.39           O  
ATOM     73  N   LYS    10      43.552  31.588  71.749  1.00 57.05           N  
ATOM     74  CA  LYS    10      42.150  31.865  71.637  1.00 57.10           C  
ATOM     75  CB  LYS    10      41.804  31.865  70.200  1.00 57.47           C  
ATOM     76  CG  LYS    10      42.462  33.063  69.483  1.00 58.99           C  
ATOM     77  CD  LYS    10      41.538  34.240  69.638  1.00 58.21           C  
ATOM     78  CE  LYS    10      42.201  35.443  69.281  1.00 57.94           C  
ATOM     79  NZ  LYS    10      41.297  36.575  69.693  1.00 60.18           N  
ATOM     80  C   LYS    10      41.243  30.938  72.408  1.00 57.62           C  
ATOM     81  O   LYS    10      40.226  31.394  72.961  1.00 57.88           O  
ATOM     82  N   MET    11      41.598  29.645  72.456  1.00 57.56           N  
ATOM     83  CA  MET    11      40.918  28.681  73.345  1.00 57.50           C  
ATOM     84  CB  MET    11      41.502  27.258  73.208  1.00 57.30           C  
ATOM     85  CG  MET    11      40.825  26.199  74.108  1.00 56.08           C  
ATOM     86  SD  MET    11      39.043  26.222  73.970  1.00 52.39           S  
ATOM     87  CE  MET    11      38.872  25.287  72.451  1.00 53.41           C  
ATOM     88  C   MET    11      41.042  29.128  74.818  1.00 58.04           C  
ATOM     89  O   MET    11      40.025  29.112  75.550  1.00 58.02           O  
ATOM     90  N   VAL    12      42.263  29.493  75.260  1.00 57.47           N  
ATOM     91  CA  VAL    12      42.429  30.037  76.624  1.00 57.41           C  
ATOM     92  CB  VAL    12      43.905  30.428  77.013  1.00 57.56           C  
ATOM     93  CG1 VAL    12      43.945  31.389  78.215  1.00 54.94           C  
ATOM     94  CG2 VAL    12      44.764  29.211  77.277  1.00 55.38           C  
ATOM     95  C   VAL    12      41.516  31.248  76.823  1.00 57.57           C  
ATOM     96  O   VAL    12      40.817  31.305  77.811  1.00 56.91           O  
ATOM     97  N   GLU    13      41.450  32.191  75.888  1.00 58.16           N  
ATOM     98  CA  GLU    13      40.551  33.330  76.145  1.00 58.81           C  
ATOM     99  CB  GLU    13      40.462  34.348  75.022  1.00 58.42           C  
ATOM    100  CG  GLU    13      41.683  34.487  74.223  1.00 61.10           C  
ATOM    101  CD  GLU    13      41.758  35.825  73.470  1.00 62.35           C  
ATOM    102  OE1 GLU    13      40.703  36.296  72.914  1.00 62.60           O  
ATOM    103  OE2 GLU    13      42.902  36.383  73.485  1.00 67.43           O  
ATOM    104  C   GLU    13      39.144  32.816  76.423  1.00 58.50           C  
ATOM    105  O   GLU    13      38.493  33.272  77.335  1.00 59.00           O  
ATOM    106  N   SER    14      38.654  31.871  75.645  1.00 58.18           N  
ATOM    107  CA  SER    14      37.284  31.459  75.850  1.00 58.33           C  
ATOM    108  CB  SER    14      36.817  30.676  74.644  1.00 57.89           C  
ATOM    109  OG  SER    14      37.492  29.449  74.612  1.00 61.31           O  
ATOM    110  C   SER    14      37.056  30.633  77.165  1.00 58.57           C  
ATOM    111  O   SER    14      35.906  30.374  77.546  1.00 58.72           O  
ATOM    112  N   LEU    15      38.135  30.221  77.847  1.00 57.94           N  
ATOM    113  CA  LEU    15      38.016  29.400  79.066  1.00 56.87           C  
ATOM    114  CB  LEU    15      39.079  28.290  79.065  1.00 56.64           C  
ATOM    115  CG  LEU    15      39.008  27.264  77.940  1.00 55.64           C  
ATOM    116  CD1 LEU    15      40.036  26.140  78.106  1.00 53.69           C  
ATOM    117  CD2 LEU    15      37.635  26.695  77.874  1.00 56.64           C  
ATOM    118  C   LEU    15      38.113  30.222  80.369  1.00 56.22           C  
ATOM    119  O   LEU    15      37.991  29.681  81.463  1.00 56.39           O  
ATOM    120  N   GLN    16      38.281  31.526  80.261  1.00 55.25           N  
ATOM    121  CA  GLN    16      38.403  32.370  81.450  1.00 55.09           C  
ATOM    122  CB  GLN    16      38.782  33.766  81.002  1.00 54.11           C  
ATOM    123  CG  GLN    16      40.063  33.767  80.207  1.00 52.69           C  
ATOM    124  CD  GLN    16      41.235  33.484  81.079  1.00 50.25           C  
ATOM    125  OE1 GLN    16      41.360  34.131  82.089  1.00 53.50           O  
ATOM    126  NE2 GLN    16      42.107  32.554  80.706  1.00 44.21           N  
ATOM    127  C   GLN    16      37.132  32.413  82.355  1.00 55.41           C  
ATOM    128  O   GLN    16      37.207  32.636  83.583  1.00 56.33           O  
ATOM    129  N   PHE    17      35.968  32.189  81.767  1.00 55.01           N  
ATOM    130  CA  PHE    17      34.749  32.207  82.527  1.00 54.61           C  
ATOM    131  CB  PHE    17      33.526  32.142  81.599  1.00 55.51           C  
ATOM    132  CG  PHE    17      33.192  30.746  81.127  1.00 55.82           C  
ATOM    133  CD1 PHE    17      32.218  30.000  81.754  1.00 58.02           C  
ATOM    134  CE1 PHE    17      31.912  28.692  81.321  1.00 57.81           C  
ATOM    135  CZ  PHE    17      32.607  28.139  80.256  1.00 56.80           C  
ATOM    136  CE2 PHE    17      33.582  28.879  79.637  1.00 55.96           C  
ATOM    137  CD2 PHE    17      33.871  30.172  80.074  1.00 56.30           C  
ATOM    138  C   PHE    17      34.772  31.037  83.503  1.00 54.06           C  
ATOM    139  O   PHE    17      34.049  31.036  84.468  1.00 55.29           O  
ATOM    140  N   LEU    18      35.603  30.045  83.289  1.00 53.09           N  
ATOM    141  CA  LEU    18      35.748  28.998  84.295  1.00 52.89           C  
ATOM    142  CB  LEU    18      36.341  27.723  83.659  1.00 52.49           C  
ATOM    143  CG  LEU    18      35.621  26.988  82.512  1.00 50.86           C  
ATOM    144  CD1 LEU    18      36.514  25.940  81.852  1.00 46.98           C  
ATOM    145  CD2 LEU    18      34.359  26.363  83.014  1.00 49.72           C  
ATOM    146  C   LEU    18      36.600  29.412  85.542  1.00 52.78           C  
ATOM    147  O   LEU    18      36.554  28.736  86.570  1.00 53.22           O  
ATOM    148  N   THR    19      37.399  30.471  85.493  1.00 52.49           N  
ATOM    149  CA  THR    19      38.125  30.888  86.731  1.00 52.78           C  
ATOM    150  CB  THR    19      38.870  32.179  86.491  1.00 52.13           C  
ATOM    151  OG1 THR    19      39.294  32.174  85.156  1.00 53.32           O  
ATOM    152  CG2 THR    19      40.072  32.260  87.300  1.00 51.34           C  
ATOM    153  C   THR    19      37.176  31.099  87.939  1.00 52.79           C  
ATOM    154  O   THR    19      36.147  31.705  87.758  1.00 53.46           O  
ATOM    155  N   THR    20      37.502  30.598  89.140  1.00 52.73           N  
ATOM    156  CA  THR    20      36.559  30.573  90.286  1.00 52.59           C  
ATOM    157  CB  THR    20      35.548  31.672  90.179  1.00 52.20           C  
ATOM    158  OG1 THR    20      36.302  32.852  90.273  1.00 50.50           O  
ATOM    159  CG2 THR    20      34.449  31.639  91.273  1.00 52.57           C  
ATOM    160  C   THR    20      35.766  29.312  90.418  1.00 53.19           C  
ATOM    161  O   THR    20      35.236  29.043  91.481  1.00 53.03           O  
ATOM    162  N   GLY    21      35.648  28.547  89.337  1.00 53.96           N  
ATOM    163  CA  GLY    21      34.834  27.362  89.349  1.00 53.68           C  
ATOM    164  C   GLY    21      35.559  26.345  90.196  1.00 54.58           C  
ATOM    165  O   GLY    21      36.775  26.444  90.445  1.00 53.00           O  
ATOM    166  N   ARG    22      34.771  25.357  90.610  1.00 56.34           N  
ATOM    167  CA  ARG    22      35.190  24.247  91.411  1.00 57.32           C  
ATOM    168  CB  ARG    22      34.116  23.996  92.465  1.00 57.52           C  
ATOM    169  CG  ARG    22      34.513  22.964  93.540  1.00 58.74           C  
ATOM    170  CD  ARG    22      33.527  22.867  94.676  1.00 61.66           C  
ATOM    171  NE  ARG    22      33.100  24.164  95.267  1.00 67.01           N  
ATOM    172  CZ  ARG    22      33.754  24.922  96.186  1.00 68.16           C  
ATOM    173  NH1 ARG    22      34.964  24.602  96.646  1.00 68.25           N  
ATOM    174  NH2 ARG    22      33.186  26.050  96.643  1.00 68.48           N  
ATOM    175  C   ARG    22      35.327  22.983  90.562  1.00 57.20           C  
ATOM    176  O   ARG    22      34.457  22.661  89.756  1.00 56.26           O  
ATOM    177  N   VAL    23      36.400  22.242  90.794  1.00 57.50           N  
ATOM    178  CA  VAL    23      36.601  20.976  90.139  1.00 57.73           C  
ATOM    179  CB  VAL    23      38.037  20.552  90.258  1.00 57.72           C  
ATOM    180  CG1 VAL    23      38.266  19.310  89.478  1.00 57.52           C  
ATOM    181  CG2 VAL    23      38.950  21.676  89.833  1.00 56.57           C  
ATOM    182  C   VAL    23      35.716  19.921  90.828  1.00 59.03           C  
ATOM    183  O   VAL    23      35.856  19.575  92.013  1.00 58.73           O  
ATOM    184  N   HIS    24      34.812  19.387  90.045  1.00 60.07           N  
ATOM    185  CA  HIS    24      33.701  18.664  90.564  1.00 60.88           C  
ATOM    186  CB  HIS    24      32.459  19.206  89.892  1.00 61.48           C  
ATOM    187  CG  HIS    24      31.191  18.633  90.411  1.00 63.27           C  
ATOM    188  ND1 HIS    24      30.493  17.656  89.736  1.00 66.74           N  
ATOM    189  CE1 HIS    24      29.398  17.355  90.409  1.00 67.59           C  
ATOM    190  NE2 HIS    24      29.373  18.093  91.504  1.00 68.16           N  
ATOM    191  CD2 HIS    24      30.485  18.900  91.531  1.00 65.18           C  
ATOM    192  C   HIS    24      33.786  17.194  90.296  1.00 61.05           C  
ATOM    193  O   HIS    24      33.056  16.429  90.918  1.00 62.19           O  
ATOM    194  N   LYS    25      34.651  16.792  89.372  1.00 61.01           N  
ATOM    195  CA  LYS    25      34.659  15.428  88.832  1.00 60.54           C  
ATOM    196  CB  LYS    25      33.366  15.171  88.071  1.00 60.68           C  
ATOM    197  CG  LYS    25      32.863  13.711  87.997  1.00 62.78           C  
ATOM    198  CD  LYS    25      31.270  13.593  88.331  1.00 64.32           C  
ATOM    199  CE  LYS    25      30.295  14.434  87.349  1.00 66.41           C  
ATOM    200  NZ  LYS    25      28.899  14.826  87.898  1.00 65.82           N  
ATOM    201  C   LYS    25      35.829  15.310  87.865  1.00 59.77           C  
ATOM    202  O   LYS    25      36.182  16.274  87.144  1.00 59.28           O  
ATOM    203  N   ILE    26      36.451  14.142  87.843  1.00 58.62           N  
ATOM    204  CA  ILE    26      37.538  13.927  86.899  1.00 58.31           C  
ATOM    205  CB  ILE    26      38.920  14.215  87.513  1.00 58.42           C  
ATOM    206  CG1 ILE    26      38.895  15.607  88.170  1.00 58.50           C  
ATOM    207  CD1 ILE    26      40.241  16.100  88.699  1.00 58.84           C  
ATOM    208  CG2 ILE    26      40.045  14.090  86.430  1.00 57.46           C  
ATOM    209  C   ILE    26      37.479  12.509  86.409  1.00 57.64           C  
ATOM    210  O   ILE    26      37.615  11.598  87.192  1.00 57.71           O  
ATOM    211  N   ASN    27      37.245  12.324  85.113  1.00 56.79           N  
ATOM    212  CA  ASN    27      37.326  11.012  84.530  1.00 56.09           C  
ATOM    213  CB  ASN    27      35.991  10.623  83.977  1.00 56.02           C  
ATOM    214  CG  ASN    27      34.913  10.823  84.943  1.00 53.76           C  
ATOM    215  OD1 ASN    27      34.504   9.905  85.622  1.00 48.78           O  
ATOM    216  ND2 ASN    27      34.440  12.040  85.026  1.00 53.49           N  
ATOM    217  C   ASN    27      38.399  10.886  83.462  1.00 55.84           C  
ATOM    218  O   ASN    27      39.094  11.836  83.156  1.00 55.88           O  
ATOM    219  N   GLN    28      38.547   9.676  82.933  1.00 55.95           N  
ATOM    220  CA  GLN    28      39.607   9.346  82.005  1.00 55.65           C  
ATOM    221  CB  GLN    28      40.802   8.751  82.778  1.00 56.10           C  
ATOM    222  CG  GLN    28      42.006   8.260  81.946  1.00 56.25           C  
ATOM    223  CD  GLN    28      43.124   7.703  82.809  1.00 55.00           C  
ATOM    224  OE1 GLN    28      43.419   8.247  83.844  1.00 58.35           O  
ATOM    225  NE2 GLN    28      43.744   6.646  82.380  1.00 51.31           N  
ATOM    226  C   GLN    28      38.938   8.322  81.128  1.00 55.31           C  
ATOM    227  O   GLN    28      38.909   7.158  81.460  1.00 55.58           O  
ATOM    228  N   PRO    29      38.354   8.753  80.019  1.00 55.19           N  
ATOM    229  CA  PRO    29      37.595   7.782  79.234  1.00 55.19           C  
ATOM    230  CB  PRO    29      36.738   8.646  78.331  1.00 55.01           C  
ATOM    231  CG  PRO    29      36.981  10.105  78.870  1.00 55.60           C  
ATOM    232  CD  PRO    29      38.326  10.083  79.408  1.00 55.16           C  
ATOM    233  C   PRO    29      38.444   6.873  78.399  1.00 55.30           C  
ATOM    234  O   PRO    29      37.894   5.908  77.878  1.00 55.91           O  
ATOM    235  N   ASP    30      39.745   7.184  78.265  1.00 55.17           N  
ATOM    236  CA  ASP    30      40.736   6.309  77.604  1.00 55.02           C  
ATOM    237  CB  ASP    30      40.604   6.402  76.079  1.00 55.37           C  
ATOM    238  CG  ASP    30      41.004   7.767  75.528  1.00 57.70           C  
ATOM    239  OD1 ASP    30      41.775   8.537  76.163  1.00 62.53           O  
ATOM    240  OD2 ASP    30      40.534   8.090  74.437  1.00 59.55           O  
ATOM    241  C   ASP    30      42.154   6.676  78.025  1.00 54.43           C  
ATOM    242  O   ASP    30      42.341   7.615  78.783  1.00 54.42           O  
ATOM    243  N   ASN    31      43.159   6.001  77.481  1.00 54.10           N  
ATOM    244  CA  ASN    31      44.529   6.248  77.909  1.00 54.40           C  
ATOM    245  CB  ASN    31      45.451   5.201  77.358  1.00 54.48           C  
ATOM    246  CG  ASN    31      45.260   3.894  78.016  1.00 55.89           C  
ATOM    247  OD1 ASN    31      44.605   2.996  77.439  1.00 55.53           O  
ATOM    248  ND2 ASN    31      45.779   3.767  79.274  1.00 54.78           N  
ATOM    249  C   ASN    31      45.105   7.554  77.512  1.00 54.41           C  
ATOM    250  O   ASN    31      46.212   7.856  77.910  1.00 54.57           O  
ATOM    251  N   ASP    32      44.378   8.322  76.715  1.00 54.81           N  
ATOM    252  CA  ASP    32      44.900   9.550  76.125  1.00 54.74           C  
ATOM    253  CB  ASP    32      44.859   9.442  74.591  1.00 55.45           C  
ATOM    254  CG  ASP    32      45.874   8.405  74.027  1.00 59.34           C  
ATOM    255  OD1 ASP    32      47.093   8.488  74.364  1.00 62.68           O  
ATOM    256  OD2 ASP    32      45.449   7.513  73.230  1.00 65.10           O  
ATOM    257  C   ASP    32      44.111  10.769  76.567  1.00 53.74           C  
ATOM    258  O   ASP    32      44.389  11.870  76.120  1.00 53.18           O  
ATOM    259  N   THR    33      43.142  10.597  77.457  1.00 52.76           N  
ATOM    260  CA  THR    33      42.191  11.650  77.663  1.00 52.24           C  
ATOM    261  CB  THR    33      40.945  11.338  76.919  1.00 52.22           C  
ATOM    262  OG1 THR    33      41.282  10.993  75.575  1.00 52.52           O  
ATOM    263  CG2 THR    33      40.025  12.541  76.965  1.00 51.93           C  
ATOM    264  C   THR    33      41.741  11.824  79.085  1.00 52.56           C  
ATOM    265  O   THR    33      41.366  10.849  79.773  1.00 52.32           O  
ATOM    266  N   ILE    34      41.748  13.081  79.508  1.00 52.31           N  
ATOM    267  CA  ILE    34      41.195  13.466  80.774  1.00 52.74           C  
ATOM    268  CB  ILE    34      42.263  14.049  81.745  1.00 52.93           C  
ATOM    269  CG1 ILE    34      43.077  12.917  82.389  1.00 54.28           C  
ATOM    270  CD1 ILE    34      42.222  11.845  83.088  1.00 55.69           C  
ATOM    271  CG2 ILE    34      41.654  14.869  82.842  1.00 51.38           C  
ATOM    272  C   ILE    34      40.067  14.437  80.546  1.00 53.51           C  
ATOM    273  O   ILE    34      40.163  15.422  79.814  1.00 53.59           O  
ATOM    274  N   LEU    35      38.989  14.111  81.231  1.00 54.85           N  
ATOM    275  CA  LEU    35      37.732  14.807  81.210  1.00 55.87           C  
ATOM    276  CB  LEU    35      36.651  13.757  80.988  1.00 55.79           C  
ATOM    277  CG  LEU    35      35.467  14.154  80.128  1.00 57.45           C  
ATOM    278  CD1 LEU    35      35.856  15.250  79.085  1.00 57.26           C  
ATOM    279  CD2 LEU    35      34.884  12.869  79.495  1.00 56.12           C  
ATOM    280  C   LEU    35      37.595  15.409  82.582  1.00 56.07           C  
ATOM    281  O   LEU    35      37.614  14.690  83.578  1.00 56.61           O  
ATOM    282  N   MET    36      37.508  16.717  82.682  1.00 56.67           N  
ATOM    283  CA  MET    36      37.559  17.340  84.010  1.00 56.77           C  
ATOM    284  CB  MET    36      38.870  18.121  84.150  1.00 55.92           C  
ATOM    285  CG  MET    36      38.839  19.269  85.127  1.00 58.22           C  
ATOM    286  SD  MET    36      40.469  20.115  85.512  1.00 63.46           S  
ATOM    287  CE  MET    36      41.676  18.770  85.774  1.00 62.58           C  
ATOM    288  C   MET    36      36.314  18.198  84.114  1.00 55.75           C  
ATOM    289  O   MET    36      36.250  19.200  83.410  1.00 55.51           O  
ATOM    290  N   VAL    37      35.302  17.813  84.919  1.00 55.03           N  
ATOM    291  CA  VAL    37      34.129  18.715  84.997  1.00 55.19           C  
ATOM    292  CB  VAL    37      32.723  18.052  84.899  1.00 54.29           C  
ATOM    293  CG1 VAL    37      31.772  18.619  85.915  1.00 51.73           C  
ATOM    294  CG2 VAL    37      32.826  16.575  84.918  1.00 54.28           C  
ATOM    295  C   VAL    37      34.232  19.840  86.054  1.00 55.48           C  
ATOM    296  O   VAL    37      34.533  19.602  87.191  1.00 56.29           O  
ATOM    297  N   VAL    38      34.058  21.074  85.589  1.00 55.33           N  
ATOM    298  CA  VAL    38      34.139  22.247  86.384  1.00 55.32           C  
ATOM    299  CB  VAL    38      34.963  23.283  85.683  1.00 54.87           C  
ATOM    300  CG1 VAL    38      35.096  24.538  86.568  1.00 53.27           C  
ATOM    301  CG2 VAL    38      36.302  22.667  85.356  1.00 54.08           C  
ATOM    302  C   VAL    38      32.750  22.800  86.603  1.00 55.82           C  
ATOM    303  O   VAL    38      32.015  23.041  85.667  1.00 55.87           O  
ATOM    304  N   ARG    39      32.413  23.018  87.864  1.00 56.70           N  
ATOM    305  CA  ARG    39      31.098  23.475  88.269  1.00 56.84           C  
ATOM    306  CB  ARG    39      30.597  22.592  89.381  1.00 56.68           C  
ATOM    307  CG  ARG    39      29.157  22.717  89.657  1.00 58.41           C  
ATOM    308  CD  ARG    39      28.651  21.737  90.757  1.00 58.93           C  
ATOM    309  NE  ARG    39      27.259  22.073  91.075  1.00 60.49           N  
ATOM    310  CZ  ARG    39      26.196  21.355  90.716  1.00 63.43           C  
ATOM    311  NH1 ARG    39      24.963  21.783  91.055  1.00 62.29           N  
ATOM    312  NH2 ARG    39      26.356  20.192  90.054  1.00 64.97           N  
ATOM    313  C   ARG    39      31.257  24.926  88.697  1.00 56.73           C  
ATOM    314  O   ARG    39      32.011  25.243  89.583  1.00 57.15           O  
ATOM    315  N   GLN    40      30.591  25.805  87.978  1.00 57.12           N  
ATOM    316  CA  GLN    40      30.682  27.231  88.157  1.00 57.07           C  
ATOM    317  CB  GLN    40      31.253  27.868  86.885  1.00 57.06           C  
ATOM    318  CG  GLN    40      31.235  29.352  86.885  1.00 58.80           C  
ATOM    319  CD  GLN    40      32.298  29.924  87.806  1.00 65.18           C  
ATOM    320  OE1 GLN    40      33.448  30.092  87.380  1.00 68.55           O  
ATOM    321  NE2 GLN    40      31.930  30.227  89.082  1.00 65.56           N  
ATOM    322  C   GLN    40      29.220  27.572  88.384  1.00 56.64           C  
ATOM    323  O   GLN    40      28.388  27.052  87.700  1.00 56.19           O  
ATOM    324  N   ASN    41      28.893  28.358  89.398  1.00 57.22           N  
ATOM    325  CA  ASN    41      27.502  28.605  89.757  1.00 57.44           C  
ATOM    326  CB  ASN    41      27.029  29.859  89.048  1.00 57.50           C  
ATOM    327  CG  ASN    41      25.567  30.195  89.347  1.00 58.59           C  
ATOM    328  OD1 ASN    41      25.012  29.778  90.370  1.00 64.21           O  
ATOM    329  ND2 ASN    41      24.935  30.956  88.463  1.00 59.55           N  
ATOM    330  C   ASN    41      26.516  27.432  89.505  1.00 57.62           C  
ATOM    331  O   ASN    41      25.476  27.578  88.928  1.00 57.25           O  
ATOM    332  N   ARG    42      26.843  26.247  89.964  1.00 59.11           N  
ATOM    333  CA  ARG    42      25.907  25.116  89.929  1.00 59.55           C  
ATOM    334  CB  ARG    42      24.640  25.493  90.665  1.00 60.61           C  
ATOM    335  CG  ARG    42      24.874  25.486  92.160  1.00 62.87           C  
ATOM    336  CD  ARG    42      23.614  24.953  92.872  1.00 66.57           C  
ATOM    337  NE  ARG    42      23.629  25.159  94.314  1.00 67.04           N  
ATOM    338  CZ  ARG    42      23.625  26.352  94.914  1.00 69.37           C  
ATOM    339  NH1 ARG    42      23.633  27.480  94.218  1.00 69.34           N  
ATOM    340  NH2 ARG    42      23.628  26.419  96.235  1.00 70.61           N  
ATOM    341  C   ARG    42      25.566  24.496  88.572  1.00 59.71           C  
ATOM    342  O   ARG    42      24.640  23.690  88.481  1.00 60.31           O  
ATOM    343  N   GLN    43      26.333  24.845  87.543  1.00 58.92           N  
ATOM    344  CA  GLN    43      26.235  24.205  86.259  1.00 58.47           C  
ATOM    345  CB  GLN    43      26.051  25.225  85.176  1.00 58.52           C  
ATOM    346  CG  GLN    43      24.904  26.154  85.410  1.00 58.45           C  
ATOM    347  CD  GLN    43      23.613  25.432  85.562  1.00 55.96           C  
ATOM    348  OE1 GLN    43      22.810  25.833  86.354  1.00 55.95           O  
ATOM    349  NE2 GLN    43      23.402  24.370  84.799  1.00 55.14           N  
ATOM    350  C   GLN    43      27.531  23.571  85.992  1.00 58.05           C  
ATOM    351  O   GLN    43      28.554  24.137  86.293  1.00 57.36           O  
ATOM    352  N   ASN    44      27.496  22.415  85.368  1.00 58.20           N  
ATOM    353  CA  ASN    44      28.717  21.724  85.051  1.00 58.21           C  
ATOM    354  CB  ASN    44      28.499  20.224  85.196  1.00 58.68           C  
ATOM    355  CG  ASN    44      28.056  19.840  86.584  1.00 58.49           C  
ATOM    356  OD1 ASN    44      28.537  20.382  87.565  1.00 60.73           O  
ATOM    357  ND2 ASN    44      27.147  18.898  86.674  1.00 59.36           N  
ATOM    358  C   ASN    44      29.187  22.052  83.649  1.00 58.20           C  
ATOM    359  O   ASN    44      28.386  22.350  82.758  1.00 58.50           O  
ATOM    360  N   HIS    45      30.504  21.988  83.474  1.00 58.35           N  
ATOM    361  CA  HIS    45      31.190  22.191  82.187  1.00 57.96           C  
ATOM    362  CB  HIS    45      31.797  23.586  82.162  1.00 57.49           C  
ATOM    363  CG  HIS    45      30.794  24.686  82.331  1.00 58.17           C  
ATOM    364  ND1 HIS    45      30.167  25.299  81.268  1.00 60.23           N  
ATOM    365  CE1 HIS    45      29.339  26.228  81.706  1.00 59.66           C  
ATOM    366  NE2 HIS    45      29.412  26.248  83.021  1.00 60.67           N  
ATOM    367  CD2 HIS    45      30.310  25.289  83.437  1.00 59.69           C  
ATOM    368  C   HIS    45      32.267  21.094  81.984  1.00 57.83           C  
ATOM    369  O   HIS    45      33.084  20.892  82.844  1.00 57.42           O  
ATOM    370  N   GLN    46      32.229  20.355  80.873  1.00 58.52           N  
ATOM    371  CA  GLN    46      33.180  19.256  80.569  1.00 58.96           C  
ATOM    372  CB  GLN    46      32.496  18.209  79.706  1.00 58.97           C  
ATOM    373  CG  GLN    46      32.282  16.854  80.257  1.00 59.90           C  
ATOM    374  CD  GLN    46      31.381  16.020  79.334  1.00 62.65           C  
ATOM    375  OE1 GLN    46      31.229  16.336  78.128  1.00 68.13           O  
ATOM    376  NE2 GLN    46      30.753  14.957  79.892  1.00 69.81           N  
ATOM    377  C   GLN    46      34.415  19.748  79.783  1.00 58.62           C  
ATOM    378  O   GLN    46      34.337  20.028  78.608  1.00 58.14           O  
ATOM    379  N   LEU    47      35.549  19.809  80.463  1.00 58.88           N  
ATOM    380  CA  LEU    47      36.823  20.259  79.907  1.00 58.33           C  
ATOM    381  CB  LEU    47      37.618  20.962  81.004  1.00 58.09           C  
ATOM    382  CG  LEU    47      38.818  21.755  80.559  1.00 58.65           C  
ATOM    383  CD1 LEU    47      38.396  22.829  79.583  1.00 58.97           C  
ATOM    384  CD2 LEU    47      39.399  22.401  81.754  1.00 57.52           C  
ATOM    385  C   LEU    47      37.572  19.013  79.446  1.00 58.16           C  
ATOM    386  O   LEU    47      37.845  18.119  80.243  1.00 58.44           O  
ATOM    387  N   LEU    48      37.872  18.924  78.163  1.00 57.25           N  
ATOM    388  CA  LEU    48      38.567  17.769  77.652  1.00 56.48           C  
ATOM    389  CB  LEU    48      37.877  17.234  76.406  1.00 57.03           C  
ATOM    390  CG  LEU    48      38.440  15.969  75.722  1.00 57.03           C  
ATOM    391  CD1 LEU    48      37.323  15.161  74.989  1.00 55.90           C  
ATOM    392  CD2 LEU    48      39.541  16.335  74.781  1.00 54.47           C  
ATOM    393  C   LEU    48      39.983  18.153  77.361  1.00 55.36           C  
ATOM    394  O   LEU    48      40.277  19.207  76.743  1.00 53.81           O  
ATOM    395  N   LEU    49      40.848  17.284  77.861  1.00 54.68           N  
ATOM    396  CA  LEU    49      42.275  17.456  77.786  1.00 54.64           C  
ATOM    397  CB  LEU    49      42.880  17.652  79.191  1.00 54.46           C  
ATOM    398  CG  LEU    49      42.481  18.866  80.090  1.00 54.75           C  
ATOM    399  CD1 LEU    49      41.544  18.487  81.228  1.00 54.38           C  
ATOM    400  CD2 LEU    49      43.679  19.531  80.733  1.00 53.91           C  
ATOM    401  C   LEU    49      42.763  16.170  77.158  1.00 54.77           C  
ATOM    402  O   LEU    49      42.695  15.148  77.805  1.00 55.28           O  
ATOM    403  N   SER    50      43.180  16.195  75.887  1.00 55.11           N  
ATOM    404  CA  SER    50      43.627  14.980  75.187  1.00 55.13           C  
ATOM    405  CB  SER    50      42.922  14.718  73.833  1.00 55.43           C  
ATOM    406  OG  SER    50      42.979  13.316  73.443  1.00 55.38           O  
ATOM    407  C   SER    50      45.065  15.129  74.914  1.00 55.23           C  
ATOM    408  O   SER    50      45.523  16.156  74.563  1.00 54.98           O  
ATOM    409  N   ILE    51      45.756  14.037  75.027  1.00 56.18           N  
ATOM    410  CA  ILE    51      47.194  13.984  74.961  1.00 57.13           C  
ATOM    411  CB  ILE    51      47.629  13.244  76.267  1.00 58.14           C  
ATOM    412  CG1 ILE    51      49.109  13.195  76.579  1.00 59.01           C  
ATOM    413  CD1 ILE    51      49.432  11.753  77.400  1.00 56.43           C  
ATOM    414  CG2 ILE    51      47.216  11.708  76.220  1.00 59.85           C  
ATOM    415  C   ILE    51      47.473  13.147  73.692  1.00 57.18           C  
ATOM    416  O   ILE    51      48.608  12.754  73.430  1.00 57.45           O  
ATOM    417  N   HIS    52      46.418  12.863  72.914  1.00 56.66           N  
ATOM    418  CA  HIS    52      46.497  11.896  71.834  1.00 56.03           C  
ATOM    419  CB  HIS    52      45.117  11.741  71.242  1.00 55.61           C  
ATOM    420  CG  HIS    52      45.070  10.764  70.130  1.00 55.02           C  
ATOM    421  ND1 HIS    52      44.714   9.446  70.319  1.00 56.08           N  
ATOM    422  CE1 HIS    52      44.797   8.804  69.167  1.00 54.33           C  
ATOM    423  NE2 HIS    52      45.222   9.654  68.250  1.00 53.71           N  
ATOM    424  CD2 HIS    52      45.414  10.881  68.830  1.00 53.86           C  
ATOM    425  C   HIS    52      47.506  12.352  70.746  1.00 56.08           C  
ATOM    426  O   HIS    52      47.529  13.543  70.370  1.00 55.75           O  
ATOM    427  N   PRO    53      48.356  11.424  70.253  1.00 55.85           N  
ATOM    428  CA  PRO    53      49.508  11.767  69.399  1.00 56.16           C  
ATOM    429  CB  PRO    53      50.126  10.436  69.079  1.00 55.40           C  
ATOM    430  CG  PRO    53      49.125   9.437  69.442  1.00 55.40           C  
ATOM    431  CD  PRO    53      48.297   9.982  70.500  1.00 56.13           C  
ATOM    432  C   PRO    53      49.137  12.520  68.130  1.00 56.78           C  
ATOM    433  O   PRO    53      49.891  13.383  67.645  1.00 56.74           O  
ATOM    434  N   ASN    54      47.957  12.231  67.612  1.00 57.18           N  
ATOM    435  CA  ASN    54      47.420  13.055  66.535  1.00 57.26           C  
ATOM    436  CB  ASN    54      46.678  12.155  65.591  1.00 58.02           C  
ATOM    437  CG  ASN    54      47.584  11.082  65.047  1.00 58.44           C  
ATOM    438  OD1 ASN    54      48.740  11.393  64.718  1.00 59.50           O  
ATOM    439  ND2 ASN    54      47.109   9.820  64.991  1.00 55.89           N  
ATOM    440  C   ASN    54      46.532  14.165  66.977  1.00 57.44           C  
ATOM    441  O   ASN    54      46.717  15.261  66.511  1.00 57.35           O  
ATOM    442  N   PHE    55      45.625  13.898  67.932  1.00 57.32           N  
ATOM    443  CA  PHE    55      44.505  14.792  68.226  1.00 56.75           C  
ATOM    444  CB  PHE    55      43.232  13.994  68.365  1.00 55.96           C  
ATOM    445  CG  PHE    55      43.023  12.979  67.271  1.00 56.71           C  
ATOM    446  CD1 PHE    55      43.590  13.127  66.031  1.00 55.44           C  
ATOM    447  CE1 PHE    55      43.366  12.175  65.071  1.00 54.75           C  
ATOM    448  CZ  PHE    55      42.578  11.094  65.334  1.00 53.41           C  
ATOM    449  CE2 PHE    55      42.015  10.941  66.534  1.00 52.77           C  
ATOM    450  CD2 PHE    55      42.216  11.862  67.491  1.00 55.99           C  
ATOM    451  C   PHE    55      44.683  15.626  69.482  1.00 56.52           C  
ATOM    452  O   PHE    55      43.747  16.298  69.913  1.00 55.71           O  
ATOM    453  N   SER    56      45.872  15.602  70.067  1.00 56.67           N  
ATOM    454  CA  SER    56      46.133  16.406  71.255  1.00 57.06           C  
ATOM    455  CB  SER    56      47.606  16.719  71.362  1.00 57.42           C  
ATOM    456  OG  SER    56      48.136  15.997  72.438  1.00 60.13           O  
ATOM    457  C   SER    56      45.446  17.729  71.184  1.00 56.99           C  
ATOM    458  O   SER    56      45.559  18.358  70.175  1.00 58.26           O  
ATOM    459  N   ARG    57      44.824  18.190  72.272  1.00 56.94           N  
ATOM    460  CA  ARG    57      44.007  19.414  72.284  1.00 55.70           C  
ATOM    461  CB  ARG    57      42.893  19.274  71.253  1.00 55.59           C  
ATOM    462  CG  ARG    57      41.847  18.226  71.575  1.00 54.03           C  
ATOM    463  CD  ARG    57      40.923  18.072  70.413  1.00 54.46           C  
ATOM    464  NE  ARG    57      39.737  17.290  70.710  1.00 53.80           N  
ATOM    465  CZ  ARG    57      39.699  15.959  70.764  1.00 52.85           C  
ATOM    466  NH1 ARG    57      40.775  15.190  70.526  1.00 50.20           N  
ATOM    467  NH2 ARG    57      38.541  15.393  71.044  1.00 53.47           N  
ATOM    468  C   ARG    57      43.329  19.698  73.639  1.00 55.42           C  
ATOM    469  O   ARG    57      43.312  18.838  74.520  1.00 54.72           O  
ATOM    470  N   LEU    58      42.702  20.879  73.749  1.00 55.44           N  
ATOM    471  CA  LEU    58      42.015  21.337  74.951  1.00 55.73           C  
ATOM    472  CB  LEU    58      42.926  22.290  75.745  1.00 55.55           C  
ATOM    473  CG  LEU    58      42.248  23.151  76.832  1.00 56.27           C  
ATOM    474  CD1 LEU    58      41.875  22.288  78.096  1.00 55.17           C  
ATOM    475  CD2 LEU    58      43.169  24.310  77.175  1.00 55.96           C  
ATOM    476  C   LEU    58      40.712  22.042  74.574  1.00 56.36           C  
ATOM    477  O   LEU    58      40.708  23.011  73.804  1.00 57.17           O  
ATOM    478  N   GLN    59      39.596  21.590  75.114  1.00 56.24           N  
ATOM    479  CA  GLN    59      38.376  22.192  74.684  1.00 56.41           C  
ATOM    480  CB  GLN    59      38.020  21.552  73.331  1.00 56.53           C  
ATOM    481  CG  GLN    59      36.924  20.485  73.393  1.00 57.15           C  
ATOM    482  CD  GLN    59      36.826  19.585  72.185  1.00 55.76           C  
ATOM    483  OE1 GLN    59      37.803  18.996  71.738  1.00 54.85           O  
ATOM    484  NE2 GLN    59      35.618  19.405  71.711  1.00 52.59           N  
ATOM    485  C   GLN    59      37.328  21.923  75.752  1.00 57.03           C  
ATOM    486  O   GLN    59      37.551  21.079  76.620  1.00 58.14           O  
ATOM    487  N   LEU    60      36.214  22.640  75.724  1.00 56.65           N  
ATOM    488  CA  LEU    60      35.002  22.174  76.376  1.00 56.96           C  
ATOM    489  CB  LEU    60      34.114  23.353  76.758  1.00 57.22           C  
ATOM    490  CG  LEU    60      34.447  24.114  78.039  1.00 57.89           C  
ATOM    491  CD1 LEU    60      35.967  24.155  78.245  1.00 60.20           C  
ATOM    492  CD2 LEU    60      33.851  25.485  77.938  1.00 56.16           C  
ATOM    493  C   LEU    60      34.249  21.313  75.385  1.00 57.37           C  
ATOM    494  O   LEU    60      34.276  21.615  74.234  1.00 58.70           O  
ATOM    495  N   THR    61      33.509  20.322  75.828  1.00 58.09           N  
ATOM    496  CA  THR    61      32.774  19.512  74.891  1.00 58.39           C  
ATOM    497  CB  THR    61      33.527  18.264  74.564  1.00 59.47           C  
ATOM    498  OG1 THR    61      32.738  17.465  73.688  1.00 59.79           O  
ATOM    499  CG2 THR    61      33.777  17.497  75.800  1.00 58.16           C  
ATOM    500  C   THR    61      31.434  19.079  75.400  1.00 58.30           C  
ATOM    501  O   THR    61      31.033  19.436  76.480  1.00 57.77           O  
ATOM    502  N   THR    62      30.748  18.294  74.587  1.00 58.42           N  
ATOM    503  CA  THR    62      29.474  17.707  74.943  1.00 58.64           C  
ATOM    504  CB  THR    62      28.391  18.269  74.125  1.00 58.50           C  
ATOM    505  OG1 THR    62      28.348  19.673  74.353  1.00 57.46           O  
ATOM    506  CG2 THR    62      27.113  17.671  74.563  1.00 58.50           C  
ATOM    507  C   THR    62      29.552  16.217  74.717  1.00 58.81           C  
ATOM    508  O   THR    62      30.006  15.776  73.692  1.00 59.38           O  
ATOM    509  N   LYS    63      29.149  15.439  75.701  1.00 20.00           N  
ATOM    510  CA  LYS    63      29.625  14.085  75.801  1.00 20.00           C  
ATOM    511  C   LYS    63      30.795  13.957  74.857  1.00 20.00           C  
ATOM    512  CB  LYS    63      28.552  13.050  75.502  1.00 20.00           C  
ATOM    513  CG  LYS    63      28.440  11.964  76.552  1.00 20.00           C  
ATOM    514  CD  LYS    63      29.630  11.030  76.541  1.00 20.00           C  
ATOM    515  CE  LYS    63      30.376  11.037  77.871  1.00 20.00           C  
ATOM    516  NZ  LYS    63      30.014   9.929  78.800  1.00 20.00           N  
ATOM    517  O   LYS    63      30.649  13.575  73.710  1.00 20.00           O  
ATOM    518  N   PRO    71      37.478   3.642  87.428  1.00 50.25           N  
ATOM    519  CA  PRO    71      38.321   4.910  87.441  1.00 51.35           C  
ATOM    520  CB  PRO    71      37.810   5.765  88.633  1.00 50.40           C  
ATOM    521  CG  PRO    71      36.648   4.920  89.269  1.00 51.34           C  
ATOM    522  CD  PRO    71      36.375   3.669  88.402  1.00 50.37           C  
ATOM    523  C   PRO    71      39.780   4.562  87.675  1.00 52.17           C  
ATOM    524  O   PRO    71      40.107   3.937  88.715  1.00 53.55           O  
ATOM    525  N   PRO    72      40.649   4.848  86.689  1.00 51.99           N  
ATOM    526  CA  PRO    72      42.075   4.487  86.790  1.00 51.09           C  
ATOM    527  CB  PRO    72      42.494   4.368  85.334  1.00 51.17           C  
ATOM    528  CG  PRO    72      41.585   5.296  84.590  1.00 51.71           C  
ATOM    529  CD  PRO    72      40.302   5.390  85.362  1.00 51.95           C  
ATOM    530  C   PRO    72      43.008   5.459  87.528  1.00 51.00           C  
ATOM    531  O   PRO    72      42.705   6.643  87.706  1.00 51.31           O  
ATOM    532  N   MET    73      44.167   4.913  87.894  1.00 50.64           N  
ATOM    533  CA  MET    73      45.183   5.528  88.722  1.00 49.81           C  
ATOM    534  CB  MET    73      46.481   4.795  88.433  1.00 49.51           C  
ATOM    535  CG  MET    73      47.701   5.214  89.184  1.00 52.15           C  
ATOM    536  SD  MET    73      48.420   6.765  88.541  1.00 63.33           S  
ATOM    537  CE  MET    73      49.562   6.247  87.215  1.00 59.65           C  
ATOM    538  C   MET    73      45.308   7.022  88.493  1.00 49.88           C  
ATOM    539  O   MET    73      45.244   7.838  89.427  1.00 49.83           O  
ATOM    540  N   PHE    74      45.481   7.412  87.242  1.00 49.60           N  
ATOM    541  CA  PHE    74      45.891   8.768  86.984  1.00 49.07           C  
ATOM    542  CB  PHE    74      46.277   8.909  85.561  1.00 49.06           C  
ATOM    543  CG  PHE    74      46.842  10.211  85.243  1.00 49.13           C  
ATOM    544  CD1 PHE    74      48.137  10.532  85.654  1.00 49.75           C  
ATOM    545  CE1 PHE    74      48.696  11.825  85.332  1.00 49.96           C  
ATOM    546  CZ  PHE    74      47.954  12.751  84.576  1.00 48.90           C  
ATOM    547  CE2 PHE    74      46.673  12.409  84.158  1.00 49.31           C  
ATOM    548  CD2 PHE    74      46.115  11.134  84.500  1.00 48.36           C  
ATOM    549  C   PHE    74      44.764   9.715  87.322  1.00 49.32           C  
ATOM    550  O   PHE    74      44.987  10.790  87.897  1.00 49.88           O  
ATOM    551  N   ALA    75      43.549   9.296  86.980  1.00 49.07           N  
ATOM    552  CA  ALA    75      42.323  10.017  87.342  1.00 48.50           C  
ATOM    553  CB  ALA    75      41.097   9.336  86.722  1.00 47.72           C  
ATOM    554  C   ALA    75      42.197  10.068  88.868  1.00 48.18           C  
ATOM    555  O   ALA    75      41.867  11.121  89.418  1.00 48.06           O  
ATOM    556  N   ARG    76      42.491   8.940  89.533  1.00 47.54           N  
ATOM    557  CA  ARG    76      42.503   8.866  91.001  1.00 47.64           C  
ATOM    558  CB  ARG    76      43.007   7.508  91.489  1.00 46.96           C  
ATOM    559  CG  ARG    76      42.015   6.404  91.608  1.00 46.60           C  
ATOM    560  CD  ARG    76      42.598   5.316  92.538  1.00 49.17           C  
ATOM    561  NE  ARG    76      43.675   4.509  91.936  1.00 50.38           N  
ATOM    562  CZ  ARG    76      43.477   3.579  90.978  1.00 52.45           C  
ATOM    563  NH1 ARG    76      42.250   3.350  90.479  1.00 52.35           N  
ATOM    564  NH2 ARG    76      44.514   2.885  90.477  1.00 51.78           N  
ATOM    565  C   ARG    76      43.426   9.964  91.564  1.00 47.30           C  
ATOM    566  O   ARG    76      43.009  10.829  92.366  1.00 45.64           O  
ATOM    567  N   VAL    77      44.672   9.945  91.096  1.00 47.65           N  
ATOM    568  CA  VAL    77      45.620  10.891  91.595  1.00 48.28           C  
ATOM    569  CB  VAL    77      46.935  10.906  90.879  1.00 48.36           C  
ATOM    570  CG1 VAL    77      47.756  12.047  91.435  1.00 47.16           C  
ATOM    571  CG2 VAL    77      47.650   9.563  90.999  1.00 47.35           C  
ATOM    572  C   VAL    77      45.037  12.252  91.414  1.00 49.86           C  
ATOM    573  O   VAL    77      45.118  13.098  92.302  1.00 51.05           O  
ATOM    574  N   PHE    78      44.441  12.490  90.262  1.00 51.07           N  
ATOM    575  CA  PHE    78      43.859  13.801  90.022  1.00 51.73           C  
ATOM    576  CB  PHE    78      43.374  13.836  88.600  1.00 52.17           C  
ATOM    577  CG  PHE    78      44.296  14.543  87.672  1.00 52.76           C  
ATOM    578  CD1 PHE    78      45.678  14.265  87.695  1.00 54.23           C  
ATOM    579  CE1 PHE    78      46.557  14.897  86.787  1.00 53.05           C  
ATOM    580  CZ  PHE    78      46.028  15.798  85.868  1.00 52.65           C  
ATOM    581  CE2 PHE    78      44.632  16.058  85.828  1.00 50.38           C  
ATOM    582  CD2 PHE    78      43.783  15.437  86.719  1.00 50.44           C  
ATOM    583  C   PHE    78      42.722  14.231  90.992  1.00 51.67           C  
ATOM    584  O   PHE    78      42.708  15.357  91.493  1.00 51.56           O  
ATOM    585  N   ARG    79      41.786  13.340  91.241  1.00 51.57           N  
ATOM    586  CA  ARG    79      40.762  13.592  92.224  1.00 52.51           C  
ATOM    587  CB  ARG    79      39.906  12.374  92.348  1.00 52.29           C  
ATOM    588  CG  ARG    79      39.290  11.991  91.043  1.00 54.30           C  
ATOM    589  CD  ARG    79      38.543  10.668  91.092  1.00 54.76           C  
ATOM    590  NE  ARG    79      37.459  10.687  90.118  1.00 56.06           N  
ATOM    591  CZ  ARG    79      36.567   9.728  89.922  1.00 56.84           C  
ATOM    592  NH1 ARG    79      36.535   8.611  90.634  1.00 58.13           N  
ATOM    593  NH2 ARG    79      35.670   9.917  88.988  1.00 59.73           N  
ATOM    594  C   ARG    79      41.319  13.911  93.601  1.00 52.45           C  
ATOM    595  O   ARG    79      40.887  14.876  94.235  1.00 52.69           O  
ATOM    596  N   LYS    80      42.267  13.098  94.055  1.00 52.49           N  
ATOM    597  CA  LYS    80      42.938  13.308  95.331  1.00 53.40           C  
ATOM    598  CB  LYS    80      44.197  12.479  95.367  1.00 53.75           C  
ATOM    599  CG  LYS    80      44.561  11.902  96.722  1.00 57.46           C  
ATOM    600  CD  LYS    80      46.025  11.266  96.784  1.00 57.32           C  
ATOM    601  CE  LYS    80      47.044  12.156  97.572  1.00 60.50           C  
ATOM    602  NZ  LYS    80      47.723  11.350  98.642  1.00 63.38           N  
ATOM    603  C   LYS    80      43.376  14.736  95.513  1.00 53.23           C  
ATOM    604  O   LYS    80      43.104  15.366  96.509  1.00 54.11           O  
ATOM    605  N   HIS    81      44.065  15.270  94.521  1.00 53.54           N  
ATOM    606  CA  HIS    81      44.648  16.603  94.635  1.00 52.51           C  
ATOM    607  CB  HIS    81      45.916  16.663  93.828  1.00 51.77           C  
ATOM    608  CG  HIS    81      47.007  15.790  94.339  1.00 49.04           C  
ATOM    609  ND1 HIS    81      48.115  16.300  94.981  1.00 46.60           N  
ATOM    610  CE1 HIS    81      48.934  15.304  95.276  1.00 47.32           C  
ATOM    611  NE2 HIS    81      48.406  14.175  94.836  1.00 47.09           N  
ATOM    612  CD2 HIS    81      47.208  14.456  94.230  1.00 47.44           C  
ATOM    613  C   HIS    81      43.770  17.734  94.154  1.00 52.57           C  
ATOM    614  O   HIS    81      44.011  18.879  94.539  1.00 52.74           O  
ATOM    615  N   LEU    82      42.809  17.460  93.278  1.00 52.37           N  
ATOM    616  CA  LEU    82      42.082  18.556  92.607  1.00 52.92           C  
ATOM    617  CB  LEU    82      42.320  18.504  91.101  1.00 52.71           C  
ATOM    618  CG  LEU    82      43.789  18.444  90.660  1.00 52.75           C  
ATOM    619  CD1 LEU    82      43.913  18.394  89.146  1.00 50.34           C  
ATOM    620  CD2 LEU    82      44.601  19.606  91.241  1.00 49.98           C  
ATOM    621  C   LEU    82      40.593  18.577  92.887  1.00 52.93           C  
ATOM    622  O   LEU    82      39.996  19.614  93.005  1.00 52.31           O  
ATOM    623  N   GLU    83      39.996  17.409  93.021  1.00 54.06           N  
ATOM    624  CA  GLU    83      38.576  17.320  93.247  1.00 54.94           C  
ATOM    625  CB  GLU    83      38.157  15.868  93.376  1.00 54.78           C  
ATOM    626  CG  GLU    83      36.737  15.603  92.979  1.00 58.54           C  
ATOM    627  CD  GLU    83      36.464  14.084  92.738  1.00 60.66           C  
ATOM    628  OE1 GLU    83      36.528  13.645  91.535  1.00 66.54           O  
ATOM    629  OE2 GLU    83      36.185  13.336  93.746  1.00 68.09           O  
ATOM    630  C   GLU    83      38.345  18.082  94.518  1.00 53.84           C  
ATOM    631  O   GLU    83      39.020  17.858  95.552  1.00 55.35           O  
ATOM    632  N   GLY    84      37.430  19.024  94.422  1.00 52.39           N  
ATOM    633  CA  GLY    84      37.190  19.964  95.494  1.00 50.70           C  
ATOM    634  C   GLY    84      37.617  21.389  95.208  1.00 49.54           C  
ATOM    635  O   GLY    84      36.910  22.314  95.592  1.00 48.01           O  
ATOM    636  N   GLY    85      38.753  21.541  94.522  1.00 48.81           N  
ATOM    637  CA  GLY    85      39.471  22.814  94.367  1.00 48.64           C  
ATOM    638  C   GLY    85      38.795  23.893  93.557  1.00 48.42           C  
ATOM    639  O   GLY    85      37.795  23.674  92.855  1.00 48.06           O  
ATOM    640  N   ILE    86      39.330  25.088  93.685  1.00 48.31           N  
ATOM    641  CA  ILE    86      38.887  26.168  92.875  1.00 49.46           C  
ATOM    642  CB  ILE    86      38.606  27.442  93.706  1.00 48.98           C  
ATOM    643  CG1 ILE    86      37.609  27.134  94.801  1.00 47.71           C  
ATOM    644  CD1 ILE    86      36.335  26.563  94.386  1.00 48.01           C  
ATOM    645  CG2 ILE    86      38.114  28.600  92.835  1.00 47.30           C  
ATOM    646  C   ILE    86      39.978  26.456  91.865  1.00 50.23           C  
ATOM    647  O   ILE    86      41.188  26.261  92.135  1.00 49.68           O  
ATOM    648  N   ILE    87      39.519  26.927  90.704  1.00 51.44           N  
ATOM    649  CA  ILE    87      40.418  27.267  89.597  1.00 52.03           C  
ATOM    650  CB  ILE    87      39.831  27.010  88.147  1.00 51.94           C  
ATOM    651  CG1 ILE    87      39.798  25.506  87.862  1.00 51.90           C  
ATOM    652  CD1 ILE    87      38.527  25.020  87.181  1.00 52.15           C  
ATOM    653  CG2 ILE    87      40.721  27.602  87.149  1.00 52.00           C  
ATOM    654  C   ILE    87      40.720  28.699  89.816  1.00 52.31           C  
ATOM    655  O   ILE    87      39.869  29.545  89.787  1.00 51.61           O  
ATOM    656  N   GLU    88      41.966  28.934  90.089  1.00 53.32           N  
ATOM    657  CA  GLU    88      42.416  30.278  90.337  1.00 54.36           C  
ATOM    658  CB  GLU    88      43.633  30.263  91.282  1.00 54.89           C  
ATOM    659  CG  GLU    88      43.387  29.574  92.589  1.00 56.82           C  
ATOM    660  CD  GLU    88      43.845  30.419  93.725  1.00 59.84           C  
ATOM    661  OE1 GLU    88      45.088  30.669  93.787  1.00 61.47           O  
ATOM    662  OE2 GLU    88      42.963  30.848  94.529  1.00 61.40           O  
ATOM    663  C   GLU    88      42.851  30.969  89.079  1.00 53.55           C  
ATOM    664  O   GLU    88      42.875  32.170  89.066  1.00 52.04           O  
ATOM    665  N   SER    89      43.307  30.195  88.095  1.00 54.01           N  
ATOM    666  CA  SER    89      43.869  30.721  86.851  1.00 54.46           C  
ATOM    667  CB  SER    89      45.199  31.415  87.059  1.00 53.73           C  
ATOM    668  OG  SER    89      46.102  31.131  86.029  1.00 51.27           O  
ATOM    669  C   SER    89      44.020  29.630  85.801  1.00 56.00           C  
ATOM    670  O   SER    89      44.327  28.452  86.138  1.00 56.94           O  
ATOM    671  N   ILE    90      43.742  30.043  84.543  1.00 56.33           N  
ATOM    672  CA  ILE    90      44.029  29.286  83.330  1.00 55.44           C  
ATOM    673  CB  ILE    90      42.800  28.891  82.635  1.00 55.50           C  
ATOM    674  CG1 ILE    90      41.841  28.161  83.598  1.00 56.02           C  
ATOM    675  CD1 ILE    90      40.418  27.918  83.015  1.00 54.97           C  
ATOM    676  CG2 ILE    90      43.181  28.014  81.481  1.00 56.94           C  
ATOM    677  C   ILE    90      44.731  30.236  82.409  1.00 55.92           C  
ATOM    678  O   ILE    90      44.225  31.310  82.118  1.00 55.99           O  
ATOM    679  N   LYS    91      45.917  29.850  81.963  1.00 56.75           N  
ATOM    680  CA  LYS    91      46.808  30.747  81.273  1.00 56.83           C  
ATOM    681  CB  LYS    91      47.592  31.557  82.331  1.00 56.54           C  
ATOM    682  CG  LYS    91      48.909  30.877  82.750  1.00 59.63           C  
ATOM    683  CD  LYS    91      49.536  31.197  84.144  1.00 59.00           C  
ATOM    684  CE  LYS    91      49.090  30.117  85.200  1.00 65.51           C  
ATOM    685  NZ  LYS    91      50.220  29.468  86.061  1.00 66.86           N  
ATOM    686  C   LYS    91      47.704  29.922  80.288  1.00 56.38           C  
ATOM    687  O   LYS    91      47.785  28.710  80.327  1.00 55.46           O  
ATOM    688  N   GLN    92      48.326  30.614  79.349  1.00 57.46           N  
ATOM    689  CA  GLN    92      49.128  30.028  78.281  1.00 57.17           C  
ATOM    690  CB  GLN    92      48.703  30.598  76.909  1.00 57.39           C  
ATOM    691  CG  GLN    92      49.577  30.169  75.672  1.00 58.49           C  
ATOM    692  CD  GLN    92      49.317  31.016  74.394  1.00 59.09           C  
ATOM    693  OE1 GLN    92      48.552  31.991  74.416  1.00 62.09           O  
ATOM    694  NE2 GLN    92      49.952  30.632  73.288  1.00 59.92           N  
ATOM    695  C   GLN    92      50.494  30.476  78.587  1.00 56.47           C  
ATOM    696  O   GLN    92      50.659  31.600  79.010  1.00 56.30           O  
ATOM    697  N   ILE    93      51.486  29.621  78.363  1.00 56.35           N  
ATOM    698  CA  ILE    93      52.869  30.020  78.619  1.00 56.58           C  
ATOM    699  CB  ILE    93      53.740  28.881  79.140  1.00 55.61           C  
ATOM    700  CG1 ILE    93      53.019  28.172  80.303  1.00 56.40           C  
ATOM    701  CD1 ILE    93      52.332  29.063  81.401  1.00 48.92           C  
ATOM    702  CG2 ILE    93      55.022  29.420  79.638  1.00 54.62           C  
ATOM    703  C   ILE    93      53.428  30.624  77.358  1.00 56.78           C  
ATOM    704  O   ILE    93      53.649  29.947  76.370  1.00 57.12           O  
ATOM    705  N   GLY    94      53.624  31.928  77.405  1.00 57.84           N  
ATOM    706  CA  GLY    94      54.054  32.694  76.242  1.00 58.56           C  
ATOM    707  C   GLY    94      53.043  32.528  75.136  1.00 58.77           C  
ATOM    708  O   GLY    94      51.796  32.497  75.375  1.00 56.82           O  
ATOM    709  N   ASN    95      53.611  32.371  73.930  1.00 60.11           N  
ATOM    710  CA  ASN    95      52.822  31.922  72.737  1.00 60.51           C  
ATOM    711  CB  ASN    95      53.087  32.828  71.500  1.00 60.81           C  
ATOM    712  CG  ASN    95      52.133  32.554  70.345  1.00 60.97           C  
ATOM    713  OD1 ASN    95      50.893  32.532  70.495  1.00 59.33           O  
ATOM    714  ND2 ASN    95      52.726  32.322  69.170  1.00 60.23           N  
ATOM    715  C   ASN    95      52.963  30.418  72.422  1.00 60.00           C  
ATOM    716  O   ASN    95      52.571  30.011  71.366  1.00 58.66           O  
ATOM    717  N   ASP    96      53.416  29.610  73.393  1.00 60.99           N  
ATOM    718  CA  ASP    96      53.685  28.200  73.174  1.00 61.06           C  
ATOM    719  CB  ASP    96      54.712  27.610  74.145  1.00 60.77           C  
ATOM    720  CG  ASP    96      55.282  26.271  73.627  1.00 63.14           C  
ATOM    721  OD1 ASP    96      55.022  25.960  72.434  1.00 68.10           O  
ATOM    722  OD2 ASP    96      55.954  25.484  74.358  1.00 65.50           O  
ATOM    723  C   ASP    96      52.398  27.444  73.223  1.00 60.43           C  
ATOM    724  O   ASP    96      51.374  28.025  73.489  1.00 59.12           O  
ATOM    725  N   ARG    97      52.462  26.170  72.864  1.00 61.62           N  
ATOM    726  CA  ARG    97      51.317  25.253  72.883  1.00 64.01           C  
ATOM    727  CB  ARG    97      51.411  24.216  71.740  1.00 65.42           C  
ATOM    728  CG  ARG    97      51.420  24.679  70.281  1.00 65.65           C  
ATOM    729  CD  ARG    97      52.449  23.795  69.471  1.00 68.64           C  
ATOM    730  NE  ARG    97      52.086  23.774  68.050  1.00 74.49           N  
ATOM    731  CZ  ARG    97      52.607  24.522  67.031  1.00 78.19           C  
ATOM    732  NH1 ARG    97      53.628  25.383  67.216  1.00 79.05           N  
ATOM    733  NH2 ARG    97      52.112  24.385  65.783  1.00 75.89           N  
ATOM    734  C   ARG    97      51.206  24.485  74.275  1.00 63.98           C  
ATOM    735  O   ARG    97      51.228  23.223  74.365  1.00 62.52           O  
ATOM    736  N   ARG    98      51.025  25.321  75.299  1.00 64.13           N  
ATOM    737  CA  ARG    98      51.058  25.006  76.688  1.00 64.57           C  
ATOM    738  CB  ARG    98      52.433  25.305  77.208  1.00 64.62           C  
ATOM    739  CG  ARG    98      53.385  24.229  76.892  1.00 66.51           C  
ATOM    740  CD  ARG    98      54.838  24.689  76.922  1.00 67.98           C  
ATOM    741  NE  ARG    98      55.405  24.783  78.266  1.00 70.82           N  
ATOM    742  CZ  ARG    98      56.241  25.747  78.664  1.00 72.02           C  
ATOM    743  NH1 ARG    98      56.598  26.711  77.833  1.00 70.08           N  
ATOM    744  NH2 ARG    98      56.722  25.752  79.913  1.00 74.67           N  
ATOM    745  C   ARG    98      50.036  25.838  77.495  1.00 64.32           C  
ATOM    746  O   ARG    98      50.012  27.086  77.458  1.00 63.18           O  
ATOM    747  N   ILE    99      49.195  25.102  78.214  1.00 63.89           N  
ATOM    748  CA  ILE    99      48.247  25.683  79.113  1.00 63.37           C  
ATOM    749  CB  ILE    99      46.800  25.397  78.689  1.00 63.81           C  
ATOM    750  CG1 ILE    99      46.616  25.593  77.170  1.00 65.37           C  
ATOM    751  CD1 ILE    99      46.775  24.321  76.298  1.00 66.90           C  
ATOM    752  CG2 ILE    99      45.835  26.300  79.476  1.00 63.47           C  
ATOM    753  C   ILE    99      48.506  25.091  80.533  1.00 63.03           C  
ATOM    754  O   ILE    99      48.784  23.889  80.712  1.00 61.85           O  
ATOM    755  N   GLU   100      48.407  26.006  81.505  1.00 61.99           N  
ATOM    756  CA  GLU   100      48.579  25.780  82.894  1.00 60.89           C  
ATOM    757  CB  GLU   100      49.796  26.543  83.356  1.00 60.38           C  
ATOM    758  CG  GLU   100      51.038  25.911  82.874  1.00 61.02           C  
ATOM    759  CD  GLU   100      52.295  26.246  83.694  1.00 62.14           C  
ATOM    760  OE1 GLU   100      52.238  26.875  84.783  1.00 62.87           O  
ATOM    761  OE2 GLU   100      53.368  25.831  83.219  1.00 64.97           O  
ATOM    762  C   GLU   100      47.314  26.267  83.607  1.00 60.31           C  
ATOM    763  O   GLU   100      46.937  27.466  83.531  1.00 60.20           O  
ATOM    764  N   ILE   101      46.655  25.319  84.274  1.00 59.15           N  
ATOM    765  CA  ILE   101      45.534  25.621  85.124  1.00 58.72           C  
ATOM    766  CB  ILE   101      44.380  24.650  84.965  1.00 59.08           C  
ATOM    767  CG1 ILE   101      44.056  24.448  83.484  1.00 57.20           C  
ATOM    768  CD1 ILE   101      43.372  23.143  83.207  1.00 55.61           C  
ATOM    769  CG2 ILE   101      43.185  25.163  85.764  1.00 58.05           C  
ATOM    770  C   ILE   101      46.008  25.482  86.551  1.00 58.80           C  
ATOM    771  O   ILE   101      46.553  24.439  86.922  1.00 58.69           O  
ATOM    772  N   ASP   102      45.746  26.549  87.317  1.00 58.60           N  
ATOM    773  CA  ASP   102      46.131  26.733  88.712  1.00 57.95           C  
ATOM    774  CB  ASP   102      46.587  28.171  88.913  1.00 58.34           C  
ATOM    775  CG  ASP   102      48.043  28.413  88.462  1.00 62.98           C  
ATOM    776  OD1 ASP   102      48.771  27.474  87.982  1.00 67.58           O  
ATOM    777  OD2 ASP   102      48.461  29.591  88.608  1.00 68.35           O  
ATOM    778  C   ASP   102      44.943  26.454  89.614  1.00 56.93           C  
ATOM    779  O   ASP   102      43.920  27.155  89.594  1.00 55.95           O  
ATOM    780  N   ILE   103      45.062  25.400  90.404  1.00 56.98           N  
ATOM    781  CA  ILE   103      43.998  25.037  91.354  1.00 56.62           C  
ATOM    782  CB  ILE   103      43.415  23.646  91.052  1.00 56.52           C  
ATOM    783  CG1 ILE   103      42.819  23.617  89.616  1.00 55.39           C  
ATOM    784  CD1 ILE   103      42.870  22.271  88.891  1.00 53.75           C  
ATOM    785  CG2 ILE   103      42.338  23.302  92.091  1.00 56.78           C  
ATOM    786  C   ILE   103      44.495  25.170  92.814  1.00 56.66           C  
ATOM    787  O   ILE   103      45.646  24.882  93.123  1.00 55.87           O  
ATOM    788  N   LYS   104      43.625  25.709  93.673  1.00 57.01           N  
ATOM    789  CA  LYS   104      43.838  25.712  95.121  1.00 56.75           C  
ATOM    790  CB  LYS   104      43.698  27.144  95.634  1.00 57.17           C  
ATOM    791  CG  LYS   104      43.611  27.280  97.155  1.00 58.00           C  
ATOM    792  CD  LYS   104      43.543  28.768  97.534  1.00 58.86           C  
ATOM    793  CE  LYS   104      43.438  28.981  99.053  1.00 60.37           C  
ATOM    794  NZ  LYS   104      43.736  30.389  99.345  1.00 59.40           N  
ATOM    795  C   LYS   104      42.829  24.748  95.761  1.00 55.51           C  
ATOM    796  O   LYS   104      41.674  24.803  95.440  1.00 55.28           O  
ATOM    797  N   SER   105      43.257  23.838  96.602  1.00 20.00           N  
ATOM    798  CA  SER   105      42.389  22.798  97.141  1.00 20.00           C  
ATOM    799  C   SER   105      42.783  22.436  98.570  1.00 20.00           C  
ATOM    800  CB  SER   105      42.428  21.552  96.253  1.00 20.00           C  
ATOM    801  OG  SER   105      43.723  20.977  96.242  1.00 20.00           O  
ATOM    802  O   SER   105      43.682  23.077  99.145  1.00 54.88           O  
ATOM    803  N   LYS   106      42.183  21.420  99.164  1.00 55.20           N  
ATOM    804  CA  LYS   106      42.545  20.877 100.474  1.00 55.13           C  
ATOM    805  CB  LYS   106      41.285  20.725 101.359  1.00 56.44           C  
ATOM    806  CG  LYS   106      40.428  22.005 101.607  1.00 58.68           C  
ATOM    807  CD  LYS   106      41.243  23.145 102.268  1.00 61.06           C  
ATOM    808  CE  LYS   106      40.363  24.308 102.761  1.00 61.81           C  
ATOM    809  NZ  LYS   106      39.111  23.846 103.438  1.00 62.79           N  
ATOM    810  C   LYS   106      43.087  19.481 100.337  1.00 53.77           C  
ATOM    811  O   LYS   106      42.550  18.697  99.558  1.00 53.70           O  
ATOM    812  N   ASP   107      44.084  19.138 101.146  1.00 52.33           N  
ATOM    813  CA  ASP   107      44.429  17.751 101.325  1.00 51.88           C  
ATOM    814  CB  ASP   107      45.864  17.548 101.776  1.00 52.06           C  
ATOM    815  CG  ASP   107      46.149  18.039 103.154  1.00 53.31           C  
ATOM    816  OD1 ASP   107      45.285  18.082 104.050  1.00 56.60           O  
ATOM    817  OD2 ASP   107      47.314  18.381 103.350  1.00 54.48           O  
ATOM    818  C   ASP   107      43.523  17.029 102.266  1.00 51.75           C  
ATOM    819  O   ASP   107      42.532  17.565 102.770  1.00 51.41           O  
ATOM    820  N   GLU   108      43.868  15.767 102.453  1.00 52.00           N  
ATOM    821  CA  GLU   108      43.167  14.848 103.355  1.00 52.49           C  
ATOM    822  CB  GLU   108      44.119  13.767 103.760  1.00 53.45           C  
ATOM    823  CG  GLU   108      44.254  12.657 102.846  1.00 57.41           C  
ATOM    824  CD  GLU   108      45.062  11.651 103.577  1.00 64.58           C  
ATOM    825  OE1 GLU   108      45.945  12.104 104.364  1.00 65.35           O  
ATOM    826  OE2 GLU   108      44.780  10.434 103.445  1.00 71.76           O  
ATOM    827  C   GLU   108      42.731  15.364 104.689  1.00 51.50           C  
ATOM    828  O   GLU   108      41.611  15.114 105.091  1.00 51.36           O  
ATOM    829  N   ILE   109      43.676  15.959 105.415  1.00 50.88           N  
ATOM    830  CA  ILE   109      43.399  16.557 106.721  1.00 50.86           C  
ATOM    831  CB  ILE   109      44.572  16.350 107.691  1.00 49.91           C  
ATOM    832  CG1 ILE   109      45.819  17.106 107.260  1.00 48.65           C  
ATOM    833  CD1 ILE   109      46.609  17.591 108.378  1.00 44.12           C  
ATOM    834  CG2 ILE   109      44.890  14.936 107.693  1.00 50.46           C  
ATOM    835  C   ILE   109      43.036  18.032 106.657  1.00 50.55           C  
ATOM    836  O   ILE   109      43.264  18.738 107.595  1.00 50.87           O  
ATOM    837  N   GLY   110      42.476  18.485 105.544  1.00 50.88           N  
ATOM    838  CA  GLY   110      42.044  19.846 105.399  1.00 50.93           C  
ATOM    839  C   GLY   110      43.091  20.902 105.143  1.00 50.85           C  
ATOM    840  O   GLY   110      42.730  22.020 104.929  1.00 51.37           O  
ATOM    841  N   ASP   111      44.381  20.636 105.150  1.00 51.47           N  
ATOM    842  CA  ASP   111      45.293  21.794 104.965  1.00 52.44           C  
ATOM    843  CB  ASP   111      46.730  21.473 105.352  1.00 53.51           C  
ATOM    844  CG  ASP   111      46.865  20.960 106.763  1.00 55.43           C  
ATOM    845  OD1 ASP   111      45.894  20.393 107.316  1.00 58.80           O  
ATOM    846  OD2 ASP   111      47.972  21.122 107.304  1.00 58.75           O  
ATOM    847  C   ASP   111      45.315  22.217 103.525  1.00 52.71           C  
ATOM    848  O   ASP   111      45.344  21.333 102.645  1.00 52.58           O  
ATOM    849  N   THR   112      45.359  23.536 103.251  1.00 52.99           N  
ATOM    850  CA  THR   112      45.282  24.008 101.806  1.00 52.54           C  
ATOM    851  CB  THR   112      45.010  25.527 101.597  1.00 52.18           C  
ATOM    852  OG1 THR   112      46.190  26.250 101.909  1.00 53.76           O  
ATOM    853  CG2 THR   112      43.830  26.048 102.455  1.00 51.57           C  
ATOM    854  C   THR   112      46.524  23.603 100.979  1.00 52.19           C  
ATOM    855  O   THR   112      47.660  23.660 101.458  1.00 51.63           O  
ATOM    856  N   ILE   113      46.269  23.133  99.759  1.00 52.14           N  
ATOM    857  CA  ILE   113      47.321  22.756  98.801  1.00 51.69           C  
ATOM    858  CB  ILE   113      47.391  21.209  98.522  1.00 51.14           C  
ATOM    859  CG1 ILE   113      46.002  20.668  98.159  1.00 50.92           C  
ATOM    860  CD1 ILE   113      45.954  19.245  97.726  1.00 50.05           C  
ATOM    861  CG2 ILE   113      47.971  20.508  99.703  1.00 46.64           C  
ATOM    862  C   ILE   113      47.110  23.544  97.499  1.00 52.17           C  
ATOM    863  O   ILE   113      45.977  23.846  97.090  1.00 51.86           O  
ATOM    864  N   TYR   114      48.230  23.893  96.892  1.00 52.69           N  
ATOM    865  CA  TYR   114      48.270  24.648  95.671  1.00 53.14           C  
ATOM    866  CB  TYR   114      49.148  25.886  95.874  1.00 52.99           C  
ATOM    867  CG  TYR   114      48.465  27.030  96.619  1.00 53.38           C  
ATOM    868  CD1 TYR   114      48.824  27.349  97.916  1.00 54.44           C  
ATOM    869  CE1 TYR   114      48.215  28.412  98.581  1.00 54.09           C  
ATOM    870  CZ  TYR   114      47.224  29.150  97.941  1.00 53.99           C  
ATOM    871  OH  TYR   114      46.607  30.184  98.640  1.00 54.18           O  
ATOM    872  CE2 TYR   114      46.842  28.826  96.648  1.00 50.27           C  
ATOM    873  CD2 TYR   114      47.456  27.798  96.017  1.00 51.66           C  
ATOM    874  C   TYR   114      48.863  23.714  94.590  1.00 53.94           C  
ATOM    875  O   TYR   114      49.984  23.228  94.707  1.00 54.23           O  
ATOM    876  N   ARG   115      48.070  23.468  93.547  1.00 55.24           N  
ATOM    877  CA  ARG   115      48.396  22.600  92.388  1.00 55.22           C  
ATOM    878  CB  ARG   115      47.420  21.458  92.374  1.00 54.89           C  
ATOM    879  CG  ARG   115      47.411  20.702  93.647  1.00 55.05           C  
ATOM    880  CD  ARG   115      48.738  20.058  93.892  1.00 56.15           C  
ATOM    881  NE  ARG   115      48.808  19.201  95.089  1.00 55.54           N  
ATOM    882  CZ  ARG   115      49.621  19.439  96.107  1.00 55.06           C  
ATOM    883  NH1 ARG   115      50.419  20.528  96.136  1.00 54.46           N  
ATOM    884  NH2 ARG   115      49.616  18.587  97.110  1.00 54.62           N  
ATOM    885  C   ARG   115      48.299  23.321  91.020  1.00 55.76           C  
ATOM    886  O   ARG   115      47.494  24.254  90.873  1.00 56.63           O  
ATOM    887  N   THR   116      49.137  22.900  90.061  1.00 55.55           N  
ATOM    888  CA  THR   116      49.034  23.318  88.662  1.00 55.67           C  
ATOM    889  CB  THR   116      50.225  24.106  88.252  1.00 55.53           C  
ATOM    890  OG1 THR   116      50.209  25.322  88.990  1.00 57.53           O  
ATOM    891  CG2 THR   116      50.184  24.419  86.783  1.00 54.83           C  
ATOM    892  C   THR   116      48.954  22.115  87.733  1.00 56.17           C  
ATOM    893  O   THR   116      49.815  21.214  87.795  1.00 56.77           O  
ATOM    894  N   VAL   117      47.906  22.089  86.895  1.00 55.91           N  
ATOM    895  CA  VAL   117      47.819  21.138  85.780  1.00 55.41           C  
ATOM    896  CB  VAL   117      46.374  20.775  85.519  1.00 55.50           C  
ATOM    897  CG1 VAL   117      46.249  19.895  84.248  1.00 54.97           C  
ATOM    898  CG2 VAL   117      45.796  20.095  86.768  1.00 54.34           C  
ATOM    899  C   VAL   117      48.442  21.781  84.516  1.00 55.50           C  
ATOM    900  O   VAL   117      48.051  22.879  84.126  1.00 55.70           O  
ATOM    901  N   ILE   118      49.433  21.111  83.926  1.00 55.26           N  
ATOM    902  CA  ILE   118      50.125  21.556  82.705  1.00 54.51           C  
ATOM    903  CB  ILE   118      51.622  21.558  82.898  1.00 54.02           C  
ATOM    904  CG1 ILE   118      51.987  22.101  84.288  1.00 53.96           C  
ATOM    905  CD1 ILE   118      53.479  22.545  84.443  1.00 53.41           C  
ATOM    906  CG2 ILE   118      52.256  22.386  81.823  1.00 54.15           C  
ATOM    907  C   ILE   118      49.790  20.628  81.492  1.00 54.85           C  
ATOM    908  O   ILE   118      50.106  19.432  81.499  1.00 54.76           O  
ATOM    909  N   LEU   119      49.087  21.175  80.482  1.00 54.66           N  
ATOM    910  CA  LEU   119      48.860  20.480  79.214  1.00 54.28           C  
ATOM    911  CB  LEU   119      47.425  20.653  78.723  1.00 53.58           C  
ATOM    912  CG  LEU   119      47.054  19.908  77.422  1.00 52.96           C  
ATOM    913  CD1 LEU   119      47.245  18.392  77.489  1.00 49.61           C  
ATOM    914  CD2 LEU   119      45.643  20.239  77.001  1.00 51.59           C  
ATOM    915  C   LEU   119      49.862  21.048  78.199  1.00 54.97           C  
ATOM    916  O   LEU   119      49.919  22.267  77.975  1.00 55.22           O  
ATOM    917  N   GLU   120      50.648  20.143  77.641  1.00 55.65           N  
ATOM    918  CA  GLU   120      51.600  20.425  76.608  1.00 55.76           C  
ATOM    919  CB  GLU   120      52.946  19.839  76.954  1.00 55.72           C  
ATOM    920  CG  GLU   120      53.566  20.360  78.184  1.00 54.10           C  
ATOM    921  CD  GLU   120      54.855  19.716  78.437  1.00 53.86           C  
ATOM    922  OE1 GLU   120      55.088  18.679  77.844  1.00 56.14           O  
ATOM    923  OE2 GLU   120      55.643  20.234  79.217  1.00 49.42           O  
ATOM    924  C   GLU   120      51.116  19.714  75.391  1.00 56.86           C  
ATOM    925  O   GLU   120      51.089  18.516  75.365  1.00 56.36           O  
ATOM    926  N   ILE   121      50.730  20.474  74.371  1.00 58.02           N  
ATOM    927  CA  ILE   121      50.239  19.894  73.126  1.00 58.72           C  
ATOM    928  CB  ILE   121      49.048  20.691  72.563  1.00 58.69           C  
ATOM    929  CG1 ILE   121      48.263  21.351  73.699  1.00 59.83           C  
ATOM    930  CD1 ILE   121      46.784  21.496  73.416  1.00 59.52           C  
ATOM    931  CG2 ILE   121      48.143  19.787  71.740  1.00 58.59           C  
ATOM    932  C   ILE   121      51.341  19.835  72.074  1.00 59.65           C  
ATOM    933  O   ILE   121      51.632  20.829  71.409  1.00 61.11           O  
ATOM    934  N   MET   122      51.951  18.663  71.929  1.00 58.65           N  
ATOM    935  CA  MET   122      53.023  18.472  70.959  1.00 58.71           C  
ATOM    936  CB  MET   122      54.389  18.614  71.634  1.00 57.91           C  
ATOM    937  CG  MET   122      54.415  19.617  72.776  1.00 60.09           C  
ATOM    938  SD  MET   122      55.106  21.209  72.289  1.00 66.60           S  
ATOM    939  CE  MET   122      54.833  22.167  73.778  1.00 65.35           C  
ATOM    940  C   MET   122      52.915  17.113  70.276  1.00 56.49           C  
ATOM    941  O   MET   122      53.742  16.228  70.498  1.00 54.98           O  
ATOM    942  N   GLY   123      51.867  16.952  69.499  1.00 55.60           N  
ATOM    943  CA  GLY   123      51.663  15.739  68.761  1.00 56.17           C  
ATOM    944  C   GLY   123      51.910  14.545  69.616  1.00 57.13           C  
ATOM    945  O   GLY   123      51.186  14.297  70.538  1.00 58.77           O  
ATOM    946  N   LYS   124      52.941  13.792  69.310  1.00 57.48           N  
ATOM    947  CA  LYS   124      53.190  12.578  70.026  1.00 58.33           C  
ATOM    948  CB  LYS   124      53.951  11.622  69.147  1.00 59.06           C  
ATOM    949  CG  LYS   124      55.062  12.265  68.403  1.00 60.90           C  
ATOM    950  CD  LYS   124      56.112  11.262  67.995  1.00 61.75           C  
ATOM    951  CE  LYS   124      57.494  11.877  68.061  1.00 65.11           C  
ATOM    952  NZ  LYS   124      58.247  11.810  66.780  1.00 68.90           N  
ATOM    953  C   LYS   124      53.986  12.858  71.262  1.00 58.00           C  
ATOM    954  O   LYS   124      54.217  11.982  72.064  1.00 58.46           O  
ATOM    955  N   HIS   125      54.422  14.093  71.406  1.00 58.26           N  
ATOM    956  CA  HIS   125      55.099  14.547  72.646  1.00 58.28           C  
ATOM    957  CB  HIS   125      56.275  15.436  72.284  1.00 58.92           C  
ATOM    958  CG  HIS   125      57.285  14.746  71.437  1.00 61.28           C  
ATOM    959  ND1 HIS   125      57.477  15.057  70.102  1.00 63.24           N  
ATOM    960  CE1 HIS   125      58.412  14.267  69.608  1.00 62.83           C  
ATOM    961  NE2 HIS   125      58.818  13.448  70.568  1.00 63.29           N  
ATOM    962  CD2 HIS   125      58.129  13.724  71.720  1.00 62.33           C  
ATOM    963  C   HIS   125      54.158  15.309  73.590  1.00 57.38           C  
ATOM    964  O   HIS   125      54.566  16.121  74.468  1.00 57.94           O  
ATOM    965  N   SER   126      52.882  15.065  73.380  1.00 55.87           N  
ATOM    966  CA  SER   126      51.888  15.590  74.254  1.00 54.64           C  
ATOM    967  CB  SER   126      50.542  15.421  73.601  1.00 54.56           C  
ATOM    968  OG  SER   126      50.494  16.271  72.494  1.00 52.33           O  
ATOM    969  C   SER   126      51.946  14.898  75.634  1.00 54.33           C  
ATOM    970  O   SER   126      52.192  13.669  75.729  1.00 53.25           O  
ATOM    971  N   ASN   127      51.764  15.727  76.677  1.00 53.83           N  
ATOM    972  CA  ASN   127      51.701  15.273  78.076  1.00 53.11           C  
ATOM    973  CB  ASN   127      53.092  15.260  78.728  1.00 52.87           C  
ATOM    974  CG  ASN   127      53.332  14.036  79.603  1.00 52.45           C  
ATOM    975  OD1 ASN   127      52.388  13.310  79.977  1.00 49.12           O  
ATOM    976  ND2 ASN   127      54.611  13.810  79.955  1.00 51.97           N  
ATOM    977  C   ASN   127      50.743  16.145  78.890  1.00 53.02           C  
ATOM    978  O   ASN   127      50.464  17.336  78.558  1.00 52.92           O  
ATOM    979  N   LEU   128      50.188  15.490  79.903  1.00 52.35           N  
ATOM    980  CA  LEU   128      49.409  16.123  80.930  1.00 52.34           C  
ATOM    981  CB  LEU   128      48.022  15.538  80.867  1.00 51.65           C  
ATOM    982  CG  LEU   128      46.995  16.118  81.795  1.00 51.16           C  
ATOM    983  CD1 LEU   128      46.994  17.619  81.751  1.00 47.66           C  
ATOM    984  CD2 LEU   128      45.705  15.554  81.439  1.00 49.71           C  
ATOM    985  C   LEU   128      50.161  15.829  82.290  1.00 53.41           C  
ATOM    986  O   LEU   128      50.557  14.665  82.606  1.00 53.06           O  
ATOM    987  N   ILE   129      50.396  16.905  83.048  1.00 53.88           N  
ATOM    988  CA  ILE   129      51.302  16.895  84.212  1.00 54.26           C  
ATOM    989  CB  ILE   129      52.738  17.348  83.867  1.00 54.52           C  
ATOM    990  CG1 ILE   129      53.318  16.589  82.683  1.00 54.79           C  
ATOM    991  CD1 ILE   129      54.540  17.350  82.119  1.00 54.37           C  
ATOM    992  CG2 ILE   129      53.675  17.153  85.040  1.00 53.94           C  
ATOM    993  C   ILE   129      50.822  17.800  85.377  1.00 54.81           C  
ATOM    994  O   ILE   129      50.388  18.966  85.212  1.00 53.98           O  
ATOM    995  N   LEU   130      50.943  17.229  86.575  1.00 55.38           N  
ATOM    996  CA  LEU   130      50.472  17.860  87.786  1.00 55.11           C  
ATOM    997  CB  LEU   130      49.554  16.878  88.490  1.00 55.70           C  
ATOM    998  CG  LEU   130      48.714  17.397  89.646  1.00 56.00           C  
ATOM    999  CD1 LEU   130      47.841  18.606  89.253  1.00 52.38           C  
ATOM   1000  CD2 LEU   130      47.934  16.169  90.183  1.00 55.26           C  
ATOM   1001  C   LEU   130      51.700  18.168  88.614  1.00 54.62           C  
ATOM   1002  O   LEU   130      52.566  17.322  88.803  1.00 54.44           O  
ATOM   1003  N   VAL   131      51.791  19.396  89.074  1.00 54.29           N  
ATOM   1004  CA  VAL   131      52.920  19.806  89.845  1.00 54.42           C  
ATOM   1005  CB  VAL   131      53.853  20.673  89.017  1.00 53.82           C  
ATOM   1006  CG1 VAL   131      54.245  19.941  87.761  1.00 52.74           C  
ATOM   1007  CG2 VAL   131      53.179  21.982  88.685  1.00 51.31           C  
ATOM   1008  C   VAL   131      52.357  20.617  90.997  1.00 55.56           C  
ATOM   1009  O   VAL   131      51.183  21.036  90.945  1.00 55.38           O  
ATOM   1010  N   ASP   132      53.187  20.843  92.029  1.00 56.53           N  
ATOM   1011  CA  ASP   132      52.807  21.688  93.155  1.00 56.66           C  
ATOM   1012  CB  ASP   132      53.393  21.127  94.429  1.00 56.44           C  
ATOM   1013  CG  ASP   132      54.916  21.169  94.440  1.00 57.88           C  
ATOM   1014  OD1 ASP   132      55.503  22.057  93.794  1.00 58.57           O  
ATOM   1015  OD2 ASP   132      55.538  20.311  95.114  1.00 57.75           O  
ATOM   1016  C   ASP   132      53.268  23.113  92.907  1.00 57.21           C  
ATOM   1017  O   ASP   132      53.857  23.421  91.864  1.00 57.29           O  
ATOM   1018  N   GLU   133      52.999  23.980  93.873  1.00 58.50           N  
ATOM   1019  CA  GLU   133      53.405  25.413  93.820  1.00 58.96           C  
ATOM   1020  CB  GLU   133      52.891  26.256  95.027  1.00 60.31           C  
ATOM   1021  CG  GLU   133      53.471  25.924  96.360  1.00 62.68           C  
ATOM   1022  CD  GLU   133      52.897  24.624  96.883  1.00 71.07           C  
ATOM   1023  OE1 GLU   133      52.763  23.620  96.135  1.00 75.98           O  
ATOM   1024  OE2 GLU   133      52.546  24.574  98.064  1.00 77.69           O  
ATOM   1025  C   GLU   133      54.895  25.635  93.698  1.00 58.67           C  
ATOM   1026  O   GLU   133      55.297  26.709  93.225  1.00 59.04           O  
ATOM   1027  N   ASN   134      55.710  24.660  94.103  1.00 57.46           N  
ATOM   1028  CA  ASN   134      57.141  24.722  93.752  1.00 56.98           C  
ATOM   1029  CB  ASN   134      57.922  24.244  94.942  1.00 57.20           C  
ATOM   1030  CG  ASN   134      57.529  24.991  96.222  1.00 57.85           C  
ATOM   1031  OD1 ASN   134      57.250  26.200  96.186  1.00 57.75           O  
ATOM   1032  ND2 ASN   134      57.484  24.269  97.352  1.00 55.56           N  
ATOM   1033  C   ASN   134      57.596  23.994  92.453  1.00 56.47           C  
ATOM   1034  O   ASN   134      58.795  23.816  92.244  1.00 55.44           O  
ATOM   1035  N   ARG   135      56.629  23.609  91.585  1.00 56.07           N  
ATOM   1036  CA  ARG   135      56.869  22.820  90.381  1.00 55.33           C  
ATOM   1037  CB  ARG   135      57.830  23.573  89.447  1.00 55.91           C  
ATOM   1038  CG  ARG   135      57.700  25.134  89.351  1.00 57.56           C  
ATOM   1039  CD  ARG   135      56.415  25.664  88.702  1.00 58.13           C  
ATOM   1040  NE  ARG   135      56.474  25.591  87.245  1.00 60.37           N  
ATOM   1041  CZ  ARG   135      55.422  25.658  86.415  1.00 59.70           C  
ATOM   1042  NH1 ARG   135      54.187  25.811  86.871  1.00 61.32           N  
ATOM   1043  NH2 ARG   135      55.611  25.530  85.116  1.00 57.16           N  
ATOM   1044  C   ARG   135      57.433  21.392  90.592  1.00 54.55           C  
ATOM   1045  O   ARG   135      58.020  20.833  89.685  1.00 53.77           O  
ATOM   1046  N   LYS   136      57.309  20.813  91.784  1.00 54.17           N  
ATOM   1047  CA  LYS   136      57.698  19.406  92.003  1.00 53.47           C  
ATOM   1048  CB  LYS   136      57.687  19.042  93.509  1.00 53.29           C  
ATOM   1049  CG  LYS   136      58.715  17.923  94.101  1.00 53.16           C  
ATOM   1050  CD  LYS   136      58.288  17.370  95.591  1.00 52.67           C  
ATOM   1051  CE  LYS   136      59.281  16.291  96.274  1.00 52.98           C  
ATOM   1052  NZ  LYS   136      58.749  15.028  97.051  1.00 47.58           N  
ATOM   1053  C   LYS   136      56.604  18.663  91.222  1.00 53.21           C  
ATOM   1054  O   LYS   136      55.416  18.981  91.361  1.00 53.64           O  
ATOM   1055  N   ILE   137      56.986  17.735  90.350  1.00 52.60           N  
ATOM   1056  CA  ILE   137      55.995  16.992  89.552  1.00 52.08           C  
ATOM   1057  CB  ILE   137      56.632  16.071  88.487  1.00 51.83           C  
ATOM   1058  CG1 ILE   137      57.308  16.862  87.372  1.00 51.11           C  
ATOM   1059  CD1 ILE   137      58.220  15.957  86.578  1.00 51.38           C  
ATOM   1060  CG2 ILE   137      55.547  15.073  87.928  1.00 51.72           C  
ATOM   1061  C   ILE   137      55.307  16.029  90.478  1.00 51.48           C  
ATOM   1062  O   ILE   137      55.969  15.212  91.043  1.00 52.01           O  
ATOM   1063  N   ILE   138      54.003  16.091  90.625  1.00 50.52           N  
ATOM   1064  CA  ILE   138      53.302  15.073  91.400  1.00 50.91           C  
ATOM   1065  CB  ILE   138      51.946  15.611  91.950  1.00 50.60           C  
ATOM   1066  CG1 ILE   138      52.258  16.677  93.012  1.00 47.28           C  
ATOM   1067  CD1 ILE   138      51.276  17.685  93.125  1.00 44.97           C  
ATOM   1068  CG2 ILE   138      51.040  14.460  92.436  1.00 48.53           C  
ATOM   1069  C   ILE   138      53.093  13.838  90.545  1.00 51.64           C  
ATOM   1070  O   ILE   138      53.410  12.738  90.962  1.00 50.95           O  
ATOM   1071  N   GLU   139      52.571  14.015  89.324  1.00 53.13           N  
ATOM   1072  CA  GLU   139      52.349  12.853  88.387  1.00 52.95           C  
ATOM   1073  CB  GLU   139      51.072  12.046  88.755  1.00 52.79           C  
ATOM   1074  CG  GLU   139      50.862  10.636  88.183  1.00 53.08           C  
ATOM   1075  CD  GLU   139      52.102   9.755  88.057  1.00 54.58           C  
ATOM   1076  OE1 GLU   139      53.087  10.157  87.397  1.00 55.78           O  
ATOM   1077  OE2 GLU   139      52.078   8.606  88.557  1.00 56.80           O  
ATOM   1078  C   GLU   139      52.301  13.340  86.954  1.00 53.00           C  
ATOM   1079  O   GLU   139      52.073  14.534  86.694  1.00 52.36           O  
ATOM   1080  N   GLY   140      52.578  12.387  86.059  1.00 53.40           N  
ATOM   1081  CA  GLY   140      52.584  12.565  84.606  1.00 53.55           C  
ATOM   1082  C   GLY   140      51.733  11.545  83.864  1.00 53.88           C  
ATOM   1083  O   GLY   140      51.905  10.316  84.024  1.00 53.95           O  
ATOM   1084  N   PHE   141      50.820  12.032  83.022  1.00 53.92           N  
ATOM   1085  CA  PHE   141      50.076  11.099  82.225  1.00 54.21           C  
ATOM   1086  CB  PHE   141      49.109  11.807  81.314  1.00 53.67           C  
ATOM   1087  CG  PHE   141      47.815  11.025  81.018  1.00 53.02           C  
ATOM   1088  CD1 PHE   141      47.678   9.708  81.303  1.00 50.46           C  
ATOM   1089  CE1 PHE   141      46.492   9.088  81.033  1.00 53.18           C  
ATOM   1090  CZ  PHE   141      45.428   9.775  80.436  1.00 52.30           C  
ATOM   1091  CE2 PHE   141      45.565  11.047  80.152  1.00 51.75           C  
ATOM   1092  CD2 PHE   141      46.736  11.675  80.412  1.00 52.03           C  
ATOM   1093  C   PHE   141      51.056  10.260  81.427  1.00 54.40           C  
ATOM   1094  O   PHE   141      50.767   9.157  81.136  1.00 54.32           O  
ATOM   1095  N   LYS   142      52.222  10.791  81.089  1.00 55.49           N  
ATOM   1096  CA  LYS   142      53.300  10.004  80.510  1.00 56.84           C  
ATOM   1097  CB  LYS   142      53.454  10.344  79.018  1.00 57.27           C  
ATOM   1098  CG  LYS   142      53.088   9.264  77.975  1.00 57.64           C  
ATOM   1099  CD  LYS   142      52.635   9.893  76.593  1.00 58.49           C  
ATOM   1100  CE  LYS   142      53.785  10.617  75.802  1.00 61.08           C  
ATOM   1101  NZ  LYS   142      53.315  11.336  74.568  1.00 59.47           N  
ATOM   1102  C   LYS   142      54.627  10.321  81.201  1.00 57.53           C  
ATOM   1103  O   LYS   142      54.940  11.482  81.448  1.00 57.80           O  
ATOM   1104  N   HIS   143      55.433   9.289  81.429  1.00 58.67           N  
ATOM   1105  CA  HIS   143      56.757   9.433  82.036  1.00 59.74           C  
ATOM   1106  CB  HIS   143      57.028   8.254  82.995  1.00 60.16           C  
ATOM   1107  CG  HIS   143      56.236   8.317  84.266  1.00 60.98           C  
ATOM   1108  ND1 HIS   143      56.477   7.478  85.331  1.00 59.63           N  
ATOM   1109  CE1 HIS   143      55.605   7.750  86.290  1.00 60.88           C  
ATOM   1110  NE2 HIS   143      54.830   8.748  85.900  1.00 58.16           N  
ATOM   1111  CD2 HIS   143      55.212   9.130  84.641  1.00 61.05           C  
ATOM   1112  C   HIS   143      57.927   9.503  81.038  1.00 60.48           C  
ATOM   1113  O   HIS   143      58.022   8.672  80.156  1.00 60.79           O  
ATOM   1114  N   LEU   144      58.831  10.465  81.237  1.00 61.21           N  
ATOM   1115  CA  LEU   144      60.124  10.507  80.569  1.00 61.59           C  
ATOM   1116  CB  LEU   144      60.439  11.908  80.075  1.00 61.40           C  
ATOM   1117  CG  LEU   144      59.660  12.439  78.890  1.00 60.04           C  
ATOM   1118  CD1 LEU   144      58.226  11.959  78.939  1.00 58.51           C  
ATOM   1119  CD2 LEU   144      59.781  13.964  78.898  1.00 60.13           C  
ATOM   1120  C   LEU   144      61.212  10.119  81.540  1.00 62.57           C  
ATOM   1121  O   LEU   144      61.538  10.884  82.444  1.00 62.29           O  
ATOM   1122  N   THR   145      61.786   8.947  81.319  1.00 63.84           N  
ATOM   1123  CA  THR   145      62.799   8.416  82.190  1.00 65.57           C  
ATOM   1124  CB  THR   145      62.624   6.877  82.256  1.00 65.98           C  
ATOM   1125  OG1 THR   145      62.769   6.364  80.931  1.00 67.65           O  
ATOM   1126  CG2 THR   145      61.239   6.441  82.811  1.00 65.24           C  
ATOM   1127  C   THR   145      64.255   8.650  81.747  1.00 66.90           C  
ATOM   1128  O   THR   145      65.185   8.607  82.589  1.00 67.41           O  
ATOM   1129  N   PRO   146      64.471   8.877  80.431  1.00 68.39           N  
ATOM   1130  CA  PRO   146      65.716   8.259  79.786  1.00 68.78           C  
ATOM   1131  CB  PRO   146      65.897   9.046  78.445  1.00 69.06           C  
ATOM   1132  CG  PRO   146      64.473   9.756  78.190  1.00 69.30           C  
ATOM   1133  CD  PRO   146      63.654   9.688  79.488  1.00 68.49           C  
ATOM   1134  C   PRO   146      67.014   8.247  80.618  1.00 68.73           C  
ATOM   1135  O   PRO   146      67.966   8.913  80.226  1.00 69.14           O  
ATOM   1136  N   ARG   152      65.707  16.095  80.197  1.00 20.00           N  
ATOM   1137  CA  ARG   152      64.443  16.267  80.900  1.00 20.00           C  
ATOM   1138  C   ARG   152      63.886  14.968  81.453  1.00 20.00           C  
ATOM   1139  CB  ARG   152      63.440  16.856  79.943  1.00 20.00           C  
ATOM   1140  CG  ARG   152      62.186  17.314  80.578  1.00 20.00           C  
ATOM   1141  CD  ARG   152      61.535  18.335  79.722  1.00 20.00           C  
ATOM   1142  NE  ARG   152      60.398  17.787  79.019  1.00 20.00           N  
ATOM   1143  CZ  ARG   152      59.186  18.272  79.141  1.00 20.00           C  
ATOM   1144  NH1 ARG   152      58.976  19.295  79.933  1.00 20.00           N  
ATOM   1145  NH2 ARG   152      58.198  17.730  78.485  1.00 20.00           N  
ATOM   1146  O   ARG   152      63.900  13.967  80.779  1.00 52.54           O  
ATOM   1147  N   THR   153      63.383  14.993  82.679  1.00 51.26           N  
ATOM   1148  CA  THR   153      62.807  13.814  83.292  1.00 50.91           C  
ATOM   1149  CB  THR   153      63.613  13.337  84.513  1.00 50.26           C  
ATOM   1150  OG1 THR   153      64.972  13.114  84.153  1.00 48.88           O  
ATOM   1151  CG2 THR   153      63.071  12.059  85.016  1.00 50.33           C  
ATOM   1152  C   THR   153      61.425  14.206  83.746  1.00 50.90           C  
ATOM   1153  O   THR   153      61.232  15.277  84.272  1.00 50.23           O  
ATOM   1154  N   VAL   154      60.460  13.336  83.536  1.00 50.84           N  
ATOM   1155  CA  VAL   154      59.087  13.648  83.878  1.00 50.71           C  
ATOM   1156  CB  VAL   154      58.215  14.051  82.656  1.00 50.57           C  
ATOM   1157  CG1 VAL   154      56.692  14.146  83.059  1.00 49.97           C  
ATOM   1158  CG2 VAL   154      58.756  15.397  82.076  1.00 46.63           C  
ATOM   1159  C   VAL   154      58.621  12.449  84.654  1.00 51.24           C  
ATOM   1160  O   VAL   154      57.934  11.558  84.136  1.00 51.31           O  
ATOM   1161  N   MET   155      59.107  12.418  85.903  1.00 51.39           N  
ATOM   1162  CA  MET   155      58.673  11.444  86.907  1.00 50.32           C  
ATOM   1163  CB  MET   155      59.753  10.384  87.129  1.00 50.06           C  
ATOM   1164  CG  MET   155      60.250   9.718  85.849  1.00 47.83           C  
ATOM   1165  SD  MET   155      61.212   8.216  86.136  1.00 44.52           S  
ATOM   1166  CE  MET   155      59.887   7.039  85.852  1.00 46.85           C  
ATOM   1167  C   MET   155      58.307  12.241  88.185  1.00 51.46           C  
ATOM   1168  O   MET   155      58.756  13.411  88.330  1.00 52.64           O  
ATOM   1169  N   PRO   156      57.466  11.648  89.074  1.00 51.56           N  
ATOM   1170  CA  PRO   156      56.955  12.266  90.302  1.00 51.75           C  
ATOM   1171  CB  PRO   156      56.139  11.126  90.949  1.00 51.74           C  
ATOM   1172  CG  PRO   156      55.690  10.352  89.852  1.00 51.66           C  
ATOM   1173  CD  PRO   156      56.928  10.285  88.961  1.00 51.60           C  
ATOM   1174  C   PRO   156      58.014  12.783  91.310  1.00 52.00           C  
ATOM   1175  O   PRO   156      57.729  13.638  92.184  1.00 53.22           O  
ATOM   1176  N   GLY   157      59.231  12.326  91.248  1.00 50.91           N  
ATOM   1177  CA  GLY   157      60.180  13.129  92.008  1.00 51.35           C  
ATOM   1178  C   GLY   157      60.393  14.632  91.680  1.00 50.84           C  
ATOM   1179  O   GLY   157      60.713  15.423  92.544  1.00 50.71           O  
ATOM   1180  N   PHE   158      60.263  15.017  90.428  1.00 50.84           N  
ATOM   1181  CA  PHE   158      61.243  15.931  89.870  1.00 50.47           C  
ATOM   1182  CB  PHE   158      61.719  15.350  88.561  1.00 48.68           C  
ATOM   1183  CG  PHE   158      62.513  14.144  88.732  1.00 46.90           C  
ATOM   1184  CD1 PHE   158      63.891  14.175  88.544  1.00 46.20           C  
ATOM   1185  CE1 PHE   158      64.679  13.015  88.762  1.00 44.94           C  
ATOM   1186  CZ  PHE   158      64.067  11.842  89.146  1.00 43.83           C  
ATOM   1187  CE2 PHE   158      62.688  11.801  89.329  1.00 42.66           C  
ATOM   1188  CD2 PHE   158      61.915  12.956  89.127  1.00 43.25           C  
ATOM   1189  C   PHE   158      60.654  17.239  89.581  1.00 52.24           C  
ATOM   1190  O   PHE   158      59.444  17.360  89.529  1.00 53.22           O  
ATOM   1191  N   ASN   159      61.501  18.211  89.298  1.00 54.35           N  
ATOM   1192  CA  ASN   159      60.999  19.540  88.922  1.00 56.60           C  
ATOM   1193  CB  ASN   159      62.055  20.609  89.187  1.00 57.28           C  
ATOM   1194  CG  ASN   159      62.422  20.704  90.659  1.00 60.13           C  
ATOM   1195  OD1 ASN   159      61.555  20.548  91.561  1.00 65.94           O  
ATOM   1196  ND2 ASN   159      63.701  20.949  90.920  1.00 59.92           N  
ATOM   1197  C   ASN   159      60.613  19.641  87.489  1.00 56.22           C  
ATOM   1198  O   ASN   159      61.411  19.346  86.647  1.00 55.94           O  
ATOM   1199  N   TYR   160      59.406  20.086  87.204  1.00 57.15           N  
ATOM   1200  CA  TYR   160      59.036  20.357  85.809  1.00 58.02           C  
ATOM   1201  CB  TYR   160      57.626  20.847  85.695  1.00 57.28           C  
ATOM   1202  CG  TYR   160      57.162  21.264  84.297  1.00 57.10           C  
ATOM   1203  CD1 TYR   160      56.396  20.411  83.514  1.00 57.09           C  
ATOM   1204  CE1 TYR   160      55.920  20.781  82.285  1.00 57.83           C  
ATOM   1205  CZ  TYR   160      56.165  22.036  81.802  1.00 57.74           C  
ATOM   1206  OH  TYR   160      55.644  22.410  80.593  1.00 55.97           O  
ATOM   1207  CE2 TYR   160      56.895  22.923  82.563  1.00 58.31           C  
ATOM   1208  CD2 TYR   160      57.380  22.535  83.811  1.00 57.95           C  
ATOM   1209  C   TYR   160      59.900  21.412  85.174  1.00 58.53           C  
ATOM   1210  O   TYR   160      60.022  22.524  85.683  1.00 57.47           O  
ATOM   1211  N   GLU   161      60.359  21.048  83.980  1.00 60.42           N  
ATOM   1212  CA  GLU   161      61.071  21.889  83.032  1.00 61.55           C  
ATOM   1213  CB  GLU   161      62.413  21.276  82.733  1.00 61.26           C  
ATOM   1214  CG  GLU   161      63.243  21.062  83.915  1.00 62.95           C  
ATOM   1215  CD  GLU   161      64.432  21.936  83.896  1.00 65.87           C  
ATOM   1216  OE1 GLU   161      65.447  21.502  83.330  1.00 72.76           O  
ATOM   1217  OE2 GLU   161      64.354  23.057  84.430  1.00 71.52           O  
ATOM   1218  C   GLU   161      60.359  21.963  81.701  1.00 62.24           C  
ATOM   1219  O   GLU   161      59.945  20.963  81.153  1.00 60.46           O  
ATOM   1220  N   ALA   162      60.223  23.178  81.181  1.00 64.04           N  
ATOM   1221  CA  ALA   162      59.561  23.392  79.899  1.00 65.97           C  
ATOM   1222  CB  ALA   162      59.654  24.855  79.492  1.00 65.07           C  
ATOM   1223  C   ALA   162      60.156  22.498  78.817  1.00 66.86           C  
ATOM   1224  O   ALA   162      61.148  21.806  79.046  1.00 66.24           O  
ATOM   1225  N   PRO   163      59.543  22.516  77.638  1.00 68.90           N  
ATOM   1226  CA  PRO   163      60.014  21.702  76.512  1.00 70.17           C  
ATOM   1227  CB  PRO   163      58.934  21.923  75.452  1.00 69.47           C  
ATOM   1228  CG  PRO   163      57.704  22.224  76.232  1.00 69.02           C  
ATOM   1229  CD  PRO   163      58.162  22.990  77.441  1.00 68.27           C  
ATOM   1230  C   PRO   163      61.365  22.182  75.993  1.00 71.79           C  
ATOM   1231  O   PRO   163      61.853  23.229  76.418  1.00 70.69           O  
ATOM   1232  N   PRO   164      61.958  21.419  75.080  1.00 74.52           N  
ATOM   1233  CA  PRO   164      63.259  21.776  74.505  1.00 75.69           C  
ATOM   1234  CB  PRO   164      63.342  20.888  73.263  1.00 76.24           C  
ATOM   1235  CG  PRO   164      62.508  19.703  73.598  1.00 75.63           C  
ATOM   1236  CD  PRO   164      61.381  20.221  74.446  1.00 74.97           C  
ATOM   1237  C   PRO   164      63.313  23.246  74.103  1.00 77.42           C  
ATOM   1238  O   PRO   164      63.862  24.066  74.838  1.00 78.39           O  
ATOM   1239  N   THR   165      62.747  23.569  72.945  1.00 20.00           N  
ATOM   1240  CA  THR   165      62.732  24.942  72.455  1.00 20.00           C  
ATOM   1241  C   THR   165      63.961  25.240  71.603  1.00 20.00           C  
ATOM   1242  CB  THR   165      62.666  25.953  73.615  1.00 20.00           C  
ATOM   1243  OG1 THR   165      61.355  26.529  73.676  1.00 20.00           O  
ATOM   1244  CG2 THR   165      63.692  27.059  73.416  1.00 20.00           C  
ATOM   1245  O   THR   165      65.002  24.600  71.751  1.00 20.00           O  
ATOM   1246  N   GLN   166      63.833  26.217  70.711  1.00 82.23           N  
ATOM   1247  CA  GLN   166      64.911  26.599  69.853  1.00 82.71           C  
ATOM   1248  CB  GLN   166      64.584  26.346  68.391  1.00 83.43           C  
ATOM   1249  CG  GLN   166      65.557  27.031  67.420  1.00 84.04           C  
ATOM   1250  CD  GLN   166      66.187  26.085  66.393  1.00 85.23           C  
ATOM   1251  OE1 GLN   166      66.303  26.427  65.214  1.00 89.14           O  
ATOM   1252  NE2 GLN   166      66.606  24.903  66.842  1.00 86.32           N  
ATOM   1253  C   GLN   166      65.103  28.059  70.110  1.00 82.10           C  
ATOM   1254  O   GLN   166      65.514  28.802  69.254  1.00 82.11           O  
ATOM   1255  N   HIS   167      64.799  28.492  71.309  1.00 81.41           N  
ATOM   1256  CA  HIS   167      64.931  29.894  71.548  1.00 79.88           C  
ATOM   1257  CB  HIS   167      66.393  30.283  71.564  1.00 81.38           C  
ATOM   1258  C   HIS   167      64.271  30.536  70.371  1.00 75.02           C  
ATOM   1259  O   HIS   167      64.921  31.013  69.465  1.00 74.94           O  
ATOM   1260  N   LYS   168      62.956  30.528  70.391  1.00 69.80           N  
ATOM   1261  CA  LYS   168      62.182  31.163  69.375  1.00 65.51           C  
ATOM   1262  CB  LYS   168      60.985  30.305  69.049  1.00 65.08           C  
ATOM   1263  CG  LYS   168      61.320  29.019  68.389  1.00 63.18           C  
ATOM   1264  CD  LYS   168      60.253  28.638  67.420  1.00 61.15           C  
ATOM   1265  CE  LYS   168      60.114  27.171  67.291  1.00 59.96           C  
ATOM   1266  NZ  LYS   168      60.476  26.681  65.970  1.00 54.43           N  
ATOM   1267  C   LYS   168      61.736  32.456  69.982  1.00 64.26           C  
ATOM   1268  O   LYS   168      62.017  32.714  71.123  1.00 63.98           O  
ATOM   1269  N   ILE   169      61.045  33.277  69.213  1.00 61.69           N  
ATOM   1270  CA  ILE   169      60.585  34.551  69.694  1.00 60.60           C  
ATOM   1271  CB  ILE   169      61.019  35.662  68.791  1.00 60.03           C  
ATOM   1272  CG1 ILE   169      62.522  35.759  68.786  1.00 59.71           C  
ATOM   1273  CD1 ILE   169      63.129  35.486  67.475  1.00 60.27           C  
ATOM   1274  CG2 ILE   169      60.500  36.941  69.296  1.00 59.13           C  
ATOM   1275  C   ILE   169      59.089  34.560  69.755  1.00 59.72           C  
ATOM   1276  O   ILE   169      58.438  33.855  69.027  1.00 59.04           O  
ATOM   1277  N   ASN   170      58.549  35.351  70.660  1.00 58.73           N  
ATOM   1278  CA  ASN   170      57.110  35.466  70.808  1.00 58.04           C  
ATOM   1279  CB  ASN   170      56.689  35.815  72.249  1.00 57.08           C  
ATOM   1280  CG  ASN   170      55.149  35.728  72.485  1.00 58.65           C  
ATOM   1281  OD1 ASN   170      54.316  36.116  71.650  1.00 62.59           O  
ATOM   1282  ND2 ASN   170      54.776  35.201  73.630  1.00 60.85           N  
ATOM   1283  C   ASN   170      56.633  36.520  69.770  1.00 57.38           C  
ATOM   1284  O   ASN   170      56.973  37.717  69.840  1.00 56.01           O  
ATOM   1285  N   PRO   171      55.849  36.056  68.789  1.00 56.90           N  
ATOM   1286  CA  PRO   171      55.367  36.937  67.802  1.00 57.10           C  
ATOM   1287  CB  PRO   171      54.419  36.076  66.990  1.00 56.60           C  
ATOM   1288  CG  PRO   171      54.150  34.955  67.780  1.00 57.11           C  
ATOM   1289  CD  PRO   171      55.364  34.698  68.538  1.00 57.22           C  
ATOM   1290  C   PRO   171      54.626  38.081  68.399  1.00 57.21           C  
ATOM   1291  O   PRO   171      54.505  39.109  67.740  1.00 59.25           O  
ATOM   1292  N   TYR   172      54.119  37.963  69.612  1.00 56.42           N  
ATOM   1293  CA  TYR   172      53.460  39.126  70.161  1.00 55.94           C  
ATOM   1294  CB  TYR   172      52.469  38.742  71.225  1.00 55.58           C  
ATOM   1295  CG  TYR   172      51.335  38.012  70.645  1.00 54.93           C  
ATOM   1296  CD1 TYR   172      50.325  38.713  69.986  1.00 56.22           C  
ATOM   1297  CE1 TYR   172      49.269  38.079  69.383  1.00 55.35           C  
ATOM   1298  CZ  TYR   172      49.197  36.714  69.449  1.00 56.18           C  
ATOM   1299  OH  TYR   172      48.134  36.123  68.864  1.00 55.80           O  
ATOM   1300  CE2 TYR   172      50.177  35.961  70.112  1.00 56.67           C  
ATOM   1301  CD2 TYR   172      51.256  36.632  70.713  1.00 55.81           C  
ATOM   1302  C   TYR   172      54.440  40.143  70.678  1.00 56.09           C  
ATOM   1303  O   TYR   172      54.041  41.229  70.922  1.00 56.96           O  
ATOM   1304  N   ASP   173      55.722  39.824  70.827  1.00 56.70           N  
ATOM   1305  CA  ASP   173      56.677  40.762  71.464  1.00 56.94           C  
ATOM   1306  CB  ASP   173      57.619  39.987  72.378  1.00 57.07           C  
ATOM   1307  CG  ASP   173      56.891  39.343  73.584  1.00 59.70           C  
ATOM   1308  OD1 ASP   173      55.715  39.682  73.957  1.00 60.73           O  
ATOM   1309  OD2 ASP   173      57.534  38.458  74.189  1.00 64.57           O  
ATOM   1310  C   ASP   173      57.504  41.542  70.452  1.00 57.10           C  
ATOM   1311  O   ASP   173      58.517  42.160  70.764  1.00 56.92           O  
ATOM   1312  N   ILE   174      57.061  41.519  69.208  1.00 57.50           N  
ATOM   1313  CA  ILE   174      57.918  41.926  68.107  1.00 56.84           C  
ATOM   1314  CB  ILE   174      58.589  40.690  67.518  1.00 56.70           C  
ATOM   1315  CG1 ILE   174      59.599  41.092  66.467  1.00 57.77           C  
ATOM   1316  CD1 ILE   174      60.661  40.028  66.250  1.00 57.91           C  
ATOM   1317  CG2 ILE   174      57.544  39.699  66.969  1.00 55.22           C  
ATOM   1318  C   ILE   174      57.023  42.643  67.120  1.00 56.45           C  
ATOM   1319  O   ILE   174      55.813  42.344  67.064  1.00 56.87           O  
ATOM   1320  N   THR   175      57.575  43.650  66.447  1.00 55.75           N  
ATOM   1321  CA  THR   175      56.850  44.351  65.389  1.00 55.67           C  
ATOM   1322  CB  THR   175      57.084  45.848  65.362  1.00 55.12           C  
ATOM   1323  OG1 THR   175      58.475  46.140  65.204  1.00 51.68           O  
ATOM   1324  CG2 THR   175      56.585  46.411  66.591  1.00 53.75           C  
ATOM   1325  C   THR   175      57.308  43.811  64.061  1.00 56.37           C  
ATOM   1326  O   THR   175      58.357  43.136  63.971  1.00 56.76           O  
ATOM   1327  N   GLY   176      56.532  44.115  63.029  1.00 55.97           N  
ATOM   1328  CA  GLY   176      56.877  43.622  61.697  1.00 55.00           C  
ATOM   1329  C   GLY   176      58.209  44.171  61.236  1.00 54.36           C  
ATOM   1330  O   GLY   176      59.011  43.437  60.620  1.00 53.31           O  
ATOM   1331  N   ALA   177      58.447  45.467  61.523  1.00 53.85           N  
ATOM   1332  CA  ALA   177      59.708  46.112  61.110  1.00 53.00           C  
ATOM   1333  CB  ALA   177      59.786  47.477  61.598  1.00 51.26           C  
ATOM   1334  C   ALA   177      60.852  45.297  61.675  1.00 53.34           C  
ATOM   1335  O   ALA   177      61.852  45.152  61.021  1.00 53.45           O  
ATOM   1336  N   GLU   178      60.654  44.743  62.890  1.00 53.75           N  
ATOM   1337  CA  GLU   178      61.667  44.026  63.674  1.00 53.30           C  
ATOM   1338  CB  GLU   178      61.261  43.985  65.162  1.00 54.23           C  
ATOM   1339  CG  GLU   178      61.696  45.215  65.982  1.00 55.75           C  
ATOM   1340  CD  GLU   178      60.861  45.500  67.251  1.00 55.56           C  
ATOM   1341  OE1 GLU   178      59.978  44.704  67.638  1.00 59.89           O  
ATOM   1342  OE2 GLU   178      61.094  46.567  67.857  1.00 58.55           O  
ATOM   1343  C   GLU   178      61.886  42.594  63.224  1.00 52.73           C  
ATOM   1344  O   GLU   178      63.013  42.111  63.291  1.00 53.74           O  
ATOM   1345  N   VAL   179      60.813  41.916  62.800  1.00 51.25           N  
ATOM   1346  CA  VAL   179      60.897  40.591  62.128  1.00 49.92           C  
ATOM   1347  CB  VAL   179      59.570  40.200  61.494  1.00 49.14           C  
ATOM   1348  CG1 VAL   179      59.636  38.784  61.000  1.00 49.19           C  
ATOM   1349  CG2 VAL   179      58.408  40.363  62.472  1.00 48.28           C  
ATOM   1350  C   VAL   179      61.975  40.492  61.036  1.00 48.85           C  
ATOM   1351  O   VAL   179      62.642  39.467  60.876  1.00 47.13           O  
ATOM   1352  N   LEU   180      62.169  41.579  60.302  1.00 49.16           N  
ATOM   1353  CA  LEU   180      63.079  41.552  59.170  1.00 49.72           C  
ATOM   1354  CB  LEU   180      63.224  42.904  58.525  1.00 47.84           C  
ATOM   1355  CG  LEU   180      61.920  43.407  57.910  1.00 46.38           C  
ATOM   1356  CD1 LEU   180      62.200  44.695  57.167  1.00 39.97           C  
ATOM   1357  CD2 LEU   180      61.195  42.326  57.003  1.00 40.86           C  
ATOM   1358  C   LEU   180      64.403  41.027  59.583  1.00 50.70           C  
ATOM   1359  O   LEU   180      64.941  40.181  58.908  1.00 50.63           O  
ATOM   1360  N   LYS   181      64.910  41.478  60.719  1.00 52.87           N  
ATOM   1361  CA  LYS   181      66.191  40.964  61.229  1.00 54.42           C  
ATOM   1362  CB  LYS   181      66.333  41.296  62.706  1.00 54.78           C  
ATOM   1363  CG  LYS   181      66.629  42.753  62.979  1.00 56.92           C  
ATOM   1364  CD  LYS   181      66.939  43.007  64.479  1.00 57.59           C  
ATOM   1365  CE  LYS   181      65.723  42.667  65.413  1.00 60.72           C  
ATOM   1366  NZ  LYS   181      64.692  43.742  65.242  1.00 63.49           N  
ATOM   1367  C   LYS   181      66.395  39.454  61.091  1.00 54.56           C  
ATOM   1368  O   LYS   181      67.513  38.992  60.961  1.00 53.84           O  
ATOM   1369  N   TYR   182      65.318  38.689  61.150  1.00 56.05           N  
ATOM   1370  CA  TYR   182      65.417  37.223  61.204  1.00 57.04           C  
ATOM   1371  CB  TYR   182      64.478  36.678  62.328  1.00 59.52           C  
ATOM   1372  CG  TYR   182      64.688  37.390  63.652  1.00 60.32           C  
ATOM   1373  CD1 TYR   182      65.790  37.088  64.436  1.00 61.47           C  
ATOM   1374  CE1 TYR   182      66.044  37.769  65.650  1.00 63.73           C  
ATOM   1375  CZ  TYR   182      65.181  38.784  66.088  1.00 64.96           C  
ATOM   1376  OH  TYR   182      65.488  39.453  67.297  1.00 62.03           O  
ATOM   1377  CE2 TYR   182      64.043  39.109  65.279  1.00 64.00           C  
ATOM   1378  CD2 TYR   182      63.811  38.402  64.084  1.00 62.05           C  
ATOM   1379  C   TYR   182      65.094  36.516  59.878  1.00 57.36           C  
ATOM   1380  O   TYR   182      64.900  35.300  59.881  1.00 57.75           O  
ATOM   1381  N   ILE   183      64.992  37.277  58.773  1.00 56.78           N  
ATOM   1382  CA  ILE   183      64.573  36.766  57.444  1.00 55.82           C  
ATOM   1383  CB  ILE   183      63.312  37.439  56.967  1.00 55.21           C  
ATOM   1384  CG1 ILE   183      62.159  37.146  57.930  1.00 54.19           C  
ATOM   1385  CD1 ILE   183      61.775  35.692  58.042  1.00 51.90           C  
ATOM   1386  CG2 ILE   183      63.034  36.990  55.548  1.00 55.52           C  
ATOM   1387  C   ILE   183      65.604  37.086  56.379  1.00 55.41           C  
ATOM   1388  O   ILE   183      65.993  38.241  56.234  1.00 55.89           O  
ATOM   1389  N   ASP   184      66.055  36.064  55.660  1.00 54.86           N  
ATOM   1390  CA  ASP   184      66.911  36.236  54.501  1.00 54.65           C  
ATOM   1391  CB  ASP   184      68.000  35.172  54.504  1.00 54.51           C  
ATOM   1392  CG  ASP   184      68.901  35.213  53.276  1.00 56.25           C  
ATOM   1393  OD1 ASP   184      68.569  35.845  52.234  1.00 60.63           O  
ATOM   1394  OD2 ASP   184      69.958  34.561  53.341  1.00 59.14           O  
ATOM   1395  C   ASP   184      65.980  36.099  53.285  1.00 54.37           C  
ATOM   1396  O   ASP   184      65.494  35.021  52.990  1.00 54.47           O  
ATOM   1397  N   PHE   185      65.689  37.193  52.602  1.00 53.46           N  
ATOM   1398  CA  PHE   185      64.734  37.104  51.528  1.00 53.40           C  
ATOM   1399  CB  PHE   185      64.352  38.502  51.076  1.00 53.07           C  
ATOM   1400  CG  PHE   185      63.298  39.126  51.909  1.00 52.32           C  
ATOM   1401  CD1 PHE   185      63.622  39.974  52.937  1.00 53.28           C  
ATOM   1402  CE1 PHE   185      62.621  40.550  53.704  1.00 53.55           C  
ATOM   1403  CZ  PHE   185      61.290  40.261  53.454  1.00 52.75           C  
ATOM   1404  CE2 PHE   185      60.965  39.413  52.458  1.00 52.74           C  
ATOM   1405  CD2 PHE   185      61.965  38.848  51.677  1.00 52.79           C  
ATOM   1406  C   PHE   185      65.292  36.261  50.366  1.00 53.48           C  
ATOM   1407  O   PHE   185      64.534  35.574  49.655  1.00 52.94           O  
ATOM   1408  N   ASN   186      66.620  36.289  50.214  1.00 53.44           N  
ATOM   1409  CA  ASN   186      67.276  35.505  49.190  1.00 53.70           C  
ATOM   1410  CB  ASN   186      68.763  35.846  49.068  1.00 53.36           C  
ATOM   1411  CG  ASN   186      69.053  37.329  49.045  1.00 52.80           C  
ATOM   1412  OD1 ASN   186      68.879  38.015  48.037  1.00 53.85           O  
ATOM   1413  ND2 ASN   186      69.581  37.816  50.143  1.00 50.90           N  
ATOM   1414  C   ASN   186      67.196  33.990  49.427  1.00 54.10           C  
ATOM   1415  O   ASN   186      67.575  33.221  48.548  1.00 53.83           O  
ATOM   1416  N   ALA   187      66.732  33.553  50.595  1.00 54.69           N  
ATOM   1417  CA  ALA   187      66.945  32.167  50.996  1.00 55.09           C  
ATOM   1418  CB  ALA   187      66.912  32.010  52.473  1.00 54.22           C  
ATOM   1419  C   ALA   187      66.025  31.153  50.271  1.00 56.70           C  
ATOM   1420  O   ALA   187      66.495  30.044  49.982  1.00 57.59           O  
ATOM   1421  N   GLY   188      64.731  31.410  50.058  1.00 57.62           N  
ATOM   1422  CA  GLY   188      63.853  31.960  51.043  1.00 59.02           C  
ATOM   1423  C   GLY   188      62.511  31.219  50.981  1.00 59.74           C  
ATOM   1424  O   GLY   188      61.723  31.467  50.074  1.00 61.22           O  
ATOM   1425  N   ASN   189      62.211  30.293  51.881  1.00 59.50           N  
ATOM   1426  CA  ASN   189      60.813  29.870  51.972  1.00 59.43           C  
ATOM   1427  CB  ASN   189      60.668  28.385  52.248  1.00 60.14           C  
ATOM   1428  CG  ASN   189      61.261  27.525  51.126  1.00 63.26           C  
ATOM   1429  OD1 ASN   189      60.745  27.503  50.000  1.00 69.09           O  
ATOM   1430  ND2 ASN   189      62.350  26.821  51.426  1.00 64.80           N  
ATOM   1431  C   ASN   189      60.293  30.684  53.108  1.00 58.76           C  
ATOM   1432  O   ASN   189      60.330  30.263  54.271  1.00 58.80           O  
ATOM   1433  N   ILE   190      59.854  31.888  52.803  1.00 57.34           N  
ATOM   1434  CA  ILE   190      59.455  32.763  53.879  1.00 56.55           C  
ATOM   1435  CB  ILE   190      58.825  34.052  53.346  1.00 56.31           C  
ATOM   1436  CG1 ILE   190      59.806  34.830  52.424  1.00 54.63           C  
ATOM   1437  CD1 ILE   190      61.277  34.745  52.731  1.00 53.57           C  
ATOM   1438  CG2 ILE   190      58.330  34.938  54.487  1.00 56.75           C  
ATOM   1439  C   ILE   190      58.560  32.078  54.944  1.00 56.38           C  
ATOM   1440  O   ILE   190      58.859  32.153  56.122  1.00 57.24           O  
ATOM   1441  N   ALA   191      57.514  31.365  54.574  1.00 55.84           N  
ATOM   1442  CA  ALA   191      56.737  30.678  55.600  1.00 55.62           C  
ATOM   1443  CB  ALA   191      55.619  29.905  55.014  1.00 54.96           C  
ATOM   1444  C   ALA   191      57.597  29.783  56.478  1.00 55.39           C  
ATOM   1445  O   ALA   191      57.483  29.839  57.693  1.00 55.38           O  
ATOM   1446  N   LYS   192      58.472  28.983  55.886  1.00 55.73           N  
ATOM   1447  CA  LYS   192      59.364  28.075  56.674  1.00 55.84           C  
ATOM   1448  CB  LYS   192      60.210  27.239  55.726  1.00 55.97           C  
ATOM   1449  CG  LYS   192      60.980  26.090  56.341  1.00 57.41           C  
ATOM   1450  CD  LYS   192      62.020  25.514  55.282  1.00 59.41           C  
ATOM   1451  CE  LYS   192      62.867  24.265  55.819  1.00 61.74           C  
ATOM   1452  NZ  LYS   192      63.481  23.500  54.653  1.00 60.86           N  
ATOM   1453  C   LYS   192      60.297  28.797  57.679  1.00 55.26           C  
ATOM   1454  O   LYS   192      60.639  28.287  58.730  1.00 54.68           O  
ATOM   1455  N   GLN   193      60.724  29.987  57.301  1.00 55.35           N  
ATOM   1456  CA  GLN   193      61.585  30.832  58.108  1.00 54.38           C  
ATOM   1457  CB  GLN   193      62.115  31.993  57.244  1.00 53.90           C  
ATOM   1458  CG  GLN   193      63.087  31.554  56.147  1.00 52.93           C  
ATOM   1459  CD  GLN   193      63.962  32.694  55.621  1.00 53.47           C  
ATOM   1460  OE1 GLN   193      64.104  32.901  54.417  1.00 51.49           O  
ATOM   1461  NE2 GLN   193      64.528  33.451  56.529  1.00 55.09           N  
ATOM   1462  C   GLN   193      60.765  31.383  59.241  1.00 53.88           C  
ATOM   1463  O   GLN   193      61.235  31.505  60.358  1.00 54.19           O  
ATOM   1464  N   LEU   194      59.534  31.755  58.955  1.00 53.27           N  
ATOM   1465  CA  LEU   194      58.716  32.295  59.994  1.00 53.33           C  
ATOM   1466  CB  LEU   194      57.432  32.856  59.425  1.00 52.86           C  
ATOM   1467  CG  LEU   194      57.462  34.117  58.566  1.00 50.30           C  
ATOM   1468  CD1 LEU   194      56.064  34.352  58.050  1.00 46.63           C  
ATOM   1469  CD2 LEU   194      57.965  35.313  59.354  1.00 46.73           C  
ATOM   1470  C   LEU   194      58.410  31.164  60.968  1.00 54.40           C  
ATOM   1471  O   LEU   194      58.433  31.358  62.167  1.00 55.26           O  
ATOM   1472  N   LEU   195      58.145  29.964  60.459  1.00 54.97           N  
ATOM   1473  CA  LEU   195      57.936  28.819  61.335  1.00 54.73           C  
ATOM   1474  CB  LEU   195      57.570  27.579  60.531  1.00 54.24           C  
ATOM   1475  CG  LEU   195      56.787  26.499  61.269  1.00 54.25           C  
ATOM   1476  CD1 LEU   195      55.409  27.022  61.737  1.00 55.95           C  
ATOM   1477  CD2 LEU   195      56.593  25.278  60.379  1.00 53.17           C  
ATOM   1478  C   LEU   195      59.177  28.557  62.193  1.00 55.04           C  
ATOM   1479  O   LEU   195      59.069  28.261  63.341  1.00 55.82           O  
ATOM   1480  N   ASN   196      60.357  28.691  61.662  1.00 55.87           N  
ATOM   1481  CA  ASN   196      61.518  28.408  62.465  1.00 57.39           C  
ATOM   1482  CB  ASN   196      62.810  28.337  61.622  1.00 58.19           C  
ATOM   1483  CG  ASN   196      62.756  27.292  60.566  1.00 58.66           C  
ATOM   1484  OD1 ASN   196      62.148  26.244  60.766  1.00 57.74           O  
ATOM   1485  ND2 ASN   196      63.361  27.586  59.406  1.00 60.48           N  
ATOM   1486  C   ASN   196      61.823  29.422  63.529  1.00 58.16           C  
ATOM   1487  O   ASN   196      62.600  29.108  64.384  1.00 57.65           O  
ATOM   1488  N   GLN   197      61.323  30.652  63.463  1.00 59.58           N  
ATOM   1489  CA  GLN   197      61.821  31.655  64.416  1.00 60.35           C  
ATOM   1490  CB  GLN   197      62.306  32.921  63.714  1.00 61.18           C  
ATOM   1491  CG  GLN   197      63.833  33.053  63.720  1.00 63.47           C  
ATOM   1492  CD  GLN   197      64.418  32.727  62.347  1.00 65.44           C  
ATOM   1493  OE1 GLN   197      65.466  33.251  61.970  1.00 65.09           O  
ATOM   1494  NE2 GLN   197      63.710  31.894  61.575  1.00 66.60           N  
ATOM   1495  C   GLN   197      60.827  32.071  65.450  1.00 61.19           C  
ATOM   1496  O   GLN   197      61.199  32.727  66.444  1.00 61.90           O  
ATOM   1497  N   PHE   198      59.572  31.708  65.224  1.00 61.74           N  
ATOM   1498  CA  PHE   198      58.476  32.250  66.007  1.00 62.50           C  
ATOM   1499  CB  PHE   198      57.610  33.136  65.091  1.00 63.24           C  
ATOM   1500  CG  PHE   198      58.311  34.400  64.721  1.00 63.23           C  
ATOM   1501  CD1 PHE   198      58.289  35.494  65.576  1.00 64.85           C  
ATOM   1502  CE1 PHE   198      58.998  36.692  65.280  1.00 64.76           C  
ATOM   1503  CZ  PHE   198      59.769  36.766  64.135  1.00 65.71           C  
ATOM   1504  CE2 PHE   198      59.845  35.649  63.294  1.00 65.67           C  
ATOM   1505  CD2 PHE   198      59.121  34.457  63.610  1.00 64.94           C  
ATOM   1506  C   PHE   198      57.719  31.184  66.761  1.00 62.01           C  
ATOM   1507  O   PHE   198      57.315  30.164  66.204  1.00 60.95           O  
ATOM   1508  N   GLU   199      57.624  31.418  68.066  1.00 63.23           N  
ATOM   1509  CA  GLU   199      57.033  30.463  69.050  1.00 63.40           C  
ATOM   1510  CB  GLU   199      57.253  30.965  70.523  1.00 64.68           C  
ATOM   1511  CG  GLU   199      56.559  30.142  71.715  1.00 65.60           C  
ATOM   1512  CD  GLU   199      56.710  30.770  73.173  1.00 67.04           C  
ATOM   1513  OE1 GLU   199      56.751  32.040  73.366  1.00 68.38           O  
ATOM   1514  OE2 GLU   199      56.762  29.934  74.144  1.00 72.60           O  
ATOM   1515  C   GLU   199      55.568  30.284  68.756  1.00 61.53           C  
ATOM   1516  O   GLU   199      54.804  31.236  68.553  1.00 60.87           O  
ATOM   1517  N   GLY   200      55.162  29.049  68.711  1.00 60.14           N  
ATOM   1518  CA  GLY   200      53.757  28.785  68.487  1.00 59.79           C  
ATOM   1519  C   GLY   200      53.182  28.977  67.100  1.00 59.49           C  
ATOM   1520  O   GLY   200      51.968  28.862  66.927  1.00 60.69           O  
ATOM   1521  N   PHE   201      54.017  29.239  66.106  1.00 58.81           N  
ATOM   1522  CA  PHE   201      53.544  29.299  64.721  1.00 58.07           C  
ATOM   1523  CB  PHE   201      54.528  30.080  63.856  1.00 57.64           C  
ATOM   1524  CG  PHE   201      54.273  31.575  63.815  1.00 57.73           C  
ATOM   1525  CD1 PHE   201      53.175  32.160  64.476  1.00 56.03           C  
ATOM   1526  CE1 PHE   201      52.942  33.521  64.394  1.00 55.74           C  
ATOM   1527  CZ  PHE   201      53.781  34.298  63.648  1.00 56.16           C  
ATOM   1528  CE2 PHE   201      54.864  33.734  62.968  1.00 55.47           C  
ATOM   1529  CD2 PHE   201      55.099  32.387  63.041  1.00 56.26           C  
ATOM   1530  C   PHE   201      53.304  27.922  64.107  1.00 57.71           C  
ATOM   1531  O   PHE   201      53.800  26.916  64.607  1.00 58.91           O  
ATOM   1532  N   SER   202      52.493  27.903  63.056  1.00 57.12           N  
ATOM   1533  CA  SER   202      52.192  26.717  62.239  1.00 56.29           C  
ATOM   1534  CB  SER   202      50.774  26.233  62.487  1.00 55.27           C  
ATOM   1535  OG  SER   202      49.885  27.334  62.345  1.00 54.15           O  
ATOM   1536  C   SER   202      52.237  27.109  60.760  1.00 56.32           C  
ATOM   1537  O   SER   202      52.035  28.315  60.398  1.00 57.11           O  
ATOM   1538  N   PRO   203      52.417  26.096  59.899  1.00 55.17           N  
ATOM   1539  CA  PRO   203      52.217  26.169  58.489  1.00 54.93           C  
ATOM   1540  CB  PRO   203      51.982  24.718  58.157  1.00 54.79           C  
ATOM   1541  CG  PRO   203      52.900  24.041  58.998  1.00 54.00           C  
ATOM   1542  CD  PRO   203      52.830  24.741  60.271  1.00 55.35           C  
ATOM   1543  C   PRO   203      51.005  27.036  58.113  1.00 54.44           C  
ATOM   1544  O   PRO   203      51.143  28.012  57.362  1.00 54.15           O  
ATOM   1545  N   LEU   204      49.855  26.711  58.689  1.00 53.91           N  
ATOM   1546  CA  LEU   204      48.646  27.446  58.419  1.00 54.19           C  
ATOM   1547  CB  LEU   204      47.528  27.053  59.371  1.00 54.64           C  
ATOM   1548  CG  LEU   204      46.784  25.767  59.012  1.00 55.67           C  
ATOM   1549  CD1 LEU   204      46.040  25.053  60.208  1.00 56.69           C  
ATOM   1550  CD2 LEU   204      45.830  26.158  57.902  1.00 56.96           C  
ATOM   1551  C   LEU   204      48.868  28.919  58.524  1.00 54.22           C  
ATOM   1552  O   LEU   204      48.571  29.667  57.557  1.00 55.59           O  
ATOM   1553  N   ILE   205      49.395  29.365  59.659  1.00 53.53           N  
ATOM   1554  CA  ILE   205      49.485  30.804  59.859  1.00 53.25           C  
ATOM   1555  CB  ILE   205      49.535  31.177  61.363  1.00 54.03           C  
ATOM   1556  CG1 ILE   205      49.136  32.662  61.552  1.00 54.55           C  
ATOM   1557  CD1 ILE   205      47.640  32.939  61.303  1.00 53.78           C  
ATOM   1558  CG2 ILE   205      50.874  30.748  62.006  1.00 51.62           C  
ATOM   1559  C   ILE   205      50.659  31.416  59.062  1.00 53.04           C  
ATOM   1560  O   ILE   205      50.516  32.522  58.503  1.00 51.64           O  
ATOM   1561  N   THR   206      51.784  30.688  58.976  1.00 52.57           N  
ATOM   1562  CA  THR   206      52.908  31.174  58.176  1.00 52.67           C  
ATOM   1563  CB  THR   206      54.182  30.297  58.286  1.00 51.95           C  
ATOM   1564  OG1 THR   206      53.851  28.925  58.179  1.00 49.67           O  
ATOM   1565  CG2 THR   206      54.854  30.509  59.602  1.00 52.05           C  
ATOM   1566  C   THR   206      52.477  31.337  56.717  1.00 52.92           C  
ATOM   1567  O   THR   206      52.723  32.395  56.101  1.00 52.13           O  
ATOM   1568  N   ASN   207      51.790  30.327  56.183  1.00 53.15           N  
ATOM   1569  CA  ASN   207      51.316  30.435  54.801  1.00 54.24           C  
ATOM   1570  CB  ASN   207      50.835  29.093  54.231  1.00 54.50           C  
ATOM   1571  CG  ASN   207      52.028  28.074  54.013  1.00 56.95           C  
ATOM   1572  OD1 ASN   207      51.834  26.874  53.952  1.00 59.50           O  
ATOM   1573  ND2 ASN   207      53.247  28.582  53.926  1.00 60.44           N  
ATOM   1574  C   ASN   207      50.316  31.562  54.650  1.00 54.17           C  
ATOM   1575  O   ASN   207      50.413  32.390  53.761  1.00 53.25           O  
ATOM   1576  N   GLU   208      49.423  31.681  55.602  1.00 55.26           N  
ATOM   1577  CA  GLU   208      48.529  32.842  55.579  1.00 55.82           C  
ATOM   1578  CB  GLU   208      47.589  32.805  56.782  1.00 55.23           C  
ATOM   1579  CG  GLU   208      46.524  33.875  56.676  1.00 55.39           C  
ATOM   1580  CD  GLU   208      45.530  33.615  55.578  1.00 57.78           C  
ATOM   1581  OE1 GLU   208      45.527  32.488  55.000  1.00 61.34           O  
ATOM   1582  OE2 GLU   208      44.725  34.532  55.300  1.00 59.27           O  
ATOM   1583  C   GLU   208      49.214  34.244  55.495  1.00 56.13           C  
ATOM   1584  O   GLU   208      48.736  35.111  54.783  1.00 55.43           O  
ATOM   1585  N   ILE   209      50.293  34.454  56.248  1.00 56.45           N  
ATOM   1586  CA  ILE   209      50.921  35.764  56.337  1.00 56.97           C  
ATOM   1587  CB  ILE   209      52.077  35.796  57.413  1.00 57.50           C  
ATOM   1588  CG1 ILE   209      51.515  35.553  58.830  1.00 59.38           C  
ATOM   1589  CD1 ILE   209      52.487  34.822  59.808  1.00 57.46           C  
ATOM   1590  CG2 ILE   209      52.938  37.133  57.349  1.00 55.85           C  
ATOM   1591  C   ILE   209      51.542  36.104  54.991  1.00 57.60           C  
ATOM   1592  O   ILE   209      51.332  37.221  54.447  1.00 57.59           O  
ATOM   1593  N   VAL   210      52.368  35.149  54.521  1.00 57.62           N  
ATOM   1594  CA  VAL   210      53.020  35.153  53.191  1.00 56.83           C  
ATOM   1595  CB  VAL   210      53.685  33.793  52.955  1.00 56.83           C  
ATOM   1596  CG1 VAL   210      53.559  33.397  51.544  1.00 54.22           C  
ATOM   1597  CG2 VAL   210      55.141  33.802  53.465  1.00 55.48           C  
ATOM   1598  C   VAL   210      52.037  35.449  52.047  1.00 56.43           C  
ATOM   1599  O   VAL   210      52.369  36.222  51.138  1.00 56.38           O  
ATOM   1600  N   SER   211      50.825  34.896  52.176  1.00 56.10           N  
ATOM   1601  CA  SER   211      49.650  35.188  51.314  1.00 56.65           C  
ATOM   1602  CB  SER   211      48.488  34.159  51.563  1.00 57.20           C  
ATOM   1603  OG  SER   211      47.430  34.685  52.415  1.00 57.88           O  
ATOM   1604  C   SER   211      48.980  36.541  51.421  1.00 56.15           C  
ATOM   1605  O   SER   211      47.991  36.772  50.749  1.00 57.13           O  
ATOM   1606  N   ARG   212      49.418  37.423  52.280  1.00 56.20           N  
ATOM   1607  CA  ARG   212      48.653  38.654  52.443  1.00 56.74           C  
ATOM   1608  CB  ARG   212      48.574  39.061  53.890  1.00 57.22           C  
ATOM   1609  CG  ARG   212      47.779  38.125  54.691  1.00 58.39           C  
ATOM   1610  CD  ARG   212      46.342  38.213  54.418  1.00 57.78           C  
ATOM   1611  NE  ARG   212      45.687  37.309  55.350  1.00 59.16           N  
ATOM   1612  CZ  ARG   212      44.974  37.688  56.413  1.00 58.38           C  
ATOM   1613  NH1 ARG   212      44.770  38.973  56.728  1.00 59.29           N  
ATOM   1614  NH2 ARG   212      44.444  36.758  57.161  1.00 55.31           N  
ATOM   1615  C   ARG   212      49.176  39.842  51.691  1.00 56.89           C  
ATOM   1616  O   ARG   212      48.782  40.983  52.023  1.00 56.43           O  
ATOM   1617  N   ARG   213      50.040  39.600  50.732  1.00 56.80           N  
ATOM   1618  CA  ARG   213      50.444  40.585  49.789  1.00 55.88           C  
ATOM   1619  CB  ARG   213      51.626  41.359  50.283  1.00 55.66           C  
ATOM   1620  CG  ARG   213      51.444  41.958  51.590  1.00 53.64           C  
ATOM   1621  CD  ARG   213      50.824  43.276  51.511  1.00 49.04           C  
ATOM   1622  NE  ARG   213      49.670  43.276  52.368  1.00 49.77           N  
ATOM   1623  CZ  ARG   213      49.371  44.248  53.196  1.00 50.41           C  
ATOM   1624  NH1 ARG   213      50.138  45.302  53.259  1.00 49.62           N  
ATOM   1625  NH2 ARG   213      48.308  44.160  53.955  1.00 48.16           N  
ATOM   1626  C   ARG   213      50.868  39.756  48.640  1.00 56.67           C  
ATOM   1627  O   ARG   213      50.996  38.567  48.763  1.00 58.18           O  
ATOM   1628  N   GLN   214      51.092  40.377  47.507  1.00 56.00           N  
ATOM   1629  CA  GLN   214      51.368  39.615  46.330  1.00 55.49           C  
ATOM   1630  CB  GLN   214      51.215  40.484  45.119  1.00 54.93           C  
ATOM   1631  CG  GLN   214      50.206  40.006  44.178  1.00 55.12           C  
ATOM   1632  CD  GLN   214      50.193  40.836  42.972  1.00 55.17           C  
ATOM   1633  OE1 GLN   214      50.335  42.041  43.044  1.00 53.10           O  
ATOM   1634  NE2 GLN   214      50.030  40.209  41.841  1.00 54.73           N  
ATOM   1635  C   GLN   214      52.753  39.106  46.390  1.00 54.51           C  
ATOM   1636  O   GLN   214      53.058  38.083  45.829  1.00 54.95           O  
ATOM   1637  N   PHE   215      53.606  39.826  47.081  1.00 52.93           N  
ATOM   1638  CA  PHE   215      54.978  39.413  47.126  1.00 52.65           C  
ATOM   1639  CB  PHE   215      55.768  40.213  46.116  1.00 53.02           C  
ATOM   1640  CG  PHE   215      55.432  39.881  44.714  1.00 53.63           C  
ATOM   1641  CD1 PHE   215      55.779  38.669  44.192  1.00 52.64           C  
ATOM   1642  CE1 PHE   215      55.471  38.360  42.924  1.00 52.66           C  
ATOM   1643  CZ  PHE   215      54.799  39.252  42.163  1.00 52.76           C  
ATOM   1644  CE2 PHE   215      54.446  40.456  42.662  1.00 52.53           C  
ATOM   1645  CD2 PHE   215      54.755  40.771  43.925  1.00 52.47           C  
ATOM   1646  C   PHE   215      55.574  39.589  48.478  1.00 51.25           C  
ATOM   1647  O   PHE   215      55.247  40.508  49.181  1.00 52.04           O  
ATOM   1648  N   MET   216      56.475  38.708  48.843  1.00 49.64           N  
ATOM   1649  CA  MET   216      57.132  38.862  50.139  1.00 48.63           C  
ATOM   1650  CB  MET   216      57.340  37.499  50.863  1.00 48.38           C  
ATOM   1651  CG  MET   216      56.156  36.939  51.693  1.00 46.59           C  
ATOM   1652  SD  MET   216      55.469  38.048  52.940  1.00 45.50           S  
ATOM   1653  CE  MET   216      54.083  38.750  52.009  1.00 43.49           C  
ATOM   1654  C   MET   216      58.458  39.602  49.897  1.00 48.05           C  
ATOM   1655  O   MET   216      59.315  39.114  49.196  1.00 47.67           O  
ATOM   1656  N   THR   217      58.598  40.776  50.507  1.00 47.87           N  
ATOM   1657  CA  THR   217      59.778  41.664  50.388  1.00 47.34           C  
ATOM   1658  CB  THR   217      59.540  42.837  49.409  1.00 47.58           C  
ATOM   1659  OG1 THR   217      58.814  43.878  50.106  1.00 46.70           O  
ATOM   1660  CG2 THR   217      58.769  42.379  48.189  1.00 44.19           C  
ATOM   1661  C   THR   217      59.940  42.364  51.720  1.00 46.72           C  
ATOM   1662  O   THR   217      59.042  42.322  52.524  1.00 46.43           O  
ATOM   1663  N   SER   218      61.035  43.086  51.890  1.00 46.41           N  
ATOM   1664  CA  SER   218      61.265  43.907  53.080  1.00 46.19           C  
ATOM   1665  CB  SER   218      62.626  44.572  52.990  1.00 45.63           C  
ATOM   1666  OG  SER   218      62.489  45.834  52.334  1.00 47.58           O  
ATOM   1667  C   SER   218      60.199  45.006  53.327  1.00 45.74           C  
ATOM   1668  O   SER   218      59.975  45.369  54.466  1.00 44.88           O  
ATOM   1669  N   SER   219      59.553  45.542  52.290  1.00 46.35           N  
ATOM   1670  CA  SER   219      58.403  46.427  52.528  1.00 47.16           C  
ATOM   1671  CB  SER   219      58.060  47.266  51.333  1.00 46.58           C  
ATOM   1672  OG  SER   219      59.187  47.996  51.006  1.00 47.75           O  
ATOM   1673  C   SER   219      57.130  45.696  52.894  1.00 48.04           C  
ATOM   1674  O   SER   219      56.330  46.191  53.689  1.00 49.24           O  
ATOM   1675  N   THR   220      56.898  44.532  52.321  1.00 48.31           N  
ATOM   1676  CA  THR   220      55.568  43.957  52.465  1.00 48.16           C  
ATOM   1677  CB  THR   220      55.196  43.183  51.194  1.00 49.17           C  
ATOM   1678  OG1 THR   220      56.260  42.272  50.896  1.00 50.74           O  
ATOM   1679  CG2 THR   220      54.915  44.141  50.059  1.00 44.82           C  
ATOM   1680  C   THR   220      55.414  43.032  53.674  1.00 47.89           C  
ATOM   1681  O   THR   220      54.334  42.962  54.286  1.00 46.24           O  
ATOM   1682  N   LEU   221      56.504  42.311  53.989  1.00 48.20           N  
ATOM   1683  CA  LEU   221      56.461  41.256  54.996  1.00 47.61           C  
ATOM   1684  CB  LEU   221      57.782  40.557  55.155  1.00 46.48           C  
ATOM   1685  CG  LEU   221      57.800  39.426  56.203  1.00 48.75           C  
ATOM   1686  CD1 LEU   221      56.470  38.648  56.303  1.00 50.59           C  
ATOM   1687  CD2 LEU   221      58.988  38.410  56.019  1.00 48.11           C  
ATOM   1688  C   LEU   221      55.973  41.871  56.278  1.00 48.13           C  
ATOM   1689  O   LEU   221      54.985  41.394  56.819  1.00 49.36           O  
ATOM   1690  N   PRO   222      56.581  42.996  56.722  1.00 47.89           N  
ATOM   1691  CA  PRO   222      56.131  43.664  57.944  1.00 47.78           C  
ATOM   1692  CB  PRO   222      56.903  44.967  57.922  1.00 47.02           C  
ATOM   1693  CG  PRO   222      58.128  44.640  57.194  1.00 47.30           C  
ATOM   1694  CD  PRO   222      57.724  43.709  56.126  1.00 47.86           C  
ATOM   1695  C   PRO   222      54.652  43.944  57.978  1.00 47.90           C  
ATOM   1696  O   PRO   222      54.009  43.676  58.960  1.00 47.04           O  
ATOM   1697  N   GLU   223      54.132  44.468  56.881  1.00 49.09           N  
ATOM   1698  CA  GLU   223      52.702  44.741  56.726  1.00 49.82           C  
ATOM   1699  CB  GLU   223      52.448  45.250  55.307  1.00 49.45           C  
ATOM   1700  CG  GLU   223      52.447  46.710  55.118  1.00 50.59           C  
ATOM   1701  CD  GLU   223      53.025  47.136  53.768  1.00 53.79           C  
ATOM   1702  OE1 GLU   223      52.836  46.390  52.760  1.00 64.29           O  
ATOM   1703  OE2 GLU   223      53.670  48.225  53.695  1.00 58.16           O  
ATOM   1704  C   GLU   223      51.871  43.489  56.907  1.00 49.23           C  
ATOM   1705  O   GLU   223      50.849  43.520  57.560  1.00 48.47           O  
ATOM   1706  N   ALA   224      52.295  42.401  56.280  1.00 49.72           N  
ATOM   1707  CA  ALA   224      51.536  41.165  56.343  1.00 51.44           C  
ATOM   1708  CB  ALA   224      52.163  40.106  55.401  1.00 51.49           C  
ATOM   1709  C   ALA   224      51.489  40.670  57.809  1.00 52.85           C  
ATOM   1710  O   ALA   224      50.424  40.541  58.444  1.00 53.64           O  
ATOM   1711  N   PHE   225      52.678  40.456  58.361  1.00 53.76           N  
ATOM   1712  CA  PHE   225      52.831  40.121  59.747  1.00 53.65           C  
ATOM   1713  CB  PHE   225      54.281  40.295  60.124  1.00 54.17           C  
ATOM   1714  CG  PHE   225      54.598  39.801  61.504  1.00 56.69           C  
ATOM   1715  CD1 PHE   225      55.016  38.484  61.720  1.00 58.37           C  
ATOM   1716  CE1 PHE   225      55.309  38.017  63.041  1.00 55.01           C  
ATOM   1717  CZ  PHE   225      55.183  38.843  64.088  1.00 53.46           C  
ATOM   1718  CE2 PHE   225      54.802  40.145  63.889  1.00 56.52           C  
ATOM   1719  CD2 PHE   225      54.489  40.633  62.608  1.00 57.51           C  
ATOM   1720  C   PHE   225      51.904  40.951  60.679  1.00 54.04           C  
ATOM   1721  O   PHE   225      51.042  40.383  61.380  1.00 54.85           O  
ATOM   1722  N   ASP   226      52.057  42.271  60.675  1.00 53.01           N  
ATOM   1723  CA  ASP   226      51.294  43.080  61.578  1.00 53.07           C  
ATOM   1724  CB  ASP   226      51.699  44.548  61.467  1.00 52.40           C  
ATOM   1725  CG  ASP   226      53.113  44.847  62.093  1.00 53.38           C  
ATOM   1726  OD1 ASP   226      53.653  44.023  62.962  1.00 51.35           O  
ATOM   1727  OD2 ASP   226      53.669  45.934  61.699  1.00 48.55           O  
ATOM   1728  C   ASP   226      49.801  42.838  61.330  1.00 53.38           C  
ATOM   1729  O   ASP   226      49.046  42.480  62.252  1.00 53.49           O  
ATOM   1730  N   GLU   227      49.389  42.924  60.075  1.00 54.03           N  
ATOM   1731  CA  GLU   227      47.999  42.712  59.723  1.00 54.36           C  
ATOM   1732  CB  GLU   227      47.862  42.611  58.221  1.00 54.35           C  
ATOM   1733  CG  GLU   227      46.491  43.047  57.703  1.00 56.78           C  
ATOM   1734  CD  GLU   227      46.152  42.565  56.254  1.00 57.35           C  
ATOM   1735  OE1 GLU   227      45.951  43.469  55.357  1.00 59.61           O  
ATOM   1736  OE2 GLU   227      46.061  41.296  56.046  1.00 58.50           O  
ATOM   1737  C   GLU   227      47.490  41.430  60.369  1.00 54.28           C  
ATOM   1738  O   GLU   227      46.450  41.397  61.026  1.00 54.29           O  
ATOM   1739  N   VAL   228      48.235  40.356  60.215  1.00 54.34           N  
ATOM   1740  CA  VAL   228      47.744  39.093  60.752  1.00 54.56           C  
ATOM   1741  CB  VAL   228      48.543  37.901  60.244  1.00 54.76           C  
ATOM   1742  CG1 VAL   228      48.211  36.632  61.062  1.00 55.28           C  
ATOM   1743  CG2 VAL   228      48.207  37.690  58.807  1.00 54.18           C  
ATOM   1744  C   VAL   228      47.711  39.053  62.266  1.00 54.31           C  
ATOM   1745  O   VAL   228      46.734  38.589  62.825  1.00 53.90           O  
ATOM   1746  N   MET   229      48.775  39.526  62.914  1.00 54.01           N  
ATOM   1747  CA  MET   229      48.828  39.476  64.364  1.00 53.65           C  
ATOM   1748  CB  MET   229      50.200  39.810  64.905  1.00 52.89           C  
ATOM   1749  CG  MET   229      51.306  38.867  64.431  1.00 51.26           C  
ATOM   1750  SD  MET   229      51.304  37.233  65.155  1.00 46.88           S  
ATOM   1751  CE  MET   229      50.165  36.437  64.133  1.00 49.03           C  
ATOM   1752  C   MET   229      47.756  40.386  64.952  1.00 53.59           C  
ATOM   1753  O   MET   229      47.123  40.038  65.945  1.00 53.15           O  
ATOM   1754  N   ALA   230      47.464  41.500  64.303  1.00 53.86           N  
ATOM   1755  CA  ALA   230      46.270  42.282  64.731  1.00 54.04           C  
ATOM   1756  CB  ALA   230      46.140  43.542  63.948  1.00 51.66           C  
ATOM   1757  C   ALA   230      44.968  41.428  64.666  1.00 54.13           C  
ATOM   1758  O   ALA   230      44.189  41.376  65.603  1.00 53.64           O  
ATOM   1759  N   GLU   231      44.737  40.737  63.574  1.00 55.17           N  
ATOM   1760  CA  GLU   231      43.548  39.929  63.492  1.00 56.47           C  
ATOM   1761  CB  GLU   231      43.523  39.255  62.139  1.00 56.63           C  
ATOM   1762  CG  GLU   231      42.845  40.053  61.072  1.00 59.59           C  
ATOM   1763  CD  GLU   231      42.881  39.377  59.663  1.00 60.96           C  
ATOM   1764  OE1 GLU   231      42.597  38.132  59.620  1.00 61.26           O  
ATOM   1765  OE2 GLU   231      43.151  40.122  58.627  1.00 66.83           O  
ATOM   1766  C   GLU   231      43.473  38.853  64.619  1.00 56.60           C  
ATOM   1767  O   GLU   231      42.379  38.435  65.077  1.00 56.06           O  
ATOM   1768  N   THR   232      44.627  38.375  65.078  1.00 57.13           N  
ATOM   1769  CA  THR   232      44.588  37.338  66.127  1.00 56.91           C  
ATOM   1770  CB  THR   232      45.929  36.776  66.492  1.00 56.05           C  
ATOM   1771  OG1 THR   232      46.809  37.850  66.880  1.00 52.73           O  
ATOM   1772  CG2 THR   232      46.443  35.992  65.330  1.00 55.48           C  
ATOM   1773  C   THR   232      44.000  37.886  67.397  1.00 57.57           C  
ATOM   1774  O   THR   232      43.532  37.126  68.203  1.00 58.60           O  
ATOM   1775  N   LYS   233      44.049  39.199  67.570  1.00 57.71           N  
ATOM   1776  CA  LYS   233      43.540  39.844  68.767  1.00 57.50           C  
ATOM   1777  CB  LYS   233      44.251  41.167  68.975  1.00 56.79           C  
ATOM   1778  CG  LYS   233      45.682  40.926  69.191  1.00 56.33           C  
ATOM   1779  CD  LYS   233      46.407  42.182  69.201  1.00 58.05           C  
ATOM   1780  CE  LYS   233      47.861  41.950  69.602  1.00 60.79           C  
ATOM   1781  NZ  LYS   233      48.289  43.255  70.239  1.00 64.17           N  
ATOM   1782  C   LYS   233      42.067  40.103  68.675  1.00 58.38           C  
ATOM   1783  O   LYS   233      41.458  40.571  69.633  1.00 59.64           O  
ATOM   1784  N   LEU   234      41.471  39.856  67.518  1.00 58.35           N  
ATOM   1785  CA  LEU   234      40.047  40.055  67.434  1.00 57.46           C  
ATOM   1786  CB  LEU   234      39.677  40.528  66.037  1.00 57.94           C  
ATOM   1787  CG  LEU   234      39.756  42.057  65.894  1.00 58.27           C  
ATOM   1788  CD1 LEU   234      40.949  42.538  66.697  1.00 59.90           C  
ATOM   1789  CD2 LEU   234      39.837  42.465  64.449  1.00 56.72           C  
ATOM   1790  C   LEU   234      39.377  38.759  67.872  1.00 57.03           C  
ATOM   1791  O   LEU   234      40.007  37.719  67.898  1.00 56.48           O  
ATOM   1792  N   PRO   235      38.119  38.837  68.304  1.00 56.78           N  
ATOM   1793  CA  PRO   235      37.403  37.612  68.588  1.00 57.06           C  
ATOM   1794  CB  PRO   235      36.009  38.107  68.951  1.00 56.13           C  
ATOM   1795  CG  PRO   235      35.933  39.448  68.479  1.00 55.48           C  
ATOM   1796  CD  PRO   235      37.275  40.015  68.523  1.00 56.19           C  
ATOM   1797  C   PRO   235      37.351  36.729  67.327  1.00 57.69           C  
ATOM   1798  O   PRO   235      37.213  37.235  66.219  1.00 57.92           O  
ATOM   1799  N   PRO   236      37.425  35.413  67.493  1.00 58.22           N  
ATOM   1800  CA  PRO   236      37.744  34.610  66.340  1.00 58.10           C  
ATOM   1801  CB  PRO   236      38.325  33.359  66.970  1.00 58.25           C  
ATOM   1802  CG  PRO   236      37.422  33.136  68.189  1.00 58.04           C  
ATOM   1803  CD  PRO   236      37.156  34.577  68.688  1.00 58.45           C  
ATOM   1804  C   PRO   236      36.514  34.194  65.560  1.00 58.39           C  
ATOM   1805  O   PRO   236      35.378  34.320  66.042  1.00 57.01           O  
ATOM   1806  N   THR   237      36.794  33.661  64.368  1.00 58.97           N  
ATOM   1807  CA  THR   237      35.827  32.949  63.549  1.00 58.76           C  
ATOM   1808  CB  THR   237      35.868  33.463  62.189  1.00 58.85           C  
ATOM   1809  OG1 THR   237      35.466  34.831  62.260  1.00 59.79           O  
ATOM   1810  CG2 THR   237      34.924  32.670  61.320  1.00 59.79           C  
ATOM   1811  C   THR   237      36.136  31.476  63.538  1.00 58.51           C  
ATOM   1812  O   THR   237      37.034  30.979  62.852  1.00 57.58           O  
ATOM   1813  N   PRO   238      35.417  30.770  64.370  1.00 59.11           N  
ATOM   1814  CA  PRO   238      35.594  29.334  64.399  1.00 60.04           C  
ATOM   1815  CB  PRO   238      34.640  28.872  65.530  1.00 59.91           C  
ATOM   1816  CG  PRO   238      34.272  30.092  66.278  1.00 59.22           C  
ATOM   1817  CD  PRO   238      34.415  31.250  65.333  1.00 59.02           C  
ATOM   1818  C   PRO   238      35.165  28.771  63.055  1.00 60.41           C  
ATOM   1819  O   PRO   238      34.010  28.951  62.685  1.00 60.91           O  
ATOM   1820  N   ILE   239      36.068  28.097  62.346  1.00 60.56           N  
ATOM   1821  CA  ILE   239      35.797  27.704  60.989  1.00 60.68           C  
ATOM   1822  CB  ILE   239      36.312  28.777  60.065  1.00 60.69           C  
ATOM   1823  CG1 ILE   239      35.801  28.552  58.648  1.00 60.81           C  
ATOM   1824  CD1 ILE   239      35.547  29.854  57.941  1.00 61.28           C  
ATOM   1825  CG2 ILE   239      37.839  28.864  60.130  1.00 60.77           C  
ATOM   1826  C   ILE   239      36.379  26.382  60.582  1.00 60.66           C  
ATOM   1827  O   ILE   239      37.537  26.094  60.818  1.00 59.60           O  
ATOM   1828  N   PHE   240      35.525  25.600  59.937  1.00 62.55           N  
ATOM   1829  CA  PHE   240      35.832  24.268  59.367  1.00 63.50           C  
ATOM   1830  CB  PHE   240      34.651  23.342  59.646  1.00 64.12           C  
ATOM   1831  CG  PHE   240      34.790  21.970  59.051  1.00 64.17           C  
ATOM   1832  CD1 PHE   240      35.617  21.019  59.641  1.00 65.39           C  
ATOM   1833  CE1 PHE   240      35.736  19.709  59.104  1.00 65.07           C  
ATOM   1834  CZ  PHE   240      35.031  19.366  57.986  1.00 64.69           C  
ATOM   1835  CE2 PHE   240      34.191  20.315  57.388  1.00 64.75           C  
ATOM   1836  CD2 PHE   240      34.064  21.603  57.926  1.00 65.49           C  
ATOM   1837  C   PHE   240      35.990  24.317  57.873  1.00 63.92           C  
ATOM   1838  O   PHE   240      35.179  24.925  57.207  1.00 63.86           O  
ATOM   1839  N   HIS   241      36.991  23.654  57.326  1.00 65.06           N  
ATOM   1840  CA  HIS   241      37.162  23.676  55.864  1.00 66.08           C  
ATOM   1841  CB  HIS   241      38.360  24.530  55.475  1.00 65.84           C  
ATOM   1842  CG  HIS   241      38.690  24.501  54.015  1.00 65.96           C  
ATOM   1843  ND1 HIS   241      39.422  23.487  53.441  1.00 67.40           N  
ATOM   1844  CE1 HIS   241      39.578  23.736  52.150  1.00 67.07           C  
ATOM   1845  NE2 HIS   241      38.995  24.887  51.873  1.00 66.00           N  
ATOM   1846  CD2 HIS   241      38.430  25.386  53.020  1.00 66.81           C  
ATOM   1847  C   HIS   241      37.340  22.270  55.334  1.00 67.20           C  
ATOM   1848  O   HIS   241      38.108  21.479  55.908  1.00 67.42           O  
ATOM   1849  N   ASN   243      38.456  20.577  51.720  1.00 70.21           N  
ATOM   1850  CA  ASN   243      38.872  20.490  50.320  1.00 71.02           C  
ATOM   1851  CB  ASN   243      40.393  20.391  50.203  1.00 70.84           C  
ATOM   1852  CG  ASN   243      40.867  20.603  48.780  1.00 71.08           C  
ATOM   1853  OD1 ASN   243      40.097  20.402  47.830  1.00 72.94           O  
ATOM   1854  ND2 ASN   243      42.115  21.034  48.615  1.00 70.41           N  
ATOM   1855  C   ASN   243      38.239  19.275  49.636  1.00 71.03           C  
ATOM   1856  O   ASN   243      38.421  18.144  50.084  1.00 70.81           O  
ATOM   1857  N   HIS   244      37.508  19.506  48.552  1.00 71.45           N  
ATOM   1858  CA  HIS   244      36.787  18.395  47.898  1.00 72.32           C  
ATOM   1859  CB  HIS   244      35.402  18.874  47.410  1.00 72.97           C  
ATOM   1860  CG  HIS   244      34.437  19.185  48.529  1.00 74.09           C  
ATOM   1861  ND1 HIS   244      33.738  18.205  49.213  1.00 74.28           N  
ATOM   1862  CE1 HIS   244      32.964  18.768  50.126  1.00 74.00           C  
ATOM   1863  NE2 HIS   244      33.141  20.077  50.069  1.00 75.08           N  
ATOM   1864  CD2 HIS   244      34.057  20.366  49.081  1.00 74.81           C  
ATOM   1865  C   HIS   244      37.635  17.685  46.796  1.00 72.19           C  
ATOM   1866  O   HIS   244      37.529  16.485  46.585  1.00 72.01           O  
ATOM   1867  N   GLU   245      38.460  18.474  46.123  1.00 72.31           N  
ATOM   1868  CA  GLU   245      39.709  18.048  45.463  1.00 72.01           C  
ATOM   1869  CB  GLU   245      40.497  19.361  45.129  1.00 72.78           C  
ATOM   1870  CG  GLU   245      41.727  19.257  44.268  1.00 73.32           C  
ATOM   1871  CD  GLU   245      41.544  18.244  43.188  1.00 76.23           C  
ATOM   1872  OE1 GLU   245      40.636  18.444  42.340  1.00 77.40           O  
ATOM   1873  OE2 GLU   245      42.278  17.226  43.215  1.00 78.17           O  
ATOM   1874  C   GLU   245      40.606  17.052  46.293  1.00 71.77           C  
ATOM   1875  O   GLU   245      40.915  15.970  45.819  1.00 71.98           O  
ATOM   1876  N   THR   246      41.012  17.429  47.513  1.00 70.83           N  
ATOM   1877  CA  THR   246      41.894  16.631  48.390  1.00 70.07           C  
ATOM   1878  CB  THR   246      42.591  17.557  49.490  1.00 70.62           C  
ATOM   1879  OG1 THR   246      43.300  18.623  48.856  1.00 72.35           O  
ATOM   1880  CG2 THR   246      43.565  16.796  50.431  1.00 70.20           C  
ATOM   1881  C   THR   246      41.156  15.559  49.177  1.00 69.07           C  
ATOM   1882  O   THR   246      41.751  14.554  49.507  1.00 68.80           O  
ATOM   1883  N   GLY   247      39.889  15.793  49.528  1.00 68.01           N  
ATOM   1884  CA  GLY   247      39.253  15.104  50.681  1.00 67.14           C  
ATOM   1885  C   GLY   247      39.628  15.674  52.076  1.00 66.27           C  
ATOM   1886  O   GLY   247      38.914  15.442  53.062  1.00 65.47           O  
ATOM   1887  N   LYS   248      40.735  16.425  52.163  1.00 65.09           N  
ATOM   1888  CA  LYS   248      41.247  16.980  53.435  1.00 64.76           C  
ATOM   1889  CB  LYS   248      42.490  17.837  53.175  1.00 64.40           C  
ATOM   1890  CG  LYS   248      43.265  18.218  54.419  1.00 63.97           C  
ATOM   1891  CD  LYS   248      44.549  18.932  54.018  1.00 65.03           C  
ATOM   1892  CE  LYS   248      45.393  19.478  55.199  1.00 64.61           C  
ATOM   1893  NZ  LYS   248      45.491  18.476  56.271  1.00 63.97           N  
ATOM   1894  C   LYS   248      40.235  17.812  54.281  1.00 64.50           C  
ATOM   1895  O   LYS   248      39.301  18.414  53.725  1.00 65.32           O  
ATOM   1896  N   GLU   249      40.437  17.820  55.613  1.00 63.10           N  
ATOM   1897  CA  GLU   249      39.711  18.671  56.557  1.00 61.95           C  
ATOM   1898  CB  GLU   249      38.701  17.865  57.368  1.00 61.30           C  
ATOM   1899  CG  GLU   249      37.888  16.895  56.496  1.00 62.51           C  
ATOM   1900  CD  GLU   249      36.815  16.060  57.232  1.00 62.38           C  
ATOM   1901  OE1 GLU   249      35.880  15.545  56.565  1.00 62.08           O  
ATOM   1902  OE2 GLU   249      36.908  15.881  58.462  1.00 64.07           O  
ATOM   1903  C   GLU   249      40.700  19.417  57.473  1.00 61.03           C  
ATOM   1904  O   GLU   249      41.782  18.955  57.811  1.00 59.65           O  
ATOM   1905  N   ASP   250      40.328  20.630  57.814  1.00 60.84           N  
ATOM   1906  CA  ASP   250      41.147  21.490  58.624  1.00 60.75           C  
ATOM   1907  CB  ASP   250      41.973  22.444  57.760  1.00 61.33           C  
ATOM   1908  CG  ASP   250      43.219  21.792  57.185  1.00 62.98           C  
ATOM   1909  OD1 ASP   250      44.233  21.684  57.907  1.00 66.92           O  
ATOM   1910  OD2 ASP   250      43.198  21.419  56.003  1.00 62.18           O  
ATOM   1911  C   ASP   250      40.177  22.293  59.427  1.00 60.32           C  
ATOM   1912  O   ASP   250      38.978  22.281  59.123  1.00 61.17           O  
ATOM   1913  N   PHE   251      40.696  22.980  60.442  1.00 59.37           N  
ATOM   1914  CA  PHE   251      39.938  23.933  61.245  1.00 58.83           C  
ATOM   1915  CB  PHE   251      39.381  23.259  62.514  1.00 59.11           C  
ATOM   1916  CG  PHE   251      40.481  22.660  63.451  1.00 59.95           C  
ATOM   1917  CD1 PHE   251      41.111  23.442  64.424  1.00 58.79           C  
ATOM   1918  CE1 PHE   251      42.096  22.927  65.237  1.00 57.67           C  
ATOM   1919  CZ  PHE   251      42.478  21.636  65.105  1.00 58.19           C  
ATOM   1920  CE2 PHE   251      41.853  20.812  64.175  1.00 59.69           C  
ATOM   1921  CD2 PHE   251      40.863  21.319  63.354  1.00 60.37           C  
ATOM   1922  C   PHE   251      40.875  25.040  61.655  1.00 57.73           C  
ATOM   1923  O   PHE   251      42.123  24.869  61.702  1.00 57.53           O  
ATOM   1924  N   TYR   252      40.300  26.173  61.996  1.00 56.75           N  
ATOM   1925  CA  TYR   252      41.122  27.216  62.554  1.00 56.78           C  
ATOM   1926  CB  TYR   252      42.047  27.786  61.469  1.00 55.88           C  
ATOM   1927  CG  TYR   252      43.392  28.272  61.964  1.00 56.06           C  
ATOM   1928  CD1 TYR   252      44.327  27.405  62.576  1.00 55.18           C  
ATOM   1929  CE1 TYR   252      45.577  27.879  63.027  1.00 52.73           C  
ATOM   1930  CZ  TYR   252      45.863  29.213  62.896  1.00 53.97           C  
ATOM   1931  OH  TYR   252      47.041  29.791  63.292  1.00 53.82           O  
ATOM   1932  CE2 TYR   252      44.947  30.071  62.321  1.00 55.93           C  
ATOM   1933  CD2 TYR   252      43.734  29.602  61.840  1.00 55.08           C  
ATOM   1934  C   TYR   252      40.230  28.259  63.202  1.00 57.82           C  
ATOM   1935  O   TYR   252      39.044  28.023  63.417  1.00 57.92           O  
ATOM   1936  N   PHE   253      40.793  29.398  63.553  1.00 59.19           N  
ATOM   1937  CA  PHE   253      40.019  30.386  64.241  1.00 61.04           C  
ATOM   1938  CB  PHE   253      40.659  30.678  65.563  1.00 60.09           C  
ATOM   1939  CG  PHE   253      41.924  31.395  65.476  1.00 58.42           C  
ATOM   1940  CD1 PHE   253      41.959  32.751  65.633  1.00 57.78           C  
ATOM   1941  CE1 PHE   253      43.145  33.426  65.578  1.00 57.95           C  
ATOM   1942  CZ  PHE   253      44.302  32.742  65.380  1.00 58.46           C  
ATOM   1943  CE2 PHE   253      44.282  31.375  65.240  1.00 58.52           C  
ATOM   1944  CD2 PHE   253      43.099  30.710  65.302  1.00 58.84           C  
ATOM   1945  C   PHE   253      39.808  31.674  63.489  1.00 63.18           C  
ATOM   1946  O   PHE   253      39.107  32.571  64.012  1.00 64.05           O  
ATOM   1947  N   ILE   254      40.335  31.748  62.277  1.00 64.65           N  
ATOM   1948  CA  ILE   254      39.995  32.785  61.334  1.00 65.00           C  
ATOM   1949  CB  ILE   254      41.010  33.882  61.326  1.00 64.83           C  
ATOM   1950  CG1 ILE   254      42.361  33.338  60.945  1.00 65.22           C  
ATOM   1951  CD1 ILE   254      43.428  34.282  61.254  1.00 64.94           C  
ATOM   1952  CG2 ILE   254      41.097  34.504  62.662  1.00 61.98           C  
ATOM   1953  C   ILE   254      39.884  32.175  59.951  1.00 66.83           C  
ATOM   1954  O   ILE   254      40.234  31.030  59.774  1.00 66.77           O  
ATOM   1955  N   LYS   255      39.373  32.931  58.981  1.00 68.08           N  
ATOM   1956  CA  LYS   255      39.230  32.440  57.610  1.00 68.59           C  
ATOM   1957  CB  LYS   255      38.024  33.070  56.938  1.00 69.48           C  
ATOM   1958  CG  LYS   255      37.638  34.426  57.482  1.00 71.38           C  
ATOM   1959  CD  LYS   255      36.128  34.665  57.382  1.00 70.14           C  
ATOM   1960  CE  LYS   255      35.715  35.360  56.084  1.00 71.36           C  
ATOM   1961  NZ  LYS   255      34.897  36.577  56.341  1.00 71.32           N  
ATOM   1962  C   LYS   255      40.453  32.720  56.772  1.00 68.61           C  
ATOM   1963  O   LYS   255      40.916  33.833  56.714  1.00 68.72           O  
ATOM   1964  N   LEU   256      41.019  31.691  56.188  1.00 68.87           N  
ATOM   1965  CA  LEU   256      42.319  31.817  55.609  1.00 69.01           C  
ATOM   1966  CB  LEU   256      43.188  30.659  56.037  1.00 69.13           C  
ATOM   1967  CG  LEU   256      43.293  30.245  57.482  1.00 67.71           C  
ATOM   1968  CD1 LEU   256      44.203  29.095  57.529  1.00 65.84           C  
ATOM   1969  CD2 LEU   256      43.861  31.357  58.254  1.00 67.86           C  
ATOM   1970  C   LEU   256      42.226  31.754  54.136  1.00 69.34           C  
ATOM   1971  O   LEU   256      41.699  30.814  53.605  1.00 69.38           O  
ATOM   1972  N   ASN   257      42.784  32.741  53.471  1.00 70.12           N  
ATOM   1973  CA  ASN   257      42.708  32.768  52.040  1.00 71.01           C  
ATOM   1974  CB  ASN   257      43.523  33.932  51.462  1.00 72.03           C  
ATOM   1975  CG  ASN   257      44.763  33.498  50.759  1.00 74.02           C  
ATOM   1976  OD1 ASN   257      44.710  32.872  49.711  1.00 76.53           O  
ATOM   1977  ND2 ASN   257      45.906  33.863  51.315  1.00 77.28           N  
ATOM   1978  C   ASN   257      43.065  31.406  51.490  1.00 71.28           C  
ATOM   1979  O   ASN   257      42.814  31.105  50.341  1.00 71.37           O  
ATOM   1980  N   GLN   258      43.592  30.552  52.336  1.00 71.17           N  
ATOM   1981  CA  GLN   258      43.892  29.218  51.896  1.00 70.93           C  
ATOM   1982  CB  GLN   258      45.044  28.654  52.682  1.00 71.38           C  
ATOM   1983  CG  GLN   258      44.932  27.183  52.845  1.00 72.34           C  
ATOM   1984  CD  GLN   258      46.170  26.577  53.443  1.00 73.53           C  
ATOM   1985  OE1 GLN   258      46.970  27.268  54.084  1.00 75.13           O  
ATOM   1986  NE2 GLN   258      46.344  25.278  53.242  1.00 74.55           N  
ATOM   1987  C   GLN   258      42.735  28.289  52.078  1.00 69.69           C  
ATOM   1988  O   GLN   258      42.861  27.112  51.851  1.00 69.54           O  
ATOM   1989  N   PHE   259      41.608  28.808  52.510  1.00 69.38           N  
ATOM   1990  CA  PHE   259      40.513  27.936  52.871  1.00 69.56           C  
ATOM   1991  CB  PHE   259      39.897  28.350  54.189  1.00 68.92           C  
ATOM   1992  CG  PHE   259      40.420  27.581  55.352  1.00 69.40           C  
ATOM   1993  CD1 PHE   259      41.237  26.512  55.166  1.00 68.68           C  
ATOM   1994  CE1 PHE   259      41.715  25.831  56.220  1.00 67.71           C  
ATOM   1995  CZ  PHE   259      41.389  26.198  57.462  1.00 66.14           C  
ATOM   1996  CE2 PHE   259      40.595  27.245  57.666  1.00 66.90           C  
ATOM   1997  CD2 PHE   259      40.108  27.937  56.626  1.00 68.50           C  
ATOM   1998  C   PHE   259      39.431  27.722  51.843  1.00 69.83           C  
ATOM   1999  O   PHE   259      38.728  26.731  51.923  1.00 70.64           O  
ATOM   2000  N   ASN   260      39.270  28.544  50.819  1.00 69.64           N  
ATOM   2001  CA  ASN   260      38.406  28.121  49.712  1.00 69.07           C  
ATOM   2002  CB  ASN   260      38.901  28.778  48.472  1.00 68.78           C  
ATOM   2003  CG  ASN   260      40.366  28.580  48.296  1.00 68.77           C  
ATOM   2004  OD1 ASN   260      40.820  27.539  47.844  1.00 69.84           O  
ATOM   2005  ND2 ASN   260      41.129  29.576  48.676  1.00 67.16           N  
ATOM   2006  C   ASN   260      38.730  26.673  49.505  1.00 68.60           C  
ATOM   2007  O   ASN   260      39.896  26.351  49.580  1.00 69.70           O  
ATOM   2008  N   ASP   261      37.787  25.763  49.265  1.00 20.00           N  
ATOM   2009  CA  ASP   261      36.432  25.993  48.862  1.00 20.00           C  
ATOM   2010  C   ASP   261      35.494  26.017  50.021  1.00 20.00           C  
ATOM   2011  CB  ASP   261      35.994  24.860  47.930  1.00 20.00           C  
ATOM   2012  CG  ASP   261      35.219  25.367  46.686  1.00 20.00           C  
ATOM   2013  OD1 ASP   261      33.980  25.508  46.770  1.00 20.00           O  
ATOM   2014  OD2 ASP   261      35.844  25.616  45.626  1.00 20.00           O  
ATOM   2015  O   ASP   261      35.187  27.065  50.529  1.00 20.00           O  
ATOM   2016  N   ASP   262      35.026  24.846  50.424  1.00 64.93           N  
ATOM   2017  CA  ASP   262      33.905  24.709  51.355  1.00 64.67           C  
ATOM   2018  CB  ASP   262      33.327  23.319  51.213  1.00 65.08           C  
ATOM   2019  CG  ASP   262      31.987  23.204  51.831  1.00 67.04           C  
ATOM   2020  OD1 ASP   262      31.422  24.248  52.171  1.00 68.85           O  
ATOM   2021  OD2 ASP   262      31.497  22.078  51.987  1.00 69.65           O  
ATOM   2022  C   ASP   262      34.200  24.962  52.830  1.00 64.13           C  
ATOM   2023  O   ASP   262      35.268  24.639  53.292  1.00 64.65           O  
ATOM   2024  N   THR   263      33.242  25.512  53.575  1.00 62.93           N  
ATOM   2025  CA  THR   263      33.502  25.877  54.943  1.00 61.69           C  
ATOM   2026  CB  THR   263      34.331  27.099  54.983  1.00 61.53           C  
ATOM   2027  OG1 THR   263      33.462  28.225  54.936  1.00 61.15           O  
ATOM   2028  CG2 THR   263      35.207  27.120  53.801  1.00 61.02           C  
ATOM   2029  C   THR   263      32.278  26.211  55.749  1.00 60.92           C  
ATOM   2030  O   THR   263      31.459  27.009  55.357  1.00 59.95           O  
ATOM   2031  N   VAL   264      32.211  25.600  56.916  1.00 60.39           N  
ATOM   2032  CA  VAL   264      31.149  25.784  57.911  1.00 59.43           C  
ATOM   2033  CB  VAL   264      30.644  24.420  58.399  1.00 58.90           C  
ATOM   2034  CG1 VAL   264      29.514  24.541  59.441  1.00 58.61           C  
ATOM   2035  CG2 VAL   264      30.189  23.636  57.242  1.00 57.44           C  
ATOM   2036  C   VAL   264      31.821  26.563  59.042  1.00 59.13           C  
ATOM   2037  O   VAL   264      32.979  26.284  59.347  1.00 59.17           O  
ATOM   2038  N   THR   265      31.154  27.571  59.614  1.00 58.67           N  
ATOM   2039  CA  THR   265      31.700  28.259  60.780  1.00 58.60           C  
ATOM   2040  CB  THR   265      31.787  29.778  60.663  1.00 57.71           C  
ATOM   2041  OG1 THR   265      30.473  30.247  60.584  1.00 56.69           O  
ATOM   2042  CG2 THR   265      32.579  30.257  59.458  1.00 57.28           C  
ATOM   2043  C   THR   265      30.764  27.969  61.932  1.00 59.00           C  
ATOM   2044  O   THR   265      29.634  27.555  61.684  1.00 58.78           O  
ATOM   2045  N   TYR   266      31.248  28.201  63.170  1.00 59.51           N  
ATOM   2046  CA  TYR   266      30.533  27.848  64.409  1.00 59.57           C  
ATOM   2047  CB  TYR   266      31.182  26.605  64.997  1.00 58.79           C  
ATOM   2048  CG  TYR   266      31.015  25.384  64.165  1.00 57.04           C  
ATOM   2049  CD1 TYR   266      30.015  24.488  64.446  1.00 55.62           C  
ATOM   2050  CE1 TYR   266      29.841  23.355  63.692  1.00 56.67           C  
ATOM   2051  CZ  TYR   266      30.673  23.108  62.641  1.00 57.43           C  
ATOM   2052  OH  TYR   266      30.462  21.968  61.908  1.00 58.62           O  
ATOM   2053  CE2 TYR   266      31.692  23.987  62.338  1.00 57.29           C  
ATOM   2054  CD2 TYR   266      31.863  25.119  63.110  1.00 56.27           C  
ATOM   2055  C   TYR   266      30.527  28.955  65.492  1.00 60.29           C  
ATOM   2056  O   TYR   266      31.313  29.917  65.409  1.00 60.46           O  
ATOM   2057  N   ASP   267      29.669  28.783  66.510  1.00 60.67           N  
ATOM   2058  CA  ASP   267      29.561  29.716  67.646  1.00 61.45           C  
ATOM   2059  CB  ASP   267      28.484  29.244  68.607  1.00 62.20           C  
ATOM   2060  CG  ASP   267      27.113  29.811  68.290  1.00 67.02           C  
ATOM   2061  OD1 ASP   267      26.922  30.488  67.228  1.00 71.32           O  
ATOM   2062  OD2 ASP   267      26.206  29.569  69.136  1.00 72.49           O  
ATOM   2063  C   ASP   267      30.818  29.884  68.492  1.00 61.90           C  
ATOM   2064  O   ASP   267      30.989  30.920  69.159  1.00 62.49           O  
ATOM   2065  N   SER   268      31.660  28.848  68.499  1.00 61.55           N  
ATOM   2066  CA  SER   268      32.785  28.751  69.398  1.00 60.75           C  
ATOM   2067  CB  SER   268      32.300  28.268  70.761  1.00 60.98           C  
ATOM   2068  OG  SER   268      31.995  26.868  70.763  1.00 60.36           O  
ATOM   2069  C   SER   268      33.799  27.735  68.884  1.00 60.46           C  
ATOM   2070  O   SER   268      33.516  26.858  68.029  1.00 59.60           O  
ATOM   2071  N   LEU   269      34.987  27.819  69.458  1.00 59.89           N  
ATOM   2072  CA  LEU   269      36.013  26.868  69.123  1.00 59.31           C  
ATOM   2073  CB  LEU   269      37.349  27.331  69.689  1.00 59.43           C  
ATOM   2074  CG  LEU   269      38.142  28.449  68.989  1.00 58.84           C  
ATOM   2075  CD1 LEU   269      38.880  29.276  70.043  1.00 56.68           C  
ATOM   2076  CD2 LEU   269      37.284  29.319  68.138  1.00 56.26           C  
ATOM   2077  C   LEU   269      35.630  25.476  69.655  1.00 59.20           C  
ATOM   2078  O   LEU   269      36.158  24.450  69.194  1.00 59.44           O  
ATOM   2079  N   ASN   270      34.711  25.430  70.613  1.00 58.48           N  
ATOM   2080  CA  ASN   270      34.468  24.196  71.311  1.00 58.22           C  
ATOM   2081  CB  ASN   270      33.903  24.493  72.667  1.00 57.82           C  
ATOM   2082  CG  ASN   270      34.924  25.148  73.559  1.00 58.43           C  
ATOM   2083  OD1 ASN   270      36.091  24.792  73.549  1.00 60.92           O  
ATOM   2084  ND2 ASN   270      34.503  26.121  74.316  1.00 59.72           N  
ATOM   2085  C   ASN   270      33.553  23.405  70.461  1.00 58.21           C  
ATOM   2086  O   ASN   270      33.760  22.224  70.232  1.00 59.01           O  
ATOM   2087  N   ASP   271      32.547  24.085  69.943  1.00 57.90           N  
ATOM   2088  CA  ASP   271      31.720  23.536  68.891  1.00 56.76           C  
ATOM   2089  CB  ASP   271      30.777  24.632  68.412  1.00 57.53           C  
ATOM   2090  CG  ASP   271      29.667  24.921  69.382  1.00 59.49           C  
ATOM   2091  OD1 ASP   271      29.498  24.136  70.305  1.00 64.52           O  
ATOM   2092  OD2 ASP   271      28.935  25.921  69.234  1.00 64.86           O  
ATOM   2093  C   ASP   271      32.576  23.059  67.706  1.00 56.10           C  
ATOM   2094  O   ASP   271      32.422  21.928  67.226  1.00 55.45           O  
ATOM   2095  N   LEU   272      33.462  23.937  67.222  1.00 55.06           N  
ATOM   2096  CA  LEU   272      34.274  23.623  66.054  1.00 54.61           C  
ATOM   2097  CB  LEU   272      35.281  24.747  65.804  1.00 54.69           C  
ATOM   2098  CG  LEU   272      36.399  24.538  64.769  1.00 54.29           C  
ATOM   2099  CD1 LEU   272      35.733  24.269  63.429  1.00 53.12           C  
ATOM   2100  CD2 LEU   272      37.393  25.732  64.722  1.00 52.33           C  
ATOM   2101  C   LEU   272      34.970  22.291  66.283  1.00 54.28           C  
ATOM   2102  O   LEU   272      34.852  21.378  65.496  1.00 52.39           O  
ATOM   2103  N   LEU   273      35.661  22.179  67.411  1.00 55.02           N  
ATOM   2104  CA  LEU   273      36.346  20.938  67.767  1.00 55.73           C  
ATOM   2105  CB  LEU   273      37.228  21.163  69.000  1.00 55.87           C  
ATOM   2106  CG  LEU   273      38.662  21.718  68.890  1.00 56.75           C  
ATOM   2107  CD1 LEU   273      38.880  22.843  69.933  1.00 55.95           C  
ATOM   2108  CD2 LEU   273      39.002  22.213  67.507  1.00 58.78           C  
ATOM   2109  C   LEU   273      35.375  19.749  67.972  1.00 55.55           C  
ATOM   2110  O   LEU   273      35.617  18.657  67.459  1.00 54.28           O  
ATOM   2111  N   ASP   274      34.287  19.951  68.708  1.00 56.51           N  
ATOM   2112  CA  ASP   274      33.324  18.865  68.930  1.00 58.38           C  
ATOM   2113  CB  ASP   274      31.990  19.395  69.530  1.00 59.03           C  
ATOM   2114  CG  ASP   274      31.881  19.227  71.078  1.00 61.08           C  
ATOM   2115  OD1 ASP   274      32.742  18.544  71.677  1.00 64.56           O  
ATOM   2116  OD2 ASP   274      30.905  19.753  71.697  1.00 60.37           O  
ATOM   2117  C   ASP   274      33.051  18.140  67.590  1.00 59.07           C  
ATOM   2118  O   ASP   274      33.085  16.910  67.500  1.00 59.81           O  
ATOM   2119  N   ARG   275      32.807  18.921  66.546  1.00 59.66           N  
ATOM   2120  CA  ARG   275      32.506  18.378  65.244  1.00 59.52           C  
ATOM   2121  CB  ARG   275      32.022  19.508  64.328  1.00 60.24           C  
ATOM   2122  CG  ARG   275      31.590  19.067  62.950  1.00 61.21           C  
ATOM   2123  CD  ARG   275      32.727  19.218  61.965  1.00 67.01           C  
ATOM   2124  NE  ARG   275      32.213  19.478  60.618  1.00 71.17           N  
ATOM   2125  CZ  ARG   275      31.944  18.547  59.694  1.00 72.56           C  
ATOM   2126  NH1 ARG   275      32.153  17.242  59.932  1.00 75.00           N  
ATOM   2127  NH2 ARG   275      31.457  18.925  58.515  1.00 70.89           N  
ATOM   2128  C   ARG   275      33.722  17.708  64.657  1.00 59.14           C  
ATOM   2129  O   ARG   275      33.740  16.511  64.406  1.00 59.80           O  
ATOM   2130  N   PHE   276      34.759  18.484  64.467  1.00 58.47           N  
ATOM   2131  CA  PHE   276      35.925  17.991  63.796  1.00 58.58           C  
ATOM   2132  CB  PHE   276      37.005  19.028  63.885  1.00 58.63           C  
ATOM   2133  CG  PHE   276      38.173  18.731  63.029  1.00 59.60           C  
ATOM   2134  CD1 PHE   276      38.282  19.290  61.767  1.00 60.31           C  
ATOM   2135  CE1 PHE   276      39.390  19.027  60.976  1.00 61.02           C  
ATOM   2136  CZ  PHE   276      40.385  18.190  61.445  1.00 59.55           C  
ATOM   2137  CE2 PHE   276      40.268  17.640  62.682  1.00 59.82           C  
ATOM   2138  CD2 PHE   276      39.177  17.906  63.471  1.00 59.93           C  
ATOM   2139  C   PHE   276      36.492  16.664  64.309  1.00 58.62           C  
ATOM   2140  O   PHE   276      37.138  15.959  63.559  1.00 58.14           O  
ATOM   2141  N   TYR   277      36.310  16.326  65.582  1.00 59.51           N  
ATOM   2142  CA  TYR   277      36.891  15.070  66.080  1.00 59.37           C  
ATOM   2143  CB  TYR   277      37.770  15.273  67.304  1.00 58.20           C  
ATOM   2144  CG  TYR   277      39.074  15.937  66.968  1.00 56.40           C  
ATOM   2145  CD1 TYR   277      40.121  15.229  66.373  1.00 54.78           C  
ATOM   2146  CE1 TYR   277      41.331  15.843  66.051  1.00 54.66           C  
ATOM   2147  CZ  TYR   277      41.492  17.189  66.334  1.00 56.64           C  
ATOM   2148  OH  TYR   277      42.636  17.887  66.033  1.00 56.35           O  
ATOM   2149  CE2 TYR   277      40.475  17.903  66.953  1.00 57.71           C  
ATOM   2150  CD2 TYR   277      39.268  17.270  67.257  1.00 56.92           C  
ATOM   2151  C   TYR   277      35.859  14.056  66.341  1.00 61.03           C  
ATOM   2152  O   TYR   277      36.050  13.190  67.133  1.00 60.14           O  
ATOM   2153  N   ASP   278      34.773  14.125  65.604  1.00 64.34           N  
ATOM   2154  CA  ASP   278      33.793  13.055  65.657  1.00 67.25           C  
ATOM   2155  CB  ASP   278      32.428  13.590  65.181  1.00 67.49           C  
ATOM   2156  CG  ASP   278      31.256  12.980  65.954  1.00 70.02           C  
ATOM   2157  OD1 ASP   278      31.431  12.654  67.171  1.00 68.92           O  
ATOM   2158  OD2 ASP   278      30.161  12.833  65.328  1.00 73.24           O  
ATOM   2159  C   ASP   278      34.232  11.755  64.872  1.00 68.21           C  
ATOM   2160  O   ASP   278      33.794  10.633  65.242  1.00 67.92           O  
ATOM   2161  N   ALA   279      35.105  11.901  63.835  1.00 69.48           N  
ATOM   2162  CA  ALA   279      35.341  10.812  62.775  1.00 69.71           C  
ATOM   2163  CB  ALA   279      35.793  11.443  61.349  1.00 69.27           C  
ATOM   2164  C   ALA   279      36.256   9.600  63.185  1.00 69.97           C  
ATOM   2165  O   ALA   279      37.255   9.750  63.917  1.00 69.96           O  
END
