
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  256 ( 1895),  selected  256 , name 1k2w_A
# Molecule2: number of CA atoms  271 ( 1954),  selected  271 , name T0511.pdb
# PARAMETERS: 1k2w_A.T0511.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      M       1           #
LGA    R     2_A      T       2          1.566
LGA    L     3_A      L       3          1.066
LGA    D     4_A      S       4          1.636
LGA    G     5_A      G       5          1.646
LGA    K     6_A      K       6          0.772
LGA    T     7_A      T       7          0.864
LGA    A     8_A      L       8          0.618
LGA    L     9_A      F       9          0.860
LGA    I    10_A      I      10          0.690
LGA    T    11_A      T      11          0.525
LGA    G    12_A      G      12          0.198
LGA    S    13_A      A      13          0.278
LGA    A    14_A      S      14          0.159
LGA    R    15_A      R      15          0.404
LGA    G    16_A      G      16          0.479
LGA    I    17_A      I      17          0.570
LGA    G    18_A      G      18          0.630
LGA    R    19_A      L      19          0.538
LGA    A    20_A      A      20          0.429
LGA    F    21_A      I      21          0.302
LGA    A    22_A      A      22          0.562
LGA    E    23_A      L      23          0.714
LGA    A    24_A      R      24          0.609
LGA    Y    25_A      A      25          0.774
LGA    V    26_A      A      26          0.825
LGA    R    27_A      R      27          1.205
LGA    E    28_A      D      28          2.162
LGA    G    29_A      G      29          2.393
LGA    A    30_A      A      30          1.101
LGA    R    31_A      N      31          1.282
LGA    V    32_A      V      32          0.881
LGA    A    33_A      A      33          1.341
LGA    I    34_A      I      34          1.550
LGA    A    35_A      A      35          1.481
LGA    D    36_A      A      36          0.652
LGA    I    37_A      K      37          0.865
LGA    N    38_A      S      38          1.569
LGA    L    39_A      A      39          2.315
LGA    E    40_A      V      40          2.864
LGA    -       -      A      41           -
LGA    -       -      N      42           -
LGA    -       -      P      43           -
LGA    -       -      K      44           -
LGA    -       -      L      45           -
LGA    -       -      P      46           -
LGA    -       -      G      47           -
LGA    A    41_A      T      48          1.051
LGA    A    42_A      I      49          0.703
LGA    R    43_A      H      50          0.524
LGA    A    44_A      S      51          1.643
LGA    T    45_A      A      52          2.002
LGA    A    46_A      A      53          1.392
LGA    A    47_A      A      54          1.308
LGA    E    48_A      A      55          2.811
LGA    I    49_A      V      56          3.091
LGA    G    50_A      N      57          1.542
LGA    P    51_A      A      58          5.988
LGA    -       -      A      59           -
LGA    -       -      G      60           -
LGA    A    52_A      G      61          2.245
LGA    A    53_A      Q      62          3.656
LGA    C    54_A      G      63          2.453
LGA    -       -      L      64           -
LGA    A    55_A      A      65          0.798
LGA    I    56_A      L      66          0.832
LGA    A    57_A      K      67          0.934
LGA    L    58_A      C      68          0.907
LGA    D    59_A      D      69          1.402
LGA    V    60_A      I      70          1.054
LGA    T    61_A      R      71          1.250
LGA    D    62_A      E      72          0.993
LGA    Q    63_A      E      73          1.294
LGA    A    64_A      D      74          0.796
LGA    S    65_A      Q      75          0.443
LGA    I    66_A      V      76          1.099
LGA    D    67_A      R      77          1.062
LGA    R    68_A      A      78          0.603
LGA    C    69_A      A      79          0.551
LGA    V    70_A      V      80          0.744
LGA    A    71_A      A      81          0.681
LGA    E    72_A      A      82          0.661
LGA    L    73_A      T      83          0.721
LGA    L    74_A      V      84          0.477
LGA    D    75_A      D      85          0.734
LGA    R    76_A      T      86          0.445
LGA    W    77_A      F      87          0.494
LGA    G    78_A      G      88          0.505
LGA    S    79_A      G      89          0.663
LGA    I    80_A      I      90          0.637
LGA    D    81_A      D      91          0.512
LGA    I    82_A      I      92          0.666
LGA    L    83_A      L      93          0.682
LGA    V    84_A      V      94          0.171
LGA    N    85_A      N      95          0.632
LGA    N    86_A      N      96          0.446
LGA    A    87_A      A      97          2.469
LGA    A    88_A      S      98          2.696
LGA    L    89_A      A      99          0.938
LGA    F    90_A      I     100          1.026
LGA    D    91_A      W     101          1.218
LGA    L    92_A      L     102          1.913
LGA    A    93_A      R     103          1.349
LGA    P    94_A      G     104          1.337
LGA    I    95_A      T     105          2.238
LGA    V    96_A      L     106          2.208
LGA    E    97_A      D     107          1.769
LGA    I    98_A      T     108          1.992
LGA    T    99_A      P     109          1.575
LGA    R   100_A      M     110          1.168
LGA    E   101_A      K     111          1.150
LGA    S   102_A      R     112          1.431
LGA    Y   103_A      F     113          1.206
LGA    D   104_A      D     114          1.221
LGA    R   105_A      L     115          1.215
LGA    L   106_A      M     116          0.487
LGA    F   107_A      Q     117          0.292
LGA    A   108_A      Q     118          0.868
LGA    I   109_A      V     119          0.958
LGA    N   110_A      N     120          0.381
LGA    V   111_A      A     121          0.842
LGA    S   112_A      R     122          0.763
LGA    G   113_A      G     123          0.714
LGA    T   114_A      S     124          0.494
LGA    L   115_A      F     125          0.160
LGA    F   116_A      V     126          0.940
LGA    M   117_A      C     127          0.426
LGA    M   118_A      A     128          0.238
LGA    Q   119_A      Q     129          0.655
LGA    A   120_A      A     130          0.538
LGA    V   121_A      C     131          0.272
LGA    A   122_A      L     132          0.400
LGA    R   123_A      P     133          1.715
LGA    A   124_A      H     134          2.049
LGA    M   125_A      L     135          2.342
LGA    I   126_A      L     136          2.711
LGA    A   127_A      -       -           -
LGA    G   128_A      Q     137          2.732
LGA    G   129_A      A     138          5.777
LGA    R   130_A      P     139          3.782
LGA    G   131_A      N     140          5.190
LGA    G   132_A      P     141          0.944
LGA    K   133_A      H     142          0.805
LGA    I   134_A      I     143          0.716
LGA    I   135_A      L     144          0.310
LGA    N   136_A      T     145          0.481
LGA    M   137_A      L     146          0.881
LGA    A   138_A      A     147          0.428
LGA    S   139_A      P     148          3.369
LGA    Q   140_A      P     149           #
LGA    A   141_A      -       -           -
LGA    G   142_A      P     150          5.510
LGA    R   143_A      S     151          3.710
LGA    -       -      L     152           -
LGA    -       -      N     153           -
LGA    -       -      P     154           -
LGA    R   144_A      A     155           #
LGA    G   145_A      W     156          1.311
LGA    E   146_A      W     157          5.211
LGA    A   147_A      G     158          4.508
LGA    L   148_A      A     159          3.929
LGA    V   149_A      H     160          2.560
LGA    G   150_A      T     161          1.998
LGA    V   151_A      G     162          1.376
LGA    Y   152_A      Y     163          1.430
LGA    C   153_A      T     164          1.313
LGA    A   154_A      L     165          1.311
LGA    T   155_A      A     166          1.395
LGA    K   156_A      K     167          1.747
LGA    A   157_A      M     168          1.475
LGA    A   158_A      G     169          1.563
LGA    V   159_A      M     170          1.463
LGA    I   160_A      S     171          1.366
LGA    S   161_A      L     172          1.408
LGA    L   162_A      V     173          1.362
LGA    T   163_A      T     174          0.980
LGA    Q   164_A      L     175          1.589
LGA    S   165_A      G     176          1.223
LGA    A   166_A      L     177          0.754
LGA    G   167_A      A     178          0.835
LGA    L   168_A      A     179          1.865
LGA    N   169_A      E     180          1.269
LGA    L   170_A      F     181          0.984
LGA    I   171_A      G     182          2.172
LGA    R   172_A      P     183          3.067
LGA    H   173_A      Q     184          2.564
LGA    G   174_A      G     185          2.125
LGA    I   175_A      V     186          1.065
LGA    N   176_A      A     187          1.043
LGA    V   177_A      I     188          0.179
LGA    N   178_A      N     189          0.177
LGA    A   179_A      A     190          0.471
LGA    I   180_A      L     191          0.560
LGA    A   181_A      W     192          1.614
LGA    P   182_A      P     193          2.213
LGA    -       -      R     194           -
LGA    G   183_A      T     195          3.831
LGA    V   184_A      V     196          1.629
LGA    V   185_A      I     197          1.450
LGA    D   186_A      A     198          2.010
LGA    G   187_A      T     199          2.566
LGA    E   188_A      D     200          3.691
LGA    H   189_A      A     201          3.414
LGA    W   190_A      I     202          2.663
LGA    D   191_A      N     203          3.929
LGA    G   192_A      M     204          5.112
LGA    V   193_A      L     205          2.987
LGA    D   194_A      P     206          1.606
LGA    A   195_A      -       -           -
LGA    K   196_A      -       -           -
LGA    F   197_A      -       -           -
LGA    A   198_A      -       -           -
LGA    D   199_A      -       -           -
LGA    Y   200_A      -       -           -
LGA    E   201_A      -       -           -
LGA    N   202_A      -       -           -
LGA    L   203_A      -       -           -
LGA    P   204_A      -       -           -
LGA    R   205_A      -       -           -
LGA    G   206_A      -       -           -
LGA    E   207_A      -       -           -
LGA    K   208_A      G     207          3.282
LGA    K   209_A      V     208          2.444
LGA    R   210_A      D     209           #
LGA    Q   211_A      A     210           -
LGA    V   212_A      A     211           -
LGA    G   213_A      A     212           #
LGA    A   214_A      -       -           -
LGA    A   215_A      -       -           -
LGA    V   216_A      -       -           -
LGA    P   217_A      -       -           -
LGA    F   218_A      -       -           -
LGA    G   219_A      -       -           -
LGA    R   220_A      -       -           -
LGA    M   221_A      C     213          2.421
LGA    G   222_A      R     214          2.719
LGA    R   223_A      R     215          2.244
LGA    A   224_A      P     216          1.038
LGA    E   225_A      E     217          1.935
LGA    D   226_A      I     218          1.724
LGA    L   227_A      M     219          1.477
LGA    T   228_A      A     220          1.942
LGA    G   229_A      D     221          2.410
LGA    M   230_A      A     222          1.986
LGA    A   231_A      A     223          0.456
LGA    I   232_A      H     224          0.934
LGA    F   233_A      A     225          1.741
LGA    L   234_A      V     226          1.663
LGA    A   235_A      L     227          1.190
LGA    T   236_A      T     228          1.614
LGA    P   237_A      R     229          3.241
LGA    E   238_A      E     230          4.332
LGA    A   239_A      A     231           #
LGA    D   240_A      A     232          3.800
LGA    Y   241_A      G     233          2.894
LGA    I   242_A      F     234          2.027
LGA    V   243_A      H     235          1.103
LGA    A   244_A      G     236          0.722
LGA    Q   245_A      Q     237          0.924
LGA    T   246_A      F     238          0.845
LGA    Y   247_A      L     239          0.922
LGA    N   248_A      I     240          2.333
LGA    V   249_A      D     241          2.841
LGA    -       -      D     242           -
LGA    -       -      E     243           -
LGA    -       -      V     244           -
LGA    -       -      L     245           -
LGA    -       -      A     246           -
LGA    -       -      Q     247           -
LGA    -       -      A     248           -
LGA    -       -      G     249           -
LGA    -       -      I     250           -
LGA    -       -      T     251           -
LGA    -       -      D     252           -
LGA    -       -      L     253           -
LGA    -       -      S     254           -
LGA    -       -      G     255           -
LGA    -       -      Y     256           -
LGA    -       -      A     257           -
LGA    -       -      V     258           -
LGA    -       -      D     259           -
LGA    -       -      P     260           -
LGA    -       -      Q     261           -
LGA    -       -      R     262           -
LGA    -       -      A     263           -
LGA    -       -      L     264           -
LGA    -       -      L     265           -
LGA    -       -      P     266           -
LGA    D   250_A      D     267           #
LGA    G   251_A      L     268           -
LGA    G   252_A      F     269           -
LGA    N   253_A      L     270          4.980
LGA    W   254_A      E     271          2.994
LGA    M   255_A      -       -           -
LGA    S   256_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  256  271    5.0    221    1.94    26.24     68.956    10.854

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.976593 * X  +  -0.214778 * Y  +   0.011686 * Z  +  51.750126
  Y_new =   0.106938 * X  +   0.531946 * Y  +   0.839999 * Z  + -35.299500
  Z_new =  -0.186630 * X  +  -0.819087 * Y  +   0.542463 * Z  +  46.508102 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.985839    2.155754  [ DEG:   -56.4844    123.5156 ]
  Theta =   0.187731    2.953862  [ DEG:    10.7562    169.2438 ]
  Phi   =   0.109066   -3.032526  [ DEG:     6.2490   -173.7510 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1k2w_A                                        
REMARK     2: T0511.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1k2w_A.T0511.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  256  271   5.0  221   1.94   26.24  68.956
REMARK  ---------------------------------------------------------- 
MOLECULE 1k2w_A
HEADER    OXIDOREDUCTASE                          29-SEP-01   1K2W              
TITLE     CRYSTAL STRUCTURE OF SORBITOL DEHYDROGENASE FROM R.                   
TITLE    2 SPHAEROIDES                                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SORBITOL DEHYDROGENASE;                                    
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: L-IDITOL 2-DEHYDROGENASE, POLYOL DEHYDROGENASE;             
COMPND   5 EC: 1.1.1.14;                                                        
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RHODOBACTER SPHAEROIDES;                        
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    SHORT-CHAIN DEHYDROGENASE, ENZYME                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.PHILIPPSEN,T.SCHIRMER,J.STETEFELD                                   
REVDAT   2   05-APR-05 1K2W    1       JRNL   REMARK                            
REVDAT   1   11-NOV-03 1K2W    0                                                
JRNL        AUTH   A.PHILIPPSEN,T.SCHIRMER,M.A.STEIN,F.GIFFHORN,                
JRNL        AUTH 2 J.STETEFELD                                                  
JRNL        TITL   STRUCTURE OF ZINC-INDEPENDENT SORBITOL                       
JRNL        TITL 2 DEHYDROGENASE FROM RHODOBACTER SPHAEROIDES AT 2.4            
JRNL        TITL 3 A RESOLUTION.                                                
JRNL        REF    ACTA CRYSTALLOGR.,SECT.D      V.  61   374 2005              
JRNL        REFN   ASTM ABCRE6  DK ISSN 0907-4449                               
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  1K2W A    1   256  UNP    Q59787   DHSO_RHOSH       1    256             
DBREF  1K2W B    1   256  UNP    Q59787   DHSO_RHOSH       1    256             
SEQRES   1 A  256  MET ARG LEU ASP GLY LYS THR ALA LEU ILE THR GLY SER          
SEQRES   2 A  256  ALA ARG GLY ILE GLY ARG ALA PHE ALA GLU ALA TYR VAL          
SEQRES   3 A  256  ARG GLU GLY ALA ARG VAL ALA ILE ALA ASP ILE ASN LEU          
SEQRES   4 A  256  GLU ALA ALA ARG ALA THR ALA ALA GLU ILE GLY PRO ALA          
SEQRES   5 A  256  ALA CYS ALA ILE ALA LEU ASP VAL THR ASP GLN ALA SER          
SEQRES   6 A  256  ILE ASP ARG CYS VAL ALA GLU LEU LEU ASP ARG TRP GLY          
SEQRES   7 A  256  SER ILE ASP ILE LEU VAL ASN ASN ALA ALA LEU PHE ASP          
SEQRES   8 A  256  LEU ALA PRO ILE VAL GLU ILE THR ARG GLU SER TYR ASP          
SEQRES   9 A  256  ARG LEU PHE ALA ILE ASN VAL SER GLY THR LEU PHE MET          
SEQRES  10 A  256  MET GLN ALA VAL ALA ARG ALA MET ILE ALA GLY GLY ARG          
SEQRES  11 A  256  GLY GLY LYS ILE ILE ASN MET ALA SER GLN ALA GLY ARG          
SEQRES  12 A  256  ARG GLY GLU ALA LEU VAL GLY VAL TYR CYS ALA THR LYS          
SEQRES  13 A  256  ALA ALA VAL ILE SER LEU THR GLN SER ALA GLY LEU ASN          
SEQRES  14 A  256  LEU ILE ARG HIS GLY ILE ASN VAL ASN ALA ILE ALA PRO          
SEQRES  15 A  256  GLY VAL VAL ASP GLY GLU HIS TRP ASP GLY VAL ASP ALA          
SEQRES  16 A  256  LYS PHE ALA ASP TYR GLU ASN LEU PRO ARG GLY GLU LYS          
SEQRES  17 A  256  LYS ARG GLN VAL GLY ALA ALA VAL PRO PHE GLY ARG MET          
SEQRES  18 A  256  GLY ARG ALA GLU ASP LEU THR GLY MET ALA ILE PHE LEU          
SEQRES  19 A  256  ALA THR PRO GLU ALA ASP TYR ILE VAL ALA GLN THR TYR          
SEQRES  20 A  256  ASN VAL ASP GLY GLY ASN TRP MET SER                          
SEQRES   1 B  256  MET ARG LEU ASP GLY LYS THR ALA LEU ILE THR GLY SER          
SEQRES   2 B  256  ALA ARG GLY ILE GLY ARG ALA PHE ALA GLU ALA TYR VAL          
SEQRES   3 B  256  ARG GLU GLY ALA ARG VAL ALA ILE ALA ASP ILE ASN LEU          
SEQRES   4 B  256  GLU ALA ALA ARG ALA THR ALA ALA GLU ILE GLY PRO ALA          
SEQRES   5 B  256  ALA CYS ALA ILE ALA LEU ASP VAL THR ASP GLN ALA SER          
SEQRES   6 B  256  ILE ASP ARG CYS VAL ALA GLU LEU LEU ASP ARG TRP GLY          
SEQRES   7 B  256  SER ILE ASP ILE LEU VAL ASN ASN ALA ALA LEU PHE ASP          
SEQRES   8 B  256  LEU ALA PRO ILE VAL GLU ILE THR ARG GLU SER TYR ASP          
SEQRES   9 B  256  ARG LEU PHE ALA ILE ASN VAL SER GLY THR LEU PHE MET          
SEQRES  10 B  256  MET GLN ALA VAL ALA ARG ALA MET ILE ALA GLY GLY ARG          
SEQRES  11 B  256  GLY GLY LYS ILE ILE ASN MET ALA SER GLN ALA GLY ARG          
SEQRES  12 B  256  ARG GLY GLU ALA LEU VAL GLY VAL TYR CYS ALA THR LYS          
SEQRES  13 B  256  ALA ALA VAL ILE SER LEU THR GLN SER ALA GLY LEU ASN          
SEQRES  14 B  256  LEU ILE ARG HIS GLY ILE ASN VAL ASN ALA ILE ALA PRO          
SEQRES  15 B  256  GLY VAL VAL ASP GLY GLU HIS TRP ASP GLY VAL ASP ALA          
SEQRES  16 B  256  LYS PHE ALA ASP TYR GLU ASN LEU PRO ARG GLY GLU LYS          
SEQRES  17 B  256  LYS ARG GLN VAL GLY ALA ALA VAL PRO PHE GLY ARG MET          
SEQRES  18 B  256  GLY ARG ALA GLU ASP LEU THR GLY MET ALA ILE PHE LEU          
SEQRES  19 B  256  ALA THR PRO GLU ALA ASP TYR ILE VAL ALA GLN THR TYR          
SEQRES  20 B  256  ASN VAL ASP GLY GLY ASN TRP MET SER                          
FORMUL   3  HOH   *170(H2 O)                                                    
CRYST1   67.465   67.465  191.044  90.00  90.00 120.00 P 31 2 1     12          
ATOM      1  N   MET A   1      65.916  33.466  44.253  1.00 41.48           N  
ATOM      2  CA  MET A   1      64.921  34.330  44.941  1.00 41.58           C  
ATOM      3  C   MET A   1      64.252  33.591  46.094  1.00 39.51           C  
ATOM      4  O   MET A   1      63.038  33.382  46.086  1.00 38.98           O  
ATOM      5  CB  MET A   1      63.849  34.800  43.953  1.00 45.90           C  
ATOM      6  CG  MET A   1      64.396  35.539  42.737  1.00 51.18           C  
ATOM      7  SD  MET A   1      65.341  37.032  43.129  1.00 55.83           S  
ATOM      8  CE  MET A   1      67.027  36.402  43.045  1.00 54.59           C  
ATOM      9  N   ARG A   2      65.045  33.204  47.085  1.00 36.39           N  
ATOM     10  CA  ARG A   2      64.518  32.493  48.238  1.00 34.35           C  
ATOM     11  C   ARG A   2      63.799  33.409  49.222  1.00 34.20           C  
ATOM     12  O   ARG A   2      63.031  32.940  50.063  1.00 32.64           O  
ATOM     13  CB  ARG A   2      65.645  31.743  48.947  1.00 33.48           C  
ATOM     14  CG  ARG A   2      66.042  30.456  48.243  1.00 31.69           C  
ATOM     15  CD  ARG A   2      67.170  29.751  48.963  1.00 29.91           C  
ATOM     16  NE  ARG A   2      68.457  30.378  48.696  1.00 28.95           N  
ATOM     17  CZ  ARG A   2      69.598  29.982  49.242  1.00 30.21           C  
ATOM     18  NH1 ARG A   2      69.604  28.962  50.088  1.00 32.54           N  
ATOM     19  NH2 ARG A   2      70.734  30.594  48.943  1.00 29.14           N  
ATOM     20  N   LEU A   3      64.039  34.714  49.110  1.00 35.07           N  
ATOM     21  CA  LEU A   3      63.412  35.694  49.998  1.00 34.70           C  
ATOM     22  C   LEU A   3      62.685  36.764  49.192  1.00 35.41           C  
ATOM     23  O   LEU A   3      62.603  37.923  49.595  1.00 35.91           O  
ATOM     24  CB  LEU A   3      64.472  36.350  50.889  1.00 31.47           C  
ATOM     25  CG  LEU A   3      65.198  35.447  51.886  1.00 29.10           C  
ATOM     26  CD1 LEU A   3      66.176  36.270  52.705  1.00 26.97           C  
ATOM     27  CD2 LEU A   3      64.181  34.778  52.794  1.00 27.95           C  
ATOM     28  N   ASP A   4      62.137  36.352  48.058  1.00 36.70           N  
ATOM     29  CA  ASP A   4      61.439  37.254  47.159  1.00 37.42           C  
ATOM     30  C   ASP A   4      60.247  37.979  47.779  1.00 37.20           C  
ATOM     31  O   ASP A   4      59.337  37.357  48.328  1.00 35.42           O  
ATOM     32  CB  ASP A   4      60.996  36.472  45.924  1.00 40.33           C  
ATOM     33  CG  ASP A   4      60.880  37.342  44.695  1.00 43.16           C  
ATOM     34  OD1 ASP A   4      59.853  38.040  44.550  1.00 44.42           O  
ATOM     35  OD2 ASP A   4      61.827  37.332  43.874  1.00 45.27           O  
ATOM     36  N   GLY A   5      60.276  39.308  47.684  1.00 38.60           N  
ATOM     37  CA  GLY A   5      59.201  40.142  48.205  1.00 40.00           C  
ATOM     38  C   GLY A   5      59.086  40.209  49.716  1.00 40.53           C  
ATOM     39  O   GLY A   5      57.982  40.342  50.257  1.00 40.48           O  
ATOM     40  N   LYS A   6      60.222  40.121  50.403  1.00 39.87           N  
ATOM     41  CA  LYS A   6      60.231  40.164  51.859  1.00 38.75           C  
ATOM     42  C   LYS A   6      61.127  41.267  52.388  1.00 37.16           C  
ATOM     43  O   LYS A   6      62.103  41.656  51.741  1.00 36.93           O  
ATOM     44  CB  LYS A   6      60.685  38.819  52.421  1.00 39.36           C  
ATOM     45  CG  LYS A   6      59.687  37.710  52.193  1.00 40.15           C  
ATOM     46  CD  LYS A   6      60.075  36.456  52.949  1.00 41.73           C  
ATOM     47  CE  LYS A   6      59.000  35.385  52.812  1.00 44.93           C  
ATOM     48  NZ  LYS A   6      57.679  35.868  53.305  1.00 44.56           N  
ATOM     49  N   THR A   7      60.790  41.761  53.576  1.00 34.56           N  
ATOM     50  CA  THR A   7      61.545  42.835  54.209  1.00 31.14           C  
ATOM     51  C   THR A   7      62.304  42.348  55.432  1.00 30.82           C  
ATOM     52  O   THR A   7      61.755  41.650  56.286  1.00 31.78           O  
ATOM     53  CB  THR A   7      60.616  43.982  54.645  1.00 30.89           C  
ATOM     54  OG1 THR A   7      59.601  43.472  55.517  1.00 31.28           O  
ATOM     55  CG2 THR A   7      59.952  44.624  53.438  1.00 32.31           C  
ATOM     56  N   ALA A   8      63.570  42.731  55.522  1.00 29.62           N  
ATOM     57  CA  ALA A   8      64.396  42.328  56.646  1.00 29.72           C  
ATOM     58  C   ALA A   8      65.113  43.508  57.312  1.00 30.28           C  
ATOM     59  O   ALA A   8      65.692  44.367  56.641  1.00 30.25           O  
ATOM     60  CB  ALA A   8      65.419  41.288  56.190  1.00 29.05           C  
ATOM     61  N   LEU A   9      65.057  43.544  58.639  1.00 28.68           N  
ATOM     62  CA  LEU A   9      65.727  44.581  59.409  1.00 26.72           C  
ATOM     63  C   LEU A   9      66.940  43.871  60.014  1.00 26.04           C  
ATOM     64  O   LEU A   9      66.785  42.876  60.723  1.00 26.45           O  
ATOM     65  CB  LEU A   9      64.810  45.093  60.534  1.00 26.06           C  
ATOM     66  CG  LEU A   9      65.134  46.388  61.306  1.00 25.33           C  
ATOM     67  CD1 LEU A   9      64.210  46.500  62.509  1.00 23.24           C  
ATOM     68  CD2 LEU A   9      66.569  46.405  61.779  1.00 25.34           C  
ATOM     69  N   ILE A  10      68.136  44.366  59.721  1.00 23.49           N  
ATOM     70  CA  ILE A  10      69.350  43.775  60.264  1.00 24.46           C  
ATOM     71  C   ILE A  10      70.101  44.841  61.052  1.00 27.09           C  
ATOM     72  O   ILE A  10      70.552  45.836  60.480  1.00 27.64           O  
ATOM     73  CB  ILE A  10      70.265  43.255  59.144  1.00 24.13           C  
ATOM     74  CG1 ILE A  10      69.492  42.273  58.267  1.00 22.48           C  
ATOM     75  CG2 ILE A  10      71.506  42.595  59.744  1.00 17.46           C  
ATOM     76  CD1 ILE A  10      70.266  41.818  57.061  1.00 24.59           C  
ATOM     77  N   THR A  11      70.243  44.631  62.357  1.00 27.49           N  
ATOM     78  CA  THR A  11      70.918  45.606  63.202  1.00 28.56           C  
ATOM     79  C   THR A  11      72.431  45.507  63.106  1.00 29.62           C  
ATOM     80  O   THR A  11      72.981  44.414  62.971  1.00 32.36           O  
ATOM     81  CB  THR A  11      70.496  45.444  64.677  1.00 27.97           C  
ATOM     82  OG1 THR A  11      71.071  44.251  65.221  1.00 27.93           O  
ATOM     83  CG2 THR A  11      68.989  45.355  64.780  1.00 27.09           C  
ATOM     84  N   GLY A  12      73.096  46.657  63.180  1.00 29.33           N  
ATOM     85  CA  GLY A  12      74.548  46.697  63.112  1.00 29.86           C  
ATOM     86  C   GLY A  12      75.084  46.106  61.827  1.00 31.12           C  
ATOM     87  O   GLY A  12      76.115  45.433  61.821  1.00 32.13           O  
ATOM     88  N   SER A  13      74.386  46.382  60.731  1.00 32.78           N  
ATOM     89  CA  SER A  13      74.739  45.859  59.415  1.00 33.66           C  
ATOM     90  C   SER A  13      75.524  46.811  58.516  1.00 35.28           C  
ATOM     91  O   SER A  13      75.604  46.602  57.305  1.00 36.10           O  
ATOM     92  CB  SER A  13      73.462  45.424  58.699  1.00 32.16           C  
ATOM     93  OG  SER A  13      72.489  46.452  58.743  1.00 31.20           O  
ATOM     94  N   ALA A  14      76.099  47.857  59.094  1.00 36.42           N  
ATOM     95  CA  ALA A  14      76.864  48.803  58.297  1.00 36.95           C  
ATOM     96  C   ALA A  14      78.157  48.137  57.855  1.00 37.21           C  
ATOM     97  O   ALA A  14      78.683  48.427  56.782  1.00 36.96           O  
ATOM     98  CB  ALA A  14      77.170  50.057  59.113  1.00 36.61           C  
ATOM     99  N   ARG A  15      78.660  47.233  58.689  1.00 37.46           N  
ATOM    100  CA  ARG A  15      79.901  46.529  58.391  1.00 38.19           C  
ATOM    101  C   ARG A  15      79.877  45.093  58.886  1.00 36.88           C  
ATOM    102  O   ARG A  15      78.912  44.651  59.517  1.00 36.88           O  
ATOM    103  CB  ARG A  15      81.085  47.249  59.045  1.00 40.06           C  
ATOM    104  CG  ARG A  15      81.270  48.684  58.590  1.00 43.70           C  
ATOM    105  CD  ARG A  15      82.296  49.409  59.447  1.00 44.19           C  
ATOM    106  NE  ARG A  15      82.276  50.845  59.191  0.00 44.00           N  
ATOM    107  CZ  ARG A  15      82.943  51.741  59.909  0.00 44.01           C  
ATOM    108  NH1 ARG A  15      82.866  53.029  59.605  0.00 43.97           N  
ATOM    109  NH2 ARG A  15      83.685  51.350  60.936  0.00 43.97           N  
ATOM    110  N   GLY A  16      80.959  44.378  58.591  1.00 35.61           N  
ATOM    111  CA  GLY A  16      81.105  42.999  59.015  1.00 34.73           C  
ATOM    112  C   GLY A  16      80.051  42.002  58.572  1.00 33.39           C  
ATOM    113  O   GLY A  16      79.468  42.109  57.493  1.00 33.46           O  
ATOM    114  N   ILE A  17      79.822  41.017  59.433  1.00 32.78           N  
ATOM    115  CA  ILE A  17      78.856  39.953  59.191  1.00 31.95           C  
ATOM    116  C   ILE A  17      77.471  40.507  58.897  1.00 31.77           C  
ATOM    117  O   ILE A  17      76.748  39.986  58.043  1.00 32.50           O  
ATOM    118  CB  ILE A  17      78.777  39.018  60.412  1.00 30.90           C  
ATOM    119  CG1 ILE A  17      80.127  38.322  60.608  1.00 31.07           C  
ATOM    120  CG2 ILE A  17      77.652  38.018  60.235  1.00 32.31           C  
ATOM    121  CD1 ILE A  17      80.180  37.389  61.806  1.00 31.10           C  
ATOM    122  N   GLY A  18      77.102  41.564  59.609  1.00 30.54           N  
ATOM    123  CA  GLY A  18      75.799  42.157  59.404  1.00 30.57           C  
ATOM    124  C   GLY A  18      75.618  42.583  57.966  1.00 31.00           C  
ATOM    125  O   GLY A  18      74.556  42.366  57.380  1.00 30.12           O  
ATOM    126  N   ARG A  19      76.657  43.194  57.399  1.00 32.12           N  
ATOM    127  CA  ARG A  19      76.611  43.652  56.017  1.00 34.24           C  
ATOM    128  C   ARG A  19      76.453  42.465  55.084  1.00 34.09           C  
ATOM    129  O   ARG A  19      75.660  42.504  54.141  1.00 34.42           O  
ATOM    130  CB  ARG A  19      77.884  44.419  55.649  1.00 35.54           C  
ATOM    131  CG  ARG A  19      77.953  44.745  54.171  1.00 37.76           C  
ATOM    132  CD  ARG A  19      78.951  45.833  53.839  1.00 41.26           C  
ATOM    133  NE  ARG A  19      78.876  46.173  52.420  1.00 45.22           N  
ATOM    134  CZ  ARG A  19      79.458  47.231  51.860  1.00 47.24           C  
ATOM    135  NH1 ARG A  19      80.173  48.075  52.594  1.00 47.45           N  
ATOM    136  NH2 ARG A  19      79.316  47.447  50.558  1.00 48.67           N  
ATOM    137  N   ALA A  20      77.215  41.411  55.362  1.00 33.55           N  
ATOM    138  CA  ALA A  20      77.171  40.193  54.564  1.00 32.10           C  
ATOM    139  C   ALA A  20      75.732  39.695  54.441  1.00 31.27           C  
ATOM    140  O   ALA A  20      75.233  39.491  53.333  1.00 30.43           O  
ATOM    141  CB  ALA A  20      78.043  39.127  55.203  1.00 33.12           C  
ATOM    142  N   PHE A  21      75.067  39.507  55.579  1.00 29.80           N  
ATOM    143  CA  PHE A  21      73.686  39.039  55.570  1.00 30.38           C  
ATOM    144  C   PHE A  21      72.823  39.928  54.688  1.00 31.24           C  
ATOM    145  O   PHE A  21      71.996  39.444  53.919  1.00 31.23           O  
ATOM    146  CB  PHE A  21      73.106  39.032  56.986  1.00 31.41           C  
ATOM    147  CG  PHE A  21      73.710  37.999  57.895  1.00 31.93           C  
ATOM    148  CD1 PHE A  21      73.378  37.974  59.247  1.00 32.29           C  
ATOM    149  CD2 PHE A  21      74.604  37.048  57.407  1.00 31.51           C  
ATOM    150  CE1 PHE A  21      73.931  37.022  60.105  1.00 32.16           C  
ATOM    151  CE2 PHE A  21      75.160  36.092  58.255  1.00 31.35           C  
ATOM    152  CZ  PHE A  21      74.820  36.080  59.607  1.00 32.56           C  
ATOM    153  N   ALA A  22      73.019  41.237  54.805  1.00 32.80           N  
ATOM    154  CA  ALA A  22      72.244  42.191  54.026  1.00 32.66           C  
ATOM    155  C   ALA A  22      72.453  41.936  52.544  1.00 33.14           C  
ATOM    156  O   ALA A  22      71.491  41.812  51.790  1.00 33.21           O  
ATOM    157  CB  ALA A  22      72.654  43.608  54.380  1.00 32.85           C  
ATOM    158  N   GLU A  23      73.711  41.860  52.130  1.00 33.91           N  
ATOM    159  CA  GLU A  23      74.020  41.606  50.732  1.00 36.31           C  
ATOM    160  C   GLU A  23      73.395  40.275  50.299  1.00 36.26           C  
ATOM    161  O   GLU A  23      72.737  40.201  49.259  1.00 37.82           O  
ATOM    162  CB  GLU A  23      75.543  41.603  50.509  1.00 36.10           C  
ATOM    163  CG  GLU A  23      76.177  42.972  50.730  1.00 40.69           C  
ATOM    164  CD  GLU A  23      77.678  43.013  50.459  1.00 43.33           C  
ATOM    165  OE1 GLU A  23      78.402  42.107  50.925  1.00 45.41           O  
ATOM    166  OE2 GLU A  23      78.140  43.969  49.797  1.00 45.19           O  
ATOM    167  N   ALA A  24      73.576  39.233  51.103  1.00 35.52           N  
ATOM    168  CA  ALA A  24      73.012  37.930  50.775  1.00 35.70           C  
ATOM    169  C   ALA A  24      71.490  38.016  50.660  1.00 36.18           C  
ATOM    170  O   ALA A  24      70.899  37.531  49.696  1.00 38.13           O  
ATOM    171  CB  ALA A  24      73.402  36.916  51.833  1.00 35.57           C  
ATOM    172  N   TYR A  25      70.859  38.640  51.647  1.00 35.70           N  
ATOM    173  CA  TYR A  25      69.409  38.799  51.654  1.00 34.64           C  
ATOM    174  C   TYR A  25      68.897  39.527  50.411  1.00 35.28           C  
ATOM    175  O   TYR A  25      67.895  39.126  49.812  1.00 34.85           O  
ATOM    176  CB  TYR A  25      68.983  39.553  52.915  1.00 32.65           C  
ATOM    177  CG  TYR A  25      68.702  38.659  54.101  1.00 31.55           C  
ATOM    178  CD1 TYR A  25      69.419  37.476  54.298  1.00 29.81           C  
ATOM    179  CD2 TYR A  25      67.712  38.992  55.027  1.00 32.84           C  
ATOM    180  CE1 TYR A  25      69.154  36.645  55.385  1.00 28.86           C  
ATOM    181  CE2 TYR A  25      67.439  38.165  56.122  1.00 31.38           C  
ATOM    182  CZ  TYR A  25      68.164  36.994  56.292  1.00 29.78           C  
ATOM    183  OH  TYR A  25      67.894  36.178  57.367  1.00 28.89           O  
ATOM    184  N   VAL A  26      69.580  40.603  50.032  1.00 36.23           N  
ATOM    185  CA  VAL A  26      69.190  41.373  48.859  1.00 37.22           C  
ATOM    186  C   VAL A  26      69.296  40.492  47.624  1.00 38.84           C  
ATOM    187  O   VAL A  26      68.410  40.494  46.770  1.00 38.94           O  
ATOM    188  CB  VAL A  26      70.092  42.611  48.672  1.00 36.95           C  
ATOM    189  CG1 VAL A  26      69.803  43.272  47.327  1.00 36.32           C  
ATOM    190  CG2 VAL A  26      69.849  43.601  49.808  1.00 35.50           C  
ATOM    191  N   ARG A  27      70.379  39.725  47.549  1.00 39.22           N  
ATOM    192  CA  ARG A  27      70.608  38.831  46.424  1.00 40.94           C  
ATOM    193  C   ARG A  27      69.459  37.838  46.266  1.00 40.42           C  
ATOM    194  O   ARG A  27      69.216  37.337  45.168  1.00 42.12           O  
ATOM    195  CB  ARG A  27      71.906  38.054  46.623  1.00 43.30           C  
ATOM    196  CG  ARG A  27      72.639  37.720  45.337  1.00 47.74           C  
ATOM    197  CD  ARG A  27      73.385  36.398  45.455  1.00 51.22           C  
ATOM    198  NE  ARG A  27      73.874  36.134  46.811  1.00 55.99           N  
ATOM    199  CZ  ARG A  27      73.481  35.102  47.565  1.00 58.56           C  
ATOM    200  NH1 ARG A  27      73.976  34.933  48.784  1.00 58.38           N  
ATOM    201  NH2 ARG A  27      72.593  34.229  47.100  1.00 60.19           N  
ATOM    202  N   GLU A  28      68.758  37.552  47.360  1.00 38.14           N  
ATOM    203  CA  GLU A  28      67.646  36.605  47.329  1.00 36.10           C  
ATOM    204  C   GLU A  28      66.305  37.286  47.080  1.00 36.39           C  
ATOM    205  O   GLU A  28      65.244  36.701  47.316  1.00 34.91           O  
ATOM    206  CB  GLU A  28      67.581  35.809  48.637  1.00 35.69           C  
ATOM    207  CG  GLU A  28      68.751  34.846  48.872  1.00 33.17           C  
ATOM    208  CD  GLU A  28      68.849  33.741  47.820  1.00 32.01           C  
ATOM    209  OE1 GLU A  28      67.812  33.155  47.440  1.00 28.70           O  
ATOM    210  OE2 GLU A  28      69.977  33.448  47.379  1.00 31.55           O  
ATOM    211  N   GLY A  29      66.366  38.532  46.615  1.00 37.61           N  
ATOM    212  CA  GLY A  29      65.159  39.279  46.308  1.00 39.19           C  
ATOM    213  C   GLY A  29      64.417  39.908  47.472  1.00 40.36           C  
ATOM    214  O   GLY A  29      63.191  40.064  47.423  1.00 40.61           O  
ATOM    215  N   ALA A  30      65.144  40.283  48.519  1.00 40.68           N  
ATOM    216  CA  ALA A  30      64.516  40.897  49.683  1.00 40.66           C  
ATOM    217  C   ALA A  30      64.936  42.349  49.863  1.00 40.40           C  
ATOM    218  O   ALA A  30      66.008  42.756  49.411  1.00 40.37           O  
ATOM    219  CB  ALA A  30      64.860  40.109  50.930  1.00 40.55           C  
ATOM    220  N   ARG A  31      64.073  43.127  50.509  1.00 40.42           N  
ATOM    221  CA  ARG A  31      64.352  44.534  50.794  1.00 40.52           C  
ATOM    222  C   ARG A  31      64.919  44.587  52.211  1.00 39.11           C  
ATOM    223  O   ARG A  31      64.302  44.091  53.152  1.00 38.13           O  
ATOM    224  CB  ARG A  31      63.068  45.364  50.689  1.00 42.90           C  
ATOM    225  CG  ARG A  31      62.643  45.633  49.249  1.00 46.44           C  
ATOM    226  CD  ARG A  31      61.169  45.360  49.027  1.00 48.95           C  
ATOM    227  NE  ARG A  31      60.317  46.265  49.789  1.00 53.95           N  
ATOM    228  CZ  ARG A  31      58.990  46.177  49.835  1.00 56.89           C  
ATOM    229  NH1 ARG A  31      58.363  45.218  49.162  1.00 58.47           N  
ATOM    230  NH2 ARG A  31      58.285  47.046  50.553  1.00 57.00           N  
ATOM    231  N   VAL A  32      66.101  45.174  52.357  1.00 37.80           N  
ATOM    232  CA  VAL A  32      66.747  45.243  53.661  1.00 36.59           C  
ATOM    233  C   VAL A  32      66.961  46.651  54.189  1.00 36.34           C  
ATOM    234  O   VAL A  32      67.062  47.611  53.429  1.00 35.13           O  
ATOM    235  CB  VAL A  32      68.116  44.553  53.625  1.00 36.30           C  
ATOM    236  CG1 VAL A  32      67.979  43.159  53.020  1.00 37.03           C  
ATOM    237  CG2 VAL A  32      69.096  45.398  52.827  1.00 35.06           C  
ATOM    238  N   ALA A  33      67.054  46.751  55.510  1.00 37.38           N  
ATOM    239  CA  ALA A  33      67.271  48.020  56.189  1.00 36.31           C  
ATOM    240  C   ALA A  33      68.619  47.984  56.886  1.00 36.88           C  
ATOM    241  O   ALA A  33      68.823  47.196  57.808  1.00 37.35           O  
ATOM    242  CB  ALA A  33      66.174  48.257  57.205  1.00 35.42           C  
ATOM    243  N   ILE A  34      69.542  48.829  56.441  1.00 38.13           N  
ATOM    244  CA  ILE A  34      70.862  48.883  57.054  1.00 38.94           C  
ATOM    245  C   ILE A  34      70.790  49.791  58.273  1.00 40.59           C  
ATOM    246  O   ILE A  34      70.979  51.002  58.168  1.00 40.22           O  
ATOM    247  CB  ILE A  34      71.922  49.448  56.085  1.00 38.37           C  
ATOM    248  CG1 ILE A  34      71.969  48.611  54.806  1.00 38.46           C  
ATOM    249  CG2 ILE A  34      73.290  49.445  56.758  1.00 37.39           C  
ATOM    250  CD1 ILE A  34      72.423  47.187  55.025  1.00 38.95           C  
ATOM    251  N   ALA A  35      70.505  49.198  59.426  1.00 41.92           N  
ATOM    252  CA  ALA A  35      70.408  49.951  60.666  1.00 43.18           C  
ATOM    253  C   ALA A  35      71.751  49.986  61.375  1.00 44.41           C  
ATOM    254  O   ALA A  35      72.446  48.978  61.460  1.00 45.46           O  
ATOM    255  CB  ALA A  35      69.361  49.331  61.568  1.00 42.44           C  
ATOM    256  N   ASP A  36      72.112  51.158  61.878  1.00 46.15           N  
ATOM    257  CA  ASP A  36      73.367  51.329  62.592  1.00 47.31           C  
ATOM    258  C   ASP A  36      73.272  52.613  63.411  1.00 48.60           C  
ATOM    259  O   ASP A  36      72.439  53.477  63.127  1.00 49.31           O  
ATOM    260  CB  ASP A  36      74.525  51.420  61.600  1.00 46.39           C  
ATOM    261  CG  ASP A  36      75.844  50.997  62.208  1.00 45.88           C  
ATOM    262  OD1 ASP A  36      76.002  49.791  62.495  1.00 45.19           O  
ATOM    263  OD2 ASP A  36      76.717  51.870  62.403  1.00 45.12           O  
ATOM    264  N   ILE A  37      74.118  52.741  64.428  1.00 50.09           N  
ATOM    265  CA  ILE A  37      74.096  53.930  65.271  1.00 51.95           C  
ATOM    266  C   ILE A  37      74.655  55.154  64.545  1.00 53.37           C  
ATOM    267  O   ILE A  37      74.262  56.287  64.831  1.00 53.50           O  
ATOM    268  CB  ILE A  37      74.888  53.708  66.566  1.00 51.56           C  
ATOM    269  CG1 ILE A  37      74.677  54.901  67.498  1.00 51.91           C  
ATOM    270  CG2 ILE A  37      76.363  53.511  66.245  1.00 51.01           C  
ATOM    271  CD1 ILE A  37      75.153  54.672  68.914  1.00 52.00           C  
ATOM    272  N   ASN A  38      75.572  54.915  63.610  1.00 54.64           N  
ATOM    273  CA  ASN A  38      76.176  55.983  62.814  1.00 55.52           C  
ATOM    274  C   ASN A  38      75.531  56.023  61.432  1.00 54.73           C  
ATOM    275  O   ASN A  38      75.872  55.220  60.558  1.00 55.80           O  
ATOM    276  CB  ASN A  38      77.680  55.757  62.659  1.00 56.47           C  
ATOM    277  CG  ASN A  38      78.290  56.650  61.596  1.00 57.78           C  
ATOM    278  OD1 ASN A  38      78.147  57.876  61.636  1.00 57.89           O  
ATOM    279  ND2 ASN A  38      78.973  56.040  60.634  1.00 58.70           N  
ATOM    280  N   LEU A  39      74.615  56.963  61.236  1.00 53.84           N  
ATOM    281  CA  LEU A  39      73.903  57.094  59.971  1.00 54.57           C  
ATOM    282  C   LEU A  39      74.807  57.331  58.763  1.00 55.54           C  
ATOM    283  O   LEU A  39      74.412  57.054  57.632  1.00 56.03           O  
ATOM    284  CB  LEU A  39      72.866  58.211  60.073  1.00 53.87           C  
ATOM    285  CG  LEU A  39      71.891  58.326  58.900  1.00 54.60           C  
ATOM    286  CD1 LEU A  39      71.198  56.990  58.674  1.00 54.32           C  
ATOM    287  CD2 LEU A  39      70.868  59.418  59.189  1.00 54.58           C  
ATOM    288  N   GLU A  40      76.016  57.840  58.997  1.00 56.31           N  
ATOM    289  CA  GLU A  40      76.952  58.085  57.898  1.00 57.01           C  
ATOM    290  C   GLU A  40      77.287  56.767  57.212  1.00 56.41           C  
ATOM    291  O   GLU A  40      77.047  56.599  56.018  1.00 57.32           O  
ATOM    292  CB  GLU A  40      78.252  58.726  58.406  1.00 57.92           C  
ATOM    293  CG  GLU A  40      78.133  60.178  58.840  1.00 57.86           C  
ATOM    294  CD  GLU A  40      79.467  60.767  59.256  0.00 57.81           C  
ATOM    295  OE1 GLU A  40      80.381  60.830  58.406  0.00 57.80           O  
ATOM    296  OE2 GLU A  40      79.603  61.165  60.432  0.00 57.80           O  
ATOM    297  N   ALA A  41      77.843  55.838  57.983  1.00 55.70           N  
ATOM    298  CA  ALA A  41      78.223  54.527  57.470  1.00 55.07           C  
ATOM    299  C   ALA A  41      77.017  53.778  56.905  1.00 54.36           C  
ATOM    300  O   ALA A  41      77.128  53.089  55.888  1.00 55.50           O  
ATOM    301  CB  ALA A  41      78.878  53.707  58.574  1.00 54.86           C  
ATOM    302  N   ALA A  42      75.872  53.913  57.568  1.00 51.88           N  
ATOM    303  CA  ALA A  42      74.659  53.248  57.124  1.00 50.49           C  
ATOM    304  C   ALA A  42      74.313  53.669  55.701  1.00 50.10           C  
ATOM    305  O   ALA A  42      74.170  52.825  54.820  1.00 50.28           O  
ATOM    306  CB  ALA A  42      73.507  53.574  58.063  1.00 49.63           C  
ATOM    307  N   ARG A  43      74.185  54.976  55.479  1.00 49.94           N  
ATOM    308  CA  ARG A  43      73.857  55.505  54.156  1.00 49.15           C  
ATOM    309  C   ARG A  43      74.872  55.044  53.119  1.00 48.09           C  
ATOM    310  O   ARG A  43      74.513  54.733  51.984  1.00 47.84           O  
ATOM    311  CB  ARG A  43      73.829  57.038  54.169  1.00 49.16           C  
ATOM    312  CG  ARG A  43      72.814  57.651  55.114  1.00 49.68           C  
ATOM    313  CD  ARG A  43      72.076  58.797  54.438  1.00 49.79           C  
ATOM    314  NE  ARG A  43      72.984  59.726  53.773  0.00 49.84           N  
ATOM    315  CZ  ARG A  43      73.855  60.506  54.403  0.00 49.87           C  
ATOM    316  NH1 ARG A  43      73.942  60.477  55.726  0.00 49.88           N  
ATOM    317  NH2 ARG A  43      74.642  61.317  53.709  0.00 49.88           N  
ATOM    318  N   ALA A  44      76.140  55.010  53.520  1.00 46.99           N  
ATOM    319  CA  ALA A  44      77.225  54.594  52.639  1.00 47.53           C  
ATOM    320  C   ALA A  44      77.025  53.167  52.141  1.00 48.09           C  
ATOM    321  O   ALA A  44      77.068  52.904  50.937  1.00 48.80           O  
ATOM    322  CB  ALA A  44      78.551  54.705  53.372  1.00 46.98           C  
ATOM    323  N   THR A  45      76.814  52.251  53.081  1.00 48.24           N  
ATOM    324  CA  THR A  45      76.603  50.844  52.767  1.00 47.85           C  
ATOM    325  C   THR A  45      75.308  50.634  51.985  1.00 48.44           C  
ATOM    326  O   THR A  45      75.279  49.885  51.008  1.00 48.68           O  
ATOM    327  CB  THR A  45      76.550  50.000  54.058  1.00 47.38           C  
ATOM    328  OG1 THR A  45      77.795  50.119  54.755  1.00 45.66           O  
ATOM    329  CG2 THR A  45      76.298  48.537  53.737  1.00 47.55           C  
ATOM    330  N   ALA A  46      74.240  51.296  52.415  1.00 49.20           N  
ATOM    331  CA  ALA A  46      72.949  51.165  51.751  1.00 50.60           C  
ATOM    332  C   ALA A  46      73.035  51.583  50.289  1.00 51.74           C  
ATOM    333  O   ALA A  46      72.450  50.943  49.411  1.00 52.51           O  
ATOM    334  CB  ALA A  46      71.905  52.005  52.471  1.00 50.87           C  
ATOM    335  N   ALA A  47      73.765  52.663  50.035  1.00 52.05           N  
ATOM    336  CA  ALA A  47      73.920  53.174  48.680  1.00 52.69           C  
ATOM    337  C   ALA A  47      74.826  52.254  47.870  1.00 51.52           C  
ATOM    338  O   ALA A  47      74.700  52.145  46.651  1.00 51.19           O  
ATOM    339  CB  ALA A  47      74.503  54.584  48.723  1.00 52.78           C  
ATOM    340  N   GLU A  48      75.735  51.592  48.571  1.00 51.09           N  
ATOM    341  CA  GLU A  48      76.684  50.680  47.960  1.00 51.37           C  
ATOM    342  C   GLU A  48      75.993  49.388  47.525  1.00 51.47           C  
ATOM    343  O   GLU A  48      76.404  48.758  46.547  1.00 52.14           O  
ATOM    344  CB  GLU A  48      77.795  50.377  48.966  1.00 52.10           C  
ATOM    345  CG  GLU A  48      79.132  50.023  48.358  1.00 54.21           C  
ATOM    346  CD  GLU A  48      80.282  50.286  49.316  1.00 54.75           C  
ATOM    347  OE1 GLU A  48      80.392  51.429  49.803  1.00 56.29           O  
ATOM    348  OE2 GLU A  48      81.076  49.361  49.582  1.00 55.57           O  
ATOM    349  N   ILE A  49      74.938  49.010  48.249  1.00 50.68           N  
ATOM    350  CA  ILE A  49      74.183  47.790  47.962  1.00 49.69           C  
ATOM    351  C   ILE A  49      73.136  47.971  46.865  1.00 49.67           C  
ATOM    352  O   ILE A  49      72.903  47.063  46.067  1.00 49.69           O  
ATOM    353  CB  ILE A  49      73.491  47.246  49.244  1.00 49.01           C  
ATOM    354  CG1 ILE A  49      74.553  46.775  50.240  1.00 48.28           C  
ATOM    355  CG2 ILE A  49      72.545  46.103  48.895  1.00 47.17           C  
ATOM    356  CD1 ILE A  49      73.991  46.144  51.494  1.00 47.96           C  
ATOM    357  N   GLY A  50      72.494  49.132  46.823  1.00 49.39           N  
ATOM    358  CA  GLY A  50      71.502  49.353  45.789  1.00 49.47           C  
ATOM    359  C   GLY A  50      70.148  49.839  46.263  1.00 50.11           C  
ATOM    360  O   GLY A  50      69.948  50.085  47.454  1.00 50.29           O  
ATOM    361  N   PRO A  51      69.190  49.988  45.331  1.00 50.40           N  
ATOM    362  CA  PRO A  51      67.818  50.447  45.581  1.00 49.58           C  
ATOM    363  C   PRO A  51      67.037  49.542  46.530  1.00 49.02           C  
ATOM    364  O   PRO A  51      65.999  49.939  47.061  1.00 49.15           O  
ATOM    365  CB  PRO A  51      67.201  50.466  44.182  1.00 50.07           C  
ATOM    366  CG  PRO A  51      68.379  50.719  43.290  1.00 49.86           C  
ATOM    367  CD  PRO A  51      69.420  49.813  43.886  1.00 49.89           C  
ATOM    368  N   ALA A  52      67.537  48.327  46.734  1.00 48.54           N  
ATOM    369  CA  ALA A  52      66.871  47.365  47.610  1.00 48.72           C  
ATOM    370  C   ALA A  52      67.193  47.600  49.084  1.00 48.10           C  
ATOM    371  O   ALA A  52      66.519  47.070  49.969  1.00 48.18           O  
ATOM    372  CB  ALA A  52      67.254  45.947  47.211  1.00 47.21           C  
ATOM    373  N   ALA A  53      68.223  48.396  49.344  1.00 47.86           N  
ATOM    374  CA  ALA A  53      68.625  48.690  50.711  1.00 48.97           C  
ATOM    375  C   ALA A  53      68.461  50.171  51.057  1.00 49.45           C  
ATOM    376  O   ALA A  53      68.684  51.046  50.223  1.00 50.94           O  
ATOM    377  CB  ALA A  53      70.074  48.265  50.922  1.00 48.79           C  
ATOM    378  N   CYS A  54      68.057  50.442  52.292  1.00 48.98           N  
ATOM    379  CA  CYS A  54      67.893  51.806  52.761  1.00 48.17           C  
ATOM    380  C   CYS A  54      68.506  51.898  54.153  1.00 47.49           C  
ATOM    381  O   CYS A  54      68.521  50.916  54.897  1.00 47.24           O  
ATOM    382  CB  CYS A  54      66.414  52.193  52.786  1.00 49.09           C  
ATOM    383  SG  CYS A  54      65.349  51.067  53.690  1.00 53.63           S  
ATOM    384  N   ALA A  55      69.030  53.072  54.494  1.00 46.35           N  
ATOM    385  CA  ALA A  55      69.663  53.280  55.790  1.00 44.77           C  
ATOM    386  C   ALA A  55      68.709  53.842  56.841  1.00 44.27           C  
ATOM    387  O   ALA A  55      67.659  54.404  56.521  1.00 44.34           O  
ATOM    388  CB  ALA A  55      70.871  54.201  55.632  1.00 44.16           C  
ATOM    389  N   ILE A  56      69.080  53.667  58.102  1.00 43.29           N  
ATOM    390  CA  ILE A  56      68.285  54.165  59.216  1.00 42.02           C  
ATOM    391  C   ILE A  56      69.114  54.136  60.492  1.00 41.19           C  
ATOM    392  O   ILE A  56      69.834  53.170  60.764  1.00 40.62           O  
ATOM    393  CB  ILE A  56      66.990  53.341  59.422  1.00 41.75           C  
ATOM    394  CG1 ILE A  56      66.125  54.009  60.487  1.00 41.95           C  
ATOM    395  CG2 ILE A  56      67.316  51.927  59.862  1.00 41.03           C  
ATOM    396  CD1 ILE A  56      64.719  53.465  60.544  1.00 42.82           C  
ATOM    397  N   ALA A  57      69.023  55.210  61.265  1.00 39.65           N  
ATOM    398  CA  ALA A  57      69.775  55.324  62.506  1.00 38.36           C  
ATOM    399  C   ALA A  57      69.114  54.499  63.603  1.00 37.61           C  
ATOM    400  O   ALA A  57      67.889  54.519  63.759  1.00 36.56           O  
ATOM    401  CB  ALA A  57      69.865  56.786  62.923  1.00 37.83           C  
ATOM    402  N   LEU A  58      69.929  53.773  64.360  1.00 36.28           N  
ATOM    403  CA  LEU A  58      69.398  52.947  65.433  1.00 35.96           C  
ATOM    404  C   LEU A  58      70.359  52.742  66.590  1.00 35.93           C  
ATOM    405  O   LEU A  58      71.520  52.376  66.403  1.00 36.09           O  
ATOM    406  CB  LEU A  58      68.985  51.581  64.889  1.00 35.23           C  
ATOM    407  CG  LEU A  58      68.420  50.599  65.919  1.00 33.94           C  
ATOM    408  CD1 LEU A  58      67.085  51.099  66.441  1.00 30.46           C  
ATOM    409  CD2 LEU A  58      68.251  49.236  65.266  1.00 33.43           C  
ATOM    410  N   ASP A  59      69.861  52.991  67.792  1.00 35.71           N  
ATOM    411  CA  ASP A  59      70.644  52.791  68.998  1.00 35.86           C  
ATOM    412  C   ASP A  59      69.830  51.777  69.788  1.00 35.81           C  
ATOM    413  O   ASP A  59      68.895  52.152  70.498  1.00 35.94           O  
ATOM    414  CB  ASP A  59      70.761  54.089  69.791  1.00 36.21           C  
ATOM    415  CG  ASP A  59      71.683  53.950  70.973  1.00 37.33           C  
ATOM    416  OD1 ASP A  59      71.531  52.970  71.730  1.00 36.23           O  
ATOM    417  OD2 ASP A  59      72.560  54.820  71.143  1.00 40.49           O  
ATOM    418  N   VAL A  60      70.171  50.495  69.654  1.00 34.59           N  
ATOM    419  CA  VAL A  60      69.426  49.441  70.336  1.00 33.19           C  
ATOM    420  C   VAL A  60      69.349  49.582  71.852  1.00 33.10           C  
ATOM    421  O   VAL A  60      68.546  48.905  72.495  1.00 31.94           O  
ATOM    422  CB  VAL A  60      69.980  48.026  69.992  1.00 32.86           C  
ATOM    423  CG1 VAL A  60      69.775  47.737  68.509  1.00 30.34           C  
ATOM    424  CG2 VAL A  60      71.450  47.919  70.371  1.00 31.52           C  
ATOM    425  N   THR A  61      70.169  50.459  72.426  1.00 33.07           N  
ATOM    426  CA  THR A  61      70.153  50.653  73.872  1.00 34.49           C  
ATOM    427  C   THR A  61      69.163  51.740  74.292  1.00 35.19           C  
ATOM    428  O   THR A  61      68.929  51.942  75.482  1.00 36.31           O  
ATOM    429  CB  THR A  61      71.529  51.053  74.406  1.00 34.05           C  
ATOM    430  OG1 THR A  61      71.779  52.424  74.082  1.00 36.43           O  
ATOM    431  CG2 THR A  61      72.609  50.195  73.786  1.00 33.40           C  
ATOM    432  N   ASP A  62      68.583  52.433  73.313  1.00 36.00           N  
ATOM    433  CA  ASP A  62      67.625  53.504  73.593  1.00 35.14           C  
ATOM    434  C   ASP A  62      66.219  53.185  73.091  1.00 34.81           C  
ATOM    435  O   ASP A  62      65.980  53.107  71.885  1.00 34.83           O  
ATOM    436  CB  ASP A  62      68.096  54.809  72.955  1.00 37.13           C  
ATOM    437  CG  ASP A  62      67.159  55.958  73.243  1.00 38.64           C  
ATOM    438  OD1 ASP A  62      67.070  56.358  74.424  1.00 40.81           O  
ATOM    439  OD2 ASP A  62      66.504  56.452  72.300  1.00 38.60           O  
ATOM    440  N   GLN A  63      65.283  53.027  74.017  1.00 33.87           N  
ATOM    441  CA  GLN A  63      63.908  52.704  73.660  1.00 33.52           C  
ATOM    442  C   GLN A  63      63.325  53.656  72.617  1.00 34.72           C  
ATOM    443  O   GLN A  63      62.631  53.235  71.694  1.00 35.13           O  
ATOM    444  CB  GLN A  63      63.030  52.723  74.909  1.00 32.53           C  
ATOM    445  CG  GLN A  63      61.636  52.164  74.687  1.00 32.39           C  
ATOM    446  CD  GLN A  63      61.657  50.689  74.328  1.00 32.46           C  
ATOM    447  OE1 GLN A  63      62.195  49.866  75.069  1.00 31.56           O  
ATOM    448  NE2 GLN A  63      61.067  50.349  73.187  1.00 30.21           N  
ATOM    449  N   ALA A  64      63.606  54.946  72.762  1.00 35.86           N  
ATOM    450  CA  ALA A  64      63.081  55.938  71.826  1.00 34.48           C  
ATOM    451  C   ALA A  64      63.556  55.656  70.409  1.00 32.80           C  
ATOM    452  O   ALA A  64      62.764  55.675  69.466  1.00 32.43           O  
ATOM    453  CB  ALA A  64      63.502  57.345  72.253  1.00 35.25           C  
ATOM    454  N   SER A  65      64.853  55.400  70.263  1.00 31.21           N  
ATOM    455  CA  SER A  65      65.434  55.115  68.954  1.00 30.13           C  
ATOM    456  C   SER A  65      64.821  53.838  68.382  1.00 29.47           C  
ATOM    457  O   SER A  65      64.599  53.725  67.179  1.00 27.80           O  
ATOM    458  CB  SER A  65      66.949  54.962  69.074  1.00 29.21           C  
ATOM    459  OG  SER A  65      67.548  54.847  67.799  1.00 30.51           O  
ATOM    460  N   ILE A  66      64.540  52.884  69.263  1.00 29.84           N  
ATOM    461  CA  ILE A  66      63.950  51.616  68.860  1.00 30.26           C  
ATOM    462  C   ILE A  66      62.540  51.821  68.309  1.00 32.24           C  
ATOM    463  O   ILE A  66      62.226  51.360  67.212  1.00 32.91           O  
ATOM    464  CB  ILE A  66      63.928  50.610  70.050  1.00 27.13           C  
ATOM    465  CG1 ILE A  66      65.326  50.018  70.245  1.00 24.91           C  
ATOM    466  CG2 ILE A  66      62.899  49.521  69.814  1.00 24.45           C  
ATOM    467  CD1 ILE A  66      65.449  49.085  71.431  1.00 26.91           C  
ATOM    468  N   ASP A  67      61.693  52.519  69.059  1.00 34.00           N  
ATOM    469  CA  ASP A  67      60.324  52.758  68.612  1.00 35.40           C  
ATOM    470  C   ASP A  67      60.267  53.588  67.329  1.00 36.75           C  
ATOM    471  O   ASP A  67      59.375  53.404  66.496  1.00 36.01           O  
ATOM    472  CB  ASP A  67      59.515  53.446  69.714  1.00 36.58           C  
ATOM    473  CG  ASP A  67      59.402  52.600  70.966  1.00 38.36           C  
ATOM    474  OD1 ASP A  67      59.122  51.394  70.831  1.00 39.81           O  
ATOM    475  OD2 ASP A  67      59.585  53.138  72.083  1.00 38.47           O  
ATOM    476  N   ARG A  68      61.209  54.510  67.169  1.00 38.36           N  
ATOM    477  CA  ARG A  68      61.229  55.328  65.971  1.00 40.77           C  
ATOM    478  C   ARG A  68      61.547  54.435  64.788  1.00 41.08           C  
ATOM    479  O   ARG A  68      60.820  54.426  63.793  1.00 40.58           O  
ATOM    480  CB  ARG A  68      62.284  56.430  66.072  1.00 44.09           C  
ATOM    481  CG  ARG A  68      61.762  57.758  66.588  1.00 48.76           C  
ATOM    482  CD  ARG A  68      62.704  58.888  66.177  1.00 53.27           C  
ATOM    483  NE  ARG A  68      64.029  58.767  66.786  1.00 54.86           N  
ATOM    484  CZ  ARG A  68      64.285  59.009  68.068  1.00 54.87           C  
ATOM    485  NH1 ARG A  68      63.305  59.389  68.881  1.00 55.06           N  
ATOM    486  NH2 ARG A  68      65.520  58.869  68.539  1.00 54.48           N  
ATOM    487  N   CYS A  69      62.637  53.681  64.915  1.00 40.06           N  
ATOM    488  CA  CYS A  69      63.090  52.771  63.872  1.00 39.62           C  
ATOM    489  C   CYS A  69      61.975  51.881  63.327  1.00 38.72           C  
ATOM    490  O   CYS A  69      61.729  51.840  62.121  1.00 37.80           O  
ATOM    491  CB  CYS A  69      64.223  51.897  64.407  1.00 39.99           C  
ATOM    492  SG  CYS A  69      64.697  50.541  63.303  1.00 42.49           S  
ATOM    493  N   VAL A  70      61.298  51.175  64.225  1.00 38.16           N  
ATOM    494  CA  VAL A  70      60.221  50.276  63.839  1.00 37.40           C  
ATOM    495  C   VAL A  70      59.044  50.992  63.189  1.00 38.38           C  
ATOM    496  O   VAL A  70      58.516  50.533  62.179  1.00 40.49           O  
ATOM    497  CB  VAL A  70      59.713  49.480  65.058  1.00 36.15           C  
ATOM    498  CG1 VAL A  70      58.419  48.753  64.714  1.00 34.94           C  
ATOM    499  CG2 VAL A  70      60.778  48.487  65.492  1.00 34.51           C  
ATOM    500  N   ALA A  71      58.628  52.110  63.770  1.00 38.72           N  
ATOM    501  CA  ALA A  71      57.511  52.871  63.229  1.00 38.96           C  
ATOM    502  C   ALA A  71      57.818  53.399  61.823  1.00 39.02           C  
ATOM    503  O   ALA A  71      56.956  53.391  60.948  1.00 37.96           O  
ATOM    504  CB  ALA A  71      57.174  54.031  64.166  1.00 39.38           C  
ATOM    505  N   GLU A  72      59.050  53.846  61.610  1.00 38.71           N  
ATOM    506  CA  GLU A  72      59.451  54.382  60.317  1.00 40.87           C  
ATOM    507  C   GLU A  72      59.446  53.319  59.223  1.00 42.58           C  
ATOM    508  O   GLU A  72      58.914  53.543  58.132  1.00 43.89           O  
ATOM    509  CB  GLU A  72      60.838  55.011  60.423  1.00 41.27           C  
ATOM    510  CG  GLU A  72      61.323  55.657  59.144  1.00 44.16           C  
ATOM    511  CD  GLU A  72      62.493  56.588  59.391  1.00 46.54           C  
ATOM    512  OE1 GLU A  72      63.034  57.152  58.415  1.00 46.48           O  
ATOM    513  OE2 GLU A  72      62.867  56.757  60.571  1.00 48.50           O  
ATOM    514  N   LEU A  73      60.039  52.165  59.513  1.00 42.36           N  
ATOM    515  CA  LEU A  73      60.091  51.072  58.553  1.00 40.61           C  
ATOM    516  C   LEU A  73      58.691  50.554  58.261  1.00 41.27           C  
ATOM    517  O   LEU A  73      58.394  50.139  57.140  1.00 40.27           O  
ATOM    518  CB  LEU A  73      60.968  49.943  59.089  1.00 40.13           C  
ATOM    519  CG  LEU A  73      62.456  50.288  59.191  1.00 38.89           C  
ATOM    520  CD1 LEU A  73      63.187  49.152  59.882  1.00 38.35           C  
ATOM    521  CD2 LEU A  73      63.031  50.544  57.798  1.00 37.11           C  
ATOM    522  N   LEU A  74      57.828  50.582  59.271  1.00 42.57           N  
ATOM    523  CA  LEU A  74      56.458  50.127  59.092  1.00 45.20           C  
ATOM    524  C   LEU A  74      55.730  50.973  58.057  1.00 47.81           C  
ATOM    525  O   LEU A  74      54.877  50.470  57.330  1.00 48.42           O  
ATOM    526  CB  LEU A  74      55.693  50.172  60.415  1.00 43.87           C  
ATOM    527  CG  LEU A  74      55.799  48.926  61.294  1.00 44.62           C  
ATOM    528  CD1 LEU A  74      54.954  49.110  62.549  1.00 45.12           C  
ATOM    529  CD2 LEU A  74      55.316  47.710  60.514  1.00 44.40           C  
ATOM    530  N   ASP A  75      56.063  52.259  57.993  1.00 50.76           N  
ATOM    531  CA  ASP A  75      55.419  53.149  57.038  1.00 52.76           C  
ATOM    532  C   ASP A  75      56.063  53.033  55.668  1.00 52.17           C  
ATOM    533  O   ASP A  75      55.394  53.202  54.654  1.00 52.65           O  
ATOM    534  CB  ASP A  75      55.471  54.603  57.519  1.00 56.34           C  
ATOM    535  CG  ASP A  75      54.772  54.802  58.857  1.00 59.85           C  
ATOM    536  OD1 ASP A  75      53.805  54.060  59.148  1.00 60.41           O  
ATOM    537  OD2 ASP A  75      55.185  55.710  59.611  1.00 62.77           O  
ATOM    538  N   ARG A  76      57.359  52.742  55.636  1.00 51.65           N  
ATOM    539  CA  ARG A  76      58.061  52.598  54.365  1.00 50.77           C  
ATOM    540  C   ARG A  76      57.769  51.245  53.720  1.00 48.49           C  
ATOM    541  O   ARG A  76      57.693  51.145  52.497  1.00 48.31           O  
ATOM    542  CB  ARG A  76      59.578  52.722  54.543  1.00 52.74           C  
ATOM    543  CG  ARG A  76      60.080  54.013  55.161  1.00 56.53           C  
ATOM    544  CD  ARG A  76      61.550  54.191  54.801  1.00 60.30           C  
ATOM    545  NE  ARG A  76      62.307  54.941  55.799  1.00 64.33           N  
ATOM    546  CZ  ARG A  76      63.612  55.187  55.708  1.00 66.39           C  
ATOM    547  NH1 ARG A  76      64.300  54.747  54.659  1.00 66.95           N  
ATOM    548  NH2 ARG A  76      64.236  55.862  56.669  1.00 67.54           N  
ATOM    549  N   TRP A  77      57.609  50.207  54.538  1.00 45.41           N  
ATOM    550  CA  TRP A  77      57.355  48.865  54.013  1.00 42.13           C  
ATOM    551  C   TRP A  77      55.957  48.315  54.253  1.00 41.62           C  
ATOM    552  O   TRP A  77      55.476  47.495  53.479  1.00 42.05           O  
ATOM    553  CB  TRP A  77      58.349  47.856  54.592  1.00 40.03           C  
ATOM    554  CG  TRP A  77      59.786  48.112  54.272  1.00 37.51           C  
ATOM    555  CD1 TRP A  77      60.286  48.804  53.207  1.00 36.49           C  
ATOM    556  CD2 TRP A  77      60.918  47.602  54.986  1.00 36.56           C  
ATOM    557  NE1 TRP A  77      61.660  48.753  53.212  1.00 36.46           N  
ATOM    558  CE2 TRP A  77      62.073  48.018  54.294  1.00 35.91           C  
ATOM    559  CE3 TRP A  77      61.067  46.824  56.142  1.00 36.20           C  
ATOM    560  CZ2 TRP A  77      63.362  47.690  54.720  1.00 36.10           C  
ATOM    561  CZ3 TRP A  77      62.346  46.497  56.566  1.00 35.54           C  
ATOM    562  CH2 TRP A  77      63.477  46.928  55.854  1.00 35.62           C  
ATOM    563  N   GLY A  78      55.308  48.750  55.327  1.00 41.28           N  
ATOM    564  CA  GLY A  78      53.983  48.243  55.626  1.00 39.86           C  
ATOM    565  C   GLY A  78      54.069  47.020  56.520  1.00 39.97           C  
ATOM    566  O   GLY A  78      53.073  46.593  57.099  1.00 40.78           O  
ATOM    567  N   SER A  79      55.260  46.439  56.624  1.00 39.94           N  
ATOM    568  CA  SER A  79      55.466  45.265  57.472  1.00 40.25           C  
ATOM    569  C   SER A  79      56.922  44.809  57.479  1.00 39.63           C  
ATOM    570  O   SER A  79      57.627  44.917  56.470  1.00 39.90           O  
ATOM    571  CB  SER A  79      54.586  44.099  57.013  1.00 40.29           C  
ATOM    572  OG  SER A  79      55.046  43.576  55.780  1.00 41.43           O  
ATOM    573  N   ILE A  80      57.363  44.307  58.627  1.00 37.58           N  
ATOM    574  CA  ILE A  80      58.721  43.807  58.783  1.00 35.51           C  
ATOM    575  C   ILE A  80      58.584  42.292  58.849  1.00 34.68           C  
ATOM    576  O   ILE A  80      57.972  41.766  59.781  1.00 35.20           O  
ATOM    577  CB  ILE A  80      59.349  44.316  60.087  1.00 35.48           C  
ATOM    578  CG1 ILE A  80      59.285  45.842  60.120  1.00 36.66           C  
ATOM    579  CG2 ILE A  80      60.789  43.847  60.194  1.00 34.17           C  
ATOM    580  CD1 ILE A  80      59.777  46.441  61.416  1.00 38.10           C  
ATOM    581  N   ASP A  81      59.132  41.593  57.857  1.00 31.81           N  
ATOM    582  CA  ASP A  81      59.032  40.137  57.824  1.00 29.02           C  
ATOM    583  C   ASP A  81      60.141  39.429  58.582  1.00 26.87           C  
ATOM    584  O   ASP A  81      59.909  38.397  59.210  1.00 25.72           O  
ATOM    585  CB  ASP A  81      59.040  39.622  56.385  1.00 30.39           C  
ATOM    586  CG  ASP A  81      57.923  40.206  55.547  1.00 32.09           C  
ATOM    587  OD1 ASP A  81      56.778  40.285  56.048  1.00 32.38           O  
ATOM    588  OD2 ASP A  81      58.195  40.575  54.382  1.00 32.67           O  
ATOM    589  N   ILE A  82      61.343  39.988  58.525  1.00 24.06           N  
ATOM    590  CA  ILE A  82      62.491  39.365  59.167  1.00 23.63           C  
ATOM    591  C   ILE A  82      63.333  40.338  59.984  1.00 23.22           C  
ATOM    592  O   ILE A  82      63.614  41.453  59.546  1.00 23.85           O  
ATOM    593  CB  ILE A  82      63.417  38.723  58.107  1.00 23.10           C  
ATOM    594  CG1 ILE A  82      62.590  37.916  57.100  1.00 24.17           C  
ATOM    595  CG2 ILE A  82      64.447  37.850  58.787  1.00 20.12           C  
ATOM    596  CD1 ILE A  82      63.386  37.430  55.883  1.00 21.60           C  
ATOM    597  N   LEU A  83      63.761  39.893  61.158  1.00 22.50           N  
ATOM    598  CA  LEU A  83      64.583  40.710  62.040  1.00 21.46           C  
ATOM    599  C   LEU A  83      65.823  39.928  62.448  1.00 21.96           C  
ATOM    600  O   LEU A  83      65.726  38.800  62.937  1.00 23.88           O  
ATOM    601  CB  LEU A  83      63.770  41.120  63.278  1.00 21.20           C  
ATOM    602  CG  LEU A  83      64.383  41.947  64.422  1.00 22.02           C  
ATOM    603  CD1 LEU A  83      64.828  41.024  65.518  1.00 24.56           C  
ATOM    604  CD2 LEU A  83      65.534  42.806  63.934  1.00 21.61           C  
ATOM    605  N   VAL A  84      66.990  40.527  62.234  1.00 21.01           N  
ATOM    606  CA  VAL A  84      68.241  39.884  62.584  1.00 20.11           C  
ATOM    607  C   VAL A  84      69.025  40.720  63.580  1.00 20.79           C  
ATOM    608  O   VAL A  84      69.638  41.723  63.216  1.00 22.04           O  
ATOM    609  CB  VAL A  84      69.127  39.651  61.333  1.00 21.55           C  
ATOM    610  CG1 VAL A  84      70.445  38.997  61.740  1.00 18.11           C  
ATOM    611  CG2 VAL A  84      68.385  38.777  60.321  1.00 20.98           C  
ATOM    612  N   ASN A  85      69.000  40.306  64.842  1.00 20.08           N  
ATOM    613  CA  ASN A  85      69.732  41.010  65.881  1.00 18.51           C  
ATOM    614  C   ASN A  85      71.221  40.682  65.759  1.00 18.52           C  
ATOM    615  O   ASN A  85      71.719  39.748  66.387  1.00 19.21           O  
ATOM    616  CB  ASN A  85      69.220  40.612  67.271  1.00 18.41           C  
ATOM    617  CG  ASN A  85      67.817  41.148  67.562  1.00 18.99           C  
ATOM    618  OD1 ASN A  85      67.511  42.307  67.285  1.00 16.61           O  
ATOM    619  ND2 ASN A  85      66.967  40.304  68.140  1.00 18.55           N  
ATOM    620  N   ASN A  86      71.922  41.461  64.941  1.00 18.04           N  
ATOM    621  CA  ASN A  86      73.350  41.274  64.717  1.00 18.54           C  
ATOM    622  C   ASN A  86      74.246  42.242  65.521  1.00 18.47           C  
ATOM    623  O   ASN A  86      75.428  41.966  65.733  1.00 14.60           O  
ATOM    624  CB  ASN A  86      73.651  41.425  63.221  1.00 18.83           C  
ATOM    625  CG  ASN A  86      75.126  41.285  62.908  1.00 23.16           C  
ATOM    626  OD1 ASN A  86      75.716  40.218  63.092  1.00 24.69           O  
ATOM    627  ND2 ASN A  86      75.737  42.369  62.440  1.00 27.29           N  
ATOM    628  N   ALA A  87      73.690  43.372  65.966  1.00 18.54           N  
ATOM    629  CA  ALA A  87      74.470  44.360  66.724  1.00 18.23           C  
ATOM    630  C   ALA A  87      75.049  43.781  68.006  1.00 17.40           C  
ATOM    631  O   ALA A  87      74.333  43.195  68.813  1.00 18.97           O  
ATOM    632  CB  ALA A  87      73.610  45.576  67.046  1.00 18.39           C  
ATOM    633  N   ALA A  88      76.349  43.954  68.202  1.00 17.55           N  
ATOM    634  CA  ALA A  88      76.986  43.416  69.388  1.00 18.66           C  
ATOM    635  C   ALA A  88      78.356  44.032  69.653  1.00 20.46           C  
ATOM    636  O   ALA A  88      78.946  44.669  68.784  1.00 21.40           O  
ATOM    637  CB  ALA A  88      77.115  41.900  69.248  1.00 18.28           C  
ATOM    638  N   LEU A  89      78.852  43.835  70.868  1.00 22.35           N  
ATOM    639  CA  LEU A  89      80.154  44.346  71.260  1.00 22.91           C  
ATOM    640  C   LEU A  89      80.952  43.236  71.905  1.00 21.30           C  
ATOM    641  O   LEU A  89      80.401  42.325  72.512  1.00 19.69           O  
ATOM    642  CB  LEU A  89      80.021  45.505  72.255  1.00 27.01           C  
ATOM    643  CG  LEU A  89      79.885  46.938  71.729  1.00 29.37           C  
ATOM    644  CD1 LEU A  89      79.822  47.885  72.922  1.00 30.12           C  
ATOM    645  CD2 LEU A  89      81.077  47.297  70.845  1.00 29.29           C  
ATOM    646  N   PHE A  90      82.262  43.332  71.776  1.00 22.22           N  
ATOM    647  CA  PHE A  90      83.154  42.340  72.336  1.00 22.86           C  
ATOM    648  C   PHE A  90      84.165  43.000  73.271  1.00 24.47           C  
ATOM    649  O   PHE A  90      84.477  44.182  73.130  1.00 25.08           O  
ATOM    650  CB  PHE A  90      83.873  41.606  71.204  1.00 19.71           C  
ATOM    651  CG  PHE A  90      84.873  40.615  71.683  1.00 20.71           C  
ATOM    652  CD1 PHE A  90      86.216  40.952  71.763  1.00 20.21           C  
ATOM    653  CD2 PHE A  90      84.469  39.348  72.086  1.00 20.67           C  
ATOM    654  CE1 PHE A  90      87.146  40.043  72.244  1.00 20.92           C  
ATOM    655  CE2 PHE A  90      85.390  38.431  72.568  1.00 19.79           C  
ATOM    656  CZ  PHE A  90      86.733  38.779  72.643  1.00 21.68           C  
ATOM    657  N   ASP A  91      84.675  42.229  74.224  1.00 25.32           N  
ATOM    658  CA  ASP A  91      85.643  42.737  75.180  1.00 25.52           C  
ATOM    659  C   ASP A  91      86.150  41.545  75.984  1.00 26.06           C  
ATOM    660  O   ASP A  91      85.492  40.505  76.047  1.00 25.43           O  
ATOM    661  CB  ASP A  91      84.965  43.746  76.110  1.00 28.34           C  
ATOM    662  CG  ASP A  91      85.931  44.784  76.674  1.00 28.51           C  
ATOM    663  OD1 ASP A  91      85.482  45.583  77.522  1.00 32.55           O  
ATOM    664  OD2 ASP A  91      87.118  44.813  76.278  1.00 25.53           O  
ATOM    665  N   LEU A  92      87.319  41.688  76.594  1.00 25.99           N  
ATOM    666  CA  LEU A  92      87.868  40.602  77.387  1.00 25.97           C  
ATOM    667  C   LEU A  92      88.697  41.119  78.541  1.00 24.25           C  
ATOM    668  O   LEU A  92      89.287  42.191  78.462  1.00 25.34           O  
ATOM    669  CB  LEU A  92      88.708  39.673  76.502  1.00 28.10           C  
ATOM    670  CG  LEU A  92      89.858  40.271  75.690  1.00 29.37           C  
ATOM    671  CD1 LEU A  92      91.183  39.880  76.316  1.00 31.08           C  
ATOM    672  CD2 LEU A  92      89.794  39.758  74.268  1.00 30.89           C  
ATOM    673  N   ALA A  93      88.726  40.350  79.619  1.00 22.01           N  
ATOM    674  CA  ALA A  93      89.487  40.716  80.799  1.00 21.68           C  
ATOM    675  C   ALA A  93      89.231  39.666  81.862  1.00 19.84           C  
ATOM    676  O   ALA A  93      88.138  39.104  81.922  1.00 20.46           O  
ATOM    677  CB  ALA A  93      89.044  42.097  81.307  1.00 22.18           C  
ATOM    678  N   PRO A  94      90.241  39.370  82.700  1.00 18.44           N  
ATOM    679  CA  PRO A  94      90.073  38.374  83.762  1.00 18.56           C  
ATOM    680  C   PRO A  94      89.029  38.858  84.770  1.00 19.10           C  
ATOM    681  O   PRO A  94      88.662  40.038  84.792  1.00 17.96           O  
ATOM    682  CB  PRO A  94      91.467  38.290  84.391  1.00 17.65           C  
ATOM    683  CG  PRO A  94      92.373  38.672  83.278  1.00 16.82           C  
ATOM    684  CD  PRO A  94      91.647  39.802  82.604  1.00 17.44           C  
ATOM    685  N   ILE A  95      88.563  37.945  85.610  1.00 19.35           N  
ATOM    686  CA  ILE A  95      87.574  38.278  86.621  1.00 19.77           C  
ATOM    687  C   ILE A  95      87.995  39.481  87.477  1.00 19.74           C  
ATOM    688  O   ILE A  95      87.268  40.465  87.563  1.00 18.49           O  
ATOM    689  CB  ILE A  95      87.313  37.075  87.558  1.00 19.29           C  
ATOM    690  CG1 ILE A  95      86.677  35.926  86.768  1.00 19.44           C  
ATOM    691  CG2 ILE A  95      86.407  37.498  88.717  1.00 19.79           C  
ATOM    692  CD1 ILE A  95      85.317  36.262  86.163  1.00 17.09           C  
ATOM    693  N   VAL A  96      89.169  39.407  88.096  1.00 19.67           N  
ATOM    694  CA  VAL A  96      89.624  40.496  88.956  1.00 21.64           C  
ATOM    695  C   VAL A  96      89.892  41.831  88.255  1.00 22.62           C  
ATOM    696  O   VAL A  96      90.234  42.803  88.915  1.00 24.28           O  
ATOM    697  CB  VAL A  96      90.905  40.106  89.753  1.00 20.39           C  
ATOM    698  CG1 VAL A  96      90.698  38.779  90.463  1.00 19.41           C  
ATOM    699  CG2 VAL A  96      92.099  40.038  88.828  1.00 19.92           C  
ATOM    700  N   GLU A  97      89.732  41.889  86.934  1.00 22.01           N  
ATOM    701  CA  GLU A  97      89.978  43.131  86.202  1.00 20.95           C  
ATOM    702  C   GLU A  97      88.753  43.657  85.482  1.00 21.11           C  
ATOM    703  O   GLU A  97      88.806  44.702  84.838  1.00 22.26           O  
ATOM    704  CB  GLU A  97      91.099  42.944  85.178  1.00 21.10           C  
ATOM    705  CG  GLU A  97      92.492  42.908  85.776  1.00 23.62           C  
ATOM    706  CD  GLU A  97      93.561  42.636  84.739  1.00 23.81           C  
ATOM    707  OE1 GLU A  97      93.529  43.268  83.663  1.00 26.41           O  
ATOM    708  OE2 GLU A  97      94.439  41.795  85.001  1.00 27.00           O  
ATOM    709  N   ILE A  98      87.648  42.934  85.579  1.00 20.73           N  
ATOM    710  CA  ILE A  98      86.432  43.359  84.911  1.00 19.76           C  
ATOM    711  C   ILE A  98      85.995  44.700  85.494  1.00 20.11           C  
ATOM    712  O   ILE A  98      86.062  44.908  86.702  1.00 20.28           O  
ATOM    713  CB  ILE A  98      85.323  42.297  85.085  1.00 18.40           C  
ATOM    714  CG1 ILE A  98      85.755  40.995  84.410  1.00 18.46           C  
ATOM    715  CG2 ILE A  98      84.018  42.792  84.486  1.00 17.99           C  
ATOM    716  CD1 ILE A  98      84.761  39.865  84.573  1.00 18.69           C  
ATOM    717  N   THR A  99      85.552  45.602  84.632  1.00 19.91           N  
ATOM    718  CA  THR A  99      85.118  46.922  85.063  1.00 20.47           C  
ATOM    719  C   THR A  99      83.614  47.057  84.915  1.00 21.49           C  
ATOM    720  O   THR A  99      82.996  46.322  84.148  1.00 22.14           O  
ATOM    721  CB  THR A  99      85.775  48.003  84.222  1.00 20.02           C  
ATOM    722  OG1 THR A  99      85.271  47.931  82.882  1.00 21.23           O  
ATOM    723  CG2 THR A  99      87.287  47.808  84.205  1.00 18.99           C  
ATOM    724  N   ARG A 100      83.026  47.998  85.648  1.00 20.86           N  
ATOM    725  CA  ARG A 100      81.586  48.209  85.584  1.00 21.25           C  
ATOM    726  C   ARG A 100      81.204  48.769  84.232  1.00 22.04           C  
ATOM    727  O   ARG A 100      80.064  48.625  83.786  1.00 21.32           O  
ATOM    728  CB  ARG A 100      81.128  49.183  86.672  1.00 21.99           C  
ATOM    729  CG  ARG A 100      81.252  48.653  88.081  1.00 21.45           C  
ATOM    730  CD  ARG A 100      79.908  48.692  88.762  1.00 21.05           C  
ATOM    731  NE  ARG A 100      79.927  47.935  90.002  1.00 21.89           N  
ATOM    732  CZ  ARG A 100      78.852  47.363  90.527  1.00 21.17           C  
ATOM    733  NH1 ARG A 100      78.947  46.689  91.663  1.00 22.28           N  
ATOM    734  NH2 ARG A 100      77.686  47.459  89.904  1.00 19.13           N  
ATOM    735  N   GLU A 101      82.158  49.425  83.581  1.00 22.16           N  
ATOM    736  CA  GLU A 101      81.882  50.001  82.278  1.00 25.43           C  
ATOM    737  C   GLU A 101      81.828  48.901  81.217  1.00 23.60           C  
ATOM    738  O   GLU A 101      81.019  48.968  80.295  1.00 23.03           O  
ATOM    739  CB  GLU A 101      82.944  51.045  81.918  1.00 28.13           C  
ATOM    740  CG  GLU A 101      84.355  50.510  81.919  1.00 37.06           C  
ATOM    741  CD  GLU A 101      84.934  50.431  80.531  1.00 41.38           C  
ATOM    742  OE1 GLU A 101      85.317  49.327  80.098  1.00 43.62           O  
ATOM    743  OE2 GLU A 101      85.007  51.484  79.875  1.00 47.06           O  
ATOM    744  N   SER A 102      82.675  47.887  81.344  1.00 22.31           N  
ATOM    745  CA  SER A 102      82.654  46.803  80.372  1.00 23.09           C  
ATOM    746  C   SER A 102      81.324  46.066  80.512  1.00 22.44           C  
ATOM    747  O   SER A 102      80.595  45.858  79.534  1.00 22.31           O  
ATOM    748  CB  SER A 102      83.811  45.842  80.613  1.00 25.08           C  
ATOM    749  OG  SER A 102      83.891  44.912  79.546  1.00 28.87           O  
ATOM    750  N   TYR A 103      81.006  45.685  81.741  1.00 18.65           N  
ATOM    751  CA  TYR A 103      79.761  45.000  82.023  1.00 21.34           C  
ATOM    752  C   TYR A 103      78.554  45.796  81.506  1.00 21.94           C  
ATOM    753  O   TYR A 103      77.782  45.307  80.682  1.00 23.56           O  
ATOM    754  CB  TYR A 103      79.620  44.783  83.532  1.00 21.53           C  
ATOM    755  CG  TYR A 103      78.265  44.263  83.942  1.00 23.00           C  
ATOM    756  CD1 TYR A 103      77.950  42.911  83.819  1.00 22.62           C  
ATOM    757  CD2 TYR A 103      77.273  45.134  84.400  1.00 22.76           C  
ATOM    758  CE1 TYR A 103      76.683  42.438  84.135  1.00 22.98           C  
ATOM    759  CE2 TYR A 103      75.996  44.667  84.719  1.00 23.79           C  
ATOM    760  CZ  TYR A 103      75.712  43.316  84.581  1.00 23.99           C  
ATOM    761  OH  TYR A 103      74.457  42.833  84.872  1.00 25.68           O  
ATOM    762  N   ASP A 104      78.403  47.019  82.003  1.00 22.49           N  
ATOM    763  CA  ASP A 104      77.291  47.897  81.634  1.00 23.01           C  
ATOM    764  C   ASP A 104      77.059  48.006  80.139  1.00 22.19           C  
ATOM    765  O   ASP A 104      75.919  47.951  79.673  1.00 21.72           O  
ATOM    766  CB  ASP A 104      77.519  49.314  82.175  1.00 24.41           C  
ATOM    767  CG  ASP A 104      77.398  49.404  83.688  1.00 26.69           C  
ATOM    768  OD1 ASP A 104      77.807  50.448  84.234  1.00 29.39           O  
ATOM    769  OD2 ASP A 104      76.896  48.458  84.334  1.00 25.80           O  
ATOM    770  N   ARG A 105      78.144  48.184  79.396  1.00 20.95           N  
ATOM    771  CA  ARG A 105      78.073  48.344  77.952  1.00 22.47           C  
ATOM    772  C   ARG A 105      77.706  47.070  77.156  1.00 22.12           C  
ATOM    773  O   ARG A 105      76.786  47.092  76.331  1.00 19.28           O  
ATOM    774  CB  ARG A 105      79.399  48.927  77.454  1.00 25.69           C  
ATOM    775  CG  ARG A 105      79.239  50.194  76.636  1.00 29.95           C  
ATOM    776  CD  ARG A 105      80.584  50.808  76.272  1.00 33.99           C  
ATOM    777  NE  ARG A 105      81.545  49.839  75.746  1.00 37.09           N  
ATOM    778  CZ  ARG A 105      82.588  49.376  76.429  1.00 39.00           C  
ATOM    779  NH1 ARG A 105      82.810  49.791  77.674  1.00 41.45           N  
ATOM    780  NH2 ARG A 105      83.420  48.511  75.866  1.00 39.59           N  
ATOM    781  N   LEU A 106      78.408  45.966  77.409  1.00 21.14           N  
ATOM    782  CA  LEU A 106      78.130  44.731  76.688  1.00 19.92           C  
ATOM    783  C   LEU A 106      76.711  44.228  76.925  1.00 19.76           C  
ATOM    784  O   LEU A 106      76.029  43.827  75.976  1.00 18.73           O  
ATOM    785  CB  LEU A 106      79.137  43.638  77.067  1.00 20.49           C  
ATOM    786  CG  LEU A 106      80.627  43.896  76.802  1.00 19.85           C  
ATOM    787  CD1 LEU A 106      81.328  42.563  76.586  1.00 17.67           C  
ATOM    788  CD2 LEU A 106      80.812  44.768  75.579  1.00 19.59           C  
ATOM    789  N   PHE A 107      76.254  44.249  78.176  1.00 17.48           N  
ATOM    790  CA  PHE A 107      74.901  43.782  78.455  1.00 18.47           C  
ATOM    791  C   PHE A 107      73.849  44.701  77.853  1.00 19.90           C  
ATOM    792  O   PHE A 107      72.800  44.240  77.390  1.00 20.21           O  
ATOM    793  CB  PHE A 107      74.664  43.627  79.959  1.00 18.99           C  
ATOM    794  CG  PHE A 107      75.039  42.269  80.493  1.00 17.93           C  
ATOM    795  CD1 PHE A 107      76.360  41.954  80.771  1.00 16.68           C  
ATOM    796  CD2 PHE A 107      74.064  41.293  80.680  1.00 17.68           C  
ATOM    797  CE1 PHE A 107      76.708  40.683  81.225  1.00 19.17           C  
ATOM    798  CE2 PHE A 107      74.400  40.024  81.131  1.00 18.06           C  
ATOM    799  CZ  PHE A 107      75.724  39.716  81.404  1.00 17.93           C  
ATOM    800  N   ALA A 108      74.128  46.002  77.850  1.00 20.29           N  
ATOM    801  CA  ALA A 108      73.195  46.969  77.283  1.00 20.07           C  
ATOM    802  C   ALA A 108      72.947  46.698  75.793  1.00 20.51           C  
ATOM    803  O   ALA A 108      71.810  46.708  75.324  1.00 21.81           O  
ATOM    804  CB  ALA A 108      73.736  48.373  77.473  1.00 20.59           C  
ATOM    805  N   ILE A 109      74.010  46.434  75.050  1.00 20.73           N  
ATOM    806  CA  ILE A 109      73.877  46.181  73.623  1.00 22.03           C  
ATOM    807  C   ILE A 109      73.563  44.741  73.229  1.00 20.38           C  
ATOM    808  O   ILE A 109      72.616  44.496  72.491  1.00 21.07           O  
ATOM    809  CB  ILE A 109      75.148  46.606  72.888  1.00 25.48           C  
ATOM    810  CG1 ILE A 109      75.406  48.090  73.158  1.00 26.67           C  
ATOM    811  CG2 ILE A 109      75.007  46.315  71.384  1.00 24.01           C  
ATOM    812  CD1 ILE A 109      76.775  48.553  72.754  1.00 30.52           C  
ATOM    813  N   ASN A 110      74.360  43.795  73.721  1.00 19.70           N  
ATOM    814  CA  ASN A 110      74.185  42.380  73.397  1.00 18.57           C  
ATOM    815  C   ASN A 110      72.881  41.764  73.892  1.00 18.89           C  
ATOM    816  O   ASN A 110      72.160  41.117  73.131  1.00 20.23           O  
ATOM    817  CB  ASN A 110      75.360  41.573  73.948  1.00 16.62           C  
ATOM    818  CG  ASN A 110      76.692  41.999  73.351  1.00 18.15           C  
ATOM    819  OD1 ASN A 110      76.756  42.937  72.544  1.00 16.03           O  
ATOM    820  ND2 ASN A 110      77.765  41.313  73.748  1.00 15.67           N  
ATOM    821  N   VAL A 111      72.592  41.961  75.174  1.00 18.51           N  
ATOM    822  CA  VAL A 111      71.388  41.421  75.805  1.00 16.00           C  
ATOM    823  C   VAL A 111      70.189  42.350  75.642  1.00 19.45           C  
ATOM    824  O   VAL A 111      69.285  42.078  74.843  1.00 20.05           O  
ATOM    825  CB  VAL A 111      71.634  41.189  77.302  1.00 12.54           C  
ATOM    826  CG1 VAL A 111      70.427  40.532  77.944  1.00 11.01           C  
ATOM    827  CG2 VAL A 111      72.870  40.340  77.483  1.00 14.15           C  
ATOM    828  N   SER A 112      70.193  43.447  76.400  1.00 20.67           N  
ATOM    829  CA  SER A 112      69.118  44.440  76.366  1.00 20.34           C  
ATOM    830  C   SER A 112      68.706  44.829  74.947  1.00 19.69           C  
ATOM    831  O   SER A 112      67.518  44.876  74.623  1.00 19.30           O  
ATOM    832  CB  SER A 112      69.554  45.696  77.126  1.00 21.15           C  
ATOM    833  OG  SER A 112      68.600  46.728  76.977  1.00 23.67           O  
ATOM    834  N   GLY A 113      69.692  45.122  74.109  1.00 20.05           N  
ATOM    835  CA  GLY A 113      69.399  45.495  72.736  1.00 20.56           C  
ATOM    836  C   GLY A 113      68.630  44.420  71.987  1.00 20.79           C  
ATOM    837  O   GLY A 113      67.642  44.707  71.309  1.00 21.68           O  
ATOM    838  N   THR A 114      69.075  43.174  72.110  1.00 20.29           N  
ATOM    839  CA  THR A 114      68.411  42.060  71.437  1.00 19.33           C  
ATOM    840  C   THR A 114      66.993  41.848  71.957  1.00 19.05           C  
ATOM    841  O   THR A 114      66.051  41.666  71.177  1.00 18.95           O  
ATOM    842  CB  THR A 114      69.209  40.756  71.620  1.00 19.60           C  
ATOM    843  OG1 THR A 114      70.427  40.840  70.871  1.00 19.37           O  
ATOM    844  CG2 THR A 114      68.398  39.558  71.155  1.00 19.59           C  
ATOM    845  N   LEU A 115      66.839  41.882  73.277  1.00 18.82           N  
ATOM    846  CA  LEU A 115      65.531  41.684  73.883  1.00 19.61           C  
ATOM    847  C   LEU A 115      64.481  42.704  73.460  1.00 20.46           C  
ATOM    848  O   LEU A 115      63.450  42.342  72.887  1.00 21.53           O  
ATOM    849  CB  LEU A 115      65.642  41.686  75.410  1.00 20.85           C  
ATOM    850  CG  LEU A 115      64.307  41.613  76.172  1.00 22.57           C  
ATOM    851  CD1 LEU A 115      63.501  40.393  75.734  1.00 22.28           C  
ATOM    852  CD2 LEU A 115      64.583  41.556  77.662  1.00 23.14           C  
ATOM    853  N   PHE A 116      64.727  43.978  73.740  1.00 20.51           N  
ATOM    854  CA  PHE A 116      63.743  45.007  73.404  1.00 20.87           C  
ATOM    855  C   PHE A 116      63.537  45.210  71.912  1.00 20.41           C  
ATOM    856  O   PHE A 116      62.473  45.660  71.481  1.00 20.80           O  
ATOM    857  CB  PHE A 116      64.094  46.316  74.125  1.00 18.66           C  
ATOM    858  CG  PHE A 116      64.007  46.193  75.621  1.00 15.88           C  
ATOM    859  CD1 PHE A 116      62.772  46.044  76.243  1.00 14.86           C  
ATOM    860  CD2 PHE A 116      65.158  46.090  76.392  1.00 16.05           C  
ATOM    861  CE1 PHE A 116      62.686  45.779  77.611  1.00 16.33           C  
ATOM    862  CE2 PHE A 116      65.080  45.827  77.757  1.00 15.00           C  
ATOM    863  CZ  PHE A 116      63.844  45.670  78.367  1.00 13.88           C  
ATOM    864  N   MET A 117      64.542  44.858  71.119  1.00 21.77           N  
ATOM    865  CA  MET A 117      64.417  44.970  69.670  1.00 22.20           C  
ATOM    866  C   MET A 117      63.449  43.847  69.252  1.00 21.64           C  
ATOM    867  O   MET A 117      62.606  44.030  68.377  1.00 21.47           O  
ATOM    868  CB  MET A 117      65.788  44.795  69.020  1.00 23.05           C  
ATOM    869  CG  MET A 117      65.919  45.386  67.628  1.00 28.50           C  
ATOM    870  SD  MET A 117      65.730  47.195  67.530  1.00 29.23           S  
ATOM    871  CE  MET A 117      64.408  47.290  66.368  1.00 28.57           C  
ATOM    872  N   MET A 118      63.561  42.690  69.904  1.00 22.05           N  
ATOM    873  CA  MET A 118      62.677  41.556  69.632  1.00 22.31           C  
ATOM    874  C   MET A 118      61.251  41.939  70.003  1.00 23.71           C  
ATOM    875  O   MET A 118      60.294  41.674  69.267  1.00 23.35           O  
ATOM    876  CB  MET A 118      63.055  40.339  70.483  1.00 20.90           C  
ATOM    877  CG  MET A 118      63.908  39.282  69.809  1.00 23.11           C  
ATOM    878  SD  MET A 118      63.709  37.676  70.650  1.00 22.63           S  
ATOM    879  CE  MET A 118      64.552  37.968  72.195  1.00 23.25           C  
ATOM    880  N   GLN A 119      61.117  42.548  71.175  1.00 25.13           N  
ATOM    881  CA  GLN A 119      59.817  42.950  71.677  1.00 25.60           C  
ATOM    882  C   GLN A 119      59.142  43.951  70.750  1.00 25.48           C  
ATOM    883  O   GLN A 119      57.958  43.825  70.443  1.00 25.67           O  
ATOM    884  CB  GLN A 119      59.978  43.548  73.064  1.00 26.26           C  
ATOM    885  CG  GLN A 119      58.675  43.852  73.763  1.00 27.78           C  
ATOM    886  CD  GLN A 119      58.891  44.725  74.975  1.00 26.91           C  
ATOM    887  OE1 GLN A 119      59.392  45.845  74.857  1.00 26.42           O  
ATOM    888  NE2 GLN A 119      58.529  44.216  76.148  1.00 24.18           N  
ATOM    889  N   ALA A 120      59.897  44.942  70.297  1.00 25.78           N  
ATOM    890  CA  ALA A 120      59.343  45.945  69.402  1.00 27.01           C  
ATOM    891  C   ALA A 120      58.822  45.322  68.097  1.00 28.88           C  
ATOM    892  O   ALA A 120      57.679  45.561  67.699  1.00 29.66           O  
ATOM    893  CB  ALA A 120      60.394  46.991  69.101  1.00 27.01           C  
ATOM    894  N   VAL A 121      59.660  44.523  67.435  1.00 29.43           N  
ATOM    895  CA  VAL A 121      59.275  43.874  66.176  1.00 28.82           C  
ATOM    896  C   VAL A 121      58.172  42.824  66.367  1.00 28.60           C  
ATOM    897  O   VAL A 121      57.239  42.738  65.570  1.00 28.22           O  
ATOM    898  CB  VAL A 121      60.494  43.206  65.502  1.00 28.69           C  
ATOM    899  CG1 VAL A 121      60.042  42.365  64.329  1.00 28.19           C  
ATOM    900  CG2 VAL A 121      61.478  44.272  65.035  1.00 26.94           C  
ATOM    901  N   ALA A 122      58.279  42.030  67.424  1.00 28.03           N  
ATOM    902  CA  ALA A 122      57.275  41.012  67.697  1.00 28.61           C  
ATOM    903  C   ALA A 122      55.885  41.637  67.849  1.00 29.97           C  
ATOM    904  O   ALA A 122      54.891  41.081  67.364  1.00 28.96           O  
ATOM    905  CB  ALA A 122      57.642  40.245  68.959  1.00 27.15           C  
ATOM    906  N   ARG A 123      55.814  42.783  68.527  1.00 29.83           N  
ATOM    907  CA  ARG A 123      54.532  43.456  68.727  1.00 30.06           C  
ATOM    908  C   ARG A 123      53.934  43.857  67.392  1.00 29.11           C  
ATOM    909  O   ARG A 123      52.722  43.772  67.201  1.00 28.37           O  
ATOM    910  CB  ARG A 123      54.677  44.684  69.647  1.00 31.03           C  
ATOM    911  CG  ARG A 123      54.557  44.326  71.130  1.00 33.90           C  
ATOM    912  CD  ARG A 123      54.356  45.528  72.060  1.00 35.16           C  
ATOM    913  NE  ARG A 123      55.590  46.262  72.335  1.00 37.11           N  
ATOM    914  CZ  ARG A 123      55.953  46.685  73.545  1.00 37.79           C  
ATOM    915  NH1 ARG A 123      55.180  46.443  74.598  1.00 36.14           N  
ATOM    916  NH2 ARG A 123      57.087  47.359  73.705  1.00 38.09           N  
ATOM    917  N   ALA A 124      54.791  44.281  66.466  1.00 28.70           N  
ATOM    918  CA  ALA A 124      54.337  44.671  65.136  1.00 28.61           C  
ATOM    919  C   ALA A 124      53.841  43.439  64.374  1.00 29.37           C  
ATOM    920  O   ALA A 124      52.764  43.463  63.781  1.00 29.55           O  
ATOM    921  CB  ALA A 124      55.469  45.336  64.368  1.00 25.88           C  
ATOM    922  N   MET A 125      54.628  42.365  64.404  1.00 28.86           N  
ATOM    923  CA  MET A 125      54.264  41.137  63.706  1.00 29.90           C  
ATOM    924  C   MET A 125      52.930  40.599  64.188  1.00 30.75           C  
ATOM    925  O   MET A 125      52.084  40.210  63.387  1.00 32.33           O  
ATOM    926  CB  MET A 125      55.359  40.076  63.882  1.00 27.85           C  
ATOM    927  CG  MET A 125      56.620  40.414  63.120  1.00 26.04           C  
ATOM    928  SD  MET A 125      58.036  39.383  63.513  1.00 29.91           S  
ATOM    929  CE  MET A 125      59.217  39.952  62.254  1.00 24.28           C  
ATOM    930  N   ILE A 126      52.732  40.578  65.498  1.00 32.14           N  
ATOM    931  CA  ILE A 126      51.477  40.091  66.040  1.00 33.78           C  
ATOM    932  C   ILE A 126      50.318  40.899  65.449  1.00 35.78           C  
ATOM    933  O   ILE A 126      49.310  40.337  65.015  1.00 36.73           O  
ATOM    934  CB  ILE A 126      51.480  40.181  67.582  1.00 33.34           C  
ATOM    935  CG1 ILE A 126      52.591  39.279  68.131  1.00 33.90           C  
ATOM    936  CG2 ILE A 126      50.119  39.773  68.140  1.00 32.20           C  
ATOM    937  CD1 ILE A 126      52.702  39.237  69.631  1.00 32.43           C  
ATOM    938  N   ALA A 127      50.477  42.220  65.416  1.00 38.03           N  
ATOM    939  CA  ALA A 127      49.456  43.105  64.865  1.00 38.24           C  
ATOM    940  C   ALA A 127      49.274  42.805  63.383  1.00 38.06           C  
ATOM    941  O   ALA A 127      48.152  42.718  62.896  1.00 38.38           O  
ATOM    942  CB  ALA A 127      49.861  44.564  65.062  1.00 38.48           C  
ATOM    943  N   GLY A 128      50.387  42.645  62.674  1.00 39.05           N  
ATOM    944  CA  GLY A 128      50.329  42.338  61.255  1.00 39.65           C  
ATOM    945  C   GLY A 128      49.455  41.126  60.965  1.00 41.06           C  
ATOM    946  O   GLY A 128      48.827  41.045  59.912  1.00 42.05           O  
ATOM    947  N   GLY A 129      49.418  40.177  61.895  1.00 40.32           N  
ATOM    948  CA  GLY A 129      48.590  39.001  61.711  1.00 40.33           C  
ATOM    949  C   GLY A 129      49.099  37.928  60.763  1.00 40.71           C  
ATOM    950  O   GLY A 129      48.360  36.998  60.442  1.00 40.37           O  
ATOM    951  N   ARG A 130      50.342  38.036  60.305  1.00 40.56           N  
ATOM    952  CA  ARG A 130      50.878  37.024  59.401  1.00 39.75           C  
ATOM    953  C   ARG A 130      52.277  36.525  59.791  1.00 37.42           C  
ATOM    954  O   ARG A 130      53.125  36.266  58.935  1.00 35.99           O  
ATOM    955  CB  ARG A 130      50.859  37.547  57.958  1.00 41.96           C  
ATOM    956  CG  ARG A 130      51.633  38.827  57.726  1.00 45.95           C  
ATOM    957  CD  ARG A 130      51.022  39.623  56.584  1.00 48.73           C  
ATOM    958  NE  ARG A 130      51.961  40.593  56.030  1.00 53.36           N  
ATOM    959  CZ  ARG A 130      52.991  40.271  55.251  1.00 55.86           C  
ATOM    960  NH1 ARG A 130      53.216  39.000  54.928  1.00 56.76           N  
ATOM    961  NH2 ARG A 130      53.798  41.219  54.789  1.00 56.58           N  
ATOM    962  N   GLY A 131      52.489  36.389  61.099  1.00 34.51           N  
ATOM    963  CA  GLY A 131      53.751  35.900  61.632  1.00 31.01           C  
ATOM    964  C   GLY A 131      55.014  36.602  61.173  1.00 28.67           C  
ATOM    965  O   GLY A 131      54.980  37.755  60.746  1.00 28.29           O  
ATOM    966  N   GLY A 132      56.136  35.891  61.270  1.00 26.33           N  
ATOM    967  CA  GLY A 132      57.413  36.442  60.858  1.00 23.68           C  
ATOM    968  C   GLY A 132      58.572  35.584  61.327  1.00 22.44           C  
ATOM    969  O   GLY A 132      58.374  34.568  61.993  1.00 21.64           O  
ATOM    970  N   LYS A 133      59.786  35.994  60.975  1.00 21.27           N  
ATOM    971  CA  LYS A 133      60.988  35.270  61.365  1.00 21.71           C  
ATOM    972  C   LYS A 133      61.948  36.170  62.145  1.00 21.26           C  
ATOM    973  O   LYS A 133      62.208  37.308  61.747  1.00 20.38           O  
ATOM    974  CB  LYS A 133      61.728  34.747  60.126  1.00 23.68           C  
ATOM    975  CG  LYS A 133      60.927  33.840  59.200  1.00 24.24           C  
ATOM    976  CD  LYS A 133      60.624  32.507  59.851  1.00 24.24           C  
ATOM    977  CE  LYS A 133      59.970  31.557  58.867  1.00 21.90           C  
ATOM    978  NZ  LYS A 133      59.640  30.282  59.557  1.00 24.56           N  
ATOM    979  N   ILE A 134      62.477  35.659  63.251  1.00 20.43           N  
ATOM    980  CA  ILE A 134      63.442  36.414  64.044  1.00 20.62           C  
ATOM    981  C   ILE A 134      64.666  35.548  64.257  1.00 20.28           C  
ATOM    982  O   ILE A 134      64.564  34.413  64.731  1.00 20.31           O  
ATOM    983  CB  ILE A 134      62.890  36.833  65.440  1.00 21.36           C  
ATOM    984  CG1 ILE A 134      61.768  37.856  65.279  1.00 18.16           C  
ATOM    985  CG2 ILE A 134      64.012  37.460  66.276  1.00 19.10           C  
ATOM    986  CD1 ILE A 134      61.039  38.157  66.557  1.00 22.19           C  
ATOM    987  N   ILE A 135      65.824  36.090  63.905  1.00 20.25           N  
ATOM    988  CA  ILE A 135      67.075  35.370  64.055  1.00 19.84           C  
ATOM    989  C   ILE A 135      68.028  36.145  64.951  1.00 19.85           C  
ATOM    990  O   ILE A 135      68.365  37.293  64.657  1.00 20.82           O  
ATOM    991  CB  ILE A 135      67.757  35.165  62.691  1.00 20.63           C  
ATOM    992  CG1 ILE A 135      66.803  34.449  61.740  1.00 21.25           C  
ATOM    993  CG2 ILE A 135      69.042  34.379  62.862  1.00 16.92           C  
ATOM    994  CD1 ILE A 135      67.329  34.356  60.326  1.00 22.38           C  
ATOM    995  N   ASN A 136      68.456  35.524  66.046  1.00 19.12           N  
ATOM    996  CA  ASN A 136      69.397  36.167  66.950  1.00 19.66           C  
ATOM    997  C   ASN A 136      70.782  35.633  66.679  1.00 19.41           C  
ATOM    998  O   ASN A 136      70.940  34.519  66.196  1.00 22.83           O  
ATOM    999  CB  ASN A 136      69.037  35.907  68.413  1.00 18.43           C  
ATOM   1000  CG  ASN A 136      67.684  36.455  68.775  1.00 20.02           C  
ATOM   1001  OD1 ASN A 136      67.257  37.477  68.226  1.00 18.24           O  
ATOM   1002  ND2 ASN A 136      66.997  35.789  69.704  1.00 15.50           N  
ATOM   1003  N   MET A 137      71.785  36.438  66.985  1.00 18.84           N  
ATOM   1004  CA  MET A 137      73.157  36.033  66.782  1.00 19.71           C  
ATOM   1005  C   MET A 137      73.823  35.723  68.118  1.00 20.72           C  
ATOM   1006  O   MET A 137      74.146  36.624  68.900  1.00 23.43           O  
ATOM   1007  CB  MET A 137      73.929  37.137  66.059  1.00 20.02           C  
ATOM   1008  CG  MET A 137      73.521  37.341  64.605  1.00 23.09           C  
ATOM   1009  SD  MET A 137      73.909  35.912  63.544  1.00 22.73           S  
ATOM   1010  CE  MET A 137      75.671  36.119  63.351  1.00 23.85           C  
ATOM   1011  N   ALA A 138      74.003  34.441  68.393  1.00 18.57           N  
ATOM   1012  CA  ALA A 138      74.659  34.036  69.620  1.00 18.03           C  
ATOM   1013  C   ALA A 138      76.126  33.892  69.250  1.00 17.33           C  
ATOM   1014  O   ALA A 138      76.663  34.713  68.503  1.00 17.16           O  
ATOM   1015  CB  ALA A 138      74.089  32.708  70.122  1.00 16.15           C  
ATOM   1016  N   SER A 139      76.764  32.841  69.747  1.00 16.62           N  
ATOM   1017  CA  SER A 139      78.178  32.605  69.473  1.00 16.28           C  
ATOM   1018  C   SER A 139      78.645  31.431  70.307  1.00 15.83           C  
ATOM   1019  O   SER A 139      78.035  31.105  71.324  1.00 15.25           O  
ATOM   1020  CB  SER A 139      79.005  33.839  69.845  1.00 16.49           C  
ATOM   1021  OG  SER A 139      80.287  33.472  70.341  1.00 17.38           O  
ATOM   1022  N   GLN A 140      79.727  30.795  69.881  1.00 16.70           N  
ATOM   1023  CA  GLN A 140      80.258  29.672  70.635  1.00 19.84           C  
ATOM   1024  C   GLN A 140      80.522  30.110  72.078  1.00 19.01           C  
ATOM   1025  O   GLN A 140      80.446  29.305  73.009  1.00 17.76           O  
ATOM   1026  CB  GLN A 140      81.562  29.178  70.007  1.00 22.44           C  
ATOM   1027  CG  GLN A 140      82.654  30.226  69.928  1.00 26.33           C  
ATOM   1028  CD  GLN A 140      83.994  29.633  69.528  1.00 30.24           C  
ATOM   1029  OE1 GLN A 140      84.097  28.942  68.512  1.00 30.88           O  
ATOM   1030  NE2 GLN A 140      85.033  29.900  70.327  1.00 30.11           N  
ATOM   1031  N   ALA A 141      80.832  31.394  72.251  1.00 19.37           N  
ATOM   1032  CA  ALA A 141      81.122  31.940  73.577  1.00 18.60           C  
ATOM   1033  C   ALA A 141      79.941  31.747  74.516  1.00 17.25           C  
ATOM   1034  O   ALA A 141      80.124  31.592  75.721  1.00 14.43           O  
ATOM   1035  CB  ALA A 141      81.472  33.411  73.472  1.00 17.72           C  
ATOM   1036  N   GLY A 142      78.737  31.739  73.952  1.00 17.68           N  
ATOM   1037  CA  GLY A 142      77.542  31.559  74.754  1.00 18.97           C  
ATOM   1038  C   GLY A 142      77.249  30.121  75.147  1.00 20.14           C  
ATOM   1039  O   GLY A 142      76.291  29.873  75.880  1.00 19.86           O  
ATOM   1040  N   ARG A 143      78.066  29.182  74.668  1.00 21.05           N  
ATOM   1041  CA  ARG A 143      77.890  27.754  74.958  1.00 20.57           C  
ATOM   1042  C   ARG A 143      78.660  27.323  76.196  1.00 21.89           C  
ATOM   1043  O   ARG A 143      78.203  26.468  76.948  1.00 24.11           O  
ATOM   1044  CB  ARG A 143      78.363  26.901  73.777  1.00 19.46           C  
ATOM   1045  CG  ARG A 143      77.576  27.084  72.487  1.00 18.05           C  
ATOM   1046  CD  ARG A 143      76.166  26.520  72.595  1.00 16.48           C  
ATOM   1047  NE  ARG A 143      75.557  26.373  71.277  1.00 17.15           N  
ATOM   1048  CZ  ARG A 143      74.314  25.954  71.060  1.00 15.24           C  
ATOM   1049  NH1 ARG A 143      73.864  25.855  69.821  1.00 15.49           N  
ATOM   1050  NH2 ARG A 143      73.521  25.641  72.074  1.00 13.65           N  
ATOM   1051  N   ARG A 144      79.841  27.903  76.389  1.00 22.09           N  
ATOM   1052  CA  ARG A 144      80.676  27.586  77.543  1.00 21.38           C  
ATOM   1053  C   ARG A 144      81.489  28.813  77.942  1.00 21.68           C  
ATOM   1054  O   ARG A 144      81.872  29.617  77.094  1.00 20.35           O  
ATOM   1055  CB  ARG A 144      81.628  26.418  77.227  1.00 22.18           C  
ATOM   1056  CG  ARG A 144      82.814  26.756  76.322  1.00 21.83           C  
ATOM   1057  CD  ARG A 144      82.385  27.073  74.899  1.00 25.39           C  
ATOM   1058  NE  ARG A 144      83.464  27.695  74.136  1.00 30.20           N  
ATOM   1059  CZ  ARG A 144      84.050  28.845  74.464  1.00 33.72           C  
ATOM   1060  NH1 ARG A 144      83.666  29.516  75.548  1.00 33.69           N  
ATOM   1061  NH2 ARG A 144      85.028  29.327  73.708  1.00 34.47           N  
ATOM   1062  N   GLY A 145      81.749  28.955  79.237  1.00 22.26           N  
ATOM   1063  CA  GLY A 145      82.512  30.098  79.700  1.00 22.50           C  
ATOM   1064  C   GLY A 145      83.976  29.987  79.332  1.00 24.41           C  
ATOM   1065  O   GLY A 145      84.441  28.908  78.957  1.00 24.30           O  
ATOM   1066  N   GLU A 146      84.689  31.111  79.424  1.00 24.94           N  
ATOM   1067  CA  GLU A 146      86.125  31.199  79.143  1.00 24.35           C  
ATOM   1068  C   GLU A 146      86.773  32.068  80.214  1.00 23.71           C  
ATOM   1069  O   GLU A 146      86.170  33.028  80.698  1.00 23.59           O  
ATOM   1070  CB  GLU A 146      86.391  31.830  77.779  1.00 27.30           C  
ATOM   1071  CG  GLU A 146      86.051  30.960  76.593  1.00 30.94           C  
ATOM   1072  CD  GLU A 146      86.532  31.571  75.292  1.00 34.30           C  
ATOM   1073  OE1 GLU A 146      87.767  31.698  75.124  1.00 34.64           O  
ATOM   1074  OE2 GLU A 146      85.677  31.933  74.447  1.00 36.59           O  
ATOM   1075  N   ALA A 147      88.012  31.743  80.559  1.00 21.29           N  
ATOM   1076  CA  ALA A 147      88.740  32.462  81.595  1.00 20.14           C  
ATOM   1077  C   ALA A 147      88.849  33.977  81.418  1.00 19.98           C  
ATOM   1078  O   ALA A 147      88.636  34.725  82.376  1.00 21.78           O  
ATOM   1079  CB  ALA A 147      90.132  31.861  81.751  1.00 17.96           C  
ATOM   1080  N   LEU A 148      89.170  34.437  80.214  1.00 18.18           N  
ATOM   1081  CA  LEU A 148      89.322  35.871  79.981  1.00 16.96           C  
ATOM   1082  C   LEU A 148      88.172  36.532  79.230  1.00 16.48           C  
ATOM   1083  O   LEU A 148      88.314  37.660  78.762  1.00 16.83           O  
ATOM   1084  CB  LEU A 148      90.614  36.138  79.206  1.00 16.32           C  
ATOM   1085  CG  LEU A 148      91.901  35.489  79.708  1.00 16.15           C  
ATOM   1086  CD1 LEU A 148      93.034  35.880  78.787  1.00 16.30           C  
ATOM   1087  CD2 LEU A 148      92.194  35.925  81.130  1.00 16.62           C  
ATOM   1088  N   VAL A 149      87.037  35.853  79.103  1.00 16.80           N  
ATOM   1089  CA  VAL A 149      85.915  36.438  78.361  1.00 16.61           C  
ATOM   1090  C   VAL A 149      84.595  36.336  79.115  1.00 16.36           C  
ATOM   1091  O   VAL A 149      83.524  36.211  78.509  1.00 16.06           O  
ATOM   1092  CB  VAL A 149      85.745  35.750  76.974  1.00 17.74           C  
ATOM   1093  CG1 VAL A 149      84.925  36.639  76.051  1.00 15.17           C  
ATOM   1094  CG2 VAL A 149      87.114  35.446  76.362  1.00 13.64           C  
ATOM   1095  N   GLY A 150      84.688  36.399  80.440  1.00 15.60           N  
ATOM   1096  CA  GLY A 150      83.514  36.304  81.288  1.00 14.75           C  
ATOM   1097  C   GLY A 150      82.317  37.142  80.890  1.00 15.37           C  
ATOM   1098  O   GLY A 150      81.218  36.596  80.726  1.00 15.20           O  
ATOM   1099  N   VAL A 151      82.511  38.455  80.732  1.00 14.19           N  
ATOM   1100  CA  VAL A 151      81.403  39.346  80.379  1.00 14.53           C  
ATOM   1101  C   VAL A 151      80.788  39.046  79.025  1.00 14.06           C  
ATOM   1102  O   VAL A 151      79.574  38.932  78.914  1.00 17.92           O  
ATOM   1103  CB  VAL A 151      81.828  40.841  80.406  1.00 16.19           C  
ATOM   1104  CG1 VAL A 151      80.663  41.729  79.981  1.00 14.78           C  
ATOM   1105  CG2 VAL A 151      82.281  41.231  81.803  1.00 15.99           C  
ATOM   1106  N   TYR A 152      81.609  38.922  77.988  1.00 15.98           N  
ATOM   1107  CA  TYR A 152      81.080  38.623  76.655  1.00 17.81           C  
ATOM   1108  C   TYR A 152      80.309  37.288  76.648  1.00 16.55           C  
ATOM   1109  O   TYR A 152      79.176  37.221  76.168  1.00 13.34           O  
ATOM   1110  CB  TYR A 152      82.212  38.568  75.625  1.00 18.53           C  
ATOM   1111  CG  TYR A 152      81.735  38.251  74.222  1.00 21.15           C  
ATOM   1112  CD1 TYR A 152      80.979  39.174  73.499  1.00 20.27           C  
ATOM   1113  CD2 TYR A 152      82.030  37.020  73.618  1.00 19.65           C  
ATOM   1114  CE1 TYR A 152      80.530  38.887  72.212  1.00 21.19           C  
ATOM   1115  CE2 TYR A 152      81.580  36.721  72.330  1.00 17.35           C  
ATOM   1116  CZ  TYR A 152      80.835  37.658  71.636  1.00 21.77           C  
ATOM   1117  OH  TYR A 152      80.396  37.386  70.359  1.00 22.64           O  
ATOM   1118  N   CYS A 153      80.934  36.244  77.197  1.00 15.84           N  
ATOM   1119  CA  CYS A 153      80.326  34.918  77.267  1.00 16.54           C  
ATOM   1120  C   CYS A 153      78.960  34.956  77.916  1.00 16.71           C  
ATOM   1121  O   CYS A 153      78.008  34.364  77.403  1.00 18.01           O  
ATOM   1122  CB  CYS A 153      81.215  33.957  78.056  1.00 15.99           C  
ATOM   1123  SG  CYS A 153      82.659  33.351  77.151  1.00 17.20           S  
ATOM   1124  N   ALA A 154      78.864  35.660  79.041  1.00 17.44           N  
ATOM   1125  CA  ALA A 154      77.607  35.769  79.778  1.00 15.73           C  
ATOM   1126  C   ALA A 154      76.515  36.441  78.969  1.00 14.77           C  
ATOM   1127  O   ALA A 154      75.345  36.116  79.133  1.00 15.79           O  
ATOM   1128  CB  ALA A 154      77.822  36.515  81.090  1.00 16.69           C  
ATOM   1129  N   THR A 155      76.877  37.379  78.098  1.00 14.37           N  
ATOM   1130  CA  THR A 155      75.854  38.041  77.293  1.00 14.85           C  
ATOM   1131  C   THR A 155      75.330  37.072  76.243  1.00 15.17           C  
ATOM   1132  O   THR A 155      74.129  37.028  75.951  1.00 15.78           O  
ATOM   1133  CB  THR A 155      76.394  39.284  76.562  1.00 15.92           C  
ATOM   1134  OG1 THR A 155      77.360  38.877  75.581  1.00 12.15           O  
ATOM   1135  CG2 THR A 155      77.031  40.262  77.559  1.00 13.53           C  
ATOM   1136  N   LYS A 156      76.231  36.289  75.667  1.00 16.19           N  
ATOM   1137  CA  LYS A 156      75.813  35.342  74.652  1.00 17.27           C  
ATOM   1138  C   LYS A 156      74.975  34.219  75.246  1.00 16.60           C  
ATOM   1139  O   LYS A 156      73.999  33.779  74.634  1.00 15.42           O  
ATOM   1140  CB  LYS A 156      77.027  34.819  73.898  1.00 18.41           C  
ATOM   1141  CG  LYS A 156      77.649  35.903  73.011  1.00 19.98           C  
ATOM   1142  CD  LYS A 156      76.587  36.564  72.132  1.00 19.81           C  
ATOM   1143  CE  LYS A 156      77.214  37.541  71.153  1.00 25.05           C  
ATOM   1144  NZ  LYS A 156      76.196  38.228  70.298  1.00 26.40           N  
ATOM   1145  N   ALA A 157      75.323  33.779  76.451  1.00 15.12           N  
ATOM   1146  CA  ALA A 157      74.533  32.737  77.094  1.00 16.09           C  
ATOM   1147  C   ALA A 157      73.111  33.273  77.278  1.00 16.14           C  
ATOM   1148  O   ALA A 157      72.129  32.548  77.101  1.00 17.97           O  
ATOM   1149  CB  ALA A 157      75.137  32.362  78.440  1.00 14.14           C  
ATOM   1150  N   ALA A 158      73.005  34.552  77.624  1.00 15.79           N  
ATOM   1151  CA  ALA A 158      71.704  35.184  77.820  1.00 14.27           C  
ATOM   1152  C   ALA A 158      70.910  35.236  76.514  1.00 12.98           C  
ATOM   1153  O   ALA A 158      69.686  35.075  76.508  1.00 11.65           O  
ATOM   1154  CB  ALA A 158      71.885  36.588  78.373  1.00 13.63           C  
ATOM   1155  N   VAL A 159      71.602  35.473  75.407  1.00 14.09           N  
ATOM   1156  CA  VAL A 159      70.937  35.537  74.112  1.00 15.94           C  
ATOM   1157  C   VAL A 159      70.314  34.191  73.770  1.00 16.91           C  
ATOM   1158  O   VAL A 159      69.195  34.123  73.243  1.00 18.62           O  
ATOM   1159  CB  VAL A 159      71.924  35.907  72.997  1.00 19.36           C  
ATOM   1160  CG1 VAL A 159      71.295  35.626  71.624  1.00 17.95           C  
ATOM   1161  CG2 VAL A 159      72.315  37.367  73.128  1.00 16.29           C  
ATOM   1162  N   ILE A 160      71.047  33.122  74.068  1.00 15.23           N  
ATOM   1163  CA  ILE A 160      70.567  31.778  73.804  1.00 15.18           C  
ATOM   1164  C   ILE A 160      69.324  31.535  74.649  1.00 16.04           C  
ATOM   1165  O   ILE A 160      68.319  30.993  74.167  1.00 16.42           O  
ATOM   1166  CB  ILE A 160      71.668  30.728  74.122  1.00 14.97           C  
ATOM   1167  CG1 ILE A 160      72.759  30.799  73.044  1.00 11.63           C  
ATOM   1168  CG2 ILE A 160      71.070  29.327  74.209  1.00 13.25           C  
ATOM   1169  CD1 ILE A 160      73.917  29.875  73.277  1.00  9.69           C  
ATOM   1170  N   SER A 161      69.386  31.963  75.907  1.00 16.35           N  
ATOM   1171  CA  SER A 161      68.252  31.796  76.816  1.00 16.15           C  
ATOM   1172  C   SER A 161      67.021  32.551  76.312  1.00 15.16           C  
ATOM   1173  O   SER A 161      65.913  32.005  76.277  1.00 16.17           O  
ATOM   1174  CB  SER A 161      68.622  32.282  78.219  1.00 15.04           C  
ATOM   1175  OG  SER A 161      67.530  32.122  79.105  1.00 16.19           O  
ATOM   1176  N   LEU A 162      67.217  33.804  75.914  1.00 14.13           N  
ATOM   1177  CA  LEU A 162      66.116  34.618  75.412  1.00 15.33           C  
ATOM   1178  C   LEU A 162      65.515  34.064  74.115  1.00 16.38           C  
ATOM   1179  O   LEU A 162      64.312  34.208  73.866  1.00 16.59           O  
ATOM   1180  CB  LEU A 162      66.593  36.053  75.191  1.00 16.85           C  
ATOM   1181  CG  LEU A 162      66.961  36.834  76.459  1.00 17.26           C  
ATOM   1182  CD1 LEU A 162      67.619  38.138  76.070  1.00 16.81           C  
ATOM   1183  CD2 LEU A 162      65.718  37.082  77.287  1.00 13.61           C  
ATOM   1184  N   THR A 163      66.352  33.445  73.284  1.00 16.75           N  
ATOM   1185  CA  THR A 163      65.881  32.863  72.025  1.00 17.10           C  
ATOM   1186  C   THR A 163      64.911  31.716  72.334  1.00 16.30           C  
ATOM   1187  O   THR A 163      63.881  31.549  71.669  1.00 17.26           O  
ATOM   1188  CB  THR A 163      67.062  32.327  71.177  1.00 19.11           C  
ATOM   1189  OG1 THR A 163      67.925  33.410  70.805  1.00 19.02           O  
ATOM   1190  CG2 THR A 163      66.553  31.657  69.919  1.00 20.19           C  
ATOM   1191  N   GLN A 164      65.226  30.935  73.360  1.00 15.12           N  
ATOM   1192  CA  GLN A 164      64.359  29.828  73.740  1.00 15.44           C  
ATOM   1193  C   GLN A 164      63.053  30.344  74.330  1.00 15.95           C  
ATOM   1194  O   GLN A 164      61.967  29.891  73.955  1.00 16.78           O  
ATOM   1195  CB  GLN A 164      65.059  28.934  74.758  1.00 14.78           C  
ATOM   1196  CG  GLN A 164      66.421  28.481  74.309  1.00 15.84           C  
ATOM   1197  CD  GLN A 164      67.104  27.622  75.342  1.00 19.19           C  
ATOM   1198  OE1 GLN A 164      66.846  27.754  76.541  1.00 20.32           O  
ATOM   1199  NE2 GLN A 164      67.998  26.751  74.891  1.00 16.87           N  
ATOM   1200  N   SER A 165      63.153  31.300  75.251  1.00 16.16           N  
ATOM   1201  CA  SER A 165      61.959  31.856  75.876  1.00 14.84           C  
ATOM   1202  C   SER A 165      61.071  32.547  74.852  1.00 12.80           C  
ATOM   1203  O   SER A 165      59.859  32.325  74.820  1.00 13.05           O  
ATOM   1204  CB  SER A 165      62.341  32.842  76.982  1.00 15.53           C  
ATOM   1205  OG  SER A 165      63.104  32.193  77.982  1.00 15.44           O  
ATOM   1206  N   ALA A 166      61.664  33.381  74.010  1.00 11.66           N  
ATOM   1207  CA  ALA A 166      60.872  34.074  73.001  1.00 13.41           C  
ATOM   1208  C   ALA A 166      60.289  33.042  72.048  1.00 16.14           C  
ATOM   1209  O   ALA A 166      59.109  33.105  71.707  1.00 18.02           O  
ATOM   1210  CB  ALA A 166      61.739  35.078  72.232  1.00 11.62           C  
ATOM   1211  N   GLY A 167      61.122  32.084  71.641  1.00 17.23           N  
ATOM   1212  CA  GLY A 167      60.693  31.047  70.723  1.00 18.65           C  
ATOM   1213  C   GLY A 167      59.440  30.310  71.148  1.00 19.67           C  
ATOM   1214  O   GLY A 167      58.490  30.194  70.374  1.00 20.49           O  
ATOM   1215  N   LEU A 168      59.429  29.805  72.376  1.00 19.99           N  
ATOM   1216  CA  LEU A 168      58.272  29.079  72.885  1.00 21.31           C  
ATOM   1217  C   LEU A 168      57.057  29.991  73.032  1.00 23.15           C  
ATOM   1218  O   LEU A 168      55.917  29.566  72.825  1.00 24.54           O  
ATOM   1219  CB  LEU A 168      58.588  28.465  74.252  1.00 19.65           C  
ATOM   1220  CG  LEU A 168      59.758  27.481  74.353  1.00 23.11           C  
ATOM   1221  CD1 LEU A 168      60.002  27.144  75.817  1.00 21.84           C  
ATOM   1222  CD2 LEU A 168      59.463  26.216  73.552  1.00 22.24           C  
ATOM   1223  N   ASN A 169      57.310  31.250  73.383  1.00 24.02           N  
ATOM   1224  CA  ASN A 169      56.242  32.217  73.607  1.00 23.10           C  
ATOM   1225  C   ASN A 169      55.646  32.817  72.350  1.00 22.53           C  
ATOM   1226  O   ASN A 169      54.450  33.074  72.296  1.00 22.07           O  
ATOM   1227  CB  ASN A 169      56.745  33.345  74.522  1.00 23.60           C  
ATOM   1228  CG  ASN A 169      55.652  34.338  74.889  1.00 22.75           C  
ATOM   1229  OD1 ASN A 169      54.567  33.955  75.315  1.00 22.50           O  
ATOM   1230  ND2 ASN A 169      55.943  35.617  74.731  1.00 22.50           N  
ATOM   1231  N   LEU A 170      56.467  33.019  71.329  1.00 22.86           N  
ATOM   1232  CA  LEU A 170      55.975  33.638  70.107  1.00 23.51           C  
ATOM   1233  C   LEU A 170      55.526  32.722  68.973  1.00 24.90           C  
ATOM   1234  O   LEU A 170      54.863  33.181  68.041  1.00 23.81           O  
ATOM   1235  CB  LEU A 170      57.026  34.614  69.573  1.00 23.37           C  
ATOM   1236  CG  LEU A 170      57.361  35.804  70.480  1.00 22.33           C  
ATOM   1237  CD1 LEU A 170      58.287  36.751  69.752  1.00 19.90           C  
ATOM   1238  CD2 LEU A 170      56.082  36.528  70.874  1.00 22.34           C  
ATOM   1239  N   ILE A 171      55.875  31.437  69.041  1.00 25.65           N  
ATOM   1240  CA  ILE A 171      55.499  30.513  67.979  1.00 25.81           C  
ATOM   1241  C   ILE A 171      53.986  30.401  67.789  1.00 27.43           C  
ATOM   1242  O   ILE A 171      53.523  30.092  66.694  1.00 27.46           O  
ATOM   1243  CB  ILE A 171      56.089  29.099  68.212  1.00 24.70           C  
ATOM   1244  CG1 ILE A 171      55.820  28.222  66.987  1.00 22.26           C  
ATOM   1245  CG2 ILE A 171      55.478  28.464  69.448  1.00 23.61           C  
ATOM   1246  CD1 ILE A 171      56.415  28.769  65.708  1.00 18.76           C  
ATOM   1247  N   ARG A 172      53.223  30.664  68.847  1.00 29.18           N  
ATOM   1248  CA  ARG A 172      51.762  30.593  68.786  1.00 30.92           C  
ATOM   1249  C   ARG A 172      51.219  31.656  67.830  1.00 29.99           C  
ATOM   1250  O   ARG A 172      50.127  31.516  67.299  1.00 29.53           O  
ATOM   1251  CB  ARG A 172      51.144  30.813  70.178  1.00 35.19           C  
ATOM   1252  CG  ARG A 172      52.043  30.426  71.367  1.00 43.55           C  
ATOM   1253  CD  ARG A 172      52.472  28.958  71.319  1.00 50.59           C  
ATOM   1254  NE  ARG A 172      53.328  28.564  72.442  1.00 55.89           N  
ATOM   1255  CZ  ARG A 172      52.907  28.400  73.695  1.00 59.21           C  
ATOM   1256  NH1 ARG A 172      51.628  28.598  74.002  1.00 60.66           N  
ATOM   1257  NH2 ARG A 172      53.764  28.025  74.641  1.00 59.15           N  
ATOM   1258  N   HIS A 173      51.980  32.726  67.621  1.00 30.06           N  
ATOM   1259  CA  HIS A 173      51.555  33.801  66.729  1.00 29.38           C  
ATOM   1260  C   HIS A 173      52.166  33.648  65.352  1.00 28.54           C  
ATOM   1261  O   HIS A 173      52.069  34.551  64.522  1.00 29.83           O  
ATOM   1262  CB  HIS A 173      51.949  35.175  67.288  1.00 30.23           C  
ATOM   1263  CG  HIS A 173      51.268  35.520  68.573  1.00 31.94           C  
ATOM   1264  ND1 HIS A 173      51.863  35.335  69.804  1.00 33.73           N  
ATOM   1265  CD2 HIS A 173      50.025  35.996  68.824  1.00 31.84           C  
ATOM   1266  CE1 HIS A 173      51.016  35.678  70.756  1.00 34.56           C  
ATOM   1267  NE2 HIS A 173      49.892  36.083  70.188  1.00 34.51           N  
ATOM   1268  N   GLY A 174      52.808  32.509  65.118  1.00 27.07           N  
ATOM   1269  CA  GLY A 174      53.421  32.264  63.826  1.00 24.63           C  
ATOM   1270  C   GLY A 174      54.771  32.923  63.661  1.00 23.40           C  
ATOM   1271  O   GLY A 174      55.210  33.184  62.542  1.00 24.50           O  
ATOM   1272  N   ILE A 175      55.436  33.198  64.777  1.00 22.24           N  
ATOM   1273  CA  ILE A 175      56.748  33.826  64.737  1.00 20.63           C  
ATOM   1274  C   ILE A 175      57.800  32.819  65.180  1.00 21.17           C  
ATOM   1275  O   ILE A 175      57.740  32.309  66.302  1.00 20.43           O  
ATOM   1276  CB  ILE A 175      56.831  35.040  65.684  1.00 20.05           C  
ATOM   1277  CG1 ILE A 175      55.741  36.055  65.338  1.00 21.88           C  
ATOM   1278  CG2 ILE A 175      58.202  35.685  65.577  1.00 16.31           C  
ATOM   1279  CD1 ILE A 175      55.667  37.236  66.300  1.00 20.44           C  
ATOM   1280  N   ASN A 176      58.751  32.530  64.293  1.00 20.73           N  
ATOM   1281  CA  ASN A 176      59.828  31.594  64.601  1.00 20.36           C  
ATOM   1282  C   ASN A 176      61.009  32.378  65.133  1.00 18.91           C  
ATOM   1283  O   ASN A 176      61.420  33.370  64.524  1.00 17.94           O  
ATOM   1284  CB  ASN A 176      60.309  30.836  63.353  1.00 20.67           C  
ATOM   1285  CG  ASN A 176      59.237  29.968  62.734  1.00 23.34           C  
ATOM   1286  OD1 ASN A 176      58.396  30.447  61.970  1.00 25.32           O  
ATOM   1287  ND2 ASN A 176      59.258  28.680  63.066  1.00 20.98           N  
ATOM   1288  N   VAL A 177      61.552  31.931  66.258  1.00 15.54           N  
ATOM   1289  CA  VAL A 177      62.719  32.579  66.826  1.00 16.40           C  
ATOM   1290  C   VAL A 177      63.831  31.539  67.014  1.00 15.61           C  
ATOM   1291  O   VAL A 177      63.663  30.560  67.734  1.00 15.59           O  
ATOM   1292  CB  VAL A 177      62.402  33.246  68.200  1.00 18.18           C  
ATOM   1293  CG1 VAL A 177      63.624  34.037  68.686  1.00 15.32           C  
ATOM   1294  CG2 VAL A 177      61.185  34.164  68.079  1.00 15.53           C  
ATOM   1295  N   ASN A 178      64.959  31.751  66.351  1.00 14.59           N  
ATOM   1296  CA  ASN A 178      66.092  30.841  66.456  1.00 16.00           C  
ATOM   1297  C   ASN A 178      67.343  31.708  66.457  1.00 17.44           C  
ATOM   1298  O   ASN A 178      67.260  32.912  66.225  1.00 18.35           O  
ATOM   1299  CB  ASN A 178      66.139  29.885  65.255  1.00 14.42           C  
ATOM   1300  CG  ASN A 178      64.934  28.966  65.184  1.00 13.37           C  
ATOM   1301  OD1 ASN A 178      64.777  28.061  66.002  1.00 11.38           O  
ATOM   1302  ND2 ASN A 178      64.072  29.201  64.205  1.00 11.38           N  
ATOM   1303  N   ALA A 179      68.498  31.101  66.699  1.00 16.81           N  
ATOM   1304  CA  ALA A 179      69.751  31.846  66.711  1.00 17.70           C  
ATOM   1305  C   ALA A 179      70.853  31.094  65.974  1.00 18.08           C  
ATOM   1306  O   ALA A 179      70.778  29.879  65.795  1.00 18.21           O  
ATOM   1307  CB  ALA A 179      70.184  32.117  68.146  1.00 16.58           C  
ATOM   1308  N   ILE A 180      71.871  31.828  65.543  1.00 18.15           N  
ATOM   1309  CA  ILE A 180      73.018  31.239  64.857  1.00 18.35           C  
ATOM   1310  C   ILE A 180      74.212  31.474  65.776  1.00 18.11           C  
ATOM   1311  O   ILE A 180      74.372  32.569  66.303  1.00 20.45           O  
ATOM   1312  CB  ILE A 180      73.294  31.942  63.506  1.00 18.29           C  
ATOM   1313  CG1 ILE A 180      72.104  31.762  62.563  1.00 16.41           C  
ATOM   1314  CG2 ILE A 180      74.565  31.400  62.883  1.00 15.58           C  
ATOM   1315  CD1 ILE A 180      72.221  32.579  61.302  1.00 16.74           C  
ATOM   1316  N   ALA A 181      75.041  30.457  65.983  1.00 17.12           N  
ATOM   1317  CA  ALA A 181      76.203  30.609  66.849  1.00 17.03           C  
ATOM   1318  C   ALA A 181      77.508  30.419  66.084  1.00 18.92           C  
ATOM   1319  O   ALA A 181      77.986  29.299  65.908  1.00 18.45           O  
ATOM   1320  CB  ALA A 181      76.130  29.629  68.007  1.00 15.64           C  
ATOM   1321  N   PRO A 182      78.095  31.526  65.603  1.00 19.68           N  
ATOM   1322  CA  PRO A 182      79.354  31.440  64.859  1.00 19.64           C  
ATOM   1323  C   PRO A 182      80.476  30.962  65.781  1.00 22.18           C  
ATOM   1324  O   PRO A 182      80.319  30.926  67.002  1.00 22.23           O  
ATOM   1325  CB  PRO A 182      79.581  32.879  64.396  1.00 17.46           C  
ATOM   1326  CG  PRO A 182      78.185  33.457  64.324  1.00 17.22           C  
ATOM   1327  CD  PRO A 182      77.542  32.894  65.561  1.00 17.83           C  
ATOM   1328  N   GLY A 183      81.602  30.588  65.194  1.00 24.56           N  
ATOM   1329  CA  GLY A 183      82.734  30.165  65.989  1.00 29.35           C  
ATOM   1330  C   GLY A 183      83.678  31.346  65.989  1.00 33.20           C  
ATOM   1331  O   GLY A 183      83.304  32.447  66.405  1.00 34.83           O  
ATOM   1332  N   VAL A 184      84.898  31.135  65.516  1.00 35.67           N  
ATOM   1333  CA  VAL A 184      85.862  32.221  65.434  1.00 40.16           C  
ATOM   1334  C   VAL A 184      85.812  32.767  64.006  1.00 42.25           C  
ATOM   1335  O   VAL A 184      86.151  32.071  63.055  1.00 42.64           O  
ATOM   1336  CB  VAL A 184      87.285  31.727  65.774  1.00 40.51           C  
ATOM   1337  CG1 VAL A 184      87.396  31.477  67.268  1.00 39.63           C  
ATOM   1338  CG2 VAL A 184      87.586  30.435  65.019  1.00 42.18           C  
ATOM   1339  N   VAL A 185      85.353  34.004  63.855  1.00 45.34           N  
ATOM   1340  CA  VAL A 185      85.258  34.615  62.536  1.00 49.56           C  
ATOM   1341  C   VAL A 185      86.344  35.659  62.363  1.00 53.11           C  
ATOM   1342  O   VAL A 185      86.530  36.520  63.225  1.00 53.93           O  
ATOM   1343  CB  VAL A 185      83.895  35.301  62.322  1.00 49.58           C  
ATOM   1344  CG1 VAL A 185      83.850  35.946  60.938  1.00 48.44           C  
ATOM   1345  CG2 VAL A 185      82.778  34.286  62.474  1.00 49.21           C  
ATOM   1346  N   ASP A 186      87.060  35.584  61.247  1.00 56.68           N  
ATOM   1347  CA  ASP A 186      88.125  36.537  60.987  1.00 60.24           C  
ATOM   1348  C   ASP A 186      87.548  37.925  60.738  1.00 62.23           C  
ATOM   1349  O   ASP A 186      86.399  38.083  60.322  1.00 62.03           O  
ATOM   1350  CB  ASP A 186      88.969  36.098  59.787  1.00 61.15           C  
ATOM   1351  CG  ASP A 186      90.340  36.761  59.761  1.00 63.02           C  
ATOM   1352  OD1 ASP A 186      90.632  37.576  60.663  1.00 64.60           O  
ATOM   1353  OD2 ASP A 186      91.132  36.466  58.838  1.00 63.98           O  
ATOM   1354  N   GLY A 187      88.379  38.922  61.005  1.00 65.34           N  
ATOM   1355  CA  GLY A 187      88.010  40.312  60.845  1.00 68.73           C  
ATOM   1356  C   GLY A 187      89.186  41.109  61.374  1.00 70.64           C  
ATOM   1357  O   GLY A 187      90.107  40.546  61.975  1.00 71.06           O  
ATOM   1358  N   GLU A 188      89.172  42.416  61.163  1.00 72.17           N  
ATOM   1359  CA  GLU A 188      90.272  43.244  61.630  1.00 73.53           C  
ATOM   1360  C   GLU A 188      90.417  43.244  63.154  1.00 73.25           C  
ATOM   1361  O   GLU A 188      91.530  43.283  63.671  1.00 74.21           O  
ATOM   1362  CB  GLU A 188      90.092  44.669  61.112  1.00 74.81           C  
ATOM   1363  CG  GLU A 188      88.697  45.210  61.315  1.00 76.65           C  
ATOM   1364  CD  GLU A 188      88.485  46.528  60.608  1.00 78.01           C  
ATOM   1365  OE1 GLU A 188      89.455  47.051  60.018  1.00 79.12           O  
ATOM   1366  OE2 GLU A 188      87.348  47.044  60.642  1.00 79.03           O  
ATOM   1367  N   HIS A 189      89.297  43.187  63.869  1.00 71.89           N  
ATOM   1368  CA  HIS A 189      89.322  43.188  65.332  1.00 70.38           C  
ATOM   1369  C   HIS A 189      90.356  42.221  65.914  1.00 69.41           C  
ATOM   1370  O   HIS A 189      90.804  42.387  67.051  1.00 69.33           O  
ATOM   1371  CB  HIS A 189      87.942  42.828  65.877  1.00 70.47           C  
ATOM   1372  CG  HIS A 189      87.446  41.495  65.410  1.00 71.14           C  
ATOM   1373  ND1 HIS A 189      87.198  41.220  64.083  1.00 70.60           N  
ATOM   1374  CD2 HIS A 189      87.173  40.356  66.089  1.00 71.47           C  
ATOM   1375  CE1 HIS A 189      86.795  39.968  63.963  1.00 70.66           C  
ATOM   1376  NE2 HIS A 189      86.772  39.421  65.167  1.00 71.08           N  
ATOM   1377  N   TRP A 190      90.735  41.214  65.132  1.00 67.92           N  
ATOM   1378  CA  TRP A 190      91.704  40.227  65.594  1.00 66.94           C  
ATOM   1379  C   TRP A 190      93.101  40.772  65.849  1.00 67.66           C  
ATOM   1380  O   TRP A 190      93.920  40.115  66.490  1.00 68.15           O  
ATOM   1381  CB  TRP A 190      91.775  39.046  64.618  1.00 64.11           C  
ATOM   1382  CG  TRP A 190      90.891  37.912  65.046  1.00 60.92           C  
ATOM   1383  CD1 TRP A 190      89.636  37.623  64.589  1.00 59.84           C  
ATOM   1384  CD2 TRP A 190      91.158  36.982  66.099  1.00 58.82           C  
ATOM   1385  NE1 TRP A 190      89.104  36.573  65.298  1.00 58.65           N  
ATOM   1386  CE2 TRP A 190      90.017  36.161  66.233  1.00 58.69           C  
ATOM   1387  CE3 TRP A 190      92.251  36.765  66.949  1.00 58.51           C  
ATOM   1388  CZ2 TRP A 190      89.938  35.138  67.181  1.00 58.32           C  
ATOM   1389  CZ3 TRP A 190      92.171  35.748  67.893  1.00 58.65           C  
ATOM   1390  CH2 TRP A 190      91.021  34.948  68.001  1.00 58.40           C  
ATOM   1391  N   ASP A 191      93.373  41.974  65.355  1.00 68.65           N  
ATOM   1392  CA  ASP A 191      94.682  42.588  65.553  1.00 69.33           C  
ATOM   1393  C   ASP A 191      94.854  42.892  67.039  1.00 68.31           C  
ATOM   1394  O   ASP A 191      95.824  42.464  67.670  1.00 68.22           O  
ATOM   1395  CB  ASP A 191      94.786  43.900  64.765  1.00 71.80           C  
ATOM   1396  CG  ASP A 191      94.147  43.816  63.387  1.00 73.75           C  
ATOM   1397  OD1 ASP A 191      93.387  44.746  63.030  1.00 74.00           O  
ATOM   1398  OD2 ASP A 191      94.404  42.832  62.659  1.00 74.44           O  
ATOM   1399  N   GLY A 192      93.894  43.635  67.585  1.00 66.70           N  
ATOM   1400  CA  GLY A 192      93.935  44.013  68.987  1.00 64.71           C  
ATOM   1401  C   GLY A 192      93.635  42.865  69.928  1.00 63.30           C  
ATOM   1402  O   GLY A 192      94.283  42.721  70.965  1.00 62.40           O  
ATOM   1403  N   VAL A 193      92.644  42.053  69.567  1.00 62.43           N  
ATOM   1404  CA  VAL A 193      92.259  40.909  70.382  1.00 60.31           C  
ATOM   1405  C   VAL A 193      93.490  40.046  70.615  1.00 59.50           C  
ATOM   1406  O   VAL A 193      93.768  39.624  71.740  1.00 58.71           O  
ATOM   1407  CB  VAL A 193      91.177  40.062  69.682  1.00 59.25           C  
ATOM   1408  CG1 VAL A 193      90.797  38.871  70.551  1.00 58.69           C  
ATOM   1409  CG2 VAL A 193      89.962  40.921  69.393  1.00 58.50           C  
ATOM   1410  N   ASP A 194      94.227  39.799  69.538  1.00 59.03           N  
ATOM   1411  CA  ASP A 194      95.440  38.996  69.593  1.00 58.59           C  
ATOM   1412  C   ASP A 194      96.451  39.649  70.538  1.00 57.85           C  
ATOM   1413  O   ASP A 194      97.104  38.974  71.342  1.00 57.67           O  
ATOM   1414  CB  ASP A 194      96.035  38.866  68.189  1.00 58.32           C  
ATOM   1415  CG  ASP A 194      97.315  38.068  68.175  1.00 58.85           C  
ATOM   1416  OD1 ASP A 194      97.256  36.848  68.441  1.00 58.08           O  
ATOM   1417  OD2 ASP A 194      98.377  38.669  67.908  1.00 58.45           O  
ATOM   1418  N   ALA A 195      96.573  40.970  70.434  1.00 56.42           N  
ATOM   1419  CA  ALA A 195      97.490  41.727  71.279  1.00 55.64           C  
ATOM   1420  C   ALA A 195      97.121  41.517  72.739  1.00 54.70           C  
ATOM   1421  O   ALA A 195      97.990  41.342  73.598  1.00 53.94           O  
ATOM   1422  CB  ALA A 195      97.411  43.206  70.934  1.00 55.46           C  
ATOM   1423  N   LYS A 196      95.821  41.543  73.006  1.00 54.16           N  
ATOM   1424  CA  LYS A 196      95.298  41.351  74.349  1.00 53.98           C  
ATOM   1425  C   LYS A 196      95.762  40.017  74.922  1.00 53.52           C  
ATOM   1426  O   LYS A 196      96.414  39.978  75.969  1.00 53.23           O  
ATOM   1427  CB  LYS A 196      93.770  41.399  74.321  1.00 54.35           C  
ATOM   1428  CG  LYS A 196      93.201  42.766  74.012  1.00 56.27           C  
ATOM   1429  CD  LYS A 196      93.411  43.707  75.183  1.00 58.25           C  
ATOM   1430  CE  LYS A 196      92.720  45.044  74.958  1.00 59.44           C  
ATOM   1431  NZ  LYS A 196      92.740  45.889  76.189  1.00 60.85           N  
ATOM   1432  N   PHE A 197      95.426  38.926  74.233  1.00 52.11           N  
ATOM   1433  CA  PHE A 197      95.811  37.593  74.684  1.00 51.19           C  
ATOM   1434  C   PHE A 197      97.325  37.462  74.797  1.00 51.30           C  
ATOM   1435  O   PHE A 197      97.839  36.889  75.761  1.00 50.40           O  
ATOM   1436  CB  PHE A 197      95.279  36.516  73.730  1.00 49.19           C  
ATOM   1437  CG  PHE A 197      93.794  36.285  73.829  1.00 46.86           C  
ATOM   1438  CD1 PHE A 197      92.921  36.859  72.912  1.00 45.15           C  
ATOM   1439  CD2 PHE A 197      93.271  35.483  74.838  1.00 46.08           C  
ATOM   1440  CE1 PHE A 197      91.551  36.632  72.995  1.00 44.34           C  
ATOM   1441  CE2 PHE A 197      91.905  35.251  74.929  1.00 44.65           C  
ATOM   1442  CZ  PHE A 197      91.043  35.826  74.006  1.00 43.84           C  
ATOM   1443  N   ALA A 198      98.039  37.991  73.809  1.00 52.00           N  
ATOM   1444  CA  ALA A 198      99.497  37.926  73.816  1.00 53.89           C  
ATOM   1445  C   ALA A 198     100.033  38.505  75.125  1.00 54.91           C  
ATOM   1446  O   ALA A 198     100.965  37.966  75.730  1.00 53.95           O  
ATOM   1447  CB  ALA A 198     100.058  38.702  72.628  1.00 51.77           C  
ATOM   1448  N   ASP A 199      99.417  39.598  75.562  1.00 56.75           N  
ATOM   1449  CA  ASP A 199      99.817  40.278  76.782  1.00 58.72           C  
ATOM   1450  C   ASP A 199      99.299  39.578  78.042  1.00 58.47           C  
ATOM   1451  O   ASP A 199      99.993  39.527  79.059  1.00 58.04           O  
ATOM   1452  CB  ASP A 199      99.324  41.727  76.742  1.00 61.40           C  
ATOM   1453  CG  ASP A 199      99.985  42.596  77.792  1.00 64.83           C  
ATOM   1454  OD1 ASP A 199     101.235  42.661  77.809  1.00 66.81           O  
ATOM   1455  OD2 ASP A 199      99.258  43.216  78.598  1.00 66.48           O  
ATOM   1456  N   TYR A 200      98.083  39.042  77.968  1.00 57.94           N  
ATOM   1457  CA  TYR A 200      97.467  38.346  79.097  1.00 57.30           C  
ATOM   1458  C   TYR A 200      98.024  36.941  79.329  1.00 58.08           C  
ATOM   1459  O   TYR A 200      97.943  36.419  80.444  1.00 58.00           O  
ATOM   1460  CB  TYR A 200      95.953  38.217  78.892  1.00 54.81           C  
ATOM   1461  CG  TYR A 200      95.125  39.437  79.239  1.00 54.29           C  
ATOM   1462  CD1 TYR A 200      94.303  40.038  78.284  1.00 53.72           C  
ATOM   1463  CD2 TYR A 200      95.124  39.963  80.532  1.00 54.57           C  
ATOM   1464  CE1 TYR A 200      93.496  41.130  78.605  1.00 53.10           C  
ATOM   1465  CE2 TYR A 200      94.318  41.060  80.867  1.00 53.99           C  
ATOM   1466  CZ  TYR A 200      93.508  41.636  79.896  1.00 53.47           C  
ATOM   1467  OH  TYR A 200      92.709  42.709  80.211  1.00 52.20           O  
ATOM   1468  N   GLU A 201      98.589  36.329  78.290  1.00 58.77           N  
ATOM   1469  CA  GLU A 201      99.096  34.965  78.417  1.00 60.18           C  
ATOM   1470  C   GLU A 201     100.575  34.753  78.102  1.00 60.32           C  
ATOM   1471  O   GLU A 201     101.020  33.612  77.965  1.00 59.03           O  
ATOM   1472  CB  GLU A 201      98.257  34.028  77.542  1.00 61.22           C  
ATOM   1473  CG  GLU A 201      96.829  34.511  77.333  1.00 63.44           C  
ATOM   1474  CD  GLU A 201      95.930  33.470  76.691  1.00 64.50           C  
ATOM   1475  OE1 GLU A 201      95.577  32.486  77.375  1.00 64.36           O  
ATOM   1476  OE2 GLU A 201      95.579  33.637  75.504  1.00 64.74           O  
ATOM   1477  N   ASN A 202     101.337  35.835  77.989  1.00 60.96           N  
ATOM   1478  CA  ASN A 202     102.763  35.714  77.700  1.00 61.64           C  
ATOM   1479  C   ASN A 202     102.948  34.903  76.416  1.00 61.22           C  
ATOM   1480  O   ASN A 202     103.568  33.839  76.413  1.00 60.33           O  
ATOM   1481  CB  ASN A 202     103.468  35.031  78.883  1.00 62.95           C  
ATOM   1482  CG  ASN A 202     104.980  34.982  78.725  1.00 64.07           C  
ATOM   1483  OD1 ASN A 202     105.620  35.993  78.427  1.00 64.55           O  
ATOM   1484  ND2 ASN A 202     105.560  33.803  78.940  1.00 64.74           N  
ATOM   1485  N   LEU A 203     102.390  35.418  75.325  1.00 60.87           N  
ATOM   1486  CA  LEU A 203     102.476  34.763  74.026  1.00 60.56           C  
ATOM   1487  C   LEU A 203     103.011  35.745  72.992  1.00 60.41           C  
ATOM   1488  O   LEU A 203     102.749  36.944  73.073  1.00 60.44           O  
ATOM   1489  CB  LEU A 203     101.091  34.279  73.583  1.00 60.79           C  
ATOM   1490  CG  LEU A 203     100.357  33.233  74.429  1.00 61.14           C  
ATOM   1491  CD1 LEU A 203      98.933  33.071  73.915  1.00 60.55           C  
ATOM   1492  CD2 LEU A 203     101.103  31.904  74.380  1.00 60.88           C  
ATOM   1493  N   PRO A 204     103.777  35.249  72.008  1.00 60.19           N  
ATOM   1494  CA  PRO A 204     104.335  36.113  70.962  1.00 60.30           C  
ATOM   1495  C   PRO A 204     103.203  36.800  70.203  1.00 60.41           C  
ATOM   1496  O   PRO A 204     102.147  36.208  69.994  1.00 60.34           O  
ATOM   1497  CB  PRO A 204     105.103  35.132  70.075  1.00 60.07           C  
ATOM   1498  CG  PRO A 204     105.519  34.060  71.039  1.00 60.33           C  
ATOM   1499  CD  PRO A 204     104.270  33.867  71.867  1.00 60.03           C  
ATOM   1500  N   ARG A 205     103.418  38.042  69.795  1.00 60.69           N  
ATOM   1501  CA  ARG A 205     102.395  38.773  69.062  1.00 62.34           C  
ATOM   1502  C   ARG A 205     102.024  38.000  67.795  1.00 61.75           C  
ATOM   1503  O   ARG A 205     102.870  37.787  66.926  1.00 62.25           O  
ATOM   1504  CB  ARG A 205     102.911  40.157  68.676  1.00 65.20           C  
ATOM   1505  CG  ARG A 205     103.635  40.894  69.790  1.00 71.21           C  
ATOM   1506  CD  ARG A 205     104.288  42.155  69.245  1.00 75.99           C  
ATOM   1507  NE  ARG A 205     105.268  42.728  70.166  1.00 80.68           N  
ATOM   1508  CZ  ARG A 205     106.074  43.745  69.863  1.00 82.80           C  
ATOM   1509  NH1 ARG A 205     106.017  44.307  68.660  1.00 83.42           N  
ATOM   1510  NH2 ARG A 205     106.943  44.197  70.760  1.00 83.44           N  
ATOM   1511  N   GLY A 206     100.767  37.575  67.694  1.00 60.65           N  
ATOM   1512  CA  GLY A 206     100.321  36.842  66.519  1.00 58.74           C  
ATOM   1513  C   GLY A 206     100.136  35.343  66.699  1.00 57.72           C  
ATOM   1514  O   GLY A 206      99.526  34.683  65.858  1.00 57.45           O  
ATOM   1515  N   GLU A 207     100.659  34.805  67.793  1.00 56.61           N  
ATOM   1516  CA  GLU A 207     100.555  33.379  68.070  1.00 56.75           C  
ATOM   1517  C   GLU A 207      99.125  32.956  68.390  1.00 56.35           C  
ATOM   1518  O   GLU A 207      98.674  31.896  67.960  1.00 56.37           O  
ATOM   1519  CB  GLU A 207     101.471  33.005  69.241  1.00 58.24           C  
ATOM   1520  CG  GLU A 207     101.337  31.558  69.714  1.00 61.56           C  
ATOM   1521  CD  GLU A 207     101.982  30.551  68.771  1.00 63.92           C  
ATOM   1522  OE1 GLU A 207     102.055  30.825  67.551  1.00 64.56           O  
ATOM   1523  OE2 GLU A 207     102.402  29.474  69.254  1.00 64.66           O  
ATOM   1524  N   LYS A 208      98.416  33.786  69.147  1.00 55.81           N  
ATOM   1525  CA  LYS A 208      97.045  33.484  69.542  1.00 54.47           C  
ATOM   1526  C   LYS A 208      96.124  33.272  68.352  1.00 54.10           C  
ATOM   1527  O   LYS A 208      95.418  32.267  68.279  1.00 54.24           O  
ATOM   1528  CB  LYS A 208      96.478  34.609  70.416  1.00 53.61           C  
ATOM   1529  CG  LYS A 208      95.119  34.286  71.022  1.00 51.11           C  
ATOM   1530  CD  LYS A 208      95.235  33.141  72.008  1.00 49.58           C  
ATOM   1531  CE  LYS A 208      93.899  32.782  72.608  1.00 46.85           C  
ATOM   1532  NZ  LYS A 208      94.078  31.743  73.650  1.00 46.61           N  
ATOM   1533  N   LYS A 209      96.126  34.224  67.425  1.00 53.65           N  
ATOM   1534  CA  LYS A 209      95.275  34.130  66.243  1.00 53.32           C  
ATOM   1535  C   LYS A 209      95.633  32.905  65.418  1.00 54.50           C  
ATOM   1536  O   LYS A 209      94.777  32.321  64.755  1.00 54.77           O  
ATOM   1537  CB  LYS A 209      95.419  35.379  65.377  1.00 51.21           C  
ATOM   1538  CG  LYS A 209      94.522  35.368  64.160  1.00 48.73           C  
ATOM   1539  CD  LYS A 209      94.763  36.576  63.279  1.00 48.11           C  
ATOM   1540  CE  LYS A 209      93.799  36.598  62.110  1.00 46.46           C  
ATOM   1541  NZ  LYS A 209      94.079  37.707  61.166  1.00 47.55           N  
ATOM   1542  N   ARG A 210      96.904  32.522  65.458  1.00 55.70           N  
ATOM   1543  CA  ARG A 210      97.374  31.363  64.715  1.00 56.99           C  
ATOM   1544  C   ARG A 210      96.862  30.083  65.370  1.00 56.95           C  
ATOM   1545  O   ARG A 210      96.332  29.199  64.692  1.00 56.48           O  
ATOM   1546  CB  ARG A 210      98.902  31.341  64.677  1.00 58.95           C  
ATOM   1547  CG  ARG A 210      99.477  30.283  63.751  1.00 61.02           C  
ATOM   1548  CD  ARG A 210     100.923  29.970  64.100  1.00 63.75           C  
ATOM   1549  NE  ARG A 210     101.043  29.407  65.445  1.00 65.84           N  
ATOM   1550  CZ  ARG A 210     100.489  28.259  65.834  1.00 66.16           C  
ATOM   1551  NH1 ARG A 210      99.772  27.539  64.980  1.00 66.15           N  
ATOM   1552  NH2 ARG A 210     100.650  27.829  67.080  1.00 65.33           N  
ATOM   1553  N   GLN A 211      97.032  29.990  66.688  1.00 56.05           N  
ATOM   1554  CA  GLN A 211      96.585  28.826  67.447  1.00 55.34           C  
ATOM   1555  C   GLN A 211      95.097  28.603  67.232  1.00 53.74           C  
ATOM   1556  O   GLN A 211      94.668  27.503  66.885  1.00 53.99           O  
ATOM   1557  CB  GLN A 211      96.848  29.018  68.949  1.00 57.24           C  
ATOM   1558  CG  GLN A 211      98.304  28.861  69.373  1.00 60.85           C  
ATOM   1559  CD  GLN A 211      98.497  29.010  70.875  1.00 62.89           C  
ATOM   1560  OE1 GLN A 211      97.862  28.310  71.669  1.00 63.24           O  
ATOM   1561  NE2 GLN A 211      99.380  29.920  71.269  1.00 63.72           N  
ATOM   1562  N   VAL A 212      94.320  29.664  67.435  1.00 51.56           N  
ATOM   1563  CA  VAL A 212      92.865  29.626  67.296  1.00 48.04           C  
ATOM   1564  C   VAL A 212      92.380  29.098  65.951  1.00 45.48           C  
ATOM   1565  O   VAL A 212      91.529  28.215  65.896  1.00 43.48           O  
ATOM   1566  CB  VAL A 212      92.261  31.029  67.516  1.00 46.87           C  
ATOM   1567  CG1 VAL A 212      90.759  30.988  67.317  1.00 47.50           C  
ATOM   1568  CG2 VAL A 212      92.595  31.516  68.912  1.00 45.84           C  
ATOM   1569  N   GLY A 213      92.924  29.649  64.872  1.00 44.03           N  
ATOM   1570  CA  GLY A 213      92.525  29.228  63.541  1.00 43.19           C  
ATOM   1571  C   GLY A 213      92.914  27.804  63.192  1.00 42.50           C  
ATOM   1572  O   GLY A 213      92.233  27.147  62.406  1.00 42.61           O  
ATOM   1573  N   ALA A 214      94.009  27.327  63.777  1.00 41.63           N  
ATOM   1574  CA  ALA A 214      94.493  25.976  63.528  1.00 39.58           C  
ATOM   1575  C   ALA A 214      93.755  24.946  64.382  1.00 38.85           C  
ATOM   1576  O   ALA A 214      93.730  23.762  64.051  1.00 39.86           O  
ATOM   1577  CB  ALA A 214      95.994  25.905  63.807  1.00 39.82           C  
ATOM   1578  N   ALA A 215      93.150  25.394  65.478  1.00 36.60           N  
ATOM   1579  CA  ALA A 215      92.429  24.490  66.368  1.00 33.99           C  
ATOM   1580  C   ALA A 215      91.039  24.153  65.841  1.00 32.84           C  
ATOM   1581  O   ALA A 215      90.410  23.191  66.295  1.00 32.52           O  
ATOM   1582  CB  ALA A 215      92.325  25.101  67.758  1.00 33.98           C  
ATOM   1583  N   VAL A 216      90.557  24.949  64.889  1.00 31.30           N  
ATOM   1584  CA  VAL A 216      89.243  24.714  64.295  1.00 30.33           C  
ATOM   1585  C   VAL A 216      89.301  23.421  63.497  1.00 29.51           C  
ATOM   1586  O   VAL A 216      90.100  23.302  62.573  1.00 29.59           O  
ATOM   1587  CB  VAL A 216      88.848  25.845  63.329  1.00 30.17           C  
ATOM   1588  CG1 VAL A 216      87.529  25.508  62.651  1.00 28.16           C  
ATOM   1589  CG2 VAL A 216      88.749  27.162  64.082  1.00 29.30           C  
ATOM   1590  N   PRO A 217      88.462  22.434  63.847  1.00 28.53           N  
ATOM   1591  CA  PRO A 217      88.442  21.148  63.141  1.00 27.89           C  
ATOM   1592  C   PRO A 217      88.470  21.313  61.623  1.00 26.79           C  
ATOM   1593  O   PRO A 217      89.293  20.702  60.953  1.00 25.32           O  
ATOM   1594  CB  PRO A 217      87.149  20.507  63.636  1.00 28.59           C  
ATOM   1595  CG  PRO A 217      87.078  20.998  65.052  1.00 28.21           C  
ATOM   1596  CD  PRO A 217      87.441  22.463  64.911  1.00 28.45           C  
ATOM   1597  N   PHE A 218      87.578  22.149  61.096  1.00 26.23           N  
ATOM   1598  CA  PHE A 218      87.505  22.401  59.659  1.00 26.96           C  
ATOM   1599  C   PHE A 218      88.865  22.805  59.080  1.00 28.62           C  
ATOM   1600  O   PHE A 218      89.110  22.634  57.887  1.00 29.39           O  
ATOM   1601  CB  PHE A 218      86.486  23.503  59.358  1.00 25.34           C  
ATOM   1602  CG  PHE A 218      86.214  23.701  57.886  1.00 26.10           C  
ATOM   1603  CD1 PHE A 218      85.204  22.983  57.249  1.00 26.93           C  
ATOM   1604  CD2 PHE A 218      86.958  24.610  57.137  1.00 26.10           C  
ATOM   1605  CE1 PHE A 218      84.938  23.170  55.894  1.00 24.35           C  
ATOM   1606  CE2 PHE A 218      86.699  24.804  55.781  1.00 25.01           C  
ATOM   1607  CZ  PHE A 218      85.688  24.084  55.160  1.00 24.55           C  
ATOM   1608  N   GLY A 219      89.738  23.364  59.912  1.00 29.98           N  
ATOM   1609  CA  GLY A 219      91.054  23.742  59.428  1.00 31.28           C  
ATOM   1610  C   GLY A 219      91.318  25.205  59.116  1.00 32.62           C  
ATOM   1611  O   GLY A 219      92.370  25.537  58.560  1.00 32.48           O  
ATOM   1612  N   ARG A 220      90.378  26.082  59.453  1.00 32.75           N  
ATOM   1613  CA  ARG A 220      90.577  27.505  59.208  1.00 32.67           C  
ATOM   1614  C   ARG A 220      89.582  28.365  59.969  1.00 33.39           C  
ATOM   1615  O   ARG A 220      88.541  27.889  60.426  1.00 33.04           O  
ATOM   1616  CB  ARG A 220      90.486  27.819  57.711  1.00 32.06           C  
ATOM   1617  CG  ARG A 220      89.097  28.171  57.203  1.00 31.62           C  
ATOM   1618  CD  ARG A 220      89.096  28.299  55.683  1.00 31.43           C  
ATOM   1619  NE  ARG A 220      87.795  28.575  55.058  1.00 32.68           N  
ATOM   1620  CZ  ARG A 220      86.619  28.611  55.679  1.00 34.77           C  
ATOM   1621  NH1 ARG A 220      86.527  28.393  56.981  1.00 40.13           N  
ATOM   1622  NH2 ARG A 220      85.521  28.862  54.982  1.00 33.56           N  
ATOM   1623  N   MET A 221      89.921  29.639  60.103  1.00 34.46           N  
ATOM   1624  CA  MET A 221      89.067  30.582  60.793  1.00 36.12           C  
ATOM   1625  C   MET A 221      87.827  30.807  59.932  1.00 35.62           C  
ATOM   1626  O   MET A 221      87.862  30.611  58.715  1.00 35.49           O  
ATOM   1627  CB  MET A 221      89.827  31.892  61.009  1.00 39.51           C  
ATOM   1628  CG  MET A 221      89.255  32.777  62.088  1.00 41.17           C  
ATOM   1629  SD  MET A 221      90.565  33.778  62.791  1.00 48.07           S  
ATOM   1630  CE  MET A 221      91.257  32.639  63.979  1.00 44.94           C  
ATOM   1631  N   GLY A 222      86.732  31.209  60.568  1.00 35.13           N  
ATOM   1632  CA  GLY A 222      85.491  31.435  59.851  1.00 34.04           C  
ATOM   1633  C   GLY A 222      85.500  32.611  58.898  1.00 34.46           C  
ATOM   1634  O   GLY A 222      86.418  33.429  58.895  1.00 32.50           O  
ATOM   1635  N   ARG A 223      84.449  32.694  58.089  1.00 35.55           N  
ATOM   1636  CA  ARG A 223      84.299  33.750  57.100  1.00 37.27           C  
ATOM   1637  C   ARG A 223      82.812  34.087  57.025  1.00 37.14           C  
ATOM   1638  O   ARG A 223      81.967  33.230  57.274  1.00 37.79           O  
ATOM   1639  CB  ARG A 223      84.802  33.239  55.752  1.00 40.76           C  
ATOM   1640  CG  ARG A 223      85.539  34.255  54.903  1.00 46.38           C  
ATOM   1641  CD  ARG A 223      86.684  33.577  54.169  1.00 48.38           C  
ATOM   1642  NE  ARG A 223      86.326  32.216  53.781  1.00 51.61           N  
ATOM   1643  CZ  ARG A 223      87.123  31.390  53.107  1.00 52.89           C  
ATOM   1644  NH1 ARG A 223      88.333  31.789  52.739  1.00 54.40           N  
ATOM   1645  NH2 ARG A 223      86.712  30.163  52.806  1.00 52.64           N  
ATOM   1646  N   ALA A 224      82.483  35.327  56.690  1.00 36.60           N  
ATOM   1647  CA  ALA A 224      81.080  35.718  56.615  1.00 36.54           C  
ATOM   1648  C   ALA A 224      80.292  34.804  55.679  1.00 36.01           C  
ATOM   1649  O   ALA A 224      79.160  34.434  55.972  1.00 35.98           O  
ATOM   1650  CB  ALA A 224      80.964  37.170  56.158  1.00 36.19           C  
ATOM   1651  N   GLU A 225      80.905  34.435  54.559  1.00 36.54           N  
ATOM   1652  CA  GLU A 225      80.268  33.570  53.571  1.00 36.13           C  
ATOM   1653  C   GLU A 225      79.864  32.204  54.120  1.00 33.95           C  
ATOM   1654  O   GLU A 225      79.011  31.532  53.548  1.00 33.83           O  
ATOM   1655  CB  GLU A 225      81.194  33.382  52.364  1.00 38.60           C  
ATOM   1656  CG  GLU A 225      81.481  34.667  51.599  1.00 43.71           C  
ATOM   1657  CD  GLU A 225      82.373  35.632  52.366  1.00 46.36           C  
ATOM   1658  OE1 GLU A 225      82.395  36.825  51.995  1.00 49.37           O  
ATOM   1659  OE2 GLU A 225      83.057  35.204  53.322  1.00 46.89           O  
ATOM   1660  N   ASP A 226      80.475  31.790  55.223  1.00 30.48           N  
ATOM   1661  CA  ASP A 226      80.132  30.503  55.808  1.00 28.59           C  
ATOM   1662  C   ASP A 226      78.805  30.572  56.539  1.00 27.55           C  
ATOM   1663  O   ASP A 226      78.160  29.550  56.755  1.00 26.90           O  
ATOM   1664  CB  ASP A 226      81.208  30.052  56.794  1.00 27.46           C  
ATOM   1665  CG  ASP A 226      82.556  29.901  56.143  1.00 29.29           C  
ATOM   1666  OD1 ASP A 226      82.589  29.584  54.931  1.00 33.27           O  
ATOM   1667  OD2 ASP A 226      83.580  30.080  56.837  1.00 26.89           O  
ATOM   1668  N   LEU A 227      78.399  31.787  56.900  1.00 26.95           N  
ATOM   1669  CA  LEU A 227      77.169  32.012  57.659  1.00 25.55           C  
ATOM   1670  C   LEU A 227      75.911  32.382  56.880  1.00 24.79           C  
ATOM   1671  O   LEU A 227      74.807  32.062  57.310  1.00 25.55           O  
ATOM   1672  CB  LEU A 227      77.428  33.090  58.722  1.00 24.60           C  
ATOM   1673  CG  LEU A 227      78.127  32.729  60.044  1.00 25.02           C  
ATOM   1674  CD1 LEU A 227      79.117  31.606  59.867  1.00 22.80           C  
ATOM   1675  CD2 LEU A 227      78.826  33.969  60.576  1.00 25.24           C  
ATOM   1676  N   THR A 228      76.068  33.051  55.744  1.00 25.33           N  
ATOM   1677  CA  THR A 228      74.917  33.487  54.951  1.00 26.26           C  
ATOM   1678  C   THR A 228      73.907  32.404  54.557  1.00 25.76           C  
ATOM   1679  O   THR A 228      72.700  32.671  54.515  1.00 27.50           O  
ATOM   1680  CB  THR A 228      75.379  34.238  53.689  1.00 27.39           C  
ATOM   1681  OG1 THR A 228      76.190  33.378  52.882  1.00 29.26           O  
ATOM   1682  CG2 THR A 228      76.198  35.465  54.085  1.00 27.87           C  
ATOM   1683  N   GLY A 229      74.382  31.191  54.280  1.00 23.67           N  
ATOM   1684  CA  GLY A 229      73.475  30.114  53.913  1.00 20.40           C  
ATOM   1685  C   GLY A 229      72.448  29.847  55.003  1.00 19.34           C  
ATOM   1686  O   GLY A 229      71.246  29.776  54.738  1.00 18.85           O  
ATOM   1687  N   MET A 230      72.923  29.696  56.235  1.00 19.43           N  
ATOM   1688  CA  MET A 230      72.048  29.442  57.378  1.00 20.56           C  
ATOM   1689  C   MET A 230      71.152  30.663  57.670  1.00 20.54           C  
ATOM   1690  O   MET A 230      69.971  30.519  58.003  1.00 19.43           O  
ATOM   1691  CB  MET A 230      72.896  29.092  58.606  1.00 21.95           C  
ATOM   1692  CG  MET A 230      72.100  28.760  59.849  1.00 22.84           C  
ATOM   1693  SD  MET A 230      70.979  27.378  59.607  1.00 25.30           S  
ATOM   1694  CE  MET A 230      72.073  26.021  59.965  1.00 23.83           C  
ATOM   1695  N   ALA A 231      71.715  31.861  57.531  1.00 19.80           N  
ATOM   1696  CA  ALA A 231      70.961  33.092  57.754  1.00 19.79           C  
ATOM   1697  C   ALA A 231      69.736  33.122  56.833  1.00 20.62           C  
ATOM   1698  O   ALA A 231      68.656  33.570  57.227  1.00 20.55           O  
ATOM   1699  CB  ALA A 231      71.850  34.304  57.486  1.00 18.85           C  
ATOM   1700  N   ILE A 232      69.915  32.643  55.604  1.00 21.65           N  
ATOM   1701  CA  ILE A 232      68.832  32.588  54.614  1.00 22.41           C  
ATOM   1702  C   ILE A 232      67.861  31.431  54.907  1.00 22.34           C  
ATOM   1703  O   ILE A 232      66.638  31.609  54.915  1.00 22.23           O  
ATOM   1704  CB  ILE A 232      69.401  32.399  53.175  1.00 22.14           C  
ATOM   1705  CG1 ILE A 232      70.238  33.619  52.780  1.00 21.71           C  
ATOM   1706  CG2 ILE A 232      68.270  32.200  52.181  1.00 20.73           C  
ATOM   1707  CD1 ILE A 232      71.028  33.441  51.494  1.00 21.14           C  
ATOM   1708  N   PHE A 233      68.413  30.245  55.154  1.00 21.98           N  
ATOM   1709  CA  PHE A 233      67.597  29.072  55.424  1.00 20.26           C  
ATOM   1710  C   PHE A 233      66.585  29.277  56.547  1.00 20.62           C  
ATOM   1711  O   PHE A 233      65.406  28.957  56.390  1.00 21.09           O  
ATOM   1712  CB  PHE A 233      68.480  27.875  55.765  1.00 19.22           C  
ATOM   1713  CG  PHE A 233      67.703  26.610  56.014  1.00 19.57           C  
ATOM   1714  CD1 PHE A 233      67.091  25.936  54.962  1.00 20.24           C  
ATOM   1715  CD2 PHE A 233      67.561  26.109  57.301  1.00 19.07           C  
ATOM   1716  CE1 PHE A 233      66.344  24.781  55.189  1.00 20.20           C  
ATOM   1717  CE2 PHE A 233      66.815  24.953  57.541  1.00 20.60           C  
ATOM   1718  CZ  PHE A 233      66.206  24.288  56.481  1.00 20.62           C  
ATOM   1719  N   LEU A 234      67.045  29.797  57.681  1.00 19.98           N  
ATOM   1720  CA  LEU A 234      66.163  30.015  58.826  1.00 20.60           C  
ATOM   1721  C   LEU A 234      65.013  30.979  58.550  1.00 21.64           C  
ATOM   1722  O   LEU A 234      64.033  31.002  59.291  1.00 21.11           O  
ATOM   1723  CB  LEU A 234      66.966  30.517  60.029  1.00 18.60           C  
ATOM   1724  CG  LEU A 234      67.797  29.455  60.751  1.00 17.74           C  
ATOM   1725  CD1 LEU A 234      68.590  30.080  61.888  1.00 15.97           C  
ATOM   1726  CD2 LEU A 234      66.864  28.379  61.285  1.00 17.93           C  
ATOM   1727  N   ALA A 235      65.132  31.761  57.480  1.00 22.87           N  
ATOM   1728  CA  ALA A 235      64.100  32.728  57.122  1.00 25.13           C  
ATOM   1729  C   ALA A 235      63.095  32.200  56.103  1.00 26.81           C  
ATOM   1730  O   ALA A 235      62.129  32.889  55.768  1.00 28.97           O  
ATOM   1731  CB  ALA A 235      64.753  34.004  56.584  1.00 24.33           C  
ATOM   1732  N   THR A 236      63.310  30.985  55.612  1.00 26.60           N  
ATOM   1733  CA  THR A 236      62.411  30.409  54.613  1.00 26.35           C  
ATOM   1734  C   THR A 236      61.362  29.486  55.223  1.00 25.67           C  
ATOM   1735  O   THR A 236      61.468  29.074  56.379  1.00 26.18           O  
ATOM   1736  CB  THR A 236      63.197  29.612  53.563  1.00 26.23           C  
ATOM   1737  OG1 THR A 236      63.855  28.512  54.203  1.00 25.70           O  
ATOM   1738  CG2 THR A 236      64.237  30.495  52.893  1.00 24.61           C  
ATOM   1739  N   PRO A 237      60.318  29.156  54.451  1.00 24.86           N  
ATOM   1740  CA  PRO A 237      59.287  28.269  54.990  1.00 24.52           C  
ATOM   1741  C   PRO A 237      59.763  26.830  55.187  1.00 25.24           C  
ATOM   1742  O   PRO A 237      59.059  26.019  55.788  1.00 25.86           O  
ATOM   1743  CB  PRO A 237      58.152  28.394  53.973  1.00 22.45           C  
ATOM   1744  CG  PRO A 237      58.855  28.741  52.713  1.00 23.42           C  
ATOM   1745  CD  PRO A 237      59.904  29.721  53.156  1.00 24.22           C  
ATOM   1746  N   GLU A 238      60.955  26.507  54.689  1.00 25.76           N  
ATOM   1747  CA  GLU A 238      61.488  25.165  54.870  1.00 26.78           C  
ATOM   1748  C   GLU A 238      61.963  25.013  56.309  1.00 27.45           C  
ATOM   1749  O   GLU A 238      62.395  23.931  56.719  1.00 28.63           O  
ATOM   1750  CB  GLU A 238      62.657  24.891  53.917  1.00 28.34           C  
ATOM   1751  CG  GLU A 238      62.248  24.653  52.477  1.00 29.47           C  
ATOM   1752  CD  GLU A 238      63.374  24.062  51.636  1.00 31.84           C  
ATOM   1753  OE1 GLU A 238      64.465  24.664  51.575  1.00 32.42           O  
ATOM   1754  OE2 GLU A 238      63.169  22.989  51.030  1.00 33.50           O  
ATOM   1755  N   ALA A 239      61.868  26.101  57.072  1.00 26.09           N  
ATOM   1756  CA  ALA A 239      62.282  26.109  58.472  1.00 24.01           C  
ATOM   1757  C   ALA A 239      61.119  26.415  59.419  1.00 24.62           C  
ATOM   1758  O   ALA A 239      61.324  26.620  60.622  1.00 25.04           O  
ATOM   1759  CB  ALA A 239      63.396  27.128  58.675  1.00 23.04           C  
ATOM   1760  N   ASP A 240      59.901  26.435  58.888  1.00 22.92           N  
ATOM   1761  CA  ASP A 240      58.728  26.721  59.710  1.00 21.54           C  
ATOM   1762  C   ASP A 240      58.588  25.825  60.928  1.00 21.09           C  
ATOM   1763  O   ASP A 240      57.900  26.187  61.877  1.00 21.96           O  
ATOM   1764  CB  ASP A 240      57.442  26.590  58.900  1.00 21.66           C  
ATOM   1765  CG  ASP A 240      57.211  27.755  57.967  1.00 22.84           C  
ATOM   1766  OD1 ASP A 240      58.042  28.688  57.923  1.00 23.30           O  
ATOM   1767  OD2 ASP A 240      56.176  27.728  57.270  1.00 25.36           O  
ATOM   1768  N   TYR A 241      59.210  24.654  60.909  1.00 19.28           N  
ATOM   1769  CA  TYR A 241      59.080  23.749  62.042  1.00 18.03           C  
ATOM   1770  C   TYR A 241      60.287  23.837  62.980  1.00 18.36           C  
ATOM   1771  O   TYR A 241      60.394  23.066  63.937  1.00 18.99           O  
ATOM   1772  CB  TYR A 241      58.883  22.306  61.545  1.00 16.72           C  
ATOM   1773  CG  TYR A 241      58.187  21.384  62.531  1.00 14.84           C  
ATOM   1774  CD1 TYR A 241      56.861  21.617  62.927  1.00 15.54           C  
ATOM   1775  CD2 TYR A 241      58.851  20.285  63.076  1.00 12.80           C  
ATOM   1776  CE1 TYR A 241      56.222  20.776  63.846  1.00 14.31           C  
ATOM   1777  CE2 TYR A 241      58.222  19.440  63.989  1.00 12.47           C  
ATOM   1778  CZ  TYR A 241      56.914  19.691  64.368  1.00 14.81           C  
ATOM   1779  OH  TYR A 241      56.302  18.860  65.281  1.00 17.97           O  
ATOM   1780  N   ILE A 242      61.194  24.774  62.708  1.00 18.06           N  
ATOM   1781  CA  ILE A 242      62.370  24.956  63.563  1.00 18.59           C  
ATOM   1782  C   ILE A 242      62.074  26.081  64.571  1.00 20.10           C  
ATOM   1783  O   ILE A 242      61.966  27.251  64.205  1.00 18.52           O  
ATOM   1784  CB  ILE A 242      63.619  25.289  62.721  1.00 16.72           C  
ATOM   1785  CG1 ILE A 242      63.947  24.094  61.809  1.00 16.44           C  
ATOM   1786  CG2 ILE A 242      64.796  25.592  63.633  1.00 15.55           C  
ATOM   1787  CD1 ILE A 242      65.072  24.330  60.822  1.00 13.53           C  
ATOM   1788  N   VAL A 243      61.937  25.709  65.841  1.00 20.04           N  
ATOM   1789  CA  VAL A 243      61.601  26.664  66.897  1.00 18.99           C  
ATOM   1790  C   VAL A 243      62.521  26.661  68.118  1.00 18.34           C  
ATOM   1791  O   VAL A 243      62.841  25.603  68.657  1.00 18.35           O  
ATOM   1792  CB  VAL A 243      60.172  26.400  67.405  1.00 18.93           C  
ATOM   1793  CG1 VAL A 243      59.792  27.410  68.473  1.00 18.33           C  
ATOM   1794  CG2 VAL A 243      59.202  26.447  66.240  1.00 17.52           C  
ATOM   1795  N   ALA A 244      62.925  27.858  68.547  1.00 17.17           N  
ATOM   1796  CA  ALA A 244      63.770  28.053  69.727  1.00 16.24           C  
ATOM   1797  C   ALA A 244      65.067  27.262  69.723  1.00 15.92           C  
ATOM   1798  O   ALA A 244      65.450  26.687  70.737  1.00 18.93           O  
ATOM   1799  CB  ALA A 244      62.972  27.729  71.000  1.00 12.40           C  
ATOM   1800  N   GLN A 245      65.757  27.255  68.592  1.00 15.76           N  
ATOM   1801  CA  GLN A 245      67.013  26.530  68.475  1.00 14.89           C  
ATOM   1802  C   GLN A 245      68.152  27.498  68.245  1.00 14.04           C  
ATOM   1803  O   GLN A 245      67.941  28.624  67.775  1.00 13.19           O  
ATOM   1804  CB  GLN A 245      66.969  25.562  67.273  1.00 16.43           C  
ATOM   1805  CG  GLN A 245      65.798  24.587  67.273  1.00 14.23           C  
ATOM   1806  CD  GLN A 245      65.839  23.660  68.462  1.00 13.84           C  
ATOM   1807  OE1 GLN A 245      66.901  23.138  68.817  1.00 15.40           O  
ATOM   1808  NE2 GLN A 245      64.685  23.440  69.086  1.00 12.98           N  
ATOM   1809  N   THR A 246      69.359  27.036  68.564  1.00 13.90           N  
ATOM   1810  CA  THR A 246      70.595  27.784  68.352  1.00 13.69           C  
ATOM   1811  C   THR A 246      71.465  26.791  67.567  1.00 14.66           C  
ATOM   1812  O   THR A 246      71.850  25.745  68.089  1.00 15.17           O  
ATOM   1813  CB  THR A 246      71.291  28.163  69.691  1.00 13.15           C  
ATOM   1814  OG1 THR A 246      70.439  29.040  70.442  1.00 14.80           O  
ATOM   1815  CG2 THR A 246      72.612  28.872  69.428  1.00 10.43           C  
ATOM   1816  N   TYR A 247      71.731  27.113  66.303  1.00 14.72           N  
ATOM   1817  CA  TYR A 247      72.519  26.261  65.413  1.00 13.19           C  
ATOM   1818  C   TYR A 247      73.958  26.734  65.302  1.00 14.07           C  
ATOM   1819  O   TYR A 247      74.207  27.877  64.930  1.00 15.30           O  
ATOM   1820  CB  TYR A 247      71.893  26.251  64.017  1.00 10.03           C  
ATOM   1821  CG  TYR A 247      70.593  25.469  63.896  1.00 10.79           C  
ATOM   1822  CD1 TYR A 247      69.752  25.645  62.798  1.00 10.59           C  
ATOM   1823  CD2 TYR A 247      70.231  24.518  64.845  1.00  9.17           C  
ATOM   1824  CE1 TYR A 247      68.591  24.893  62.649  1.00 11.19           C  
ATOM   1825  CE2 TYR A 247      69.075  23.761  64.699  1.00  9.39           C  
ATOM   1826  CZ  TYR A 247      68.264  23.954  63.600  1.00 10.28           C  
ATOM   1827  OH  TYR A 247      67.124  23.196  63.449  1.00 16.71           O  
ATOM   1828  N   ASN A 248      74.900  25.850  65.610  1.00 13.65           N  
ATOM   1829  CA  ASN A 248      76.314  26.186  65.538  1.00 16.85           C  
ATOM   1830  C   ASN A 248      76.868  26.046  64.125  1.00 18.74           C  
ATOM   1831  O   ASN A 248      76.773  24.971  63.520  1.00 22.45           O  
ATOM   1832  CB  ASN A 248      77.121  25.282  66.473  1.00 17.50           C  
ATOM   1833  CG  ASN A 248      76.841  25.553  67.937  1.00 19.69           C  
ATOM   1834  OD1 ASN A 248      75.888  26.253  68.286  1.00 18.80           O  
ATOM   1835  ND2 ASN A 248      77.673  24.990  68.807  1.00 21.89           N  
ATOM   1836  N   VAL A 249      77.438  27.130  63.603  1.00 18.57           N  
ATOM   1837  CA  VAL A 249      78.052  27.130  62.275  1.00 18.70           C  
ATOM   1838  C   VAL A 249      79.464  27.625  62.553  1.00 20.64           C  
ATOM   1839  O   VAL A 249      79.804  28.773  62.268  1.00 22.16           O  
ATOM   1840  CB  VAL A 249      77.328  28.095  61.304  1.00 18.65           C  
ATOM   1841  CG1 VAL A 249      77.947  27.993  59.901  1.00 18.55           C  
ATOM   1842  CG2 VAL A 249      75.847  27.753  61.238  1.00 15.89           C  
ATOM   1843  N   ASP A 250      80.281  26.729  63.104  1.00 21.03           N  
ATOM   1844  CA  ASP A 250      81.637  27.046  63.533  1.00 21.01           C  
ATOM   1845  C   ASP A 250      82.741  26.087  63.076  1.00 21.15           C  
ATOM   1846  O   ASP A 250      83.776  25.990  63.738  1.00 20.51           O  
ATOM   1847  CB  ASP A 250      81.633  27.057  65.053  1.00 23.83           C  
ATOM   1848  CG  ASP A 250      81.228  25.698  65.630  1.00 27.33           C  
ATOM   1849  OD1 ASP A 250      80.918  25.601  66.839  1.00 28.60           O  
ATOM   1850  OD2 ASP A 250      81.224  24.712  64.858  1.00 28.72           O  
ATOM   1851  N   GLY A 251      82.530  25.363  61.980  1.00 20.11           N  
ATOM   1852  CA  GLY A 251      83.554  24.439  61.512  1.00 17.10           C  
ATOM   1853  C   GLY A 251      83.951  23.372  62.526  1.00 18.53           C  
ATOM   1854  O   GLY A 251      85.058  22.820  62.467  1.00 17.43           O  
ATOM   1855  N   GLY A 252      83.058  23.086  63.469  1.00 18.10           N  
ATOM   1856  CA  GLY A 252      83.337  22.070  64.464  1.00 19.73           C  
ATOM   1857  C   GLY A 252      83.910  22.569  65.781  1.00 23.83           C  
ATOM   1858  O   GLY A 252      84.193  21.760  66.674  1.00 22.71           O  
ATOM   1859  N   ASN A 253      84.077  23.885  65.920  1.00 25.53           N  
ATOM   1860  CA  ASN A 253      84.634  24.459  67.148  1.00 25.63           C  
ATOM   1861  C   ASN A 253      83.910  24.021  68.419  1.00 24.79           C  
ATOM   1862  O   ASN A 253      84.534  23.781  69.451  1.00 25.09           O  
ATOM   1863  CB  ASN A 253      84.651  25.980  67.048  1.00 27.95           C  
ATOM   1864  CG  ASN A 253      86.043  26.542  67.203  1.00 32.16           C  
ATOM   1865  OD1 ASN A 253      87.015  25.938  66.745  1.00 33.89           O  
ATOM   1866  ND2 ASN A 253      86.154  27.705  67.841  1.00 33.82           N  
ATOM   1867  N   TRP A 254      82.590  23.924  68.351  1.00 23.58           N  
ATOM   1868  CA  TRP A 254      81.811  23.475  69.492  1.00 23.49           C  
ATOM   1869  C   TRP A 254      80.699  22.570  68.971  1.00 24.70           C  
ATOM   1870  O   TRP A 254      80.125  22.825  67.914  1.00 25.29           O  
ATOM   1871  CB  TRP A 254      81.228  24.669  70.256  1.00 23.33           C  
ATOM   1872  CG  TRP A 254      80.701  24.267  71.591  1.00 18.89           C  
ATOM   1873  CD1 TRP A 254      79.399  24.048  71.927  1.00 19.59           C  
ATOM   1874  CD2 TRP A 254      81.475  23.951  72.750  1.00 18.21           C  
ATOM   1875  NE1 TRP A 254      79.311  23.611  73.228  1.00 18.41           N  
ATOM   1876  CE2 TRP A 254      80.573  23.541  73.756  1.00 19.37           C  
ATOM   1877  CE3 TRP A 254      82.847  23.970  73.036  1.00 17.89           C  
ATOM   1878  CZ2 TRP A 254      80.996  23.158  75.035  1.00 19.13           C  
ATOM   1879  CZ3 TRP A 254      83.268  23.589  74.303  1.00 19.67           C  
ATOM   1880  CH2 TRP A 254      82.345  23.186  75.288  1.00 20.58           C  
ATOM   1881  N   MET A 255      80.384  21.513  69.708  1.00 26.34           N  
ATOM   1882  CA  MET A 255      79.367  20.574  69.248  1.00 27.93           C  
ATOM   1883  C   MET A 255      78.095  20.550  70.074  1.00 27.64           C  
ATOM   1884  O   MET A 255      78.109  20.175  71.246  1.00 29.54           O  
ATOM   1885  CB  MET A 255      79.966  19.176  69.200  1.00 28.54           C  
ATOM   1886  CG  MET A 255      81.273  19.114  68.437  1.00 30.99           C  
ATOM   1887  SD  MET A 255      82.072  17.537  68.727  1.00 34.74           S  
ATOM   1888  CE  MET A 255      82.772  17.815  70.351  1.00 35.45           C  
ATOM   1889  N   SER A 256      76.985  20.923  69.446  1.00 26.90           N  
ATOM   1890  CA  SER A 256      75.702  20.954  70.131  1.00 28.27           C  
ATOM   1891  C   SER A 256      74.665  20.131  69.369  1.00 28.44           C  
ATOM   1892  O   SER A 256      75.047  19.549  68.336  1.00 28.92           O  
ATOM   1893  CB  SER A 256      75.228  22.409  70.275  1.00 28.64           C  
ATOM   1894  OG  SER A 256      76.200  23.191  70.958  1.00 28.28           O  
ATOM   1895  OXT SER A 256      73.497  20.075  69.808  1.00 27.92           O  
TER    1896      SER A 256                                                      
END
MOLECULE T0511.pdb
ATOM   3951  N   MET     1      62.597  29.220  47.107  1.00 30.67           N  
ATOM   3952  CA  MET     1      62.845  29.811  48.467  1.00 29.57           C  
ATOM   3953  C   MET     1      63.620  31.132  48.359  1.00 27.36           C  
ATOM   3954  O   MET     1      64.850  31.137  48.239  1.00 28.85           O  
ATOM   3955  CB  MET     1      63.591  28.807  49.357  1.00 29.94           C  
ATOM   3956  N   THR     2      62.877  32.239  48.391  1.00 25.23           N  
ATOM   3957  CA  THR     2      63.403  33.587  48.132  1.00 22.67           C  
ATOM   3958  C   THR     2      62.942  34.592  49.198  1.00 18.88           C  
ATOM   3959  O   THR     2      61.858  34.461  49.757  1.00 18.29           O  
ATOM   3960  CB  THR     2      62.903  34.135  46.760  1.00 23.35           C  
ATOM   3961  OG1 THR     2      63.359  35.463  46.573  1.00 25.88           O  
ATOM   3962  CG2 THR     2      61.378  34.171  46.691  1.00 26.28           C  
ATOM   3963  N   LEU     3      63.760  35.618  49.440  1.00 15.02           N  
ATOM   3964  CA  LEU     3      63.374  36.703  50.340  1.00 13.66           C  
ATOM   3965  C   LEU     3      62.820  37.921  49.572  1.00 13.56           C  
ATOM   3966  O   LEU     3      62.745  39.020  50.112  1.00 12.43           O  
ATOM   3967  CB  LEU     3      64.547  37.093  51.236  1.00 12.07           C  
ATOM   3968  CG  LEU     3      64.994  35.993  52.218  1.00 11.15           C  
ATOM   3969  CD1 LEU     3      66.181  36.444  53.005  1.00 13.04           C  
ATOM   3970  CD2 LEU     3      63.855  35.585  53.148  1.00 10.48           C  
ATOM   3971  N   SER     4      62.447  37.723  48.314  1.00 14.77           N  
ATOM   3972  CA  SER     4      61.853  38.795  47.519  1.00 15.97           C  
ATOM   3973  C   SER     4      60.660  39.433  48.243  1.00 15.52           C  
ATOM   3974  O   SER     4      59.745  38.745  48.654  1.00 16.06           O  
ATOM   3975  CB  SER     4      61.389  38.288  46.155  1.00 16.75           C  
ATOM   3976  OG  SER     4      60.927  39.377  45.373  1.00 20.08           O  
ATOM   3977  N   GLY     5      60.704  40.757  48.393  1.00 15.66           N  
ATOM   3978  CA  GLY     5      59.619  41.521  48.999  1.00 15.02           C  
ATOM   3979  C   GLY     5      59.535  41.413  50.510  1.00 14.21           C  
ATOM   3980  O   GLY     5      58.676  42.070  51.125  1.00 15.43           O  
ATOM   3981  N   LYS     6      60.352  40.543  51.108  1.00 11.75           N  
ATOM   3982  CA  LYS     6      60.416  40.422  52.563  0.50 11.20           C  
ATOM   3984  C   LYS     6      61.177  41.607  53.131  1.00 12.33           C  
ATOM   3985  O   LYS     6      62.113  42.107  52.491  1.00 12.97           O  
ATOM   3986  CB  LYS     6      61.116  39.131  52.979  0.50 10.32           C  
ATOM   3988  CG  LYS     6      60.442  37.856  52.511  0.50  9.52           C  
ATOM   3990  CD  LYS     6      59.018  37.773  53.017  0.50  8.56           C  
ATOM   3992  CE  LYS     6      58.396  36.430  52.773  0.50  9.59           C  
ATOM   3994  NZ  LYS     6      56.954  36.413  53.165  0.50  8.36           N  
ATOM   3996  N   THR     7      60.795  42.032  54.333  1.00 11.54           N  
ATOM   3997  CA  THR     7      61.404  43.157  54.998  1.00 10.57           C  
ATOM   3998  C   THR     7      62.191  42.674  56.216  1.00 10.31           C  
ATOM   3999  O   THR     7      61.606  42.122  57.185  1.00  8.12           O  
ATOM   4000  CB  THR     7      60.336  44.191  55.400  1.00 10.97           C  
ATOM   4001  OG1 THR     7      59.628  44.627  54.224  1.00 11.12           O  
ATOM   4002  CG2 THR     7      60.981  45.397  56.117  1.00 11.35           C  
ATOM   4003  N   LEU     8      63.515  42.880  56.149  1.00  9.48           N  
ATOM   4004  CA  LEU     8      64.441  42.550  57.221  1.00  9.12           C  
ATOM   4005  C   LEU     8      64.855  43.800  57.995  1.00 10.02           C  
ATOM   4006  O   LEU     8      65.154  44.847  57.421  1.00  9.93           O  
ATOM   4007  CB  LEU     8      65.726  41.895  56.666  1.00  8.69           C  
ATOM   4008  CG  LEU     8      65.617  40.506  56.031  1.00  8.91           C  
ATOM   4009  CD1 LEU     8      64.948  40.526  54.667  1.00  9.80           C  
ATOM   4010  CD2 LEU     8      67.019  39.850  55.945  1.00 10.15           C  
ATOM   4011  N   PHE     9      64.864  43.671  59.311  1.00 10.64           N  
ATOM   4012  CA  PHE     9      65.393  44.701  60.193  1.00  9.82           C  
ATOM   4013  C   PHE     9      66.642  44.075  60.792  1.00 10.33           C  
ATOM   4014  O   PHE     9      66.556  43.086  61.518  1.00  9.34           O  
ATOM   4015  CB  PHE     9      64.353  45.039  61.271  1.00 11.76           C  
ATOM   4016  CG  PHE     9      64.736  46.193  62.169  1.00 11.01           C  
ATOM   4017  CD1 PHE     9      64.214  47.476  61.952  1.00 11.20           C  
ATOM   4018  CD2 PHE     9      65.612  45.997  63.246  1.00 11.20           C  
ATOM   4019  CE1 PHE     9      64.545  48.541  62.804  1.00 12.34           C  
ATOM   4020  CE2 PHE     9      65.972  47.059  64.072  1.00 11.47           C  
ATOM   4021  CZ  PHE     9      65.421  48.337  63.851  1.00 12.34           C  
ATOM   4022  N   ILE    10      67.804  44.632  60.449  1.00  9.68           N  
ATOM   4023  CA  ILE    10      69.085  44.043  60.842  1.00  8.82           C  
ATOM   4024  C   ILE    10      69.875  45.048  61.639  1.00  9.31           C  
ATOM   4025  O   ILE    10      70.190  46.135  61.158  1.00  8.86           O  
ATOM   4026  CB  ILE    10      69.954  43.569  59.614  1.00  8.91           C  
ATOM   4027  CG1 ILE    10      69.161  42.655  58.682  1.00  9.64           C  
ATOM   4028  CG2 ILE    10      71.253  42.869  60.098  1.00  9.55           C  
ATOM   4029  CD1 ILE    10      69.891  42.285  57.434  1.00  8.87           C  
ATOM   4030  N   THR    11      70.176  44.703  62.881  1.00  9.12           N  
ATOM   4031  CA  THR    11      71.002  45.584  63.719  1.00 10.75           C  
ATOM   4032  C   THR    11      72.490  45.424  63.375  1.00 10.49           C  
ATOM   4033  O   THR    11      72.965  44.333  63.011  1.00 12.33           O  
ATOM   4034  CB  THR    11      70.774  45.336  65.236  1.00 11.13           C  
ATOM   4035  OG1 THR    11      71.224  44.025  65.597  1.00  9.91           O  
ATOM   4036  CG2 THR    11      69.289  45.513  65.589  1.00 11.16           C  
ATOM   4037  N   GLY    12      73.205  46.541  63.433  1.00 11.26           N  
ATOM   4038  CA  GLY    12      74.650  46.585  63.240  1.00 11.66           C  
ATOM   4039  C   GLY    12      75.115  46.237  61.835  1.00 12.20           C  
ATOM   4040  O   GLY    12      76.236  45.796  61.663  1.00 14.31           O  
ATOM   4041  N   ALA    13      74.276  46.482  60.830  1.00 10.74           N  
ATOM   4042  CA  ALA    13      74.524  46.028  59.465  1.00 10.80           C  
ATOM   4043  C   ALA    13      75.251  47.052  58.569  1.00  9.89           C  
ATOM   4044  O   ALA    13      75.175  46.977  57.349  1.00 10.74           O  
ATOM   4045  CB  ALA    13      73.213  45.535  58.805  1.00 12.85           C  
ATOM   4046  N   SER    14      75.957  47.997  59.175  1.00 12.09           N  
ATOM   4047  CA  SER    14      76.826  48.908  58.410  1.00 13.18           C  
ATOM   4048  C   SER    14      78.103  48.221  57.906  1.00 13.87           C  
ATOM   4049  O   SER    14      78.781  48.720  56.992  1.00 14.18           O  
ATOM   4050  CB  SER    14      77.178  50.138  59.246  1.00 14.38           C  
ATOM   4051  OG  SER    14      77.783  49.759  60.460  1.00 17.14           O  
ATOM   4052  N   ARG    15      78.431  47.075  58.494  1.00 13.35           N  
ATOM   4053  CA  ARG    15      79.640  46.338  58.149  1.00 13.18           C  
ATOM   4054  C   ARG    15      79.528  44.878  58.620  1.00 13.07           C  
ATOM   4055  O   ARG    15      78.533  44.479  59.249  1.00 11.22           O  
ATOM   4056  CB  ARG    15      80.874  47.012  58.788  1.00 14.09           C  
ATOM   4057  CG  ARG    15      80.918  46.971  60.285  1.00 14.31           C  
ATOM   4058  CD  ARG    15      82.066  47.857  60.818  1.00 17.37           C  
ATOM   4059  NE  ARG    15      81.762  49.280  60.653  1.00 20.79           N  
ATOM   4060  CZ  ARG    15      81.012  49.990  61.486  1.00 20.72           C  
ATOM   4061  NH1 ARG    15      80.496  49.435  62.579  1.00 22.67           N  
ATOM   4062  NH2 ARG    15      80.782  51.263  61.236  1.00 20.56           N  
ATOM   4063  N   GLY    16      80.556  44.099  58.288  1.00 11.96           N  
ATOM   4064  CA  GLY    16      80.736  42.761  58.825  1.00 12.69           C  
ATOM   4065  C   GLY    16      79.604  41.803  58.491  1.00 10.91           C  
ATOM   4066  O   GLY    16      79.052  41.809  57.374  1.00 10.91           O  
ATOM   4067  N   ILE    17      79.280  40.958  59.460  1.00 11.51           N  
ATOM   4068  CA  ILE    17      78.291  39.912  59.250  1.00  9.32           C  
ATOM   4069  C   ILE    17      76.913  40.500  58.910  1.00  8.38           C  
ATOM   4070  O   ILE    17      76.253  40.004  58.023  1.00  7.43           O  
ATOM   4071  CB  ILE    17      78.222  38.953  60.470  1.00  9.84           C  
ATOM   4072  CG1 ILE    17      79.519  38.155  60.560  1.00 10.94           C  
ATOM   4073  CG2 ILE    17      77.030  37.970  60.375  1.00 10.76           C  
ATOM   4074  CD1 ILE    17      79.657  37.339  61.859  1.00 12.58           C  
ATOM   4075  N   GLY    18      76.494  41.539  59.618  1.00  8.76           N  
ATOM   4076  CA  GLY    18      75.170  42.138  59.368  1.00  8.15           C  
ATOM   4077  C   GLY    18      75.044  42.616  57.936  1.00  7.27           C  
ATOM   4078  O   GLY    18      74.060  42.340  57.263  1.00  8.56           O  
ATOM   4079  N   LEU    19      76.062  43.340  57.467  1.00  7.75           N  
ATOM   4080  CA  LEU    19      76.102  43.810  56.092  1.00  9.23           C  
ATOM   4081  C   LEU    19      76.014  42.632  55.116  1.00  8.73           C  
ATOM   4082  O   LEU    19      75.266  42.671  54.144  1.00  9.26           O  
ATOM   4083  CB  LEU    19      77.365  44.651  55.841  1.00  8.49           C  
ATOM   4084  CG  LEU    19      77.475  45.222  54.395  1.00  8.05           C  
ATOM   4085  CD1 LEU    19      76.268  46.087  54.030  1.00 11.07           C  
ATOM   4086  CD2 LEU    19      78.799  45.972  54.238  1.00 11.71           C  
ATOM   4087  N   ALA    20      76.790  41.575  55.363  1.00  8.21           N  
ATOM   4088  CA  ALA    20      76.818  40.418  54.466  1.00  8.31           C  
ATOM   4089  C   ALA    20      75.430  39.785  54.378  1.00  7.74           C  
ATOM   4090  O   ALA    20      74.958  39.458  53.296  1.00  8.04           O  
ATOM   4091  CB  ALA    20      77.848  39.389  54.944  1.00  9.02           C  
ATOM   4092  N   ILE    21      74.772  39.669  55.523  1.00  8.02           N  
ATOM   4093  CA  ILE    21      73.404  39.147  55.571  1.00  8.70           C  
ATOM   4094  C   ILE    21      72.490  40.086  54.769  1.00  8.63           C  
ATOM   4095  O   ILE    21      71.714  39.628  53.907  1.00  8.84           O  
ATOM   4096  CB  ILE    21      72.906  38.984  57.042  1.00  9.05           C  
ATOM   4097  CG1 ILE    21      73.668  37.891  57.784  1.00  7.45           C  
ATOM   4098  CG2 ILE    21      71.394  38.697  57.078  1.00  9.46           C  
ATOM   4099  CD1 ILE    21      73.339  37.846  59.303  1.00  8.85           C  
ATOM   4100  N   ALA    22      72.600  41.392  55.039  1.00  9.08           N  
ATOM   4101  CA  ALA    22      71.824  42.423  54.318  1.00  9.76           C  
ATOM   4102  C   ALA    22      71.958  42.242  52.788  1.00  8.59           C  
ATOM   4103  O   ALA    22      70.958  42.201  52.041  1.00  9.38           O  
ATOM   4104  CB  ALA    22      72.254  43.834  54.777  1.00  7.10           C  
ATOM   4105  N   LEU    23      73.188  42.058  52.311  1.00  8.83           N  
ATOM   4106  CA  LEU    23      73.424  41.979  50.858  1.00  9.35           C  
ATOM   4107  C   LEU    23      72.947  40.652  50.243  1.00  8.93           C  
ATOM   4108  O   LEU    23      72.440  40.619  49.090  1.00  8.82           O  
ATOM   4109  CB  LEU    23      74.888  42.229  50.554  1.00  9.38           C  
ATOM   4110  CG  LEU    23      75.440  43.596  50.959  1.00  9.38           C  
ATOM   4111  CD1 LEU    23      76.913  43.699  50.547  1.00 11.14           C  
ATOM   4112  CD2 LEU    23      74.585  44.776  50.392  1.00 12.49           C  
ATOM   4113  N   ARG    24      73.082  39.565  50.998  1.00  6.98           N  
ATOM   4114  CA  ARG    24      72.578  38.277  50.524  1.00 10.03           C  
ATOM   4115  C   ARG    24      71.052  38.351  50.351  1.00  9.92           C  
ATOM   4116  O   ARG    24      70.492  37.887  49.372  1.00 10.75           O  
ATOM   4117  CB  ARG    24      72.987  37.137  51.457  1.00 10.79           C  
ATOM   4118  CG  ARG    24      72.449  35.755  51.043  1.00 11.75           C  
ATOM   4119  CD  ARG    24      72.954  35.280  49.687  1.00 13.28           C  
ATOM   4120  NE  ARG    24      72.271  34.075  49.201  1.00 14.92           N  
ATOM   4121  CZ  ARG    24      71.136  34.057  48.499  1.00 13.41           C  
ATOM   4122  NH1 ARG    24      70.480  35.166  48.186  1.00 14.16           N  
ATOM   4123  NH2 ARG    24      70.644  32.898  48.090  1.00 15.36           N  
ATOM   4124  N   ALA    25      70.367  38.988  51.291  1.00  8.74           N  
ATOM   4125  CA  ALA    25      68.899  39.152  51.191  1.00  9.90           C  
ATOM   4126  C   ALA    25      68.517  40.102  50.028  1.00  9.92           C  
ATOM   4127  O   ALA    25      67.538  39.866  49.286  1.00 11.82           O  
ATOM   4128  CB  ALA    25      68.380  39.677  52.518  1.00  9.28           C  
ATOM   4129  N   ALA    26      69.281  41.190  49.901  1.00  9.89           N  
ATOM   4130  CA  ALA    26      69.099  42.193  48.822  1.00 10.10           C  
ATOM   4131  C   ALA    26      69.116  41.544  47.458  1.00 10.34           C  
ATOM   4132  O   ALA    26      68.316  41.889  46.578  1.00 11.34           O  
ATOM   4133  CB  ALA    26      70.148  43.259  48.872  1.00  9.94           C  
ATOM   4134  N   ARG    27      70.003  40.570  47.281  1.00 11.84           N  
ATOM   4135  CA  ARG    27      70.155  39.864  46.000  1.00 13.94           C  
ATOM   4136  C   ARG    27      68.850  39.211  45.538  1.00 14.38           C  
ATOM   4137  O   ARG    27      68.580  39.114  44.346  1.00 15.05           O  
ATOM   4138  CB  ARG    27      71.266  38.815  46.191  1.00 15.14           C  
ATOM   4139  CG  ARG    27      71.710  38.069  45.005  1.00 21.23           C  
ATOM   4140  CD  ARG    27      73.119  37.495  45.280  1.00 26.32           C  
ATOM   4141  NE  ARG    27      73.145  36.075  45.602  1.00 28.22           N  
ATOM   4142  CZ  ARG    27      74.087  35.472  46.333  1.00 29.94           C  
ATOM   4143  NH1 ARG    27      75.079  36.153  46.912  1.00 32.75           N  
ATOM   4144  NH2 ARG    27      74.015  34.172  46.523  1.00 31.76           N  
ATOM   4145  N   ASP    28      68.049  38.792  46.506  1.00 13.10           N  
ATOM   4146  CA  ASP    28      66.720  38.247  46.269  1.00 12.77           C  
ATOM   4147  C   ASP    28      65.638  39.307  46.007  1.00 12.75           C  
ATOM   4148  O   ASP    28      64.503  38.943  45.651  1.00 13.44           O  
ATOM   4149  CB  ASP    28      66.255  37.451  47.495  1.00 13.05           C  
ATOM   4150  CG  ASP    28      66.843  36.066  47.599  1.00 13.32           C  
ATOM   4151  OD1 ASP    28      67.775  35.704  46.843  1.00 14.41           O  
ATOM   4152  OD2 ASP    28      66.355  35.322  48.480  1.00 12.54           O  
ATOM   4153  N   GLY    29      65.935  40.587  46.231  1.00 10.11           N  
ATOM   4154  CA  GLY    29      64.912  41.654  46.146  1.00  9.93           C  
ATOM   4155  C   GLY    29      64.262  41.985  47.473  1.00 10.64           C  
ATOM   4156  O   GLY    29      63.130  42.494  47.518  1.00 12.32           O  
ATOM   4157  N   ALA    30      64.952  41.686  48.574  1.00  9.58           N  
ATOM   4158  CA  ALA    30      64.396  41.970  49.897  1.00  9.95           C  
ATOM   4159  C   ALA    30      64.521  43.470  50.182  1.00 10.01           C  
ATOM   4160  O   ALA    30      65.433  44.163  49.651  1.00  9.43           O  
ATOM   4161  CB  ALA    30      65.097  41.183  50.977  1.00  9.59           C  
ATOM   4162  N   ASN    31      63.610  43.950  51.029  1.00  9.52           N  
ATOM   4163  CA  ASN    31      63.752  45.233  51.686  1.00  9.86           C  
ATOM   4164  C   ASN    31      64.600  45.024  52.924  1.00  8.84           C  
ATOM   4165  O   ASN    31      64.373  44.084  53.690  1.00 10.54           O  
ATOM   4166  CB  ASN    31      62.386  45.773  52.119  1.00 10.20           C  
ATOM   4167  CG  ASN    31      61.383  45.795  50.986  1.00  9.19           C  
ATOM   4168  OD1 ASN    31      61.670  46.332  49.919  1.00 10.33           O  
ATOM   4169  ND2 ASN    31      60.167  45.261  51.237  1.00 10.75           N  
ATOM   4170  N   VAL    32      65.590  45.887  53.116  1.00  9.95           N  
ATOM   4171  CA  VAL    32      66.461  45.789  54.290  1.00  9.69           C  
ATOM   4172  C   VAL    32      66.596  47.133  55.012  1.00 10.30           C  
ATOM   4173  O   VAL    32      67.058  48.133  54.432  1.00 12.03           O  
ATOM   4174  CB  VAL    32      67.879  45.251  53.949  1.00  9.18           C  
ATOM   4175  CG1 VAL    32      68.643  44.975  55.249  1.00 11.10           C  
ATOM   4176  CG2 VAL    32      67.819  43.969  53.119  1.00 10.00           C  
ATOM   4177  N   ALA    33      66.191  47.150  56.277  1.00  9.49           N  
ATOM   4178  CA  ALA    33      66.381  48.263  57.162  1.00  9.13           C  
ATOM   4179  C   ALA    33      67.703  48.031  57.943  1.00 11.03           C  
ATOM   4180  O   ALA    33      67.848  47.054  58.690  1.00 10.96           O  
ATOM   4181  CB  ALA    33      65.140  48.420  58.106  1.00 10.39           C  
ATOM   4182  N   ILE    34      68.660  48.914  57.698  1.00  9.27           N  
ATOM   4183  CA  ILE    34      69.978  48.897  58.327  1.00 10.73           C  
ATOM   4184  C   ILE    34      69.911  49.779  59.555  1.00 10.74           C  
ATOM   4185  O   ILE    34      69.866  51.014  59.440  1.00 11.32           O  
ATOM   4186  CB  ILE    34      71.055  49.446  57.365  1.00 11.56           C  
ATOM   4187  CG1 ILE    34      71.079  48.663  56.046  1.00 12.76           C  
ATOM   4188  CG2 ILE    34      72.425  49.488  58.059  1.00 11.82           C  
ATOM   4189  CD1 ILE    34      71.623  47.273  56.171  1.00 15.51           C  
ATOM   4190  N   ALA    35      69.864  49.164  60.736  1.00 10.80           N  
ATOM   4191  CA  ALA    35      69.718  49.912  61.976  1.00 11.12           C  
ATOM   4192  C   ALA    35      71.054  49.915  62.714  1.00 12.35           C  
ATOM   4193  O   ALA    35      71.424  48.949  63.376  1.00 13.49           O  
ATOM   4194  CB  ALA    35      68.600  49.344  62.835  1.00 10.58           C  
ATOM   4195  N   ALA    36      71.772  51.019  62.600  1.00 12.61           N  
ATOM   4196  CA  ALA    36      73.119  51.086  63.144  1.00 13.43           C  
ATOM   4197  C   ALA    36      73.496  52.524  63.496  1.00 13.74           C  
ATOM   4198  O   ALA    36      72.828  53.477  63.065  1.00 11.72           O  
ATOM   4199  CB  ALA    36      74.102  50.509  62.158  1.00 11.42           C  
ATOM   4200  N   LYS    37      74.546  52.664  64.302  1.00 15.75           N  
ATOM   4201  CA  LYS    37      74.869  53.965  64.885  1.00 18.51           C  
ATOM   4202  C   LYS    37      75.644  54.902  63.963  1.00 18.21           C  
ATOM   4203  O   LYS    37      75.478  56.117  64.075  1.00 20.01           O  
ATOM   4204  CB  LYS    37      75.588  53.840  66.239  1.00 19.73           C  
ATOM   4205  CG  LYS    37      76.782  52.938  66.266  1.00 23.33           C  
ATOM   4206  CD  LYS    37      77.700  53.212  67.466  1.00 23.66           C  
ATOM   4207  CE  LYS    37      76.944  53.327  68.751  1.00 26.80           C  
ATOM   4208  NZ  LYS    37      76.411  54.714  68.945  1.00 28.42           N  
ATOM   4209  N   SER    38      76.463  54.352  63.059  1.00 18.12           N  
ATOM   4210  CA  SER    38      77.373  55.149  62.238  1.00 18.53           C  
ATOM   4211  C   SER    38      76.720  55.723  60.995  1.00 16.90           C  
ATOM   4212  O   SER    38      76.342  54.974  60.108  1.00 15.01           O  
ATOM   4213  CB  SER    38      78.574  54.307  61.790  1.00 19.20           C  
ATOM   4214  OG  SER    38      79.300  53.812  62.899  1.00 23.44           O  
ATOM   4215  N   ALA    39      76.652  57.057  60.934  1.00 17.63           N  
ATOM   4216  CA  ALA    39      76.100  57.802  59.800  1.00 17.44           C  
ATOM   4217  C   ALA    39      77.184  58.388  58.894  1.00 16.14           C  
ATOM   4218  O   ALA    39      76.980  58.563  57.700  1.00 16.68           O  
ATOM   4219  CB  ALA    39      75.168  58.905  60.301  1.00 18.43           C  
ATOM   4220  N   VAL    40      78.356  58.669  59.449  1.00 17.49           N  
ATOM   4221  CA  VAL    40      79.479  59.194  58.661  1.00 18.46           C  
ATOM   4222  C   VAL    40      80.694  58.310  58.896  1.00 20.70           C  
ATOM   4223  O   VAL    40      80.839  57.741  59.976  1.00 21.01           O  
ATOM   4224  CB  VAL    40      79.805  60.654  59.054  1.00 18.94           C  
ATOM   4225  CG1 VAL    40      78.557  61.514  58.972  1.00 17.23           C  
ATOM   4226  CG2 VAL    40      80.365  60.716  60.433  1.00 21.03           C  
ATOM   4227  N   ALA    41      81.549  58.211  57.880  1.00 23.79           N  
ATOM   4228  CA  ALA    41      82.672  57.275  57.846  1.00 27.02           C  
ATOM   4229  C   ALA    41      83.886  57.766  58.628  1.00 30.16           C  
ATOM   4230  O   ALA    41      84.101  58.958  58.765  1.00 29.60           O  
ATOM   4231  CB  ALA    41      83.078  57.029  56.414  1.00 26.45           C  
ATOM   4232  N   ASN    42      84.686  56.826  59.121  1.00 34.39           N  
ATOM   4233  CA  ASN    42      85.982  57.137  59.736  1.00 37.35           C  
ATOM   4234  C   ASN    42      87.024  56.189  59.163  1.00 37.86           C  
ATOM   4235  O   ASN    42      86.663  55.114  58.676  1.00 37.47           O  
ATOM   4236  CB  ASN    42      85.905  56.978  61.255  1.00 38.97           C  
ATOM   4237  CG  ASN    42      85.984  55.535  61.686  1.00 41.85           C  
ATOM   4238  OD1 ASN    42      85.250  54.679  61.176  1.00 45.32           O  
ATOM   4239  ND2 ASN    42      86.880  55.246  62.619  1.00 44.83           N  
ATOM   4240  N   PRO    43      88.319  56.571  59.222  1.00 39.25           N  
ATOM   4241  CA  PRO    43      89.357  55.734  58.596  1.00 39.71           C  
ATOM   4242  C   PRO    43      89.487  54.349  59.225  1.00 40.22           C  
ATOM   4243  O   PRO    43      89.883  53.401  58.539  1.00 41.70           O  
ATOM   4244  CB  PRO    43      90.651  56.529  58.828  1.00 40.04           C  
ATOM   4245  CG  PRO    43      90.363  57.413  59.989  1.00 40.12           C  
ATOM   4246  CD  PRO    43      88.895  57.761  59.874  1.00 39.62           C  
ATOM   4247  N   LYS    44      89.146  54.243  60.511  1.00 40.29           N  
ATOM   4248  CA  LYS    44      89.455  53.057  61.315  1.00 40.44           C  
ATOM   4249  C   LYS    44      88.515  51.890  61.049  1.00 40.27           C  
ATOM   4250  O   LYS    44      88.956  50.741  60.928  1.00 41.53           O  
ATOM   4251  CB  LYS    44      89.431  53.404  62.812  1.00 40.80           C  
ATOM   4252  N   LEU    45      87.222  52.178  60.972  1.00 39.05           N  
ATOM   4253  CA  LEU    45      86.218  51.131  60.866  1.00 37.50           C  
ATOM   4254  C   LEU    45      85.167  51.541  59.838  1.00 35.61           C  
ATOM   4255  O   LEU    45      84.102  52.037  60.207  1.00 36.83           O  
ATOM   4256  CB  LEU    45      85.583  50.908  62.238  1.00 38.08           C  
ATOM   4257  CG  LEU    45      84.656  49.705  62.386  1.00 39.22           C  
ATOM   4258  CD1 LEU    45      85.288  48.424  61.838  1.00 39.99           C  
ATOM   4259  CD2 LEU    45      84.277  49.533  63.845  1.00 40.21           C  
ATOM   4260  N   PRO    46      85.479  51.367  58.541  1.00 32.57           N  
ATOM   4261  CA  PRO    46      84.580  51.804  57.478  1.00 29.62           C  
ATOM   4262  C   PRO    46      83.181  51.163  57.498  1.00 25.47           C  
ATOM   4263  O   PRO    46      82.966  50.062  58.098  1.00 22.97           O  
ATOM   4264  CB  PRO    46      85.322  51.403  56.192  1.00 30.51           C  
ATOM   4265  CG  PRO    46      86.752  51.314  56.592  1.00 31.69           C  
ATOM   4266  CD  PRO    46      86.721  50.787  57.993  1.00 32.59           C  
ATOM   4267  N   GLY    47      82.267  51.872  56.828  1.00 20.24           N  
ATOM   4268  CA  GLY    47      80.893  51.466  56.666  1.00 17.13           C  
ATOM   4269  C   GLY    47      79.945  52.339  57.470  1.00 14.78           C  
ATOM   4270  O   GLY    47      80.178  52.610  58.646  1.00 14.21           O  
ATOM   4271  N   THR    48      78.845  52.748  56.854  1.00 12.11           N  
ATOM   4272  CA  THR    48      77.836  53.553  57.539  1.00 11.85           C  
ATOM   4273  C   THR    48      76.458  52.991  57.179  1.00 10.89           C  
ATOM   4274  O   THR    48      76.335  52.132  56.293  1.00 10.28           O  
ATOM   4275  CB  THR    48      77.887  55.017  57.087  1.00 11.91           C  
ATOM   4276  OG1 THR    48      77.440  55.084  55.728  1.00 11.31           O  
ATOM   4277  CG2 THR    48      79.309  55.580  57.219  1.00 10.23           C  
ATOM   4278  N   ILE    49      75.412  53.500  57.823  1.00 10.85           N  
ATOM   4279  CA  ILE    49      74.050  53.133  57.457  1.00 11.77           C  
ATOM   4280  C   ILE    49      73.758  53.496  55.991  1.00 11.48           C  
ATOM   4281  O   ILE    49      73.063  52.789  55.301  1.00 10.88           O  
ATOM   4282  CB  ILE    49      73.019  53.765  58.417  1.00 11.13           C  
ATOM   4283  CG1 ILE    49      73.116  55.306  58.420  1.00 10.53           C  
ATOM   4284  CG2 ILE    49      73.243  53.212  59.835  1.00 10.06           C  
ATOM   4285  CD1 ILE    49      72.142  56.006  59.385  1.00 12.06           C  
ATOM   4286  N   HIS    50      74.347  54.586  55.520  1.00 10.00           N  
ATOM   4287  CA  HIS    50      74.122  55.053  54.160  1.00 10.47           C  
ATOM   4288  C   HIS    50      74.872  54.216  53.113  1.00 10.35           C  
ATOM   4289  O   HIS    50      74.304  53.925  52.051  1.00 11.27           O  
ATOM   4290  CB  HIS    50      74.479  56.543  54.077  1.00 10.80           C  
ATOM   4291  CG  HIS    50      73.675  57.392  55.011  1.00 10.97           C  
ATOM   4292  ND1 HIS    50      72.304  57.486  54.923  1.00 12.42           N  
ATOM   4293  CD2 HIS    50      74.036  58.151  56.066  1.00 12.09           C  
ATOM   4294  CE1 HIS    50      71.858  58.265  55.888  1.00 12.60           C  
ATOM   4295  NE2 HIS    50      72.886  58.688  56.595  1.00 14.34           N  
ATOM   4296  N   SER    51      76.128  53.849  53.374  1.00 11.13           N  
ATOM   4297  CA  SER    51      76.866  53.008  52.407  1.00 11.05           C  
ATOM   4298  C   SER    51      76.184  51.617  52.353  1.00  9.62           C  
ATOM   4299  O   SER    51      76.037  51.007  51.281  1.00  9.84           O  
ATOM   4300  CB  SER    51      78.361  52.883  52.733  1.00 12.34           C  
ATOM   4301  OG  SER    51      78.583  52.345  54.001  1.00 11.91           O  
ATOM   4302  N   ALA    52      75.734  51.137  53.502  1.00  9.54           N  
ATOM   4303  CA  ALA    52      75.072  49.824  53.556  1.00  8.67           C  
ATOM   4304  C   ALA    52      73.733  49.851  52.804  1.00  9.08           C  
ATOM   4305  O   ALA    52      73.465  48.990  51.965  1.00 10.29           O  
ATOM   4306  CB  ALA    52      74.886  49.382  54.995  1.00  9.27           C  
ATOM   4307  N   ALA    53      72.915  50.878  53.043  1.00  9.71           N  
ATOM   4308  CA  ALA    53      71.666  51.040  52.278  1.00 10.36           C  
ATOM   4309  C   ALA    53      71.901  51.167  50.763  1.00  9.96           C  
ATOM   4310  O   ALA    53      71.181  50.566  49.976  1.00 11.61           O  
ATOM   4311  CB  ALA    53      70.844  52.230  52.790  1.00 10.97           C  
ATOM   4312  N   ALA    54      72.926  51.924  50.366  1.00 11.88           N  
ATOM   4313  CA  ALA    54      73.297  52.057  48.954  1.00 12.31           C  
ATOM   4314  C   ALA    54      73.722  50.707  48.347  1.00 11.30           C  
ATOM   4315  O   ALA    54      73.353  50.386  47.208  1.00 10.08           O  
ATOM   4316  CB  ALA    54      74.431  53.098  48.806  1.00 12.56           C  
ATOM   4317  N   ALA    55      74.509  49.940  49.112  1.00 10.85           N  
ATOM   4318  CA  ALA    55      74.954  48.592  48.703  1.00  9.92           C  
ATOM   4319  C   ALA    55      73.773  47.608  48.516  1.00 10.77           C  
ATOM   4320  O   ALA    55      73.742  46.853  47.557  1.00 11.65           O  
ATOM   4321  CB  ALA    55      76.006  48.045  49.693  1.00 10.49           C  
ATOM   4322  N   VAL    56      72.799  47.650  49.430  1.00  9.59           N  
ATOM   4323  CA  VAL    56      71.557  46.882  49.316  1.00 10.13           C  
ATOM   4324  C   VAL    56      70.872  47.218  47.978  1.00  8.79           C  
ATOM   4325  O   VAL    56      70.487  46.331  47.219  1.00  8.66           O  
ATOM   4326  CB  VAL    56      70.633  47.138  50.532  1.00 10.01           C  
ATOM   4327  CG1 VAL    56      69.172  46.649  50.280  1.00  7.56           C  
ATOM   4328  CG2 VAL    56      71.197  46.518  51.814  1.00 10.51           C  
ATOM   4329  N   ASN    57      70.745  48.500  47.692  1.00  9.87           N  
ATOM   4330  CA  ASN    57      70.154  48.947  46.418  1.00 11.76           C  
ATOM   4331  C   ASN    57      70.955  48.418  45.217  1.00 11.67           C  
ATOM   4332  O   ASN    57      70.387  47.822  44.284  1.00 12.55           O  
ATOM   4333  CB  ASN    57      70.021  50.469  46.372  1.00 11.99           C  
ATOM   4334  CG  ASN    57      69.007  51.027  47.383  1.00 15.66           C  
ATOM   4335  OD1 ASN    57      68.032  50.360  47.782  1.00 12.64           O  
ATOM   4336  ND2 ASN    57      69.219  52.277  47.765  1.00 17.06           N  
ATOM   4337  N   ALA    58      72.277  48.567  45.274  1.00 12.94           N  
ATOM   4338  CA  ALA    58      73.156  48.118  44.189  1.00 13.57           C  
ATOM   4339  C   ALA    58      73.017  46.612  43.937  1.00 13.61           C  
ATOM   4340  O   ALA    58      73.109  46.169  42.796  1.00 16.13           O  
ATOM   4341  CB  ALA    58      74.614  48.476  44.510  1.00 13.21           C  
ATOM   4342  N   ALA    59      72.771  45.838  45.008  1.00 11.39           N  
ATOM   4343  CA  ALA    59      72.713  44.387  44.990  1.00 12.51           C  
ATOM   4344  C   ALA    59      71.383  43.821  44.486  1.00 12.62           C  
ATOM   4345  O   ALA    59      71.285  42.620  44.220  1.00 15.13           O  
ATOM   4346  CB  ALA    59      72.996  43.852  46.390  1.00 11.06           C  
ATOM   4347  N   GLY    60      70.378  44.682  44.403  1.00 12.64           N  
ATOM   4348  CA  GLY    60      69.046  44.314  43.915  1.00 13.60           C  
ATOM   4349  C   GLY    60      67.892  44.413  44.895  1.00 12.69           C  
ATOM   4350  O   GLY    60      66.779  43.988  44.575  1.00 14.43           O  
ATOM   4351  N   GLY    61      68.157  44.977  46.071  1.00 11.70           N  
ATOM   4352  CA  GLY    61      67.159  45.202  47.083  1.00 11.61           C  
ATOM   4353  C   GLY    61      66.769  46.649  47.284  1.00 10.76           C  
ATOM   4354  O   GLY    61      67.133  47.541  46.509  1.00 11.66           O  
ATOM   4355  N   GLN    62      65.997  46.875  48.342  1.00 10.13           N  
ATOM   4356  CA  GLN    62      65.579  48.208  48.747  1.00 10.90           C  
ATOM   4357  C   GLN    62      66.130  48.515  50.154  1.00 10.77           C  
ATOM   4358  O   GLN    62      65.662  47.951  51.164  1.00 11.03           O  
ATOM   4359  CB  GLN    62      64.037  48.298  48.684  1.00 11.20           C  
ATOM   4360  CG  GLN    62      63.461  47.988  47.269  1.00 15.34           C  
ATOM   4361  CD  GLN    62      63.525  46.484  46.782  1.00 19.63           C  
ATOM   4362  OE1 GLN    62      63.962  46.197  45.643  1.00 24.40           O  
ATOM   4363  NE2 GLN    62      63.036  45.554  47.608  1.00 20.05           N  
ATOM   4364  N   GLY    63      67.141  49.385  50.235  1.00  9.97           N  
ATOM   4365  CA  GLY    63      67.772  49.697  51.514  1.00 10.52           C  
ATOM   4366  C   GLY    63      67.143  50.896  52.214  1.00 11.09           C  
ATOM   4367  O   GLY    63      66.751  51.872  51.565  1.00 11.70           O  
ATOM   4368  N   LEU    64      67.097  50.839  53.541  1.00 10.37           N  
ATOM   4369  CA  LEU    64      66.625  51.939  54.367  1.00 10.16           C  
ATOM   4370  C   LEU    64      67.664  52.174  55.478  1.00  9.71           C  
ATOM   4371  O   LEU    64      67.874  51.315  56.356  1.00 10.08           O  
ATOM   4372  CB  LEU    64      65.244  51.621  54.960  1.00 10.42           C  
ATOM   4373  CG  LEU    64      64.636  52.668  55.897  1.00 12.75           C  
ATOM   4374  CD1 LEU    64      64.511  54.024  55.202  1.00 12.09           C  
ATOM   4375  CD2 LEU    64      63.278  52.172  56.431  1.00 11.76           C  
ATOM   4376  N   ALA    65      68.330  53.321  55.410  1.00  9.06           N  
ATOM   4377  CA  ALA    65      69.351  53.704  56.389  1.00 10.32           C  
ATOM   4378  C   ALA    65      68.659  54.294  57.618  1.00 11.65           C  
ATOM   4379  O   ALA    65      67.982  55.338  57.508  1.00 11.62           O  
ATOM   4380  CB  ALA    65      70.334  54.747  55.780  1.00 11.66           C  
ATOM   4381  N   LEU    66      68.853  53.662  58.777  1.00 10.79           N  
ATOM   4382  CA  LEU    66      68.286  54.127  60.047  1.00 11.07           C  
ATOM   4383  C   LEU    66      69.362  54.351  61.107  1.00 12.60           C  
ATOM   4384  O   LEU    66      70.029  53.421  61.537  1.00 13.07           O  
ATOM   4385  CB  LEU    66      67.247  53.141  60.582  1.00 11.35           C  
ATOM   4386  CG  LEU    66      66.058  52.943  59.660  1.00 10.42           C  
ATOM   4387  CD1 LEU    66      65.099  51.776  60.092  1.00 11.42           C  
ATOM   4388  CD2 LEU    66      65.316  54.273  59.501  1.00 11.23           C  
ATOM   4389  N   LYS    67      69.536  55.602  61.503  1.00 14.30           N  
ATOM   4390  CA  LYS    67      70.479  55.934  62.564  1.00 15.13           C  
ATOM   4391  C   LYS    67      69.918  55.438  63.901  1.00 15.44           C  
ATOM   4392  O   LYS    67      68.971  55.999  64.442  1.00 15.52           O  
ATOM   4393  CB  LYS    67      70.754  57.440  62.607  1.00 18.18           C  
ATOM   4394  CG  LYS    67      71.845  57.783  63.568  1.00 20.83           C  
ATOM   4395  CD  LYS    67      72.370  59.186  63.374  1.00 25.57           C  
ATOM   4396  CE  LYS    67      73.249  59.584  64.533  1.00 29.07           C  
ATOM   4397  NZ  LYS    67      74.375  58.632  64.659  1.00 30.99           N  
ATOM   4398  N   CYS    68      70.520  54.384  64.435  1.00 15.01           N  
ATOM   4399  CA  CYS    68      69.929  53.672  65.558  1.00 14.35           C  
ATOM   4400  C   CYS    68      71.002  53.069  66.436  1.00 15.73           C  
ATOM   4401  O   CYS    68      71.712  52.159  66.030  1.00 15.85           O  
ATOM   4402  CB  CYS    68      68.987  52.584  65.037  1.00 14.77           C  
ATOM   4403  SG  CYS    68      68.102  51.658  66.320  1.00 16.51           S  
ATOM   4404  N   ASP    69      71.149  53.645  67.615  1.00 15.43           N  
ATOM   4405  CA  ASP    69      71.974  53.077  68.661  1.00 14.74           C  
ATOM   4406  C   ASP    69      71.058  52.152  69.482  1.00 14.40           C  
ATOM   4407  O   ASP    69      70.159  52.640  70.195  1.00 12.21           O  
ATOM   4408  CB  ASP    69      72.526  54.213  69.516  1.00 16.00           C  
ATOM   4409  CG  ASP    69      73.504  53.737  70.597  1.00 19.52           C  
ATOM   4410  OD1 ASP    69      73.547  52.525  70.927  1.00 18.10           O  
ATOM   4411  OD2 ASP    69      74.211  54.625  71.143  1.00 23.30           O  
ATOM   4412  N   ILE    70      71.266  50.833  69.379  1.00 14.30           N  
ATOM   4413  CA  ILE    70      70.321  49.876  69.990  1.00 15.56           C  
ATOM   4414  C   ILE    70      70.370  49.869  71.538  1.00 15.83           C  
ATOM   4415  O   ILE    70      69.527  49.223  72.182  1.00 15.07           O  
ATOM   4416  CB  ILE    70      70.395  48.418  69.397  1.00 16.26           C  
ATOM   4417  CG1 ILE    70      71.703  47.716  69.749  1.00 18.10           C  
ATOM   4418  CG2 ILE    70      70.142  48.415  67.861  1.00 17.83           C  
ATOM   4419  CD1 ILE    70      71.696  46.193  69.368  1.00 17.33           C  
ATOM   4420  N   ARG    71      71.298  50.643  72.109  1.00 14.82           N  
ATOM   4421  CA  ARG    71      71.335  50.907  73.554  1.00 15.94           C  
ATOM   4422  C   ARG    71      70.191  51.802  73.997  1.00 15.57           C  
ATOM   4423  O   ARG    71      69.853  51.845  75.194  1.00 15.81           O  
ATOM   4424  CB  ARG    71      72.664  51.558  73.964  1.00 15.65           C  
ATOM   4425  CG  ARG    71      73.911  50.663  73.791  1.00 14.57           C  
ATOM   4426  CD  ARG    71      75.186  51.376  74.210  1.00 19.32           C  
ATOM   4427  NE  ARG    71      75.512  52.425  73.239  1.00 21.10           N  
ATOM   4428  CZ  ARG    71      76.577  53.222  73.305  1.00 24.89           C  
ATOM   4429  NH1 ARG    71      77.449  53.098  74.293  1.00 24.75           N  
ATOM   4430  NH2 ARG    71      76.777  54.145  72.365  1.00 22.88           N  
ATOM   4431  N   GLU    72      69.595  52.500  73.025  1.00 15.06           N  
ATOM   4432  CA  GLU    72      68.561  53.486  73.263  1.00 14.85           C  
ATOM   4433  C   GLU    72      67.228  52.992  72.776  1.00 14.36           C  
ATOM   4434  O   GLU    72      66.974  52.971  71.572  1.00 14.13           O  
ATOM   4435  CB  GLU    72      68.927  54.788  72.547  1.00 16.20           C  
ATOM   4436  CG  GLU    72      70.228  55.424  73.032  1.00 19.28           C  
ATOM   4437  CD  GLU    72      70.163  55.912  74.477  1.00 24.79           C  
ATOM   4438  OE1 GLU    72      69.065  56.244  74.975  1.00 26.49           O  
ATOM   4439  OE2 GLU    72      71.228  55.987  75.109  1.00 31.64           O  
ATOM   4440  N   GLU    73      66.373  52.616  73.722  1.00 14.09           N  
ATOM   4441  CA  GLU    73      65.038  52.121  73.420  1.00 14.77           C  
ATOM   4442  C   GLU    73      64.240  53.052  72.481  1.00 15.01           C  
ATOM   4443  O   GLU    73      63.577  52.581  71.536  1.00 13.16           O  
ATOM   4444  CB  GLU    73      64.247  51.894  74.732  1.00 16.04           C  
ATOM   4445  CG  GLU    73      62.876  51.306  74.472  1.00 18.66           C  
ATOM   4446  CD  GLU    73      61.866  51.466  75.631  1.00 20.26           C  
ATOM   4447  OE1 GLU    73      62.232  52.012  76.692  1.00 24.55           O  
ATOM   4448  OE2 GLU    73      60.699  51.042  75.454  1.00 23.78           O  
ATOM   4449  N   ASP    74      64.303  54.362  72.738  1.00 14.98           N  
ATOM   4450  CA  ASP    74      63.582  55.324  71.895  0.50 14.83           C  
ATOM   4452  C   ASP    74      64.038  55.283  70.432  1.00 14.52           C  
ATOM   4453  O   ASP    74      63.213  55.398  69.513  1.00 14.83           O  
ATOM   4454  CB  ASP    74      63.633  56.758  72.467  0.50 15.52           C  
ATOM   4456  CG  ASP    74      65.035  57.340  72.522  0.50 16.56           C  
ATOM   4458  OD1 ASP    74      66.010  56.581  72.494  0.50 16.84           O  
ATOM   4460  OD2 ASP    74      65.147  58.582  72.630  0.50 20.41           O  
ATOM   4462  N   GLN    75      65.332  55.101  70.199  1.00 13.57           N  
ATOM   4463  CA  GLN    75      65.839  54.993  68.823  1.00 13.14           C  
ATOM   4464  C   GLN    75      65.410  53.694  68.158  1.00 14.19           C  
ATOM   4465  O   GLN    75      65.118  53.662  66.948  1.00 13.85           O  
ATOM   4466  CB  GLN    75      67.347  55.120  68.804  1.00 14.45           C  
ATOM   4467  CG  GLN    75      67.809  56.504  69.261  1.00 14.29           C  
ATOM   4468  CD  GLN    75      69.289  56.650  69.151  1.00 16.40           C  
ATOM   4469  OE1 GLN    75      69.882  56.165  68.197  1.00 15.63           O  
ATOM   4470  NE2 GLN    75      69.905  57.317  70.129  1.00 18.92           N  
ATOM   4471  N   VAL    76      65.380  52.610  68.929  1.00 11.77           N  
ATOM   4472  CA  VAL    76      64.900  51.323  68.393  1.00 12.50           C  
ATOM   4473  C   VAL    76      63.419  51.411  67.974  1.00 12.50           C  
ATOM   4474  O   VAL    76      63.030  51.036  66.868  1.00 10.96           O  
ATOM   4475  CB  VAL    76      65.084  50.176  69.410  1.00 11.81           C  
ATOM   4476  CG1 VAL    76      64.358  48.932  68.920  1.00 11.56           C  
ATOM   4477  CG2 VAL    76      66.542  49.876  69.627  1.00 12.60           C  
ATOM   4478  N   ARG    77      62.601  51.956  68.857  1.00 13.65           N  
ATOM   4479  CA  ARG    77      61.189  52.145  68.559  0.50 13.88           C  
ATOM   4481  C   ARG    77      61.020  53.019  67.324  1.00 12.93           C  
ATOM   4482  O   ARG    77      60.226  52.697  66.449  1.00 12.46           O  
ATOM   4483  CB  ARG    77      60.467  52.791  69.729  0.50 14.68           C  
ATOM   4485  CG  ARG    77      60.032  51.831  70.812  0.50 16.92           C  
ATOM   4487  CD  ARG    77      59.153  52.565  71.818  0.50 20.54           C  
ATOM   4489  NE  ARG    77      59.950  53.532  72.565  0.50 23.90           N  
ATOM   4491  CZ  ARG    77      60.040  53.601  73.889  0.50 25.52           C  
ATOM   4493  NH1 ARG    77      59.345  52.779  74.669  0.50 28.09           N  
ATOM   4495  NH2 ARG    77      60.825  54.518  74.436  0.50 24.10           N  
ATOM   4497  N   ALA    78      61.801  54.113  67.257  1.00 12.74           N  
ATOM   4498  CA  ALA    78      61.742  55.052  66.125  1.00 12.35           C  
ATOM   4499  C   ALA    78      62.108  54.311  64.829  1.00 11.80           C  
ATOM   4500  O   ALA    78      61.436  54.455  63.798  1.00 10.56           O  
ATOM   4501  CB  ALA    78      62.675  56.230  66.346  1.00 12.32           C  
ATOM   4502  N   ALA    79      63.188  53.526  64.875  1.00 10.16           N  
ATOM   4503  CA  ALA    79      63.613  52.764  63.698  1.00  9.21           C  
ATOM   4504  C   ALA    79      62.555  51.749  63.227  1.00  9.66           C  
ATOM   4505  O   ALA    79      62.283  51.644  62.029  1.00  9.19           O  
ATOM   4506  CB  ALA    79      64.950  52.109  63.938  1.00 11.41           C  
ATOM   4507  N   VAL    80      61.932  51.036  64.162  1.00 10.89           N  
ATOM   4508  CA  VAL    80      60.930  50.054  63.811  1.00 10.39           C  
ATOM   4509  C   VAL    80      59.708  50.748  63.173  1.00 11.76           C  
ATOM   4510  O   VAL    80      59.182  50.300  62.157  1.00 10.69           O  
ATOM   4511  CB  VAL    80      60.549  49.202  65.058  1.00 11.02           C  
ATOM   4512  CG1 VAL    80      59.275  48.393  64.797  1.00 12.27           C  
ATOM   4513  CG2 VAL    80      61.707  48.283  65.456  1.00 10.82           C  
ATOM   4514  N   ALA    81      59.284  51.847  63.774  1.00 11.29           N  
ATOM   4515  CA  ALA    81      58.149  52.634  63.249  1.00 11.10           C  
ATOM   4516  C   ALA    81      58.424  53.111  61.822  1.00 10.71           C  
ATOM   4517  O   ALA    81      57.583  52.981  60.937  1.00 10.67           O  
ATOM   4518  CB  ALA    81      57.848  53.798  64.168  1.00 11.80           C  
ATOM   4519  N   ALA    82      59.638  53.609  61.588  1.00 12.43           N  
ATOM   4520  CA  ALA    82      60.031  54.073  60.246  1.00 11.93           C  
ATOM   4521  C   ALA    82      60.020  52.929  59.223  1.00 12.13           C  
ATOM   4522  O   ALA    82      59.658  53.130  58.059  1.00 12.22           O  
ATOM   4523  CB  ALA    82      61.418  54.698  60.294  1.00 11.17           C  
ATOM   4524  N   THR    83      60.486  51.750  59.641  1.00 10.92           N  
ATOM   4525  CA  THR    83      60.552  50.567  58.781  1.00 11.47           C  
ATOM   4526  C   THR    83      59.150  50.169  58.351  1.00 10.06           C  
ATOM   4527  O   THR    83      58.901  49.929  57.170  1.00 10.48           O  
ATOM   4528  CB  THR    83      61.291  49.396  59.496  1.00 12.22           C  
ATOM   4529  OG1 THR    83      62.647  49.789  59.838  1.00 10.85           O  
ATOM   4530  CG2 THR    83      61.322  48.118  58.625  1.00 11.26           C  
ATOM   4531  N   VAL    84      58.226  50.151  59.308  1.00 11.11           N  
ATOM   4532  CA  VAL    84      56.815  49.819  59.019  1.00 11.98           C  
ATOM   4533  C   VAL    84      56.188  50.876  58.082  1.00 12.56           C  
ATOM   4534  O   VAL    84      55.509  50.529  57.121  1.00 14.11           O  
ATOM   4535  CB  VAL    84      56.056  49.667  60.328  1.00 12.21           C  
ATOM   4536  CG1 VAL    84      54.528  49.657  60.079  1.00 13.32           C  
ATOM   4537  CG2 VAL    84      56.577  48.395  61.081  1.00 11.90           C  
ATOM   4538  N   ASP    85      56.495  52.145  58.314  1.00 12.76           N  
ATOM   4539  CA  ASP    85      55.984  53.238  57.498  1.00 13.08           C  
ATOM   4540  C   ASP    85      56.545  53.222  56.074  1.00 14.08           C  
ATOM   4541  O   ASP    85      55.918  53.767  55.149  1.00 17.77           O  
ATOM   4542  CB  ASP    85      56.288  54.569  58.170  1.00 11.36           C  
ATOM   4543  CG  ASP    85      55.357  54.849  59.353  1.00 13.67           C  
ATOM   4544  OD1 ASP    85      54.298  54.183  59.454  1.00 16.53           O  
ATOM   4545  OD2 ASP    85      55.690  55.730  60.152  1.00 12.55           O  
ATOM   4546  N   THR    86      57.730  52.637  55.914  1.00 13.52           N  
ATOM   4547  CA  THR    86      58.421  52.588  54.626  1.00 13.64           C  
ATOM   4548  C   THR    86      58.031  51.337  53.806  1.00 12.99           C  
ATOM   4549  O   THR    86      57.796  51.439  52.603  1.00 13.01           O  
ATOM   4550  CB  THR    86      59.949  52.678  54.805  1.00 14.35           C  
ATOM   4551  OG1 THR    86      60.296  53.846  55.556  1.00 13.28           O  
ATOM   4552  CG2 THR    86      60.658  52.690  53.436  1.00 14.76           C  
ATOM   4553  N   PHE    87      57.985  50.175  54.453  1.00 12.20           N  
ATOM   4554  CA  PHE    87      57.786  48.909  53.776  1.00 13.39           C  
ATOM   4555  C   PHE    87      56.445  48.196  54.062  1.00 14.24           C  
ATOM   4556  O   PHE    87      56.106  47.230  53.376  1.00 14.71           O  
ATOM   4557  CB  PHE    87      58.978  47.966  54.067  1.00 12.60           C  
ATOM   4558  CG  PHE    87      60.331  48.500  53.574  1.00 12.24           C  
ATOM   4559  CD1 PHE    87      60.545  48.733  52.222  1.00 12.48           C  
ATOM   4560  CD2 PHE    87      61.377  48.710  54.450  1.00 10.71           C  
ATOM   4561  CE1 PHE    87      61.770  49.195  51.760  1.00 12.16           C  
ATOM   4562  CE2 PHE    87      62.623  49.163  53.993  1.00 11.59           C  
ATOM   4563  CZ  PHE    87      62.808  49.426  52.663  1.00 11.42           C  
ATOM   4564  N   GLY    88      55.701  48.651  55.066  1.00 14.19           N  
ATOM   4565  CA  GLY    88      54.385  48.070  55.374  1.00 15.72           C  
ATOM   4566  C   GLY    88      54.414  47.041  56.492  1.00 16.55           C  
ATOM   4567  O   GLY    88      53.366  46.641  56.994  1.00 18.76           O  
ATOM   4568  N   GLY    89      55.600  46.614  56.913  1.00 16.03           N  
ATOM   4569  CA  GLY    89      55.698  45.617  57.983  1.00 15.01           C  
ATOM   4570  C   GLY    89      57.135  45.227  58.265  1.00 14.27           C  
ATOM   4571  O   GLY    89      58.052  45.854  57.737  1.00 13.48           O  
ATOM   4572  N   ILE    90      57.300  44.214  59.119  1.00 13.25           N  
ATOM   4573  CA  ILE    90      58.606  43.592  59.372  1.00 13.40           C  
ATOM   4574  C   ILE    90      58.384  42.086  59.350  1.00 11.55           C  
ATOM   4575  O   ILE    90      57.515  41.570  60.077  1.00 11.69           O  
ATOM   4576  CB  ILE    90      59.255  44.041  60.701  1.00 12.64           C  
ATOM   4577  CG1 ILE    90      59.526  45.566  60.696  1.00 14.52           C  
ATOM   4578  CG2 ILE    90      60.558  43.283  60.906  1.00 12.56           C  
ATOM   4579  CD1 ILE    90      60.052  46.125  61.987  1.00 15.48           C  
ATOM   4580  N   ASP    91      59.096  41.403  58.457  1.00  9.86           N  
ATOM   4581  CA  ASP    91      59.002  39.958  58.303  1.00 11.11           C  
ATOM   4582  C   ASP    91      60.065  39.250  59.113  1.00  9.15           C  
ATOM   4583  O   ASP    91      59.854  38.134  59.552  1.00  9.18           O  
ATOM   4584  CB  ASP    91      59.140  39.542  56.847  1.00 11.65           C  
ATOM   4585  CG  ASP    91      58.037  40.107  55.980  1.00 14.84           C  
ATOM   4586  OD1 ASP    91      56.894  39.622  56.119  1.00 16.00           O  
ATOM   4587  OD2 ASP    91      58.298  41.074  55.229  1.00 12.79           O  
ATOM   4588  N   ILE    92      61.221  39.899  59.274  1.00  9.58           N  
ATOM   4589  CA  ILE    92      62.410  39.261  59.820  1.00  8.68           C  
ATOM   4590  C   ILE    92      63.218  40.242  60.659  1.00  8.52           C  
ATOM   4591  O   ILE    92      63.473  41.358  60.218  1.00  9.07           O  
ATOM   4592  CB  ILE    92      63.321  38.751  58.680  1.00  8.52           C  
ATOM   4593  CG1 ILE    92      62.638  37.607  57.875  1.00  9.06           C  
ATOM   4594  CG2 ILE    92      64.706  38.401  59.227  1.00  8.10           C  
ATOM   4595  CD1 ILE    92      63.261  37.353  56.436  1.00  7.79           C  
ATOM   4596  N   LEU    93      63.533  39.852  61.886  1.00  8.30           N  
ATOM   4597  CA  LEU    93      64.502  40.588  62.706  1.00  7.41           C  
ATOM   4598  C   LEU    93      65.775  39.756  62.820  1.00  8.70           C  
ATOM   4599  O   LEU    93      65.716  38.585  63.185  1.00  8.76           O  
ATOM   4600  CB  LEU    93      63.938  40.843  64.105  1.00  8.16           C  
ATOM   4601  CG  LEU    93      64.932  41.233  65.196  1.00  5.74           C  
ATOM   4602  CD1 LEU    93      65.628  42.551  64.861  1.00  6.57           C  
ATOM   4603  CD2 LEU    93      64.314  41.307  66.611  1.00  8.60           C  
ATOM   4604  N   VAL    94      66.914  40.375  62.510  1.00  7.98           N  
ATOM   4605  CA  VAL    94      68.219  39.769  62.709  1.00  9.12           C  
ATOM   4606  C   VAL    94      68.980  40.558  63.797  1.00 10.02           C  
ATOM   4607  O   VAL    94      69.390  41.739  63.605  1.00  9.86           O  
ATOM   4608  CB  VAL    94      69.055  39.690  61.423  1.00  9.47           C  
ATOM   4609  CG1 VAL    94      70.436  39.116  61.752  1.00  9.29           C  
ATOM   4610  CG2 VAL    94      68.318  38.871  60.309  1.00  8.59           C  
ATOM   4611  N   ASN    95      69.154  39.893  64.938  1.00 10.55           N  
ATOM   4612  CA  ASN    95      69.892  40.431  66.077  1.00  9.62           C  
ATOM   4613  C   ASN    95      71.373  40.123  65.903  1.00 11.40           C  
ATOM   4614  O   ASN    95      71.831  39.032  66.242  1.00  9.87           O  
ATOM   4615  CB  ASN    95      69.380  39.836  67.413  1.00 10.60           C  
ATOM   4616  CG  ASN    95      68.052  40.440  67.876  1.00 11.21           C  
ATOM   4617  OD1 ASN    95      67.818  41.634  67.732  1.00 10.76           O  
ATOM   4618  ND2 ASN    95      67.218  39.620  68.528  1.00 12.96           N  
ATOM   4619  N   ASN    96      72.085  41.091  65.326  1.00 11.59           N  
ATOM   4620  CA  ASN    96      73.528  41.016  65.035  1.00 13.37           C  
ATOM   4621  C   ASN    96      74.273  42.005  65.928  1.00 16.20           C  
ATOM   4622  O   ASN    96      73.928  43.179  65.993  1.00 15.11           O  
ATOM   4623  CB  ASN    96      73.715  41.313  63.557  1.00 11.50           C  
ATOM   4624  CG  ASN    96      75.139  41.575  63.180  1.00 14.49           C  
ATOM   4625  OD1 ASN    96      75.983  40.680  63.207  1.00 16.83           O  
ATOM   4626  ND2 ASN    96      75.409  42.792  62.790  1.00  9.56           N  
ATOM   4627  N   ALA    97      75.296  41.579  66.656  1.00 18.86           N  
ATOM   4628  CA  ALA    97      75.854  42.536  67.648  1.00 21.32           C  
ATOM   4629  C   ALA    97      77.288  42.237  68.037  1.00 24.35           C  
ATOM   4630  O   ALA    97      77.701  41.061  68.148  1.00 25.78           O  
ATOM   4631  CB  ALA    97      74.962  42.624  68.875  1.00 19.12           C  
ATOM   4632  N   SER    98      78.054  43.303  68.232  1.00 26.50           N  
ATOM   4633  CA  SER    98      79.498  43.168  68.439  1.00 27.11           C  
ATOM   4634  C   SER    98      79.973  44.056  69.562  1.00 28.44           C  
ATOM   4635  O   SER    98      80.188  45.265  69.386  1.00 30.58           O  
ATOM   4636  CB  SER    98      80.288  43.465  67.148  1.00 28.40           C  
ATOM   4637  N   ALA    99      80.109  43.449  70.737  1.00 27.31           N  
ATOM   4638  CA  ALA    99      80.844  44.047  71.820  1.00 25.99           C  
ATOM   4639  C   ALA    99      81.478  42.891  72.564  1.00 25.28           C  
ATOM   4640  O   ALA    99      80.775  42.057  73.139  1.00 26.40           O  
ATOM   4641  CB  ALA    99      79.943  44.863  72.705  1.00 23.45           C  
ATOM   4642  N   ILE   100      82.803  42.829  72.486  1.00 25.37           N  
ATOM   4643  CA  ILE   100      83.592  41.744  73.047  1.00 25.42           C  
ATOM   4644  C   ILE   100      84.627  42.316  73.998  1.00 24.81           C  
ATOM   4645  O   ILE   100      85.177  43.389  73.744  1.00 24.78           O  
ATOM   4646  CB  ILE   100      84.371  40.987  71.948  1.00 25.91           C  
ATOM   4647  CG1 ILE   100      83.484  40.708  70.742  1.00 27.86           C  
ATOM   4648  CG2 ILE   100      84.948  39.693  72.488  1.00 24.79           C  
ATOM   4649  CD1 ILE   100      84.232  40.102  69.571  1.00 29.67           C  
ATOM   4650  N   TRP   101      84.907  41.572  75.065  1.00 24.29           N  
ATOM   4651  CA  TRP   101      85.986  41.896  75.992  1.00 23.47           C  
ATOM   4652  C   TRP   101      86.430  40.636  76.723  1.00 22.77           C  
ATOM   4653  O   TRP   101      85.773  40.172  77.675  1.00 21.38           O  
ATOM   4654  CB  TRP   101      85.541  42.954  76.986  1.00 24.46           C  
ATOM   4655  CG  TRP   101      86.642  43.518  77.809  1.00 24.30           C  
ATOM   4656  CD1 TRP   101      86.913  43.240  79.101  1.00 24.59           C  
ATOM   4657  CD2 TRP   101      87.599  44.497  77.396  1.00 23.61           C  
ATOM   4658  NE1 TRP   101      87.994  43.970  79.529  1.00 24.57           N  
ATOM   4659  CE2 TRP   101      88.426  44.762  78.502  1.00 24.81           C  
ATOM   4660  CE3 TRP   101      87.836  45.178  76.195  1.00 25.08           C  
ATOM   4661  CZ2 TRP   101      89.479  45.672  78.448  1.00 25.92           C  
ATOM   4662  CZ3 TRP   101      88.884  46.096  76.148  1.00 24.84           C  
ATOM   4663  CH2 TRP   101      89.694  46.322  77.263  1.00 25.44           C  
ATOM   4664  N   LEU   102      87.548  40.074  76.284  1.00 21.75           N  
ATOM   4665  CA  LEU   102      87.973  38.788  76.788  1.00 22.04           C  
ATOM   4666  C   LEU   102      88.999  38.959  77.898  1.00 23.00           C  
ATOM   4667  O   LEU   102      90.183  38.677  77.729  1.00 24.09           O  
ATOM   4668  CB  LEU   102      88.501  37.906  75.658  1.00 22.22           C  
ATOM   4669  CG  LEU   102      87.511  37.608  74.531  1.00 21.08           C  
ATOM   4670  CD1 LEU   102      88.094  36.557  73.608  1.00 22.43           C  
ATOM   4671  CD2 LEU   102      86.161  37.181  75.059  1.00 23.06           C  
ATOM   4672  N   ARG   103      88.519  39.427  79.046  1.00 22.04           N  
ATOM   4673  CA  ARG   103      89.319  39.493  80.253  1.00 21.64           C  
ATOM   4674  C   ARG   103      88.537  39.038  81.485  1.00 20.27           C  
ATOM   4675  O   ARG   103      87.312  38.943  81.477  1.00 17.16           O  
ATOM   4676  CB  ARG   103      89.814  40.917  80.499  1.00 24.03           C  
ATOM   4677  CG  ARG   103      90.505  41.512  79.289  1.00 28.14           C  
ATOM   4678  CD  ARG   103      91.647  42.375  79.666  1.00 33.78           C  
ATOM   4679  NE  ARG   103      91.975  43.272  78.562  1.00 36.82           N  
ATOM   4680  CZ  ARG   103      92.748  44.347  78.676  1.00 38.51           C  
ATOM   4681  NH1 ARG   103      93.292  44.664  79.851  1.00 40.89           N  
ATOM   4682  NH2 ARG   103      92.980  45.113  77.610  1.00 38.28           N  
ATOM   4683  N   GLY   104      89.296  38.795  82.548  1.00 16.74           N  
ATOM   4684  CA  GLY   104      88.738  38.403  83.816  1.00 16.72           C  
ATOM   4685  C   GLY   104      88.016  39.549  84.476  1.00 15.68           C  
ATOM   4686  O   GLY   104      88.102  40.703  84.059  1.00 14.76           O  
ATOM   4687  N   THR   105      87.290  39.209  85.524  1.00 15.55           N  
ATOM   4688  CA  THR   105      86.415  40.145  86.195  1.00 15.07           C  
ATOM   4689  C   THR   105      87.085  41.370  86.813  1.00 16.19           C  
ATOM   4690  O   THR   105      86.541  42.478  86.727  1.00 17.66           O  
ATOM   4691  CB  THR   105      85.596  39.354  87.216  1.00 15.47           C  
ATOM   4692  OG1 THR   105      84.754  38.485  86.470  1.00 15.00           O  
ATOM   4693  CG2 THR   105      84.743  40.249  88.138  1.00 14.35           C  
ATOM   4694  N   LEU   106      88.263  41.202  87.418  1.00 15.58           N  
ATOM   4695  CA  LEU   106      88.968  42.363  87.978  1.00 17.21           C  
ATOM   4696  C   LEU   106      89.505  43.305  86.884  1.00 17.64           C  
ATOM   4697  O   LEU   106      89.758  44.483  87.159  1.00 18.32           O  
ATOM   4698  CB  LEU   106      90.100  41.919  88.905  1.00 18.10           C  
ATOM   4699  CG  LEU   106      89.663  41.104  90.120  1.00 18.99           C  
ATOM   4700  CD1 LEU   106      90.879  40.738  91.005  1.00 19.71           C  
ATOM   4701  CD2 LEU   106      88.591  41.858  90.886  1.00 19.70           C  
ATOM   4702  N   ASP   107      89.640  42.778  85.666  1.00 18.49           N  
ATOM   4703  CA  ASP   107      90.100  43.530  84.483  1.00 20.41           C  
ATOM   4704  C   ASP   107      88.994  43.850  83.466  1.00 20.75           C  
ATOM   4705  O   ASP   107      89.274  44.072  82.273  1.00 19.29           O  
ATOM   4706  CB  ASP   107      91.193  42.730  83.775  1.00 21.67           C  
ATOM   4707  CG  ASP   107      92.343  42.404  84.683  1.00 25.54           C  
ATOM   4708  OD1 ASP   107      92.765  43.318  85.419  1.00 30.40           O  
ATOM   4709  OD2 ASP   107      92.820  41.247  84.674  1.00 29.43           O  
ATOM   4710  N   THR   108      87.744  43.880  83.937  1.00 19.28           N  
ATOM   4711  CA  THR   108      86.581  44.210  83.116  1.00 18.97           C  
ATOM   4712  C   THR   108      85.864  45.409  83.737  1.00 18.53           C  
ATOM   4713  O   THR   108      84.979  45.238  84.572  1.00 18.30           O  
ATOM   4714  CB  THR   108      85.607  42.989  82.979  1.00 18.05           C  
ATOM   4715  OG1 THR   108      86.270  41.918  82.300  1.00 16.75           O  
ATOM   4716  CG2 THR   108      84.333  43.347  82.176  1.00 18.61           C  
ATOM   4717  N   PRO   109      86.236  46.634  83.326  1.00 19.10           N  
ATOM   4718  CA  PRO   109      85.571  47.825  83.855  1.00 18.95           C  
ATOM   4719  C   PRO   109      84.062  47.813  83.663  1.00 18.05           C  
ATOM   4720  O   PRO   109      83.562  47.256  82.680  1.00 17.09           O  
ATOM   4721  CB  PRO   109      86.210  48.986  83.052  1.00 19.61           C  
ATOM   4722  CG  PRO   109      87.506  48.462  82.542  1.00 19.54           C  
ATOM   4723  CD  PRO   109      87.301  46.969  82.358  1.00 19.08           C  
ATOM   4724  N   MET   110      83.332  48.423  84.588  1.00 18.14           N  
ATOM   4725  CA  MET   110      81.867  48.425  84.471  1.00 18.12           C  
ATOM   4726  C   MET   110      81.380  49.103  83.188  1.00 17.12           C  
ATOM   4727  O   MET   110      80.344  48.701  82.654  1.00 15.67           O  
ATOM   4728  CB  MET   110      81.211  49.040  85.703  1.00 18.68           C  
ATOM   4729  CG  MET   110      81.477  48.233  86.978  1.00 20.97           C  
ATOM   4730  SD  MET   110      81.044  46.309  86.827  1.00 25.12          SE  
ATOM   4731  CE  MET   110      79.163  46.430  86.231  1.00 15.96           C  
ATOM   4732  N   LYS   111      82.099  50.110  82.680  1.00 15.99           N  
ATOM   4733  CA  LYS   111      81.717  50.714  81.391  1.00 16.83           C  
ATOM   4734  C   LYS   111      81.719  49.670  80.260  1.00 16.95           C  
ATOM   4735  O   LYS   111      80.841  49.664  79.396  1.00 16.98           O  
ATOM   4736  CB  LYS   111      82.604  51.928  81.031  1.00 17.99           C  
ATOM   4737  N   ARG   112      82.687  48.772  80.283  1.00 16.61           N  
ATOM   4738  CA  ARG   112      82.800  47.714  79.279  1.00 16.84           C  
ATOM   4739  C   ARG   112      81.758  46.624  79.515  1.00 15.21           C  
ATOM   4740  O   ARG   112      81.088  46.175  78.593  1.00 14.90           O  
ATOM   4741  CB  ARG   112      84.206  47.118  79.324  1.00 19.03           C  
ATOM   4742  CG  ARG   112      84.488  46.147  78.241  1.00 24.00           C  
ATOM   4743  CD  ARG   112      84.588  46.814  76.882  1.00 28.63           C  
ATOM   4744  NE  ARG   112      85.729  47.725  76.809  1.00 31.55           N  
ATOM   4745  CZ  ARG   112      86.100  48.369  75.702  1.00 33.82           C  
ATOM   4746  NH1 ARG   112      85.423  48.203  74.565  1.00 35.01           N  
ATOM   4747  NH2 ARG   112      87.157  49.175  75.724  1.00 33.19           N  
ATOM   4748  N   PHE   113      81.589  46.242  80.771  1.00 14.46           N  
ATOM   4749  CA  PHE   113      80.528  45.298  81.141  1.00 13.19           C  
ATOM   4750  C   PHE   113      79.201  45.800  80.609  1.00 12.99           C  
ATOM   4751  O   PHE   113      78.449  45.038  79.996  1.00 13.17           O  
ATOM   4752  CB  PHE   113      80.464  45.166  82.666  1.00 13.14           C  
ATOM   4753  CG  PHE   113      79.424  44.201  83.156  1.00 12.58           C  
ATOM   4754  CD1 PHE   113      79.761  42.881  83.428  1.00 13.38           C  
ATOM   4755  CD2 PHE   113      78.112  44.619  83.395  1.00 12.08           C  
ATOM   4756  CE1 PHE   113      78.809  41.975  83.900  1.00 13.78           C  
ATOM   4757  CE2 PHE   113      77.166  43.727  83.864  1.00 14.33           C  
ATOM   4758  CZ  PHE   113      77.521  42.387  84.097  1.00 13.05           C  
ATOM   4759  N   ASP   114      78.925  47.089  80.832  1.00 13.50           N  
ATOM   4760  CA  ASP   114      77.629  47.702  80.477  1.00 13.35           C  
ATOM   4761  C   ASP   114      77.445  47.808  78.964  1.00 13.59           C  
ATOM   4762  O   ASP   114      76.377  47.516  78.440  1.00 13.57           O  
ATOM   4763  CB  ASP   114      77.495  49.087  81.096  1.00 14.35           C  
ATOM   4764  CG  ASP   114      77.199  49.046  82.581  1.00 16.36           C  
ATOM   4765  OD1 ASP   114      76.877  47.963  83.130  1.00 16.43           O  
ATOM   4766  OD2 ASP   114      77.296  50.123  83.213  1.00 17.53           O  
ATOM   4767  N   LEU   115      78.494  48.227  78.255  1.00 13.85           N  
ATOM   4768  CA  LEU   115      78.435  48.234  76.797  1.00 14.41           C  
ATOM   4769  C   LEU   115      78.001  46.864  76.291  1.00 13.73           C  
ATOM   4770  O   LEU   115      77.135  46.765  75.426  1.00 12.95           O  
ATOM   4771  CB  LEU   115      79.810  48.563  76.215  1.00 15.20           C  
ATOM   4772  CG  LEU   115      79.954  48.493  74.687  1.00 17.36           C  
ATOM   4773  CD1 LEU   115      79.052  49.546  74.048  1.00 20.85           C  
ATOM   4774  CD2 LEU   115      81.438  48.699  74.265  1.00 17.77           C  
ATOM   4775  N   MET   116      78.636  45.810  76.810  1.00 12.94           N  
ATOM   4776  CA  MET   116      78.357  44.446  76.364  1.00 14.83           C  
ATOM   4777  C   MET   116      76.934  44.028  76.686  1.00 13.40           C  
ATOM   4778  O   MET   116      76.227  43.522  75.812  1.00 12.46           O  
ATOM   4779  CB  MET   116      79.337  43.460  76.970  1.00 14.83           C  
ATOM   4780  CG  MET   116      80.753  43.700  76.483  1.00 17.13           C  
ATOM   4781  SD  MET   116      81.983  42.298  76.979  1.00 23.57          SE  
ATOM   4782  CE  MET   116      81.985  42.439  78.957  1.00 14.43           C  
ATOM   4783  N   GLN   117      76.479  44.232  77.914  1.00 12.39           N  
ATOM   4784  CA  GLN   117      75.076  43.805  78.221  1.00 10.84           C  
ATOM   4785  C   GLN   117      74.063  44.595  77.416  1.00 12.68           C  
ATOM   4786  O   GLN   117      73.022  44.081  77.083  1.00 13.09           O  
ATOM   4787  CB  GLN   117      74.696  43.928  79.699  1.00 11.00           C  
ATOM   4788  CG  GLN   117      75.734  43.443  80.721  1.00 10.79           C  
ATOM   4789  CD  GLN   117      76.335  42.099  80.406  1.00 12.31           C  
ATOM   4790  OE1 GLN   117      75.632  41.127  80.084  1.00 15.56           O  
ATOM   4791  NE2 GLN   117      77.669  42.022  80.528  1.00 13.42           N  
ATOM   4792  N   GLN   118      74.345  45.867  77.163  1.00 12.32           N  
ATOM   4793  CA  GLN   118      73.398  46.727  76.474  1.00 12.69           C  
ATOM   4794  C   GLN   118      73.291  46.412  74.976  1.00 12.42           C  
ATOM   4795  O   GLN   118      72.191  46.387  74.414  1.00 14.90           O  
ATOM   4796  CB  GLN   118      73.751  48.191  76.720  1.00 12.77           C  
ATOM   4797  CG  GLN   118      73.473  48.629  78.157  1.00 13.82           C  
ATOM   4798  CD  GLN   118      74.069  49.992  78.489  1.00 18.46           C  
ATOM   4799  OE1 GLN   118      74.460  50.744  77.596  1.00 20.95           O  
ATOM   4800  NE2 GLN   118      74.143  50.308  79.778  1.00 18.75           N  
ATOM   4801  N   VAL   119      74.414  46.146  74.323  1.00 11.13           N  
ATOM   4802  CA  VAL   119      74.416  45.869  72.895  1.00 12.66           C  
ATOM   4803  C   VAL   119      73.986  44.426  72.572  1.00 13.69           C  
ATOM   4804  O   VAL   119      73.292  44.178  71.564  1.00 14.74           O  
ATOM   4805  CB  VAL   119      75.809  46.132  72.258  1.00 13.12           C  
ATOM   4806  CG1 VAL   119      75.776  45.741  70.812  1.00 14.87           C  
ATOM   4807  CG2 VAL   119      76.195  47.602  72.424  1.00 12.12           C  
ATOM   4808  N   ASN   120      74.401  43.486  73.427  1.00 13.44           N  
ATOM   4809  CA  ASN   120      74.200  42.069  73.177  0.50 12.98           C  
ATOM   4811  C   ASN   120      72.813  41.670  73.715  1.00 13.00           C  
ATOM   4812  O   ASN   120      71.819  41.857  73.018  1.00 12.21           O  
ATOM   4813  CB  ASN   120      75.360  41.220  73.757  0.50 13.16           C  
ATOM   4815  CG  ASN   120      76.684  41.377  72.975  0.50 12.41           C  
ATOM   4817  OD1 ASN   120      76.764  41.060  71.790  0.50 13.07           O  
ATOM   4819  ND2 ASN   120      77.733  41.834  73.656  0.50 12.30           N  
ATOM   4821  N   ALA   121      72.726  41.185  74.956  1.00 12.16           N  
ATOM   4822  CA  ALA   121      71.464  40.643  75.491  1.00 11.72           C  
ATOM   4823  C   ALA   121      70.322  41.649  75.456  1.00 12.07           C  
ATOM   4824  O   ALA   121      69.208  41.328  74.996  1.00 12.16           O  
ATOM   4825  CB  ALA   121      71.669  40.131  76.946  1.00 13.02           C  
ATOM   4826  N   ARG   122      70.565  42.852  75.995  1.00 11.44           N  
ATOM   4827  CA  ARG   122      69.499  43.842  76.086  1.00 11.27           C  
ATOM   4828  C   ARG   122      69.060  44.279  74.698  1.00 10.77           C  
ATOM   4829  O   ARG   122      67.867  44.432  74.456  1.00 10.93           O  
ATOM   4830  CB  ARG   122      69.894  45.062  76.914  1.00 10.51           C  
ATOM   4831  CG  ARG   122      68.796  46.125  77.010  1.00 13.02           C  
ATOM   4832  CD  ARG   122      69.322  47.318  77.769  1.00 13.69           C  
ATOM   4833  NE  ARG   122      68.287  48.282  78.149  1.00 13.08           N  
ATOM   4834  CZ  ARG   122      67.886  49.308  77.407  1.00 15.18           C  
ATOM   4835  NH1 ARG   122      68.372  49.496  76.189  1.00 15.76           N  
ATOM   4836  NH2 ARG   122      66.952  50.136  77.870  1.00 15.43           N  
ATOM   4837  N   GLY   123      70.024  44.489  73.807  1.00 10.93           N  
ATOM   4838  CA  GLY   123      69.728  44.923  72.463  1.00 12.11           C  
ATOM   4839  C   GLY   123      68.832  43.942  71.757  1.00 10.92           C  
ATOM   4840  O   GLY   123      67.879  44.335  71.092  1.00 11.97           O  
ATOM   4841  N   SER   124      69.147  42.658  71.879  1.00 11.84           N  
ATOM   4842  CA  SER   124      68.289  41.598  71.314  1.00 12.43           C  
ATOM   4843  C   SER   124      66.855  41.606  71.898  1.00 11.52           C  
ATOM   4844  O   SER   124      65.874  41.445  71.187  1.00 12.03           O  
ATOM   4845  CB  SER   124      68.951  40.237  71.508  1.00 13.17           C  
ATOM   4846  OG  SER   124      70.098  40.135  70.688  1.00 14.58           O  
ATOM   4847  N   PHE   125      66.754  41.814  73.197  1.00 10.91           N  
ATOM   4848  CA  PHE   125      65.472  41.833  73.875  1.00 11.04           C  
ATOM   4849  C   PHE   125      64.646  43.039  73.427  1.00 10.57           C  
ATOM   4850  O   PHE   125      63.471  42.909  73.092  1.00 10.43           O  
ATOM   4851  CB  PHE   125      65.703  41.865  75.387  1.00 11.54           C  
ATOM   4852  CG  PHE   125      64.418  41.773  76.193  1.00 10.16           C  
ATOM   4853  CD1 PHE   125      63.897  40.544  76.579  1.00 13.28           C  
ATOM   4854  CD2 PHE   125      63.741  42.919  76.557  1.00 11.17           C  
ATOM   4855  CE1 PHE   125      62.693  40.470  77.301  1.00 11.83           C  
ATOM   4856  CE2 PHE   125      62.552  42.848  77.299  1.00 12.77           C  
ATOM   4857  CZ  PHE   125      62.044  41.624  77.670  1.00 12.83           C  
ATOM   4858  N   VAL   126      65.256  44.219  73.410  1.00  9.95           N  
ATOM   4859  CA  VAL   126      64.511  45.438  73.075  1.00 10.61           C  
ATOM   4860  C   VAL   126      64.085  45.414  71.595  1.00 10.08           C  
ATOM   4861  O   VAL   126      62.974  45.786  71.260  1.00  8.91           O  
ATOM   4862  CB  VAL   126      65.253  46.746  73.445  1.00 12.17           C  
ATOM   4863  CG1 VAL   126      66.411  46.975  72.549  1.00 13.03           C  
ATOM   4864  CG2 VAL   126      64.261  47.941  73.333  1.00 13.60           C  
ATOM   4865  N   CYS   127      64.940  44.918  70.706  1.00  8.78           N  
ATOM   4866  CA  CYS   127      64.556  44.829  69.293  1.00  9.64           C  
ATOM   4867  C   CYS   127      63.430  43.799  69.065  1.00  9.04           C  
ATOM   4868  O   CYS   127      62.509  44.066  68.289  1.00  9.08           O  
ATOM   4869  CB  CYS   127      65.755  44.527  68.395  1.00 11.59           C  
ATOM   4870  SG  CYS   127      66.985  45.896  68.327  1.00 12.35           S  
ATOM   4871  N   ALA   128      63.515  42.647  69.720  1.00  9.80           N  
ATOM   4872  CA  ALA   128      62.455  41.630  69.677  1.00 10.15           C  
ATOM   4873  C   ALA   128      61.138  42.245  70.181  1.00 11.65           C  
ATOM   4874  O   ALA   128      60.084  42.133  69.539  1.00 11.05           O  
ATOM   4875  CB  ALA   128      62.843  40.415  70.540  1.00 10.91           C  
ATOM   4876  N   GLN   129      61.188  42.911  71.330  1.00 11.23           N  
ATOM   4877  CA  GLN   129      59.985  43.547  71.886  1.00 11.14           C  
ATOM   4878  C   GLN   129      59.314  44.538  70.907  1.00 10.13           C  
ATOM   4879  O   GLN   129      58.088  44.591  70.759  1.00 11.68           O  
ATOM   4880  CB  GLN   129      60.369  44.283  73.190  1.00 11.56           C  
ATOM   4881  CG  GLN   129      59.181  44.730  74.003  1.00 13.69           C  
ATOM   4882  CD  GLN   129      59.602  45.485  75.254  1.00 13.88           C  
ATOM   4883  OE1 GLN   129      60.151  46.609  75.176  1.00 14.78           O  
ATOM   4884  NE2 GLN   129      59.383  44.865  76.410  1.00 12.56           N  
ATOM   4885  N   ALA   130      60.143  45.338  70.237  1.00 11.19           N  
ATOM   4886  CA  ALA   130      59.670  46.369  69.343  1.00 10.54           C  
ATOM   4887  C   ALA   130      59.142  45.773  68.036  1.00 11.30           C  
ATOM   4888  O   ALA   130      58.129  46.269  67.490  1.00 11.80           O  
ATOM   4889  CB  ALA   130      60.775  47.412  69.087  1.00 10.80           C  
ATOM   4890  N   CYS   131      59.797  44.715  67.541  1.00  9.61           N  
ATOM   4891  CA  CYS   131      59.391  44.102  66.271  1.00  9.08           C  
ATOM   4892  C   CYS   131      58.218  43.106  66.416  1.00 10.40           C  
ATOM   4893  O   CYS   131      57.470  42.901  65.465  1.00 11.49           O  
ATOM   4894  CB  CYS   131      60.552  43.393  65.597  1.00  9.36           C  
ATOM   4895  SG  CYS   131      61.871  44.495  65.006  1.00 11.22           S  
ATOM   4896  N   LEU   132      58.079  42.475  67.581  1.00 10.77           N  
ATOM   4897  CA  LEU   132      57.107  41.373  67.726  1.00  9.18           C  
ATOM   4898  C   LEU   132      55.663  41.690  67.279  1.00 10.03           C  
ATOM   4899  O   LEU   132      55.045  40.850  66.604  1.00  9.95           O  
ATOM   4900  CB  LEU   132      57.153  40.761  69.134  1.00 11.17           C  
ATOM   4901  CG  LEU   132      58.164  39.617  69.230  1.00 11.35           C  
ATOM   4902  CD1 LEU   132      58.557  39.333  70.702  1.00 13.15           C  
ATOM   4903  CD2 LEU   132      57.596  38.377  68.539  1.00 12.42           C  
ATOM   4904  N   PRO   133      55.114  42.868  67.665  1.00 10.54           N  
ATOM   4905  CA  PRO   133      53.739  43.225  67.224  1.00 11.32           C  
ATOM   4906  C   PRO   133      53.565  43.175  65.705  1.00 12.10           C  
ATOM   4907  O   PRO   133      52.485  42.830  65.204  1.00 12.95           O  
ATOM   4908  CB  PRO   133      53.538  44.635  67.781  1.00 11.39           C  
ATOM   4909  CG  PRO   133      54.421  44.675  69.013  1.00 11.30           C  
ATOM   4910  CD  PRO   133      55.667  43.877  68.578  1.00 11.32           C  
ATOM   4911  N   HIS   134      54.638  43.491  64.986  1.00 12.10           N  
ATOM   4912  CA  HIS   134      54.660  43.452  63.521  1.00 12.42           C  
ATOM   4913  C   HIS   134      54.978  42.070  62.973  1.00 12.18           C  
ATOM   4914  O   HIS   134      54.335  41.617  62.025  1.00 12.08           O  
ATOM   4915  CB  HIS   134      55.651  44.492  63.010  1.00 11.83           C  
ATOM   4916  CG  HIS   134      55.357  45.859  63.526  1.00 13.73           C  
ATOM   4917  ND1 HIS   134      54.203  46.531  63.184  1.00 13.93           N  
ATOM   4918  CD2 HIS   134      56.001  46.638  64.423  1.00 16.48           C  
ATOM   4919  CE1 HIS   134      54.173  47.687  63.821  1.00 16.64           C  
ATOM   4920  NE2 HIS   134      55.247  47.771  64.587  1.00 16.02           N  
ATOM   4921  N   LEU   135      55.956  41.390  63.574  1.00 11.61           N  
ATOM   4922  CA  LEU   135      56.254  40.010  63.200  1.00 11.72           C  
ATOM   4923  C   LEU   135      55.029  39.117  63.326  1.00 12.63           C  
ATOM   4924  O   LEU   135      54.788  38.262  62.481  1.00 12.07           O  
ATOM   4925  CB  LEU   135      57.383  39.427  64.059  1.00 11.18           C  
ATOM   4926  CG  LEU   135      58.759  40.045  63.825  1.00 11.31           C  
ATOM   4927  CD1 LEU   135      59.726  39.571  64.899  1.00 11.84           C  
ATOM   4928  CD2 LEU   135      59.269  39.678  62.420  1.00 11.63           C  
ATOM   4929  N   LEU   136      54.253  39.312  64.391  1.00 12.46           N  
ATOM   4930  CA  LEU   136      53.108  38.423  64.659  1.00 14.15           C  
ATOM   4931  C   LEU   136      52.018  38.541  63.584  1.00 16.01           C  
ATOM   4932  O   LEU   136      51.106  37.706  63.514  1.00 19.25           O  
ATOM   4933  CB  LEU   136      52.539  38.725  66.045  1.00 12.70           C  
ATOM   4934  CG  LEU   136      53.382  38.188  67.206  1.00 12.96           C  
ATOM   4935  CD1 LEU   136      52.957  38.868  68.508  1.00 14.52           C  
ATOM   4936  CD2 LEU   136      53.292  36.667  67.308  1.00 10.87           C  
ATOM   4937  N   GLN   137      52.110  39.571  62.759  1.00 16.74           N  
ATOM   4938  CA  GLN   137      51.183  39.771  61.640  1.00 18.19           C  
ATOM   4939  C   GLN   137      51.740  39.369  60.282  1.00 16.98           C  
ATOM   4940  O   GLN   137      51.024  39.422  59.274  1.00 17.55           O  
ATOM   4941  CB  GLN   137      50.766  41.225  61.630  1.00 19.63           C  
ATOM   4942  CG  GLN   137      50.111  41.555  62.966  1.00 23.17           C  
ATOM   4943  CD  GLN   137      49.402  42.830  62.973  1.00 27.69           C  
ATOM   4944  OE1 GLN   137      49.575  43.662  62.078  1.00 30.53           O  
ATOM   4945  NE2 GLN   137      48.580  43.029  64.003  1.00 30.84           N  
ATOM   4946  N   ALA   138      53.013  38.981  60.249  1.00 13.57           N  
ATOM   4947  CA  ALA   138      53.674  38.667  58.989  1.00 13.26           C  
ATOM   4948  C   ALA   138      53.365  37.223  58.577  1.00 13.01           C  
ATOM   4949  O   ALA   138      53.091  36.390  59.436  1.00 13.92           O  
ATOM   4950  CB  ALA   138      55.196  38.887  59.136  1.00 10.87           C  
ATOM   4951  N   PRO   139      53.404  36.912  57.256  1.00 13.60           N  
ATOM   4952  CA  PRO   139      53.165  35.548  56.775  1.00 14.70           C  
ATOM   4953  C   PRO   139      54.134  34.472  57.301  1.00 13.61           C  
ATOM   4954  O   PRO   139      53.723  33.352  57.564  1.00 14.84           O  
ATOM   4955  CB  PRO   139      53.284  35.676  55.245  1.00 15.05           C  
ATOM   4956  CG  PRO   139      53.252  37.102  54.932  1.00 16.25           C  
ATOM   4957  CD  PRO   139      53.571  37.875  56.152  1.00 14.63           C  
ATOM   4958  N   ASN   140      55.419  34.808  57.417  1.00 12.46           N  
ATOM   4959  CA  ASN   140      56.460  33.845  57.711  1.00 10.76           C  
ATOM   4960  C   ASN   140      57.542  34.465  58.631  1.00 10.92           C  
ATOM   4961  O   ASN   140      58.709  34.556  58.259  1.00 11.27           O  
ATOM   4962  CB  ASN   140      57.067  33.343  56.395  1.00 10.37           C  
ATOM   4963  CG  ASN   140      57.839  32.044  56.564  1.00 12.11           C  
ATOM   4964  OD1 ASN   140      57.293  31.043  57.044  1.00 12.13           O  
ATOM   4965  ND2 ASN   140      59.126  32.054  56.176  1.00 11.73           N  
ATOM   4966  N   PRO   141      57.145  34.894  59.845  1.00  9.73           N  
ATOM   4967  CA  PRO   141      57.996  35.713  60.714  1.00  8.93           C  
ATOM   4968  C   PRO   141      59.180  34.962  61.305  1.00  8.86           C  
ATOM   4969  O   PRO   141      59.015  33.848  61.832  1.00 10.00           O  
ATOM   4970  CB  PRO   141      57.056  36.160  61.844  1.00  8.95           C  
ATOM   4971  CG  PRO   141      55.917  35.154  61.826  1.00  9.54           C  
ATOM   4972  CD  PRO   141      55.826  34.603  60.458  1.00  9.92           C  
ATOM   4973  N   HIS   142      60.352  35.589  61.252  1.00  9.98           N  
ATOM   4974  CA  HIS   142      61.537  35.073  61.919  1.00  8.85           C  
ATOM   4975  C   HIS   142      62.138  36.109  62.858  1.00  8.43           C  
ATOM   4976  O   HIS   142      62.186  37.313  62.542  1.00  8.45           O  
ATOM   4977  CB  HIS   142      62.655  34.688  60.939  1.00  9.11           C  
ATOM   4978  CG  HIS   142      62.416  33.425  60.173  1.00  8.48           C  
ATOM   4979  ND1 HIS   142      63.165  32.291  60.363  1.00 10.07           N  
ATOM   4980  CD2 HIS   142      61.535  33.139  59.187  1.00  8.64           C  
ATOM   4981  CE1 HIS   142      62.749  31.350  59.525  1.00  8.26           C  
ATOM   4982  NE2 HIS   142      61.770  31.844  58.788  1.00  8.78           N  
ATOM   4983  N   ILE   143      62.666  35.625  63.979  1.00  7.13           N  
ATOM   4984  CA  ILE   143      63.736  36.341  64.693  1.00  8.08           C  
ATOM   4985  C   ILE   143      64.959  35.437  64.669  1.00  9.27           C  
ATOM   4986  O   ILE   143      64.889  34.307  65.156  1.00  8.91           O  
ATOM   4987  CB  ILE   143      63.392  36.694  66.158  1.00  7.68           C  
ATOM   4988  CG1 ILE   143      62.101  37.525  66.218  1.00  8.75           C  
ATOM   4989  CG2 ILE   143      64.586  37.385  66.855  1.00  8.80           C  
ATOM   4990  CD1 ILE   143      61.726  37.950  67.589  1.00  9.49           C  
ATOM   4991  N   LEU   144      66.067  35.939  64.131  1.00  8.41           N  
ATOM   4992  CA  LEU   144      67.316  35.177  64.084  1.00  8.62           C  
ATOM   4993  C   LEU   144      68.386  35.952  64.838  1.00  8.23           C  
ATOM   4994  O   LEU   144      68.756  37.060  64.432  1.00  8.96           O  
ATOM   4995  CB  LEU   144      67.739  34.959  62.640  1.00  9.69           C  
ATOM   4996  CG  LEU   144      68.944  33.999  62.466  1.00  7.56           C  
ATOM   4997  CD1 LEU   144      68.602  32.611  63.078  1.00 10.14           C  
ATOM   4998  CD2 LEU   144      69.312  33.862  61.003  1.00 10.82           C  
ATOM   4999  N   THR   145      68.862  35.377  65.942  1.00  7.76           N  
ATOM   5000  CA  THR   145      69.830  36.025  66.798  1.00  7.83           C  
ATOM   5001  C   THR   145      71.161  35.351  66.580  1.00  8.18           C  
ATOM   5002  O   THR   145      71.228  34.139  66.579  1.00  9.08           O  
ATOM   5003  CB  THR   145      69.395  35.948  68.263  1.00  8.67           C  
ATOM   5004  OG1 THR   145      68.161  36.674  68.398  1.00  7.71           O  
ATOM   5005  CG2 THR   145      70.427  36.543  69.196  1.00  9.71           C  
ATOM   5006  N   LEU   146      72.199  36.139  66.383  1.00  9.45           N  
ATOM   5007  CA  LEU   146      73.514  35.582  66.115  1.00  9.61           C  
ATOM   5008  C   LEU   146      74.244  35.352  67.441  1.00 10.74           C  
ATOM   5009  O   LEU   146      74.892  36.248  68.012  1.00 10.43           O  
ATOM   5010  CB  LEU   146      74.276  36.501  65.146  1.00 10.85           C  
ATOM   5011  CG  LEU   146      73.526  36.849  63.848  1.00 10.11           C  
ATOM   5012  CD1 LEU   146      74.460  37.650  62.891  1.00 11.64           C  
ATOM   5013  CD2 LEU   146      72.864  35.599  63.200  1.00 10.55           C  
ATOM   5014  N   ALA   147      74.062  34.146  67.964  1.00 10.19           N  
ATOM   5015  CA  ALA   147      74.465  33.801  69.319  1.00  9.82           C  
ATOM   5016  C   ALA   147      74.669  32.291  69.385  1.00  8.49           C  
ATOM   5017  O   ALA   147      74.109  31.543  68.580  1.00  9.17           O  
ATOM   5018  CB  ALA   147      73.416  34.232  70.355  1.00 10.13           C  
ATOM   5019  N   PRO   148      75.480  31.843  70.345  1.00  9.47           N  
ATOM   5020  CA  PRO   148      75.788  30.414  70.387  1.00  9.21           C  
ATOM   5021  C   PRO   148      74.721  29.572  71.101  1.00  9.33           C  
ATOM   5022  O   PRO   148      73.805  30.114  71.771  1.00  9.48           O  
ATOM   5023  CB  PRO   148      77.110  30.369  71.170  1.00  9.13           C  
ATOM   5024  CG  PRO   148      77.024  31.533  72.111  1.00  9.41           C  
ATOM   5025  CD  PRO   148      76.242  32.604  71.349  1.00  9.84           C  
ATOM   5026  N   PRO   149      74.825  28.242  70.970  1.00 10.68           N  
ATOM   5027  CA  PRO   149      73.992  27.398  71.799  1.00 10.84           C  
ATOM   5028  C   PRO   149      74.222  27.720  73.298  1.00 11.01           C  
ATOM   5029  O   PRO   149      75.353  28.008  73.701  1.00 11.27           O  
ATOM   5030  CB  PRO   149      74.441  25.974  71.425  1.00 11.31           C  
ATOM   5031  CG  PRO   149      75.058  26.107  70.082  1.00 13.25           C  
ATOM   5032  CD  PRO   149      75.689  27.455  70.069  1.00 11.23           C  
ATOM   5033  N   PRO   150      73.151  27.737  74.103  1.00 11.55           N  
ATOM   5034  CA  PRO   150      73.374  28.037  75.516  1.00 13.44           C  
ATOM   5035  C   PRO   150      74.165  26.917  76.172  1.00 12.69           C  
ATOM   5036  O   PRO   150      73.973  25.753  75.827  1.00 12.48           O  
ATOM   5037  CB  PRO   150      71.968  28.171  76.089  1.00 14.26           C  
ATOM   5038  CG  PRO   150      71.107  27.419  75.158  1.00 13.94           C  
ATOM   5039  CD  PRO   150      71.723  27.531  73.800  1.00 12.80           C  
ATOM   5040  N   SER   151      75.085  27.287  77.060  1.00 12.97           N  
ATOM   5041  CA  SER   151      75.913  26.337  77.760  1.00 12.67           C  
ATOM   5042  C   SER   151      76.224  26.798  79.189  1.00 11.79           C  
ATOM   5043  O   SER   151      76.415  27.985  79.449  1.00 10.95           O  
ATOM   5044  CB  SER   151      77.227  26.145  76.996  1.00 13.34           C  
ATOM   5045  OG  SER   151      78.177  25.447  77.782  1.00 15.32           O  
ATOM   5046  N   LEU   152      76.299  25.823  80.091  1.00 12.48           N  
ATOM   5047  CA  LEU   152      76.660  26.062  81.482  1.00 12.82           C  
ATOM   5048  C   LEU   152      78.100  25.619  81.746  1.00 13.82           C  
ATOM   5049  O   LEU   152      78.467  25.384  82.887  1.00 13.85           O  
ATOM   5050  CB  LEU   152      75.699  25.316  82.402  1.00 13.26           C  
ATOM   5051  CG  LEU   152      74.207  25.617  82.213  1.00 13.79           C  
ATOM   5052  CD1 LEU   152      73.254  24.806  83.109  1.00 16.95           C  
ATOM   5053  CD2 LEU   152      73.998  27.120  82.395  1.00 14.84           C  
ATOM   5054  N   ASN   153      78.909  25.520  80.696  1.00 14.56           N  
ATOM   5055  CA  ASN   153      80.316  25.120  80.813  1.00 15.16           C  
ATOM   5056  C   ASN   153      81.090  26.098  81.721  1.00 14.56           C  
ATOM   5057  O   ASN   153      81.274  27.238  81.359  1.00 12.48           O  
ATOM   5058  CB  ASN   153      80.953  25.082  79.412  1.00 15.67           C  
ATOM   5059  CG  ASN   153      82.402  24.595  79.428  1.00 18.65           C  
ATOM   5060  OD1 ASN   153      83.123  24.785  80.393  1.00 19.88           O  
ATOM   5061  ND2 ASN   153      82.818  23.947  78.351  1.00 19.99           N  
ATOM   5062  N   PRO   154      81.538  25.649  82.909  1.00 16.27           N  
ATOM   5063  CA  PRO   154      82.166  26.576  83.859  1.00 16.11           C  
ATOM   5064  C   PRO   154      83.430  27.274  83.360  1.00 16.70           C  
ATOM   5065  O   PRO   154      83.672  28.430  83.732  1.00 17.81           O  
ATOM   5066  CB  PRO   154      82.497  25.681  85.071  1.00 16.99           C  
ATOM   5067  CG  PRO   154      81.655  24.488  84.943  1.00 18.79           C  
ATOM   5068  CD  PRO   154      81.443  24.282  83.457  1.00 17.38           C  
ATOM   5069  N   ALA   155      84.241  26.569  82.574  1.00 16.28           N  
ATOM   5070  CA  ALA   155      85.427  27.138  81.941  1.00 15.99           C  
ATOM   5071  C   ALA   155      85.106  28.366  81.069  1.00 15.24           C  
ATOM   5072  O   ALA   155      85.818  29.369  81.106  1.00 14.81           O  
ATOM   5073  CB  ALA   155      86.139  26.059  81.097  1.00 16.78           C  
ATOM   5074  N   TRP   156      84.012  28.299  80.316  1.00 14.98           N  
ATOM   5075  CA  TRP   156      83.596  29.403  79.455  1.00 14.84           C  
ATOM   5076  C   TRP   156      83.109  30.615  80.265  1.00 14.80           C  
ATOM   5077  O   TRP   156      83.330  31.768  79.897  1.00 16.21           O  
ATOM   5078  CB  TRP   156      82.493  28.941  78.489  1.00 16.31           C  
ATOM   5079  CG  TRP   156      82.920  27.855  77.495  1.00 17.06           C  
ATOM   5080  CD1 TRP   156      84.188  27.333  77.315  1.00 17.90           C  
ATOM   5081  CD2 TRP   156      82.085  27.208  76.537  1.00 16.22           C  
ATOM   5082  NE1 TRP   156      84.169  26.398  76.309  1.00 17.25           N  
ATOM   5083  CE2 TRP   156      82.894  26.296  75.818  1.00 16.73           C  
ATOM   5084  CE3 TRP   156      80.726  27.305  76.212  1.00 15.91           C  
ATOM   5085  CZ2 TRP   156      82.385  25.474  74.814  1.00 17.44           C  
ATOM   5086  CZ3 TRP   156      80.223  26.489  75.198  1.00 17.20           C  
ATOM   5087  CH2 TRP   156      81.047  25.583  74.519  1.00 17.77           C  
ATOM   5088  N   TRP   157      82.424  30.329  81.366  1.00 13.94           N  
ATOM   5089  CA  TRP   157      81.970  31.353  82.284  1.00 13.64           C  
ATOM   5090  C   TRP   157      83.116  31.992  83.065  1.00 13.27           C  
ATOM   5091  O   TRP   157      83.147  33.196  83.195  1.00 14.25           O  
ATOM   5092  CB  TRP   157      80.866  30.814  83.193  1.00 12.20           C  
ATOM   5093  CG  TRP   157      79.571  30.678  82.408  1.00 11.88           C  
ATOM   5094  CD1 TRP   157      79.133  29.593  81.730  1.00 11.93           C  
ATOM   5095  CD2 TRP   157      78.629  31.738  82.126  1.00 11.22           C  
ATOM   5096  NE1 TRP   157      77.938  29.881  81.091  1.00 12.82           N  
ATOM   5097  CE2 TRP   157      77.616  31.191  81.321  1.00 11.10           C  
ATOM   5098  CE3 TRP   157      78.527  33.076  82.526  1.00 11.25           C  
ATOM   5099  CZ2 TRP   157      76.523  31.937  80.883  1.00 11.05           C  
ATOM   5100  CZ3 TRP   157      77.457  33.822  82.079  1.00 11.68           C  
ATOM   5101  CH2 TRP   157      76.459  33.249  81.274  1.00 11.49           C  
ATOM   5102  N   GLY   158      84.070  31.190  83.528  1.00 14.14           N  
ATOM   5103  CA  GLY   158      85.203  31.678  84.278  1.00 14.02           C  
ATOM   5104  C   GLY   158      86.217  32.465  83.452  1.00 14.82           C  
ATOM   5105  O   GLY   158      86.885  33.349  83.978  1.00 17.72           O  
ATOM   5106  N   ALA   159      86.317  32.154  82.153  1.00 14.72           N  
ATOM   5107  CA  ALA   159      87.318  32.745  81.267  1.00 14.94           C  
ATOM   5108  C   ALA   159      87.142  34.248  81.111  1.00 15.18           C  
ATOM   5109  O   ALA   159      88.131  34.992  81.027  1.00 16.65           O  
ATOM   5110  CB  ALA   159      87.289  32.061  79.925  1.00 13.67           C  
ATOM   5111  N   HIS   160      85.879  34.699  81.100  1.00 13.66           N  
ATOM   5112  CA  HIS   160      85.548  36.091  80.871  1.00 13.69           C  
ATOM   5113  C   HIS   160      84.069  36.260  81.181  1.00 13.04           C  
ATOM   5114  O   HIS   160      83.249  36.339  80.287  1.00 10.70           O  
ATOM   5115  CB  HIS   160      85.848  36.537  79.422  1.00 13.39           C  
ATOM   5116  CG  HIS   160      85.746  35.440  78.403  1.00 14.27           C  
ATOM   5117  ND1 HIS   160      84.553  34.824  78.087  1.00 14.09           N  
ATOM   5118  CD2 HIS   160      86.688  34.853  77.622  1.00 15.07           C  
ATOM   5119  CE1 HIS   160      84.764  33.903  77.165  1.00 16.60           C  
ATOM   5120  NE2 HIS   160      86.051  33.897  76.865  1.00 16.45           N  
ATOM   5121  N   THR   161      83.760  36.299  82.464  1.00 12.32           N  
ATOM   5122  CA  THR   161      82.368  36.278  82.925  1.00 12.36           C  
ATOM   5123  C   THR   161      81.500  37.381  82.324  1.00 11.52           C  
ATOM   5124  O   THR   161      80.342  37.142  81.929  1.00 11.52           O  
ATOM   5125  CB  THR   161      82.342  36.341  84.457  1.00 13.06           C  
ATOM   5126  OG1 THR   161      83.142  35.279  84.981  1.00 12.30           O  
ATOM   5127  CG2 THR   161      80.893  36.226  84.999  1.00 11.18           C  
ATOM   5128  N   GLY   162      82.041  38.594  82.211  1.00 11.50           N  
ATOM   5129  CA  GLY   162      81.234  39.705  81.696  1.00 11.59           C  
ATOM   5130  C   GLY   162      80.805  39.473  80.262  1.00 11.89           C  
ATOM   5131  O   GLY   162      79.656  39.683  79.899  1.00 11.18           O  
ATOM   5132  N   TYR   163      81.747  39.020  79.438  1.00 12.00           N  
ATOM   5133  CA  TYR   163      81.447  38.778  78.029  1.00 12.53           C  
ATOM   5134  C   TYR   163      80.522  37.563  77.840  1.00 12.08           C  
ATOM   5135  O   TYR   163      79.591  37.590  77.026  1.00 11.75           O  
ATOM   5136  CB  TYR   163      82.734  38.611  77.212  1.00 13.90           C  
ATOM   5137  CG  TYR   163      82.435  38.218  75.797  1.00 14.42           C  
ATOM   5138  CD1 TYR   163      81.652  39.033  74.997  1.00 14.43           C  
ATOM   5139  CD2 TYR   163      82.915  37.028  75.246  1.00 16.20           C  
ATOM   5140  CE1 TYR   163      81.350  38.696  73.705  1.00 15.28           C  
ATOM   5141  CE2 TYR   163      82.603  36.674  73.949  1.00 15.68           C  
ATOM   5142  CZ  TYR   163      81.813  37.513  73.182  1.00 14.96           C  
ATOM   5143  OH  TYR   163      81.489  37.202  71.880  1.00 17.96           O  
ATOM   5144  N   THR   164      80.803  36.493  78.569  1.00 11.34           N  
ATOM   5145  CA  THR   164      80.000  35.279  78.487  1.00 10.60           C  
ATOM   5146  C   THR   164      78.557  35.593  78.903  1.00 10.53           C  
ATOM   5147  O   THR   164      77.625  35.171  78.220  1.00 11.15           O  
ATOM   5148  CB  THR   164      80.597  34.158  79.318  1.00 10.90           C  
ATOM   5149  OG1 THR   164      81.939  33.874  78.843  1.00  9.94           O  
ATOM   5150  CG2 THR   164      79.751  32.877  79.220  1.00  8.86           C  
ATOM   5151  N   LEU   165      78.384  36.349  79.986  1.00 10.04           N  
ATOM   5152  CA  LEU   165      77.055  36.780  80.403  1.00 10.99           C  
ATOM   5153  C   LEU   165      76.352  37.508  79.259  1.00 11.20           C  
ATOM   5154  O   LEU   165      75.185  37.251  78.985  1.00 11.03           O  
ATOM   5155  CB  LEU   165      77.144  37.728  81.612  1.00 10.74           C  
ATOM   5156  CG  LEU   165      75.811  38.062  82.282  1.00 10.97           C  
ATOM   5157  CD1 LEU   165      75.159  36.786  82.895  1.00 12.62           C  
ATOM   5158  CD2 LEU   165      75.973  39.174  83.356  1.00 11.21           C  
ATOM   5159  N   ALA   166      77.068  38.431  78.604  1.00 11.10           N  
ATOM   5160  CA  ALA   166      76.474  39.264  77.550  1.00 10.84           C  
ATOM   5161  C   ALA   166      76.073  38.457  76.326  1.00 11.42           C  
ATOM   5162  O   ALA   166      74.969  38.621  75.804  1.00 10.68           O  
ATOM   5163  CB  ALA   166      77.403  40.407  77.140  1.00 11.67           C  
ATOM   5164  N   LYS   167      76.951  37.571  75.884  1.00 11.98           N  
ATOM   5165  CA  LYS   167      76.727  36.830  74.630  1.00 12.54           C  
ATOM   5166  C   LYS   167      75.839  35.627  74.874  1.00 11.75           C  
ATOM   5167  O   LYS   167      74.891  35.390  74.115  1.00 12.03           O  
ATOM   5168  CB  LYS   167      78.053  36.402  73.991  1.00 13.01           C  
ATOM   5169  CG  LYS   167      77.943  36.218  72.469  1.00 15.17           C  
ATOM   5170  CD  LYS   167      77.892  37.601  71.798  1.00 17.60           C  
ATOM   5171  CE  LYS   167      77.480  37.602  70.363  1.00 21.69           C  
ATOM   5172  NZ  LYS   167      77.482  39.019  69.896  1.00 23.77           N  
ATOM   5173  N   MET   168      76.095  34.873  75.938  1.00 10.34           N  
ATOM   5174  CA  MET   168      75.119  33.851  76.326  1.00 10.50           C  
ATOM   5175  C   MET   168      73.760  34.492  76.627  1.00 10.74           C  
ATOM   5176  O   MET   168      72.737  33.864  76.443  1.00 11.42           O  
ATOM   5177  CB  MET   168      75.592  32.997  77.487  1.00 11.10           C  
ATOM   5178  CG  MET   168      76.757  32.126  77.107  1.00 12.68           C  
ATOM   5179  SD  MET   168      76.108  30.665  75.946  1.00 19.95          SE  
ATOM   5180  CE  MET   168      77.842  29.786  75.485  1.00 10.61           C  
ATOM   5181  N   GLY   169      73.757  35.738  77.087  1.00 11.10           N  
ATOM   5182  CA  GLY   169      72.487  36.444  77.328  1.00 10.54           C  
ATOM   5183  C   GLY   169      71.662  36.546  76.068  1.00 10.60           C  
ATOM   5184  O   GLY   169      70.401  36.490  76.123  1.00  9.88           O  
ATOM   5185  N   MET   170      72.323  36.713  74.919  1.00 10.12           N  
ATOM   5186  CA  MET   170      71.602  36.754  73.648  1.00 13.27           C  
ATOM   5187  C   MET   170      70.969  35.403  73.353  1.00 11.19           C  
ATOM   5188  O   MET   170      69.841  35.333  72.875  1.00 10.49           O  
ATOM   5189  CB  MET   170      72.523  37.166  72.496  1.00 12.00           C  
ATOM   5190  CG  MET   170      72.855  38.616  72.502  1.00 14.77           C  
ATOM   5191  SD  MET   170      74.197  39.010  71.113  1.00 23.37          SE  
ATOM   5192  CE  MET   170      73.059  38.764  69.527  1.00 17.34           C  
ATOM   5193  N   SER   171      71.703  34.329  73.645  1.00 10.04           N  
ATOM   5194  CA  SER   171      71.198  32.953  73.510  1.00 10.06           C  
ATOM   5195  C   SER   171      70.010  32.670  74.429  1.00  9.55           C  
ATOM   5196  O   SER   171      69.042  32.033  74.028  1.00  8.84           O  
ATOM   5197  CB  SER   171      72.321  31.940  73.793  1.00 10.61           C  
ATOM   5198  OG  SER   171      73.515  32.341  73.128  1.00  9.88           O  
ATOM   5199  N   LEU   172      70.057  33.211  75.646  1.00  9.34           N  
ATOM   5200  CA  LEU   172      69.070  32.932  76.669  1.00  9.39           C  
ATOM   5201  C   LEU   172      67.785  33.752  76.435  1.00 10.31           C  
ATOM   5202  O   LEU   172      66.677  33.251  76.618  1.00 10.52           O  
ATOM   5203  CB  LEU   172      69.661  33.146  78.057  1.00  9.93           C  
ATOM   5204  CG  LEU   172      70.796  32.181  78.409  1.00 10.49           C  
ATOM   5205  CD1 LEU   172      71.469  32.706  79.679  1.00 13.66           C  
ATOM   5206  CD2 LEU   172      70.291  30.709  78.581  1.00 13.42           C  
ATOM   5207  N   VAL   173      67.952  34.993  75.978  1.00 11.39           N  
ATOM   5208  CA  VAL   173      66.839  35.772  75.445  1.00 10.64           C  
ATOM   5209  C   VAL   173      66.154  35.028  74.300  1.00 11.23           C  
ATOM   5210  O   VAL   173      64.918  34.943  74.269  1.00 11.24           O  
ATOM   5211  CB  VAL   173      67.291  37.195  75.021  1.00 10.93           C  
ATOM   5212  CG1 VAL   173      66.261  37.906  74.103  1.00  9.87           C  
ATOM   5213  CG2 VAL   173      67.607  38.028  76.268  1.00 11.90           C  
ATOM   5214  N   THR   174      66.938  34.471  73.376  1.00 10.79           N  
ATOM   5215  CA  THR   174      66.376  33.668  72.287  1.00 10.55           C  
ATOM   5216  C   THR   174      65.586  32.466  72.836  1.00 10.31           C  
ATOM   5217  O   THR   174      64.503  32.181  72.383  1.00  9.27           O  
ATOM   5218  CB  THR   174      67.467  33.169  71.328  1.00 11.68           C  
ATOM   5219  OG1 THR   174      68.128  34.291  70.737  1.00 10.40           O  
ATOM   5220  CG2 THR   174      66.857  32.276  70.221  1.00 14.65           C  
ATOM   5221  N   LEU   175      66.173  31.762  73.798  1.00  9.89           N  
ATOM   5222  CA  LEU   175      65.532  30.604  74.478  1.00 10.76           C  
ATOM   5223  C   LEU   175      64.148  30.968  75.037  1.00 10.60           C  
ATOM   5224  O   LEU   175      63.162  30.274  74.781  1.00 11.15           O  
ATOM   5225  CB  LEU   175      66.472  30.117  75.590  1.00 10.82           C  
ATOM   5226  CG  LEU   175      66.125  28.826  76.327  1.00 14.98           C  
ATOM   5227  CD1 LEU   175      66.054  27.656  75.367  1.00 16.59           C  
ATOM   5228  CD2 LEU   175      67.119  28.559  77.475  1.00 14.66           C  
ATOM   5229  N   GLY   176      64.076  32.093  75.745  1.00  9.37           N  
ATOM   5230  CA  GLY   176      62.833  32.576  76.339  1.00  9.14           C  
ATOM   5231  C   GLY   176      61.830  33.089  75.334  1.00  9.80           C  
ATOM   5232  O   GLY   176      60.641  32.810  75.447  1.00  9.37           O  
ATOM   5233  N   LEU   177      62.295  33.911  74.404  1.00  9.70           N  
ATOM   5234  CA  LEU   177      61.442  34.424  73.350  1.00  9.48           C  
ATOM   5235  C   LEU   177      60.778  33.274  72.550  1.00  8.52           C  
ATOM   5236  O   LEU   177      59.566  33.305  72.253  1.00  9.73           O  
ATOM   5237  CB  LEU   177      62.249  35.331  72.431  1.00  9.06           C  
ATOM   5238  CG  LEU   177      62.696  36.710  72.924  1.00 10.74           C  
ATOM   5239  CD1 LEU   177      63.597  37.313  71.853  1.00 11.62           C  
ATOM   5240  CD2 LEU   177      61.504  37.626  73.284  1.00 12.30           C  
ATOM   5241  N   ALA   178      61.566  32.256  72.216  1.00  8.43           N  
ATOM   5242  CA  ALA   178      61.093  31.109  71.453  1.00  9.28           C  
ATOM   5243  C   ALA   178      60.042  30.336  72.235  1.00 10.35           C  
ATOM   5244  O   ALA   178      59.033  29.929  71.680  1.00 12.33           O  
ATOM   5245  CB  ALA   178      62.282  30.197  71.065  1.00  8.50           C  
ATOM   5246  N   ALA   179      60.254  30.180  73.533  1.00  9.75           N  
ATOM   5247  CA  ALA   179      59.303  29.481  74.387  1.00  9.25           C  
ATOM   5248  C   ALA   179      58.010  30.275  74.495  1.00  9.33           C  
ATOM   5249  O   ALA   179      56.932  29.689  74.462  1.00 11.27           O  
ATOM   5250  CB  ALA   179      59.889  29.198  75.767  1.00  9.17           C  
ATOM   5251  N   GLU   180      58.102  31.598  74.575  1.00  9.20           N  
ATOM   5252  CA  GLU   180      56.897  32.431  74.672  1.00 10.66           C  
ATOM   5253  C   GLU   180      56.156  32.548  73.327  1.00 11.36           C  
ATOM   5254  O   GLU   180      54.948  32.296  73.260  1.00 13.31           O  
ATOM   5255  CB  GLU   180      57.199  33.824  75.238  1.00 10.57           C  
ATOM   5256  CG  GLU   180      55.909  34.623  75.449  1.00 12.04           C  
ATOM   5257  CD  GLU   180      56.024  35.918  76.272  1.00 12.93           C  
ATOM   5258  OE1 GLU   180      57.140  36.401  76.585  1.00 12.71           O  
ATOM   5259  OE2 GLU   180      54.928  36.453  76.579  1.00 13.47           O  
ATOM   5260  N   PHE   181      56.876  32.935  72.268  1.00 10.03           N  
ATOM   5261  CA  PHE   181      56.241  33.340  71.006  1.00  9.11           C  
ATOM   5262  C   PHE   181      56.311  32.308  69.872  1.00  9.14           C  
ATOM   5263  O   PHE   181      55.526  32.373  68.907  1.00  8.76           O  
ATOM   5264  CB  PHE   181      56.790  34.687  70.529  1.00  8.81           C  
ATOM   5265  CG  PHE   181      56.602  35.780  71.528  1.00  8.08           C  
ATOM   5266  CD1 PHE   181      55.378  36.399  71.658  1.00 10.81           C  
ATOM   5267  CD2 PHE   181      57.633  36.145  72.383  1.00  8.50           C  
ATOM   5268  CE1 PHE   181      55.179  37.385  72.606  1.00 13.06           C  
ATOM   5269  CE2 PHE   181      57.445  37.144  73.331  1.00 11.65           C  
ATOM   5270  CZ  PHE   181      56.206  37.750  73.445  1.00 10.19           C  
ATOM   5271  N   GLY   182      57.243  31.373  69.976  1.00  8.25           N  
ATOM   5272  CA  GLY   182      57.374  30.259  69.046  1.00  9.83           C  
ATOM   5273  C   GLY   182      56.049  29.554  68.803  1.00 10.22           C  
ATOM   5274  O   GLY   182      55.683  29.290  67.645  1.00 10.48           O  
ATOM   5275  N   PRO   183      55.312  29.266  69.892  1.00 11.08           N  
ATOM   5276  CA  PRO   183      53.963  28.671  69.718  1.00 12.39           C  
ATOM   5277  C   PRO   183      52.947  29.455  68.867  1.00 13.67           C  
ATOM   5278  O   PRO   183      52.015  28.824  68.319  1.00 14.71           O  
ATOM   5279  CB  PRO   183      53.482  28.491  71.155  1.00 12.40           C  
ATOM   5280  CG  PRO   183      54.800  28.346  71.972  1.00 11.55           C  
ATOM   5281  CD  PRO   183      55.674  29.382  71.314  1.00 12.27           C  
ATOM   5282  N   GLN   184      53.152  30.767  68.710  1.00 13.30           N  
ATOM   5283  CA  GLN   184      52.369  31.623  67.809  1.00 15.86           C  
ATOM   5284  C   GLN   184      52.832  31.589  66.346  1.00 15.32           C  
ATOM   5285  O   GLN   184      52.274  32.308  65.506  1.00 16.18           O  
ATOM   5286  CB  GLN   184      52.369  33.073  68.290  1.00 17.64           C  
ATOM   5287  CG  GLN   184      51.963  33.232  69.728  1.00 22.03           C  
ATOM   5288  CD  GLN   184      51.321  34.561  69.989  1.00 25.53           C  
ATOM   5289  OE1 GLN   184      50.299  34.902  69.375  1.00 29.99           O  
ATOM   5290  NE2 GLN   184      51.912  35.335  70.875  1.00 25.73           N  
ATOM   5291  N   GLY   185      53.845  30.777  66.061  1.00 13.43           N  
ATOM   5292  CA  GLY   185      54.344  30.563  64.705  1.00 13.34           C  
ATOM   5293  C   GLY   185      55.509  31.472  64.316  1.00 12.38           C  
ATOM   5294  O   GLY   185      55.856  31.555  63.128  1.00 11.77           O  
ATOM   5295  N   VAL   186      56.104  32.158  65.283  1.00 11.41           N  
ATOM   5296  CA  VAL   186      57.310  32.964  65.015  1.00  9.94           C  
ATOM   5297  C   VAL   186      58.534  32.043  65.073  1.00 10.45           C  
ATOM   5298  O   VAL   186      58.731  31.360  66.068  1.00 10.06           O  
ATOM   5299  CB  VAL   186      57.482  34.150  66.025  1.00 10.23           C  
ATOM   5300  CG1 VAL   186      58.684  35.044  65.578  1.00  8.77           C  
ATOM   5301  CG2 VAL   186      56.174  34.979  66.166  1.00 12.50           C  
ATOM   5302  N   ALA   187      59.359  32.039  64.016  1.00  9.98           N  
ATOM   5303  CA  ALA   187      60.599  31.240  63.996  1.00  9.28           C  
ATOM   5304  C   ALA   187      61.705  32.004  64.719  1.00  8.67           C  
ATOM   5305  O   ALA   187      62.406  32.837  64.124  1.00  9.41           O  
ATOM   5306  CB  ALA   187      61.005  30.888  62.601  1.00 10.54           C  
ATOM   5307  N   ILE   188      61.829  31.731  66.019  1.00  7.96           N  
ATOM   5308  CA  ILE   188      62.789  32.419  66.865  1.00  7.80           C  
ATOM   5309  C   ILE   188      63.915  31.423  67.152  1.00  7.32           C  
ATOM   5310  O   ILE   188      63.735  30.474  67.939  1.00  7.86           O  
ATOM   5311  CB  ILE   188      62.138  32.927  68.173  1.00  8.58           C  
ATOM   5312  CG1 ILE   188      60.963  33.856  67.842  1.00  8.13           C  
ATOM   5313  CG2 ILE   188      63.167  33.613  69.044  1.00  8.17           C  
ATOM   5314  CD1 ILE   188      60.276  34.446  69.053  1.00  8.96           C  
ATOM   5315  N   ASN   189      65.061  31.656  66.507  1.00  7.47           N  
ATOM   5316  CA  ASN   189      66.195  30.746  66.563  1.00  6.87           C  
ATOM   5317  C   ASN   189      67.498  31.548  66.687  1.00  8.06           C  
ATOM   5318  O   ASN   189      67.479  32.781  66.546  1.00  8.59           O  
ATOM   5319  CB  ASN   189      66.229  29.878  65.307  1.00  6.70           C  
ATOM   5320  CG  ASN   189      64.984  29.063  65.129  1.00  7.66           C  
ATOM   5321  OD1 ASN   189      64.724  28.150  65.905  1.00  7.79           O  
ATOM   5322  ND2 ASN   189      64.198  29.391  64.107  1.00 12.41           N  
ATOM   5323  N   ALA   190      68.609  30.835  66.915  1.00  8.26           N  
ATOM   5324  CA  ALA   190      69.944  31.450  66.876  1.00  9.32           C  
ATOM   5325  C   ALA   190      70.812  30.760  65.807  1.00  9.09           C  
ATOM   5326  O   ALA   190      70.573  29.599  65.475  1.00 10.07           O  
ATOM   5327  CB  ALA   190      70.648  31.359  68.209  1.00  9.25           C  
ATOM   5328  N   LEU   191      71.816  31.489  65.330  1.00 10.36           N  
ATOM   5329  CA  LEU   191      72.845  31.007  64.377  1.00  9.17           C  
ATOM   5330  C   LEU   191      74.238  31.462  64.835  1.00  9.57           C  
ATOM   5331  O   LEU   191      74.447  32.636  65.207  1.00  8.55           O  
ATOM   5332  CB  LEU   191      72.578  31.536  62.977  1.00  9.89           C  
ATOM   5333  CG  LEU   191      73.450  31.125  61.779  1.00 10.91           C  
ATOM   5334  CD1 LEU   191      73.372  29.626  61.545  1.00 10.30           C  
ATOM   5335  CD2 LEU   191      73.041  31.909  60.526  1.00  8.61           C  
ATOM   5336  N   TRP   192      75.178  30.531  64.784  1.00  9.45           N  
ATOM   5337  CA  TRP   192      76.544  30.741  65.277  1.00  9.01           C  
ATOM   5338  C   TRP   192      77.514  30.051  64.316  1.00  9.84           C  
ATOM   5339  O   TRP   192      77.222  28.952  63.839  1.00 10.90           O  
ATOM   5340  CB  TRP   192      76.679  30.144  66.673  1.00 10.80           C  
ATOM   5341  CG  TRP   192      77.856  30.603  67.439  1.00 10.61           C  
ATOM   5342  CD1 TRP   192      78.886  29.835  67.918  1.00 11.57           C  
ATOM   5343  CD2 TRP   192      78.141  31.952  67.839  1.00  9.13           C  
ATOM   5344  NE1 TRP   192      79.795  30.622  68.579  1.00 11.20           N  
ATOM   5345  CE2 TRP   192      79.364  31.923  68.557  1.00 11.68           C  
ATOM   5346  CE3 TRP   192      77.485  33.174  67.670  1.00 10.78           C  
ATOM   5347  CZ2 TRP   192      79.937  33.070  69.096  1.00 11.29           C  
ATOM   5348  CZ3 TRP   192      78.054  34.314  68.202  1.00 11.27           C  
ATOM   5349  CH2 TRP   192      79.278  34.253  68.914  1.00 12.30           C  
ATOM   5350  N   PRO   193      78.667  30.690  64.040  1.00  9.62           N  
ATOM   5351  CA  PRO   193      79.621  30.077  63.136  1.00 10.38           C  
ATOM   5352  C   PRO   193      80.513  29.019  63.797  1.00 10.94           C  
ATOM   5353  O   PRO   193      80.984  29.202  64.911  1.00  9.98           O  
ATOM   5354  CB  PRO   193      80.468  31.273  62.659  1.00 11.12           C  
ATOM   5355  CG  PRO   193      80.326  32.291  63.639  1.00 10.94           C  
ATOM   5356  CD  PRO   193      79.099  32.025  64.469  1.00 10.76           C  
ATOM   5357  N   ARG   194      80.776  27.930  63.080  1.00 10.77           N  
ATOM   5358  CA  ARG   194      81.727  26.913  63.570  1.00 10.69           C  
ATOM   5359  C   ARG   194      83.095  27.509  63.851  1.00 10.70           C  
ATOM   5360  O   ARG   194      83.748  27.156  64.828  1.00  9.13           O  
ATOM   5361  CB  ARG   194      81.890  25.806  62.532  1.00 11.19           C  
ATOM   5362  CG  ARG   194      82.814  24.686  62.960  1.00 11.22           C  
ATOM   5363  CD  ARG   194      82.180  23.835  64.078  1.00 12.94           C  
ATOM   5364  NE  ARG   194      81.005  23.167  63.543  1.00 12.73           N  
ATOM   5365  CZ  ARG   194      80.118  22.480  64.255  1.00 14.19           C  
ATOM   5366  NH1 ARG   194      80.286  22.324  65.558  1.00 16.53           N  
ATOM   5367  NH2 ARG   194      79.055  21.952  63.652  1.00 14.05           N  
ATOM   5368  N   THR   195      83.534  28.379  62.955  1.00 11.24           N  
ATOM   5369  CA  THR   195      84.879  28.978  63.046  1.00 11.59           C  
ATOM   5370  C   THR   195      84.790  30.461  63.425  1.00 12.97           C  
ATOM   5371  O   THR   195      83.704  31.053  63.383  1.00 13.53           O  
ATOM   5372  CB  THR   195      85.620  28.929  61.676  1.00 12.60           C  
ATOM   5373  OG1 THR   195      85.032  29.877  60.754  1.00 11.19           O  
ATOM   5374  CG2 THR   195      85.676  27.489  61.118  1.00 12.90           C  
ATOM   5375  N   VAL   196      85.942  31.073  63.701  1.00 11.44           N  
ATOM   5376  CA  VAL   196      86.008  32.521  63.839  1.00 11.47           C  
ATOM   5377  C   VAL   196      85.730  33.097  62.442  1.00 11.64           C  
ATOM   5378  O   VAL   196      86.074  32.485  61.403  1.00 10.13           O  
ATOM   5379  CB  VAL   196      87.356  33.001  64.413  1.00 11.27           C  
ATOM   5380  CG1 VAL   196      87.401  34.512  64.542  1.00 12.44           C  
ATOM   5381  CG2 VAL   196      87.597  32.355  65.780  1.00 10.12           C  
ATOM   5382  N   ILE   197      85.028  34.226  62.435  1.00 12.21           N  
ATOM   5383  CA  ILE   197      84.747  34.958  61.223  1.00 13.19           C  
ATOM   5384  C   ILE   197      85.583  36.247  61.188  1.00 14.47           C  
ATOM   5385  O   ILE   197      85.707  36.958  62.194  1.00 14.39           O  
ATOM   5386  CB  ILE   197      83.248  35.297  61.152  1.00 12.45           C  
ATOM   5387  CG1 ILE   197      82.388  34.023  61.239  1.00 13.93           C  
ATOM   5388  CG2 ILE   197      82.920  36.119  59.895  1.00 13.55           C  
ATOM   5389  CD1 ILE   197      82.545  33.084  60.053  1.00 14.19           C  
ATOM   5390  N   ALA   198      86.141  36.551  60.019  1.00 16.97           N  
ATOM   5391  CA  ALA   198      86.989  37.753  59.860  1.00 17.70           C  
ATOM   5392  C   ALA   198      86.111  39.009  59.807  1.00 18.75           C  
ATOM   5393  O   ALA   198      85.349  39.217  58.860  1.00 18.30           O  
ATOM   5394  CB  ALA   198      87.888  37.641  58.600  1.00 17.80           C  
ATOM   5395  N   THR   199      86.212  39.798  60.868  1.00 21.42           N  
ATOM   5396  CA  THR   199      85.578  41.116  61.002  1.00 24.66           C  
ATOM   5397  C   THR   199      86.500  41.968  61.873  1.00 26.60           C  
ATOM   5398  O   THR   199      87.403  41.432  62.484  1.00 26.00           O  
ATOM   5399  CB  THR   199      84.227  41.037  61.739  1.00 25.02           C  
ATOM   5400  OG1 THR   199      84.442  40.752  63.136  1.00 26.53           O  
ATOM   5401  CG2 THR   199      83.326  39.977  61.142  1.00 25.09           C  
ATOM   5402  N   ASP   200      86.223  43.270  61.970  1.00 29.31           N  
ATOM   5403  CA  ASP   200      86.932  44.183  62.889  1.00 30.32           C  
ATOM   5404  C   ASP   200      87.104  43.664  64.326  1.00 31.53           C  
ATOM   5405  O   ASP   200      88.110  43.967  64.981  1.00 32.46           O  
ATOM   5406  CB  ASP   200      86.198  45.525  62.943  1.00 31.47           C  
ATOM   5407  N   ALA   201      86.135  42.878  64.800  1.00 31.69           N  
ATOM   5408  CA  ALA   201      86.127  42.324  66.166  1.00 31.93           C  
ATOM   5409  C   ALA   201      87.251  41.332  66.487  1.00 32.03           C  
ATOM   5410  O   ALA   201      87.487  41.038  67.662  1.00 31.34           O  
ATOM   5411  CB  ALA   201      84.795  41.663  66.443  1.00 32.18           C  
ATOM   5412  N   ILE   202      87.932  40.801  65.467  1.00 31.53           N  
ATOM   5413  CA  ILE   202      89.063  39.902  65.713  1.00 31.58           C  
ATOM   5414  C   ILE   202      90.234  40.678  66.357  1.00 32.11           C  
ATOM   5415  O   ILE   202      91.125  40.084  66.978  1.00 31.21           O  
ATOM   5416  CB  ILE   202      89.485  39.082  64.436  1.00 31.88           C  
ATOM   5417  CG1 ILE   202      90.197  39.944  63.389  1.00 32.24           C  
ATOM   5418  CG2 ILE   202      88.262  38.397  63.811  1.00 31.23           C  
ATOM   5419  CD1 ILE   202      90.743  39.116  62.219  1.00 31.43           C  
ATOM   5420  N   ASN   203      90.198  42.007  66.237  1.00 32.73           N  
ATOM   5421  CA  ASN   203      91.054  42.892  67.029  1.00 34.45           C  
ATOM   5422  C   ASN   203      90.952  42.646  68.543  1.00 35.71           C  
ATOM   5423  O   ASN   203      91.914  42.909  69.274  1.00 36.12           O  
ATOM   5424  CB  ASN   203      90.715  44.354  66.734  1.00 34.31           C  
ATOM   5425  N   MET   204      89.790  42.155  68.997  1.00 36.69           N  
ATOM   5426  CA  MET   204      89.535  41.843  70.422  1.00 38.17           C  
ATOM   5427  C   MET   204      89.874  40.391  70.771  1.00 37.20           C  
ATOM   5428  O   MET   204      89.632  39.938  71.896  1.00 36.41           O  
ATOM   5429  CB  MET   204      88.062  42.091  70.766  1.00 40.03           C  
ATOM   5430  CG  MET   204      87.529  43.449  70.311  1.00 44.85           C  
ATOM   5431  SD  MET   204      88.510  44.923  71.156  1.00 54.38          SE  
ATOM   5432  CE  MET   204      87.862  44.661  72.974  1.00 51.52           C  
ATOM   5433  N   LEU   205      90.416  39.671  69.793  1.00 35.72           N  
ATOM   5434  CA  LEU   205      90.858  38.304  69.967  1.00 34.98           C  
ATOM   5435  C   LEU   205      92.377  38.279  69.775  1.00 35.18           C  
ATOM   5436  O   LEU   205      92.865  38.245  68.643  1.00 34.54           O  
ATOM   5437  CB  LEU   205      90.148  37.394  68.952  1.00 34.68           C  
ATOM   5438  CG  LEU   205      88.614  37.490  68.924  1.00 33.90           C  
ATOM   5439  CD1 LEU   205      88.037  36.670  67.789  1.00 33.73           C  
ATOM   5440  CD2 LEU   205      88.026  37.038  70.242  1.00 32.96           C  
ATOM   5441  N   PRO   206      93.136  38.348  70.882  1.00 35.71           N  
ATOM   5442  CA  PRO   206      94.597  38.309  70.775  1.00 35.39           C  
ATOM   5443  C   PRO   206      95.100  37.148  69.922  1.00 34.40           C  
ATOM   5444  O   PRO   206      94.643  36.016  70.072  1.00 34.60           O  
ATOM   5445  CB  PRO   206      95.058  38.150  72.229  1.00 35.54           C  
ATOM   5446  CG  PRO   206      93.972  38.750  73.037  1.00 36.25           C  
ATOM   5447  CD  PRO   206      92.692  38.510  72.281  1.00 36.21           C  
ATOM   5448  N   GLY   207      96.019  37.451  69.015  1.00 34.01           N  
ATOM   5449  CA  GLY   207      96.646  36.439  68.171  1.00 33.22           C  
ATOM   5450  C   GLY   207      95.911  36.060  66.890  1.00 32.07           C  
ATOM   5451  O   GLY   207      96.522  35.448  66.002  1.00 32.72           O  
ATOM   5452  N   VAL   208      94.624  36.409  66.783  1.00 30.05           N  
ATOM   5453  CA  VAL   208      93.756  35.957  65.671  1.00 27.96           C  
ATOM   5454  C   VAL   208      93.990  36.753  64.385  1.00 27.04           C  
ATOM   5455  O   VAL   208      93.672  37.942  64.316  1.00 27.08           O  
ATOM   5456  CB  VAL   208      92.250  36.048  66.054  1.00 28.33           C  
ATOM   5457  CG1 VAL   208      91.345  35.662  64.876  1.00 26.35           C  
ATOM   5458  CG2 VAL   208      91.955  35.168  67.254  1.00 27.54           C  
ATOM   5459  N   ASP   209      94.530  36.087  63.365  1.00 24.99           N  
ATOM   5460  CA  ASP   209      94.710  36.684  62.039  1.00 23.73           C  
ATOM   5461  C   ASP   209      93.466  36.381  61.216  1.00 21.98           C  
ATOM   5462  O   ASP   209      92.914  35.275  61.322  1.00 22.45           O  
ATOM   5463  CB  ASP   209      95.953  36.107  61.337  1.00 24.39           C  
ATOM   5464  N   ALA   210      93.033  37.354  60.414  1.00 19.90           N  
ATOM   5465  CA  ALA   210      91.928  37.172  59.477  1.00 18.55           C  
ATOM   5466  C   ALA   210      92.178  35.961  58.577  1.00 18.54           C  
ATOM   5467  O   ALA   210      91.233  35.279  58.206  1.00 16.36           O  
ATOM   5468  CB  ALA   210      91.725  38.381  58.635  1.00 18.39           C  
ATOM   5469  N   ALA   211      93.453  35.698  58.251  1.00 19.22           N  
ATOM   5470  CA  ALA   211      93.823  34.559  57.396  1.00 19.77           C  
ATOM   5471  C   ALA   211      93.396  33.177  57.928  1.00 18.66           C  
ATOM   5472  O   ALA   211      93.265  32.230  57.141  1.00 19.01           O  
ATOM   5473  CB  ALA   211      95.327  34.572  57.128  1.00 21.00           C  
ATOM   5474  N   ALA   212      93.189  33.060  59.243  1.00 17.16           N  
ATOM   5475  CA  ALA   212      92.806  31.799  59.875  1.00 17.32           C  
ATOM   5476  C   ALA   212      91.303  31.720  60.146  1.00 15.98           C  
ATOM   5477  O   ALA   212      90.850  30.865  60.903  1.00 16.45           O  
ATOM   5478  CB  ALA   212      93.583  31.597  61.193  1.00 19.36           C  
ATOM   5479  N   CYS   213      90.548  32.587  59.477  1.00 15.68           N  
ATOM   5480  CA  CYS   213      89.096  32.724  59.665  1.00 14.96           C  
ATOM   5481  C   CYS   213      88.347  32.398  58.401  1.00 13.90           C  
ATOM   5482  O   CYS   213      88.930  32.247  57.312  1.00 11.30           O  
ATOM   5483  CB  CYS   213      88.779  34.173  60.037  1.00 16.04           C  
ATOM   5484  SG  CYS   213      89.465  34.687  61.599  1.00 18.31           S  
ATOM   5485  N   ARG   214      87.028  32.321  58.541  1.00 11.55           N  
ATOM   5486  CA  ARG   214      86.146  32.352  57.377  1.00 11.17           C  
ATOM   5487  C   ARG   214      85.580  33.749  57.101  1.00 11.47           C  
ATOM   5488  O   ARG   214      85.539  34.626  57.993  1.00 10.53           O  
ATOM   5489  CB  ARG   214      85.013  31.352  57.523  1.00  9.96           C  
ATOM   5490  CG  ARG   214      85.378  29.941  57.116  1.00 10.13           C  
ATOM   5491  CD  ARG   214      84.332  28.940  57.540  1.00 13.06           C  
ATOM   5492  NE  ARG   214      84.674  27.599  57.086  1.00 11.49           N  
ATOM   5493  CZ  ARG   214      84.153  26.484  57.587  1.00 14.37           C  
ATOM   5494  NH1 ARG   214      83.233  26.531  58.552  1.00 14.60           N  
ATOM   5495  NH2 ARG   214      84.546  25.319  57.082  1.00 15.69           N  
ATOM   5496  N   ARG   215      85.191  33.946  55.854  1.00 11.96           N  
ATOM   5497  CA  ARG   215      84.573  35.193  55.404  1.00 13.62           C  
ATOM   5498  C   ARG   215      83.150  35.307  55.975  1.00 13.79           C  
ATOM   5499  O   ARG   215      82.469  34.282  56.179  1.00 11.81           O  
ATOM   5500  CB  ARG   215      84.546  35.244  53.871  1.00 15.28           C  
ATOM   5501  CG  ARG   215      85.990  35.211  53.309  1.00 18.33           C  
ATOM   5502  CD  ARG   215      86.047  35.215  51.806  1.00 24.21           C  
ATOM   5503  NE  ARG   215      85.094  34.272  51.253  1.00 28.15           N  
ATOM   5504  CZ  ARG   215      84.003  34.585  50.547  1.00 29.00           C  
ATOM   5505  NH1 ARG   215      83.716  35.842  50.227  1.00 30.59           N  
ATOM   5506  NH2 ARG   215      83.203  33.614  50.121  1.00 28.92           N  
ATOM   5507  N   PRO   216      82.682  36.556  56.199  1.00 13.39           N  
ATOM   5508  CA  PRO   216      81.301  36.730  56.690  1.00 13.19           C  
ATOM   5509  C   PRO   216      80.209  36.108  55.804  1.00 12.29           C  
ATOM   5510  O   PRO   216      79.103  35.859  56.313  1.00 10.07           O  
ATOM   5511  CB  PRO   216      81.120  38.247  56.741  1.00 14.69           C  
ATOM   5512  CG  PRO   216      82.496  38.852  56.576  1.00 16.80           C  
ATOM   5513  CD  PRO   216      83.400  37.829  56.004  1.00 13.98           C  
ATOM   5514  N   GLU   217      80.494  35.898  54.504  1.00 10.14           N  
ATOM   5515  CA  GLU   217      79.524  35.356  53.563  1.00  9.80           C  
ATOM   5516  C   GLU   217      79.001  33.955  53.979  1.00  9.93           C  
ATOM   5517  O   GLU   217      77.877  33.596  53.621  1.00 10.64           O  
ATOM   5518  CB  GLU   217      80.075  35.346  52.131  1.00 11.56           C  
ATOM   5519  CG  GLU   217      80.152  36.741  51.466  1.00 13.90           C  
ATOM   5520  CD  GLU   217      81.203  37.674  52.049  1.00 15.89           C  
ATOM   5521  OE1 GLU   217      82.190  37.184  52.627  1.00 14.96           O  
ATOM   5522  OE2 GLU   217      81.053  38.924  51.907  1.00 19.39           O  
ATOM   5523  N   ILE   218      79.782  33.174  54.733  1.00  9.54           N  
ATOM   5524  CA  ILE   218      79.265  31.870  55.216  1.00  9.51           C  
ATOM   5525  C   ILE   218      78.061  32.085  56.149  1.00  8.43           C  
ATOM   5526  O   ILE   218      77.044  31.361  56.049  1.00  9.07           O  
ATOM   5527  CB  ILE   218      80.356  30.962  55.875  1.00  9.51           C  
ATOM   5528  CG1 ILE   218      79.776  29.532  56.010  1.00 10.71           C  
ATOM   5529  CG2 ILE   218      80.869  31.523  57.243  1.00  9.59           C  
ATOM   5530  CD1 ILE   218      80.721  28.472  56.519  1.00 10.01           C  
ATOM   5531  N   MET   219      78.160  33.092  57.012  1.00  8.08           N  
ATOM   5532  CA  MET   219      77.037  33.462  57.908  1.00  9.75           C  
ATOM   5533  C   MET   219      75.877  34.075  57.105  1.00  9.33           C  
ATOM   5534  O   MET   219      74.705  33.796  57.393  1.00  8.50           O  
ATOM   5535  CB  MET   219      77.517  34.361  59.036  1.00 10.70           C  
ATOM   5536  CG  MET   219      78.318  33.632  60.104  1.00 10.83           C  
ATOM   5537  SD  MET   219      77.132  32.461  61.178  1.00 19.24          SE  
ATOM   5538  CE  MET   219      76.251  33.854  62.236  1.00 13.10           C  
ATOM   5539  N   ALA   220      76.175  34.864  56.093  1.00  9.79           N  
ATOM   5540  CA  ALA   220      75.142  35.398  55.209  1.00  8.81           C  
ATOM   5541  C   ALA   220      74.358  34.282  54.515  1.00 10.55           C  
ATOM   5542  O   ALA   220      73.131  34.330  54.420  1.00 10.80           O  
ATOM   5543  CB  ALA   220      75.776  36.335  54.162  1.00  9.90           C  
ATOM   5544  N   ASP   221      75.076  33.305  53.986  1.00  9.26           N  
ATOM   5545  CA  ASP   221      74.465  32.207  53.244  1.00 10.44           C  
ATOM   5546  C   ASP   221      73.722  31.244  54.162  1.00  8.96           C  
ATOM   5547  O   ASP   221      72.638  30.797  53.816  1.00  9.98           O  
ATOM   5548  CB  ASP   221      75.522  31.469  52.396  1.00 10.47           C  
ATOM   5549  CG  ASP   221      76.035  32.329  51.208  1.00 12.58           C  
ATOM   5550  OD1 ASP   221      75.426  33.389  50.886  1.00 12.60           O  
ATOM   5551  OD2 ASP   221      77.070  31.951  50.616  1.00 13.20           O  
ATOM   5552  N   ALA   222      74.281  30.981  55.344  1.00 10.14           N  
ATOM   5553  CA  ALA   222      73.588  30.148  56.343  1.00  9.51           C  
ATOM   5554  C   ALA   222      72.310  30.883  56.806  1.00  8.92           C  
ATOM   5555  O   ALA   222      71.228  30.287  56.887  1.00  9.18           O  
ATOM   5556  CB  ALA   222      74.463  29.823  57.531  1.00 10.57           C  
ATOM   5557  N   ALA   223      72.426  32.185  57.037  1.00  8.48           N  
ATOM   5558  CA  ALA   223      71.247  32.982  57.416  1.00  8.96           C  
ATOM   5559  C   ALA   223      70.127  32.893  56.386  1.00  9.41           C  
ATOM   5560  O   ALA   223      68.957  32.691  56.744  1.00  9.64           O  
ATOM   5561  CB  ALA   223      71.641  34.461  57.673  1.00  8.23           C  
ATOM   5562  N   HIS   224      70.468  33.020  55.111  1.00  9.26           N  
ATOM   5563  CA  HIS   224      69.485  32.935  54.044  1.00  9.24           C  
ATOM   5564  C   HIS   224      68.758  31.592  54.086  1.00  8.64           C  
ATOM   5565  O   HIS   224      67.525  31.505  53.908  1.00  9.28           O  
ATOM   5566  CB  HIS   224      70.181  33.124  52.698  1.00 10.68           C  
ATOM   5567  CG  HIS   224      69.238  33.111  51.541  1.00 11.78           C  
ATOM   5568  ND1 HIS   224      68.859  31.952  50.898  1.00 13.37           N  
ATOM   5569  CD2 HIS   224      68.592  34.121  50.920  1.00 13.87           C  
ATOM   5570  CE1 HIS   224      68.030  32.255  49.914  1.00 15.01           C  
ATOM   5571  NE2 HIS   224      67.844  33.563  49.912  1.00 14.14           N  
ATOM   5572  N   ALA   225      69.517  30.529  54.318  1.00  9.29           N  
ATOM   5573  CA  ALA   225      68.954  29.178  54.338  1.00 10.35           C  
ATOM   5574  C   ALA   225      67.978  29.020  55.497  1.00 10.67           C  
ATOM   5575  O   ALA   225      66.974  28.344  55.368  1.00 13.06           O  
ATOM   5576  CB  ALA   225      70.037  28.143  54.416  1.00 10.21           C  
ATOM   5577  N   VAL   226      68.296  29.623  56.629  1.00  9.64           N  
ATOM   5578  CA  VAL   226      67.402  29.632  57.786  1.00  8.31           C  
ATOM   5579  C   VAL   226      66.149  30.466  57.514  1.00  9.05           C  
ATOM   5580  O   VAL   226      65.042  30.008  57.759  1.00  8.06           O  
ATOM   5581  CB  VAL   226      68.089  30.177  59.040  1.00  9.54           C  
ATOM   5582  CG1 VAL   226      67.026  30.386  60.150  1.00  9.38           C  
ATOM   5583  CG2 VAL   226      69.208  29.249  59.496  1.00  8.88           C  
ATOM   5584  N   LEU   227      66.339  31.679  57.008  1.00  8.80           N  
ATOM   5585  CA  LEU   227      65.269  32.685  56.902  1.00  7.62           C  
ATOM   5586  C   LEU   227      64.221  32.400  55.830  1.00  9.30           C  
ATOM   5587  O   LEU   227      63.134  32.981  55.859  1.00 11.38           O  
ATOM   5588  CB  LEU   227      65.853  34.086  56.720  1.00  7.31           C  
ATOM   5589  CG  LEU   227      66.660  34.626  57.912  1.00  7.53           C  
ATOM   5590  CD1 LEU   227      67.456  35.893  57.453  1.00  7.82           C  
ATOM   5591  CD2 LEU   227      65.807  34.868  59.162  1.00  7.82           C  
ATOM   5592  N   THR   228      64.565  31.532  54.877  1.00 10.84           N  
ATOM   5593  CA  THR   228      63.640  31.106  53.834  1.00 11.21           C  
ATOM   5594  C   THR   228      62.902  29.813  54.207  1.00 12.51           C  
ATOM   5595  O   THR   228      62.089  29.324  53.427  1.00 13.36           O  
ATOM   5596  CB  THR   228      64.356  30.943  52.480  1.00 11.28           C  
ATOM   5597  OG1 THR   228      65.490  30.071  52.623  1.00 11.86           O  
ATOM   5598  CG2 THR   228      64.823  32.305  51.925  1.00 10.49           C  
ATOM   5599  N   ARG   229      63.164  29.275  55.392  1.00 12.31           N  
ATOM   5600  CA  ARG   229      62.398  28.131  55.886  1.00 13.02           C  
ATOM   5601  C   ARG   229      61.036  28.582  56.366  1.00 12.41           C  
ATOM   5602  O   ARG   229      60.857  29.699  56.833  1.00 11.12           O  
ATOM   5603  CB  ARG   229      63.131  27.449  57.042  1.00 13.90           C  
ATOM   5604  CG  ARG   229      64.361  26.695  56.573  1.00 18.22           C  
ATOM   5605  CD  ARG   229      64.905  25.781  57.639  1.00 24.70           C  
ATOM   5606  NE  ARG   229      66.358  25.629  57.578  1.00 27.94           N  
ATOM   5607  CZ  ARG   229      67.067  24.929  58.463  1.00 29.51           C  
ATOM   5608  NH1 ARG   229      66.464  24.315  59.473  1.00 30.07           N  
ATOM   5609  NH2 ARG   229      68.382  24.843  58.339  1.00 31.20           N  
ATOM   5610  N   GLU   230      60.073  27.682  56.263  1.00 13.02           N  
ATOM   5611  CA  GLU   230      58.789  27.853  56.934  1.00 13.00           C  
ATOM   5612  C   GLU   230      58.956  28.177  58.441  1.00 10.74           C  
ATOM   5613  O   GLU   230      59.669  27.483  59.145  1.00 10.37           O  
ATOM   5614  CB  GLU   230      57.992  26.558  56.766  1.00 14.44           C  
ATOM   5615  CG  GLU   230      56.714  26.470  57.570  1.00 16.81           C  
ATOM   5616  CD  GLU   230      55.756  27.580  57.297  1.00 20.75           C  
ATOM   5617  OE1 GLU   230      55.565  27.938  56.108  1.00 22.68           O  
ATOM   5618  OE2 GLU   230      55.183  28.101  58.273  1.00 23.60           O  
ATOM   5619  N   ALA   231      58.274  29.224  58.921  1.00 10.66           N  
ATOM   5620  CA  ALA   231      58.452  29.695  60.279  1.00  9.21           C  
ATOM   5621  C   ALA   231      57.666  28.814  61.265  1.00  9.22           C  
ATOM   5622  O   ALA   231      58.149  28.544  62.358  1.00 11.18           O  
ATOM   5623  CB  ALA   231      58.043  31.163  60.394  1.00 11.08           C  
ATOM   5624  N   ALA   232      56.440  28.411  60.900  1.00 11.57           N  
ATOM   5625  CA  ALA   232      55.657  27.536  61.794  1.00 11.84           C  
ATOM   5626  C   ALA   232      56.448  26.274  62.149  1.00 11.65           C  
ATOM   5627  O   ALA   232      57.030  25.635  61.277  1.00 11.13           O  
ATOM   5628  CB  ALA   232      54.287  27.166  61.177  1.00 12.63           C  
ATOM   5629  N   GLY   233      56.460  25.932  63.440  1.00 11.71           N  
ATOM   5630  CA  GLY   233      57.118  24.727  63.931  1.00 12.81           C  
ATOM   5631  C   GLY   233      58.631  24.731  63.914  1.00 12.78           C  
ATOM   5632  O   GLY   233      59.258  23.671  64.000  1.00 15.24           O  
ATOM   5633  N   PHE   234      59.231  25.920  63.845  1.00 11.53           N  
ATOM   5634  CA  PHE   234      60.681  26.065  63.718  1.00 10.95           C  
ATOM   5635  C   PHE   234      61.135  27.154  64.667  1.00 10.41           C  
ATOM   5636  O   PHE   234      61.335  28.309  64.285  1.00 10.14           O  
ATOM   5637  CB  PHE   234      61.024  26.418  62.268  1.00 10.28           C  
ATOM   5638  CG  PHE   234      62.481  26.660  61.998  1.00 11.48           C  
ATOM   5639  CD1 PHE   234      63.469  25.908  62.615  1.00 12.55           C  
ATOM   5640  CD2 PHE   234      62.851  27.629  61.057  1.00 12.01           C  
ATOM   5641  CE1 PHE   234      64.810  26.118  62.316  1.00 12.77           C  
ATOM   5642  CE2 PHE   234      64.198  27.847  60.754  1.00  9.77           C  
ATOM   5643  CZ  PHE   234      65.173  27.094  61.377  1.00 10.45           C  
ATOM   5644  N   HIS   235      61.220  26.803  65.939  1.00 11.11           N  
ATOM   5645  CA  HIS   235      61.674  27.764  66.942  1.00 10.75           C  
ATOM   5646  C   HIS   235      62.484  27.096  68.044  1.00 10.73           C  
ATOM   5647  O   HIS   235      62.409  25.871  68.220  1.00 11.07           O  
ATOM   5648  CB  HIS   235      60.488  28.535  67.516  1.00 11.00           C  
ATOM   5649  CG  HIS   235      59.431  27.661  68.116  1.00 12.49           C  
ATOM   5650  ND1 HIS   235      59.451  27.250  69.430  1.00 17.28           N  
ATOM   5651  CD2 HIS   235      58.298  27.159  67.583  1.00 15.51           C  
ATOM   5652  CE1 HIS   235      58.384  26.505  69.672  1.00 16.54           C  
ATOM   5653  NE2 HIS   235      57.661  26.444  68.572  1.00 19.60           N  
ATOM   5654  N   GLY   236      63.272  27.900  68.757  1.00  9.65           N  
ATOM   5655  CA  GLY   236      64.075  27.417  69.881  1.00 10.22           C  
ATOM   5656  C   GLY   236      65.311  26.612  69.493  1.00 11.11           C  
ATOM   5657  O   GLY   236      65.883  25.899  70.346  1.00 11.67           O  
ATOM   5658  N   GLN   237      65.737  26.719  68.229  1.00  9.79           N  
ATOM   5659  CA  GLN   237      66.917  26.007  67.719  0.50  9.71           C  
ATOM   5661  C   GLN   237      68.155  26.891  67.753  1.00  9.69           C  
ATOM   5662  O   GLN   237      68.076  28.093  67.421  1.00  9.08           O  
ATOM   5663  CB  GLN   237      66.702  25.568  66.277  0.50  9.51           C  
ATOM   5665  CG  GLN   237      65.375  24.867  66.030  0.50  9.75           C  
ATOM   5667  CD  GLN   237      65.237  23.639  66.887  0.50 12.51           C  
ATOM   5669  OE1 GLN   237      66.075  22.741  66.822  0.50 15.44           O  
ATOM   5671  NE2 GLN   237      64.207  23.607  67.731  0.50 13.76           N  
ATOM   5673  N   PHE   238      69.292  26.295  68.111  1.00 10.54           N  
ATOM   5674  CA  PHE   238      70.565  26.961  68.165  1.00 10.09           C  
ATOM   5675  C   PHE   238      71.422  26.330  67.095  1.00 10.10           C  
ATOM   5676  O   PHE   238      71.923  25.208  67.260  1.00 10.79           O  
ATOM   5677  CB  PHE   238      71.148  26.854  69.559  1.00 11.86           C  
ATOM   5678  CG  PHE   238      70.364  27.638  70.513  1.00 11.06           C  
ATOM   5679  CD1 PHE   238      70.683  28.963  70.740  1.00  9.74           C  
ATOM   5680  CD2 PHE   238      69.199  27.095  71.091  1.00 13.11           C  
ATOM   5681  CE1 PHE   238      69.877  29.754  71.591  1.00 12.73           C  
ATOM   5682  CE2 PHE   238      68.397  27.871  71.954  1.00 11.73           C  
ATOM   5683  CZ  PHE   238      68.729  29.199  72.181  1.00 12.13           C  
ATOM   5684  N   LEU   239      71.435  27.004  65.947  1.00  8.63           N  
ATOM   5685  CA  LEU   239      71.954  26.431  64.705  1.00  9.84           C  
ATOM   5686  C   LEU   239      73.415  26.809  64.453  1.00 10.60           C  
ATOM   5687  O   LEU   239      73.900  27.852  64.902  1.00  9.43           O  
ATOM   5688  CB  LEU   239      71.071  26.890  63.542  1.00 11.24           C  
ATOM   5689  CG  LEU   239      69.571  26.548  63.665  1.00 14.18           C  
ATOM   5690  CD1 LEU   239      68.745  27.380  62.716  1.00 15.68           C  
ATOM   5691  CD2 LEU   239      69.305  25.051  63.508  1.00 13.50           C  
ATOM   5692  N   ILE   240      74.114  25.957  63.699  1.00 10.01           N  
ATOM   5693  CA  ILE   240      75.506  26.202  63.350  1.00 10.29           C  
ATOM   5694  C   ILE   240      75.630  26.359  61.837  1.00 10.02           C  
ATOM   5695  O   ILE   240      74.977  25.618  61.079  1.00  9.20           O  
ATOM   5696  CB  ILE   240      76.425  25.078  63.844  1.00 12.25           C  
ATOM   5697  CG1 ILE   240      76.182  24.784  65.334  1.00 12.19           C  
ATOM   5698  CG2 ILE   240      77.889  25.507  63.641  1.00  9.74           C  
ATOM   5699  CD1 ILE   240      76.500  25.914  66.214  1.00 11.70           C  
ATOM   5700  N   ASP   241      76.455  27.320  61.392  1.00  8.55           N  
ATOM   5701  CA  ASP   241      76.500  27.630  59.948  1.00  7.63           C  
ATOM   5702  C   ASP   241      76.734  26.403  59.046  1.00  8.93           C  
ATOM   5703  O   ASP   241      75.986  26.182  58.087  1.00  7.81           O  
ATOM   5704  CB  ASP   241      77.462  28.776  59.622  1.00  8.63           C  
ATOM   5705  CG  ASP   241      78.910  28.556  60.089  1.00  8.77           C  
ATOM   5706  OD1 ASP   241      79.263  27.528  60.731  1.00  9.52           O  
ATOM   5707  OD2 ASP   241      79.702  29.490  59.786  1.00 10.21           O  
ATOM   5708  N   ASP   242      77.776  25.640  59.346  1.00  9.44           N  
ATOM   5709  CA  ASP   242      78.153  24.498  58.505  1.00  9.97           C  
ATOM   5710  C   ASP   242      77.045  23.463  58.410  1.00 11.43           C  
ATOM   5711  O   ASP   242      76.792  22.932  57.322  1.00 11.52           O  
ATOM   5712  CB  ASP   242      79.518  23.916  58.898  1.00 10.96           C  
ATOM   5713  CG  ASP   242      79.626  23.456  60.354  1.00 10.47           C  
ATOM   5714  OD1 ASP   242      78.637  23.411  61.152  1.00  9.82           O  
ATOM   5715  OD2 ASP   242      80.750  23.045  60.696  1.00 11.04           O  
ATOM   5716  N   GLU   243      76.340  23.240  59.528  1.00 10.97           N  
ATOM   5717  CA  GLU   243      75.254  22.271  59.563  1.00 12.10           C  
ATOM   5718  C   GLU   243      74.051  22.754  58.781  1.00 11.93           C  
ATOM   5719  O   GLU   243      73.450  21.991  58.013  1.00 12.25           O  
ATOM   5720  CB  GLU   243      74.891  21.953  61.015  1.00 10.90           C  
ATOM   5721  CG  GLU   243      75.989  21.186  61.752  1.00 11.73           C  
ATOM   5722  CD  GLU   243      75.652  20.881  63.201  1.00 14.83           C  
ATOM   5723  OE1 GLU   243      74.647  21.414  63.728  1.00 15.06           O  
ATOM   5724  OE2 GLU   243      76.424  20.123  63.820  1.00 15.27           O  
ATOM   5725  N   VAL   244      73.726  24.043  58.928  1.00 10.46           N  
ATOM   5726  CA  VAL   244      72.639  24.624  58.156  1.00 10.91           C  
ATOM   5727  C   VAL   244      72.944  24.498  56.657  1.00  9.60           C  
ATOM   5728  O   VAL   244      72.100  24.116  55.849  1.00  9.49           O  
ATOM   5729  CB  VAL   244      72.430  26.109  58.522  1.00 10.40           C  
ATOM   5730  CG1 VAL   244      71.527  26.825  57.494  1.00 10.80           C  
ATOM   5731  CG2 VAL   244      71.827  26.241  59.936  1.00 10.74           C  
ATOM   5732  N   LEU   245      74.171  24.845  56.271  1.00  8.34           N  
ATOM   5733  CA  LEU   245      74.524  24.803  54.873  1.00  9.08           C  
ATOM   5734  C   LEU   245      74.510  23.367  54.329  1.00  9.72           C  
ATOM   5735  O   LEU   245      74.061  23.135  53.212  1.00 12.07           O  
ATOM   5736  CB  LEU   245      75.864  25.495  54.646  1.00 10.01           C  
ATOM   5737  CG  LEU   245      75.757  27.025  54.754  1.00  9.78           C  
ATOM   5738  CD1 LEU   245      77.125  27.622  54.847  1.00 11.42           C  
ATOM   5739  CD2 LEU   245      74.933  27.662  53.573  1.00 10.98           C  
ATOM   5740  N   ALA   246      74.926  22.406  55.142  1.00  9.49           N  
ATOM   5741  CA  ALA   246      74.899  20.989  54.735  1.00 10.39           C  
ATOM   5742  C   ALA   246      73.460  20.527  54.472  1.00 13.02           C  
ATOM   5743  O   ALA   246      73.166  19.889  53.464  1.00 13.50           O  
ATOM   5744  CB  ALA   246      75.552  20.141  55.785  1.00 11.18           C  
ATOM   5745  N   GLN   247      72.545  20.906  55.350  1.00 14.76           N  
ATOM   5746  CA  GLN   247      71.142  20.553  55.146  1.00 15.96           C  
ATOM   5747  C   GLN   247      70.605  21.162  53.844  1.00 16.26           C  
ATOM   5748  O   GLN   247      69.775  20.553  53.163  1.00 17.07           O  
ATOM   5749  CB  GLN   247      70.284  20.972  56.345  1.00 16.47           C  
ATOM   5750  CG  GLN   247      68.830  20.506  56.232  1.00 19.53           C  
ATOM   5751  CD  GLN   247      68.716  18.981  56.287  1.00 23.04           C  
ATOM   5752  OE1 GLN   247      69.252  18.354  57.198  1.00 30.20           O  
ATOM   5753  NE2 GLN   247      68.015  18.387  55.318  1.00 26.17           N  
ATOM   5754  N   ALA   248      71.096  22.354  53.499  1.00 15.68           N  
ATOM   5755  CA  ALA   248      70.715  23.057  52.270  1.00 17.03           C  
ATOM   5756  C   ALA   248      71.405  22.541  50.999  1.00 17.73           C  
ATOM   5757  O   ALA   248      71.152  23.057  49.898  1.00 18.79           O  
ATOM   5758  CB  ALA   248      70.970  24.566  52.440  1.00 16.79           C  
ATOM   5759  N   GLY   249      72.257  21.525  51.136  1.00 17.88           N  
ATOM   5760  CA  GLY   249      72.937  20.916  50.006  1.00 17.09           C  
ATOM   5761  C   GLY   249      74.269  21.562  49.677  1.00 18.14           C  
ATOM   5762  O   GLY   249      74.836  21.281  48.639  1.00 18.86           O  
ATOM   5763  N   ILE   250      74.764  22.432  50.558  1.00 16.72           N  
ATOM   5764  CA  ILE   250      76.060  23.086  50.394  1.00 16.93           C  
ATOM   5765  C   ILE   250      77.010  22.469  51.401  1.00 17.11           C  
ATOM   5766  O   ILE   250      76.966  22.786  52.594  1.00 17.06           O  
ATOM   5767  CB  ILE   250      75.991  24.625  50.598  1.00 16.82           C  
ATOM   5768  CG1 ILE   250      75.017  25.237  49.576  1.00 18.36           C  
ATOM   5769  CG2 ILE   250      77.421  25.238  50.561  1.00 17.05           C  
ATOM   5770  CD1 ILE   250      74.554  26.663  49.877  1.00 20.00           C  
ATOM   5771  N   THR   251      77.844  21.565  50.907  1.00 16.28           N  
ATOM   5772  CA  THR   251      78.766  20.798  51.733  1.00 17.39           C  
ATOM   5773  C   THR   251      80.225  21.172  51.470  1.00 16.35           C  
ATOM   5774  O   THR   251      81.100  20.924  52.311  1.00 17.59           O  
ATOM   5775  CB  THR   251      78.548  19.258  51.518  1.00 18.88           C  
ATOM   5776  OG1 THR   251      78.633  18.951  50.125  1.00 19.35           O  
ATOM   5777  CG2 THR   251      77.179  18.803  52.048  1.00 18.81           C  
ATOM   5778  N   ASP   252      80.506  21.772  50.318  1.00 16.57           N  
ATOM   5779  CA  ASP   252      81.860  22.264  50.053  1.00 16.71           C  
ATOM   5780  C   ASP   252      81.990  23.719  50.530  1.00 15.16           C  
ATOM   5781  O   ASP   252      81.513  24.643  49.869  1.00 14.76           O  
ATOM   5782  CB  ASP   252      82.210  22.136  48.559  1.00 18.34           C  
ATOM   5783  CG  ASP   252      83.534  22.803  48.198  1.00 21.36           C  
ATOM   5784  OD1 ASP   252      84.360  23.072  49.092  1.00 20.58           O  
ATOM   5785  OD2 ASP   252      83.762  23.062  46.991  1.00 26.03           O  
ATOM   5786  N   LEU   253      82.677  23.907  51.654  1.00 14.09           N  
ATOM   5787  CA  LEU   253      82.822  25.212  52.292  1.00 13.04           C  
ATOM   5788  C   LEU   253      84.167  25.868  52.017  1.00 13.64           C  
ATOM   5789  O   LEU   253      84.484  26.925  52.582  1.00 13.52           O  
ATOM   5790  CB  LEU   253      82.650  25.059  53.802  1.00 12.46           C  
ATOM   5791  CG  LEU   253      81.350  24.462  54.293  1.00 14.11           C  
ATOM   5792  CD1 LEU   253      81.337  24.370  55.815  1.00 12.78           C  
ATOM   5793  CD2 LEU   253      80.193  25.302  53.751  1.00 14.19           C  
ATOM   5794  N   SER   254      84.964  25.252  51.146  1.00 15.63           N  
ATOM   5795  CA  SER   254      86.332  25.727  50.935  1.00 15.42           C  
ATOM   5796  C   SER   254      86.416  27.206  50.485  1.00 14.66           C  
ATOM   5797  O   SER   254      87.362  27.936  50.845  1.00 14.75           O  
ATOM   5798  CB  SER   254      87.046  24.810  49.915  1.00 17.15           C  
ATOM   5799  OG  SER   254      86.372  24.804  48.662  1.00 21.05           O  
ATOM   5800  N   GLY   255      85.450  27.636  49.674  1.00 13.97           N  
ATOM   5801  CA  GLY   255      85.415  29.023  49.171  1.00 15.07           C  
ATOM   5802  C   GLY   255      85.129  30.080  50.222  1.00 13.40           C  
ATOM   5803  O   GLY   255      85.300  31.281  49.964  1.00 15.35           O  
ATOM   5804  N   TYR   256      84.668  29.654  51.397  1.00 12.89           N  
ATOM   5805  CA  TYR   256      84.408  30.594  52.502  1.00 12.87           C  
ATOM   5806  C   TYR   256      85.652  30.922  53.329  1.00 13.02           C  
ATOM   5807  O   TYR   256      85.633  31.807  54.191  1.00 12.60           O  
ATOM   5808  CB  TYR   256      83.310  30.070  53.409  1.00 12.71           C  
ATOM   5809  CG  TYR   256      81.957  29.985  52.758  1.00 12.38           C  
ATOM   5810  CD1 TYR   256      81.262  31.146  52.368  1.00 12.60           C  
ATOM   5811  CD2 TYR   256      81.344  28.764  52.573  1.00 13.56           C  
ATOM   5812  CE1 TYR   256      79.982  31.066  51.790  1.00 13.07           C  
ATOM   5813  CE2 TYR   256      80.072  28.672  51.992  1.00 12.59           C  
ATOM   5814  CZ  TYR   256      79.398  29.822  51.595  1.00 12.08           C  
ATOM   5815  OH  TYR   256      78.136  29.650  51.055  1.00 13.51           O  
ATOM   5816  N   ALA   257      86.750  30.202  53.093  1.00 12.21           N  
ATOM   5817  CA  ALA   257      88.000  30.505  53.803  1.00 12.76           C  
ATOM   5818  C   ALA   257      88.579  31.834  53.341  1.00 13.14           C  
ATOM   5819  O   ALA   257      88.634  32.103  52.137  1.00 12.74           O  
ATOM   5820  CB  ALA   257      89.035  29.381  53.574  1.00 11.08           C  
ATOM   5821  N   VAL   258      89.025  32.653  54.291  1.00 13.59           N  
ATOM   5822  CA  VAL   258      89.766  33.875  53.957  1.00 13.15           C  
ATOM   5823  C   VAL   258      91.047  33.481  53.196  1.00 13.92           C  
ATOM   5824  O   VAL   258      91.350  34.062  52.167  1.00 15.15           O  
ATOM   5825  CB  VAL   258      90.139  34.695  55.196  1.00 13.73           C  
ATOM   5826  CG1 VAL   258      91.133  35.827  54.828  1.00 12.44           C  
ATOM   5827  CG2 VAL   258      88.887  35.275  55.836  1.00 11.73           C  
ATOM   5828  N   ASP   259      91.737  32.468  53.695  1.00 14.36           N  
ATOM   5829  CA  ASP   259      93.043  32.032  53.152  1.00 16.66           C  
ATOM   5830  C   ASP   259      93.207  30.531  53.378  1.00 16.00           C  
ATOM   5831  O   ASP   259      93.492  30.111  54.495  1.00 15.74           O  
ATOM   5832  CB  ASP   259      94.178  32.770  53.843  1.00 17.28           C  
ATOM   5833  CG  ASP   259      95.534  32.527  53.175  1.00 19.52           C  
ATOM   5834  OD1 ASP   259      95.638  31.603  52.334  1.00 19.14           O  
ATOM   5835  OD2 ASP   259      96.471  33.285  53.500  1.00 20.78           O  
ATOM   5836  N   PRO   260      93.040  29.731  52.314  1.00 16.57           N  
ATOM   5837  CA  PRO   260      93.114  28.263  52.358  1.00 17.14           C  
ATOM   5838  C   PRO   260      94.471  27.723  52.853  1.00 17.17           C  
ATOM   5839  O   PRO   260      94.556  26.568  53.229  1.00 17.32           O  
ATOM   5840  CB  PRO   260      92.895  27.856  50.906  1.00 17.55           C  
ATOM   5841  CG  PRO   260      92.197  29.012  50.297  1.00 19.80           C  
ATOM   5842  CD  PRO   260      92.761  30.208  50.948  1.00 17.57           C  
ATOM   5843  N   GLN   261      95.513  28.555  52.877  1.00 17.47           N  
ATOM   5844  CA  GLN   261      96.809  28.066  53.346  1.00 19.31           C  
ATOM   5845  C   GLN   261      96.883  27.935  54.861  1.00 18.28           C  
ATOM   5846  O   GLN   261      97.785  27.279  55.369  1.00 17.94           O  
ATOM   5847  CB  GLN   261      98.003  28.848  52.735  1.00 20.37           C  
ATOM   5848  CG  GLN   261      98.334  30.204  53.267  1.00 22.82           C  
ATOM   5849  CD  GLN   261      99.129  31.047  52.224  1.00 23.06           C  
ATOM   5850  OE1 GLN   261     100.267  30.741  51.890  1.00 24.28           O  
ATOM   5851  NE2 GLN   261      98.505  32.082  51.712  1.00 26.95           N  
ATOM   5852  N   ARG   262      95.897  28.499  55.570  1.00 17.95           N  
ATOM   5853  CA  ARG   262      95.835  28.452  57.026  1.00 18.53           C  
ATOM   5854  C   ARG   262      94.770  27.486  57.540  1.00 16.88           C  
ATOM   5855  O   ARG   262      93.689  27.377  56.957  1.00 15.84           O  
ATOM   5856  CB  ARG   262      95.538  29.856  57.567  1.00 19.88           C  
ATOM   5857  CG  ARG   262      96.516  30.933  57.099  1.00 24.55           C  
ATOM   5858  CD  ARG   262      97.860  30.788  57.788  1.00 29.13           C  
ATOM   5859  NE  ARG   262      97.735  31.167  59.198  1.00 33.15           N  
ATOM   5860  CZ  ARG   262      97.938  32.393  59.688  1.00 34.34           C  
ATOM   5861  NH1 ARG   262      98.293  33.410  58.897  1.00 36.27           N  
ATOM   5862  NH2 ARG   262      97.770  32.606  60.988  1.00 33.46           N  
ATOM   5863  N   ALA   263      95.068  26.798  58.640  1.00 17.37           N  
ATOM   5864  CA  ALA   263      94.067  26.008  59.366  1.00 17.08           C  
ATOM   5865  C   ALA   263      93.041  26.985  59.978  1.00 16.55           C  
ATOM   5866  O   ALA   263      93.421  28.032  60.471  1.00 17.26           O  
ATOM   5867  CB  ALA   263      94.745  25.188  60.460  1.00 18.51           C  
ATOM   5868  N   LEU   264      91.753  26.664  59.895  1.00 16.39           N  
ATOM   5869  CA  LEU   264      90.712  27.525  60.490  1.00 16.60           C  
ATOM   5870  C   LEU   264      90.679  27.453  62.024  1.00 16.45           C  
ATOM   5871  O   LEU   264      90.837  26.372  62.621  1.00 18.13           O  
ATOM   5872  CB  LEU   264      89.346  27.156  59.948  1.00 16.42           C  
ATOM   5873  CG  LEU   264      89.143  27.414  58.467  1.00 15.21           C  
ATOM   5874  CD1 LEU   264      87.920  26.660  57.985  1.00 13.98           C  
ATOM   5875  CD2 LEU   264      89.042  28.909  58.183  1.00 13.81           C  
ATOM   5876  N   LEU   265      90.505  28.618  62.652  1.00 16.21           N  
ATOM   5877  CA  LEU   265      90.405  28.714  64.100  1.00 16.33           C  
ATOM   5878  C   LEU   265      88.967  28.386  64.532  1.00 15.83           C  
ATOM   5879  O   LEU   265      88.023  29.000  64.038  1.00 16.09           O  
ATOM   5880  CB  LEU   265      90.750  30.120  64.588  1.00 17.75           C  
ATOM   5881  CG  LEU   265      92.181  30.627  64.317  1.00 20.10           C  
ATOM   5882  CD1 LEU   265      92.346  32.048  64.846  1.00 21.56           C  
ATOM   5883  CD2 LEU   265      93.196  29.698  64.919  1.00 20.73           C  
ATOM   5884  N   PRO   266      88.798  27.457  65.480  1.00 15.63           N  
ATOM   5885  CA  PRO   266      87.450  27.153  65.999  1.00 16.18           C  
ATOM   5886  C   PRO   266      86.857  28.356  66.741  1.00 14.14           C  
ATOM   5887  O   PRO   266      87.580  29.095  67.395  1.00 13.74           O  
ATOM   5888  CB  PRO   266      87.674  25.992  66.976  1.00 16.24           C  
ATOM   5889  CG  PRO   266      89.145  25.788  67.059  1.00 19.00           C  
ATOM   5890  CD  PRO   266      89.857  26.631  66.102  1.00 16.71           C  
ATOM   5891  N   ASP   267      85.546  28.556  66.607  1.00 13.96           N  
ATOM   5892  CA  ASP   267      84.855  29.689  67.218  1.00 14.10           C  
ATOM   5893  C   ASP   267      84.760  29.523  68.743  1.00 13.49           C  
ATOM   5894  O   ASP   267      84.859  28.418  69.281  1.00 12.65           O  
ATOM   5895  CB  ASP   267      83.449  29.792  66.625  1.00 12.54           C  
ATOM   5896  CG  ASP   267      82.819  31.171  66.739  1.00 15.42           C  
ATOM   5897  OD1 ASP   267      83.441  32.138  67.217  1.00 13.95           O  
ATOM   5898  OD2 ASP   267      81.637  31.269  66.309  1.00 14.52           O  
ATOM   5899  N   LEU   268      84.617  30.659  69.422  1.00 13.52           N  
ATOM   5900  CA  LEU   268      84.284  30.699  70.824  1.00 14.96           C  
ATOM   5901  C   LEU   268      82.946  29.991  71.042  1.00 14.82           C  
ATOM   5902  O   LEU   268      82.104  29.993  70.145  1.00 13.69           O  
ATOM   5903  CB  LEU   268      84.141  32.161  71.304  1.00 15.82           C  
ATOM   5904  CG  LEU   268      85.422  32.938  71.595  1.00 18.28           C  
ATOM   5905  CD1 LEU   268      86.182  33.204  70.301  1.00 19.74           C  
ATOM   5906  CD2 LEU   268      85.092  34.258  72.314  1.00 18.49           C  
ATOM   5907  N   PHE   269      82.776  29.416  72.224  1.00 13.88           N  
ATOM   5908  CA  PHE   269      81.479  28.918  72.704  1.00 14.11           C  
ATOM   5909  C   PHE   269      80.922  27.726  71.915  1.00 14.49           C  
ATOM   5910  O   PHE   269      79.710  27.559  71.807  1.00 14.78           O  
ATOM   5911  CB  PHE   269      80.436  30.047  72.742  1.00 13.13           C  
ATOM   5912  CG  PHE   269      80.814  31.243  73.592  1.00 12.50           C  
ATOM   5913  CD1 PHE   269      81.254  31.089  74.894  1.00 12.83           C  
ATOM   5914  CD2 PHE   269      80.654  32.522  73.105  1.00 12.47           C  
ATOM   5915  CE1 PHE   269      81.565  32.193  75.692  1.00 13.46           C  
ATOM   5916  CE2 PHE   269      80.964  33.642  73.895  1.00 12.05           C  
ATOM   5917  CZ  PHE   269      81.431  33.453  75.208  1.00 12.47           C  
ATOM   5918  N   LEU   270      81.812  26.920  71.338  1.00 14.37           N  
ATOM   5919  CA  LEU   270      81.447  25.635  70.789  1.00 16.10           C  
ATOM   5920  C   LEU   270      82.469  24.613  71.275  1.00 17.22           C  
ATOM   5921  O   LEU   270      83.675  24.880  71.244  1.00 16.86           O  
ATOM   5922  CB  LEU   270      81.459  25.668  69.258  1.00 16.26           C  
ATOM   5923  CG  LEU   270      80.278  26.364  68.588  1.00 15.58           C  
ATOM   5924  CD1 LEU   270      80.496  26.370  67.046  1.00 14.45           C  
ATOM   5925  CD2 LEU   270      78.909  25.742  68.959  1.00 15.54           C  
ATOM   5926  N   GLU   271      81.963  23.476  71.740  1.00 19.45           N  
ATOM   5927  CA  GLU   271      82.788  22.330  72.080  1.00 22.57           C  
ATOM   5928  C   GLU   271      83.343  21.779  70.762  1.00 25.04           C  
ATOM   5929  O   GLU   271      82.642  21.754  69.735  1.00 23.26           O  
ATOM   5930  CB  GLU   271      81.968  21.231  72.775  1.00 23.30           C  
ATOM   5931  CG  GLU   271      81.121  21.665  73.996  1.00 25.01           C  
ATOM   5932  CD  GLU   271      81.931  22.042  75.228  1.00 26.56           C  
ATOM   5933  OE1 GLU   271      83.171  21.827  75.219  1.00 26.60           O  
ATOM   5934  OE2 GLU   271      81.312  22.561  76.204  1.00 25.67           O  
END
