
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  260 ( 1879),  selected  260 , name 1wmb_A
# Molecule2: number of CA atoms  271 ( 1954),  selected  271 , name T0511.pdb
# PARAMETERS: 1wmb_A.T0511.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    M     1_A      T       2          0.341
LGA    L     2_A      L       3          1.354
LGA    K     3_A      S       4          1.341
LGA    G     4_A      G       5          1.833
LGA    K     5_A      K       6          0.950
LGA    V     6_A      T       7          0.277
LGA    A     7_A      L       8          0.413
LGA    V     8_A      F       9          0.878
LGA    V     9_A      I      10          0.584
LGA    T    10_A      T      11          0.469
LGA    G    11_A      G      12          0.362
LGA    S    12_A      A      13          0.410
LGA    T    13_A      S      14          0.530
LGA    S    14_A      R      15          0.571
LGA    G    15_A      G      16          0.606
LGA    I    16_A      I      17          0.708
LGA    G    17_A      G      18          0.734
LGA    L    18_A      L      19          0.543
LGA    G    19_A      A      20          0.703
LGA    I    20_A      I      21          0.812
LGA    A    21_A      A      22          0.755
LGA    T    22_A      L      23          0.990
LGA    A    23_A      R      24          1.190
LGA    L    24_A      A      25          1.371
LGA    A    25_A      A      26          1.366
LGA    A    26_A      R      27          1.732
LGA    Q    27_A      D      28          2.263
LGA    G    28_A      G      29          2.154
LGA    A    29_A      A      30          1.202
LGA    D    30_A      N      31          0.632
LGA    I    31_A      V      32          0.591
LGA    V    32_A      A      33          0.771
LGA    L    33_A      I      34          1.043
LGA    N    34_A      A      35          2.293
LGA    G    35_A      A      36          1.738
LGA    F    36_A      K      37          2.874
LGA    G    37_A      S      38          2.935
LGA    -       -      A      39           -
LGA    -       -      V      40           -
LGA    D    38_A      A      41          1.956
LGA    A    39_A      N      42           -
LGA    A    40_A      P      43           -
LGA    -       -      K      44           -
LGA    -       -      L      45           -
LGA    -       -      P      46           -
LGA    E    41_A      G      47          5.130
LGA    I    42_A      T      48          2.869
LGA    -       -      I      49           -
LGA    E    43_A      H      50          2.573
LGA    K    44_A      S      51          3.319
LGA    V    45_A      A      52          3.333
LGA    R    46_A      A      53          1.872
LGA    A    47_A      A      54          1.588
LGA    G    48_A      A      55          2.891
LGA    L    49_A      V      56          2.126
LGA    A    50_A      N      57          0.499
LGA    A    51_A      A      58          2.496
LGA    Q    52_A      A      59          2.289
LGA    H    53_A      G      60          1.086
LGA    G    54_A      -       -           -
LGA    V    55_A      G      61          2.096
LGA    K    56_A      Q      62          1.315
LGA    V    57_A      G      63          0.598
LGA    L    58_A      L      64          0.868
LGA    Y    59_A      A      65          0.730
LGA    D    60_A      L      66          0.509
LGA    G    61_A      K      67          1.351
LGA    A    62_A      C      68          0.917
LGA    D    63_A      D      69          1.118
LGA    L    64_A      I      70          1.225
LGA    S    65_A      R      71          1.280
LGA    K    66_A      E      72          1.049
LGA    G    67_A      E      73          1.925
LGA    E    68_A      D      74          2.133
LGA    A    69_A      Q      75          1.634
LGA    V    70_A      V      76          1.799
LGA    R    71_A      R      77          2.423
LGA    G    72_A      A      78          2.176
LGA    L    73_A      A      79          1.765
LGA    V    74_A      V      80          1.621
LGA    D    75_A      A      81          2.018
LGA    N    76_A      A      82          1.657
LGA    A    77_A      T      83          1.069
LGA    V    78_A      V      84          1.044
LGA    R    79_A      D      85          1.400
LGA    Q    80_A      T      86          1.481
LGA    M    81_A      F      87          1.621
LGA    G    82_A      G      88          1.039
LGA    R    83_A      G      89          0.480
LGA    I    84_A      I      90          0.262
LGA    D    85_A      D      91          0.209
LGA    I    86_A      I      92          0.455
LGA    L    87_A      L      93          0.376
LGA    V    88_A      V      94          0.301
LGA    N    89_A      N      95          0.835
LGA    N    90_A      N      96          0.389
LGA    A    91_A      A      97          2.060
LGA    G    92_A      S      98          2.118
LGA    I    93_A      A      99          0.792
LGA    Q    94_A      I     100          1.474
LGA    H    95_A      W     101          1.871
LGA    T    96_A      L     102          2.890
LGA    A    97_A      R     103          2.289
LGA    L    98_A      G     104          1.554
LGA    I    99_A      T     105          0.697
LGA    E   100_A      L     106          1.658
LGA    D   101_A      D     107          2.165
LGA    F   102_A      T     108          1.316
LGA    P   103_A      P     109          0.652
LGA    T   104_A      M     110          1.185
LGA    E   105_A      K     111          1.472
LGA    K   106_A      R     112          1.095
LGA    W   107_A      F     113          0.808
LGA    D   108_A      D     114          1.305
LGA    A   109_A      L     115          1.431
LGA    I   110_A      M     116          0.662
LGA    L   111_A      Q     117          0.205
LGA    A   112_A      Q     118          0.674
LGA    L   113_A      V     119          0.736
LGA    N   114_A      N     120          0.639
LGA    L   115_A      A     121          0.894
LGA    S   116_A      R     122          0.533
LGA    A   117_A      G     123          0.788
LGA    V   118_A      S     124          0.665
LGA    F   119_A      F     125          0.756
LGA    H   120_A      V     126          0.730
LGA    G   121_A      C     127          0.447
LGA    T   122_A      A     128          0.316
LGA    A   123_A      Q     129          0.494
LGA    A   124_A      A     130          0.881
LGA    A   125_A      C     131          0.843
LGA    L   126_A      L     132          0.789
LGA    P   127_A      P     133          0.907
LGA    H   128_A      H     134          1.123
LGA    M   129_A      L     135          1.457
LGA    K   130_A      L     136          1.350
LGA    K   131_A      Q     137          2.479
LGA    Q   132_A      A     138          2.869
LGA    G   133_A      P     139          4.532
LGA    F   134_A      N     140          3.237
LGA    G   135_A      P     141          1.019
LGA    R   136_A      H     142          0.351
LGA    I   137_A      I     143          0.297
LGA    I   138_A      L     144          0.482
LGA    N   139_A      T     145          0.538
LGA    I   140_A      L     146          0.967
LGA    A   141_A      A     147          1.372
LGA    S   142_A      P     148          3.843
LGA    A   143_A      -       -           -
LGA    H   144_A      -       -           -
LGA    G   145_A      P     149           #
LGA    L   146_A      P     150          3.780
LGA    -       -      S     151           -
LGA    -       -      L     152           -
LGA    -       -      N     153           -
LGA    -       -      P     154           -
LGA    -       -      A     155           -
LGA    V   147_A      W     156          4.843
LGA    A   148_A      W     157          4.782
LGA    S   149_A      G     158           #
LGA    A   150_A      A     159          1.674
LGA    N   151_A      H     160          3.159
LGA    K   152_A      -       -           -
LGA    S   153_A      T     161          2.053
LGA    A   154_A      G     162          1.828
LGA    Y   155_A      Y     163          1.805
LGA    V   156_A      T     164          0.954
LGA    A   157_A      L     165          0.670
LGA    A   158_A      A     166          1.401
LGA    K   159_A      K     167          1.540
LGA    H   160_A      M     168          1.270
LGA    G   161_A      G     169          1.577
LGA    V   162_A      M     170          1.368
LGA    V   163_A      S     171          1.166
LGA    G   164_A      L     172          1.442
LGA    F   165_A      V     173          1.115
LGA    T   166_A      T     174          0.721
LGA    K   167_A      L     175          1.640
LGA    V   168_A      G     176          1.620
LGA    T   169_A      L     177          1.255
LGA    A   170_A      A     178          1.400
LGA    L   171_A      A     179          1.945
LGA    E   172_A      E     180          1.766
LGA    T   173_A      F     181          1.849
LGA    A   174_A      G     182          2.603
LGA    G   175_A      P     183          3.819
LGA    Q   176_A      Q     184          2.695
LGA    G   177_A      G     185          2.906
LGA    I   178_A      V     186          1.254
LGA    T   179_A      A     187          0.799
LGA    A   180_A      I     188          0.529
LGA    N   181_A      N     189          0.621
LGA    A   182_A      A     190          0.960
LGA    I   183_A      L     191          1.074
LGA    C   184_A      W     192          1.927
LGA    P   185_A      P     193          2.812
LGA    -       -      R     194           -
LGA    G   186_A      T     195          3.961
LGA    W   187_A      V     196          0.955
LGA    V   188_A      I     197          0.952
LGA    R   189_A      A     198          1.174
LGA    T   190_A      T     199          1.539
LGA    P   191_A      D     200          3.676
LGA    L   192_A      A     201          5.037
LGA    V   193_A      I     202          2.729
LGA    E   194_A      -       -           -
LGA    K   195_A      -       -           -
LGA    Q   196_A      N     203           #
LGA    -       -      M     204           -
LGA    -       -      L     205           -
LGA    -       -      P     206           -
LGA    -       -      G     207           -
LGA    -       -      V     208           -
LGA    I   197_A      D     209          2.594
LGA    S   198_A      A     210           -
LGA    A   199_A      -       -           -
LGA    L   200_A      -       -           -
LGA    A   201_A      -       -           -
LGA    E   202_A      -       -           -
LGA    K   203_A      -       -           -
LGA    N   204_A      -       -           -
LGA    G   205_A      -       -           -
LGA    V   206_A      -       -           -
LGA    D   207_A      -       -           -
LGA    Q   208_A      -       -           -
LGA    E   209_A      -       -           -
LGA    T   210_A      -       -           -
LGA    A   211_A      -       -           -
LGA    A   212_A      A     211          4.630
LGA    R   213_A      A     212          4.564
LGA    E   214_A      -       -           -
LGA    L   215_A      -       -           -
LGA    L   216_A      -       -           -
LGA    S   217_A      -       -           -
LGA    E   218_A      -       -           -
LGA    K   219_A      -       -           -
LGA    Q   220_A      -       -           -
LGA    P   221_A      -       -           -
LGA    S   222_A      -       -           -
LGA    L   223_A      -       -           -
LGA    Q   224_A      -       -           -
LGA    F   225_A      C     213          2.277
LGA    V   226_A      R     214          3.264
LGA    T   227_A      R     215          2.617
LGA    P   228_A      P     216          1.359
LGA    E   229_A      E     217          0.857
LGA    Q   230_A      I     218          0.990
LGA    L   231_A      M     219          0.648
LGA    G   232_A      A     220          0.941
LGA    G   233_A      D     221          1.181
LGA    T   234_A      A     222          1.439
LGA    A   235_A      A     223          1.275
LGA    V   236_A      H     224          0.958
LGA    F   237_A      A     225          1.430
LGA    L   238_A      V     226          1.501
LGA    A   239_A      L     227          1.160
LGA    S   240_A      T     228          1.356
LGA    D   241_A      R     229          2.808
LGA    A   242_A      E     230          4.722
LGA    A   243_A      A     231           #
LGA    A   244_A      A     232          4.271
LGA    Q   245_A      G     233          2.885
LGA    I   246_A      F     234          2.515
LGA    T   247_A      H     235          0.959
LGA    G   248_A      G     236          0.720
LGA    T   249_A      Q     237          1.424
LGA    T   250_A      F     238          0.588
LGA    V   251_A      L     239          0.951
LGA    S   252_A      I     240          2.430
LGA    V   253_A      D     241          3.550
LGA    -       -      D     242           -
LGA    -       -      E     243           -
LGA    -       -      V     244           -
LGA    -       -      L     245           -
LGA    -       -      A     246           -
LGA    -       -      Q     247           -
LGA    -       -      A     248           -
LGA    -       -      G     249           -
LGA    -       -      I     250           -
LGA    -       -      T     251           -
LGA    -       -      D     252           -
LGA    -       -      L     253           -
LGA    -       -      S     254           -
LGA    -       -      G     255           -
LGA    -       -      Y     256           -
LGA    -       -      A     257           -
LGA    -       -      V     258           -
LGA    -       -      D     259           -
LGA    -       -      P     260           -
LGA    -       -      Q     261           -
LGA    -       -      R     262           -
LGA    -       -      A     263           -
LGA    -       -      L     264           -
LGA    -       -      L     265           -
LGA    -       -      P     266           -
LGA    D   254_A      D     267          4.539
LGA    G   255_A      L     268           -
LGA    G   256_A      F     269           -
LGA    W   257_A      L     270          3.973
LGA    T   258_A      E     271          2.348
LGA    A   259_A      -       -           -
LGA    R   260_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  260  271    5.0    219    1.93    28.77     69.787    10.796

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.991327 * X  +   0.109755 * Y  +   0.072282 * Z  +  66.243591
  Y_new =   0.096619 * X  +  -0.235857 * Y  +  -0.966973 * Z  +  59.267105
  Z_new =  -0.089082 * X  +   0.965570 * Y  +  -0.244416 * Z  +  35.179520 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.818720   -1.322873  [ DEG:   104.2050    -75.7950 ]
  Theta =   0.089201    3.052392  [ DEG:     5.1108    174.8892 ]
  Phi   =   0.097157   -3.044435  [ DEG:     5.5667   -174.4333 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1wmb_A                                        
REMARK     2: T0511.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1wmb_A.T0511.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  260  271   5.0  219   1.93   28.77  69.787
REMARK  ---------------------------------------------------------- 
MOLECULE 1wmb_A
HEADER    OXIDOREDUCTASE                          06-JUL-04   1WMB              
TITLE     CRYSTAL STRUCTURE OF NAD DEPENDENT D-3-HYDROXYBUTYLATE                
TITLE    2 DEHYDROGENASE                                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: D(-)-3-HYDROXYBUTYRATE DEHYDROGENASE;                      
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 EC: 1.1.1.30;                                                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS FRAGI;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PKK233-3                                  
KEYWDS    NAD, NADH, SHORT CHAIN DEHYDROGENASE, OXIDOREDUCTASE                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.ITO,Y.NAKAJIMA,E.ICHIHARA,K.OGAWA,T.YOSHIMOTO                       
REVDAT   2   10-JAN-06 1WMB    1       JRNL                                     
REVDAT   1   06-SEP-05 1WMB    0                                                
JRNL        AUTH   K.ITO,Y.NAKAJIMA,E.ICHIHARA,K.OGAWA,N.KATAYAMA,              
JRNL        AUTH 2 K.NAKASHIMA,T.YOSHIMOTO                                      
JRNL        TITL   D-3-HYDROXYBUTYRATE DEHYDROGENASE FROM PSEUDOMONAS           
JRNL        TITL 2 FRAGI: MOLECULAR CLONING OF THE ENZYME GENE AND              
JRNL        TITL 3 CRYSTAL STRUCTURE OF THE ENZYME                              
JRNL        REF    J.MOL.BIOL.                   V. 355   722 2006              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1WMB A    1   260  UNP    Q5KST5   Q5KST5_PSEFR     1    260             
DBREF  1WMB B    1   260  UNP    Q5KST5   Q5KST5_PSEFR     1    260             
SEQRES   1 A  260  MET LEU LYS GLY LYS VAL ALA VAL VAL THR GLY SER THR          
SEQRES   2 A  260  SER GLY ILE GLY LEU GLY ILE ALA THR ALA LEU ALA ALA          
SEQRES   3 A  260  GLN GLY ALA ASP ILE VAL LEU ASN GLY PHE GLY ASP ALA          
SEQRES   4 A  260  ALA GLU ILE GLU LYS VAL ARG ALA GLY LEU ALA ALA GLN          
SEQRES   5 A  260  HIS GLY VAL LYS VAL LEU TYR ASP GLY ALA ASP LEU SER          
SEQRES   6 A  260  LYS GLY GLU ALA VAL ARG GLY LEU VAL ASP ASN ALA VAL          
SEQRES   7 A  260  ARG GLN MET GLY ARG ILE ASP ILE LEU VAL ASN ASN ALA          
SEQRES   8 A  260  GLY ILE GLN HIS THR ALA LEU ILE GLU ASP PHE PRO THR          
SEQRES   9 A  260  GLU LYS TRP ASP ALA ILE LEU ALA LEU ASN LEU SER ALA          
SEQRES  10 A  260  VAL PHE HIS GLY THR ALA ALA ALA LEU PRO HIS MET LYS          
SEQRES  11 A  260  LYS GLN GLY PHE GLY ARG ILE ILE ASN ILE ALA SER ALA          
SEQRES  12 A  260  HIS GLY LEU VAL ALA SER ALA ASN LYS SER ALA TYR VAL          
SEQRES  13 A  260  ALA ALA LYS HIS GLY VAL VAL GLY PHE THR LYS VAL THR          
SEQRES  14 A  260  ALA LEU GLU THR ALA GLY GLN GLY ILE THR ALA ASN ALA          
SEQRES  15 A  260  ILE CYS PRO GLY TRP VAL ARG THR PRO LEU VAL GLU LYS          
SEQRES  16 A  260  GLN ILE SER ALA LEU ALA GLU LYS ASN GLY VAL ASP GLN          
SEQRES  17 A  260  GLU THR ALA ALA ARG GLU LEU LEU SER GLU LYS GLN PRO          
SEQRES  18 A  260  SER LEU GLN PHE VAL THR PRO GLU GLN LEU GLY GLY THR          
SEQRES  19 A  260  ALA VAL PHE LEU ALA SER ASP ALA ALA ALA GLN ILE THR          
SEQRES  20 A  260  GLY THR THR VAL SER VAL ASP GLY GLY TRP THR ALA ARG          
SEQRES   1 B  260  MET LEU LYS GLY LYS VAL ALA VAL VAL THR GLY SER THR          
SEQRES   2 B  260  SER GLY ILE GLY LEU GLY ILE ALA THR ALA LEU ALA ALA          
SEQRES   3 B  260  GLN GLY ALA ASP ILE VAL LEU ASN GLY PHE GLY ASP ALA          
SEQRES   4 B  260  ALA GLU ILE GLU LYS VAL ARG ALA GLY LEU ALA ALA GLN          
SEQRES   5 B  260  HIS GLY VAL LYS VAL LEU TYR ASP GLY ALA ASP LEU SER          
SEQRES   6 B  260  LYS GLY GLU ALA VAL ARG GLY LEU VAL ASP ASN ALA VAL          
SEQRES   7 B  260  ARG GLN MET GLY ARG ILE ASP ILE LEU VAL ASN ASN ALA          
SEQRES   8 B  260  GLY ILE GLN HIS THR ALA LEU ILE GLU ASP PHE PRO THR          
SEQRES   9 B  260  GLU LYS TRP ASP ALA ILE LEU ALA LEU ASN LEU SER ALA          
SEQRES  10 B  260  VAL PHE HIS GLY THR ALA ALA ALA LEU PRO HIS MET LYS          
SEQRES  11 B  260  LYS GLN GLY PHE GLY ARG ILE ILE ASN ILE ALA SER ALA          
SEQRES  12 B  260  HIS GLY LEU VAL ALA SER ALA ASN LYS SER ALA TYR VAL          
SEQRES  13 B  260  ALA ALA LYS HIS GLY VAL VAL GLY PHE THR LYS VAL THR          
SEQRES  14 B  260  ALA LEU GLU THR ALA GLY GLN GLY ILE THR ALA ASN ALA          
SEQRES  15 B  260  ILE CYS PRO GLY TRP VAL ARG THR PRO LEU VAL GLU LYS          
SEQRES  16 B  260  GLN ILE SER ALA LEU ALA GLU LYS ASN GLY VAL ASP GLN          
SEQRES  17 B  260  GLU THR ALA ALA ARG GLU LEU LEU SER GLU LYS GLN PRO          
SEQRES  18 B  260  SER LEU GLN PHE VAL THR PRO GLU GLN LEU GLY GLY THR          
SEQRES  19 B  260  ALA VAL PHE LEU ALA SER ASP ALA ALA ALA GLN ILE THR          
SEQRES  20 B  260  GLY THR THR VAL SER VAL ASP GLY GLY TRP THR ALA ARG          
HET     MG   1301       1                                                       
HET    CAC   1302       5                                                       
HET     MG   2301       1                                                       
HET    CAC   2302       5                                                       
HETNAM      MG MAGNESIUM ION                                                    
HETNAM     CAC CACODYLATE ION                                                   
FORMUL   3   MG    2(MG 2+)                                                     
FORMUL   4  CAC    2(C2 H6 AS O2 1-)                                            
FORMUL   7  HOH   *428(H2 O)                                                    
CRYST1   64.336   99.025  110.229  90.00  90.00  90.00 P 21 21 2     8          
ATOM      1  N   MET A   1      62.908  32.054  48.028  1.00 32.77           N  
ATOM      2  CA  MET A   1      63.132  33.523  47.934  1.00 32.63           C  
ATOM      3  C   MET A   1      62.405  34.254  49.057  1.00 31.32           C  
ATOM      4  O   MET A   1      61.611  33.659  49.786  1.00 31.65           O  
ATOM      5  CB  MET A   1      62.647  34.044  46.577  1.00 37.18           C  
ATOM      6  CG  MET A   1      63.427  33.510  45.384  1.00 40.02           C  
ATOM      7  SD  MET A   1      65.161  34.022  45.394  1.00 46.83           S  
ATOM      8  CE  MET A   1      65.128  35.374  44.239  1.00 43.46           C  
ATOM      9  N   LEU A   2      62.684  35.545  49.190  1.00 29.08           N  
ATOM     10  CA  LEU A   2      62.068  36.365  50.224  1.00 28.02           C  
ATOM     11  C   LEU A   2      61.477  37.639  49.633  1.00 28.66           C  
ATOM     12  O   LEU A   2      61.359  38.658  50.313  1.00 28.56           O  
ATOM     13  CB  LEU A   2      63.104  36.726  51.289  1.00 25.86           C  
ATOM     14  CG  LEU A   2      63.751  35.546  52.015  1.00 23.92           C  
ATOM     15  CD1 LEU A   2      64.840  36.062  52.946  1.00 22.19           C  
ATOM     16  CD2 LEU A   2      62.689  34.771  52.791  1.00 20.58           C  
ATOM     17  N   LYS A   3      61.108  37.577  48.359  1.00 29.84           N  
ATOM     18  CA  LYS A   3      60.525  38.726  47.687  1.00 30.50           C  
ATOM     19  C   LYS A   3      59.255  39.150  48.414  1.00 29.74           C  
ATOM     20  O   LYS A   3      58.443  38.309  48.804  1.00 29.44           O  
ATOM     21  CB  LYS A   3      60.200  38.369  46.236  1.00 33.77           C  
ATOM     22  CG  LYS A   3      61.401  37.860  45.460  1.00 36.85           C  
ATOM     23  CD  LYS A   3      61.009  37.373  44.077  1.00 40.11           C  
ATOM     24  CE  LYS A   3      62.214  36.797  43.345  1.00 41.14           C  
ATOM     25  NZ  LYS A   3      61.834  36.156  42.058  1.00 42.40           N  
ATOM     26  N   GLY A   4      59.088  40.452  48.604  1.00 28.06           N  
ATOM     27  CA  GLY A   4      57.904  40.940  49.284  1.00 27.84           C  
ATOM     28  C   GLY A   4      58.051  40.952  50.793  1.00 27.02           C  
ATOM     29  O   GLY A   4      57.099  41.258  51.514  1.00 26.78           O  
ATOM     30  N   LYS A   5      59.241  40.611  51.278  1.00 25.91           N  
ATOM     31  CA  LYS A   5      59.495  40.599  52.714  1.00 24.35           C  
ATOM     32  C   LYS A   5      60.461  41.703  53.113  1.00 22.71           C  
ATOM     33  O   LYS A   5      61.302  42.125  52.320  1.00 23.48           O  
ATOM     34  CB  LYS A   5      60.034  39.233  53.148  1.00 25.71           C  
ATOM     35  CG  LYS A   5      58.952  38.165  53.206  1.00 26.39           C  
ATOM     36  CD  LYS A   5      59.495  36.808  53.593  1.00 26.20           C  
ATOM     37  CE  LYS A   5      58.361  35.809  53.771  1.00 26.42           C  
ATOM     38  NZ  LYS A   5      57.543  35.659  52.538  1.00 28.76           N  
ATOM     39  N   VAL A   6      60.324  42.173  54.346  1.00 20.35           N  
ATOM     40  CA  VAL A   6      61.176  43.233  54.860  1.00 18.73           C  
ATOM     41  C   VAL A   6      62.051  42.712  55.997  1.00 18.79           C  
ATOM     42  O   VAL A   6      61.546  42.172  56.988  1.00 17.35           O  
ATOM     43  CB  VAL A   6      60.330  44.413  55.374  1.00 18.91           C  
ATOM     44  CG1 VAL A   6      61.239  45.513  55.918  1.00 18.45           C  
ATOM     45  CG2 VAL A   6      59.452  44.943  54.251  1.00 16.99           C  
ATOM     46  N   ALA A   7      63.361  42.890  55.844  1.00 15.87           N  
ATOM     47  CA  ALA A   7      64.327  42.442  56.839  1.00 17.47           C  
ATOM     48  C   ALA A   7      65.101  43.606  57.441  1.00 17.06           C  
ATOM     49  O   ALA A   7      65.626  44.450  56.715  1.00 17.14           O  
ATOM     50  CB  ALA A   7      65.300  41.463  56.202  1.00 18.00           C  
ATOM     51  N   VAL A   8      65.156  43.655  58.768  1.00 17.18           N  
ATOM     52  CA  VAL A   8      65.896  44.702  59.474  1.00 17.85           C  
ATOM     53  C   VAL A   8      67.102  44.020  60.112  1.00 17.86           C  
ATOM     54  O   VAL A   8      66.952  42.990  60.775  1.00 16.59           O  
ATOM     55  CB  VAL A   8      65.045  45.368  60.592  1.00 17.30           C  
ATOM     56  CG1 VAL A   8      65.906  46.344  61.395  1.00 15.69           C  
ATOM     57  CG2 VAL A   8      63.853  46.100  59.983  1.00 16.57           C  
ATOM     58  N   VAL A   9      68.292  44.581  59.902  1.00 18.28           N  
ATOM     59  CA  VAL A   9      69.525  44.013  60.459  1.00 18.45           C  
ATOM     60  C   VAL A   9      70.328  45.051  61.236  1.00 17.56           C  
ATOM     61  O   VAL A   9      70.812  46.023  60.664  1.00 17.74           O  
ATOM     62  CB  VAL A   9      70.442  43.444  59.340  1.00 18.62           C  
ATOM     63  CG1 VAL A   9      71.623  42.710  59.957  1.00 18.54           C  
ATOM     64  CG2 VAL A   9      69.653  42.517  58.430  1.00 16.26           C  
ATOM     65  N   THR A  10      70.476  44.846  62.543  1.00 18.19           N  
ATOM     66  CA  THR A  10      71.238  45.781  63.365  1.00 16.87           C  
ATOM     67  C   THR A  10      72.738  45.542  63.179  1.00 17.56           C  
ATOM     68  O   THR A  10      73.171  44.404  62.957  1.00 17.20           O  
ATOM     69  CB  THR A  10      70.872  45.636  64.864  1.00 17.97           C  
ATOM     70  OG1 THR A  10      71.400  44.405  65.379  1.00 17.18           O  
ATOM     71  CG2 THR A  10      69.352  45.640  65.037  1.00 17.67           C  
ATOM     72  N   GLY A  11      73.525  46.613  63.264  1.00 16.43           N  
ATOM     73  CA  GLY A  11      74.968  46.496  63.092  1.00 15.31           C  
ATOM     74  C   GLY A  11      75.321  45.889  61.748  1.00 16.70           C  
ATOM     75  O   GLY A  11      76.185  45.016  61.648  1.00 14.86           O  
ATOM     76  N   SER A  12      74.663  46.371  60.698  1.00 15.45           N  
ATOM     77  CA  SER A  12      74.878  45.846  59.363  1.00 15.87           C  
ATOM     78  C   SER A  12      75.630  46.754  58.402  1.00 17.71           C  
ATOM     79  O   SER A  12      75.563  46.548  57.196  1.00 18.04           O  
ATOM     80  CB  SER A  12      73.528  45.478  58.736  1.00 15.22           C  
ATOM     81  OG  SER A  12      72.644  46.586  58.770  1.00 15.55           O  
ATOM     82  N   THR A  13      76.344  47.751  58.913  1.00 19.19           N  
ATOM     83  CA  THR A  13      77.078  48.646  58.025  1.00 22.98           C  
ATOM     84  C   THR A  13      78.362  48.002  57.524  1.00 23.37           C  
ATOM     85  O   THR A  13      79.026  48.543  56.643  1.00 23.04           O  
ATOM     86  CB  THR A  13      77.440  49.986  58.711  1.00 22.46           C  
ATOM     87  OG1 THR A  13      78.296  49.739  59.831  1.00 26.14           O  
ATOM     88  CG2 THR A  13      76.179  50.706  59.173  1.00 21.78           C  
ATOM     89  N   SER A  14      78.707  46.847  58.090  1.00 23.89           N  
ATOM     90  CA  SER A  14      79.914  46.131  57.693  1.00 23.84           C  
ATOM     91  C   SER A  14      79.971  44.738  58.313  1.00 23.31           C  
ATOM     92  O   SER A  14      79.071  44.329  59.043  1.00 21.54           O  
ATOM     93  CB  SER A  14      81.160  46.908  58.122  1.00 24.93           C  
ATOM     94  OG  SER A  14      81.307  46.889  59.535  1.00 26.42           O  
ATOM     95  N   GLY A  15      81.051  44.027  58.007  1.00 23.08           N  
ATOM     96  CA  GLY A  15      81.266  42.696  58.537  1.00 20.53           C  
ATOM     97  C   GLY A  15      80.109  41.719  58.450  1.00 20.34           C  
ATOM     98  O   GLY A  15      79.431  41.613  57.429  1.00 17.94           O  
ATOM     99  N   ILE A  16      79.908  40.994  59.545  1.00 18.98           N  
ATOM    100  CA  ILE A  16      78.864  39.990  59.658  1.00 18.28           C  
ATOM    101  C   ILE A  16      77.484  40.535  59.319  1.00 18.16           C  
ATOM    102  O   ILE A  16      76.791  39.987  58.464  1.00 18.55           O  
ATOM    103  CB  ILE A  16      78.835  39.407  61.093  1.00 18.48           C  
ATOM    104  CG1 ILE A  16      80.206  38.811  61.432  1.00 17.33           C  
ATOM    105  CG2 ILE A  16      77.752  38.346  61.203  1.00 16.46           C  
ATOM    106  CD1 ILE A  16      80.364  38.409  62.879  1.00 19.04           C  
ATOM    107  N   GLY A  17      77.090  41.610  59.999  1.00 18.14           N  
ATOM    108  CA  GLY A  17      75.787  42.207  59.760  1.00 18.54           C  
ATOM    109  C   GLY A  17      75.563  42.542  58.296  1.00 19.03           C  
ATOM    110  O   GLY A  17      74.484  42.295  57.752  1.00 18.45           O  
ATOM    111  N   LEU A  18      76.585  43.106  57.655  1.00 19.24           N  
ATOM    112  CA  LEU A  18      76.498  43.471  56.245  1.00 16.90           C  
ATOM    113  C   LEU A  18      76.367  42.231  55.370  1.00 17.04           C  
ATOM    114  O   LEU A  18      75.601  42.219  54.396  1.00 15.36           O  
ATOM    115  CB  LEU A  18      77.737  44.268  55.830  1.00 19.16           C  
ATOM    116  CG  LEU A  18      77.776  44.747  54.375  1.00 21.63           C  
ATOM    117  CD1 LEU A  18      76.457  45.404  54.000  1.00 22.61           C  
ATOM    118  CD2 LEU A  18      78.929  45.718  54.199  1.00 22.21           C  
ATOM    119  N   GLY A  19      77.119  41.189  55.713  1.00 14.42           N  
ATOM    120  CA  GLY A  19      77.054  39.961  54.945  1.00 14.25           C  
ATOM    121  C   GLY A  19      75.649  39.392  54.982  1.00 16.02           C  
ATOM    122  O   GLY A  19      75.148  38.867  53.983  1.00 16.24           O  
ATOM    123  N   ILE A  20      75.007  39.512  56.141  1.00 15.07           N  
ATOM    124  CA  ILE A  20      73.653  38.999  56.329  1.00 15.65           C  
ATOM    125  C   ILE A  20      72.614  39.823  55.565  1.00 14.73           C  
ATOM    126  O   ILE A  20      71.730  39.269  54.912  1.00 14.60           O  
ATOM    127  CB  ILE A  20      73.289  38.964  57.836  1.00 14.25           C  
ATOM    128  CG1 ILE A  20      74.173  37.931  58.549  1.00 13.01           C  
ATOM    129  CG2 ILE A  20      71.811  38.634  58.017  1.00 10.28           C  
ATOM    130  CD1 ILE A  20      74.075  37.977  60.065  1.00 16.46           C  
ATOM    131  N   ALA A  21      72.721  41.141  55.651  1.00 14.41           N  
ATOM    132  CA  ALA A  21      71.791  42.019  54.955  1.00 16.65           C  
ATOM    133  C   ALA A  21      71.893  41.802  53.445  1.00 17.23           C  
ATOM    134  O   ALA A  21      70.897  41.887  52.718  1.00 18.30           O  
ATOM    135  CB  ALA A  21      72.097  43.471  55.297  1.00 14.66           C  
ATOM    136  N   THR A  22      73.107  41.519  52.987  1.00 18.04           N  
ATOM    137  CA  THR A  22      73.380  41.297  51.574  1.00 17.48           C  
ATOM    138  C   THR A  22      72.771  39.989  51.088  1.00 19.26           C  
ATOM    139  O   THR A  22      72.152  39.949  50.023  1.00 19.07           O  
ATOM    140  CB  THR A  22      74.900  41.294  51.311  1.00 17.04           C  
ATOM    141  OG1 THR A  22      75.445  42.574  51.661  1.00 15.43           O  
ATOM    142  CG2 THR A  22      75.193  41.007  49.853  1.00 17.87           C  
ATOM    143  N   ALA A  23      72.948  38.919  51.865  1.00 16.97           N  
ATOM    144  CA  ALA A  23      72.387  37.622  51.499  1.00 17.78           C  
ATOM    145  C   ALA A  23      70.861  37.718  51.459  1.00 17.76           C  
ATOM    146  O   ALA A  23      70.217  37.142  50.580  1.00 19.03           O  
ATOM    147  CB  ALA A  23      72.828  36.542  52.503  1.00 16.63           C  
ATOM    148  N   LEU A  24      70.285  38.450  52.408  1.00 17.97           N  
ATOM    149  CA  LEU A  24      68.834  38.620  52.453  1.00 18.41           C  
ATOM    150  C   LEU A  24      68.373  39.447  51.255  1.00 19.96           C  
ATOM    151  O   LEU A  24      67.413  39.086  50.563  1.00 20.27           O  
ATOM    152  CB  LEU A  24      68.424  39.312  53.756  1.00 18.29           C  
ATOM    153  CG  LEU A  24      68.682  38.471  55.012  1.00 15.24           C  
ATOM    154  CD1 LEU A  24      68.429  39.300  56.261  1.00 14.16           C  
ATOM    155  CD2 LEU A  24      67.792  37.244  54.979  1.00 14.92           C  
ATOM    156  N   ALA A  25      69.068  40.555  51.014  1.00 19.36           N  
ATOM    157  CA  ALA A  25      68.749  41.428  49.898  1.00 20.87           C  
ATOM    158  C   ALA A  25      68.863  40.626  48.608  1.00 21.68           C  
ATOM    159  O   ALA A  25      68.090  40.819  47.674  1.00 23.14           O  
ATOM    160  CB  ALA A  25      69.707  42.617  49.875  1.00 18.94           C  
ATOM    161  N   ALA A  26      69.820  39.705  48.577  1.00 23.93           N  
ATOM    162  CA  ALA A  26      70.046  38.865  47.410  1.00 23.12           C  
ATOM    163  C   ALA A  26      68.867  37.934  47.146  1.00 23.74           C  
ATOM    164  O   ALA A  26      68.693  37.451  46.029  1.00 22.93           O  
ATOM    165  CB  ALA A  26      71.323  38.057  47.593  1.00 23.15           C  
ATOM    166  N   GLN A  27      68.055  37.681  48.170  1.00 22.46           N  
ATOM    167  CA  GLN A  27      66.896  36.808  48.007  1.00 21.46           C  
ATOM    168  C   GLN A  27      65.634  37.606  47.662  1.00 20.36           C  
ATOM    169  O   GLN A  27      64.543  37.049  47.587  1.00 18.60           O  
ATOM    170  CB  GLN A  27      66.660  35.985  49.282  1.00 23.61           C  
ATOM    171  CG  GLN A  27      67.779  35.002  49.616  1.00 23.61           C  
ATOM    172  CD  GLN A  27      67.959  33.937  48.551  1.00 24.21           C  
ATOM    173  OE1 GLN A  27      67.045  33.168  48.275  1.00 26.36           O  
ATOM    174  NE2 GLN A  27      69.140  33.889  47.950  1.00 26.56           N  
ATOM    175  N   GLY A  28      65.788  38.913  47.467  1.00 20.56           N  
ATOM    176  CA  GLY A  28      64.650  39.746  47.110  1.00 21.38           C  
ATOM    177  C   GLY A  28      63.992  40.504  48.249  1.00 21.32           C  
ATOM    178  O   GLY A  28      62.988  41.189  48.048  1.00 20.82           O  
ATOM    179  N   ALA A  29      64.547  40.397  49.450  1.00 20.97           N  
ATOM    180  CA  ALA A  29      63.973  41.090  50.598  1.00 20.20           C  
ATOM    181  C   ALA A  29      64.410  42.551  50.666  1.00 19.32           C  
ATOM    182  O   ALA A  29      65.559  42.869  50.367  1.00 18.01           O  
ATOM    183  CB  ALA A  29      64.372  40.374  51.889  1.00 17.80           C  
ATOM    184  N   ASP A  30      63.491  43.440  51.040  1.00 20.84           N  
ATOM    185  CA  ASP A  30      63.841  44.848  51.193  1.00 22.51           C  
ATOM    186  C   ASP A  30      64.679  44.878  52.465  1.00 22.94           C  
ATOM    187  O   ASP A  30      64.482  44.042  53.354  1.00 22.30           O  
ATOM    188  CB  ASP A  30      62.601  45.729  51.363  1.00 23.60           C  
ATOM    189  CG  ASP A  30      61.870  45.973  50.049  1.00 26.49           C  
ATOM    190  OD1 ASP A  30      62.542  46.055  48.995  1.00 25.50           O  
ATOM    191  OD2 ASP A  30      60.627  46.098  50.074  1.00 27.28           O  
ATOM    192  N   ILE A  31      65.595  45.837  52.559  1.00 20.93           N  
ATOM    193  CA  ILE A  31      66.486  45.911  53.712  1.00 20.88           C  
ATOM    194  C   ILE A  31      66.539  47.248  54.440  1.00 20.38           C  
ATOM    195  O   ILE A  31      66.409  48.318  53.837  1.00 19.33           O  
ATOM    196  CB  ILE A  31      67.951  45.570  53.298  1.00 20.61           C  
ATOM    197  CG1 ILE A  31      68.004  44.225  52.573  1.00 19.48           C  
ATOM    198  CG2 ILE A  31      68.857  45.550  54.527  1.00 20.34           C  
ATOM    199  CD1 ILE A  31      67.472  43.059  53.388  1.00 21.28           C  
ATOM    200  N   VAL A  32      66.738  47.161  55.750  1.00 19.67           N  
ATOM    201  CA  VAL A  32      66.896  48.332  56.593  1.00 18.80           C  
ATOM    202  C   VAL A  32      68.243  48.148  57.283  1.00 20.52           C  
ATOM    203  O   VAL A  32      68.389  47.278  58.152  1.00 19.00           O  
ATOM    204  CB  VAL A  32      65.820  48.438  57.683  1.00 20.51           C  
ATOM    205  CG1 VAL A  32      66.153  49.601  58.606  1.00 20.26           C  
ATOM    206  CG2 VAL A  32      64.448  48.638  57.051  1.00 20.41           C  
ATOM    207  N   LEU A  33      69.226  48.947  56.876  1.00 18.31           N  
ATOM    208  CA  LEU A  33      70.562  48.887  57.463  1.00 18.23           C  
ATOM    209  C   LEU A  33      70.598  49.739  58.723  1.00 18.05           C  
ATOM    210  O   LEU A  33      69.779  50.646  58.902  1.00 17.89           O  
ATOM    211  CB  LEU A  33      71.615  49.395  56.470  1.00 18.17           C  
ATOM    212  CG  LEU A  33      71.773  48.619  55.159  1.00 17.20           C  
ATOM    213  CD1 LEU A  33      72.780  49.334  54.278  1.00 19.10           C  
ATOM    214  CD2 LEU A  33      72.227  47.187  55.446  1.00 18.94           C  
ATOM    215  N   ASN A  34      71.557  49.446  59.592  1.00 17.66           N  
ATOM    216  CA  ASN A  34      71.698  50.166  60.848  1.00 19.34           C  
ATOM    217  C   ASN A  34      73.095  49.963  61.423  1.00 20.22           C  
ATOM    218  O   ASN A  34      73.799  49.037  61.035  1.00 20.05           O  
ATOM    219  CB  ASN A  34      70.629  49.675  61.840  1.00 17.23           C  
ATOM    220  CG  ASN A  34      71.030  49.882  63.288  1.00 16.92           C  
ATOM    221  OD1 ASN A  34      71.721  49.048  63.876  1.00 16.51           O  
ATOM    222  ND2 ASN A  34      70.611  51.001  63.868  1.00 15.32           N  
ATOM    223  N   GLY A  35      73.495  50.839  62.337  1.00 22.13           N  
ATOM    224  CA  GLY A  35      74.805  50.712  62.949  1.00 26.19           C  
ATOM    225  C   GLY A  35      75.667  51.953  62.813  1.00 28.24           C  
ATOM    226  O   GLY A  35      75.542  52.708  61.846  1.00 27.84           O  
ATOM    227  N   PHE A  36      76.543  52.166  63.788  1.00 29.51           N  
ATOM    228  CA  PHE A  36      77.436  53.309  63.771  1.00 30.78           C  
ATOM    229  C   PHE A  36      78.514  53.136  62.711  1.00 29.73           C  
ATOM    230  O   PHE A  36      78.998  52.029  62.463  1.00 27.50           O  
ATOM    231  CB  PHE A  36      78.074  53.507  65.148  1.00 35.22           C  
ATOM    232  CG  PHE A  36      77.147  54.121  66.166  1.00 41.39           C  
ATOM    233  CD1 PHE A  36      77.500  54.164  67.512  1.00 43.74           C  
ATOM    234  CD2 PHE A  36      75.925  54.676  65.776  1.00 44.00           C  
ATOM    235  CE1 PHE A  36      76.652  54.751  68.457  1.00 45.18           C  
ATOM    236  CE2 PHE A  36      75.071  55.265  66.712  1.00 44.35           C  
ATOM    237  CZ  PHE A  36      75.436  55.303  68.053  1.00 44.75           C  
ATOM    238  N   GLY A  37      78.875  54.247  62.078  1.00 27.45           N  
ATOM    239  CA  GLY A  37      79.886  54.217  61.042  1.00 26.81           C  
ATOM    240  C   GLY A  37      79.973  55.558  60.338  1.00 26.00           C  
ATOM    241  O   GLY A  37      79.397  56.548  60.790  1.00 26.49           O  
ATOM    242  N   ASP A  38      80.690  55.583  59.224  1.00 23.72           N  
ATOM    243  CA  ASP A  38      80.873  56.798  58.447  1.00 22.82           C  
ATOM    244  C   ASP A  38      79.676  57.059  57.529  1.00 21.59           C  
ATOM    245  O   ASP A  38      79.365  56.247  56.661  1.00 22.34           O  
ATOM    246  CB  ASP A  38      82.151  56.670  57.629  1.00 23.74           C  
ATOM    247  CG  ASP A  38      82.512  57.943  56.920  1.00 25.21           C  
ATOM    248  OD1 ASP A  38      81.957  58.203  55.830  1.00 25.41           O  
ATOM    249  OD2 ASP A  38      83.349  58.685  57.469  1.00 25.86           O  
ATOM    250  N   ALA A  39      79.010  58.193  57.723  1.00 22.16           N  
ATOM    251  CA  ALA A  39      77.835  58.542  56.921  1.00 20.79           C  
ATOM    252  C   ALA A  39      78.066  58.394  55.419  1.00 21.51           C  
ATOM    253  O   ALA A  39      77.274  57.759  54.720  1.00 22.07           O  
ATOM    254  CB  ALA A  39      77.387  59.962  57.242  1.00 21.56           C  
ATOM    255  N   ALA A  40      79.156  58.981  54.929  1.00 21.56           N  
ATOM    256  CA  ALA A  40      79.499  58.924  53.509  1.00 20.38           C  
ATOM    257  C   ALA A  40      79.589  57.487  52.991  1.00 20.83           C  
ATOM    258  O   ALA A  40      78.950  57.127  51.997  1.00 18.34           O  
ATOM    259  CB  ALA A  40      80.825  59.646  53.269  1.00 20.31           C  
ATOM    260  N   GLU A  41      80.389  56.667  53.663  1.00 20.27           N  
ATOM    261  CA  GLU A  41      80.556  55.281  53.254  1.00 19.91           C  
ATOM    262  C   GLU A  41      79.290  54.463  53.460  1.00 18.19           C  
ATOM    263  O   GLU A  41      78.989  53.564  52.678  1.00 17.44           O  
ATOM    264  CB  GLU A  41      81.727  54.653  54.011  1.00 22.83           C  
ATOM    265  CG  GLU A  41      83.076  55.215  53.586  1.00 25.60           C  
ATOM    266  CD  GLU A  41      83.303  55.085  52.087  1.00 28.58           C  
ATOM    267  OE1 GLU A  41      83.111  53.970  51.552  1.00 29.21           O  
ATOM    268  OE2 GLU A  41      83.673  56.091  51.440  1.00 29.00           O  
ATOM    269  N   ILE A  42      78.537  54.781  54.504  1.00 19.81           N  
ATOM    270  CA  ILE A  42      77.301  54.053  54.765  1.00 21.55           C  
ATOM    271  C   ILE A  42      76.323  54.238  53.606  1.00 22.45           C  
ATOM    272  O   ILE A  42      75.691  53.278  53.156  1.00 21.71           O  
ATOM    273  CB  ILE A  42      76.655  54.514  56.094  1.00 20.89           C  
ATOM    274  CG1 ILE A  42      77.490  53.991  57.273  1.00 22.56           C  
ATOM    275  CG2 ILE A  42      75.219  54.012  56.182  1.00 21.55           C  
ATOM    276  CD1 ILE A  42      77.014  54.452  58.645  1.00 22.23           C  
ATOM    277  N   GLU A  43      76.214  55.467  53.111  1.00 23.55           N  
ATOM    278  CA  GLU A  43      75.321  55.752  51.993  1.00 24.26           C  
ATOM    279  C   GLU A  43      75.767  54.989  50.749  1.00 25.17           C  
ATOM    280  O   GLU A  43      74.936  54.493  49.987  1.00 26.17           O  
ATOM    281  CB  GLU A  43      75.290  57.255  51.688  1.00 25.50           C  
ATOM    282  CG  GLU A  43      74.648  57.586  50.345  1.00 25.55           C  
ATOM    283  CD  GLU A  43      73.202  57.124  50.248  1.00 26.54           C  
ATOM    284  OE1 GLU A  43      72.671  57.049  49.119  1.00 25.69           O  
ATOM    285  OE2 GLU A  43      72.592  56.843  51.300  1.00 27.20           O  
ATOM    286  N   LYS A  44      77.076  54.898  50.543  1.00 25.91           N  
ATOM    287  CA  LYS A  44      77.604  54.179  49.390  1.00 27.64           C  
ATOM    288  C   LYS A  44      77.175  52.721  49.478  1.00 27.14           C  
ATOM    289  O   LYS A  44      76.779  52.117  48.483  1.00 27.91           O  
ATOM    290  CB  LYS A  44      79.134  54.266  49.350  1.00 29.83           C  
ATOM    291  CG  LYS A  44      79.669  55.684  49.424  1.00 33.84           C  
ATOM    292  CD  LYS A  44      81.113  55.781  48.941  1.00 35.60           C  
ATOM    293  CE  LYS A  44      81.205  55.596  47.429  1.00 37.13           C  
ATOM    294  NZ  LYS A  44      82.561  55.933  46.900  1.00 36.92           N  
ATOM    295  N   VAL A  45      77.255  52.164  50.682  1.00 26.19           N  
ATOM    296  CA  VAL A  45      76.871  50.778  50.918  1.00 24.88           C  
ATOM    297  C   VAL A  45      75.373  50.615  50.686  1.00 23.84           C  
ATOM    298  O   VAL A  45      74.946  49.723  49.949  1.00 23.23           O  
ATOM    299  CB  VAL A  45      77.212  50.344  52.367  1.00 24.02           C  
ATOM    300  CG1 VAL A  45      76.703  48.932  52.630  1.00 26.99           C  
ATOM    301  CG2 VAL A  45      78.711  50.412  52.586  1.00 22.06           C  
ATOM    302  N   ARG A  46      74.585  51.487  51.312  1.00 23.26           N  
ATOM    303  CA  ARG A  46      73.129  51.449  51.184  1.00 24.07           C  
ATOM    304  C   ARG A  46      72.677  51.552  49.727  1.00 24.14           C  
ATOM    305  O   ARG A  46      71.881  50.737  49.256  1.00 23.13           O  
ATOM    306  CB  ARG A  46      72.490  52.594  51.974  1.00 23.61           C  
ATOM    307  CG  ARG A  46      70.963  52.519  52.023  1.00 24.44           C  
ATOM    308  CD  ARG A  46      70.325  53.898  52.168  1.00 26.17           C  
ATOM    309  NE  ARG A  46      70.606  54.750  51.014  1.00 24.68           N  
ATOM    310  CZ  ARG A  46      70.162  54.525  49.779  1.00 27.23           C  
ATOM    311  NH1 ARG A  46      69.401  53.471  49.511  1.00 25.96           N  
ATOM    312  NH2 ARG A  46      70.494  55.353  48.800  1.00 26.40           N  
ATOM    313  N   ALA A  47      73.174  52.568  49.027  1.00 24.70           N  
ATOM    314  CA  ALA A  47      72.826  52.788  47.625  1.00 24.68           C  
ATOM    315  C   ALA A  47      73.289  51.611  46.773  1.00 24.84           C  
ATOM    316  O   ALA A  47      72.538  51.097  45.948  1.00 25.75           O  
ATOM    317  CB  ALA A  47      73.463  54.091  47.123  1.00 24.00           C  
ATOM    318  N   GLY A  48      74.529  51.182  46.982  1.00 26.23           N  
ATOM    319  CA  GLY A  48      75.058  50.066  46.218  1.00 27.23           C  
ATOM    320  C   GLY A  48      74.217  48.811  46.345  1.00 27.58           C  
ATOM    321  O   GLY A  48      73.923  48.147  45.349  1.00 28.45           O  
ATOM    322  N   LEU A  49      73.822  48.484  47.572  1.00 27.25           N  
ATOM    323  CA  LEU A  49      73.018  47.292  47.827  1.00 25.70           C  
ATOM    324  C   LEU A  49      71.684  47.351  47.086  1.00 25.36           C  
ATOM    325  O   LEU A  49      71.256  46.370  46.465  1.00 20.78           O  
ATOM    326  CB  LEU A  49      72.772  47.143  49.334  1.00 26.19           C  
ATOM    327  CG  LEU A  49      72.212  45.803  49.821  1.00 28.21           C  
ATOM    328  CD1 LEU A  49      73.191  44.681  49.479  1.00 27.83           C  
ATOM    329  CD2 LEU A  49      71.973  45.865  51.326  1.00 27.15           C  
ATOM    330  N   ALA A  50      71.026  48.505  47.149  1.00 24.68           N  
ATOM    331  CA  ALA A  50      69.742  48.672  46.479  1.00 27.07           C  
ATOM    332  C   ALA A  50      69.898  48.492  44.967  1.00 28.01           C  
ATOM    333  O   ALA A  50      69.111  47.793  44.330  1.00 28.79           O  
ATOM    334  CB  ALA A  50      69.163  50.052  46.793  1.00 25.96           C  
ATOM    335  N   ALA A  51      70.925  49.119  44.402  1.00 30.20           N  
ATOM    336  CA  ALA A  51      71.177  49.027  42.969  1.00 31.68           C  
ATOM    337  C   ALA A  51      71.535  47.601  42.565  1.00 32.37           C  
ATOM    338  O   ALA A  51      71.018  47.081  41.580  1.00 31.54           O  
ATOM    339  CB  ALA A  51      72.302  49.981  42.572  1.00 31.57           C  
ATOM    340  N   GLN A  52      72.419  46.974  43.337  1.00 33.90           N  
ATOM    341  CA  GLN A  52      72.868  45.611  43.062  1.00 34.77           C  
ATOM    342  C   GLN A  52      71.777  44.550  43.031  1.00 34.87           C  
ATOM    343  O   GLN A  52      71.742  43.713  42.128  1.00 34.91           O  
ATOM    344  CB  GLN A  52      73.928  45.191  44.081  1.00 36.83           C  
ATOM    345  CG  GLN A  52      75.269  45.847  43.863  1.00 41.64           C  
ATOM    346  CD  GLN A  52      75.813  45.567  42.477  1.00 45.78           C  
ATOM    347  OE1 GLN A  52      76.052  44.412  42.113  1.00 46.48           O  
ATOM    348  NE2 GLN A  52      76.005  46.623  41.689  1.00 46.61           N  
ATOM    349  N   HIS A  53      70.886  44.583  44.013  1.00 33.77           N  
ATOM    350  CA  HIS A  53      69.830  43.585  44.094  1.00 34.02           C  
ATOM    351  C   HIS A  53      68.443  44.090  43.731  1.00 32.80           C  
ATOM    352  O   HIS A  53      67.471  43.343  43.803  1.00 32.21           O  
ATOM    353  CB  HIS A  53      69.828  42.980  45.496  1.00 35.05           C  
ATOM    354  CG  HIS A  53      71.155  42.415  45.897  1.00 36.35           C  
ATOM    355  ND1 HIS A  53      71.678  41.271  45.333  1.00 36.68           N  
ATOM    356  CD2 HIS A  53      72.092  42.869  46.764  1.00 36.87           C  
ATOM    357  CE1 HIS A  53      72.879  41.045  45.834  1.00 37.55           C  
ATOM    358  NE2 HIS A  53      73.154  42.001  46.703  1.00 37.27           N  
ATOM    359  N   GLY A  54      68.354  45.354  43.336  1.00 32.40           N  
ATOM    360  CA  GLY A  54      67.069  45.916  42.956  1.00 31.58           C  
ATOM    361  C   GLY A  54      65.992  45.800  44.021  1.00 31.06           C  
ATOM    362  O   GLY A  54      64.862  45.401  43.732  1.00 30.91           O  
ATOM    363  N   VAL A  55      66.345  46.144  45.255  1.00 29.01           N  
ATOM    364  CA  VAL A  55      65.405  46.100  46.367  1.00 27.84           C  
ATOM    365  C   VAL A  55      65.531  47.414  47.120  1.00 27.43           C  
ATOM    366  O   VAL A  55      66.550  48.100  47.009  1.00 27.15           O  
ATOM    367  CB  VAL A  55      65.722  44.936  47.342  1.00 27.64           C  
ATOM    368  CG1 VAL A  55      65.576  43.604  46.630  1.00 26.41           C  
ATOM    369  CG2 VAL A  55      67.131  45.089  47.899  1.00 26.78           C  
ATOM    370  N   LYS A  56      64.504  47.768  47.882  1.00 26.67           N  
ATOM    371  CA  LYS A  56      64.544  49.012  48.635  1.00 27.01           C  
ATOM    372  C   LYS A  56      65.462  48.830  49.831  1.00 26.98           C  
ATOM    373  O   LYS A  56      65.349  47.847  50.565  1.00 25.33           O  
ATOM    374  CB  LYS A  56      63.143  49.407  49.107  1.00 28.38           C  
ATOM    375  CG  LYS A  56      63.090  50.752  49.826  1.00 30.38           C  
ATOM    376  CD  LYS A  56      61.659  51.134  50.174  1.00 33.00           C  
ATOM    377  CE  LYS A  56      61.599  52.439  50.952  1.00 33.56           C  
ATOM    378  NZ  LYS A  56      60.205  52.764  51.360  1.00 34.74           N  
ATOM    379  N   VAL A  57      66.377  49.779  50.013  1.00 26.18           N  
ATOM    380  CA  VAL A  57      67.326  49.733  51.117  1.00 24.56           C  
ATOM    381  C   VAL A  57      67.417  51.083  51.810  1.00 23.71           C  
ATOM    382  O   VAL A  57      67.699  52.099  51.178  1.00 24.31           O  
ATOM    383  CB  VAL A  57      68.740  49.355  50.631  1.00 23.98           C  
ATOM    384  CG1 VAL A  57      69.708  49.321  51.817  1.00 23.54           C  
ATOM    385  CG2 VAL A  57      68.706  48.015  49.924  1.00 21.97           C  
ATOM    386  N   LEU A  58      67.179  51.086  53.114  1.00 22.54           N  
ATOM    387  CA  LEU A  58      67.251  52.311  53.895  1.00 23.32           C  
ATOM    388  C   LEU A  58      68.319  52.115  54.960  1.00 23.72           C  
ATOM    389  O   LEU A  58      68.839  51.012  55.129  1.00 24.37           O  
ATOM    390  CB  LEU A  58      65.908  52.590  54.573  1.00 23.29           C  
ATOM    391  CG  LEU A  58      64.644  52.547  53.709  1.00 25.62           C  
ATOM    392  CD1 LEU A  58      63.427  52.752  54.604  1.00 26.06           C  
ATOM    393  CD2 LEU A  58      64.701  53.612  52.620  1.00 26.39           C  
ATOM    394  N   TYR A  59      68.646  53.188  55.668  1.00 22.18           N  
ATOM    395  CA  TYR A  59      69.621  53.127  56.744  1.00 22.89           C  
ATOM    396  C   TYR A  59      69.113  53.940  57.930  1.00 22.81           C  
ATOM    397  O   TYR A  59      68.689  55.088  57.779  1.00 23.17           O  
ATOM    398  CB  TYR A  59      70.981  53.681  56.296  1.00 21.11           C  
ATOM    399  CG  TYR A  59      71.908  53.968  57.461  1.00 21.19           C  
ATOM    400  CD1 TYR A  59      72.535  52.930  58.159  1.00 20.94           C  
ATOM    401  CD2 TYR A  59      72.112  55.275  57.903  1.00 20.59           C  
ATOM    402  CE1 TYR A  59      73.340  53.194  59.270  1.00 19.91           C  
ATOM    403  CE2 TYR A  59      72.914  55.549  59.011  1.00 21.93           C  
ATOM    404  CZ  TYR A  59      73.523  54.505  59.689  1.00 21.52           C  
ATOM    405  OH  TYR A  59      74.308  54.785  60.788  1.00 20.35           O  
ATOM    406  N   ASP A  60      69.146  53.336  59.110  1.00 22.59           N  
ATOM    407  CA  ASP A  60      68.704  54.017  60.316  1.00 23.56           C  
ATOM    408  C   ASP A  60      69.857  53.944  61.304  1.00 23.69           C  
ATOM    409  O   ASP A  60      70.203  52.860  61.784  1.00 22.91           O  
ATOM    410  CB  ASP A  60      67.469  53.323  60.901  1.00 25.95           C  
ATOM    411  CG  ASP A  60      66.842  54.103  62.047  1.00 24.05           C  
ATOM    412  OD1 ASP A  60      67.589  54.597  62.917  1.00 24.39           O  
ATOM    413  OD2 ASP A  60      65.596  54.213  62.083  1.00 27.38           O  
ATOM    414  N   GLY A  61      70.452  55.096  61.600  1.00 23.51           N  
ATOM    415  CA  GLY A  61      71.571  55.139  62.526  1.00 23.49           C  
ATOM    416  C   GLY A  61      71.187  55.179  63.994  1.00 24.27           C  
ATOM    417  O   GLY A  61      71.899  55.771  64.809  1.00 22.46           O  
ATOM    418  N   ALA A  62      70.071  54.543  64.341  1.00 23.99           N  
ATOM    419  CA  ALA A  62      69.615  54.516  65.729  1.00 23.98           C  
ATOM    420  C   ALA A  62      70.689  53.939  66.653  1.00 23.93           C  
ATOM    421  O   ALA A  62      71.331  52.940  66.324  1.00 23.41           O  
ATOM    422  CB  ALA A  62      68.333  53.695  65.840  1.00 25.30           C  
ATOM    423  N   ASP A  63      70.873  54.584  67.805  1.00 24.25           N  
ATOM    424  CA  ASP A  63      71.850  54.177  68.815  1.00 23.83           C  
ATOM    425  C   ASP A  63      71.312  52.954  69.558  1.00 22.96           C  
ATOM    426  O   ASP A  63      70.480  53.082  70.454  1.00 21.71           O  
ATOM    427  CB  ASP A  63      72.079  55.338  69.790  1.00 25.38           C  
ATOM    428  CG  ASP A  63      73.071  55.004  70.885  1.00 27.88           C  
ATOM    429  OD1 ASP A  63      73.394  55.917  71.674  1.00 27.53           O  
ATOM    430  OD2 ASP A  63      73.526  53.840  70.964  1.00 29.04           O  
ATOM    431  N   LEU A  64      71.798  51.775  69.180  1.00 22.94           N  
ATOM    432  CA  LEU A  64      71.343  50.515  69.770  1.00 21.44           C  
ATOM    433  C   LEU A  64      71.545  50.362  71.279  1.00 20.82           C  
ATOM    434  O   LEU A  64      70.981  49.457  71.893  1.00 21.57           O  
ATOM    435  CB  LEU A  64      71.990  49.342  69.023  1.00 21.19           C  
ATOM    436  CG  LEU A  64      71.625  49.245  67.531  1.00 22.39           C  
ATOM    437  CD1 LEU A  64      72.542  48.253  66.830  1.00 24.67           C  
ATOM    438  CD2 LEU A  64      70.169  48.825  67.372  1.00 20.08           C  
ATOM    439  N   SER A  65      72.334  51.243  71.884  1.00 20.39           N  
ATOM    440  CA  SER A  65      72.565  51.177  73.325  1.00 21.79           C  
ATOM    441  C   SER A  65      71.381  51.797  74.074  1.00 22.78           C  
ATOM    442  O   SER A  65      71.268  51.680  75.300  1.00 22.15           O  
ATOM    443  CB  SER A  65      73.852  51.920  73.694  1.00 23.79           C  
ATOM    444  OG  SER A  65      73.700  53.324  73.553  1.00 26.15           O  
ATOM    445  N   LYS A  66      70.495  52.448  73.322  1.00 22.73           N  
ATOM    446  CA  LYS A  66      69.315  53.101  73.883  1.00 23.96           C  
ATOM    447  C   LYS A  66      68.045  52.296  73.597  1.00 23.49           C  
ATOM    448  O   LYS A  66      67.650  52.126  72.441  1.00 21.88           O  
ATOM    449  CB  LYS A  66      69.166  54.504  73.286  1.00 26.66           C  
ATOM    450  CG  LYS A  66      70.337  55.442  73.549  1.00 31.13           C  
ATOM    451  CD  LYS A  66      70.394  55.872  75.005  1.00 35.18           C  
ATOM    452  CE  LYS A  66      71.424  56.976  75.211  1.00 37.82           C  
ATOM    453  NZ  LYS A  66      71.458  57.438  76.628  1.00 40.31           N  
ATOM    454  N   GLY A  67      67.402  51.819  74.659  1.00 23.63           N  
ATOM    455  CA  GLY A  67      66.190  51.032  74.512  1.00 24.78           C  
ATOM    456  C   GLY A  67      65.135  51.623  73.591  1.00 25.43           C  
ATOM    457  O   GLY A  67      64.666  50.956  72.663  1.00 22.72           O  
ATOM    458  N   GLU A  68      64.753  52.872  73.841  1.00 25.62           N  
ATOM    459  CA  GLU A  68      63.740  53.514  73.012  1.00 27.63           C  
ATOM    460  C   GLU A  68      64.212  53.689  71.576  1.00 25.28           C  
ATOM    461  O   GLU A  68      63.402  53.739  70.649  1.00 25.67           O  
ATOM    462  CB  GLU A  68      63.338  54.877  73.599  1.00 32.44           C  
ATOM    463  CG  GLU A  68      62.356  55.644  72.717  1.00 39.55           C  
ATOM    464  CD  GLU A  68      61.780  56.881  73.384  1.00 44.95           C  
ATOM    465  OE1 GLU A  68      61.096  56.736  74.423  1.00 46.85           O  
ATOM    466  OE2 GLU A  68      62.007  57.998  72.866  1.00 46.15           O  
ATOM    467  N   ALA A  69      65.525  53.782  71.389  1.00 23.20           N  
ATOM    468  CA  ALA A  69      66.085  53.946  70.054  1.00 20.51           C  
ATOM    469  C   ALA A  69      65.960  52.651  69.258  1.00 19.25           C  
ATOM    470  O   ALA A  69      65.712  52.675  68.051  1.00 16.37           O  
ATOM    471  CB  ALA A  69      67.547  54.370  70.147  1.00 22.17           C  
ATOM    472  N   VAL A  70      66.130  51.517  69.935  1.00 17.78           N  
ATOM    473  CA  VAL A  70      66.020  50.220  69.267  1.00 16.33           C  
ATOM    474  C   VAL A  70      64.575  50.007  68.825  1.00 15.53           C  
ATOM    475  O   VAL A  70      64.307  49.613  67.690  1.00 15.66           O  
ATOM    476  CB  VAL A  70      66.437  49.064  70.201  1.00 16.85           C  
ATOM    477  CG1 VAL A  70      66.274  47.718  69.474  1.00 15.20           C  
ATOM    478  CG2 VAL A  70      67.883  49.258  70.650  1.00 16.83           C  
ATOM    479  N   ARG A  71      63.646  50.277  69.732  1.00 16.86           N  
ATOM    480  CA  ARG A  71      62.228  50.136  69.429  1.00 18.35           C  
ATOM    481  C   ARG A  71      61.863  51.096  68.292  1.00 17.60           C  
ATOM    482  O   ARG A  71      61.066  50.766  67.411  1.00 17.31           O  
ATOM    483  CB  ARG A  71      61.410  50.424  70.692  1.00 17.89           C  
ATOM    484  CG  ARG A  71      61.561  49.327  71.750  1.00 19.52           C  
ATOM    485  CD  ARG A  71      61.238  49.810  73.155  1.00 18.81           C  
ATOM    486  NE  ARG A  71      61.341  48.728  74.130  1.00 18.92           N  
ATOM    487  CZ  ARG A  71      60.427  47.775  74.292  1.00 18.94           C  
ATOM    488  NH1 ARG A  71      59.327  47.765  73.545  1.00 16.46           N  
ATOM    489  NH2 ARG A  71      60.612  46.830  75.202  1.00 16.30           N  
ATOM    490  N   GLY A  72      62.472  52.278  68.309  1.00 18.68           N  
ATOM    491  CA  GLY A  72      62.215  53.264  67.272  1.00 19.01           C  
ATOM    492  C   GLY A  72      62.678  52.778  65.914  1.00 17.77           C  
ATOM    493  O   GLY A  72      62.065  53.089  64.892  1.00 19.34           O  
ATOM    494  N   LEU A  73      63.770  52.017  65.902  1.00 18.52           N  
ATOM    495  CA  LEU A  73      64.316  51.466  64.665  1.00 17.41           C  
ATOM    496  C   LEU A  73      63.260  50.565  64.042  1.00 17.86           C  
ATOM    497  O   LEU A  73      62.940  50.673  62.855  1.00 16.77           O  
ATOM    498  CB  LEU A  73      65.587  50.656  64.957  1.00 16.28           C  
ATOM    499  CG  LEU A  73      66.152  49.821  63.801  1.00 17.93           C  
ATOM    500  CD1 LEU A  73      66.529  50.731  62.643  1.00 14.07           C  
ATOM    501  CD2 LEU A  73      67.364  49.033  64.273  1.00 20.40           C  
ATOM    502  N   VAL A  74      62.719  49.669  64.860  1.00 18.12           N  
ATOM    503  CA  VAL A  74      61.684  48.750  64.410  1.00 17.09           C  
ATOM    504  C   VAL A  74      60.437  49.533  63.988  1.00 18.56           C  
ATOM    505  O   VAL A  74      59.898  49.318  62.902  1.00 18.45           O  
ATOM    506  CB  VAL A  74      61.288  47.761  65.535  1.00 16.68           C  
ATOM    507  CG1 VAL A  74      60.209  46.808  65.036  1.00 14.40           C  
ATOM    508  CG2 VAL A  74      62.511  46.979  65.997  1.00 17.03           C  
ATOM    509  N   ASP A  75      59.984  50.441  64.849  1.00 19.69           N  
ATOM    510  CA  ASP A  75      58.796  51.234  64.550  1.00 22.01           C  
ATOM    511  C   ASP A  75      58.894  51.936  63.201  1.00 23.23           C  
ATOM    512  O   ASP A  75      57.976  51.856  62.385  1.00 23.51           O  
ATOM    513  CB  ASP A  75      58.546  52.284  65.642  1.00 21.91           C  
ATOM    514  CG  ASP A  75      58.123  51.669  66.966  1.00 22.21           C  
ATOM    515  OD1 ASP A  75      57.608  50.530  66.970  1.00 23.22           O  
ATOM    516  OD2 ASP A  75      58.290  52.335  68.005  1.00 23.53           O  
ATOM    517  N   ASN A  76      60.014  52.618  62.971  1.00 24.39           N  
ATOM    518  CA  ASN A  76      60.228  53.356  61.726  1.00 26.25           C  
ATOM    519  C   ASN A  76      60.369  52.444  60.518  1.00 24.76           C  
ATOM    520  O   ASN A  76      59.989  52.805  59.405  1.00 24.87           O  
ATOM    521  CB  ASN A  76      61.469  54.244  61.859  1.00 30.32           C  
ATOM    522  CG  ASN A  76      61.294  55.335  62.907  1.00 35.11           C  
ATOM    523  OD1 ASN A  76      60.824  55.076  64.018  1.00 37.92           O  
ATOM    524  ND2 ASN A  76      61.678  56.560  62.561  1.00 38.97           N  
ATOM    525  N   ALA A  77      60.922  51.258  60.739  1.00 25.09           N  
ATOM    526  CA  ALA A  77      61.097  50.299  59.660  1.00 23.38           C  
ATOM    527  C   ALA A  77      59.723  49.901  59.127  1.00 23.59           C  
ATOM    528  O   ALA A  77      59.514  49.823  57.914  1.00 24.43           O  
ATOM    529  CB  ALA A  77      61.843  49.071  60.164  1.00 23.46           C  
ATOM    530  N   VAL A  78      58.790  49.653  60.039  1.00 22.07           N  
ATOM    531  CA  VAL A  78      57.441  49.274  59.652  1.00 22.14           C  
ATOM    532  C   VAL A  78      56.806  50.427  58.873  1.00 23.40           C  
ATOM    533  O   VAL A  78      56.268  50.226  57.785  1.00 21.97           O  
ATOM    534  CB  VAL A  78      56.568  48.960  60.889  1.00 22.15           C  
ATOM    535  CG1 VAL A  78      55.136  48.676  60.455  1.00 21.17           C  
ATOM    536  CG2 VAL A  78      57.147  47.753  61.648  1.00 22.07           C  
ATOM    537  N   ARG A  79      56.881  51.631  59.433  1.00 23.88           N  
ATOM    538  CA  ARG A  79      56.306  52.811  58.792  1.00 27.06           C  
ATOM    539  C   ARG A  79      56.852  53.085  57.397  1.00 26.59           C  
ATOM    540  O   ARG A  79      56.096  53.432  56.493  1.00 27.72           O  
ATOM    541  CB  ARG A  79      56.519  54.053  59.664  1.00 27.86           C  
ATOM    542  CG  ARG A  79      55.610  54.122  60.880  1.00 32.39           C  
ATOM    543  CD  ARG A  79      55.690  55.491  61.540  1.00 36.21           C  
ATOM    544  NE  ARG A  79      56.885  55.652  62.363  1.00 41.05           N  
ATOM    545  CZ  ARG A  79      57.024  55.146  63.585  1.00 42.91           C  
ATOM    546  NH1 ARG A  79      56.039  54.440  64.131  1.00 43.56           N  
ATOM    547  NH2 ARG A  79      58.142  55.354  64.268  1.00 43.55           N  
ATOM    548  N   GLN A  80      58.160  52.926  57.221  1.00 27.32           N  
ATOM    549  CA  GLN A  80      58.789  53.183  55.931  1.00 27.17           C  
ATOM    550  C   GLN A  80      58.794  51.988  54.986  1.00 28.07           C  
ATOM    551  O   GLN A  80      58.728  52.153  53.764  1.00 25.98           O  
ATOM    552  CB  GLN A  80      60.230  53.659  56.135  1.00 27.78           C  
ATOM    553  CG  GLN A  80      60.361  54.923  56.971  1.00 30.32           C  
ATOM    554  CD  GLN A  80      59.478  56.047  56.462  1.00 31.43           C  
ATOM    555  OE1 GLN A  80      59.500  56.381  55.276  1.00 33.19           O  
ATOM    556  NE2 GLN A  80      58.697  56.638  57.358  1.00 32.31           N  
ATOM    557  N   MET A  81      58.868  50.785  55.548  1.00 27.51           N  
ATOM    558  CA  MET A  81      58.912  49.577  54.731  1.00 28.17           C  
ATOM    559  C   MET A  81      57.571  48.877  54.549  1.00 26.92           C  
ATOM    560  O   MET A  81      57.408  48.079  53.624  1.00 29.24           O  
ATOM    561  CB  MET A  81      59.930  48.597  55.316  1.00 28.45           C  
ATOM    562  CG  MET A  81      61.325  49.178  55.456  1.00 31.23           C  
ATOM    563  SD  MET A  81      61.952  49.894  53.912  1.00 34.41           S  
ATOM    564  CE  MET A  81      62.594  48.448  53.111  1.00 35.53           C  
ATOM    565  N   GLY A  82      56.618  49.167  55.428  1.00 25.41           N  
ATOM    566  CA  GLY A  82      55.303  48.554  55.323  1.00 24.96           C  
ATOM    567  C   GLY A  82      55.074  47.389  56.270  1.00 24.63           C  
ATOM    568  O   GLY A  82      53.933  47.013  56.536  1.00 23.77           O  
ATOM    569  N   ARG A  83      56.158  46.818  56.783  1.00 24.07           N  
ATOM    570  CA  ARG A  83      56.075  45.682  57.693  1.00 24.24           C  
ATOM    571  C   ARG A  83      57.477  45.264  58.118  1.00 22.50           C  
ATOM    572  O   ARG A  83      58.463  45.875  57.715  1.00 22.53           O  
ATOM    573  CB  ARG A  83      55.396  44.504  56.988  1.00 24.70           C  
ATOM    574  CG  ARG A  83      56.151  44.012  55.754  1.00 29.01           C  
ATOM    575  CD  ARG A  83      55.376  42.942  54.998  1.00 31.21           C  
ATOM    576  NE  ARG A  83      55.050  41.800  55.848  1.00 37.34           N  
ATOM    577  CZ  ARG A  83      54.353  40.740  55.449  1.00 39.02           C  
ATOM    578  NH1 ARG A  83      53.905  40.667  54.202  1.00 41.81           N  
ATOM    579  NH2 ARG A  83      54.098  39.753  56.299  1.00 38.50           N  
ATOM    580  N   ILE A  84      57.557  44.230  58.948  1.00 21.05           N  
ATOM    581  CA  ILE A  84      58.845  43.699  59.382  1.00 18.93           C  
ATOM    582  C   ILE A  84      58.714  42.189  59.528  1.00 18.42           C  
ATOM    583  O   ILE A  84      58.232  41.679  60.534  1.00 19.95           O  
ATOM    584  CB  ILE A  84      59.333  44.322  60.715  1.00 18.74           C  
ATOM    585  CG1 ILE A  84      60.643  43.639  61.143  1.00 17.70           C  
ATOM    586  CG2 ILE A  84      58.252  44.210  61.791  1.00 18.92           C  
ATOM    587  CD1 ILE A  84      61.391  44.353  62.256  1.00 13.12           C  
ATOM    588  N   ASP A  85      59.140  41.477  58.495  1.00 18.52           N  
ATOM    589  CA  ASP A  85      59.061  40.029  58.490  1.00 18.59           C  
ATOM    590  C   ASP A  85      60.262  39.389  59.161  1.00 17.31           C  
ATOM    591  O   ASP A  85      60.139  38.355  59.820  1.00 15.27           O  
ATOM    592  CB  ASP A  85      58.969  39.520  57.053  1.00 18.51           C  
ATOM    593  CG  ASP A  85      57.779  40.087  56.316  1.00 20.56           C  
ATOM    594  OD1 ASP A  85      57.954  41.075  55.576  1.00 20.17           O  
ATOM    595  OD2 ASP A  85      56.668  39.547  56.498  1.00 20.41           O  
ATOM    596  N   ILE A  86      61.416  40.028  59.005  1.00 16.31           N  
ATOM    597  CA  ILE A  86      62.668  39.502  59.533  1.00 15.75           C  
ATOM    598  C   ILE A  86      63.444  40.493  60.392  1.00 15.87           C  
ATOM    599  O   ILE A  86      63.685  41.629  59.986  1.00 17.38           O  
ATOM    600  CB  ILE A  86      63.578  39.043  58.350  1.00 15.45           C  
ATOM    601  CG1 ILE A  86      62.824  38.024  57.489  1.00 14.76           C  
ATOM    602  CG2 ILE A  86      64.885  38.481  58.869  1.00 14.65           C  
ATOM    603  CD1 ILE A  86      63.441  37.783  56.118  1.00 14.65           C  
ATOM    604  N   LEU A  87      63.827  40.051  61.585  1.00 13.80           N  
ATOM    605  CA  LEU A  87      64.615  40.872  62.487  1.00 11.95           C  
ATOM    606  C   LEU A  87      65.883  40.107  62.843  1.00 13.48           C  
ATOM    607  O   LEU A  87      65.825  39.030  63.449  1.00 12.64           O  
ATOM    608  CB  LEU A  87      63.846  41.198  63.773  1.00 11.35           C  
ATOM    609  CG  LEU A  87      64.668  41.994  64.803  1.00 10.00           C  
ATOM    610  CD1 LEU A  87      65.087  43.322  64.195  1.00 11.94           C  
ATOM    611  CD2 LEU A  87      63.864  42.227  66.073  1.00  9.82           C  
ATOM    612  N   VAL A  88      67.023  40.657  62.444  1.00 12.84           N  
ATOM    613  CA  VAL A  88      68.311  40.055  62.736  1.00 13.25           C  
ATOM    614  C   VAL A  88      68.995  40.954  63.758  1.00 15.22           C  
ATOM    615  O   VAL A  88      69.408  42.069  63.438  1.00 14.26           O  
ATOM    616  CB  VAL A  88      69.204  39.958  61.471  1.00 12.79           C  
ATOM    617  CG1 VAL A  88      70.507  39.241  61.808  1.00 11.44           C  
ATOM    618  CG2 VAL A  88      68.461  39.217  60.353  1.00  8.83           C  
ATOM    619  N   ASN A  89      69.086  40.480  64.995  1.00 15.16           N  
ATOM    620  CA  ASN A  89      69.734  41.250  66.050  1.00 17.27           C  
ATOM    621  C   ASN A  89      71.192  40.819  66.018  1.00 17.96           C  
ATOM    622  O   ASN A  89      71.551  39.761  66.532  1.00 17.57           O  
ATOM    623  CB  ASN A  89      69.085  40.942  67.400  1.00 16.30           C  
ATOM    624  CG  ASN A  89      67.623  41.348  67.443  1.00 17.67           C  
ATOM    625  OD1 ASN A  89      66.737  40.515  67.654  1.00 17.24           O  
ATOM    626  ND2 ASN A  89      67.362  42.638  67.239  1.00 15.15           N  
ATOM    627  N   ASN A  90      72.025  41.657  65.410  1.00 18.62           N  
ATOM    628  CA  ASN A  90      73.434  41.342  65.225  1.00 19.85           C  
ATOM    629  C   ASN A  90      74.473  42.140  66.003  1.00 21.48           C  
ATOM    630  O   ASN A  90      75.468  41.575  66.461  1.00 21.45           O  
ATOM    631  CB  ASN A  90      73.757  41.430  63.732  1.00 18.84           C  
ATOM    632  CG  ASN A  90      75.228  41.256  63.444  1.00 19.31           C  
ATOM    633  OD1 ASN A  90      75.786  40.177  63.635  1.00 18.73           O  
ATOM    634  ND2 ASN A  90      75.870  42.327  62.989  1.00 17.83           N  
ATOM    635  N   ALA A  91      74.251  43.444  66.144  1.00 21.70           N  
ATOM    636  CA  ALA A  91      75.202  44.313  66.836  1.00 23.72           C  
ATOM    637  C   ALA A  91      75.768  43.743  68.136  1.00 24.43           C  
ATOM    638  O   ALA A  91      75.054  43.119  68.922  1.00 24.41           O  
ATOM    639  CB  ALA A  91      74.563  45.668  67.104  1.00 24.30           C  
ATOM    640  N   GLY A  92      77.062  43.970  68.349  1.00 26.50           N  
ATOM    641  CA  GLY A  92      77.727  43.501  69.552  1.00 26.55           C  
ATOM    642  C   GLY A  92      79.055  44.209  69.785  1.00 27.87           C  
ATOM    643  O   GLY A  92      79.594  44.858  68.882  1.00 27.46           O  
ATOM    644  N   ILE A  93      79.577  44.097  71.006  1.00 25.86           N  
ATOM    645  CA  ILE A  93      80.861  44.698  71.370  1.00 24.87           C  
ATOM    646  C   ILE A  93      81.534  43.826  72.422  1.00 23.50           C  
ATOM    647  O   ILE A  93      80.861  43.060  73.116  1.00 20.95           O  
ATOM    648  CB  ILE A  93      80.693  46.116  71.952  1.00 25.02           C  
ATOM    649  CG1 ILE A  93      79.740  46.081  73.149  1.00 25.93           C  
ATOM    650  CG2 ILE A  93      80.193  47.059  70.874  1.00 27.16           C  
ATOM    651  CD1 ILE A  93      79.579  47.418  73.854  1.00 28.26           C  
ATOM    652  N   GLN A  94      82.853  43.947  72.547  1.00 22.95           N  
ATOM    653  CA  GLN A  94      83.590  43.142  73.512  1.00 23.68           C  
ATOM    654  C   GLN A  94      84.642  43.903  74.299  1.00 22.73           C  
ATOM    655  O   GLN A  94      84.966  45.049  73.997  1.00 24.10           O  
ATOM    656  CB  GLN A  94      84.297  41.978  72.814  1.00 27.10           C  
ATOM    657  CG  GLN A  94      83.406  41.089  71.987  1.00 30.71           C  
ATOM    658  CD  GLN A  94      84.105  39.814  71.564  1.00 32.98           C  
ATOM    659  OE1 GLN A  94      84.524  39.012  72.405  1.00 31.63           O  
ATOM    660  NE2 GLN A  94      84.241  39.620  70.255  1.00 35.66           N  
ATOM    661  N   HIS A  95      85.165  43.226  75.316  1.00 20.77           N  
ATOM    662  CA  HIS A  95      86.223  43.743  76.179  1.00 21.14           C  
ATOM    663  C   HIS A  95      86.829  42.554  76.908  1.00 18.79           C  
ATOM    664  O   HIS A  95      86.102  41.701  77.411  1.00 18.06           O  
ATOM    665  CB  HIS A  95      85.688  44.724  77.217  1.00 21.44           C  
ATOM    666  CG  HIS A  95      86.754  45.276  78.115  1.00 22.91           C  
ATOM    667  ND1 HIS A  95      87.710  46.166  77.674  1.00 23.95           N  
ATOM    668  CD2 HIS A  95      87.046  45.024  79.413  1.00 23.35           C  
ATOM    669  CE1 HIS A  95      88.546  46.437  78.660  1.00 24.41           C  
ATOM    670  NE2 HIS A  95      88.165  45.756  79.727  1.00 25.67           N  
ATOM    671  N   THR A  96      88.156  42.504  76.966  1.00 18.49           N  
ATOM    672  CA  THR A  96      88.856  41.408  77.631  1.00 19.22           C  
ATOM    673  C   THR A  96      89.550  41.872  78.916  1.00 19.45           C  
ATOM    674  O   THR A  96      90.267  42.872  78.916  1.00 17.83           O  
ATOM    675  CB  THR A  96      89.931  40.781  76.704  1.00 20.20           C  
ATOM    676  OG1 THR A  96      89.328  40.364  75.472  1.00 20.65           O  
ATOM    677  CG2 THR A  96      90.573  39.572  77.375  1.00 19.18           C  
ATOM    678  N   ALA A  97      89.334  41.133  80.000  1.00 17.36           N  
ATOM    679  CA  ALA A  97      89.941  41.435  81.294  1.00 18.24           C  
ATOM    680  C   ALA A  97      89.489  40.392  82.310  1.00 17.35           C  
ATOM    681  O   ALA A  97      88.462  39.742  82.118  1.00 17.84           O  
ATOM    682  CB  ALA A  97      89.529  42.829  81.763  1.00 18.09           C  
ATOM    683  N   LEU A  98      90.266  40.211  83.374  1.00 16.65           N  
ATOM    684  CA  LEU A  98      89.883  39.264  84.419  1.00 16.04           C  
ATOM    685  C   LEU A  98      88.638  39.850  85.051  1.00 16.38           C  
ATOM    686  O   LEU A  98      88.438  41.066  85.018  1.00 13.98           O  
ATOM    687  CB  LEU A  98      90.971  39.141  85.491  1.00 15.36           C  
ATOM    688  CG  LEU A  98      92.256  38.407  85.094  1.00 16.92           C  
ATOM    689  CD1 LEU A  98      93.276  38.511  86.220  1.00 15.96           C  
ATOM    690  CD2 LEU A  98      91.937  36.953  84.784  1.00 17.86           C  
ATOM    691  N   ILE A  99      87.801  38.997  85.630  1.00 15.83           N  
ATOM    692  CA  ILE A  99      86.578  39.470  86.256  1.00 15.79           C  
ATOM    693  C   ILE A  99      86.836  40.605  87.239  1.00 16.75           C  
ATOM    694  O   ILE A  99      86.144  41.630  87.206  1.00 17.37           O  
ATOM    695  CB  ILE A  99      85.837  38.313  86.976  1.00 16.20           C  
ATOM    696  CG1 ILE A  99      85.215  37.379  85.933  1.00 13.86           C  
ATOM    697  CG2 ILE A  99      84.759  38.868  87.902  1.00 16.93           C  
ATOM    698  CD1 ILE A  99      84.640  36.097  86.507  1.00 15.02           C  
ATOM    699  N   GLU A 100      87.838  40.441  88.100  1.00 16.39           N  
ATOM    700  CA  GLU A 100      88.133  41.466  89.095  1.00 16.86           C  
ATOM    701  C   GLU A 100      88.665  42.761  88.494  1.00 16.79           C  
ATOM    702  O   GLU A 100      88.679  43.794  89.163  1.00 17.53           O  
ATOM    703  CB  GLU A 100      89.134  40.944  90.126  1.00 16.93           C  
ATOM    704  CG  GLU A 100      90.442  40.476  89.525  1.00 16.66           C  
ATOM    705  CD  GLU A 100      90.486  38.969  89.357  1.00 19.16           C  
ATOM    706  OE1 GLU A 100      89.508  38.394  88.821  1.00 15.94           O  
ATOM    707  OE2 GLU A 100      91.504  38.364  89.761  1.00 17.50           O  
ATOM    708  N   ASP A 101      89.109  42.705  87.240  1.00 16.50           N  
ATOM    709  CA  ASP A 101      89.633  43.889  86.567  1.00 18.73           C  
ATOM    710  C   ASP A 101      88.651  44.437  85.537  1.00 18.04           C  
ATOM    711  O   ASP A 101      88.942  45.420  84.858  1.00 17.76           O  
ATOM    712  CB  ASP A 101      90.949  43.574  85.846  1.00 20.38           C  
ATOM    713  CG  ASP A 101      92.039  43.091  86.784  1.00 21.48           C  
ATOM    714  OD1 ASP A 101      92.170  43.653  87.888  1.00 23.80           O  
ATOM    715  OD2 ASP A 101      92.779  42.155  86.408  1.00 23.34           O  
ATOM    716  N   PHE A 102      87.492  43.804  85.413  1.00 16.21           N  
ATOM    717  CA  PHE A 102      86.507  44.240  84.430  1.00 14.85           C  
ATOM    718  C   PHE A 102      85.775  45.505  84.858  1.00 15.89           C  
ATOM    719  O   PHE A 102      85.047  45.502  85.848  1.00 14.19           O  
ATOM    720  CB  PHE A 102      85.484  43.131  84.188  1.00 16.02           C  
ATOM    721  CG  PHE A 102      85.031  43.033  82.765  1.00 13.81           C  
ATOM    722  CD1 PHE A 102      85.530  42.032  81.927  1.00 15.12           C  
ATOM    723  CD2 PHE A 102      84.103  43.932  82.256  1.00 14.01           C  
ATOM    724  CE1 PHE A 102      85.105  41.928  80.600  1.00 14.10           C  
ATOM    725  CE2 PHE A 102      83.672  43.840  80.934  1.00 13.22           C  
ATOM    726  CZ  PHE A 102      84.174  42.834  80.104  1.00 15.20           C  
ATOM    727  N   PRO A 103      85.950  46.605  84.109  1.00 16.96           N  
ATOM    728  CA  PRO A 103      85.287  47.870  84.440  1.00 17.21           C  
ATOM    729  C   PRO A 103      83.765  47.714  84.464  1.00 18.44           C  
ATOM    730  O   PRO A 103      83.180  47.138  83.542  1.00 16.72           O  
ATOM    731  CB  PRO A 103      85.746  48.803  83.319  1.00 18.35           C  
ATOM    732  CG  PRO A 103      87.097  48.243  82.935  1.00 17.40           C  
ATOM    733  CD  PRO A 103      86.825  46.762  82.933  1.00 19.04           C  
ATOM    734  N   THR A 104      83.126  48.221  85.514  1.00 17.22           N  
ATOM    735  CA  THR A 104      81.677  48.126  85.602  1.00 18.89           C  
ATOM    736  C   THR A 104      81.048  48.770  84.373  1.00 18.47           C  
ATOM    737  O   THR A 104      80.050  48.280  83.848  1.00 18.83           O  
ATOM    738  CB  THR A 104      81.139  48.821  86.864  1.00 17.75           C  
ATOM    739  OG1 THR A 104      81.592  48.114  88.022  1.00 18.69           O  
ATOM    740  CG2 THR A 104      79.614  48.836  86.861  1.00 19.83           C  
ATOM    741  N   GLU A 105      81.650  49.860  83.901  1.00 18.93           N  
ATOM    742  CA  GLU A 105      81.135  50.564  82.735  1.00 20.79           C  
ATOM    743  C   GLU A 105      81.116  49.674  81.506  1.00 19.58           C  
ATOM    744  O   GLU A 105      80.170  49.718  80.720  1.00 18.69           O  
ATOM    745  CB  GLU A 105      81.968  51.818  82.459  1.00 25.42           C  
ATOM    746  CG  GLU A 105      81.849  52.878  83.546  1.00 32.00           C  
ATOM    747  CD  GLU A 105      82.490  52.461  84.867  1.00 36.93           C  
ATOM    748  OE1 GLU A 105      82.220  53.132  85.890  1.00 40.26           O  
ATOM    749  OE2 GLU A 105      83.268  51.479  84.884  1.00 36.12           O  
ATOM    750  N   LYS A 106      82.165  48.871  81.340  1.00 19.19           N  
ATOM    751  CA  LYS A 106      82.268  47.955  80.205  1.00 18.89           C  
ATOM    752  C   LYS A 106      81.244  46.830  80.350  1.00 17.22           C  
ATOM    753  O   LYS A 106      80.612  46.418  79.377  1.00 16.01           O  
ATOM    754  CB  LYS A 106      83.679  47.365  80.123  1.00 22.16           C  
ATOM    755  CG  LYS A 106      84.751  48.369  79.702  1.00 28.83           C  
ATOM    756  CD  LYS A 106      84.525  48.878  78.275  1.00 31.15           C  
ATOM    757  CE  LYS A 106      84.591  47.738  77.266  1.00 34.18           C  
ATOM    758  NZ  LYS A 106      84.562  48.195  75.845  1.00 36.82           N  
ATOM    759  N   TRP A 107      81.096  46.333  81.572  1.00 15.27           N  
ATOM    760  CA  TRP A 107      80.136  45.273  81.847  1.00 16.02           C  
ATOM    761  C   TRP A 107      78.736  45.740  81.473  1.00 16.53           C  
ATOM    762  O   TRP A 107      78.005  45.027  80.782  1.00 16.11           O  
ATOM    763  CB  TRP A 107      80.183  44.875  83.330  1.00 12.05           C  
ATOM    764  CG  TRP A 107      79.026  44.003  83.761  1.00 12.79           C  
ATOM    765  CD1 TRP A 107      77.796  44.421  84.183  1.00 11.29           C  
ATOM    766  CD2 TRP A 107      78.972  42.564  83.741  1.00 12.53           C  
ATOM    767  NE1 TRP A 107      76.979  43.340  84.421  1.00 12.35           N  
ATOM    768  CE2 TRP A 107      77.677  42.188  84.159  1.00 11.27           C  
ATOM    769  CE3 TRP A 107      79.893  41.560  83.408  1.00 12.57           C  
ATOM    770  CZ2 TRP A 107      77.276  40.848  84.253  1.00 10.98           C  
ATOM    771  CZ3 TRP A 107      79.490  40.220  83.503  1.00 10.87           C  
ATOM    772  CH2 TRP A 107      78.194  39.884  83.922  1.00 10.17           C  
ATOM    773  N   ASP A 108      78.373  46.944  81.913  1.00 16.45           N  
ATOM    774  CA  ASP A 108      77.051  47.494  81.628  1.00 16.86           C  
ATOM    775  C   ASP A 108      76.821  47.723  80.142  1.00 15.13           C  
ATOM    776  O   ASP A 108      75.726  47.483  79.634  1.00 14.75           O  
ATOM    777  CB  ASP A 108      76.826  48.833  82.348  1.00 17.74           C  
ATOM    778  CG  ASP A 108      76.736  48.695  83.853  1.00 18.63           C  
ATOM    779  OD1 ASP A 108      76.494  47.578  84.360  1.00 20.84           O  
ATOM    780  OD2 ASP A 108      76.893  49.727  84.538  1.00 20.34           O  
ATOM    781  N   ALA A 109      77.854  48.201  79.455  1.00 16.50           N  
ATOM    782  CA  ALA A 109      77.756  48.499  78.028  1.00 14.92           C  
ATOM    783  C   ALA A 109      77.604  47.248  77.171  1.00 15.41           C  
ATOM    784  O   ALA A 109      76.858  47.243  76.185  1.00 14.51           O  
ATOM    785  CB  ALA A 109      78.986  49.297  77.575  1.00 17.75           C  
ATOM    786  N   ILE A 110      78.323  46.191  77.533  1.00 13.97           N  
ATOM    787  CA  ILE A 110      78.248  44.949  76.779  1.00 14.06           C  
ATOM    788  C   ILE A 110      76.874  44.310  76.952  1.00 14.45           C  
ATOM    789  O   ILE A 110      76.300  43.789  75.996  1.00 15.29           O  
ATOM    790  CB  ILE A 110      79.370  43.975  77.217  1.00 15.48           C  
ATOM    791  CG1 ILE A 110      80.719  44.508  76.717  1.00 16.32           C  
ATOM    792  CG2 ILE A 110      79.098  42.566  76.687  1.00 14.82           C  
ATOM    793  CD1 ILE A 110      81.938  43.724  77.213  1.00 15.12           C  
ATOM    794  N   LEU A 111      76.339  44.358  78.168  1.00 13.52           N  
ATOM    795  CA  LEU A 111      75.020  43.786  78.418  1.00 14.89           C  
ATOM    796  C   LEU A 111      73.930  44.584  77.713  1.00 13.85           C  
ATOM    797  O   LEU A 111      72.981  44.015  77.180  1.00 12.68           O  
ATOM    798  CB  LEU A 111      74.728  43.737  79.919  1.00 13.78           C  
ATOM    799  CG  LEU A 111      75.119  42.449  80.654  1.00 14.43           C  
ATOM    800  CD1 LEU A 111      76.594  42.148  80.464  1.00 16.17           C  
ATOM    801  CD2 LEU A 111      74.789  42.598  82.128  1.00 16.32           C  
ATOM    802  N   ALA A 112      74.071  45.904  77.698  1.00 15.58           N  
ATOM    803  CA  ALA A 112      73.067  46.744  77.060  1.00 14.43           C  
ATOM    804  C   ALA A 112      72.957  46.491  75.570  1.00 13.83           C  
ATOM    805  O   ALA A 112      71.857  46.343  75.039  1.00 14.75           O  
ATOM    806  CB  ALA A 112      73.370  48.224  77.316  1.00 15.39           C  
ATOM    807  N   LEU A 113      74.098  46.440  74.896  1.00 14.41           N  
ATOM    808  CA  LEU A 113      74.109  46.241  73.451  1.00 14.95           C  
ATOM    809  C   LEU A 113      73.955  44.796  73.005  1.00 14.14           C  
ATOM    810  O   LEU A 113      73.179  44.500  72.102  1.00 14.75           O  
ATOM    811  CB  LEU A 113      75.398  46.804  72.848  1.00 15.33           C  
ATOM    812  CG  LEU A 113      75.540  46.659  71.328  1.00 18.49           C  
ATOM    813  CD1 LEU A 113      74.393  47.383  70.631  1.00 18.63           C  
ATOM    814  CD2 LEU A 113      76.875  47.234  70.881  1.00 17.92           C  
ATOM    815  N   ASN A 114      74.693  43.900  73.647  1.00 14.21           N  
ATOM    816  CA  ASN A 114      74.668  42.493  73.275  1.00 13.76           C  
ATOM    817  C   ASN A 114      73.440  41.725  73.741  1.00 12.56           C  
ATOM    818  O   ASN A 114      73.080  40.710  73.152  1.00 11.42           O  
ATOM    819  CB  ASN A 114      75.938  41.815  73.792  1.00 16.10           C  
ATOM    820  CG  ASN A 114      77.200  42.461  73.247  1.00 20.18           C  
ATOM    821  OD1 ASN A 114      77.327  43.689  73.236  1.00 23.04           O  
ATOM    822  ND2 ASN A 114      78.140  41.641  72.800  1.00 19.59           N  
ATOM    823  N   LEU A 115      72.786  42.206  74.789  1.00 12.88           N  
ATOM    824  CA  LEU A 115      71.623  41.502  75.297  1.00 12.55           C  
ATOM    825  C   LEU A 115      70.344  42.323  75.350  1.00 12.00           C  
ATOM    826  O   LEU A 115      69.328  41.934  74.778  1.00 12.35           O  
ATOM    827  CB  LEU A 115      71.929  40.931  76.694  1.00 12.37           C  
ATOM    828  CG  LEU A 115      70.778  40.220  77.413  1.00  9.95           C  
ATOM    829  CD1 LEU A 115      70.274  39.040  76.575  1.00 10.15           C  
ATOM    830  CD2 LEU A 115      71.263  39.743  78.776  1.00 11.55           C  
ATOM    831  N   SER A 116      70.379  43.462  76.031  1.00 12.21           N  
ATOM    832  CA  SER A 116      69.167  44.256  76.142  1.00 12.29           C  
ATOM    833  C   SER A 116      68.639  44.727  74.789  1.00 12.18           C  
ATOM    834  O   SER A 116      67.431  44.828  74.599  1.00 12.78           O  
ATOM    835  CB  SER A 116      69.395  45.428  77.096  1.00 10.90           C  
ATOM    836  OG  SER A 116      69.577  44.944  78.416  1.00 11.55           O  
ATOM    837  N   ALA A 117      69.536  44.981  73.842  1.00 12.46           N  
ATOM    838  CA  ALA A 117      69.120  45.422  72.513  1.00 13.10           C  
ATOM    839  C   ALA A 117      68.232  44.372  71.838  1.00 14.74           C  
ATOM    840  O   ALA A 117      67.285  44.710  71.116  1.00 14.01           O  
ATOM    841  CB  ALA A 117      70.347  45.700  71.651  1.00 10.99           C  
ATOM    842  N   VAL A 118      68.549  43.099  72.068  1.00 13.40           N  
ATOM    843  CA  VAL A 118      67.783  41.992  71.491  1.00 11.39           C  
ATOM    844  C   VAL A 118      66.362  41.987  72.064  1.00 11.76           C  
ATOM    845  O   VAL A 118      65.394  41.691  71.360  1.00 11.66           O  
ATOM    846  CB  VAL A 118      68.454  40.628  71.795  1.00  9.76           C  
ATOM    847  CG1 VAL A 118      67.628  39.495  71.216  1.00 10.25           C  
ATOM    848  CG2 VAL A 118      69.874  40.599  71.224  1.00 11.53           C  
ATOM    849  N   PHE A 119      66.249  42.313  73.347  1.00 11.14           N  
ATOM    850  CA  PHE A 119      64.959  42.367  74.023  1.00 12.94           C  
ATOM    851  C   PHE A 119      64.100  43.524  73.473  1.00 12.96           C  
ATOM    852  O   PHE A 119      62.945  43.329  73.076  1.00 11.14           O  
ATOM    853  CB  PHE A 119      65.179  42.540  75.531  1.00 13.38           C  
ATOM    854  CG  PHE A 119      64.009  43.145  76.246  1.00 15.50           C  
ATOM    855  CD1 PHE A 119      62.772  42.503  76.251  1.00 15.99           C  
ATOM    856  CD2 PHE A 119      64.133  44.376  76.881  1.00 13.27           C  
ATOM    857  CE1 PHE A 119      61.670  43.079  76.874  1.00 16.85           C  
ATOM    858  CE2 PHE A 119      63.037  44.965  77.509  1.00 14.89           C  
ATOM    859  CZ  PHE A 119      61.799  44.314  77.505  1.00 16.90           C  
ATOM    860  N   HIS A 120      64.672  44.722  73.445  1.00 13.06           N  
ATOM    861  CA  HIS A 120      63.952  45.890  72.945  1.00 13.22           C  
ATOM    862  C   HIS A 120      63.540  45.722  71.492  1.00 12.45           C  
ATOM    863  O   HIS A 120      62.420  46.068  71.114  1.00 13.85           O  
ATOM    864  CB  HIS A 120      64.814  47.143  73.106  1.00 14.61           C  
ATOM    865  CG  HIS A 120      65.045  47.529  74.533  1.00 12.63           C  
ATOM    866  ND1 HIS A 120      64.017  47.865  75.386  1.00 15.03           N  
ATOM    867  CD2 HIS A 120      66.183  47.625  75.260  1.00 13.90           C  
ATOM    868  CE1 HIS A 120      64.510  48.153  76.577  1.00 12.35           C  
ATOM    869  NE2 HIS A 120      65.822  48.015  76.527  1.00 12.96           N  
ATOM    870  N   GLY A 121      64.441  45.181  70.678  1.00 13.17           N  
ATOM    871  CA  GLY A 121      64.133  44.973  69.277  1.00 13.33           C  
ATOM    872  C   GLY A 121      63.052  43.920  69.103  1.00 14.20           C  
ATOM    873  O   GLY A 121      62.124  44.093  68.316  1.00 13.49           O  
ATOM    874  N   THR A 122      63.161  42.827  69.849  1.00 14.44           N  
ATOM    875  CA  THR A 122      62.177  41.753  69.764  1.00 15.15           C  
ATOM    876  C   THR A 122      60.797  42.246  70.189  1.00 15.19           C  
ATOM    877  O   THR A 122      59.798  42.015  69.495  1.00 16.68           O  
ATOM    878  CB  THR A 122      62.599  40.554  70.652  1.00 15.76           C  
ATOM    879  OG1 THR A 122      63.790  39.956  70.113  1.00 16.46           O  
ATOM    880  CG2 THR A 122      61.499  39.507  70.707  1.00 15.85           C  
ATOM    881  N   ALA A 123      60.749  42.942  71.322  1.00 13.81           N  
ATOM    882  CA  ALA A 123      59.498  43.467  71.860  1.00 14.03           C  
ATOM    883  C   ALA A 123      58.746  44.353  70.873  1.00 15.07           C  
ATOM    884  O   ALA A 123      57.532  44.247  70.746  1.00 16.57           O  
ATOM    885  CB  ALA A 123      59.771  44.241  73.150  1.00 13.59           C  
ATOM    886  N   ALA A 124      59.465  45.228  70.176  1.00 14.34           N  
ATOM    887  CA  ALA A 124      58.834  46.126  69.211  1.00 13.82           C  
ATOM    888  C   ALA A 124      58.377  45.389  67.956  1.00 12.50           C  
ATOM    889  O   ALA A 124      57.394  45.766  67.322  1.00 14.37           O  
ATOM    890  CB  ALA A 124      59.806  47.251  68.833  1.00 10.81           C  
ATOM    891  N   ALA A 125      59.084  44.326  67.601  1.00 13.36           N  
ATOM    892  CA  ALA A 125      58.746  43.576  66.401  1.00 13.32           C  
ATOM    893  C   ALA A 125      57.613  42.569  66.558  1.00 14.44           C  
ATOM    894  O   ALA A 125      56.813  42.387  65.640  1.00 15.89           O  
ATOM    895  CB  ALA A 125      59.985  42.866  65.882  1.00 15.31           C  
ATOM    896  N   LEU A 126      57.530  41.922  67.716  1.00 14.05           N  
ATOM    897  CA  LEU A 126      56.519  40.885  67.920  1.00 15.19           C  
ATOM    898  C   LEU A 126      55.059  41.216  67.603  1.00 14.43           C  
ATOM    899  O   LEU A 126      54.370  40.408  66.979  1.00 16.58           O  
ATOM    900  CB  LEU A 126      56.637  40.311  69.340  1.00 14.63           C  
ATOM    901  CG  LEU A 126      57.916  39.483  69.532  1.00 13.99           C  
ATOM    902  CD1 LEU A 126      58.044  38.999  70.976  1.00 12.62           C  
ATOM    903  CD2 LEU A 126      57.887  38.317  68.570  1.00 15.66           C  
ATOM    904  N   PRO A 127      54.564  42.391  68.022  1.00 14.20           N  
ATOM    905  CA  PRO A 127      53.167  42.735  67.730  1.00 15.19           C  
ATOM    906  C   PRO A 127      52.866  42.720  66.231  1.00 15.40           C  
ATOM    907  O   PRO A 127      51.791  42.289  65.809  1.00 15.66           O  
ATOM    908  CB  PRO A 127      53.022  44.126  68.342  1.00 16.44           C  
ATOM    909  CG  PRO A 127      53.976  44.069  69.506  1.00 15.66           C  
ATOM    910  CD  PRO A 127      55.181  43.404  68.895  1.00 13.76           C  
ATOM    911  N   HIS A 128      53.827  43.177  65.432  1.00 17.45           N  
ATOM    912  CA  HIS A 128      53.662  43.219  63.980  1.00 16.55           C  
ATOM    913  C   HIS A 128      53.739  41.809  63.400  1.00 16.23           C  
ATOM    914  O   HIS A 128      52.943  41.427  62.544  1.00 16.23           O  
ATOM    915  CB  HIS A 128      54.754  44.085  63.344  1.00 17.69           C  
ATOM    916  CG  HIS A 128      54.830  45.474  63.900  1.00 20.01           C  
ATOM    917  ND1 HIS A 128      53.855  46.423  63.679  1.00 21.50           N  
ATOM    918  CD2 HIS A 128      55.758  46.066  64.687  1.00 19.69           C  
ATOM    919  CE1 HIS A 128      54.178  47.539  64.305  1.00 20.59           C  
ATOM    920  NE2 HIS A 128      55.328  47.349  64.926  1.00 20.95           N  
ATOM    921  N   MET A 129      54.702  41.029  63.867  1.00 15.50           N  
ATOM    922  CA  MET A 129      54.844  39.677  63.355  1.00 14.85           C  
ATOM    923  C   MET A 129      53.633  38.808  63.697  1.00 13.54           C  
ATOM    924  O   MET A 129      53.178  38.021  62.872  1.00 15.20           O  
ATOM    925  CB  MET A 129      56.120  39.043  63.900  1.00 12.92           C  
ATOM    926  CG  MET A 129      57.373  39.811  63.546  1.00 14.76           C  
ATOM    927  SD  MET A 129      58.863  38.981  64.131  1.00 14.26           S  
ATOM    928  CE  MET A 129      60.111  39.584  62.948  1.00  9.75           C  
ATOM    929  N   LYS A 130      53.112  38.946  64.911  1.00 13.30           N  
ATOM    930  CA  LYS A 130      51.951  38.153  65.300  1.00 14.84           C  
ATOM    931  C   LYS A 130      50.727  38.534  64.468  1.00 17.45           C  
ATOM    932  O   LYS A 130      49.929  37.674  64.093  1.00 16.15           O  
ATOM    933  CB  LYS A 130      51.667  38.323  66.793  1.00 14.36           C  
ATOM    934  CG  LYS A 130      52.757  37.731  67.674  1.00 10.66           C  
ATOM    935  CD  LYS A 130      52.400  37.798  69.141  1.00 14.23           C  
ATOM    936  CE  LYS A 130      53.525  37.215  69.992  1.00 11.07           C  
ATOM    937  NZ  LYS A 130      53.189  37.248  71.437  1.00 13.28           N  
ATOM    938  N   LYS A 131      50.592  39.824  64.166  1.00 18.55           N  
ATOM    939  CA  LYS A 131      49.471  40.292  63.356  1.00 20.80           C  
ATOM    940  C   LYS A 131      49.602  39.855  61.901  1.00 20.00           C  
ATOM    941  O   LYS A 131      48.604  39.513  61.265  1.00 21.15           O  
ATOM    942  CB  LYS A 131      49.361  41.817  63.430  1.00 23.28           C  
ATOM    943  CG  LYS A 131      48.458  42.310  64.541  1.00 28.14           C  
ATOM    944  CD  LYS A 131      47.008  41.929  64.259  1.00 31.72           C  
ATOM    945  CE  LYS A 131      46.060  42.542  65.275  1.00 33.86           C  
ATOM    946  NZ  LYS A 131      44.633  42.340  64.889  1.00 35.87           N  
ATOM    947  N   GLN A 132      50.830  39.860  61.384  1.00 19.57           N  
ATOM    948  CA  GLN A 132      51.107  39.457  59.999  1.00 20.83           C  
ATOM    949  C   GLN A 132      50.969  37.947  59.816  1.00 21.92           C  
ATOM    950  O   GLN A 132      50.719  37.468  58.707  1.00 22.71           O  
ATOM    951  CB  GLN A 132      52.542  39.823  59.593  1.00 22.40           C  
ATOM    952  CG  GLN A 132      52.960  41.280  59.754  1.00 23.02           C  
ATOM    953  CD  GLN A 132      54.491  41.444  59.752  1.00 25.55           C  
ATOM    954  OE1 GLN A 132      55.012  42.564  59.848  1.00 21.05           O  
ATOM    955  NE2 GLN A 132      55.213  40.319  59.650  1.00 18.36           N  
ATOM    956  N   GLY A 133      51.160  37.197  60.895  1.00 20.35           N  
ATOM    957  CA  GLY A 133      51.080  35.751  60.794  1.00 19.64           C  
ATOM    958  C   GLY A 133      52.395  35.198  60.273  1.00 18.77           C  
ATOM    959  O   GLY A 133      52.484  34.035  59.879  1.00 17.74           O  
ATOM    960  N   PHE A 134      53.419  36.046  60.251  1.00 16.86           N  
ATOM    961  CA  PHE A 134      54.742  35.640  59.786  1.00 17.49           C  
ATOM    962  C   PHE A 134      55.846  36.383  60.519  1.00 16.85           C  
ATOM    963  O   PHE A 134      55.754  37.588  60.760  1.00 14.31           O  
ATOM    964  CB  PHE A 134      54.920  35.885  58.283  1.00 18.53           C  
ATOM    965  CG  PHE A 134      56.242  35.389  57.754  1.00 18.66           C  
ATOM    966  CD1 PHE A 134      56.402  34.058  57.379  1.00 18.37           C  
ATOM    967  CD2 PHE A 134      57.348  36.234  57.704  1.00 17.82           C  
ATOM    968  CE1 PHE A 134      57.642  33.575  56.968  1.00 18.99           C  
ATOM    969  CE2 PHE A 134      58.594  35.760  57.294  1.00 18.33           C  
ATOM    970  CZ  PHE A 134      58.742  34.429  56.927  1.00 17.07           C  
ATOM    971  N   GLY A 135      56.902  35.656  60.862  1.00 17.93           N  
ATOM    972  CA  GLY A 135      58.006  36.276  61.563  1.00 16.68           C  
ATOM    973  C   GLY A 135      59.214  35.376  61.696  1.00 17.02           C  
ATOM    974  O   GLY A 135      59.093  34.170  61.911  1.00 15.94           O  
ATOM    975  N   ARG A 136      60.388  35.980  61.548  1.00 17.17           N  
ATOM    976  CA  ARG A 136      61.658  35.285  61.668  1.00 16.51           C  
ATOM    977  C   ARG A 136      62.607  36.177  62.450  1.00 16.51           C  
ATOM    978  O   ARG A 136      63.095  37.186  61.931  1.00 18.36           O  
ATOM    979  CB  ARG A 136      62.267  35.005  60.290  1.00 15.64           C  
ATOM    980  CG  ARG A 136      61.553  33.957  59.464  1.00 15.56           C  
ATOM    981  CD  ARG A 136      61.898  32.552  59.940  1.00 16.54           C  
ATOM    982  NE  ARG A 136      61.372  31.543  59.029  1.00 18.05           N  
ATOM    983  CZ  ARG A 136      60.081  31.244  58.919  1.00 17.88           C  
ATOM    984  NH1 ARG A 136      59.188  31.874  59.668  1.00 15.83           N  
ATOM    985  NH2 ARG A 136      59.687  30.321  58.055  1.00 18.20           N  
ATOM    986  N   ILE A 137      62.839  35.832  63.709  1.00 15.71           N  
ATOM    987  CA  ILE A 137      63.770  36.584  64.527  1.00 13.95           C  
ATOM    988  C   ILE A 137      65.035  35.738  64.573  1.00 14.56           C  
ATOM    989  O   ILE A 137      65.013  34.572  64.980  1.00 12.96           O  
ATOM    990  CB  ILE A 137      63.235  36.825  65.953  1.00 15.53           C  
ATOM    991  CG1 ILE A 137      61.981  37.705  65.894  1.00 16.76           C  
ATOM    992  CG2 ILE A 137      64.296  37.523  66.796  1.00 13.18           C  
ATOM    993  CD1 ILE A 137      61.329  37.929  67.239  1.00 20.50           C  
ATOM    994  N   ILE A 138      66.133  36.330  64.120  1.00 13.62           N  
ATOM    995  CA  ILE A 138      67.414  35.649  64.076  1.00 13.82           C  
ATOM    996  C   ILE A 138      68.423  36.449  64.888  1.00 14.71           C  
ATOM    997  O   ILE A 138      68.840  37.541  64.490  1.00 12.90           O  
ATOM    998  CB  ILE A 138      67.899  35.508  62.618  1.00 13.60           C  
ATOM    999  CG1 ILE A 138      66.822  34.798  61.794  1.00 12.83           C  
ATOM   1000  CG2 ILE A 138      69.213  34.734  62.569  1.00 13.79           C  
ATOM   1001  CD1 ILE A 138      67.053  34.852  60.292  1.00 14.89           C  
ATOM   1002  N   ASN A 139      68.794  35.898  66.040  1.00 13.05           N  
ATOM   1003  CA  ASN A 139      69.741  36.539  66.930  1.00 12.24           C  
ATOM   1004  C   ASN A 139      71.144  36.019  66.665  1.00 12.42           C  
ATOM   1005  O   ASN A 139      71.385  34.806  66.681  1.00 13.08           O  
ATOM   1006  CB  ASN A 139      69.336  36.282  68.385  1.00 12.33           C  
ATOM   1007  CG  ASN A 139      67.985  36.900  68.728  1.00 13.26           C  
ATOM   1008  OD1 ASN A 139      67.276  36.432  69.618  1.00 12.07           O  
ATOM   1009  ND2 ASN A 139      67.630  37.966  68.017  1.00 10.18           N  
ATOM   1010  N   ILE A 140      72.066  36.936  66.394  1.00 11.49           N  
ATOM   1011  CA  ILE A 140      73.445  36.546  66.141  1.00 12.32           C  
ATOM   1012  C   ILE A 140      74.128  36.485  67.499  1.00 14.05           C  
ATOM   1013  O   ILE A 140      74.567  37.506  68.032  1.00 14.16           O  
ATOM   1014  CB  ILE A 140      74.181  37.566  65.238  1.00 13.30           C  
ATOM   1015  CG1 ILE A 140      73.419  37.749  63.912  1.00 10.26           C  
ATOM   1016  CG2 ILE A 140      75.610  37.088  64.979  1.00 10.81           C  
ATOM   1017  CD1 ILE A 140      73.219  36.461  63.123  1.00 14.00           C  
ATOM   1018  N   ALA A 141      74.185  35.289  68.075  1.00 14.62           N  
ATOM   1019  CA  ALA A 141      74.812  35.128  69.377  1.00 15.23           C  
ATOM   1020  C   ALA A 141      76.302  34.861  69.212  1.00 14.58           C  
ATOM   1021  O   ALA A 141      77.040  35.722  68.744  1.00 14.91           O  
ATOM   1022  CB  ALA A 141      74.146  33.994  70.150  1.00 13.68           C  
ATOM   1023  N   SER A 142      76.738  33.667  69.586  1.00 13.13           N  
ATOM   1024  CA  SER A 142      78.147  33.311  69.486  1.00 11.62           C  
ATOM   1025  C   SER A 142      78.359  31.955  70.113  1.00  9.93           C  
ATOM   1026  O   SER A 142      77.499  31.456  70.835  1.00  8.30           O  
ATOM   1027  CB  SER A 142      79.015  34.320  70.248  1.00  9.83           C  
ATOM   1028  OG  SER A 142      80.360  33.868  70.355  1.00  9.59           O  
ATOM   1029  N   ALA A 143      79.519  31.372  69.838  1.00  9.49           N  
ATOM   1030  CA  ALA A 143      79.875  30.093  70.427  1.00 12.31           C  
ATOM   1031  C   ALA A 143      79.927  30.385  71.918  1.00 11.43           C  
ATOM   1032  O   ALA A 143      79.767  29.491  72.749  1.00 10.94           O  
ATOM   1033  CB  ALA A 143      81.249  29.646  69.933  1.00 12.89           C  
ATOM   1034  N   HIS A 144      80.156  31.656  72.241  1.00  9.70           N  
ATOM   1035  CA  HIS A 144      80.225  32.087  73.631  1.00 11.53           C  
ATOM   1036  C   HIS A 144      78.847  32.246  74.280  1.00 11.43           C  
ATOM   1037  O   HIS A 144      78.706  32.805  75.370  1.00 12.05           O  
ATOM   1038  CB  HIS A 144      81.061  33.364  73.735  1.00 10.92           C  
ATOM   1039  CG  HIS A 144      82.537  33.110  73.645  1.00 11.78           C  
ATOM   1040  ND1 HIS A 144      83.374  33.838  72.826  1.00 13.73           N  
ATOM   1041  CD2 HIS A 144      83.321  32.198  74.269  1.00 13.03           C  
ATOM   1042  CE1 HIS A 144      84.610  33.385  72.948  1.00 13.28           C  
ATOM   1043  NE2 HIS A 144      84.605  32.390  73.818  1.00 13.94           N  
ATOM   1044  N   GLY A 145      77.830  31.736  73.595  1.00 12.35           N  
ATOM   1045  CA  GLY A 145      76.485  31.747  74.137  1.00 10.13           C  
ATOM   1046  C   GLY A 145      76.212  30.320  74.599  1.00  9.09           C  
ATOM   1047  O   GLY A 145      75.202  30.027  75.249  1.00 10.29           O  
ATOM   1048  N   LEU A 146      77.137  29.428  74.255  1.00  8.47           N  
ATOM   1049  CA  LEU A 146      77.039  28.008  74.591  1.00 11.13           C  
ATOM   1050  C   LEU A 146      78.179  27.527  75.497  1.00  9.37           C  
ATOM   1051  O   LEU A 146      77.990  26.650  76.339  1.00 10.39           O  
ATOM   1052  CB  LEU A 146      77.024  27.177  73.304  1.00 10.75           C  
ATOM   1053  CG  LEU A 146      75.813  27.391  72.387  1.00 12.93           C  
ATOM   1054  CD1 LEU A 146      76.065  26.713  71.049  1.00 12.85           C  
ATOM   1055  CD2 LEU A 146      74.549  26.844  73.049  1.00 13.05           C  
ATOM   1056  N   VAL A 147      79.370  28.075  75.292  1.00  8.27           N  
ATOM   1057  CA  VAL A 147      80.517  27.723  76.115  1.00  9.12           C  
ATOM   1058  C   VAL A 147      81.216  29.008  76.537  1.00  9.94           C  
ATOM   1059  O   VAL A 147      80.794  30.103  76.160  1.00 10.01           O  
ATOM   1060  CB  VAL A 147      81.518  26.786  75.373  1.00  9.66           C  
ATOM   1061  CG1 VAL A 147      80.806  25.496  74.948  1.00  7.16           C  
ATOM   1062  CG2 VAL A 147      82.120  27.491  74.175  1.00  7.59           C  
ATOM   1063  N   ALA A 148      82.287  28.884  77.310  1.00 10.80           N  
ATOM   1064  CA  ALA A 148      82.983  30.068  77.791  1.00 11.57           C  
ATOM   1065  C   ALA A 148      84.469  30.133  77.478  1.00 11.86           C  
ATOM   1066  O   ALA A 148      85.090  29.130  77.126  1.00 12.26           O  
ATOM   1067  CB  ALA A 148      82.784  30.185  79.287  1.00 10.08           C  
ATOM   1068  N   SER A 149      85.014  31.341  77.598  1.00 11.63           N  
ATOM   1069  CA  SER A 149      86.437  31.605  77.411  1.00 13.00           C  
ATOM   1070  C   SER A 149      86.823  32.528  78.549  1.00 12.95           C  
ATOM   1071  O   SER A 149      86.032  33.382  78.946  1.00 14.16           O  
ATOM   1072  CB  SER A 149      86.728  32.302  76.079  1.00 11.78           C  
ATOM   1073  OG  SER A 149      86.665  31.390  75.000  1.00 15.66           O  
ATOM   1074  N   ALA A 150      88.026  32.343  79.081  1.00 13.60           N  
ATOM   1075  CA  ALA A 150      88.515  33.165  80.175  1.00 13.28           C  
ATOM   1076  C   ALA A 150      88.641  34.619  79.730  1.00 13.99           C  
ATOM   1077  O   ALA A 150      88.919  34.888  78.558  1.00 13.02           O  
ATOM   1078  CB  ALA A 150      89.882  32.647  80.650  1.00 13.71           C  
ATOM   1079  N   ASN A 151      88.429  35.542  80.671  1.00 13.05           N  
ATOM   1080  CA  ASN A 151      88.545  36.985  80.426  1.00 15.13           C  
ATOM   1081  C   ASN A 151      87.484  37.642  79.559  1.00 14.69           C  
ATOM   1082  O   ASN A 151      87.643  38.793  79.149  1.00 15.44           O  
ATOM   1083  CB  ASN A 151      89.918  37.308  79.843  1.00 17.74           C  
ATOM   1084  CG  ASN A 151      91.024  37.113  80.841  1.00 21.46           C  
ATOM   1085  OD1 ASN A 151      91.112  36.073  81.486  1.00 25.17           O  
ATOM   1086  ND2 ASN A 151      91.880  38.118  80.978  1.00 26.48           N  
ATOM   1087  N   LYS A 152      86.396  36.930  79.289  1.00 15.17           N  
ATOM   1088  CA  LYS A 152      85.329  37.479  78.468  1.00 14.58           C  
ATOM   1089  C   LYS A 152      83.982  37.343  79.169  1.00 14.37           C  
ATOM   1090  O   LYS A 152      82.969  37.054  78.535  1.00 16.35           O  
ATOM   1091  CB  LYS A 152      85.300  36.768  77.109  1.00 14.51           C  
ATOM   1092  CG  LYS A 152      86.499  37.085  76.224  1.00 13.76           C  
ATOM   1093  CD  LYS A 152      86.266  36.621  74.789  1.00 16.53           C  
ATOM   1094  CE  LYS A 152      87.444  37.006  73.896  1.00 17.93           C  
ATOM   1095  NZ  LYS A 152      87.247  36.567  72.485  1.00 23.63           N  
ATOM   1096  N   SER A 153      83.982  37.588  80.478  1.00 14.66           N  
ATOM   1097  CA  SER A 153      82.787  37.465  81.303  1.00 12.35           C  
ATOM   1098  C   SER A 153      81.533  38.180  80.820  1.00 13.16           C  
ATOM   1099  O   SER A 153      80.484  37.558  80.678  1.00 10.58           O  
ATOM   1100  CB  SER A 153      83.096  37.908  82.733  1.00 15.55           C  
ATOM   1101  OG  SER A 153      83.489  39.262  82.779  1.00 14.72           O  
ATOM   1102  N   ALA A 154      81.623  39.482  80.577  1.00 13.41           N  
ATOM   1103  CA  ALA A 154      80.444  40.224  80.131  1.00 13.28           C  
ATOM   1104  C   ALA A 154      79.904  39.703  78.802  1.00 12.20           C  
ATOM   1105  O   ALA A 154      78.693  39.599  78.624  1.00 10.19           O  
ATOM   1106  CB  ALA A 154      80.762  41.713  80.017  1.00 10.92           C  
ATOM   1107  N   TYR A 155      80.802  39.376  77.877  1.00 12.16           N  
ATOM   1108  CA  TYR A 155      80.405  38.877  76.559  1.00 11.29           C  
ATOM   1109  C   TYR A 155      79.748  37.500  76.639  1.00 11.19           C  
ATOM   1110  O   TYR A 155      78.713  37.259  76.015  1.00 13.05           O  
ATOM   1111  CB  TYR A 155      81.623  38.816  75.637  1.00  9.82           C  
ATOM   1112  CG  TYR A 155      81.304  38.567  74.178  1.00 12.73           C  
ATOM   1113  CD1 TYR A 155      81.405  37.287  73.621  1.00 14.85           C  
ATOM   1114  CD2 TYR A 155      80.901  39.614  73.352  1.00 14.94           C  
ATOM   1115  CE1 TYR A 155      81.112  37.064  72.272  1.00 13.60           C  
ATOM   1116  CE2 TYR A 155      80.604  39.404  72.010  1.00 14.50           C  
ATOM   1117  CZ  TYR A 155      80.711  38.131  71.474  1.00 16.59           C  
ATOM   1118  OH  TYR A 155      80.416  37.941  70.138  1.00 16.06           O  
ATOM   1119  N   VAL A 156      80.354  36.600  77.402  1.00 10.48           N  
ATOM   1120  CA  VAL A 156      79.820  35.254  77.551  1.00 10.38           C  
ATOM   1121  C   VAL A 156      78.463  35.315  78.236  1.00 11.15           C  
ATOM   1122  O   VAL A 156      77.510  34.677  77.789  1.00 11.55           O  
ATOM   1123  CB  VAL A 156      80.771  34.351  78.384  1.00  8.26           C  
ATOM   1124  CG1 VAL A 156      80.176  32.959  78.532  1.00 10.10           C  
ATOM   1125  CG2 VAL A 156      82.140  34.254  77.695  1.00 12.59           C  
ATOM   1126  N   ALA A 157      78.375  36.083  79.320  1.00  9.78           N  
ATOM   1127  CA  ALA A 157      77.121  36.213  80.052  1.00  9.44           C  
ATOM   1128  C   ALA A 157      76.011  36.754  79.158  1.00  8.78           C  
ATOM   1129  O   ALA A 157      74.910  36.198  79.127  1.00  9.75           O  
ATOM   1130  CB  ALA A 157      77.305  37.131  81.272  1.00  9.54           C  
ATOM   1131  N   ALA A 158      76.304  37.832  78.430  1.00  9.54           N  
ATOM   1132  CA  ALA A 158      75.330  38.456  77.533  1.00  9.77           C  
ATOM   1133  C   ALA A 158      74.863  37.528  76.406  1.00 10.56           C  
ATOM   1134  O   ALA A 158      73.669  37.458  76.102  1.00  8.83           O  
ATOM   1135  CB  ALA A 158      75.918  39.737  76.933  1.00  9.89           C  
ATOM   1136  N   LYS A 159      75.807  36.832  75.784  1.00 11.54           N  
ATOM   1137  CA  LYS A 159      75.489  35.916  74.696  1.00 11.48           C  
ATOM   1138  C   LYS A 159      74.699  34.726  75.222  1.00 12.27           C  
ATOM   1139  O   LYS A 159      73.795  34.229  74.552  1.00 11.56           O  
ATOM   1140  CB  LYS A 159      76.775  35.451  74.011  1.00 12.97           C  
ATOM   1141  CG  LYS A 159      77.500  36.573  73.275  1.00 14.71           C  
ATOM   1142  CD  LYS A 159      76.629  37.139  72.161  1.00 16.30           C  
ATOM   1143  CE  LYS A 159      77.352  38.235  71.400  1.00 16.85           C  
ATOM   1144  NZ  LYS A 159      76.594  38.667  70.197  1.00 15.66           N  
ATOM   1145  N   HIS A 160      75.048  34.264  76.421  1.00 10.77           N  
ATOM   1146  CA  HIS A 160      74.311  33.165  77.026  1.00  9.93           C  
ATOM   1147  C   HIS A 160      72.875  33.641  77.226  1.00  9.80           C  
ATOM   1148  O   HIS A 160      71.923  32.905  76.972  1.00  9.17           O  
ATOM   1149  CB  HIS A 160      74.928  32.764  78.371  1.00  8.92           C  
ATOM   1150  CG  HIS A 160      75.872  31.604  78.278  1.00  9.04           C  
ATOM   1151  ND1 HIS A 160      77.139  31.714  77.746  1.00 10.49           N  
ATOM   1152  CD2 HIS A 160      75.713  30.299  78.601  1.00  8.75           C  
ATOM   1153  CE1 HIS A 160      77.718  30.526  77.743  1.00  8.45           C  
ATOM   1154  NE2 HIS A 160      76.874  29.651  78.256  1.00  9.49           N  
ATOM   1155  N   GLY A 161      72.729  34.887  77.672  1.00 10.02           N  
ATOM   1156  CA  GLY A 161      71.405  35.443  77.887  1.00 11.53           C  
ATOM   1157  C   GLY A 161      70.626  35.509  76.591  1.00 11.32           C  
ATOM   1158  O   GLY A 161      69.418  35.282  76.572  1.00 13.77           O  
ATOM   1159  N   VAL A 162      71.319  35.822  75.501  1.00 10.69           N  
ATOM   1160  CA  VAL A 162      70.679  35.907  74.199  1.00 10.87           C  
ATOM   1161  C   VAL A 162      70.102  34.556  73.797  1.00 10.53           C  
ATOM   1162  O   VAL A 162      68.986  34.478  73.280  1.00 12.33           O  
ATOM   1163  CB  VAL A 162      71.671  36.379  73.126  1.00 10.98           C  
ATOM   1164  CG1 VAL A 162      71.026  36.303  71.736  1.00  9.11           C  
ATOM   1165  CG2 VAL A 162      72.101  37.809  73.432  1.00 10.18           C  
ATOM   1166  N   VAL A 163      70.853  33.487  74.041  1.00 10.71           N  
ATOM   1167  CA  VAL A 163      70.380  32.145  73.701  1.00  9.18           C  
ATOM   1168  C   VAL A 163      69.126  31.861  74.515  1.00  9.54           C  
ATOM   1169  O   VAL A 163      68.126  31.388  73.981  1.00  9.65           O  
ATOM   1170  CB  VAL A 163      71.454  31.088  74.002  1.00  9.32           C  
ATOM   1171  CG1 VAL A 163      70.922  29.691  73.697  1.00 11.68           C  
ATOM   1172  CG2 VAL A 163      72.695  31.381  73.181  1.00  8.79           C  
ATOM   1173  N   GLY A 164      69.174  32.163  75.812  1.00  8.21           N  
ATOM   1174  CA  GLY A 164      68.007  31.958  76.650  1.00  7.71           C  
ATOM   1175  C   GLY A 164      66.835  32.814  76.188  1.00 10.35           C  
ATOM   1176  O   GLY A 164      65.704  32.334  76.080  1.00  9.37           O  
ATOM   1177  N   PHE A 165      67.096  34.093  75.923  1.00  8.86           N  
ATOM   1178  CA  PHE A 165      66.041  34.994  75.475  1.00  9.97           C  
ATOM   1179  C   PHE A 165      65.420  34.481  74.171  1.00  8.80           C  
ATOM   1180  O   PHE A 165      64.216  34.613  73.950  1.00  8.75           O  
ATOM   1181  CB  PHE A 165      66.597  36.408  75.262  1.00 10.22           C  
ATOM   1182  CG  PHE A 165      65.543  37.428  74.946  1.00 10.57           C  
ATOM   1183  CD1 PHE A 165      64.750  37.966  75.960  1.00 11.72           C  
ATOM   1184  CD2 PHE A 165      65.307  37.815  73.630  1.00 11.79           C  
ATOM   1185  CE1 PHE A 165      63.731  38.874  75.668  1.00  9.28           C  
ATOM   1186  CE2 PHE A 165      64.292  38.723  73.323  1.00  9.48           C  
ATOM   1187  CZ  PHE A 165      63.501  39.252  74.347  1.00 12.76           C  
ATOM   1188  N   THR A 166      66.248  33.901  73.312  1.00  9.93           N  
ATOM   1189  CA  THR A 166      65.775  33.357  72.038  1.00 11.24           C  
ATOM   1190  C   THR A 166      64.792  32.213  72.276  1.00 11.96           C  
ATOM   1191  O   THR A 166      63.790  32.085  71.571  1.00 11.53           O  
ATOM   1192  CB  THR A 166      66.946  32.805  71.184  1.00 10.63           C  
ATOM   1193  OG1 THR A 166      67.888  33.851  70.924  1.00 10.64           O  
ATOM   1194  CG2 THR A 166      66.431  32.246  69.847  1.00  9.35           C  
ATOM   1195  N   LYS A 167      65.079  31.379  73.273  1.00 10.40           N  
ATOM   1196  CA  LYS A 167      64.219  30.234  73.568  1.00 10.89           C  
ATOM   1197  C   LYS A 167      62.844  30.679  74.050  1.00  9.82           C  
ATOM   1198  O   LYS A 167      61.829  30.105  73.671  1.00  8.67           O  
ATOM   1199  CB  LYS A 167      64.875  29.328  74.625  1.00 10.32           C  
ATOM   1200  CG  LYS A 167      66.207  28.692  74.205  1.00 12.78           C  
ATOM   1201  CD  LYS A 167      66.894  28.041  75.423  1.00 12.23           C  
ATOM   1202  CE  LYS A 167      68.317  27.581  75.123  1.00 15.81           C  
ATOM   1203  NZ  LYS A 167      69.043  27.121  76.359  1.00 13.65           N  
ATOM   1204  N   VAL A 168      62.814  31.704  74.895  1.00 12.29           N  
ATOM   1205  CA  VAL A 168      61.550  32.220  75.416  1.00 12.55           C  
ATOM   1206  C   VAL A 168      60.743  32.822  74.270  1.00 12.95           C  
ATOM   1207  O   VAL A 168      59.542  32.574  74.140  1.00 11.80           O  
ATOM   1208  CB  VAL A 168      61.803  33.300  76.495  1.00 11.78           C  
ATOM   1209  CG1 VAL A 168      60.476  33.877  76.991  1.00  8.23           C  
ATOM   1210  CG2 VAL A 168      62.597  32.685  77.658  1.00  8.15           C  
ATOM   1211  N   THR A 169      61.418  33.618  73.444  1.00 14.65           N  
ATOM   1212  CA  THR A 169      60.785  34.252  72.294  1.00 11.92           C  
ATOM   1213  C   THR A 169      60.064  33.188  71.460  1.00 11.30           C  
ATOM   1214  O   THR A 169      58.909  33.364  71.060  1.00 12.49           O  
ATOM   1215  CB  THR A 169      61.844  34.969  71.408  1.00 11.30           C  
ATOM   1216  OG1 THR A 169      62.529  35.973  72.175  1.00  8.18           O  
ATOM   1217  CG2 THR A 169      61.178  35.629  70.215  1.00  9.71           C  
ATOM   1218  N   ALA A 170      60.743  32.074  71.207  1.00 12.12           N  
ATOM   1219  CA  ALA A 170      60.161  30.989  70.415  1.00 10.04           C  
ATOM   1220  C   ALA A 170      58.912  30.388  71.051  1.00 10.25           C  
ATOM   1221  O   ALA A 170      57.905  30.142  70.372  1.00  9.80           O  
ATOM   1222  CB  ALA A 170      61.196  29.901  70.199  1.00 11.85           C  
ATOM   1223  N   LEU A 171      58.980  30.142  72.356  1.00 10.86           N  
ATOM   1224  CA  LEU A 171      57.859  29.546  73.086  1.00 10.95           C  
ATOM   1225  C   LEU A 171      56.642  30.470  73.139  1.00 11.09           C  
ATOM   1226  O   LEU A 171      55.502  30.008  73.060  1.00 10.56           O  
ATOM   1227  CB  LEU A 171      58.297  29.162  74.509  1.00  7.35           C  
ATOM   1228  CG  LEU A 171      59.392  28.090  74.650  1.00  5.89           C  
ATOM   1229  CD1 LEU A 171      59.686  27.860  76.122  1.00  8.18           C  
ATOM   1230  CD2 LEU A 171      58.946  26.786  73.987  1.00  5.81           C  
ATOM   1231  N   GLU A 172      56.885  31.770  73.283  1.00 11.16           N  
ATOM   1232  CA  GLU A 172      55.801  32.748  73.324  1.00 12.32           C  
ATOM   1233  C   GLU A 172      55.159  32.933  71.948  1.00 11.49           C  
ATOM   1234  O   GLU A 172      54.031  33.413  71.849  1.00 13.91           O  
ATOM   1235  CB  GLU A 172      56.321  34.105  73.833  1.00 10.06           C  
ATOM   1236  CG  GLU A 172      56.622  34.139  75.323  1.00 11.51           C  
ATOM   1237  CD  GLU A 172      57.078  35.511  75.800  1.00 11.86           C  
ATOM   1238  OE1 GLU A 172      56.834  36.506  75.083  1.00 10.85           O  
ATOM   1239  OE2 GLU A 172      57.671  35.592  76.897  1.00 14.19           O  
ATOM   1240  N   THR A 173      55.866  32.549  70.887  1.00 11.54           N  
ATOM   1241  CA  THR A 173      55.332  32.706  69.526  1.00 11.37           C  
ATOM   1242  C   THR A 173      55.036  31.387  68.810  1.00 11.64           C  
ATOM   1243  O   THR A 173      54.541  31.385  67.676  1.00  9.17           O  
ATOM   1244  CB  THR A 173      56.304  33.518  68.628  1.00 10.93           C  
ATOM   1245  OG1 THR A 173      57.544  32.814  68.500  1.00 11.47           O  
ATOM   1246  CG2 THR A 173      56.577  34.898  69.225  1.00 13.27           C  
ATOM   1247  N   ALA A 174      55.332  30.272  69.472  1.00 12.91           N  
ATOM   1248  CA  ALA A 174      55.132  28.946  68.886  1.00 12.35           C  
ATOM   1249  C   ALA A 174      53.780  28.750  68.208  1.00 12.62           C  
ATOM   1250  O   ALA A 174      52.739  28.984  68.808  1.00 13.23           O  
ATOM   1251  CB  ALA A 174      55.334  27.878  69.951  1.00 13.11           C  
ATOM   1252  N   GLY A 175      53.812  28.315  66.952  1.00 13.89           N  
ATOM   1253  CA  GLY A 175      52.587  28.066  66.208  1.00 13.72           C  
ATOM   1254  C   GLY A 175      51.986  29.249  65.465  1.00 14.63           C  
ATOM   1255  O   GLY A 175      51.108  29.064  64.612  1.00 10.76           O  
ATOM   1256  N   GLN A 176      52.458  30.456  65.772  1.00 14.10           N  
ATOM   1257  CA  GLN A 176      51.935  31.671  65.149  1.00 13.65           C  
ATOM   1258  C   GLN A 176      52.636  32.085  63.853  1.00 15.32           C  
ATOM   1259  O   GLN A 176      52.562  33.251  63.450  1.00 15.52           O  
ATOM   1260  CB  GLN A 176      51.987  32.840  66.155  1.00 14.12           C  
ATOM   1261  CG  GLN A 176      51.198  32.588  67.446  1.00 17.34           C  
ATOM   1262  CD  GLN A 176      51.137  33.799  68.363  1.00 21.04           C  
ATOM   1263  OE1 GLN A 176      50.650  34.862  67.976  1.00 24.80           O  
ATOM   1264  NE2 GLN A 176      51.626  33.643  69.591  1.00 20.50           N  
ATOM   1265  N   GLY A 177      53.301  31.139  63.196  1.00 15.05           N  
ATOM   1266  CA  GLY A 177      53.999  31.445  61.957  1.00 14.05           C  
ATOM   1267  C   GLY A 177      55.297  32.210  62.180  1.00 15.54           C  
ATOM   1268  O   GLY A 177      55.888  32.738  61.238  1.00 12.46           O  
ATOM   1269  N   ILE A 178      55.743  32.251  63.432  1.00 12.57           N  
ATOM   1270  CA  ILE A 178      56.960  32.958  63.811  1.00 12.45           C  
ATOM   1271  C   ILE A 178      57.983  32.027  64.462  1.00 13.36           C  
ATOM   1272  O   ILE A 178      57.624  31.167  65.271  1.00 11.58           O  
ATOM   1273  CB  ILE A 178      56.650  34.061  64.843  1.00 10.42           C  
ATOM   1274  CG1 ILE A 178      55.594  35.013  64.288  1.00 10.69           C  
ATOM   1275  CG2 ILE A 178      57.940  34.787  65.232  1.00 10.44           C  
ATOM   1276  CD1 ILE A 178      55.038  35.988  65.309  1.00  9.83           C  
ATOM   1277  N   THR A 179      59.253  32.196  64.107  1.00 13.08           N  
ATOM   1278  CA  THR A 179      60.312  31.398  64.725  1.00 13.31           C  
ATOM   1279  C   THR A 179      61.386  32.353  65.230  1.00 13.97           C  
ATOM   1280  O   THR A 179      61.497  33.490  64.760  1.00 15.16           O  
ATOM   1281  CB  THR A 179      60.965  30.393  63.740  1.00 12.84           C  
ATOM   1282  OG1 THR A 179      61.815  31.094  62.830  1.00 13.24           O  
ATOM   1283  CG2 THR A 179      59.896  29.637  62.952  1.00 13.31           C  
ATOM   1284  N   ALA A 180      62.160  31.895  66.205  1.00 13.22           N  
ATOM   1285  CA  ALA A 180      63.237  32.689  66.781  1.00 12.87           C  
ATOM   1286  C   ALA A 180      64.371  31.717  67.083  1.00 12.66           C  
ATOM   1287  O   ALA A 180      64.201  30.756  67.835  1.00 12.77           O  
ATOM   1288  CB  ALA A 180      62.758  33.382  68.050  1.00 13.06           C  
ATOM   1289  N   ASN A 181      65.516  31.960  66.455  1.00 11.39           N  
ATOM   1290  CA  ASN A 181      66.690  31.118  66.609  1.00 11.69           C  
ATOM   1291  C   ASN A 181      67.920  31.985  66.789  1.00 12.75           C  
ATOM   1292  O   ASN A 181      67.909  33.173  66.460  1.00 12.33           O  
ATOM   1293  CB  ASN A 181      66.870  30.249  65.367  1.00 11.36           C  
ATOM   1294  CG  ASN A 181      65.715  29.301  65.157  1.00 12.89           C  
ATOM   1295  OD1 ASN A 181      65.526  28.358  65.931  1.00 13.16           O  
ATOM   1296  ND2 ASN A 181      64.920  29.554  64.119  1.00 11.09           N  
ATOM   1297  N   ALA A 182      68.980  31.384  67.313  1.00 12.35           N  
ATOM   1298  CA  ALA A 182      70.226  32.095  67.529  1.00 11.44           C  
ATOM   1299  C   ALA A 182      71.356  31.436  66.759  1.00 12.78           C  
ATOM   1300  O   ALA A 182      71.620  30.242  66.935  1.00 13.93           O  
ATOM   1301  CB  ALA A 182      70.568  32.124  69.027  1.00  9.56           C  
ATOM   1302  N   ILE A 183      72.003  32.207  65.886  1.00 11.76           N  
ATOM   1303  CA  ILE A 183      73.148  31.710  65.130  1.00 11.36           C  
ATOM   1304  C   ILE A 183      74.326  31.944  66.070  1.00 12.26           C  
ATOM   1305  O   ILE A 183      74.465  33.035  66.630  1.00 11.94           O  
ATOM   1306  CB  ILE A 183      73.375  32.504  63.819  1.00  8.95           C  
ATOM   1307  CG1 ILE A 183      72.219  32.248  62.844  1.00 11.19           C  
ATOM   1308  CG2 ILE A 183      74.695  32.074  63.173  1.00  8.44           C  
ATOM   1309  CD1 ILE A 183      72.251  33.131  61.592  1.00 10.30           C  
ATOM   1310  N   CYS A 184      75.159  30.922  66.261  1.00 12.01           N  
ATOM   1311  CA  CYS A 184      76.300  31.030  67.166  1.00 12.16           C  
ATOM   1312  C   CYS A 184      77.625  30.885  66.418  1.00 10.28           C  
ATOM   1313  O   CYS A 184      78.166  29.788  66.288  1.00  9.84           O  
ATOM   1314  CB  CYS A 184      76.185  29.971  68.271  1.00 12.42           C  
ATOM   1315  SG  CYS A 184      74.729  30.192  69.317  1.00 10.61           S  
ATOM   1316  N   PRO A 185      78.170  32.006  65.923  1.00 11.72           N  
ATOM   1317  CA  PRO A 185      79.433  32.002  65.177  1.00 11.78           C  
ATOM   1318  C   PRO A 185      80.689  31.733  65.991  1.00 11.17           C  
ATOM   1319  O   PRO A 185      80.741  32.000  67.190  1.00 11.29           O  
ATOM   1320  CB  PRO A 185      79.483  33.402  64.555  1.00 13.08           C  
ATOM   1321  CG  PRO A 185      78.036  33.855  64.548  1.00 12.78           C  
ATOM   1322  CD  PRO A 185      77.554  33.342  65.884  1.00 12.34           C  
ATOM   1323  N   GLY A 186      81.696  31.197  65.307  1.00 10.71           N  
ATOM   1324  CA  GLY A 186      82.986  30.947  65.916  1.00 12.13           C  
ATOM   1325  C   GLY A 186      83.843  32.104  65.426  1.00 11.73           C  
ATOM   1326  O   GLY A 186      83.323  33.215  65.258  1.00 12.84           O  
ATOM   1327  N   TRP A 187      85.128  31.869  65.170  1.00 11.77           N  
ATOM   1328  CA  TRP A 187      86.008  32.943  64.696  1.00 14.08           C  
ATOM   1329  C   TRP A 187      85.628  33.447  63.309  1.00 13.40           C  
ATOM   1330  O   TRP A 187      85.434  32.654  62.393  1.00 11.09           O  
ATOM   1331  CB  TRP A 187      87.463  32.486  64.598  1.00 14.96           C  
ATOM   1332  CG  TRP A 187      88.259  32.439  65.860  1.00 18.52           C  
ATOM   1333  CD1 TRP A 187      88.438  31.360  66.678  1.00 18.89           C  
ATOM   1334  CD2 TRP A 187      89.085  33.484  66.383  1.00 19.61           C  
ATOM   1335  NE1 TRP A 187      89.337  31.664  67.671  1.00 19.65           N  
ATOM   1336  CE2 TRP A 187      89.750  32.963  67.515  1.00 22.07           C  
ATOM   1337  CE3 TRP A 187      89.334  34.812  66.002  1.00 20.93           C  
ATOM   1338  CZ2 TRP A 187      90.654  33.723  68.273  1.00 22.08           C  
ATOM   1339  CZ3 TRP A 187      90.235  35.571  66.756  1.00 22.86           C  
ATOM   1340  CH2 TRP A 187      90.883  35.020  67.880  1.00 21.28           C  
ATOM   1341  N   VAL A 188      85.554  34.769  63.165  1.00 13.75           N  
ATOM   1342  CA  VAL A 188      85.257  35.416  61.884  1.00 15.45           C  
ATOM   1343  C   VAL A 188      86.429  36.368  61.641  1.00 17.36           C  
ATOM   1344  O   VAL A 188      86.902  37.023  62.574  1.00 17.34           O  
ATOM   1345  CB  VAL A 188      83.946  36.227  61.936  1.00 13.87           C  
ATOM   1346  CG1 VAL A 188      83.711  36.922  60.591  1.00 13.59           C  
ATOM   1347  CG2 VAL A 188      82.777  35.305  62.270  1.00  9.79           C  
ATOM   1348  N   ARG A 189      86.897  36.449  60.398  1.00 20.23           N  
ATOM   1349  CA  ARG A 189      88.048  37.294  60.071  1.00 23.12           C  
ATOM   1350  C   ARG A 189      87.741  38.775  59.875  1.00 25.04           C  
ATOM   1351  O   ARG A 189      87.821  39.295  58.764  1.00 25.02           O  
ATOM   1352  CB  ARG A 189      88.749  36.747  58.822  1.00 24.07           C  
ATOM   1353  CG  ARG A 189      90.154  37.293  58.597  1.00 24.98           C  
ATOM   1354  CD  ARG A 189      90.949  36.381  57.662  1.00 25.75           C  
ATOM   1355  NE  ARG A 189      92.374  36.718  57.638  1.00 26.31           N  
ATOM   1356  CZ  ARG A 189      93.311  35.959  57.079  1.00 27.15           C  
ATOM   1357  NH1 ARG A 189      92.980  34.815  56.493  1.00 25.41           N  
ATOM   1358  NH2 ARG A 189      94.584  36.340  57.112  1.00 27.23           N  
ATOM   1359  N   THR A 190      87.411  39.454  60.966  1.00 27.74           N  
ATOM   1360  CA  THR A 190      87.097  40.878  60.926  1.00 29.67           C  
ATOM   1361  C   THR A 190      88.383  41.680  60.740  1.00 31.95           C  
ATOM   1362  O   THR A 190      89.480  41.138  60.865  1.00 31.61           O  
ATOM   1363  CB  THR A 190      86.430  41.328  62.236  1.00 29.91           C  
ATOM   1364  OG1 THR A 190      87.331  41.097  63.326  1.00 29.73           O  
ATOM   1365  CG2 THR A 190      85.138  40.553  62.476  1.00 29.50           C  
ATOM   1366  N   PRO A 191      88.265  42.984  60.434  1.00 33.63           N  
ATOM   1367  CA  PRO A 191      89.460  43.811  60.247  1.00 34.87           C  
ATOM   1368  C   PRO A 191      90.315  43.848  61.510  1.00 35.76           C  
ATOM   1369  O   PRO A 191      91.544  43.852  61.436  1.00 35.80           O  
ATOM   1370  CB  PRO A 191      88.883  45.182  59.893  1.00 35.01           C  
ATOM   1371  CG  PRO A 191      87.565  45.188  60.608  1.00 35.36           C  
ATOM   1372  CD  PRO A 191      87.044  43.800  60.306  1.00 34.40           C  
ATOM   1373  N   LEU A 192      89.655  43.874  62.666  1.00 35.91           N  
ATOM   1374  CA  LEU A 192      90.361  43.902  63.941  1.00 36.74           C  
ATOM   1375  C   LEU A 192      91.037  42.566  64.222  1.00 36.90           C  
ATOM   1376  O   LEU A 192      92.053  42.512  64.918  1.00 36.63           O  
ATOM   1377  CB  LEU A 192      89.407  44.263  65.086  1.00 38.51           C  
ATOM   1378  CG  LEU A 192      88.045  43.577  65.206  1.00 41.27           C  
ATOM   1379  CD1 LEU A 192      87.477  43.840  66.595  1.00 41.22           C  
ATOM   1380  CD2 LEU A 192      87.092  44.097  64.127  1.00 42.18           C  
ATOM   1381  N   VAL A 193      90.472  41.487  63.685  1.00 35.21           N  
ATOM   1382  CA  VAL A 193      91.061  40.169  63.873  1.00 34.07           C  
ATOM   1383  C   VAL A 193      92.282  40.089  62.965  1.00 33.72           C  
ATOM   1384  O   VAL A 193      93.283  39.460  63.310  1.00 32.81           O  
ATOM   1385  CB  VAL A 193      90.064  39.036  63.518  1.00 33.83           C  
ATOM   1386  CG1 VAL A 193      90.785  37.692  63.466  1.00 32.26           C  
ATOM   1387  CG2 VAL A 193      88.962  38.980  64.566  1.00 32.48           C  
ATOM   1388  N   GLU A 194      92.195  40.743  61.810  1.00 33.54           N  
ATOM   1389  CA  GLU A 194      93.296  40.757  60.857  1.00 33.88           C  
ATOM   1390  C   GLU A 194      94.537  41.325  61.539  1.00 34.25           C  
ATOM   1391  O   GLU A 194      95.623  40.759  61.441  1.00 33.83           O  
ATOM   1392  CB  GLU A 194      92.949  41.617  59.642  1.00 33.26           C  
ATOM   1393  CG  GLU A 194      93.942  41.469  58.504  1.00 34.26           C  
ATOM   1394  CD  GLU A 194      93.856  40.110  57.834  1.00 34.60           C  
ATOM   1395  OE1 GLU A 194      94.810  39.729  57.127  1.00 35.34           O  
ATOM   1396  OE2 GLU A 194      92.826  39.426  58.005  1.00 34.71           O  
ATOM   1397  N   LYS A 195      94.364  42.449  62.228  1.00 34.54           N  
ATOM   1398  CA  LYS A 195      95.464  43.086  62.939  1.00 35.23           C  
ATOM   1399  C   LYS A 195      96.037  42.092  63.943  1.00 35.25           C  
ATOM   1400  O   LYS A 195      97.251  42.017  64.146  1.00 34.77           O  
ATOM   1401  CB  LYS A 195      94.970  44.334  63.673  1.00 36.42           C  
ATOM   1402  CG  LYS A 195      94.407  45.410  62.757  1.00 39.02           C  
ATOM   1403  CD  LYS A 195      94.001  46.654  63.536  1.00 41.56           C  
ATOM   1404  CE  LYS A 195      93.561  47.775  62.601  1.00 43.21           C  
ATOM   1405  NZ  LYS A 195      93.184  49.012  63.343  1.00 44.36           N  
ATOM   1406  N   GLN A 196      95.148  41.323  64.563  1.00 33.69           N  
ATOM   1407  CA  GLN A 196      95.546  40.327  65.546  1.00 34.19           C  
ATOM   1408  C   GLN A 196      96.442  39.282  64.882  1.00 33.16           C  
ATOM   1409  O   GLN A 196      97.446  38.851  65.453  1.00 31.74           O  
ATOM   1410  CB  GLN A 196      94.300  39.665  66.131  1.00 36.08           C  
ATOM   1411  CG  GLN A 196      94.544  38.866  67.393  1.00 38.76           C  
ATOM   1412  CD  GLN A 196      93.248  38.416  68.044  1.00 40.38           C  
ATOM   1413  OE1 GLN A 196      93.256  37.788  69.106  1.00 41.74           O  
ATOM   1414  NE2 GLN A 196      92.124  38.735  67.408  1.00 41.00           N  
ATOM   1415  N   ILE A 197      96.071  38.887  63.667  1.00 31.88           N  
ATOM   1416  CA  ILE A 197      96.828  37.908  62.901  1.00 31.26           C  
ATOM   1417  C   ILE A 197      98.214  38.448  62.550  1.00 32.30           C  
ATOM   1418  O   ILE A 197      99.213  37.735  62.663  1.00 30.76           O  
ATOM   1419  CB  ILE A 197      96.093  37.535  61.596  1.00 30.46           C  
ATOM   1420  CG1 ILE A 197      94.788  36.800  61.924  1.00 28.25           C  
ATOM   1421  CG2 ILE A 197      96.987  36.665  60.722  1.00 29.78           C  
ATOM   1422  CD1 ILE A 197      93.933  36.494  60.708  1.00 26.16           C  
ATOM   1423  N   SER A 198      98.265  39.706  62.120  1.00 33.20           N  
ATOM   1424  CA  SER A 198      99.530  40.337  61.756  1.00 34.21           C  
ATOM   1425  C   SER A 198     100.440  40.420  62.973  1.00 35.40           C  
ATOM   1426  O   SER A 198     101.614  40.063  62.905  1.00 35.49           O  
ATOM   1427  CB  SER A 198      99.284  41.741  61.198  1.00 34.12           C  
ATOM   1428  OG  SER A 198      98.671  41.680  59.923  1.00 32.69           O  
ATOM   1429  N   ALA A 199      99.886  40.892  64.085  1.00 37.10           N  
ATOM   1430  CA  ALA A 199     100.641  41.015  65.324  1.00 38.96           C  
ATOM   1431  C   ALA A 199     101.247  39.663  65.691  1.00 39.89           C  
ATOM   1432  O   ALA A 199     102.436  39.564  65.999  1.00 40.17           O  
ATOM   1433  CB  ALA A 199      99.728  41.502  66.445  1.00 38.88           C  
ATOM   1434  N   LEU A 200     100.424  38.622  65.648  1.00 40.02           N  
ATOM   1435  CA  LEU A 200     100.882  37.282  65.976  1.00 40.16           C  
ATOM   1436  C   LEU A 200     101.937  36.819  64.976  1.00 40.82           C  
ATOM   1437  O   LEU A 200     102.944  36.219  65.353  1.00 40.92           O  
ATOM   1438  CB  LEU A 200      99.700  36.309  65.971  1.00 40.48           C  
ATOM   1439  CG  LEU A 200     100.025  34.846  66.284  1.00 40.86           C  
ATOM   1440  CD1 LEU A 200     100.608  34.743  67.686  1.00 41.36           C  
ATOM   1441  CD2 LEU A 200      98.767  33.999  66.162  1.00 40.56           C  
ATOM   1442  N   ALA A 201     101.701  37.102  63.699  1.00 41.48           N  
ATOM   1443  CA  ALA A 201     102.628  36.714  62.643  1.00 42.15           C  
ATOM   1444  C   ALA A 201     104.004  37.328  62.887  1.00 43.72           C  
ATOM   1445  O   ALA A 201     105.034  36.701  62.635  1.00 43.28           O  
ATOM   1446  CB  ALA A 201     102.087  37.156  61.290  1.00 41.34           C  
ATOM   1447  N   GLU A 202     104.012  38.558  63.382  1.00 45.27           N  
ATOM   1448  CA  GLU A 202     105.256  39.264  63.658  1.00 47.25           C  
ATOM   1449  C   GLU A 202     105.955  38.664  64.873  1.00 46.44           C  
ATOM   1450  O   GLU A 202     107.148  38.372  64.833  1.00 46.73           O  
ATOM   1451  CB  GLU A 202     104.959  40.747  63.898  1.00 50.58           C  
ATOM   1452  CG  GLU A 202     104.329  41.441  62.692  1.00 55.07           C  
ATOM   1453  CD  GLU A 202     103.586  42.712  63.062  1.00 57.11           C  
ATOM   1454  OE1 GLU A 202     103.058  43.381  62.147  1.00 57.95           O  
ATOM   1455  OE2 GLU A 202     103.523  43.036  64.268  1.00 59.17           O  
ATOM   1456  N   LYS A 203     105.200  38.471  65.948  1.00 45.55           N  
ATOM   1457  CA  LYS A 203     105.734  37.912  67.184  1.00 44.67           C  
ATOM   1458  C   LYS A 203     106.309  36.510  67.001  1.00 44.76           C  
ATOM   1459  O   LYS A 203     107.287  36.142  67.654  1.00 43.43           O  
ATOM   1460  CB  LYS A 203     104.636  37.873  68.248  1.00 44.87           C  
ATOM   1461  CG  LYS A 203     105.031  37.175  69.536  1.00 45.35           C  
ATOM   1462  CD  LYS A 203     103.828  37.020  70.450  1.00 46.66           C  
ATOM   1463  CE  LYS A 203     104.161  36.188  71.676  1.00 46.89           C  
ATOM   1464  NZ  LYS A 203     102.952  35.950  72.512  1.00 47.01           N  
ATOM   1465  N   ASN A 204     105.698  35.733  66.110  1.00 44.74           N  
ATOM   1466  CA  ASN A 204     106.134  34.365  65.852  1.00 43.83           C  
ATOM   1467  C   ASN A 204     107.031  34.258  64.626  1.00 42.53           C  
ATOM   1468  O   ASN A 204     107.574  33.194  64.336  1.00 42.72           O  
ATOM   1469  CB  ASN A 204     104.913  33.459  65.680  1.00 45.28           C  
ATOM   1470  CG  ASN A 204     103.999  33.486  66.891  1.00 47.26           C  
ATOM   1471  OD1 ASN A 204     103.611  34.554  67.362  1.00 49.36           O  
ATOM   1472  ND2 ASN A 204     103.646  32.310  67.399  1.00 47.91           N  
ATOM   1473  N   GLY A 205     107.184  35.363  63.907  1.00 41.35           N  
ATOM   1474  CA  GLY A 205     108.025  35.354  62.726  1.00 39.62           C  
ATOM   1475  C   GLY A 205     107.591  34.342  61.682  1.00 39.40           C  
ATOM   1476  O   GLY A 205     108.417  33.596  61.152  1.00 38.27           O  
ATOM   1477  N   VAL A 206     106.293  34.311  61.391  1.00 38.27           N  
ATOM   1478  CA  VAL A 206     105.742  33.397  60.392  1.00 37.64           C  
ATOM   1479  C   VAL A 206     104.846  34.187  59.441  1.00 36.54           C  
ATOM   1480  O   VAL A 206     104.509  35.337  59.721  1.00 36.23           O  
ATOM   1481  CB  VAL A 206     104.905  32.271  61.049  1.00 36.90           C  
ATOM   1482  CG1 VAL A 206     105.799  31.387  61.899  1.00 37.55           C  
ATOM   1483  CG2 VAL A 206     103.796  32.871  61.900  1.00 37.26           C  
ATOM   1484  N   ASP A 207     104.466  33.581  58.320  1.00 35.94           N  
ATOM   1485  CA  ASP A 207     103.605  34.263  57.357  1.00 37.06           C  
ATOM   1486  C   ASP A 207     102.203  34.485  57.926  1.00 36.09           C  
ATOM   1487  O   ASP A 207     101.793  33.816  58.874  1.00 34.77           O  
ATOM   1488  CB  ASP A 207     103.521  33.475  56.043  1.00 39.67           C  
ATOM   1489  CG  ASP A 207     103.248  31.999  56.258  1.00 43.66           C  
ATOM   1490  OD1 ASP A 207     104.167  31.281  56.711  1.00 46.27           O  
ATOM   1491  OD2 ASP A 207     102.114  31.557  55.975  1.00 46.28           O  
ATOM   1492  N   GLN A 208     101.477  35.430  57.337  1.00 33.77           N  
ATOM   1493  CA  GLN A 208     100.132  35.774  57.785  1.00 32.94           C  
ATOM   1494  C   GLN A 208      99.200  34.564  57.909  1.00 31.76           C  
ATOM   1495  O   GLN A 208      98.479  34.429  58.897  1.00 30.56           O  
ATOM   1496  CB  GLN A 208      99.511  36.808  56.837  1.00 32.83           C  
ATOM   1497  CG  GLN A 208      98.255  37.482  57.380  1.00 32.75           C  
ATOM   1498  CD  GLN A 208      98.553  38.527  58.446  1.00 33.46           C  
ATOM   1499  OE1 GLN A 208      99.669  38.611  58.961  1.00 34.58           O  
ATOM   1500  NE2 GLN A 208      97.547  39.325  58.786  1.00 33.19           N  
ATOM   1501  N   GLU A 209      99.216  33.685  56.912  1.00 29.81           N  
ATOM   1502  CA  GLU A 209      98.347  32.517  56.941  1.00 28.13           C  
ATOM   1503  C   GLU A 209      98.736  31.479  57.988  1.00 27.05           C  
ATOM   1504  O   GLU A 209      97.874  30.770  58.515  1.00 24.89           O  
ATOM   1505  CB  GLU A 209      98.273  31.888  55.550  1.00 28.33           C  
ATOM   1506  CG  GLU A 209      97.653  32.829  54.527  1.00 29.17           C  
ATOM   1507  CD  GLU A 209      96.373  33.479  55.034  1.00 30.06           C  
ATOM   1508  OE1 GLU A 209      95.359  32.769  55.213  1.00 30.42           O  
ATOM   1509  OE2 GLU A 209      96.384  34.708  55.263  1.00 29.12           O  
ATOM   1510  N   THR A 210     100.027  31.379  58.290  1.00 25.03           N  
ATOM   1511  CA  THR A 210     100.475  30.435  59.308  1.00 22.66           C  
ATOM   1512  C   THR A 210      99.968  30.963  60.649  1.00 22.01           C  
ATOM   1513  O   THR A 210      99.500  30.202  61.499  1.00 20.67           O  
ATOM   1514  CB  THR A 210     102.015  30.324  59.337  1.00 23.74           C  
ATOM   1515  OG1 THR A 210     102.459  29.608  58.176  1.00 22.19           O  
ATOM   1516  CG2 THR A 210     102.487  29.598  60.602  1.00 21.95           C  
ATOM   1517  N   ALA A 211     100.049  32.277  60.821  1.00 20.44           N  
ATOM   1518  CA  ALA A 211      99.586  32.913  62.048  1.00 20.83           C  
ATOM   1519  C   ALA A 211      98.071  32.727  62.195  1.00 20.67           C  
ATOM   1520  O   ALA A 211      97.566  32.491  63.295  1.00 20.15           O  
ATOM   1521  CB  ALA A 211      99.937  34.400  62.033  1.00 21.04           C  
ATOM   1522  N   ALA A 212      97.357  32.832  61.077  1.00 20.22           N  
ATOM   1523  CA  ALA A 212      95.903  32.677  61.080  1.00 19.69           C  
ATOM   1524  C   ALA A 212      95.531  31.307  61.635  1.00 19.64           C  
ATOM   1525  O   ALA A 212      94.682  31.198  62.523  1.00 20.26           O  
ATOM   1526  CB  ALA A 212      95.356  32.843  59.667  1.00 15.02           C  
ATOM   1527  N   ARG A 213      96.163  30.261  61.110  1.00 19.40           N  
ATOM   1528  CA  ARG A 213      95.895  28.911  61.590  1.00 19.43           C  
ATOM   1529  C   ARG A 213      96.287  28.833  63.062  1.00 17.64           C  
ATOM   1530  O   ARG A 213      95.568  28.262  63.879  1.00 15.77           O  
ATOM   1531  CB  ARG A 213      96.685  27.882  60.766  1.00 20.96           C  
ATOM   1532  CG  ARG A 213      96.070  27.583  59.396  1.00 25.34           C  
ATOM   1533  CD  ARG A 213      97.033  26.825  58.487  1.00 29.53           C  
ATOM   1534  NE  ARG A 213      97.330  25.474  58.956  1.00 33.44           N  
ATOM   1535  CZ  ARG A 213      96.561  24.410  58.737  1.00 37.25           C  
ATOM   1536  NH1 ARG A 213      95.432  24.530  58.048  1.00 39.24           N  
ATOM   1537  NH2 ARG A 213      96.925  23.220  59.200  1.00 38.05           N  
ATOM   1538  N   GLU A 214      97.427  29.419  63.402  1.00 19.52           N  
ATOM   1539  CA  GLU A 214      97.891  29.403  64.785  1.00 19.07           C  
ATOM   1540  C   GLU A 214      96.892  30.079  65.716  1.00 18.28           C  
ATOM   1541  O   GLU A 214      96.606  29.571  66.794  1.00 18.97           O  
ATOM   1542  CB  GLU A 214      99.259  30.076  64.891  1.00 20.65           C  
ATOM   1543  CG  GLU A 214     100.378  29.238  64.289  1.00 23.33           C  
ATOM   1544  CD  GLU A 214     101.728  29.933  64.325  1.00 25.14           C  
ATOM   1545  OE1 GLU A 214     102.727  29.309  63.895  1.00 25.58           O  
ATOM   1546  OE2 GLU A 214     101.787  31.099  64.778  1.00 25.97           O  
ATOM   1547  N   LEU A 215      96.349  31.216  65.293  1.00 17.84           N  
ATOM   1548  CA  LEU A 215      95.372  31.930  66.110  1.00 18.16           C  
ATOM   1549  C   LEU A 215      94.091  31.108  66.296  1.00 16.36           C  
ATOM   1550  O   LEU A 215      93.485  31.112  67.371  1.00 15.93           O  
ATOM   1551  CB  LEU A 215      95.027  33.277  65.464  1.00 19.67           C  
ATOM   1552  CG  LEU A 215      94.093  34.195  66.261  1.00 20.34           C  
ATOM   1553  CD1 LEU A 215      94.695  34.482  67.631  1.00 21.31           C  
ATOM   1554  CD2 LEU A 215      93.877  35.488  65.500  1.00 23.41           C  
ATOM   1555  N   LEU A 216      93.695  30.390  65.250  1.00 14.70           N  
ATOM   1556  CA  LEU A 216      92.482  29.576  65.288  1.00 16.67           C  
ATOM   1557  C   LEU A 216      92.627  28.236  66.018  1.00 15.76           C  
ATOM   1558  O   LEU A 216      91.641  27.694  66.516  1.00 16.81           O  
ATOM   1559  CB  LEU A 216      91.995  29.299  63.854  1.00 16.79           C  
ATOM   1560  CG  LEU A 216      91.516  30.463  62.981  1.00 18.95           C  
ATOM   1561  CD1 LEU A 216      91.442  30.025  61.529  1.00 19.67           C  
ATOM   1562  CD2 LEU A 216      90.158  30.938  63.458  1.00 19.47           C  
ATOM   1563  N   SER A 217      93.847  27.714  66.092  1.00 14.86           N  
ATOM   1564  CA  SER A 217      94.092  26.402  66.696  1.00 16.87           C  
ATOM   1565  C   SER A 217      93.467  26.086  68.053  1.00 15.98           C  
ATOM   1566  O   SER A 217      92.964  24.986  68.254  1.00 17.26           O  
ATOM   1567  CB  SER A 217      95.597  26.123  66.766  1.00 16.74           C  
ATOM   1568  OG  SER A 217      96.236  26.984  67.688  1.00 24.77           O  
ATOM   1569  N   GLU A 218      93.487  27.028  68.985  1.00 16.17           N  
ATOM   1570  CA  GLU A 218      92.926  26.745  70.303  1.00 16.92           C  
ATOM   1571  C   GLU A 218      91.416  26.495  70.361  1.00 15.40           C  
ATOM   1572  O   GLU A 218      90.963  25.616  71.092  1.00 14.75           O  
ATOM   1573  CB  GLU A 218      93.268  27.862  71.291  1.00 17.30           C  
ATOM   1574  CG  GLU A 218      92.916  27.480  72.727  1.00 24.14           C  
ATOM   1575  CD  GLU A 218      93.020  28.627  73.705  1.00 26.23           C  
ATOM   1576  OE1 GLU A 218      92.986  28.360  74.925  1.00 31.76           O  
ATOM   1577  OE2 GLU A 218      93.119  29.791  73.268  1.00 29.57           O  
ATOM   1578  N   LYS A 219      90.640  27.251  69.590  1.00 14.98           N  
ATOM   1579  CA  LYS A 219      89.182  27.111  69.628  1.00 13.07           C  
ATOM   1580  C   LYS A 219      88.466  26.534  68.400  1.00 12.14           C  
ATOM   1581  O   LYS A 219      87.376  25.983  68.530  1.00 11.00           O  
ATOM   1582  CB  LYS A 219      88.552  28.480  69.924  1.00  9.20           C  
ATOM   1583  CG  LYS A 219      89.042  29.167  71.189  1.00 10.20           C  
ATOM   1584  CD  LYS A 219      88.576  28.451  72.433  1.00 11.11           C  
ATOM   1585  CE  LYS A 219      88.919  29.257  73.676  1.00 12.17           C  
ATOM   1586  NZ  LYS A 219      88.338  28.639  74.898  1.00 13.33           N  
ATOM   1587  N   GLN A 220      89.070  26.657  67.220  1.00 12.14           N  
ATOM   1588  CA  GLN A 220      88.428  26.221  65.974  1.00 11.95           C  
ATOM   1589  C   GLN A 220      89.145  25.072  65.244  1.00 11.94           C  
ATOM   1590  O   GLN A 220      90.037  25.308  64.426  1.00 14.32           O  
ATOM   1591  CB  GLN A 220      88.318  27.447  65.053  1.00 12.77           C  
ATOM   1592  CG  GLN A 220      87.172  27.430  64.066  1.00  9.57           C  
ATOM   1593  CD  GLN A 220      86.450  28.769  64.022  1.00 12.13           C  
ATOM   1594  OE1 GLN A 220      85.912  29.230  65.029  1.00 11.92           O  
ATOM   1595  NE2 GLN A 220      86.432  29.398  62.851  1.00 12.56           N  
ATOM   1596  N   PRO A 221      88.732  23.816  65.504  1.00 11.56           N  
ATOM   1597  CA  PRO A 221      89.318  22.615  64.897  1.00 12.96           C  
ATOM   1598  C   PRO A 221      89.604  22.676  63.398  1.00 12.13           C  
ATOM   1599  O   PRO A 221      90.639  22.191  62.943  1.00 11.87           O  
ATOM   1600  CB  PRO A 221      88.295  21.531  65.229  1.00 12.12           C  
ATOM   1601  CG  PRO A 221      87.791  21.961  66.547  1.00 13.86           C  
ATOM   1602  CD  PRO A 221      87.593  23.447  66.364  1.00 11.60           C  
ATOM   1603  N   SER A 222      88.684  23.259  62.634  1.00 12.17           N  
ATOM   1604  CA  SER A 222      88.838  23.350  61.182  1.00 13.66           C  
ATOM   1605  C   SER A 222      90.033  24.186  60.742  1.00 15.03           C  
ATOM   1606  O   SER A 222      90.574  23.971  59.657  1.00 16.62           O  
ATOM   1607  CB  SER A 222      87.576  23.938  60.549  1.00 12.68           C  
ATOM   1608  OG  SER A 222      87.485  25.328  60.806  1.00 10.80           O  
ATOM   1609  N   LEU A 223      90.426  25.140  61.580  1.00 14.69           N  
ATOM   1610  CA  LEU A 223      91.540  26.031  61.284  1.00 15.63           C  
ATOM   1611  C   LEU A 223      91.172  26.918  60.099  1.00 16.62           C  
ATOM   1612  O   LEU A 223      92.037  27.383  59.358  1.00 14.52           O  
ATOM   1613  CB  LEU A 223      92.807  25.222  60.978  1.00 17.30           C  
ATOM   1614  CG  LEU A 223      93.270  24.278  62.094  1.00 18.20           C  
ATOM   1615  CD1 LEU A 223      94.579  23.609  61.690  1.00 17.77           C  
ATOM   1616  CD2 LEU A 223      93.456  25.062  63.392  1.00 18.28           C  
ATOM   1617  N   GLN A 224      89.872  27.140  59.937  1.00 15.44           N  
ATOM   1618  CA  GLN A 224      89.342  27.966  58.864  1.00 16.86           C  
ATOM   1619  C   GLN A 224      88.335  28.949  59.449  1.00 17.23           C  
ATOM   1620  O   GLN A 224      87.559  28.598  60.339  1.00 17.67           O  
ATOM   1621  CB  GLN A 224      88.659  27.087  57.814  1.00 17.79           C  
ATOM   1622  CG  GLN A 224      89.577  26.035  57.207  1.00 19.42           C  
ATOM   1623  CD  GLN A 224      88.832  25.010  56.375  1.00 22.34           C  
ATOM   1624  OE1 GLN A 224      87.925  24.333  56.864  1.00 20.32           O  
ATOM   1625  NE2 GLN A 224      89.220  24.881  55.109  1.00 25.37           N  
ATOM   1626  N   PHE A 225      88.359  30.183  58.961  1.00 16.17           N  
ATOM   1627  CA  PHE A 225      87.430  31.187  59.453  1.00 16.69           C  
ATOM   1628  C   PHE A 225      86.026  31.015  58.895  1.00 16.84           C  
ATOM   1629  O   PHE A 225      85.836  30.501  57.793  1.00 16.61           O  
ATOM   1630  CB  PHE A 225      87.900  32.598  59.097  1.00 17.33           C  
ATOM   1631  CG  PHE A 225      89.043  33.097  59.929  1.00 16.76           C  
ATOM   1632  CD1 PHE A 225      90.357  32.908  59.518  1.00 18.83           C  
ATOM   1633  CD2 PHE A 225      88.803  33.798  61.105  1.00 19.00           C  
ATOM   1634  CE1 PHE A 225      91.416  33.419  60.263  1.00 18.61           C  
ATOM   1635  CE2 PHE A 225      89.856  34.313  61.859  1.00 19.63           C  
ATOM   1636  CZ  PHE A 225      91.165  34.123  61.434  1.00 18.24           C  
ATOM   1637  N   VAL A 226      85.046  31.442  59.683  1.00 15.60           N  
ATOM   1638  CA  VAL A 226      83.651  31.425  59.266  1.00 15.74           C  
ATOM   1639  C   VAL A 226      83.535  32.752  58.515  1.00 15.82           C  
ATOM   1640  O   VAL A 226      84.182  33.730  58.893  1.00 14.69           O  
ATOM   1641  CB  VAL A 226      82.707  31.449  60.482  1.00 15.63           C  
ATOM   1642  CG1 VAL A 226      81.279  31.676  60.022  1.00 16.42           C  
ATOM   1643  CG2 VAL A 226      82.831  30.146  61.267  1.00 11.81           C  
ATOM   1644  N   THR A 227      82.737  32.798  57.456  1.00 15.41           N  
ATOM   1645  CA  THR A 227      82.611  34.038  56.693  1.00 17.20           C  
ATOM   1646  C   THR A 227      81.250  34.719  56.800  1.00 18.84           C  
ATOM   1647  O   THR A 227      80.242  34.090  57.146  1.00 18.04           O  
ATOM   1648  CB  THR A 227      82.883  33.806  55.197  1.00 17.22           C  
ATOM   1649  OG1 THR A 227      81.846  32.986  54.651  1.00 17.32           O  
ATOM   1650  CG2 THR A 227      84.231  33.127  54.994  1.00 15.69           C  
ATOM   1651  N   PRO A 228      81.209  36.029  56.513  1.00 19.16           N  
ATOM   1652  CA  PRO A 228      79.948  36.767  56.577  1.00 19.21           C  
ATOM   1653  C   PRO A 228      78.985  36.231  55.526  1.00 19.81           C  
ATOM   1654  O   PRO A 228      77.769  36.306  55.694  1.00 19.44           O  
ATOM   1655  CB  PRO A 228      80.381  38.203  56.309  1.00 19.84           C  
ATOM   1656  CG  PRO A 228      81.758  38.238  56.925  1.00 17.97           C  
ATOM   1657  CD  PRO A 228      82.348  36.957  56.399  1.00 18.40           C  
ATOM   1658  N   GLU A 229      79.540  35.686  54.443  1.00 18.33           N  
ATOM   1659  CA  GLU A 229      78.723  35.112  53.379  1.00 18.33           C  
ATOM   1660  C   GLU A 229      78.061  33.832  53.891  1.00 17.73           C  
ATOM   1661  O   GLU A 229      76.909  33.544  53.565  1.00 16.12           O  
ATOM   1662  CB  GLU A 229      79.577  34.781  52.149  1.00 19.33           C  
ATOM   1663  CG  GLU A 229      80.144  35.993  51.415  1.00 25.12           C  
ATOM   1664  CD  GLU A 229      81.174  36.757  52.232  1.00 26.14           C  
ATOM   1665  OE1 GLU A 229      82.171  36.142  52.664  1.00 26.19           O  
ATOM   1666  OE2 GLU A 229      80.989  37.977  52.436  1.00 27.93           O  
ATOM   1667  N   GLN A 230      78.798  33.067  54.693  1.00 15.44           N  
ATOM   1668  CA  GLN A 230      78.277  31.824  55.244  1.00 14.23           C  
ATOM   1669  C   GLN A 230      77.166  32.130  56.237  1.00 13.55           C  
ATOM   1670  O   GLN A 230      76.091  31.538  56.179  1.00 14.26           O  
ATOM   1671  CB  GLN A 230      79.407  31.025  55.911  1.00 13.97           C  
ATOM   1672  CG  GLN A 230      80.352  30.382  54.895  1.00 15.57           C  
ATOM   1673  CD  GLN A 230      81.671  29.924  55.493  1.00 14.71           C  
ATOM   1674  OE1 GLN A 230      81.906  30.053  56.695  1.00 13.14           O  
ATOM   1675  NE2 GLN A 230      82.542  29.383  54.649  1.00 13.43           N  
ATOM   1676  N   LEU A 231      77.422  33.072  57.137  1.00 14.50           N  
ATOM   1677  CA  LEU A 231      76.430  33.460  58.135  1.00 13.75           C  
ATOM   1678  C   LEU A 231      75.194  34.055  57.460  1.00 14.20           C  
ATOM   1679  O   LEU A 231      74.066  33.889  57.937  1.00 12.20           O  
ATOM   1680  CB  LEU A 231      77.046  34.465  59.106  1.00 14.08           C  
ATOM   1681  CG  LEU A 231      78.182  33.856  59.933  1.00 14.31           C  
ATOM   1682  CD1 LEU A 231      78.871  34.938  60.758  1.00 14.81           C  
ATOM   1683  CD2 LEU A 231      77.610  32.771  60.847  1.00 14.32           C  
ATOM   1684  N   GLY A 232      75.413  34.750  56.348  1.00 15.36           N  
ATOM   1685  CA  GLY A 232      74.299  35.324  55.619  1.00 13.57           C  
ATOM   1686  C   GLY A 232      73.494  34.169  55.061  1.00 12.70           C  
ATOM   1687  O   GLY A 232      72.269  34.167  55.125  1.00 13.58           O  
ATOM   1688  N   GLY A 233      74.201  33.176  54.523  1.00 14.19           N  
ATOM   1689  CA  GLY A 233      73.545  32.009  53.958  1.00 13.73           C  
ATOM   1690  C   GLY A 233      72.756  31.262  55.009  1.00 11.84           C  
ATOM   1691  O   GLY A 233      71.684  30.715  54.739  1.00 13.26           O  
ATOM   1692  N   THR A 234      73.290  31.247  56.224  1.00 12.21           N  
ATOM   1693  CA  THR A 234      72.632  30.575  57.330  1.00 12.66           C  
ATOM   1694  C   THR A 234      71.335  31.312  57.680  1.00 13.56           C  
ATOM   1695  O   THR A 234      70.295  30.686  57.901  1.00 13.51           O  
ATOM   1696  CB  THR A 234      73.571  30.517  58.557  1.00 15.35           C  
ATOM   1697  OG1 THR A 234      74.732  29.741  58.227  1.00 17.23           O  
ATOM   1698  CG2 THR A 234      72.867  29.888  59.745  1.00 13.50           C  
ATOM   1699  N   ALA A 235      71.397  32.644  57.713  1.00 12.04           N  
ATOM   1700  CA  ALA A 235      70.226  33.454  58.016  1.00 11.24           C  
ATOM   1701  C   ALA A 235      69.167  33.230  56.941  1.00 12.98           C  
ATOM   1702  O   ALA A 235      67.982  33.114  57.240  1.00 12.40           O  
ATOM   1703  CB  ALA A 235      70.607  34.935  58.081  1.00  9.80           C  
ATOM   1704  N   VAL A 236      69.605  33.164  55.684  1.00 14.63           N  
ATOM   1705  CA  VAL A 236      68.687  32.943  54.573  1.00 13.87           C  
ATOM   1706  C   VAL A 236      67.957  31.613  54.753  1.00 14.15           C  
ATOM   1707  O   VAL A 236      66.762  31.509  54.477  1.00 14.03           O  
ATOM   1708  CB  VAL A 236      69.440  32.955  53.216  1.00 14.87           C  
ATOM   1709  CG1 VAL A 236      68.514  32.502  52.093  1.00 17.60           C  
ATOM   1710  CG2 VAL A 236      69.947  34.357  52.926  1.00 14.77           C  
ATOM   1711  N   PHE A 237      68.671  30.594  55.225  1.00 14.04           N  
ATOM   1712  CA  PHE A 237      68.048  29.293  55.438  1.00 13.18           C  
ATOM   1713  C   PHE A 237      66.968  29.386  56.519  1.00 13.32           C  
ATOM   1714  O   PHE A 237      65.839  28.914  56.333  1.00 11.05           O  
ATOM   1715  CB  PHE A 237      69.097  28.252  55.846  1.00 14.28           C  
ATOM   1716  CG  PHE A 237      68.500  26.946  56.307  1.00 15.49           C  
ATOM   1717  CD1 PHE A 237      67.810  26.125  55.415  1.00 15.44           C  
ATOM   1718  CD2 PHE A 237      68.576  26.567  57.647  1.00 15.47           C  
ATOM   1719  CE1 PHE A 237      67.194  24.944  55.850  1.00 19.40           C  
ATOM   1720  CE2 PHE A 237      67.962  25.383  58.096  1.00 16.81           C  
ATOM   1721  CZ  PHE A 237      67.270  24.573  57.196  1.00 17.66           C  
ATOM   1722  N   LEU A 238      67.318  30.007  57.645  1.00 15.81           N  
ATOM   1723  CA  LEU A 238      66.397  30.152  58.771  1.00 15.03           C  
ATOM   1724  C   LEU A 238      65.151  30.975  58.450  1.00 15.75           C  
ATOM   1725  O   LEU A 238      64.105  30.793  59.076  1.00 13.99           O  
ATOM   1726  CB  LEU A 238      67.121  30.775  59.968  1.00 15.84           C  
ATOM   1727  CG  LEU A 238      68.188  29.906  60.641  1.00 16.62           C  
ATOM   1728  CD1 LEU A 238      68.824  30.675  61.803  1.00 14.34           C  
ATOM   1729  CD2 LEU A 238      67.551  28.622  61.140  1.00 16.02           C  
ATOM   1730  N   ALA A 239      65.260  31.877  57.477  1.00 17.15           N  
ATOM   1731  CA  ALA A 239      64.125  32.712  57.096  1.00 15.69           C  
ATOM   1732  C   ALA A 239      63.255  32.027  56.047  1.00 16.54           C  
ATOM   1733  O   ALA A 239      62.177  32.520  55.714  1.00 15.10           O  
ATOM   1734  CB  ALA A 239      64.613  34.057  56.574  1.00 15.90           C  
ATOM   1735  N   SER A 240      63.725  30.893  55.533  1.00 17.15           N  
ATOM   1736  CA  SER A 240      62.997  30.129  54.520  1.00 17.60           C  
ATOM   1737  C   SER A 240      61.871  29.283  55.128  1.00 18.30           C  
ATOM   1738  O   SER A 240      61.860  29.014  56.333  1.00 17.44           O  
ATOM   1739  CB  SER A 240      63.954  29.205  53.766  1.00 18.68           C  
ATOM   1740  OG  SER A 240      64.355  28.116  54.583  1.00 15.13           O  
ATOM   1741  N   ASP A 241      60.927  28.857  54.294  1.00 17.11           N  
ATOM   1742  CA  ASP A 241      59.817  28.046  54.783  1.00 18.57           C  
ATOM   1743  C   ASP A 241      60.272  26.645  55.182  1.00 17.54           C  
ATOM   1744  O   ASP A 241      59.581  25.948  55.923  1.00 14.67           O  
ATOM   1745  CB  ASP A 241      58.698  27.960  53.738  1.00 22.24           C  
ATOM   1746  CG  ASP A 241      58.072  29.316  53.439  1.00 24.82           C  
ATOM   1747  OD1 ASP A 241      57.926  30.132  54.375  1.00 27.65           O  
ATOM   1748  OD2 ASP A 241      57.712  29.565  52.273  1.00 25.76           O  
ATOM   1749  N   ALA A 242      61.436  26.236  54.689  1.00 16.27           N  
ATOM   1750  CA  ALA A 242      61.968  24.925  55.033  1.00 17.68           C  
ATOM   1751  C   ALA A 242      62.276  24.896  56.534  1.00 17.18           C  
ATOM   1752  O   ALA A 242      62.273  23.833  57.155  1.00 17.94           O  
ATOM   1753  CB  ALA A 242      63.227  24.649  54.232  1.00 16.89           C  
ATOM   1754  N   ALA A 243      62.529  26.070  57.112  1.00 16.59           N  
ATOM   1755  CA  ALA A 243      62.846  26.181  58.536  1.00 15.75           C  
ATOM   1756  C   ALA A 243      61.649  26.638  59.373  1.00 14.87           C  
ATOM   1757  O   ALA A 243      61.821  27.188  60.460  1.00 12.04           O  
ATOM   1758  CB  ALA A 243      64.014  27.154  58.732  1.00 16.94           C  
ATOM   1759  N   ALA A 244      60.442  26.394  58.866  1.00 14.76           N  
ATOM   1760  CA  ALA A 244      59.212  26.790  59.547  1.00 13.95           C  
ATOM   1761  C   ALA A 244      59.087  26.170  60.935  1.00 13.90           C  
ATOM   1762  O   ALA A 244      58.511  26.768  61.844  1.00 11.27           O  
ATOM   1763  CB  ALA A 244      57.996  26.408  58.696  1.00 14.48           C  
ATOM   1764  N   GLN A 245      59.613  24.963  61.097  1.00 12.45           N  
ATOM   1765  CA  GLN A 245      59.519  24.307  62.387  1.00 12.58           C  
ATOM   1766  C   GLN A 245      60.834  24.296  63.160  1.00 11.42           C  
ATOM   1767  O   GLN A 245      60.997  23.539  64.118  1.00 12.38           O  
ATOM   1768  CB  GLN A 245      58.968  22.891  62.224  1.00 13.21           C  
ATOM   1769  CG  GLN A 245      57.494  22.845  61.797  1.00 13.16           C  
ATOM   1770  CD  GLN A 245      56.595  23.754  62.634  1.00 13.92           C  
ATOM   1771  OE1 GLN A 245      56.736  23.846  63.858  1.00 14.35           O  
ATOM   1772  NE2 GLN A 245      55.655  24.417  61.974  1.00 11.03           N  
ATOM   1773  N   ILE A 246      61.777  25.122  62.722  1.00 10.56           N  
ATOM   1774  CA  ILE A 246      63.048  25.267  63.423  1.00  9.90           C  
ATOM   1775  C   ILE A 246      62.822  26.517  64.282  1.00 10.36           C  
ATOM   1776  O   ILE A 246      62.755  27.633  63.758  1.00  7.78           O  
ATOM   1777  CB  ILE A 246      64.229  25.542  62.454  1.00  9.30           C  
ATOM   1778  CG1 ILE A 246      64.518  24.307  61.594  1.00  8.59           C  
ATOM   1779  CG2 ILE A 246      65.465  25.945  63.249  1.00 11.44           C  
ATOM   1780  CD1 ILE A 246      65.715  24.481  60.637  1.00 10.87           C  
ATOM   1781  N   THR A 247      62.680  26.342  65.591  1.00  9.31           N  
ATOM   1782  CA  THR A 247      62.456  27.493  66.458  1.00 11.48           C  
ATOM   1783  C   THR A 247      62.926  27.211  67.889  1.00 12.38           C  
ATOM   1784  O   THR A 247      62.869  26.070  68.362  1.00 12.60           O  
ATOM   1785  CB  THR A 247      60.954  27.898  66.453  1.00 10.67           C  
ATOM   1786  OG1 THR A 247      60.795  29.195  67.046  1.00  9.16           O  
ATOM   1787  CG2 THR A 247      60.123  26.887  67.230  1.00 11.13           C  
ATOM   1788  N   GLY A 248      63.399  28.255  68.567  1.00 11.62           N  
ATOM   1789  CA  GLY A 248      63.890  28.111  69.928  1.00 11.20           C  
ATOM   1790  C   GLY A 248      65.201  27.348  70.002  1.00 12.76           C  
ATOM   1791  O   GLY A 248      65.510  26.719  71.022  1.00 10.57           O  
ATOM   1792  N   THR A 249      65.995  27.408  68.937  1.00 13.15           N  
ATOM   1793  CA  THR A 249      67.251  26.669  68.935  1.00 14.23           C  
ATOM   1794  C   THR A 249      68.481  27.486  68.524  1.00 14.09           C  
ATOM   1795  O   THR A 249      68.397  28.682  68.235  1.00 13.34           O  
ATOM   1796  CB  THR A 249      67.133  25.435  68.020  1.00 16.45           C  
ATOM   1797  OG1 THR A 249      68.147  24.482  68.366  1.00 19.31           O  
ATOM   1798  CG2 THR A 249      67.293  25.840  66.560  1.00 15.12           C  
ATOM   1799  N   THR A 250      69.630  26.824  68.527  1.00 14.03           N  
ATOM   1800  CA  THR A 250      70.885  27.454  68.148  1.00 15.60           C  
ATOM   1801  C   THR A 250      71.460  26.750  66.926  1.00 16.70           C  
ATOM   1802  O   THR A 250      71.312  25.535  66.763  1.00 17.56           O  
ATOM   1803  CB  THR A 250      71.937  27.387  69.304  1.00 16.98           C  
ATOM   1804  OG1 THR A 250      71.998  26.052  69.822  1.00 18.07           O  
ATOM   1805  CG2 THR A 250      71.573  28.338  70.433  1.00 15.62           C  
ATOM   1806  N   VAL A 251      72.097  27.520  66.052  1.00 16.78           N  
ATOM   1807  CA  VAL A 251      72.730  26.954  64.875  1.00 14.25           C  
ATOM   1808  C   VAL A 251      74.196  27.352  64.962  1.00 12.68           C  
ATOM   1809  O   VAL A 251      74.565  28.488  64.666  1.00 10.57           O  
ATOM   1810  CB  VAL A 251      72.135  27.498  63.554  1.00 16.19           C  
ATOM   1811  CG1 VAL A 251      72.908  26.920  62.367  1.00 15.63           C  
ATOM   1812  CG2 VAL A 251      70.664  27.112  63.440  1.00 16.41           C  
ATOM   1813  N   SER A 252      75.029  26.416  65.398  1.00 12.43           N  
ATOM   1814  CA  SER A 252      76.454  26.690  65.534  1.00 12.60           C  
ATOM   1815  C   SER A 252      77.189  26.664  64.207  1.00 11.00           C  
ATOM   1816  O   SER A 252      77.113  25.689  63.470  1.00 14.43           O  
ATOM   1817  CB  SER A 252      77.105  25.686  66.487  1.00 10.80           C  
ATOM   1818  OG  SER A 252      76.758  25.965  67.831  1.00 11.20           O  
ATOM   1819  N   VAL A 253      77.896  27.753  63.918  1.00 12.38           N  
ATOM   1820  CA  VAL A 253      78.711  27.891  62.713  1.00 11.20           C  
ATOM   1821  C   VAL A 253      80.072  28.219  63.317  1.00 13.05           C  
ATOM   1822  O   VAL A 253      80.496  29.374  63.330  1.00 13.43           O  
ATOM   1823  CB  VAL A 253      78.249  29.073  61.836  1.00  9.53           C  
ATOM   1824  CG1 VAL A 253      79.027  29.087  60.531  1.00  8.28           C  
ATOM   1825  CG2 VAL A 253      76.746  28.969  61.562  1.00 10.20           C  
ATOM   1826  N   ASP A 254      80.756  27.195  63.814  1.00 12.17           N  
ATOM   1827  CA  ASP A 254      82.030  27.417  64.487  1.00 12.13           C  
ATOM   1828  C   ASP A 254      83.201  26.498  64.143  1.00 10.60           C  
ATOM   1829  O   ASP A 254      84.134  26.367  64.935  1.00 13.67           O  
ATOM   1830  CB  ASP A 254      81.795  27.369  66.002  1.00  9.82           C  
ATOM   1831  CG  ASP A 254      81.210  26.043  66.463  1.00 11.04           C  
ATOM   1832  OD1 ASP A 254      81.313  25.040  65.719  1.00  9.27           O  
ATOM   1833  OD2 ASP A 254      80.652  26.000  67.579  1.00 12.16           O  
ATOM   1834  N   GLY A 255      83.165  25.860  62.980  1.00 11.55           N  
ATOM   1835  CA  GLY A 255      84.262  24.982  62.601  1.00 11.36           C  
ATOM   1836  C   GLY A 255      84.608  23.885  63.601  1.00 10.59           C  
ATOM   1837  O   GLY A 255      85.748  23.422  63.638  1.00  9.86           O  
ATOM   1838  N   GLY A 256      83.637  23.476  64.415  1.00  9.45           N  
ATOM   1839  CA  GLY A 256      83.873  22.416  65.391  1.00 10.79           C  
ATOM   1840  C   GLY A 256      84.168  22.853  66.818  1.00 11.34           C  
ATOM   1841  O   GLY A 256      84.381  22.018  67.698  1.00 11.02           O  
ATOM   1842  N   TRP A 257      84.172  24.162  67.045  1.00  9.37           N  
ATOM   1843  CA  TRP A 257      84.459  24.739  68.358  1.00 10.36           C  
ATOM   1844  C   TRP A 257      83.707  24.055  69.500  1.00 10.36           C  
ATOM   1845  O   TRP A 257      84.312  23.613  70.465  1.00  9.96           O  
ATOM   1846  CB  TRP A 257      84.102  26.226  68.326  1.00 11.05           C  
ATOM   1847  CG  TRP A 257      84.474  27.063  69.519  1.00 13.53           C  
ATOM   1848  CD1 TRP A 257      84.374  26.722  70.842  1.00 12.75           C  
ATOM   1849  CD2 TRP A 257      84.864  28.445  69.493  1.00 13.64           C  
ATOM   1850  NE1 TRP A 257      84.665  27.809  71.634  1.00 15.37           N  
ATOM   1851  CE2 TRP A 257      84.969  28.879  70.833  1.00 15.00           C  
ATOM   1852  CE3 TRP A 257      85.127  29.358  68.464  1.00 13.97           C  
ATOM   1853  CZ2 TRP A 257      85.327  30.192  71.173  1.00 15.75           C  
ATOM   1854  CZ3 TRP A 257      85.482  30.668  68.801  1.00 16.67           C  
ATOM   1855  CH2 TRP A 257      85.578  31.070  70.147  1.00 15.55           C  
ATOM   1856  N   THR A 258      82.386  23.977  69.376  1.00 10.29           N  
ATOM   1857  CA  THR A 258      81.534  23.393  70.403  1.00  9.90           C  
ATOM   1858  C   THR A 258      81.379  21.864  70.388  1.00 10.87           C  
ATOM   1859  O   THR A 258      80.671  21.306  71.224  1.00 12.02           O  
ATOM   1860  CB  THR A 258      80.137  24.052  70.359  1.00 11.21           C  
ATOM   1861  OG1 THR A 258      79.624  23.994  69.024  1.00 10.95           O  
ATOM   1862  CG2 THR A 258      80.221  25.525  70.789  1.00  9.21           C  
ATOM   1863  N   ALA A 259      82.038  21.187  69.450  1.00  8.91           N  
ATOM   1864  CA  ALA A 259      81.964  19.728  69.368  1.00 10.35           C  
ATOM   1865  C   ALA A 259      82.885  19.054  70.386  1.00 10.43           C  
ATOM   1866  O   ALA A 259      82.641  17.921  70.805  1.00 12.28           O  
ATOM   1867  CB  ALA A 259      82.321  19.264  67.957  1.00 11.61           C  
ATOM   1868  N   ARG A 260      83.940  19.754  70.788  1.00 10.91           N  
ATOM   1869  CA  ARG A 260      84.891  19.213  71.754  1.00 10.47           C  
ATOM   1870  C   ARG A 260      84.841  20.007  73.067  1.00 10.39           C  
ATOM   1871  O   ARG A 260      85.479  19.594  74.059  1.00  9.92           O  
ATOM   1872  CB  ARG A 260      86.305  19.242  71.162  1.00 10.70           C  
ATOM   1873  CG  ARG A 260      86.801  20.627  70.769  1.00 10.19           C  
ATOM   1874  CD  ARG A 260      88.187  20.558  70.141  1.00 14.46           C  
ATOM   1875  NE  ARG A 260      88.742  21.893  69.924  1.00 17.00           N  
ATOM   1876  CZ  ARG A 260      89.888  22.141  69.296  1.00 18.06           C  
ATOM   1877  NH1 ARG A 260      90.615  21.138  68.813  1.00 15.50           N  
ATOM   1878  NH2 ARG A 260      90.308  23.396  69.154  1.00 17.73           N  
ATOM   1879  OXT ARG A 260      84.145  21.038  73.086  1.00 12.55           O  
TER    1880      ARG A 260                                                      
END
MOLECULE T0511.pdb
ATOM   3951  N   MET     1      62.597  29.220  47.107  1.00 30.67           N  
ATOM   3952  CA  MET     1      62.845  29.811  48.467  1.00 29.57           C  
ATOM   3953  C   MET     1      63.620  31.132  48.359  1.00 27.36           C  
ATOM   3954  O   MET     1      64.850  31.137  48.239  1.00 28.85           O  
ATOM   3955  CB  MET     1      63.591  28.807  49.357  1.00 29.94           C  
ATOM   3956  N   THR     2      62.877  32.239  48.391  1.00 25.23           N  
ATOM   3957  CA  THR     2      63.403  33.587  48.132  1.00 22.67           C  
ATOM   3958  C   THR     2      62.942  34.592  49.198  1.00 18.88           C  
ATOM   3959  O   THR     2      61.858  34.461  49.757  1.00 18.29           O  
ATOM   3960  CB  THR     2      62.903  34.135  46.760  1.00 23.35           C  
ATOM   3961  OG1 THR     2      63.359  35.463  46.573  1.00 25.88           O  
ATOM   3962  CG2 THR     2      61.378  34.171  46.691  1.00 26.28           C  
ATOM   3963  N   LEU     3      63.760  35.618  49.440  1.00 15.02           N  
ATOM   3964  CA  LEU     3      63.374  36.703  50.340  1.00 13.66           C  
ATOM   3965  C   LEU     3      62.820  37.921  49.572  1.00 13.56           C  
ATOM   3966  O   LEU     3      62.745  39.020  50.112  1.00 12.43           O  
ATOM   3967  CB  LEU     3      64.547  37.093  51.236  1.00 12.07           C  
ATOM   3968  CG  LEU     3      64.994  35.993  52.218  1.00 11.15           C  
ATOM   3969  CD1 LEU     3      66.181  36.444  53.005  1.00 13.04           C  
ATOM   3970  CD2 LEU     3      63.855  35.585  53.148  1.00 10.48           C  
ATOM   3971  N   SER     4      62.447  37.723  48.314  1.00 14.77           N  
ATOM   3972  CA  SER     4      61.853  38.795  47.519  1.00 15.97           C  
ATOM   3973  C   SER     4      60.660  39.433  48.243  1.00 15.52           C  
ATOM   3974  O   SER     4      59.745  38.745  48.654  1.00 16.06           O  
ATOM   3975  CB  SER     4      61.389  38.288  46.155  1.00 16.75           C  
ATOM   3976  OG  SER     4      60.927  39.377  45.373  1.00 20.08           O  
ATOM   3977  N   GLY     5      60.704  40.757  48.393  1.00 15.66           N  
ATOM   3978  CA  GLY     5      59.619  41.521  48.999  1.00 15.02           C  
ATOM   3979  C   GLY     5      59.535  41.413  50.510  1.00 14.21           C  
ATOM   3980  O   GLY     5      58.676  42.070  51.125  1.00 15.43           O  
ATOM   3981  N   LYS     6      60.352  40.543  51.108  1.00 11.75           N  
ATOM   3982  CA  LYS     6      60.416  40.422  52.563  0.50 11.20           C  
ATOM   3984  C   LYS     6      61.177  41.607  53.131  1.00 12.33           C  
ATOM   3985  O   LYS     6      62.113  42.107  52.491  1.00 12.97           O  
ATOM   3986  CB  LYS     6      61.116  39.131  52.979  0.50 10.32           C  
ATOM   3988  CG  LYS     6      60.442  37.856  52.511  0.50  9.52           C  
ATOM   3990  CD  LYS     6      59.018  37.773  53.017  0.50  8.56           C  
ATOM   3992  CE  LYS     6      58.396  36.430  52.773  0.50  9.59           C  
ATOM   3994  NZ  LYS     6      56.954  36.413  53.165  0.50  8.36           N  
ATOM   3996  N   THR     7      60.795  42.032  54.333  1.00 11.54           N  
ATOM   3997  CA  THR     7      61.404  43.157  54.998  1.00 10.57           C  
ATOM   3998  C   THR     7      62.191  42.674  56.216  1.00 10.31           C  
ATOM   3999  O   THR     7      61.606  42.122  57.185  1.00  8.12           O  
ATOM   4000  CB  THR     7      60.336  44.191  55.400  1.00 10.97           C  
ATOM   4001  OG1 THR     7      59.628  44.627  54.224  1.00 11.12           O  
ATOM   4002  CG2 THR     7      60.981  45.397  56.117  1.00 11.35           C  
ATOM   4003  N   LEU     8      63.515  42.880  56.149  1.00  9.48           N  
ATOM   4004  CA  LEU     8      64.441  42.550  57.221  1.00  9.12           C  
ATOM   4005  C   LEU     8      64.855  43.800  57.995  1.00 10.02           C  
ATOM   4006  O   LEU     8      65.154  44.847  57.421  1.00  9.93           O  
ATOM   4007  CB  LEU     8      65.726  41.895  56.666  1.00  8.69           C  
ATOM   4008  CG  LEU     8      65.617  40.506  56.031  1.00  8.91           C  
ATOM   4009  CD1 LEU     8      64.948  40.526  54.667  1.00  9.80           C  
ATOM   4010  CD2 LEU     8      67.019  39.850  55.945  1.00 10.15           C  
ATOM   4011  N   PHE     9      64.864  43.671  59.311  1.00 10.64           N  
ATOM   4012  CA  PHE     9      65.393  44.701  60.193  1.00  9.82           C  
ATOM   4013  C   PHE     9      66.642  44.075  60.792  1.00 10.33           C  
ATOM   4014  O   PHE     9      66.556  43.086  61.518  1.00  9.34           O  
ATOM   4015  CB  PHE     9      64.353  45.039  61.271  1.00 11.76           C  
ATOM   4016  CG  PHE     9      64.736  46.193  62.169  1.00 11.01           C  
ATOM   4017  CD1 PHE     9      64.214  47.476  61.952  1.00 11.20           C  
ATOM   4018  CD2 PHE     9      65.612  45.997  63.246  1.00 11.20           C  
ATOM   4019  CE1 PHE     9      64.545  48.541  62.804  1.00 12.34           C  
ATOM   4020  CE2 PHE     9      65.972  47.059  64.072  1.00 11.47           C  
ATOM   4021  CZ  PHE     9      65.421  48.337  63.851  1.00 12.34           C  
ATOM   4022  N   ILE    10      67.804  44.632  60.449  1.00  9.68           N  
ATOM   4023  CA  ILE    10      69.085  44.043  60.842  1.00  8.82           C  
ATOM   4024  C   ILE    10      69.875  45.048  61.639  1.00  9.31           C  
ATOM   4025  O   ILE    10      70.190  46.135  61.158  1.00  8.86           O  
ATOM   4026  CB  ILE    10      69.954  43.569  59.614  1.00  8.91           C  
ATOM   4027  CG1 ILE    10      69.161  42.655  58.682  1.00  9.64           C  
ATOM   4028  CG2 ILE    10      71.253  42.869  60.098  1.00  9.55           C  
ATOM   4029  CD1 ILE    10      69.891  42.285  57.434  1.00  8.87           C  
ATOM   4030  N   THR    11      70.176  44.703  62.881  1.00  9.12           N  
ATOM   4031  CA  THR    11      71.002  45.584  63.719  1.00 10.75           C  
ATOM   4032  C   THR    11      72.490  45.424  63.375  1.00 10.49           C  
ATOM   4033  O   THR    11      72.965  44.333  63.011  1.00 12.33           O  
ATOM   4034  CB  THR    11      70.774  45.336  65.236  1.00 11.13           C  
ATOM   4035  OG1 THR    11      71.224  44.025  65.597  1.00  9.91           O  
ATOM   4036  CG2 THR    11      69.289  45.513  65.589  1.00 11.16           C  
ATOM   4037  N   GLY    12      73.205  46.541  63.433  1.00 11.26           N  
ATOM   4038  CA  GLY    12      74.650  46.585  63.240  1.00 11.66           C  
ATOM   4039  C   GLY    12      75.115  46.237  61.835  1.00 12.20           C  
ATOM   4040  O   GLY    12      76.236  45.796  61.663  1.00 14.31           O  
ATOM   4041  N   ALA    13      74.276  46.482  60.830  1.00 10.74           N  
ATOM   4042  CA  ALA    13      74.524  46.028  59.465  1.00 10.80           C  
ATOM   4043  C   ALA    13      75.251  47.052  58.569  1.00  9.89           C  
ATOM   4044  O   ALA    13      75.175  46.977  57.349  1.00 10.74           O  
ATOM   4045  CB  ALA    13      73.213  45.535  58.805  1.00 12.85           C  
ATOM   4046  N   SER    14      75.957  47.997  59.175  1.00 12.09           N  
ATOM   4047  CA  SER    14      76.826  48.908  58.410  1.00 13.18           C  
ATOM   4048  C   SER    14      78.103  48.221  57.906  1.00 13.87           C  
ATOM   4049  O   SER    14      78.781  48.720  56.992  1.00 14.18           O  
ATOM   4050  CB  SER    14      77.178  50.138  59.246  1.00 14.38           C  
ATOM   4051  OG  SER    14      77.783  49.759  60.460  1.00 17.14           O  
ATOM   4052  N   ARG    15      78.431  47.075  58.494  1.00 13.35           N  
ATOM   4053  CA  ARG    15      79.640  46.338  58.149  1.00 13.18           C  
ATOM   4054  C   ARG    15      79.528  44.878  58.620  1.00 13.07           C  
ATOM   4055  O   ARG    15      78.533  44.479  59.249  1.00 11.22           O  
ATOM   4056  CB  ARG    15      80.874  47.012  58.788  1.00 14.09           C  
ATOM   4057  CG  ARG    15      80.918  46.971  60.285  1.00 14.31           C  
ATOM   4058  CD  ARG    15      82.066  47.857  60.818  1.00 17.37           C  
ATOM   4059  NE  ARG    15      81.762  49.280  60.653  1.00 20.79           N  
ATOM   4060  CZ  ARG    15      81.012  49.990  61.486  1.00 20.72           C  
ATOM   4061  NH1 ARG    15      80.496  49.435  62.579  1.00 22.67           N  
ATOM   4062  NH2 ARG    15      80.782  51.263  61.236  1.00 20.56           N  
ATOM   4063  N   GLY    16      80.556  44.099  58.288  1.00 11.96           N  
ATOM   4064  CA  GLY    16      80.736  42.761  58.825  1.00 12.69           C  
ATOM   4065  C   GLY    16      79.604  41.803  58.491  1.00 10.91           C  
ATOM   4066  O   GLY    16      79.052  41.809  57.374  1.00 10.91           O  
ATOM   4067  N   ILE    17      79.280  40.958  59.460  1.00 11.51           N  
ATOM   4068  CA  ILE    17      78.291  39.912  59.250  1.00  9.32           C  
ATOM   4069  C   ILE    17      76.913  40.500  58.910  1.00  8.38           C  
ATOM   4070  O   ILE    17      76.253  40.004  58.023  1.00  7.43           O  
ATOM   4071  CB  ILE    17      78.222  38.953  60.470  1.00  9.84           C  
ATOM   4072  CG1 ILE    17      79.519  38.155  60.560  1.00 10.94           C  
ATOM   4073  CG2 ILE    17      77.030  37.970  60.375  1.00 10.76           C  
ATOM   4074  CD1 ILE    17      79.657  37.339  61.859  1.00 12.58           C  
ATOM   4075  N   GLY    18      76.494  41.539  59.618  1.00  8.76           N  
ATOM   4076  CA  GLY    18      75.170  42.138  59.368  1.00  8.15           C  
ATOM   4077  C   GLY    18      75.044  42.616  57.936  1.00  7.27           C  
ATOM   4078  O   GLY    18      74.060  42.340  57.263  1.00  8.56           O  
ATOM   4079  N   LEU    19      76.062  43.340  57.467  1.00  7.75           N  
ATOM   4080  CA  LEU    19      76.102  43.810  56.092  1.00  9.23           C  
ATOM   4081  C   LEU    19      76.014  42.632  55.116  1.00  8.73           C  
ATOM   4082  O   LEU    19      75.266  42.671  54.144  1.00  9.26           O  
ATOM   4083  CB  LEU    19      77.365  44.651  55.841  1.00  8.49           C  
ATOM   4084  CG  LEU    19      77.475  45.222  54.395  1.00  8.05           C  
ATOM   4085  CD1 LEU    19      76.268  46.087  54.030  1.00 11.07           C  
ATOM   4086  CD2 LEU    19      78.799  45.972  54.238  1.00 11.71           C  
ATOM   4087  N   ALA    20      76.790  41.575  55.363  1.00  8.21           N  
ATOM   4088  CA  ALA    20      76.818  40.418  54.466  1.00  8.31           C  
ATOM   4089  C   ALA    20      75.430  39.785  54.378  1.00  7.74           C  
ATOM   4090  O   ALA    20      74.958  39.458  53.296  1.00  8.04           O  
ATOM   4091  CB  ALA    20      77.848  39.389  54.944  1.00  9.02           C  
ATOM   4092  N   ILE    21      74.772  39.669  55.523  1.00  8.02           N  
ATOM   4093  CA  ILE    21      73.404  39.147  55.571  1.00  8.70           C  
ATOM   4094  C   ILE    21      72.490  40.086  54.769  1.00  8.63           C  
ATOM   4095  O   ILE    21      71.714  39.628  53.907  1.00  8.84           O  
ATOM   4096  CB  ILE    21      72.906  38.984  57.042  1.00  9.05           C  
ATOM   4097  CG1 ILE    21      73.668  37.891  57.784  1.00  7.45           C  
ATOM   4098  CG2 ILE    21      71.394  38.697  57.078  1.00  9.46           C  
ATOM   4099  CD1 ILE    21      73.339  37.846  59.303  1.00  8.85           C  
ATOM   4100  N   ALA    22      72.600  41.392  55.039  1.00  9.08           N  
ATOM   4101  CA  ALA    22      71.824  42.423  54.318  1.00  9.76           C  
ATOM   4102  C   ALA    22      71.958  42.242  52.788  1.00  8.59           C  
ATOM   4103  O   ALA    22      70.958  42.201  52.041  1.00  9.38           O  
ATOM   4104  CB  ALA    22      72.254  43.834  54.777  1.00  7.10           C  
ATOM   4105  N   LEU    23      73.188  42.058  52.311  1.00  8.83           N  
ATOM   4106  CA  LEU    23      73.424  41.979  50.858  1.00  9.35           C  
ATOM   4107  C   LEU    23      72.947  40.652  50.243  1.00  8.93           C  
ATOM   4108  O   LEU    23      72.440  40.619  49.090  1.00  8.82           O  
ATOM   4109  CB  LEU    23      74.888  42.229  50.554  1.00  9.38           C  
ATOM   4110  CG  LEU    23      75.440  43.596  50.959  1.00  9.38           C  
ATOM   4111  CD1 LEU    23      76.913  43.699  50.547  1.00 11.14           C  
ATOM   4112  CD2 LEU    23      74.585  44.776  50.392  1.00 12.49           C  
ATOM   4113  N   ARG    24      73.082  39.565  50.998  1.00  6.98           N  
ATOM   4114  CA  ARG    24      72.578  38.277  50.524  1.00 10.03           C  
ATOM   4115  C   ARG    24      71.052  38.351  50.351  1.00  9.92           C  
ATOM   4116  O   ARG    24      70.492  37.887  49.372  1.00 10.75           O  
ATOM   4117  CB  ARG    24      72.987  37.137  51.457  1.00 10.79           C  
ATOM   4118  CG  ARG    24      72.449  35.755  51.043  1.00 11.75           C  
ATOM   4119  CD  ARG    24      72.954  35.280  49.687  1.00 13.28           C  
ATOM   4120  NE  ARG    24      72.271  34.075  49.201  1.00 14.92           N  
ATOM   4121  CZ  ARG    24      71.136  34.057  48.499  1.00 13.41           C  
ATOM   4122  NH1 ARG    24      70.480  35.166  48.186  1.00 14.16           N  
ATOM   4123  NH2 ARG    24      70.644  32.898  48.090  1.00 15.36           N  
ATOM   4124  N   ALA    25      70.367  38.988  51.291  1.00  8.74           N  
ATOM   4125  CA  ALA    25      68.899  39.152  51.191  1.00  9.90           C  
ATOM   4126  C   ALA    25      68.517  40.102  50.028  1.00  9.92           C  
ATOM   4127  O   ALA    25      67.538  39.866  49.286  1.00 11.82           O  
ATOM   4128  CB  ALA    25      68.380  39.677  52.518  1.00  9.28           C  
ATOM   4129  N   ALA    26      69.281  41.190  49.901  1.00  9.89           N  
ATOM   4130  CA  ALA    26      69.099  42.193  48.822  1.00 10.10           C  
ATOM   4131  C   ALA    26      69.116  41.544  47.458  1.00 10.34           C  
ATOM   4132  O   ALA    26      68.316  41.889  46.578  1.00 11.34           O  
ATOM   4133  CB  ALA    26      70.148  43.259  48.872  1.00  9.94           C  
ATOM   4134  N   ARG    27      70.003  40.570  47.281  1.00 11.84           N  
ATOM   4135  CA  ARG    27      70.155  39.864  46.000  1.00 13.94           C  
ATOM   4136  C   ARG    27      68.850  39.211  45.538  1.00 14.38           C  
ATOM   4137  O   ARG    27      68.580  39.114  44.346  1.00 15.05           O  
ATOM   4138  CB  ARG    27      71.266  38.815  46.191  1.00 15.14           C  
ATOM   4139  CG  ARG    27      71.710  38.069  45.005  1.00 21.23           C  
ATOM   4140  CD  ARG    27      73.119  37.495  45.280  1.00 26.32           C  
ATOM   4141  NE  ARG    27      73.145  36.075  45.602  1.00 28.22           N  
ATOM   4142  CZ  ARG    27      74.087  35.472  46.333  1.00 29.94           C  
ATOM   4143  NH1 ARG    27      75.079  36.153  46.912  1.00 32.75           N  
ATOM   4144  NH2 ARG    27      74.015  34.172  46.523  1.00 31.76           N  
ATOM   4145  N   ASP    28      68.049  38.792  46.506  1.00 13.10           N  
ATOM   4146  CA  ASP    28      66.720  38.247  46.269  1.00 12.77           C  
ATOM   4147  C   ASP    28      65.638  39.307  46.007  1.00 12.75           C  
ATOM   4148  O   ASP    28      64.503  38.943  45.651  1.00 13.44           O  
ATOM   4149  CB  ASP    28      66.255  37.451  47.495  1.00 13.05           C  
ATOM   4150  CG  ASP    28      66.843  36.066  47.599  1.00 13.32           C  
ATOM   4151  OD1 ASP    28      67.775  35.704  46.843  1.00 14.41           O  
ATOM   4152  OD2 ASP    28      66.355  35.322  48.480  1.00 12.54           O  
ATOM   4153  N   GLY    29      65.935  40.587  46.231  1.00 10.11           N  
ATOM   4154  CA  GLY    29      64.912  41.654  46.146  1.00  9.93           C  
ATOM   4155  C   GLY    29      64.262  41.985  47.473  1.00 10.64           C  
ATOM   4156  O   GLY    29      63.130  42.494  47.518  1.00 12.32           O  
ATOM   4157  N   ALA    30      64.952  41.686  48.574  1.00  9.58           N  
ATOM   4158  CA  ALA    30      64.396  41.970  49.897  1.00  9.95           C  
ATOM   4159  C   ALA    30      64.521  43.470  50.182  1.00 10.01           C  
ATOM   4160  O   ALA    30      65.433  44.163  49.651  1.00  9.43           O  
ATOM   4161  CB  ALA    30      65.097  41.183  50.977  1.00  9.59           C  
ATOM   4162  N   ASN    31      63.610  43.950  51.029  1.00  9.52           N  
ATOM   4163  CA  ASN    31      63.752  45.233  51.686  1.00  9.86           C  
ATOM   4164  C   ASN    31      64.600  45.024  52.924  1.00  8.84           C  
ATOM   4165  O   ASN    31      64.373  44.084  53.690  1.00 10.54           O  
ATOM   4166  CB  ASN    31      62.386  45.773  52.119  1.00 10.20           C  
ATOM   4167  CG  ASN    31      61.383  45.795  50.986  1.00  9.19           C  
ATOM   4168  OD1 ASN    31      61.670  46.332  49.919  1.00 10.33           O  
ATOM   4169  ND2 ASN    31      60.167  45.261  51.237  1.00 10.75           N  
ATOM   4170  N   VAL    32      65.590  45.887  53.116  1.00  9.95           N  
ATOM   4171  CA  VAL    32      66.461  45.789  54.290  1.00  9.69           C  
ATOM   4172  C   VAL    32      66.596  47.133  55.012  1.00 10.30           C  
ATOM   4173  O   VAL    32      67.058  48.133  54.432  1.00 12.03           O  
ATOM   4174  CB  VAL    32      67.879  45.251  53.949  1.00  9.18           C  
ATOM   4175  CG1 VAL    32      68.643  44.975  55.249  1.00 11.10           C  
ATOM   4176  CG2 VAL    32      67.819  43.969  53.119  1.00 10.00           C  
ATOM   4177  N   ALA    33      66.191  47.150  56.277  1.00  9.49           N  
ATOM   4178  CA  ALA    33      66.381  48.263  57.162  1.00  9.13           C  
ATOM   4179  C   ALA    33      67.703  48.031  57.943  1.00 11.03           C  
ATOM   4180  O   ALA    33      67.848  47.054  58.690  1.00 10.96           O  
ATOM   4181  CB  ALA    33      65.140  48.420  58.106  1.00 10.39           C  
ATOM   4182  N   ILE    34      68.660  48.914  57.698  1.00  9.27           N  
ATOM   4183  CA  ILE    34      69.978  48.897  58.327  1.00 10.73           C  
ATOM   4184  C   ILE    34      69.911  49.779  59.555  1.00 10.74           C  
ATOM   4185  O   ILE    34      69.866  51.014  59.440  1.00 11.32           O  
ATOM   4186  CB  ILE    34      71.055  49.446  57.365  1.00 11.56           C  
ATOM   4187  CG1 ILE    34      71.079  48.663  56.046  1.00 12.76           C  
ATOM   4188  CG2 ILE    34      72.425  49.488  58.059  1.00 11.82           C  
ATOM   4189  CD1 ILE    34      71.623  47.273  56.171  1.00 15.51           C  
ATOM   4190  N   ALA    35      69.864  49.164  60.736  1.00 10.80           N  
ATOM   4191  CA  ALA    35      69.718  49.912  61.976  1.00 11.12           C  
ATOM   4192  C   ALA    35      71.054  49.915  62.714  1.00 12.35           C  
ATOM   4193  O   ALA    35      71.424  48.949  63.376  1.00 13.49           O  
ATOM   4194  CB  ALA    35      68.600  49.344  62.835  1.00 10.58           C  
ATOM   4195  N   ALA    36      71.772  51.019  62.600  1.00 12.61           N  
ATOM   4196  CA  ALA    36      73.119  51.086  63.144  1.00 13.43           C  
ATOM   4197  C   ALA    36      73.496  52.524  63.496  1.00 13.74           C  
ATOM   4198  O   ALA    36      72.828  53.477  63.065  1.00 11.72           O  
ATOM   4199  CB  ALA    36      74.102  50.509  62.158  1.00 11.42           C  
ATOM   4200  N   LYS    37      74.546  52.664  64.302  1.00 15.75           N  
ATOM   4201  CA  LYS    37      74.869  53.965  64.885  1.00 18.51           C  
ATOM   4202  C   LYS    37      75.644  54.902  63.963  1.00 18.21           C  
ATOM   4203  O   LYS    37      75.478  56.117  64.075  1.00 20.01           O  
ATOM   4204  CB  LYS    37      75.588  53.840  66.239  1.00 19.73           C  
ATOM   4205  CG  LYS    37      76.782  52.938  66.266  1.00 23.33           C  
ATOM   4206  CD  LYS    37      77.700  53.212  67.466  1.00 23.66           C  
ATOM   4207  CE  LYS    37      76.944  53.327  68.751  1.00 26.80           C  
ATOM   4208  NZ  LYS    37      76.411  54.714  68.945  1.00 28.42           N  
ATOM   4209  N   SER    38      76.463  54.352  63.059  1.00 18.12           N  
ATOM   4210  CA  SER    38      77.373  55.149  62.238  1.00 18.53           C  
ATOM   4211  C   SER    38      76.720  55.723  60.995  1.00 16.90           C  
ATOM   4212  O   SER    38      76.342  54.974  60.108  1.00 15.01           O  
ATOM   4213  CB  SER    38      78.574  54.307  61.790  1.00 19.20           C  
ATOM   4214  OG  SER    38      79.300  53.812  62.899  1.00 23.44           O  
ATOM   4215  N   ALA    39      76.652  57.057  60.934  1.00 17.63           N  
ATOM   4216  CA  ALA    39      76.100  57.802  59.800  1.00 17.44           C  
ATOM   4217  C   ALA    39      77.184  58.388  58.894  1.00 16.14           C  
ATOM   4218  O   ALA    39      76.980  58.563  57.700  1.00 16.68           O  
ATOM   4219  CB  ALA    39      75.168  58.905  60.301  1.00 18.43           C  
ATOM   4220  N   VAL    40      78.356  58.669  59.449  1.00 17.49           N  
ATOM   4221  CA  VAL    40      79.479  59.194  58.661  1.00 18.46           C  
ATOM   4222  C   VAL    40      80.694  58.310  58.896  1.00 20.70           C  
ATOM   4223  O   VAL    40      80.839  57.741  59.976  1.00 21.01           O  
ATOM   4224  CB  VAL    40      79.805  60.654  59.054  1.00 18.94           C  
ATOM   4225  CG1 VAL    40      78.557  61.514  58.972  1.00 17.23           C  
ATOM   4226  CG2 VAL    40      80.365  60.716  60.433  1.00 21.03           C  
ATOM   4227  N   ALA    41      81.549  58.211  57.880  1.00 23.79           N  
ATOM   4228  CA  ALA    41      82.672  57.275  57.846  1.00 27.02           C  
ATOM   4229  C   ALA    41      83.886  57.766  58.628  1.00 30.16           C  
ATOM   4230  O   ALA    41      84.101  58.958  58.765  1.00 29.60           O  
ATOM   4231  CB  ALA    41      83.078  57.029  56.414  1.00 26.45           C  
ATOM   4232  N   ASN    42      84.686  56.826  59.121  1.00 34.39           N  
ATOM   4233  CA  ASN    42      85.982  57.137  59.736  1.00 37.35           C  
ATOM   4234  C   ASN    42      87.024  56.189  59.163  1.00 37.86           C  
ATOM   4235  O   ASN    42      86.663  55.114  58.676  1.00 37.47           O  
ATOM   4236  CB  ASN    42      85.905  56.978  61.255  1.00 38.97           C  
ATOM   4237  CG  ASN    42      85.984  55.535  61.686  1.00 41.85           C  
ATOM   4238  OD1 ASN    42      85.250  54.679  61.176  1.00 45.32           O  
ATOM   4239  ND2 ASN    42      86.880  55.246  62.619  1.00 44.83           N  
ATOM   4240  N   PRO    43      88.319  56.571  59.222  1.00 39.25           N  
ATOM   4241  CA  PRO    43      89.357  55.734  58.596  1.00 39.71           C  
ATOM   4242  C   PRO    43      89.487  54.349  59.225  1.00 40.22           C  
ATOM   4243  O   PRO    43      89.883  53.401  58.539  1.00 41.70           O  
ATOM   4244  CB  PRO    43      90.651  56.529  58.828  1.00 40.04           C  
ATOM   4245  CG  PRO    43      90.363  57.413  59.989  1.00 40.12           C  
ATOM   4246  CD  PRO    43      88.895  57.761  59.874  1.00 39.62           C  
ATOM   4247  N   LYS    44      89.146  54.243  60.511  1.00 40.29           N  
ATOM   4248  CA  LYS    44      89.455  53.057  61.315  1.00 40.44           C  
ATOM   4249  C   LYS    44      88.515  51.890  61.049  1.00 40.27           C  
ATOM   4250  O   LYS    44      88.956  50.741  60.928  1.00 41.53           O  
ATOM   4251  CB  LYS    44      89.431  53.404  62.812  1.00 40.80           C  
ATOM   4252  N   LEU    45      87.222  52.178  60.972  1.00 39.05           N  
ATOM   4253  CA  LEU    45      86.218  51.131  60.866  1.00 37.50           C  
ATOM   4254  C   LEU    45      85.167  51.541  59.838  1.00 35.61           C  
ATOM   4255  O   LEU    45      84.102  52.037  60.207  1.00 36.83           O  
ATOM   4256  CB  LEU    45      85.583  50.908  62.238  1.00 38.08           C  
ATOM   4257  CG  LEU    45      84.656  49.705  62.386  1.00 39.22           C  
ATOM   4258  CD1 LEU    45      85.288  48.424  61.838  1.00 39.99           C  
ATOM   4259  CD2 LEU    45      84.277  49.533  63.845  1.00 40.21           C  
ATOM   4260  N   PRO    46      85.479  51.367  58.541  1.00 32.57           N  
ATOM   4261  CA  PRO    46      84.580  51.804  57.478  1.00 29.62           C  
ATOM   4262  C   PRO    46      83.181  51.163  57.498  1.00 25.47           C  
ATOM   4263  O   PRO    46      82.966  50.062  58.098  1.00 22.97           O  
ATOM   4264  CB  PRO    46      85.322  51.403  56.192  1.00 30.51           C  
ATOM   4265  CG  PRO    46      86.752  51.314  56.592  1.00 31.69           C  
ATOM   4266  CD  PRO    46      86.721  50.787  57.993  1.00 32.59           C  
ATOM   4267  N   GLY    47      82.267  51.872  56.828  1.00 20.24           N  
ATOM   4268  CA  GLY    47      80.893  51.466  56.666  1.00 17.13           C  
ATOM   4269  C   GLY    47      79.945  52.339  57.470  1.00 14.78           C  
ATOM   4270  O   GLY    47      80.178  52.610  58.646  1.00 14.21           O  
ATOM   4271  N   THR    48      78.845  52.748  56.854  1.00 12.11           N  
ATOM   4272  CA  THR    48      77.836  53.553  57.539  1.00 11.85           C  
ATOM   4273  C   THR    48      76.458  52.991  57.179  1.00 10.89           C  
ATOM   4274  O   THR    48      76.335  52.132  56.293  1.00 10.28           O  
ATOM   4275  CB  THR    48      77.887  55.017  57.087  1.00 11.91           C  
ATOM   4276  OG1 THR    48      77.440  55.084  55.728  1.00 11.31           O  
ATOM   4277  CG2 THR    48      79.309  55.580  57.219  1.00 10.23           C  
ATOM   4278  N   ILE    49      75.412  53.500  57.823  1.00 10.85           N  
ATOM   4279  CA  ILE    49      74.050  53.133  57.457  1.00 11.77           C  
ATOM   4280  C   ILE    49      73.758  53.496  55.991  1.00 11.48           C  
ATOM   4281  O   ILE    49      73.063  52.789  55.301  1.00 10.88           O  
ATOM   4282  CB  ILE    49      73.019  53.765  58.417  1.00 11.13           C  
ATOM   4283  CG1 ILE    49      73.116  55.306  58.420  1.00 10.53           C  
ATOM   4284  CG2 ILE    49      73.243  53.212  59.835  1.00 10.06           C  
ATOM   4285  CD1 ILE    49      72.142  56.006  59.385  1.00 12.06           C  
ATOM   4286  N   HIS    50      74.347  54.586  55.520  1.00 10.00           N  
ATOM   4287  CA  HIS    50      74.122  55.053  54.160  1.00 10.47           C  
ATOM   4288  C   HIS    50      74.872  54.216  53.113  1.00 10.35           C  
ATOM   4289  O   HIS    50      74.304  53.925  52.051  1.00 11.27           O  
ATOM   4290  CB  HIS    50      74.479  56.543  54.077  1.00 10.80           C  
ATOM   4291  CG  HIS    50      73.675  57.392  55.011  1.00 10.97           C  
ATOM   4292  ND1 HIS    50      72.304  57.486  54.923  1.00 12.42           N  
ATOM   4293  CD2 HIS    50      74.036  58.151  56.066  1.00 12.09           C  
ATOM   4294  CE1 HIS    50      71.858  58.265  55.888  1.00 12.60           C  
ATOM   4295  NE2 HIS    50      72.886  58.688  56.595  1.00 14.34           N  
ATOM   4296  N   SER    51      76.128  53.849  53.374  1.00 11.13           N  
ATOM   4297  CA  SER    51      76.866  53.008  52.407  1.00 11.05           C  
ATOM   4298  C   SER    51      76.184  51.617  52.353  1.00  9.62           C  
ATOM   4299  O   SER    51      76.037  51.007  51.281  1.00  9.84           O  
ATOM   4300  CB  SER    51      78.361  52.883  52.733  1.00 12.34           C  
ATOM   4301  OG  SER    51      78.583  52.345  54.001  1.00 11.91           O  
ATOM   4302  N   ALA    52      75.734  51.137  53.502  1.00  9.54           N  
ATOM   4303  CA  ALA    52      75.072  49.824  53.556  1.00  8.67           C  
ATOM   4304  C   ALA    52      73.733  49.851  52.804  1.00  9.08           C  
ATOM   4305  O   ALA    52      73.465  48.990  51.965  1.00 10.29           O  
ATOM   4306  CB  ALA    52      74.886  49.382  54.995  1.00  9.27           C  
ATOM   4307  N   ALA    53      72.915  50.878  53.043  1.00  9.71           N  
ATOM   4308  CA  ALA    53      71.666  51.040  52.278  1.00 10.36           C  
ATOM   4309  C   ALA    53      71.901  51.167  50.763  1.00  9.96           C  
ATOM   4310  O   ALA    53      71.181  50.566  49.976  1.00 11.61           O  
ATOM   4311  CB  ALA    53      70.844  52.230  52.790  1.00 10.97           C  
ATOM   4312  N   ALA    54      72.926  51.924  50.366  1.00 11.88           N  
ATOM   4313  CA  ALA    54      73.297  52.057  48.954  1.00 12.31           C  
ATOM   4314  C   ALA    54      73.722  50.707  48.347  1.00 11.30           C  
ATOM   4315  O   ALA    54      73.353  50.386  47.208  1.00 10.08           O  
ATOM   4316  CB  ALA    54      74.431  53.098  48.806  1.00 12.56           C  
ATOM   4317  N   ALA    55      74.509  49.940  49.112  1.00 10.85           N  
ATOM   4318  CA  ALA    55      74.954  48.592  48.703  1.00  9.92           C  
ATOM   4319  C   ALA    55      73.773  47.608  48.516  1.00 10.77           C  
ATOM   4320  O   ALA    55      73.742  46.853  47.557  1.00 11.65           O  
ATOM   4321  CB  ALA    55      76.006  48.045  49.693  1.00 10.49           C  
ATOM   4322  N   VAL    56      72.799  47.650  49.430  1.00  9.59           N  
ATOM   4323  CA  VAL    56      71.557  46.882  49.316  1.00 10.13           C  
ATOM   4324  C   VAL    56      70.872  47.218  47.978  1.00  8.79           C  
ATOM   4325  O   VAL    56      70.487  46.331  47.219  1.00  8.66           O  
ATOM   4326  CB  VAL    56      70.633  47.138  50.532  1.00 10.01           C  
ATOM   4327  CG1 VAL    56      69.172  46.649  50.280  1.00  7.56           C  
ATOM   4328  CG2 VAL    56      71.197  46.518  51.814  1.00 10.51           C  
ATOM   4329  N   ASN    57      70.745  48.500  47.692  1.00  9.87           N  
ATOM   4330  CA  ASN    57      70.154  48.947  46.418  1.00 11.76           C  
ATOM   4331  C   ASN    57      70.955  48.418  45.217  1.00 11.67           C  
ATOM   4332  O   ASN    57      70.387  47.822  44.284  1.00 12.55           O  
ATOM   4333  CB  ASN    57      70.021  50.469  46.372  1.00 11.99           C  
ATOM   4334  CG  ASN    57      69.007  51.027  47.383  1.00 15.66           C  
ATOM   4335  OD1 ASN    57      68.032  50.360  47.782  1.00 12.64           O  
ATOM   4336  ND2 ASN    57      69.219  52.277  47.765  1.00 17.06           N  
ATOM   4337  N   ALA    58      72.277  48.567  45.274  1.00 12.94           N  
ATOM   4338  CA  ALA    58      73.156  48.118  44.189  1.00 13.57           C  
ATOM   4339  C   ALA    58      73.017  46.612  43.937  1.00 13.61           C  
ATOM   4340  O   ALA    58      73.109  46.169  42.796  1.00 16.13           O  
ATOM   4341  CB  ALA    58      74.614  48.476  44.510  1.00 13.21           C  
ATOM   4342  N   ALA    59      72.771  45.838  45.008  1.00 11.39           N  
ATOM   4343  CA  ALA    59      72.713  44.387  44.990  1.00 12.51           C  
ATOM   4344  C   ALA    59      71.383  43.821  44.486  1.00 12.62           C  
ATOM   4345  O   ALA    59      71.285  42.620  44.220  1.00 15.13           O  
ATOM   4346  CB  ALA    59      72.996  43.852  46.390  1.00 11.06           C  
ATOM   4347  N   GLY    60      70.378  44.682  44.403  1.00 12.64           N  
ATOM   4348  CA  GLY    60      69.046  44.314  43.915  1.00 13.60           C  
ATOM   4349  C   GLY    60      67.892  44.413  44.895  1.00 12.69           C  
ATOM   4350  O   GLY    60      66.779  43.988  44.575  1.00 14.43           O  
ATOM   4351  N   GLY    61      68.157  44.977  46.071  1.00 11.70           N  
ATOM   4352  CA  GLY    61      67.159  45.202  47.083  1.00 11.61           C  
ATOM   4353  C   GLY    61      66.769  46.649  47.284  1.00 10.76           C  
ATOM   4354  O   GLY    61      67.133  47.541  46.509  1.00 11.66           O  
ATOM   4355  N   GLN    62      65.997  46.875  48.342  1.00 10.13           N  
ATOM   4356  CA  GLN    62      65.579  48.208  48.747  1.00 10.90           C  
ATOM   4357  C   GLN    62      66.130  48.515  50.154  1.00 10.77           C  
ATOM   4358  O   GLN    62      65.662  47.951  51.164  1.00 11.03           O  
ATOM   4359  CB  GLN    62      64.037  48.298  48.684  1.00 11.20           C  
ATOM   4360  CG  GLN    62      63.461  47.988  47.269  1.00 15.34           C  
ATOM   4361  CD  GLN    62      63.525  46.484  46.782  1.00 19.63           C  
ATOM   4362  OE1 GLN    62      63.962  46.197  45.643  1.00 24.40           O  
ATOM   4363  NE2 GLN    62      63.036  45.554  47.608  1.00 20.05           N  
ATOM   4364  N   GLY    63      67.141  49.385  50.235  1.00  9.97           N  
ATOM   4365  CA  GLY    63      67.772  49.697  51.514  1.00 10.52           C  
ATOM   4366  C   GLY    63      67.143  50.896  52.214  1.00 11.09           C  
ATOM   4367  O   GLY    63      66.751  51.872  51.565  1.00 11.70           O  
ATOM   4368  N   LEU    64      67.097  50.839  53.541  1.00 10.37           N  
ATOM   4369  CA  LEU    64      66.625  51.939  54.367  1.00 10.16           C  
ATOM   4370  C   LEU    64      67.664  52.174  55.478  1.00  9.71           C  
ATOM   4371  O   LEU    64      67.874  51.315  56.356  1.00 10.08           O  
ATOM   4372  CB  LEU    64      65.244  51.621  54.960  1.00 10.42           C  
ATOM   4373  CG  LEU    64      64.636  52.668  55.897  1.00 12.75           C  
ATOM   4374  CD1 LEU    64      64.511  54.024  55.202  1.00 12.09           C  
ATOM   4375  CD2 LEU    64      63.278  52.172  56.431  1.00 11.76           C  
ATOM   4376  N   ALA    65      68.330  53.321  55.410  1.00  9.06           N  
ATOM   4377  CA  ALA    65      69.351  53.704  56.389  1.00 10.32           C  
ATOM   4378  C   ALA    65      68.659  54.294  57.618  1.00 11.65           C  
ATOM   4379  O   ALA    65      67.982  55.338  57.508  1.00 11.62           O  
ATOM   4380  CB  ALA    65      70.334  54.747  55.780  1.00 11.66           C  
ATOM   4381  N   LEU    66      68.853  53.662  58.777  1.00 10.79           N  
ATOM   4382  CA  LEU    66      68.286  54.127  60.047  1.00 11.07           C  
ATOM   4383  C   LEU    66      69.362  54.351  61.107  1.00 12.60           C  
ATOM   4384  O   LEU    66      70.029  53.421  61.537  1.00 13.07           O  
ATOM   4385  CB  LEU    66      67.247  53.141  60.582  1.00 11.35           C  
ATOM   4386  CG  LEU    66      66.058  52.943  59.660  1.00 10.42           C  
ATOM   4387  CD1 LEU    66      65.099  51.776  60.092  1.00 11.42           C  
ATOM   4388  CD2 LEU    66      65.316  54.273  59.501  1.00 11.23           C  
ATOM   4389  N   LYS    67      69.536  55.602  61.503  1.00 14.30           N  
ATOM   4390  CA  LYS    67      70.479  55.934  62.564  1.00 15.13           C  
ATOM   4391  C   LYS    67      69.918  55.438  63.901  1.00 15.44           C  
ATOM   4392  O   LYS    67      68.971  55.999  64.442  1.00 15.52           O  
ATOM   4393  CB  LYS    67      70.754  57.440  62.607  1.00 18.18           C  
ATOM   4394  CG  LYS    67      71.845  57.783  63.568  1.00 20.83           C  
ATOM   4395  CD  LYS    67      72.370  59.186  63.374  1.00 25.57           C  
ATOM   4396  CE  LYS    67      73.249  59.584  64.533  1.00 29.07           C  
ATOM   4397  NZ  LYS    67      74.375  58.632  64.659  1.00 30.99           N  
ATOM   4398  N   CYS    68      70.520  54.384  64.435  1.00 15.01           N  
ATOM   4399  CA  CYS    68      69.929  53.672  65.558  1.00 14.35           C  
ATOM   4400  C   CYS    68      71.002  53.069  66.436  1.00 15.73           C  
ATOM   4401  O   CYS    68      71.712  52.159  66.030  1.00 15.85           O  
ATOM   4402  CB  CYS    68      68.987  52.584  65.037  1.00 14.77           C  
ATOM   4403  SG  CYS    68      68.102  51.658  66.320  1.00 16.51           S  
ATOM   4404  N   ASP    69      71.149  53.645  67.615  1.00 15.43           N  
ATOM   4405  CA  ASP    69      71.974  53.077  68.661  1.00 14.74           C  
ATOM   4406  C   ASP    69      71.058  52.152  69.482  1.00 14.40           C  
ATOM   4407  O   ASP    69      70.159  52.640  70.195  1.00 12.21           O  
ATOM   4408  CB  ASP    69      72.526  54.213  69.516  1.00 16.00           C  
ATOM   4409  CG  ASP    69      73.504  53.737  70.597  1.00 19.52           C  
ATOM   4410  OD1 ASP    69      73.547  52.525  70.927  1.00 18.10           O  
ATOM   4411  OD2 ASP    69      74.211  54.625  71.143  1.00 23.30           O  
ATOM   4412  N   ILE    70      71.266  50.833  69.379  1.00 14.30           N  
ATOM   4413  CA  ILE    70      70.321  49.876  69.990  1.00 15.56           C  
ATOM   4414  C   ILE    70      70.370  49.869  71.538  1.00 15.83           C  
ATOM   4415  O   ILE    70      69.527  49.223  72.182  1.00 15.07           O  
ATOM   4416  CB  ILE    70      70.395  48.418  69.397  1.00 16.26           C  
ATOM   4417  CG1 ILE    70      71.703  47.716  69.749  1.00 18.10           C  
ATOM   4418  CG2 ILE    70      70.142  48.415  67.861  1.00 17.83           C  
ATOM   4419  CD1 ILE    70      71.696  46.193  69.368  1.00 17.33           C  
ATOM   4420  N   ARG    71      71.298  50.643  72.109  1.00 14.82           N  
ATOM   4421  CA  ARG    71      71.335  50.907  73.554  1.00 15.94           C  
ATOM   4422  C   ARG    71      70.191  51.802  73.997  1.00 15.57           C  
ATOM   4423  O   ARG    71      69.853  51.845  75.194  1.00 15.81           O  
ATOM   4424  CB  ARG    71      72.664  51.558  73.964  1.00 15.65           C  
ATOM   4425  CG  ARG    71      73.911  50.663  73.791  1.00 14.57           C  
ATOM   4426  CD  ARG    71      75.186  51.376  74.210  1.00 19.32           C  
ATOM   4427  NE  ARG    71      75.512  52.425  73.239  1.00 21.10           N  
ATOM   4428  CZ  ARG    71      76.577  53.222  73.305  1.00 24.89           C  
ATOM   4429  NH1 ARG    71      77.449  53.098  74.293  1.00 24.75           N  
ATOM   4430  NH2 ARG    71      76.777  54.145  72.365  1.00 22.88           N  
ATOM   4431  N   GLU    72      69.595  52.500  73.025  1.00 15.06           N  
ATOM   4432  CA  GLU    72      68.561  53.486  73.263  1.00 14.85           C  
ATOM   4433  C   GLU    72      67.228  52.992  72.776  1.00 14.36           C  
ATOM   4434  O   GLU    72      66.974  52.971  71.572  1.00 14.13           O  
ATOM   4435  CB  GLU    72      68.927  54.788  72.547  1.00 16.20           C  
ATOM   4436  CG  GLU    72      70.228  55.424  73.032  1.00 19.28           C  
ATOM   4437  CD  GLU    72      70.163  55.912  74.477  1.00 24.79           C  
ATOM   4438  OE1 GLU    72      69.065  56.244  74.975  1.00 26.49           O  
ATOM   4439  OE2 GLU    72      71.228  55.987  75.109  1.00 31.64           O  
ATOM   4440  N   GLU    73      66.373  52.616  73.722  1.00 14.09           N  
ATOM   4441  CA  GLU    73      65.038  52.121  73.420  1.00 14.77           C  
ATOM   4442  C   GLU    73      64.240  53.052  72.481  1.00 15.01           C  
ATOM   4443  O   GLU    73      63.577  52.581  71.536  1.00 13.16           O  
ATOM   4444  CB  GLU    73      64.247  51.894  74.732  1.00 16.04           C  
ATOM   4445  CG  GLU    73      62.876  51.306  74.472  1.00 18.66           C  
ATOM   4446  CD  GLU    73      61.866  51.466  75.631  1.00 20.26           C  
ATOM   4447  OE1 GLU    73      62.232  52.012  76.692  1.00 24.55           O  
ATOM   4448  OE2 GLU    73      60.699  51.042  75.454  1.00 23.78           O  
ATOM   4449  N   ASP    74      64.303  54.362  72.738  1.00 14.98           N  
ATOM   4450  CA  ASP    74      63.582  55.324  71.895  0.50 14.83           C  
ATOM   4452  C   ASP    74      64.038  55.283  70.432  1.00 14.52           C  
ATOM   4453  O   ASP    74      63.213  55.398  69.513  1.00 14.83           O  
ATOM   4454  CB  ASP    74      63.633  56.758  72.467  0.50 15.52           C  
ATOM   4456  CG  ASP    74      65.035  57.340  72.522  0.50 16.56           C  
ATOM   4458  OD1 ASP    74      66.010  56.581  72.494  0.50 16.84           O  
ATOM   4460  OD2 ASP    74      65.147  58.582  72.630  0.50 20.41           O  
ATOM   4462  N   GLN    75      65.332  55.101  70.199  1.00 13.57           N  
ATOM   4463  CA  GLN    75      65.839  54.993  68.823  1.00 13.14           C  
ATOM   4464  C   GLN    75      65.410  53.694  68.158  1.00 14.19           C  
ATOM   4465  O   GLN    75      65.118  53.662  66.948  1.00 13.85           O  
ATOM   4466  CB  GLN    75      67.347  55.120  68.804  1.00 14.45           C  
ATOM   4467  CG  GLN    75      67.809  56.504  69.261  1.00 14.29           C  
ATOM   4468  CD  GLN    75      69.289  56.650  69.151  1.00 16.40           C  
ATOM   4469  OE1 GLN    75      69.882  56.165  68.197  1.00 15.63           O  
ATOM   4470  NE2 GLN    75      69.905  57.317  70.129  1.00 18.92           N  
ATOM   4471  N   VAL    76      65.380  52.610  68.929  1.00 11.77           N  
ATOM   4472  CA  VAL    76      64.900  51.323  68.393  1.00 12.50           C  
ATOM   4473  C   VAL    76      63.419  51.411  67.974  1.00 12.50           C  
ATOM   4474  O   VAL    76      63.030  51.036  66.868  1.00 10.96           O  
ATOM   4475  CB  VAL    76      65.084  50.176  69.410  1.00 11.81           C  
ATOM   4476  CG1 VAL    76      64.358  48.932  68.920  1.00 11.56           C  
ATOM   4477  CG2 VAL    76      66.542  49.876  69.627  1.00 12.60           C  
ATOM   4478  N   ARG    77      62.601  51.956  68.857  1.00 13.65           N  
ATOM   4479  CA  ARG    77      61.189  52.145  68.559  0.50 13.88           C  
ATOM   4481  C   ARG    77      61.020  53.019  67.324  1.00 12.93           C  
ATOM   4482  O   ARG    77      60.226  52.697  66.449  1.00 12.46           O  
ATOM   4483  CB  ARG    77      60.467  52.791  69.729  0.50 14.68           C  
ATOM   4485  CG  ARG    77      60.032  51.831  70.812  0.50 16.92           C  
ATOM   4487  CD  ARG    77      59.153  52.565  71.818  0.50 20.54           C  
ATOM   4489  NE  ARG    77      59.950  53.532  72.565  0.50 23.90           N  
ATOM   4491  CZ  ARG    77      60.040  53.601  73.889  0.50 25.52           C  
ATOM   4493  NH1 ARG    77      59.345  52.779  74.669  0.50 28.09           N  
ATOM   4495  NH2 ARG    77      60.825  54.518  74.436  0.50 24.10           N  
ATOM   4497  N   ALA    78      61.801  54.113  67.257  1.00 12.74           N  
ATOM   4498  CA  ALA    78      61.742  55.052  66.125  1.00 12.35           C  
ATOM   4499  C   ALA    78      62.108  54.311  64.829  1.00 11.80           C  
ATOM   4500  O   ALA    78      61.436  54.455  63.798  1.00 10.56           O  
ATOM   4501  CB  ALA    78      62.675  56.230  66.346  1.00 12.32           C  
ATOM   4502  N   ALA    79      63.188  53.526  64.875  1.00 10.16           N  
ATOM   4503  CA  ALA    79      63.613  52.764  63.698  1.00  9.21           C  
ATOM   4504  C   ALA    79      62.555  51.749  63.227  1.00  9.66           C  
ATOM   4505  O   ALA    79      62.283  51.644  62.029  1.00  9.19           O  
ATOM   4506  CB  ALA    79      64.950  52.109  63.938  1.00 11.41           C  
ATOM   4507  N   VAL    80      61.932  51.036  64.162  1.00 10.89           N  
ATOM   4508  CA  VAL    80      60.930  50.054  63.811  1.00 10.39           C  
ATOM   4509  C   VAL    80      59.708  50.748  63.173  1.00 11.76           C  
ATOM   4510  O   VAL    80      59.182  50.300  62.157  1.00 10.69           O  
ATOM   4511  CB  VAL    80      60.549  49.202  65.058  1.00 11.02           C  
ATOM   4512  CG1 VAL    80      59.275  48.393  64.797  1.00 12.27           C  
ATOM   4513  CG2 VAL    80      61.707  48.283  65.456  1.00 10.82           C  
ATOM   4514  N   ALA    81      59.284  51.847  63.774  1.00 11.29           N  
ATOM   4515  CA  ALA    81      58.149  52.634  63.249  1.00 11.10           C  
ATOM   4516  C   ALA    81      58.424  53.111  61.822  1.00 10.71           C  
ATOM   4517  O   ALA    81      57.583  52.981  60.937  1.00 10.67           O  
ATOM   4518  CB  ALA    81      57.848  53.798  64.168  1.00 11.80           C  
ATOM   4519  N   ALA    82      59.638  53.609  61.588  1.00 12.43           N  
ATOM   4520  CA  ALA    82      60.031  54.073  60.246  1.00 11.93           C  
ATOM   4521  C   ALA    82      60.020  52.929  59.223  1.00 12.13           C  
ATOM   4522  O   ALA    82      59.658  53.130  58.059  1.00 12.22           O  
ATOM   4523  CB  ALA    82      61.418  54.698  60.294  1.00 11.17           C  
ATOM   4524  N   THR    83      60.486  51.750  59.641  1.00 10.92           N  
ATOM   4525  CA  THR    83      60.552  50.567  58.781  1.00 11.47           C  
ATOM   4526  C   THR    83      59.150  50.169  58.351  1.00 10.06           C  
ATOM   4527  O   THR    83      58.901  49.929  57.170  1.00 10.48           O  
ATOM   4528  CB  THR    83      61.291  49.396  59.496  1.00 12.22           C  
ATOM   4529  OG1 THR    83      62.647  49.789  59.838  1.00 10.85           O  
ATOM   4530  CG2 THR    83      61.322  48.118  58.625  1.00 11.26           C  
ATOM   4531  N   VAL    84      58.226  50.151  59.308  1.00 11.11           N  
ATOM   4532  CA  VAL    84      56.815  49.819  59.019  1.00 11.98           C  
ATOM   4533  C   VAL    84      56.188  50.876  58.082  1.00 12.56           C  
ATOM   4534  O   VAL    84      55.509  50.529  57.121  1.00 14.11           O  
ATOM   4535  CB  VAL    84      56.056  49.667  60.328  1.00 12.21           C  
ATOM   4536  CG1 VAL    84      54.528  49.657  60.079  1.00 13.32           C  
ATOM   4537  CG2 VAL    84      56.577  48.395  61.081  1.00 11.90           C  
ATOM   4538  N   ASP    85      56.495  52.145  58.314  1.00 12.76           N  
ATOM   4539  CA  ASP    85      55.984  53.238  57.498  1.00 13.08           C  
ATOM   4540  C   ASP    85      56.545  53.222  56.074  1.00 14.08           C  
ATOM   4541  O   ASP    85      55.918  53.767  55.149  1.00 17.77           O  
ATOM   4542  CB  ASP    85      56.288  54.569  58.170  1.00 11.36           C  
ATOM   4543  CG  ASP    85      55.357  54.849  59.353  1.00 13.67           C  
ATOM   4544  OD1 ASP    85      54.298  54.183  59.454  1.00 16.53           O  
ATOM   4545  OD2 ASP    85      55.690  55.730  60.152  1.00 12.55           O  
ATOM   4546  N   THR    86      57.730  52.637  55.914  1.00 13.52           N  
ATOM   4547  CA  THR    86      58.421  52.588  54.626  1.00 13.64           C  
ATOM   4548  C   THR    86      58.031  51.337  53.806  1.00 12.99           C  
ATOM   4549  O   THR    86      57.796  51.439  52.603  1.00 13.01           O  
ATOM   4550  CB  THR    86      59.949  52.678  54.805  1.00 14.35           C  
ATOM   4551  OG1 THR    86      60.296  53.846  55.556  1.00 13.28           O  
ATOM   4552  CG2 THR    86      60.658  52.690  53.436  1.00 14.76           C  
ATOM   4553  N   PHE    87      57.985  50.175  54.453  1.00 12.20           N  
ATOM   4554  CA  PHE    87      57.786  48.909  53.776  1.00 13.39           C  
ATOM   4555  C   PHE    87      56.445  48.196  54.062  1.00 14.24           C  
ATOM   4556  O   PHE    87      56.106  47.230  53.376  1.00 14.71           O  
ATOM   4557  CB  PHE    87      58.978  47.966  54.067  1.00 12.60           C  
ATOM   4558  CG  PHE    87      60.331  48.500  53.574  1.00 12.24           C  
ATOM   4559  CD1 PHE    87      60.545  48.733  52.222  1.00 12.48           C  
ATOM   4560  CD2 PHE    87      61.377  48.710  54.450  1.00 10.71           C  
ATOM   4561  CE1 PHE    87      61.770  49.195  51.760  1.00 12.16           C  
ATOM   4562  CE2 PHE    87      62.623  49.163  53.993  1.00 11.59           C  
ATOM   4563  CZ  PHE    87      62.808  49.426  52.663  1.00 11.42           C  
ATOM   4564  N   GLY    88      55.701  48.651  55.066  1.00 14.19           N  
ATOM   4565  CA  GLY    88      54.385  48.070  55.374  1.00 15.72           C  
ATOM   4566  C   GLY    88      54.414  47.041  56.492  1.00 16.55           C  
ATOM   4567  O   GLY    88      53.366  46.641  56.994  1.00 18.76           O  
ATOM   4568  N   GLY    89      55.600  46.614  56.913  1.00 16.03           N  
ATOM   4569  CA  GLY    89      55.698  45.617  57.983  1.00 15.01           C  
ATOM   4570  C   GLY    89      57.135  45.227  58.265  1.00 14.27           C  
ATOM   4571  O   GLY    89      58.052  45.854  57.737  1.00 13.48           O  
ATOM   4572  N   ILE    90      57.300  44.214  59.119  1.00 13.25           N  
ATOM   4573  CA  ILE    90      58.606  43.592  59.372  1.00 13.40           C  
ATOM   4574  C   ILE    90      58.384  42.086  59.350  1.00 11.55           C  
ATOM   4575  O   ILE    90      57.515  41.570  60.077  1.00 11.69           O  
ATOM   4576  CB  ILE    90      59.255  44.041  60.701  1.00 12.64           C  
ATOM   4577  CG1 ILE    90      59.526  45.566  60.696  1.00 14.52           C  
ATOM   4578  CG2 ILE    90      60.558  43.283  60.906  1.00 12.56           C  
ATOM   4579  CD1 ILE    90      60.052  46.125  61.987  1.00 15.48           C  
ATOM   4580  N   ASP    91      59.096  41.403  58.457  1.00  9.86           N  
ATOM   4581  CA  ASP    91      59.002  39.958  58.303  1.00 11.11           C  
ATOM   4582  C   ASP    91      60.065  39.250  59.113  1.00  9.15           C  
ATOM   4583  O   ASP    91      59.854  38.134  59.552  1.00  9.18           O  
ATOM   4584  CB  ASP    91      59.140  39.542  56.847  1.00 11.65           C  
ATOM   4585  CG  ASP    91      58.037  40.107  55.980  1.00 14.84           C  
ATOM   4586  OD1 ASP    91      56.894  39.622  56.119  1.00 16.00           O  
ATOM   4587  OD2 ASP    91      58.298  41.074  55.229  1.00 12.79           O  
ATOM   4588  N   ILE    92      61.221  39.899  59.274  1.00  9.58           N  
ATOM   4589  CA  ILE    92      62.410  39.261  59.820  1.00  8.68           C  
ATOM   4590  C   ILE    92      63.218  40.242  60.659  1.00  8.52           C  
ATOM   4591  O   ILE    92      63.473  41.358  60.218  1.00  9.07           O  
ATOM   4592  CB  ILE    92      63.321  38.751  58.680  1.00  8.52           C  
ATOM   4593  CG1 ILE    92      62.638  37.607  57.875  1.00  9.06           C  
ATOM   4594  CG2 ILE    92      64.706  38.401  59.227  1.00  8.10           C  
ATOM   4595  CD1 ILE    92      63.261  37.353  56.436  1.00  7.79           C  
ATOM   4596  N   LEU    93      63.533  39.852  61.886  1.00  8.30           N  
ATOM   4597  CA  LEU    93      64.502  40.588  62.706  1.00  7.41           C  
ATOM   4598  C   LEU    93      65.775  39.756  62.820  1.00  8.70           C  
ATOM   4599  O   LEU    93      65.716  38.585  63.185  1.00  8.76           O  
ATOM   4600  CB  LEU    93      63.938  40.843  64.105  1.00  8.16           C  
ATOM   4601  CG  LEU    93      64.932  41.233  65.196  1.00  5.74           C  
ATOM   4602  CD1 LEU    93      65.628  42.551  64.861  1.00  6.57           C  
ATOM   4603  CD2 LEU    93      64.314  41.307  66.611  1.00  8.60           C  
ATOM   4604  N   VAL    94      66.914  40.375  62.510  1.00  7.98           N  
ATOM   4605  CA  VAL    94      68.219  39.769  62.709  1.00  9.12           C  
ATOM   4606  C   VAL    94      68.980  40.558  63.797  1.00 10.02           C  
ATOM   4607  O   VAL    94      69.390  41.739  63.605  1.00  9.86           O  
ATOM   4608  CB  VAL    94      69.055  39.690  61.423  1.00  9.47           C  
ATOM   4609  CG1 VAL    94      70.436  39.116  61.752  1.00  9.29           C  
ATOM   4610  CG2 VAL    94      68.318  38.871  60.309  1.00  8.59           C  
ATOM   4611  N   ASN    95      69.154  39.893  64.938  1.00 10.55           N  
ATOM   4612  CA  ASN    95      69.892  40.431  66.077  1.00  9.62           C  
ATOM   4613  C   ASN    95      71.373  40.123  65.903  1.00 11.40           C  
ATOM   4614  O   ASN    95      71.831  39.032  66.242  1.00  9.87           O  
ATOM   4615  CB  ASN    95      69.380  39.836  67.413  1.00 10.60           C  
ATOM   4616  CG  ASN    95      68.052  40.440  67.876  1.00 11.21           C  
ATOM   4617  OD1 ASN    95      67.818  41.634  67.732  1.00 10.76           O  
ATOM   4618  ND2 ASN    95      67.218  39.620  68.528  1.00 12.96           N  
ATOM   4619  N   ASN    96      72.085  41.091  65.326  1.00 11.59           N  
ATOM   4620  CA  ASN    96      73.528  41.016  65.035  1.00 13.37           C  
ATOM   4621  C   ASN    96      74.273  42.005  65.928  1.00 16.20           C  
ATOM   4622  O   ASN    96      73.928  43.179  65.993  1.00 15.11           O  
ATOM   4623  CB  ASN    96      73.715  41.313  63.557  1.00 11.50           C  
ATOM   4624  CG  ASN    96      75.139  41.575  63.180  1.00 14.49           C  
ATOM   4625  OD1 ASN    96      75.983  40.680  63.207  1.00 16.83           O  
ATOM   4626  ND2 ASN    96      75.409  42.792  62.790  1.00  9.56           N  
ATOM   4627  N   ALA    97      75.296  41.579  66.656  1.00 18.86           N  
ATOM   4628  CA  ALA    97      75.854  42.536  67.648  1.00 21.32           C  
ATOM   4629  C   ALA    97      77.288  42.237  68.037  1.00 24.35           C  
ATOM   4630  O   ALA    97      77.701  41.061  68.148  1.00 25.78           O  
ATOM   4631  CB  ALA    97      74.962  42.624  68.875  1.00 19.12           C  
ATOM   4632  N   SER    98      78.054  43.303  68.232  1.00 26.50           N  
ATOM   4633  CA  SER    98      79.498  43.168  68.439  1.00 27.11           C  
ATOM   4634  C   SER    98      79.973  44.056  69.562  1.00 28.44           C  
ATOM   4635  O   SER    98      80.188  45.265  69.386  1.00 30.58           O  
ATOM   4636  CB  SER    98      80.288  43.465  67.148  1.00 28.40           C  
ATOM   4637  N   ALA    99      80.109  43.449  70.737  1.00 27.31           N  
ATOM   4638  CA  ALA    99      80.844  44.047  71.820  1.00 25.99           C  
ATOM   4639  C   ALA    99      81.478  42.891  72.564  1.00 25.28           C  
ATOM   4640  O   ALA    99      80.775  42.057  73.139  1.00 26.40           O  
ATOM   4641  CB  ALA    99      79.943  44.863  72.705  1.00 23.45           C  
ATOM   4642  N   ILE   100      82.803  42.829  72.486  1.00 25.37           N  
ATOM   4643  CA  ILE   100      83.592  41.744  73.047  1.00 25.42           C  
ATOM   4644  C   ILE   100      84.627  42.316  73.998  1.00 24.81           C  
ATOM   4645  O   ILE   100      85.177  43.389  73.744  1.00 24.78           O  
ATOM   4646  CB  ILE   100      84.371  40.987  71.948  1.00 25.91           C  
ATOM   4647  CG1 ILE   100      83.484  40.708  70.742  1.00 27.86           C  
ATOM   4648  CG2 ILE   100      84.948  39.693  72.488  1.00 24.79           C  
ATOM   4649  CD1 ILE   100      84.232  40.102  69.571  1.00 29.67           C  
ATOM   4650  N   TRP   101      84.907  41.572  75.065  1.00 24.29           N  
ATOM   4651  CA  TRP   101      85.986  41.896  75.992  1.00 23.47           C  
ATOM   4652  C   TRP   101      86.430  40.636  76.723  1.00 22.77           C  
ATOM   4653  O   TRP   101      85.773  40.172  77.675  1.00 21.38           O  
ATOM   4654  CB  TRP   101      85.541  42.954  76.986  1.00 24.46           C  
ATOM   4655  CG  TRP   101      86.642  43.518  77.809  1.00 24.30           C  
ATOM   4656  CD1 TRP   101      86.913  43.240  79.101  1.00 24.59           C  
ATOM   4657  CD2 TRP   101      87.599  44.497  77.396  1.00 23.61           C  
ATOM   4658  NE1 TRP   101      87.994  43.970  79.529  1.00 24.57           N  
ATOM   4659  CE2 TRP   101      88.426  44.762  78.502  1.00 24.81           C  
ATOM   4660  CE3 TRP   101      87.836  45.178  76.195  1.00 25.08           C  
ATOM   4661  CZ2 TRP   101      89.479  45.672  78.448  1.00 25.92           C  
ATOM   4662  CZ3 TRP   101      88.884  46.096  76.148  1.00 24.84           C  
ATOM   4663  CH2 TRP   101      89.694  46.322  77.263  1.00 25.44           C  
ATOM   4664  N   LEU   102      87.548  40.074  76.284  1.00 21.75           N  
ATOM   4665  CA  LEU   102      87.973  38.788  76.788  1.00 22.04           C  
ATOM   4666  C   LEU   102      88.999  38.959  77.898  1.00 23.00           C  
ATOM   4667  O   LEU   102      90.183  38.677  77.729  1.00 24.09           O  
ATOM   4668  CB  LEU   102      88.501  37.906  75.658  1.00 22.22           C  
ATOM   4669  CG  LEU   102      87.511  37.608  74.531  1.00 21.08           C  
ATOM   4670  CD1 LEU   102      88.094  36.557  73.608  1.00 22.43           C  
ATOM   4671  CD2 LEU   102      86.161  37.181  75.059  1.00 23.06           C  
ATOM   4672  N   ARG   103      88.519  39.427  79.046  1.00 22.04           N  
ATOM   4673  CA  ARG   103      89.319  39.493  80.253  1.00 21.64           C  
ATOM   4674  C   ARG   103      88.537  39.038  81.485  1.00 20.27           C  
ATOM   4675  O   ARG   103      87.312  38.943  81.477  1.00 17.16           O  
ATOM   4676  CB  ARG   103      89.814  40.917  80.499  1.00 24.03           C  
ATOM   4677  CG  ARG   103      90.505  41.512  79.289  1.00 28.14           C  
ATOM   4678  CD  ARG   103      91.647  42.375  79.666  1.00 33.78           C  
ATOM   4679  NE  ARG   103      91.975  43.272  78.562  1.00 36.82           N  
ATOM   4680  CZ  ARG   103      92.748  44.347  78.676  1.00 38.51           C  
ATOM   4681  NH1 ARG   103      93.292  44.664  79.851  1.00 40.89           N  
ATOM   4682  NH2 ARG   103      92.980  45.113  77.610  1.00 38.28           N  
ATOM   4683  N   GLY   104      89.296  38.795  82.548  1.00 16.74           N  
ATOM   4684  CA  GLY   104      88.738  38.403  83.816  1.00 16.72           C  
ATOM   4685  C   GLY   104      88.016  39.549  84.476  1.00 15.68           C  
ATOM   4686  O   GLY   104      88.102  40.703  84.059  1.00 14.76           O  
ATOM   4687  N   THR   105      87.290  39.209  85.524  1.00 15.55           N  
ATOM   4688  CA  THR   105      86.415  40.145  86.195  1.00 15.07           C  
ATOM   4689  C   THR   105      87.085  41.370  86.813  1.00 16.19           C  
ATOM   4690  O   THR   105      86.541  42.478  86.727  1.00 17.66           O  
ATOM   4691  CB  THR   105      85.596  39.354  87.216  1.00 15.47           C  
ATOM   4692  OG1 THR   105      84.754  38.485  86.470  1.00 15.00           O  
ATOM   4693  CG2 THR   105      84.743  40.249  88.138  1.00 14.35           C  
ATOM   4694  N   LEU   106      88.263  41.202  87.418  1.00 15.58           N  
ATOM   4695  CA  LEU   106      88.968  42.363  87.978  1.00 17.21           C  
ATOM   4696  C   LEU   106      89.505  43.305  86.884  1.00 17.64           C  
ATOM   4697  O   LEU   106      89.758  44.483  87.159  1.00 18.32           O  
ATOM   4698  CB  LEU   106      90.100  41.919  88.905  1.00 18.10           C  
ATOM   4699  CG  LEU   106      89.663  41.104  90.120  1.00 18.99           C  
ATOM   4700  CD1 LEU   106      90.879  40.738  91.005  1.00 19.71           C  
ATOM   4701  CD2 LEU   106      88.591  41.858  90.886  1.00 19.70           C  
ATOM   4702  N   ASP   107      89.640  42.778  85.666  1.00 18.49           N  
ATOM   4703  CA  ASP   107      90.100  43.530  84.483  1.00 20.41           C  
ATOM   4704  C   ASP   107      88.994  43.850  83.466  1.00 20.75           C  
ATOM   4705  O   ASP   107      89.274  44.072  82.273  1.00 19.29           O  
ATOM   4706  CB  ASP   107      91.193  42.730  83.775  1.00 21.67           C  
ATOM   4707  CG  ASP   107      92.343  42.404  84.683  1.00 25.54           C  
ATOM   4708  OD1 ASP   107      92.765  43.318  85.419  1.00 30.40           O  
ATOM   4709  OD2 ASP   107      92.820  41.247  84.674  1.00 29.43           O  
ATOM   4710  N   THR   108      87.744  43.880  83.937  1.00 19.28           N  
ATOM   4711  CA  THR   108      86.581  44.210  83.116  1.00 18.97           C  
ATOM   4712  C   THR   108      85.864  45.409  83.737  1.00 18.53           C  
ATOM   4713  O   THR   108      84.979  45.238  84.572  1.00 18.30           O  
ATOM   4714  CB  THR   108      85.607  42.989  82.979  1.00 18.05           C  
ATOM   4715  OG1 THR   108      86.270  41.918  82.300  1.00 16.75           O  
ATOM   4716  CG2 THR   108      84.333  43.347  82.176  1.00 18.61           C  
ATOM   4717  N   PRO   109      86.236  46.634  83.326  1.00 19.10           N  
ATOM   4718  CA  PRO   109      85.571  47.825  83.855  1.00 18.95           C  
ATOM   4719  C   PRO   109      84.062  47.813  83.663  1.00 18.05           C  
ATOM   4720  O   PRO   109      83.562  47.256  82.680  1.00 17.09           O  
ATOM   4721  CB  PRO   109      86.210  48.986  83.052  1.00 19.61           C  
ATOM   4722  CG  PRO   109      87.506  48.462  82.542  1.00 19.54           C  
ATOM   4723  CD  PRO   109      87.301  46.969  82.358  1.00 19.08           C  
ATOM   4724  N   MET   110      83.332  48.423  84.588  1.00 18.14           N  
ATOM   4725  CA  MET   110      81.867  48.425  84.471  1.00 18.12           C  
ATOM   4726  C   MET   110      81.380  49.103  83.188  1.00 17.12           C  
ATOM   4727  O   MET   110      80.344  48.701  82.654  1.00 15.67           O  
ATOM   4728  CB  MET   110      81.211  49.040  85.703  1.00 18.68           C  
ATOM   4729  CG  MET   110      81.477  48.233  86.978  1.00 20.97           C  
ATOM   4730  SD  MET   110      81.044  46.309  86.827  1.00 25.12          SE  
ATOM   4731  CE  MET   110      79.163  46.430  86.231  1.00 15.96           C  
ATOM   4732  N   LYS   111      82.099  50.110  82.680  1.00 15.99           N  
ATOM   4733  CA  LYS   111      81.717  50.714  81.391  1.00 16.83           C  
ATOM   4734  C   LYS   111      81.719  49.670  80.260  1.00 16.95           C  
ATOM   4735  O   LYS   111      80.841  49.664  79.396  1.00 16.98           O  
ATOM   4736  CB  LYS   111      82.604  51.928  81.031  1.00 17.99           C  
ATOM   4737  N   ARG   112      82.687  48.772  80.283  1.00 16.61           N  
ATOM   4738  CA  ARG   112      82.800  47.714  79.279  1.00 16.84           C  
ATOM   4739  C   ARG   112      81.758  46.624  79.515  1.00 15.21           C  
ATOM   4740  O   ARG   112      81.088  46.175  78.593  1.00 14.90           O  
ATOM   4741  CB  ARG   112      84.206  47.118  79.324  1.00 19.03           C  
ATOM   4742  CG  ARG   112      84.488  46.147  78.241  1.00 24.00           C  
ATOM   4743  CD  ARG   112      84.588  46.814  76.882  1.00 28.63           C  
ATOM   4744  NE  ARG   112      85.729  47.725  76.809  1.00 31.55           N  
ATOM   4745  CZ  ARG   112      86.100  48.369  75.702  1.00 33.82           C  
ATOM   4746  NH1 ARG   112      85.423  48.203  74.565  1.00 35.01           N  
ATOM   4747  NH2 ARG   112      87.157  49.175  75.724  1.00 33.19           N  
ATOM   4748  N   PHE   113      81.589  46.242  80.771  1.00 14.46           N  
ATOM   4749  CA  PHE   113      80.528  45.298  81.141  1.00 13.19           C  
ATOM   4750  C   PHE   113      79.201  45.800  80.609  1.00 12.99           C  
ATOM   4751  O   PHE   113      78.449  45.038  79.996  1.00 13.17           O  
ATOM   4752  CB  PHE   113      80.464  45.166  82.666  1.00 13.14           C  
ATOM   4753  CG  PHE   113      79.424  44.201  83.156  1.00 12.58           C  
ATOM   4754  CD1 PHE   113      79.761  42.881  83.428  1.00 13.38           C  
ATOM   4755  CD2 PHE   113      78.112  44.619  83.395  1.00 12.08           C  
ATOM   4756  CE1 PHE   113      78.809  41.975  83.900  1.00 13.78           C  
ATOM   4757  CE2 PHE   113      77.166  43.727  83.864  1.00 14.33           C  
ATOM   4758  CZ  PHE   113      77.521  42.387  84.097  1.00 13.05           C  
ATOM   4759  N   ASP   114      78.925  47.089  80.832  1.00 13.50           N  
ATOM   4760  CA  ASP   114      77.629  47.702  80.477  1.00 13.35           C  
ATOM   4761  C   ASP   114      77.445  47.808  78.964  1.00 13.59           C  
ATOM   4762  O   ASP   114      76.377  47.516  78.440  1.00 13.57           O  
ATOM   4763  CB  ASP   114      77.495  49.087  81.096  1.00 14.35           C  
ATOM   4764  CG  ASP   114      77.199  49.046  82.581  1.00 16.36           C  
ATOM   4765  OD1 ASP   114      76.877  47.963  83.130  1.00 16.43           O  
ATOM   4766  OD2 ASP   114      77.296  50.123  83.213  1.00 17.53           O  
ATOM   4767  N   LEU   115      78.494  48.227  78.255  1.00 13.85           N  
ATOM   4768  CA  LEU   115      78.435  48.234  76.797  1.00 14.41           C  
ATOM   4769  C   LEU   115      78.001  46.864  76.291  1.00 13.73           C  
ATOM   4770  O   LEU   115      77.135  46.765  75.426  1.00 12.95           O  
ATOM   4771  CB  LEU   115      79.810  48.563  76.215  1.00 15.20           C  
ATOM   4772  CG  LEU   115      79.954  48.493  74.687  1.00 17.36           C  
ATOM   4773  CD1 LEU   115      79.052  49.546  74.048  1.00 20.85           C  
ATOM   4774  CD2 LEU   115      81.438  48.699  74.265  1.00 17.77           C  
ATOM   4775  N   MET   116      78.636  45.810  76.810  1.00 12.94           N  
ATOM   4776  CA  MET   116      78.357  44.446  76.364  1.00 14.83           C  
ATOM   4777  C   MET   116      76.934  44.028  76.686  1.00 13.40           C  
ATOM   4778  O   MET   116      76.227  43.522  75.812  1.00 12.46           O  
ATOM   4779  CB  MET   116      79.337  43.460  76.970  1.00 14.83           C  
ATOM   4780  CG  MET   116      80.753  43.700  76.483  1.00 17.13           C  
ATOM   4781  SD  MET   116      81.983  42.298  76.979  1.00 23.57          SE  
ATOM   4782  CE  MET   116      81.985  42.439  78.957  1.00 14.43           C  
ATOM   4783  N   GLN   117      76.479  44.232  77.914  1.00 12.39           N  
ATOM   4784  CA  GLN   117      75.076  43.805  78.221  1.00 10.84           C  
ATOM   4785  C   GLN   117      74.063  44.595  77.416  1.00 12.68           C  
ATOM   4786  O   GLN   117      73.022  44.081  77.083  1.00 13.09           O  
ATOM   4787  CB  GLN   117      74.696  43.928  79.699  1.00 11.00           C  
ATOM   4788  CG  GLN   117      75.734  43.443  80.721  1.00 10.79           C  
ATOM   4789  CD  GLN   117      76.335  42.099  80.406  1.00 12.31           C  
ATOM   4790  OE1 GLN   117      75.632  41.127  80.084  1.00 15.56           O  
ATOM   4791  NE2 GLN   117      77.669  42.022  80.528  1.00 13.42           N  
ATOM   4792  N   GLN   118      74.345  45.867  77.163  1.00 12.32           N  
ATOM   4793  CA  GLN   118      73.398  46.727  76.474  1.00 12.69           C  
ATOM   4794  C   GLN   118      73.291  46.412  74.976  1.00 12.42           C  
ATOM   4795  O   GLN   118      72.191  46.387  74.414  1.00 14.90           O  
ATOM   4796  CB  GLN   118      73.751  48.191  76.720  1.00 12.77           C  
ATOM   4797  CG  GLN   118      73.473  48.629  78.157  1.00 13.82           C  
ATOM   4798  CD  GLN   118      74.069  49.992  78.489  1.00 18.46           C  
ATOM   4799  OE1 GLN   118      74.460  50.744  77.596  1.00 20.95           O  
ATOM   4800  NE2 GLN   118      74.143  50.308  79.778  1.00 18.75           N  
ATOM   4801  N   VAL   119      74.414  46.146  74.323  1.00 11.13           N  
ATOM   4802  CA  VAL   119      74.416  45.869  72.895  1.00 12.66           C  
ATOM   4803  C   VAL   119      73.986  44.426  72.572  1.00 13.69           C  
ATOM   4804  O   VAL   119      73.292  44.178  71.564  1.00 14.74           O  
ATOM   4805  CB  VAL   119      75.809  46.132  72.258  1.00 13.12           C  
ATOM   4806  CG1 VAL   119      75.776  45.741  70.812  1.00 14.87           C  
ATOM   4807  CG2 VAL   119      76.195  47.602  72.424  1.00 12.12           C  
ATOM   4808  N   ASN   120      74.401  43.486  73.427  1.00 13.44           N  
ATOM   4809  CA  ASN   120      74.200  42.069  73.177  0.50 12.98           C  
ATOM   4811  C   ASN   120      72.813  41.670  73.715  1.00 13.00           C  
ATOM   4812  O   ASN   120      71.819  41.857  73.018  1.00 12.21           O  
ATOM   4813  CB  ASN   120      75.360  41.220  73.757  0.50 13.16           C  
ATOM   4815  CG  ASN   120      76.684  41.377  72.975  0.50 12.41           C  
ATOM   4817  OD1 ASN   120      76.764  41.060  71.790  0.50 13.07           O  
ATOM   4819  ND2 ASN   120      77.733  41.834  73.656  0.50 12.30           N  
ATOM   4821  N   ALA   121      72.726  41.185  74.956  1.00 12.16           N  
ATOM   4822  CA  ALA   121      71.464  40.643  75.491  1.00 11.72           C  
ATOM   4823  C   ALA   121      70.322  41.649  75.456  1.00 12.07           C  
ATOM   4824  O   ALA   121      69.208  41.328  74.996  1.00 12.16           O  
ATOM   4825  CB  ALA   121      71.669  40.131  76.946  1.00 13.02           C  
ATOM   4826  N   ARG   122      70.565  42.852  75.995  1.00 11.44           N  
ATOM   4827  CA  ARG   122      69.499  43.842  76.086  1.00 11.27           C  
ATOM   4828  C   ARG   122      69.060  44.279  74.698  1.00 10.77           C  
ATOM   4829  O   ARG   122      67.867  44.432  74.456  1.00 10.93           O  
ATOM   4830  CB  ARG   122      69.894  45.062  76.914  1.00 10.51           C  
ATOM   4831  CG  ARG   122      68.796  46.125  77.010  1.00 13.02           C  
ATOM   4832  CD  ARG   122      69.322  47.318  77.769  1.00 13.69           C  
ATOM   4833  NE  ARG   122      68.287  48.282  78.149  1.00 13.08           N  
ATOM   4834  CZ  ARG   122      67.886  49.308  77.407  1.00 15.18           C  
ATOM   4835  NH1 ARG   122      68.372  49.496  76.189  1.00 15.76           N  
ATOM   4836  NH2 ARG   122      66.952  50.136  77.870  1.00 15.43           N  
ATOM   4837  N   GLY   123      70.024  44.489  73.807  1.00 10.93           N  
ATOM   4838  CA  GLY   123      69.728  44.923  72.463  1.00 12.11           C  
ATOM   4839  C   GLY   123      68.832  43.942  71.757  1.00 10.92           C  
ATOM   4840  O   GLY   123      67.879  44.335  71.092  1.00 11.97           O  
ATOM   4841  N   SER   124      69.147  42.658  71.879  1.00 11.84           N  
ATOM   4842  CA  SER   124      68.289  41.598  71.314  1.00 12.43           C  
ATOM   4843  C   SER   124      66.855  41.606  71.898  1.00 11.52           C  
ATOM   4844  O   SER   124      65.874  41.445  71.187  1.00 12.03           O  
ATOM   4845  CB  SER   124      68.951  40.237  71.508  1.00 13.17           C  
ATOM   4846  OG  SER   124      70.098  40.135  70.688  1.00 14.58           O  
ATOM   4847  N   PHE   125      66.754  41.814  73.197  1.00 10.91           N  
ATOM   4848  CA  PHE   125      65.472  41.833  73.875  1.00 11.04           C  
ATOM   4849  C   PHE   125      64.646  43.039  73.427  1.00 10.57           C  
ATOM   4850  O   PHE   125      63.471  42.909  73.092  1.00 10.43           O  
ATOM   4851  CB  PHE   125      65.703  41.865  75.387  1.00 11.54           C  
ATOM   4852  CG  PHE   125      64.418  41.773  76.193  1.00 10.16           C  
ATOM   4853  CD1 PHE   125      63.897  40.544  76.579  1.00 13.28           C  
ATOM   4854  CD2 PHE   125      63.741  42.919  76.557  1.00 11.17           C  
ATOM   4855  CE1 PHE   125      62.693  40.470  77.301  1.00 11.83           C  
ATOM   4856  CE2 PHE   125      62.552  42.848  77.299  1.00 12.77           C  
ATOM   4857  CZ  PHE   125      62.044  41.624  77.670  1.00 12.83           C  
ATOM   4858  N   VAL   126      65.256  44.219  73.410  1.00  9.95           N  
ATOM   4859  CA  VAL   126      64.511  45.438  73.075  1.00 10.61           C  
ATOM   4860  C   VAL   126      64.085  45.414  71.595  1.00 10.08           C  
ATOM   4861  O   VAL   126      62.974  45.786  71.260  1.00  8.91           O  
ATOM   4862  CB  VAL   126      65.253  46.746  73.445  1.00 12.17           C  
ATOM   4863  CG1 VAL   126      66.411  46.975  72.549  1.00 13.03           C  
ATOM   4864  CG2 VAL   126      64.261  47.941  73.333  1.00 13.60           C  
ATOM   4865  N   CYS   127      64.940  44.918  70.706  1.00  8.78           N  
ATOM   4866  CA  CYS   127      64.556  44.829  69.293  1.00  9.64           C  
ATOM   4867  C   CYS   127      63.430  43.799  69.065  1.00  9.04           C  
ATOM   4868  O   CYS   127      62.509  44.066  68.289  1.00  9.08           O  
ATOM   4869  CB  CYS   127      65.755  44.527  68.395  1.00 11.59           C  
ATOM   4870  SG  CYS   127      66.985  45.896  68.327  1.00 12.35           S  
ATOM   4871  N   ALA   128      63.515  42.647  69.720  1.00  9.80           N  
ATOM   4872  CA  ALA   128      62.455  41.630  69.677  1.00 10.15           C  
ATOM   4873  C   ALA   128      61.138  42.245  70.181  1.00 11.65           C  
ATOM   4874  O   ALA   128      60.084  42.133  69.539  1.00 11.05           O  
ATOM   4875  CB  ALA   128      62.843  40.415  70.540  1.00 10.91           C  
ATOM   4876  N   GLN   129      61.188  42.911  71.330  1.00 11.23           N  
ATOM   4877  CA  GLN   129      59.985  43.547  71.886  1.00 11.14           C  
ATOM   4878  C   GLN   129      59.314  44.538  70.907  1.00 10.13           C  
ATOM   4879  O   GLN   129      58.088  44.591  70.759  1.00 11.68           O  
ATOM   4880  CB  GLN   129      60.369  44.283  73.190  1.00 11.56           C  
ATOM   4881  CG  GLN   129      59.181  44.730  74.003  1.00 13.69           C  
ATOM   4882  CD  GLN   129      59.602  45.485  75.254  1.00 13.88           C  
ATOM   4883  OE1 GLN   129      60.151  46.609  75.176  1.00 14.78           O  
ATOM   4884  NE2 GLN   129      59.383  44.865  76.410  1.00 12.56           N  
ATOM   4885  N   ALA   130      60.143  45.338  70.237  1.00 11.19           N  
ATOM   4886  CA  ALA   130      59.670  46.369  69.343  1.00 10.54           C  
ATOM   4887  C   ALA   130      59.142  45.773  68.036  1.00 11.30           C  
ATOM   4888  O   ALA   130      58.129  46.269  67.490  1.00 11.80           O  
ATOM   4889  CB  ALA   130      60.775  47.412  69.087  1.00 10.80           C  
ATOM   4890  N   CYS   131      59.797  44.715  67.541  1.00  9.61           N  
ATOM   4891  CA  CYS   131      59.391  44.102  66.271  1.00  9.08           C  
ATOM   4892  C   CYS   131      58.218  43.106  66.416  1.00 10.40           C  
ATOM   4893  O   CYS   131      57.470  42.901  65.465  1.00 11.49           O  
ATOM   4894  CB  CYS   131      60.552  43.393  65.597  1.00  9.36           C  
ATOM   4895  SG  CYS   131      61.871  44.495  65.006  1.00 11.22           S  
ATOM   4896  N   LEU   132      58.079  42.475  67.581  1.00 10.77           N  
ATOM   4897  CA  LEU   132      57.107  41.373  67.726  1.00  9.18           C  
ATOM   4898  C   LEU   132      55.663  41.690  67.279  1.00 10.03           C  
ATOM   4899  O   LEU   132      55.045  40.850  66.604  1.00  9.95           O  
ATOM   4900  CB  LEU   132      57.153  40.761  69.134  1.00 11.17           C  
ATOM   4901  CG  LEU   132      58.164  39.617  69.230  1.00 11.35           C  
ATOM   4902  CD1 LEU   132      58.557  39.333  70.702  1.00 13.15           C  
ATOM   4903  CD2 LEU   132      57.596  38.377  68.539  1.00 12.42           C  
ATOM   4904  N   PRO   133      55.114  42.868  67.665  1.00 10.54           N  
ATOM   4905  CA  PRO   133      53.739  43.225  67.224  1.00 11.32           C  
ATOM   4906  C   PRO   133      53.565  43.175  65.705  1.00 12.10           C  
ATOM   4907  O   PRO   133      52.485  42.830  65.204  1.00 12.95           O  
ATOM   4908  CB  PRO   133      53.538  44.635  67.781  1.00 11.39           C  
ATOM   4909  CG  PRO   133      54.421  44.675  69.013  1.00 11.30           C  
ATOM   4910  CD  PRO   133      55.667  43.877  68.578  1.00 11.32           C  
ATOM   4911  N   HIS   134      54.638  43.491  64.986  1.00 12.10           N  
ATOM   4912  CA  HIS   134      54.660  43.452  63.521  1.00 12.42           C  
ATOM   4913  C   HIS   134      54.978  42.070  62.973  1.00 12.18           C  
ATOM   4914  O   HIS   134      54.335  41.617  62.025  1.00 12.08           O  
ATOM   4915  CB  HIS   134      55.651  44.492  63.010  1.00 11.83           C  
ATOM   4916  CG  HIS   134      55.357  45.859  63.526  1.00 13.73           C  
ATOM   4917  ND1 HIS   134      54.203  46.531  63.184  1.00 13.93           N  
ATOM   4918  CD2 HIS   134      56.001  46.638  64.423  1.00 16.48           C  
ATOM   4919  CE1 HIS   134      54.173  47.687  63.821  1.00 16.64           C  
ATOM   4920  NE2 HIS   134      55.247  47.771  64.587  1.00 16.02           N  
ATOM   4921  N   LEU   135      55.956  41.390  63.574  1.00 11.61           N  
ATOM   4922  CA  LEU   135      56.254  40.010  63.200  1.00 11.72           C  
ATOM   4923  C   LEU   135      55.029  39.117  63.326  1.00 12.63           C  
ATOM   4924  O   LEU   135      54.788  38.262  62.481  1.00 12.07           O  
ATOM   4925  CB  LEU   135      57.383  39.427  64.059  1.00 11.18           C  
ATOM   4926  CG  LEU   135      58.759  40.045  63.825  1.00 11.31           C  
ATOM   4927  CD1 LEU   135      59.726  39.571  64.899  1.00 11.84           C  
ATOM   4928  CD2 LEU   135      59.269  39.678  62.420  1.00 11.63           C  
ATOM   4929  N   LEU   136      54.253  39.312  64.391  1.00 12.46           N  
ATOM   4930  CA  LEU   136      53.108  38.423  64.659  1.00 14.15           C  
ATOM   4931  C   LEU   136      52.018  38.541  63.584  1.00 16.01           C  
ATOM   4932  O   LEU   136      51.106  37.706  63.514  1.00 19.25           O  
ATOM   4933  CB  LEU   136      52.539  38.725  66.045  1.00 12.70           C  
ATOM   4934  CG  LEU   136      53.382  38.188  67.206  1.00 12.96           C  
ATOM   4935  CD1 LEU   136      52.957  38.868  68.508  1.00 14.52           C  
ATOM   4936  CD2 LEU   136      53.292  36.667  67.308  1.00 10.87           C  
ATOM   4937  N   GLN   137      52.110  39.571  62.759  1.00 16.74           N  
ATOM   4938  CA  GLN   137      51.183  39.771  61.640  1.00 18.19           C  
ATOM   4939  C   GLN   137      51.740  39.369  60.282  1.00 16.98           C  
ATOM   4940  O   GLN   137      51.024  39.422  59.274  1.00 17.55           O  
ATOM   4941  CB  GLN   137      50.766  41.225  61.630  1.00 19.63           C  
ATOM   4942  CG  GLN   137      50.111  41.555  62.966  1.00 23.17           C  
ATOM   4943  CD  GLN   137      49.402  42.830  62.973  1.00 27.69           C  
ATOM   4944  OE1 GLN   137      49.575  43.662  62.078  1.00 30.53           O  
ATOM   4945  NE2 GLN   137      48.580  43.029  64.003  1.00 30.84           N  
ATOM   4946  N   ALA   138      53.013  38.981  60.249  1.00 13.57           N  
ATOM   4947  CA  ALA   138      53.674  38.667  58.989  1.00 13.26           C  
ATOM   4948  C   ALA   138      53.365  37.223  58.577  1.00 13.01           C  
ATOM   4949  O   ALA   138      53.091  36.390  59.436  1.00 13.92           O  
ATOM   4950  CB  ALA   138      55.196  38.887  59.136  1.00 10.87           C  
ATOM   4951  N   PRO   139      53.404  36.912  57.256  1.00 13.60           N  
ATOM   4952  CA  PRO   139      53.165  35.548  56.775  1.00 14.70           C  
ATOM   4953  C   PRO   139      54.134  34.472  57.301  1.00 13.61           C  
ATOM   4954  O   PRO   139      53.723  33.352  57.564  1.00 14.84           O  
ATOM   4955  CB  PRO   139      53.284  35.676  55.245  1.00 15.05           C  
ATOM   4956  CG  PRO   139      53.252  37.102  54.932  1.00 16.25           C  
ATOM   4957  CD  PRO   139      53.571  37.875  56.152  1.00 14.63           C  
ATOM   4958  N   ASN   140      55.419  34.808  57.417  1.00 12.46           N  
ATOM   4959  CA  ASN   140      56.460  33.845  57.711  1.00 10.76           C  
ATOM   4960  C   ASN   140      57.542  34.465  58.631  1.00 10.92           C  
ATOM   4961  O   ASN   140      58.709  34.556  58.259  1.00 11.27           O  
ATOM   4962  CB  ASN   140      57.067  33.343  56.395  1.00 10.37           C  
ATOM   4963  CG  ASN   140      57.839  32.044  56.564  1.00 12.11           C  
ATOM   4964  OD1 ASN   140      57.293  31.043  57.044  1.00 12.13           O  
ATOM   4965  ND2 ASN   140      59.126  32.054  56.176  1.00 11.73           N  
ATOM   4966  N   PRO   141      57.145  34.894  59.845  1.00  9.73           N  
ATOM   4967  CA  PRO   141      57.996  35.713  60.714  1.00  8.93           C  
ATOM   4968  C   PRO   141      59.180  34.962  61.305  1.00  8.86           C  
ATOM   4969  O   PRO   141      59.015  33.848  61.832  1.00 10.00           O  
ATOM   4970  CB  PRO   141      57.056  36.160  61.844  1.00  8.95           C  
ATOM   4971  CG  PRO   141      55.917  35.154  61.826  1.00  9.54           C  
ATOM   4972  CD  PRO   141      55.826  34.603  60.458  1.00  9.92           C  
ATOM   4973  N   HIS   142      60.352  35.589  61.252  1.00  9.98           N  
ATOM   4974  CA  HIS   142      61.537  35.073  61.919  1.00  8.85           C  
ATOM   4975  C   HIS   142      62.138  36.109  62.858  1.00  8.43           C  
ATOM   4976  O   HIS   142      62.186  37.313  62.542  1.00  8.45           O  
ATOM   4977  CB  HIS   142      62.655  34.688  60.939  1.00  9.11           C  
ATOM   4978  CG  HIS   142      62.416  33.425  60.173  1.00  8.48           C  
ATOM   4979  ND1 HIS   142      63.165  32.291  60.363  1.00 10.07           N  
ATOM   4980  CD2 HIS   142      61.535  33.139  59.187  1.00  8.64           C  
ATOM   4981  CE1 HIS   142      62.749  31.350  59.525  1.00  8.26           C  
ATOM   4982  NE2 HIS   142      61.770  31.844  58.788  1.00  8.78           N  
ATOM   4983  N   ILE   143      62.666  35.625  63.979  1.00  7.13           N  
ATOM   4984  CA  ILE   143      63.736  36.341  64.693  1.00  8.08           C  
ATOM   4985  C   ILE   143      64.959  35.437  64.669  1.00  9.27           C  
ATOM   4986  O   ILE   143      64.889  34.307  65.156  1.00  8.91           O  
ATOM   4987  CB  ILE   143      63.392  36.694  66.158  1.00  7.68           C  
ATOM   4988  CG1 ILE   143      62.101  37.525  66.218  1.00  8.75           C  
ATOM   4989  CG2 ILE   143      64.586  37.385  66.855  1.00  8.80           C  
ATOM   4990  CD1 ILE   143      61.726  37.950  67.589  1.00  9.49           C  
ATOM   4991  N   LEU   144      66.067  35.939  64.131  1.00  8.41           N  
ATOM   4992  CA  LEU   144      67.316  35.177  64.084  1.00  8.62           C  
ATOM   4993  C   LEU   144      68.386  35.952  64.838  1.00  8.23           C  
ATOM   4994  O   LEU   144      68.756  37.060  64.432  1.00  8.96           O  
ATOM   4995  CB  LEU   144      67.739  34.959  62.640  1.00  9.69           C  
ATOM   4996  CG  LEU   144      68.944  33.999  62.466  1.00  7.56           C  
ATOM   4997  CD1 LEU   144      68.602  32.611  63.078  1.00 10.14           C  
ATOM   4998  CD2 LEU   144      69.312  33.862  61.003  1.00 10.82           C  
ATOM   4999  N   THR   145      68.862  35.377  65.942  1.00  7.76           N  
ATOM   5000  CA  THR   145      69.830  36.025  66.798  1.00  7.83           C  
ATOM   5001  C   THR   145      71.161  35.351  66.580  1.00  8.18           C  
ATOM   5002  O   THR   145      71.228  34.139  66.579  1.00  9.08           O  
ATOM   5003  CB  THR   145      69.395  35.948  68.263  1.00  8.67           C  
ATOM   5004  OG1 THR   145      68.161  36.674  68.398  1.00  7.71           O  
ATOM   5005  CG2 THR   145      70.427  36.543  69.196  1.00  9.71           C  
ATOM   5006  N   LEU   146      72.199  36.139  66.383  1.00  9.45           N  
ATOM   5007  CA  LEU   146      73.514  35.582  66.115  1.00  9.61           C  
ATOM   5008  C   LEU   146      74.244  35.352  67.441  1.00 10.74           C  
ATOM   5009  O   LEU   146      74.892  36.248  68.012  1.00 10.43           O  
ATOM   5010  CB  LEU   146      74.276  36.501  65.146  1.00 10.85           C  
ATOM   5011  CG  LEU   146      73.526  36.849  63.848  1.00 10.11           C  
ATOM   5012  CD1 LEU   146      74.460  37.650  62.891  1.00 11.64           C  
ATOM   5013  CD2 LEU   146      72.864  35.599  63.200  1.00 10.55           C  
ATOM   5014  N   ALA   147      74.062  34.146  67.964  1.00 10.19           N  
ATOM   5015  CA  ALA   147      74.465  33.801  69.319  1.00  9.82           C  
ATOM   5016  C   ALA   147      74.669  32.291  69.385  1.00  8.49           C  
ATOM   5017  O   ALA   147      74.109  31.543  68.580  1.00  9.17           O  
ATOM   5018  CB  ALA   147      73.416  34.232  70.355  1.00 10.13           C  
ATOM   5019  N   PRO   148      75.480  31.843  70.345  1.00  9.47           N  
ATOM   5020  CA  PRO   148      75.788  30.414  70.387  1.00  9.21           C  
ATOM   5021  C   PRO   148      74.721  29.572  71.101  1.00  9.33           C  
ATOM   5022  O   PRO   148      73.805  30.114  71.771  1.00  9.48           O  
ATOM   5023  CB  PRO   148      77.110  30.369  71.170  1.00  9.13           C  
ATOM   5024  CG  PRO   148      77.024  31.533  72.111  1.00  9.41           C  
ATOM   5025  CD  PRO   148      76.242  32.604  71.349  1.00  9.84           C  
ATOM   5026  N   PRO   149      74.825  28.242  70.970  1.00 10.68           N  
ATOM   5027  CA  PRO   149      73.992  27.398  71.799  1.00 10.84           C  
ATOM   5028  C   PRO   149      74.222  27.720  73.298  1.00 11.01           C  
ATOM   5029  O   PRO   149      75.353  28.008  73.701  1.00 11.27           O  
ATOM   5030  CB  PRO   149      74.441  25.974  71.425  1.00 11.31           C  
ATOM   5031  CG  PRO   149      75.058  26.107  70.082  1.00 13.25           C  
ATOM   5032  CD  PRO   149      75.689  27.455  70.069  1.00 11.23           C  
ATOM   5033  N   PRO   150      73.151  27.737  74.103  1.00 11.55           N  
ATOM   5034  CA  PRO   150      73.374  28.037  75.516  1.00 13.44           C  
ATOM   5035  C   PRO   150      74.165  26.917  76.172  1.00 12.69           C  
ATOM   5036  O   PRO   150      73.973  25.753  75.827  1.00 12.48           O  
ATOM   5037  CB  PRO   150      71.968  28.171  76.089  1.00 14.26           C  
ATOM   5038  CG  PRO   150      71.107  27.419  75.158  1.00 13.94           C  
ATOM   5039  CD  PRO   150      71.723  27.531  73.800  1.00 12.80           C  
ATOM   5040  N   SER   151      75.085  27.287  77.060  1.00 12.97           N  
ATOM   5041  CA  SER   151      75.913  26.337  77.760  1.00 12.67           C  
ATOM   5042  C   SER   151      76.224  26.798  79.189  1.00 11.79           C  
ATOM   5043  O   SER   151      76.415  27.985  79.449  1.00 10.95           O  
ATOM   5044  CB  SER   151      77.227  26.145  76.996  1.00 13.34           C  
ATOM   5045  OG  SER   151      78.177  25.447  77.782  1.00 15.32           O  
ATOM   5046  N   LEU   152      76.299  25.823  80.091  1.00 12.48           N  
ATOM   5047  CA  LEU   152      76.660  26.062  81.482  1.00 12.82           C  
ATOM   5048  C   LEU   152      78.100  25.619  81.746  1.00 13.82           C  
ATOM   5049  O   LEU   152      78.467  25.384  82.887  1.00 13.85           O  
ATOM   5050  CB  LEU   152      75.699  25.316  82.402  1.00 13.26           C  
ATOM   5051  CG  LEU   152      74.207  25.617  82.213  1.00 13.79           C  
ATOM   5052  CD1 LEU   152      73.254  24.806  83.109  1.00 16.95           C  
ATOM   5053  CD2 LEU   152      73.998  27.120  82.395  1.00 14.84           C  
ATOM   5054  N   ASN   153      78.909  25.520  80.696  1.00 14.56           N  
ATOM   5055  CA  ASN   153      80.316  25.120  80.813  1.00 15.16           C  
ATOM   5056  C   ASN   153      81.090  26.098  81.721  1.00 14.56           C  
ATOM   5057  O   ASN   153      81.274  27.238  81.359  1.00 12.48           O  
ATOM   5058  CB  ASN   153      80.953  25.082  79.412  1.00 15.67           C  
ATOM   5059  CG  ASN   153      82.402  24.595  79.428  1.00 18.65           C  
ATOM   5060  OD1 ASN   153      83.123  24.785  80.393  1.00 19.88           O  
ATOM   5061  ND2 ASN   153      82.818  23.947  78.351  1.00 19.99           N  
ATOM   5062  N   PRO   154      81.538  25.649  82.909  1.00 16.27           N  
ATOM   5063  CA  PRO   154      82.166  26.576  83.859  1.00 16.11           C  
ATOM   5064  C   PRO   154      83.430  27.274  83.360  1.00 16.70           C  
ATOM   5065  O   PRO   154      83.672  28.430  83.732  1.00 17.81           O  
ATOM   5066  CB  PRO   154      82.497  25.681  85.071  1.00 16.99           C  
ATOM   5067  CG  PRO   154      81.655  24.488  84.943  1.00 18.79           C  
ATOM   5068  CD  PRO   154      81.443  24.282  83.457  1.00 17.38           C  
ATOM   5069  N   ALA   155      84.241  26.569  82.574  1.00 16.28           N  
ATOM   5070  CA  ALA   155      85.427  27.138  81.941  1.00 15.99           C  
ATOM   5071  C   ALA   155      85.106  28.366  81.069  1.00 15.24           C  
ATOM   5072  O   ALA   155      85.818  29.369  81.106  1.00 14.81           O  
ATOM   5073  CB  ALA   155      86.139  26.059  81.097  1.00 16.78           C  
ATOM   5074  N   TRP   156      84.012  28.299  80.316  1.00 14.98           N  
ATOM   5075  CA  TRP   156      83.596  29.403  79.455  1.00 14.84           C  
ATOM   5076  C   TRP   156      83.109  30.615  80.265  1.00 14.80           C  
ATOM   5077  O   TRP   156      83.330  31.768  79.897  1.00 16.21           O  
ATOM   5078  CB  TRP   156      82.493  28.941  78.489  1.00 16.31           C  
ATOM   5079  CG  TRP   156      82.920  27.855  77.495  1.00 17.06           C  
ATOM   5080  CD1 TRP   156      84.188  27.333  77.315  1.00 17.90           C  
ATOM   5081  CD2 TRP   156      82.085  27.208  76.537  1.00 16.22           C  
ATOM   5082  NE1 TRP   156      84.169  26.398  76.309  1.00 17.25           N  
ATOM   5083  CE2 TRP   156      82.894  26.296  75.818  1.00 16.73           C  
ATOM   5084  CE3 TRP   156      80.726  27.305  76.212  1.00 15.91           C  
ATOM   5085  CZ2 TRP   156      82.385  25.474  74.814  1.00 17.44           C  
ATOM   5086  CZ3 TRP   156      80.223  26.489  75.198  1.00 17.20           C  
ATOM   5087  CH2 TRP   156      81.047  25.583  74.519  1.00 17.77           C  
ATOM   5088  N   TRP   157      82.424  30.329  81.366  1.00 13.94           N  
ATOM   5089  CA  TRP   157      81.970  31.353  82.284  1.00 13.64           C  
ATOM   5090  C   TRP   157      83.116  31.992  83.065  1.00 13.27           C  
ATOM   5091  O   TRP   157      83.147  33.196  83.195  1.00 14.25           O  
ATOM   5092  CB  TRP   157      80.866  30.814  83.193  1.00 12.20           C  
ATOM   5093  CG  TRP   157      79.571  30.678  82.408  1.00 11.88           C  
ATOM   5094  CD1 TRP   157      79.133  29.593  81.730  1.00 11.93           C  
ATOM   5095  CD2 TRP   157      78.629  31.738  82.126  1.00 11.22           C  
ATOM   5096  NE1 TRP   157      77.938  29.881  81.091  1.00 12.82           N  
ATOM   5097  CE2 TRP   157      77.616  31.191  81.321  1.00 11.10           C  
ATOM   5098  CE3 TRP   157      78.527  33.076  82.526  1.00 11.25           C  
ATOM   5099  CZ2 TRP   157      76.523  31.937  80.883  1.00 11.05           C  
ATOM   5100  CZ3 TRP   157      77.457  33.822  82.079  1.00 11.68           C  
ATOM   5101  CH2 TRP   157      76.459  33.249  81.274  1.00 11.49           C  
ATOM   5102  N   GLY   158      84.070  31.190  83.528  1.00 14.14           N  
ATOM   5103  CA  GLY   158      85.203  31.678  84.278  1.00 14.02           C  
ATOM   5104  C   GLY   158      86.217  32.465  83.452  1.00 14.82           C  
ATOM   5105  O   GLY   158      86.885  33.349  83.978  1.00 17.72           O  
ATOM   5106  N   ALA   159      86.317  32.154  82.153  1.00 14.72           N  
ATOM   5107  CA  ALA   159      87.318  32.745  81.267  1.00 14.94           C  
ATOM   5108  C   ALA   159      87.142  34.248  81.111  1.00 15.18           C  
ATOM   5109  O   ALA   159      88.131  34.992  81.027  1.00 16.65           O  
ATOM   5110  CB  ALA   159      87.289  32.061  79.925  1.00 13.67           C  
ATOM   5111  N   HIS   160      85.879  34.699  81.100  1.00 13.66           N  
ATOM   5112  CA  HIS   160      85.548  36.091  80.871  1.00 13.69           C  
ATOM   5113  C   HIS   160      84.069  36.260  81.181  1.00 13.04           C  
ATOM   5114  O   HIS   160      83.249  36.339  80.287  1.00 10.70           O  
ATOM   5115  CB  HIS   160      85.848  36.537  79.422  1.00 13.39           C  
ATOM   5116  CG  HIS   160      85.746  35.440  78.403  1.00 14.27           C  
ATOM   5117  ND1 HIS   160      84.553  34.824  78.087  1.00 14.09           N  
ATOM   5118  CD2 HIS   160      86.688  34.853  77.622  1.00 15.07           C  
ATOM   5119  CE1 HIS   160      84.764  33.903  77.165  1.00 16.60           C  
ATOM   5120  NE2 HIS   160      86.051  33.897  76.865  1.00 16.45           N  
ATOM   5121  N   THR   161      83.760  36.299  82.464  1.00 12.32           N  
ATOM   5122  CA  THR   161      82.368  36.278  82.925  1.00 12.36           C  
ATOM   5123  C   THR   161      81.500  37.381  82.324  1.00 11.52           C  
ATOM   5124  O   THR   161      80.342  37.142  81.929  1.00 11.52           O  
ATOM   5125  CB  THR   161      82.342  36.341  84.457  1.00 13.06           C  
ATOM   5126  OG1 THR   161      83.142  35.279  84.981  1.00 12.30           O  
ATOM   5127  CG2 THR   161      80.893  36.226  84.999  1.00 11.18           C  
ATOM   5128  N   GLY   162      82.041  38.594  82.211  1.00 11.50           N  
ATOM   5129  CA  GLY   162      81.234  39.705  81.696  1.00 11.59           C  
ATOM   5130  C   GLY   162      80.805  39.473  80.262  1.00 11.89           C  
ATOM   5131  O   GLY   162      79.656  39.683  79.899  1.00 11.18           O  
ATOM   5132  N   TYR   163      81.747  39.020  79.438  1.00 12.00           N  
ATOM   5133  CA  TYR   163      81.447  38.778  78.029  1.00 12.53           C  
ATOM   5134  C   TYR   163      80.522  37.563  77.840  1.00 12.08           C  
ATOM   5135  O   TYR   163      79.591  37.590  77.026  1.00 11.75           O  
ATOM   5136  CB  TYR   163      82.734  38.611  77.212  1.00 13.90           C  
ATOM   5137  CG  TYR   163      82.435  38.218  75.797  1.00 14.42           C  
ATOM   5138  CD1 TYR   163      81.652  39.033  74.997  1.00 14.43           C  
ATOM   5139  CD2 TYR   163      82.915  37.028  75.246  1.00 16.20           C  
ATOM   5140  CE1 TYR   163      81.350  38.696  73.705  1.00 15.28           C  
ATOM   5141  CE2 TYR   163      82.603  36.674  73.949  1.00 15.68           C  
ATOM   5142  CZ  TYR   163      81.813  37.513  73.182  1.00 14.96           C  
ATOM   5143  OH  TYR   163      81.489  37.202  71.880  1.00 17.96           O  
ATOM   5144  N   THR   164      80.803  36.493  78.569  1.00 11.34           N  
ATOM   5145  CA  THR   164      80.000  35.279  78.487  1.00 10.60           C  
ATOM   5146  C   THR   164      78.557  35.593  78.903  1.00 10.53           C  
ATOM   5147  O   THR   164      77.625  35.171  78.220  1.00 11.15           O  
ATOM   5148  CB  THR   164      80.597  34.158  79.318  1.00 10.90           C  
ATOM   5149  OG1 THR   164      81.939  33.874  78.843  1.00  9.94           O  
ATOM   5150  CG2 THR   164      79.751  32.877  79.220  1.00  8.86           C  
ATOM   5151  N   LEU   165      78.384  36.349  79.986  1.00 10.04           N  
ATOM   5152  CA  LEU   165      77.055  36.780  80.403  1.00 10.99           C  
ATOM   5153  C   LEU   165      76.352  37.508  79.259  1.00 11.20           C  
ATOM   5154  O   LEU   165      75.185  37.251  78.985  1.00 11.03           O  
ATOM   5155  CB  LEU   165      77.144  37.728  81.612  1.00 10.74           C  
ATOM   5156  CG  LEU   165      75.811  38.062  82.282  1.00 10.97           C  
ATOM   5157  CD1 LEU   165      75.159  36.786  82.895  1.00 12.62           C  
ATOM   5158  CD2 LEU   165      75.973  39.174  83.356  1.00 11.21           C  
ATOM   5159  N   ALA   166      77.068  38.431  78.604  1.00 11.10           N  
ATOM   5160  CA  ALA   166      76.474  39.264  77.550  1.00 10.84           C  
ATOM   5161  C   ALA   166      76.073  38.457  76.326  1.00 11.42           C  
ATOM   5162  O   ALA   166      74.969  38.621  75.804  1.00 10.68           O  
ATOM   5163  CB  ALA   166      77.403  40.407  77.140  1.00 11.67           C  
ATOM   5164  N   LYS   167      76.951  37.571  75.884  1.00 11.98           N  
ATOM   5165  CA  LYS   167      76.727  36.830  74.630  1.00 12.54           C  
ATOM   5166  C   LYS   167      75.839  35.627  74.874  1.00 11.75           C  
ATOM   5167  O   LYS   167      74.891  35.390  74.115  1.00 12.03           O  
ATOM   5168  CB  LYS   167      78.053  36.402  73.991  1.00 13.01           C  
ATOM   5169  CG  LYS   167      77.943  36.218  72.469  1.00 15.17           C  
ATOM   5170  CD  LYS   167      77.892  37.601  71.798  1.00 17.60           C  
ATOM   5171  CE  LYS   167      77.480  37.602  70.363  1.00 21.69           C  
ATOM   5172  NZ  LYS   167      77.482  39.019  69.896  1.00 23.77           N  
ATOM   5173  N   MET   168      76.095  34.873  75.938  1.00 10.34           N  
ATOM   5174  CA  MET   168      75.119  33.851  76.326  1.00 10.50           C  
ATOM   5175  C   MET   168      73.760  34.492  76.627  1.00 10.74           C  
ATOM   5176  O   MET   168      72.737  33.864  76.443  1.00 11.42           O  
ATOM   5177  CB  MET   168      75.592  32.997  77.487  1.00 11.10           C  
ATOM   5178  CG  MET   168      76.757  32.126  77.107  1.00 12.68           C  
ATOM   5179  SD  MET   168      76.108  30.665  75.946  1.00 19.95          SE  
ATOM   5180  CE  MET   168      77.842  29.786  75.485  1.00 10.61           C  
ATOM   5181  N   GLY   169      73.757  35.738  77.087  1.00 11.10           N  
ATOM   5182  CA  GLY   169      72.487  36.444  77.328  1.00 10.54           C  
ATOM   5183  C   GLY   169      71.662  36.546  76.068  1.00 10.60           C  
ATOM   5184  O   GLY   169      70.401  36.490  76.123  1.00  9.88           O  
ATOM   5185  N   MET   170      72.323  36.713  74.919  1.00 10.12           N  
ATOM   5186  CA  MET   170      71.602  36.754  73.648  1.00 13.27           C  
ATOM   5187  C   MET   170      70.969  35.403  73.353  1.00 11.19           C  
ATOM   5188  O   MET   170      69.841  35.333  72.875  1.00 10.49           O  
ATOM   5189  CB  MET   170      72.523  37.166  72.496  1.00 12.00           C  
ATOM   5190  CG  MET   170      72.855  38.616  72.502  1.00 14.77           C  
ATOM   5191  SD  MET   170      74.197  39.010  71.113  1.00 23.37          SE  
ATOM   5192  CE  MET   170      73.059  38.764  69.527  1.00 17.34           C  
ATOM   5193  N   SER   171      71.703  34.329  73.645  1.00 10.04           N  
ATOM   5194  CA  SER   171      71.198  32.953  73.510  1.00 10.06           C  
ATOM   5195  C   SER   171      70.010  32.670  74.429  1.00  9.55           C  
ATOM   5196  O   SER   171      69.042  32.033  74.028  1.00  8.84           O  
ATOM   5197  CB  SER   171      72.321  31.940  73.793  1.00 10.61           C  
ATOM   5198  OG  SER   171      73.515  32.341  73.128  1.00  9.88           O  
ATOM   5199  N   LEU   172      70.057  33.211  75.646  1.00  9.34           N  
ATOM   5200  CA  LEU   172      69.070  32.932  76.669  1.00  9.39           C  
ATOM   5201  C   LEU   172      67.785  33.752  76.435  1.00 10.31           C  
ATOM   5202  O   LEU   172      66.677  33.251  76.618  1.00 10.52           O  
ATOM   5203  CB  LEU   172      69.661  33.146  78.057  1.00  9.93           C  
ATOM   5204  CG  LEU   172      70.796  32.181  78.409  1.00 10.49           C  
ATOM   5205  CD1 LEU   172      71.469  32.706  79.679  1.00 13.66           C  
ATOM   5206  CD2 LEU   172      70.291  30.709  78.581  1.00 13.42           C  
ATOM   5207  N   VAL   173      67.952  34.993  75.978  1.00 11.39           N  
ATOM   5208  CA  VAL   173      66.839  35.772  75.445  1.00 10.64           C  
ATOM   5209  C   VAL   173      66.154  35.028  74.300  1.00 11.23           C  
ATOM   5210  O   VAL   173      64.918  34.943  74.269  1.00 11.24           O  
ATOM   5211  CB  VAL   173      67.291  37.195  75.021  1.00 10.93           C  
ATOM   5212  CG1 VAL   173      66.261  37.906  74.103  1.00  9.87           C  
ATOM   5213  CG2 VAL   173      67.607  38.028  76.268  1.00 11.90           C  
ATOM   5214  N   THR   174      66.938  34.471  73.376  1.00 10.79           N  
ATOM   5215  CA  THR   174      66.376  33.668  72.287  1.00 10.55           C  
ATOM   5216  C   THR   174      65.586  32.466  72.836  1.00 10.31           C  
ATOM   5217  O   THR   174      64.503  32.181  72.383  1.00  9.27           O  
ATOM   5218  CB  THR   174      67.467  33.169  71.328  1.00 11.68           C  
ATOM   5219  OG1 THR   174      68.128  34.291  70.737  1.00 10.40           O  
ATOM   5220  CG2 THR   174      66.857  32.276  70.221  1.00 14.65           C  
ATOM   5221  N   LEU   175      66.173  31.762  73.798  1.00  9.89           N  
ATOM   5222  CA  LEU   175      65.532  30.604  74.478  1.00 10.76           C  
ATOM   5223  C   LEU   175      64.148  30.968  75.037  1.00 10.60           C  
ATOM   5224  O   LEU   175      63.162  30.274  74.781  1.00 11.15           O  
ATOM   5225  CB  LEU   175      66.472  30.117  75.590  1.00 10.82           C  
ATOM   5226  CG  LEU   175      66.125  28.826  76.327  1.00 14.98           C  
ATOM   5227  CD1 LEU   175      66.054  27.656  75.367  1.00 16.59           C  
ATOM   5228  CD2 LEU   175      67.119  28.559  77.475  1.00 14.66           C  
ATOM   5229  N   GLY   176      64.076  32.093  75.745  1.00  9.37           N  
ATOM   5230  CA  GLY   176      62.833  32.576  76.339  1.00  9.14           C  
ATOM   5231  C   GLY   176      61.830  33.089  75.334  1.00  9.80           C  
ATOM   5232  O   GLY   176      60.641  32.810  75.447  1.00  9.37           O  
ATOM   5233  N   LEU   177      62.295  33.911  74.404  1.00  9.70           N  
ATOM   5234  CA  LEU   177      61.442  34.424  73.350  1.00  9.48           C  
ATOM   5235  C   LEU   177      60.778  33.274  72.550  1.00  8.52           C  
ATOM   5236  O   LEU   177      59.566  33.305  72.253  1.00  9.73           O  
ATOM   5237  CB  LEU   177      62.249  35.331  72.431  1.00  9.06           C  
ATOM   5238  CG  LEU   177      62.696  36.710  72.924  1.00 10.74           C  
ATOM   5239  CD1 LEU   177      63.597  37.313  71.853  1.00 11.62           C  
ATOM   5240  CD2 LEU   177      61.504  37.626  73.284  1.00 12.30           C  
ATOM   5241  N   ALA   178      61.566  32.256  72.216  1.00  8.43           N  
ATOM   5242  CA  ALA   178      61.093  31.109  71.453  1.00  9.28           C  
ATOM   5243  C   ALA   178      60.042  30.336  72.235  1.00 10.35           C  
ATOM   5244  O   ALA   178      59.033  29.929  71.680  1.00 12.33           O  
ATOM   5245  CB  ALA   178      62.282  30.197  71.065  1.00  8.50           C  
ATOM   5246  N   ALA   179      60.254  30.180  73.533  1.00  9.75           N  
ATOM   5247  CA  ALA   179      59.303  29.481  74.387  1.00  9.25           C  
ATOM   5248  C   ALA   179      58.010  30.275  74.495  1.00  9.33           C  
ATOM   5249  O   ALA   179      56.932  29.689  74.462  1.00 11.27           O  
ATOM   5250  CB  ALA   179      59.889  29.198  75.767  1.00  9.17           C  
ATOM   5251  N   GLU   180      58.102  31.598  74.575  1.00  9.20           N  
ATOM   5252  CA  GLU   180      56.897  32.431  74.672  1.00 10.66           C  
ATOM   5253  C   GLU   180      56.156  32.548  73.327  1.00 11.36           C  
ATOM   5254  O   GLU   180      54.948  32.296  73.260  1.00 13.31           O  
ATOM   5255  CB  GLU   180      57.199  33.824  75.238  1.00 10.57           C  
ATOM   5256  CG  GLU   180      55.909  34.623  75.449  1.00 12.04           C  
ATOM   5257  CD  GLU   180      56.024  35.918  76.272  1.00 12.93           C  
ATOM   5258  OE1 GLU   180      57.140  36.401  76.585  1.00 12.71           O  
ATOM   5259  OE2 GLU   180      54.928  36.453  76.579  1.00 13.47           O  
ATOM   5260  N   PHE   181      56.876  32.935  72.268  1.00 10.03           N  
ATOM   5261  CA  PHE   181      56.241  33.340  71.006  1.00  9.11           C  
ATOM   5262  C   PHE   181      56.311  32.308  69.872  1.00  9.14           C  
ATOM   5263  O   PHE   181      55.526  32.373  68.907  1.00  8.76           O  
ATOM   5264  CB  PHE   181      56.790  34.687  70.529  1.00  8.81           C  
ATOM   5265  CG  PHE   181      56.602  35.780  71.528  1.00  8.08           C  
ATOM   5266  CD1 PHE   181      55.378  36.399  71.658  1.00 10.81           C  
ATOM   5267  CD2 PHE   181      57.633  36.145  72.383  1.00  8.50           C  
ATOM   5268  CE1 PHE   181      55.179  37.385  72.606  1.00 13.06           C  
ATOM   5269  CE2 PHE   181      57.445  37.144  73.331  1.00 11.65           C  
ATOM   5270  CZ  PHE   181      56.206  37.750  73.445  1.00 10.19           C  
ATOM   5271  N   GLY   182      57.243  31.373  69.976  1.00  8.25           N  
ATOM   5272  CA  GLY   182      57.374  30.259  69.046  1.00  9.83           C  
ATOM   5273  C   GLY   182      56.049  29.554  68.803  1.00 10.22           C  
ATOM   5274  O   GLY   182      55.683  29.290  67.645  1.00 10.48           O  
ATOM   5275  N   PRO   183      55.312  29.266  69.892  1.00 11.08           N  
ATOM   5276  CA  PRO   183      53.963  28.671  69.718  1.00 12.39           C  
ATOM   5277  C   PRO   183      52.947  29.455  68.867  1.00 13.67           C  
ATOM   5278  O   PRO   183      52.015  28.824  68.319  1.00 14.71           O  
ATOM   5279  CB  PRO   183      53.482  28.491  71.155  1.00 12.40           C  
ATOM   5280  CG  PRO   183      54.800  28.346  71.972  1.00 11.55           C  
ATOM   5281  CD  PRO   183      55.674  29.382  71.314  1.00 12.27           C  
ATOM   5282  N   GLN   184      53.152  30.767  68.710  1.00 13.30           N  
ATOM   5283  CA  GLN   184      52.369  31.623  67.809  1.00 15.86           C  
ATOM   5284  C   GLN   184      52.832  31.589  66.346  1.00 15.32           C  
ATOM   5285  O   GLN   184      52.274  32.308  65.506  1.00 16.18           O  
ATOM   5286  CB  GLN   184      52.369  33.073  68.290  1.00 17.64           C  
ATOM   5287  CG  GLN   184      51.963  33.232  69.728  1.00 22.03           C  
ATOM   5288  CD  GLN   184      51.321  34.561  69.989  1.00 25.53           C  
ATOM   5289  OE1 GLN   184      50.299  34.902  69.375  1.00 29.99           O  
ATOM   5290  NE2 GLN   184      51.912  35.335  70.875  1.00 25.73           N  
ATOM   5291  N   GLY   185      53.845  30.777  66.061  1.00 13.43           N  
ATOM   5292  CA  GLY   185      54.344  30.563  64.705  1.00 13.34           C  
ATOM   5293  C   GLY   185      55.509  31.472  64.316  1.00 12.38           C  
ATOM   5294  O   GLY   185      55.856  31.555  63.128  1.00 11.77           O  
ATOM   5295  N   VAL   186      56.104  32.158  65.283  1.00 11.41           N  
ATOM   5296  CA  VAL   186      57.310  32.964  65.015  1.00  9.94           C  
ATOM   5297  C   VAL   186      58.534  32.043  65.073  1.00 10.45           C  
ATOM   5298  O   VAL   186      58.731  31.360  66.068  1.00 10.06           O  
ATOM   5299  CB  VAL   186      57.482  34.150  66.025  1.00 10.23           C  
ATOM   5300  CG1 VAL   186      58.684  35.044  65.578  1.00  8.77           C  
ATOM   5301  CG2 VAL   186      56.174  34.979  66.166  1.00 12.50           C  
ATOM   5302  N   ALA   187      59.359  32.039  64.016  1.00  9.98           N  
ATOM   5303  CA  ALA   187      60.599  31.240  63.996  1.00  9.28           C  
ATOM   5304  C   ALA   187      61.705  32.004  64.719  1.00  8.67           C  
ATOM   5305  O   ALA   187      62.406  32.837  64.124  1.00  9.41           O  
ATOM   5306  CB  ALA   187      61.005  30.888  62.601  1.00 10.54           C  
ATOM   5307  N   ILE   188      61.829  31.731  66.019  1.00  7.96           N  
ATOM   5308  CA  ILE   188      62.789  32.419  66.865  1.00  7.80           C  
ATOM   5309  C   ILE   188      63.915  31.423  67.152  1.00  7.32           C  
ATOM   5310  O   ILE   188      63.735  30.474  67.939  1.00  7.86           O  
ATOM   5311  CB  ILE   188      62.138  32.927  68.173  1.00  8.58           C  
ATOM   5312  CG1 ILE   188      60.963  33.856  67.842  1.00  8.13           C  
ATOM   5313  CG2 ILE   188      63.167  33.613  69.044  1.00  8.17           C  
ATOM   5314  CD1 ILE   188      60.276  34.446  69.053  1.00  8.96           C  
ATOM   5315  N   ASN   189      65.061  31.656  66.507  1.00  7.47           N  
ATOM   5316  CA  ASN   189      66.195  30.746  66.563  1.00  6.87           C  
ATOM   5317  C   ASN   189      67.498  31.548  66.687  1.00  8.06           C  
ATOM   5318  O   ASN   189      67.479  32.781  66.546  1.00  8.59           O  
ATOM   5319  CB  ASN   189      66.229  29.878  65.307  1.00  6.70           C  
ATOM   5320  CG  ASN   189      64.984  29.063  65.129  1.00  7.66           C  
ATOM   5321  OD1 ASN   189      64.724  28.150  65.905  1.00  7.79           O  
ATOM   5322  ND2 ASN   189      64.198  29.391  64.107  1.00 12.41           N  
ATOM   5323  N   ALA   190      68.609  30.835  66.915  1.00  8.26           N  
ATOM   5324  CA  ALA   190      69.944  31.450  66.876  1.00  9.32           C  
ATOM   5325  C   ALA   190      70.812  30.760  65.807  1.00  9.09           C  
ATOM   5326  O   ALA   190      70.573  29.599  65.475  1.00 10.07           O  
ATOM   5327  CB  ALA   190      70.648  31.359  68.209  1.00  9.25           C  
ATOM   5328  N   LEU   191      71.816  31.489  65.330  1.00 10.36           N  
ATOM   5329  CA  LEU   191      72.845  31.007  64.377  1.00  9.17           C  
ATOM   5330  C   LEU   191      74.238  31.462  64.835  1.00  9.57           C  
ATOM   5331  O   LEU   191      74.447  32.636  65.207  1.00  8.55           O  
ATOM   5332  CB  LEU   191      72.578  31.536  62.977  1.00  9.89           C  
ATOM   5333  CG  LEU   191      73.450  31.125  61.779  1.00 10.91           C  
ATOM   5334  CD1 LEU   191      73.372  29.626  61.545  1.00 10.30           C  
ATOM   5335  CD2 LEU   191      73.041  31.909  60.526  1.00  8.61           C  
ATOM   5336  N   TRP   192      75.178  30.531  64.784  1.00  9.45           N  
ATOM   5337  CA  TRP   192      76.544  30.741  65.277  1.00  9.01           C  
ATOM   5338  C   TRP   192      77.514  30.051  64.316  1.00  9.84           C  
ATOM   5339  O   TRP   192      77.222  28.952  63.839  1.00 10.90           O  
ATOM   5340  CB  TRP   192      76.679  30.144  66.673  1.00 10.80           C  
ATOM   5341  CG  TRP   192      77.856  30.603  67.439  1.00 10.61           C  
ATOM   5342  CD1 TRP   192      78.886  29.835  67.918  1.00 11.57           C  
ATOM   5343  CD2 TRP   192      78.141  31.952  67.839  1.00  9.13           C  
ATOM   5344  NE1 TRP   192      79.795  30.622  68.579  1.00 11.20           N  
ATOM   5345  CE2 TRP   192      79.364  31.923  68.557  1.00 11.68           C  
ATOM   5346  CE3 TRP   192      77.485  33.174  67.670  1.00 10.78           C  
ATOM   5347  CZ2 TRP   192      79.937  33.070  69.096  1.00 11.29           C  
ATOM   5348  CZ3 TRP   192      78.054  34.314  68.202  1.00 11.27           C  
ATOM   5349  CH2 TRP   192      79.278  34.253  68.914  1.00 12.30           C  
ATOM   5350  N   PRO   193      78.667  30.690  64.040  1.00  9.62           N  
ATOM   5351  CA  PRO   193      79.621  30.077  63.136  1.00 10.38           C  
ATOM   5352  C   PRO   193      80.513  29.019  63.797  1.00 10.94           C  
ATOM   5353  O   PRO   193      80.984  29.202  64.911  1.00  9.98           O  
ATOM   5354  CB  PRO   193      80.468  31.273  62.659  1.00 11.12           C  
ATOM   5355  CG  PRO   193      80.326  32.291  63.639  1.00 10.94           C  
ATOM   5356  CD  PRO   193      79.099  32.025  64.469  1.00 10.76           C  
ATOM   5357  N   ARG   194      80.776  27.930  63.080  1.00 10.77           N  
ATOM   5358  CA  ARG   194      81.727  26.913  63.570  1.00 10.69           C  
ATOM   5359  C   ARG   194      83.095  27.509  63.851  1.00 10.70           C  
ATOM   5360  O   ARG   194      83.748  27.156  64.828  1.00  9.13           O  
ATOM   5361  CB  ARG   194      81.890  25.806  62.532  1.00 11.19           C  
ATOM   5362  CG  ARG   194      82.814  24.686  62.960  1.00 11.22           C  
ATOM   5363  CD  ARG   194      82.180  23.835  64.078  1.00 12.94           C  
ATOM   5364  NE  ARG   194      81.005  23.167  63.543  1.00 12.73           N  
ATOM   5365  CZ  ARG   194      80.118  22.480  64.255  1.00 14.19           C  
ATOM   5366  NH1 ARG   194      80.286  22.324  65.558  1.00 16.53           N  
ATOM   5367  NH2 ARG   194      79.055  21.952  63.652  1.00 14.05           N  
ATOM   5368  N   THR   195      83.534  28.379  62.955  1.00 11.24           N  
ATOM   5369  CA  THR   195      84.879  28.978  63.046  1.00 11.59           C  
ATOM   5370  C   THR   195      84.790  30.461  63.425  1.00 12.97           C  
ATOM   5371  O   THR   195      83.704  31.053  63.383  1.00 13.53           O  
ATOM   5372  CB  THR   195      85.620  28.929  61.676  1.00 12.60           C  
ATOM   5373  OG1 THR   195      85.032  29.877  60.754  1.00 11.19           O  
ATOM   5374  CG2 THR   195      85.676  27.489  61.118  1.00 12.90           C  
ATOM   5375  N   VAL   196      85.942  31.073  63.701  1.00 11.44           N  
ATOM   5376  CA  VAL   196      86.008  32.521  63.839  1.00 11.47           C  
ATOM   5377  C   VAL   196      85.730  33.097  62.442  1.00 11.64           C  
ATOM   5378  O   VAL   196      86.074  32.485  61.403  1.00 10.13           O  
ATOM   5379  CB  VAL   196      87.356  33.001  64.413  1.00 11.27           C  
ATOM   5380  CG1 VAL   196      87.401  34.512  64.542  1.00 12.44           C  
ATOM   5381  CG2 VAL   196      87.597  32.355  65.780  1.00 10.12           C  
ATOM   5382  N   ILE   197      85.028  34.226  62.435  1.00 12.21           N  
ATOM   5383  CA  ILE   197      84.747  34.958  61.223  1.00 13.19           C  
ATOM   5384  C   ILE   197      85.583  36.247  61.188  1.00 14.47           C  
ATOM   5385  O   ILE   197      85.707  36.958  62.194  1.00 14.39           O  
ATOM   5386  CB  ILE   197      83.248  35.297  61.152  1.00 12.45           C  
ATOM   5387  CG1 ILE   197      82.388  34.023  61.239  1.00 13.93           C  
ATOM   5388  CG2 ILE   197      82.920  36.119  59.895  1.00 13.55           C  
ATOM   5389  CD1 ILE   197      82.545  33.084  60.053  1.00 14.19           C  
ATOM   5390  N   ALA   198      86.141  36.551  60.019  1.00 16.97           N  
ATOM   5391  CA  ALA   198      86.989  37.753  59.860  1.00 17.70           C  
ATOM   5392  C   ALA   198      86.111  39.009  59.807  1.00 18.75           C  
ATOM   5393  O   ALA   198      85.349  39.217  58.860  1.00 18.30           O  
ATOM   5394  CB  ALA   198      87.888  37.641  58.600  1.00 17.80           C  
ATOM   5395  N   THR   199      86.212  39.798  60.868  1.00 21.42           N  
ATOM   5396  CA  THR   199      85.578  41.116  61.002  1.00 24.66           C  
ATOM   5397  C   THR   199      86.500  41.968  61.873  1.00 26.60           C  
ATOM   5398  O   THR   199      87.403  41.432  62.484  1.00 26.00           O  
ATOM   5399  CB  THR   199      84.227  41.037  61.739  1.00 25.02           C  
ATOM   5400  OG1 THR   199      84.442  40.752  63.136  1.00 26.53           O  
ATOM   5401  CG2 THR   199      83.326  39.977  61.142  1.00 25.09           C  
ATOM   5402  N   ASP   200      86.223  43.270  61.970  1.00 29.31           N  
ATOM   5403  CA  ASP   200      86.932  44.183  62.889  1.00 30.32           C  
ATOM   5404  C   ASP   200      87.104  43.664  64.326  1.00 31.53           C  
ATOM   5405  O   ASP   200      88.110  43.967  64.981  1.00 32.46           O  
ATOM   5406  CB  ASP   200      86.198  45.525  62.943  1.00 31.47           C  
ATOM   5407  N   ALA   201      86.135  42.878  64.800  1.00 31.69           N  
ATOM   5408  CA  ALA   201      86.127  42.324  66.166  1.00 31.93           C  
ATOM   5409  C   ALA   201      87.251  41.332  66.487  1.00 32.03           C  
ATOM   5410  O   ALA   201      87.487  41.038  67.662  1.00 31.34           O  
ATOM   5411  CB  ALA   201      84.795  41.663  66.443  1.00 32.18           C  
ATOM   5412  N   ILE   202      87.932  40.801  65.467  1.00 31.53           N  
ATOM   5413  CA  ILE   202      89.063  39.902  65.713  1.00 31.58           C  
ATOM   5414  C   ILE   202      90.234  40.678  66.357  1.00 32.11           C  
ATOM   5415  O   ILE   202      91.125  40.084  66.978  1.00 31.21           O  
ATOM   5416  CB  ILE   202      89.485  39.082  64.436  1.00 31.88           C  
ATOM   5417  CG1 ILE   202      90.197  39.944  63.389  1.00 32.24           C  
ATOM   5418  CG2 ILE   202      88.262  38.397  63.811  1.00 31.23           C  
ATOM   5419  CD1 ILE   202      90.743  39.116  62.219  1.00 31.43           C  
ATOM   5420  N   ASN   203      90.198  42.007  66.237  1.00 32.73           N  
ATOM   5421  CA  ASN   203      91.054  42.892  67.029  1.00 34.45           C  
ATOM   5422  C   ASN   203      90.952  42.646  68.543  1.00 35.71           C  
ATOM   5423  O   ASN   203      91.914  42.909  69.274  1.00 36.12           O  
ATOM   5424  CB  ASN   203      90.715  44.354  66.734  1.00 34.31           C  
ATOM   5425  N   MET   204      89.790  42.155  68.997  1.00 36.69           N  
ATOM   5426  CA  MET   204      89.535  41.843  70.422  1.00 38.17           C  
ATOM   5427  C   MET   204      89.874  40.391  70.771  1.00 37.20           C  
ATOM   5428  O   MET   204      89.632  39.938  71.896  1.00 36.41           O  
ATOM   5429  CB  MET   204      88.062  42.091  70.766  1.00 40.03           C  
ATOM   5430  CG  MET   204      87.529  43.449  70.311  1.00 44.85           C  
ATOM   5431  SD  MET   204      88.510  44.923  71.156  1.00 54.38          SE  
ATOM   5432  CE  MET   204      87.862  44.661  72.974  1.00 51.52           C  
ATOM   5433  N   LEU   205      90.416  39.671  69.793  1.00 35.72           N  
ATOM   5434  CA  LEU   205      90.858  38.304  69.967  1.00 34.98           C  
ATOM   5435  C   LEU   205      92.377  38.279  69.775  1.00 35.18           C  
ATOM   5436  O   LEU   205      92.865  38.245  68.643  1.00 34.54           O  
ATOM   5437  CB  LEU   205      90.148  37.394  68.952  1.00 34.68           C  
ATOM   5438  CG  LEU   205      88.614  37.490  68.924  1.00 33.90           C  
ATOM   5439  CD1 LEU   205      88.037  36.670  67.789  1.00 33.73           C  
ATOM   5440  CD2 LEU   205      88.026  37.038  70.242  1.00 32.96           C  
ATOM   5441  N   PRO   206      93.136  38.348  70.882  1.00 35.71           N  
ATOM   5442  CA  PRO   206      94.597  38.309  70.775  1.00 35.39           C  
ATOM   5443  C   PRO   206      95.100  37.148  69.922  1.00 34.40           C  
ATOM   5444  O   PRO   206      94.643  36.016  70.072  1.00 34.60           O  
ATOM   5445  CB  PRO   206      95.058  38.150  72.229  1.00 35.54           C  
ATOM   5446  CG  PRO   206      93.972  38.750  73.037  1.00 36.25           C  
ATOM   5447  CD  PRO   206      92.692  38.510  72.281  1.00 36.21           C  
ATOM   5448  N   GLY   207      96.019  37.451  69.015  1.00 34.01           N  
ATOM   5449  CA  GLY   207      96.646  36.439  68.171  1.00 33.22           C  
ATOM   5450  C   GLY   207      95.911  36.060  66.890  1.00 32.07           C  
ATOM   5451  O   GLY   207      96.522  35.448  66.002  1.00 32.72           O  
ATOM   5452  N   VAL   208      94.624  36.409  66.783  1.00 30.05           N  
ATOM   5453  CA  VAL   208      93.756  35.957  65.671  1.00 27.96           C  
ATOM   5454  C   VAL   208      93.990  36.753  64.385  1.00 27.04           C  
ATOM   5455  O   VAL   208      93.672  37.942  64.316  1.00 27.08           O  
ATOM   5456  CB  VAL   208      92.250  36.048  66.054  1.00 28.33           C  
ATOM   5457  CG1 VAL   208      91.345  35.662  64.876  1.00 26.35           C  
ATOM   5458  CG2 VAL   208      91.955  35.168  67.254  1.00 27.54           C  
ATOM   5459  N   ASP   209      94.530  36.087  63.365  1.00 24.99           N  
ATOM   5460  CA  ASP   209      94.710  36.684  62.039  1.00 23.73           C  
ATOM   5461  C   ASP   209      93.466  36.381  61.216  1.00 21.98           C  
ATOM   5462  O   ASP   209      92.914  35.275  61.322  1.00 22.45           O  
ATOM   5463  CB  ASP   209      95.953  36.107  61.337  1.00 24.39           C  
ATOM   5464  N   ALA   210      93.033  37.354  60.414  1.00 19.90           N  
ATOM   5465  CA  ALA   210      91.928  37.172  59.477  1.00 18.55           C  
ATOM   5466  C   ALA   210      92.178  35.961  58.577  1.00 18.54           C  
ATOM   5467  O   ALA   210      91.233  35.279  58.206  1.00 16.36           O  
ATOM   5468  CB  ALA   210      91.725  38.381  58.635  1.00 18.39           C  
ATOM   5469  N   ALA   211      93.453  35.698  58.251  1.00 19.22           N  
ATOM   5470  CA  ALA   211      93.823  34.559  57.396  1.00 19.77           C  
ATOM   5471  C   ALA   211      93.396  33.177  57.928  1.00 18.66           C  
ATOM   5472  O   ALA   211      93.265  32.230  57.141  1.00 19.01           O  
ATOM   5473  CB  ALA   211      95.327  34.572  57.128  1.00 21.00           C  
ATOM   5474  N   ALA   212      93.189  33.060  59.243  1.00 17.16           N  
ATOM   5475  CA  ALA   212      92.806  31.799  59.875  1.00 17.32           C  
ATOM   5476  C   ALA   212      91.303  31.720  60.146  1.00 15.98           C  
ATOM   5477  O   ALA   212      90.850  30.865  60.903  1.00 16.45           O  
ATOM   5478  CB  ALA   212      93.583  31.597  61.193  1.00 19.36           C  
ATOM   5479  N   CYS   213      90.548  32.587  59.477  1.00 15.68           N  
ATOM   5480  CA  CYS   213      89.096  32.724  59.665  1.00 14.96           C  
ATOM   5481  C   CYS   213      88.347  32.398  58.401  1.00 13.90           C  
ATOM   5482  O   CYS   213      88.930  32.247  57.312  1.00 11.30           O  
ATOM   5483  CB  CYS   213      88.779  34.173  60.037  1.00 16.04           C  
ATOM   5484  SG  CYS   213      89.465  34.687  61.599  1.00 18.31           S  
ATOM   5485  N   ARG   214      87.028  32.321  58.541  1.00 11.55           N  
ATOM   5486  CA  ARG   214      86.146  32.352  57.377  1.00 11.17           C  
ATOM   5487  C   ARG   214      85.580  33.749  57.101  1.00 11.47           C  
ATOM   5488  O   ARG   214      85.539  34.626  57.993  1.00 10.53           O  
ATOM   5489  CB  ARG   214      85.013  31.352  57.523  1.00  9.96           C  
ATOM   5490  CG  ARG   214      85.378  29.941  57.116  1.00 10.13           C  
ATOM   5491  CD  ARG   214      84.332  28.940  57.540  1.00 13.06           C  
ATOM   5492  NE  ARG   214      84.674  27.599  57.086  1.00 11.49           N  
ATOM   5493  CZ  ARG   214      84.153  26.484  57.587  1.00 14.37           C  
ATOM   5494  NH1 ARG   214      83.233  26.531  58.552  1.00 14.60           N  
ATOM   5495  NH2 ARG   214      84.546  25.319  57.082  1.00 15.69           N  
ATOM   5496  N   ARG   215      85.191  33.946  55.854  1.00 11.96           N  
ATOM   5497  CA  ARG   215      84.573  35.193  55.404  1.00 13.62           C  
ATOM   5498  C   ARG   215      83.150  35.307  55.975  1.00 13.79           C  
ATOM   5499  O   ARG   215      82.469  34.282  56.179  1.00 11.81           O  
ATOM   5500  CB  ARG   215      84.546  35.244  53.871  1.00 15.28           C  
ATOM   5501  CG  ARG   215      85.990  35.211  53.309  1.00 18.33           C  
ATOM   5502  CD  ARG   215      86.047  35.215  51.806  1.00 24.21           C  
ATOM   5503  NE  ARG   215      85.094  34.272  51.253  1.00 28.15           N  
ATOM   5504  CZ  ARG   215      84.003  34.585  50.547  1.00 29.00           C  
ATOM   5505  NH1 ARG   215      83.716  35.842  50.227  1.00 30.59           N  
ATOM   5506  NH2 ARG   215      83.203  33.614  50.121  1.00 28.92           N  
ATOM   5507  N   PRO   216      82.682  36.556  56.199  1.00 13.39           N  
ATOM   5508  CA  PRO   216      81.301  36.730  56.690  1.00 13.19           C  
ATOM   5509  C   PRO   216      80.209  36.108  55.804  1.00 12.29           C  
ATOM   5510  O   PRO   216      79.103  35.859  56.313  1.00 10.07           O  
ATOM   5511  CB  PRO   216      81.120  38.247  56.741  1.00 14.69           C  
ATOM   5512  CG  PRO   216      82.496  38.852  56.576  1.00 16.80           C  
ATOM   5513  CD  PRO   216      83.400  37.829  56.004  1.00 13.98           C  
ATOM   5514  N   GLU   217      80.494  35.898  54.504  1.00 10.14           N  
ATOM   5515  CA  GLU   217      79.524  35.356  53.563  1.00  9.80           C  
ATOM   5516  C   GLU   217      79.001  33.955  53.979  1.00  9.93           C  
ATOM   5517  O   GLU   217      77.877  33.596  53.621  1.00 10.64           O  
ATOM   5518  CB  GLU   217      80.075  35.346  52.131  1.00 11.56           C  
ATOM   5519  CG  GLU   217      80.152  36.741  51.466  1.00 13.90           C  
ATOM   5520  CD  GLU   217      81.203  37.674  52.049  1.00 15.89           C  
ATOM   5521  OE1 GLU   217      82.190  37.184  52.627  1.00 14.96           O  
ATOM   5522  OE2 GLU   217      81.053  38.924  51.907  1.00 19.39           O  
ATOM   5523  N   ILE   218      79.782  33.174  54.733  1.00  9.54           N  
ATOM   5524  CA  ILE   218      79.265  31.870  55.216  1.00  9.51           C  
ATOM   5525  C   ILE   218      78.061  32.085  56.149  1.00  8.43           C  
ATOM   5526  O   ILE   218      77.044  31.361  56.049  1.00  9.07           O  
ATOM   5527  CB  ILE   218      80.356  30.962  55.875  1.00  9.51           C  
ATOM   5528  CG1 ILE   218      79.776  29.532  56.010  1.00 10.71           C  
ATOM   5529  CG2 ILE   218      80.869  31.523  57.243  1.00  9.59           C  
ATOM   5530  CD1 ILE   218      80.721  28.472  56.519  1.00 10.01           C  
ATOM   5531  N   MET   219      78.160  33.092  57.012  1.00  8.08           N  
ATOM   5532  CA  MET   219      77.037  33.462  57.908  1.00  9.75           C  
ATOM   5533  C   MET   219      75.877  34.075  57.105  1.00  9.33           C  
ATOM   5534  O   MET   219      74.705  33.796  57.393  1.00  8.50           O  
ATOM   5535  CB  MET   219      77.517  34.361  59.036  1.00 10.70           C  
ATOM   5536  CG  MET   219      78.318  33.632  60.104  1.00 10.83           C  
ATOM   5537  SD  MET   219      77.132  32.461  61.178  1.00 19.24          SE  
ATOM   5538  CE  MET   219      76.251  33.854  62.236  1.00 13.10           C  
ATOM   5539  N   ALA   220      76.175  34.864  56.093  1.00  9.79           N  
ATOM   5540  CA  ALA   220      75.142  35.398  55.209  1.00  8.81           C  
ATOM   5541  C   ALA   220      74.358  34.282  54.515  1.00 10.55           C  
ATOM   5542  O   ALA   220      73.131  34.330  54.420  1.00 10.80           O  
ATOM   5543  CB  ALA   220      75.776  36.335  54.162  1.00  9.90           C  
ATOM   5544  N   ASP   221      75.076  33.305  53.986  1.00  9.26           N  
ATOM   5545  CA  ASP   221      74.465  32.207  53.244  1.00 10.44           C  
ATOM   5546  C   ASP   221      73.722  31.244  54.162  1.00  8.96           C  
ATOM   5547  O   ASP   221      72.638  30.797  53.816  1.00  9.98           O  
ATOM   5548  CB  ASP   221      75.522  31.469  52.396  1.00 10.47           C  
ATOM   5549  CG  ASP   221      76.035  32.329  51.208  1.00 12.58           C  
ATOM   5550  OD1 ASP   221      75.426  33.389  50.886  1.00 12.60           O  
ATOM   5551  OD2 ASP   221      77.070  31.951  50.616  1.00 13.20           O  
ATOM   5552  N   ALA   222      74.281  30.981  55.344  1.00 10.14           N  
ATOM   5553  CA  ALA   222      73.588  30.148  56.343  1.00  9.51           C  
ATOM   5554  C   ALA   222      72.310  30.883  56.806  1.00  8.92           C  
ATOM   5555  O   ALA   222      71.228  30.287  56.887  1.00  9.18           O  
ATOM   5556  CB  ALA   222      74.463  29.823  57.531  1.00 10.57           C  
ATOM   5557  N   ALA   223      72.426  32.185  57.037  1.00  8.48           N  
ATOM   5558  CA  ALA   223      71.247  32.982  57.416  1.00  8.96           C  
ATOM   5559  C   ALA   223      70.127  32.893  56.386  1.00  9.41           C  
ATOM   5560  O   ALA   223      68.957  32.691  56.744  1.00  9.64           O  
ATOM   5561  CB  ALA   223      71.641  34.461  57.673  1.00  8.23           C  
ATOM   5562  N   HIS   224      70.468  33.020  55.111  1.00  9.26           N  
ATOM   5563  CA  HIS   224      69.485  32.935  54.044  1.00  9.24           C  
ATOM   5564  C   HIS   224      68.758  31.592  54.086  1.00  8.64           C  
ATOM   5565  O   HIS   224      67.525  31.505  53.908  1.00  9.28           O  
ATOM   5566  CB  HIS   224      70.181  33.124  52.698  1.00 10.68           C  
ATOM   5567  CG  HIS   224      69.238  33.111  51.541  1.00 11.78           C  
ATOM   5568  ND1 HIS   224      68.859  31.952  50.898  1.00 13.37           N  
ATOM   5569  CD2 HIS   224      68.592  34.121  50.920  1.00 13.87           C  
ATOM   5570  CE1 HIS   224      68.030  32.255  49.914  1.00 15.01           C  
ATOM   5571  NE2 HIS   224      67.844  33.563  49.912  1.00 14.14           N  
ATOM   5572  N   ALA   225      69.517  30.529  54.318  1.00  9.29           N  
ATOM   5573  CA  ALA   225      68.954  29.178  54.338  1.00 10.35           C  
ATOM   5574  C   ALA   225      67.978  29.020  55.497  1.00 10.67           C  
ATOM   5575  O   ALA   225      66.974  28.344  55.368  1.00 13.06           O  
ATOM   5576  CB  ALA   225      70.037  28.143  54.416  1.00 10.21           C  
ATOM   5577  N   VAL   226      68.296  29.623  56.629  1.00  9.64           N  
ATOM   5578  CA  VAL   226      67.402  29.632  57.786  1.00  8.31           C  
ATOM   5579  C   VAL   226      66.149  30.466  57.514  1.00  9.05           C  
ATOM   5580  O   VAL   226      65.042  30.008  57.759  1.00  8.06           O  
ATOM   5581  CB  VAL   226      68.089  30.177  59.040  1.00  9.54           C  
ATOM   5582  CG1 VAL   226      67.026  30.386  60.150  1.00  9.38           C  
ATOM   5583  CG2 VAL   226      69.208  29.249  59.496  1.00  8.88           C  
ATOM   5584  N   LEU   227      66.339  31.679  57.008  1.00  8.80           N  
ATOM   5585  CA  LEU   227      65.269  32.685  56.902  1.00  7.62           C  
ATOM   5586  C   LEU   227      64.221  32.400  55.830  1.00  9.30           C  
ATOM   5587  O   LEU   227      63.134  32.981  55.859  1.00 11.38           O  
ATOM   5588  CB  LEU   227      65.853  34.086  56.720  1.00  7.31           C  
ATOM   5589  CG  LEU   227      66.660  34.626  57.912  1.00  7.53           C  
ATOM   5590  CD1 LEU   227      67.456  35.893  57.453  1.00  7.82           C  
ATOM   5591  CD2 LEU   227      65.807  34.868  59.162  1.00  7.82           C  
ATOM   5592  N   THR   228      64.565  31.532  54.877  1.00 10.84           N  
ATOM   5593  CA  THR   228      63.640  31.106  53.834  1.00 11.21           C  
ATOM   5594  C   THR   228      62.902  29.813  54.207  1.00 12.51           C  
ATOM   5595  O   THR   228      62.089  29.324  53.427  1.00 13.36           O  
ATOM   5596  CB  THR   228      64.356  30.943  52.480  1.00 11.28           C  
ATOM   5597  OG1 THR   228      65.490  30.071  52.623  1.00 11.86           O  
ATOM   5598  CG2 THR   228      64.823  32.305  51.925  1.00 10.49           C  
ATOM   5599  N   ARG   229      63.164  29.275  55.392  1.00 12.31           N  
ATOM   5600  CA  ARG   229      62.398  28.131  55.886  1.00 13.02           C  
ATOM   5601  C   ARG   229      61.036  28.582  56.366  1.00 12.41           C  
ATOM   5602  O   ARG   229      60.857  29.699  56.833  1.00 11.12           O  
ATOM   5603  CB  ARG   229      63.131  27.449  57.042  1.00 13.90           C  
ATOM   5604  CG  ARG   229      64.361  26.695  56.573  1.00 18.22           C  
ATOM   5605  CD  ARG   229      64.905  25.781  57.639  1.00 24.70           C  
ATOM   5606  NE  ARG   229      66.358  25.629  57.578  1.00 27.94           N  
ATOM   5607  CZ  ARG   229      67.067  24.929  58.463  1.00 29.51           C  
ATOM   5608  NH1 ARG   229      66.464  24.315  59.473  1.00 30.07           N  
ATOM   5609  NH2 ARG   229      68.382  24.843  58.339  1.00 31.20           N  
ATOM   5610  N   GLU   230      60.073  27.682  56.263  1.00 13.02           N  
ATOM   5611  CA  GLU   230      58.789  27.853  56.934  1.00 13.00           C  
ATOM   5612  C   GLU   230      58.956  28.177  58.441  1.00 10.74           C  
ATOM   5613  O   GLU   230      59.669  27.483  59.145  1.00 10.37           O  
ATOM   5614  CB  GLU   230      57.992  26.558  56.766  1.00 14.44           C  
ATOM   5615  CG  GLU   230      56.714  26.470  57.570  1.00 16.81           C  
ATOM   5616  CD  GLU   230      55.756  27.580  57.297  1.00 20.75           C  
ATOM   5617  OE1 GLU   230      55.565  27.938  56.108  1.00 22.68           O  
ATOM   5618  OE2 GLU   230      55.183  28.101  58.273  1.00 23.60           O  
ATOM   5619  N   ALA   231      58.274  29.224  58.921  1.00 10.66           N  
ATOM   5620  CA  ALA   231      58.452  29.695  60.279  1.00  9.21           C  
ATOM   5621  C   ALA   231      57.666  28.814  61.265  1.00  9.22           C  
ATOM   5622  O   ALA   231      58.149  28.544  62.358  1.00 11.18           O  
ATOM   5623  CB  ALA   231      58.043  31.163  60.394  1.00 11.08           C  
ATOM   5624  N   ALA   232      56.440  28.411  60.900  1.00 11.57           N  
ATOM   5625  CA  ALA   232      55.657  27.536  61.794  1.00 11.84           C  
ATOM   5626  C   ALA   232      56.448  26.274  62.149  1.00 11.65           C  
ATOM   5627  O   ALA   232      57.030  25.635  61.277  1.00 11.13           O  
ATOM   5628  CB  ALA   232      54.287  27.166  61.177  1.00 12.63           C  
ATOM   5629  N   GLY   233      56.460  25.932  63.440  1.00 11.71           N  
ATOM   5630  CA  GLY   233      57.118  24.727  63.931  1.00 12.81           C  
ATOM   5631  C   GLY   233      58.631  24.731  63.914  1.00 12.78           C  
ATOM   5632  O   GLY   233      59.258  23.671  64.000  1.00 15.24           O  
ATOM   5633  N   PHE   234      59.231  25.920  63.845  1.00 11.53           N  
ATOM   5634  CA  PHE   234      60.681  26.065  63.718  1.00 10.95           C  
ATOM   5635  C   PHE   234      61.135  27.154  64.667  1.00 10.41           C  
ATOM   5636  O   PHE   234      61.335  28.309  64.285  1.00 10.14           O  
ATOM   5637  CB  PHE   234      61.024  26.418  62.268  1.00 10.28           C  
ATOM   5638  CG  PHE   234      62.481  26.660  61.998  1.00 11.48           C  
ATOM   5639  CD1 PHE   234      63.469  25.908  62.615  1.00 12.55           C  
ATOM   5640  CD2 PHE   234      62.851  27.629  61.057  1.00 12.01           C  
ATOM   5641  CE1 PHE   234      64.810  26.118  62.316  1.00 12.77           C  
ATOM   5642  CE2 PHE   234      64.198  27.847  60.754  1.00  9.77           C  
ATOM   5643  CZ  PHE   234      65.173  27.094  61.377  1.00 10.45           C  
ATOM   5644  N   HIS   235      61.220  26.803  65.939  1.00 11.11           N  
ATOM   5645  CA  HIS   235      61.674  27.764  66.942  1.00 10.75           C  
ATOM   5646  C   HIS   235      62.484  27.096  68.044  1.00 10.73           C  
ATOM   5647  O   HIS   235      62.409  25.871  68.220  1.00 11.07           O  
ATOM   5648  CB  HIS   235      60.488  28.535  67.516  1.00 11.00           C  
ATOM   5649  CG  HIS   235      59.431  27.661  68.116  1.00 12.49           C  
ATOM   5650  ND1 HIS   235      59.451  27.250  69.430  1.00 17.28           N  
ATOM   5651  CD2 HIS   235      58.298  27.159  67.583  1.00 15.51           C  
ATOM   5652  CE1 HIS   235      58.384  26.505  69.672  1.00 16.54           C  
ATOM   5653  NE2 HIS   235      57.661  26.444  68.572  1.00 19.60           N  
ATOM   5654  N   GLY   236      63.272  27.900  68.757  1.00  9.65           N  
ATOM   5655  CA  GLY   236      64.075  27.417  69.881  1.00 10.22           C  
ATOM   5656  C   GLY   236      65.311  26.612  69.493  1.00 11.11           C  
ATOM   5657  O   GLY   236      65.883  25.899  70.346  1.00 11.67           O  
ATOM   5658  N   GLN   237      65.737  26.719  68.229  1.00  9.79           N  
ATOM   5659  CA  GLN   237      66.917  26.007  67.719  0.50  9.71           C  
ATOM   5661  C   GLN   237      68.155  26.891  67.753  1.00  9.69           C  
ATOM   5662  O   GLN   237      68.076  28.093  67.421  1.00  9.08           O  
ATOM   5663  CB  GLN   237      66.702  25.568  66.277  0.50  9.51           C  
ATOM   5665  CG  GLN   237      65.375  24.867  66.030  0.50  9.75           C  
ATOM   5667  CD  GLN   237      65.237  23.639  66.887  0.50 12.51           C  
ATOM   5669  OE1 GLN   237      66.075  22.741  66.822  0.50 15.44           O  
ATOM   5671  NE2 GLN   237      64.207  23.607  67.731  0.50 13.76           N  
ATOM   5673  N   PHE   238      69.292  26.295  68.111  1.00 10.54           N  
ATOM   5674  CA  PHE   238      70.565  26.961  68.165  1.00 10.09           C  
ATOM   5675  C   PHE   238      71.422  26.330  67.095  1.00 10.10           C  
ATOM   5676  O   PHE   238      71.923  25.208  67.260  1.00 10.79           O  
ATOM   5677  CB  PHE   238      71.148  26.854  69.559  1.00 11.86           C  
ATOM   5678  CG  PHE   238      70.364  27.638  70.513  1.00 11.06           C  
ATOM   5679  CD1 PHE   238      70.683  28.963  70.740  1.00  9.74           C  
ATOM   5680  CD2 PHE   238      69.199  27.095  71.091  1.00 13.11           C  
ATOM   5681  CE1 PHE   238      69.877  29.754  71.591  1.00 12.73           C  
ATOM   5682  CE2 PHE   238      68.397  27.871  71.954  1.00 11.73           C  
ATOM   5683  CZ  PHE   238      68.729  29.199  72.181  1.00 12.13           C  
ATOM   5684  N   LEU   239      71.435  27.004  65.947  1.00  8.63           N  
ATOM   5685  CA  LEU   239      71.954  26.431  64.705  1.00  9.84           C  
ATOM   5686  C   LEU   239      73.415  26.809  64.453  1.00 10.60           C  
ATOM   5687  O   LEU   239      73.900  27.852  64.902  1.00  9.43           O  
ATOM   5688  CB  LEU   239      71.071  26.890  63.542  1.00 11.24           C  
ATOM   5689  CG  LEU   239      69.571  26.548  63.665  1.00 14.18           C  
ATOM   5690  CD1 LEU   239      68.745  27.380  62.716  1.00 15.68           C  
ATOM   5691  CD2 LEU   239      69.305  25.051  63.508  1.00 13.50           C  
ATOM   5692  N   ILE   240      74.114  25.957  63.699  1.00 10.01           N  
ATOM   5693  CA  ILE   240      75.506  26.202  63.350  1.00 10.29           C  
ATOM   5694  C   ILE   240      75.630  26.359  61.837  1.00 10.02           C  
ATOM   5695  O   ILE   240      74.977  25.618  61.079  1.00  9.20           O  
ATOM   5696  CB  ILE   240      76.425  25.078  63.844  1.00 12.25           C  
ATOM   5697  CG1 ILE   240      76.182  24.784  65.334  1.00 12.19           C  
ATOM   5698  CG2 ILE   240      77.889  25.507  63.641  1.00  9.74           C  
ATOM   5699  CD1 ILE   240      76.500  25.914  66.214  1.00 11.70           C  
ATOM   5700  N   ASP   241      76.455  27.320  61.392  1.00  8.55           N  
ATOM   5701  CA  ASP   241      76.500  27.630  59.948  1.00  7.63           C  
ATOM   5702  C   ASP   241      76.734  26.403  59.046  1.00  8.93           C  
ATOM   5703  O   ASP   241      75.986  26.182  58.087  1.00  7.81           O  
ATOM   5704  CB  ASP   241      77.462  28.776  59.622  1.00  8.63           C  
ATOM   5705  CG  ASP   241      78.910  28.556  60.089  1.00  8.77           C  
ATOM   5706  OD1 ASP   241      79.263  27.528  60.731  1.00  9.52           O  
ATOM   5707  OD2 ASP   241      79.702  29.490  59.786  1.00 10.21           O  
ATOM   5708  N   ASP   242      77.776  25.640  59.346  1.00  9.44           N  
ATOM   5709  CA  ASP   242      78.153  24.498  58.505  1.00  9.97           C  
ATOM   5710  C   ASP   242      77.045  23.463  58.410  1.00 11.43           C  
ATOM   5711  O   ASP   242      76.792  22.932  57.322  1.00 11.52           O  
ATOM   5712  CB  ASP   242      79.518  23.916  58.898  1.00 10.96           C  
ATOM   5713  CG  ASP   242      79.626  23.456  60.354  1.00 10.47           C  
ATOM   5714  OD1 ASP   242      78.637  23.411  61.152  1.00  9.82           O  
ATOM   5715  OD2 ASP   242      80.750  23.045  60.696  1.00 11.04           O  
ATOM   5716  N   GLU   243      76.340  23.240  59.528  1.00 10.97           N  
ATOM   5717  CA  GLU   243      75.254  22.271  59.563  1.00 12.10           C  
ATOM   5718  C   GLU   243      74.051  22.754  58.781  1.00 11.93           C  
ATOM   5719  O   GLU   243      73.450  21.991  58.013  1.00 12.25           O  
ATOM   5720  CB  GLU   243      74.891  21.953  61.015  1.00 10.90           C  
ATOM   5721  CG  GLU   243      75.989  21.186  61.752  1.00 11.73           C  
ATOM   5722  CD  GLU   243      75.652  20.881  63.201  1.00 14.83           C  
ATOM   5723  OE1 GLU   243      74.647  21.414  63.728  1.00 15.06           O  
ATOM   5724  OE2 GLU   243      76.424  20.123  63.820  1.00 15.27           O  
ATOM   5725  N   VAL   244      73.726  24.043  58.928  1.00 10.46           N  
ATOM   5726  CA  VAL   244      72.639  24.624  58.156  1.00 10.91           C  
ATOM   5727  C   VAL   244      72.944  24.498  56.657  1.00  9.60           C  
ATOM   5728  O   VAL   244      72.100  24.116  55.849  1.00  9.49           O  
ATOM   5729  CB  VAL   244      72.430  26.109  58.522  1.00 10.40           C  
ATOM   5730  CG1 VAL   244      71.527  26.825  57.494  1.00 10.80           C  
ATOM   5731  CG2 VAL   244      71.827  26.241  59.936  1.00 10.74           C  
ATOM   5732  N   LEU   245      74.171  24.845  56.271  1.00  8.34           N  
ATOM   5733  CA  LEU   245      74.524  24.803  54.873  1.00  9.08           C  
ATOM   5734  C   LEU   245      74.510  23.367  54.329  1.00  9.72           C  
ATOM   5735  O   LEU   245      74.061  23.135  53.212  1.00 12.07           O  
ATOM   5736  CB  LEU   245      75.864  25.495  54.646  1.00 10.01           C  
ATOM   5737  CG  LEU   245      75.757  27.025  54.754  1.00  9.78           C  
ATOM   5738  CD1 LEU   245      77.125  27.622  54.847  1.00 11.42           C  
ATOM   5739  CD2 LEU   245      74.933  27.662  53.573  1.00 10.98           C  
ATOM   5740  N   ALA   246      74.926  22.406  55.142  1.00  9.49           N  
ATOM   5741  CA  ALA   246      74.899  20.989  54.735  1.00 10.39           C  
ATOM   5742  C   ALA   246      73.460  20.527  54.472  1.00 13.02           C  
ATOM   5743  O   ALA   246      73.166  19.889  53.464  1.00 13.50           O  
ATOM   5744  CB  ALA   246      75.552  20.141  55.785  1.00 11.18           C  
ATOM   5745  N   GLN   247      72.545  20.906  55.350  1.00 14.76           N  
ATOM   5746  CA  GLN   247      71.142  20.553  55.146  1.00 15.96           C  
ATOM   5747  C   GLN   247      70.605  21.162  53.844  1.00 16.26           C  
ATOM   5748  O   GLN   247      69.775  20.553  53.163  1.00 17.07           O  
ATOM   5749  CB  GLN   247      70.284  20.972  56.345  1.00 16.47           C  
ATOM   5750  CG  GLN   247      68.830  20.506  56.232  1.00 19.53           C  
ATOM   5751  CD  GLN   247      68.716  18.981  56.287  1.00 23.04           C  
ATOM   5752  OE1 GLN   247      69.252  18.354  57.198  1.00 30.20           O  
ATOM   5753  NE2 GLN   247      68.015  18.387  55.318  1.00 26.17           N  
ATOM   5754  N   ALA   248      71.096  22.354  53.499  1.00 15.68           N  
ATOM   5755  CA  ALA   248      70.715  23.057  52.270  1.00 17.03           C  
ATOM   5756  C   ALA   248      71.405  22.541  50.999  1.00 17.73           C  
ATOM   5757  O   ALA   248      71.152  23.057  49.898  1.00 18.79           O  
ATOM   5758  CB  ALA   248      70.970  24.566  52.440  1.00 16.79           C  
ATOM   5759  N   GLY   249      72.257  21.525  51.136  1.00 17.88           N  
ATOM   5760  CA  GLY   249      72.937  20.916  50.006  1.00 17.09           C  
ATOM   5761  C   GLY   249      74.269  21.562  49.677  1.00 18.14           C  
ATOM   5762  O   GLY   249      74.836  21.281  48.639  1.00 18.86           O  
ATOM   5763  N   ILE   250      74.764  22.432  50.558  1.00 16.72           N  
ATOM   5764  CA  ILE   250      76.060  23.086  50.394  1.00 16.93           C  
ATOM   5765  C   ILE   250      77.010  22.469  51.401  1.00 17.11           C  
ATOM   5766  O   ILE   250      76.966  22.786  52.594  1.00 17.06           O  
ATOM   5767  CB  ILE   250      75.991  24.625  50.598  1.00 16.82           C  
ATOM   5768  CG1 ILE   250      75.017  25.237  49.576  1.00 18.36           C  
ATOM   5769  CG2 ILE   250      77.421  25.238  50.561  1.00 17.05           C  
ATOM   5770  CD1 ILE   250      74.554  26.663  49.877  1.00 20.00           C  
ATOM   5771  N   THR   251      77.844  21.565  50.907  1.00 16.28           N  
ATOM   5772  CA  THR   251      78.766  20.798  51.733  1.00 17.39           C  
ATOM   5773  C   THR   251      80.225  21.172  51.470  1.00 16.35           C  
ATOM   5774  O   THR   251      81.100  20.924  52.311  1.00 17.59           O  
ATOM   5775  CB  THR   251      78.548  19.258  51.518  1.00 18.88           C  
ATOM   5776  OG1 THR   251      78.633  18.951  50.125  1.00 19.35           O  
ATOM   5777  CG2 THR   251      77.179  18.803  52.048  1.00 18.81           C  
ATOM   5778  N   ASP   252      80.506  21.772  50.318  1.00 16.57           N  
ATOM   5779  CA  ASP   252      81.860  22.264  50.053  1.00 16.71           C  
ATOM   5780  C   ASP   252      81.990  23.719  50.530  1.00 15.16           C  
ATOM   5781  O   ASP   252      81.513  24.643  49.869  1.00 14.76           O  
ATOM   5782  CB  ASP   252      82.210  22.136  48.559  1.00 18.34           C  
ATOM   5783  CG  ASP   252      83.534  22.803  48.198  1.00 21.36           C  
ATOM   5784  OD1 ASP   252      84.360  23.072  49.092  1.00 20.58           O  
ATOM   5785  OD2 ASP   252      83.762  23.062  46.991  1.00 26.03           O  
ATOM   5786  N   LEU   253      82.677  23.907  51.654  1.00 14.09           N  
ATOM   5787  CA  LEU   253      82.822  25.212  52.292  1.00 13.04           C  
ATOM   5788  C   LEU   253      84.167  25.868  52.017  1.00 13.64           C  
ATOM   5789  O   LEU   253      84.484  26.925  52.582  1.00 13.52           O  
ATOM   5790  CB  LEU   253      82.650  25.059  53.802  1.00 12.46           C  
ATOM   5791  CG  LEU   253      81.350  24.462  54.293  1.00 14.11           C  
ATOM   5792  CD1 LEU   253      81.337  24.370  55.815  1.00 12.78           C  
ATOM   5793  CD2 LEU   253      80.193  25.302  53.751  1.00 14.19           C  
ATOM   5794  N   SER   254      84.964  25.252  51.146  1.00 15.63           N  
ATOM   5795  CA  SER   254      86.332  25.727  50.935  1.00 15.42           C  
ATOM   5796  C   SER   254      86.416  27.206  50.485  1.00 14.66           C  
ATOM   5797  O   SER   254      87.362  27.936  50.845  1.00 14.75           O  
ATOM   5798  CB  SER   254      87.046  24.810  49.915  1.00 17.15           C  
ATOM   5799  OG  SER   254      86.372  24.804  48.662  1.00 21.05           O  
ATOM   5800  N   GLY   255      85.450  27.636  49.674  1.00 13.97           N  
ATOM   5801  CA  GLY   255      85.415  29.023  49.171  1.00 15.07           C  
ATOM   5802  C   GLY   255      85.129  30.080  50.222  1.00 13.40           C  
ATOM   5803  O   GLY   255      85.300  31.281  49.964  1.00 15.35           O  
ATOM   5804  N   TYR   256      84.668  29.654  51.397  1.00 12.89           N  
ATOM   5805  CA  TYR   256      84.408  30.594  52.502  1.00 12.87           C  
ATOM   5806  C   TYR   256      85.652  30.922  53.329  1.00 13.02           C  
ATOM   5807  O   TYR   256      85.633  31.807  54.191  1.00 12.60           O  
ATOM   5808  CB  TYR   256      83.310  30.070  53.409  1.00 12.71           C  
ATOM   5809  CG  TYR   256      81.957  29.985  52.758  1.00 12.38           C  
ATOM   5810  CD1 TYR   256      81.262  31.146  52.368  1.00 12.60           C  
ATOM   5811  CD2 TYR   256      81.344  28.764  52.573  1.00 13.56           C  
ATOM   5812  CE1 TYR   256      79.982  31.066  51.790  1.00 13.07           C  
ATOM   5813  CE2 TYR   256      80.072  28.672  51.992  1.00 12.59           C  
ATOM   5814  CZ  TYR   256      79.398  29.822  51.595  1.00 12.08           C  
ATOM   5815  OH  TYR   256      78.136  29.650  51.055  1.00 13.51           O  
ATOM   5816  N   ALA   257      86.750  30.202  53.093  1.00 12.21           N  
ATOM   5817  CA  ALA   257      88.000  30.505  53.803  1.00 12.76           C  
ATOM   5818  C   ALA   257      88.579  31.834  53.341  1.00 13.14           C  
ATOM   5819  O   ALA   257      88.634  32.103  52.137  1.00 12.74           O  
ATOM   5820  CB  ALA   257      89.035  29.381  53.574  1.00 11.08           C  
ATOM   5821  N   VAL   258      89.025  32.653  54.291  1.00 13.59           N  
ATOM   5822  CA  VAL   258      89.766  33.875  53.957  1.00 13.15           C  
ATOM   5823  C   VAL   258      91.047  33.481  53.196  1.00 13.92           C  
ATOM   5824  O   VAL   258      91.350  34.062  52.167  1.00 15.15           O  
ATOM   5825  CB  VAL   258      90.139  34.695  55.196  1.00 13.73           C  
ATOM   5826  CG1 VAL   258      91.133  35.827  54.828  1.00 12.44           C  
ATOM   5827  CG2 VAL   258      88.887  35.275  55.836  1.00 11.73           C  
ATOM   5828  N   ASP   259      91.737  32.468  53.695  1.00 14.36           N  
ATOM   5829  CA  ASP   259      93.043  32.032  53.152  1.00 16.66           C  
ATOM   5830  C   ASP   259      93.207  30.531  53.378  1.00 16.00           C  
ATOM   5831  O   ASP   259      93.492  30.111  54.495  1.00 15.74           O  
ATOM   5832  CB  ASP   259      94.178  32.770  53.843  1.00 17.28           C  
ATOM   5833  CG  ASP   259      95.534  32.527  53.175  1.00 19.52           C  
ATOM   5834  OD1 ASP   259      95.638  31.603  52.334  1.00 19.14           O  
ATOM   5835  OD2 ASP   259      96.471  33.285  53.500  1.00 20.78           O  
ATOM   5836  N   PRO   260      93.040  29.731  52.314  1.00 16.57           N  
ATOM   5837  CA  PRO   260      93.114  28.263  52.358  1.00 17.14           C  
ATOM   5838  C   PRO   260      94.471  27.723  52.853  1.00 17.17           C  
ATOM   5839  O   PRO   260      94.556  26.568  53.229  1.00 17.32           O  
ATOM   5840  CB  PRO   260      92.895  27.856  50.906  1.00 17.55           C  
ATOM   5841  CG  PRO   260      92.197  29.012  50.297  1.00 19.80           C  
ATOM   5842  CD  PRO   260      92.761  30.208  50.948  1.00 17.57           C  
ATOM   5843  N   GLN   261      95.513  28.555  52.877  1.00 17.47           N  
ATOM   5844  CA  GLN   261      96.809  28.066  53.346  1.00 19.31           C  
ATOM   5845  C   GLN   261      96.883  27.935  54.861  1.00 18.28           C  
ATOM   5846  O   GLN   261      97.785  27.279  55.369  1.00 17.94           O  
ATOM   5847  CB  GLN   261      98.003  28.848  52.735  1.00 20.37           C  
ATOM   5848  CG  GLN   261      98.334  30.204  53.267  1.00 22.82           C  
ATOM   5849  CD  GLN   261      99.129  31.047  52.224  1.00 23.06           C  
ATOM   5850  OE1 GLN   261     100.267  30.741  51.890  1.00 24.28           O  
ATOM   5851  NE2 GLN   261      98.505  32.082  51.712  1.00 26.95           N  
ATOM   5852  N   ARG   262      95.897  28.499  55.570  1.00 17.95           N  
ATOM   5853  CA  ARG   262      95.835  28.452  57.026  1.00 18.53           C  
ATOM   5854  C   ARG   262      94.770  27.486  57.540  1.00 16.88           C  
ATOM   5855  O   ARG   262      93.689  27.377  56.957  1.00 15.84           O  
ATOM   5856  CB  ARG   262      95.538  29.856  57.567  1.00 19.88           C  
ATOM   5857  CG  ARG   262      96.516  30.933  57.099  1.00 24.55           C  
ATOM   5858  CD  ARG   262      97.860  30.788  57.788  1.00 29.13           C  
ATOM   5859  NE  ARG   262      97.735  31.167  59.198  1.00 33.15           N  
ATOM   5860  CZ  ARG   262      97.938  32.393  59.688  1.00 34.34           C  
ATOM   5861  NH1 ARG   262      98.293  33.410  58.897  1.00 36.27           N  
ATOM   5862  NH2 ARG   262      97.770  32.606  60.988  1.00 33.46           N  
ATOM   5863  N   ALA   263      95.068  26.798  58.640  1.00 17.37           N  
ATOM   5864  CA  ALA   263      94.067  26.008  59.366  1.00 17.08           C  
ATOM   5865  C   ALA   263      93.041  26.985  59.978  1.00 16.55           C  
ATOM   5866  O   ALA   263      93.421  28.032  60.471  1.00 17.26           O  
ATOM   5867  CB  ALA   263      94.745  25.188  60.460  1.00 18.51           C  
ATOM   5868  N   LEU   264      91.753  26.664  59.895  1.00 16.39           N  
ATOM   5869  CA  LEU   264      90.712  27.525  60.490  1.00 16.60           C  
ATOM   5870  C   LEU   264      90.679  27.453  62.024  1.00 16.45           C  
ATOM   5871  O   LEU   264      90.837  26.372  62.621  1.00 18.13           O  
ATOM   5872  CB  LEU   264      89.346  27.156  59.948  1.00 16.42           C  
ATOM   5873  CG  LEU   264      89.143  27.414  58.467  1.00 15.21           C  
ATOM   5874  CD1 LEU   264      87.920  26.660  57.985  1.00 13.98           C  
ATOM   5875  CD2 LEU   264      89.042  28.909  58.183  1.00 13.81           C  
ATOM   5876  N   LEU   265      90.505  28.618  62.652  1.00 16.21           N  
ATOM   5877  CA  LEU   265      90.405  28.714  64.100  1.00 16.33           C  
ATOM   5878  C   LEU   265      88.967  28.386  64.532  1.00 15.83           C  
ATOM   5879  O   LEU   265      88.023  29.000  64.038  1.00 16.09           O  
ATOM   5880  CB  LEU   265      90.750  30.120  64.588  1.00 17.75           C  
ATOM   5881  CG  LEU   265      92.181  30.627  64.317  1.00 20.10           C  
ATOM   5882  CD1 LEU   265      92.346  32.048  64.846  1.00 21.56           C  
ATOM   5883  CD2 LEU   265      93.196  29.698  64.919  1.00 20.73           C  
ATOM   5884  N   PRO   266      88.798  27.457  65.480  1.00 15.63           N  
ATOM   5885  CA  PRO   266      87.450  27.153  65.999  1.00 16.18           C  
ATOM   5886  C   PRO   266      86.857  28.356  66.741  1.00 14.14           C  
ATOM   5887  O   PRO   266      87.580  29.095  67.395  1.00 13.74           O  
ATOM   5888  CB  PRO   266      87.674  25.992  66.976  1.00 16.24           C  
ATOM   5889  CG  PRO   266      89.145  25.788  67.059  1.00 19.00           C  
ATOM   5890  CD  PRO   266      89.857  26.631  66.102  1.00 16.71           C  
ATOM   5891  N   ASP   267      85.546  28.556  66.607  1.00 13.96           N  
ATOM   5892  CA  ASP   267      84.855  29.689  67.218  1.00 14.10           C  
ATOM   5893  C   ASP   267      84.760  29.523  68.743  1.00 13.49           C  
ATOM   5894  O   ASP   267      84.859  28.418  69.281  1.00 12.65           O  
ATOM   5895  CB  ASP   267      83.449  29.792  66.625  1.00 12.54           C  
ATOM   5896  CG  ASP   267      82.819  31.171  66.739  1.00 15.42           C  
ATOM   5897  OD1 ASP   267      83.441  32.138  67.217  1.00 13.95           O  
ATOM   5898  OD2 ASP   267      81.637  31.269  66.309  1.00 14.52           O  
ATOM   5899  N   LEU   268      84.617  30.659  69.422  1.00 13.52           N  
ATOM   5900  CA  LEU   268      84.284  30.699  70.824  1.00 14.96           C  
ATOM   5901  C   LEU   268      82.946  29.991  71.042  1.00 14.82           C  
ATOM   5902  O   LEU   268      82.104  29.993  70.145  1.00 13.69           O  
ATOM   5903  CB  LEU   268      84.141  32.161  71.304  1.00 15.82           C  
ATOM   5904  CG  LEU   268      85.422  32.938  71.595  1.00 18.28           C  
ATOM   5905  CD1 LEU   268      86.182  33.204  70.301  1.00 19.74           C  
ATOM   5906  CD2 LEU   268      85.092  34.258  72.314  1.00 18.49           C  
ATOM   5907  N   PHE   269      82.776  29.416  72.224  1.00 13.88           N  
ATOM   5908  CA  PHE   269      81.479  28.918  72.704  1.00 14.11           C  
ATOM   5909  C   PHE   269      80.922  27.726  71.915  1.00 14.49           C  
ATOM   5910  O   PHE   269      79.710  27.559  71.807  1.00 14.78           O  
ATOM   5911  CB  PHE   269      80.436  30.047  72.742  1.00 13.13           C  
ATOM   5912  CG  PHE   269      80.814  31.243  73.592  1.00 12.50           C  
ATOM   5913  CD1 PHE   269      81.254  31.089  74.894  1.00 12.83           C  
ATOM   5914  CD2 PHE   269      80.654  32.522  73.105  1.00 12.47           C  
ATOM   5915  CE1 PHE   269      81.565  32.193  75.692  1.00 13.46           C  
ATOM   5916  CE2 PHE   269      80.964  33.642  73.895  1.00 12.05           C  
ATOM   5917  CZ  PHE   269      81.431  33.453  75.208  1.00 12.47           C  
ATOM   5918  N   LEU   270      81.812  26.920  71.338  1.00 14.37           N  
ATOM   5919  CA  LEU   270      81.447  25.635  70.789  1.00 16.10           C  
ATOM   5920  C   LEU   270      82.469  24.613  71.275  1.00 17.22           C  
ATOM   5921  O   LEU   270      83.675  24.880  71.244  1.00 16.86           O  
ATOM   5922  CB  LEU   270      81.459  25.668  69.258  1.00 16.26           C  
ATOM   5923  CG  LEU   270      80.278  26.364  68.588  1.00 15.58           C  
ATOM   5924  CD1 LEU   270      80.496  26.370  67.046  1.00 14.45           C  
ATOM   5925  CD2 LEU   270      78.909  25.742  68.959  1.00 15.54           C  
ATOM   5926  N   GLU   271      81.963  23.476  71.740  1.00 19.45           N  
ATOM   5927  CA  GLU   271      82.788  22.330  72.080  1.00 22.57           C  
ATOM   5928  C   GLU   271      83.343  21.779  70.762  1.00 25.04           C  
ATOM   5929  O   GLU   271      82.642  21.754  69.735  1.00 23.26           O  
ATOM   5930  CB  GLU   271      81.968  21.231  72.775  1.00 23.30           C  
ATOM   5931  CG  GLU   271      81.121  21.665  73.996  1.00 25.01           C  
ATOM   5932  CD  GLU   271      81.931  22.042  75.228  1.00 26.56           C  
ATOM   5933  OE1 GLU   271      83.171  21.827  75.219  1.00 26.60           O  
ATOM   5934  OE2 GLU   271      81.312  22.561  76.204  1.00 25.67           O  
END
