
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  151 ( 1228),  selected  151 , name 2gt2_A
# Molecule2: number of CA atoms  208 ( 1611),  selected  208 , name T0513_1_11_87_283.pdb
# PARAMETERS: 2gt2_A.T0513_1_11_87_283.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      S       2           -
LGA    -       -      F       3           -
LGA    -       -      L       4           -
LGA    -       -      K       5           -
LGA    -       -      H       6           -
LGA    -       -      V       7           -
LGA    -       -      Q       8           -
LGA    -       -      D       9           -
LGA    -       -      C      10           -
LGA    -       -      N      11           -
LGA    F     3_A      G      87          3.846
LGA    L     4_A      E      88          3.519
LGA    R     5_A      L      89           -
LGA    Q     6_A      Y      90           -
LGA    E     7_A      R      91           -
LGA    -       -      V      92           -
LGA    -       -      N      93           -
LGA    -       -      Q      94           -
LGA    -       -      S      95           -
LGA    -       -      W      96           -
LGA    -       -      G      97           -
LGA    -       -      E      98           -
LGA    -       -      P      99           -
LGA    -       -      T     100           -
LGA    -       -      L     101           -
LGA    -       -      M     102           -
LGA    -       -      L     103           -
LGA    -       -      L     104           -
LGA    D     8_A      D     105          3.620
LGA    F     9_A      R     106          2.974
LGA    A    10_A      A     107          2.279
LGA    T    11_A      V     108          1.757
LGA    V    12_A      V     109          2.215
LGA    V    13_A      P     110          3.282
LGA    R    14_A      T     111          2.118
LGA    S    15_A      F     112          2.099
LGA    -       -      G     113           -
LGA    T    16_A      V     114          1.324
LGA    P    17_A      R     115          2.118
LGA    L    18_A      A     116          1.766
LGA    V    19_A      Y     117          1.048
LGA    S    20_A      G     118          0.757
LGA    L    21_A      V     119          0.762
LGA    D    22_A      H     120          0.506
LGA    F    23_A      L     121          0.442
LGA    I    24_A      N     122          0.748
LGA    V    25_A      G     123          0.735
LGA    E    26_A      Y     124          0.478
LGA    N    27_A      V     125          1.767
LGA    S    28_A      G     126          3.669
LGA    -       -      A     127           -
LGA    -       -      G     128           -
LGA    -       -      A     129           -
LGA    R    29_A      D     130          4.271
LGA    G    30_A      L     131          1.582
LGA    E    31_A      H     132          0.641
LGA    F    32_A      L     133          0.670
LGA    L    33_A      W     134          1.388
LGA    L    34_A      I     135          1.346
LGA    G    35_A      G     136          1.427
LGA    K    36_A      R     137          2.009
LGA    R    37_A      R     138          2.689
LGA    T    38_A      S     139          3.570
LGA    -       -      P     140           -
LGA    -       -      D     141           -
LGA    N    39_A      K     142          2.179
LGA    R    40_A      S     143          3.526
LGA    P    41_A      V     144          2.564
LGA    A    42_A      A     145          3.180
LGA    Q    43_A      P     146          3.400
LGA    G    44_A      G     147          3.679
LGA    Y    45_A      K     148          2.649
LGA    W    46_A      L     149          1.143
LGA    F    47_A      D     150          1.616
LGA    V    48_A      N     151          0.947
LGA    P    49_A      M     152          3.013
LGA    -       -      V     153           -
LGA    G    50_A      A     154          0.870
LGA    G    51_A      G     155          0.827
LGA    R    52_A      G     156          1.508
LGA    V    53_A      Q     157          1.601
LGA    Q    54_A      P     158          0.821
LGA    K    55_A      A     159          1.212
LGA    D    56_A      D     160          1.875
LGA    E    57_A      L     161          0.885
LGA    T    58_A      S     162          1.549
LGA    L    59_A      L     163          2.052
LGA    E    60_A      R     164          2.615
LGA    A    61_A      Q     165          1.448
LGA    A    62_A      N     166          1.343
LGA    F    63_A      L     167          2.108
LGA    E    64_A      I     168          1.499
LGA    R    65_A      K     169          0.969
LGA    L    66_A      E     170          1.632
LGA    T    67_A      C     171          1.677
LGA    M    68_A      A     172          1.374
LGA    A    69_A      E     173          1.748
LGA    E    70_A      E     174          2.435
LGA    L    71_A      A     175          2.364
LGA    G    72_A      D     176          0.890
LGA    L    73_A      L     177          1.534
LGA    R    74_A      P     178          2.419
LGA    -       -      E     179           -
LGA    -       -      A     180           -
LGA    L    75_A      L     181          3.453
LGA    P    76_A      A     182          4.600
LGA    I    77_A      R     183          3.883
LGA    T    78_A      -       -           -
LGA    A    79_A      Q     184          1.142
LGA    G    80_A      A     185          1.748
LGA    Q    81_A      I     186          2.220
LGA    F    82_A      P     187          1.582
LGA    Y    83_A      V     188          1.419
LGA    G    84_A      G     189          0.795
LGA    V    85_A      A     190          1.254
LGA    W    86_A      I     191          0.558
LGA    Q    87_A      T     192          2.171
LGA    H    88_A      Y     193          4.690
LGA    F    89_A      C     194          4.995
LGA    Y    90_A      M     195           #
LGA    D    91_A      E     196          5.093
LGA    D    92_A      S     197          4.120
LGA    N    93_A      -       -           -
LGA    F    94_A      -       -           -
LGA    S    95_A      -       -           -
LGA    G    96_A      -       -           -
LGA    T    97_A      P     198          3.206
LGA    D    98_A      -       -           -
LGA    F    99_A      A     199          1.187
LGA    T   100_A      G     200          4.196
LGA    -       -      I     201           -
LGA    T   101_A      K     202          3.892
LGA    H   102_A      P     203          4.108
LGA    Y   103_A      D     204          2.567
LGA    V   104_A      T     205          0.809
LGA    V   105_A      L     206          0.751
LGA    L   106_A      F     207          0.565
LGA    G   107_A      L     208          0.258
LGA    F   108_A      Y     209          0.456
LGA    R   109_A      D     210          0.658
LGA    F   110_A      L     211          1.160
LGA    R   111_A      A     212          0.698
LGA    V   112_A      L     213          0.652
LGA    S   113_A      P     214          2.012
LGA    E   114_A      E     215          4.743
LGA    E   115_A      D     216          3.256
LGA    E   116_A      F     217          2.321
LGA    L   117_A      R     218          3.163
LGA    L   118_A      P     219          3.603
LGA    -       -      H     220           -
LGA    -       -      N     221           -
LGA    -       -      T     222           -
LGA    -       -      D     223           -
LGA    -       -      G     224           -
LGA    -       -      E     225           -
LGA    -       -      M     226           -
LGA    -       -      A     227           -
LGA    D   126_A      D     228          2.473
LGA    Y   127_A      F     229          1.875
LGA    R   128_A      M     230          1.608
LGA    W   129_A      L     231          1.475
LGA    L   130_A      W     232          1.790
LGA    T   131_A      P     233          2.040
LGA    S   132_A      A     234          2.440
LGA    D   133_A      A     235          1.408
LGA    A   134_A      K     236          0.502
LGA    L   135_A      V     237          1.000
LGA    L   136_A      V     238          1.824
LGA    A   137_A      E     239          1.619
LGA    S   138_A      A     240          1.394
LGA    -       -      V     241           -
LGA    -       -      R     242           -
LGA    -       -      T     243           -
LGA    D   139_A      T     244          1.392
LGA    -       -      E     245           -
LGA    N   140_A      A     246          1.179
LGA    V   141_A      F     247          2.920
LGA    H   142_A      K     248          4.429
LGA    -       -      F     249           -
LGA    -       -      N     250           -
LGA    -       -      V     251           -
LGA    A   143_A      N     252          2.366
LGA    N   144_A      L     253          2.394
LGA    S   145_A      T     254          3.604
LGA    R   146_A      V     255          2.768
LGA    A   147_A      I     256          1.646
LGA    Y   148_A      D     257          2.250
LGA    F   149_A      F     258          3.367
LGA    L   150_A      A     259          3.763
LGA    A   151_A      I     260          3.152
LGA    -       -      R     261           -
LGA    -       -      H     262           -
LGA    -       -      G     263           -
LGA    -       -      L     264           -
LGA    -       -      I     265           -
LGA    -       -      D     266           -
LGA    -       -      P     267           -
LGA    -       -      D     268           -
LGA    -       -      N     269           -
LGA    -       -      E     270           -
LGA    -       -      P     271           -
LGA    -       -      D     272           -
LGA    E   152_A      Y     273          3.187
LGA    K   153_A      Q     274           #
LGA    -       -      E     275           -
LGA    -       -      I     276           -
LGA    R   154_A      L     277          5.063
LGA    T   155_A      -       -           -
LGA    G   156_A      A     278          5.467
LGA    -       -      G     279           -
LGA    -       -      L     280           -
LGA    V   157_A      R     281          5.270
LGA    P   158_A      G     282           -
LGA    G   159_A      R     283           -
LGA    L   160_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  151  208    5.0    136    2.50    12.50     45.323     5.237

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.162955 * X  +  -0.985158 * Y  +  -0.053938 * Z  +  65.712410
  Y_new =   0.884203 * X  +  -0.121563 * Y  +  -0.451006 * Z  +  85.424629
  Z_new =   0.437756 * X  +  -0.121186 * Y  +   0.890889 * Z  + -93.246292 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.135198    3.006394  [ DEG:    -7.7463    172.2537 ]
  Theta =  -0.453101   -2.688492  [ DEG:   -25.9608   -154.0392 ]
  Phi   =   1.753047   -1.388545  [ DEG:   100.4422    -79.5578 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gt2_A                                        
REMARK     2: T0513_1_11_87_283.pdb                         
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gt2_A.T0513_1_11_87_283.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  151  208   5.0  136   2.50   12.50  45.323
REMARK  ---------------------------------------------------------- 
MOLECULE 2gt2_A
HEADER    HYDROLASE                               27-APR-06   2GT2              
TITLE     STRUCTURE OF THE E. COLI GDP-MANNOSE MANNOSYL HYDROLASE               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GDP-MANNOSE MANNOSYL HYDROLASE;                            
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: GDPMH, COLANIC ACID BIOSYNTHESIS PROTEIN WCAH;              
COMPND   5 EC: 3.6.1.-;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: NUDD, GMM, WCAH;                                               
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET11B                                    
KEYWDS    GDP-MANNOSE HYDROLASE GDP-GLUCOSE HYDROLASE NUDIX                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.B.GABELLI,M.A.BIANCHET,H.F.AZURMENDI,A.S.MILDVAN,L.M.AMZEL          
REVDAT   1   12-DEC-06 2GT2    0                                                
JRNL        AUTH   S.B.GABELLI,H.F.AZURMENDI,M.A.BIANCHET,L.M.AMZEL,            
JRNL        AUTH 2 A.S.MILDVAN                                                  
JRNL        TITL   X-RAY, NMR, AND MUTATIONAL STUDIES OF THE                    
JRNL        TITL 2 CATALYTIC CYCLE OF THE GDP-MANNOSE MANNOSYL                  
JRNL        TITL 3 HYDROLASE REACTION.                                          
JRNL        REF    BIOCHEMISTRY                  V.  45 11290 2006              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  2GT2 A    2   160  UNP    P32056   NUDD_ECOLI       1    159             
DBREF  2GT2 B    2   160  UNP    P32056   NUDD_ECOLI       1    159             
DBREF  2GT2 C    2   160  UNP    P32056   NUDD_ECOLI       1    159             
DBREF  2GT2 D    2   160  UNP    P32056   NUDD_ECOLI       1    159             
SEQRES   1 A  160  MET MET PHE LEU ARG GLN GLU ASP PHE ALA THR VAL VAL          
SEQRES   2 A  160  ARG SER THR PRO LEU VAL SER LEU ASP PHE ILE VAL GLU          
SEQRES   3 A  160  ASN SER ARG GLY GLU PHE LEU LEU GLY LYS ARG THR ASN          
SEQRES   4 A  160  ARG PRO ALA GLN GLY TYR TRP PHE VAL PRO GLY GLY ARG          
SEQRES   5 A  160  VAL GLN LYS ASP GLU THR LEU GLU ALA ALA PHE GLU ARG          
SEQRES   6 A  160  LEU THR MET ALA GLU LEU GLY LEU ARG LEU PRO ILE THR          
SEQRES   7 A  160  ALA GLY GLN PHE TYR GLY VAL TRP GLN HIS PHE TYR ASP          
SEQRES   8 A  160  ASP ASN PHE SER GLY THR ASP PHE THR THR HIS TYR VAL          
SEQRES   9 A  160  VAL LEU GLY PHE ARG PHE ARG VAL SER GLU GLU GLU LEU          
SEQRES  10 A  160  LEU LEU PRO ASP GLU GLN HIS ASP ASP TYR ARG TRP LEU          
SEQRES  11 A  160  THR SER ASP ALA LEU LEU ALA SER ASP ASN VAL HIS ALA          
SEQRES  12 A  160  ASN SER ARG ALA TYR PHE LEU ALA GLU LYS ARG THR GLY          
SEQRES  13 A  160  VAL PRO GLY LEU                                              
SEQRES   1 B  160  MET MET PHE LEU ARG GLN GLU ASP PHE ALA THR VAL VAL          
SEQRES   2 B  160  ARG SER THR PRO LEU VAL SER LEU ASP PHE ILE VAL GLU          
SEQRES   3 B  160  ASN SER ARG GLY GLU PHE LEU LEU GLY LYS ARG THR ASN          
SEQRES   4 B  160  ARG PRO ALA GLN GLY TYR TRP PHE VAL PRO GLY GLY ARG          
SEQRES   5 B  160  VAL GLN LYS ASP GLU THR LEU GLU ALA ALA PHE GLU ARG          
SEQRES   6 B  160  LEU THR MET ALA GLU LEU GLY LEU ARG LEU PRO ILE THR          
SEQRES   7 B  160  ALA GLY GLN PHE TYR GLY VAL TRP GLN HIS PHE TYR ASP          
SEQRES   8 B  160  ASP ASN PHE SER GLY THR ASP PHE THR THR HIS TYR VAL          
SEQRES   9 B  160  VAL LEU GLY PHE ARG PHE ARG VAL SER GLU GLU GLU LEU          
SEQRES  10 B  160  LEU LEU PRO ASP GLU GLN HIS ASP ASP TYR ARG TRP LEU          
SEQRES  11 B  160  THR SER ASP ALA LEU LEU ALA SER ASP ASN VAL HIS ALA          
SEQRES  12 B  160  ASN SER ARG ALA TYR PHE LEU ALA GLU LYS ARG THR GLY          
SEQRES  13 B  160  VAL PRO GLY LEU                                              
SEQRES   1 C  160  MET MET PHE LEU ARG GLN GLU ASP PHE ALA THR VAL VAL          
SEQRES   2 C  160  ARG SER THR PRO LEU VAL SER LEU ASP PHE ILE VAL GLU          
SEQRES   3 C  160  ASN SER ARG GLY GLU PHE LEU LEU GLY LYS ARG THR ASN          
SEQRES   4 C  160  ARG PRO ALA GLN GLY TYR TRP PHE VAL PRO GLY GLY ARG          
SEQRES   5 C  160  VAL GLN LYS ASP GLU THR LEU GLU ALA ALA PHE GLU ARG          
SEQRES   6 C  160  LEU THR MET ALA GLU LEU GLY LEU ARG LEU PRO ILE THR          
SEQRES   7 C  160  ALA GLY GLN PHE TYR GLY VAL TRP GLN HIS PHE TYR ASP          
SEQRES   8 C  160  ASP ASN PHE SER GLY THR ASP PHE THR THR HIS TYR VAL          
SEQRES   9 C  160  VAL LEU GLY PHE ARG PHE ARG VAL SER GLU GLU GLU LEU          
SEQRES  10 C  160  LEU LEU PRO ASP GLU GLN HIS ASP ASP TYR ARG TRP LEU          
SEQRES  11 C  160  THR SER ASP ALA LEU LEU ALA SER ASP ASN VAL HIS ALA          
SEQRES  12 C  160  ASN SER ARG ALA TYR PHE LEU ALA GLU LYS ARG THR GLY          
SEQRES  13 C  160  VAL PRO GLY LEU                                              
SEQRES   1 D  160  MET MET PHE LEU ARG GLN GLU ASP PHE ALA THR VAL VAL          
SEQRES   2 D  160  ARG SER THR PRO LEU VAL SER LEU ASP PHE ILE VAL GLU          
SEQRES   3 D  160  ASN SER ARG GLY GLU PHE LEU LEU GLY LYS ARG THR ASN          
SEQRES   4 D  160  ARG PRO ALA GLN GLY TYR TRP PHE VAL PRO GLY GLY ARG          
SEQRES   5 D  160  VAL GLN LYS ASP GLU THR LEU GLU ALA ALA PHE GLU ARG          
SEQRES   6 D  160  LEU THR MET ALA GLU LEU GLY LEU ARG LEU PRO ILE THR          
SEQRES   7 D  160  ALA GLY GLN PHE TYR GLY VAL TRP GLN HIS PHE TYR ASP          
SEQRES   8 D  160  ASP ASN PHE SER GLY THR ASP PHE THR THR HIS TYR VAL          
SEQRES   9 D  160  VAL LEU GLY PHE ARG PHE ARG VAL SER GLU GLU GLU LEU          
SEQRES  10 D  160  LEU LEU PRO ASP GLU GLN HIS ASP ASP TYR ARG TRP LEU          
SEQRES  11 D  160  THR SER ASP ALA LEU LEU ALA SER ASP ASN VAL HIS ALA          
SEQRES  12 D  160  ASN SER ARG ALA TYR PHE LEU ALA GLU LYS ARG THR GLY          
SEQRES  13 D  160  VAL PRO GLY LEU                                              
FORMUL   5  HOH   *351(H2 O)                                                    
CRYST1   48.767   48.767  210.230  90.00  90.00 120.00 P 32         12          
ATOM      1  N   PHE A   3      24.712  60.967  -0.101  1.00 50.59           N  
ATOM      2  CA  PHE A   3      24.810  60.890   1.388  1.00 50.54           C  
ATOM      3  C   PHE A   3      23.593  60.190   1.967  1.00 50.28           C  
ATOM      4  O   PHE A   3      22.491  60.294   1.424  1.00 50.36           O  
ATOM      5  CB  PHE A   3      24.973  62.285   1.996  1.00 50.82           C  
ATOM      6  CG  PHE A   3      26.145  63.036   1.449  1.00 51.33           C  
ATOM      7  CD1 PHE A   3      27.418  62.839   1.976  1.00 52.02           C  
ATOM      8  CD2 PHE A   3      25.985  63.918   0.389  1.00 51.44           C  
ATOM      9  CE1 PHE A   3      28.507  63.521   1.458  1.00 51.91           C  
ATOM     10  CE2 PHE A   3      27.067  64.607  -0.133  1.00 51.82           C  
ATOM     11  CZ  PHE A   3      28.328  64.408   0.399  1.00 51.74           C  
ATOM     12  N   LEU A   4      23.806  59.482   3.072  1.00 49.99           N  
ATOM     13  CA  LEU A   4      22.793  58.595   3.638  1.00 49.49           C  
ATOM     14  C   LEU A   4      22.008  59.229   4.770  1.00 49.31           C  
ATOM     15  O   LEU A   4      22.562  59.929   5.621  1.00 49.05           O  
ATOM     16  CB  LEU A   4      23.433  57.298   4.140  1.00 49.52           C  
ATOM     17  CG  LEU A   4      24.342  56.517   3.193  1.00 49.30           C  
ATOM     18  CD1 LEU A   4      24.881  55.282   3.898  1.00 48.95           C  
ATOM     19  CD2 LEU A   4      23.610  56.147   1.912  1.00 49.01           C  
ATOM     20  N   ARG A   5      20.707  58.969   4.772  1.00 49.06           N  
ATOM     21  CA  ARG A   5      19.867  59.335   5.896  1.00 48.92           C  
ATOM     22  C   ARG A   5      19.910  58.248   6.969  1.00 48.46           C  
ATOM     23  O   ARG A   5      20.025  57.058   6.655  1.00 48.45           O  
ATOM     24  CB  ARG A   5      18.433  59.631   5.447  1.00 49.18           C  
ATOM     25  CG  ARG A   5      17.829  58.639   4.471  1.00 50.25           C  
ATOM     26  CD  ARG A   5      16.589  59.234   3.823  1.00 52.42           C  
ATOM     27  NE  ARG A   5      15.644  58.200   3.408  1.00 54.36           N  
ATOM     28  CZ  ARG A   5      14.337  58.393   3.240  1.00 55.36           C  
ATOM     29  NH1 ARG A   5      13.802  59.589   3.457  1.00 55.96           N  
ATOM     30  NH2 ARG A   5      13.559  57.384   2.859  1.00 55.60           N  
ATOM     31  N   GLN A   6      19.842  58.687   8.227  1.00 47.71           N  
ATOM     32  CA  GLN A   6      19.838  57.834   9.423  1.00 46.98           C  
ATOM     33  C   GLN A   6      19.164  56.468   9.234  1.00 45.85           C  
ATOM     34  O   GLN A   6      19.753  55.428   9.544  1.00 45.72           O  
ATOM     35  CB  GLN A   6      19.195  58.611  10.591  1.00 47.35           C  
ATOM     36  CG  GLN A   6      18.484  57.775  11.657  1.00 48.78           C  
ATOM     37  CD  GLN A   6      19.426  57.178  12.675  1.00 50.57           C  
ATOM     38  OE1 GLN A   6      20.004  57.892  13.501  1.00 51.32           O  
ATOM     39  NE2 GLN A   6      19.575  55.855  12.638  1.00 51.32           N  
ATOM     40  N   GLU A   7      17.938  56.493   8.717  1.00 44.45           N  
ATOM     41  CA  GLU A   7      17.114  55.300   8.532  1.00 42.98           C  
ATOM     42  C   GLU A   7      17.733  54.314   7.534  1.00 41.55           C  
ATOM     43  O   GLU A   7      17.633  53.100   7.708  1.00 41.51           O  
ATOM     44  CB  GLU A   7      15.700  55.693   8.079  1.00 43.31           C  
ATOM     45  CG  GLU A   7      15.203  57.059   8.599  1.00 44.49           C  
ATOM     46  CD  GLU A   7      15.478  58.219   7.635  1.00 45.78           C  
ATOM     47  OE1 GLU A   7      15.048  58.139   6.461  1.00 46.10           O  
ATOM     48  OE2 GLU A   7      16.105  59.221   8.056  1.00 45.47           O  
ATOM     49  N   ASP A   8      18.374  54.841   6.494  1.00 39.86           N  
ATOM     50  CA  ASP A   8      18.988  54.011   5.458  1.00 38.09           C  
ATOM     51  C   ASP A   8      20.323  53.399   5.901  1.00 36.87           C  
ATOM     52  O   ASP A   8      20.656  52.288   5.493  1.00 36.33           O  
ATOM     53  CB  ASP A   8      19.165  54.801   4.160  1.00 38.19           C  
ATOM     54  CG  ASP A   8      17.854  54.993   3.393  1.00 38.31           C  
ATOM     55  OD1 ASP A   8      16.819  54.398   3.772  1.00 37.71           O  
ATOM     56  OD2 ASP A   8      17.869  55.743   2.395  1.00 38.84           O  
ATOM     57  N   PHE A   9      21.082  54.127   6.723  1.00 35.25           N  
ATOM     58  CA  PHE A   9      22.338  53.594   7.255  1.00 33.83           C  
ATOM     59  C   PHE A   9      22.077  52.525   8.317  1.00 32.72           C  
ATOM     60  O   PHE A   9      22.849  51.576   8.446  1.00 32.10           O  
ATOM     61  CB  PHE A   9      23.252  54.693   7.811  1.00 33.92           C  
ATOM     62  CG  PHE A   9      24.622  54.190   8.209  1.00 34.25           C  
ATOM     63  CD1 PHE A   9      25.498  53.675   7.250  1.00 34.45           C  
ATOM     64  CD2 PHE A   9      25.029  54.215   9.539  1.00 33.94           C  
ATOM     65  CE1 PHE A   9      26.765  53.193   7.611  1.00 34.65           C  
ATOM     66  CE2 PHE A   9      26.295  53.739   9.913  1.00 34.17           C  
ATOM     67  CZ  PHE A   9      27.164  53.228   8.944  1.00 34.46           C  
ATOM     68  N   ALA A  10      20.989  52.698   9.067  1.00 31.42           N  
ATOM     69  CA  ALA A  10      20.501  51.687  10.004  1.00 30.39           C  
ATOM     70  C   ALA A  10      20.151  50.390   9.278  1.00 29.64           C  
ATOM     71  O   ALA A  10      20.561  49.310   9.701  1.00 29.36           O  
ATOM     72  CB  ALA A  10      19.296  52.213  10.781  1.00 30.60           C  
ATOM     73  N   THR A  11      19.406  50.511   8.179  1.00 28.84           N  
ATOM     74  CA  THR A  11      19.082  49.386   7.300  1.00 27.72           C  
ATOM     75  C   THR A  11      20.353  48.727   6.757  1.00 26.83           C  
ATOM     76  O   THR A  11      20.463  47.507   6.751  1.00 26.61           O  
ATOM     77  CB  THR A  11      18.179  49.845   6.131  1.00 28.03           C  
ATOM     78  OG1 THR A  11      17.052  50.549   6.662  1.00 28.40           O  
ATOM     79  CG2 THR A  11      17.684  48.654   5.304  1.00 27.40           C  
ATOM     80  N   VAL A  12      21.307  49.544   6.310  1.00 25.81           N  
ATOM     81  CA  VAL A  12      22.615  49.060   5.852  1.00 25.06           C  
ATOM     82  C   VAL A  12      23.339  48.261   6.945  1.00 24.80           C  
ATOM     83  O   VAL A  12      23.673  47.093   6.743  1.00 24.32           O  
ATOM     84  CB  VAL A  12      23.508  50.231   5.337  1.00 25.17           C  
ATOM     85  CG1 VAL A  12      24.976  49.822   5.245  1.00 24.61           C  
ATOM     86  CG2 VAL A  12      23.020  50.712   3.980  1.00 24.28           C  
ATOM     87  N   VAL A  13      23.551  48.884   8.105  1.00 24.21           N  
ATOM     88  CA  VAL A  13      24.271  48.240   9.212  1.00 24.12           C  
ATOM     89  C   VAL A  13      23.569  46.951   9.640  1.00 24.11           C  
ATOM     90  O   VAL A  13      24.223  45.950   9.926  1.00 23.85           O  
ATOM     91  CB  VAL A  13      24.484  49.208  10.413  1.00 23.96           C  
ATOM     92  CG1 VAL A  13      25.068  48.476  11.635  1.00 23.90           C  
ATOM     93  CG2 VAL A  13      25.408  50.344  10.013  1.00 23.32           C  
ATOM     94  N   ARG A  14      22.235  46.987   9.632  1.00 24.40           N  
ATOM     95  CA  ARG A  14      21.391  45.852  10.003  1.00 24.98           C  
ATOM     96  C   ARG A  14      21.554  44.665   9.048  1.00 24.36           C  
ATOM     97  O   ARG A  14      21.514  43.505   9.475  1.00 24.04           O  
ATOM     98  CB  ARG A  14      19.918  46.286  10.018  1.00 25.71           C  
ATOM     99  CG  ARG A  14      19.087  45.725  11.174  1.00 28.82           C  
ATOM    100  CD  ARG A  14      17.652  45.363  10.756  1.00 33.49           C  
ATOM    101  NE  ARG A  14      16.951  46.412  10.006  1.00 37.32           N  
ATOM    102  CZ  ARG A  14      16.543  46.293   8.740  1.00 38.73           C  
ATOM    103  NH1 ARG A  14      16.762  45.170   8.061  1.00 39.58           N  
ATOM    104  NH2 ARG A  14      15.916  47.299   8.147  1.00 39.22           N  
ATOM    105  N   SER A  15      21.767  44.961   7.764  1.00 23.98           N  
ATOM    106  CA  SER A  15      21.607  43.962   6.694  1.00 23.50           C  
ATOM    107  C   SER A  15      22.889  43.414   6.062  1.00 22.82           C  
ATOM    108  O   SER A  15      22.864  42.347   5.444  1.00 22.73           O  
ATOM    109  CB  SER A  15      20.715  44.522   5.576  1.00 23.36           C  
ATOM    110  OG  SER A  15      19.600  45.222   6.101  1.00 25.36           O  
ATOM    111  N   THR A  16      24.001  44.130   6.201  1.00 22.18           N  
ATOM    112  CA  THR A  16      25.201  43.798   5.419  1.00 21.34           C  
ATOM    113  C   THR A  16      26.501  44.176   6.136  1.00 20.96           C  
ATOM    114  O   THR A  16      26.498  45.083   6.985  1.00 20.89           O  
ATOM    115  CB  THR A  16      25.127  44.488   4.005  1.00 21.57           C  
ATOM    116  OG1 THR A  16      25.934  43.777   3.058  1.00 20.18           O  
ATOM    117  CG2 THR A  16      25.571  45.944   4.077  1.00 20.91           C  
ATOM    118  N   PRO A  17      27.617  43.473   5.825  1.00 21.01           N  
ATOM    119  CA  PRO A  17      28.900  43.966   6.332  1.00 20.83           C  
ATOM    120  C   PRO A  17      29.323  45.317   5.761  1.00 20.96           C  
ATOM    121  O   PRO A  17      29.127  45.597   4.570  1.00 20.22           O  
ATOM    122  CB  PRO A  17      29.903  42.880   5.924  1.00 20.98           C  
ATOM    123  CG  PRO A  17      29.236  42.117   4.824  1.00 21.25           C  
ATOM    124  CD  PRO A  17      27.762  42.193   5.102  1.00 20.57           C  
ATOM    125  N   LEU A  18      29.892  46.143   6.635  1.00 20.99           N  
ATOM    126  CA  LEU A  18      30.556  47.367   6.230  1.00 21.18           C  
ATOM    127  C   LEU A  18      31.977  47.037   5.789  1.00 21.36           C  
ATOM    128  O   LEU A  18      32.543  46.015   6.199  1.00 21.89           O  
ATOM    129  CB  LEU A  18      30.589  48.371   7.390  1.00 21.34           C  
ATOM    130  CG  LEU A  18      29.273  48.837   8.009  1.00 21.40           C  
ATOM    131  CD1 LEU A  18      29.561  49.682   9.239  1.00 20.79           C  
ATOM    132  CD2 LEU A  18      28.419  49.614   7.012  1.00 22.23           C  
ATOM    133  N   VAL A  19      32.534  47.898   4.938  1.00 20.71           N  
ATOM    134  CA  VAL A  19      33.905  47.777   4.468  1.00 20.63           C  
ATOM    135  C   VAL A  19      34.714  48.939   5.014  1.00 20.49           C  
ATOM    136  O   VAL A  19      34.328  50.094   4.837  1.00 20.55           O  
ATOM    137  CB  VAL A  19      34.002  47.821   2.919  1.00 20.23           C  
ATOM    138  CG1 VAL A  19      35.454  47.652   2.475  1.00 20.66           C  
ATOM    139  CG2 VAL A  19      33.134  46.752   2.297  1.00 20.02           C  
ATOM    140  N   SER A  20      35.828  48.637   5.669  1.00 20.49           N  
ATOM    141  CA  SER A  20      36.656  49.680   6.256  1.00 20.88           C  
ATOM    142  C   SER A  20      38.129  49.481   5.996  1.00 20.92           C  
ATOM    143  O   SER A  20      38.570  48.392   5.654  1.00 20.74           O  
ATOM    144  CB  SER A  20      36.415  49.788   7.764  1.00 20.82           C  
ATOM    145  OG  SER A  20      36.867  48.627   8.436  1.00 21.51           O  
ATOM    146  N   LEU A  21      38.875  50.565   6.162  1.00 21.39           N  
ATOM    147  CA  LEU A  21      40.324  50.534   6.168  1.00 21.74           C  
ATOM    148  C   LEU A  21      40.793  50.830   7.579  1.00 22.02           C  
ATOM    149  O   LEU A  21      40.309  51.771   8.212  1.00 22.68           O  
ATOM    150  CB  LEU A  21      40.889  51.590   5.205  1.00 21.85           C  
ATOM    151  CG  LEU A  21      40.402  51.636   3.756  1.00 21.88           C  
ATOM    152  CD1 LEU A  21      41.173  52.714   3.001  1.00 21.70           C  
ATOM    153  CD2 LEU A  21      40.562  50.287   3.059  1.00 21.94           C  
ATOM    154  N   ASP A  22      41.719  50.016   8.079  1.00 22.25           N  
ATOM    155  CA  ASP A  22      42.349  50.259   9.376  1.00 22.37           C  
ATOM    156  C   ASP A  22      43.819  50.548   9.153  1.00 22.92           C  
ATOM    157  O   ASP A  22      44.480  49.874   8.358  1.00 22.76           O  
ATOM    158  CB  ASP A  22      42.209  49.051  10.299  1.00 22.10           C  
ATOM    159  CG  ASP A  22      41.008  49.144  11.230  1.00 21.81           C  
ATOM    160  OD1 ASP A  22      40.173  50.062  11.093  1.00 22.53           O  
ATOM    161  OD2 ASP A  22      40.898  48.273  12.108  1.00 21.89           O  
ATOM    162  N   PHE A  23      44.336  51.544   9.863  1.00 23.52           N  
ATOM    163  CA  PHE A  23      45.725  51.944   9.671  1.00 24.10           C  
ATOM    164  C   PHE A  23      46.566  51.616  10.900  1.00 24.54           C  
ATOM    165  O   PHE A  23      46.286  52.087  12.003  1.00 24.07           O  
ATOM    166  CB  PHE A  23      45.829  53.435   9.322  1.00 24.30           C  
ATOM    167  CG  PHE A  23      44.959  53.866   8.162  1.00 25.09           C  
ATOM    168  CD1 PHE A  23      44.949  53.150   6.966  1.00 25.61           C  
ATOM    169  CD2 PHE A  23      44.181  55.017   8.256  1.00 25.72           C  
ATOM    170  CE1 PHE A  23      44.157  53.560   5.893  1.00 25.37           C  
ATOM    171  CE2 PHE A  23      43.388  55.439   7.185  1.00 25.79           C  
ATOM    172  CZ  PHE A  23      43.376  54.703   6.000  1.00 25.37           C  
ATOM    173  N   ILE A  24      47.591  50.796  10.695  1.00 25.07           N  
ATOM    174  CA  ILE A  24      48.571  50.525  11.736  1.00 26.07           C  
ATOM    175  C   ILE A  24      49.718  51.506  11.525  1.00 26.33           C  
ATOM    176  O   ILE A  24      50.566  51.331  10.645  1.00 26.47           O  
ATOM    177  CB  ILE A  24      49.017  49.042  11.747  1.00 26.13           C  
ATOM    178  CG1 ILE A  24      47.855  48.132  12.175  1.00 26.69           C  
ATOM    179  CG2 ILE A  24      50.199  48.832  12.690  1.00 26.66           C  
ATOM    180  CD1 ILE A  24      46.907  47.725  11.054  1.00 28.48           C  
ATOM    181  N   VAL A  25      49.704  52.560  12.333  1.00 26.91           N  
ATOM    182  CA  VAL A  25      50.548  53.736  12.128  1.00 27.24           C  
ATOM    183  C   VAL A  25      51.682  53.745  13.162  1.00 28.06           C  
ATOM    184  O   VAL A  25      51.434  53.835  14.366  1.00 27.30           O  
ATOM    185  CB  VAL A  25      49.699  55.040  12.224  1.00 27.47           C  
ATOM    186  CG1 VAL A  25      50.546  56.277  11.966  1.00 26.49           C  
ATOM    187  CG2 VAL A  25      48.506  54.992  11.258  1.00 26.72           C  
ATOM    188  N   GLU A  26      52.920  53.629  12.680  1.00 29.04           N  
ATOM    189  CA  GLU A  26      54.090  53.544  13.560  1.00 30.38           C  
ATOM    190  C   GLU A  26      54.884  54.854  13.510  1.00 30.50           C  
ATOM    191  O   GLU A  26      55.047  55.442  12.437  1.00 30.46           O  
ATOM    192  CB  GLU A  26      54.968  52.352  13.161  1.00 30.23           C  
ATOM    193  CG  GLU A  26      56.085  51.998  14.152  1.00 31.64           C  
ATOM    194  CD  GLU A  26      56.980  50.859  13.668  1.00 31.96           C  
ATOM    195  OE1 GLU A  26      56.843  50.430  12.502  1.00 34.42           O  
ATOM    196  OE2 GLU A  26      57.827  50.382  14.460  1.00 33.71           O  
ATOM    197  N   ASN A  27      55.355  55.317  14.668  1.00 30.99           N  
ATOM    198  CA  ASN A  27      56.224  56.505  14.721  1.00 31.64           C  
ATOM    199  C   ASN A  27      57.710  56.145  14.829  1.00 31.98           C  
ATOM    200  O   ASN A  27      58.073  54.983  14.658  1.00 32.08           O  
ATOM    201  CB  ASN A  27      55.804  57.453  15.858  1.00 31.32           C  
ATOM    202  CG  ASN A  27      56.098  56.890  17.243  1.00 31.46           C  
ATOM    203  OD1 ASN A  27      56.631  55.790  17.390  1.00 32.77           O  
ATOM    204  ND2 ASN A  27      55.750  57.651  18.270  1.00 31.68           N  
ATOM    205  N   SER A  28      58.542  57.151  15.123  1.00 32.71           N  
ATOM    206  CA  SER A  28      59.995  57.017  15.303  1.00 33.75           C  
ATOM    207  C   SER A  28      60.418  56.018  16.376  1.00 34.07           C  
ATOM    208  O   SER A  28      61.418  55.317  16.213  1.00 34.67           O  
ATOM    209  CB  SER A  28      60.604  58.380  15.663  1.00 33.74           C  
ATOM    210  OG  SER A  28      60.703  59.217  14.523  1.00 35.09           O  
ATOM    211  N   ARG A  29      59.662  55.974  17.471  1.00 34.42           N  
ATOM    212  CA  ARG A  29      60.007  55.178  18.649  1.00 34.67           C  
ATOM    213  C   ARG A  29      59.471  53.749  18.568  1.00 34.72           C  
ATOM    214  O   ARG A  29      59.595  52.978  19.523  1.00 34.80           O  
ATOM    215  CB  ARG A  29      59.461  55.849  19.910  1.00 34.85           C  
ATOM    216  CG  ARG A  29      59.627  57.366  19.956  1.00 35.25           C  
ATOM    217  CD  ARG A  29      59.398  57.925  21.363  1.00 35.25           C  
ATOM    218  NE  ARG A  29      60.103  57.154  22.391  1.00 37.65           N  
ATOM    219  CZ  ARG A  29      61.420  57.172  22.593  1.00 38.32           C  
ATOM    220  NH1 ARG A  29      62.217  57.921  21.839  1.00 39.32           N  
ATOM    221  NH2 ARG A  29      61.946  56.430  23.553  1.00 39.99           N  
ATOM    222  N   GLY A  30      58.873  53.407  17.428  1.00 34.49           N  
ATOM    223  CA  GLY A  30      58.233  52.111  17.241  1.00 34.06           C  
ATOM    224  C   GLY A  30      56.918  51.982  17.987  1.00 33.71           C  
ATOM    225  O   GLY A  30      56.483  50.871  18.302  1.00 34.27           O  
ATOM    226  N   GLU A  31      56.292  53.122  18.275  1.00 32.97           N  
ATOM    227  CA  GLU A  31      55.001  53.162  18.959  1.00 32.20           C  
ATOM    228  C   GLU A  31      53.887  53.314  17.924  1.00 31.81           C  
ATOM    229  O   GLU A  31      54.138  53.780  16.818  1.00 31.54           O  
ATOM    230  CB  GLU A  31      54.961  54.324  19.952  1.00 32.16           C  
ATOM    231  CG  GLU A  31      56.116  54.334  20.957  1.00 32.22           C  
ATOM    232  CD  GLU A  31      56.219  55.641  21.714  1.00 32.47           C  
ATOM    233  OE1 GLU A  31      55.946  56.702  21.118  1.00 31.95           O  
ATOM    234  OE2 GLU A  31      56.578  55.608  22.911  1.00 34.27           O  
ATOM    235  N   PHE A  32      52.664  52.935  18.287  1.00 31.26           N  
ATOM    236  CA  PHE A  32      51.548  52.926  17.337  1.00 30.83           C  
ATOM    237  C   PHE A  32      50.407  53.844  17.762  1.00 30.76           C  
ATOM    238  O   PHE A  32      50.080  53.937  18.946  1.00 30.63           O  
ATOM    239  CB  PHE A  32      51.043  51.494  17.114  1.00 30.49           C  
ATOM    240  CG  PHE A  32      52.100  50.552  16.585  1.00 29.92           C  
ATOM    241  CD1 PHE A  32      52.310  50.418  15.214  1.00 28.65           C  
ATOM    242  CD2 PHE A  32      52.887  49.804  17.460  1.00 29.70           C  
ATOM    243  CE1 PHE A  32      53.279  49.555  14.722  1.00 27.84           C  
ATOM    244  CE2 PHE A  32      53.864  48.936  16.979  1.00 28.38           C  
ATOM    245  CZ  PHE A  32      54.060  48.811  15.605  1.00 29.24           C  
ATOM    246  N   LEU A  33      49.804  54.517  16.787  1.00 30.64           N  
ATOM    247  CA  LEU A  33      48.728  55.464  17.053  1.00 30.50           C  
ATOM    248  C   LEU A  33      47.401  54.769  17.366  1.00 30.92           C  
ATOM    249  O   LEU A  33      46.948  53.883  16.626  1.00 30.62           O  
ATOM    250  CB  LEU A  33      48.571  56.450  15.883  1.00 30.47           C  
ATOM    251  CG  LEU A  33      47.552  57.599  15.977  1.00 30.33           C  
ATOM    252  CD1 LEU A  33      47.755  58.478  17.215  1.00 30.75           C  
ATOM    253  CD2 LEU A  33      47.619  58.451  14.722  1.00 30.80           C  
ATOM    254  N   LEU A  34      46.794  55.180  18.476  1.00 31.14           N  
ATOM    255  CA  LEU A  34      45.472  54.725  18.881  1.00 31.89           C  
ATOM    256  C   LEU A  34      44.617  55.925  19.245  1.00 32.30           C  
ATOM    257  O   LEU A  34      45.124  56.930  19.762  1.00 32.30           O  
ATOM    258  CB  LEU A  34      45.559  53.774  20.078  1.00 32.27           C  
ATOM    259  CG  LEU A  34      46.155  52.386  19.833  1.00 33.18           C  
ATOM    260  CD1 LEU A  34      46.875  51.899  21.066  1.00 34.67           C  
ATOM    261  CD2 LEU A  34      45.088  51.381  19.391  1.00 34.53           C  
ATOM    262  N   GLY A  35      43.322  55.819  18.971  1.00 32.53           N  
ATOM    263  CA  GLY A  35      42.378  56.890  19.271  1.00 33.28           C  
ATOM    264  C   GLY A  35      41.224  56.376  20.102  1.00 33.81           C  
ATOM    265  O   GLY A  35      40.763  55.255  19.898  1.00 33.44           O  
ATOM    266  N   LYS A  36      40.762  57.198  21.044  1.00 34.59           N  
ATOM    267  CA  LYS A  36      39.628  56.838  21.893  1.00 35.59           C  
ATOM    268  C   LYS A  36      38.316  57.045  21.140  1.00 35.91           C  
ATOM    269  O   LYS A  36      38.085  58.108  20.565  1.00 35.64           O  
ATOM    270  CB  LYS A  36      39.644  57.648  23.203  1.00 35.79           C  
ATOM    271  CG  LYS A  36      38.501  57.316  24.174  1.00 37.15           C  
ATOM    272  CD  LYS A  36      38.932  57.418  25.640  1.00 39.47           C  
ATOM    273  CE  LYS A  36      38.735  58.816  26.223  1.00 41.55           C  
ATOM    274  NZ  LYS A  36      37.325  59.070  26.666  1.00 42.64           N  
ATOM    275  N   ARG A  37      37.467  56.020  21.141  1.00 36.54           N  
ATOM    276  CA  ARG A  37      36.127  56.140  20.563  1.00 37.32           C  
ATOM    277  C   ARG A  37      35.150  56.769  21.548  1.00 37.48           C  
ATOM    278  O   ARG A  37      35.011  56.313  22.683  1.00 37.47           O  
ATOM    279  CB  ARG A  37      35.602  54.789  20.080  1.00 37.46           C  
ATOM    280  CG  ARG A  37      35.987  54.464  18.649  1.00 38.25           C  
ATOM    281  CD  ARG A  37      35.046  53.427  18.040  1.00 38.87           C  
ATOM    282  NE  ARG A  37      33.693  53.950  17.859  1.00 39.46           N  
ATOM    283  CZ  ARG A  37      33.280  54.630  16.791  1.00 39.61           C  
ATOM    284  NH1 ARG A  37      34.113  54.883  15.786  1.00 39.45           N  
ATOM    285  NH2 ARG A  37      32.027  55.061  16.728  1.00 39.59           N  
ATOM    286  N   THR A  38      34.470  57.820  21.092  1.00 38.03           N  
ATOM    287  CA  THR A  38      33.574  58.604  21.941  1.00 38.52           C  
ATOM    288  C   THR A  38      32.097  58.314  21.653  1.00 38.61           C  
ATOM    289  O   THR A  38      31.209  58.799  22.358  1.00 38.86           O  
ATOM    290  CB  THR A  38      33.850  60.116  21.799  1.00 38.49           C  
ATOM    291  OG1 THR A  38      33.940  60.464  20.411  1.00 38.99           O  
ATOM    292  CG2 THR A  38      35.156  60.482  22.492  1.00 39.08           C  
ATOM    293  N   ASN A  39      31.843  57.522  20.614  1.00 38.55           N  
ATOM    294  CA  ASN A  39      30.489  57.105  20.274  1.00 38.53           C  
ATOM    295  C   ASN A  39      30.442  55.611  19.975  1.00 38.31           C  
ATOM    296  O   ASN A  39      31.483  54.966  19.811  1.00 38.02           O  
ATOM    297  CB  ASN A  39      29.954  57.900  19.073  1.00 38.82           C  
ATOM    298  CG  ASN A  39      30.075  59.409  19.257  1.00 39.67           C  
ATOM    299  OD1 ASN A  39      30.838  60.067  18.549  1.00 40.95           O  
ATOM    300  ND2 ASN A  39      29.317  59.962  20.203  1.00 40.79           N  
ATOM    301  N   ARG A  40      29.230  55.068  19.910  1.00 38.21           N  
ATOM    302  CA  ARG A  40      29.016  53.666  19.553  1.00 37.91           C  
ATOM    303  C   ARG A  40      29.484  53.390  18.123  1.00 37.41           C  
ATOM    304  O   ARG A  40      29.496  54.308  17.294  1.00 37.01           O  
ATOM    305  CB  ARG A  40      27.540  53.307  19.697  1.00 38.14           C  
ATOM    306  CG  ARG A  40      27.040  53.231  21.129  1.00 38.87           C  
ATOM    307  CD  ARG A  40      25.666  52.583  21.155  1.00 40.61           C  
ATOM    308  NE  ARG A  40      25.017  52.657  22.464  1.00 41.62           N  
ATOM    309  CZ  ARG A  40      25.091  51.716  23.403  1.00 42.57           C  
ATOM    310  NH1 ARG A  40      25.810  50.614  23.205  1.00 43.22           N  
ATOM    311  NH2 ARG A  40      24.450  51.883  24.552  1.00 42.82           N  
ATOM    312  N   PRO A  41      29.881  52.133  17.825  1.00 36.96           N  
ATOM    313  CA  PRO A  41      29.956  50.962  18.709  1.00 36.71           C  
ATOM    314  C   PRO A  41      31.239  50.892  19.542  1.00 36.33           C  
ATOM    315  O   PRO A  41      32.231  51.546  19.211  1.00 36.00           O  
ATOM    316  CB  PRO A  41      29.896  49.787  17.728  1.00 36.66           C  
ATOM    317  CG  PRO A  41      30.473  50.306  16.473  1.00 36.90           C  
ATOM    318  CD  PRO A  41      30.293  51.799  16.448  1.00 36.78           C  
ATOM    319  N   ALA A  42      31.207  50.094  20.613  1.00 36.25           N  
ATOM    320  CA  ALA A  42      32.362  49.915  21.514  1.00 36.15           C  
ATOM    321  C   ALA A  42      32.909  51.255  22.019  1.00 36.08           C  
ATOM    322  O   ALA A  42      34.124  51.494  22.032  1.00 35.74           O  
ATOM    323  CB  ALA A  42      33.458  49.091  20.843  1.00 36.10           C  
ATOM    324  N   GLN A  43      31.979  52.123  22.416  1.00 35.74           N  
ATOM    325  CA  GLN A  43      32.280  53.414  23.016  1.00 36.05           C  
ATOM    326  C   GLN A  43      33.263  53.254  24.175  1.00 35.33           C  
ATOM    327  O   GLN A  43      33.118  52.347  24.997  1.00 35.41           O  
ATOM    328  CB  GLN A  43      30.976  54.035  23.519  1.00 36.17           C  
ATOM    329  CG  GLN A  43      30.984  55.539  23.672  1.00 37.25           C  
ATOM    330  CD  GLN A  43      29.591  56.102  23.921  1.00 37.53           C  
ATOM    331  OE1 GLN A  43      28.666  55.378  24.301  1.00 39.76           O  
ATOM    332  NE2 GLN A  43      29.435  57.402  23.699  1.00 40.04           N  
ATOM    333  N   GLY A  44      34.278  54.114  24.213  1.00 34.63           N  
ATOM    334  CA  GLY A  44      35.224  54.145  25.326  1.00 33.53           C  
ATOM    335  C   GLY A  44      36.523  53.406  25.083  1.00 32.98           C  
ATOM    336  O   GLY A  44      37.516  53.654  25.763  1.00 32.86           O  
ATOM    337  N   TYR A  45      36.518  52.490  24.119  1.00 32.39           N  
ATOM    338  CA  TYR A  45      37.719  51.724  23.787  1.00 31.74           C  
ATOM    339  C   TYR A  45      38.639  52.504  22.845  1.00 31.18           C  
ATOM    340  O   TYR A  45      38.194  53.420  22.148  1.00 30.73           O  
ATOM    341  CB  TYR A  45      37.345  50.377  23.166  1.00 31.99           C  
ATOM    342  CG  TYR A  45      36.877  49.333  24.154  1.00 32.34           C  
ATOM    343  CD1 TYR A  45      35.528  49.217  24.490  1.00 32.59           C  
ATOM    344  CD2 TYR A  45      37.779  48.450  24.741  1.00 32.48           C  
ATOM    345  CE1 TYR A  45      35.092  48.258  25.388  1.00 32.88           C  
ATOM    346  CE2 TYR A  45      37.351  47.475  25.640  1.00 33.29           C  
ATOM    347  CZ  TYR A  45      36.006  47.387  25.958  1.00 32.91           C  
ATOM    348  OH  TYR A  45      35.575  46.432  26.851  1.00 32.95           O  
ATOM    349  N   TRP A  46      39.918  52.124  22.837  1.00 30.30           N  
ATOM    350  CA  TRP A  46      40.923  52.733  21.962  1.00 29.45           C  
ATOM    351  C   TRP A  46      41.195  51.853  20.742  1.00 28.34           C  
ATOM    352  O   TRP A  46      41.411  50.645  20.872  1.00 28.37           O  
ATOM    353  CB  TRP A  46      42.223  52.983  22.730  1.00 30.19           C  
ATOM    354  CG  TRP A  46      42.082  54.000  23.834  1.00 30.67           C  
ATOM    355  CD1 TRP A  46      41.403  53.847  25.009  1.00 31.62           C  
ATOM    356  CD2 TRP A  46      42.644  55.316  23.864  1.00 31.58           C  
ATOM    357  NE1 TRP A  46      41.503  54.986  25.764  1.00 32.65           N  
ATOM    358  CE2 TRP A  46      42.259  55.907  25.087  1.00 32.08           C  
ATOM    359  CE3 TRP A  46      43.436  56.055  22.975  1.00 31.75           C  
ATOM    360  CZ2 TRP A  46      42.641  57.205  25.450  1.00 31.67           C  
ATOM    361  CZ3 TRP A  46      43.814  57.350  23.336  1.00 32.06           C  
ATOM    362  CH2 TRP A  46      43.416  57.909  24.562  1.00 31.42           C  
ATOM    363  N   PHE A  47      41.175  52.475  19.566  1.00 27.10           N  
ATOM    364  CA  PHE A  47      41.329  51.778  18.286  1.00 25.58           C  
ATOM    365  C   PHE A  47      42.383  52.451  17.422  1.00 24.72           C  
ATOM    366  O   PHE A  47      42.630  53.651  17.561  1.00 24.07           O  
ATOM    367  CB  PHE A  47      40.008  51.797  17.508  1.00 25.86           C  
ATOM    368  CG  PHE A  47      38.904  51.019  18.154  1.00 25.72           C  
ATOM    369  CD1 PHE A  47      38.046  51.628  19.061  1.00 25.67           C  
ATOM    370  CD2 PHE A  47      38.704  49.677  17.836  1.00 26.85           C  
ATOM    371  CE1 PHE A  47      37.007  50.909  19.652  1.00 26.50           C  
ATOM    372  CE2 PHE A  47      37.669  48.956  18.415  1.00 25.88           C  
ATOM    373  CZ  PHE A  47      36.824  49.573  19.331  1.00 26.59           C  
ATOM    374  N   VAL A  48      42.992  51.673  16.527  1.00 23.69           N  
ATOM    375  CA  VAL A  48      43.791  52.226  15.430  1.00 23.18           C  
ATOM    376  C   VAL A  48      42.914  53.184  14.613  1.00 22.95           C  
ATOM    377  O   VAL A  48      41.690  53.043  14.610  1.00 22.41           O  
ATOM    378  CB  VAL A  48      44.375  51.110  14.498  1.00 23.17           C  
ATOM    379  CG1 VAL A  48      45.416  50.265  15.235  1.00 22.80           C  
ATOM    380  CG2 VAL A  48      43.272  50.227  13.900  1.00 22.60           C  
ATOM    381  N   PRO A  49      43.530  54.165  13.924  1.00 22.97           N  
ATOM    382  CA  PRO A  49      42.733  55.011  13.029  1.00 22.99           C  
ATOM    383  C   PRO A  49      42.143  54.220  11.859  1.00 22.70           C  
ATOM    384  O   PRO A  49      42.690  53.194  11.466  1.00 22.37           O  
ATOM    385  CB  PRO A  49      43.757  56.028  12.506  1.00 22.81           C  
ATOM    386  CG  PRO A  49      44.888  55.987  13.522  1.00 23.58           C  
ATOM    387  CD  PRO A  49      44.950  54.558  13.921  1.00 23.00           C  
ATOM    388  N   GLY A  50      41.026  54.702  11.317  1.00 23.28           N  
ATOM    389  CA  GLY A  50      40.417  54.106  10.128  1.00 23.48           C  
ATOM    390  C   GLY A  50      39.022  54.628   9.835  1.00 23.78           C  
ATOM    391  O   GLY A  50      38.546  55.559  10.475  1.00 24.34           O  
ATOM    392  N   GLY A  51      38.358  54.019   8.864  1.00 23.60           N  
ATOM    393  CA  GLY A  51      37.017  54.437   8.494  1.00 23.87           C  
ATOM    394  C   GLY A  51      36.462  53.564   7.398  1.00 23.82           C  
ATOM    395  O   GLY A  51      37.198  52.810   6.772  1.00 23.55           O  
ATOM    396  N   ARG A  52      35.161  53.677   7.152  1.00 24.24           N  
ATOM    397  CA  ARG A  52      34.529  52.795   6.188  1.00 24.76           C  
ATOM    398  C   ARG A  52      34.655  53.320   4.759  1.00 24.40           C  
ATOM    399  O   ARG A  52      34.749  54.535   4.533  1.00 24.36           O  
ATOM    400  CB  ARG A  52      33.077  52.470   6.577  1.00 25.24           C  
ATOM    401  CG  ARG A  52      32.056  53.466   6.134  1.00 27.42           C  
ATOM    402  CD  ARG A  52      30.658  52.903   6.264  1.00 30.35           C  
ATOM    403  NE  ARG A  52      29.703  53.832   5.683  1.00 33.74           N  
ATOM    404  CZ  ARG A  52      29.160  53.711   4.477  1.00 35.01           C  
ATOM    405  NH1 ARG A  52      29.450  52.676   3.703  1.00 35.98           N  
ATOM    406  NH2 ARG A  52      28.315  54.634   4.049  1.00 36.31           N  
ATOM    407  N   VAL A  53      34.705  52.381   3.815  1.00 23.94           N  
ATOM    408  CA  VAL A  53      34.686  52.685   2.389  1.00 23.68           C  
ATOM    409  C   VAL A  53      33.239  52.927   1.972  1.00 24.08           C  
ATOM    410  O   VAL A  53      32.327  52.176   2.346  1.00 24.23           O  
ATOM    411  CB  VAL A  53      35.335  51.548   1.542  1.00 23.64           C  
ATOM    412  CG1 VAL A  53      35.350  51.909   0.053  1.00 22.48           C  
ATOM    413  CG2 VAL A  53      36.756  51.255   2.031  1.00 22.25           C  
ATOM    414  N   GLN A  54      33.032  53.992   1.211  1.00 24.33           N  
ATOM    415  CA  GLN A  54      31.689  54.412   0.842  1.00 24.77           C  
ATOM    416  C   GLN A  54      31.312  53.913  -0.552  1.00 24.24           C  
ATOM    417  O   GLN A  54      32.178  53.512  -1.326  1.00 23.80           O  
ATOM    418  CB  GLN A  54      31.568  55.933   0.969  1.00 25.55           C  
ATOM    419  CG  GLN A  54      32.164  56.436   2.289  1.00 27.87           C  
ATOM    420  CD  GLN A  54      31.697  57.807   2.685  1.00 33.02           C  
ATOM    421  OE1 GLN A  54      31.310  58.023   3.834  1.00 35.23           O  
ATOM    422  NE2 GLN A  54      31.750  58.755   1.750  1.00 34.05           N  
ATOM    423  N   LYS A  55      30.012  53.911  -0.836  1.00 24.19           N  
ATOM    424  CA  LYS A  55      29.472  53.498  -2.129  1.00 23.92           C  
ATOM    425  C   LYS A  55      30.164  54.199  -3.296  1.00 23.93           C  
ATOM    426  O   LYS A  55      30.321  55.425  -3.297  1.00 23.78           O  
ATOM    427  CB  LYS A  55      27.960  53.753  -2.172  1.00 24.02           C  
ATOM    428  CG  LYS A  55      27.282  53.416  -3.498  1.00 23.18           C  
ATOM    429  CD  LYS A  55      27.291  51.916  -3.758  1.00 21.68           C  
ATOM    430  CE  LYS A  55      26.688  51.580  -5.107  1.00 19.97           C  
ATOM    431  NZ  LYS A  55      25.264  52.062  -5.266  1.00 19.37           N  
ATOM    432  N   ASP A  56      30.594  53.395  -4.271  1.00 23.78           N  
ATOM    433  CA  ASP A  56      31.221  53.868  -5.502  1.00 23.99           C  
ATOM    434  C   ASP A  56      32.543  54.619  -5.304  1.00 23.99           C  
ATOM    435  O   ASP A  56      33.016  55.298  -6.209  1.00 24.57           O  
ATOM    436  CB  ASP A  56      30.224  54.673  -6.357  1.00 24.40           C  
ATOM    437  CG  ASP A  56      29.225  53.781  -7.087  1.00 25.43           C  
ATOM    438  OD1 ASP A  56      29.496  52.556  -7.215  1.00 24.71           O  
ATOM    439  OD2 ASP A  56      28.169  54.303  -7.529  1.00 25.75           O  
ATOM    440  N   GLU A  57      33.139  54.470  -4.124  1.00 23.69           N  
ATOM    441  CA  GLU A  57      34.477  54.980  -3.852  1.00 23.21           C  
ATOM    442  C   GLU A  57      35.491  53.849  -4.025  1.00 23.22           C  
ATOM    443  O   GLU A  57      35.290  52.738  -3.508  1.00 23.09           O  
ATOM    444  CB  GLU A  57      34.552  55.538  -2.419  1.00 23.22           C  
ATOM    445  CG  GLU A  57      35.919  56.099  -2.016  1.00 22.98           C  
ATOM    446  CD  GLU A  57      35.947  56.677  -0.608  1.00 23.26           C  
ATOM    447  OE1 GLU A  57      35.295  56.108   0.303  1.00 22.29           O  
ATOM    448  OE2 GLU A  57      36.657  57.690  -0.412  1.00 24.10           O  
ATOM    449  N   THR A  58      36.580  54.131  -4.741  1.00 22.43           N  
ATOM    450  CA  THR A  58      37.655  53.153  -4.873  1.00 22.57           C  
ATOM    451  C   THR A  58      38.432  53.053  -3.564  1.00 22.45           C  
ATOM    452  O   THR A  58      38.383  53.965  -2.732  1.00 22.37           O  
ATOM    453  CB  THR A  58      38.650  53.464  -6.023  1.00 22.53           C  
ATOM    454  OG1 THR A  58      39.360  54.669  -5.733  1.00 21.90           O  
ATOM    455  CG2 THR A  58      37.935  53.587  -7.367  1.00 22.83           C  
ATOM    456  N   LEU A  59      39.134  51.937  -3.384  1.00 22.19           N  
ATOM    457  CA  LEU A  59      40.015  51.757  -2.232  1.00 22.39           C  
ATOM    458  C   LEU A  59      41.103  52.825  -2.237  1.00 22.77           C  
ATOM    459  O   LEU A  59      41.465  53.359  -1.193  1.00 22.65           O  
ATOM    460  CB  LEU A  59      40.655  50.362  -2.244  1.00 21.95           C  
ATOM    461  CG  LEU A  59      39.715  49.150  -2.173  1.00 21.39           C  
ATOM    462  CD1 LEU A  59      40.529  47.857  -2.068  1.00 20.96           C  
ATOM    463  CD2 LEU A  59      38.743  49.272  -1.019  1.00 19.33           C  
ATOM    464  N   GLU A  60      41.598  53.132  -3.429  1.00 23.49           N  
ATOM    465  CA  GLU A  60      42.664  54.114  -3.619  1.00 24.58           C  
ATOM    466  C   GLU A  60      42.230  55.498  -3.129  1.00 24.59           C  
ATOM    467  O   GLU A  60      42.974  56.163  -2.408  1.00 25.04           O  
ATOM    468  CB  GLU A  60      43.088  54.150  -5.096  1.00 24.81           C  
ATOM    469  CG  GLU A  60      43.928  52.932  -5.564  1.00 27.13           C  
ATOM    470  CD  GLU A  60      43.117  51.633  -5.761  1.00 30.47           C  
ATOM    471  OE1 GLU A  60      41.877  51.690  -5.943  1.00 29.44           O  
ATOM    472  OE2 GLU A  60      43.739  50.545  -5.727  1.00 33.04           O  
ATOM    473  N   ALA A  61      41.022  55.912  -3.512  1.00 24.48           N  
ATOM    474  CA  ALA A  61      40.445  57.191  -3.090  1.00 24.53           C  
ATOM    475  C   ALA A  61      40.120  57.197  -1.594  1.00 24.52           C  
ATOM    476  O   ALA A  61      40.327  58.203  -0.914  1.00 23.93           O  
ATOM    477  CB  ALA A  61      39.197  57.503  -3.905  1.00 24.46           C  
ATOM    478  N   ALA A  62      39.626  56.063  -1.091  1.00 24.76           N  
ATOM    479  CA  ALA A  62      39.301  55.916   0.328  1.00 25.34           C  
ATOM    480  C   ALA A  62      40.537  56.086   1.190  1.00 25.66           C  
ATOM    481  O   ALA A  62      40.505  56.788   2.200  1.00 25.99           O  
ATOM    482  CB  ALA A  62      38.644  54.552   0.602  1.00 25.17           C  
ATOM    483  N   PHE A  63      41.625  55.442   0.782  1.00 26.08           N  
ATOM    484  CA  PHE A  63      42.882  55.502   1.519  1.00 26.80           C  
ATOM    485  C   PHE A  63      43.340  56.955   1.652  1.00 27.03           C  
ATOM    486  O   PHE A  63      43.675  57.402   2.749  1.00 27.31           O  
ATOM    487  CB  PHE A  63      43.946  54.658   0.813  1.00 26.81           C  
ATOM    488  CG  PHE A  63      45.163  54.390   1.646  1.00 27.50           C  
ATOM    489  CD1 PHE A  63      46.228  55.282   1.658  1.00 27.49           C  
ATOM    490  CD2 PHE A  63      45.248  53.240   2.422  1.00 28.91           C  
ATOM    491  CE1 PHE A  63      47.362  55.029   2.422  1.00 27.72           C  
ATOM    492  CE2 PHE A  63      46.378  52.982   3.190  1.00 28.94           C  
ATOM    493  CZ  PHE A  63      47.438  53.883   3.189  1.00 28.56           C  
ATOM    494  N   GLU A  64      43.325  57.682   0.534  1.00 27.44           N  
ATOM    495  CA  GLU A  64      43.740  59.090   0.495  1.00 28.06           C  
ATOM    496  C   GLU A  64      42.835  59.986   1.340  1.00 27.83           C  
ATOM    497  O   GLU A  64      43.324  60.860   2.060  1.00 28.28           O  
ATOM    498  CB  GLU A  64      43.796  59.604  -0.954  1.00 27.86           C  
ATOM    499  CG  GLU A  64      44.900  58.962  -1.805  1.00 29.01           C  
ATOM    500  CD  GLU A  64      45.123  59.663  -3.141  1.00 29.43           C  
ATOM    501  OE1 GLU A  64      44.830  60.877  -3.249  1.00 31.93           O  
ATOM    502  OE2 GLU A  64      45.596  58.996  -4.089  1.00 31.71           O  
ATOM    503  N   ARG A  65      41.522  59.768   1.247  1.00 27.95           N  
ATOM    504  CA  ARG A  65      40.541  60.524   2.026  1.00 27.97           C  
ATOM    505  C   ARG A  65      40.687  60.250   3.528  1.00 28.23           C  
ATOM    506  O   ARG A  65      40.673  61.182   4.343  1.00 27.89           O  
ATOM    507  CB  ARG A  65      39.119  60.189   1.555  1.00 28.40           C  
ATOM    508  CG  ARG A  65      38.008  60.728   2.449  1.00 28.33           C  
ATOM    509  CD  ARG A  65      36.623  60.352   1.954  1.00 27.93           C  
ATOM    510  NE  ARG A  65      36.366  58.909   1.935  1.00 26.62           N  
ATOM    511  CZ  ARG A  65      35.961  58.193   2.984  1.00 27.60           C  
ATOM    512  NH1 ARG A  65      35.775  58.772   4.163  1.00 25.33           N  
ATOM    513  NH2 ARG A  65      35.742  56.886   2.855  1.00 25.92           N  
ATOM    514  N   LEU A  66      40.840  58.974   3.882  1.00 27.98           N  
ATOM    515  CA  LEU A  66      40.868  58.558   5.288  1.00 28.14           C  
ATOM    516  C   LEU A  66      42.171  58.875   5.999  1.00 28.50           C  
ATOM    517  O   LEU A  66      42.158  59.205   7.182  1.00 28.40           O  
ATOM    518  CB  LEU A  66      40.511  57.077   5.436  1.00 27.68           C  
ATOM    519  CG  LEU A  66      39.034  56.750   5.176  1.00 27.29           C  
ATOM    520  CD1 LEU A  66      38.829  55.245   4.985  1.00 25.81           C  
ATOM    521  CD2 LEU A  66      38.141  57.291   6.295  1.00 26.47           C  
ATOM    522  N   THR A  67      43.291  58.781   5.286  1.00 29.39           N  
ATOM    523  CA  THR A  67      44.582  59.183   5.846  1.00 30.29           C  
ATOM    524  C   THR A  67      44.607  60.686   6.129  1.00 31.20           C  
ATOM    525  O   THR A  67      45.193  61.119   7.118  1.00 31.34           O  
ATOM    526  CB  THR A  67      45.775  58.802   4.947  1.00 30.13           C  
ATOM    527  OG1 THR A  67      45.507  59.192   3.594  1.00 29.84           O  
ATOM    528  CG2 THR A  67      46.057  57.296   5.025  1.00 29.77           C  
ATOM    529  N   MET A  68      43.957  61.469   5.269  1.00 32.27           N  
ATOM    530  CA  MET A  68      43.853  62.908   5.486  1.00 33.67           C  
ATOM    531  C   MET A  68      42.900  63.222   6.637  1.00 33.89           C  
ATOM    532  O   MET A  68      43.213  64.045   7.497  1.00 34.10           O  
ATOM    533  CB  MET A  68      43.430  63.643   4.205  1.00 33.86           C  
ATOM    534  CG  MET A  68      43.345  65.172   4.350  1.00 35.85           C  
ATOM    535  SD  MET A  68      44.926  65.940   4.784  1.00 38.73           S  
ATOM    536  CE  MET A  68      44.455  67.666   4.916  1.00 37.24           C  
ATOM    537  N   ALA A  69      41.744  62.568   6.645  1.00 34.40           N  
ATOM    538  CA  ALA A  69      40.728  62.803   7.668  1.00 35.06           C  
ATOM    539  C   ALA A  69      41.208  62.366   9.048  1.00 35.55           C  
ATOM    540  O   ALA A  69      41.082  63.114  10.027  1.00 35.72           O  
ATOM    541  CB  ALA A  69      39.427  62.084   7.303  1.00 35.07           C  
ATOM    542  N   GLU A  70      41.778  61.161   9.107  1.00 35.89           N  
ATOM    543  CA  GLU A  70      42.143  60.520  10.369  1.00 36.30           C  
ATOM    544  C   GLU A  70      43.480  60.987  10.923  1.00 36.80           C  
ATOM    545  O   GLU A  70      43.625  61.131  12.139  1.00 37.28           O  
ATOM    546  CB  GLU A  70      42.150  58.990  10.223  1.00 36.13           C  
ATOM    547  CG  GLU A  70      40.771  58.362  10.075  1.00 35.62           C  
ATOM    548  CD  GLU A  70      40.006  58.330  11.385  1.00 35.82           C  
ATOM    549  OE1 GLU A  70      40.402  57.559  12.289  1.00 34.65           O  
ATOM    550  OE2 GLU A  70      39.009  59.070  11.504  1.00 34.69           O  
ATOM    551  N   LEU A  71      44.443  61.221  10.033  1.00 37.26           N  
ATOM    552  CA  LEU A  71      45.825  61.521  10.421  1.00 37.76           C  
ATOM    553  C   LEU A  71      46.244  62.967  10.149  1.00 38.22           C  
ATOM    554  O   LEU A  71      47.246  63.436  10.696  1.00 38.52           O  
ATOM    555  CB  LEU A  71      46.801  60.569   9.707  1.00 37.63           C  
ATOM    556  CG  LEU A  71      46.544  59.059   9.723  1.00 37.27           C  
ATOM    557  CD1 LEU A  71      47.526  58.341   8.811  1.00 36.73           C  
ATOM    558  CD2 LEU A  71      46.625  58.506  11.136  1.00 36.23           C  
ATOM    559  N   GLY A  72      45.487  63.660   9.305  1.00 38.45           N  
ATOM    560  CA  GLY A  72      45.836  65.015   8.878  1.00 39.34           C  
ATOM    561  C   GLY A  72      46.918  65.051   7.810  1.00 39.64           C  
ATOM    562  O   GLY A  72      47.506  66.101   7.543  1.00 39.76           O  
ATOM    563  N   LEU A  73      47.178  63.896   7.204  1.00 39.94           N  
ATOM    564  CA  LEU A  73      48.189  63.767   6.164  1.00 40.39           C  
ATOM    565  C   LEU A  73      47.672  62.872   5.038  1.00 40.51           C  
ATOM    566  O   LEU A  73      47.426  61.677   5.247  1.00 40.54           O  
ATOM    567  CB  LEU A  73      49.488  63.208   6.755  1.00 40.37           C  
ATOM    568  CG  LEU A  73      50.685  62.925   5.842  1.00 40.94           C  
ATOM    569  CD1 LEU A  73      51.206  64.196   5.182  1.00 41.91           C  
ATOM    570  CD2 LEU A  73      51.789  62.246   6.637  1.00 40.79           C  
ATOM    571  N   ARG A  74      47.501  63.460   3.855  1.00 40.37           N  
ATOM    572  CA  ARG A  74      46.990  62.735   2.696  1.00 40.61           C  
ATOM    573  C   ARG A  74      48.078  61.829   2.135  1.00 40.16           C  
ATOM    574  O   ARG A  74      49.080  62.304   1.595  1.00 40.43           O  
ATOM    575  CB  ARG A  74      46.489  63.701   1.616  1.00 40.87           C  
ATOM    576  CG  ARG A  74      45.626  63.049   0.539  1.00 42.27           C  
ATOM    577  CD  ARG A  74      45.612  63.860  -0.751  1.00 45.31           C  
ATOM    578  NE  ARG A  74      46.853  63.698  -1.519  1.00 47.40           N  
ATOM    579  CZ  ARG A  74      47.177  64.413  -2.598  1.00 48.41           C  
ATOM    580  NH1 ARG A  74      46.361  65.358  -3.053  1.00 48.40           N  
ATOM    581  NH2 ARG A  74      48.330  64.187  -3.220  1.00 48.91           N  
ATOM    582  N   LEU A  75      47.877  60.525   2.286  1.00 39.51           N  
ATOM    583  CA  LEU A  75      48.829  59.530   1.802  1.00 38.96           C  
ATOM    584  C   LEU A  75      48.186  58.672   0.713  1.00 38.60           C  
ATOM    585  O   LEU A  75      47.001  58.344   0.812  1.00 38.67           O  
ATOM    586  CB  LEU A  75      49.322  58.649   2.959  1.00 38.81           C  
ATOM    587  CG  LEU A  75      50.218  59.278   4.037  1.00 38.69           C  
ATOM    588  CD1 LEU A  75      50.388  58.333   5.213  1.00 38.05           C  
ATOM    589  CD2 LEU A  75      51.587  59.680   3.478  1.00 38.87           C  
ATOM    590  N   PRO A  76      48.956  58.328  -0.343  1.00 38.21           N  
ATOM    591  CA  PRO A  76      48.459  57.407  -1.366  1.00 37.68           C  
ATOM    592  C   PRO A  76      48.494  55.964  -0.869  1.00 37.07           C  
ATOM    593  O   PRO A  76      49.278  55.639   0.028  1.00 36.84           O  
ATOM    594  CB  PRO A  76      49.455  57.593  -2.514  1.00 37.94           C  
ATOM    595  CG  PRO A  76      50.738  57.975  -1.830  1.00 38.33           C  
ATOM    596  CD  PRO A  76      50.329  58.792  -0.633  1.00 38.24           C  
ATOM    597  N   ILE A  77      47.658  55.107  -1.454  1.00 36.46           N  
ATOM    598  CA  ILE A  77      47.589  53.692  -1.071  1.00 35.92           C  
ATOM    599  C   ILE A  77      48.948  52.979  -1.185  1.00 35.86           C  
ATOM    600  O   ILE A  77      49.223  52.025  -0.455  1.00 35.63           O  
ATOM    601  CB  ILE A  77      46.469  52.932  -1.855  1.00 35.97           C  
ATOM    602  CG1 ILE A  77      46.132  51.593  -1.173  1.00 35.65           C  
ATOM    603  CG2 ILE A  77      46.841  52.778  -3.342  1.00 35.50           C  
ATOM    604  CD1 ILE A  77      44.825  50.953  -1.634  1.00 35.46           C  
ATOM    605  N   THR A  78      49.798  53.479  -2.077  1.00 35.77           N  
ATOM    606  CA  THR A  78      51.128  52.911  -2.317  1.00 35.87           C  
ATOM    607  C   THR A  78      52.080  53.087  -1.128  1.00 35.49           C  
ATOM    608  O   THR A  78      53.053  52.346  -0.998  1.00 35.60           O  
ATOM    609  CB  THR A  78      51.776  53.513  -3.584  1.00 35.84           C  
ATOM    610  OG1 THR A  78      51.781  54.943  -3.490  1.00 36.45           O  
ATOM    611  CG2 THR A  78      51.010  53.093  -4.836  1.00 36.32           C  
ATOM    612  N   ALA A  79      51.791  54.068  -0.273  1.00 35.36           N  
ATOM    613  CA  ALA A  79      52.568  54.309   0.950  1.00 35.14           C  
ATOM    614  C   ALA A  79      52.267  53.277   2.037  1.00 34.96           C  
ATOM    615  O   ALA A  79      53.033  53.125   2.992  1.00 35.31           O  
ATOM    616  CB  ALA A  79      52.318  55.719   1.471  1.00 34.93           C  
ATOM    617  N   GLY A  80      51.149  52.571   1.891  1.00 34.64           N  
ATOM    618  CA  GLY A  80      50.728  51.576   2.877  1.00 34.14           C  
ATOM    619  C   GLY A  80      51.155  50.166   2.521  1.00 33.88           C  
ATOM    620  O   GLY A  80      51.174  49.788   1.344  1.00 33.82           O  
ATOM    621  N   GLN A  81      51.512  49.397   3.545  1.00 33.26           N  
ATOM    622  CA  GLN A  81      51.786  47.975   3.395  1.00 33.18           C  
ATOM    623  C   GLN A  81      50.503  47.202   3.715  1.00 32.03           C  
ATOM    624  O   GLN A  81      50.063  47.169   4.870  1.00 31.99           O  
ATOM    625  CB  GLN A  81      52.932  47.546   4.330  1.00 33.17           C  
ATOM    626  CG  GLN A  81      53.163  46.031   4.433  1.00 34.28           C  
ATOM    627  CD  GLN A  81      54.286  45.654   5.399  1.00 34.84           C  
ATOM    628  OE1 GLN A  81      55.404  46.174   5.314  1.00 37.81           O  
ATOM    629  NE2 GLN A  81      53.996  44.727   6.309  1.00 36.44           N  
ATOM    630  N   PHE A  82      49.908  46.581   2.697  1.00 30.92           N  
ATOM    631  CA  PHE A  82      48.708  45.767   2.909  1.00 29.59           C  
ATOM    632  C   PHE A  82      48.937  44.757   4.023  1.00 29.06           C  
ATOM    633  O   PHE A  82      49.928  44.034   4.021  1.00 28.70           O  
ATOM    634  CB  PHE A  82      48.255  45.054   1.631  1.00 29.38           C  
ATOM    635  CG  PHE A  82      47.005  44.233   1.815  1.00 28.31           C  
ATOM    636  CD1 PHE A  82      45.777  44.850   2.036  1.00 27.71           C  
ATOM    637  CD2 PHE A  82      47.059  42.843   1.785  1.00 27.69           C  
ATOM    638  CE1 PHE A  82      44.613  44.089   2.211  1.00 28.11           C  
ATOM    639  CE2 PHE A  82      45.902  42.075   1.956  1.00 27.01           C  
ATOM    640  CZ  PHE A  82      44.684  42.697   2.173  1.00 27.46           C  
ATOM    641  N   TYR A  83      48.010  44.723   4.970  1.00 28.57           N  
ATOM    642  CA  TYR A  83      48.196  43.963   6.193  1.00 28.13           C  
ATOM    643  C   TYR A  83      47.036  43.008   6.491  1.00 27.02           C  
ATOM    644  O   TYR A  83      46.668  42.793   7.648  1.00 26.75           O  
ATOM    645  CB  TYR A  83      48.448  44.918   7.368  1.00 29.49           C  
ATOM    646  CG  TYR A  83      49.356  44.327   8.416  1.00 30.68           C  
ATOM    647  CD1 TYR A  83      50.683  44.020   8.114  1.00 31.93           C  
ATOM    648  CD2 TYR A  83      48.888  44.057   9.699  1.00 31.92           C  
ATOM    649  CE1 TYR A  83      51.531  43.463   9.065  1.00 33.18           C  
ATOM    650  CE2 TYR A  83      49.730  43.501  10.668  1.00 33.25           C  
ATOM    651  CZ  TYR A  83      51.050  43.206  10.338  1.00 33.19           C  
ATOM    652  OH  TYR A  83      51.898  42.661  11.280  1.00 34.01           O  
ATOM    653  N   GLY A  84      46.464  42.445   5.429  1.00 25.89           N  
ATOM    654  CA  GLY A  84      45.466  41.389   5.547  1.00 24.64           C  
ATOM    655  C   GLY A  84      44.022  41.855   5.555  1.00 23.97           C  
ATOM    656  O   GLY A  84      43.728  43.059   5.658  1.00 23.18           O  
ATOM    657  N   VAL A  85      43.115  40.888   5.433  1.00 22.98           N  
ATOM    658  CA  VAL A  85      41.686  41.166   5.524  1.00 22.04           C  
ATOM    659  C   VAL A  85      41.189  40.624   6.859  1.00 21.95           C  
ATOM    660  O   VAL A  85      41.272  39.416   7.115  1.00 22.01           O  
ATOM    661  CB  VAL A  85      40.885  40.540   4.351  1.00 22.11           C  
ATOM    662  CG1 VAL A  85      39.406  40.893   4.464  1.00 21.24           C  
ATOM    663  CG2 VAL A  85      41.432  41.001   3.005  1.00 21.06           C  
ATOM    664  N   TRP A  86      40.689  41.519   7.707  1.00 21.26           N  
ATOM    665  CA  TRP A  86      40.197  41.142   9.029  1.00 21.25           C  
ATOM    666  C   TRP A  86      38.679  41.294   9.119  1.00 20.76           C  
ATOM    667  O   TRP A  86      38.042  41.793   8.191  1.00 20.37           O  
ATOM    668  CB  TRP A  86      40.904  41.970  10.113  1.00 21.43           C  
ATOM    669  CG  TRP A  86      42.411  41.942   9.990  1.00 22.19           C  
ATOM    670  CD1 TRP A  86      43.167  42.512   9.001  1.00 22.99           C  
ATOM    671  CD2 TRP A  86      43.339  41.326  10.895  1.00 22.04           C  
ATOM    672  NE1 TRP A  86      44.503  42.278   9.229  1.00 23.39           N  
ATOM    673  CE2 TRP A  86      44.636  41.557  10.387  1.00 22.90           C  
ATOM    674  CE3 TRP A  86      43.200  40.605  12.089  1.00 22.29           C  
ATOM    675  CZ2 TRP A  86      45.792  41.095  11.032  1.00 22.70           C  
ATOM    676  CZ3 TRP A  86      44.351  40.135  12.726  1.00 22.82           C  
ATOM    677  CH2 TRP A  86      45.627  40.386  12.197  1.00 22.52           C  
ATOM    678  N   GLN A  87      38.098  40.842  10.224  1.00 20.68           N  
ATOM    679  CA  GLN A  87      36.652  40.908  10.410  1.00 20.84           C  
ATOM    680  C   GLN A  87      36.346  41.307  11.839  1.00 20.56           C  
ATOM    681  O   GLN A  87      36.840  40.673  12.782  1.00 20.25           O  
ATOM    682  CB  GLN A  87      35.981  39.569  10.029  1.00 20.84           C  
ATOM    683  CG  GLN A  87      36.418  38.349  10.861  1.00 21.04           C  
ATOM    684  CD  GLN A  87      36.109  37.008  10.185  1.00 21.80           C  
ATOM    685  OE1 GLN A  87      35.276  36.921   9.277  1.00 20.69           O  
ATOM    686  NE2 GLN A  87      36.783  35.953  10.642  1.00 23.61           N  
ATOM    687  N   HIS A  88      35.557  42.370  11.992  1.00 20.53           N  
ATOM    688  CA  HIS A  88      35.198  42.919  13.305  1.00 21.02           C  
ATOM    689  C   HIS A  88      33.691  42.881  13.521  1.00 21.51           C  
ATOM    690  O   HIS A  88      32.924  43.409  12.720  1.00 21.23           O  
ATOM    691  CB  HIS A  88      35.710  44.360  13.472  1.00 20.77           C  
ATOM    692  CG  HIS A  88      37.203  44.495  13.367  1.00 20.05           C  
ATOM    693  ND1 HIS A  88      37.825  45.708  13.179  1.00 20.31           N  
ATOM    694  CD2 HIS A  88      38.192  43.571  13.408  1.00 19.98           C  
ATOM    695  CE1 HIS A  88      39.132  45.530  13.118  1.00 20.21           C  
ATOM    696  NE2 HIS A  88      39.381  44.242  13.250  1.00 20.72           N  
ATOM    697  N   PHE A  89      33.282  42.247  14.609  1.00 22.16           N  
ATOM    698  CA  PHE A  89      31.876  42.106  14.943  1.00 23.17           C  
ATOM    699  C   PHE A  89      31.596  42.880  16.226  1.00 23.87           C  
ATOM    700  O   PHE A  89      32.293  42.696  17.221  1.00 24.55           O  
ATOM    701  CB  PHE A  89      31.521  40.622  15.112  1.00 22.69           C  
ATOM    702  CG  PHE A  89      31.866  39.772  13.913  1.00 23.28           C  
ATOM    703  CD1 PHE A  89      31.031  39.743  12.800  1.00 22.33           C  
ATOM    704  CD2 PHE A  89      33.032  39.010  13.896  1.00 22.85           C  
ATOM    705  CE1 PHE A  89      31.346  38.955  11.694  1.00 22.63           C  
ATOM    706  CE2 PHE A  89      33.355  38.229  12.793  1.00 21.78           C  
ATOM    707  CZ  PHE A  89      32.511  38.208  11.689  1.00 21.47           C  
ATOM    708  N   TYR A  90      30.595  43.753  16.196  1.00 24.76           N  
ATOM    709  CA  TYR A  90      30.237  44.553  17.370  1.00 25.99           C  
ATOM    710  C   TYR A  90      28.815  44.267  17.782  1.00 26.71           C  
ATOM    711  O   TYR A  90      27.903  44.315  16.955  1.00 26.21           O  
ATOM    712  CB  TYR A  90      30.382  46.052  17.099  1.00 25.99           C  
ATOM    713  CG  TYR A  90      31.791  46.505  16.826  1.00 26.13           C  
ATOM    714  CD1 TYR A  90      32.638  46.878  17.872  1.00 26.74           C  
ATOM    715  CD2 TYR A  90      32.277  46.578  15.521  1.00 25.31           C  
ATOM    716  CE1 TYR A  90      33.940  47.303  17.619  1.00 26.80           C  
ATOM    717  CE2 TYR A  90      33.572  46.995  15.259  1.00 25.25           C  
ATOM    718  CZ  TYR A  90      34.396  47.358  16.311  1.00 26.68           C  
ATOM    719  OH  TYR A  90      35.678  47.779  16.053  1.00 26.83           O  
ATOM    720  N   ASP A  91      28.623  44.004  19.071  1.00 27.67           N  
ATOM    721  CA  ASP A  91      27.308  43.623  19.577  1.00 29.07           C  
ATOM    722  C   ASP A  91      26.337  44.809  19.586  1.00 29.17           C  
ATOM    723  O   ASP A  91      25.146  44.637  19.854  1.00 29.07           O  
ATOM    724  CB  ASP A  91      27.449  42.985  20.966  1.00 30.01           C  
ATOM    725  CG  ASP A  91      26.440  41.885  21.216  1.00 33.18           C  
ATOM    726  OD1 ASP A  91      25.397  41.826  20.522  1.00 36.34           O  
ATOM    727  OD2 ASP A  91      26.691  41.060  22.126  1.00 38.03           O  
ATOM    728  N   ASP A  92      26.843  46.006  19.274  1.00 28.93           N  
ATOM    729  CA  ASP A  92      25.999  47.202  19.150  1.00 29.30           C  
ATOM    730  C   ASP A  92      26.226  47.969  17.842  1.00 29.41           C  
ATOM    731  O   ASP A  92      26.930  47.493  16.947  1.00 29.14           O  
ATOM    732  CB  ASP A  92      26.173  48.125  20.365  1.00 29.39           C  
ATOM    733  CG  ASP A  92      27.596  48.663  20.510  1.00 30.40           C  
ATOM    734  OD1 ASP A  92      28.553  48.064  19.965  1.00 31.24           O  
ATOM    735  OD2 ASP A  92      27.753  49.700  21.185  1.00 31.70           O  
ATOM    736  N   ASN A  93      25.624  49.154  17.739  1.00 29.65           N  
ATOM    737  CA  ASN A  93      25.739  49.981  16.540  1.00 30.12           C  
ATOM    738  C   ASN A  93      25.711  51.483  16.831  1.00 30.69           C  
ATOM    739  O   ASN A  93      25.365  51.910  17.941  1.00 30.36           O  
ATOM    740  CB  ASN A  93      24.636  49.624  15.538  1.00 29.84           C  
ATOM    741  CG  ASN A  93      23.255  49.991  16.041  1.00 29.57           C  
ATOM    742  OD1 ASN A  93      22.615  49.226  16.766  1.00 30.65           O  
ATOM    743  ND2 ASN A  93      22.781  51.155  15.645  1.00 27.91           N  
ATOM    744  N   PHE A  94      26.042  52.273  15.812  1.00 31.34           N  
ATOM    745  CA  PHE A  94      26.050  53.739  15.901  1.00 32.24           C  
ATOM    746  C   PHE A  94      24.879  54.336  16.700  1.00 32.85           C  
ATOM    747  O   PHE A  94      25.062  55.326  17.405  1.00 33.21           O  
ATOM    748  CB  PHE A  94      26.151  54.374  14.499  1.00 31.91           C  
ATOM    749  CG  PHE A  94      24.870  54.322  13.695  1.00 32.21           C  
ATOM    750  CD1 PHE A  94      24.447  53.134  13.098  1.00 32.59           C  
ATOM    751  CD2 PHE A  94      24.103  55.471  13.511  1.00 31.97           C  
ATOM    752  CE1 PHE A  94      23.273  53.085  12.351  1.00 32.53           C  
ATOM    753  CE2 PHE A  94      22.924  55.435  12.764  1.00 31.39           C  
ATOM    754  CZ  PHE A  94      22.510  54.242  12.180  1.00 32.15           C  
ATOM    755  N   SER A  95      23.704  53.707  16.623  1.00 33.53           N  
ATOM    756  CA  SER A  95      22.471  54.281  17.183  1.00 34.17           C  
ATOM    757  C   SER A  95      21.868  53.565  18.403  1.00 34.39           C  
ATOM    758  O   SER A  95      20.730  53.851  18.781  1.00 34.64           O  
ATOM    759  CB  SER A  95      21.410  54.394  16.085  1.00 34.03           C  
ATOM    760  OG  SER A  95      20.871  53.118  15.773  1.00 35.19           O  
ATOM    761  N   GLY A  96      22.617  52.647  19.013  1.00 34.65           N  
ATOM    762  CA  GLY A  96      22.129  51.908  20.184  1.00 34.72           C  
ATOM    763  C   GLY A  96      22.472  50.426  20.198  1.00 34.76           C  
ATOM    764  O   GLY A  96      23.466  50.005  19.596  1.00 34.79           O  
ATOM    765  N   THR A  97      21.642  49.633  20.878  1.00 34.46           N  
ATOM    766  CA  THR A  97      21.928  48.208  21.087  1.00 34.43           C  
ATOM    767  C   THR A  97      20.934  47.254  20.418  1.00 34.14           C  
ATOM    768  O   THR A  97      20.934  46.062  20.719  1.00 34.28           O  
ATOM    769  CB  THR A  97      21.993  47.841  22.604  1.00 34.61           C  
ATOM    770  OG1 THR A  97      20.700  48.019  23.203  1.00 35.05           O  
ATOM    771  CG2 THR A  97      23.026  48.682  23.338  1.00 34.49           C  
ATOM    772  N   ASP A  98      20.096  47.772  19.522  1.00 33.73           N  
ATOM    773  CA  ASP A  98      19.045  46.962  18.893  1.00 33.32           C  
ATOM    774  C   ASP A  98      19.538  46.005  17.807  1.00 32.00           C  
ATOM    775  O   ASP A  98      18.859  45.029  17.482  1.00 32.10           O  
ATOM    776  CB  ASP A  98      17.892  47.838  18.376  1.00 34.11           C  
ATOM    777  CG  ASP A  98      18.365  49.029  17.548  1.00 36.89           C  
ATOM    778  OD1 ASP A  98      19.496  49.549  17.769  1.00 39.05           O  
ATOM    779  OD2 ASP A  98      17.579  49.458  16.669  1.00 40.10           O  
ATOM    780  N   PHE A  99      20.717  46.276  17.256  1.00 30.15           N  
ATOM    781  CA  PHE A  99      21.327  45.385  16.271  1.00 28.32           C  
ATOM    782  C   PHE A  99      22.849  45.470  16.270  1.00 26.94           C  
ATOM    783  O   PHE A  99      23.431  46.397  16.830  1.00 26.74           O  
ATOM    784  CB  PHE A  99      20.748  45.606  14.859  1.00 28.44           C  
ATOM    785  CG  PHE A  99      20.790  47.030  14.387  1.00 27.95           C  
ATOM    786  CD1 PHE A  99      21.890  47.516  13.689  1.00 27.75           C  
ATOM    787  CD2 PHE A  99      19.716  47.884  14.614  1.00 28.44           C  
ATOM    788  CE1 PHE A  99      21.920  48.840  13.238  1.00 27.91           C  
ATOM    789  CE2 PHE A  99      19.740  49.208  14.167  1.00 28.52           C  
ATOM    790  CZ  PHE A  99      20.845  49.686  13.485  1.00 27.95           C  
ATOM    791  N   THR A 100      23.479  44.482  15.642  1.00 25.46           N  
ATOM    792  CA  THR A 100      24.928  44.335  15.635  1.00 24.00           C  
ATOM    793  C   THR A 100      25.572  45.127  14.489  1.00 23.37           C  
ATOM    794  O   THR A 100      24.896  45.507  13.536  1.00 23.02           O  
ATOM    795  CB  THR A 100      25.301  42.863  15.453  1.00 24.16           C  
ATOM    796  OG1 THR A 100      24.763  42.391  14.203  1.00 22.94           O  
ATOM    797  CG2 THR A 100      24.757  42.004  16.617  1.00 23.47           C  
ATOM    798  N   THR A 101      26.880  45.352  14.585  1.00 22.50           N  
ATOM    799  CA  THR A 101      27.656  45.907  13.475  1.00 21.42           C  
ATOM    800  C   THR A 101      28.703  44.894  13.021  1.00 21.01           C  
ATOM    801  O   THR A 101      29.323  44.222  13.845  1.00 21.13           O  
ATOM    802  CB  THR A 101      28.332  47.249  13.848  1.00 21.47           C  
ATOM    803  OG1 THR A 101      27.374  48.117  14.472  1.00 20.95           O  
ATOM    804  CG2 THR A 101      28.865  47.942  12.606  1.00 20.49           C  
ATOM    805  N   HIS A 102      28.887  44.794  11.705  1.00 20.10           N  
ATOM    806  CA  HIS A 102      29.835  43.867  11.095  1.00 19.57           C  
ATOM    807  C   HIS A 102      30.743  44.617  10.103  1.00 19.55           C  
ATOM    808  O   HIS A 102      30.249  45.231   9.150  1.00 19.05           O  
ATOM    809  CB  HIS A 102      29.050  42.721  10.417  1.00 19.05           C  
ATOM    810  CG  HIS A 102      29.885  41.753   9.630  1.00 18.40           C  
ATOM    811  ND1 HIS A 102      29.321  40.810   8.800  1.00 15.97           N  
ATOM    812  CD2 HIS A 102      31.225  41.565   9.553  1.00 17.69           C  
ATOM    813  CE1 HIS A 102      30.274  40.088   8.240  1.00 18.28           C  
ATOM    814  NE2 HIS A 102      31.441  40.529   8.676  1.00 16.64           N  
ATOM    815  N   TYR A 103      32.057  44.570  10.350  1.00 19.12           N  
ATOM    816  CA  TYR A 103      33.056  45.117   9.425  1.00 19.41           C  
ATOM    817  C   TYR A 103      33.913  44.035   8.784  1.00 18.99           C  
ATOM    818  O   TYR A 103      34.427  43.144   9.465  1.00 18.64           O  
ATOM    819  CB  TYR A 103      34.029  46.071  10.130  1.00 19.77           C  
ATOM    820  CG  TYR A 103      33.469  47.399  10.563  1.00 21.57           C  
ATOM    821  CD1 TYR A 103      32.861  47.540  11.808  1.00 21.94           C  
ATOM    822  CD2 TYR A 103      33.580  48.524   9.746  1.00 21.21           C  
ATOM    823  CE1 TYR A 103      32.367  48.758  12.226  1.00 22.89           C  
ATOM    824  CE2 TYR A 103      33.078  49.750  10.154  1.00 22.96           C  
ATOM    825  CZ  TYR A 103      32.479  49.857  11.399  1.00 22.27           C  
ATOM    826  OH  TYR A 103      31.982  51.062  11.822  1.00 23.90           O  
ATOM    827  N   VAL A 104      34.076  44.134   7.474  1.00 18.32           N  
ATOM    828  CA  VAL A 104      35.183  43.474   6.799  1.00 18.37           C  
ATOM    829  C   VAL A 104      36.256  44.545   6.596  1.00 18.47           C  
ATOM    830  O   VAL A 104      36.013  45.598   5.984  1.00 18.33           O  
ATOM    831  CB  VAL A 104      34.748  42.779   5.476  1.00 18.12           C  
ATOM    832  CG1 VAL A 104      35.942  42.186   4.738  1.00 18.22           C  
ATOM    833  CG2 VAL A 104      33.707  41.680   5.768  1.00 17.68           C  
ATOM    834  N   VAL A 105      37.439  44.274   7.131  1.00 18.57           N  
ATOM    835  CA  VAL A 105      38.471  45.296   7.280  1.00 18.57           C  
ATOM    836  C   VAL A 105      39.730  45.005   6.483  1.00 19.50           C  
ATOM    837  O   VAL A 105      40.283  43.914   6.558  1.00 19.48           O  
ATOM    838  CB  VAL A 105      38.870  45.465   8.768  1.00 18.81           C  
ATOM    839  CG1 VAL A 105      39.812  46.643   8.945  1.00 18.37           C  
ATOM    840  CG2 VAL A 105      37.648  45.636   9.642  1.00 16.64           C  
ATOM    841  N   LEU A 106      40.186  46.011   5.741  1.00 19.97           N  
ATOM    842  CA  LEU A 106      41.460  45.966   5.059  1.00 21.16           C  
ATOM    843  C   LEU A 106      42.468  46.751   5.901  1.00 21.98           C  
ATOM    844  O   LEU A 106      42.319  47.959   6.094  1.00 21.98           O  
ATOM    845  CB  LEU A 106      41.320  46.568   3.648  1.00 21.45           C  
ATOM    846  CG  LEU A 106      40.097  46.091   2.846  1.00 21.61           C  
ATOM    847  CD1 LEU A 106      39.931  46.864   1.543  1.00 23.89           C  
ATOM    848  CD2 LEU A 106      40.160  44.594   2.568  1.00 23.12           C  
ATOM    849  N   GLY A 107      43.461  46.049   6.444  1.00 22.72           N  
ATOM    850  CA  GLY A 107      44.495  46.674   7.261  1.00 24.13           C  
ATOM    851  C   GLY A 107      45.638  47.159   6.395  1.00 24.97           C  
ATOM    852  O   GLY A 107      45.972  46.523   5.388  1.00 24.94           O  
ATOM    853  N   PHE A 108      46.215  48.297   6.771  1.00 25.72           N  
ATOM    854  CA  PHE A 108      47.401  48.835   6.102  1.00 27.12           C  
ATOM    855  C   PHE A 108      48.404  49.331   7.132  1.00 28.09           C  
ATOM    856  O   PHE A 108      48.040  50.083   8.045  1.00 27.97           O  
ATOM    857  CB  PHE A 108      47.030  49.970   5.132  1.00 26.85           C  
ATOM    858  CG  PHE A 108      46.310  49.504   3.898  1.00 26.50           C  
ATOM    859  CD1 PHE A 108      47.024  49.132   2.762  1.00 26.75           C  
ATOM    860  CD2 PHE A 108      44.916  49.428   3.874  1.00 25.17           C  
ATOM    861  CE1 PHE A 108      46.362  48.692   1.616  1.00 26.69           C  
ATOM    862  CE2 PHE A 108      44.244  48.984   2.742  1.00 25.75           C  
ATOM    863  CZ  PHE A 108      44.964  48.620   1.608  1.00 26.01           C  
ATOM    864  N   ARG A 109      49.657  48.902   6.983  1.00 29.44           N  
ATOM    865  CA  ARG A 109      50.747  49.304   7.878  1.00 30.99           C  
ATOM    866  C   ARG A 109      51.654  50.324   7.219  1.00 31.51           C  
ATOM    867  O   ARG A 109      52.007  50.182   6.054  1.00 31.52           O  
ATOM    868  CB  ARG A 109      51.595  48.097   8.292  1.00 31.26           C  
ATOM    869  CG  ARG A 109      51.194  47.476   9.604  1.00 33.60           C  
ATOM    870  CD  ARG A 109      52.294  46.586  10.189  1.00 37.76           C  
ATOM    871  NE  ARG A 109      53.373  47.325  10.849  1.00 39.97           N  
ATOM    872  CZ  ARG A 109      54.479  46.761  11.331  1.00 42.02           C  
ATOM    873  NH1 ARG A 109      54.666  45.448  11.224  1.00 42.35           N  
ATOM    874  NH2 ARG A 109      55.408  47.506  11.920  1.00 42.82           N  
ATOM    875  N   PHE A 110      52.020  51.358   7.969  1.00 32.59           N  
ATOM    876  CA  PHE A 110      53.032  52.325   7.523  1.00 33.77           C  
ATOM    877  C   PHE A 110      53.642  53.112   8.681  1.00 34.79           C  
ATOM    878  O   PHE A 110      53.110  53.126   9.792  1.00 34.84           O  
ATOM    879  CB  PHE A 110      52.505  53.273   6.424  1.00 33.35           C  
ATOM    880  CG  PHE A 110      51.152  53.853   6.709  1.00 33.30           C  
ATOM    881  CD1 PHE A 110      49.992  53.189   6.299  1.00 32.96           C  
ATOM    882  CD2 PHE A 110      51.030  55.066   7.375  1.00 32.58           C  
ATOM    883  CE1 PHE A 110      48.728  53.723   6.556  1.00 32.30           C  
ATOM    884  CE2 PHE A 110      49.773  55.609   7.638  1.00 32.94           C  
ATOM    885  CZ  PHE A 110      48.617  54.933   7.222  1.00 32.54           C  
ATOM    886  N   ARG A 111      54.768  53.756   8.392  1.00 36.47           N  
ATOM    887  CA  ARG A 111      55.526  54.525   9.367  1.00 38.17           C  
ATOM    888  C   ARG A 111      55.392  56.007   9.043  1.00 38.91           C  
ATOM    889  O   ARG A 111      55.376  56.393   7.869  1.00 39.14           O  
ATOM    890  CB  ARG A 111      56.992  54.092   9.332  1.00 38.24           C  
ATOM    891  CG  ARG A 111      57.720  54.203  10.659  1.00 40.58           C  
ATOM    892  CD  ARG A 111      58.796  53.124  10.789  1.00 43.70           C  
ATOM    893  NE  ARG A 111      59.930  53.346   9.887  1.00 45.85           N  
ATOM    894  CZ  ARG A 111      60.930  52.486   9.700  1.00 46.93           C  
ATOM    895  NH1 ARG A 111      60.959  51.322  10.347  1.00 46.79           N  
ATOM    896  NH2 ARG A 111      61.906  52.789   8.855  1.00 47.17           N  
ATOM    897  N   VAL A 112      55.264  56.827  10.085  1.00 39.82           N  
ATOM    898  CA  VAL A 112      55.137  58.278   9.933  1.00 40.86           C  
ATOM    899  C   VAL A 112      56.098  59.019  10.862  1.00 41.67           C  
ATOM    900  O   VAL A 112      56.626  58.444  11.825  1.00 41.40           O  
ATOM    901  CB  VAL A 112      53.683  58.796  10.213  1.00 40.83           C  
ATOM    902  CG1 VAL A 112      52.668  58.200   9.234  1.00 41.07           C  
ATOM    903  CG2 VAL A 112      53.265  58.540  11.674  1.00 40.77           C  
ATOM    904  N   SER A 113      56.328  60.293  10.555  1.00 42.83           N  
ATOM    905  CA  SER A 113      56.939  61.215  11.498  1.00 44.05           C  
ATOM    906  C   SER A 113      55.821  61.775  12.368  1.00 44.95           C  
ATOM    907  O   SER A 113      54.917  62.449  11.864  1.00 44.91           O  
ATOM    908  CB  SER A 113      57.666  62.340  10.765  1.00 44.04           C  
ATOM    909  OG  SER A 113      58.133  63.311  11.684  1.00 44.59           O  
ATOM    910  N   GLU A 114      55.877  61.475  13.665  1.00 45.93           N  
ATOM    911  CA  GLU A 114      54.826  61.857  14.614  1.00 47.23           C  
ATOM    912  C   GLU A 114      54.481  63.351  14.595  1.00 47.85           C  
ATOM    913  O   GLU A 114      53.305  63.716  14.611  1.00 47.80           O  
ATOM    914  CB  GLU A 114      55.196  61.418  16.038  1.00 47.04           C  
ATOM    915  CG  GLU A 114      54.158  61.777  17.095  1.00 47.69           C  
ATOM    916  CD  GLU A 114      54.692  61.711  18.518  1.00 47.94           C  
ATOM    917  OE1 GLU A 114      55.488  60.795  18.827  1.00 48.79           O  
ATOM    918  OE2 GLU A 114      54.300  62.580  19.332  1.00 48.88           O  
ATOM    919  N   GLU A 115      55.502  64.207  14.557  1.00 48.94           N  
ATOM    920  CA  GLU A 115      55.278  65.654  14.612  1.00 49.95           C  
ATOM    921  C   GLU A 115      54.654  66.239  13.334  1.00 50.17           C  
ATOM    922  O   GLU A 115      54.210  67.389  13.327  1.00 50.29           O  
ATOM    923  CB  GLU A 115      56.568  66.400  14.989  1.00 50.15           C  
ATOM    924  CG  GLU A 115      56.992  66.259  16.457  1.00 51.42           C  
ATOM    925  CD  GLU A 115      56.080  67.003  17.436  1.00 52.95           C  
ATOM    926  OE1 GLU A 115      54.939  66.540  17.672  1.00 53.29           O  
ATOM    927  OE2 GLU A 115      56.516  68.041  17.984  1.00 53.48           O  
ATOM    928  N   GLU A 116      54.610  65.434  12.273  1.00 50.61           N  
ATOM    929  CA  GLU A 116      54.042  65.840  10.983  1.00 51.17           C  
ATOM    930  C   GLU A 116      52.539  65.595  10.831  1.00 51.40           C  
ATOM    931  O   GLU A 116      51.945  65.987   9.819  1.00 51.39           O  
ATOM    932  CB  GLU A 116      54.756  65.116   9.844  1.00 51.33           C  
ATOM    933  CG  GLU A 116      55.807  65.929   9.137  1.00 52.01           C  
ATOM    934  CD  GLU A 116      56.077  65.397   7.749  1.00 53.12           C  
ATOM    935  OE1 GLU A 116      55.276  65.690   6.827  1.00 53.22           O  
ATOM    936  OE2 GLU A 116      57.091  64.685   7.586  1.00 53.44           O  
ATOM    937  N   LEU A 117      51.931  64.932  11.811  1.00 51.51           N  
ATOM    938  CA  LEU A 117      50.502  64.635  11.749  1.00 51.71           C  
ATOM    939  C   LEU A 117      49.685  65.766  12.367  1.00 51.75           C  
ATOM    940  O   LEU A 117      50.176  66.493  13.229  1.00 51.77           O  
ATOM    941  CB  LEU A 117      50.186  63.304  12.446  1.00 51.70           C  
ATOM    942  CG  LEU A 117      50.927  62.025  12.038  1.00 51.87           C  
ATOM    943  CD1 LEU A 117      50.361  60.839  12.808  1.00 51.91           C  
ATOM    944  CD2 LEU A 117      50.868  61.761  10.533  1.00 51.82           C  
ATOM    945  N   LEU A 118      48.442  65.906  11.918  1.00 51.85           N  
ATOM    946  CA  LEU A 118      47.527  66.907  12.459  1.00 52.02           C  
ATOM    947  C   LEU A 118      46.496  66.278  13.391  1.00 51.95           C  
ATOM    948  O   LEU A 118      45.400  65.910  12.966  1.00 52.06           O  
ATOM    949  CB  LEU A 118      46.828  67.661  11.323  1.00 52.13           C  
ATOM    950  CG  LEU A 118      47.594  68.809  10.668  1.00 52.43           C  
ATOM    951  CD1 LEU A 118      47.218  68.952   9.196  1.00 52.86           C  
ATOM    952  CD2 LEU A 118      47.356  70.114  11.423  1.00 52.58           C  
ATOM    953  N   ASP A 126      40.410  61.336  22.317  1.00 46.17           N  
ATOM    954  CA  ASP A 126      41.821  61.721  22.218  1.00 45.95           C  
ATOM    955  C   ASP A 126      42.720  60.593  21.686  1.00 45.45           C  
ATOM    956  O   ASP A 126      42.234  59.509  21.332  1.00 45.38           O  
ATOM    957  CB  ASP A 126      42.345  62.270  23.553  1.00 46.13           C  
ATOM    958  CG  ASP A 126      41.960  61.407  24.743  1.00 47.27           C  
ATOM    959  OD1 ASP A 126      40.747  61.175  24.960  1.00 48.31           O  
ATOM    960  OD2 ASP A 126      42.876  60.983  25.478  1.00 47.85           O  
ATOM    961  N   TYR A 127      44.022  60.869  21.627  1.00 44.64           N  
ATOM    962  CA  TYR A 127      44.995  59.980  20.993  1.00 44.04           C  
ATOM    963  C   TYR A 127      46.176  59.649  21.906  1.00 43.32           C  
ATOM    964  O   TYR A 127      46.486  60.402  22.830  1.00 43.28           O  
ATOM    965  CB  TYR A 127      45.506  60.600  19.686  1.00 44.27           C  
ATOM    966  CG  TYR A 127      44.449  60.762  18.614  1.00 44.81           C  
ATOM    967  CD1 TYR A 127      43.690  61.930  18.527  1.00 45.08           C  
ATOM    968  CD2 TYR A 127      44.209  59.751  17.686  1.00 45.13           C  
ATOM    969  CE1 TYR A 127      42.718  62.086  17.545  1.00 45.53           C  
ATOM    970  CE2 TYR A 127      43.237  59.896  16.699  1.00 45.57           C  
ATOM    971  CZ  TYR A 127      42.496  61.067  16.634  1.00 45.65           C  
ATOM    972  OH  TYR A 127      41.532  61.223  15.659  1.00 45.65           O  
ATOM    973  N   ARG A 128      46.817  58.513  21.636  1.00 42.40           N  
ATOM    974  CA  ARG A 128      48.023  58.075  22.341  1.00 41.62           C  
ATOM    975  C   ARG A 128      48.923  57.259  21.425  1.00 40.63           C  
ATOM    976  O   ARG A 128      48.438  56.508  20.573  1.00 40.51           O  
ATOM    977  CB  ARG A 128      47.667  57.230  23.567  1.00 41.60           C  
ATOM    978  CG  ARG A 128      47.422  58.027  24.832  1.00 42.27           C  
ATOM    979  CD  ARG A 128      46.926  57.131  25.964  1.00 42.89           C  
ATOM    980  NE  ARG A 128      46.206  57.856  27.021  1.00 45.97           N  
ATOM    981  CZ  ARG A 128      46.585  59.008  27.578  1.00 46.90           C  
ATOM    982  NH1 ARG A 128      47.712  59.617  27.216  1.00 46.76           N  
ATOM    983  NH2 ARG A 128      45.827  59.553  28.522  1.00 47.28           N  
ATOM    984  N   TRP A 129      50.231  57.418  21.605  1.00 39.51           N  
ATOM    985  CA  TRP A 129      51.226  56.581  20.944  1.00 38.55           C  
ATOM    986  C   TRP A 129      51.675  55.488  21.906  1.00 38.10           C  
ATOM    987  O   TRP A 129      52.238  55.782  22.966  1.00 37.96           O  
ATOM    988  CB  TRP A 129      52.426  57.415  20.493  1.00 38.35           C  
ATOM    989  CG  TRP A 129      52.118  58.329  19.352  1.00 38.06           C  
ATOM    990  CD1 TRP A 129      51.737  59.634  19.431  1.00 38.47           C  
ATOM    991  CD2 TRP A 129      52.154  58.006  17.957  1.00 38.12           C  
ATOM    992  NE1 TRP A 129      51.534  60.149  18.175  1.00 38.26           N  
ATOM    993  CE2 TRP A 129      51.783  59.171  17.249  1.00 37.98           C  
ATOM    994  CE3 TRP A 129      52.461  56.843  17.234  1.00 37.84           C  
ATOM    995  CZ2 TRP A 129      51.715  59.211  15.853  1.00 37.67           C  
ATOM    996  CZ3 TRP A 129      52.390  56.883  15.844  1.00 38.15           C  
ATOM    997  CH2 TRP A 129      52.022  58.062  15.169  1.00 38.15           C  
ATOM    998  N   LEU A 130      51.413  54.233  21.543  1.00 37.19           N  
ATOM    999  CA  LEU A 130      51.712  53.099  22.418  1.00 36.70           C  
ATOM   1000  C   LEU A 130      52.556  52.037  21.732  1.00 36.26           C  
ATOM   1001  O   LEU A 130      52.344  51.730  20.564  1.00 36.14           O  
ATOM   1002  CB  LEU A 130      50.420  52.454  22.936  1.00 36.67           C  
ATOM   1003  CG  LEU A 130      49.583  53.137  24.023  1.00 36.94           C  
ATOM   1004  CD1 LEU A 130      48.407  52.242  24.402  1.00 37.45           C  
ATOM   1005  CD2 LEU A 130      50.414  53.458  25.258  1.00 36.74           C  
ATOM   1006  N   THR A 131      53.510  51.471  22.470  1.00 35.71           N  
ATOM   1007  CA  THR A 131      54.257  50.314  21.995  1.00 35.07           C  
ATOM   1008  C   THR A 131      53.281  49.145  21.942  1.00 34.90           C  
ATOM   1009  O   THR A 131      52.240  49.192  22.596  1.00 34.72           O  
ATOM   1010  CB  THR A 131      55.439  49.957  22.929  1.00 35.15           C  
ATOM   1011  OG1 THR A 131      54.940  49.607  24.223  1.00 34.51           O  
ATOM   1012  CG2 THR A 131      56.409  51.123  23.061  1.00 34.73           C  
ATOM   1013  N   SER A 132      53.602  48.112  21.167  1.00 34.71           N  
ATOM   1014  CA  SER A 132      52.739  46.930  21.082  1.00 34.59           C  
ATOM   1015  C   SER A 132      52.586  46.258  22.443  1.00 34.48           C  
ATOM   1016  O   SER A 132      51.508  45.804  22.812  1.00 34.27           O  
ATOM   1017  CB  SER A 132      53.255  45.936  20.041  1.00 34.63           C  
ATOM   1018  OG  SER A 132      54.589  45.559  20.297  1.00 35.20           O  
ATOM   1019  N   ASP A 133      53.674  46.230  23.198  1.00 34.55           N  
ATOM   1020  CA  ASP A 133      53.678  45.648  24.528  1.00 34.55           C  
ATOM   1021  C   ASP A 133      52.728  46.415  25.468  1.00 34.17           C  
ATOM   1022  O   ASP A 133      52.015  45.806  26.269  1.00 34.12           O  
ATOM   1023  CB  ASP A 133      55.119  45.618  25.046  1.00 34.93           C  
ATOM   1024  CG  ASP A 133      56.093  45.011  24.026  1.00 35.76           C  
ATOM   1025  OD1 ASP A 133      56.059  43.773  23.823  1.00 35.85           O  
ATOM   1026  OD2 ASP A 133      56.884  45.775  23.417  1.00 36.59           O  
ATOM   1027  N   ALA A 134      52.699  47.740  25.333  1.00 33.70           N  
ATOM   1028  CA  ALA A 134      51.783  48.588  26.099  1.00 33.70           C  
ATOM   1029  C   ALA A 134      50.322  48.387  25.681  1.00 33.70           C  
ATOM   1030  O   ALA A 134      49.459  48.093  26.517  1.00 33.18           O  
ATOM   1031  CB  ALA A 134      52.169  50.051  25.951  1.00 33.88           C  
ATOM   1032  N   LEU A 135      50.053  48.550  24.383  1.00 33.51           N  
ATOM   1033  CA  LEU A 135      48.694  48.398  23.853  1.00 33.40           C  
ATOM   1034  C   LEU A 135      48.098  47.008  24.133  1.00 33.53           C  
ATOM   1035  O   LEU A 135      46.913  46.890  24.438  1.00 33.45           O  
ATOM   1036  CB  LEU A 135      48.636  48.767  22.363  1.00 33.31           C  
ATOM   1037  CG  LEU A 135      49.124  47.833  21.251  1.00 33.16           C  
ATOM   1038  CD1 LEU A 135      48.033  46.836  20.855  1.00 33.69           C  
ATOM   1039  CD2 LEU A 135      49.534  48.642  20.038  1.00 33.29           C  
ATOM   1040  N   LEU A 136      48.925  45.968  24.055  1.00 33.85           N  
ATOM   1041  CA  LEU A 136      48.461  44.601  24.309  1.00 34.54           C  
ATOM   1042  C   LEU A 136      48.144  44.327  25.782  1.00 35.13           C  
ATOM   1043  O   LEU A 136      47.269  43.517  26.091  1.00 35.38           O  
ATOM   1044  CB  LEU A 136      49.464  43.573  23.781  1.00 34.54           C  
ATOM   1045  CG  LEU A 136      49.670  43.490  22.266  1.00 34.13           C  
ATOM   1046  CD1 LEU A 136      50.886  42.630  21.943  1.00 34.42           C  
ATOM   1047  CD2 LEU A 136      48.434  42.955  21.572  1.00 34.73           C  
ATOM   1048  N   ALA A 137      48.852  45.006  26.683  1.00 35.84           N  
ATOM   1049  CA  ALA A 137      48.618  44.857  28.119  1.00 36.41           C  
ATOM   1050  C   ALA A 137      47.483  45.756  28.613  1.00 36.83           C  
ATOM   1051  O   ALA A 137      47.060  45.652  29.767  1.00 36.89           O  
ATOM   1052  CB  ALA A 137      49.907  45.139  28.900  1.00 36.60           C  
ATOM   1053  N   SER A 138      46.987  46.629  27.736  1.00 37.26           N  
ATOM   1054  CA  SER A 138      45.948  47.587  28.105  1.00 37.55           C  
ATOM   1055  C   SER A 138      44.540  47.002  27.994  1.00 37.74           C  
ATOM   1056  O   SER A 138      44.204  46.330  27.018  1.00 37.74           O  
ATOM   1057  CB  SER A 138      46.064  48.863  27.270  1.00 37.56           C  
ATOM   1058  OG  SER A 138      44.977  49.734  27.523  1.00 37.98           O  
ATOM   1059  N   ASP A 139      43.728  47.272  29.012  1.00 37.73           N  
ATOM   1060  CA  ASP A 139      42.329  46.850  29.035  1.00 37.86           C  
ATOM   1061  C   ASP A 139      41.395  47.839  28.323  1.00 36.89           C  
ATOM   1062  O   ASP A 139      40.214  47.547  28.133  1.00 37.18           O  
ATOM   1063  CB  ASP A 139      41.870  46.605  30.480  1.00 38.30           C  
ATOM   1064  CG  ASP A 139      42.295  45.238  31.009  1.00 40.36           C  
ATOM   1065  OD1 ASP A 139      41.860  44.207  30.436  1.00 42.40           O  
ATOM   1066  OD2 ASP A 139      43.047  45.189  32.009  1.00 43.03           O  
ATOM   1067  N   ASN A 140      41.937  48.991  27.923  1.00 35.96           N  
ATOM   1068  CA  ASN A 140      41.182  50.033  27.221  1.00 34.94           C  
ATOM   1069  C   ASN A 140      41.349  49.975  25.699  1.00 33.67           C  
ATOM   1070  O   ASN A 140      40.539  50.529  24.962  1.00 33.27           O  
ATOM   1071  CB  ASN A 140      41.582  51.422  27.728  1.00 35.39           C  
ATOM   1072  CG  ASN A 140      41.457  51.554  29.233  1.00 37.14           C  
ATOM   1073  OD1 ASN A 140      40.354  51.483  29.790  1.00 39.58           O  
ATOM   1074  ND2 ASN A 140      42.590  51.753  29.906  1.00 37.54           N  
ATOM   1075  N   VAL A 141      42.415  49.319  25.245  1.00 32.27           N  
ATOM   1076  CA  VAL A 141      42.643  49.068  23.820  1.00 30.98           C  
ATOM   1077  C   VAL A 141      41.819  47.841  23.427  1.00 30.00           C  
ATOM   1078  O   VAL A 141      41.981  46.770  24.012  1.00 30.09           O  
ATOM   1079  CB  VAL A 141      44.154  48.864  23.504  1.00 30.75           C  
ATOM   1080  CG1 VAL A 141      44.369  48.455  22.043  1.00 30.28           C  
ATOM   1081  CG2 VAL A 141      44.942  50.136  23.817  1.00 30.56           C  
ATOM   1082  N   HIS A 142      40.933  48.007  22.446  1.00 28.82           N  
ATOM   1083  CA  HIS A 142      39.962  46.966  22.083  1.00 27.04           C  
ATOM   1084  C   HIS A 142      40.629  45.731  21.492  1.00 26.49           C  
ATOM   1085  O   HIS A 142      41.692  45.825  20.890  1.00 26.32           O  
ATOM   1086  CB  HIS A 142      38.928  47.518  21.106  1.00 27.26           C  
ATOM   1087  CG  HIS A 142      37.696  46.673  20.977  1.00 25.41           C  
ATOM   1088  ND1 HIS A 142      37.620  45.589  20.131  1.00 25.04           N  
ATOM   1089  CD2 HIS A 142      36.488  46.761  21.581  1.00 24.92           C  
ATOM   1090  CE1 HIS A 142      36.422  45.040  20.223  1.00 23.49           C  
ATOM   1091  NE2 HIS A 142      35.717  45.732  21.097  1.00 24.71           N  
ATOM   1092  N   ALA A 143      39.990  44.576  21.680  1.00 25.55           N  
ATOM   1093  CA  ALA A 143      40.467  43.299  21.152  1.00 25.16           C  
ATOM   1094  C   ALA A 143      40.685  43.305  19.631  1.00 24.91           C  
ATOM   1095  O   ALA A 143      41.616  42.669  19.136  1.00 24.86           O  
ATOM   1096  CB  ALA A 143      39.505  42.180  21.550  1.00 25.12           C  
ATOM   1097  N   ASN A 144      39.827  44.021  18.896  1.00 24.70           N  
ATOM   1098  CA  ASN A 144      39.958  44.137  17.437  1.00 24.25           C  
ATOM   1099  C   ASN A 144      41.245  44.846  17.020  1.00 24.23           C  
ATOM   1100  O   ASN A 144      41.807  44.567  15.960  1.00 24.08           O  
ATOM   1101  CB  ASN A 144      38.747  44.847  16.823  1.00 24.00           C  
ATOM   1102  CG  ASN A 144      37.440  44.108  17.076  1.00 24.74           C  
ATOM   1103  OD1 ASN A 144      37.430  42.931  17.441  1.00 25.57           O  
ATOM   1104  ND2 ASN A 144      36.330  44.804  16.888  1.00 24.92           N  
ATOM   1105  N   SER A 145      41.700  45.769  17.857  1.00 24.17           N  
ATOM   1106  CA  SER A 145      42.933  46.497  17.587  1.00 24.55           C  
ATOM   1107  C   SER A 145      44.165  45.743  18.081  1.00 24.54           C  
ATOM   1108  O   SER A 145      45.187  45.731  17.400  1.00 24.37           O  
ATOM   1109  CB  SER A 145      42.869  47.910  18.162  1.00 24.68           C  
ATOM   1110  OG  SER A 145      42.252  48.786  17.230  1.00 25.29           O  
ATOM   1111  N   ARG A 146      44.056  45.105  19.247  1.00 24.86           N  
ATOM   1112  CA  ARG A 146      45.138  44.259  19.789  1.00 25.65           C  
ATOM   1113  C   ARG A 146      45.517  43.104  18.848  1.00 25.34           C  
ATOM   1114  O   ARG A 146      46.691  42.737  18.745  1.00 25.49           O  
ATOM   1115  CB  ARG A 146      44.742  43.674  21.147  1.00 25.71           C  
ATOM   1116  CG  ARG A 146      44.549  44.689  22.261  1.00 27.88           C  
ATOM   1117  CD  ARG A 146      44.595  44.008  23.637  1.00 32.17           C  
ATOM   1118  NE  ARG A 146      43.747  42.816  23.717  1.00 34.49           N  
ATOM   1119  CZ  ARG A 146      42.516  42.792  24.228  1.00 37.12           C  
ATOM   1120  NH1 ARG A 146      41.959  43.897  24.715  1.00 37.96           N  
ATOM   1121  NH2 ARG A 146      41.832  41.653  24.256  1.00 39.27           N  
ATOM   1122  N   ALA A 147      44.513  42.552  18.168  1.00 25.01           N  
ATOM   1123  CA  ALA A 147      44.685  41.415  17.254  1.00 25.05           C  
ATOM   1124  C   ALA A 147      45.767  41.638  16.202  1.00 25.05           C  
ATOM   1125  O   ALA A 147      46.480  40.708  15.832  1.00 25.11           O  
ATOM   1126  CB  ALA A 147      43.363  41.057  16.594  1.00 24.60           C  
ATOM   1127  N   TYR A 148      45.904  42.875  15.740  1.00 25.43           N  
ATOM   1128  CA  TYR A 148      46.940  43.226  14.780  1.00 25.89           C  
ATOM   1129  C   TYR A 148      48.354  42.933  15.286  1.00 27.07           C  
ATOM   1130  O   TYR A 148      49.277  42.794  14.495  1.00 27.33           O  
ATOM   1131  CB  TYR A 148      46.823  44.698  14.388  1.00 25.09           C  
ATOM   1132  CG  TYR A 148      45.560  45.030  13.627  1.00 24.21           C  
ATOM   1133  CD1 TYR A 148      45.219  44.336  12.468  1.00 23.34           C  
ATOM   1134  CD2 TYR A 148      44.724  46.052  14.053  1.00 23.90           C  
ATOM   1135  CE1 TYR A 148      44.064  44.645  11.767  1.00 22.79           C  
ATOM   1136  CE2 TYR A 148      43.572  46.373  13.354  1.00 23.08           C  
ATOM   1137  CZ  TYR A 148      43.251  45.660  12.214  1.00 22.23           C  
ATOM   1138  OH  TYR A 148      42.110  45.971  11.528  1.00 22.85           O  
ATOM   1139  N   PHE A 149      48.507  42.810  16.599  1.00 28.82           N  
ATOM   1140  CA  PHE A 149      49.828  42.719  17.224  1.00 30.34           C  
ATOM   1141  C   PHE A 149      50.058  41.381  17.917  1.00 31.94           C  
ATOM   1142  O   PHE A 149      51.080  41.181  18.587  1.00 32.56           O  
ATOM   1143  CB  PHE A 149      50.012  43.881  18.207  1.00 29.64           C  
ATOM   1144  CG  PHE A 149      49.800  45.231  17.587  1.00 29.02           C  
ATOM   1145  CD1 PHE A 149      48.525  45.800  17.537  1.00 27.67           C  
ATOM   1146  CD2 PHE A 149      50.868  45.926  17.027  1.00 28.04           C  
ATOM   1147  CE1 PHE A 149      48.323  47.048  16.954  1.00 27.40           C  
ATOM   1148  CE2 PHE A 149      50.675  47.173  16.442  1.00 28.01           C  
ATOM   1149  CZ  PHE A 149      49.399  47.740  16.408  1.00 27.77           C  
ATOM   1150  N   LEU A 150      49.102  40.471  17.757  1.00 33.68           N  
ATOM   1151  CA  LEU A 150      49.187  39.138  18.339  1.00 35.20           C  
ATOM   1152  C   LEU A 150      49.486  38.105  17.257  1.00 36.47           C  
ATOM   1153  O   LEU A 150      48.866  38.115  16.192  1.00 36.62           O  
ATOM   1154  CB  LEU A 150      47.890  38.793  19.072  1.00 35.11           C  
ATOM   1155  CG  LEU A 150      47.601  39.559  20.369  1.00 35.28           C  
ATOM   1156  CD1 LEU A 150      46.107  39.542  20.707  1.00 35.02           C  
ATOM   1157  CD2 LEU A 150      48.427  39.012  21.536  1.00 35.97           C  
ATOM   1158  N   ALA A 151      50.449  37.228  17.538  1.00 38.08           N  
ATOM   1159  CA  ALA A 151      50.886  36.185  16.599  1.00 39.49           C  
ATOM   1160  C   ALA A 151      49.797  35.150  16.291  1.00 40.45           C  
ATOM   1161  O   ALA A 151      49.630  34.745  15.139  1.00 40.91           O  
ATOM   1162  CB  ALA A 151      52.140  35.500  17.121  1.00 39.48           C  
ATOM   1163  N   GLU A 152      49.060  34.736  17.321  1.00 41.66           N  
ATOM   1164  CA  GLU A 152      47.961  33.769  17.175  1.00 42.67           C  
ATOM   1165  C   GLU A 152      46.867  34.271  16.231  1.00 42.74           C  
ATOM   1166  O   GLU A 152      46.143  33.470  15.630  1.00 42.96           O  
ATOM   1167  CB  GLU A 152      47.356  33.434  18.550  1.00 42.96           C  
ATOM   1168  CG  GLU A 152      46.546  32.125  18.609  1.00 44.67           C  
ATOM   1169  CD  GLU A 152      45.027  32.328  18.619  1.00 46.95           C  
ATOM   1170  OE1 GLU A 152      44.529  33.318  18.039  1.00 47.40           O  
ATOM   1171  OE2 GLU A 152      44.323  31.475  19.206  1.00 47.30           O  
ATOM   1172  N   LYS A 153      46.756  35.593  16.107  1.00 42.87           N  
ATOM   1173  CA  LYS A 153      45.674  36.216  15.345  1.00 42.74           C  
ATOM   1174  C   LYS A 153      46.005  36.416  13.869  1.00 42.74           C  
ATOM   1175  O   LYS A 153      45.101  36.433  13.038  1.00 42.57           O  
ATOM   1176  CB  LYS A 153      45.246  37.548  15.980  1.00 42.84           C  
ATOM   1177  CG  LYS A 153      44.838  37.470  17.455  1.00 42.72           C  
ATOM   1178  CD  LYS A 153      43.632  36.567  17.691  1.00 42.64           C  
ATOM   1179  CE  LYS A 153      43.353  36.415  19.179  1.00 42.45           C  
ATOM   1180  NZ  LYS A 153      42.773  35.083  19.509  1.00 42.48           N  
ATOM   1181  N   ARG A 154      47.290  36.565  13.546  1.00 42.76           N  
ATOM   1182  CA  ARG A 154      47.722  36.755  12.155  1.00 42.94           C  
ATOM   1183  C   ARG A 154      47.639  35.475  11.323  1.00 42.56           C  
ATOM   1184  O   ARG A 154      47.670  35.532  10.088  1.00 42.58           O  
ATOM   1185  CB  ARG A 154      49.135  37.346  12.079  1.00 43.30           C  
ATOM   1186  CG  ARG A 154      49.236  38.798  12.537  1.00 44.70           C  
ATOM   1187  CD  ARG A 154      50.515  39.453  12.037  1.00 46.78           C  
ATOM   1188  NE  ARG A 154      50.864  40.638  12.822  1.00 48.77           N  
ATOM   1189  CZ  ARG A 154      51.712  40.642  13.852  1.00 49.72           C  
ATOM   1190  NH1 ARG A 154      52.317  39.524  14.238  1.00 50.52           N  
ATOM   1191  NH2 ARG A 154      51.962  41.772  14.499  1.00 50.09           N  
ATOM   1192  N   THR A 155      47.542  34.326  11.992  1.00 42.04           N  
ATOM   1193  CA  THR A 155      47.377  33.045  11.299  1.00 41.41           C  
ATOM   1194  C   THR A 155      45.990  32.938  10.677  1.00 40.67           C  
ATOM   1195  O   THR A 155      44.980  33.182  11.339  1.00 40.99           O  
ATOM   1196  CB  THR A 155      47.617  31.827  12.229  1.00 41.61           C  
ATOM   1197  OG1 THR A 155      46.860  31.976  13.440  1.00 42.75           O  
ATOM   1198  CG2 THR A 155      49.096  31.684  12.564  1.00 41.78           C  
ATOM   1199  N   GLY A 156      45.948  32.582   9.398  1.00 39.96           N  
ATOM   1200  CA  GLY A 156      44.685  32.395   8.688  1.00 38.45           C  
ATOM   1201  C   GLY A 156      44.073  33.671   8.135  1.00 37.49           C  
ATOM   1202  O   GLY A 156      43.046  33.622   7.449  1.00 37.68           O  
ATOM   1203  N   VAL A 157      44.686  34.816   8.433  1.00 36.11           N  
ATOM   1204  CA  VAL A 157      44.244  36.086   7.862  1.00 34.63           C  
ATOM   1205  C   VAL A 157      44.641  36.145   6.380  1.00 33.93           C  
ATOM   1206  O   VAL A 157      45.826  36.079   6.058  1.00 33.21           O  
ATOM   1207  CB  VAL A 157      44.816  37.306   8.634  1.00 34.71           C  
ATOM   1208  CG1 VAL A 157      44.479  38.615   7.917  1.00 33.90           C  
ATOM   1209  CG2 VAL A 157      44.287  37.331  10.059  1.00 33.91           C  
ATOM   1210  N   PRO A 158      43.648  36.259   5.476  1.00 33.31           N  
ATOM   1211  CA  PRO A 158      43.966  36.351   4.047  1.00 33.18           C  
ATOM   1212  C   PRO A 158      44.830  37.576   3.746  1.00 33.19           C  
ATOM   1213  O   PRO A 158      44.536  38.663   4.225  1.00 32.59           O  
ATOM   1214  CB  PRO A 158      42.589  36.496   3.383  1.00 32.97           C  
ATOM   1215  CG  PRO A 158      41.610  35.981   4.380  1.00 33.11           C  
ATOM   1216  CD  PRO A 158      42.194  36.310   5.725  1.00 33.35           C  
ATOM   1217  N   GLY A 159      45.896  37.385   2.977  1.00 33.73           N  
ATOM   1218  CA  GLY A 159      46.781  38.489   2.596  1.00 34.51           C  
ATOM   1219  C   GLY A 159      47.947  38.730   3.538  1.00 35.16           C  
ATOM   1220  O   GLY A 159      48.756  39.627   3.308  1.00 35.33           O  
ATOM   1221  N   LEU A 160      48.021  37.944   4.609  1.00 35.72           N  
ATOM   1222  CA  LEU A 160      49.177  37.947   5.505  1.00 36.39           C  
ATOM   1223  C   LEU A 160      49.949  36.634   5.401  1.00 36.77           C  
ATOM   1224  O   LEU A 160      49.425  35.566   5.733  1.00 37.20           O  
ATOM   1225  CB  LEU A 160      48.747  38.180   6.955  1.00 36.49           C  
ATOM   1226  CG  LEU A 160      48.495  39.609   7.431  1.00 36.83           C  
ATOM   1227  CD1 LEU A 160      48.249  39.591   8.930  1.00 36.62           C  
ATOM   1228  CD2 LEU A 160      49.669  40.520   7.105  1.00 36.91           C  
TER    1229      LEU A 160                                                      
END
MOLECULE T0513_1_11_87_283.pdb
ATOM      7  N   MET     1      40.511  38.696  30.932  1.00 34.21           N  
ATOM      8  CA  MET     1      40.458  39.135  29.549  1.00 22.06           C  
ATOM      9  C   MET     1      41.682  38.517  28.896  1.00 20.62           C  
ATOM     10  O   MET     1      42.651  38.176  29.595  1.00 20.32           O  
ATOM     11  CB  MET     1      40.508  40.662  29.493  1.00 26.67           C  
ATOM     12  CG  MET     1      39.316  41.294  30.229  1.00 26.17           C  
ATOM     15  N   SER     2      41.648  38.358  27.573  1.00 18.56           N  
ATOM     16  CA  SER     2      42.745  37.762  26.830  1.00 17.53           C  
ATOM     17  C   SER     2      42.560  38.118  25.378  1.00 19.94           C  
ATOM     18  O   SER     2      41.495  38.598  24.988  1.00 17.05           O  
ATOM     19  CB  SER     2      42.710  36.228  26.946  1.00 17.75           C  
ATOM     20  OG  SER     2      41.480  35.716  26.386  1.00 17.41           O  
ATOM     21  N   PHE     3      43.586  37.860  24.569  1.00 16.42           N  
ATOM     22  CA  PHE     3      43.459  38.022  23.110  1.00 16.19           C  
ATOM     23  C   PHE     3      42.307  37.173  22.593  1.00 21.25           C  
ATOM     24  O   PHE     3      41.461  37.650  21.819  1.00 19.18           O  
ATOM     25  CB  PHE     3      44.739  37.581  22.397  1.00 16.58           C  
ATOM     26  CG  PHE     3      45.941  38.449  22.661  1.00 15.61           C  
ATOM     27  CD1 PHE     3      45.828  39.838  22.823  1.00 13.92           C  
ATOM     28  CD2 PHE     3      47.208  37.862  22.709  1.00 20.52           C  
ATOM     29  CE1 PHE     3      46.981  40.625  23.045  1.00 17.47           C  
ATOM     30  CE2 PHE     3      48.343  38.632  22.922  1.00 19.74           C  
ATOM     31  CZ  PHE     3      48.236  40.011  23.095  1.00 20.60           C  
ATOM     32  N   LEU     4      42.276  35.914  23.034  1.00 17.01           N  
ATOM     33  CA  LEU     4      41.300  34.959  22.547  1.00 17.54           C  
ATOM     34  C   LEU     4      39.864  35.393  22.852  1.00 15.99           C  
ATOM     35  O   LEU     4      38.998  35.315  21.978  1.00 18.48           O  
ATOM     36  CB  LEU     4      41.598  33.535  23.044  1.00 18.74           C  
ATOM     37  CG  LEU     4      40.593  32.443  22.590  1.00 23.52           C  
ATOM     38  CD1 LEU     4      40.527  32.284  21.070  1.00 23.88           C  
ATOM     39  CD2 LEU     4      40.891  31.090  23.260  1.00 23.18           C  
ATOM     40  N   LYS     5      39.637  35.880  24.072  1.00 17.97           N  
ATOM     41  CA  LYS     5      38.295  36.329  24.470  1.00 16.32           C  
ATOM     42  C   LYS     5      37.818  37.464  23.559  1.00 17.11           C  
ATOM     43  O   LYS     5      36.660  37.464  23.200  1.00 17.21           O  
ATOM     44  CB  LYS     5      38.234  36.758  25.934  1.00 25.30           C  
ATOM     45  CG  LYS     5      36.789  36.876  26.476  1.00 32.59           C  
ATOM     46  CD  LYS     5      36.697  37.899  27.624  1.00 46.27           C  
ATOM     47  CE  LYS     5      35.251  38.200  28.091  1.00 40.02           C  
ATOM     48  NZ  LYS     5      34.171  38.126  27.026  1.00 37.12           N  
ATOM     49  N   HIS     6      38.696  38.404  23.186  1.00 16.06           N  
ATOM     50  CA  HIS     6      38.317  39.478  22.227  1.00 19.72           C  
ATOM     51  C   HIS     6      37.859  38.902  20.880  1.00 17.75           C  
ATOM     52  O   HIS     6      36.864  39.336  20.280  1.00 17.62           O  
ATOM     53  CB  HIS     6      39.490  40.435  21.971  1.00 17.88           C  
ATOM     54  CG  HIS     6      39.760  41.393  23.082  1.00 26.05           C  
ATOM     55  ND1 HIS     6      38.778  42.169  23.654  1.00 23.15           N  
ATOM     56  CD2 HIS     6      40.912  41.716  23.719  1.00 20.43           C  
ATOM     57  CE1 HIS     6      39.305  42.917  24.607  1.00 24.59           C  
ATOM     58  NE2 HIS     6      40.601  42.674  24.658  1.00 23.21           N  
ATOM     59  N   VAL     7      38.607  37.911  20.395  1.00 19.93           N  
ATOM     60  CA  VAL     7      38.322  37.270  19.129  1.00 15.58           C  
ATOM     61  C   VAL     7      36.992  36.526  19.218  1.00 20.03           C  
ATOM     62  O   VAL     7      36.166  36.642  18.319  1.00 17.61           O  
ATOM     63  CB  VAL     7      39.521  36.349  18.692  1.00 18.90           C  
ATOM     64  CG1 VAL     7      39.154  35.465  17.528  1.00 22.87           C  
ATOM     65  CG2 VAL     7      40.777  37.213  18.386  1.00 17.72           C  
ATOM     66  N   GLN     8      36.777  35.822  20.329  1.00 18.18           N  
ATOM     67  CA  GLN     8      35.531  35.100  20.579  1.00 15.33           C  
ATOM     68  C   GLN     8      34.323  36.036  20.681  1.00 17.02           C  
ATOM     69  O   GLN     8      33.252  35.717  20.142  1.00 23.55           O  
ATOM     70  CB  GLN     8      35.662  34.259  21.842  1.00 20.01           C  
ATOM     71  CG  GLN     8      36.479  32.991  21.588  1.00 19.14           C  
ATOM     72  CD  GLN     8      36.808  32.235  22.869  1.00 26.74           C  
ATOM     73  OE1 GLN     8      36.820  32.801  23.960  1.00 25.57           O  
ATOM     74  NE2 GLN     8      37.099  30.951  22.729  1.00 29.56           N  
ATOM     75  N   ASP     9      34.514  37.181  21.363  1.00 16.26           N  
ATOM     76  CA  ASP     9      33.480  38.214  21.515  1.00 17.99           C  
ATOM     77  C   ASP     9      33.012  38.673  20.127  1.00 17.79           C  
ATOM     78  O   ASP     9      31.805  38.752  19.866  1.00 15.63           O  
ATOM     79  CB  ASP     9      34.018  39.459  22.245  1.00 20.20           C  
ATOM     80  CG  ASP     9      34.205  39.262  23.755  1.00 21.46           C  
ATOM     81  OD1 ASP     9      33.680  38.295  24.334  1.00 22.14           O  
ATOM     82  OD2 ASP     9      34.896  40.116  24.337  1.00 25.62           O  
ATOM     83  N   CYS    10      33.972  38.942  19.230  1.00 13.03           N  
ATOM     84  CA  CYS    10      33.660  39.396  17.882  1.00 17.68           C  
ATOM     85  C   CYS    10      33.082  38.342  16.932  1.00 17.69           C  
ATOM     86  O   CYS    10      32.679  38.677  15.815  1.00 18.01           O  
ATOM     87  CB  CYS    10      34.881  40.047  17.257  1.00 20.69           C  
ATOM     88  SG  CYS    10      35.334  41.640  18.054  1.00 22.02           S  
ATOM     89  N   ASN    11      33.044  37.089  17.377  1.00 16.85           N  
ATOM     90  CA  ASN    11      32.489  36.005  16.585  1.00 16.00           C  
ATOM     91  C   ASN    11      31.330  35.320  17.254  1.00 21.69           C  
ATOM     92  O   ASN    11      30.958  34.203  16.885  1.00 21.64           O  
ATOM     93  CB  ASN    11      33.593  35.035  16.168  1.00 18.19           C  
ATOM     94  CG  ASN    11      34.453  35.616  15.082  1.00 21.69           C  
ATOM     95  OD1 ASN    11      33.977  35.828  13.968  1.00 20.16           O  
ATOM     96  ND2 ASN    11      35.712  35.932  15.408  1.00 25.35           N  
ATOM    704  N   GLY    87      22.335  58.715   5.514  1.00 25.39           N  
ATOM    705  CA  GLY    87      22.831  59.252   4.250  1.00 24.83           C  
ATOM    706  C   GLY    87      24.088  58.667   3.650  1.00 25.87           C  
ATOM    707  O   GLY    87      24.394  58.938   2.496  1.00 27.78           O  
ATOM    708  N   GLU    88      24.826  57.861   4.409  1.00 22.13           N  
ATOM    709  CA  GLU    88      25.998  57.160   3.861  1.00 22.36           C  
ATOM    710  C   GLU    88      25.582  55.816   3.295  1.00 23.51           C  
ATOM    711  O   GLU    88      25.054  54.989   4.020  1.00 19.80           O  
ATOM    712  CB  GLU    88      27.074  56.962   4.933  1.00 21.74           C  
ATOM    713  CG  GLU    88      28.275  56.190   4.365  1.00 22.96           C  
ATOM    714  CD  GLU    88      29.489  56.189   5.269  1.00 29.30           C  
ATOM    715  OE1 GLU    88      29.367  56.503   6.472  1.00 33.52           O  
ATOM    716  OE2 GLU    88      30.570  55.860   4.759  1.00 24.96           O  
ATOM    717  N   LEU    89      25.810  55.583   2.004  1.00 20.88           N  
ATOM    718  CA  LEU    89      25.365  54.333   1.387  1.00 21.09           C  
ATOM    719  C   LEU    89      26.512  53.320   1.330  1.00 18.78           C  
ATOM    720  O   LEU    89      27.654  53.675   1.020  1.00 23.48           O  
ATOM    721  CB  LEU    89      24.801  54.587  -0.030  1.00 24.83           C  
ATOM    722  CG  LEU    89      23.590  55.510  -0.163  1.00 24.17           C  
ATOM    723  CD1 LEU    89      23.159  55.634  -1.627  1.00 26.09           C  
ATOM    724  CD2 LEU    89      22.440  55.047   0.719  1.00 26.85           C  
ATOM    725  N   TYR    90      26.193  52.062   1.617  1.00 16.23           N  
ATOM    726  CA  TYR    90      27.161  50.972   1.554  1.00 16.87           C  
ATOM    727  C   TYR    90      26.790  50.018   0.421  1.00 21.89           C  
ATOM    728  O   TYR    90      25.612  49.841   0.095  1.00 21.37           O  
ATOM    729  CB  TYR    90      27.108  50.166   2.857  1.00 19.18           C  
ATOM    730  CG  TYR    90      27.980  50.636   4.014  1.00 19.39           C  
ATOM    731  CD1 TYR    90      28.586  51.896   4.022  1.00 22.76           C  
ATOM    732  CD2 TYR    90      28.157  49.810   5.129  1.00 17.63           C  
ATOM    733  CE1 TYR    90      29.384  52.298   5.104  1.00 23.15           C  
ATOM    734  CE2 TYR    90      28.930  50.204   6.222  1.00 16.30           C  
ATOM    735  CZ  TYR    90      29.555  51.449   6.190  1.00 20.05           C  
ATOM    736  OH  TYR    90      30.322  51.863   7.267  1.00 20.00           O  
ATOM    737  N   ARG    91      27.794  49.363  -0.136  1.00 20.63           N  
ATOM    738  CA  ARG    91      27.555  48.370  -1.175  1.00 19.85           C  
ATOM    739  C   ARG    91      27.051  47.062  -0.576  1.00 20.29           C  
ATOM    740  O   ARG    91      27.473  46.654   0.518  1.00 19.32           O  
ATOM    741  CB  ARG    91      28.840  48.157  -2.011  1.00 19.59           C  
ATOM    742  CG  ARG    91      29.881  47.303  -1.337  1.00 26.33           C  
ATOM    743  CD  ARG    91      31.225  47.506  -1.966  1.00 24.05           C  
ATOM    744  NE  ARG    91      31.794  48.821  -1.681  1.00 21.42           N  
ATOM    745  CZ  ARG    91      32.772  49.356  -2.401  1.00 28.61           C  
ATOM    746  NH1 ARG    91      33.284  48.673  -3.417  1.00 23.53           N  
ATOM    747  NH2 ARG    91      33.260  50.541  -2.095  1.00 22.18           N  
ATOM    748  N   VAL    92      26.123  46.418  -1.279  1.00 18.57           N  
ATOM    749  CA  VAL    92      25.629  45.105  -0.875  1.00 16.93           C  
ATOM    750  C   VAL    92      26.147  44.058  -1.867  1.00 21.31           C  
ATOM    751  O   VAL    92      25.839  44.127  -3.082  1.00 19.91           O  
ATOM    752  CB  VAL    92      24.077  45.066  -0.843  1.00 19.63           C  
ATOM    753  CG1 VAL    92      23.561  43.626  -0.553  1.00 18.79           C  
ATOM    754  CG2 VAL    92      23.540  46.091   0.161  1.00 19.26           C  
ATOM    755  N   ASN    93      26.930  43.104  -1.352  1.00 18.20           N  
ATOM    756  CA  ASN    93      27.505  42.038  -2.178  1.00 21.74           C  
ATOM    757  C   ASN    93      27.698  40.762  -1.358  1.00 24.96           C  
ATOM    758  O   ASN    93      27.499  40.746  -0.136  1.00 22.57           O  
ATOM    759  CB  ASN    93      28.859  42.491  -2.788  1.00 18.95           C  
ATOM    760  CG  ASN    93      29.874  42.903  -1.719  1.00 18.59           C  
ATOM    761  OD1 ASN    93      29.937  42.301  -0.661  1.00 24.48           O  
ATOM    762  ND2 ASN    93      30.678  43.942  -2.005  1.00 22.24           N  
ATOM    763  N   GLN    94      28.152  39.704  -2.018  1.00 26.36           N  
ATOM    764  CA  GLN    94      28.433  38.446  -1.340  1.00 26.49           C  
ATOM    765  C   GLN    94      29.823  38.381  -0.751  1.00 30.49           C  
ATOM    766  O   GLN    94      30.080  37.583   0.146  1.00 36.86           O  
ATOM    767  CB  GLN    94      28.266  37.286  -2.304  1.00 37.10           C  
ATOM    768  CG  GLN    94      26.932  36.636  -2.224  1.00 37.93           C  
ATOM    769  CD  GLN    94      26.869  35.435  -3.124  1.00 49.22           C  
ATOM    770  OE1 GLN    94      27.271  35.502  -4.289  1.00 48.89           O  
ATOM    771  NE2 GLN    94      26.362  34.325  -2.598  1.00 50.15           N  
ATOM    772  N   SER    95      30.722  39.175  -1.320  1.00 27.55           N  
ATOM    773  CA  SER    95      32.069  39.392  -0.824  1.00 28.80           C  
ATOM    774  C   SER    95      32.682  40.521  -1.622  1.00 22.53           C  
ATOM    775  O   SER    95      32.128  40.970  -2.634  1.00 27.82           O  
ATOM    776  CB  SER    95      32.951  38.132  -0.907  1.00 35.68           C  
ATOM    777  OG  SER    95      32.898  37.568  -2.200  1.00 45.01           O  
ATOM    778  N   TRP    96      33.826  40.973  -1.150  1.00 24.95           N  
ATOM    779  CA  TRP    96      34.436  42.202  -1.609  1.00 25.45           C  
ATOM    780  C   TRP    96      34.681  42.248  -3.134  1.00 31.67           C  
ATOM    781  O   TRP    96      34.439  43.261  -3.783  1.00 27.35           O  
ATOM    782  CB  TRP    96      35.741  42.422  -0.848  1.00 22.30           C  
ATOM    783  CG  TRP    96      36.462  43.612  -1.369  1.00 24.98           C  
ATOM    784  CD1 TRP    96      37.632  43.618  -2.096  1.00 26.49           C  
ATOM    785  CD2 TRP    96      36.055  44.983  -1.250  1.00 26.86           C  
ATOM    786  NE1 TRP    96      37.962  44.903  -2.437  1.00 27.97           N  
ATOM    787  CE2 TRP    96      37.019  45.764  -1.932  1.00 21.43           C  
ATOM    788  CE3 TRP    96      34.974  45.630  -0.629  1.00 26.25           C  
ATOM    789  CZ2 TRP    96      36.931  47.158  -2.015  1.00 27.21           C  
ATOM    790  CZ3 TRP    96      34.891  47.010  -0.708  1.00 24.31           C  
ATOM    791  CH2 TRP    96      35.870  47.765  -1.392  1.00 26.46           C  
ATOM    792  N   GLY    97      35.167  41.155  -3.704  1.00 34.73           N  
ATOM    793  CA  GLY    97      35.381  41.134  -5.170  1.00 43.04           C  
ATOM    794  C   GLY    97      34.138  41.139  -6.057  1.00 39.97           C  
ATOM    795  O   GLY    97      34.185  41.591  -7.209  1.00 39.72           O  
ATOM    796  N   GLU    98      33.033  40.651  -5.503  1.00 32.97           N  
ATOM    797  CA  GLU    98      31.804  40.317  -6.230  1.00 27.55           C  
ATOM    798  C   GLU    98      31.010  41.563  -6.666  1.00 28.91           C  
ATOM    799  O   GLU    98      31.254  42.659  -6.156  1.00 28.40           O  
ATOM    800  CB  GLU    98      30.957  39.401  -5.344  1.00 31.83           C  
ATOM    801  CG  GLU    98      31.496  37.987  -5.178  1.00 44.11           C  
ATOM    802  CD  GLU    98      31.337  37.164  -6.427  1.00 58.39           C  
ATOM    803  OE1 GLU    98      32.363  36.906  -7.087  1.00 64.85           O  
ATOM    804  OE2 GLU    98      30.189  36.793  -6.761  1.00 62.34           O  
ATOM    805  N   PRO    99      30.088  41.417  -7.650  1.00 29.23           N  
ATOM    806  CA  PRO    99      29.327  42.602  -8.113  1.00 31.34           C  
ATOM    807  C   PRO    99      28.456  43.270  -7.032  1.00 22.94           C  
ATOM    808  O   PRO    99      27.910  42.597  -6.172  1.00 22.94           O  
ATOM    809  CB  PRO    99      28.421  42.028  -9.225  1.00 30.62           C  
ATOM    810  CG  PRO    99      29.121  40.763  -9.672  1.00 34.18           C  
ATOM    811  CD  PRO    99      29.736  40.207  -8.431  1.00 34.24           C  
ATOM    812  N   THR   100      28.385  44.577  -7.048  1.00 21.61           N  
ATOM    813  CA  THR   100      27.472  45.266  -6.184  1.00 22.07           C  
ATOM    814  C   THR   100      26.055  45.017  -6.668  1.00 23.86           C  
ATOM    815  O   THR   100      25.724  45.353  -7.758  1.00 27.37           O  
ATOM    816  CB  THR   100      27.794  46.753  -6.127  1.00 25.42           C  
ATOM    817  OG1 THR   100      29.070  46.950  -5.547  1.00 25.25           O  
ATOM    818  CG2 THR   100      26.768  47.493  -5.390  1.00 21.58           C  
ATOM    819  N   LEU   101      25.252  44.413  -5.827  1.00 22.26           N  
ATOM    820  CA  LEU   101      23.902  44.054  -6.147  1.00 22.54           C  
ATOM    821  C   LEU   101      22.868  45.162  -5.909  1.00 26.84           C  
ATOM    822  O   LEU   101      21.835  45.169  -6.511  1.00 22.64           O  
ATOM    823  CB  LEU   101      23.512  42.785  -5.421  1.00 23.42           C  
ATOM    824  CG  LEU   101      24.336  41.556  -5.780  1.00 23.60           C  
ATOM    825  CD1 LEU   101      24.021  40.422  -4.914  1.00 24.49           C  
ATOM    826  CD2 LEU   101      24.104  41.185  -7.208  1.00 23.72           C  
ATOM    827  N   MET   102      23.182  46.045  -4.985  1.00 22.55           N  
ATOM    828  CA  MET   102      22.371  47.178  -4.624  1.00 21.19           C  
ATOM    829  C   MET   102      23.150  47.968  -3.581  1.00 23.28           C  
ATOM    830  O   MET   102      24.171  47.532  -3.145  1.00 19.55           O  
ATOM    831  CB  MET   102      21.053  46.709  -4.017  1.00 19.31           C  
ATOM    832  CG  MET   102      21.164  45.928  -2.733  1.00 21.18           C  
ATOM    833  SD  MET   102      19.405  45.525  -1.916  0.70 23.50          SE  
ATOM    834  CE  MET   102      19.035  47.338  -1.459  1.00 18.91           C  
ATOM    835  N   LEU   103      22.596  49.100  -3.191  1.00 18.82           N  
ATOM    836  CA  LEU   103      23.106  49.922  -2.110  1.00 19.48           C  
ATOM    837  C   LEU   103      22.134  50.000  -0.941  1.00 20.90           C  
ATOM    838  O   LEU   103      20.948  49.907  -1.109  1.00 20.47           O  
ATOM    839  CB  LEU   103      23.457  51.333  -2.574  1.00 19.25           C  
ATOM    840  CG  LEU   103      24.264  51.497  -3.846  1.00 25.37           C  
ATOM    841  CD1 LEU   103      24.555  52.930  -4.178  1.00 22.48           C  
ATOM    842  CD2 LEU   103      25.523  50.763  -3.726  1.00 16.64           C  
ATOM    843  N   LEU   104      22.687  50.192   0.242  1.00 19.74           N  
ATOM    844  CA  LEU   104      21.923  50.226   1.458  1.00 21.14           C  
ATOM    845  C   LEU   104      22.505  51.224   2.435  1.00 24.21           C  
ATOM    846  O   LEU   104      23.680  51.307   2.604  1.00 20.89           O  
ATOM    847  CB  LEU   104      21.901  48.860   2.084  1.00 23.77           C  
ATOM    848  CG  LEU   104      20.943  48.484   3.187  1.00 22.11           C  
ATOM    849  CD1 LEU   104      19.549  48.698   2.787  1.00 21.93           C  
ATOM    850  CD2 LEU   104      21.194  47.061   3.593  1.00 18.00           C  
ATOM    851  N   ASP   105      21.646  52.004   3.040  1.00 23.13           N  
ATOM    852  CA  ASP   105      22.136  52.996   3.987  1.00 19.41           C  
ATOM    853  C   ASP   105      22.867  52.277   5.131  1.00 15.14           C  
ATOM    854  O   ASP   105      22.375  51.291   5.654  1.00 18.33           O  
ATOM    855  CB  ASP   105      20.977  53.801   4.552  1.00 20.99           C  
ATOM    856  CG  ASP   105      21.447  55.029   5.285  1.00 20.36           C  
ATOM    857  OD1 ASP   105      21.842  54.928   6.470  1.00 21.30           O  
ATOM    858  OD2 ASP   105      21.476  56.107   4.673  1.00 21.56           O  
ATOM    859  N   ARG   106      24.040  52.796   5.477  1.00 21.02           N  
ATOM    860  CA  ARG   106      24.899  52.258   6.546  1.00 18.68           C  
ATOM    861  C   ARG   106      24.099  51.988   7.824  1.00 22.99           C  
ATOM    862  O   ARG   106      24.278  50.952   8.482  1.00 19.07           O  
ATOM    863  CB  ARG   106      26.026  53.245   6.801  1.00 20.67           C  
ATOM    864  CG  ARG   106      26.860  52.965   8.042  1.00 26.03           C  
ATOM    865  CD  ARG   106      27.944  54.002   8.188  1.00 21.79           C  
ATOM    866  NE  ARG   106      28.772  53.685   9.350  1.00 28.51           N  
ATOM    867  CZ  ARG   106      29.995  54.161   9.567  1.00 36.58           C  
ATOM    868  NH1 ARG   106      30.556  55.013   8.713  1.00 24.41           N  
ATOM    869  NH2 ARG   106      30.663  53.784  10.651  1.00 37.44           N  
ATOM    870  N   ALA   107      23.138  52.862   8.127  1.00 16.60           N  
ATOM    871  CA  ALA   107      22.420  52.758   9.398  1.00 22.69           C  
ATOM    872  C   ALA   107      21.586  51.489   9.530  1.00 19.03           C  
ATOM    873  O   ALA   107      21.297  51.057  10.637  1.00 21.36           O  
ATOM    874  CB  ALA   107      21.549  53.986   9.636  1.00 23.29           C  
ATOM    875  N   VAL   108      21.235  50.881   8.402  1.00 17.20           N  
ATOM    876  CA  VAL   108      20.418  49.676   8.404  1.00 17.43           C  
ATOM    877  C   VAL   108      21.193  48.455   7.914  1.00 21.77           C  
ATOM    878  O   VAL   108      20.631  47.379   7.750  1.00 19.19           O  
ATOM    879  CB  VAL   108      19.055  49.853   7.627  1.00 21.96           C  
ATOM    880  CG1 VAL   108      18.186  50.936   8.289  1.00 20.29           C  
ATOM    881  CG2 VAL   108      19.268  50.173   6.131  1.00 19.03           C  
ATOM    882  N   VAL   109      22.492  48.618   7.699  1.00 19.07           N  
ATOM    883  CA  VAL   109      23.306  47.473   7.234  1.00 17.15           C  
ATOM    884  C   VAL   109      23.208  46.292   8.255  1.00 15.02           C  
ATOM    885  O   VAL   109      22.810  45.158   7.867  1.00 17.93           O  
ATOM    886  CB  VAL   109      24.732  47.951   6.781  1.00 19.33           C  
ATOM    887  CG1 VAL   109      25.788  46.856   6.910  1.00 17.69           C  
ATOM    888  CG2 VAL   109      24.659  48.517   5.317  1.00 18.99           C  
ATOM    889  N   PRO   110      23.436  46.541   9.582  1.00 17.55           N  
ATOM    890  CA  PRO   110      23.209  45.433  10.540  1.00 18.17           C  
ATOM    891  C   PRO   110      21.767  44.902  10.631  1.00 17.33           C  
ATOM    892  O   PRO   110      21.566  43.727  10.878  1.00 18.00           O  
ATOM    893  CB  PRO   110      23.693  46.011  11.877  1.00 18.05           C  
ATOM    894  CG  PRO   110      24.670  47.112  11.485  1.00 20.81           C  
ATOM    895  CD  PRO   110      23.988  47.725  10.264  1.00 16.19           C  
ATOM    896  N   THR   111      20.779  45.761  10.386  1.00 17.33           N  
ATOM    897  CA  THR   111      19.362  45.360  10.360  1.00 18.97           C  
ATOM    898  C   THR   111      19.067  44.300   9.285  1.00 19.99           C  
ATOM    899  O   THR   111      18.183  43.453   9.462  1.00 20.53           O  
ATOM    900  CB  THR   111      18.509  46.609  10.107  1.00 21.00           C  
ATOM    901  OG1 THR   111      18.776  47.555  11.154  1.00 23.41           O  
ATOM    902  CG2 THR   111      17.008  46.263  10.007  1.00 17.86           C  
ATOM    903  N   PHE   112      19.787  44.369   8.160  1.00 16.89           N  
ATOM    904  CA  PHE   112      19.636  43.371   7.109  1.00 17.37           C  
ATOM    905  C   PHE   112      20.737  42.314   7.152  1.00 18.91           C  
ATOM    906  O   PHE   112      20.770  41.443   6.284  1.00 19.04           O  
ATOM    907  CB  PHE   112      19.554  44.029   5.725  1.00 21.08           C  
ATOM    908  CG  PHE   112      18.251  44.732   5.507  1.00 21.38           C  
ATOM    909  CD1 PHE   112      17.161  44.054   4.924  1.00 21.83           C  
ATOM    910  CD2 PHE   112      18.069  46.030   5.976  1.00 21.21           C  
ATOM    911  CE1 PHE   112      15.922  44.701   4.770  1.00 23.45           C  
ATOM    912  CE2 PHE   112      16.824  46.676   5.822  1.00 26.65           C  
ATOM    913  CZ  PHE   112      15.772  46.010   5.224  1.00 23.26           C  
ATOM    914  N   GLY   113      21.619  42.408   8.160  1.00 17.00           N  
ATOM    915  CA  GLY   113      22.760  41.450   8.343  1.00 19.86           C  
ATOM    916  C   GLY   113      23.708  41.372   7.156  1.00 19.08           C  
ATOM    917  O   GLY   113      24.320  40.316   6.875  1.00 17.65           O  
ATOM    918  N   VAL   114      23.822  42.488   6.453  1.00 16.66           N  
ATOM    919  CA  VAL   114      24.617  42.622   5.241  1.00 20.98           C  
ATOM    920  C   VAL   114      26.109  42.813   5.587  1.00 14.90           C  
ATOM    921  O   VAL   114      26.453  43.461   6.583  1.00 17.95           O  
ATOM    922  CB  VAL   114      24.061  43.812   4.391  1.00 22.54           C  
ATOM    923  CG1 VAL   114      25.108  44.402   3.471  1.00 26.90           C  
ATOM    924  CG2 VAL   114      22.800  43.348   3.641  1.00 20.80           C  
ATOM    925  N   ARG   115      26.992  42.207   4.798  1.00 18.90           N  
ATOM    926  CA  ARG   115      28.424  42.369   5.025  0.50 18.89           C  
ATOM    928  C   ARG   115      28.865  43.824   4.888  1.00 20.95           C  
ATOM    929  O   ARG   115      28.477  44.509   3.934  1.00 21.03           O  
ATOM    930  CB  ARG   115      29.202  41.456   4.089  0.50 25.76           C  
ATOM    932  CG  ARG   115      28.836  39.990   4.312  0.50 30.32           C  
ATOM    934  CD  ARG   115      29.435  39.054   3.279  0.50 39.53           C  
ATOM    936  NE  ARG   115      30.793  39.438   2.908  0.50 40.24           N  
ATOM    938  CZ  ARG   115      31.874  39.233   3.650  0.50 35.64           C  
ATOM    940  NH1 ARG   115      33.037  39.641   3.194  0.50 37.10           N  
ATOM    942  NH2 ARG   115      31.801  38.652   4.846  0.50 44.23           N  
ATOM    944  N   ALA   116      29.631  44.298   5.874  1.00 15.80           N  
ATOM    945  CA  ALA   116      30.150  45.685   5.878  1.00 23.26           C  
ATOM    946  C   ALA   116      31.663  45.682   5.736  1.00 22.47           C  
ATOM    947  O   ALA   116      32.346  44.741   6.166  1.00 22.50           O  
ATOM    948  CB  ALA   116      29.767  46.415   7.151  1.00 18.37           C  
ATOM    949  N   TYR   117      32.186  46.762   5.178  1.00 16.80           N  
ATOM    950  CA  TYR   117      33.643  46.870   4.922  1.00 16.57           C  
ATOM    951  C   TYR   117      34.160  48.128   5.558  1.00 19.40           C  
ATOM    952  O   TYR   117      33.404  49.096   5.756  1.00 17.01           O  
ATOM    953  CB  TYR   117      33.920  46.873   3.397  1.00 17.31           C  
ATOM    954  CG  TYR   117      33.361  45.617   2.746  1.00 19.59           C  
ATOM    955  CD1 TYR   117      34.018  44.399   2.876  1.00 20.47           C  
ATOM    956  CD2 TYR   117      32.124  45.637   2.084  1.00 20.52           C  
ATOM    957  CE1 TYR   117      33.501  43.243   2.328  1.00 17.56           C  
ATOM    958  CE2 TYR   117      31.601  44.488   1.515  1.00 22.34           C  
ATOM    959  CZ  TYR   117      32.279  43.295   1.653  1.00 22.06           C  
ATOM    960  OH  TYR   117      31.744  42.169   1.124  1.00 21.87           O  
ATOM    961  N   GLY   118      35.448  48.143   5.874  1.00 19.03           N  
ATOM    962  CA  GLY   118      36.030  49.316   6.478  1.00 19.24           C  
ATOM    963  C   GLY   118      37.527  49.267   6.295  1.00 16.72           C  
ATOM    964  O   GLY   118      38.090  48.234   5.913  1.00 20.13           O  
ATOM    965  N   VAL   119      38.164  50.403   6.517  1.00 16.32           N  
ATOM    966  CA  VAL   119      39.604  50.494   6.412  1.00 15.00           C  
ATOM    967  C   VAL   119      40.169  50.936   7.753  1.00 22.40           C  
ATOM    968  O   VAL   119      39.583  51.799   8.435  1.00 22.82           O  
ATOM    969  CB  VAL   119      40.100  51.440   5.249  1.00 22.27           C  
ATOM    970  CG1 VAL   119      39.592  50.948   3.891  1.00 19.88           C  
ATOM    971  CG2 VAL   119      39.690  52.898   5.489  1.00 22.21           C  
ATOM    972  N   HIS   120      41.285  50.311   8.137  1.00 18.08           N  
ATOM    973  CA  HIS   120      41.968  50.589   9.417  1.00 19.70           C  
ATOM    974  C   HIS   120      43.453  50.730   9.187  1.00 21.42           C  
ATOM    975  O   HIS   120      44.094  49.860   8.570  1.00 20.16           O  
ATOM    976  CB  HIS   120      41.709  49.468  10.444  1.00 18.67           C  
ATOM    977  CG  HIS   120      40.288  49.423  10.918  1.00 20.33           C  
ATOM    978  ND1 HIS   120      39.921  49.778  12.195  1.00 18.82           N  
ATOM    979  CD2 HIS   120      39.142  49.097  10.276  1.00 22.07           C  
ATOM    980  CE1 HIS   120      38.609  49.662  12.326  1.00 20.40           C  
ATOM    981  NE2 HIS   120      38.114  49.271  11.167  1.00 21.07           N  
ATOM    982  N   LEU   121      43.992  51.845   9.667  1.00 17.73           N  
ATOM    983  CA  LEU   121      45.391  52.168   9.486  1.00 19.07           C  
ATOM    984  C   LEU   121      46.194  52.043  10.780  1.00 17.80           C  
ATOM    985  O   LEU   121      45.801  52.603  11.817  1.00 19.58           O  
ATOM    986  CB  LEU   121      45.541  53.594   8.939  1.00 16.96           C  
ATOM    987  CG  LEU   121      46.996  54.056   8.719  1.00 19.89           C  
ATOM    988  CD1 LEU   121      47.636  53.390   7.537  1.00 22.06           C  
ATOM    989  CD2 LEU   121      47.033  55.582   8.509  1.00 22.75           C  
ATOM    990  N   ASN   122      47.303  51.298  10.705  1.00 19.55           N  
ATOM    991  CA  ASN   122      48.301  51.221  11.781  1.00 21.15           C  
ATOM    992  C   ASN   122      49.405  52.240  11.517  1.00 19.94           C  
ATOM    993  O   ASN   122      50.271  52.018  10.667  1.00 21.83           O  
ATOM    994  CB  ASN   122      48.888  49.806  11.905  1.00 17.68           C  
ATOM    995  CG  ASN   122      47.824  48.744  12.154  1.00 26.32           C  
ATOM    996  OD1 ASN   122      47.116  48.776  13.163  1.00 22.92           O  
ATOM    997  ND2 ASN   122      47.707  47.804  11.238  1.00 18.70           N  
ATOM    998  N   GLY   123      49.334  53.381  12.208  1.00 20.19           N  
ATOM    999  CA  GLY   123      50.345  54.440  12.079  1.00 18.15           C  
ATOM   1000  C   GLY   123      51.381  54.310  13.171  1.00 21.64           C  
ATOM   1001  O   GLY   123      51.065  54.442  14.366  1.00 22.55           O  
ATOM   1002  N   TYR   124      52.620  54.067  12.763  1.00 22.90           N  
ATOM   1003  CA  TYR   124      53.694  53.774  13.698  1.00 25.90           C  
ATOM   1004  C   TYR   124      55.020  54.490  13.366  1.00 25.41           C  
ATOM   1005  O   TYR   124      55.209  54.987  12.233  1.00 23.58           O  
ATOM   1006  CB  TYR   124      53.884  52.237  13.832  1.00 21.31           C  
ATOM   1007  CG  TYR   124      54.369  51.536  12.592  1.00 27.55           C  
ATOM   1008  CD1 TYR   124      55.728  51.400  12.332  1.00 30.72           C  
ATOM   1009  CD2 TYR   124      53.469  50.982  11.680  1.00 27.78           C  
ATOM   1010  CE1 TYR   124      56.182  50.760  11.192  1.00 31.47           C  
ATOM   1011  CE2 TYR   124      53.919  50.339  10.543  1.00 30.81           C  
ATOM   1012  CZ  TYR   124      55.265  50.228  10.304  1.00 31.70           C  
ATOM   1013  OH  TYR   124      55.719  49.579   9.177  1.00 42.11           O  
ATOM   1014  N   VAL   125      55.895  54.566  14.384  1.00 29.81           N  
ATOM   1015  CA  VAL   125      57.235  55.137  14.244  0.50 32.58           C  
ATOM   1017  C   VAL   125      58.246  54.234  14.931  1.00 34.47           C  
ATOM   1018  O   VAL   125      57.929  53.543  15.901  1.00 36.28           O  
ATOM   1019  CB  VAL   125      57.365  56.610  14.786  0.50 31.90           C  
ATOM   1021  CG1 VAL   125      56.598  57.581  13.923  0.50 28.83           C  
ATOM   1023  CG2 VAL   125      56.931  56.736  16.248  0.50 25.63           C  
ATOM   1025  N   GLY   126      59.472  54.206  14.407  1.00 37.83           N  
ATOM   1026  CA  GLY   126      60.529  53.399  15.017  1.00 35.15           C  
ATOM   1027  C   GLY   126      60.513  51.960  14.553  1.00 37.66           C  
ATOM   1028  O   GLY   126      59.729  51.601  13.680  1.00 38.85           O  
ATOM   1029  N   ALA   127      61.400  51.144  15.123  1.00 41.73           N  
ATOM   1030  CA  ALA   127      61.486  49.714  14.808  1.00 44.35           C  
ATOM   1031  C   ALA   127      61.973  48.958  16.031  1.00 47.23           C  
ATOM   1032  O   ALA   127      62.529  49.566  16.954  1.00 46.60           O  
ATOM   1033  CB  ALA   127      62.415  49.466  13.622  1.00 46.56           C  
ATOM   1034  N   GLY   128      61.751  47.644  16.037  1.00 47.40           N  
ATOM   1035  CA  GLY   128      62.218  46.768  17.107  1.00 50.12           C  
ATOM   1036  C   GLY   128      61.766  47.220  18.479  1.00 51.85           C  
ATOM   1037  O   GLY   128      60.591  47.487  18.685  1.00 49.32           O  
ATOM   1038  N   ALA   129      62.719  47.366  19.398  1.00 53.70           N  
ATOM   1039  CA  ALA   129      62.427  47.766  20.776  1.00 52.09           C  
ATOM   1040  C   ALA   129      61.864  49.189  20.926  1.00 49.76           C  
ATOM   1041  O   ALA   129      61.302  49.525  21.971  1.00 51.31           O  
ATOM   1042  CB  ALA   129      63.673  47.580  21.661  1.00 58.37           C  
ATOM   1043  N   ASP   130      61.988  50.006  19.878  1.00 42.21           N  
ATOM   1044  CA  ASP   130      61.566  51.406  19.908  0.50 41.80           C  
ATOM   1046  C   ASP   130      60.292  51.658  19.075  1.00 36.31           C  
ATOM   1047  O   ASP   130      59.968  52.791  18.752  1.00 38.36           O  
ATOM   1048  CB  ASP   130      62.718  52.293  19.417  0.50 40.53           C  
ATOM   1050  CG  ASP   130      64.080  51.814  19.913  0.50 50.35           C  
ATOM   1052  OD1 ASP   130      64.218  51.549  21.128  0.50 52.59           O  
ATOM   1054  OD2 ASP   130      65.011  51.699  19.084  0.50 53.48           O  
ATOM   1056  N   LEU   131      59.587  50.592  18.717  1.00 34.21           N  
ATOM   1057  CA  LEU   131      58.357  50.692  17.930  1.00 32.36           C  
ATOM   1058  C   LEU   131      57.231  51.347  18.729  1.00 29.17           C  
ATOM   1059  O   LEU   131      56.875  50.888  19.824  1.00 31.74           O  
ATOM   1060  CB  LEU   131      57.936  49.290  17.504  1.00 33.48           C  
ATOM   1061  CG  LEU   131      56.788  49.115  16.520  1.00 38.03           C  
ATOM   1062  CD1 LEU   131      57.146  49.674  15.163  1.00 38.14           C  
ATOM   1063  CD2 LEU   131      56.476  47.633  16.402  1.00 34.66           C  
ATOM   1064  N   HIS   132      56.697  52.440  18.189  1.00 27.61           N  
ATOM   1065  CA  HIS   132      55.625  53.187  18.816  1.00 23.90           C  
ATOM   1066  C   HIS   132      54.403  53.300  17.890  1.00 24.13           C  
ATOM   1067  O   HIS   132      54.568  53.508  16.702  1.00 28.10           O  
ATOM   1068  CB  HIS   132      56.104  54.594  19.205  1.00 25.85           C  
ATOM   1069  CG  HIS   132      57.031  54.617  20.382  1.00 24.89           C  
ATOM   1070  ND1 HIS   132      56.661  55.116  21.613  1.00 30.01           N  
ATOM   1071  CD2 HIS   132      58.310  54.197  20.517  1.00 29.31           C  
ATOM   1072  CE1 HIS   132      57.673  55.006  22.453  1.00 26.14           C  
ATOM   1073  NE2 HIS   132      58.684  54.446  21.815  1.00 33.17           N  
ATOM   1074  N   LEU   133      53.202  53.178  18.454  1.00 28.30           N  
ATOM   1075  CA  LEU   133      51.965  53.311  17.693  0.50 25.22           C  
ATOM   1077  C   LEU   133      51.192  54.565  18.089  1.00 28.50           C  
ATOM   1078  O   LEU   133      51.068  54.881  19.279  1.00 28.20           O  
ATOM   1079  CB  LEU   133      51.074  52.082  17.888  0.50 25.92           C  
ATOM   1081  CG  LEU   133      51.376  50.838  17.050  0.50 26.92           C  
ATOM   1083  CD1 LEU   133      50.895  49.605  17.797  0.50 26.96           C  
ATOM   1085  CD2 LEU   133      50.773  50.929  15.631  0.50 14.39           C  
ATOM   1087  N   TRP   134      50.677  55.273  17.079  1.00 24.73           N  
ATOM   1088  CA  TRP   134      49.741  56.378  17.310  1.00 28.04           C  
ATOM   1089  C   TRP   134      48.363  55.790  17.526  1.00 21.54           C  
ATOM   1090  O   TRP   134      47.880  55.030  16.697  1.00 27.82           O  
ATOM   1091  CB  TRP   134      49.680  57.332  16.115  1.00 24.82           C  
ATOM   1092  CG  TRP   134      50.814  58.286  16.080  1.00 25.59           C  
ATOM   1093  CD1 TRP   134      51.899  58.229  15.270  1.00 25.75           C  
ATOM   1094  CD2 TRP   134      50.989  59.436  16.920  1.00 27.94           C  
ATOM   1095  NE1 TRP   134      52.752  59.290  15.539  1.00 32.80           N  
ATOM   1096  CE2 TRP   134      52.208  60.045  16.547  1.00 32.27           C  
ATOM   1097  CE3 TRP   134      50.226  60.016  17.948  1.00 29.66           C  
ATOM   1098  CZ2 TRP   134      52.694  61.209  17.178  1.00 32.34           C  
ATOM   1099  CZ3 TRP   134      50.701  61.175  18.566  1.00 27.78           C  
ATOM   1100  CH2 TRP   134      51.928  61.751  18.178  1.00 25.76           C  
ATOM   1101  N   ILE   135      47.743  56.157  18.633  1.00 20.49           N  
ATOM   1102  CA  ILE   135      46.424  55.667  19.012  1.00 23.64           C  
ATOM   1103  C   ILE   135      45.507  56.876  19.036  1.00 24.63           C  
ATOM   1104  O   ILE   135      45.884  57.934  19.535  1.00 25.53           O  
ATOM   1105  CB  ILE   135      46.491  54.994  20.443  1.00 25.95           C  
ATOM   1106  CG1 ILE   135      47.393  53.740  20.415  1.00 32.16           C  
ATOM   1107  CG2 ILE   135      45.105  54.739  21.036  1.00 28.52           C  
ATOM   1108  CD1 ILE   135      47.131  52.779  19.275  1.00 32.57           C  
ATOM   1109  N   GLY   136      44.291  56.729  18.517  1.00 22.14           N  
ATOM   1110  CA  GLY   136      43.312  57.788  18.672  1.00 23.75           C  
ATOM   1111  C   GLY   136      42.392  57.506  19.845  1.00 29.17           C  
ATOM   1112  O   GLY   136      42.214  56.345  20.221  1.00 26.20           O  
ATOM   1113  N   ARG   137      41.853  58.561  20.468  1.00 27.14           N  
ATOM   1114  CA  ARG   137      40.785  58.419  21.449  0.50 27.41           C  
ATOM   1116  C   ARG   137      39.521  58.970  20.802  1.00 26.20           C  
ATOM   1117  O   ARG   137      39.511  60.130  20.393  1.00 30.01           O  
ATOM   1118  CB  ARG   137      41.113  59.202  22.723  0.50 28.24           C  
ATOM   1120  CG  ARG   137      40.424  58.677  23.983  0.50 35.93           C  
ATOM   1122  CD  ARG   137      40.349  59.720  25.115  0.50 34.31           C  
ATOM   1124  NE  ARG   137      41.505  60.618  25.170  0.50 35.77           N  
ATOM   1126  CZ  ARG   137      42.654  60.353  25.790  0.50 35.38           C  
ATOM   1128  NH1 ARG   137      43.629  61.251  25.770  0.50 40.30           N  
ATOM   1130  NH2 ARG   137      42.837  59.204  26.431  0.50 38.83           N  
ATOM   1132  N   ARG   138      38.478  58.146  20.717  1.00 26.46           N  
ATOM   1133  CA  ARG   138      37.248  58.524  20.025  1.00 25.62           C  
ATOM   1134  C   ARG   138      36.522  59.630  20.787  1.00 30.91           C  
ATOM   1135  O   ARG   138      36.602  59.709  22.021  1.00 29.45           O  
ATOM   1136  CB  ARG   138      36.339  57.304  19.832  1.00 23.64           C  
ATOM   1137  CG  ARG   138      36.966  56.242  18.907  1.00 21.94           C  
ATOM   1138  CD  ARG   138      36.266  54.910  18.996  1.00 20.70           C  
ATOM   1139  NE  ARG   138      34.880  54.968  18.531  1.00 22.86           N  
ATOM   1140  CZ  ARG   138      34.529  54.986  17.247  1.00 20.39           C  
ATOM   1141  NH1 ARG   138      35.457  54.949  16.293  1.00 22.53           N  
ATOM   1142  NH2 ARG   138      33.259  55.024  16.912  1.00 23.32           N  
ATOM   1143  N   SER   139      35.824  60.482  20.046  1.00 30.82           N  
ATOM   1144  CA  SER   139      35.057  61.578  20.638  1.00 30.87           C  
ATOM   1145  C   SER   139      33.940  61.000  21.509  1.00 34.11           C  
ATOM   1146  O   SER   139      33.421  59.916  21.203  1.00 30.95           O  
ATOM   1147  CB  SER   139      34.488  62.454  19.511  1.00 33.82           C  
ATOM   1148  OG  SER   139      33.340  63.180  19.913  1.00 44.80           O  
ATOM   1149  N   PRO   140      33.553  61.712  22.597  1.00 38.34           N  
ATOM   1150  CA  PRO   140      32.428  61.225  23.417  1.00 34.53           C  
ATOM   1151  C   PRO   140      31.082  61.213  22.695  1.00 37.90           C  
ATOM   1152  O   PRO   140      30.154  60.542  23.157  1.00 31.63           O  
ATOM   1153  CB  PRO   140      32.380  62.217  24.592  1.00 39.75           C  
ATOM   1154  CG  PRO   140      33.679  62.919  24.569  1.00 42.46           C  
ATOM   1155  CD  PRO   140      34.111  62.964  23.141  1.00 37.78           C  
ATOM   1156  N   ASP   141      30.996  61.920  21.563  1.00 35.55           N  
ATOM   1157  CA  ASP   141      29.781  62.004  20.771  1.00 36.36           C  
ATOM   1158  C   ASP   141      29.584  60.825  19.802  1.00 34.79           C  
ATOM   1159  O   ASP   141      28.527  60.709  19.174  1.00 34.78           O  
ATOM   1160  CB  ASP   141      29.739  63.340  20.013  1.00 44.42           C  
ATOM   1161  CG  ASP   141      29.874  64.547  20.938  1.00 49.36           C  
ATOM   1162  OD1 ASP   141      29.306  64.515  22.049  1.00 56.17           O  
ATOM   1163  OD2 ASP   141      30.558  65.525  20.559  1.00 52.17           O  
ATOM   1164  N   LYS   142      30.576  59.939  19.681  1.00 29.21           N  
ATOM   1165  CA  LYS   142      30.384  58.752  18.851  1.00 25.30           C  
ATOM   1166  C   LYS   142      29.212  57.930  19.356  1.00 25.78           C  
ATOM   1167  O   LYS   142      29.064  57.680  20.568  1.00 27.08           O  
ATOM   1168  CB  LYS   142      31.640  57.870  18.797  1.00 27.48           C  
ATOM   1169  CG  LYS   142      32.783  58.447  17.985  1.00 21.74           C  
ATOM   1170  CD  LYS   142      32.458  58.500  16.487  1.00 23.30           C  
ATOM   1171  CE  LYS   142      33.691  58.863  15.653  1.00 37.56           C  
ATOM   1172  NZ  LYS   142      33.392  58.674  14.195  1.00 34.81           N  
ATOM   1173  N   SER   143      28.395  57.504  18.408  1.00 28.71           N  
ATOM   1174  CA  SER   143      27.291  56.609  18.662  1.00 30.64           C  
ATOM   1175  C   SER   143      27.787  55.255  19.212  1.00 34.84           C  
ATOM   1176  O   SER   143      27.203  54.700  20.156  1.00 33.01           O  
ATOM   1177  CB  SER   143      26.516  56.417  17.359  1.00 38.43           C  
ATOM   1178  OG  SER   143      25.518  55.421  17.483  1.00 52.04           O  
ATOM   1179  N   VAL   144      28.881  54.763  18.625  1.00 26.02           N  
ATOM   1180  CA  VAL   144      29.490  53.472  18.954  1.00 27.84           C  
ATOM   1181  C   VAL   144      30.828  53.714  19.640  1.00 24.68           C  
ATOM   1182  O   VAL   144      31.624  54.538  19.176  1.00 29.30           O  
ATOM   1183  CB  VAL   144      29.689  52.619  17.656  1.00 24.85           C  
ATOM   1184  CG1 VAL   144      30.577  51.388  17.923  1.00 28.55           C  
ATOM   1185  CG2 VAL   144      28.334  52.209  17.074  1.00 29.86           C  
ATOM   1186  N   ALA   145      31.073  53.020  20.760  1.00 28.68           N  
ATOM   1187  CA  ALA   145      32.369  53.094  21.450  1.00 27.24           C  
ATOM   1188  C   ALA   145      32.860  54.538  21.737  1.00 24.20           C  
ATOM   1189  O   ALA   145      34.024  54.866  21.456  1.00 24.03           O  
ATOM   1190  CB  ALA   145      33.455  52.282  20.649  1.00 22.65           C  
ATOM   1191  N   PRO   146      31.979  55.416  22.294  1.00 26.11           N  
ATOM   1192  CA  PRO   146      32.462  56.776  22.548  1.00 27.01           C  
ATOM   1193  C   PRO   146      33.556  56.753  23.604  1.00 27.01           C  
ATOM   1194  O   PRO   146      33.477  55.947  24.536  1.00 26.67           O  
ATOM   1195  CB  PRO   146      31.219  57.494  23.089  1.00 26.92           C  
ATOM   1196  CG  PRO   146      30.367  56.410  23.679  1.00 26.95           C  
ATOM   1197  CD  PRO   146      30.582  55.243  22.751  1.00 26.57           C  
ATOM   1198  N   GLY   147      34.583  57.584  23.429  1.00 23.06           N  
ATOM   1199  CA  GLY   147      35.705  57.661  24.359  1.00 27.37           C  
ATOM   1200  C   GLY   147      36.691  56.497  24.326  1.00 31.76           C  
ATOM   1201  O   GLY   147      37.667  56.505  25.074  1.00 28.82           O  
ATOM   1202  N   LYS   148      36.440  55.491  23.485  1.00 27.28           N  
ATOM   1203  CA  LYS   148      37.332  54.317  23.405  1.00 26.06           C  
ATOM   1204  C   LYS   148      38.557  54.579  22.543  1.00 24.99           C  
ATOM   1205  O   LYS   148      38.583  55.495  21.700  1.00 22.55           O  
ATOM   1206  CB  LYS   148      36.593  53.091  22.883  1.00 28.51           C  
ATOM   1207  CG  LYS   148      35.318  52.761  23.627  1.00 30.74           C  
ATOM   1208  CD  LYS   148      35.550  52.390  25.007  1.00 43.85           C  
ATOM   1209  CE  LYS   148      35.908  50.942  25.127  1.00 32.51           C  
ATOM   1210  NZ  LYS   148      35.988  50.749  26.579  1.00 28.96           N  
ATOM   1211  N   LEU   149      39.580  53.755  22.738  1.00 19.09           N  
ATOM   1212  CA  LEU   149      40.799  53.869  21.978  1.00 20.06           C  
ATOM   1213  C   LEU   149      40.618  53.178  20.614  1.00 21.55           C  
ATOM   1214  O   LEU   149      39.808  52.249  20.469  1.00 19.47           O  
ATOM   1215  CB  LEU   149      41.978  53.254  22.739  1.00 19.37           C  
ATOM   1216  CG  LEU   149      42.239  53.841  24.143  1.00 22.93           C  
ATOM   1217  CD1 LEU   149      43.478  53.201  24.754  1.00 25.48           C  
ATOM   1218  CD2 LEU   149      42.424  55.331  24.014  1.00 24.59           C  
ATOM   1219  N   ASP   150      41.386  53.643  19.642  1.00 19.17           N  
ATOM   1220  CA  ASP   150      41.137  53.381  18.214  1.00 17.87           C  
ATOM   1221  C   ASP   150      42.435  53.385  17.456  1.00 21.13           C  
ATOM   1222  O   ASP   150      43.464  53.839  17.963  1.00 19.36           O  
ATOM   1223  CB  ASP   150      40.216  54.510  17.665  1.00 22.49           C  
ATOM   1224  CG  ASP   150      39.310  54.075  16.479  1.00 28.89           C  
ATOM   1225  OD1 ASP   150      39.538  53.036  15.793  1.00 24.67           O  
ATOM   1226  OD2 ASP   150      38.338  54.829  16.218  1.00 21.49           O  
ATOM   1227  N   ASN   151      42.412  52.873  16.220  1.00 19.91           N  
ATOM   1228  CA  ASN   151      43.513  53.121  15.292  1.00 18.90           C  
ATOM   1229  C   ASN   151      43.692  54.630  15.039  1.00 19.61           C  
ATOM   1230  O   ASN   151      42.763  55.413  15.282  1.00 21.72           O  
ATOM   1231  CB  ASN   151      43.249  52.436  13.953  1.00 19.47           C  
ATOM   1232  CG  ASN   151      42.927  50.965  14.110  1.00 21.52           C  
ATOM   1233  OD1 ASN   151      41.774  50.562  13.988  1.00 25.50           O  
ATOM   1234  ND2 ASN   151      43.938  50.165  14.449  1.00 24.44           N  
ATOM   1235  N   MET   152      44.869  55.023  14.553  1.00 20.04           N  
ATOM   1236  CA  MET   152      45.111  56.424  14.225  1.00 22.73           C  
ATOM   1237  C   MET   152      44.070  56.899  13.189  1.00 23.86           C  
ATOM   1238  O   MET   152      43.521  58.014  13.289  1.00 21.66           O  
ATOM   1239  CB  MET   152      46.514  56.636  13.679  1.00 18.42           C  
ATOM   1240  CG  MET   152      46.859  58.149  13.591  1.00 23.68           C  
ATOM   1241  SD  MET   152      48.604  58.426  12.865  0.70 28.49          SE  
ATOM   1242  CE  MET   152      48.177  58.085  11.003  1.00 34.44           C  
ATOM   1243  N   VAL   153      43.777  56.029  12.217  1.00 20.16           N  
ATOM   1244  CA  VAL   153      42.762  56.323  11.194  1.00 19.57           C  
ATOM   1245  C   VAL   153      41.943  55.047  10.963  1.00 19.06           C  
ATOM   1246  O   VAL   153      42.516  53.975  10.822  1.00 20.64           O  
ATOM   1247  CB  VAL   153      43.415  56.792   9.862  1.00 20.96           C  
ATOM   1248  CG1 VAL   153      42.353  56.936   8.741  1.00 24.65           C  
ATOM   1249  CG2 VAL   153      44.159  58.106  10.035  1.00 22.39           C  
ATOM   1250  N   ALA   154      40.617  55.163  10.971  1.00 19.92           N  
ATOM   1251  CA  ALA   154      39.731  54.023  10.657  1.00 21.62           C  
ATOM   1252  C   ALA   154      38.397  54.570  10.228  1.00 25.62           C  
ATOM   1253  O   ALA   154      37.948  55.570  10.773  1.00 25.22           O  
ATOM   1254  CB  ALA   154      39.524  53.137  11.885  1.00 20.52           C  
ATOM   1255  N   GLY   155      37.735  53.910   9.291  1.00 19.78           N  
ATOM   1256  CA  GLY   155      36.358  54.302   8.976  1.00 23.92           C  
ATOM   1257  C   GLY   155      35.641  53.261   8.154  1.00 25.11           C  
ATOM   1258  O   GLY   155      36.280  52.417   7.521  1.00 20.50           O  
ATOM   1259  N   GLY   156      34.313  53.317   8.176  1.00 16.33           N  
ATOM   1260  CA  GLY   156      33.510  52.527   7.267  1.00 17.20           C  
ATOM   1261  C   GLY   156      33.756  52.878   5.803  1.00 17.21           C  
ATOM   1262  O   GLY   156      34.197  53.983   5.475  1.00 20.27           O  
ATOM   1263  N   GLN   157      33.468  51.919   4.926  1.00 21.75           N  
ATOM   1264  CA  GLN   157      33.725  52.051   3.502  1.00 18.48           C  
ATOM   1265  C   GLN   157      32.454  52.429   2.761  1.00 20.30           C  
ATOM   1266  O   GLN   157      31.530  51.630   2.670  1.00 19.32           O  
ATOM   1267  CB  GLN   157      34.219  50.733   2.932  1.00 20.97           C  
ATOM   1268  CG  GLN   157      34.585  50.817   1.450  1.00 17.60           C  
ATOM   1269  CD  GLN   157      35.776  51.699   1.251  1.00 22.34           C  
ATOM   1270  OE1 GLN   157      36.605  51.847   2.153  1.00 20.60           O  
ATOM   1271  NE2 GLN   157      35.886  52.292   0.068  1.00 22.64           N  
ATOM   1272  N   PRO   158      32.420  53.634   2.195  1.00 20.08           N  
ATOM   1273  CA  PRO   158      31.248  53.977   1.381  1.00 22.50           C  
ATOM   1274  C   PRO   158      31.248  53.236   0.035  1.00 19.52           C  
ATOM   1275  O   PRO   158      32.300  52.813  -0.455  1.00 22.07           O  
ATOM   1276  CB  PRO   158      31.373  55.491   1.172  1.00 25.22           C  
ATOM   1277  CG  PRO   158      32.803  55.820   1.440  1.00 26.79           C  
ATOM   1278  CD  PRO   158      33.400  54.730   2.294  1.00 20.41           C  
ATOM   1279  N   ALA   159      30.050  53.050  -0.505  1.00 21.68           N  
ATOM   1280  CA  ALA   159      29.832  52.394  -1.781  1.00 23.81           C  
ATOM   1281  C   ALA   159      30.622  53.032  -2.917  1.00 28.04           C  
ATOM   1282  O   ALA   159      31.044  52.329  -3.845  1.00 25.76           O  
ATOM   1283  CB  ALA   159      28.379  52.443  -2.120  1.00 28.69           C  
ATOM   1284  N   ASP   160      30.840  54.346  -2.847  1.00 24.07           N  
ATOM   1285  CA  ASP   160      31.271  55.058  -4.054  1.00 33.19           C  
ATOM   1286  C   ASP   160      32.778  55.280  -4.144  1.00 33.50           C  
ATOM   1287  O   ASP   160      33.247  55.930  -5.091  1.00 25.67           O  
ATOM   1288  CB  ASP   160      30.494  56.378  -4.237  1.00 30.97           C  
ATOM   1289  CG  ASP   160      30.814  57.410  -3.164  1.00 39.20           C  
ATOM   1290  OD1 ASP   160      31.210  57.017  -2.048  1.00 33.72           O  
ATOM   1291  OD2 ASP   160      30.659  58.620  -3.436  1.00 46.55           O  
ATOM   1292  N   LEU   161      33.521  54.729  -3.178  1.00 24.34           N  
ATOM   1293  CA  LEU   161      34.989  54.888  -3.136  1.00 22.16           C  
ATOM   1294  C   LEU   161      35.713  53.536  -3.169  1.00 25.00           C  
ATOM   1295  O   LEU   161      35.177  52.523  -2.695  1.00 23.70           O  
ATOM   1296  CB  LEU   161      35.414  55.651  -1.874  1.00 22.56           C  
ATOM   1297  CG  LEU   161      34.928  57.096  -1.657  1.00 30.24           C  
ATOM   1298  CD1 LEU   161      35.634  57.695  -0.437  1.00 27.83           C  
ATOM   1299  CD2 LEU   161      35.183  57.934  -2.909  1.00 23.35           C  
ATOM   1300  N   SER   162      36.929  53.543  -3.710  1.00 19.44           N  
ATOM   1301  CA  SER   162      37.896  52.441  -3.518  1.00 18.75           C  
ATOM   1302  C   SER   162      38.383  52.464  -2.051  1.00 16.03           C  
ATOM   1303  O   SER   162      38.138  53.432  -1.324  1.00 18.03           O  
ATOM   1304  CB  SER   162      39.094  52.550  -4.471  1.00 17.15           C  
ATOM   1305  OG  SER   162      39.999  53.562  -4.049  1.00 20.75           O  
ATOM   1306  N   LEU   163      39.050  51.391  -1.627  1.00 19.00           N  
ATOM   1307  CA  LEU   163      39.595  51.317  -0.272  1.00 18.42           C  
ATOM   1308  C   LEU   163      40.671  52.381  -0.112  1.00 19.29           C  
ATOM   1309  O   LEU   163      40.718  53.055   0.905  1.00 17.38           O  
ATOM   1310  CB  LEU   163      40.196  49.919  -0.020  1.00 15.49           C  
ATOM   1311  CG  LEU   163      39.127  48.827  -0.009  1.00 17.28           C  
ATOM   1312  CD1 LEU   163      39.794  47.445  -0.052  1.00 19.40           C  
ATOM   1313  CD2 LEU   163      38.208  48.916   1.206  1.00 21.21           C  
ATOM   1314  N   ARG   164      41.510  52.514  -1.135  1.00 17.15           N  
ATOM   1315  CA  ARG   164      42.623  53.462  -1.087  1.00 22.19           C  
ATOM   1316  C   ARG   164      42.088  54.905  -1.016  1.00 22.29           C  
ATOM   1317  O   ARG   164      42.616  55.747  -0.281  1.00 22.06           O  
ATOM   1318  CB  ARG   164      43.540  53.283  -2.294  1.00 24.55           C  
ATOM   1319  CG  ARG   164      44.631  54.375  -2.420  1.00 26.08           C  
ATOM   1320  CD  ARG   164      45.627  54.235  -1.296  1.00 29.30           C  
ATOM   1321  NE  ARG   164      46.362  52.975  -1.399  1.00 38.00           N  
ATOM   1322  CZ  ARG   164      47.405  52.647  -0.639  1.00 34.41           C  
ATOM   1323  NH1 ARG   164      47.838  53.476   0.317  1.00 28.73           N  
ATOM   1324  NH2 ARG   164      48.010  51.489  -0.842  1.00 29.91           N  
ATOM   1325  N   GLN   165      41.038  55.181  -1.780  1.00 20.52           N  
ATOM   1326  CA  GLN   165      40.438  56.522  -1.806  1.00 21.23           C  
ATOM   1327  C   GLN   165      39.844  56.868  -0.457  1.00 21.59           C  
ATOM   1328  O   GLN   165      40.038  57.982   0.062  1.00 20.84           O  
ATOM   1329  CB  GLN   165      39.336  56.598  -2.863  1.00 21.52           C  
ATOM   1330  CG  GLN   165      39.894  56.847  -4.261  1.00 28.49           C  
ATOM   1331  CD  GLN   165      39.029  56.265  -5.354  1.00 36.32           C  
ATOM   1332  OE1 GLN   165      37.806  56.063  -5.196  1.00 26.17           O  
ATOM   1333  NE2 GLN   165      39.665  55.986  -6.491  1.00 39.85           N  
ATOM   1334  N   ASN   166      39.107  55.918   0.106  1.00 21.23           N  
ATOM   1335  CA  ASN   166      38.535  56.108   1.415  1.00 22.05           C  
ATOM   1336  C   ASN   166      39.629  56.262   2.475  1.00 22.07           C  
ATOM   1337  O   ASN   166      39.542  57.133   3.315  1.00 20.60           O  
ATOM   1338  CB  ASN   166      37.599  54.967   1.791  1.00 20.63           C  
ATOM   1339  CG  ASN   166      36.757  55.305   3.021  1.00 23.47           C  
ATOM   1340  OD1 ASN   166      36.291  56.449   3.168  1.00 23.28           O  
ATOM   1341  ND2 ASN   166      36.583  54.349   3.904  1.00 18.78           N  
ATOM   1342  N   LEU   167      40.657  55.415   2.423  1.00 19.16           N  
ATOM   1343  CA  LEU   167      41.799  55.585   3.326  1.00 22.36           C  
ATOM   1344  C   LEU   167      42.376  57.018   3.244  1.00 27.44           C  
ATOM   1345  O   LEU   167      42.636  57.642   4.269  1.00 22.88           O  
ATOM   1346  CB  LEU   167      42.895  54.563   3.029  1.00 20.82           C  
ATOM   1347  CG  LEU   167      44.107  54.634   3.965  1.00 26.27           C  
ATOM   1348  CD1 LEU   167      43.730  54.259   5.425  1.00 21.08           C  
ATOM   1349  CD2 LEU   167      45.208  53.749   3.420  1.00 22.64           C  
ATOM   1350  N   ILE   168      42.555  57.538   2.028  1.00 26.93           N  
ATOM   1351  CA  ILE   168      43.115  58.897   1.843  1.00 25.17           C  
ATOM   1352  C   ILE   168      42.233  59.979   2.470  1.00 24.22           C  
ATOM   1353  O   ILE   168      42.714  60.859   3.184  1.00 23.88           O  
ATOM   1354  CB  ILE   168      43.383  59.177   0.341  1.00 28.80           C  
ATOM   1355  CG1 ILE   168      44.609  58.378  -0.097  1.00 21.59           C  
ATOM   1356  CG2 ILE   168      43.611  60.674   0.062  1.00 24.28           C  
ATOM   1357  CD1 ILE   168      44.644  58.115  -1.579  1.00 29.12           C  
ATOM   1358  N   LYS   169      40.942  59.881   2.215  1.00 21.03           N  
ATOM   1359  CA  LYS   169      39.965  60.802   2.753  1.00 25.69           C  
ATOM   1360  C   LYS   169      39.921  60.744   4.277  1.00 27.01           C  
ATOM   1361  O   LYS   169      39.920  61.770   4.938  1.00 24.12           O  
ATOM   1362  CB  LYS   169      38.605  60.472   2.187  1.00 20.71           C  
ATOM   1363  CG  LYS   169      37.441  61.203   2.821  1.00 28.07           C  
ATOM   1364  CD  LYS   169      36.119  60.764   2.225  1.00 44.80           C  
ATOM   1365  CE  LYS   169      34.965  61.166   3.143  1.00 54.68           C  
ATOM   1366  NZ  LYS   169      33.661  60.638   2.662  1.00 64.28           N  
ATOM   1367  N   GLU   170      39.906  59.538   4.834  1.00 18.72           N  
ATOM   1368  CA  GLU   170      39.874  59.382   6.287  1.00 20.09           C  
ATOM   1369  C   GLU   170      41.139  59.892   6.938  1.00 23.18           C  
ATOM   1370  O   GLU   170      41.073  60.468   8.020  1.00 27.45           O  
ATOM   1371  CB  GLU   170      39.622  57.917   6.696  1.00 22.79           C  
ATOM   1372  CG  GLU   170      38.258  57.350   6.280  1.00 25.29           C  
ATOM   1373  CD  GLU   170      37.049  58.059   6.906  1.00 40.32           C  
ATOM   1374  OE1 GLU   170      36.871  59.283   6.729  1.00 53.74           O  
ATOM   1375  OE2 GLU   170      36.237  57.371   7.550  1.00 42.38           O  
ATOM   1376  N   CYS   171      42.271  59.697   6.276  1.00 20.72           N  
ATOM   1377  CA  CYS   171      43.568  60.139   6.779  1.00 23.54           C  
ATOM   1378  C   CYS   171      43.620  61.653   6.964  1.00 30.29           C  
ATOM   1379  O   CYS   171      44.135  62.136   7.976  1.00 28.00           O  
ATOM   1380  CB  CYS   171      44.709  59.704   5.866  1.00 24.69           C  
ATOM   1381  SG  CYS   171      45.309  57.986   6.121  1.00 24.58           S  
ATOM   1382  N   ALA   172      43.089  62.377   5.974  1.00 25.84           N  
ATOM   1383  CA  ALA   172      42.997  63.838   6.024  1.00 26.87           C  
ATOM   1384  C   ALA   172      41.963  64.287   7.049  1.00 24.26           C  
ATOM   1385  O   ALA   172      42.255  65.126   7.889  1.00 28.18           O  
ATOM   1386  CB  ALA   172      42.653  64.407   4.617  1.00 26.01           C  
ATOM   1387  N   GLU   173      40.763  63.712   7.013  1.00 23.60           N  
ATOM   1388  CA  GLU   173      39.687  64.192   7.870  1.00 31.06           C  
ATOM   1389  C   GLU   173      39.919  63.865   9.345  1.00 31.04           C  
ATOM   1390  O   GLU   173      39.618  64.676  10.216  1.00 30.90           O  
ATOM   1391  CB  GLU   173      38.336  63.634   7.421  1.00 28.56           C  
ATOM   1392  CG  GLU   173      37.884  64.143   6.052  1.00 33.70           C  
ATOM   1393  CD  GLU   173      36.558  63.542   5.607  1.00 44.95           C  
ATOM   1394  OE1 GLU   173      36.107  62.539   6.213  1.00 52.84           O  
ATOM   1395  OE2 GLU   173      35.976  64.071   4.633  1.00 57.87           O  
ATOM   1396  N   GLU   174      40.459  62.683   9.625  1.00 27.71           N  
ATOM   1397  CA  GLU   174      40.521  62.220  11.005  1.00 24.57           C  
ATOM   1398  C   GLU   174      41.802  62.587  11.697  1.00 23.74           C  
ATOM   1399  O   GLU   174      41.819  62.763  12.916  1.00 27.22           O  
ATOM   1400  CB  GLU   174      40.311  60.703  11.110  1.00 21.95           C  
ATOM   1401  CG  GLU   174      38.903  60.226  10.741  1.00 31.09           C  
ATOM   1402  CD  GLU   174      38.726  58.714  10.905  1.00 40.24           C  
ATOM   1403  OE1 GLU   174      39.712  58.058  11.331  1.00 29.99           O  
ATOM   1404  OE2 GLU   174      37.601  58.194  10.616  1.00 30.74           O  
ATOM   1405  N   ALA   175      42.886  62.691  10.937  1.00 23.54           N  
ATOM   1406  CA  ALA   175      44.190  62.794  11.559  1.00 26.67           C  
ATOM   1407  C   ALA   175      45.070  63.861  10.933  1.00 23.54           C  
ATOM   1408  O   ALA   175      46.236  64.004  11.327  1.00 26.48           O  
ATOM   1409  CB  ALA   175      44.898  61.448  11.543  1.00 25.30           C  
ATOM   1410  N   ASP   176      44.536  64.581   9.945  1.00 30.87           N  
ATOM   1411  CA  ASP   176      45.316  65.624   9.266  1.00 31.29           C  
ATOM   1412  C   ASP   176      46.584  65.021   8.650  1.00 31.62           C  
ATOM   1413  O   ASP   176      47.680  65.585   8.741  1.00 26.14           O  
ATOM   1414  CB  ASP   176      45.645  66.754  10.271  1.00 35.88           C  
ATOM   1415  CG  ASP   176      46.111  68.041   9.596  1.00 44.42           C  
ATOM   1416  OD1 ASP   176      45.799  68.242   8.402  1.00 42.23           O  
ATOM   1417  OD2 ASP   176      46.803  68.835  10.266  1.00 45.65           O  
ATOM   1418  N   LEU   177      46.436  63.833   8.063  1.00 28.64           N  
ATOM   1419  CA  LEU   177      47.547  63.153   7.415  1.00 28.98           C  
ATOM   1420  C   LEU   177      47.363  63.336   5.912  1.00 29.59           C  
ATOM   1421  O   LEU   177      46.375  62.864   5.350  1.00 29.80           O  
ATOM   1422  CB  LEU   177      47.591  61.655   7.796  1.00 28.47           C  
ATOM   1423  CG  LEU   177      48.676  60.813   7.119  1.00 31.21           C  
ATOM   1424  CD1 LEU   177      50.059  61.193   7.567  1.00 43.08           C  
ATOM   1425  CD2 LEU   177      48.462  59.350   7.408  1.00 35.93           C  
ATOM   1426  N   PRO   178      48.287  64.075   5.272  1.00 36.79           N  
ATOM   1427  CA  PRO   178      48.150  64.497   3.880  1.00 35.44           C  
ATOM   1428  C   PRO   178      48.266  63.343   2.903  1.00 31.05           C  
ATOM   1429  O   PRO   178      48.832  62.296   3.248  1.00 31.49           O  
ATOM   1430  CB  PRO   178      49.332  65.455   3.684  1.00 38.30           C  
ATOM   1431  CG  PRO   178      50.349  65.018   4.692  1.00 42.22           C  
ATOM   1432  CD  PRO   178      49.543  64.563   5.873  1.00 35.40           C  
ATOM   1433  N   GLU   179      47.743  63.564   1.695  1.00 33.20           N  
ATOM   1434  CA  GLU   179      47.658  62.554   0.647  1.00 34.92           C  
ATOM   1435  C   GLU   179      48.979  61.886   0.297  1.00 33.77           C  
ATOM   1436  O   GLU   179      49.014  60.670   0.118  1.00 35.14           O  
ATOM   1437  CB  GLU   179      47.021  63.129  -0.615  1.00 35.78           C  
ATOM   1438  CG  GLU   179      46.777  62.071  -1.703  1.00 36.31           C  
ATOM   1439  CD  GLU   179      45.889  62.560  -2.842  1.00 45.49           C  
ATOM   1440  OE1 GLU   179      45.597  63.774  -2.898  1.00 52.73           O  
ATOM   1441  OE2 GLU   179      45.477  61.722  -3.677  1.00 45.51           O  
ATOM   1442  N   ALA   180      50.058  62.667   0.227  1.00 36.39           N  
ATOM   1443  CA  ALA   180      51.379  62.133  -0.131  1.00 38.20           C  
ATOM   1444  C   ALA   180      51.853  61.056   0.853  1.00 37.77           C  
ATOM   1445  O   ALA   180      52.397  60.028   0.444  1.00 41.56           O  
ATOM   1446  CB  ALA   180      52.416  63.260  -0.251  1.00 40.78           C  
ATOM   1447  N   LEU   181      51.627  61.294   2.142  1.00 36.73           N  
ATOM   1448  CA  LEU   181      51.914  60.280   3.160  1.00 34.41           C  
ATOM   1449  C   LEU   181      50.891  59.141   3.182  1.00 27.36           C  
ATOM   1450  O   LEU   181      51.282  57.985   3.216  1.00 31.68           O  
ATOM   1451  CB  LEU   181      52.044  60.908   4.548  1.00 31.23           C  
ATOM   1452  CG  LEU   181      53.424  61.415   4.958  1.00 44.99           C  
ATOM   1453  CD1 LEU   181      53.292  62.339   6.142  1.00 46.78           C  
ATOM   1454  CD2 LEU   181      54.331  60.242   5.304  1.00 49.35           C  
ATOM   1455  N   ALA   182      49.589  59.457   3.184  1.00 24.43           N  
ATOM   1456  CA  ALA   182      48.533  58.431   3.118  1.00 26.05           C  
ATOM   1457  C   ALA   182      48.706  57.419   1.980  1.00 30.74           C  
ATOM   1458  O   ALA   182      48.386  56.233   2.140  1.00 25.47           O  
ATOM   1459  CB  ALA   182      47.142  59.081   3.053  1.00 25.43           C  
ATOM   1460  N   ARG   183      49.211  57.878   0.829  1.00 28.18           N  
ATOM   1461  CA  ARG   183      49.477  56.998  -0.308  1.00 31.04           C  
ATOM   1462  C   ARG   183      50.649  56.021  -0.087  1.00 25.44           C  
ATOM   1463  O   ARG   183      50.764  55.015  -0.789  1.00 29.60           O  
ATOM   1464  CB  ARG   183      49.697  57.813  -1.595  1.00 29.99           C  
ATOM   1465  CG  ARG   183      48.406  58.279  -2.240  1.00 34.47           C  
ATOM   1466  CD  ARG   183      48.654  58.995  -3.593  1.00 43.53           C  
ATOM   1467  NE  ARG   183      47.418  59.526  -4.180  1.00 42.49           N  
ATOM   1468  CZ  ARG   183      46.495  58.799  -4.812  1.00 45.86           C  
ATOM   1469  NH1 ARG   183      46.631  57.479  -4.952  1.00 51.31           N  
ATOM   1470  NH2 ARG   183      45.416  59.395  -5.297  1.00 49.80           N  
ATOM   1471  N   GLN   184      51.530  56.332   0.857  1.00 30.80           N  
ATOM   1472  CA  GLN   184      52.625  55.422   1.196  1.00 31.05           C  
ATOM   1473  C   GLN   184      52.169  54.233   2.055  1.00 27.05           C  
ATOM   1474  O   GLN   184      52.927  53.271   2.211  1.00 26.28           O  
ATOM   1475  CB  GLN   184      53.746  56.175   1.903  1.00 30.65           C  
ATOM   1476  CG  GLN   184      54.521  57.145   1.003  1.00 43.67           C  
ATOM   1477  CD  GLN   184      55.464  58.044   1.787  1.00 47.15           C  
ATOM   1478  OE1 GLN   184      56.057  57.632   2.791  1.00 55.62           O  
ATOM   1479  NE2 GLN   184      55.603  59.284   1.334  1.00 61.22           N  
ATOM   1480  N   ALA   185      50.965  54.313   2.632  1.00 27.12           N  
ATOM   1481  CA  ALA   185      50.421  53.199   3.447  1.00 26.49           C  
ATOM   1482  C   ALA   185      50.296  51.947   2.601  1.00 23.37           C  
ATOM   1483  O   ALA   185      49.831  52.000   1.454  1.00 26.33           O  
ATOM   1484  CB  ALA   185      49.064  53.550   4.049  1.00 22.77           C  
ATOM   1485  N   ILE   186      50.731  50.817   3.148  1.00 19.54           N  
ATOM   1486  CA  ILE   186      50.664  49.592   2.367  1.00 18.61           C  
ATOM   1487  C   ILE   186      49.586  48.655   2.902  1.00 19.53           C  
ATOM   1488  O   ILE   186      49.412  48.540   4.122  1.00 18.61           O  
ATOM   1489  CB  ILE   186      52.028  48.867   2.298  1.00 25.65           C  
ATOM   1490  CG1 ILE   186      52.474  48.403   3.664  1.00 23.08           C  
ATOM   1491  CG2 ILE   186      53.119  49.766   1.611  1.00 32.33           C  
ATOM   1492  CD1 ILE   186      53.373  47.159   3.562  1.00 23.38           C  
ATOM   1493  N   PRO   187      48.855  47.988   1.999  1.00 21.38           N  
ATOM   1494  CA  PRO   187      47.867  47.043   2.502  1.00 15.78           C  
ATOM   1495  C   PRO   187      48.569  45.828   3.087  1.00 20.47           C  
ATOM   1496  O   PRO   187      49.607  45.439   2.576  1.00 16.31           O  
ATOM   1497  CB  PRO   187      47.064  46.657   1.256  1.00 17.27           C  
ATOM   1498  CG  PRO   187      47.952  46.981   0.098  1.00 20.64           C  
ATOM   1499  CD  PRO   187      48.888  48.061   0.519  1.00 18.84           C  
ATOM   1500  N   VAL   188      48.046  45.287   4.183  1.00 18.73           N  
ATOM   1501  CA  VAL   188      48.744  44.218   4.909  1.00 16.69           C  
ATOM   1502  C   VAL   188      47.866  43.014   5.242  1.00 18.23           C  
ATOM   1503  O   VAL   188      48.310  42.075   5.917  1.00 21.16           O  
ATOM   1504  CB  VAL   188      49.437  44.737   6.215  1.00 19.46           C  
ATOM   1505  CG1 VAL   188      50.608  45.617   5.888  1.00 19.96           C  
ATOM   1506  CG2 VAL   188      48.436  45.460   7.141  1.00 15.01           C  
ATOM   1507  N   GLY   189      46.614  43.047   4.783  1.00 16.49           N  
ATOM   1508  CA  GLY   189      45.738  41.913   5.015  1.00 18.91           C  
ATOM   1509  C   GLY   189      44.371  42.407   5.404  1.00 18.87           C  
ATOM   1510  O   GLY   189      44.031  43.575   5.182  1.00 19.08           O  
ATOM   1511  N   ALA   190      43.588  41.519   5.986  1.00 16.54           N  
ATOM   1512  CA  ALA   190      42.232  41.863   6.412  1.00 20.59           C  
ATOM   1513  C   ALA   190      41.818  41.013   7.596  1.00 22.26           C  
ATOM   1514  O   ALA   190      42.310  39.908   7.782  1.00 22.93           O  
ATOM   1515  CB  ALA   190      41.193  41.719   5.252  1.00 17.91           C  
ATOM   1516  N   ILE   191      40.876  41.527   8.372  1.00 18.64           N  
ATOM   1517  CA  ILE   191      40.209  40.733   9.408  1.00 18.43           C  
ATOM   1518  C   ILE   191      38.742  40.564   9.089  1.00 21.37           C  
ATOM   1519  O   ILE   191      38.120  41.492   8.588  1.00 17.81           O  
ATOM   1520  CB  ILE   191      40.403  41.440  10.771  1.00 18.60           C  
ATOM   1521  CG1 ILE   191      41.794  41.129  11.305  1.00 22.38           C  
ATOM   1522  CG2 ILE   191      39.357  41.046  11.813  1.00 22.58           C  
ATOM   1523  CD1 ILE   191      42.241  42.201  12.244  1.00 27.81           C  
ATOM   1524  N   THR   192      38.193  39.370   9.332  1.00 16.15           N  
ATOM   1525  CA  THR   192      36.762  39.137   9.160  0.50 18.17           C  
ATOM   1527  C   THR   192      36.165  38.562  10.457  1.00 22.84           C  
ATOM   1528  O   THR   192      36.755  37.666  11.076  1.00 19.70           O  
ATOM   1529  CB  THR   192      36.505  38.231   7.926  0.50 23.49           C  
ATOM   1531  OG1 THR   192      36.932  38.911   6.737  0.50 21.60           O  
ATOM   1533  CG2 THR   192      35.053  37.898   7.769  0.50 12.87           C  
ATOM   1535  N   TYR   193      35.003  39.065  10.863  1.00 16.92           N  
ATOM   1536  CA  TYR   193      34.320  38.490  12.035  1.00 16.58           C  
ATOM   1537  C   TYR   193      32.832  38.520  11.779  1.00 20.59           C  
ATOM   1538  O   TYR   193      32.369  39.156  10.815  1.00 17.01           O  
ATOM   1539  CB  TYR   193      34.676  39.237  13.327  1.00 18.38           C  
ATOM   1540  CG  TYR   193      34.347  40.713  13.291  1.00 15.91           C  
ATOM   1541  CD1 TYR   193      33.058  41.166  13.568  1.00 20.25           C  
ATOM   1542  CD2 TYR   193      35.328  41.646  12.962  1.00 20.34           C  
ATOM   1543  CE1 TYR   193      32.761  42.513  13.536  1.00 20.52           C  
ATOM   1544  CE2 TYR   193      35.040  43.000  12.920  1.00 19.27           C  
ATOM   1545  CZ  TYR   193      33.755  43.418  13.219  1.00 16.20           C  
ATOM   1546  OH  TYR   193      33.448  44.772  13.151  1.00 20.98           O  
ATOM   1547  N   CYS   194      32.082  37.834  12.631  1.00 17.08           N  
ATOM   1548  CA  CYS   194      30.631  37.908  12.541  1.00 22.60           C  
ATOM   1549  C   CYS   194      30.028  37.871  13.931  1.00 22.09           C  
ATOM   1550  O   CYS   194      30.080  36.838  14.620  1.00 18.58           O  
ATOM   1551  CB  CYS   194      30.050  36.795  11.661  1.00 20.95           C  
ATOM   1552  SG  CYS   194      28.234  36.914  11.524  1.00 23.38           S  
ATOM   1553  N   MET   195      29.462  38.998  14.343  1.00 17.69           N  
ATOM   1554  CA  MET   195      28.851  39.085  15.673  1.00 18.41           C  
ATOM   1555  C   MET   195      27.433  39.597  15.665  1.00 20.71           C  
ATOM   1556  O   MET   195      27.045  40.381  14.778  1.00 20.17           O  
ATOM   1557  CB  MET   195      29.698  39.933  16.620  1.00 18.74           C  
ATOM   1558  CG  MET   195      29.772  41.398  16.224  1.00 25.25           C  
ATOM   1559  SD  MET   195      30.880  42.412  17.429  0.70 30.47          SE  
ATOM   1560  CE  MET   195      30.018  41.990  19.031  1.00 22.83           C  
ATOM   1561  N   GLU   196      26.663  39.172  16.666  1.00 20.84           N  
ATOM   1562  CA  GLU   196      25.352  39.749  16.911  1.00 21.64           C  
ATOM   1563  C   GLU   196      25.582  41.092  17.613  1.00 22.83           C  
ATOM   1564  O   GLU   196      26.303  41.181  18.614  1.00 20.50           O  
ATOM   1565  CB  GLU   196      24.470  38.823  17.761  1.00 21.99           C  
ATOM   1566  CG  GLU   196      23.072  39.424  17.999  1.00 28.14           C  
ATOM   1567  CD  GLU   196      22.005  38.428  18.472  1.00 27.63           C  
ATOM   1568  OE1 GLU   196      22.157  37.202  18.283  1.00 27.80           O  
ATOM   1569  OE2 GLU   196      20.982  38.917  19.004  1.00 38.54           O  
ATOM   1570  N   SER   197      24.962  42.137  17.088  1.00 20.19           N  
ATOM   1571  CA  SER   197      25.125  43.478  17.619  1.00 15.72           C  
ATOM   1572  C   SER   197      23.742  43.912  18.167  1.00 19.33           C  
ATOM   1573  O   SER   197      22.786  43.161  18.009  1.00 18.28           O  
ATOM   1574  CB  SER   197      25.552  44.410  16.490  1.00 18.24           C  
ATOM   1575  OG  SER   197      24.526  44.513  15.506  1.00 20.58           O  
ATOM   1576  N   PRO   198      23.651  45.084  18.836  1.00 19.82           N  
ATOM   1577  CA  PRO   198      22.353  45.521  19.391  1.00 25.01           C  
ATOM   1578  C   PRO   198      21.172  45.509  18.409  1.00 27.78           C  
ATOM   1579  O   PRO   198      20.049  45.138  18.784  1.00 27.26           O  
ATOM   1580  CB  PRO   198      22.640  46.948  19.858  1.00 21.66           C  
ATOM   1581  CG  PRO   198      24.110  46.942  20.199  1.00 25.92           C  
ATOM   1582  CD  PRO   198      24.735  46.026  19.187  1.00 21.79           C  
ATOM   1583  N   ALA   199      21.424  45.881  17.158  1.00 21.66           N  
ATOM   1584  CA  ALA   199      20.334  46.028  16.176  1.00 20.92           C  
ATOM   1585  C   ALA   199      20.302  44.928  15.105  1.00 27.82           C  
ATOM   1586  O   ALA   199      19.410  44.909  14.244  1.00 27.25           O  
ATOM   1587  CB  ALA   199      20.406  47.399  15.539  1.00 23.88           C  
ATOM   1588  N   GLY   200      21.269  44.016  15.139  1.00 21.47           N  
ATOM   1589  CA  GLY   200      21.257  42.919  14.178  1.00 20.08           C  
ATOM   1590  C   GLY   200      22.517  42.076  14.199  1.00 23.27           C  
ATOM   1591  O   GLY   200      22.938  41.612  15.250  1.00 23.02           O  
ATOM   1592  N   ILE   201      23.078  41.891  13.011  1.00 19.61           N  
ATOM   1593  CA  ILE   201      24.189  40.982  12.725  0.50 20.79           C  
ATOM   1595  C   ILE   201      25.253  41.788  11.991  1.00 21.52           C  
ATOM   1596  O   ILE   201      24.917  42.492  11.034  1.00 19.17           O  
ATOM   1597  CB  ILE   201      23.712  39.817  11.789  0.50 19.77           C  
ATOM   1599  CG1 ILE   201      22.825  38.828  12.545  0.50 23.67           C  
ATOM   1601  CG2 ILE   201      24.901  39.052  11.128  0.50 23.88           C  
ATOM   1603  CD1 ILE   201      23.586  37.842  13.400  0.50 30.69           C  
ATOM   1605  N   LYS   202      26.513  41.644  12.395  1.00 17.46           N  
ATOM   1606  CA  LYS   202      27.615  42.393  11.804  1.00 16.91           C  
ATOM   1607  C   LYS   202      28.686  41.412  11.283  1.00 19.03           C  
ATOM   1608  O   LYS   202      29.577  41.041  12.051  1.00 17.60           O  
ATOM   1609  CB  LYS   202      28.244  43.287  12.861  1.00 19.47           C  
ATOM   1610  CG  LYS   202      27.405  44.510  13.236  1.00 15.46           C  
ATOM   1611  CD  LYS   202      28.072  45.440  14.221  1.00 22.65           C  
ATOM   1612  CE  LYS   202      29.321  46.142  13.706  1.00 24.43           C  
ATOM   1613  NZ  LYS   202      29.066  47.055  12.516  1.00 27.31           N  
ATOM   1614  N   PRO   203      28.593  41.006   9.994  1.00 16.72           N  
ATOM   1615  CA  PRO   203      29.596  40.167   9.326  1.00 17.50           C  
ATOM   1616  C   PRO   203      30.545  41.129   8.652  1.00 18.96           C  
ATOM   1617  O   PRO   203      30.338  41.527   7.498  1.00 22.69           O  
ATOM   1618  CB  PRO   203      28.772  39.361   8.315  1.00 23.12           C  
ATOM   1619  CG  PRO   203      27.382  40.061   8.235  1.00 20.40           C  
ATOM   1620  CD  PRO   203      27.492  41.331   9.070  1.00 16.33           C  
ATOM   1621  N   ASP   204      31.554  41.558   9.391  1.00 14.49           N  
ATOM   1622  CA  ASP   204      32.398  42.684   8.939  1.00 18.90           C  
ATOM   1623  C   ASP   204      33.757  42.241   8.446  1.00 19.68           C  
ATOM   1624  O   ASP   204      34.325  41.264   8.944  1.00 19.53           O  
ATOM   1625  CB  ASP   204      32.610  43.701  10.053  1.00 17.03           C  
ATOM   1626  CG  ASP   204      31.314  44.405  10.487  1.00 21.45           C  
ATOM   1627  OD1 ASP   204      30.277  44.283   9.809  1.00 24.51           O  
ATOM   1628  OD2 ASP   204      31.358  45.071  11.528  1.00 25.88           O  
ATOM   1629  N   THR   205      34.267  42.983   7.469  1.00 16.49           N  
ATOM   1630  CA  THR   205      35.645  42.835   6.979  1.00 18.97           C  
ATOM   1631  C   THR   205      36.391  44.138   7.145  1.00 22.03           C  
ATOM   1632  O   THR   205      35.931  45.179   6.680  1.00 20.97           O  
ATOM   1633  CB  THR   205      35.650  42.381   5.527  1.00 20.97           C  
ATOM   1634  OG1 THR   205      35.084  41.066   5.454  1.00 18.93           O  
ATOM   1635  CG2 THR   205      37.050  42.330   4.966  1.00 18.62           C  
ATOM   1636  N   LEU   206      37.530  44.089   7.834  1.00 17.58           N  
ATOM   1637  CA  LEU   206      38.394  45.264   8.026  1.00 17.07           C  
ATOM   1638  C   LEU   206      39.632  45.098   7.186  1.00 19.34           C  
ATOM   1639  O   LEU   206      40.434  44.205   7.447  1.00 19.57           O  
ATOM   1640  CB  LEU   206      38.815  45.454   9.519  1.00 19.70           C  
ATOM   1641  CG  LEU   206      37.830  45.184  10.672  1.00 30.19           C  
ATOM   1642  CD1 LEU   206      38.456  45.413  12.051  1.00 30.63           C  
ATOM   1643  CD2 LEU   206      36.637  46.012  10.534  1.00 34.18           C  
ATOM   1644  N   PHE   207      39.797  45.960   6.190  1.00 15.14           N  
ATOM   1645  CA  PHE   207      41.012  45.982   5.403  1.00 14.18           C  
ATOM   1646  C   PHE   207      42.077  46.767   6.142  1.00 15.69           C  
ATOM   1647  O   PHE   207      41.870  47.911   6.555  1.00 19.26           O  
ATOM   1648  CB  PHE   207      40.737  46.514   3.988  1.00 15.92           C  
ATOM   1649  CG  PHE   207      39.840  45.607   3.185  1.00 19.36           C  
ATOM   1650  CD1 PHE   207      40.348  44.442   2.573  1.00 17.29           C  
ATOM   1651  CD2 PHE   207      38.484  45.899   3.052  1.00 16.61           C  
ATOM   1652  CE1 PHE   207      39.502  43.583   1.817  1.00 15.95           C  
ATOM   1653  CE2 PHE   207      37.653  45.048   2.310  1.00 18.64           C  
ATOM   1654  CZ  PHE   207      38.160  43.894   1.703  1.00 21.53           C  
ATOM   1655  N   LEU   208      43.247  46.163   6.259  1.00 16.02           N  
ATOM   1656  CA  LEU   208      44.265  46.699   7.147  1.00 16.18           C  
ATOM   1657  C   LEU   208      45.422  47.286   6.362  1.00 15.99           C  
ATOM   1658  O   LEU   208      45.801  46.761   5.317  1.00 17.80           O  
ATOM   1659  CB  LEU   208      44.773  45.584   8.056  1.00 17.30           C  
ATOM   1660  CG  LEU   208      43.666  44.740   8.702  1.00 21.82           C  
ATOM   1661  CD1 LEU   208      44.249  43.562   9.423  1.00 24.62           C  
ATOM   1662  CD2 LEU   208      42.840  45.588   9.656  1.00 21.41           C  
ATOM   1663  N   TYR   209      45.954  48.390   6.877  1.00 16.64           N  
ATOM   1664  CA  TYR   209      47.074  49.114   6.254  1.00 13.20           C  
ATOM   1665  C   TYR   209      48.103  49.478   7.319  1.00 18.91           C  
ATOM   1666  O   TYR   209      47.733  49.720   8.469  1.00 17.11           O  
ATOM   1667  CB  TYR   209      46.541  50.406   5.583  1.00 19.14           C  
ATOM   1668  CG  TYR   209      45.645  50.126   4.407  1.00 14.54           C  
ATOM   1669  CD1 TYR   209      46.130  50.167   3.107  1.00 16.75           C  
ATOM   1670  CD2 TYR   209      44.278  49.801   4.595  1.00 21.68           C  
ATOM   1671  CE1 TYR   209      45.281  49.903   1.991  1.00 21.68           C  
ATOM   1672  CE2 TYR   209      43.439  49.519   3.496  1.00 21.31           C  
ATOM   1673  CZ  TYR   209      43.959  49.570   2.209  1.00 20.17           C  
ATOM   1674  OH  TYR   209      43.129  49.283   1.152  1.00 21.68           O  
ATOM   1675  N   ASP   210      49.384  49.472   6.942  1.00 17.51           N  
ATOM   1676  CA  ASP   210      50.474  49.899   7.816  1.00 20.05           C  
ATOM   1677  C   ASP   210      51.129  51.115   7.175  1.00 19.12           C  
ATOM   1678  O   ASP   210      51.344  51.150   5.939  1.00 21.30           O  
ATOM   1679  CB  ASP   210      51.578  48.821   7.908  1.00 17.73           C  
ATOM   1680  CG  ASP   210      51.330  47.777   8.969  1.00 23.66           C  
ATOM   1681  OD1 ASP   210      50.234  47.740   9.580  1.00 19.71           O  
ATOM   1682  OD2 ASP   210      52.246  46.941   9.154  1.00 19.66           O  
ATOM   1683  N   LEU   211      51.483  52.081   8.014  1.00 21.44           N  
ATOM   1684  CA  LEU   211      52.293  53.218   7.583  1.00 19.60           C  
ATOM   1685  C   LEU   211      53.371  53.590   8.618  1.00 28.52           C  
ATOM   1686  O   LEU   211      53.047  53.917   9.773  1.00 25.01           O  
ATOM   1687  CB  LEU   211      51.396  54.433   7.289  1.00 21.33           C  
ATOM   1688  CG  LEU   211      52.079  55.711   6.778  1.00 23.75           C  
ATOM   1689  CD1 LEU   211      52.892  55.427   5.515  1.00 28.56           C  
ATOM   1690  CD2 LEU   211      51.050  56.768   6.486  1.00 21.28           C  
ATOM   1691  N   ALA   212      54.636  53.535   8.184  1.00 24.81           N  
ATOM   1692  CA  ALA   212      55.787  54.018   8.964  1.00 29.85           C  
ATOM   1693  C   ALA   212      55.828  55.527   8.798  1.00 29.57           C  
ATOM   1694  O   ALA   212      56.058  56.036   7.697  1.00 32.92           O  
ATOM   1695  CB  ALA   212      57.068  53.405   8.459  1.00 27.38           C  
ATOM   1696  N   LEU   213      55.551  56.239   9.876  1.00 25.42           N  
ATOM   1697  CA  LEU   213      55.416  57.697   9.832  1.00 25.21           C  
ATOM   1698  C   LEU   213      56.746  58.407  10.143  1.00 33.84           C  
ATOM   1699  O   LEU   213      57.605  57.834  10.822  1.00 36.56           O  
ATOM   1700  CB  LEU   213      54.344  58.147  10.814  1.00 25.79           C  
ATOM   1701  CG  LEU   213      52.903  57.810  10.408  1.00 27.39           C  
ATOM   1702  CD1 LEU   213      51.998  57.831  11.609  1.00 22.21           C  
ATOM   1703  CD2 LEU   213      52.419  58.783   9.358  1.00 32.76           C  
ATOM   1704  N   PRO   214      56.921  59.654   9.646  1.00 36.16           N  
ATOM   1705  CA  PRO   214      58.100  60.427  10.057  1.00 39.31           C  
ATOM   1706  C   PRO   214      58.066  60.728  11.559  1.00 34.96           C  
ATOM   1707  O   PRO   214      56.983  60.938  12.125  1.00 32.07           O  
ATOM   1708  CB  PRO   214      57.956  61.741   9.269  1.00 37.83           C  
ATOM   1709  CG  PRO   214      57.019  61.437   8.155  1.00 42.05           C  
ATOM   1710  CD  PRO   214      56.072  60.421   8.720  1.00 34.03           C  
ATOM   1711  N   GLU   215      59.244  60.772  12.182  1.00 38.88           N  
ATOM   1712  CA  GLU   215      59.400  61.115  13.605  1.00 42.52           C  
ATOM   1713  C   GLU   215      58.699  62.427  13.981  1.00 40.78           C  
ATOM   1714  O   GLU   215      58.184  62.559  15.092  1.00 41.45           O  
ATOM   1715  CB  GLU   215      60.889  61.205  13.984  1.00 47.40           C  
ATOM   1716  CG  GLU   215      61.675  59.879  13.903  1.00 61.85           C  
ATOM   1717  CD  GLU   215      61.590  59.037  15.173  1.00 71.62           C  
ATOM   1718  OE1 GLU   215      61.330  59.612  16.254  1.00 77.66           O  
ATOM   1719  OE2 GLU   215      61.789  57.799  15.091  1.00 66.95           O  
ATOM   1720  N   ASP   216      58.667  63.374  13.043  1.00 40.78           N  
ATOM   1721  CA  ASP   216      58.096  64.696  13.291  1.00 42.30           C  
ATOM   1722  C   ASP   216      56.617  64.850  12.910  1.00 42.05           C  
ATOM   1723  O   ASP   216      56.042  65.911  13.149  1.00 40.61           O  
ATOM   1724  CB  ASP   216      58.958  65.813  12.665  1.00 47.09           C  
ATOM   1725  CG  ASP   216      58.932  65.811  11.131  1.00 58.78           C  
ATOM   1726  OD1 ASP   216      58.804  64.731  10.514  1.00 70.12           O  
ATOM   1727  OD2 ASP   216      59.056  66.903  10.535  1.00 58.84           O  
ATOM   1728  N   PHE   217      55.990  63.813  12.342  1.00 33.84           N  
ATOM   1729  CA  PHE   217      54.531  63.879  12.124  1.00 28.76           C  
ATOM   1730  C   PHE   217      53.736  63.857  13.447  1.00 28.64           C  
ATOM   1731  O   PHE   217      54.063  63.107  14.375  1.00 33.24           O  
ATOM   1732  CB  PHE   217      54.032  62.756  11.171  1.00 31.39           C  
ATOM   1733  CG  PHE   217      52.537  62.770  10.970  1.00 34.89           C  
ATOM   1734  CD1 PHE   217      51.953  63.682  10.090  1.00 31.80           C  
ATOM   1735  CD2 PHE   217      51.708  61.919  11.707  1.00 30.13           C  
ATOM   1736  CE1 PHE   217      50.574  63.734   9.928  1.00 35.26           C  
ATOM   1737  CE2 PHE   217      50.343  61.968  11.554  1.00 26.65           C  
ATOM   1738  CZ  PHE   217      49.767  62.879  10.664  1.00 30.87           C  
ATOM   1739  N   ARG   218      52.701  64.691  13.531  1.00 30.24           N  
ATOM   1740  CA  ARG   218      51.765  64.675  14.649  1.00 33.07           C  
ATOM   1741  C   ARG   218      50.362  64.664  14.087  1.00 33.27           C  
ATOM   1742  O   ARG   218      50.005  65.570  13.349  1.00 30.02           O  
ATOM   1743  CB  ARG   218      51.913  65.918  15.548  1.00 36.17           C  
ATOM   1744  CG  ARG   218      53.292  66.156  16.149  1.00 38.66           C  
ATOM   1745  CD  ARG   218      53.636  65.164  17.279  1.00 44.01           C  
ATOM   1746  NE  ARG   218      54.971  65.428  17.825  1.00 50.41           N  
ATOM   1747  CZ  ARG   218      56.105  64.916  17.348  1.00 48.17           C  
ATOM   1748  NH1 ARG   218      56.091  64.081  16.319  1.00 53.09           N  
ATOM   1749  NH2 ARG   218      57.263  65.226  17.916  1.00 52.78           N  
ATOM   1750  N   PRO   219      49.551  63.642  14.425  1.00 32.18           N  
ATOM   1751  CA  PRO   219      48.154  63.704  13.986  1.00 28.77           C  
ATOM   1752  C   PRO   219      47.327  64.817  14.674  1.00 35.00           C  
ATOM   1753  O   PRO   219      47.516  65.087  15.867  1.00 35.22           O  
ATOM   1754  CB  PRO   219      47.602  62.299  14.338  1.00 26.16           C  
ATOM   1755  CG  PRO   219      48.499  61.797  15.400  1.00 29.84           C  
ATOM   1756  CD  PRO   219      49.859  62.389  15.144  1.00 29.45           C  
ATOM   1757  N   HIS   220      46.438  65.469  13.920  1.00 30.48           N  
ATOM   1758  CA  HIS   220      45.476  66.413  14.512  1.00 32.09           C  
ATOM   1759  C   HIS   220      44.077  66.058  14.111  1.00 30.14           C  
ATOM   1760  O   HIS   220      43.835  65.693  12.971  1.00 30.55           O  
ATOM   1761  CB  HIS   220      45.781  67.860  14.106  1.00 37.92           C  
ATOM   1762  CG  HIS   220      47.209  68.246  14.322  1.00 41.04           C  
ATOM   1763  ND1 HIS   220      48.122  68.330  13.293  1.00 50.01           N  
ATOM   1764  CD2 HIS   220      47.894  68.530  15.457  1.00 45.11           C  
ATOM   1765  CE1 HIS   220      49.305  68.660  13.781  1.00 40.41           C  
ATOM   1766  NE2 HIS   220      49.194  68.786  15.092  1.00 44.64           N  
ATOM   1767  N   ASN   221      43.153  66.229  15.047  1.00 25.59           N  
ATOM   1768  CA  ASN   221      41.767  65.783  14.921  1.00 31.42           C  
ATOM   1769  C   ASN   221      40.854  66.733  14.118  1.00 34.72           C  
ATOM   1770  O   ASN   221      39.805  67.183  14.617  1.00 40.74           O  
ATOM   1771  CB  ASN   221      41.192  65.500  16.330  1.00 32.04           C  
ATOM   1772  CG  ASN   221      41.034  66.778  17.195  1.00 41.90           C  
ATOM   1773  OD1 ASN   221      41.773  67.752  17.028  1.00 42.49           O  
ATOM   1774  ND2 ASN   221      40.056  66.768  18.105  1.00 30.00           N  
ATOM   1775  N   THR   222      41.229  66.990  12.866  1.00 34.65           N  
ATOM   1776  CA  THR   222      40.516  67.939  11.978  1.00 37.42           C  
ATOM   1777  C   THR   222      38.978  67.898  12.029  1.00 39.37           C  
ATOM   1778  O   THR   222      38.344  68.925  12.252  1.00 40.20           O  
ATOM   1779  CB  THR   222      41.007  67.833  10.506  1.00 40.30           C  
ATOM   1780  OG1 THR   222      42.441  67.862  10.475  1.00 38.41           O  
ATOM   1781  CG2 THR   222      40.467  68.991   9.654  1.00 37.82           C  
ATOM   1782  N   ASP   223      38.375  66.725  11.856  1.00 33.08           N  
ATOM   1783  CA  ASP   223      36.914  66.646  11.873  1.00 36.16           C  
ATOM   1784  C   ASP   223      36.279  66.357  13.243  1.00 36.45           C  
ATOM   1785  O   ASP   223      35.053  66.241  13.343  1.00 38.37           O  
ATOM   1786  CB  ASP   223      36.392  65.690  10.786  1.00 37.98           C  
ATOM   1787  CG  ASP   223      36.618  64.223  11.118  1.00 42.50           C  
ATOM   1788  OD1 ASP   223      37.293  63.886  12.122  1.00 34.80           O  
ATOM   1789  OD2 ASP   223      36.106  63.402  10.344  1.00 36.90           O  
ATOM   1790  N   GLY   224      37.111  66.244  14.282  1.00 35.55           N  
ATOM   1791  CA  GLY   224      36.630  66.034  15.654  1.00 36.89           C  
ATOM   1792  C   GLY   224      36.020  64.671  15.976  1.00 36.39           C  
ATOM   1793  O   GLY   224      35.449  64.482  17.054  1.00 40.38           O  
ATOM   1794  N   GLU   225      36.125  63.723  15.042  1.00 32.74           N  
ATOM   1795  CA  GLU   225      35.722  62.336  15.276  1.00 33.39           C  
ATOM   1796  C   GLU   225      36.597  61.697  16.367  1.00 31.95           C  
ATOM   1797  O   GLU   225      36.143  60.836  17.113  1.00 26.70           O  
ATOM   1798  CB  GLU   225      35.884  61.520  13.996  1.00 34.72           C  
ATOM   1799  CG  GLU   225      34.769  61.677  12.971  1.00 35.77           C  
ATOM   1800  CD  GLU   225      34.913  60.657  11.831  1.00 48.02           C  
ATOM   1801  OE1 GLU   225      34.275  59.583  11.894  1.00 36.79           O  
ATOM   1802  OE2 GLU   225      35.692  60.911  10.885  1.00 46.05           O  
ATOM   1803  N   MET   226      37.861  62.104  16.409  1.00 30.60           N  
ATOM   1804  CA  MET   226      38.780  61.764  17.497  1.00 33.62           C  
ATOM   1805  C   MET   226      38.879  62.927  18.495  1.00 35.35           C  
ATOM   1806  O   MET   226      39.017  64.078  18.089  1.00 34.95           O  
ATOM   1807  CB  MET   226      40.182  61.499  16.949  1.00 30.26           C  
ATOM   1808  CG  MET   226      40.305  60.311  16.011  1.00 38.22           C  
ATOM   1809  SD  MET   226      39.791  58.599  16.819  0.70 33.77          SE  
ATOM   1810  CE  MET   226      40.212  57.510  15.238  1.00 43.66           C  
ATOM   1811  N   ALA   227      38.835  62.611  19.788  1.00 30.11           N  
ATOM   1812  CA  ALA   227      39.070  63.585  20.851  1.00 30.34           C  
ATOM   1813  C   ALA   227      40.531  64.052  20.907  1.00 38.31           C  
ATOM   1814  O   ALA   227      40.797  65.253  21.065  1.00 39.38           O  
ATOM   1815  CB  ALA   227      38.624  63.028  22.201  1.00 32.23           C  
ATOM   1816  N   ASP   228      41.459  63.100  20.764  1.00 29.95           N  
ATOM   1817  CA  ASP   228      42.897  63.383  20.736  0.50 32.07           C  
ATOM   1819  C   ASP   228      43.640  62.133  20.291  1.00 31.14           C  
ATOM   1820  O   ASP   228      43.016  61.111  19.979  1.00 30.62           O  
ATOM   1821  CB  ASP   228      43.422  63.840  22.108  0.50 37.97           C  
ATOM   1823  CG  ASP   228      43.307  62.764  23.162  0.50 37.14           C  
ATOM   1825  OD1 ASP   228      42.167  62.425  23.532  0.50 39.67           O  
ATOM   1827  OD2 ASP   228      44.356  62.264  23.619  0.50 48.07           O  
ATOM   1829  N   PHE   229      44.961  62.237  20.221  1.00 23.57           N  
ATOM   1830  CA  PHE   229      45.842  61.157  19.805  1.00 28.22           C  
ATOM   1831  C   PHE   229      46.978  60.986  20.814  1.00 32.28           C  
ATOM   1832  O   PHE   229      47.356  61.956  21.464  1.00 29.69           O  
ATOM   1833  CB  PHE   229      46.454  61.481  18.450  1.00 27.21           C  
ATOM   1834  CG  PHE   229      45.462  61.500  17.324  1.00 28.89           C  
ATOM   1835  CD1 PHE   229      45.107  60.316  16.674  1.00 25.77           C  
ATOM   1836  CD2 PHE   229      44.905  62.698  16.895  1.00 29.22           C  
ATOM   1837  CE1 PHE   229      44.203  60.321  15.640  1.00 25.83           C  
ATOM   1838  CE2 PHE   229      43.985  62.718  15.846  1.00 29.84           C  
ATOM   1839  CZ  PHE   229      43.626  61.523  15.225  1.00 23.27           C  
ATOM   1840  N   MET   230      47.504  59.761  20.943  1.00 30.54           N  
ATOM   1841  CA  MET   230      48.633  59.475  21.839  0.50 31.97           C  
ATOM   1843  C   MET   230      49.613  58.548  21.148  1.00 32.95           C  
ATOM   1844  O   MET   230      49.212  57.668  20.384  1.00 30.38           O  
ATOM   1845  CB  MET   230      48.170  58.804  23.139  0.50 29.98           C  
ATOM   1847  CG  MET   230      47.326  59.655  24.086  0.50 30.10           C  
ATOM   1849  SD  MET   230      46.461  58.547  25.462  0.35 35.81          SE  
ATOM   1851  CE  MET   230      45.786  57.198  24.278  0.50  9.41           C  
ATOM   1853  N   LEU   231      50.903  58.740  21.417  1.00 26.63           N  
ATOM   1854  CA  LEU   231      51.928  57.875  20.870  1.00 24.90           C  
ATOM   1855  C   LEU   231      52.402  56.944  21.983  1.00 32.60           C  
ATOM   1856  O   LEU   231      52.984  57.400  22.973  1.00 27.40           O  
ATOM   1857  CB  LEU   231      53.092  58.697  20.318  1.00 22.14           C  
ATOM   1858  CG  LEU   231      54.213  57.917  19.627  1.00 27.92           C  
ATOM   1859  CD1 LEU   231      53.690  57.195  18.374  1.00 31.77           C  
ATOM   1860  CD2 LEU   231      55.354  58.858  19.235  1.00 34.90           C  
ATOM   1861  N   TRP   232      52.153  55.643  21.825  1.00 26.63           N  
ATOM   1862  CA  TRP   232      52.468  54.657  22.873  1.00 27.49           C  
ATOM   1863  C   TRP   232      53.463  53.641  22.351  1.00 24.44           C  
ATOM   1864  O   TRP   232      53.424  53.335  21.153  1.00 24.35           O  
ATOM   1865  CB  TRP   232      51.214  53.888  23.242  1.00 25.56           C  
ATOM   1866  CG  TRP   232      50.254  54.542  24.163  1.00 33.99           C  
ATOM   1867  CD1 TRP   232      50.243  55.857  24.583  1.00 30.32           C  
ATOM   1868  CD2 TRP   232      49.111  53.920  24.754  1.00 30.78           C  
ATOM   1869  NE1 TRP   232      49.172  56.067  25.416  1.00 28.93           N  
ATOM   1870  CE2 TRP   232      48.459  54.899  25.537  1.00 33.17           C  
ATOM   1871  CE3 TRP   232      48.592  52.611  24.734  1.00 25.26           C  
ATOM   1872  CZ2 TRP   232      47.301  54.615  26.278  1.00 33.10           C  
ATOM   1873  CZ3 TRP   232      47.429  52.341  25.462  1.00 31.07           C  
ATOM   1874  CH2 TRP   232      46.803  53.334  26.220  1.00 29.08           C  
ATOM   1875  N   PRO   233      54.330  53.081  23.229  1.00 25.37           N  
ATOM   1876  CA  PRO   233      55.152  51.969  22.783  1.00 26.06           C  
ATOM   1877  C   PRO   233      54.231  50.848  22.323  1.00 24.38           C  
ATOM   1878  O   PRO   233      53.160  50.647  22.927  1.00 22.96           O  
ATOM   1879  CB  PRO   233      55.902  51.547  24.060  1.00 29.18           C  
ATOM   1880  CG  PRO   233      55.941  52.785  24.901  1.00 28.56           C  
ATOM   1881  CD  PRO   233      54.598  53.424  24.647  1.00 28.32           C  
ATOM   1882  N   ALA   234      54.615  50.163  21.250  1.00 23.20           N  
ATOM   1883  CA  ALA   234      53.779  49.101  20.681  1.00 25.59           C  
ATOM   1884  C   ALA   234      53.388  48.077  21.749  1.00 22.71           C  
ATOM   1885  O   ALA   234      52.225  47.682  21.809  1.00 21.44           O  
ATOM   1886  CB  ALA   234      54.464  48.417  19.496  1.00 27.69           C  
ATOM   1887  N   ALA   235      54.338  47.677  22.603  1.00 25.08           N  
ATOM   1888  CA  ALA   235      54.065  46.687  23.659  1.00 23.69           C  
ATOM   1889  C   ALA   235      52.959  47.126  24.629  1.00 24.83           C  
ATOM   1890  O   ALA   235      52.156  46.305  25.065  1.00 23.63           O  
ATOM   1891  CB  ALA   235      55.343  46.309  24.415  1.00 29.81           C  
ATOM   1892  N   LYS   236      52.898  48.420  24.935  1.00 24.16           N  
ATOM   1893  CA  LYS   236      51.849  48.978  25.790  1.00 27.58           C  
ATOM   1894  C   LYS   236      50.451  48.847  25.143  1.00 21.12           C  
ATOM   1895  O   LYS   236      49.450  48.578  25.825  1.00 22.07           O  
ATOM   1896  CB  LYS   236      52.180  50.448  26.117  1.00 26.72           C  
ATOM   1897  CG  LYS   236      51.190  51.123  27.037  1.00 30.02           C  
ATOM   1898  CD  LYS   236      51.459  52.607  27.212  1.00 37.84           C  
ATOM   1899  CE  LYS   236      50.410  53.245  28.131  1.00 45.71           C  
ATOM   1900  NZ  LYS   236      50.697  54.688  28.391  1.00 44.63           N  
ATOM   1901  N   VAL   237      50.386  49.019  23.816  1.00 21.52           N  
ATOM   1902  CA  VAL   237      49.122  48.858  23.075  1.00 19.23           C  
ATOM   1903  C   VAL   237      48.692  47.392  23.125  1.00 17.87           C  
ATOM   1904  O   VAL   237      47.555  47.073  23.417  1.00 19.86           O  
ATOM   1905  CB  VAL   237      49.262  49.352  21.594  1.00 21.36           C  
ATOM   1906  CG1 VAL   237      47.994  49.054  20.745  1.00 21.80           C  
ATOM   1907  CG2 VAL   237      49.561  50.862  21.578  1.00 19.94           C  
ATOM   1908  N   VAL   238      49.638  46.515  22.828  1.00 15.89           N  
ATOM   1909  CA  VAL   238      49.356  45.083  22.794  1.00 17.55           C  
ATOM   1910  C   VAL   238      48.889  44.625  24.185  1.00 18.38           C  
ATOM   1911  O   VAL   238      47.898  43.906  24.296  1.00 17.12           O  
ATOM   1912  CB  VAL   238      50.579  44.302  22.299  1.00 20.65           C  
ATOM   1913  CG1 VAL   238      50.349  42.779  22.475  1.00 17.40           C  
ATOM   1914  CG2 VAL   238      50.879  44.646  20.838  1.00 22.23           C  
ATOM   1915  N   GLU   239      49.575  45.053  25.254  1.00 20.45           N  
ATOM   1916  CA  GLU   239      49.154  44.644  26.606  1.00 19.51           C  
ATOM   1917  C   GLU   239      47.828  45.270  27.046  1.00 17.58           C  
ATOM   1918  O   GLU   239      47.054  44.633  27.746  1.00 19.73           O  
ATOM   1919  CB  GLU   239      50.231  44.906  27.659  1.00 18.69           C  
ATOM   1920  CG  GLU   239      51.537  44.178  27.372  1.00 18.82           C  
ATOM   1921  CD  GLU   239      51.459  42.647  27.407  1.00 23.22           C  
ATOM   1922  OE1 GLU   239      50.465  42.043  27.875  1.00 29.15           O  
ATOM   1923  OE2 GLU   239      52.440  42.036  26.965  1.00 26.04           O  
ATOM   1924  N   ALA   240      47.560  46.498  26.609  1.00 18.60           N  
ATOM   1925  CA  ALA   240      46.227  47.090  26.833  1.00 18.75           C  
ATOM   1926  C   ALA   240      45.097  46.233  26.209  1.00 21.18           C  
ATOM   1927  O   ALA   240      44.067  46.000  26.831  1.00 17.62           O  
ATOM   1928  CB  ALA   240      46.183  48.550  26.332  1.00 18.84           C  
ATOM   1929  N   VAL   241      45.310  45.713  25.002  1.00 19.17           N  
ATOM   1930  CA  VAL   241      44.324  44.848  24.381  1.00 16.76           C  
ATOM   1931  C   VAL   241      44.267  43.498  25.112  1.00 15.47           C  
ATOM   1932  O   VAL   241      43.178  42.958  25.346  1.00 18.92           O  
ATOM   1933  CB  VAL   241      44.643  44.686  22.855  1.00 20.22           C  
ATOM   1934  CG1 VAL   241      43.787  43.559  22.183  1.00 17.92           C  
ATOM   1935  CG2 VAL   241      44.413  46.033  22.172  1.00 14.08           C  
ATOM   1936  N   ARG   242      45.422  42.960  25.515  1.00 14.46           N  
ATOM   1937  CA  ARG   242      45.425  41.642  26.181  1.00 16.30           C  
ATOM   1938  C   ARG   242      44.592  41.660  27.459  1.00 18.93           C  
ATOM   1939  O   ARG   242      43.795  40.741  27.716  1.00 21.27           O  
ATOM   1940  CB  ARG   242      46.864  41.171  26.494  1.00 15.30           C  
ATOM   1941  CG  ARG   242      46.889  39.763  27.067  1.00 16.78           C  
ATOM   1942  CD  ARG   242      48.226  39.519  27.784  1.00 22.29           C  
ATOM   1943  NE  ARG   242      49.335  39.487  26.843  1.00 20.03           N  
ATOM   1944  CZ  ARG   242      49.637  38.449  26.058  1.00 21.15           C  
ATOM   1945  NH1 ARG   242      48.907  37.328  26.050  1.00 21.56           N  
ATOM   1946  NH2 ARG   242      50.687  38.534  25.272  1.00 19.17           N  
ATOM   1947  N   THR   243      44.715  42.746  28.226  1.00 18.75           N  
ATOM   1948  CA  THR   243      44.213  42.720  29.582  1.00 20.29           C  
ATOM   1949  C   THR   243      43.134  43.725  29.948  1.00 20.77           C  
ATOM   1950  O   THR   243      42.682  43.716  31.088  1.00 20.63           O  
ATOM   1951  CB  THR   243      45.375  42.827  30.613  1.00 23.74           C  
ATOM   1952  OG1 THR   243      46.034  44.069  30.452  1.00 29.54           O  
ATOM   1953  CG2 THR   243      46.376  41.733  30.398  1.00 27.63           C  
ATOM   1954  N   THR   244      42.724  44.592  29.014  1.00 19.31           N  
ATOM   1955  CA  THR   244      41.730  45.624  29.312  1.00 20.53           C  
ATOM   1956  C   THR   244      40.672  45.705  28.197  1.00 24.18           C  
ATOM   1957  O   THR   244      40.803  45.067  27.141  1.00 19.20           O  
ATOM   1958  CB  THR   244      42.349  47.061  29.504  1.00 21.98           C  
ATOM   1959  OG1 THR   244      42.659  47.636  28.232  1.00 20.95           O  
ATOM   1960  CG2 THR   244      43.608  47.072  30.385  1.00 22.52           C  
ATOM   1961  N   GLU   245      39.649  46.532  28.423  1.00 22.28           N  
ATOM   1962  CA  GLU   245      38.659  46.803  27.380  1.00 21.28           C  
ATOM   1963  C   GLU   245      38.762  48.249  26.933  1.00 22.53           C  
ATOM   1964  O   GLU   245      37.759  48.847  26.603  1.00 22.94           O  
ATOM   1965  CB  GLU   245      37.243  46.518  27.900  1.00 25.72           C  
ATOM   1966  CG  GLU   245      37.013  45.108  28.390  1.00 29.04           C  
ATOM   1967  CD  GLU   245      36.556  44.167  27.293  1.00 39.66           C  
ATOM   1968  OE1 GLU   245      36.793  44.438  26.084  1.00 43.88           O  
ATOM   1969  OE2 GLU   245      35.930  43.148  27.639  1.00 34.03           O  
ATOM   1970  N   ALA   246      39.976  48.799  26.936  1.00 18.23           N  
ATOM   1971  CA  ALA   246      40.195  50.198  26.597  1.00 23.71           C  
ATOM   1972  C   ALA   246      39.887  50.482  25.118  1.00 25.82           C  
ATOM   1973  O   ALA   246      39.454  51.582  24.780  1.00 23.44           O  
ATOM   1974  CB  ALA   246      41.633  50.571  26.876  1.00 21.63           C  
ATOM   1975  N   PHE   247      40.124  49.490  24.248  1.00 20.81           N  
ATOM   1976  CA  PHE   247      39.980  49.691  22.795  1.00 20.54           C  
ATOM   1977  C   PHE   247      38.572  49.387  22.298  1.00 21.57           C  
ATOM   1978  O   PHE   247      37.861  48.501  22.835  1.00 21.62           O  
ATOM   1979  CB  PHE   247      41.037  48.883  22.019  1.00 17.15           C  
ATOM   1980  CG  PHE   247      42.407  49.520  22.021  1.00 24.57           C  
ATOM   1981  CD1 PHE   247      42.832  50.293  20.932  1.00 22.20           C  
ATOM   1982  CD2 PHE   247      43.256  49.386  23.128  1.00 20.78           C  
ATOM   1983  CE1 PHE   247      44.094  50.901  20.935  1.00 24.41           C  
ATOM   1984  CE2 PHE   247      44.516  49.983  23.134  1.00 24.91           C  
ATOM   1985  CZ  PHE   247      44.928  50.753  22.045  1.00 21.88           C  
ATOM   1986  N   LYS   248      38.157  50.113  21.258  1.00 19.66           N  
ATOM   1987  CA  LYS   248      36.895  49.781  20.572  1.00 15.71           C  
ATOM   1988  C   LYS   248      36.908  48.307  20.192  1.00 17.36           C  
ATOM   1989  O   LYS   248      37.957  47.775  19.831  1.00 16.16           O  
ATOM   1990  CB  LYS   248      36.785  50.665  19.313  1.00 20.31           C  
ATOM   1991  CG  LYS   248      35.653  50.308  18.350  1.00 19.58           C  
ATOM   1992  CD  LYS   248      35.383  51.525  17.446  1.00 20.79           C  
ATOM   1993  CE  LYS   248      34.446  51.169  16.277  1.00 19.70           C  
ATOM   1994  NZ  LYS   248      35.252  50.527  15.166  1.00 22.92           N  
ATOM   1995  N   PHE   249      35.758  47.644  20.279  1.00 16.33           N  
ATOM   1996  CA  PHE   249      35.678  46.156  20.219  1.00 16.95           C  
ATOM   1997  C   PHE   249      36.470  45.499  19.069  1.00 17.92           C  
ATOM   1998  O   PHE   249      37.251  44.547  19.278  1.00 20.40           O  
ATOM   1999  CB  PHE   249      34.203  45.693  20.232  1.00 17.22           C  
ATOM   2000  CG  PHE   249      33.419  46.084  18.995  1.00 27.57           C  
ATOM   2001  CD1 PHE   249      33.226  45.166  17.948  1.00 23.89           C  
ATOM   2002  CD2 PHE   249      32.841  47.348  18.884  1.00 34.84           C  
ATOM   2003  CE1 PHE   249      32.526  45.533  16.794  1.00 24.40           C  
ATOM   2004  CE2 PHE   249      32.121  47.707  17.741  1.00 29.75           C  
ATOM   2005  CZ  PHE   249      31.971  46.811  16.697  1.00 29.91           C  
ATOM   2006  N   ASN   250      36.319  46.021  17.857  1.00 17.89           N  
ATOM   2007  CA  ASN   250      36.948  45.377  16.717  1.00 18.87           C  
ATOM   2008  C   ASN   250      38.357  45.863  16.478  1.00 19.30           C  
ATOM   2009  O   ASN   250      39.125  45.186  15.831  1.00 17.61           O  
ATOM   2010  CB  ASN   250      36.074  45.436  15.463  1.00 19.36           C  
ATOM   2011  CG  ASN   250      35.623  46.859  15.113  1.00 26.18           C  
ATOM   2012  OD1 ASN   250      36.006  47.833  15.762  1.00 21.97           O  
ATOM   2013  ND2 ASN   250      34.794  46.966  14.082  1.00 23.76           N  
ATOM   2014  N   VAL   251      38.705  47.014  17.053  1.00 17.26           N  
ATOM   2015  CA  VAL   251      40.090  47.489  17.021  1.00 17.67           C  
ATOM   2016  C   VAL   251      41.045  46.546  17.793  1.00 15.70           C  
ATOM   2017  O   VAL   251      42.209  46.395  17.416  1.00 20.55           O  
ATOM   2018  CB  VAL   251      40.213  48.959  17.474  1.00 18.07           C  
ATOM   2019  CG1 VAL   251      41.693  49.419  17.429  1.00 19.60           C  
ATOM   2020  CG2 VAL   251      39.326  49.855  16.598  1.00 20.52           C  
ATOM   2021  N   ASN   252      40.554  45.898  18.853  1.00 16.54           N  
ATOM   2022  CA  ASN   252      41.300  44.796  19.520  1.00 19.17           C  
ATOM   2023  C   ASN   252      41.835  43.794  18.486  1.00 17.97           C  
ATOM   2024  O   ASN   252      43.016  43.390  18.550  1.00 13.67           O  
ATOM   2025  CB  ASN   252      40.427  44.044  20.518  1.00 16.95           C  
ATOM   2026  CG  ASN   252      40.085  44.874  21.712  1.00 21.39           C  
ATOM   2027  OD1 ASN   252      40.966  45.357  22.403  1.00 21.20           O  
ATOM   2028  ND2 ASN   252      38.796  45.077  21.939  1.00 18.46           N  
ATOM   2029  N   LEU   253      40.979  43.415  17.544  1.00 16.65           N  
ATOM   2030  CA  LEU   253      41.404  42.493  16.468  1.00 19.56           C  
ATOM   2031  C   LEU   253      42.543  43.033  15.601  1.00 16.73           C  
ATOM   2032  O   LEU   253      43.489  42.301  15.315  1.00 18.19           O  
ATOM   2033  CB  LEU   253      40.229  42.022  15.603  1.00 18.12           C  
ATOM   2034  CG  LEU   253      38.922  41.578  16.300  1.00 20.48           C  
ATOM   2035  CD1 LEU   253      37.904  41.116  15.291  1.00 21.68           C  
ATOM   2036  CD2 LEU   253      39.152  40.512  17.330  1.00 20.21           C  
ATOM   2037  N   THR   254      42.473  44.311  15.194  1.00 15.24           N  
ATOM   2038  CA  THR   254      43.556  44.925  14.404  1.00 18.27           C  
ATOM   2039  C   THR   254      44.865  44.978  15.187  1.00 16.83           C  
ATOM   2040  O   THR   254      45.934  44.825  14.612  1.00 17.38           O  
ATOM   2041  CB  THR   254      43.206  46.367  13.943  1.00 21.69           C  
ATOM   2042  OG1 THR   254      43.306  47.269  15.053  1.00 19.60           O  
ATOM   2043  CG2 THR   254      41.784  46.421  13.327  1.00 18.91           C  
ATOM   2044  N   VAL   255      44.787  45.190  16.513  1.00 16.92           N  
ATOM   2045  CA  VAL   255      46.014  45.184  17.332  1.00 20.44           C  
ATOM   2046  C   VAL   255      46.648  43.772  17.414  1.00 16.81           C  
ATOM   2047  O   VAL   255      47.861  43.602  17.301  1.00 15.75           O  
ATOM   2048  CB  VAL   255      45.729  45.717  18.762  1.00 23.19           C  
ATOM   2049  CG1 VAL   255      46.961  45.580  19.637  1.00 17.22           C  
ATOM   2050  CG2 VAL   255      45.271  47.183  18.700  1.00 17.07           C  
ATOM   2051  N   ILE   256      45.817  42.770  17.622  1.00 15.06           N  
ATOM   2052  CA  ILE   256      46.283  41.365  17.645  1.00 16.72           C  
ATOM   2053  C   ILE   256      46.945  40.996  16.304  1.00 18.72           C  
ATOM   2054  O   ILE   256      48.041  40.424  16.277  1.00 17.73           O  
ATOM   2055  CB  ILE   256      45.117  40.416  17.975  1.00 15.49           C  
ATOM   2056  CG1 ILE   256      44.671  40.628  19.426  1.00 16.40           C  
ATOM   2057  CG2 ILE   256      45.526  38.931  17.782  1.00 15.97           C  
ATOM   2058  CD1 ILE   256      43.271  40.002  19.721  1.00 17.55           C  
ATOM   2059  N   ASP   257      46.308  41.383  15.204  1.00 13.78           N  
ATOM   2060  CA  ASP   257      46.861  41.172  13.864  1.00 15.76           C  
ATOM   2061  C   ASP   257      48.199  41.850  13.683  1.00 15.74           C  
ATOM   2062  O   ASP   257      49.140  41.264  13.139  1.00 14.56           O  
ATOM   2063  CB  ASP   257      45.867  41.648  12.794  1.00 18.64           C  
ATOM   2064  CG  ASP   257      46.470  41.626  11.405  1.00 26.78           C  
ATOM   2065  OD1 ASP   257      46.453  40.556  10.783  1.00 20.72           O  
ATOM   2066  OD2 ASP   257      46.996  42.664  10.954  1.00 20.29           O  
ATOM   2067  N   PHE   258      48.273  43.108  14.105  1.00 16.25           N  
ATOM   2068  CA  PHE   258      49.528  43.852  14.067  1.00 17.51           C  
ATOM   2069  C   PHE   258      50.622  43.141  14.865  1.00 16.83           C  
ATOM   2070  O   PHE   258      51.773  43.018  14.390  1.00 17.69           O  
ATOM   2071  CB  PHE   258      49.323  45.269  14.626  1.00 15.95           C  
ATOM   2072  CG  PHE   258      50.559  46.166  14.516  1.00 17.88           C  
ATOM   2073  CD1 PHE   258      50.725  47.003  13.413  1.00 17.31           C  
ATOM   2074  CD2 PHE   258      51.537  46.171  15.533  1.00 17.86           C  
ATOM   2075  CE1 PHE   258      51.858  47.838  13.312  1.00 20.55           C  
ATOM   2076  CE2 PHE   258      52.654  46.980  15.434  1.00 23.41           C  
ATOM   2077  CZ  PHE   258      52.815  47.810  14.323  1.00 18.10           C  
ATOM   2078  N   ALA   259      50.285  42.691  16.073  1.00 14.66           N  
ATOM   2079  CA  ALA   259      51.247  41.942  16.906  1.00 17.15           C  
ATOM   2080  C   ALA   259      51.777  40.679  16.212  1.00 16.42           C  
ATOM   2081  O   ALA   259      52.985  40.380  16.281  1.00 17.86           O  
ATOM   2082  CB  ALA   259      50.584  41.557  18.213  1.00 16.20           C  
ATOM   2083  N   ILE   260      50.876  39.950  15.553  1.00 15.43           N  
ATOM   2084  CA  ILE   260      51.263  38.743  14.796  1.00 17.05           C  
ATOM   2085  C   ILE   260      52.194  39.088  13.631  1.00 21.68           C  
ATOM   2086  O   ILE   260      53.265  38.511  13.498  1.00 17.54           O  
ATOM   2087  CB  ILE   260      50.004  37.957  14.309  1.00 15.84           C  
ATOM   2088  CG1 ILE   260      49.276  37.306  15.480  1.00 15.26           C  
ATOM   2089  CG2 ILE   260      50.356  36.946  13.221  1.00 13.29           C  
ATOM   2090  CD1 ILE   260      47.801  37.088  15.148  1.00 20.98           C  
ATOM   2091  N   ARG   261      51.829  40.091  12.840  1.00 16.50           N  
ATOM   2092  CA  ARG   261      52.593  40.431  11.650  1.00 17.41           C  
ATOM   2093  C   ARG   261      53.957  41.067  11.969  1.00 20.27           C  
ATOM   2094  O   ARG   261      54.883  40.981  11.167  1.00 17.78           O  
ATOM   2095  CB  ARG   261      51.767  41.376  10.777  1.00 18.71           C  
ATOM   2096  CG  ARG   261      50.631  40.706  10.003  1.00 18.49           C  
ATOM   2097  CD  ARG   261      49.895  41.730   9.083  1.00 19.15           C  
ATOM   2098  NE  ARG   261      49.374  42.927   9.773  1.00 15.15           N  
ATOM   2099  CZ  ARG   261      49.999  44.110   9.879  1.00 17.36           C  
ATOM   2100  NH1 ARG   261      51.185  44.316   9.312  1.00 13.59           N  
ATOM   2101  NH2 ARG   261      49.410  45.118  10.534  1.00 17.72           N  
ATOM   2102  N   HIS   262      54.049  41.730  13.125  1.00 18.55           N  
ATOM   2103  CA  HIS   262      55.287  42.423  13.520  1.00 18.49           C  
ATOM   2104  C   HIS   262      56.111  41.632  14.541  1.00 19.93           C  
ATOM   2105  O   HIS   262      57.079  42.156  15.116  1.00 20.40           O  
ATOM   2106  CB  HIS   262      54.993  43.845  14.015  1.00 20.26           C  
ATOM   2107  CG  HIS   262      54.594  44.785  12.917  1.00 22.68           C  
ATOM   2108  ND1 HIS   262      55.464  45.707  12.373  1.00 26.66           N  
ATOM   2109  CD2 HIS   262      53.422  44.926  12.243  1.00 19.17           C  
ATOM   2110  CE1 HIS   262      54.846  46.384  11.418  1.00 25.84           C  
ATOM   2111  NE2 HIS   262      53.615  45.915  11.305  1.00 22.21           N  
ATOM   2112  N   GLY   263      55.748  40.363  14.727  1.00 15.73           N  
ATOM   2113  CA  GLY   263      56.525  39.416  15.539  1.00 18.52           C  
ATOM   2114  C   GLY   263      56.471  39.718  17.035  1.00 23.51           C  
ATOM   2115  O   GLY   263      57.383  39.371  17.767  1.00 19.61           O  
ATOM   2116  N   LEU   264      55.410  40.379  17.482  1.00 14.70           N  
ATOM   2117  CA  LEU   264      55.305  40.807  18.894  1.00 17.57           C  
ATOM   2118  C   LEU   264      54.781  39.666  19.747  1.00 21.10           C  
ATOM   2119  O   LEU   264      54.997  39.651  20.979  1.00 24.41           O  
ATOM   2120  CB  LEU   264      54.405  42.057  19.037  1.00 21.79           C  
ATOM   2121  CG  LEU   264      54.894  43.310  18.267  1.00 23.31           C  
ATOM   2122  CD1 LEU   264      54.040  44.564  18.553  1.00 26.68           C  
ATOM   2123  CD2 LEU   264      56.367  43.588  18.518  1.00 29.60           C  
ATOM   2124  N   ILE   265      54.031  38.749  19.115  1.00 18.52           N  
ATOM   2125  CA  ILE   265      53.686  37.475  19.752  1.00 22.83           C  
ATOM   2126  C   ILE   265      54.260  36.308  18.926  1.00 22.38           C  
ATOM   2127  O   ILE   265      54.466  36.436  17.709  1.00 22.45           O  
ATOM   2128  CB  ILE   265      52.160  37.348  20.072  1.00 25.81           C  
ATOM   2129  CG1 ILE   265      51.316  37.513  18.820  1.00 23.62           C  
ATOM   2130  CG2 ILE   265      51.719  38.400  21.120  1.00 28.12           C  
ATOM   2131  CD1 ILE   265      49.815  37.437  19.137  1.00 30.09           C  
ATOM   2132  N   ASP   266      54.528  35.182  19.589  1.00 17.59           N  
ATOM   2133  CA  ASP   266      55.396  34.130  19.052  1.00 18.41           C  
ATOM   2134  C   ASP   266      54.716  32.788  19.309  1.00 14.35           C  
ATOM   2135  O   ASP   266      54.356  32.498  20.449  1.00 17.74           O  
ATOM   2136  CB  ASP   266      56.736  34.200  19.769  1.00 22.76           C  
ATOM   2137  CG  ASP   266      57.793  33.287  19.155  1.00 23.74           C  
ATOM   2138  OD1 ASP   266      57.485  32.100  18.885  1.00 18.42           O  
ATOM   2139  OD2 ASP   266      58.934  33.756  18.958  1.00 28.70           O  
ATOM   2140  N   PRO   267      54.519  31.984  18.263  1.00 14.45           N  
ATOM   2141  CA  PRO   267      53.801  30.706  18.408  1.00 18.63           C  
ATOM   2142  C   PRO   267      54.476  29.707  19.342  1.00 19.37           C  
ATOM   2143  O   PRO   267      53.824  28.755  19.780  1.00 18.58           O  
ATOM   2144  CB  PRO   267      53.784  30.167  16.977  1.00 15.64           C  
ATOM   2145  CG  PRO   267      55.031  30.801  16.347  1.00 17.26           C  
ATOM   2146  CD  PRO   267      54.945  32.200  16.867  1.00 20.06           C  
ATOM   2147  N   ASP   268      55.740  29.927  19.664  1.00 15.62           N  
ATOM   2148  CA  ASP   268      56.414  29.081  20.623  1.00 15.57           C  
ATOM   2149  C   ASP   268      55.906  29.264  22.063  1.00 18.65           C  
ATOM   2150  O   ASP   268      56.171  28.468  22.893  1.00 20.39           O  
ATOM   2151  CB  ASP   268      57.926  29.260  20.596  1.00 15.64           C  
ATOM   2152  CG  ASP   268      58.650  28.193  19.765  1.00 20.73           C  
ATOM   2153  OD1 ASP   268      58.176  27.083  19.594  1.00 19.74           O  
ATOM   2154  OD2 ASP   268      59.709  28.523  19.289  1.00 18.59           O  
ATOM   2155  N   ASN   269      55.254  30.378  22.352  1.00 18.15           N  
ATOM   2156  CA  ASN   269      54.833  30.636  23.700  1.00 18.28           C  
ATOM   2157  C   ASN   269      53.520  31.390  23.936  1.00 23.96           C  
ATOM   2158  O   ASN   269      53.023  31.432  25.023  1.00 26.27           O  
ATOM   2159  CB  ASN   269      55.964  31.175  24.533  1.00 18.15           C  
ATOM   2160  CG  ASN   269      56.558  32.401  23.953  1.00 26.19           C  
ATOM   2161  OD1 ASN   269      57.699  32.422  23.568  1.00 32.60           O  
ATOM   2162  ND2 ASN   269      55.787  33.418  23.887  1.00 26.72           N  
ATOM   2163  N   GLU   270      52.941  31.937  22.902  1.00 16.48           N  
ATOM   2164  CA  GLU   270      51.647  32.553  23.047  1.00 15.11           C  
ATOM   2165  C   GLU   270      50.492  31.549  23.084  1.00 14.42           C  
ATOM   2166  O   GLU   270      50.240  30.921  22.121  1.00 21.12           O  
ATOM   2167  CB  GLU   270      51.467  33.548  21.932  1.00 18.79           C  
ATOM   2168  CG  GLU   270      50.290  34.433  22.053  1.00 18.97           C  
ATOM   2169  CD  GLU   270      50.347  35.361  23.231  1.00 22.84           C  
ATOM   2170  OE1 GLU   270      51.369  35.956  23.455  1.00 20.01           O  
ATOM   2171  OE2 GLU   270      49.349  35.477  23.920  1.00 26.54           O  
ATOM   2172  N   PRO   271      49.784  31.472  24.201  1.00 18.53           N  
ATOM   2173  CA  PRO   271      48.640  30.527  24.313  1.00 18.62           C  
ATOM   2174  C   PRO   271      47.585  30.711  23.209  1.00 21.48           C  
ATOM   2175  O   PRO   271      47.318  31.827  22.772  1.00 20.64           O  
ATOM   2176  CB  PRO   271      48.042  30.857  25.699  1.00 18.34           C  
ATOM   2177  CG  PRO   271      49.205  31.407  26.481  1.00 22.82           C  
ATOM   2178  CD  PRO   271      49.976  32.218  25.463  1.00 19.03           C  
ATOM   2179  N   ASP   272      47.040  29.602  22.722  1.00 19.39           N  
ATOM   2180  CA  ASP   272      45.946  29.606  21.734  1.00 21.41           C  
ATOM   2181  C   ASP   272      46.249  30.312  20.390  1.00 22.39           C  
ATOM   2182  O   ASP   272      45.353  30.844  19.739  1.00 21.93           O  
ATOM   2183  CB  ASP   272      44.665  30.132  22.399  1.00 25.85           C  
ATOM   2184  CG  ASP   272      44.337  29.387  23.701  1.00 22.95           C  
ATOM   2185  OD1 ASP   272      44.123  28.160  23.659  1.00 30.25           O  
ATOM   2186  OD2 ASP   272      44.290  30.024  24.762  1.00 25.66           O  
ATOM   2187  N   TYR   273      47.521  30.310  19.994  1.00 22.77           N  
ATOM   2188  CA  TYR   273      47.976  31.029  18.803  1.00 24.21           C  
ATOM   2189  C   TYR   273      47.124  30.663  17.581  1.00 25.07           C  
ATOM   2190  O   TYR   273      46.575  31.546  16.921  1.00 19.63           O  
ATOM   2191  CB  TYR   273      49.470  30.728  18.556  1.00 24.65           C  
ATOM   2192  CG  TYR   273      50.160  31.551  17.468  1.00 22.16           C  
ATOM   2193  CD1 TYR   273      50.778  32.746  17.787  1.00 22.26           C  
ATOM   2194  CD2 TYR   273      50.222  31.115  16.129  1.00 26.27           C  
ATOM   2195  CE1 TYR   273      51.455  33.514  16.826  1.00 25.71           C  
ATOM   2196  CE2 TYR   273      50.906  31.883  15.148  1.00 23.07           C  
ATOM   2197  CZ  TYR   273      51.516  33.091  15.519  1.00 26.26           C  
ATOM   2198  OH  TYR   273      52.227  33.891  14.619  1.00 25.63           O  
ATOM   2199  N   GLN   274      46.965  29.362  17.313  1.00 25.05           N  
ATOM   2200  CA  GLN   274      46.233  28.905  16.136  1.00 28.03           C  
ATOM   2201  C   GLN   274      44.756  29.291  16.186  1.00 21.12           C  
ATOM   2202  O   GLN   274      44.185  29.668  15.168  1.00 25.17           O  
ATOM   2203  CB  GLN   274      46.352  27.379  15.960  1.00 29.75           C  
ATOM   2204  CG  GLN   274      47.542  26.871  15.197  1.00 35.04           C  
ATOM   2205  CD  GLN   274      47.510  25.334  15.104  1.00 37.83           C  
ATOM   2206  OE1 GLN   274      47.600  24.655  16.103  1.00 54.17           O  
ATOM   2207  NE2 GLN   274      47.333  24.809  13.918  1.00 29.49           N  
ATOM   2208  N   GLU   275      44.133  29.184  17.363  1.00 21.24           N  
ATOM   2209  CA  GLU   275      42.711  29.558  17.518  1.00 23.65           C  
ATOM   2210  C   GLU   275      42.464  31.077  17.339  1.00 23.33           C  
ATOM   2211  O   GLU   275      41.438  31.485  16.766  1.00 23.64           O  
ATOM   2212  CB  GLU   275      42.172  29.094  18.877  1.00 25.97           C  
ATOM   2213  CG  GLU   275      40.632  29.029  18.967  1.00 32.41           C  
ATOM   2214  CD  GLU   275      40.122  28.518  20.321  1.00 39.35           C  
ATOM   2215  OE1 GLU   275      40.922  27.962  21.105  1.00 44.52           O  
ATOM   2216  OE2 GLU   275      38.908  28.672  20.601  1.00 41.90           O  
ATOM   2217  N   ILE   276      43.388  31.896  17.846  1.00 20.81           N  
ATOM   2218  CA  ILE   276      43.385  33.356  17.610  1.00 17.98           C  
ATOM   2219  C   ILE   276      43.453  33.689  16.106  1.00 17.71           C  
ATOM   2220  O   ILE   276      42.631  34.450  15.591  1.00 21.55           O  
ATOM   2221  CB  ILE   276      44.528  34.081  18.401  1.00 15.86           C  
ATOM   2222  CG1 ILE   276      44.247  34.008  19.908  1.00 19.73           C  
ATOM   2223  CG2 ILE   276      44.706  35.542  17.912  1.00 19.05           C  
ATOM   2224  CD1 ILE   276      45.475  34.302  20.768  1.00 19.29           C  
ATOM   2225  N   LEU   277      44.398  33.072  15.395  1.00 19.08           N  
ATOM   2226  CA  LEU   277      44.530  33.265  13.963  1.00 21.48           C  
ATOM   2227  C   LEU   277      43.274  32.840  13.211  1.00 24.88           C  
ATOM   2228  O   LEU   277      42.825  33.536  12.298  1.00 24.76           O  
ATOM   2229  CB  LEU   277      45.735  32.471  13.422  1.00 21.86           C  
ATOM   2230  CG  LEU   277      47.076  33.195  13.374  1.00 24.75           C  
ATOM   2231  CD1 LEU   277      47.600  33.586  14.733  1.00 34.47           C  
ATOM   2232  CD2 LEU   277      48.096  32.295  12.688  1.00 25.76           C  
ATOM   2233  N   ALA   278      42.715  31.692  13.593  1.00 27.02           N  
ATOM   2234  CA  ALA   278      41.506  31.175  12.965  1.00 25.77           C  
ATOM   2235  C   ALA   278      40.359  32.164  13.105  1.00 27.86           C  
ATOM   2236  O   ALA   278      39.644  32.463  12.139  1.00 27.51           O  
ATOM   2237  CB  ALA   278      41.141  29.816  13.572  1.00 26.62           C  
ATOM   2238  N   GLY   279      40.206  32.713  14.303  1.00 24.75           N  
ATOM   2239  CA  GLY   279      39.119  33.606  14.566  1.00 24.32           C  
ATOM   2240  C   GLY   279      39.255  34.969  13.922  1.00 21.62           C  
ATOM   2241  O   GLY   279      38.252  35.644  13.752  1.00 25.06           O  
ATOM   2242  N   LEU   280      40.471  35.367  13.529  1.00 21.70           N  
ATOM   2243  CA  LEU   280      40.689  36.640  12.818  1.00 16.91           C  
ATOM   2244  C   LEU   280      40.233  36.546  11.361  1.00 19.92           C  
ATOM   2245  O   LEU   280      40.131  37.569  10.678  1.00 23.50           O  
ATOM   2246  CB  LEU   280      42.167  37.093  12.848  1.00 19.48           C  
ATOM   2247  CG  LEU   280      42.750  37.463  14.221  1.00 19.47           C  
ATOM   2248  CD1 LEU   280      44.277  37.667  14.111  1.00 17.83           C  
ATOM   2249  CD2 LEU   280      42.045  38.638  14.883  1.00 22.63           C  
ATOM   2250  N   ARG   281      39.992  35.328  10.881  1.00 23.44           N  
ATOM   2251  CA  ARG   281      39.354  35.114   9.570  1.00 32.81           C  
ATOM   2252  C   ARG   281      37.935  34.561   9.712  1.00 32.09           C  
ATOM   2253  O   ARG   281      37.445  33.916   8.796  1.00 48.29           O  
ATOM   2254  CB  ARG   281      40.191  34.158   8.682  1.00 34.72           C  
ATOM   2255  CG  ARG   281      41.637  34.586   8.452  1.00 51.44           C  
ATOM   2256  CD  ARG   281      41.875  35.612   7.315  1.00 47.49           C  
ATOM   2257  NE  ARG   281      43.253  36.139   7.365  1.00 47.28           N  
ATOM   2258  CZ  ARG   281      44.352  35.493   6.941  1.00 62.28           C  
ATOM   2259  NH1 ARG   281      44.285  34.275   6.399  1.00 47.33           N  
ATOM   2260  NH2 ARG   281      45.544  36.071   7.053  1.00 64.73           N  
ATOM   2261  N   GLY   282      37.261  34.858  10.830  1.00 38.52           N  
ATOM   2262  CA  GLY   282      35.979  34.235  11.204  1.00 42.89           C  
ATOM   2263  C   GLY   282      34.742  34.549  10.371  1.00 58.44           C  
ATOM   2264  O   GLY   282      34.487  35.704  10.042  1.00 62.23           O  
ATOM   2265  N   ARG   283      33.963  33.519  10.030  1.00 64.93           N  
ATOM   2266  CA  ARG   283      32.705  33.700   9.274  1.00 72.21           C  
ATOM   2267  C   ARG   283      31.534  32.990   9.967  1.00 69.93           C  
ATOM   2268  O   ARG   283      30.361  33.286   9.718  1.00 69.14           O  
ATOM   2269  CB  ARG   283      32.831  33.197   7.821  1.00 73.70           C  
ATOM   2270  CG  ARG   283      34.107  33.605   7.074  1.00 81.93           C  
ATOM   2271  CD  ARG   283      33.954  33.492   5.560  1.00 83.14           C  
ATOM   2272  NE  ARG   283      33.593  34.769   4.934  1.00 96.15           N  
ATOM   2273  CZ  ARG   283      34.447  35.572   4.294  1.00100.15           C  
ATOM   2274  NH1 ARG   283      34.015  36.705   3.758  1.00 98.98           N  
ATOM   2275  NH2 ARG   283      35.731  35.249   4.181  1.00102.87           N  
END
