
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  233 ( 1931),  selected  233 , name 2pny_A
# Molecule2: number of CA atoms  208 ( 1611),  selected  208 , name T0513_1_11_87_283.pdb
# PARAMETERS: 2pny_A.T0513_1_11_87_283.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    L    -5_A      M       1           -
LGA    V    -4_A      S       2           -
LGA    P    -3_A      F       3           -
LGA    R    -2_A      L       4           -
LGA    G    -1_A      K       5           -
LGA    S     0_A      H       6           -
LGA    M     1_A      V       7           -
LGA    S     2_A      Q       8           -
LGA    D     3_A      D       9           -
LGA    I     4_A      C      10           -
LGA    N     5_A      N      11           -
LGA    L     6_A      -       -           -
LGA    D     7_A      -       -           -
LGA    W     8_A      -       -           -
LGA    V     9_A      -       -           -
LGA    D    10_A      -       -           -
LGA    R    11_A      -       -           -
LGA    R    12_A      -       -           -
LGA    Q    13_A      -       -           -
LGA    L    14_A      -       -           -
LGA    Q    15_A      -       -           -
LGA    R    16_A      -       -           -
LGA    L    17_A      -       -           -
LGA    E    18_A      G      87          0.979
LGA    E    19_A      E      88          1.478
LGA    M    20_A      L      89          1.662
LGA    L    21_A      Y      90          2.000
LGA    I    22_A      R      91          2.331
LGA    V    23_A      V      92          2.446
LGA    V    24_A      N      93          2.662
LGA    D    25_A      Q      94          1.467
LGA    E    26_A      S      95          3.838
LGA    N    27_A      W      96           #
LGA    D    28_A      G      97          4.318
LGA    K    29_A      E      98          1.927
LGA    V    30_A      P      99          3.709
LGA    I    31_A      T     100          2.609
LGA    G    32_A      L     101          3.671
LGA    -       -      M     102           -
LGA    A    33_A      L     103          1.974
LGA    D    34_A      L     104          1.643
LGA    T    35_A      D     105          1.647
LGA    K    36_A      R     106          1.891
LGA    R    37_A      A     107          1.276
LGA    N    38_A      V     108          1.789
LGA    C    39_A      V     109          2.020
LGA    H    40_A      -       -           -
LGA    L    41_A      -       -           -
LGA    N    42_A      P     110          3.762
LGA    E    43_A      T     111          2.779
LGA    N    44_A      F     112          2.311
LGA    I    45_A      G     113          2.165
LGA    E    46_A      -       -           -
LGA    K    47_A      -       -           -
LGA    G    48_A      -       -           -
LGA    L    49_A      V     114          0.789
LGA    L    50_A      R     115          1.016
LGA    H    51_A      A     116          2.166
LGA    R    52_A      Y     117          2.262
LGA    A    53_A      G     118          1.627
LGA    F    54_A      V     119          1.515
LGA    S    55_A      H     120          1.392
LGA    V    56_A      L     121          1.239
LGA    V    57_A      N     122          1.054
LGA    L    58_A      G     123          1.183
LGA    F    59_A      Y     124          0.832
LGA    N    60_A      V     125          1.748
LGA    T    61_A      G     126          3.069
LGA    -       -      A     127           -
LGA    -       -      G     128           -
LGA    -       -      A     129           -
LGA    K    62_A      D     130          4.824
LGA    N    63_A      L     131          2.321
LGA    R    64_A      H     132          1.017
LGA    I    65_A      L     133          1.234
LGA    L    66_A      W     134          1.515
LGA    I    67_A      I     135          1.458
LGA    Q    68_A      G     136          1.397
LGA    Q    69_A      R     137          1.588
LGA    R    70_A      R     138          1.403
LGA    S    71_A      S     139          1.160
LGA    D    72_A      P     140          1.479
LGA    T    73_A      D     141          1.456
LGA    K    74_A      K     142          1.704
LGA    V    75_A      S     143          2.190
LGA    T    76_A      V     144          1.880
LGA    F    77_A      A     145          1.767
LGA    P    78_A      P     146          1.715
LGA    G    79_A      G     147          1.646
LGA    Y    80_A      K     148          1.441
LGA    F    81_A      L     149          1.108
LGA    T    82_A      D     150          2.009
LGA    D    83_A      N     151          2.036
LGA    S    84_A      M     152          2.293
LGA    C    85_A      V     153          1.917
LGA    S    86_A      A     154          1.707
LGA    S    87_A      G     155          1.333
LGA    H    88_A      G     156          2.839
LGA    P    89_A      Q     157          3.070
LGA    L    90_A      P     158          2.323
LGA    Y    91_A      A     159          2.201
LGA    N    92_A      D     160          2.323
LGA    P    93_A      -       -           -
LGA    A    94_A      L     161          4.863
LGA    E    95_A      S     162          2.252
LGA    L    96_A      -       -           -
LGA    E    97_A      -       -           -
LGA    E    98_A      -       -           -
LGA    K    99_A      -       -           -
LGA    D   100_A      -       -           -
LGA    A   101_A      -       -           -
LGA    I   102_A      -       -           -
LGA    G   103_A      -       -           -
LGA    V   104_A      L     163          0.530
LGA    R   105_A      R     164          1.506
LGA    R   106_A      Q     165          1.691
LGA    A   107_A      N     166          0.772
LGA    A   108_A      L     167          0.602
LGA    Q   109_A      I     168          1.263
LGA    R   110_A      K     169          0.686
LGA    R   111_A      E     170          0.211
LGA    L   112_A      C     171          1.066
LGA    Q   113_A      A     172          0.674
LGA    A   114_A      E     173          0.566
LGA    E   115_A      E     174          0.907
LGA    L   116_A      A     175          1.071
LGA    G   117_A      D     176          1.441
LGA    I   118_A      L     177          1.372
LGA    P   119_A      P     178          1.891
LGA    G   120_A      E     179          1.761
LGA    E   121_A      A     180          3.503
LGA    Q   122_A      L     181          3.089
LGA    I   123_A      A     182          2.393
LGA    S   124_A      R     183          2.231
LGA    P   125_A      -       -           -
LGA    E   126_A      -       -           -
LGA    D   127_A      Q     184          0.773
LGA    I   128_A      A     185          1.622
LGA    V   129_A      I     186          0.768
LGA    F   130_A      P     187          1.074
LGA    M   131_A      V     188          1.145
LGA    T   132_A      G     189          1.089
LGA    I   133_A      A     190          1.911
LGA    Y   134_A      I     191          1.906
LGA    H   135_A      T     192          1.537
LGA    H   136_A      Y     193          1.827
LGA    K   137_A      C     194          3.293
LGA    A   138_A      M     195          4.384
LGA    K   139_A      E     196          5.807
LGA    S   140_A      S     197          6.181
LGA    D   141_A      -       -           -
LGA    R   142_A      P     198          2.262
LGA    I   143_A      A     199          3.155
LGA    W   144_A      G     200           #
LGA    G   145_A      -       -           -
LGA    E   146_A      I     201           #
LGA    H   147_A      K     202          2.920
LGA    -       -      P     203           -
LGA    E   148_A      D     204          1.858
LGA    I   149_A      T     205          2.137
LGA    C   150_A      L     206          1.830
LGA    Y   151_A      F     207          1.003
LGA    L   152_A      L     208          1.142
LGA    L   153_A      Y     209          1.219
LGA    L   154_A      D     210          1.196
LGA    V   155_A      L     211          1.072
LGA    R   156_A      A     212          1.119
LGA    K   157_A      L     213          1.360
LGA    N   158_A      P     214          2.237
LGA    -       -      E     215           -
LGA    -       -      D     216           -
LGA    V   159_A      F     217          2.705
LGA    T   160_A      R     218          2.893
LGA    L   161_A      P     219          1.904
LGA    N   162_A      H     220          1.917
LGA    P   163_A      N     221          0.593
LGA    D   164_A      T     222          3.414
LGA    P   165_A      D     223           #
LGA    S   166_A      G     224          3.101
LGA    E   167_A      E     225          0.455
LGA    T   168_A      M     226          0.479
LGA    K   169_A      A     227          1.647
LGA    S   170_A      D     228          2.433
LGA    I   171_A      F     229          1.733
LGA    L   172_A      M     230          2.056
LGA    Y   173_A      L     231          1.640
LGA    L   174_A      W     232          1.886
LGA    S   175_A      P     233          1.457
LGA    Q   176_A      A     234          2.111
LGA    E   177_A      A     235          1.485
LGA    E   178_A      K     236          0.396
LGA    L   179_A      V     237          1.041
LGA    W   180_A      V     238          2.377
LGA    E   181_A      E     239          2.444
LGA    L   182_A      A     240          1.160
LGA    L   183_A      V     241          1.765
LGA    E   184_A      R     242          3.688
LGA    R   185_A      T     243          3.890
LGA    E   186_A      T     244          1.165
LGA    A   187_A      E     245           #
LGA    R   188_A      -       -           -
LGA    G   189_A      -       -           -
LGA    E   190_A      -       -           -
LGA    V   191_A      -       -           -
LGA    K   192_A      A     246          3.254
LGA    V   193_A      F     247          1.696
LGA    T   194_A      K     248          1.911
LGA    P   195_A      F     249          2.434
LGA    W   196_A      N     250          2.274
LGA    L   197_A      V     251          2.585
LGA    R   198_A      N     252          2.447
LGA    T   199_A      L     253          2.115
LGA    I   200_A      T     254          2.537
LGA    A   201_A      V     255          2.639
LGA    E   202_A      I     256          2.582
LGA    R   203_A      D     257          3.669
LGA    F   204_A      -       -           -
LGA    L   205_A      F     258          1.548
LGA    Y   206_A      A     259          1.760
LGA    R   207_A      I     260          2.772
LGA    W   208_A      R     261          2.755
LGA    W   209_A      H     262          2.531
LGA    P   210_A      G     263          5.170
LGA    H   211_A      L     264           -
LGA    L   212_A      I     265           -
LGA    D   213_A      D     266           -
LGA    D   214_A      P     267           -
LGA    V   215_A      D     268           -
LGA    T   216_A      N     269           -
LGA    P   217_A      E     270           -
LGA    F   218_A      P     271           -
LGA    V   219_A      D     272           -
LGA    E   220_A      Y     273           -
LGA    L   221_A      Q     274           -
LGA    H   222_A      E     275           -
LGA    K   223_A      I     276           -
LGA    I   224_A      -       -           -
LGA    H   225_A      L     277           #
LGA    -       -      A     278           -
LGA    -       -      G     279           -
LGA    -       -      L     280           -
LGA    R   226_A      R     281          2.353
LGA    V   227_A      G     282          2.893
LGA    -       -      R     283           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  233  208    5.0    167    2.25     9.58     57.196     7.116

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.047394 * X  +   0.527285 * Y  +  -0.848366 * Z  +  33.624645
  Y_new =  -0.996208 * X  +   0.037086 * Y  +   0.078703 * Z  +  77.328278
  Z_new =   0.072962 * X  +   0.848879 * Y  +   0.523528 * Z  + -18.361448 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.018167   -2.123425  [ DEG:    58.3367   -121.6633 ]
  Theta =  -0.073027   -3.068566  [ DEG:    -4.1841   -175.8159 ]
  Phi   =  -1.618335    1.523258  [ DEG:   -92.7238     87.2762 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pny_A                                        
REMARK     2: T0513_1_11_87_283.pdb                         
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pny_A.T0513_1_11_87_283.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  233  208   5.0  167   2.25    9.58  57.196
REMARK  ---------------------------------------------------------- 
MOLECULE 2pny_A
HEADER    ISOMERASE                               25-APR-07   2PNY              
TITLE     STRUCTURE OF HUMAN ISOPENTENYL-DIPHOSPHATE DELTA-ISOMERASE 2          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ISOPENTENYL-DIPHOSPHATE DELTA-ISOMERASE 2;                 
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: IPP ISOMERASE 2, ISOPENTENYL PYROPHOSPHATE                  
COMPND   5 ISOMERASE 2, IPPI2;                                                  
COMPND   6 EC: 5.3.3.2;                                                         
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 TISSUE: SKELETAL MUSCLE;                                             
SOURCE   5 GENE: IDI2;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET28-LIC                                 
KEYWDS    CAROTENOID BIOSYNTHESIS, CHOLESTEROL BIOSYNTHESIS,                    
KEYWDS   2 ISOMERASE, ISOPRENE BIOSYNTHESIS, LIPID SYNTHESIS,                   
KEYWDS   3 PEROXISOME, STEROID BIOSYNTHESIS, STEROL BIOSYNTHESIS,               
KEYWDS   4 STRUCTURAL GENOMICS, STRUCTURAL GENOMICS CONSORTIUM, SGC             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.R.WALKER,T.DAVIS,C.BUTLER-COLE,J.WEIGELT,M.SUNDSTROM,               
AUTHOR   2 C.H.ARROWSMITH,A.M.EDWARDS,A.BOCHKAREV,S.DHE-PAGANON,                
AUTHOR   3 STRUCTURAL GENOMICS CONSORTIUM (SGC)                                 
REVDAT   1   29-MAY-07 2PNY    0                                                
JRNL        AUTH   J.R.WALKER,T.DAVIS,C.BUTLER-COLE,J.WEIGELT,                  
JRNL        AUTH 2 M.SUNDSTROM,C.H.ARROWSMITH,A.M.EDWARDS,A.BOCHKAREV,          
JRNL        AUTH 3 S.DHE-PAGANON                                                
JRNL        TITL   STRUCTURE OF THE HUMAN ISOPENTENYL-DIPHOSPHATE               
JRNL        TITL 2 DELTA-ISOMERASE 2.                                           
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.81 ANGSTROMS.                                          
DBREF  2PNY A    1   227  UNP    Q9BXS1   IDI2_HUMAN       1    227             
SEQRES   1 A  246  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 A  246  LEU VAL PRO ARG GLY SER MET SER ASP ILE ASN LEU ASP          
SEQRES   3 A  246  TRP VAL ASP ARG ARG GLN LEU GLN ARG LEU GLU GLU MET          
SEQRES   4 A  246  LEU ILE VAL VAL ASP GLU ASN ASP LYS VAL ILE GLY ALA          
SEQRES   5 A  246  ASP THR LYS ARG ASN CYS HIS LEU ASN GLU ASN ILE GLU          
SEQRES   6 A  246  LYS GLY LEU LEU HIS ARG ALA PHE SER VAL VAL LEU PHE          
SEQRES   7 A  246  ASN THR LYS ASN ARG ILE LEU ILE GLN GLN ARG SER ASP          
SEQRES   8 A  246  THR LYS VAL THR PHE PRO GLY TYR PHE THR ASP SER CYS          
SEQRES   9 A  246  SER SER HIS PRO LEU TYR ASN PRO ALA GLU LEU GLU GLU          
SEQRES  10 A  246  LYS ASP ALA ILE GLY VAL ARG ARG ALA ALA GLN ARG ARG          
SEQRES  11 A  246  LEU GLN ALA GLU LEU GLY ILE PRO GLY GLU GLN ILE SER          
SEQRES  12 A  246  PRO GLU ASP ILE VAL PHE MET THR ILE TYR HIS HIS LYS          
SEQRES  13 A  246  ALA LYS SER ASP ARG ILE TRP GLY GLU HIS GLU ILE CYS          
SEQRES  14 A  246  TYR LEU LEU LEU VAL ARG LYS ASN VAL THR LEU ASN PRO          
SEQRES  15 A  246  ASP PRO SER GLU THR LYS SER ILE LEU TYR LEU SER GLN          
SEQRES  16 A  246  GLU GLU LEU TRP GLU LEU LEU GLU ARG GLU ALA ARG GLY          
SEQRES  17 A  246  GLU VAL LYS VAL THR PRO TRP LEU ARG THR ILE ALA GLU          
SEQRES  18 A  246  ARG PHE LEU TYR ARG TRP TRP PRO HIS LEU ASP ASP VAL          
SEQRES  19 A  246  THR PRO PHE VAL GLU LEU HIS LYS ILE HIS ARG VAL              
HET     CA      1       1                                                       
HET     MN      2       1                                                       
HET    POP      3       9                                                       
HET    GOL      4      12                                                       
HET    GOL      5       6                                                       
HET    GOL      6       6                                                       
HETNAM      CA CALCIUM ION                                                      
HETNAM      MN MANGANESE (II) ION                                               
HETNAM     POP PYROPHOSPHATE 2-                                                 
HETNAM     GOL GLYCEROL                                                         
FORMUL   2   CA    CA 2+                                                        
FORMUL   3   MN    MN 2+                                                        
FORMUL   4  POP    H2 O7 P2 2-                                                  
FORMUL   5  GOL    3(C3 H8 O3)                                                  
FORMUL   8  HOH   *187(H2 O)                                                    
CRYST1   50.897   52.815   96.391  90.00  90.00  90.00 P 21 21 21    4          
ATOM      1  N   LEU A  -5       9.073  41.573  11.102  1.00 31.98           N  
ATOM      2  CA  LEU A  -5       9.023  42.926  11.763  1.00 26.60           C  
ATOM      3  C   LEU A  -5      10.013  43.005  12.889  1.00 22.98           C  
ATOM      4  O   LEU A  -5      10.282  42.017  13.555  1.00 24.43           O  
ATOM      5  CB  LEU A  -5       7.628  43.258  12.312  1.00 30.62           C  
ATOM      6  CG  LEU A  -5       6.810  44.204  11.402  1.00 32.75           C  
ATOM      7  CD1 LEU A  -5       6.109  43.396  10.331  1.00 42.14           C  
ATOM      8  CD2 LEU A  -5       5.834  45.060  12.174  1.00 32.78           C  
ATOM      9  N   VAL A  -4      10.550  44.189  13.112  1.00 17.88           N  
ATOM     10  CA  VAL A  -4      11.537  44.385  14.140  1.00 16.65           C  
ATOM     11  C   VAL A  -4      10.787  44.796  15.402  1.00 15.32           C  
ATOM     12  O   VAL A  -4      10.000  45.759  15.384  1.00 15.76           O  
ATOM     13  CB  VAL A  -4      12.581  45.498  13.732  1.00 17.53           C  
ATOM     14  CG1 VAL A  -4      13.597  45.747  14.871  1.00 20.67           C  
ATOM     15  CG2 VAL A  -4      13.324  45.093  12.456  1.00 20.15           C  
ATOM     16  N   PRO A  -3      10.987  44.070  16.496  1.00 17.18           N  
ATOM     17  CA  PRO A  -3      10.280  44.480  17.744  1.00 18.77           C  
ATOM     18  C   PRO A  -3      10.876  45.771  18.300  1.00 19.02           C  
ATOM     19  O   PRO A  -3      12.111  45.957  18.254  1.00 22.96           O  
ATOM     20  CB  PRO A  -3      10.571  43.320  18.719  1.00 20.39           C  
ATOM     21  CG  PRO A  -3      11.890  42.769  18.242  1.00 20.80           C  
ATOM     22  CD  PRO A  -3      11.856  42.898  16.707  1.00 18.72           C  
ATOM     23  N   ARG A  -2      10.035  46.673  18.793  1.00 19.95           N  
ATOM     24  CA  ARG A  -2      10.564  47.927  19.368  1.00 21.86           C  
ATOM     25  C   ARG A  -2      10.030  47.995  20.788  1.00 25.07           C  
ATOM     26  O   ARG A  -2       8.815  48.168  20.986  1.00 27.12           O  
ATOM     27  CB  ARG A  -2      10.117  49.146  18.586  1.00 23.30           C  
ATOM     28  CG  ARG A  -2      10.504  49.118  17.085  1.00 22.14           C  
ATOM     29  CD  ARG A  -2      11.729  49.936  16.759  1.00 23.19           C  
ATOM     30  NE  ARG A  -2      12.067  49.875  15.321  1.00 19.16           N  
ATOM     31  CZ  ARG A  -2      13.263  49.494  14.849  1.00 24.40           C  
ATOM     32  NH1 ARG A  -2      13.492  49.451  13.544  1.00 23.60           N  
ATOM     33  NH2 ARG A  -2      14.251  49.140  15.695  1.00 26.94           N  
ATOM     34  N   GLY A  -1      10.906  47.822  21.778  1.00 27.20           N  
ATOM     35  CA  GLY A  -1      10.439  47.811  23.165  1.00 30.97           C  
ATOM     36  C   GLY A  -1       9.927  49.187  23.489  1.00 35.58           C  
ATOM     37  O   GLY A  -1       8.909  49.370  24.184  1.00 39.90           O  
ATOM     38  N   SER A   0      10.639  50.178  22.986  1.00 26.41           N  
ATOM     39  CA  SER A   0      10.233  51.540  23.178  1.00 26.60           C  
ATOM     40  C   SER A   0      10.917  52.440  22.157  1.00 25.26           C  
ATOM     41  O   SER A   0      11.774  51.993  21.392  1.00 23.82           O  
ATOM     42  CB  SER A   0      10.575  51.991  24.602  1.00 30.18           C  
ATOM     43  OG  SER A   0      11.836  52.615  24.666  1.00 30.15           O  
ATOM     44  N   MET A   1      10.565  53.719  22.162  0.50 26.02           N  
ATOM     46  CA  MET A   1      11.164  54.666  21.228  0.50 26.28           C  
ATOM     48  C   MET A   1      12.623  55.022  21.618  0.50 25.15           C  
ATOM     50  O   MET A   1      13.345  55.660  20.849  0.50 25.61           O  
ATOM     52  CB  MET A   1      10.260  55.896  21.129  0.50 31.49           C  
ATOM     54  CG  MET A   1      10.598  56.867  20.027  0.50 34.09           C  
ATOM     56  SD  MET A   1       9.702  58.393  20.358  0.50 43.32           S  
ATOM     58  CE  MET A   1       9.997  58.523  22.143  0.50 43.83           C  
ATOM     60  N   SER A   2      13.059  54.607  22.805  1.00 25.96           N  
ATOM     61  CA  SER A   2      14.505  54.640  23.133  1.00 26.81           C  
ATOM     62  C   SER A   2      15.412  53.859  22.134  1.00 25.67           C  
ATOM     63  O   SER A   2      16.618  54.170  21.989  1.00 25.73           O  
ATOM     64  CB  SER A   2      14.747  54.120  24.536  1.00 31.67           C  
ATOM     65  OG  SER A   2      14.632  52.708  24.553  1.00 37.55           O  
ATOM     66  N   ASP A   3      14.851  52.853  21.457  1.00 24.24           N  
ATOM     67  CA  ASP A   3      15.577  52.158  20.380  1.00 26.27           C  
ATOM     68  C   ASP A   3      16.097  53.092  19.314  1.00 25.18           C  
ATOM     69  O   ASP A   3      17.115  52.813  18.686  1.00 29.47           O  
ATOM     70  CB  ASP A   3      14.681  51.157  19.650  1.00 29.34           C  
ATOM     71  CG  ASP A   3      14.421  49.937  20.453  1.00 33.13           C  
ATOM     72  OD1 ASP A   3      14.845  49.901  21.617  1.00 39.72           O  
ATOM     73  OD2 ASP A   3      13.798  49.019  19.909  1.00 40.18           O  
ATOM     74  N   ILE A   4      15.390  54.183  19.067  1.00 22.03           N  
ATOM     75  CA  ILE A   4      15.792  55.068  17.949  1.00 25.35           C  
ATOM     76  C   ILE A   4      16.689  56.258  18.366  1.00 22.95           C  
ATOM     77  O   ILE A   4      17.185  57.008  17.507  1.00 28.00           O  
ATOM     78  CB  ILE A   4      14.545  55.482  17.119  1.00 28.64           C  
ATOM     79  CG1 ILE A   4      13.584  56.339  17.933  1.00 29.98           C  
ATOM     80  CG2 ILE A   4      13.773  54.247  16.722  1.00 32.54           C  
ATOM     81  CD1 ILE A   4      13.968  57.826  18.014  1.00 35.90           C  
ATOM     82  N   ASN A   5      16.914  56.387  19.677  1.00 20.22           N  
ATOM     83  CA  ASN A   5      17.752  57.438  20.318  1.00 21.79           C  
ATOM     84  C   ASN A   5      19.169  57.479  19.759  1.00 22.07           C  
ATOM     85  O   ASN A   5      19.847  56.449  19.735  1.00 23.74           O  
ATOM     86  CB  ASN A   5      17.835  57.149  21.840  1.00 22.44           C  
ATOM     87  CG  ASN A   5      18.871  57.994  22.577  1.00 30.52           C  
ATOM     88  OD1 ASN A   5      18.914  59.226  22.454  1.00 35.03           O  
ATOM     89  ND2 ASN A   5      19.684  57.327  23.426  1.00 36.37           N  
ATOM     90  N   LEU A   6      19.583  58.659  19.292  1.00 19.57           N  
ATOM     91  CA  LEU A   6      21.001  58.942  19.003  1.00 18.15           C  
ATOM     92  C   LEU A   6      21.416  60.254  19.668  1.00 18.89           C  
ATOM     93  O   LEU A   6      22.110  61.081  19.074  1.00 18.25           O  
ATOM     94  CB  LEU A   6      21.270  58.967  17.487  1.00 17.05           C  
ATOM     95  CG  LEU A   6      21.140  57.621  16.775  1.00 17.71           C  
ATOM     96  CD1 LEU A   6      21.305  57.910  15.287  1.00 17.15           C  
ATOM     97  CD2 LEU A   6      22.260  56.638  17.293  1.00 18.10           C  
ATOM     98  N   ASP A   7      21.007  60.439  20.914  1.00 19.36           N  
ATOM     99  CA  ASP A   7      21.218  61.747  21.546  1.00 21.63           C  
ATOM    100  C   ASP A   7      22.699  62.028  21.814  1.00 20.60           C  
ATOM    101  O   ASP A   7      23.084  63.183  21.892  1.00 22.31           O  
ATOM    102  CB  ASP A   7      20.358  61.973  22.802  1.00 24.67           C  
ATOM    103  CG  ASP A   7      20.712  61.056  23.955  1.00 27.61           C  
ATOM    104  OD1 ASP A   7      21.503  60.119  23.759  1.00 29.11           O  
ATOM    105  OD2 ASP A   7      20.157  61.261  25.083  1.00 30.07           O  
ATOM    106  N   TRP A   8      23.534  60.997  21.904  1.00 18.03           N  
ATOM    107  CA  TRP A   8      24.988  61.238  22.127  1.00 18.25           C  
ATOM    108  C   TRP A   8      25.769  61.660  20.857  1.00 17.52           C  
ATOM    109  O   TRP A   8      26.950  62.062  20.933  1.00 18.14           O  
ATOM    110  CB  TRP A   8      25.636  59.981  22.710  1.00 19.08           C  
ATOM    111  CG  TRP A   8      25.739  58.816  21.738  1.00 19.20           C  
ATOM    112  CD1 TRP A   8      26.834  58.479  20.957  1.00 17.43           C  
ATOM    113  CD2 TRP A   8      24.743  57.814  21.477  1.00 17.69           C  
ATOM    114  NE1 TRP A   8      26.560  57.338  20.237  1.00 16.91           N  
ATOM    115  CE2 TRP A   8      25.288  56.913  20.540  1.00 18.57           C  
ATOM    116  CE3 TRP A   8      23.437  57.585  21.959  1.00 20.12           C  
ATOM    117  CZ2 TRP A   8      24.563  55.816  20.049  1.00 19.17           C  
ATOM    118  CZ3 TRP A   8      22.736  56.506  21.482  1.00 18.84           C  
ATOM    119  CH2 TRP A   8      23.294  55.635  20.531  1.00 18.34           C  
ATOM    120  N   VAL A   9      25.117  61.532  19.697  1.00 16.63           N  
ATOM    121  CA  VAL A   9      25.764  61.710  18.407  1.00 16.49           C  
ATOM    122  C   VAL A   9      25.601  63.182  17.970  1.00 17.27           C  
ATOM    123  O   VAL A   9      24.514  63.754  18.154  1.00 18.02           O  
ATOM    124  CB  VAL A   9      25.097  60.785  17.339  1.00 16.07           C  
ATOM    125  CG1 VAL A   9      25.868  60.888  15.995  1.00 14.66           C  
ATOM    126  CG2 VAL A   9      25.062  59.301  17.814  1.00 15.96           C  
ATOM    127  N   ASP A  10      26.658  63.785  17.396  1.00 16.82           N  
ATOM    128  CA  ASP A  10      26.584  65.190  16.997  1.00 19.19           C  
ATOM    129  C   ASP A  10      26.024  65.306  15.583  1.00 19.43           C  
ATOM    130  O   ASP A  10      25.861  64.292  14.871  1.00 17.39           O  
ATOM    131  CB  ASP A  10      27.950  65.907  17.115  1.00 20.28           C  
ATOM    132  CG  ASP A  10      29.044  65.313  16.205  1.00 22.53           C  
ATOM    133  OD1 ASP A  10      28.755  64.501  15.314  1.00 21.37           O  
ATOM    134  OD2 ASP A  10      30.228  65.711  16.371  1.00 23.92           O  
ATOM    135  N   ARG A  11      25.773  66.539  15.163  1.00 21.84           N  
ATOM    136  CA  ARG A  11      25.126  66.715  13.869  1.00 23.29           C  
ATOM    137  C   ARG A  11      25.973  66.186  12.698  1.00 21.37           C  
ATOM    138  O   ARG A  11      25.413  65.672  11.741  1.00 20.12           O  
ATOM    139  CB  ARG A  11      24.684  68.163  13.669  1.00 25.65           C  
ATOM    140  CG  ARG A  11      23.308  68.426  14.381  1.00 28.45           C  
ATOM    141  CD  ARG A  11      22.775  69.835  14.148  1.00 32.48           C  
ATOM    142  NE  ARG A  11      21.782  70.223  15.159  1.00 40.84           N  
ATOM    143  CZ  ARG A  11      20.491  70.430  14.900  1.00 44.10           C  
ATOM    144  NH1 ARG A  11      20.030  70.280  13.666  1.00 46.46           N  
ATOM    145  NH2 ARG A  11      19.658  70.799  15.869  1.00 46.52           N  
ATOM    146  N   ARG A  12      27.296  66.335  12.780  1.00 20.42           N  
ATOM    147  CA  ARG A  12      28.175  65.870  11.697  1.00 20.23           C  
ATOM    148  C   ARG A  12      28.101  64.377  11.545  1.00 17.94           C  
ATOM    149  O   ARG A  12      27.989  63.880  10.409  1.00 16.70           O  
ATOM    150  CB  ARG A  12      29.626  66.295  11.891  1.00 21.13           C  
ATOM    151  CG  ARG A  12      30.608  65.592  10.893  1.00 21.87           C  
ATOM    152  CD  ARG A  12      31.988  66.204  10.914  1.00 25.37           C  
ATOM    153  NE  ARG A  12      31.972  67.563  10.393  1.00 30.98           N  
ATOM    154  CZ  ARG A  12      32.905  68.465  10.635  1.00 37.60           C  
ATOM    155  NH1 ARG A  12      33.943  68.166  11.406  1.00 37.41           N  
ATOM    156  NH2 ARG A  12      32.784  69.686  10.121  1.00 39.44           N  
ATOM    157  N   GLN A  13      28.170  63.644  12.666  1.00 15.85           N  
ATOM    158  CA  GLN A  13      28.090  62.181  12.584  1.00 14.76           C  
ATOM    159  C   GLN A  13      26.699  61.722  12.143  1.00 15.43           C  
ATOM    160  O   GLN A  13      26.580  60.730  11.440  1.00 16.17           O  
ATOM    161  CB  GLN A  13      28.538  61.474  13.858  1.00 13.92           C  
ATOM    162  CG  GLN A  13      30.005  61.716  14.238  1.00 14.44           C  
ATOM    163  CD  GLN A  13      30.963  61.518  13.078  1.00 18.67           C  
ATOM    164  OE1 GLN A  13      30.901  60.490  12.385  1.00 17.50           O  
ATOM    165  NE2 GLN A  13      31.882  62.474  12.874  1.00 14.46           N  
ATOM    166  N   LEU A  14      25.660  62.435  12.566  1.00 15.60           N  
ATOM    167  CA  LEU A  14      24.314  62.118  12.059  1.00 15.85           C  
ATOM    168  C   LEU A  14      24.223  62.287  10.544  1.00 16.05           C  
ATOM    169  O   LEU A  14      23.585  61.479   9.862  1.00 16.56           O  
ATOM    170  CB  LEU A  14      23.257  62.966  12.756  1.00 16.79           C  
ATOM    171  CG  LEU A  14      23.055  62.611  14.234  1.00 15.30           C  
ATOM    172  CD1 LEU A  14      22.113  63.617  14.897  1.00 18.65           C  
ATOM    173  CD2 LEU A  14      22.573  61.130  14.448  1.00 14.88           C  
ATOM    174  N   GLN A  15      24.811  63.352  10.007  1.00 17.54           N  
ATOM    175  CA  GLN A  15      24.752  63.605   8.554  1.00 20.00           C  
ATOM    176  C   GLN A  15      25.468  62.467   7.817  1.00 18.50           C  
ATOM    177  O   GLN A  15      25.019  62.056   6.727  1.00 18.74           O  
ATOM    178  CB  GLN A  15      25.417  64.953   8.208  1.00 21.18           C  
ATOM    179  CG  GLN A  15      24.606  66.200   8.731  1.00 26.95           C  
ATOM    180  CD  GLN A  15      25.389  67.548   8.647  1.00 30.04           C  
ATOM    181  OE1 GLN A  15      26.644  67.583   8.651  1.00 37.14           O  
ATOM    182  NE2 GLN A  15      24.638  68.661   8.583  1.00 38.35           N  
ATOM    183  N   ARG A  16      26.553  61.959   8.400  1.00 16.28           N  
ATOM    184  CA  ARG A  16      27.382  60.907   7.745  1.00 16.72           C  
ATOM    185  C   ARG A  16      26.641  59.564   7.646  1.00 16.36           C  
ATOM    186  O   ARG A  16      27.026  58.700   6.860  1.00 18.29           O  
ATOM    187  CB  ARG A  16      28.744  60.761   8.442  1.00 16.46           C  
ATOM    188  CG  ARG A  16      29.608  61.992   8.277  1.00 18.23           C  
ATOM    189  CD  ARG A  16      31.014  61.816   8.856  1.00 19.43           C  
ATOM    190  NE  ARG A  16      31.689  60.799   8.063  1.00 19.68           N  
ATOM    191  CZ  ARG A  16      31.994  59.597   8.531  1.00 19.07           C  
ATOM    192  NH1 ARG A  16      31.788  59.306   9.829  1.00 19.64           N  
ATOM    193  NH2 ARG A  16      32.524  58.710   7.711  1.00 20.49           N  
ATOM    194  N   LEU A  17      25.545  59.418   8.415  1.00 16.74           N  
ATOM    195  CA  LEU A  17      24.736  58.186   8.357  1.00 15.97           C  
ATOM    196  C   LEU A  17      24.155  58.009   6.970  1.00 16.58           C  
ATOM    197  O   LEU A  17      23.745  56.907   6.619  1.00 17.68           O  
ATOM    198  CB  LEU A  17      23.616  58.205   9.397  1.00 16.37           C  
ATOM    199  CG  LEU A  17      24.162  57.992  10.823  1.00 18.55           C  
ATOM    200  CD1 LEU A  17      23.061  58.115  11.864  1.00 20.53           C  
ATOM    201  CD2 LEU A  17      24.791  56.577  10.885  1.00 22.01           C  
ATOM    202  N   GLU A  18      24.098  59.087   6.189  1.00 18.07           N  
ATOM    203  CA  GLU A  18      23.560  58.952   4.829  1.00 20.78           C  
ATOM    204  C   GLU A  18      24.594  58.575   3.743  1.00 18.84           C  
ATOM    205  O   GLU A  18      24.222  58.410   2.585  1.00 19.89           O  
ATOM    206  CB  GLU A  18      22.681  60.169   4.457  1.00 26.35           C  
ATOM    207  CG  GLU A  18      21.449  60.352   5.412  1.00 34.16           C  
ATOM    208  CD  GLU A  18      20.644  59.029   5.759  1.00 42.56           C  
ATOM    209  OE1 GLU A  18      20.110  58.397   4.809  1.00 43.40           O  
ATOM    210  OE2 GLU A  18      20.535  58.642   6.992  1.00 43.02           O  
ATOM    211  N   GLU A  19      25.875  58.439   4.115  1.00 16.65           N  
ATOM    212  CA  GLU A  19      26.924  58.055   3.135  1.00 18.46           C  
ATOM    213  C   GLU A  19      26.512  56.703   2.539  1.00 17.15           C  
ATOM    214  O   GLU A  19      25.973  55.833   3.258  1.00 15.51           O  
ATOM    215  CB  GLU A  19      28.273  57.808   3.852  1.00 18.59           C  
ATOM    216  CG  GLU A  19      29.059  59.056   4.164  1.00 25.38           C  
ATOM    217  CD  GLU A  19      30.401  58.772   4.842  1.00 25.63           C  
ATOM    218  OE1 GLU A  19      30.781  57.591   5.080  1.00 29.85           O  
ATOM    219  OE2 GLU A  19      31.059  59.734   5.197  1.00 33.79           O  
ATOM    220  N   MET A  20      26.743  56.538   1.235  1.00 17.42           N  
ATOM    221  CA  MET A  20      26.455  55.265   0.547  1.00 16.09           C  
ATOM    222  C   MET A  20      27.716  54.374   0.540  1.00 15.13           C  
ATOM    223  O   MET A  20      28.739  54.729  -0.052  1.00 16.22           O  
ATOM    224  CB  MET A  20      26.008  55.556  -0.893  1.00 17.47           C  
ATOM    225  CG  MET A  20      24.690  56.342  -0.978  1.00 23.86           C  
ATOM    226  SD  MET A  20      23.310  55.485  -0.164  1.00 34.13           S  
ATOM    227  CE  MET A  20      23.528  53.899  -0.740  1.00 17.57           C  
ATOM    228  N   LEU A  21      27.603  53.220   1.202  1.00 14.11           N  
ATOM    229  CA  LEU A  21      28.683  52.258   1.384  1.00 15.82           C  
ATOM    230  C   LEU A  21      28.568  51.155   0.346  1.00 16.47           C  
ATOM    231  O   LEU A  21      27.571  51.082  -0.395  1.00 15.50           O  
ATOM    232  CB  LEU A  21      28.632  51.667   2.788  1.00 16.95           C  
ATOM    233  CG  LEU A  21      28.595  52.654   3.964  1.00 18.64           C  
ATOM    234  CD1 LEU A  21      28.837  51.881   5.284  1.00 17.40           C  
ATOM    235  CD2 LEU A  21      29.592  53.789   3.775  1.00 22.45           C  
ATOM    236  N   ILE A  22      29.596  50.305   0.276  1.00 14.43           N  
ATOM    237  CA  ILE A  22      29.659  49.264  -0.718  1.00 14.43           C  
ATOM    238  C   ILE A  22      29.235  47.980  -0.010  1.00 15.43           C  
ATOM    239  O   ILE A  22      29.907  47.504   0.936  1.00 14.87           O  
ATOM    240  CB  ILE A  22      31.112  49.103  -1.239  1.00 14.37           C  
ATOM    241  CG1 ILE A  22      31.596  50.407  -1.881  1.00 15.70           C  
ATOM    242  CG2 ILE A  22      31.207  47.872  -2.211  1.00 13.33           C  
ATOM    243  CD1 ILE A  22      33.092  50.396  -2.233  1.00 16.99           C  
ATOM    244  N   VAL A  23      28.102  47.438  -0.449  1.00 15.50           N  
ATOM    245  CA  VAL A  23      27.603  46.176   0.094  1.00 15.63           C  
ATOM    246  C   VAL A  23      28.223  45.010  -0.666  1.00 15.78           C  
ATOM    247  O   VAL A  23      28.272  44.983  -1.900  1.00 18.37           O  
ATOM    248  CB  VAL A  23      26.067  46.108   0.028  1.00 16.50           C  
ATOM    249  CG1 VAL A  23      25.533  44.724   0.506  1.00 16.13           C  
ATOM    250  CG2 VAL A  23      25.442  47.242   0.897  1.00 17.14           C  
ATOM    251  N   VAL A  24      28.685  44.016   0.078  1.00 16.26           N  
ATOM    252  CA  VAL A  24      29.399  42.909  -0.522  1.00 15.94           C  
ATOM    253  C   VAL A  24      28.890  41.584   0.007  1.00 16.63           C  
ATOM    254  O   VAL A  24      28.237  41.508   1.067  1.00 18.17           O  
ATOM    255  CB  VAL A  24      30.959  42.949  -0.278  1.00 14.15           C  
ATOM    256  CG1 VAL A  24      31.648  44.196  -0.920  1.00 13.78           C  
ATOM    257  CG2 VAL A  24      31.324  42.860   1.214  1.00 14.53           C  
ATOM    258  N   ASP A  25      29.216  40.519  -0.717  1.00 17.66           N  
ATOM    259  CA  ASP A  25      28.966  39.191  -0.194  1.00 19.48           C  
ATOM    260  C   ASP A  25      30.180  38.697   0.612  1.00 19.27           C  
ATOM    261  O   ASP A  25      31.157  39.457   0.821  1.00 17.17           O  
ATOM    262  CB  ASP A  25      28.506  38.193  -1.290  1.00 22.94           C  
ATOM    263  CG  ASP A  25      29.608  37.856  -2.319  1.00 23.58           C  
ATOM    264  OD1 ASP A  25      30.805  38.087  -2.055  1.00 19.80           O  
ATOM    265  OD2 ASP A  25      29.248  37.297  -3.377  1.00 26.30           O  
ATOM    266  N   GLU A  26      30.114  37.453   1.084  1.00 20.16           N  
ATOM    267  CA  GLU A  26      31.167  36.918   1.968  1.00 22.25           C  
ATOM    268  C   GLU A  26      32.491  36.730   1.264  1.00 21.83           C  
ATOM    269  O   GLU A  26      33.514  36.503   1.901  1.00 23.17           O  
ATOM    270  CB  GLU A  26      30.752  35.591   2.605  1.00 24.50           C  
ATOM    271  CG  GLU A  26      29.751  35.777   3.700  1.00 31.19           C  
ATOM    272  CD  GLU A  26      29.409  34.491   4.432  1.00 40.58           C  
ATOM    273  OE1 GLU A  26      29.682  33.376   3.900  1.00 41.67           O  
ATOM    274  OE2 GLU A  26      28.871  34.606   5.555  1.00 45.81           O  
ATOM    275  N   ASN A  27      32.476  36.777  -0.051  1.00 21.65           N  
ATOM    276  CA  ASN A  27      33.720  36.671  -0.827  1.00 21.26           C  
ATOM    277  C   ASN A  27      34.177  38.020  -1.347  1.00 19.23           C  
ATOM    278  O   ASN A  27      35.025  38.084  -2.270  1.00 19.12           O  
ATOM    279  CB  ASN A  27      33.499  35.737  -2.025  1.00 22.87           C  
ATOM    280  CG  ASN A  27      33.155  34.327  -1.599  1.00 30.05           C  
ATOM    281  OD1 ASN A  27      33.874  33.720  -0.799  1.00 35.50           O  
ATOM    282  ND2 ASN A  27      32.057  33.792  -2.136  1.00 32.23           N  
ATOM    283  N   ASP A  28      33.610  39.101  -0.794  1.00 17.24           N  
ATOM    284  CA  ASP A  28      34.037  40.465  -1.121  1.00 15.86           C  
ATOM    285  C   ASP A  28      33.631  40.876  -2.540  1.00 16.84           C  
ATOM    286  O   ASP A  28      34.259  41.764  -3.149  1.00 17.07           O  
ATOM    287  CB  ASP A  28      35.573  40.672  -0.877  1.00 15.40           C  
ATOM    288  CG  ASP A  28      36.008  42.163  -0.934  1.00 18.37           C  
ATOM    289  OD1 ASP A  28      35.231  43.028  -0.463  1.00 15.79           O  
ATOM    290  OD2 ASP A  28      37.129  42.477  -1.397  1.00 18.45           O  
ATOM    291  N   LYS A  29      32.573  40.264  -3.067  1.00 16.89           N  
ATOM    292  CA  LYS A  29      32.068  40.721  -4.365  1.00 19.64           C  
ATOM    293  C   LYS A  29      30.975  41.772  -4.136  1.00 18.30           C  
ATOM    294  O   LYS A  29      30.077  41.582  -3.308  1.00 19.03           O  
ATOM    295  CB  LYS A  29      31.544  39.550  -5.146  1.00 22.21           C  
ATOM    296  CG  LYS A  29      32.607  38.428  -5.281  1.00 26.09           C  
ATOM    297  CD  LYS A  29      33.836  38.901  -6.060  1.00 32.29           C  
ATOM    298  CE  LYS A  29      34.878  37.799  -6.132  1.00 36.43           C  
ATOM    299  NZ  LYS A  29      36.091  38.288  -6.836  1.00 40.74           N  
ATOM    300  N   VAL A  30      31.090  42.890  -4.853  1.00 18.94           N  
ATOM    301  CA  VAL A  30      30.119  43.974  -4.759  1.00 17.82           C  
ATOM    302  C   VAL A  30      28.741  43.530  -5.227  1.00 19.86           C  
ATOM    303  O   VAL A  30      28.526  43.068  -6.370  1.00 19.92           O  
ATOM    304  CB  VAL A  30      30.551  45.215  -5.562  1.00 19.64           C  
ATOM    305  CG1 VAL A  30      29.465  46.325  -5.488  1.00 20.52           C  
ATOM    306  CG2 VAL A  30      31.882  45.752  -5.029  1.00 18.07           C  
ATOM    307  N   ILE A  31      27.785  43.704  -4.343  1.00 19.40           N  
ATOM    308  CA  ILE A  31      26.425  43.380  -4.716  1.00 23.05           C  
ATOM    309  C   ILE A  31      25.495  44.604  -4.740  1.00 21.85           C  
ATOM    310  O   ILE A  31      24.431  44.545  -5.371  1.00 23.96           O  
ATOM    311  CB  ILE A  31      25.863  42.113  -3.958  1.00 25.03           C  
ATOM    312  CG1 ILE A  31      25.759  42.372  -2.468  1.00 24.54           C  
ATOM    313  CG2 ILE A  31      26.762  40.877  -4.201  1.00 25.91           C  
ATOM    314  CD1 ILE A  31      25.432  41.102  -1.680  1.00 24.06           C  
ATOM    315  N   GLY A  32      25.914  45.720  -4.143  1.00 19.37           N  
ATOM    316  CA  GLY A  32      25.139  46.954  -4.265  1.00 20.78           C  
ATOM    317  C   GLY A  32      25.657  48.034  -3.359  1.00 18.37           C  
ATOM    318  O   GLY A  32      26.811  47.975  -2.903  1.00 17.94           O  
ATOM    319  N   ALA A  33      24.801  49.017  -3.112  1.00 20.91           N  
ATOM    320  CA  ALA A  33      25.064  50.145  -2.213  1.00 19.13           C  
ATOM    321  C   ALA A  33      23.971  50.209  -1.145  1.00 18.49           C  
ATOM    322  O   ALA A  33      22.819  49.825  -1.402  1.00 19.29           O  
ATOM    323  CB  ALA A  33      25.059  51.463  -3.013  1.00 18.98           C  
ATOM    324  N   ASP A  34      24.318  50.689   0.044  1.00 16.87           N  
ATOM    325  CA  ASP A  34      23.319  50.997   1.064  1.00 16.54           C  
ATOM    326  C   ASP A  34      23.939  51.991   2.031  1.00 15.66           C  
ATOM    327  O   ASP A  34      25.165  52.171   2.048  1.00 15.82           O  
ATOM    328  CB  ASP A  34      22.930  49.705   1.811  1.00 17.71           C  
ATOM    329  CG  ASP A  34      21.509  49.744   2.401  1.00 19.20           C  
ATOM    330  OD1 ASP A  34      20.887  50.836   2.545  1.00 19.50           O  
ATOM    331  OD2 ASP A  34      21.040  48.645   2.784  1.00 22.41           O  
ATOM    332  N   THR A  35      23.116  52.627   2.847  1.00 15.85           N  
ATOM    333  CA  THR A  35      23.594  53.711   3.717  1.00 14.89           C  
ATOM    334  C   THR A  35      24.380  53.218   4.903  1.00 14.84           C  
ATOM    335  O   THR A  35      24.245  52.044   5.349  1.00 14.12           O  
ATOM    336  CB  THR A  35      22.425  54.547   4.267  1.00 15.18           C  
ATOM    337  OG1 THR A  35      21.508  53.677   4.963  1.00 14.40           O  
ATOM    338  CG2 THR A  35      21.702  55.238   3.089  1.00 16.36           C  
ATOM    339  N   LYS A  36      25.177  54.122   5.450  1.00 14.33           N  
ATOM    340  CA  LYS A  36      25.936  53.835   6.660  1.00 15.13           C  
ATOM    341  C   LYS A  36      24.941  53.437   7.772  1.00 14.99           C  
ATOM    342  O   LYS A  36      25.166  52.453   8.503  1.00 14.79           O  
ATOM    343  CB  LYS A  36      26.766  55.055   7.062  1.00 15.13           C  
ATOM    344  CG  LYS A  36      27.574  54.838   8.354  1.00 16.83           C  
ATOM    345  CD  LYS A  36      28.363  56.120   8.664  1.00 19.71           C  
ATOM    346  CE  LYS A  36      29.093  56.014  10.067  1.00 21.75           C  
ATOM    347  NZ  LYS A  36      30.328  55.230   9.880  1.00 26.36           N  
ATOM    348  N   ARG A  37      23.839  54.187   7.886  1.00 14.64           N  
ATOM    349  CA  ARG A  37      22.798  53.861   8.878  1.00 14.78           C  
ATOM    350  C   ARG A  37      22.409  52.384   8.712  1.00 14.52           C  
ATOM    351  O   ARG A  37      22.444  51.600   9.677  1.00 14.70           O  
ATOM    352  CB  ARG A  37      21.571  54.747   8.648  1.00 14.99           C  
ATOM    353  CG  ARG A  37      20.363  54.445   9.595  1.00 18.42           C  
ATOM    354  CD  ARG A  37      19.192  55.407   9.302  1.00 18.48           C  
ATOM    355  NE  ARG A  37      19.482  56.832   9.502  1.00 19.90           N  
ATOM    356  CZ  ARG A  37      19.345  57.504  10.649  1.00 23.79           C  
ATOM    357  NH1 ARG A  37      18.971  56.898  11.753  1.00 23.35           N  
ATOM    358  NH2 ARG A  37      19.628  58.811  10.699  1.00 27.90           N  
ATOM    359  N   ASN A  38      21.987  52.014   7.495  1.00 14.15           N  
ATOM    360  CA  ASN A  38      21.428  50.660   7.303  1.00 15.93           C  
ATOM    361  C   ASN A  38      22.473  49.569   7.580  1.00 15.38           C  
ATOM    362  O   ASN A  38      22.177  48.520   8.193  1.00 16.22           O  
ATOM    363  CB  ASN A  38      20.857  50.504   5.907  1.00 15.42           C  
ATOM    364  CG  ASN A  38      19.454  51.081   5.799  1.00 19.24           C  
ATOM    365  OD1 ASN A  38      18.826  51.386   6.822  1.00 20.79           O  
ATOM    366  ND2 ASN A  38      18.963  51.256   4.572  1.00 18.07           N  
ATOM    367  N   CYS A  39      23.699  49.845   7.149  1.00 14.40           N  
ATOM    368  CA  CYS A  39      24.784  48.850   7.265  1.00 15.52           C  
ATOM    369  C   CYS A  39      25.208  48.614   8.712  1.00 15.00           C  
ATOM    370  O   CYS A  39      25.822  47.568   9.025  1.00 15.30           O  
ATOM    371  CB  CYS A  39      26.016  49.304   6.467  1.00 15.03           C  
ATOM    372  SG  CYS A  39      25.770  49.173   4.662  1.00 16.01           S  
ATOM    373  N   HIS A  40      24.881  49.556   9.601  1.00 14.43           N  
ATOM    374  CA  HIS A  40      25.341  49.424  10.981  1.00 14.16           C  
ATOM    375  C   HIS A  40      24.210  49.143  11.980  1.00 14.14           C  
ATOM    376  O   HIS A  40      24.416  49.148  13.197  1.00 14.87           O  
ATOM    377  CB  HIS A  40      26.216  50.643  11.335  1.00 15.43           C  
ATOM    378  CG  HIS A  40      27.519  50.654  10.567  1.00 15.55           C  
ATOM    379  ND1 HIS A  40      27.624  51.197   9.301  1.00 19.12           N  
ATOM    380  CD2 HIS A  40      28.729  50.086  10.836  1.00 19.63           C  
ATOM    381  CE1 HIS A  40      28.869  51.014   8.857  1.00 19.06           C  
ATOM    382  NE2 HIS A  40      29.554  50.309   9.752  1.00 17.12           N  
ATOM    383  N   LEU A  41      23.039  48.818  11.464  1.00 13.81           N  
ATOM    384  CA  LEU A  41      21.916  48.372  12.305  1.00 14.27           C  
ATOM    385  C   LEU A  41      21.973  46.852  12.522  1.00 14.79           C  
ATOM    386  O   LEU A  41      22.004  46.082  11.556  1.00 14.51           O  
ATOM    387  CB  LEU A  41      20.573  48.782  11.671  1.00 15.15           C  
ATOM    388  CG  LEU A  41      20.173  50.271  11.844  1.00 14.54           C  
ATOM    389  CD1 LEU A  41      18.972  50.593  10.923  1.00 16.81           C  
ATOM    390  CD2 LEU A  41      19.799  50.632  13.308  1.00 14.99           C  
ATOM    391  N   ASN A  42      21.964  46.427  13.779  1.00 14.40           N  
ATOM    392  CA  ASN A  42      21.987  44.975  14.069  1.00 15.97           C  
ATOM    393  C   ASN A  42      20.816  44.218  13.424  1.00 16.50           C  
ATOM    394  O   ASN A  42      20.985  43.112  12.924  1.00 16.32           O  
ATOM    395  CB  ASN A  42      22.039  44.686  15.593  1.00 16.69           C  
ATOM    396  CG  ASN A  42      23.337  45.176  16.228  1.00 16.71           C  
ATOM    397  OD1 ASN A  42      24.382  45.183  15.584  1.00 16.36           O  
ATOM    398  ND2 ASN A  42      23.274  45.563  17.491  1.00 16.94           N  
ATOM    399  N   GLU A  43      19.648  44.850  13.395  1.00 17.83           N  
ATOM    400  CA  GLU A  43      18.468  44.271  12.755  1.00 18.13           C  
ATOM    401  C   GLU A  43      18.691  43.890  11.276  1.00 19.36           C  
ATOM    402  O   GLU A  43      18.049  42.948  10.766  1.00 21.24           O  
ATOM    403  CB  GLU A  43      17.271  45.216  12.912  1.00 19.32           C  
ATOM    404  CG  GLU A  43      17.369  46.499  12.098  1.00 19.69           C  
ATOM    405  CD  GLU A  43      16.550  47.630  12.698  1.00 25.81           C  
ATOM    406  OE1 GLU A  43      16.674  47.893  13.922  1.00 26.40           O  
ATOM    407  OE2 GLU A  43      15.833  48.282  11.922  1.00 26.19           O  
ATOM    408  N   ASN A  44      19.586  44.605  10.595  1.00 17.47           N  
ATOM    409  CA  ASN A  44      19.929  44.331   9.190  1.00 18.48           C  
ATOM    410  C   ASN A  44      21.110  43.380   9.077  1.00 18.82           C  
ATOM    411  O   ASN A  44      21.120  42.487   8.217  1.00 19.93           O  
ATOM    412  CB  ASN A  44      20.222  45.626   8.389  1.00 18.20           C  
ATOM    413  CG  ASN A  44      19.002  46.539   8.266  1.00 20.46           C  
ATOM    414  OD1 ASN A  44      17.853  46.064   8.284  1.00 22.01           O  
ATOM    415  ND2 ASN A  44      19.242  47.864   8.140  1.00 17.64           N  
ATOM    416  N   ILE A  45      22.079  43.560   9.974  1.00 17.68           N  
ATOM    417  CA  ILE A  45      23.259  42.711  10.030  1.00 17.73           C  
ATOM    418  C   ILE A  45      22.841  41.255  10.293  1.00 19.76           C  
ATOM    419  O   ILE A  45      23.396  40.327   9.705  1.00 20.44           O  
ATOM    420  CB  ILE A  45      24.194  43.203  11.137  1.00 16.08           C  
ATOM    421  CG1 ILE A  45      24.920  44.487  10.653  1.00 15.83           C  
ATOM    422  CG2 ILE A  45      25.213  42.093  11.566  1.00 17.65           C  
ATOM    423  CD1 ILE A  45      25.718  45.193  11.759  1.00 17.38           C  
ATOM    424  N   GLU A  46      21.838  41.072  11.149  1.00 20.37           N  
ATOM    425  CA  GLU A  46      21.369  39.729  11.454  1.00 23.77           C  
ATOM    426  C   GLU A  46      20.672  39.034  10.282  1.00 24.45           C  
ATOM    427  O   GLU A  46      20.536  37.802  10.273  1.00 25.22           O  
ATOM    428  CB  GLU A  46      20.558  39.730  12.745  1.00 24.29           C  
ATOM    429  CG  GLU A  46      21.554  39.939  13.917  1.00 29.35           C  
ATOM    430  CD  GLU A  46      22.618  38.800  14.008  1.00 34.34           C  
ATOM    431  OE1 GLU A  46      23.853  39.055  13.911  1.00 31.23           O  
ATOM    432  OE2 GLU A  46      22.189  37.622  14.155  1.00 38.38           O  
ATOM    433  N   LYS A  47      20.261  39.830   9.302  1.00 23.60           N  
ATOM    434  CA  LYS A  47      19.691  39.309   8.049  1.00 26.05           C  
ATOM    435  C   LYS A  47      20.800  39.037   7.024  1.00 24.73           C  
ATOM    436  O   LYS A  47      20.536  38.496   5.942  1.00 25.71           O  
ATOM    437  CB  LYS A  47      18.655  40.295   7.492  1.00 26.32           C  
ATOM    438  CG  LYS A  47      17.409  40.482   8.380  1.00 29.42           C  
ATOM    439  CD  LYS A  47      16.214  41.026   7.550  1.00 31.01           C  
ATOM    440  CE  LYS A  47      16.394  42.546   7.167  1.00 35.92           C  
ATOM    441  NZ  LYS A  47      15.191  43.101   6.406  1.00 34.86           N  
ATOM    442  N   GLY A  48      22.042  39.406   7.366  1.00 23.34           N  
ATOM    443  CA  GLY A  48      23.187  39.110   6.522  1.00 22.33           C  
ATOM    444  C   GLY A  48      23.866  40.320   5.893  1.00 20.83           C  
ATOM    445  O   GLY A  48      24.923  40.197   5.244  1.00 20.45           O  
ATOM    446  N   LEU A  49      23.293  41.504   6.096  1.00 19.46           N  
ATOM    447  CA  LEU A  49      23.864  42.696   5.465  1.00 17.72           C  
ATOM    448  C   LEU A  49      25.344  42.853   5.844  1.00 17.31           C  
ATOM    449  O   LEU A  49      25.701  42.845   7.031  1.00 16.27           O  
ATOM    450  CB  LEU A  49      23.078  43.955   5.862  1.00 17.88           C  
ATOM    451  CG  LEU A  49      23.468  45.211   5.066  1.00 17.09           C  
ATOM    452  CD1 LEU A  49      23.286  45.050   3.540  1.00 16.41           C  
ATOM    453  CD2 LEU A  49      22.577  46.356   5.561  1.00 16.95           C  
ATOM    454  N   LEU A  50      26.190  43.012   4.823  1.00 16.78           N  
ATOM    455  CA  LEU A  50      27.649  43.025   4.994  1.00 15.99           C  
ATOM    456  C   LEU A  50      28.231  44.082   4.072  1.00 16.17           C  
ATOM    457  O   LEU A  50      27.807  44.174   2.902  1.00 15.75           O  
ATOM    458  CB  LEU A  50      28.203  41.653   4.585  1.00 16.20           C  
ATOM    459  CG  LEU A  50      29.707  41.374   4.602  1.00 14.52           C  
ATOM    460  CD1 LEU A  50      30.283  41.546   6.016  1.00 17.04           C  
ATOM    461  CD2 LEU A  50      29.927  39.900   4.156  1.00 17.33           C  
ATOM    462  N   HIS A  51      29.213  44.852   4.570  1.00 15.37           N  
ATOM    463  CA  HIS A  51      29.813  45.914   3.751  1.00 15.74           C  
ATOM    464  C   HIS A  51      31.342  45.849   3.775  1.00 15.25           C  
ATOM    465  O   HIS A  51      31.952  45.274   4.701  1.00 13.60           O  
ATOM    466  CB  HIS A  51      29.300  47.317   4.197  1.00 15.74           C  
ATOM    467  CG  HIS A  51      29.590  47.658   5.652  1.00 16.44           C  
ATOM    468  ND1 HIS A  51      28.847  47.145   6.694  1.00 16.59           N  
ATOM    469  CD2 HIS A  51      30.540  48.450   6.224  1.00 17.12           C  
ATOM    470  CE1 HIS A  51      29.326  47.630   7.848  1.00 16.42           C  
ATOM    471  NE2 HIS A  51      30.339  48.441   7.599  1.00 14.78           N  
ATOM    472  N   ARG A  52      31.957  46.441   2.755  1.00 14.00           N  
ATOM    473  CA  ARG A  52      33.418  46.543   2.695  1.00 14.23           C  
ATOM    474  C   ARG A  52      33.911  47.663   3.611  1.00 13.98           C  
ATOM    475  O   ARG A  52      33.268  48.729   3.724  1.00 15.27           O  
ATOM    476  CB  ARG A  52      33.863  46.830   1.253  1.00 13.85           C  
ATOM    477  CG  ARG A  52      35.380  46.718   1.060  1.00 13.13           C  
ATOM    478  CD  ARG A  52      35.727  46.830  -0.456  1.00 14.24           C  
ATOM    479  NE  ARG A  52      35.307  45.666  -1.258  1.00 14.87           N  
ATOM    480  CZ  ARG A  52      35.064  45.728  -2.576  1.00 16.77           C  
ATOM    481  NH1 ARG A  52      35.183  46.900  -3.230  1.00 17.36           N  
ATOM    482  NH2 ARG A  52      34.716  44.631  -3.254  1.00 15.57           N  
ATOM    483  N   ALA A  53      35.074  47.458   4.234  1.00 13.72           N  
ATOM    484  CA  ALA A  53      35.578  48.437   5.185  1.00 13.09           C  
ATOM    485  C   ALA A  53      37.084  48.347   5.220  1.00 12.92           C  
ATOM    486  O   ALA A  53      37.695  47.481   4.545  1.00 13.43           O  
ATOM    487  CB  ALA A  53      35.008  48.097   6.616  1.00 11.66           C  
ATOM    488  N   PHE A  54      37.701  49.219   6.014  1.00 12.31           N  
ATOM    489  CA  PHE A  54      39.145  49.055   6.294  1.00 13.13           C  
ATOM    490  C   PHE A  54      39.491  49.432   7.718  1.00 13.00           C  
ATOM    491  O   PHE A  54      38.722  50.165   8.412  1.00 12.23           O  
ATOM    492  CB  PHE A  54      40.009  49.875   5.316  1.00 13.39           C  
ATOM    493  CG  PHE A  54      39.758  51.349   5.413  1.00 14.04           C  
ATOM    494  CD1 PHE A  54      40.442  52.123   6.390  1.00 12.72           C  
ATOM    495  CD2 PHE A  54      38.836  51.959   4.551  1.00 15.35           C  
ATOM    496  CE1 PHE A  54      40.166  53.490   6.525  1.00 16.42           C  
ATOM    497  CE2 PHE A  54      38.556  53.357   4.667  1.00 17.55           C  
ATOM    498  CZ  PHE A  54      39.228  54.110   5.659  1.00 14.09           C  
ATOM    499  N   SER A  55      40.667  48.943   8.147  1.00 12.87           N  
ATOM    500  CA  SER A  55      41.310  49.362   9.413  1.00 13.70           C  
ATOM    501  C   SER A  55      42.729  49.721   9.065  1.00 14.68           C  
ATOM    502  O   SER A  55      43.387  48.966   8.339  1.00 14.57           O  
ATOM    503  CB  SER A  55      41.398  48.175  10.386  1.00 15.25           C  
ATOM    504  OG  SER A  55      40.171  48.038  11.069  1.00 21.32           O  
ATOM    505  N   VAL A  56      43.229  50.849   9.574  1.00 12.50           N  
ATOM    506  CA  VAL A  56      44.624  51.208   9.332  1.00 12.23           C  
ATOM    507  C   VAL A  56      45.406  51.035  10.617  1.00 12.71           C  
ATOM    508  O   VAL A  56      44.911  51.386  11.697  1.00 12.29           O  
ATOM    509  CB  VAL A  56      44.769  52.673   8.953  1.00 12.45           C  
ATOM    510  CG1 VAL A  56      46.289  53.051   8.785  1.00 15.52           C  
ATOM    511  CG2 VAL A  56      44.001  53.000   7.634  1.00 12.89           C  
ATOM    512  N   VAL A  57      46.611  50.496  10.497  1.00 12.00           N  
ATOM    513  CA  VAL A  57      47.540  50.511  11.620  1.00 12.48           C  
ATOM    514  C   VAL A  57      48.705  51.400  11.182  1.00 13.48           C  
ATOM    515  O   VAL A  57      49.439  51.084  10.232  1.00 15.20           O  
ATOM    516  CB  VAL A  57      47.910  49.070  12.113  1.00 11.57           C  
ATOM    517  CG1 VAL A  57      46.675  48.464  12.885  1.00 11.18           C  
ATOM    518  CG2 VAL A  57      48.359  48.145  10.932  1.00 12.14           C  
ATOM    519  N   LEU A  58      48.830  52.553  11.843  1.00 12.16           N  
ATOM    520  CA  LEU A  58      49.872  53.524  11.499  1.00 12.44           C  
ATOM    521  C   LEU A  58      50.951  53.560  12.570  1.00 13.50           C  
ATOM    522  O   LEU A  58      50.628  53.747  13.784  1.00 13.53           O  
ATOM    523  CB  LEU A  58      49.212  54.912  11.377  1.00 13.68           C  
ATOM    524  CG  LEU A  58      50.141  56.048  10.888  1.00 17.08           C  
ATOM    525  CD1 LEU A  58      49.262  57.123  10.251  1.00 22.58           C  
ATOM    526  CD2 LEU A  58      50.911  56.618  12.018  1.00 23.54           C  
ATOM    527  N   PHE A  59      52.212  53.398  12.143  1.00 13.66           N  
ATOM    528  CA  PHE A  59      53.362  53.351  13.063  1.00 14.55           C  
ATOM    529  C   PHE A  59      54.300  54.503  12.753  1.00 15.86           C  
ATOM    530  O   PHE A  59      54.547  54.799  11.581  1.00 15.87           O  
ATOM    531  CB  PHE A  59      54.164  52.066  12.867  1.00 15.48           C  
ATOM    532  CG  PHE A  59      53.378  50.816  13.118  1.00 14.29           C  
ATOM    533  CD1 PHE A  59      53.399  50.214  14.370  1.00 15.98           C  
ATOM    534  CD2 PHE A  59      52.549  50.276  12.103  1.00 13.59           C  
ATOM    535  CE1 PHE A  59      52.645  49.029  14.623  1.00 14.40           C  
ATOM    536  CE2 PHE A  59      51.774  49.127  12.347  1.00 14.46           C  
ATOM    537  CZ  PHE A  59      51.817  48.501  13.620  1.00 15.75           C  
ATOM    538  N   ASN A  60      54.862  55.141  13.782  1.00 16.01           N  
ATOM    539  CA  ASN A  60      55.951  56.068  13.509  1.00 16.62           C  
ATOM    540  C   ASN A  60      57.301  55.305  13.348  1.00 17.25           C  
ATOM    541  O   ASN A  60      57.342  54.062  13.439  1.00 17.62           O  
ATOM    542  CB  ASN A  60      56.008  57.209  14.537  1.00 17.42           C  
ATOM    543  CG  ASN A  60      56.411  56.751  15.931  1.00 16.94           C  
ATOM    544  OD1 ASN A  60      56.939  55.648  16.131  1.00 16.61           O  
ATOM    545  ND2 ASN A  60      56.285  57.674  16.900  1.00 18.92           N  
ATOM    546  N   THR A  61      58.388  56.036  13.093  1.00 18.25           N  
ATOM    547  CA  THR A  61      59.695  55.393  12.839  1.00 19.76           C  
ATOM    548  C   THR A  61      60.364  54.907  14.138  1.00 20.43           C  
ATOM    549  O   THR A  61      61.433  54.292  14.091  1.00 21.26           O  
ATOM    550  CB  THR A  61      60.639  56.366  12.107  1.00 20.47           C  
ATOM    551  OG1 THR A  61      60.829  57.539  12.910  1.00 20.22           O  
ATOM    552  CG2 THR A  61      60.043  56.746  10.730  1.00 21.25           C  
ATOM    553  N   LYS A  62      59.763  55.210  15.291  1.00 19.81           N  
ATOM    554  CA  LYS A  62      60.133  54.579  16.569  1.00 21.07           C  
ATOM    555  C   LYS A  62      59.243  53.362  16.909  1.00 19.86           C  
ATOM    556  O   LYS A  62      59.267  52.847  18.053  1.00 19.43           O  
ATOM    557  CB  LYS A  62      60.146  55.598  17.725  1.00 22.93           C  
ATOM    558  CG  LYS A  62      61.211  56.720  17.569  1.00 25.79           C  
ATOM    559  CD  LYS A  62      62.635  56.223  17.711  1.00 31.55           C  
ATOM    560  CE  LYS A  62      63.634  57.390  17.576  1.00 33.34           C  
ATOM    561  NZ  LYS A  62      64.719  57.108  16.572  1.00 37.91           N  
ATOM    562  N   ASN A  63      58.525  52.879  15.891  1.00 17.93           N  
ATOM    563  CA  ASN A  63      57.638  51.717  15.975  1.00 17.64           C  
ATOM    564  C   ASN A  63      56.546  51.820  17.058  1.00 17.85           C  
ATOM    565  O   ASN A  63      56.154  50.814  17.641  1.00 17.61           O  
ATOM    566  CB  ASN A  63      58.486  50.448  16.156  1.00 18.70           C  
ATOM    567  CG  ASN A  63      59.601  50.381  15.121  1.00 21.45           C  
ATOM    568  OD1 ASN A  63      59.351  50.576  13.940  1.00 26.48           O  
ATOM    569  ND2 ASN A  63      60.837  50.234  15.580  1.00 28.33           N  
ATOM    570  N   ARG A  64      56.077  53.040  17.326  1.00 16.17           N  
ATOM    571  CA  ARG A  64      54.880  53.229  18.126  1.00 15.54           C  
ATOM    572  C   ARG A  64      53.672  53.288  17.206  1.00 14.20           C  
ATOM    573  O   ARG A  64      53.701  53.976  16.171  1.00 15.06           O  
ATOM    574  CB  ARG A  64      54.976  54.535  18.922  1.00 15.13           C  
ATOM    575  CG  ARG A  64      56.038  54.470  20.023  1.00 17.67           C  
ATOM    576  CD  ARG A  64      56.051  55.741  20.889  1.00 20.52           C  
ATOM    577  NE  ARG A  64      56.931  55.496  22.039  1.00 27.57           N  
ATOM    578  CZ  ARG A  64      56.518  55.068  23.239  1.00 28.85           C  
ATOM    579  NH1 ARG A  64      55.221  54.906  23.516  1.00 23.16           N  
ATOM    580  NH2 ARG A  64      57.423  54.833  24.180  1.00 27.55           N  
ATOM    581  N   ILE A  65      52.597  52.652  17.637  1.00 14.14           N  
ATOM    582  CA  ILE A  65      51.340  52.633  16.873  1.00 12.79           C  
ATOM    583  C   ILE A  65      50.424  53.743  17.356  1.00 13.52           C  
ATOM    584  O   ILE A  65      50.361  54.040  18.556  1.00 13.70           O  
ATOM    585  CB  ILE A  65      50.621  51.254  16.965  1.00 13.16           C  
ATOM    586  CG1 ILE A  65      49.439  51.177  15.983  1.00 12.86           C  
ATOM    587  CG2 ILE A  65      50.188  50.896  18.454  1.00 12.38           C  
ATOM    588  CD1 ILE A  65      48.811  49.727  15.903  1.00 13.22           C  
ATOM    589  N   LEU A  66      49.726  54.352  16.409  1.00 13.22           N  
ATOM    590  CA  LEU A  66      48.748  55.398  16.719  1.00 13.43           C  
ATOM    591  C   LEU A  66      47.445  54.725  17.129  1.00 13.38           C  
ATOM    592  O   LEU A  66      46.807  54.035  16.316  1.00 13.24           O  
ATOM    593  CB  LEU A  66      48.517  56.255  15.472  1.00 13.90           C  
ATOM    594  CG  LEU A  66      47.741  57.563  15.714  1.00 15.17           C  
ATOM    595  CD1 LEU A  66      47.958  58.525  14.512  1.00 17.94           C  
ATOM    596  CD2 LEU A  66      46.242  57.323  15.896  1.00 17.07           C  
ATOM    597  N   ILE A  67      47.054  54.922  18.388  1.00 13.30           N  
ATOM    598  CA  ILE A  67      45.800  54.356  18.876  1.00 13.09           C  
ATOM    599  C   ILE A  67      44.803  55.513  19.063  1.00 13.98           C  
ATOM    600  O   ILE A  67      45.036  56.447  19.869  1.00 15.06           O  
ATOM    601  CB  ILE A  67      46.011  53.602  20.234  1.00 13.69           C  
ATOM    602  CG1 ILE A  67      46.997  52.422  20.082  1.00 13.84           C  
ATOM    603  CG2 ILE A  67      44.667  53.153  20.861  1.00 12.18           C  
ATOM    604  CD1 ILE A  67      46.526  51.431  18.991  1.00 14.20           C  
ATOM    605  N   GLN A  68      43.740  55.523  18.264  1.00 13.19           N  
ATOM    606  CA  GLN A  68      42.695  56.552  18.462  1.00 13.62           C  
ATOM    607  C   GLN A  68      41.803  56.168  19.596  1.00 13.85           C  
ATOM    608  O   GLN A  68      41.539  54.961  19.810  1.00 15.39           O  
ATOM    609  CB  GLN A  68      41.752  56.645  17.260  1.00 13.89           C  
ATOM    610  CG  GLN A  68      42.338  57.344  16.049  1.00 17.49           C  
ATOM    611  CD  GLN A  68      41.204  57.862  15.160  1.00 22.71           C  
ATOM    612  OE1 GLN A  68      40.185  58.344  15.681  1.00 23.85           O  
ATOM    613  NE2 GLN A  68      41.371  57.762  13.820  1.00 19.39           N  
ATOM    614  N   GLN A  69      41.343  57.176  20.328  1.00 13.97           N  
ATOM    615  CA  GLN A  69      40.116  57.010  21.152  1.00 13.69           C  
ATOM    616  C   GLN A  69      39.006  57.666  20.360  1.00 13.58           C  
ATOM    617  O   GLN A  69      39.096  58.864  20.008  1.00 14.88           O  
ATOM    618  CB  GLN A  69      40.231  57.715  22.490  1.00 14.06           C  
ATOM    619  CG  GLN A  69      39.060  57.364  23.388  1.00 15.54           C  
ATOM    620  CD  GLN A  69      39.096  58.092  24.716  1.00 18.42           C  
ATOM    621  OE1 GLN A  69      39.881  59.026  24.904  1.00 17.58           O  
ATOM    622  NE2 GLN A  69      38.208  57.691  25.649  1.00 17.13           N  
ATOM    623  N   ARG A  70      37.968  56.887  20.070  1.00 13.25           N  
ATOM    624  CA  ARG A  70      36.804  57.406  19.303  1.00 12.85           C  
ATOM    625  C   ARG A  70      36.118  58.459  20.117  1.00 14.14           C  
ATOM    626  O   ARG A  70      36.028  58.341  21.333  1.00 15.08           O  
ATOM    627  CB  ARG A  70      35.814  56.253  18.987  1.00 12.95           C  
ATOM    628  CG  ARG A  70      36.465  55.231  18.059  1.00 13.20           C  
ATOM    629  CD  ARG A  70      35.542  53.994  18.020  1.00 15.85           C  
ATOM    630  NE  ARG A  70      34.322  54.199  17.254  1.00 15.93           N  
ATOM    631  CZ  ARG A  70      34.257  54.289  15.921  1.00 18.07           C  
ATOM    632  NH1 ARG A  70      35.381  54.286  15.170  1.00 16.30           N  
ATOM    633  NH2 ARG A  70      33.071  54.397  15.318  1.00 15.45           N  
ATOM    634  N   SER A  71      35.664  59.521  19.462  0.50 14.22           N  
ATOM    636  CA  SER A  71      34.891  60.531  20.168  0.50 14.75           C  
ATOM    638  C   SER A  71      33.660  59.912  20.822  0.50 15.36           C  
ATOM    640  O   SER A  71      33.209  58.816  20.451  0.50 15.01           O  
ATOM    642  CB  SER A  71      34.460  61.620  19.210  0.50 15.45           C  
ATOM    644  OG  SER A  71      33.515  61.107  18.299  0.50 13.37           O  
ATOM    646  N   ASP A  72      33.119  60.627  21.799  1.00 16.34           N  
ATOM    647  CA  ASP A  72      31.881  60.246  22.453  1.00 15.96           C  
ATOM    648  C   ASP A  72      30.703  60.448  21.515  1.00 16.21           C  
ATOM    649  O   ASP A  72      29.605  59.962  21.785  1.00 17.59           O  
ATOM    650  CB  ASP A  72      31.677  61.092  23.708  1.00 17.74           C  
ATOM    651  CG  ASP A  72      32.651  60.719  24.828  1.00 20.49           C  
ATOM    652  OD1 ASP A  72      33.032  59.529  24.962  1.00 22.79           O  
ATOM    653  OD2 ASP A  72      33.041  61.635  25.550  1.00 25.87           O  
ATOM    654  N   THR A  73      30.934  61.128  20.397  1.00 16.09           N  
ATOM    655  CA  THR A  73      29.848  61.399  19.449  1.00 15.49           C  
ATOM    656  C   THR A  73      29.734  60.405  18.273  1.00 15.33           C  
ATOM    657  O   THR A  73      28.932  60.628  17.375  1.00 17.26           O  
ATOM    658  CB  THR A  73      29.985  62.858  18.853  1.00 16.69           C  
ATOM    659  OG1 THR A  73      31.301  63.040  18.331  1.00 17.56           O  
ATOM    660  CG2 THR A  73      29.708  63.929  19.917  1.00 17.55           C  
ATOM    661  N   LYS A  74      30.552  59.354  18.248  1.00 15.16           N  
ATOM    662  CA  LYS A  74      30.471  58.315  17.207  1.00 15.04           C  
ATOM    663  C   LYS A  74      29.205  57.482  17.441  1.00 15.46           C  
ATOM    664  O   LYS A  74      28.837  57.233  18.606  1.00 16.07           O  
ATOM    665  CB  LYS A  74      31.709  57.385  17.236  1.00 14.24           C  
ATOM    666  CG  LYS A  74      33.032  58.033  16.870  1.00 15.11           C  
ATOM    667  CD  LYS A  74      32.997  58.716  15.474  1.00 17.74           C  
ATOM    668  CE  LYS A  74      32.945  57.691  14.364  1.00 18.14           C  
ATOM    669  NZ  LYS A  74      32.805  58.347  13.036  1.00 16.84           N  
ATOM    670  N   VAL A  75      28.540  57.059  16.358  1.00 15.03           N  
ATOM    671  CA  VAL A  75      27.347  56.215  16.508  1.00 15.59           C  
ATOM    672  C   VAL A  75      27.702  54.884  17.163  1.00 16.23           C  
ATOM    673  O   VAL A  75      26.997  54.446  18.090  1.00 18.02           O  
ATOM    674  CB  VAL A  75      26.643  55.989  15.135  1.00 14.98           C  
ATOM    675  CG1 VAL A  75      25.520  54.947  15.213  1.00 17.30           C  
ATOM    676  CG2 VAL A  75      26.131  57.347  14.626  1.00 16.14           C  
ATOM    677  N   THR A  76      28.799  54.276  16.686  1.00 15.95           N  
ATOM    678  CA  THR A  76      29.258  52.963  17.159  1.00 14.85           C  
ATOM    679  C   THR A  76      30.518  53.112  18.015  1.00 14.72           C  
ATOM    680  O   THR A  76      31.398  53.931  17.728  1.00 13.85           O  
ATOM    681  CB  THR A  76      29.508  52.000  15.990  1.00 16.12           C  
ATOM    682  OG1 THR A  76      30.433  52.621  15.069  1.00 13.72           O  
ATOM    683  CG2 THR A  76      28.146  51.645  15.243  1.00 16.58           C  
ATOM    684  N   PHE A  77      30.565  52.334  19.095  1.00 14.99           N  
ATOM    685  CA  PHE A  77      31.721  52.317  20.001  1.00 13.68           C  
ATOM    686  C   PHE A  77      32.211  53.718  20.393  1.00 13.84           C  
ATOM    687  O   PHE A  77      33.422  53.986  20.316  1.00 13.68           O  
ATOM    688  CB  PHE A  77      32.865  51.476  19.381  1.00 14.26           C  
ATOM    689  CG  PHE A  77      32.415  50.124  18.939  1.00 14.53           C  
ATOM    690  CD1 PHE A  77      32.259  49.090  19.873  1.00 16.45           C  
ATOM    691  CD2 PHE A  77      32.063  49.890  17.594  1.00 15.16           C  
ATOM    692  CE1 PHE A  77      31.763  47.817  19.461  1.00 19.60           C  
ATOM    693  CE2 PHE A  77      31.560  48.648  17.189  1.00 16.86           C  
ATOM    694  CZ  PHE A  77      31.408  47.614  18.128  1.00 16.09           C  
ATOM    695  N   PRO A  78      31.291  54.613  20.843  1.00 14.85           N  
ATOM    696  CA  PRO A  78      31.765  55.974  21.202  1.00 14.68           C  
ATOM    697  C   PRO A  78      32.719  55.847  22.403  1.00 14.74           C  
ATOM    698  O   PRO A  78      32.473  55.027  23.334  1.00 15.85           O  
ATOM    699  CB  PRO A  78      30.467  56.718  21.570  1.00 14.48           C  
ATOM    700  CG  PRO A  78      29.499  55.590  21.991  1.00 16.24           C  
ATOM    701  CD  PRO A  78      29.836  54.468  21.030  1.00 15.19           C  
ATOM    702  N   GLY A  79      33.804  56.615  22.399  1.00 14.93           N  
ATOM    703  CA  GLY A  79      34.678  56.643  23.572  1.00 14.79           C  
ATOM    704  C   GLY A  79      35.647  55.474  23.622  1.00 14.41           C  
ATOM    705  O   GLY A  79      36.490  55.409  24.532  1.00 14.81           O  
ATOM    706  N   TYR A  80      35.544  54.511  22.696  1.00 13.55           N  
ATOM    707  CA  TYR A  80      36.472  53.338  22.791  1.00 13.10           C  
ATOM    708  C   TYR A  80      37.820  53.609  22.162  1.00 13.59           C  
ATOM    709  O   TYR A  80      37.906  54.232  21.120  1.00 13.11           O  
ATOM    710  CB  TYR A  80      35.909  52.129  22.006  1.00 14.42           C  
ATOM    711  CG  TYR A  80      34.776  51.376  22.688  1.00 14.08           C  
ATOM    712  CD1 TYR A  80      33.645  52.043  23.164  1.00 16.67           C  
ATOM    713  CD2 TYR A  80      34.807  49.986  22.770  1.00 17.08           C  
ATOM    714  CE1 TYR A  80      32.579  51.341  23.742  1.00 19.82           C  
ATOM    715  CE2 TYR A  80      33.752  49.275  23.337  1.00 18.58           C  
ATOM    716  CZ  TYR A  80      32.643  49.956  23.806  1.00 21.66           C  
ATOM    717  OH  TYR A  80      31.594  49.267  24.388  1.00 22.31           O  
ATOM    718  N   PHE A  81      38.861  53.014  22.729  1.00 14.04           N  
ATOM    719  CA  PHE A  81      40.156  52.974  22.087  1.00 14.44           C  
ATOM    720  C   PHE A  81      40.117  51.949  20.959  1.00 14.07           C  
ATOM    721  O   PHE A  81      39.376  50.947  21.005  1.00 14.53           O  
ATOM    722  CB  PHE A  81      41.235  52.673  23.117  1.00 15.72           C  
ATOM    723  CG  PHE A  81      41.426  53.802  24.095  1.00 17.39           C  
ATOM    724  CD1 PHE A  81      42.283  54.871  23.790  1.00 17.05           C  
ATOM    725  CD2 PHE A  81      40.697  53.844  25.265  1.00 18.72           C  
ATOM    726  CE1 PHE A  81      42.454  55.938  24.688  1.00 18.25           C  
ATOM    727  CE2 PHE A  81      40.855  54.903  26.177  1.00 21.72           C  
ATOM    728  CZ  PHE A  81      41.735  55.947  25.888  1.00 18.41           C  
ATOM    729  N   THR A  82      40.903  52.225  19.927  1.00 13.62           N  
ATOM    730  CA  THR A  82      40.782  51.455  18.662  1.00 13.42           C  
ATOM    731  C   THR A  82      42.058  51.592  17.801  1.00 12.94           C  
ATOM    732  O   THR A  82      43.068  52.056  18.307  1.00 13.26           O  
ATOM    733  CB  THR A  82      39.494  51.864  17.899  1.00 14.60           C  
ATOM    734  OG1 THR A  82      39.240  50.948  16.800  1.00 13.94           O  
ATOM    735  CG2 THR A  82      39.572  53.344  17.383  1.00 15.08           C  
ATOM    736  N   ASP A  83      42.016  51.105  16.551  1.00 12.96           N  
ATOM    737  CA  ASP A  83      43.172  51.149  15.669  1.00 13.05           C  
ATOM    738  C   ASP A  83      43.388  52.609  15.220  1.00 12.90           C  
ATOM    739  O   ASP A  83      42.774  53.560  15.787  1.00 13.77           O  
ATOM    740  CB  ASP A  83      42.951  50.225  14.460  1.00 13.86           C  
ATOM    741  CG  ASP A  83      41.637  50.503  13.758  1.00 19.21           C  
ATOM    742  OD1 ASP A  83      41.349  51.693  13.474  1.00 20.27           O  
ATOM    743  OD2 ASP A  83      40.882  49.543  13.493  1.00 22.25           O  
ATOM    744  N   SER A  84      44.261  52.823  14.236  1.00 11.84           N  
ATOM    745  CA  SER A  84      44.670  54.198  13.893  1.00 11.59           C  
ATOM    746  C   SER A  84      43.601  54.955  13.097  1.00 13.03           C  
ATOM    747  O   SER A  84      43.533  56.175  13.131  1.00 14.24           O  
ATOM    748  CB  SER A  84      45.942  54.115  13.050  1.00 10.14           C  
ATOM    749  OG  SER A  84      46.963  53.423  13.764  1.00 12.97           O  
ATOM    750  N   CYS A  85      42.768  54.207  12.382  1.00 15.09           N  
ATOM    751  CA  CYS A  85      41.694  54.771  11.549  1.00 15.71           C  
ATOM    752  C   CYS A  85      40.853  53.638  10.974  1.00 15.75           C  
ATOM    753  O   CYS A  85      41.383  52.753  10.292  1.00 16.20           O  
ATOM    754  CB  CYS A  85      42.292  55.559  10.372  1.00 15.17           C  
ATOM    755  SG  CYS A  85      41.005  56.371   9.325  1.00 18.71           S  
ATOM    756  N   SER A  86      39.554  53.657  11.213  1.00 16.69           N  
ATOM    757  CA  SER A  86      38.692  52.673  10.539  1.00 18.20           C  
ATOM    758  C   SER A  86      37.566  53.402   9.824  1.00 18.26           C  
ATOM    759  O   SER A  86      37.106  54.428  10.278  1.00 17.55           O  
ATOM    760  CB  SER A  86      38.139  51.680  11.569  1.00 19.73           C  
ATOM    761  OG  SER A  86      37.278  52.325  12.524  1.00 23.23           O  
ATOM    762  N   SER A  87      37.129  52.886   8.688  1.00 15.89           N  
ATOM    763  CA  SER A  87      36.042  53.496   7.962  1.00 16.86           C  
ATOM    764  C   SER A  87      35.771  52.587   6.797  1.00 16.86           C  
ATOM    765  O   SER A  87      36.024  51.353   6.892  1.00 16.14           O  
ATOM    766  CB  SER A  87      36.376  54.946   7.534  1.00 16.82           C  
ATOM    767  OG  SER A  87      35.219  55.584   6.974  1.00 19.08           O  
ATOM    768  N   HIS A  88      35.211  53.165   5.743  1.00 17.28           N  
ATOM    769  CA  HIS A  88      34.641  52.405   4.666  1.00 17.77           C  
ATOM    770  C   HIS A  88      34.908  53.135   3.342  1.00 17.47           C  
ATOM    771  O   HIS A  88      34.827  54.369   3.268  1.00 17.53           O  
ATOM    772  CB  HIS A  88      33.083  52.236   4.853  1.00 18.38           C  
ATOM    773  CG  HIS A  88      32.637  51.875   6.255  1.00 21.57           C  
ATOM    774  ND1 HIS A  88      32.088  52.800   7.123  1.00 23.05           N  
ATOM    775  CD2 HIS A  88      32.611  50.682   6.919  1.00 22.54           C  
ATOM    776  CE1 HIS A  88      31.784  52.199   8.273  1.00 26.62           C  
ATOM    777  NE2 HIS A  88      32.093  50.909   8.188  1.00 23.83           N  
ATOM    778  N   PRO A  89      35.174  52.371   2.280  1.00 16.90           N  
ATOM    779  CA  PRO A  89      35.155  53.028   0.967  1.00 16.80           C  
ATOM    780  C   PRO A  89      33.689  53.323   0.583  1.00 17.01           C  
ATOM    781  O   PRO A  89      32.742  52.565   0.994  1.00 17.51           O  
ATOM    782  CB  PRO A  89      35.775  51.982   0.049  1.00 17.32           C  
ATOM    783  CG  PRO A  89      35.388  50.630   0.704  1.00 17.56           C  
ATOM    784  CD  PRO A  89      35.471  50.929   2.206  1.00 16.78           C  
ATOM    785  N   LEU A  90      33.500  54.435  -0.135  1.00 16.03           N  
ATOM    786  CA  LEU A  90      32.166  54.830  -0.575  1.00 15.36           C  
ATOM    787  C   LEU A  90      31.825  54.247  -1.944  1.00 15.61           C  
ATOM    788  O   LEU A  90      32.696  53.866  -2.716  1.00 15.08           O  
ATOM    789  CB  LEU A  90      32.040  56.369  -0.609  1.00 16.16           C  
ATOM    790  CG  LEU A  90      32.262  57.104   0.731  1.00 17.86           C  
ATOM    791  CD1 LEU A  90      32.528  58.576   0.494  1.00 20.47           C  
ATOM    792  CD2 LEU A  90      31.054  56.906   1.626  1.00 21.59           C  
ATOM    793  N   TYR A  91      30.530  54.222  -2.256  1.00 15.60           N  
ATOM    794  CA  TYR A  91      30.078  53.703  -3.534  1.00 16.82           C  
ATOM    795  C   TYR A  91      30.187  54.826  -4.568  1.00 17.31           C  
ATOM    796  O   TYR A  91      29.196  55.524  -4.876  1.00 18.46           O  
ATOM    797  CB  TYR A  91      28.646  53.160  -3.408  1.00 18.14           C  
ATOM    798  CG  TYR A  91      28.240  52.258  -4.554  1.00 17.88           C  
ATOM    799  CD1 TYR A  91      28.369  50.883  -4.453  1.00 19.31           C  
ATOM    800  CD2 TYR A  91      27.731  52.791  -5.739  1.00 20.93           C  
ATOM    801  CE1 TYR A  91      27.972  50.019  -5.513  1.00 19.91           C  
ATOM    802  CE2 TYR A  91      27.350  51.963  -6.787  1.00 24.91           C  
ATOM    803  CZ  TYR A  91      27.465  50.590  -6.666  1.00 23.70           C  
ATOM    804  OH  TYR A  91      27.112  49.784  -7.719  1.00 25.01           O  
ATOM    805  N   ASN A  92      31.404  55.019  -5.072  1.00 16.15           N  
ATOM    806  CA  ASN A  92      31.657  56.020  -6.133  1.00 16.80           C  
ATOM    807  C   ASN A  92      32.801  55.478  -6.972  1.00 17.34           C  
ATOM    808  O   ASN A  92      33.467  54.526  -6.551  1.00 17.81           O  
ATOM    809  CB  ASN A  92      31.892  57.436  -5.550  1.00 16.49           C  
ATOM    810  CG  ASN A  92      33.199  57.578  -4.776  1.00 17.30           C  
ATOM    811  OD1 ASN A  92      34.281  57.127  -5.226  1.00 16.41           O  
ATOM    812  ND2 ASN A  92      33.121  58.240  -3.602  1.00 17.21           N  
ATOM    813  N   PRO A  93      33.022  56.035  -8.176  1.00 18.45           N  
ATOM    814  CA  PRO A  93      34.030  55.410  -9.055  1.00 19.02           C  
ATOM    815  C   PRO A  93      35.420  55.270  -8.436  1.00 18.98           C  
ATOM    816  O   PRO A  93      36.098  54.208  -8.614  1.00 18.94           O  
ATOM    817  CB  PRO A  93      34.037  56.344 -10.298  1.00 18.76           C  
ATOM    818  CG  PRO A  93      32.589  56.890 -10.328  1.00 21.12           C  
ATOM    819  CD  PRO A  93      32.313  57.153  -8.837  1.00 19.57           C  
ATOM    820  N   ALA A  94      35.855  56.303  -7.718  1.00 18.02           N  
ATOM    821  CA  ALA A  94      37.216  56.336  -7.210  1.00 18.88           C  
ATOM    822  C   ALA A  94      37.425  55.258  -6.153  1.00 18.13           C  
ATOM    823  O   ALA A  94      38.498  54.605  -6.112  1.00 18.20           O  
ATOM    824  CB  ALA A  94      37.550  57.754  -6.626  1.00 19.58           C  
ATOM    825  N   GLU A  95      36.427  55.070  -5.296  1.00 16.21           N  
ATOM    826  CA  GLU A  95      36.577  54.151  -4.156  1.00 15.77           C  
ATOM    827  C   GLU A  95      36.088  52.749  -4.390  1.00 15.67           C  
ATOM    828  O   GLU A  95      36.345  51.874  -3.574  1.00 15.36           O  
ATOM    829  CB  GLU A  95      36.003  54.769  -2.862  1.00 15.88           C  
ATOM    830  CG  GLU A  95      36.786  56.104  -2.619  1.00 15.01           C  
ATOM    831  CD  GLU A  95      36.549  56.735  -1.246  1.00 18.94           C  
ATOM    832  OE1 GLU A  95      35.775  56.206  -0.444  1.00 18.14           O  
ATOM    833  OE2 GLU A  95      37.141  57.791  -0.972  1.00 17.70           O  
ATOM    834  N   LEU A  96      35.404  52.545  -5.525  1.00 15.52           N  
ATOM    835  CA  LEU A  96      35.004  51.198  -5.964  1.00 17.39           C  
ATOM    836  C   LEU A  96      36.139  50.464  -6.683  1.00 18.32           C  
ATOM    837  O   LEU A  96      36.083  49.225  -6.842  1.00 19.48           O  
ATOM    838  CB  LEU A  96      33.796  51.272  -6.927  1.00 18.01           C  
ATOM    839  CG  LEU A  96      32.412  51.330  -6.241  1.00 17.73           C  
ATOM    840  CD1 LEU A  96      31.372  51.915  -7.198  1.00 20.33           C  
ATOM    841  CD2 LEU A  96      31.939  49.949  -5.770  1.00 20.13           C  
ATOM    842  N   GLU A  97      37.155  51.201  -7.119  1.00 18.64           N  
ATOM    843  CA  GLU A  97      38.214  50.594  -7.965  1.00 21.85           C  
ATOM    844  C   GLU A  97      38.927  49.487  -7.185  1.00 21.35           C  
ATOM    845  O   GLU A  97      39.439  49.743  -6.098  1.00 20.12           O  
ATOM    846  CB  GLU A  97      39.201  51.664  -8.442  1.00 22.41           C  
ATOM    847  CG  GLU A  97      40.054  51.177  -9.593  1.00 27.95           C  
ATOM    848  CD  GLU A  97      40.845  52.272 -10.312  1.00 29.42           C  
ATOM    849  OE1 GLU A  97      41.629  51.877 -11.226  1.00 34.31           O  
ATOM    850  OE2 GLU A  97      40.682  53.482 -10.003  1.00 29.21           O  
ATOM    851  N   GLU A  98      38.976  48.267  -7.730  1.00 21.70           N  
ATOM    852  CA  GLU A  98      39.489  47.140  -6.941  1.00 23.08           C  
ATOM    853  C   GLU A  98      40.962  46.774  -7.199  1.00 23.39           C  
ATOM    854  O   GLU A  98      41.576  46.128  -6.372  1.00 23.03           O  
ATOM    855  CB  GLU A  98      38.603  45.907  -7.109  1.00 25.36           C  
ATOM    856  CG  GLU A  98      37.284  46.054  -6.334  1.00 25.72           C  
ATOM    857  CD  GLU A  98      36.419  44.833  -6.358  1.00 30.41           C  
ATOM    858  OE1 GLU A  98      36.898  43.714  -6.722  1.00 30.17           O  
ATOM    859  OE2 GLU A  98      35.233  44.983  -6.018  1.00 27.33           O  
ATOM    860  N   LYS A  99      41.505  47.149  -8.348  0.50 23.94           N  
ATOM    862  CA  LYS A  99      42.857  46.688  -8.626  0.50 24.62           C  
ATOM    864  C   LYS A  99      43.854  47.266  -7.617  0.50 23.40           C  
ATOM    866  O   LYS A  99      43.854  48.471  -7.311  0.50 20.89           O  
ATOM    868  CB  LYS A  99      43.276  46.902 -10.067  0.50 26.82           C  
ATOM    870  CG  LYS A  99      43.225  48.311 -10.538  0.50 29.63           C  
ATOM    872  CD  LYS A  99      44.162  48.431 -11.697  0.50 36.57           C  
ATOM    874  CE  LYS A  99      44.334  49.863 -12.098  1.00 37.53           C  
ATOM    875  NZ  LYS A  99      44.532  50.894 -10.981  1.00 37.75           N  
ATOM    876  N   ASP A 100      44.642  46.348  -7.074  1.00 20.40           N  
ATOM    877  CA  ASP A 100      45.628  46.585  -5.976  1.00 21.55           C  
ATOM    878  C   ASP A 100      44.985  47.290  -4.769  1.00 20.15           C  
ATOM    879  O   ASP A 100      45.664  48.029  -4.019  1.00 20.38           O  
ATOM    880  CB  ASP A 100      46.862  47.359  -6.472  1.00 23.09           C  
ATOM    881  CG  ASP A 100      47.581  46.639  -7.573  1.00 27.93           C  
ATOM    882  OD1 ASP A 100      47.650  45.394  -7.535  1.00 31.54           O  
ATOM    883  OD2 ASP A 100      48.075  47.317  -8.489  1.00 30.35           O  
ATOM    884  N   ALA A 101      43.678  47.066  -4.601  1.00 19.19           N  
ATOM    885  CA  ALA A 101      42.902  47.649  -3.492  1.00 18.72           C  
ATOM    886  C   ALA A 101      42.996  49.157  -3.481  1.00 17.87           C  
ATOM    887  O   ALA A 101      42.950  49.767  -2.407  1.00 17.76           O  
ATOM    888  CB  ALA A 101      43.369  47.086  -2.105  1.00 19.95           C  
ATOM    889  N   ILE A 102      43.105  49.767  -4.656  1.00 17.31           N  
ATOM    890  CA  ILE A 102      43.354  51.229  -4.690  1.00 17.67           C  
ATOM    891  C   ILE A 102      42.138  52.003  -4.170  1.00 17.33           C  
ATOM    892  O   ILE A 102      42.296  53.053  -3.533  1.00 16.48           O  
ATOM    893  CB  ILE A 102      43.790  51.716  -6.078  1.00 18.66           C  
ATOM    894  CG1 ILE A 102      44.208  53.187  -6.046  1.00 21.14           C  
ATOM    895  CG2 ILE A 102      42.664  51.471  -7.104  1.00 19.24           C  
ATOM    896  CD1 ILE A 102      45.473  53.476  -5.179  1.00 23.22           C  
ATOM    897  N   GLY A 103      40.934  51.481  -4.415  1.00 15.69           N  
ATOM    898  CA  GLY A 103      39.709  52.186  -3.960  1.00 15.39           C  
ATOM    899  C   GLY A 103      39.700  52.291  -2.430  1.00 15.78           C  
ATOM    900  O   GLY A 103      39.410  53.361  -1.845  1.00 15.82           O  
ATOM    901  N   VAL A 104      40.002  51.174  -1.778  1.00 13.86           N  
ATOM    902  CA  VAL A 104      40.090  51.136  -0.319  1.00 14.98           C  
ATOM    903  C   VAL A 104      41.229  52.031   0.187  1.00 15.80           C  
ATOM    904  O   VAL A 104      41.085  52.749   1.205  1.00 15.22           O  
ATOM    905  CB  VAL A 104      40.241  49.671   0.145  1.00 16.06           C  
ATOM    906  CG1 VAL A 104      40.856  49.588   1.553  1.00 17.02           C  
ATOM    907  CG2 VAL A 104      38.872  48.988   0.143  1.00 16.96           C  
ATOM    908  N   ARG A 105      42.363  51.999  -0.505  1.00 15.32           N  
ATOM    909  CA  ARG A 105      43.520  52.815  -0.065  1.00 16.16           C  
ATOM    910  C   ARG A 105      43.225  54.314  -0.252  1.00 16.20           C  
ATOM    911  O   ARG A 105      43.627  55.125   0.583  1.00 16.97           O  
ATOM    912  CB  ARG A 105      44.793  52.342  -0.786  1.00 16.12           C  
ATOM    913  CG  ARG A 105      45.172  50.891  -0.285  1.00 16.21           C  
ATOM    914  CD  ARG A 105      46.032  50.141  -1.325  1.00 20.13           C  
ATOM    915  NE  ARG A 105      47.241  50.863  -1.620  1.00 22.37           N  
ATOM    916  CZ  ARG A 105      47.742  51.009  -2.855  1.00 25.62           C  
ATOM    917  NH1 ARG A 105      47.152  50.453  -3.944  1.00 25.87           N  
ATOM    918  NH2 ARG A 105      48.872  51.693  -3.001  1.00 25.45           N  
ATOM    919  N   ARG A 106      42.453  54.676  -1.282  1.00 16.14           N  
ATOM    920  CA  ARG A 106      42.027  56.074  -1.440  1.00 17.41           C  
ATOM    921  C   ARG A 106      41.093  56.495  -0.329  1.00 16.01           C  
ATOM    922  O   ARG A 106      41.192  57.622   0.165  1.00 17.08           O  
ATOM    923  CB  ARG A 106      41.269  56.266  -2.752  1.00 16.37           C  
ATOM    924  CG  ARG A 106      42.206  56.251  -3.948  1.00 20.43           C  
ATOM    925  CD  ARG A 106      41.361  56.283  -5.193  1.00 21.75           C  
ATOM    926  NE  ARG A 106      42.189  56.350  -6.381  1.00 24.33           N  
ATOM    927  CZ  ARG A 106      41.940  55.674  -7.501  1.00 27.58           C  
ATOM    928  NH1 ARG A 106      42.782  55.823  -8.547  1.00 26.39           N  
ATOM    929  NH2 ARG A 106      40.871  54.846  -7.569  1.00 20.09           N  
ATOM    930  N   ALA A 107      40.170  55.608   0.054  1.00 16.53           N  
ATOM    931  CA  ALA A 107      39.228  55.883   1.161  1.00 15.70           C  
ATOM    932  C   ALA A 107      39.996  56.057   2.467  1.00 15.70           C  
ATOM    933  O   ALA A 107      39.687  56.948   3.291  1.00 14.89           O  
ATOM    934  CB  ALA A 107      38.266  54.735   1.298  1.00 16.02           C  
ATOM    935  N   ALA A 108      41.008  55.215   2.657  1.00 13.53           N  
ATOM    936  CA  ALA A 108      41.852  55.314   3.861  1.00 13.96           C  
ATOM    937  C   ALA A 108      42.587  56.673   3.901  1.00 14.53           C  
ATOM    938  O   ALA A 108      42.598  57.318   4.952  1.00 14.53           O  
ATOM    939  CB  ALA A 108      42.861  54.147   3.911  1.00 14.87           C  
ATOM    940  N   GLN A 109      43.191  57.117   2.798  0.50 14.61           N  
ATOM    942  CA  GLN A 109      43.812  58.454   2.799  0.50 14.49           C  
ATOM    944  C   GLN A 109      42.754  59.485   3.191  0.50 14.49           C  
ATOM    946  O   GLN A 109      42.964  60.294   4.094  0.50 14.61           O  
ATOM    948  CB  GLN A 109      44.395  58.827   1.438  0.50 16.05           C  
ATOM    950  CG  GLN A 109      45.124  60.214   1.425  0.50 17.59           C  
ATOM    952  CD  GLN A 109      44.192  61.422   1.244  0.50 20.59           C  
ATOM    954  OE1 GLN A 109      43.262  61.390   0.426  0.50 19.78           O  
ATOM    956  NE2 GLN A 109      44.460  62.506   1.991  0.50 21.21           N  
ATOM    958  N   ARG A 110      41.621  59.449   2.500  1.00 14.78           N  
ATOM    959  CA  ARG A 110      40.530  60.413   2.731  1.00 15.22           C  
ATOM    960  C   ARG A 110      40.181  60.510   4.231  1.00 15.31           C  
ATOM    961  O   ARG A 110      40.039  61.612   4.803  1.00 15.24           O  
ATOM    962  CB  ARG A 110      39.297  59.985   1.914  1.00 15.50           C  
ATOM    963  CG  ARG A 110      38.086  60.919   2.156  1.00 18.44           C  
ATOM    964  CD  ARG A 110      36.904  60.592   1.217  1.00 18.89           C  
ATOM    965  NE  ARG A 110      36.508  59.183   1.294  1.00 17.24           N  
ATOM    966  CZ  ARG A 110      35.738  58.607   2.240  1.00 20.21           C  
ATOM    967  NH1 ARG A 110      35.254  59.319   3.269  1.00 21.82           N  
ATOM    968  NH2 ARG A 110      35.480  57.282   2.148  1.00 20.75           N  
ATOM    969  N   ARG A 111      40.060  59.361   4.870  1.00 13.82           N  
ATOM    970  CA  ARG A 111      39.666  59.350   6.276  1.00 14.79           C  
ATOM    971  C   ARG A 111      40.813  59.655   7.229  1.00 14.42           C  
ATOM    972  O   ARG A 111      40.579  60.188   8.328  1.00 15.74           O  
ATOM    973  CB  ARG A 111      39.012  58.010   6.640  1.00 13.93           C  
ATOM    974  CG  ARG A 111      37.668  57.735   5.895  1.00 14.88           C  
ATOM    975  CD  ARG A 111      36.645  58.858   6.201  1.00 17.00           C  
ATOM    976  NE  ARG A 111      36.223  58.815   7.610  1.00 15.83           N  
ATOM    977  CZ  ARG A 111      35.612  59.804   8.266  1.00 17.85           C  
ATOM    978  NH1 ARG A 111      35.344  60.966   7.658  1.00 17.52           N  
ATOM    979  NH2 ARG A 111      35.238  59.622   9.541  1.00 18.65           N  
ATOM    980  N   LEU A 112      42.052  59.306   6.867  1.00 14.48           N  
ATOM    981  CA  LEU A 112      43.175  59.761   7.695  1.00 14.45           C  
ATOM    982  C   LEU A 112      43.217  61.297   7.688  1.00 15.93           C  
ATOM    983  O   LEU A 112      43.528  61.919   8.715  1.00 15.55           O  
ATOM    984  CB  LEU A 112      44.542  59.192   7.210  1.00 14.00           C  
ATOM    985  CG  LEU A 112      44.657  57.670   7.396  1.00 15.59           C  
ATOM    986  CD1 LEU A 112      45.800  57.148   6.532  1.00 15.13           C  
ATOM    987  CD2 LEU A 112      44.968  57.385   8.854  1.00 14.61           C  
ATOM    988  N   GLN A 113      42.935  61.895   6.528  1.00 15.42           N  
ATOM    989  CA  GLN A 113      42.872  63.347   6.468  1.00 17.78           C  
ATOM    990  C   GLN A 113      41.673  63.888   7.286  1.00 16.63           C  
ATOM    991  O   GLN A 113      41.794  64.857   8.059  1.00 17.77           O  
ATOM    992  CB  GLN A 113      42.798  63.832   5.011  1.00 18.76           C  
ATOM    993  CG  GLN A 113      43.009  65.337   4.925  1.00 23.57           C  
ATOM    994  CD  GLN A 113      43.016  65.878   3.497  1.00 27.15           C  
ATOM    995  OE1 GLN A 113      43.349  65.158   2.542  1.00 36.53           O  
ATOM    996  NE2 GLN A 113      42.658  67.168   3.342  1.00 35.85           N  
ATOM    997  N   ALA A 114      40.506  63.274   7.110  1.00 16.56           N  
ATOM    998  CA  ALA A 114      39.282  63.823   7.728  1.00 17.41           C  
ATOM    999  C   ALA A 114      39.293  63.660   9.261  1.00 17.40           C  
ATOM   1000  O   ALA A 114      38.896  64.562   9.995  1.00 17.57           O  
ATOM   1001  CB  ALA A 114      38.020  63.150   7.145  1.00 17.65           C  
ATOM   1002  N   GLU A 115      39.687  62.485   9.735  1.00 16.84           N  
ATOM   1003  CA  GLU A 115      39.629  62.193  11.167  1.00 16.86           C  
ATOM   1004  C   GLU A 115      40.832  62.769  11.915  1.00 16.63           C  
ATOM   1005  O   GLU A 115      40.665  63.370  12.960  1.00 17.45           O  
ATOM   1006  CB  GLU A 115      39.658  60.699  11.382  1.00 16.37           C  
ATOM   1007  CG  GLU A 115      38.373  60.002  10.921  1.00 18.45           C  
ATOM   1008  CD  GLU A 115      38.420  58.497  11.158  1.00 20.25           C  
ATOM   1009  OE1 GLU A 115      39.281  58.026  11.940  1.00 17.56           O  
ATOM   1010  OE2 GLU A 115      37.605  57.794  10.532  1.00 19.91           O  
ATOM   1011  N   LEU A 116      42.040  62.533  11.396  1.00 14.92           N  
ATOM   1012  CA  LEU A 116      43.274  62.854  12.111  1.00 15.12           C  
ATOM   1013  C   LEU A 116      43.953  64.115  11.582  1.00 14.88           C  
ATOM   1014  O   LEU A 116      44.892  64.606  12.202  1.00 15.78           O  
ATOM   1015  CB  LEU A 116      44.237  61.661  12.013  1.00 13.57           C  
ATOM   1016  CG  LEU A 116      43.703  60.380  12.690  1.00 15.48           C  
ATOM   1017  CD1 LEU A 116      44.684  59.226  12.436  1.00 17.23           C  
ATOM   1018  CD2 LEU A 116      43.490  60.599  14.213  1.00 17.52           C  
ATOM   1019  N   GLY A 117      43.461  64.660  10.471  1.00 15.42           N  
ATOM   1020  CA  GLY A 117      44.059  65.872   9.924  1.00 16.80           C  
ATOM   1021  C   GLY A 117      45.437  65.649   9.305  1.00 16.90           C  
ATOM   1022  O   GLY A 117      46.240  66.595   9.211  1.00 18.39           O  
ATOM   1023  N   ILE A 118      45.718  64.405   8.905  1.00 16.53           N  
ATOM   1024  CA  ILE A 118      46.983  64.101   8.230  1.00 17.56           C  
ATOM   1025  C   ILE A 118      46.859  64.490   6.756  1.00 17.73           C  
ATOM   1026  O   ILE A 118      46.004  63.929   6.036  1.00 19.04           O  
ATOM   1027  CB  ILE A 118      47.374  62.604   8.334  1.00 16.18           C  
ATOM   1028  CG1 ILE A 118      47.534  62.192   9.816  1.00 16.22           C  
ATOM   1029  CG2 ILE A 118      48.668  62.369   7.504  1.00 17.13           C  
ATOM   1030  CD1 ILE A 118      47.390  60.691  10.071  1.00 16.12           C  
ATOM   1031  N   PRO A 119      47.662  65.466   6.311  1.00 18.58           N  
ATOM   1032  CA  PRO A 119      47.496  65.929   4.927  1.00 19.00           C  
ATOM   1033  C   PRO A 119      47.889  64.841   3.916  1.00 20.28           C  
ATOM   1034  O   PRO A 119      48.737  63.976   4.214  1.00 17.79           O  
ATOM   1035  CB  PRO A 119      48.457  67.126   4.807  1.00 20.37           C  
ATOM   1036  CG  PRO A 119      49.315  67.108   6.017  1.00 20.22           C  
ATOM   1037  CD  PRO A 119      48.731  66.195   7.047  1.00 17.57           C  
ATOM   1038  N   GLY A 120      47.296  64.931   2.716  1.00 21.59           N  
ATOM   1039  CA  GLY A 120      47.653  64.034   1.600  1.00 24.13           C  
ATOM   1040  C   GLY A 120      49.132  64.098   1.224  1.00 24.91           C  
ATOM   1041  O   GLY A 120      49.700  63.097   0.756  1.00 26.20           O  
ATOM   1042  N   GLU A 121      49.768  65.243   1.463  1.00 24.61           N  
ATOM   1043  CA  GLU A 121      51.200  65.386   1.157  1.00 25.59           C  
ATOM   1044  C   GLU A 121      52.051  64.456   2.012  1.00 24.54           C  
ATOM   1045  O   GLU A 121      53.203  64.143   1.667  1.00 24.81           O  
ATOM   1046  CB  GLU A 121      51.667  66.817   1.391  1.00 26.61           C  
ATOM   1047  CG  GLU A 121      51.125  67.822   0.389  1.00 32.53           C  
ATOM   1048  CD  GLU A 121      49.688  68.236   0.662  1.00 37.47           C  
ATOM   1049  OE1 GLU A 121      49.097  67.786   1.682  1.00 34.83           O  
ATOM   1050  OE2 GLU A 121      49.145  69.015  -0.165  1.00 40.66           O  
ATOM   1051  N   GLN A 122      51.513  64.056   3.159  1.00 20.60           N  
ATOM   1052  CA  GLN A 122      52.261  63.216   4.054  1.00 20.60           C  
ATOM   1053  C   GLN A 122      51.969  61.731   3.854  1.00 21.47           C  
ATOM   1054  O   GLN A 122      52.864  60.916   3.974  1.00 21.77           O  
ATOM   1055  CB  GLN A 122      51.972  63.606   5.508  1.00 19.40           C  
ATOM   1056  CG  GLN A 122      52.459  65.012   5.834  1.00 17.75           C  
ATOM   1057  CD  GLN A 122      52.206  65.359   7.301  1.00 17.27           C  
ATOM   1058  OE1 GLN A 122      51.902  64.480   8.088  1.00 16.33           O  
ATOM   1059  NE2 GLN A 122      52.271  66.632   7.642  1.00 16.18           N  
ATOM   1060  N   ILE A 123      50.710  61.379   3.607  1.00 21.89           N  
ATOM   1061  CA  ILE A 123      50.334  59.994   3.320  1.00 22.79           C  
ATOM   1062  C   ILE A 123      49.432  60.013   2.095  1.00 24.51           C  
ATOM   1063  O   ILE A 123      48.356  60.608   2.123  1.00 25.45           O  
ATOM   1064  CB  ILE A 123      49.520  59.322   4.457  1.00 21.99           C  
ATOM   1065  CG1 ILE A 123      50.338  59.229   5.734  1.00 21.86           C  
ATOM   1066  CG2 ILE A 123      49.018  57.913   3.979  1.00 22.05           C  
ATOM   1067  CD1 ILE A 123      49.489  58.784   7.009  1.00 22.55           C  
ATOM   1068  N   SER A 124      49.893  59.397   1.029  1.00 25.20           N  
ATOM   1069  CA  SER A 124      49.067  59.187  -0.170  1.00 27.38           C  
ATOM   1070  C   SER A 124      48.721  57.696  -0.242  1.00 27.62           C  
ATOM   1071  O   SER A 124      49.293  56.901   0.507  1.00 26.06           O  
ATOM   1072  CB  SER A 124      49.861  59.570  -1.392  1.00 29.48           C  
ATOM   1073  OG  SER A 124      50.903  58.630  -1.585  1.00 32.24           O  
ATOM   1074  N   PRO A 125      47.847  57.288  -1.186  1.00 28.67           N  
ATOM   1075  CA  PRO A 125      47.564  55.838  -1.255  1.00 28.37           C  
ATOM   1076  C   PRO A 125      48.821  54.972  -1.474  1.00 28.78           C  
ATOM   1077  O   PRO A 125      48.842  53.817  -1.041  1.00 27.62           O  
ATOM   1078  CB  PRO A 125      46.596  55.731  -2.441  1.00 30.60           C  
ATOM   1079  CG  PRO A 125      45.926  57.055  -2.472  1.00 30.89           C  
ATOM   1080  CD  PRO A 125      47.066  58.021  -2.196  1.00 30.04           C  
ATOM   1081  N   GLU A 126      49.867  55.515  -2.108  1.00 31.09           N  
ATOM   1082  CA  GLU A 126      51.069  54.720  -2.333  1.00 32.23           C  
ATOM   1083  C   GLU A 126      51.763  54.304  -1.037  1.00 29.39           C  
ATOM   1084  O   GLU A 126      52.429  53.265  -0.983  1.00 30.30           O  
ATOM   1085  CB  GLU A 126      52.036  55.399  -3.322  1.00 36.77           C  
ATOM   1086  CG  GLU A 126      52.568  54.409  -4.368  1.00 44.70           C  
ATOM   1087  CD  GLU A 126      51.443  53.620  -5.090  1.00 52.23           C  
ATOM   1088  OE1 GLU A 126      50.521  54.278  -5.639  1.00 58.04           O  
ATOM   1089  OE2 GLU A 126      51.475  52.356  -5.115  1.00 51.81           O  
ATOM   1090  N   ASP A 127      51.552  55.095   0.008  1.00 25.56           N  
ATOM   1091  CA  ASP A 127      52.126  54.848   1.333  1.00 23.88           C  
ATOM   1092  C   ASP A 127      51.293  53.872   2.158  1.00 20.33           C  
ATOM   1093  O   ASP A 127      51.701  53.506   3.259  1.00 19.92           O  
ATOM   1094  CB  ASP A 127      52.203  56.162   2.135  1.00 22.58           C  
ATOM   1095  CG  ASP A 127      53.115  57.183   1.516  1.00 28.23           C  
ATOM   1096  OD1 ASP A 127      54.240  56.793   1.144  1.00 32.85           O  
ATOM   1097  OD2 ASP A 127      52.700  58.367   1.380  1.00 28.01           O  
ATOM   1098  N   ILE A 128      50.102  53.515   1.680  1.00 18.50           N  
ATOM   1099  CA  ILE A 128      49.180  52.729   2.515  1.00 16.12           C  
ATOM   1100  C   ILE A 128      49.275  51.319   1.980  1.00 16.55           C  
ATOM   1101  O   ILE A 128      48.944  51.059   0.786  1.00 17.63           O  
ATOM   1102  CB  ILE A 128      47.731  53.272   2.425  1.00 16.20           C  
ATOM   1103  CG1 ILE A 128      47.691  54.714   2.951  1.00 16.12           C  
ATOM   1104  CG2 ILE A 128      46.766  52.393   3.275  1.00 14.45           C  
ATOM   1105  CD1 ILE A 128      46.342  55.413   2.817  1.00 17.79           C  
ATOM   1106  N   VAL A 129      49.786  50.414   2.797  1.00 13.92           N  
ATOM   1107  CA  VAL A 129      50.109  49.069   2.278  1.00 14.16           C  
ATOM   1108  C   VAL A 129      48.967  48.100   2.566  1.00 13.57           C  
ATOM   1109  O   VAL A 129      48.590  47.939   3.733  1.00 13.22           O  
ATOM   1110  CB  VAL A 129      51.394  48.501   2.951  1.00 14.04           C  
ATOM   1111  CG1 VAL A 129      51.763  47.135   2.303  1.00 15.87           C  
ATOM   1112  CG2 VAL A 129      52.547  49.477   2.800  1.00 16.35           C  
ATOM   1113  N   PHE A 130      48.420  47.476   1.527  1.00 14.12           N  
ATOM   1114  CA  PHE A 130      47.430  46.425   1.740  1.00 13.94           C  
ATOM   1115  C   PHE A 130      48.110  45.196   2.393  1.00 14.89           C  
ATOM   1116  O   PHE A 130      49.096  44.651   1.817  1.00 15.29           O  
ATOM   1117  CB  PHE A 130      46.776  45.969   0.405  1.00 15.18           C  
ATOM   1118  CG  PHE A 130      45.928  44.751   0.571  1.00 14.50           C  
ATOM   1119  CD1 PHE A 130      44.662  44.860   1.107  1.00 14.08           C  
ATOM   1120  CD2 PHE A 130      46.465  43.460   0.352  1.00 15.28           C  
ATOM   1121  CE1 PHE A 130      43.879  43.712   1.347  1.00 16.11           C  
ATOM   1122  CE2 PHE A 130      45.714  42.323   0.566  1.00 18.22           C  
ATOM   1123  CZ  PHE A 130      44.410  42.434   1.050  1.00 18.73           C  
ATOM   1124  N   MET A 131      47.571  44.721   3.525  1.00 14.03           N  
ATOM   1125  CA  MET A 131      48.143  43.537   4.212  1.00 13.62           C  
ATOM   1126  C   MET A 131      47.295  42.270   4.088  1.00 14.19           C  
ATOM   1127  O   MET A 131      47.812  41.201   3.697  1.00 15.24           O  
ATOM   1128  CB  MET A 131      48.400  43.799   5.718  1.00 13.38           C  
ATOM   1129  CG  MET A 131      49.284  45.036   5.971  1.00 14.61           C  
ATOM   1130  SD  MET A 131      50.959  44.805   5.287  1.00 16.01           S  
ATOM   1131  CE  MET A 131      51.500  43.288   6.076  1.00 18.12           C  
ATOM   1132  N   THR A 132      46.033  42.358   4.480  1.00 13.61           N  
ATOM   1133  CA  THR A 132      45.165  41.179   4.452  1.00 13.78           C  
ATOM   1134  C   THR A 132      43.729  41.638   4.654  1.00 13.23           C  
ATOM   1135  O   THR A 132      43.456  42.844   4.712  1.00 13.77           O  
ATOM   1136  CB  THR A 132      45.590  40.134   5.520  1.00 14.73           C  
ATOM   1137  OG1 THR A 132      44.880  38.886   5.349  1.00 15.39           O  
ATOM   1138  CG2 THR A 132      45.420  40.726   6.994  1.00 16.48           C  
ATOM   1139  N   ILE A 133      42.810  40.682   4.726  1.00 13.77           N  
ATOM   1140  CA  ILE A 133      41.403  40.994   4.926  1.00 13.76           C  
ATOM   1141  C   ILE A 133      40.885  40.114   6.066  1.00 15.05           C  
ATOM   1142  O   ILE A 133      41.197  38.917   6.126  1.00 16.29           O  
ATOM   1143  CB  ILE A 133      40.595  40.659   3.651  1.00 15.03           C  
ATOM   1144  CG1 ILE A 133      41.043  41.536   2.472  1.00 13.97           C  
ATOM   1145  CG2 ILE A 133      39.068  40.832   3.902  1.00 17.06           C  
ATOM   1146  CD1 ILE A 133      40.462  41.019   1.088  1.00 18.34           C  
ATOM   1147  N   TYR A 134      40.034  40.689   6.916  1.00 15.39           N  
ATOM   1148  CA  TYR A 134      39.305  39.919   7.940  1.00 14.84           C  
ATOM   1149  C   TYR A 134      37.826  40.210   7.919  1.00 14.78           C  
ATOM   1150  O   TYR A 134      37.424  41.349   7.731  1.00 14.32           O  
ATOM   1151  CB  TYR A 134      39.889  40.135   9.356  1.00 15.68           C  
ATOM   1152  CG  TYR A 134      39.829  41.539   9.930  1.00 15.51           C  
ATOM   1153  CD1 TYR A 134      38.794  41.914  10.774  1.00 16.91           C  
ATOM   1154  CD2 TYR A 134      40.837  42.482   9.655  1.00 17.29           C  
ATOM   1155  CE1 TYR A 134      38.738  43.211  11.359  1.00 17.42           C  
ATOM   1156  CE2 TYR A 134      40.786  43.780  10.217  1.00 16.05           C  
ATOM   1157  CZ  TYR A 134      39.743  44.133  11.051  1.00 16.73           C  
ATOM   1158  OH  TYR A 134      39.675  45.388  11.612  1.00 19.46           O  
ATOM   1159  N   HIS A 135      37.030  39.160   8.104  1.00 14.40           N  
ATOM   1160  CA  HIS A 135      35.578  39.270   8.190  1.00 14.47           C  
ATOM   1161  C   HIS A 135      35.189  39.194   9.677  1.00 15.08           C  
ATOM   1162  O   HIS A 135      35.527  38.219  10.366  1.00 15.80           O  
ATOM   1163  CB  HIS A 135      35.003  38.109   7.376  1.00 15.11           C  
ATOM   1164  CG  HIS A 135      33.523  38.013   7.395  1.00 17.24           C  
ATOM   1165  ND1 HIS A 135      32.866  36.900   6.927  1.00 17.29           N  
ATOM   1166  CD2 HIS A 135      32.565  38.876   7.815  1.00 15.89           C  
ATOM   1167  CE1 HIS A 135      31.556  37.084   7.034  1.00 19.25           C  
ATOM   1168  NE2 HIS A 135      31.347  38.279   7.565  1.00 16.69           N  
ATOM   1169  N   HIS A 136      34.541  40.248  10.188  1.00 13.54           N  
ATOM   1170  CA  HIS A 136      34.180  40.258  11.594  1.00 14.38           C  
ATOM   1171  C   HIS A 136      32.774  40.800  11.820  1.00 15.16           C  
ATOM   1172  O   HIS A 136      32.191  41.417  10.926  1.00 14.21           O  
ATOM   1173  CB  HIS A 136      35.224  41.045  12.370  1.00 14.16           C  
ATOM   1174  CG  HIS A 136      35.079  42.544  12.274  1.00 15.16           C  
ATOM   1175  ND1 HIS A 136      35.257  43.256  11.105  1.00 18.71           N  
ATOM   1176  CD2 HIS A 136      34.803  43.456  13.234  1.00 14.44           C  
ATOM   1177  CE1 HIS A 136      35.099  44.552  11.352  1.00 13.31           C  
ATOM   1178  NE2 HIS A 136      34.848  44.696  12.647  1.00 19.65           N  
ATOM   1179  N   LYS A 137      32.203  40.511  12.989  1.00 15.81           N  
ATOM   1180  CA  LYS A 137      30.884  41.088  13.357  1.00 17.02           C  
ATOM   1181  C   LYS A 137      31.016  41.487  14.819  1.00 17.76           C  
ATOM   1182  O   LYS A 137      31.605  40.724  15.605  1.00 17.83           O  
ATOM   1183  CB  LYS A 137      29.804  40.013  13.196  1.00 17.86           C  
ATOM   1184  CG  LYS A 137      28.382  40.442  13.534  1.00 20.40           C  
ATOM   1185  CD  LYS A 137      27.309  39.494  12.892  1.00 23.37           C  
ATOM   1186  CE  LYS A 137      27.281  38.138  13.439  1.00 31.87           C  
ATOM   1187  NZ  LYS A 137      26.104  37.447  12.771  1.00 34.14           N  
ATOM   1188  N   ALA A 138      30.474  42.645  15.197  1.00 17.58           N  
ATOM   1189  CA  ALA A 138      30.500  43.039  16.605  1.00 18.93           C  
ATOM   1190  C   ALA A 138      29.228  43.824  16.885  1.00 19.38           C  
ATOM   1191  O   ALA A 138      28.629  44.353  15.958  1.00 20.22           O  
ATOM   1192  CB  ALA A 138      31.747  43.905  16.858  1.00 18.27           C  
ATOM   1193  N   LYS A 139      28.826  43.921  18.140  1.00 18.79           N  
ATOM   1194  CA  LYS A 139      27.725  44.802  18.510  1.00 19.63           C  
ATOM   1195  C   LYS A 139      28.292  45.947  19.340  1.00 18.23           C  
ATOM   1196  O   LYS A 139      29.103  45.691  20.270  1.00 17.70           O  
ATOM   1197  CB  LYS A 139      26.665  44.033  19.343  1.00 20.73           C  
ATOM   1198  CG  LYS A 139      25.822  43.056  18.490  1.00 23.41           C  
ATOM   1199  CD  LYS A 139      24.928  42.127  19.315  1.00 25.89           C  
ATOM   1200  CE  LYS A 139      23.849  42.909  20.009  1.00 33.11           C  
ATOM   1201  NZ  LYS A 139      22.775  42.024  20.605  1.00 39.17           N  
ATOM   1202  N   SER A 140      27.896  47.180  19.006  1.00 16.38           N  
ATOM   1203  CA  SER A 140      28.194  48.359  19.848  1.00 17.50           C  
ATOM   1204  C   SER A 140      27.198  48.432  21.010  1.00 18.00           C  
ATOM   1205  O   SER A 140      27.579  48.643  22.165  1.00 18.49           O  
ATOM   1206  CB  SER A 140      28.132  49.652  19.019  1.00 17.25           C  
ATOM   1207  OG  SER A 140      28.382  50.781  19.834  1.00 18.12           O  
ATOM   1208  N   ASP A 141      25.911  48.297  20.687  1.00 17.18           N  
ATOM   1209  CA  ASP A 141      24.865  48.205  21.710  1.00 19.47           C  
ATOM   1210  C   ASP A 141      23.741  47.316  21.155  1.00 19.49           C  
ATOM   1211  O   ASP A 141      23.950  46.601  20.175  1.00 18.22           O  
ATOM   1212  CB  ASP A 141      24.409  49.608  22.148  1.00 19.67           C  
ATOM   1213  CG  ASP A 141      23.828  50.459  20.999  1.00 19.86           C  
ATOM   1214  OD1 ASP A 141      23.253  49.867  20.033  1.00 18.36           O  
ATOM   1215  OD2 ASP A 141      23.896  51.741  21.100  1.00 19.29           O  
ATOM   1216  N   ARG A 142      22.561  47.319  21.773  1.00 21.09           N  
ATOM   1217  CA  ARG A 142      21.494  46.445  21.269  1.00 22.68           C  
ATOM   1218  C   ARG A 142      21.095  46.762  19.810  1.00 20.49           C  
ATOM   1219  O   ARG A 142      20.679  45.877  19.063  1.00 21.00           O  
ATOM   1220  CB  ARG A 142      20.255  46.552  22.173  1.00 24.03           C  
ATOM   1221  CG  ARG A 142      19.366  45.328  22.056  1.00 30.09           C  
ATOM   1222  CD  ARG A 142      18.292  45.270  23.188  1.00 33.16           C  
ATOM   1223  NE  ARG A 142      17.619  46.554  23.305  1.00 43.91           N  
ATOM   1224  CZ  ARG A 142      16.666  46.967  22.471  1.00 47.56           C  
ATOM   1225  NH1 ARG A 142      16.247  46.172  21.474  1.00 48.47           N  
ATOM   1226  NH2 ARG A 142      16.130  48.171  22.642  1.00 48.22           N  
ATOM   1227  N   ILE A 143      21.210  48.027  19.419  1.00 17.76           N  
ATOM   1228  CA  ILE A 143      20.682  48.487  18.121  1.00 16.94           C  
ATOM   1229  C   ILE A 143      21.779  48.552  17.030  1.00 16.69           C  
ATOM   1230  O   ILE A 143      21.511  48.192  15.865  1.00 16.28           O  
ATOM   1231  CB  ILE A 143      20.060  49.901  18.278  1.00 17.28           C  
ATOM   1232  CG1 ILE A 143      18.937  49.896  19.339  1.00 20.54           C  
ATOM   1233  CG2 ILE A 143      19.504  50.447  16.948  1.00 17.07           C  
ATOM   1234  CD1 ILE A 143      17.758  48.981  19.024  1.00 24.12           C  
ATOM   1235  N   TRP A 144      22.987  48.993  17.400  1.00 15.03           N  
ATOM   1236  CA  TRP A 144      24.034  49.309  16.394  1.00 15.25           C  
ATOM   1237  C   TRP A 144      25.220  48.350  16.517  1.00 14.78           C  
ATOM   1238  O   TRP A 144      25.540  47.849  17.601  1.00 15.37           O  
ATOM   1239  CB  TRP A 144      24.556  50.754  16.573  1.00 16.05           C  
ATOM   1240  CG  TRP A 144      23.426  51.770  16.538  1.00 16.25           C  
ATOM   1241  CD1 TRP A 144      22.718  52.275  17.594  1.00 16.04           C  
ATOM   1242  CD2 TRP A 144      22.904  52.390  15.359  1.00 15.47           C  
ATOM   1243  NE1 TRP A 144      21.766  53.174  17.134  1.00 15.52           N  
ATOM   1244  CE2 TRP A 144      21.847  53.246  15.770  1.00 16.91           C  
ATOM   1245  CE3 TRP A 144      23.221  52.296  13.981  1.00 15.81           C  
ATOM   1246  CZ2 TRP A 144      21.109  54.013  14.866  1.00 18.20           C  
ATOM   1247  CZ3 TRP A 144      22.465  53.071  13.068  1.00 17.02           C  
ATOM   1248  CH2 TRP A 144      21.447  53.920  13.523  1.00 18.79           C  
ATOM   1249  N   GLY A 145      25.902  48.131  15.406  1.00 14.20           N  
ATOM   1250  CA  GLY A 145      27.015  47.186  15.395  1.00 14.84           C  
ATOM   1251  C   GLY A 145      27.772  47.226  14.086  1.00 14.83           C  
ATOM   1252  O   GLY A 145      27.596  48.148  13.288  1.00 15.05           O  
ATOM   1253  N   GLU A 146      28.616  46.223  13.879  1.00 13.85           N  
ATOM   1254  CA  GLU A 146      29.488  46.163  12.709  1.00 14.45           C  
ATOM   1255  C   GLU A 146      29.410  44.818  12.076  1.00 14.78           C  
ATOM   1256  O   GLU A 146      29.163  43.821  12.764  1.00 15.54           O  
ATOM   1257  CB  GLU A 146      30.953  46.384  13.118  1.00 14.70           C  
ATOM   1258  CG  GLU A 146      31.340  47.883  13.088  1.00 16.31           C  
ATOM   1259  CD  GLU A 146      31.366  48.501  11.653  1.00 18.39           C  
ATOM   1260  OE1 GLU A 146      30.944  47.906  10.602  1.00 17.26           O  
ATOM   1261  OE2 GLU A 146      31.825  49.652  11.563  1.00 20.37           O  
ATOM   1262  N   HIS A 147      29.563  44.772  10.754  1.00 14.47           N  
ATOM   1263  CA  HIS A 147      29.682  43.487  10.056  1.00 14.59           C  
ATOM   1264  C   HIS A 147      30.403  43.834   8.759  1.00 14.85           C  
ATOM   1265  O   HIS A 147      29.814  44.466   7.871  1.00 14.38           O  
ATOM   1266  CB  HIS A 147      28.286  42.884   9.751  1.00 15.60           C  
ATOM   1267  CG  HIS A 147      28.336  41.490   9.186  1.00 16.43           C  
ATOM   1268  ND1 HIS A 147      27.380  40.995   8.322  1.00 16.56           N  
ATOM   1269  CD2 HIS A 147      29.228  40.486   9.372  1.00 15.21           C  
ATOM   1270  CE1 HIS A 147      27.670  39.741   8.016  1.00 18.96           C  
ATOM   1271  NE2 HIS A 147      28.775  39.402   8.657  1.00 19.52           N  
ATOM   1272  N   GLU A 148      31.667  43.416   8.637  1.00 14.18           N  
ATOM   1273  CA  GLU A 148      32.515  43.932   7.567  1.00 14.85           C  
ATOM   1274  C   GLU A 148      33.403  42.876   6.984  1.00 14.94           C  
ATOM   1275  O   GLU A 148      33.857  41.977   7.699  1.00 15.82           O  
ATOM   1276  CB  GLU A 148      33.435  45.036   8.097  1.00 15.22           C  
ATOM   1277  CG  GLU A 148      32.674  46.286   8.641  1.00 16.27           C  
ATOM   1278  CD  GLU A 148      33.596  47.336   9.236  1.00 16.19           C  
ATOM   1279  OE1 GLU A 148      34.766  46.958   9.619  1.00 16.57           O  
ATOM   1280  OE2 GLU A 148      33.140  48.531   9.273  1.00 17.99           O  
ATOM   1281  N   ILE A 149      33.653  43.026   5.690  1.00 14.47           N  
ATOM   1282  CA  ILE A 149      34.832  42.473   5.037  1.00 13.98           C  
ATOM   1283  C   ILE A 149      35.854  43.607   5.153  1.00 14.98           C  
ATOM   1284  O   ILE A 149      35.754  44.599   4.440  1.00 13.14           O  
ATOM   1285  CB  ILE A 149      34.528  42.111   3.542  1.00 15.32           C  
ATOM   1286  CG1 ILE A 149      33.453  41.007   3.442  1.00 16.62           C  
ATOM   1287  CG2 ILE A 149      35.837  41.758   2.784  1.00 15.58           C  
ATOM   1288  CD1 ILE A 149      33.811  39.701   4.190  1.00 14.70           C  
ATOM   1289  N   CYS A 150      36.776  43.497   6.120  1.00 14.50           N  
ATOM   1290  CA  CYS A 150      37.583  44.654   6.502  1.00 13.46           C  
ATOM   1291  C   CYS A 150      39.028  44.469   6.015  1.00 14.89           C  
ATOM   1292  O   CYS A 150      39.705  43.496   6.382  1.00 14.37           O  
ATOM   1293  CB  CYS A 150      37.544  44.816   8.031  1.00 14.04           C  
ATOM   1294  SG  CYS A 150      38.419  46.319   8.528  1.00 16.30           S  
ATOM   1295  N   TYR A 151      39.465  45.364   5.127  1.00 13.62           N  
ATOM   1296  CA  TYR A 151      40.850  45.365   4.630  1.00 14.21           C  
ATOM   1297  C   TYR A 151      41.778  45.937   5.724  1.00 14.02           C  
ATOM   1298  O   TYR A 151      41.560  47.036   6.253  1.00 14.61           O  
ATOM   1299  CB  TYR A 151      40.978  46.239   3.383  1.00 15.17           C  
ATOM   1300  CG  TYR A 151      40.324  45.717   2.104  1.00 14.78           C  
ATOM   1301  CD1 TYR A 151      40.982  45.877   0.865  1.00 17.27           C  
ATOM   1302  CD2 TYR A 151      39.077  45.096   2.104  1.00 15.70           C  
ATOM   1303  CE1 TYR A 151      40.402  45.449  -0.332  1.00 17.19           C  
ATOM   1304  CE2 TYR A 151      38.493  44.637   0.904  1.00 16.05           C  
ATOM   1305  CZ  TYR A 151      39.155  44.838  -0.309  1.00 16.64           C  
ATOM   1306  OH  TYR A 151      38.582  44.392  -1.484  1.00 19.48           O  
ATOM   1307  N   LEU A 152      42.821  45.198   6.061  1.00 12.45           N  
ATOM   1308  CA  LEU A 152      43.789  45.665   7.059  1.00 12.47           C  
ATOM   1309  C   LEU A 152      44.955  46.295   6.333  1.00 13.57           C  
ATOM   1310  O   LEU A 152      45.594  45.656   5.470  1.00 13.69           O  
ATOM   1311  CB  LEU A 152      44.272  44.518   7.959  1.00 12.49           C  
ATOM   1312  CG  LEU A 152      45.289  44.799   9.084  1.00 12.97           C  
ATOM   1313  CD1 LEU A 152      44.866  46.032   9.983  1.00 12.97           C  
ATOM   1314  CD2 LEU A 152      45.520  43.500   9.921  1.00 13.47           C  
ATOM   1315  N   LEU A 153      45.166  47.575   6.640  1.00 12.50           N  
ATOM   1316  CA  LEU A 153      46.144  48.397   5.926  1.00 12.19           C  
ATOM   1317  C   LEU A 153      47.180  48.905   6.888  1.00 13.78           C  
ATOM   1318  O   LEU A 153      46.868  49.174   8.076  1.00 13.47           O  
ATOM   1319  CB  LEU A 153      45.466  49.600   5.293  1.00 12.42           C  
ATOM   1320  CG  LEU A 153      44.163  49.301   4.506  1.00 11.65           C  
ATOM   1321  CD1 LEU A 153      43.546  50.663   4.139  1.00 14.65           C  
ATOM   1322  CD2 LEU A 153      44.473  48.435   3.224  1.00 12.02           C  
ATOM   1323  N   LEU A 154      48.403  49.078   6.388  1.00 11.63           N  
ATOM   1324  CA  LEU A 154      49.516  49.446   7.261  1.00 11.94           C  
ATOM   1325  C   LEU A 154      50.261  50.656   6.669  1.00 13.92           C  
ATOM   1326  O   LEU A 154      50.526  50.691   5.445  1.00 14.38           O  
ATOM   1327  CB  LEU A 154      50.466  48.263   7.425  1.00 12.74           C  
ATOM   1328  CG  LEU A 154      51.640  48.518   8.390  1.00 15.24           C  
ATOM   1329  CD1 LEU A 154      51.945  47.217   9.144  1.00 16.12           C  
ATOM   1330  CD2 LEU A 154      52.871  49.023   7.612  1.00 15.11           C  
ATOM   1331  N   VAL A 155      50.638  51.596   7.540  1.00 13.16           N  
ATOM   1332  CA  VAL A 155      51.436  52.749   7.142  1.00 14.96           C  
ATOM   1333  C   VAL A 155      52.568  52.867   8.163  1.00 15.67           C  
ATOM   1334  O   VAL A 155      52.314  52.737   9.384  1.00 15.52           O  
ATOM   1335  CB  VAL A 155      50.625  54.072   7.230  1.00 15.54           C  
ATOM   1336  CG1 VAL A 155      51.522  55.265   6.823  1.00 18.26           C  
ATOM   1337  CG2 VAL A 155      49.438  54.060   6.294  1.00 16.52           C  
ATOM   1338  N   ARG A 156      53.799  53.104   7.709  0.50 15.77           N  
ATOM   1340  CA  ARG A 156      54.867  53.450   8.675  0.50 16.12           C  
ATOM   1342  C   ARG A 156      55.529  54.760   8.258  0.50 17.04           C  
ATOM   1344  O   ARG A 156      56.362  54.780   7.346  0.50 16.52           O  
ATOM   1346  CB  ARG A 156      55.902  52.343   8.869  0.50 17.14           C  
ATOM   1348  CG  ARG A 156      56.932  52.700   9.928  0.50 18.66           C  
ATOM   1350  CD  ARG A 156      58.039  51.658  10.031  0.50 22.98           C  
ATOM   1352  NE  ARG A 156      59.248  52.241  10.591  0.50 26.08           N  
ATOM   1354  CZ  ARG A 156      60.398  52.402   9.939  0.50 28.38           C  
ATOM   1356  NH1 ARG A 156      60.514  52.010   8.685  0.50 29.70           N  
ATOM   1358  NH2 ARG A 156      61.441  52.946  10.557  0.50 28.54           N  
ATOM   1360  N   LYS A 157      55.127  55.840   8.931  1.00 16.66           N  
ATOM   1361  CA  LYS A 157      55.515  57.201   8.569  1.00 18.70           C  
ATOM   1362  C   LYS A 157      55.340  58.121   9.770  1.00 18.03           C  
ATOM   1363  O   LYS A 157      54.426  57.929  10.565  1.00 16.95           O  
ATOM   1364  CB  LYS A 157      54.645  57.717   7.413  1.00 20.28           C  
ATOM   1365  CG  LYS A 157      55.316  58.842   6.606  1.00 25.59           C  
ATOM   1366  CD  LYS A 157      54.811  58.878   5.158  1.00 29.64           C  
ATOM   1367  CE  LYS A 157      55.801  59.630   4.248  1.00 34.61           C  
ATOM   1368  NZ  LYS A 157      55.209  60.433   3.096  1.00 32.77           N  
ATOM   1369  N   ASN A 158      56.229  59.113   9.897  1.00 18.17           N  
ATOM   1370  CA  ASN A 158      56.046  60.156  10.899  1.00 17.28           C  
ATOM   1371  C   ASN A 158      55.132  61.172  10.264  1.00 17.81           C  
ATOM   1372  O   ASN A 158      55.409  61.645   9.155  1.00 18.76           O  
ATOM   1373  CB  ASN A 158      57.406  60.767  11.264  1.00 19.41           C  
ATOM   1374  CG  ASN A 158      58.305  59.765  11.923  1.00 19.48           C  
ATOM   1375  OD1 ASN A 158      57.823  58.835  12.586  1.00 19.27           O  
ATOM   1376  ND2 ASN A 158      59.613  59.918  11.747  1.00 20.04           N  
ATOM   1377  N   VAL A 159      54.050  61.507  10.957  1.00 18.64           N  
ATOM   1378  CA  VAL A 159      53.034  62.428  10.401  1.00 18.48           C  
ATOM   1379  C   VAL A 159      52.636  63.440  11.448  1.00 17.69           C  
ATOM   1380  O   VAL A 159      52.933  63.265  12.656  1.00 18.00           O  
ATOM   1381  CB  VAL A 159      51.761  61.652   9.921  1.00 19.48           C  
ATOM   1382  CG1 VAL A 159      52.124  60.621   8.802  1.00 20.92           C  
ATOM   1383  CG2 VAL A 159      51.068  61.002  11.090  1.00 19.30           C  
ATOM   1384  N   THR A 160      52.001  64.513  10.994  1.00 17.74           N  
ATOM   1385  CA  THR A 160      51.446  65.512  11.898  1.00 17.23           C  
ATOM   1386  C   THR A 160      49.924  65.328  12.005  1.00 18.01           C  
ATOM   1387  O   THR A 160      49.286  64.903  11.058  1.00 17.55           O  
ATOM   1388  CB  THR A 160      51.783  66.945  11.457  1.00 18.68           C  
ATOM   1389  OG1 THR A 160      51.206  67.220  10.165  1.00 18.18           O  
ATOM   1390  CG2 THR A 160      53.335  67.145  11.353  1.00 18.06           C  
ATOM   1391  N   LEU A 161      49.354  65.740  13.139  1.00 16.92           N  
ATOM   1392  CA  LEU A 161      47.939  65.506  13.410  1.00 18.21           C  
ATOM   1393  C   LEU A 161      47.220  66.825  13.696  1.00 18.06           C  
ATOM   1394  O   LEU A 161      47.798  67.764  14.298  1.00 20.24           O  
ATOM   1395  CB  LEU A 161      47.801  64.608  14.650  1.00 17.81           C  
ATOM   1396  CG  LEU A 161      48.498  63.229  14.606  1.00 18.96           C  
ATOM   1397  CD1 LEU A 161      48.177  62.495  15.924  1.00 22.55           C  
ATOM   1398  CD2 LEU A 161      48.003  62.436  13.426  1.00 16.88           C  
ATOM   1399  N   ASN A 162      45.975  66.909  13.225  1.00 17.65           N  
ATOM   1400  CA  ASN A 162      45.080  68.016  13.538  1.00 17.75           C  
ATOM   1401  C   ASN A 162      43.696  67.370  13.545  1.00 16.46           C  
ATOM   1402  O   ASN A 162      42.925  67.529  12.592  1.00 16.05           O  
ATOM   1403  CB  ASN A 162      45.168  69.081  12.472  1.00 19.97           C  
ATOM   1404  CG  ASN A 162      44.223  70.238  12.720  1.00 24.00           C  
ATOM   1405  OD1 ASN A 162      43.906  70.561  13.855  1.00 23.61           O  
ATOM   1406  ND2 ASN A 162      43.764  70.854  11.651  1.00 27.00           N  
ATOM   1407  N   PRO A 163      43.429  66.543  14.575  1.00 16.31           N  
ATOM   1408  CA  PRO A 163      42.236  65.687  14.570  1.00 16.11           C  
ATOM   1409  C   PRO A 163      40.921  66.420  14.752  1.00 17.49           C  
ATOM   1410  O   PRO A 163      40.882  67.528  15.353  1.00 18.05           O  
ATOM   1411  CB  PRO A 163      42.473  64.689  15.743  1.00 16.40           C  
ATOM   1412  CG  PRO A 163      43.957  64.808  16.072  1.00 15.71           C  
ATOM   1413  CD  PRO A 163      44.294  66.280  15.739  1.00 16.10           C  
ATOM   1414  N   ASP A 164      39.872  65.849  14.149  1.00 16.41           N  
ATOM   1415  CA  ASP A 164      38.520  66.390  14.274  1.00 16.77           C  
ATOM   1416  C   ASP A 164      37.906  65.857  15.563  1.00 16.57           C  
ATOM   1417  O   ASP A 164      37.706  64.648  15.697  1.00 16.69           O  
ATOM   1418  CB  ASP A 164      37.686  65.980  13.059  1.00 17.70           C  
ATOM   1419  CG  ASP A 164      36.257  66.527  13.100  1.00 19.20           C  
ATOM   1420  OD1 ASP A 164      35.865  67.195  14.101  1.00 18.07           O  
ATOM   1421  OD2 ASP A 164      35.532  66.305  12.094  1.00 22.18           O  
ATOM   1422  N   PRO A 165      37.589  66.744  16.524  1.00 18.04           N  
ATOM   1423  CA  PRO A 165      37.020  66.196  17.779  1.00 16.97           C  
ATOM   1424  C   PRO A 165      35.632  65.542  17.609  1.00 17.29           C  
ATOM   1425  O   PRO A 165      35.190  64.844  18.520  1.00 17.86           O  
ATOM   1426  CB  PRO A 165      36.941  67.410  18.733  1.00 18.57           C  
ATOM   1427  CG  PRO A 165      37.183  68.640  17.848  1.00 21.98           C  
ATOM   1428  CD  PRO A 165      37.720  68.213  16.518  1.00 18.31           C  
ATOM   1429  N   SER A 166      34.961  65.779  16.479  1.00 16.70           N  
ATOM   1430  CA  SER A 166      33.729  65.056  16.152  1.00 16.21           C  
ATOM   1431  C   SER A 166      34.026  63.569  15.989  1.00 15.42           C  
ATOM   1432  O   SER A 166      33.141  62.754  16.247  1.00 16.64           O  
ATOM   1433  CB  SER A 166      33.140  65.564  14.826  1.00 17.11           C  
ATOM   1434  OG  SER A 166      31.904  64.892  14.539  1.00 16.61           O  
ATOM   1435  N   GLU A 167      35.236  63.253  15.513  1.00 13.75           N  
ATOM   1436  CA  GLU A 167      35.684  61.890  15.193  1.00 13.85           C  
ATOM   1437  C   GLU A 167      36.506  61.275  16.324  1.00 14.94           C  
ATOM   1438  O   GLU A 167      36.358  60.087  16.661  1.00 13.78           O  
ATOM   1439  CB  GLU A 167      36.564  61.906  13.930  1.00 13.74           C  
ATOM   1440  CG  GLU A 167      35.811  62.336  12.648  1.00 16.26           C  
ATOM   1441  CD  GLU A 167      34.821  61.286  12.148  1.00 18.41           C  
ATOM   1442  OE1 GLU A 167      34.851  60.123  12.644  1.00 18.20           O  
ATOM   1443  OE2 GLU A 167      34.019  61.621  11.248  1.00 20.73           O  
ATOM   1444  N   THR A 168      37.363  62.109  16.914  1.00 15.65           N  
ATOM   1445  CA  THR A 168      38.428  61.612  17.784  1.00 16.19           C  
ATOM   1446  C   THR A 168      38.475  62.365  19.129  1.00 16.69           C  
ATOM   1447  O   THR A 168      38.547  63.574  19.133  1.00 17.85           O  
ATOM   1448  CB  THR A 168      39.791  61.821  17.069  1.00 17.19           C  
ATOM   1449  OG1 THR A 168      39.740  61.199  15.774  1.00 18.73           O  
ATOM   1450  CG2 THR A 168      40.902  61.192  17.888  1.00 17.47           C  
ATOM   1451  N   LYS A 169      38.454  61.640  20.250  1.00 15.86           N  
ATOM   1452  CA  LYS A 169      38.514  62.230  21.604  1.00 16.89           C  
ATOM   1453  C   LYS A 169      39.963  62.399  22.059  1.00 17.05           C  
ATOM   1454  O   LYS A 169      40.282  63.380  22.767  1.00 17.92           O  
ATOM   1455  CB  LYS A 169      37.780  61.322  22.596  1.00 18.10           C  
ATOM   1456  CG  LYS A 169      37.591  61.894  23.992  1.00 23.74           C  
ATOM   1457  CD  LYS A 169      36.645  60.954  24.712  1.00 28.32           C  
ATOM   1458  CE  LYS A 169      36.633  61.172  26.189  1.00 32.19           C  
ATOM   1459  NZ  LYS A 169      35.680  62.205  26.659  1.00 35.98           N  
ATOM   1460  N   SER A 170      40.822  61.437  21.712  1.00 15.96           N  
ATOM   1461  CA  SER A 170      42.243  61.503  22.135  1.00 16.27           C  
ATOM   1462  C   SER A 170      43.076  60.542  21.299  1.00 16.82           C  
ATOM   1463  O   SER A 170      42.528  59.748  20.524  1.00 15.55           O  
ATOM   1464  CB  SER A 170      42.417  61.204  23.649  1.00 17.75           C  
ATOM   1465  OG  SER A 170      42.300  59.805  23.943  1.00 16.21           O  
ATOM   1466  N   ILE A 171      44.391  60.629  21.463  1.00 15.97           N  
ATOM   1467  CA  ILE A 171      45.299  59.781  20.709  1.00 16.64           C  
ATOM   1468  C   ILE A 171      46.444  59.360  21.622  1.00 17.40           C  
ATOM   1469  O   ILE A 171      46.987  60.185  22.384  1.00 16.79           O  
ATOM   1470  CB  ILE A 171      45.829  60.527  19.480  1.00 17.37           C  
ATOM   1471  CG1 ILE A 171      44.739  60.576  18.381  1.00 19.42           C  
ATOM   1472  CG2 ILE A 171      47.065  59.822  18.922  1.00 19.31           C  
ATOM   1473  CD1 ILE A 171      45.028  61.489  17.335  1.00 24.29           C  
ATOM   1474  N   LEU A 172      46.811  58.080  21.544  1.00 19.34           N  
ATOM   1475  CA  LEU A 172      48.008  57.552  22.208  1.00 19.03           C  
ATOM   1476  C   LEU A 172      48.968  56.975  21.142  1.00 18.57           C  
ATOM   1477  O   LEU A 172      48.542  56.336  20.197  1.00 19.45           O  
ATOM   1478  CB  LEU A 172      47.634  56.443  23.193  1.00 19.82           C  
ATOM   1479  CG  LEU A 172      46.592  56.761  24.300  1.00 23.55           C  
ATOM   1480  CD1 LEU A 172      46.112  55.445  24.916  1.00 26.64           C  
ATOM   1481  CD2 LEU A 172      47.227  57.569  25.328  1.00 28.45           C  
ATOM   1482  N   TYR A 173      50.264  57.194  21.291  1.00 17.60           N  
ATOM   1483  CA  TYR A 173      51.212  56.455  20.469  1.00 16.99           C  
ATOM   1484  C   TYR A 173      51.854  55.424  21.395  1.00 15.97           C  
ATOM   1485  O   TYR A 173      52.598  55.809  22.325  1.00 16.15           O  
ATOM   1486  CB  TYR A 173      52.275  57.392  19.926  1.00 17.73           C  
ATOM   1487  CG  TYR A 173      51.990  57.911  18.523  1.00 21.21           C  
ATOM   1488  CD1 TYR A 173      52.397  57.180  17.389  1.00 22.49           C  
ATOM   1489  CD2 TYR A 173      51.396  59.117  18.340  1.00 22.17           C  
ATOM   1490  CE1 TYR A 173      52.168  57.668  16.089  1.00 21.84           C  
ATOM   1491  CE2 TYR A 173      51.155  59.642  17.048  1.00 23.21           C  
ATOM   1492  CZ  TYR A 173      51.553  58.891  15.933  1.00 23.35           C  
ATOM   1493  OH  TYR A 173      51.360  59.369  14.665  1.00 24.79           O  
ATOM   1494  N   LEU A 174      51.530  54.158  21.168  1.00 15.00           N  
ATOM   1495  CA  LEU A 174      51.950  53.046  22.041  1.00 14.26           C  
ATOM   1496  C   LEU A 174      53.042  52.186  21.464  1.00 14.10           C  
ATOM   1497  O   LEU A 174      53.031  51.871  20.257  1.00 14.04           O  
ATOM   1498  CB  LEU A 174      50.735  52.154  22.379  1.00 13.70           C  
ATOM   1499  CG  LEU A 174      49.558  52.877  23.048  1.00 14.14           C  
ATOM   1500  CD1 LEU A 174      48.599  51.782  23.524  1.00 14.48           C  
ATOM   1501  CD2 LEU A 174      50.060  53.750  24.236  1.00 14.83           C  
ATOM   1502  N   SER A 175      53.993  51.829  22.321  1.00 14.04           N  
ATOM   1503  CA  SER A 175      54.924  50.757  22.007  1.00 14.82           C  
ATOM   1504  C   SER A 175      54.153  49.450  21.932  1.00 14.03           C  
ATOM   1505  O   SER A 175      52.986  49.370  22.399  1.00 13.56           O  
ATOM   1506  CB  SER A 175      56.004  50.644  23.091  1.00 14.98           C  
ATOM   1507  OG  SER A 175      55.452  50.195  24.345  1.00 15.68           O  
ATOM   1508  N   GLN A 176      54.807  48.420  21.395  1.00 14.00           N  
ATOM   1509  CA  GLN A 176      54.144  47.119  21.308  1.00 15.12           C  
ATOM   1510  C   GLN A 176      53.793  46.667  22.731  1.00 15.11           C  
ATOM   1511  O   GLN A 176      52.719  46.094  22.986  1.00 14.80           O  
ATOM   1512  CB  GLN A 176      55.099  46.128  20.633  1.00 17.35           C  
ATOM   1513  CG  GLN A 176      54.483  44.818  20.421  1.00 20.76           C  
ATOM   1514  CD  GLN A 176      55.410  43.847  19.714  1.00 26.05           C  
ATOM   1515  OE1 GLN A 176      56.665  43.983  19.727  1.00 27.91           O  
ATOM   1516  NE2 GLN A 176      54.798  42.850  19.083  1.00 26.36           N  
ATOM   1517  N   GLU A 177      54.726  46.902  23.649  0.50 15.09           N  
ATOM   1519  CA  GLU A 177      54.551  46.481  25.048  0.50 15.87           C  
ATOM   1521  C   GLU A 177      53.337  47.194  25.662  0.50 15.36           C  
ATOM   1523  O   GLU A 177      52.507  46.578  26.339  0.50 14.79           O  
ATOM   1525  CB  GLU A 177      55.840  46.757  25.826  0.50 16.96           C  
ATOM   1527  CG  GLU A 177      57.034  45.880  25.365  0.50 17.25           C  
ATOM   1529  CD  GLU A 177      57.767  46.350  24.075  0.50 17.51           C  
ATOM   1531  OE1 GLU A 177      57.542  47.468  23.520  0.50 10.99           O  
ATOM   1533  OE2 GLU A 177      58.628  45.559  23.603  0.50 21.13           O  
ATOM   1535  N   GLU A 178      53.216  48.489  25.395  1.00 14.47           N  
ATOM   1536  CA  GLU A 178      52.091  49.268  25.911  1.00 14.07           C  
ATOM   1537  C   GLU A 178      50.749  48.844  25.301  1.00 13.27           C  
ATOM   1538  O   GLU A 178      49.688  48.866  25.978  1.00 14.04           O  
ATOM   1539  CB  GLU A 178      52.336  50.755  25.673  1.00 14.75           C  
ATOM   1540  CG  GLU A 178      53.440  51.301  26.568  1.00 16.26           C  
ATOM   1541  CD  GLU A 178      53.786  52.733  26.211  1.00 22.00           C  
ATOM   1542  OE1 GLU A 178      53.824  53.061  25.002  1.00 20.35           O  
ATOM   1543  OE2 GLU A 178      53.997  53.545  27.151  1.00 26.33           O  
ATOM   1544  N   LEU A 179      50.764  48.474  24.034  1.00 12.64           N  
ATOM   1545  CA  LEU A 179      49.516  47.957  23.415  1.00 12.58           C  
ATOM   1546  C   LEU A 179      49.112  46.653  24.111  1.00 13.56           C  
ATOM   1547  O   LEU A 179      47.936  46.453  24.448  1.00 12.30           O  
ATOM   1548  CB  LEU A 179      49.650  47.767  21.908  1.00 13.38           C  
ATOM   1549  CG  LEU A 179      48.409  47.114  21.227  1.00 13.20           C  
ATOM   1550  CD1 LEU A 179      47.103  47.932  21.448  1.00 15.60           C  
ATOM   1551  CD2 LEU A 179      48.673  46.783  19.705  1.00 13.84           C  
ATOM   1552  N   TRP A 180      50.095  45.787  24.394  1.00 13.01           N  
ATOM   1553  CA  TRP A 180      49.784  44.522  25.064  1.00 13.72           C  
ATOM   1554  C   TRP A 180      49.160  44.859  26.423  1.00 13.38           C  
ATOM   1555  O   TRP A 180      48.170  44.236  26.853  1.00 13.83           O  
ATOM   1556  CB  TRP A 180      51.083  43.708  25.251  1.00 13.70           C  
ATOM   1557  CG  TRP A 180      50.871  42.371  25.948  1.00 16.56           C  
ATOM   1558  CD1 TRP A 180      50.699  41.166  25.362  1.00 18.45           C  
ATOM   1559  CD2 TRP A 180      50.829  42.147  27.357  1.00 16.57           C  
ATOM   1560  NE1 TRP A 180      50.523  40.179  26.316  1.00 20.16           N  
ATOM   1561  CE2 TRP A 180      50.604  40.757  27.552  1.00 19.01           C  
ATOM   1562  CE3 TRP A 180      50.957  42.986  28.475  1.00 16.84           C  
ATOM   1563  CZ2 TRP A 180      50.498  40.181  28.826  1.00 20.50           C  
ATOM   1564  CZ3 TRP A 180      50.858  42.411  29.756  1.00 19.30           C  
ATOM   1565  CH2 TRP A 180      50.621  41.016  29.908  1.00 20.87           C  
ATOM   1566  N   GLU A 181      49.743  45.845  27.094  1.00 14.02           N  
ATOM   1567  CA  GLU A 181      49.242  46.276  28.424  1.00 16.89           C  
ATOM   1568  C   GLU A 181      47.822  46.844  28.336  1.00 14.56           C  
ATOM   1569  O   GLU A 181      47.001  46.578  29.217  1.00 14.85           O  
ATOM   1570  CB  GLU A 181      50.188  47.300  29.047  1.00 16.42           C  
ATOM   1571  CG  GLU A 181      49.743  47.726  30.465  1.00 22.27           C  
ATOM   1572  CD  GLU A 181      50.642  48.827  31.050  1.00 27.41           C  
ATOM   1573  OE1 GLU A 181      51.856  48.850  30.682  1.00 32.83           O  
ATOM   1574  OE2 GLU A 181      50.153  49.654  31.871  1.00 35.09           O  
ATOM   1575  N   LEU A 182      47.567  47.686  27.337  1.00 14.59           N  
ATOM   1576  CA  LEU A 182      46.202  48.215  27.115  1.00 13.61           C  
ATOM   1577  C   LEU A 182      45.184  47.059  27.039  1.00 13.54           C  
ATOM   1578  O   LEU A 182      44.098  47.150  27.584  1.00 14.19           O  
ATOM   1579  CB  LEU A 182      46.156  48.991  25.798  1.00 14.10           C  
ATOM   1580  CG  LEU A 182      44.817  49.675  25.494  1.00 13.71           C  
ATOM   1581  CD1 LEU A 182      44.576  50.916  26.430  1.00 18.22           C  
ATOM   1582  CD2 LEU A 182      44.805  50.079  24.043  1.00 15.70           C  
ATOM   1583  N   LEU A 183      45.553  46.000  26.318  1.00 13.83           N  
ATOM   1584  CA  LEU A 183      44.630  44.861  26.120  1.00 14.05           C  
ATOM   1585  C   LEU A 183      44.484  44.060  27.401  1.00 15.08           C  
ATOM   1586  O   LEU A 183      43.393  43.600  27.725  1.00 16.98           O  
ATOM   1587  CB  LEU A 183      45.058  44.003  24.916  1.00 13.30           C  
ATOM   1588  CG  LEU A 183      44.939  44.738  23.554  1.00 11.76           C  
ATOM   1589  CD1 LEU A 183      45.543  43.859  22.429  1.00 15.22           C  
ATOM   1590  CD2 LEU A 183      43.480  45.049  23.215  1.00 15.40           C  
ATOM   1591  N   GLU A 184      45.561  43.939  28.172  1.00 15.27           N  
ATOM   1592  CA  GLU A 184      45.455  43.289  29.481  1.00 18.18           C  
ATOM   1593  C   GLU A 184      44.487  44.050  30.362  1.00 16.70           C  
ATOM   1594  O   GLU A 184      43.654  43.441  31.064  1.00 17.20           O  
ATOM   1595  CB  GLU A 184      46.834  43.210  30.147  1.00 20.22           C  
ATOM   1596  CG  GLU A 184      46.917  42.136  31.195  1.00 29.85           C  
ATOM   1597  CD  GLU A 184      47.051  40.704  30.590  1.00 37.16           C  
ATOM   1598  OE1 GLU A 184      47.234  39.768  31.393  1.00 47.33           O  
ATOM   1599  OE2 GLU A 184      47.012  40.495  29.336  1.00 40.72           O  
ATOM   1600  N   ARG A 185      44.601  45.384  30.344  1.00 15.58           N  
ATOM   1601  CA  ARG A 185      43.698  46.245  31.144  1.00 15.08           C  
ATOM   1602  C   ARG A 185      42.270  46.146  30.616  1.00 14.44           C  
ATOM   1603  O   ARG A 185      41.312  46.119  31.418  1.00 15.70           O  
ATOM   1604  CB  ARG A 185      44.195  47.695  31.146  1.00 14.39           C  
ATOM   1605  CG  ARG A 185      45.503  47.839  31.931  1.00 14.47           C  
ATOM   1606  CD  ARG A 185      46.068  49.237  31.863  1.00 19.07           C  
ATOM   1607  NE  ARG A 185      47.385  49.302  32.524  1.00 22.55           N  
ATOM   1608  CZ  ARG A 185      47.558  49.363  33.848  1.00 26.62           C  
ATOM   1609  NH1 ARG A 185      46.512  49.389  34.674  1.00 24.56           N  
ATOM   1610  NH2 ARG A 185      48.785  49.448  34.350  1.00 26.03           N  
ATOM   1611  N   GLU A 186      42.108  46.057  29.293  1.00 13.76           N  
ATOM   1612  CA  GLU A 186      40.761  45.888  28.722  1.00 13.73           C  
ATOM   1613  C   GLU A 186      40.129  44.623  29.277  1.00 16.16           C  
ATOM   1614  O   GLU A 186      38.942  44.607  29.633  1.00 15.47           O  
ATOM   1615  CB  GLU A 186      40.792  45.792  27.201  1.00 14.12           C  
ATOM   1616  CG  GLU A 186      39.373  45.848  26.564  1.00 16.65           C  
ATOM   1617  CD  GLU A 186      38.628  44.501  26.548  1.00 19.77           C  
ATOM   1618  OE1 GLU A 186      39.291  43.437  26.616  1.00 20.31           O  
ATOM   1619  OE2 GLU A 186      37.364  44.501  26.469  1.00 21.32           O  
ATOM   1620  N   ALA A 187      40.922  43.555  29.357  1.00 16.35           N  
ATOM   1621  CA  ALA A 187      40.352  42.249  29.725  1.00 19.20           C  
ATOM   1622  C   ALA A 187      39.849  42.230  31.176  1.00 20.31           C  
ATOM   1623  O   ALA A 187      38.910  41.462  31.512  1.00 23.69           O  
ATOM   1624  CB  ALA A 187      41.373  41.136  29.461  1.00 19.45           C  
ATOM   1625  N   ARG A 188      40.449  43.060  32.028  1.00 20.93           N  
ATOM   1626  CA  ARG A 188      40.009  43.293  33.424  1.00 23.24           C  
ATOM   1627  C   ARG A 188      38.758  44.167  33.533  1.00 21.75           C  
ATOM   1628  O   ARG A 188      38.053  44.145  34.562  1.00 22.68           O  
ATOM   1629  CB  ARG A 188      41.092  44.059  34.207  1.00 23.67           C  
ATOM   1630  CG  ARG A 188      42.353  43.370  34.567  1.00 28.38           C  
ATOM   1631  CD  ARG A 188      43.070  44.174  35.696  1.00 26.30           C  
ATOM   1632  NE  ARG A 188      42.401  43.962  36.967  1.00 25.89           N  
ATOM   1633  CZ  ARG A 188      41.922  44.905  37.793  1.00 24.00           C  
ATOM   1634  NH1 ARG A 188      42.064  46.234  37.591  1.00 19.52           N  
ATOM   1635  NH2 ARG A 188      41.331  44.489  38.880  1.00 19.83           N  
ATOM   1636  N   GLY A 189      38.525  44.998  32.525  1.00 20.08           N  
ATOM   1637  CA  GLY A 189      37.431  45.984  32.577  1.00 18.90           C  
ATOM   1638  C   GLY A 189      37.878  47.430  32.781  1.00 17.24           C  
ATOM   1639  O   GLY A 189      37.033  48.321  32.921  1.00 17.54           O  
ATOM   1640  N   GLU A 190      39.189  47.684  32.756  1.00 14.62           N  
ATOM   1641  CA  GLU A 190      39.674  49.040  33.064  1.00 15.36           C  
ATOM   1642  C   GLU A 190      39.383  50.081  31.989  1.00 16.12           C  
ATOM   1643  O   GLU A 190      39.284  51.259  32.283  1.00 16.94           O  
ATOM   1644  CB  GLU A 190      41.188  49.056  33.313  1.00 14.34           C  
ATOM   1645  CG  GLU A 190      41.652  48.162  34.469  1.00 17.00           C  
ATOM   1646  CD  GLU A 190      43.117  48.355  34.817  1.00 16.95           C  
ATOM   1647  OE1 GLU A 190      43.748  49.378  34.431  1.00 17.01           O  
ATOM   1648  OE2 GLU A 190      43.644  47.457  35.504  1.00 18.60           O  
ATOM   1649  N   VAL A 191      39.353  49.631  30.735  1.00 16.44           N  
ATOM   1650  CA  VAL A 191      39.314  50.522  29.588  1.00 16.51           C  
ATOM   1651  C   VAL A 191      38.484  49.853  28.467  1.00 16.68           C  
ATOM   1652  O   VAL A 191      38.481  48.621  28.351  1.00 15.90           O  
ATOM   1653  CB  VAL A 191      40.770  50.823  29.126  1.00 17.47           C  
ATOM   1654  CG1 VAL A 191      41.483  49.549  28.690  1.00 17.99           C  
ATOM   1655  CG2 VAL A 191      40.810  51.849  28.040  1.00 20.42           C  
ATOM   1656  N   LYS A 192      37.787  50.661  27.664  1.00 16.12           N  
ATOM   1657  CA  LYS A 192      36.942  50.160  26.573  1.00 16.59           C  
ATOM   1658  C   LYS A 192      37.748  50.182  25.307  1.00 16.74           C  
ATOM   1659  O   LYS A 192      38.259  51.257  24.913  1.00 16.77           O  
ATOM   1660  CB  LYS A 192      35.721  51.056  26.354  1.00 19.14           C  
ATOM   1661  CG  LYS A 192      34.947  51.353  27.624  1.00 25.46           C  
ATOM   1662  CD  LYS A 192      34.414  50.077  28.221  1.00 32.38           C  
ATOM   1663  CE  LYS A 192      33.093  49.682  27.546  1.00 38.63           C  
ATOM   1664  NZ  LYS A 192      32.228  50.840  27.210  1.00 44.29           N  
ATOM   1665  N   VAL A 193      37.816  49.027  24.645  1.00 14.13           N  
ATOM   1666  CA  VAL A 193      38.612  48.904  23.417  1.00 14.95           C  
ATOM   1667  C   VAL A 193      37.762  48.167  22.379  1.00 14.85           C  
ATOM   1668  O   VAL A 193      37.028  47.223  22.717  1.00 15.28           O  
ATOM   1669  CB  VAL A 193      39.908  48.101  23.651  1.00 15.21           C  
ATOM   1670  CG1 VAL A 193      40.708  48.041  22.370  1.00 15.64           C  
ATOM   1671  CG2 VAL A 193      40.775  48.703  24.811  1.00 15.10           C  
ATOM   1672  N   THR A 194      37.832  48.583  21.115  1.00 13.92           N  
ATOM   1673  CA  THR A 194      37.020  47.936  20.088  1.00 15.06           C  
ATOM   1674  C   THR A 194      37.490  46.478  19.958  1.00 14.52           C  
ATOM   1675  O   THR A 194      38.694  46.191  20.069  1.00 13.92           O  
ATOM   1676  CB  THR A 194      37.142  48.628  18.718  1.00 15.01           C  
ATOM   1677  OG1 THR A 194      38.526  48.760  18.373  1.00 14.31           O  
ATOM   1678  CG2 THR A 194      36.456  50.035  18.764  1.00 15.34           C  
ATOM   1679  N   PRO A 195      36.547  45.566  19.746  1.00 16.03           N  
ATOM   1680  CA  PRO A 195      36.966  44.150  19.727  1.00 16.85           C  
ATOM   1681  C   PRO A 195      37.990  43.798  18.634  1.00 16.45           C  
ATOM   1682  O   PRO A 195      38.827  42.863  18.803  1.00 17.39           O  
ATOM   1683  CB  PRO A 195      35.650  43.384  19.524  1.00 18.67           C  
ATOM   1684  CG  PRO A 195      34.658  44.396  18.996  1.00 20.24           C  
ATOM   1685  CD  PRO A 195      35.097  45.747  19.551  1.00 16.24           C  
ATOM   1686  N   TRP A 196      37.952  44.511  17.512  1.00 15.04           N  
ATOM   1687  CA  TRP A 196      38.843  44.155  16.422  1.00 14.71           C  
ATOM   1688  C   TRP A 196      40.299  44.566  16.696  1.00 14.96           C  
ATOM   1689  O   TRP A 196      41.205  44.024  16.077  1.00 15.00           O  
ATOM   1690  CB  TRP A 196      38.403  44.713  15.072  1.00 15.63           C  
ATOM   1691  CG  TRP A 196      38.219  46.199  15.013  1.00 15.71           C  
ATOM   1692  CD1 TRP A 196      39.143  47.143  14.643  1.00 16.58           C  
ATOM   1693  CD2 TRP A 196      37.007  46.900  15.304  1.00 15.99           C  
ATOM   1694  NE1 TRP A 196      38.571  48.395  14.710  1.00 17.34           N  
ATOM   1695  CE2 TRP A 196      37.262  48.274  15.121  1.00 16.47           C  
ATOM   1696  CE3 TRP A 196      35.729  46.491  15.723  1.00 16.95           C  
ATOM   1697  CZ2 TRP A 196      36.266  49.256  15.303  1.00 17.09           C  
ATOM   1698  CZ3 TRP A 196      34.719  47.463  15.902  1.00 18.00           C  
ATOM   1699  CH2 TRP A 196      35.003  48.828  15.705  1.00 17.15           C  
ATOM   1700  N   LEU A 197      40.518  45.542  17.590  1.00 13.83           N  
ATOM   1701  CA  LEU A 197      41.905  45.892  17.935  1.00 14.36           C  
ATOM   1702  C   LEU A 197      42.628  44.707  18.572  1.00 14.66           C  
ATOM   1703  O   LEU A 197      43.771  44.420  18.217  1.00 14.41           O  
ATOM   1704  CB  LEU A 197      41.988  47.121  18.855  1.00 14.84           C  
ATOM   1705  CG  LEU A 197      43.445  47.565  19.130  1.00 13.38           C  
ATOM   1706  CD1 LEU A 197      44.220  47.861  17.817  1.00 17.80           C  
ATOM   1707  CD2 LEU A 197      43.461  48.781  20.101  1.00 14.67           C  
ATOM   1708  N   ARG A 198      41.980  44.009  19.503  1.00 14.24           N  
ATOM   1709  CA  ARG A 198      42.611  42.815  20.106  1.00 14.54           C  
ATOM   1710  C   ARG A 198      42.876  41.775  19.007  1.00 15.60           C  
ATOM   1711  O   ARG A 198      43.971  41.208  18.916  1.00 15.42           O  
ATOM   1712  CB  ARG A 198      41.694  42.190  21.170  1.00 15.67           C  
ATOM   1713  CG  ARG A 198      42.225  40.836  21.705  1.00 16.62           C  
ATOM   1714  CD  ARG A 198      41.290  40.301  22.802  1.00 19.11           C  
ATOM   1715  NE  ARG A 198      41.126  41.239  23.914  1.00 20.21           N  
ATOM   1716  CZ  ARG A 198      42.014  41.399  24.873  1.00 19.82           C  
ATOM   1717  NH1 ARG A 198      43.154  40.710  24.838  1.00 21.12           N  
ATOM   1718  NH2 ARG A 198      41.764  42.268  25.857  1.00 18.48           N  
ATOM   1719  N   THR A 199      41.885  41.562  18.139  1.00 14.25           N  
ATOM   1720  CA  THR A 199      42.065  40.575  17.064  1.00 14.98           C  
ATOM   1721  C   THR A 199      43.277  40.911  16.187  1.00 16.65           C  
ATOM   1722  O   THR A 199      44.115  40.032  15.845  1.00 16.58           O  
ATOM   1723  CB  THR A 199      40.794  40.540  16.217  1.00 15.52           C  
ATOM   1724  OG1 THR A 199      39.705  40.124  17.068  1.00 16.04           O  
ATOM   1725  CG2 THR A 199      40.922  39.536  15.058  1.00 18.35           C  
ATOM   1726  N   ILE A 200      43.356  42.164  15.768  1.00 14.82           N  
ATOM   1727  CA  ILE A 200      44.438  42.591  14.862  1.00 17.15           C  
ATOM   1728  C   ILE A 200      45.783  42.453  15.584  1.00 14.70           C  
ATOM   1729  O   ILE A 200      46.776  41.989  15.012  1.00 14.52           O  
ATOM   1730  CB  ILE A 200      44.206  44.067  14.415  1.00 17.26           C  
ATOM   1731  CG1 ILE A 200      43.046  44.145  13.406  1.00 19.83           C  
ATOM   1732  CG2 ILE A 200      45.492  44.700  13.823  1.00 21.87           C  
ATOM   1733  CD1 ILE A 200      42.540  45.660  13.291  1.00 22.57           C  
ATOM   1734  N   ALA A 201      45.815  42.846  16.830  1.00 14.55           N  
ATOM   1735  CA  ALA A 201      47.058  42.776  17.610  1.00 14.31           C  
ATOM   1736  C   ALA A 201      47.550  41.328  17.749  1.00 15.31           C  
ATOM   1737  O   ALA A 201      48.711  41.012  17.469  1.00 15.16           O  
ATOM   1738  CB  ALA A 201      46.848  43.393  18.999  1.00 14.77           C  
ATOM   1739  N   GLU A 202      46.670  40.462  18.234  1.00 15.09           N  
ATOM   1740  CA  GLU A 202      47.062  39.076  18.550  1.00 16.24           C  
ATOM   1741  C   GLU A 202      47.298  38.221  17.318  1.00 16.18           C  
ATOM   1742  O   GLU A 202      48.119  37.270  17.360  1.00 17.88           O  
ATOM   1743  CB  GLU A 202      46.012  38.438  19.473  1.00 16.23           C  
ATOM   1744  CG  GLU A 202      45.953  39.228  20.812  1.00 19.67           C  
ATOM   1745  CD  GLU A 202      44.990  38.698  21.845  1.00 20.56           C  
ATOM   1746  OE1 GLU A 202      44.097  37.882  21.528  1.00 21.01           O  
ATOM   1747  OE2 GLU A 202      45.159  39.126  23.007  1.00 24.18           O  
ATOM   1748  N   ARG A 203      46.582  38.511  16.224  1.00 15.49           N  
ATOM   1749  CA  ARG A 203      46.716  37.693  15.019  1.00 16.77           C  
ATOM   1750  C   ARG A 203      47.819  38.187  14.108  1.00 16.91           C  
ATOM   1751  O   ARG A 203      48.460  37.379  13.423  1.00 16.84           O  
ATOM   1752  CB  ARG A 203      45.392  37.663  14.221  1.00 18.33           C  
ATOM   1753  CG  ARG A 203      44.211  36.907  14.919  1.00 22.17           C  
ATOM   1754  CD  ARG A 203      44.492  35.415  15.131  1.00 28.38           C  
ATOM   1755  NE  ARG A 203      44.706  34.763  13.842  1.00 30.78           N  
ATOM   1756  CZ  ARG A 203      43.742  34.302  13.035  1.00 32.27           C  
ATOM   1757  NH1 ARG A 203      42.445  34.329  13.372  1.00 27.46           N  
ATOM   1758  NH2 ARG A 203      44.111  33.765  11.888  1.00 32.49           N  
ATOM   1759  N   PHE A 204      48.018  39.517  14.067  1.00 16.07           N  
ATOM   1760  CA  PHE A 204      48.867  40.126  13.076  1.00 16.17           C  
ATOM   1761  C   PHE A 204      49.971  41.004  13.661  1.00 15.83           C  
ATOM   1762  O   PHE A 204      51.139  40.811  13.307  1.00 16.22           O  
ATOM   1763  CB  PHE A 204      48.044  40.937  12.075  1.00 15.69           C  
ATOM   1764  CG  PHE A 204      46.966  40.125  11.393  1.00 17.44           C  
ATOM   1765  CD1 PHE A 204      47.305  39.053  10.562  1.00 15.42           C  
ATOM   1766  CD2 PHE A 204      45.618  40.410  11.610  1.00 19.17           C  
ATOM   1767  CE1 PHE A 204      46.317  38.283   9.936  1.00 19.68           C  
ATOM   1768  CE2 PHE A 204      44.618  39.621  10.985  1.00 18.58           C  
ATOM   1769  CZ  PHE A 204      44.989  38.548  10.167  1.00 18.28           C  
ATOM   1770  N   LEU A 205      49.627  41.979  14.514  1.00 14.77           N  
ATOM   1771  CA  LEU A 205      50.619  43.047  14.813  1.00 15.63           C  
ATOM   1772  C   LEU A 205      51.810  42.507  15.565  1.00 16.92           C  
ATOM   1773  O   LEU A 205      52.943  42.859  15.259  1.00 18.24           O  
ATOM   1774  CB  LEU A 205      50.032  44.254  15.597  1.00 14.67           C  
ATOM   1775  CG  LEU A 205      48.774  44.869  14.945  1.00 15.97           C  
ATOM   1776  CD1 LEU A 205      48.371  46.074  15.783  1.00 17.41           C  
ATOM   1777  CD2 LEU A 205      49.042  45.268  13.464  1.00 16.35           C  
ATOM   1778  N   TYR A 206      51.578  41.616  16.517  1.00 16.89           N  
ATOM   1779  CA  TYR A 206      52.728  41.053  17.244  1.00 18.12           C  
ATOM   1780  C   TYR A 206      53.682  40.305  16.312  1.00 19.37           C  
ATOM   1781  O   TYR A 206      54.900  40.361  16.510  1.00 20.78           O  
ATOM   1782  CB  TYR A 206      52.311  40.169  18.433  1.00 18.10           C  
ATOM   1783  CG  TYR A 206      51.384  40.808  19.474  1.00 15.79           C  
ATOM   1784  CD1 TYR A 206      51.312  42.208  19.642  1.00 14.10           C  
ATOM   1785  CD2 TYR A 206      50.624  39.994  20.299  1.00 14.76           C  
ATOM   1786  CE1 TYR A 206      50.467  42.769  20.585  1.00 15.70           C  
ATOM   1787  CE2 TYR A 206      49.788  40.523  21.270  1.00 15.05           C  
ATOM   1788  CZ  TYR A 206      49.710  41.918  21.407  1.00 16.53           C  
ATOM   1789  OH  TYR A 206      48.866  42.422  22.354  1.00 16.25           O  
ATOM   1790  N   ARG A 207      53.141  39.613  15.305  0.50 19.25           N  
ATOM   1792  CA  ARG A 207      53.979  38.961  14.283  0.50 20.15           C  
ATOM   1794  C   ARG A 207      54.812  39.997  13.513  0.50 18.72           C  
ATOM   1796  O   ARG A 207      56.033  39.823  13.317  0.50 18.10           O  
ATOM   1798  CB  ARG A 207      53.118  38.227  13.243  0.50 21.01           C  
ATOM   1800  CG  ARG A 207      52.480  36.933  13.689  0.50 25.74           C  
ATOM   1802  CD  ARG A 207      51.861  36.169  12.490  0.50 26.36           C  
ATOM   1804  NE  ARG A 207      52.875  35.643  11.566  0.50 33.83           N  
ATOM   1806  CZ  ARG A 207      52.625  34.991  10.432  0.50 34.54           C  
ATOM   1808  NH1 ARG A 207      51.379  34.764  10.037  0.50 35.90           N  
ATOM   1810  NH2 ARG A 207      53.635  34.557   9.687  0.50 37.74           N  
ATOM   1812  N   TRP A 208      54.144  41.066  13.075  1.00 16.26           N  
ATOM   1813  CA  TRP A 208      54.767  42.043  12.164  1.00 17.20           C  
ATOM   1814  C   TRP A 208      55.739  43.000  12.829  1.00 16.82           C  
ATOM   1815  O   TRP A 208      56.630  43.515  12.163  1.00 18.08           O  
ATOM   1816  CB  TRP A 208      53.693  42.905  11.511  1.00 16.80           C  
ATOM   1817  CG  TRP A 208      52.700  42.120  10.735  1.00 16.78           C  
ATOM   1818  CD1 TRP A 208      52.788  40.801  10.333  1.00 17.81           C  
ATOM   1819  CD2 TRP A 208      51.451  42.613  10.245  1.00 17.38           C  
ATOM   1820  NE1 TRP A 208      51.638  40.447   9.647  1.00 20.66           N  
ATOM   1821  CE2 TRP A 208      50.814  41.552   9.565  1.00 17.34           C  
ATOM   1822  CE3 TRP A 208      50.796  43.851  10.344  1.00 16.60           C  
ATOM   1823  CZ2 TRP A 208      49.552  41.702   8.945  1.00 19.51           C  
ATOM   1824  CZ3 TRP A 208      49.534  44.003   9.740  1.00 18.83           C  
ATOM   1825  CH2 TRP A 208      48.924  42.929   9.058  1.00 20.44           C  
ATOM   1826  N   TRP A 209      55.567  43.246  14.131  1.00 16.04           N  
ATOM   1827  CA  TRP A 209      56.225  44.406  14.784  1.00 17.01           C  
ATOM   1828  C   TRP A 209      57.750  44.416  14.667  1.00 18.49           C  
ATOM   1829  O   TRP A 209      58.323  45.483  14.444  1.00 18.03           O  
ATOM   1830  CB  TRP A 209      55.830  44.496  16.266  1.00 16.57           C  
ATOM   1831  CG  TRP A 209      55.528  45.886  16.726  1.00 16.55           C  
ATOM   1832  CD1 TRP A 209      56.407  46.922  16.859  1.00 17.90           C  
ATOM   1833  CD2 TRP A 209      54.279  46.344  17.214  1.00 17.08           C  
ATOM   1834  NE1 TRP A 209      55.741  48.048  17.338  1.00 18.20           N  
ATOM   1835  CE2 TRP A 209      54.432  47.711  17.565  1.00 17.22           C  
ATOM   1836  CE3 TRP A 209      53.020  45.741  17.364  1.00 15.96           C  
ATOM   1837  CZ2 TRP A 209      53.393  48.473  18.103  1.00 16.96           C  
ATOM   1838  CZ3 TRP A 209      51.968  46.519  17.854  1.00 15.89           C  
ATOM   1839  CH2 TRP A 209      52.172  47.874  18.254  1.00 18.27           C  
ATOM   1840  N   PRO A 210      58.415  43.247  14.823  1.00 19.75           N  
ATOM   1841  CA  PRO A 210      59.889  43.244  14.666  1.00 22.17           C  
ATOM   1842  C   PRO A 210      60.346  43.479  13.227  1.00 23.57           C  
ATOM   1843  O   PRO A 210      61.551  43.545  12.957  1.00 25.52           O  
ATOM   1844  CB  PRO A 210      60.282  41.819  15.115  1.00 24.36           C  
ATOM   1845  CG  PRO A 210      59.151  41.387  16.049  1.00 22.06           C  
ATOM   1846  CD  PRO A 210      57.924  41.918  15.264  1.00 19.70           C  
ATOM   1847  N   HIS A 211      59.386  43.592  12.317  1.00 22.26           N  
ATOM   1848  CA  HIS A 211      59.668  43.660  10.881  1.00 23.51           C  
ATOM   1849  C   HIS A 211      59.040  44.853  10.163  1.00 22.89           C  
ATOM   1850  O   HIS A 211      58.826  44.813   8.944  1.00 23.53           O  
ATOM   1851  CB  HIS A 211      59.173  42.359  10.222  1.00 23.05           C  
ATOM   1852  CG  HIS A 211      59.673  41.127  10.911  1.00 25.73           C  
ATOM   1853  ND1 HIS A 211      60.996  40.742  10.861  1.00 28.16           N  
ATOM   1854  CD2 HIS A 211      59.044  40.212  11.688  1.00 26.94           C  
ATOM   1855  CE1 HIS A 211      61.163  39.647  11.579  1.00 28.15           C  
ATOM   1856  NE2 HIS A 211      59.997  39.307  12.098  1.00 27.87           N  
ATOM   1857  N   LEU A 212      58.769  45.931  10.876  1.00 23.36           N  
ATOM   1858  CA  LEU A 212      58.059  47.046  10.242  1.00 23.95           C  
ATOM   1859  C   LEU A 212      58.838  47.719   9.108  1.00 26.52           C  
ATOM   1860  O   LEU A 212      58.239  48.420   8.316  1.00 27.82           O  
ATOM   1861  CB  LEU A 212      57.624  48.099  11.281  1.00 23.67           C  
ATOM   1862  CG  LEU A 212      56.647  47.566  12.332  1.00 20.46           C  
ATOM   1863  CD1 LEU A 212      56.500  48.526  13.515  1.00 23.40           C  
ATOM   1864  CD2 LEU A 212      55.264  47.268  11.693  1.00 21.73           C  
ATOM   1865  N   ASP A 213      60.155  47.520   9.046  0.50 27.78           N  
ATOM   1867  CA  ASP A 213      60.975  48.137   7.999  0.50 30.28           C  
ATOM   1869  C   ASP A 213      60.660  47.498   6.643  0.50 29.16           C  
ATOM   1871  O   ASP A 213      60.934  48.079   5.584  0.50 30.65           O  
ATOM   1873  CB  ASP A 213      62.473  48.032   8.328  0.50 32.64           C  
ATOM   1875  CG  ASP A 213      62.981  46.599   8.319  0.50 34.77           C  
ATOM   1877  OD1 ASP A 213      62.565  45.815   9.196  0.50 34.46           O  
ATOM   1879  OD2 ASP A 213      63.810  46.256   7.434  0.50 39.62           O  
ATOM   1881  N   ASP A 214      60.083  46.297   6.690  0.50 26.56           N  
ATOM   1883  CA  ASP A 214      59.619  45.606   5.484  0.50 26.17           C  
ATOM   1885  C   ASP A 214      58.671  44.455   5.831  0.50 24.51           C  
ATOM   1887  O   ASP A 214      59.082  43.335   6.189  0.50 23.69           O  
ATOM   1889  CB  ASP A 214      60.789  45.136   4.610  0.50 27.87           C  
ATOM   1891  CG  ASP A 214      60.340  44.488   3.300  0.50 26.56           C  
ATOM   1893  OD1 ASP A 214      59.143  44.529   2.946  0.50 21.49           O  
ATOM   1895  OD2 ASP A 214      61.222  43.956   2.599  0.50 27.56           O  
ATOM   1897  N   VAL A 215      57.389  44.782   5.706  1.00 24.42           N  
ATOM   1898  CA  VAL A 215      56.259  43.900   6.002  1.00 23.59           C  
ATOM   1899  C   VAL A 215      55.768  43.147   4.771  1.00 22.68           C  
ATOM   1900  O   VAL A 215      54.841  42.336   4.862  1.00 21.39           O  
ATOM   1901  CB  VAL A 215      55.068  44.650   6.687  1.00 23.01           C  
ATOM   1902  CG1 VAL A 215      55.512  45.266   8.000  1.00 24.31           C  
ATOM   1903  CG2 VAL A 215      54.470  45.693   5.757  1.00 22.87           C  
ATOM   1904  N   THR A 216      56.417  43.361   3.632  1.00 23.07           N  
ATOM   1905  CA  THR A 216      55.959  42.717   2.400  1.00 23.49           C  
ATOM   1906  C   THR A 216      55.830  41.163   2.449  1.00 21.89           C  
ATOM   1907  O   THR A 216      54.917  40.623   1.839  1.00 21.67           O  
ATOM   1908  CB  THR A 216      56.714  43.215   1.116  1.00 25.14           C  
ATOM   1909  OG1 THR A 216      58.071  42.790   1.145  1.00 27.80           O  
ATOM   1910  CG2 THR A 216      56.693  44.728   1.029  1.00 26.23           C  
ATOM   1911  N   PRO A 217      56.690  40.453   3.203  1.00 21.37           N  
ATOM   1912  CA  PRO A 217      56.484  39.010   3.398  1.00 21.70           C  
ATOM   1913  C   PRO A 217      55.147  38.581   3.980  1.00 20.37           C  
ATOM   1914  O   PRO A 217      54.760  37.396   3.835  1.00 19.86           O  
ATOM   1915  CB  PRO A 217      57.598  38.633   4.410  1.00 23.00           C  
ATOM   1916  CG  PRO A 217      58.695  39.622   4.101  1.00 24.88           C  
ATOM   1917  CD  PRO A 217      57.915  40.915   3.891  1.00 22.59           C  
ATOM   1918  N   PHE A 218      54.460  39.494   4.674  1.00 19.64           N  
ATOM   1919  CA  PHE A 218      53.247  39.137   5.418  1.00 19.28           C  
ATOM   1920  C   PHE A 218      51.982  39.481   4.630  1.00 18.47           C  
ATOM   1921  O   PHE A 218      50.878  39.229   5.113  1.00 18.20           O  
ATOM   1922  CB  PHE A 218      53.210  39.856   6.765  1.00 19.72           C  
ATOM   1923  CG  PHE A 218      54.367  39.506   7.641  1.00 21.16           C  
ATOM   1924  CD1 PHE A 218      54.425  38.275   8.278  1.00 23.04           C  
ATOM   1925  CD2 PHE A 218      55.421  40.384   7.797  1.00 20.09           C  
ATOM   1926  CE1 PHE A 218      55.513  37.938   9.065  1.00 23.95           C  
ATOM   1927  CE2 PHE A 218      56.516  40.048   8.590  1.00 24.23           C  
ATOM   1928  CZ  PHE A 218      56.562  38.825   9.218  1.00 25.36           C  
ATOM   1929  N   VAL A 219      52.145  40.037   3.425  1.00 17.29           N  
ATOM   1930  CA  VAL A 219      50.969  40.422   2.619  1.00 17.08           C  
ATOM   1931  C   VAL A 219      50.294  39.151   2.148  1.00 18.64           C  
ATOM   1932  O   VAL A 219      50.981  38.254   1.620  1.00 19.28           O  
ATOM   1933  CB  VAL A 219      51.359  41.293   1.414  1.00 17.19           C  
ATOM   1934  CG1 VAL A 219      50.113  41.511   0.485  1.00 17.92           C  
ATOM   1935  CG2 VAL A 219      51.929  42.647   1.899  1.00 16.64           C  
ATOM   1936  N   GLU A 220      48.967  39.086   2.276  1.00 16.76           N  
ATOM   1937  CA  GLU A 220      48.228  37.888   1.918  1.00 17.63           C  
ATOM   1938  C   GLU A 220      47.198  38.253   0.878  1.00 18.48           C  
ATOM   1939  O   GLU A 220      46.212  38.979   1.180  1.00 18.88           O  
ATOM   1940  CB  GLU A 220      47.478  37.357   3.132  1.00 17.03           C  
ATOM   1941  CG  GLU A 220      48.347  36.805   4.206  1.00 21.55           C  
ATOM   1942  CD  GLU A 220      47.486  36.252   5.343  1.00 22.80           C  
ATOM   1943  OE1 GLU A 220      46.866  37.060   6.025  1.00 19.64           O  
ATOM   1944  OE2 GLU A 220      47.364  35.008   5.486  1.00 26.08           O  
ATOM   1945  N   LEU A 221      47.415  37.761  -0.338  1.00 18.65           N  
ATOM   1946  CA  LEU A 221      46.435  37.933  -1.396  1.00 19.87           C  
ATOM   1947  C   LEU A 221      45.485  36.726  -1.381  1.00 19.89           C  
ATOM   1948  O   LEU A 221      45.802  35.667  -0.825  1.00 21.11           O  
ATOM   1949  CB  LEU A 221      47.155  38.082  -2.749  1.00 21.02           C  
ATOM   1950  CG  LEU A 221      48.164  39.240  -2.853  1.00 21.23           C  
ATOM   1951  CD1 LEU A 221      48.779  39.278  -4.286  1.00 25.97           C  
ATOM   1952  CD2 LEU A 221      47.545  40.608  -2.490  1.00 22.81           C  
ATOM   1953  N   HIS A 222      44.328  36.873  -2.011  1.00 20.21           N  
ATOM   1954  CA  HIS A 222      43.395  35.743  -2.101  1.00 20.09           C  
ATOM   1955  C   HIS A 222      43.061  35.093  -0.747  1.00 19.63           C  
ATOM   1956  O   HIS A 222      42.909  33.864  -0.672  1.00 19.60           O  
ATOM   1957  CB  HIS A 222      43.955  34.664  -3.033  1.00 21.54           C  
ATOM   1958  CG  HIS A 222      44.620  35.226  -4.244  1.00 24.90           C  
ATOM   1959  ND1 HIS A 222      43.906  35.801  -5.276  1.00 28.57           N  
ATOM   1960  CD2 HIS A 222      45.925  35.290  -4.597  1.00 26.66           C  
ATOM   1961  CE1 HIS A 222      44.756  36.218  -6.203  1.00 29.20           C  
ATOM   1962  NE2 HIS A 222      45.981  35.898  -5.823  1.00 27.33           N  
ATOM   1963  N   LYS A 223      42.908  35.914   0.288  1.00 17.04           N  
ATOM   1964  CA  LYS A 223      42.692  35.408   1.624  1.00 17.27           C  
ATOM   1965  C   LYS A 223      41.713  36.297   2.400  1.00 16.88           C  
ATOM   1966  O   LYS A 223      41.884  37.549   2.433  1.00 16.88           O  
ATOM   1967  CB  LYS A 223      44.039  35.418   2.378  1.00 17.51           C  
ATOM   1968  CG  LYS A 223      43.915  35.004   3.852  1.00 18.04           C  
ATOM   1969  CD  LYS A 223      43.610  33.556   3.966  1.00 22.27           C  
ATOM   1970  CE  LYS A 223      43.549  33.148   5.415  1.00 25.38           C  
ATOM   1971  NZ  LYS A 223      43.395  31.684   5.436  1.00 26.23           N  
ATOM   1972  N   ILE A 224      40.716  35.677   3.044  1.00 15.64           N  
ATOM   1973  CA  ILE A 224      39.856  36.446   3.958  1.00 15.46           C  
ATOM   1974  C   ILE A 224      39.836  35.641   5.243  1.00 16.57           C  
ATOM   1975  O   ILE A 224      39.389  34.475   5.240  1.00 18.09           O  
ATOM   1976  CB  ILE A 224      38.406  36.595   3.447  1.00 15.42           C  
ATOM   1977  CG1 ILE A 224      38.361  37.489   2.206  1.00 17.03           C  
ATOM   1978  CG2 ILE A 224      37.474  37.153   4.584  1.00 19.03           C  
ATOM   1979  CD1 ILE A 224      36.956  37.500   1.535  1.00 17.00           C  
ATOM   1980  N   HIS A 225      40.381  36.219   6.314  1.00 15.82           N  
ATOM   1981  CA  HIS A 225      40.286  35.624   7.627  1.00 17.34           C  
ATOM   1982  C   HIS A 225      38.900  35.765   8.216  1.00 18.39           C  
ATOM   1983  O   HIS A 225      38.360  36.848   8.292  1.00 20.17           O  
ATOM   1984  CB  HIS A 225      41.333  36.201   8.610  1.00 17.24           C  
ATOM   1985  CG  HIS A 225      42.765  35.975   8.199  1.00 16.30           C  
ATOM   1986  ND1 HIS A 225      43.514  34.905   8.646  1.00 19.63           N  
ATOM   1987  CD2 HIS A 225      43.605  36.729   7.442  1.00 16.99           C  
ATOM   1988  CE1 HIS A 225      44.737  34.976   8.142  1.00 19.71           C  
ATOM   1989  NE2 HIS A 225      44.818  36.078   7.409  1.00 18.32           N  
ATOM   1990  N   ARG A 226      38.330  34.654   8.666  1.00 18.84           N  
ATOM   1991  CA  ARG A 226      37.044  34.717   9.370  1.00 19.94           C  
ATOM   1992  C   ARG A 226      37.357  34.762  10.855  1.00 20.50           C  
ATOM   1993  O   ARG A 226      37.864  33.778  11.428  1.00 21.73           O  
ATOM   1994  CB  ARG A 226      36.187  33.485   9.034  1.00 21.25           C  
ATOM   1995  CG  ARG A 226      36.125  33.148   7.568  1.00 22.06           C  
ATOM   1996  CD  ARG A 226      35.324  34.121   6.732  1.00 20.81           C  
ATOM   1997  NE  ARG A 226      35.515  33.865   5.291  1.00 20.42           N  
ATOM   1998  CZ  ARG A 226      34.920  34.571   4.338  1.00 20.84           C  
ATOM   1999  NH1 ARG A 226      34.102  35.577   4.666  1.00 20.00           N  
ATOM   2000  NH2 ARG A 226      35.157  34.314   3.057  1.00 23.00           N  
ATOM   2001  N   VAL A 227      37.060  35.892  11.490  1.00 20.49           N  
ATOM   2002  CA  VAL A 227      37.411  36.091  12.899  1.00 21.25           C  
ATOM   2003  C   VAL A 227      36.218  36.383  13.788  1.00 23.84           C  
ATOM   2004  O   VAL A 227      35.050  36.392  13.320  1.00 23.53           O  
ATOM   2005  CB  VAL A 227      38.466  37.200  13.058  1.00 21.94           C  
ATOM   2006  CG1 VAL A 227      39.656  36.936  12.180  1.00 20.62           C  
ATOM   2007  CG2 VAL A 227      37.866  38.579  12.757  1.00 21.78           C  
ATOM   2008  OXT VAL A 227      36.404  36.649  15.002  1.00 24.29           O  
TER    2009      VAL A 227                                                      
END
MOLECULE T0513_1_11_87_283.pdb
ATOM      7  N   MET     1      40.511  38.696  30.932  1.00 34.21           N  
ATOM      8  CA  MET     1      40.458  39.135  29.549  1.00 22.06           C  
ATOM      9  C   MET     1      41.682  38.517  28.896  1.00 20.62           C  
ATOM     10  O   MET     1      42.651  38.176  29.595  1.00 20.32           O  
ATOM     11  CB  MET     1      40.508  40.662  29.493  1.00 26.67           C  
ATOM     12  CG  MET     1      39.316  41.294  30.229  1.00 26.17           C  
ATOM     15  N   SER     2      41.648  38.358  27.573  1.00 18.56           N  
ATOM     16  CA  SER     2      42.745  37.762  26.830  1.00 17.53           C  
ATOM     17  C   SER     2      42.560  38.118  25.378  1.00 19.94           C  
ATOM     18  O   SER     2      41.495  38.598  24.988  1.00 17.05           O  
ATOM     19  CB  SER     2      42.710  36.228  26.946  1.00 17.75           C  
ATOM     20  OG  SER     2      41.480  35.716  26.386  1.00 17.41           O  
ATOM     21  N   PHE     3      43.586  37.860  24.569  1.00 16.42           N  
ATOM     22  CA  PHE     3      43.459  38.022  23.110  1.00 16.19           C  
ATOM     23  C   PHE     3      42.307  37.173  22.593  1.00 21.25           C  
ATOM     24  O   PHE     3      41.461  37.650  21.819  1.00 19.18           O  
ATOM     25  CB  PHE     3      44.739  37.581  22.397  1.00 16.58           C  
ATOM     26  CG  PHE     3      45.941  38.449  22.661  1.00 15.61           C  
ATOM     27  CD1 PHE     3      45.828  39.838  22.823  1.00 13.92           C  
ATOM     28  CD2 PHE     3      47.208  37.862  22.709  1.00 20.52           C  
ATOM     29  CE1 PHE     3      46.981  40.625  23.045  1.00 17.47           C  
ATOM     30  CE2 PHE     3      48.343  38.632  22.922  1.00 19.74           C  
ATOM     31  CZ  PHE     3      48.236  40.011  23.095  1.00 20.60           C  
ATOM     32  N   LEU     4      42.276  35.914  23.034  1.00 17.01           N  
ATOM     33  CA  LEU     4      41.300  34.959  22.547  1.00 17.54           C  
ATOM     34  C   LEU     4      39.864  35.393  22.852  1.00 15.99           C  
ATOM     35  O   LEU     4      38.998  35.315  21.978  1.00 18.48           O  
ATOM     36  CB  LEU     4      41.598  33.535  23.044  1.00 18.74           C  
ATOM     37  CG  LEU     4      40.593  32.443  22.590  1.00 23.52           C  
ATOM     38  CD1 LEU     4      40.527  32.284  21.070  1.00 23.88           C  
ATOM     39  CD2 LEU     4      40.891  31.090  23.260  1.00 23.18           C  
ATOM     40  N   LYS     5      39.637  35.880  24.072  1.00 17.97           N  
ATOM     41  CA  LYS     5      38.295  36.329  24.470  1.00 16.32           C  
ATOM     42  C   LYS     5      37.818  37.464  23.559  1.00 17.11           C  
ATOM     43  O   LYS     5      36.660  37.464  23.200  1.00 17.21           O  
ATOM     44  CB  LYS     5      38.234  36.758  25.934  1.00 25.30           C  
ATOM     45  CG  LYS     5      36.789  36.876  26.476  1.00 32.59           C  
ATOM     46  CD  LYS     5      36.697  37.899  27.624  1.00 46.27           C  
ATOM     47  CE  LYS     5      35.251  38.200  28.091  1.00 40.02           C  
ATOM     48  NZ  LYS     5      34.171  38.126  27.026  1.00 37.12           N  
ATOM     49  N   HIS     6      38.696  38.404  23.186  1.00 16.06           N  
ATOM     50  CA  HIS     6      38.317  39.478  22.227  1.00 19.72           C  
ATOM     51  C   HIS     6      37.859  38.902  20.880  1.00 17.75           C  
ATOM     52  O   HIS     6      36.864  39.336  20.280  1.00 17.62           O  
ATOM     53  CB  HIS     6      39.490  40.435  21.971  1.00 17.88           C  
ATOM     54  CG  HIS     6      39.760  41.393  23.082  1.00 26.05           C  
ATOM     55  ND1 HIS     6      38.778  42.169  23.654  1.00 23.15           N  
ATOM     56  CD2 HIS     6      40.912  41.716  23.719  1.00 20.43           C  
ATOM     57  CE1 HIS     6      39.305  42.917  24.607  1.00 24.59           C  
ATOM     58  NE2 HIS     6      40.601  42.674  24.658  1.00 23.21           N  
ATOM     59  N   VAL     7      38.607  37.911  20.395  1.00 19.93           N  
ATOM     60  CA  VAL     7      38.322  37.270  19.129  1.00 15.58           C  
ATOM     61  C   VAL     7      36.992  36.526  19.218  1.00 20.03           C  
ATOM     62  O   VAL     7      36.166  36.642  18.319  1.00 17.61           O  
ATOM     63  CB  VAL     7      39.521  36.349  18.692  1.00 18.90           C  
ATOM     64  CG1 VAL     7      39.154  35.465  17.528  1.00 22.87           C  
ATOM     65  CG2 VAL     7      40.777  37.213  18.386  1.00 17.72           C  
ATOM     66  N   GLN     8      36.777  35.822  20.329  1.00 18.18           N  
ATOM     67  CA  GLN     8      35.531  35.100  20.579  1.00 15.33           C  
ATOM     68  C   GLN     8      34.323  36.036  20.681  1.00 17.02           C  
ATOM     69  O   GLN     8      33.252  35.717  20.142  1.00 23.55           O  
ATOM     70  CB  GLN     8      35.662  34.259  21.842  1.00 20.01           C  
ATOM     71  CG  GLN     8      36.479  32.991  21.588  1.00 19.14           C  
ATOM     72  CD  GLN     8      36.808  32.235  22.869  1.00 26.74           C  
ATOM     73  OE1 GLN     8      36.820  32.801  23.960  1.00 25.57           O  
ATOM     74  NE2 GLN     8      37.099  30.951  22.729  1.00 29.56           N  
ATOM     75  N   ASP     9      34.514  37.181  21.363  1.00 16.26           N  
ATOM     76  CA  ASP     9      33.480  38.214  21.515  1.00 17.99           C  
ATOM     77  C   ASP     9      33.012  38.673  20.127  1.00 17.79           C  
ATOM     78  O   ASP     9      31.805  38.752  19.866  1.00 15.63           O  
ATOM     79  CB  ASP     9      34.018  39.459  22.245  1.00 20.20           C  
ATOM     80  CG  ASP     9      34.205  39.262  23.755  1.00 21.46           C  
ATOM     81  OD1 ASP     9      33.680  38.295  24.334  1.00 22.14           O  
ATOM     82  OD2 ASP     9      34.896  40.116  24.337  1.00 25.62           O  
ATOM     83  N   CYS    10      33.972  38.942  19.230  1.00 13.03           N  
ATOM     84  CA  CYS    10      33.660  39.396  17.882  1.00 17.68           C  
ATOM     85  C   CYS    10      33.082  38.342  16.932  1.00 17.69           C  
ATOM     86  O   CYS    10      32.679  38.677  15.815  1.00 18.01           O  
ATOM     87  CB  CYS    10      34.881  40.047  17.257  1.00 20.69           C  
ATOM     88  SG  CYS    10      35.334  41.640  18.054  1.00 22.02           S  
ATOM     89  N   ASN    11      33.044  37.089  17.377  1.00 16.85           N  
ATOM     90  CA  ASN    11      32.489  36.005  16.585  1.00 16.00           C  
ATOM     91  C   ASN    11      31.330  35.320  17.254  1.00 21.69           C  
ATOM     92  O   ASN    11      30.958  34.203  16.885  1.00 21.64           O  
ATOM     93  CB  ASN    11      33.593  35.035  16.168  1.00 18.19           C  
ATOM     94  CG  ASN    11      34.453  35.616  15.082  1.00 21.69           C  
ATOM     95  OD1 ASN    11      33.977  35.828  13.968  1.00 20.16           O  
ATOM     96  ND2 ASN    11      35.712  35.932  15.408  1.00 25.35           N  
ATOM    704  N   GLY    87      22.335  58.715   5.514  1.00 25.39           N  
ATOM    705  CA  GLY    87      22.831  59.252   4.250  1.00 24.83           C  
ATOM    706  C   GLY    87      24.088  58.667   3.650  1.00 25.87           C  
ATOM    707  O   GLY    87      24.394  58.938   2.496  1.00 27.78           O  
ATOM    708  N   GLU    88      24.826  57.861   4.409  1.00 22.13           N  
ATOM    709  CA  GLU    88      25.998  57.160   3.861  1.00 22.36           C  
ATOM    710  C   GLU    88      25.582  55.816   3.295  1.00 23.51           C  
ATOM    711  O   GLU    88      25.054  54.989   4.020  1.00 19.80           O  
ATOM    712  CB  GLU    88      27.074  56.962   4.933  1.00 21.74           C  
ATOM    713  CG  GLU    88      28.275  56.190   4.365  1.00 22.96           C  
ATOM    714  CD  GLU    88      29.489  56.189   5.269  1.00 29.30           C  
ATOM    715  OE1 GLU    88      29.367  56.503   6.472  1.00 33.52           O  
ATOM    716  OE2 GLU    88      30.570  55.860   4.759  1.00 24.96           O  
ATOM    717  N   LEU    89      25.810  55.583   2.004  1.00 20.88           N  
ATOM    718  CA  LEU    89      25.365  54.333   1.387  1.00 21.09           C  
ATOM    719  C   LEU    89      26.512  53.320   1.330  1.00 18.78           C  
ATOM    720  O   LEU    89      27.654  53.675   1.020  1.00 23.48           O  
ATOM    721  CB  LEU    89      24.801  54.587  -0.030  1.00 24.83           C  
ATOM    722  CG  LEU    89      23.590  55.510  -0.163  1.00 24.17           C  
ATOM    723  CD1 LEU    89      23.159  55.634  -1.627  1.00 26.09           C  
ATOM    724  CD2 LEU    89      22.440  55.047   0.719  1.00 26.85           C  
ATOM    725  N   TYR    90      26.193  52.062   1.617  1.00 16.23           N  
ATOM    726  CA  TYR    90      27.161  50.972   1.554  1.00 16.87           C  
ATOM    727  C   TYR    90      26.790  50.018   0.421  1.00 21.89           C  
ATOM    728  O   TYR    90      25.612  49.841   0.095  1.00 21.37           O  
ATOM    729  CB  TYR    90      27.108  50.166   2.857  1.00 19.18           C  
ATOM    730  CG  TYR    90      27.980  50.636   4.014  1.00 19.39           C  
ATOM    731  CD1 TYR    90      28.586  51.896   4.022  1.00 22.76           C  
ATOM    732  CD2 TYR    90      28.157  49.810   5.129  1.00 17.63           C  
ATOM    733  CE1 TYR    90      29.384  52.298   5.104  1.00 23.15           C  
ATOM    734  CE2 TYR    90      28.930  50.204   6.222  1.00 16.30           C  
ATOM    735  CZ  TYR    90      29.555  51.449   6.190  1.00 20.05           C  
ATOM    736  OH  TYR    90      30.322  51.863   7.267  1.00 20.00           O  
ATOM    737  N   ARG    91      27.794  49.363  -0.136  1.00 20.63           N  
ATOM    738  CA  ARG    91      27.555  48.370  -1.175  1.00 19.85           C  
ATOM    739  C   ARG    91      27.051  47.062  -0.576  1.00 20.29           C  
ATOM    740  O   ARG    91      27.473  46.654   0.518  1.00 19.32           O  
ATOM    741  CB  ARG    91      28.840  48.157  -2.011  1.00 19.59           C  
ATOM    742  CG  ARG    91      29.881  47.303  -1.337  1.00 26.33           C  
ATOM    743  CD  ARG    91      31.225  47.506  -1.966  1.00 24.05           C  
ATOM    744  NE  ARG    91      31.794  48.821  -1.681  1.00 21.42           N  
ATOM    745  CZ  ARG    91      32.772  49.356  -2.401  1.00 28.61           C  
ATOM    746  NH1 ARG    91      33.284  48.673  -3.417  1.00 23.53           N  
ATOM    747  NH2 ARG    91      33.260  50.541  -2.095  1.00 22.18           N  
ATOM    748  N   VAL    92      26.123  46.418  -1.279  1.00 18.57           N  
ATOM    749  CA  VAL    92      25.629  45.105  -0.875  1.00 16.93           C  
ATOM    750  C   VAL    92      26.147  44.058  -1.867  1.00 21.31           C  
ATOM    751  O   VAL    92      25.839  44.127  -3.082  1.00 19.91           O  
ATOM    752  CB  VAL    92      24.077  45.066  -0.843  1.00 19.63           C  
ATOM    753  CG1 VAL    92      23.561  43.626  -0.553  1.00 18.79           C  
ATOM    754  CG2 VAL    92      23.540  46.091   0.161  1.00 19.26           C  
ATOM    755  N   ASN    93      26.930  43.104  -1.352  1.00 18.20           N  
ATOM    756  CA  ASN    93      27.505  42.038  -2.178  1.00 21.74           C  
ATOM    757  C   ASN    93      27.698  40.762  -1.358  1.00 24.96           C  
ATOM    758  O   ASN    93      27.499  40.746  -0.136  1.00 22.57           O  
ATOM    759  CB  ASN    93      28.859  42.491  -2.788  1.00 18.95           C  
ATOM    760  CG  ASN    93      29.874  42.903  -1.719  1.00 18.59           C  
ATOM    761  OD1 ASN    93      29.937  42.301  -0.661  1.00 24.48           O  
ATOM    762  ND2 ASN    93      30.678  43.942  -2.005  1.00 22.24           N  
ATOM    763  N   GLN    94      28.152  39.704  -2.018  1.00 26.36           N  
ATOM    764  CA  GLN    94      28.433  38.446  -1.340  1.00 26.49           C  
ATOM    765  C   GLN    94      29.823  38.381  -0.751  1.00 30.49           C  
ATOM    766  O   GLN    94      30.080  37.583   0.146  1.00 36.86           O  
ATOM    767  CB  GLN    94      28.266  37.286  -2.304  1.00 37.10           C  
ATOM    768  CG  GLN    94      26.932  36.636  -2.224  1.00 37.93           C  
ATOM    769  CD  GLN    94      26.869  35.435  -3.124  1.00 49.22           C  
ATOM    770  OE1 GLN    94      27.271  35.502  -4.289  1.00 48.89           O  
ATOM    771  NE2 GLN    94      26.362  34.325  -2.598  1.00 50.15           N  
ATOM    772  N   SER    95      30.722  39.175  -1.320  1.00 27.55           N  
ATOM    773  CA  SER    95      32.069  39.392  -0.824  1.00 28.80           C  
ATOM    774  C   SER    95      32.682  40.521  -1.622  1.00 22.53           C  
ATOM    775  O   SER    95      32.128  40.970  -2.634  1.00 27.82           O  
ATOM    776  CB  SER    95      32.951  38.132  -0.907  1.00 35.68           C  
ATOM    777  OG  SER    95      32.898  37.568  -2.200  1.00 45.01           O  
ATOM    778  N   TRP    96      33.826  40.973  -1.150  1.00 24.95           N  
ATOM    779  CA  TRP    96      34.436  42.202  -1.609  1.00 25.45           C  
ATOM    780  C   TRP    96      34.681  42.248  -3.134  1.00 31.67           C  
ATOM    781  O   TRP    96      34.439  43.261  -3.783  1.00 27.35           O  
ATOM    782  CB  TRP    96      35.741  42.422  -0.848  1.00 22.30           C  
ATOM    783  CG  TRP    96      36.462  43.612  -1.369  1.00 24.98           C  
ATOM    784  CD1 TRP    96      37.632  43.618  -2.096  1.00 26.49           C  
ATOM    785  CD2 TRP    96      36.055  44.983  -1.250  1.00 26.86           C  
ATOM    786  NE1 TRP    96      37.962  44.903  -2.437  1.00 27.97           N  
ATOM    787  CE2 TRP    96      37.019  45.764  -1.932  1.00 21.43           C  
ATOM    788  CE3 TRP    96      34.974  45.630  -0.629  1.00 26.25           C  
ATOM    789  CZ2 TRP    96      36.931  47.158  -2.015  1.00 27.21           C  
ATOM    790  CZ3 TRP    96      34.891  47.010  -0.708  1.00 24.31           C  
ATOM    791  CH2 TRP    96      35.870  47.765  -1.392  1.00 26.46           C  
ATOM    792  N   GLY    97      35.167  41.155  -3.704  1.00 34.73           N  
ATOM    793  CA  GLY    97      35.381  41.134  -5.170  1.00 43.04           C  
ATOM    794  C   GLY    97      34.138  41.139  -6.057  1.00 39.97           C  
ATOM    795  O   GLY    97      34.185  41.591  -7.209  1.00 39.72           O  
ATOM    796  N   GLU    98      33.033  40.651  -5.503  1.00 32.97           N  
ATOM    797  CA  GLU    98      31.804  40.317  -6.230  1.00 27.55           C  
ATOM    798  C   GLU    98      31.010  41.563  -6.666  1.00 28.91           C  
ATOM    799  O   GLU    98      31.254  42.659  -6.156  1.00 28.40           O  
ATOM    800  CB  GLU    98      30.957  39.401  -5.344  1.00 31.83           C  
ATOM    801  CG  GLU    98      31.496  37.987  -5.178  1.00 44.11           C  
ATOM    802  CD  GLU    98      31.337  37.164  -6.427  1.00 58.39           C  
ATOM    803  OE1 GLU    98      32.363  36.906  -7.087  1.00 64.85           O  
ATOM    804  OE2 GLU    98      30.189  36.793  -6.761  1.00 62.34           O  
ATOM    805  N   PRO    99      30.088  41.417  -7.650  1.00 29.23           N  
ATOM    806  CA  PRO    99      29.327  42.602  -8.113  1.00 31.34           C  
ATOM    807  C   PRO    99      28.456  43.270  -7.032  1.00 22.94           C  
ATOM    808  O   PRO    99      27.910  42.597  -6.172  1.00 22.94           O  
ATOM    809  CB  PRO    99      28.421  42.028  -9.225  1.00 30.62           C  
ATOM    810  CG  PRO    99      29.121  40.763  -9.672  1.00 34.18           C  
ATOM    811  CD  PRO    99      29.736  40.207  -8.431  1.00 34.24           C  
ATOM    812  N   THR   100      28.385  44.577  -7.048  1.00 21.61           N  
ATOM    813  CA  THR   100      27.472  45.266  -6.184  1.00 22.07           C  
ATOM    814  C   THR   100      26.055  45.017  -6.668  1.00 23.86           C  
ATOM    815  O   THR   100      25.724  45.353  -7.758  1.00 27.37           O  
ATOM    816  CB  THR   100      27.794  46.753  -6.127  1.00 25.42           C  
ATOM    817  OG1 THR   100      29.070  46.950  -5.547  1.00 25.25           O  
ATOM    818  CG2 THR   100      26.768  47.493  -5.390  1.00 21.58           C  
ATOM    819  N   LEU   101      25.252  44.413  -5.827  1.00 22.26           N  
ATOM    820  CA  LEU   101      23.902  44.054  -6.147  1.00 22.54           C  
ATOM    821  C   LEU   101      22.868  45.162  -5.909  1.00 26.84           C  
ATOM    822  O   LEU   101      21.835  45.169  -6.511  1.00 22.64           O  
ATOM    823  CB  LEU   101      23.512  42.785  -5.421  1.00 23.42           C  
ATOM    824  CG  LEU   101      24.336  41.556  -5.780  1.00 23.60           C  
ATOM    825  CD1 LEU   101      24.021  40.422  -4.914  1.00 24.49           C  
ATOM    826  CD2 LEU   101      24.104  41.185  -7.208  1.00 23.72           C  
ATOM    827  N   MET   102      23.182  46.045  -4.985  1.00 22.55           N  
ATOM    828  CA  MET   102      22.371  47.178  -4.624  1.00 21.19           C  
ATOM    829  C   MET   102      23.150  47.968  -3.581  1.00 23.28           C  
ATOM    830  O   MET   102      24.171  47.532  -3.145  1.00 19.55           O  
ATOM    831  CB  MET   102      21.053  46.709  -4.017  1.00 19.31           C  
ATOM    832  CG  MET   102      21.164  45.928  -2.733  1.00 21.18           C  
ATOM    833  SD  MET   102      19.405  45.525  -1.916  0.70 23.50          SE  
ATOM    834  CE  MET   102      19.035  47.338  -1.459  1.00 18.91           C  
ATOM    835  N   LEU   103      22.596  49.100  -3.191  1.00 18.82           N  
ATOM    836  CA  LEU   103      23.106  49.922  -2.110  1.00 19.48           C  
ATOM    837  C   LEU   103      22.134  50.000  -0.941  1.00 20.90           C  
ATOM    838  O   LEU   103      20.948  49.907  -1.109  1.00 20.47           O  
ATOM    839  CB  LEU   103      23.457  51.333  -2.574  1.00 19.25           C  
ATOM    840  CG  LEU   103      24.264  51.497  -3.846  1.00 25.37           C  
ATOM    841  CD1 LEU   103      24.555  52.930  -4.178  1.00 22.48           C  
ATOM    842  CD2 LEU   103      25.523  50.763  -3.726  1.00 16.64           C  
ATOM    843  N   LEU   104      22.687  50.192   0.242  1.00 19.74           N  
ATOM    844  CA  LEU   104      21.923  50.226   1.458  1.00 21.14           C  
ATOM    845  C   LEU   104      22.505  51.224   2.435  1.00 24.21           C  
ATOM    846  O   LEU   104      23.680  51.307   2.604  1.00 20.89           O  
ATOM    847  CB  LEU   104      21.901  48.860   2.084  1.00 23.77           C  
ATOM    848  CG  LEU   104      20.943  48.484   3.187  1.00 22.11           C  
ATOM    849  CD1 LEU   104      19.549  48.698   2.787  1.00 21.93           C  
ATOM    850  CD2 LEU   104      21.194  47.061   3.593  1.00 18.00           C  
ATOM    851  N   ASP   105      21.646  52.004   3.040  1.00 23.13           N  
ATOM    852  CA  ASP   105      22.136  52.996   3.987  1.00 19.41           C  
ATOM    853  C   ASP   105      22.867  52.277   5.131  1.00 15.14           C  
ATOM    854  O   ASP   105      22.375  51.291   5.654  1.00 18.33           O  
ATOM    855  CB  ASP   105      20.977  53.801   4.552  1.00 20.99           C  
ATOM    856  CG  ASP   105      21.447  55.029   5.285  1.00 20.36           C  
ATOM    857  OD1 ASP   105      21.842  54.928   6.470  1.00 21.30           O  
ATOM    858  OD2 ASP   105      21.476  56.107   4.673  1.00 21.56           O  
ATOM    859  N   ARG   106      24.040  52.796   5.477  1.00 21.02           N  
ATOM    860  CA  ARG   106      24.899  52.258   6.546  1.00 18.68           C  
ATOM    861  C   ARG   106      24.099  51.988   7.824  1.00 22.99           C  
ATOM    862  O   ARG   106      24.278  50.952   8.482  1.00 19.07           O  
ATOM    863  CB  ARG   106      26.026  53.245   6.801  1.00 20.67           C  
ATOM    864  CG  ARG   106      26.860  52.965   8.042  1.00 26.03           C  
ATOM    865  CD  ARG   106      27.944  54.002   8.188  1.00 21.79           C  
ATOM    866  NE  ARG   106      28.772  53.685   9.350  1.00 28.51           N  
ATOM    867  CZ  ARG   106      29.995  54.161   9.567  1.00 36.58           C  
ATOM    868  NH1 ARG   106      30.556  55.013   8.713  1.00 24.41           N  
ATOM    869  NH2 ARG   106      30.663  53.784  10.651  1.00 37.44           N  
ATOM    870  N   ALA   107      23.138  52.862   8.127  1.00 16.60           N  
ATOM    871  CA  ALA   107      22.420  52.758   9.398  1.00 22.69           C  
ATOM    872  C   ALA   107      21.586  51.489   9.530  1.00 19.03           C  
ATOM    873  O   ALA   107      21.297  51.057  10.637  1.00 21.36           O  
ATOM    874  CB  ALA   107      21.549  53.986   9.636  1.00 23.29           C  
ATOM    875  N   VAL   108      21.235  50.881   8.402  1.00 17.20           N  
ATOM    876  CA  VAL   108      20.418  49.676   8.404  1.00 17.43           C  
ATOM    877  C   VAL   108      21.193  48.455   7.914  1.00 21.77           C  
ATOM    878  O   VAL   108      20.631  47.379   7.750  1.00 19.19           O  
ATOM    879  CB  VAL   108      19.055  49.853   7.627  1.00 21.96           C  
ATOM    880  CG1 VAL   108      18.186  50.936   8.289  1.00 20.29           C  
ATOM    881  CG2 VAL   108      19.268  50.173   6.131  1.00 19.03           C  
ATOM    882  N   VAL   109      22.492  48.618   7.699  1.00 19.07           N  
ATOM    883  CA  VAL   109      23.306  47.473   7.234  1.00 17.15           C  
ATOM    884  C   VAL   109      23.208  46.292   8.255  1.00 15.02           C  
ATOM    885  O   VAL   109      22.810  45.158   7.867  1.00 17.93           O  
ATOM    886  CB  VAL   109      24.732  47.951   6.781  1.00 19.33           C  
ATOM    887  CG1 VAL   109      25.788  46.856   6.910  1.00 17.69           C  
ATOM    888  CG2 VAL   109      24.659  48.517   5.317  1.00 18.99           C  
ATOM    889  N   PRO   110      23.436  46.541   9.582  1.00 17.55           N  
ATOM    890  CA  PRO   110      23.209  45.433  10.540  1.00 18.17           C  
ATOM    891  C   PRO   110      21.767  44.902  10.631  1.00 17.33           C  
ATOM    892  O   PRO   110      21.566  43.727  10.878  1.00 18.00           O  
ATOM    893  CB  PRO   110      23.693  46.011  11.877  1.00 18.05           C  
ATOM    894  CG  PRO   110      24.670  47.112  11.485  1.00 20.81           C  
ATOM    895  CD  PRO   110      23.988  47.725  10.264  1.00 16.19           C  
ATOM    896  N   THR   111      20.779  45.761  10.386  1.00 17.33           N  
ATOM    897  CA  THR   111      19.362  45.360  10.360  1.00 18.97           C  
ATOM    898  C   THR   111      19.067  44.300   9.285  1.00 19.99           C  
ATOM    899  O   THR   111      18.183  43.453   9.462  1.00 20.53           O  
ATOM    900  CB  THR   111      18.509  46.609  10.107  1.00 21.00           C  
ATOM    901  OG1 THR   111      18.776  47.555  11.154  1.00 23.41           O  
ATOM    902  CG2 THR   111      17.008  46.263  10.007  1.00 17.86           C  
ATOM    903  N   PHE   112      19.787  44.369   8.160  1.00 16.89           N  
ATOM    904  CA  PHE   112      19.636  43.371   7.109  1.00 17.37           C  
ATOM    905  C   PHE   112      20.737  42.314   7.152  1.00 18.91           C  
ATOM    906  O   PHE   112      20.770  41.443   6.284  1.00 19.04           O  
ATOM    907  CB  PHE   112      19.554  44.029   5.725  1.00 21.08           C  
ATOM    908  CG  PHE   112      18.251  44.732   5.507  1.00 21.38           C  
ATOM    909  CD1 PHE   112      17.161  44.054   4.924  1.00 21.83           C  
ATOM    910  CD2 PHE   112      18.069  46.030   5.976  1.00 21.21           C  
ATOM    911  CE1 PHE   112      15.922  44.701   4.770  1.00 23.45           C  
ATOM    912  CE2 PHE   112      16.824  46.676   5.822  1.00 26.65           C  
ATOM    913  CZ  PHE   112      15.772  46.010   5.224  1.00 23.26           C  
ATOM    914  N   GLY   113      21.619  42.408   8.160  1.00 17.00           N  
ATOM    915  CA  GLY   113      22.760  41.450   8.343  1.00 19.86           C  
ATOM    916  C   GLY   113      23.708  41.372   7.156  1.00 19.08           C  
ATOM    917  O   GLY   113      24.320  40.316   6.875  1.00 17.65           O  
ATOM    918  N   VAL   114      23.822  42.488   6.453  1.00 16.66           N  
ATOM    919  CA  VAL   114      24.617  42.622   5.241  1.00 20.98           C  
ATOM    920  C   VAL   114      26.109  42.813   5.587  1.00 14.90           C  
ATOM    921  O   VAL   114      26.453  43.461   6.583  1.00 17.95           O  
ATOM    922  CB  VAL   114      24.061  43.812   4.391  1.00 22.54           C  
ATOM    923  CG1 VAL   114      25.108  44.402   3.471  1.00 26.90           C  
ATOM    924  CG2 VAL   114      22.800  43.348   3.641  1.00 20.80           C  
ATOM    925  N   ARG   115      26.992  42.207   4.798  1.00 18.90           N  
ATOM    926  CA  ARG   115      28.424  42.369   5.025  0.50 18.89           C  
ATOM    928  C   ARG   115      28.865  43.824   4.888  1.00 20.95           C  
ATOM    929  O   ARG   115      28.477  44.509   3.934  1.00 21.03           O  
ATOM    930  CB  ARG   115      29.202  41.456   4.089  0.50 25.76           C  
ATOM    932  CG  ARG   115      28.836  39.990   4.312  0.50 30.32           C  
ATOM    934  CD  ARG   115      29.435  39.054   3.279  0.50 39.53           C  
ATOM    936  NE  ARG   115      30.793  39.438   2.908  0.50 40.24           N  
ATOM    938  CZ  ARG   115      31.874  39.233   3.650  0.50 35.64           C  
ATOM    940  NH1 ARG   115      33.037  39.641   3.194  0.50 37.10           N  
ATOM    942  NH2 ARG   115      31.801  38.652   4.846  0.50 44.23           N  
ATOM    944  N   ALA   116      29.631  44.298   5.874  1.00 15.80           N  
ATOM    945  CA  ALA   116      30.150  45.685   5.878  1.00 23.26           C  
ATOM    946  C   ALA   116      31.663  45.682   5.736  1.00 22.47           C  
ATOM    947  O   ALA   116      32.346  44.741   6.166  1.00 22.50           O  
ATOM    948  CB  ALA   116      29.767  46.415   7.151  1.00 18.37           C  
ATOM    949  N   TYR   117      32.186  46.762   5.178  1.00 16.80           N  
ATOM    950  CA  TYR   117      33.643  46.870   4.922  1.00 16.57           C  
ATOM    951  C   TYR   117      34.160  48.128   5.558  1.00 19.40           C  
ATOM    952  O   TYR   117      33.404  49.096   5.756  1.00 17.01           O  
ATOM    953  CB  TYR   117      33.920  46.873   3.397  1.00 17.31           C  
ATOM    954  CG  TYR   117      33.361  45.617   2.746  1.00 19.59           C  
ATOM    955  CD1 TYR   117      34.018  44.399   2.876  1.00 20.47           C  
ATOM    956  CD2 TYR   117      32.124  45.637   2.084  1.00 20.52           C  
ATOM    957  CE1 TYR   117      33.501  43.243   2.328  1.00 17.56           C  
ATOM    958  CE2 TYR   117      31.601  44.488   1.515  1.00 22.34           C  
ATOM    959  CZ  TYR   117      32.279  43.295   1.653  1.00 22.06           C  
ATOM    960  OH  TYR   117      31.744  42.169   1.124  1.00 21.87           O  
ATOM    961  N   GLY   118      35.448  48.143   5.874  1.00 19.03           N  
ATOM    962  CA  GLY   118      36.030  49.316   6.478  1.00 19.24           C  
ATOM    963  C   GLY   118      37.527  49.267   6.295  1.00 16.72           C  
ATOM    964  O   GLY   118      38.090  48.234   5.913  1.00 20.13           O  
ATOM    965  N   VAL   119      38.164  50.403   6.517  1.00 16.32           N  
ATOM    966  CA  VAL   119      39.604  50.494   6.412  1.00 15.00           C  
ATOM    967  C   VAL   119      40.169  50.936   7.753  1.00 22.40           C  
ATOM    968  O   VAL   119      39.583  51.799   8.435  1.00 22.82           O  
ATOM    969  CB  VAL   119      40.100  51.440   5.249  1.00 22.27           C  
ATOM    970  CG1 VAL   119      39.592  50.948   3.891  1.00 19.88           C  
ATOM    971  CG2 VAL   119      39.690  52.898   5.489  1.00 22.21           C  
ATOM    972  N   HIS   120      41.285  50.311   8.137  1.00 18.08           N  
ATOM    973  CA  HIS   120      41.968  50.589   9.417  1.00 19.70           C  
ATOM    974  C   HIS   120      43.453  50.730   9.187  1.00 21.42           C  
ATOM    975  O   HIS   120      44.094  49.860   8.570  1.00 20.16           O  
ATOM    976  CB  HIS   120      41.709  49.468  10.444  1.00 18.67           C  
ATOM    977  CG  HIS   120      40.288  49.423  10.918  1.00 20.33           C  
ATOM    978  ND1 HIS   120      39.921  49.778  12.195  1.00 18.82           N  
ATOM    979  CD2 HIS   120      39.142  49.097  10.276  1.00 22.07           C  
ATOM    980  CE1 HIS   120      38.609  49.662  12.326  1.00 20.40           C  
ATOM    981  NE2 HIS   120      38.114  49.271  11.167  1.00 21.07           N  
ATOM    982  N   LEU   121      43.992  51.845   9.667  1.00 17.73           N  
ATOM    983  CA  LEU   121      45.391  52.168   9.486  1.00 19.07           C  
ATOM    984  C   LEU   121      46.194  52.043  10.780  1.00 17.80           C  
ATOM    985  O   LEU   121      45.801  52.603  11.817  1.00 19.58           O  
ATOM    986  CB  LEU   121      45.541  53.594   8.939  1.00 16.96           C  
ATOM    987  CG  LEU   121      46.996  54.056   8.719  1.00 19.89           C  
ATOM    988  CD1 LEU   121      47.636  53.390   7.537  1.00 22.06           C  
ATOM    989  CD2 LEU   121      47.033  55.582   8.509  1.00 22.75           C  
ATOM    990  N   ASN   122      47.303  51.298  10.705  1.00 19.55           N  
ATOM    991  CA  ASN   122      48.301  51.221  11.781  1.00 21.15           C  
ATOM    992  C   ASN   122      49.405  52.240  11.517  1.00 19.94           C  
ATOM    993  O   ASN   122      50.271  52.018  10.667  1.00 21.83           O  
ATOM    994  CB  ASN   122      48.888  49.806  11.905  1.00 17.68           C  
ATOM    995  CG  ASN   122      47.824  48.744  12.154  1.00 26.32           C  
ATOM    996  OD1 ASN   122      47.116  48.776  13.163  1.00 22.92           O  
ATOM    997  ND2 ASN   122      47.707  47.804  11.238  1.00 18.70           N  
ATOM    998  N   GLY   123      49.334  53.381  12.208  1.00 20.19           N  
ATOM    999  CA  GLY   123      50.345  54.440  12.079  1.00 18.15           C  
ATOM   1000  C   GLY   123      51.381  54.310  13.171  1.00 21.64           C  
ATOM   1001  O   GLY   123      51.065  54.442  14.366  1.00 22.55           O  
ATOM   1002  N   TYR   124      52.620  54.067  12.763  1.00 22.90           N  
ATOM   1003  CA  TYR   124      53.694  53.774  13.698  1.00 25.90           C  
ATOM   1004  C   TYR   124      55.020  54.490  13.366  1.00 25.41           C  
ATOM   1005  O   TYR   124      55.209  54.987  12.233  1.00 23.58           O  
ATOM   1006  CB  TYR   124      53.884  52.237  13.832  1.00 21.31           C  
ATOM   1007  CG  TYR   124      54.369  51.536  12.592  1.00 27.55           C  
ATOM   1008  CD1 TYR   124      55.728  51.400  12.332  1.00 30.72           C  
ATOM   1009  CD2 TYR   124      53.469  50.982  11.680  1.00 27.78           C  
ATOM   1010  CE1 TYR   124      56.182  50.760  11.192  1.00 31.47           C  
ATOM   1011  CE2 TYR   124      53.919  50.339  10.543  1.00 30.81           C  
ATOM   1012  CZ  TYR   124      55.265  50.228  10.304  1.00 31.70           C  
ATOM   1013  OH  TYR   124      55.719  49.579   9.177  1.00 42.11           O  
ATOM   1014  N   VAL   125      55.895  54.566  14.384  1.00 29.81           N  
ATOM   1015  CA  VAL   125      57.235  55.137  14.244  0.50 32.58           C  
ATOM   1017  C   VAL   125      58.246  54.234  14.931  1.00 34.47           C  
ATOM   1018  O   VAL   125      57.929  53.543  15.901  1.00 36.28           O  
ATOM   1019  CB  VAL   125      57.365  56.610  14.786  0.50 31.90           C  
ATOM   1021  CG1 VAL   125      56.598  57.581  13.923  0.50 28.83           C  
ATOM   1023  CG2 VAL   125      56.931  56.736  16.248  0.50 25.63           C  
ATOM   1025  N   GLY   126      59.472  54.206  14.407  1.00 37.83           N  
ATOM   1026  CA  GLY   126      60.529  53.399  15.017  1.00 35.15           C  
ATOM   1027  C   GLY   126      60.513  51.960  14.553  1.00 37.66           C  
ATOM   1028  O   GLY   126      59.729  51.601  13.680  1.00 38.85           O  
ATOM   1029  N   ALA   127      61.400  51.144  15.123  1.00 41.73           N  
ATOM   1030  CA  ALA   127      61.486  49.714  14.808  1.00 44.35           C  
ATOM   1031  C   ALA   127      61.973  48.958  16.031  1.00 47.23           C  
ATOM   1032  O   ALA   127      62.529  49.566  16.954  1.00 46.60           O  
ATOM   1033  CB  ALA   127      62.415  49.466  13.622  1.00 46.56           C  
ATOM   1034  N   GLY   128      61.751  47.644  16.037  1.00 47.40           N  
ATOM   1035  CA  GLY   128      62.218  46.768  17.107  1.00 50.12           C  
ATOM   1036  C   GLY   128      61.766  47.220  18.479  1.00 51.85           C  
ATOM   1037  O   GLY   128      60.591  47.487  18.685  1.00 49.32           O  
ATOM   1038  N   ALA   129      62.719  47.366  19.398  1.00 53.70           N  
ATOM   1039  CA  ALA   129      62.427  47.766  20.776  1.00 52.09           C  
ATOM   1040  C   ALA   129      61.864  49.189  20.926  1.00 49.76           C  
ATOM   1041  O   ALA   129      61.302  49.525  21.971  1.00 51.31           O  
ATOM   1042  CB  ALA   129      63.673  47.580  21.661  1.00 58.37           C  
ATOM   1043  N   ASP   130      61.988  50.006  19.878  1.00 42.21           N  
ATOM   1044  CA  ASP   130      61.566  51.406  19.908  0.50 41.80           C  
ATOM   1046  C   ASP   130      60.292  51.658  19.075  1.00 36.31           C  
ATOM   1047  O   ASP   130      59.968  52.791  18.752  1.00 38.36           O  
ATOM   1048  CB  ASP   130      62.718  52.293  19.417  0.50 40.53           C  
ATOM   1050  CG  ASP   130      64.080  51.814  19.913  0.50 50.35           C  
ATOM   1052  OD1 ASP   130      64.218  51.549  21.128  0.50 52.59           O  
ATOM   1054  OD2 ASP   130      65.011  51.699  19.084  0.50 53.48           O  
ATOM   1056  N   LEU   131      59.587  50.592  18.717  1.00 34.21           N  
ATOM   1057  CA  LEU   131      58.357  50.692  17.930  1.00 32.36           C  
ATOM   1058  C   LEU   131      57.231  51.347  18.729  1.00 29.17           C  
ATOM   1059  O   LEU   131      56.875  50.888  19.824  1.00 31.74           O  
ATOM   1060  CB  LEU   131      57.936  49.290  17.504  1.00 33.48           C  
ATOM   1061  CG  LEU   131      56.788  49.115  16.520  1.00 38.03           C  
ATOM   1062  CD1 LEU   131      57.146  49.674  15.163  1.00 38.14           C  
ATOM   1063  CD2 LEU   131      56.476  47.633  16.402  1.00 34.66           C  
ATOM   1064  N   HIS   132      56.697  52.440  18.189  1.00 27.61           N  
ATOM   1065  CA  HIS   132      55.625  53.187  18.816  1.00 23.90           C  
ATOM   1066  C   HIS   132      54.403  53.300  17.890  1.00 24.13           C  
ATOM   1067  O   HIS   132      54.568  53.508  16.702  1.00 28.10           O  
ATOM   1068  CB  HIS   132      56.104  54.594  19.205  1.00 25.85           C  
ATOM   1069  CG  HIS   132      57.031  54.617  20.382  1.00 24.89           C  
ATOM   1070  ND1 HIS   132      56.661  55.116  21.613  1.00 30.01           N  
ATOM   1071  CD2 HIS   132      58.310  54.197  20.517  1.00 29.31           C  
ATOM   1072  CE1 HIS   132      57.673  55.006  22.453  1.00 26.14           C  
ATOM   1073  NE2 HIS   132      58.684  54.446  21.815  1.00 33.17           N  
ATOM   1074  N   LEU   133      53.202  53.178  18.454  1.00 28.30           N  
ATOM   1075  CA  LEU   133      51.965  53.311  17.693  0.50 25.22           C  
ATOM   1077  C   LEU   133      51.192  54.565  18.089  1.00 28.50           C  
ATOM   1078  O   LEU   133      51.068  54.881  19.279  1.00 28.20           O  
ATOM   1079  CB  LEU   133      51.074  52.082  17.888  0.50 25.92           C  
ATOM   1081  CG  LEU   133      51.376  50.838  17.050  0.50 26.92           C  
ATOM   1083  CD1 LEU   133      50.895  49.605  17.797  0.50 26.96           C  
ATOM   1085  CD2 LEU   133      50.773  50.929  15.631  0.50 14.39           C  
ATOM   1087  N   TRP   134      50.677  55.273  17.079  1.00 24.73           N  
ATOM   1088  CA  TRP   134      49.741  56.378  17.310  1.00 28.04           C  
ATOM   1089  C   TRP   134      48.363  55.790  17.526  1.00 21.54           C  
ATOM   1090  O   TRP   134      47.880  55.030  16.697  1.00 27.82           O  
ATOM   1091  CB  TRP   134      49.680  57.332  16.115  1.00 24.82           C  
ATOM   1092  CG  TRP   134      50.814  58.286  16.080  1.00 25.59           C  
ATOM   1093  CD1 TRP   134      51.899  58.229  15.270  1.00 25.75           C  
ATOM   1094  CD2 TRP   134      50.989  59.436  16.920  1.00 27.94           C  
ATOM   1095  NE1 TRP   134      52.752  59.290  15.539  1.00 32.80           N  
ATOM   1096  CE2 TRP   134      52.208  60.045  16.547  1.00 32.27           C  
ATOM   1097  CE3 TRP   134      50.226  60.016  17.948  1.00 29.66           C  
ATOM   1098  CZ2 TRP   134      52.694  61.209  17.178  1.00 32.34           C  
ATOM   1099  CZ3 TRP   134      50.701  61.175  18.566  1.00 27.78           C  
ATOM   1100  CH2 TRP   134      51.928  61.751  18.178  1.00 25.76           C  
ATOM   1101  N   ILE   135      47.743  56.157  18.633  1.00 20.49           N  
ATOM   1102  CA  ILE   135      46.424  55.667  19.012  1.00 23.64           C  
ATOM   1103  C   ILE   135      45.507  56.876  19.036  1.00 24.63           C  
ATOM   1104  O   ILE   135      45.884  57.934  19.535  1.00 25.53           O  
ATOM   1105  CB  ILE   135      46.491  54.994  20.443  1.00 25.95           C  
ATOM   1106  CG1 ILE   135      47.393  53.740  20.415  1.00 32.16           C  
ATOM   1107  CG2 ILE   135      45.105  54.739  21.036  1.00 28.52           C  
ATOM   1108  CD1 ILE   135      47.131  52.779  19.275  1.00 32.57           C  
ATOM   1109  N   GLY   136      44.291  56.729  18.517  1.00 22.14           N  
ATOM   1110  CA  GLY   136      43.312  57.788  18.672  1.00 23.75           C  
ATOM   1111  C   GLY   136      42.392  57.506  19.845  1.00 29.17           C  
ATOM   1112  O   GLY   136      42.214  56.345  20.221  1.00 26.20           O  
ATOM   1113  N   ARG   137      41.853  58.561  20.468  1.00 27.14           N  
ATOM   1114  CA  ARG   137      40.785  58.419  21.449  0.50 27.41           C  
ATOM   1116  C   ARG   137      39.521  58.970  20.802  1.00 26.20           C  
ATOM   1117  O   ARG   137      39.511  60.130  20.393  1.00 30.01           O  
ATOM   1118  CB  ARG   137      41.113  59.202  22.723  0.50 28.24           C  
ATOM   1120  CG  ARG   137      40.424  58.677  23.983  0.50 35.93           C  
ATOM   1122  CD  ARG   137      40.349  59.720  25.115  0.50 34.31           C  
ATOM   1124  NE  ARG   137      41.505  60.618  25.170  0.50 35.77           N  
ATOM   1126  CZ  ARG   137      42.654  60.353  25.790  0.50 35.38           C  
ATOM   1128  NH1 ARG   137      43.629  61.251  25.770  0.50 40.30           N  
ATOM   1130  NH2 ARG   137      42.837  59.204  26.431  0.50 38.83           N  
ATOM   1132  N   ARG   138      38.478  58.146  20.717  1.00 26.46           N  
ATOM   1133  CA  ARG   138      37.248  58.524  20.025  1.00 25.62           C  
ATOM   1134  C   ARG   138      36.522  59.630  20.787  1.00 30.91           C  
ATOM   1135  O   ARG   138      36.602  59.709  22.021  1.00 29.45           O  
ATOM   1136  CB  ARG   138      36.339  57.304  19.832  1.00 23.64           C  
ATOM   1137  CG  ARG   138      36.966  56.242  18.907  1.00 21.94           C  
ATOM   1138  CD  ARG   138      36.266  54.910  18.996  1.00 20.70           C  
ATOM   1139  NE  ARG   138      34.880  54.968  18.531  1.00 22.86           N  
ATOM   1140  CZ  ARG   138      34.529  54.986  17.247  1.00 20.39           C  
ATOM   1141  NH1 ARG   138      35.457  54.949  16.293  1.00 22.53           N  
ATOM   1142  NH2 ARG   138      33.259  55.024  16.912  1.00 23.32           N  
ATOM   1143  N   SER   139      35.824  60.482  20.046  1.00 30.82           N  
ATOM   1144  CA  SER   139      35.057  61.578  20.638  1.00 30.87           C  
ATOM   1145  C   SER   139      33.940  61.000  21.509  1.00 34.11           C  
ATOM   1146  O   SER   139      33.421  59.916  21.203  1.00 30.95           O  
ATOM   1147  CB  SER   139      34.488  62.454  19.511  1.00 33.82           C  
ATOM   1148  OG  SER   139      33.340  63.180  19.913  1.00 44.80           O  
ATOM   1149  N   PRO   140      33.553  61.712  22.597  1.00 38.34           N  
ATOM   1150  CA  PRO   140      32.428  61.225  23.417  1.00 34.53           C  
ATOM   1151  C   PRO   140      31.082  61.213  22.695  1.00 37.90           C  
ATOM   1152  O   PRO   140      30.154  60.542  23.157  1.00 31.63           O  
ATOM   1153  CB  PRO   140      32.380  62.217  24.592  1.00 39.75           C  
ATOM   1154  CG  PRO   140      33.679  62.919  24.569  1.00 42.46           C  
ATOM   1155  CD  PRO   140      34.111  62.964  23.141  1.00 37.78           C  
ATOM   1156  N   ASP   141      30.996  61.920  21.563  1.00 35.55           N  
ATOM   1157  CA  ASP   141      29.781  62.004  20.771  1.00 36.36           C  
ATOM   1158  C   ASP   141      29.584  60.825  19.802  1.00 34.79           C  
ATOM   1159  O   ASP   141      28.527  60.709  19.174  1.00 34.78           O  
ATOM   1160  CB  ASP   141      29.739  63.340  20.013  1.00 44.42           C  
ATOM   1161  CG  ASP   141      29.874  64.547  20.938  1.00 49.36           C  
ATOM   1162  OD1 ASP   141      29.306  64.515  22.049  1.00 56.17           O  
ATOM   1163  OD2 ASP   141      30.558  65.525  20.559  1.00 52.17           O  
ATOM   1164  N   LYS   142      30.576  59.939  19.681  1.00 29.21           N  
ATOM   1165  CA  LYS   142      30.384  58.752  18.851  1.00 25.30           C  
ATOM   1166  C   LYS   142      29.212  57.930  19.356  1.00 25.78           C  
ATOM   1167  O   LYS   142      29.064  57.680  20.568  1.00 27.08           O  
ATOM   1168  CB  LYS   142      31.640  57.870  18.797  1.00 27.48           C  
ATOM   1169  CG  LYS   142      32.783  58.447  17.985  1.00 21.74           C  
ATOM   1170  CD  LYS   142      32.458  58.500  16.487  1.00 23.30           C  
ATOM   1171  CE  LYS   142      33.691  58.863  15.653  1.00 37.56           C  
ATOM   1172  NZ  LYS   142      33.392  58.674  14.195  1.00 34.81           N  
ATOM   1173  N   SER   143      28.395  57.504  18.408  1.00 28.71           N  
ATOM   1174  CA  SER   143      27.291  56.609  18.662  1.00 30.64           C  
ATOM   1175  C   SER   143      27.787  55.255  19.212  1.00 34.84           C  
ATOM   1176  O   SER   143      27.203  54.700  20.156  1.00 33.01           O  
ATOM   1177  CB  SER   143      26.516  56.417  17.359  1.00 38.43           C  
ATOM   1178  OG  SER   143      25.518  55.421  17.483  1.00 52.04           O  
ATOM   1179  N   VAL   144      28.881  54.763  18.625  1.00 26.02           N  
ATOM   1180  CA  VAL   144      29.490  53.472  18.954  1.00 27.84           C  
ATOM   1181  C   VAL   144      30.828  53.714  19.640  1.00 24.68           C  
ATOM   1182  O   VAL   144      31.624  54.538  19.176  1.00 29.30           O  
ATOM   1183  CB  VAL   144      29.689  52.619  17.656  1.00 24.85           C  
ATOM   1184  CG1 VAL   144      30.577  51.388  17.923  1.00 28.55           C  
ATOM   1185  CG2 VAL   144      28.334  52.209  17.074  1.00 29.86           C  
ATOM   1186  N   ALA   145      31.073  53.020  20.760  1.00 28.68           N  
ATOM   1187  CA  ALA   145      32.369  53.094  21.450  1.00 27.24           C  
ATOM   1188  C   ALA   145      32.860  54.538  21.737  1.00 24.20           C  
ATOM   1189  O   ALA   145      34.024  54.866  21.456  1.00 24.03           O  
ATOM   1190  CB  ALA   145      33.455  52.282  20.649  1.00 22.65           C  
ATOM   1191  N   PRO   146      31.979  55.416  22.294  1.00 26.11           N  
ATOM   1192  CA  PRO   146      32.462  56.776  22.548  1.00 27.01           C  
ATOM   1193  C   PRO   146      33.556  56.753  23.604  1.00 27.01           C  
ATOM   1194  O   PRO   146      33.477  55.947  24.536  1.00 26.67           O  
ATOM   1195  CB  PRO   146      31.219  57.494  23.089  1.00 26.92           C  
ATOM   1196  CG  PRO   146      30.367  56.410  23.679  1.00 26.95           C  
ATOM   1197  CD  PRO   146      30.582  55.243  22.751  1.00 26.57           C  
ATOM   1198  N   GLY   147      34.583  57.584  23.429  1.00 23.06           N  
ATOM   1199  CA  GLY   147      35.705  57.661  24.359  1.00 27.37           C  
ATOM   1200  C   GLY   147      36.691  56.497  24.326  1.00 31.76           C  
ATOM   1201  O   GLY   147      37.667  56.505  25.074  1.00 28.82           O  
ATOM   1202  N   LYS   148      36.440  55.491  23.485  1.00 27.28           N  
ATOM   1203  CA  LYS   148      37.332  54.317  23.405  1.00 26.06           C  
ATOM   1204  C   LYS   148      38.557  54.579  22.543  1.00 24.99           C  
ATOM   1205  O   LYS   148      38.583  55.495  21.700  1.00 22.55           O  
ATOM   1206  CB  LYS   148      36.593  53.091  22.883  1.00 28.51           C  
ATOM   1207  CG  LYS   148      35.318  52.761  23.627  1.00 30.74           C  
ATOM   1208  CD  LYS   148      35.550  52.390  25.007  1.00 43.85           C  
ATOM   1209  CE  LYS   148      35.908  50.942  25.127  1.00 32.51           C  
ATOM   1210  NZ  LYS   148      35.988  50.749  26.579  1.00 28.96           N  
ATOM   1211  N   LEU   149      39.580  53.755  22.738  1.00 19.09           N  
ATOM   1212  CA  LEU   149      40.799  53.869  21.978  1.00 20.06           C  
ATOM   1213  C   LEU   149      40.618  53.178  20.614  1.00 21.55           C  
ATOM   1214  O   LEU   149      39.808  52.249  20.469  1.00 19.47           O  
ATOM   1215  CB  LEU   149      41.978  53.254  22.739  1.00 19.37           C  
ATOM   1216  CG  LEU   149      42.239  53.841  24.143  1.00 22.93           C  
ATOM   1217  CD1 LEU   149      43.478  53.201  24.754  1.00 25.48           C  
ATOM   1218  CD2 LEU   149      42.424  55.331  24.014  1.00 24.59           C  
ATOM   1219  N   ASP   150      41.386  53.643  19.642  1.00 19.17           N  
ATOM   1220  CA  ASP   150      41.137  53.381  18.214  1.00 17.87           C  
ATOM   1221  C   ASP   150      42.435  53.385  17.456  1.00 21.13           C  
ATOM   1222  O   ASP   150      43.464  53.839  17.963  1.00 19.36           O  
ATOM   1223  CB  ASP   150      40.216  54.510  17.665  1.00 22.49           C  
ATOM   1224  CG  ASP   150      39.310  54.075  16.479  1.00 28.89           C  
ATOM   1225  OD1 ASP   150      39.538  53.036  15.793  1.00 24.67           O  
ATOM   1226  OD2 ASP   150      38.338  54.829  16.218  1.00 21.49           O  
ATOM   1227  N   ASN   151      42.412  52.873  16.220  1.00 19.91           N  
ATOM   1228  CA  ASN   151      43.513  53.121  15.292  1.00 18.90           C  
ATOM   1229  C   ASN   151      43.692  54.630  15.039  1.00 19.61           C  
ATOM   1230  O   ASN   151      42.763  55.413  15.282  1.00 21.72           O  
ATOM   1231  CB  ASN   151      43.249  52.436  13.953  1.00 19.47           C  
ATOM   1232  CG  ASN   151      42.927  50.965  14.110  1.00 21.52           C  
ATOM   1233  OD1 ASN   151      41.774  50.562  13.988  1.00 25.50           O  
ATOM   1234  ND2 ASN   151      43.938  50.165  14.449  1.00 24.44           N  
ATOM   1235  N   MET   152      44.869  55.023  14.553  1.00 20.04           N  
ATOM   1236  CA  MET   152      45.111  56.424  14.225  1.00 22.73           C  
ATOM   1237  C   MET   152      44.070  56.899  13.189  1.00 23.86           C  
ATOM   1238  O   MET   152      43.521  58.014  13.289  1.00 21.66           O  
ATOM   1239  CB  MET   152      46.514  56.636  13.679  1.00 18.42           C  
ATOM   1240  CG  MET   152      46.859  58.149  13.591  1.00 23.68           C  
ATOM   1241  SD  MET   152      48.604  58.426  12.865  0.70 28.49          SE  
ATOM   1242  CE  MET   152      48.177  58.085  11.003  1.00 34.44           C  
ATOM   1243  N   VAL   153      43.777  56.029  12.217  1.00 20.16           N  
ATOM   1244  CA  VAL   153      42.762  56.323  11.194  1.00 19.57           C  
ATOM   1245  C   VAL   153      41.943  55.047  10.963  1.00 19.06           C  
ATOM   1246  O   VAL   153      42.516  53.975  10.822  1.00 20.64           O  
ATOM   1247  CB  VAL   153      43.415  56.792   9.862  1.00 20.96           C  
ATOM   1248  CG1 VAL   153      42.353  56.936   8.741  1.00 24.65           C  
ATOM   1249  CG2 VAL   153      44.159  58.106  10.035  1.00 22.39           C  
ATOM   1250  N   ALA   154      40.617  55.163  10.971  1.00 19.92           N  
ATOM   1251  CA  ALA   154      39.731  54.023  10.657  1.00 21.62           C  
ATOM   1252  C   ALA   154      38.397  54.570  10.228  1.00 25.62           C  
ATOM   1253  O   ALA   154      37.948  55.570  10.773  1.00 25.22           O  
ATOM   1254  CB  ALA   154      39.524  53.137  11.885  1.00 20.52           C  
ATOM   1255  N   GLY   155      37.735  53.910   9.291  1.00 19.78           N  
ATOM   1256  CA  GLY   155      36.358  54.302   8.976  1.00 23.92           C  
ATOM   1257  C   GLY   155      35.641  53.261   8.154  1.00 25.11           C  
ATOM   1258  O   GLY   155      36.280  52.417   7.521  1.00 20.50           O  
ATOM   1259  N   GLY   156      34.313  53.317   8.176  1.00 16.33           N  
ATOM   1260  CA  GLY   156      33.510  52.527   7.267  1.00 17.20           C  
ATOM   1261  C   GLY   156      33.756  52.878   5.803  1.00 17.21           C  
ATOM   1262  O   GLY   156      34.197  53.983   5.475  1.00 20.27           O  
ATOM   1263  N   GLN   157      33.468  51.919   4.926  1.00 21.75           N  
ATOM   1264  CA  GLN   157      33.725  52.051   3.502  1.00 18.48           C  
ATOM   1265  C   GLN   157      32.454  52.429   2.761  1.00 20.30           C  
ATOM   1266  O   GLN   157      31.530  51.630   2.670  1.00 19.32           O  
ATOM   1267  CB  GLN   157      34.219  50.733   2.932  1.00 20.97           C  
ATOM   1268  CG  GLN   157      34.585  50.817   1.450  1.00 17.60           C  
ATOM   1269  CD  GLN   157      35.776  51.699   1.251  1.00 22.34           C  
ATOM   1270  OE1 GLN   157      36.605  51.847   2.153  1.00 20.60           O  
ATOM   1271  NE2 GLN   157      35.886  52.292   0.068  1.00 22.64           N  
ATOM   1272  N   PRO   158      32.420  53.634   2.195  1.00 20.08           N  
ATOM   1273  CA  PRO   158      31.248  53.977   1.381  1.00 22.50           C  
ATOM   1274  C   PRO   158      31.248  53.236   0.035  1.00 19.52           C  
ATOM   1275  O   PRO   158      32.300  52.813  -0.455  1.00 22.07           O  
ATOM   1276  CB  PRO   158      31.373  55.491   1.172  1.00 25.22           C  
ATOM   1277  CG  PRO   158      32.803  55.820   1.440  1.00 26.79           C  
ATOM   1278  CD  PRO   158      33.400  54.730   2.294  1.00 20.41           C  
ATOM   1279  N   ALA   159      30.050  53.050  -0.505  1.00 21.68           N  
ATOM   1280  CA  ALA   159      29.832  52.394  -1.781  1.00 23.81           C  
ATOM   1281  C   ALA   159      30.622  53.032  -2.917  1.00 28.04           C  
ATOM   1282  O   ALA   159      31.044  52.329  -3.845  1.00 25.76           O  
ATOM   1283  CB  ALA   159      28.379  52.443  -2.120  1.00 28.69           C  
ATOM   1284  N   ASP   160      30.840  54.346  -2.847  1.00 24.07           N  
ATOM   1285  CA  ASP   160      31.271  55.058  -4.054  1.00 33.19           C  
ATOM   1286  C   ASP   160      32.778  55.280  -4.144  1.00 33.50           C  
ATOM   1287  O   ASP   160      33.247  55.930  -5.091  1.00 25.67           O  
ATOM   1288  CB  ASP   160      30.494  56.378  -4.237  1.00 30.97           C  
ATOM   1289  CG  ASP   160      30.814  57.410  -3.164  1.00 39.20           C  
ATOM   1290  OD1 ASP   160      31.210  57.017  -2.048  1.00 33.72           O  
ATOM   1291  OD2 ASP   160      30.659  58.620  -3.436  1.00 46.55           O  
ATOM   1292  N   LEU   161      33.521  54.729  -3.178  1.00 24.34           N  
ATOM   1293  CA  LEU   161      34.989  54.888  -3.136  1.00 22.16           C  
ATOM   1294  C   LEU   161      35.713  53.536  -3.169  1.00 25.00           C  
ATOM   1295  O   LEU   161      35.177  52.523  -2.695  1.00 23.70           O  
ATOM   1296  CB  LEU   161      35.414  55.651  -1.874  1.00 22.56           C  
ATOM   1297  CG  LEU   161      34.928  57.096  -1.657  1.00 30.24           C  
ATOM   1298  CD1 LEU   161      35.634  57.695  -0.437  1.00 27.83           C  
ATOM   1299  CD2 LEU   161      35.183  57.934  -2.909  1.00 23.35           C  
ATOM   1300  N   SER   162      36.929  53.543  -3.710  1.00 19.44           N  
ATOM   1301  CA  SER   162      37.896  52.441  -3.518  1.00 18.75           C  
ATOM   1302  C   SER   162      38.383  52.464  -2.051  1.00 16.03           C  
ATOM   1303  O   SER   162      38.138  53.432  -1.324  1.00 18.03           O  
ATOM   1304  CB  SER   162      39.094  52.550  -4.471  1.00 17.15           C  
ATOM   1305  OG  SER   162      39.999  53.562  -4.049  1.00 20.75           O  
ATOM   1306  N   LEU   163      39.050  51.391  -1.627  1.00 19.00           N  
ATOM   1307  CA  LEU   163      39.595  51.317  -0.272  1.00 18.42           C  
ATOM   1308  C   LEU   163      40.671  52.381  -0.112  1.00 19.29           C  
ATOM   1309  O   LEU   163      40.718  53.055   0.905  1.00 17.38           O  
ATOM   1310  CB  LEU   163      40.196  49.919  -0.020  1.00 15.49           C  
ATOM   1311  CG  LEU   163      39.127  48.827  -0.009  1.00 17.28           C  
ATOM   1312  CD1 LEU   163      39.794  47.445  -0.052  1.00 19.40           C  
ATOM   1313  CD2 LEU   163      38.208  48.916   1.206  1.00 21.21           C  
ATOM   1314  N   ARG   164      41.510  52.514  -1.135  1.00 17.15           N  
ATOM   1315  CA  ARG   164      42.623  53.462  -1.087  1.00 22.19           C  
ATOM   1316  C   ARG   164      42.088  54.905  -1.016  1.00 22.29           C  
ATOM   1317  O   ARG   164      42.616  55.747  -0.281  1.00 22.06           O  
ATOM   1318  CB  ARG   164      43.540  53.283  -2.294  1.00 24.55           C  
ATOM   1319  CG  ARG   164      44.631  54.375  -2.420  1.00 26.08           C  
ATOM   1320  CD  ARG   164      45.627  54.235  -1.296  1.00 29.30           C  
ATOM   1321  NE  ARG   164      46.362  52.975  -1.399  1.00 38.00           N  
ATOM   1322  CZ  ARG   164      47.405  52.647  -0.639  1.00 34.41           C  
ATOM   1323  NH1 ARG   164      47.838  53.476   0.317  1.00 28.73           N  
ATOM   1324  NH2 ARG   164      48.010  51.489  -0.842  1.00 29.91           N  
ATOM   1325  N   GLN   165      41.038  55.181  -1.780  1.00 20.52           N  
ATOM   1326  CA  GLN   165      40.438  56.522  -1.806  1.00 21.23           C  
ATOM   1327  C   GLN   165      39.844  56.868  -0.457  1.00 21.59           C  
ATOM   1328  O   GLN   165      40.038  57.982   0.062  1.00 20.84           O  
ATOM   1329  CB  GLN   165      39.336  56.598  -2.863  1.00 21.52           C  
ATOM   1330  CG  GLN   165      39.894  56.847  -4.261  1.00 28.49           C  
ATOM   1331  CD  GLN   165      39.029  56.265  -5.354  1.00 36.32           C  
ATOM   1332  OE1 GLN   165      37.806  56.063  -5.196  1.00 26.17           O  
ATOM   1333  NE2 GLN   165      39.665  55.986  -6.491  1.00 39.85           N  
ATOM   1334  N   ASN   166      39.107  55.918   0.106  1.00 21.23           N  
ATOM   1335  CA  ASN   166      38.535  56.108   1.415  1.00 22.05           C  
ATOM   1336  C   ASN   166      39.629  56.262   2.475  1.00 22.07           C  
ATOM   1337  O   ASN   166      39.542  57.133   3.315  1.00 20.60           O  
ATOM   1338  CB  ASN   166      37.599  54.967   1.791  1.00 20.63           C  
ATOM   1339  CG  ASN   166      36.757  55.305   3.021  1.00 23.47           C  
ATOM   1340  OD1 ASN   166      36.291  56.449   3.168  1.00 23.28           O  
ATOM   1341  ND2 ASN   166      36.583  54.349   3.904  1.00 18.78           N  
ATOM   1342  N   LEU   167      40.657  55.415   2.423  1.00 19.16           N  
ATOM   1343  CA  LEU   167      41.799  55.585   3.326  1.00 22.36           C  
ATOM   1344  C   LEU   167      42.376  57.018   3.244  1.00 27.44           C  
ATOM   1345  O   LEU   167      42.636  57.642   4.269  1.00 22.88           O  
ATOM   1346  CB  LEU   167      42.895  54.563   3.029  1.00 20.82           C  
ATOM   1347  CG  LEU   167      44.107  54.634   3.965  1.00 26.27           C  
ATOM   1348  CD1 LEU   167      43.730  54.259   5.425  1.00 21.08           C  
ATOM   1349  CD2 LEU   167      45.208  53.749   3.420  1.00 22.64           C  
ATOM   1350  N   ILE   168      42.555  57.538   2.028  1.00 26.93           N  
ATOM   1351  CA  ILE   168      43.115  58.897   1.843  1.00 25.17           C  
ATOM   1352  C   ILE   168      42.233  59.979   2.470  1.00 24.22           C  
ATOM   1353  O   ILE   168      42.714  60.859   3.184  1.00 23.88           O  
ATOM   1354  CB  ILE   168      43.383  59.177   0.341  1.00 28.80           C  
ATOM   1355  CG1 ILE   168      44.609  58.378  -0.097  1.00 21.59           C  
ATOM   1356  CG2 ILE   168      43.611  60.674   0.062  1.00 24.28           C  
ATOM   1357  CD1 ILE   168      44.644  58.115  -1.579  1.00 29.12           C  
ATOM   1358  N   LYS   169      40.942  59.881   2.215  1.00 21.03           N  
ATOM   1359  CA  LYS   169      39.965  60.802   2.753  1.00 25.69           C  
ATOM   1360  C   LYS   169      39.921  60.744   4.277  1.00 27.01           C  
ATOM   1361  O   LYS   169      39.920  61.770   4.938  1.00 24.12           O  
ATOM   1362  CB  LYS   169      38.605  60.472   2.187  1.00 20.71           C  
ATOM   1363  CG  LYS   169      37.441  61.203   2.821  1.00 28.07           C  
ATOM   1364  CD  LYS   169      36.119  60.764   2.225  1.00 44.80           C  
ATOM   1365  CE  LYS   169      34.965  61.166   3.143  1.00 54.68           C  
ATOM   1366  NZ  LYS   169      33.661  60.638   2.662  1.00 64.28           N  
ATOM   1367  N   GLU   170      39.906  59.538   4.834  1.00 18.72           N  
ATOM   1368  CA  GLU   170      39.874  59.382   6.287  1.00 20.09           C  
ATOM   1369  C   GLU   170      41.139  59.892   6.938  1.00 23.18           C  
ATOM   1370  O   GLU   170      41.073  60.468   8.020  1.00 27.45           O  
ATOM   1371  CB  GLU   170      39.622  57.917   6.696  1.00 22.79           C  
ATOM   1372  CG  GLU   170      38.258  57.350   6.280  1.00 25.29           C  
ATOM   1373  CD  GLU   170      37.049  58.059   6.906  1.00 40.32           C  
ATOM   1374  OE1 GLU   170      36.871  59.283   6.729  1.00 53.74           O  
ATOM   1375  OE2 GLU   170      36.237  57.371   7.550  1.00 42.38           O  
ATOM   1376  N   CYS   171      42.271  59.697   6.276  1.00 20.72           N  
ATOM   1377  CA  CYS   171      43.568  60.139   6.779  1.00 23.54           C  
ATOM   1378  C   CYS   171      43.620  61.653   6.964  1.00 30.29           C  
ATOM   1379  O   CYS   171      44.135  62.136   7.976  1.00 28.00           O  
ATOM   1380  CB  CYS   171      44.709  59.704   5.866  1.00 24.69           C  
ATOM   1381  SG  CYS   171      45.309  57.986   6.121  1.00 24.58           S  
ATOM   1382  N   ALA   172      43.089  62.377   5.974  1.00 25.84           N  
ATOM   1383  CA  ALA   172      42.997  63.838   6.024  1.00 26.87           C  
ATOM   1384  C   ALA   172      41.963  64.287   7.049  1.00 24.26           C  
ATOM   1385  O   ALA   172      42.255  65.126   7.889  1.00 28.18           O  
ATOM   1386  CB  ALA   172      42.653  64.407   4.617  1.00 26.01           C  
ATOM   1387  N   GLU   173      40.763  63.712   7.013  1.00 23.60           N  
ATOM   1388  CA  GLU   173      39.687  64.192   7.870  1.00 31.06           C  
ATOM   1389  C   GLU   173      39.919  63.865   9.345  1.00 31.04           C  
ATOM   1390  O   GLU   173      39.618  64.676  10.216  1.00 30.90           O  
ATOM   1391  CB  GLU   173      38.336  63.634   7.421  1.00 28.56           C  
ATOM   1392  CG  GLU   173      37.884  64.143   6.052  1.00 33.70           C  
ATOM   1393  CD  GLU   173      36.558  63.542   5.607  1.00 44.95           C  
ATOM   1394  OE1 GLU   173      36.107  62.539   6.213  1.00 52.84           O  
ATOM   1395  OE2 GLU   173      35.976  64.071   4.633  1.00 57.87           O  
ATOM   1396  N   GLU   174      40.459  62.683   9.625  1.00 27.71           N  
ATOM   1397  CA  GLU   174      40.521  62.220  11.005  1.00 24.57           C  
ATOM   1398  C   GLU   174      41.802  62.587  11.697  1.00 23.74           C  
ATOM   1399  O   GLU   174      41.819  62.763  12.916  1.00 27.22           O  
ATOM   1400  CB  GLU   174      40.311  60.703  11.110  1.00 21.95           C  
ATOM   1401  CG  GLU   174      38.903  60.226  10.741  1.00 31.09           C  
ATOM   1402  CD  GLU   174      38.726  58.714  10.905  1.00 40.24           C  
ATOM   1403  OE1 GLU   174      39.712  58.058  11.331  1.00 29.99           O  
ATOM   1404  OE2 GLU   174      37.601  58.194  10.616  1.00 30.74           O  
ATOM   1405  N   ALA   175      42.886  62.691  10.937  1.00 23.54           N  
ATOM   1406  CA  ALA   175      44.190  62.794  11.559  1.00 26.67           C  
ATOM   1407  C   ALA   175      45.070  63.861  10.933  1.00 23.54           C  
ATOM   1408  O   ALA   175      46.236  64.004  11.327  1.00 26.48           O  
ATOM   1409  CB  ALA   175      44.898  61.448  11.543  1.00 25.30           C  
ATOM   1410  N   ASP   176      44.536  64.581   9.945  1.00 30.87           N  
ATOM   1411  CA  ASP   176      45.316  65.624   9.266  1.00 31.29           C  
ATOM   1412  C   ASP   176      46.584  65.021   8.650  1.00 31.62           C  
ATOM   1413  O   ASP   176      47.680  65.585   8.741  1.00 26.14           O  
ATOM   1414  CB  ASP   176      45.645  66.754  10.271  1.00 35.88           C  
ATOM   1415  CG  ASP   176      46.111  68.041   9.596  1.00 44.42           C  
ATOM   1416  OD1 ASP   176      45.799  68.242   8.402  1.00 42.23           O  
ATOM   1417  OD2 ASP   176      46.803  68.835  10.266  1.00 45.65           O  
ATOM   1418  N   LEU   177      46.436  63.833   8.063  1.00 28.64           N  
ATOM   1419  CA  LEU   177      47.547  63.153   7.415  1.00 28.98           C  
ATOM   1420  C   LEU   177      47.363  63.336   5.912  1.00 29.59           C  
ATOM   1421  O   LEU   177      46.375  62.864   5.350  1.00 29.80           O  
ATOM   1422  CB  LEU   177      47.591  61.655   7.796  1.00 28.47           C  
ATOM   1423  CG  LEU   177      48.676  60.813   7.119  1.00 31.21           C  
ATOM   1424  CD1 LEU   177      50.059  61.193   7.567  1.00 43.08           C  
ATOM   1425  CD2 LEU   177      48.462  59.350   7.408  1.00 35.93           C  
ATOM   1426  N   PRO   178      48.287  64.075   5.272  1.00 36.79           N  
ATOM   1427  CA  PRO   178      48.150  64.497   3.880  1.00 35.44           C  
ATOM   1428  C   PRO   178      48.266  63.343   2.903  1.00 31.05           C  
ATOM   1429  O   PRO   178      48.832  62.296   3.248  1.00 31.49           O  
ATOM   1430  CB  PRO   178      49.332  65.455   3.684  1.00 38.30           C  
ATOM   1431  CG  PRO   178      50.349  65.018   4.692  1.00 42.22           C  
ATOM   1432  CD  PRO   178      49.543  64.563   5.873  1.00 35.40           C  
ATOM   1433  N   GLU   179      47.743  63.564   1.695  1.00 33.20           N  
ATOM   1434  CA  GLU   179      47.658  62.554   0.647  1.00 34.92           C  
ATOM   1435  C   GLU   179      48.979  61.886   0.297  1.00 33.77           C  
ATOM   1436  O   GLU   179      49.014  60.670   0.118  1.00 35.14           O  
ATOM   1437  CB  GLU   179      47.021  63.129  -0.615  1.00 35.78           C  
ATOM   1438  CG  GLU   179      46.777  62.071  -1.703  1.00 36.31           C  
ATOM   1439  CD  GLU   179      45.889  62.560  -2.842  1.00 45.49           C  
ATOM   1440  OE1 GLU   179      45.597  63.774  -2.898  1.00 52.73           O  
ATOM   1441  OE2 GLU   179      45.477  61.722  -3.677  1.00 45.51           O  
ATOM   1442  N   ALA   180      50.058  62.667   0.227  1.00 36.39           N  
ATOM   1443  CA  ALA   180      51.379  62.133  -0.131  1.00 38.20           C  
ATOM   1444  C   ALA   180      51.853  61.056   0.853  1.00 37.77           C  
ATOM   1445  O   ALA   180      52.397  60.028   0.444  1.00 41.56           O  
ATOM   1446  CB  ALA   180      52.416  63.260  -0.251  1.00 40.78           C  
ATOM   1447  N   LEU   181      51.627  61.294   2.142  1.00 36.73           N  
ATOM   1448  CA  LEU   181      51.914  60.280   3.160  1.00 34.41           C  
ATOM   1449  C   LEU   181      50.891  59.141   3.182  1.00 27.36           C  
ATOM   1450  O   LEU   181      51.282  57.985   3.216  1.00 31.68           O  
ATOM   1451  CB  LEU   181      52.044  60.908   4.548  1.00 31.23           C  
ATOM   1452  CG  LEU   181      53.424  61.415   4.958  1.00 44.99           C  
ATOM   1453  CD1 LEU   181      53.292  62.339   6.142  1.00 46.78           C  
ATOM   1454  CD2 LEU   181      54.331  60.242   5.304  1.00 49.35           C  
ATOM   1455  N   ALA   182      49.589  59.457   3.184  1.00 24.43           N  
ATOM   1456  CA  ALA   182      48.533  58.431   3.118  1.00 26.05           C  
ATOM   1457  C   ALA   182      48.706  57.419   1.980  1.00 30.74           C  
ATOM   1458  O   ALA   182      48.386  56.233   2.140  1.00 25.47           O  
ATOM   1459  CB  ALA   182      47.142  59.081   3.053  1.00 25.43           C  
ATOM   1460  N   ARG   183      49.211  57.878   0.829  1.00 28.18           N  
ATOM   1461  CA  ARG   183      49.477  56.998  -0.308  1.00 31.04           C  
ATOM   1462  C   ARG   183      50.649  56.021  -0.087  1.00 25.44           C  
ATOM   1463  O   ARG   183      50.764  55.015  -0.789  1.00 29.60           O  
ATOM   1464  CB  ARG   183      49.697  57.813  -1.595  1.00 29.99           C  
ATOM   1465  CG  ARG   183      48.406  58.279  -2.240  1.00 34.47           C  
ATOM   1466  CD  ARG   183      48.654  58.995  -3.593  1.00 43.53           C  
ATOM   1467  NE  ARG   183      47.418  59.526  -4.180  1.00 42.49           N  
ATOM   1468  CZ  ARG   183      46.495  58.799  -4.812  1.00 45.86           C  
ATOM   1469  NH1 ARG   183      46.631  57.479  -4.952  1.00 51.31           N  
ATOM   1470  NH2 ARG   183      45.416  59.395  -5.297  1.00 49.80           N  
ATOM   1471  N   GLN   184      51.530  56.332   0.857  1.00 30.80           N  
ATOM   1472  CA  GLN   184      52.625  55.422   1.196  1.00 31.05           C  
ATOM   1473  C   GLN   184      52.169  54.233   2.055  1.00 27.05           C  
ATOM   1474  O   GLN   184      52.927  53.271   2.211  1.00 26.28           O  
ATOM   1475  CB  GLN   184      53.746  56.175   1.903  1.00 30.65           C  
ATOM   1476  CG  GLN   184      54.521  57.145   1.003  1.00 43.67           C  
ATOM   1477  CD  GLN   184      55.464  58.044   1.787  1.00 47.15           C  
ATOM   1478  OE1 GLN   184      56.057  57.632   2.791  1.00 55.62           O  
ATOM   1479  NE2 GLN   184      55.603  59.284   1.334  1.00 61.22           N  
ATOM   1480  N   ALA   185      50.965  54.313   2.632  1.00 27.12           N  
ATOM   1481  CA  ALA   185      50.421  53.199   3.447  1.00 26.49           C  
ATOM   1482  C   ALA   185      50.296  51.947   2.601  1.00 23.37           C  
ATOM   1483  O   ALA   185      49.831  52.000   1.454  1.00 26.33           O  
ATOM   1484  CB  ALA   185      49.064  53.550   4.049  1.00 22.77           C  
ATOM   1485  N   ILE   186      50.731  50.817   3.148  1.00 19.54           N  
ATOM   1486  CA  ILE   186      50.664  49.592   2.367  1.00 18.61           C  
ATOM   1487  C   ILE   186      49.586  48.655   2.902  1.00 19.53           C  
ATOM   1488  O   ILE   186      49.412  48.540   4.122  1.00 18.61           O  
ATOM   1489  CB  ILE   186      52.028  48.867   2.298  1.00 25.65           C  
ATOM   1490  CG1 ILE   186      52.474  48.403   3.664  1.00 23.08           C  
ATOM   1491  CG2 ILE   186      53.119  49.766   1.611  1.00 32.33           C  
ATOM   1492  CD1 ILE   186      53.373  47.159   3.562  1.00 23.38           C  
ATOM   1493  N   PRO   187      48.855  47.988   1.999  1.00 21.38           N  
ATOM   1494  CA  PRO   187      47.867  47.043   2.502  1.00 15.78           C  
ATOM   1495  C   PRO   187      48.569  45.828   3.087  1.00 20.47           C  
ATOM   1496  O   PRO   187      49.607  45.439   2.576  1.00 16.31           O  
ATOM   1497  CB  PRO   187      47.064  46.657   1.256  1.00 17.27           C  
ATOM   1498  CG  PRO   187      47.952  46.981   0.098  1.00 20.64           C  
ATOM   1499  CD  PRO   187      48.888  48.061   0.519  1.00 18.84           C  
ATOM   1500  N   VAL   188      48.046  45.287   4.183  1.00 18.73           N  
ATOM   1501  CA  VAL   188      48.744  44.218   4.909  1.00 16.69           C  
ATOM   1502  C   VAL   188      47.866  43.014   5.242  1.00 18.23           C  
ATOM   1503  O   VAL   188      48.310  42.075   5.917  1.00 21.16           O  
ATOM   1504  CB  VAL   188      49.437  44.737   6.215  1.00 19.46           C  
ATOM   1505  CG1 VAL   188      50.608  45.617   5.888  1.00 19.96           C  
ATOM   1506  CG2 VAL   188      48.436  45.460   7.141  1.00 15.01           C  
ATOM   1507  N   GLY   189      46.614  43.047   4.783  1.00 16.49           N  
ATOM   1508  CA  GLY   189      45.738  41.913   5.015  1.00 18.91           C  
ATOM   1509  C   GLY   189      44.371  42.407   5.404  1.00 18.87           C  
ATOM   1510  O   GLY   189      44.031  43.575   5.182  1.00 19.08           O  
ATOM   1511  N   ALA   190      43.588  41.519   5.986  1.00 16.54           N  
ATOM   1512  CA  ALA   190      42.232  41.863   6.412  1.00 20.59           C  
ATOM   1513  C   ALA   190      41.818  41.013   7.596  1.00 22.26           C  
ATOM   1514  O   ALA   190      42.310  39.908   7.782  1.00 22.93           O  
ATOM   1515  CB  ALA   190      41.193  41.719   5.252  1.00 17.91           C  
ATOM   1516  N   ILE   191      40.876  41.527   8.372  1.00 18.64           N  
ATOM   1517  CA  ILE   191      40.209  40.733   9.408  1.00 18.43           C  
ATOM   1518  C   ILE   191      38.742  40.564   9.089  1.00 21.37           C  
ATOM   1519  O   ILE   191      38.120  41.492   8.588  1.00 17.81           O  
ATOM   1520  CB  ILE   191      40.403  41.440  10.771  1.00 18.60           C  
ATOM   1521  CG1 ILE   191      41.794  41.129  11.305  1.00 22.38           C  
ATOM   1522  CG2 ILE   191      39.357  41.046  11.813  1.00 22.58           C  
ATOM   1523  CD1 ILE   191      42.241  42.201  12.244  1.00 27.81           C  
ATOM   1524  N   THR   192      38.193  39.370   9.332  1.00 16.15           N  
ATOM   1525  CA  THR   192      36.762  39.137   9.160  0.50 18.17           C  
ATOM   1527  C   THR   192      36.165  38.562  10.457  1.00 22.84           C  
ATOM   1528  O   THR   192      36.755  37.666  11.076  1.00 19.70           O  
ATOM   1529  CB  THR   192      36.505  38.231   7.926  0.50 23.49           C  
ATOM   1531  OG1 THR   192      36.932  38.911   6.737  0.50 21.60           O  
ATOM   1533  CG2 THR   192      35.053  37.898   7.769  0.50 12.87           C  
ATOM   1535  N   TYR   193      35.003  39.065  10.863  1.00 16.92           N  
ATOM   1536  CA  TYR   193      34.320  38.490  12.035  1.00 16.58           C  
ATOM   1537  C   TYR   193      32.832  38.520  11.779  1.00 20.59           C  
ATOM   1538  O   TYR   193      32.369  39.156  10.815  1.00 17.01           O  
ATOM   1539  CB  TYR   193      34.676  39.237  13.327  1.00 18.38           C  
ATOM   1540  CG  TYR   193      34.347  40.713  13.291  1.00 15.91           C  
ATOM   1541  CD1 TYR   193      33.058  41.166  13.568  1.00 20.25           C  
ATOM   1542  CD2 TYR   193      35.328  41.646  12.962  1.00 20.34           C  
ATOM   1543  CE1 TYR   193      32.761  42.513  13.536  1.00 20.52           C  
ATOM   1544  CE2 TYR   193      35.040  43.000  12.920  1.00 19.27           C  
ATOM   1545  CZ  TYR   193      33.755  43.418  13.219  1.00 16.20           C  
ATOM   1546  OH  TYR   193      33.448  44.772  13.151  1.00 20.98           O  
ATOM   1547  N   CYS   194      32.082  37.834  12.631  1.00 17.08           N  
ATOM   1548  CA  CYS   194      30.631  37.908  12.541  1.00 22.60           C  
ATOM   1549  C   CYS   194      30.028  37.871  13.931  1.00 22.09           C  
ATOM   1550  O   CYS   194      30.080  36.838  14.620  1.00 18.58           O  
ATOM   1551  CB  CYS   194      30.050  36.795  11.661  1.00 20.95           C  
ATOM   1552  SG  CYS   194      28.234  36.914  11.524  1.00 23.38           S  
ATOM   1553  N   MET   195      29.462  38.998  14.343  1.00 17.69           N  
ATOM   1554  CA  MET   195      28.851  39.085  15.673  1.00 18.41           C  
ATOM   1555  C   MET   195      27.433  39.597  15.665  1.00 20.71           C  
ATOM   1556  O   MET   195      27.045  40.381  14.778  1.00 20.17           O  
ATOM   1557  CB  MET   195      29.698  39.933  16.620  1.00 18.74           C  
ATOM   1558  CG  MET   195      29.772  41.398  16.224  1.00 25.25           C  
ATOM   1559  SD  MET   195      30.880  42.412  17.429  0.70 30.47          SE  
ATOM   1560  CE  MET   195      30.018  41.990  19.031  1.00 22.83           C  
ATOM   1561  N   GLU   196      26.663  39.172  16.666  1.00 20.84           N  
ATOM   1562  CA  GLU   196      25.352  39.749  16.911  1.00 21.64           C  
ATOM   1563  C   GLU   196      25.582  41.092  17.613  1.00 22.83           C  
ATOM   1564  O   GLU   196      26.303  41.181  18.614  1.00 20.50           O  
ATOM   1565  CB  GLU   196      24.470  38.823  17.761  1.00 21.99           C  
ATOM   1566  CG  GLU   196      23.072  39.424  17.999  1.00 28.14           C  
ATOM   1567  CD  GLU   196      22.005  38.428  18.472  1.00 27.63           C  
ATOM   1568  OE1 GLU   196      22.157  37.202  18.283  1.00 27.80           O  
ATOM   1569  OE2 GLU   196      20.982  38.917  19.004  1.00 38.54           O  
ATOM   1570  N   SER   197      24.962  42.137  17.088  1.00 20.19           N  
ATOM   1571  CA  SER   197      25.125  43.478  17.619  1.00 15.72           C  
ATOM   1572  C   SER   197      23.742  43.912  18.167  1.00 19.33           C  
ATOM   1573  O   SER   197      22.786  43.161  18.009  1.00 18.28           O  
ATOM   1574  CB  SER   197      25.552  44.410  16.490  1.00 18.24           C  
ATOM   1575  OG  SER   197      24.526  44.513  15.506  1.00 20.58           O  
ATOM   1576  N   PRO   198      23.651  45.084  18.836  1.00 19.82           N  
ATOM   1577  CA  PRO   198      22.353  45.521  19.391  1.00 25.01           C  
ATOM   1578  C   PRO   198      21.172  45.509  18.409  1.00 27.78           C  
ATOM   1579  O   PRO   198      20.049  45.138  18.784  1.00 27.26           O  
ATOM   1580  CB  PRO   198      22.640  46.948  19.858  1.00 21.66           C  
ATOM   1581  CG  PRO   198      24.110  46.942  20.199  1.00 25.92           C  
ATOM   1582  CD  PRO   198      24.735  46.026  19.187  1.00 21.79           C  
ATOM   1583  N   ALA   199      21.424  45.881  17.158  1.00 21.66           N  
ATOM   1584  CA  ALA   199      20.334  46.028  16.176  1.00 20.92           C  
ATOM   1585  C   ALA   199      20.302  44.928  15.105  1.00 27.82           C  
ATOM   1586  O   ALA   199      19.410  44.909  14.244  1.00 27.25           O  
ATOM   1587  CB  ALA   199      20.406  47.399  15.539  1.00 23.88           C  
ATOM   1588  N   GLY   200      21.269  44.016  15.139  1.00 21.47           N  
ATOM   1589  CA  GLY   200      21.257  42.919  14.178  1.00 20.08           C  
ATOM   1590  C   GLY   200      22.517  42.076  14.199  1.00 23.27           C  
ATOM   1591  O   GLY   200      22.938  41.612  15.250  1.00 23.02           O  
ATOM   1592  N   ILE   201      23.078  41.891  13.011  1.00 19.61           N  
ATOM   1593  CA  ILE   201      24.189  40.982  12.725  0.50 20.79           C  
ATOM   1595  C   ILE   201      25.253  41.788  11.991  1.00 21.52           C  
ATOM   1596  O   ILE   201      24.917  42.492  11.034  1.00 19.17           O  
ATOM   1597  CB  ILE   201      23.712  39.817  11.789  0.50 19.77           C  
ATOM   1599  CG1 ILE   201      22.825  38.828  12.545  0.50 23.67           C  
ATOM   1601  CG2 ILE   201      24.901  39.052  11.128  0.50 23.88           C  
ATOM   1603  CD1 ILE   201      23.586  37.842  13.400  0.50 30.69           C  
ATOM   1605  N   LYS   202      26.513  41.644  12.395  1.00 17.46           N  
ATOM   1606  CA  LYS   202      27.615  42.393  11.804  1.00 16.91           C  
ATOM   1607  C   LYS   202      28.686  41.412  11.283  1.00 19.03           C  
ATOM   1608  O   LYS   202      29.577  41.041  12.051  1.00 17.60           O  
ATOM   1609  CB  LYS   202      28.244  43.287  12.861  1.00 19.47           C  
ATOM   1610  CG  LYS   202      27.405  44.510  13.236  1.00 15.46           C  
ATOM   1611  CD  LYS   202      28.072  45.440  14.221  1.00 22.65           C  
ATOM   1612  CE  LYS   202      29.321  46.142  13.706  1.00 24.43           C  
ATOM   1613  NZ  LYS   202      29.066  47.055  12.516  1.00 27.31           N  
ATOM   1614  N   PRO   203      28.593  41.006   9.994  1.00 16.72           N  
ATOM   1615  CA  PRO   203      29.596  40.167   9.326  1.00 17.50           C  
ATOM   1616  C   PRO   203      30.545  41.129   8.652  1.00 18.96           C  
ATOM   1617  O   PRO   203      30.338  41.527   7.498  1.00 22.69           O  
ATOM   1618  CB  PRO   203      28.772  39.361   8.315  1.00 23.12           C  
ATOM   1619  CG  PRO   203      27.382  40.061   8.235  1.00 20.40           C  
ATOM   1620  CD  PRO   203      27.492  41.331   9.070  1.00 16.33           C  
ATOM   1621  N   ASP   204      31.554  41.558   9.391  1.00 14.49           N  
ATOM   1622  CA  ASP   204      32.398  42.684   8.939  1.00 18.90           C  
ATOM   1623  C   ASP   204      33.757  42.241   8.446  1.00 19.68           C  
ATOM   1624  O   ASP   204      34.325  41.264   8.944  1.00 19.53           O  
ATOM   1625  CB  ASP   204      32.610  43.701  10.053  1.00 17.03           C  
ATOM   1626  CG  ASP   204      31.314  44.405  10.487  1.00 21.45           C  
ATOM   1627  OD1 ASP   204      30.277  44.283   9.809  1.00 24.51           O  
ATOM   1628  OD2 ASP   204      31.358  45.071  11.528  1.00 25.88           O  
ATOM   1629  N   THR   205      34.267  42.983   7.469  1.00 16.49           N  
ATOM   1630  CA  THR   205      35.645  42.835   6.979  1.00 18.97           C  
ATOM   1631  C   THR   205      36.391  44.138   7.145  1.00 22.03           C  
ATOM   1632  O   THR   205      35.931  45.179   6.680  1.00 20.97           O  
ATOM   1633  CB  THR   205      35.650  42.381   5.527  1.00 20.97           C  
ATOM   1634  OG1 THR   205      35.084  41.066   5.454  1.00 18.93           O  
ATOM   1635  CG2 THR   205      37.050  42.330   4.966  1.00 18.62           C  
ATOM   1636  N   LEU   206      37.530  44.089   7.834  1.00 17.58           N  
ATOM   1637  CA  LEU   206      38.394  45.264   8.026  1.00 17.07           C  
ATOM   1638  C   LEU   206      39.632  45.098   7.186  1.00 19.34           C  
ATOM   1639  O   LEU   206      40.434  44.205   7.447  1.00 19.57           O  
ATOM   1640  CB  LEU   206      38.815  45.454   9.519  1.00 19.70           C  
ATOM   1641  CG  LEU   206      37.830  45.184  10.672  1.00 30.19           C  
ATOM   1642  CD1 LEU   206      38.456  45.413  12.051  1.00 30.63           C  
ATOM   1643  CD2 LEU   206      36.637  46.012  10.534  1.00 34.18           C  
ATOM   1644  N   PHE   207      39.797  45.960   6.190  1.00 15.14           N  
ATOM   1645  CA  PHE   207      41.012  45.982   5.403  1.00 14.18           C  
ATOM   1646  C   PHE   207      42.077  46.767   6.142  1.00 15.69           C  
ATOM   1647  O   PHE   207      41.870  47.911   6.555  1.00 19.26           O  
ATOM   1648  CB  PHE   207      40.737  46.514   3.988  1.00 15.92           C  
ATOM   1649  CG  PHE   207      39.840  45.607   3.185  1.00 19.36           C  
ATOM   1650  CD1 PHE   207      40.348  44.442   2.573  1.00 17.29           C  
ATOM   1651  CD2 PHE   207      38.484  45.899   3.052  1.00 16.61           C  
ATOM   1652  CE1 PHE   207      39.502  43.583   1.817  1.00 15.95           C  
ATOM   1653  CE2 PHE   207      37.653  45.048   2.310  1.00 18.64           C  
ATOM   1654  CZ  PHE   207      38.160  43.894   1.703  1.00 21.53           C  
ATOM   1655  N   LEU   208      43.247  46.163   6.259  1.00 16.02           N  
ATOM   1656  CA  LEU   208      44.265  46.699   7.147  1.00 16.18           C  
ATOM   1657  C   LEU   208      45.422  47.286   6.362  1.00 15.99           C  
ATOM   1658  O   LEU   208      45.801  46.761   5.317  1.00 17.80           O  
ATOM   1659  CB  LEU   208      44.773  45.584   8.056  1.00 17.30           C  
ATOM   1660  CG  LEU   208      43.666  44.740   8.702  1.00 21.82           C  
ATOM   1661  CD1 LEU   208      44.249  43.562   9.423  1.00 24.62           C  
ATOM   1662  CD2 LEU   208      42.840  45.588   9.656  1.00 21.41           C  
ATOM   1663  N   TYR   209      45.954  48.390   6.877  1.00 16.64           N  
ATOM   1664  CA  TYR   209      47.074  49.114   6.254  1.00 13.20           C  
ATOM   1665  C   TYR   209      48.103  49.478   7.319  1.00 18.91           C  
ATOM   1666  O   TYR   209      47.733  49.720   8.469  1.00 17.11           O  
ATOM   1667  CB  TYR   209      46.541  50.406   5.583  1.00 19.14           C  
ATOM   1668  CG  TYR   209      45.645  50.126   4.407  1.00 14.54           C  
ATOM   1669  CD1 TYR   209      46.130  50.167   3.107  1.00 16.75           C  
ATOM   1670  CD2 TYR   209      44.278  49.801   4.595  1.00 21.68           C  
ATOM   1671  CE1 TYR   209      45.281  49.903   1.991  1.00 21.68           C  
ATOM   1672  CE2 TYR   209      43.439  49.519   3.496  1.00 21.31           C  
ATOM   1673  CZ  TYR   209      43.959  49.570   2.209  1.00 20.17           C  
ATOM   1674  OH  TYR   209      43.129  49.283   1.152  1.00 21.68           O  
ATOM   1675  N   ASP   210      49.384  49.472   6.942  1.00 17.51           N  
ATOM   1676  CA  ASP   210      50.474  49.899   7.816  1.00 20.05           C  
ATOM   1677  C   ASP   210      51.129  51.115   7.175  1.00 19.12           C  
ATOM   1678  O   ASP   210      51.344  51.150   5.939  1.00 21.30           O  
ATOM   1679  CB  ASP   210      51.578  48.821   7.908  1.00 17.73           C  
ATOM   1680  CG  ASP   210      51.330  47.777   8.969  1.00 23.66           C  
ATOM   1681  OD1 ASP   210      50.234  47.740   9.580  1.00 19.71           O  
ATOM   1682  OD2 ASP   210      52.246  46.941   9.154  1.00 19.66           O  
ATOM   1683  N   LEU   211      51.483  52.081   8.014  1.00 21.44           N  
ATOM   1684  CA  LEU   211      52.293  53.218   7.583  1.00 19.60           C  
ATOM   1685  C   LEU   211      53.371  53.590   8.618  1.00 28.52           C  
ATOM   1686  O   LEU   211      53.047  53.917   9.773  1.00 25.01           O  
ATOM   1687  CB  LEU   211      51.396  54.433   7.289  1.00 21.33           C  
ATOM   1688  CG  LEU   211      52.079  55.711   6.778  1.00 23.75           C  
ATOM   1689  CD1 LEU   211      52.892  55.427   5.515  1.00 28.56           C  
ATOM   1690  CD2 LEU   211      51.050  56.768   6.486  1.00 21.28           C  
ATOM   1691  N   ALA   212      54.636  53.535   8.184  1.00 24.81           N  
ATOM   1692  CA  ALA   212      55.787  54.018   8.964  1.00 29.85           C  
ATOM   1693  C   ALA   212      55.828  55.527   8.798  1.00 29.57           C  
ATOM   1694  O   ALA   212      56.058  56.036   7.697  1.00 32.92           O  
ATOM   1695  CB  ALA   212      57.068  53.405   8.459  1.00 27.38           C  
ATOM   1696  N   LEU   213      55.551  56.239   9.876  1.00 25.42           N  
ATOM   1697  CA  LEU   213      55.416  57.697   9.832  1.00 25.21           C  
ATOM   1698  C   LEU   213      56.746  58.407  10.143  1.00 33.84           C  
ATOM   1699  O   LEU   213      57.605  57.834  10.822  1.00 36.56           O  
ATOM   1700  CB  LEU   213      54.344  58.147  10.814  1.00 25.79           C  
ATOM   1701  CG  LEU   213      52.903  57.810  10.408  1.00 27.39           C  
ATOM   1702  CD1 LEU   213      51.998  57.831  11.609  1.00 22.21           C  
ATOM   1703  CD2 LEU   213      52.419  58.783   9.358  1.00 32.76           C  
ATOM   1704  N   PRO   214      56.921  59.654   9.646  1.00 36.16           N  
ATOM   1705  CA  PRO   214      58.100  60.427  10.057  1.00 39.31           C  
ATOM   1706  C   PRO   214      58.066  60.728  11.559  1.00 34.96           C  
ATOM   1707  O   PRO   214      56.983  60.938  12.125  1.00 32.07           O  
ATOM   1708  CB  PRO   214      57.956  61.741   9.269  1.00 37.83           C  
ATOM   1709  CG  PRO   214      57.019  61.437   8.155  1.00 42.05           C  
ATOM   1710  CD  PRO   214      56.072  60.421   8.720  1.00 34.03           C  
ATOM   1711  N   GLU   215      59.244  60.772  12.182  1.00 38.88           N  
ATOM   1712  CA  GLU   215      59.400  61.115  13.605  1.00 42.52           C  
ATOM   1713  C   GLU   215      58.699  62.427  13.981  1.00 40.78           C  
ATOM   1714  O   GLU   215      58.184  62.559  15.092  1.00 41.45           O  
ATOM   1715  CB  GLU   215      60.889  61.205  13.984  1.00 47.40           C  
ATOM   1716  CG  GLU   215      61.675  59.879  13.903  1.00 61.85           C  
ATOM   1717  CD  GLU   215      61.590  59.037  15.173  1.00 71.62           C  
ATOM   1718  OE1 GLU   215      61.330  59.612  16.254  1.00 77.66           O  
ATOM   1719  OE2 GLU   215      61.789  57.799  15.091  1.00 66.95           O  
ATOM   1720  N   ASP   216      58.667  63.374  13.043  1.00 40.78           N  
ATOM   1721  CA  ASP   216      58.096  64.696  13.291  1.00 42.30           C  
ATOM   1722  C   ASP   216      56.617  64.850  12.910  1.00 42.05           C  
ATOM   1723  O   ASP   216      56.042  65.911  13.149  1.00 40.61           O  
ATOM   1724  CB  ASP   216      58.958  65.813  12.665  1.00 47.09           C  
ATOM   1725  CG  ASP   216      58.932  65.811  11.131  1.00 58.78           C  
ATOM   1726  OD1 ASP   216      58.804  64.731  10.514  1.00 70.12           O  
ATOM   1727  OD2 ASP   216      59.056  66.903  10.535  1.00 58.84           O  
ATOM   1728  N   PHE   217      55.990  63.813  12.342  1.00 33.84           N  
ATOM   1729  CA  PHE   217      54.531  63.879  12.124  1.00 28.76           C  
ATOM   1730  C   PHE   217      53.736  63.857  13.447  1.00 28.64           C  
ATOM   1731  O   PHE   217      54.063  63.107  14.375  1.00 33.24           O  
ATOM   1732  CB  PHE   217      54.032  62.756  11.171  1.00 31.39           C  
ATOM   1733  CG  PHE   217      52.537  62.770  10.970  1.00 34.89           C  
ATOM   1734  CD1 PHE   217      51.953  63.682  10.090  1.00 31.80           C  
ATOM   1735  CD2 PHE   217      51.708  61.919  11.707  1.00 30.13           C  
ATOM   1736  CE1 PHE   217      50.574  63.734   9.928  1.00 35.26           C  
ATOM   1737  CE2 PHE   217      50.343  61.968  11.554  1.00 26.65           C  
ATOM   1738  CZ  PHE   217      49.767  62.879  10.664  1.00 30.87           C  
ATOM   1739  N   ARG   218      52.701  64.691  13.531  1.00 30.24           N  
ATOM   1740  CA  ARG   218      51.765  64.675  14.649  1.00 33.07           C  
ATOM   1741  C   ARG   218      50.362  64.664  14.087  1.00 33.27           C  
ATOM   1742  O   ARG   218      50.005  65.570  13.349  1.00 30.02           O  
ATOM   1743  CB  ARG   218      51.913  65.918  15.548  1.00 36.17           C  
ATOM   1744  CG  ARG   218      53.292  66.156  16.149  1.00 38.66           C  
ATOM   1745  CD  ARG   218      53.636  65.164  17.279  1.00 44.01           C  
ATOM   1746  NE  ARG   218      54.971  65.428  17.825  1.00 50.41           N  
ATOM   1747  CZ  ARG   218      56.105  64.916  17.348  1.00 48.17           C  
ATOM   1748  NH1 ARG   218      56.091  64.081  16.319  1.00 53.09           N  
ATOM   1749  NH2 ARG   218      57.263  65.226  17.916  1.00 52.78           N  
ATOM   1750  N   PRO   219      49.551  63.642  14.425  1.00 32.18           N  
ATOM   1751  CA  PRO   219      48.154  63.704  13.986  1.00 28.77           C  
ATOM   1752  C   PRO   219      47.327  64.817  14.674  1.00 35.00           C  
ATOM   1753  O   PRO   219      47.516  65.087  15.867  1.00 35.22           O  
ATOM   1754  CB  PRO   219      47.602  62.299  14.338  1.00 26.16           C  
ATOM   1755  CG  PRO   219      48.499  61.797  15.400  1.00 29.84           C  
ATOM   1756  CD  PRO   219      49.859  62.389  15.144  1.00 29.45           C  
ATOM   1757  N   HIS   220      46.438  65.469  13.920  1.00 30.48           N  
ATOM   1758  CA  HIS   220      45.476  66.413  14.512  1.00 32.09           C  
ATOM   1759  C   HIS   220      44.077  66.058  14.111  1.00 30.14           C  
ATOM   1760  O   HIS   220      43.835  65.693  12.971  1.00 30.55           O  
ATOM   1761  CB  HIS   220      45.781  67.860  14.106  1.00 37.92           C  
ATOM   1762  CG  HIS   220      47.209  68.246  14.322  1.00 41.04           C  
ATOM   1763  ND1 HIS   220      48.122  68.330  13.293  1.00 50.01           N  
ATOM   1764  CD2 HIS   220      47.894  68.530  15.457  1.00 45.11           C  
ATOM   1765  CE1 HIS   220      49.305  68.660  13.781  1.00 40.41           C  
ATOM   1766  NE2 HIS   220      49.194  68.786  15.092  1.00 44.64           N  
ATOM   1767  N   ASN   221      43.153  66.229  15.047  1.00 25.59           N  
ATOM   1768  CA  ASN   221      41.767  65.783  14.921  1.00 31.42           C  
ATOM   1769  C   ASN   221      40.854  66.733  14.118  1.00 34.72           C  
ATOM   1770  O   ASN   221      39.805  67.183  14.617  1.00 40.74           O  
ATOM   1771  CB  ASN   221      41.192  65.500  16.330  1.00 32.04           C  
ATOM   1772  CG  ASN   221      41.034  66.778  17.195  1.00 41.90           C  
ATOM   1773  OD1 ASN   221      41.773  67.752  17.028  1.00 42.49           O  
ATOM   1774  ND2 ASN   221      40.056  66.768  18.105  1.00 30.00           N  
ATOM   1775  N   THR   222      41.229  66.990  12.866  1.00 34.65           N  
ATOM   1776  CA  THR   222      40.516  67.939  11.978  1.00 37.42           C  
ATOM   1777  C   THR   222      38.978  67.898  12.029  1.00 39.37           C  
ATOM   1778  O   THR   222      38.344  68.925  12.252  1.00 40.20           O  
ATOM   1779  CB  THR   222      41.007  67.833  10.506  1.00 40.30           C  
ATOM   1780  OG1 THR   222      42.441  67.862  10.475  1.00 38.41           O  
ATOM   1781  CG2 THR   222      40.467  68.991   9.654  1.00 37.82           C  
ATOM   1782  N   ASP   223      38.375  66.725  11.856  1.00 33.08           N  
ATOM   1783  CA  ASP   223      36.914  66.646  11.873  1.00 36.16           C  
ATOM   1784  C   ASP   223      36.279  66.357  13.243  1.00 36.45           C  
ATOM   1785  O   ASP   223      35.053  66.241  13.343  1.00 38.37           O  
ATOM   1786  CB  ASP   223      36.392  65.690  10.786  1.00 37.98           C  
ATOM   1787  CG  ASP   223      36.618  64.223  11.118  1.00 42.50           C  
ATOM   1788  OD1 ASP   223      37.293  63.886  12.122  1.00 34.80           O  
ATOM   1789  OD2 ASP   223      36.106  63.402  10.344  1.00 36.90           O  
ATOM   1790  N   GLY   224      37.111  66.244  14.282  1.00 35.55           N  
ATOM   1791  CA  GLY   224      36.630  66.034  15.654  1.00 36.89           C  
ATOM   1792  C   GLY   224      36.020  64.671  15.976  1.00 36.39           C  
ATOM   1793  O   GLY   224      35.449  64.482  17.054  1.00 40.38           O  
ATOM   1794  N   GLU   225      36.125  63.723  15.042  1.00 32.74           N  
ATOM   1795  CA  GLU   225      35.722  62.336  15.276  1.00 33.39           C  
ATOM   1796  C   GLU   225      36.597  61.697  16.367  1.00 31.95           C  
ATOM   1797  O   GLU   225      36.143  60.836  17.113  1.00 26.70           O  
ATOM   1798  CB  GLU   225      35.884  61.520  13.996  1.00 34.72           C  
ATOM   1799  CG  GLU   225      34.769  61.677  12.971  1.00 35.77           C  
ATOM   1800  CD  GLU   225      34.913  60.657  11.831  1.00 48.02           C  
ATOM   1801  OE1 GLU   225      34.275  59.583  11.894  1.00 36.79           O  
ATOM   1802  OE2 GLU   225      35.692  60.911  10.885  1.00 46.05           O  
ATOM   1803  N   MET   226      37.861  62.104  16.409  1.00 30.60           N  
ATOM   1804  CA  MET   226      38.780  61.764  17.497  1.00 33.62           C  
ATOM   1805  C   MET   226      38.879  62.927  18.495  1.00 35.35           C  
ATOM   1806  O   MET   226      39.017  64.078  18.089  1.00 34.95           O  
ATOM   1807  CB  MET   226      40.182  61.499  16.949  1.00 30.26           C  
ATOM   1808  CG  MET   226      40.305  60.311  16.011  1.00 38.22           C  
ATOM   1809  SD  MET   226      39.791  58.599  16.819  0.70 33.77          SE  
ATOM   1810  CE  MET   226      40.212  57.510  15.238  1.00 43.66           C  
ATOM   1811  N   ALA   227      38.835  62.611  19.788  1.00 30.11           N  
ATOM   1812  CA  ALA   227      39.070  63.585  20.851  1.00 30.34           C  
ATOM   1813  C   ALA   227      40.531  64.052  20.907  1.00 38.31           C  
ATOM   1814  O   ALA   227      40.797  65.253  21.065  1.00 39.38           O  
ATOM   1815  CB  ALA   227      38.624  63.028  22.201  1.00 32.23           C  
ATOM   1816  N   ASP   228      41.459  63.100  20.764  1.00 29.95           N  
ATOM   1817  CA  ASP   228      42.897  63.383  20.736  0.50 32.07           C  
ATOM   1819  C   ASP   228      43.640  62.133  20.291  1.00 31.14           C  
ATOM   1820  O   ASP   228      43.016  61.111  19.979  1.00 30.62           O  
ATOM   1821  CB  ASP   228      43.422  63.840  22.108  0.50 37.97           C  
ATOM   1823  CG  ASP   228      43.307  62.764  23.162  0.50 37.14           C  
ATOM   1825  OD1 ASP   228      42.167  62.425  23.532  0.50 39.67           O  
ATOM   1827  OD2 ASP   228      44.356  62.264  23.619  0.50 48.07           O  
ATOM   1829  N   PHE   229      44.961  62.237  20.221  1.00 23.57           N  
ATOM   1830  CA  PHE   229      45.842  61.157  19.805  1.00 28.22           C  
ATOM   1831  C   PHE   229      46.978  60.986  20.814  1.00 32.28           C  
ATOM   1832  O   PHE   229      47.356  61.956  21.464  1.00 29.69           O  
ATOM   1833  CB  PHE   229      46.454  61.481  18.450  1.00 27.21           C  
ATOM   1834  CG  PHE   229      45.462  61.500  17.324  1.00 28.89           C  
ATOM   1835  CD1 PHE   229      45.107  60.316  16.674  1.00 25.77           C  
ATOM   1836  CD2 PHE   229      44.905  62.698  16.895  1.00 29.22           C  
ATOM   1837  CE1 PHE   229      44.203  60.321  15.640  1.00 25.83           C  
ATOM   1838  CE2 PHE   229      43.985  62.718  15.846  1.00 29.84           C  
ATOM   1839  CZ  PHE   229      43.626  61.523  15.225  1.00 23.27           C  
ATOM   1840  N   MET   230      47.504  59.761  20.943  1.00 30.54           N  
ATOM   1841  CA  MET   230      48.633  59.475  21.839  0.50 31.97           C  
ATOM   1843  C   MET   230      49.613  58.548  21.148  1.00 32.95           C  
ATOM   1844  O   MET   230      49.212  57.668  20.384  1.00 30.38           O  
ATOM   1845  CB  MET   230      48.170  58.804  23.139  0.50 29.98           C  
ATOM   1847  CG  MET   230      47.326  59.655  24.086  0.50 30.10           C  
ATOM   1849  SD  MET   230      46.461  58.547  25.462  0.35 35.81          SE  
ATOM   1851  CE  MET   230      45.786  57.198  24.278  0.50  9.41           C  
ATOM   1853  N   LEU   231      50.903  58.740  21.417  1.00 26.63           N  
ATOM   1854  CA  LEU   231      51.928  57.875  20.870  1.00 24.90           C  
ATOM   1855  C   LEU   231      52.402  56.944  21.983  1.00 32.60           C  
ATOM   1856  O   LEU   231      52.984  57.400  22.973  1.00 27.40           O  
ATOM   1857  CB  LEU   231      53.092  58.697  20.318  1.00 22.14           C  
ATOM   1858  CG  LEU   231      54.213  57.917  19.627  1.00 27.92           C  
ATOM   1859  CD1 LEU   231      53.690  57.195  18.374  1.00 31.77           C  
ATOM   1860  CD2 LEU   231      55.354  58.858  19.235  1.00 34.90           C  
ATOM   1861  N   TRP   232      52.153  55.643  21.825  1.00 26.63           N  
ATOM   1862  CA  TRP   232      52.468  54.657  22.873  1.00 27.49           C  
ATOM   1863  C   TRP   232      53.463  53.641  22.351  1.00 24.44           C  
ATOM   1864  O   TRP   232      53.424  53.335  21.153  1.00 24.35           O  
ATOM   1865  CB  TRP   232      51.214  53.888  23.242  1.00 25.56           C  
ATOM   1866  CG  TRP   232      50.254  54.542  24.163  1.00 33.99           C  
ATOM   1867  CD1 TRP   232      50.243  55.857  24.583  1.00 30.32           C  
ATOM   1868  CD2 TRP   232      49.111  53.920  24.754  1.00 30.78           C  
ATOM   1869  NE1 TRP   232      49.172  56.067  25.416  1.00 28.93           N  
ATOM   1870  CE2 TRP   232      48.459  54.899  25.537  1.00 33.17           C  
ATOM   1871  CE3 TRP   232      48.592  52.611  24.734  1.00 25.26           C  
ATOM   1872  CZ2 TRP   232      47.301  54.615  26.278  1.00 33.10           C  
ATOM   1873  CZ3 TRP   232      47.429  52.341  25.462  1.00 31.07           C  
ATOM   1874  CH2 TRP   232      46.803  53.334  26.220  1.00 29.08           C  
ATOM   1875  N   PRO   233      54.330  53.081  23.229  1.00 25.37           N  
ATOM   1876  CA  PRO   233      55.152  51.969  22.783  1.00 26.06           C  
ATOM   1877  C   PRO   233      54.231  50.848  22.323  1.00 24.38           C  
ATOM   1878  O   PRO   233      53.160  50.647  22.927  1.00 22.96           O  
ATOM   1879  CB  PRO   233      55.902  51.547  24.060  1.00 29.18           C  
ATOM   1880  CG  PRO   233      55.941  52.785  24.901  1.00 28.56           C  
ATOM   1881  CD  PRO   233      54.598  53.424  24.647  1.00 28.32           C  
ATOM   1882  N   ALA   234      54.615  50.163  21.250  1.00 23.20           N  
ATOM   1883  CA  ALA   234      53.779  49.101  20.681  1.00 25.59           C  
ATOM   1884  C   ALA   234      53.388  48.077  21.749  1.00 22.71           C  
ATOM   1885  O   ALA   234      52.225  47.682  21.809  1.00 21.44           O  
ATOM   1886  CB  ALA   234      54.464  48.417  19.496  1.00 27.69           C  
ATOM   1887  N   ALA   235      54.338  47.677  22.603  1.00 25.08           N  
ATOM   1888  CA  ALA   235      54.065  46.687  23.659  1.00 23.69           C  
ATOM   1889  C   ALA   235      52.959  47.126  24.629  1.00 24.83           C  
ATOM   1890  O   ALA   235      52.156  46.305  25.065  1.00 23.63           O  
ATOM   1891  CB  ALA   235      55.343  46.309  24.415  1.00 29.81           C  
ATOM   1892  N   LYS   236      52.898  48.420  24.935  1.00 24.16           N  
ATOM   1893  CA  LYS   236      51.849  48.978  25.790  1.00 27.58           C  
ATOM   1894  C   LYS   236      50.451  48.847  25.143  1.00 21.12           C  
ATOM   1895  O   LYS   236      49.450  48.578  25.825  1.00 22.07           O  
ATOM   1896  CB  LYS   236      52.180  50.448  26.117  1.00 26.72           C  
ATOM   1897  CG  LYS   236      51.190  51.123  27.037  1.00 30.02           C  
ATOM   1898  CD  LYS   236      51.459  52.607  27.212  1.00 37.84           C  
ATOM   1899  CE  LYS   236      50.410  53.245  28.131  1.00 45.71           C  
ATOM   1900  NZ  LYS   236      50.697  54.688  28.391  1.00 44.63           N  
ATOM   1901  N   VAL   237      50.386  49.019  23.816  1.00 21.52           N  
ATOM   1902  CA  VAL   237      49.122  48.858  23.075  1.00 19.23           C  
ATOM   1903  C   VAL   237      48.692  47.392  23.125  1.00 17.87           C  
ATOM   1904  O   VAL   237      47.555  47.073  23.417  1.00 19.86           O  
ATOM   1905  CB  VAL   237      49.262  49.352  21.594  1.00 21.36           C  
ATOM   1906  CG1 VAL   237      47.994  49.054  20.745  1.00 21.80           C  
ATOM   1907  CG2 VAL   237      49.561  50.862  21.578  1.00 19.94           C  
ATOM   1908  N   VAL   238      49.638  46.515  22.828  1.00 15.89           N  
ATOM   1909  CA  VAL   238      49.356  45.083  22.794  1.00 17.55           C  
ATOM   1910  C   VAL   238      48.889  44.625  24.185  1.00 18.38           C  
ATOM   1911  O   VAL   238      47.898  43.906  24.296  1.00 17.12           O  
ATOM   1912  CB  VAL   238      50.579  44.302  22.299  1.00 20.65           C  
ATOM   1913  CG1 VAL   238      50.349  42.779  22.475  1.00 17.40           C  
ATOM   1914  CG2 VAL   238      50.879  44.646  20.838  1.00 22.23           C  
ATOM   1915  N   GLU   239      49.575  45.053  25.254  1.00 20.45           N  
ATOM   1916  CA  GLU   239      49.154  44.644  26.606  1.00 19.51           C  
ATOM   1917  C   GLU   239      47.828  45.270  27.046  1.00 17.58           C  
ATOM   1918  O   GLU   239      47.054  44.633  27.746  1.00 19.73           O  
ATOM   1919  CB  GLU   239      50.231  44.906  27.659  1.00 18.69           C  
ATOM   1920  CG  GLU   239      51.537  44.178  27.372  1.00 18.82           C  
ATOM   1921  CD  GLU   239      51.459  42.647  27.407  1.00 23.22           C  
ATOM   1922  OE1 GLU   239      50.465  42.043  27.875  1.00 29.15           O  
ATOM   1923  OE2 GLU   239      52.440  42.036  26.965  1.00 26.04           O  
ATOM   1924  N   ALA   240      47.560  46.498  26.609  1.00 18.60           N  
ATOM   1925  CA  ALA   240      46.227  47.090  26.833  1.00 18.75           C  
ATOM   1926  C   ALA   240      45.097  46.233  26.209  1.00 21.18           C  
ATOM   1927  O   ALA   240      44.067  46.000  26.831  1.00 17.62           O  
ATOM   1928  CB  ALA   240      46.183  48.550  26.332  1.00 18.84           C  
ATOM   1929  N   VAL   241      45.310  45.713  25.002  1.00 19.17           N  
ATOM   1930  CA  VAL   241      44.324  44.848  24.381  1.00 16.76           C  
ATOM   1931  C   VAL   241      44.267  43.498  25.112  1.00 15.47           C  
ATOM   1932  O   VAL   241      43.178  42.958  25.346  1.00 18.92           O  
ATOM   1933  CB  VAL   241      44.643  44.686  22.855  1.00 20.22           C  
ATOM   1934  CG1 VAL   241      43.787  43.559  22.183  1.00 17.92           C  
ATOM   1935  CG2 VAL   241      44.413  46.033  22.172  1.00 14.08           C  
ATOM   1936  N   ARG   242      45.422  42.960  25.515  1.00 14.46           N  
ATOM   1937  CA  ARG   242      45.425  41.642  26.181  1.00 16.30           C  
ATOM   1938  C   ARG   242      44.592  41.660  27.459  1.00 18.93           C  
ATOM   1939  O   ARG   242      43.795  40.741  27.716  1.00 21.27           O  
ATOM   1940  CB  ARG   242      46.864  41.171  26.494  1.00 15.30           C  
ATOM   1941  CG  ARG   242      46.889  39.763  27.067  1.00 16.78           C  
ATOM   1942  CD  ARG   242      48.226  39.519  27.784  1.00 22.29           C  
ATOM   1943  NE  ARG   242      49.335  39.487  26.843  1.00 20.03           N  
ATOM   1944  CZ  ARG   242      49.637  38.449  26.058  1.00 21.15           C  
ATOM   1945  NH1 ARG   242      48.907  37.328  26.050  1.00 21.56           N  
ATOM   1946  NH2 ARG   242      50.687  38.534  25.272  1.00 19.17           N  
ATOM   1947  N   THR   243      44.715  42.746  28.226  1.00 18.75           N  
ATOM   1948  CA  THR   243      44.213  42.720  29.582  1.00 20.29           C  
ATOM   1949  C   THR   243      43.134  43.725  29.948  1.00 20.77           C  
ATOM   1950  O   THR   243      42.682  43.716  31.088  1.00 20.63           O  
ATOM   1951  CB  THR   243      45.375  42.827  30.613  1.00 23.74           C  
ATOM   1952  OG1 THR   243      46.034  44.069  30.452  1.00 29.54           O  
ATOM   1953  CG2 THR   243      46.376  41.733  30.398  1.00 27.63           C  
ATOM   1954  N   THR   244      42.724  44.592  29.014  1.00 19.31           N  
ATOM   1955  CA  THR   244      41.730  45.624  29.312  1.00 20.53           C  
ATOM   1956  C   THR   244      40.672  45.705  28.197  1.00 24.18           C  
ATOM   1957  O   THR   244      40.803  45.067  27.141  1.00 19.20           O  
ATOM   1958  CB  THR   244      42.349  47.061  29.504  1.00 21.98           C  
ATOM   1959  OG1 THR   244      42.659  47.636  28.232  1.00 20.95           O  
ATOM   1960  CG2 THR   244      43.608  47.072  30.385  1.00 22.52           C  
ATOM   1961  N   GLU   245      39.649  46.532  28.423  1.00 22.28           N  
ATOM   1962  CA  GLU   245      38.659  46.803  27.380  1.00 21.28           C  
ATOM   1963  C   GLU   245      38.762  48.249  26.933  1.00 22.53           C  
ATOM   1964  O   GLU   245      37.759  48.847  26.603  1.00 22.94           O  
ATOM   1965  CB  GLU   245      37.243  46.518  27.900  1.00 25.72           C  
ATOM   1966  CG  GLU   245      37.013  45.108  28.390  1.00 29.04           C  
ATOM   1967  CD  GLU   245      36.556  44.167  27.293  1.00 39.66           C  
ATOM   1968  OE1 GLU   245      36.793  44.438  26.084  1.00 43.88           O  
ATOM   1969  OE2 GLU   245      35.930  43.148  27.639  1.00 34.03           O  
ATOM   1970  N   ALA   246      39.976  48.799  26.936  1.00 18.23           N  
ATOM   1971  CA  ALA   246      40.195  50.198  26.597  1.00 23.71           C  
ATOM   1972  C   ALA   246      39.887  50.482  25.118  1.00 25.82           C  
ATOM   1973  O   ALA   246      39.454  51.582  24.780  1.00 23.44           O  
ATOM   1974  CB  ALA   246      41.633  50.571  26.876  1.00 21.63           C  
ATOM   1975  N   PHE   247      40.124  49.490  24.248  1.00 20.81           N  
ATOM   1976  CA  PHE   247      39.980  49.691  22.795  1.00 20.54           C  
ATOM   1977  C   PHE   247      38.572  49.387  22.298  1.00 21.57           C  
ATOM   1978  O   PHE   247      37.861  48.501  22.835  1.00 21.62           O  
ATOM   1979  CB  PHE   247      41.037  48.883  22.019  1.00 17.15           C  
ATOM   1980  CG  PHE   247      42.407  49.520  22.021  1.00 24.57           C  
ATOM   1981  CD1 PHE   247      42.832  50.293  20.932  1.00 22.20           C  
ATOM   1982  CD2 PHE   247      43.256  49.386  23.128  1.00 20.78           C  
ATOM   1983  CE1 PHE   247      44.094  50.901  20.935  1.00 24.41           C  
ATOM   1984  CE2 PHE   247      44.516  49.983  23.134  1.00 24.91           C  
ATOM   1985  CZ  PHE   247      44.928  50.753  22.045  1.00 21.88           C  
ATOM   1986  N   LYS   248      38.157  50.113  21.258  1.00 19.66           N  
ATOM   1987  CA  LYS   248      36.895  49.781  20.572  1.00 15.71           C  
ATOM   1988  C   LYS   248      36.908  48.307  20.192  1.00 17.36           C  
ATOM   1989  O   LYS   248      37.957  47.775  19.831  1.00 16.16           O  
ATOM   1990  CB  LYS   248      36.785  50.665  19.313  1.00 20.31           C  
ATOM   1991  CG  LYS   248      35.653  50.308  18.350  1.00 19.58           C  
ATOM   1992  CD  LYS   248      35.383  51.525  17.446  1.00 20.79           C  
ATOM   1993  CE  LYS   248      34.446  51.169  16.277  1.00 19.70           C  
ATOM   1994  NZ  LYS   248      35.252  50.527  15.166  1.00 22.92           N  
ATOM   1995  N   PHE   249      35.758  47.644  20.279  1.00 16.33           N  
ATOM   1996  CA  PHE   249      35.678  46.156  20.219  1.00 16.95           C  
ATOM   1997  C   PHE   249      36.470  45.499  19.069  1.00 17.92           C  
ATOM   1998  O   PHE   249      37.251  44.547  19.278  1.00 20.40           O  
ATOM   1999  CB  PHE   249      34.203  45.693  20.232  1.00 17.22           C  
ATOM   2000  CG  PHE   249      33.419  46.084  18.995  1.00 27.57           C  
ATOM   2001  CD1 PHE   249      33.226  45.166  17.948  1.00 23.89           C  
ATOM   2002  CD2 PHE   249      32.841  47.348  18.884  1.00 34.84           C  
ATOM   2003  CE1 PHE   249      32.526  45.533  16.794  1.00 24.40           C  
ATOM   2004  CE2 PHE   249      32.121  47.707  17.741  1.00 29.75           C  
ATOM   2005  CZ  PHE   249      31.971  46.811  16.697  1.00 29.91           C  
ATOM   2006  N   ASN   250      36.319  46.021  17.857  1.00 17.89           N  
ATOM   2007  CA  ASN   250      36.948  45.377  16.717  1.00 18.87           C  
ATOM   2008  C   ASN   250      38.357  45.863  16.478  1.00 19.30           C  
ATOM   2009  O   ASN   250      39.125  45.186  15.831  1.00 17.61           O  
ATOM   2010  CB  ASN   250      36.074  45.436  15.463  1.00 19.36           C  
ATOM   2011  CG  ASN   250      35.623  46.859  15.113  1.00 26.18           C  
ATOM   2012  OD1 ASN   250      36.006  47.833  15.762  1.00 21.97           O  
ATOM   2013  ND2 ASN   250      34.794  46.966  14.082  1.00 23.76           N  
ATOM   2014  N   VAL   251      38.705  47.014  17.053  1.00 17.26           N  
ATOM   2015  CA  VAL   251      40.090  47.489  17.021  1.00 17.67           C  
ATOM   2016  C   VAL   251      41.045  46.546  17.793  1.00 15.70           C  
ATOM   2017  O   VAL   251      42.209  46.395  17.416  1.00 20.55           O  
ATOM   2018  CB  VAL   251      40.213  48.959  17.474  1.00 18.07           C  
ATOM   2019  CG1 VAL   251      41.693  49.419  17.429  1.00 19.60           C  
ATOM   2020  CG2 VAL   251      39.326  49.855  16.598  1.00 20.52           C  
ATOM   2021  N   ASN   252      40.554  45.898  18.853  1.00 16.54           N  
ATOM   2022  CA  ASN   252      41.300  44.796  19.520  1.00 19.17           C  
ATOM   2023  C   ASN   252      41.835  43.794  18.486  1.00 17.97           C  
ATOM   2024  O   ASN   252      43.016  43.390  18.550  1.00 13.67           O  
ATOM   2025  CB  ASN   252      40.427  44.044  20.518  1.00 16.95           C  
ATOM   2026  CG  ASN   252      40.085  44.874  21.712  1.00 21.39           C  
ATOM   2027  OD1 ASN   252      40.966  45.357  22.403  1.00 21.20           O  
ATOM   2028  ND2 ASN   252      38.796  45.077  21.939  1.00 18.46           N  
ATOM   2029  N   LEU   253      40.979  43.415  17.544  1.00 16.65           N  
ATOM   2030  CA  LEU   253      41.404  42.493  16.468  1.00 19.56           C  
ATOM   2031  C   LEU   253      42.543  43.033  15.601  1.00 16.73           C  
ATOM   2032  O   LEU   253      43.489  42.301  15.315  1.00 18.19           O  
ATOM   2033  CB  LEU   253      40.229  42.022  15.603  1.00 18.12           C  
ATOM   2034  CG  LEU   253      38.922  41.578  16.300  1.00 20.48           C  
ATOM   2035  CD1 LEU   253      37.904  41.116  15.291  1.00 21.68           C  
ATOM   2036  CD2 LEU   253      39.152  40.512  17.330  1.00 20.21           C  
ATOM   2037  N   THR   254      42.473  44.311  15.194  1.00 15.24           N  
ATOM   2038  CA  THR   254      43.556  44.925  14.404  1.00 18.27           C  
ATOM   2039  C   THR   254      44.865  44.978  15.187  1.00 16.83           C  
ATOM   2040  O   THR   254      45.934  44.825  14.612  1.00 17.38           O  
ATOM   2041  CB  THR   254      43.206  46.367  13.943  1.00 21.69           C  
ATOM   2042  OG1 THR   254      43.306  47.269  15.053  1.00 19.60           O  
ATOM   2043  CG2 THR   254      41.784  46.421  13.327  1.00 18.91           C  
ATOM   2044  N   VAL   255      44.787  45.190  16.513  1.00 16.92           N  
ATOM   2045  CA  VAL   255      46.014  45.184  17.332  1.00 20.44           C  
ATOM   2046  C   VAL   255      46.648  43.772  17.414  1.00 16.81           C  
ATOM   2047  O   VAL   255      47.861  43.602  17.301  1.00 15.75           O  
ATOM   2048  CB  VAL   255      45.729  45.717  18.762  1.00 23.19           C  
ATOM   2049  CG1 VAL   255      46.961  45.580  19.637  1.00 17.22           C  
ATOM   2050  CG2 VAL   255      45.271  47.183  18.700  1.00 17.07           C  
ATOM   2051  N   ILE   256      45.817  42.770  17.622  1.00 15.06           N  
ATOM   2052  CA  ILE   256      46.283  41.365  17.645  1.00 16.72           C  
ATOM   2053  C   ILE   256      46.945  40.996  16.304  1.00 18.72           C  
ATOM   2054  O   ILE   256      48.041  40.424  16.277  1.00 17.73           O  
ATOM   2055  CB  ILE   256      45.117  40.416  17.975  1.00 15.49           C  
ATOM   2056  CG1 ILE   256      44.671  40.628  19.426  1.00 16.40           C  
ATOM   2057  CG2 ILE   256      45.526  38.931  17.782  1.00 15.97           C  
ATOM   2058  CD1 ILE   256      43.271  40.002  19.721  1.00 17.55           C  
ATOM   2059  N   ASP   257      46.308  41.383  15.204  1.00 13.78           N  
ATOM   2060  CA  ASP   257      46.861  41.172  13.864  1.00 15.76           C  
ATOM   2061  C   ASP   257      48.199  41.850  13.683  1.00 15.74           C  
ATOM   2062  O   ASP   257      49.140  41.264  13.139  1.00 14.56           O  
ATOM   2063  CB  ASP   257      45.867  41.648  12.794  1.00 18.64           C  
ATOM   2064  CG  ASP   257      46.470  41.626  11.405  1.00 26.78           C  
ATOM   2065  OD1 ASP   257      46.453  40.556  10.783  1.00 20.72           O  
ATOM   2066  OD2 ASP   257      46.996  42.664  10.954  1.00 20.29           O  
ATOM   2067  N   PHE   258      48.273  43.108  14.105  1.00 16.25           N  
ATOM   2068  CA  PHE   258      49.528  43.852  14.067  1.00 17.51           C  
ATOM   2069  C   PHE   258      50.622  43.141  14.865  1.00 16.83           C  
ATOM   2070  O   PHE   258      51.773  43.018  14.390  1.00 17.69           O  
ATOM   2071  CB  PHE   258      49.323  45.269  14.626  1.00 15.95           C  
ATOM   2072  CG  PHE   258      50.559  46.166  14.516  1.00 17.88           C  
ATOM   2073  CD1 PHE   258      50.725  47.003  13.413  1.00 17.31           C  
ATOM   2074  CD2 PHE   258      51.537  46.171  15.533  1.00 17.86           C  
ATOM   2075  CE1 PHE   258      51.858  47.838  13.312  1.00 20.55           C  
ATOM   2076  CE2 PHE   258      52.654  46.980  15.434  1.00 23.41           C  
ATOM   2077  CZ  PHE   258      52.815  47.810  14.323  1.00 18.10           C  
ATOM   2078  N   ALA   259      50.285  42.691  16.073  1.00 14.66           N  
ATOM   2079  CA  ALA   259      51.247  41.942  16.906  1.00 17.15           C  
ATOM   2080  C   ALA   259      51.777  40.679  16.212  1.00 16.42           C  
ATOM   2081  O   ALA   259      52.985  40.380  16.281  1.00 17.86           O  
ATOM   2082  CB  ALA   259      50.584  41.557  18.213  1.00 16.20           C  
ATOM   2083  N   ILE   260      50.876  39.950  15.553  1.00 15.43           N  
ATOM   2084  CA  ILE   260      51.263  38.743  14.796  1.00 17.05           C  
ATOM   2085  C   ILE   260      52.194  39.088  13.631  1.00 21.68           C  
ATOM   2086  O   ILE   260      53.265  38.511  13.498  1.00 17.54           O  
ATOM   2087  CB  ILE   260      50.004  37.957  14.309  1.00 15.84           C  
ATOM   2088  CG1 ILE   260      49.276  37.306  15.480  1.00 15.26           C  
ATOM   2089  CG2 ILE   260      50.356  36.946  13.221  1.00 13.29           C  
ATOM   2090  CD1 ILE   260      47.801  37.088  15.148  1.00 20.98           C  
ATOM   2091  N   ARG   261      51.829  40.091  12.840  1.00 16.50           N  
ATOM   2092  CA  ARG   261      52.593  40.431  11.650  1.00 17.41           C  
ATOM   2093  C   ARG   261      53.957  41.067  11.969  1.00 20.27           C  
ATOM   2094  O   ARG   261      54.883  40.981  11.167  1.00 17.78           O  
ATOM   2095  CB  ARG   261      51.767  41.376  10.777  1.00 18.71           C  
ATOM   2096  CG  ARG   261      50.631  40.706  10.003  1.00 18.49           C  
ATOM   2097  CD  ARG   261      49.895  41.730   9.083  1.00 19.15           C  
ATOM   2098  NE  ARG   261      49.374  42.927   9.773  1.00 15.15           N  
ATOM   2099  CZ  ARG   261      49.999  44.110   9.879  1.00 17.36           C  
ATOM   2100  NH1 ARG   261      51.185  44.316   9.312  1.00 13.59           N  
ATOM   2101  NH2 ARG   261      49.410  45.118  10.534  1.00 17.72           N  
ATOM   2102  N   HIS   262      54.049  41.730  13.125  1.00 18.55           N  
ATOM   2103  CA  HIS   262      55.287  42.423  13.520  1.00 18.49           C  
ATOM   2104  C   HIS   262      56.111  41.632  14.541  1.00 19.93           C  
ATOM   2105  O   HIS   262      57.079  42.156  15.116  1.00 20.40           O  
ATOM   2106  CB  HIS   262      54.993  43.845  14.015  1.00 20.26           C  
ATOM   2107  CG  HIS   262      54.594  44.785  12.917  1.00 22.68           C  
ATOM   2108  ND1 HIS   262      55.464  45.707  12.373  1.00 26.66           N  
ATOM   2109  CD2 HIS   262      53.422  44.926  12.243  1.00 19.17           C  
ATOM   2110  CE1 HIS   262      54.846  46.384  11.418  1.00 25.84           C  
ATOM   2111  NE2 HIS   262      53.615  45.915  11.305  1.00 22.21           N  
ATOM   2112  N   GLY   263      55.748  40.363  14.727  1.00 15.73           N  
ATOM   2113  CA  GLY   263      56.525  39.416  15.539  1.00 18.52           C  
ATOM   2114  C   GLY   263      56.471  39.718  17.035  1.00 23.51           C  
ATOM   2115  O   GLY   263      57.383  39.371  17.767  1.00 19.61           O  
ATOM   2116  N   LEU   264      55.410  40.379  17.482  1.00 14.70           N  
ATOM   2117  CA  LEU   264      55.305  40.807  18.894  1.00 17.57           C  
ATOM   2118  C   LEU   264      54.781  39.666  19.747  1.00 21.10           C  
ATOM   2119  O   LEU   264      54.997  39.651  20.979  1.00 24.41           O  
ATOM   2120  CB  LEU   264      54.405  42.057  19.037  1.00 21.79           C  
ATOM   2121  CG  LEU   264      54.894  43.310  18.267  1.00 23.31           C  
ATOM   2122  CD1 LEU   264      54.040  44.564  18.553  1.00 26.68           C  
ATOM   2123  CD2 LEU   264      56.367  43.588  18.518  1.00 29.60           C  
ATOM   2124  N   ILE   265      54.031  38.749  19.115  1.00 18.52           N  
ATOM   2125  CA  ILE   265      53.686  37.475  19.752  1.00 22.83           C  
ATOM   2126  C   ILE   265      54.260  36.308  18.926  1.00 22.38           C  
ATOM   2127  O   ILE   265      54.466  36.436  17.709  1.00 22.45           O  
ATOM   2128  CB  ILE   265      52.160  37.348  20.072  1.00 25.81           C  
ATOM   2129  CG1 ILE   265      51.316  37.513  18.820  1.00 23.62           C  
ATOM   2130  CG2 ILE   265      51.719  38.400  21.120  1.00 28.12           C  
ATOM   2131  CD1 ILE   265      49.815  37.437  19.137  1.00 30.09           C  
ATOM   2132  N   ASP   266      54.528  35.182  19.589  1.00 17.59           N  
ATOM   2133  CA  ASP   266      55.396  34.130  19.052  1.00 18.41           C  
ATOM   2134  C   ASP   266      54.716  32.788  19.309  1.00 14.35           C  
ATOM   2135  O   ASP   266      54.356  32.498  20.449  1.00 17.74           O  
ATOM   2136  CB  ASP   266      56.736  34.200  19.769  1.00 22.76           C  
ATOM   2137  CG  ASP   266      57.793  33.287  19.155  1.00 23.74           C  
ATOM   2138  OD1 ASP   266      57.485  32.100  18.885  1.00 18.42           O  
ATOM   2139  OD2 ASP   266      58.934  33.756  18.958  1.00 28.70           O  
ATOM   2140  N   PRO   267      54.519  31.984  18.263  1.00 14.45           N  
ATOM   2141  CA  PRO   267      53.801  30.706  18.408  1.00 18.63           C  
ATOM   2142  C   PRO   267      54.476  29.707  19.342  1.00 19.37           C  
ATOM   2143  O   PRO   267      53.824  28.755  19.780  1.00 18.58           O  
ATOM   2144  CB  PRO   267      53.784  30.167  16.977  1.00 15.64           C  
ATOM   2145  CG  PRO   267      55.031  30.801  16.347  1.00 17.26           C  
ATOM   2146  CD  PRO   267      54.945  32.200  16.867  1.00 20.06           C  
ATOM   2147  N   ASP   268      55.740  29.927  19.664  1.00 15.62           N  
ATOM   2148  CA  ASP   268      56.414  29.081  20.623  1.00 15.57           C  
ATOM   2149  C   ASP   268      55.906  29.264  22.063  1.00 18.65           C  
ATOM   2150  O   ASP   268      56.171  28.468  22.893  1.00 20.39           O  
ATOM   2151  CB  ASP   268      57.926  29.260  20.596  1.00 15.64           C  
ATOM   2152  CG  ASP   268      58.650  28.193  19.765  1.00 20.73           C  
ATOM   2153  OD1 ASP   268      58.176  27.083  19.594  1.00 19.74           O  
ATOM   2154  OD2 ASP   268      59.709  28.523  19.289  1.00 18.59           O  
ATOM   2155  N   ASN   269      55.254  30.378  22.352  1.00 18.15           N  
ATOM   2156  CA  ASN   269      54.833  30.636  23.700  1.00 18.28           C  
ATOM   2157  C   ASN   269      53.520  31.390  23.936  1.00 23.96           C  
ATOM   2158  O   ASN   269      53.023  31.432  25.023  1.00 26.27           O  
ATOM   2159  CB  ASN   269      55.964  31.175  24.533  1.00 18.15           C  
ATOM   2160  CG  ASN   269      56.558  32.401  23.953  1.00 26.19           C  
ATOM   2161  OD1 ASN   269      57.699  32.422  23.568  1.00 32.60           O  
ATOM   2162  ND2 ASN   269      55.787  33.418  23.887  1.00 26.72           N  
ATOM   2163  N   GLU   270      52.941  31.937  22.902  1.00 16.48           N  
ATOM   2164  CA  GLU   270      51.647  32.553  23.047  1.00 15.11           C  
ATOM   2165  C   GLU   270      50.492  31.549  23.084  1.00 14.42           C  
ATOM   2166  O   GLU   270      50.240  30.921  22.121  1.00 21.12           O  
ATOM   2167  CB  GLU   270      51.467  33.548  21.932  1.00 18.79           C  
ATOM   2168  CG  GLU   270      50.290  34.433  22.053  1.00 18.97           C  
ATOM   2169  CD  GLU   270      50.347  35.361  23.231  1.00 22.84           C  
ATOM   2170  OE1 GLU   270      51.369  35.956  23.455  1.00 20.01           O  
ATOM   2171  OE2 GLU   270      49.349  35.477  23.920  1.00 26.54           O  
ATOM   2172  N   PRO   271      49.784  31.472  24.201  1.00 18.53           N  
ATOM   2173  CA  PRO   271      48.640  30.527  24.313  1.00 18.62           C  
ATOM   2174  C   PRO   271      47.585  30.711  23.209  1.00 21.48           C  
ATOM   2175  O   PRO   271      47.318  31.827  22.772  1.00 20.64           O  
ATOM   2176  CB  PRO   271      48.042  30.857  25.699  1.00 18.34           C  
ATOM   2177  CG  PRO   271      49.205  31.407  26.481  1.00 22.82           C  
ATOM   2178  CD  PRO   271      49.976  32.218  25.463  1.00 19.03           C  
ATOM   2179  N   ASP   272      47.040  29.602  22.722  1.00 19.39           N  
ATOM   2180  CA  ASP   272      45.946  29.606  21.734  1.00 21.41           C  
ATOM   2181  C   ASP   272      46.249  30.312  20.390  1.00 22.39           C  
ATOM   2182  O   ASP   272      45.353  30.844  19.739  1.00 21.93           O  
ATOM   2183  CB  ASP   272      44.665  30.132  22.399  1.00 25.85           C  
ATOM   2184  CG  ASP   272      44.337  29.387  23.701  1.00 22.95           C  
ATOM   2185  OD1 ASP   272      44.123  28.160  23.659  1.00 30.25           O  
ATOM   2186  OD2 ASP   272      44.290  30.024  24.762  1.00 25.66           O  
ATOM   2187  N   TYR   273      47.521  30.310  19.994  1.00 22.77           N  
ATOM   2188  CA  TYR   273      47.976  31.029  18.803  1.00 24.21           C  
ATOM   2189  C   TYR   273      47.124  30.663  17.581  1.00 25.07           C  
ATOM   2190  O   TYR   273      46.575  31.546  16.921  1.00 19.63           O  
ATOM   2191  CB  TYR   273      49.470  30.728  18.556  1.00 24.65           C  
ATOM   2192  CG  TYR   273      50.160  31.551  17.468  1.00 22.16           C  
ATOM   2193  CD1 TYR   273      50.778  32.746  17.787  1.00 22.26           C  
ATOM   2194  CD2 TYR   273      50.222  31.115  16.129  1.00 26.27           C  
ATOM   2195  CE1 TYR   273      51.455  33.514  16.826  1.00 25.71           C  
ATOM   2196  CE2 TYR   273      50.906  31.883  15.148  1.00 23.07           C  
ATOM   2197  CZ  TYR   273      51.516  33.091  15.519  1.00 26.26           C  
ATOM   2198  OH  TYR   273      52.227  33.891  14.619  1.00 25.63           O  
ATOM   2199  N   GLN   274      46.965  29.362  17.313  1.00 25.05           N  
ATOM   2200  CA  GLN   274      46.233  28.905  16.136  1.00 28.03           C  
ATOM   2201  C   GLN   274      44.756  29.291  16.186  1.00 21.12           C  
ATOM   2202  O   GLN   274      44.185  29.668  15.168  1.00 25.17           O  
ATOM   2203  CB  GLN   274      46.352  27.379  15.960  1.00 29.75           C  
ATOM   2204  CG  GLN   274      47.542  26.871  15.197  1.00 35.04           C  
ATOM   2205  CD  GLN   274      47.510  25.334  15.104  1.00 37.83           C  
ATOM   2206  OE1 GLN   274      47.600  24.655  16.103  1.00 54.17           O  
ATOM   2207  NE2 GLN   274      47.333  24.809  13.918  1.00 29.49           N  
ATOM   2208  N   GLU   275      44.133  29.184  17.363  1.00 21.24           N  
ATOM   2209  CA  GLU   275      42.711  29.558  17.518  1.00 23.65           C  
ATOM   2210  C   GLU   275      42.464  31.077  17.339  1.00 23.33           C  
ATOM   2211  O   GLU   275      41.438  31.485  16.766  1.00 23.64           O  
ATOM   2212  CB  GLU   275      42.172  29.094  18.877  1.00 25.97           C  
ATOM   2213  CG  GLU   275      40.632  29.029  18.967  1.00 32.41           C  
ATOM   2214  CD  GLU   275      40.122  28.518  20.321  1.00 39.35           C  
ATOM   2215  OE1 GLU   275      40.922  27.962  21.105  1.00 44.52           O  
ATOM   2216  OE2 GLU   275      38.908  28.672  20.601  1.00 41.90           O  
ATOM   2217  N   ILE   276      43.388  31.896  17.846  1.00 20.81           N  
ATOM   2218  CA  ILE   276      43.385  33.356  17.610  1.00 17.98           C  
ATOM   2219  C   ILE   276      43.453  33.689  16.106  1.00 17.71           C  
ATOM   2220  O   ILE   276      42.631  34.450  15.591  1.00 21.55           O  
ATOM   2221  CB  ILE   276      44.528  34.081  18.401  1.00 15.86           C  
ATOM   2222  CG1 ILE   276      44.247  34.008  19.908  1.00 19.73           C  
ATOM   2223  CG2 ILE   276      44.706  35.542  17.912  1.00 19.05           C  
ATOM   2224  CD1 ILE   276      45.475  34.302  20.768  1.00 19.29           C  
ATOM   2225  N   LEU   277      44.398  33.072  15.395  1.00 19.08           N  
ATOM   2226  CA  LEU   277      44.530  33.265  13.963  1.00 21.48           C  
ATOM   2227  C   LEU   277      43.274  32.840  13.211  1.00 24.88           C  
ATOM   2228  O   LEU   277      42.825  33.536  12.298  1.00 24.76           O  
ATOM   2229  CB  LEU   277      45.735  32.471  13.422  1.00 21.86           C  
ATOM   2230  CG  LEU   277      47.076  33.195  13.374  1.00 24.75           C  
ATOM   2231  CD1 LEU   277      47.600  33.586  14.733  1.00 34.47           C  
ATOM   2232  CD2 LEU   277      48.096  32.295  12.688  1.00 25.76           C  
ATOM   2233  N   ALA   278      42.715  31.692  13.593  1.00 27.02           N  
ATOM   2234  CA  ALA   278      41.506  31.175  12.965  1.00 25.77           C  
ATOM   2235  C   ALA   278      40.359  32.164  13.105  1.00 27.86           C  
ATOM   2236  O   ALA   278      39.644  32.463  12.139  1.00 27.51           O  
ATOM   2237  CB  ALA   278      41.141  29.816  13.572  1.00 26.62           C  
ATOM   2238  N   GLY   279      40.206  32.713  14.303  1.00 24.75           N  
ATOM   2239  CA  GLY   279      39.119  33.606  14.566  1.00 24.32           C  
ATOM   2240  C   GLY   279      39.255  34.969  13.922  1.00 21.62           C  
ATOM   2241  O   GLY   279      38.252  35.644  13.752  1.00 25.06           O  
ATOM   2242  N   LEU   280      40.471  35.367  13.529  1.00 21.70           N  
ATOM   2243  CA  LEU   280      40.689  36.640  12.818  1.00 16.91           C  
ATOM   2244  C   LEU   280      40.233  36.546  11.361  1.00 19.92           C  
ATOM   2245  O   LEU   280      40.131  37.569  10.678  1.00 23.50           O  
ATOM   2246  CB  LEU   280      42.167  37.093  12.848  1.00 19.48           C  
ATOM   2247  CG  LEU   280      42.750  37.463  14.221  1.00 19.47           C  
ATOM   2248  CD1 LEU   280      44.277  37.667  14.111  1.00 17.83           C  
ATOM   2249  CD2 LEU   280      42.045  38.638  14.883  1.00 22.63           C  
ATOM   2250  N   ARG   281      39.992  35.328  10.881  1.00 23.44           N  
ATOM   2251  CA  ARG   281      39.354  35.114   9.570  1.00 32.81           C  
ATOM   2252  C   ARG   281      37.935  34.561   9.712  1.00 32.09           C  
ATOM   2253  O   ARG   281      37.445  33.916   8.796  1.00 48.29           O  
ATOM   2254  CB  ARG   281      40.191  34.158   8.682  1.00 34.72           C  
ATOM   2255  CG  ARG   281      41.637  34.586   8.452  1.00 51.44           C  
ATOM   2256  CD  ARG   281      41.875  35.612   7.315  1.00 47.49           C  
ATOM   2257  NE  ARG   281      43.253  36.139   7.365  1.00 47.28           N  
ATOM   2258  CZ  ARG   281      44.352  35.493   6.941  1.00 62.28           C  
ATOM   2259  NH1 ARG   281      44.285  34.275   6.399  1.00 47.33           N  
ATOM   2260  NH2 ARG   281      45.544  36.071   7.053  1.00 64.73           N  
ATOM   2261  N   GLY   282      37.261  34.858  10.830  1.00 38.52           N  
ATOM   2262  CA  GLY   282      35.979  34.235  11.204  1.00 42.89           C  
ATOM   2263  C   GLY   282      34.742  34.549  10.371  1.00 58.44           C  
ATOM   2264  O   GLY   282      34.487  35.704  10.042  1.00 62.23           O  
ATOM   2265  N   ARG   283      33.963  33.519  10.030  1.00 64.93           N  
ATOM   2266  CA  ARG   283      32.705  33.700   9.274  1.00 72.21           C  
ATOM   2267  C   ARG   283      31.534  32.990   9.967  1.00 69.93           C  
ATOM   2268  O   ARG   283      30.361  33.286   9.718  1.00 69.14           O  
ATOM   2269  CB  ARG   283      32.831  33.197   7.821  1.00 73.70           C  
ATOM   2270  CG  ARG   283      34.107  33.605   7.074  1.00 81.93           C  
ATOM   2271  CD  ARG   283      33.954  33.492   5.560  1.00 83.14           C  
ATOM   2272  NE  ARG   283      33.593  34.769   4.934  1.00 96.15           N  
ATOM   2273  CZ  ARG   283      34.447  35.572   4.294  1.00100.15           C  
ATOM   2274  NH1 ARG   283      34.015  36.705   3.758  1.00 98.98           N  
ATOM   2275  NH2 ARG   283      35.731  35.249   4.181  1.00102.87           N  
END
