
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  224 ( 1828),  selected  224 , name 2i6k_A
# Molecule2: number of CA atoms  208 ( 1611),  selected  208 , name T0513_1_11_87_283.pdb
# PARAMETERS: 2i6k_A.T0513_1_11_87_283.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    I     4_A      M       1           -
LGA    N     5_A      S       2           -
LGA    T     6_A      F       3           -
LGA    N     7_A      L       4           -
LGA    H     8_A      K       5           -
LGA    L     9_A      H       6           -
LGA    D    10_A      V       7           -
LGA    K    11_A      Q       8           -
LGA    Q    12_A      D       9           -
LGA    Q    13_A      C      10           -
LGA    V    14_A      N      11           -
LGA    Q    15_A      -       -           -
LGA    L    16_A      -       -           -
LGA    L    17_A      -       -           -
LGA    A    18_A      G      87          1.030
LGA    E    19_A      E      88          1.602
LGA    X    20_A      L      89          1.782
LGA    C    21_A      Y      90          1.906
LGA    I    22_A      R      91          2.290
LGA    L    23_A      V      92          2.195
LGA    I    24_A      N      93          2.626
LGA    D    25_A      Q      94          1.005
LGA    E    26_A      S      95          3.709
LGA    N    27_A      W      96          5.500
LGA    D    28_A      G      97          4.169
LGA    N    29_A      E      98          1.873
LGA    K    30_A      P      99          3.693
LGA    I    31_A      T     100          2.540
LGA    G    32_A      L     101          3.549
LGA    -       -      M     102           -
LGA    A    33_A      L     103          2.110
LGA    E    34_A      L     104          1.836
LGA    T    35_A      D     105          1.788
LGA    K    36_A      R     106          1.837
LGA    K    37_A      A     107          1.354
LGA    N    38_A      V     108          1.794
LGA    C    39_A      V     109          1.922
LGA    H    40_A      -       -           -
LGA    L    41_A      -       -           -
LGA    N    42_A      P     110          3.561
LGA    E    43_A      T     111          2.469
LGA    N    44_A      F     112          2.071
LGA    I    45_A      G     113          1.768
LGA    E    46_A      -       -           -
LGA    K    47_A      -       -           -
LGA    G    48_A      -       -           -
LGA    L    49_A      V     114          0.762
LGA    L    50_A      R     115          0.913
LGA    H    51_A      A     116          2.185
LGA    R    52_A      Y     117          2.210
LGA    A    53_A      G     118          1.561
LGA    F    54_A      V     119          1.319
LGA    S    55_A      H     120          1.248
LGA    V    56_A      L     121          0.973
LGA    F    57_A      N     122          0.792
LGA    L    58_A      G     123          1.008
LGA    F    59_A      Y     124          0.859
LGA    N    60_A      V     125          1.931
LGA    T    61_A      G     126          3.563
LGA    -       -      A     127           -
LGA    -       -      G     128           -
LGA    -       -      A     129           -
LGA    E    62_A      D     130          5.246
LGA    N    63_A      L     131          2.850
LGA    K    64_A      H     132          1.128
LGA    L    65_A      L     133          1.241
LGA    L    66_A      W     134          1.165
LGA    L    67_A      I     135          1.129
LGA    Q    68_A      G     136          1.232
LGA    Q    69_A      R     137          1.781
LGA    R    70_A      R     138          1.514
LGA    S    71_A      S     139          1.351
LGA    D    72_A      P     140          1.689
LGA    A    73_A      D     141          1.453
LGA    K    74_A      K     142          1.485
LGA    I    75_A      S     143          1.702
LGA    T    76_A      V     144          1.979
LGA    F    77_A      A     145          2.012
LGA    P    78_A      P     146          1.801
LGA    G    79_A      G     147          2.002
LGA    C    80_A      K     148          1.765
LGA    F    81_A      L     149          1.358
LGA    T    82_A      D     150          2.192
LGA    N    83_A      N     151          1.939
LGA    T    84_A      M     152          2.010
LGA    C    85_A      V     153          1.795
LGA    C    86_A      A     154          1.493
LGA    S    87_A      G     155          1.376
LGA    H    88_A      G     156          2.739
LGA    P    89_A      Q     157          3.020
LGA    L    90_A      P     158          2.328
LGA    S    91_A      A     159          1.884
LGA    N    92_A      D     160          1.970
LGA    P    93_A      -       -           -
LGA    A    94_A      L     161          4.683
LGA    E    95_A      S     162          2.338
LGA    L    96_A      -       -           -
LGA    E    97_A      -       -           -
LGA    E    98_A      -       -           -
LGA    S    99_A      -       -           -
LGA    D   100_A      -       -           -
LGA    A   101_A      -       -           -
LGA    L   102_A      -       -           -
LGA    G   103_A      -       -           -
LGA    V   104_A      L     163          0.690
LGA    R   105_A      R     164          1.547
LGA    R   106_A      Q     165          1.769
LGA    A   107_A      N     166          0.912
LGA    A   108_A      L     167          0.699
LGA    Q   109_A      I     168          1.284
LGA    R   110_A      K     169          0.752
LGA    R   111_A      E     170          0.180
LGA    L   112_A      C     171          1.062
LGA    K   113_A      A     172          0.806
LGA    A   114_A      E     173          0.710
LGA    E   115_A      E     174          0.912
LGA    L   116_A      A     175          1.128
LGA    G   117_A      D     176          1.660
LGA    I   118_A      L     177          1.644
LGA    P   119_A      P     178          2.137
LGA    L   120_A      E     179          2.221
LGA    E   121_A      A     180          2.829
LGA    E   122_A      L     181          2.772
LGA    V   123_A      A     182          1.954
LGA    P   124_A      R     183          2.063
LGA    P   125_A      -       -           -
LGA    E   126_A      -       -           -
LGA    E   127_A      Q     184          0.965
LGA    I   128_A      A     185          1.606
LGA    N   129_A      I     186          0.957
LGA    Y   130_A      P     187          0.932
LGA    L   131_A      V     188          1.558
LGA    T   132_A      G     189          1.486
LGA    R   133_A      A     190          2.096
LGA    I   134_A      I     191          2.026
LGA    H   135_A      T     192          1.648
LGA    Y   136_A      Y     193          1.462
LGA    K   137_A      C     194          2.627
LGA    A   138_A      M     195          3.641
LGA    Q   139_A      E     196          5.218
LGA    S   140_A      S     197          5.575
LGA    D   141_A      -       -           -
LGA    G   142_A      P     198          1.952
LGA    I   143_A      A     199          3.006
LGA    W   144_A      G     200           #
LGA    G   145_A      I     201           #
LGA    E   146_A      K     202          3.984
LGA    H   147_A      P     203          3.163
LGA    E   148_A      D     204          1.846
LGA    I   149_A      T     205          1.736
LGA    D   150_A      L     206          1.560
LGA    Y   151_A      F     207          0.943
LGA    I   152_A      L     208          1.053
LGA    L   153_A      Y     209          0.954
LGA    L   154_A      D     210          1.003
LGA    V   155_A      L     211          1.018
LGA    R   156_A      A     212          1.015
LGA    X   157_A      L     213          1.568
LGA    N   158_A      P     214          2.186
LGA    -       -      E     215           -
LGA    -       -      D     216           -
LGA    V   159_A      F     217          2.837
LGA    T   160_A      R     218          3.417
LGA    L   161_A      P     219          1.986
LGA    N   162_A      H     220          1.503
LGA    P   163_A      N     221          0.810
LGA    D   164_A      T     222          3.793
LGA    P   165_A      D     223           #
LGA    N   166_A      G     224          3.075
LGA    E   167_A      E     225          0.683
LGA    I   168_A      M     226          0.945
LGA    K   169_A      A     227          2.232
LGA    S   170_A      D     228          2.792
LGA    Y   171_A      F     229          1.862
LGA    C   172_A      M     230          1.193
LGA    Y   173_A      L     231          1.574
LGA    V   174_A      W     232          1.692
LGA    S   175_A      P     233          1.388
LGA    K   176_A      A     234          2.554
LGA    E   177_A      A     235          2.223
LGA    E   178_A      K     236          1.354
LGA    L   179_A      V     237          1.472
LGA    K   180_A      V     238          3.337
LGA    E   181_A      E     239          3.606
LGA    L   182_A      A     240          1.977
LGA    L   183_A      V     241          2.412
LGA    K   184_A      R     242          4.743
LGA    K   185_A      T     243          4.960
LGA    A   186_A      T     244          1.390
LGA    A   187_A      E     245           #
LGA    S   188_A      -       -           -
LGA    G   189_A      -       -           -
LGA    E   190_A      -       -           -
LGA    I   191_A      -       -           -
LGA    K   192_A      A     246          2.898
LGA    I   193_A      F     247          1.768
LGA    T   194_A      K     248          2.030
LGA    P   195_A      F     249          2.333
LGA    W   196_A      N     250          1.859
LGA    F   197_A      V     251          2.026
LGA    K   198_A      N     252          1.910
LGA    I   199_A      L     253          2.244
LGA    I   200_A      T     254          3.203
LGA    A   201_A      V     255          2.961
LGA    A   202_A      I     256          3.348
LGA    T   203_A      -       -           -
LGA    F   204_A      D     257          2.242
LGA    L   205_A      F     258          1.680
LGA    F   206_A      A     259          1.266
LGA    K   207_A      I     260          2.578
LGA    W   208_A      R     261          2.056
LGA    W   209_A      H     262          2.408
LGA    D   210_A      G     263          3.480
LGA    N   211_A      L     264           -
LGA    L   212_A      I     265           -
LGA    N   213_A      D     266           -
LGA    H   214_A      P     267           -
LGA    L   215_A      D     268           -
LGA    N   216_A      N     269           -
LGA    Q   217_A      E     270           -
LGA    F   218_A      P     271           -
LGA    V   219_A      D     272           -
LGA    D   220_A      Y     273           -
LGA    H   221_A      Q     274           -
LGA    E   222_A      E     275           -
LGA    K   223_A      I     276           -
LGA    I   224_A      L     277           -
LGA    Y   225_A      -       -           -
LGA    R   226_A      A     278           #
LGA    X   227_A      G     279          3.572
LGA    -       -      L     280           -
LGA    -       -      R     281           -
LGA    -       -      G     282           -
LGA    -       -      R     283           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  224  208    5.0    168    2.29     9.52     57.465     7.042

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.639380 * X  +  -0.645017 * Y  +   0.418506 * Z  +  40.084301
  Y_new =   0.760672 * X  +   0.610008 * Y  +  -0.221964 * Z  +  50.448620
  Z_new =  -0.112121 * X  +   0.460265 * Y  +   0.880673 * Z  +  10.159479 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.481587   -2.660006  [ DEG:    27.5929   -152.4071 ]
  Theta =   0.112358    3.029235  [ DEG:     6.4376    173.5624 ]
  Phi   =   0.871817   -2.269776  [ DEG:    49.9514   -130.0486 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2i6k_A                                        
REMARK     2: T0513_1_11_87_283.pdb                         
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2i6k_A.T0513_1_11_87_283.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  224  208   5.0  168   2.29    9.52  57.465
REMARK  ---------------------------------------------------------- 
MOLECULE 2i6k_A
HEADER    ISOMERASE                               29-AUG-06   2I6K              
TITLE     CRYSTAL STRUCTURE OF HUMAN TYPE I IPP ISOMERASE COMPLEXED             
TITLE    2 WITH A SUBSTRATE ANALOG                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ISOPENTENYL-DIPHOSPHATE DELTA-ISOMERASE 1;                 
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: IPP ISOMERASE 1, ISOPENTENYL PYROPHOSPHATE                  
COMPND   5 ISOMERASE 1, IPPI1;                                                  
COMPND   6 EC: 5.3.3.2;                                                         
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: P28                                       
KEYWDS    GLOBULAR DOMAIN, FOLD                                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.ZHANG,Z.WEI,W.GONG                                                  
REVDAT   1   05-JUN-07 2I6K    0                                                
JRNL        AUTH   C.ZHANG,L.LIU,H.XU,Z.WEI,Y.WANG,Y.LIN,W.GONG                 
JRNL        TITL   CRYSTAL STRUCTURES OF HUMAN IPP ISOMERASE: NEW               
JRNL        TITL 2 INSIGHTS INTO THE CATALYTIC MECHANISM                        
JRNL        REF    J.MOL.BIOL.                   V. 366  1437 2007              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  2I6K A    1   227  UNP    Q13907   IDI1_HUMAN       1    227             
DBREF  2I6K B    1   227  UNP    Q13907   IDI1_HUMAN       1    227             
SEQRES   1 A  235  MSE GLY HIS HIS HIS HIS HIS HIS MSE PRO GLU ILE ASN          
SEQRES   2 A  235  THR ASN HIS LEU ASP LYS GLN GLN VAL GLN LEU LEU ALA          
SEQRES   3 A  235  GLU MSE CYS ILE LEU ILE ASP GLU ASN ASP ASN LYS ILE          
SEQRES   4 A  235  GLY ALA GLU THR LYS LYS ASN CYS HIS LEU ASN GLU ASN          
SEQRES   5 A  235  ILE GLU LYS GLY LEU LEU HIS ARG ALA PHE SER VAL PHE          
SEQRES   6 A  235  LEU PHE ASN THR GLU ASN LYS LEU LEU LEU GLN GLN ARG          
SEQRES   7 A  235  SER ASP ALA LYS ILE THR PHE PRO GLY CYS PHE THR ASN          
SEQRES   8 A  235  THR CYS CYS SER HIS PRO LEU SER ASN PRO ALA GLU LEU          
SEQRES   9 A  235  GLU GLU SER ASP ALA LEU GLY VAL ARG ARG ALA ALA GLN          
SEQRES  10 A  235  ARG ARG LEU LYS ALA GLU LEU GLY ILE PRO LEU GLU GLU          
SEQRES  11 A  235  VAL PRO PRO GLU GLU ILE ASN TYR LEU THR ARG ILE HIS          
SEQRES  12 A  235  TYR LYS ALA GLN SER ASP GLY ILE TRP GLY GLU HIS GLU          
SEQRES  13 A  235  ILE ASP TYR ILE LEU LEU VAL ARG MSE ASN VAL THR LEU          
SEQRES  14 A  235  ASN PRO ASP PRO ASN GLU ILE LYS SER TYR CYS TYR VAL          
SEQRES  15 A  235  SER LYS GLU GLU LEU LYS GLU LEU LEU LYS LYS ALA ALA          
SEQRES  16 A  235  SER GLY GLU ILE LYS ILE THR PRO TRP PHE LYS ILE ILE          
SEQRES  17 A  235  ALA ALA THR PHE LEU PHE LYS TRP TRP ASP ASN LEU ASN          
SEQRES  18 A  235  HIS LEU ASN GLN PHE VAL ASP HIS GLU LYS ILE TYR ARG          
SEQRES  19 A  235  MSE                                                          
SEQRES   1 B  235  MSE GLY HIS HIS HIS HIS HIS HIS MSE PRO GLU ILE ASN          
SEQRES   2 B  235  THR ASN HIS LEU ASP LYS GLN GLN VAL GLN LEU LEU ALA          
SEQRES   3 B  235  GLU MSE CYS ILE LEU ILE ASP GLU ASN ASP ASN LYS ILE          
SEQRES   4 B  235  GLY ALA GLU THR LYS LYS ASN CYS HIS LEU ASN GLU ASN          
SEQRES   5 B  235  ILE GLU LYS GLY LEU LEU HIS ARG ALA PHE SER VAL PHE          
SEQRES   6 B  235  LEU PHE ASN THR GLU ASN LYS LEU LEU LEU GLN GLN ARG          
SEQRES   7 B  235  SER ASP ALA LYS ILE THR PHE PRO GLY CYS PHE THR ASN          
SEQRES   8 B  235  THR CYS CYS SER HIS PRO LEU SER ASN PRO ALA GLU LEU          
SEQRES   9 B  235  GLU GLU SER ASP ALA LEU GLY VAL ARG ARG ALA ALA GLN          
SEQRES  10 B  235  ARG ARG LEU LYS ALA GLU LEU GLY ILE PRO LEU GLU GLU          
SEQRES  11 B  235  VAL PRO PRO GLU GLU ILE ASN TYR LEU THR ARG ILE HIS          
SEQRES  12 B  235  TYR LYS ALA GLN SER ASP GLY ILE TRP GLY GLU HIS GLU          
SEQRES  13 B  235  ILE ASP TYR ILE LEU LEU VAL ARG MSE ASN VAL THR LEU          
SEQRES  14 B  235  ASN PRO ASP PRO ASN GLU ILE LYS SER TYR CYS TYR VAL          
SEQRES  15 B  235  SER LYS GLU GLU LEU LYS GLU LEU LEU LYS LYS ALA ALA          
SEQRES  16 B  235  SER GLY GLU ILE LYS ILE THR PRO TRP PHE LYS ILE ILE          
SEQRES  17 B  235  ALA ALA THR PHE LEU PHE LYS TRP TRP ASP ASN LEU ASN          
SEQRES  18 B  235  HIS LEU ASN GLN PHE VAL ASP HIS GLU LYS ILE TYR ARG          
SEQRES  19 B  235  MSE                                                          
HET    MSE  A  20       8                                                       
HET    MSE  A 157       8                                                       
HET    MSE  A 227       9                                                       
HET    MSE  B  20       8                                                       
HET    MSE  B 157      13                                                       
HET    MSE  B 227       9                                                       
HET     MN    201       1                                                       
HET     MN    202       1                                                       
HET     MG    301       1                                                       
HET     MG    302       1                                                       
HET     MG    303       1                                                       
HET     MG    304       1                                                       
HET    EA2    401      12                                                       
HET    EA2    402      12                                                       
HET    ACY    501       4                                                       
HET    ACY    502       4                                                       
HET    ACY    503       4                                                       
HET    ACY    504       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      MN MANGANESE (II) ION                                               
HETNAM      MG MAGNESIUM ION                                                    
HETNAM     EA2 AMINOETHANOLPYROPHOSPHATE                                        
HETNAM     ACY ACETIC ACID                                                      
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   3   MN    2(MN 2+)                                                     
FORMUL   5   MG    4(MG 2+)                                                     
FORMUL   9  EA2    2(C2 H9 N O7 P2)                                             
FORMUL  11  ACY    4(C2 H4 O2)                                                  
FORMUL  15  HOH   *140(H2 O)                                                    
CRYST1   41.363   43.074   70.466  80.26  89.98  67.95 P 1           2          
ATOM      1  N   ILE A   4      14.280  53.758  12.673  1.00 74.53           N  
ATOM      2  CA  ILE A   4      14.190  54.376  13.977  1.00 74.49           C  
ATOM      3  C   ILE A   4      14.983  55.654  14.029  1.00 74.22           C  
ATOM      4  O   ILE A   4      15.444  56.167  13.027  1.00 74.07           O  
ATOM      5  CB  ILE A   4      14.760  53.499  15.064  1.00 74.69           C  
ATOM      6  CG1 ILE A   4      13.801  52.380  15.445  1.00 75.47           C  
ATOM      7  CG2 ILE A   4      16.180  53.067  14.722  1.00 73.94           C  
ATOM      8  CD1 ILE A   4      13.402  51.499  14.321  1.00 76.43           C  
ATOM      9  N   ASN A   5      15.163  56.142  15.238  1.00 74.00           N  
ATOM     10  CA  ASN A   5      15.124  57.545  15.492  1.00 73.53           C  
ATOM     11  C   ASN A   5      16.426  58.072  16.047  1.00 73.25           C  
ATOM     12  O   ASN A   5      16.752  57.838  17.194  1.00 73.32           O  
ATOM     13  CB  ASN A   5      14.015  57.865  16.459  0.00 73.81           C  
ATOM     14  CG  ASN A   5      13.880  59.322  16.680  0.00 78.68           C  
ATOM     15  OD1 ASN A   5      14.575  59.895  17.513  0.00 79.72           O  
ATOM     16  ND2 ASN A   5      12.983  59.955  15.923  0.00 79.57           N  
ATOM     17  N   THR A   6      17.158  58.791  15.213  1.00 72.66           N  
ATOM     18  CA  THR A   6      18.548  59.076  15.463  1.00 71.94           C  
ATOM     19  C   THR A   6      18.668  60.426  16.125  1.00 71.75           C  
ATOM     20  O   THR A   6      19.625  61.128  15.948  1.00 71.98           O  
ATOM     21  CB  THR A   6      19.418  58.977  14.167  1.00 71.86           C  
ATOM     22  OG1 THR A   6      19.088  60.013  13.244  1.00 70.64           O  
ATOM     23  CG2 THR A   6      19.217  57.663  13.489  1.00 71.11           C  
ATOM     24  N   ASN A   7      17.669  60.795  16.903  1.00 71.21           N  
ATOM     25  CA  ASN A   7      17.666  62.111  17.528  1.00 70.48           C  
ATOM     26  C   ASN A   7      18.494  62.173  18.804  1.00 69.70           C  
ATOM     27  O   ASN A   7      18.904  63.236  19.183  1.00 69.74           O  
ATOM     28  CB  ASN A   7      16.220  62.633  17.707  1.00 70.84           C  
ATOM     29  CG  ASN A   7      16.075  63.719  18.789  0.00 64.50           C  
ATOM     30  OD1 ASN A   7      16.587  64.836  18.665  0.00 64.96           O  
ATOM     31  ND2 ASN A   7      15.332  63.391  19.842  0.00 64.84           N  
ATOM     32  N   HIS A   8      18.817  61.032  19.434  1.00 20.00           N  
ATOM     33  CA  HIS A   8      19.549  61.150  20.688  1.00 20.00           C  
ATOM     34  C   HIS A   8      21.051  61.250  20.444  1.00 20.00           C  
ATOM     35  O   HIS A   8      21.904  61.367  21.377  1.00 65.64           O  
ATOM     36  CB  HIS A   8      19.244  59.961  21.601  1.00 20.00           C  
ATOM     37  CG  HIS A   8      17.815  59.881  22.031  1.00 20.00           C  
ATOM     38  ND1 HIS A   8      16.937  58.938  21.536  1.00 20.00           N  
ATOM     39  CD2 HIS A   8      17.104  60.626  22.910  1.00 20.00           C  
ATOM     40  CE1 HIS A   8      15.752  59.106  22.090  1.00 20.00           C  
ATOM     41  NE2 HIS A   8      15.823  60.124  22.929  1.00 20.00           N  
ATOM     42  N   LEU A   9      21.399  61.193  19.127  1.00 64.02           N  
ATOM     43  CA  LEU A   9      22.766  61.044  18.590  1.00 61.68           C  
ATOM     44  C   LEU A   9      23.347  62.327  17.995  1.00 60.12           C  
ATOM     45  O   LEU A   9      22.610  63.199  17.529  1.00 60.02           O  
ATOM     46  CB  LEU A   9      22.810  59.923  17.543  1.00 61.51           C  
ATOM     47  CG  LEU A   9      22.091  58.603  17.905  1.00 60.83           C  
ATOM     48  CD1 LEU A   9      21.666  57.863  16.658  1.00 60.68           C  
ATOM     49  CD2 LEU A   9      22.943  57.713  18.795  1.00 60.61           C  
ATOM     50  N   ASP A  10      24.679  62.411  18.007  1.00 58.09           N  
ATOM     51  CA  ASP A  10      25.434  63.579  17.542  1.00 56.19           C  
ATOM     52  C   ASP A  10      25.111  63.933  16.086  1.00 55.07           C  
ATOM     53  O   ASP A  10      25.054  63.055  15.233  1.00 55.01           O  
ATOM     54  CB  ASP A  10      26.940  63.324  17.724  1.00 55.78           C  
ATOM     55  CG  ASP A  10      27.797  64.508  17.298  1.00 54.53           C  
ATOM     56  OD1 ASP A  10      27.978  65.444  18.109  1.00 53.44           O  
ATOM     57  OD2 ASP A  10      28.294  64.501  16.153  1.00 51.16           O  
ATOM     58  N   LYS A  11      24.915  65.224  15.820  1.00 53.95           N  
ATOM     59  CA  LYS A  11      24.456  65.704  14.513  1.00 52.92           C  
ATOM     60  C   LYS A  11      25.438  65.494  13.370  1.00 51.59           C  
ATOM     61  O   LYS A  11      25.035  65.137  12.265  1.00 51.33           O  
ATOM     62  CB  LYS A  11      24.069  67.183  14.571  1.00 53.56           C  
ATOM     63  CG  LYS A  11      22.772  67.456  15.308  1.00 56.26           C  
ATOM     64  CD  LYS A  11      21.916  68.487  14.569  1.00 61.05           C  
ATOM     65  CE  LYS A  11      22.337  69.942  14.852  1.00 63.29           C  
ATOM     66  NZ  LYS A  11      21.986  70.402  16.233  1.00 64.12           N  
ATOM     67  N   GLN A  12      26.718  65.737  13.617  1.00 50.30           N  
ATOM     68  CA  GLN A  12      27.721  65.545  12.571  1.00 49.16           C  
ATOM     69  C   GLN A  12      27.844  64.071  12.215  1.00 47.80           C  
ATOM     70  O   GLN A  12      28.015  63.727  11.048  1.00 48.38           O  
ATOM     71  CB  GLN A  12      29.076  66.110  12.985  1.00 49.46           C  
ATOM     72  CG  GLN A  12      29.058  67.581  13.335  1.00 50.71           C  
ATOM     73  CD  GLN A  12      30.434  68.108  13.680  1.00 51.74           C  
ATOM     74  OE1 GLN A  12      31.334  68.153  12.829  1.00 53.03           O  
ATOM     75  NE2 GLN A  12      30.603  68.529  14.929  1.00 50.44           N  
ATOM     76  N   GLN A  13      27.749  63.208  13.225  1.00 45.87           N  
ATOM     77  CA  GLN A  13      27.796  61.765  13.017  1.00 43.83           C  
ATOM     78  C   GLN A  13      26.590  61.267  12.244  1.00 43.70           C  
ATOM     79  O   GLN A  13      26.705  60.358  11.433  1.00 43.35           O  
ATOM     80  CB  GLN A  13      27.927  61.032  14.346  1.00 42.97           C  
ATOM     81  CG  GLN A  13      29.293  61.187  14.972  1.00 41.60           C  
ATOM     82  CD  GLN A  13      30.401  60.758  14.035  1.00 42.46           C  
ATOM     83  OE1 GLN A  13      30.439  59.609  13.590  1.00 38.10           O  
ATOM     84  NE2 GLN A  13      31.312  61.682  13.725  1.00 43.03           N  
ATOM     85  N   VAL A  14      25.447  61.884  12.488  1.00 43.66           N  
ATOM     86  CA  VAL A  14      24.209  61.519  11.851  1.00 43.39           C  
ATOM     87  C   VAL A  14      24.226  61.878  10.392  1.00 43.13           C  
ATOM     88  O   VAL A  14      23.797  61.120   9.563  1.00 43.23           O  
ATOM     89  CB  VAL A  14      23.005  62.139  12.570  1.00 43.69           C  
ATOM     90  CG1 VAL A  14      21.823  62.169  11.696  1.00 44.75           C  
ATOM     91  CG2 VAL A  14      22.710  61.394  13.828  1.00 43.43           C  
ATOM     92  N   GLN A  15      24.765  63.028  10.069  1.00 42.67           N  
ATOM     93  CA  GLN A  15      24.929  63.378   8.694  1.00 42.84           C  
ATOM     94  C   GLN A  15      25.757  62.356   7.935  1.00 42.54           C  
ATOM     95  O   GLN A  15      25.533  62.132   6.773  1.00 42.55           O  
ATOM     96  CB  GLN A  15      25.529  64.760   8.537  1.00 43.24           C  
ATOM     97  CG  GLN A  15      24.752  65.869   9.175  1.00 45.25           C  
ATOM     98  CD  GLN A  15      25.327  67.220   8.861  1.00 50.99           C  
ATOM     99  OE1 GLN A  15      25.742  67.954   9.739  1.00 53.51           O  
ATOM    100  NE2 GLN A  15      25.356  67.552   7.602  1.00 52.66           N  
ATOM    101  N   LEU A  16      26.710  61.741   8.603  1.00 41.62           N  
ATOM    102  CA  LEU A  16      27.599  60.815   7.925  1.00 41.98           C  
ATOM    103  C   LEU A  16      26.880  59.505   7.625  1.00 41.69           C  
ATOM    104  O   LEU A  16      27.321  58.714   6.827  1.00 41.51           O  
ATOM    105  CB  LEU A  16      28.839  60.560   8.764  1.00 42.10           C  
ATOM    106  CG  LEU A  16      29.844  61.696   8.896  1.00 42.99           C  
ATOM    107  CD1 LEU A  16      30.803  61.408   9.992  1.00 41.92           C  
ATOM    108  CD2 LEU A  16      30.571  61.908   7.599  1.00 43.61           C  
ATOM    109  N   LEU A  17      25.737  59.316   8.259  1.00 40.75           N  
ATOM    110  CA  LEU A  17      24.955  58.124   8.039  1.00 40.67           C  
ATOM    111  C   LEU A  17      24.335  58.016   6.667  1.00 40.07           C  
ATOM    112  O   LEU A  17      23.857  56.989   6.307  1.00 40.48           O  
ATOM    113  CB  LEU A  17      23.897  57.921   9.111  1.00 40.49           C  
ATOM    114  CG  LEU A  17      24.281  57.655  10.555  1.00 41.23           C  
ATOM    115  CD1 LEU A  17      23.038  57.668  11.384  1.00 38.71           C  
ATOM    116  CD2 LEU A  17      25.030  56.378  10.758  1.00 39.65           C  
ATOM    117  N   ALA A  18      24.354  59.096   5.922  1.00 39.82           N  
ATOM    118  CA  ALA A  18      23.797  59.125   4.586  1.00 40.33           C  
ATOM    119  C   ALA A  18      24.813  58.664   3.560  1.00 40.68           C  
ATOM    120  O   ALA A  18      24.469  58.495   2.391  1.00 41.69           O  
ATOM    121  CB  ALA A  18      23.293  60.519   4.234  1.00 40.77           C  
ATOM    122  N   GLU A  19      26.061  58.477   3.984  1.00 40.61           N  
ATOM    123  CA  GLU A  19      27.105  58.007   3.071  1.00 40.50           C  
ATOM    124  C   GLU A  19      26.786  56.614   2.555  1.00 39.30           C  
ATOM    125  O   GLU A  19      26.263  55.777   3.286  1.00 38.79           O  
ATOM    126  CB  GLU A  19      28.467  58.013   3.747  1.00 40.95           C  
ATOM    127  CG  GLU A  19      29.161  59.360   3.707  1.00 43.29           C  
ATOM    128  CD  GLU A  19      30.496  59.360   4.436  1.00 43.90           C  
ATOM    129  OE1 GLU A  19      30.807  58.370   5.147  1.00 46.80           O  
ATOM    130  OE2 GLU A  19      31.238  60.363   4.298  1.00 46.79           O  
HETATM  131  N   MSE A  20      27.101  56.376   1.288  1.00 38.88           N  
HETATM  132  CA  MSE A  20      26.798  55.102   0.658  1.00 38.74           C  
HETATM  133  C   MSE A  20      27.993  54.151   0.749  1.00 37.52           C  
HETATM  134  O   MSE A  20      29.047  54.440   0.200  1.00 37.22           O  
HETATM  135  CB  MSE A  20      26.380  55.309  -0.802  1.00 39.56           C  
HETATM  136  CG  MSE A  20      25.208  56.249  -0.979  1.00 44.79           C  
HETATM  137 SE   MSE A  20      23.629  55.469  -0.246  1.00 54.87          SE  
HETATM  138  CE  MSE A  20      23.602  53.806  -1.300  1.00 48.33           C  
ATOM    139  N   CYS A  21      27.798  53.025   1.444  1.00 36.10           N  
ATOM    140  CA  CYS A  21      28.797  51.950   1.580  1.00 35.10           C  
ATOM    141  C   CYS A  21      28.663  50.883   0.501  1.00 33.27           C  
ATOM    142  O   CYS A  21      27.619  50.773  -0.139  1.00 33.93           O  
ATOM    143  CB  CYS A  21      28.657  51.264   2.942  1.00 35.58           C  
ATOM    144  SG  CYS A  21      28.876  52.335   4.371  1.00 41.89           S  
ATOM    145  N   ILE A  22      29.715  50.077   0.326  1.00 31.14           N  
ATOM    146  CA  ILE A  22      29.698  48.971  -0.636  1.00 28.75           C  
ATOM    147  C   ILE A  22      29.171  47.664  -0.004  1.00 28.38           C  
ATOM    148  O   ILE A  22      29.723  47.153   0.961  1.00 28.47           O  
ATOM    149  CB  ILE A  22      31.121  48.751  -1.287  1.00 28.72           C  
ATOM    150  CG1 ILE A  22      31.665  50.081  -1.826  1.00 28.78           C  
ATOM    151  CG2 ILE A  22      31.003  47.805  -2.421  1.00 23.51           C  
ATOM    152  CD1 ILE A  22      33.203  50.162  -2.000  1.00 29.27           C  
ATOM    153  N   LEU A  23      28.083  47.147  -0.545  1.00 28.77           N  
ATOM    154  CA  LEU A  23      27.523  45.898  -0.099  1.00 27.92           C  
ATOM    155  C   LEU A  23      28.278  44.810  -0.846  1.00 28.25           C  
ATOM    156  O   LEU A  23      28.409  44.899  -2.058  1.00 28.09           O  
ATOM    157  CB  LEU A  23      26.050  45.842  -0.470  1.00 27.81           C  
ATOM    158  CG  LEU A  23      25.082  46.737   0.339  1.00 26.80           C  
ATOM    159  CD1 LEU A  23      23.670  46.412  -0.065  1.00 26.66           C  
ATOM    160  CD2 LEU A  23      25.247  46.497   1.814  1.00 27.65           C  
ATOM    161  N   ILE A  24      28.773  43.807  -0.127  1.00 28.70           N  
ATOM    162  CA  ILE A  24      29.592  42.727  -0.741  1.00 29.13           C  
ATOM    163  C   ILE A  24      29.014  41.373  -0.370  1.00 30.96           C  
ATOM    164  O   ILE A  24      28.244  41.270   0.596  1.00 30.21           O  
ATOM    165  CB  ILE A  24      31.055  42.781  -0.263  1.00 27.10           C  
ATOM    166  CG1 ILE A  24      31.104  42.761   1.274  1.00 28.66           C  
ATOM    167  CG2 ILE A  24      31.778  44.006  -0.855  1.00 24.64           C  
ATOM    168  CD1 ILE A  24      32.476  42.891   1.896  1.00 27.68           C  
ATOM    169  N   ASP A  25      29.378  40.338  -1.133  1.00 33.46           N  
ATOM    170  CA  ASP A  25      29.050  38.981  -0.753  1.00 34.97           C  
ATOM    171  C   ASP A  25      30.157  38.486   0.161  1.00 37.12           C  
ATOM    172  O   ASP A  25      31.098  39.238   0.465  1.00 37.17           O  
ATOM    173  CB  ASP A  25      28.851  38.085  -1.985  1.00 35.31           C  
ATOM    174  CG  ASP A  25      30.140  37.836  -2.765  1.00 38.12           C  
ATOM    175  OD1 ASP A  25      31.243  38.165  -2.274  1.00 38.83           O  
ATOM    176  OD2 ASP A  25      30.048  37.290  -3.888  1.00 40.60           O  
ATOM    177  N   GLU A  26      30.067  37.234   0.606  1.00 38.97           N  
ATOM    178  CA  GLU A  26      31.071  36.716   1.542  1.00 40.39           C  
ATOM    179  C   GLU A  26      32.486  36.625   0.944  1.00 40.12           C  
ATOM    180  O   GLU A  26      33.450  36.448   1.680  1.00 39.80           O  
ATOM    181  CB  GLU A  26      30.606  35.417   2.240  1.00 41.24           C  
ATOM    182  CG  GLU A  26      29.361  35.643   3.155  1.00 44.87           C  
ATOM    183  CD  GLU A  26      29.169  34.615   4.293  1.00 46.87           C  
ATOM    184  OE1 GLU A  26      28.834  35.049   5.432  1.00 50.18           O  
ATOM    185  OE2 GLU A  26      29.322  33.388   4.058  1.00 52.13           O  
ATOM    186  N   ASN A  27      32.611  36.799  -0.371  1.00 39.35           N  
ATOM    187  CA  ASN A  27      33.919  36.757  -1.033  1.00 39.47           C  
ATOM    188  C   ASN A  27      34.409  38.128  -1.484  1.00 38.26           C  
ATOM    189  O   ASN A  27      35.305  38.220  -2.324  1.00 37.10           O  
ATOM    190  CB  ASN A  27      33.919  35.806  -2.243  1.00 40.37           C  
ATOM    191  CG  ASN A  27      33.756  34.344  -1.859  1.00 43.53           C  
ATOM    192  OD1 ASN A  27      33.090  33.588  -2.566  1.00 48.72           O  
ATOM    193  ND2 ASN A  27      34.352  33.939  -0.746  1.00 44.43           N  
ATOM    194  N   ASP A  28      33.805  39.189  -0.942  1.00 37.09           N  
ATOM    195  CA  ASP A  28      34.248  40.567  -1.198  1.00 35.20           C  
ATOM    196  C   ASP A  28      34.010  41.002  -2.644  1.00 33.85           C  
ATOM    197  O   ASP A  28      34.702  41.866  -3.155  1.00 34.29           O  
ATOM    198  CB  ASP A  28      35.710  40.744  -0.754  1.00 35.33           C  
ATOM    199  CG  ASP A  28      36.149  42.199  -0.663  1.00 36.57           C  
ATOM    200  OD1 ASP A  28      35.344  43.080  -0.260  1.00 37.38           O  
ATOM    201  OD2 ASP A  28      37.340  42.448  -0.978  1.00 36.78           O  
ATOM    202  N   ASN A  29      33.028  40.383  -3.296  1.00 32.94           N  
ATOM    203  CA  ASN A  29      32.521  40.844  -4.582  1.00 33.22           C  
ATOM    204  C   ASN A  29      31.394  41.834  -4.316  1.00 33.03           C  
ATOM    205  O   ASN A  29      30.565  41.558  -3.481  1.00 32.03           O  
ATOM    206  CB  ASN A  29      31.961  39.672  -5.379  1.00 33.70           C  
ATOM    207  CG  ASN A  29      32.996  38.585  -5.614  1.00 36.95           C  
ATOM    208  OD1 ASN A  29      32.748  37.406  -5.344  1.00 39.07           O  
ATOM    209  ND2 ASN A  29      34.165  38.982  -6.084  1.00 36.63           N  
ATOM    210  N   LYS A  30      31.380  42.958  -5.031  1.00 33.62           N  
ATOM    211  CA  LYS A  30      30.370  44.014  -4.864  1.00 33.95           C  
ATOM    212  C   LYS A  30      29.005  43.502  -5.288  1.00 34.29           C  
ATOM    213  O   LYS A  30      28.867  42.879  -6.349  1.00 33.94           O  
ATOM    214  CB  LYS A  30      30.756  45.206  -5.726  1.00 34.82           C  
ATOM    215  CG  LYS A  30      30.065  46.528  -5.386  1.00 34.88           C  
ATOM    216  CD  LYS A  30      28.650  46.648  -5.920  1.00 38.60           C  
ATOM    217  CE  LYS A  30      28.516  47.405  -7.220  1.00 41.79           C  
ATOM    218  NZ  LYS A  30      28.769  48.875  -7.226  1.00 44.02           N  
ATOM    219  N   ILE A  31      27.988  43.760  -4.466  1.00 33.87           N  
ATOM    220  CA  ILE A  31      26.619  43.327  -4.782  1.00 32.23           C  
ATOM    221  C   ILE A  31      25.584  44.460  -4.733  1.00 32.88           C  
ATOM    222  O   ILE A  31      24.467  44.309  -5.217  1.00 33.42           O  
ATOM    223  CB  ILE A  31      26.149  42.118  -3.916  1.00 31.62           C  
ATOM    224  CG1 ILE A  31      26.152  42.468  -2.432  1.00 30.19           C  
ATOM    225  CG2 ILE A  31      27.017  40.868  -4.197  1.00 31.19           C  
ATOM    226  CD1 ILE A  31      25.501  41.432  -1.533  1.00 28.29           C  
ATOM    227  N   GLY A  32      25.962  45.593  -4.167  1.00 32.28           N  
ATOM    228  CA  GLY A  32      25.074  46.741  -4.146  1.00 32.67           C  
ATOM    229  C   GLY A  32      25.671  47.896  -3.395  1.00 32.02           C  
ATOM    230  O   GLY A  32      26.871  47.929  -3.137  1.00 31.64           O  
ATOM    231  N   ALA A  33      24.811  48.845  -3.033  1.00 31.70           N  
ATOM    232  CA  ALA A  33      25.206  50.018  -2.283  1.00 30.94           C  
ATOM    233  C   ALA A  33      24.100  50.320  -1.283  1.00 31.67           C  
ATOM    234  O   ALA A  33      22.922  50.187  -1.598  1.00 31.98           O  
ATOM    235  CB  ALA A  33      25.396  51.179  -3.210  1.00 29.67           C  
ATOM    236  N   GLU A  34      24.490  50.715  -0.082  1.00 32.08           N  
ATOM    237  CA  GLU A  34      23.548  50.946   0.998  1.00 32.36           C  
ATOM    238  C   GLU A  34      24.088  52.022   1.922  1.00 31.43           C  
ATOM    239  O   GLU A  34      25.286  52.117   2.098  1.00 30.23           O  
ATOM    240  CB  GLU A  34      23.310  49.636   1.762  1.00 33.62           C  
ATOM    241  CG  GLU A  34      22.359  49.717   2.945  1.00 35.22           C  
ATOM    242  CD  GLU A  34      20.944  50.078   2.547  1.00 39.81           C  
ATOM    243  OE1 GLU A  34      20.178  49.167   2.177  1.00 39.25           O  
ATOM    244  OE2 GLU A  34      20.595  51.281   2.624  1.00 42.21           O  
ATOM    245  N   THR A  35      23.201  52.836   2.508  1.00 30.23           N  
ATOM    246  CA  THR A  35      23.614  53.854   3.461  1.00 29.02           C  
ATOM    247  C   THR A  35      24.313  53.265   4.669  1.00 29.28           C  
ATOM    248  O   THR A  35      23.948  52.185   5.146  1.00 29.17           O  
ATOM    249  CB  THR A  35      22.421  54.661   3.999  1.00 27.71           C  
ATOM    250  OG1 THR A  35      21.602  53.796   4.783  1.00 28.29           O  
ATOM    251  CG2 THR A  35      21.615  55.221   2.875  1.00 27.84           C  
ATOM    252  N   LYS A  36      25.304  54.009   5.166  1.00 29.86           N  
ATOM    253  CA  LYS A  36      26.039  53.690   6.390  1.00 29.24           C  
ATOM    254  C   LYS A  36      25.098  53.274   7.507  1.00 30.07           C  
ATOM    255  O   LYS A  36      25.329  52.276   8.199  1.00 28.64           O  
ATOM    256  CB  LYS A  36      26.902  54.903   6.801  1.00 28.95           C  
ATOM    257  CG  LYS A  36      27.600  54.777   8.147  1.00 27.81           C  
ATOM    258  CD  LYS A  36      28.548  55.931   8.384  1.00 27.27           C  
ATOM    259  CE  LYS A  36      29.321  55.747   9.682  1.00 26.28           C  
ATOM    260  NZ  LYS A  36      30.346  56.816   9.832  1.00 31.74           N  
ATOM    261  N   LYS A  37      24.020  54.050   7.682  1.00 30.82           N  
ATOM    262  CA  LYS A  37      23.033  53.755   8.718  1.00 31.37           C  
ATOM    263  C   LYS A  37      22.439  52.345   8.593  1.00 30.68           C  
ATOM    264  O   LYS A  37      22.484  51.573   9.545  1.00 30.37           O  
ATOM    265  CB  LYS A  37      21.908  54.802   8.698  1.00 31.50           C  
ATOM    266  CG  LYS A  37      20.693  54.432   9.521  1.00 34.73           C  
ATOM    267  CD  LYS A  37      19.613  55.508   9.341  1.00 38.95           C  
ATOM    268  CE  LYS A  37      18.241  55.047   9.833  1.00 44.24           C  
ATOM    269  NZ  LYS A  37      18.156  54.960  11.324  1.00 46.44           N  
ATOM    270  N   ASN A  38      21.896  52.015   7.422  1.00 29.94           N  
ATOM    271  CA  ASN A  38      21.283  50.707   7.217  1.00 30.89           C  
ATOM    272  C   ASN A  38      22.301  49.573   7.349  1.00 31.81           C  
ATOM    273  O   ASN A  38      21.986  48.498   7.848  1.00 31.05           O  
ATOM    274  CB  ASN A  38      20.548  50.643   5.867  1.00 30.65           C  
ATOM    275  CG  ASN A  38      19.209  51.378   5.901  1.00 30.86           C  
ATOM    276  OD1 ASN A  38      18.566  51.426   6.932  1.00 33.46           O  
ATOM    277  ND2 ASN A  38      18.810  51.957   4.782  1.00 28.94           N  
ATOM    278  N   CYS A  39      23.528  49.840   6.918  1.00 33.33           N  
ATOM    279  CA  CYS A  39      24.612  48.866   7.015  1.00 34.27           C  
ATOM    280  C   CYS A  39      24.979  48.577   8.464  1.00 34.43           C  
ATOM    281  O   CYS A  39      25.578  47.537   8.757  1.00 35.19           O  
ATOM    282  CB  CYS A  39      25.843  49.398   6.298  1.00 34.59           C  
ATOM    283  SG  CYS A  39      25.752  49.183   4.524  1.00 40.50           S  
ATOM    284  N   HIS A  40      24.649  49.505   9.368  1.00 33.84           N  
ATOM    285  CA  HIS A  40      25.052  49.342  10.756  1.00 33.52           C  
ATOM    286  C   HIS A  40      23.959  49.008  11.728  1.00 33.42           C  
ATOM    287  O   HIS A  40      24.211  48.928  12.919  1.00 33.53           O  
ATOM    288  CB  HIS A  40      25.976  50.470  11.235  1.00 33.67           C  
ATOM    289  CG  HIS A  40      27.291  50.477  10.517  1.00 30.94           C  
ATOM    290  ND1 HIS A  40      27.444  51.057   9.273  1.00 27.76           N  
ATOM    291  CD2 HIS A  40      28.483  49.897  10.815  1.00 31.25           C  
ATOM    292  CE1 HIS A  40      28.689  50.868   8.857  1.00 30.26           C  
ATOM    293  NE2 HIS A  40      29.345  50.194   9.786  1.00 24.82           N  
ATOM    294  N   LEU A  41      22.760  48.759  11.216  1.00 34.38           N  
ATOM    295  CA  LEU A  41      21.658  48.326  12.055  1.00 35.17           C  
ATOM    296  C   LEU A  41      21.726  46.822  12.195  1.00 35.41           C  
ATOM    297  O   LEU A  41      21.762  46.117  11.190  1.00 35.28           O  
ATOM    298  CB  LEU A  41      20.308  48.741  11.453  1.00 34.94           C  
ATOM    299  CG  LEU A  41      19.970  50.239  11.545  1.00 35.96           C  
ATOM    300  CD1 LEU A  41      18.695  50.585  10.774  1.00 33.40           C  
ATOM    301  CD2 LEU A  41      19.874  50.710  12.984  1.00 35.38           C  
ATOM    302  N   ASN A  42      21.734  46.343  13.440  1.00 35.97           N  
ATOM    303  CA  ASN A  42      21.734  44.913  13.739  1.00 36.21           C  
ATOM    304  C   ASN A  42      20.579  44.190  13.023  1.00 36.50           C  
ATOM    305  O   ASN A  42      20.750  43.091  12.499  1.00 35.85           O  
ATOM    306  CB  ASN A  42      21.703  44.655  15.259  1.00 35.69           C  
ATOM    307  CG  ASN A  42      23.043  44.957  15.961  1.00 36.68           C  
ATOM    308  OD1 ASN A  42      24.130  44.787  15.392  1.00 37.93           O  
ATOM    309  ND2 ASN A  42      22.956  45.383  17.221  1.00 35.84           N  
ATOM    310  N   GLU A  43      19.416  44.831  12.967  1.00 36.85           N  
ATOM    311  CA  GLU A  43      18.265  44.264  12.281  1.00 37.96           C  
ATOM    312  C   GLU A  43      18.588  43.944  10.817  1.00 37.40           C  
ATOM    313  O   GLU A  43      18.128  42.928  10.297  1.00 38.39           O  
ATOM    314  CB  GLU A  43      17.033  45.188  12.395  1.00 38.37           C  
ATOM    315  CG  GLU A  43      16.851  46.186  11.231  1.00 42.51           C  
ATOM    316  CD  GLU A  43      15.529  46.972  11.283  0.50 43.63           C  
ATOM    317  OE1 GLU A  43      14.954  47.117  12.379  1.00 48.32           O  
ATOM    318  OE2 GLU A  43      15.064  47.454  10.228  1.00 45.90           O  
ATOM    319  N   ASN A  44      19.396  44.794  10.172  1.00 35.82           N  
ATOM    320  CA  ASN A  44      19.782  44.577   8.787  1.00 34.72           C  
ATOM    321  C   ASN A  44      20.935  43.582   8.653  1.00 34.27           C  
ATOM    322  O   ASN A  44      20.954  42.801   7.707  1.00 33.87           O  
ATOM    323  CB  ASN A  44      20.119  45.894   8.100  1.00 34.78           C  
ATOM    324  CG  ASN A  44      18.897  46.760   7.871  1.00 35.75           C  
ATOM    325  OD1 ASN A  44      17.805  46.260   7.614  1.00 38.11           O  
ATOM    326  ND2 ASN A  44      19.080  48.059   7.944  1.00 35.86           N  
ATOM    327  N   ILE A  45      21.874  43.615   9.598  1.00 33.55           N  
ATOM    328  CA  ILE A  45      22.979  42.657   9.616  0.50 34.04           C  
ATOM    330  C   ILE A  45      22.450  41.234   9.841  1.00 34.48           C  
ATOM    331  O   ILE A  45      23.010  40.263   9.329  1.00 34.75           O  
ATOM    332  CB  ILE A  45      24.077  43.064  10.649  0.50 33.72           C  
ATOM    334  CG1 ILE A  45      25.407  42.385  10.345  0.50 32.57           C  
ATOM    336  CG2 ILE A  45      23.671  42.734  12.062  0.50 34.30           C  
ATOM    338  CD1 ILE A  45      25.492  40.978  10.839  0.50 32.19           C  
ATOM    340  N   GLU A  46      21.346  41.119  10.582  1.00 35.47           N  
ATOM    341  CA  GLU A  46      20.676  39.838  10.805  1.00 36.72           C  
ATOM    342  C   GLU A  46      19.991  39.352   9.537  1.00 37.16           C  
ATOM    343  O   GLU A  46      19.665  38.169   9.418  1.00 38.48           O  
ATOM    344  CB  GLU A  46      19.661  39.944  11.937  1.00 37.42           C  
ATOM    345  CG  GLU A  46      19.151  38.589  12.406  1.00 40.61           C  
ATOM    346  CD  GLU A  46      18.208  38.664  13.590  1.00 42.98           C  
ATOM    347  OE1 GLU A  46      17.299  37.803  13.641  1.00 48.91           O  
ATOM    348  OE2 GLU A  46      18.360  39.568  14.451  1.00 43.75           O  
ATOM    349  N   LYS A  47      19.781  40.262   8.587  1.00 37.00           N  
ATOM    350  CA  LYS A  47      19.251  39.894   7.272  1.00 37.16           C  
ATOM    351  C   LYS A  47      20.370  39.612   6.278  1.00 36.41           C  
ATOM    352  O   LYS A  47      20.116  39.481   5.081  1.00 37.55           O  
ATOM    353  CB  LYS A  47      18.328  40.973   6.701  1.00 36.87           C  
ATOM    354  CG  LYS A  47      17.206  41.448   7.627  1.00 38.74           C  
ATOM    355  CD  LYS A  47      16.260  42.343   6.854  1.00 40.02           C  
ATOM    356  CE  LYS A  47      15.549  43.340   7.746  1.00 40.90           C  
ATOM    357  NZ  LYS A  47      14.405  43.942   6.995  1.00 42.53           N  
ATOM    358  N   GLY A  48      21.602  39.527   6.765  1.00 35.58           N  
ATOM    359  CA  GLY A  48      22.739  39.151   5.918  1.00 33.36           C  
ATOM    360  C   GLY A  48      23.579  40.295   5.400  1.00 32.33           C  
ATOM    361  O   GLY A  48      24.582  40.058   4.745  1.00 31.69           O  
ATOM    362  N   LEU A  49      23.185  41.531   5.705  1.00 31.43           N  
ATOM    363  CA  LEU A  49      23.865  42.716   5.169  1.00 31.54           C  
ATOM    364  C   LEU A  49      25.310  42.801   5.641  1.00 30.90           C  
ATOM    365  O   LEU A  49      25.577  42.722   6.842  1.00 31.66           O  
ATOM    366  CB  LEU A  49      23.107  43.987   5.549  1.00 31.27           C  
ATOM    367  CG  LEU A  49      23.031  45.092   4.505  1.00 32.72           C  
ATOM    368  CD1 LEU A  49      22.357  44.566   3.250  1.00 29.74           C  
ATOM    369  CD2 LEU A  49      22.254  46.313   5.051  1.00 30.98           C  
ATOM    370  N   LEU A  50      26.224  42.946   4.679  1.00 30.59           N  
ATOM    371  CA  LEU A  50      27.683  42.882   4.878  1.00 29.33           C  
ATOM    372  C   LEU A  50      28.342  43.940   3.970  1.00 28.63           C  
ATOM    373  O   LEU A  50      28.021  44.016   2.791  1.00 30.57           O  
ATOM    374  CB  LEU A  50      28.160  41.469   4.515  1.00 28.82           C  
ATOM    375  CG  LEU A  50      29.656  41.145   4.479  1.00 28.53           C  
ATOM    376  CD1 LEU A  50      30.227  41.198   5.853  1.00 25.02           C  
ATOM    377  CD2 LEU A  50      29.911  39.783   3.870  1.00 28.09           C  
ATOM    378  N   HIS A  51      29.227  44.779   4.507  1.00 28.41           N  
ATOM    379  CA  HIS A  51      29.814  45.883   3.728  1.00 28.27           C  
ATOM    380  C   HIS A  51      31.361  45.865   3.742  1.00 29.66           C  
ATOM    381  O   HIS A  51      31.968  45.227   4.602  1.00 30.19           O  
ATOM    382  CB  HIS A  51      29.255  47.259   4.160  1.00 27.30           C  
ATOM    383  CG  HIS A  51      29.498  47.594   5.600  1.00 27.09           C  
ATOM    384  ND1 HIS A  51      28.792  47.011   6.629  1.00 24.80           N  
ATOM    385  CD2 HIS A  51      30.381  48.436   6.185  1.00 24.62           C  
ATOM    386  CE1 HIS A  51      29.238  47.462   7.787  1.00 22.99           C  
ATOM    387  NE2 HIS A  51      30.203  48.332   7.547  1.00 24.71           N  
ATOM    388  N   ARG A  52      31.983  46.572   2.792  1.00 30.54           N  
ATOM    389  CA  ARG A  52      33.436  46.705   2.728  1.00 31.00           C  
ATOM    390  C   ARG A  52      33.951  47.810   3.656  1.00 31.45           C  
ATOM    391  O   ARG A  52      33.298  48.860   3.837  1.00 32.68           O  
ATOM    392  CB  ARG A  52      33.936  46.912   1.277  1.00 31.23           C  
ATOM    393  CG  ARG A  52      35.463  46.624   1.083  1.00 29.95           C  
ATOM    394  CD  ARG A  52      35.928  46.794  -0.371  1.00 27.16           C  
ATOM    395  NE  ARG A  52      35.268  45.815  -1.214  1.00 19.50           N  
ATOM    396  CZ  ARG A  52      35.023  45.957  -2.501  1.00 13.98           C  
ATOM    397  NH1 ARG A  52      35.371  47.054  -3.162  1.00 17.96           N  
ATOM    398  NH2 ARG A  52      34.427  44.975  -3.133  1.00 19.15           N  
ATOM    399  N   ALA A  53      35.125  47.557   4.234  1.00 30.27           N  
ATOM    400  CA  ALA A  53      35.710  48.399   5.256  1.00 29.40           C  
ATOM    401  C   ALA A  53      37.222  48.344   5.215  1.00 30.22           C  
ATOM    402  O   ALA A  53      37.806  47.449   4.572  1.00 29.85           O  
ATOM    403  CB  ALA A  53      35.225  47.947   6.637  1.00 29.50           C  
ATOM    404  N   PHE A  54      37.860  49.281   5.926  1.00 30.06           N  
ATOM    405  CA  PHE A  54      39.308  49.246   6.102  1.00 30.94           C  
ATOM    406  C   PHE A  54      39.755  49.645   7.519  1.00 31.30           C  
ATOM    407  O   PHE A  54      39.086  50.432   8.220  1.00 29.94           O  
ATOM    408  CB  PHE A  54      40.002  50.115   5.040  1.00 31.17           C  
ATOM    409  CG  PHE A  54      39.703  51.573   5.182  1.00 32.17           C  
ATOM    410  CD1 PHE A  54      40.431  52.358   6.083  1.00 31.95           C  
ATOM    411  CD2 PHE A  54      38.656  52.160   4.456  1.00 32.29           C  
ATOM    412  CE1 PHE A  54      40.136  53.724   6.250  1.00 32.52           C  
ATOM    413  CE2 PHE A  54      38.352  53.504   4.625  1.00 29.65           C  
ATOM    414  CZ  PHE A  54      39.093  54.292   5.513  1.00 29.67           C  
ATOM    415  N   SER A  55      40.889  49.083   7.931  1.00 30.64           N  
ATOM    416  CA  SER A  55      41.565  49.432   9.176  1.00 32.25           C  
ATOM    417  C   SER A  55      43.009  49.795   8.909  1.00 32.87           C  
ATOM    418  O   SER A  55      43.767  48.991   8.328  1.00 33.63           O  
ATOM    419  CB  SER A  55      41.540  48.264  10.158  1.00 32.97           C  
ATOM    420  OG  SER A  55      40.436  48.349  11.035  1.00 35.81           O  
ATOM    421  N   VAL A  56      43.398  50.987   9.349  1.00 32.43           N  
ATOM    422  CA  VAL A  56      44.766  51.482   9.192  1.00 31.98           C  
ATOM    423  C   VAL A  56      45.505  51.299  10.505  1.00 32.48           C  
ATOM    424  O   VAL A  56      44.950  51.540  11.572  1.00 32.19           O  
ATOM    425  CB  VAL A  56      44.816  52.975   8.758  1.00 31.73           C  
ATOM    426  CG1 VAL A  56      46.262  53.445   8.564  1.00 32.58           C  
ATOM    427  CG2 VAL A  56      43.991  53.218   7.474  1.00 29.62           C  
ATOM    428  N   PHE A  57      46.743  50.816  10.418  1.00 32.54           N  
ATOM    429  CA  PHE A  57      47.668  50.807  11.546  1.00 32.28           C  
ATOM    430  C   PHE A  57      48.883  51.631  11.137  1.00 32.75           C  
ATOM    431  O   PHE A  57      49.653  51.218  10.253  1.00 33.07           O  
ATOM    432  CB  PHE A  57      48.087  49.386  11.894  1.00 32.28           C  
ATOM    433  CG  PHE A  57      46.961  48.514  12.381  1.00 32.35           C  
ATOM    434  CD1 PHE A  57      46.903  48.110  13.716  1.00 32.16           C  
ATOM    435  CD2 PHE A  57      45.960  48.085  11.514  1.00 31.64           C  
ATOM    436  CE1 PHE A  57      45.863  47.284  14.177  1.00 30.01           C  
ATOM    437  CE2 PHE A  57      44.913  47.273  11.979  1.00 31.17           C  
ATOM    438  CZ  PHE A  57      44.881  46.867  13.303  1.00 29.70           C  
ATOM    439  N   LEU A  58      49.039  52.801  11.753  1.00 32.33           N  
ATOM    440  CA  LEU A  58      50.130  53.716  11.411  1.00 32.79           C  
ATOM    441  C   LEU A  58      51.207  53.715  12.489  1.00 33.22           C  
ATOM    442  O   LEU A  58      50.940  53.994  13.647  1.00 32.33           O  
ATOM    443  CB  LEU A  58      49.605  55.133  11.140  1.00 32.71           C  
ATOM    444  CG  LEU A  58      50.595  56.187  10.608  1.00 33.78           C  
ATOM    445  CD1 LEU A  58      49.908  57.248   9.757  1.00 35.09           C  
ATOM    446  CD2 LEU A  58      51.380  56.851  11.741  1.00 32.89           C  
ATOM    447  N   PHE A  59      52.426  53.359  12.084  1.00 33.72           N  
ATOM    448  CA  PHE A  59      53.589  53.348  12.960  1.00 33.98           C  
ATOM    449  C   PHE A  59      54.471  54.545  12.598  1.00 36.00           C  
ATOM    450  O   PHE A  59      54.644  54.858  11.415  1.00 37.49           O  
ATOM    451  CB  PHE A  59      54.377  52.034  12.811  1.00 33.15           C  
ATOM    452  CG  PHE A  59      53.559  50.781  13.095  1.00 30.39           C  
ATOM    453  CD1 PHE A  59      53.606  50.176  14.337  1.00 26.93           C  
ATOM    454  CD2 PHE A  59      52.768  50.199  12.105  1.00 27.93           C  
ATOM    455  CE1 PHE A  59      52.876  49.038  14.606  1.00 25.61           C  
ATOM    456  CE2 PHE A  59      52.026  49.050  12.379  1.00 25.20           C  
ATOM    457  CZ  PHE A  59      52.087  48.475  13.639  1.00 24.95           C  
ATOM    458  N   ASN A  60      55.006  55.245  13.595  1.00 37.44           N  
ATOM    459  CA  ASN A  60      55.996  56.284  13.307  1.00 38.94           C  
ATOM    460  C   ASN A  60      57.399  55.677  13.121  1.00 40.59           C  
ATOM    461  O   ASN A  60      57.542  54.456  13.115  1.00 40.67           O  
ATOM    462  CB  ASN A  60      55.959  57.414  14.344  1.00 38.67           C  
ATOM    463  CG  ASN A  60      56.506  57.008  15.706  1.00 40.17           C  
ATOM    464  OD1 ASN A  60      57.144  55.961  15.870  1.00 37.01           O  
ATOM    465  ND2 ASN A  60      56.270  57.859  16.696  1.00 37.00           N  
ATOM    466  N   THR A  61      58.422  56.509  12.963  1.00 42.82           N  
ATOM    467  CA  THR A  61      59.772  55.988  12.690  1.00 44.84           C  
ATOM    468  C   THR A  61      60.485  55.448  13.936  1.00 45.58           C  
ATOM    469  O   THR A  61      61.506  54.775  13.825  1.00 46.05           O  
ATOM    470  CB  THR A  61      60.655  56.992  11.908  1.00 44.92           C  
ATOM    471  OG1 THR A  61      60.655  58.254  12.574  1.00 46.64           O  
ATOM    472  CG2 THR A  61      60.118  57.192  10.502  1.00 45.71           C  
ATOM    473  N   GLU A  62      59.927  55.725  15.112  1.00 45.83           N  
ATOM    474  CA  GLU A  62      60.332  55.053  16.345  1.00 46.08           C  
ATOM    475  C   GLU A  62      59.634  53.693  16.498  1.00 45.09           C  
ATOM    476  O   GLU A  62      59.752  53.046  17.535  1.00 44.84           O  
ATOM    477  CB  GLU A  62      59.989  55.917  17.556  1.00 46.96           C  
ATOM    478  CG  GLU A  62      60.891  57.130  17.790  1.00 50.54           C  
ATOM    479  CD  GLU A  62      60.461  57.933  19.007  0.10 51.62           C  
ATOM    480  OE1 GLU A  62      61.298  58.140  19.911  0.10 55.67           O  
ATOM    481  OE2 GLU A  62      59.284  58.346  19.066  0.10 54.10           O  
ATOM    482  N   ASN A  63      58.912  53.276  15.455  1.00 44.51           N  
ATOM    483  CA  ASN A  63      58.083  52.050  15.439  1.00 43.32           C  
ATOM    484  C   ASN A  63      56.969  52.012  16.504  1.00 41.84           C  
ATOM    485  O   ASN A  63      56.615  50.953  17.018  1.00 41.70           O  
ATOM    486  CB  ASN A  63      58.944  50.770  15.457  1.00 44.23           C  
ATOM    487  CG  ASN A  63      59.891  50.679  14.260  1.00 46.57           C  
ATOM    488  OD1 ASN A  63      59.466  50.694  13.101  1.00 48.07           O  
ATOM    489  ND2 ASN A  63      61.187  50.584  14.542  1.00 50.35           N  
ATOM    490  N   LYS A  64      56.419  53.174  16.826  1.00 40.14           N  
ATOM    491  CA  LYS A  64      55.284  53.251  17.742  1.00 38.45           C  
ATOM    492  C   LYS A  64      53.979  53.304  16.962  1.00 36.13           C  
ATOM    493  O   LYS A  64      53.869  54.038  15.976  1.00 35.44           O  
ATOM    494  CB  LYS A  64      55.398  54.469  18.668  1.00 38.94           C  
ATOM    495  CG  LYS A  64      56.450  54.330  19.769  1.00 40.59           C  
ATOM    496  CD  LYS A  64      56.274  55.427  20.793  1.00 44.11           C  
ATOM    497  CE  LYS A  64      57.145  55.194  22.003  1.00 46.57           C  
ATOM    498  NZ  LYS A  64      56.786  56.110  23.118  1.00 49.64           N  
ATOM    499  N   LEU A  65      53.004  52.517  17.413  1.00 33.92           N  
ATOM    500  CA  LEU A  65      51.682  52.484  16.812  1.00 33.16           C  
ATOM    501  C   LEU A  65      50.849  53.677  17.299  1.00 33.13           C  
ATOM    502  O   LEU A  65      50.769  53.923  18.505  1.00 32.48           O  
ATOM    503  CB  LEU A  65      50.966  51.164  17.153  1.00 33.16           C  
ATOM    504  CG  LEU A  65      49.504  50.957  16.721  1.00 31.10           C  
ATOM    505  CD1 LEU A  65      49.282  51.137  15.203  1.00 29.46           C  
ATOM    506  CD2 LEU A  65      49.056  49.584  17.160  1.00 34.40           C  
ATOM    507  N   LEU A  66      50.247  54.402  16.355  1.00 32.25           N  
ATOM    508  CA  LEU A  66      49.328  55.478  16.696  1.00 31.67           C  
ATOM    509  C   LEU A  66      47.958  54.900  16.988  1.00 32.12           C  
ATOM    510  O   LEU A  66      47.318  54.301  16.125  1.00 33.84           O  
ATOM    511  CB  LEU A  66      49.246  56.523  15.577  1.00 31.86           C  
ATOM    512  CG  LEU A  66      48.291  57.726  15.772  1.00 30.16           C  
ATOM    513  CD1 LEU A  66      48.553  58.474  17.070  1.00 27.32           C  
ATOM    514  CD2 LEU A  66      48.398  58.674  14.612  1.00 30.79           C  
ATOM    515  N   LEU A  67      47.511  55.078  18.222  1.00 31.84           N  
ATOM    516  CA  LEU A  67      46.197  54.634  18.616  1.00 31.66           C  
ATOM    517  C   LEU A  67      45.274  55.832  18.776  1.00 31.54           C  
ATOM    518  O   LEU A  67      45.709  56.935  19.135  1.00 30.25           O  
ATOM    519  CB  LEU A  67      46.236  53.893  19.947  1.00 31.43           C  
ATOM    520  CG  LEU A  67      47.020  52.592  20.111  1.00 33.22           C  
ATOM    521  CD1 LEU A  67      46.874  52.165  21.577  1.00 32.11           C  
ATOM    522  CD2 LEU A  67      46.554  51.494  19.147  1.00 31.33           C  
ATOM    523  N   GLN A  68      43.995  55.591  18.530  1.00 31.77           N  
ATOM    524  CA  GLN A  68      42.990  56.605  18.790  1.00 32.32           C  
ATOM    525  C   GLN A  68      41.970  56.107  19.810  1.00 33.12           C  
ATOM    526  O   GLN A  68      41.806  54.892  19.999  1.00 33.06           O  
ATOM    527  CB  GLN A  68      42.340  57.055  17.476  1.00 31.78           C  
ATOM    528  CG  GLN A  68      41.445  56.037  16.814  1.00 30.63           C  
ATOM    529  CD  GLN A  68      40.396  56.691  15.951  1.00 34.55           C  
ATOM    530  OE1 GLN A  68      40.668  57.087  14.804  1.00 35.50           O  
ATOM    531  NE2 GLN A  68      39.182  56.838  16.502  1.00 33.12           N  
ATOM    532  N   GLN A  69      41.324  57.055  20.496  1.00 33.71           N  
ATOM    533  CA  GLN A  69      40.153  56.762  21.288  1.00 33.58           C  
ATOM    534  C   GLN A  69      38.987  57.456  20.627  1.00 33.58           C  
ATOM    535  O   GLN A  69      39.007  58.668  20.437  1.00 32.87           O  
ATOM    536  CB  GLN A  69      40.278  57.244  22.736  1.00 34.26           C  
ATOM    537  CG  GLN A  69      39.138  56.695  23.616  1.00 34.40           C  
ATOM    538  CD  GLN A  69      39.070  57.286  25.012  1.00 34.98           C  
ATOM    539  OE1 GLN A  69      39.745  58.261  25.326  1.00 38.37           O  
ATOM    540  NE2 GLN A  69      38.245  56.684  25.864  1.00 34.07           N  
ATOM    541  N   ARG A  70      37.978  56.661  20.283  1.00 33.48           N  
ATOM    542  CA  ARG A  70      36.804  57.143  19.592  1.00 34.48           C  
ATOM    543  C   ARG A  70      36.085  58.132  20.502  1.00 34.56           C  
ATOM    544  O   ARG A  70      35.969  57.884  21.694  1.00 34.53           O  
ATOM    545  CB  ARG A  70      35.877  55.965  19.246  1.00 34.55           C  
ATOM    546  CG  ARG A  70      36.452  54.980  18.231  1.00 33.44           C  
ATOM    547  CD  ARG A  70      35.601  53.739  18.098  1.00 33.60           C  
ATOM    548  NE  ARG A  70      34.362  53.931  17.349  1.00 31.70           N  
ATOM    549  CZ  ARG A  70      34.300  54.027  16.023  1.00 33.41           C  
ATOM    550  NH1 ARG A  70      35.404  53.968  15.284  1.00 34.77           N  
ATOM    551  NH2 ARG A  70      33.130  54.196  15.422  1.00 35.85           N  
ATOM    552  N   SER A  71      35.632  59.255  19.947  1.00 36.06           N  
ATOM    553  CA  SER A  71      34.885  60.242  20.729  1.00 37.29           C  
ATOM    554  C   SER A  71      33.618  59.604  21.282  1.00 38.60           C  
ATOM    555  O   SER A  71      33.213  58.532  20.829  1.00 38.50           O  
ATOM    556  CB  SER A  71      34.517  61.437  19.862  1.00 36.82           C  
ATOM    557  OG  SER A  71      33.550  61.062  18.904  1.00 38.76           O  
ATOM    558  N   ASP A  72      32.990  60.273  22.251  1.00 39.78           N  
ATOM    559  CA  ASP A  72      31.689  59.857  22.758  1.00 40.71           C  
ATOM    560  C   ASP A  72      30.553  60.121  21.749  1.00 40.27           C  
ATOM    561  O   ASP A  72      29.444  59.630  21.922  1.00 40.86           O  
ATOM    562  CB  ASP A  72      31.412  60.544  24.099  1.00 42.30           C  
ATOM    563  CG  ASP A  72      32.395  60.118  25.183  1.00 45.40           C  
ATOM    564  OD1 ASP A  72      32.630  58.898  25.323  1.00 49.90           O  
ATOM    565  OD2 ASP A  72      32.929  60.993  25.901  1.00 48.14           O  
ATOM    566  N   ALA A  73      30.856  60.869  20.689  1.00 39.28           N  
ATOM    567  CA  ALA A  73      29.913  61.153  19.601  1.00 38.32           C  
ATOM    568  C   ALA A  73      29.665  59.990  18.638  1.00 37.84           C  
ATOM    569  O   ALA A  73      28.616  59.924  17.983  1.00 38.24           O  
ATOM    570  CB  ALA A  73      30.382  62.359  18.827  1.00 38.02           C  
ATOM    571  N   LYS A  74      30.636  59.085  18.519  1.00 36.42           N  
ATOM    572  CA  LYS A  74      30.506  57.969  17.595  1.00 34.91           C  
ATOM    573  C   LYS A  74      29.311  57.092  17.955  1.00 34.31           C  
ATOM    574  O   LYS A  74      29.069  56.808  19.120  1.00 34.64           O  
ATOM    575  CB  LYS A  74      31.808  57.159  17.538  1.00 33.81           C  
ATOM    576  CG  LYS A  74      33.023  58.009  17.248  1.00 30.76           C  
ATOM    577  CD  LYS A  74      32.947  58.697  15.876  1.00 29.36           C  
ATOM    578  CE  LYS A  74      33.047  57.682  14.739  1.00 28.87           C  
ATOM    579  NZ  LYS A  74      32.950  58.291  13.379  1.00 26.82           N  
ATOM    580  N   ILE A  75      28.570  56.687  16.935  1.00 33.82           N  
ATOM    581  CA  ILE A  75      27.348  55.927  17.103  1.00 33.75           C  
ATOM    582  C   ILE A  75      27.628  54.471  17.441  1.00 34.65           C  
ATOM    583  O   ILE A  75      26.893  53.857  18.217  1.00 35.22           O  
ATOM    584  CB  ILE A  75      26.465  56.057  15.848  1.00 34.11           C  
ATOM    585  CG1 ILE A  75      26.058  57.522  15.676  1.00 32.79           C  
ATOM    586  CG2 ILE A  75      25.225  55.179  15.953  1.00 34.02           C  
ATOM    587  CD1 ILE A  75      25.379  57.811  14.377  1.00 31.99           C  
ATOM    588  N   THR A  76      28.684  53.917  16.847  1.00 34.41           N  
ATOM    589  CA  THR A  76      29.159  52.594  17.211  1.00 33.47           C  
ATOM    590  C   THR A  76      30.433  52.746  18.051  1.00 33.46           C  
ATOM    591  O   THR A  76      31.279  53.582  17.755  1.00 33.52           O  
ATOM    592  CB  THR A  76      29.424  51.700  15.965  1.00 33.52           C  
ATOM    593  OG1 THR A  76      30.288  52.379  15.055  1.00 33.64           O  
ATOM    594  CG2 THR A  76      28.127  51.353  15.224  1.00 32.52           C  
ATOM    595  N   PHE A  77      30.530  51.966  19.127  1.00 34.41           N  
ATOM    596  CA  PHE A  77      31.740  51.875  19.978  1.00 35.20           C  
ATOM    597  C   PHE A  77      32.364  53.204  20.428  1.00 35.52           C  
ATOM    598  O   PHE A  77      33.574  53.386  20.324  1.00 35.11           O  
ATOM    599  CB  PHE A  77      32.820  50.981  19.317  1.00 35.17           C  
ATOM    600  CG  PHE A  77      32.278  49.709  18.731  1.00 35.56           C  
ATOM    601  CD1 PHE A  77      31.917  48.639  19.555  1.00 35.55           C  
ATOM    602  CD2 PHE A  77      32.123  49.579  17.356  1.00 34.74           C  
ATOM    603  CE1 PHE A  77      31.401  47.462  19.009  1.00 33.72           C  
ATOM    604  CE2 PHE A  77      31.605  48.411  16.803  1.00 32.18           C  
ATOM    605  CZ  PHE A  77      31.241  47.352  17.626  1.00 33.52           C  
ATOM    606  N   PRO A  78      31.541  54.139  20.952  1.00 35.37           N  
ATOM    607  CA  PRO A  78      32.131  55.374  21.467  1.00 34.52           C  
ATOM    608  C   PRO A  78      33.006  55.131  22.681  1.00 34.09           C  
ATOM    609  O   PRO A  78      32.746  54.228  23.464  1.00 35.45           O  
ATOM    610  CB  PRO A  78      30.900  56.209  21.886  1.00 35.07           C  
ATOM    611  CG  PRO A  78      29.812  55.203  22.098  1.00 35.28           C  
ATOM    612  CD  PRO A  78      30.070  54.123  21.085  1.00 35.10           C  
ATOM    613  N   GLY A  79      34.025  55.957  22.857  1.00 33.93           N  
ATOM    614  CA  GLY A  79      34.910  55.859  24.000  1.00 33.91           C  
ATOM    615  C   GLY A  79      35.949  54.757  23.877  1.00 34.58           C  
ATOM    616  O   GLY A  79      36.778  54.593  24.764  1.00 35.72           O  
ATOM    617  N   CYS A  80      35.917  54.004  22.790  1.00 34.70           N  
ATOM    618  CA  CYS A  80      36.767  52.817  22.666  1.00 35.81           C  
ATOM    619  C   CYS A  80      38.145  53.106  22.081  1.00 36.28           C  
ATOM    620  O   CYS A  80      38.274  53.862  21.120  1.00 37.28           O  
ATOM    621  CB  CYS A  80      36.061  51.761  21.812  1.00 35.78           C  
ATOM    622  SG  CYS A  80      34.667  50.898  22.604  1.00 38.05           S  
ATOM    623  N   PHE A  81      39.177  52.499  22.661  1.00 36.44           N  
ATOM    624  CA  PHE A  81      40.529  52.542  22.084  1.00 36.16           C  
ATOM    625  C   PHE A  81      40.667  51.556  20.934  1.00 35.99           C  
ATOM    626  O   PHE A  81      40.091  50.460  20.951  1.00 35.23           O  
ATOM    627  CB  PHE A  81      41.598  52.277  23.142  1.00 36.54           C  
ATOM    628  CG  PHE A  81      41.841  53.440  24.060  1.00 37.57           C  
ATOM    629  CD1 PHE A  81      42.802  54.394  23.751  1.00 39.68           C  
ATOM    630  CD2 PHE A  81      41.104  53.583  25.235  1.00 37.66           C  
ATOM    631  CE1 PHE A  81      43.025  55.481  24.593  1.00 40.03           C  
ATOM    632  CE2 PHE A  81      41.326  54.657  26.087  1.00 38.29           C  
ATOM    633  CZ  PHE A  81      42.287  55.609  25.768  1.00 38.77           C  
ATOM    634  N   THR A  82      41.438  51.949  19.930  1.00 35.58           N  
ATOM    635  CA  THR A  82      41.421  51.253  18.655  1.00 35.30           C  
ATOM    636  C   THR A  82      42.612  51.702  17.835  1.00 34.99           C  
ATOM    637  O   THR A  82      43.287  52.673  18.203  1.00 34.32           O  
ATOM    638  CB  THR A  82      40.072  51.515  17.913  1.00 35.94           C  
ATOM    639  OG1 THR A  82      39.955  50.677  16.760  1.00 37.81           O  
ATOM    640  CG2 THR A  82      39.940  52.969  17.507  1.00 35.69           C  
ATOM    641  N   ASN A  83      42.874  50.987  16.742  1.00 34.87           N  
ATOM    642  CA  ASN A  83      43.968  51.319  15.842  1.00 35.54           C  
ATOM    643  C   ASN A  83      43.776  52.673  15.210  1.00 35.58           C  
ATOM    644  O   ASN A  83      42.735  53.305  15.395  1.00 35.41           O  
ATOM    645  CB  ASN A  83      44.102  50.273  14.749  1.00 35.86           C  
ATOM    646  CG  ASN A  83      42.807  50.049  14.012  1.00 36.07           C  
ATOM    647  OD1 ASN A  83      41.893  49.395  14.528  1.00 36.89           O  
ATOM    648  ND2 ASN A  83      42.711  50.592  12.804  1.00 33.60           N  
ATOM    649  N   THR A  84      44.778  53.090  14.442  1.00 35.17           N  
ATOM    650  CA  THR A  84      44.902  54.449  13.917  1.00 34.91           C  
ATOM    651  C   THR A  84      43.602  55.072  13.383  1.00 35.30           C  
ATOM    652  O   THR A  84      43.225  56.162  13.804  1.00 34.30           O  
ATOM    653  CB  THR A  84      46.024  54.523  12.856  1.00 35.55           C  
ATOM    654  OG1 THR A  84      47.184  53.824  13.342  1.00 32.99           O  
ATOM    655  CG2 THR A  84      46.405  55.972  12.556  1.00 36.21           C  
ATOM    656  N   CYS A  85      42.933  54.362  12.473  1.00 35.58           N  
ATOM    657  CA  CYS A  85      41.806  54.893  11.706  1.00 34.95           C  
ATOM    658  C   CYS A  85      41.069  53.770  10.988  1.00 34.76           C  
ATOM    659  O   CYS A  85      41.686  52.954  10.298  1.00 34.81           O  
ATOM    660  CB  CYS A  85      42.309  55.931  10.700  1.00 35.20           C  
ATOM    661  SG  CYS A  85      41.142  56.559   9.488  1.00 36.88           S  
ATOM    662  N   CYS A  86      39.755  53.711  11.182  1.00 34.49           N  
ATOM    663  CA  CYS A  86      38.891  52.814  10.410  1.00 34.53           C  
ATOM    664  C   CYS A  86      37.760  53.554   9.720  1.00 33.51           C  
ATOM    665  O   CYS A  86      37.259  54.562  10.237  1.00 31.92           O  
ATOM    666  CB  CYS A  86      38.223  51.777  11.311  1.00 34.80           C  
ATOM    667  SG  CYS A  86      39.289  50.834  12.328  1.00 41.28           S  
ATOM    668  N   SER A  87      37.353  53.034   8.561  1.00 32.12           N  
ATOM    669  CA  SER A  87      36.117  53.459   7.915  0.50 31.07           C  
ATOM    671  C   SER A  87      35.737  52.512   6.786  1.00 31.15           C  
ATOM    672  O   SER A  87      36.106  51.312   6.807  1.00 30.76           O  
ATOM    673  CB  SER A  87      36.208  54.919   7.426  0.50 31.45           C  
ATOM    675  OG  SER A  87      34.981  55.373   6.883  0.50 25.44           O  
ATOM    677  N   HIS A  88      35.005  53.061   5.817  1.00 31.16           N  
ATOM    678  CA  HIS A  88      34.452  52.337   4.702  1.00 31.74           C  
ATOM    679  C   HIS A  88      34.823  53.052   3.427  1.00 32.03           C  
ATOM    680  O   HIS A  88      34.780  54.277   3.372  1.00 31.48           O  
ATOM    681  CB  HIS A  88      32.916  52.260   4.843  1.00 31.18           C  
ATOM    682  CG  HIS A  88      32.462  51.873   6.216  1.00 31.73           C  
ATOM    683  ND1 HIS A  88      31.789  52.743   7.054  1.00 29.81           N  
ATOM    684  CD2 HIS A  88      32.619  50.722   6.915  1.00 31.79           C  
ATOM    685  CE1 HIS A  88      31.554  52.142   8.208  1.00 31.32           C  
ATOM    686  NE2 HIS A  88      32.031  50.906   8.146  1.00 30.97           N  
ATOM    687  N   PRO A  89      35.229  52.288   2.402  1.00 33.47           N  
ATOM    688  CA  PRO A  89      35.291  52.834   1.042  1.00 34.48           C  
ATOM    689  C   PRO A  89      33.880  53.192   0.580  1.00 35.94           C  
ATOM    690  O   PRO A  89      32.927  52.447   0.851  1.00 35.93           O  
ATOM    691  CB  PRO A  89      35.860  51.669   0.208  1.00 33.86           C  
ATOM    692  CG  PRO A  89      35.607  50.453   1.003  1.00 32.43           C  
ATOM    693  CD  PRO A  89      35.652  50.876   2.452  1.00 33.74           C  
ATOM    694  N   LEU A  90      33.741  54.336  -0.084  1.00 36.97           N  
ATOM    695  CA  LEU A  90      32.423  54.831  -0.439  1.00 37.14           C  
ATOM    696  C   LEU A  90      31.984  54.188  -1.735  1.00 37.07           C  
ATOM    697  O   LEU A  90      32.807  53.797  -2.549  1.00 36.24           O  
ATOM    698  CB  LEU A  90      32.413  56.361  -0.567  1.00 37.53           C  
ATOM    699  CG  LEU A  90      32.612  57.208   0.691  1.00 39.71           C  
ATOM    700  CD1 LEU A  90      32.797  58.673   0.325  1.00 40.56           C  
ATOM    701  CD2 LEU A  90      31.467  57.048   1.660  1.00 41.28           C  
ATOM    702  N   SER A  91      30.676  54.079  -1.925  1.00 37.03           N  
ATOM    703  CA  SER A  91      30.171  53.602  -3.186  1.00 37.31           C  
ATOM    704  C   SER A  91      30.214  54.694  -4.259  1.00 37.21           C  
ATOM    705  O   SER A  91      29.178  55.101  -4.782  1.00 37.88           O  
ATOM    706  CB  SER A  91      28.771  53.023  -3.026  1.00 37.71           C  
ATOM    707  OG  SER A  91      28.404  52.316  -4.190  1.00 39.15           O  
ATOM    708  N   ASN A  92      31.420  55.166  -4.572  1.00 35.86           N  
ATOM    709  CA  ASN A  92      31.635  56.068  -5.705  1.00 35.45           C  
ATOM    710  C   ASN A  92      32.765  55.534  -6.623  1.00 35.69           C  
ATOM    711  O   ASN A  92      33.517  54.653  -6.202  1.00 36.18           O  
ATOM    712  CB  ASN A  92      31.864  57.510  -5.222  1.00 35.20           C  
ATOM    713  CG  ASN A  92      33.215  57.725  -4.540  1.00 34.07           C  
ATOM    714  OD1 ASN A  92      34.258  57.178  -4.956  1.00 32.30           O  
ATOM    715  ND2 ASN A  92      33.215  58.563  -3.513  1.00 27.85           N  
ATOM    716  N   PRO A  93      32.868  56.024  -7.883  1.00 35.62           N  
ATOM    717  CA  PRO A  93      33.891  55.452  -8.782  1.00 35.06           C  
ATOM    718  C   PRO A  93      35.349  55.587  -8.334  1.00 34.91           C  
ATOM    719  O   PRO A  93      36.211  54.786  -8.763  1.00 34.72           O  
ATOM    720  CB  PRO A  93      33.661  56.204 -10.100  1.00 34.84           C  
ATOM    721  CG  PRO A  93      32.927  57.433  -9.723  1.00 36.45           C  
ATOM    722  CD  PRO A  93      32.053  57.039  -8.574  1.00 35.20           C  
ATOM    723  N   ALA A  94      35.637  56.585  -7.498  1.00 33.92           N  
ATOM    724  CA  ALA A  94      36.976  56.744  -6.949  1.00 33.67           C  
ATOM    725  C   ALA A  94      37.294  55.589  -6.008  1.00 34.00           C  
ATOM    726  O   ALA A  94      38.376  54.992  -6.078  1.00 33.61           O  
ATOM    727  CB  ALA A  94      37.149  58.099  -6.235  1.00 33.11           C  
ATOM    728  N   GLU A  95      36.331  55.251  -5.156  1.00 32.48           N  
ATOM    729  CA  GLU A  95      36.600  54.305  -4.077  1.00 32.03           C  
ATOM    730  C   GLU A  95      36.046  52.913  -4.315  1.00 31.51           C  
ATOM    731  O   GLU A  95      36.222  52.029  -3.482  1.00 32.05           O  
ATOM    732  CB  GLU A  95      36.151  54.885  -2.740  1.00 30.56           C  
ATOM    733  CG  GLU A  95      36.895  56.160  -2.411  1.00 32.40           C  
ATOM    734  CD  GLU A  95      36.579  56.688  -1.035  1.00 35.63           C  
ATOM    735  OE1 GLU A  95      35.769  56.058  -0.313  1.00 34.49           O  
ATOM    736  OE2 GLU A  95      37.147  57.744  -0.673  1.00 38.40           O  
ATOM    737  N   LEU A  96      35.412  52.703  -5.463  1.00 32.08           N  
ATOM    738  CA  LEU A  96      34.989  51.365  -5.837  1.00 33.01           C  
ATOM    739  C   LEU A  96      36.139  50.694  -6.569  1.00 33.98           C  
ATOM    740  O   LEU A  96      36.110  49.497  -6.780  1.00 34.60           O  
ATOM    741  CB  LEU A  96      33.752  51.396  -6.734  1.00 33.17           C  
ATOM    742  CG  LEU A  96      32.368  51.561  -6.097  1.00 32.72           C  
ATOM    743  CD1 LEU A  96      31.423  52.145  -7.134  1.00 34.22           C  
ATOM    744  CD2 LEU A  96      31.833  50.243  -5.559  1.00 31.24           C  
ATOM    745  N   GLU A  97      37.135  51.486  -6.957  1.00 34.47           N  
ATOM    746  CA  GLU A  97      38.231  50.994  -7.803  1.00 36.99           C  
ATOM    747  C   GLU A  97      38.909  49.802  -7.162  1.00 37.25           C  
ATOM    748  O   GLU A  97      39.427  49.897  -6.055  1.00 37.18           O  
ATOM    749  CB  GLU A  97      39.244  52.109  -8.092  1.00 37.32           C  
ATOM    750  CG  GLU A  97      40.431  51.688  -8.954  1.00 37.49           C  
ATOM    751  CD  GLU A  97      40.011  51.281 -10.361  1.00 40.73           C  
ATOM    752  OE1 GLU A  97      39.488  52.139 -11.121  1.00 40.49           O  
ATOM    753  OE2 GLU A  97      40.222  50.096 -10.720  1.00 41.14           O  
ATOM    754  N   GLU A  98      38.901  48.677  -7.866  1.00 39.98           N  
ATOM    755  CA  GLU A  98      39.458  47.439  -7.328  1.00 41.69           C  
ATOM    756  C   GLU A  98      40.850  47.053  -7.830  1.00 42.46           C  
ATOM    757  O   GLU A  98      41.497  46.183  -7.245  1.00 42.84           O  
ATOM    758  CB  GLU A  98      38.477  46.290  -7.513  1.00 42.56           C  
ATOM    759  CG  GLU A  98      37.277  46.418  -6.599  1.00 44.95           C  
ATOM    760  CD  GLU A  98      36.658  45.092  -6.276  1.00 48.35           C  
ATOM    761  OE1 GLU A  98      37.422  44.169  -5.895  1.00 51.73           O  
ATOM    762  OE2 GLU A  98      35.417  44.974  -6.403  1.00 48.82           O  
ATOM    763  N   SER A  99      41.312  47.700  -8.896  1.00 43.29           N  
ATOM    764  CA  SER A  99      42.680  47.525  -9.359  1.00 43.67           C  
ATOM    765  C   SER A  99      43.627  47.892  -8.218  1.00 43.62           C  
ATOM    766  O   SER A  99      43.640  49.040  -7.762  1.00 43.35           O  
ATOM    767  CB  SER A  99      42.966  48.405 -10.584  1.00 43.80           C  
ATOM    768  OG  SER A  99      42.000  48.233 -11.614  1.00 45.88           O  
ATOM    769  N   ASP A 100      44.399  46.904  -7.758  1.00 43.26           N  
ATOM    770  CA  ASP A 100      45.394  47.070  -6.687  1.00 42.98           C  
ATOM    771  C   ASP A 100      44.804  47.595  -5.365  1.00 41.85           C  
ATOM    772  O   ASP A 100      45.496  48.229  -4.557  1.00 41.00           O  
ATOM    773  CB  ASP A 100      46.559  47.942  -7.171  1.00 44.05           C  
ATOM    774  CG  ASP A 100      47.422  47.240  -8.221  1.00 48.75           C  
ATOM    775  OD1 ASP A 100      48.372  46.524  -7.828  1.00 52.56           O  
ATOM    776  OD2 ASP A 100      47.158  47.407  -9.434  1.00 52.59           O  
ATOM    777  N   ALA A 101      43.525  47.303  -5.146  1.00 40.11           N  
ATOM    778  CA  ALA A 101      42.792  47.771  -3.965  1.00 39.52           C  
ATOM    779  C   ALA A 101      42.931  49.287  -3.805  1.00 38.48           C  
ATOM    780  O   ALA A 101      42.971  49.808  -2.687  1.00 39.03           O  
ATOM    781  CB  ALA A 101      43.272  47.035  -2.702  1.00 39.12           C  
ATOM    782  N   LEU A 102      43.010  49.982  -4.935  1.00 37.06           N  
ATOM    783  CA  LEU A 102      43.252  51.407  -4.947  1.00 36.46           C  
ATOM    784  C   LEU A 102      42.094  52.171  -4.289  1.00 36.35           C  
ATOM    785  O   LEU A 102      42.313  53.185  -3.632  1.00 36.17           O  
ATOM    786  CB  LEU A 102      43.464  51.894  -6.383  1.00 36.56           C  
ATOM    787  CG  LEU A 102      43.883  53.350  -6.570  1.00 36.64           C  
ATOM    788  CD1 LEU A 102      45.044  53.753  -5.644  1.00 36.09           C  
ATOM    789  CD2 LEU A 102      44.208  53.616  -8.033  1.00 37.99           C  
ATOM    790  N   GLY A 103      40.875  51.670  -4.461  1.00 35.57           N  
ATOM    791  CA  GLY A 103      39.713  52.332  -3.904  1.00 35.69           C  
ATOM    792  C   GLY A 103      39.735  52.396  -2.392  1.00 36.42           C  
ATOM    793  O   GLY A 103      39.293  53.385  -1.812  1.00 37.04           O  
ATOM    794  N   VAL A 104      40.214  51.333  -1.740  1.00 36.63           N  
ATOM    795  CA  VAL A 104      40.285  51.323  -0.272  1.00 36.70           C  
ATOM    796  C   VAL A 104      41.410  52.225   0.239  1.00 36.66           C  
ATOM    797  O   VAL A 104      41.224  52.962   1.220  1.00 34.89           O  
ATOM    798  CB  VAL A 104      40.409  49.906   0.339  1.00 37.03           C  
ATOM    799  CG1 VAL A 104      39.050  49.232   0.409  1.00 37.36           C  
ATOM    800  CG2 VAL A 104      41.374  49.066  -0.456  1.00 39.14           C  
ATOM    801  N   ARG A 105      42.561  52.162  -0.447  1.00 35.56           N  
ATOM    802  CA  ARG A 105      43.730  52.974  -0.122  1.00 35.07           C  
ATOM    803  C   ARG A 105      43.457  54.471  -0.282  1.00 34.69           C  
ATOM    804  O   ARG A 105      44.009  55.282   0.461  1.00 35.06           O  
ATOM    805  CB  ARG A 105      44.946  52.533  -0.944  1.00 34.70           C  
ATOM    806  CG  ARG A 105      45.330  51.084  -0.678  1.00 36.80           C  
ATOM    807  CD  ARG A 105      46.662  50.679  -1.303  1.00 40.23           C  
ATOM    808  NE  ARG A 105      46.529  50.415  -2.727  1.00 43.90           N  
ATOM    809  CZ  ARG A 105      47.138  51.109  -3.685  1.00 47.26           C  
ATOM    810  NH1 ARG A 105      47.964  52.105  -3.385  1.00 47.65           N  
ATOM    811  NH2 ARG A 105      46.934  50.796  -4.957  1.00 48.83           N  
ATOM    812  N   ARG A 106      42.604  54.827  -1.242  1.00 34.30           N  
ATOM    813  CA  ARG A 106      42.133  56.207  -1.410  1.00 33.32           C  
ATOM    814  C   ARG A 106      41.182  56.639  -0.291  1.00 32.95           C  
ATOM    815  O   ARG A 106      41.192  57.792   0.136  1.00 32.45           O  
ATOM    816  CB  ARG A 106      41.380  56.342  -2.721  1.00 33.91           C  
ATOM    817  CG  ARG A 106      42.218  56.458  -3.956  1.00 32.72           C  
ATOM    818  CD  ARG A 106      41.303  56.270  -5.150  1.00 34.11           C  
ATOM    819  NE  ARG A 106      41.930  56.659  -6.406  1.00 34.07           N  
ATOM    820  CZ  ARG A 106      41.548  56.228  -7.601  1.00 31.14           C  
ATOM    821  NH1 ARG A 106      40.533  55.385  -7.723  1.00 29.84           N  
ATOM    822  NH2 ARG A 106      42.205  56.634  -8.673  1.00 32.75           N  
ATOM    823  N   ALA A 107      40.344  55.695   0.140  1.00 32.56           N  
ATOM    824  CA  ALA A 107      39.398  55.873   1.236  1.00 31.52           C  
ATOM    825  C   ALA A 107      40.109  56.139   2.559  1.00 31.41           C  
ATOM    826  O   ALA A 107      39.699  57.014   3.321  1.00 30.08           O  
ATOM    827  CB  ALA A 107      38.499  54.636   1.358  1.00 30.20           C  
ATOM    828  N   ALA A 108      41.154  55.346   2.821  1.00 30.08           N  
ATOM    829  CA  ALA A 108      42.048  55.472   3.969  1.00 29.89           C  
ATOM    830  C   ALA A 108      42.717  56.834   4.024  1.00 30.26           C  
ATOM    831  O   ALA A 108      42.716  57.488   5.068  1.00 30.53           O  
ATOM    832  CB  ALA A 108      43.126  54.360   3.909  1.00 29.11           C  
ATOM    833  N   GLN A 109      43.283  57.258   2.888  1.00 30.84           N  
ATOM    834  CA  GLN A 109      43.931  58.558   2.775  1.00 31.51           C  
ATOM    835  C   GLN A 109      42.922  59.650   3.092  1.00 31.84           C  
ATOM    836  O   GLN A 109      43.221  60.560   3.855  1.00 31.14           O  
ATOM    837  CB  GLN A 109      44.511  58.751   1.373  1.00 32.34           C  
ATOM    838  CG  GLN A 109      45.007  60.152   1.093  1.00 34.83           C  
ATOM    839  CD  GLN A 109      45.476  60.352  -0.334  1.00 35.21           C  
ATOM    840  OE1 GLN A 109      44.875  59.848  -1.288  1.00 37.87           O  
ATOM    841  NE2 GLN A 109      46.543  61.122  -0.489  1.00 36.22           N  
ATOM    842  N   ARG A 110      41.729  59.542   2.514  1.00 32.94           N  
ATOM    843  CA  ARG A 110      40.648  60.490   2.789  1.00 33.24           C  
ATOM    844  C   ARG A 110      40.278  60.538   4.275  1.00 33.53           C  
ATOM    845  O   ARG A 110      40.188  61.630   4.844  1.00 35.88           O  
ATOM    846  CB  ARG A 110      39.430  60.196   1.921  1.00 33.62           C  
ATOM    847  CG  ARG A 110      38.182  61.042   2.273  1.00 33.18           C  
ATOM    848  CD  ARG A 110      36.946  60.633   1.478  1.00 34.15           C  
ATOM    849  NE  ARG A 110      36.604  59.209   1.598  1.00 35.37           N  
ATOM    850  CZ  ARG A 110      35.812  58.689   2.539  1.00 38.15           C  
ATOM    851  NH1 ARG A 110      35.254  59.464   3.477  1.00 36.96           N  
ATOM    852  NH2 ARG A 110      35.572  57.385   2.546  1.00 35.60           N  
ATOM    853  N   ARG A 111      40.090  59.381   4.914  1.00 33.55           N  
ATOM    854  CA  ARG A 111      39.702  59.359   6.336  1.00 33.87           C  
ATOM    855  C   ARG A 111      40.818  59.743   7.292  1.00 33.42           C  
ATOM    856  O   ARG A 111      40.545  60.305   8.364  1.00 33.04           O  
ATOM    857  CB  ARG A 111      39.076  58.029   6.792  1.00 33.52           C  
ATOM    858  CG  ARG A 111      37.658  57.836   6.337  1.00 36.51           C  
ATOM    859  CD  ARG A 111      36.718  58.920   6.855  1.00 37.22           C  
ATOM    860  NE  ARG A 111      36.283  58.730   8.243  1.00 38.35           N  
ATOM    861  CZ  ARG A 111      35.456  59.572   8.867  1.00 38.77           C  
ATOM    862  NH1 ARG A 111      34.982  60.635   8.236  1.00 38.60           N  
ATOM    863  NH2 ARG A 111      35.102  59.365  10.119  1.00 38.26           N  
ATOM    864  N   LEU A 112      42.061  59.440   6.920  1.00 31.26           N  
ATOM    865  CA  LEU A 112      43.188  59.869   7.733  1.00 31.40           C  
ATOM    866  C   LEU A 112      43.197  61.386   7.831  1.00 33.23           C  
ATOM    867  O   LEU A 112      43.506  61.957   8.888  1.00 33.23           O  
ATOM    868  CB  LEU A 112      44.515  59.342   7.169  1.00 30.15           C  
ATOM    869  CG  LEU A 112      44.685  57.850   7.429  1.00 26.32           C  
ATOM    870  CD1 LEU A 112      45.830  57.228   6.611  1.00 25.51           C  
ATOM    871  CD2 LEU A 112      44.916  57.629   8.892  1.00 24.09           C  
ATOM    872  N   LYS A 113      42.815  62.032   6.732  1.00 33.78           N  
ATOM    873  CA  LYS A 113      42.728  63.477   6.692  1.00 35.63           C  
ATOM    874  C   LYS A 113      41.521  63.967   7.478  1.00 35.06           C  
ATOM    875  O   LYS A 113      41.634  64.903   8.250  1.00 35.94           O  
ATOM    876  CB  LYS A 113      42.684  63.986   5.243  1.00 36.81           C  
ATOM    877  CG  LYS A 113      42.388  65.475   5.086  1.00 38.97           C  
ATOM    878  CD  LYS A 113      43.555  66.332   5.541  1.00 43.08           C  
ATOM    879  CE  LYS A 113      43.091  67.668   6.137  1.00 45.00           C  
ATOM    880  NZ  LYS A 113      42.198  68.436   5.228  1.00 49.00           N  
ATOM    881  N   ALA A 114      40.377  63.327   7.282  1.00 34.89           N  
ATOM    882  CA  ALA A 114      39.148  63.744   7.980  1.00 34.22           C  
ATOM    883  C   ALA A 114      39.201  63.457   9.476  1.00 34.03           C  
ATOM    884  O   ALA A 114      38.872  64.306  10.272  1.00 34.68           O  
ATOM    885  CB  ALA A 114      37.920  63.111   7.350  1.00 34.07           C  
ATOM    886  N   GLU A 115      39.627  62.272   9.876  1.00 33.29           N  
ATOM    887  CA  GLU A 115      39.696  61.989  11.318  1.00 33.21           C  
ATOM    888  C   GLU A 115      40.881  62.671  12.020  1.00 33.22           C  
ATOM    889  O   GLU A 115      40.706  63.321  13.049  1.00 33.41           O  
ATOM    890  CB  GLU A 115      39.676  60.492  11.602  1.00 32.97           C  
ATOM    891  CG  GLU A 115      38.451  59.780  11.066  1.00 33.13           C  
ATOM    892  CD  GLU A 115      38.271  58.392  11.652  1.00 32.98           C  
ATOM    893  OE1 GLU A 115      38.924  58.060  12.670  1.00 32.65           O  
ATOM    894  OE2 GLU A 115      37.458  57.619  11.096  1.00 31.63           O  
ATOM    895  N   LEU A 116      42.082  62.556  11.456  1.00 32.35           N  
ATOM    896  CA  LEU A 116      43.272  62.958  12.194  1.00 31.67           C  
ATOM    897  C   LEU A 116      43.899  64.252  11.711  1.00 31.08           C  
ATOM    898  O   LEU A 116      44.801  64.799  12.352  1.00 31.65           O  
ATOM    899  CB  LEU A 116      44.281  61.809  12.204  1.00 32.05           C  
ATOM    900  CG  LEU A 116      43.785  60.560  12.928  1.00 31.74           C  
ATOM    901  CD1 LEU A 116      44.602  59.339  12.510  1.00 32.97           C  
ATOM    902  CD2 LEU A 116      43.847  60.758  14.444  1.00 31.44           C  
ATOM    903  N   GLY A 117      43.410  64.770  10.599  1.00 30.54           N  
ATOM    904  CA  GLY A 117      43.935  66.029  10.094  1.00 31.27           C  
ATOM    905  C   GLY A 117      45.285  65.851   9.423  1.00 30.70           C  
ATOM    906  O   GLY A 117      45.995  66.815   9.183  1.00 30.34           O  
ATOM    907  N   ILE A 118      45.634  64.601   9.139  1.00 31.34           N  
ATOM    908  CA  ILE A 118      46.813  64.281   8.360  1.00 29.94           C  
ATOM    909  C   ILE A 118      46.671  64.741   6.897  1.00 31.91           C  
ATOM    910  O   ILE A 118      45.815  64.237   6.165  1.00 31.70           O  
ATOM    911  CB  ILE A 118      47.083  62.781   8.392  1.00 28.50           C  
ATOM    912  CG1 ILE A 118      47.357  62.327   9.818  1.00 24.64           C  
ATOM    913  CG2 ILE A 118      48.244  62.421   7.450  1.00 30.25           C  
ATOM    914  CD1 ILE A 118      46.890  60.929  10.076  1.00 26.21           C  
ATOM    915  N   PRO A 119      47.541  65.668   6.450  1.00 33.38           N  
ATOM    916  CA  PRO A 119      47.478  66.135   5.075  1.00 33.96           C  
ATOM    917  C   PRO A 119      47.586  65.007   4.047  1.00 35.59           C  
ATOM    918  O   PRO A 119      48.440  64.135   4.161  1.00 33.86           O  
ATOM    919  CB  PRO A 119      48.693  67.052   4.969  1.00 34.78           C  
ATOM    920  CG  PRO A 119      49.002  67.455   6.329  1.00 34.07           C  
ATOM    921  CD  PRO A 119      48.651  66.299   7.187  1.00 33.93           C  
ATOM    922  N   LEU A 120      46.720  65.041   3.042  1.00 38.19           N  
ATOM    923  CA  LEU A 120      46.673  63.990   2.025  1.00 40.70           C  
ATOM    924  C   LEU A 120      48.058  63.668   1.490  1.00 42.87           C  
ATOM    925  O   LEU A 120      48.347  62.513   1.175  1.00 43.65           O  
ATOM    926  CB  LEU A 120      45.782  64.401   0.863  1.00 40.53           C  
ATOM    927  CG  LEU A 120      44.346  64.829   1.147  1.00 41.22           C  
ATOM    928  CD1 LEU A 120      43.740  65.389  -0.125  1.00 45.09           C  
ATOM    929  CD2 LEU A 120      43.532  63.664   1.650  1.00 41.30           C  
ATOM    930  N   GLU A 121      48.907  64.689   1.400  1.00 44.55           N  
ATOM    931  CA  GLU A 121      50.231  64.540   0.812  1.00 47.18           C  
ATOM    932  C   GLU A 121      51.184  63.716   1.659  1.00 47.83           C  
ATOM    933  O   GLU A 121      52.088  63.068   1.133  1.00 48.45           O  
ATOM    934  CB  GLU A 121      50.826  65.901   0.453  1.00 47.90           C  
ATOM    935  CG  GLU A 121      51.100  66.027  -1.050  1.00 52.51           C  
ATOM    936  CD  GLU A 121      50.498  67.267  -1.704  1.00 55.86           C  
ATOM    937  OE1 GLU A 121      50.956  67.613  -2.816  1.00 56.73           O  
ATOM    938  OE2 GLU A 121      49.560  67.878  -1.126  1.00 58.33           O  
ATOM    939  N   GLU A 122      50.951  63.706   2.965  1.00 48.07           N  
ATOM    940  CA  GLU A 122      51.791  62.953   3.885  1.00 48.55           C  
ATOM    941  C   GLU A 122      51.583  61.447   3.754  1.00 48.51           C  
ATOM    942  O   GLU A 122      52.499  60.679   4.030  1.00 49.73           O  
ATOM    943  CB  GLU A 122      51.568  63.422   5.334  1.00 48.48           C  
ATOM    944  CG  GLU A 122      52.093  64.826   5.599  1.00 48.74           C  
ATOM    945  CD  GLU A 122      52.193  65.172   7.075  1.00 49.62           C  
ATOM    946  OE1 GLU A 122      51.457  64.570   7.885  1.00 51.86           O  
ATOM    947  OE2 GLU A 122      53.006  66.061   7.422  1.00 48.10           O  
ATOM    948  N   VAL A 123      50.385  61.028   3.341  1.00 48.35           N  
ATOM    949  CA  VAL A 123      50.093  59.606   3.128  1.00 48.00           C  
ATOM    950  C   VAL A 123      49.407  59.360   1.788  1.00 48.34           C  
ATOM    951  O   VAL A 123      48.183  59.179   1.751  1.00 48.65           O  
ATOM    952  CB  VAL A 123      49.207  58.986   4.247  1.00 48.16           C  
ATOM    953  CG1 VAL A 123      49.303  57.450   4.202  1.00 48.23           C  
ATOM    954  CG2 VAL A 123      49.592  59.500   5.628  1.00 47.70           C  
ATOM    955  N   PRO A 124      50.182  59.345   0.679  1.00 48.39           N  
ATOM    956  CA  PRO A 124      49.545  59.040  -0.594  1.00 48.26           C  
ATOM    957  C   PRO A 124      49.245  57.545  -0.672  1.00 47.86           C  
ATOM    958  O   PRO A 124      49.873  56.763   0.048  1.00 47.29           O  
ATOM    959  CB  PRO A 124      50.596  59.466  -1.627  1.00 47.87           C  
ATOM    960  CG  PRO A 124      51.874  59.308  -0.946  1.00 48.25           C  
ATOM    961  CD  PRO A 124      51.625  59.602   0.514  1.00 48.54           C  
ATOM    962  N   PRO A 125      48.359  57.146  -1.560  1.00 47.89           N  
ATOM    963  CA  PRO A 125      47.890  55.776  -1.593  1.00 47.92           C  
ATOM    964  C   PRO A 125      48.968  54.706  -1.768  1.00 48.18           C  
ATOM    965  O   PRO A 125      48.765  53.611  -1.310  1.00 47.85           O  
ATOM    966  CB  PRO A 125      46.918  55.791  -2.751  1.00 48.09           C  
ATOM    967  CG  PRO A 125      46.385  57.125  -2.747  1.00 47.94           C  
ATOM    968  CD  PRO A 125      47.480  58.024  -2.342  1.00 47.97           C  
ATOM    969  N   GLU A 126      50.092  55.040  -2.388  1.00 48.48           N  
ATOM    970  CA  GLU A 126      51.264  54.163  -2.489  1.00 49.08           C  
ATOM    971  C   GLU A 126      51.971  53.846  -1.184  1.00 48.32           C  
ATOM    972  O   GLU A 126      52.633  52.848  -1.075  1.00 48.35           O  
ATOM    973  CB  GLU A 126      52.307  54.757  -3.423  1.00 49.72           C  
ATOM    974  CG  GLU A 126      51.770  55.621  -4.488  1.00 52.62           C  
ATOM    975  CD  GLU A 126      51.563  57.024  -4.037  1.00 55.79           C  
ATOM    976  OE1 GLU A 126      52.538  57.687  -3.695  1.00 57.93           O  
ATOM    977  OE2 GLU A 126      50.422  57.471  -4.044  1.00 56.68           O  
ATOM    978  N   GLU A 127      51.843  54.712  -0.200  1.00 46.96           N  
ATOM    979  CA  GLU A 127      52.473  54.477   1.068  1.00 46.37           C  
ATOM    980  C   GLU A 127      51.649  53.621   1.978  1.00 44.63           C  
ATOM    981  O   GLU A 127      52.041  53.349   3.081  1.00 44.67           O  
ATOM    982  CB  GLU A 127      52.768  55.782   1.763  1.00 47.29           C  
ATOM    983  CG  GLU A 127      53.547  56.720   0.959  1.00 51.15           C  
ATOM    984  CD  GLU A 127      55.014  56.464   1.056  1.00 54.34           C  
ATOM    985  OE1 GLU A 127      55.406  55.331   1.341  1.00 54.94           O  
ATOM    986  OE2 GLU A 127      55.763  57.417   0.878  1.00 56.70           O  
ATOM    987  N   ILE A 128      50.488  53.215   1.506  1.00 42.84           N  
ATOM    988  CA  ILE A 128      49.567  52.430   2.325  1.00 41.36           C  
ATOM    989  C   ILE A 128      49.626  50.975   1.894  1.00 40.15           C  
ATOM    990  O   ILE A 128      49.265  50.633   0.762  1.00 39.68           O  
ATOM    991  CB  ILE A 128      48.111  52.981   2.251  1.00 41.01           C  
ATOM    992  CG1 ILE A 128      48.105  54.495   2.451  1.00 40.73           C  
ATOM    993  CG2 ILE A 128      47.209  52.288   3.278  1.00 41.76           C  
ATOM    994  CD1 ILE A 128      46.720  55.136   2.433  1.00 39.85           C  
ATOM    995  N   ASN A 129      50.080  50.127   2.814  1.00 39.79           N  
ATOM    996  CA  ASN A 129      50.298  48.722   2.524  0.50 39.25           C  
ATOM    998  C   ASN A 129      49.110  47.845   2.887  1.00 38.78           C  
ATOM    999  O   ASN A 129      48.862  47.576   4.055  1.00 39.00           O  
ATOM   1000  CB  ASN A 129      51.573  48.228   3.218  0.50 39.11           C  
ATOM   1002  CG  ASN A 129      52.801  49.007   2.798  0.50 39.66           C  
ATOM   1004  OD1 ASN A 129      53.280  48.872   1.671  0.50 39.70           O  
ATOM   1006  ND2 ASN A 129      53.325  49.824   3.708  0.50 40.35           N  
ATOM   1008  N   TYR A 130      48.382  47.405   1.867  1.00 38.47           N  
ATOM   1009  CA  TYR A 130      47.290  46.477   2.039  1.00 37.89           C  
ATOM   1010  C   TYR A 130      47.862  45.085   2.292  1.00 38.87           C  
ATOM   1011  O   TYR A 130      48.515  44.503   1.417  1.00 39.22           O  
ATOM   1012  CB  TYR A 130      46.385  46.498   0.801  1.00 37.89           C  
ATOM   1013  CG  TYR A 130      45.463  45.292   0.639  1.00 36.26           C  
ATOM   1014  CD1 TYR A 130      44.850  44.685   1.742  1.00 33.73           C  
ATOM   1015  CD2 TYR A 130      45.189  44.787  -0.620  1.00 34.19           C  
ATOM   1016  CE1 TYR A 130      44.033  43.598   1.590  1.00 33.39           C  
ATOM   1017  CE2 TYR A 130      44.356  43.704  -0.779  1.00 35.17           C  
ATOM   1018  CZ  TYR A 130      43.792  43.110   0.329  1.00 33.73           C  
ATOM   1019  OH  TYR A 130      42.969  42.028   0.152  1.00 35.22           O  
ATOM   1020  N   LEU A 131      47.607  44.557   3.488  1.00 38.58           N  
ATOM   1021  CA  LEU A 131      48.108  43.232   3.884  1.00 38.95           C  
ATOM   1022  C   LEU A 131      47.155  42.084   3.581  1.00 38.55           C  
ATOM   1023  O   LEU A 131      47.482  41.200   2.772  1.00 38.71           O  
ATOM   1024  CB  LEU A 131      48.514  43.212   5.363  1.00 39.36           C  
ATOM   1025  CG  LEU A 131      50.014  43.225   5.648  1.00 40.62           C  
ATOM   1026  CD1 LEU A 131      50.705  44.387   4.954  1.00 42.24           C  
ATOM   1027  CD2 LEU A 131      50.246  43.281   7.136  1.00 40.41           C  
ATOM   1028  N   THR A 132      45.996  42.087   4.241  1.00 37.07           N  
ATOM   1029  CA  THR A 132      45.016  41.032   4.061  1.00 36.65           C  
ATOM   1030  C   THR A 132      43.625  41.505   4.471  1.00 36.75           C  
ATOM   1031  O   THR A 132      43.442  42.678   4.784  1.00 37.07           O  
ATOM   1032  CB  THR A 132      45.433  39.731   4.811  1.00 36.94           C  
ATOM   1033  OG1 THR A 132      44.632  38.626   4.358  1.00 37.01           O  
ATOM   1034  CG2 THR A 132      45.329  39.884   6.330  1.00 36.93           C  
ATOM   1035  N   ARG A 133      42.653  40.596   4.449  1.00 36.83           N  
ATOM   1036  CA  ARG A 133      41.271  40.917   4.808  1.00 36.69           C  
ATOM   1037  C   ARG A 133      40.762  40.001   5.908  1.00 36.63           C  
ATOM   1038  O   ARG A 133      41.101  38.815   5.961  1.00 36.84           O  
ATOM   1039  CB  ARG A 133      40.362  40.777   3.591  1.00 36.41           C  
ATOM   1040  CG  ARG A 133      40.621  41.782   2.501  1.00 37.29           C  
ATOM   1041  CD  ARG A 133      39.885  41.403   1.243  1.00 39.17           C  
ATOM   1042  NE  ARG A 133      40.417  40.173   0.656  1.00 40.80           N  
ATOM   1043  CZ  ARG A 133      39.956  39.606  -0.452  1.00 41.20           C  
ATOM   1044  NH1 ARG A 133      38.943  40.155  -1.108  1.00 39.87           N  
ATOM   1045  NH2 ARG A 133      40.512  38.488  -0.904  1.00 40.18           N  
ATOM   1046  N   ILE A 134      39.946  40.559   6.786  1.00 35.88           N  
ATOM   1047  CA  ILE A 134      39.307  39.809   7.847  1.00 35.98           C  
ATOM   1048  C   ILE A 134      37.788  40.053   7.840  1.00 37.02           C  
ATOM   1049  O   ILE A 134      37.336  41.204   7.786  1.00 36.33           O  
ATOM   1050  CB  ILE A 134      39.916  40.202   9.215  1.00 36.76           C  
ATOM   1051  CG1 ILE A 134      41.341  39.654   9.322  1.00 36.06           C  
ATOM   1052  CG2 ILE A 134      39.059  39.708  10.368  1.00 36.51           C  
ATOM   1053  CD1 ILE A 134      42.303  40.549  10.068  1.00 36.71           C  
ATOM   1054  N   HIS A 135      37.026  38.961   7.874  1.00 36.61           N  
ATOM   1055  CA  HIS A 135      35.577  38.989   8.024  1.00 36.65           C  
ATOM   1056  C   HIS A 135      35.219  38.875   9.512  1.00 35.47           C  
ATOM   1057  O   HIS A 135      35.680  37.959  10.199  1.00 33.85           O  
ATOM   1058  CB  HIS A 135      34.975  37.830   7.204  1.00 37.54           C  
ATOM   1059  CG  HIS A 135      33.477  37.774   7.196  1.00 39.07           C  
ATOM   1060  ND1 HIS A 135      32.785  36.700   6.676  1.00 42.76           N  
ATOM   1061  CD2 HIS A 135      32.537  38.637   7.651  1.00 42.55           C  
ATOM   1062  CE1 HIS A 135      31.487  36.910   6.799  1.00 41.93           C  
ATOM   1063  NE2 HIS A 135      31.309  38.078   7.389  1.00 42.16           N  
ATOM   1064  N   TYR A 136      34.399  39.809  10.016  1.00 34.45           N  
ATOM   1065  CA  TYR A 136      33.952  39.759  11.409  1.00 33.13           C  
ATOM   1066  C   TYR A 136      32.544  40.382  11.580  1.00 33.61           C  
ATOM   1067  O   TYR A 136      32.084  41.177  10.766  1.00 30.99           O  
ATOM   1068  CB  TYR A 136      34.969  40.416  12.383  1.00 33.23           C  
ATOM   1069  CG  TYR A 136      34.939  41.928  12.350  1.00 32.44           C  
ATOM   1070  CD1 TYR A 136      34.132  42.660  13.243  1.00 34.27           C  
ATOM   1071  CD2 TYR A 136      35.660  42.627  11.390  1.00 32.61           C  
ATOM   1072  CE1 TYR A 136      34.069  44.057  13.182  1.00 33.63           C  
ATOM   1073  CE2 TYR A 136      35.614  44.014  11.319  1.00 34.79           C  
ATOM   1074  CZ  TYR A 136      34.813  44.729  12.219  1.00 35.38           C  
ATOM   1075  OH  TYR A 136      34.787  46.106  12.133  1.00 35.57           O  
ATOM   1076  N   LYS A 137      31.883  39.965  12.651  1.00 34.37           N  
ATOM   1077  CA  LYS A 137      30.585  40.485  13.050  1.00 35.36           C  
ATOM   1078  C   LYS A 137      30.676  40.781  14.544  1.00 35.11           C  
ATOM   1079  O   LYS A 137      31.176  39.951  15.314  1.00 34.48           O  
ATOM   1080  CB  LYS A 137      29.491  39.458  12.759  1.00 35.21           C  
ATOM   1081  CG  LYS A 137      28.095  40.007  12.954  1.00 38.21           C  
ATOM   1082  CD  LYS A 137      27.060  38.907  13.176  1.00 42.41           C  
ATOM   1083  CE  LYS A 137      26.604  38.245  11.885  1.00 43.32           C  
ATOM   1084  NZ  LYS A 137      25.483  37.292  12.164  1.00 46.45           N  
ATOM   1085  N   ALA A 138      30.210  41.965  14.939  1.00 35.38           N  
ATOM   1086  CA  ALA A 138      30.227  42.391  16.327  1.00 36.23           C  
ATOM   1087  C   ALA A 138      29.167  43.446  16.602  1.00 37.11           C  
ATOM   1088  O   ALA A 138      28.983  44.362  15.803  1.00 38.46           O  
ATOM   1089  CB  ALA A 138      31.585  42.942  16.687  1.00 36.23           C  
ATOM   1090  N   GLN A 139      28.503  43.336  17.745  1.00 37.78           N  
ATOM   1091  CA  GLN A 139      27.502  44.337  18.156  1.00 38.31           C  
ATOM   1092  C   GLN A 139      28.088  45.435  19.060  1.00 38.28           C  
ATOM   1093  O   GLN A 139      28.911  45.171  19.939  1.00 38.33           O  
ATOM   1094  CB  GLN A 139      26.297  43.670  18.825  1.00 38.44           C  
ATOM   1095  CG  GLN A 139      25.511  42.741  17.894  1.00 39.87           C  
ATOM   1096  CD  GLN A 139      24.114  42.373  18.408  1.00 41.12           C  
ATOM   1097  OE1 GLN A 139      23.268  41.915  17.631  1.00 43.49           O  
ATOM   1098  NE2 GLN A 139      23.868  42.566  19.706  1.00 43.24           N  
ATOM   1099  N   SER A 140      27.654  46.668  18.822  1.00 38.42           N  
ATOM   1100  CA  SER A 140      27.983  47.803  19.670  1.00 38.26           C  
ATOM   1101  C   SER A 140      27.005  47.855  20.841  1.00 38.96           C  
ATOM   1102  O   SER A 140      27.392  47.901  22.018  1.00 39.00           O  
ATOM   1103  CB  SER A 140      27.887  49.083  18.841  1.00 37.77           C  
ATOM   1104  OG  SER A 140      28.441  50.195  19.513  1.00 36.25           O  
ATOM   1105  N   ASP A 141      25.723  47.886  20.501  1.00 39.51           N  
ATOM   1106  CA  ASP A 141      24.651  47.758  21.476  1.00 40.04           C  
ATOM   1107  C   ASP A 141      23.568  46.910  20.832  1.00 40.60           C  
ATOM   1108  O   ASP A 141      23.836  46.188  19.865  1.00 41.22           O  
ATOM   1109  CB  ASP A 141      24.110  49.135  21.925  1.00 39.72           C  
ATOM   1110  CG  ASP A 141      23.735  50.071  20.758  1.00 38.53           C  
ATOM   1111  OD1 ASP A 141      23.153  49.652  19.739  1.00 36.97           O  
ATOM   1112  OD2 ASP A 141      24.007  51.275  20.882  1.00 41.19           O  
ATOM   1113  N   GLY A 142      22.343  47.014  21.344  1.00 40.71           N  
ATOM   1114  CA  GLY A 142      21.218  46.271  20.791  1.00 39.74           C  
ATOM   1115  C   GLY A 142      20.851  46.704  19.385  1.00 39.01           C  
ATOM   1116  O   GLY A 142      20.360  45.904  18.597  1.00 39.17           O  
ATOM   1117  N   ILE A 143      21.093  47.972  19.065  1.00 38.21           N  
ATOM   1118  CA  ILE A 143      20.637  48.544  17.793  1.00 37.19           C  
ATOM   1119  C   ILE A 143      21.709  48.593  16.733  1.00 35.81           C  
ATOM   1120  O   ILE A 143      21.446  48.291  15.573  1.00 35.86           O  
ATOM   1121  CB  ILE A 143      20.079  49.975  17.980  1.00 37.17           C  
ATOM   1122  CG1 ILE A 143      18.791  49.941  18.803  1.00 39.17           C  
ATOM   1123  CG2 ILE A 143      19.831  50.653  16.634  1.00 35.15           C  
ATOM   1124  CD1 ILE A 143      18.200  51.342  19.066  1.00 40.46           C  
ATOM   1125  N   TRP A 144      22.906  49.007  17.133  1.00 35.25           N  
ATOM   1126  CA  TRP A 144      23.991  49.247  16.194  1.00 34.28           C  
ATOM   1127  C   TRP A 144      25.076  48.184  16.301  1.00 33.91           C  
ATOM   1128  O   TRP A 144      25.332  47.639  17.380  1.00 34.28           O  
ATOM   1129  CB  TRP A 144      24.615  50.611  16.463  1.00 34.84           C  
ATOM   1130  CG  TRP A 144      23.640  51.735  16.407  1.00 33.90           C  
ATOM   1131  CD1 TRP A 144      22.973  52.292  17.462  1.00 35.41           C  
ATOM   1132  CD2 TRP A 144      23.211  52.444  15.235  1.00 33.85           C  
ATOM   1133  NE1 TRP A 144      22.151  53.305  17.019  1.00 35.53           N  
ATOM   1134  CE2 TRP A 144      22.275  53.420  15.658  1.00 34.86           C  
ATOM   1135  CE3 TRP A 144      23.528  52.358  13.876  1.00 35.06           C  
ATOM   1136  CZ2 TRP A 144      21.656  54.308  14.764  1.00 34.03           C  
ATOM   1137  CZ3 TRP A 144      22.900  53.233  12.984  1.00 36.06           C  
ATOM   1138  CH2 TRP A 144      21.969  54.195  13.439  1.00 34.63           C  
ATOM   1139  N   GLY A 145      25.731  47.907  15.178  1.00 33.06           N  
ATOM   1140  CA  GLY A 145      26.806  46.924  15.154  1.00 31.56           C  
ATOM   1141  C   GLY A 145      27.557  46.949  13.845  1.00 30.86           C  
ATOM   1142  O   GLY A 145      27.344  47.814  12.989  1.00 29.99           O  
ATOM   1143  N   GLU A 146      28.437  45.978  13.689  1.00 31.13           N  
ATOM   1144  CA  GLU A 146      29.299  45.930  12.530  1.00 30.31           C  
ATOM   1145  C   GLU A 146      29.217  44.557  11.903  1.00 29.24           C  
ATOM   1146  O   GLU A 146      29.001  43.569  12.598  1.00 28.41           O  
ATOM   1147  CB  GLU A 146      30.739  46.211  12.955  1.00 31.96           C  
ATOM   1148  CG  GLU A 146      31.081  47.681  13.101  1.00 31.66           C  
ATOM   1149  CD  GLU A 146      31.201  48.402  11.777  1.00 35.93           C  
ATOM   1150  OE1 GLU A 146      30.952  47.818  10.699  1.00 35.17           O  
ATOM   1151  OE2 GLU A 146      31.534  49.592  11.799  1.00 41.13           O  
ATOM   1152  N   HIS A 147      29.356  44.523  10.585  1.00 30.21           N  
ATOM   1153  CA  HIS A 147      29.531  43.293   9.805  1.00 30.76           C  
ATOM   1154  C   HIS A 147      30.294  43.689   8.549  1.00 30.68           C  
ATOM   1155  O   HIS A 147      29.766  44.360   7.665  1.00 29.19           O  
ATOM   1156  CB  HIS A 147      28.169  42.696   9.458  1.00 31.83           C  
ATOM   1157  CG  HIS A 147      28.223  41.314   8.882  1.00 30.01           C  
ATOM   1158  ND1 HIS A 147      27.259  40.842   8.019  1.00 28.77           N  
ATOM   1159  CD2 HIS A 147      29.118  40.309   9.034  1.00 32.08           C  
ATOM   1160  CE1 HIS A 147      27.546  39.600   7.678  1.00 29.61           C  
ATOM   1161  NE2 HIS A 147      28.676  39.254   8.267  1.00 29.17           N  
ATOM   1162  N   GLU A 148      31.565  43.294   8.489  1.00 30.38           N  
ATOM   1163  CA  GLU A 148      32.459  43.806   7.475  1.00 30.44           C  
ATOM   1164  C   GLU A 148      33.438  42.754   6.997  1.00 29.39           C  
ATOM   1165  O   GLU A 148      33.767  41.842   7.726  1.00 28.95           O  
ATOM   1166  CB  GLU A 148      33.292  44.954   8.059  1.00 30.60           C  
ATOM   1167  CG  GLU A 148      32.502  46.020   8.786  1.00 34.30           C  
ATOM   1168  CD  GLU A 148      33.387  47.148   9.241  1.00 35.23           C  
ATOM   1169  OE1 GLU A 148      34.289  46.917  10.076  1.00 39.37           O  
ATOM   1170  OE2 GLU A 148      33.208  48.264   8.738  1.00 33.17           O  
ATOM   1171  N   ILE A 149      33.911  42.922   5.774  1.00 28.97           N  
ATOM   1172  CA  ILE A 149      35.189  42.340   5.379  1.00 29.58           C  
ATOM   1173  C   ILE A 149      36.160  43.527   5.393  1.00 30.26           C  
ATOM   1174  O   ILE A 149      36.033  44.448   4.594  1.00 31.75           O  
ATOM   1175  CB  ILE A 149      35.129  41.604   4.004  1.00 28.90           C  
ATOM   1176  CG1 ILE A 149      34.298  40.324   4.126  1.00 27.57           C  
ATOM   1177  CG2 ILE A 149      36.540  41.261   3.504  1.00 28.61           C  
ATOM   1178  CD1 ILE A 149      34.099  39.550   2.810  1.00 29.03           C  
ATOM   1179  N   ASP A 150      37.105  43.490   6.331  1.00 30.30           N  
ATOM   1180  CA  ASP A 150      37.957  44.611   6.678  1.00 31.18           C  
ATOM   1181  C   ASP A 150      39.308  44.432   6.020  1.00 31.90           C  
ATOM   1182  O   ASP A 150      39.979  43.430   6.257  1.00 31.92           O  
ATOM   1183  CB  ASP A 150      38.124  44.638   8.207  1.00 32.06           C  
ATOM   1184  CG  ASP A 150      38.479  46.004   8.749  1.00 33.55           C  
ATOM   1185  OD1 ASP A 150      38.450  46.965   7.988  1.00 38.59           O  
ATOM   1186  OD2 ASP A 150      38.791  46.133   9.954  1.00 36.96           O  
ATOM   1187  N   TYR A 151      39.679  45.407   5.190  1.00 32.24           N  
ATOM   1188  CA  TYR A 151      41.002  45.523   4.579  1.00 32.97           C  
ATOM   1189  C   TYR A 151      42.021  46.047   5.600  1.00 33.00           C  
ATOM   1190  O   TYR A 151      41.874  47.150   6.104  1.00 32.97           O  
ATOM   1191  CB  TYR A 151      40.923  46.472   3.354  1.00 33.27           C  
ATOM   1192  CG  TYR A 151      40.372  45.849   2.067  1.00 34.51           C  
ATOM   1193  CD1 TYR A 151      41.159  45.774   0.925  1.00 36.16           C  
ATOM   1194  CD2 TYR A 151      39.067  45.334   1.994  1.00 36.76           C  
ATOM   1195  CE1 TYR A 151      40.677  45.199  -0.262  1.00 35.54           C  
ATOM   1196  CE2 TYR A 151      38.581  44.753   0.810  1.00 35.68           C  
ATOM   1197  CZ  TYR A 151      39.401  44.691  -0.313  1.00 34.78           C  
ATOM   1198  OH  TYR A 151      38.948  44.135  -1.498  1.00 32.59           O  
ATOM   1199  N   ILE A 152      43.060  45.268   5.901  1.00 32.66           N  
ATOM   1200  CA  ILE A 152      44.076  45.700   6.871  1.00 32.68           C  
ATOM   1201  C   ILE A 152      45.219  46.461   6.213  1.00 33.16           C  
ATOM   1202  O   ILE A 152      45.970  45.917   5.378  1.00 32.02           O  
ATOM   1203  CB  ILE A 152      44.673  44.534   7.715  1.00 32.90           C  
ATOM   1204  CG1 ILE A 152      43.598  43.525   8.137  1.00 33.99           C  
ATOM   1205  CG2 ILE A 152      45.390  45.102   8.929  1.00 32.09           C  
ATOM   1206  CD1 ILE A 152      42.427  44.141   8.986  1.00 35.07           C  
ATOM   1207  N   LEU A 153      45.372  47.717   6.608  1.00 32.82           N  
ATOM   1208  CA  LEU A 153      46.329  48.600   5.950  1.00 34.04           C  
ATOM   1209  C   LEU A 153      47.402  49.049   6.922  1.00 35.16           C  
ATOM   1210  O   LEU A 153      47.105  49.476   8.043  1.00 35.27           O  
ATOM   1211  CB  LEU A 153      45.619  49.828   5.360  1.00 32.88           C  
ATOM   1212  CG  LEU A 153      44.390  49.588   4.480  1.00 34.04           C  
ATOM   1213  CD1 LEU A 153      43.603  50.886   4.319  1.00 35.05           C  
ATOM   1214  CD2 LEU A 153      44.743  48.971   3.111  1.00 33.90           C  
ATOM   1215  N   LEU A 154      48.653  48.951   6.493  1.00 36.21           N  
ATOM   1216  CA  LEU A 154      49.759  49.414   7.308  1.00 36.99           C  
ATOM   1217  C   LEU A 154      50.511  50.576   6.663  1.00 37.60           C  
ATOM   1218  O   LEU A 154      50.786  50.569   5.467  1.00 37.16           O  
ATOM   1219  CB  LEU A 154      50.687  48.252   7.661  1.00 37.61           C  
ATOM   1220  CG  LEU A 154      50.360  47.484   8.947  1.00 38.87           C  
ATOM   1221  CD1 LEU A 154      49.198  46.492   8.780  1.00 40.27           C  
ATOM   1222  CD2 LEU A 154      51.603  46.764   9.439  1.00 40.32           C  
ATOM   1223  N   VAL A 155      50.792  51.592   7.476  1.00 38.88           N  
ATOM   1224  CA  VAL A 155      51.544  52.770   7.059  1.00 40.68           C  
ATOM   1225  C   VAL A 155      52.708  52.982   8.037  1.00 41.95           C  
ATOM   1226  O   VAL A 155      52.542  52.777   9.241  1.00 41.96           O  
ATOM   1227  CB  VAL A 155      50.632  54.036   7.001  1.00 40.44           C  
ATOM   1228  CG1 VAL A 155      51.401  55.250   6.503  1.00 40.80           C  
ATOM   1229  CG2 VAL A 155      49.450  53.799   6.093  1.00 40.37           C  
ATOM   1230  N   ARG A 156      53.883  53.346   7.506  1.00 43.49           N  
ATOM   1231  CA  ARG A 156      55.056  53.747   8.315  1.00 44.79           C  
ATOM   1232  C   ARG A 156      55.525  55.134   7.890  1.00 44.52           C  
ATOM   1233  O   ARG A 156      56.167  55.298   6.854  1.00 44.57           O  
ATOM   1234  CB  ARG A 156      56.210  52.755   8.173  1.00 45.38           C  
ATOM   1235  CG  ARG A 156      55.869  51.307   8.510  1.00 49.10           C  
ATOM   1236  CD  ARG A 156      57.097  50.400   8.336  1.00 52.66           C  
ATOM   1237  NE  ARG A 156      58.078  50.523   9.401  1.00 57.38           N  
ATOM   1238  CZ  ARG A 156      59.396  50.334   9.328  1.00 59.29           C  
ATOM   1239  NH1 ARG A 156      60.032  50.024   8.195  1.00 59.87           N  
ATOM   1240  NH2 ARG A 156      60.088  50.486  10.448  1.00 58.48           N  
HETATM 1241  N   MSE A 157      55.203  56.133   8.704  1.00 44.50           N  
HETATM 1242  CA  MSE A 157      55.283  57.525   8.279  1.00 44.57           C  
HETATM 1243  C   MSE A 157      55.257  58.401   9.509  1.00 43.57           C  
HETATM 1244  O   MSE A 157      54.557  58.097  10.460  1.00 43.79           O  
HETATM 1245  CB  MSE A 157      54.079  57.844   7.378  1.00 45.13           C  
HETATM 1246  CG  MSE A 157      54.245  59.017   6.418  1.00 48.13           C  
HETATM 1247 SE   MSE A 157      55.906  58.976   5.361  0.50 55.39          SE  
HETATM 1248  CE  MSE A 157      55.726  57.254   4.465  1.00 43.22           C  
ATOM   1249  N   ASN A 158      56.044  59.467   9.508  1.00 43.30           N  
ATOM   1250  CA  ASN A 158      55.972  60.468  10.555  1.00 43.40           C  
ATOM   1251  C   ASN A 158      54.982  61.522  10.083  1.00 43.31           C  
ATOM   1252  O   ASN A 158      55.215  62.169   9.069  1.00 44.27           O  
ATOM   1253  CB  ASN A 158      57.342  61.106  10.793  1.00 43.74           C  
ATOM   1254  CG  ASN A 158      58.260  60.243  11.638  1.00 44.16           C  
ATOM   1255  OD1 ASN A 158      57.818  59.336  12.337  1.00 46.63           O  
ATOM   1256  ND2 ASN A 158      59.554  60.535  11.584  1.00 43.79           N  
ATOM   1257  N   VAL A 159      53.878  61.692  10.800  1.00 42.78           N  
ATOM   1258  CA  VAL A 159      52.792  62.559  10.312  1.00 42.20           C  
ATOM   1259  C   VAL A 159      52.486  63.736  11.244  1.00 42.16           C  
ATOM   1260  O   VAL A 159      52.826  63.705  12.423  1.00 41.61           O  
ATOM   1261  CB  VAL A 159      51.482  61.757  10.037  1.00 41.48           C  
ATOM   1262  CG1 VAL A 159      51.687  60.746   8.914  1.00 41.13           C  
ATOM   1263  CG2 VAL A 159      50.967  61.083  11.315  1.00 41.84           C  
ATOM   1264  N   THR A 160      51.855  64.771  10.698  1.00 42.21           N  
ATOM   1265  CA  THR A 160      51.423  65.921  11.486  1.00 42.86           C  
ATOM   1266  C   THR A 160      49.967  65.724  11.835  1.00 42.51           C  
ATOM   1267  O   THR A 160      49.149  65.413  10.958  1.00 42.45           O  
ATOM   1268  CB  THR A 160      51.520  67.244  10.705  1.00 43.42           C  
ATOM   1269  OG1 THR A 160      52.641  67.214   9.810  1.00 46.26           O  
ATOM   1270  CG2 THR A 160      51.647  68.423  11.667  1.00 44.67           C  
ATOM   1271  N   LEU A 161      49.635  65.917  13.109  1.00 41.75           N  
ATOM   1272  CA  LEU A 161      48.286  65.644  13.586  1.00 41.00           C  
ATOM   1273  C   LEU A 161      47.502  66.897  13.964  1.00 40.25           C  
ATOM   1274  O   LEU A 161      48.025  67.809  14.588  1.00 40.18           O  
ATOM   1275  CB  LEU A 161      48.312  64.659  14.762  1.00 40.58           C  
ATOM   1276  CG  LEU A 161      48.979  63.298  14.539  1.00 40.16           C  
ATOM   1277  CD1 LEU A 161      48.903  62.477  15.802  1.00 40.20           C  
ATOM   1278  CD2 LEU A 161      48.360  62.533  13.372  1.00 36.76           C  
ATOM   1279  N   ASN A 162      46.268  66.953  13.537  1.00 39.78           N  
ATOM   1280  CA  ASN A 162      45.278  67.849  14.117  1.00 40.29           C  
ATOM   1281  C   ASN A 162      43.966  67.139  13.994  1.00 39.49           C  
ATOM   1282  O   ASN A 162      43.257  67.356  13.065  1.00 40.25           O  
ATOM   1283  CB  ASN A 162      45.228  69.173  13.334  1.00 41.13           C  
ATOM   1284  CG  ASN A 162      44.321  70.223  13.970  1.00 43.71           C  
ATOM   1285  OD1 ASN A 162      43.629  70.899  13.284  1.00 46.55           O  
ATOM   1286  ND2 ASN A 162      44.369  70.367  15.266  1.00 48.23           N  
ATOM   1287  N   PRO A 163      43.666  66.266  14.928  1.00 38.86           N  
ATOM   1288  CA  PRO A 163      42.483  65.414  14.833  1.00 39.15           C  
ATOM   1289  C   PRO A 163      41.179  66.169  15.116  1.00 39.54           C  
ATOM   1290  O   PRO A 163      41.206  67.203  15.785  1.00 39.47           O  
ATOM   1291  CB  PRO A 163      42.731  64.346  15.901  1.00 38.72           C  
ATOM   1292  CG  PRO A 163      44.137  64.564  16.376  1.00 38.95           C  
ATOM   1293  CD  PRO A 163      44.437  65.992  16.146  1.00 38.56           C  
ATOM   1294  N   ASP A 164      40.069  65.652  14.579  1.00 39.37           N  
ATOM   1295  CA  ASP A 164      38.724  66.174  14.817  1.00 39.70           C  
ATOM   1296  C   ASP A 164      38.207  65.633  16.159  1.00 40.29           C  
ATOM   1297  O   ASP A 164      38.038  64.409  16.305  1.00 39.50           O  
ATOM   1298  CB  ASP A 164      37.802  65.735  13.668  1.00 39.87           C  
ATOM   1299  CG  ASP A 164      36.441  66.451  13.661  1.00 40.64           C  
ATOM   1300  OD1 ASP A 164      36.043  67.069  14.670  1.00 41.17           O  
ATOM   1301  OD2 ASP A 164      35.757  66.379  12.615  1.00 40.34           O  
ATOM   1302  N   PRO A 165      37.949  66.539  17.146  1.00 40.64           N  
ATOM   1303  CA  PRO A 165      37.416  66.127  18.454  1.00 40.25           C  
ATOM   1304  C   PRO A 165      36.044  65.459  18.363  1.00 39.69           C  
ATOM   1305  O   PRO A 165      35.643  64.738  19.285  1.00 39.63           O  
ATOM   1306  CB  PRO A 165      37.316  67.450  19.240  1.00 40.50           C  
ATOM   1307  CG  PRO A 165      37.282  68.513  18.213  1.00 41.17           C  
ATOM   1308  CD  PRO A 165      38.149  68.003  17.087  1.00 40.58           C  
ATOM   1309  N   ASN A 166      35.336  65.695  17.264  1.00 39.13           N  
ATOM   1310  CA  ASN A 166      34.070  65.016  17.020  1.00 38.89           C  
ATOM   1311  C   ASN A 166      34.243  63.540  16.663  1.00 37.65           C  
ATOM   1312  O   ASN A 166      33.323  62.744  16.842  1.00 37.73           O  
ATOM   1313  CB  ASN A 166      33.269  65.719  15.919  1.00 39.15           C  
ATOM   1314  CG  ASN A 166      31.928  65.047  15.667  1.00 39.69           C  
ATOM   1315  OD1 ASN A 166      31.659  64.554  14.571  1.00 40.20           O  
ATOM   1316  ND2 ASN A 166      31.102  64.983  16.701  1.00 40.73           N  
ATOM   1317  N   GLU A 167      35.416  63.193  16.146  1.00 36.98           N  
ATOM   1318  CA  GLU A 167      35.716  61.824  15.728  1.00 36.66           C  
ATOM   1319  C   GLU A 167      36.527  61.082  16.780  1.00 35.86           C  
ATOM   1320  O   GLU A 167      36.319  59.899  17.020  1.00 34.82           O  
ATOM   1321  CB  GLU A 167      36.482  61.835  14.399  1.00 36.42           C  
ATOM   1322  CG  GLU A 167      35.638  62.151  13.174  1.00 37.26           C  
ATOM   1323  CD  GLU A 167      34.737  60.998  12.766  1.00 39.53           C  
ATOM   1324  OE1 GLU A 167      34.845  59.910  13.375  1.00 41.98           O  
ATOM   1325  OE2 GLU A 167      33.924  61.164  11.829  1.00 40.01           O  
ATOM   1326  N   ILE A 168      37.419  61.828  17.427  1.00 36.46           N  
ATOM   1327  CA  ILE A 168      38.484  61.301  18.266  1.00 36.54           C  
ATOM   1328  C   ILE A 168      38.556  62.045  19.609  1.00 36.68           C  
ATOM   1329  O   ILE A 168      38.718  63.269  19.654  1.00 37.98           O  
ATOM   1330  CB  ILE A 168      39.822  61.373  17.467  1.00 36.98           C  
ATOM   1331  CG1 ILE A 168      39.843  60.259  16.416  1.00 35.74           C  
ATOM   1332  CG2 ILE A 168      41.053  61.336  18.373  1.00 36.18           C  
ATOM   1333  CD1 ILE A 168      40.662  60.554  15.196  1.00 35.39           C  
ATOM   1334  N   LYS A 169      38.421  61.287  20.692  1.00 35.65           N  
ATOM   1335  CA  LYS A 169      38.553  61.781  22.058  1.00 34.73           C  
ATOM   1336  C   LYS A 169      39.992  62.045  22.462  1.00 35.08           C  
ATOM   1337  O   LYS A 169      40.294  63.042  23.108  1.00 33.87           O  
ATOM   1338  CB  LYS A 169      37.987  60.740  23.015  1.00 35.33           C  
ATOM   1339  CG  LYS A 169      37.599  61.279  24.371  1.00 38.25           C  
ATOM   1340  CD  LYS A 169      36.842  60.246  25.193  1.00 39.97           C  
ATOM   1341  CE  LYS A 169      36.176  60.934  26.395  1.00 43.40           C  
ATOM   1342  NZ  LYS A 169      35.405  60.005  27.280  1.00 45.15           N  
ATOM   1343  N   SER A 170      40.882  61.112  22.124  1.00 34.15           N  
ATOM   1344  CA  SER A 170      42.281  61.253  22.433  1.00 33.95           C  
ATOM   1345  C   SER A 170      43.025  60.314  21.510  1.00 33.61           C  
ATOM   1346  O   SER A 170      42.418  59.476  20.852  1.00 32.61           O  
ATOM   1347  CB  SER A 170      42.573  60.897  23.899  1.00 34.78           C  
ATOM   1348  OG  SER A 170      42.426  59.504  24.144  1.00 37.85           O  
ATOM   1349  N   TYR A 171      44.337  60.476  21.456  1.00 34.24           N  
ATOM   1350  CA  TYR A 171      45.201  59.625  20.648  1.00 34.50           C  
ATOM   1351  C   TYR A 171      46.545  59.519  21.339  1.00 34.72           C  
ATOM   1352  O   TYR A 171      46.880  60.353  22.173  1.00 34.14           O  
ATOM   1353  CB  TYR A 171      45.365  60.218  19.241  1.00 35.49           C  
ATOM   1354  CG  TYR A 171      46.027  61.582  19.219  1.00 37.33           C  
ATOM   1355  CD1 TYR A 171      47.387  61.706  19.000  1.00 34.98           C  
ATOM   1356  CD2 TYR A 171      45.285  62.747  19.437  1.00 38.38           C  
ATOM   1357  CE1 TYR A 171      47.998  62.934  18.985  1.00 38.37           C  
ATOM   1358  CE2 TYR A 171      45.890  63.990  19.435  1.00 40.10           C  
ATOM   1359  CZ  TYR A 171      47.249  64.075  19.200  1.00 40.86           C  
ATOM   1360  OH  TYR A 171      47.875  65.304  19.189  1.00 44.48           O  
ATOM   1361  N   CYS A 172      47.319  58.492  20.995  1.00 35.09           N  
ATOM   1362  CA  CYS A 172      48.644  58.312  21.574  1.00 36.38           C  
ATOM   1363  C   CYS A 172      49.432  57.290  20.777  1.00 35.26           C  
ATOM   1364  O   CYS A 172      48.862  56.350  20.234  1.00 35.33           O  
ATOM   1365  CB  CYS A 172      48.566  57.855  23.038  1.00 36.58           C  
ATOM   1366  SG  CYS A 172      47.544  56.379  23.322  1.00 47.79           S  
ATOM   1367  N   TYR A 173      50.737  57.495  20.708  1.00 35.20           N  
ATOM   1368  CA  TYR A 173      51.669  56.504  20.141  1.00 35.59           C  
ATOM   1369  C   TYR A 173      52.158  55.575  21.233  1.00 35.41           C  
ATOM   1370  O   TYR A 173      52.596  56.039  22.290  1.00 35.57           O  
ATOM   1371  CB  TYR A 173      52.882  57.193  19.548  1.00 35.93           C  
ATOM   1372  CG  TYR A 173      52.610  58.059  18.345  1.00 36.62           C  
ATOM   1373  CD1 TYR A 173      52.645  57.520  17.060  1.00 37.51           C  
ATOM   1374  CD2 TYR A 173      52.374  59.431  18.484  1.00 36.50           C  
ATOM   1375  CE1 TYR A 173      52.419  58.318  15.936  1.00 38.11           C  
ATOM   1376  CE2 TYR A 173      52.156  60.239  17.370  1.00 38.26           C  
ATOM   1377  CZ  TYR A 173      52.172  59.674  16.099  1.00 38.20           C  
ATOM   1378  OH  TYR A 173      51.967  60.462  14.984  1.00 40.07           O  
ATOM   1379  N   VAL A 174      52.102  54.270  20.970  1.00 35.95           N  
ATOM   1380  CA  VAL A 174      52.518  53.248  21.938  1.00 35.36           C  
ATOM   1381  C   VAL A 174      53.610  52.307  21.407  1.00 36.26           C  
ATOM   1382  O   VAL A 174      53.620  51.931  20.229  1.00 35.23           O  
ATOM   1383  CB  VAL A 174      51.322  52.399  22.452  1.00 35.28           C  
ATOM   1384  CG1 VAL A 174      50.317  53.274  23.210  1.00 36.31           C  
ATOM   1385  CG2 VAL A 174      50.627  51.687  21.317  1.00 33.24           C  
ATOM   1386  N   SER A 175      54.517  51.929  22.295  1.00 36.94           N  
ATOM   1387  CA  SER A 175      55.456  50.851  22.019  1.00 38.86           C  
ATOM   1388  C   SER A 175      54.720  49.524  22.177  1.00 39.52           C  
ATOM   1389  O   SER A 175      53.575  49.491  22.654  1.00 38.21           O  
ATOM   1390  CB  SER A 175      56.645  50.919  22.978  1.00 39.34           C  
ATOM   1391  OG  SER A 175      56.220  50.747  24.318  1.00 38.85           O  
ATOM   1392  N   LYS A 176      55.370  48.439  21.756  1.00 40.65           N  
ATOM   1393  CA  LYS A 176      54.816  47.098  21.879  1.00 42.27           C  
ATOM   1394  C   LYS A 176      54.402  46.810  23.317  1.00 42.50           C  
ATOM   1395  O   LYS A 176      53.352  46.225  23.563  1.00 42.23           O  
ATOM   1396  CB  LYS A 176      55.853  46.050  21.472  1.00 43.15           C  
ATOM   1397  CG  LYS A 176      56.136  45.912  19.995  1.00 45.92           C  
ATOM   1398  CD  LYS A 176      56.917  44.619  19.768  1.00 50.92           C  
ATOM   1399  CE  LYS A 176      57.301  44.405  18.313  1.00 53.07           C  
ATOM   1400  NZ  LYS A 176      58.490  45.223  17.928  1.00 55.36           N  
ATOM   1401  N   GLU A 177      55.246  47.208  24.265  1.00 43.19           N  
ATOM   1402  CA  GLU A 177      55.008  46.889  25.662  1.00 44.86           C  
ATOM   1403  C   GLU A 177      53.891  47.741  26.241  1.00 44.07           C  
ATOM   1404  O   GLU A 177      53.106  47.260  27.054  1.00 44.51           O  
ATOM   1405  CB  GLU A 177      56.292  47.008  26.487  1.00 46.20           C  
ATOM   1406  CG  GLU A 177      57.399  46.018  26.069  1.00 52.52           C  
ATOM   1407  CD  GLU A 177      57.011  44.531  26.190  1.00 59.33           C  
ATOM   1408  OE1 GLU A 177      56.163  44.175  27.044  1.00 61.29           O  
ATOM   1409  OE2 GLU A 177      57.579  43.708  25.429  1.00 62.28           O  
ATOM   1410  N   GLU A 178      53.809  48.994  25.799  1.00 43.37           N  
ATOM   1411  CA  GLU A 178      52.738  49.902  26.224  1.00 43.25           C  
ATOM   1412  C   GLU A 178      51.362  49.440  25.730  1.00 42.65           C  
ATOM   1413  O   GLU A 178      50.355  49.627  26.429  1.00 43.37           O  
ATOM   1414  CB  GLU A 178      53.025  51.348  25.785  1.00 43.14           C  
ATOM   1415  CG  GLU A 178      54.194  51.987  26.523  1.00 43.76           C  
ATOM   1416  CD  GLU A 178      54.812  53.176  25.795  1.00 46.30           C  
ATOM   1417  OE1 GLU A 178      54.441  53.471  24.629  1.00 44.11           O  
ATOM   1418  OE2 GLU A 178      55.696  53.821  26.403  1.00 48.75           O  
ATOM   1419  N   LEU A 179      51.315  48.843  24.538  1.00 40.87           N  
ATOM   1420  CA  LEU A 179      50.065  48.284  24.048  1.00 40.31           C  
ATOM   1421  C   LEU A 179      49.655  47.040  24.828  1.00 40.82           C  
ATOM   1422  O   LEU A 179      48.485  46.880  25.163  1.00 40.03           O  
ATOM   1423  CB  LEU A 179      50.092  48.006  22.548  1.00 39.80           C  
ATOM   1424  CG  LEU A 179      48.783  47.424  22.002  1.00 39.62           C  
ATOM   1425  CD1 LEU A 179      47.573  48.389  22.133  1.00 37.38           C  
ATOM   1426  CD2 LEU A 179      48.982  46.982  20.567  1.00 39.33           C  
ATOM   1427  N   LYS A 180      50.617  46.165  25.122  1.00 41.46           N  
ATOM   1428  CA  LYS A 180      50.343  45.011  25.981  1.00 42.28           C  
ATOM   1429  C   LYS A 180      49.743  45.450  27.322  1.00 42.89           C  
ATOM   1430  O   LYS A 180      48.793  44.837  27.808  1.00 42.74           O  
ATOM   1431  CB  LYS A 180      51.602  44.162  26.174  1.00 42.38           C  
ATOM   1432  CG  LYS A 180      51.976  43.413  24.909  1.00 43.47           C  
ATOM   1433  CD  LYS A 180      53.203  42.539  25.067  1.00 45.74           C  
ATOM   1434  CE  LYS A 180      53.418  41.725  23.794  1.00 46.90           C  
ATOM   1435  NZ  LYS A 180      54.704  40.967  23.821  1.00 50.56           N  
ATOM   1436  N   GLU A 181      50.286  46.530  27.875  1.00 43.68           N  
ATOM   1437  CA  GLU A 181      49.841  47.127  29.128  1.00 45.70           C  
ATOM   1438  C   GLU A 181      48.407  47.666  29.001  1.00 45.56           C  
ATOM   1439  O   GLU A 181      47.569  47.482  29.891  1.00 45.79           O  
ATOM   1440  CB  GLU A 181      50.801  48.263  29.485  1.00 46.42           C  
ATOM   1441  CG  GLU A 181      50.991  48.545  30.967  1.00 50.73           C  
ATOM   1442  CD  GLU A 181      52.016  49.658  31.231  1.00 53.27           C  
ATOM   1443  OE1 GLU A 181      52.332  50.430  30.292  1.00 57.78           O  
ATOM   1444  OE2 GLU A 181      52.506  49.769  32.382  1.00 57.91           O  
ATOM   1445  N   LEU A 182      48.144  48.328  27.878  1.00 44.85           N  
ATOM   1446  CA  LEU A 182      46.820  48.840  27.535  1.00 44.39           C  
ATOM   1447  C   LEU A 182      45.798  47.724  27.310  1.00 43.37           C  
ATOM   1448  O   LEU A 182      44.636  47.861  27.681  1.00 42.22           O  
ATOM   1449  CB  LEU A 182      46.923  49.724  26.294  1.00 44.58           C  
ATOM   1450  CG  LEU A 182      45.678  50.547  25.992  1.00 47.99           C  
ATOM   1451  CD1 LEU A 182      46.037  52.027  25.825  1.00 50.88           C  
ATOM   1452  CD2 LEU A 182      44.913  49.979  24.787  1.00 48.43           C  
ATOM   1453  N   LEU A 183      46.238  46.625  26.703  1.00 42.35           N  
ATOM   1454  CA  LEU A 183      45.370  45.478  26.461  1.00 42.38           C  
ATOM   1455  C   LEU A 183      45.004  44.739  27.758  1.00 42.29           C  
ATOM   1456  O   LEU A 183      43.988  44.047  27.821  1.00 42.48           O  
ATOM   1457  CB  LEU A 183      46.016  44.511  25.456  1.00 42.66           C  
ATOM   1458  CG  LEU A 183      46.206  44.903  23.982  1.00 42.58           C  
ATOM   1459  CD1 LEU A 183      47.006  43.826  23.272  1.00 40.87           C  
ATOM   1460  CD2 LEU A 183      44.874  45.151  23.261  1.00 41.07           C  
ATOM   1461  N   LYS A 184      45.836  44.884  28.785  1.00 42.69           N  
ATOM   1462  CA  LYS A 184      45.556  44.310  30.100  1.00 43.60           C  
ATOM   1463  C   LYS A 184      44.529  45.148  30.863  1.00 43.41           C  
ATOM   1464  O   LYS A 184      43.736  44.618  31.639  1.00 43.37           O  
ATOM   1465  CB  LYS A 184      46.849  44.148  30.909  1.00 44.30           C  
ATOM   1466  CG  LYS A 184      47.726  43.009  30.411  1.00 47.64           C  
ATOM   1467  CD  LYS A 184      49.176  43.134  30.869  1.00 51.58           C  
ATOM   1468  CE  LYS A 184      50.046  42.064  30.192  1.00 54.62           C  
ATOM   1469  NZ  LYS A 184      51.487  42.150  30.581  1.00 56.92           N  
ATOM   1470  N   LYS A 185      44.559  46.456  30.641  1.00 43.61           N  
ATOM   1471  CA  LYS A 185      43.555  47.359  31.208  1.00 44.47           C  
ATOM   1472  C   LYS A 185      42.184  47.151  30.558  1.00 44.10           C  
ATOM   1473  O   LYS A 185      41.153  47.255  31.219  1.00 44.57           O  
ATOM   1474  CB  LYS A 185      44.008  48.820  31.082  1.00 44.58           C  
ATOM   1475  CG  LYS A 185      45.122  49.202  32.045  1.00 47.84           C  
ATOM   1476  CD  LYS A 185      45.192  50.701  32.281  1.00 51.41           C  
ATOM   1477  CE  LYS A 185      45.844  51.410  31.111  1.00 54.89           C  
ATOM   1478  NZ  LYS A 185      46.251  52.803  31.464  1.00 58.13           N  
ATOM   1479  N   ALA A 186      42.189  46.845  29.263  1.00 43.51           N  
ATOM   1480  CA  ALA A 186      40.983  46.497  28.531  1.00 43.52           C  
ATOM   1481  C   ALA A 186      40.397  45.171  29.010  1.00 43.57           C  
ATOM   1482  O   ALA A 186      39.193  45.080  29.242  1.00 43.25           O  
ATOM   1483  CB  ALA A 186      41.258  46.449  27.035  1.00 43.20           C  
ATOM   1484  N   ALA A 187      41.250  44.154  29.154  1.00 43.46           N  
ATOM   1485  CA  ALA A 187      40.826  42.829  29.630  1.00 43.82           C  
ATOM   1486  C   ALA A 187      40.260  42.857  31.057  1.00 44.11           C  
ATOM   1487  O   ALA A 187      39.449  42.000  31.430  1.00 44.95           O  
ATOM   1488  CB  ALA A 187      41.981  41.807  29.522  1.00 43.22           C  
ATOM   1489  N   SER A 188      40.684  43.833  31.848  1.00 43.90           N  
ATOM   1490  CA  SER A 188      40.209  43.956  33.218  1.00 44.31           C  
ATOM   1491  C   SER A 188      39.149  45.049  33.391  1.00 44.53           C  
ATOM   1492  O   SER A 188      38.857  45.455  34.514  1.00 44.30           O  
ATOM   1493  CB  SER A 188      41.384  44.184  34.169  1.00 44.13           C  
ATOM   1494  OG  SER A 188      42.090  45.359  33.839  1.00 45.62           O  
ATOM   1495  N   GLY A 189      38.587  45.515  32.276  1.00 44.71           N  
ATOM   1496  CA  GLY A 189      37.491  46.495  32.275  1.00 45.14           C  
ATOM   1497  C   GLY A 189      37.803  47.932  32.680  1.00 45.42           C  
ATOM   1498  O   GLY A 189      36.885  48.701  32.983  1.00 45.60           O  
ATOM   1499  N   GLU A 190      39.080  48.302  32.688  1.00 45.55           N  
ATOM   1500  CA  GLU A 190      39.491  49.657  33.064  1.00 46.61           C  
ATOM   1501  C   GLU A 190      39.313  50.650  31.922  1.00 46.14           C  
ATOM   1502  O   GLU A 190      38.973  51.814  32.150  1.00 47.05           O  
ATOM   1503  CB  GLU A 190      40.933  49.683  33.564  1.00 47.66           C  
ATOM   1504  CG  GLU A 190      41.206  48.656  34.652  1.00 51.99           C  
ATOM   1505  CD  GLU A 190      42.481  48.934  35.412  1.00 55.88           C  
ATOM   1506  OE1 GLU A 190      43.573  48.507  34.951  1.00 56.63           O  
ATOM   1507  OE2 GLU A 190      42.377  49.576  36.481  1.00 57.32           O  
ATOM   1508  N   ILE A 191      39.556  50.189  30.699  1.00 45.03           N  
ATOM   1509  CA  ILE A 191      39.196  50.928  29.495  1.00 43.63           C  
ATOM   1510  C   ILE A 191      38.455  49.987  28.550  1.00 42.88           C  
ATOM   1511  O   ILE A 191      38.279  48.812  28.858  1.00 42.89           O  
ATOM   1512  CB  ILE A 191      40.429  51.523  28.799  1.00 43.57           C  
ATOM   1513  CG1 ILE A 191      41.508  50.454  28.621  1.00 43.27           C  
ATOM   1514  CG2 ILE A 191      40.965  52.715  29.585  1.00 43.72           C  
ATOM   1515  CD1 ILE A 191      42.257  50.565  27.331  1.00 43.33           C  
ATOM   1516  N   LYS A 192      38.003  50.506  27.415  1.00 42.37           N  
ATOM   1517  CA  LYS A 192      37.350  49.680  26.397  1.00 42.47           C  
ATOM   1518  C   LYS A 192      38.113  49.727  25.074  1.00 41.28           C  
ATOM   1519  O   LYS A 192      38.714  50.739  24.722  1.00 41.08           O  
ATOM   1520  CB  LYS A 192      35.892  50.101  26.179  1.00 42.94           C  
ATOM   1521  CG  LYS A 192      34.977  49.821  27.358  1.00 44.87           C  
ATOM   1522  CD  LYS A 192      33.608  50.487  27.183  1.00 46.50           C  
ATOM   1523  CE  LYS A 192      32.617  49.554  26.491  1.00 50.11           C  
ATOM   1524  NZ  LYS A 192      31.186  49.948  26.706  1.00 52.98           N  
ATOM   1525  N   ILE A 193      38.108  48.604  24.368  1.00 40.07           N  
ATOM   1526  CA  ILE A 193      38.669  48.528  23.032  1.00 38.74           C  
ATOM   1527  C   ILE A 193      37.621  47.982  22.064  1.00 37.82           C  
ATOM   1528  O   ILE A 193      36.737  47.218  22.454  1.00 38.66           O  
ATOM   1529  CB  ILE A 193      39.997  47.685  22.983  1.00 38.63           C  
ATOM   1530  CG1 ILE A 193      39.733  46.202  23.302  1.00 38.73           C  
ATOM   1531  CG2 ILE A 193      41.066  48.304  23.897  1.00 37.18           C  
ATOM   1532  CD1 ILE A 193      40.895  45.273  22.942  1.00 38.02           C  
ATOM   1533  N   THR A 194      37.720  48.381  20.803  1.00 37.40           N  
ATOM   1534  CA  THR A 194      36.792  47.916  19.778  1.00 36.41           C  
ATOM   1535  C   THR A 194      37.006  46.424  19.497  1.00 37.55           C  
ATOM   1536  O   THR A 194      38.113  45.912  19.674  1.00 35.61           O  
ATOM   1537  CB  THR A 194      36.993  48.692  18.471  1.00 36.23           C  
ATOM   1538  OG1 THR A 194      38.335  48.487  18.005  1.00 37.28           O  
ATOM   1539  CG2 THR A 194      36.728  50.181  18.679  1.00 33.38           C  
ATOM   1540  N   PRO A 195      35.946  45.726  19.051  1.00 38.35           N  
ATOM   1541  CA  PRO A 195      36.057  44.290  18.870  1.00 39.06           C  
ATOM   1542  C   PRO A 195      37.046  43.906  17.763  1.00 39.24           C  
ATOM   1543  O   PRO A 195      37.728  42.895  17.900  1.00 40.13           O  
ATOM   1544  CB  PRO A 195      34.622  43.864  18.524  1.00 38.97           C  
ATOM   1545  CG  PRO A 195      33.989  45.081  17.961  1.00 38.77           C  
ATOM   1546  CD  PRO A 195      34.604  46.226  18.698  1.00 38.53           C  
ATOM   1547  N   TRP A 196      37.149  44.709  16.705  1.00 39.49           N  
ATOM   1548  CA  TRP A 196      38.074  44.385  15.619  1.00 39.91           C  
ATOM   1549  C   TRP A 196      39.527  44.569  16.046  1.00 40.19           C  
ATOM   1550  O   TRP A 196      40.400  43.827  15.608  1.00 41.03           O  
ATOM   1551  CB  TRP A 196      37.765  45.167  14.329  1.00 39.47           C  
ATOM   1552  CG  TRP A 196      37.970  46.649  14.433  1.00 39.98           C  
ATOM   1553  CD1 TRP A 196      39.150  47.328  14.305  1.00 39.02           C  
ATOM   1554  CD2 TRP A 196      36.961  47.643  14.683  1.00 39.28           C  
ATOM   1555  NE1 TRP A 196      38.938  48.682  14.471  1.00 40.79           N  
ATOM   1556  CE2 TRP A 196      37.607  48.900  14.707  1.00 38.61           C  
ATOM   1557  CE3 TRP A 196      35.581  47.591  14.904  1.00 39.48           C  
ATOM   1558  CZ2 TRP A 196      36.914  50.094  14.941  1.00 38.65           C  
ATOM   1559  CZ3 TRP A 196      34.893  48.781  15.136  1.00 38.07           C  
ATOM   1560  CH2 TRP A 196      35.558  50.010  15.148  1.00 37.85           C  
ATOM   1561  N   PHE A 197      39.787  45.555  16.897  1.00 40.86           N  
ATOM   1562  CA  PHE A 197      41.134  45.795  17.401  1.00 41.04           C  
ATOM   1563  C   PHE A 197      41.577  44.678  18.359  1.00 42.42           C  
ATOM   1564  O   PHE A 197      42.743  44.280  18.354  1.00 41.87           O  
ATOM   1565  CB  PHE A 197      41.247  47.178  18.046  1.00 40.94           C  
ATOM   1566  CG  PHE A 197      42.631  47.536  18.471  1.00 39.10           C  
ATOM   1567  CD1 PHE A 197      43.620  47.769  17.528  1.00 39.35           C  
ATOM   1568  CD2 PHE A 197      42.951  47.644  19.816  1.00 41.07           C  
ATOM   1569  CE1 PHE A 197      44.921  48.089  17.917  1.00 39.21           C  
ATOM   1570  CE2 PHE A 197      44.250  47.973  20.221  1.00 41.42           C  
ATOM   1571  CZ  PHE A 197      45.235  48.191  19.263  1.00 40.02           C  
ATOM   1572  N   LYS A 198      40.640  44.168  19.158  1.00 43.41           N  
ATOM   1573  CA  LYS A 198      40.880  42.991  19.983  1.00 44.48           C  
ATOM   1574  C   LYS A 198      41.255  41.789  19.121  1.00 45.01           C  
ATOM   1575  O   LYS A 198      42.261  41.122  19.378  1.00 44.76           O  
ATOM   1576  CB  LYS A 198      39.646  42.661  20.814  1.00 45.68           C  
ATOM   1577  CG  LYS A 198      39.885  41.598  21.879  1.00 47.00           C  
ATOM   1578  CD  LYS A 198      38.578  41.080  22.452  1.00 50.74           C  
ATOM   1579  CE  LYS A 198      38.857  40.119  23.596  1.00 53.57           C  
ATOM   1580  NZ  LYS A 198      37.711  39.202  23.871  1.00 56.86           N  
ATOM   1581  N   ILE A 199      40.440  41.529  18.101  1.00 44.90           N  
ATOM   1582  CA  ILE A 199      40.682  40.469  17.116  1.00 44.80           C  
ATOM   1583  C   ILE A 199      42.098  40.527  16.516  1.00 44.67           C  
ATOM   1584  O   ILE A 199      42.850  39.556  16.598  1.00 44.99           O  
ATOM   1585  CB  ILE A 199      39.591  40.500  16.000  1.00 44.93           C  
ATOM   1586  CG1 ILE A 199      38.271  39.926  16.531  1.00 45.39           C  
ATOM   1587  CG2 ILE A 199      40.033  39.757  14.738  1.00 45.00           C  
ATOM   1588  CD1 ILE A 199      37.098  40.066  15.564  1.00 45.19           C  
ATOM   1589  N   ILE A 200      42.455  41.670  15.932  1.00 44.26           N  
ATOM   1590  CA  ILE A 200      43.739  41.843  15.260  1.00 44.03           C  
ATOM   1591  C   ILE A 200      44.913  41.831  16.248  1.00 44.28           C  
ATOM   1592  O   ILE A 200      45.974  41.261  15.950  1.00 43.46           O  
ATOM   1593  CB  ILE A 200      43.741  43.105  14.331  1.00 44.21           C  
ATOM   1594  CG1 ILE A 200      42.652  42.958  13.254  1.00 43.71           C  
ATOM   1595  CG2 ILE A 200      45.113  43.319  13.664  1.00 42.21           C  
ATOM   1596  CD1 ILE A 200      42.255  44.243  12.578  1.00 44.45           C  
ATOM   1597  N   ALA A 201      44.714  42.434  17.423  1.00 44.33           N  
ATOM   1598  CA  ALA A 201      45.762  42.455  18.455  1.00 45.08           C  
ATOM   1599  C   ALA A 201      46.106  41.055  18.972  1.00 45.70           C  
ATOM   1600  O   ALA A 201      47.278  40.736  19.210  1.00 45.38           O  
ATOM   1601  CB  ALA A 201      45.376  43.374  19.613  1.00 44.47           C  
ATOM   1602  N   ALA A 202      45.073  40.232  19.130  1.00 46.64           N  
ATOM   1603  CA  ALA A 202      45.224  38.865  19.604  1.00 47.65           C  
ATOM   1604  C   ALA A 202      45.846  37.944  18.552  1.00 48.79           C  
ATOM   1605  O   ALA A 202      46.466  36.937  18.896  1.00 49.54           O  
ATOM   1606  CB  ALA A 202      43.880  38.323  20.051  1.00 47.43           C  
ATOM   1607  N   THR A 203      45.694  38.297  17.278  1.00 49.43           N  
ATOM   1608  CA  THR A 203      45.979  37.368  16.188  1.00 49.87           C  
ATOM   1609  C   THR A 203      47.173  37.763  15.313  1.00 49.55           C  
ATOM   1610  O   THR A 203      48.123  36.995  15.185  1.00 50.46           O  
ATOM   1611  CB  THR A 203      44.710  37.128  15.323  1.00 50.21           C  
ATOM   1612  OG1 THR A 203      43.675  36.557  16.139  1.00 51.74           O  
ATOM   1613  CG2 THR A 203      45.000  36.182  14.160  1.00 52.17           C  
ATOM   1614  N   PHE A 204      47.131  38.949  14.718  1.00 48.66           N  
ATOM   1615  CA  PHE A 204      48.110  39.318  13.696  1.00 48.08           C  
ATOM   1616  C   PHE A 204      49.134  40.357  14.126  1.00 47.15           C  
ATOM   1617  O   PHE A 204      50.291  40.321  13.683  1.00 46.10           O  
ATOM   1618  CB  PHE A 204      47.404  39.893  12.474  1.00 48.56           C  
ATOM   1619  CG  PHE A 204      46.609  38.901  11.690  1.00 50.68           C  
ATOM   1620  CD1 PHE A 204      47.238  38.002  10.826  1.00 52.80           C  
ATOM   1621  CD2 PHE A 204      45.223  38.896  11.773  1.00 52.37           C  
ATOM   1622  CE1 PHE A 204      46.497  37.089  10.085  1.00 53.63           C  
ATOM   1623  CE2 PHE A 204      44.470  37.989  11.037  1.00 53.35           C  
ATOM   1624  CZ  PHE A 204      45.104  37.084  10.191  1.00 53.64           C  
ATOM   1625  N   LEU A 205      48.686  41.295  14.963  1.00 46.13           N  
ATOM   1626  CA  LEU A 205      49.365  42.575  15.146  1.00 45.02           C  
ATOM   1627  C   LEU A 205      50.817  42.488  15.602  1.00 44.53           C  
ATOM   1628  O   LEU A 205      51.671  43.177  15.047  1.00 44.08           O  
ATOM   1629  CB  LEU A 205      48.563  43.482  16.088  1.00 44.40           C  
ATOM   1630  CG  LEU A 205      49.170  44.846  16.416  1.00 44.80           C  
ATOM   1631  CD1 LEU A 205      49.255  45.742  15.177  1.00 45.98           C  
ATOM   1632  CD2 LEU A 205      48.359  45.529  17.506  1.00 45.45           C  
ATOM   1633  N   PHE A 206      51.092  41.674  16.621  1.00 44.62           N  
ATOM   1634  CA  PHE A 206      52.442  41.633  17.185  1.00 44.96           C  
ATOM   1635  C   PHE A 206      53.437  40.938  16.254  1.00 45.24           C  
ATOM   1636  O   PHE A 206      54.616  41.264  16.264  1.00 44.77           O  
ATOM   1637  CB  PHE A 206      52.447  41.055  18.607  1.00 44.58           C  
ATOM   1638  CG  PHE A 206      51.868  41.992  19.630  1.00 43.82           C  
ATOM   1639  CD1 PHE A 206      52.604  43.082  20.088  1.00 43.65           C  
ATOM   1640  CD2 PHE A 206      50.581  41.806  20.112  1.00 43.00           C  
ATOM   1641  CE1 PHE A 206      52.063  43.974  21.028  1.00 44.81           C  
ATOM   1642  CE2 PHE A 206      50.034  42.684  21.053  1.00 42.88           C  
ATOM   1643  CZ  PHE A 206      50.777  43.769  21.509  1.00 42.84           C  
ATOM   1644  N   LYS A 207      52.934  40.021  15.429  1.00 46.33           N  
ATOM   1645  CA  LYS A 207      53.724  39.380  14.371  1.00 47.55           C  
ATOM   1646  C   LYS A 207      54.140  40.376  13.284  1.00 47.78           C  
ATOM   1647  O   LYS A 207      55.310  40.409  12.880  1.00 47.62           O  
ATOM   1648  CB  LYS A 207      52.951  38.219  13.746  1.00 47.86           C  
ATOM   1649  CG  LYS A 207      52.397  37.237  14.767  1.00 50.32           C  
ATOM   1650  CD  LYS A 207      51.713  36.034  14.100  1.00 52.34           C  
ATOM   1651  CE  LYS A 207      51.254  35.010  15.148  1.00 56.12           C  
ATOM   1652  NZ  LYS A 207      52.372  34.555  16.050  1.00 56.96           N  
ATOM   1653  N   TRP A 208      53.186  41.189  12.817  1.00 47.69           N  
ATOM   1654  CA  TRP A 208      53.492  42.266  11.877  1.00 47.63           C  
ATOM   1655  C   TRP A 208      54.443  43.275  12.490  1.00 47.33           C  
ATOM   1656  O   TRP A 208      55.361  43.739  11.821  1.00 47.25           O  
ATOM   1657  CB  TRP A 208      52.237  43.020  11.455  1.00 48.28           C  
ATOM   1658  CG  TRP A 208      51.204  42.201  10.773  1.00 49.79           C  
ATOM   1659  CD1 TRP A 208      51.396  41.062  10.045  1.00 50.02           C  
ATOM   1660  CD2 TRP A 208      49.807  42.485  10.719  1.00 50.72           C  
ATOM   1661  NE1 TRP A 208      50.199  40.607   9.553  1.00 51.31           N  
ATOM   1662  CE2 TRP A 208      49.204  41.463   9.953  1.00 51.73           C  
ATOM   1663  CE3 TRP A 208      49.000  43.498  11.258  1.00 50.88           C  
ATOM   1664  CZ2 TRP A 208      47.827  41.429   9.701  1.00 51.37           C  
ATOM   1665  CZ3 TRP A 208      47.637  43.458  11.021  1.00 50.31           C  
ATOM   1666  CH2 TRP A 208      47.062  42.430  10.248  1.00 50.74           C  
ATOM   1667  N   TRP A 209      54.206  43.615  13.758  1.00 47.08           N  
ATOM   1668  CA  TRP A 209      54.999  44.616  14.473  1.00 47.33           C  
ATOM   1669  C   TRP A 209      56.482  44.234  14.584  1.00 48.91           C  
ATOM   1670  O   TRP A 209      57.364  45.088  14.447  1.00 49.02           O  
ATOM   1671  CB  TRP A 209      54.425  44.849  15.867  1.00 45.73           C  
ATOM   1672  CG  TRP A 209      54.663  46.225  16.414  1.00 42.22           C  
ATOM   1673  CD1 TRP A 209      55.689  47.072  16.110  1.00 39.79           C  
ATOM   1674  CD2 TRP A 209      53.855  46.902  17.377  1.00 39.19           C  
ATOM   1675  NE1 TRP A 209      55.565  48.240  16.822  1.00 39.90           N  
ATOM   1676  CE2 TRP A 209      54.447  48.159  17.610  1.00 39.40           C  
ATOM   1677  CE3 TRP A 209      52.683  46.571  18.061  1.00 40.08           C  
ATOM   1678  CZ2 TRP A 209      53.906  49.088  18.499  1.00 40.26           C  
ATOM   1679  CZ3 TRP A 209      52.150  47.492  18.950  1.00 40.40           C  
ATOM   1680  CH2 TRP A 209      52.762  48.732  19.161  1.00 40.38           C  
ATOM   1681  N   ASP A 210      56.744  42.958  14.840  1.00 50.84           N  
ATOM   1682  CA  ASP A 210      58.110  42.449  14.908  1.00 53.21           C  
ATOM   1683  C   ASP A 210      58.797  42.472  13.555  1.00 53.83           C  
ATOM   1684  O   ASP A 210      60.019  42.508  13.482  1.00 54.19           O  
ATOM   1685  CB  ASP A 210      58.132  41.028  15.464  1.00 53.97           C  
ATOM   1686  CG  ASP A 210      58.471  40.988  16.940  1.00 57.17           C  
ATOM   1687  OD1 ASP A 210      59.554  41.495  17.326  1.00 59.30           O  
ATOM   1688  OD2 ASP A 210      57.654  40.438  17.713  1.00 60.02           O  
ATOM   1689  N   ASN A 211      58.002  42.474  12.491  1.00 54.83           N  
ATOM   1690  CA  ASN A 211      58.526  42.369  11.132  1.00 55.63           C  
ATOM   1691  C   ASN A 211      58.150  43.521  10.198  1.00 55.88           C  
ATOM   1692  O   ASN A 211      57.774  43.289   9.050  1.00 55.52           O  
ATOM   1693  CB  ASN A 211      58.072  41.042  10.534  1.00 55.82           C  
ATOM   1694  CG  ASN A 211      58.679  39.853  11.244  1.00 57.01           C  
ATOM   1695  OD1 ASN A 211      59.857  39.550  11.062  1.00 57.31           O  
ATOM   1696  ND2 ASN A 211      57.880  39.176  12.061  1.00 57.65           N  
ATOM   1697  N   LEU A 212      58.265  44.757  10.684  1.00 56.81           N  
ATOM   1698  CA  LEU A 212      57.858  45.936   9.907  1.00 57.69           C  
ATOM   1699  C   LEU A 212      58.700  46.152   8.643  1.00 58.58           C  
ATOM   1700  O   LEU A 212      58.195  46.660   7.637  1.00 58.54           O  
ATOM   1701  CB  LEU A 212      57.830  47.203  10.778  1.00 57.50           C  
ATOM   1702  CG  LEU A 212      56.692  47.322  11.803  1.00 56.80           C  
ATOM   1703  CD1 LEU A 212      56.725  48.674  12.473  1.00 58.10           C  
ATOM   1704  CD2 LEU A 212      55.334  47.094  11.166  1.00 55.70           C  
ATOM   1705  N   ASN A 213      59.969  45.754   8.698  1.00 59.56           N  
ATOM   1706  CA  ASN A 213      60.849  45.825   7.534  1.00 60.80           C  
ATOM   1707  C   ASN A 213      60.519  44.777   6.469  1.00 61.21           C  
ATOM   1708  O   ASN A 213      60.683  45.032   5.277  1.00 61.81           O  
ATOM   1709  CB  ASN A 213      62.318  45.707   7.953  1.00 61.13           C  
ATOM   1710  CG  ASN A 213      62.717  46.737   9.003  1.00 63.00           C  
ATOM   1711  OD1 ASN A 213      63.220  46.382  10.074  1.00 64.57           O  
ATOM   1712  ND2 ASN A 213      62.492  48.015   8.704  1.00 63.84           N  
ATOM   1713  N   HIS A 214      60.043  43.609   6.902  1.00 61.66           N  
ATOM   1714  CA  HIS A 214      59.713  42.510   5.990  1.00 62.24           C  
ATOM   1715  C   HIS A 214      58.239  42.134   6.036  1.00 61.67           C  
ATOM   1716  O   HIS A 214      57.890  41.041   6.499  1.00 61.76           O  
ATOM   1717  CB  HIS A 214      60.554  41.272   6.314  1.00 63.10           C  
ATOM   1718  CG  HIS A 214      61.990  41.574   6.604  1.00 65.74           C  
ATOM   1719  ND1 HIS A 214      62.817  42.206   5.699  1.00 67.44           N  
ATOM   1720  CD2 HIS A 214      62.748  41.323   7.697  1.00 67.51           C  
ATOM   1721  CE1 HIS A 214      64.021  42.339   6.228  1.00 68.75           C  
ATOM   1722  NE2 HIS A 214      64.006  41.810   7.439  1.00 68.73           N  
ATOM   1723  N   LEU A 215      57.378  43.021   5.542  1.00 61.29           N  
ATOM   1724  CA  LEU A 215      55.928  42.790   5.606  1.00 60.96           C  
ATOM   1725  C   LEU A 215      55.394  41.830   4.544  1.00 61.42           C  
ATOM   1726  O   LEU A 215      54.252  41.369   4.637  1.00 61.12           O  
ATOM   1727  CB  LEU A 215      55.148  44.112   5.595  1.00 60.43           C  
ATOM   1728  CG  LEU A 215      55.144  44.847   6.939  1.00 59.09           C  
ATOM   1729  CD1 LEU A 215      54.435  46.176   6.813  1.00 57.89           C  
ATOM   1730  CD2 LEU A 215      54.517  43.999   8.058  1.00 56.95           C  
ATOM   1731  N   ASN A 216      56.202  41.504   3.558  1.00 61.90           N  
ATOM   1732  CA  ASN A 216      55.746  40.649   2.502  1.00 62.62           C  
ATOM   1733  C   ASN A 216      55.249  39.288   2.931  1.00 62.92           C  
ATOM   1734  O   ASN A 216      54.183  38.884   2.525  1.00 62.98           O  
ATOM   1735  CB  ASN A 216      56.811  40.505   1.446  1.00 63.07           C  
ATOM   1736  CG  ASN A 216      56.712  41.544   0.403  1.00 63.41           C  
ATOM   1737  OD1 ASN A 216      56.015  41.390  -0.578  1.00 63.98           O  
ATOM   1738  ND2 ASN A 216      57.429  42.607   0.591  1.00 63.64           N  
ATOM   1739  N   GLN A 217      56.011  38.566   3.735  1.00 63.14           N  
ATOM   1740  CA  GLN A 217      55.573  37.224   4.141  1.00 63.18           C  
ATOM   1741  C   GLN A 217      54.151  37.232   4.687  1.00 62.51           C  
ATOM   1742  O   GLN A 217      53.527  36.176   4.815  1.00 62.63           O  
ATOM   1743  CB  GLN A 217      56.529  36.605   5.171  1.00 63.71           C  
ATOM   1744  CG  GLN A 217      57.369  37.694   5.945  1.00 65.00           C  
ATOM   1745  CD  GLN A 217      57.600  37.246   7.439  1.00 65.16           C  
ATOM   1746  OE1 GLN A 217      57.703  36.034   7.758  1.00 66.36           O  
ATOM   1747  NE2 GLN A 217      57.689  38.246   8.376  1.00 65.55           N  
ATOM   1748  N   PHE A 218      53.642  38.426   4.990  1.00 61.46           N  
ATOM   1749  CA  PHE A 218      52.311  38.583   5.571  1.00 60.38           C  
ATOM   1750  C   PHE A 218      51.240  38.992   4.567  1.00 59.02           C  
ATOM   1751  O   PHE A 218      50.050  38.891   4.857  1.00 59.06           O  
ATOM   1752  CB  PHE A 218      52.349  39.589   6.721  1.00 60.82           C  
ATOM   1753  CG  PHE A 218      53.235  39.174   7.865  1.00 61.26           C  
ATOM   1754  CD1 PHE A 218      52.815  38.204   8.778  1.00 61.91           C  
ATOM   1755  CD2 PHE A 218      54.482  39.759   8.036  1.00 60.53           C  
ATOM   1756  CE1 PHE A 218      53.631  37.828   9.839  1.00 62.06           C  
ATOM   1757  CE2 PHE A 218      55.295  39.391   9.093  1.00 60.23           C  
ATOM   1758  CZ  PHE A 218      54.877  38.424   9.992  1.00 61.28           C  
ATOM   1759  N   VAL A 219      51.663  39.456   3.394  1.00 57.36           N  
ATOM   1760  CA  VAL A 219      50.737  39.876   2.343  1.00 55.66           C  
ATOM   1761  C   VAL A 219      49.953  38.673   1.794  1.00 55.13           C  
ATOM   1762  O   VAL A 219      50.533  37.768   1.175  1.00 55.30           O  
ATOM   1763  CB  VAL A 219      51.475  40.632   1.201  1.00 55.23           C  
ATOM   1764  CG1 VAL A 219      50.526  40.981   0.077  1.00 54.57           C  
ATOM   1765  CG2 VAL A 219      52.141  41.888   1.725  1.00 54.43           C  
ATOM   1766  N   ASP A 220      48.642  38.661   2.041  1.00 53.52           N  
ATOM   1767  CA  ASP A 220      47.755  37.617   1.518  1.00 52.15           C  
ATOM   1768  C   ASP A 220      46.508  38.266   0.934  1.00 51.65           C  
ATOM   1769  O   ASP A 220      45.571  38.615   1.663  1.00 51.62           O  
ATOM   1770  CB  ASP A 220      47.391  36.606   2.615  1.00 52.19           C  
ATOM   1771  CG  ASP A 220      46.584  35.404   2.094  1.00 51.73           C  
ATOM   1772  OD1 ASP A 220      46.029  35.453   0.966  1.00 51.24           O  
ATOM   1773  OD2 ASP A 220      46.494  34.403   2.847  1.00 51.05           O  
ATOM   1774  N   HIS A 221      46.501  38.421  -0.384  1.00 50.32           N  
ATOM   1775  CA  HIS A 221      45.405  39.087  -1.067  1.00 49.57           C  
ATOM   1776  C   HIS A 221      44.376  38.114  -1.617  1.00 49.61           C  
ATOM   1777  O   HIS A 221      43.489  38.509  -2.376  1.00 48.93           O  
ATOM   1778  CB  HIS A 221      45.929  40.002  -2.173  1.00 49.18           C  
ATOM   1779  CG  HIS A 221      46.760  41.138  -1.668  1.00 48.18           C  
ATOM   1780  ND1 HIS A 221      47.533  41.921  -2.498  1.00 48.06           N  
ATOM   1781  CD2 HIS A 221      46.951  41.616  -0.417  1.00 47.80           C  
ATOM   1782  CE1 HIS A 221      48.160  42.835  -1.781  1.00 48.56           C  
ATOM   1783  NE2 HIS A 221      47.821  42.673  -0.516  1.00 49.82           N  
ATOM   1784  N   GLU A 222      44.488  36.853  -1.202  1.00 49.90           N  
ATOM   1785  CA  GLU A 222      43.608  35.789  -1.670  1.00 50.54           C  
ATOM   1786  C   GLU A 222      42.683  35.275  -0.564  1.00 49.56           C  
ATOM   1787  O   GLU A 222      41.522  34.972  -0.815  1.00 49.59           O  
ATOM   1788  CB  GLU A 222      44.435  34.619  -2.223  1.00 51.27           C  
ATOM   1789  CG  GLU A 222      45.694  35.015  -2.997  1.00 54.46           C  
ATOM   1790  CD  GLU A 222      45.430  35.312  -4.460  1.00 58.30           C  
ATOM   1791  OE1 GLU A 222      46.279  35.976  -5.086  1.00 60.53           O  
ATOM   1792  OE2 GLU A 222      44.380  34.885  -4.987  1.00 60.35           O  
ATOM   1793  N   LYS A 223      43.211  35.162   0.653  1.00 48.98           N  
ATOM   1794  CA  LYS A 223      42.468  34.564   1.756  1.00 48.57           C  
ATOM   1795  C   LYS A 223      41.737  35.605   2.594  1.00 47.57           C  
ATOM   1796  O   LYS A 223      42.319  36.607   3.020  1.00 47.77           O  
ATOM   1797  CB  LYS A 223      43.402  33.744   2.642  1.00 48.89           C  
ATOM   1798  CG  LYS A 223      42.716  32.873   3.684  1.00 50.22           C  
ATOM   1799  CD  LYS A 223      43.750  32.133   4.523  1.00 52.11           C  
ATOM   1800  CE  LYS A 223      43.107  31.409   5.710  1.00 56.72           C  
ATOM   1801  NZ  LYS A 223      42.289  30.213   5.314  1.00 59.25           N  
ATOM   1802  N   ILE A 224      40.453  35.354   2.817  1.00 46.31           N  
ATOM   1803  CA  ILE A 224      39.653  36.156   3.731  1.00 45.22           C  
ATOM   1804  C   ILE A 224      39.553  35.386   5.040  1.00 45.04           C  
ATOM   1805  O   ILE A 224      38.916  34.337   5.106  1.00 45.14           O  
ATOM   1806  CB  ILE A 224      38.258  36.460   3.157  1.00 44.70           C  
ATOM   1807  CG1 ILE A 224      38.380  37.342   1.918  1.00 43.63           C  
ATOM   1808  CG2 ILE A 224      37.381  37.142   4.201  1.00 44.61           C  
ATOM   1809  CD1 ILE A 224      37.233  37.191   0.957  1.00 44.66           C  
ATOM   1810  N   TYR A 225      40.221  35.905   6.062  1.00 44.72           N  
ATOM   1811  CA  TYR A 225      40.222  35.303   7.384  1.00 45.66           C  
ATOM   1812  C   TYR A 225      38.870  35.509   8.074  1.00 46.26           C  
ATOM   1813  O   TYR A 225      38.394  36.635   8.176  1.00 45.93           O  
ATOM   1814  CB  TYR A 225      41.359  35.898   8.224  1.00 45.21           C  
ATOM   1815  CG  TYR A 225      42.735  35.458   7.770  1.00 46.97           C  
ATOM   1816  CD1 TYR A 225      43.348  34.334   8.333  1.00 48.12           C  
ATOM   1817  CD2 TYR A 225      43.416  36.151   6.767  1.00 45.91           C  
ATOM   1818  CE1 TYR A 225      44.612  33.916   7.913  1.00 49.15           C  
ATOM   1819  CE2 TYR A 225      44.675  35.741   6.339  1.00 48.75           C  
ATOM   1820  CZ  TYR A 225      45.264  34.624   6.917  1.00 50.01           C  
ATOM   1821  OH  TYR A 225      46.514  34.217   6.501  1.00 54.23           O  
ATOM   1822  N   ARG A 226      38.260  34.411   8.520  1.00 47.26           N  
ATOM   1823  CA  ARG A 226      36.979  34.443   9.226  1.00 48.98           C  
ATOM   1824  C   ARG A 226      37.184  34.468  10.730  1.00 49.67           C  
ATOM   1825  O   ARG A 226      37.638  33.485  11.311  1.00 49.78           O  
ATOM   1826  CB  ARG A 226      36.119  33.221   8.866  1.00 49.55           C  
ATOM   1827  CG  ARG A 226      35.041  33.460   7.833  1.00 50.43           C  
ATOM   1828  CD  ARG A 226      35.513  33.171   6.416  1.00 53.31           C  
ATOM   1829  NE  ARG A 226      34.742  33.977   5.474  1.00 54.67           N  
ATOM   1830  CZ  ARG A 226      34.929  34.019   4.161  1.00 54.99           C  
ATOM   1831  NH1 ARG A 226      34.168  34.803   3.428  1.00 56.08           N  
ATOM   1832  NH2 ARG A 226      35.868  33.288   3.581  1.00 58.39           N  
HETATM 1833  N   MSE A 227      36.865  35.597  11.352  1.00 50.71           N  
HETATM 1834  CA  MSE A 227      36.822  35.701  12.809  1.00 52.11           C  
HETATM 1835  C   MSE A 227      35.379  35.901  13.308  1.00 53.20           C  
HETATM 1836  O   MSE A 227      34.983  36.986  13.733  1.00 53.12           O  
HETATM 1837  OXT MSE A 227      34.553  34.972  13.293  1.00 54.29           O  
HETATM 1838  CB  MSE A 227      37.735  36.831  13.300  1.00 51.91           C  
HETATM 1839  CG  MSE A 227      39.042  36.325  13.892  1.00 53.11           C  
HETATM 1840 SE   MSE A 227      40.264  35.623  12.533  0.50 52.06          SE  
HETATM 1841  CE  MSE A 227      41.527  37.099  12.491  1.00 48.50           C  
TER    1842      MSE A 227                                                      
END
MOLECULE T0513_1_11_87_283.pdb
ATOM      7  N   MET     1      40.511  38.696  30.932  1.00 34.21           N  
ATOM      8  CA  MET     1      40.458  39.135  29.549  1.00 22.06           C  
ATOM      9  C   MET     1      41.682  38.517  28.896  1.00 20.62           C  
ATOM     10  O   MET     1      42.651  38.176  29.595  1.00 20.32           O  
ATOM     11  CB  MET     1      40.508  40.662  29.493  1.00 26.67           C  
ATOM     12  CG  MET     1      39.316  41.294  30.229  1.00 26.17           C  
ATOM     15  N   SER     2      41.648  38.358  27.573  1.00 18.56           N  
ATOM     16  CA  SER     2      42.745  37.762  26.830  1.00 17.53           C  
ATOM     17  C   SER     2      42.560  38.118  25.378  1.00 19.94           C  
ATOM     18  O   SER     2      41.495  38.598  24.988  1.00 17.05           O  
ATOM     19  CB  SER     2      42.710  36.228  26.946  1.00 17.75           C  
ATOM     20  OG  SER     2      41.480  35.716  26.386  1.00 17.41           O  
ATOM     21  N   PHE     3      43.586  37.860  24.569  1.00 16.42           N  
ATOM     22  CA  PHE     3      43.459  38.022  23.110  1.00 16.19           C  
ATOM     23  C   PHE     3      42.307  37.173  22.593  1.00 21.25           C  
ATOM     24  O   PHE     3      41.461  37.650  21.819  1.00 19.18           O  
ATOM     25  CB  PHE     3      44.739  37.581  22.397  1.00 16.58           C  
ATOM     26  CG  PHE     3      45.941  38.449  22.661  1.00 15.61           C  
ATOM     27  CD1 PHE     3      45.828  39.838  22.823  1.00 13.92           C  
ATOM     28  CD2 PHE     3      47.208  37.862  22.709  1.00 20.52           C  
ATOM     29  CE1 PHE     3      46.981  40.625  23.045  1.00 17.47           C  
ATOM     30  CE2 PHE     3      48.343  38.632  22.922  1.00 19.74           C  
ATOM     31  CZ  PHE     3      48.236  40.011  23.095  1.00 20.60           C  
ATOM     32  N   LEU     4      42.276  35.914  23.034  1.00 17.01           N  
ATOM     33  CA  LEU     4      41.300  34.959  22.547  1.00 17.54           C  
ATOM     34  C   LEU     4      39.864  35.393  22.852  1.00 15.99           C  
ATOM     35  O   LEU     4      38.998  35.315  21.978  1.00 18.48           O  
ATOM     36  CB  LEU     4      41.598  33.535  23.044  1.00 18.74           C  
ATOM     37  CG  LEU     4      40.593  32.443  22.590  1.00 23.52           C  
ATOM     38  CD1 LEU     4      40.527  32.284  21.070  1.00 23.88           C  
ATOM     39  CD2 LEU     4      40.891  31.090  23.260  1.00 23.18           C  
ATOM     40  N   LYS     5      39.637  35.880  24.072  1.00 17.97           N  
ATOM     41  CA  LYS     5      38.295  36.329  24.470  1.00 16.32           C  
ATOM     42  C   LYS     5      37.818  37.464  23.559  1.00 17.11           C  
ATOM     43  O   LYS     5      36.660  37.464  23.200  1.00 17.21           O  
ATOM     44  CB  LYS     5      38.234  36.758  25.934  1.00 25.30           C  
ATOM     45  CG  LYS     5      36.789  36.876  26.476  1.00 32.59           C  
ATOM     46  CD  LYS     5      36.697  37.899  27.624  1.00 46.27           C  
ATOM     47  CE  LYS     5      35.251  38.200  28.091  1.00 40.02           C  
ATOM     48  NZ  LYS     5      34.171  38.126  27.026  1.00 37.12           N  
ATOM     49  N   HIS     6      38.696  38.404  23.186  1.00 16.06           N  
ATOM     50  CA  HIS     6      38.317  39.478  22.227  1.00 19.72           C  
ATOM     51  C   HIS     6      37.859  38.902  20.880  1.00 17.75           C  
ATOM     52  O   HIS     6      36.864  39.336  20.280  1.00 17.62           O  
ATOM     53  CB  HIS     6      39.490  40.435  21.971  1.00 17.88           C  
ATOM     54  CG  HIS     6      39.760  41.393  23.082  1.00 26.05           C  
ATOM     55  ND1 HIS     6      38.778  42.169  23.654  1.00 23.15           N  
ATOM     56  CD2 HIS     6      40.912  41.716  23.719  1.00 20.43           C  
ATOM     57  CE1 HIS     6      39.305  42.917  24.607  1.00 24.59           C  
ATOM     58  NE2 HIS     6      40.601  42.674  24.658  1.00 23.21           N  
ATOM     59  N   VAL     7      38.607  37.911  20.395  1.00 19.93           N  
ATOM     60  CA  VAL     7      38.322  37.270  19.129  1.00 15.58           C  
ATOM     61  C   VAL     7      36.992  36.526  19.218  1.00 20.03           C  
ATOM     62  O   VAL     7      36.166  36.642  18.319  1.00 17.61           O  
ATOM     63  CB  VAL     7      39.521  36.349  18.692  1.00 18.90           C  
ATOM     64  CG1 VAL     7      39.154  35.465  17.528  1.00 22.87           C  
ATOM     65  CG2 VAL     7      40.777  37.213  18.386  1.00 17.72           C  
ATOM     66  N   GLN     8      36.777  35.822  20.329  1.00 18.18           N  
ATOM     67  CA  GLN     8      35.531  35.100  20.579  1.00 15.33           C  
ATOM     68  C   GLN     8      34.323  36.036  20.681  1.00 17.02           C  
ATOM     69  O   GLN     8      33.252  35.717  20.142  1.00 23.55           O  
ATOM     70  CB  GLN     8      35.662  34.259  21.842  1.00 20.01           C  
ATOM     71  CG  GLN     8      36.479  32.991  21.588  1.00 19.14           C  
ATOM     72  CD  GLN     8      36.808  32.235  22.869  1.00 26.74           C  
ATOM     73  OE1 GLN     8      36.820  32.801  23.960  1.00 25.57           O  
ATOM     74  NE2 GLN     8      37.099  30.951  22.729  1.00 29.56           N  
ATOM     75  N   ASP     9      34.514  37.181  21.363  1.00 16.26           N  
ATOM     76  CA  ASP     9      33.480  38.214  21.515  1.00 17.99           C  
ATOM     77  C   ASP     9      33.012  38.673  20.127  1.00 17.79           C  
ATOM     78  O   ASP     9      31.805  38.752  19.866  1.00 15.63           O  
ATOM     79  CB  ASP     9      34.018  39.459  22.245  1.00 20.20           C  
ATOM     80  CG  ASP     9      34.205  39.262  23.755  1.00 21.46           C  
ATOM     81  OD1 ASP     9      33.680  38.295  24.334  1.00 22.14           O  
ATOM     82  OD2 ASP     9      34.896  40.116  24.337  1.00 25.62           O  
ATOM     83  N   CYS    10      33.972  38.942  19.230  1.00 13.03           N  
ATOM     84  CA  CYS    10      33.660  39.396  17.882  1.00 17.68           C  
ATOM     85  C   CYS    10      33.082  38.342  16.932  1.00 17.69           C  
ATOM     86  O   CYS    10      32.679  38.677  15.815  1.00 18.01           O  
ATOM     87  CB  CYS    10      34.881  40.047  17.257  1.00 20.69           C  
ATOM     88  SG  CYS    10      35.334  41.640  18.054  1.00 22.02           S  
ATOM     89  N   ASN    11      33.044  37.089  17.377  1.00 16.85           N  
ATOM     90  CA  ASN    11      32.489  36.005  16.585  1.00 16.00           C  
ATOM     91  C   ASN    11      31.330  35.320  17.254  1.00 21.69           C  
ATOM     92  O   ASN    11      30.958  34.203  16.885  1.00 21.64           O  
ATOM     93  CB  ASN    11      33.593  35.035  16.168  1.00 18.19           C  
ATOM     94  CG  ASN    11      34.453  35.616  15.082  1.00 21.69           C  
ATOM     95  OD1 ASN    11      33.977  35.828  13.968  1.00 20.16           O  
ATOM     96  ND2 ASN    11      35.712  35.932  15.408  1.00 25.35           N  
ATOM    704  N   GLY    87      22.335  58.715   5.514  1.00 25.39           N  
ATOM    705  CA  GLY    87      22.831  59.252   4.250  1.00 24.83           C  
ATOM    706  C   GLY    87      24.088  58.667   3.650  1.00 25.87           C  
ATOM    707  O   GLY    87      24.394  58.938   2.496  1.00 27.78           O  
ATOM    708  N   GLU    88      24.826  57.861   4.409  1.00 22.13           N  
ATOM    709  CA  GLU    88      25.998  57.160   3.861  1.00 22.36           C  
ATOM    710  C   GLU    88      25.582  55.816   3.295  1.00 23.51           C  
ATOM    711  O   GLU    88      25.054  54.989   4.020  1.00 19.80           O  
ATOM    712  CB  GLU    88      27.074  56.962   4.933  1.00 21.74           C  
ATOM    713  CG  GLU    88      28.275  56.190   4.365  1.00 22.96           C  
ATOM    714  CD  GLU    88      29.489  56.189   5.269  1.00 29.30           C  
ATOM    715  OE1 GLU    88      29.367  56.503   6.472  1.00 33.52           O  
ATOM    716  OE2 GLU    88      30.570  55.860   4.759  1.00 24.96           O  
ATOM    717  N   LEU    89      25.810  55.583   2.004  1.00 20.88           N  
ATOM    718  CA  LEU    89      25.365  54.333   1.387  1.00 21.09           C  
ATOM    719  C   LEU    89      26.512  53.320   1.330  1.00 18.78           C  
ATOM    720  O   LEU    89      27.654  53.675   1.020  1.00 23.48           O  
ATOM    721  CB  LEU    89      24.801  54.587  -0.030  1.00 24.83           C  
ATOM    722  CG  LEU    89      23.590  55.510  -0.163  1.00 24.17           C  
ATOM    723  CD1 LEU    89      23.159  55.634  -1.627  1.00 26.09           C  
ATOM    724  CD2 LEU    89      22.440  55.047   0.719  1.00 26.85           C  
ATOM    725  N   TYR    90      26.193  52.062   1.617  1.00 16.23           N  
ATOM    726  CA  TYR    90      27.161  50.972   1.554  1.00 16.87           C  
ATOM    727  C   TYR    90      26.790  50.018   0.421  1.00 21.89           C  
ATOM    728  O   TYR    90      25.612  49.841   0.095  1.00 21.37           O  
ATOM    729  CB  TYR    90      27.108  50.166   2.857  1.00 19.18           C  
ATOM    730  CG  TYR    90      27.980  50.636   4.014  1.00 19.39           C  
ATOM    731  CD1 TYR    90      28.586  51.896   4.022  1.00 22.76           C  
ATOM    732  CD2 TYR    90      28.157  49.810   5.129  1.00 17.63           C  
ATOM    733  CE1 TYR    90      29.384  52.298   5.104  1.00 23.15           C  
ATOM    734  CE2 TYR    90      28.930  50.204   6.222  1.00 16.30           C  
ATOM    735  CZ  TYR    90      29.555  51.449   6.190  1.00 20.05           C  
ATOM    736  OH  TYR    90      30.322  51.863   7.267  1.00 20.00           O  
ATOM    737  N   ARG    91      27.794  49.363  -0.136  1.00 20.63           N  
ATOM    738  CA  ARG    91      27.555  48.370  -1.175  1.00 19.85           C  
ATOM    739  C   ARG    91      27.051  47.062  -0.576  1.00 20.29           C  
ATOM    740  O   ARG    91      27.473  46.654   0.518  1.00 19.32           O  
ATOM    741  CB  ARG    91      28.840  48.157  -2.011  1.00 19.59           C  
ATOM    742  CG  ARG    91      29.881  47.303  -1.337  1.00 26.33           C  
ATOM    743  CD  ARG    91      31.225  47.506  -1.966  1.00 24.05           C  
ATOM    744  NE  ARG    91      31.794  48.821  -1.681  1.00 21.42           N  
ATOM    745  CZ  ARG    91      32.772  49.356  -2.401  1.00 28.61           C  
ATOM    746  NH1 ARG    91      33.284  48.673  -3.417  1.00 23.53           N  
ATOM    747  NH2 ARG    91      33.260  50.541  -2.095  1.00 22.18           N  
ATOM    748  N   VAL    92      26.123  46.418  -1.279  1.00 18.57           N  
ATOM    749  CA  VAL    92      25.629  45.105  -0.875  1.00 16.93           C  
ATOM    750  C   VAL    92      26.147  44.058  -1.867  1.00 21.31           C  
ATOM    751  O   VAL    92      25.839  44.127  -3.082  1.00 19.91           O  
ATOM    752  CB  VAL    92      24.077  45.066  -0.843  1.00 19.63           C  
ATOM    753  CG1 VAL    92      23.561  43.626  -0.553  1.00 18.79           C  
ATOM    754  CG2 VAL    92      23.540  46.091   0.161  1.00 19.26           C  
ATOM    755  N   ASN    93      26.930  43.104  -1.352  1.00 18.20           N  
ATOM    756  CA  ASN    93      27.505  42.038  -2.178  1.00 21.74           C  
ATOM    757  C   ASN    93      27.698  40.762  -1.358  1.00 24.96           C  
ATOM    758  O   ASN    93      27.499  40.746  -0.136  1.00 22.57           O  
ATOM    759  CB  ASN    93      28.859  42.491  -2.788  1.00 18.95           C  
ATOM    760  CG  ASN    93      29.874  42.903  -1.719  1.00 18.59           C  
ATOM    761  OD1 ASN    93      29.937  42.301  -0.661  1.00 24.48           O  
ATOM    762  ND2 ASN    93      30.678  43.942  -2.005  1.00 22.24           N  
ATOM    763  N   GLN    94      28.152  39.704  -2.018  1.00 26.36           N  
ATOM    764  CA  GLN    94      28.433  38.446  -1.340  1.00 26.49           C  
ATOM    765  C   GLN    94      29.823  38.381  -0.751  1.00 30.49           C  
ATOM    766  O   GLN    94      30.080  37.583   0.146  1.00 36.86           O  
ATOM    767  CB  GLN    94      28.266  37.286  -2.304  1.00 37.10           C  
ATOM    768  CG  GLN    94      26.932  36.636  -2.224  1.00 37.93           C  
ATOM    769  CD  GLN    94      26.869  35.435  -3.124  1.00 49.22           C  
ATOM    770  OE1 GLN    94      27.271  35.502  -4.289  1.00 48.89           O  
ATOM    771  NE2 GLN    94      26.362  34.325  -2.598  1.00 50.15           N  
ATOM    772  N   SER    95      30.722  39.175  -1.320  1.00 27.55           N  
ATOM    773  CA  SER    95      32.069  39.392  -0.824  1.00 28.80           C  
ATOM    774  C   SER    95      32.682  40.521  -1.622  1.00 22.53           C  
ATOM    775  O   SER    95      32.128  40.970  -2.634  1.00 27.82           O  
ATOM    776  CB  SER    95      32.951  38.132  -0.907  1.00 35.68           C  
ATOM    777  OG  SER    95      32.898  37.568  -2.200  1.00 45.01           O  
ATOM    778  N   TRP    96      33.826  40.973  -1.150  1.00 24.95           N  
ATOM    779  CA  TRP    96      34.436  42.202  -1.609  1.00 25.45           C  
ATOM    780  C   TRP    96      34.681  42.248  -3.134  1.00 31.67           C  
ATOM    781  O   TRP    96      34.439  43.261  -3.783  1.00 27.35           O  
ATOM    782  CB  TRP    96      35.741  42.422  -0.848  1.00 22.30           C  
ATOM    783  CG  TRP    96      36.462  43.612  -1.369  1.00 24.98           C  
ATOM    784  CD1 TRP    96      37.632  43.618  -2.096  1.00 26.49           C  
ATOM    785  CD2 TRP    96      36.055  44.983  -1.250  1.00 26.86           C  
ATOM    786  NE1 TRP    96      37.962  44.903  -2.437  1.00 27.97           N  
ATOM    787  CE2 TRP    96      37.019  45.764  -1.932  1.00 21.43           C  
ATOM    788  CE3 TRP    96      34.974  45.630  -0.629  1.00 26.25           C  
ATOM    789  CZ2 TRP    96      36.931  47.158  -2.015  1.00 27.21           C  
ATOM    790  CZ3 TRP    96      34.891  47.010  -0.708  1.00 24.31           C  
ATOM    791  CH2 TRP    96      35.870  47.765  -1.392  1.00 26.46           C  
ATOM    792  N   GLY    97      35.167  41.155  -3.704  1.00 34.73           N  
ATOM    793  CA  GLY    97      35.381  41.134  -5.170  1.00 43.04           C  
ATOM    794  C   GLY    97      34.138  41.139  -6.057  1.00 39.97           C  
ATOM    795  O   GLY    97      34.185  41.591  -7.209  1.00 39.72           O  
ATOM    796  N   GLU    98      33.033  40.651  -5.503  1.00 32.97           N  
ATOM    797  CA  GLU    98      31.804  40.317  -6.230  1.00 27.55           C  
ATOM    798  C   GLU    98      31.010  41.563  -6.666  1.00 28.91           C  
ATOM    799  O   GLU    98      31.254  42.659  -6.156  1.00 28.40           O  
ATOM    800  CB  GLU    98      30.957  39.401  -5.344  1.00 31.83           C  
ATOM    801  CG  GLU    98      31.496  37.987  -5.178  1.00 44.11           C  
ATOM    802  CD  GLU    98      31.337  37.164  -6.427  1.00 58.39           C  
ATOM    803  OE1 GLU    98      32.363  36.906  -7.087  1.00 64.85           O  
ATOM    804  OE2 GLU    98      30.189  36.793  -6.761  1.00 62.34           O  
ATOM    805  N   PRO    99      30.088  41.417  -7.650  1.00 29.23           N  
ATOM    806  CA  PRO    99      29.327  42.602  -8.113  1.00 31.34           C  
ATOM    807  C   PRO    99      28.456  43.270  -7.032  1.00 22.94           C  
ATOM    808  O   PRO    99      27.910  42.597  -6.172  1.00 22.94           O  
ATOM    809  CB  PRO    99      28.421  42.028  -9.225  1.00 30.62           C  
ATOM    810  CG  PRO    99      29.121  40.763  -9.672  1.00 34.18           C  
ATOM    811  CD  PRO    99      29.736  40.207  -8.431  1.00 34.24           C  
ATOM    812  N   THR   100      28.385  44.577  -7.048  1.00 21.61           N  
ATOM    813  CA  THR   100      27.472  45.266  -6.184  1.00 22.07           C  
ATOM    814  C   THR   100      26.055  45.017  -6.668  1.00 23.86           C  
ATOM    815  O   THR   100      25.724  45.353  -7.758  1.00 27.37           O  
ATOM    816  CB  THR   100      27.794  46.753  -6.127  1.00 25.42           C  
ATOM    817  OG1 THR   100      29.070  46.950  -5.547  1.00 25.25           O  
ATOM    818  CG2 THR   100      26.768  47.493  -5.390  1.00 21.58           C  
ATOM    819  N   LEU   101      25.252  44.413  -5.827  1.00 22.26           N  
ATOM    820  CA  LEU   101      23.902  44.054  -6.147  1.00 22.54           C  
ATOM    821  C   LEU   101      22.868  45.162  -5.909  1.00 26.84           C  
ATOM    822  O   LEU   101      21.835  45.169  -6.511  1.00 22.64           O  
ATOM    823  CB  LEU   101      23.512  42.785  -5.421  1.00 23.42           C  
ATOM    824  CG  LEU   101      24.336  41.556  -5.780  1.00 23.60           C  
ATOM    825  CD1 LEU   101      24.021  40.422  -4.914  1.00 24.49           C  
ATOM    826  CD2 LEU   101      24.104  41.185  -7.208  1.00 23.72           C  
ATOM    827  N   MET   102      23.182  46.045  -4.985  1.00 22.55           N  
ATOM    828  CA  MET   102      22.371  47.178  -4.624  1.00 21.19           C  
ATOM    829  C   MET   102      23.150  47.968  -3.581  1.00 23.28           C  
ATOM    830  O   MET   102      24.171  47.532  -3.145  1.00 19.55           O  
ATOM    831  CB  MET   102      21.053  46.709  -4.017  1.00 19.31           C  
ATOM    832  CG  MET   102      21.164  45.928  -2.733  1.00 21.18           C  
ATOM    833  SD  MET   102      19.405  45.525  -1.916  0.70 23.50          SE  
ATOM    834  CE  MET   102      19.035  47.338  -1.459  1.00 18.91           C  
ATOM    835  N   LEU   103      22.596  49.100  -3.191  1.00 18.82           N  
ATOM    836  CA  LEU   103      23.106  49.922  -2.110  1.00 19.48           C  
ATOM    837  C   LEU   103      22.134  50.000  -0.941  1.00 20.90           C  
ATOM    838  O   LEU   103      20.948  49.907  -1.109  1.00 20.47           O  
ATOM    839  CB  LEU   103      23.457  51.333  -2.574  1.00 19.25           C  
ATOM    840  CG  LEU   103      24.264  51.497  -3.846  1.00 25.37           C  
ATOM    841  CD1 LEU   103      24.555  52.930  -4.178  1.00 22.48           C  
ATOM    842  CD2 LEU   103      25.523  50.763  -3.726  1.00 16.64           C  
ATOM    843  N   LEU   104      22.687  50.192   0.242  1.00 19.74           N  
ATOM    844  CA  LEU   104      21.923  50.226   1.458  1.00 21.14           C  
ATOM    845  C   LEU   104      22.505  51.224   2.435  1.00 24.21           C  
ATOM    846  O   LEU   104      23.680  51.307   2.604  1.00 20.89           O  
ATOM    847  CB  LEU   104      21.901  48.860   2.084  1.00 23.77           C  
ATOM    848  CG  LEU   104      20.943  48.484   3.187  1.00 22.11           C  
ATOM    849  CD1 LEU   104      19.549  48.698   2.787  1.00 21.93           C  
ATOM    850  CD2 LEU   104      21.194  47.061   3.593  1.00 18.00           C  
ATOM    851  N   ASP   105      21.646  52.004   3.040  1.00 23.13           N  
ATOM    852  CA  ASP   105      22.136  52.996   3.987  1.00 19.41           C  
ATOM    853  C   ASP   105      22.867  52.277   5.131  1.00 15.14           C  
ATOM    854  O   ASP   105      22.375  51.291   5.654  1.00 18.33           O  
ATOM    855  CB  ASP   105      20.977  53.801   4.552  1.00 20.99           C  
ATOM    856  CG  ASP   105      21.447  55.029   5.285  1.00 20.36           C  
ATOM    857  OD1 ASP   105      21.842  54.928   6.470  1.00 21.30           O  
ATOM    858  OD2 ASP   105      21.476  56.107   4.673  1.00 21.56           O  
ATOM    859  N   ARG   106      24.040  52.796   5.477  1.00 21.02           N  
ATOM    860  CA  ARG   106      24.899  52.258   6.546  1.00 18.68           C  
ATOM    861  C   ARG   106      24.099  51.988   7.824  1.00 22.99           C  
ATOM    862  O   ARG   106      24.278  50.952   8.482  1.00 19.07           O  
ATOM    863  CB  ARG   106      26.026  53.245   6.801  1.00 20.67           C  
ATOM    864  CG  ARG   106      26.860  52.965   8.042  1.00 26.03           C  
ATOM    865  CD  ARG   106      27.944  54.002   8.188  1.00 21.79           C  
ATOM    866  NE  ARG   106      28.772  53.685   9.350  1.00 28.51           N  
ATOM    867  CZ  ARG   106      29.995  54.161   9.567  1.00 36.58           C  
ATOM    868  NH1 ARG   106      30.556  55.013   8.713  1.00 24.41           N  
ATOM    869  NH2 ARG   106      30.663  53.784  10.651  1.00 37.44           N  
ATOM    870  N   ALA   107      23.138  52.862   8.127  1.00 16.60           N  
ATOM    871  CA  ALA   107      22.420  52.758   9.398  1.00 22.69           C  
ATOM    872  C   ALA   107      21.586  51.489   9.530  1.00 19.03           C  
ATOM    873  O   ALA   107      21.297  51.057  10.637  1.00 21.36           O  
ATOM    874  CB  ALA   107      21.549  53.986   9.636  1.00 23.29           C  
ATOM    875  N   VAL   108      21.235  50.881   8.402  1.00 17.20           N  
ATOM    876  CA  VAL   108      20.418  49.676   8.404  1.00 17.43           C  
ATOM    877  C   VAL   108      21.193  48.455   7.914  1.00 21.77           C  
ATOM    878  O   VAL   108      20.631  47.379   7.750  1.00 19.19           O  
ATOM    879  CB  VAL   108      19.055  49.853   7.627  1.00 21.96           C  
ATOM    880  CG1 VAL   108      18.186  50.936   8.289  1.00 20.29           C  
ATOM    881  CG2 VAL   108      19.268  50.173   6.131  1.00 19.03           C  
ATOM    882  N   VAL   109      22.492  48.618   7.699  1.00 19.07           N  
ATOM    883  CA  VAL   109      23.306  47.473   7.234  1.00 17.15           C  
ATOM    884  C   VAL   109      23.208  46.292   8.255  1.00 15.02           C  
ATOM    885  O   VAL   109      22.810  45.158   7.867  1.00 17.93           O  
ATOM    886  CB  VAL   109      24.732  47.951   6.781  1.00 19.33           C  
ATOM    887  CG1 VAL   109      25.788  46.856   6.910  1.00 17.69           C  
ATOM    888  CG2 VAL   109      24.659  48.517   5.317  1.00 18.99           C  
ATOM    889  N   PRO   110      23.436  46.541   9.582  1.00 17.55           N  
ATOM    890  CA  PRO   110      23.209  45.433  10.540  1.00 18.17           C  
ATOM    891  C   PRO   110      21.767  44.902  10.631  1.00 17.33           C  
ATOM    892  O   PRO   110      21.566  43.727  10.878  1.00 18.00           O  
ATOM    893  CB  PRO   110      23.693  46.011  11.877  1.00 18.05           C  
ATOM    894  CG  PRO   110      24.670  47.112  11.485  1.00 20.81           C  
ATOM    895  CD  PRO   110      23.988  47.725  10.264  1.00 16.19           C  
ATOM    896  N   THR   111      20.779  45.761  10.386  1.00 17.33           N  
ATOM    897  CA  THR   111      19.362  45.360  10.360  1.00 18.97           C  
ATOM    898  C   THR   111      19.067  44.300   9.285  1.00 19.99           C  
ATOM    899  O   THR   111      18.183  43.453   9.462  1.00 20.53           O  
ATOM    900  CB  THR   111      18.509  46.609  10.107  1.00 21.00           C  
ATOM    901  OG1 THR   111      18.776  47.555  11.154  1.00 23.41           O  
ATOM    902  CG2 THR   111      17.008  46.263  10.007  1.00 17.86           C  
ATOM    903  N   PHE   112      19.787  44.369   8.160  1.00 16.89           N  
ATOM    904  CA  PHE   112      19.636  43.371   7.109  1.00 17.37           C  
ATOM    905  C   PHE   112      20.737  42.314   7.152  1.00 18.91           C  
ATOM    906  O   PHE   112      20.770  41.443   6.284  1.00 19.04           O  
ATOM    907  CB  PHE   112      19.554  44.029   5.725  1.00 21.08           C  
ATOM    908  CG  PHE   112      18.251  44.732   5.507  1.00 21.38           C  
ATOM    909  CD1 PHE   112      17.161  44.054   4.924  1.00 21.83           C  
ATOM    910  CD2 PHE   112      18.069  46.030   5.976  1.00 21.21           C  
ATOM    911  CE1 PHE   112      15.922  44.701   4.770  1.00 23.45           C  
ATOM    912  CE2 PHE   112      16.824  46.676   5.822  1.00 26.65           C  
ATOM    913  CZ  PHE   112      15.772  46.010   5.224  1.00 23.26           C  
ATOM    914  N   GLY   113      21.619  42.408   8.160  1.00 17.00           N  
ATOM    915  CA  GLY   113      22.760  41.450   8.343  1.00 19.86           C  
ATOM    916  C   GLY   113      23.708  41.372   7.156  1.00 19.08           C  
ATOM    917  O   GLY   113      24.320  40.316   6.875  1.00 17.65           O  
ATOM    918  N   VAL   114      23.822  42.488   6.453  1.00 16.66           N  
ATOM    919  CA  VAL   114      24.617  42.622   5.241  1.00 20.98           C  
ATOM    920  C   VAL   114      26.109  42.813   5.587  1.00 14.90           C  
ATOM    921  O   VAL   114      26.453  43.461   6.583  1.00 17.95           O  
ATOM    922  CB  VAL   114      24.061  43.812   4.391  1.00 22.54           C  
ATOM    923  CG1 VAL   114      25.108  44.402   3.471  1.00 26.90           C  
ATOM    924  CG2 VAL   114      22.800  43.348   3.641  1.00 20.80           C  
ATOM    925  N   ARG   115      26.992  42.207   4.798  1.00 18.90           N  
ATOM    926  CA  ARG   115      28.424  42.369   5.025  0.50 18.89           C  
ATOM    928  C   ARG   115      28.865  43.824   4.888  1.00 20.95           C  
ATOM    929  O   ARG   115      28.477  44.509   3.934  1.00 21.03           O  
ATOM    930  CB  ARG   115      29.202  41.456   4.089  0.50 25.76           C  
ATOM    932  CG  ARG   115      28.836  39.990   4.312  0.50 30.32           C  
ATOM    934  CD  ARG   115      29.435  39.054   3.279  0.50 39.53           C  
ATOM    936  NE  ARG   115      30.793  39.438   2.908  0.50 40.24           N  
ATOM    938  CZ  ARG   115      31.874  39.233   3.650  0.50 35.64           C  
ATOM    940  NH1 ARG   115      33.037  39.641   3.194  0.50 37.10           N  
ATOM    942  NH2 ARG   115      31.801  38.652   4.846  0.50 44.23           N  
ATOM    944  N   ALA   116      29.631  44.298   5.874  1.00 15.80           N  
ATOM    945  CA  ALA   116      30.150  45.685   5.878  1.00 23.26           C  
ATOM    946  C   ALA   116      31.663  45.682   5.736  1.00 22.47           C  
ATOM    947  O   ALA   116      32.346  44.741   6.166  1.00 22.50           O  
ATOM    948  CB  ALA   116      29.767  46.415   7.151  1.00 18.37           C  
ATOM    949  N   TYR   117      32.186  46.762   5.178  1.00 16.80           N  
ATOM    950  CA  TYR   117      33.643  46.870   4.922  1.00 16.57           C  
ATOM    951  C   TYR   117      34.160  48.128   5.558  1.00 19.40           C  
ATOM    952  O   TYR   117      33.404  49.096   5.756  1.00 17.01           O  
ATOM    953  CB  TYR   117      33.920  46.873   3.397  1.00 17.31           C  
ATOM    954  CG  TYR   117      33.361  45.617   2.746  1.00 19.59           C  
ATOM    955  CD1 TYR   117      34.018  44.399   2.876  1.00 20.47           C  
ATOM    956  CD2 TYR   117      32.124  45.637   2.084  1.00 20.52           C  
ATOM    957  CE1 TYR   117      33.501  43.243   2.328  1.00 17.56           C  
ATOM    958  CE2 TYR   117      31.601  44.488   1.515  1.00 22.34           C  
ATOM    959  CZ  TYR   117      32.279  43.295   1.653  1.00 22.06           C  
ATOM    960  OH  TYR   117      31.744  42.169   1.124  1.00 21.87           O  
ATOM    961  N   GLY   118      35.448  48.143   5.874  1.00 19.03           N  
ATOM    962  CA  GLY   118      36.030  49.316   6.478  1.00 19.24           C  
ATOM    963  C   GLY   118      37.527  49.267   6.295  1.00 16.72           C  
ATOM    964  O   GLY   118      38.090  48.234   5.913  1.00 20.13           O  
ATOM    965  N   VAL   119      38.164  50.403   6.517  1.00 16.32           N  
ATOM    966  CA  VAL   119      39.604  50.494   6.412  1.00 15.00           C  
ATOM    967  C   VAL   119      40.169  50.936   7.753  1.00 22.40           C  
ATOM    968  O   VAL   119      39.583  51.799   8.435  1.00 22.82           O  
ATOM    969  CB  VAL   119      40.100  51.440   5.249  1.00 22.27           C  
ATOM    970  CG1 VAL   119      39.592  50.948   3.891  1.00 19.88           C  
ATOM    971  CG2 VAL   119      39.690  52.898   5.489  1.00 22.21           C  
ATOM    972  N   HIS   120      41.285  50.311   8.137  1.00 18.08           N  
ATOM    973  CA  HIS   120      41.968  50.589   9.417  1.00 19.70           C  
ATOM    974  C   HIS   120      43.453  50.730   9.187  1.00 21.42           C  
ATOM    975  O   HIS   120      44.094  49.860   8.570  1.00 20.16           O  
ATOM    976  CB  HIS   120      41.709  49.468  10.444  1.00 18.67           C  
ATOM    977  CG  HIS   120      40.288  49.423  10.918  1.00 20.33           C  
ATOM    978  ND1 HIS   120      39.921  49.778  12.195  1.00 18.82           N  
ATOM    979  CD2 HIS   120      39.142  49.097  10.276  1.00 22.07           C  
ATOM    980  CE1 HIS   120      38.609  49.662  12.326  1.00 20.40           C  
ATOM    981  NE2 HIS   120      38.114  49.271  11.167  1.00 21.07           N  
ATOM    982  N   LEU   121      43.992  51.845   9.667  1.00 17.73           N  
ATOM    983  CA  LEU   121      45.391  52.168   9.486  1.00 19.07           C  
ATOM    984  C   LEU   121      46.194  52.043  10.780  1.00 17.80           C  
ATOM    985  O   LEU   121      45.801  52.603  11.817  1.00 19.58           O  
ATOM    986  CB  LEU   121      45.541  53.594   8.939  1.00 16.96           C  
ATOM    987  CG  LEU   121      46.996  54.056   8.719  1.00 19.89           C  
ATOM    988  CD1 LEU   121      47.636  53.390   7.537  1.00 22.06           C  
ATOM    989  CD2 LEU   121      47.033  55.582   8.509  1.00 22.75           C  
ATOM    990  N   ASN   122      47.303  51.298  10.705  1.00 19.55           N  
ATOM    991  CA  ASN   122      48.301  51.221  11.781  1.00 21.15           C  
ATOM    992  C   ASN   122      49.405  52.240  11.517  1.00 19.94           C  
ATOM    993  O   ASN   122      50.271  52.018  10.667  1.00 21.83           O  
ATOM    994  CB  ASN   122      48.888  49.806  11.905  1.00 17.68           C  
ATOM    995  CG  ASN   122      47.824  48.744  12.154  1.00 26.32           C  
ATOM    996  OD1 ASN   122      47.116  48.776  13.163  1.00 22.92           O  
ATOM    997  ND2 ASN   122      47.707  47.804  11.238  1.00 18.70           N  
ATOM    998  N   GLY   123      49.334  53.381  12.208  1.00 20.19           N  
ATOM    999  CA  GLY   123      50.345  54.440  12.079  1.00 18.15           C  
ATOM   1000  C   GLY   123      51.381  54.310  13.171  1.00 21.64           C  
ATOM   1001  O   GLY   123      51.065  54.442  14.366  1.00 22.55           O  
ATOM   1002  N   TYR   124      52.620  54.067  12.763  1.00 22.90           N  
ATOM   1003  CA  TYR   124      53.694  53.774  13.698  1.00 25.90           C  
ATOM   1004  C   TYR   124      55.020  54.490  13.366  1.00 25.41           C  
ATOM   1005  O   TYR   124      55.209  54.987  12.233  1.00 23.58           O  
ATOM   1006  CB  TYR   124      53.884  52.237  13.832  1.00 21.31           C  
ATOM   1007  CG  TYR   124      54.369  51.536  12.592  1.00 27.55           C  
ATOM   1008  CD1 TYR   124      55.728  51.400  12.332  1.00 30.72           C  
ATOM   1009  CD2 TYR   124      53.469  50.982  11.680  1.00 27.78           C  
ATOM   1010  CE1 TYR   124      56.182  50.760  11.192  1.00 31.47           C  
ATOM   1011  CE2 TYR   124      53.919  50.339  10.543  1.00 30.81           C  
ATOM   1012  CZ  TYR   124      55.265  50.228  10.304  1.00 31.70           C  
ATOM   1013  OH  TYR   124      55.719  49.579   9.177  1.00 42.11           O  
ATOM   1014  N   VAL   125      55.895  54.566  14.384  1.00 29.81           N  
ATOM   1015  CA  VAL   125      57.235  55.137  14.244  0.50 32.58           C  
ATOM   1017  C   VAL   125      58.246  54.234  14.931  1.00 34.47           C  
ATOM   1018  O   VAL   125      57.929  53.543  15.901  1.00 36.28           O  
ATOM   1019  CB  VAL   125      57.365  56.610  14.786  0.50 31.90           C  
ATOM   1021  CG1 VAL   125      56.598  57.581  13.923  0.50 28.83           C  
ATOM   1023  CG2 VAL   125      56.931  56.736  16.248  0.50 25.63           C  
ATOM   1025  N   GLY   126      59.472  54.206  14.407  1.00 37.83           N  
ATOM   1026  CA  GLY   126      60.529  53.399  15.017  1.00 35.15           C  
ATOM   1027  C   GLY   126      60.513  51.960  14.553  1.00 37.66           C  
ATOM   1028  O   GLY   126      59.729  51.601  13.680  1.00 38.85           O  
ATOM   1029  N   ALA   127      61.400  51.144  15.123  1.00 41.73           N  
ATOM   1030  CA  ALA   127      61.486  49.714  14.808  1.00 44.35           C  
ATOM   1031  C   ALA   127      61.973  48.958  16.031  1.00 47.23           C  
ATOM   1032  O   ALA   127      62.529  49.566  16.954  1.00 46.60           O  
ATOM   1033  CB  ALA   127      62.415  49.466  13.622  1.00 46.56           C  
ATOM   1034  N   GLY   128      61.751  47.644  16.037  1.00 47.40           N  
ATOM   1035  CA  GLY   128      62.218  46.768  17.107  1.00 50.12           C  
ATOM   1036  C   GLY   128      61.766  47.220  18.479  1.00 51.85           C  
ATOM   1037  O   GLY   128      60.591  47.487  18.685  1.00 49.32           O  
ATOM   1038  N   ALA   129      62.719  47.366  19.398  1.00 53.70           N  
ATOM   1039  CA  ALA   129      62.427  47.766  20.776  1.00 52.09           C  
ATOM   1040  C   ALA   129      61.864  49.189  20.926  1.00 49.76           C  
ATOM   1041  O   ALA   129      61.302  49.525  21.971  1.00 51.31           O  
ATOM   1042  CB  ALA   129      63.673  47.580  21.661  1.00 58.37           C  
ATOM   1043  N   ASP   130      61.988  50.006  19.878  1.00 42.21           N  
ATOM   1044  CA  ASP   130      61.566  51.406  19.908  0.50 41.80           C  
ATOM   1046  C   ASP   130      60.292  51.658  19.075  1.00 36.31           C  
ATOM   1047  O   ASP   130      59.968  52.791  18.752  1.00 38.36           O  
ATOM   1048  CB  ASP   130      62.718  52.293  19.417  0.50 40.53           C  
ATOM   1050  CG  ASP   130      64.080  51.814  19.913  0.50 50.35           C  
ATOM   1052  OD1 ASP   130      64.218  51.549  21.128  0.50 52.59           O  
ATOM   1054  OD2 ASP   130      65.011  51.699  19.084  0.50 53.48           O  
ATOM   1056  N   LEU   131      59.587  50.592  18.717  1.00 34.21           N  
ATOM   1057  CA  LEU   131      58.357  50.692  17.930  1.00 32.36           C  
ATOM   1058  C   LEU   131      57.231  51.347  18.729  1.00 29.17           C  
ATOM   1059  O   LEU   131      56.875  50.888  19.824  1.00 31.74           O  
ATOM   1060  CB  LEU   131      57.936  49.290  17.504  1.00 33.48           C  
ATOM   1061  CG  LEU   131      56.788  49.115  16.520  1.00 38.03           C  
ATOM   1062  CD1 LEU   131      57.146  49.674  15.163  1.00 38.14           C  
ATOM   1063  CD2 LEU   131      56.476  47.633  16.402  1.00 34.66           C  
ATOM   1064  N   HIS   132      56.697  52.440  18.189  1.00 27.61           N  
ATOM   1065  CA  HIS   132      55.625  53.187  18.816  1.00 23.90           C  
ATOM   1066  C   HIS   132      54.403  53.300  17.890  1.00 24.13           C  
ATOM   1067  O   HIS   132      54.568  53.508  16.702  1.00 28.10           O  
ATOM   1068  CB  HIS   132      56.104  54.594  19.205  1.00 25.85           C  
ATOM   1069  CG  HIS   132      57.031  54.617  20.382  1.00 24.89           C  
ATOM   1070  ND1 HIS   132      56.661  55.116  21.613  1.00 30.01           N  
ATOM   1071  CD2 HIS   132      58.310  54.197  20.517  1.00 29.31           C  
ATOM   1072  CE1 HIS   132      57.673  55.006  22.453  1.00 26.14           C  
ATOM   1073  NE2 HIS   132      58.684  54.446  21.815  1.00 33.17           N  
ATOM   1074  N   LEU   133      53.202  53.178  18.454  1.00 28.30           N  
ATOM   1075  CA  LEU   133      51.965  53.311  17.693  0.50 25.22           C  
ATOM   1077  C   LEU   133      51.192  54.565  18.089  1.00 28.50           C  
ATOM   1078  O   LEU   133      51.068  54.881  19.279  1.00 28.20           O  
ATOM   1079  CB  LEU   133      51.074  52.082  17.888  0.50 25.92           C  
ATOM   1081  CG  LEU   133      51.376  50.838  17.050  0.50 26.92           C  
ATOM   1083  CD1 LEU   133      50.895  49.605  17.797  0.50 26.96           C  
ATOM   1085  CD2 LEU   133      50.773  50.929  15.631  0.50 14.39           C  
ATOM   1087  N   TRP   134      50.677  55.273  17.079  1.00 24.73           N  
ATOM   1088  CA  TRP   134      49.741  56.378  17.310  1.00 28.04           C  
ATOM   1089  C   TRP   134      48.363  55.790  17.526  1.00 21.54           C  
ATOM   1090  O   TRP   134      47.880  55.030  16.697  1.00 27.82           O  
ATOM   1091  CB  TRP   134      49.680  57.332  16.115  1.00 24.82           C  
ATOM   1092  CG  TRP   134      50.814  58.286  16.080  1.00 25.59           C  
ATOM   1093  CD1 TRP   134      51.899  58.229  15.270  1.00 25.75           C  
ATOM   1094  CD2 TRP   134      50.989  59.436  16.920  1.00 27.94           C  
ATOM   1095  NE1 TRP   134      52.752  59.290  15.539  1.00 32.80           N  
ATOM   1096  CE2 TRP   134      52.208  60.045  16.547  1.00 32.27           C  
ATOM   1097  CE3 TRP   134      50.226  60.016  17.948  1.00 29.66           C  
ATOM   1098  CZ2 TRP   134      52.694  61.209  17.178  1.00 32.34           C  
ATOM   1099  CZ3 TRP   134      50.701  61.175  18.566  1.00 27.78           C  
ATOM   1100  CH2 TRP   134      51.928  61.751  18.178  1.00 25.76           C  
ATOM   1101  N   ILE   135      47.743  56.157  18.633  1.00 20.49           N  
ATOM   1102  CA  ILE   135      46.424  55.667  19.012  1.00 23.64           C  
ATOM   1103  C   ILE   135      45.507  56.876  19.036  1.00 24.63           C  
ATOM   1104  O   ILE   135      45.884  57.934  19.535  1.00 25.53           O  
ATOM   1105  CB  ILE   135      46.491  54.994  20.443  1.00 25.95           C  
ATOM   1106  CG1 ILE   135      47.393  53.740  20.415  1.00 32.16           C  
ATOM   1107  CG2 ILE   135      45.105  54.739  21.036  1.00 28.52           C  
ATOM   1108  CD1 ILE   135      47.131  52.779  19.275  1.00 32.57           C  
ATOM   1109  N   GLY   136      44.291  56.729  18.517  1.00 22.14           N  
ATOM   1110  CA  GLY   136      43.312  57.788  18.672  1.00 23.75           C  
ATOM   1111  C   GLY   136      42.392  57.506  19.845  1.00 29.17           C  
ATOM   1112  O   GLY   136      42.214  56.345  20.221  1.00 26.20           O  
ATOM   1113  N   ARG   137      41.853  58.561  20.468  1.00 27.14           N  
ATOM   1114  CA  ARG   137      40.785  58.419  21.449  0.50 27.41           C  
ATOM   1116  C   ARG   137      39.521  58.970  20.802  1.00 26.20           C  
ATOM   1117  O   ARG   137      39.511  60.130  20.393  1.00 30.01           O  
ATOM   1118  CB  ARG   137      41.113  59.202  22.723  0.50 28.24           C  
ATOM   1120  CG  ARG   137      40.424  58.677  23.983  0.50 35.93           C  
ATOM   1122  CD  ARG   137      40.349  59.720  25.115  0.50 34.31           C  
ATOM   1124  NE  ARG   137      41.505  60.618  25.170  0.50 35.77           N  
ATOM   1126  CZ  ARG   137      42.654  60.353  25.790  0.50 35.38           C  
ATOM   1128  NH1 ARG   137      43.629  61.251  25.770  0.50 40.30           N  
ATOM   1130  NH2 ARG   137      42.837  59.204  26.431  0.50 38.83           N  
ATOM   1132  N   ARG   138      38.478  58.146  20.717  1.00 26.46           N  
ATOM   1133  CA  ARG   138      37.248  58.524  20.025  1.00 25.62           C  
ATOM   1134  C   ARG   138      36.522  59.630  20.787  1.00 30.91           C  
ATOM   1135  O   ARG   138      36.602  59.709  22.021  1.00 29.45           O  
ATOM   1136  CB  ARG   138      36.339  57.304  19.832  1.00 23.64           C  
ATOM   1137  CG  ARG   138      36.966  56.242  18.907  1.00 21.94           C  
ATOM   1138  CD  ARG   138      36.266  54.910  18.996  1.00 20.70           C  
ATOM   1139  NE  ARG   138      34.880  54.968  18.531  1.00 22.86           N  
ATOM   1140  CZ  ARG   138      34.529  54.986  17.247  1.00 20.39           C  
ATOM   1141  NH1 ARG   138      35.457  54.949  16.293  1.00 22.53           N  
ATOM   1142  NH2 ARG   138      33.259  55.024  16.912  1.00 23.32           N  
ATOM   1143  N   SER   139      35.824  60.482  20.046  1.00 30.82           N  
ATOM   1144  CA  SER   139      35.057  61.578  20.638  1.00 30.87           C  
ATOM   1145  C   SER   139      33.940  61.000  21.509  1.00 34.11           C  
ATOM   1146  O   SER   139      33.421  59.916  21.203  1.00 30.95           O  
ATOM   1147  CB  SER   139      34.488  62.454  19.511  1.00 33.82           C  
ATOM   1148  OG  SER   139      33.340  63.180  19.913  1.00 44.80           O  
ATOM   1149  N   PRO   140      33.553  61.712  22.597  1.00 38.34           N  
ATOM   1150  CA  PRO   140      32.428  61.225  23.417  1.00 34.53           C  
ATOM   1151  C   PRO   140      31.082  61.213  22.695  1.00 37.90           C  
ATOM   1152  O   PRO   140      30.154  60.542  23.157  1.00 31.63           O  
ATOM   1153  CB  PRO   140      32.380  62.217  24.592  1.00 39.75           C  
ATOM   1154  CG  PRO   140      33.679  62.919  24.569  1.00 42.46           C  
ATOM   1155  CD  PRO   140      34.111  62.964  23.141  1.00 37.78           C  
ATOM   1156  N   ASP   141      30.996  61.920  21.563  1.00 35.55           N  
ATOM   1157  CA  ASP   141      29.781  62.004  20.771  1.00 36.36           C  
ATOM   1158  C   ASP   141      29.584  60.825  19.802  1.00 34.79           C  
ATOM   1159  O   ASP   141      28.527  60.709  19.174  1.00 34.78           O  
ATOM   1160  CB  ASP   141      29.739  63.340  20.013  1.00 44.42           C  
ATOM   1161  CG  ASP   141      29.874  64.547  20.938  1.00 49.36           C  
ATOM   1162  OD1 ASP   141      29.306  64.515  22.049  1.00 56.17           O  
ATOM   1163  OD2 ASP   141      30.558  65.525  20.559  1.00 52.17           O  
ATOM   1164  N   LYS   142      30.576  59.939  19.681  1.00 29.21           N  
ATOM   1165  CA  LYS   142      30.384  58.752  18.851  1.00 25.30           C  
ATOM   1166  C   LYS   142      29.212  57.930  19.356  1.00 25.78           C  
ATOM   1167  O   LYS   142      29.064  57.680  20.568  1.00 27.08           O  
ATOM   1168  CB  LYS   142      31.640  57.870  18.797  1.00 27.48           C  
ATOM   1169  CG  LYS   142      32.783  58.447  17.985  1.00 21.74           C  
ATOM   1170  CD  LYS   142      32.458  58.500  16.487  1.00 23.30           C  
ATOM   1171  CE  LYS   142      33.691  58.863  15.653  1.00 37.56           C  
ATOM   1172  NZ  LYS   142      33.392  58.674  14.195  1.00 34.81           N  
ATOM   1173  N   SER   143      28.395  57.504  18.408  1.00 28.71           N  
ATOM   1174  CA  SER   143      27.291  56.609  18.662  1.00 30.64           C  
ATOM   1175  C   SER   143      27.787  55.255  19.212  1.00 34.84           C  
ATOM   1176  O   SER   143      27.203  54.700  20.156  1.00 33.01           O  
ATOM   1177  CB  SER   143      26.516  56.417  17.359  1.00 38.43           C  
ATOM   1178  OG  SER   143      25.518  55.421  17.483  1.00 52.04           O  
ATOM   1179  N   VAL   144      28.881  54.763  18.625  1.00 26.02           N  
ATOM   1180  CA  VAL   144      29.490  53.472  18.954  1.00 27.84           C  
ATOM   1181  C   VAL   144      30.828  53.714  19.640  1.00 24.68           C  
ATOM   1182  O   VAL   144      31.624  54.538  19.176  1.00 29.30           O  
ATOM   1183  CB  VAL   144      29.689  52.619  17.656  1.00 24.85           C  
ATOM   1184  CG1 VAL   144      30.577  51.388  17.923  1.00 28.55           C  
ATOM   1185  CG2 VAL   144      28.334  52.209  17.074  1.00 29.86           C  
ATOM   1186  N   ALA   145      31.073  53.020  20.760  1.00 28.68           N  
ATOM   1187  CA  ALA   145      32.369  53.094  21.450  1.00 27.24           C  
ATOM   1188  C   ALA   145      32.860  54.538  21.737  1.00 24.20           C  
ATOM   1189  O   ALA   145      34.024  54.866  21.456  1.00 24.03           O  
ATOM   1190  CB  ALA   145      33.455  52.282  20.649  1.00 22.65           C  
ATOM   1191  N   PRO   146      31.979  55.416  22.294  1.00 26.11           N  
ATOM   1192  CA  PRO   146      32.462  56.776  22.548  1.00 27.01           C  
ATOM   1193  C   PRO   146      33.556  56.753  23.604  1.00 27.01           C  
ATOM   1194  O   PRO   146      33.477  55.947  24.536  1.00 26.67           O  
ATOM   1195  CB  PRO   146      31.219  57.494  23.089  1.00 26.92           C  
ATOM   1196  CG  PRO   146      30.367  56.410  23.679  1.00 26.95           C  
ATOM   1197  CD  PRO   146      30.582  55.243  22.751  1.00 26.57           C  
ATOM   1198  N   GLY   147      34.583  57.584  23.429  1.00 23.06           N  
ATOM   1199  CA  GLY   147      35.705  57.661  24.359  1.00 27.37           C  
ATOM   1200  C   GLY   147      36.691  56.497  24.326  1.00 31.76           C  
ATOM   1201  O   GLY   147      37.667  56.505  25.074  1.00 28.82           O  
ATOM   1202  N   LYS   148      36.440  55.491  23.485  1.00 27.28           N  
ATOM   1203  CA  LYS   148      37.332  54.317  23.405  1.00 26.06           C  
ATOM   1204  C   LYS   148      38.557  54.579  22.543  1.00 24.99           C  
ATOM   1205  O   LYS   148      38.583  55.495  21.700  1.00 22.55           O  
ATOM   1206  CB  LYS   148      36.593  53.091  22.883  1.00 28.51           C  
ATOM   1207  CG  LYS   148      35.318  52.761  23.627  1.00 30.74           C  
ATOM   1208  CD  LYS   148      35.550  52.390  25.007  1.00 43.85           C  
ATOM   1209  CE  LYS   148      35.908  50.942  25.127  1.00 32.51           C  
ATOM   1210  NZ  LYS   148      35.988  50.749  26.579  1.00 28.96           N  
ATOM   1211  N   LEU   149      39.580  53.755  22.738  1.00 19.09           N  
ATOM   1212  CA  LEU   149      40.799  53.869  21.978  1.00 20.06           C  
ATOM   1213  C   LEU   149      40.618  53.178  20.614  1.00 21.55           C  
ATOM   1214  O   LEU   149      39.808  52.249  20.469  1.00 19.47           O  
ATOM   1215  CB  LEU   149      41.978  53.254  22.739  1.00 19.37           C  
ATOM   1216  CG  LEU   149      42.239  53.841  24.143  1.00 22.93           C  
ATOM   1217  CD1 LEU   149      43.478  53.201  24.754  1.00 25.48           C  
ATOM   1218  CD2 LEU   149      42.424  55.331  24.014  1.00 24.59           C  
ATOM   1219  N   ASP   150      41.386  53.643  19.642  1.00 19.17           N  
ATOM   1220  CA  ASP   150      41.137  53.381  18.214  1.00 17.87           C  
ATOM   1221  C   ASP   150      42.435  53.385  17.456  1.00 21.13           C  
ATOM   1222  O   ASP   150      43.464  53.839  17.963  1.00 19.36           O  
ATOM   1223  CB  ASP   150      40.216  54.510  17.665  1.00 22.49           C  
ATOM   1224  CG  ASP   150      39.310  54.075  16.479  1.00 28.89           C  
ATOM   1225  OD1 ASP   150      39.538  53.036  15.793  1.00 24.67           O  
ATOM   1226  OD2 ASP   150      38.338  54.829  16.218  1.00 21.49           O  
ATOM   1227  N   ASN   151      42.412  52.873  16.220  1.00 19.91           N  
ATOM   1228  CA  ASN   151      43.513  53.121  15.292  1.00 18.90           C  
ATOM   1229  C   ASN   151      43.692  54.630  15.039  1.00 19.61           C  
ATOM   1230  O   ASN   151      42.763  55.413  15.282  1.00 21.72           O  
ATOM   1231  CB  ASN   151      43.249  52.436  13.953  1.00 19.47           C  
ATOM   1232  CG  ASN   151      42.927  50.965  14.110  1.00 21.52           C  
ATOM   1233  OD1 ASN   151      41.774  50.562  13.988  1.00 25.50           O  
ATOM   1234  ND2 ASN   151      43.938  50.165  14.449  1.00 24.44           N  
ATOM   1235  N   MET   152      44.869  55.023  14.553  1.00 20.04           N  
ATOM   1236  CA  MET   152      45.111  56.424  14.225  1.00 22.73           C  
ATOM   1237  C   MET   152      44.070  56.899  13.189  1.00 23.86           C  
ATOM   1238  O   MET   152      43.521  58.014  13.289  1.00 21.66           O  
ATOM   1239  CB  MET   152      46.514  56.636  13.679  1.00 18.42           C  
ATOM   1240  CG  MET   152      46.859  58.149  13.591  1.00 23.68           C  
ATOM   1241  SD  MET   152      48.604  58.426  12.865  0.70 28.49          SE  
ATOM   1242  CE  MET   152      48.177  58.085  11.003  1.00 34.44           C  
ATOM   1243  N   VAL   153      43.777  56.029  12.217  1.00 20.16           N  
ATOM   1244  CA  VAL   153      42.762  56.323  11.194  1.00 19.57           C  
ATOM   1245  C   VAL   153      41.943  55.047  10.963  1.00 19.06           C  
ATOM   1246  O   VAL   153      42.516  53.975  10.822  1.00 20.64           O  
ATOM   1247  CB  VAL   153      43.415  56.792   9.862  1.00 20.96           C  
ATOM   1248  CG1 VAL   153      42.353  56.936   8.741  1.00 24.65           C  
ATOM   1249  CG2 VAL   153      44.159  58.106  10.035  1.00 22.39           C  
ATOM   1250  N   ALA   154      40.617  55.163  10.971  1.00 19.92           N  
ATOM   1251  CA  ALA   154      39.731  54.023  10.657  1.00 21.62           C  
ATOM   1252  C   ALA   154      38.397  54.570  10.228  1.00 25.62           C  
ATOM   1253  O   ALA   154      37.948  55.570  10.773  1.00 25.22           O  
ATOM   1254  CB  ALA   154      39.524  53.137  11.885  1.00 20.52           C  
ATOM   1255  N   GLY   155      37.735  53.910   9.291  1.00 19.78           N  
ATOM   1256  CA  GLY   155      36.358  54.302   8.976  1.00 23.92           C  
ATOM   1257  C   GLY   155      35.641  53.261   8.154  1.00 25.11           C  
ATOM   1258  O   GLY   155      36.280  52.417   7.521  1.00 20.50           O  
ATOM   1259  N   GLY   156      34.313  53.317   8.176  1.00 16.33           N  
ATOM   1260  CA  GLY   156      33.510  52.527   7.267  1.00 17.20           C  
ATOM   1261  C   GLY   156      33.756  52.878   5.803  1.00 17.21           C  
ATOM   1262  O   GLY   156      34.197  53.983   5.475  1.00 20.27           O  
ATOM   1263  N   GLN   157      33.468  51.919   4.926  1.00 21.75           N  
ATOM   1264  CA  GLN   157      33.725  52.051   3.502  1.00 18.48           C  
ATOM   1265  C   GLN   157      32.454  52.429   2.761  1.00 20.30           C  
ATOM   1266  O   GLN   157      31.530  51.630   2.670  1.00 19.32           O  
ATOM   1267  CB  GLN   157      34.219  50.733   2.932  1.00 20.97           C  
ATOM   1268  CG  GLN   157      34.585  50.817   1.450  1.00 17.60           C  
ATOM   1269  CD  GLN   157      35.776  51.699   1.251  1.00 22.34           C  
ATOM   1270  OE1 GLN   157      36.605  51.847   2.153  1.00 20.60           O  
ATOM   1271  NE2 GLN   157      35.886  52.292   0.068  1.00 22.64           N  
ATOM   1272  N   PRO   158      32.420  53.634   2.195  1.00 20.08           N  
ATOM   1273  CA  PRO   158      31.248  53.977   1.381  1.00 22.50           C  
ATOM   1274  C   PRO   158      31.248  53.236   0.035  1.00 19.52           C  
ATOM   1275  O   PRO   158      32.300  52.813  -0.455  1.00 22.07           O  
ATOM   1276  CB  PRO   158      31.373  55.491   1.172  1.00 25.22           C  
ATOM   1277  CG  PRO   158      32.803  55.820   1.440  1.00 26.79           C  
ATOM   1278  CD  PRO   158      33.400  54.730   2.294  1.00 20.41           C  
ATOM   1279  N   ALA   159      30.050  53.050  -0.505  1.00 21.68           N  
ATOM   1280  CA  ALA   159      29.832  52.394  -1.781  1.00 23.81           C  
ATOM   1281  C   ALA   159      30.622  53.032  -2.917  1.00 28.04           C  
ATOM   1282  O   ALA   159      31.044  52.329  -3.845  1.00 25.76           O  
ATOM   1283  CB  ALA   159      28.379  52.443  -2.120  1.00 28.69           C  
ATOM   1284  N   ASP   160      30.840  54.346  -2.847  1.00 24.07           N  
ATOM   1285  CA  ASP   160      31.271  55.058  -4.054  1.00 33.19           C  
ATOM   1286  C   ASP   160      32.778  55.280  -4.144  1.00 33.50           C  
ATOM   1287  O   ASP   160      33.247  55.930  -5.091  1.00 25.67           O  
ATOM   1288  CB  ASP   160      30.494  56.378  -4.237  1.00 30.97           C  
ATOM   1289  CG  ASP   160      30.814  57.410  -3.164  1.00 39.20           C  
ATOM   1290  OD1 ASP   160      31.210  57.017  -2.048  1.00 33.72           O  
ATOM   1291  OD2 ASP   160      30.659  58.620  -3.436  1.00 46.55           O  
ATOM   1292  N   LEU   161      33.521  54.729  -3.178  1.00 24.34           N  
ATOM   1293  CA  LEU   161      34.989  54.888  -3.136  1.00 22.16           C  
ATOM   1294  C   LEU   161      35.713  53.536  -3.169  1.00 25.00           C  
ATOM   1295  O   LEU   161      35.177  52.523  -2.695  1.00 23.70           O  
ATOM   1296  CB  LEU   161      35.414  55.651  -1.874  1.00 22.56           C  
ATOM   1297  CG  LEU   161      34.928  57.096  -1.657  1.00 30.24           C  
ATOM   1298  CD1 LEU   161      35.634  57.695  -0.437  1.00 27.83           C  
ATOM   1299  CD2 LEU   161      35.183  57.934  -2.909  1.00 23.35           C  
ATOM   1300  N   SER   162      36.929  53.543  -3.710  1.00 19.44           N  
ATOM   1301  CA  SER   162      37.896  52.441  -3.518  1.00 18.75           C  
ATOM   1302  C   SER   162      38.383  52.464  -2.051  1.00 16.03           C  
ATOM   1303  O   SER   162      38.138  53.432  -1.324  1.00 18.03           O  
ATOM   1304  CB  SER   162      39.094  52.550  -4.471  1.00 17.15           C  
ATOM   1305  OG  SER   162      39.999  53.562  -4.049  1.00 20.75           O  
ATOM   1306  N   LEU   163      39.050  51.391  -1.627  1.00 19.00           N  
ATOM   1307  CA  LEU   163      39.595  51.317  -0.272  1.00 18.42           C  
ATOM   1308  C   LEU   163      40.671  52.381  -0.112  1.00 19.29           C  
ATOM   1309  O   LEU   163      40.718  53.055   0.905  1.00 17.38           O  
ATOM   1310  CB  LEU   163      40.196  49.919  -0.020  1.00 15.49           C  
ATOM   1311  CG  LEU   163      39.127  48.827  -0.009  1.00 17.28           C  
ATOM   1312  CD1 LEU   163      39.794  47.445  -0.052  1.00 19.40           C  
ATOM   1313  CD2 LEU   163      38.208  48.916   1.206  1.00 21.21           C  
ATOM   1314  N   ARG   164      41.510  52.514  -1.135  1.00 17.15           N  
ATOM   1315  CA  ARG   164      42.623  53.462  -1.087  1.00 22.19           C  
ATOM   1316  C   ARG   164      42.088  54.905  -1.016  1.00 22.29           C  
ATOM   1317  O   ARG   164      42.616  55.747  -0.281  1.00 22.06           O  
ATOM   1318  CB  ARG   164      43.540  53.283  -2.294  1.00 24.55           C  
ATOM   1319  CG  ARG   164      44.631  54.375  -2.420  1.00 26.08           C  
ATOM   1320  CD  ARG   164      45.627  54.235  -1.296  1.00 29.30           C  
ATOM   1321  NE  ARG   164      46.362  52.975  -1.399  1.00 38.00           N  
ATOM   1322  CZ  ARG   164      47.405  52.647  -0.639  1.00 34.41           C  
ATOM   1323  NH1 ARG   164      47.838  53.476   0.317  1.00 28.73           N  
ATOM   1324  NH2 ARG   164      48.010  51.489  -0.842  1.00 29.91           N  
ATOM   1325  N   GLN   165      41.038  55.181  -1.780  1.00 20.52           N  
ATOM   1326  CA  GLN   165      40.438  56.522  -1.806  1.00 21.23           C  
ATOM   1327  C   GLN   165      39.844  56.868  -0.457  1.00 21.59           C  
ATOM   1328  O   GLN   165      40.038  57.982   0.062  1.00 20.84           O  
ATOM   1329  CB  GLN   165      39.336  56.598  -2.863  1.00 21.52           C  
ATOM   1330  CG  GLN   165      39.894  56.847  -4.261  1.00 28.49           C  
ATOM   1331  CD  GLN   165      39.029  56.265  -5.354  1.00 36.32           C  
ATOM   1332  OE1 GLN   165      37.806  56.063  -5.196  1.00 26.17           O  
ATOM   1333  NE2 GLN   165      39.665  55.986  -6.491  1.00 39.85           N  
ATOM   1334  N   ASN   166      39.107  55.918   0.106  1.00 21.23           N  
ATOM   1335  CA  ASN   166      38.535  56.108   1.415  1.00 22.05           C  
ATOM   1336  C   ASN   166      39.629  56.262   2.475  1.00 22.07           C  
ATOM   1337  O   ASN   166      39.542  57.133   3.315  1.00 20.60           O  
ATOM   1338  CB  ASN   166      37.599  54.967   1.791  1.00 20.63           C  
ATOM   1339  CG  ASN   166      36.757  55.305   3.021  1.00 23.47           C  
ATOM   1340  OD1 ASN   166      36.291  56.449   3.168  1.00 23.28           O  
ATOM   1341  ND2 ASN   166      36.583  54.349   3.904  1.00 18.78           N  
ATOM   1342  N   LEU   167      40.657  55.415   2.423  1.00 19.16           N  
ATOM   1343  CA  LEU   167      41.799  55.585   3.326  1.00 22.36           C  
ATOM   1344  C   LEU   167      42.376  57.018   3.244  1.00 27.44           C  
ATOM   1345  O   LEU   167      42.636  57.642   4.269  1.00 22.88           O  
ATOM   1346  CB  LEU   167      42.895  54.563   3.029  1.00 20.82           C  
ATOM   1347  CG  LEU   167      44.107  54.634   3.965  1.00 26.27           C  
ATOM   1348  CD1 LEU   167      43.730  54.259   5.425  1.00 21.08           C  
ATOM   1349  CD2 LEU   167      45.208  53.749   3.420  1.00 22.64           C  
ATOM   1350  N   ILE   168      42.555  57.538   2.028  1.00 26.93           N  
ATOM   1351  CA  ILE   168      43.115  58.897   1.843  1.00 25.17           C  
ATOM   1352  C   ILE   168      42.233  59.979   2.470  1.00 24.22           C  
ATOM   1353  O   ILE   168      42.714  60.859   3.184  1.00 23.88           O  
ATOM   1354  CB  ILE   168      43.383  59.177   0.341  1.00 28.80           C  
ATOM   1355  CG1 ILE   168      44.609  58.378  -0.097  1.00 21.59           C  
ATOM   1356  CG2 ILE   168      43.611  60.674   0.062  1.00 24.28           C  
ATOM   1357  CD1 ILE   168      44.644  58.115  -1.579  1.00 29.12           C  
ATOM   1358  N   LYS   169      40.942  59.881   2.215  1.00 21.03           N  
ATOM   1359  CA  LYS   169      39.965  60.802   2.753  1.00 25.69           C  
ATOM   1360  C   LYS   169      39.921  60.744   4.277  1.00 27.01           C  
ATOM   1361  O   LYS   169      39.920  61.770   4.938  1.00 24.12           O  
ATOM   1362  CB  LYS   169      38.605  60.472   2.187  1.00 20.71           C  
ATOM   1363  CG  LYS   169      37.441  61.203   2.821  1.00 28.07           C  
ATOM   1364  CD  LYS   169      36.119  60.764   2.225  1.00 44.80           C  
ATOM   1365  CE  LYS   169      34.965  61.166   3.143  1.00 54.68           C  
ATOM   1366  NZ  LYS   169      33.661  60.638   2.662  1.00 64.28           N  
ATOM   1367  N   GLU   170      39.906  59.538   4.834  1.00 18.72           N  
ATOM   1368  CA  GLU   170      39.874  59.382   6.287  1.00 20.09           C  
ATOM   1369  C   GLU   170      41.139  59.892   6.938  1.00 23.18           C  
ATOM   1370  O   GLU   170      41.073  60.468   8.020  1.00 27.45           O  
ATOM   1371  CB  GLU   170      39.622  57.917   6.696  1.00 22.79           C  
ATOM   1372  CG  GLU   170      38.258  57.350   6.280  1.00 25.29           C  
ATOM   1373  CD  GLU   170      37.049  58.059   6.906  1.00 40.32           C  
ATOM   1374  OE1 GLU   170      36.871  59.283   6.729  1.00 53.74           O  
ATOM   1375  OE2 GLU   170      36.237  57.371   7.550  1.00 42.38           O  
ATOM   1376  N   CYS   171      42.271  59.697   6.276  1.00 20.72           N  
ATOM   1377  CA  CYS   171      43.568  60.139   6.779  1.00 23.54           C  
ATOM   1378  C   CYS   171      43.620  61.653   6.964  1.00 30.29           C  
ATOM   1379  O   CYS   171      44.135  62.136   7.976  1.00 28.00           O  
ATOM   1380  CB  CYS   171      44.709  59.704   5.866  1.00 24.69           C  
ATOM   1381  SG  CYS   171      45.309  57.986   6.121  1.00 24.58           S  
ATOM   1382  N   ALA   172      43.089  62.377   5.974  1.00 25.84           N  
ATOM   1383  CA  ALA   172      42.997  63.838   6.024  1.00 26.87           C  
ATOM   1384  C   ALA   172      41.963  64.287   7.049  1.00 24.26           C  
ATOM   1385  O   ALA   172      42.255  65.126   7.889  1.00 28.18           O  
ATOM   1386  CB  ALA   172      42.653  64.407   4.617  1.00 26.01           C  
ATOM   1387  N   GLU   173      40.763  63.712   7.013  1.00 23.60           N  
ATOM   1388  CA  GLU   173      39.687  64.192   7.870  1.00 31.06           C  
ATOM   1389  C   GLU   173      39.919  63.865   9.345  1.00 31.04           C  
ATOM   1390  O   GLU   173      39.618  64.676  10.216  1.00 30.90           O  
ATOM   1391  CB  GLU   173      38.336  63.634   7.421  1.00 28.56           C  
ATOM   1392  CG  GLU   173      37.884  64.143   6.052  1.00 33.70           C  
ATOM   1393  CD  GLU   173      36.558  63.542   5.607  1.00 44.95           C  
ATOM   1394  OE1 GLU   173      36.107  62.539   6.213  1.00 52.84           O  
ATOM   1395  OE2 GLU   173      35.976  64.071   4.633  1.00 57.87           O  
ATOM   1396  N   GLU   174      40.459  62.683   9.625  1.00 27.71           N  
ATOM   1397  CA  GLU   174      40.521  62.220  11.005  1.00 24.57           C  
ATOM   1398  C   GLU   174      41.802  62.587  11.697  1.00 23.74           C  
ATOM   1399  O   GLU   174      41.819  62.763  12.916  1.00 27.22           O  
ATOM   1400  CB  GLU   174      40.311  60.703  11.110  1.00 21.95           C  
ATOM   1401  CG  GLU   174      38.903  60.226  10.741  1.00 31.09           C  
ATOM   1402  CD  GLU   174      38.726  58.714  10.905  1.00 40.24           C  
ATOM   1403  OE1 GLU   174      39.712  58.058  11.331  1.00 29.99           O  
ATOM   1404  OE2 GLU   174      37.601  58.194  10.616  1.00 30.74           O  
ATOM   1405  N   ALA   175      42.886  62.691  10.937  1.00 23.54           N  
ATOM   1406  CA  ALA   175      44.190  62.794  11.559  1.00 26.67           C  
ATOM   1407  C   ALA   175      45.070  63.861  10.933  1.00 23.54           C  
ATOM   1408  O   ALA   175      46.236  64.004  11.327  1.00 26.48           O  
ATOM   1409  CB  ALA   175      44.898  61.448  11.543  1.00 25.30           C  
ATOM   1410  N   ASP   176      44.536  64.581   9.945  1.00 30.87           N  
ATOM   1411  CA  ASP   176      45.316  65.624   9.266  1.00 31.29           C  
ATOM   1412  C   ASP   176      46.584  65.021   8.650  1.00 31.62           C  
ATOM   1413  O   ASP   176      47.680  65.585   8.741  1.00 26.14           O  
ATOM   1414  CB  ASP   176      45.645  66.754  10.271  1.00 35.88           C  
ATOM   1415  CG  ASP   176      46.111  68.041   9.596  1.00 44.42           C  
ATOM   1416  OD1 ASP   176      45.799  68.242   8.402  1.00 42.23           O  
ATOM   1417  OD2 ASP   176      46.803  68.835  10.266  1.00 45.65           O  
ATOM   1418  N   LEU   177      46.436  63.833   8.063  1.00 28.64           N  
ATOM   1419  CA  LEU   177      47.547  63.153   7.415  1.00 28.98           C  
ATOM   1420  C   LEU   177      47.363  63.336   5.912  1.00 29.59           C  
ATOM   1421  O   LEU   177      46.375  62.864   5.350  1.00 29.80           O  
ATOM   1422  CB  LEU   177      47.591  61.655   7.796  1.00 28.47           C  
ATOM   1423  CG  LEU   177      48.676  60.813   7.119  1.00 31.21           C  
ATOM   1424  CD1 LEU   177      50.059  61.193   7.567  1.00 43.08           C  
ATOM   1425  CD2 LEU   177      48.462  59.350   7.408  1.00 35.93           C  
ATOM   1426  N   PRO   178      48.287  64.075   5.272  1.00 36.79           N  
ATOM   1427  CA  PRO   178      48.150  64.497   3.880  1.00 35.44           C  
ATOM   1428  C   PRO   178      48.266  63.343   2.903  1.00 31.05           C  
ATOM   1429  O   PRO   178      48.832  62.296   3.248  1.00 31.49           O  
ATOM   1430  CB  PRO   178      49.332  65.455   3.684  1.00 38.30           C  
ATOM   1431  CG  PRO   178      50.349  65.018   4.692  1.00 42.22           C  
ATOM   1432  CD  PRO   178      49.543  64.563   5.873  1.00 35.40           C  
ATOM   1433  N   GLU   179      47.743  63.564   1.695  1.00 33.20           N  
ATOM   1434  CA  GLU   179      47.658  62.554   0.647  1.00 34.92           C  
ATOM   1435  C   GLU   179      48.979  61.886   0.297  1.00 33.77           C  
ATOM   1436  O   GLU   179      49.014  60.670   0.118  1.00 35.14           O  
ATOM   1437  CB  GLU   179      47.021  63.129  -0.615  1.00 35.78           C  
ATOM   1438  CG  GLU   179      46.777  62.071  -1.703  1.00 36.31           C  
ATOM   1439  CD  GLU   179      45.889  62.560  -2.842  1.00 45.49           C  
ATOM   1440  OE1 GLU   179      45.597  63.774  -2.898  1.00 52.73           O  
ATOM   1441  OE2 GLU   179      45.477  61.722  -3.677  1.00 45.51           O  
ATOM   1442  N   ALA   180      50.058  62.667   0.227  1.00 36.39           N  
ATOM   1443  CA  ALA   180      51.379  62.133  -0.131  1.00 38.20           C  
ATOM   1444  C   ALA   180      51.853  61.056   0.853  1.00 37.77           C  
ATOM   1445  O   ALA   180      52.397  60.028   0.444  1.00 41.56           O  
ATOM   1446  CB  ALA   180      52.416  63.260  -0.251  1.00 40.78           C  
ATOM   1447  N   LEU   181      51.627  61.294   2.142  1.00 36.73           N  
ATOM   1448  CA  LEU   181      51.914  60.280   3.160  1.00 34.41           C  
ATOM   1449  C   LEU   181      50.891  59.141   3.182  1.00 27.36           C  
ATOM   1450  O   LEU   181      51.282  57.985   3.216  1.00 31.68           O  
ATOM   1451  CB  LEU   181      52.044  60.908   4.548  1.00 31.23           C  
ATOM   1452  CG  LEU   181      53.424  61.415   4.958  1.00 44.99           C  
ATOM   1453  CD1 LEU   181      53.292  62.339   6.142  1.00 46.78           C  
ATOM   1454  CD2 LEU   181      54.331  60.242   5.304  1.00 49.35           C  
ATOM   1455  N   ALA   182      49.589  59.457   3.184  1.00 24.43           N  
ATOM   1456  CA  ALA   182      48.533  58.431   3.118  1.00 26.05           C  
ATOM   1457  C   ALA   182      48.706  57.419   1.980  1.00 30.74           C  
ATOM   1458  O   ALA   182      48.386  56.233   2.140  1.00 25.47           O  
ATOM   1459  CB  ALA   182      47.142  59.081   3.053  1.00 25.43           C  
ATOM   1460  N   ARG   183      49.211  57.878   0.829  1.00 28.18           N  
ATOM   1461  CA  ARG   183      49.477  56.998  -0.308  1.00 31.04           C  
ATOM   1462  C   ARG   183      50.649  56.021  -0.087  1.00 25.44           C  
ATOM   1463  O   ARG   183      50.764  55.015  -0.789  1.00 29.60           O  
ATOM   1464  CB  ARG   183      49.697  57.813  -1.595  1.00 29.99           C  
ATOM   1465  CG  ARG   183      48.406  58.279  -2.240  1.00 34.47           C  
ATOM   1466  CD  ARG   183      48.654  58.995  -3.593  1.00 43.53           C  
ATOM   1467  NE  ARG   183      47.418  59.526  -4.180  1.00 42.49           N  
ATOM   1468  CZ  ARG   183      46.495  58.799  -4.812  1.00 45.86           C  
ATOM   1469  NH1 ARG   183      46.631  57.479  -4.952  1.00 51.31           N  
ATOM   1470  NH2 ARG   183      45.416  59.395  -5.297  1.00 49.80           N  
ATOM   1471  N   GLN   184      51.530  56.332   0.857  1.00 30.80           N  
ATOM   1472  CA  GLN   184      52.625  55.422   1.196  1.00 31.05           C  
ATOM   1473  C   GLN   184      52.169  54.233   2.055  1.00 27.05           C  
ATOM   1474  O   GLN   184      52.927  53.271   2.211  1.00 26.28           O  
ATOM   1475  CB  GLN   184      53.746  56.175   1.903  1.00 30.65           C  
ATOM   1476  CG  GLN   184      54.521  57.145   1.003  1.00 43.67           C  
ATOM   1477  CD  GLN   184      55.464  58.044   1.787  1.00 47.15           C  
ATOM   1478  OE1 GLN   184      56.057  57.632   2.791  1.00 55.62           O  
ATOM   1479  NE2 GLN   184      55.603  59.284   1.334  1.00 61.22           N  
ATOM   1480  N   ALA   185      50.965  54.313   2.632  1.00 27.12           N  
ATOM   1481  CA  ALA   185      50.421  53.199   3.447  1.00 26.49           C  
ATOM   1482  C   ALA   185      50.296  51.947   2.601  1.00 23.37           C  
ATOM   1483  O   ALA   185      49.831  52.000   1.454  1.00 26.33           O  
ATOM   1484  CB  ALA   185      49.064  53.550   4.049  1.00 22.77           C  
ATOM   1485  N   ILE   186      50.731  50.817   3.148  1.00 19.54           N  
ATOM   1486  CA  ILE   186      50.664  49.592   2.367  1.00 18.61           C  
ATOM   1487  C   ILE   186      49.586  48.655   2.902  1.00 19.53           C  
ATOM   1488  O   ILE   186      49.412  48.540   4.122  1.00 18.61           O  
ATOM   1489  CB  ILE   186      52.028  48.867   2.298  1.00 25.65           C  
ATOM   1490  CG1 ILE   186      52.474  48.403   3.664  1.00 23.08           C  
ATOM   1491  CG2 ILE   186      53.119  49.766   1.611  1.00 32.33           C  
ATOM   1492  CD1 ILE   186      53.373  47.159   3.562  1.00 23.38           C  
ATOM   1493  N   PRO   187      48.855  47.988   1.999  1.00 21.38           N  
ATOM   1494  CA  PRO   187      47.867  47.043   2.502  1.00 15.78           C  
ATOM   1495  C   PRO   187      48.569  45.828   3.087  1.00 20.47           C  
ATOM   1496  O   PRO   187      49.607  45.439   2.576  1.00 16.31           O  
ATOM   1497  CB  PRO   187      47.064  46.657   1.256  1.00 17.27           C  
ATOM   1498  CG  PRO   187      47.952  46.981   0.098  1.00 20.64           C  
ATOM   1499  CD  PRO   187      48.888  48.061   0.519  1.00 18.84           C  
ATOM   1500  N   VAL   188      48.046  45.287   4.183  1.00 18.73           N  
ATOM   1501  CA  VAL   188      48.744  44.218   4.909  1.00 16.69           C  
ATOM   1502  C   VAL   188      47.866  43.014   5.242  1.00 18.23           C  
ATOM   1503  O   VAL   188      48.310  42.075   5.917  1.00 21.16           O  
ATOM   1504  CB  VAL   188      49.437  44.737   6.215  1.00 19.46           C  
ATOM   1505  CG1 VAL   188      50.608  45.617   5.888  1.00 19.96           C  
ATOM   1506  CG2 VAL   188      48.436  45.460   7.141  1.00 15.01           C  
ATOM   1507  N   GLY   189      46.614  43.047   4.783  1.00 16.49           N  
ATOM   1508  CA  GLY   189      45.738  41.913   5.015  1.00 18.91           C  
ATOM   1509  C   GLY   189      44.371  42.407   5.404  1.00 18.87           C  
ATOM   1510  O   GLY   189      44.031  43.575   5.182  1.00 19.08           O  
ATOM   1511  N   ALA   190      43.588  41.519   5.986  1.00 16.54           N  
ATOM   1512  CA  ALA   190      42.232  41.863   6.412  1.00 20.59           C  
ATOM   1513  C   ALA   190      41.818  41.013   7.596  1.00 22.26           C  
ATOM   1514  O   ALA   190      42.310  39.908   7.782  1.00 22.93           O  
ATOM   1515  CB  ALA   190      41.193  41.719   5.252  1.00 17.91           C  
ATOM   1516  N   ILE   191      40.876  41.527   8.372  1.00 18.64           N  
ATOM   1517  CA  ILE   191      40.209  40.733   9.408  1.00 18.43           C  
ATOM   1518  C   ILE   191      38.742  40.564   9.089  1.00 21.37           C  
ATOM   1519  O   ILE   191      38.120  41.492   8.588  1.00 17.81           O  
ATOM   1520  CB  ILE   191      40.403  41.440  10.771  1.00 18.60           C  
ATOM   1521  CG1 ILE   191      41.794  41.129  11.305  1.00 22.38           C  
ATOM   1522  CG2 ILE   191      39.357  41.046  11.813  1.00 22.58           C  
ATOM   1523  CD1 ILE   191      42.241  42.201  12.244  1.00 27.81           C  
ATOM   1524  N   THR   192      38.193  39.370   9.332  1.00 16.15           N  
ATOM   1525  CA  THR   192      36.762  39.137   9.160  0.50 18.17           C  
ATOM   1527  C   THR   192      36.165  38.562  10.457  1.00 22.84           C  
ATOM   1528  O   THR   192      36.755  37.666  11.076  1.00 19.70           O  
ATOM   1529  CB  THR   192      36.505  38.231   7.926  0.50 23.49           C  
ATOM   1531  OG1 THR   192      36.932  38.911   6.737  0.50 21.60           O  
ATOM   1533  CG2 THR   192      35.053  37.898   7.769  0.50 12.87           C  
ATOM   1535  N   TYR   193      35.003  39.065  10.863  1.00 16.92           N  
ATOM   1536  CA  TYR   193      34.320  38.490  12.035  1.00 16.58           C  
ATOM   1537  C   TYR   193      32.832  38.520  11.779  1.00 20.59           C  
ATOM   1538  O   TYR   193      32.369  39.156  10.815  1.00 17.01           O  
ATOM   1539  CB  TYR   193      34.676  39.237  13.327  1.00 18.38           C  
ATOM   1540  CG  TYR   193      34.347  40.713  13.291  1.00 15.91           C  
ATOM   1541  CD1 TYR   193      33.058  41.166  13.568  1.00 20.25           C  
ATOM   1542  CD2 TYR   193      35.328  41.646  12.962  1.00 20.34           C  
ATOM   1543  CE1 TYR   193      32.761  42.513  13.536  1.00 20.52           C  
ATOM   1544  CE2 TYR   193      35.040  43.000  12.920  1.00 19.27           C  
ATOM   1545  CZ  TYR   193      33.755  43.418  13.219  1.00 16.20           C  
ATOM   1546  OH  TYR   193      33.448  44.772  13.151  1.00 20.98           O  
ATOM   1547  N   CYS   194      32.082  37.834  12.631  1.00 17.08           N  
ATOM   1548  CA  CYS   194      30.631  37.908  12.541  1.00 22.60           C  
ATOM   1549  C   CYS   194      30.028  37.871  13.931  1.00 22.09           C  
ATOM   1550  O   CYS   194      30.080  36.838  14.620  1.00 18.58           O  
ATOM   1551  CB  CYS   194      30.050  36.795  11.661  1.00 20.95           C  
ATOM   1552  SG  CYS   194      28.234  36.914  11.524  1.00 23.38           S  
ATOM   1553  N   MET   195      29.462  38.998  14.343  1.00 17.69           N  
ATOM   1554  CA  MET   195      28.851  39.085  15.673  1.00 18.41           C  
ATOM   1555  C   MET   195      27.433  39.597  15.665  1.00 20.71           C  
ATOM   1556  O   MET   195      27.045  40.381  14.778  1.00 20.17           O  
ATOM   1557  CB  MET   195      29.698  39.933  16.620  1.00 18.74           C  
ATOM   1558  CG  MET   195      29.772  41.398  16.224  1.00 25.25           C  
ATOM   1559  SD  MET   195      30.880  42.412  17.429  0.70 30.47          SE  
ATOM   1560  CE  MET   195      30.018  41.990  19.031  1.00 22.83           C  
ATOM   1561  N   GLU   196      26.663  39.172  16.666  1.00 20.84           N  
ATOM   1562  CA  GLU   196      25.352  39.749  16.911  1.00 21.64           C  
ATOM   1563  C   GLU   196      25.582  41.092  17.613  1.00 22.83           C  
ATOM   1564  O   GLU   196      26.303  41.181  18.614  1.00 20.50           O  
ATOM   1565  CB  GLU   196      24.470  38.823  17.761  1.00 21.99           C  
ATOM   1566  CG  GLU   196      23.072  39.424  17.999  1.00 28.14           C  
ATOM   1567  CD  GLU   196      22.005  38.428  18.472  1.00 27.63           C  
ATOM   1568  OE1 GLU   196      22.157  37.202  18.283  1.00 27.80           O  
ATOM   1569  OE2 GLU   196      20.982  38.917  19.004  1.00 38.54           O  
ATOM   1570  N   SER   197      24.962  42.137  17.088  1.00 20.19           N  
ATOM   1571  CA  SER   197      25.125  43.478  17.619  1.00 15.72           C  
ATOM   1572  C   SER   197      23.742  43.912  18.167  1.00 19.33           C  
ATOM   1573  O   SER   197      22.786  43.161  18.009  1.00 18.28           O  
ATOM   1574  CB  SER   197      25.552  44.410  16.490  1.00 18.24           C  
ATOM   1575  OG  SER   197      24.526  44.513  15.506  1.00 20.58           O  
ATOM   1576  N   PRO   198      23.651  45.084  18.836  1.00 19.82           N  
ATOM   1577  CA  PRO   198      22.353  45.521  19.391  1.00 25.01           C  
ATOM   1578  C   PRO   198      21.172  45.509  18.409  1.00 27.78           C  
ATOM   1579  O   PRO   198      20.049  45.138  18.784  1.00 27.26           O  
ATOM   1580  CB  PRO   198      22.640  46.948  19.858  1.00 21.66           C  
ATOM   1581  CG  PRO   198      24.110  46.942  20.199  1.00 25.92           C  
ATOM   1582  CD  PRO   198      24.735  46.026  19.187  1.00 21.79           C  
ATOM   1583  N   ALA   199      21.424  45.881  17.158  1.00 21.66           N  
ATOM   1584  CA  ALA   199      20.334  46.028  16.176  1.00 20.92           C  
ATOM   1585  C   ALA   199      20.302  44.928  15.105  1.00 27.82           C  
ATOM   1586  O   ALA   199      19.410  44.909  14.244  1.00 27.25           O  
ATOM   1587  CB  ALA   199      20.406  47.399  15.539  1.00 23.88           C  
ATOM   1588  N   GLY   200      21.269  44.016  15.139  1.00 21.47           N  
ATOM   1589  CA  GLY   200      21.257  42.919  14.178  1.00 20.08           C  
ATOM   1590  C   GLY   200      22.517  42.076  14.199  1.00 23.27           C  
ATOM   1591  O   GLY   200      22.938  41.612  15.250  1.00 23.02           O  
ATOM   1592  N   ILE   201      23.078  41.891  13.011  1.00 19.61           N  
ATOM   1593  CA  ILE   201      24.189  40.982  12.725  0.50 20.79           C  
ATOM   1595  C   ILE   201      25.253  41.788  11.991  1.00 21.52           C  
ATOM   1596  O   ILE   201      24.917  42.492  11.034  1.00 19.17           O  
ATOM   1597  CB  ILE   201      23.712  39.817  11.789  0.50 19.77           C  
ATOM   1599  CG1 ILE   201      22.825  38.828  12.545  0.50 23.67           C  
ATOM   1601  CG2 ILE   201      24.901  39.052  11.128  0.50 23.88           C  
ATOM   1603  CD1 ILE   201      23.586  37.842  13.400  0.50 30.69           C  
ATOM   1605  N   LYS   202      26.513  41.644  12.395  1.00 17.46           N  
ATOM   1606  CA  LYS   202      27.615  42.393  11.804  1.00 16.91           C  
ATOM   1607  C   LYS   202      28.686  41.412  11.283  1.00 19.03           C  
ATOM   1608  O   LYS   202      29.577  41.041  12.051  1.00 17.60           O  
ATOM   1609  CB  LYS   202      28.244  43.287  12.861  1.00 19.47           C  
ATOM   1610  CG  LYS   202      27.405  44.510  13.236  1.00 15.46           C  
ATOM   1611  CD  LYS   202      28.072  45.440  14.221  1.00 22.65           C  
ATOM   1612  CE  LYS   202      29.321  46.142  13.706  1.00 24.43           C  
ATOM   1613  NZ  LYS   202      29.066  47.055  12.516  1.00 27.31           N  
ATOM   1614  N   PRO   203      28.593  41.006   9.994  1.00 16.72           N  
ATOM   1615  CA  PRO   203      29.596  40.167   9.326  1.00 17.50           C  
ATOM   1616  C   PRO   203      30.545  41.129   8.652  1.00 18.96           C  
ATOM   1617  O   PRO   203      30.338  41.527   7.498  1.00 22.69           O  
ATOM   1618  CB  PRO   203      28.772  39.361   8.315  1.00 23.12           C  
ATOM   1619  CG  PRO   203      27.382  40.061   8.235  1.00 20.40           C  
ATOM   1620  CD  PRO   203      27.492  41.331   9.070  1.00 16.33           C  
ATOM   1621  N   ASP   204      31.554  41.558   9.391  1.00 14.49           N  
ATOM   1622  CA  ASP   204      32.398  42.684   8.939  1.00 18.90           C  
ATOM   1623  C   ASP   204      33.757  42.241   8.446  1.00 19.68           C  
ATOM   1624  O   ASP   204      34.325  41.264   8.944  1.00 19.53           O  
ATOM   1625  CB  ASP   204      32.610  43.701  10.053  1.00 17.03           C  
ATOM   1626  CG  ASP   204      31.314  44.405  10.487  1.00 21.45           C  
ATOM   1627  OD1 ASP   204      30.277  44.283   9.809  1.00 24.51           O  
ATOM   1628  OD2 ASP   204      31.358  45.071  11.528  1.00 25.88           O  
ATOM   1629  N   THR   205      34.267  42.983   7.469  1.00 16.49           N  
ATOM   1630  CA  THR   205      35.645  42.835   6.979  1.00 18.97           C  
ATOM   1631  C   THR   205      36.391  44.138   7.145  1.00 22.03           C  
ATOM   1632  O   THR   205      35.931  45.179   6.680  1.00 20.97           O  
ATOM   1633  CB  THR   205      35.650  42.381   5.527  1.00 20.97           C  
ATOM   1634  OG1 THR   205      35.084  41.066   5.454  1.00 18.93           O  
ATOM   1635  CG2 THR   205      37.050  42.330   4.966  1.00 18.62           C  
ATOM   1636  N   LEU   206      37.530  44.089   7.834  1.00 17.58           N  
ATOM   1637  CA  LEU   206      38.394  45.264   8.026  1.00 17.07           C  
ATOM   1638  C   LEU   206      39.632  45.098   7.186  1.00 19.34           C  
ATOM   1639  O   LEU   206      40.434  44.205   7.447  1.00 19.57           O  
ATOM   1640  CB  LEU   206      38.815  45.454   9.519  1.00 19.70           C  
ATOM   1641  CG  LEU   206      37.830  45.184  10.672  1.00 30.19           C  
ATOM   1642  CD1 LEU   206      38.456  45.413  12.051  1.00 30.63           C  
ATOM   1643  CD2 LEU   206      36.637  46.012  10.534  1.00 34.18           C  
ATOM   1644  N   PHE   207      39.797  45.960   6.190  1.00 15.14           N  
ATOM   1645  CA  PHE   207      41.012  45.982   5.403  1.00 14.18           C  
ATOM   1646  C   PHE   207      42.077  46.767   6.142  1.00 15.69           C  
ATOM   1647  O   PHE   207      41.870  47.911   6.555  1.00 19.26           O  
ATOM   1648  CB  PHE   207      40.737  46.514   3.988  1.00 15.92           C  
ATOM   1649  CG  PHE   207      39.840  45.607   3.185  1.00 19.36           C  
ATOM   1650  CD1 PHE   207      40.348  44.442   2.573  1.00 17.29           C  
ATOM   1651  CD2 PHE   207      38.484  45.899   3.052  1.00 16.61           C  
ATOM   1652  CE1 PHE   207      39.502  43.583   1.817  1.00 15.95           C  
ATOM   1653  CE2 PHE   207      37.653  45.048   2.310  1.00 18.64           C  
ATOM   1654  CZ  PHE   207      38.160  43.894   1.703  1.00 21.53           C  
ATOM   1655  N   LEU   208      43.247  46.163   6.259  1.00 16.02           N  
ATOM   1656  CA  LEU   208      44.265  46.699   7.147  1.00 16.18           C  
ATOM   1657  C   LEU   208      45.422  47.286   6.362  1.00 15.99           C  
ATOM   1658  O   LEU   208      45.801  46.761   5.317  1.00 17.80           O  
ATOM   1659  CB  LEU   208      44.773  45.584   8.056  1.00 17.30           C  
ATOM   1660  CG  LEU   208      43.666  44.740   8.702  1.00 21.82           C  
ATOM   1661  CD1 LEU   208      44.249  43.562   9.423  1.00 24.62           C  
ATOM   1662  CD2 LEU   208      42.840  45.588   9.656  1.00 21.41           C  
ATOM   1663  N   TYR   209      45.954  48.390   6.877  1.00 16.64           N  
ATOM   1664  CA  TYR   209      47.074  49.114   6.254  1.00 13.20           C  
ATOM   1665  C   TYR   209      48.103  49.478   7.319  1.00 18.91           C  
ATOM   1666  O   TYR   209      47.733  49.720   8.469  1.00 17.11           O  
ATOM   1667  CB  TYR   209      46.541  50.406   5.583  1.00 19.14           C  
ATOM   1668  CG  TYR   209      45.645  50.126   4.407  1.00 14.54           C  
ATOM   1669  CD1 TYR   209      46.130  50.167   3.107  1.00 16.75           C  
ATOM   1670  CD2 TYR   209      44.278  49.801   4.595  1.00 21.68           C  
ATOM   1671  CE1 TYR   209      45.281  49.903   1.991  1.00 21.68           C  
ATOM   1672  CE2 TYR   209      43.439  49.519   3.496  1.00 21.31           C  
ATOM   1673  CZ  TYR   209      43.959  49.570   2.209  1.00 20.17           C  
ATOM   1674  OH  TYR   209      43.129  49.283   1.152  1.00 21.68           O  
ATOM   1675  N   ASP   210      49.384  49.472   6.942  1.00 17.51           N  
ATOM   1676  CA  ASP   210      50.474  49.899   7.816  1.00 20.05           C  
ATOM   1677  C   ASP   210      51.129  51.115   7.175  1.00 19.12           C  
ATOM   1678  O   ASP   210      51.344  51.150   5.939  1.00 21.30           O  
ATOM   1679  CB  ASP   210      51.578  48.821   7.908  1.00 17.73           C  
ATOM   1680  CG  ASP   210      51.330  47.777   8.969  1.00 23.66           C  
ATOM   1681  OD1 ASP   210      50.234  47.740   9.580  1.00 19.71           O  
ATOM   1682  OD2 ASP   210      52.246  46.941   9.154  1.00 19.66           O  
ATOM   1683  N   LEU   211      51.483  52.081   8.014  1.00 21.44           N  
ATOM   1684  CA  LEU   211      52.293  53.218   7.583  1.00 19.60           C  
ATOM   1685  C   LEU   211      53.371  53.590   8.618  1.00 28.52           C  
ATOM   1686  O   LEU   211      53.047  53.917   9.773  1.00 25.01           O  
ATOM   1687  CB  LEU   211      51.396  54.433   7.289  1.00 21.33           C  
ATOM   1688  CG  LEU   211      52.079  55.711   6.778  1.00 23.75           C  
ATOM   1689  CD1 LEU   211      52.892  55.427   5.515  1.00 28.56           C  
ATOM   1690  CD2 LEU   211      51.050  56.768   6.486  1.00 21.28           C  
ATOM   1691  N   ALA   212      54.636  53.535   8.184  1.00 24.81           N  
ATOM   1692  CA  ALA   212      55.787  54.018   8.964  1.00 29.85           C  
ATOM   1693  C   ALA   212      55.828  55.527   8.798  1.00 29.57           C  
ATOM   1694  O   ALA   212      56.058  56.036   7.697  1.00 32.92           O  
ATOM   1695  CB  ALA   212      57.068  53.405   8.459  1.00 27.38           C  
ATOM   1696  N   LEU   213      55.551  56.239   9.876  1.00 25.42           N  
ATOM   1697  CA  LEU   213      55.416  57.697   9.832  1.00 25.21           C  
ATOM   1698  C   LEU   213      56.746  58.407  10.143  1.00 33.84           C  
ATOM   1699  O   LEU   213      57.605  57.834  10.822  1.00 36.56           O  
ATOM   1700  CB  LEU   213      54.344  58.147  10.814  1.00 25.79           C  
ATOM   1701  CG  LEU   213      52.903  57.810  10.408  1.00 27.39           C  
ATOM   1702  CD1 LEU   213      51.998  57.831  11.609  1.00 22.21           C  
ATOM   1703  CD2 LEU   213      52.419  58.783   9.358  1.00 32.76           C  
ATOM   1704  N   PRO   214      56.921  59.654   9.646  1.00 36.16           N  
ATOM   1705  CA  PRO   214      58.100  60.427  10.057  1.00 39.31           C  
ATOM   1706  C   PRO   214      58.066  60.728  11.559  1.00 34.96           C  
ATOM   1707  O   PRO   214      56.983  60.938  12.125  1.00 32.07           O  
ATOM   1708  CB  PRO   214      57.956  61.741   9.269  1.00 37.83           C  
ATOM   1709  CG  PRO   214      57.019  61.437   8.155  1.00 42.05           C  
ATOM   1710  CD  PRO   214      56.072  60.421   8.720  1.00 34.03           C  
ATOM   1711  N   GLU   215      59.244  60.772  12.182  1.00 38.88           N  
ATOM   1712  CA  GLU   215      59.400  61.115  13.605  1.00 42.52           C  
ATOM   1713  C   GLU   215      58.699  62.427  13.981  1.00 40.78           C  
ATOM   1714  O   GLU   215      58.184  62.559  15.092  1.00 41.45           O  
ATOM   1715  CB  GLU   215      60.889  61.205  13.984  1.00 47.40           C  
ATOM   1716  CG  GLU   215      61.675  59.879  13.903  1.00 61.85           C  
ATOM   1717  CD  GLU   215      61.590  59.037  15.173  1.00 71.62           C  
ATOM   1718  OE1 GLU   215      61.330  59.612  16.254  1.00 77.66           O  
ATOM   1719  OE2 GLU   215      61.789  57.799  15.091  1.00 66.95           O  
ATOM   1720  N   ASP   216      58.667  63.374  13.043  1.00 40.78           N  
ATOM   1721  CA  ASP   216      58.096  64.696  13.291  1.00 42.30           C  
ATOM   1722  C   ASP   216      56.617  64.850  12.910  1.00 42.05           C  
ATOM   1723  O   ASP   216      56.042  65.911  13.149  1.00 40.61           O  
ATOM   1724  CB  ASP   216      58.958  65.813  12.665  1.00 47.09           C  
ATOM   1725  CG  ASP   216      58.932  65.811  11.131  1.00 58.78           C  
ATOM   1726  OD1 ASP   216      58.804  64.731  10.514  1.00 70.12           O  
ATOM   1727  OD2 ASP   216      59.056  66.903  10.535  1.00 58.84           O  
ATOM   1728  N   PHE   217      55.990  63.813  12.342  1.00 33.84           N  
ATOM   1729  CA  PHE   217      54.531  63.879  12.124  1.00 28.76           C  
ATOM   1730  C   PHE   217      53.736  63.857  13.447  1.00 28.64           C  
ATOM   1731  O   PHE   217      54.063  63.107  14.375  1.00 33.24           O  
ATOM   1732  CB  PHE   217      54.032  62.756  11.171  1.00 31.39           C  
ATOM   1733  CG  PHE   217      52.537  62.770  10.970  1.00 34.89           C  
ATOM   1734  CD1 PHE   217      51.953  63.682  10.090  1.00 31.80           C  
ATOM   1735  CD2 PHE   217      51.708  61.919  11.707  1.00 30.13           C  
ATOM   1736  CE1 PHE   217      50.574  63.734   9.928  1.00 35.26           C  
ATOM   1737  CE2 PHE   217      50.343  61.968  11.554  1.00 26.65           C  
ATOM   1738  CZ  PHE   217      49.767  62.879  10.664  1.00 30.87           C  
ATOM   1739  N   ARG   218      52.701  64.691  13.531  1.00 30.24           N  
ATOM   1740  CA  ARG   218      51.765  64.675  14.649  1.00 33.07           C  
ATOM   1741  C   ARG   218      50.362  64.664  14.087  1.00 33.27           C  
ATOM   1742  O   ARG   218      50.005  65.570  13.349  1.00 30.02           O  
ATOM   1743  CB  ARG   218      51.913  65.918  15.548  1.00 36.17           C  
ATOM   1744  CG  ARG   218      53.292  66.156  16.149  1.00 38.66           C  
ATOM   1745  CD  ARG   218      53.636  65.164  17.279  1.00 44.01           C  
ATOM   1746  NE  ARG   218      54.971  65.428  17.825  1.00 50.41           N  
ATOM   1747  CZ  ARG   218      56.105  64.916  17.348  1.00 48.17           C  
ATOM   1748  NH1 ARG   218      56.091  64.081  16.319  1.00 53.09           N  
ATOM   1749  NH2 ARG   218      57.263  65.226  17.916  1.00 52.78           N  
ATOM   1750  N   PRO   219      49.551  63.642  14.425  1.00 32.18           N  
ATOM   1751  CA  PRO   219      48.154  63.704  13.986  1.00 28.77           C  
ATOM   1752  C   PRO   219      47.327  64.817  14.674  1.00 35.00           C  
ATOM   1753  O   PRO   219      47.516  65.087  15.867  1.00 35.22           O  
ATOM   1754  CB  PRO   219      47.602  62.299  14.338  1.00 26.16           C  
ATOM   1755  CG  PRO   219      48.499  61.797  15.400  1.00 29.84           C  
ATOM   1756  CD  PRO   219      49.859  62.389  15.144  1.00 29.45           C  
ATOM   1757  N   HIS   220      46.438  65.469  13.920  1.00 30.48           N  
ATOM   1758  CA  HIS   220      45.476  66.413  14.512  1.00 32.09           C  
ATOM   1759  C   HIS   220      44.077  66.058  14.111  1.00 30.14           C  
ATOM   1760  O   HIS   220      43.835  65.693  12.971  1.00 30.55           O  
ATOM   1761  CB  HIS   220      45.781  67.860  14.106  1.00 37.92           C  
ATOM   1762  CG  HIS   220      47.209  68.246  14.322  1.00 41.04           C  
ATOM   1763  ND1 HIS   220      48.122  68.330  13.293  1.00 50.01           N  
ATOM   1764  CD2 HIS   220      47.894  68.530  15.457  1.00 45.11           C  
ATOM   1765  CE1 HIS   220      49.305  68.660  13.781  1.00 40.41           C  
ATOM   1766  NE2 HIS   220      49.194  68.786  15.092  1.00 44.64           N  
ATOM   1767  N   ASN   221      43.153  66.229  15.047  1.00 25.59           N  
ATOM   1768  CA  ASN   221      41.767  65.783  14.921  1.00 31.42           C  
ATOM   1769  C   ASN   221      40.854  66.733  14.118  1.00 34.72           C  
ATOM   1770  O   ASN   221      39.805  67.183  14.617  1.00 40.74           O  
ATOM   1771  CB  ASN   221      41.192  65.500  16.330  1.00 32.04           C  
ATOM   1772  CG  ASN   221      41.034  66.778  17.195  1.00 41.90           C  
ATOM   1773  OD1 ASN   221      41.773  67.752  17.028  1.00 42.49           O  
ATOM   1774  ND2 ASN   221      40.056  66.768  18.105  1.00 30.00           N  
ATOM   1775  N   THR   222      41.229  66.990  12.866  1.00 34.65           N  
ATOM   1776  CA  THR   222      40.516  67.939  11.978  1.00 37.42           C  
ATOM   1777  C   THR   222      38.978  67.898  12.029  1.00 39.37           C  
ATOM   1778  O   THR   222      38.344  68.925  12.252  1.00 40.20           O  
ATOM   1779  CB  THR   222      41.007  67.833  10.506  1.00 40.30           C  
ATOM   1780  OG1 THR   222      42.441  67.862  10.475  1.00 38.41           O  
ATOM   1781  CG2 THR   222      40.467  68.991   9.654  1.00 37.82           C  
ATOM   1782  N   ASP   223      38.375  66.725  11.856  1.00 33.08           N  
ATOM   1783  CA  ASP   223      36.914  66.646  11.873  1.00 36.16           C  
ATOM   1784  C   ASP   223      36.279  66.357  13.243  1.00 36.45           C  
ATOM   1785  O   ASP   223      35.053  66.241  13.343  1.00 38.37           O  
ATOM   1786  CB  ASP   223      36.392  65.690  10.786  1.00 37.98           C  
ATOM   1787  CG  ASP   223      36.618  64.223  11.118  1.00 42.50           C  
ATOM   1788  OD1 ASP   223      37.293  63.886  12.122  1.00 34.80           O  
ATOM   1789  OD2 ASP   223      36.106  63.402  10.344  1.00 36.90           O  
ATOM   1790  N   GLY   224      37.111  66.244  14.282  1.00 35.55           N  
ATOM   1791  CA  GLY   224      36.630  66.034  15.654  1.00 36.89           C  
ATOM   1792  C   GLY   224      36.020  64.671  15.976  1.00 36.39           C  
ATOM   1793  O   GLY   224      35.449  64.482  17.054  1.00 40.38           O  
ATOM   1794  N   GLU   225      36.125  63.723  15.042  1.00 32.74           N  
ATOM   1795  CA  GLU   225      35.722  62.336  15.276  1.00 33.39           C  
ATOM   1796  C   GLU   225      36.597  61.697  16.367  1.00 31.95           C  
ATOM   1797  O   GLU   225      36.143  60.836  17.113  1.00 26.70           O  
ATOM   1798  CB  GLU   225      35.884  61.520  13.996  1.00 34.72           C  
ATOM   1799  CG  GLU   225      34.769  61.677  12.971  1.00 35.77           C  
ATOM   1800  CD  GLU   225      34.913  60.657  11.831  1.00 48.02           C  
ATOM   1801  OE1 GLU   225      34.275  59.583  11.894  1.00 36.79           O  
ATOM   1802  OE2 GLU   225      35.692  60.911  10.885  1.00 46.05           O  
ATOM   1803  N   MET   226      37.861  62.104  16.409  1.00 30.60           N  
ATOM   1804  CA  MET   226      38.780  61.764  17.497  1.00 33.62           C  
ATOM   1805  C   MET   226      38.879  62.927  18.495  1.00 35.35           C  
ATOM   1806  O   MET   226      39.017  64.078  18.089  1.00 34.95           O  
ATOM   1807  CB  MET   226      40.182  61.499  16.949  1.00 30.26           C  
ATOM   1808  CG  MET   226      40.305  60.311  16.011  1.00 38.22           C  
ATOM   1809  SD  MET   226      39.791  58.599  16.819  0.70 33.77          SE  
ATOM   1810  CE  MET   226      40.212  57.510  15.238  1.00 43.66           C  
ATOM   1811  N   ALA   227      38.835  62.611  19.788  1.00 30.11           N  
ATOM   1812  CA  ALA   227      39.070  63.585  20.851  1.00 30.34           C  
ATOM   1813  C   ALA   227      40.531  64.052  20.907  1.00 38.31           C  
ATOM   1814  O   ALA   227      40.797  65.253  21.065  1.00 39.38           O  
ATOM   1815  CB  ALA   227      38.624  63.028  22.201  1.00 32.23           C  
ATOM   1816  N   ASP   228      41.459  63.100  20.764  1.00 29.95           N  
ATOM   1817  CA  ASP   228      42.897  63.383  20.736  0.50 32.07           C  
ATOM   1819  C   ASP   228      43.640  62.133  20.291  1.00 31.14           C  
ATOM   1820  O   ASP   228      43.016  61.111  19.979  1.00 30.62           O  
ATOM   1821  CB  ASP   228      43.422  63.840  22.108  0.50 37.97           C  
ATOM   1823  CG  ASP   228      43.307  62.764  23.162  0.50 37.14           C  
ATOM   1825  OD1 ASP   228      42.167  62.425  23.532  0.50 39.67           O  
ATOM   1827  OD2 ASP   228      44.356  62.264  23.619  0.50 48.07           O  
ATOM   1829  N   PHE   229      44.961  62.237  20.221  1.00 23.57           N  
ATOM   1830  CA  PHE   229      45.842  61.157  19.805  1.00 28.22           C  
ATOM   1831  C   PHE   229      46.978  60.986  20.814  1.00 32.28           C  
ATOM   1832  O   PHE   229      47.356  61.956  21.464  1.00 29.69           O  
ATOM   1833  CB  PHE   229      46.454  61.481  18.450  1.00 27.21           C  
ATOM   1834  CG  PHE   229      45.462  61.500  17.324  1.00 28.89           C  
ATOM   1835  CD1 PHE   229      45.107  60.316  16.674  1.00 25.77           C  
ATOM   1836  CD2 PHE   229      44.905  62.698  16.895  1.00 29.22           C  
ATOM   1837  CE1 PHE   229      44.203  60.321  15.640  1.00 25.83           C  
ATOM   1838  CE2 PHE   229      43.985  62.718  15.846  1.00 29.84           C  
ATOM   1839  CZ  PHE   229      43.626  61.523  15.225  1.00 23.27           C  
ATOM   1840  N   MET   230      47.504  59.761  20.943  1.00 30.54           N  
ATOM   1841  CA  MET   230      48.633  59.475  21.839  0.50 31.97           C  
ATOM   1843  C   MET   230      49.613  58.548  21.148  1.00 32.95           C  
ATOM   1844  O   MET   230      49.212  57.668  20.384  1.00 30.38           O  
ATOM   1845  CB  MET   230      48.170  58.804  23.139  0.50 29.98           C  
ATOM   1847  CG  MET   230      47.326  59.655  24.086  0.50 30.10           C  
ATOM   1849  SD  MET   230      46.461  58.547  25.462  0.35 35.81          SE  
ATOM   1851  CE  MET   230      45.786  57.198  24.278  0.50  9.41           C  
ATOM   1853  N   LEU   231      50.903  58.740  21.417  1.00 26.63           N  
ATOM   1854  CA  LEU   231      51.928  57.875  20.870  1.00 24.90           C  
ATOM   1855  C   LEU   231      52.402  56.944  21.983  1.00 32.60           C  
ATOM   1856  O   LEU   231      52.984  57.400  22.973  1.00 27.40           O  
ATOM   1857  CB  LEU   231      53.092  58.697  20.318  1.00 22.14           C  
ATOM   1858  CG  LEU   231      54.213  57.917  19.627  1.00 27.92           C  
ATOM   1859  CD1 LEU   231      53.690  57.195  18.374  1.00 31.77           C  
ATOM   1860  CD2 LEU   231      55.354  58.858  19.235  1.00 34.90           C  
ATOM   1861  N   TRP   232      52.153  55.643  21.825  1.00 26.63           N  
ATOM   1862  CA  TRP   232      52.468  54.657  22.873  1.00 27.49           C  
ATOM   1863  C   TRP   232      53.463  53.641  22.351  1.00 24.44           C  
ATOM   1864  O   TRP   232      53.424  53.335  21.153  1.00 24.35           O  
ATOM   1865  CB  TRP   232      51.214  53.888  23.242  1.00 25.56           C  
ATOM   1866  CG  TRP   232      50.254  54.542  24.163  1.00 33.99           C  
ATOM   1867  CD1 TRP   232      50.243  55.857  24.583  1.00 30.32           C  
ATOM   1868  CD2 TRP   232      49.111  53.920  24.754  1.00 30.78           C  
ATOM   1869  NE1 TRP   232      49.172  56.067  25.416  1.00 28.93           N  
ATOM   1870  CE2 TRP   232      48.459  54.899  25.537  1.00 33.17           C  
ATOM   1871  CE3 TRP   232      48.592  52.611  24.734  1.00 25.26           C  
ATOM   1872  CZ2 TRP   232      47.301  54.615  26.278  1.00 33.10           C  
ATOM   1873  CZ3 TRP   232      47.429  52.341  25.462  1.00 31.07           C  
ATOM   1874  CH2 TRP   232      46.803  53.334  26.220  1.00 29.08           C  
ATOM   1875  N   PRO   233      54.330  53.081  23.229  1.00 25.37           N  
ATOM   1876  CA  PRO   233      55.152  51.969  22.783  1.00 26.06           C  
ATOM   1877  C   PRO   233      54.231  50.848  22.323  1.00 24.38           C  
ATOM   1878  O   PRO   233      53.160  50.647  22.927  1.00 22.96           O  
ATOM   1879  CB  PRO   233      55.902  51.547  24.060  1.00 29.18           C  
ATOM   1880  CG  PRO   233      55.941  52.785  24.901  1.00 28.56           C  
ATOM   1881  CD  PRO   233      54.598  53.424  24.647  1.00 28.32           C  
ATOM   1882  N   ALA   234      54.615  50.163  21.250  1.00 23.20           N  
ATOM   1883  CA  ALA   234      53.779  49.101  20.681  1.00 25.59           C  
ATOM   1884  C   ALA   234      53.388  48.077  21.749  1.00 22.71           C  
ATOM   1885  O   ALA   234      52.225  47.682  21.809  1.00 21.44           O  
ATOM   1886  CB  ALA   234      54.464  48.417  19.496  1.00 27.69           C  
ATOM   1887  N   ALA   235      54.338  47.677  22.603  1.00 25.08           N  
ATOM   1888  CA  ALA   235      54.065  46.687  23.659  1.00 23.69           C  
ATOM   1889  C   ALA   235      52.959  47.126  24.629  1.00 24.83           C  
ATOM   1890  O   ALA   235      52.156  46.305  25.065  1.00 23.63           O  
ATOM   1891  CB  ALA   235      55.343  46.309  24.415  1.00 29.81           C  
ATOM   1892  N   LYS   236      52.898  48.420  24.935  1.00 24.16           N  
ATOM   1893  CA  LYS   236      51.849  48.978  25.790  1.00 27.58           C  
ATOM   1894  C   LYS   236      50.451  48.847  25.143  1.00 21.12           C  
ATOM   1895  O   LYS   236      49.450  48.578  25.825  1.00 22.07           O  
ATOM   1896  CB  LYS   236      52.180  50.448  26.117  1.00 26.72           C  
ATOM   1897  CG  LYS   236      51.190  51.123  27.037  1.00 30.02           C  
ATOM   1898  CD  LYS   236      51.459  52.607  27.212  1.00 37.84           C  
ATOM   1899  CE  LYS   236      50.410  53.245  28.131  1.00 45.71           C  
ATOM   1900  NZ  LYS   236      50.697  54.688  28.391  1.00 44.63           N  
ATOM   1901  N   VAL   237      50.386  49.019  23.816  1.00 21.52           N  
ATOM   1902  CA  VAL   237      49.122  48.858  23.075  1.00 19.23           C  
ATOM   1903  C   VAL   237      48.692  47.392  23.125  1.00 17.87           C  
ATOM   1904  O   VAL   237      47.555  47.073  23.417  1.00 19.86           O  
ATOM   1905  CB  VAL   237      49.262  49.352  21.594  1.00 21.36           C  
ATOM   1906  CG1 VAL   237      47.994  49.054  20.745  1.00 21.80           C  
ATOM   1907  CG2 VAL   237      49.561  50.862  21.578  1.00 19.94           C  
ATOM   1908  N   VAL   238      49.638  46.515  22.828  1.00 15.89           N  
ATOM   1909  CA  VAL   238      49.356  45.083  22.794  1.00 17.55           C  
ATOM   1910  C   VAL   238      48.889  44.625  24.185  1.00 18.38           C  
ATOM   1911  O   VAL   238      47.898  43.906  24.296  1.00 17.12           O  
ATOM   1912  CB  VAL   238      50.579  44.302  22.299  1.00 20.65           C  
ATOM   1913  CG1 VAL   238      50.349  42.779  22.475  1.00 17.40           C  
ATOM   1914  CG2 VAL   238      50.879  44.646  20.838  1.00 22.23           C  
ATOM   1915  N   GLU   239      49.575  45.053  25.254  1.00 20.45           N  
ATOM   1916  CA  GLU   239      49.154  44.644  26.606  1.00 19.51           C  
ATOM   1917  C   GLU   239      47.828  45.270  27.046  1.00 17.58           C  
ATOM   1918  O   GLU   239      47.054  44.633  27.746  1.00 19.73           O  
ATOM   1919  CB  GLU   239      50.231  44.906  27.659  1.00 18.69           C  
ATOM   1920  CG  GLU   239      51.537  44.178  27.372  1.00 18.82           C  
ATOM   1921  CD  GLU   239      51.459  42.647  27.407  1.00 23.22           C  
ATOM   1922  OE1 GLU   239      50.465  42.043  27.875  1.00 29.15           O  
ATOM   1923  OE2 GLU   239      52.440  42.036  26.965  1.00 26.04           O  
ATOM   1924  N   ALA   240      47.560  46.498  26.609  1.00 18.60           N  
ATOM   1925  CA  ALA   240      46.227  47.090  26.833  1.00 18.75           C  
ATOM   1926  C   ALA   240      45.097  46.233  26.209  1.00 21.18           C  
ATOM   1927  O   ALA   240      44.067  46.000  26.831  1.00 17.62           O  
ATOM   1928  CB  ALA   240      46.183  48.550  26.332  1.00 18.84           C  
ATOM   1929  N   VAL   241      45.310  45.713  25.002  1.00 19.17           N  
ATOM   1930  CA  VAL   241      44.324  44.848  24.381  1.00 16.76           C  
ATOM   1931  C   VAL   241      44.267  43.498  25.112  1.00 15.47           C  
ATOM   1932  O   VAL   241      43.178  42.958  25.346  1.00 18.92           O  
ATOM   1933  CB  VAL   241      44.643  44.686  22.855  1.00 20.22           C  
ATOM   1934  CG1 VAL   241      43.787  43.559  22.183  1.00 17.92           C  
ATOM   1935  CG2 VAL   241      44.413  46.033  22.172  1.00 14.08           C  
ATOM   1936  N   ARG   242      45.422  42.960  25.515  1.00 14.46           N  
ATOM   1937  CA  ARG   242      45.425  41.642  26.181  1.00 16.30           C  
ATOM   1938  C   ARG   242      44.592  41.660  27.459  1.00 18.93           C  
ATOM   1939  O   ARG   242      43.795  40.741  27.716  1.00 21.27           O  
ATOM   1940  CB  ARG   242      46.864  41.171  26.494  1.00 15.30           C  
ATOM   1941  CG  ARG   242      46.889  39.763  27.067  1.00 16.78           C  
ATOM   1942  CD  ARG   242      48.226  39.519  27.784  1.00 22.29           C  
ATOM   1943  NE  ARG   242      49.335  39.487  26.843  1.00 20.03           N  
ATOM   1944  CZ  ARG   242      49.637  38.449  26.058  1.00 21.15           C  
ATOM   1945  NH1 ARG   242      48.907  37.328  26.050  1.00 21.56           N  
ATOM   1946  NH2 ARG   242      50.687  38.534  25.272  1.00 19.17           N  
ATOM   1947  N   THR   243      44.715  42.746  28.226  1.00 18.75           N  
ATOM   1948  CA  THR   243      44.213  42.720  29.582  1.00 20.29           C  
ATOM   1949  C   THR   243      43.134  43.725  29.948  1.00 20.77           C  
ATOM   1950  O   THR   243      42.682  43.716  31.088  1.00 20.63           O  
ATOM   1951  CB  THR   243      45.375  42.827  30.613  1.00 23.74           C  
ATOM   1952  OG1 THR   243      46.034  44.069  30.452  1.00 29.54           O  
ATOM   1953  CG2 THR   243      46.376  41.733  30.398  1.00 27.63           C  
ATOM   1954  N   THR   244      42.724  44.592  29.014  1.00 19.31           N  
ATOM   1955  CA  THR   244      41.730  45.624  29.312  1.00 20.53           C  
ATOM   1956  C   THR   244      40.672  45.705  28.197  1.00 24.18           C  
ATOM   1957  O   THR   244      40.803  45.067  27.141  1.00 19.20           O  
ATOM   1958  CB  THR   244      42.349  47.061  29.504  1.00 21.98           C  
ATOM   1959  OG1 THR   244      42.659  47.636  28.232  1.00 20.95           O  
ATOM   1960  CG2 THR   244      43.608  47.072  30.385  1.00 22.52           C  
ATOM   1961  N   GLU   245      39.649  46.532  28.423  1.00 22.28           N  
ATOM   1962  CA  GLU   245      38.659  46.803  27.380  1.00 21.28           C  
ATOM   1963  C   GLU   245      38.762  48.249  26.933  1.00 22.53           C  
ATOM   1964  O   GLU   245      37.759  48.847  26.603  1.00 22.94           O  
ATOM   1965  CB  GLU   245      37.243  46.518  27.900  1.00 25.72           C  
ATOM   1966  CG  GLU   245      37.013  45.108  28.390  1.00 29.04           C  
ATOM   1967  CD  GLU   245      36.556  44.167  27.293  1.00 39.66           C  
ATOM   1968  OE1 GLU   245      36.793  44.438  26.084  1.00 43.88           O  
ATOM   1969  OE2 GLU   245      35.930  43.148  27.639  1.00 34.03           O  
ATOM   1970  N   ALA   246      39.976  48.799  26.936  1.00 18.23           N  
ATOM   1971  CA  ALA   246      40.195  50.198  26.597  1.00 23.71           C  
ATOM   1972  C   ALA   246      39.887  50.482  25.118  1.00 25.82           C  
ATOM   1973  O   ALA   246      39.454  51.582  24.780  1.00 23.44           O  
ATOM   1974  CB  ALA   246      41.633  50.571  26.876  1.00 21.63           C  
ATOM   1975  N   PHE   247      40.124  49.490  24.248  1.00 20.81           N  
ATOM   1976  CA  PHE   247      39.980  49.691  22.795  1.00 20.54           C  
ATOM   1977  C   PHE   247      38.572  49.387  22.298  1.00 21.57           C  
ATOM   1978  O   PHE   247      37.861  48.501  22.835  1.00 21.62           O  
ATOM   1979  CB  PHE   247      41.037  48.883  22.019  1.00 17.15           C  
ATOM   1980  CG  PHE   247      42.407  49.520  22.021  1.00 24.57           C  
ATOM   1981  CD1 PHE   247      42.832  50.293  20.932  1.00 22.20           C  
ATOM   1982  CD2 PHE   247      43.256  49.386  23.128  1.00 20.78           C  
ATOM   1983  CE1 PHE   247      44.094  50.901  20.935  1.00 24.41           C  
ATOM   1984  CE2 PHE   247      44.516  49.983  23.134  1.00 24.91           C  
ATOM   1985  CZ  PHE   247      44.928  50.753  22.045  1.00 21.88           C  
ATOM   1986  N   LYS   248      38.157  50.113  21.258  1.00 19.66           N  
ATOM   1987  CA  LYS   248      36.895  49.781  20.572  1.00 15.71           C  
ATOM   1988  C   LYS   248      36.908  48.307  20.192  1.00 17.36           C  
ATOM   1989  O   LYS   248      37.957  47.775  19.831  1.00 16.16           O  
ATOM   1990  CB  LYS   248      36.785  50.665  19.313  1.00 20.31           C  
ATOM   1991  CG  LYS   248      35.653  50.308  18.350  1.00 19.58           C  
ATOM   1992  CD  LYS   248      35.383  51.525  17.446  1.00 20.79           C  
ATOM   1993  CE  LYS   248      34.446  51.169  16.277  1.00 19.70           C  
ATOM   1994  NZ  LYS   248      35.252  50.527  15.166  1.00 22.92           N  
ATOM   1995  N   PHE   249      35.758  47.644  20.279  1.00 16.33           N  
ATOM   1996  CA  PHE   249      35.678  46.156  20.219  1.00 16.95           C  
ATOM   1997  C   PHE   249      36.470  45.499  19.069  1.00 17.92           C  
ATOM   1998  O   PHE   249      37.251  44.547  19.278  1.00 20.40           O  
ATOM   1999  CB  PHE   249      34.203  45.693  20.232  1.00 17.22           C  
ATOM   2000  CG  PHE   249      33.419  46.084  18.995  1.00 27.57           C  
ATOM   2001  CD1 PHE   249      33.226  45.166  17.948  1.00 23.89           C  
ATOM   2002  CD2 PHE   249      32.841  47.348  18.884  1.00 34.84           C  
ATOM   2003  CE1 PHE   249      32.526  45.533  16.794  1.00 24.40           C  
ATOM   2004  CE2 PHE   249      32.121  47.707  17.741  1.00 29.75           C  
ATOM   2005  CZ  PHE   249      31.971  46.811  16.697  1.00 29.91           C  
ATOM   2006  N   ASN   250      36.319  46.021  17.857  1.00 17.89           N  
ATOM   2007  CA  ASN   250      36.948  45.377  16.717  1.00 18.87           C  
ATOM   2008  C   ASN   250      38.357  45.863  16.478  1.00 19.30           C  
ATOM   2009  O   ASN   250      39.125  45.186  15.831  1.00 17.61           O  
ATOM   2010  CB  ASN   250      36.074  45.436  15.463  1.00 19.36           C  
ATOM   2011  CG  ASN   250      35.623  46.859  15.113  1.00 26.18           C  
ATOM   2012  OD1 ASN   250      36.006  47.833  15.762  1.00 21.97           O  
ATOM   2013  ND2 ASN   250      34.794  46.966  14.082  1.00 23.76           N  
ATOM   2014  N   VAL   251      38.705  47.014  17.053  1.00 17.26           N  
ATOM   2015  CA  VAL   251      40.090  47.489  17.021  1.00 17.67           C  
ATOM   2016  C   VAL   251      41.045  46.546  17.793  1.00 15.70           C  
ATOM   2017  O   VAL   251      42.209  46.395  17.416  1.00 20.55           O  
ATOM   2018  CB  VAL   251      40.213  48.959  17.474  1.00 18.07           C  
ATOM   2019  CG1 VAL   251      41.693  49.419  17.429  1.00 19.60           C  
ATOM   2020  CG2 VAL   251      39.326  49.855  16.598  1.00 20.52           C  
ATOM   2021  N   ASN   252      40.554  45.898  18.853  1.00 16.54           N  
ATOM   2022  CA  ASN   252      41.300  44.796  19.520  1.00 19.17           C  
ATOM   2023  C   ASN   252      41.835  43.794  18.486  1.00 17.97           C  
ATOM   2024  O   ASN   252      43.016  43.390  18.550  1.00 13.67           O  
ATOM   2025  CB  ASN   252      40.427  44.044  20.518  1.00 16.95           C  
ATOM   2026  CG  ASN   252      40.085  44.874  21.712  1.00 21.39           C  
ATOM   2027  OD1 ASN   252      40.966  45.357  22.403  1.00 21.20           O  
ATOM   2028  ND2 ASN   252      38.796  45.077  21.939  1.00 18.46           N  
ATOM   2029  N   LEU   253      40.979  43.415  17.544  1.00 16.65           N  
ATOM   2030  CA  LEU   253      41.404  42.493  16.468  1.00 19.56           C  
ATOM   2031  C   LEU   253      42.543  43.033  15.601  1.00 16.73           C  
ATOM   2032  O   LEU   253      43.489  42.301  15.315  1.00 18.19           O  
ATOM   2033  CB  LEU   253      40.229  42.022  15.603  1.00 18.12           C  
ATOM   2034  CG  LEU   253      38.922  41.578  16.300  1.00 20.48           C  
ATOM   2035  CD1 LEU   253      37.904  41.116  15.291  1.00 21.68           C  
ATOM   2036  CD2 LEU   253      39.152  40.512  17.330  1.00 20.21           C  
ATOM   2037  N   THR   254      42.473  44.311  15.194  1.00 15.24           N  
ATOM   2038  CA  THR   254      43.556  44.925  14.404  1.00 18.27           C  
ATOM   2039  C   THR   254      44.865  44.978  15.187  1.00 16.83           C  
ATOM   2040  O   THR   254      45.934  44.825  14.612  1.00 17.38           O  
ATOM   2041  CB  THR   254      43.206  46.367  13.943  1.00 21.69           C  
ATOM   2042  OG1 THR   254      43.306  47.269  15.053  1.00 19.60           O  
ATOM   2043  CG2 THR   254      41.784  46.421  13.327  1.00 18.91           C  
ATOM   2044  N   VAL   255      44.787  45.190  16.513  1.00 16.92           N  
ATOM   2045  CA  VAL   255      46.014  45.184  17.332  1.00 20.44           C  
ATOM   2046  C   VAL   255      46.648  43.772  17.414  1.00 16.81           C  
ATOM   2047  O   VAL   255      47.861  43.602  17.301  1.00 15.75           O  
ATOM   2048  CB  VAL   255      45.729  45.717  18.762  1.00 23.19           C  
ATOM   2049  CG1 VAL   255      46.961  45.580  19.637  1.00 17.22           C  
ATOM   2050  CG2 VAL   255      45.271  47.183  18.700  1.00 17.07           C  
ATOM   2051  N   ILE   256      45.817  42.770  17.622  1.00 15.06           N  
ATOM   2052  CA  ILE   256      46.283  41.365  17.645  1.00 16.72           C  
ATOM   2053  C   ILE   256      46.945  40.996  16.304  1.00 18.72           C  
ATOM   2054  O   ILE   256      48.041  40.424  16.277  1.00 17.73           O  
ATOM   2055  CB  ILE   256      45.117  40.416  17.975  1.00 15.49           C  
ATOM   2056  CG1 ILE   256      44.671  40.628  19.426  1.00 16.40           C  
ATOM   2057  CG2 ILE   256      45.526  38.931  17.782  1.00 15.97           C  
ATOM   2058  CD1 ILE   256      43.271  40.002  19.721  1.00 17.55           C  
ATOM   2059  N   ASP   257      46.308  41.383  15.204  1.00 13.78           N  
ATOM   2060  CA  ASP   257      46.861  41.172  13.864  1.00 15.76           C  
ATOM   2061  C   ASP   257      48.199  41.850  13.683  1.00 15.74           C  
ATOM   2062  O   ASP   257      49.140  41.264  13.139  1.00 14.56           O  
ATOM   2063  CB  ASP   257      45.867  41.648  12.794  1.00 18.64           C  
ATOM   2064  CG  ASP   257      46.470  41.626  11.405  1.00 26.78           C  
ATOM   2065  OD1 ASP   257      46.453  40.556  10.783  1.00 20.72           O  
ATOM   2066  OD2 ASP   257      46.996  42.664  10.954  1.00 20.29           O  
ATOM   2067  N   PHE   258      48.273  43.108  14.105  1.00 16.25           N  
ATOM   2068  CA  PHE   258      49.528  43.852  14.067  1.00 17.51           C  
ATOM   2069  C   PHE   258      50.622  43.141  14.865  1.00 16.83           C  
ATOM   2070  O   PHE   258      51.773  43.018  14.390  1.00 17.69           O  
ATOM   2071  CB  PHE   258      49.323  45.269  14.626  1.00 15.95           C  
ATOM   2072  CG  PHE   258      50.559  46.166  14.516  1.00 17.88           C  
ATOM   2073  CD1 PHE   258      50.725  47.003  13.413  1.00 17.31           C  
ATOM   2074  CD2 PHE   258      51.537  46.171  15.533  1.00 17.86           C  
ATOM   2075  CE1 PHE   258      51.858  47.838  13.312  1.00 20.55           C  
ATOM   2076  CE2 PHE   258      52.654  46.980  15.434  1.00 23.41           C  
ATOM   2077  CZ  PHE   258      52.815  47.810  14.323  1.00 18.10           C  
ATOM   2078  N   ALA   259      50.285  42.691  16.073  1.00 14.66           N  
ATOM   2079  CA  ALA   259      51.247  41.942  16.906  1.00 17.15           C  
ATOM   2080  C   ALA   259      51.777  40.679  16.212  1.00 16.42           C  
ATOM   2081  O   ALA   259      52.985  40.380  16.281  1.00 17.86           O  
ATOM   2082  CB  ALA   259      50.584  41.557  18.213  1.00 16.20           C  
ATOM   2083  N   ILE   260      50.876  39.950  15.553  1.00 15.43           N  
ATOM   2084  CA  ILE   260      51.263  38.743  14.796  1.00 17.05           C  
ATOM   2085  C   ILE   260      52.194  39.088  13.631  1.00 21.68           C  
ATOM   2086  O   ILE   260      53.265  38.511  13.498  1.00 17.54           O  
ATOM   2087  CB  ILE   260      50.004  37.957  14.309  1.00 15.84           C  
ATOM   2088  CG1 ILE   260      49.276  37.306  15.480  1.00 15.26           C  
ATOM   2089  CG2 ILE   260      50.356  36.946  13.221  1.00 13.29           C  
ATOM   2090  CD1 ILE   260      47.801  37.088  15.148  1.00 20.98           C  
ATOM   2091  N   ARG   261      51.829  40.091  12.840  1.00 16.50           N  
ATOM   2092  CA  ARG   261      52.593  40.431  11.650  1.00 17.41           C  
ATOM   2093  C   ARG   261      53.957  41.067  11.969  1.00 20.27           C  
ATOM   2094  O   ARG   261      54.883  40.981  11.167  1.00 17.78           O  
ATOM   2095  CB  ARG   261      51.767  41.376  10.777  1.00 18.71           C  
ATOM   2096  CG  ARG   261      50.631  40.706  10.003  1.00 18.49           C  
ATOM   2097  CD  ARG   261      49.895  41.730   9.083  1.00 19.15           C  
ATOM   2098  NE  ARG   261      49.374  42.927   9.773  1.00 15.15           N  
ATOM   2099  CZ  ARG   261      49.999  44.110   9.879  1.00 17.36           C  
ATOM   2100  NH1 ARG   261      51.185  44.316   9.312  1.00 13.59           N  
ATOM   2101  NH2 ARG   261      49.410  45.118  10.534  1.00 17.72           N  
ATOM   2102  N   HIS   262      54.049  41.730  13.125  1.00 18.55           N  
ATOM   2103  CA  HIS   262      55.287  42.423  13.520  1.00 18.49           C  
ATOM   2104  C   HIS   262      56.111  41.632  14.541  1.00 19.93           C  
ATOM   2105  O   HIS   262      57.079  42.156  15.116  1.00 20.40           O  
ATOM   2106  CB  HIS   262      54.993  43.845  14.015  1.00 20.26           C  
ATOM   2107  CG  HIS   262      54.594  44.785  12.917  1.00 22.68           C  
ATOM   2108  ND1 HIS   262      55.464  45.707  12.373  1.00 26.66           N  
ATOM   2109  CD2 HIS   262      53.422  44.926  12.243  1.00 19.17           C  
ATOM   2110  CE1 HIS   262      54.846  46.384  11.418  1.00 25.84           C  
ATOM   2111  NE2 HIS   262      53.615  45.915  11.305  1.00 22.21           N  
ATOM   2112  N   GLY   263      55.748  40.363  14.727  1.00 15.73           N  
ATOM   2113  CA  GLY   263      56.525  39.416  15.539  1.00 18.52           C  
ATOM   2114  C   GLY   263      56.471  39.718  17.035  1.00 23.51           C  
ATOM   2115  O   GLY   263      57.383  39.371  17.767  1.00 19.61           O  
ATOM   2116  N   LEU   264      55.410  40.379  17.482  1.00 14.70           N  
ATOM   2117  CA  LEU   264      55.305  40.807  18.894  1.00 17.57           C  
ATOM   2118  C   LEU   264      54.781  39.666  19.747  1.00 21.10           C  
ATOM   2119  O   LEU   264      54.997  39.651  20.979  1.00 24.41           O  
ATOM   2120  CB  LEU   264      54.405  42.057  19.037  1.00 21.79           C  
ATOM   2121  CG  LEU   264      54.894  43.310  18.267  1.00 23.31           C  
ATOM   2122  CD1 LEU   264      54.040  44.564  18.553  1.00 26.68           C  
ATOM   2123  CD2 LEU   264      56.367  43.588  18.518  1.00 29.60           C  
ATOM   2124  N   ILE   265      54.031  38.749  19.115  1.00 18.52           N  
ATOM   2125  CA  ILE   265      53.686  37.475  19.752  1.00 22.83           C  
ATOM   2126  C   ILE   265      54.260  36.308  18.926  1.00 22.38           C  
ATOM   2127  O   ILE   265      54.466  36.436  17.709  1.00 22.45           O  
ATOM   2128  CB  ILE   265      52.160  37.348  20.072  1.00 25.81           C  
ATOM   2129  CG1 ILE   265      51.316  37.513  18.820  1.00 23.62           C  
ATOM   2130  CG2 ILE   265      51.719  38.400  21.120  1.00 28.12           C  
ATOM   2131  CD1 ILE   265      49.815  37.437  19.137  1.00 30.09           C  
ATOM   2132  N   ASP   266      54.528  35.182  19.589  1.00 17.59           N  
ATOM   2133  CA  ASP   266      55.396  34.130  19.052  1.00 18.41           C  
ATOM   2134  C   ASP   266      54.716  32.788  19.309  1.00 14.35           C  
ATOM   2135  O   ASP   266      54.356  32.498  20.449  1.00 17.74           O  
ATOM   2136  CB  ASP   266      56.736  34.200  19.769  1.00 22.76           C  
ATOM   2137  CG  ASP   266      57.793  33.287  19.155  1.00 23.74           C  
ATOM   2138  OD1 ASP   266      57.485  32.100  18.885  1.00 18.42           O  
ATOM   2139  OD2 ASP   266      58.934  33.756  18.958  1.00 28.70           O  
ATOM   2140  N   PRO   267      54.519  31.984  18.263  1.00 14.45           N  
ATOM   2141  CA  PRO   267      53.801  30.706  18.408  1.00 18.63           C  
ATOM   2142  C   PRO   267      54.476  29.707  19.342  1.00 19.37           C  
ATOM   2143  O   PRO   267      53.824  28.755  19.780  1.00 18.58           O  
ATOM   2144  CB  PRO   267      53.784  30.167  16.977  1.00 15.64           C  
ATOM   2145  CG  PRO   267      55.031  30.801  16.347  1.00 17.26           C  
ATOM   2146  CD  PRO   267      54.945  32.200  16.867  1.00 20.06           C  
ATOM   2147  N   ASP   268      55.740  29.927  19.664  1.00 15.62           N  
ATOM   2148  CA  ASP   268      56.414  29.081  20.623  1.00 15.57           C  
ATOM   2149  C   ASP   268      55.906  29.264  22.063  1.00 18.65           C  
ATOM   2150  O   ASP   268      56.171  28.468  22.893  1.00 20.39           O  
ATOM   2151  CB  ASP   268      57.926  29.260  20.596  1.00 15.64           C  
ATOM   2152  CG  ASP   268      58.650  28.193  19.765  1.00 20.73           C  
ATOM   2153  OD1 ASP   268      58.176  27.083  19.594  1.00 19.74           O  
ATOM   2154  OD2 ASP   268      59.709  28.523  19.289  1.00 18.59           O  
ATOM   2155  N   ASN   269      55.254  30.378  22.352  1.00 18.15           N  
ATOM   2156  CA  ASN   269      54.833  30.636  23.700  1.00 18.28           C  
ATOM   2157  C   ASN   269      53.520  31.390  23.936  1.00 23.96           C  
ATOM   2158  O   ASN   269      53.023  31.432  25.023  1.00 26.27           O  
ATOM   2159  CB  ASN   269      55.964  31.175  24.533  1.00 18.15           C  
ATOM   2160  CG  ASN   269      56.558  32.401  23.953  1.00 26.19           C  
ATOM   2161  OD1 ASN   269      57.699  32.422  23.568  1.00 32.60           O  
ATOM   2162  ND2 ASN   269      55.787  33.418  23.887  1.00 26.72           N  
ATOM   2163  N   GLU   270      52.941  31.937  22.902  1.00 16.48           N  
ATOM   2164  CA  GLU   270      51.647  32.553  23.047  1.00 15.11           C  
ATOM   2165  C   GLU   270      50.492  31.549  23.084  1.00 14.42           C  
ATOM   2166  O   GLU   270      50.240  30.921  22.121  1.00 21.12           O  
ATOM   2167  CB  GLU   270      51.467  33.548  21.932  1.00 18.79           C  
ATOM   2168  CG  GLU   270      50.290  34.433  22.053  1.00 18.97           C  
ATOM   2169  CD  GLU   270      50.347  35.361  23.231  1.00 22.84           C  
ATOM   2170  OE1 GLU   270      51.369  35.956  23.455  1.00 20.01           O  
ATOM   2171  OE2 GLU   270      49.349  35.477  23.920  1.00 26.54           O  
ATOM   2172  N   PRO   271      49.784  31.472  24.201  1.00 18.53           N  
ATOM   2173  CA  PRO   271      48.640  30.527  24.313  1.00 18.62           C  
ATOM   2174  C   PRO   271      47.585  30.711  23.209  1.00 21.48           C  
ATOM   2175  O   PRO   271      47.318  31.827  22.772  1.00 20.64           O  
ATOM   2176  CB  PRO   271      48.042  30.857  25.699  1.00 18.34           C  
ATOM   2177  CG  PRO   271      49.205  31.407  26.481  1.00 22.82           C  
ATOM   2178  CD  PRO   271      49.976  32.218  25.463  1.00 19.03           C  
ATOM   2179  N   ASP   272      47.040  29.602  22.722  1.00 19.39           N  
ATOM   2180  CA  ASP   272      45.946  29.606  21.734  1.00 21.41           C  
ATOM   2181  C   ASP   272      46.249  30.312  20.390  1.00 22.39           C  
ATOM   2182  O   ASP   272      45.353  30.844  19.739  1.00 21.93           O  
ATOM   2183  CB  ASP   272      44.665  30.132  22.399  1.00 25.85           C  
ATOM   2184  CG  ASP   272      44.337  29.387  23.701  1.00 22.95           C  
ATOM   2185  OD1 ASP   272      44.123  28.160  23.659  1.00 30.25           O  
ATOM   2186  OD2 ASP   272      44.290  30.024  24.762  1.00 25.66           O  
ATOM   2187  N   TYR   273      47.521  30.310  19.994  1.00 22.77           N  
ATOM   2188  CA  TYR   273      47.976  31.029  18.803  1.00 24.21           C  
ATOM   2189  C   TYR   273      47.124  30.663  17.581  1.00 25.07           C  
ATOM   2190  O   TYR   273      46.575  31.546  16.921  1.00 19.63           O  
ATOM   2191  CB  TYR   273      49.470  30.728  18.556  1.00 24.65           C  
ATOM   2192  CG  TYR   273      50.160  31.551  17.468  1.00 22.16           C  
ATOM   2193  CD1 TYR   273      50.778  32.746  17.787  1.00 22.26           C  
ATOM   2194  CD2 TYR   273      50.222  31.115  16.129  1.00 26.27           C  
ATOM   2195  CE1 TYR   273      51.455  33.514  16.826  1.00 25.71           C  
ATOM   2196  CE2 TYR   273      50.906  31.883  15.148  1.00 23.07           C  
ATOM   2197  CZ  TYR   273      51.516  33.091  15.519  1.00 26.26           C  
ATOM   2198  OH  TYR   273      52.227  33.891  14.619  1.00 25.63           O  
ATOM   2199  N   GLN   274      46.965  29.362  17.313  1.00 25.05           N  
ATOM   2200  CA  GLN   274      46.233  28.905  16.136  1.00 28.03           C  
ATOM   2201  C   GLN   274      44.756  29.291  16.186  1.00 21.12           C  
ATOM   2202  O   GLN   274      44.185  29.668  15.168  1.00 25.17           O  
ATOM   2203  CB  GLN   274      46.352  27.379  15.960  1.00 29.75           C  
ATOM   2204  CG  GLN   274      47.542  26.871  15.197  1.00 35.04           C  
ATOM   2205  CD  GLN   274      47.510  25.334  15.104  1.00 37.83           C  
ATOM   2206  OE1 GLN   274      47.600  24.655  16.103  1.00 54.17           O  
ATOM   2207  NE2 GLN   274      47.333  24.809  13.918  1.00 29.49           N  
ATOM   2208  N   GLU   275      44.133  29.184  17.363  1.00 21.24           N  
ATOM   2209  CA  GLU   275      42.711  29.558  17.518  1.00 23.65           C  
ATOM   2210  C   GLU   275      42.464  31.077  17.339  1.00 23.33           C  
ATOM   2211  O   GLU   275      41.438  31.485  16.766  1.00 23.64           O  
ATOM   2212  CB  GLU   275      42.172  29.094  18.877  1.00 25.97           C  
ATOM   2213  CG  GLU   275      40.632  29.029  18.967  1.00 32.41           C  
ATOM   2214  CD  GLU   275      40.122  28.518  20.321  1.00 39.35           C  
ATOM   2215  OE1 GLU   275      40.922  27.962  21.105  1.00 44.52           O  
ATOM   2216  OE2 GLU   275      38.908  28.672  20.601  1.00 41.90           O  
ATOM   2217  N   ILE   276      43.388  31.896  17.846  1.00 20.81           N  
ATOM   2218  CA  ILE   276      43.385  33.356  17.610  1.00 17.98           C  
ATOM   2219  C   ILE   276      43.453  33.689  16.106  1.00 17.71           C  
ATOM   2220  O   ILE   276      42.631  34.450  15.591  1.00 21.55           O  
ATOM   2221  CB  ILE   276      44.528  34.081  18.401  1.00 15.86           C  
ATOM   2222  CG1 ILE   276      44.247  34.008  19.908  1.00 19.73           C  
ATOM   2223  CG2 ILE   276      44.706  35.542  17.912  1.00 19.05           C  
ATOM   2224  CD1 ILE   276      45.475  34.302  20.768  1.00 19.29           C  
ATOM   2225  N   LEU   277      44.398  33.072  15.395  1.00 19.08           N  
ATOM   2226  CA  LEU   277      44.530  33.265  13.963  1.00 21.48           C  
ATOM   2227  C   LEU   277      43.274  32.840  13.211  1.00 24.88           C  
ATOM   2228  O   LEU   277      42.825  33.536  12.298  1.00 24.76           O  
ATOM   2229  CB  LEU   277      45.735  32.471  13.422  1.00 21.86           C  
ATOM   2230  CG  LEU   277      47.076  33.195  13.374  1.00 24.75           C  
ATOM   2231  CD1 LEU   277      47.600  33.586  14.733  1.00 34.47           C  
ATOM   2232  CD2 LEU   277      48.096  32.295  12.688  1.00 25.76           C  
ATOM   2233  N   ALA   278      42.715  31.692  13.593  1.00 27.02           N  
ATOM   2234  CA  ALA   278      41.506  31.175  12.965  1.00 25.77           C  
ATOM   2235  C   ALA   278      40.359  32.164  13.105  1.00 27.86           C  
ATOM   2236  O   ALA   278      39.644  32.463  12.139  1.00 27.51           O  
ATOM   2237  CB  ALA   278      41.141  29.816  13.572  1.00 26.62           C  
ATOM   2238  N   GLY   279      40.206  32.713  14.303  1.00 24.75           N  
ATOM   2239  CA  GLY   279      39.119  33.606  14.566  1.00 24.32           C  
ATOM   2240  C   GLY   279      39.255  34.969  13.922  1.00 21.62           C  
ATOM   2241  O   GLY   279      38.252  35.644  13.752  1.00 25.06           O  
ATOM   2242  N   LEU   280      40.471  35.367  13.529  1.00 21.70           N  
ATOM   2243  CA  LEU   280      40.689  36.640  12.818  1.00 16.91           C  
ATOM   2244  C   LEU   280      40.233  36.546  11.361  1.00 19.92           C  
ATOM   2245  O   LEU   280      40.131  37.569  10.678  1.00 23.50           O  
ATOM   2246  CB  LEU   280      42.167  37.093  12.848  1.00 19.48           C  
ATOM   2247  CG  LEU   280      42.750  37.463  14.221  1.00 19.47           C  
ATOM   2248  CD1 LEU   280      44.277  37.667  14.111  1.00 17.83           C  
ATOM   2249  CD2 LEU   280      42.045  38.638  14.883  1.00 22.63           C  
ATOM   2250  N   ARG   281      39.992  35.328  10.881  1.00 23.44           N  
ATOM   2251  CA  ARG   281      39.354  35.114   9.570  1.00 32.81           C  
ATOM   2252  C   ARG   281      37.935  34.561   9.712  1.00 32.09           C  
ATOM   2253  O   ARG   281      37.445  33.916   8.796  1.00 48.29           O  
ATOM   2254  CB  ARG   281      40.191  34.158   8.682  1.00 34.72           C  
ATOM   2255  CG  ARG   281      41.637  34.586   8.452  1.00 51.44           C  
ATOM   2256  CD  ARG   281      41.875  35.612   7.315  1.00 47.49           C  
ATOM   2257  NE  ARG   281      43.253  36.139   7.365  1.00 47.28           N  
ATOM   2258  CZ  ARG   281      44.352  35.493   6.941  1.00 62.28           C  
ATOM   2259  NH1 ARG   281      44.285  34.275   6.399  1.00 47.33           N  
ATOM   2260  NH2 ARG   281      45.544  36.071   7.053  1.00 64.73           N  
ATOM   2261  N   GLY   282      37.261  34.858  10.830  1.00 38.52           N  
ATOM   2262  CA  GLY   282      35.979  34.235  11.204  1.00 42.89           C  
ATOM   2263  C   GLY   282      34.742  34.549  10.371  1.00 58.44           C  
ATOM   2264  O   GLY   282      34.487  35.704  10.042  1.00 62.23           O  
ATOM   2265  N   ARG   283      33.963  33.519  10.030  1.00 64.93           N  
ATOM   2266  CA  ARG   283      32.705  33.700   9.274  1.00 72.21           C  
ATOM   2267  C   ARG   283      31.534  32.990   9.967  1.00 69.93           C  
ATOM   2268  O   ARG   283      30.361  33.286   9.718  1.00 69.14           O  
ATOM   2269  CB  ARG   283      32.831  33.197   7.821  1.00 73.70           C  
ATOM   2270  CG  ARG   283      34.107  33.605   7.074  1.00 81.93           C  
ATOM   2271  CD  ARG   283      33.954  33.492   5.560  1.00 83.14           C  
ATOM   2272  NE  ARG   283      33.593  34.769   4.934  1.00 96.15           N  
ATOM   2273  CZ  ARG   283      34.447  35.572   4.294  1.00100.15           C  
ATOM   2274  NH1 ARG   283      34.015  36.705   3.758  1.00 98.98           N  
ATOM   2275  NH2 ARG   283      35.731  35.249   4.181  1.00102.87           N  
END
