
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  147 ( 1201),  selected  147 , name 2o1c_A
# Molecule2: number of CA atoms  208 ( 1611),  selected  208 , name T0513_1_11_87_283.pdb
# PARAMETERS: 2o1c_A.T0513_1_11_87_283.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     2_A      M       1           -
LGA    D     3_A      S       2           -
LGA    K     4_A      F       3           -
LGA    -       -      L       4           -
LGA    -       -      K       5           -
LGA    -       -      H       6           -
LGA    -       -      V       7           -
LGA    -       -      Q       8           -
LGA    -       -      D       9           -
LGA    -       -      C      10           -
LGA    -       -      N      11           -
LGA    V     5_A      G      87          2.947
LGA    -       -      E      88           -
LGA    -       -      L      89           -
LGA    -       -      Y      90           -
LGA    -       -      R      91           -
LGA    -       -      V      92           -
LGA    -       -      N      93           -
LGA    -       -      Q      94           -
LGA    -       -      S      95           -
LGA    -       -      W      96           -
LGA    -       -      G      97           -
LGA    -       -      E      98           -
LGA    -       -      P      99           -
LGA    -       -      T     100           -
LGA    -       -      L     101           -
LGA    -       -      M     102           -
LGA    -       -      L     103           -
LGA    -       -      L     104           -
LGA    -       -      D     105           -
LGA    -       -      R     106           -
LGA    Y     6_A      A     107          2.481
LGA    K     7_A      V     108           -
LGA    R     8_A      V     109          6.006
LGA    P     9_A      P     110           #
LGA    -       -      T     111           -
LGA    -       -      F     112           -
LGA    -       -      G     113           -
LGA    -       -      V     114           -
LGA    -       -      R     115           -
LGA    V    10_A      A     116          2.671
LGA    -       -      Y     117           -
LGA    S    11_A      G     118          0.908
LGA    I    12_A      V     119          1.131
LGA    L    13_A      H     120          0.917
LGA    V    14_A      L     121          0.841
LGA    V    15_A      N     122          0.933
LGA    I    16_A      G     123          0.947
LGA    Y    17_A      Y     124          0.916
LGA    A    18_A      V     125          1.323
LGA    Q    19_A      G     126          3.446
LGA    D    20_A      A     127           #
LGA    T    21_A      G     128           #
LGA    -       -      A     129           -
LGA    -       -      D     130           -
LGA    K    22_A      L     131          1.917
LGA    R    23_A      H     132          0.796
LGA    V    24_A      L     133          0.563
LGA    L    25_A      W     134          0.770
LGA    M    26_A      I     135          0.568
LGA    L    27_A      G     136          0.641
LGA    Q    28_A      R     137          0.859
LGA    R    29_A      R     138          1.154
LGA    R    30_A      S     139          1.903
LGA    -       -      P     140           -
LGA    -       -      D     141           -
LGA    D    31_A      K     142          2.252
LGA    -       -      S     143           -
LGA    -       -      V     144           -
LGA    D    32_A      A     145          2.801
LGA    P    33_A      P     146          3.861
LGA    D    34_A      G     147          4.347
LGA    F    35_A      K     148          1.599
LGA    W    36_A      L     149          0.276
LGA    Q    37_A      D     150          1.002
LGA    S    38_A      N     151          0.388
LGA    -       -      M     152           -
LGA    V    39_A      V     153          1.949
LGA    T    40_A      A     154          1.405
LGA    G    41_A      G     155          0.791
LGA    S    42_A      G     156          1.181
LGA    V    43_A      Q     157          1.139
LGA    E    44_A      P     158          0.621
LGA    E    45_A      A     159          1.039
LGA    G    46_A      D     160          1.738
LGA    E    47_A      L     161          1.198
LGA    T    48_A      S     162          1.560
LGA    A    49_A      L     163          1.574
LGA    P    50_A      R     164          2.033
LGA    Q    51_A      Q     165          1.842
LGA    A    52_A      N     166          1.580
LGA    A    53_A      L     167          1.596
LGA    M    54_A      I     168          1.783
LGA    R    55_A      K     169          1.499
LGA    E    56_A      E     170          1.116
LGA    V    57_A      C     171          1.334
LGA    K    58_A      A     172          1.438
LGA    E    59_A      E     173          1.239
LGA    E    60_A      E     174          0.534
LGA    V    61_A      A     175          0.205
LGA    T    62_A      D     176          0.932
LGA    I    63_A      L     177          0.385
LGA    D    64_A      P     178          1.616
LGA    V    65_A      E     179          3.486
LGA    V    66_A      A     180          2.707
LGA    A    67_A      -       -           -
LGA    E    68_A      L     181          3.505
LGA    Q    69_A      A     182           #
LGA    L    70_A      R     183          5.275
LGA    T    71_A      Q     184          1.620
LGA    L    72_A      A     185          1.124
LGA    I    73_A      I     186          0.844
LGA    D    74_A      P     187          0.470
LGA    C    75_A      V     188          0.617
LGA    Q    76_A      G     189          2.632
LGA    R    77_A      A     190          2.478
LGA    T    78_A      I     191          3.578
LGA    V    79_A      T     192          1.899
LGA    E    80_A      Y     193          2.348
LGA    F    81_A      C     194          4.245
LGA    E    82_A      M     195          2.790
LGA    I    83_A      E     196           #
LGA    F    84_A      S     197          5.703
LGA    S    85_A      P     198          4.157
LGA    H    86_A      -       -           -
LGA    L    87_A      -       -           -
LGA    R    88_A      A     199          5.722
LGA    H    89_A      -       -           -
LGA    R    90_A      -       -           -
LGA    Y    91_A      -       -           -
LGA    A    92_A      -       -           -
LGA    P    93_A      -       -           -
LGA    G    94_A      G     200          3.623
LGA    V    95_A      I     201          4.187
LGA    T    96_A      K     202          2.554
LGA    R    97_A      P     203          2.647
LGA    N    98_A      D     204          2.014
LGA    T    99_A      T     205          1.706
LGA    E   100_A      L     206          1.162
LGA    S   101_A      F     207          1.118
LGA    W   102_A      L     208          0.853
LGA    F   103_A      Y     209          0.935
LGA    C   104_A      D     210          1.155
LGA    L   105_A      L     211          1.257
LGA    A   106_A      A     212          1.288
LGA    L   107_A      L     213          0.419
LGA    P   108_A      P     214          2.153
LGA    H   109_A      E     215          1.390
LGA    E   110_A      D     216           #
LGA    R   111_A      F     217          3.009
LGA    Q   112_A      R     218          2.592
LGA    I   113_A      P     219          1.959
LGA    V   114_A      H     220          0.904
LGA    F   115_A      N     221          0.977
LGA    T   116_A      T     222          3.183
LGA    -       -      D     223           -
LGA    -       -      G     224           -
LGA    E   117_A      E     225          1.230
LGA    H   118_A      M     226          0.803
LGA    L   119_A      A     227          0.957
LGA    A   120_A      D     228          1.549
LGA    Y   121_A      F     229          1.152
LGA    K   122_A      M     230          0.698
LGA    W   123_A      L     231          0.408
LGA    L   124_A      W     232          0.506
LGA    D   125_A      P     233          0.803
LGA    A   126_A      A     234          0.961
LGA    P   127_A      A     235          1.919
LGA    A   128_A      K     236          1.330
LGA    A   129_A      V     237          1.573
LGA    A   130_A      V     238          2.741
LGA    A   131_A      E     239          3.301
LGA    L   132_A      A     240          3.161
LGA    -       -      V     241           -
LGA    -       -      R     242           -
LGA    -       -      T     243           -
LGA    -       -      T     244           -
LGA    -       -      E     245           -
LGA    -       -      A     246           -
LGA    T   133_A      F     247          2.476
LGA    K   134_A      K     248          3.898
LGA    S   135_A      F     249          3.474
LGA    -       -      N     250           -
LGA    -       -      V     251           -
LGA    W   136_A      N     252          2.588
LGA    S   137_A      L     253          1.456
LGA    N   138_A      T     254          2.162
LGA    R   139_A      V     255          1.768
LGA    Q   140_A      I     256          1.550
LGA    A   141_A      D     257          2.905
LGA    I   142_A      F     258          2.681
LGA    E   143_A      A     259          0.796
LGA    Q   144_A      I     260          2.799
LGA    F   145_A      R     261          3.903
LGA    V   146_A      -       -           -
LGA    I   147_A      H     262          3.762
LGA    N   148_A      G     263          2.264
LGA    -       -      L     264           -
LGA    -       -      I     265           -
LGA    -       -      D     266           -
LGA    -       -      P     267           -
LGA    -       -      D     268           -
LGA    -       -      N     269           -
LGA    -       -      E     270           -
LGA    -       -      P     271           -
LGA    -       -      D     272           -
LGA    -       -      Y     273           -
LGA    -       -      Q     274           -
LGA    -       -      E     275           -
LGA    -       -      I     276           -
LGA    -       -      L     277           -
LGA    -       -      A     278           -
LGA    -       -      G     279           -
LGA    -       -      L     280           -
LGA    -       -      R     281           -
LGA    -       -      G     282           -
LGA    -       -      R     283           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  147  208    5.0    128    2.26    15.62     44.206     5.433

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.972393 * X  +   0.202080 * Y  +   0.116684 * Z  +  49.370537
  Y_new =   0.020419 * X  +  -0.571811 * Y  +   0.820131 * Z  +   2.381165
  Z_new =   0.232453 * X  +  -0.795108 * Y  +  -0.560151 * Z  +  53.504215 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.184534    0.957058  [ DEG:  -125.1646     54.8354 ]
  Theta =  -0.234599   -2.906993  [ DEG:   -13.4416   -166.5584 ]
  Phi   =   0.020996   -3.120597  [ DEG:     1.2030   -178.7970 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2o1c_A                                        
REMARK     2: T0513_1_11_87_283.pdb                         
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2o1c_A.T0513_1_11_87_283.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  147  208   5.0  128   2.26   15.62  44.206
REMARK  ---------------------------------------------------------- 
MOLECULE 2o1c_A
HEADER    HYDROLASE                               28-NOV-06   2O1C              
TITLE     STRUCTURE OF THE E. COLI DIHYDRONEOPTERIN TRIPHOSPHATE                
TITLE    2 PYROPHOSPHOHYDROLASE                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DATP PYROPHOSPHOHYDROLASE;                                 
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 EC: 3.6.1.-;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 STRAIN: HB101;                                                       
SOURCE   4 GENE: NUDB, NTPA;                                                    
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: HMS174(DE3);                               
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET11B                                    
KEYWDS    NUDIX NTP HYDROLASE NTP PYROPHOSPHOHYDROLASE MUTT                     
KEYWDS   2 DIHYDRONEOPTERIN TRIPHOSPHATE PYROPHOSPHOHYDROLASE FOLATE            
KEYWDS   3 BIOSYNTHESIS                                                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.B.GABELLI,M.A.BIANCHET,L.M.AMZEL                                    
REVDAT   1   28-AUG-07 2O1C    0                                                
JRNL        AUTH   S.B.GABELLI,M.A.BIANCHET,W.L.XU,C.A.DUNN,Z.-D.NIU,           
JRNL        AUTH 2 L.M.AMZEL,M.J.BESSMAN                                        
JRNL        TITL   STRUCTURE AND FUNCTION OF THE E. COLI                        
JRNL        TITL 2 DIHYDRONEOPTERIN TRIPHOSPHATE PYROPHOSPHATASE: A             
JRNL        TITL 3 NUDIX ENZYME INVOLVED IN FOLATE BIOSYNTHESIS                 
JRNL        REF    STRUCTURE                     V.  15  1014 2007              
JRNL        REFN   ASTM STRUE6  UK ISSN 0969-2126                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2O1C A    1   150  UNP    P0AFC0   NUDB_ECOLI       1    150             
DBREF  2O1C B    1   150  UNP    P0AFC0   NUDB_ECOLI       1    150             
DBREF  2O1C C    1   150  UNP    P0AFC0   NUDB_ECOLI       1    150             
DBREF  2O1C D    1   150  UNP    P0AFC0   NUDB_ECOLI       1    150             
SEQRES   1 A  150  MET LYS ASP LYS VAL TYR LYS ARG PRO VAL SER ILE LEU          
SEQRES   2 A  150  VAL VAL ILE TYR ALA GLN ASP THR LYS ARG VAL LEU MET          
SEQRES   3 A  150  LEU GLN ARG ARG ASP ASP PRO ASP PHE TRP GLN SER VAL          
SEQRES   4 A  150  THR GLY SER VAL GLU GLU GLY GLU THR ALA PRO GLN ALA          
SEQRES   5 A  150  ALA MET ARG GLU VAL LYS GLU GLU VAL THR ILE ASP VAL          
SEQRES   6 A  150  VAL ALA GLU GLN LEU THR LEU ILE ASP CYS GLN ARG THR          
SEQRES   7 A  150  VAL GLU PHE GLU ILE PHE SER HIS LEU ARG HIS ARG TYR          
SEQRES   8 A  150  ALA PRO GLY VAL THR ARG ASN THR GLU SER TRP PHE CYS          
SEQRES   9 A  150  LEU ALA LEU PRO HIS GLU ARG GLN ILE VAL PHE THR GLU          
SEQRES  10 A  150  HIS LEU ALA TYR LYS TRP LEU ASP ALA PRO ALA ALA ALA          
SEQRES  11 A  150  ALA LEU THR LYS SER TRP SER ASN ARG GLN ALA ILE GLU          
SEQRES  12 A  150  GLN PHE VAL ILE ASN ALA ALA                                  
SEQRES   1 B  150  MET LYS ASP LYS VAL TYR LYS ARG PRO VAL SER ILE LEU          
SEQRES   2 B  150  VAL VAL ILE TYR ALA GLN ASP THR LYS ARG VAL LEU MET          
SEQRES   3 B  150  LEU GLN ARG ARG ASP ASP PRO ASP PHE TRP GLN SER VAL          
SEQRES   4 B  150  THR GLY SER VAL GLU GLU GLY GLU THR ALA PRO GLN ALA          
SEQRES   5 B  150  ALA MET ARG GLU VAL LYS GLU GLU VAL THR ILE ASP VAL          
SEQRES   6 B  150  VAL ALA GLU GLN LEU THR LEU ILE ASP CYS GLN ARG THR          
SEQRES   7 B  150  VAL GLU PHE GLU ILE PHE SER HIS LEU ARG HIS ARG TYR          
SEQRES   8 B  150  ALA PRO GLY VAL THR ARG ASN THR GLU SER TRP PHE CYS          
SEQRES   9 B  150  LEU ALA LEU PRO HIS GLU ARG GLN ILE VAL PHE THR GLU          
SEQRES  10 B  150  HIS LEU ALA TYR LYS TRP LEU ASP ALA PRO ALA ALA ALA          
SEQRES  11 B  150  ALA LEU THR LYS SER TRP SER ASN ARG GLN ALA ILE GLU          
SEQRES  12 B  150  GLN PHE VAL ILE ASN ALA ALA                                  
SEQRES   1 C  150  MET LYS ASP LYS VAL TYR LYS ARG PRO VAL SER ILE LEU          
SEQRES   2 C  150  VAL VAL ILE TYR ALA GLN ASP THR LYS ARG VAL LEU MET          
SEQRES   3 C  150  LEU GLN ARG ARG ASP ASP PRO ASP PHE TRP GLN SER VAL          
SEQRES   4 C  150  THR GLY SER VAL GLU GLU GLY GLU THR ALA PRO GLN ALA          
SEQRES   5 C  150  ALA MET ARG GLU VAL LYS GLU GLU VAL THR ILE ASP VAL          
SEQRES   6 C  150  VAL ALA GLU GLN LEU THR LEU ILE ASP CYS GLN ARG THR          
SEQRES   7 C  150  VAL GLU PHE GLU ILE PHE SER HIS LEU ARG HIS ARG TYR          
SEQRES   8 C  150  ALA PRO GLY VAL THR ARG ASN THR GLU SER TRP PHE CYS          
SEQRES   9 C  150  LEU ALA LEU PRO HIS GLU ARG GLN ILE VAL PHE THR GLU          
SEQRES  10 C  150  HIS LEU ALA TYR LYS TRP LEU ASP ALA PRO ALA ALA ALA          
SEQRES  11 C  150  ALA LEU THR LYS SER TRP SER ASN ARG GLN ALA ILE GLU          
SEQRES  12 C  150  GLN PHE VAL ILE ASN ALA ALA                                  
SEQRES   1 D  150  MET LYS ASP LYS VAL TYR LYS ARG PRO VAL SER ILE LEU          
SEQRES   2 D  150  VAL VAL ILE TYR ALA GLN ASP THR LYS ARG VAL LEU MET          
SEQRES   3 D  150  LEU GLN ARG ARG ASP ASP PRO ASP PHE TRP GLN SER VAL          
SEQRES   4 D  150  THR GLY SER VAL GLU GLU GLY GLU THR ALA PRO GLN ALA          
SEQRES   5 D  150  ALA MET ARG GLU VAL LYS GLU GLU VAL THR ILE ASP VAL          
SEQRES   6 D  150  VAL ALA GLU GLN LEU THR LEU ILE ASP CYS GLN ARG THR          
SEQRES   7 D  150  VAL GLU PHE GLU ILE PHE SER HIS LEU ARG HIS ARG TYR          
SEQRES   8 D  150  ALA PRO GLY VAL THR ARG ASN THR GLU SER TRP PHE CYS          
SEQRES   9 D  150  LEU ALA LEU PRO HIS GLU ARG GLN ILE VAL PHE THR GLU          
SEQRES  10 D  150  HIS LEU ALA TYR LYS TRP LEU ASP ALA PRO ALA ALA ALA          
SEQRES  11 D  150  ALA LEU THR LYS SER TRP SER ASN ARG GLN ALA ILE GLU          
SEQRES  12 D  150  GLN PHE VAL ILE ASN ALA ALA                                  
HET    SO4  A 164       5                                                       
HET    SO4  A 165       5                                                       
HET    SO4  B 164       5                                                       
HET    SO4  B 163       5                                                       
HET    PPV  A 163       9                                                       
HET    PPV  B 165       9                                                       
HET    PPV  C 163       9                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM     PPV PYROPHOSPHATE                                                    
FORMUL   5  SO4    4(O4 S 2-)                                                   
FORMUL   9  PPV    3(H4 O7 P2)                                                  
FORMUL  12  HOH   *611(H2 O)                                                    
CRYST1  124.104   42.579  106.467  90.00 115.69  90.00 C 1 2 1      16          
ATOM      1  N   LYS A   2      18.558  65.179   6.250  1.00 22.76           N  
ATOM      2  CA  LYS A   2      18.177  63.826   6.758  1.00 22.31           C  
ATOM      3  C   LYS A   2      19.106  63.383   7.883  1.00 22.19           C  
ATOM      4  O   LYS A   2      20.163  63.991   8.099  1.00 22.23           O  
ATOM      5  CB  LYS A   2      18.184  62.801   5.614  1.00 22.34           C  
ATOM      6  CG  LYS A   2      17.172  63.109   4.504  1.00 22.79           C  
ATOM      7  CD  LYS A   2      16.767  61.861   3.732  1.00 22.82           C  
ATOM      8  CE  LYS A   2      15.543  62.117   2.844  1.00 23.25           C  
ATOM      9  NZ  LYS A   2      15.871  62.897   1.631  1.00 24.40           N  
ATOM     10  N   ASP A   3      18.714  62.323   8.595  1.00 21.75           N  
ATOM     11  CA  ASP A   3      19.581  61.702   9.598  1.00 21.40           C  
ATOM     12  C   ASP A   3      20.846  61.211   8.917  1.00 20.95           C  
ATOM     13  O   ASP A   3      20.819  60.865   7.727  1.00 20.37           O  
ATOM     14  CB  ASP A   3      18.909  60.495  10.260  1.00 21.64           C  
ATOM     15  CG  ASP A   3      17.570  60.823  10.901  1.00 22.13           C  
ATOM     16  OD1 ASP A   3      17.292  62.006  11.193  1.00 23.14           O  
ATOM     17  OD2 ASP A   3      16.793  59.870  11.123  1.00 22.47           O  
ATOM     18  N   LYS A   4      21.946  61.163   9.673  1.00 20.37           N  
ATOM     19  CA  LYS A   4      23.182  60.586   9.166  1.00 20.35           C  
ATOM     20  C   LYS A   4      22.865  59.215   8.603  1.00 19.45           C  
ATOM     21  O   LYS A   4      22.188  58.405   9.243  1.00 19.17           O  
ATOM     22  CB  LYS A   4      24.251  60.472  10.259  1.00 20.32           C  
ATOM     23  CG  LYS A   4      25.060  61.746  10.488  1.00 21.46           C  
ATOM     24  CD  LYS A   4      26.064  61.596  11.639  1.00 21.81           C  
ATOM     25  CE  LYS A   4      27.394  60.987  11.184  1.00 25.39           C  
ATOM     26  NZ  LYS A   4      28.199  61.901  10.302  1.00 26.74           N  
ATOM     27  N   VAL A   5      23.333  58.971   7.387  1.00 19.06           N  
ATOM     28  CA  VAL A   5      23.109  57.690   6.734  1.00 18.39           C  
ATOM     29  C   VAL A   5      23.810  56.599   7.525  1.00 18.11           C  
ATOM     30  O   VAL A   5      24.747  56.876   8.279  1.00 18.08           O  
ATOM     31  CB  VAL A   5      23.570  57.715   5.257  1.00 18.47           C  
ATOM     32  CG1 VAL A   5      22.688  58.680   4.459  1.00 18.48           C  
ATOM     33  CG2 VAL A   5      25.046  58.099   5.145  1.00 18.47           C  
ATOM     34  N   TYR A   6      23.331  55.369   7.376  1.00 17.94           N  
ATOM     35  CA  TYR A   6      23.912  54.237   8.079  1.00 16.81           C  
ATOM     36  C   TYR A   6      25.369  54.045   7.680  1.00 16.61           C  
ATOM     37  O   TYR A   6      25.752  54.300   6.528  1.00 16.26           O  
ATOM     38  CB  TYR A   6      23.124  52.957   7.787  1.00 17.16           C  
ATOM     39  CG  TYR A   6      21.718  52.927   8.356  1.00 17.59           C  
ATOM     40  CD1 TYR A   6      21.488  53.100   9.723  1.00 17.42           C  
ATOM     41  CD2 TYR A   6      20.613  52.710   7.528  1.00 17.21           C  
ATOM     42  CE1 TYR A   6      20.200  53.062  10.249  1.00 18.78           C  
ATOM     43  CE2 TYR A   6      19.318  52.677   8.049  1.00 18.30           C  
ATOM     44  CZ  TYR A   6      19.125  52.850   9.410  1.00 18.39           C  
ATOM     45  OH  TYR A   6      17.852  52.809   9.936  1.00 19.75           O  
ATOM     46  N   LYS A   7      26.169  53.617   8.649  1.00 15.95           N  
ATOM     47  CA  LYS A   7      27.515  53.136   8.377  1.00 16.32           C  
ATOM     48  C   LYS A   7      27.392  51.849   7.580  1.00 16.14           C  
ATOM     49  O   LYS A   7      26.438  51.088   7.736  1.00 15.95           O  
ATOM     50  CB  LYS A   7      28.270  52.861   9.675  1.00 15.81           C  
ATOM     51  CG  LYS A   7      28.552  54.086  10.524  1.00 16.68           C  
ATOM     52  CD  LYS A   7      29.367  53.720  11.763  1.00 17.07           C  
ATOM     53  CE  LYS A   7      29.625  54.967  12.607  1.00 19.85           C  
ATOM     54  NZ  LYS A   7      30.542  54.683  13.737  1.00 25.84           N  
ATOM     55  N   ARG A   8      28.365  51.610   6.717  1.00 16.37           N  
ATOM     56  CA  ARG A   8      28.386  50.394   5.917  1.00 16.40           C  
ATOM     57  C   ARG A   8      29.197  49.340   6.668  1.00 14.93           C  
ATOM     58  O   ARG A   8      30.253  49.656   7.234  1.00 15.24           O  
ATOM     59  CB  ARG A   8      28.953  50.680   4.525  1.00 17.07           C  
ATOM     60  CG  ARG A   8      28.292  51.895   3.872  1.00 20.43           C  
ATOM     61  CD  ARG A   8      28.023  51.709   2.389  1.00 25.82           C  
ATOM     62  NE  ARG A   8      26.599  51.493   2.116  1.00 29.32           N  
ATOM     63  CZ  ARG A   8      26.094  50.415   1.524  1.00 30.39           C  
ATOM     64  NH1 ARG A   8      26.887  49.435   1.122  1.00 30.84           N  
ATOM     65  NH2 ARG A   8      24.787  50.320   1.324  1.00 32.37           N  
ATOM     66  N   PRO A   9      28.694  48.089   6.708  1.00 13.76           N  
ATOM     67  CA  PRO A   9      29.383  46.986   7.382  1.00 12.78           C  
ATOM     68  C   PRO A   9      30.546  46.370   6.572  1.00 12.03           C  
ATOM     69  O   PRO A   9      30.857  45.186   6.718  1.00 11.91           O  
ATOM     70  CB  PRO A   9      28.265  45.969   7.605  1.00 12.76           C  
ATOM     71  CG  PRO A   9      27.367  46.170   6.431  1.00 13.28           C  
ATOM     72  CD  PRO A   9      27.414  47.646   6.113  1.00 13.43           C  
ATOM     73  N   VAL A  10      31.147  47.186   5.719  1.00 11.94           N  
ATOM     74  CA  VAL A  10      32.383  46.873   5.021  1.00 12.64           C  
ATOM     75  C   VAL A  10      33.293  48.056   5.342  1.00 12.07           C  
ATOM     76  O   VAL A  10      32.947  49.196   5.049  1.00 13.00           O  
ATOM     77  CB  VAL A  10      32.150  46.769   3.502  1.00 12.86           C  
ATOM     78  CG1 VAL A  10      33.478  46.647   2.762  1.00 13.91           C  
ATOM     79  CG2 VAL A  10      31.239  45.588   3.167  1.00 12.64           C  
ATOM     80  N   SER A  11      34.442  47.785   5.955  1.00 11.96           N  
ATOM     81  CA  SER A  11      35.253  48.852   6.556  1.00 11.99           C  
ATOM     82  C   SER A  11      36.737  48.648   6.303  1.00 11.08           C  
ATOM     83  O   SER A  11      37.136  47.599   5.790  1.00 11.13           O  
ATOM     84  CB  SER A  11      34.978  48.891   8.065  1.00 12.21           C  
ATOM     85  OG  SER A  11      35.467  47.717   8.689  1.00 15.33           O  
ATOM     86  N   ILE A  12      37.536  49.656   6.667  1.00 10.71           N  
ATOM     87  CA  ILE A  12      38.998  49.572   6.659  1.00 10.99           C  
ATOM     88  C   ILE A  12      39.549  49.920   8.049  1.00 10.81           C  
ATOM     89  O   ILE A  12      38.857  50.535   8.882  1.00  9.55           O  
ATOM     90  CB  ILE A  12      39.648  50.453   5.530  1.00 10.83           C  
ATOM     91  CG1 ILE A  12      39.199  51.914   5.601  1.00 11.68           C  
ATOM     92  CG2 ILE A  12      39.289  49.908   4.138  1.00 10.44           C  
ATOM     93  CD1 ILE A  12      39.879  52.778   6.618  1.00 13.77           C  
ATOM     94  N   LEU A  13      40.772  49.468   8.288  1.00 11.14           N  
ATOM     95  CA  LEU A  13      41.548  49.775   9.471  1.00 11.85           C  
ATOM     96  C   LEU A  13      42.929  50.199   8.974  1.00 11.89           C  
ATOM     97  O   LEU A  13      43.550  49.503   8.162  1.00 11.73           O  
ATOM     98  CB  LEU A  13      41.675  48.533  10.363  1.00 12.29           C  
ATOM     99  CG  LEU A  13      42.702  48.598  11.508  1.00 13.13           C  
ATOM    100  CD1 LEU A  13      42.154  49.426  12.639  1.00 12.10           C  
ATOM    101  CD2 LEU A  13      43.089  47.196  11.974  1.00 13.64           C  
ATOM    102  N   VAL A  14      43.393  51.352   9.429  1.00 12.26           N  
ATOM    103  CA  VAL A  14      44.764  51.758   9.102  1.00 11.74           C  
ATOM    104  C   VAL A  14      45.549  51.909  10.399  1.00 11.93           C  
ATOM    105  O   VAL A  14      45.314  52.849  11.169  1.00 11.69           O  
ATOM    106  CB  VAL A  14      44.814  53.061   8.292  1.00 11.80           C  
ATOM    107  CG1 VAL A  14      46.264  53.348   7.855  1.00 12.86           C  
ATOM    108  CG2 VAL A  14      43.874  52.993   7.075  1.00 11.44           C  
ATOM    109  N   VAL A  15      46.488  50.988  10.618  1.00 11.89           N  
ATOM    110  CA  VAL A  15      47.382  51.061  11.763  1.00 12.60           C  
ATOM    111  C   VAL A  15      48.506  52.036  11.438  1.00 12.59           C  
ATOM    112  O   VAL A  15      49.418  51.730  10.674  1.00 12.76           O  
ATOM    113  CB  VAL A  15      47.962  49.684  12.164  1.00 12.83           C  
ATOM    114  CG1 VAL A  15      48.939  49.838  13.332  1.00 13.33           C  
ATOM    115  CG2 VAL A  15      46.846  48.723  12.541  1.00 13.43           C  
ATOM    116  N   ILE A  16      48.407  53.219  12.032  1.00 12.65           N  
ATOM    117  CA  ILE A  16      49.434  54.250  11.904  1.00 12.54           C  
ATOM    118  C   ILE A  16      50.457  54.096  13.012  1.00 12.57           C  
ATOM    119  O   ILE A  16      50.106  54.033  14.201  1.00 12.58           O  
ATOM    120  CB  ILE A  16      48.814  55.666  11.949  1.00 12.50           C  
ATOM    121  CG1 ILE A  16      47.796  55.825  10.813  1.00 13.07           C  
ATOM    122  CG2 ILE A  16      49.916  56.760  11.901  1.00 12.78           C  
ATOM    123  CD1 ILE A  16      46.935  57.086  10.901  1.00 12.42           C  
ATOM    124  N   TYR A  17      51.722  54.026  12.613  1.00 12.92           N  
ATOM    125  CA  TYR A  17      52.817  54.013  13.583  1.00 13.23           C  
ATOM    126  C   TYR A  17      54.018  54.840  13.109  1.00 13.60           C  
ATOM    127  O   TYR A  17      54.064  55.286  11.958  1.00 13.41           O  
ATOM    128  CB  TYR A  17      53.208  52.569  13.912  1.00 13.74           C  
ATOM    129  CG  TYR A  17      53.869  51.822  12.778  1.00 14.01           C  
ATOM    130  CD1 TYR A  17      53.110  51.184  11.798  1.00 15.36           C  
ATOM    131  CD2 TYR A  17      55.260  51.751  12.686  1.00 15.77           C  
ATOM    132  CE1 TYR A  17      53.719  50.489  10.754  1.00 15.84           C  
ATOM    133  CE2 TYR A  17      55.873  51.067  11.654  1.00 16.34           C  
ATOM    134  CZ  TYR A  17      55.103  50.440  10.690  1.00 16.09           C  
ATOM    135  OH  TYR A  17      55.734  49.765   9.664  1.00 15.71           O  
ATOM    136  N   ALA A  18      54.968  55.065  14.018  1.00 13.32           N  
ATOM    137  CA  ALA A  18      56.203  55.760  13.697  1.00 13.50           C  
ATOM    138  C   ALA A  18      57.335  54.758  13.465  1.00 13.61           C  
ATOM    139  O   ALA A  18      57.635  53.924  14.331  1.00 13.19           O  
ATOM    140  CB  ALA A  18      56.559  56.727  14.804  1.00 12.79           C  
ATOM    141  N   GLN A  19      57.945  54.833  12.292  1.00 14.07           N  
ATOM    142  CA  GLN A  19      59.056  53.938  11.949  1.00 15.24           C  
ATOM    143  C   GLN A  19      60.238  54.064  12.918  1.00 15.35           C  
ATOM    144  O   GLN A  19      60.916  53.066  13.227  1.00 16.01           O  
ATOM    145  CB  GLN A  19      59.521  54.179  10.510  1.00 15.74           C  
ATOM    146  CG  GLN A  19      60.793  53.408  10.098  1.00 17.37           C  
ATOM    147  CD  GLN A  19      60.650  51.885  10.187  1.00 19.47           C  
ATOM    148  OE1 GLN A  19      61.646  51.166  10.327  1.00 21.07           O  
ATOM    149  NE2 GLN A  19      59.421  51.391  10.088  1.00 19.18           N  
ATOM    150  N   ASP A  20      60.490  55.279  13.390  1.00 14.89           N  
ATOM    151  CA  ASP A  20      61.669  55.511  14.237  1.00 14.19           C  
ATOM    152  C   ASP A  20      61.504  54.953  15.659  1.00 13.63           C  
ATOM    153  O   ASP A  20      62.351  54.182  16.111  1.00 12.75           O  
ATOM    154  CB  ASP A  20      62.134  56.974  14.199  1.00 14.61           C  
ATOM    155  CG  ASP A  20      61.147  57.947  14.810  1.00 15.22           C  
ATOM    156  OD1 ASP A  20      59.977  57.581  15.059  1.00 14.89           O  
ATOM    157  OD2 ASP A  20      61.562  59.112  15.031  1.00 16.05           O  
ATOM    158  N   THR A  21      60.386  55.278  16.314  1.00 12.57           N  
ATOM    159  CA  THR A  21      60.123  54.836  17.696  1.00 12.48           C  
ATOM    160  C   THR A  21      59.355  53.520  17.805  1.00 12.75           C  
ATOM    161  O   THR A  21      59.351  52.890  18.872  1.00 12.65           O  
ATOM    162  CB  THR A  21      59.332  55.892  18.518  1.00 12.38           C  
ATOM    163  OG1 THR A  21      57.998  56.018  18.000  1.00 11.53           O  
ATOM    164  CG2 THR A  21      60.038  57.257  18.519  1.00 11.80           C  
ATOM    165  N   LYS A  22      58.697  53.126  16.713  1.00 12.55           N  
ATOM    166  CA  LYS A  22      57.736  52.009  16.683  1.00 12.99           C  
ATOM    167  C   LYS A  22      56.521  52.204  17.607  1.00 13.33           C  
ATOM    168  O   LYS A  22      55.856  51.238  17.976  1.00 13.39           O  
ATOM    169  CB  LYS A  22      58.397  50.644  16.941  1.00 13.36           C  
ATOM    170  CG  LYS A  22      59.617  50.326  16.071  1.00 13.16           C  
ATOM    171  CD  LYS A  22      59.280  50.224  14.583  1.00 14.16           C  
ATOM    172  CE  LYS A  22      60.502  49.783  13.771  1.00 14.78           C  
ATOM    173  NZ  LYS A  22      61.717  50.550  14.154  1.00 16.20           N  
ATOM    174  N   ARG A  23      56.235  53.447  17.974  1.00 13.15           N  
ATOM    175  CA  ARG A  23      55.027  53.708  18.745  1.00 12.61           C  
ATOM    176  C   ARG A  23      53.850  53.802  17.782  1.00 12.35           C  
ATOM    177  O   ARG A  23      54.016  54.178  16.616  1.00 11.69           O  
ATOM    178  CB  ARG A  23      55.152  54.959  19.621  1.00 13.40           C  
ATOM    179  CG  ARG A  23      56.122  54.823  20.825  1.00 11.92           C  
ATOM    180  CD  ARG A  23      55.850  55.898  21.870  1.00 13.10           C  
ATOM    181  NE  ARG A  23      56.838  55.973  22.943  1.00 14.48           N  
ATOM    182  CZ  ARG A  23      58.022  56.577  22.838  1.00 15.30           C  
ATOM    183  NH1 ARG A  23      58.392  57.151  21.696  1.00 15.34           N  
ATOM    184  NH2 ARG A  23      58.853  56.597  23.878  1.00 15.44           N  
ATOM    185  N   VAL A  24      52.681  53.443  18.302  1.00 11.70           N  
ATOM    186  CA  VAL A  24      51.420  53.353  17.558  1.00 11.37           C  
ATOM    187  C   VAL A  24      50.521  54.517  17.960  1.00 11.51           C  
ATOM    188  O   VAL A  24      50.401  54.859  19.149  1.00 10.65           O  
ATOM    189  CB  VAL A  24      50.716  52.012  17.840  1.00 11.07           C  
ATOM    190  CG1 VAL A  24      49.364  51.907  17.100  1.00 10.61           C  
ATOM    191  CG2 VAL A  24      51.644  50.829  17.464  1.00 10.59           C  
ATOM    192  N   LEU A  25      49.912  55.126  16.945  1.00 12.03           N  
ATOM    193  CA  LEU A  25      49.006  56.248  17.119  1.00 12.69           C  
ATOM    194  C   LEU A  25      47.628  55.745  17.559  1.00 12.72           C  
ATOM    195  O   LEU A  25      46.932  55.123  16.783  1.00 12.55           O  
ATOM    196  CB  LEU A  25      48.862  57.009  15.793  1.00 12.53           C  
ATOM    197  CG  LEU A  25      48.608  58.531  15.767  1.00 15.04           C  
ATOM    198  CD1 LEU A  25      47.743  58.928  14.571  1.00 11.14           C  
ATOM    199  CD2 LEU A  25      48.078  59.154  17.053  1.00 14.23           C  
ATOM    200  N   MET A  26      47.252  56.025  18.803  1.00 13.34           N  
ATOM    201  CA  MET A  26      45.954  55.589  19.321  1.00 13.33           C  
ATOM    202  C   MET A  26      45.026  56.784  19.543  1.00 13.71           C  
ATOM    203  O   MET A  26      45.447  57.837  20.031  1.00 13.98           O  
ATOM    204  CB  MET A  26      46.132  54.734  20.580  1.00 13.88           C  
ATOM    205  CG  MET A  26      46.938  53.439  20.309  1.00 14.66           C  
ATOM    206  SD  MET A  26      46.190  52.388  19.038  1.00 18.13           S  
ATOM    207  CE  MET A  26      44.864  51.656  20.005  1.00 17.23           C  
ATOM    208  N   LEU A  27      43.770  56.616  19.135  1.00 13.61           N  
ATOM    209  CA  LEU A  27      42.812  57.708  19.065  1.00 13.34           C  
ATOM    210  C   LEU A  27      41.563  57.351  19.862  1.00 12.87           C  
ATOM    211  O   LEU A  27      40.996  56.256  19.693  1.00 13.20           O  
ATOM    212  CB  LEU A  27      42.428  57.971  17.600  1.00 14.12           C  
ATOM    213  CG  LEU A  27      43.553  58.315  16.618  1.00 13.25           C  
ATOM    214  CD1 LEU A  27      43.173  57.941  15.199  1.00 14.50           C  
ATOM    215  CD2 LEU A  27      43.904  59.793  16.709  1.00 14.30           C  
ATOM    216  N   GLN A  28      41.123  58.297  20.685  1.00 12.66           N  
ATOM    217  CA  GLN A  28      39.990  58.122  21.584  1.00 12.71           C  
ATOM    218  C   GLN A  28      38.665  58.455  20.890  1.00 12.42           C  
ATOM    219  O   GLN A  28      38.419  59.590  20.477  1.00 11.63           O  
ATOM    220  CB  GLN A  28      40.174  58.956  22.862  1.00 12.84           C  
ATOM    221  CG  GLN A  28      39.111  58.691  23.945  1.00 12.30           C  
ATOM    222  CD  GLN A  28      39.184  59.646  25.138  1.00 13.52           C  
ATOM    223  OE1 GLN A  28      39.713  60.751  25.051  1.00 13.55           O  
ATOM    224  NE2 GLN A  28      38.622  59.218  26.252  1.00 13.58           N  
ATOM    225  N   ARG A  29      37.808  57.449  20.761  1.00 12.31           N  
ATOM    226  CA  ARG A  29      36.514  57.636  20.088  1.00 12.41           C  
ATOM    227  C   ARG A  29      35.572  58.569  20.846  1.00 12.60           C  
ATOM    228  O   ARG A  29      35.643  58.682  22.061  1.00 12.88           O  
ATOM    229  CB  ARG A  29      35.832  56.285  19.812  1.00 11.85           C  
ATOM    230  CG  ARG A  29      36.553  55.439  18.780  1.00 12.30           C  
ATOM    231  CD  ARG A  29      35.816  54.145  18.452  1.00 13.67           C  
ATOM    232  NE  ARG A  29      34.519  54.361  17.800  1.00 14.72           N  
ATOM    233  CZ  ARG A  29      34.311  54.314  16.480  1.00 18.14           C  
ATOM    234  NH1 ARG A  29      35.309  54.085  15.631  1.00 18.90           N  
ATOM    235  NH2 ARG A  29      33.087  54.501  15.993  1.00 17.90           N  
ATOM    236  N   ARG A  30      34.696  59.234  20.098  1.00 13.36           N  
ATOM    237  CA  ARG A  30      33.754  60.191  20.673  1.00 14.24           C  
ATOM    238  C   ARG A  30      32.400  59.550  21.000  1.00 14.08           C  
ATOM    239  O   ARG A  30      31.642  60.123  21.765  1.00 14.90           O  
ATOM    240  CB  ARG A  30      33.573  61.395  19.753  1.00 14.68           C  
ATOM    241  CG  ARG A  30      32.741  61.114  18.513  1.00 15.95           C  
ATOM    242  CD  ARG A  30      32.500  62.375  17.701  1.00 20.87           C  
ATOM    243  NE  ARG A  30      32.062  62.035  16.350  1.00 24.15           N  
ATOM    244  CZ  ARG A  30      32.293  62.777  15.271  1.00 26.59           C  
ATOM    245  NH1 ARG A  30      32.958  63.922  15.368  1.00 27.23           N  
ATOM    246  NH2 ARG A  30      31.859  62.362  14.086  1.00 28.48           N  
ATOM    247  N   ASP A  31      32.125  58.375  20.421  1.00 14.19           N  
ATOM    248  CA  ASP A  31      30.910  57.607  20.717  1.00 14.21           C  
ATOM    249  C   ASP A  31      31.075  56.718  21.954  1.00 14.23           C  
ATOM    250  O   ASP A  31      30.191  56.663  22.809  1.00 13.81           O  
ATOM    251  CB  ASP A  31      30.388  56.825  19.494  1.00 14.17           C  
ATOM    252  CG  ASP A  31      31.426  55.907  18.848  1.00 15.08           C  
ATOM    253  OD1 ASP A  31      32.580  55.780  19.326  1.00 15.53           O  
ATOM    254  OD2 ASP A  31      31.076  55.299  17.815  1.00 14.79           O  
ATOM    255  N   ASP A  32      32.234  56.064  22.045  1.00 13.98           N  
ATOM    256  CA  ASP A  32      32.642  55.267  23.196  1.00 13.83           C  
ATOM    257  C   ASP A  32      34.024  55.771  23.646  1.00 13.70           C  
ATOM    258  O   ASP A  32      35.044  55.307  23.137  1.00 13.24           O  
ATOM    259  CB  ASP A  32      32.714  53.784  22.792  1.00 13.57           C  
ATOM    260  CG  ASP A  32      33.152  52.861  23.927  1.00 14.04           C  
ATOM    261  OD1 ASP A  32      33.596  53.343  24.991  1.00 15.07           O  
ATOM    262  OD2 ASP A  32      33.088  51.623  23.724  1.00 14.88           O  
ATOM    263  N   PRO A  33      34.061  56.739  24.587  1.00 13.87           N  
ATOM    264  CA  PRO A  33      35.333  57.304  25.075  1.00 14.23           C  
ATOM    265  C   PRO A  33      36.302  56.311  25.721  1.00 14.49           C  
ATOM    266  O   PRO A  33      37.469  56.654  25.950  1.00 14.94           O  
ATOM    267  CB  PRO A  33      34.875  58.356  26.101  1.00 13.67           C  
ATOM    268  CG  PRO A  33      33.472  58.697  25.689  1.00 14.97           C  
ATOM    269  CD  PRO A  33      32.902  57.412  25.205  1.00 14.27           C  
ATOM    270  N   ASP A  34      35.839  55.095  26.011  1.00 14.69           N  
ATOM    271  CA  ASP A  34      36.730  54.021  26.503  1.00 15.26           C  
ATOM    272  C   ASP A  34      37.453  53.258  25.380  1.00 15.24           C  
ATOM    273  O   ASP A  34      38.387  52.478  25.625  1.00 14.94           O  
ATOM    274  CB  ASP A  34      35.943  53.061  27.396  1.00 16.01           C  
ATOM    275  CG  ASP A  34      35.468  53.723  28.686  1.00 18.48           C  
ATOM    276  OD1 ASP A  34      36.234  54.506  29.292  1.00 21.86           O  
ATOM    277  OD2 ASP A  34      34.324  53.481  29.076  1.00 22.29           O  
ATOM    278  N   PHE A  35      37.042  53.531  24.149  1.00 14.12           N  
ATOM    279  CA  PHE A  35      37.477  52.780  22.986  1.00 13.96           C  
ATOM    280  C   PHE A  35      38.539  53.596  22.258  1.00 13.54           C  
ATOM    281  O   PHE A  35      38.211  54.583  21.582  1.00 12.76           O  
ATOM    282  CB  PHE A  35      36.249  52.564  22.103  1.00 13.12           C  
ATOM    283  CG  PHE A  35      36.447  51.618  20.946  1.00 13.47           C  
ATOM    284  CD1 PHE A  35      37.713  51.211  20.511  1.00 11.03           C  
ATOM    285  CD2 PHE A  35      35.321  51.145  20.261  1.00 12.96           C  
ATOM    286  CE1 PHE A  35      37.860  50.348  19.424  1.00 13.12           C  
ATOM    287  CE2 PHE A  35      35.459  50.280  19.166  1.00 13.80           C  
ATOM    288  CZ  PHE A  35      36.736  49.887  18.747  1.00 14.22           C  
ATOM    289  N   TRP A  36      39.805  53.219  22.462  1.00 13.55           N  
ATOM    290  CA  TRP A  36      40.936  53.801  21.749  1.00 13.58           C  
ATOM    291  C   TRP A  36      41.308  52.879  20.599  1.00 13.53           C  
ATOM    292  O   TRP A  36      41.261  51.668  20.743  1.00 13.58           O  
ATOM    293  CB  TRP A  36      42.145  53.967  22.673  1.00 14.10           C  
ATOM    294  CG  TRP A  36      41.931  54.970  23.780  1.00 14.49           C  
ATOM    295  CD1 TRP A  36      41.163  54.818  24.893  1.00 15.06           C  
ATOM    296  CD2 TRP A  36      42.530  56.268  23.877  1.00 16.15           C  
ATOM    297  NE1 TRP A  36      41.230  55.955  25.678  1.00 16.13           N  
ATOM    298  CE2 TRP A  36      42.057  56.862  25.067  1.00 15.82           C  
ATOM    299  CE3 TRP A  36      43.402  56.996  23.055  1.00 15.66           C  
ATOM    300  CZ2 TRP A  36      42.442  58.143  25.471  1.00 14.61           C  
ATOM    301  CZ3 TRP A  36      43.787  58.278  23.463  1.00 15.84           C  
ATOM    302  CH2 TRP A  36      43.299  58.835  24.652  1.00 14.75           C  
ATOM    303  N   GLN A  37      41.715  53.459  19.476  1.00 12.76           N  
ATOM    304  CA  GLN A  37      41.872  52.700  18.239  1.00 12.85           C  
ATOM    305  C   GLN A  37      42.793  53.401  17.252  1.00 12.61           C  
ATOM    306  O   GLN A  37      43.049  54.606  17.347  1.00 13.23           O  
ATOM    307  CB  GLN A  37      40.493  52.534  17.564  1.00 12.12           C  
ATOM    308  CG  GLN A  37      39.794  53.890  17.319  1.00 14.19           C  
ATOM    309  CD  GLN A  37      38.731  53.854  16.233  1.00 13.86           C  
ATOM    310  OE1 GLN A  37      38.200  54.900  15.840  1.00 15.58           O  
ATOM    311  NE2 GLN A  37      38.401  52.654  15.747  1.00 13.76           N  
ATOM    312  N   SER A  38      43.249  52.625  16.277  1.00 12.78           N  
ATOM    313  CA  SER A  38      43.802  53.147  15.034  1.00 13.00           C  
ATOM    314  C   SER A  38      42.654  53.734  14.194  1.00 13.36           C  
ATOM    315  O   SER A  38      41.501  53.781  14.629  1.00 13.53           O  
ATOM    316  CB  SER A  38      44.517  52.016  14.276  1.00 12.98           C  
ATOM    317  OG  SER A  38      45.512  51.374  15.085  1.00 13.89           O  
ATOM    318  N   VAL A  39      42.969  54.194  12.993  1.00 12.86           N  
ATOM    319  CA  VAL A  39      41.968  54.797  12.111  1.00 13.13           C  
ATOM    320  C   VAL A  39      41.047  53.720  11.518  1.00 12.74           C  
ATOM    321  O   VAL A  39      41.505  52.702  11.003  1.00 12.00           O  
ATOM    322  CB  VAL A  39      42.663  55.623  11.007  1.00 13.31           C  
ATOM    323  CG1 VAL A  39      41.722  55.960   9.841  1.00 13.97           C  
ATOM    324  CG2 VAL A  39      43.278  56.883  11.607  1.00 13.51           C  
ATOM    325  N   THR A  40      39.742  53.934  11.633  1.00 12.61           N  
ATOM    326  CA  THR A  40      38.773  53.048  10.982  1.00 12.94           C  
ATOM    327  C   THR A  40      37.712  53.837  10.213  1.00 12.78           C  
ATOM    328  O   THR A  40      37.481  55.024  10.474  1.00 12.93           O  
ATOM    329  CB  THR A  40      38.029  52.137  11.994  1.00 13.03           C  
ATOM    330  OG1 THR A  40      37.318  52.940  12.953  1.00 12.64           O  
ATOM    331  CG2 THR A  40      38.967  51.196  12.707  1.00 13.41           C  
ATOM    332  N   GLY A  41      37.051  53.169   9.273  1.00 12.74           N  
ATOM    333  CA  GLY A  41      35.882  53.770   8.635  1.00 12.82           C  
ATOM    334  C   GLY A  41      35.249  52.877   7.587  1.00 13.33           C  
ATOM    335  O   GLY A  41      35.834  51.878   7.184  1.00 12.78           O  
ATOM    336  N   SER A  42      34.052  53.254   7.153  1.00 13.57           N  
ATOM    337  CA  SER A  42      33.311  52.530   6.103  1.00 14.41           C  
ATOM    338  C   SER A  42      33.904  52.727   4.719  1.00 14.36           C  
ATOM    339  O   SER A  42      34.369  53.822   4.391  1.00 14.56           O  
ATOM    340  CB  SER A  42      31.857  53.012   6.066  1.00 14.47           C  
ATOM    341  OG  SER A  42      31.146  52.564   7.205  1.00 16.71           O  
ATOM    342  N   VAL A  43      33.871  51.662   3.911  1.00 14.29           N  
ATOM    343  CA  VAL A  43      34.123  51.767   2.474  1.00 14.81           C  
ATOM    344  C   VAL A  43      32.796  52.175   1.839  1.00 15.43           C  
ATOM    345  O   VAL A  43      31.832  51.393   1.831  1.00 16.43           O  
ATOM    346  CB  VAL A  43      34.623  50.443   1.863  1.00 14.40           C  
ATOM    347  CG1 VAL A  43      34.887  50.600   0.359  1.00 13.32           C  
ATOM    348  CG2 VAL A  43      35.869  49.940   2.572  1.00 13.57           C  
ATOM    349  N   GLU A  44      32.737  53.401   1.330  1.00 16.25           N  
ATOM    350  CA  GLU A  44      31.491  53.944   0.811  1.00 16.97           C  
ATOM    351  C   GLU A  44      31.254  53.473  -0.626  1.00 16.64           C  
ATOM    352  O   GLU A  44      32.192  53.106  -1.338  1.00 15.46           O  
ATOM    353  CB  GLU A  44      31.473  55.478   0.890  1.00 17.93           C  
ATOM    354  CG  GLU A  44      31.614  56.057   2.314  1.00 20.64           C  
ATOM    355  CD  GLU A  44      30.348  55.912   3.160  1.00 25.31           C  
ATOM    356  OE1 GLU A  44      29.233  55.856   2.590  1.00 28.36           O  
ATOM    357  OE2 GLU A  44      30.462  55.869   4.409  1.00 27.32           O  
ATOM    358  N   GLU A  45      29.991  53.478  -1.039  1.00 17.01           N  
ATOM    359  CA  GLU A  45      29.641  53.188  -2.423  1.00 17.38           C  
ATOM    360  C   GLU A  45      30.496  54.026  -3.362  1.00 17.04           C  
ATOM    361  O   GLU A  45      30.632  55.232  -3.173  1.00 18.27           O  
ATOM    362  CB  GLU A  45      28.161  53.499  -2.667  1.00 17.55           C  
ATOM    363  CG  GLU A  45      27.633  53.015  -4.002  1.00 19.97           C  
ATOM    364  CD  GLU A  45      27.115  51.593  -3.951  1.00 23.32           C  
ATOM    365  OE1 GLU A  45      27.167  50.988  -2.854  1.00 26.18           O  
ATOM    366  OE2 GLU A  45      26.649  51.085  -4.999  1.00 22.90           O  
ATOM    367  N   GLY A  46      31.093  53.382  -4.358  1.00 16.59           N  
ATOM    368  CA  GLY A  46      31.851  54.090  -5.376  1.00 15.33           C  
ATOM    369  C   GLY A  46      33.329  54.232  -5.079  1.00 14.76           C  
ATOM    370  O   GLY A  46      34.076  54.724  -5.914  1.00 15.04           O  
ATOM    371  N   GLU A  47      33.762  53.823  -3.890  1.00 13.85           N  
ATOM    372  CA  GLU A  47      35.199  53.803  -3.599  1.00 13.57           C  
ATOM    373  C   GLU A  47      35.698  52.394  -3.315  1.00 12.10           C  
ATOM    374  O   GLU A  47      34.919  51.497  -2.998  1.00 11.98           O  
ATOM    375  CB  GLU A  47      35.586  54.782  -2.474  1.00 13.60           C  
ATOM    376  CG  GLU A  47      35.253  54.320  -1.076  1.00 15.26           C  
ATOM    377  CD  GLU A  47      35.446  55.403  -0.010  1.00 14.71           C  
ATOM    378  OE1 GLU A  47      35.991  56.494  -0.293  1.00 15.62           O  
ATOM    379  OE2 GLU A  47      35.035  55.157   1.122  1.00 16.52           O  
ATOM    380  N   THR A  48      37.003  52.214  -3.444  1.00 11.71           N  
ATOM    381  CA  THR A  48      37.658  50.953  -3.113  1.00 11.19           C  
ATOM    382  C   THR A  48      38.198  51.031  -1.683  1.00 10.87           C  
ATOM    383  O   THR A  48      38.261  52.109  -1.100  1.00 10.85           O  
ATOM    384  CB  THR A  48      38.832  50.696  -4.051  1.00 10.43           C  
ATOM    385  OG1 THR A  48      39.827  51.699  -3.817  1.00 10.66           O  
ATOM    386  CG2 THR A  48      38.399  50.753  -5.530  1.00 10.41           C  
ATOM    387  N   ALA A  49      38.611  49.898  -1.122  1.00 11.30           N  
ATOM    388  CA  ALA A  49      39.166  49.891   0.237  1.00 11.29           C  
ATOM    389  C   ALA A  49      40.441  50.751   0.376  1.00 11.68           C  
ATOM    390  O   ALA A  49      40.543  51.524   1.323  1.00 11.54           O  
ATOM    391  CB  ALA A  49      39.391  48.455   0.726  1.00 11.85           C  
ATOM    392  N   PRO A  50      41.403  50.643  -0.568  1.00 11.86           N  
ATOM    393  CA  PRO A  50      42.572  51.540  -0.425  1.00 12.27           C  
ATOM    394  C   PRO A  50      42.187  53.029  -0.433  1.00 12.47           C  
ATOM    395  O   PRO A  50      42.734  53.813   0.348  1.00 11.97           O  
ATOM    396  CB  PRO A  50      43.438  51.183  -1.640  1.00 12.07           C  
ATOM    397  CG  PRO A  50      43.024  49.770  -1.981  1.00 12.67           C  
ATOM    398  CD  PRO A  50      41.560  49.735  -1.718  1.00 11.73           C  
ATOM    399  N   GLN A  51      41.237  53.390  -1.295  1.00 12.47           N  
ATOM    400  CA  GLN A  51      40.715  54.752  -1.378  1.00 13.20           C  
ATOM    401  C   GLN A  51      40.014  55.201  -0.105  1.00 13.23           C  
ATOM    402  O   GLN A  51      40.170  56.351   0.314  1.00 13.67           O  
ATOM    403  CB  GLN A  51      39.760  54.898  -2.562  1.00 13.20           C  
ATOM    404  CG  GLN A  51      40.442  54.885  -3.919  1.00 13.93           C  
ATOM    405  CD  GLN A  51      39.464  54.801  -5.077  1.00 13.16           C  
ATOM    406  OE1 GLN A  51      38.261  54.556  -4.901  1.00 14.44           O  
ATOM    407  NE2 GLN A  51      39.984  54.981  -6.282  1.00 14.34           N  
ATOM    408  N   ALA A  52      39.239  54.301   0.498  1.00 13.25           N  
ATOM    409  CA  ALA A  52      38.590  54.569   1.769  1.00 13.32           C  
ATOM    410  C   ALA A  52      39.631  54.787   2.852  1.00 13.25           C  
ATOM    411  O   ALA A  52      39.490  55.712   3.637  1.00 13.35           O  
ATOM    412  CB  ALA A  52      37.653  53.423   2.162  1.00 13.17           C  
ATOM    413  N   ALA A  53      40.663  53.938   2.883  1.00 13.18           N  
ATOM    414  CA  ALA A  53      41.767  54.076   3.843  1.00 13.94           C  
ATOM    415  C   ALA A  53      42.435  55.443   3.747  1.00 14.63           C  
ATOM    416  O   ALA A  53      42.700  56.080   4.771  1.00 14.34           O  
ATOM    417  CB  ALA A  53      42.794  52.959   3.666  1.00 13.72           C  
ATOM    418  N   MET A  54      42.673  55.909   2.526  1.00 15.36           N  
ATOM    419  CA  MET A  54      43.340  57.196   2.331  1.00 16.61           C  
ATOM    420  C   MET A  54      42.471  58.362   2.769  1.00 15.67           C  
ATOM    421  O   MET A  54      42.949  59.278   3.443  1.00 15.08           O  
ATOM    422  CB  MET A  54      43.807  57.373   0.880  1.00 16.54           C  
ATOM    423  CG  MET A  54      45.022  56.517   0.539  1.00 18.43           C  
ATOM    424  SD  MET A  54      45.783  56.886  -1.052  1.00 20.78           S  
ATOM    425  CE  MET A  54      44.517  56.337  -2.190  1.00 18.31           C  
ATOM    426  N   ARG A  55      41.199  58.312   2.389  1.00 15.05           N  
ATOM    427  CA  ARG A  55      40.211  59.324   2.760  1.00 15.24           C  
ATOM    428  C   ARG A  55      40.071  59.430   4.274  1.00 14.98           C  
ATOM    429  O   ARG A  55      40.121  60.527   4.819  1.00 14.81           O  
ATOM    430  CB  ARG A  55      38.852  59.009   2.114  1.00 14.73           C  
ATOM    431  CG  ARG A  55      37.728  59.993   2.473  1.00 15.67           C  
ATOM    432  CD  ARG A  55      36.377  59.654   1.825  1.00 15.86           C  
ATOM    433  NE  ARG A  55      35.974  58.265   2.067  1.00 17.54           N  
ATOM    434  CZ  ARG A  55      35.557  57.772   3.230  1.00 17.50           C  
ATOM    435  NH1 ARG A  55      35.466  58.544   4.314  1.00 17.27           N  
ATOM    436  NH2 ARG A  55      35.235  56.487   3.313  1.00 17.35           N  
ATOM    437  N   GLU A  56      39.903  58.290   4.944  1.00 14.41           N  
ATOM    438  CA  GLU A  56      39.731  58.282   6.404  1.00 14.47           C  
ATOM    439  C   GLU A  56      40.958  58.790   7.147  1.00 14.08           C  
ATOM    440  O   GLU A  56      40.822  59.492   8.142  1.00 13.69           O  
ATOM    441  CB  GLU A  56      39.348  56.895   6.923  1.00 15.03           C  
ATOM    442  CG  GLU A  56      37.905  56.489   6.612  1.00 16.04           C  
ATOM    443  CD  GLU A  56      36.870  57.254   7.431  1.00 16.85           C  
ATOM    444  OE1 GLU A  56      37.241  58.066   8.299  1.00 20.27           O  
ATOM    445  OE2 GLU A  56      35.673  57.039   7.208  1.00 19.94           O  
ATOM    446  N   VAL A  57      42.149  58.422   6.671  1.00 13.17           N  
ATOM    447  CA  VAL A  57      43.401  58.913   7.278  1.00 13.15           C  
ATOM    448  C   VAL A  57      43.446  60.451   7.191  1.00 13.33           C  
ATOM    449  O   VAL A  57      43.762  61.136   8.174  1.00 12.76           O  
ATOM    450  CB  VAL A  57      44.646  58.247   6.632  1.00 12.80           C  
ATOM    451  CG1 VAL A  57      45.963  58.893   7.114  1.00 13.19           C  
ATOM    452  CG2 VAL A  57      44.661  56.745   6.933  1.00 13.38           C  
ATOM    453  N   LYS A  58      43.087  60.975   6.022  1.00 13.79           N  
ATOM    454  CA  LYS A  58      43.013  62.418   5.792  1.00 15.19           C  
ATOM    455  C   LYS A  58      41.929  63.097   6.636  1.00 15.75           C  
ATOM    456  O   LYS A  58      42.172  64.149   7.252  1.00 15.58           O  
ATOM    457  CB  LYS A  58      42.794  62.717   4.303  1.00 14.97           C  
ATOM    458  CG  LYS A  58      42.938  64.197   3.945  1.00 15.93           C  
ATOM    459  CD  LYS A  58      42.785  64.465   2.452  1.00 16.07           C  
ATOM    460  CE  LYS A  58      43.171  65.911   2.146  1.00 17.54           C  
ATOM    461  NZ  LYS A  58      43.141  66.221   0.694  1.00 18.72           N  
ATOM    462  N   GLU A  59      40.743  62.496   6.660  1.00 16.07           N  
ATOM    463  CA  GLU A  59      39.594  63.059   7.379  1.00 17.03           C  
ATOM    464  C   GLU A  59      39.786  63.028   8.893  1.00 16.57           C  
ATOM    465  O   GLU A  59      39.477  64.001   9.588  1.00 17.19           O  
ATOM    466  CB  GLU A  59      38.305  62.321   6.993  1.00 17.06           C  
ATOM    467  CG  GLU A  59      37.726  62.702   5.628  1.00 18.13           C  
ATOM    468  CD  GLU A  59      36.447  61.939   5.293  1.00 18.58           C  
ATOM    469  OE1 GLU A  59      36.028  61.064   6.081  1.00 22.43           O  
ATOM    470  OE2 GLU A  59      35.858  62.211   4.236  1.00 20.85           O  
ATOM    471  N   GLU A  60      40.319  61.922   9.398  1.00 16.27           N  
ATOM    472  CA  GLU A  60      40.423  61.722  10.840  1.00 16.19           C  
ATOM    473  C   GLU A  60      41.677  62.299  11.499  1.00 15.55           C  
ATOM    474  O   GLU A  60      41.603  62.761  12.629  1.00 15.25           O  
ATOM    475  CB  GLU A  60      40.298  60.252  11.201  1.00 16.37           C  
ATOM    476  CG  GLU A  60      38.951  59.633  10.842  1.00 18.98           C  
ATOM    477  CD  GLU A  60      38.703  58.326  11.556  1.00 21.92           C  
ATOM    478  OE1 GLU A  60      39.656  57.550  11.756  1.00 24.77           O  
ATOM    479  OE2 GLU A  60      37.544  58.075  11.930  1.00 26.25           O  
ATOM    480  N   VAL A  61      42.824  62.229  10.821  1.00 15.43           N  
ATOM    481  CA  VAL A  61      44.090  62.669  11.431  1.00 15.14           C  
ATOM    482  C   VAL A  61      44.878  63.643  10.560  1.00 15.41           C  
ATOM    483  O   VAL A  61      46.045  63.944  10.849  1.00 14.96           O  
ATOM    484  CB  VAL A  61      44.997  61.477  11.878  1.00 15.05           C  
ATOM    485  CG1 VAL A  61      44.290  60.621  12.911  1.00 14.46           C  
ATOM    486  CG2 VAL A  61      45.447  60.627  10.686  1.00 15.06           C  
ATOM    487  N   THR A  62      44.233  64.121   9.493  1.00 15.61           N  
ATOM    488  CA  THR A  62      44.778  65.182   8.646  1.00 16.69           C  
ATOM    489  C   THR A  62      46.178  64.843   8.112  1.00 16.39           C  
ATOM    490  O   THR A  62      47.082  65.692   8.070  1.00 16.58           O  
ATOM    491  CB  THR A  62      44.758  66.558   9.373  1.00 16.63           C  
ATOM    492  OG1 THR A  62      43.638  66.624  10.271  1.00 17.54           O  
ATOM    493  CG2 THR A  62      44.659  67.711   8.369  1.00 18.28           C  
ATOM    494  N   ILE A  63      46.342  63.589   7.715  1.00 16.24           N  
ATOM    495  CA  ILE A  63      47.544  63.135   7.030  1.00 16.44           C  
ATOM    496  C   ILE A  63      47.162  62.734   5.620  1.00 16.87           C  
ATOM    497  O   ILE A  63      46.285  61.894   5.400  1.00 16.46           O  
ATOM    498  CB  ILE A  63      48.229  61.970   7.769  1.00 16.59           C  
ATOM    499  CG1 ILE A  63      48.783  62.451   9.110  1.00 16.00           C  
ATOM    500  CG2 ILE A  63      49.326  61.327   6.910  1.00 17.47           C  
ATOM    501  CD1 ILE A  63      49.088  61.320  10.072  1.00 16.48           C  
ATOM    502  N   ASP A  64      47.813  63.375   4.661  1.00 17.40           N  
ATOM    503  CA  ASP A  64      47.542  63.132   3.266  1.00 17.75           C  
ATOM    504  C   ASP A  64      48.635  62.210   2.743  1.00 17.83           C  
ATOM    505  O   ASP A  64      49.758  62.648   2.495  1.00 17.71           O  
ATOM    506  CB  ASP A  64      47.519  64.473   2.526  1.00 17.90           C  
ATOM    507  CG  ASP A  64      46.973  64.361   1.126  1.00 17.96           C  
ATOM    508  OD1 ASP A  64      47.248  63.345   0.452  1.00 18.91           O  
ATOM    509  OD2 ASP A  64      46.273  65.300   0.697  1.00 18.70           O  
ATOM    510  N   VAL A  65      48.301  60.930   2.605  1.00 18.24           N  
ATOM    511  CA  VAL A  65      49.259  59.888   2.224  1.00 18.99           C  
ATOM    512  C   VAL A  65      49.855  60.155   0.837  1.00 19.21           C  
ATOM    513  O   VAL A  65      51.073  60.071   0.647  1.00 19.10           O  
ATOM    514  CB  VAL A  65      48.611  58.472   2.296  1.00 18.93           C  
ATOM    515  CG1 VAL A  65      49.530  57.408   1.690  1.00 19.67           C  
ATOM    516  CG2 VAL A  65      48.275  58.109   3.742  1.00 18.90           C  
ATOM    517  N   VAL A  66      48.993  60.496  -0.112  1.00 19.35           N  
ATOM    518  CA  VAL A  66      49.423  60.826  -1.471  1.00 19.94           C  
ATOM    519  C   VAL A  66      50.336  62.064  -1.473  1.00 20.11           C  
ATOM    520  O   VAL A  66      51.401  62.058  -2.101  1.00 20.52           O  
ATOM    521  CB  VAL A  66      48.213  61.004  -2.424  1.00 19.67           C  
ATOM    522  CG1 VAL A  66      48.662  61.512  -3.788  1.00 20.29           C  
ATOM    523  CG2 VAL A  66      47.469  59.696  -2.590  1.00 20.25           C  
ATOM    524  N   ALA A  67      49.939  63.106  -0.746  1.00 20.42           N  
ATOM    525  CA  ALA A  67      50.713  64.347  -0.704  1.00 20.45           C  
ATOM    526  C   ALA A  67      52.064  64.193  -0.010  1.00 20.75           C  
ATOM    527  O   ALA A  67      53.045  64.838  -0.391  1.00 20.89           O  
ATOM    528  CB  ALA A  67      49.911  65.460  -0.058  1.00 20.73           C  
ATOM    529  N   GLU A  68      52.122  63.344   1.010  1.00 20.47           N  
ATOM    530  CA  GLU A  68      53.372  63.131   1.736  1.00 20.78           C  
ATOM    531  C   GLU A  68      54.245  62.040   1.108  1.00 20.62           C  
ATOM    532  O   GLU A  68      55.353  61.780   1.577  1.00 20.85           O  
ATOM    533  CB  GLU A  68      53.097  62.839   3.215  1.00 20.79           C  
ATOM    534  CG  GLU A  68      52.607  64.043   3.989  1.00 21.75           C  
ATOM    535  CD  GLU A  68      52.648  63.837   5.488  1.00 23.55           C  
ATOM    536  OE1 GLU A  68      53.564  63.133   5.975  1.00 24.50           O  
ATOM    537  OE2 GLU A  68      51.776  64.400   6.184  1.00 22.85           O  
ATOM    538  N   GLN A  69      53.737  61.420   0.044  1.00 20.85           N  
ATOM    539  CA  GLN A  69      54.408  60.318  -0.651  1.00 21.06           C  
ATOM    540  C   GLN A  69      54.778  59.179   0.308  1.00 21.11           C  
ATOM    541  O   GLN A  69      55.826  58.540   0.174  1.00 20.96           O  
ATOM    542  CB  GLN A  69      55.617  60.823  -1.452  1.00 21.29           C  
ATOM    543  CG  GLN A  69      55.267  61.928  -2.443  1.00 21.68           C  
ATOM    544  CD  GLN A  69      56.488  62.570  -3.080  1.00 21.73           C  
ATOM    545  OE1 GLN A  69      56.599  62.631  -4.305  1.00 22.84           O  
ATOM    546  NE2 GLN A  69      57.412  63.056  -2.251  1.00 22.47           N  
ATOM    547  N   LEU A  70      53.889  58.939   1.273  1.00 21.00           N  
ATOM    548  CA  LEU A  70      54.038  57.829   2.209  1.00 21.07           C  
ATOM    549  C   LEU A  70      53.518  56.540   1.570  1.00 21.22           C  
ATOM    550  O   LEU A  70      52.850  56.577   0.534  1.00 21.13           O  
ATOM    551  CB  LEU A  70      53.332  58.136   3.539  1.00 21.03           C  
ATOM    552  CG  LEU A  70      53.831  59.383   4.278  1.00 21.15           C  
ATOM    553  CD1 LEU A  70      52.879  59.797   5.392  1.00 22.28           C  
ATOM    554  CD2 LEU A  70      55.246  59.188   4.824  1.00 21.55           C  
ATOM    555  N   THR A  71      53.862  55.400   2.162  1.00 21.18           N  
ATOM    556  CA  THR A  71      53.469  54.105   1.616  1.00 21.46           C  
ATOM    557  C   THR A  71      52.305  53.548   2.437  1.00 21.23           C  
ATOM    558  O   THR A  71      52.477  53.191   3.602  1.00 21.74           O  
ATOM    559  CB  THR A  71      54.660  53.109   1.609  1.00 21.44           C  
ATOM    560  OG1 THR A  71      55.760  53.673   0.873  1.00 22.43           O  
ATOM    561  CG2 THR A  71      54.262  51.763   0.994  1.00 21.49           C  
ATOM    562  N   LEU A  72      51.121  53.501   1.836  1.00 21.55           N  
ATOM    563  CA  LEU A  72      49.963  52.871   2.475  1.00 21.41           C  
ATOM    564  C   LEU A  72      50.095  51.372   2.233  1.00 21.25           C  
ATOM    565  O   LEU A  72      49.889  50.896   1.117  1.00 22.03           O  
ATOM    566  CB  LEU A  72      48.660  53.390   1.861  1.00 21.80           C  
ATOM    567  CG  LEU A  72      47.348  53.587   2.644  1.00 22.35           C  
ATOM    568  CD1 LEU A  72      46.184  53.101   1.794  1.00 22.79           C  
ATOM    569  CD2 LEU A  72      47.297  52.923   4.024  1.00 21.96           C  
ATOM    570  N   ILE A  73      50.467  50.629   3.268  1.00 20.57           N  
ATOM    571  CA  ILE A  73      50.717  49.201   3.113  1.00 20.35           C  
ATOM    572  C   ILE A  73      49.395  48.429   3.168  1.00 19.55           C  
ATOM    573  O   ILE A  73      48.667  48.512   4.143  1.00 18.41           O  
ATOM    574  CB  ILE A  73      51.718  48.666   4.183  1.00 20.74           C  
ATOM    575  CG1 ILE A  73      53.044  49.439   4.118  1.00 21.05           C  
ATOM    576  CG2 ILE A  73      51.947  47.160   4.007  1.00 21.40           C  
ATOM    577  CD1 ILE A  73      53.898  49.377   5.413  1.00 21.04           C  
ATOM    578  N   ASP A  74      49.084  47.703   2.097  1.00 19.30           N  
ATOM    579  CA  ASP A  74      47.937  46.800   2.107  1.00 18.84           C  
ATOM    580  C   ASP A  74      48.395  45.500   2.763  1.00 18.81           C  
ATOM    581  O   ASP A  74      49.273  44.801   2.237  1.00 18.81           O  
ATOM    582  CB  ASP A  74      47.445  46.549   0.677  1.00 18.94           C  
ATOM    583  CG  ASP A  74      46.135  45.781   0.622  1.00 19.67           C  
ATOM    584  OD1 ASP A  74      45.871  44.942   1.510  1.00 19.57           O  
ATOM    585  OD2 ASP A  74      45.361  46.008  -0.332  1.00 21.05           O  
ATOM    586  N   CYS A  75      47.825  45.197   3.927  1.00 18.66           N  
ATOM    587  CA  CYS A  75      48.208  44.007   4.687  1.00 18.76           C  
ATOM    588  C   CYS A  75      47.733  42.712   4.038  1.00 18.39           C  
ATOM    589  O   CYS A  75      48.180  41.633   4.425  1.00 18.14           O  
ATOM    590  CB  CYS A  75      47.665  44.072   6.105  1.00 18.56           C  
ATOM    591  SG  CYS A  75      48.291  45.443   7.041  1.00 21.90           S  
ATOM    592  N   GLN A  76      46.831  42.834   3.067  1.00 18.31           N  
ATOM    593  CA  GLN A  76      46.177  41.692   2.430  1.00 18.12           C  
ATOM    594  C   GLN A  76      45.568  40.747   3.468  1.00 18.03           C  
ATOM    595  O   GLN A  76      45.720  39.530   3.388  1.00 18.03           O  
ATOM    596  CB  GLN A  76      47.146  40.958   1.488  1.00 18.39           C  
ATOM    597  CG  GLN A  76      47.607  41.815   0.317  1.00 18.19           C  
ATOM    598  CD  GLN A  76      48.456  41.062  -0.706  1.00 18.97           C  
ATOM    599  OE1 GLN A  76      48.832  41.623  -1.730  1.00 21.98           O  
ATOM    600  NE2 GLN A  76      48.758  39.797  -0.432  1.00 20.06           N  
ATOM    601  N   ARG A  77      44.895  41.342   4.452  1.00 17.87           N  
ATOM    602  CA  ARG A  77      44.158  40.617   5.474  1.00 17.86           C  
ATOM    603  C   ARG A  77      42.787  41.244   5.583  1.00 17.02           C  
ATOM    604  O   ARG A  77      42.647  42.473   5.624  1.00 16.52           O  
ATOM    605  CB  ARG A  77      44.851  40.697   6.840  1.00 18.77           C  
ATOM    606  CG  ARG A  77      45.652  39.447   7.233  1.00 22.32           C  
ATOM    607  CD  ARG A  77      47.001  39.420   6.585  1.00 26.41           C  
ATOM    608  NE  ARG A  77      47.609  38.088   6.615  1.00 30.02           N  
ATOM    609  CZ  ARG A  77      48.603  37.724   7.423  1.00 31.92           C  
ATOM    610  NH1 ARG A  77      49.124  38.589   8.291  1.00 32.90           N  
ATOM    611  NH2 ARG A  77      49.083  36.487   7.362  1.00 32.38           N  
ATOM    612  N   THR A  78      41.774  40.390   5.623  1.00 15.86           N  
ATOM    613  CA  THR A  78      40.412  40.831   5.838  1.00 14.88           C  
ATOM    614  C   THR A  78      39.854  39.969   6.962  1.00 14.14           C  
ATOM    615  O   THR A  78      40.042  38.762   6.954  1.00 14.19           O  
ATOM    616  CB  THR A  78      39.571  40.672   4.547  1.00 14.91           C  
ATOM    617  OG1 THR A  78      39.937  41.680   3.595  1.00 14.84           O  
ATOM    618  CG2 THR A  78      38.114  40.804   4.836  1.00 15.37           C  
ATOM    619  N   VAL A  79      39.205  40.581   7.952  1.00 13.68           N  
ATOM    620  CA  VAL A  79      38.538  39.789   8.998  1.00 14.00           C  
ATOM    621  C   VAL A  79      37.077  40.182   9.097  1.00 14.00           C  
ATOM    622  O   VAL A  79      36.673  41.208   8.562  1.00 14.29           O  
ATOM    623  CB  VAL A  79      39.207  39.962  10.399  1.00 14.02           C  
ATOM    624  CG1 VAL A  79      40.654  39.441  10.376  1.00 14.83           C  
ATOM    625  CG2 VAL A  79      39.152  41.424  10.838  1.00 14.63           C  
ATOM    626  N   GLU A  80      36.295  39.368   9.796  1.00 14.34           N  
ATOM    627  CA  GLU A  80      34.912  39.706  10.116  1.00 15.00           C  
ATOM    628  C   GLU A  80      34.695  39.653  11.625  1.00 14.32           C  
ATOM    629  O   GLU A  80      35.164  38.727  12.300  1.00 13.53           O  
ATOM    630  CB  GLU A  80      33.964  38.733   9.420  1.00 15.01           C  
ATOM    631  CG  GLU A  80      32.481  39.107   9.488  1.00 16.49           C  
ATOM    632  CD  GLU A  80      31.585  38.017   8.935  1.00 17.83           C  
ATOM    633  OE1 GLU A  80      31.686  37.694   7.734  1.00 20.76           O  
ATOM    634  OE2 GLU A  80      30.794  37.458   9.715  1.00 20.71           O  
ATOM    635  N   PHE A  81      33.969  40.634  12.160  1.00 13.55           N  
ATOM    636  CA  PHE A  81      33.705  40.642  13.588  1.00 13.17           C  
ATOM    637  C   PHE A  81      32.312  41.153  13.948  1.00 12.80           C  
ATOM    638  O   PHE A  81      31.676  41.849  13.150  1.00 12.67           O  
ATOM    639  CB  PHE A  81      34.805  41.414  14.351  1.00 12.58           C  
ATOM    640  CG  PHE A  81      34.958  42.859  13.955  1.00 13.32           C  
ATOM    641  CD1 PHE A  81      34.079  43.836  14.441  1.00 14.56           C  
ATOM    642  CD2 PHE A  81      36.013  43.251  13.142  1.00 15.44           C  
ATOM    643  CE1 PHE A  81      34.246  45.200  14.087  1.00 15.42           C  
ATOM    644  CE2 PHE A  81      36.192  44.589  12.790  1.00 15.11           C  
ATOM    645  CZ  PHE A  81      35.311  45.570  13.274  1.00 15.01           C  
ATOM    646  N   GLU A  82      31.855  40.798  15.156  1.00 12.62           N  
ATOM    647  CA  GLU A  82      30.574  41.279  15.691  1.00 12.27           C  
ATOM    648  C   GLU A  82      30.653  42.751  16.065  1.00 12.00           C  
ATOM    649  O   GLU A  82      31.500  43.158  16.866  1.00 11.71           O  
ATOM    650  CB  GLU A  82      30.139  40.466  16.916  1.00 11.89           C  
ATOM    651  CG  GLU A  82      28.734  40.828  17.453  1.00 12.79           C  
ATOM    652  CD  GLU A  82      27.592  40.314  16.576  1.00 13.56           C  
ATOM    653  OE1 GLU A  82      27.836  39.508  15.655  1.00 12.48           O  
ATOM    654  OE2 GLU A  82      26.435  40.702  16.837  1.00 13.10           O  
ATOM    655  N   ILE A  83      29.765  43.554  15.480  1.00 11.73           N  
ATOM    656  CA  ILE A  83      29.705  44.974  15.820  1.00 11.74           C  
ATOM    657  C   ILE A  83      29.356  45.087  17.316  1.00 11.10           C  
ATOM    658  O   ILE A  83      28.443  44.414  17.799  1.00 10.53           O  
ATOM    659  CB  ILE A  83      28.667  45.725  14.908  1.00 12.00           C  
ATOM    660  CG1 ILE A  83      29.141  45.702  13.453  1.00 12.46           C  
ATOM    661  CG2 ILE A  83      28.434  47.195  15.370  1.00 11.97           C  
ATOM    662  CD1 ILE A  83      28.031  45.864  12.445  1.00 12.40           C  
ATOM    663  N   PHE A  84      30.095  45.919  18.049  1.00 11.91           N  
ATOM    664  CA  PHE A  84      29.817  46.141  19.469  1.00 11.98           C  
ATOM    665  C   PHE A  84      28.352  46.530  19.628  1.00 12.80           C  
ATOM    666  O   PHE A  84      27.868  47.403  18.910  1.00 12.23           O  
ATOM    667  CB  PHE A  84      30.712  47.249  20.046  1.00 12.82           C  
ATOM    668  CG  PHE A  84      32.138  46.822  20.314  1.00 14.35           C  
ATOM    669  CD1 PHE A  84      32.513  45.479  20.269  1.00 15.52           C  
ATOM    670  CD2 PHE A  84      33.098  47.773  20.621  1.00 16.11           C  
ATOM    671  CE1 PHE A  84      33.845  45.090  20.526  1.00 17.52           C  
ATOM    672  CE2 PHE A  84      34.420  47.397  20.883  1.00 16.89           C  
ATOM    673  CZ  PHE A  84      34.786  46.054  20.839  1.00 15.75           C  
ATOM    674  N   SER A  85      27.668  45.860  20.549  1.00 12.44           N  
ATOM    675  CA  SER A  85      26.231  46.051  20.793  1.00 14.07           C  
ATOM    676  C   SER A  85      25.852  47.525  20.925  1.00 13.39           C  
ATOM    677  O   SER A  85      24.889  47.987  20.315  1.00 14.15           O  
ATOM    678  CB  SER A  85      25.816  45.295  22.055  1.00 13.59           C  
ATOM    679  OG  SER A  85      25.729  43.898  21.791  1.00 18.95           O  
ATOM    680  N   HIS A  86      26.644  48.260  21.695  1.00 13.75           N  
ATOM    681  CA  HIS A  86      26.352  49.652  22.020  1.00 13.62           C  
ATOM    682  C   HIS A  86      26.667  50.623  20.880  1.00 13.83           C  
ATOM    683  O   HIS A  86      26.383  51.819  21.002  1.00 14.91           O  
ATOM    684  CB  HIS A  86      27.079  50.055  23.322  1.00 13.85           C  
ATOM    685  CG  HIS A  86      28.572  49.957  23.245  1.00 13.90           C  
ATOM    686  ND1 HIS A  86      29.245  48.754  23.260  1.00 12.76           N  
ATOM    687  CD2 HIS A  86      29.525  50.918  23.181  1.00 15.26           C  
ATOM    688  CE1 HIS A  86      30.544  48.976  23.184  1.00 13.68           C  
ATOM    689  NE2 HIS A  86      30.741  50.281  23.132  1.00 14.47           N  
ATOM    690  N   LEU A  87      27.244  50.113  19.784  1.00 13.64           N  
ATOM    691  CA  LEU A  87      27.572  50.936  18.598  1.00 13.76           C  
ATOM    692  C   LEU A  87      26.799  50.528  17.329  1.00 14.22           C  
ATOM    693  O   LEU A  87      26.936  51.145  16.259  1.00 14.85           O  
ATOM    694  CB  LEU A  87      29.098  50.918  18.339  1.00 13.88           C  
ATOM    695  CG  LEU A  87      30.010  51.311  19.506  1.00 14.36           C  
ATOM    696  CD1 LEU A  87      31.495  51.021  19.201  1.00 16.61           C  
ATOM    697  CD2 LEU A  87      29.800  52.764  19.959  1.00 17.68           C  
ATOM    698  N   ARG A  88      25.986  49.488  17.449  1.00 13.92           N  
ATOM    699  CA  ARG A  88      25.276  48.907  16.309  1.00 14.16           C  
ATOM    700  C   ARG A  88      24.177  49.828  15.752  1.00 13.97           C  
ATOM    701  O   ARG A  88      23.766  49.665  14.605  1.00 14.07           O  
ATOM    702  CB  ARG A  88      24.688  47.553  16.714  1.00 14.69           C  
ATOM    703  CG  ARG A  88      24.276  46.654  15.567  1.00 17.56           C  
ATOM    704  CD  ARG A  88      23.241  45.620  16.021  1.00 21.95           C  
ATOM    705  NE  ARG A  88      23.809  44.731  17.038  1.00 26.13           N  
ATOM    706  CZ  ARG A  88      23.123  43.845  17.759  1.00 26.69           C  
ATOM    707  NH1 ARG A  88      21.815  43.688  17.602  1.00 26.48           N  
ATOM    708  NH2 ARG A  88      23.765  43.107  18.653  1.00 26.48           N  
ATOM    709  N   HIS A  89      23.749  50.802  16.557  1.00 13.66           N  
ATOM    710  CA  HIS A  89      22.670  51.749  16.199  1.00 14.29           C  
ATOM    711  C   HIS A  89      22.947  52.553  14.926  1.00 14.50           C  
ATOM    712  O   HIS A  89      22.013  53.046  14.288  1.00 14.77           O  
ATOM    713  CB  HIS A  89      22.427  52.718  17.363  1.00 14.31           C  
ATOM    714  CG  HIS A  89      23.603  53.594  17.663  1.00 14.51           C  
ATOM    715  ND1 HIS A  89      24.763  53.112  18.229  1.00 14.91           N  
ATOM    716  CD2 HIS A  89      23.811  54.915  17.449  1.00 15.17           C  
ATOM    717  CE1 HIS A  89      25.630  54.099  18.364  1.00 16.40           C  
ATOM    718  NE2 HIS A  89      25.081  55.204  17.893  1.00 14.49           N  
ATOM    719  N   ARG A  90      24.226  52.685  14.566  1.00 14.50           N  
ATOM    720  CA  ARG A  90      24.614  53.427  13.375  1.00 14.33           C  
ATOM    721  C   ARG A  90      24.564  52.596  12.091  1.00 13.91           C  
ATOM    722  O   ARG A  90      24.836  53.116  11.019  1.00 13.69           O  
ATOM    723  CB  ARG A  90      26.002  54.052  13.553  1.00 15.13           C  
ATOM    724  CG  ARG A  90      26.029  55.257  14.520  1.00 15.65           C  
ATOM    725  CD  ARG A  90      25.367  56.518  13.912  1.00 16.42           C  
ATOM    726  NE  ARG A  90      26.230  57.119  12.892  1.00 16.06           N  
ATOM    727  CZ  ARG A  90      26.018  57.086  11.578  1.00 18.32           C  
ATOM    728  NH1 ARG A  90      24.927  56.521  11.072  1.00 18.11           N  
ATOM    729  NH2 ARG A  90      26.899  57.648  10.759  1.00 18.46           N  
ATOM    730  N   TYR A  91      24.253  51.310  12.221  1.00 13.37           N  
ATOM    731  CA  TYR A  91      24.130  50.409  11.059  1.00 12.74           C  
ATOM    732  C   TYR A  91      22.678  50.088  10.741  1.00 12.44           C  
ATOM    733  O   TYR A  91      21.787  50.237  11.591  1.00 12.16           O  
ATOM    734  CB  TYR A  91      24.929  49.118  11.270  1.00 12.71           C  
ATOM    735  CG  TYR A  91      26.410  49.383  11.451  1.00 13.23           C  
ATOM    736  CD1 TYR A  91      26.912  49.809  12.683  1.00 12.79           C  
ATOM    737  CD2 TYR A  91      27.299  49.216  10.392  1.00 11.98           C  
ATOM    738  CE1 TYR A  91      28.274  50.070  12.850  1.00 12.70           C  
ATOM    739  CE2 TYR A  91      28.665  49.470  10.554  1.00 12.92           C  
ATOM    740  CZ  TYR A  91      29.135  49.892  11.773  1.00 12.47           C  
ATOM    741  OH  TYR A  91      30.486  50.148  11.911  1.00 14.42           O  
ATOM    742  N   ALA A  92      22.438  49.675   9.502  1.00 11.93           N  
ATOM    743  CA  ALA A  92      21.085  49.375   9.043  1.00 11.27           C  
ATOM    744  C   ALA A  92      20.437  48.273   9.876  1.00 11.73           C  
ATOM    745  O   ALA A  92      21.129  47.423  10.423  1.00 10.45           O  
ATOM    746  CB  ALA A  92      21.087  49.013   7.561  1.00 11.13           C  
ATOM    747  N   PRO A  93      19.096  48.292   9.989  1.00 11.68           N  
ATOM    748  CA  PRO A  93      18.412  47.247  10.753  1.00 12.27           C  
ATOM    749  C   PRO A  93      18.867  45.841  10.335  1.00 12.54           C  
ATOM    750  O   PRO A  93      18.959  45.545   9.144  1.00 12.44           O  
ATOM    751  CB  PRO A  93      16.940  47.470  10.397  1.00 12.49           C  
ATOM    752  CG  PRO A  93      16.854  48.934  10.122  1.00 12.55           C  
ATOM    753  CD  PRO A  93      18.144  49.275   9.425  1.00 12.70           C  
ATOM    754  N   GLY A  94      19.176  44.996  11.315  1.00 12.68           N  
ATOM    755  CA  GLY A  94      19.567  43.609  11.049  1.00 12.32           C  
ATOM    756  C   GLY A  94      21.069  43.406  10.931  1.00 12.51           C  
ATOM    757  O   GLY A  94      21.553  42.279  11.038  1.00 12.47           O  
ATOM    758  N   VAL A  95      21.804  44.492  10.695  1.00 11.69           N  
ATOM    759  CA  VAL A  95      23.255  44.411  10.512  1.00 12.11           C  
ATOM    760  C   VAL A  95      23.926  44.190  11.869  1.00 11.89           C  
ATOM    761  O   VAL A  95      23.706  44.963  12.795  1.00 12.62           O  
ATOM    762  CB  VAL A  95      23.816  45.675   9.802  1.00 11.48           C  
ATOM    763  CG1 VAL A  95      25.355  45.627   9.692  1.00 13.04           C  
ATOM    764  CG2 VAL A  95      23.195  45.821   8.402  1.00 12.31           C  
ATOM    765  N   THR A  96      24.747  43.141  11.961  1.00 12.34           N  
ATOM    766  CA  THR A  96      25.509  42.815  13.186  1.00 12.62           C  
ATOM    767  C   THR A  96      26.983  42.459  12.938  1.00 13.14           C  
ATOM    768  O   THR A  96      27.791  42.445  13.891  1.00 12.36           O  
ATOM    769  CB  THR A  96      24.834  41.648  13.982  1.00 12.81           C  
ATOM    770  OG1 THR A  96      24.783  40.478  13.160  1.00 13.77           O  
ATOM    771  CG2 THR A  96      23.420  42.010  14.430  1.00 13.67           C  
ATOM    772  N   ARG A  97      27.333  42.185  11.675  1.00 12.55           N  
ATOM    773  CA  ARG A  97      28.673  41.707  11.270  1.00 13.26           C  
ATOM    774  C   ARG A  97      29.377  42.797  10.461  1.00 12.80           C  
ATOM    775  O   ARG A  97      28.812  43.320   9.503  1.00 13.56           O  
ATOM    776  CB  ARG A  97      28.558  40.474  10.360  1.00 13.15           C  
ATOM    777  CG  ARG A  97      27.930  39.225  10.944  1.00 16.04           C  
ATOM    778  CD  ARG A  97      29.028  38.252  11.318  1.00 21.54           C  
ATOM    779  NE  ARG A  97      29.263  38.315  12.735  1.00 18.69           N  
ATOM    780  CZ  ARG A  97      30.353  37.923  13.393  1.00 16.73           C  
ATOM    781  NH1 ARG A  97      31.445  37.422  12.815  1.00 18.27           N  
ATOM    782  NH2 ARG A  97      30.327  38.062  14.684  1.00 13.30           N  
ATOM    783  N   ASN A  98      30.607  43.131  10.827  1.00 13.06           N  
ATOM    784  CA  ASN A  98      31.401  44.049  10.033  1.00 12.46           C  
ATOM    785  C   ASN A  98      32.599  43.320   9.432  1.00 12.87           C  
ATOM    786  O   ASN A  98      33.254  42.531  10.110  1.00 11.71           O  
ATOM    787  CB  ASN A  98      31.869  45.224  10.900  1.00 13.62           C  
ATOM    788  CG  ASN A  98      32.633  46.261  10.118  1.00 13.73           C  
ATOM    789  OD1 ASN A  98      32.084  46.937   9.263  1.00 16.43           O  
ATOM    790  ND2 ASN A  98      33.916  46.414  10.436  1.00 18.18           N  
ATOM    791  N   THR A  99      32.869  43.586   8.162  1.00 12.50           N  
ATOM    792  CA  THR A  99      34.029  43.028   7.493  1.00 12.68           C  
ATOM    793  C   THR A  99      35.038  44.162   7.374  1.00 12.36           C  
ATOM    794  O   THR A  99      34.717  45.244   6.891  1.00 13.43           O  
ATOM    795  CB  THR A  99      33.634  42.448   6.117  1.00 12.67           C  
ATOM    796  OG1 THR A  99      32.807  41.301   6.324  1.00 12.87           O  
ATOM    797  CG2 THR A  99      34.849  42.035   5.332  1.00 13.29           C  
ATOM    798  N   GLU A 100      36.250  43.904   7.839  1.00 11.87           N  
ATOM    799  CA  GLU A 100      37.292  44.913   7.913  1.00 12.05           C  
ATOM    800  C   GLU A 100      38.570  44.468   7.201  1.00 12.00           C  
ATOM    801  O   GLU A 100      39.069  43.378   7.443  1.00 12.56           O  
ATOM    802  CB  GLU A 100      37.598  45.172   9.377  1.00 11.62           C  
ATOM    803  CG  GLU A 100      38.622  46.229   9.648  1.00 13.33           C  
ATOM    804  CD  GLU A 100      38.963  46.282  11.110  1.00 15.03           C  
ATOM    805  OE1 GLU A 100      39.605  45.336  11.619  1.00 17.35           O  
ATOM    806  OE2 GLU A 100      38.541  47.245  11.756  1.00 15.21           O  
ATOM    807  N   SER A 101      39.105  45.345   6.362  1.00 12.30           N  
ATOM    808  CA  SER A 101      40.373  45.105   5.671  1.00 12.90           C  
ATOM    809  C   SER A 101      41.486  45.991   6.222  1.00 12.53           C  
ATOM    810  O   SER A 101      41.286  47.185   6.486  1.00 11.86           O  
ATOM    811  CB  SER A 101      40.199  45.344   4.182  1.00 13.38           C  
ATOM    812  OG  SER A 101      39.161  44.524   3.684  1.00 15.63           O  
ATOM    813  N   TRP A 102      42.663  45.392   6.376  1.00 12.24           N  
ATOM    814  CA  TRP A 102      43.753  46.017   7.115  1.00 12.79           C  
ATOM    815  C   TRP A 102      44.807  46.645   6.237  1.00 12.97           C  
ATOM    816  O   TRP A 102      45.214  46.075   5.206  1.00 12.84           O  
ATOM    817  CB  TRP A 102      44.451  45.004   8.008  1.00 13.13           C  
ATOM    818  CG  TRP A 102      43.625  44.392   9.077  1.00 13.64           C  
ATOM    819  CD1 TRP A 102      42.348  44.728   9.447  1.00 14.45           C  
ATOM    820  CD2 TRP A 102      44.039  43.345   9.954  1.00 14.20           C  
ATOM    821  NE1 TRP A 102      41.938  43.931  10.490  1.00 14.67           N  
ATOM    822  CE2 TRP A 102      42.959  43.080  10.831  1.00 14.23           C  
ATOM    823  CE3 TRP A 102      45.222  42.590  10.079  1.00 14.38           C  
ATOM    824  CZ2 TRP A 102      43.024  42.089  11.818  1.00 13.41           C  
ATOM    825  CZ3 TRP A 102      45.293  41.618  11.070  1.00 14.71           C  
ATOM    826  CH2 TRP A 102      44.192  41.372  11.920  1.00 13.79           C  
ATOM    827  N   PHE A 103      45.258  47.809   6.692  1.00 12.92           N  
ATOM    828  CA  PHE A 103      46.340  48.556   6.097  1.00 13.35           C  
ATOM    829  C   PHE A 103      47.237  49.049   7.231  1.00 13.87           C  
ATOM    830  O   PHE A 103      46.790  49.188   8.369  1.00 13.86           O  
ATOM    831  CB  PHE A 103      45.794  49.749   5.311  1.00 12.78           C  
ATOM    832  CG  PHE A 103      44.896  49.368   4.165  1.00 11.90           C  
ATOM    833  CD1 PHE A 103      43.553  49.053   4.395  1.00 12.68           C  
ATOM    834  CD2 PHE A 103      45.373  49.356   2.866  1.00 14.89           C  
ATOM    835  CE1 PHE A 103      42.728  48.694   3.347  1.00 12.62           C  
ATOM    836  CE2 PHE A 103      44.547  49.006   1.804  1.00 13.57           C  
ATOM    837  CZ  PHE A 103      43.215  48.678   2.056  1.00 13.70           C  
ATOM    838  N   CYS A 104      48.503  49.294   6.934  1.00 14.83           N  
ATOM    839  CA  CYS A 104      49.328  50.027   7.885  1.00 16.45           C  
ATOM    840  C   CYS A 104      49.979  51.243   7.236  1.00 15.63           C  
ATOM    841  O   CYS A 104      50.033  51.347   6.021  1.00 16.00           O  
ATOM    842  CB  CYS A 104      50.329  49.122   8.613  1.00 16.69           C  
ATOM    843  SG  CYS A 104      51.417  48.146   7.595  1.00 25.64           S  
ATOM    844  N   LEU A 105      50.448  52.172   8.062  1.00 15.53           N  
ATOM    845  CA  LEU A 105      51.049  53.393   7.552  1.00 15.72           C  
ATOM    846  C   LEU A 105      52.133  53.781   8.525  1.00 15.31           C  
ATOM    847  O   LEU A 105      51.843  54.107   9.674  1.00 15.47           O  
ATOM    848  CB  LEU A 105      50.016  54.518   7.400  1.00 15.55           C  
ATOM    849  CG  LEU A 105      50.507  55.855   6.823  1.00 16.44           C  
ATOM    850  CD1 LEU A 105      50.724  55.786   5.302  1.00 18.22           C  
ATOM    851  CD2 LEU A 105      49.552  56.977   7.194  1.00 16.79           C  
ATOM    852  N   ALA A 106      53.383  53.685   8.076  1.00 15.69           N  
ATOM    853  CA  ALA A 106      54.508  54.139   8.884  1.00 15.75           C  
ATOM    854  C   ALA A 106      54.834  55.586   8.547  1.00 15.46           C  
ATOM    855  O   ALA A 106      55.081  55.928   7.391  1.00 15.68           O  
ATOM    856  CB  ALA A 106      55.720  53.253   8.676  1.00 15.93           C  
ATOM    857  N   LEU A 107      54.811  56.433   9.567  1.00 15.04           N  
ATOM    858  CA  LEU A 107      55.294  57.797   9.444  1.00 14.81           C  
ATOM    859  C   LEU A 107      56.787  57.748   9.778  1.00 14.71           C  
ATOM    860  O   LEU A 107      57.208  56.904  10.575  1.00 14.58           O  
ATOM    861  CB  LEU A 107      54.553  58.717  10.414  1.00 14.23           C  
ATOM    862  CG  LEU A 107      53.009  58.776  10.387  1.00 14.22           C  
ATOM    863  CD1 LEU A 107      52.503  59.764  11.424  1.00 13.51           C  
ATOM    864  CD2 LEU A 107      52.454  59.132   9.014  1.00 13.28           C  
ATOM    865  N   PRO A 108      57.604  58.631   9.170  1.00 15.31           N  
ATOM    866  CA  PRO A 108      59.049  58.578   9.495  1.00 15.37           C  
ATOM    867  C   PRO A 108      59.341  58.877  10.969  1.00 15.91           C  
ATOM    868  O   PRO A 108      60.293  58.335  11.539  1.00 16.03           O  
ATOM    869  CB  PRO A 108      59.656  59.669   8.603  1.00 15.25           C  
ATOM    870  CG  PRO A 108      58.516  60.549   8.223  1.00 15.35           C  
ATOM    871  CD  PRO A 108      57.304  59.664   8.165  1.00 15.00           C  
ATOM    872  N   HIS A 109      58.520  59.733  11.568  1.00 15.79           N  
ATOM    873  CA  HIS A 109      58.675  60.117  12.966  1.00 15.93           C  
ATOM    874  C   HIS A 109      57.306  60.277  13.592  1.00 15.93           C  
ATOM    875  O   HIS A 109      56.284  60.309  12.892  1.00 16.40           O  
ATOM    876  CB  HIS A 109      59.449  61.435  13.092  1.00 15.98           C  
ATOM    877  CG  HIS A 109      60.744  61.446  12.343  1.00 16.19           C  
ATOM    878  ND1 HIS A 109      61.858  60.763  12.780  1.00 15.79           N  
ATOM    879  CD2 HIS A 109      61.094  62.031  11.175  1.00 15.79           C  
ATOM    880  CE1 HIS A 109      62.843  60.936  11.917  1.00 16.86           C  
ATOM    881  NE2 HIS A 109      62.404  61.701  10.933  1.00 17.11           N  
ATOM    882  N   GLU A 110      57.281  60.370  14.916  1.00 16.22           N  
ATOM    883  CA  GLU A 110      56.065  60.757  15.606  1.00 16.20           C  
ATOM    884  C   GLU A 110      55.817  62.215  15.269  1.00 17.02           C  
ATOM    885  O   GLU A 110      56.753  62.963  14.944  1.00 16.87           O  
ATOM    886  CB  GLU A 110      56.197  60.576  17.113  1.00 16.39           C  
ATOM    887  CG  GLU A 110      56.551  59.157  17.528  1.00 15.86           C  
ATOM    888  CD  GLU A 110      56.498  58.945  19.016  1.00 15.23           C  
ATOM    889  OE1 GLU A 110      56.161  59.882  19.761  1.00 17.59           O  
ATOM    890  OE2 GLU A 110      56.798  57.825  19.445  1.00 16.03           O  
ATOM    891  N   ARG A 111      54.556  62.613  15.311  1.00 17.38           N  
ATOM    892  CA  ARG A 111      54.220  64.012  15.114  1.00 17.85           C  
ATOM    893  C   ARG A 111      53.016  64.351  15.963  1.00 18.20           C  
ATOM    894  O   ARG A 111      52.239  63.468  16.344  1.00 18.21           O  
ATOM    895  CB  ARG A 111      53.915  64.294  13.644  1.00 17.20           C  
ATOM    896  CG  ARG A 111      52.622  63.630  13.146  1.00 18.02           C  
ATOM    897  CD  ARG A 111      52.278  64.027  11.727  1.00 17.56           C  
ATOM    898  NE  ARG A 111      53.157  63.381  10.756  1.00 16.43           N  
ATOM    899  CZ  ARG A 111      53.038  63.495   9.436  1.00 17.15           C  
ATOM    900  NH1 ARG A 111      52.065  64.233   8.907  1.00 17.92           N  
ATOM    901  NH2 ARG A 111      53.894  62.871   8.642  1.00 16.49           N  
ATOM    902  N   GLN A 112      52.869  65.641  16.255  1.00 18.88           N  
ATOM    903  CA  GLN A 112      51.615  66.135  16.785  1.00 19.78           C  
ATOM    904  C   GLN A 112      50.540  65.859  15.746  1.00 19.67           C  
ATOM    905  O   GLN A 112      50.788  65.942  14.536  1.00 19.70           O  
ATOM    906  CB  GLN A 112      51.695  67.618  17.128  1.00 19.90           C  
ATOM    907  CG  GLN A 112      52.301  67.871  18.494  1.00 22.49           C  
ATOM    908  CD  GLN A 112      52.271  69.327  18.874  1.00 24.99           C  
ATOM    909  OE1 GLN A 112      51.351  69.788  19.557  1.00 26.91           O  
ATOM    910  NE2 GLN A 112      53.268  70.071  18.417  1.00 25.60           N  
ATOM    911  N   ILE A 113      49.358  65.495  16.228  1.00 19.51           N  
ATOM    912  CA  ILE A 113      48.264  65.089  15.366  1.00 19.57           C  
ATOM    913  C   ILE A 113      47.094  66.062  15.468  1.00 19.69           C  
ATOM    914  O   ILE A 113      46.620  66.375  16.562  1.00 19.43           O  
ATOM    915  CB  ILE A 113      47.800  63.630  15.699  1.00 19.26           C  
ATOM    916  CG1 ILE A 113      48.876  62.602  15.307  1.00 19.18           C  
ATOM    917  CG2 ILE A 113      46.436  63.298  15.081  1.00 20.02           C  
ATOM    918  CD1 ILE A 113      49.172  62.499  13.807  1.00 19.27           C  
ATOM    919  N   VAL A 114      46.641  66.544  14.316  1.00 19.56           N  
ATOM    920  CA  VAL A 114      45.389  67.277  14.260  1.00 19.92           C  
ATOM    921  C   VAL A 114      44.236  66.314  13.962  1.00 19.79           C  
ATOM    922  O   VAL A 114      44.026  65.872  12.832  1.00 19.81           O  
ATOM    923  CB  VAL A 114      45.432  68.493  13.298  1.00 20.01           C  
ATOM    924  CG1 VAL A 114      46.291  69.599  13.889  1.00 20.53           C  
ATOM    925  CG2 VAL A 114      45.973  68.101  11.955  1.00 21.65           C  
ATOM    926  N   PHE A 115      43.514  65.980  15.021  1.00 20.07           N  
ATOM    927  CA  PHE A 115      42.404  65.043  14.956  1.00 19.91           C  
ATOM    928  C   PHE A 115      41.096  65.817  14.888  1.00 20.22           C  
ATOM    929  O   PHE A 115      40.972  66.915  15.440  1.00 20.33           O  
ATOM    930  CB  PHE A 115      42.431  64.080  16.153  1.00 19.58           C  
ATOM    931  CG  PHE A 115      42.464  64.768  17.491  1.00 19.86           C  
ATOM    932  CD1 PHE A 115      43.671  65.201  18.043  1.00 19.81           C  
ATOM    933  CD2 PHE A 115      41.289  64.982  18.203  1.00 20.13           C  
ATOM    934  CE1 PHE A 115      43.703  65.840  19.287  1.00 20.50           C  
ATOM    935  CE2 PHE A 115      41.311  65.617  19.451  1.00 19.69           C  
ATOM    936  CZ  PHE A 115      42.526  66.049  19.991  1.00 20.21           C  
ATOM    937  N   THR A 116      40.121  65.242  14.200  1.00 20.49           N  
ATOM    938  CA  THR A 116      38.896  65.968  13.882  1.00 20.95           C  
ATOM    939  C   THR A 116      37.656  65.301  14.456  1.00 20.71           C  
ATOM    940  O   THR A 116      36.670  65.967  14.764  1.00 21.19           O  
ATOM    941  CB  THR A 116      38.723  66.119  12.352  1.00 20.87           C  
ATOM    942  OG1 THR A 116      38.613  64.821  11.752  1.00 21.98           O  
ATOM    943  CG2 THR A 116      39.916  66.853  11.747  1.00 21.74           C  
ATOM    944  N   GLU A 117      37.715  63.984  14.608  1.00 20.41           N  
ATOM    945  CA  GLU A 117      36.538  63.199  14.954  1.00 20.54           C  
ATOM    946  C   GLU A 117      36.689  62.495  16.299  1.00 19.45           C  
ATOM    947  O   GLU A 117      35.697  62.070  16.895  1.00 20.62           O  
ATOM    948  CB  GLU A 117      36.233  62.188  13.838  1.00 20.63           C  
ATOM    949  CG  GLU A 117      36.032  62.829  12.451  1.00 22.71           C  
ATOM    950  CD  GLU A 117      35.765  61.823  11.336  1.00 22.51           C  
ATOM    951  OE1 GLU A 117      35.607  60.616  11.611  1.00 27.71           O  
ATOM    952  OE2 GLU A 117      35.696  62.245  10.165  1.00 26.77           O  
ATOM    953  N   HIS A 118      37.924  62.371  16.775  1.00 17.25           N  
ATOM    954  CA  HIS A 118      38.200  61.729  18.051  1.00 15.47           C  
ATOM    955  C   HIS A 118      38.333  62.767  19.167  1.00 14.75           C  
ATOM    956  O   HIS A 118      38.304  63.977  18.914  1.00 14.38           O  
ATOM    957  CB  HIS A 118      39.461  60.848  17.939  1.00 14.70           C  
ATOM    958  CG  HIS A 118      39.265  59.623  17.099  1.00 14.60           C  
ATOM    959  ND1 HIS A 118      39.349  59.638  15.722  1.00 13.62           N  
ATOM    960  CD2 HIS A 118      38.946  58.352  17.441  1.00 11.72           C  
ATOM    961  CE1 HIS A 118      39.125  58.422  15.254  1.00 13.28           C  
ATOM    962  NE2 HIS A 118      38.884  57.621  16.279  1.00 12.68           N  
ATOM    963  N   LEU A 119      38.480  62.294  20.398  1.00 14.00           N  
ATOM    964  CA  LEU A 119      38.559  63.179  21.552  1.00 13.61           C  
ATOM    965  C   LEU A 119      39.993  63.545  21.938  1.00 13.76           C  
ATOM    966  O   LEU A 119      40.249  64.575  22.591  1.00 13.73           O  
ATOM    967  CB  LEU A 119      37.855  62.524  22.727  1.00 13.85           C  
ATOM    968  CG  LEU A 119      36.354  62.251  22.564  1.00 12.26           C  
ATOM    969  CD1 LEU A 119      35.849  61.557  23.812  1.00 13.11           C  
ATOM    970  CD2 LEU A 119      35.542  63.532  22.308  1.00 14.83           C  
ATOM    971  N   ALA A 120      40.925  62.695  21.527  1.00 13.48           N  
ATOM    972  CA  ALA A 120      42.297  62.742  22.012  1.00 13.85           C  
ATOM    973  C   ALA A 120      43.137  61.739  21.249  1.00 14.03           C  
ATOM    974  O   ALA A 120      42.606  60.855  20.579  1.00 13.65           O  
ATOM    975  CB  ALA A 120      42.342  62.410  23.493  1.00 13.99           C  
ATOM    976  N   TYR A 121      44.458  61.878  21.363  1.00 14.66           N  
ATOM    977  CA  TYR A 121      45.383  60.892  20.828  1.00 15.09           C  
ATOM    978  C   TYR A 121      46.572  60.664  21.762  1.00 15.49           C  
ATOM    979  O   TYR A 121      46.935  61.527  22.574  1.00 14.56           O  
ATOM    980  CB  TYR A 121      45.871  61.285  19.421  1.00 15.41           C  
ATOM    981  CG  TYR A 121      46.935  62.351  19.436  1.00 16.13           C  
ATOM    982  CD1 TYR A 121      46.596  63.700  19.549  1.00 16.69           C  
ATOM    983  CD2 TYR A 121      48.288  62.014  19.356  1.00 16.42           C  
ATOM    984  CE1 TYR A 121      47.580  64.689  19.586  1.00 17.49           C  
ATOM    985  CE2 TYR A 121      49.273  62.993  19.390  1.00 17.58           C  
ATOM    986  CZ  TYR A 121      48.911  64.324  19.500  1.00 16.83           C  
ATOM    987  OH  TYR A 121      49.881  65.297  19.532  1.00 17.23           O  
ATOM    988  N   LYS A 122      47.158  59.482  21.632  1.00 16.12           N  
ATOM    989  CA  LYS A 122      48.361  59.101  22.363  1.00 16.48           C  
ATOM    990  C   LYS A 122      49.268  58.320  21.426  1.00 16.27           C  
ATOM    991  O   LYS A 122      48.790  57.543  20.600  1.00 16.85           O  
ATOM    992  CB  LYS A 122      47.999  58.233  23.575  1.00 16.96           C  
ATOM    993  CG  LYS A 122      47.428  58.999  24.745  1.00 19.90           C  
ATOM    994  CD  LYS A 122      47.311  58.111  25.979  1.00 23.42           C  
ATOM    995  CE  LYS A 122      46.893  58.918  27.200  1.00 25.23           C  
ATOM    996  NZ  LYS A 122      45.429  59.193  27.236  1.00 26.86           N  
ATOM    997  N   TRP A 123      50.578  58.540  21.552  1.00 15.93           N  
ATOM    998  CA  TRP A 123      51.578  57.676  20.939  1.00 14.88           C  
ATOM    999  C   TRP A 123      52.006  56.661  21.999  1.00 14.62           C  
ATOM   1000  O   TRP A 123      52.491  57.037  23.070  1.00 14.12           O  
ATOM   1001  CB  TRP A 123      52.783  58.485  20.458  1.00 14.67           C  
ATOM   1002  CG  TRP A 123      52.542  59.298  19.202  1.00 13.35           C  
ATOM   1003  CD1 TRP A 123      52.308  60.645  19.130  1.00 12.54           C  
ATOM   1004  CD2 TRP A 123      52.529  58.819  17.843  1.00 12.79           C  
ATOM   1005  NE1 TRP A 123      52.150  61.030  17.824  1.00 12.06           N  
ATOM   1006  CE2 TRP A 123      52.271  59.934  17.012  1.00 12.32           C  
ATOM   1007  CE3 TRP A 123      52.699  57.561  17.253  1.00 11.02           C  
ATOM   1008  CZ2 TRP A 123      52.188  59.828  15.622  1.00 13.11           C  
ATOM   1009  CZ3 TRP A 123      52.625  57.455  15.867  1.00 12.17           C  
ATOM   1010  CH2 TRP A 123      52.369  58.589  15.068  1.00 12.42           C  
ATOM   1011  N   LEU A 124      51.804  55.379  21.718  1.00 14.37           N  
ATOM   1012  CA  LEU A 124      52.102  54.348  22.709  1.00 15.22           C  
ATOM   1013  C   LEU A 124      52.983  53.253  22.140  1.00 14.88           C  
ATOM   1014  O   LEU A 124      52.839  52.898  20.965  1.00 14.89           O  
ATOM   1015  CB  LEU A 124      50.797  53.727  23.221  1.00 15.18           C  
ATOM   1016  CG  LEU A 124      49.805  54.628  23.969  1.00 15.89           C  
ATOM   1017  CD1 LEU A 124      48.513  53.872  24.213  1.00 17.42           C  
ATOM   1018  CD2 LEU A 124      50.379  55.165  25.273  1.00 16.23           C  
ATOM   1019  N   ASP A 125      53.871  52.687  22.964  1.00 14.69           N  
ATOM   1020  CA  ASP A 125      54.571  51.474  22.535  1.00 13.65           C  
ATOM   1021  C   ASP A 125      53.537  50.433  22.051  1.00 13.24           C  
ATOM   1022  O   ASP A 125      52.409  50.391  22.557  1.00 12.37           O  
ATOM   1023  CB  ASP A 125      55.558  50.941  23.590  1.00 14.31           C  
ATOM   1024  CG  ASP A 125      54.885  50.329  24.813  1.00 14.08           C  
ATOM   1025  OD1 ASP A 125      54.275  49.258  24.686  1.00 13.86           O  
ATOM   1026  OD2 ASP A 125      55.048  50.878  25.923  1.00 15.73           O  
ATOM   1027  N   ALA A 126      53.907  49.630  21.060  1.00 13.07           N  
ATOM   1028  CA  ALA A 126      52.924  48.774  20.391  1.00 12.70           C  
ATOM   1029  C   ALA A 126      52.216  47.774  21.317  1.00 12.74           C  
ATOM   1030  O   ALA A 126      50.994  47.627  21.199  1.00 13.15           O  
ATOM   1031  CB  ALA A 126      53.518  48.079  19.171  1.00 13.20           C  
ATOM   1032  N   PRO A 127      52.956  47.086  22.220  1.00 12.72           N  
ATOM   1033  CA  PRO A 127      52.256  46.243  23.200  1.00 13.10           C  
ATOM   1034  C   PRO A 127      51.229  46.995  24.046  1.00 13.29           C  
ATOM   1035  O   PRO A 127      50.139  46.464  24.274  1.00 13.73           O  
ATOM   1036  CB  PRO A 127      53.386  45.694  24.078  1.00 13.10           C  
ATOM   1037  CG  PRO A 127      54.603  45.726  23.194  1.00 13.40           C  
ATOM   1038  CD  PRO A 127      54.426  46.985  22.375  1.00 11.92           C  
ATOM   1039  N   ALA A 128      51.564  48.211  24.487  1.00 13.15           N  
ATOM   1040  CA  ALA A 128      50.628  49.033  25.266  1.00 13.50           C  
ATOM   1041  C   ALA A 128      49.387  49.388  24.438  1.00 13.70           C  
ATOM   1042  O   ALA A 128      48.269  49.406  24.952  1.00 13.47           O  
ATOM   1043  CB  ALA A 128      51.321  50.311  25.807  1.00 13.78           C  
ATOM   1044  N   ALA A 129      49.604  49.670  23.157  1.00 13.97           N  
ATOM   1045  CA  ALA A 129      48.532  50.055  22.241  1.00 14.67           C  
ATOM   1046  C   ALA A 129      47.582  48.892  22.002  1.00 14.73           C  
ATOM   1047  O   ALA A 129      46.349  49.031  22.109  1.00 15.35           O  
ATOM   1048  CB  ALA A 129      49.121  50.540  20.925  1.00 14.68           C  
ATOM   1049  N   ALA A 130      48.170  47.741  21.689  1.00 15.15           N  
ATOM   1050  CA  ALA A 130      47.415  46.511  21.487  1.00 15.18           C  
ATOM   1051  C   ALA A 130      46.620  46.139  22.731  1.00 15.05           C  
ATOM   1052  O   ALA A 130      45.495  45.660  22.629  1.00 14.84           O  
ATOM   1053  CB  ALA A 130      48.355  45.389  21.108  1.00 14.91           C  
ATOM   1054  N   ALA A 131      47.209  46.366  23.900  1.00 14.66           N  
ATOM   1055  CA  ALA A 131      46.543  46.065  25.170  1.00 14.62           C  
ATOM   1056  C   ALA A 131      45.388  47.024  25.470  1.00 14.37           C  
ATOM   1057  O   ALA A 131      44.410  46.640  26.116  1.00 15.36           O  
ATOM   1058  CB  ALA A 131      47.551  46.089  26.302  1.00 14.26           C  
ATOM   1059  N   LEU A 132      45.524  48.275  25.025  1.00 13.48           N  
ATOM   1060  CA  LEU A 132      44.563  49.324  25.339  1.00 13.09           C  
ATOM   1061  C   LEU A 132      43.290  49.215  24.513  1.00 12.79           C  
ATOM   1062  O   LEU A 132      42.198  49.424  25.044  1.00 12.75           O  
ATOM   1063  CB  LEU A 132      45.179  50.706  25.124  1.00 13.20           C  
ATOM   1064  CG  LEU A 132      44.235  51.910  25.181  1.00 12.54           C  
ATOM   1065  CD1 LEU A 132      43.740  52.145  26.606  1.00 14.00           C  
ATOM   1066  CD2 LEU A 132      44.920  53.146  24.638  1.00 12.38           C  
ATOM   1067  N   THR A 133      43.438  48.919  23.223  1.00 12.27           N  
ATOM   1068  CA  THR A 133      42.277  48.901  22.312  1.00 12.81           C  
ATOM   1069  C   THR A 133      41.233  47.861  22.727  1.00 12.98           C  
ATOM   1070  O   THR A 133      41.599  46.793  23.201  1.00 14.52           O  
ATOM   1071  CB  THR A 133      42.691  48.721  20.812  1.00 12.33           C  
ATOM   1072  OG1 THR A 133      41.538  48.873  19.974  1.00 11.98           O  
ATOM   1073  CG2 THR A 133      43.323  47.344  20.529  1.00 13.49           C  
ATOM   1074  N   LYS A 134      39.943  48.198  22.580  1.00 12.98           N  
ATOM   1075  CA  LYS A 134      38.851  47.240  22.789  1.00 13.19           C  
ATOM   1076  C   LYS A 134      38.634  46.313  21.596  1.00 12.62           C  
ATOM   1077  O   LYS A 134      38.017  45.250  21.740  1.00 13.48           O  
ATOM   1078  CB  LYS A 134      37.531  47.968  23.128  1.00 13.39           C  
ATOM   1079  CG  LYS A 134      37.509  48.626  24.498  1.00 15.50           C  
ATOM   1080  CD  LYS A 134      36.081  48.682  25.071  1.00 19.74           C  
ATOM   1081  CE  LYS A 134      35.569  50.088  25.102  1.00 18.63           C  
ATOM   1082  NZ  LYS A 134      34.147  50.177  25.556  1.00 16.04           N  
ATOM   1083  N   SER A 135      39.137  46.716  20.428  1.00 12.41           N  
ATOM   1084  CA  SER A 135      38.992  45.961  19.194  1.00 11.65           C  
ATOM   1085  C   SER A 135      40.042  44.857  19.043  1.00 11.45           C  
ATOM   1086  O   SER A 135      41.243  45.133  18.927  1.00 11.07           O  
ATOM   1087  CB  SER A 135      39.068  46.901  17.992  1.00 11.42           C  
ATOM   1088  OG  SER A 135      39.189  46.170  16.776  1.00 11.66           O  
ATOM   1089  N   TRP A 136      39.577  43.614  19.032  1.00 10.90           N  
ATOM   1090  CA  TRP A 136      40.451  42.450  18.830  1.00 11.20           C  
ATOM   1091  C   TRP A 136      41.209  42.472  17.513  1.00 10.80           C  
ATOM   1092  O   TRP A 136      42.385  42.100  17.470  1.00 10.29           O  
ATOM   1093  CB  TRP A 136      39.693  41.123  19.033  1.00 11.19           C  
ATOM   1094  CG  TRP A 136      38.684  40.705  17.972  1.00 12.15           C  
ATOM   1095  CD1 TRP A 136      37.323  40.796  18.061  1.00 12.00           C  
ATOM   1096  CD2 TRP A 136      38.959  40.049  16.723  1.00 12.80           C  
ATOM   1097  NE1 TRP A 136      36.740  40.278  16.931  1.00 13.34           N  
ATOM   1098  CE2 TRP A 136      37.721  39.830  16.086  1.00 12.75           C  
ATOM   1099  CE3 TRP A 136      40.135  39.680  16.054  1.00 12.40           C  
ATOM   1100  CZ2 TRP A 136      37.619  39.222  14.818  1.00 13.92           C  
ATOM   1101  CZ3 TRP A 136      40.034  39.076  14.795  1.00 13.18           C  
ATOM   1102  CH2 TRP A 136      38.783  38.859  14.192  1.00 12.27           C  
ATOM   1103  N   SER A 137      40.534  42.924  16.452  1.00 11.99           N  
ATOM   1104  CA  SER A 137      41.146  43.037  15.142  1.00 11.97           C  
ATOM   1105  C   SER A 137      42.221  44.117  15.140  1.00 12.58           C  
ATOM   1106  O   SER A 137      43.322  43.882  14.634  1.00 11.92           O  
ATOM   1107  CB  SER A 137      40.090  43.227  14.036  1.00 11.95           C  
ATOM   1108  OG  SER A 137      39.358  44.425  14.167  1.00 12.04           O  
ATOM   1109  N   ASN A 138      41.925  45.265  15.758  1.00 12.56           N  
ATOM   1110  CA  ASN A 138      42.922  46.322  15.927  1.00 13.28           C  
ATOM   1111  C   ASN A 138      44.138  45.795  16.708  1.00 13.21           C  
ATOM   1112  O   ASN A 138      45.274  46.073  16.340  1.00 14.15           O  
ATOM   1113  CB  ASN A 138      42.300  47.549  16.619  1.00 12.75           C  
ATOM   1114  CG  ASN A 138      43.016  48.878  16.293  1.00 13.65           C  
ATOM   1115  OD1 ASN A 138      42.393  49.943  16.351  1.00 14.55           O  
ATOM   1116  ND2 ASN A 138      44.310  48.822  15.962  1.00 13.72           N  
ATOM   1117  N   ARG A 139      43.897  45.049  17.787  1.00 13.88           N  
ATOM   1118  CA  ARG A 139      44.989  44.442  18.567  1.00 14.59           C  
ATOM   1119  C   ARG A 139      45.832  43.514  17.694  1.00 14.01           C  
ATOM   1120  O   ARG A 139      47.054  43.630  17.668  1.00 12.39           O  
ATOM   1121  CB  ARG A 139      44.437  43.667  19.774  1.00 14.59           C  
ATOM   1122  CG  ARG A 139      45.471  42.860  20.546  1.00 15.42           C  
ATOM   1123  CD  ARG A 139      44.889  42.252  21.812  1.00 17.66           C  
ATOM   1124  NE  ARG A 139      43.875  41.239  21.514  1.00 23.92           N  
ATOM   1125  CZ  ARG A 139      42.567  41.366  21.733  1.00 26.20           C  
ATOM   1126  NH1 ARG A 139      42.059  42.478  22.258  1.00 28.23           N  
ATOM   1127  NH2 ARG A 139      41.759  40.364  21.423  1.00 25.99           N  
ATOM   1128  N   GLN A 140      45.169  42.613  16.976  1.00 13.92           N  
ATOM   1129  CA  GLN A 140      45.863  41.604  16.172  1.00 14.64           C  
ATOM   1130  C   GLN A 140      46.694  42.248  15.068  1.00 13.80           C  
ATOM   1131  O   GLN A 140      47.788  41.768  14.766  1.00 13.82           O  
ATOM   1132  CB  GLN A 140      44.873  40.583  15.596  1.00 14.50           C  
ATOM   1133  CG  GLN A 140      45.510  39.498  14.721  1.00 16.36           C  
ATOM   1134  CD  GLN A 140      44.608  38.282  14.551  1.00 16.95           C  
ATOM   1135  OE1 GLN A 140      43.383  38.392  14.574  1.00 18.85           O  
ATOM   1136  NE2 GLN A 140      45.213  37.114  14.404  1.00 21.05           N  
ATOM   1137  N   ALA A 141      46.179  43.337  14.492  1.00 13.57           N  
ATOM   1138  CA  ALA A 141      46.871  44.040  13.400  1.00 12.97           C  
ATOM   1139  C   ALA A 141      48.134  44.720  13.912  1.00 12.70           C  
ATOM   1140  O   ALA A 141      49.166  44.680  13.242  1.00 12.85           O  
ATOM   1141  CB  ALA A 141      45.960  45.034  12.728  1.00 13.64           C  
ATOM   1142  N   ILE A 142      48.045  45.328  15.097  1.00 12.21           N  
ATOM   1143  CA  ILE A 142      49.229  45.892  15.780  1.00 12.28           C  
ATOM   1144  C   ILE A 142      50.288  44.814  16.054  1.00 12.76           C  
ATOM   1145  O   ILE A 142      51.477  44.998  15.770  1.00 13.11           O  
ATOM   1146  CB  ILE A 142      48.834  46.668  17.083  1.00 11.80           C  
ATOM   1147  CG1 ILE A 142      47.953  47.884  16.734  1.00 12.12           C  
ATOM   1148  CG2 ILE A 142      50.086  47.109  17.864  1.00 12.07           C  
ATOM   1149  CD1 ILE A 142      47.238  48.482  17.913  1.00 13.91           C  
ATOM   1150  N   GLU A 143      49.854  43.680  16.585  1.00 13.97           N  
ATOM   1151  CA  GLU A 143      50.768  42.578  16.893  1.00 14.95           C  
ATOM   1152  C   GLU A 143      51.459  41.996  15.669  1.00 15.71           C  
ATOM   1153  O   GLU A 143      52.655  41.742  15.700  1.00 15.50           O  
ATOM   1154  CB  GLU A 143      50.026  41.479  17.645  1.00 14.92           C  
ATOM   1155  CG  GLU A 143      49.532  41.934  19.002  1.00 16.37           C  
ATOM   1156  CD  GLU A 143      48.686  40.902  19.695  1.00 18.01           C  
ATOM   1157  OE1 GLU A 143      48.069  40.055  19.015  1.00 18.81           O  
ATOM   1158  OE2 GLU A 143      48.623  40.956  20.935  1.00 20.76           O  
ATOM   1159  N   GLN A 144      50.708  41.804  14.587  1.00 16.70           N  
ATOM   1160  CA  GLN A 144      51.257  41.162  13.387  1.00 18.63           C  
ATOM   1161  C   GLN A 144      52.042  42.110  12.480  1.00 18.21           C  
ATOM   1162  O   GLN A 144      52.995  41.685  11.817  1.00 18.71           O  
ATOM   1163  CB  GLN A 144      50.138  40.490  12.578  1.00 18.27           C  
ATOM   1164  CG  GLN A 144      49.367  39.412  13.323  1.00 20.90           C  
ATOM   1165  CD  GLN A 144      48.307  38.752  12.459  1.00 21.47           C  
ATOM   1166  OE1 GLN A 144      47.984  39.234  11.369  1.00 25.24           O  
ATOM   1167  NE2 GLN A 144      47.758  37.641  12.943  1.00 25.13           N  
ATOM   1168  N   PHE A 145      51.657  43.386  12.442  1.00 18.76           N  
ATOM   1169  CA  PHE A 145      52.260  44.316  11.479  1.00 19.48           C  
ATOM   1170  C   PHE A 145      53.071  45.485  12.043  1.00 20.07           C  
ATOM   1171  O   PHE A 145      53.653  46.269  11.287  1.00 20.47           O  
ATOM   1172  CB  PHE A 145      51.211  44.817  10.490  1.00 19.86           C  
ATOM   1173  CG  PHE A 145      50.646  43.736   9.618  1.00 19.41           C  
ATOM   1174  CD1 PHE A 145      51.309  43.337   8.462  1.00 20.95           C  
ATOM   1175  CD2 PHE A 145      49.460  43.098   9.960  1.00 18.45           C  
ATOM   1176  CE1 PHE A 145      50.793  42.323   7.654  1.00 20.62           C  
ATOM   1177  CE2 PHE A 145      48.929  42.089   9.157  1.00 18.75           C  
ATOM   1178  CZ  PHE A 145      49.600  41.700   8.005  1.00 19.99           C  
ATOM   1179  N   VAL A 146      53.098  45.617  13.365  1.00 20.14           N  
ATOM   1180  CA  VAL A 146      53.966  46.594  14.000  1.00 20.62           C  
ATOM   1181  C   VAL A 146      54.984  45.854  14.851  1.00 21.13           C  
ATOM   1182  O   VAL A 146      56.190  45.941  14.592  1.00 20.96           O  
ATOM   1183  CB  VAL A 146      53.196  47.628  14.859  1.00 20.50           C  
ATOM   1184  CG1 VAL A 146      54.164  48.611  15.504  1.00 20.37           C  
ATOM   1185  CG2 VAL A 146      52.169  48.366  14.024  1.00 20.83           C  
ATOM   1186  N   ILE A 147      54.492  45.113  15.845  1.00 21.78           N  
ATOM   1187  CA  ILE A 147      55.356  44.343  16.755  1.00 22.64           C  
ATOM   1188  C   ILE A 147      56.133  43.255  16.017  1.00 23.60           C  
ATOM   1189  O   ILE A 147      57.354  43.128  16.191  1.00 23.80           O  
ATOM   1190  CB  ILE A 147      54.553  43.702  17.923  1.00 22.38           C  
ATOM   1191  CG1 ILE A 147      53.828  44.782  18.732  1.00 21.88           C  
ATOM   1192  CG2 ILE A 147      55.472  42.865  18.827  1.00 22.58           C  
ATOM   1193  CD1 ILE A 147      52.941  44.271  19.857  1.00 22.90           C  
ATOM   1194  N   ASN A 148      55.403  42.507  15.183  1.00 24.34           N  
ATOM   1195  CA  ASN A 148      55.861  41.302  14.478  1.00 25.49           C  
ATOM   1196  C   ASN A 148      55.986  40.058  15.372  1.00 25.60           C  
ATOM   1197  O   ASN A 148      55.105  39.757  16.184  1.00 25.96           O  
ATOM   1198  CB  ASN A 148      57.142  41.561  13.681  1.00 25.89           C  
ATOM   1199  CG  ASN A 148      56.871  42.039  12.274  1.00 26.82           C  
ATOM   1200  OD1 ASN A 148      57.273  41.392  11.307  1.00 29.98           O  
ATOM   1201  ND2 ASN A 148      56.207  43.183  12.147  1.00 28.64           N  
TER    1202      ASN A 148                                                      
END
MOLECULE T0513_1_11_87_283.pdb
ATOM      7  N   MET     1      40.511  38.696  30.932  1.00 34.21           N  
ATOM      8  CA  MET     1      40.458  39.135  29.549  1.00 22.06           C  
ATOM      9  C   MET     1      41.682  38.517  28.896  1.00 20.62           C  
ATOM     10  O   MET     1      42.651  38.176  29.595  1.00 20.32           O  
ATOM     11  CB  MET     1      40.508  40.662  29.493  1.00 26.67           C  
ATOM     12  CG  MET     1      39.316  41.294  30.229  1.00 26.17           C  
ATOM     15  N   SER     2      41.648  38.358  27.573  1.00 18.56           N  
ATOM     16  CA  SER     2      42.745  37.762  26.830  1.00 17.53           C  
ATOM     17  C   SER     2      42.560  38.118  25.378  1.00 19.94           C  
ATOM     18  O   SER     2      41.495  38.598  24.988  1.00 17.05           O  
ATOM     19  CB  SER     2      42.710  36.228  26.946  1.00 17.75           C  
ATOM     20  OG  SER     2      41.480  35.716  26.386  1.00 17.41           O  
ATOM     21  N   PHE     3      43.586  37.860  24.569  1.00 16.42           N  
ATOM     22  CA  PHE     3      43.459  38.022  23.110  1.00 16.19           C  
ATOM     23  C   PHE     3      42.307  37.173  22.593  1.00 21.25           C  
ATOM     24  O   PHE     3      41.461  37.650  21.819  1.00 19.18           O  
ATOM     25  CB  PHE     3      44.739  37.581  22.397  1.00 16.58           C  
ATOM     26  CG  PHE     3      45.941  38.449  22.661  1.00 15.61           C  
ATOM     27  CD1 PHE     3      45.828  39.838  22.823  1.00 13.92           C  
ATOM     28  CD2 PHE     3      47.208  37.862  22.709  1.00 20.52           C  
ATOM     29  CE1 PHE     3      46.981  40.625  23.045  1.00 17.47           C  
ATOM     30  CE2 PHE     3      48.343  38.632  22.922  1.00 19.74           C  
ATOM     31  CZ  PHE     3      48.236  40.011  23.095  1.00 20.60           C  
ATOM     32  N   LEU     4      42.276  35.914  23.034  1.00 17.01           N  
ATOM     33  CA  LEU     4      41.300  34.959  22.547  1.00 17.54           C  
ATOM     34  C   LEU     4      39.864  35.393  22.852  1.00 15.99           C  
ATOM     35  O   LEU     4      38.998  35.315  21.978  1.00 18.48           O  
ATOM     36  CB  LEU     4      41.598  33.535  23.044  1.00 18.74           C  
ATOM     37  CG  LEU     4      40.593  32.443  22.590  1.00 23.52           C  
ATOM     38  CD1 LEU     4      40.527  32.284  21.070  1.00 23.88           C  
ATOM     39  CD2 LEU     4      40.891  31.090  23.260  1.00 23.18           C  
ATOM     40  N   LYS     5      39.637  35.880  24.072  1.00 17.97           N  
ATOM     41  CA  LYS     5      38.295  36.329  24.470  1.00 16.32           C  
ATOM     42  C   LYS     5      37.818  37.464  23.559  1.00 17.11           C  
ATOM     43  O   LYS     5      36.660  37.464  23.200  1.00 17.21           O  
ATOM     44  CB  LYS     5      38.234  36.758  25.934  1.00 25.30           C  
ATOM     45  CG  LYS     5      36.789  36.876  26.476  1.00 32.59           C  
ATOM     46  CD  LYS     5      36.697  37.899  27.624  1.00 46.27           C  
ATOM     47  CE  LYS     5      35.251  38.200  28.091  1.00 40.02           C  
ATOM     48  NZ  LYS     5      34.171  38.126  27.026  1.00 37.12           N  
ATOM     49  N   HIS     6      38.696  38.404  23.186  1.00 16.06           N  
ATOM     50  CA  HIS     6      38.317  39.478  22.227  1.00 19.72           C  
ATOM     51  C   HIS     6      37.859  38.902  20.880  1.00 17.75           C  
ATOM     52  O   HIS     6      36.864  39.336  20.280  1.00 17.62           O  
ATOM     53  CB  HIS     6      39.490  40.435  21.971  1.00 17.88           C  
ATOM     54  CG  HIS     6      39.760  41.393  23.082  1.00 26.05           C  
ATOM     55  ND1 HIS     6      38.778  42.169  23.654  1.00 23.15           N  
ATOM     56  CD2 HIS     6      40.912  41.716  23.719  1.00 20.43           C  
ATOM     57  CE1 HIS     6      39.305  42.917  24.607  1.00 24.59           C  
ATOM     58  NE2 HIS     6      40.601  42.674  24.658  1.00 23.21           N  
ATOM     59  N   VAL     7      38.607  37.911  20.395  1.00 19.93           N  
ATOM     60  CA  VAL     7      38.322  37.270  19.129  1.00 15.58           C  
ATOM     61  C   VAL     7      36.992  36.526  19.218  1.00 20.03           C  
ATOM     62  O   VAL     7      36.166  36.642  18.319  1.00 17.61           O  
ATOM     63  CB  VAL     7      39.521  36.349  18.692  1.00 18.90           C  
ATOM     64  CG1 VAL     7      39.154  35.465  17.528  1.00 22.87           C  
ATOM     65  CG2 VAL     7      40.777  37.213  18.386  1.00 17.72           C  
ATOM     66  N   GLN     8      36.777  35.822  20.329  1.00 18.18           N  
ATOM     67  CA  GLN     8      35.531  35.100  20.579  1.00 15.33           C  
ATOM     68  C   GLN     8      34.323  36.036  20.681  1.00 17.02           C  
ATOM     69  O   GLN     8      33.252  35.717  20.142  1.00 23.55           O  
ATOM     70  CB  GLN     8      35.662  34.259  21.842  1.00 20.01           C  
ATOM     71  CG  GLN     8      36.479  32.991  21.588  1.00 19.14           C  
ATOM     72  CD  GLN     8      36.808  32.235  22.869  1.00 26.74           C  
ATOM     73  OE1 GLN     8      36.820  32.801  23.960  1.00 25.57           O  
ATOM     74  NE2 GLN     8      37.099  30.951  22.729  1.00 29.56           N  
ATOM     75  N   ASP     9      34.514  37.181  21.363  1.00 16.26           N  
ATOM     76  CA  ASP     9      33.480  38.214  21.515  1.00 17.99           C  
ATOM     77  C   ASP     9      33.012  38.673  20.127  1.00 17.79           C  
ATOM     78  O   ASP     9      31.805  38.752  19.866  1.00 15.63           O  
ATOM     79  CB  ASP     9      34.018  39.459  22.245  1.00 20.20           C  
ATOM     80  CG  ASP     9      34.205  39.262  23.755  1.00 21.46           C  
ATOM     81  OD1 ASP     9      33.680  38.295  24.334  1.00 22.14           O  
ATOM     82  OD2 ASP     9      34.896  40.116  24.337  1.00 25.62           O  
ATOM     83  N   CYS    10      33.972  38.942  19.230  1.00 13.03           N  
ATOM     84  CA  CYS    10      33.660  39.396  17.882  1.00 17.68           C  
ATOM     85  C   CYS    10      33.082  38.342  16.932  1.00 17.69           C  
ATOM     86  O   CYS    10      32.679  38.677  15.815  1.00 18.01           O  
ATOM     87  CB  CYS    10      34.881  40.047  17.257  1.00 20.69           C  
ATOM     88  SG  CYS    10      35.334  41.640  18.054  1.00 22.02           S  
ATOM     89  N   ASN    11      33.044  37.089  17.377  1.00 16.85           N  
ATOM     90  CA  ASN    11      32.489  36.005  16.585  1.00 16.00           C  
ATOM     91  C   ASN    11      31.330  35.320  17.254  1.00 21.69           C  
ATOM     92  O   ASN    11      30.958  34.203  16.885  1.00 21.64           O  
ATOM     93  CB  ASN    11      33.593  35.035  16.168  1.00 18.19           C  
ATOM     94  CG  ASN    11      34.453  35.616  15.082  1.00 21.69           C  
ATOM     95  OD1 ASN    11      33.977  35.828  13.968  1.00 20.16           O  
ATOM     96  ND2 ASN    11      35.712  35.932  15.408  1.00 25.35           N  
ATOM    704  N   GLY    87      22.335  58.715   5.514  1.00 25.39           N  
ATOM    705  CA  GLY    87      22.831  59.252   4.250  1.00 24.83           C  
ATOM    706  C   GLY    87      24.088  58.667   3.650  1.00 25.87           C  
ATOM    707  O   GLY    87      24.394  58.938   2.496  1.00 27.78           O  
ATOM    708  N   GLU    88      24.826  57.861   4.409  1.00 22.13           N  
ATOM    709  CA  GLU    88      25.998  57.160   3.861  1.00 22.36           C  
ATOM    710  C   GLU    88      25.582  55.816   3.295  1.00 23.51           C  
ATOM    711  O   GLU    88      25.054  54.989   4.020  1.00 19.80           O  
ATOM    712  CB  GLU    88      27.074  56.962   4.933  1.00 21.74           C  
ATOM    713  CG  GLU    88      28.275  56.190   4.365  1.00 22.96           C  
ATOM    714  CD  GLU    88      29.489  56.189   5.269  1.00 29.30           C  
ATOM    715  OE1 GLU    88      29.367  56.503   6.472  1.00 33.52           O  
ATOM    716  OE2 GLU    88      30.570  55.860   4.759  1.00 24.96           O  
ATOM    717  N   LEU    89      25.810  55.583   2.004  1.00 20.88           N  
ATOM    718  CA  LEU    89      25.365  54.333   1.387  1.00 21.09           C  
ATOM    719  C   LEU    89      26.512  53.320   1.330  1.00 18.78           C  
ATOM    720  O   LEU    89      27.654  53.675   1.020  1.00 23.48           O  
ATOM    721  CB  LEU    89      24.801  54.587  -0.030  1.00 24.83           C  
ATOM    722  CG  LEU    89      23.590  55.510  -0.163  1.00 24.17           C  
ATOM    723  CD1 LEU    89      23.159  55.634  -1.627  1.00 26.09           C  
ATOM    724  CD2 LEU    89      22.440  55.047   0.719  1.00 26.85           C  
ATOM    725  N   TYR    90      26.193  52.062   1.617  1.00 16.23           N  
ATOM    726  CA  TYR    90      27.161  50.972   1.554  1.00 16.87           C  
ATOM    727  C   TYR    90      26.790  50.018   0.421  1.00 21.89           C  
ATOM    728  O   TYR    90      25.612  49.841   0.095  1.00 21.37           O  
ATOM    729  CB  TYR    90      27.108  50.166   2.857  1.00 19.18           C  
ATOM    730  CG  TYR    90      27.980  50.636   4.014  1.00 19.39           C  
ATOM    731  CD1 TYR    90      28.586  51.896   4.022  1.00 22.76           C  
ATOM    732  CD2 TYR    90      28.157  49.810   5.129  1.00 17.63           C  
ATOM    733  CE1 TYR    90      29.384  52.298   5.104  1.00 23.15           C  
ATOM    734  CE2 TYR    90      28.930  50.204   6.222  1.00 16.30           C  
ATOM    735  CZ  TYR    90      29.555  51.449   6.190  1.00 20.05           C  
ATOM    736  OH  TYR    90      30.322  51.863   7.267  1.00 20.00           O  
ATOM    737  N   ARG    91      27.794  49.363  -0.136  1.00 20.63           N  
ATOM    738  CA  ARG    91      27.555  48.370  -1.175  1.00 19.85           C  
ATOM    739  C   ARG    91      27.051  47.062  -0.576  1.00 20.29           C  
ATOM    740  O   ARG    91      27.473  46.654   0.518  1.00 19.32           O  
ATOM    741  CB  ARG    91      28.840  48.157  -2.011  1.00 19.59           C  
ATOM    742  CG  ARG    91      29.881  47.303  -1.337  1.00 26.33           C  
ATOM    743  CD  ARG    91      31.225  47.506  -1.966  1.00 24.05           C  
ATOM    744  NE  ARG    91      31.794  48.821  -1.681  1.00 21.42           N  
ATOM    745  CZ  ARG    91      32.772  49.356  -2.401  1.00 28.61           C  
ATOM    746  NH1 ARG    91      33.284  48.673  -3.417  1.00 23.53           N  
ATOM    747  NH2 ARG    91      33.260  50.541  -2.095  1.00 22.18           N  
ATOM    748  N   VAL    92      26.123  46.418  -1.279  1.00 18.57           N  
ATOM    749  CA  VAL    92      25.629  45.105  -0.875  1.00 16.93           C  
ATOM    750  C   VAL    92      26.147  44.058  -1.867  1.00 21.31           C  
ATOM    751  O   VAL    92      25.839  44.127  -3.082  1.00 19.91           O  
ATOM    752  CB  VAL    92      24.077  45.066  -0.843  1.00 19.63           C  
ATOM    753  CG1 VAL    92      23.561  43.626  -0.553  1.00 18.79           C  
ATOM    754  CG2 VAL    92      23.540  46.091   0.161  1.00 19.26           C  
ATOM    755  N   ASN    93      26.930  43.104  -1.352  1.00 18.20           N  
ATOM    756  CA  ASN    93      27.505  42.038  -2.178  1.00 21.74           C  
ATOM    757  C   ASN    93      27.698  40.762  -1.358  1.00 24.96           C  
ATOM    758  O   ASN    93      27.499  40.746  -0.136  1.00 22.57           O  
ATOM    759  CB  ASN    93      28.859  42.491  -2.788  1.00 18.95           C  
ATOM    760  CG  ASN    93      29.874  42.903  -1.719  1.00 18.59           C  
ATOM    761  OD1 ASN    93      29.937  42.301  -0.661  1.00 24.48           O  
ATOM    762  ND2 ASN    93      30.678  43.942  -2.005  1.00 22.24           N  
ATOM    763  N   GLN    94      28.152  39.704  -2.018  1.00 26.36           N  
ATOM    764  CA  GLN    94      28.433  38.446  -1.340  1.00 26.49           C  
ATOM    765  C   GLN    94      29.823  38.381  -0.751  1.00 30.49           C  
ATOM    766  O   GLN    94      30.080  37.583   0.146  1.00 36.86           O  
ATOM    767  CB  GLN    94      28.266  37.286  -2.304  1.00 37.10           C  
ATOM    768  CG  GLN    94      26.932  36.636  -2.224  1.00 37.93           C  
ATOM    769  CD  GLN    94      26.869  35.435  -3.124  1.00 49.22           C  
ATOM    770  OE1 GLN    94      27.271  35.502  -4.289  1.00 48.89           O  
ATOM    771  NE2 GLN    94      26.362  34.325  -2.598  1.00 50.15           N  
ATOM    772  N   SER    95      30.722  39.175  -1.320  1.00 27.55           N  
ATOM    773  CA  SER    95      32.069  39.392  -0.824  1.00 28.80           C  
ATOM    774  C   SER    95      32.682  40.521  -1.622  1.00 22.53           C  
ATOM    775  O   SER    95      32.128  40.970  -2.634  1.00 27.82           O  
ATOM    776  CB  SER    95      32.951  38.132  -0.907  1.00 35.68           C  
ATOM    777  OG  SER    95      32.898  37.568  -2.200  1.00 45.01           O  
ATOM    778  N   TRP    96      33.826  40.973  -1.150  1.00 24.95           N  
ATOM    779  CA  TRP    96      34.436  42.202  -1.609  1.00 25.45           C  
ATOM    780  C   TRP    96      34.681  42.248  -3.134  1.00 31.67           C  
ATOM    781  O   TRP    96      34.439  43.261  -3.783  1.00 27.35           O  
ATOM    782  CB  TRP    96      35.741  42.422  -0.848  1.00 22.30           C  
ATOM    783  CG  TRP    96      36.462  43.612  -1.369  1.00 24.98           C  
ATOM    784  CD1 TRP    96      37.632  43.618  -2.096  1.00 26.49           C  
ATOM    785  CD2 TRP    96      36.055  44.983  -1.250  1.00 26.86           C  
ATOM    786  NE1 TRP    96      37.962  44.903  -2.437  1.00 27.97           N  
ATOM    787  CE2 TRP    96      37.019  45.764  -1.932  1.00 21.43           C  
ATOM    788  CE3 TRP    96      34.974  45.630  -0.629  1.00 26.25           C  
ATOM    789  CZ2 TRP    96      36.931  47.158  -2.015  1.00 27.21           C  
ATOM    790  CZ3 TRP    96      34.891  47.010  -0.708  1.00 24.31           C  
ATOM    791  CH2 TRP    96      35.870  47.765  -1.392  1.00 26.46           C  
ATOM    792  N   GLY    97      35.167  41.155  -3.704  1.00 34.73           N  
ATOM    793  CA  GLY    97      35.381  41.134  -5.170  1.00 43.04           C  
ATOM    794  C   GLY    97      34.138  41.139  -6.057  1.00 39.97           C  
ATOM    795  O   GLY    97      34.185  41.591  -7.209  1.00 39.72           O  
ATOM    796  N   GLU    98      33.033  40.651  -5.503  1.00 32.97           N  
ATOM    797  CA  GLU    98      31.804  40.317  -6.230  1.00 27.55           C  
ATOM    798  C   GLU    98      31.010  41.563  -6.666  1.00 28.91           C  
ATOM    799  O   GLU    98      31.254  42.659  -6.156  1.00 28.40           O  
ATOM    800  CB  GLU    98      30.957  39.401  -5.344  1.00 31.83           C  
ATOM    801  CG  GLU    98      31.496  37.987  -5.178  1.00 44.11           C  
ATOM    802  CD  GLU    98      31.337  37.164  -6.427  1.00 58.39           C  
ATOM    803  OE1 GLU    98      32.363  36.906  -7.087  1.00 64.85           O  
ATOM    804  OE2 GLU    98      30.189  36.793  -6.761  1.00 62.34           O  
ATOM    805  N   PRO    99      30.088  41.417  -7.650  1.00 29.23           N  
ATOM    806  CA  PRO    99      29.327  42.602  -8.113  1.00 31.34           C  
ATOM    807  C   PRO    99      28.456  43.270  -7.032  1.00 22.94           C  
ATOM    808  O   PRO    99      27.910  42.597  -6.172  1.00 22.94           O  
ATOM    809  CB  PRO    99      28.421  42.028  -9.225  1.00 30.62           C  
ATOM    810  CG  PRO    99      29.121  40.763  -9.672  1.00 34.18           C  
ATOM    811  CD  PRO    99      29.736  40.207  -8.431  1.00 34.24           C  
ATOM    812  N   THR   100      28.385  44.577  -7.048  1.00 21.61           N  
ATOM    813  CA  THR   100      27.472  45.266  -6.184  1.00 22.07           C  
ATOM    814  C   THR   100      26.055  45.017  -6.668  1.00 23.86           C  
ATOM    815  O   THR   100      25.724  45.353  -7.758  1.00 27.37           O  
ATOM    816  CB  THR   100      27.794  46.753  -6.127  1.00 25.42           C  
ATOM    817  OG1 THR   100      29.070  46.950  -5.547  1.00 25.25           O  
ATOM    818  CG2 THR   100      26.768  47.493  -5.390  1.00 21.58           C  
ATOM    819  N   LEU   101      25.252  44.413  -5.827  1.00 22.26           N  
ATOM    820  CA  LEU   101      23.902  44.054  -6.147  1.00 22.54           C  
ATOM    821  C   LEU   101      22.868  45.162  -5.909  1.00 26.84           C  
ATOM    822  O   LEU   101      21.835  45.169  -6.511  1.00 22.64           O  
ATOM    823  CB  LEU   101      23.512  42.785  -5.421  1.00 23.42           C  
ATOM    824  CG  LEU   101      24.336  41.556  -5.780  1.00 23.60           C  
ATOM    825  CD1 LEU   101      24.021  40.422  -4.914  1.00 24.49           C  
ATOM    826  CD2 LEU   101      24.104  41.185  -7.208  1.00 23.72           C  
ATOM    827  N   MET   102      23.182  46.045  -4.985  1.00 22.55           N  
ATOM    828  CA  MET   102      22.371  47.178  -4.624  1.00 21.19           C  
ATOM    829  C   MET   102      23.150  47.968  -3.581  1.00 23.28           C  
ATOM    830  O   MET   102      24.171  47.532  -3.145  1.00 19.55           O  
ATOM    831  CB  MET   102      21.053  46.709  -4.017  1.00 19.31           C  
ATOM    832  CG  MET   102      21.164  45.928  -2.733  1.00 21.18           C  
ATOM    833  SD  MET   102      19.405  45.525  -1.916  0.70 23.50          SE  
ATOM    834  CE  MET   102      19.035  47.338  -1.459  1.00 18.91           C  
ATOM    835  N   LEU   103      22.596  49.100  -3.191  1.00 18.82           N  
ATOM    836  CA  LEU   103      23.106  49.922  -2.110  1.00 19.48           C  
ATOM    837  C   LEU   103      22.134  50.000  -0.941  1.00 20.90           C  
ATOM    838  O   LEU   103      20.948  49.907  -1.109  1.00 20.47           O  
ATOM    839  CB  LEU   103      23.457  51.333  -2.574  1.00 19.25           C  
ATOM    840  CG  LEU   103      24.264  51.497  -3.846  1.00 25.37           C  
ATOM    841  CD1 LEU   103      24.555  52.930  -4.178  1.00 22.48           C  
ATOM    842  CD2 LEU   103      25.523  50.763  -3.726  1.00 16.64           C  
ATOM    843  N   LEU   104      22.687  50.192   0.242  1.00 19.74           N  
ATOM    844  CA  LEU   104      21.923  50.226   1.458  1.00 21.14           C  
ATOM    845  C   LEU   104      22.505  51.224   2.435  1.00 24.21           C  
ATOM    846  O   LEU   104      23.680  51.307   2.604  1.00 20.89           O  
ATOM    847  CB  LEU   104      21.901  48.860   2.084  1.00 23.77           C  
ATOM    848  CG  LEU   104      20.943  48.484   3.187  1.00 22.11           C  
ATOM    849  CD1 LEU   104      19.549  48.698   2.787  1.00 21.93           C  
ATOM    850  CD2 LEU   104      21.194  47.061   3.593  1.00 18.00           C  
ATOM    851  N   ASP   105      21.646  52.004   3.040  1.00 23.13           N  
ATOM    852  CA  ASP   105      22.136  52.996   3.987  1.00 19.41           C  
ATOM    853  C   ASP   105      22.867  52.277   5.131  1.00 15.14           C  
ATOM    854  O   ASP   105      22.375  51.291   5.654  1.00 18.33           O  
ATOM    855  CB  ASP   105      20.977  53.801   4.552  1.00 20.99           C  
ATOM    856  CG  ASP   105      21.447  55.029   5.285  1.00 20.36           C  
ATOM    857  OD1 ASP   105      21.842  54.928   6.470  1.00 21.30           O  
ATOM    858  OD2 ASP   105      21.476  56.107   4.673  1.00 21.56           O  
ATOM    859  N   ARG   106      24.040  52.796   5.477  1.00 21.02           N  
ATOM    860  CA  ARG   106      24.899  52.258   6.546  1.00 18.68           C  
ATOM    861  C   ARG   106      24.099  51.988   7.824  1.00 22.99           C  
ATOM    862  O   ARG   106      24.278  50.952   8.482  1.00 19.07           O  
ATOM    863  CB  ARG   106      26.026  53.245   6.801  1.00 20.67           C  
ATOM    864  CG  ARG   106      26.860  52.965   8.042  1.00 26.03           C  
ATOM    865  CD  ARG   106      27.944  54.002   8.188  1.00 21.79           C  
ATOM    866  NE  ARG   106      28.772  53.685   9.350  1.00 28.51           N  
ATOM    867  CZ  ARG   106      29.995  54.161   9.567  1.00 36.58           C  
ATOM    868  NH1 ARG   106      30.556  55.013   8.713  1.00 24.41           N  
ATOM    869  NH2 ARG   106      30.663  53.784  10.651  1.00 37.44           N  
ATOM    870  N   ALA   107      23.138  52.862   8.127  1.00 16.60           N  
ATOM    871  CA  ALA   107      22.420  52.758   9.398  1.00 22.69           C  
ATOM    872  C   ALA   107      21.586  51.489   9.530  1.00 19.03           C  
ATOM    873  O   ALA   107      21.297  51.057  10.637  1.00 21.36           O  
ATOM    874  CB  ALA   107      21.549  53.986   9.636  1.00 23.29           C  
ATOM    875  N   VAL   108      21.235  50.881   8.402  1.00 17.20           N  
ATOM    876  CA  VAL   108      20.418  49.676   8.404  1.00 17.43           C  
ATOM    877  C   VAL   108      21.193  48.455   7.914  1.00 21.77           C  
ATOM    878  O   VAL   108      20.631  47.379   7.750  1.00 19.19           O  
ATOM    879  CB  VAL   108      19.055  49.853   7.627  1.00 21.96           C  
ATOM    880  CG1 VAL   108      18.186  50.936   8.289  1.00 20.29           C  
ATOM    881  CG2 VAL   108      19.268  50.173   6.131  1.00 19.03           C  
ATOM    882  N   VAL   109      22.492  48.618   7.699  1.00 19.07           N  
ATOM    883  CA  VAL   109      23.306  47.473   7.234  1.00 17.15           C  
ATOM    884  C   VAL   109      23.208  46.292   8.255  1.00 15.02           C  
ATOM    885  O   VAL   109      22.810  45.158   7.867  1.00 17.93           O  
ATOM    886  CB  VAL   109      24.732  47.951   6.781  1.00 19.33           C  
ATOM    887  CG1 VAL   109      25.788  46.856   6.910  1.00 17.69           C  
ATOM    888  CG2 VAL   109      24.659  48.517   5.317  1.00 18.99           C  
ATOM    889  N   PRO   110      23.436  46.541   9.582  1.00 17.55           N  
ATOM    890  CA  PRO   110      23.209  45.433  10.540  1.00 18.17           C  
ATOM    891  C   PRO   110      21.767  44.902  10.631  1.00 17.33           C  
ATOM    892  O   PRO   110      21.566  43.727  10.878  1.00 18.00           O  
ATOM    893  CB  PRO   110      23.693  46.011  11.877  1.00 18.05           C  
ATOM    894  CG  PRO   110      24.670  47.112  11.485  1.00 20.81           C  
ATOM    895  CD  PRO   110      23.988  47.725  10.264  1.00 16.19           C  
ATOM    896  N   THR   111      20.779  45.761  10.386  1.00 17.33           N  
ATOM    897  CA  THR   111      19.362  45.360  10.360  1.00 18.97           C  
ATOM    898  C   THR   111      19.067  44.300   9.285  1.00 19.99           C  
ATOM    899  O   THR   111      18.183  43.453   9.462  1.00 20.53           O  
ATOM    900  CB  THR   111      18.509  46.609  10.107  1.00 21.00           C  
ATOM    901  OG1 THR   111      18.776  47.555  11.154  1.00 23.41           O  
ATOM    902  CG2 THR   111      17.008  46.263  10.007  1.00 17.86           C  
ATOM    903  N   PHE   112      19.787  44.369   8.160  1.00 16.89           N  
ATOM    904  CA  PHE   112      19.636  43.371   7.109  1.00 17.37           C  
ATOM    905  C   PHE   112      20.737  42.314   7.152  1.00 18.91           C  
ATOM    906  O   PHE   112      20.770  41.443   6.284  1.00 19.04           O  
ATOM    907  CB  PHE   112      19.554  44.029   5.725  1.00 21.08           C  
ATOM    908  CG  PHE   112      18.251  44.732   5.507  1.00 21.38           C  
ATOM    909  CD1 PHE   112      17.161  44.054   4.924  1.00 21.83           C  
ATOM    910  CD2 PHE   112      18.069  46.030   5.976  1.00 21.21           C  
ATOM    911  CE1 PHE   112      15.922  44.701   4.770  1.00 23.45           C  
ATOM    912  CE2 PHE   112      16.824  46.676   5.822  1.00 26.65           C  
ATOM    913  CZ  PHE   112      15.772  46.010   5.224  1.00 23.26           C  
ATOM    914  N   GLY   113      21.619  42.408   8.160  1.00 17.00           N  
ATOM    915  CA  GLY   113      22.760  41.450   8.343  1.00 19.86           C  
ATOM    916  C   GLY   113      23.708  41.372   7.156  1.00 19.08           C  
ATOM    917  O   GLY   113      24.320  40.316   6.875  1.00 17.65           O  
ATOM    918  N   VAL   114      23.822  42.488   6.453  1.00 16.66           N  
ATOM    919  CA  VAL   114      24.617  42.622   5.241  1.00 20.98           C  
ATOM    920  C   VAL   114      26.109  42.813   5.587  1.00 14.90           C  
ATOM    921  O   VAL   114      26.453  43.461   6.583  1.00 17.95           O  
ATOM    922  CB  VAL   114      24.061  43.812   4.391  1.00 22.54           C  
ATOM    923  CG1 VAL   114      25.108  44.402   3.471  1.00 26.90           C  
ATOM    924  CG2 VAL   114      22.800  43.348   3.641  1.00 20.80           C  
ATOM    925  N   ARG   115      26.992  42.207   4.798  1.00 18.90           N  
ATOM    926  CA  ARG   115      28.424  42.369   5.025  0.50 18.89           C  
ATOM    928  C   ARG   115      28.865  43.824   4.888  1.00 20.95           C  
ATOM    929  O   ARG   115      28.477  44.509   3.934  1.00 21.03           O  
ATOM    930  CB  ARG   115      29.202  41.456   4.089  0.50 25.76           C  
ATOM    932  CG  ARG   115      28.836  39.990   4.312  0.50 30.32           C  
ATOM    934  CD  ARG   115      29.435  39.054   3.279  0.50 39.53           C  
ATOM    936  NE  ARG   115      30.793  39.438   2.908  0.50 40.24           N  
ATOM    938  CZ  ARG   115      31.874  39.233   3.650  0.50 35.64           C  
ATOM    940  NH1 ARG   115      33.037  39.641   3.194  0.50 37.10           N  
ATOM    942  NH2 ARG   115      31.801  38.652   4.846  0.50 44.23           N  
ATOM    944  N   ALA   116      29.631  44.298   5.874  1.00 15.80           N  
ATOM    945  CA  ALA   116      30.150  45.685   5.878  1.00 23.26           C  
ATOM    946  C   ALA   116      31.663  45.682   5.736  1.00 22.47           C  
ATOM    947  O   ALA   116      32.346  44.741   6.166  1.00 22.50           O  
ATOM    948  CB  ALA   116      29.767  46.415   7.151  1.00 18.37           C  
ATOM    949  N   TYR   117      32.186  46.762   5.178  1.00 16.80           N  
ATOM    950  CA  TYR   117      33.643  46.870   4.922  1.00 16.57           C  
ATOM    951  C   TYR   117      34.160  48.128   5.558  1.00 19.40           C  
ATOM    952  O   TYR   117      33.404  49.096   5.756  1.00 17.01           O  
ATOM    953  CB  TYR   117      33.920  46.873   3.397  1.00 17.31           C  
ATOM    954  CG  TYR   117      33.361  45.617   2.746  1.00 19.59           C  
ATOM    955  CD1 TYR   117      34.018  44.399   2.876  1.00 20.47           C  
ATOM    956  CD2 TYR   117      32.124  45.637   2.084  1.00 20.52           C  
ATOM    957  CE1 TYR   117      33.501  43.243   2.328  1.00 17.56           C  
ATOM    958  CE2 TYR   117      31.601  44.488   1.515  1.00 22.34           C  
ATOM    959  CZ  TYR   117      32.279  43.295   1.653  1.00 22.06           C  
ATOM    960  OH  TYR   117      31.744  42.169   1.124  1.00 21.87           O  
ATOM    961  N   GLY   118      35.448  48.143   5.874  1.00 19.03           N  
ATOM    962  CA  GLY   118      36.030  49.316   6.478  1.00 19.24           C  
ATOM    963  C   GLY   118      37.527  49.267   6.295  1.00 16.72           C  
ATOM    964  O   GLY   118      38.090  48.234   5.913  1.00 20.13           O  
ATOM    965  N   VAL   119      38.164  50.403   6.517  1.00 16.32           N  
ATOM    966  CA  VAL   119      39.604  50.494   6.412  1.00 15.00           C  
ATOM    967  C   VAL   119      40.169  50.936   7.753  1.00 22.40           C  
ATOM    968  O   VAL   119      39.583  51.799   8.435  1.00 22.82           O  
ATOM    969  CB  VAL   119      40.100  51.440   5.249  1.00 22.27           C  
ATOM    970  CG1 VAL   119      39.592  50.948   3.891  1.00 19.88           C  
ATOM    971  CG2 VAL   119      39.690  52.898   5.489  1.00 22.21           C  
ATOM    972  N   HIS   120      41.285  50.311   8.137  1.00 18.08           N  
ATOM    973  CA  HIS   120      41.968  50.589   9.417  1.00 19.70           C  
ATOM    974  C   HIS   120      43.453  50.730   9.187  1.00 21.42           C  
ATOM    975  O   HIS   120      44.094  49.860   8.570  1.00 20.16           O  
ATOM    976  CB  HIS   120      41.709  49.468  10.444  1.00 18.67           C  
ATOM    977  CG  HIS   120      40.288  49.423  10.918  1.00 20.33           C  
ATOM    978  ND1 HIS   120      39.921  49.778  12.195  1.00 18.82           N  
ATOM    979  CD2 HIS   120      39.142  49.097  10.276  1.00 22.07           C  
ATOM    980  CE1 HIS   120      38.609  49.662  12.326  1.00 20.40           C  
ATOM    981  NE2 HIS   120      38.114  49.271  11.167  1.00 21.07           N  
ATOM    982  N   LEU   121      43.992  51.845   9.667  1.00 17.73           N  
ATOM    983  CA  LEU   121      45.391  52.168   9.486  1.00 19.07           C  
ATOM    984  C   LEU   121      46.194  52.043  10.780  1.00 17.80           C  
ATOM    985  O   LEU   121      45.801  52.603  11.817  1.00 19.58           O  
ATOM    986  CB  LEU   121      45.541  53.594   8.939  1.00 16.96           C  
ATOM    987  CG  LEU   121      46.996  54.056   8.719  1.00 19.89           C  
ATOM    988  CD1 LEU   121      47.636  53.390   7.537  1.00 22.06           C  
ATOM    989  CD2 LEU   121      47.033  55.582   8.509  1.00 22.75           C  
ATOM    990  N   ASN   122      47.303  51.298  10.705  1.00 19.55           N  
ATOM    991  CA  ASN   122      48.301  51.221  11.781  1.00 21.15           C  
ATOM    992  C   ASN   122      49.405  52.240  11.517  1.00 19.94           C  
ATOM    993  O   ASN   122      50.271  52.018  10.667  1.00 21.83           O  
ATOM    994  CB  ASN   122      48.888  49.806  11.905  1.00 17.68           C  
ATOM    995  CG  ASN   122      47.824  48.744  12.154  1.00 26.32           C  
ATOM    996  OD1 ASN   122      47.116  48.776  13.163  1.00 22.92           O  
ATOM    997  ND2 ASN   122      47.707  47.804  11.238  1.00 18.70           N  
ATOM    998  N   GLY   123      49.334  53.381  12.208  1.00 20.19           N  
ATOM    999  CA  GLY   123      50.345  54.440  12.079  1.00 18.15           C  
ATOM   1000  C   GLY   123      51.381  54.310  13.171  1.00 21.64           C  
ATOM   1001  O   GLY   123      51.065  54.442  14.366  1.00 22.55           O  
ATOM   1002  N   TYR   124      52.620  54.067  12.763  1.00 22.90           N  
ATOM   1003  CA  TYR   124      53.694  53.774  13.698  1.00 25.90           C  
ATOM   1004  C   TYR   124      55.020  54.490  13.366  1.00 25.41           C  
ATOM   1005  O   TYR   124      55.209  54.987  12.233  1.00 23.58           O  
ATOM   1006  CB  TYR   124      53.884  52.237  13.832  1.00 21.31           C  
ATOM   1007  CG  TYR   124      54.369  51.536  12.592  1.00 27.55           C  
ATOM   1008  CD1 TYR   124      55.728  51.400  12.332  1.00 30.72           C  
ATOM   1009  CD2 TYR   124      53.469  50.982  11.680  1.00 27.78           C  
ATOM   1010  CE1 TYR   124      56.182  50.760  11.192  1.00 31.47           C  
ATOM   1011  CE2 TYR   124      53.919  50.339  10.543  1.00 30.81           C  
ATOM   1012  CZ  TYR   124      55.265  50.228  10.304  1.00 31.70           C  
ATOM   1013  OH  TYR   124      55.719  49.579   9.177  1.00 42.11           O  
ATOM   1014  N   VAL   125      55.895  54.566  14.384  1.00 29.81           N  
ATOM   1015  CA  VAL   125      57.235  55.137  14.244  0.50 32.58           C  
ATOM   1017  C   VAL   125      58.246  54.234  14.931  1.00 34.47           C  
ATOM   1018  O   VAL   125      57.929  53.543  15.901  1.00 36.28           O  
ATOM   1019  CB  VAL   125      57.365  56.610  14.786  0.50 31.90           C  
ATOM   1021  CG1 VAL   125      56.598  57.581  13.923  0.50 28.83           C  
ATOM   1023  CG2 VAL   125      56.931  56.736  16.248  0.50 25.63           C  
ATOM   1025  N   GLY   126      59.472  54.206  14.407  1.00 37.83           N  
ATOM   1026  CA  GLY   126      60.529  53.399  15.017  1.00 35.15           C  
ATOM   1027  C   GLY   126      60.513  51.960  14.553  1.00 37.66           C  
ATOM   1028  O   GLY   126      59.729  51.601  13.680  1.00 38.85           O  
ATOM   1029  N   ALA   127      61.400  51.144  15.123  1.00 41.73           N  
ATOM   1030  CA  ALA   127      61.486  49.714  14.808  1.00 44.35           C  
ATOM   1031  C   ALA   127      61.973  48.958  16.031  1.00 47.23           C  
ATOM   1032  O   ALA   127      62.529  49.566  16.954  1.00 46.60           O  
ATOM   1033  CB  ALA   127      62.415  49.466  13.622  1.00 46.56           C  
ATOM   1034  N   GLY   128      61.751  47.644  16.037  1.00 47.40           N  
ATOM   1035  CA  GLY   128      62.218  46.768  17.107  1.00 50.12           C  
ATOM   1036  C   GLY   128      61.766  47.220  18.479  1.00 51.85           C  
ATOM   1037  O   GLY   128      60.591  47.487  18.685  1.00 49.32           O  
ATOM   1038  N   ALA   129      62.719  47.366  19.398  1.00 53.70           N  
ATOM   1039  CA  ALA   129      62.427  47.766  20.776  1.00 52.09           C  
ATOM   1040  C   ALA   129      61.864  49.189  20.926  1.00 49.76           C  
ATOM   1041  O   ALA   129      61.302  49.525  21.971  1.00 51.31           O  
ATOM   1042  CB  ALA   129      63.673  47.580  21.661  1.00 58.37           C  
ATOM   1043  N   ASP   130      61.988  50.006  19.878  1.00 42.21           N  
ATOM   1044  CA  ASP   130      61.566  51.406  19.908  0.50 41.80           C  
ATOM   1046  C   ASP   130      60.292  51.658  19.075  1.00 36.31           C  
ATOM   1047  O   ASP   130      59.968  52.791  18.752  1.00 38.36           O  
ATOM   1048  CB  ASP   130      62.718  52.293  19.417  0.50 40.53           C  
ATOM   1050  CG  ASP   130      64.080  51.814  19.913  0.50 50.35           C  
ATOM   1052  OD1 ASP   130      64.218  51.549  21.128  0.50 52.59           O  
ATOM   1054  OD2 ASP   130      65.011  51.699  19.084  0.50 53.48           O  
ATOM   1056  N   LEU   131      59.587  50.592  18.717  1.00 34.21           N  
ATOM   1057  CA  LEU   131      58.357  50.692  17.930  1.00 32.36           C  
ATOM   1058  C   LEU   131      57.231  51.347  18.729  1.00 29.17           C  
ATOM   1059  O   LEU   131      56.875  50.888  19.824  1.00 31.74           O  
ATOM   1060  CB  LEU   131      57.936  49.290  17.504  1.00 33.48           C  
ATOM   1061  CG  LEU   131      56.788  49.115  16.520  1.00 38.03           C  
ATOM   1062  CD1 LEU   131      57.146  49.674  15.163  1.00 38.14           C  
ATOM   1063  CD2 LEU   131      56.476  47.633  16.402  1.00 34.66           C  
ATOM   1064  N   HIS   132      56.697  52.440  18.189  1.00 27.61           N  
ATOM   1065  CA  HIS   132      55.625  53.187  18.816  1.00 23.90           C  
ATOM   1066  C   HIS   132      54.403  53.300  17.890  1.00 24.13           C  
ATOM   1067  O   HIS   132      54.568  53.508  16.702  1.00 28.10           O  
ATOM   1068  CB  HIS   132      56.104  54.594  19.205  1.00 25.85           C  
ATOM   1069  CG  HIS   132      57.031  54.617  20.382  1.00 24.89           C  
ATOM   1070  ND1 HIS   132      56.661  55.116  21.613  1.00 30.01           N  
ATOM   1071  CD2 HIS   132      58.310  54.197  20.517  1.00 29.31           C  
ATOM   1072  CE1 HIS   132      57.673  55.006  22.453  1.00 26.14           C  
ATOM   1073  NE2 HIS   132      58.684  54.446  21.815  1.00 33.17           N  
ATOM   1074  N   LEU   133      53.202  53.178  18.454  1.00 28.30           N  
ATOM   1075  CA  LEU   133      51.965  53.311  17.693  0.50 25.22           C  
ATOM   1077  C   LEU   133      51.192  54.565  18.089  1.00 28.50           C  
ATOM   1078  O   LEU   133      51.068  54.881  19.279  1.00 28.20           O  
ATOM   1079  CB  LEU   133      51.074  52.082  17.888  0.50 25.92           C  
ATOM   1081  CG  LEU   133      51.376  50.838  17.050  0.50 26.92           C  
ATOM   1083  CD1 LEU   133      50.895  49.605  17.797  0.50 26.96           C  
ATOM   1085  CD2 LEU   133      50.773  50.929  15.631  0.50 14.39           C  
ATOM   1087  N   TRP   134      50.677  55.273  17.079  1.00 24.73           N  
ATOM   1088  CA  TRP   134      49.741  56.378  17.310  1.00 28.04           C  
ATOM   1089  C   TRP   134      48.363  55.790  17.526  1.00 21.54           C  
ATOM   1090  O   TRP   134      47.880  55.030  16.697  1.00 27.82           O  
ATOM   1091  CB  TRP   134      49.680  57.332  16.115  1.00 24.82           C  
ATOM   1092  CG  TRP   134      50.814  58.286  16.080  1.00 25.59           C  
ATOM   1093  CD1 TRP   134      51.899  58.229  15.270  1.00 25.75           C  
ATOM   1094  CD2 TRP   134      50.989  59.436  16.920  1.00 27.94           C  
ATOM   1095  NE1 TRP   134      52.752  59.290  15.539  1.00 32.80           N  
ATOM   1096  CE2 TRP   134      52.208  60.045  16.547  1.00 32.27           C  
ATOM   1097  CE3 TRP   134      50.226  60.016  17.948  1.00 29.66           C  
ATOM   1098  CZ2 TRP   134      52.694  61.209  17.178  1.00 32.34           C  
ATOM   1099  CZ3 TRP   134      50.701  61.175  18.566  1.00 27.78           C  
ATOM   1100  CH2 TRP   134      51.928  61.751  18.178  1.00 25.76           C  
ATOM   1101  N   ILE   135      47.743  56.157  18.633  1.00 20.49           N  
ATOM   1102  CA  ILE   135      46.424  55.667  19.012  1.00 23.64           C  
ATOM   1103  C   ILE   135      45.507  56.876  19.036  1.00 24.63           C  
ATOM   1104  O   ILE   135      45.884  57.934  19.535  1.00 25.53           O  
ATOM   1105  CB  ILE   135      46.491  54.994  20.443  1.00 25.95           C  
ATOM   1106  CG1 ILE   135      47.393  53.740  20.415  1.00 32.16           C  
ATOM   1107  CG2 ILE   135      45.105  54.739  21.036  1.00 28.52           C  
ATOM   1108  CD1 ILE   135      47.131  52.779  19.275  1.00 32.57           C  
ATOM   1109  N   GLY   136      44.291  56.729  18.517  1.00 22.14           N  
ATOM   1110  CA  GLY   136      43.312  57.788  18.672  1.00 23.75           C  
ATOM   1111  C   GLY   136      42.392  57.506  19.845  1.00 29.17           C  
ATOM   1112  O   GLY   136      42.214  56.345  20.221  1.00 26.20           O  
ATOM   1113  N   ARG   137      41.853  58.561  20.468  1.00 27.14           N  
ATOM   1114  CA  ARG   137      40.785  58.419  21.449  0.50 27.41           C  
ATOM   1116  C   ARG   137      39.521  58.970  20.802  1.00 26.20           C  
ATOM   1117  O   ARG   137      39.511  60.130  20.393  1.00 30.01           O  
ATOM   1118  CB  ARG   137      41.113  59.202  22.723  0.50 28.24           C  
ATOM   1120  CG  ARG   137      40.424  58.677  23.983  0.50 35.93           C  
ATOM   1122  CD  ARG   137      40.349  59.720  25.115  0.50 34.31           C  
ATOM   1124  NE  ARG   137      41.505  60.618  25.170  0.50 35.77           N  
ATOM   1126  CZ  ARG   137      42.654  60.353  25.790  0.50 35.38           C  
ATOM   1128  NH1 ARG   137      43.629  61.251  25.770  0.50 40.30           N  
ATOM   1130  NH2 ARG   137      42.837  59.204  26.431  0.50 38.83           N  
ATOM   1132  N   ARG   138      38.478  58.146  20.717  1.00 26.46           N  
ATOM   1133  CA  ARG   138      37.248  58.524  20.025  1.00 25.62           C  
ATOM   1134  C   ARG   138      36.522  59.630  20.787  1.00 30.91           C  
ATOM   1135  O   ARG   138      36.602  59.709  22.021  1.00 29.45           O  
ATOM   1136  CB  ARG   138      36.339  57.304  19.832  1.00 23.64           C  
ATOM   1137  CG  ARG   138      36.966  56.242  18.907  1.00 21.94           C  
ATOM   1138  CD  ARG   138      36.266  54.910  18.996  1.00 20.70           C  
ATOM   1139  NE  ARG   138      34.880  54.968  18.531  1.00 22.86           N  
ATOM   1140  CZ  ARG   138      34.529  54.986  17.247  1.00 20.39           C  
ATOM   1141  NH1 ARG   138      35.457  54.949  16.293  1.00 22.53           N  
ATOM   1142  NH2 ARG   138      33.259  55.024  16.912  1.00 23.32           N  
ATOM   1143  N   SER   139      35.824  60.482  20.046  1.00 30.82           N  
ATOM   1144  CA  SER   139      35.057  61.578  20.638  1.00 30.87           C  
ATOM   1145  C   SER   139      33.940  61.000  21.509  1.00 34.11           C  
ATOM   1146  O   SER   139      33.421  59.916  21.203  1.00 30.95           O  
ATOM   1147  CB  SER   139      34.488  62.454  19.511  1.00 33.82           C  
ATOM   1148  OG  SER   139      33.340  63.180  19.913  1.00 44.80           O  
ATOM   1149  N   PRO   140      33.553  61.712  22.597  1.00 38.34           N  
ATOM   1150  CA  PRO   140      32.428  61.225  23.417  1.00 34.53           C  
ATOM   1151  C   PRO   140      31.082  61.213  22.695  1.00 37.90           C  
ATOM   1152  O   PRO   140      30.154  60.542  23.157  1.00 31.63           O  
ATOM   1153  CB  PRO   140      32.380  62.217  24.592  1.00 39.75           C  
ATOM   1154  CG  PRO   140      33.679  62.919  24.569  1.00 42.46           C  
ATOM   1155  CD  PRO   140      34.111  62.964  23.141  1.00 37.78           C  
ATOM   1156  N   ASP   141      30.996  61.920  21.563  1.00 35.55           N  
ATOM   1157  CA  ASP   141      29.781  62.004  20.771  1.00 36.36           C  
ATOM   1158  C   ASP   141      29.584  60.825  19.802  1.00 34.79           C  
ATOM   1159  O   ASP   141      28.527  60.709  19.174  1.00 34.78           O  
ATOM   1160  CB  ASP   141      29.739  63.340  20.013  1.00 44.42           C  
ATOM   1161  CG  ASP   141      29.874  64.547  20.938  1.00 49.36           C  
ATOM   1162  OD1 ASP   141      29.306  64.515  22.049  1.00 56.17           O  
ATOM   1163  OD2 ASP   141      30.558  65.525  20.559  1.00 52.17           O  
ATOM   1164  N   LYS   142      30.576  59.939  19.681  1.00 29.21           N  
ATOM   1165  CA  LYS   142      30.384  58.752  18.851  1.00 25.30           C  
ATOM   1166  C   LYS   142      29.212  57.930  19.356  1.00 25.78           C  
ATOM   1167  O   LYS   142      29.064  57.680  20.568  1.00 27.08           O  
ATOM   1168  CB  LYS   142      31.640  57.870  18.797  1.00 27.48           C  
ATOM   1169  CG  LYS   142      32.783  58.447  17.985  1.00 21.74           C  
ATOM   1170  CD  LYS   142      32.458  58.500  16.487  1.00 23.30           C  
ATOM   1171  CE  LYS   142      33.691  58.863  15.653  1.00 37.56           C  
ATOM   1172  NZ  LYS   142      33.392  58.674  14.195  1.00 34.81           N  
ATOM   1173  N   SER   143      28.395  57.504  18.408  1.00 28.71           N  
ATOM   1174  CA  SER   143      27.291  56.609  18.662  1.00 30.64           C  
ATOM   1175  C   SER   143      27.787  55.255  19.212  1.00 34.84           C  
ATOM   1176  O   SER   143      27.203  54.700  20.156  1.00 33.01           O  
ATOM   1177  CB  SER   143      26.516  56.417  17.359  1.00 38.43           C  
ATOM   1178  OG  SER   143      25.518  55.421  17.483  1.00 52.04           O  
ATOM   1179  N   VAL   144      28.881  54.763  18.625  1.00 26.02           N  
ATOM   1180  CA  VAL   144      29.490  53.472  18.954  1.00 27.84           C  
ATOM   1181  C   VAL   144      30.828  53.714  19.640  1.00 24.68           C  
ATOM   1182  O   VAL   144      31.624  54.538  19.176  1.00 29.30           O  
ATOM   1183  CB  VAL   144      29.689  52.619  17.656  1.00 24.85           C  
ATOM   1184  CG1 VAL   144      30.577  51.388  17.923  1.00 28.55           C  
ATOM   1185  CG2 VAL   144      28.334  52.209  17.074  1.00 29.86           C  
ATOM   1186  N   ALA   145      31.073  53.020  20.760  1.00 28.68           N  
ATOM   1187  CA  ALA   145      32.369  53.094  21.450  1.00 27.24           C  
ATOM   1188  C   ALA   145      32.860  54.538  21.737  1.00 24.20           C  
ATOM   1189  O   ALA   145      34.024  54.866  21.456  1.00 24.03           O  
ATOM   1190  CB  ALA   145      33.455  52.282  20.649  1.00 22.65           C  
ATOM   1191  N   PRO   146      31.979  55.416  22.294  1.00 26.11           N  
ATOM   1192  CA  PRO   146      32.462  56.776  22.548  1.00 27.01           C  
ATOM   1193  C   PRO   146      33.556  56.753  23.604  1.00 27.01           C  
ATOM   1194  O   PRO   146      33.477  55.947  24.536  1.00 26.67           O  
ATOM   1195  CB  PRO   146      31.219  57.494  23.089  1.00 26.92           C  
ATOM   1196  CG  PRO   146      30.367  56.410  23.679  1.00 26.95           C  
ATOM   1197  CD  PRO   146      30.582  55.243  22.751  1.00 26.57           C  
ATOM   1198  N   GLY   147      34.583  57.584  23.429  1.00 23.06           N  
ATOM   1199  CA  GLY   147      35.705  57.661  24.359  1.00 27.37           C  
ATOM   1200  C   GLY   147      36.691  56.497  24.326  1.00 31.76           C  
ATOM   1201  O   GLY   147      37.667  56.505  25.074  1.00 28.82           O  
ATOM   1202  N   LYS   148      36.440  55.491  23.485  1.00 27.28           N  
ATOM   1203  CA  LYS   148      37.332  54.317  23.405  1.00 26.06           C  
ATOM   1204  C   LYS   148      38.557  54.579  22.543  1.00 24.99           C  
ATOM   1205  O   LYS   148      38.583  55.495  21.700  1.00 22.55           O  
ATOM   1206  CB  LYS   148      36.593  53.091  22.883  1.00 28.51           C  
ATOM   1207  CG  LYS   148      35.318  52.761  23.627  1.00 30.74           C  
ATOM   1208  CD  LYS   148      35.550  52.390  25.007  1.00 43.85           C  
ATOM   1209  CE  LYS   148      35.908  50.942  25.127  1.00 32.51           C  
ATOM   1210  NZ  LYS   148      35.988  50.749  26.579  1.00 28.96           N  
ATOM   1211  N   LEU   149      39.580  53.755  22.738  1.00 19.09           N  
ATOM   1212  CA  LEU   149      40.799  53.869  21.978  1.00 20.06           C  
ATOM   1213  C   LEU   149      40.618  53.178  20.614  1.00 21.55           C  
ATOM   1214  O   LEU   149      39.808  52.249  20.469  1.00 19.47           O  
ATOM   1215  CB  LEU   149      41.978  53.254  22.739  1.00 19.37           C  
ATOM   1216  CG  LEU   149      42.239  53.841  24.143  1.00 22.93           C  
ATOM   1217  CD1 LEU   149      43.478  53.201  24.754  1.00 25.48           C  
ATOM   1218  CD2 LEU   149      42.424  55.331  24.014  1.00 24.59           C  
ATOM   1219  N   ASP   150      41.386  53.643  19.642  1.00 19.17           N  
ATOM   1220  CA  ASP   150      41.137  53.381  18.214  1.00 17.87           C  
ATOM   1221  C   ASP   150      42.435  53.385  17.456  1.00 21.13           C  
ATOM   1222  O   ASP   150      43.464  53.839  17.963  1.00 19.36           O  
ATOM   1223  CB  ASP   150      40.216  54.510  17.665  1.00 22.49           C  
ATOM   1224  CG  ASP   150      39.310  54.075  16.479  1.00 28.89           C  
ATOM   1225  OD1 ASP   150      39.538  53.036  15.793  1.00 24.67           O  
ATOM   1226  OD2 ASP   150      38.338  54.829  16.218  1.00 21.49           O  
ATOM   1227  N   ASN   151      42.412  52.873  16.220  1.00 19.91           N  
ATOM   1228  CA  ASN   151      43.513  53.121  15.292  1.00 18.90           C  
ATOM   1229  C   ASN   151      43.692  54.630  15.039  1.00 19.61           C  
ATOM   1230  O   ASN   151      42.763  55.413  15.282  1.00 21.72           O  
ATOM   1231  CB  ASN   151      43.249  52.436  13.953  1.00 19.47           C  
ATOM   1232  CG  ASN   151      42.927  50.965  14.110  1.00 21.52           C  
ATOM   1233  OD1 ASN   151      41.774  50.562  13.988  1.00 25.50           O  
ATOM   1234  ND2 ASN   151      43.938  50.165  14.449  1.00 24.44           N  
ATOM   1235  N   MET   152      44.869  55.023  14.553  1.00 20.04           N  
ATOM   1236  CA  MET   152      45.111  56.424  14.225  1.00 22.73           C  
ATOM   1237  C   MET   152      44.070  56.899  13.189  1.00 23.86           C  
ATOM   1238  O   MET   152      43.521  58.014  13.289  1.00 21.66           O  
ATOM   1239  CB  MET   152      46.514  56.636  13.679  1.00 18.42           C  
ATOM   1240  CG  MET   152      46.859  58.149  13.591  1.00 23.68           C  
ATOM   1241  SD  MET   152      48.604  58.426  12.865  0.70 28.49          SE  
ATOM   1242  CE  MET   152      48.177  58.085  11.003  1.00 34.44           C  
ATOM   1243  N   VAL   153      43.777  56.029  12.217  1.00 20.16           N  
ATOM   1244  CA  VAL   153      42.762  56.323  11.194  1.00 19.57           C  
ATOM   1245  C   VAL   153      41.943  55.047  10.963  1.00 19.06           C  
ATOM   1246  O   VAL   153      42.516  53.975  10.822  1.00 20.64           O  
ATOM   1247  CB  VAL   153      43.415  56.792   9.862  1.00 20.96           C  
ATOM   1248  CG1 VAL   153      42.353  56.936   8.741  1.00 24.65           C  
ATOM   1249  CG2 VAL   153      44.159  58.106  10.035  1.00 22.39           C  
ATOM   1250  N   ALA   154      40.617  55.163  10.971  1.00 19.92           N  
ATOM   1251  CA  ALA   154      39.731  54.023  10.657  1.00 21.62           C  
ATOM   1252  C   ALA   154      38.397  54.570  10.228  1.00 25.62           C  
ATOM   1253  O   ALA   154      37.948  55.570  10.773  1.00 25.22           O  
ATOM   1254  CB  ALA   154      39.524  53.137  11.885  1.00 20.52           C  
ATOM   1255  N   GLY   155      37.735  53.910   9.291  1.00 19.78           N  
ATOM   1256  CA  GLY   155      36.358  54.302   8.976  1.00 23.92           C  
ATOM   1257  C   GLY   155      35.641  53.261   8.154  1.00 25.11           C  
ATOM   1258  O   GLY   155      36.280  52.417   7.521  1.00 20.50           O  
ATOM   1259  N   GLY   156      34.313  53.317   8.176  1.00 16.33           N  
ATOM   1260  CA  GLY   156      33.510  52.527   7.267  1.00 17.20           C  
ATOM   1261  C   GLY   156      33.756  52.878   5.803  1.00 17.21           C  
ATOM   1262  O   GLY   156      34.197  53.983   5.475  1.00 20.27           O  
ATOM   1263  N   GLN   157      33.468  51.919   4.926  1.00 21.75           N  
ATOM   1264  CA  GLN   157      33.725  52.051   3.502  1.00 18.48           C  
ATOM   1265  C   GLN   157      32.454  52.429   2.761  1.00 20.30           C  
ATOM   1266  O   GLN   157      31.530  51.630   2.670  1.00 19.32           O  
ATOM   1267  CB  GLN   157      34.219  50.733   2.932  1.00 20.97           C  
ATOM   1268  CG  GLN   157      34.585  50.817   1.450  1.00 17.60           C  
ATOM   1269  CD  GLN   157      35.776  51.699   1.251  1.00 22.34           C  
ATOM   1270  OE1 GLN   157      36.605  51.847   2.153  1.00 20.60           O  
ATOM   1271  NE2 GLN   157      35.886  52.292   0.068  1.00 22.64           N  
ATOM   1272  N   PRO   158      32.420  53.634   2.195  1.00 20.08           N  
ATOM   1273  CA  PRO   158      31.248  53.977   1.381  1.00 22.50           C  
ATOM   1274  C   PRO   158      31.248  53.236   0.035  1.00 19.52           C  
ATOM   1275  O   PRO   158      32.300  52.813  -0.455  1.00 22.07           O  
ATOM   1276  CB  PRO   158      31.373  55.491   1.172  1.00 25.22           C  
ATOM   1277  CG  PRO   158      32.803  55.820   1.440  1.00 26.79           C  
ATOM   1278  CD  PRO   158      33.400  54.730   2.294  1.00 20.41           C  
ATOM   1279  N   ALA   159      30.050  53.050  -0.505  1.00 21.68           N  
ATOM   1280  CA  ALA   159      29.832  52.394  -1.781  1.00 23.81           C  
ATOM   1281  C   ALA   159      30.622  53.032  -2.917  1.00 28.04           C  
ATOM   1282  O   ALA   159      31.044  52.329  -3.845  1.00 25.76           O  
ATOM   1283  CB  ALA   159      28.379  52.443  -2.120  1.00 28.69           C  
ATOM   1284  N   ASP   160      30.840  54.346  -2.847  1.00 24.07           N  
ATOM   1285  CA  ASP   160      31.271  55.058  -4.054  1.00 33.19           C  
ATOM   1286  C   ASP   160      32.778  55.280  -4.144  1.00 33.50           C  
ATOM   1287  O   ASP   160      33.247  55.930  -5.091  1.00 25.67           O  
ATOM   1288  CB  ASP   160      30.494  56.378  -4.237  1.00 30.97           C  
ATOM   1289  CG  ASP   160      30.814  57.410  -3.164  1.00 39.20           C  
ATOM   1290  OD1 ASP   160      31.210  57.017  -2.048  1.00 33.72           O  
ATOM   1291  OD2 ASP   160      30.659  58.620  -3.436  1.00 46.55           O  
ATOM   1292  N   LEU   161      33.521  54.729  -3.178  1.00 24.34           N  
ATOM   1293  CA  LEU   161      34.989  54.888  -3.136  1.00 22.16           C  
ATOM   1294  C   LEU   161      35.713  53.536  -3.169  1.00 25.00           C  
ATOM   1295  O   LEU   161      35.177  52.523  -2.695  1.00 23.70           O  
ATOM   1296  CB  LEU   161      35.414  55.651  -1.874  1.00 22.56           C  
ATOM   1297  CG  LEU   161      34.928  57.096  -1.657  1.00 30.24           C  
ATOM   1298  CD1 LEU   161      35.634  57.695  -0.437  1.00 27.83           C  
ATOM   1299  CD2 LEU   161      35.183  57.934  -2.909  1.00 23.35           C  
ATOM   1300  N   SER   162      36.929  53.543  -3.710  1.00 19.44           N  
ATOM   1301  CA  SER   162      37.896  52.441  -3.518  1.00 18.75           C  
ATOM   1302  C   SER   162      38.383  52.464  -2.051  1.00 16.03           C  
ATOM   1303  O   SER   162      38.138  53.432  -1.324  1.00 18.03           O  
ATOM   1304  CB  SER   162      39.094  52.550  -4.471  1.00 17.15           C  
ATOM   1305  OG  SER   162      39.999  53.562  -4.049  1.00 20.75           O  
ATOM   1306  N   LEU   163      39.050  51.391  -1.627  1.00 19.00           N  
ATOM   1307  CA  LEU   163      39.595  51.317  -0.272  1.00 18.42           C  
ATOM   1308  C   LEU   163      40.671  52.381  -0.112  1.00 19.29           C  
ATOM   1309  O   LEU   163      40.718  53.055   0.905  1.00 17.38           O  
ATOM   1310  CB  LEU   163      40.196  49.919  -0.020  1.00 15.49           C  
ATOM   1311  CG  LEU   163      39.127  48.827  -0.009  1.00 17.28           C  
ATOM   1312  CD1 LEU   163      39.794  47.445  -0.052  1.00 19.40           C  
ATOM   1313  CD2 LEU   163      38.208  48.916   1.206  1.00 21.21           C  
ATOM   1314  N   ARG   164      41.510  52.514  -1.135  1.00 17.15           N  
ATOM   1315  CA  ARG   164      42.623  53.462  -1.087  1.00 22.19           C  
ATOM   1316  C   ARG   164      42.088  54.905  -1.016  1.00 22.29           C  
ATOM   1317  O   ARG   164      42.616  55.747  -0.281  1.00 22.06           O  
ATOM   1318  CB  ARG   164      43.540  53.283  -2.294  1.00 24.55           C  
ATOM   1319  CG  ARG   164      44.631  54.375  -2.420  1.00 26.08           C  
ATOM   1320  CD  ARG   164      45.627  54.235  -1.296  1.00 29.30           C  
ATOM   1321  NE  ARG   164      46.362  52.975  -1.399  1.00 38.00           N  
ATOM   1322  CZ  ARG   164      47.405  52.647  -0.639  1.00 34.41           C  
ATOM   1323  NH1 ARG   164      47.838  53.476   0.317  1.00 28.73           N  
ATOM   1324  NH2 ARG   164      48.010  51.489  -0.842  1.00 29.91           N  
ATOM   1325  N   GLN   165      41.038  55.181  -1.780  1.00 20.52           N  
ATOM   1326  CA  GLN   165      40.438  56.522  -1.806  1.00 21.23           C  
ATOM   1327  C   GLN   165      39.844  56.868  -0.457  1.00 21.59           C  
ATOM   1328  O   GLN   165      40.038  57.982   0.062  1.00 20.84           O  
ATOM   1329  CB  GLN   165      39.336  56.598  -2.863  1.00 21.52           C  
ATOM   1330  CG  GLN   165      39.894  56.847  -4.261  1.00 28.49           C  
ATOM   1331  CD  GLN   165      39.029  56.265  -5.354  1.00 36.32           C  
ATOM   1332  OE1 GLN   165      37.806  56.063  -5.196  1.00 26.17           O  
ATOM   1333  NE2 GLN   165      39.665  55.986  -6.491  1.00 39.85           N  
ATOM   1334  N   ASN   166      39.107  55.918   0.106  1.00 21.23           N  
ATOM   1335  CA  ASN   166      38.535  56.108   1.415  1.00 22.05           C  
ATOM   1336  C   ASN   166      39.629  56.262   2.475  1.00 22.07           C  
ATOM   1337  O   ASN   166      39.542  57.133   3.315  1.00 20.60           O  
ATOM   1338  CB  ASN   166      37.599  54.967   1.791  1.00 20.63           C  
ATOM   1339  CG  ASN   166      36.757  55.305   3.021  1.00 23.47           C  
ATOM   1340  OD1 ASN   166      36.291  56.449   3.168  1.00 23.28           O  
ATOM   1341  ND2 ASN   166      36.583  54.349   3.904  1.00 18.78           N  
ATOM   1342  N   LEU   167      40.657  55.415   2.423  1.00 19.16           N  
ATOM   1343  CA  LEU   167      41.799  55.585   3.326  1.00 22.36           C  
ATOM   1344  C   LEU   167      42.376  57.018   3.244  1.00 27.44           C  
ATOM   1345  O   LEU   167      42.636  57.642   4.269  1.00 22.88           O  
ATOM   1346  CB  LEU   167      42.895  54.563   3.029  1.00 20.82           C  
ATOM   1347  CG  LEU   167      44.107  54.634   3.965  1.00 26.27           C  
ATOM   1348  CD1 LEU   167      43.730  54.259   5.425  1.00 21.08           C  
ATOM   1349  CD2 LEU   167      45.208  53.749   3.420  1.00 22.64           C  
ATOM   1350  N   ILE   168      42.555  57.538   2.028  1.00 26.93           N  
ATOM   1351  CA  ILE   168      43.115  58.897   1.843  1.00 25.17           C  
ATOM   1352  C   ILE   168      42.233  59.979   2.470  1.00 24.22           C  
ATOM   1353  O   ILE   168      42.714  60.859   3.184  1.00 23.88           O  
ATOM   1354  CB  ILE   168      43.383  59.177   0.341  1.00 28.80           C  
ATOM   1355  CG1 ILE   168      44.609  58.378  -0.097  1.00 21.59           C  
ATOM   1356  CG2 ILE   168      43.611  60.674   0.062  1.00 24.28           C  
ATOM   1357  CD1 ILE   168      44.644  58.115  -1.579  1.00 29.12           C  
ATOM   1358  N   LYS   169      40.942  59.881   2.215  1.00 21.03           N  
ATOM   1359  CA  LYS   169      39.965  60.802   2.753  1.00 25.69           C  
ATOM   1360  C   LYS   169      39.921  60.744   4.277  1.00 27.01           C  
ATOM   1361  O   LYS   169      39.920  61.770   4.938  1.00 24.12           O  
ATOM   1362  CB  LYS   169      38.605  60.472   2.187  1.00 20.71           C  
ATOM   1363  CG  LYS   169      37.441  61.203   2.821  1.00 28.07           C  
ATOM   1364  CD  LYS   169      36.119  60.764   2.225  1.00 44.80           C  
ATOM   1365  CE  LYS   169      34.965  61.166   3.143  1.00 54.68           C  
ATOM   1366  NZ  LYS   169      33.661  60.638   2.662  1.00 64.28           N  
ATOM   1367  N   GLU   170      39.906  59.538   4.834  1.00 18.72           N  
ATOM   1368  CA  GLU   170      39.874  59.382   6.287  1.00 20.09           C  
ATOM   1369  C   GLU   170      41.139  59.892   6.938  1.00 23.18           C  
ATOM   1370  O   GLU   170      41.073  60.468   8.020  1.00 27.45           O  
ATOM   1371  CB  GLU   170      39.622  57.917   6.696  1.00 22.79           C  
ATOM   1372  CG  GLU   170      38.258  57.350   6.280  1.00 25.29           C  
ATOM   1373  CD  GLU   170      37.049  58.059   6.906  1.00 40.32           C  
ATOM   1374  OE1 GLU   170      36.871  59.283   6.729  1.00 53.74           O  
ATOM   1375  OE2 GLU   170      36.237  57.371   7.550  1.00 42.38           O  
ATOM   1376  N   CYS   171      42.271  59.697   6.276  1.00 20.72           N  
ATOM   1377  CA  CYS   171      43.568  60.139   6.779  1.00 23.54           C  
ATOM   1378  C   CYS   171      43.620  61.653   6.964  1.00 30.29           C  
ATOM   1379  O   CYS   171      44.135  62.136   7.976  1.00 28.00           O  
ATOM   1380  CB  CYS   171      44.709  59.704   5.866  1.00 24.69           C  
ATOM   1381  SG  CYS   171      45.309  57.986   6.121  1.00 24.58           S  
ATOM   1382  N   ALA   172      43.089  62.377   5.974  1.00 25.84           N  
ATOM   1383  CA  ALA   172      42.997  63.838   6.024  1.00 26.87           C  
ATOM   1384  C   ALA   172      41.963  64.287   7.049  1.00 24.26           C  
ATOM   1385  O   ALA   172      42.255  65.126   7.889  1.00 28.18           O  
ATOM   1386  CB  ALA   172      42.653  64.407   4.617  1.00 26.01           C  
ATOM   1387  N   GLU   173      40.763  63.712   7.013  1.00 23.60           N  
ATOM   1388  CA  GLU   173      39.687  64.192   7.870  1.00 31.06           C  
ATOM   1389  C   GLU   173      39.919  63.865   9.345  1.00 31.04           C  
ATOM   1390  O   GLU   173      39.618  64.676  10.216  1.00 30.90           O  
ATOM   1391  CB  GLU   173      38.336  63.634   7.421  1.00 28.56           C  
ATOM   1392  CG  GLU   173      37.884  64.143   6.052  1.00 33.70           C  
ATOM   1393  CD  GLU   173      36.558  63.542   5.607  1.00 44.95           C  
ATOM   1394  OE1 GLU   173      36.107  62.539   6.213  1.00 52.84           O  
ATOM   1395  OE2 GLU   173      35.976  64.071   4.633  1.00 57.87           O  
ATOM   1396  N   GLU   174      40.459  62.683   9.625  1.00 27.71           N  
ATOM   1397  CA  GLU   174      40.521  62.220  11.005  1.00 24.57           C  
ATOM   1398  C   GLU   174      41.802  62.587  11.697  1.00 23.74           C  
ATOM   1399  O   GLU   174      41.819  62.763  12.916  1.00 27.22           O  
ATOM   1400  CB  GLU   174      40.311  60.703  11.110  1.00 21.95           C  
ATOM   1401  CG  GLU   174      38.903  60.226  10.741  1.00 31.09           C  
ATOM   1402  CD  GLU   174      38.726  58.714  10.905  1.00 40.24           C  
ATOM   1403  OE1 GLU   174      39.712  58.058  11.331  1.00 29.99           O  
ATOM   1404  OE2 GLU   174      37.601  58.194  10.616  1.00 30.74           O  
ATOM   1405  N   ALA   175      42.886  62.691  10.937  1.00 23.54           N  
ATOM   1406  CA  ALA   175      44.190  62.794  11.559  1.00 26.67           C  
ATOM   1407  C   ALA   175      45.070  63.861  10.933  1.00 23.54           C  
ATOM   1408  O   ALA   175      46.236  64.004  11.327  1.00 26.48           O  
ATOM   1409  CB  ALA   175      44.898  61.448  11.543  1.00 25.30           C  
ATOM   1410  N   ASP   176      44.536  64.581   9.945  1.00 30.87           N  
ATOM   1411  CA  ASP   176      45.316  65.624   9.266  1.00 31.29           C  
ATOM   1412  C   ASP   176      46.584  65.021   8.650  1.00 31.62           C  
ATOM   1413  O   ASP   176      47.680  65.585   8.741  1.00 26.14           O  
ATOM   1414  CB  ASP   176      45.645  66.754  10.271  1.00 35.88           C  
ATOM   1415  CG  ASP   176      46.111  68.041   9.596  1.00 44.42           C  
ATOM   1416  OD1 ASP   176      45.799  68.242   8.402  1.00 42.23           O  
ATOM   1417  OD2 ASP   176      46.803  68.835  10.266  1.00 45.65           O  
ATOM   1418  N   LEU   177      46.436  63.833   8.063  1.00 28.64           N  
ATOM   1419  CA  LEU   177      47.547  63.153   7.415  1.00 28.98           C  
ATOM   1420  C   LEU   177      47.363  63.336   5.912  1.00 29.59           C  
ATOM   1421  O   LEU   177      46.375  62.864   5.350  1.00 29.80           O  
ATOM   1422  CB  LEU   177      47.591  61.655   7.796  1.00 28.47           C  
ATOM   1423  CG  LEU   177      48.676  60.813   7.119  1.00 31.21           C  
ATOM   1424  CD1 LEU   177      50.059  61.193   7.567  1.00 43.08           C  
ATOM   1425  CD2 LEU   177      48.462  59.350   7.408  1.00 35.93           C  
ATOM   1426  N   PRO   178      48.287  64.075   5.272  1.00 36.79           N  
ATOM   1427  CA  PRO   178      48.150  64.497   3.880  1.00 35.44           C  
ATOM   1428  C   PRO   178      48.266  63.343   2.903  1.00 31.05           C  
ATOM   1429  O   PRO   178      48.832  62.296   3.248  1.00 31.49           O  
ATOM   1430  CB  PRO   178      49.332  65.455   3.684  1.00 38.30           C  
ATOM   1431  CG  PRO   178      50.349  65.018   4.692  1.00 42.22           C  
ATOM   1432  CD  PRO   178      49.543  64.563   5.873  1.00 35.40           C  
ATOM   1433  N   GLU   179      47.743  63.564   1.695  1.00 33.20           N  
ATOM   1434  CA  GLU   179      47.658  62.554   0.647  1.00 34.92           C  
ATOM   1435  C   GLU   179      48.979  61.886   0.297  1.00 33.77           C  
ATOM   1436  O   GLU   179      49.014  60.670   0.118  1.00 35.14           O  
ATOM   1437  CB  GLU   179      47.021  63.129  -0.615  1.00 35.78           C  
ATOM   1438  CG  GLU   179      46.777  62.071  -1.703  1.00 36.31           C  
ATOM   1439  CD  GLU   179      45.889  62.560  -2.842  1.00 45.49           C  
ATOM   1440  OE1 GLU   179      45.597  63.774  -2.898  1.00 52.73           O  
ATOM   1441  OE2 GLU   179      45.477  61.722  -3.677  1.00 45.51           O  
ATOM   1442  N   ALA   180      50.058  62.667   0.227  1.00 36.39           N  
ATOM   1443  CA  ALA   180      51.379  62.133  -0.131  1.00 38.20           C  
ATOM   1444  C   ALA   180      51.853  61.056   0.853  1.00 37.77           C  
ATOM   1445  O   ALA   180      52.397  60.028   0.444  1.00 41.56           O  
ATOM   1446  CB  ALA   180      52.416  63.260  -0.251  1.00 40.78           C  
ATOM   1447  N   LEU   181      51.627  61.294   2.142  1.00 36.73           N  
ATOM   1448  CA  LEU   181      51.914  60.280   3.160  1.00 34.41           C  
ATOM   1449  C   LEU   181      50.891  59.141   3.182  1.00 27.36           C  
ATOM   1450  O   LEU   181      51.282  57.985   3.216  1.00 31.68           O  
ATOM   1451  CB  LEU   181      52.044  60.908   4.548  1.00 31.23           C  
ATOM   1452  CG  LEU   181      53.424  61.415   4.958  1.00 44.99           C  
ATOM   1453  CD1 LEU   181      53.292  62.339   6.142  1.00 46.78           C  
ATOM   1454  CD2 LEU   181      54.331  60.242   5.304  1.00 49.35           C  
ATOM   1455  N   ALA   182      49.589  59.457   3.184  1.00 24.43           N  
ATOM   1456  CA  ALA   182      48.533  58.431   3.118  1.00 26.05           C  
ATOM   1457  C   ALA   182      48.706  57.419   1.980  1.00 30.74           C  
ATOM   1458  O   ALA   182      48.386  56.233   2.140  1.00 25.47           O  
ATOM   1459  CB  ALA   182      47.142  59.081   3.053  1.00 25.43           C  
ATOM   1460  N   ARG   183      49.211  57.878   0.829  1.00 28.18           N  
ATOM   1461  CA  ARG   183      49.477  56.998  -0.308  1.00 31.04           C  
ATOM   1462  C   ARG   183      50.649  56.021  -0.087  1.00 25.44           C  
ATOM   1463  O   ARG   183      50.764  55.015  -0.789  1.00 29.60           O  
ATOM   1464  CB  ARG   183      49.697  57.813  -1.595  1.00 29.99           C  
ATOM   1465  CG  ARG   183      48.406  58.279  -2.240  1.00 34.47           C  
ATOM   1466  CD  ARG   183      48.654  58.995  -3.593  1.00 43.53           C  
ATOM   1467  NE  ARG   183      47.418  59.526  -4.180  1.00 42.49           N  
ATOM   1468  CZ  ARG   183      46.495  58.799  -4.812  1.00 45.86           C  
ATOM   1469  NH1 ARG   183      46.631  57.479  -4.952  1.00 51.31           N  
ATOM   1470  NH2 ARG   183      45.416  59.395  -5.297  1.00 49.80           N  
ATOM   1471  N   GLN   184      51.530  56.332   0.857  1.00 30.80           N  
ATOM   1472  CA  GLN   184      52.625  55.422   1.196  1.00 31.05           C  
ATOM   1473  C   GLN   184      52.169  54.233   2.055  1.00 27.05           C  
ATOM   1474  O   GLN   184      52.927  53.271   2.211  1.00 26.28           O  
ATOM   1475  CB  GLN   184      53.746  56.175   1.903  1.00 30.65           C  
ATOM   1476  CG  GLN   184      54.521  57.145   1.003  1.00 43.67           C  
ATOM   1477  CD  GLN   184      55.464  58.044   1.787  1.00 47.15           C  
ATOM   1478  OE1 GLN   184      56.057  57.632   2.791  1.00 55.62           O  
ATOM   1479  NE2 GLN   184      55.603  59.284   1.334  1.00 61.22           N  
ATOM   1480  N   ALA   185      50.965  54.313   2.632  1.00 27.12           N  
ATOM   1481  CA  ALA   185      50.421  53.199   3.447  1.00 26.49           C  
ATOM   1482  C   ALA   185      50.296  51.947   2.601  1.00 23.37           C  
ATOM   1483  O   ALA   185      49.831  52.000   1.454  1.00 26.33           O  
ATOM   1484  CB  ALA   185      49.064  53.550   4.049  1.00 22.77           C  
ATOM   1485  N   ILE   186      50.731  50.817   3.148  1.00 19.54           N  
ATOM   1486  CA  ILE   186      50.664  49.592   2.367  1.00 18.61           C  
ATOM   1487  C   ILE   186      49.586  48.655   2.902  1.00 19.53           C  
ATOM   1488  O   ILE   186      49.412  48.540   4.122  1.00 18.61           O  
ATOM   1489  CB  ILE   186      52.028  48.867   2.298  1.00 25.65           C  
ATOM   1490  CG1 ILE   186      52.474  48.403   3.664  1.00 23.08           C  
ATOM   1491  CG2 ILE   186      53.119  49.766   1.611  1.00 32.33           C  
ATOM   1492  CD1 ILE   186      53.373  47.159   3.562  1.00 23.38           C  
ATOM   1493  N   PRO   187      48.855  47.988   1.999  1.00 21.38           N  
ATOM   1494  CA  PRO   187      47.867  47.043   2.502  1.00 15.78           C  
ATOM   1495  C   PRO   187      48.569  45.828   3.087  1.00 20.47           C  
ATOM   1496  O   PRO   187      49.607  45.439   2.576  1.00 16.31           O  
ATOM   1497  CB  PRO   187      47.064  46.657   1.256  1.00 17.27           C  
ATOM   1498  CG  PRO   187      47.952  46.981   0.098  1.00 20.64           C  
ATOM   1499  CD  PRO   187      48.888  48.061   0.519  1.00 18.84           C  
ATOM   1500  N   VAL   188      48.046  45.287   4.183  1.00 18.73           N  
ATOM   1501  CA  VAL   188      48.744  44.218   4.909  1.00 16.69           C  
ATOM   1502  C   VAL   188      47.866  43.014   5.242  1.00 18.23           C  
ATOM   1503  O   VAL   188      48.310  42.075   5.917  1.00 21.16           O  
ATOM   1504  CB  VAL   188      49.437  44.737   6.215  1.00 19.46           C  
ATOM   1505  CG1 VAL   188      50.608  45.617   5.888  1.00 19.96           C  
ATOM   1506  CG2 VAL   188      48.436  45.460   7.141  1.00 15.01           C  
ATOM   1507  N   GLY   189      46.614  43.047   4.783  1.00 16.49           N  
ATOM   1508  CA  GLY   189      45.738  41.913   5.015  1.00 18.91           C  
ATOM   1509  C   GLY   189      44.371  42.407   5.404  1.00 18.87           C  
ATOM   1510  O   GLY   189      44.031  43.575   5.182  1.00 19.08           O  
ATOM   1511  N   ALA   190      43.588  41.519   5.986  1.00 16.54           N  
ATOM   1512  CA  ALA   190      42.232  41.863   6.412  1.00 20.59           C  
ATOM   1513  C   ALA   190      41.818  41.013   7.596  1.00 22.26           C  
ATOM   1514  O   ALA   190      42.310  39.908   7.782  1.00 22.93           O  
ATOM   1515  CB  ALA   190      41.193  41.719   5.252  1.00 17.91           C  
ATOM   1516  N   ILE   191      40.876  41.527   8.372  1.00 18.64           N  
ATOM   1517  CA  ILE   191      40.209  40.733   9.408  1.00 18.43           C  
ATOM   1518  C   ILE   191      38.742  40.564   9.089  1.00 21.37           C  
ATOM   1519  O   ILE   191      38.120  41.492   8.588  1.00 17.81           O  
ATOM   1520  CB  ILE   191      40.403  41.440  10.771  1.00 18.60           C  
ATOM   1521  CG1 ILE   191      41.794  41.129  11.305  1.00 22.38           C  
ATOM   1522  CG2 ILE   191      39.357  41.046  11.813  1.00 22.58           C  
ATOM   1523  CD1 ILE   191      42.241  42.201  12.244  1.00 27.81           C  
ATOM   1524  N   THR   192      38.193  39.370   9.332  1.00 16.15           N  
ATOM   1525  CA  THR   192      36.762  39.137   9.160  0.50 18.17           C  
ATOM   1527  C   THR   192      36.165  38.562  10.457  1.00 22.84           C  
ATOM   1528  O   THR   192      36.755  37.666  11.076  1.00 19.70           O  
ATOM   1529  CB  THR   192      36.505  38.231   7.926  0.50 23.49           C  
ATOM   1531  OG1 THR   192      36.932  38.911   6.737  0.50 21.60           O  
ATOM   1533  CG2 THR   192      35.053  37.898   7.769  0.50 12.87           C  
ATOM   1535  N   TYR   193      35.003  39.065  10.863  1.00 16.92           N  
ATOM   1536  CA  TYR   193      34.320  38.490  12.035  1.00 16.58           C  
ATOM   1537  C   TYR   193      32.832  38.520  11.779  1.00 20.59           C  
ATOM   1538  O   TYR   193      32.369  39.156  10.815  1.00 17.01           O  
ATOM   1539  CB  TYR   193      34.676  39.237  13.327  1.00 18.38           C  
ATOM   1540  CG  TYR   193      34.347  40.713  13.291  1.00 15.91           C  
ATOM   1541  CD1 TYR   193      33.058  41.166  13.568  1.00 20.25           C  
ATOM   1542  CD2 TYR   193      35.328  41.646  12.962  1.00 20.34           C  
ATOM   1543  CE1 TYR   193      32.761  42.513  13.536  1.00 20.52           C  
ATOM   1544  CE2 TYR   193      35.040  43.000  12.920  1.00 19.27           C  
ATOM   1545  CZ  TYR   193      33.755  43.418  13.219  1.00 16.20           C  
ATOM   1546  OH  TYR   193      33.448  44.772  13.151  1.00 20.98           O  
ATOM   1547  N   CYS   194      32.082  37.834  12.631  1.00 17.08           N  
ATOM   1548  CA  CYS   194      30.631  37.908  12.541  1.00 22.60           C  
ATOM   1549  C   CYS   194      30.028  37.871  13.931  1.00 22.09           C  
ATOM   1550  O   CYS   194      30.080  36.838  14.620  1.00 18.58           O  
ATOM   1551  CB  CYS   194      30.050  36.795  11.661  1.00 20.95           C  
ATOM   1552  SG  CYS   194      28.234  36.914  11.524  1.00 23.38           S  
ATOM   1553  N   MET   195      29.462  38.998  14.343  1.00 17.69           N  
ATOM   1554  CA  MET   195      28.851  39.085  15.673  1.00 18.41           C  
ATOM   1555  C   MET   195      27.433  39.597  15.665  1.00 20.71           C  
ATOM   1556  O   MET   195      27.045  40.381  14.778  1.00 20.17           O  
ATOM   1557  CB  MET   195      29.698  39.933  16.620  1.00 18.74           C  
ATOM   1558  CG  MET   195      29.772  41.398  16.224  1.00 25.25           C  
ATOM   1559  SD  MET   195      30.880  42.412  17.429  0.70 30.47          SE  
ATOM   1560  CE  MET   195      30.018  41.990  19.031  1.00 22.83           C  
ATOM   1561  N   GLU   196      26.663  39.172  16.666  1.00 20.84           N  
ATOM   1562  CA  GLU   196      25.352  39.749  16.911  1.00 21.64           C  
ATOM   1563  C   GLU   196      25.582  41.092  17.613  1.00 22.83           C  
ATOM   1564  O   GLU   196      26.303  41.181  18.614  1.00 20.50           O  
ATOM   1565  CB  GLU   196      24.470  38.823  17.761  1.00 21.99           C  
ATOM   1566  CG  GLU   196      23.072  39.424  17.999  1.00 28.14           C  
ATOM   1567  CD  GLU   196      22.005  38.428  18.472  1.00 27.63           C  
ATOM   1568  OE1 GLU   196      22.157  37.202  18.283  1.00 27.80           O  
ATOM   1569  OE2 GLU   196      20.982  38.917  19.004  1.00 38.54           O  
ATOM   1570  N   SER   197      24.962  42.137  17.088  1.00 20.19           N  
ATOM   1571  CA  SER   197      25.125  43.478  17.619  1.00 15.72           C  
ATOM   1572  C   SER   197      23.742  43.912  18.167  1.00 19.33           C  
ATOM   1573  O   SER   197      22.786  43.161  18.009  1.00 18.28           O  
ATOM   1574  CB  SER   197      25.552  44.410  16.490  1.00 18.24           C  
ATOM   1575  OG  SER   197      24.526  44.513  15.506  1.00 20.58           O  
ATOM   1576  N   PRO   198      23.651  45.084  18.836  1.00 19.82           N  
ATOM   1577  CA  PRO   198      22.353  45.521  19.391  1.00 25.01           C  
ATOM   1578  C   PRO   198      21.172  45.509  18.409  1.00 27.78           C  
ATOM   1579  O   PRO   198      20.049  45.138  18.784  1.00 27.26           O  
ATOM   1580  CB  PRO   198      22.640  46.948  19.858  1.00 21.66           C  
ATOM   1581  CG  PRO   198      24.110  46.942  20.199  1.00 25.92           C  
ATOM   1582  CD  PRO   198      24.735  46.026  19.187  1.00 21.79           C  
ATOM   1583  N   ALA   199      21.424  45.881  17.158  1.00 21.66           N  
ATOM   1584  CA  ALA   199      20.334  46.028  16.176  1.00 20.92           C  
ATOM   1585  C   ALA   199      20.302  44.928  15.105  1.00 27.82           C  
ATOM   1586  O   ALA   199      19.410  44.909  14.244  1.00 27.25           O  
ATOM   1587  CB  ALA   199      20.406  47.399  15.539  1.00 23.88           C  
ATOM   1588  N   GLY   200      21.269  44.016  15.139  1.00 21.47           N  
ATOM   1589  CA  GLY   200      21.257  42.919  14.178  1.00 20.08           C  
ATOM   1590  C   GLY   200      22.517  42.076  14.199  1.00 23.27           C  
ATOM   1591  O   GLY   200      22.938  41.612  15.250  1.00 23.02           O  
ATOM   1592  N   ILE   201      23.078  41.891  13.011  1.00 19.61           N  
ATOM   1593  CA  ILE   201      24.189  40.982  12.725  0.50 20.79           C  
ATOM   1595  C   ILE   201      25.253  41.788  11.991  1.00 21.52           C  
ATOM   1596  O   ILE   201      24.917  42.492  11.034  1.00 19.17           O  
ATOM   1597  CB  ILE   201      23.712  39.817  11.789  0.50 19.77           C  
ATOM   1599  CG1 ILE   201      22.825  38.828  12.545  0.50 23.67           C  
ATOM   1601  CG2 ILE   201      24.901  39.052  11.128  0.50 23.88           C  
ATOM   1603  CD1 ILE   201      23.586  37.842  13.400  0.50 30.69           C  
ATOM   1605  N   LYS   202      26.513  41.644  12.395  1.00 17.46           N  
ATOM   1606  CA  LYS   202      27.615  42.393  11.804  1.00 16.91           C  
ATOM   1607  C   LYS   202      28.686  41.412  11.283  1.00 19.03           C  
ATOM   1608  O   LYS   202      29.577  41.041  12.051  1.00 17.60           O  
ATOM   1609  CB  LYS   202      28.244  43.287  12.861  1.00 19.47           C  
ATOM   1610  CG  LYS   202      27.405  44.510  13.236  1.00 15.46           C  
ATOM   1611  CD  LYS   202      28.072  45.440  14.221  1.00 22.65           C  
ATOM   1612  CE  LYS   202      29.321  46.142  13.706  1.00 24.43           C  
ATOM   1613  NZ  LYS   202      29.066  47.055  12.516  1.00 27.31           N  
ATOM   1614  N   PRO   203      28.593  41.006   9.994  1.00 16.72           N  
ATOM   1615  CA  PRO   203      29.596  40.167   9.326  1.00 17.50           C  
ATOM   1616  C   PRO   203      30.545  41.129   8.652  1.00 18.96           C  
ATOM   1617  O   PRO   203      30.338  41.527   7.498  1.00 22.69           O  
ATOM   1618  CB  PRO   203      28.772  39.361   8.315  1.00 23.12           C  
ATOM   1619  CG  PRO   203      27.382  40.061   8.235  1.00 20.40           C  
ATOM   1620  CD  PRO   203      27.492  41.331   9.070  1.00 16.33           C  
ATOM   1621  N   ASP   204      31.554  41.558   9.391  1.00 14.49           N  
ATOM   1622  CA  ASP   204      32.398  42.684   8.939  1.00 18.90           C  
ATOM   1623  C   ASP   204      33.757  42.241   8.446  1.00 19.68           C  
ATOM   1624  O   ASP   204      34.325  41.264   8.944  1.00 19.53           O  
ATOM   1625  CB  ASP   204      32.610  43.701  10.053  1.00 17.03           C  
ATOM   1626  CG  ASP   204      31.314  44.405  10.487  1.00 21.45           C  
ATOM   1627  OD1 ASP   204      30.277  44.283   9.809  1.00 24.51           O  
ATOM   1628  OD2 ASP   204      31.358  45.071  11.528  1.00 25.88           O  
ATOM   1629  N   THR   205      34.267  42.983   7.469  1.00 16.49           N  
ATOM   1630  CA  THR   205      35.645  42.835   6.979  1.00 18.97           C  
ATOM   1631  C   THR   205      36.391  44.138   7.145  1.00 22.03           C  
ATOM   1632  O   THR   205      35.931  45.179   6.680  1.00 20.97           O  
ATOM   1633  CB  THR   205      35.650  42.381   5.527  1.00 20.97           C  
ATOM   1634  OG1 THR   205      35.084  41.066   5.454  1.00 18.93           O  
ATOM   1635  CG2 THR   205      37.050  42.330   4.966  1.00 18.62           C  
ATOM   1636  N   LEU   206      37.530  44.089   7.834  1.00 17.58           N  
ATOM   1637  CA  LEU   206      38.394  45.264   8.026  1.00 17.07           C  
ATOM   1638  C   LEU   206      39.632  45.098   7.186  1.00 19.34           C  
ATOM   1639  O   LEU   206      40.434  44.205   7.447  1.00 19.57           O  
ATOM   1640  CB  LEU   206      38.815  45.454   9.519  1.00 19.70           C  
ATOM   1641  CG  LEU   206      37.830  45.184  10.672  1.00 30.19           C  
ATOM   1642  CD1 LEU   206      38.456  45.413  12.051  1.00 30.63           C  
ATOM   1643  CD2 LEU   206      36.637  46.012  10.534  1.00 34.18           C  
ATOM   1644  N   PHE   207      39.797  45.960   6.190  1.00 15.14           N  
ATOM   1645  CA  PHE   207      41.012  45.982   5.403  1.00 14.18           C  
ATOM   1646  C   PHE   207      42.077  46.767   6.142  1.00 15.69           C  
ATOM   1647  O   PHE   207      41.870  47.911   6.555  1.00 19.26           O  
ATOM   1648  CB  PHE   207      40.737  46.514   3.988  1.00 15.92           C  
ATOM   1649  CG  PHE   207      39.840  45.607   3.185  1.00 19.36           C  
ATOM   1650  CD1 PHE   207      40.348  44.442   2.573  1.00 17.29           C  
ATOM   1651  CD2 PHE   207      38.484  45.899   3.052  1.00 16.61           C  
ATOM   1652  CE1 PHE   207      39.502  43.583   1.817  1.00 15.95           C  
ATOM   1653  CE2 PHE   207      37.653  45.048   2.310  1.00 18.64           C  
ATOM   1654  CZ  PHE   207      38.160  43.894   1.703  1.00 21.53           C  
ATOM   1655  N   LEU   208      43.247  46.163   6.259  1.00 16.02           N  
ATOM   1656  CA  LEU   208      44.265  46.699   7.147  1.00 16.18           C  
ATOM   1657  C   LEU   208      45.422  47.286   6.362  1.00 15.99           C  
ATOM   1658  O   LEU   208      45.801  46.761   5.317  1.00 17.80           O  
ATOM   1659  CB  LEU   208      44.773  45.584   8.056  1.00 17.30           C  
ATOM   1660  CG  LEU   208      43.666  44.740   8.702  1.00 21.82           C  
ATOM   1661  CD1 LEU   208      44.249  43.562   9.423  1.00 24.62           C  
ATOM   1662  CD2 LEU   208      42.840  45.588   9.656  1.00 21.41           C  
ATOM   1663  N   TYR   209      45.954  48.390   6.877  1.00 16.64           N  
ATOM   1664  CA  TYR   209      47.074  49.114   6.254  1.00 13.20           C  
ATOM   1665  C   TYR   209      48.103  49.478   7.319  1.00 18.91           C  
ATOM   1666  O   TYR   209      47.733  49.720   8.469  1.00 17.11           O  
ATOM   1667  CB  TYR   209      46.541  50.406   5.583  1.00 19.14           C  
ATOM   1668  CG  TYR   209      45.645  50.126   4.407  1.00 14.54           C  
ATOM   1669  CD1 TYR   209      46.130  50.167   3.107  1.00 16.75           C  
ATOM   1670  CD2 TYR   209      44.278  49.801   4.595  1.00 21.68           C  
ATOM   1671  CE1 TYR   209      45.281  49.903   1.991  1.00 21.68           C  
ATOM   1672  CE2 TYR   209      43.439  49.519   3.496  1.00 21.31           C  
ATOM   1673  CZ  TYR   209      43.959  49.570   2.209  1.00 20.17           C  
ATOM   1674  OH  TYR   209      43.129  49.283   1.152  1.00 21.68           O  
ATOM   1675  N   ASP   210      49.384  49.472   6.942  1.00 17.51           N  
ATOM   1676  CA  ASP   210      50.474  49.899   7.816  1.00 20.05           C  
ATOM   1677  C   ASP   210      51.129  51.115   7.175  1.00 19.12           C  
ATOM   1678  O   ASP   210      51.344  51.150   5.939  1.00 21.30           O  
ATOM   1679  CB  ASP   210      51.578  48.821   7.908  1.00 17.73           C  
ATOM   1680  CG  ASP   210      51.330  47.777   8.969  1.00 23.66           C  
ATOM   1681  OD1 ASP   210      50.234  47.740   9.580  1.00 19.71           O  
ATOM   1682  OD2 ASP   210      52.246  46.941   9.154  1.00 19.66           O  
ATOM   1683  N   LEU   211      51.483  52.081   8.014  1.00 21.44           N  
ATOM   1684  CA  LEU   211      52.293  53.218   7.583  1.00 19.60           C  
ATOM   1685  C   LEU   211      53.371  53.590   8.618  1.00 28.52           C  
ATOM   1686  O   LEU   211      53.047  53.917   9.773  1.00 25.01           O  
ATOM   1687  CB  LEU   211      51.396  54.433   7.289  1.00 21.33           C  
ATOM   1688  CG  LEU   211      52.079  55.711   6.778  1.00 23.75           C  
ATOM   1689  CD1 LEU   211      52.892  55.427   5.515  1.00 28.56           C  
ATOM   1690  CD2 LEU   211      51.050  56.768   6.486  1.00 21.28           C  
ATOM   1691  N   ALA   212      54.636  53.535   8.184  1.00 24.81           N  
ATOM   1692  CA  ALA   212      55.787  54.018   8.964  1.00 29.85           C  
ATOM   1693  C   ALA   212      55.828  55.527   8.798  1.00 29.57           C  
ATOM   1694  O   ALA   212      56.058  56.036   7.697  1.00 32.92           O  
ATOM   1695  CB  ALA   212      57.068  53.405   8.459  1.00 27.38           C  
ATOM   1696  N   LEU   213      55.551  56.239   9.876  1.00 25.42           N  
ATOM   1697  CA  LEU   213      55.416  57.697   9.832  1.00 25.21           C  
ATOM   1698  C   LEU   213      56.746  58.407  10.143  1.00 33.84           C  
ATOM   1699  O   LEU   213      57.605  57.834  10.822  1.00 36.56           O  
ATOM   1700  CB  LEU   213      54.344  58.147  10.814  1.00 25.79           C  
ATOM   1701  CG  LEU   213      52.903  57.810  10.408  1.00 27.39           C  
ATOM   1702  CD1 LEU   213      51.998  57.831  11.609  1.00 22.21           C  
ATOM   1703  CD2 LEU   213      52.419  58.783   9.358  1.00 32.76           C  
ATOM   1704  N   PRO   214      56.921  59.654   9.646  1.00 36.16           N  
ATOM   1705  CA  PRO   214      58.100  60.427  10.057  1.00 39.31           C  
ATOM   1706  C   PRO   214      58.066  60.728  11.559  1.00 34.96           C  
ATOM   1707  O   PRO   214      56.983  60.938  12.125  1.00 32.07           O  
ATOM   1708  CB  PRO   214      57.956  61.741   9.269  1.00 37.83           C  
ATOM   1709  CG  PRO   214      57.019  61.437   8.155  1.00 42.05           C  
ATOM   1710  CD  PRO   214      56.072  60.421   8.720  1.00 34.03           C  
ATOM   1711  N   GLU   215      59.244  60.772  12.182  1.00 38.88           N  
ATOM   1712  CA  GLU   215      59.400  61.115  13.605  1.00 42.52           C  
ATOM   1713  C   GLU   215      58.699  62.427  13.981  1.00 40.78           C  
ATOM   1714  O   GLU   215      58.184  62.559  15.092  1.00 41.45           O  
ATOM   1715  CB  GLU   215      60.889  61.205  13.984  1.00 47.40           C  
ATOM   1716  CG  GLU   215      61.675  59.879  13.903  1.00 61.85           C  
ATOM   1717  CD  GLU   215      61.590  59.037  15.173  1.00 71.62           C  
ATOM   1718  OE1 GLU   215      61.330  59.612  16.254  1.00 77.66           O  
ATOM   1719  OE2 GLU   215      61.789  57.799  15.091  1.00 66.95           O  
ATOM   1720  N   ASP   216      58.667  63.374  13.043  1.00 40.78           N  
ATOM   1721  CA  ASP   216      58.096  64.696  13.291  1.00 42.30           C  
ATOM   1722  C   ASP   216      56.617  64.850  12.910  1.00 42.05           C  
ATOM   1723  O   ASP   216      56.042  65.911  13.149  1.00 40.61           O  
ATOM   1724  CB  ASP   216      58.958  65.813  12.665  1.00 47.09           C  
ATOM   1725  CG  ASP   216      58.932  65.811  11.131  1.00 58.78           C  
ATOM   1726  OD1 ASP   216      58.804  64.731  10.514  1.00 70.12           O  
ATOM   1727  OD2 ASP   216      59.056  66.903  10.535  1.00 58.84           O  
ATOM   1728  N   PHE   217      55.990  63.813  12.342  1.00 33.84           N  
ATOM   1729  CA  PHE   217      54.531  63.879  12.124  1.00 28.76           C  
ATOM   1730  C   PHE   217      53.736  63.857  13.447  1.00 28.64           C  
ATOM   1731  O   PHE   217      54.063  63.107  14.375  1.00 33.24           O  
ATOM   1732  CB  PHE   217      54.032  62.756  11.171  1.00 31.39           C  
ATOM   1733  CG  PHE   217      52.537  62.770  10.970  1.00 34.89           C  
ATOM   1734  CD1 PHE   217      51.953  63.682  10.090  1.00 31.80           C  
ATOM   1735  CD2 PHE   217      51.708  61.919  11.707  1.00 30.13           C  
ATOM   1736  CE1 PHE   217      50.574  63.734   9.928  1.00 35.26           C  
ATOM   1737  CE2 PHE   217      50.343  61.968  11.554  1.00 26.65           C  
ATOM   1738  CZ  PHE   217      49.767  62.879  10.664  1.00 30.87           C  
ATOM   1739  N   ARG   218      52.701  64.691  13.531  1.00 30.24           N  
ATOM   1740  CA  ARG   218      51.765  64.675  14.649  1.00 33.07           C  
ATOM   1741  C   ARG   218      50.362  64.664  14.087  1.00 33.27           C  
ATOM   1742  O   ARG   218      50.005  65.570  13.349  1.00 30.02           O  
ATOM   1743  CB  ARG   218      51.913  65.918  15.548  1.00 36.17           C  
ATOM   1744  CG  ARG   218      53.292  66.156  16.149  1.00 38.66           C  
ATOM   1745  CD  ARG   218      53.636  65.164  17.279  1.00 44.01           C  
ATOM   1746  NE  ARG   218      54.971  65.428  17.825  1.00 50.41           N  
ATOM   1747  CZ  ARG   218      56.105  64.916  17.348  1.00 48.17           C  
ATOM   1748  NH1 ARG   218      56.091  64.081  16.319  1.00 53.09           N  
ATOM   1749  NH2 ARG   218      57.263  65.226  17.916  1.00 52.78           N  
ATOM   1750  N   PRO   219      49.551  63.642  14.425  1.00 32.18           N  
ATOM   1751  CA  PRO   219      48.154  63.704  13.986  1.00 28.77           C  
ATOM   1752  C   PRO   219      47.327  64.817  14.674  1.00 35.00           C  
ATOM   1753  O   PRO   219      47.516  65.087  15.867  1.00 35.22           O  
ATOM   1754  CB  PRO   219      47.602  62.299  14.338  1.00 26.16           C  
ATOM   1755  CG  PRO   219      48.499  61.797  15.400  1.00 29.84           C  
ATOM   1756  CD  PRO   219      49.859  62.389  15.144  1.00 29.45           C  
ATOM   1757  N   HIS   220      46.438  65.469  13.920  1.00 30.48           N  
ATOM   1758  CA  HIS   220      45.476  66.413  14.512  1.00 32.09           C  
ATOM   1759  C   HIS   220      44.077  66.058  14.111  1.00 30.14           C  
ATOM   1760  O   HIS   220      43.835  65.693  12.971  1.00 30.55           O  
ATOM   1761  CB  HIS   220      45.781  67.860  14.106  1.00 37.92           C  
ATOM   1762  CG  HIS   220      47.209  68.246  14.322  1.00 41.04           C  
ATOM   1763  ND1 HIS   220      48.122  68.330  13.293  1.00 50.01           N  
ATOM   1764  CD2 HIS   220      47.894  68.530  15.457  1.00 45.11           C  
ATOM   1765  CE1 HIS   220      49.305  68.660  13.781  1.00 40.41           C  
ATOM   1766  NE2 HIS   220      49.194  68.786  15.092  1.00 44.64           N  
ATOM   1767  N   ASN   221      43.153  66.229  15.047  1.00 25.59           N  
ATOM   1768  CA  ASN   221      41.767  65.783  14.921  1.00 31.42           C  
ATOM   1769  C   ASN   221      40.854  66.733  14.118  1.00 34.72           C  
ATOM   1770  O   ASN   221      39.805  67.183  14.617  1.00 40.74           O  
ATOM   1771  CB  ASN   221      41.192  65.500  16.330  1.00 32.04           C  
ATOM   1772  CG  ASN   221      41.034  66.778  17.195  1.00 41.90           C  
ATOM   1773  OD1 ASN   221      41.773  67.752  17.028  1.00 42.49           O  
ATOM   1774  ND2 ASN   221      40.056  66.768  18.105  1.00 30.00           N  
ATOM   1775  N   THR   222      41.229  66.990  12.866  1.00 34.65           N  
ATOM   1776  CA  THR   222      40.516  67.939  11.978  1.00 37.42           C  
ATOM   1777  C   THR   222      38.978  67.898  12.029  1.00 39.37           C  
ATOM   1778  O   THR   222      38.344  68.925  12.252  1.00 40.20           O  
ATOM   1779  CB  THR   222      41.007  67.833  10.506  1.00 40.30           C  
ATOM   1780  OG1 THR   222      42.441  67.862  10.475  1.00 38.41           O  
ATOM   1781  CG2 THR   222      40.467  68.991   9.654  1.00 37.82           C  
ATOM   1782  N   ASP   223      38.375  66.725  11.856  1.00 33.08           N  
ATOM   1783  CA  ASP   223      36.914  66.646  11.873  1.00 36.16           C  
ATOM   1784  C   ASP   223      36.279  66.357  13.243  1.00 36.45           C  
ATOM   1785  O   ASP   223      35.053  66.241  13.343  1.00 38.37           O  
ATOM   1786  CB  ASP   223      36.392  65.690  10.786  1.00 37.98           C  
ATOM   1787  CG  ASP   223      36.618  64.223  11.118  1.00 42.50           C  
ATOM   1788  OD1 ASP   223      37.293  63.886  12.122  1.00 34.80           O  
ATOM   1789  OD2 ASP   223      36.106  63.402  10.344  1.00 36.90           O  
ATOM   1790  N   GLY   224      37.111  66.244  14.282  1.00 35.55           N  
ATOM   1791  CA  GLY   224      36.630  66.034  15.654  1.00 36.89           C  
ATOM   1792  C   GLY   224      36.020  64.671  15.976  1.00 36.39           C  
ATOM   1793  O   GLY   224      35.449  64.482  17.054  1.00 40.38           O  
ATOM   1794  N   GLU   225      36.125  63.723  15.042  1.00 32.74           N  
ATOM   1795  CA  GLU   225      35.722  62.336  15.276  1.00 33.39           C  
ATOM   1796  C   GLU   225      36.597  61.697  16.367  1.00 31.95           C  
ATOM   1797  O   GLU   225      36.143  60.836  17.113  1.00 26.70           O  
ATOM   1798  CB  GLU   225      35.884  61.520  13.996  1.00 34.72           C  
ATOM   1799  CG  GLU   225      34.769  61.677  12.971  1.00 35.77           C  
ATOM   1800  CD  GLU   225      34.913  60.657  11.831  1.00 48.02           C  
ATOM   1801  OE1 GLU   225      34.275  59.583  11.894  1.00 36.79           O  
ATOM   1802  OE2 GLU   225      35.692  60.911  10.885  1.00 46.05           O  
ATOM   1803  N   MET   226      37.861  62.104  16.409  1.00 30.60           N  
ATOM   1804  CA  MET   226      38.780  61.764  17.497  1.00 33.62           C  
ATOM   1805  C   MET   226      38.879  62.927  18.495  1.00 35.35           C  
ATOM   1806  O   MET   226      39.017  64.078  18.089  1.00 34.95           O  
ATOM   1807  CB  MET   226      40.182  61.499  16.949  1.00 30.26           C  
ATOM   1808  CG  MET   226      40.305  60.311  16.011  1.00 38.22           C  
ATOM   1809  SD  MET   226      39.791  58.599  16.819  0.70 33.77          SE  
ATOM   1810  CE  MET   226      40.212  57.510  15.238  1.00 43.66           C  
ATOM   1811  N   ALA   227      38.835  62.611  19.788  1.00 30.11           N  
ATOM   1812  CA  ALA   227      39.070  63.585  20.851  1.00 30.34           C  
ATOM   1813  C   ALA   227      40.531  64.052  20.907  1.00 38.31           C  
ATOM   1814  O   ALA   227      40.797  65.253  21.065  1.00 39.38           O  
ATOM   1815  CB  ALA   227      38.624  63.028  22.201  1.00 32.23           C  
ATOM   1816  N   ASP   228      41.459  63.100  20.764  1.00 29.95           N  
ATOM   1817  CA  ASP   228      42.897  63.383  20.736  0.50 32.07           C  
ATOM   1819  C   ASP   228      43.640  62.133  20.291  1.00 31.14           C  
ATOM   1820  O   ASP   228      43.016  61.111  19.979  1.00 30.62           O  
ATOM   1821  CB  ASP   228      43.422  63.840  22.108  0.50 37.97           C  
ATOM   1823  CG  ASP   228      43.307  62.764  23.162  0.50 37.14           C  
ATOM   1825  OD1 ASP   228      42.167  62.425  23.532  0.50 39.67           O  
ATOM   1827  OD2 ASP   228      44.356  62.264  23.619  0.50 48.07           O  
ATOM   1829  N   PHE   229      44.961  62.237  20.221  1.00 23.57           N  
ATOM   1830  CA  PHE   229      45.842  61.157  19.805  1.00 28.22           C  
ATOM   1831  C   PHE   229      46.978  60.986  20.814  1.00 32.28           C  
ATOM   1832  O   PHE   229      47.356  61.956  21.464  1.00 29.69           O  
ATOM   1833  CB  PHE   229      46.454  61.481  18.450  1.00 27.21           C  
ATOM   1834  CG  PHE   229      45.462  61.500  17.324  1.00 28.89           C  
ATOM   1835  CD1 PHE   229      45.107  60.316  16.674  1.00 25.77           C  
ATOM   1836  CD2 PHE   229      44.905  62.698  16.895  1.00 29.22           C  
ATOM   1837  CE1 PHE   229      44.203  60.321  15.640  1.00 25.83           C  
ATOM   1838  CE2 PHE   229      43.985  62.718  15.846  1.00 29.84           C  
ATOM   1839  CZ  PHE   229      43.626  61.523  15.225  1.00 23.27           C  
ATOM   1840  N   MET   230      47.504  59.761  20.943  1.00 30.54           N  
ATOM   1841  CA  MET   230      48.633  59.475  21.839  0.50 31.97           C  
ATOM   1843  C   MET   230      49.613  58.548  21.148  1.00 32.95           C  
ATOM   1844  O   MET   230      49.212  57.668  20.384  1.00 30.38           O  
ATOM   1845  CB  MET   230      48.170  58.804  23.139  0.50 29.98           C  
ATOM   1847  CG  MET   230      47.326  59.655  24.086  0.50 30.10           C  
ATOM   1849  SD  MET   230      46.461  58.547  25.462  0.35 35.81          SE  
ATOM   1851  CE  MET   230      45.786  57.198  24.278  0.50  9.41           C  
ATOM   1853  N   LEU   231      50.903  58.740  21.417  1.00 26.63           N  
ATOM   1854  CA  LEU   231      51.928  57.875  20.870  1.00 24.90           C  
ATOM   1855  C   LEU   231      52.402  56.944  21.983  1.00 32.60           C  
ATOM   1856  O   LEU   231      52.984  57.400  22.973  1.00 27.40           O  
ATOM   1857  CB  LEU   231      53.092  58.697  20.318  1.00 22.14           C  
ATOM   1858  CG  LEU   231      54.213  57.917  19.627  1.00 27.92           C  
ATOM   1859  CD1 LEU   231      53.690  57.195  18.374  1.00 31.77           C  
ATOM   1860  CD2 LEU   231      55.354  58.858  19.235  1.00 34.90           C  
ATOM   1861  N   TRP   232      52.153  55.643  21.825  1.00 26.63           N  
ATOM   1862  CA  TRP   232      52.468  54.657  22.873  1.00 27.49           C  
ATOM   1863  C   TRP   232      53.463  53.641  22.351  1.00 24.44           C  
ATOM   1864  O   TRP   232      53.424  53.335  21.153  1.00 24.35           O  
ATOM   1865  CB  TRP   232      51.214  53.888  23.242  1.00 25.56           C  
ATOM   1866  CG  TRP   232      50.254  54.542  24.163  1.00 33.99           C  
ATOM   1867  CD1 TRP   232      50.243  55.857  24.583  1.00 30.32           C  
ATOM   1868  CD2 TRP   232      49.111  53.920  24.754  1.00 30.78           C  
ATOM   1869  NE1 TRP   232      49.172  56.067  25.416  1.00 28.93           N  
ATOM   1870  CE2 TRP   232      48.459  54.899  25.537  1.00 33.17           C  
ATOM   1871  CE3 TRP   232      48.592  52.611  24.734  1.00 25.26           C  
ATOM   1872  CZ2 TRP   232      47.301  54.615  26.278  1.00 33.10           C  
ATOM   1873  CZ3 TRP   232      47.429  52.341  25.462  1.00 31.07           C  
ATOM   1874  CH2 TRP   232      46.803  53.334  26.220  1.00 29.08           C  
ATOM   1875  N   PRO   233      54.330  53.081  23.229  1.00 25.37           N  
ATOM   1876  CA  PRO   233      55.152  51.969  22.783  1.00 26.06           C  
ATOM   1877  C   PRO   233      54.231  50.848  22.323  1.00 24.38           C  
ATOM   1878  O   PRO   233      53.160  50.647  22.927  1.00 22.96           O  
ATOM   1879  CB  PRO   233      55.902  51.547  24.060  1.00 29.18           C  
ATOM   1880  CG  PRO   233      55.941  52.785  24.901  1.00 28.56           C  
ATOM   1881  CD  PRO   233      54.598  53.424  24.647  1.00 28.32           C  
ATOM   1882  N   ALA   234      54.615  50.163  21.250  1.00 23.20           N  
ATOM   1883  CA  ALA   234      53.779  49.101  20.681  1.00 25.59           C  
ATOM   1884  C   ALA   234      53.388  48.077  21.749  1.00 22.71           C  
ATOM   1885  O   ALA   234      52.225  47.682  21.809  1.00 21.44           O  
ATOM   1886  CB  ALA   234      54.464  48.417  19.496  1.00 27.69           C  
ATOM   1887  N   ALA   235      54.338  47.677  22.603  1.00 25.08           N  
ATOM   1888  CA  ALA   235      54.065  46.687  23.659  1.00 23.69           C  
ATOM   1889  C   ALA   235      52.959  47.126  24.629  1.00 24.83           C  
ATOM   1890  O   ALA   235      52.156  46.305  25.065  1.00 23.63           O  
ATOM   1891  CB  ALA   235      55.343  46.309  24.415  1.00 29.81           C  
ATOM   1892  N   LYS   236      52.898  48.420  24.935  1.00 24.16           N  
ATOM   1893  CA  LYS   236      51.849  48.978  25.790  1.00 27.58           C  
ATOM   1894  C   LYS   236      50.451  48.847  25.143  1.00 21.12           C  
ATOM   1895  O   LYS   236      49.450  48.578  25.825  1.00 22.07           O  
ATOM   1896  CB  LYS   236      52.180  50.448  26.117  1.00 26.72           C  
ATOM   1897  CG  LYS   236      51.190  51.123  27.037  1.00 30.02           C  
ATOM   1898  CD  LYS   236      51.459  52.607  27.212  1.00 37.84           C  
ATOM   1899  CE  LYS   236      50.410  53.245  28.131  1.00 45.71           C  
ATOM   1900  NZ  LYS   236      50.697  54.688  28.391  1.00 44.63           N  
ATOM   1901  N   VAL   237      50.386  49.019  23.816  1.00 21.52           N  
ATOM   1902  CA  VAL   237      49.122  48.858  23.075  1.00 19.23           C  
ATOM   1903  C   VAL   237      48.692  47.392  23.125  1.00 17.87           C  
ATOM   1904  O   VAL   237      47.555  47.073  23.417  1.00 19.86           O  
ATOM   1905  CB  VAL   237      49.262  49.352  21.594  1.00 21.36           C  
ATOM   1906  CG1 VAL   237      47.994  49.054  20.745  1.00 21.80           C  
ATOM   1907  CG2 VAL   237      49.561  50.862  21.578  1.00 19.94           C  
ATOM   1908  N   VAL   238      49.638  46.515  22.828  1.00 15.89           N  
ATOM   1909  CA  VAL   238      49.356  45.083  22.794  1.00 17.55           C  
ATOM   1910  C   VAL   238      48.889  44.625  24.185  1.00 18.38           C  
ATOM   1911  O   VAL   238      47.898  43.906  24.296  1.00 17.12           O  
ATOM   1912  CB  VAL   238      50.579  44.302  22.299  1.00 20.65           C  
ATOM   1913  CG1 VAL   238      50.349  42.779  22.475  1.00 17.40           C  
ATOM   1914  CG2 VAL   238      50.879  44.646  20.838  1.00 22.23           C  
ATOM   1915  N   GLU   239      49.575  45.053  25.254  1.00 20.45           N  
ATOM   1916  CA  GLU   239      49.154  44.644  26.606  1.00 19.51           C  
ATOM   1917  C   GLU   239      47.828  45.270  27.046  1.00 17.58           C  
ATOM   1918  O   GLU   239      47.054  44.633  27.746  1.00 19.73           O  
ATOM   1919  CB  GLU   239      50.231  44.906  27.659  1.00 18.69           C  
ATOM   1920  CG  GLU   239      51.537  44.178  27.372  1.00 18.82           C  
ATOM   1921  CD  GLU   239      51.459  42.647  27.407  1.00 23.22           C  
ATOM   1922  OE1 GLU   239      50.465  42.043  27.875  1.00 29.15           O  
ATOM   1923  OE2 GLU   239      52.440  42.036  26.965  1.00 26.04           O  
ATOM   1924  N   ALA   240      47.560  46.498  26.609  1.00 18.60           N  
ATOM   1925  CA  ALA   240      46.227  47.090  26.833  1.00 18.75           C  
ATOM   1926  C   ALA   240      45.097  46.233  26.209  1.00 21.18           C  
ATOM   1927  O   ALA   240      44.067  46.000  26.831  1.00 17.62           O  
ATOM   1928  CB  ALA   240      46.183  48.550  26.332  1.00 18.84           C  
ATOM   1929  N   VAL   241      45.310  45.713  25.002  1.00 19.17           N  
ATOM   1930  CA  VAL   241      44.324  44.848  24.381  1.00 16.76           C  
ATOM   1931  C   VAL   241      44.267  43.498  25.112  1.00 15.47           C  
ATOM   1932  O   VAL   241      43.178  42.958  25.346  1.00 18.92           O  
ATOM   1933  CB  VAL   241      44.643  44.686  22.855  1.00 20.22           C  
ATOM   1934  CG1 VAL   241      43.787  43.559  22.183  1.00 17.92           C  
ATOM   1935  CG2 VAL   241      44.413  46.033  22.172  1.00 14.08           C  
ATOM   1936  N   ARG   242      45.422  42.960  25.515  1.00 14.46           N  
ATOM   1937  CA  ARG   242      45.425  41.642  26.181  1.00 16.30           C  
ATOM   1938  C   ARG   242      44.592  41.660  27.459  1.00 18.93           C  
ATOM   1939  O   ARG   242      43.795  40.741  27.716  1.00 21.27           O  
ATOM   1940  CB  ARG   242      46.864  41.171  26.494  1.00 15.30           C  
ATOM   1941  CG  ARG   242      46.889  39.763  27.067  1.00 16.78           C  
ATOM   1942  CD  ARG   242      48.226  39.519  27.784  1.00 22.29           C  
ATOM   1943  NE  ARG   242      49.335  39.487  26.843  1.00 20.03           N  
ATOM   1944  CZ  ARG   242      49.637  38.449  26.058  1.00 21.15           C  
ATOM   1945  NH1 ARG   242      48.907  37.328  26.050  1.00 21.56           N  
ATOM   1946  NH2 ARG   242      50.687  38.534  25.272  1.00 19.17           N  
ATOM   1947  N   THR   243      44.715  42.746  28.226  1.00 18.75           N  
ATOM   1948  CA  THR   243      44.213  42.720  29.582  1.00 20.29           C  
ATOM   1949  C   THR   243      43.134  43.725  29.948  1.00 20.77           C  
ATOM   1950  O   THR   243      42.682  43.716  31.088  1.00 20.63           O  
ATOM   1951  CB  THR   243      45.375  42.827  30.613  1.00 23.74           C  
ATOM   1952  OG1 THR   243      46.034  44.069  30.452  1.00 29.54           O  
ATOM   1953  CG2 THR   243      46.376  41.733  30.398  1.00 27.63           C  
ATOM   1954  N   THR   244      42.724  44.592  29.014  1.00 19.31           N  
ATOM   1955  CA  THR   244      41.730  45.624  29.312  1.00 20.53           C  
ATOM   1956  C   THR   244      40.672  45.705  28.197  1.00 24.18           C  
ATOM   1957  O   THR   244      40.803  45.067  27.141  1.00 19.20           O  
ATOM   1958  CB  THR   244      42.349  47.061  29.504  1.00 21.98           C  
ATOM   1959  OG1 THR   244      42.659  47.636  28.232  1.00 20.95           O  
ATOM   1960  CG2 THR   244      43.608  47.072  30.385  1.00 22.52           C  
ATOM   1961  N   GLU   245      39.649  46.532  28.423  1.00 22.28           N  
ATOM   1962  CA  GLU   245      38.659  46.803  27.380  1.00 21.28           C  
ATOM   1963  C   GLU   245      38.762  48.249  26.933  1.00 22.53           C  
ATOM   1964  O   GLU   245      37.759  48.847  26.603  1.00 22.94           O  
ATOM   1965  CB  GLU   245      37.243  46.518  27.900  1.00 25.72           C  
ATOM   1966  CG  GLU   245      37.013  45.108  28.390  1.00 29.04           C  
ATOM   1967  CD  GLU   245      36.556  44.167  27.293  1.00 39.66           C  
ATOM   1968  OE1 GLU   245      36.793  44.438  26.084  1.00 43.88           O  
ATOM   1969  OE2 GLU   245      35.930  43.148  27.639  1.00 34.03           O  
ATOM   1970  N   ALA   246      39.976  48.799  26.936  1.00 18.23           N  
ATOM   1971  CA  ALA   246      40.195  50.198  26.597  1.00 23.71           C  
ATOM   1972  C   ALA   246      39.887  50.482  25.118  1.00 25.82           C  
ATOM   1973  O   ALA   246      39.454  51.582  24.780  1.00 23.44           O  
ATOM   1974  CB  ALA   246      41.633  50.571  26.876  1.00 21.63           C  
ATOM   1975  N   PHE   247      40.124  49.490  24.248  1.00 20.81           N  
ATOM   1976  CA  PHE   247      39.980  49.691  22.795  1.00 20.54           C  
ATOM   1977  C   PHE   247      38.572  49.387  22.298  1.00 21.57           C  
ATOM   1978  O   PHE   247      37.861  48.501  22.835  1.00 21.62           O  
ATOM   1979  CB  PHE   247      41.037  48.883  22.019  1.00 17.15           C  
ATOM   1980  CG  PHE   247      42.407  49.520  22.021  1.00 24.57           C  
ATOM   1981  CD1 PHE   247      42.832  50.293  20.932  1.00 22.20           C  
ATOM   1982  CD2 PHE   247      43.256  49.386  23.128  1.00 20.78           C  
ATOM   1983  CE1 PHE   247      44.094  50.901  20.935  1.00 24.41           C  
ATOM   1984  CE2 PHE   247      44.516  49.983  23.134  1.00 24.91           C  
ATOM   1985  CZ  PHE   247      44.928  50.753  22.045  1.00 21.88           C  
ATOM   1986  N   LYS   248      38.157  50.113  21.258  1.00 19.66           N  
ATOM   1987  CA  LYS   248      36.895  49.781  20.572  1.00 15.71           C  
ATOM   1988  C   LYS   248      36.908  48.307  20.192  1.00 17.36           C  
ATOM   1989  O   LYS   248      37.957  47.775  19.831  1.00 16.16           O  
ATOM   1990  CB  LYS   248      36.785  50.665  19.313  1.00 20.31           C  
ATOM   1991  CG  LYS   248      35.653  50.308  18.350  1.00 19.58           C  
ATOM   1992  CD  LYS   248      35.383  51.525  17.446  1.00 20.79           C  
ATOM   1993  CE  LYS   248      34.446  51.169  16.277  1.00 19.70           C  
ATOM   1994  NZ  LYS   248      35.252  50.527  15.166  1.00 22.92           N  
ATOM   1995  N   PHE   249      35.758  47.644  20.279  1.00 16.33           N  
ATOM   1996  CA  PHE   249      35.678  46.156  20.219  1.00 16.95           C  
ATOM   1997  C   PHE   249      36.470  45.499  19.069  1.00 17.92           C  
ATOM   1998  O   PHE   249      37.251  44.547  19.278  1.00 20.40           O  
ATOM   1999  CB  PHE   249      34.203  45.693  20.232  1.00 17.22           C  
ATOM   2000  CG  PHE   249      33.419  46.084  18.995  1.00 27.57           C  
ATOM   2001  CD1 PHE   249      33.226  45.166  17.948  1.00 23.89           C  
ATOM   2002  CD2 PHE   249      32.841  47.348  18.884  1.00 34.84           C  
ATOM   2003  CE1 PHE   249      32.526  45.533  16.794  1.00 24.40           C  
ATOM   2004  CE2 PHE   249      32.121  47.707  17.741  1.00 29.75           C  
ATOM   2005  CZ  PHE   249      31.971  46.811  16.697  1.00 29.91           C  
ATOM   2006  N   ASN   250      36.319  46.021  17.857  1.00 17.89           N  
ATOM   2007  CA  ASN   250      36.948  45.377  16.717  1.00 18.87           C  
ATOM   2008  C   ASN   250      38.357  45.863  16.478  1.00 19.30           C  
ATOM   2009  O   ASN   250      39.125  45.186  15.831  1.00 17.61           O  
ATOM   2010  CB  ASN   250      36.074  45.436  15.463  1.00 19.36           C  
ATOM   2011  CG  ASN   250      35.623  46.859  15.113  1.00 26.18           C  
ATOM   2012  OD1 ASN   250      36.006  47.833  15.762  1.00 21.97           O  
ATOM   2013  ND2 ASN   250      34.794  46.966  14.082  1.00 23.76           N  
ATOM   2014  N   VAL   251      38.705  47.014  17.053  1.00 17.26           N  
ATOM   2015  CA  VAL   251      40.090  47.489  17.021  1.00 17.67           C  
ATOM   2016  C   VAL   251      41.045  46.546  17.793  1.00 15.70           C  
ATOM   2017  O   VAL   251      42.209  46.395  17.416  1.00 20.55           O  
ATOM   2018  CB  VAL   251      40.213  48.959  17.474  1.00 18.07           C  
ATOM   2019  CG1 VAL   251      41.693  49.419  17.429  1.00 19.60           C  
ATOM   2020  CG2 VAL   251      39.326  49.855  16.598  1.00 20.52           C  
ATOM   2021  N   ASN   252      40.554  45.898  18.853  1.00 16.54           N  
ATOM   2022  CA  ASN   252      41.300  44.796  19.520  1.00 19.17           C  
ATOM   2023  C   ASN   252      41.835  43.794  18.486  1.00 17.97           C  
ATOM   2024  O   ASN   252      43.016  43.390  18.550  1.00 13.67           O  
ATOM   2025  CB  ASN   252      40.427  44.044  20.518  1.00 16.95           C  
ATOM   2026  CG  ASN   252      40.085  44.874  21.712  1.00 21.39           C  
ATOM   2027  OD1 ASN   252      40.966  45.357  22.403  1.00 21.20           O  
ATOM   2028  ND2 ASN   252      38.796  45.077  21.939  1.00 18.46           N  
ATOM   2029  N   LEU   253      40.979  43.415  17.544  1.00 16.65           N  
ATOM   2030  CA  LEU   253      41.404  42.493  16.468  1.00 19.56           C  
ATOM   2031  C   LEU   253      42.543  43.033  15.601  1.00 16.73           C  
ATOM   2032  O   LEU   253      43.489  42.301  15.315  1.00 18.19           O  
ATOM   2033  CB  LEU   253      40.229  42.022  15.603  1.00 18.12           C  
ATOM   2034  CG  LEU   253      38.922  41.578  16.300  1.00 20.48           C  
ATOM   2035  CD1 LEU   253      37.904  41.116  15.291  1.00 21.68           C  
ATOM   2036  CD2 LEU   253      39.152  40.512  17.330  1.00 20.21           C  
ATOM   2037  N   THR   254      42.473  44.311  15.194  1.00 15.24           N  
ATOM   2038  CA  THR   254      43.556  44.925  14.404  1.00 18.27           C  
ATOM   2039  C   THR   254      44.865  44.978  15.187  1.00 16.83           C  
ATOM   2040  O   THR   254      45.934  44.825  14.612  1.00 17.38           O  
ATOM   2041  CB  THR   254      43.206  46.367  13.943  1.00 21.69           C  
ATOM   2042  OG1 THR   254      43.306  47.269  15.053  1.00 19.60           O  
ATOM   2043  CG2 THR   254      41.784  46.421  13.327  1.00 18.91           C  
ATOM   2044  N   VAL   255      44.787  45.190  16.513  1.00 16.92           N  
ATOM   2045  CA  VAL   255      46.014  45.184  17.332  1.00 20.44           C  
ATOM   2046  C   VAL   255      46.648  43.772  17.414  1.00 16.81           C  
ATOM   2047  O   VAL   255      47.861  43.602  17.301  1.00 15.75           O  
ATOM   2048  CB  VAL   255      45.729  45.717  18.762  1.00 23.19           C  
ATOM   2049  CG1 VAL   255      46.961  45.580  19.637  1.00 17.22           C  
ATOM   2050  CG2 VAL   255      45.271  47.183  18.700  1.00 17.07           C  
ATOM   2051  N   ILE   256      45.817  42.770  17.622  1.00 15.06           N  
ATOM   2052  CA  ILE   256      46.283  41.365  17.645  1.00 16.72           C  
ATOM   2053  C   ILE   256      46.945  40.996  16.304  1.00 18.72           C  
ATOM   2054  O   ILE   256      48.041  40.424  16.277  1.00 17.73           O  
ATOM   2055  CB  ILE   256      45.117  40.416  17.975  1.00 15.49           C  
ATOM   2056  CG1 ILE   256      44.671  40.628  19.426  1.00 16.40           C  
ATOM   2057  CG2 ILE   256      45.526  38.931  17.782  1.00 15.97           C  
ATOM   2058  CD1 ILE   256      43.271  40.002  19.721  1.00 17.55           C  
ATOM   2059  N   ASP   257      46.308  41.383  15.204  1.00 13.78           N  
ATOM   2060  CA  ASP   257      46.861  41.172  13.864  1.00 15.76           C  
ATOM   2061  C   ASP   257      48.199  41.850  13.683  1.00 15.74           C  
ATOM   2062  O   ASP   257      49.140  41.264  13.139  1.00 14.56           O  
ATOM   2063  CB  ASP   257      45.867  41.648  12.794  1.00 18.64           C  
ATOM   2064  CG  ASP   257      46.470  41.626  11.405  1.00 26.78           C  
ATOM   2065  OD1 ASP   257      46.453  40.556  10.783  1.00 20.72           O  
ATOM   2066  OD2 ASP   257      46.996  42.664  10.954  1.00 20.29           O  
ATOM   2067  N   PHE   258      48.273  43.108  14.105  1.00 16.25           N  
ATOM   2068  CA  PHE   258      49.528  43.852  14.067  1.00 17.51           C  
ATOM   2069  C   PHE   258      50.622  43.141  14.865  1.00 16.83           C  
ATOM   2070  O   PHE   258      51.773  43.018  14.390  1.00 17.69           O  
ATOM   2071  CB  PHE   258      49.323  45.269  14.626  1.00 15.95           C  
ATOM   2072  CG  PHE   258      50.559  46.166  14.516  1.00 17.88           C  
ATOM   2073  CD1 PHE   258      50.725  47.003  13.413  1.00 17.31           C  
ATOM   2074  CD2 PHE   258      51.537  46.171  15.533  1.00 17.86           C  
ATOM   2075  CE1 PHE   258      51.858  47.838  13.312  1.00 20.55           C  
ATOM   2076  CE2 PHE   258      52.654  46.980  15.434  1.00 23.41           C  
ATOM   2077  CZ  PHE   258      52.815  47.810  14.323  1.00 18.10           C  
ATOM   2078  N   ALA   259      50.285  42.691  16.073  1.00 14.66           N  
ATOM   2079  CA  ALA   259      51.247  41.942  16.906  1.00 17.15           C  
ATOM   2080  C   ALA   259      51.777  40.679  16.212  1.00 16.42           C  
ATOM   2081  O   ALA   259      52.985  40.380  16.281  1.00 17.86           O  
ATOM   2082  CB  ALA   259      50.584  41.557  18.213  1.00 16.20           C  
ATOM   2083  N   ILE   260      50.876  39.950  15.553  1.00 15.43           N  
ATOM   2084  CA  ILE   260      51.263  38.743  14.796  1.00 17.05           C  
ATOM   2085  C   ILE   260      52.194  39.088  13.631  1.00 21.68           C  
ATOM   2086  O   ILE   260      53.265  38.511  13.498  1.00 17.54           O  
ATOM   2087  CB  ILE   260      50.004  37.957  14.309  1.00 15.84           C  
ATOM   2088  CG1 ILE   260      49.276  37.306  15.480  1.00 15.26           C  
ATOM   2089  CG2 ILE   260      50.356  36.946  13.221  1.00 13.29           C  
ATOM   2090  CD1 ILE   260      47.801  37.088  15.148  1.00 20.98           C  
ATOM   2091  N   ARG   261      51.829  40.091  12.840  1.00 16.50           N  
ATOM   2092  CA  ARG   261      52.593  40.431  11.650  1.00 17.41           C  
ATOM   2093  C   ARG   261      53.957  41.067  11.969  1.00 20.27           C  
ATOM   2094  O   ARG   261      54.883  40.981  11.167  1.00 17.78           O  
ATOM   2095  CB  ARG   261      51.767  41.376  10.777  1.00 18.71           C  
ATOM   2096  CG  ARG   261      50.631  40.706  10.003  1.00 18.49           C  
ATOM   2097  CD  ARG   261      49.895  41.730   9.083  1.00 19.15           C  
ATOM   2098  NE  ARG   261      49.374  42.927   9.773  1.00 15.15           N  
ATOM   2099  CZ  ARG   261      49.999  44.110   9.879  1.00 17.36           C  
ATOM   2100  NH1 ARG   261      51.185  44.316   9.312  1.00 13.59           N  
ATOM   2101  NH2 ARG   261      49.410  45.118  10.534  1.00 17.72           N  
ATOM   2102  N   HIS   262      54.049  41.730  13.125  1.00 18.55           N  
ATOM   2103  CA  HIS   262      55.287  42.423  13.520  1.00 18.49           C  
ATOM   2104  C   HIS   262      56.111  41.632  14.541  1.00 19.93           C  
ATOM   2105  O   HIS   262      57.079  42.156  15.116  1.00 20.40           O  
ATOM   2106  CB  HIS   262      54.993  43.845  14.015  1.00 20.26           C  
ATOM   2107  CG  HIS   262      54.594  44.785  12.917  1.00 22.68           C  
ATOM   2108  ND1 HIS   262      55.464  45.707  12.373  1.00 26.66           N  
ATOM   2109  CD2 HIS   262      53.422  44.926  12.243  1.00 19.17           C  
ATOM   2110  CE1 HIS   262      54.846  46.384  11.418  1.00 25.84           C  
ATOM   2111  NE2 HIS   262      53.615  45.915  11.305  1.00 22.21           N  
ATOM   2112  N   GLY   263      55.748  40.363  14.727  1.00 15.73           N  
ATOM   2113  CA  GLY   263      56.525  39.416  15.539  1.00 18.52           C  
ATOM   2114  C   GLY   263      56.471  39.718  17.035  1.00 23.51           C  
ATOM   2115  O   GLY   263      57.383  39.371  17.767  1.00 19.61           O  
ATOM   2116  N   LEU   264      55.410  40.379  17.482  1.00 14.70           N  
ATOM   2117  CA  LEU   264      55.305  40.807  18.894  1.00 17.57           C  
ATOM   2118  C   LEU   264      54.781  39.666  19.747  1.00 21.10           C  
ATOM   2119  O   LEU   264      54.997  39.651  20.979  1.00 24.41           O  
ATOM   2120  CB  LEU   264      54.405  42.057  19.037  1.00 21.79           C  
ATOM   2121  CG  LEU   264      54.894  43.310  18.267  1.00 23.31           C  
ATOM   2122  CD1 LEU   264      54.040  44.564  18.553  1.00 26.68           C  
ATOM   2123  CD2 LEU   264      56.367  43.588  18.518  1.00 29.60           C  
ATOM   2124  N   ILE   265      54.031  38.749  19.115  1.00 18.52           N  
ATOM   2125  CA  ILE   265      53.686  37.475  19.752  1.00 22.83           C  
ATOM   2126  C   ILE   265      54.260  36.308  18.926  1.00 22.38           C  
ATOM   2127  O   ILE   265      54.466  36.436  17.709  1.00 22.45           O  
ATOM   2128  CB  ILE   265      52.160  37.348  20.072  1.00 25.81           C  
ATOM   2129  CG1 ILE   265      51.316  37.513  18.820  1.00 23.62           C  
ATOM   2130  CG2 ILE   265      51.719  38.400  21.120  1.00 28.12           C  
ATOM   2131  CD1 ILE   265      49.815  37.437  19.137  1.00 30.09           C  
ATOM   2132  N   ASP   266      54.528  35.182  19.589  1.00 17.59           N  
ATOM   2133  CA  ASP   266      55.396  34.130  19.052  1.00 18.41           C  
ATOM   2134  C   ASP   266      54.716  32.788  19.309  1.00 14.35           C  
ATOM   2135  O   ASP   266      54.356  32.498  20.449  1.00 17.74           O  
ATOM   2136  CB  ASP   266      56.736  34.200  19.769  1.00 22.76           C  
ATOM   2137  CG  ASP   266      57.793  33.287  19.155  1.00 23.74           C  
ATOM   2138  OD1 ASP   266      57.485  32.100  18.885  1.00 18.42           O  
ATOM   2139  OD2 ASP   266      58.934  33.756  18.958  1.00 28.70           O  
ATOM   2140  N   PRO   267      54.519  31.984  18.263  1.00 14.45           N  
ATOM   2141  CA  PRO   267      53.801  30.706  18.408  1.00 18.63           C  
ATOM   2142  C   PRO   267      54.476  29.707  19.342  1.00 19.37           C  
ATOM   2143  O   PRO   267      53.824  28.755  19.780  1.00 18.58           O  
ATOM   2144  CB  PRO   267      53.784  30.167  16.977  1.00 15.64           C  
ATOM   2145  CG  PRO   267      55.031  30.801  16.347  1.00 17.26           C  
ATOM   2146  CD  PRO   267      54.945  32.200  16.867  1.00 20.06           C  
ATOM   2147  N   ASP   268      55.740  29.927  19.664  1.00 15.62           N  
ATOM   2148  CA  ASP   268      56.414  29.081  20.623  1.00 15.57           C  
ATOM   2149  C   ASP   268      55.906  29.264  22.063  1.00 18.65           C  
ATOM   2150  O   ASP   268      56.171  28.468  22.893  1.00 20.39           O  
ATOM   2151  CB  ASP   268      57.926  29.260  20.596  1.00 15.64           C  
ATOM   2152  CG  ASP   268      58.650  28.193  19.765  1.00 20.73           C  
ATOM   2153  OD1 ASP   268      58.176  27.083  19.594  1.00 19.74           O  
ATOM   2154  OD2 ASP   268      59.709  28.523  19.289  1.00 18.59           O  
ATOM   2155  N   ASN   269      55.254  30.378  22.352  1.00 18.15           N  
ATOM   2156  CA  ASN   269      54.833  30.636  23.700  1.00 18.28           C  
ATOM   2157  C   ASN   269      53.520  31.390  23.936  1.00 23.96           C  
ATOM   2158  O   ASN   269      53.023  31.432  25.023  1.00 26.27           O  
ATOM   2159  CB  ASN   269      55.964  31.175  24.533  1.00 18.15           C  
ATOM   2160  CG  ASN   269      56.558  32.401  23.953  1.00 26.19           C  
ATOM   2161  OD1 ASN   269      57.699  32.422  23.568  1.00 32.60           O  
ATOM   2162  ND2 ASN   269      55.787  33.418  23.887  1.00 26.72           N  
ATOM   2163  N   GLU   270      52.941  31.937  22.902  1.00 16.48           N  
ATOM   2164  CA  GLU   270      51.647  32.553  23.047  1.00 15.11           C  
ATOM   2165  C   GLU   270      50.492  31.549  23.084  1.00 14.42           C  
ATOM   2166  O   GLU   270      50.240  30.921  22.121  1.00 21.12           O  
ATOM   2167  CB  GLU   270      51.467  33.548  21.932  1.00 18.79           C  
ATOM   2168  CG  GLU   270      50.290  34.433  22.053  1.00 18.97           C  
ATOM   2169  CD  GLU   270      50.347  35.361  23.231  1.00 22.84           C  
ATOM   2170  OE1 GLU   270      51.369  35.956  23.455  1.00 20.01           O  
ATOM   2171  OE2 GLU   270      49.349  35.477  23.920  1.00 26.54           O  
ATOM   2172  N   PRO   271      49.784  31.472  24.201  1.00 18.53           N  
ATOM   2173  CA  PRO   271      48.640  30.527  24.313  1.00 18.62           C  
ATOM   2174  C   PRO   271      47.585  30.711  23.209  1.00 21.48           C  
ATOM   2175  O   PRO   271      47.318  31.827  22.772  1.00 20.64           O  
ATOM   2176  CB  PRO   271      48.042  30.857  25.699  1.00 18.34           C  
ATOM   2177  CG  PRO   271      49.205  31.407  26.481  1.00 22.82           C  
ATOM   2178  CD  PRO   271      49.976  32.218  25.463  1.00 19.03           C  
ATOM   2179  N   ASP   272      47.040  29.602  22.722  1.00 19.39           N  
ATOM   2180  CA  ASP   272      45.946  29.606  21.734  1.00 21.41           C  
ATOM   2181  C   ASP   272      46.249  30.312  20.390  1.00 22.39           C  
ATOM   2182  O   ASP   272      45.353  30.844  19.739  1.00 21.93           O  
ATOM   2183  CB  ASP   272      44.665  30.132  22.399  1.00 25.85           C  
ATOM   2184  CG  ASP   272      44.337  29.387  23.701  1.00 22.95           C  
ATOM   2185  OD1 ASP   272      44.123  28.160  23.659  1.00 30.25           O  
ATOM   2186  OD2 ASP   272      44.290  30.024  24.762  1.00 25.66           O  
ATOM   2187  N   TYR   273      47.521  30.310  19.994  1.00 22.77           N  
ATOM   2188  CA  TYR   273      47.976  31.029  18.803  1.00 24.21           C  
ATOM   2189  C   TYR   273      47.124  30.663  17.581  1.00 25.07           C  
ATOM   2190  O   TYR   273      46.575  31.546  16.921  1.00 19.63           O  
ATOM   2191  CB  TYR   273      49.470  30.728  18.556  1.00 24.65           C  
ATOM   2192  CG  TYR   273      50.160  31.551  17.468  1.00 22.16           C  
ATOM   2193  CD1 TYR   273      50.778  32.746  17.787  1.00 22.26           C  
ATOM   2194  CD2 TYR   273      50.222  31.115  16.129  1.00 26.27           C  
ATOM   2195  CE1 TYR   273      51.455  33.514  16.826  1.00 25.71           C  
ATOM   2196  CE2 TYR   273      50.906  31.883  15.148  1.00 23.07           C  
ATOM   2197  CZ  TYR   273      51.516  33.091  15.519  1.00 26.26           C  
ATOM   2198  OH  TYR   273      52.227  33.891  14.619  1.00 25.63           O  
ATOM   2199  N   GLN   274      46.965  29.362  17.313  1.00 25.05           N  
ATOM   2200  CA  GLN   274      46.233  28.905  16.136  1.00 28.03           C  
ATOM   2201  C   GLN   274      44.756  29.291  16.186  1.00 21.12           C  
ATOM   2202  O   GLN   274      44.185  29.668  15.168  1.00 25.17           O  
ATOM   2203  CB  GLN   274      46.352  27.379  15.960  1.00 29.75           C  
ATOM   2204  CG  GLN   274      47.542  26.871  15.197  1.00 35.04           C  
ATOM   2205  CD  GLN   274      47.510  25.334  15.104  1.00 37.83           C  
ATOM   2206  OE1 GLN   274      47.600  24.655  16.103  1.00 54.17           O  
ATOM   2207  NE2 GLN   274      47.333  24.809  13.918  1.00 29.49           N  
ATOM   2208  N   GLU   275      44.133  29.184  17.363  1.00 21.24           N  
ATOM   2209  CA  GLU   275      42.711  29.558  17.518  1.00 23.65           C  
ATOM   2210  C   GLU   275      42.464  31.077  17.339  1.00 23.33           C  
ATOM   2211  O   GLU   275      41.438  31.485  16.766  1.00 23.64           O  
ATOM   2212  CB  GLU   275      42.172  29.094  18.877  1.00 25.97           C  
ATOM   2213  CG  GLU   275      40.632  29.029  18.967  1.00 32.41           C  
ATOM   2214  CD  GLU   275      40.122  28.518  20.321  1.00 39.35           C  
ATOM   2215  OE1 GLU   275      40.922  27.962  21.105  1.00 44.52           O  
ATOM   2216  OE2 GLU   275      38.908  28.672  20.601  1.00 41.90           O  
ATOM   2217  N   ILE   276      43.388  31.896  17.846  1.00 20.81           N  
ATOM   2218  CA  ILE   276      43.385  33.356  17.610  1.00 17.98           C  
ATOM   2219  C   ILE   276      43.453  33.689  16.106  1.00 17.71           C  
ATOM   2220  O   ILE   276      42.631  34.450  15.591  1.00 21.55           O  
ATOM   2221  CB  ILE   276      44.528  34.081  18.401  1.00 15.86           C  
ATOM   2222  CG1 ILE   276      44.247  34.008  19.908  1.00 19.73           C  
ATOM   2223  CG2 ILE   276      44.706  35.542  17.912  1.00 19.05           C  
ATOM   2224  CD1 ILE   276      45.475  34.302  20.768  1.00 19.29           C  
ATOM   2225  N   LEU   277      44.398  33.072  15.395  1.00 19.08           N  
ATOM   2226  CA  LEU   277      44.530  33.265  13.963  1.00 21.48           C  
ATOM   2227  C   LEU   277      43.274  32.840  13.211  1.00 24.88           C  
ATOM   2228  O   LEU   277      42.825  33.536  12.298  1.00 24.76           O  
ATOM   2229  CB  LEU   277      45.735  32.471  13.422  1.00 21.86           C  
ATOM   2230  CG  LEU   277      47.076  33.195  13.374  1.00 24.75           C  
ATOM   2231  CD1 LEU   277      47.600  33.586  14.733  1.00 34.47           C  
ATOM   2232  CD2 LEU   277      48.096  32.295  12.688  1.00 25.76           C  
ATOM   2233  N   ALA   278      42.715  31.692  13.593  1.00 27.02           N  
ATOM   2234  CA  ALA   278      41.506  31.175  12.965  1.00 25.77           C  
ATOM   2235  C   ALA   278      40.359  32.164  13.105  1.00 27.86           C  
ATOM   2236  O   ALA   278      39.644  32.463  12.139  1.00 27.51           O  
ATOM   2237  CB  ALA   278      41.141  29.816  13.572  1.00 26.62           C  
ATOM   2238  N   GLY   279      40.206  32.713  14.303  1.00 24.75           N  
ATOM   2239  CA  GLY   279      39.119  33.606  14.566  1.00 24.32           C  
ATOM   2240  C   GLY   279      39.255  34.969  13.922  1.00 21.62           C  
ATOM   2241  O   GLY   279      38.252  35.644  13.752  1.00 25.06           O  
ATOM   2242  N   LEU   280      40.471  35.367  13.529  1.00 21.70           N  
ATOM   2243  CA  LEU   280      40.689  36.640  12.818  1.00 16.91           C  
ATOM   2244  C   LEU   280      40.233  36.546  11.361  1.00 19.92           C  
ATOM   2245  O   LEU   280      40.131  37.569  10.678  1.00 23.50           O  
ATOM   2246  CB  LEU   280      42.167  37.093  12.848  1.00 19.48           C  
ATOM   2247  CG  LEU   280      42.750  37.463  14.221  1.00 19.47           C  
ATOM   2248  CD1 LEU   280      44.277  37.667  14.111  1.00 17.83           C  
ATOM   2249  CD2 LEU   280      42.045  38.638  14.883  1.00 22.63           C  
ATOM   2250  N   ARG   281      39.992  35.328  10.881  1.00 23.44           N  
ATOM   2251  CA  ARG   281      39.354  35.114   9.570  1.00 32.81           C  
ATOM   2252  C   ARG   281      37.935  34.561   9.712  1.00 32.09           C  
ATOM   2253  O   ARG   281      37.445  33.916   8.796  1.00 48.29           O  
ATOM   2254  CB  ARG   281      40.191  34.158   8.682  1.00 34.72           C  
ATOM   2255  CG  ARG   281      41.637  34.586   8.452  1.00 51.44           C  
ATOM   2256  CD  ARG   281      41.875  35.612   7.315  1.00 47.49           C  
ATOM   2257  NE  ARG   281      43.253  36.139   7.365  1.00 47.28           N  
ATOM   2258  CZ  ARG   281      44.352  35.493   6.941  1.00 62.28           C  
ATOM   2259  NH1 ARG   281      44.285  34.275   6.399  1.00 47.33           N  
ATOM   2260  NH2 ARG   281      45.544  36.071   7.053  1.00 64.73           N  
ATOM   2261  N   GLY   282      37.261  34.858  10.830  1.00 38.52           N  
ATOM   2262  CA  GLY   282      35.979  34.235  11.204  1.00 42.89           C  
ATOM   2263  C   GLY   282      34.742  34.549  10.371  1.00 58.44           C  
ATOM   2264  O   GLY   282      34.487  35.704  10.042  1.00 62.23           O  
ATOM   2265  N   ARG   283      33.963  33.519  10.030  1.00 64.93           N  
ATOM   2266  CA  ARG   283      32.705  33.700   9.274  1.00 72.21           C  
ATOM   2267  C   ARG   283      31.534  32.990   9.967  1.00 69.93           C  
ATOM   2268  O   ARG   283      30.361  33.286   9.718  1.00 69.14           O  
ATOM   2269  CB  ARG   283      32.831  33.197   7.821  1.00 73.70           C  
ATOM   2270  CG  ARG   283      34.107  33.605   7.074  1.00 81.93           C  
ATOM   2271  CD  ARG   283      33.954  33.492   5.560  1.00 83.14           C  
ATOM   2272  NE  ARG   283      33.593  34.769   4.934  1.00 96.15           N  
ATOM   2273  CZ  ARG   283      34.447  35.572   4.294  1.00100.15           C  
ATOM   2274  NH1 ARG   283      34.015  36.705   3.758  1.00 98.98           N  
ATOM   2275  NH2 ARG   283      35.731  35.249   4.181  1.00102.87           N  
END
