
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  147 ( 1201),  selected  147 , name 2o1c_A
# Molecule2: number of CA atoms  283 ( 2202),  selected  283 , name T0513.pdb
# PARAMETERS: 2o1c_A.T0513.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     2_A      M       1           -
LGA    -       -      S       2           -
LGA    -       -      F       3           -
LGA    -       -      L       4           -
LGA    -       -      K       5           -
LGA    -       -      H       6           -
LGA    -       -      V       7           -
LGA    -       -      Q       8           -
LGA    -       -      D       9           -
LGA    -       -      C      10           -
LGA    -       -      N      11           -
LGA    -       -      T      12           -
LGA    -       -      H      13           -
LGA    -       -      D      14           -
LGA    -       -      L      15           -
LGA    -       -      S      16           -
LGA    -       -      N      17           -
LGA    -       -      F      18           -
LGA    -       -      V      19           -
LGA    -       -      R      20           -
LGA    -       -      F      21           -
LGA    -       -      V      22           -
LGA    -       -      I      23           -
LGA    -       -      E      24           -
LGA    -       -      G      25           -
LGA    -       -      R      26           -
LGA    -       -      R      27           -
LGA    -       -      V      28           -
LGA    -       -      G      29           -
LGA    -       -      W      30           -
LGA    -       -      V      31           -
LGA    -       -      R      32           -
LGA    -       -      K      33           -
LGA    -       -      A      34           -
LGA    -       -      L      35           -
LGA    -       -      A      36           -
LGA    -       -      Q      37           -
LGA    -       -      R      38           -
LGA    -       -      L      39           -
LGA    -       -      K      40           -
LGA    -       -      A      41           -
LGA    -       -      H      42           -
LGA    -       -      G      43           -
LGA    -       -      R      44           -
LGA    -       -      V      45           -
LGA    -       -      F      46           -
LGA    -       -      D      47           -
LGA    -       -      V      48           -
LGA    -       -      T      49           -
LGA    -       -      R      50           -
LGA    -       -      D      51           -
LGA    -       -      A      52           -
LGA    -       -      V      53           -
LGA    -       -      L      54           -
LGA    -       -      L      55           -
LGA    -       -      S      56           -
LGA    -       -      A      57           -
LGA    -       -      S      58           -
LGA    -       -      L      59           -
LGA    -       -      R      60           -
LGA    -       -      T      61           -
LGA    -       -      P      62           -
LGA    -       -      Q      63           -
LGA    -       -      S      64           -
LGA    -       -      R      65           -
LGA    -       -      T      66           -
LGA    -       -      R      67           -
LGA    -       -      A      68           -
LGA    -       -      V      69           -
LGA    -       -      A      70           -
LGA    -       -      D      71           -
LGA    -       -      V      72           -
LGA    -       -      V      73           -
LGA    -       -      D      74           -
LGA    -       -      R      75           -
LGA    -       -      L      76           -
LGA    -       -      A      77           -
LGA    -       -      D      78           -
LGA    -       -      E      79           -
LGA    -       -      G      80           -
LGA    -       -      V      81           -
LGA    -       -      V      82           -
LGA    -       -      P      83           -
LGA    -       -      A      84           -
LGA    D     3_A      P      85          5.156
LGA    K     4_A      R      86          2.151
LGA    V     5_A      G      87          3.014
LGA    -       -      E      88           -
LGA    -       -      L      89           -
LGA    -       -      Y      90           -
LGA    -       -      R      91           -
LGA    -       -      V      92           -
LGA    -       -      N      93           -
LGA    -       -      Q      94           -
LGA    -       -      S      95           -
LGA    -       -      W      96           -
LGA    -       -      G      97           -
LGA    -       -      E      98           -
LGA    -       -      P      99           -
LGA    -       -      T     100           -
LGA    -       -      L     101           -
LGA    -       -      M     102           -
LGA    -       -      L     103           -
LGA    -       -      L     104           -
LGA    -       -      D     105           -
LGA    Y     6_A      R     106          2.018
LGA    -       -      A     107           -
LGA    K     7_A      V     108           #
LGA    -       -      V     109           -
LGA    -       -      P     110           -
LGA    -       -      T     111           -
LGA    -       -      F     112           -
LGA    -       -      G     113           -
LGA    -       -      V     114           -
LGA    R     8_A      R     115           #
LGA    P     9_A      A     116          1.449
LGA    V    10_A      Y     117          0.914
LGA    S    11_A      G     118          0.789
LGA    I    12_A      V     119          0.998
LGA    L    13_A      H     120          0.872
LGA    V    14_A      L     121          0.716
LGA    V    15_A      N     122          0.750
LGA    I    16_A      G     123          0.844
LGA    Y    17_A      Y     124          0.932
LGA    A    18_A      V     125          1.418
LGA    Q    19_A      G     126          3.303
LGA    D    20_A      A     127           #
LGA    -       -      G     128           -
LGA    -       -      A     129           -
LGA    T    21_A      D     130          4.463
LGA    K    22_A      L     131          1.998
LGA    R    23_A      H     132          0.903
LGA    V    24_A      L     133          0.553
LGA    L    25_A      W     134          0.828
LGA    M    26_A      I     135          0.702
LGA    L    27_A      G     136          0.844
LGA    Q    28_A      R     137          1.229
LGA    R    29_A      R     138          1.627
LGA    R    30_A      S     139          2.497
LGA    -       -      P     140           -
LGA    -       -      D     141           -
LGA    D    31_A      K     142          2.480
LGA    -       -      S     143           -
LGA    -       -      V     144           -
LGA    D    32_A      A     145          2.146
LGA    P    33_A      P     146          3.565
LGA    D    34_A      G     147           #
LGA    F    35_A      K     148          2.142
LGA    W    36_A      L     149          0.563
LGA    Q    37_A      D     150          1.205
LGA    S    38_A      N     151          0.485
LGA    -       -      M     152           -
LGA    V    39_A      V     153          1.973
LGA    T    40_A      A     154          1.409
LGA    G    41_A      G     155          0.949
LGA    S    42_A      G     156          1.452
LGA    V    43_A      Q     157          1.535
LGA    E    44_A      P     158          1.005
LGA    E    45_A      A     159          1.216
LGA    G    46_A      D     160          2.062
LGA    E    47_A      L     161          1.307
LGA    T    48_A      S     162          1.332
LGA    A    49_A      L     163          1.314
LGA    P    50_A      R     164          1.777
LGA    Q    51_A      Q     165          1.685
LGA    A    52_A      N     166          1.508
LGA    A    53_A      L     167          1.470
LGA    M    54_A      I     168          1.630
LGA    R    55_A      K     169          1.421
LGA    E    56_A      E     170          1.121
LGA    V    57_A      C     171          1.295
LGA    K    58_A      A     172          1.323
LGA    E    59_A      E     173          1.254
LGA    E    60_A      E     174          0.653
LGA    V    61_A      A     175          0.309
LGA    T    62_A      D     176          0.895
LGA    I    63_A      L     177          0.246
LGA    D    64_A      P     178          1.295
LGA    V    65_A      E     179          3.350
LGA    V    66_A      A     180          2.299
LGA    A    67_A      -       -           -
LGA    E    68_A      -       -           -
LGA    Q    69_A      L     181          4.405
LGA    L    70_A      A     182          5.680
LGA    T    71_A      R     183          5.284
LGA    -       -      Q     184           -
LGA    L    72_A      A     185          0.949
LGA    I    73_A      I     186          0.831
LGA    D    74_A      P     187          0.780
LGA    C    75_A      V     188          0.452
LGA    Q    76_A      G     189          3.092
LGA    R    77_A      A     190          3.055
LGA    T    78_A      -       -           -
LGA    V    79_A      I     191          1.774
LGA    E    80_A      T     192          1.387
LGA    F    81_A      Y     193          2.038
LGA    E    82_A      C     194          3.830
LGA    I    83_A      M     195          5.478
LGA    -       -      E     196           -
LGA    F    84_A      S     197          5.459
LGA    S    85_A      P     198          4.150
LGA    H    86_A      -       -           -
LGA    L    87_A      -       -           -
LGA    R    88_A      A     199          5.577
LGA    H    89_A      -       -           -
LGA    R    90_A      -       -           -
LGA    Y    91_A      -       -           -
LGA    A    92_A      -       -           -
LGA    P    93_A      -       -           -
LGA    G    94_A      G     200          4.089
LGA    V    95_A      I     201          4.074
LGA    T    96_A      K     202          1.842
LGA    R    97_A      P     203          1.750
LGA    N    98_A      D     204          1.296
LGA    T    99_A      T     205          1.113
LGA    E   100_A      L     206          0.960
LGA    S   101_A      F     207          0.860
LGA    W   102_A      L     208          0.656
LGA    F   103_A      Y     209          0.600
LGA    C   104_A      D     210          0.947
LGA    L   105_A      L     211          1.168
LGA    A   106_A      A     212          1.252
LGA    L   107_A      L     213          0.502
LGA    P   108_A      P     214          1.666
LGA    H   109_A      E     215          1.083
LGA    E   110_A      D     216           #
LGA    R   111_A      F     217          3.459
LGA    Q   112_A      R     218          3.011
LGA    I   113_A      P     219          2.204
LGA    V   114_A      H     220          0.923
LGA    F   115_A      N     221          0.995
LGA    T   116_A      T     222          3.593
LGA    -       -      D     223           -
LGA    -       -      G     224           -
LGA    E   117_A      E     225          0.823
LGA    H   118_A      M     226          1.103
LGA    L   119_A      A     227          1.454
LGA    A   120_A      D     228          1.980
LGA    Y   121_A      F     229          1.476
LGA    K   122_A      M     230          1.026
LGA    W   123_A      L     231          0.643
LGA    L   124_A      W     232          0.618
LGA    D   125_A      P     233          0.799
LGA    A   126_A      A     234          0.881
LGA    P   127_A      A     235          1.854
LGA    A   128_A      K     236          1.360
LGA    A   129_A      V     237          1.486
LGA    A   130_A      V     238          2.649
LGA    A   131_A      E     239          3.212
LGA    L   132_A      A     240          3.007
LGA    -       -      V     241           -
LGA    -       -      R     242           -
LGA    -       -      T     243           -
LGA    -       -      T     244           -
LGA    -       -      E     245           -
LGA    -       -      A     246           -
LGA    T   133_A      F     247          2.707
LGA    -       -      K     248           -
LGA    K   134_A      F     249          4.024
LGA    S   135_A      N     250          3.105
LGA    -       -      V     251           -
LGA    W   136_A      N     252          2.920
LGA    S   137_A      L     253          1.747
LGA    N   138_A      T     254          1.808
LGA    R   139_A      V     255          1.527
LGA    Q   140_A      I     256          1.812
LGA    A   141_A      D     257          3.005
LGA    I   142_A      F     258          2.592
LGA    E   143_A      A     259          0.739
LGA    Q   144_A      I     260          3.095
LGA    F   145_A      R     261          4.136
LGA    V   146_A      -       -           -
LGA    I   147_A      -       -           -
LGA    N   148_A      H     262          1.535
LGA    -       -      G     263           -
LGA    -       -      L     264           -
LGA    -       -      I     265           -
LGA    -       -      D     266           -
LGA    -       -      P     267           -
LGA    -       -      D     268           -
LGA    -       -      N     269           -
LGA    -       -      E     270           -
LGA    -       -      P     271           -
LGA    -       -      D     272           -
LGA    -       -      Y     273           -
LGA    -       -      Q     274           -
LGA    -       -      E     275           -
LGA    -       -      I     276           -
LGA    -       -      L     277           -
LGA    -       -      A     278           -
LGA    -       -      G     279           -
LGA    -       -      L     280           -
LGA    -       -      R     281           -
LGA    -       -      G     282           -
LGA    -       -      R     283           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  147  283    5.0    129    2.28    14.73     32.980     5.424

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.967081 * X  +   0.233289 * Y  +   0.101634 * Z  +  50.284977
  Y_new =   0.043258 * X  +  -0.544304 * Y  +   0.837772 * Z  +   1.456051
  Z_new =   0.250763 * X  +  -0.805797 * Y  +  -0.536478 * Z  +  52.202038 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.158180    0.983413  [ DEG:  -123.6546     56.3454 ]
  Theta =  -0.253469   -2.888124  [ DEG:   -14.5227   -165.4773 ]
  Phi   =   0.044701   -3.096892  [ DEG:     2.5612   -177.4388 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2o1c_A                                        
REMARK     2: T0513.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2o1c_A.T0513.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  147  283   5.0  129   2.28   14.73  32.980
REMARK  ---------------------------------------------------------- 
MOLECULE 2o1c_A
HEADER    HYDROLASE                               28-NOV-06   2O1C              
TITLE     STRUCTURE OF THE E. COLI DIHYDRONEOPTERIN TRIPHOSPHATE                
TITLE    2 PYROPHOSPHOHYDROLASE                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DATP PYROPHOSPHOHYDROLASE;                                 
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 EC: 3.6.1.-;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 STRAIN: HB101;                                                       
SOURCE   4 GENE: NUDB, NTPA;                                                    
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: HMS174(DE3);                               
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET11B                                    
KEYWDS    NUDIX NTP HYDROLASE NTP PYROPHOSPHOHYDROLASE MUTT                     
KEYWDS   2 DIHYDRONEOPTERIN TRIPHOSPHATE PYROPHOSPHOHYDROLASE FOLATE            
KEYWDS   3 BIOSYNTHESIS                                                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.B.GABELLI,M.A.BIANCHET,L.M.AMZEL                                    
REVDAT   1   28-AUG-07 2O1C    0                                                
JRNL        AUTH   S.B.GABELLI,M.A.BIANCHET,W.L.XU,C.A.DUNN,Z.-D.NIU,           
JRNL        AUTH 2 L.M.AMZEL,M.J.BESSMAN                                        
JRNL        TITL   STRUCTURE AND FUNCTION OF THE E. COLI                        
JRNL        TITL 2 DIHYDRONEOPTERIN TRIPHOSPHATE PYROPHOSPHATASE: A             
JRNL        TITL 3 NUDIX ENZYME INVOLVED IN FOLATE BIOSYNTHESIS                 
JRNL        REF    STRUCTURE                     V.  15  1014 2007              
JRNL        REFN   ASTM STRUE6  UK ISSN 0969-2126                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2O1C A    1   150  UNP    P0AFC0   NUDB_ECOLI       1    150             
DBREF  2O1C B    1   150  UNP    P0AFC0   NUDB_ECOLI       1    150             
DBREF  2O1C C    1   150  UNP    P0AFC0   NUDB_ECOLI       1    150             
DBREF  2O1C D    1   150  UNP    P0AFC0   NUDB_ECOLI       1    150             
SEQRES   1 A  150  MET LYS ASP LYS VAL TYR LYS ARG PRO VAL SER ILE LEU          
SEQRES   2 A  150  VAL VAL ILE TYR ALA GLN ASP THR LYS ARG VAL LEU MET          
SEQRES   3 A  150  LEU GLN ARG ARG ASP ASP PRO ASP PHE TRP GLN SER VAL          
SEQRES   4 A  150  THR GLY SER VAL GLU GLU GLY GLU THR ALA PRO GLN ALA          
SEQRES   5 A  150  ALA MET ARG GLU VAL LYS GLU GLU VAL THR ILE ASP VAL          
SEQRES   6 A  150  VAL ALA GLU GLN LEU THR LEU ILE ASP CYS GLN ARG THR          
SEQRES   7 A  150  VAL GLU PHE GLU ILE PHE SER HIS LEU ARG HIS ARG TYR          
SEQRES   8 A  150  ALA PRO GLY VAL THR ARG ASN THR GLU SER TRP PHE CYS          
SEQRES   9 A  150  LEU ALA LEU PRO HIS GLU ARG GLN ILE VAL PHE THR GLU          
SEQRES  10 A  150  HIS LEU ALA TYR LYS TRP LEU ASP ALA PRO ALA ALA ALA          
SEQRES  11 A  150  ALA LEU THR LYS SER TRP SER ASN ARG GLN ALA ILE GLU          
SEQRES  12 A  150  GLN PHE VAL ILE ASN ALA ALA                                  
SEQRES   1 B  150  MET LYS ASP LYS VAL TYR LYS ARG PRO VAL SER ILE LEU          
SEQRES   2 B  150  VAL VAL ILE TYR ALA GLN ASP THR LYS ARG VAL LEU MET          
SEQRES   3 B  150  LEU GLN ARG ARG ASP ASP PRO ASP PHE TRP GLN SER VAL          
SEQRES   4 B  150  THR GLY SER VAL GLU GLU GLY GLU THR ALA PRO GLN ALA          
SEQRES   5 B  150  ALA MET ARG GLU VAL LYS GLU GLU VAL THR ILE ASP VAL          
SEQRES   6 B  150  VAL ALA GLU GLN LEU THR LEU ILE ASP CYS GLN ARG THR          
SEQRES   7 B  150  VAL GLU PHE GLU ILE PHE SER HIS LEU ARG HIS ARG TYR          
SEQRES   8 B  150  ALA PRO GLY VAL THR ARG ASN THR GLU SER TRP PHE CYS          
SEQRES   9 B  150  LEU ALA LEU PRO HIS GLU ARG GLN ILE VAL PHE THR GLU          
SEQRES  10 B  150  HIS LEU ALA TYR LYS TRP LEU ASP ALA PRO ALA ALA ALA          
SEQRES  11 B  150  ALA LEU THR LYS SER TRP SER ASN ARG GLN ALA ILE GLU          
SEQRES  12 B  150  GLN PHE VAL ILE ASN ALA ALA                                  
SEQRES   1 C  150  MET LYS ASP LYS VAL TYR LYS ARG PRO VAL SER ILE LEU          
SEQRES   2 C  150  VAL VAL ILE TYR ALA GLN ASP THR LYS ARG VAL LEU MET          
SEQRES   3 C  150  LEU GLN ARG ARG ASP ASP PRO ASP PHE TRP GLN SER VAL          
SEQRES   4 C  150  THR GLY SER VAL GLU GLU GLY GLU THR ALA PRO GLN ALA          
SEQRES   5 C  150  ALA MET ARG GLU VAL LYS GLU GLU VAL THR ILE ASP VAL          
SEQRES   6 C  150  VAL ALA GLU GLN LEU THR LEU ILE ASP CYS GLN ARG THR          
SEQRES   7 C  150  VAL GLU PHE GLU ILE PHE SER HIS LEU ARG HIS ARG TYR          
SEQRES   8 C  150  ALA PRO GLY VAL THR ARG ASN THR GLU SER TRP PHE CYS          
SEQRES   9 C  150  LEU ALA LEU PRO HIS GLU ARG GLN ILE VAL PHE THR GLU          
SEQRES  10 C  150  HIS LEU ALA TYR LYS TRP LEU ASP ALA PRO ALA ALA ALA          
SEQRES  11 C  150  ALA LEU THR LYS SER TRP SER ASN ARG GLN ALA ILE GLU          
SEQRES  12 C  150  GLN PHE VAL ILE ASN ALA ALA                                  
SEQRES   1 D  150  MET LYS ASP LYS VAL TYR LYS ARG PRO VAL SER ILE LEU          
SEQRES   2 D  150  VAL VAL ILE TYR ALA GLN ASP THR LYS ARG VAL LEU MET          
SEQRES   3 D  150  LEU GLN ARG ARG ASP ASP PRO ASP PHE TRP GLN SER VAL          
SEQRES   4 D  150  THR GLY SER VAL GLU GLU GLY GLU THR ALA PRO GLN ALA          
SEQRES   5 D  150  ALA MET ARG GLU VAL LYS GLU GLU VAL THR ILE ASP VAL          
SEQRES   6 D  150  VAL ALA GLU GLN LEU THR LEU ILE ASP CYS GLN ARG THR          
SEQRES   7 D  150  VAL GLU PHE GLU ILE PHE SER HIS LEU ARG HIS ARG TYR          
SEQRES   8 D  150  ALA PRO GLY VAL THR ARG ASN THR GLU SER TRP PHE CYS          
SEQRES   9 D  150  LEU ALA LEU PRO HIS GLU ARG GLN ILE VAL PHE THR GLU          
SEQRES  10 D  150  HIS LEU ALA TYR LYS TRP LEU ASP ALA PRO ALA ALA ALA          
SEQRES  11 D  150  ALA LEU THR LYS SER TRP SER ASN ARG GLN ALA ILE GLU          
SEQRES  12 D  150  GLN PHE VAL ILE ASN ALA ALA                                  
HET    SO4  A 164       5                                                       
HET    SO4  A 165       5                                                       
HET    SO4  B 164       5                                                       
HET    SO4  B 163       5                                                       
HET    PPV  A 163       9                                                       
HET    PPV  B 165       9                                                       
HET    PPV  C 163       9                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM     PPV PYROPHOSPHATE                                                    
FORMUL   5  SO4    4(O4 S 2-)                                                   
FORMUL   9  PPV    3(H4 O7 P2)                                                  
FORMUL  12  HOH   *611(H2 O)                                                    
CRYST1  124.104   42.579  106.467  90.00 115.69  90.00 C 1 2 1      16          
ATOM      1  N   LYS A   2      18.421  64.534   6.032  1.00 22.76           N  
ATOM      2  CA  LYS A   2      18.073  63.158   6.497  1.00 22.31           C  
ATOM      3  C   LYS A   2      18.995  62.713   7.627  1.00 22.19           C  
ATOM      4  O   LYS A   2      20.028  63.347   7.878  1.00 22.23           O  
ATOM      5  CB  LYS A   2      18.131  62.164   5.327  1.00 22.34           C  
ATOM      6  CG  LYS A   2      17.130  62.471   4.207  1.00 22.79           C  
ATOM      7  CD  LYS A   2      16.776  61.233   3.396  1.00 22.82           C  
ATOM      8  CE  LYS A   2      15.561  61.475   2.492  1.00 23.25           C  
ATOM      9  NZ  LYS A   2      15.887  62.297   1.306  1.00 24.40           N  
ATOM     10  N   ASP A   3      18.622  61.624   8.304  1.00 21.75           N  
ATOM     11  CA  ASP A   3      19.490  61.002   9.306  1.00 21.40           C  
ATOM     12  C   ASP A   3      20.781  60.567   8.636  1.00 20.95           C  
ATOM     13  O   ASP A   3      20.786  60.253   7.438  1.00 20.37           O  
ATOM     14  CB  ASP A   3      18.844  59.759   9.924  1.00 21.64           C  
ATOM     15  CG  ASP A   3      17.484  60.030  10.549  1.00 22.13           C  
ATOM     16  OD1 ASP A   3      17.165  61.196  10.866  1.00 23.14           O  
ATOM     17  OD2 ASP A   3      16.732  59.049  10.732  1.00 22.47           O  
ATOM     18  N   LYS A   4      21.868  60.533   9.411  1.00 20.37           N  
ATOM     19  CA  LYS A   4      23.130  60.006   8.912  1.00 20.35           C  
ATOM     20  C   LYS A   4      22.865  58.641   8.307  1.00 19.45           C  
ATOM     21  O   LYS A   4      22.201  57.795   8.914  1.00 19.17           O  
ATOM     22  CB  LYS A   4      24.183  59.895  10.021  1.00 20.32           C  
ATOM     23  CG  LYS A   4      24.949  61.186  10.298  1.00 21.46           C  
ATOM     24  CD  LYS A   4      25.936  61.035  11.463  1.00 21.81           C  
ATOM     25  CE  LYS A   4      27.292  60.479  11.016  1.00 25.39           C  
ATOM     26  NZ  LYS A   4      28.085  61.439  10.174  1.00 26.74           N  
ATOM     27  N   VAL A   5      23.362  58.444   7.094  1.00 19.06           N  
ATOM     28  CA  VAL A   5      23.188  57.175   6.405  1.00 18.39           C  
ATOM     29  C   VAL A   5      23.908  56.085   7.179  1.00 18.11           C  
ATOM     30  O   VAL A   5      24.822  56.369   7.958  1.00 18.08           O  
ATOM     31  CB  VAL A   5      23.673  57.252   4.938  1.00 18.47           C  
ATOM     32  CG1 VAL A   5      22.777  58.211   4.149  1.00 18.48           C  
ATOM     33  CG2 VAL A   5      25.140  57.683   4.863  1.00 18.47           C  
ATOM     34  N   TYR A   6      23.469  54.845   6.990  1.00 17.94           N  
ATOM     35  CA  TYR A   6      24.072  53.712   7.674  1.00 16.81           C  
ATOM     36  C   TYR A   6      25.540  53.575   7.297  1.00 16.61           C  
ATOM     37  O   TYR A   6      25.936  53.871   6.159  1.00 16.26           O  
ATOM     38  CB  TYR A   6      23.328  52.418   7.335  1.00 17.16           C  
ATOM     39  CG  TYR A   6      21.913  52.331   7.877  1.00 17.59           C  
ATOM     40  CD1 TYR A   6      21.655  52.461   9.243  1.00 17.42           C  
ATOM     41  CD2 TYR A   6      20.831  52.103   7.024  1.00 17.21           C  
ATOM     42  CE1 TYR A   6      20.359  52.371   9.744  1.00 18.78           C  
ATOM     43  CE2 TYR A   6      19.528  52.017   7.520  1.00 18.30           C  
ATOM     44  CZ  TYR A   6      19.306  52.148   8.881  1.00 18.39           C  
ATOM     45  OH  TYR A   6      18.026  52.056   9.382  1.00 19.75           O  
ATOM     46  N   LYS A   7      26.335  53.146   8.269  1.00 15.95           N  
ATOM     47  CA  LYS A   7      27.700  52.712   8.010  1.00 16.32           C  
ATOM     48  C   LYS A   7      27.630  51.443   7.178  1.00 16.14           C  
ATOM     49  O   LYS A   7      26.697  50.650   7.297  1.00 15.95           O  
ATOM     50  CB  LYS A   7      28.441  52.425   9.314  1.00 15.81           C  
ATOM     51  CG  LYS A   7      28.670  53.635  10.199  1.00 16.68           C  
ATOM     52  CD  LYS A   7      29.474  53.262  11.444  1.00 17.07           C  
ATOM     53  CE  LYS A   7      29.679  54.492  12.324  1.00 19.85           C  
ATOM     54  NZ  LYS A   7      30.584  54.207  13.463  1.00 25.84           N  
ATOM     55  N   ARG A   8      28.626  51.256   6.327  1.00 16.37           N  
ATOM     56  CA  ARG A   8      28.697  50.063   5.496  1.00 16.40           C  
ATOM     57  C   ARG A   8      29.526  49.014   6.234  1.00 14.93           C  
ATOM     58  O   ARG A   8      30.562  49.347   6.828  1.00 15.24           O  
ATOM     59  CB  ARG A   8      29.280  50.403   4.123  1.00 17.07           C  
ATOM     60  CG  ARG A   8      28.594  51.614   3.489  1.00 20.43           C  
ATOM     61  CD  ARG A   8      28.357  51.460   1.997  1.00 25.82           C  
ATOM     62  NE  ARG A   8      26.945  51.208   1.693  1.00 29.32           N  
ATOM     63  CZ  ARG A   8      26.483  50.132   1.064  1.00 30.39           C  
ATOM     64  NH1 ARG A   8      27.313  49.187   0.651  1.00 30.84           N  
ATOM     65  NH2 ARG A   8      25.184  50.003   0.838  1.00 32.37           N  
ATOM     66  N   PRO A   9      29.061  47.748   6.232  1.00 13.76           N  
ATOM     67  CA  PRO A   9      29.771  46.649   6.891  1.00 12.78           C  
ATOM     68  C   PRO A   9      30.966  46.089   6.086  1.00 12.03           C  
ATOM     69  O   PRO A   9      31.310  44.912   6.207  1.00 11.91           O  
ATOM     70  CB  PRO A   9      28.681  45.594   7.066  1.00 12.76           C  
ATOM     71  CG  PRO A   9      27.798  45.798   5.882  1.00 13.28           C  
ATOM     72  CD  PRO A   9      27.806  47.283   5.604  1.00 13.43           C  
ATOM     73  N   VAL A  10      31.558  46.946   5.266  1.00 11.94           N  
ATOM     74  CA  VAL A  10      32.814  46.688   4.583  1.00 12.64           C  
ATOM     75  C   VAL A  10      33.683  47.888   4.952  1.00 12.07           C  
ATOM     76  O   VAL A  10      33.307  49.025   4.682  1.00 13.00           O  
ATOM     77  CB  VAL A  10      32.611  46.617   3.058  1.00 12.86           C  
ATOM     78  CG1 VAL A  10      33.955  46.555   2.340  1.00 13.91           C  
ATOM     79  CG2 VAL A  10      31.742  45.419   2.676  1.00 12.64           C  
ATOM     80  N   SER A  11      34.828  47.636   5.579  1.00 11.96           N  
ATOM     81  CA  SER A  11      35.596  48.710   6.221  1.00 11.99           C  
ATOM     82  C   SER A  11      37.089  48.557   5.991  1.00 11.08           C  
ATOM     83  O   SER A  11      37.528  47.535   5.458  1.00 11.13           O  
ATOM     84  CB  SER A  11      35.293  48.701   7.725  1.00 12.21           C  
ATOM     85  OG  SER A  11      35.806  47.526   8.328  1.00 15.33           O  
ATOM     86  N   ILE A  12      37.851  49.579   6.395  1.00 10.71           N  
ATOM     87  CA  ILE A  12      39.314  49.539   6.411  1.00 10.99           C  
ATOM     88  C   ILE A  12      39.830  49.866   7.820  1.00 10.81           C  
ATOM     89  O   ILE A  12      39.105  50.438   8.656  1.00  9.55           O  
ATOM     90  CB  ILE A  12      39.958  50.468   5.319  1.00 10.83           C  
ATOM     91  CG1 ILE A  12      39.463  51.913   5.419  1.00 11.68           C  
ATOM     92  CG2 ILE A  12      39.640  49.950   3.906  1.00 10.44           C  
ATOM     93  CD1 ILE A  12      40.099  52.770   6.470  1.00 13.77           C  
ATOM     94  N   LEU A  13      41.062  49.444   8.070  1.00 11.14           N  
ATOM     95  CA  LEU A  13      41.807  49.744   9.274  1.00 11.85           C  
ATOM     96  C   LEU A  13      43.183  50.221   8.814  1.00 11.89           C  
ATOM     97  O   LEU A  13      43.839  49.566   7.996  1.00 11.73           O  
ATOM     98  CB  LEU A  13      41.956  48.482  10.136  1.00 12.29           C  
ATOM     99  CG  LEU A  13      42.960  48.548  11.301  1.00 13.13           C  
ATOM    100  CD1 LEU A  13      42.367  49.328  12.444  1.00 12.10           C  
ATOM    101  CD2 LEU A  13      43.381  47.146  11.738  1.00 13.64           C  
ATOM    102  N   VAL A  14      43.604  51.376   9.308  1.00 12.26           N  
ATOM    103  CA  VAL A  14      44.968  51.831   9.017  1.00 11.74           C  
ATOM    104  C   VAL A  14      45.724  51.971  10.331  1.00 11.93           C  
ATOM    105  O   VAL A  14      45.448  52.882  11.121  1.00 11.69           O  
ATOM    106  CB  VAL A  14      44.992  53.155   8.242  1.00 11.80           C  
ATOM    107  CG1 VAL A  14      46.441  53.497   7.839  1.00 12.86           C  
ATOM    108  CG2 VAL A  14      44.076  53.091   7.006  1.00 11.44           C  
ATOM    109  N   VAL A  15      46.688  51.072  10.544  1.00 11.89           N  
ATOM    110  CA  VAL A  15      47.559  51.142  11.707  1.00 12.60           C  
ATOM    111  C   VAL A  15      48.658  52.158  11.428  1.00 12.59           C  
ATOM    112  O   VAL A  15      49.592  51.899  10.673  1.00 12.76           O  
ATOM    113  CB  VAL A  15      48.173  49.773  12.082  1.00 12.83           C  
ATOM    114  CG1 VAL A  15      49.124  49.924  13.271  1.00 13.33           C  
ATOM    115  CG2 VAL A  15      47.079  48.769  12.414  1.00 13.43           C  
ATOM    116  N   ILE A  16      48.513  53.321  12.049  1.00 12.65           N  
ATOM    117  CA  ILE A  16      49.510  54.386  11.968  1.00 12.54           C  
ATOM    118  C   ILE A  16      50.518  54.233  13.090  1.00 12.57           C  
ATOM    119  O   ILE A  16      50.148  54.128  14.270  1.00 12.58           O  
ATOM    120  CB  ILE A  16      48.846  55.781  12.038  1.00 12.50           C  
ATOM    121  CG1 ILE A  16      47.845  55.940  10.888  1.00 13.07           C  
ATOM    122  CG2 ILE A  16      49.916  56.908  12.038  1.00 12.78           C  
ATOM    123  CD1 ILE A  16      46.945  57.171  10.993  1.00 12.42           C  
ATOM    124  N   TYR A  17      51.791  54.211  12.713  1.00 12.92           N  
ATOM    125  CA  TYR A  17      52.869  54.206  13.702  1.00 13.23           C  
ATOM    126  C   TYR A  17      54.052  55.080  13.272  1.00 13.60           C  
ATOM    127  O   TYR A  17      54.105  55.557  12.133  1.00 13.41           O  
ATOM    128  CB  TYR A  17      53.297  52.766  14.001  1.00 13.74           C  
ATOM    129  CG  TYR A  17      54.000  52.069  12.860  1.00 14.01           C  
ATOM    130  CD1 TYR A  17      53.278  51.435  11.850  1.00 15.36           C  
ATOM    131  CD2 TYR A  17      55.395  52.042  12.791  1.00 15.77           C  
ATOM    132  CE1 TYR A  17      53.926  50.786  10.799  1.00 15.84           C  
ATOM    133  CE2 TYR A  17      56.046  51.403  11.753  1.00 16.34           C  
ATOM    134  CZ  TYR A  17      55.312  50.780  10.759  1.00 16.09           C  
ATOM    135  OH  TYR A  17      55.981  50.152   9.728  1.00 15.71           O  
ATOM    136  N   ALA A  18      54.979  55.309  14.203  1.00 13.32           N  
ATOM    137  CA  ALA A  18      56.198  56.049  13.923  1.00 13.50           C  
ATOM    138  C   ALA A  18      57.363  55.088  13.687  1.00 13.61           C  
ATOM    139  O   ALA A  18      57.673  54.240  14.536  1.00 13.19           O  
ATOM    140  CB  ALA A  18      56.505  56.996  15.062  1.00 12.79           C  
ATOM    141  N   GLN A  19      57.991  55.211  12.527  1.00 14.07           N  
ATOM    142  CA  GLN A  19      59.134  54.360  12.182  1.00 15.24           C  
ATOM    143  C   GLN A  19      60.295  54.495  13.175  1.00 15.35           C  
ATOM    144  O   GLN A  19      60.997  53.510  13.470  1.00 16.01           O  
ATOM    145  CB  GLN A  19      59.618  54.652  10.758  1.00 15.74           C  
ATOM    146  CG  GLN A  19      60.919  53.930  10.350  1.00 17.37           C  
ATOM    147  CD  GLN A  19      60.821  52.402  10.396  1.00 19.47           C  
ATOM    148  OE1 GLN A  19      61.836  51.710  10.536  1.00 21.07           O  
ATOM    149  NE2 GLN A  19      59.610  51.875  10.262  1.00 19.18           N  
ATOM    150  N   ASP A  20      60.502  55.704  13.682  1.00 14.89           N  
ATOM    151  CA  ASP A  20      61.658  55.949  14.557  1.00 14.19           C  
ATOM    152  C   ASP A  20      61.485  55.349  15.961  1.00 13.63           C  
ATOM    153  O   ASP A  20      62.347  54.592  16.409  1.00 12.75           O  
ATOM    154  CB  ASP A  20      62.079  57.425  14.566  1.00 14.61           C  
ATOM    155  CG  ASP A  20      61.052  58.353  15.184  1.00 15.22           C  
ATOM    156  OD1 ASP A  20      59.890  57.945  15.402  1.00 14.89           O  
ATOM    157  OD2 ASP A  20      61.428  59.523  15.442  1.00 16.05           O  
ATOM    158  N   THR A  21      60.346  55.623  16.603  1.00 12.57           N  
ATOM    159  CA  THR A  21      60.073  55.137  17.968  1.00 12.48           C  
ATOM    160  C   THR A  21      59.343  53.796  18.029  1.00 12.75           C  
ATOM    161  O   THR A  21      59.339  53.138  19.079  1.00 12.65           O  
ATOM    162  CB  THR A  21      59.235  56.147  18.802  1.00 12.38           C  
ATOM    163  OG1 THR A  21      57.907  56.247  18.264  1.00 11.53           O  
ATOM    164  CG2 THR A  21      59.900  57.532  18.852  1.00 11.80           C  
ATOM    165  N   LYS A  22      58.717  53.411  16.916  1.00 12.55           N  
ATOM    166  CA  LYS A  22      57.791  52.267  16.839  1.00 12.99           C  
ATOM    167  C   LYS A  22      56.554  52.401  17.745  1.00 13.33           C  
ATOM    168  O   LYS A  22      55.912  51.407  18.077  1.00 13.39           O  
ATOM    169  CB  LYS A  22      58.487  50.916  17.073  1.00 13.36           C  
ATOM    170  CG  LYS A  22      59.732  50.658  16.218  1.00 13.16           C  
ATOM    171  CD  LYS A  22      59.424  50.585  14.722  1.00 14.16           C  
ATOM    172  CE  LYS A  22      60.674  50.203  13.921  1.00 14.78           C  
ATOM    173  NZ  LYS A  22      61.858  50.995  14.347  1.00 16.20           N  
ATOM    174  N   ARG A  23      56.224  53.626  18.139  1.00 13.15           N  
ATOM    175  CA  ARG A  23      54.996  53.830  18.894  1.00 12.61           C  
ATOM    176  C   ARG A  23      53.833  53.914  17.913  1.00 12.35           C  
ATOM    177  O   ARG A  23      54.008  54.325  16.760  1.00 11.69           O  
ATOM    178  CB  ARG A  23      55.067  55.061  19.805  1.00 13.40           C  
ATOM    179  CG  ARG A  23      56.020  54.922  21.022  1.00 11.92           C  
ATOM    180  CD  ARG A  23      55.696  55.961  22.090  1.00 13.10           C  
ATOM    181  NE  ARG A  23      56.663  56.037  23.182  1.00 14.48           N  
ATOM    182  CZ  ARG A  23      57.830  56.678  23.115  1.00 15.30           C  
ATOM    183  NH1 ARG A  23      58.202  57.293  21.994  1.00 15.34           N  
ATOM    184  NH2 ARG A  23      58.641  56.695  24.169  1.00 15.44           N  
ATOM    185  N   VAL A  24      52.667  53.507  18.401  1.00 11.70           N  
ATOM    186  CA  VAL A  24      51.422  53.399  17.632  1.00 11.37           C  
ATOM    187  C   VAL A  24      50.482  54.525  18.047  1.00 11.51           C  
ATOM    188  O   VAL A  24      50.331  54.831  19.242  1.00 10.65           O  
ATOM    189  CB  VAL A  24      50.755  52.031  17.867  1.00 11.07           C  
ATOM    190  CG1 VAL A  24      49.420  51.905  17.098  1.00 10.61           C  
ATOM    191  CG2 VAL A  24      51.724  50.886  17.477  1.00 10.59           C  
ATOM    192  N   LEU A  25      49.872  55.142  17.037  1.00 12.03           N  
ATOM    193  CA  LEU A  25      48.930  56.232  17.223  1.00 12.69           C  
ATOM    194  C   LEU A  25      47.560  55.676  17.625  1.00 12.72           C  
ATOM    195  O   LEU A  25      46.897  55.054  16.821  1.00 12.55           O  
ATOM    196  CB  LEU A  25      48.786  57.023  15.915  1.00 12.53           C  
ATOM    197  CG  LEU A  25      48.487  58.537  15.924  1.00 15.04           C  
ATOM    198  CD1 LEU A  25      47.631  58.939  14.724  1.00 11.14           C  
ATOM    199  CD2 LEU A  25      47.915  59.109  17.216  1.00 14.23           C  
ATOM    200  N   MET A  26      47.154  55.912  18.869  1.00 13.34           N  
ATOM    201  CA  MET A  26      45.860  55.423  19.352  1.00 13.33           C  
ATOM    202  C   MET A  26      44.893  56.584  19.587  1.00 13.71           C  
ATOM    203  O   MET A  26      45.273  57.635  20.110  1.00 13.98           O  
ATOM    204  CB  MET A  26      46.042  54.541  20.591  1.00 13.88           C  
ATOM    205  CG  MET A  26      46.892  53.279  20.301  1.00 14.66           C  
ATOM    206  SD  MET A  26      46.199  52.240  18.990  1.00 18.13           S  
ATOM    207  CE  MET A  26      44.879  51.443  19.913  1.00 17.23           C  
ATOM    208  N   LEU A  27      43.650  56.390  19.152  1.00 13.61           N  
ATOM    209  CA  LEU A  27      42.661  57.454  19.093  1.00 13.34           C  
ATOM    210  C   LEU A  27      41.409  57.039  19.857  1.00 12.87           C  
ATOM    211  O   LEU A  27      40.879  55.933  19.649  1.00 13.20           O  
ATOM    212  CB  LEU A  27      42.295  57.744  17.628  1.00 14.12           C  
ATOM    213  CG  LEU A  27      43.426  58.147  16.677  1.00 13.25           C  
ATOM    214  CD1 LEU A  27      43.083  57.800  15.241  1.00 14.50           C  
ATOM    215  CD2 LEU A  27      43.730  59.632  16.812  1.00 14.30           C  
ATOM    216  N   GLN A  28      40.927  57.949  20.696  1.00 12.66           N  
ATOM    217  CA  GLN A  28      39.784  57.717  21.569  1.00 12.71           C  
ATOM    218  C   GLN A  28      38.462  58.029  20.859  1.00 12.42           C  
ATOM    219  O   GLN A  28      38.189  59.166  20.471  1.00 11.63           O  
ATOM    220  CB  GLN A  28      39.920  58.522  22.872  1.00 12.84           C  
ATOM    221  CG  GLN A  28      38.846  58.197  23.927  1.00 12.30           C  
ATOM    222  CD  GLN A  28      38.869  59.121  25.146  1.00 13.52           C  
ATOM    223  OE1 GLN A  28      39.366  60.244  25.098  1.00 13.55           O  
ATOM    224  NE2 GLN A  28      38.301  58.648  26.237  1.00 13.58           N  
ATOM    225  N   ARG A  29      37.638  57.001  20.688  1.00 12.31           N  
ATOM    226  CA  ARG A  29      36.351  57.167  19.997  1.00 12.41           C  
ATOM    227  C   ARG A  29      35.368  58.051  20.761  1.00 12.60           C  
ATOM    228  O   ARG A  29      35.414  58.134  21.981  1.00 12.88           O  
ATOM    229  CB  ARG A  29      35.715  55.804  19.674  1.00 11.85           C  
ATOM    230  CG  ARG A  29      36.480  55.008  18.634  1.00 12.30           C  
ATOM    231  CD  ARG A  29      35.788  53.701  18.259  1.00 13.67           C  
ATOM    232  NE  ARG A  29      34.497  53.896  17.589  1.00 14.72           N  
ATOM    233  CZ  ARG A  29      34.313  53.878  16.264  1.00 18.14           C  
ATOM    234  NH1 ARG A  29      35.333  53.701  15.428  1.00 18.90           N  
ATOM    235  NH2 ARG A  29      33.094  54.041  15.760  1.00 17.90           N  
ATOM    236  N   ARG A  30      34.485  58.709  20.015  1.00 13.36           N  
ATOM    237  CA  ARG A  30      33.505  59.623  20.597  1.00 14.24           C  
ATOM    238  C   ARG A  30      32.166  58.933  20.883  1.00 14.08           C  
ATOM    239  O   ARG A  30      31.377  59.463  21.648  1.00 14.90           O  
ATOM    240  CB  ARG A  30      33.304  60.845  19.705  1.00 14.68           C  
ATOM    241  CG  ARG A  30      32.503  60.572  18.444  1.00 15.95           C  
ATOM    242  CD  ARG A  30      32.238  61.846  17.660  1.00 20.87           C  
ATOM    243  NE  ARG A  30      31.835  61.529  16.294  1.00 24.15           N  
ATOM    244  CZ  ARG A  30      32.062  62.305  15.238  1.00 26.59           C  
ATOM    245  NH1 ARG A  30      32.690  63.467  15.377  1.00 27.23           N  
ATOM    246  NH2 ARG A  30      31.662  61.909  14.035  1.00 28.48           N  
ATOM    247  N   ASP A  31      31.937  57.766  20.268  1.00 14.19           N  
ATOM    248  CA  ASP A  31      30.740  56.954  20.522  1.00 14.21           C  
ATOM    249  C   ASP A  31      30.910  56.038  21.739  1.00 14.23           C  
ATOM    250  O   ASP A  31      30.013  55.934  22.576  1.00 13.81           O  
ATOM    251  CB  ASP A  31      30.263  56.190  19.270  1.00 14.17           C  
ATOM    252  CG  ASP A  31      31.341  55.320  18.619  1.00 15.08           C  
ATOM    253  OD1 ASP A  31      32.490  55.216  19.115  1.00 15.53           O  
ATOM    254  OD2 ASP A  31      31.027  54.730  17.565  1.00 14.79           O  
ATOM    255  N   ASP A  32      32.087  55.417  21.834  1.00 13.98           N  
ATOM    256  CA  ASP A  32      32.498  54.602  22.971  1.00 13.83           C  
ATOM    257  C   ASP A  32      33.857  55.135  23.460  1.00 13.70           C  
ATOM    258  O   ASP A  32      34.899  54.716  22.957  1.00 13.24           O  
ATOM    259  CB  ASP A  32      32.623  53.133  22.530  1.00 13.57           C  
ATOM    260  CG  ASP A  32      33.069  52.194  23.649  1.00 14.04           C  
ATOM    261  OD1 ASP A  32      33.479  52.660  24.733  1.00 15.07           O  
ATOM    262  OD2 ASP A  32      33.045  50.960  23.413  1.00 14.88           O  
ATOM    263  N   PRO A  33      33.847  56.079  24.426  1.00 13.87           N  
ATOM    264  CA  PRO A  33      35.093  56.669  24.951  1.00 14.23           C  
ATOM    265  C   PRO A  33      36.080  55.688  25.589  1.00 14.49           C  
ATOM    266  O   PRO A  33      37.232  56.060  25.848  1.00 14.94           O  
ATOM    267  CB  PRO A  33      34.586  57.679  25.996  1.00 13.67           C  
ATOM    268  CG  PRO A  33      33.180  57.989  25.567  1.00 14.97           C  
ATOM    269  CD  PRO A  33      32.657  56.700  25.039  1.00 14.27           C  
ATOM    270  N   ASP A  34      35.650  54.452  25.839  1.00 14.69           N  
ATOM    271  CA  ASP A  34      36.563  53.392  26.320  1.00 15.26           C  
ATOM    272  C   ASP A  34      37.329  52.681  25.190  1.00 15.24           C  
ATOM    273  O   ASP A  34      38.281  51.923  25.433  1.00 14.94           O  
ATOM    274  CB  ASP A  34      35.790  52.386  27.173  1.00 16.01           C  
ATOM    275  CG  ASP A  34      35.273  52.999  28.470  1.00 18.48           C  
ATOM    276  OD1 ASP A  34      36.004  53.788  29.110  1.00 21.86           O  
ATOM    277  OD2 ASP A  34      34.130  52.712  28.833  1.00 22.29           O  
ATOM    278  N   PHE A  35      36.932  52.974  23.960  1.00 14.12           N  
ATOM    279  CA  PHE A  35      37.410  52.267  22.786  1.00 13.96           C  
ATOM    280  C   PHE A  35      38.459  53.134  22.099  1.00 13.54           C  
ATOM    281  O   PHE A  35      38.113  54.128  21.442  1.00 12.76           O  
ATOM    282  CB  PHE A  35      36.204  52.038  21.875  1.00 13.12           C  
ATOM    283  CG  PHE A  35      36.451  51.129  20.697  1.00 13.47           C  
ATOM    284  CD1 PHE A  35      37.737  50.772  20.276  1.00 11.03           C  
ATOM    285  CD2 PHE A  35      35.353  50.642  19.980  1.00 12.96           C  
ATOM    286  CE1 PHE A  35      37.929  49.943  19.170  1.00 13.12           C  
ATOM    287  CE2 PHE A  35      35.536  49.810  18.866  1.00 13.80           C  
ATOM    288  CZ  PHE A  35      36.831  49.466  18.461  1.00 14.22           C  
ATOM    289  N   TRP A  36      39.732  52.789  22.316  1.00 13.55           N  
ATOM    290  CA  TRP A  36      40.858  53.424  21.639  1.00 13.58           C  
ATOM    291  C   TRP A  36      41.277  52.543  20.473  1.00 13.53           C  
ATOM    292  O   TRP A  36      41.264  51.329  20.585  1.00 13.58           O  
ATOM    293  CB  TRP A  36      42.044  53.600  22.589  1.00 14.10           C  
ATOM    294  CG  TRP A  36      41.780  54.567  23.718  1.00 14.49           C  
ATOM    295  CD1 TRP A  36      40.998  54.363  24.813  1.00 15.06           C  
ATOM    296  CD2 TRP A  36      42.338  55.879  23.859  1.00 16.15           C  
ATOM    297  NE1 TRP A  36      41.017  55.481  25.627  1.00 16.13           N  
ATOM    298  CE2 TRP A  36      41.827  56.427  25.056  1.00 15.82           C  
ATOM    299  CE3 TRP A  36      43.202  56.655  23.073  1.00 15.66           C  
ATOM    300  CZ2 TRP A  36      42.165  57.708  25.500  1.00 14.61           C  
ATOM    301  CZ3 TRP A  36      43.541  57.937  23.521  1.00 15.84           C  
ATOM    302  CH2 TRP A  36      43.015  58.447  24.715  1.00 14.75           C  
ATOM    303  N   GLN A  37      41.686  53.165  19.373  1.00 12.76           N  
ATOM    304  CA  GLN A  37      41.888  52.444  18.120  1.00 12.85           C  
ATOM    305  C   GLN A  37      42.805  53.197  17.168  1.00 12.61           C  
ATOM    306  O   GLN A  37      43.022  54.407  17.299  1.00 13.23           O  
ATOM    307  CB  GLN A  37      40.526  52.255  17.416  1.00 12.12           C  
ATOM    308  CG  GLN A  37      39.791  53.595  17.192  1.00 14.19           C  
ATOM    309  CD  GLN A  37      38.749  53.557  16.087  1.00 13.86           C  
ATOM    310  OE1 GLN A  37      38.194  54.596  15.711  1.00 15.58           O  
ATOM    311  NE2 GLN A  37      38.464  52.360  15.564  1.00 13.76           N  
ATOM    312  N   SER A  38      43.301  52.461  16.182  1.00 12.78           N  
ATOM    313  CA  SER A  38      43.859  53.033  14.964  1.00 13.00           C  
ATOM    314  C   SER A  38      42.710  53.607  14.119  1.00 13.36           C  
ATOM    315  O   SER A  38      41.548  53.608  14.533  1.00 13.53           O  
ATOM    316  CB  SER A  38      44.622  51.944  14.190  1.00 12.98           C  
ATOM    317  OG  SER A  38      45.622  51.311  15.000  1.00 13.89           O  
ATOM    318  N   VAL A  39      43.031  54.108  12.935  1.00 12.86           N  
ATOM    319  CA  VAL A  39      42.028  54.704  12.051  1.00 13.13           C  
ATOM    320  C   VAL A  39      41.151  53.616  11.414  1.00 12.74           C  
ATOM    321  O   VAL A  39      41.648  52.626  10.880  1.00 12.00           O  
ATOM    322  CB  VAL A  39      42.717  55.580  10.982  1.00 13.31           C  
ATOM    323  CG1 VAL A  39      41.787  55.919   9.808  1.00 13.97           C  
ATOM    324  CG2 VAL A  39      43.283  56.841  11.625  1.00 13.51           C  
ATOM    325  N   THR A  40      39.838  53.788  11.510  1.00 12.61           N  
ATOM    326  CA  THR A  40      38.908  52.891  10.819  1.00 12.94           C  
ATOM    327  C   THR A  40      37.838  53.668  10.051  1.00 12.78           C  
ATOM    328  O   THR A  40      37.566  54.840  10.339  1.00 12.93           O  
ATOM    329  CB  THR A  40      38.174  51.932  11.793  1.00 13.03           C  
ATOM    330  OG1 THR A  40      37.422  52.687  12.759  1.00 12.64           O  
ATOM    331  CG2 THR A  40      39.128  51.000  12.498  1.00 13.41           C  
ATOM    332  N   GLY A  41      37.214  53.005   9.082  1.00 12.74           N  
ATOM    333  CA  GLY A  41      36.038  53.588   8.439  1.00 12.82           C  
ATOM    334  C   GLY A  41      35.452  52.704   7.356  1.00 13.33           C  
ATOM    335  O   GLY A  41      36.074  51.735   6.938  1.00 12.78           O  
ATOM    336  N   SER A  42      34.252  53.058   6.910  1.00 13.57           N  
ATOM    337  CA  SER A  42      33.551  52.340   5.828  1.00 14.41           C  
ATOM    338  C   SER A  42      34.162  52.591   4.460  1.00 14.36           C  
ATOM    339  O   SER A  42      34.599  53.708   4.170  1.00 14.56           O  
ATOM    340  CB  SER A  42      32.084  52.779   5.777  1.00 14.47           C  
ATOM    341  OG  SER A  42      31.367  52.279   6.891  1.00 16.71           O  
ATOM    342  N   VAL A  43      34.176  51.547   3.625  1.00 14.29           N  
ATOM    343  CA  VAL A  43      34.450  51.698   2.196  1.00 14.81           C  
ATOM    344  C   VAL A  43      33.122  52.082   1.548  1.00 15.43           C  
ATOM    345  O   VAL A  43      32.183  51.273   1.501  1.00 16.43           O  
ATOM    346  CB  VAL A  43      35.000  50.405   1.560  1.00 14.40           C  
ATOM    347  CG1 VAL A  43      35.286  50.610   0.066  1.00 13.32           C  
ATOM    348  CG2 VAL A  43      36.248  49.922   2.279  1.00 13.57           C  
ATOM    349  N   GLU A  44      33.035  53.319   1.069  1.00 16.25           N  
ATOM    350  CA  GLU A  44      31.783  53.838   0.542  1.00 16.97           C  
ATOM    351  C   GLU A  44      31.585  53.398  -0.910  1.00 16.64           C  
ATOM    352  O   GLU A  44      32.546  53.079  -1.615  1.00 15.46           O  
ATOM    353  CB  GLU A  44      31.716  55.368   0.660  1.00 17.93           C  
ATOM    354  CG  GLU A  44      31.815  55.913   2.101  1.00 20.64           C  
ATOM    355  CD  GLU A  44      30.539  55.708   2.920  1.00 25.31           C  
ATOM    356  OE1 GLU A  44      29.436  55.634   2.328  1.00 28.36           O  
ATOM    357  OE2 GLU A  44      30.632  55.636   4.169  1.00 27.32           O  
ATOM    358  N   GLU A  45      30.330  53.376  -1.347  1.00 17.01           N  
ATOM    359  CA  GLU A  45      30.014  53.113  -2.744  1.00 17.38           C  
ATOM    360  C   GLU A  45      30.859  54.001  -3.645  1.00 17.04           C  
ATOM    361  O   GLU A  45      30.955  55.205  -3.423  1.00 18.27           O  
ATOM    362  CB  GLU A  45      28.530  53.386  -3.007  1.00 17.55           C  
ATOM    363  CG  GLU A  45      28.040  52.922  -4.364  1.00 19.97           C  
ATOM    364  CD  GLU A  45      27.564  51.484  -4.359  1.00 23.32           C  
ATOM    365  OE1 GLU A  45      27.615  50.852  -3.277  1.00 26.18           O  
ATOM    366  OE2 GLU A  45      27.133  50.991  -5.428  1.00 22.90           O  
ATOM    367  N   GLY A  46      31.493  53.401  -4.646  1.00 16.59           N  
ATOM    368  CA  GLY A  46      32.247  54.159  -5.632  1.00 15.33           C  
ATOM    369  C   GLY A  46      33.714  54.336  -5.304  1.00 14.76           C  
ATOM    370  O   GLY A  46      34.461  54.872  -6.112  1.00 15.04           O  
ATOM    371  N   GLU A  47      34.138  53.909  -4.118  1.00 13.85           N  
ATOM    372  CA  GLU A  47      35.571  53.925  -3.802  1.00 13.57           C  
ATOM    373  C   GLU A  47      36.106  52.524  -3.544  1.00 12.10           C  
ATOM    374  O   GLU A  47      35.350  51.596  -3.266  1.00 11.98           O  
ATOM    375  CB  GLU A  47      35.908  54.884  -2.644  1.00 13.60           C  
ATOM    376  CG  GLU A  47      35.564  54.375  -1.265  1.00 15.26           C  
ATOM    377  CD  GLU A  47      35.705  55.436  -0.168  1.00 14.71           C  
ATOM    378  OE1 GLU A  47      36.222  56.549  -0.413  1.00 15.62           O  
ATOM    379  OE2 GLU A  47      35.282  55.147   0.949  1.00 16.52           O  
ATOM    380  N   THR A  48      37.419  52.386  -3.654  1.00 11.71           N  
ATOM    381  CA  THR A  48      38.106  51.137  -3.344  1.00 11.19           C  
ATOM    382  C   THR A  48      38.618  51.194  -1.903  1.00 10.87           C  
ATOM    383  O   THR A  48      38.638  52.257  -1.291  1.00 10.85           O  
ATOM    384  CB  THR A  48      39.303  50.941  -4.267  1.00 10.43           C  
ATOM    385  OG1 THR A  48      40.263  51.965  -3.989  1.00 10.66           O  
ATOM    386  CG2 THR A  48      38.894  51.023  -5.752  1.00 10.41           C  
ATOM    387  N   ALA A  49      39.055  50.059  -1.364  1.00 11.30           N  
ATOM    388  CA  ALA A  49      39.586  50.032   0.005  1.00 11.29           C  
ATOM    389  C   ALA A  49      40.832  50.926   0.189  1.00 11.68           C  
ATOM    390  O   ALA A  49      40.893  51.677   1.158  1.00 11.54           O  
ATOM    391  CB  ALA A  49      39.845  48.591   0.460  1.00 11.85           C  
ATOM    392  N   PRO A  50      41.813  50.872  -0.740  1.00 11.86           N  
ATOM    393  CA  PRO A  50      42.952  51.799  -0.552  1.00 12.27           C  
ATOM    394  C   PRO A  50      42.522  53.276  -0.528  1.00 12.47           C  
ATOM    395  O   PRO A  50      43.030  54.054   0.282  1.00 11.97           O  
ATOM    396  CB  PRO A  50      43.849  51.501  -1.759  1.00 12.07           C  
ATOM    397  CG  PRO A  50      43.485  50.085  -2.145  1.00 12.67           C  
ATOM    398  CD  PRO A  50      42.017  50.000  -1.910  1.00 11.73           C  
ATOM    399  N   GLN A  51      41.576  53.631  -1.398  1.00 12.47           N  
ATOM    400  CA  GLN A  51      41.015  54.978  -1.455  1.00 13.20           C  
ATOM    401  C   GLN A  51      40.279  55.373  -0.184  1.00 13.23           C  
ATOM    402  O   GLN A  51      40.392  56.515   0.268  1.00 13.67           O  
ATOM    403  CB  GLN A  51      40.077  55.127  -2.653  1.00 13.20           C  
ATOM    404  CG  GLN A  51      40.783  55.170  -3.997  1.00 13.93           C  
ATOM    405  CD  GLN A  51      39.829  55.088  -5.174  1.00 13.16           C  
ATOM    406  OE1 GLN A  51      38.631  54.803  -5.027  1.00 14.44           O  
ATOM    407  NE2 GLN A  51      40.364  55.315  -6.364  1.00 14.34           N  
ATOM    408  N   ALA A  52      39.521  54.435   0.381  1.00 13.25           N  
ATOM    409  CA  ALA A  52      38.842  54.649   1.646  1.00 13.32           C  
ATOM    410  C   ALA A  52      39.856  54.869   2.754  1.00 13.25           C  
ATOM    411  O   ALA A  52      39.673  55.769   3.559  1.00 13.35           O  
ATOM    412  CB  ALA A  52      37.932  53.465   1.992  1.00 13.17           C  
ATOM    413  N   ALA A  53      40.913  54.051   2.782  1.00 13.18           N  
ATOM    414  CA  ALA A  53      41.995  54.196   3.765  1.00 13.94           C  
ATOM    415  C   ALA A  53      42.622  55.585   3.717  1.00 14.63           C  
ATOM    416  O   ALA A  53      42.850  56.202   4.761  1.00 14.34           O  
ATOM    417  CB  ALA A  53      43.059  53.115   3.578  1.00 13.72           C  
ATOM    418  N   MET A  54      42.868  56.090   2.513  1.00 15.36           N  
ATOM    419  CA  MET A  54      43.499  57.401   2.363  1.00 16.61           C  
ATOM    420  C   MET A  54      42.587  58.528   2.816  1.00 15.67           C  
ATOM    421  O   MET A  54      43.026  59.440   3.522  1.00 15.08           O  
ATOM    422  CB  MET A  54      43.986  57.630   0.926  1.00 16.54           C  
ATOM    423  CG  MET A  54      45.232  56.820   0.585  1.00 18.43           C  
ATOM    424  SD  MET A  54      46.010  57.253  -0.981  1.00 20.78           S  
ATOM    425  CE  MET A  54      44.781  56.697  -2.156  1.00 18.31           C  
ATOM    426  N   ARG A  55      41.324  58.451   2.410  1.00 15.05           N  
ATOM    427  CA  ARG A  55      40.300  59.422   2.789  1.00 15.24           C  
ATOM    428  C   ARG A  55      40.130  59.484   4.303  1.00 14.98           C  
ATOM    429  O   ARG A  55      40.137  60.567   4.877  1.00 14.81           O  
ATOM    430  CB  ARG A  55      38.962  59.084   2.111  1.00 14.73           C  
ATOM    431  CG  ARG A  55      37.803  60.024   2.474  1.00 15.67           C  
ATOM    432  CD  ARG A  55      36.475  59.662   1.793  1.00 15.86           C  
ATOM    433  NE  ARG A  55      36.110  58.256   1.992  1.00 17.54           N  
ATOM    434  CZ  ARG A  55      35.687  57.720   3.134  1.00 17.50           C  
ATOM    435  NH1 ARG A  55      35.554  58.460   4.236  1.00 17.27           N  
ATOM    436  NH2 ARG A  55      35.403  56.424   3.177  1.00 17.35           N  
ATOM    437  N   GLU A  56      39.985  58.322   4.940  1.00 14.41           N  
ATOM    438  CA  GLU A  56      39.787  58.270   6.396  1.00 14.47           C  
ATOM    439  C   GLU A  56      40.986  58.795   7.174  1.00 14.08           C  
ATOM    440  O   GLU A  56      40.811  59.466   8.184  1.00 13.69           O  
ATOM    441  CB  GLU A  56      39.437  56.860   6.872  1.00 15.03           C  
ATOM    442  CG  GLU A  56      38.014  56.419   6.524  1.00 16.04           C  
ATOM    443  CD  GLU A  56      36.941  57.131   7.344  1.00 16.85           C  
ATOM    444  OE1 GLU A  56      37.272  57.930   8.239  1.00 20.27           O  
ATOM    445  OE2 GLU A  56      35.756  56.886   7.093  1.00 19.94           O  
ATOM    446  N   VAL A  57      42.195  58.476   6.711  1.00 13.17           N  
ATOM    447  CA  VAL A  57      43.421  58.988   7.353  1.00 13.15           C  
ATOM    448  C   VAL A  57      43.421  60.528   7.307  1.00 13.33           C  
ATOM    449  O   VAL A  57      43.699  61.195   8.313  1.00 12.76           O  
ATOM    450  CB  VAL A  57      44.697  58.376   6.714  1.00 12.80           C  
ATOM    451  CG1 VAL A  57      45.985  59.048   7.237  1.00 13.19           C  
ATOM    452  CG2 VAL A  57      44.752  56.868   6.976  1.00 13.38           C  
ATOM    453  N   LYS A  58      43.067  61.071   6.146  1.00 13.79           N  
ATOM    454  CA  LYS A  58      42.953  62.518   5.951  1.00 15.19           C  
ATOM    455  C   LYS A  58      41.834  63.141   6.794  1.00 15.75           C  
ATOM    456  O   LYS A  58      42.034  64.183   7.441  1.00 15.58           O  
ATOM    457  CB  LYS A  58      42.751  62.849   4.467  1.00 14.97           C  
ATOM    458  CG  LYS A  58      42.857  64.341   4.151  1.00 15.93           C  
ATOM    459  CD  LYS A  58      42.722  64.644   2.663  1.00 16.07           C  
ATOM    460  CE  LYS A  58      43.070  66.109   2.402  1.00 17.54           C  
ATOM    461  NZ  LYS A  58      43.055  66.456   0.958  1.00 18.72           N  
ATOM    462  N   GLU A  59      40.667  62.505   6.780  1.00 16.07           N  
ATOM    463  CA  GLU A  59      39.488  63.013   7.491  1.00 17.03           C  
ATOM    464  C   GLU A  59      39.654  62.949   9.008  1.00 16.57           C  
ATOM    465  O   GLU A  59      39.304  63.893   9.722  1.00 17.19           O  
ATOM    466  CB  GLU A  59      38.230  62.248   7.063  1.00 17.06           C  
ATOM    467  CG  GLU A  59      37.664  62.647   5.698  1.00 18.13           C  
ATOM    468  CD  GLU A  59      36.414  61.856   5.319  1.00 18.58           C  
ATOM    469  OE1 GLU A  59      36.008  60.948   6.077  1.00 22.43           O  
ATOM    470  OE2 GLU A  59      35.837  62.138   4.260  1.00 20.85           O  
ATOM    471  N   GLU A  60      40.212  61.846   9.494  1.00 16.27           N  
ATOM    472  CA  GLU A  60      40.297  61.611  10.931  1.00 16.19           C  
ATOM    473  C   GLU A  60      41.521  62.208  11.629  1.00 15.55           C  
ATOM    474  O   GLU A  60      41.413  62.637  12.768  1.00 15.25           O  
ATOM    475  CB  GLU A  60      40.210  60.129  11.252  1.00 16.37           C  
ATOM    476  CG  GLU A  60      38.889  59.479  10.853  1.00 18.98           C  
ATOM    477  CD  GLU A  60      38.668  58.148  11.527  1.00 21.92           C  
ATOM    478  OE1 GLU A  60      39.641  57.395  11.725  1.00 24.77           O  
ATOM    479  OE2 GLU A  60      37.511  57.852  11.874  1.00 26.25           O  
ATOM    480  N   VAL A  61      42.681  62.190  10.970  1.00 15.43           N  
ATOM    481  CA  VAL A  61      43.922  62.651  11.615  1.00 15.14           C  
ATOM    482  C   VAL A  61      44.696  63.671  10.784  1.00 15.41           C  
ATOM    483  O   VAL A  61      45.848  63.999  11.102  1.00 14.96           O  
ATOM    484  CB  VAL A  61      44.857  61.475  12.047  1.00 15.05           C  
ATOM    485  CG1 VAL A  61      44.158  60.572  13.044  1.00 14.46           C  
ATOM    486  CG2 VAL A  61      45.354  60.671  10.842  1.00 15.06           C  
ATOM    487  N   THR A  62      44.055  64.157   9.718  1.00 15.61           N  
ATOM    488  CA  THR A  62      44.583  65.257   8.908  1.00 16.69           C  
ATOM    489  C   THR A  62      46.001  64.974   8.392  1.00 16.39           C  
ATOM    490  O   THR A  62      46.880  65.849   8.388  1.00 16.58           O  
ATOM    491  CB  THR A  62      44.509  66.612   9.670  1.00 16.63           C  
ATOM    492  OG1 THR A  62      43.372  66.620  10.549  1.00 17.54           O  
ATOM    493  CG2 THR A  62      44.393  67.787   8.695  1.00 18.28           C  
ATOM    494  N   ILE A  63      46.211  63.736   7.966  1.00 16.24           N  
ATOM    495  CA  ILE A  63      47.437  63.336   7.292  1.00 16.44           C  
ATOM    496  C   ILE A  63      47.093  62.962   5.865  1.00 16.87           C  
ATOM    497  O   ILE A  63      46.246  62.102   5.607  1.00 16.46           O  
ATOM    498  CB  ILE A  63      48.144  62.173   8.012  1.00 16.59           C  
ATOM    499  CG1 ILE A  63      48.660  62.634   9.375  1.00 16.00           C  
ATOM    500  CG2 ILE A  63      49.275  61.586   7.157  1.00 17.47           C  
ATOM    501  CD1 ILE A  63      48.982  61.488  10.314  1.00 16.48           C  
ATOM    502  N   ASP A  64      47.741  63.647   4.934  1.00 17.40           N  
ATOM    503  CA  ASP A  64      47.502  63.432   3.529  1.00 17.75           C  
ATOM    504  C   ASP A  64      48.632  62.558   3.003  1.00 17.83           C  
ATOM    505  O   ASP A  64      49.745  63.035   2.786  1.00 17.71           O  
ATOM    506  CB  ASP A  64      47.451  64.792   2.824  1.00 17.90           C  
ATOM    507  CG  ASP A  64      46.934  64.700   1.412  1.00 17.96           C  
ATOM    508  OD1 ASP A  64      47.252  63.711   0.717  1.00 18.91           O  
ATOM    509  OD2 ASP A  64      46.213  65.629   0.994  1.00 18.70           O  
ATOM    510  N   VAL A  65      48.339  61.272   2.826  1.00 18.24           N  
ATOM    511  CA  VAL A  65      49.334  60.270   2.435  1.00 18.99           C  
ATOM    512  C   VAL A  65      49.947  60.591   1.067  1.00 19.21           C  
ATOM    513  O   VAL A  65      51.170  60.548   0.897  1.00 19.10           O  
ATOM    514  CB  VAL A  65      48.728  58.833   2.459  1.00 18.93           C  
ATOM    515  CG1 VAL A  65      49.690  57.814   1.843  1.00 19.67           C  
ATOM    516  CG2 VAL A  65      48.378  58.422   3.889  1.00 18.90           C  
ATOM    517  N   VAL A  66      49.091  60.932   0.112  1.00 19.35           N  
ATOM    518  CA  VAL A  66      49.535  61.310  -1.230  1.00 19.94           C  
ATOM    519  C   VAL A  66      50.411  62.574  -1.184  1.00 20.11           C  
ATOM    520  O   VAL A  66      51.485  62.617  -1.792  1.00 20.52           O  
ATOM    521  CB  VAL A  66      48.338  61.477  -2.201  1.00 19.67           C  
ATOM    522  CG1 VAL A  66      48.795  62.034  -3.543  1.00 20.29           C  
ATOM    523  CG2 VAL A  66      47.637  60.152  -2.415  1.00 20.25           C  
ATOM    524  N   ALA A  67      49.969  63.584  -0.438  1.00 20.42           N  
ATOM    525  CA  ALA A  67      50.705  64.846  -0.349  1.00 20.45           C  
ATOM    526  C   ALA A  67      52.047  64.714   0.366  1.00 20.75           C  
ATOM    527  O   ALA A  67      53.014  65.398   0.019  1.00 20.89           O  
ATOM    528  CB  ALA A  67      49.858  65.917   0.310  1.00 20.73           C  
ATOM    529  N   GLU A  68      52.113  63.841   1.364  1.00 20.47           N  
ATOM    530  CA  GLU A  68      53.356  63.646   2.107  1.00 20.78           C  
ATOM    531  C   GLU A  68      54.272  62.599   1.467  1.00 20.62           C  
ATOM    532  O   GLU A  68      55.379  62.359   1.949  1.00 20.85           O  
ATOM    533  CB  GLU A  68      53.063  63.307   3.573  1.00 20.79           C  
ATOM    534  CG  GLU A  68      52.524  64.475   4.368  1.00 21.75           C  
ATOM    535  CD  GLU A  68      52.544  64.231   5.862  1.00 23.55           C  
ATOM    536  OE1 GLU A  68      53.473  63.541   6.348  1.00 24.50           O  
ATOM    537  OE2 GLU A  68      51.644  64.749   6.556  1.00 22.85           O  
ATOM    538  N   GLN A  69      53.802  61.992   0.378  1.00 20.85           N  
ATOM    539  CA  GLN A  69      54.518  60.930  -0.332  1.00 21.06           C  
ATOM    540  C   GLN A  69      54.905  59.777   0.603  1.00 21.11           C  
ATOM    541  O   GLN A  69      55.974  59.173   0.472  1.00 20.96           O  
ATOM    542  CB  GLN A  69      55.726  61.491  -1.098  1.00 21.29           C  
ATOM    543  CG  GLN A  69      55.360  62.611  -2.066  1.00 21.68           C  
ATOM    544  CD  GLN A  69      56.572  63.306  -2.663  1.00 21.73           C  
ATOM    545  OE1 GLN A  69      56.702  63.402  -3.885  1.00 22.84           O  
ATOM    546  NE2 GLN A  69      57.466  63.797  -1.806  1.00 22.47           N  
ATOM    547  N   LEU A  70      54.007  59.485   1.546  1.00 21.00           N  
ATOM    548  CA  LEU A  70      54.173  58.355   2.455  1.00 21.07           C  
ATOM    549  C   LEU A  70      53.705  57.068   1.773  1.00 21.22           C  
ATOM    550  O   LEU A  70      53.054  57.113   0.726  1.00 21.13           O  
ATOM    551  CB  LEU A  70      53.435  58.606   3.779  1.00 21.03           C  
ATOM    552  CG  LEU A  70      53.883  59.848   4.559  1.00 21.15           C  
ATOM    553  CD1 LEU A  70      52.899  60.203   5.666  1.00 22.28           C  
ATOM    554  CD2 LEU A  70      55.293  59.680   5.125  1.00 21.55           C  
ATOM    555  N   THR A  71      54.072  55.925   2.342  1.00 21.18           N  
ATOM    556  CA  THR A  71      53.728  54.633   1.755  1.00 21.46           C  
ATOM    557  C   THR A  71      52.568  54.020   2.540  1.00 21.23           C  
ATOM    558  O   THR A  71      52.729  53.638   3.698  1.00 21.74           O  
ATOM    559  CB  THR A  71      54.949  53.674   1.745  1.00 21.44           C  
ATOM    560  OG1 THR A  71      56.044  54.290   1.044  1.00 22.43           O  
ATOM    561  CG2 THR A  71      54.603  52.333   1.087  1.00 21.49           C  
ATOM    562  N   LEU A  72      51.395  53.953   1.916  1.00 21.55           N  
ATOM    563  CA  LEU A  72      50.246  53.273   2.517  1.00 21.41           C  
ATOM    564  C   LEU A  72      50.428  51.785   2.239  1.00 21.25           C  
ATOM    565  O   LEU A  72      50.256  51.333   1.107  1.00 22.03           O  
ATOM    566  CB  LEU A  72      48.939  53.769   1.893  1.00 21.80           C  
ATOM    567  CG  LEU A  72      47.608  53.906   2.656  1.00 22.35           C  
ATOM    568  CD1 LEU A  72      46.475  53.407   1.773  1.00 22.79           C  
ATOM    569  CD2 LEU A  72      47.553  53.204   4.018  1.00 21.96           C  
ATOM    570  N   ILE A  73      50.804  51.026   3.261  1.00 20.57           N  
ATOM    571  CA  ILE A  73      51.100  49.611   3.074  1.00 20.35           C  
ATOM    572  C   ILE A  73      49.801  48.799   3.084  1.00 19.55           C  
ATOM    573  O   ILE A  73      49.054  48.835   4.048  1.00 18.41           O  
ATOM    574  CB  ILE A  73      52.098  49.078   4.148  1.00 20.74           C  
ATOM    575  CG1 ILE A  73      53.401  49.892   4.128  1.00 21.05           C  
ATOM    576  CG2 ILE A  73      52.375  47.585   3.937  1.00 21.40           C  
ATOM    577  CD1 ILE A  73      54.233  49.821   5.436  1.00 21.04           C  
ATOM    578  N   ASP A  74      49.531  48.092   1.989  1.00 19.30           N  
ATOM    579  CA  ASP A  74      48.412  47.155   1.954  1.00 18.84           C  
ATOM    580  C   ASP A  74      48.898  45.853   2.585  1.00 18.81           C  
ATOM    581  O   ASP A  74      49.805  45.195   2.058  1.00 18.81           O  
ATOM    582  CB  ASP A  74      47.954  46.928   0.510  1.00 18.94           C  
ATOM    583  CG  ASP A  74      46.668  46.123   0.411  1.00 19.67           C  
ATOM    584  OD1 ASP A  74      46.414  45.254   1.272  1.00 19.57           O  
ATOM    585  OD2 ASP A  74      45.905  46.352  -0.550  1.00 21.05           O  
ATOM    586  N   CYS A  75      48.317  45.503   3.731  1.00 18.66           N  
ATOM    587  CA  CYS A  75      48.722  44.305   4.466  1.00 18.76           C  
ATOM    588  C   CYS A  75      48.298  43.014   3.776  1.00 18.39           C  
ATOM    589  O   CYS A  75      48.770  41.939   4.143  1.00 18.14           O  
ATOM    590  CB  CYS A  75      48.153  44.316   5.875  1.00 18.56           C  
ATOM    591  SG  CYS A  75      48.720  45.680   6.858  1.00 21.90           S  
ATOM    592  N   GLN A  76      47.410  43.135   2.792  1.00 18.31           N  
ATOM    593  CA  GLN A  76      46.802  41.991   2.113  1.00 18.12           C  
ATOM    594  C   GLN A  76      46.204  41.001   3.115  1.00 18.03           C  
ATOM    595  O   GLN A  76      46.394  39.792   3.006  1.00 18.03           O  
ATOM    596  CB  GLN A  76      47.809  41.311   1.171  1.00 18.39           C  
ATOM    597  CG  GLN A  76      48.265  42.213   0.031  1.00 18.19           C  
ATOM    598  CD  GLN A  76      49.154  41.512  -0.995  1.00 18.97           C  
ATOM    599  OE1 GLN A  76      49.531  42.111  -1.997  1.00 21.98           O  
ATOM    600  NE2 GLN A  76      49.490  40.251  -0.749  1.00 20.06           N  
ATOM    601  N   ARG A  77      45.496  41.549   4.102  1.00 17.87           N  
ATOM    602  CA  ARG A  77      44.763  40.776   5.091  1.00 17.86           C  
ATOM    603  C   ARG A  77      43.372  41.359   5.190  1.00 17.02           C  
ATOM    604  O   ARG A  77      43.195  42.582   5.261  1.00 16.52           O  
ATOM    605  CB  ARG A  77      45.429  40.841   6.471  1.00 18.77           C  
ATOM    606  CG  ARG A  77      46.261  39.605   6.845  1.00 22.32           C  
ATOM    607  CD  ARG A  77      47.622  39.635   6.222  1.00 26.41           C  
ATOM    608  NE  ARG A  77      48.269  38.322   6.229  1.00 30.02           N  
ATOM    609  CZ  ARG A  77      49.259  37.967   7.045  1.00 31.92           C  
ATOM    610  NH1 ARG A  77      49.739  38.823   7.944  1.00 32.90           N  
ATOM    611  NH2 ARG A  77      49.777  36.746   6.961  1.00 32.38           N  
ATOM    612  N   THR A  78      42.385  40.474   5.189  1.00 15.86           N  
ATOM    613  CA  THR A  78      41.007  40.868   5.390  1.00 14.88           C  
ATOM    614  C   THR A  78      40.456  39.961   6.482  1.00 14.14           C  
ATOM    615  O   THR A  78      40.680  38.761   6.446  1.00 14.19           O  
ATOM    616  CB  THR A  78      40.194  40.718   4.081  1.00 14.91           C  
ATOM    617  OG1 THR A  78      40.546  41.762   3.162  1.00 14.84           O  
ATOM    618  CG2 THR A  78      38.729  40.800   4.347  1.00 15.37           C  
ATOM    619  N   VAL A  79      39.770  40.527   7.475  1.00 13.68           N  
ATOM    620  CA  VAL A  79      39.110  39.687   8.488  1.00 14.00           C  
ATOM    621  C   VAL A  79      37.636  40.035   8.570  1.00 14.00           C  
ATOM    622  O   VAL A  79      37.211  41.061   8.054  1.00 14.29           O  
ATOM    623  CB  VAL A  79      39.749  39.844   9.905  1.00 14.02           C  
ATOM    624  CG1 VAL A  79      41.211  39.367   9.895  1.00 14.83           C  
ATOM    625  CG2 VAL A  79      39.642  41.291  10.381  1.00 14.63           C  
ATOM    626  N   GLU A  80      36.867  39.180   9.233  1.00 14.34           N  
ATOM    627  CA  GLU A  80      35.469  39.467   9.536  1.00 15.00           C  
ATOM    628  C   GLU A  80      35.227  39.368  11.040  1.00 14.32           C  
ATOM    629  O   GLU A  80      35.712  38.439  11.699  1.00 13.53           O  
ATOM    630  CB  GLU A  80      34.564  38.485   8.798  1.00 15.01           C  
ATOM    631  CG  GLU A  80      33.069  38.813   8.848  1.00 16.49           C  
ATOM    632  CD  GLU A  80      32.216  37.712   8.251  1.00 17.83           C  
ATOM    633  OE1 GLU A  80      32.348  37.424   7.044  1.00 20.76           O  
ATOM    634  OE2 GLU A  80      31.429  37.109   9.001  1.00 20.71           O  
ATOM    635  N   PHE A  81      34.462  40.312  11.586  1.00 13.55           N  
ATOM    636  CA  PHE A  81      34.174  40.275  13.009  1.00 13.17           C  
ATOM    637  C   PHE A  81      32.759  40.734  13.356  1.00 12.80           C  
ATOM    638  O   PHE A  81      32.116  41.432  12.565  1.00 12.67           O  
ATOM    639  CB  PHE A  81      35.235  41.059  13.812  1.00 12.58           C  
ATOM    640  CG  PHE A  81      35.351  42.518  13.456  1.00 13.32           C  
ATOM    641  CD1 PHE A  81      34.435  43.455  13.951  1.00 14.56           C  
ATOM    642  CD2 PHE A  81      36.408  42.962  12.673  1.00 15.44           C  
ATOM    643  CE1 PHE A  81      34.567  44.832  13.636  1.00 15.42           C  
ATOM    644  CE2 PHE A  81      36.553  44.314  12.359  1.00 15.11           C  
ATOM    645  CZ  PHE A  81      35.635  45.255  12.852  1.00 15.01           C  
ATOM    646  N   GLU A  82      32.292  40.334  14.546  1.00 12.62           N  
ATOM    647  CA  GLU A  82      30.988  40.762  15.070  1.00 12.27           C  
ATOM    648  C   GLU A  82      31.016  42.225  15.483  1.00 12.00           C  
ATOM    649  O   GLU A  82      31.836  42.636  16.310  1.00 11.71           O  
ATOM    650  CB  GLU A  82      30.556  39.905  16.264  1.00 11.89           C  
ATOM    651  CG  GLU A  82      29.132  40.210  16.785  1.00 12.79           C  
ATOM    652  CD  GLU A  82      28.021  39.686  15.875  1.00 13.56           C  
ATOM    653  OE1 GLU A  82      28.306  38.912  14.937  1.00 12.48           O  
ATOM    654  OE2 GLU A  82      26.849  40.032  16.124  1.00 13.10           O  
ATOM    655  N   ILE A  83      30.114  43.017  14.903  1.00 11.73           N  
ATOM    656  CA  ILE A  83      30.005  44.425  15.278  1.00 11.74           C  
ATOM    657  C   ILE A  83      29.626  44.488  16.770  1.00 11.10           C  
ATOM    658  O   ILE A  83      28.726  43.775  17.218  1.00 10.53           O  
ATOM    659  CB  ILE A  83      28.961  45.169  14.367  1.00 12.00           C  
ATOM    660  CG1 ILE A  83      29.461  45.198  12.920  1.00 12.46           C  
ATOM    661  CG2 ILE A  83      28.675  46.618  14.862  1.00 11.97           C  
ATOM    662  CD1 ILE A  83      28.364  45.354  11.897  1.00 12.40           C  
ATOM    663  N   PHE A  84      30.327  45.322  17.538  1.00 11.91           N  
ATOM    664  CA  PHE A  84      30.017  45.498  18.957  1.00 11.98           C  
ATOM    665  C   PHE A  84      28.539  45.839  19.100  1.00 12.80           C  
ATOM    666  O   PHE A  84      28.041  46.716  18.396  1.00 12.23           O  
ATOM    667  CB  PHE A  84      30.868  46.617  19.580  1.00 12.82           C  
ATOM    668  CG  PHE A  84      32.301  46.225  19.862  1.00 14.35           C  
ATOM    669  CD1 PHE A  84      32.717  44.896  19.790  1.00 15.52           C  
ATOM    670  CD2 PHE A  84      33.227  47.196  20.212  1.00 16.11           C  
ATOM    671  CE1 PHE A  84      34.056  44.540  20.061  1.00 17.52           C  
ATOM    672  CE2 PHE A  84      34.554  46.852  20.488  1.00 16.89           C  
ATOM    673  CZ  PHE A  84      34.962  45.523  20.416  1.00 15.75           C  
ATOM    674  N   SER A  85      27.859  45.124  19.990  1.00 12.44           N  
ATOM    675  CA  SER A  85      26.413  45.266  20.213  1.00 14.07           C  
ATOM    676  C   SER A  85      25.987  46.724  20.376  1.00 13.39           C  
ATOM    677  O   SER A  85      25.022  47.173  19.760  1.00 14.15           O  
ATOM    678  CB  SER A  85      25.999  44.465  21.447  1.00 13.59           C  
ATOM    679  OG  SER A  85      25.959  43.074  21.145  1.00 18.95           O  
ATOM    680  N   HIS A  86      26.743  47.462  21.179  1.00 13.75           N  
ATOM    681  CA  HIS A  86      26.404  48.835  21.535  1.00 13.62           C  
ATOM    682  C   HIS A  86      26.709  49.845  20.426  1.00 13.83           C  
ATOM    683  O   HIS A  86      26.386  51.028  20.574  1.00 14.91           O  
ATOM    684  CB  HIS A  86      27.094  49.225  22.860  1.00 13.85           C  
ATOM    685  CG  HIS A  86      28.591  49.174  22.808  1.00 13.90           C  
ATOM    686  ND1 HIS A  86      29.300  47.992  22.804  1.00 12.76           N  
ATOM    687  CD2 HIS A  86      29.516  50.164  22.786  1.00 15.26           C  
ATOM    688  CE1 HIS A  86      30.593  48.254  22.758  1.00 13.68           C  
ATOM    689  NE2 HIS A  86      30.751  49.565  22.743  1.00 14.47           N  
ATOM    690  N   LEU A  87      27.320  49.382  19.328  1.00 13.64           N  
ATOM    691  CA  LEU A  87      27.644  50.245  18.170  1.00 13.76           C  
ATOM    692  C   LEU A  87      26.906  49.848  16.877  1.00 14.22           C  
ATOM    693  O   LEU A  87      27.043  50.497  15.826  1.00 14.85           O  
ATOM    694  CB  LEU A  87      29.174  50.279  17.938  1.00 13.88           C  
ATOM    695  CG  LEU A  87      30.053  50.669  19.132  1.00 14.36           C  
ATOM    696  CD1 LEU A  87      31.551  50.431  18.847  1.00 16.61           C  
ATOM    697  CD2 LEU A  87      29.791  52.102  19.619  1.00 17.68           C  
ATOM    698  N   ARG A  88      26.123  48.782  16.955  1.00 13.92           N  
ATOM    699  CA  ARG A  88      25.451  48.210  15.787  1.00 14.16           C  
ATOM    700  C   ARG A  88      24.334  49.112  15.234  1.00 13.97           C  
ATOM    701  O   ARG A  88      23.949  48.968  14.076  1.00 14.07           O  
ATOM    702  CB  ARG A  88      24.897  46.829  16.146  1.00 14.69           C  
ATOM    703  CG  ARG A  88      24.533  45.949  14.969  1.00 17.56           C  
ATOM    704  CD  ARG A  88      23.522  44.872  15.376  1.00 21.95           C  
ATOM    705  NE  ARG A  88      24.098  43.975  16.380  1.00 26.13           N  
ATOM    706  CZ  ARG A  88      23.428  43.049  17.066  1.00 26.69           C  
ATOM    707  NH1 ARG A  88      22.127  42.858  16.880  1.00 26.48           N  
ATOM    708  NH2 ARG A  88      24.076  42.307  17.952  1.00 26.48           N  
ATOM    709  N   HIS A  89      23.863  50.051  16.056  1.00 13.66           N  
ATOM    710  CA  HIS A  89      22.763  50.975  15.703  1.00 14.29           C  
ATOM    711  C   HIS A  89      23.037  51.820  14.457  1.00 14.50           C  
ATOM    712  O   HIS A  89      22.100  52.302  13.814  1.00 14.77           O  
ATOM    713  CB  HIS A  89      22.470  51.905  16.887  1.00 14.31           C  
ATOM    714  CG  HIS A  89      23.613  52.808  17.232  1.00 14.51           C  
ATOM    715  ND1 HIS A  89      24.777  52.345  17.805  1.00 14.91           N  
ATOM    716  CD2 HIS A  89      23.785  54.140  17.055  1.00 15.17           C  
ATOM    717  CE1 HIS A  89      25.611  53.354  17.982  1.00 16.40           C  
ATOM    718  NE2 HIS A  89      25.038  54.454  17.530  1.00 14.49           N  
ATOM    719  N   ARG A  90      24.318  51.999  14.123  1.00 14.50           N  
ATOM    720  CA  ARG A  90      24.704  52.784  12.959  1.00 14.33           C  
ATOM    721  C   ARG A  90      24.702  51.987  11.654  1.00 13.91           C  
ATOM    722  O   ARG A  90      24.977  52.542  10.600  1.00 13.69           O  
ATOM    723  CB  ARG A  90      26.069  53.446  13.179  1.00 15.13           C  
ATOM    724  CG  ARG A  90      26.042  54.625  14.177  1.00 15.65           C  
ATOM    725  CD  ARG A  90      25.354  55.880  13.590  1.00 16.42           C  
ATOM    726  NE  ARG A  90      26.216  56.534  12.602  1.00 16.06           N  
ATOM    727  CZ  ARG A  90      26.028  56.529  11.284  1.00 18.32           C  
ATOM    728  NH1 ARG A  90      24.964  55.946  10.744  1.00 18.11           N  
ATOM    729  NH2 ARG A  90      26.906  57.139  10.496  1.00 18.46           N  
ATOM    730  N   TYR A  91      24.428  50.688  11.745  1.00 13.37           N  
ATOM    731  CA  TYR A  91      24.352  49.816  10.557  1.00 12.74           C  
ATOM    732  C   TYR A  91      22.917  49.460  10.205  1.00 12.44           C  
ATOM    733  O   TYR A  91      22.007  49.559  11.042  1.00 12.16           O  
ATOM    734  CB  TYR A  91      25.187  48.544  10.750  1.00 12.71           C  
ATOM    735  CG  TYR A  91      26.656  48.848  10.965  1.00 13.23           C  
ATOM    736  CD1 TYR A  91      27.123  49.256  12.216  1.00 12.79           C  
ATOM    737  CD2 TYR A  91      27.568  48.736   9.918  1.00 11.98           C  
ATOM    738  CE1 TYR A  91      28.472  49.553  12.415  1.00 12.70           C  
ATOM    739  CE2 TYR A  91      28.923  49.026  10.112  1.00 12.92           C  
ATOM    740  CZ  TYR A  91      29.358  49.430  11.350  1.00 12.47           C  
ATOM    741  OH  TYR A  91      30.698  49.721  11.519  1.00 14.42           O  
ATOM    742  N   ALA A  92      22.711  49.073   8.951  1.00 11.93           N  
ATOM    743  CA  ALA A  92      21.377  48.745   8.460  1.00 11.27           C  
ATOM    744  C   ALA A  92      20.748  47.602   9.252  1.00 11.73           C  
ATOM    745  O   ALA A  92      21.455  46.759   9.789  1.00 10.45           O  
ATOM    746  CB  ALA A  92      21.416  48.422   6.969  1.00 11.13           C  
ATOM    747  N   PRO A  93      19.404  47.579   9.340  1.00 11.68           N  
ATOM    748  CA  PRO A  93      18.740  46.494  10.065  1.00 12.27           C  
ATOM    749  C   PRO A  93      19.244  45.113   9.619  1.00 12.54           C  
ATOM    750  O   PRO A  93      19.366  44.852   8.423  1.00 12.44           O  
ATOM    751  CB  PRO A  93      17.268  46.682   9.688  1.00 12.49           C  
ATOM    752  CG  PRO A  93      17.142  48.149   9.449  1.00 12.55           C  
ATOM    753  CD  PRO A  93      18.434  48.546   8.785  1.00 12.70           C  
ATOM    754  N   GLY A  94      19.561  44.252  10.582  1.00 12.68           N  
ATOM    755  CA  GLY A  94      19.998  42.885  10.288  1.00 12.32           C  
ATOM    756  C   GLY A  94      21.508  42.730  10.192  1.00 12.51           C  
ATOM    757  O   GLY A  94      22.024  41.615  10.279  1.00 12.47           O  
ATOM    758  N   VAL A  95      22.214  43.843   9.998  1.00 11.69           N  
ATOM    759  CA  VAL A  95      23.670  43.810   9.839  1.00 12.11           C  
ATOM    760  C   VAL A  95      24.323  43.574  11.202  1.00 11.89           C  
ATOM    761  O   VAL A  95      24.064  44.315  12.144  1.00 12.62           O  
ATOM    762  CB  VAL A  95      24.204  45.109   9.173  1.00 11.48           C  
ATOM    763  CG1 VAL A  95      25.746  45.109   9.090  1.00 13.04           C  
ATOM    764  CG2 VAL A  95      23.604  45.273   7.766  1.00 12.31           C  
ATOM    765  N   THR A  96      25.174  42.548  11.282  1.00 12.34           N  
ATOM    766  CA  THR A  96      25.924  42.212  12.512  1.00 12.62           C  
ATOM    767  C   THR A  96      27.412  41.907  12.282  1.00 13.14           C  
ATOM    768  O   THR A  96      28.203  41.892  13.249  1.00 12.36           O  
ATOM    769  CB  THR A  96      25.271  41.005  13.265  1.00 12.81           C  
ATOM    770  OG1 THR A  96      25.269  39.856  12.413  1.00 13.77           O  
ATOM    771  CG2 THR A  96      23.838  41.312  13.696  1.00 13.67           C  
ATOM    772  N   ARG A  97      27.792  41.677  11.019  1.00 12.55           N  
ATOM    773  CA  ARG A  97      29.152  41.250  10.627  1.00 13.26           C  
ATOM    774  C   ARG A  97      29.838  42.381   9.859  1.00 12.80           C  
ATOM    775  O   ARG A  97      29.274  42.913   8.905  1.00 13.56           O  
ATOM    776  CB  ARG A  97      29.092  40.039   9.683  1.00 13.15           C  
ATOM    777  CG  ARG A  97      28.491  38.756  10.223  1.00 16.04           C  
ATOM    778  CD  ARG A  97      29.611  37.808  10.592  1.00 21.54           C  
ATOM    779  NE  ARG A  97      29.819  37.840  12.014  1.00 18.69           N  
ATOM    780  CZ  ARG A  97      30.909  37.463  12.682  1.00 16.73           C  
ATOM    781  NH1 ARG A  97      32.025  37.011  12.111  1.00 18.27           N  
ATOM    782  NH2 ARG A  97      30.856  37.567  13.975  1.00 13.30           N  
ATOM    783  N   ASN A  98      31.050  42.742  10.257  1.00 13.06           N  
ATOM    784  CA  ASN A  98      31.830  43.704   9.501  1.00 12.46           C  
ATOM    785  C   ASN A  98      33.060  43.027   8.904  1.00 12.87           C  
ATOM    786  O   ASN A  98      33.726  42.241   9.573  1.00 11.71           O  
ATOM    787  CB  ASN A  98      32.247  44.869  10.407  1.00 13.62           C  
ATOM    788  CG  ASN A  98      32.992  45.949   9.667  1.00 13.73           C  
ATOM    789  OD1 ASN A  98      32.438  46.630   8.819  1.00 16.43           O  
ATOM    790  ND2 ASN A  98      34.265  46.131  10.011  1.00 18.18           N  
ATOM    791  N   THR A  99      33.344  43.335   7.646  1.00 12.50           N  
ATOM    792  CA  THR A  99      34.532  42.830   6.985  1.00 12.68           C  
ATOM    793  C   THR A  99      35.508  43.996   6.914  1.00 12.36           C  
ATOM    794  O   THR A  99      35.163  45.081   6.453  1.00 13.43           O  
ATOM    795  CB  THR A  99      34.179  42.275   5.587  1.00 12.67           C  
ATOM    796  OG1 THR A  99      33.383  41.099   5.749  1.00 12.87           O  
ATOM    797  CG2 THR A  99      35.419  41.919   4.814  1.00 13.29           C  
ATOM    798  N   GLU A 100      36.720  43.762   7.394  1.00 11.87           N  
ATOM    799  CA  GLU A 100      37.729  44.799   7.513  1.00 12.05           C  
ATOM    800  C   GLU A 100      39.032  44.411   6.814  1.00 12.00           C  
ATOM    801  O   GLU A 100      39.559  43.331   7.036  1.00 12.56           O  
ATOM    802  CB  GLU A 100      38.001  45.028   8.989  1.00 11.62           C  
ATOM    803  CG  GLU A 100      38.987  46.109   9.306  1.00 13.33           C  
ATOM    804  CD  GLU A 100      39.301  46.132  10.775  1.00 15.03           C  
ATOM    805  OE1 GLU A 100      39.962  45.193  11.271  1.00 17.35           O  
ATOM    806  OE2 GLU A 100      38.838  47.065  11.438  1.00 15.21           O  
ATOM    807  N   SER A 101      39.555  45.326   6.008  1.00 12.30           N  
ATOM    808  CA  SER A 101      40.841  45.142   5.333  1.00 12.90           C  
ATOM    809  C   SER A 101      41.918  46.046   5.928  1.00 12.53           C  
ATOM    810  O   SER A 101      41.677  47.226   6.219  1.00 11.86           O  
ATOM    811  CB  SER A 101      40.687  45.415   3.848  1.00 13.38           C  
ATOM    812  OG  SER A 101      39.683  44.578   3.310  1.00 15.63           O  
ATOM    813  N   TRP A 102      43.109  45.479   6.089  1.00 12.24           N  
ATOM    814  CA  TRP A 102      44.166  46.117   6.863  1.00 12.79           C  
ATOM    815  C   TRP A 102      45.216  46.799   6.021  1.00 12.97           C  
ATOM    816  O   TRP A 102      45.658  46.268   4.983  1.00 12.84           O  
ATOM    817  CB  TRP A 102      44.879  45.101   7.742  1.00 13.13           C  
ATOM    818  CG  TRP A 102      44.053  44.437   8.780  1.00 13.64           C  
ATOM    819  CD1 TRP A 102      42.760  44.724   9.135  1.00 14.45           C  
ATOM    820  CD2 TRP A 102      44.483  43.380   9.637  1.00 14.20           C  
ATOM    821  NE1 TRP A 102      42.356  43.888  10.149  1.00 14.67           N  
ATOM    822  CE2 TRP A 102      43.396  43.060  10.486  1.00 14.23           C  
ATOM    823  CE3 TRP A 102      45.686  42.657   9.764  1.00 14.38           C  
ATOM    824  CZ2 TRP A 102      43.473  42.046  11.448  1.00 13.41           C  
ATOM    825  CZ3 TRP A 102      45.769  41.662  10.730  1.00 14.71           C  
ATOM    826  CH2 TRP A 102      44.661  41.361  11.553  1.00 13.79           C  
ATOM    827  N   PHE A 103      45.623  47.963   6.515  1.00 12.92           N  
ATOM    828  CA  PHE A 103      46.693  48.757   5.959  1.00 13.35           C  
ATOM    829  C   PHE A 103      47.554  49.247   7.121  1.00 13.87           C  
ATOM    830  O   PHE A 103      47.083  49.342   8.255  1.00 13.86           O  
ATOM    831  CB  PHE A 103      46.125  49.954   5.194  1.00 12.78           C  
ATOM    832  CG  PHE A 103      45.258  49.576   4.023  1.00 11.90           C  
ATOM    833  CD1 PHE A 103      43.922  49.216   4.219  1.00 12.68           C  
ATOM    834  CD2 PHE A 103      45.759  49.613   2.733  1.00 14.89           C  
ATOM    835  CE1 PHE A 103      43.127  48.860   3.147  1.00 12.62           C  
ATOM    836  CE2 PHE A 103      44.963  49.267   1.647  1.00 13.57           C  
ATOM    837  CZ  PHE A 103      43.637  48.893   1.865  1.00 13.70           C  
ATOM    838  N   CYS A 104      48.817  49.537   6.854  1.00 14.83           N  
ATOM    839  CA  CYS A 104      49.603  50.270   7.839  1.00 16.45           C  
ATOM    840  C   CYS A 104      50.228  51.521   7.234  1.00 15.63           C  
ATOM    841  O   CYS A 104      50.300  51.659   6.023  1.00 16.00           O  
ATOM    842  CB  CYS A 104      50.617  49.375   8.562  1.00 16.69           C  
ATOM    843  SG  CYS A 104      51.753  48.459   7.539  1.00 25.64           S  
ATOM    844  N   LEU A 105      50.654  52.441   8.093  1.00 15.53           N  
ATOM    845  CA  LEU A 105      51.227  53.693   7.625  1.00 15.72           C  
ATOM    846  C   LEU A 105      52.281  54.086   8.627  1.00 15.31           C  
ATOM    847  O   LEU A 105      51.961  54.374   9.779  1.00 15.47           O  
ATOM    848  CB  LEU A 105      50.163  54.790   7.483  1.00 15.55           C  
ATOM    849  CG  LEU A 105      50.623  56.156   6.951  1.00 16.44           C  
ATOM    850  CD1 LEU A 105      50.869  56.134   5.432  1.00 18.22           C  
ATOM    851  CD2 LEU A 105      49.628  57.239   7.332  1.00 16.79           C  
ATOM    852  N   ALA A 106      53.541  54.040   8.199  1.00 15.69           N  
ATOM    853  CA  ALA A 106      54.637  54.506   9.040  1.00 15.75           C  
ATOM    854  C   ALA A 106      54.926  55.970   8.746  1.00 15.46           C  
ATOM    855  O   ALA A 106      55.182  56.350   7.604  1.00 15.68           O  
ATOM    856  CB  ALA A 106      55.880  53.662   8.831  1.00 15.93           C  
ATOM    857  N   LEU A 107      54.859  56.789   9.787  1.00 15.04           N  
ATOM    858  CA  LEU A 107      55.303  58.170   9.709  1.00 14.81           C  
ATOM    859  C   LEU A 107      56.790  58.157  10.069  1.00 14.71           C  
ATOM    860  O   LEU A 107      57.222  57.304  10.851  1.00 14.58           O  
ATOM    861  CB  LEU A 107      54.516  59.041  10.689  1.00 14.23           C  
ATOM    862  CG  LEU A 107      52.973  59.055  10.634  1.00 14.22           C  
ATOM    863  CD1 LEU A 107      52.418  59.999  11.687  1.00 13.51           C  
ATOM    864  CD2 LEU A 107      52.431  59.430   9.261  1.00 13.28           C  
ATOM    865  N   PRO A 108      57.590  59.079   9.499  1.00 15.31           N  
ATOM    866  CA  PRO A 108      59.031  59.061   9.849  1.00 15.37           C  
ATOM    867  C   PRO A 108      59.287  59.329  11.335  1.00 15.91           C  
ATOM    868  O   PRO A 108      60.244  58.801  11.908  1.00 16.03           O  
ATOM    869  CB  PRO A 108      59.620  60.192   8.997  1.00 15.25           C  
ATOM    870  CG  PRO A 108      58.460  61.048   8.618  1.00 15.35           C  
ATOM    871  CD  PRO A 108      57.277  60.129   8.515  1.00 15.00           C  
ATOM    872  N   HIS A 109      58.430  60.144  11.941  1.00 15.79           N  
ATOM    873  CA  HIS A 109      58.549  60.495  13.351  1.00 15.93           C  
ATOM    874  C   HIS A 109      57.165  60.598  13.955  1.00 15.93           C  
ATOM    875  O   HIS A 109      56.155  60.618  13.238  1.00 16.40           O  
ATOM    876  CB  HIS A 109      59.280  61.832  13.525  1.00 15.98           C  
ATOM    877  CG  HIS A 109      60.588  61.901  12.801  1.00 16.19           C  
ATOM    878  ND1 HIS A 109      61.713  61.240  13.241  1.00 15.79           N  
ATOM    879  CD2 HIS A 109      60.940  62.527  11.655  1.00 15.79           C  
ATOM    880  CE1 HIS A 109      62.708  61.466  12.401  1.00 16.86           C  
ATOM    881  NE2 HIS A 109      62.263  62.243  11.429  1.00 17.11           N  
ATOM    882  N   GLU A 110      57.113  60.655  15.280  1.00 16.22           N  
ATOM    883  CA  GLU A 110      55.874  60.988  15.958  1.00 16.20           C  
ATOM    884  C   GLU A 110      55.588  62.445  15.655  1.00 17.02           C  
ATOM    885  O   GLU A 110      56.507  63.230  15.366  1.00 16.87           O  
ATOM    886  CB  GLU A 110      55.985  60.770  17.462  1.00 16.39           C  
ATOM    887  CG  GLU A 110      56.375  59.353  17.847  1.00 15.86           C  
ATOM    888  CD  GLU A 110      56.302  59.100  19.328  1.00 15.23           C  
ATOM    889  OE1 GLU A 110      55.923  60.006  20.090  1.00 17.59           O  
ATOM    890  OE2 GLU A 110      56.628  57.978  19.733  1.00 16.03           O  
ATOM    891  N   ARG A 111      54.315  62.805  15.684  1.00 17.38           N  
ATOM    892  CA  ARG A 111      53.940  64.197  15.517  1.00 17.85           C  
ATOM    893  C   ARG A 111      52.713  64.478  16.352  1.00 18.20           C  
ATOM    894  O   ARG A 111      51.956  63.562  16.696  1.00 18.21           O  
ATOM    895  CB  ARG A 111      53.654  64.510  14.049  1.00 17.20           C  
ATOM    896  CG  ARG A 111      52.390  63.820  13.511  1.00 18.02           C  
ATOM    897  CD  ARG A 111      52.059  64.244  12.097  1.00 17.56           C  
ATOM    898  NE  ARG A 111      52.975  63.651  11.125  1.00 16.43           N  
ATOM    899  CZ  ARG A 111      52.875  63.796   9.807  1.00 17.15           C  
ATOM    900  NH1 ARG A 111      51.889  64.518   9.279  1.00 17.92           N  
ATOM    901  NH2 ARG A 111      53.763  63.219   9.012  1.00 16.49           N  
ATOM    902  N   GLN A 112      52.521  65.755  16.675  1.00 18.88           N  
ATOM    903  CA  GLN A 112      51.244  66.197  17.194  1.00 19.78           C  
ATOM    904  C   GLN A 112      50.196  65.917  16.128  1.00 19.67           C  
ATOM    905  O   GLN A 112      50.463  66.039  14.925  1.00 19.70           O  
ATOM    906  CB  GLN A 112      51.273  67.672  17.577  1.00 19.90           C  
ATOM    907  CG  GLN A 112      51.847  67.907  18.960  1.00 22.49           C  
ATOM    908  CD  GLN A 112      51.765  69.351  19.376  1.00 24.99           C  
ATOM    909  OE1 GLN A 112      50.820  69.766  20.054  1.00 26.91           O  
ATOM    910  NE2 GLN A 112      52.748  70.137  18.957  1.00 25.60           N  
ATOM    911  N   ILE A 113      49.017  65.505  16.579  1.00 19.51           N  
ATOM    912  CA  ILE A 113      47.951  65.090  15.687  1.00 19.57           C  
ATOM    913  C   ILE A 113      46.751  66.024  15.792  1.00 19.69           C  
ATOM    914  O   ILE A 113      46.249  66.294  16.885  1.00 19.43           O  
ATOM    915  CB  ILE A 113      47.526  63.609  15.974  1.00 19.26           C  
ATOM    916  CG1 ILE A 113      48.639  62.624  15.575  1.00 19.18           C  
ATOM    917  CG2 ILE A 113      46.184  63.253  15.322  1.00 20.02           C  
ATOM    918  CD1 ILE A 113      48.965  62.570  14.079  1.00 19.27           C  
ATOM    919  N   VAL A 114      46.304  66.523  14.645  1.00 19.56           N  
ATOM    920  CA  VAL A 114      45.031  67.219  14.585  1.00 19.92           C  
ATOM    921  C   VAL A 114      43.913  66.231  14.241  1.00 19.79           C  
ATOM    922  O   VAL A 114      43.737  65.813  13.096  1.00 19.81           O  
ATOM    923  CB  VAL A 114      45.054  68.462  13.656  1.00 20.01           C  
ATOM    924  CG1 VAL A 114      45.869  69.577  14.291  1.00 20.53           C  
ATOM    925  CG2 VAL A 114      45.630  68.121  12.314  1.00 21.65           C  
ATOM    926  N   PHE A 115      43.183  65.847  15.278  1.00 20.07           N  
ATOM    927  CA  PHE A 115      42.104  64.880  15.169  1.00 19.91           C  
ATOM    928  C   PHE A 115      40.774  65.616  15.096  1.00 20.22           C  
ATOM    929  O   PHE A 115      40.607  66.695  15.674  1.00 20.33           O  
ATOM    930  CB  PHE A 115      42.138  63.887  16.340  1.00 19.58           C  
ATOM    931  CG  PHE A 115      42.127  64.539  17.696  1.00 19.86           C  
ATOM    932  CD1 PHE A 115      43.310  64.993  18.281  1.00 19.81           C  
ATOM    933  CD2 PHE A 115      40.934  64.700  18.392  1.00 20.13           C  
ATOM    934  CE1 PHE A 115      43.301  65.600  19.541  1.00 20.50           C  
ATOM    935  CE2 PHE A 115      40.914  65.302  19.656  1.00 19.69           C  
ATOM    936  CZ  PHE A 115      42.106  65.756  20.229  1.00 20.21           C  
ATOM    937  N   THR A 116      39.829  65.030  14.375  1.00 20.49           N  
ATOM    938  CA  THR A 116      38.589  65.728  14.054  1.00 20.95           C  
ATOM    939  C   THR A 116      37.360  65.009  14.588  1.00 20.71           C  
ATOM    940  O   THR A 116      36.348  65.637  14.895  1.00 21.19           O  
ATOM    941  CB  THR A 116      38.438  65.913  12.526  1.00 20.87           C  
ATOM    942  OG1 THR A 116      38.378  64.629  11.890  1.00 21.98           O  
ATOM    943  CG2 THR A 116      39.618  66.699  11.962  1.00 21.74           C  
ATOM    944  N   GLU A 117      37.456  63.691  14.707  1.00 20.41           N  
ATOM    945  CA  GLU A 117      36.296  62.862  15.010  1.00 20.54           C  
ATOM    946  C   GLU A 117      36.445  62.127  16.339  1.00 19.45           C  
ATOM    947  O   GLU A 117      35.457  61.657  16.905  1.00 20.62           O  
ATOM    948  CB  GLU A 117      36.043  61.873  13.863  1.00 20.63           C  
ATOM    949  CG  GLU A 117      35.847  62.544  12.489  1.00 22.71           C  
ATOM    950  CD  GLU A 117      35.630  61.559  11.344  1.00 22.51           C  
ATOM    951  OE1 GLU A 117      35.503  60.342  11.585  1.00 27.71           O  
ATOM    952  OE2 GLU A 117      35.569  62.010  10.184  1.00 26.77           O  
ATOM    953  N   HIS A 118      37.676  62.028  16.834  1.00 17.25           N  
ATOM    954  CA  HIS A 118      37.947  61.361  18.098  1.00 15.47           C  
ATOM    955  C   HIS A 118      38.029  62.373  19.243  1.00 14.75           C  
ATOM    956  O   HIS A 118      37.968  63.588  19.021  1.00 14.38           O  
ATOM    957  CB  HIS A 118      39.237  60.521  17.987  1.00 14.70           C  
ATOM    958  CG  HIS A 118      39.093  59.313  17.112  1.00 14.60           C  
ATOM    959  ND1 HIS A 118      39.201  59.368  15.737  1.00 13.62           N  
ATOM    960  CD2 HIS A 118      38.806  58.025  17.415  1.00 11.72           C  
ATOM    961  CE1 HIS A 118      39.022  58.158  15.234  1.00 13.28           C  
ATOM    962  NE2 HIS A 118      38.787  57.324  16.234  1.00 12.68           N  
ATOM    963  N   LEU A 119      38.169  61.872  20.464  1.00 14.00           N  
ATOM    964  CA  LEU A 119      38.201  62.728  21.641  1.00 13.61           C  
ATOM    965  C   LEU A 119      39.617  63.127  22.064  1.00 13.76           C  
ATOM    966  O   LEU A 119      39.829  64.146  22.747  1.00 13.73           O  
ATOM    967  CB  LEU A 119      37.496  62.021  22.786  1.00 13.85           C  
ATOM    968  CG  LEU A 119      36.007  61.708  22.589  1.00 12.26           C  
ATOM    969  CD1 LEU A 119      35.502  60.966  23.809  1.00 13.11           C  
ATOM    970  CD2 LEU A 119      35.162  62.971  22.351  1.00 14.83           C  
ATOM    971  N   ALA A 120      40.581  62.316  21.648  1.00 13.48           N  
ATOM    972  CA  ALA A 120      41.942  62.391  22.159  1.00 13.85           C  
ATOM    973  C   ALA A 120      42.825  61.434  21.386  1.00 14.03           C  
ATOM    974  O   ALA A 120      42.333  60.552  20.684  1.00 13.65           O  
ATOM    975  CB  ALA A 120      41.971  62.021  23.631  1.00 13.99           C  
ATOM    976  N   TYR A 121      44.140  61.609  21.528  1.00 14.66           N  
ATOM    977  CA  TYR A 121      45.103  60.666  20.985  1.00 15.09           C  
ATOM    978  C   TYR A 121      46.281  60.448  21.934  1.00 15.49           C  
ATOM    979  O   TYR A 121      46.604  61.301  22.775  1.00 14.56           O  
ATOM    980  CB  TYR A 121      45.603  61.110  19.597  1.00 15.41           C  
ATOM    981  CG  TYR A 121      46.634  62.206  19.660  1.00 16.13           C  
ATOM    982  CD1 TYR A 121      46.252  63.542  19.801  1.00 16.69           C  
ATOM    983  CD2 TYR A 121      47.998  61.913  19.596  1.00 16.42           C  
ATOM    984  CE1 TYR A 121      47.206  64.558  19.882  1.00 17.49           C  
ATOM    985  CE2 TYR A 121      48.952  62.919  19.674  1.00 17.58           C  
ATOM    986  CZ  TYR A 121      48.548  64.235  19.811  1.00 16.83           C  
ATOM    987  OH  TYR A 121      49.487  65.235  19.886  1.00 17.23           O  
ATOM    988  N   LYS A 122      46.906  59.288  21.784  1.00 16.12           N  
ATOM    989  CA  LYS A 122      48.107  58.924  22.527  1.00 16.48           C  
ATOM    990  C   LYS A 122      49.053  58.195  21.587  1.00 16.27           C  
ATOM    991  O   LYS A 122      48.613  57.426  20.733  1.00 16.85           O  
ATOM    992  CB  LYS A 122      47.750  58.014  23.709  1.00 16.96           C  
ATOM    993  CG  LYS A 122      47.135  58.731  24.888  1.00 19.90           C  
ATOM    994  CD  LYS A 122      47.023  57.808  26.096  1.00 23.42           C  
ATOM    995  CE  LYS A 122      46.560  58.570  27.330  1.00 25.23           C  
ATOM    996  NZ  LYS A 122      45.087  58.799  27.346  1.00 26.86           N  
ATOM    997  N   TRP A 123      50.353  58.452  21.743  1.00 15.93           N  
ATOM    998  CA  TRP A 123      51.390  57.634  21.126  1.00 14.88           C  
ATOM    999  C   TRP A 123      51.830  56.605  22.167  1.00 14.62           C  
ATOM   1000  O   TRP A 123      52.284  56.967  23.256  1.00 14.12           O  
ATOM   1001  CB  TRP A 123      52.578  58.491  20.688  1.00 14.67           C  
ATOM   1002  CG  TRP A 123      52.334  59.330  19.450  1.00 13.35           C  
ATOM   1003  CD1 TRP A 123      52.061  60.670  19.409  1.00 12.54           C  
ATOM   1004  CD2 TRP A 123      52.360  58.887  18.079  1.00 12.79           C  
ATOM   1005  NE1 TRP A 123      51.914  61.084  18.110  1.00 12.06           N  
ATOM   1006  CE2 TRP A 123      52.083  60.014  17.273  1.00 12.32           C  
ATOM   1007  CE3 TRP A 123      52.579  57.650  17.460  1.00 11.02           C  
ATOM   1008  CZ2 TRP A 123      52.028  59.943  15.879  1.00 13.11           C  
ATOM   1009  CZ3 TRP A 123      52.532  57.578  16.070  1.00 12.17           C  
ATOM   1010  CH2 TRP A 123      52.256  58.725  15.296  1.00 12.42           C  
ATOM   1011  N   LEU A 124      51.672  55.324  21.849  1.00 14.37           N  
ATOM   1012  CA  LEU A 124      51.983  54.277  22.819  1.00 15.22           C  
ATOM   1013  C   LEU A 124      52.907  53.225  22.238  1.00 14.88           C  
ATOM   1014  O   LEU A 124      52.794  52.897  21.051  1.00 14.89           O  
ATOM   1015  CB  LEU A 124      50.689  53.604  23.290  1.00 15.18           C  
ATOM   1016  CG  LEU A 124      49.657  54.455  24.043  1.00 15.89           C  
ATOM   1017  CD1 LEU A 124      48.384  53.655  24.244  1.00 17.42           C  
ATOM   1018  CD2 LEU A 124      50.191  54.975  25.371  1.00 16.23           C  
ATOM   1019  N   ASP A 125      53.796  52.664  23.063  1.00 14.69           N  
ATOM   1020  CA  ASP A 125      54.540  51.484  22.616  1.00 13.65           C  
ATOM   1021  C   ASP A 125      53.547  50.425  22.086  1.00 13.24           C  
ATOM   1022  O   ASP A 125      52.412  50.337  22.570  1.00 12.37           O  
ATOM   1023  CB  ASP A 125      55.525  50.953  23.675  1.00 14.31           C  
ATOM   1024  CG  ASP A 125      54.849  50.289  24.868  1.00 14.08           C  
ATOM   1025  OD1 ASP A 125      54.274  49.204  24.703  1.00 13.86           O  
ATOM   1026  OD2 ASP A 125      54.976  50.813  25.996  1.00 15.73           O  
ATOM   1027  N   ALA A 126      53.959  49.660  21.082  1.00 13.07           N  
ATOM   1028  CA  ALA A 126      53.014  48.793  20.372  1.00 12.70           C  
ATOM   1029  C   ALA A 126      52.321  47.749  21.259  1.00 12.74           C  
ATOM   1030  O   ALA A 126      51.106  47.569  21.115  1.00 13.15           O  
ATOM   1031  CB  ALA A 126      53.650  48.149  19.146  1.00 13.20           C  
ATOM   1032  N   PRO A 127      53.065  47.060  22.158  1.00 12.72           N  
ATOM   1033  CA  PRO A 127      52.374  46.170  23.102  1.00 13.10           C  
ATOM   1034  C   PRO A 127      51.310  46.869  23.949  1.00 13.29           C  
ATOM   1035  O   PRO A 127      50.233  46.300  24.143  1.00 13.73           O  
ATOM   1036  CB  PRO A 127      53.504  45.632  23.986  1.00 13.10           C  
ATOM   1037  CG  PRO A 127      54.735  45.724  23.126  1.00 13.40           C  
ATOM   1038  CD  PRO A 127      54.535  46.998  22.337  1.00 11.92           C  
ATOM   1039  N   ALA A 128      51.600  48.082  24.427  1.00 13.15           N  
ATOM   1040  CA  ALA A 128      50.625  48.855  25.210  1.00 13.50           C  
ATOM   1041  C   ALA A 128      49.389  49.195  24.368  1.00 13.70           C  
ATOM   1042  O   ALA A 128      48.262  49.166  24.862  1.00 13.47           O  
ATOM   1043  CB  ALA A 128      51.270  50.139  25.797  1.00 13.78           C  
ATOM   1044  N   ALA A 129      49.620  49.517  23.100  1.00 13.97           N  
ATOM   1045  CA  ALA A 129      48.554  49.893  22.174  1.00 14.67           C  
ATOM   1046  C   ALA A 129      47.644  48.709  21.888  1.00 14.73           C  
ATOM   1047  O   ALA A 129      46.406  48.809  21.976  1.00 15.35           O  
ATOM   1048  CB  ALA A 129      49.150  50.431  20.882  1.00 14.68           C  
ATOM   1049  N   ALA A 130      48.271  47.585  21.555  1.00 15.15           N  
ATOM   1050  CA  ALA A 130      47.558  46.339  21.308  1.00 15.18           C  
ATOM   1051  C   ALA A 130      46.753  45.911  22.527  1.00 15.05           C  
ATOM   1052  O   ALA A 130      45.644  45.402  22.393  1.00 14.84           O  
ATOM   1053  CB  ALA A 130      48.538  45.256  20.918  1.00 14.91           C  
ATOM   1054  N   ALA A 131      47.314  46.124  23.712  1.00 14.66           N  
ATOM   1055  CA  ALA A 131      46.635  45.770  24.962  1.00 14.62           C  
ATOM   1056  C   ALA A 131      45.446  46.685  25.265  1.00 14.37           C  
ATOM   1057  O   ALA A 131      44.469  46.256  25.883  1.00 15.36           O  
ATOM   1058  CB  ALA A 131      47.622  45.794  26.113  1.00 14.26           C  
ATOM   1059  N   LEU A 132      45.552  47.952  24.855  1.00 13.48           N  
ATOM   1060  CA  LEU A 132      44.555  48.963  25.178  1.00 13.09           C  
ATOM   1061  C   LEU A 132      43.300  48.838  24.327  1.00 12.79           C  
ATOM   1062  O   LEU A 132      42.193  49.001  24.842  1.00 12.75           O  
ATOM   1063  CB  LEU A 132      45.132  50.368  25.010  1.00 13.20           C  
ATOM   1064  CG  LEU A 132      44.151  51.541  25.082  1.00 12.54           C  
ATOM   1065  CD1 LEU A 132      43.624  51.724  26.502  1.00 14.00           C  
ATOM   1066  CD2 LEU A 132      44.808  52.811  24.583  1.00 12.38           C  
ATOM   1067  N   THR A 133      43.480  48.581  23.033  1.00 12.27           N  
ATOM   1068  CA  THR A 133      42.335  48.552  22.100  1.00 12.81           C  
ATOM   1069  C   THR A 133      41.316  47.471  22.468  1.00 12.98           C  
ATOM   1070  O   THR A 133      41.707  46.402  22.921  1.00 14.52           O  
ATOM   1071  CB  THR A 133      42.782  48.425  20.604  1.00 12.33           C  
ATOM   1072  OG1 THR A 133      41.640  48.563  19.749  1.00 11.98           O  
ATOM   1073  CG2 THR A 133      43.459  47.075  20.297  1.00 13.49           C  
ATOM   1074  N   LYS A 134      40.020  47.773  22.306  1.00 12.98           N  
ATOM   1075  CA  LYS A 134      38.954  46.778  22.471  1.00 13.19           C  
ATOM   1076  C   LYS A 134      38.786  45.876  21.251  1.00 12.62           C  
ATOM   1077  O   LYS A 134      38.199  44.792  21.355  1.00 13.48           O  
ATOM   1078  CB  LYS A 134      37.607  47.457  22.804  1.00 13.39           C  
ATOM   1079  CG  LYS A 134      37.541  48.078  24.190  1.00 15.50           C  
ATOM   1080  CD  LYS A 134      36.101  48.076  24.738  1.00 19.74           C  
ATOM   1081  CE  LYS A 134      35.547  49.464  24.795  1.00 18.63           C  
ATOM   1082  NZ  LYS A 134      34.115  49.499  25.226  1.00 16.04           N  
ATOM   1083  N   SER A 135      39.298  46.325  20.103  1.00 12.41           N  
ATOM   1084  CA  SER A 135      39.197  45.599  18.847  1.00 11.65           C  
ATOM   1085  C   SER A 135      40.283  44.531  18.687  1.00 11.45           C  
ATOM   1086  O   SER A 135      41.476  44.846  18.600  1.00 11.07           O  
ATOM   1087  CB  SER A 135      39.266  46.572  17.671  1.00 11.42           C  
ATOM   1088  OG  SER A 135      39.430  45.878  16.439  1.00 11.66           O  
ATOM   1089  N   TRP A 136      39.856  43.275  18.635  1.00 10.90           N  
ATOM   1090  CA  TRP A 136      40.768  42.144  18.419  1.00 11.20           C  
ATOM   1091  C   TRP A 136      41.548  42.223  17.117  1.00 10.80           C  
ATOM   1092  O   TRP A 136      42.735  41.888  17.086  1.00 10.29           O  
ATOM   1093  CB  TRP A 136      40.047  40.790  18.574  1.00 11.19           C  
ATOM   1094  CG  TRP A 136      39.070  40.370  17.484  1.00 12.15           C  
ATOM   1095  CD1 TRP A 136      37.705  40.418  17.550  1.00 12.00           C  
ATOM   1096  CD2 TRP A 136      39.387  39.756  16.223  1.00 12.80           C  
ATOM   1097  NE1 TRP A 136      37.158  39.913  16.396  1.00 13.34           N  
ATOM   1098  CE2 TRP A 136      38.168  39.517  15.558  1.00 12.75           C  
ATOM   1099  CE3 TRP A 136      40.585  39.440  15.567  1.00 12.40           C  
ATOM   1100  CZ2 TRP A 136      38.106  38.940  14.273  1.00 13.92           C  
ATOM   1101  CZ3 TRP A 136      40.524  38.867  14.291  1.00 13.18           C  
ATOM   1102  CH2 TRP A 136      39.291  38.628  13.659  1.00 12.27           C  
ATOM   1103  N   SER A 137      40.878  42.683  16.056  1.00 11.99           N  
ATOM   1104  CA  SER A 137      41.509  42.848  14.761  1.00 11.97           C  
ATOM   1105  C   SER A 137      42.551  43.960  14.806  1.00 12.58           C  
ATOM   1106  O   SER A 137      43.667  43.772  14.315  1.00 11.92           O  
ATOM   1107  CB  SER A 137      40.468  43.036  13.641  1.00 11.95           C  
ATOM   1108  OG  SER A 137      39.698  44.208  13.789  1.00 12.04           O  
ATOM   1109  N   ASN A 138      42.209  45.082  15.449  1.00 12.56           N  
ATOM   1110  CA  ASN A 138      43.171  46.164  15.663  1.00 13.28           C  
ATOM   1111  C   ASN A 138      44.389  45.652  16.453  1.00 13.21           C  
ATOM   1112  O   ASN A 138      45.522  45.974  16.113  1.00 14.15           O  
ATOM   1113  CB  ASN A 138      42.501  47.352  16.375  1.00 12.75           C  
ATOM   1114  CG  ASN A 138      43.182  48.711  16.097  1.00 13.65           C  
ATOM   1115  OD1 ASN A 138      42.526  49.754  16.171  1.00 14.55           O  
ATOM   1116  ND2 ASN A 138      44.482  48.701  15.789  1.00 13.72           N  
ATOM   1117  N   ARG A 139      44.151  44.872  17.507  1.00 13.88           N  
ATOM   1118  CA  ARG A 139      45.247  44.276  18.291  1.00 14.59           C  
ATOM   1119  C   ARG A 139      46.134  43.398  17.410  1.00 14.01           C  
ATOM   1120  O   ARG A 139      47.351  43.551  17.409  1.00 12.39           O  
ATOM   1121  CB  ARG A 139      44.698  43.453  19.467  1.00 14.59           C  
ATOM   1122  CG  ARG A 139      45.742  42.658  20.237  1.00 15.42           C  
ATOM   1123  CD  ARG A 139      45.156  42.000  21.476  1.00 17.66           C  
ATOM   1124  NE  ARG A 139      44.179  40.965  21.133  1.00 23.92           N  
ATOM   1125  CZ  ARG A 139      42.864  41.047  21.331  1.00 26.20           C  
ATOM   1126  NH1 ARG A 139      42.314  42.129  21.876  1.00 28.23           N  
ATOM   1127  NH2 ARG A 139      42.093  40.030  20.981  1.00 25.99           N  
ATOM   1128  N   GLN A 140      45.511  42.497  16.657  1.00 13.92           N  
ATOM   1129  CA  GLN A 140      46.249  41.530  15.840  1.00 14.64           C  
ATOM   1130  C   GLN A 140      47.080  42.228  14.768  1.00 13.80           C  
ATOM   1131  O   GLN A 140      48.193  41.789  14.475  1.00 13.82           O  
ATOM   1132  CB  GLN A 140      45.301  40.496  15.220  1.00 14.50           C  
ATOM   1133  CG  GLN A 140      45.986  39.454  14.329  1.00 16.36           C  
ATOM   1134  CD  GLN A 140      45.124  38.216  14.111  1.00 16.95           C  
ATOM   1135  OE1 GLN A 140      43.896  38.290  14.114  1.00 18.85           O  
ATOM   1136  NE2 GLN A 140      45.767  37.071  13.945  1.00 21.05           N  
ATOM   1137  N   ALA A 141      46.542  43.316  14.211  1.00 13.57           N  
ATOM   1138  CA  ALA A 141      47.232  44.067  13.151  1.00 12.97           C  
ATOM   1139  C   ALA A 141      48.464  44.772  13.704  1.00 12.70           C  
ATOM   1140  O   ALA A 141      49.509  44.780  13.052  1.00 12.85           O  
ATOM   1141  CB  ALA A 141      46.303  45.052  12.488  1.00 13.64           C  
ATOM   1142  N   ILE A 142      48.336  45.344  14.902  1.00 12.21           N  
ATOM   1143  CA  ILE A 142      49.490  45.925  15.622  1.00 12.28           C  
ATOM   1144  C   ILE A 142      50.576  44.872  15.887  1.00 12.76           C  
ATOM   1145  O   ILE A 142      51.764  45.099  15.629  1.00 13.11           O  
ATOM   1146  CB  ILE A 142      49.048  46.655  16.936  1.00 11.80           C  
ATOM   1147  CG1 ILE A 142      48.137  47.853  16.603  1.00 12.12           C  
ATOM   1148  CG2 ILE A 142      50.272  47.112  17.752  1.00 12.07           C  
ATOM   1149  CD1 ILE A 142      47.384  48.397  17.784  1.00 13.91           C  
ATOM   1150  N   GLU A 143      50.167  43.713  16.380  1.00 13.97           N  
ATOM   1151  CA  GLU A 143      51.108  42.630  16.677  1.00 14.95           C  
ATOM   1152  C   GLU A 143      51.839  42.103  15.450  1.00 15.71           C  
ATOM   1153  O   GLU A 143      53.041  41.883  15.497  1.00 15.50           O  
ATOM   1154  CB  GLU A 143      50.387  41.491  17.385  1.00 14.92           C  
ATOM   1155  CG  GLU A 143      49.855  41.895  18.744  1.00 16.37           C  
ATOM   1156  CD  GLU A 143      49.030  40.819  19.395  1.00 18.01           C  
ATOM   1157  OE1 GLU A 143      48.451  39.973  18.682  1.00 18.81           O  
ATOM   1158  OE2 GLU A 143      48.943  40.840  20.635  1.00 20.76           O  
ATOM   1159  N   GLN A 144      51.113  41.916  14.351  1.00 16.70           N  
ATOM   1160  CA  GLN A 144      51.702  41.323  13.145  1.00 18.63           C  
ATOM   1161  C   GLN A 144      52.474  42.318  12.277  1.00 18.21           C  
ATOM   1162  O   GLN A 144      53.451  41.940  11.620  1.00 18.71           O  
ATOM   1163  CB  GLN A 144      50.619  40.640  12.297  1.00 18.27           C  
ATOM   1164  CG  GLN A 144      49.867  39.520  13.000  1.00 20.90           C  
ATOM   1165  CD  GLN A 144      48.843  38.851  12.100  1.00 21.47           C  
ATOM   1166  OE1 GLN A 144      48.525  39.352  11.017  1.00 25.24           O  
ATOM   1167  NE2 GLN A 144      48.319  37.713  12.545  1.00 25.13           N  
ATOM   1168  N   PHE A 145      52.052  43.582  12.265  1.00 18.76           N  
ATOM   1169  CA  PHE A 145      52.643  44.555  11.337  1.00 19.48           C  
ATOM   1170  C   PHE A 145      53.408  45.732  11.946  1.00 20.07           C  
ATOM   1171  O   PHE A 145      53.979  46.554  11.222  1.00 20.47           O  
ATOM   1172  CB  PHE A 145      51.596  45.050  10.342  1.00 19.86           C  
ATOM   1173  CG  PHE A 145      51.080  43.976   9.433  1.00 19.41           C  
ATOM   1174  CD1 PHE A 145      51.775  43.628   8.279  1.00 20.95           C  
ATOM   1175  CD2 PHE A 145      49.908  43.295   9.736  1.00 18.45           C  
ATOM   1176  CE1 PHE A 145      51.305  42.621   7.436  1.00 20.62           C  
ATOM   1177  CE2 PHE A 145      49.422  42.292   8.898  1.00 18.75           C  
ATOM   1178  CZ  PHE A 145      50.125  41.954   7.749  1.00 19.99           C  
ATOM   1179  N   VAL A 146      53.408  45.830  13.271  1.00 20.14           N  
ATOM   1180  CA  VAL A 146      54.235  46.816  13.948  1.00 20.62           C  
ATOM   1181  C   VAL A 146      55.259  46.084  14.797  1.00 21.13           C  
ATOM   1182  O   VAL A 146      56.466  46.214  14.564  1.00 20.96           O  
ATOM   1183  CB  VAL A 146      53.418  47.803  14.819  1.00 20.50           C  
ATOM   1184  CG1 VAL A 146      54.345  48.797  15.507  1.00 20.37           C  
ATOM   1185  CG2 VAL A 146      52.384  48.532  13.984  1.00 20.83           C  
ATOM   1186  N   ILE A 147      54.773  45.302  15.763  1.00 21.78           N  
ATOM   1187  CA  ILE A 147      55.643  44.535  16.668  1.00 22.64           C  
ATOM   1188  C   ILE A 147      56.465  43.491  15.916  1.00 23.60           C  
ATOM   1189  O   ILE A 147      57.686  43.395  16.110  1.00 23.80           O  
ATOM   1190  CB  ILE A 147      54.839  43.839  17.804  1.00 22.38           C  
ATOM   1191  CG1 ILE A 147      54.067  44.876  18.628  1.00 21.88           C  
ATOM   1192  CG2 ILE A 147      55.767  43.006  18.704  1.00 22.58           C  
ATOM   1193  CD1 ILE A 147      53.177  44.308  19.722  1.00 22.90           C  
ATOM   1194  N   ASN A 148      55.773  42.743  15.051  1.00 24.34           N  
ATOM   1195  CA  ASN A 148      56.280  41.572  14.323  1.00 25.49           C  
ATOM   1196  C   ASN A 148      56.427  40.309  15.187  1.00 25.60           C  
ATOM   1197  O   ASN A 148      55.541  39.960  15.974  1.00 25.96           O  
ATOM   1198  CB  ASN A 148      57.567  41.890  13.556  1.00 25.89           C  
ATOM   1199  CG  ASN A 148      57.306  42.397  12.158  1.00 26.82           C  
ATOM   1200  OD1 ASN A 148      57.744  41.787  11.182  1.00 29.98           O  
ATOM   1201  ND2 ASN A 148      56.610  43.523  12.048  1.00 28.64           N  
TER    1202      ASN A 148                                                      
END
MOLECULE T0513.pdb
ATOM      7  N   MET     1      40.511  38.696  30.932  1.00 34.21           N  
ATOM      8  CA  MET     1      40.458  39.135  29.549  1.00 22.06           C  
ATOM      9  C   MET     1      41.682  38.517  28.896  1.00 20.62           C  
ATOM     10  O   MET     1      42.651  38.176  29.595  1.00 20.32           O  
ATOM     11  CB  MET     1      40.508  40.662  29.493  1.00 26.67           C  
ATOM     12  CG  MET     1      39.316  41.294  30.229  1.00 26.17           C  
ATOM     15  N   SER     2      41.648  38.358  27.573  1.00 18.56           N  
ATOM     16  CA  SER     2      42.745  37.762  26.830  1.00 17.53           C  
ATOM     17  C   SER     2      42.560  38.118  25.378  1.00 19.94           C  
ATOM     18  O   SER     2      41.495  38.598  24.988  1.00 17.05           O  
ATOM     19  CB  SER     2      42.710  36.228  26.946  1.00 17.75           C  
ATOM     20  OG  SER     2      41.480  35.716  26.386  1.00 17.41           O  
ATOM     21  N   PHE     3      43.586  37.860  24.569  1.00 16.42           N  
ATOM     22  CA  PHE     3      43.459  38.022  23.110  1.00 16.19           C  
ATOM     23  C   PHE     3      42.307  37.173  22.593  1.00 21.25           C  
ATOM     24  O   PHE     3      41.461  37.650  21.819  1.00 19.18           O  
ATOM     25  CB  PHE     3      44.739  37.581  22.397  1.00 16.58           C  
ATOM     26  CG  PHE     3      45.941  38.449  22.661  1.00 15.61           C  
ATOM     27  CD1 PHE     3      45.828  39.838  22.823  1.00 13.92           C  
ATOM     28  CD2 PHE     3      47.208  37.862  22.709  1.00 20.52           C  
ATOM     29  CE1 PHE     3      46.981  40.625  23.045  1.00 17.47           C  
ATOM     30  CE2 PHE     3      48.343  38.632  22.922  1.00 19.74           C  
ATOM     31  CZ  PHE     3      48.236  40.011  23.095  1.00 20.60           C  
ATOM     32  N   LEU     4      42.276  35.914  23.034  1.00 17.01           N  
ATOM     33  CA  LEU     4      41.300  34.959  22.547  1.00 17.54           C  
ATOM     34  C   LEU     4      39.864  35.393  22.852  1.00 15.99           C  
ATOM     35  O   LEU     4      38.998  35.315  21.978  1.00 18.48           O  
ATOM     36  CB  LEU     4      41.598  33.535  23.044  1.00 18.74           C  
ATOM     37  CG  LEU     4      40.593  32.443  22.590  1.00 23.52           C  
ATOM     38  CD1 LEU     4      40.527  32.284  21.070  1.00 23.88           C  
ATOM     39  CD2 LEU     4      40.891  31.090  23.260  1.00 23.18           C  
ATOM     40  N   LYS     5      39.637  35.880  24.072  1.00 17.97           N  
ATOM     41  CA  LYS     5      38.295  36.329  24.470  1.00 16.32           C  
ATOM     42  C   LYS     5      37.818  37.464  23.559  1.00 17.11           C  
ATOM     43  O   LYS     5      36.660  37.464  23.200  1.00 17.21           O  
ATOM     44  CB  LYS     5      38.234  36.758  25.934  1.00 25.30           C  
ATOM     45  CG  LYS     5      36.789  36.876  26.476  1.00 32.59           C  
ATOM     46  CD  LYS     5      36.697  37.899  27.624  1.00 46.27           C  
ATOM     47  CE  LYS     5      35.251  38.200  28.091  1.00 40.02           C  
ATOM     48  NZ  LYS     5      34.171  38.126  27.026  1.00 37.12           N  
ATOM     49  N   HIS     6      38.696  38.404  23.186  1.00 16.06           N  
ATOM     50  CA  HIS     6      38.317  39.478  22.227  1.00 19.72           C  
ATOM     51  C   HIS     6      37.859  38.902  20.880  1.00 17.75           C  
ATOM     52  O   HIS     6      36.864  39.336  20.280  1.00 17.62           O  
ATOM     53  CB  HIS     6      39.490  40.435  21.971  1.00 17.88           C  
ATOM     54  CG  HIS     6      39.760  41.393  23.082  1.00 26.05           C  
ATOM     55  ND1 HIS     6      38.778  42.169  23.654  1.00 23.15           N  
ATOM     56  CD2 HIS     6      40.912  41.716  23.719  1.00 20.43           C  
ATOM     57  CE1 HIS     6      39.305  42.917  24.607  1.00 24.59           C  
ATOM     58  NE2 HIS     6      40.601  42.674  24.658  1.00 23.21           N  
ATOM     59  N   VAL     7      38.607  37.911  20.395  1.00 19.93           N  
ATOM     60  CA  VAL     7      38.322  37.270  19.129  1.00 15.58           C  
ATOM     61  C   VAL     7      36.992  36.526  19.218  1.00 20.03           C  
ATOM     62  O   VAL     7      36.166  36.642  18.319  1.00 17.61           O  
ATOM     63  CB  VAL     7      39.521  36.349  18.692  1.00 18.90           C  
ATOM     64  CG1 VAL     7      39.154  35.465  17.528  1.00 22.87           C  
ATOM     65  CG2 VAL     7      40.777  37.213  18.386  1.00 17.72           C  
ATOM     66  N   GLN     8      36.777  35.822  20.329  1.00 18.18           N  
ATOM     67  CA  GLN     8      35.531  35.100  20.579  1.00 15.33           C  
ATOM     68  C   GLN     8      34.323  36.036  20.681  1.00 17.02           C  
ATOM     69  O   GLN     8      33.252  35.717  20.142  1.00 23.55           O  
ATOM     70  CB  GLN     8      35.662  34.259  21.842  1.00 20.01           C  
ATOM     71  CG  GLN     8      36.479  32.991  21.588  1.00 19.14           C  
ATOM     72  CD  GLN     8      36.808  32.235  22.869  1.00 26.74           C  
ATOM     73  OE1 GLN     8      36.820  32.801  23.960  1.00 25.57           O  
ATOM     74  NE2 GLN     8      37.099  30.951  22.729  1.00 29.56           N  
ATOM     75  N   ASP     9      34.514  37.181  21.363  1.00 16.26           N  
ATOM     76  CA  ASP     9      33.480  38.214  21.515  1.00 17.99           C  
ATOM     77  C   ASP     9      33.012  38.673  20.127  1.00 17.79           C  
ATOM     78  O   ASP     9      31.805  38.752  19.866  1.00 15.63           O  
ATOM     79  CB  ASP     9      34.018  39.459  22.245  1.00 20.20           C  
ATOM     80  CG  ASP     9      34.205  39.262  23.755  1.00 21.46           C  
ATOM     81  OD1 ASP     9      33.680  38.295  24.334  1.00 22.14           O  
ATOM     82  OD2 ASP     9      34.896  40.116  24.337  1.00 25.62           O  
ATOM     83  N   CYS    10      33.972  38.942  19.230  1.00 13.03           N  
ATOM     84  CA  CYS    10      33.660  39.396  17.882  1.00 17.68           C  
ATOM     85  C   CYS    10      33.082  38.342  16.932  1.00 17.69           C  
ATOM     86  O   CYS    10      32.679  38.677  15.815  1.00 18.01           O  
ATOM     87  CB  CYS    10      34.881  40.047  17.257  1.00 20.69           C  
ATOM     88  SG  CYS    10      35.334  41.640  18.054  1.00 22.02           S  
ATOM     89  N   ASN    11      33.044  37.089  17.377  1.00 16.85           N  
ATOM     90  CA  ASN    11      32.489  36.005  16.585  1.00 16.00           C  
ATOM     91  C   ASN    11      31.330  35.320  17.254  1.00 21.69           C  
ATOM     92  O   ASN    11      30.958  34.203  16.885  1.00 21.64           O  
ATOM     93  CB  ASN    11      33.593  35.035  16.168  1.00 18.19           C  
ATOM     94  CG  ASN    11      34.453  35.616  15.082  1.00 21.69           C  
ATOM     95  OD1 ASN    11      33.977  35.828  13.968  1.00 20.16           O  
ATOM     96  ND2 ASN    11      35.712  35.932  15.408  1.00 25.35           N  
ATOM     97  N   THR    12      30.714  36.017  18.208  1.00 18.95           N  
ATOM     98  CA  THR    12      29.572  35.446  18.892  1.00 18.63           C  
ATOM     99  C   THR    12      28.293  35.861  18.180  1.00 18.36           C  
ATOM    100  O   THR    12      27.984  37.047  18.086  1.00 16.47           O  
ATOM    101  CB  THR    12      29.537  35.840  20.405  1.00 22.56           C  
ATOM    102  OG1 THR    12      30.713  35.320  21.064  1.00 19.17           O  
ATOM    103  CG2 THR    12      28.285  35.238  21.068  1.00 19.34           C  
ATOM    104  N   HIS    13      27.555  34.886  17.684  1.00 20.03           N  
ATOM    105  CA  HIS    13      26.270  35.130  17.031  1.00 19.68           C  
ATOM    106  C   HIS    13      25.394  33.889  17.130  1.00 24.63           C  
ATOM    107  O   HIS    13      25.872  32.772  17.328  1.00 25.09           O  
ATOM    108  CB  HIS    13      26.459  35.517  15.545  1.00 17.84           C  
ATOM    109  CG  HIS    13      27.238  34.516  14.746  1.00 23.47           C  
ATOM    110  ND1 HIS    13      28.599  34.619  14.538  1.00 27.90           N  
ATOM    111  CD2 HIS    13      26.844  33.393  14.093  1.00 32.12           C  
ATOM    112  CE1 HIS    13      29.011  33.585  13.820  1.00 25.06           C  
ATOM    113  NE2 HIS    13      27.963  32.839  13.519  1.00 31.67           N  
ATOM    114  N   ASP    14      24.102  34.106  16.985  1.00 25.98           N  
ATOM    115  CA  ASP    14      23.143  33.016  17.030  1.00 27.37           C  
ATOM    116  C   ASP    14      22.171  33.358  15.918  1.00 21.97           C  
ATOM    117  O   ASP    14      21.442  34.348  16.004  1.00 26.94           O  
ATOM    118  CB  ASP    14      22.497  32.977  18.422  1.00 24.40           C  
ATOM    119  CG  ASP    14      21.469  31.861  18.586  1.00 31.83           C  
ATOM    120  OD1 ASP    14      20.981  31.300  17.594  1.00 29.47           O  
ATOM    121  OD2 ASP    14      21.138  31.552  19.744  1.00 35.82           O  
ATOM    122  N   LEU    15      22.188  32.547  14.866  1.00 23.16           N  
ATOM    123  CA  LEU    15      21.375  32.804  13.674  1.00 24.11           C  
ATOM    124  C   LEU    15      19.959  32.217  13.743  1.00 27.06           C  
ATOM    125  O   LEU    15      19.180  32.356  12.790  1.00 27.43           O  
ATOM    126  CB  LEU    15      22.111  32.360  12.406  1.00 25.67           C  
ATOM    127  CG  LEU    15      23.409  33.114  12.056  1.00 29.91           C  
ATOM    128  CD1 LEU    15      24.236  32.389  11.018  1.00 36.75           C  
ATOM    129  CD2 LEU    15      23.079  34.508  11.584  1.00 31.22           C  
ATOM    130  N   SER    16      19.615  31.610  14.889  1.00 24.69           N  
ATOM    131  CA  SER    16      18.392  30.819  15.011  1.00 23.42           C  
ATOM    132  C   SER    16      17.119  31.665  14.922  1.00 22.61           C  
ATOM    133  O   SER    16      16.086  31.181  14.484  1.00 25.09           O  
ATOM    134  CB  SER    16      18.399  29.975  16.292  1.00 25.81           C  
ATOM    135  OG  SER    16      18.262  30.773  17.454  1.00 29.65           O  
ATOM    136  N   ASN    17      17.209  32.934  15.316  1.00 20.86           N  
ATOM    137  CA  ASN    17      16.055  33.821  15.215  1.00 21.30           C  
ATOM    138  C   ASN    17      16.030  34.653  13.915  1.00 19.81           C  
ATOM    139  O   ASN    17      15.279  35.635  13.809  1.00 22.73           O  
ATOM    140  CB  ASN    17      15.951  34.697  16.480  1.00 20.06           C  
ATOM    141  CG  ASN    17      14.625  35.442  16.589  1.00 20.33           C  
ATOM    142  OD1 ASN    17      14.596  36.674  16.657  1.00 26.71           O  
ATOM    143  ND2 ASN    17      13.524  34.701  16.602  1.00 25.28           N  
ATOM    144  N   PHE    18      16.863  34.266  12.950  1.00 22.83           N  
ATOM    145  CA  PHE    18      17.038  34.993  11.685  1.00 20.77           C  
ATOM    146  C   PHE    18      16.729  34.131  10.466  1.00 26.09           C  
ATOM    147  O   PHE    18      16.856  32.904  10.510  1.00 23.90           O  
ATOM    148  CB  PHE    18      18.489  35.478  11.537  1.00 20.07           C  
ATOM    149  CG  PHE    18      18.897  36.501  12.565  1.00 21.76           C  
ATOM    150  CD1 PHE    18      18.942  37.859  12.237  1.00 24.52           C  
ATOM    151  CD2 PHE    18      19.251  36.104  13.865  1.00 24.38           C  
ATOM    152  CE1 PHE    18      19.316  38.798  13.175  1.00 21.09           C  
ATOM    153  CE2 PHE    18      19.629  37.040  14.816  1.00 27.62           C  
ATOM    154  CZ  PHE    18      19.662  38.396  14.477  1.00 22.52           C  
ATOM    155  N   VAL    19      16.347  34.797   9.371  1.00 23.29           N  
ATOM    156  CA  VAL    19      16.190  34.157   8.064  1.00 23.44           C  
ATOM    157  C   VAL    19      17.116  34.822   7.054  1.00 23.87           C  
ATOM    158  O   VAL    19      17.450  36.007   7.186  1.00 26.05           O  
ATOM    159  CB  VAL    19      14.722  34.166   7.535  1.00 26.11           C  
ATOM    160  CG1 VAL    19      13.813  33.322   8.418  1.00 29.80           C  
ATOM    161  CG2 VAL    19      14.181  35.594   7.420  1.00 26.39           C  
ATOM    162  N   ARG    20      17.533  34.023   6.065  1.00 21.52           N  
ATOM    163  CA  ARG    20      18.422  34.472   4.999  0.50 25.24           C  
ATOM    165  C   ARG    20      17.799  35.611   4.197  1.00 23.67           C  
ATOM    166  O   ARG    20      16.602  35.598   3.885  1.00 26.54           O  
ATOM    167  CB  ARG    20      18.765  33.299   4.066  0.50 26.19           C  
ATOM    169  CG  ARG    20      19.517  32.169   4.752  0.50 32.31           C  
ATOM    171  CD  ARG    20      19.716  30.936   3.868  0.50 37.64           C  
ATOM    173  NE  ARG    20      21.039  30.345   4.075  0.50 32.60           N  
ATOM    175  CZ  ARG    20      21.962  30.231   3.123  0.50 38.95           C  
ATOM    177  NH1 ARG    20      23.143  29.697   3.411  0.50 43.99           N  
ATOM    179  NH2 ARG    20      21.705  30.634   1.880  0.50 28.71           N  
ATOM    181  N   PHE    21      18.612  36.600   3.890  1.00 20.41           N  
ATOM    182  CA  PHE    21      18.195  37.664   2.981  1.00 19.15           C  
ATOM    183  C   PHE    21      18.908  37.400   1.650  1.00 22.86           C  
ATOM    184  O   PHE    21      20.145  37.355   1.582  1.00 21.81           O  
ATOM    185  CB  PHE    21      18.522  39.041   3.558  1.00 21.05           C  
ATOM    186  CG  PHE    21      18.246  40.177   2.615  1.00 24.51           C  
ATOM    187  CD1 PHE    21      17.130  40.161   1.782  1.00 25.06           C  
ATOM    188  CD2 PHE    21      19.075  41.286   2.588  1.00 26.03           C  
ATOM    189  CE1 PHE    21      16.873  41.200   0.908  1.00 32.51           C  
ATOM    190  CE2 PHE    21      18.810  42.341   1.700  1.00 24.87           C  
ATOM    191  CZ  PHE    21      17.706  42.282   0.869  1.00 21.39           C  
ATOM    192  N   VAL    22      18.104  37.221   0.606  1.00 23.08           N  
ATOM    193  CA  VAL    22      18.559  36.692  -0.692  1.00 20.41           C  
ATOM    194  C   VAL    22      18.247  37.636  -1.870  1.00 23.08           C  
ATOM    195  O   VAL    22      17.138  38.165  -1.984  1.00 23.12           O  
ATOM    196  CB  VAL    22      17.935  35.297  -0.938  1.00 20.68           C  
ATOM    197  CG1 VAL    22      18.300  34.736  -2.328  1.00 23.11           C  
ATOM    198  CG2 VAL    22      18.358  34.340   0.161  1.00 27.48           C  
ATOM    199  N   ILE    23      19.243  37.852  -2.723  1.00 24.77           N  
ATOM    200  CA  ILE    23      19.057  38.610  -3.967  1.00 27.98           C  
ATOM    201  C   ILE    23      19.535  37.726  -5.131  1.00 32.10           C  
ATOM    202  O   ILE    23      20.708  37.296  -5.164  1.00 25.66           O  
ATOM    203  CB  ILE    23      19.843  39.955  -3.981  1.00 31.42           C  
ATOM    204  CG1 ILE    23      19.464  40.859  -2.795  1.00 24.84           C  
ATOM    205  CG2 ILE    23      19.614  40.727  -5.293  1.00 31.38           C  
ATOM    206  CD1 ILE    23      20.302  42.150  -2.745  1.00 24.85           C  
ATOM    207  N   GLU    24      18.619  37.471  -6.067  1.00 35.79           N  
ATOM    208  CA  GLU    24      18.867  36.635  -7.256  1.00 40.85           C  
ATOM    209  C   GLU    24      19.596  35.344  -6.899  1.00 38.68           C  
ATOM    210  O   GLU    24      20.621  35.030  -7.497  1.00 39.34           O  
ATOM    211  CB  GLU    24      19.661  37.404  -8.330  1.00 41.46           C  
ATOM    212  CG  GLU    24      19.095  38.765  -8.702  1.00 58.88           C  
ATOM    213  CD  GLU    24      17.908  38.707  -9.655  1.00 71.12           C  
ATOM    214  OE1 GLU    24      17.830  37.743 -10.453  1.00 72.33           O  
ATOM    215  OE2 GLU    24      17.060  39.637  -9.610  1.00 72.59           O  
ATOM    216  N   GLY    25      19.097  34.634  -5.890  1.00 38.63           N  
ATOM    217  CA  GLY    25      19.656  33.332  -5.487  1.00 35.84           C  
ATOM    218  C   GLY    25      20.919  33.370  -4.642  1.00 39.23           C  
ATOM    219  O   GLY    25      21.433  32.320  -4.260  1.00 36.34           O  
ATOM    220  N   ARG    26      21.434  34.570  -4.363  1.00 31.50           N  
ATOM    221  CA  ARG    26      22.645  34.735  -3.546  1.00 31.87           C  
ATOM    222  C   ARG    26      22.285  35.258  -2.152  1.00 27.89           C  
ATOM    223  O   ARG    26      21.606  36.279  -2.051  1.00 25.53           O  
ATOM    224  CB  ARG    26      23.601  35.715  -4.232  1.00 34.35           C  
ATOM    225  CG  ARG    26      24.062  35.266  -5.640  1.00 46.09           C  
ATOM    226  CD  ARG    26      24.650  33.842  -5.609  1.00 67.45           C  
ATOM    227  NE  ARG    26      24.739  33.221  -6.934  1.00 79.26           N  
ATOM    228  CZ  ARG    26      25.765  33.359  -7.774  1.00 81.40           C  
ATOM    229  NH1 ARG    26      26.814  34.109  -7.449  1.00 76.67           N  
ATOM    230  NH2 ARG    26      25.738  32.746  -8.951  1.00 81.53           N  
ATOM    231  N   ARG    27      22.741  34.579  -1.097  1.00 28.09           N  
ATOM    232  CA  ARG    27      22.516  35.067   0.266  1.00 29.86           C  
ATOM    233  C   ARG    27      23.404  36.265   0.561  1.00 27.38           C  
ATOM    234  O   ARG    27      24.632  36.167   0.521  1.00 27.76           O  
ATOM    235  CB  ARG    27      22.714  33.994   1.345  1.00 28.19           C  
ATOM    236  CG  ARG    27      22.185  34.495   2.724  1.00 27.64           C  
ATOM    237  CD  ARG    27      22.737  33.767   3.968  1.00 32.43           C  
ATOM    238  NE  ARG    27      24.189  33.836   4.100  1.00 26.50           N  
ATOM    239  CZ  ARG    27      24.855  34.923   4.495  1.00 32.07           C  
ATOM    240  NH1 ARG    27      24.213  36.047   4.809  1.00 26.92           N  
ATOM    241  NH2 ARG    27      26.169  34.892   4.579  1.00 32.44           N  
ATOM    242  N   VAL    28      22.789  37.414   0.846  1.00 18.52           N  
ATOM    243  CA  VAL    28      23.609  38.605   1.129  1.00 22.68           C  
ATOM    244  C   VAL    28      23.372  39.166   2.544  1.00 22.19           C  
ATOM    245  O   VAL    28      23.990  40.150   2.928  1.00 22.40           O  
ATOM    246  CB  VAL    28      23.365  39.738   0.098  1.00 24.96           C  
ATOM    247  CG1 VAL    28      23.876  39.321  -1.282  1.00 24.70           C  
ATOM    248  CG2 VAL    28      21.873  40.109   0.066  1.00 28.33           C  
ATOM    249  N   GLY    29      22.451  38.565   3.285  1.00 20.83           N  
ATOM    250  CA  GLY    29      22.212  38.997   4.657  1.00 15.98           C  
ATOM    251  C   GLY    29      21.388  38.062   5.499  1.00 19.37           C  
ATOM    252  O   GLY    29      21.164  36.897   5.142  1.00 24.06           O  
ATOM    253  N   TRP    30      20.973  38.584   6.649  1.00 19.03           N  
ATOM    254  CA  TRP    30      20.178  37.855   7.647  1.00 17.42           C  
ATOM    255  C   TRP    30      19.232  38.867   8.246  1.00 20.49           C  
ATOM    256  O   TRP    30      19.659  39.943   8.660  1.00 20.00           O  
ATOM    257  CB  TRP    30      21.042  37.350   8.791  1.00 23.22           C  
ATOM    258  CG  TRP    30      22.128  36.434   8.394  1.00 25.03           C  
ATOM    259  CD1 TRP    30      23.468  36.727   8.254  1.00 27.24           C  
ATOM    260  CD2 TRP    30      21.986  35.054   8.118  1.00 28.67           C  
ATOM    261  NE1 TRP    30      24.156  35.601   7.893  1.00 31.31           N  
ATOM    262  CE2 TRP    30      23.274  34.556   7.803  1.00 28.47           C  
ATOM    263  CE3 TRP    30      20.896  34.186   8.096  1.00 24.83           C  
ATOM    264  CZ2 TRP    30      23.501  33.216   7.473  1.00 36.90           C  
ATOM    265  CZ3 TRP    30      21.118  32.847   7.769  1.00 36.21           C  
ATOM    266  CH2 TRP    30      22.413  32.379   7.460  1.00 31.44           C  
ATOM    267  N   VAL    31      17.957  38.507   8.323  1.00 17.37           N  
ATOM    268  CA  VAL    31      16.909  39.418   8.827  1.00 19.85           C  
ATOM    269  C   VAL    31      16.218  38.708   9.974  1.00 18.71           C  
ATOM    270  O   VAL    31      15.887  37.527   9.863  1.00 18.44           O  
ATOM    271  CB  VAL    31      15.901  39.734   7.689  1.00 24.44           C  
ATOM    272  CG1 VAL    31      14.615  40.380   8.198  1.00 28.37           C  
ATOM    273  CG2 VAL    31      16.560  40.638   6.637  1.00 24.28           C  
ATOM    274  N   ARG    32      16.008  39.417  11.082  1.00 18.35           N  
ATOM    275  CA  ARG    32      15.317  38.839  12.248  1.00 18.09           C  
ATOM    276  C   ARG    32      13.910  38.390  11.843  1.00 20.69           C  
ATOM    277  O   ARG    32      13.289  39.032  11.011  1.00 20.50           O  
ATOM    278  CB  ARG    32      15.253  39.853  13.387  1.00 26.61           C  
ATOM    279  CG  ARG    32      15.330  39.189  14.723  1.00 39.40           C  
ATOM    280  CD  ARG    32      15.433  40.164  15.878  1.00 32.98           C  
ATOM    281  NE  ARG    32      16.788  40.385  16.397  1.00 27.34           N  
ATOM    282  CZ  ARG    32      17.559  39.468  16.999  1.00 31.20           C  
ATOM    283  NH1 ARG    32      17.168  38.216  17.147  1.00 23.24           N  
ATOM    284  NH2 ARG    32      18.758  39.802  17.443  1.00 29.28           N  
ATOM    285  N   LYS    33      13.453  37.255  12.362  1.00 20.44           N  
ATOM    286  CA  LYS    33      12.118  36.739  11.984  1.00 24.51           C  
ATOM    287  C   LYS    33      10.963  37.745  12.142  1.00 23.04           C  
ATOM    288  O   LYS    33      10.120  37.859  11.246  1.00 20.15           O  
ATOM    289  CB  LYS    33      11.813  35.443  12.738  1.00 25.25           C  
ATOM    290  CG  LYS    33      12.553  34.232  12.191  1.00 24.38           C  
ATOM    291  CD  LYS    33      12.538  33.069  13.190  1.00 22.85           C  
ATOM    292  CE  LYS    33      13.393  31.904  12.653  1.00 29.69           C  
ATOM    293  NZ  LYS    33      13.288  30.715  13.555  1.00 33.21           N  
ATOM    294  N   ALA    34      10.908  38.463  13.263  1.00 23.39           N  
ATOM    295  CA  ALA    34       9.837  39.486  13.438  1.00 23.82           C  
ATOM    296  C   ALA    34       9.931  40.608  12.392  1.00 21.06           C  
ATOM    297  O   ALA    34       8.915  41.079  11.869  1.00 23.26           O  
ATOM    298  CB  ALA    34       9.838  40.053  14.861  1.00 24.14           C  
ATOM    299  N   LEU    35      11.150  41.021  12.057  1.00 21.64           N  
ATOM    300  CA  LEU    35      11.318  42.030  11.020  1.00 22.65           C  
ATOM    301  C   LEU    35      10.867  41.492   9.646  1.00 20.58           C  
ATOM    302  O   LEU    35      10.277  42.233   8.860  1.00 21.78           O  
ATOM    303  CB  LEU    35      12.768  42.517  10.957  1.00 18.60           C  
ATOM    304  CG  LEU    35      13.159  43.481   9.832  1.00 21.60           C  
ATOM    305  CD1 LEU    35      12.357  44.782   9.930  1.00 22.31           C  
ATOM    306  CD2 LEU    35      14.625  43.774   9.959  1.00 17.99           C  
ATOM    307  N   ALA    36      11.134  40.209   9.376  1.00 20.53           N  
ATOM    308  CA  ALA    36      10.707  39.572   8.135  1.00 24.82           C  
ATOM    309  C   ALA    36       9.195  39.669   7.995  1.00 25.43           C  
ATOM    310  O   ALA    36       8.695  39.931   6.891  1.00 25.13           O  
ATOM    311  CB  ALA    36      11.176  38.108   8.077  1.00 18.16           C  
ATOM    312  N   GLN    37       8.487  39.531   9.128  1.00 19.18           N  
ATOM    313  CA  GLN    37       7.026  39.711   9.172  1.00 21.96           C  
ATOM    314  C   GLN    37       6.611  41.128   8.806  1.00 24.15           C  
ATOM    315  O   GLN    37       5.595  41.324   8.129  1.00 28.98           O  
ATOM    316  CB  GLN    37       6.450  39.304  10.526  1.00 24.96           C  
ATOM    317  CG  GLN    37       6.470  37.799  10.786  1.00 41.37           C  
ATOM    318  CD  GLN    37       5.780  36.990   9.688  1.00 51.39           C  
ATOM    319  OE1 GLN    37       4.587  37.161   9.429  1.00 45.08           O  
ATOM    320  NE2 GLN    37       6.534  36.104   9.043  1.00 47.83           N  
ATOM    321  N   ARG    38       7.402  42.119   9.220  1.00 23.70           N  
ATOM    322  CA  ARG    38       7.148  43.510   8.841  0.50 22.14           C  
ATOM    324  C   ARG    38       7.373  43.714   7.341  1.00 27.87           C  
ATOM    325  O   ARG    38       6.623  44.433   6.689  1.00 25.76           O  
ATOM    326  CB  ARG    38       8.025  44.495   9.637  0.50 24.12           C  
ATOM    328  CG  ARG    38       7.914  44.432  11.169  0.50 21.02           C  
ATOM    330  CD  ARG    38       6.591  45.017  11.738  0.50 19.70           C  
ATOM    332  NE  ARG    38       5.452  44.110  11.583  0.50 18.95           N  
ATOM    334  CZ  ARG    38       5.293  42.965  12.246  0.50 23.77           C  
ATOM    336  NH1 ARG    38       4.217  42.214  12.017  0.50 28.31           N  
ATOM    338  NH2 ARG    38       6.198  42.563  13.140  0.50 29.77           N  
ATOM    340  N   LEU    39       8.399  43.069   6.804  1.00 27.55           N  
ATOM    341  CA  LEU    39       8.758  43.182   5.394  1.00 26.92           C  
ATOM    342  C   LEU    39       7.715  42.557   4.451  1.00 28.70           C  
ATOM    343  O   LEU    39       7.550  42.940   3.331  1.00 27.28           O  
ATOM    344  CB  LEU    39      10.122  42.556   5.162  1.00 23.52           C  
ATOM    345  CG  LEU    39      11.339  43.205   5.783  1.00 21.20           C  
ATOM    346  CD1 LEU    39      12.583  42.462   5.385  1.00 23.20           C  
ATOM    347  CD2 LEU    39      11.462  44.614   5.429  1.00 23.96           C  
ATOM    348  N   LYS    40       7.035  41.573   4.967  1.00 24.98           N  
ATOM    349  CA  LYS    40       5.956  40.906   4.311  1.00 32.51           C  
ATOM    350  C   LYS    40       4.847  41.820   3.842  1.00 33.88           C  
ATOM    351  O   LYS    40       4.201  41.545   2.891  1.00 34.37           O  
ATOM    352  CB  LYS    40       5.398  39.871   5.265  1.00 35.26           C  
ATOM    353  CG  LYS    40       4.833  38.712   4.620  1.00 42.25           C  
ATOM    354  CD  LYS    40       4.215  37.788   5.581  1.00 47.99           C  
ATOM    355  CE  LYS    40       5.219  36.895   6.146  1.00 56.22           C  
ATOM    356  NZ  LYS    40       4.614  35.738   6.844  1.00 65.56           N  
ATOM    357  N   ALA    41       4.651  42.919   4.534  1.00 33.32           N  
ATOM    358  CA  ALA    41       3.654  43.879   4.166  1.00 26.43           C  
ATOM    359  C   ALA    41       4.055  44.652   2.919  1.00 31.43           C  
ATOM    360  O   ALA    41       3.262  45.313   2.315  1.00 31.38           O  
ATOM    361  CB  ALA    41       3.446  44.781   5.243  1.00 28.22           C  
ATOM    362  N   HIS    42       5.315  44.560   2.560  1.00 22.14           N  
ATOM    363  CA  HIS    42       5.782  45.155   1.354  1.00 22.67           C  
ATOM    364  C   HIS    42       5.977  44.112   0.240  1.00 24.61           C  
ATOM    365  O   HIS    42       7.041  43.935  -0.242  1.00 21.94           O  
ATOM    366  CB  HIS    42       7.064  45.909   1.625  1.00 23.33           C  
ATOM    367  CG  HIS    42       6.906  47.023   2.603  1.00 26.26           C  
ATOM    368  ND1 HIS    42       6.771  48.327   2.211  1.00 28.75           N  
ATOM    369  CD2 HIS    42       6.846  47.032   3.946  1.00 27.23           C  
ATOM    370  CE1 HIS    42       6.650  49.092   3.270  1.00 29.65           C  
ATOM    371  NE2 HIS    42       6.684  48.330   4.335  1.00 22.96           N  
ATOM    372  N   GLY    43       4.902  43.451  -0.118  1.00 21.77           N  
ATOM    373  CA  GLY    43       4.938  42.357  -1.055  1.00 24.76           C  
ATOM    374  C   GLY    43       5.412  42.645  -2.467  1.00 28.20           C  
ATOM    375  O   GLY    43       5.741  41.776  -3.184  1.00 25.79           O  
ATOM    376  N   ARG    44       5.456  43.907  -2.835  1.00 21.72           N  
ATOM    377  CA  ARG    44       5.914  44.304  -4.161  1.00 24.32           C  
ATOM    378  C   ARG    44       7.437  44.361  -4.225  1.00 20.86           C  
ATOM    379  O   ARG    44       8.019  44.447  -5.305  1.00 23.65           O  
ATOM    380  CB  ARG    44       5.321  45.661  -4.548  1.00 22.47           C  
ATOM    381  CG  ARG    44       3.815  45.643  -4.754  1.00 21.53           C  
ATOM    382  CD  ARG    44       3.289  47.028  -5.094  1.00 22.88           C  
ATOM    383  NE  ARG    44       3.817  47.518  -6.364  1.00 23.77           N  
ATOM    384  CZ  ARG    44       3.800  48.793  -6.738  1.00 28.40           C  
ATOM    385  NH1 ARG    44       3.279  49.714  -5.938  1.00 23.25           N  
ATOM    386  NH2 ARG    44       4.303  49.149  -7.912  1.00 22.34           N  
ATOM    387  N   VAL    45       8.075  44.311  -3.060  1.00 16.84           N  
ATOM    388  CA  VAL    45       9.532  44.444  -2.974  1.00 19.47           C  
ATOM    389  C   VAL    45      10.146  43.169  -2.404  1.00 21.56           C  
ATOM    390  O   VAL    45      11.226  42.779  -2.841  1.00 22.98           O  
ATOM    391  CB  VAL    45       9.907  45.652  -2.097  1.00 19.99           C  
ATOM    392  CG1 VAL    45      11.447  45.847  -1.919  1.00 21.44           C  
ATOM    393  CG2 VAL    45       9.247  46.952  -2.669  1.00 21.74           C  
ATOM    394  N   PHE    46       9.484  42.556  -1.421  1.00 23.63           N  
ATOM    395  CA  PHE    46      10.014  41.345  -0.749  1.00 20.04           C  
ATOM    396  C   PHE    46       9.057  40.164  -0.851  1.00 26.86           C  
ATOM    397  O   PHE    46       7.859  40.313  -0.628  1.00 28.56           O  
ATOM    398  CB  PHE    46      10.268  41.631   0.747  1.00 21.13           C  
ATOM    399  CG  PHE    46      11.314  42.678   1.005  1.00 21.58           C  
ATOM    400  CD1 PHE    46      12.673  42.366   0.922  1.00 26.18           C  
ATOM    401  CD2 PHE    46      10.942  43.978   1.337  1.00 23.12           C  
ATOM    402  CE1 PHE    46      13.650  43.337   1.165  1.00 24.11           C  
ATOM    403  CE2 PHE    46      11.889  44.948   1.576  1.00 21.14           C  
ATOM    404  CZ  PHE    46      13.251  44.646   1.504  1.00 17.18           C  
ATOM    405  N   ASP    47       9.590  38.987  -1.178  1.00 20.78           N  
ATOM    406  CA  ASP    47       8.849  37.730  -1.002  1.00 24.46           C  
ATOM    407  C   ASP    47       9.338  37.080   0.284  1.00 26.67           C  
ATOM    408  O   ASP    47      10.537  36.823   0.431  1.00 31.75           O  
ATOM    409  CB  ASP    47       9.107  36.797  -2.180  1.00 32.25           C  
ATOM    410  CG  ASP    47       8.665  37.398  -3.500  1.00 45.29           C  
ATOM    411  OD1 ASP    47       7.537  37.927  -3.556  1.00 49.98           O  
ATOM    412  OD2 ASP    47       9.446  37.343  -4.473  1.00 54.42           O  
ATOM    413  N   VAL    48       8.430  36.834   1.220  1.00 27.58           N  
ATOM    414  CA  VAL    48       8.826  36.313   2.532  1.00 30.03           C  
ATOM    415  C   VAL    48       8.249  34.926   2.741  1.00 33.16           C  
ATOM    416  O   VAL    48       7.034  34.738   2.683  1.00 34.75           O  
ATOM    417  CB  VAL    48       8.411  37.276   3.708  1.00 29.61           C  
ATOM    418  CG1 VAL    48       8.797  36.679   5.070  1.00 29.77           C  
ATOM    419  CG2 VAL    48       9.052  38.643   3.525  1.00 31.49           C  
ATOM    420  N   THR    49       9.133  33.957   2.966  1.00 28.52           N  
ATOM    421  CA  THR    49       8.723  32.591   3.293  1.00 33.79           C  
ATOM    422  C   THR    49       9.204  32.264   4.698  1.00 37.87           C  
ATOM    423  O   THR    49       9.802  33.109   5.366  1.00 34.40           O  
ATOM    424  CB  THR    49       9.305  31.582   2.285  1.00 33.24           C  
ATOM    425  OG1 THR    49      10.733  31.717   2.232  1.00 42.54           O  
ATOM    426  CG2 THR    49       8.726  31.811   0.890  1.00 38.14           C  
ATOM    427  N   ARG    50       8.966  31.031   5.134  1.00 46.46           N  
ATOM    428  CA  ARG    50       9.394  30.554   6.452  1.00 50.39           C  
ATOM    429  C   ARG    50      10.920  30.552   6.612  1.00 42.25           C  
ATOM    430  O   ARG    50      11.437  30.711   7.717  1.00 50.08           O  
ATOM    431  CB  ARG    50       8.833  29.143   6.689  1.00 51.10           C  
ATOM    432  CG  ARG    50       8.908  28.632   8.125  1.00 65.81           C  
ATOM    433  CD  ARG    50       8.648  27.129   8.184  1.00 65.65           C  
ATOM    434  NE  ARG    50       9.511  26.455   9.160  1.00 82.09           N  
ATOM    435  CZ  ARG    50       9.228  26.304  10.454  1.00 86.34           C  
ATOM    436  NH1 ARG    50       8.094  26.778  10.958  1.00 87.28           N  
ATOM    437  NH2 ARG    50      10.086  25.675  11.248  1.00 84.79           N  
ATOM    438  N   ASP    51      11.629  30.389   5.503  1.00 32.87           N  
ATOM    439  CA  ASP    51      13.077  30.235   5.527  1.00 37.90           C  
ATOM    440  C   ASP    51      13.855  31.424   4.946  1.00 33.77           C  
ATOM    441  O   ASP    51      15.081  31.474   5.085  1.00 33.12           O  
ATOM    442  CB  ASP    51      13.488  28.953   4.773  1.00 46.29           C  
ATOM    443  CG  ASP    51      12.793  27.692   5.302  1.00 57.41           C  
ATOM    444  OD1 ASP    51      12.856  27.426   6.522  1.00 66.19           O  
ATOM    445  OD2 ASP    51      12.195  26.956   4.484  1.00 61.45           O  
ATOM    446  N   ALA    52      13.176  32.363   4.277  1.00 29.51           N  
ATOM    447  CA  ALA    52      13.909  33.400   3.549  1.00 31.37           C  
ATOM    448  C   ALA    52      13.112  34.666   3.256  1.00 27.18           C  
ATOM    449  O   ALA    52      11.890  34.637   3.109  1.00 27.33           O  
ATOM    450  CB  ALA    52      14.477  32.834   2.236  1.00 32.40           C  
ATOM    451  N   VAL    53      13.844  35.771   3.191  1.00 24.06           N  
ATOM    452  CA  VAL    53      13.359  37.013   2.627  1.00 23.42           C  
ATOM    453  C   VAL    53      14.046  37.168   1.268  1.00 27.83           C  
ATOM    454  O   VAL    53      15.281  37.291   1.186  1.00 26.26           O  
ATOM    455  CB  VAL    53      13.720  38.216   3.535  1.00 22.71           C  
ATOM    456  CG1 VAL    53      13.313  39.521   2.909  1.00 23.66           C  
ATOM    457  CG2 VAL    53      13.050  38.097   4.878  1.00 24.13           C  
ATOM    458  N   LEU    54      13.253  37.153   0.201  1.00 22.46           N  
ATOM    459  CA  LEU    54      13.779  37.276  -1.151  1.00 22.52           C  
ATOM    460  C   LEU    54      13.415  38.629  -1.732  1.00 22.04           C  
ATOM    461  O   LEU    54      12.262  39.026  -1.688  1.00 23.72           O  
ATOM    462  CB  LEU    54      13.206  36.181  -2.066  1.00 28.23           C  
ATOM    463  CG  LEU    54      14.094  34.965  -2.357  1.00 44.20           C  
ATOM    464  CD1 LEU    54      14.301  34.149  -1.120  1.00 47.96           C  
ATOM    465  CD2 LEU    54      13.496  34.074  -3.455  1.00 42.25           C  
ATOM    466  N   LEU    55      14.402  39.333  -2.262  1.00 20.07           N  
ATOM    467  CA  LEU    55      14.093  40.556  -2.999  1.00 24.13           C  
ATOM    468  C   LEU    55      13.367  40.173  -4.288  1.00 27.55           C  
ATOM    469  O   LEU    55      13.743  39.198  -4.951  1.00 23.84           O  
ATOM    470  CB  LEU    55      15.370  41.320  -3.291  1.00 25.84           C  
ATOM    471  CG  LEU    55      15.168  42.775  -3.660  1.00 25.00           C  
ATOM    472  CD1 LEU    55      14.453  43.534  -2.557  1.00 23.86           C  
ATOM    473  CD2 LEU    55      16.490  43.392  -3.953  1.00 22.17           C  
ATOM    474  N   SER    56      12.313  40.909  -4.621  1.00 26.26           N  
ATOM    475  CA  SER    56      11.503  40.630  -5.822  1.00 29.54           C  
ATOM    476  C   SER    56      12.328  40.562  -7.109  1.00 27.78           C  
ATOM    477  O   SER    56      13.165  41.423  -7.367  1.00 22.69           O  
ATOM    478  CB  SER    56      10.431  41.699  -6.007  1.00 31.72           C  
ATOM    479  OG  SER    56       9.711  41.455  -7.207  1.00 32.81           O  
ATOM    480  N   ALA    57      12.058  39.545  -7.920  1.00 29.77           N  
ATOM    481  CA  ALA    57      12.789  39.319  -9.167  1.00 32.42           C  
ATOM    482  C   ALA    57      12.470  40.390 -10.205  1.00 33.36           C  
ATOM    483  O   ALA    57      13.229  40.569 -11.147  1.00 34.96           O  
ATOM    484  CB  ALA    57      12.509  37.914  -9.725  1.00 36.66           C  
ATOM    485  N   SER    58      11.376  41.128  -9.990  1.00 28.68           N  
ATOM    486  CA  SER    58      11.012  42.274 -10.826  1.00 28.25           C  
ATOM    487  C   SER    58      11.974  43.463 -10.707  1.00 31.71           C  
ATOM    488  O   SER    58      11.977  44.358 -11.557  1.00 31.32           O  
ATOM    489  CB  SER    58       9.565  42.695 -10.543  1.00 34.24           C  
ATOM    490  OG  SER    58       9.420  43.333  -9.284  1.00 35.76           O  
ATOM    491  N   LEU    59      12.787  43.475  -9.653  1.00 24.78           N  
ATOM    492  CA  LEU    59      13.783  44.526  -9.471  1.00 30.63           C  
ATOM    493  C   LEU    59      15.071  44.018 -10.106  1.00 31.92           C  
ATOM    494  O   LEU    59      15.820  43.244  -9.497  1.00 31.98           O  
ATOM    495  CB  LEU    59      13.955  44.871  -7.980  1.00 29.62           C  
ATOM    496  CG  LEU    59      12.714  45.319  -7.215  1.00 25.65           C  
ATOM    497  CD1 LEU    59      12.954  45.256  -5.702  1.00 25.36           C  
ATOM    498  CD2 LEU    59      12.301  46.719  -7.619  1.00 29.09           C  
ATOM    499  N   ARG    60      15.300  44.459 -11.342  1.00 33.21           N  
ATOM    500  CA  ARG    60      16.249  43.826 -12.253  1.00 36.10           C  
ATOM    501  C   ARG    60      17.617  44.474 -12.231  1.00 33.20           C  
ATOM    502  O   ARG    60      18.578  43.881 -12.717  1.00 44.58           O  
ATOM    503  CB  ARG    60      15.712  43.878 -13.696  1.00 39.12           C  
ATOM    504  CG  ARG    60      14.323  43.261 -13.930  1.00 52.12           C  
ATOM    505  CD  ARG    60      14.402  41.782 -14.285  1.00 67.62           C  
ATOM    506  NE  ARG    60      13.334  41.402 -15.212  1.00 85.24           N  
ATOM    507  CZ  ARG    60      12.391  40.490 -14.977  1.00 88.67           C  
ATOM    508  NH1 ARG    60      12.359  39.816 -13.833  1.00 90.37           N  
ATOM    509  NH2 ARG    60      11.478  40.240 -15.906  1.00 88.09           N  
ATOM    510  N   THR    61      17.700  45.706 -11.724  1.00 29.10           N  
ATOM    511  CA  THR    61      18.947  46.463 -11.718  1.00 26.42           C  
ATOM    512  C   THR    61      19.334  46.835 -10.279  1.00 27.29           C  
ATOM    513  O   THR    61      18.456  46.936  -9.417  1.00 22.73           O  
ATOM    514  CB  THR    61      18.868  47.776 -12.543  1.00 29.34           C  
ATOM    515  OG1 THR    61      18.018  48.728 -11.881  1.00 26.60           O  
ATOM    516  CG2 THR    61      18.422  47.539 -13.999  1.00 24.84           C  
ATOM    517  N   PRO    62      20.634  47.044 -10.018  1.00 25.78           N  
ATOM    518  CA  PRO    62      21.002  47.565  -8.694  1.00 22.69           C  
ATOM    519  C   PRO    62      20.253  48.870  -8.342  1.00 29.65           C  
ATOM    520  O   PRO    62      19.791  49.003  -7.207  1.00 24.80           O  
ATOM    521  CB  PRO    62      22.528  47.800  -8.813  1.00 27.82           C  
ATOM    522  CG  PRO    62      22.973  46.819  -9.858  1.00 31.58           C  
ATOM    523  CD  PRO    62      21.829  46.806 -10.863  1.00 27.50           C  
ATOM    524  N   GLN    63      20.076  49.775  -9.315  1.00 24.51           N  
ATOM    525  CA  GLN    63      19.422  51.067  -9.069  1.00 25.29           C  
ATOM    526  C   GLN    63      17.965  50.872  -8.650  1.00 21.95           C  
ATOM    527  O   GLN    63      17.484  51.547  -7.720  1.00 23.61           O  
ATOM    528  CB  GLN    63      19.507  52.002 -10.296  1.00 31.56           C  
ATOM    529  CG  GLN    63      20.910  52.567 -10.603  1.00 41.77           C  
ATOM    530  CD  GLN    63      21.898  51.536 -11.202  1.00 57.34           C  
ATOM    531  OE1 GLN    63      21.501  50.544 -11.848  1.00 32.51           O  
ATOM    532  NE2 GLN    63      23.202  51.774 -10.973  1.00 51.09           N  
ATOM    533  N   SER    64      17.280  49.920  -9.284  1.00 21.83           N  
ATOM    534  CA  SER    64      15.876  49.666  -8.954  1.00 25.03           C  
ATOM    535  C   SER    64      15.750  49.055  -7.554  1.00 24.32           C  
ATOM    536  O   SER    64      14.890  49.460  -6.775  1.00 20.62           O  
ATOM    537  CB  SER    64      15.192  48.792 -10.011  1.00 28.61           C  
ATOM    538  OG  SER    64      15.627  47.452  -9.913  1.00 30.88           O  
ATOM    539  N   ARG    65      16.631  48.109  -7.241  1.00 20.58           N  
ATOM    540  CA  ARG    65      16.695  47.517  -5.897  1.00 21.14           C  
ATOM    541  C   ARG    65      16.955  48.511  -4.773  1.00 21.18           C  
ATOM    542  O   ARG    65      16.253  48.488  -3.756  1.00 19.62           O  
ATOM    543  CB  ARG    65      17.750  46.409  -5.852  1.00 23.32           C  
ATOM    544  CG  ARG    65      17.463  45.270  -6.805  1.00 18.45           C  
ATOM    545  CD  ARG    65      18.665  44.418  -6.897  1.00 23.80           C  
ATOM    546  NE  ARG    65      18.445  43.302  -7.792  1.00 28.23           N  
ATOM    547  CZ  ARG    65      19.393  42.818  -8.571  1.00 39.35           C  
ATOM    548  NH1 ARG    65      20.600  43.365  -8.529  1.00 26.87           N  
ATOM    549  NH2 ARG    65      19.131  41.801  -9.384  1.00 39.24           N  
ATOM    550  N   THR    66      17.976  49.349  -4.961  1.00 18.13           N  
ATOM    551  CA  THR    66      18.367  50.404  -4.029  1.00 18.63           C  
ATOM    552  C   THR    66      17.207  51.354  -3.731  1.00 22.30           C  
ATOM    553  O   THR    66      16.892  51.610  -2.565  1.00 17.93           O  
ATOM    554  CB  THR    66      19.518  51.206  -4.624  1.00 15.67           C  
ATOM    555  OG1 THR    66      20.662  50.330  -4.794  1.00 19.82           O  
ATOM    556  CG2 THR    66      19.902  52.414  -3.716  1.00 22.75           C  
ATOM    557  N   ARG    67      16.562  51.837  -4.791  1.00 21.29           N  
ATOM    558  CA  ARG    67      15.388  52.717  -4.654  1.00 26.02           C  
ATOM    559  C   ARG    67      14.202  52.034  -3.933  1.00 17.62           C  
ATOM    560  O   ARG    67      13.593  52.643  -3.029  1.00 21.68           O  
ATOM    561  CB  ARG    67      15.032  53.252  -6.059  1.00 24.56           C  
ATOM    562  CG  ARG    67      13.700  53.913  -6.270  1.00 35.10           C  
ATOM    563  CD  ARG    67      13.442  54.083  -7.804  1.00 28.40           C  
ATOM    564  NE  ARG    67      14.538  54.784  -8.478  1.00 34.03           N  
ATOM    565  CZ  ARG    67      15.203  54.347  -9.545  1.00 43.18           C  
ATOM    566  NH1 ARG    67      14.900  53.185 -10.139  1.00 42.38           N  
ATOM    567  NH2 ARG    67      16.184  55.099 -10.032  1.00 51.91           N  
ATOM    568  N   ALA    68      13.898  50.784  -4.297  1.00 21.03           N  
ATOM    569  CA  ALA    68      12.785  50.049  -3.702  1.00 16.16           C  
ATOM    570  C   ALA    68      13.012  49.854  -2.200  1.00 20.76           C  
ATOM    571  O   ALA    68      12.143  50.134  -1.392  1.00 20.74           O  
ATOM    572  CB  ALA    68      12.611  48.667  -4.367  1.00 15.55           C  
ATOM    573  N   VAL    69      14.181  49.335  -1.841  1.00 17.62           N  
ATOM    574  CA  VAL    69      14.494  49.098  -0.428  1.00 17.98           C  
ATOM    575  C   VAL    69      14.677  50.379   0.391  1.00 18.80           C  
ATOM    576  O   VAL    69      14.300  50.412   1.572  1.00 21.34           O  
ATOM    577  CB  VAL    69      15.722  48.180  -0.310  1.00 16.22           C  
ATOM    578  CG1 VAL    69      16.157  47.989   1.146  1.00 17.56           C  
ATOM    579  CG2 VAL    69      15.351  46.828  -0.894  1.00 15.21           C  
ATOM    580  N   ALA    70      15.217  51.420  -0.231  1.00 16.22           N  
ATOM    581  CA  ALA    70      15.393  52.699   0.447  1.00 18.41           C  
ATOM    582  C   ALA    70      14.053  53.236   0.933  1.00 23.35           C  
ATOM    583  O   ALA    70      13.960  53.719   2.057  1.00 20.90           O  
ATOM    584  CB  ALA    70      16.106  53.706  -0.414  1.00 20.53           C  
ATOM    585  N   ASP    71      13.029  53.113   0.093  1.00 19.14           N  
ATOM    586  CA  ASP    71      11.661  53.564   0.421  1.00 22.77           C  
ATOM    587  C   ASP    71      11.066  52.725   1.566  1.00 22.49           C  
ATOM    588  O   ASP    71      10.469  53.270   2.493  1.00 18.09           O  
ATOM    589  CB  ASP    71      10.774  53.529  -0.847  1.00 16.87           C  
ATOM    590  CG  ASP    71       9.287  53.667  -0.537  1.00 22.63           C  
ATOM    591  OD1 ASP    71       8.899  54.604   0.199  1.00 23.94           O  
ATOM    592  OD2 ASP    71       8.512  52.807  -0.986  1.00 23.44           O  
ATOM    593  N   VAL    72      11.256  51.403   1.515  1.00 19.22           N  
ATOM    594  CA  VAL    72      10.769  50.516   2.571  1.00 20.05           C  
ATOM    595  C   VAL    72      11.420  50.874   3.922  1.00 19.36           C  
ATOM    596  O   VAL    72      10.726  51.017   4.927  1.00 19.01           O  
ATOM    597  CB  VAL    72      11.034  49.025   2.216  1.00 20.04           C  
ATOM    598  CG1 VAL    72      10.739  48.072   3.440  1.00 24.21           C  
ATOM    599  CG2 VAL    72      10.201  48.614   1.010  1.00 22.38           C  
ATOM    600  N   VAL    73      12.743  51.023   3.908  1.00 17.33           N  
ATOM    601  CA  VAL    73      13.536  51.443   5.070  1.00 20.26           C  
ATOM    602  C   VAL    73      13.027  52.774   5.630  1.00 22.10           C  
ATOM    603  O   VAL    73      12.812  52.861   6.840  1.00 17.86           O  
ATOM    604  CB  VAL    73      15.051  51.490   4.716  1.00 21.15           C  
ATOM    605  CG1 VAL    73      15.854  52.320   5.724  1.00 22.24           C  
ATOM    606  CG2 VAL    73      15.574  50.041   4.613  1.00 20.63           C  
ATOM    607  N   ASP    74      12.790  53.755   4.746  1.00 20.58           N  
ATOM    608  CA  ASP    74      12.251  55.063   5.119  1.00 18.28           C  
ATOM    609  C   ASP    74      11.020  54.878   5.970  1.00 20.19           C  
ATOM    610  O   ASP    74      10.914  55.452   7.042  1.00 21.19           O  
ATOM    611  CB  ASP    74      11.869  55.914   3.896  1.00 19.53           C  
ATOM    612  CG  ASP    74      13.056  56.564   3.220  1.00 31.44           C  
ATOM    613  OD1 ASP    74      14.149  56.596   3.817  1.00 30.23           O  
ATOM    614  OD2 ASP    74      12.889  57.055   2.076  1.00 33.16           O  
ATOM    615  N   ARG    75      10.109  54.037   5.496  1.00 19.10           N  
ATOM    616  CA  ARG    75       8.804  53.931   6.138  1.00 21.32           C  
ATOM    617  C   ARG    75       8.854  53.063   7.393  1.00 21.32           C  
ATOM    618  O   ARG    75       8.255  53.401   8.398  1.00 17.97           O  
ATOM    619  CB  ARG    75       7.755  53.513   5.125  1.00 19.91           C  
ATOM    620  CG  ARG    75       7.548  54.674   4.110  1.00 20.27           C  
ATOM    621  CD  ARG    75       6.359  54.402   3.225  1.00 22.86           C  
ATOM    622  NE  ARG    75       6.733  53.521   2.129  1.00 25.46           N  
ATOM    623  CZ  ARG    75       6.126  52.384   1.815  1.00 27.49           C  
ATOM    624  NH1 ARG    75       5.079  51.963   2.505  1.00 25.53           N  
ATOM    625  NH2 ARG    75       6.553  51.690   0.767  1.00 23.23           N  
ATOM    626  N   LEU    76       9.635  51.995   7.363  1.00 20.28           N  
ATOM    627  CA  LEU    76       9.884  51.208   8.580  1.00 18.24           C  
ATOM    628  C   LEU    76      10.543  52.045   9.684  1.00 17.75           C  
ATOM    629  O   LEU    76      10.208  51.893  10.865  1.00 18.96           O  
ATOM    630  CB  LEU    76      10.747  49.987   8.241  1.00 18.67           C  
ATOM    631  CG  LEU    76      10.044  48.840   7.491  1.00 24.03           C  
ATOM    632  CD1 LEU    76      11.029  47.720   7.214  1.00 24.96           C  
ATOM    633  CD2 LEU    76       8.841  48.331   8.274  1.00 27.30           C  
ATOM    634  N   ALA    77      11.474  52.925   9.310  1.00 16.73           N  
ATOM    635  CA  ALA    77      12.117  53.812  10.286  1.00 21.15           C  
ATOM    636  C   ALA    77      11.117  54.843  10.818  1.00 22.18           C  
ATOM    637  O   ALA    77      11.066  55.100  12.027  1.00 19.61           O  
ATOM    638  CB  ALA    77      13.325  54.466   9.693  1.00 17.59           C  
ATOM    639  N   ASP    78      10.291  55.395   9.931  1.00 20.66           N  
ATOM    640  CA  ASP    78       9.179  56.292  10.347  1.00 19.06           C  
ATOM    641  C   ASP    78       8.312  55.602  11.411  1.00 18.85           C  
ATOM    642  O   ASP    78       7.870  56.240  12.365  1.00 22.08           O  
ATOM    643  CB  ASP    78       8.266  56.625   9.159  1.00 23.91           C  
ATOM    644  CG  ASP    78       8.888  57.584   8.160  1.00 19.56           C  
ATOM    645  OD1 ASP    78       9.904  58.282   8.455  1.00 22.27           O  
ATOM    646  OD2 ASP    78       8.328  57.646   7.032  1.00 23.65           O  
ATOM    647  N   GLU    79       8.110  54.294  11.256  1.00 19.40           N  
ATOM    648  CA  GLU    79       7.257  53.515  12.140  1.00 18.58           C  
ATOM    649  C   GLU    79       7.984  53.003  13.407  1.00 19.38           C  
ATOM    650  O   GLU    79       7.387  52.305  14.226  1.00 23.70           O  
ATOM    651  CB  GLU    79       6.646  52.344  11.361  1.00 20.27           C  
ATOM    652  CG  GLU    79       5.647  52.804  10.265  1.00 22.77           C  
ATOM    653  CD  GLU    79       5.568  51.905   9.043  1.00 30.88           C  
ATOM    654  OE1 GLU    79       6.058  50.756   9.116  1.00 25.70           O  
ATOM    655  OE2 GLU    79       5.018  52.361   7.992  1.00 25.40           O  
ATOM    656  N   GLY    80       9.262  53.354  13.564  1.00 17.12           N  
ATOM    657  CA  GLY    80      10.044  52.909  14.737  1.00 17.37           C  
ATOM    658  C   GLY    80      10.604  51.500  14.654  1.00 21.05           C  
ATOM    659  O   GLY    80      11.103  50.971  15.658  1.00 22.12           O  
ATOM    660  N   VAL    81      10.558  50.887  13.467  1.00 19.14           N  
ATOM    661  CA  VAL    81      10.930  49.474  13.314  1.00 20.51           C  
ATOM    662  C   VAL    81      12.445  49.248  13.111  1.00 20.06           C  
ATOM    663  O   VAL    81      13.037  48.268  13.647  1.00 17.76           O  
ATOM    664  CB  VAL    81      10.120  48.806  12.186  1.00 25.27           C  
ATOM    665  CG1 VAL    81      10.474  47.322  12.042  1.00 22.76           C  
ATOM    666  CG2 VAL    81       8.654  48.971  12.458  1.00 20.85           C  
ATOM    667  N   VAL    82      13.073  50.146  12.346  1.00 18.25           N  
ATOM    668  CA  VAL    82      14.499  50.035  12.016  1.00 16.89           C  
ATOM    669  C   VAL    82      15.127  51.393  12.281  1.00 16.23           C  
ATOM    670  O   VAL    82      14.387  52.399  12.357  1.00 19.06           O  
ATOM    671  CB  VAL    82      14.720  49.615  10.509  1.00 18.42           C  
ATOM    672  CG1 VAL    82      13.994  48.315  10.210  1.00 16.44           C  
ATOM    673  CG2 VAL    82      14.267  50.713   9.547  1.00 21.23           C  
ATOM    674  N   PRO    83      16.467  51.445  12.420  1.00 19.03           N  
ATOM    675  CA  PRO    83      17.159  52.709  12.574  1.00 16.16           C  
ATOM    676  C   PRO    83      16.935  53.643  11.408  1.00 19.13           C  
ATOM    677  O   PRO    83      16.727  53.205  10.281  1.00 19.03           O  
ATOM    678  CB  PRO    83      18.633  52.274  12.648  1.00 14.32           C  
ATOM    679  CG  PRO    83      18.580  50.895  13.208  1.00 19.67           C  
ATOM    680  CD  PRO    83      17.423  50.315  12.495  1.00 18.96           C  
ATOM    681  N   ALA    84      16.964  54.937  11.681  1.00 19.88           N  
ATOM    682  CA  ALA    84      16.800  55.923  10.623  1.00 19.34           C  
ATOM    683  C   ALA    84      18.026  55.982   9.719  1.00 17.45           C  
ATOM    684  O   ALA    84      19.150  56.024  10.202  1.00 19.89           O  
ATOM    685  CB  ALA    84      16.552  57.280  11.219  1.00 23.23           C  
ATOM    686  N   PRO    85      17.805  55.997   8.393  1.00 20.18           N  
ATOM    687  CA  PRO    85      18.928  56.220   7.463  1.00 23.79           C  
ATOM    688  C   PRO    85      19.585  57.578   7.699  1.00 26.63           C  
ATOM    689  O   PRO    85      18.905  58.550   8.050  1.00 22.39           O  
ATOM    690  CB  PRO    85      18.282  56.124   6.071  1.00 28.43           C  
ATOM    691  CG  PRO    85      16.819  56.059   6.290  1.00 31.93           C  
ATOM    692  CD  PRO    85      16.530  55.736   7.715  1.00 23.72           C  
ATOM    693  N   ARG    86      20.904  57.637   7.571  1.00 21.40           N  
ATOM    694  CA  ARG    86      21.638  58.873   7.856  1.00 25.10           C  
ATOM    695  C   ARG    86      22.387  59.424   6.647  1.00 26.58           C  
ATOM    696  O   ARG    86      23.023  60.469   6.752  1.00 28.84           O  
ATOM    697  CB  ARG    86      22.602  58.662   9.042  1.00 25.49           C  
ATOM    698  CG  ARG    86      21.896  58.067  10.263  1.00 30.08           C  
ATOM    699  CD  ARG    86      22.607  58.369  11.562  1.00 31.92           C  
ATOM    700  NE  ARG    86      22.427  59.762  11.944  1.00 40.56           N  
ATOM    701  CZ  ARG    86      21.426  60.221  12.691  1.00 33.94           C  
ATOM    702  NH1 ARG    86      21.371  61.511  12.968  1.00 31.03           N  
ATOM    703  NH2 ARG    86      20.491  59.408  13.175  1.00 24.20           N  
ATOM    704  N   GLY    87      22.335  58.715   5.514  1.00 25.39           N  
ATOM    705  CA  GLY    87      22.831  59.252   4.250  1.00 24.83           C  
ATOM    706  C   GLY    87      24.088  58.667   3.650  1.00 25.87           C  
ATOM    707  O   GLY    87      24.394  58.938   2.496  1.00 27.78           O  
ATOM    708  N   GLU    88      24.826  57.861   4.409  1.00 22.13           N  
ATOM    709  CA  GLU    88      25.998  57.160   3.861  1.00 22.36           C  
ATOM    710  C   GLU    88      25.582  55.816   3.295  1.00 23.51           C  
ATOM    711  O   GLU    88      25.054  54.989   4.020  1.00 19.80           O  
ATOM    712  CB  GLU    88      27.074  56.962   4.933  1.00 21.74           C  
ATOM    713  CG  GLU    88      28.275  56.190   4.365  1.00 22.96           C  
ATOM    714  CD  GLU    88      29.489  56.189   5.269  1.00 29.30           C  
ATOM    715  OE1 GLU    88      29.367  56.503   6.472  1.00 33.52           O  
ATOM    716  OE2 GLU    88      30.570  55.860   4.759  1.00 24.96           O  
ATOM    717  N   LEU    89      25.810  55.583   2.004  1.00 20.88           N  
ATOM    718  CA  LEU    89      25.365  54.333   1.387  1.00 21.09           C  
ATOM    719  C   LEU    89      26.512  53.320   1.330  1.00 18.78           C  
ATOM    720  O   LEU    89      27.654  53.675   1.020  1.00 23.48           O  
ATOM    721  CB  LEU    89      24.801  54.587  -0.030  1.00 24.83           C  
ATOM    722  CG  LEU    89      23.590  55.510  -0.163  1.00 24.17           C  
ATOM    723  CD1 LEU    89      23.159  55.634  -1.627  1.00 26.09           C  
ATOM    724  CD2 LEU    89      22.440  55.047   0.719  1.00 26.85           C  
ATOM    725  N   TYR    90      26.193  52.062   1.617  1.00 16.23           N  
ATOM    726  CA  TYR    90      27.161  50.972   1.554  1.00 16.87           C  
ATOM    727  C   TYR    90      26.790  50.018   0.421  1.00 21.89           C  
ATOM    728  O   TYR    90      25.612  49.841   0.095  1.00 21.37           O  
ATOM    729  CB  TYR    90      27.108  50.166   2.857  1.00 19.18           C  
ATOM    730  CG  TYR    90      27.980  50.636   4.014  1.00 19.39           C  
ATOM    731  CD1 TYR    90      28.586  51.896   4.022  1.00 22.76           C  
ATOM    732  CD2 TYR    90      28.157  49.810   5.129  1.00 17.63           C  
ATOM    733  CE1 TYR    90      29.384  52.298   5.104  1.00 23.15           C  
ATOM    734  CE2 TYR    90      28.930  50.204   6.222  1.00 16.30           C  
ATOM    735  CZ  TYR    90      29.555  51.449   6.190  1.00 20.05           C  
ATOM    736  OH  TYR    90      30.322  51.863   7.267  1.00 20.00           O  
ATOM    737  N   ARG    91      27.794  49.363  -0.136  1.00 20.63           N  
ATOM    738  CA  ARG    91      27.555  48.370  -1.175  1.00 19.85           C  
ATOM    739  C   ARG    91      27.051  47.062  -0.576  1.00 20.29           C  
ATOM    740  O   ARG    91      27.473  46.654   0.518  1.00 19.32           O  
ATOM    741  CB  ARG    91      28.840  48.157  -2.011  1.00 19.59           C  
ATOM    742  CG  ARG    91      29.881  47.303  -1.337  1.00 26.33           C  
ATOM    743  CD  ARG    91      31.225  47.506  -1.966  1.00 24.05           C  
ATOM    744  NE  ARG    91      31.794  48.821  -1.681  1.00 21.42           N  
ATOM    745  CZ  ARG    91      32.772  49.356  -2.401  1.00 28.61           C  
ATOM    746  NH1 ARG    91      33.284  48.673  -3.417  1.00 23.53           N  
ATOM    747  NH2 ARG    91      33.260  50.541  -2.095  1.00 22.18           N  
ATOM    748  N   VAL    92      26.123  46.418  -1.279  1.00 18.57           N  
ATOM    749  CA  VAL    92      25.629  45.105  -0.875  1.00 16.93           C  
ATOM    750  C   VAL    92      26.147  44.058  -1.867  1.00 21.31           C  
ATOM    751  O   VAL    92      25.839  44.127  -3.082  1.00 19.91           O  
ATOM    752  CB  VAL    92      24.077  45.066  -0.843  1.00 19.63           C  
ATOM    753  CG1 VAL    92      23.561  43.626  -0.553  1.00 18.79           C  
ATOM    754  CG2 VAL    92      23.540  46.091   0.161  1.00 19.26           C  
ATOM    755  N   ASN    93      26.930  43.104  -1.352  1.00 18.20           N  
ATOM    756  CA  ASN    93      27.505  42.038  -2.178  1.00 21.74           C  
ATOM    757  C   ASN    93      27.698  40.762  -1.358  1.00 24.96           C  
ATOM    758  O   ASN    93      27.499  40.746  -0.136  1.00 22.57           O  
ATOM    759  CB  ASN    93      28.859  42.491  -2.788  1.00 18.95           C  
ATOM    760  CG  ASN    93      29.874  42.903  -1.719  1.00 18.59           C  
ATOM    761  OD1 ASN    93      29.937  42.301  -0.661  1.00 24.48           O  
ATOM    762  ND2 ASN    93      30.678  43.942  -2.005  1.00 22.24           N  
ATOM    763  N   GLN    94      28.152  39.704  -2.018  1.00 26.36           N  
ATOM    764  CA  GLN    94      28.433  38.446  -1.340  1.00 26.49           C  
ATOM    765  C   GLN    94      29.823  38.381  -0.751  1.00 30.49           C  
ATOM    766  O   GLN    94      30.080  37.583   0.146  1.00 36.86           O  
ATOM    767  CB  GLN    94      28.266  37.286  -2.304  1.00 37.10           C  
ATOM    768  CG  GLN    94      26.932  36.636  -2.224  1.00 37.93           C  
ATOM    769  CD  GLN    94      26.869  35.435  -3.124  1.00 49.22           C  
ATOM    770  OE1 GLN    94      27.271  35.502  -4.289  1.00 48.89           O  
ATOM    771  NE2 GLN    94      26.362  34.325  -2.598  1.00 50.15           N  
ATOM    772  N   SER    95      30.722  39.175  -1.320  1.00 27.55           N  
ATOM    773  CA  SER    95      32.069  39.392  -0.824  1.00 28.80           C  
ATOM    774  C   SER    95      32.682  40.521  -1.622  1.00 22.53           C  
ATOM    775  O   SER    95      32.128  40.970  -2.634  1.00 27.82           O  
ATOM    776  CB  SER    95      32.951  38.132  -0.907  1.00 35.68           C  
ATOM    777  OG  SER    95      32.898  37.568  -2.200  1.00 45.01           O  
ATOM    778  N   TRP    96      33.826  40.973  -1.150  1.00 24.95           N  
ATOM    779  CA  TRP    96      34.436  42.202  -1.609  1.00 25.45           C  
ATOM    780  C   TRP    96      34.681  42.248  -3.134  1.00 31.67           C  
ATOM    781  O   TRP    96      34.439  43.261  -3.783  1.00 27.35           O  
ATOM    782  CB  TRP    96      35.741  42.422  -0.848  1.00 22.30           C  
ATOM    783  CG  TRP    96      36.462  43.612  -1.369  1.00 24.98           C  
ATOM    784  CD1 TRP    96      37.632  43.618  -2.096  1.00 26.49           C  
ATOM    785  CD2 TRP    96      36.055  44.983  -1.250  1.00 26.86           C  
ATOM    786  NE1 TRP    96      37.962  44.903  -2.437  1.00 27.97           N  
ATOM    787  CE2 TRP    96      37.019  45.764  -1.932  1.00 21.43           C  
ATOM    788  CE3 TRP    96      34.974  45.630  -0.629  1.00 26.25           C  
ATOM    789  CZ2 TRP    96      36.931  47.158  -2.015  1.00 27.21           C  
ATOM    790  CZ3 TRP    96      34.891  47.010  -0.708  1.00 24.31           C  
ATOM    791  CH2 TRP    96      35.870  47.765  -1.392  1.00 26.46           C  
ATOM    792  N   GLY    97      35.167  41.155  -3.704  1.00 34.73           N  
ATOM    793  CA  GLY    97      35.381  41.134  -5.170  1.00 43.04           C  
ATOM    794  C   GLY    97      34.138  41.139  -6.057  1.00 39.97           C  
ATOM    795  O   GLY    97      34.185  41.591  -7.209  1.00 39.72           O  
ATOM    796  N   GLU    98      33.033  40.651  -5.503  1.00 32.97           N  
ATOM    797  CA  GLU    98      31.804  40.317  -6.230  1.00 27.55           C  
ATOM    798  C   GLU    98      31.010  41.563  -6.666  1.00 28.91           C  
ATOM    799  O   GLU    98      31.254  42.659  -6.156  1.00 28.40           O  
ATOM    800  CB  GLU    98      30.957  39.401  -5.344  1.00 31.83           C  
ATOM    801  CG  GLU    98      31.496  37.987  -5.178  1.00 44.11           C  
ATOM    802  CD  GLU    98      31.337  37.164  -6.427  1.00 58.39           C  
ATOM    803  OE1 GLU    98      32.363  36.906  -7.087  1.00 64.85           O  
ATOM    804  OE2 GLU    98      30.189  36.793  -6.761  1.00 62.34           O  
ATOM    805  N   PRO    99      30.088  41.417  -7.650  1.00 29.23           N  
ATOM    806  CA  PRO    99      29.327  42.602  -8.113  1.00 31.34           C  
ATOM    807  C   PRO    99      28.456  43.270  -7.032  1.00 22.94           C  
ATOM    808  O   PRO    99      27.910  42.597  -6.172  1.00 22.94           O  
ATOM    809  CB  PRO    99      28.421  42.028  -9.225  1.00 30.62           C  
ATOM    810  CG  PRO    99      29.121  40.763  -9.672  1.00 34.18           C  
ATOM    811  CD  PRO    99      29.736  40.207  -8.431  1.00 34.24           C  
ATOM    812  N   THR   100      28.385  44.577  -7.048  1.00 21.61           N  
ATOM    813  CA  THR   100      27.472  45.266  -6.184  1.00 22.07           C  
ATOM    814  C   THR   100      26.055  45.017  -6.668  1.00 23.86           C  
ATOM    815  O   THR   100      25.724  45.353  -7.758  1.00 27.37           O  
ATOM    816  CB  THR   100      27.794  46.753  -6.127  1.00 25.42           C  
ATOM    817  OG1 THR   100      29.070  46.950  -5.547  1.00 25.25           O  
ATOM    818  CG2 THR   100      26.768  47.493  -5.390  1.00 21.58           C  
ATOM    819  N   LEU   101      25.252  44.413  -5.827  1.00 22.26           N  
ATOM    820  CA  LEU   101      23.902  44.054  -6.147  1.00 22.54           C  
ATOM    821  C   LEU   101      22.868  45.162  -5.909  1.00 26.84           C  
ATOM    822  O   LEU   101      21.835  45.169  -6.511  1.00 22.64           O  
ATOM    823  CB  LEU   101      23.512  42.785  -5.421  1.00 23.42           C  
ATOM    824  CG  LEU   101      24.336  41.556  -5.780  1.00 23.60           C  
ATOM    825  CD1 LEU   101      24.021  40.422  -4.914  1.00 24.49           C  
ATOM    826  CD2 LEU   101      24.104  41.185  -7.208  1.00 23.72           C  
ATOM    827  N   MET   102      23.182  46.045  -4.985  1.00 22.55           N  
ATOM    828  CA  MET   102      22.371  47.178  -4.624  1.00 21.19           C  
ATOM    829  C   MET   102      23.150  47.968  -3.581  1.00 23.28           C  
ATOM    830  O   MET   102      24.171  47.532  -3.145  1.00 19.55           O  
ATOM    831  CB  MET   102      21.053  46.709  -4.017  1.00 19.31           C  
ATOM    832  CG  MET   102      21.164  45.928  -2.733  1.00 21.18           C  
ATOM    833  SD  MET   102      19.405  45.525  -1.916  0.70 23.50          SE  
ATOM    834  CE  MET   102      19.035  47.338  -1.459  1.00 18.91           C  
ATOM    835  N   LEU   103      22.596  49.100  -3.191  1.00 18.82           N  
ATOM    836  CA  LEU   103      23.106  49.922  -2.110  1.00 19.48           C  
ATOM    837  C   LEU   103      22.134  50.000  -0.941  1.00 20.90           C  
ATOM    838  O   LEU   103      20.948  49.907  -1.109  1.00 20.47           O  
ATOM    839  CB  LEU   103      23.457  51.333  -2.574  1.00 19.25           C  
ATOM    840  CG  LEU   103      24.264  51.497  -3.846  1.00 25.37           C  
ATOM    841  CD1 LEU   103      24.555  52.930  -4.178  1.00 22.48           C  
ATOM    842  CD2 LEU   103      25.523  50.763  -3.726  1.00 16.64           C  
ATOM    843  N   LEU   104      22.687  50.192   0.242  1.00 19.74           N  
ATOM    844  CA  LEU   104      21.923  50.226   1.458  1.00 21.14           C  
ATOM    845  C   LEU   104      22.505  51.224   2.435  1.00 24.21           C  
ATOM    846  O   LEU   104      23.680  51.307   2.604  1.00 20.89           O  
ATOM    847  CB  LEU   104      21.901  48.860   2.084  1.00 23.77           C  
ATOM    848  CG  LEU   104      20.943  48.484   3.187  1.00 22.11           C  
ATOM    849  CD1 LEU   104      19.549  48.698   2.787  1.00 21.93           C  
ATOM    850  CD2 LEU   104      21.194  47.061   3.593  1.00 18.00           C  
ATOM    851  N   ASP   105      21.646  52.004   3.040  1.00 23.13           N  
ATOM    852  CA  ASP   105      22.136  52.996   3.987  1.00 19.41           C  
ATOM    853  C   ASP   105      22.867  52.277   5.131  1.00 15.14           C  
ATOM    854  O   ASP   105      22.375  51.291   5.654  1.00 18.33           O  
ATOM    855  CB  ASP   105      20.977  53.801   4.552  1.00 20.99           C  
ATOM    856  CG  ASP   105      21.447  55.029   5.285  1.00 20.36           C  
ATOM    857  OD1 ASP   105      21.842  54.928   6.470  1.00 21.30           O  
ATOM    858  OD2 ASP   105      21.476  56.107   4.673  1.00 21.56           O  
ATOM    859  N   ARG   106      24.040  52.796   5.477  1.00 21.02           N  
ATOM    860  CA  ARG   106      24.899  52.258   6.546  1.00 18.68           C  
ATOM    861  C   ARG   106      24.099  51.988   7.824  1.00 22.99           C  
ATOM    862  O   ARG   106      24.278  50.952   8.482  1.00 19.07           O  
ATOM    863  CB  ARG   106      26.026  53.245   6.801  1.00 20.67           C  
ATOM    864  CG  ARG   106      26.860  52.965   8.042  1.00 26.03           C  
ATOM    865  CD  ARG   106      27.944  54.002   8.188  1.00 21.79           C  
ATOM    866  NE  ARG   106      28.772  53.685   9.350  1.00 28.51           N  
ATOM    867  CZ  ARG   106      29.995  54.161   9.567  1.00 36.58           C  
ATOM    868  NH1 ARG   106      30.556  55.013   8.713  1.00 24.41           N  
ATOM    869  NH2 ARG   106      30.663  53.784  10.651  1.00 37.44           N  
ATOM    870  N   ALA   107      23.138  52.862   8.127  1.00 16.60           N  
ATOM    871  CA  ALA   107      22.420  52.758   9.398  1.00 22.69           C  
ATOM    872  C   ALA   107      21.586  51.489   9.530  1.00 19.03           C  
ATOM    873  O   ALA   107      21.297  51.057  10.637  1.00 21.36           O  
ATOM    874  CB  ALA   107      21.549  53.986   9.636  1.00 23.29           C  
ATOM    875  N   VAL   108      21.235  50.881   8.402  1.00 17.20           N  
ATOM    876  CA  VAL   108      20.418  49.676   8.404  1.00 17.43           C  
ATOM    877  C   VAL   108      21.193  48.455   7.914  1.00 21.77           C  
ATOM    878  O   VAL   108      20.631  47.379   7.750  1.00 19.19           O  
ATOM    879  CB  VAL   108      19.055  49.853   7.627  1.00 21.96           C  
ATOM    880  CG1 VAL   108      18.186  50.936   8.289  1.00 20.29           C  
ATOM    881  CG2 VAL   108      19.268  50.173   6.131  1.00 19.03           C  
ATOM    882  N   VAL   109      22.492  48.618   7.699  1.00 19.07           N  
ATOM    883  CA  VAL   109      23.306  47.473   7.234  1.00 17.15           C  
ATOM    884  C   VAL   109      23.208  46.292   8.255  1.00 15.02           C  
ATOM    885  O   VAL   109      22.810  45.158   7.867  1.00 17.93           O  
ATOM    886  CB  VAL   109      24.732  47.951   6.781  1.00 19.33           C  
ATOM    887  CG1 VAL   109      25.788  46.856   6.910  1.00 17.69           C  
ATOM    888  CG2 VAL   109      24.659  48.517   5.317  1.00 18.99           C  
ATOM    889  N   PRO   110      23.436  46.541   9.582  1.00 17.55           N  
ATOM    890  CA  PRO   110      23.209  45.433  10.540  1.00 18.17           C  
ATOM    891  C   PRO   110      21.767  44.902  10.631  1.00 17.33           C  
ATOM    892  O   PRO   110      21.566  43.727  10.878  1.00 18.00           O  
ATOM    893  CB  PRO   110      23.693  46.011  11.877  1.00 18.05           C  
ATOM    894  CG  PRO   110      24.670  47.112  11.485  1.00 20.81           C  
ATOM    895  CD  PRO   110      23.988  47.725  10.264  1.00 16.19           C  
ATOM    896  N   THR   111      20.779  45.761  10.386  1.00 17.33           N  
ATOM    897  CA  THR   111      19.362  45.360  10.360  1.00 18.97           C  
ATOM    898  C   THR   111      19.067  44.300   9.285  1.00 19.99           C  
ATOM    899  O   THR   111      18.183  43.453   9.462  1.00 20.53           O  
ATOM    900  CB  THR   111      18.509  46.609  10.107  1.00 21.00           C  
ATOM    901  OG1 THR   111      18.776  47.555  11.154  1.00 23.41           O  
ATOM    902  CG2 THR   111      17.008  46.263  10.007  1.00 17.86           C  
ATOM    903  N   PHE   112      19.787  44.369   8.160  1.00 16.89           N  
ATOM    904  CA  PHE   112      19.636  43.371   7.109  1.00 17.37           C  
ATOM    905  C   PHE   112      20.737  42.314   7.152  1.00 18.91           C  
ATOM    906  O   PHE   112      20.770  41.443   6.284  1.00 19.04           O  
ATOM    907  CB  PHE   112      19.554  44.029   5.725  1.00 21.08           C  
ATOM    908  CG  PHE   112      18.251  44.732   5.507  1.00 21.38           C  
ATOM    909  CD1 PHE   112      17.161  44.054   4.924  1.00 21.83           C  
ATOM    910  CD2 PHE   112      18.069  46.030   5.976  1.00 21.21           C  
ATOM    911  CE1 PHE   112      15.922  44.701   4.770  1.00 23.45           C  
ATOM    912  CE2 PHE   112      16.824  46.676   5.822  1.00 26.65           C  
ATOM    913  CZ  PHE   112      15.772  46.010   5.224  1.00 23.26           C  
ATOM    914  N   GLY   113      21.619  42.408   8.160  1.00 17.00           N  
ATOM    915  CA  GLY   113      22.760  41.450   8.343  1.00 19.86           C  
ATOM    916  C   GLY   113      23.708  41.372   7.156  1.00 19.08           C  
ATOM    917  O   GLY   113      24.320  40.316   6.875  1.00 17.65           O  
ATOM    918  N   VAL   114      23.822  42.488   6.453  1.00 16.66           N  
ATOM    919  CA  VAL   114      24.617  42.622   5.241  1.00 20.98           C  
ATOM    920  C   VAL   114      26.109  42.813   5.587  1.00 14.90           C  
ATOM    921  O   VAL   114      26.453  43.461   6.583  1.00 17.95           O  
ATOM    922  CB  VAL   114      24.061  43.812   4.391  1.00 22.54           C  
ATOM    923  CG1 VAL   114      25.108  44.402   3.471  1.00 26.90           C  
ATOM    924  CG2 VAL   114      22.800  43.348   3.641  1.00 20.80           C  
ATOM    925  N   ARG   115      26.992  42.207   4.798  1.00 18.90           N  
ATOM    926  CA  ARG   115      28.424  42.369   5.025  0.50 18.89           C  
ATOM    928  C   ARG   115      28.865  43.824   4.888  1.00 20.95           C  
ATOM    929  O   ARG   115      28.477  44.509   3.934  1.00 21.03           O  
ATOM    930  CB  ARG   115      29.202  41.456   4.089  0.50 25.76           C  
ATOM    932  CG  ARG   115      28.836  39.990   4.312  0.50 30.32           C  
ATOM    934  CD  ARG   115      29.435  39.054   3.279  0.50 39.53           C  
ATOM    936  NE  ARG   115      30.793  39.438   2.908  0.50 40.24           N  
ATOM    938  CZ  ARG   115      31.874  39.233   3.650  0.50 35.64           C  
ATOM    940  NH1 ARG   115      33.037  39.641   3.194  0.50 37.10           N  
ATOM    942  NH2 ARG   115      31.801  38.652   4.846  0.50 44.23           N  
ATOM    944  N   ALA   116      29.631  44.298   5.874  1.00 15.80           N  
ATOM    945  CA  ALA   116      30.150  45.685   5.878  1.00 23.26           C  
ATOM    946  C   ALA   116      31.663  45.682   5.736  1.00 22.47           C  
ATOM    947  O   ALA   116      32.346  44.741   6.166  1.00 22.50           O  
ATOM    948  CB  ALA   116      29.767  46.415   7.151  1.00 18.37           C  
ATOM    949  N   TYR   117      32.186  46.762   5.178  1.00 16.80           N  
ATOM    950  CA  TYR   117      33.643  46.870   4.922  1.00 16.57           C  
ATOM    951  C   TYR   117      34.160  48.128   5.558  1.00 19.40           C  
ATOM    952  O   TYR   117      33.404  49.096   5.756  1.00 17.01           O  
ATOM    953  CB  TYR   117      33.920  46.873   3.397  1.00 17.31           C  
ATOM    954  CG  TYR   117      33.361  45.617   2.746  1.00 19.59           C  
ATOM    955  CD1 TYR   117      34.018  44.399   2.876  1.00 20.47           C  
ATOM    956  CD2 TYR   117      32.124  45.637   2.084  1.00 20.52           C  
ATOM    957  CE1 TYR   117      33.501  43.243   2.328  1.00 17.56           C  
ATOM    958  CE2 TYR   117      31.601  44.488   1.515  1.00 22.34           C  
ATOM    959  CZ  TYR   117      32.279  43.295   1.653  1.00 22.06           C  
ATOM    960  OH  TYR   117      31.744  42.169   1.124  1.00 21.87           O  
ATOM    961  N   GLY   118      35.448  48.143   5.874  1.00 19.03           N  
ATOM    962  CA  GLY   118      36.030  49.316   6.478  1.00 19.24           C  
ATOM    963  C   GLY   118      37.527  49.267   6.295  1.00 16.72           C  
ATOM    964  O   GLY   118      38.090  48.234   5.913  1.00 20.13           O  
ATOM    965  N   VAL   119      38.164  50.403   6.517  1.00 16.32           N  
ATOM    966  CA  VAL   119      39.604  50.494   6.412  1.00 15.00           C  
ATOM    967  C   VAL   119      40.169  50.936   7.753  1.00 22.40           C  
ATOM    968  O   VAL   119      39.583  51.799   8.435  1.00 22.82           O  
ATOM    969  CB  VAL   119      40.100  51.440   5.249  1.00 22.27           C  
ATOM    970  CG1 VAL   119      39.592  50.948   3.891  1.00 19.88           C  
ATOM    971  CG2 VAL   119      39.690  52.898   5.489  1.00 22.21           C  
ATOM    972  N   HIS   120      41.285  50.311   8.137  1.00 18.08           N  
ATOM    973  CA  HIS   120      41.968  50.589   9.417  1.00 19.70           C  
ATOM    974  C   HIS   120      43.453  50.730   9.187  1.00 21.42           C  
ATOM    975  O   HIS   120      44.094  49.860   8.570  1.00 20.16           O  
ATOM    976  CB  HIS   120      41.709  49.468  10.444  1.00 18.67           C  
ATOM    977  CG  HIS   120      40.288  49.423  10.918  1.00 20.33           C  
ATOM    978  ND1 HIS   120      39.921  49.778  12.195  1.00 18.82           N  
ATOM    979  CD2 HIS   120      39.142  49.097  10.276  1.00 22.07           C  
ATOM    980  CE1 HIS   120      38.609  49.662  12.326  1.00 20.40           C  
ATOM    981  NE2 HIS   120      38.114  49.271  11.167  1.00 21.07           N  
ATOM    982  N   LEU   121      43.992  51.845   9.667  1.00 17.73           N  
ATOM    983  CA  LEU   121      45.391  52.168   9.486  1.00 19.07           C  
ATOM    984  C   LEU   121      46.194  52.043  10.780  1.00 17.80           C  
ATOM    985  O   LEU   121      45.801  52.603  11.817  1.00 19.58           O  
ATOM    986  CB  LEU   121      45.541  53.594   8.939  1.00 16.96           C  
ATOM    987  CG  LEU   121      46.996  54.056   8.719  1.00 19.89           C  
ATOM    988  CD1 LEU   121      47.636  53.390   7.537  1.00 22.06           C  
ATOM    989  CD2 LEU   121      47.033  55.582   8.509  1.00 22.75           C  
ATOM    990  N   ASN   122      47.303  51.298  10.705  1.00 19.55           N  
ATOM    991  CA  ASN   122      48.301  51.221  11.781  1.00 21.15           C  
ATOM    992  C   ASN   122      49.405  52.240  11.517  1.00 19.94           C  
ATOM    993  O   ASN   122      50.271  52.018  10.667  1.00 21.83           O  
ATOM    994  CB  ASN   122      48.888  49.806  11.905  1.00 17.68           C  
ATOM    995  CG  ASN   122      47.824  48.744  12.154  1.00 26.32           C  
ATOM    996  OD1 ASN   122      47.116  48.776  13.163  1.00 22.92           O  
ATOM    997  ND2 ASN   122      47.707  47.804  11.238  1.00 18.70           N  
ATOM    998  N   GLY   123      49.334  53.381  12.208  1.00 20.19           N  
ATOM    999  CA  GLY   123      50.345  54.440  12.079  1.00 18.15           C  
ATOM   1000  C   GLY   123      51.381  54.310  13.171  1.00 21.64           C  
ATOM   1001  O   GLY   123      51.065  54.442  14.366  1.00 22.55           O  
ATOM   1002  N   TYR   124      52.620  54.067  12.763  1.00 22.90           N  
ATOM   1003  CA  TYR   124      53.694  53.774  13.698  1.00 25.90           C  
ATOM   1004  C   TYR   124      55.020  54.490  13.366  1.00 25.41           C  
ATOM   1005  O   TYR   124      55.209  54.987  12.233  1.00 23.58           O  
ATOM   1006  CB  TYR   124      53.884  52.237  13.832  1.00 21.31           C  
ATOM   1007  CG  TYR   124      54.369  51.536  12.592  1.00 27.55           C  
ATOM   1008  CD1 TYR   124      55.728  51.400  12.332  1.00 30.72           C  
ATOM   1009  CD2 TYR   124      53.469  50.982  11.680  1.00 27.78           C  
ATOM   1010  CE1 TYR   124      56.182  50.760  11.192  1.00 31.47           C  
ATOM   1011  CE2 TYR   124      53.919  50.339  10.543  1.00 30.81           C  
ATOM   1012  CZ  TYR   124      55.265  50.228  10.304  1.00 31.70           C  
ATOM   1013  OH  TYR   124      55.719  49.579   9.177  1.00 42.11           O  
ATOM   1014  N   VAL   125      55.895  54.566  14.384  1.00 29.81           N  
ATOM   1015  CA  VAL   125      57.235  55.137  14.244  0.50 32.58           C  
ATOM   1017  C   VAL   125      58.246  54.234  14.931  1.00 34.47           C  
ATOM   1018  O   VAL   125      57.929  53.543  15.901  1.00 36.28           O  
ATOM   1019  CB  VAL   125      57.365  56.610  14.786  0.50 31.90           C  
ATOM   1021  CG1 VAL   125      56.598  57.581  13.923  0.50 28.83           C  
ATOM   1023  CG2 VAL   125      56.931  56.736  16.248  0.50 25.63           C  
ATOM   1025  N   GLY   126      59.472  54.206  14.407  1.00 37.83           N  
ATOM   1026  CA  GLY   126      60.529  53.399  15.017  1.00 35.15           C  
ATOM   1027  C   GLY   126      60.513  51.960  14.553  1.00 37.66           C  
ATOM   1028  O   GLY   126      59.729  51.601  13.680  1.00 38.85           O  
ATOM   1029  N   ALA   127      61.400  51.144  15.123  1.00 41.73           N  
ATOM   1030  CA  ALA   127      61.486  49.714  14.808  1.00 44.35           C  
ATOM   1031  C   ALA   127      61.973  48.958  16.031  1.00 47.23           C  
ATOM   1032  O   ALA   127      62.529  49.566  16.954  1.00 46.60           O  
ATOM   1033  CB  ALA   127      62.415  49.466  13.622  1.00 46.56           C  
ATOM   1034  N   GLY   128      61.751  47.644  16.037  1.00 47.40           N  
ATOM   1035  CA  GLY   128      62.218  46.768  17.107  1.00 50.12           C  
ATOM   1036  C   GLY   128      61.766  47.220  18.479  1.00 51.85           C  
ATOM   1037  O   GLY   128      60.591  47.487  18.685  1.00 49.32           O  
ATOM   1038  N   ALA   129      62.719  47.366  19.398  1.00 53.70           N  
ATOM   1039  CA  ALA   129      62.427  47.766  20.776  1.00 52.09           C  
ATOM   1040  C   ALA   129      61.864  49.189  20.926  1.00 49.76           C  
ATOM   1041  O   ALA   129      61.302  49.525  21.971  1.00 51.31           O  
ATOM   1042  CB  ALA   129      63.673  47.580  21.661  1.00 58.37           C  
ATOM   1043  N   ASP   130      61.988  50.006  19.878  1.00 42.21           N  
ATOM   1044  CA  ASP   130      61.566  51.406  19.908  0.50 41.80           C  
ATOM   1046  C   ASP   130      60.292  51.658  19.075  1.00 36.31           C  
ATOM   1047  O   ASP   130      59.968  52.791  18.752  1.00 38.36           O  
ATOM   1048  CB  ASP   130      62.718  52.293  19.417  0.50 40.53           C  
ATOM   1050  CG  ASP   130      64.080  51.814  19.913  0.50 50.35           C  
ATOM   1052  OD1 ASP   130      64.218  51.549  21.128  0.50 52.59           O  
ATOM   1054  OD2 ASP   130      65.011  51.699  19.084  0.50 53.48           O  
ATOM   1056  N   LEU   131      59.587  50.592  18.717  1.00 34.21           N  
ATOM   1057  CA  LEU   131      58.357  50.692  17.930  1.00 32.36           C  
ATOM   1058  C   LEU   131      57.231  51.347  18.729  1.00 29.17           C  
ATOM   1059  O   LEU   131      56.875  50.888  19.824  1.00 31.74           O  
ATOM   1060  CB  LEU   131      57.936  49.290  17.504  1.00 33.48           C  
ATOM   1061  CG  LEU   131      56.788  49.115  16.520  1.00 38.03           C  
ATOM   1062  CD1 LEU   131      57.146  49.674  15.163  1.00 38.14           C  
ATOM   1063  CD2 LEU   131      56.476  47.633  16.402  1.00 34.66           C  
ATOM   1064  N   HIS   132      56.697  52.440  18.189  1.00 27.61           N  
ATOM   1065  CA  HIS   132      55.625  53.187  18.816  1.00 23.90           C  
ATOM   1066  C   HIS   132      54.403  53.300  17.890  1.00 24.13           C  
ATOM   1067  O   HIS   132      54.568  53.508  16.702  1.00 28.10           O  
ATOM   1068  CB  HIS   132      56.104  54.594  19.205  1.00 25.85           C  
ATOM   1069  CG  HIS   132      57.031  54.617  20.382  1.00 24.89           C  
ATOM   1070  ND1 HIS   132      56.661  55.116  21.613  1.00 30.01           N  
ATOM   1071  CD2 HIS   132      58.310  54.197  20.517  1.00 29.31           C  
ATOM   1072  CE1 HIS   132      57.673  55.006  22.453  1.00 26.14           C  
ATOM   1073  NE2 HIS   132      58.684  54.446  21.815  1.00 33.17           N  
ATOM   1074  N   LEU   133      53.202  53.178  18.454  1.00 28.30           N  
ATOM   1075  CA  LEU   133      51.965  53.311  17.693  0.50 25.22           C  
ATOM   1077  C   LEU   133      51.192  54.565  18.089  1.00 28.50           C  
ATOM   1078  O   LEU   133      51.068  54.881  19.279  1.00 28.20           O  
ATOM   1079  CB  LEU   133      51.074  52.082  17.888  0.50 25.92           C  
ATOM   1081  CG  LEU   133      51.376  50.838  17.050  0.50 26.92           C  
ATOM   1083  CD1 LEU   133      50.895  49.605  17.797  0.50 26.96           C  
ATOM   1085  CD2 LEU   133      50.773  50.929  15.631  0.50 14.39           C  
ATOM   1087  N   TRP   134      50.677  55.273  17.079  1.00 24.73           N  
ATOM   1088  CA  TRP   134      49.741  56.378  17.310  1.00 28.04           C  
ATOM   1089  C   TRP   134      48.363  55.790  17.526  1.00 21.54           C  
ATOM   1090  O   TRP   134      47.880  55.030  16.697  1.00 27.82           O  
ATOM   1091  CB  TRP   134      49.680  57.332  16.115  1.00 24.82           C  
ATOM   1092  CG  TRP   134      50.814  58.286  16.080  1.00 25.59           C  
ATOM   1093  CD1 TRP   134      51.899  58.229  15.270  1.00 25.75           C  
ATOM   1094  CD2 TRP   134      50.989  59.436  16.920  1.00 27.94           C  
ATOM   1095  NE1 TRP   134      52.752  59.290  15.539  1.00 32.80           N  
ATOM   1096  CE2 TRP   134      52.208  60.045  16.547  1.00 32.27           C  
ATOM   1097  CE3 TRP   134      50.226  60.016  17.948  1.00 29.66           C  
ATOM   1098  CZ2 TRP   134      52.694  61.209  17.178  1.00 32.34           C  
ATOM   1099  CZ3 TRP   134      50.701  61.175  18.566  1.00 27.78           C  
ATOM   1100  CH2 TRP   134      51.928  61.751  18.178  1.00 25.76           C  
ATOM   1101  N   ILE   135      47.743  56.157  18.633  1.00 20.49           N  
ATOM   1102  CA  ILE   135      46.424  55.667  19.012  1.00 23.64           C  
ATOM   1103  C   ILE   135      45.507  56.876  19.036  1.00 24.63           C  
ATOM   1104  O   ILE   135      45.884  57.934  19.535  1.00 25.53           O  
ATOM   1105  CB  ILE   135      46.491  54.994  20.443  1.00 25.95           C  
ATOM   1106  CG1 ILE   135      47.393  53.740  20.415  1.00 32.16           C  
ATOM   1107  CG2 ILE   135      45.105  54.739  21.036  1.00 28.52           C  
ATOM   1108  CD1 ILE   135      47.131  52.779  19.275  1.00 32.57           C  
ATOM   1109  N   GLY   136      44.291  56.729  18.517  1.00 22.14           N  
ATOM   1110  CA  GLY   136      43.312  57.788  18.672  1.00 23.75           C  
ATOM   1111  C   GLY   136      42.392  57.506  19.845  1.00 29.17           C  
ATOM   1112  O   GLY   136      42.214  56.345  20.221  1.00 26.20           O  
ATOM   1113  N   ARG   137      41.853  58.561  20.468  1.00 27.14           N  
ATOM   1114  CA  ARG   137      40.785  58.419  21.449  0.50 27.41           C  
ATOM   1116  C   ARG   137      39.521  58.970  20.802  1.00 26.20           C  
ATOM   1117  O   ARG   137      39.511  60.130  20.393  1.00 30.01           O  
ATOM   1118  CB  ARG   137      41.113  59.202  22.723  0.50 28.24           C  
ATOM   1120  CG  ARG   137      40.424  58.677  23.983  0.50 35.93           C  
ATOM   1122  CD  ARG   137      40.349  59.720  25.115  0.50 34.31           C  
ATOM   1124  NE  ARG   137      41.505  60.618  25.170  0.50 35.77           N  
ATOM   1126  CZ  ARG   137      42.654  60.353  25.790  0.50 35.38           C  
ATOM   1128  NH1 ARG   137      43.629  61.251  25.770  0.50 40.30           N  
ATOM   1130  NH2 ARG   137      42.837  59.204  26.431  0.50 38.83           N  
ATOM   1132  N   ARG   138      38.478  58.146  20.717  1.00 26.46           N  
ATOM   1133  CA  ARG   138      37.248  58.524  20.025  1.00 25.62           C  
ATOM   1134  C   ARG   138      36.522  59.630  20.787  1.00 30.91           C  
ATOM   1135  O   ARG   138      36.602  59.709  22.021  1.00 29.45           O  
ATOM   1136  CB  ARG   138      36.339  57.304  19.832  1.00 23.64           C  
ATOM   1137  CG  ARG   138      36.966  56.242  18.907  1.00 21.94           C  
ATOM   1138  CD  ARG   138      36.266  54.910  18.996  1.00 20.70           C  
ATOM   1139  NE  ARG   138      34.880  54.968  18.531  1.00 22.86           N  
ATOM   1140  CZ  ARG   138      34.529  54.986  17.247  1.00 20.39           C  
ATOM   1141  NH1 ARG   138      35.457  54.949  16.293  1.00 22.53           N  
ATOM   1142  NH2 ARG   138      33.259  55.024  16.912  1.00 23.32           N  
ATOM   1143  N   SER   139      35.824  60.482  20.046  1.00 30.82           N  
ATOM   1144  CA  SER   139      35.057  61.578  20.638  1.00 30.87           C  
ATOM   1145  C   SER   139      33.940  61.000  21.509  1.00 34.11           C  
ATOM   1146  O   SER   139      33.421  59.916  21.203  1.00 30.95           O  
ATOM   1147  CB  SER   139      34.488  62.454  19.511  1.00 33.82           C  
ATOM   1148  OG  SER   139      33.340  63.180  19.913  1.00 44.80           O  
ATOM   1149  N   PRO   140      33.553  61.712  22.597  1.00 38.34           N  
ATOM   1150  CA  PRO   140      32.428  61.225  23.417  1.00 34.53           C  
ATOM   1151  C   PRO   140      31.082  61.213  22.695  1.00 37.90           C  
ATOM   1152  O   PRO   140      30.154  60.542  23.157  1.00 31.63           O  
ATOM   1153  CB  PRO   140      32.380  62.217  24.592  1.00 39.75           C  
ATOM   1154  CG  PRO   140      33.679  62.919  24.569  1.00 42.46           C  
ATOM   1155  CD  PRO   140      34.111  62.964  23.141  1.00 37.78           C  
ATOM   1156  N   ASP   141      30.996  61.920  21.563  1.00 35.55           N  
ATOM   1157  CA  ASP   141      29.781  62.004  20.771  1.00 36.36           C  
ATOM   1158  C   ASP   141      29.584  60.825  19.802  1.00 34.79           C  
ATOM   1159  O   ASP   141      28.527  60.709  19.174  1.00 34.78           O  
ATOM   1160  CB  ASP   141      29.739  63.340  20.013  1.00 44.42           C  
ATOM   1161  CG  ASP   141      29.874  64.547  20.938  1.00 49.36           C  
ATOM   1162  OD1 ASP   141      29.306  64.515  22.049  1.00 56.17           O  
ATOM   1163  OD2 ASP   141      30.558  65.525  20.559  1.00 52.17           O  
ATOM   1164  N   LYS   142      30.576  59.939  19.681  1.00 29.21           N  
ATOM   1165  CA  LYS   142      30.384  58.752  18.851  1.00 25.30           C  
ATOM   1166  C   LYS   142      29.212  57.930  19.356  1.00 25.78           C  
ATOM   1167  O   LYS   142      29.064  57.680  20.568  1.00 27.08           O  
ATOM   1168  CB  LYS   142      31.640  57.870  18.797  1.00 27.48           C  
ATOM   1169  CG  LYS   142      32.783  58.447  17.985  1.00 21.74           C  
ATOM   1170  CD  LYS   142      32.458  58.500  16.487  1.00 23.30           C  
ATOM   1171  CE  LYS   142      33.691  58.863  15.653  1.00 37.56           C  
ATOM   1172  NZ  LYS   142      33.392  58.674  14.195  1.00 34.81           N  
ATOM   1173  N   SER   143      28.395  57.504  18.408  1.00 28.71           N  
ATOM   1174  CA  SER   143      27.291  56.609  18.662  1.00 30.64           C  
ATOM   1175  C   SER   143      27.787  55.255  19.212  1.00 34.84           C  
ATOM   1176  O   SER   143      27.203  54.700  20.156  1.00 33.01           O  
ATOM   1177  CB  SER   143      26.516  56.417  17.359  1.00 38.43           C  
ATOM   1178  OG  SER   143      25.518  55.421  17.483  1.00 52.04           O  
ATOM   1179  N   VAL   144      28.881  54.763  18.625  1.00 26.02           N  
ATOM   1180  CA  VAL   144      29.490  53.472  18.954  1.00 27.84           C  
ATOM   1181  C   VAL   144      30.828  53.714  19.640  1.00 24.68           C  
ATOM   1182  O   VAL   144      31.624  54.538  19.176  1.00 29.30           O  
ATOM   1183  CB  VAL   144      29.689  52.619  17.656  1.00 24.85           C  
ATOM   1184  CG1 VAL   144      30.577  51.388  17.923  1.00 28.55           C  
ATOM   1185  CG2 VAL   144      28.334  52.209  17.074  1.00 29.86           C  
ATOM   1186  N   ALA   145      31.073  53.020  20.760  1.00 28.68           N  
ATOM   1187  CA  ALA   145      32.369  53.094  21.450  1.00 27.24           C  
ATOM   1188  C   ALA   145      32.860  54.538  21.737  1.00 24.20           C  
ATOM   1189  O   ALA   145      34.024  54.866  21.456  1.00 24.03           O  
ATOM   1190  CB  ALA   145      33.455  52.282  20.649  1.00 22.65           C  
ATOM   1191  N   PRO   146      31.979  55.416  22.294  1.00 26.11           N  
ATOM   1192  CA  PRO   146      32.462  56.776  22.548  1.00 27.01           C  
ATOM   1193  C   PRO   146      33.556  56.753  23.604  1.00 27.01           C  
ATOM   1194  O   PRO   146      33.477  55.947  24.536  1.00 26.67           O  
ATOM   1195  CB  PRO   146      31.219  57.494  23.089  1.00 26.92           C  
ATOM   1196  CG  PRO   146      30.367  56.410  23.679  1.00 26.95           C  
ATOM   1197  CD  PRO   146      30.582  55.243  22.751  1.00 26.57           C  
ATOM   1198  N   GLY   147      34.583  57.584  23.429  1.00 23.06           N  
ATOM   1199  CA  GLY   147      35.705  57.661  24.359  1.00 27.37           C  
ATOM   1200  C   GLY   147      36.691  56.497  24.326  1.00 31.76           C  
ATOM   1201  O   GLY   147      37.667  56.505  25.074  1.00 28.82           O  
ATOM   1202  N   LYS   148      36.440  55.491  23.485  1.00 27.28           N  
ATOM   1203  CA  LYS   148      37.332  54.317  23.405  1.00 26.06           C  
ATOM   1204  C   LYS   148      38.557  54.579  22.543  1.00 24.99           C  
ATOM   1205  O   LYS   148      38.583  55.495  21.700  1.00 22.55           O  
ATOM   1206  CB  LYS   148      36.593  53.091  22.883  1.00 28.51           C  
ATOM   1207  CG  LYS   148      35.318  52.761  23.627  1.00 30.74           C  
ATOM   1208  CD  LYS   148      35.550  52.390  25.007  1.00 43.85           C  
ATOM   1209  CE  LYS   148      35.908  50.942  25.127  1.00 32.51           C  
ATOM   1210  NZ  LYS   148      35.988  50.749  26.579  1.00 28.96           N  
ATOM   1211  N   LEU   149      39.580  53.755  22.738  1.00 19.09           N  
ATOM   1212  CA  LEU   149      40.799  53.869  21.978  1.00 20.06           C  
ATOM   1213  C   LEU   149      40.618  53.178  20.614  1.00 21.55           C  
ATOM   1214  O   LEU   149      39.808  52.249  20.469  1.00 19.47           O  
ATOM   1215  CB  LEU   149      41.978  53.254  22.739  1.00 19.37           C  
ATOM   1216  CG  LEU   149      42.239  53.841  24.143  1.00 22.93           C  
ATOM   1217  CD1 LEU   149      43.478  53.201  24.754  1.00 25.48           C  
ATOM   1218  CD2 LEU   149      42.424  55.331  24.014  1.00 24.59           C  
ATOM   1219  N   ASP   150      41.386  53.643  19.642  1.00 19.17           N  
ATOM   1220  CA  ASP   150      41.137  53.381  18.214  1.00 17.87           C  
ATOM   1221  C   ASP   150      42.435  53.385  17.456  1.00 21.13           C  
ATOM   1222  O   ASP   150      43.464  53.839  17.963  1.00 19.36           O  
ATOM   1223  CB  ASP   150      40.216  54.510  17.665  1.00 22.49           C  
ATOM   1224  CG  ASP   150      39.310  54.075  16.479  1.00 28.89           C  
ATOM   1225  OD1 ASP   150      39.538  53.036  15.793  1.00 24.67           O  
ATOM   1226  OD2 ASP   150      38.338  54.829  16.218  1.00 21.49           O  
ATOM   1227  N   ASN   151      42.412  52.873  16.220  1.00 19.91           N  
ATOM   1228  CA  ASN   151      43.513  53.121  15.292  1.00 18.90           C  
ATOM   1229  C   ASN   151      43.692  54.630  15.039  1.00 19.61           C  
ATOM   1230  O   ASN   151      42.763  55.413  15.282  1.00 21.72           O  
ATOM   1231  CB  ASN   151      43.249  52.436  13.953  1.00 19.47           C  
ATOM   1232  CG  ASN   151      42.927  50.965  14.110  1.00 21.52           C  
ATOM   1233  OD1 ASN   151      41.774  50.562  13.988  1.00 25.50           O  
ATOM   1234  ND2 ASN   151      43.938  50.165  14.449  1.00 24.44           N  
ATOM   1235  N   MET   152      44.869  55.023  14.553  1.00 20.04           N  
ATOM   1236  CA  MET   152      45.111  56.424  14.225  1.00 22.73           C  
ATOM   1237  C   MET   152      44.070  56.899  13.189  1.00 23.86           C  
ATOM   1238  O   MET   152      43.521  58.014  13.289  1.00 21.66           O  
ATOM   1239  CB  MET   152      46.514  56.636  13.679  1.00 18.42           C  
ATOM   1240  CG  MET   152      46.859  58.149  13.591  1.00 23.68           C  
ATOM   1241  SD  MET   152      48.604  58.426  12.865  0.70 28.49          SE  
ATOM   1242  CE  MET   152      48.177  58.085  11.003  1.00 34.44           C  
ATOM   1243  N   VAL   153      43.777  56.029  12.217  1.00 20.16           N  
ATOM   1244  CA  VAL   153      42.762  56.323  11.194  1.00 19.57           C  
ATOM   1245  C   VAL   153      41.943  55.047  10.963  1.00 19.06           C  
ATOM   1246  O   VAL   153      42.516  53.975  10.822  1.00 20.64           O  
ATOM   1247  CB  VAL   153      43.415  56.792   9.862  1.00 20.96           C  
ATOM   1248  CG1 VAL   153      42.353  56.936   8.741  1.00 24.65           C  
ATOM   1249  CG2 VAL   153      44.159  58.106  10.035  1.00 22.39           C  
ATOM   1250  N   ALA   154      40.617  55.163  10.971  1.00 19.92           N  
ATOM   1251  CA  ALA   154      39.731  54.023  10.657  1.00 21.62           C  
ATOM   1252  C   ALA   154      38.397  54.570  10.228  1.00 25.62           C  
ATOM   1253  O   ALA   154      37.948  55.570  10.773  1.00 25.22           O  
ATOM   1254  CB  ALA   154      39.524  53.137  11.885  1.00 20.52           C  
ATOM   1255  N   GLY   155      37.735  53.910   9.291  1.00 19.78           N  
ATOM   1256  CA  GLY   155      36.358  54.302   8.976  1.00 23.92           C  
ATOM   1257  C   GLY   155      35.641  53.261   8.154  1.00 25.11           C  
ATOM   1258  O   GLY   155      36.280  52.417   7.521  1.00 20.50           O  
ATOM   1259  N   GLY   156      34.313  53.317   8.176  1.00 16.33           N  
ATOM   1260  CA  GLY   156      33.510  52.527   7.267  1.00 17.20           C  
ATOM   1261  C   GLY   156      33.756  52.878   5.803  1.00 17.21           C  
ATOM   1262  O   GLY   156      34.197  53.983   5.475  1.00 20.27           O  
ATOM   1263  N   GLN   157      33.468  51.919   4.926  1.00 21.75           N  
ATOM   1264  CA  GLN   157      33.725  52.051   3.502  1.00 18.48           C  
ATOM   1265  C   GLN   157      32.454  52.429   2.761  1.00 20.30           C  
ATOM   1266  O   GLN   157      31.530  51.630   2.670  1.00 19.32           O  
ATOM   1267  CB  GLN   157      34.219  50.733   2.932  1.00 20.97           C  
ATOM   1268  CG  GLN   157      34.585  50.817   1.450  1.00 17.60           C  
ATOM   1269  CD  GLN   157      35.776  51.699   1.251  1.00 22.34           C  
ATOM   1270  OE1 GLN   157      36.605  51.847   2.153  1.00 20.60           O  
ATOM   1271  NE2 GLN   157      35.886  52.292   0.068  1.00 22.64           N  
ATOM   1272  N   PRO   158      32.420  53.634   2.195  1.00 20.08           N  
ATOM   1273  CA  PRO   158      31.248  53.977   1.381  1.00 22.50           C  
ATOM   1274  C   PRO   158      31.248  53.236   0.035  1.00 19.52           C  
ATOM   1275  O   PRO   158      32.300  52.813  -0.455  1.00 22.07           O  
ATOM   1276  CB  PRO   158      31.373  55.491   1.172  1.00 25.22           C  
ATOM   1277  CG  PRO   158      32.803  55.820   1.440  1.00 26.79           C  
ATOM   1278  CD  PRO   158      33.400  54.730   2.294  1.00 20.41           C  
ATOM   1279  N   ALA   159      30.050  53.050  -0.505  1.00 21.68           N  
ATOM   1280  CA  ALA   159      29.832  52.394  -1.781  1.00 23.81           C  
ATOM   1281  C   ALA   159      30.622  53.032  -2.917  1.00 28.04           C  
ATOM   1282  O   ALA   159      31.044  52.329  -3.845  1.00 25.76           O  
ATOM   1283  CB  ALA   159      28.379  52.443  -2.120  1.00 28.69           C  
ATOM   1284  N   ASP   160      30.840  54.346  -2.847  1.00 24.07           N  
ATOM   1285  CA  ASP   160      31.271  55.058  -4.054  1.00 33.19           C  
ATOM   1286  C   ASP   160      32.778  55.280  -4.144  1.00 33.50           C  
ATOM   1287  O   ASP   160      33.247  55.930  -5.091  1.00 25.67           O  
ATOM   1288  CB  ASP   160      30.494  56.378  -4.237  1.00 30.97           C  
ATOM   1289  CG  ASP   160      30.814  57.410  -3.164  1.00 39.20           C  
ATOM   1290  OD1 ASP   160      31.210  57.017  -2.048  1.00 33.72           O  
ATOM   1291  OD2 ASP   160      30.659  58.620  -3.436  1.00 46.55           O  
ATOM   1292  N   LEU   161      33.521  54.729  -3.178  1.00 24.34           N  
ATOM   1293  CA  LEU   161      34.989  54.888  -3.136  1.00 22.16           C  
ATOM   1294  C   LEU   161      35.713  53.536  -3.169  1.00 25.00           C  
ATOM   1295  O   LEU   161      35.177  52.523  -2.695  1.00 23.70           O  
ATOM   1296  CB  LEU   161      35.414  55.651  -1.874  1.00 22.56           C  
ATOM   1297  CG  LEU   161      34.928  57.096  -1.657  1.00 30.24           C  
ATOM   1298  CD1 LEU   161      35.634  57.695  -0.437  1.00 27.83           C  
ATOM   1299  CD2 LEU   161      35.183  57.934  -2.909  1.00 23.35           C  
ATOM   1300  N   SER   162      36.929  53.543  -3.710  1.00 19.44           N  
ATOM   1301  CA  SER   162      37.896  52.441  -3.518  1.00 18.75           C  
ATOM   1302  C   SER   162      38.383  52.464  -2.051  1.00 16.03           C  
ATOM   1303  O   SER   162      38.138  53.432  -1.324  1.00 18.03           O  
ATOM   1304  CB  SER   162      39.094  52.550  -4.471  1.00 17.15           C  
ATOM   1305  OG  SER   162      39.999  53.562  -4.049  1.00 20.75           O  
ATOM   1306  N   LEU   163      39.050  51.391  -1.627  1.00 19.00           N  
ATOM   1307  CA  LEU   163      39.595  51.317  -0.272  1.00 18.42           C  
ATOM   1308  C   LEU   163      40.671  52.381  -0.112  1.00 19.29           C  
ATOM   1309  O   LEU   163      40.718  53.055   0.905  1.00 17.38           O  
ATOM   1310  CB  LEU   163      40.196  49.919  -0.020  1.00 15.49           C  
ATOM   1311  CG  LEU   163      39.127  48.827  -0.009  1.00 17.28           C  
ATOM   1312  CD1 LEU   163      39.794  47.445  -0.052  1.00 19.40           C  
ATOM   1313  CD2 LEU   163      38.208  48.916   1.206  1.00 21.21           C  
ATOM   1314  N   ARG   164      41.510  52.514  -1.135  1.00 17.15           N  
ATOM   1315  CA  ARG   164      42.623  53.462  -1.087  1.00 22.19           C  
ATOM   1316  C   ARG   164      42.088  54.905  -1.016  1.00 22.29           C  
ATOM   1317  O   ARG   164      42.616  55.747  -0.281  1.00 22.06           O  
ATOM   1318  CB  ARG   164      43.540  53.283  -2.294  1.00 24.55           C  
ATOM   1319  CG  ARG   164      44.631  54.375  -2.420  1.00 26.08           C  
ATOM   1320  CD  ARG   164      45.627  54.235  -1.296  1.00 29.30           C  
ATOM   1321  NE  ARG   164      46.362  52.975  -1.399  1.00 38.00           N  
ATOM   1322  CZ  ARG   164      47.405  52.647  -0.639  1.00 34.41           C  
ATOM   1323  NH1 ARG   164      47.838  53.476   0.317  1.00 28.73           N  
ATOM   1324  NH2 ARG   164      48.010  51.489  -0.842  1.00 29.91           N  
ATOM   1325  N   GLN   165      41.038  55.181  -1.780  1.00 20.52           N  
ATOM   1326  CA  GLN   165      40.438  56.522  -1.806  1.00 21.23           C  
ATOM   1327  C   GLN   165      39.844  56.868  -0.457  1.00 21.59           C  
ATOM   1328  O   GLN   165      40.038  57.982   0.062  1.00 20.84           O  
ATOM   1329  CB  GLN   165      39.336  56.598  -2.863  1.00 21.52           C  
ATOM   1330  CG  GLN   165      39.894  56.847  -4.261  1.00 28.49           C  
ATOM   1331  CD  GLN   165      39.029  56.265  -5.354  1.00 36.32           C  
ATOM   1332  OE1 GLN   165      37.806  56.063  -5.196  1.00 26.17           O  
ATOM   1333  NE2 GLN   165      39.665  55.986  -6.491  1.00 39.85           N  
ATOM   1334  N   ASN   166      39.107  55.918   0.106  1.00 21.23           N  
ATOM   1335  CA  ASN   166      38.535  56.108   1.415  1.00 22.05           C  
ATOM   1336  C   ASN   166      39.629  56.262   2.475  1.00 22.07           C  
ATOM   1337  O   ASN   166      39.542  57.133   3.315  1.00 20.60           O  
ATOM   1338  CB  ASN   166      37.599  54.967   1.791  1.00 20.63           C  
ATOM   1339  CG  ASN   166      36.757  55.305   3.021  1.00 23.47           C  
ATOM   1340  OD1 ASN   166      36.291  56.449   3.168  1.00 23.28           O  
ATOM   1341  ND2 ASN   166      36.583  54.349   3.904  1.00 18.78           N  
ATOM   1342  N   LEU   167      40.657  55.415   2.423  1.00 19.16           N  
ATOM   1343  CA  LEU   167      41.799  55.585   3.326  1.00 22.36           C  
ATOM   1344  C   LEU   167      42.376  57.018   3.244  1.00 27.44           C  
ATOM   1345  O   LEU   167      42.636  57.642   4.269  1.00 22.88           O  
ATOM   1346  CB  LEU   167      42.895  54.563   3.029  1.00 20.82           C  
ATOM   1347  CG  LEU   167      44.107  54.634   3.965  1.00 26.27           C  
ATOM   1348  CD1 LEU   167      43.730  54.259   5.425  1.00 21.08           C  
ATOM   1349  CD2 LEU   167      45.208  53.749   3.420  1.00 22.64           C  
ATOM   1350  N   ILE   168      42.555  57.538   2.028  1.00 26.93           N  
ATOM   1351  CA  ILE   168      43.115  58.897   1.843  1.00 25.17           C  
ATOM   1352  C   ILE   168      42.233  59.979   2.470  1.00 24.22           C  
ATOM   1353  O   ILE   168      42.714  60.859   3.184  1.00 23.88           O  
ATOM   1354  CB  ILE   168      43.383  59.177   0.341  1.00 28.80           C  
ATOM   1355  CG1 ILE   168      44.609  58.378  -0.097  1.00 21.59           C  
ATOM   1356  CG2 ILE   168      43.611  60.674   0.062  1.00 24.28           C  
ATOM   1357  CD1 ILE   168      44.644  58.115  -1.579  1.00 29.12           C  
ATOM   1358  N   LYS   169      40.942  59.881   2.215  1.00 21.03           N  
ATOM   1359  CA  LYS   169      39.965  60.802   2.753  1.00 25.69           C  
ATOM   1360  C   LYS   169      39.921  60.744   4.277  1.00 27.01           C  
ATOM   1361  O   LYS   169      39.920  61.770   4.938  1.00 24.12           O  
ATOM   1362  CB  LYS   169      38.605  60.472   2.187  1.00 20.71           C  
ATOM   1363  CG  LYS   169      37.441  61.203   2.821  1.00 28.07           C  
ATOM   1364  CD  LYS   169      36.119  60.764   2.225  1.00 44.80           C  
ATOM   1365  CE  LYS   169      34.965  61.166   3.143  1.00 54.68           C  
ATOM   1366  NZ  LYS   169      33.661  60.638   2.662  1.00 64.28           N  
ATOM   1367  N   GLU   170      39.906  59.538   4.834  1.00 18.72           N  
ATOM   1368  CA  GLU   170      39.874  59.382   6.287  1.00 20.09           C  
ATOM   1369  C   GLU   170      41.139  59.892   6.938  1.00 23.18           C  
ATOM   1370  O   GLU   170      41.073  60.468   8.020  1.00 27.45           O  
ATOM   1371  CB  GLU   170      39.622  57.917   6.696  1.00 22.79           C  
ATOM   1372  CG  GLU   170      38.258  57.350   6.280  1.00 25.29           C  
ATOM   1373  CD  GLU   170      37.049  58.059   6.906  1.00 40.32           C  
ATOM   1374  OE1 GLU   170      36.871  59.283   6.729  1.00 53.74           O  
ATOM   1375  OE2 GLU   170      36.237  57.371   7.550  1.00 42.38           O  
ATOM   1376  N   CYS   171      42.271  59.697   6.276  1.00 20.72           N  
ATOM   1377  CA  CYS   171      43.568  60.139   6.779  1.00 23.54           C  
ATOM   1378  C   CYS   171      43.620  61.653   6.964  1.00 30.29           C  
ATOM   1379  O   CYS   171      44.135  62.136   7.976  1.00 28.00           O  
ATOM   1380  CB  CYS   171      44.709  59.704   5.866  1.00 24.69           C  
ATOM   1381  SG  CYS   171      45.309  57.986   6.121  1.00 24.58           S  
ATOM   1382  N   ALA   172      43.089  62.377   5.974  1.00 25.84           N  
ATOM   1383  CA  ALA   172      42.997  63.838   6.024  1.00 26.87           C  
ATOM   1384  C   ALA   172      41.963  64.287   7.049  1.00 24.26           C  
ATOM   1385  O   ALA   172      42.255  65.126   7.889  1.00 28.18           O  
ATOM   1386  CB  ALA   172      42.653  64.407   4.617  1.00 26.01           C  
ATOM   1387  N   GLU   173      40.763  63.712   7.013  1.00 23.60           N  
ATOM   1388  CA  GLU   173      39.687  64.192   7.870  1.00 31.06           C  
ATOM   1389  C   GLU   173      39.919  63.865   9.345  1.00 31.04           C  
ATOM   1390  O   GLU   173      39.618  64.676  10.216  1.00 30.90           O  
ATOM   1391  CB  GLU   173      38.336  63.634   7.421  1.00 28.56           C  
ATOM   1392  CG  GLU   173      37.884  64.143   6.052  1.00 33.70           C  
ATOM   1393  CD  GLU   173      36.558  63.542   5.607  1.00 44.95           C  
ATOM   1394  OE1 GLU   173      36.107  62.539   6.213  1.00 52.84           O  
ATOM   1395  OE2 GLU   173      35.976  64.071   4.633  1.00 57.87           O  
ATOM   1396  N   GLU   174      40.459  62.683   9.625  1.00 27.71           N  
ATOM   1397  CA  GLU   174      40.521  62.220  11.005  1.00 24.57           C  
ATOM   1398  C   GLU   174      41.802  62.587  11.697  1.00 23.74           C  
ATOM   1399  O   GLU   174      41.819  62.763  12.916  1.00 27.22           O  
ATOM   1400  CB  GLU   174      40.311  60.703  11.110  1.00 21.95           C  
ATOM   1401  CG  GLU   174      38.903  60.226  10.741  1.00 31.09           C  
ATOM   1402  CD  GLU   174      38.726  58.714  10.905  1.00 40.24           C  
ATOM   1403  OE1 GLU   174      39.712  58.058  11.331  1.00 29.99           O  
ATOM   1404  OE2 GLU   174      37.601  58.194  10.616  1.00 30.74           O  
ATOM   1405  N   ALA   175      42.886  62.691  10.937  1.00 23.54           N  
ATOM   1406  CA  ALA   175      44.190  62.794  11.559  1.00 26.67           C  
ATOM   1407  C   ALA   175      45.070  63.861  10.933  1.00 23.54           C  
ATOM   1408  O   ALA   175      46.236  64.004  11.327  1.00 26.48           O  
ATOM   1409  CB  ALA   175      44.898  61.448  11.543  1.00 25.30           C  
ATOM   1410  N   ASP   176      44.536  64.581   9.945  1.00 30.87           N  
ATOM   1411  CA  ASP   176      45.316  65.624   9.266  1.00 31.29           C  
ATOM   1412  C   ASP   176      46.584  65.021   8.650  1.00 31.62           C  
ATOM   1413  O   ASP   176      47.680  65.585   8.741  1.00 26.14           O  
ATOM   1414  CB  ASP   176      45.645  66.754  10.271  1.00 35.88           C  
ATOM   1415  CG  ASP   176      46.111  68.041   9.596  1.00 44.42           C  
ATOM   1416  OD1 ASP   176      45.799  68.242   8.402  1.00 42.23           O  
ATOM   1417  OD2 ASP   176      46.803  68.835  10.266  1.00 45.65           O  
ATOM   1418  N   LEU   177      46.436  63.833   8.063  1.00 28.64           N  
ATOM   1419  CA  LEU   177      47.547  63.153   7.415  1.00 28.98           C  
ATOM   1420  C   LEU   177      47.363  63.336   5.912  1.00 29.59           C  
ATOM   1421  O   LEU   177      46.375  62.864   5.350  1.00 29.80           O  
ATOM   1422  CB  LEU   177      47.591  61.655   7.796  1.00 28.47           C  
ATOM   1423  CG  LEU   177      48.676  60.813   7.119  1.00 31.21           C  
ATOM   1424  CD1 LEU   177      50.059  61.193   7.567  1.00 43.08           C  
ATOM   1425  CD2 LEU   177      48.462  59.350   7.408  1.00 35.93           C  
ATOM   1426  N   PRO   178      48.287  64.075   5.272  1.00 36.79           N  
ATOM   1427  CA  PRO   178      48.150  64.497   3.880  1.00 35.44           C  
ATOM   1428  C   PRO   178      48.266  63.343   2.903  1.00 31.05           C  
ATOM   1429  O   PRO   178      48.832  62.296   3.248  1.00 31.49           O  
ATOM   1430  CB  PRO   178      49.332  65.455   3.684  1.00 38.30           C  
ATOM   1431  CG  PRO   178      50.349  65.018   4.692  1.00 42.22           C  
ATOM   1432  CD  PRO   178      49.543  64.563   5.873  1.00 35.40           C  
ATOM   1433  N   GLU   179      47.743  63.564   1.695  1.00 33.20           N  
ATOM   1434  CA  GLU   179      47.658  62.554   0.647  1.00 34.92           C  
ATOM   1435  C   GLU   179      48.979  61.886   0.297  1.00 33.77           C  
ATOM   1436  O   GLU   179      49.014  60.670   0.118  1.00 35.14           O  
ATOM   1437  CB  GLU   179      47.021  63.129  -0.615  1.00 35.78           C  
ATOM   1438  CG  GLU   179      46.777  62.071  -1.703  1.00 36.31           C  
ATOM   1439  CD  GLU   179      45.889  62.560  -2.842  1.00 45.49           C  
ATOM   1440  OE1 GLU   179      45.597  63.774  -2.898  1.00 52.73           O  
ATOM   1441  OE2 GLU   179      45.477  61.722  -3.677  1.00 45.51           O  
ATOM   1442  N   ALA   180      50.058  62.667   0.227  1.00 36.39           N  
ATOM   1443  CA  ALA   180      51.379  62.133  -0.131  1.00 38.20           C  
ATOM   1444  C   ALA   180      51.853  61.056   0.853  1.00 37.77           C  
ATOM   1445  O   ALA   180      52.397  60.028   0.444  1.00 41.56           O  
ATOM   1446  CB  ALA   180      52.416  63.260  -0.251  1.00 40.78           C  
ATOM   1447  N   LEU   181      51.627  61.294   2.142  1.00 36.73           N  
ATOM   1448  CA  LEU   181      51.914  60.280   3.160  1.00 34.41           C  
ATOM   1449  C   LEU   181      50.891  59.141   3.182  1.00 27.36           C  
ATOM   1450  O   LEU   181      51.282  57.985   3.216  1.00 31.68           O  
ATOM   1451  CB  LEU   181      52.044  60.908   4.548  1.00 31.23           C  
ATOM   1452  CG  LEU   181      53.424  61.415   4.958  1.00 44.99           C  
ATOM   1453  CD1 LEU   181      53.292  62.339   6.142  1.00 46.78           C  
ATOM   1454  CD2 LEU   181      54.331  60.242   5.304  1.00 49.35           C  
ATOM   1455  N   ALA   182      49.589  59.457   3.184  1.00 24.43           N  
ATOM   1456  CA  ALA   182      48.533  58.431   3.118  1.00 26.05           C  
ATOM   1457  C   ALA   182      48.706  57.419   1.980  1.00 30.74           C  
ATOM   1458  O   ALA   182      48.386  56.233   2.140  1.00 25.47           O  
ATOM   1459  CB  ALA   182      47.142  59.081   3.053  1.00 25.43           C  
ATOM   1460  N   ARG   183      49.211  57.878   0.829  1.00 28.18           N  
ATOM   1461  CA  ARG   183      49.477  56.998  -0.308  1.00 31.04           C  
ATOM   1462  C   ARG   183      50.649  56.021  -0.087  1.00 25.44           C  
ATOM   1463  O   ARG   183      50.764  55.015  -0.789  1.00 29.60           O  
ATOM   1464  CB  ARG   183      49.697  57.813  -1.595  1.00 29.99           C  
ATOM   1465  CG  ARG   183      48.406  58.279  -2.240  1.00 34.47           C  
ATOM   1466  CD  ARG   183      48.654  58.995  -3.593  1.00 43.53           C  
ATOM   1467  NE  ARG   183      47.418  59.526  -4.180  1.00 42.49           N  
ATOM   1468  CZ  ARG   183      46.495  58.799  -4.812  1.00 45.86           C  
ATOM   1469  NH1 ARG   183      46.631  57.479  -4.952  1.00 51.31           N  
ATOM   1470  NH2 ARG   183      45.416  59.395  -5.297  1.00 49.80           N  
ATOM   1471  N   GLN   184      51.530  56.332   0.857  1.00 30.80           N  
ATOM   1472  CA  GLN   184      52.625  55.422   1.196  1.00 31.05           C  
ATOM   1473  C   GLN   184      52.169  54.233   2.055  1.00 27.05           C  
ATOM   1474  O   GLN   184      52.927  53.271   2.211  1.00 26.28           O  
ATOM   1475  CB  GLN   184      53.746  56.175   1.903  1.00 30.65           C  
ATOM   1476  CG  GLN   184      54.521  57.145   1.003  1.00 43.67           C  
ATOM   1477  CD  GLN   184      55.464  58.044   1.787  1.00 47.15           C  
ATOM   1478  OE1 GLN   184      56.057  57.632   2.791  1.00 55.62           O  
ATOM   1479  NE2 GLN   184      55.603  59.284   1.334  1.00 61.22           N  
ATOM   1480  N   ALA   185      50.965  54.313   2.632  1.00 27.12           N  
ATOM   1481  CA  ALA   185      50.421  53.199   3.447  1.00 26.49           C  
ATOM   1482  C   ALA   185      50.296  51.947   2.601  1.00 23.37           C  
ATOM   1483  O   ALA   185      49.831  52.000   1.454  1.00 26.33           O  
ATOM   1484  CB  ALA   185      49.064  53.550   4.049  1.00 22.77           C  
ATOM   1485  N   ILE   186      50.731  50.817   3.148  1.00 19.54           N  
ATOM   1486  CA  ILE   186      50.664  49.592   2.367  1.00 18.61           C  
ATOM   1487  C   ILE   186      49.586  48.655   2.902  1.00 19.53           C  
ATOM   1488  O   ILE   186      49.412  48.540   4.122  1.00 18.61           O  
ATOM   1489  CB  ILE   186      52.028  48.867   2.298  1.00 25.65           C  
ATOM   1490  CG1 ILE   186      52.474  48.403   3.664  1.00 23.08           C  
ATOM   1491  CG2 ILE   186      53.119  49.766   1.611  1.00 32.33           C  
ATOM   1492  CD1 ILE   186      53.373  47.159   3.562  1.00 23.38           C  
ATOM   1493  N   PRO   187      48.855  47.988   1.999  1.00 21.38           N  
ATOM   1494  CA  PRO   187      47.867  47.043   2.502  1.00 15.78           C  
ATOM   1495  C   PRO   187      48.569  45.828   3.087  1.00 20.47           C  
ATOM   1496  O   PRO   187      49.607  45.439   2.576  1.00 16.31           O  
ATOM   1497  CB  PRO   187      47.064  46.657   1.256  1.00 17.27           C  
ATOM   1498  CG  PRO   187      47.952  46.981   0.098  1.00 20.64           C  
ATOM   1499  CD  PRO   187      48.888  48.061   0.519  1.00 18.84           C  
ATOM   1500  N   VAL   188      48.046  45.287   4.183  1.00 18.73           N  
ATOM   1501  CA  VAL   188      48.744  44.218   4.909  1.00 16.69           C  
ATOM   1502  C   VAL   188      47.866  43.014   5.242  1.00 18.23           C  
ATOM   1503  O   VAL   188      48.310  42.075   5.917  1.00 21.16           O  
ATOM   1504  CB  VAL   188      49.437  44.737   6.215  1.00 19.46           C  
ATOM   1505  CG1 VAL   188      50.608  45.617   5.888  1.00 19.96           C  
ATOM   1506  CG2 VAL   188      48.436  45.460   7.141  1.00 15.01           C  
ATOM   1507  N   GLY   189      46.614  43.047   4.783  1.00 16.49           N  
ATOM   1508  CA  GLY   189      45.738  41.913   5.015  1.00 18.91           C  
ATOM   1509  C   GLY   189      44.371  42.407   5.404  1.00 18.87           C  
ATOM   1510  O   GLY   189      44.031  43.575   5.182  1.00 19.08           O  
ATOM   1511  N   ALA   190      43.588  41.519   5.986  1.00 16.54           N  
ATOM   1512  CA  ALA   190      42.232  41.863   6.412  1.00 20.59           C  
ATOM   1513  C   ALA   190      41.818  41.013   7.596  1.00 22.26           C  
ATOM   1514  O   ALA   190      42.310  39.908   7.782  1.00 22.93           O  
ATOM   1515  CB  ALA   190      41.193  41.719   5.252  1.00 17.91           C  
ATOM   1516  N   ILE   191      40.876  41.527   8.372  1.00 18.64           N  
ATOM   1517  CA  ILE   191      40.209  40.733   9.408  1.00 18.43           C  
ATOM   1518  C   ILE   191      38.742  40.564   9.089  1.00 21.37           C  
ATOM   1519  O   ILE   191      38.120  41.492   8.588  1.00 17.81           O  
ATOM   1520  CB  ILE   191      40.403  41.440  10.771  1.00 18.60           C  
ATOM   1521  CG1 ILE   191      41.794  41.129  11.305  1.00 22.38           C  
ATOM   1522  CG2 ILE   191      39.357  41.046  11.813  1.00 22.58           C  
ATOM   1523  CD1 ILE   191      42.241  42.201  12.244  1.00 27.81           C  
ATOM   1524  N   THR   192      38.193  39.370   9.332  1.00 16.15           N  
ATOM   1525  CA  THR   192      36.762  39.137   9.160  0.50 18.17           C  
ATOM   1527  C   THR   192      36.165  38.562  10.457  1.00 22.84           C  
ATOM   1528  O   THR   192      36.755  37.666  11.076  1.00 19.70           O  
ATOM   1529  CB  THR   192      36.505  38.231   7.926  0.50 23.49           C  
ATOM   1531  OG1 THR   192      36.932  38.911   6.737  0.50 21.60           O  
ATOM   1533  CG2 THR   192      35.053  37.898   7.769  0.50 12.87           C  
ATOM   1535  N   TYR   193      35.003  39.065  10.863  1.00 16.92           N  
ATOM   1536  CA  TYR   193      34.320  38.490  12.035  1.00 16.58           C  
ATOM   1537  C   TYR   193      32.832  38.520  11.779  1.00 20.59           C  
ATOM   1538  O   TYR   193      32.369  39.156  10.815  1.00 17.01           O  
ATOM   1539  CB  TYR   193      34.676  39.237  13.327  1.00 18.38           C  
ATOM   1540  CG  TYR   193      34.347  40.713  13.291  1.00 15.91           C  
ATOM   1541  CD1 TYR   193      33.058  41.166  13.568  1.00 20.25           C  
ATOM   1542  CD2 TYR   193      35.328  41.646  12.962  1.00 20.34           C  
ATOM   1543  CE1 TYR   193      32.761  42.513  13.536  1.00 20.52           C  
ATOM   1544  CE2 TYR   193      35.040  43.000  12.920  1.00 19.27           C  
ATOM   1545  CZ  TYR   193      33.755  43.418  13.219  1.00 16.20           C  
ATOM   1546  OH  TYR   193      33.448  44.772  13.151  1.00 20.98           O  
ATOM   1547  N   CYS   194      32.082  37.834  12.631  1.00 17.08           N  
ATOM   1548  CA  CYS   194      30.631  37.908  12.541  1.00 22.60           C  
ATOM   1549  C   CYS   194      30.028  37.871  13.931  1.00 22.09           C  
ATOM   1550  O   CYS   194      30.080  36.838  14.620  1.00 18.58           O  
ATOM   1551  CB  CYS   194      30.050  36.795  11.661  1.00 20.95           C  
ATOM   1552  SG  CYS   194      28.234  36.914  11.524  1.00 23.38           S  
ATOM   1553  N   MET   195      29.462  38.998  14.343  1.00 17.69           N  
ATOM   1554  CA  MET   195      28.851  39.085  15.673  1.00 18.41           C  
ATOM   1555  C   MET   195      27.433  39.597  15.665  1.00 20.71           C  
ATOM   1556  O   MET   195      27.045  40.381  14.778  1.00 20.17           O  
ATOM   1557  CB  MET   195      29.698  39.933  16.620  1.00 18.74           C  
ATOM   1558  CG  MET   195      29.772  41.398  16.224  1.00 25.25           C  
ATOM   1559  SD  MET   195      30.880  42.412  17.429  0.70 30.47          SE  
ATOM   1560  CE  MET   195      30.018  41.990  19.031  1.00 22.83           C  
ATOM   1561  N   GLU   196      26.663  39.172  16.666  1.00 20.84           N  
ATOM   1562  CA  GLU   196      25.352  39.749  16.911  1.00 21.64           C  
ATOM   1563  C   GLU   196      25.582  41.092  17.613  1.00 22.83           C  
ATOM   1564  O   GLU   196      26.303  41.181  18.614  1.00 20.50           O  
ATOM   1565  CB  GLU   196      24.470  38.823  17.761  1.00 21.99           C  
ATOM   1566  CG  GLU   196      23.072  39.424  17.999  1.00 28.14           C  
ATOM   1567  CD  GLU   196      22.005  38.428  18.472  1.00 27.63           C  
ATOM   1568  OE1 GLU   196      22.157  37.202  18.283  1.00 27.80           O  
ATOM   1569  OE2 GLU   196      20.982  38.917  19.004  1.00 38.54           O  
ATOM   1570  N   SER   197      24.962  42.137  17.088  1.00 20.19           N  
ATOM   1571  CA  SER   197      25.125  43.478  17.619  1.00 15.72           C  
ATOM   1572  C   SER   197      23.742  43.912  18.167  1.00 19.33           C  
ATOM   1573  O   SER   197      22.786  43.161  18.009  1.00 18.28           O  
ATOM   1574  CB  SER   197      25.552  44.410  16.490  1.00 18.24           C  
ATOM   1575  OG  SER   197      24.526  44.513  15.506  1.00 20.58           O  
ATOM   1576  N   PRO   198      23.651  45.084  18.836  1.00 19.82           N  
ATOM   1577  CA  PRO   198      22.353  45.521  19.391  1.00 25.01           C  
ATOM   1578  C   PRO   198      21.172  45.509  18.409  1.00 27.78           C  
ATOM   1579  O   PRO   198      20.049  45.138  18.784  1.00 27.26           O  
ATOM   1580  CB  PRO   198      22.640  46.948  19.858  1.00 21.66           C  
ATOM   1581  CG  PRO   198      24.110  46.942  20.199  1.00 25.92           C  
ATOM   1582  CD  PRO   198      24.735  46.026  19.187  1.00 21.79           C  
ATOM   1583  N   ALA   199      21.424  45.881  17.158  1.00 21.66           N  
ATOM   1584  CA  ALA   199      20.334  46.028  16.176  1.00 20.92           C  
ATOM   1585  C   ALA   199      20.302  44.928  15.105  1.00 27.82           C  
ATOM   1586  O   ALA   199      19.410  44.909  14.244  1.00 27.25           O  
ATOM   1587  CB  ALA   199      20.406  47.399  15.539  1.00 23.88           C  
ATOM   1588  N   GLY   200      21.269  44.016  15.139  1.00 21.47           N  
ATOM   1589  CA  GLY   200      21.257  42.919  14.178  1.00 20.08           C  
ATOM   1590  C   GLY   200      22.517  42.076  14.199  1.00 23.27           C  
ATOM   1591  O   GLY   200      22.938  41.612  15.250  1.00 23.02           O  
ATOM   1592  N   ILE   201      23.078  41.891  13.011  1.00 19.61           N  
ATOM   1593  CA  ILE   201      24.189  40.982  12.725  0.50 20.79           C  
ATOM   1595  C   ILE   201      25.253  41.788  11.991  1.00 21.52           C  
ATOM   1596  O   ILE   201      24.917  42.492  11.034  1.00 19.17           O  
ATOM   1597  CB  ILE   201      23.712  39.817  11.789  0.50 19.77           C  
ATOM   1599  CG1 ILE   201      22.825  38.828  12.545  0.50 23.67           C  
ATOM   1601  CG2 ILE   201      24.901  39.052  11.128  0.50 23.88           C  
ATOM   1603  CD1 ILE   201      23.586  37.842  13.400  0.50 30.69           C  
ATOM   1605  N   LYS   202      26.513  41.644  12.395  1.00 17.46           N  
ATOM   1606  CA  LYS   202      27.615  42.393  11.804  1.00 16.91           C  
ATOM   1607  C   LYS   202      28.686  41.412  11.283  1.00 19.03           C  
ATOM   1608  O   LYS   202      29.577  41.041  12.051  1.00 17.60           O  
ATOM   1609  CB  LYS   202      28.244  43.287  12.861  1.00 19.47           C  
ATOM   1610  CG  LYS   202      27.405  44.510  13.236  1.00 15.46           C  
ATOM   1611  CD  LYS   202      28.072  45.440  14.221  1.00 22.65           C  
ATOM   1612  CE  LYS   202      29.321  46.142  13.706  1.00 24.43           C  
ATOM   1613  NZ  LYS   202      29.066  47.055  12.516  1.00 27.31           N  
ATOM   1614  N   PRO   203      28.593  41.006   9.994  1.00 16.72           N  
ATOM   1615  CA  PRO   203      29.596  40.167   9.326  1.00 17.50           C  
ATOM   1616  C   PRO   203      30.545  41.129   8.652  1.00 18.96           C  
ATOM   1617  O   PRO   203      30.338  41.527   7.498  1.00 22.69           O  
ATOM   1618  CB  PRO   203      28.772  39.361   8.315  1.00 23.12           C  
ATOM   1619  CG  PRO   203      27.382  40.061   8.235  1.00 20.40           C  
ATOM   1620  CD  PRO   203      27.492  41.331   9.070  1.00 16.33           C  
ATOM   1621  N   ASP   204      31.554  41.558   9.391  1.00 14.49           N  
ATOM   1622  CA  ASP   204      32.398  42.684   8.939  1.00 18.90           C  
ATOM   1623  C   ASP   204      33.757  42.241   8.446  1.00 19.68           C  
ATOM   1624  O   ASP   204      34.325  41.264   8.944  1.00 19.53           O  
ATOM   1625  CB  ASP   204      32.610  43.701  10.053  1.00 17.03           C  
ATOM   1626  CG  ASP   204      31.314  44.405  10.487  1.00 21.45           C  
ATOM   1627  OD1 ASP   204      30.277  44.283   9.809  1.00 24.51           O  
ATOM   1628  OD2 ASP   204      31.358  45.071  11.528  1.00 25.88           O  
ATOM   1629  N   THR   205      34.267  42.983   7.469  1.00 16.49           N  
ATOM   1630  CA  THR   205      35.645  42.835   6.979  1.00 18.97           C  
ATOM   1631  C   THR   205      36.391  44.138   7.145  1.00 22.03           C  
ATOM   1632  O   THR   205      35.931  45.179   6.680  1.00 20.97           O  
ATOM   1633  CB  THR   205      35.650  42.381   5.527  1.00 20.97           C  
ATOM   1634  OG1 THR   205      35.084  41.066   5.454  1.00 18.93           O  
ATOM   1635  CG2 THR   205      37.050  42.330   4.966  1.00 18.62           C  
ATOM   1636  N   LEU   206      37.530  44.089   7.834  1.00 17.58           N  
ATOM   1637  CA  LEU   206      38.394  45.264   8.026  1.00 17.07           C  
ATOM   1638  C   LEU   206      39.632  45.098   7.186  1.00 19.34           C  
ATOM   1639  O   LEU   206      40.434  44.205   7.447  1.00 19.57           O  
ATOM   1640  CB  LEU   206      38.815  45.454   9.519  1.00 19.70           C  
ATOM   1641  CG  LEU   206      37.830  45.184  10.672  1.00 30.19           C  
ATOM   1642  CD1 LEU   206      38.456  45.413  12.051  1.00 30.63           C  
ATOM   1643  CD2 LEU   206      36.637  46.012  10.534  1.00 34.18           C  
ATOM   1644  N   PHE   207      39.797  45.960   6.190  1.00 15.14           N  
ATOM   1645  CA  PHE   207      41.012  45.982   5.403  1.00 14.18           C  
ATOM   1646  C   PHE   207      42.077  46.767   6.142  1.00 15.69           C  
ATOM   1647  O   PHE   207      41.870  47.911   6.555  1.00 19.26           O  
ATOM   1648  CB  PHE   207      40.737  46.514   3.988  1.00 15.92           C  
ATOM   1649  CG  PHE   207      39.840  45.607   3.185  1.00 19.36           C  
ATOM   1650  CD1 PHE   207      40.348  44.442   2.573  1.00 17.29           C  
ATOM   1651  CD2 PHE   207      38.484  45.899   3.052  1.00 16.61           C  
ATOM   1652  CE1 PHE   207      39.502  43.583   1.817  1.00 15.95           C  
ATOM   1653  CE2 PHE   207      37.653  45.048   2.310  1.00 18.64           C  
ATOM   1654  CZ  PHE   207      38.160  43.894   1.703  1.00 21.53           C  
ATOM   1655  N   LEU   208      43.247  46.163   6.259  1.00 16.02           N  
ATOM   1656  CA  LEU   208      44.265  46.699   7.147  1.00 16.18           C  
ATOM   1657  C   LEU   208      45.422  47.286   6.362  1.00 15.99           C  
ATOM   1658  O   LEU   208      45.801  46.761   5.317  1.00 17.80           O  
ATOM   1659  CB  LEU   208      44.773  45.584   8.056  1.00 17.30           C  
ATOM   1660  CG  LEU   208      43.666  44.740   8.702  1.00 21.82           C  
ATOM   1661  CD1 LEU   208      44.249  43.562   9.423  1.00 24.62           C  
ATOM   1662  CD2 LEU   208      42.840  45.588   9.656  1.00 21.41           C  
ATOM   1663  N   TYR   209      45.954  48.390   6.877  1.00 16.64           N  
ATOM   1664  CA  TYR   209      47.074  49.114   6.254  1.00 13.20           C  
ATOM   1665  C   TYR   209      48.103  49.478   7.319  1.00 18.91           C  
ATOM   1666  O   TYR   209      47.733  49.720   8.469  1.00 17.11           O  
ATOM   1667  CB  TYR   209      46.541  50.406   5.583  1.00 19.14           C  
ATOM   1668  CG  TYR   209      45.645  50.126   4.407  1.00 14.54           C  
ATOM   1669  CD1 TYR   209      46.130  50.167   3.107  1.00 16.75           C  
ATOM   1670  CD2 TYR   209      44.278  49.801   4.595  1.00 21.68           C  
ATOM   1671  CE1 TYR   209      45.281  49.903   1.991  1.00 21.68           C  
ATOM   1672  CE2 TYR   209      43.439  49.519   3.496  1.00 21.31           C  
ATOM   1673  CZ  TYR   209      43.959  49.570   2.209  1.00 20.17           C  
ATOM   1674  OH  TYR   209      43.129  49.283   1.152  1.00 21.68           O  
ATOM   1675  N   ASP   210      49.384  49.472   6.942  1.00 17.51           N  
ATOM   1676  CA  ASP   210      50.474  49.899   7.816  1.00 20.05           C  
ATOM   1677  C   ASP   210      51.129  51.115   7.175  1.00 19.12           C  
ATOM   1678  O   ASP   210      51.344  51.150   5.939  1.00 21.30           O  
ATOM   1679  CB  ASP   210      51.578  48.821   7.908  1.00 17.73           C  
ATOM   1680  CG  ASP   210      51.330  47.777   8.969  1.00 23.66           C  
ATOM   1681  OD1 ASP   210      50.234  47.740   9.580  1.00 19.71           O  
ATOM   1682  OD2 ASP   210      52.246  46.941   9.154  1.00 19.66           O  
ATOM   1683  N   LEU   211      51.483  52.081   8.014  1.00 21.44           N  
ATOM   1684  CA  LEU   211      52.293  53.218   7.583  1.00 19.60           C  
ATOM   1685  C   LEU   211      53.371  53.590   8.618  1.00 28.52           C  
ATOM   1686  O   LEU   211      53.047  53.917   9.773  1.00 25.01           O  
ATOM   1687  CB  LEU   211      51.396  54.433   7.289  1.00 21.33           C  
ATOM   1688  CG  LEU   211      52.079  55.711   6.778  1.00 23.75           C  
ATOM   1689  CD1 LEU   211      52.892  55.427   5.515  1.00 28.56           C  
ATOM   1690  CD2 LEU   211      51.050  56.768   6.486  1.00 21.28           C  
ATOM   1691  N   ALA   212      54.636  53.535   8.184  1.00 24.81           N  
ATOM   1692  CA  ALA   212      55.787  54.018   8.964  1.00 29.85           C  
ATOM   1693  C   ALA   212      55.828  55.527   8.798  1.00 29.57           C  
ATOM   1694  O   ALA   212      56.058  56.036   7.697  1.00 32.92           O  
ATOM   1695  CB  ALA   212      57.068  53.405   8.459  1.00 27.38           C  
ATOM   1696  N   LEU   213      55.551  56.239   9.876  1.00 25.42           N  
ATOM   1697  CA  LEU   213      55.416  57.697   9.832  1.00 25.21           C  
ATOM   1698  C   LEU   213      56.746  58.407  10.143  1.00 33.84           C  
ATOM   1699  O   LEU   213      57.605  57.834  10.822  1.00 36.56           O  
ATOM   1700  CB  LEU   213      54.344  58.147  10.814  1.00 25.79           C  
ATOM   1701  CG  LEU   213      52.903  57.810  10.408  1.00 27.39           C  
ATOM   1702  CD1 LEU   213      51.998  57.831  11.609  1.00 22.21           C  
ATOM   1703  CD2 LEU   213      52.419  58.783   9.358  1.00 32.76           C  
ATOM   1704  N   PRO   214      56.921  59.654   9.646  1.00 36.16           N  
ATOM   1705  CA  PRO   214      58.100  60.427  10.057  1.00 39.31           C  
ATOM   1706  C   PRO   214      58.066  60.728  11.559  1.00 34.96           C  
ATOM   1707  O   PRO   214      56.983  60.938  12.125  1.00 32.07           O  
ATOM   1708  CB  PRO   214      57.956  61.741   9.269  1.00 37.83           C  
ATOM   1709  CG  PRO   214      57.019  61.437   8.155  1.00 42.05           C  
ATOM   1710  CD  PRO   214      56.072  60.421   8.720  1.00 34.03           C  
ATOM   1711  N   GLU   215      59.244  60.772  12.182  1.00 38.88           N  
ATOM   1712  CA  GLU   215      59.400  61.115  13.605  1.00 42.52           C  
ATOM   1713  C   GLU   215      58.699  62.427  13.981  1.00 40.78           C  
ATOM   1714  O   GLU   215      58.184  62.559  15.092  1.00 41.45           O  
ATOM   1715  CB  GLU   215      60.889  61.205  13.984  1.00 47.40           C  
ATOM   1716  CG  GLU   215      61.675  59.879  13.903  1.00 61.85           C  
ATOM   1717  CD  GLU   215      61.590  59.037  15.173  1.00 71.62           C  
ATOM   1718  OE1 GLU   215      61.330  59.612  16.254  1.00 77.66           O  
ATOM   1719  OE2 GLU   215      61.789  57.799  15.091  1.00 66.95           O  
ATOM   1720  N   ASP   216      58.667  63.374  13.043  1.00 40.78           N  
ATOM   1721  CA  ASP   216      58.096  64.696  13.291  1.00 42.30           C  
ATOM   1722  C   ASP   216      56.617  64.850  12.910  1.00 42.05           C  
ATOM   1723  O   ASP   216      56.042  65.911  13.149  1.00 40.61           O  
ATOM   1724  CB  ASP   216      58.958  65.813  12.665  1.00 47.09           C  
ATOM   1725  CG  ASP   216      58.932  65.811  11.131  1.00 58.78           C  
ATOM   1726  OD1 ASP   216      58.804  64.731  10.514  1.00 70.12           O  
ATOM   1727  OD2 ASP   216      59.056  66.903  10.535  1.00 58.84           O  
ATOM   1728  N   PHE   217      55.990  63.813  12.342  1.00 33.84           N  
ATOM   1729  CA  PHE   217      54.531  63.879  12.124  1.00 28.76           C  
ATOM   1730  C   PHE   217      53.736  63.857  13.447  1.00 28.64           C  
ATOM   1731  O   PHE   217      54.063  63.107  14.375  1.00 33.24           O  
ATOM   1732  CB  PHE   217      54.032  62.756  11.171  1.00 31.39           C  
ATOM   1733  CG  PHE   217      52.537  62.770  10.970  1.00 34.89           C  
ATOM   1734  CD1 PHE   217      51.953  63.682  10.090  1.00 31.80           C  
ATOM   1735  CD2 PHE   217      51.708  61.919  11.707  1.00 30.13           C  
ATOM   1736  CE1 PHE   217      50.574  63.734   9.928  1.00 35.26           C  
ATOM   1737  CE2 PHE   217      50.343  61.968  11.554  1.00 26.65           C  
ATOM   1738  CZ  PHE   217      49.767  62.879  10.664  1.00 30.87           C  
ATOM   1739  N   ARG   218      52.701  64.691  13.531  1.00 30.24           N  
ATOM   1740  CA  ARG   218      51.765  64.675  14.649  1.00 33.07           C  
ATOM   1741  C   ARG   218      50.362  64.664  14.087  1.00 33.27           C  
ATOM   1742  O   ARG   218      50.005  65.570  13.349  1.00 30.02           O  
ATOM   1743  CB  ARG   218      51.913  65.918  15.548  1.00 36.17           C  
ATOM   1744  CG  ARG   218      53.292  66.156  16.149  1.00 38.66           C  
ATOM   1745  CD  ARG   218      53.636  65.164  17.279  1.00 44.01           C  
ATOM   1746  NE  ARG   218      54.971  65.428  17.825  1.00 50.41           N  
ATOM   1747  CZ  ARG   218      56.105  64.916  17.348  1.00 48.17           C  
ATOM   1748  NH1 ARG   218      56.091  64.081  16.319  1.00 53.09           N  
ATOM   1749  NH2 ARG   218      57.263  65.226  17.916  1.00 52.78           N  
ATOM   1750  N   PRO   219      49.551  63.642  14.425  1.00 32.18           N  
ATOM   1751  CA  PRO   219      48.154  63.704  13.986  1.00 28.77           C  
ATOM   1752  C   PRO   219      47.327  64.817  14.674  1.00 35.00           C  
ATOM   1753  O   PRO   219      47.516  65.087  15.867  1.00 35.22           O  
ATOM   1754  CB  PRO   219      47.602  62.299  14.338  1.00 26.16           C  
ATOM   1755  CG  PRO   219      48.499  61.797  15.400  1.00 29.84           C  
ATOM   1756  CD  PRO   219      49.859  62.389  15.144  1.00 29.45           C  
ATOM   1757  N   HIS   220      46.438  65.469  13.920  1.00 30.48           N  
ATOM   1758  CA  HIS   220      45.476  66.413  14.512  1.00 32.09           C  
ATOM   1759  C   HIS   220      44.077  66.058  14.111  1.00 30.14           C  
ATOM   1760  O   HIS   220      43.835  65.693  12.971  1.00 30.55           O  
ATOM   1761  CB  HIS   220      45.781  67.860  14.106  1.00 37.92           C  
ATOM   1762  CG  HIS   220      47.209  68.246  14.322  1.00 41.04           C  
ATOM   1763  ND1 HIS   220      48.122  68.330  13.293  1.00 50.01           N  
ATOM   1764  CD2 HIS   220      47.894  68.530  15.457  1.00 45.11           C  
ATOM   1765  CE1 HIS   220      49.305  68.660  13.781  1.00 40.41           C  
ATOM   1766  NE2 HIS   220      49.194  68.786  15.092  1.00 44.64           N  
ATOM   1767  N   ASN   221      43.153  66.229  15.047  1.00 25.59           N  
ATOM   1768  CA  ASN   221      41.767  65.783  14.921  1.00 31.42           C  
ATOM   1769  C   ASN   221      40.854  66.733  14.118  1.00 34.72           C  
ATOM   1770  O   ASN   221      39.805  67.183  14.617  1.00 40.74           O  
ATOM   1771  CB  ASN   221      41.192  65.500  16.330  1.00 32.04           C  
ATOM   1772  CG  ASN   221      41.034  66.778  17.195  1.00 41.90           C  
ATOM   1773  OD1 ASN   221      41.773  67.752  17.028  1.00 42.49           O  
ATOM   1774  ND2 ASN   221      40.056  66.768  18.105  1.00 30.00           N  
ATOM   1775  N   THR   222      41.229  66.990  12.866  1.00 34.65           N  
ATOM   1776  CA  THR   222      40.516  67.939  11.978  1.00 37.42           C  
ATOM   1777  C   THR   222      38.978  67.898  12.029  1.00 39.37           C  
ATOM   1778  O   THR   222      38.344  68.925  12.252  1.00 40.20           O  
ATOM   1779  CB  THR   222      41.007  67.833  10.506  1.00 40.30           C  
ATOM   1780  OG1 THR   222      42.441  67.862  10.475  1.00 38.41           O  
ATOM   1781  CG2 THR   222      40.467  68.991   9.654  1.00 37.82           C  
ATOM   1782  N   ASP   223      38.375  66.725  11.856  1.00 33.08           N  
ATOM   1783  CA  ASP   223      36.914  66.646  11.873  1.00 36.16           C  
ATOM   1784  C   ASP   223      36.279  66.357  13.243  1.00 36.45           C  
ATOM   1785  O   ASP   223      35.053  66.241  13.343  1.00 38.37           O  
ATOM   1786  CB  ASP   223      36.392  65.690  10.786  1.00 37.98           C  
ATOM   1787  CG  ASP   223      36.618  64.223  11.118  1.00 42.50           C  
ATOM   1788  OD1 ASP   223      37.293  63.886  12.122  1.00 34.80           O  
ATOM   1789  OD2 ASP   223      36.106  63.402  10.344  1.00 36.90           O  
ATOM   1790  N   GLY   224      37.111  66.244  14.282  1.00 35.55           N  
ATOM   1791  CA  GLY   224      36.630  66.034  15.654  1.00 36.89           C  
ATOM   1792  C   GLY   224      36.020  64.671  15.976  1.00 36.39           C  
ATOM   1793  O   GLY   224      35.449  64.482  17.054  1.00 40.38           O  
ATOM   1794  N   GLU   225      36.125  63.723  15.042  1.00 32.74           N  
ATOM   1795  CA  GLU   225      35.722  62.336  15.276  1.00 33.39           C  
ATOM   1796  C   GLU   225      36.597  61.697  16.367  1.00 31.95           C  
ATOM   1797  O   GLU   225      36.143  60.836  17.113  1.00 26.70           O  
ATOM   1798  CB  GLU   225      35.884  61.520  13.996  1.00 34.72           C  
ATOM   1799  CG  GLU   225      34.769  61.677  12.971  1.00 35.77           C  
ATOM   1800  CD  GLU   225      34.913  60.657  11.831  1.00 48.02           C  
ATOM   1801  OE1 GLU   225      34.275  59.583  11.894  1.00 36.79           O  
ATOM   1802  OE2 GLU   225      35.692  60.911  10.885  1.00 46.05           O  
ATOM   1803  N   MET   226      37.861  62.104  16.409  1.00 30.60           N  
ATOM   1804  CA  MET   226      38.780  61.764  17.497  1.00 33.62           C  
ATOM   1805  C   MET   226      38.879  62.927  18.495  1.00 35.35           C  
ATOM   1806  O   MET   226      39.017  64.078  18.089  1.00 34.95           O  
ATOM   1807  CB  MET   226      40.182  61.499  16.949  1.00 30.26           C  
ATOM   1808  CG  MET   226      40.305  60.311  16.011  1.00 38.22           C  
ATOM   1809  SD  MET   226      39.791  58.599  16.819  0.70 33.77          SE  
ATOM   1810  CE  MET   226      40.212  57.510  15.238  1.00 43.66           C  
ATOM   1811  N   ALA   227      38.835  62.611  19.788  1.00 30.11           N  
ATOM   1812  CA  ALA   227      39.070  63.585  20.851  1.00 30.34           C  
ATOM   1813  C   ALA   227      40.531  64.052  20.907  1.00 38.31           C  
ATOM   1814  O   ALA   227      40.797  65.253  21.065  1.00 39.38           O  
ATOM   1815  CB  ALA   227      38.624  63.028  22.201  1.00 32.23           C  
ATOM   1816  N   ASP   228      41.459  63.100  20.764  1.00 29.95           N  
ATOM   1817  CA  ASP   228      42.897  63.383  20.736  0.50 32.07           C  
ATOM   1819  C   ASP   228      43.640  62.133  20.291  1.00 31.14           C  
ATOM   1820  O   ASP   228      43.016  61.111  19.979  1.00 30.62           O  
ATOM   1821  CB  ASP   228      43.422  63.840  22.108  0.50 37.97           C  
ATOM   1823  CG  ASP   228      43.307  62.764  23.162  0.50 37.14           C  
ATOM   1825  OD1 ASP   228      42.167  62.425  23.532  0.50 39.67           O  
ATOM   1827  OD2 ASP   228      44.356  62.264  23.619  0.50 48.07           O  
ATOM   1829  N   PHE   229      44.961  62.237  20.221  1.00 23.57           N  
ATOM   1830  CA  PHE   229      45.842  61.157  19.805  1.00 28.22           C  
ATOM   1831  C   PHE   229      46.978  60.986  20.814  1.00 32.28           C  
ATOM   1832  O   PHE   229      47.356  61.956  21.464  1.00 29.69           O  
ATOM   1833  CB  PHE   229      46.454  61.481  18.450  1.00 27.21           C  
ATOM   1834  CG  PHE   229      45.462  61.500  17.324  1.00 28.89           C  
ATOM   1835  CD1 PHE   229      45.107  60.316  16.674  1.00 25.77           C  
ATOM   1836  CD2 PHE   229      44.905  62.698  16.895  1.00 29.22           C  
ATOM   1837  CE1 PHE   229      44.203  60.321  15.640  1.00 25.83           C  
ATOM   1838  CE2 PHE   229      43.985  62.718  15.846  1.00 29.84           C  
ATOM   1839  CZ  PHE   229      43.626  61.523  15.225  1.00 23.27           C  
ATOM   1840  N   MET   230      47.504  59.761  20.943  1.00 30.54           N  
ATOM   1841  CA  MET   230      48.633  59.475  21.839  0.50 31.97           C  
ATOM   1843  C   MET   230      49.613  58.548  21.148  1.00 32.95           C  
ATOM   1844  O   MET   230      49.212  57.668  20.384  1.00 30.38           O  
ATOM   1845  CB  MET   230      48.170  58.804  23.139  0.50 29.98           C  
ATOM   1847  CG  MET   230      47.326  59.655  24.086  0.50 30.10           C  
ATOM   1849  SD  MET   230      46.461  58.547  25.462  0.35 35.81          SE  
ATOM   1851  CE  MET   230      45.786  57.198  24.278  0.50  9.41           C  
ATOM   1853  N   LEU   231      50.903  58.740  21.417  1.00 26.63           N  
ATOM   1854  CA  LEU   231      51.928  57.875  20.870  1.00 24.90           C  
ATOM   1855  C   LEU   231      52.402  56.944  21.983  1.00 32.60           C  
ATOM   1856  O   LEU   231      52.984  57.400  22.973  1.00 27.40           O  
ATOM   1857  CB  LEU   231      53.092  58.697  20.318  1.00 22.14           C  
ATOM   1858  CG  LEU   231      54.213  57.917  19.627  1.00 27.92           C  
ATOM   1859  CD1 LEU   231      53.690  57.195  18.374  1.00 31.77           C  
ATOM   1860  CD2 LEU   231      55.354  58.858  19.235  1.00 34.90           C  
ATOM   1861  N   TRP   232      52.153  55.643  21.825  1.00 26.63           N  
ATOM   1862  CA  TRP   232      52.468  54.657  22.873  1.00 27.49           C  
ATOM   1863  C   TRP   232      53.463  53.641  22.351  1.00 24.44           C  
ATOM   1864  O   TRP   232      53.424  53.335  21.153  1.00 24.35           O  
ATOM   1865  CB  TRP   232      51.214  53.888  23.242  1.00 25.56           C  
ATOM   1866  CG  TRP   232      50.254  54.542  24.163  1.00 33.99           C  
ATOM   1867  CD1 TRP   232      50.243  55.857  24.583  1.00 30.32           C  
ATOM   1868  CD2 TRP   232      49.111  53.920  24.754  1.00 30.78           C  
ATOM   1869  NE1 TRP   232      49.172  56.067  25.416  1.00 28.93           N  
ATOM   1870  CE2 TRP   232      48.459  54.899  25.537  1.00 33.17           C  
ATOM   1871  CE3 TRP   232      48.592  52.611  24.734  1.00 25.26           C  
ATOM   1872  CZ2 TRP   232      47.301  54.615  26.278  1.00 33.10           C  
ATOM   1873  CZ3 TRP   232      47.429  52.341  25.462  1.00 31.07           C  
ATOM   1874  CH2 TRP   232      46.803  53.334  26.220  1.00 29.08           C  
ATOM   1875  N   PRO   233      54.330  53.081  23.229  1.00 25.37           N  
ATOM   1876  CA  PRO   233      55.152  51.969  22.783  1.00 26.06           C  
ATOM   1877  C   PRO   233      54.231  50.848  22.323  1.00 24.38           C  
ATOM   1878  O   PRO   233      53.160  50.647  22.927  1.00 22.96           O  
ATOM   1879  CB  PRO   233      55.902  51.547  24.060  1.00 29.18           C  
ATOM   1880  CG  PRO   233      55.941  52.785  24.901  1.00 28.56           C  
ATOM   1881  CD  PRO   233      54.598  53.424  24.647  1.00 28.32           C  
ATOM   1882  N   ALA   234      54.615  50.163  21.250  1.00 23.20           N  
ATOM   1883  CA  ALA   234      53.779  49.101  20.681  1.00 25.59           C  
ATOM   1884  C   ALA   234      53.388  48.077  21.749  1.00 22.71           C  
ATOM   1885  O   ALA   234      52.225  47.682  21.809  1.00 21.44           O  
ATOM   1886  CB  ALA   234      54.464  48.417  19.496  1.00 27.69           C  
ATOM   1887  N   ALA   235      54.338  47.677  22.603  1.00 25.08           N  
ATOM   1888  CA  ALA   235      54.065  46.687  23.659  1.00 23.69           C  
ATOM   1889  C   ALA   235      52.959  47.126  24.629  1.00 24.83           C  
ATOM   1890  O   ALA   235      52.156  46.305  25.065  1.00 23.63           O  
ATOM   1891  CB  ALA   235      55.343  46.309  24.415  1.00 29.81           C  
ATOM   1892  N   LYS   236      52.898  48.420  24.935  1.00 24.16           N  
ATOM   1893  CA  LYS   236      51.849  48.978  25.790  1.00 27.58           C  
ATOM   1894  C   LYS   236      50.451  48.847  25.143  1.00 21.12           C  
ATOM   1895  O   LYS   236      49.450  48.578  25.825  1.00 22.07           O  
ATOM   1896  CB  LYS   236      52.180  50.448  26.117  1.00 26.72           C  
ATOM   1897  CG  LYS   236      51.190  51.123  27.037  1.00 30.02           C  
ATOM   1898  CD  LYS   236      51.459  52.607  27.212  1.00 37.84           C  
ATOM   1899  CE  LYS   236      50.410  53.245  28.131  1.00 45.71           C  
ATOM   1900  NZ  LYS   236      50.697  54.688  28.391  1.00 44.63           N  
ATOM   1901  N   VAL   237      50.386  49.019  23.816  1.00 21.52           N  
ATOM   1902  CA  VAL   237      49.122  48.858  23.075  1.00 19.23           C  
ATOM   1903  C   VAL   237      48.692  47.392  23.125  1.00 17.87           C  
ATOM   1904  O   VAL   237      47.555  47.073  23.417  1.00 19.86           O  
ATOM   1905  CB  VAL   237      49.262  49.352  21.594  1.00 21.36           C  
ATOM   1906  CG1 VAL   237      47.994  49.054  20.745  1.00 21.80           C  
ATOM   1907  CG2 VAL   237      49.561  50.862  21.578  1.00 19.94           C  
ATOM   1908  N   VAL   238      49.638  46.515  22.828  1.00 15.89           N  
ATOM   1909  CA  VAL   238      49.356  45.083  22.794  1.00 17.55           C  
ATOM   1910  C   VAL   238      48.889  44.625  24.185  1.00 18.38           C  
ATOM   1911  O   VAL   238      47.898  43.906  24.296  1.00 17.12           O  
ATOM   1912  CB  VAL   238      50.579  44.302  22.299  1.00 20.65           C  
ATOM   1913  CG1 VAL   238      50.349  42.779  22.475  1.00 17.40           C  
ATOM   1914  CG2 VAL   238      50.879  44.646  20.838  1.00 22.23           C  
ATOM   1915  N   GLU   239      49.575  45.053  25.254  1.00 20.45           N  
ATOM   1916  CA  GLU   239      49.154  44.644  26.606  1.00 19.51           C  
ATOM   1917  C   GLU   239      47.828  45.270  27.046  1.00 17.58           C  
ATOM   1918  O   GLU   239      47.054  44.633  27.746  1.00 19.73           O  
ATOM   1919  CB  GLU   239      50.231  44.906  27.659  1.00 18.69           C  
ATOM   1920  CG  GLU   239      51.537  44.178  27.372  1.00 18.82           C  
ATOM   1921  CD  GLU   239      51.459  42.647  27.407  1.00 23.22           C  
ATOM   1922  OE1 GLU   239      50.465  42.043  27.875  1.00 29.15           O  
ATOM   1923  OE2 GLU   239      52.440  42.036  26.965  1.00 26.04           O  
ATOM   1924  N   ALA   240      47.560  46.498  26.609  1.00 18.60           N  
ATOM   1925  CA  ALA   240      46.227  47.090  26.833  1.00 18.75           C  
ATOM   1926  C   ALA   240      45.097  46.233  26.209  1.00 21.18           C  
ATOM   1927  O   ALA   240      44.067  46.000  26.831  1.00 17.62           O  
ATOM   1928  CB  ALA   240      46.183  48.550  26.332  1.00 18.84           C  
ATOM   1929  N   VAL   241      45.310  45.713  25.002  1.00 19.17           N  
ATOM   1930  CA  VAL   241      44.324  44.848  24.381  1.00 16.76           C  
ATOM   1931  C   VAL   241      44.267  43.498  25.112  1.00 15.47           C  
ATOM   1932  O   VAL   241      43.178  42.958  25.346  1.00 18.92           O  
ATOM   1933  CB  VAL   241      44.643  44.686  22.855  1.00 20.22           C  
ATOM   1934  CG1 VAL   241      43.787  43.559  22.183  1.00 17.92           C  
ATOM   1935  CG2 VAL   241      44.413  46.033  22.172  1.00 14.08           C  
ATOM   1936  N   ARG   242      45.422  42.960  25.515  1.00 14.46           N  
ATOM   1937  CA  ARG   242      45.425  41.642  26.181  1.00 16.30           C  
ATOM   1938  C   ARG   242      44.592  41.660  27.459  1.00 18.93           C  
ATOM   1939  O   ARG   242      43.795  40.741  27.716  1.00 21.27           O  
ATOM   1940  CB  ARG   242      46.864  41.171  26.494  1.00 15.30           C  
ATOM   1941  CG  ARG   242      46.889  39.763  27.067  1.00 16.78           C  
ATOM   1942  CD  ARG   242      48.226  39.519  27.784  1.00 22.29           C  
ATOM   1943  NE  ARG   242      49.335  39.487  26.843  1.00 20.03           N  
ATOM   1944  CZ  ARG   242      49.637  38.449  26.058  1.00 21.15           C  
ATOM   1945  NH1 ARG   242      48.907  37.328  26.050  1.00 21.56           N  
ATOM   1946  NH2 ARG   242      50.687  38.534  25.272  1.00 19.17           N  
ATOM   1947  N   THR   243      44.715  42.746  28.226  1.00 18.75           N  
ATOM   1948  CA  THR   243      44.213  42.720  29.582  1.00 20.29           C  
ATOM   1949  C   THR   243      43.134  43.725  29.948  1.00 20.77           C  
ATOM   1950  O   THR   243      42.682  43.716  31.088  1.00 20.63           O  
ATOM   1951  CB  THR   243      45.375  42.827  30.613  1.00 23.74           C  
ATOM   1952  OG1 THR   243      46.034  44.069  30.452  1.00 29.54           O  
ATOM   1953  CG2 THR   243      46.376  41.733  30.398  1.00 27.63           C  
ATOM   1954  N   THR   244      42.724  44.592  29.014  1.00 19.31           N  
ATOM   1955  CA  THR   244      41.730  45.624  29.312  1.00 20.53           C  
ATOM   1956  C   THR   244      40.672  45.705  28.197  1.00 24.18           C  
ATOM   1957  O   THR   244      40.803  45.067  27.141  1.00 19.20           O  
ATOM   1958  CB  THR   244      42.349  47.061  29.504  1.00 21.98           C  
ATOM   1959  OG1 THR   244      42.659  47.636  28.232  1.00 20.95           O  
ATOM   1960  CG2 THR   244      43.608  47.072  30.385  1.00 22.52           C  
ATOM   1961  N   GLU   245      39.649  46.532  28.423  1.00 22.28           N  
ATOM   1962  CA  GLU   245      38.659  46.803  27.380  1.00 21.28           C  
ATOM   1963  C   GLU   245      38.762  48.249  26.933  1.00 22.53           C  
ATOM   1964  O   GLU   245      37.759  48.847  26.603  1.00 22.94           O  
ATOM   1965  CB  GLU   245      37.243  46.518  27.900  1.00 25.72           C  
ATOM   1966  CG  GLU   245      37.013  45.108  28.390  1.00 29.04           C  
ATOM   1967  CD  GLU   245      36.556  44.167  27.293  1.00 39.66           C  
ATOM   1968  OE1 GLU   245      36.793  44.438  26.084  1.00 43.88           O  
ATOM   1969  OE2 GLU   245      35.930  43.148  27.639  1.00 34.03           O  
ATOM   1970  N   ALA   246      39.976  48.799  26.936  1.00 18.23           N  
ATOM   1971  CA  ALA   246      40.195  50.198  26.597  1.00 23.71           C  
ATOM   1972  C   ALA   246      39.887  50.482  25.118  1.00 25.82           C  
ATOM   1973  O   ALA   246      39.454  51.582  24.780  1.00 23.44           O  
ATOM   1974  CB  ALA   246      41.633  50.571  26.876  1.00 21.63           C  
ATOM   1975  N   PHE   247      40.124  49.490  24.248  1.00 20.81           N  
ATOM   1976  CA  PHE   247      39.980  49.691  22.795  1.00 20.54           C  
ATOM   1977  C   PHE   247      38.572  49.387  22.298  1.00 21.57           C  
ATOM   1978  O   PHE   247      37.861  48.501  22.835  1.00 21.62           O  
ATOM   1979  CB  PHE   247      41.037  48.883  22.019  1.00 17.15           C  
ATOM   1980  CG  PHE   247      42.407  49.520  22.021  1.00 24.57           C  
ATOM   1981  CD1 PHE   247      42.832  50.293  20.932  1.00 22.20           C  
ATOM   1982  CD2 PHE   247      43.256  49.386  23.128  1.00 20.78           C  
ATOM   1983  CE1 PHE   247      44.094  50.901  20.935  1.00 24.41           C  
ATOM   1984  CE2 PHE   247      44.516  49.983  23.134  1.00 24.91           C  
ATOM   1985  CZ  PHE   247      44.928  50.753  22.045  1.00 21.88           C  
ATOM   1986  N   LYS   248      38.157  50.113  21.258  1.00 19.66           N  
ATOM   1987  CA  LYS   248      36.895  49.781  20.572  1.00 15.71           C  
ATOM   1988  C   LYS   248      36.908  48.307  20.192  1.00 17.36           C  
ATOM   1989  O   LYS   248      37.957  47.775  19.831  1.00 16.16           O  
ATOM   1990  CB  LYS   248      36.785  50.665  19.313  1.00 20.31           C  
ATOM   1991  CG  LYS   248      35.653  50.308  18.350  1.00 19.58           C  
ATOM   1992  CD  LYS   248      35.383  51.525  17.446  1.00 20.79           C  
ATOM   1993  CE  LYS   248      34.446  51.169  16.277  1.00 19.70           C  
ATOM   1994  NZ  LYS   248      35.252  50.527  15.166  1.00 22.92           N  
ATOM   1995  N   PHE   249      35.758  47.644  20.279  1.00 16.33           N  
ATOM   1996  CA  PHE   249      35.678  46.156  20.219  1.00 16.95           C  
ATOM   1997  C   PHE   249      36.470  45.499  19.069  1.00 17.92           C  
ATOM   1998  O   PHE   249      37.251  44.547  19.278  1.00 20.40           O  
ATOM   1999  CB  PHE   249      34.203  45.693  20.232  1.00 17.22           C  
ATOM   2000  CG  PHE   249      33.419  46.084  18.995  1.00 27.57           C  
ATOM   2001  CD1 PHE   249      33.226  45.166  17.948  1.00 23.89           C  
ATOM   2002  CD2 PHE   249      32.841  47.348  18.884  1.00 34.84           C  
ATOM   2003  CE1 PHE   249      32.526  45.533  16.794  1.00 24.40           C  
ATOM   2004  CE2 PHE   249      32.121  47.707  17.741  1.00 29.75           C  
ATOM   2005  CZ  PHE   249      31.971  46.811  16.697  1.00 29.91           C  
ATOM   2006  N   ASN   250      36.319  46.021  17.857  1.00 17.89           N  
ATOM   2007  CA  ASN   250      36.948  45.377  16.717  1.00 18.87           C  
ATOM   2008  C   ASN   250      38.357  45.863  16.478  1.00 19.30           C  
ATOM   2009  O   ASN   250      39.125  45.186  15.831  1.00 17.61           O  
ATOM   2010  CB  ASN   250      36.074  45.436  15.463  1.00 19.36           C  
ATOM   2011  CG  ASN   250      35.623  46.859  15.113  1.00 26.18           C  
ATOM   2012  OD1 ASN   250      36.006  47.833  15.762  1.00 21.97           O  
ATOM   2013  ND2 ASN   250      34.794  46.966  14.082  1.00 23.76           N  
ATOM   2014  N   VAL   251      38.705  47.014  17.053  1.00 17.26           N  
ATOM   2015  CA  VAL   251      40.090  47.489  17.021  1.00 17.67           C  
ATOM   2016  C   VAL   251      41.045  46.546  17.793  1.00 15.70           C  
ATOM   2017  O   VAL   251      42.209  46.395  17.416  1.00 20.55           O  
ATOM   2018  CB  VAL   251      40.213  48.959  17.474  1.00 18.07           C  
ATOM   2019  CG1 VAL   251      41.693  49.419  17.429  1.00 19.60           C  
ATOM   2020  CG2 VAL   251      39.326  49.855  16.598  1.00 20.52           C  
ATOM   2021  N   ASN   252      40.554  45.898  18.853  1.00 16.54           N  
ATOM   2022  CA  ASN   252      41.300  44.796  19.520  1.00 19.17           C  
ATOM   2023  C   ASN   252      41.835  43.794  18.486  1.00 17.97           C  
ATOM   2024  O   ASN   252      43.016  43.390  18.550  1.00 13.67           O  
ATOM   2025  CB  ASN   252      40.427  44.044  20.518  1.00 16.95           C  
ATOM   2026  CG  ASN   252      40.085  44.874  21.712  1.00 21.39           C  
ATOM   2027  OD1 ASN   252      40.966  45.357  22.403  1.00 21.20           O  
ATOM   2028  ND2 ASN   252      38.796  45.077  21.939  1.00 18.46           N  
ATOM   2029  N   LEU   253      40.979  43.415  17.544  1.00 16.65           N  
ATOM   2030  CA  LEU   253      41.404  42.493  16.468  1.00 19.56           C  
ATOM   2031  C   LEU   253      42.543  43.033  15.601  1.00 16.73           C  
ATOM   2032  O   LEU   253      43.489  42.301  15.315  1.00 18.19           O  
ATOM   2033  CB  LEU   253      40.229  42.022  15.603  1.00 18.12           C  
ATOM   2034  CG  LEU   253      38.922  41.578  16.300  1.00 20.48           C  
ATOM   2035  CD1 LEU   253      37.904  41.116  15.291  1.00 21.68           C  
ATOM   2036  CD2 LEU   253      39.152  40.512  17.330  1.00 20.21           C  
ATOM   2037  N   THR   254      42.473  44.311  15.194  1.00 15.24           N  
ATOM   2038  CA  THR   254      43.556  44.925  14.404  1.00 18.27           C  
ATOM   2039  C   THR   254      44.865  44.978  15.187  1.00 16.83           C  
ATOM   2040  O   THR   254      45.934  44.825  14.612  1.00 17.38           O  
ATOM   2041  CB  THR   254      43.206  46.367  13.943  1.00 21.69           C  
ATOM   2042  OG1 THR   254      43.306  47.269  15.053  1.00 19.60           O  
ATOM   2043  CG2 THR   254      41.784  46.421  13.327  1.00 18.91           C  
ATOM   2044  N   VAL   255      44.787  45.190  16.513  1.00 16.92           N  
ATOM   2045  CA  VAL   255      46.014  45.184  17.332  1.00 20.44           C  
ATOM   2046  C   VAL   255      46.648  43.772  17.414  1.00 16.81           C  
ATOM   2047  O   VAL   255      47.861  43.602  17.301  1.00 15.75           O  
ATOM   2048  CB  VAL   255      45.729  45.717  18.762  1.00 23.19           C  
ATOM   2049  CG1 VAL   255      46.961  45.580  19.637  1.00 17.22           C  
ATOM   2050  CG2 VAL   255      45.271  47.183  18.700  1.00 17.07           C  
ATOM   2051  N   ILE   256      45.817  42.770  17.622  1.00 15.06           N  
ATOM   2052  CA  ILE   256      46.283  41.365  17.645  1.00 16.72           C  
ATOM   2053  C   ILE   256      46.945  40.996  16.304  1.00 18.72           C  
ATOM   2054  O   ILE   256      48.041  40.424  16.277  1.00 17.73           O  
ATOM   2055  CB  ILE   256      45.117  40.416  17.975  1.00 15.49           C  
ATOM   2056  CG1 ILE   256      44.671  40.628  19.426  1.00 16.40           C  
ATOM   2057  CG2 ILE   256      45.526  38.931  17.782  1.00 15.97           C  
ATOM   2058  CD1 ILE   256      43.271  40.002  19.721  1.00 17.55           C  
ATOM   2059  N   ASP   257      46.308  41.383  15.204  1.00 13.78           N  
ATOM   2060  CA  ASP   257      46.861  41.172  13.864  1.00 15.76           C  
ATOM   2061  C   ASP   257      48.199  41.850  13.683  1.00 15.74           C  
ATOM   2062  O   ASP   257      49.140  41.264  13.139  1.00 14.56           O  
ATOM   2063  CB  ASP   257      45.867  41.648  12.794  1.00 18.64           C  
ATOM   2064  CG  ASP   257      46.470  41.626  11.405  1.00 26.78           C  
ATOM   2065  OD1 ASP   257      46.453  40.556  10.783  1.00 20.72           O  
ATOM   2066  OD2 ASP   257      46.996  42.664  10.954  1.00 20.29           O  
ATOM   2067  N   PHE   258      48.273  43.108  14.105  1.00 16.25           N  
ATOM   2068  CA  PHE   258      49.528  43.852  14.067  1.00 17.51           C  
ATOM   2069  C   PHE   258      50.622  43.141  14.865  1.00 16.83           C  
ATOM   2070  O   PHE   258      51.773  43.018  14.390  1.00 17.69           O  
ATOM   2071  CB  PHE   258      49.323  45.269  14.626  1.00 15.95           C  
ATOM   2072  CG  PHE   258      50.559  46.166  14.516  1.00 17.88           C  
ATOM   2073  CD1 PHE   258      50.725  47.003  13.413  1.00 17.31           C  
ATOM   2074  CD2 PHE   258      51.537  46.171  15.533  1.00 17.86           C  
ATOM   2075  CE1 PHE   258      51.858  47.838  13.312  1.00 20.55           C  
ATOM   2076  CE2 PHE   258      52.654  46.980  15.434  1.00 23.41           C  
ATOM   2077  CZ  PHE   258      52.815  47.810  14.323  1.00 18.10           C  
ATOM   2078  N   ALA   259      50.285  42.691  16.073  1.00 14.66           N  
ATOM   2079  CA  ALA   259      51.247  41.942  16.906  1.00 17.15           C  
ATOM   2080  C   ALA   259      51.777  40.679  16.212  1.00 16.42           C  
ATOM   2081  O   ALA   259      52.985  40.380  16.281  1.00 17.86           O  
ATOM   2082  CB  ALA   259      50.584  41.557  18.213  1.00 16.20           C  
ATOM   2083  N   ILE   260      50.876  39.950  15.553  1.00 15.43           N  
ATOM   2084  CA  ILE   260      51.263  38.743  14.796  1.00 17.05           C  
ATOM   2085  C   ILE   260      52.194  39.088  13.631  1.00 21.68           C  
ATOM   2086  O   ILE   260      53.265  38.511  13.498  1.00 17.54           O  
ATOM   2087  CB  ILE   260      50.004  37.957  14.309  1.00 15.84           C  
ATOM   2088  CG1 ILE   260      49.276  37.306  15.480  1.00 15.26           C  
ATOM   2089  CG2 ILE   260      50.356  36.946  13.221  1.00 13.29           C  
ATOM   2090  CD1 ILE   260      47.801  37.088  15.148  1.00 20.98           C  
ATOM   2091  N   ARG   261      51.829  40.091  12.840  1.00 16.50           N  
ATOM   2092  CA  ARG   261      52.593  40.431  11.650  1.00 17.41           C  
ATOM   2093  C   ARG   261      53.957  41.067  11.969  1.00 20.27           C  
ATOM   2094  O   ARG   261      54.883  40.981  11.167  1.00 17.78           O  
ATOM   2095  CB  ARG   261      51.767  41.376  10.777  1.00 18.71           C  
ATOM   2096  CG  ARG   261      50.631  40.706  10.003  1.00 18.49           C  
ATOM   2097  CD  ARG   261      49.895  41.730   9.083  1.00 19.15           C  
ATOM   2098  NE  ARG   261      49.374  42.927   9.773  1.00 15.15           N  
ATOM   2099  CZ  ARG   261      49.999  44.110   9.879  1.00 17.36           C  
ATOM   2100  NH1 ARG   261      51.185  44.316   9.312  1.00 13.59           N  
ATOM   2101  NH2 ARG   261      49.410  45.118  10.534  1.00 17.72           N  
ATOM   2102  N   HIS   262      54.049  41.730  13.125  1.00 18.55           N  
ATOM   2103  CA  HIS   262      55.287  42.423  13.520  1.00 18.49           C  
ATOM   2104  C   HIS   262      56.111  41.632  14.541  1.00 19.93           C  
ATOM   2105  O   HIS   262      57.079  42.156  15.116  1.00 20.40           O  
ATOM   2106  CB  HIS   262      54.993  43.845  14.015  1.00 20.26           C  
ATOM   2107  CG  HIS   262      54.594  44.785  12.917  1.00 22.68           C  
ATOM   2108  ND1 HIS   262      55.464  45.707  12.373  1.00 26.66           N  
ATOM   2109  CD2 HIS   262      53.422  44.926  12.243  1.00 19.17           C  
ATOM   2110  CE1 HIS   262      54.846  46.384  11.418  1.00 25.84           C  
ATOM   2111  NE2 HIS   262      53.615  45.915  11.305  1.00 22.21           N  
ATOM   2112  N   GLY   263      55.748  40.363  14.727  1.00 15.73           N  
ATOM   2113  CA  GLY   263      56.525  39.416  15.539  1.00 18.52           C  
ATOM   2114  C   GLY   263      56.471  39.718  17.035  1.00 23.51           C  
ATOM   2115  O   GLY   263      57.383  39.371  17.767  1.00 19.61           O  
ATOM   2116  N   LEU   264      55.410  40.379  17.482  1.00 14.70           N  
ATOM   2117  CA  LEU   264      55.305  40.807  18.894  1.00 17.57           C  
ATOM   2118  C   LEU   264      54.781  39.666  19.747  1.00 21.10           C  
ATOM   2119  O   LEU   264      54.997  39.651  20.979  1.00 24.41           O  
ATOM   2120  CB  LEU   264      54.405  42.057  19.037  1.00 21.79           C  
ATOM   2121  CG  LEU   264      54.894  43.310  18.267  1.00 23.31           C  
ATOM   2122  CD1 LEU   264      54.040  44.564  18.553  1.00 26.68           C  
ATOM   2123  CD2 LEU   264      56.367  43.588  18.518  1.00 29.60           C  
ATOM   2124  N   ILE   265      54.031  38.749  19.115  1.00 18.52           N  
ATOM   2125  CA  ILE   265      53.686  37.475  19.752  1.00 22.83           C  
ATOM   2126  C   ILE   265      54.260  36.308  18.926  1.00 22.38           C  
ATOM   2127  O   ILE   265      54.466  36.436  17.709  1.00 22.45           O  
ATOM   2128  CB  ILE   265      52.160  37.348  20.072  1.00 25.81           C  
ATOM   2129  CG1 ILE   265      51.316  37.513  18.820  1.00 23.62           C  
ATOM   2130  CG2 ILE   265      51.719  38.400  21.120  1.00 28.12           C  
ATOM   2131  CD1 ILE   265      49.815  37.437  19.137  1.00 30.09           C  
ATOM   2132  N   ASP   266      54.528  35.182  19.589  1.00 17.59           N  
ATOM   2133  CA  ASP   266      55.396  34.130  19.052  1.00 18.41           C  
ATOM   2134  C   ASP   266      54.716  32.788  19.309  1.00 14.35           C  
ATOM   2135  O   ASP   266      54.356  32.498  20.449  1.00 17.74           O  
ATOM   2136  CB  ASP   266      56.736  34.200  19.769  1.00 22.76           C  
ATOM   2137  CG  ASP   266      57.793  33.287  19.155  1.00 23.74           C  
ATOM   2138  OD1 ASP   266      57.485  32.100  18.885  1.00 18.42           O  
ATOM   2139  OD2 ASP   266      58.934  33.756  18.958  1.00 28.70           O  
ATOM   2140  N   PRO   267      54.519  31.984  18.263  1.00 14.45           N  
ATOM   2141  CA  PRO   267      53.801  30.706  18.408  1.00 18.63           C  
ATOM   2142  C   PRO   267      54.476  29.707  19.342  1.00 19.37           C  
ATOM   2143  O   PRO   267      53.824  28.755  19.780  1.00 18.58           O  
ATOM   2144  CB  PRO   267      53.784  30.167  16.977  1.00 15.64           C  
ATOM   2145  CG  PRO   267      55.031  30.801  16.347  1.00 17.26           C  
ATOM   2146  CD  PRO   267      54.945  32.200  16.867  1.00 20.06           C  
ATOM   2147  N   ASP   268      55.740  29.927  19.664  1.00 15.62           N  
ATOM   2148  CA  ASP   268      56.414  29.081  20.623  1.00 15.57           C  
ATOM   2149  C   ASP   268      55.906  29.264  22.063  1.00 18.65           C  
ATOM   2150  O   ASP   268      56.171  28.468  22.893  1.00 20.39           O  
ATOM   2151  CB  ASP   268      57.926  29.260  20.596  1.00 15.64           C  
ATOM   2152  CG  ASP   268      58.650  28.193  19.765  1.00 20.73           C  
ATOM   2153  OD1 ASP   268      58.176  27.083  19.594  1.00 19.74           O  
ATOM   2154  OD2 ASP   268      59.709  28.523  19.289  1.00 18.59           O  
ATOM   2155  N   ASN   269      55.254  30.378  22.352  1.00 18.15           N  
ATOM   2156  CA  ASN   269      54.833  30.636  23.700  1.00 18.28           C  
ATOM   2157  C   ASN   269      53.520  31.390  23.936  1.00 23.96           C  
ATOM   2158  O   ASN   269      53.023  31.432  25.023  1.00 26.27           O  
ATOM   2159  CB  ASN   269      55.964  31.175  24.533  1.00 18.15           C  
ATOM   2160  CG  ASN   269      56.558  32.401  23.953  1.00 26.19           C  
ATOM   2161  OD1 ASN   269      57.699  32.422  23.568  1.00 32.60           O  
ATOM   2162  ND2 ASN   269      55.787  33.418  23.887  1.00 26.72           N  
ATOM   2163  N   GLU   270      52.941  31.937  22.902  1.00 16.48           N  
ATOM   2164  CA  GLU   270      51.647  32.553  23.047  1.00 15.11           C  
ATOM   2165  C   GLU   270      50.492  31.549  23.084  1.00 14.42           C  
ATOM   2166  O   GLU   270      50.240  30.921  22.121  1.00 21.12           O  
ATOM   2167  CB  GLU   270      51.467  33.548  21.932  1.00 18.79           C  
ATOM   2168  CG  GLU   270      50.290  34.433  22.053  1.00 18.97           C  
ATOM   2169  CD  GLU   270      50.347  35.361  23.231  1.00 22.84           C  
ATOM   2170  OE1 GLU   270      51.369  35.956  23.455  1.00 20.01           O  
ATOM   2171  OE2 GLU   270      49.349  35.477  23.920  1.00 26.54           O  
ATOM   2172  N   PRO   271      49.784  31.472  24.201  1.00 18.53           N  
ATOM   2173  CA  PRO   271      48.640  30.527  24.313  1.00 18.62           C  
ATOM   2174  C   PRO   271      47.585  30.711  23.209  1.00 21.48           C  
ATOM   2175  O   PRO   271      47.318  31.827  22.772  1.00 20.64           O  
ATOM   2176  CB  PRO   271      48.042  30.857  25.699  1.00 18.34           C  
ATOM   2177  CG  PRO   271      49.205  31.407  26.481  1.00 22.82           C  
ATOM   2178  CD  PRO   271      49.976  32.218  25.463  1.00 19.03           C  
ATOM   2179  N   ASP   272      47.040  29.602  22.722  1.00 19.39           N  
ATOM   2180  CA  ASP   272      45.946  29.606  21.734  1.00 21.41           C  
ATOM   2181  C   ASP   272      46.249  30.312  20.390  1.00 22.39           C  
ATOM   2182  O   ASP   272      45.353  30.844  19.739  1.00 21.93           O  
ATOM   2183  CB  ASP   272      44.665  30.132  22.399  1.00 25.85           C  
ATOM   2184  CG  ASP   272      44.337  29.387  23.701  1.00 22.95           C  
ATOM   2185  OD1 ASP   272      44.123  28.160  23.659  1.00 30.25           O  
ATOM   2186  OD2 ASP   272      44.290  30.024  24.762  1.00 25.66           O  
ATOM   2187  N   TYR   273      47.521  30.310  19.994  1.00 22.77           N  
ATOM   2188  CA  TYR   273      47.976  31.029  18.803  1.00 24.21           C  
ATOM   2189  C   TYR   273      47.124  30.663  17.581  1.00 25.07           C  
ATOM   2190  O   TYR   273      46.575  31.546  16.921  1.00 19.63           O  
ATOM   2191  CB  TYR   273      49.470  30.728  18.556  1.00 24.65           C  
ATOM   2192  CG  TYR   273      50.160  31.551  17.468  1.00 22.16           C  
ATOM   2193  CD1 TYR   273      50.778  32.746  17.787  1.00 22.26           C  
ATOM   2194  CD2 TYR   273      50.222  31.115  16.129  1.00 26.27           C  
ATOM   2195  CE1 TYR   273      51.455  33.514  16.826  1.00 25.71           C  
ATOM   2196  CE2 TYR   273      50.906  31.883  15.148  1.00 23.07           C  
ATOM   2197  CZ  TYR   273      51.516  33.091  15.519  1.00 26.26           C  
ATOM   2198  OH  TYR   273      52.227  33.891  14.619  1.00 25.63           O  
ATOM   2199  N   GLN   274      46.965  29.362  17.313  1.00 25.05           N  
ATOM   2200  CA  GLN   274      46.233  28.905  16.136  1.00 28.03           C  
ATOM   2201  C   GLN   274      44.756  29.291  16.186  1.00 21.12           C  
ATOM   2202  O   GLN   274      44.185  29.668  15.168  1.00 25.17           O  
ATOM   2203  CB  GLN   274      46.352  27.379  15.960  1.00 29.75           C  
ATOM   2204  CG  GLN   274      47.542  26.871  15.197  1.00 35.04           C  
ATOM   2205  CD  GLN   274      47.510  25.334  15.104  1.00 37.83           C  
ATOM   2206  OE1 GLN   274      47.600  24.655  16.103  1.00 54.17           O  
ATOM   2207  NE2 GLN   274      47.333  24.809  13.918  1.00 29.49           N  
ATOM   2208  N   GLU   275      44.133  29.184  17.363  1.00 21.24           N  
ATOM   2209  CA  GLU   275      42.711  29.558  17.518  1.00 23.65           C  
ATOM   2210  C   GLU   275      42.464  31.077  17.339  1.00 23.33           C  
ATOM   2211  O   GLU   275      41.438  31.485  16.766  1.00 23.64           O  
ATOM   2212  CB  GLU   275      42.172  29.094  18.877  1.00 25.97           C  
ATOM   2213  CG  GLU   275      40.632  29.029  18.967  1.00 32.41           C  
ATOM   2214  CD  GLU   275      40.122  28.518  20.321  1.00 39.35           C  
ATOM   2215  OE1 GLU   275      40.922  27.962  21.105  1.00 44.52           O  
ATOM   2216  OE2 GLU   275      38.908  28.672  20.601  1.00 41.90           O  
ATOM   2217  N   ILE   276      43.388  31.896  17.846  1.00 20.81           N  
ATOM   2218  CA  ILE   276      43.385  33.356  17.610  1.00 17.98           C  
ATOM   2219  C   ILE   276      43.453  33.689  16.106  1.00 17.71           C  
ATOM   2220  O   ILE   276      42.631  34.450  15.591  1.00 21.55           O  
ATOM   2221  CB  ILE   276      44.528  34.081  18.401  1.00 15.86           C  
ATOM   2222  CG1 ILE   276      44.247  34.008  19.908  1.00 19.73           C  
ATOM   2223  CG2 ILE   276      44.706  35.542  17.912  1.00 19.05           C  
ATOM   2224  CD1 ILE   276      45.475  34.302  20.768  1.00 19.29           C  
ATOM   2225  N   LEU   277      44.398  33.072  15.395  1.00 19.08           N  
ATOM   2226  CA  LEU   277      44.530  33.265  13.963  1.00 21.48           C  
ATOM   2227  C   LEU   277      43.274  32.840  13.211  1.00 24.88           C  
ATOM   2228  O   LEU   277      42.825  33.536  12.298  1.00 24.76           O  
ATOM   2229  CB  LEU   277      45.735  32.471  13.422  1.00 21.86           C  
ATOM   2230  CG  LEU   277      47.076  33.195  13.374  1.00 24.75           C  
ATOM   2231  CD1 LEU   277      47.600  33.586  14.733  1.00 34.47           C  
ATOM   2232  CD2 LEU   277      48.096  32.295  12.688  1.00 25.76           C  
ATOM   2233  N   ALA   278      42.715  31.692  13.593  1.00 27.02           N  
ATOM   2234  CA  ALA   278      41.506  31.175  12.965  1.00 25.77           C  
ATOM   2235  C   ALA   278      40.359  32.164  13.105  1.00 27.86           C  
ATOM   2236  O   ALA   278      39.644  32.463  12.139  1.00 27.51           O  
ATOM   2237  CB  ALA   278      41.141  29.816  13.572  1.00 26.62           C  
ATOM   2238  N   GLY   279      40.206  32.713  14.303  1.00 24.75           N  
ATOM   2239  CA  GLY   279      39.119  33.606  14.566  1.00 24.32           C  
ATOM   2240  C   GLY   279      39.255  34.969  13.922  1.00 21.62           C  
ATOM   2241  O   GLY   279      38.252  35.644  13.752  1.00 25.06           O  
ATOM   2242  N   LEU   280      40.471  35.367  13.529  1.00 21.70           N  
ATOM   2243  CA  LEU   280      40.689  36.640  12.818  1.00 16.91           C  
ATOM   2244  C   LEU   280      40.233  36.546  11.361  1.00 19.92           C  
ATOM   2245  O   LEU   280      40.131  37.569  10.678  1.00 23.50           O  
ATOM   2246  CB  LEU   280      42.167  37.093  12.848  1.00 19.48           C  
ATOM   2247  CG  LEU   280      42.750  37.463  14.221  1.00 19.47           C  
ATOM   2248  CD1 LEU   280      44.277  37.667  14.111  1.00 17.83           C  
ATOM   2249  CD2 LEU   280      42.045  38.638  14.883  1.00 22.63           C  
ATOM   2250  N   ARG   281      39.992  35.328  10.881  1.00 23.44           N  
ATOM   2251  CA  ARG   281      39.354  35.114   9.570  1.00 32.81           C  
ATOM   2252  C   ARG   281      37.935  34.561   9.712  1.00 32.09           C  
ATOM   2253  O   ARG   281      37.445  33.916   8.796  1.00 48.29           O  
ATOM   2254  CB  ARG   281      40.191  34.158   8.682  1.00 34.72           C  
ATOM   2255  CG  ARG   281      41.637  34.586   8.452  1.00 51.44           C  
ATOM   2256  CD  ARG   281      41.875  35.612   7.315  1.00 47.49           C  
ATOM   2257  NE  ARG   281      43.253  36.139   7.365  1.00 47.28           N  
ATOM   2258  CZ  ARG   281      44.352  35.493   6.941  1.00 62.28           C  
ATOM   2259  NH1 ARG   281      44.285  34.275   6.399  1.00 47.33           N  
ATOM   2260  NH2 ARG   281      45.544  36.071   7.053  1.00 64.73           N  
ATOM   2261  N   GLY   282      37.261  34.858  10.830  1.00 38.52           N  
ATOM   2262  CA  GLY   282      35.979  34.235  11.204  1.00 42.89           C  
ATOM   2263  C   GLY   282      34.742  34.549  10.371  1.00 58.44           C  
ATOM   2264  O   GLY   282      34.487  35.704  10.042  1.00 62.23           O  
ATOM   2265  N   ARG   283      33.963  33.519  10.030  1.00 64.93           N  
ATOM   2266  CA  ARG   283      32.705  33.700   9.274  1.00 72.21           C  
ATOM   2267  C   ARG   283      31.534  32.990   9.967  1.00 69.93           C  
ATOM   2268  O   ARG   283      30.361  33.286   9.718  1.00 69.14           O  
ATOM   2269  CB  ARG   283      32.831  33.197   7.821  1.00 73.70           C  
ATOM   2270  CG  ARG   283      34.107  33.605   7.074  1.00 81.93           C  
ATOM   2271  CD  ARG   283      33.954  33.492   5.560  1.00 83.14           C  
ATOM   2272  NE  ARG   283      33.593  34.769   4.934  1.00 96.15           N  
ATOM   2273  CZ  ARG   283      34.447  35.572   4.294  1.00100.15           C  
ATOM   2274  NH1 ARG   283      34.015  36.705   3.758  1.00 98.98           N  
ATOM   2275  NH2 ARG   283      35.731  35.249   4.181  1.00102.87           N  
END
