
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  110 (  847),  selected  110 , name 1e50_Q
# Molecule2: number of CA atoms  145 ( 1093),  selected  145 , name T0514.pdb
# PARAMETERS: 1e50_Q.T0514.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      S       1           -
LGA    -       -      S       2           -
LGA    -       -      L       3           -
LGA    -       -      T       4           -
LGA    -       -      E       5           -
LGA    -       -      T       6           -
LGA    -       -      Y       7           -
LGA    -       -      G       8           -
LGA    -       -      L       9           -
LGA    -       -      W      10           -
LGA    -       -      S      11           -
LGA    -       -      I      12           -
LGA    -       -      N      13           -
LGA    -       -      C      14           -
LGA    -       -      G      15           -
LGA    -       -      I      16           -
LGA    -       -      Q      17           -
LGA    -       -      E      18           -
LGA    -       -      G      19           -
LGA    -       -      K      20           -
LGA    -       -      K      21           -
LGA    -       -      V      22           -
LGA    -       -      C      23           -
LGA    -       -      F      24           -
LGA    -       -      M      25           -
LGA    L    62_Q      H      26          4.605
LGA    V    63_Q      R      27          3.277
LGA    R    64_Q      Q      28          2.188
LGA    T    65_Q      E      29          2.444
LGA    D    66_Q      V      30          4.831
LGA    S    67_Q      -       -           -
LGA    P    68_Q      N      31          4.854
LGA    -       -      D      32           -
LGA    -       -      Q      33           -
LGA    -       -      N      34           -
LGA    -       -      R      35           -
LGA    -       -      V      36           -
LGA    N    69_Q      V      37          3.028
LGA    F    70_Q      V      38          2.389
LGA    L    71_Q      A      39          1.947
LGA    C    72_Q      M      40          1.999
LGA    S    73_Q      S      41          2.085
LGA    V    74_Q      V      42          5.136
LGA    L    75_Q      V      43           #
LGA    P    76_Q      -       -           -
LGA    T    77_Q      -       -           -
LGA    H    78_Q      -       -           -
LGA    W    79_Q      L      44           #
LGA    R    80_Q      N      45           -
LGA    C    81_Q      A      46           -
LGA    N    82_Q      D      47           -
LGA    K    83_Q      G      48           #
LGA    T    84_Q      V      49          2.670
LGA    L    85_Q      V      50          1.438
LGA    P    86_Q      -       -           -
LGA    I    87_Q      S      51          3.255
LGA    A    88_Q      G      52          2.576
LGA    F    89_Q      -       -           -
LGA    K    90_Q      N      53          1.990
LGA    V    91_Q      L      54          1.669
LGA    V    92_Q      T      55          1.234
LGA    A    93_Q      V      56          2.300
LGA    L    94_Q      P      57          3.334
LGA    G    95_Q      F      58          1.707
LGA    D    96_Q      G      59          3.641
LGA    V    97_Q      I      60          2.514
LGA    P    98_Q      L      61          3.180
LGA    D    99_Q      V      62          2.197
LGA    G   100_Q      S      63          2.082
LGA    T   101_Q      K      64          2.742
LGA    L   102_Q      P      65          1.173
LGA    V   103_Q      V      66          0.740
LGA    T   104_Q      R      67          1.317
LGA    V   105_Q      L      68          1.300
LGA    M   106_Q      Q      69          1.272
LGA    A   107_Q      V      70          1.173
LGA    G   108_Q      D      71          3.090
LGA    N   109_Q      -       -           -
LGA    D   110_Q      -       -           -
LGA    E   111_Q      -       -           -
LGA    N   112_Q      -       -           -
LGA    Y   113_Q      -       -           -
LGA    S   114_Q      E      72          2.882
LGA    A   115_Q      G      73          3.357
LGA    E   116_Q      K      74          3.233
LGA    L   117_Q      A      75          2.333
LGA    R   118_Q      V      76           #
LGA    N   119_Q      I      77          3.727
LGA    A   120_Q      -       -           -
LGA    T   121_Q      E      78          0.960
LGA    A   122_Q      T      79          0.661
LGA    A   123_Q      G      80          1.088
LGA    M   124_Q      I      81          1.185
LGA    K   125_Q      R      82          2.517
LGA    N   126_Q      T      83          1.407
LGA    -       -      C      84           -
LGA    -       -      V      85           -
LGA    -       -      P      86           -
LGA    -       -      A      87           -
LGA    -       -      G      88           -
LGA    Q   127_Q      C      89          1.674
LGA    V   128_Q      I      90          1.139
LGA    A   129_Q      V      91          1.286
LGA    R   130_Q      P      92          0.893
LGA    F   131_Q      I      93          1.915
LGA    N   132_Q      V      94          3.378
LGA    D   133_Q      F      95          3.447
LGA    L   134_Q      D      96          4.791
LGA    R   135_Q      K      97          4.698
LGA    -       -      N      98           -
LGA    F   136_Q      Y      99          1.513
LGA    -       -      V     100           -
LGA    V   137_Q      A     101          5.250
LGA    G   138_Q      A     102          3.976
LGA    R   139_Q      L     103           #
LGA    S   140_Q      R     104          5.495
LGA    G   141_Q      A     105           #
LGA    R   142_Q      -       -           -
LGA    G   143_Q      -       -           -
LGA    K   144_Q      -       -           -
LGA    S   145_Q      G     106          4.234
LGA    F   146_Q      K     107          2.574
LGA    T   147_Q      H     108          1.283
LGA    L   148_Q      L     109          0.952
LGA    T   149_Q      K     110          0.695
LGA    I   150_Q      L     111          1.514
LGA    T   151_Q      A     112          1.563
LGA    V   152_Q      M     113          1.955
LGA    F   153_Q      T     114          3.028
LGA    T   154_Q      I     115          3.015
LGA    -       -      A     116           -
LGA    -       -      A     117           -
LGA    -       -      P     118           -
LGA    -       -      G     119           -
LGA    N   155_Q      E     120          2.705
LGA    P   156_Q      P     121          1.649
LGA    P   157_Q      P     122          1.657
LGA    Q   158_Q      L     123          1.646
LGA    V   159_Q      N     124          3.252
LGA    -       -      D     125           -
LGA    A   160_Q      L     126          1.371
LGA    T   161_Q      F     127          1.853
LGA    Y   162_Q      V     128          2.040
LGA    H   163_Q      Q     129          2.189
LGA    R   164_Q      L     130          3.092
LGA    A   165_Q      N     131          4.063
LGA    -       -      G     132           -
LGA    I   166_Q      F     133          2.882
LGA    K   167_Q      S     134          3.939
LGA    I   168_Q      N     135           -
LGA    T   169_Q      A     136           -
LGA    V   170_Q      L     137           -
LGA    D   171_Q      N     138           -
LGA    -       -      R     139           -
LGA    -       -      L     140           -
LGA    -       -      I     141           -
LGA    -       -      A     142           -
LGA    -       -      L     143           -
LGA    -       -      Q     144           -
LGA    -       -      K     145           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  110  145    5.0     82    2.75     7.32     34.802     2.873

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.558823 * X  +   0.787210 * Y  +  -0.260799 * Z  + -81.614868
  Y_new =  -0.743226 * X  +   0.335912 * Y  +  -0.578600 * Z  +  81.207809
  Z_new =  -0.367874 * X  +   0.517168 * Y  +   0.772791 * Z  + -131.853806 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.589769   -2.551824  [ DEG:    33.7913   -146.2087 ]
  Theta =   0.376722    2.764871  [ DEG:    21.5846    158.4154 ]
  Phi   =  -0.926087    2.215505  [ DEG:   -53.0609    126.9391 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1e50_Q                                        
REMARK     2: T0514.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1e50_Q.T0514.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  110  145   5.0   82   2.75    7.32  34.802
REMARK  ---------------------------------------------------------- 
MOLECULE 1e50_Q
HEADER    TRANSCRIPTION FACTOR                    12-JUL-00   1E50              
TITLE     AML1/CBF COMPLEX                                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CORE-BINDING FACTOR ALPHA SUBUNIT;                         
COMPND   3 CHAIN: A, C, E, G, Q, R;                                             
COMPND   4 FRAGMENT: RUNT DOMAIN RESIDUES 50-183;                               
COMPND   5 SYNONYM: CBFA2/PEPBP2AB/RUNX1, AML1;                                 
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MOL_ID: 2;                                                           
COMPND   8 MOLECULE: CORE-BINDING FACTOR CBF-BETA;                              
COMPND   9 CHAIN: B, D, F, H;                                                   
COMPND  10 FRAGMENT: HETERODIMERISATION DOMAIN RESIDUES 2-135                   
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: AML1;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: DE3;                                       
SOURCE   7 EXPRESSION_SYSTEM_VARIANT: C41;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: BACTERIA;                             
SOURCE   9 EXPRESSION_SYSTEM_VECTOR: PLASMID;                                   
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PRSET;                                    
SOURCE  11 MOL_ID: 2;                                                           
SOURCE  12 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE  13 ORGANISM_COMMON: HUMAN                                               
KEYWDS    TRANSCRIPTION FACTOR                                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.J.WARREN,J.BRAVO,R.L.WILLIAMS,T.H.RABBITS                           
REVDAT   2   01-APR-03 1E50    1       JRNL                                     
REVDAT   1   12-JUL-01 1E50    0                                                
JRNL        AUTH   A.J.WARREN,J.BRAVO,R.L.WILLIAMS,T.H.RABBITTS                 
JRNL        TITL   STRUCTURAL BASIS FOR THE HETERODIMERIC INTERACTION           
JRNL        TITL 2 BETWEEN THE ACUTE LEUKAEMIA-ASSOCIATED                       
JRNL        TITL 3 TRANSCRIPTION FACTORS AML1 AND CBFBETA.                      
JRNL        REF    EMBO J.                       V.  19  3004 2000              
JRNL        REFN   ASTM EMJODG  UK ISSN 0261-4189                               
REMARK   2 RESOLUTION. 2.60 ANGSTROMS.                                          
DBREF  1E50 A   50   183  UNP    Q01196   RUNX1_HUMAN     50    183             
DBREF  1E50 B    2   135  UNP    Q13951   PEBB_HUMAN       2    135             
DBREF  1E50 C   50   183  UNP    Q01196   RUNX1_HUMAN     50    183             
DBREF  1E50 D    2   135  UNP    Q13951   PEBB_HUMAN       2    135             
DBREF  1E50 E   50   183  UNP    Q01196   RUNX1_HUMAN     50    183             
DBREF  1E50 F    2   135  UNP    Q13951   PEBB_HUMAN       2    135             
DBREF  1E50 G   50   183  UNP    Q01196   RUNX1_HUMAN     50    183             
DBREF  1E50 H    2   135  UNP    Q13951   PEBB_HUMAN       2    135             
DBREF  1E50 Q   50   183  UNP    Q01196   RUNX1_HUMAN     50    183             
DBREF  1E50 R   50   183  UNP    Q01196   RUNX1_HUMAN     50    183             
SEQRES   1 A  134  SER MET VAL GLU VAL LEU ALA ASP HIS PRO GLY GLU LEU          
SEQRES   2 A  134  VAL ARG THR ASP SER PRO ASN PHE LEU CYS SER VAL LEU          
SEQRES   3 A  134  PRO THR HIS TRP ARG CYS ASN LYS THR LEU PRO ILE ALA          
SEQRES   4 A  134  PHE LYS VAL VAL ALA LEU GLY ASP VAL PRO ASP GLY THR          
SEQRES   5 A  134  LEU VAL THR VAL MET ALA GLY ASN ASP GLU ASN TYR SER          
SEQRES   6 A  134  ALA GLU LEU ARG ASN ALA THR ALA ALA MET LYS ASN GLN          
SEQRES   7 A  134  VAL ALA ARG PHE ASN ASP LEU ARG PHE VAL GLY ARG SER          
SEQRES   8 A  134  GLY ARG GLY LYS SER PHE THR LEU THR ILE THR VAL PHE          
SEQRES   9 A  134  THR ASN PRO PRO GLN VAL ALA THR TYR HIS ARG ALA ILE          
SEQRES  10 A  134  LYS ILE THR VAL ASP GLY PRO ARG GLU PRO ARG ARG HIS          
SEQRES  11 A  134  ARG GLN LYS LEU                                              
SEQRES   1 B  134  PRO ARG VAL VAL PRO ASP GLN ARG SER LYS PHE GLU ASN          
SEQRES   2 B  134  GLU GLU PHE PHE ARG LYS LEU SER ARG GLU CYS GLU ILE          
SEQRES   3 B  134  LYS TYR THR GLY PHE ARG ASP ARG PRO HIS GLU GLU ARG          
SEQRES   4 B  134  GLN ALA ARG PHE GLN ASN ALA CYS ARG ASP GLY ARG SER          
SEQRES   5 B  134  GLU ILE ALA PHE VAL ALA THR GLY THR ASN LEU SER LEU          
SEQRES   6 B  134  GLN PHE PHE PRO ALA SER TRP GLN GLY GLU GLN ARG GLN          
SEQRES   7 B  134  THR PRO SER ARG GLU TYR VAL ASP LEU GLU ARG GLU ALA          
SEQRES   8 B  134  GLY LYS VAL TYR LEU LYS ALA PRO MET ILE LEU ASN GLY          
SEQRES   9 B  134  VAL CYS VAL ILE TRP LYS GLY TRP ILE ASP LEU GLN ARG          
SEQRES  10 B  134  LEU ASP GLY MET GLY CYS LEU GLU PHE ASP GLU GLU ARG          
SEQRES  11 B  134  ALA GLN GLN GLU                                              
SEQRES   1 C  134  SER MET VAL GLU VAL LEU ALA ASP HIS PRO GLY GLU LEU          
SEQRES   2 C  134  VAL ARG THR ASP SER PRO ASN PHE LEU CYS SER VAL LEU          
SEQRES   3 C  134  PRO THR HIS TRP ARG CYS ASN LYS THR LEU PRO ILE ALA          
SEQRES   4 C  134  PHE LYS VAL VAL ALA LEU GLY ASP VAL PRO ASP GLY THR          
SEQRES   5 C  134  LEU VAL THR VAL MET ALA GLY ASN ASP GLU ASN TYR SER          
SEQRES   6 C  134  ALA GLU LEU ARG ASN ALA THR ALA ALA MET LYS ASN GLN          
SEQRES   7 C  134  VAL ALA ARG PHE ASN ASP LEU ARG PHE VAL GLY ARG SER          
SEQRES   8 C  134  GLY ARG GLY LYS SER PHE THR LEU THR ILE THR VAL PHE          
SEQRES   9 C  134  THR ASN PRO PRO GLN VAL ALA THR TYR HIS ARG ALA ILE          
SEQRES  10 C  134  LYS ILE THR VAL ASP GLY PRO ARG GLU PRO ARG ARG HIS          
SEQRES  11 C  134  ARG GLN LYS LEU                                              
SEQRES   1 D  134  PRO ARG VAL VAL PRO ASP GLN ARG SER LYS PHE GLU ASN          
SEQRES   2 D  134  GLU GLU PHE PHE ARG LYS LEU SER ARG GLU CYS GLU ILE          
SEQRES   3 D  134  LYS TYR THR GLY PHE ARG ASP ARG PRO HIS GLU GLU ARG          
SEQRES   4 D  134  GLN ALA ARG PHE GLN ASN ALA CYS ARG ASP GLY ARG SER          
SEQRES   5 D  134  GLU ILE ALA PHE VAL ALA THR GLY THR ASN LEU SER LEU          
SEQRES   6 D  134  GLN PHE PHE PRO ALA SER TRP GLN GLY GLU GLN ARG GLN          
SEQRES   7 D  134  THR PRO SER ARG GLU TYR VAL ASP LEU GLU ARG GLU ALA          
SEQRES   8 D  134  GLY LYS VAL TYR LEU LYS ALA PRO MET ILE LEU ASN GLY          
SEQRES   9 D  134  VAL CYS VAL ILE TRP LYS GLY TRP ILE ASP LEU GLN ARG          
SEQRES  10 D  134  LEU ASP GLY MET GLY CYS LEU GLU PHE ASP GLU GLU ARG          
SEQRES  11 D  134  ALA GLN GLN GLU                                              
SEQRES   1 E  134  SER MET VAL GLU VAL LEU ALA ASP HIS PRO GLY GLU LEU          
SEQRES   2 E  134  VAL ARG THR ASP SER PRO ASN PHE LEU CYS SER VAL LEU          
SEQRES   3 E  134  PRO THR HIS TRP ARG CYS ASN LYS THR LEU PRO ILE ALA          
SEQRES   4 E  134  PHE LYS VAL VAL ALA LEU GLY ASP VAL PRO ASP GLY THR          
SEQRES   5 E  134  LEU VAL THR VAL MET ALA GLY ASN ASP GLU ASN TYR SER          
SEQRES   6 E  134  ALA GLU LEU ARG ASN ALA THR ALA ALA MET LYS ASN GLN          
SEQRES   7 E  134  VAL ALA ARG PHE ASN ASP LEU ARG PHE VAL GLY ARG SER          
SEQRES   8 E  134  GLY ARG GLY LYS SER PHE THR LEU THR ILE THR VAL PHE          
SEQRES   9 E  134  THR ASN PRO PRO GLN VAL ALA THR TYR HIS ARG ALA ILE          
SEQRES  10 E  134  LYS ILE THR VAL ASP GLY PRO ARG GLU PRO ARG ARG HIS          
SEQRES  11 E  134  ARG GLN LYS LEU                                              
SEQRES   1 F  134  PRO ARG VAL VAL PRO ASP GLN ARG SER LYS PHE GLU ASN          
SEQRES   2 F  134  GLU GLU PHE PHE ARG LYS LEU SER ARG GLU CYS GLU ILE          
SEQRES   3 F  134  LYS TYR THR GLY PHE ARG ASP ARG PRO HIS GLU GLU ARG          
SEQRES   4 F  134  GLN ALA ARG PHE GLN ASN ALA CYS ARG ASP GLY ARG SER          
SEQRES   5 F  134  GLU ILE ALA PHE VAL ALA THR GLY THR ASN LEU SER LEU          
SEQRES   6 F  134  GLN PHE PHE PRO ALA SER TRP GLN GLY GLU GLN ARG GLN          
SEQRES   7 F  134  THR PRO SER ARG GLU TYR VAL ASP LEU GLU ARG GLU ALA          
SEQRES   8 F  134  GLY LYS VAL TYR LEU LYS ALA PRO MET ILE LEU ASN GLY          
SEQRES   9 F  134  VAL CYS VAL ILE TRP LYS GLY TRP ILE ASP LEU GLN ARG          
SEQRES  10 F  134  LEU ASP GLY MET GLY CYS LEU GLU PHE ASP GLU GLU ARG          
SEQRES  11 F  134  ALA GLN GLN GLU                                              
SEQRES   1 G  134  SER MET VAL GLU VAL LEU ALA ASP HIS PRO GLY GLU LEU          
SEQRES   2 G  134  VAL ARG THR ASP SER PRO ASN PHE LEU CYS SER VAL LEU          
SEQRES   3 G  134  PRO THR HIS TRP ARG CYS ASN LYS THR LEU PRO ILE ALA          
SEQRES   4 G  134  PHE LYS VAL VAL ALA LEU GLY ASP VAL PRO ASP GLY THR          
SEQRES   5 G  134  LEU VAL THR VAL MET ALA GLY ASN ASP GLU ASN TYR SER          
SEQRES   6 G  134  ALA GLU LEU ARG ASN ALA THR ALA ALA MET LYS ASN GLN          
SEQRES   7 G  134  VAL ALA ARG PHE ASN ASP LEU ARG PHE VAL GLY ARG SER          
SEQRES   8 G  134  GLY ARG GLY LYS SER PHE THR LEU THR ILE THR VAL PHE          
SEQRES   9 G  134  THR ASN PRO PRO GLN VAL ALA THR TYR HIS ARG ALA ILE          
SEQRES  10 G  134  LYS ILE THR VAL ASP GLY PRO ARG GLU PRO ARG ARG HIS          
SEQRES  11 G  134  ARG GLN LYS LEU                                              
SEQRES   1 H  134  PRO ARG VAL VAL PRO ASP GLN ARG SER LYS PHE GLU ASN          
SEQRES   2 H  134  GLU GLU PHE PHE ARG LYS LEU SER ARG GLU CYS GLU ILE          
SEQRES   3 H  134  LYS TYR THR GLY PHE ARG ASP ARG PRO HIS GLU GLU ARG          
SEQRES   4 H  134  GLN ALA ARG PHE GLN ASN ALA CYS ARG ASP GLY ARG SER          
SEQRES   5 H  134  GLU ILE ALA PHE VAL ALA THR GLY THR ASN LEU SER LEU          
SEQRES   6 H  134  GLN PHE PHE PRO ALA SER TRP GLN GLY GLU GLN ARG GLN          
SEQRES   7 H  134  THR PRO SER ARG GLU TYR VAL ASP LEU GLU ARG GLU ALA          
SEQRES   8 H  134  GLY LYS VAL TYR LEU LYS ALA PRO MET ILE LEU ASN GLY          
SEQRES   9 H  134  VAL CYS VAL ILE TRP LYS GLY TRP ILE ASP LEU GLN ARG          
SEQRES  10 H  134  LEU ASP GLY MET GLY CYS LEU GLU PHE ASP GLU GLU ARG          
SEQRES  11 H  134  ALA GLN GLN GLU                                              
SEQRES   1 Q  134  SER MET VAL GLU VAL LEU ALA ASP HIS PRO GLY GLU LEU          
SEQRES   2 Q  134  VAL ARG THR ASP SER PRO ASN PHE LEU CYS SER VAL LEU          
SEQRES   3 Q  134  PRO THR HIS TRP ARG CYS ASN LYS THR LEU PRO ILE ALA          
SEQRES   4 Q  134  PHE LYS VAL VAL ALA LEU GLY ASP VAL PRO ASP GLY THR          
SEQRES   5 Q  134  LEU VAL THR VAL MET ALA GLY ASN ASP GLU ASN TYR SER          
SEQRES   6 Q  134  ALA GLU LEU ARG ASN ALA THR ALA ALA MET LYS ASN GLN          
SEQRES   7 Q  134  VAL ALA ARG PHE ASN ASP LEU ARG PHE VAL GLY ARG SER          
SEQRES   8 Q  134  GLY ARG GLY LYS SER PHE THR LEU THR ILE THR VAL PHE          
SEQRES   9 Q  134  THR ASN PRO PRO GLN VAL ALA THR TYR HIS ARG ALA ILE          
SEQRES  10 Q  134  LYS ILE THR VAL ASP GLY PRO ARG GLU PRO ARG ARG HIS          
SEQRES  11 Q  134  ARG GLN LYS LEU                                              
SEQRES   1 R  134  SER MET VAL GLU VAL LEU ALA ASP HIS PRO GLY GLU LEU          
SEQRES   2 R  134  VAL ARG THR ASP SER PRO ASN PHE LEU CYS SER VAL LEU          
SEQRES   3 R  134  PRO THR HIS TRP ARG CYS ASN LYS THR LEU PRO ILE ALA          
SEQRES   4 R  134  PHE LYS VAL VAL ALA LEU GLY ASP VAL PRO ASP GLY THR          
SEQRES   5 R  134  LEU VAL THR VAL MET ALA GLY ASN ASP GLU ASN TYR SER          
SEQRES   6 R  134  ALA GLU LEU ARG ASN ALA THR ALA ALA MET LYS ASN GLN          
SEQRES   7 R  134  VAL ALA ARG PHE ASN ASP LEU ARG PHE VAL GLY ARG SER          
SEQRES   8 R  134  GLY ARG GLY LYS SER PHE THR LEU THR ILE THR VAL PHE          
SEQRES   9 R  134  THR ASN PRO PRO GLN VAL ALA THR TYR HIS ARG ALA ILE          
SEQRES  10 R  134  LYS ILE THR VAL ASP GLY PRO ARG GLU PRO ARG ARG HIS          
SEQRES  11 R  134  ARG GLN LYS LEU                                              
FORMUL  11  HOH   *157(H2 O)                                                    
CRYST1  103.260   79.380  130.100  90.00 101.39  90.00 P 1 21 1     12          
ATOM   7854  N   LEU Q  62     -89.704  14.665 -34.206  1.00 87.39           N  
ATOM   7855  CA  LEU Q  62     -90.618  14.337 -33.072  1.00 88.04           C  
ATOM   7856  C   LEU Q  62     -90.252  15.105 -31.803  1.00 89.16           C  
ATOM   7857  O   LEU Q  62     -89.115  15.547 -31.635  1.00 87.68           O  
ATOM   7858  CB  LEU Q  62     -90.588  12.831 -32.787  1.00 85.75           C  
ATOM   7859  CG  LEU Q  62     -91.074  11.903 -33.904  1.00 84.90           C  
ATOM   7860  CD1 LEU Q  62     -90.859  10.455 -33.501  1.00 84.41           C  
ATOM   7861  CD2 LEU Q  62     -92.540  12.166 -34.191  1.00 84.20           C  
ATOM   7862  N   VAL Q  63     -91.236  15.259 -30.918  1.00 91.58           N  
ATOM   7863  CA  VAL Q  63     -91.059  15.965 -29.652  1.00 93.80           C  
ATOM   7864  C   VAL Q  63     -92.097  15.506 -28.624  1.00 95.57           C  
ATOM   7865  O   VAL Q  63     -93.184  15.039 -28.978  1.00 95.57           O  
ATOM   7866  CB  VAL Q  63     -91.159  17.507 -29.853  1.00 92.94           C  
ATOM   7867  CG1 VAL Q  63     -91.495  18.205 -28.548  1.00 94.00           C  
ATOM   7868  CG2 VAL Q  63     -89.836  18.038 -30.366  1.00 93.82           C  
ATOM   7869  N   ARG Q  64     -91.746  15.631 -27.349  1.00 97.25           N  
ATOM   7870  CA  ARG Q  64     -92.627  15.239 -26.258  1.00 98.65           C  
ATOM   7871  C   ARG Q  64     -93.708  16.276 -25.956  1.00 98.03           C  
ATOM   7872  O   ARG Q  64     -93.428  17.472 -25.837  1.00 97.52           O  
ATOM   7873  CB  ARG Q  64     -91.801  14.983 -24.995  1.00100.60           C  
ATOM   7874  CG  ARG Q  64     -92.622  14.941 -23.717  1.00104.01           C  
ATOM   7875  CD  ARG Q  64     -91.756  14.653 -22.509  1.00106.24           C  
ATOM   7876  NE  ARG Q  64     -91.191  13.310 -22.566  1.00108.15           N  
ATOM   7877  CZ  ARG Q  64     -90.408  12.790 -21.628  1.00109.27           C  
ATOM   7878  NH1 ARG Q  64     -90.091  13.503 -20.554  1.00109.85           N  
ATOM   7879  NH2 ARG Q  64     -89.944  11.556 -21.765  1.00109.94           N  
ATOM   7880  N   THR Q  65     -94.944  15.805 -25.828  1.00 97.33           N  
ATOM   7881  CA  THR Q  65     -96.074  16.675 -25.517  1.00 96.58           C  
ATOM   7882  C   THR Q  65     -96.128  16.836 -24.000  1.00 96.25           C  
ATOM   7883  O   THR Q  65     -95.300  16.272 -23.290  1.00 96.21           O  
ATOM   7884  CB  THR Q  65     -97.398  16.050 -25.998  1.00 95.74           C  
ATOM   7885  OG1 THR Q  65     -97.639  14.831 -25.286  1.00 94.51           O  
ATOM   7886  CG2 THR Q  65     -97.333  15.745 -27.487  1.00 94.42           C  
ATOM   7887  N   ASP Q  66     -97.087  17.606 -23.497  1.00 96.77           N  
ATOM   7888  CA  ASP Q  66     -97.203  17.775 -22.052  1.00 98.11           C  
ATOM   7889  C   ASP Q  66     -97.560  16.418 -21.442  1.00 98.11           C  
ATOM   7890  O   ASP Q  66     -97.428  16.206 -20.234  1.00 98.13           O  
ATOM   7891  CB  ASP Q  66     -98.281  18.807 -21.703  1.00 98.91           C  
ATOM   7892  CG  ASP Q  66     -97.896  20.216 -22.114  1.00 99.73           C  
ATOM   7893  OD1 ASP Q  66     -96.792  20.665 -21.747  1.00 99.73           O  
ATOM   7894  OD2 ASP Q  66     -98.701  20.880 -22.798  1.00101.88           O  
ATOM   7895  N   SER Q  67     -98.012  15.506 -22.297  1.00 97.39           N  
ATOM   7896  CA  SER Q  67     -98.375  14.160 -21.878  1.00 96.20           C  
ATOM   7897  C   SER Q  67     -97.146  13.263 -21.990  1.00 96.93           C  
ATOM   7898  O   SER Q  67     -96.497  13.206 -23.039  1.00 96.77           O  
ATOM   7899  CB  SER Q  67     -99.493  13.604 -22.762  1.00 94.91           C  
ATOM   7900  OG  SER Q  67     -99.722  12.231 -22.494  1.00 91.70           O  
ATOM   7901  N   PRO Q  68     -96.805  12.559 -20.902  1.00 96.34           N  
ATOM   7902  CA  PRO Q  68     -95.643  11.668 -20.903  1.00 95.41           C  
ATOM   7903  C   PRO Q  68     -95.892  10.375 -21.676  1.00 93.72           C  
ATOM   7904  O   PRO Q  68     -95.041   9.484 -21.692  1.00 93.92           O  
ATOM   7905  CB  PRO Q  68     -95.407  11.420 -19.417  1.00 95.86           C  
ATOM   7906  CG  PRO Q  68     -96.799  11.434 -18.868  1.00 95.39           C  
ATOM   7907  CD  PRO Q  68     -97.410  12.630 -19.560  1.00 96.05           C  
ATOM   7908  N   ASN Q  69     -97.053  10.279 -22.321  1.00 91.05           N  
ATOM   7909  CA  ASN Q  69     -97.390   9.079 -23.078  1.00 88.96           C  
ATOM   7910  C   ASN Q  69     -97.456   9.297 -24.589  1.00 87.38           C  
ATOM   7911  O   ASN Q  69     -97.623   8.342 -25.353  1.00 85.56           O  
ATOM   7912  CB  ASN Q  69     -98.720   8.507 -22.581  1.00 88.58           C  
ATOM   7913  CG  ASN Q  69     -98.986   7.116 -23.114  1.00 88.11           C  
ATOM   7914  OD1 ASN Q  69     -98.131   6.236 -23.030  1.00 88.01           O  
ATOM   7915  ND2 ASN Q  69    -100.177   6.906 -23.660  1.00 88.11           N  
ATOM   7916  N   PHE Q  70     -97.317  10.547 -25.025  1.00 86.46           N  
ATOM   7917  CA  PHE Q  70     -97.366  10.848 -26.453  1.00 85.05           C  
ATOM   7918  C   PHE Q  70     -96.272  11.776 -26.967  1.00 84.65           C  
ATOM   7919  O   PHE Q  70     -95.783  12.657 -26.258  1.00 85.53           O  
ATOM   7920  CB  PHE Q  70     -98.723  11.446 -26.827  1.00 82.42           C  
ATOM   7921  CG  PHE Q  70     -99.881  10.557 -26.508  1.00 81.23           C  
ATOM   7922  CD1 PHE Q  70    -100.265   9.556 -27.394  1.00 80.10           C  
ATOM   7923  CD2 PHE Q  70    -100.568  10.693 -25.305  1.00 80.68           C  
ATOM   7924  CE1 PHE Q  70    -101.313   8.699 -27.088  1.00 79.54           C  
ATOM   7925  CE2 PHE Q  70    -101.621   9.841 -24.987  1.00 79.36           C  
ATOM   7926  CZ  PHE Q  70    -101.995   8.841 -25.880  1.00 79.80           C  
ATOM   7927  N   LEU Q  71     -95.895  11.552 -28.221  1.00 83.69           N  
ATOM   7928  CA  LEU Q  71     -94.898  12.362 -28.902  1.00 83.46           C  
ATOM   7929  C   LEU Q  71     -95.571  12.853 -30.179  1.00 82.90           C  
ATOM   7930  O   LEU Q  71     -96.356  12.126 -30.792  1.00 82.04           O  
ATOM   7931  CB  LEU Q  71     -93.665  11.527 -29.273  1.00 82.71           C  
ATOM   7932  CG  LEU Q  71     -92.802  10.911 -28.169  1.00 82.25           C  
ATOM   7933  CD1 LEU Q  71     -91.645  10.147 -28.805  1.00 79.39           C  
ATOM   7934  CD2 LEU Q  71     -92.285  12.001 -27.242  1.00 82.07           C  
ATOM   7935  N   CYS Q  72     -95.287  14.090 -30.571  1.00 82.06           N  
ATOM   7936  CA  CYS Q  72     -95.866  14.636 -31.796  1.00 80.75           C  
ATOM   7937  C   CYS Q  72     -94.779  15.334 -32.596  1.00 80.54           C  
ATOM   7938  O   CYS Q  72     -93.860  15.925 -32.025  1.00 79.85           O  
ATOM   7939  CB  CYS Q  72     -96.981  15.635 -31.481  1.00 77.42           C  
ATOM   7940  SG  CYS Q  72     -96.388  17.201 -30.845  1.00 73.89           S  
ATOM   7941  N   SER Q  73     -94.884  15.255 -33.919  1.00 80.60           N  
ATOM   7942  CA  SER Q  73     -93.915  15.893 -34.795  1.00 79.48           C  
ATOM   7943  C   SER Q  73     -94.021  17.413 -34.671  1.00 78.47           C  
ATOM   7944  O   SER Q  73     -95.118  17.963 -34.573  1.00 76.55           O  
ATOM   7945  CB  SER Q  73     -94.152  15.451 -36.241  1.00 79.08           C  
ATOM   7946  OG  SER Q  73     -95.523  15.528 -36.582  1.00 78.85           O  
ATOM   7947  N   VAL Q  74     -92.876  18.086 -34.653  1.00 77.81           N  
ATOM   7948  CA  VAL Q  74     -92.858  19.537 -34.543  1.00 78.53           C  
ATOM   7949  C   VAL Q  74     -93.401  20.161 -35.828  1.00 78.00           C  
ATOM   7950  O   VAL Q  74     -93.206  19.634 -36.926  1.00 78.19           O  
ATOM   7951  CB  VAL Q  74     -91.424  20.073 -34.308  1.00 79.08           C  
ATOM   7952  CG1 VAL Q  74     -91.475  21.538 -33.880  1.00 78.40           C  
ATOM   7953  CG2 VAL Q  74     -90.724  19.237 -33.262  1.00 78.91           C  
ATOM   7954  N   LEU Q  75     -94.093  21.282 -35.681  1.00 76.37           N  
ATOM   7955  CA  LEU Q  75     -94.649  21.981 -36.826  1.00 75.58           C  
ATOM   7956  C   LEU Q  75     -93.852  23.257 -37.061  1.00 74.71           C  
ATOM   7957  O   LEU Q  75     -93.109  23.705 -36.186  1.00 74.96           O  
ATOM   7958  CB  LEU Q  75     -96.113  22.334 -36.564  1.00 74.30           C  
ATOM   7959  CG  LEU Q  75     -97.108  21.178 -36.482  1.00 72.10           C  
ATOM   7960  CD1 LEU Q  75     -98.456  21.726 -36.049  1.00 73.98           C  
ATOM   7961  CD2 LEU Q  75     -97.213  20.477 -37.828  1.00 69.16           C  
ATOM   7962  N   PRO Q  76     -93.978  23.850 -38.259  1.00 73.54           N  
ATOM   7963  CA  PRO Q  76     -93.238  25.086 -38.528  1.00 71.67           C  
ATOM   7964  C   PRO Q  76     -93.721  26.182 -37.583  1.00 70.13           C  
ATOM   7965  O   PRO Q  76     -94.915  26.297 -37.321  1.00 68.23           O  
ATOM   7966  CB  PRO Q  76     -93.567  25.374 -39.993  1.00 73.17           C  
ATOM   7967  CG  PRO Q  76     -94.916  24.718 -40.186  1.00 74.42           C  
ATOM   7968  CD  PRO Q  76     -94.757  23.425 -39.435  1.00 73.55           C  
ATOM   7969  N   THR Q  77     -92.792  26.976 -37.062  1.00 70.01           N  
ATOM   7970  CA  THR Q  77     -93.145  28.044 -36.134  1.00 71.67           C  
ATOM   7971  C   THR Q  77     -94.256  28.918 -36.708  1.00 72.75           C  
ATOM   7972  O   THR Q  77     -95.201  29.282 -36.008  1.00 73.60           O  
ATOM   7973  CB  THR Q  77     -91.917  28.933 -35.803  1.00 71.54           C  
ATOM   7974  OG1 THR Q  77     -91.743  29.932 -36.816  1.00 70.99           O  
ATOM   7975  CG2 THR Q  77     -90.653  28.080 -35.736  1.00 71.20           C  
ATOM   7976  N   HIS Q  78     -94.137  29.238 -37.994  1.00 73.72           N  
ATOM   7977  CA  HIS Q  78     -95.109  30.072 -38.696  1.00 73.10           C  
ATOM   7978  C   HIS Q  78     -95.471  29.409 -40.022  1.00 70.48           C  
ATOM   7979  O   HIS Q  78     -94.590  28.980 -40.770  1.00 70.77           O  
ATOM   7980  CB  HIS Q  78     -94.508  31.467 -38.932  1.00 77.05           C  
ATOM   7981  CG  HIS Q  78     -95.412  32.412 -39.662  1.00 82.99           C  
ATOM   7982  ND1 HIS Q  78     -96.774  32.468 -39.440  1.00 84.81           N  
ATOM   7983  CD2 HIS Q  78     -95.145  33.371 -40.584  1.00 83.30           C  
ATOM   7984  CE1 HIS Q  78     -97.303  33.418 -40.192  1.00 83.34           C  
ATOM   7985  NE2 HIS Q  78     -96.336  33.979 -40.895  1.00 84.14           N  
ATOM   7986  N   TRP Q  79     -96.763  29.302 -40.307  1.00 66.56           N  
ATOM   7987  CA  TRP Q  79     -97.191  28.687 -41.555  1.00 63.17           C  
ATOM   7988  C   TRP Q  79     -98.368  29.439 -42.150  1.00 62.69           C  
ATOM   7989  O   TRP Q  79     -98.912  30.346 -41.522  1.00 62.20           O  
ATOM   7990  CB  TRP Q  79     -97.569  27.221 -41.337  1.00 59.36           C  
ATOM   7991  CG  TRP Q  79     -97.511  26.410 -42.600  1.00 56.48           C  
ATOM   7992  CD1 TRP Q  79     -98.547  25.763 -43.214  1.00 55.44           C  
ATOM   7993  CD2 TRP Q  79     -96.349  26.162 -43.402  1.00 56.11           C  
ATOM   7994  NE1 TRP Q  79     -98.098  25.124 -44.353  1.00 54.58           N  
ATOM   7995  CE2 TRP Q  79     -96.755  25.352 -44.491  1.00 54.98           C  
ATOM   7996  CE3 TRP Q  79     -95.000  26.546 -43.309  1.00 55.65           C  
ATOM   7997  CZ2 TRP Q  79     -95.861  24.918 -45.479  1.00 56.80           C  
ATOM   7998  CZ3 TRP Q  79     -94.107  26.113 -44.292  1.00 54.95           C  
ATOM   7999  CH2 TRP Q  79     -94.544  25.309 -45.363  1.00 55.52           C  
ATOM   8000  N   ARG Q  80     -98.759  29.038 -43.358  1.00 62.72           N  
ATOM   8001  CA  ARG Q  80     -99.853  29.665 -44.093  1.00 63.60           C  
ATOM   8002  C   ARG Q  80    -101.191  28.950 -43.953  1.00 63.37           C  
ATOM   8003  O   ARG Q  80    -101.257  27.721 -43.947  1.00 62.49           O  
ATOM   8004  CB  ARG Q  80     -99.488  29.744 -45.580  1.00 64.95           C  
ATOM   8005  CG  ARG Q  80    -100.555  30.359 -46.483  1.00 62.92           C  
ATOM   8006  CD  ARG Q  80    -100.284  30.004 -47.939  1.00 62.68           C  
ATOM   8007  NE  ARG Q  80    -101.322  30.496 -48.837  1.00 63.90           N  
ATOM   8008  CZ  ARG Q  80    -101.266  31.656 -49.489  1.00 61.08           C  
ATOM   8009  NH1 ARG Q  80    -100.211  32.450 -49.349  1.00 58.06           N  
ATOM   8010  NH2 ARG Q  80    -102.269  32.021 -50.276  1.00 56.41           N  
ATOM   8011  N   CYS Q  81    -102.254  29.744 -43.858  1.00 63.36           N  
ATOM   8012  CA  CYS Q  81    -103.617  29.237 -43.741  1.00 63.79           C  
ATOM   8013  C   CYS Q  81    -103.971  28.319 -44.914  1.00 62.60           C  
ATOM   8014  O   CYS Q  81    -103.864  28.707 -46.082  1.00 62.29           O  
ATOM   8015  CB  CYS Q  81    -104.604  30.415 -43.675  1.00 64.86           C  
ATOM   8016  SG  CYS Q  81    -106.339  30.033 -44.096  1.00 73.99           S  
ATOM   8017  N   ASN Q  82    -104.384  27.099 -44.580  1.00 61.70           N  
ATOM   8018  CA  ASN Q  82    -104.779  26.076 -45.548  1.00 59.70           C  
ATOM   8019  C   ASN Q  82    -103.698  25.651 -46.539  1.00 58.66           C  
ATOM   8020  O   ASN Q  82    -103.997  25.137 -47.612  1.00 57.28           O  
ATOM   8021  CB  ASN Q  82    -106.027  26.521 -46.310  1.00 59.83           C  
ATOM   8022  CG  ASN Q  82    -106.680  25.380 -47.072  1.00 61.49           C  
ATOM   8023  OD1 ASN Q  82    -107.014  24.347 -46.493  1.00 61.45           O  
ATOM   8024  ND2 ASN Q  82    -106.868  25.563 -48.375  1.00 62.06           N  
ATOM   8025  N   LYS Q  83    -102.438  25.857 -46.179  1.00 60.52           N  
ATOM   8026  CA  LYS Q  83    -101.339  25.455 -47.045  1.00 62.61           C  
ATOM   8027  C   LYS Q  83    -100.711  24.171 -46.499  1.00 65.07           C  
ATOM   8028  O   LYS Q  83    -100.218  24.145 -45.365  1.00 64.99           O  
ATOM   8029  CB  LYS Q  83    -100.270  26.549 -47.113  1.00 62.04           C  
ATOM   8030  CG  LYS Q  83     -99.093  26.198 -48.023  1.00 62.83           C  
ATOM   8031  CD  LYS Q  83     -97.906  27.122 -47.779  1.00 65.05           C  
ATOM   8032  CE  LYS Q  83     -96.709  26.741 -48.639  1.00 65.70           C  
ATOM   8033  NZ  LYS Q  83     -95.502  27.550 -48.292  1.00 67.02           N  
ATOM   8034  N   THR Q  84    -100.739  23.109 -47.302  1.00 65.35           N  
ATOM   8035  CA  THR Q  84    -100.160  21.828 -46.908  1.00 63.51           C  
ATOM   8036  C   THR Q  84     -98.916  22.028 -46.037  1.00 64.92           C  
ATOM   8037  O   THR Q  84     -98.095  22.916 -46.291  1.00 65.50           O  
ATOM   8038  CB  THR Q  84     -99.781  21.002 -48.152  1.00 61.55           C  
ATOM   8039  OG1 THR Q  84    -100.976  20.552 -48.806  1.00 60.59           O  
ATOM   8040  CG2 THR Q  84     -98.932  19.807 -47.766  1.00 62.15           C  
ATOM   8041  N   LEU Q  85     -98.787  21.204 -45.002  1.00 65.70           N  
ATOM   8042  CA  LEU Q  85     -97.652  21.290 -44.086  1.00 65.13           C  
ATOM   8043  C   LEU Q  85     -96.333  20.853 -44.728  1.00 64.97           C  
ATOM   8044  O   LEU Q  85     -96.322  20.137 -45.728  1.00 61.72           O  
ATOM   8045  CB  LEU Q  85     -97.921  20.431 -42.840  1.00 64.99           C  
ATOM   8046  CG  LEU Q  85     -99.022  20.874 -41.869  1.00 64.22           C  
ATOM   8047  CD1 LEU Q  85     -99.214  19.814 -40.799  1.00 63.60           C  
ATOM   8048  CD2 LEU Q  85     -98.650  22.218 -41.240  1.00 63.21           C  
ATOM   8049  N   PRO Q  86     -95.198  21.301 -44.162  1.00 67.06           N  
ATOM   8050  CA  PRO Q  86     -93.874  20.942 -44.684  1.00 70.06           C  
ATOM   8051  C   PRO Q  86     -93.723  19.432 -44.559  1.00 73.81           C  
ATOM   8052  O   PRO Q  86     -93.386  18.735 -45.519  1.00 74.58           O  
ATOM   8053  CB  PRO Q  86     -92.915  21.670 -43.743  1.00 69.58           C  
ATOM   8054  CG  PRO Q  86     -93.707  22.848 -43.273  1.00 68.89           C  
ATOM   8055  CD  PRO Q  86     -95.082  22.260 -43.048  1.00 68.79           C  
ATOM   8056  N   ILE Q  87     -93.991  18.948 -43.348  1.00 76.84           N  
ATOM   8057  CA  ILE Q  87     -93.913  17.530 -43.018  1.00 77.86           C  
ATOM   8058  C   ILE Q  87     -95.295  17.021 -42.647  1.00 77.58           C  
ATOM   8059  O   ILE Q  87     -96.178  17.800 -42.284  1.00 76.67           O  
ATOM   8060  CB  ILE Q  87     -92.992  17.285 -41.802  1.00 79.09           C  
ATOM   8061  CG1 ILE Q  87     -93.491  18.113 -40.608  1.00 80.32           C  
ATOM   8062  CG2 ILE Q  87     -91.551  17.621 -42.157  1.00 77.53           C  
ATOM   8063  CD1 ILE Q  87     -92.728  17.869 -39.315  1.00 84.15           C  
ATOM   8064  N   ALA Q  88     -95.474  15.707 -42.731  1.00 79.11           N  
ATOM   8065  CA  ALA Q  88     -96.745  15.090 -42.377  1.00 81.27           C  
ATOM   8066  C   ALA Q  88     -96.807  14.986 -40.854  1.00 81.64           C  
ATOM   8067  O   ALA Q  88     -95.886  14.465 -40.216  1.00 81.25           O  
ATOM   8068  CB  ALA Q  88     -96.857  13.703 -43.009  1.00 82.17           C  
ATOM   8069  N   PHE Q  89     -97.891  15.489 -40.271  1.00 81.71           N  
ATOM   8070  CA  PHE Q  89     -98.042  15.454 -38.824  1.00 79.59           C  
ATOM   8071  C   PHE Q  89     -98.300  14.041 -38.323  1.00 79.64           C  
ATOM   8072  O   PHE Q  89     -99.184  13.335 -38.825  1.00 76.55           O  
ATOM   8073  CB  PHE Q  89     -99.179  16.370 -38.377  1.00 76.93           C  
ATOM   8074  CG  PHE Q  89     -99.224  16.585 -36.898  1.00 72.93           C  
ATOM   8075  CD1 PHE Q  89     -98.190  17.251 -36.253  1.00 72.06           C  
ATOM   8076  CD2 PHE Q  89    -100.289  16.112 -36.144  1.00 72.02           C  
ATOM   8077  CE1 PHE Q  89     -98.212  17.443 -34.874  1.00 71.88           C  
ATOM   8078  CE2 PHE Q  89    -100.322  16.299 -34.764  1.00 73.38           C  
ATOM   8079  CZ  PHE Q  89     -99.279  16.967 -34.127  1.00 72.30           C  
ATOM   8080  N   LYS Q  90     -97.510  13.640 -37.330  1.00 80.15           N  
ATOM   8081  CA  LYS Q  90     -97.619  12.319 -36.726  1.00 80.06           C  
ATOM   8082  C   LYS Q  90     -97.689  12.410 -35.210  1.00 79.25           C  
ATOM   8083  O   LYS Q  90     -97.107  13.307 -34.598  1.00 77.62           O  
ATOM   8084  CB  LYS Q  90     -96.415  11.448 -37.102  1.00 80.14           C  
ATOM   8085  CG  LYS Q  90     -96.360  11.013 -38.553  1.00 82.52           C  
ATOM   8086  CD  LYS Q  90     -95.268   9.971 -38.765  1.00 83.80           C  
ATOM   8087  CE  LYS Q  90     -95.320   9.390 -40.173  1.00 84.57           C  
ATOM   8088  NZ  LYS Q  90     -94.474   8.170 -40.317  1.00 83.08           N  
ATOM   8089  N   VAL Q  91     -98.422  11.478 -34.615  1.00 80.54           N  
ATOM   8090  CA  VAL Q  91     -98.546  11.395 -33.165  1.00 81.53           C  
ATOM   8091  C   VAL Q  91     -98.063  10.003 -32.784  1.00 81.83           C  
ATOM   8092  O   VAL Q  91     -98.630   8.997 -33.221  1.00 80.44           O  
ATOM   8093  CB  VAL Q  91    -100.006  11.566 -32.689  1.00 81.43           C  
ATOM   8094  CG1 VAL Q  91    -100.102  11.263 -31.201  1.00 81.57           C  
ATOM   8095  CG2 VAL Q  91    -100.475  12.985 -32.950  1.00 80.78           C  
ATOM   8096  N   VAL Q  92     -96.999   9.956 -31.991  1.00 83.65           N  
ATOM   8097  CA  VAL Q  92     -96.419   8.691 -31.546  1.00 84.57           C  
ATOM   8098  C   VAL Q  92     -96.840   8.368 -30.115  1.00 84.18           C  
ATOM   8099  O   VAL Q  92     -96.570   9.135 -29.188  1.00 82.87           O  
ATOM   8100  CB  VAL Q  92     -94.875   8.735 -31.604  1.00 85.13           C  
ATOM   8101  CG1 VAL Q  92     -94.304   7.380 -31.220  1.00 85.18           C  
ATOM   8102  CG2 VAL Q  92     -94.417   9.132 -32.999  1.00 84.60           C  
ATOM   8103  N   ALA Q  93     -97.505   7.230 -29.943  1.00 85.09           N  
ATOM   8104  CA  ALA Q  93     -97.961   6.801 -28.627  1.00 86.71           C  
ATOM   8105  C   ALA Q  93     -96.892   5.956 -27.937  1.00 87.62           C  
ATOM   8106  O   ALA Q  93     -96.445   4.944 -28.481  1.00 87.46           O  
ATOM   8107  CB  ALA Q  93     -99.255   6.006 -28.760  1.00 84.72           C  
ATOM   8108  N   LEU Q  94     -96.479   6.381 -26.745  1.00 88.55           N  
ATOM   8109  CA  LEU Q  94     -95.474   5.653 -25.972  1.00 90.20           C  
ATOM   8110  C   LEU Q  94     -96.083   4.385 -25.384  1.00 91.14           C  
ATOM   8111  O   LEU Q  94     -95.513   3.298 -25.491  1.00 90.60           O  
ATOM   8112  CB  LEU Q  94     -94.930   6.540 -24.849  1.00 89.98           C  
ATOM   8113  CG  LEU Q  94     -93.623   7.294 -25.119  1.00 90.69           C  
ATOM   8114  CD1 LEU Q  94     -93.549   7.756 -26.566  1.00 90.46           C  
ATOM   8115  CD2 LEU Q  94     -93.519   8.470 -24.157  1.00 89.58           C  
ATOM   8116  N   GLY Q  95     -97.245   4.538 -24.759  1.00 92.49           N  
ATOM   8117  CA  GLY Q  95     -97.930   3.401 -24.179  1.00 93.45           C  
ATOM   8118  C   GLY Q  95     -98.772   2.731 -25.246  1.00 94.57           C  
ATOM   8119  O   GLY Q  95     -99.489   3.402 -25.987  1.00 95.04           O  
ATOM   8120  N   ASP Q  96     -98.681   1.407 -25.330  1.00 95.50           N  
ATOM   8121  CA  ASP Q  96     -99.435   0.642 -26.317  1.00 95.49           C  
ATOM   8122  C   ASP Q  96    -100.896   1.060 -26.401  1.00 94.97           C  
ATOM   8123  O   ASP Q  96    -101.629   1.006 -25.413  1.00 95.35           O  
ATOM   8124  CB  ASP Q  96     -99.352  -0.855 -26.004  1.00 96.93           C  
ATOM   8125  CG  ASP Q  96     -99.546  -1.155 -24.530  1.00 99.08           C  
ATOM   8126  OD1 ASP Q  96     -98.631  -0.847 -23.734  1.00 99.52           O  
ATOM   8127  OD2 ASP Q  96    -100.614  -1.694 -24.166  1.00 99.71           O  
ATOM   8128  N   VAL Q  97    -101.305   1.485 -27.591  1.00 93.93           N  
ATOM   8129  CA  VAL Q  97    -102.680   1.901 -27.837  1.00 92.41           C  
ATOM   8130  C   VAL Q  97    -103.235   1.030 -28.958  1.00 91.41           C  
ATOM   8131  O   VAL Q  97    -102.539   0.735 -29.928  1.00 91.35           O  
ATOM   8132  CB  VAL Q  97    -102.751   3.391 -28.245  1.00 91.86           C  
ATOM   8133  CG1 VAL Q  97    -104.180   3.774 -28.601  1.00 90.67           C  
ATOM   8134  CG2 VAL Q  97    -102.246   4.261 -27.105  1.00 90.87           C  
ATOM   8135  N   PRO Q  98    -104.495   0.590 -28.832  1.00 91.14           N  
ATOM   8136  CA  PRO Q  98    -105.108  -0.258 -29.859  1.00 91.07           C  
ATOM   8137  C   PRO Q  98    -105.136   0.364 -31.255  1.00 91.21           C  
ATOM   8138  O   PRO Q  98    -105.309   1.576 -31.404  1.00 91.38           O  
ATOM   8139  CB  PRO Q  98    -106.516  -0.493 -29.313  1.00 89.89           C  
ATOM   8140  CG  PRO Q  98    -106.324  -0.421 -27.835  1.00 90.42           C  
ATOM   8141  CD  PRO Q  98    -105.406   0.765 -27.687  1.00 90.52           C  
ATOM   8142  N   ASP Q  99    -104.956  -0.470 -32.273  1.00 90.32           N  
ATOM   8143  CA  ASP Q  99    -105.010   0.004 -33.647  1.00 89.26           C  
ATOM   8144  C   ASP Q  99    -106.464   0.393 -33.886  1.00 88.95           C  
ATOM   8145  O   ASP Q  99    -107.373  -0.209 -33.309  1.00 89.40           O  
ATOM   8146  CB  ASP Q  99    -104.623  -1.105 -34.628  1.00 89.93           C  
ATOM   8147  CG  ASP Q  99    -103.218  -1.617 -34.407  1.00 91.57           C  
ATOM   8148  OD1 ASP Q  99    -102.274  -0.798 -34.386  1.00 92.83           O  
ATOM   8149  OD2 ASP Q  99    -103.055  -2.846 -34.262  1.00 93.55           O  
ATOM   8150  N   GLY Q 100    -106.684   1.395 -34.727  1.00 87.08           N  
ATOM   8151  CA  GLY Q 100    -108.041   1.820 -35.010  1.00 84.42           C  
ATOM   8152  C   GLY Q 100    -108.528   2.878 -34.044  1.00 83.08           C  
ATOM   8153  O   GLY Q 100    -109.590   3.464 -34.244  1.00 83.50           O  
ATOM   8154  N   THR Q 101    -107.759   3.116 -32.986  1.00 81.91           N  
ATOM   8155  CA  THR Q 101    -108.123   4.127 -32.001  1.00 81.53           C  
ATOM   8156  C   THR Q 101    -108.015   5.489 -32.675  1.00 81.27           C  
ATOM   8157  O   THR Q 101    -106.990   5.809 -33.284  1.00 81.35           O  
ATOM   8158  CB  THR Q 101    -107.174   4.094 -30.779  1.00 82.00           C  
ATOM   8159  OG1 THR Q 101    -107.300   2.832 -30.109  1.00 82.10           O  
ATOM   8160  CG2 THR Q 101    -107.505   5.226 -29.809  1.00 79.41           C  
ATOM   8161  N   LEU Q 102    -109.072   6.287 -32.571  1.00 79.90           N  
ATOM   8162  CA  LEU Q 102    -109.079   7.607 -33.187  1.00 78.35           C  
ATOM   8163  C   LEU Q 102    -108.280   8.637 -32.411  1.00 76.41           C  
ATOM   8164  O   LEU Q 102    -108.305   8.674 -31.181  1.00 75.28           O  
ATOM   8165  CB  LEU Q 102    -110.515   8.106 -33.370  1.00 77.46           C  
ATOM   8166  CG  LEU Q 102    -111.098   7.909 -34.773  1.00 77.49           C  
ATOM   8167  CD1 LEU Q 102    -110.973   6.458 -35.199  1.00 76.53           C  
ATOM   8168  CD2 LEU Q 102    -112.545   8.357 -34.781  1.00 77.68           C  
ATOM   8169  N   VAL Q 103    -107.559   9.465 -33.158  1.00 75.17           N  
ATOM   8170  CA  VAL Q 103    -106.749  10.531 -32.587  1.00 74.59           C  
ATOM   8171  C   VAL Q 103    -107.101  11.809 -33.338  1.00 73.96           C  
ATOM   8172  O   VAL Q 103    -107.180  11.812 -34.569  1.00 74.22           O  
ATOM   8173  CB  VAL Q 103    -105.239  10.261 -32.769  1.00 73.98           C  
ATOM   8174  CG1 VAL Q 103    -104.429  11.365 -32.087  1.00 72.44           C  
ATOM   8175  CG2 VAL Q 103    -104.878   8.896 -32.206  1.00 72.88           C  
ATOM   8176  N   THR Q 104    -107.329  12.893 -32.609  1.00 71.69           N  
ATOM   8177  CA  THR Q 104    -107.659  14.146 -33.262  1.00 71.11           C  
ATOM   8178  C   THR Q 104    -106.804  15.285 -32.734  1.00 71.66           C  
ATOM   8179  O   THR Q 104    -106.196  15.185 -31.664  1.00 70.94           O  
ATOM   8180  CB  THR Q 104    -109.148  14.511 -33.079  1.00 70.19           C  
ATOM   8181  OG1 THR Q 104    -109.412  14.750 -31.693  1.00 70.18           O  
ATOM   8182  CG2 THR Q 104    -110.043  13.386 -33.579  1.00 69.23           C  
ATOM   8183  N   VAL Q 105    -106.751  16.366 -33.508  1.00 72.29           N  
ATOM   8184  CA  VAL Q 105    -105.984  17.546 -33.134  1.00 72.15           C  
ATOM   8185  C   VAL Q 105    -106.906  18.755 -33.165  1.00 70.93           C  
ATOM   8186  O   VAL Q 105    -107.827  18.831 -33.980  1.00 70.23           O  
ATOM   8187  CB  VAL Q 105    -104.802  17.805 -34.110  1.00 72.49           C  
ATOM   8188  CG1 VAL Q 105    -104.024  19.041 -33.667  1.00 72.93           C  
ATOM   8189  CG2 VAL Q 105    -103.881  16.594 -34.159  1.00 72.39           C  
ATOM   8190  N   MET Q 106    -106.658  19.688 -32.259  1.00 69.79           N  
ATOM   8191  CA  MET Q 106    -107.438  20.906 -32.181  1.00 71.61           C  
ATOM   8192  C   MET Q 106    -106.440  22.022 -31.935  1.00 72.65           C  
ATOM   8193  O   MET Q 106    -105.395  21.792 -31.326  1.00 72.06           O  
ATOM   8194  CB  MET Q 106    -108.456  20.815 -31.042  1.00 71.86           C  
ATOM   8195  CG  MET Q 106    -109.566  19.795 -31.308  1.00 74.94           C  
ATOM   8196  SD  MET Q 106    -110.718  19.543 -29.931  1.00 74.78           S  
ATOM   8197  CE  MET Q 106    -111.934  20.831 -30.257  1.00 77.43           C  
ATOM   8198  N   ALA Q 107    -106.739  23.219 -32.429  1.00 73.72           N  
ATOM   8199  CA  ALA Q 107    -105.835  24.348 -32.245  1.00 76.01           C  
ATOM   8200  C   ALA Q 107    -106.581  25.561 -31.707  1.00 77.27           C  
ATOM   8201  O   ALA Q 107    -107.783  25.708 -31.921  1.00 77.92           O  
ATOM   8202  CB  ALA Q 107    -105.150  24.694 -33.567  1.00 75.61           C  
ATOM   8203  N   GLY Q 108    -105.863  26.428 -31.003  1.00 78.94           N  
ATOM   8204  CA  GLY Q 108    -106.487  27.612 -30.451  1.00 81.05           C  
ATOM   8205  C   GLY Q 108    -105.545  28.421 -29.586  1.00 83.43           C  
ATOM   8206  O   GLY Q 108    -104.418  28.004 -29.313  1.00 82.92           O  
ATOM   8207  N   ASN Q 109    -106.013  29.591 -29.163  1.00 86.32           N  
ATOM   8208  CA  ASN Q 109    -105.240  30.487 -28.313  1.00 89.75           C  
ATOM   8209  C   ASN Q 109    -106.164  31.554 -27.730  1.00 91.43           C  
ATOM   8210  O   ASN Q 109    -107.345  31.297 -27.489  1.00 89.45           O  
ATOM   8211  CB  ASN Q 109    -104.094  31.139 -29.108  1.00 90.34           C  
ATOM   8212  CG  ASN Q 109    -104.577  31.891 -30.343  1.00 92.20           C  
ATOM   8213  OD1 ASN Q 109    -105.403  32.798 -30.249  1.00 93.27           O  
ATOM   8214  ND2 ASN Q 109    -104.050  31.521 -31.507  1.00 92.62           N  
ATOM   8215  N   ASP Q 110    -105.623  32.745 -27.497  1.00 94.87           N  
ATOM   8216  CA  ASP Q 110    -106.414  33.841 -26.951  1.00 98.26           C  
ATOM   8217  C   ASP Q 110    -107.505  34.234 -27.945  1.00 99.05           C  
ATOM   8218  O   ASP Q 110    -108.686  33.961 -27.718  1.00 98.75           O  
ATOM   8219  CB  ASP Q 110    -105.518  35.050 -26.665  1.00100.47           C  
ATOM   8220  CG  ASP Q 110    -104.311  34.689 -25.822  1.00103.40           C  
ATOM   8221  OD1 ASP Q 110    -103.448  33.935 -26.320  1.00105.35           O  
ATOM   8222  OD2 ASP Q 110    -104.227  35.154 -24.663  1.00104.55           O  
ATOM   8223  N   GLU Q 111    -107.102  34.866 -29.047  1.00 99.20           N  
ATOM   8224  CA  GLU Q 111    -108.040  35.299 -30.082  1.00 99.23           C  
ATOM   8225  C   GLU Q 111    -108.896  34.127 -30.562  1.00 97.51           C  
ATOM   8226  O   GLU Q 111    -110.034  33.957 -30.119  1.00 98.49           O  
ATOM   8227  CB  GLU Q 111    -107.283  35.905 -31.268  1.00101.05           C  
ATOM   8228  CG  GLU Q 111    -106.242  36.950 -30.886  1.00103.20           C  
ATOM   8229  CD  GLU Q 111    -105.669  37.667 -32.096  1.00105.40           C  
ATOM   8230  OE1 GLU Q 111    -105.301  36.984 -33.077  1.00105.33           O  
ATOM   8231  OE2 GLU Q 111    -105.582  38.915 -32.065  1.00106.27           O  
ATOM   8232  N   ASN Q 112    -108.354  33.325 -31.474  1.00 94.12           N  
ATOM   8233  CA  ASN Q 112    -109.081  32.171 -31.982  1.00 91.62           C  
ATOM   8234  C   ASN Q 112    -108.955  31.071 -30.926  1.00 91.10           C  
ATOM   8235  O   ASN Q 112    -107.845  30.717 -30.532  1.00 91.33           O  
ATOM   8236  CB  ASN Q 112    -108.468  31.694 -33.300  1.00 89.20           C  
ATOM   8237  CG  ASN Q 112    -109.433  30.860 -34.125  1.00 85.37           C  
ATOM   8238  OD1 ASN Q 112    -110.324  30.204 -33.588  1.00 82.33           O  
ATOM   8239  ND2 ASN Q 112    -109.248  30.874 -35.438  1.00 84.56           N  
ATOM   8240  N   TYR Q 113    -110.084  30.534 -30.471  1.00 89.79           N  
ATOM   8241  CA  TYR Q 113    -110.066  29.495 -29.444  1.00 88.79           C  
ATOM   8242  C   TYR Q 113    -110.142  28.063 -29.986  1.00 87.08           C  
ATOM   8243  O   TYR Q 113    -109.602  27.136 -29.376  1.00 87.97           O  
ATOM   8244  CB  TYR Q 113    -111.193  29.748 -28.428  1.00 90.17           C  
ATOM   8245  CG  TYR Q 113    -112.585  29.780 -29.024  1.00 92.46           C  
ATOM   8246  CD1 TYR Q 113    -113.245  28.599 -29.370  1.00 93.76           C  
ATOM   8247  CD2 TYR Q 113    -113.238  30.993 -29.258  1.00 92.95           C  
ATOM   8248  CE1 TYR Q 113    -114.524  28.622 -29.934  1.00 93.71           C  
ATOM   8249  CE2 TYR Q 113    -114.518  31.027 -29.823  1.00 93.18           C  
ATOM   8250  CZ  TYR Q 113    -115.154  29.837 -30.159  1.00 93.77           C  
ATOM   8251  OH  TYR Q 113    -116.414  29.855 -30.722  1.00 92.35           O  
ATOM   8252  N   SER Q 114    -110.806  27.881 -31.123  1.00 83.32           N  
ATOM   8253  CA  SER Q 114    -110.920  26.555 -31.727  1.00 79.82           C  
ATOM   8254  C   SER Q 114    -110.786  26.680 -33.243  1.00 77.50           C  
ATOM   8255  O   SER Q 114    -111.737  26.441 -33.988  1.00 77.23           O  
ATOM   8256  CB  SER Q 114    -112.264  25.911 -31.369  1.00 80.02           C  
ATOM   8257  OG  SER Q 114    -112.261  24.521 -31.658  1.00 77.43           O  
ATOM   8258  N   ALA Q 115    -109.588  27.054 -33.681  1.00 74.36           N  
ATOM   8259  CA  ALA Q 115    -109.284  27.241 -35.093  1.00 72.55           C  
ATOM   8260  C   ALA Q 115    -109.765  26.098 -35.981  1.00 71.45           C  
ATOM   8261  O   ALA Q 115    -109.708  24.929 -35.596  1.00 70.62           O  
ATOM   8262  CB  ALA Q 115    -107.784  27.439 -35.268  1.00 71.21           C  
ATOM   8263  N   GLU Q 116    -110.236  26.448 -37.176  1.00 70.44           N  
ATOM   8264  CA  GLU Q 116    -110.720  25.460 -38.131  1.00 70.36           C  
ATOM   8265  C   GLU Q 116    -109.539  24.665 -38.682  1.00 69.18           C  
ATOM   8266  O   GLU Q 116    -108.490  25.230 -38.993  1.00 68.67           O  
ATOM   8267  CB  GLU Q 116    -111.460  26.149 -39.281  1.00 71.64           C  
ATOM   8268  CG  GLU Q 116    -112.212  25.184 -40.192  1.00 75.89           C  
ATOM   8269  CD  GLU Q 116    -112.979  25.888 -41.297  1.00 79.55           C  
ATOM   8270  OE1 GLU Q 116    -113.618  26.927 -41.009  1.00 81.80           O  
ATOM   8271  OE2 GLU Q 116    -112.952  25.398 -42.450  1.00 81.48           O  
ATOM   8272  N   LEU Q 117    -109.707  23.353 -38.802  1.00 66.18           N  
ATOM   8273  CA  LEU Q 117    -108.636  22.504 -39.302  1.00 63.90           C  
ATOM   8274  C   LEU Q 117    -109.155  21.553 -40.366  1.00 63.22           C  
ATOM   8275  O   LEU Q 117    -110.353  21.276 -40.438  1.00 64.02           O  
ATOM   8276  CB  LEU Q 117    -108.023  21.692 -38.152  1.00 61.19           C  
ATOM   8277  CG  LEU Q 117    -107.475  22.461 -36.945  1.00 59.75           C  
ATOM   8278  CD1 LEU Q 117    -107.071  21.482 -35.854  1.00 59.62           C  
ATOM   8279  CD2 LEU Q 117    -106.291  23.318 -37.364  1.00 58.77           C  
ATOM   8280  N   ARG Q 118    -108.247  21.058 -41.197  1.00 62.07           N  
ATOM   8281  CA  ARG Q 118    -108.617  20.113 -42.239  1.00 60.47           C  
ATOM   8282  C   ARG Q 118    -107.820  18.833 -41.997  1.00 59.46           C  
ATOM   8283  O   ARG Q 118    -106.614  18.889 -41.725  1.00 53.22           O  
ATOM   8284  CB  ARG Q 118    -108.298  20.683 -43.621  1.00 58.64           C  
ATOM   8285  CG  ARG Q 118    -108.710  19.783 -44.762  1.00 57.20           C  
ATOM   8286  CD  ARG Q 118    -110.212  19.549 -44.780  1.00 59.26           C  
ATOM   8287  NE  ARG Q 118    -110.616  18.745 -45.936  1.00 62.60           N  
ATOM   8288  CZ  ARG Q 118    -111.876  18.442 -46.241  1.00 65.39           C  
ATOM   8289  NH1 ARG Q 118    -112.874  18.878 -45.475  1.00 65.30           N  
ATOM   8290  NH2 ARG Q 118    -112.143  17.700 -47.311  1.00 64.44           N  
ATOM   8291  N   ASN Q 119    -108.515  17.698 -42.086  1.00 60.64           N  
ATOM   8292  CA  ASN Q 119    -107.932  16.373 -41.870  1.00 62.33           C  
ATOM   8293  C   ASN Q 119    -107.230  16.280 -40.513  1.00 63.12           C  
ATOM   8294  O   ASN Q 119    -106.055  15.914 -40.432  1.00 60.26           O  
ATOM   8295  CB  ASN Q 119    -106.949  16.041 -42.996  1.00 63.09           C  
ATOM   8296  CG  ASN Q 119    -107.584  16.130 -44.370  1.00 64.88           C  
ATOM   8297  OD1 ASN Q 119    -108.733  15.722 -44.564  1.00 64.26           O  
ATOM   8298  ND2 ASN Q 119    -106.837  16.655 -45.339  1.00 65.57           N  
ATOM   8299  N   ALA Q 120    -107.958  16.615 -39.450  1.00 65.80           N  
ATOM   8300  CA  ALA Q 120    -107.406  16.589 -38.098  1.00 69.30           C  
ATOM   8301  C   ALA Q 120    -107.752  15.305 -37.356  1.00 71.98           C  
ATOM   8302  O   ALA Q 120    -107.562  15.211 -36.145  1.00 71.50           O  
ATOM   8303  CB  ALA Q 120    -107.895  17.796 -37.308  1.00 67.79           C  
ATOM   8304  N   THR Q 121    -108.262  14.321 -38.089  1.00 75.38           N  
ATOM   8305  CA  THR Q 121    -108.619  13.042 -37.495  1.00 78.23           C  
ATOM   8306  C   THR Q 121    -107.765  11.944 -38.109  1.00 80.23           C  
ATOM   8307  O   THR Q 121    -107.646  11.846 -39.332  1.00 80.13           O  
ATOM   8308  CB  THR Q 121    -110.104  12.697 -37.726  1.00 78.54           C  
ATOM   8309  OG1 THR Q 121    -110.928  13.736 -37.180  1.00 79.31           O  
ATOM   8310  CG2 THR Q 121    -110.455  11.374 -37.047  1.00 78.43           C  
ATOM   8311  N   ALA Q 122    -107.172  11.122 -37.250  1.00 82.27           N  
ATOM   8312  CA  ALA Q 122    -106.323  10.026 -37.695  1.00 83.14           C  
ATOM   8313  C   ALA Q 122    -106.510   8.792 -36.815  1.00 83.75           C  
ATOM   8314  O   ALA Q 122    -106.836   8.901 -35.631  1.00 83.46           O  
ATOM   8315  CB  ALA Q 122    -104.857  10.465 -37.679  1.00 81.68           C  
ATOM   8316  N   ALA Q 123    -106.313   7.620 -37.411  1.00 85.73           N  
ATOM   8317  CA  ALA Q 123    -106.426   6.352 -36.690  1.00 87.42           C  
ATOM   8318  C   ALA Q 123    -105.005   5.872 -36.393  1.00 87.28           C  
ATOM   8319  O   ALA Q 123    -104.130   5.920 -37.261  1.00 86.66           O  
ATOM   8320  CB  ALA Q 123    -107.169   5.323 -37.539  1.00 87.23           C  
ATOM   8321  N   MET Q 124    -104.772   5.410 -35.169  1.00 87.62           N  
ATOM   8322  CA  MET Q 124    -103.442   4.954 -34.786  1.00 87.63           C  
ATOM   8323  C   MET Q 124    -103.126   3.533 -35.240  1.00 87.20           C  
ATOM   8324  O   MET Q 124    -103.962   2.635 -35.153  1.00 86.67           O  
ATOM   8325  CB  MET Q 124    -103.264   5.063 -33.272  1.00 86.23           C  
ATOM   8326  CG  MET Q 124    -101.818   5.154 -32.849  1.00 84.40           C  
ATOM   8327  SD  MET Q 124    -101.657   5.725 -31.162  1.00 87.24           S  
ATOM   8328  CE  MET Q 124    -102.014   7.465 -31.327  1.00 85.42           C  
ATOM   8329  N   LYS Q 125    -101.908   3.347 -35.733  1.00 86.97           N  
ATOM   8330  CA  LYS Q 125    -101.455   2.047 -36.199  1.00 87.72           C  
ATOM   8331  C   LYS Q 125     -99.974   1.919 -35.856  1.00 88.82           C  
ATOM   8332  O   LYS Q 125     -99.165   2.767 -36.238  1.00 88.76           O  
ATOM   8333  CB  LYS Q 125    -101.674   1.920 -37.711  1.00 86.15           C  
ATOM   8334  CG  LYS Q 125    -101.453   0.523 -38.268  1.00 84.56           C  
ATOM   8335  CD  LYS Q 125    -101.976   0.409 -39.695  1.00 83.56           C  
ATOM   8336  CE  LYS Q 125    -101.862  -1.015 -40.221  1.00 82.30           C  
ATOM   8337  NZ  LYS Q 125    -102.428  -1.155 -41.593  1.00 81.53           N  
ATOM   8338  N   ASN Q 126     -99.635   0.867 -35.112  1.00 89.70           N  
ATOM   8339  CA  ASN Q 126     -98.258   0.607 -34.696  1.00 90.29           C  
ATOM   8340  C   ASN Q 126     -97.719   1.682 -33.751  1.00 90.41           C  
ATOM   8341  O   ASN Q 126     -96.521   1.969 -33.755  1.00 89.40           O  
ATOM   8342  CB  ASN Q 126     -97.346   0.496 -35.924  1.00 90.90           C  
ATOM   8343  CG  ASN Q 126     -97.873  -0.488 -36.952  1.00 92.03           C  
ATOM   8344  OD1 ASN Q 126     -98.217  -1.621 -36.621  1.00 94.11           O  
ATOM   8345  ND2 ASN Q 126     -97.935  -0.060 -38.208  1.00 91.89           N  
ATOM   8346  N   GLN Q 127     -98.606   2.256 -32.937  1.00 91.51           N  
ATOM   8347  CA  GLN Q 127     -98.257   3.308 -31.974  1.00 93.37           C  
ATOM   8348  C   GLN Q 127     -98.036   4.649 -32.671  1.00 93.18           C  
ATOM   8349  O   GLN Q 127     -97.615   5.625 -32.047  1.00 91.76           O  
ATOM   8350  CB  GLN Q 127     -96.991   2.933 -31.196  1.00 95.75           C  
ATOM   8351  CG  GLN Q 127     -97.031   1.547 -30.574  1.00 99.34           C  
ATOM   8352  CD  GLN Q 127     -97.991   1.441 -29.407  1.00100.45           C  
ATOM   8353  OE1 GLN Q 127     -98.336   0.340 -28.977  1.00102.12           O  
ATOM   8354  NE2 GLN Q 127     -98.419   2.584 -28.881  1.00101.09           N  
ATOM   8355  N   VAL Q 128     -98.324   4.689 -33.969  1.00 93.42           N  
ATOM   8356  CA  VAL Q 128     -98.152   5.902 -34.756  1.00 92.87           C  
ATOM   8357  C   VAL Q 128     -99.423   6.291 -35.502  1.00 92.49           C  
ATOM   8358  O   VAL Q 128     -99.928   5.539 -36.334  1.00 91.46           O  
ATOM   8359  CB  VAL Q 128     -97.005   5.742 -35.783  1.00 92.48           C  
ATOM   8360  CG1 VAL Q 128     -96.918   6.971 -36.670  1.00 91.21           C  
ATOM   8361  CG2 VAL Q 128     -95.687   5.531 -35.056  1.00 92.02           C  
ATOM   8362  N   ALA Q 129     -99.935   7.475 -35.183  1.00 93.10           N  
ATOM   8363  CA  ALA Q 129    -101.132   8.002 -35.829  1.00 94.08           C  
ATOM   8364  C   ALA Q 129    -100.671   9.147 -36.725  1.00 93.78           C  
ATOM   8365  O   ALA Q 129    -100.386  10.242 -36.241  1.00 92.77           O  
ATOM   8366  CB  ALA Q 129    -102.115   8.515 -34.783  1.00 93.89           C  
ATOM   8367  N   ARG Q 130    -100.580   8.887 -38.026  1.00 93.86           N  
ATOM   8368  CA  ARG Q 130    -100.131   9.910 -38.962  1.00 95.36           C  
ATOM   8369  C   ARG Q 130    -101.289  10.547 -39.717  1.00 94.03           C  
ATOM   8370  O   ARG Q 130    -102.155   9.855 -40.257  1.00 93.07           O  
ATOM   8371  CB  ARG Q 130     -99.111   9.323 -39.946  1.00 97.84           C  
ATOM   8372  CG  ARG Q 130     -99.636   8.200 -40.827  1.00102.55           C  
ATOM   8373  CD  ARG Q 130     -98.489   7.479 -41.529  1.00106.14           C  
ATOM   8374  NE  ARG Q 130     -97.625   8.403 -42.261  1.00109.71           N  
ATOM   8375  CZ  ARG Q 130     -96.494   8.048 -42.867  1.00111.25           C  
ATOM   8376  NH1 ARG Q 130     -96.083   6.787 -42.830  1.00111.32           N  
ATOM   8377  NH2 ARG Q 130     -95.768   8.958 -43.505  1.00111.08           N  
ATOM   8378  N   PHE Q 131    -101.297  11.877 -39.738  1.00 93.00           N  
ATOM   8379  CA  PHE Q 131    -102.342  12.631 -40.414  1.00 92.54           C  
ATOM   8380  C   PHE Q 131    -101.980  12.891 -41.874  1.00 91.73           C  
ATOM   8381  O   PHE Q 131    -100.958  13.513 -42.170  1.00 91.37           O  
ATOM   8382  CB  PHE Q 131    -102.584  13.966 -39.698  1.00 93.04           C  
ATOM   8383  CG  PHE Q 131    -103.025  13.822 -38.265  1.00 93.34           C  
ATOM   8384  CD1 PHE Q 131    -102.123  13.440 -37.276  1.00 92.93           C  
ATOM   8385  CD2 PHE Q 131    -104.351  14.061 -37.904  1.00 93.69           C  
ATOM   8386  CE1 PHE Q 131    -102.533  13.297 -35.949  1.00 93.27           C  
ATOM   8387  CE2 PHE Q 131    -104.773  13.922 -36.581  1.00 94.03           C  
ATOM   8388  CZ  PHE Q 131    -103.861  13.539 -35.602  1.00 94.17           C  
ATOM   8389  N   ASN Q 132    -102.823  12.407 -42.780  1.00 90.90           N  
ATOM   8390  CA  ASN Q 132    -102.603  12.593 -44.208  1.00 90.66           C  
ATOM   8391  C   ASN Q 132    -102.919  14.039 -44.586  1.00 90.34           C  
ATOM   8392  O   ASN Q 132    -104.038  14.358 -44.990  1.00 90.10           O  
ATOM   8393  CB  ASN Q 132    -103.499  11.644 -45.005  1.00 92.42           C  
ATOM   8394  CG  ASN Q 132    -103.256  11.736 -46.495  1.00 93.66           C  
ATOM   8395  OD1 ASN Q 132    -102.171  11.412 -46.978  1.00 94.41           O  
ATOM   8396  ND2 ASN Q 132    -104.266  12.185 -47.232  1.00 93.37           N  
ATOM   8397  N   ASP Q 133    -101.920  14.904 -44.439  1.00 89.29           N  
ATOM   8398  CA  ASP Q 133    -102.040  16.329 -44.742  1.00 87.91           C  
ATOM   8399  C   ASP Q 133    -102.983  17.091 -43.812  1.00 86.34           C  
ATOM   8400  O   ASP Q 133    -104.190  17.195 -44.055  1.00 84.64           O  
ATOM   8401  CB  ASP Q 133    -102.471  16.544 -46.198  1.00 88.32           C  
ATOM   8402  CG  ASP Q 133    -102.570  18.017 -46.562  1.00 88.34           C  
ATOM   8403  OD1 ASP Q 133    -101.582  18.756 -46.353  1.00 86.20           O  
ATOM   8404  OD2 ASP Q 133    -103.639  18.435 -47.059  1.00 88.29           O  
ATOM   8405  N   LEU Q 134    -102.407  17.622 -42.741  1.00 84.59           N  
ATOM   8406  CA  LEU Q 134    -103.146  18.402 -41.760  1.00 82.24           C  
ATOM   8407  C   LEU Q 134    -103.019  19.865 -42.169  1.00 80.47           C  
ATOM   8408  O   LEU Q 134    -101.915  20.347 -42.435  1.00 79.76           O  
ATOM   8409  CB  LEU Q 134    -102.540  18.200 -40.368  1.00 81.71           C  
ATOM   8410  CG  LEU Q 134    -103.108  19.017 -39.205  1.00 80.57           C  
ATOM   8411  CD1 LEU Q 134    -104.553  18.621 -38.963  1.00 80.39           C  
ATOM   8412  CD2 LEU Q 134    -102.269  18.778 -37.957  1.00 78.71           C  
ATOM   8413  N   ARG Q 135    -104.145  20.567 -42.227  1.00 77.56           N  
ATOM   8414  CA  ARG Q 135    -104.134  21.975 -42.606  1.00 73.56           C  
ATOM   8415  C   ARG Q 135    -104.890  22.860 -41.629  1.00 71.47           C  
ATOM   8416  O   ARG Q 135    -105.935  22.485 -41.097  1.00 68.97           O  
ATOM   8417  CB  ARG Q 135    -104.710  22.148 -44.010  1.00 72.72           C  
ATOM   8418  CG  ARG Q 135    -103.667  22.135 -45.117  1.00 71.28           C  
ATOM   8419  CD  ARG Q 135    -104.339  22.105 -46.471  1.00 69.73           C  
ATOM   8420  NE  ARG Q 135    -104.946  20.806 -46.734  1.00 67.34           N  
ATOM   8421  CZ  ARG Q 135    -106.142  20.632 -47.286  1.00 65.93           C  
ATOM   8422  NH1 ARG Q 135    -106.879  21.678 -47.635  1.00 62.34           N  
ATOM   8423  NH2 ARG Q 135    -106.592  19.404 -47.497  1.00 66.53           N  
ATOM   8424  N   PHE Q 136    -104.350  24.049 -41.400  1.00 70.54           N  
ATOM   8425  CA  PHE Q 136    -104.965  24.998 -40.489  1.00 70.11           C  
ATOM   8426  C   PHE Q 136    -105.752  26.070 -41.239  1.00 67.66           C  
ATOM   8427  O   PHE Q 136    -105.177  27.008 -41.787  1.00 67.41           O  
ATOM   8428  CB  PHE Q 136    -103.890  25.652 -39.620  1.00 72.69           C  
ATOM   8429  CG  PHE Q 136    -103.086  24.671 -38.822  1.00 76.91           C  
ATOM   8430  CD1 PHE Q 136    -102.260  23.748 -39.459  1.00 77.29           C  
ATOM   8431  CD2 PHE Q 136    -103.168  24.653 -37.432  1.00 79.13           C  
ATOM   8432  CE1 PHE Q 136    -101.528  22.821 -38.728  1.00 77.94           C  
ATOM   8433  CE2 PHE Q 136    -102.437  23.727 -36.687  1.00 79.74           C  
ATOM   8434  CZ  PHE Q 136    -101.615  22.809 -37.339  1.00 79.83           C  
ATOM   8435  N   VAL Q 137    -107.073  25.911 -41.268  1.00 64.57           N  
ATOM   8436  CA  VAL Q 137    -107.951  26.864 -41.933  1.00 62.34           C  
ATOM   8437  C   VAL Q 137    -108.022  28.124 -41.075  1.00 61.55           C  
ATOM   8438  O   VAL Q 137    -107.814  29.231 -41.564  1.00 61.67           O  
ATOM   8439  CB  VAL Q 137    -109.368  26.283 -42.094  1.00 61.84           C  
ATOM   8440  CG1 VAL Q 137    -110.220  27.216 -42.941  1.00 57.97           C  
ATOM   8441  CG2 VAL Q 137    -109.290  24.894 -42.713  1.00 60.05           C  
ATOM   8442  N   GLY Q 138    -108.321  27.940 -39.791  1.00 62.26           N  
ATOM   8443  CA  GLY Q 138    -108.386  29.056 -38.867  1.00 61.77           C  
ATOM   8444  C   GLY Q 138    -107.001  29.663 -38.761  1.00 64.23           C  
ATOM   8445  O   GLY Q 138    -106.017  29.045 -39.171  1.00 62.85           O  
ATOM   8446  N   ARG Q 139    -106.911  30.867 -38.208  1.00 65.90           N  
ATOM   8447  CA  ARG Q 139    -105.626  31.538 -38.085  1.00 68.44           C  
ATOM   8448  C   ARG Q 139    -105.358  32.033 -36.670  1.00 69.14           C  
ATOM   8449  O   ARG Q 139    -106.286  32.304 -35.911  1.00 66.97           O  
ATOM   8450  CB  ARG Q 139    -105.575  32.706 -39.069  1.00 69.46           C  
ATOM   8451  CG  ARG Q 139    -105.569  32.278 -40.538  1.00 73.74           C  
ATOM   8452  CD  ARG Q 139    -106.059  33.399 -41.448  1.00 73.25           C  
ATOM   8453  NE  ARG Q 139    -107.512  33.374 -41.601  1.00 70.09           N  
ATOM   8454  CZ  ARG Q 139    -108.261  34.443 -41.862  1.00 67.57           C  
ATOM   8455  NH1 ARG Q 139    -107.702  35.639 -41.995  1.00 63.74           N  
ATOM   8456  NH2 ARG Q 139    -109.572  34.311 -41.998  1.00 65.44           N  
ATOM   8457  N   SER Q 140    -104.083  32.133 -36.310  1.00 72.56           N  
ATOM   8458  CA  SER Q 140    -103.717  32.609 -34.982  1.00 77.01           C  
ATOM   8459  C   SER Q 140    -103.683  34.137 -34.975  1.00 79.90           C  
ATOM   8460  O   SER Q 140    -103.670  34.766 -33.914  1.00 81.34           O  
ATOM   8461  CB  SER Q 140    -102.355  32.032 -34.554  1.00 77.46           C  
ATOM   8462  OG  SER Q 140    -101.309  32.389 -35.444  1.00 78.32           O  
ATOM   8463  N   GLY Q 141    -103.684  34.727 -36.169  1.00 82.58           N  
ATOM   8464  CA  GLY Q 141    -103.663  36.176 -36.288  1.00 85.48           C  
ATOM   8465  C   GLY Q 141    -102.545  36.825 -35.498  1.00 87.72           C  
ATOM   8466  O   GLY Q 141    -101.409  36.346 -35.519  1.00 87.72           O  
ATOM   8467  N   ARG Q 142    -102.868  37.913 -34.801  1.00 89.78           N  
ATOM   8468  CA  ARG Q 142    -101.887  38.639 -33.993  1.00 92.45           C  
ATOM   8469  C   ARG Q 142    -101.629  37.894 -32.682  1.00 91.88           C  
ATOM   8470  O   ARG Q 142    -100.587  38.069 -32.047  1.00 89.97           O  
ATOM   8471  CB  ARG Q 142    -102.394  40.050 -33.666  1.00 95.96           C  
ATOM   8472  CG  ARG Q 142    -103.532  40.554 -34.545  1.00100.58           C  
ATOM   8473  CD  ARG Q 142    -103.094  40.838 -35.971  1.00104.29           C  
ATOM   8474  NE  ARG Q 142    -104.217  41.309 -36.782  1.00107.63           N  
ATOM   8475  CZ  ARG Q 142    -104.120  41.694 -38.051  1.00108.53           C  
ATOM   8476  NH1 ARG Q 142    -102.947  41.670 -38.671  1.00108.58           N  
ATOM   8477  NH2 ARG Q 142    -105.201  42.099 -38.705  1.00109.34           N  
ATOM   8478  N   GLY Q 143    -102.594  37.069 -32.286  1.00 91.99           N  
ATOM   8479  CA  GLY Q 143    -102.476  36.309 -31.055  1.00 91.00           C  
ATOM   8480  C   GLY Q 143    -101.348  35.301 -31.080  1.00 89.76           C  
ATOM   8481  O   GLY Q 143    -100.750  35.049 -32.127  1.00 88.71           O  
ATOM   8482  N   LYS Q 144    -101.057  34.722 -29.920  1.00 90.32           N  
ATOM   8483  CA  LYS Q 144     -99.992  33.733 -29.805  1.00 90.04           C  
ATOM   8484  C   LYS Q 144    -100.329  32.521 -30.662  1.00 89.52           C  
ATOM   8485  O   LYS Q 144    -101.488  32.305 -31.021  1.00 88.99           O  
ATOM   8486  CB  LYS Q 144     -99.814  33.315 -28.349  1.00 88.51           C  
ATOM   8487  N   SER Q 145     -99.307  31.740 -30.994  1.00 89.12           N  
ATOM   8488  CA  SER Q 145     -99.496  30.547 -31.806  1.00 88.20           C  
ATOM   8489  C   SER Q 145    -100.554  29.673 -31.162  1.00 87.36           C  
ATOM   8490  O   SER Q 145    -100.885  29.844 -29.989  1.00 87.14           O  
ATOM   8491  CB  SER Q 145     -98.184  29.766 -31.919  1.00 88.48           C  
ATOM   8492  OG  SER Q 145     -97.692  29.418 -30.641  1.00 87.98           O  
ATOM   8493  N   PHE Q 146    -101.091  28.737 -31.933  1.00 87.04           N  
ATOM   8494  CA  PHE Q 146    -102.111  27.843 -31.416  1.00 86.37           C  
ATOM   8495  C   PHE Q 146    -101.508  26.825 -30.471  1.00 85.50           C  
ATOM   8496  O   PHE Q 146    -100.320  26.515 -30.543  1.00 84.87           O  
ATOM   8497  CB  PHE Q 146    -102.799  27.081 -32.549  1.00 87.14           C  
ATOM   8498  CG  PHE Q 146    -103.584  27.949 -33.487  1.00 89.84           C  
ATOM   8499  CD1 PHE Q 146    -104.483  28.893 -33.000  1.00 89.56           C  
ATOM   8500  CD2 PHE Q 146    -103.469  27.780 -34.865  1.00 89.60           C  
ATOM   8501  CE1 PHE Q 146    -105.256  29.650 -33.867  1.00 89.15           C  
ATOM   8502  CE2 PHE Q 146    -104.238  28.532 -35.738  1.00 89.99           C  
ATOM   8503  CZ  PHE Q 146    -105.134  29.467 -35.237  1.00 89.67           C  
ATOM   8504  N   THR Q 147    -102.339  26.315 -29.573  1.00 85.38           N  
ATOM   8505  CA  THR Q 147    -101.911  25.281 -28.649  1.00 85.49           C  
ATOM   8506  C   THR Q 147    -102.632  24.037 -29.150  1.00 85.05           C  
ATOM   8507  O   THR Q 147    -103.863  24.006 -29.203  1.00 84.31           O  
ATOM   8508  CB  THR Q 147    -102.339  25.579 -27.188  1.00 85.44           C  
ATOM   8509  OG1 THR Q 147    -101.576  26.678 -26.671  1.00 83.95           O  
ATOM   8510  CG2 THR Q 147    -102.105  24.362 -26.313  1.00 84.60           C  
ATOM   8511  N   LEU Q 148    -101.865  23.031 -29.554  1.00 84.99           N  
ATOM   8512  CA  LEU Q 148    -102.450  21.795 -30.050  1.00 86.08           C  
ATOM   8513  C   LEU Q 148    -103.056  20.972 -28.923  1.00 86.12           C  
ATOM   8514  O   LEU Q 148    -102.576  20.995 -27.788  1.00 85.89           O  
ATOM   8515  CB  LEU Q 148    -101.399  20.956 -30.787  1.00 87.59           C  
ATOM   8516  CG  LEU Q 148    -101.301  21.119 -32.307  1.00 89.12           C  
ATOM   8517  CD1 LEU Q 148    -101.020  22.568 -32.656  1.00 89.73           C  
ATOM   8518  CD2 LEU Q 148    -100.204  20.213 -32.847  1.00 89.48           C  
ATOM   8519  N   THR Q 149    -104.123  20.254 -29.249  1.00 85.91           N  
ATOM   8520  CA  THR Q 149    -104.805  19.401 -28.289  1.00 84.79           C  
ATOM   8521  C   THR Q 149    -104.991  18.028 -28.928  1.00 84.86           C  
ATOM   8522  O   THR Q 149    -105.983  17.768 -29.614  1.00 84.19           O  
ATOM   8523  CB  THR Q 149    -106.183  19.992 -27.885  1.00 83.88           C  
ATOM   8524  OG1 THR Q 149    -105.986  21.228 -27.189  1.00 81.98           O  
ATOM   8525  CG2 THR Q 149    -106.938  19.029 -26.979  1.00 82.24           C  
ATOM   8526  N   ILE Q 150    -104.010  17.159 -28.712  1.00 85.17           N  
ATOM   8527  CA  ILE Q 150    -104.053  15.807 -29.252  1.00 85.45           C  
ATOM   8528  C   ILE Q 150    -104.945  14.971 -28.345  1.00 85.21           C  
ATOM   8529  O   ILE Q 150    -104.602  14.717 -27.191  1.00 84.81           O  
ATOM   8530  CB  ILE Q 150    -102.648  15.160 -29.280  1.00 85.01           C  
ATOM   8531  CG1 ILE Q 150    -101.632  16.129 -29.883  1.00 83.73           C  
ATOM   8532  CG2 ILE Q 150    -102.686  13.873 -30.098  1.00 86.01           C  
ATOM   8533  CD1 ILE Q 150    -100.214  15.609 -29.855  1.00 84.39           C  
ATOM   8534  N   THR Q 151    -106.095  14.551 -28.857  1.00 85.12           N  
ATOM   8535  CA  THR Q 151    -107.002  13.747 -28.057  1.00 85.32           C  
ATOM   8536  C   THR Q 151    -107.090  12.326 -28.598  1.00 85.99           C  
ATOM   8537  O   THR Q 151    -107.744  12.068 -29.609  1.00 84.60           O  
ATOM   8538  CB  THR Q 151    -108.408  14.373 -28.010  1.00 84.78           C  
ATOM   8539  OG1 THR Q 151    -108.325  15.678 -27.421  1.00 83.20           O  
ATOM   8540  CG2 THR Q 151    -109.344  13.515 -27.176  1.00 83.99           C  
ATOM   8541  N   VAL Q 152    -106.406  11.413 -27.914  1.00 87.57           N  
ATOM   8542  CA  VAL Q 152    -106.387  10.007 -28.291  1.00 89.19           C  
ATOM   8543  C   VAL Q 152    -107.618   9.343 -27.697  1.00 91.36           C  
ATOM   8544  O   VAL Q 152    -107.630   8.944 -26.531  1.00 90.14           O  
ATOM   8545  CB  VAL Q 152    -105.123   9.310 -27.766  1.00 87.68           C  
ATOM   8546  CG1 VAL Q 152    -105.092   7.863 -28.238  1.00 87.21           C  
ATOM   8547  CG2 VAL Q 152    -103.896  10.058 -28.245  1.00 85.36           C  
ATOM   8548  N   PHE Q 153    -108.654   9.239 -28.518  1.00 94.02           N  
ATOM   8549  CA  PHE Q 153    -109.922   8.661 -28.108  1.00 96.41           C  
ATOM   8550  C   PHE Q 153    -109.854   7.231 -27.594  1.00 96.59           C  
ATOM   8551  O   PHE Q 153    -110.112   6.270 -28.320  1.00 96.58           O  
ATOM   8552  CB  PHE Q 153    -110.924   8.780 -29.259  1.00 98.72           C  
ATOM   8553  CG  PHE Q 153    -111.440  10.182 -29.468  1.00101.42           C  
ATOM   8554  CD1 PHE Q 153    -111.444  11.102 -28.421  1.00101.43           C  
ATOM   8555  CD2 PHE Q 153    -111.949  10.575 -30.701  1.00104.01           C  
ATOM   8556  CE1 PHE Q 153    -111.948  12.387 -28.596  1.00102.07           C  
ATOM   8557  CE2 PHE Q 153    -112.457  11.863 -30.885  1.00105.13           C  
ATOM   8558  CZ  PHE Q 153    -112.454  12.769 -29.827  1.00103.75           C  
ATOM   8559  N   THR Q 154    -109.502   7.110 -26.321  1.00 97.82           N  
ATOM   8560  CA  THR Q 154    -109.415   5.821 -25.654  1.00 98.84           C  
ATOM   8561  C   THR Q 154    -110.635   5.747 -24.734  1.00 98.77           C  
ATOM   8562  O   THR Q 154    -111.547   6.573 -24.830  1.00 98.04           O  
ATOM   8563  CB  THR Q 154    -108.132   5.710 -24.791  1.00 98.74           C  
ATOM   8564  OG1 THR Q 154    -107.015   6.244 -25.510  1.00 98.19           O  
ATOM   8565  CG2 THR Q 154    -107.844   4.254 -24.457  1.00 99.31           C  
ATOM   8566  N   ASN Q 155    -110.642   4.767 -23.842  1.00 99.07           N  
ATOM   8567  CA  ASN Q 155    -111.741   4.593 -22.901  1.00 99.68           C  
ATOM   8568  C   ASN Q 155    -111.219   4.488 -21.469  1.00 98.73           C  
ATOM   8569  O   ASN Q 155    -110.880   3.402 -21.003  1.00 98.28           O  
ATOM   8570  CB  ASN Q 155    -112.548   3.339 -23.268  1.00100.54           C  
ATOM   8571  CG  ASN Q 155    -111.717   2.303 -24.021  1.00101.78           C  
ATOM   8572  OD1 ASN Q 155    -110.645   1.895 -23.566  1.00101.10           O  
ATOM   8573  ND2 ASN Q 155    -112.214   1.873 -25.177  1.00101.02           N  
ATOM   8574  N   PRO Q 156    -111.141   5.622 -20.750  1.00 98.95           N  
ATOM   8575  CA  PRO Q 156    -111.505   6.986 -21.159  1.00 99.66           C  
ATOM   8576  C   PRO Q 156    -110.499   7.631 -22.125  1.00 99.86           C  
ATOM   8577  O   PRO Q 156    -109.460   7.048 -22.440  1.00100.27           O  
ATOM   8578  CB  PRO Q 156    -111.577   7.725 -19.827  1.00 98.75           C  
ATOM   8579  CG  PRO Q 156    -110.462   7.096 -19.067  1.00 98.47           C  
ATOM   8580  CD  PRO Q 156    -110.665   5.616 -19.355  1.00 98.90           C  
ATOM   8581  N   PRO Q 157    -110.798   8.851 -22.600  1.00 99.24           N  
ATOM   8582  CA  PRO Q 157    -109.916   9.563 -23.530  1.00 98.13           C  
ATOM   8583  C   PRO Q 157    -108.629  10.109 -22.911  1.00 97.05           C  
ATOM   8584  O   PRO Q 157    -108.588  10.465 -21.731  1.00 97.12           O  
ATOM   8585  CB  PRO Q 157    -110.813  10.677 -24.055  1.00 98.12           C  
ATOM   8586  CG  PRO Q 157    -111.635  11.007 -22.854  1.00 98.23           C  
ATOM   8587  CD  PRO Q 157    -112.022   9.634 -22.349  1.00 98.76           C  
ATOM   8588  N   GLN Q 158    -107.582  10.168 -23.730  1.00 95.80           N  
ATOM   8589  CA  GLN Q 158    -106.279  10.684 -23.319  1.00 93.33           C  
ATOM   8590  C   GLN Q 158    -106.008  11.989 -24.075  1.00 93.68           C  
ATOM   8591  O   GLN Q 158    -106.322  12.101 -25.263  1.00 93.91           O  
ATOM   8592  CB  GLN Q 158    -105.184   9.658 -23.623  1.00 90.88           C  
ATOM   8593  CG  GLN Q 158    -105.158   8.472 -22.665  1.00 85.60           C  
ATOM   8594  CD  GLN Q 158    -104.094   7.450 -23.026  1.00 83.50           C  
ATOM   8595  OE1 GLN Q 158    -104.306   6.589 -23.881  1.00 81.60           O  
ATOM   8596  NE2 GLN Q 158    -102.935   7.549 -22.382  1.00 80.99           N  
ATOM   8597  N   VAL Q 159    -105.429  12.970 -23.387  1.00 92.57           N  
ATOM   8598  CA  VAL Q 159    -105.147  14.263 -23.999  1.00 91.57           C  
ATOM   8599  C   VAL Q 159    -103.702  14.724 -23.822  1.00 91.79           C  
ATOM   8600  O   VAL Q 159    -103.125  14.609 -22.741  1.00 90.60           O  
ATOM   8601  CB  VAL Q 159    -106.090  15.351 -23.433  1.00 91.42           C  
ATOM   8602  CG1 VAL Q 159    -105.761  16.709 -24.041  1.00 90.95           C  
ATOM   8603  CG2 VAL Q 159    -107.531  14.984 -23.728  1.00 90.53           C  
ATOM   8604  N   ALA Q 160    -103.129  15.249 -24.903  1.00 92.25           N  
ATOM   8605  CA  ALA Q 160    -101.757  15.746 -24.905  1.00 91.64           C  
ATOM   8606  C   ALA Q 160    -101.718  17.160 -25.487  1.00 90.99           C  
ATOM   8607  O   ALA Q 160    -102.091  17.383 -26.639  1.00 89.95           O  
ATOM   8608  CB  ALA Q 160    -100.864  14.817 -25.723  1.00 91.62           C  
ATOM   8609  N   THR Q 161    -101.265  18.113 -24.679  1.00 90.80           N  
ATOM   8610  CA  THR Q 161    -101.178  19.503 -25.105  1.00 89.75           C  
ATOM   8611  C   THR Q 161     -99.785  19.860 -25.610  1.00 89.87           C  
ATOM   8612  O   THR Q 161     -98.787  19.289 -25.172  1.00 88.74           O  
ATOM   8613  CB  THR Q 161    -101.547  20.455 -23.948  1.00 88.86           C  
ATOM   8614  OG1 THR Q 161    -102.945  20.342 -23.664  1.00 89.18           O  
ATOM   8615  CG2 THR Q 161    -101.231  21.887 -24.314  1.00 90.07           C  
ATOM   8616  N   TYR Q 162     -99.732  20.806 -26.544  1.00 91.47           N  
ATOM   8617  CA  TYR Q 162     -98.476  21.275 -27.116  1.00 92.85           C  
ATOM   8618  C   TYR Q 162     -98.613  22.780 -27.320  1.00 92.76           C  
ATOM   8619  O   TYR Q 162     -99.023  23.235 -28.384  1.00 93.24           O  
ATOM   8620  CB  TYR Q 162     -98.204  20.582 -28.456  1.00 94.39           C  
ATOM   8621  CG  TYR Q 162     -96.758  20.650 -28.903  1.00 98.08           C  
ATOM   8622  CD1 TYR Q 162     -95.747  20.032 -28.161  1.00 99.42           C  
ATOM   8623  CD2 TYR Q 162     -96.396  21.333 -30.065  1.00 99.10           C  
ATOM   8624  CE1 TYR Q 162     -94.411  20.095 -28.565  1.00100.89           C  
ATOM   8625  CE2 TYR Q 162     -95.063  21.404 -30.478  1.00100.20           C  
ATOM   8626  CZ  TYR Q 162     -94.075  20.782 -29.724  1.00101.59           C  
ATOM   8627  OH  TYR Q 162     -92.757  20.847 -30.128  1.00101.73           O  
ATOM   8628  N   HIS Q 163     -98.278  23.545 -26.286  1.00 93.39           N  
ATOM   8629  CA  HIS Q 163     -98.374  25.003 -26.324  1.00 93.64           C  
ATOM   8630  C   HIS Q 163     -97.347  25.652 -27.250  1.00 93.07           C  
ATOM   8631  O   HIS Q 163     -96.296  25.072 -27.528  1.00 92.85           O  
ATOM   8632  CB  HIS Q 163     -98.203  25.570 -24.913  1.00 93.70           C  
ATOM   8633  CG  HIS Q 163     -99.222  25.070 -23.936  1.00 95.49           C  
ATOM   8634  ND1 HIS Q 163    -100.544  25.455 -23.979  1.00 96.11           N  
ATOM   8635  CD2 HIS Q 163     -99.111  24.209 -22.898  1.00 95.06           C  
ATOM   8636  CE1 HIS Q 163    -101.207  24.851 -23.008  1.00 95.75           C  
ATOM   8637  NE2 HIS Q 163    -100.361  24.089 -22.338  1.00 95.25           N  
ATOM   8638  N   ARG Q 164     -97.667  26.859 -27.722  1.00 91.92           N  
ATOM   8639  CA  ARG Q 164     -96.785  27.621 -28.606  1.00 90.55           C  
ATOM   8640  C   ARG Q 164     -96.286  26.745 -29.755  1.00 87.50           C  
ATOM   8641  O   ARG Q 164     -95.094  26.729 -30.070  1.00 86.51           O  
ATOM   8642  CB  ARG Q 164     -95.599  28.156 -27.797  1.00 94.25           C  
ATOM   8643  CG  ARG Q 164     -96.001  28.893 -26.520  1.00 98.89           C  
ATOM   8644  CD  ARG Q 164     -94.830  28.998 -25.550  1.00104.36           C  
ATOM   8645  NE  ARG Q 164     -95.155  29.801 -24.372  1.00109.22           N  
ATOM   8646  CZ  ARG Q 164     -94.305  30.041 -23.374  1.00112.33           C  
ATOM   8647  NH1 ARG Q 164     -93.078  29.535 -23.409  1.00113.62           N  
ATOM   8648  NH2 ARG Q 164     -94.677  30.799 -22.347  1.00111.82           N  
ATOM   8649  N   ALA Q 165     -97.210  26.037 -30.394  1.00 83.64           N  
ATOM   8650  CA  ALA Q 165     -96.863  25.126 -31.475  1.00 80.83           C  
ATOM   8651  C   ALA Q 165     -96.796  25.695 -32.885  1.00 79.07           C  
ATOM   8652  O   ALA Q 165     -95.971  25.254 -33.685  1.00 79.87           O  
ATOM   8653  CB  ALA Q 165     -97.814  23.941 -31.459  1.00 80.17           C  
ATOM   8654  N   ILE Q 166     -97.648  26.662 -33.207  1.00 75.70           N  
ATOM   8655  CA  ILE Q 166     -97.638  27.189 -34.564  1.00 72.61           C  
ATOM   8656  C   ILE Q 166     -98.518  28.428 -34.762  1.00 72.39           C  
ATOM   8657  O   ILE Q 166     -99.659  28.475 -34.301  1.00 71.50           O  
ATOM   8658  CB  ILE Q 166     -98.088  26.069 -35.553  1.00 69.41           C  
ATOM   8659  CG1 ILE Q 166     -97.950  26.532 -37.001  1.00 68.60           C  
ATOM   8660  CG2 ILE Q 166     -99.533  25.663 -35.260  1.00 66.36           C  
ATOM   8661  CD1 ILE Q 166     -98.275  25.441 -38.017  1.00 66.86           C  
ATOM   8662  N   LYS Q 167     -97.971  29.434 -35.440  1.00 71.58           N  
ATOM   8663  CA  LYS Q 167     -98.719  30.652 -35.731  1.00 72.26           C  
ATOM   8664  C   LYS Q 167     -99.209  30.557 -37.168  1.00 71.80           C  
ATOM   8665  O   LYS Q 167     -98.449  30.188 -38.068  1.00 71.60           O  
ATOM   8666  CB  LYS Q 167     -97.841  31.896 -35.556  1.00 72.06           C  
ATOM   8667  CG  LYS Q 167     -97.481  32.183 -34.110  1.00 74.56           C  
ATOM   8668  CD  LYS Q 167     -96.765  33.512 -33.954  1.00 76.99           C  
ATOM   8669  CE  LYS Q 167     -96.552  33.841 -32.483  1.00 78.19           C  
ATOM   8670  NZ  LYS Q 167     -95.968  35.198 -32.287  1.00 78.97           N  
ATOM   8671  N   ILE Q 168    -100.480  30.872 -37.383  1.00 71.10           N  
ATOM   8672  CA  ILE Q 168    -101.046  30.801 -38.722  1.00 70.40           C  
ATOM   8673  C   ILE Q 168    -101.618  32.133 -39.188  1.00 70.29           C  
ATOM   8674  O   ILE Q 168    -102.362  32.793 -38.458  1.00 70.33           O  
ATOM   8675  CB  ILE Q 168    -102.159  29.739 -38.796  1.00 69.72           C  
ATOM   8676  CG1 ILE Q 168    -101.607  28.374 -38.359  1.00 69.08           C  
ATOM   8677  CG2 ILE Q 168    -102.727  29.678 -40.215  1.00 68.18           C  
ATOM   8678  CD1 ILE Q 168    -100.505  27.823 -39.255  1.00 65.71           C  
ATOM   8679  N   THR Q 169    -101.261  32.519 -40.409  1.00 69.18           N  
ATOM   8680  CA  THR Q 169    -101.741  33.759 -41.005  1.00 69.05           C  
ATOM   8681  C   THR Q 169    -102.162  33.474 -42.436  1.00 71.33           C  
ATOM   8682  O   THR Q 169    -101.886  32.397 -42.969  1.00 70.86           O  
ATOM   8683  CB  THR Q 169    -100.646  34.847 -41.042  1.00 68.17           C  
ATOM   8684  OG1 THR Q 169     -99.547  34.397 -41.847  1.00 66.28           O  
ATOM   8685  CG2 THR Q 169    -100.166  35.173 -39.637  1.00 66.26           C  
ATOM   8686  N   VAL Q 170    -102.826  34.447 -43.055  1.00 74.09           N  
ATOM   8687  CA  VAL Q 170    -103.277  34.316 -44.435  1.00 75.84           C  
ATOM   8688  C   VAL Q 170    -102.075  34.143 -45.368  1.00 76.61           C  
ATOM   8689  O   VAL Q 170    -102.151  33.421 -46.360  1.00 75.01           O  
ATOM   8690  CB  VAL Q 170    -104.098  35.554 -44.868  1.00 76.52           C  
ATOM   8691  CG1 VAL Q 170    -104.548  35.411 -46.313  1.00 78.22           C  
ATOM   8692  CG2 VAL Q 170    -105.304  35.710 -43.966  1.00 75.25           C  
ATOM   8693  N   ASP Q 171    -100.964  34.800 -45.035  1.00 78.98           N  
ATOM   8694  CA  ASP Q 171     -99.743  34.712 -45.836  1.00 82.10           C  
ATOM   8695  C   ASP Q 171     -98.646  33.901 -45.133  1.00 84.04           C  
ATOM   8696  O   ASP Q 171     -97.634  34.496 -44.694  1.00 84.64           O  
ATOM   8697  CB  ASP Q 171     -99.220  36.113 -46.161  1.00 82.92           C  
ATOM   8698  CG  ASP Q 171    -100.230  36.951 -46.920  1.00 85.03           C  
ATOM   8699  OD1 ASP Q 171    -100.771  36.456 -47.932  1.00 87.18           O  
ATOM   8700  OD2 ASP Q 171    -100.477  38.106 -46.508  1.00 82.95           O  
TER    8701      ASP Q 171                                                      
END
MOLECULE T0514.pdb
ATOM   7695  N   SER     1     -73.106  18.033 -40.322  1.00 86.00           N  
ATOM   7696  CA  SER     1     -73.011  18.711 -38.995  1.00 85.50           C  
ATOM   7697  C   SER     1     -74.354  19.367 -38.664  1.00 79.83           C  
ATOM   7698  O   SER     1     -74.616  20.512 -39.038  1.00 86.46           O  
ATOM   7699  CB  SER     1     -71.867  19.728 -38.999  1.00 86.33           C  
ATOM   7700  OG  SER     1     -71.212  19.767 -37.742  1.00 88.81           O  
ATOM   7701  N   SER     2     -75.186  18.622 -37.940  1.00 70.86           N  
ATOM   7702  CA  SER     2     -76.629  18.868 -37.847  1.00 70.05           C  
ATOM   7703  C   SER     2     -77.049  19.675 -36.613  1.00 66.08           C  
ATOM   7704  O   SER     2     -77.518  19.116 -35.621  1.00 67.53           O  
ATOM   7705  CB  SER     2     -77.364  17.524 -37.883  1.00 72.15           C  
ATOM   7706  OG  SER     2     -78.761  17.686 -37.715  1.00 76.65           O  
ATOM   7707  N   LEU     3     -76.905  20.994 -36.702  1.00 57.90           N  
ATOM   7708  CA  LEU     3     -77.150  21.891 -35.579  1.00 49.32           C  
ATOM   7709  C   LEU     3     -78.641  22.135 -35.344  1.00 45.20           C  
ATOM   7710  O   LEU     3     -79.395  22.383 -36.285  1.00 46.29           O  
ATOM   7711  CB  LEU     3     -76.427  23.218 -35.823  1.00 50.89           C  
ATOM   7712  CG  LEU     3     -75.688  23.894 -34.673  1.00 48.11           C  
ATOM   7713  CD1 LEU     3     -74.641  22.973 -34.089  1.00 51.21           C  
ATOM   7714  CD2 LEU     3     -75.040  25.155 -35.184  1.00 47.04           C  
ATOM   7715  N   THR     4     -79.051  22.068 -34.078  1.00 40.66           N  
ATOM   7716  CA  THR     4     -80.445  22.293 -33.688  1.00 38.62           C  
ATOM   7717  C   THR     4     -80.772  23.788 -33.633  1.00 40.67           C  
ATOM   7718  O   THR     4     -80.086  24.559 -32.951  1.00 39.89           O  
ATOM   7719  CB  THR     4     -80.760  21.636 -32.319  1.00 36.41           C  
ATOM   7720  OG1 THR     4     -80.313  20.276 -32.327  1.00 37.81           O  
ATOM   7721  CG2 THR     4     -82.255  21.661 -32.026  1.00 30.45           C  
ATOM   7722  N   GLU     5     -81.811  24.184 -34.370  1.00 39.96           N  
ATOM   7723  CA  GLU     5     -82.345  25.546 -34.329  1.00 39.54           C  
ATOM   7724  C   GLU     5     -83.553  25.564 -33.417  1.00 37.36           C  
ATOM   7725  O   GLU     5     -84.281  24.581 -33.340  1.00 38.64           O  
ATOM   7726  CB  GLU     5     -82.768  26.019 -35.722  1.00 39.72           C  
ATOM   7727  CG  GLU     5     -81.673  25.972 -36.765  1.00 42.97           C  
ATOM   7728  CD  GLU     5     -82.038  26.679 -38.058  1.00 52.29           C  
ATOM   7729  OE1 GLU     5     -81.494  26.288 -39.114  1.00 59.87           O  
ATOM   7730  OE2 GLU     5     -82.861  27.622 -38.023  1.00 58.70           O  
ATOM   7731  N   THR     6     -83.771  26.685 -32.739  1.00 39.74           N  
ATOM   7732  CA  THR     6     -84.865  26.804 -31.783  1.00 40.46           C  
ATOM   7733  C   THR     6     -85.754  27.995 -32.125  1.00 40.75           C  
ATOM   7734  O   THR     6     -85.275  29.127 -32.261  1.00 42.54           O  
ATOM   7735  CB  THR     6     -84.337  26.935 -30.323  1.00 42.91           C  
ATOM   7736  OG1 THR     6     -83.371  25.908 -30.059  1.00 46.85           O  
ATOM   7737  CG2 THR     6     -85.477  26.818 -29.319  1.00 44.55           C  
ATOM   7738  N   TYR     7     -87.047  27.721 -32.277  1.00 39.16           N  
ATOM   7739  CA  TYR     7     -88.045  28.754 -32.525  1.00 35.75           C  
ATOM   7740  C   TYR     7     -89.166  28.573 -31.529  1.00 35.97           C  
ATOM   7741  O   TYR     7     -90.017  27.699 -31.698  1.00 39.75           O  
ATOM   7742  CB  TYR     7     -88.560  28.689 -33.969  1.00 38.99           C  
ATOM   7743  CG  TYR     7     -87.478  28.999 -34.969  1.00 40.54           C  
ATOM   7744  CD1 TYR     7     -87.179  30.317 -35.305  1.00 37.88           C  
ATOM   7745  CD2 TYR     7     -86.726  27.978 -35.553  1.00 37.35           C  
ATOM   7746  CE1 TYR     7     -86.166  30.614 -36.212  1.00 41.16           C  
ATOM   7747  CE2 TYR     7     -85.712  28.261 -36.456  1.00 37.99           C  
ATOM   7748  CZ  TYR     7     -85.437  29.579 -36.783  1.00 40.84           C  
ATOM   7749  OH  TYR     7     -84.431  29.867 -37.675  1.00 49.82           O  
ATOM   7750  N   GLY     8     -89.140  29.398 -30.483  1.00 35.98           N  
ATOM   7751  CA  GLY     8     -90.046  29.261 -29.348  1.00 34.78           C  
ATOM   7752  C   GLY     8     -89.837  27.928 -28.661  1.00 37.11           C  
ATOM   7753  O   GLY     8     -88.768  27.666 -28.097  1.00 39.11           O  
ATOM   7754  N   LEU     9     -90.858  27.081 -28.742  1.00 35.37           N  
ATOM   7755  CA  LEU     9     -90.831  25.755 -28.144  1.00 32.71           C  
ATOM   7756  C   LEU     9     -90.501  24.674 -29.174  1.00 33.56           C  
ATOM   7757  O   LEU     9     -90.358  23.498 -28.825  1.00 34.51           O  
ATOM   7758  CB  LEU     9     -92.174  25.452 -27.473  1.00 30.66           C  
ATOM   7759  CG  LEU     9     -92.546  26.278 -26.243  1.00 31.48           C  
ATOM   7760  CD1 LEU     9     -93.946  25.918 -25.798  1.00 26.00           C  
ATOM   7761  CD2 LEU     9     -91.550  26.088 -25.099  1.00 28.69           C  
ATOM   7762  N   TRP    10     -90.363  25.084 -30.436  1.00 35.01           N  
ATOM   7763  CA  TRP    10     -90.121  24.154 -31.539  1.00 33.36           C  
ATOM   7764  C   TRP    10     -88.660  24.091 -31.974  1.00 35.75           C  
ATOM   7765  O   TRP    10     -87.944  25.097 -31.949  1.00 33.95           O  
ATOM   7766  CB  TRP    10     -91.035  24.480 -32.721  1.00 31.82           C  
ATOM   7767  CG  TRP    10     -92.432  23.993 -32.495  1.00 30.68           C  
ATOM   7768  CD1 TRP    10     -93.389  24.573 -31.708  1.00 27.17           C  
ATOM   7769  CD2 TRP    10     -93.025  22.808 -33.041  1.00 29.19           C  
ATOM   7770  NE1 TRP    10     -94.545  23.827 -31.737  1.00 30.50           N  
ATOM   7771  CE2 TRP    10     -94.350  22.738 -32.549  1.00 31.52           C  
ATOM   7772  CE3 TRP    10     -92.566  21.798 -33.901  1.00 28.90           C  
ATOM   7773  CZ2 TRP    10     -95.224  21.695 -32.888  1.00 32.76           C  
ATOM   7774  CZ3 TRP    10     -93.437  20.759 -34.242  1.00 30.01           C  
ATOM   7775  CH2 TRP    10     -94.749  20.716 -33.733  1.00 32.69           C  
ATOM   7776  N   SER    11     -88.225  22.890 -32.351  1.00 35.54           N  
ATOM   7777  CA  SER    11     -86.858  22.665 -32.800  1.00 34.01           C  
ATOM   7778  C   SER    11     -86.809  22.282 -34.273  1.00 34.91           C  
ATOM   7779  O   SER    11     -87.770  21.719 -34.807  1.00 32.84           O  
ATOM   7780  CB  SER    11     -86.184  21.585 -31.957  1.00 34.82           C  
ATOM   7781  OG  SER    11     -86.153  21.951 -30.592  1.00 40.26           O  
ATOM   7782  N   ILE    12     -85.691  22.609 -34.921  1.00 37.39           N  
ATOM   7783  CA  ILE    12     -85.430  22.225 -36.311  1.00 38.04           C  
ATOM   7784  C   ILE    12     -84.071  21.530 -36.443  1.00 37.76           C  
ATOM   7785  O   ILE    12     -83.051  22.050 -35.989  1.00 38.44           O  
ATOM   7786  CB  ILE    12     -85.517  23.448 -37.280  1.00 39.96           C  
ATOM   7787  CG1 ILE    12     -86.963  23.902 -37.431  1.00 38.91           C  
ATOM   7788  CG2 ILE    12     -84.949  23.115 -38.674  1.00 37.07           C  
ATOM   7789  CD1 ILE    12     -87.101  25.226 -38.088  1.00 41.12           C  
ATOM   7790  N   ASN    13     -84.079  20.346 -37.047  1.00 40.63           N  
ATOM   7791  CA  ASN    13     -82.853  19.655 -37.434  1.00 42.33           C  
ATOM   7792  C   ASN    13     -82.896  19.247 -38.904  1.00 45.34           C  
ATOM   7793  O   ASN    13     -83.948  18.864 -39.422  1.00 47.47           O  
ATOM   7794  CB  ASN    13     -82.620  18.432 -36.552  1.00 40.33           C  
ATOM   7795  CG  ASN    13     -82.231  18.804 -35.141  1.00 41.17           C  
ATOM   7796  OD1 ASN    13     -83.081  18.895 -34.255  1.00 42.99           O  
ATOM   7797  ND2 ASN    13     -80.942  19.039 -34.925  1.00 36.69           N  
ATOM   7798  N   CYS    14     -81.753  19.358 -39.573  1.00 51.92           N  
ATOM   7799  CA  CYS    14     -81.608  18.893 -40.950  1.00 58.30           C  
ATOM   7800  C   CYS    14     -80.651  17.708 -40.975  1.00 63.16           C  
ATOM   7801  O   CYS    14     -79.557  17.774 -40.421  1.00 65.08           O  
ATOM   7802  CB  CYS    14     -81.105  20.020 -41.853  1.00 57.24           C  
ATOM   7803  SG  CYS    14     -82.207  21.455 -41.929  1.00 61.75           S  
ATOM   7804  N   GLY    15     -81.073  16.612 -41.593  1.00 71.49           N  
ATOM   7805  CA  GLY    15     -80.278  15.392 -41.572  1.00 79.04           C  
ATOM   7806  C   GLY    15     -80.256  14.637 -42.882  1.00 83.68           C  
ATOM   7807  O   GLY    15     -81.005  14.953 -43.807  1.00 81.70           O  
ATOM   7808  N   ILE    16     -79.385  13.635 -42.951  1.00 89.29           N  
ATOM   7809  CA  ILE    16     -79.296  12.768 -44.116  1.00 95.07           C  
ATOM   7810  C   ILE    16     -79.867  11.387 -43.785  1.00 97.80           C  
ATOM   7811  O   ILE    16     -79.246  10.598 -43.067  1.00101.91           O  
ATOM   7812  CB  ILE    16     -77.840  12.662 -44.659  1.00 95.61           C  
ATOM   7813  CG1 ILE    16     -77.255  14.058 -44.917  1.00 95.45           C  
ATOM   7814  CG2 ILE    16     -77.797  11.817 -45.936  1.00 97.89           C  
ATOM   7815  CD1 ILE    16     -75.734  14.100 -44.990  1.00 96.35           C  
ATOM   7816  N   GLN    17     -81.070  11.121 -44.289  1.00 99.86           N  
ATOM   7817  CA  GLN    17     -81.656   9.781 -44.248  1.00103.94           C  
ATOM   7818  C   GLN    17     -81.935   9.297 -45.671  1.00107.30           C  
ATOM   7819  O   GLN    17     -82.322  10.090 -46.537  1.00109.45           O  
ATOM   7820  CB  GLN    17     -82.913   9.730 -43.366  1.00103.97           C  
ATOM   7821  CG  GLN    17     -84.047  10.667 -43.776  1.00103.34           C  
ATOM   7822  CD  GLN    17     -85.227  10.643 -42.816  1.00103.34           C  
ATOM   7823  OE1 GLN    17     -86.325  11.077 -43.163  1.00101.58           O  
ATOM   7824  NE2 GLN    17     -85.007  10.138 -41.605  1.00103.62           N  
ATOM   7825  N   GLU    18     -81.735   7.993 -45.887  1.00109.68           N  
ATOM   7826  CA  GLU    18     -81.668   7.343 -47.222  1.00108.94           C  
ATOM   7827  C   GLU    18     -80.948   8.127 -48.341  1.00104.86           C  
ATOM   7828  O   GLU    18     -81.362   8.105 -49.506  1.00105.18           O  
ATOM   7829  CB  GLU    18     -83.026   6.751 -47.681  1.00110.74           C  
ATOM   7830  CG  GLU    18     -84.210   7.717 -47.825  1.00113.55           C  
ATOM   7831  CD  GLU    18     -85.104   7.762 -46.593  1.00119.58           C  
ATOM   7832  OE1 GLU    18     -84.621   7.489 -45.471  1.00119.83           O  
ATOM   7833  OE2 GLU    18     -86.303   8.075 -46.749  1.00123.72           O  
ATOM   7834  N   GLY    19     -79.866   8.811 -47.965  1.00 99.61           N  
ATOM   7835  CA  GLY    19     -79.063   9.610 -48.891  1.00 93.47           C  
ATOM   7836  C   GLY    19     -79.633  10.977 -49.231  1.00 89.20           C  
ATOM   7837  O   GLY    19     -79.123  11.659 -50.126  1.00 84.86           O  
ATOM   7838  N   LYS    20     -80.686  11.380 -48.519  1.00 87.80           N  
ATOM   7839  CA  LYS    20     -81.356  12.659 -48.774  1.00 85.31           C  
ATOM   7840  C   LYS    20     -81.306  13.652 -47.624  1.00 84.60           C  
ATOM   7841  O   LYS    20     -81.594  13.304 -46.478  1.00 83.32           O  
ATOM   7842  CB  LYS    20     -82.820  12.453 -49.188  1.00 82.26           C  
ATOM   7843  CG  LYS    20     -83.153  12.836 -50.629  1.00 80.18           C  
ATOM   7844  CD  LYS    20     -82.756  14.271 -50.990  1.00 79.88           C  
ATOM   7845  CE  LYS    20     -81.530  14.316 -51.907  1.00 71.59           C  
ATOM   7846  NZ  LYS    20     -81.177  15.696 -52.331  1.00 69.67           N  
ATOM   7847  N   LYS    21     -80.950  14.892 -47.957  1.00 84.11           N  
ATOM   7848  CA  LYS    21     -81.076  16.017 -47.038  1.00 83.87           C  
ATOM   7849  C   LYS    21     -82.556  16.337 -46.825  1.00 81.07           C  
ATOM   7850  O   LYS    21     -83.272  16.685 -47.769  1.00 86.07           O  
ATOM   7851  CB  LYS    21     -80.317  17.244 -47.569  1.00 87.63           C  
ATOM   7852  CG  LYS    21     -80.607  18.573 -46.838  1.00 91.25           C  
ATOM   7853  CD  LYS    21     -80.062  18.608 -45.407  1.00 91.27           C  
ATOM   7854  CE  LYS    21     -78.579  18.952 -45.370  1.00 92.40           C  
ATOM   7855  NZ  LYS    21     -78.069  19.024 -43.973  1.00 94.73           N  
ATOM   7856  N   VAL    22     -83.006  16.185 -45.583  1.00 75.46           N  
ATOM   7857  CA  VAL    22     -84.368  16.538 -45.195  1.00 66.54           C  
ATOM   7858  C   VAL    22     -84.341  17.350 -43.894  1.00 60.14           C  
ATOM   7859  O   VAL    22     -83.654  16.991 -42.932  1.00 50.69           O  
ATOM   7860  CB  VAL    22     -85.316  15.282 -45.129  1.00 69.02           C  
ATOM   7861  CG1 VAL    22     -84.927  14.316 -44.011  1.00 62.21           C  
ATOM   7862  CG2 VAL    22     -86.785  15.694 -45.009  1.00 75.37           C  
ATOM   7863  N   CYS    23     -85.051  18.474 -43.893  1.00 57.05           N  
ATOM   7864  CA  CYS    23     -85.160  19.292 -42.693  1.00 52.37           C  
ATOM   7865  C   CYS    23     -86.501  19.053 -42.026  1.00 48.74           C  
ATOM   7866  O   CYS    23     -87.550  19.124 -42.672  1.00 48.88           O  
ATOM   7867  CB  CYS    23     -84.960  20.774 -43.012  1.00 53.59           C  
ATOM   7868  SG  CYS    23     -83.302  21.159 -43.621  1.00 61.48           S  
ATOM   7869  N   PHE    24     -86.462  18.751 -40.734  1.00 47.22           N  
ATOM   7870  CA  PHE    24     -87.689  18.483 -39.991  1.00 45.34           C  
ATOM   7871  C   PHE    24     -87.883  19.369 -38.767  1.00 40.99           C  
ATOM   7872  O   PHE    24     -86.934  19.890 -38.181  1.00 37.69           O  
ATOM   7873  CB  PHE    24     -87.866  16.983 -39.669  1.00 47.46           C  
ATOM   7874  CG  PHE    24     -86.757  16.385 -38.850  1.00 53.18           C  
ATOM   7875  CD1 PHE    24     -86.894  16.249 -37.469  1.00 57.41           C  
ATOM   7876  CD2 PHE    24     -85.590  15.920 -39.458  1.00 56.07           C  
ATOM   7877  CE1 PHE    24     -85.877  15.680 -36.699  1.00 57.82           C  
ATOM   7878  CE2 PHE    24     -84.563  15.356 -38.702  1.00 61.34           C  
ATOM   7879  CZ  PHE    24     -84.707  15.235 -37.317  1.00 59.01           C  
ATOM   7880  N   MET    25     -89.150  19.526 -38.415  1.00 40.89           N  
ATOM   7881  CA  MET    25     -89.627  20.457 -37.417  1.00 37.14           C  
ATOM   7882  C   MET    25     -90.204  19.579 -36.318  1.00 36.34           C  
ATOM   7883  O   MET    25     -91.072  18.749 -36.595  1.00 35.61           O  
ATOM   7884  CB  MET    25     -90.745  21.248 -38.069  1.00 40.66           C  
ATOM   7885  CG  MET    25     -91.015  22.605 -37.554  1.00 41.74           C  
ATOM   7886  SD  MET    25     -92.447  23.209 -38.467  1.00 33.57           S  
ATOM   7887  CE  MET    25     -93.338  23.885 -37.087  1.00 29.70           C  
ATOM   7888  N   HIS    26     -89.737  19.742 -35.080  1.00 36.22           N  
ATOM   7889  CA  HIS    26     -90.155  18.821 -34.012  1.00 34.22           C  
ATOM   7890  C   HIS    26     -90.321  19.388 -32.595  1.00 34.68           C  
ATOM   7891  O   HIS    26     -89.727  20.411 -32.225  1.00 32.90           O  
ATOM   7892  CB  HIS    26     -89.268  17.565 -33.993  1.00 31.23           C  
ATOM   7893  CG  HIS    26     -87.822  17.849 -33.742  1.00 33.71           C  
ATOM   7894  ND1 HIS    26     -87.235  17.684 -32.506  1.00 37.09           N  
ATOM   7895  CD2 HIS    26     -86.845  18.296 -34.566  1.00 32.07           C  
ATOM   7896  CE1 HIS    26     -85.959  18.012 -32.580  1.00 36.78           C  
ATOM   7897  NE2 HIS    26     -85.697  18.388 -33.819  1.00 36.25           N  
ATOM   7898  N   ARG    27     -91.147  18.696 -31.815  1.00 34.90           N  
ATOM   7899  CA  ARG    27     -91.499  19.109 -30.464  1.00 35.60           C  
ATOM   7900  C   ARG    27     -91.845  17.880 -29.620  1.00 37.37           C  
ATOM   7901  O   ARG    27     -92.615  17.022 -30.055  1.00 37.78           O  
ATOM   7902  CB  ARG    27     -92.693  20.072 -30.515  1.00 34.68           C  
ATOM   7903  CG  ARG    27     -93.389  20.316 -29.183  1.00 32.93           C  
ATOM   7904  CD  ARG    27     -92.882  21.562 -28.499  1.00 34.97           C  
ATOM   7905  NE  ARG    27     -93.150  21.549 -27.062  1.00 35.70           N  
ATOM   7906  CZ  ARG    27     -92.237  21.777 -26.118  1.00 35.79           C  
ATOM   7907  NH1 ARG    27     -90.983  22.061 -26.446  1.00 35.35           N  
ATOM   7908  NH2 ARG    27     -92.584  21.734 -24.840  1.00 32.78           N  
ATOM   7909  N   GLN    28     -91.264  17.802 -28.424  1.00 39.12           N  
ATOM   7910  CA  GLN    28     -91.625  16.785 -27.438  1.00 39.03           C  
ATOM   7911  C   GLN    28     -92.318  17.425 -26.248  1.00 35.59           C  
ATOM   7912  O   GLN    28     -91.953  18.522 -25.819  1.00 36.00           O  
ATOM   7913  CB  GLN    28     -90.382  16.060 -26.928  1.00 37.97           C  
ATOM   7914  CG  GLN    28     -89.815  15.019 -27.865  1.00 50.79           C  
ATOM   7915  CD  GLN    28     -88.584  14.336 -27.295  1.00 51.82           C  
ATOM   7916  OE1 GLN    28     -87.931  14.854 -26.380  1.00 48.50           O  
ATOM   7917  NE2 GLN    28     -88.258  13.163 -27.836  1.00 56.54           N  
ATOM   7918  N   GLU    29     -93.310  16.727 -25.706  1.00 34.54           N  
ATOM   7919  CA  GLU    29     -93.924  17.138 -24.452  1.00 36.76           C  
ATOM   7920  C   GLU    29     -93.641  16.119 -23.352  1.00 37.73           C  
ATOM   7921  O   GLU    29     -93.732  14.906 -23.576  1.00 36.19           O  
ATOM   7922  CB  GLU    29     -95.432  17.367 -24.605  1.00 38.13           C  
ATOM   7923  CG  GLU    29     -95.845  18.263 -25.776  1.00 38.36           C  
ATOM   7924  CD  GLU    29     -95.494  19.736 -25.598  1.00 42.52           C  
ATOM   7925  OE1 GLU    29     -95.164  20.170 -24.475  1.00 47.87           O  
ATOM   7926  OE2 GLU    29     -95.559  20.472 -26.602  1.00 44.00           O  
ATOM   7927  N   VAL    30     -93.284  16.629 -22.172  1.00 39.11           N  
ATOM   7928  CA  VAL    30     -92.918  15.794 -21.024  1.00 38.76           C  
ATOM   7929  C   VAL    30     -93.876  15.994 -19.843  1.00 40.55           C  
ATOM   7930  O   VAL    30     -94.572  17.009 -19.767  1.00 40.75           O  
ATOM   7931  CB  VAL    30     -91.444  16.041 -20.568  1.00 36.91           C  
ATOM   7932  CG1 VAL    30     -90.460  15.709 -21.687  1.00 33.10           C  
ATOM   7933  CG2 VAL    30     -91.237  17.483 -20.087  1.00 35.14           C  
ATOM   7934  N   ASN    31     -93.917  15.016 -18.939  1.00 43.33           N  
ATOM   7935  CA  ASN    31     -94.651  15.160 -17.681  1.00 43.25           C  
ATOM   7936  C   ASN    31     -93.779  15.766 -16.584  1.00 47.22           C  
ATOM   7937  O   ASN    31     -92.674  16.237 -16.865  1.00 47.32           O  
ATOM   7938  CB  ASN    31     -95.294  13.832 -17.233  1.00 43.59           C  
ATOM   7939  CG  ASN    31     -94.288  12.688 -17.073  1.00 43.57           C  
ATOM   7940  OD1 ASN    31     -93.078  12.894 -16.971  1.00 49.89           O  
ATOM   7941  ND2 ASN    31     -94.803  11.466 -17.049  1.00 39.28           N  
ATOM   7942  N   ASP    32     -94.274  15.749 -15.343  1.00 52.63           N  
ATOM   7943  CA  ASP    32     -93.516  16.253 -14.183  1.00 58.15           C  
ATOM   7944  C   ASP    32     -92.281  15.415 -13.813  1.00 58.15           C  
ATOM   7945  O   ASP    32     -91.374  15.908 -13.142  1.00 58.05           O  
ATOM   7946  CB  ASP    32     -94.427  16.458 -12.960  1.00 63.77           C  
ATOM   7947  CG  ASP    32     -95.443  15.332 -12.767  1.00 76.42           C  
ATOM   7948  OD1 ASP    32     -95.134  14.158 -13.075  1.00 83.20           O  
ATOM   7949  OD2 ASP    32     -96.559  15.631 -12.288  1.00 85.45           O  
ATOM   7950  N   GLN    33     -92.253  14.159 -14.264  1.00 60.15           N  
ATOM   7951  CA  GLN    33     -91.095  13.270 -14.084  1.00 60.41           C  
ATOM   7952  C   GLN    33     -90.101  13.388 -15.240  1.00 60.28           C  
ATOM   7953  O   GLN    33     -89.128  12.631 -15.309  1.00 63.82           O  
ATOM   7954  CB  GLN    33     -91.542  11.809 -13.928  1.00 58.58           C  
ATOM   7955  CG  GLN    33     -92.418  11.530 -12.707  1.00 67.98           C  
ATOM   7956  CD  GLN    33     -91.759  11.932 -11.396  1.00 76.84           C  
ATOM   7957  OE1 GLN    33     -92.246  12.817 -10.691  1.00 77.72           O  
ATOM   7958  NE2 GLN    33     -90.641  11.290 -11.069  1.00 78.90           N  
ATOM   7959  N   ASN    34     -90.371  14.333 -16.142  1.00 56.72           N  
ATOM   7960  CA  ASN    34     -89.528  14.644 -17.307  1.00 57.64           C  
ATOM   7961  C   ASN    34     -89.388  13.517 -18.343  1.00 53.14           C  
ATOM   7962  O   ASN    34     -88.394  13.450 -19.064  1.00 54.45           O  
ATOM   7963  CB  ASN    34     -88.152  15.190 -16.875  1.00 63.11           C  
ATOM   7964  CG  ASN    34     -87.574  16.183 -17.871  1.00 73.48           C  
ATOM   7965  OD1 ASN    34     -88.079  17.298 -18.021  1.00 82.99           O  
ATOM   7966  ND2 ASN    34     -86.505  15.782 -18.552  1.00 71.05           N  
ATOM   7967  N   ARG    35     -90.384  12.638 -18.426  1.00 50.00           N  
ATOM   7968  CA  ARG    35     -90.399  11.638 -19.493  1.00 52.19           C  
ATOM   7969  C   ARG    35     -91.392  12.000 -20.607  1.00 49.40           C  
ATOM   7970  O   ARG    35     -92.459  12.566 -20.351  1.00 46.47           O  
ATOM   7971  CB  ARG    35     -90.621  10.214 -18.955  1.00 54.38           C  
ATOM   7972  CG  ARG    35     -92.008   9.913 -18.435  1.00 63.48           C  
ATOM   7973  CD  ARG    35     -92.314   8.431 -18.562  1.00 72.96           C  
ATOM   7974  NE  ARG    35     -93.747   8.174 -18.460  1.00 81.89           N  
ATOM   7975  CZ  ARG    35     -94.569   7.959 -19.487  1.00 85.10           C  
ATOM   7976  NH1 ARG    35     -94.122   7.945 -20.737  1.00 84.71           N  
ATOM   7977  NH2 ARG    35     -95.855   7.748 -19.252  1.00 85.00           N  
ATOM   7978  N   VAL    36     -91.016  11.665 -21.839  1.00 46.28           N  
ATOM   7979  CA  VAL    36     -91.781  12.021 -23.036  1.00 43.64           C  
ATOM   7980  C   VAL    36     -93.111  11.271 -23.099  1.00 43.57           C  
ATOM   7981  O   VAL    36     -93.145  10.043 -23.052  1.00 45.58           O  
ATOM   7982  CB  VAL    36     -90.946  11.794 -24.329  1.00 43.77           C  
ATOM   7983  CG1 VAL    36     -91.721  12.214 -25.571  1.00 40.76           C  
ATOM   7984  CG2 VAL    36     -89.632  12.564 -24.252  1.00 43.73           C  
ATOM   7985  N   VAL    37     -94.199  12.032 -23.190  1.00 42.93           N  
ATOM   7986  CA  VAL    37     -95.549  11.475 -23.274  1.00 42.32           C  
ATOM   7987  C   VAL    37     -96.081  11.586 -24.705  1.00 43.22           C  
ATOM   7988  O   VAL    37     -96.640  10.634 -25.249  1.00 45.11           O  
ATOM   7989  CB  VAL    37     -96.511  12.177 -22.282  1.00 41.41           C  
ATOM   7990  CG1 VAL    37     -97.901  11.548 -22.323  1.00 44.11           C  
ATOM   7991  CG2 VAL    37     -95.952  12.127 -20.860  1.00 41.25           C  
ATOM   7992  N   VAL    38     -95.891  12.752 -25.312  1.00 42.01           N  
ATOM   7993  CA  VAL    38     -96.311  12.978 -26.691  1.00 44.83           C  
ATOM   7994  C   VAL    38     -95.192  13.689 -27.472  1.00 39.42           C  
ATOM   7995  O   VAL    38     -94.454  14.503 -26.911  1.00 42.68           O  
ATOM   7996  CB  VAL    38     -97.733  13.666 -26.765  1.00 47.06           C  
ATOM   7997  CG1 VAL    38     -97.745  15.019 -26.108  1.00 49.87           C  
ATOM   7998  CG2 VAL    38     -98.250  13.765 -28.184  1.00 54.30           C  
ATOM   7999  N   ALA    39     -95.029  13.324 -28.742  1.00 39.00           N  
ATOM   8000  CA  ALA    39     -94.053  13.963 -29.619  1.00 36.49           C  
ATOM   8001  C   ALA    39     -94.664  14.211 -30.995  1.00 40.04           C  
ATOM   8002  O   ALA    39     -95.598  13.516 -31.405  1.00 41.01           O  
ATOM   8003  CB  ALA    39     -92.787  13.106 -29.733  1.00 33.14           C  
ATOM   8004  N   MET    40     -94.135  15.209 -31.698  1.00 39.36           N  
ATOM   8005  CA  MET    40     -94.594  15.548 -33.040  1.00 37.36           C  
ATOM   8006  C   MET    40     -93.396  15.917 -33.903  1.00 36.61           C  
ATOM   8007  O   MET    40     -92.546  16.694 -33.484  1.00 38.65           O  
ATOM   8008  CB  MET    40     -95.604  16.701 -32.982  1.00 35.72           C  
ATOM   8009  CG  MET    40     -96.020  17.272 -34.336  1.00 44.41           C  
ATOM   8010  SD  MET    40     -97.527  18.253 -34.261  1.00 43.34           S  
ATOM   8011  CE  MET    40     -98.734  16.944 -34.198  1.00 57.38           C  
ATOM   8012  N   SER    41     -93.328  15.329 -35.095  1.00 38.59           N  
ATOM   8013  CA  SER    41     -92.282  15.642 -36.068  1.00 39.90           C  
ATOM   8014  C   SER    41     -92.924  15.923 -37.423  1.00 42.42           C  
ATOM   8015  O   SER    41     -93.814  15.194 -37.858  1.00 44.66           O  
ATOM   8016  CB  SER    41     -91.275  14.497 -36.171  1.00 38.92           C  
ATOM   8017  OG  SER    41     -90.050  14.948 -36.720  1.00 45.02           O  
ATOM   8018  N   VAL    42     -92.465  16.980 -38.084  1.00 43.27           N  
ATOM   8019  CA  VAL    42     -93.147  17.520 -39.258  1.00 43.16           C  
ATOM   8020  C   VAL    42     -92.174  17.983 -40.359  1.00 42.78           C  
ATOM   8021  O   VAL    42     -91.132  18.582 -40.069  1.00 41.02           O  
ATOM   8022  CB  VAL    42     -94.163  18.624 -38.813  1.00 45.42           C  
ATOM   8023  CG1 VAL    42     -94.091  19.877 -39.667  1.00 47.71           C  
ATOM   8024  CG2 VAL    42     -95.576  18.055 -38.765  1.00 50.61           C  
ATOM   8025  N   VAL    43     -92.503  17.669 -41.615  1.00 44.23           N  
ATOM   8026  CA  VAL    43     -91.737  18.158 -42.773  1.00 45.03           C  
ATOM   8027  C   VAL    43     -92.593  19.010 -43.711  1.00 47.46           C  
ATOM   8028  O   VAL    43     -93.827  18.887 -43.743  1.00 45.91           O  
ATOM   8029  CB  VAL    43     -91.058  17.017 -43.599  1.00 45.82           C  
ATOM   8030  CG1 VAL    43     -89.978  16.311 -42.785  1.00 47.96           C  
ATOM   8031  CG2 VAL    43     -92.085  16.022 -44.131  1.00 44.05           C  
ATOM   8032  N   LEU    44     -91.923  19.882 -44.461  1.00 48.25           N  
ATOM   8033  CA  LEU    44     -92.552  20.638 -45.533  1.00 49.20           C  
ATOM   8034  C   LEU    44     -92.233  19.926 -46.840  1.00 50.17           C  
ATOM   8035  O   LEU    44     -91.069  19.834 -47.241  1.00 48.59           O  
ATOM   8036  CB  LEU    44     -92.007  22.069 -45.574  1.00 50.42           C  
ATOM   8037  CG  LEU    44     -92.858  23.273 -46.005  1.00 51.57           C  
ATOM   8038  CD1 LEU    44     -92.022  24.181 -46.886  1.00 48.17           C  
ATOM   8039  CD2 LEU    44     -94.179  22.925 -46.686  1.00 53.02           C  
ATOM   8040  N   ASN    45     -93.269  19.405 -47.490  1.00 53.56           N  
ATOM   8041  CA  ASN    45     -93.105  18.705 -48.759  1.00 60.61           C  
ATOM   8042  C   ASN    45     -92.953  19.682 -49.926  1.00 61.95           C  
ATOM   8043  O   ASN    45     -93.225  20.880 -49.780  1.00 62.94           O  
ATOM   8044  CB  ASN    45     -94.268  17.736 -48.991  1.00 61.44           C  
ATOM   8045  CG  ASN    45     -94.318  16.625 -47.955  1.00 61.88           C  
ATOM   8046  OD1 ASN    45     -93.560  15.656 -48.027  1.00 64.24           O  
ATOM   8047  ND2 ASN    45     -95.216  16.760 -46.986  1.00 54.93           N  
ATOM   8048  N   ALA    46     -92.519  19.160 -51.073  1.00 67.68           N  
ATOM   8049  CA  ALA    46     -92.230  19.965 -52.270  1.00 72.47           C  
ATOM   8050  C   ALA    46     -93.438  20.734 -52.823  1.00 71.74           C  
ATOM   8051  O   ALA    46     -93.283  21.830 -53.370  1.00 64.68           O  
ATOM   8052  CB  ALA    46     -91.609  19.090 -53.357  1.00 71.52           C  
ATOM   8053  N   ASP    47     -94.630  20.158 -52.664  1.00 76.25           N  
ATOM   8054  CA  ASP    47     -95.876  20.788 -53.116  1.00 81.64           C  
ATOM   8055  C   ASP    47     -96.438  21.812 -52.121  1.00 80.37           C  
ATOM   8056  O   ASP    47     -97.388  22.535 -52.433  1.00 83.42           O  
ATOM   8057  CB  ASP    47     -96.933  19.726 -53.454  1.00 83.20           C  
ATOM   8058  CG  ASP    47     -97.331  18.887 -52.253  1.00 89.84           C  
ATOM   8059  OD1 ASP    47     -96.480  18.135 -51.726  1.00 88.83           O  
ATOM   8060  OD2 ASP    47     -98.509  18.972 -51.847  1.00 94.11           O  
ATOM   8061  N   GLY    48     -95.851  21.869 -50.928  1.00 78.39           N  
ATOM   8062  CA  GLY    48     -96.258  22.836 -49.913  1.00 75.66           C  
ATOM   8063  C   GLY    48     -97.114  22.258 -48.802  1.00 74.27           C  
ATOM   8064  O   GLY    48     -97.499  22.977 -47.874  1.00 73.74           O  
ATOM   8065  N   VAL    49     -97.419  20.963 -48.893  1.00 70.95           N  
ATOM   8066  CA  VAL    49     -98.200  20.284 -47.858  1.00 66.91           C  
ATOM   8067  C   VAL    49     -97.320  19.964 -46.637  1.00 61.43           C  
ATOM   8068  O   VAL    49     -96.161  19.555 -46.773  1.00 59.04           O  
ATOM   8069  CB  VAL    49     -98.986  19.037 -48.419  1.00 70.53           C  
ATOM   8070  CG1 VAL    49     -98.077  17.831 -48.676  1.00 70.34           C  
ATOM   8071  CG2 VAL    49    -100.136  18.653 -47.503  1.00 72.21           C  
ATOM   8072  N   VAL    50     -97.867  20.205 -45.449  1.00 55.18           N  
ATOM   8073  CA  VAL    50     -97.165  19.942 -44.198  1.00 51.62           C  
ATOM   8074  C   VAL    50     -97.600  18.579 -43.655  1.00 50.09           C  
ATOM   8075  O   VAL    50     -98.779  18.360 -43.366  1.00 49.43           O  
ATOM   8076  CB  VAL    50     -97.396  21.082 -43.168  1.00 54.49           C  
ATOM   8077  CG1 VAL    50     -96.922  20.691 -41.780  1.00 51.97           C  
ATOM   8078  CG2 VAL    50     -96.696  22.361 -43.622  1.00 58.52           C  
ATOM   8079  N   SER    51     -96.642  17.662 -43.546  1.00 46.60           N  
ATOM   8080  CA  SER    51     -96.927  16.305 -43.098  1.00 46.78           C  
ATOM   8081  C   SER    51     -95.855  15.764 -42.153  1.00 45.98           C  
ATOM   8082  O   SER    51     -94.767  16.326 -42.041  1.00 47.23           O  
ATOM   8083  CB  SER    51     -97.097  15.362 -44.297  1.00 46.56           C  
ATOM   8084  OG  SER    51     -95.844  15.036 -44.878  1.00 47.27           O  
ATOM   8085  N   GLY    52     -96.178  14.667 -41.478  1.00 45.55           N  
ATOM   8086  CA  GLY    52     -95.223  13.985 -40.616  1.00 43.07           C  
ATOM   8087  C   GLY    52     -95.883  12.979 -39.699  1.00 43.98           C  
ATOM   8088  O   GLY    52     -96.833  12.294 -40.090  1.00 43.52           O  
ATOM   8089  N   ASN    53     -95.381  12.902 -38.469  1.00 43.90           N  
ATOM   8090  CA  ASN    53     -95.834  11.907 -37.504  1.00 40.61           C  
ATOM   8091  C   ASN    53     -96.062  12.463 -36.107  1.00 39.65           C  
ATOM   8092  O   ASN    53     -95.329  13.336 -35.638  1.00 40.08           O  
ATOM   8093  CB  ASN    53     -94.838  10.745 -37.431  1.00 41.51           C  
ATOM   8094  CG  ASN    53     -94.871   9.867 -38.667  1.00 47.13           C  
ATOM   8095  OD1 ASN    53     -95.901   9.287 -39.005  1.00 50.75           O  
ATOM   8096  ND2 ASN    53     -93.738   9.759 -39.343  1.00 49.89           N  
ATOM   8097  N   LEU    54     -97.097  11.938 -35.462  1.00 37.37           N  
ATOM   8098  CA  LEU    54     -97.386  12.191 -34.062  1.00 38.77           C  
ATOM   8099  C   LEU    54     -97.122  10.899 -33.277  1.00 38.50           C  
ATOM   8100  O   LEU    54     -97.566   9.821 -33.675  1.00 39.47           O  
ATOM   8101  CB  LEU    54     -98.845  12.642 -33.919  1.00 40.65           C  
ATOM   8102  CG  LEU    54     -99.498  12.858 -32.553  1.00 48.06           C  
ATOM   8103  CD1 LEU    54     -98.949  14.092 -31.861  1.00 52.48           C  
ATOM   8104  CD2 LEU    54    -101.005  12.973 -32.727  1.00 43.73           C  
ATOM   8105  N   THR    55     -96.378  11.010 -32.180  1.00 39.30           N  
ATOM   8106  CA  THR    55     -96.126   9.865 -31.304  1.00 39.91           C  
ATOM   8107  C   THR    55     -96.993   9.965 -30.053  1.00 40.74           C  
ATOM   8108  O   THR    55     -96.873  10.912 -29.277  1.00 41.61           O  
ATOM   8109  CB  THR    55     -94.633   9.737 -30.907  1.00 41.37           C  
ATOM   8110  OG1 THR    55     -93.816   9.773 -32.083  1.00 45.21           O  
ATOM   8111  CG2 THR    55     -94.383   8.421 -30.165  1.00 38.83           C  
ATOM   8112  N   VAL    56     -97.865   8.980 -29.871  1.00 41.74           N  
ATOM   8113  CA  VAL    56     -98.785   8.946 -28.740  1.00 39.47           C  
ATOM   8114  C   VAL    56     -98.411   7.781 -27.797  1.00 40.99           C  
ATOM   8115  O   VAL    56     -97.630   6.910 -28.194  1.00 39.59           O  
ATOM   8116  CB  VAL    56    -100.268   8.874 -29.224  1.00 39.38           C  
ATOM   8117  CG1 VAL    56    -100.628  10.107 -30.044  1.00 38.86           C  
ATOM   8118  CG2 VAL    56    -100.544   7.595 -30.007  1.00 36.61           C  
ATOM   8119  N   PRO    57     -98.932   7.774 -26.543  1.00 40.92           N  
ATOM   8120  CA  PRO    57     -98.623   6.686 -25.603  1.00 40.34           C  
ATOM   8121  C   PRO    57     -99.085   5.286 -26.011  1.00 39.91           C  
ATOM   8122  O   PRO    57     -99.891   5.127 -26.932  1.00 41.60           O  
ATOM   8123  CB  PRO    57     -99.368   7.101 -24.325  1.00 40.00           C  
ATOM   8124  CG  PRO    57     -99.582   8.555 -24.455  1.00 39.77           C  
ATOM   8125  CD  PRO    57     -99.794   8.790 -25.906  1.00 37.98           C  
ATOM   8126  N   PHE    58     -98.547   4.284 -25.316  1.00 39.09           N  
ATOM   8127  CA  PHE    58     -99.014   2.905 -25.401  1.00 36.94           C  
ATOM   8128  C   PHE    58    -100.369   2.794 -24.711  1.00 38.40           C  
ATOM   8129  O   PHE    58    -100.719   3.639 -23.889  1.00 39.49           O  
ATOM   8130  CB  PHE    58     -98.033   1.968 -24.691  1.00 36.65           C  
ATOM   8131  CG  PHE    58     -96.719   1.777 -25.406  1.00 37.29           C  
ATOM   8132  CD1 PHE    58     -96.674   1.317 -26.721  1.00 32.46           C  
ATOM   8133  CD2 PHE    58     -95.525   2.011 -24.740  1.00 36.17           C  
ATOM   8134  CE1 PHE    58     -95.456   1.124 -27.365  1.00 30.64           C  
ATOM   8135  CE2 PHE    58     -94.301   1.820 -25.375  1.00 36.39           C  
ATOM   8136  CZ  PHE    58     -94.265   1.374 -26.687  1.00 33.57           C  
ATOM   8137  N   GLY    59    -101.122   1.746 -25.033  1.00 38.02           N  
ATOM   8138  CA  GLY    59    -102.386   1.476 -24.353  1.00 38.64           C  
ATOM   8139  C   GLY    59    -103.588   2.148 -24.991  1.00 40.57           C  
ATOM   8140  O   GLY    59    -104.689   2.114 -24.437  1.00 41.45           O  
ATOM   8141  N   ILE    60    -103.373   2.751 -26.159  1.00 39.42           N  
ATOM   8142  CA  ILE    60    -104.424   3.446 -26.893  1.00 38.65           C  
ATOM   8143  C   ILE    60    -105.140   2.452 -27.794  1.00 39.98           C  
ATOM   8144  O   ILE    60    -104.493   1.652 -28.471  1.00 42.85           O  
ATOM   8145  CB  ILE    60    -103.848   4.646 -27.724  1.00 38.15           C  
ATOM   8146  CG1 ILE    60    -103.155   5.668 -26.813  1.00 35.54           C  
ATOM   8147  CG2 ILE    60    -104.926   5.336 -28.572  1.00 36.48           C  
ATOM   8148  CD1 ILE    60    -103.977   6.131 -25.609  1.00 40.32           C  
ATOM   8149  N   LEU    61    -106.473   2.500 -27.777  1.00 40.96           N  
ATOM   8150  CA  LEU    61    -107.313   1.695 -28.658  1.00 41.73           C  
ATOM   8151  C   LEU    61    -107.102   2.086 -30.115  1.00 43.74           C  
ATOM   8152  O   LEU    61    -107.481   3.174 -30.556  1.00 45.62           O  
ATOM   8153  CB  LEU    61    -108.791   1.801 -28.261  1.00 43.12           C  
ATOM   8154  CG  LEU    61    -109.809   0.889 -28.954  1.00 47.01           C  
ATOM   8155  CD1 LEU    61    -109.384  -0.574 -28.917  1.00 46.29           C  
ATOM   8156  CD2 LEU    61    -111.168   1.062 -28.305  1.00 48.24           C  
ATOM   8157  N   VAL    62    -106.482   1.158 -30.833  1.00 45.81           N  
ATOM   8158  CA  VAL    62    -106.000   1.327 -32.199  1.00 46.43           C  
ATOM   8159  C   VAL    62    -107.124   1.393 -33.254  1.00 49.99           C  
ATOM   8160  O   VAL    62    -106.973   2.042 -34.297  1.00 49.86           O  
ATOM   8161  CB  VAL    62    -104.952   0.203 -32.488  1.00 47.63           C  
ATOM   8162  CG1 VAL    62    -105.276  -0.618 -33.727  1.00 44.38           C  
ATOM   8163  CG2 VAL    62    -103.540   0.753 -32.479  1.00 43.08           C  
ATOM   8164  N   SER    63    -108.252   0.744 -32.963  1.00 52.24           N  
ATOM   8165  CA  SER    63    -109.386   0.694 -33.888  1.00 55.22           C  
ATOM   8166  C   SER    63    -110.231   1.973 -33.879  1.00 55.13           C  
ATOM   8167  O   SER    63    -110.996   2.225 -34.813  1.00 56.93           O  
ATOM   8168  CB  SER    63    -110.260  -0.534 -33.604  1.00 56.41           C  
ATOM   8169  OG  SER    63    -110.703  -0.554 -32.259  1.00 58.82           O  
ATOM   8170  N   LYS    64    -110.087   2.770 -32.823  1.00 54.64           N  
ATOM   8171  CA  LYS    64    -110.773   4.056 -32.702  1.00 54.80           C  
ATOM   8172  C   LYS    64    -109.828   5.216 -33.061  1.00 55.37           C  
ATOM   8173  O   LYS    64    -108.627   5.136 -32.792  1.00 54.67           O  
ATOM   8174  CB  LYS    64    -111.362   4.217 -31.295  1.00 55.30           C  
ATOM   8175  CG  LYS    64    -112.561   3.308 -31.037  1.00 63.31           C  
ATOM   8176  CD  LYS    64    -113.400   3.779 -29.855  1.00 78.37           C  
ATOM   8177  CE  LYS    64    -114.502   4.741 -30.289  1.00 85.91           C  
ATOM   8178  NZ  LYS    64    -115.560   4.064 -31.097  1.00 90.27           N  
ATOM   8179  N   PRO    65    -110.364   6.296 -33.674  1.00 55.58           N  
ATOM   8180  CA  PRO    65    -109.497   7.330 -34.247  1.00 52.60           C  
ATOM   8181  C   PRO    65    -108.828   8.256 -33.237  1.00 49.82           C  
ATOM   8182  O   PRO    65    -109.250   8.339 -32.083  1.00 48.16           O  
ATOM   8183  CB  PRO    65    -110.454   8.155 -35.122  1.00 54.13           C  
ATOM   8184  CG  PRO    65    -111.767   7.441 -35.107  1.00 56.65           C  
ATOM   8185  CD  PRO    65    -111.788   6.625 -33.873  1.00 55.49           C  
ATOM   8186  N   VAL    66    -107.782   8.940 -33.696  1.00 46.27           N  
ATOM   8187  CA  VAL    66    -107.118   9.997 -32.944  1.00 44.24           C  
ATOM   8188  C   VAL    66    -107.577  11.331 -33.533  1.00 46.00           C  
ATOM   8189  O   VAL    66    -107.417  11.587 -34.731  1.00 43.01           O  
ATOM   8190  CB  VAL    66    -105.565   9.870 -33.002  1.00 42.88           C  
ATOM   8191  CG1 VAL    66    -104.891  11.013 -32.249  1.00 35.13           C  
ATOM   8192  CG2 VAL    66    -105.110   8.531 -32.428  1.00 35.10           C  
ATOM   8193  N   ARG    67    -108.167  12.164 -32.684  1.00 48.36           N  
ATOM   8194  CA  ARG    67    -108.753  13.427 -33.112  1.00 53.92           C  
ATOM   8195  C   ARG    67    -107.820  14.591 -32.793  1.00 49.32           C  
ATOM   8196  O   ARG    67    -107.342  14.724 -31.667  1.00 48.15           O  
ATOM   8197  CB  ARG    67    -110.116  13.618 -32.440  1.00 58.21           C  
ATOM   8198  CG  ARG    67    -110.978  14.714 -33.038  1.00 66.31           C  
ATOM   8199  CD  ARG    67    -112.314  14.790 -32.317  1.00 73.54           C  
ATOM   8200  NE  ARG    67    -112.903  16.125 -32.388  1.00 80.28           N  
ATOM   8201  CZ  ARG    67    -112.664  17.103 -31.518  1.00 86.09           C  
ATOM   8202  NH1 ARG    67    -111.839  16.912 -30.494  1.00 80.35           N  
ATOM   8203  NH2 ARG    67    -113.252  18.282 -31.672  1.00 91.87           N  
ATOM   8204  N   LEU    68    -107.562  15.424 -33.795  1.00 49.12           N  
ATOM   8205  CA  LEU    68    -106.675  16.571 -33.647  1.00 49.18           C  
ATOM   8206  C   LEU    68    -107.459  17.867 -33.811  1.00 49.62           C  
ATOM   8207  O   LEU    68    -108.159  18.051 -34.804  1.00 48.56           O  
ATOM   8208  CB  LEU    68    -105.534  16.513 -34.671  1.00 49.41           C  
ATOM   8209  CG  LEU    68    -104.300  15.649 -34.391  1.00 49.62           C  
ATOM   8210  CD1 LEU    68    -104.533  14.193 -34.745  1.00 50.08           C  
ATOM   8211  CD2 LEU    68    -103.119  16.188 -35.170  1.00 55.46           C  
ATOM   8212  N   GLN    69    -107.330  18.764 -32.839  1.00 48.75           N  
ATOM   8213  CA  GLN    69    -108.055  20.028 -32.864  1.00 49.66           C  
ATOM   8214  C   GLN    69    -107.172  21.176 -32.386  1.00 47.73           C  
ATOM   8215  O   GLN    69    -106.540  21.078 -31.335  1.00 45.89           O  
ATOM   8216  CB  GLN    69    -109.320  19.936 -32.002  1.00 49.58           C  
ATOM   8217  CG  GLN    69    -110.243  21.150 -32.100  1.00 56.24           C  
ATOM   8218  CD  GLN    69    -111.428  21.082 -31.147  1.00 57.65           C  
ATOM   8219  OE1 GLN    69    -111.413  20.341 -30.165  1.00 61.51           O  
ATOM   8220  NE2 GLN    69    -112.460  21.865 -31.434  1.00 63.23           N  
ATOM   8221  N   VAL    70    -107.132  22.258 -33.162  1.00 46.79           N  
ATOM   8222  CA  VAL    70    -106.425  23.465 -32.744  1.00 45.63           C  
ATOM   8223  C   VAL    70    -107.314  24.237 -31.771  1.00 50.88           C  
ATOM   8224  O   VAL    70    -108.377  24.738 -32.157  1.00 51.95           O  
ATOM   8225  CB  VAL    70    -106.029  24.367 -33.933  1.00 44.32           C  
ATOM   8226  CG1 VAL    70    -105.031  25.425 -33.477  1.00 41.51           C  
ATOM   8227  CG2 VAL    70    -105.442  23.542 -35.065  1.00 37.72           C  
ATOM   8228  N   ASP    71    -106.859  24.307 -30.517  1.00 57.99           N  
ATOM   8229  CA  ASP    71    -107.581  24.923 -29.392  1.00 60.52           C  
ATOM   8230  C   ASP    71    -109.024  24.421 -29.270  1.00 61.83           C  
ATOM   8231  O   ASP    71    -109.254  23.219 -29.136  1.00 62.03           O  
ATOM   8232  CB  ASP    71    -107.508  26.457 -29.463  1.00 62.89           C  
ATOM   8233  CG  ASP    71    -106.079  26.981 -29.403  1.00 69.66           C  
ATOM   8234  OD1 ASP    71    -105.280  26.458 -28.597  1.00 66.80           O  
ATOM   8235  OD2 ASP    71    -105.759  27.927 -30.157  1.00 74.25           O  
ATOM   8236  N   GLU    72    -109.986  25.336 -29.324  1.00 67.01           N  
ATOM   8237  CA  GLU    72    -111.397  24.967 -29.370  1.00 69.33           C  
ATOM   8238  C   GLU    72    -112.042  25.472 -30.658  1.00 67.56           C  
ATOM   8239  O   GLU    72    -113.250  25.704 -30.716  1.00 69.21           O  
ATOM   8240  CB  GLU    72    -112.128  25.476 -28.127  1.00 72.79           C  
ATOM   8241  CG  GLU    72    -111.884  24.613 -26.893  1.00 84.26           C  
ATOM   8242  CD  GLU    72    -112.101  25.361 -25.594  1.00 95.67           C  
ATOM   8243  OE1 GLU    72    -111.532  26.464 -25.436  1.00100.41           O  
ATOM   8244  OE2 GLU    72    -112.831  24.839 -24.724  1.00 98.92           O  
ATOM   8245  N   GLY    73    -111.215  25.616 -31.691  1.00 67.67           N  
ATOM   8246  CA  GLY    73    -111.646  26.110 -32.993  1.00 68.92           C  
ATOM   8247  C   GLY    73    -112.233  25.051 -33.907  1.00 68.85           C  
ATOM   8248  O   GLY    73    -112.516  23.929 -33.484  1.00 66.45           O  
ATOM   8249  N   LYS    74    -112.392  25.420 -35.175  1.00 73.69           N  
ATOM   8250  CA  LYS    74    -113.137  24.626 -36.153  1.00 76.53           C  
ATOM   8251  C   LYS    74    -112.253  23.676 -36.967  1.00 75.07           C  
ATOM   8252  O   LYS    74    -112.757  22.896 -37.783  1.00 74.22           O  
ATOM   8253  CB  LYS    74    -113.920  25.556 -37.090  1.00 81.61           C  
ATOM   8254  CG  LYS    74    -114.897  26.494 -36.380  1.00 88.45           C  
ATOM   8255  CD  LYS    74    -115.299  27.663 -37.273  1.00 94.43           C  
ATOM   8256  CE  LYS    74    -116.285  28.596 -36.579  1.00 94.31           C  
ATOM   8257  NZ  LYS    74    -117.639  27.985 -36.428  1.00 96.16           N  
ATOM   8258  N   ALA    75    -110.943  23.746 -36.739  1.00 73.41           N  
ATOM   8259  CA  ALA    75    -109.978  22.892 -37.434  1.00 69.88           C  
ATOM   8260  C   ALA    75    -109.856  21.516 -36.768  1.00 67.42           C  
ATOM   8261  O   ALA    75    -109.128  21.353 -35.782  1.00 65.58           O  
ATOM   8262  CB  ALA    75    -108.621  23.581 -37.510  1.00 70.25           C  
ATOM   8263  N   VAL    76    -110.579  20.535 -37.311  1.00 60.66           N  
ATOM   8264  CA  VAL    76    -110.595  19.175 -36.765  1.00 59.27           C  
ATOM   8265  C   VAL    76    -110.114  18.142 -37.797  1.00 59.79           C  
ATOM   8266  O   VAL    76    -110.641  18.064 -38.908  1.00 60.59           O  
ATOM   8267  CB  VAL    76    -111.999  18.791 -36.193  1.00 58.84           C  
ATOM   8268  CG1 VAL    76    -112.044  17.324 -35.750  1.00 59.68           C  
ATOM   8269  CG2 VAL    76    -112.380  19.697 -35.023  1.00 57.82           C  
ATOM   8270  N   ILE    77    -109.096  17.371 -37.417  1.00 58.69           N  
ATOM   8271  CA  ILE    77    -108.611  16.242 -38.207  1.00 59.27           C  
ATOM   8272  C   ILE    77    -108.860  14.942 -37.441  1.00 57.23           C  
ATOM   8273  O   ILE    77    -108.650  14.878 -36.228  1.00 54.63           O  
ATOM   8274  CB  ILE    77    -107.106  16.413 -38.573  1.00 60.42           C  
ATOM   8275  CG1 ILE    77    -106.971  17.218 -39.864  1.00 62.03           C  
ATOM   8276  CG2 ILE    77    -106.384  15.063 -38.733  1.00 63.50           C  
ATOM   8277  CD1 ILE    77    -105.544  17.554 -40.232  1.00 65.24           C  
ATOM   8278  N   GLU    78    -109.340  13.922 -38.145  1.00 57.78           N  
ATOM   8279  CA  GLU    78    -109.468  12.599 -37.555  1.00 60.04           C  
ATOM   8280  C   GLU    78    -108.614  11.602 -38.333  1.00 57.68           C  
ATOM   8281  O   GLU    78    -108.806  11.399 -39.533  1.00 59.36           O  
ATOM   8282  CB  GLU    78    -110.933  12.161 -37.490  1.00 61.44           C  
ATOM   8283  CG  GLU    78    -111.316  11.586 -36.139  1.00 71.59           C  
ATOM   8284  CD  GLU    78    -112.807  11.362 -35.982  1.00 82.86           C  
ATOM   8285  OE1 GLU    78    -113.399  11.973 -35.065  1.00 85.63           O  
ATOM   8286  OE2 GLU    78    -113.384  10.575 -36.764  1.00 85.45           O  
ATOM   8287  N   THR    79    -107.655  11.004 -37.634  1.00 55.81           N  
ATOM   8288  CA  THR    79    -106.732  10.030 -38.214  1.00 53.71           C  
ATOM   8289  C   THR    79    -106.540   8.885 -37.214  1.00 50.88           C  
ATOM   8290  O   THR    79    -107.223   8.843 -36.198  1.00 53.52           O  
ATOM   8291  CB  THR    79    -105.387  10.704 -38.633  1.00 56.65           C  
ATOM   8292  OG1 THR    79    -104.436   9.713 -39.047  1.00 55.80           O  
ATOM   8293  CG2 THR    79    -104.801  11.534 -37.490  1.00 53.91           C  
ATOM   8294  N   GLY    80    -105.636   7.952 -37.499  1.00 48.90           N  
ATOM   8295  CA  GLY    80    -105.436   6.798 -36.626  1.00 45.19           C  
ATOM   8296  C   GLY    80    -103.998   6.328 -36.531  1.00 43.56           C  
ATOM   8297  O   GLY    80    -103.134   6.782 -37.288  1.00 43.06           O  
ATOM   8298  N   ILE    81    -103.749   5.418 -35.588  1.00 41.38           N  
ATOM   8299  CA  ILE    81    -102.425   4.828 -35.381  1.00 38.65           C  
ATOM   8300  C   ILE    81    -102.105   3.891 -36.542  1.00 38.79           C  
ATOM   8301  O   ILE    81    -102.950   3.084 -36.931  1.00 42.90           O  
ATOM   8302  CB  ILE    81    -102.347   4.072 -34.017  1.00 37.88           C  
ATOM   8303  CG1 ILE    81    -102.470   5.056 -32.844  1.00 37.27           C  
ATOM   8304  CG2 ILE    81    -101.049   3.254 -33.893  1.00 33.72           C  
ATOM   8305  CD1 ILE    81    -102.728   4.400 -31.495  1.00 36.56           C  
ATOM   8306  N   ARG    82    -100.906   4.039 -37.106  1.00 36.17           N  
ATOM   8307  CA  ARG    82    -100.434   3.188 -38.197  0.50 35.92           C  
ATOM   8309  C   ARG    82     -99.723   1.959 -37.641  1.00 38.22           C  
ATOM   8310  O   ARG    82     -99.928   0.840 -38.121  1.00 36.05           O  
ATOM   8311  CB  ARG    82     -99.487   3.972 -39.112  0.50 34.83           C  
ATOM   8313  CG  ARG    82     -99.010   3.215 -40.350  0.50 39.11           C  
ATOM   8315  CD  ARG    82     -98.224   4.118 -41.294  0.50 35.84           C  
ATOM   8317  NE  ARG    82     -97.622   3.368 -42.395  0.50 33.08           N  
ATOM   8319  CZ  ARG    82     -96.374   2.903 -42.404  0.50 37.07           C  
ATOM   8321  NH1 ARG    82     -95.569   3.106 -41.368  0.50 32.81           N  
ATOM   8323  NH2 ARG    82     -95.926   2.231 -43.457  0.50 36.71           N  
ATOM   8325  N   THR    83     -98.886   2.189 -36.632  1.00 37.48           N  
ATOM   8326  CA  THR    83     -98.088   1.158 -35.979  1.00 39.27           C  
ATOM   8327  C   THR    83     -97.544   1.685 -34.654  1.00 39.23           C  
ATOM   8328  O   THR    83     -97.584   2.892 -34.390  1.00 39.06           O  
ATOM   8329  CB  THR    83     -96.901   0.695 -36.874  1.00 41.83           C  
ATOM   8330  OG1 THR    83     -96.245  -0.419 -36.262  1.00 49.98           O  
ATOM   8331  CG2 THR    83     -95.888   1.825 -37.118  1.00 40.10           C  
ATOM   8332  N   CYS    84     -97.042   0.782 -33.816  1.00 39.51           N  
ATOM   8333  CA  CYS    84     -96.324   1.200 -32.615  1.00 40.53           C  
ATOM   8334  C   CYS    84     -94.914   0.628 -32.602  1.00 39.63           C  
ATOM   8335  O   CYS    84     -94.671  -0.472 -33.091  1.00 41.58           O  
ATOM   8336  CB  CYS    84     -97.084   0.853 -31.328  1.00 40.84           C  
ATOM   8337  SG  CYS    84     -98.856   1.307 -31.327  1.00 47.99           S  
ATOM   8338  N   VAL    85     -93.994   1.422 -32.069  1.00 41.26           N  
ATOM   8339  CA  VAL    85     -92.575   1.088 -31.962  1.00 38.74           C  
ATOM   8340  C   VAL    85     -92.207   1.247 -30.470  1.00 39.32           C  
ATOM   8341  O   VAL    85     -93.071   1.667 -29.693  1.00 38.98           O  
ATOM   8342  CB  VAL    85     -91.720   2.011 -32.891  1.00 39.61           C  
ATOM   8343  CG1 VAL    85     -91.939   1.654 -34.361  1.00 36.84           C  
ATOM   8344  CG2 VAL    85     -92.010   3.488 -32.630  1.00 36.34           C  
ATOM   8345  N   PRO    86     -90.965   0.887 -30.050  1.00 39.93           N  
ATOM   8346  CA  PRO    86     -90.579   1.125 -28.642  1.00 40.46           C  
ATOM   8347  C   PRO    86     -90.798   2.546 -28.099  1.00 41.17           C  
ATOM   8348  O   PRO    86     -91.110   2.702 -26.920  1.00 41.73           O  
ATOM   8349  CB  PRO    86     -89.090   0.763 -28.623  1.00 38.19           C  
ATOM   8350  CG  PRO    86     -88.964  -0.271 -29.677  1.00 39.12           C  
ATOM   8351  CD  PRO    86     -89.882   0.187 -30.776  1.00 40.81           C  
ATOM   8352  N   ALA    87     -90.664   3.561 -28.953  1.00 41.92           N  
ATOM   8353  CA  ALA    87     -90.876   4.959 -28.552  1.00 41.74           C  
ATOM   8354  C   ALA    87     -92.349   5.317 -28.308  1.00 42.35           C  
ATOM   8355  O   ALA    87     -92.646   6.320 -27.659  1.00 44.31           O  
ATOM   8356  CB  ALA    87     -90.265   5.907 -29.580  1.00 39.31           C  
ATOM   8357  N   GLY    88     -93.261   4.500 -28.829  1.00 40.31           N  
ATOM   8358  CA  GLY    88     -94.694   4.729 -28.676  1.00 35.02           C  
ATOM   8359  C   GLY    88     -95.465   4.404 -29.941  1.00 38.26           C  
ATOM   8360  O   GLY    88     -94.940   3.763 -30.856  1.00 38.56           O  
ATOM   8361  N   CYS    89     -96.718   4.846 -29.992  1.00 37.23           N  
ATOM   8362  CA  CYS    89     -97.581   4.594 -31.143  1.00 37.64           C  
ATOM   8363  C   CYS    89     -97.558   5.742 -32.153  1.00 37.25           C  
ATOM   8364  O   CYS    89     -97.679   6.909 -31.783  1.00 38.90           O  
ATOM   8365  CB  CYS    89     -98.997   4.263 -30.677  1.00 36.32           C  
ATOM   8366  SG  CYS    89     -99.087   2.665 -29.817  1.00 44.05           S  
ATOM   8367  N   ILE    90     -97.386   5.397 -33.426  1.00 38.32           N  
ATOM   8368  CA  ILE    90     -97.156   6.382 -34.485  1.00 38.77           C  
ATOM   8369  C   ILE    90     -98.438   6.728 -35.234  1.00 38.84           C  
ATOM   8370  O   ILE    90     -99.085   5.851 -35.811  1.00 39.38           O  
ATOM   8371  CB  ILE    90     -96.072   5.896 -35.490  1.00 40.66           C  
ATOM   8372  CG1 ILE    90     -94.799   5.434 -34.759  1.00 40.11           C  
ATOM   8373  CG2 ILE    90     -95.768   6.968 -36.549  1.00 36.05           C  
ATOM   8374  CD1 ILE    90     -94.091   6.505 -33.922  1.00 47.31           C  
ATOM   8375  N   VAL    91     -98.788   8.015 -35.214  1.00 37.89           N  
ATOM   8376  CA  VAL    91     -99.967   8.541 -35.903  1.00 38.22           C  
ATOM   8377  C   VAL    91     -99.531   9.458 -37.056  1.00 38.71           C  
ATOM   8378  O   VAL    91     -99.006  10.547 -36.804  1.00 37.63           O  
ATOM   8379  CB  VAL    91    -100.880   9.336 -34.930  1.00 37.64           C  
ATOM   8380  CG1 VAL    91    -102.136   9.797 -35.628  1.00 34.89           C  
ATOM   8381  CG2 VAL    91    -101.244   8.505 -33.701  1.00 34.78           C  
ATOM   8382  N   PRO    92     -99.724   9.015 -38.321  1.00 41.21           N  
ATOM   8383  CA  PRO    92     -99.403   9.864 -39.476  1.00 42.25           C  
ATOM   8384  C   PRO    92    -100.380  11.022 -39.603  1.00 43.69           C  
ATOM   8385  O   PRO    92    -101.587  10.855 -39.385  1.00 46.34           O  
ATOM   8386  CB  PRO    92     -99.558   8.923 -40.679  1.00 40.31           C  
ATOM   8387  CG  PRO    92     -99.658   7.560 -40.117  1.00 41.73           C  
ATOM   8388  CD  PRO    92    -100.242   7.706 -38.751  1.00 40.34           C  
ATOM   8389  N   ILE    93     -99.847  12.189 -39.942  1.00 45.44           N  
ATOM   8390  CA  ILE    93    -100.636  13.410 -40.027  1.00 49.26           C  
ATOM   8391  C   ILE    93    -100.320  14.166 -41.312  1.00 48.71           C  
ATOM   8392  O   ILE    93     -99.160  14.278 -41.705  1.00 47.82           O  
ATOM   8393  CB  ILE    93    -100.407  14.322 -38.799  1.00 49.93           C  
ATOM   8394  CG1 ILE    93     -98.955  14.218 -38.324  1.00 54.73           C  
ATOM   8395  CG2 ILE    93    -101.351  13.927 -37.673  1.00 51.42           C  
ATOM   8396  CD1 ILE    93     -98.444  15.402 -37.553  1.00 48.62           C  
ATOM   8397  N   VAL    94    -101.369  14.643 -41.977  1.00 50.69           N  
ATOM   8398  CA  VAL    94    -101.246  15.502 -43.154  1.00 50.83           C  
ATOM   8399  C   VAL    94    -102.096  16.742 -42.903  1.00 50.88           C  
ATOM   8400  O   VAL    94    -103.281  16.628 -42.589  1.00 49.91           O  
ATOM   8401  CB  VAL    94    -101.702  14.779 -44.456  1.00 51.87           C  
ATOM   8402  CG1 VAL    94    -101.773  15.746 -45.634  1.00 51.56           C  
ATOM   8403  CG2 VAL    94    -100.766  13.624 -44.794  1.00 52.37           C  
ATOM   8404  N   PHE    95    -101.482  17.918 -43.019  1.00 51.11           N  
ATOM   8405  CA  PHE    95    -102.182  19.184 -42.817  1.00 53.11           C  
ATOM   8406  C   PHE    95    -102.367  19.943 -44.131  1.00 55.23           C  
ATOM   8407  O   PHE    95    -101.393  20.207 -44.839  1.00 57.10           O  
ATOM   8408  CB  PHE    95    -101.417  20.069 -41.830  1.00 51.34           C  
ATOM   8409  CG  PHE    95    -101.156  19.428 -40.493  1.00 51.30           C  
ATOM   8410  CD1 PHE    95     -99.856  19.297 -40.014  1.00 52.45           C  
ATOM   8411  CD2 PHE    95    -102.205  18.971 -39.704  1.00 51.81           C  
ATOM   8412  CE1 PHE    95     -99.611  18.719 -38.773  1.00 51.34           C  
ATOM   8413  CE2 PHE    95    -101.969  18.393 -38.462  1.00 49.46           C  
ATOM   8414  CZ  PHE    95    -100.673  18.267 -37.997  1.00 47.79           C  
ATOM   8415  N   ASP    96    -103.612  20.298 -44.449  1.00 58.17           N  
ATOM   8416  CA  ASP    96    -103.896  21.166 -45.601  1.00 62.07           C  
ATOM   8417  C   ASP    96    -103.629  22.639 -45.269  1.00 61.94           C  
ATOM   8418  O   ASP    96    -103.404  22.977 -44.103  1.00 61.30           O  
ATOM   8419  CB  ASP    96    -105.324  20.955 -46.143  1.00 62.34           C  
ATOM   8420  CG  ASP    96    -106.411  21.130 -45.079  1.00 68.13           C  
ATOM   8421  OD1 ASP    96    -106.406  22.134 -44.332  1.00 70.22           O  
ATOM   8422  OD2 ASP    96    -107.305  20.260 -45.012  1.00 74.75           O  
ATOM   8423  N   LYS    97    -103.677  23.499 -46.293  1.00 63.21           N  
ATOM   8424  CA  LYS    97    -103.397  24.944 -46.171  1.00 62.15           C  
ATOM   8425  C   LYS    97    -104.205  25.629 -45.062  1.00 58.72           C  
ATOM   8426  O   LYS    97    -103.676  26.483 -44.340  1.00 56.63           O  
ATOM   8427  CB  LYS    97    -103.646  25.671 -47.505  1.00 66.63           C  
ATOM   8428  CG  LYS    97    -103.078  24.989 -48.754  1.00 79.15           C  
ATOM   8429  CD  LYS    97    -101.597  25.278 -48.960  1.00 86.33           C  
ATOM   8430  CE  LYS    97    -101.089  24.618 -50.234  1.00 91.32           C  
ATOM   8431  NZ  LYS    97     -99.626  24.816 -50.433  1.00 92.22           N  
ATOM   8432  N   ASN    98    -105.474  25.231 -44.942  1.00 57.44           N  
ATOM   8433  CA  ASN    98    -106.388  25.775 -43.937  0.50 56.36           C  
ATOM   8435  C   ASN    98    -106.004  25.379 -42.513  1.00 56.07           C  
ATOM   8436  O   ASN    98    -106.101  26.193 -41.586  1.00 55.82           O  
ATOM   8437  CB  ASN    98    -107.826  25.333 -44.230  0.50 55.43           C  
ATOM   8439  CG  ASN    98    -108.272  25.685 -45.639  0.50 59.53           C  
ATOM   8441  OD1 ASN    98    -108.337  24.821 -46.514  0.50 56.99           O  
ATOM   8443  ND2 ASN    98    -108.574  26.959 -45.866  0.50 60.32           N  
ATOM   8445  N   TYR    99    -105.572  24.127 -42.346  1.00 53.30           N  
ATOM   8446  CA  TYR    99    -105.174  23.604 -41.038  1.00 49.37           C  
ATOM   8447  C   TYR    99    -103.825  24.171 -40.601  1.00 46.29           C  
ATOM   8448  O   TYR    99    -103.633  24.483 -39.422  1.00 46.34           O  
ATOM   8449  CB  TYR    99    -105.136  22.073 -41.041  1.00 49.20           C  
ATOM   8450  CG  TYR    99    -105.383  21.459 -39.678  1.00 47.60           C  
ATOM   8451  CD1 TYR    99    -104.369  21.396 -38.725  1.00 45.07           C  
ATOM   8452  CD2 TYR    99    -106.631  20.950 -39.339  1.00 47.01           C  
ATOM   8453  CE1 TYR    99    -104.583  20.839 -37.479  1.00 45.69           C  
ATOM   8454  CE2 TYR    99    -106.857  20.387 -38.087  1.00 49.26           C  
ATOM   8455  CZ  TYR    99    -105.826  20.337 -37.164  1.00 46.90           C  
ATOM   8456  OH  TYR    99    -106.029  19.789 -35.921  1.00 49.80           O  
ATOM   8457  N   VAL   100    -102.906  24.302 -41.556  1.00 43.96           N  
ATOM   8458  CA  VAL   100    -101.616  24.960 -41.332  1.00 43.98           C  
ATOM   8459  C   VAL   100    -101.799  26.388 -40.802  1.00 45.79           C  
ATOM   8460  O   VAL   100    -101.137  26.778 -39.843  1.00 48.00           O  
ATOM   8461  CB  VAL   100    -100.750  24.947 -42.617  1.00 44.35           C  
ATOM   8462  CG1 VAL   100     -99.566  25.891 -42.500  1.00 40.53           C  
ATOM   8463  CG2 VAL   100    -100.267  23.541 -42.908  1.00 42.15           C  
ATOM   8464  N   ALA   101    -102.725  27.136 -41.407  1.00 47.44           N  
ATOM   8465  CA  ALA   101    -103.055  28.503 -40.983  1.00 47.64           C  
ATOM   8466  C   ALA   101    -103.597  28.568 -39.554  1.00 46.99           C  
ATOM   8467  O   ALA   101    -103.307  29.517 -38.819  1.00 51.32           O  
ATOM   8468  CB  ALA   101    -104.048  29.135 -41.954  1.00 47.36           C  
ATOM   8469  N   ALA   102    -104.378  27.558 -39.174  1.00 45.72           N  
ATOM   8470  CA  ALA   102    -104.909  27.437 -37.818  1.00 43.91           C  
ATOM   8471  C   ALA   102    -103.809  27.097 -36.807  1.00 45.33           C  
ATOM   8472  O   ALA   102    -103.827  27.592 -35.680  1.00 46.79           O  
ATOM   8473  CB  ALA   102    -106.022  26.394 -37.774  1.00 42.26           C  
ATOM   8474  N   LEU   103    -102.859  26.258 -37.228  1.00 45.67           N  
ATOM   8475  CA  LEU   103    -101.682  25.882 -36.429  1.00 44.40           C  
ATOM   8476  C   LEU   103    -100.780  27.074 -36.107  1.00 44.93           C  
ATOM   8477  O   LEU   103    -100.211  27.149 -35.017  1.00 44.18           O  
ATOM   8478  CB  LEU   103    -100.866  24.811 -37.167  1.00 43.89           C  
ATOM   8479  CG  LEU   103    -100.812  23.312 -36.816  1.00 45.04           C  
ATOM   8480  CD1 LEU   103    -101.862  22.848 -35.824  1.00 40.47           C  
ATOM   8481  CD2 LEU   103    -100.864  22.475 -38.089  1.00 39.92           C  
ATOM   8482  N   ARG   104    -100.654  27.997 -37.060  1.00 45.96           N  
ATOM   8483  CA  ARG   104     -99.846  29.205 -36.884  1.00 45.42           C  
ATOM   8484  C   ARG   104    -100.493  30.188 -35.908  1.00 45.70           C  
ATOM   8485  O   ARG   104     -99.793  30.910 -35.198  1.00 47.56           O  
ATOM   8486  CB  ARG   104     -99.612  29.903 -38.226  1.00 48.20           C  
ATOM   8487  CG  ARG   104     -98.985  29.032 -39.300  1.00 48.50           C  
ATOM   8488  CD  ARG   104     -98.942  29.763 -40.628  1.00 48.41           C  
ATOM   8489  NE  ARG   104     -97.597  30.242 -40.930  1.00 45.45           N  
ATOM   8490  CZ  ARG   104     -96.884  29.856 -41.983  1.00 48.70           C  
ATOM   8491  NH1 ARG   104     -97.389  28.999 -42.860  1.00 61.07           N  
ATOM   8492  NH2 ARG   104     -95.668  30.342 -42.172  1.00 38.74           N  
ATOM   8493  N   ALA   105    -101.825  30.206 -35.880  1.00 46.39           N  
ATOM   8494  CA  ALA   105    -102.577  31.137 -35.038  1.00 48.45           C  
ATOM   8495  C   ALA   105    -102.917  30.547 -33.674  1.00 49.51           C  
ATOM   8496  O   ALA   105    -103.317  31.272 -32.760  1.00 52.08           O  
ATOM   8497  CB  ALA   105    -103.850  31.589 -35.753  1.00 48.13           C  
ATOM   8498  N   GLY   106    -102.755  29.232 -33.541  1.00 47.95           N  
ATOM   8499  CA  GLY   106    -103.172  28.515 -32.335  1.00 42.97           C  
ATOM   8500  C   GLY   106    -102.157  28.480 -31.207  1.00 42.20           C  
ATOM   8501  O   GLY   106    -100.995  28.862 -31.377  1.00 42.49           O  
ATOM   8502  N   LYS   107    -102.614  28.015 -30.048  1.00 43.00           N  
ATOM   8503  CA  LYS   107    -101.771  27.880 -28.865  1.00 47.17           C  
ATOM   8504  C   LYS   107    -101.509  26.412 -28.525  1.00 45.45           C  
ATOM   8505  O   LYS   107    -100.383  26.029 -28.207  1.00 44.60           O  
ATOM   8506  CB  LYS   107    -102.407  28.607 -27.674  1.00 50.63           C  
ATOM   8507  CG  LYS   107    -101.873  30.023 -27.475  1.00 65.02           C  
ATOM   8508  CD  LYS   107    -102.913  30.961 -26.882  1.00 77.55           C  
ATOM   8509  CE  LYS   107    -103.747  31.627 -27.972  1.00 86.67           C  
ATOM   8510  NZ  LYS   107    -104.663  32.663 -27.416  1.00 90.76           N  
ATOM   8511  N   HIS   108    -102.546  25.600 -28.561  1.00 45.01           N  
ATOM   8512  CA  HIS   108    -102.459  24.180 -28.282  1.00 44.56           C  
ATOM   8513  C   HIS   108    -103.063  23.346 -29.397  1.00 44.55           C  
ATOM   8514  O   HIS   108    -104.122  23.632 -29.880  1.00 43.56           O  
ATOM   8515  CB  HIS   108    -103.221  23.854 -27.015  1.00 47.32           C  
ATOM   8516  CG  HIS   108    -102.505  24.212 -25.762  1.00 54.73           C  
ATOM   8517  ND1 HIS   108    -102.780  23.614 -24.564  1.00 64.61           N  
ATOM   8518  CD2 HIS   108    -101.536  25.110 -25.515  1.00 62.28           C  
ATOM   8519  CE1 HIS   108    -102.005  24.123 -23.633  1.00 65.87           C  
ATOM   8520  NE2 HIS   108    -101.244  25.038 -24.183  1.00 62.10           N  
ATOM   8521  N   LEU   109    -102.395  22.283 -29.779  1.00 41.56           N  
ATOM   8522  CA  LEU   109    -102.997  21.270 -30.627  1.00 41.76           C  
ATOM   8523  C   LEU   109    -103.484  20.151 -29.717  1.00 42.73           C  
ATOM   8524  O   LEU   109    -102.692  19.347 -29.231  1.00 43.29           O  
ATOM   8525  CB  LEU   109    -102.010  20.747 -31.677  1.00 38.66           C  
ATOM   8526  CG  LEU   109    -102.527  19.658 -32.627  1.00 38.21           C  
ATOM   8527  CD1 LEU   109    -103.705  20.134 -33.472  1.00 38.18           C  
ATOM   8528  CD2 LEU   109    -101.416  19.180 -33.517  1.00 37.24           C  
ATOM   8529  N   LYS   110    -104.791  20.125 -29.480  1.00 43.89           N  
ATOM   8530  CA  LYS   110    -105.404  19.176 -28.560  1.00 43.28           C  
ATOM   8531  C   LYS   110    -105.587  17.811 -29.212  1.00 42.81           C  
ATOM   8532  O   LYS   110    -105.958  17.711 -30.386  1.00 41.27           O  
ATOM   8533  CB  LYS   110    -106.747  19.713 -28.057  1.00 46.86           C  
ATOM   8534  CG  LYS   110    -106.637  20.949 -27.172  1.00 53.48           C  
ATOM   8535  CD  LYS   110    -107.995  21.343 -26.614  1.00 68.99           C  
ATOM   8536  CE  LYS   110    -107.894  22.573 -25.725  1.00 83.43           C  
ATOM   8537  NZ  LYS   110    -109.224  22.997 -25.197  1.00 87.33           N  
ATOM   8538  N   LEU   111    -105.312  16.761 -28.444  1.00 43.69           N  
ATOM   8539  CA  LEU   111    -105.471  15.391 -28.923  1.00 43.91           C  
ATOM   8540  C   LEU   111    -106.586  14.683 -28.168  1.00 42.18           C  
ATOM   8541  O   LEU   111    -106.776  14.908 -26.971  1.00 42.42           O  
ATOM   8542  CB  LEU   111    -104.172  14.585 -28.777  1.00 44.52           C  
ATOM   8543  CG  LEU   111    -102.890  14.770 -29.601  1.00 45.49           C  
ATOM   8544  CD1 LEU   111    -103.057  15.711 -30.792  1.00 43.61           C  
ATOM   8545  CD2 LEU   111    -101.758  15.239 -28.714  1.00 46.82           C  
ATOM   8546  N   ALA   112    -107.317  13.826 -28.874  1.00 41.70           N  
ATOM   8547  CA  ALA   112    -108.374  13.027 -28.265  1.00 42.11           C  
ATOM   8548  C   ALA   112    -108.318  11.600 -28.786  1.00 40.83           C  
ATOM   8549  O   ALA   112    -108.326  11.375 -29.995  1.00 41.53           O  
ATOM   8550  CB  ALA   112    -109.737  13.640 -28.541  1.00 43.85           C  
ATOM   8551  N   MET   113    -108.261  10.641 -27.867  1.00 42.50           N  
ATOM   8552  CA  MET   113    -108.178   9.224 -28.225  1.00 41.77           C  
ATOM   8553  C   MET   113    -108.865   8.337 -27.185  1.00 43.96           C  
ATOM   8554  O   MET   113    -109.351   8.830 -26.165  1.00 43.85           O  
ATOM   8555  CB  MET   113    -106.716   8.800 -28.455  1.00 39.60           C  
ATOM   8556  CG  MET   113    -105.768   9.074 -27.297  1.00 39.28           C  
ATOM   8557  SD  MET   113    -104.057   9.187 -27.855  1.00 38.65           S  
ATOM   8558  CE  MET   113    -103.916  10.929 -28.210  1.00 41.68           C  
ATOM   8559  N   THR   114    -108.912   7.036 -27.464  1.00 46.22           N  
ATOM   8560  CA  THR   114    -109.570   6.062 -26.595  1.00 45.64           C  
ATOM   8561  C   THR   114    -108.539   5.101 -26.004  1.00 45.67           C  
ATOM   8562  O   THR   114    -107.699   4.574 -26.725  1.00 45.03           O  
ATOM   8563  CB  THR   114    -110.642   5.261 -27.373  1.00 45.96           C  
ATOM   8564  OG1 THR   114    -111.473   6.162 -28.109  1.00 48.22           O  
ATOM   8565  CG2 THR   114    -111.514   4.449 -26.434  1.00 42.63           C  
ATOM   8566  N   ILE   115    -108.603   4.896 -24.688  1.00 45.73           N  
ATOM   8567  CA  ILE   115    -107.736   3.945 -23.995  1.00 46.76           C  
ATOM   8568  C   ILE   115    -108.279   2.526 -24.181  1.00 48.35           C  
ATOM   8569  O   ILE   115    -109.484   2.295 -24.043  1.00 46.33           O  
ATOM   8570  CB  ILE   115    -107.608   4.296 -22.484  1.00 48.02           C  
ATOM   8571  CG1 ILE   115    -107.145   5.752 -22.308  1.00 45.46           C  
ATOM   8572  CG2 ILE   115    -106.644   3.342 -21.767  1.00 46.95           C  
ATOM   8573  CD1 ILE   115    -107.260   6.284 -20.886  1.00 46.24           C  
ATOM   8574  N   ALA   116    -107.391   1.590 -24.528  1.00 50.35           N  
ATOM   8575  CA  ALA   116    -107.740   0.171 -24.607  1.00 52.06           C  
ATOM   8576  C   ALA   116    -107.751  -0.436 -23.205  1.00 55.15           C  
ATOM   8577  O   ALA   116    -106.767  -1.031 -22.750  1.00 59.61           O  
ATOM   8578  CB  ALA   116    -106.782  -0.572 -25.521  1.00 44.31           C  
ATOM   8579  N   ALA   117    -108.878  -0.253 -22.527  1.00 58.19           N  
ATOM   8580  CA  ALA   117    -109.069  -0.675 -21.145  1.00 61.47           C  
ATOM   8581  C   ALA   117    -110.547  -1.048 -20.998  1.00 66.06           C  
ATOM   8582  O   ALA   117    -111.353  -0.647 -21.847  1.00 65.12           O  
ATOM   8583  CB  ALA   117    -108.688   0.464 -20.192  1.00 59.16           C  
ATOM   8584  N   PRO   118    -110.907  -1.847 -19.961  1.00 70.36           N  
ATOM   8585  CA  PRO   118    -112.326  -2.104 -19.686  1.00 69.83           C  
ATOM   8586  C   PRO   118    -113.139  -0.815 -19.520  1.00 67.26           C  
ATOM   8587  O   PRO   118    -112.801   0.036 -18.690  1.00 65.41           O  
ATOM   8588  CB  PRO   118    -112.289  -2.889 -18.371  1.00 72.29           C  
ATOM   8589  CG  PRO   118    -110.970  -3.562 -18.380  1.00 73.53           C  
ATOM   8590  CD  PRO   118    -110.035  -2.587 -19.025  1.00 71.48           C  
ATOM   8591  N   GLY   119    -114.183  -0.678 -20.336  1.00 64.56           N  
ATOM   8592  CA  GLY   119    -115.020   0.521 -20.353  1.00 65.34           C  
ATOM   8593  C   GLY   119    -114.679   1.468 -21.491  1.00 66.33           C  
ATOM   8594  O   GLY   119    -115.500   2.313 -21.870  1.00 65.92           O  
ATOM   8595  N   GLU   120    -113.468   1.304 -22.031  1.00 65.10           N  
ATOM   8596  CA  GLU   120    -112.886   2.149 -23.091  1.00 60.07           C  
ATOM   8597  C   GLU   120    -112.930   3.659 -22.797  1.00 56.48           C  
ATOM   8598  O   GLU   120    -113.626   4.403 -23.499  1.00 54.40           O  
ATOM   8599  CB  GLU   120    -113.501   1.823 -24.461  1.00 57.83           C  
ATOM   8600  CG  GLU   120    -113.168   0.420 -24.972  1.00 61.58           C  
ATOM   8601  CD  GLU   120    -113.903   0.049 -26.256  1.00 66.14           C  
ATOM   8602  OE1 GLU   120    -114.475   0.945 -26.917  1.00 66.14           O  
ATOM   8603  OE2 GLU   120    -113.890  -1.148 -26.617  1.00 72.51           O  
ATOM   8604  N   PRO   121    -112.171   4.114 -21.774  1.00 52.88           N  
ATOM   8605  CA  PRO   121    -112.229   5.517 -21.353  1.00 53.24           C  
ATOM   8606  C   PRO   121    -111.534   6.454 -22.351  1.00 56.38           C  
ATOM   8607  O   PRO   121    -110.611   6.030 -23.048  1.00 53.06           O  
ATOM   8608  CB  PRO   121    -111.475   5.522 -20.009  1.00 52.61           C  
ATOM   8609  CG  PRO   121    -111.177   4.091 -19.683  1.00 52.96           C  
ATOM   8610  CD  PRO   121    -111.185   3.358 -20.979  1.00 52.36           C  
ATOM   8611  N   PRO   122    -111.985   7.719 -22.435  1.00 59.94           N  
ATOM   8612  CA  PRO   122    -111.286   8.657 -23.309  1.00 58.33           C  
ATOM   8613  C   PRO   122    -110.017   9.220 -22.674  1.00 56.98           C  
ATOM   8614  O   PRO   122    -109.922   9.322 -21.444  1.00 57.07           O  
ATOM   8615  CB  PRO   122    -112.315   9.769 -23.519  1.00 60.21           C  
ATOM   8616  CG  PRO   122    -113.144   9.755 -22.281  1.00 61.14           C  
ATOM   8617  CD  PRO   122    -113.148   8.339 -21.768  1.00 60.85           C  
ATOM   8618  N   LEU   123    -109.047   9.561 -23.519  1.00 54.52           N  
ATOM   8619  CA  LEU   123    -107.865  10.303 -23.100  1.00 53.27           C  
ATOM   8620  C   LEU   123    -107.857  11.620 -23.871  1.00 54.53           C  
ATOM   8621  O   LEU   123    -107.614  11.639 -25.083  1.00 51.60           O  
ATOM   8622  CB  LEU   123    -106.586   9.495 -23.354  1.00 51.52           C  
ATOM   8623  CG  LEU   123    -105.254  10.038 -22.815  1.00 53.22           C  
ATOM   8624  CD1 LEU   123    -105.218  10.070 -21.284  1.00 52.01           C  
ATOM   8625  CD2 LEU   123    -104.097   9.215 -23.355  1.00 50.63           C  
ATOM   8626  N   ASN   124    -108.144  12.713 -23.163  1.00 56.50           N  
ATOM   8627  CA  ASN   124    -108.382  14.015 -23.792  1.00 56.92           C  
ATOM   8628  C   ASN   124    -107.468  15.139 -23.302  1.00 56.47           C  
ATOM   8629  O   ASN   124    -107.540  16.263 -23.805  1.00 57.02           O  
ATOM   8630  CB  ASN   124    -109.848  14.431 -23.610  1.00 59.19           C  
ATOM   8631  CG  ASN   124    -110.825  13.484 -24.293  1.00 62.91           C  
ATOM   8632  OD1 ASN   124    -110.506  12.856 -25.306  1.00 63.84           O  
ATOM   8633  ND2 ASN   124    -112.032  13.388 -23.741  1.00 62.51           N  
ATOM   8634  N   ASP   125    -106.609  14.837 -22.332  1.00 55.89           N  
ATOM   8635  CA  ASP   125    -105.779  15.864 -21.692  1.00 57.91           C  
ATOM   8636  C   ASP   125    -104.396  16.068 -22.331  1.00 55.21           C  
ATOM   8637  O   ASP   125    -103.591  16.868 -21.845  1.00 54.81           O  
ATOM   8638  CB  ASP   125    -105.666  15.616 -20.173  1.00 62.84           C  
ATOM   8639  CG  ASP   125    -105.107  14.231 -19.822  1.00 72.01           C  
ATOM   8640  OD1 ASP   125    -104.941  13.962 -18.613  1.00 81.27           O  
ATOM   8641  OD2 ASP   125    -104.833  13.413 -20.727  1.00 74.19           O  
ATOM   8642  N   LEU   126    -104.131  15.349 -23.420  1.00 51.02           N  
ATOM   8643  CA  LEU   126    -102.862  15.481 -24.138  1.00 46.92           C  
ATOM   8644  C   LEU   126    -102.934  16.535 -25.235  1.00 44.90           C  
ATOM   8645  O   LEU   126    -103.976  16.714 -25.877  1.00 45.37           O  
ATOM   8646  CB  LEU   126    -102.422  14.140 -24.730  1.00 47.54           C  
ATOM   8647  CG  LEU   126    -101.420  13.221 -24.023  1.00 47.39           C  
ATOM   8648  CD1 LEU   126    -101.581  13.167 -22.504  1.00 46.51           C  
ATOM   8649  CD2 LEU   126    -101.553  11.842 -24.625  1.00 44.20           C  
ATOM   8650  N   PHE   127    -101.809  17.212 -25.446  1.00 41.83           N  
ATOM   8651  CA  PHE   127    -101.706  18.298 -26.410  1.00 41.39           C  
ATOM   8652  C   PHE   127    -100.275  18.487 -26.886  1.00 40.58           C  
ATOM   8653  O   PHE   127     -99.340  17.969 -26.280  1.00 41.29           O  
ATOM   8654  CB  PHE   127    -102.233  19.626 -25.825  1.00 44.43           C  
ATOM   8655  CG  PHE   127    -101.652  19.980 -24.479  1.00 47.75           C  
ATOM   8656  CD1 PHE   127    -100.417  20.619 -24.373  1.00 47.14           C  
ATOM   8657  CD2 PHE   127    -102.350  19.680 -23.312  1.00 49.24           C  
ATOM   8658  CE1 PHE   127     -99.883  20.940 -23.128  1.00 49.24           C  
ATOM   8659  CE2 PHE   127    -101.824  19.998 -22.065  1.00 50.32           C  
ATOM   8660  CZ  PHE   127    -100.590  20.629 -21.973  1.00 51.44           C  
ATOM   8661  N   VAL   128    -100.116  19.241 -27.969  1.00 39.64           N  
ATOM   8662  CA  VAL   128     -98.810  19.727 -28.402  1.00 35.39           C  
ATOM   8663  C   VAL   128     -98.871  21.252 -28.339  1.00 37.91           C  
ATOM   8664  O   VAL   128     -99.822  21.863 -28.828  1.00 37.48           O  
ATOM   8665  CB  VAL   128     -98.448  19.246 -29.832  1.00 34.96           C  
ATOM   8666  CG1 VAL   128     -97.069  19.763 -30.258  1.00 30.06           C  
ATOM   8667  CG2 VAL   128     -98.479  17.727 -29.917  1.00 32.12           C  
ATOM   8668  N   GLN   129     -97.872  21.862 -27.707  1.00 38.26           N  
ATOM   8669  CA  GLN   129     -97.810  23.317 -27.601  1.00 36.17           C  
ATOM   8670  C   GLN   129     -97.309  23.935 -28.904  1.00 36.80           C  
ATOM   8671  O   GLN   129     -96.326  23.473 -29.489  1.00 36.17           O  
ATOM   8672  CB  GLN   129     -96.923  23.732 -26.432  1.00 35.06           C  
ATOM   8673  CG  GLN   129     -97.478  23.348 -25.062  1.00 36.77           C  
ATOM   8674  CD  GLN   129     -96.547  23.751 -23.932  1.00 39.52           C  
ATOM   8675  OE1 GLN   129     -96.678  24.837 -23.363  1.00 44.44           O  
ATOM   8676  NE2 GLN   129     -95.588  22.888 -23.615  1.00 37.86           N  
ATOM   8677  N   LEU   130     -97.986  24.989 -29.348  1.00 39.66           N  
ATOM   8678  CA  LEU   130     -97.746  25.542 -30.682  1.00 37.39           C  
ATOM   8679  C   LEU   130     -96.927  26.823 -30.700  1.00 36.78           C  
ATOM   8680  O   LEU   130     -96.784  27.445 -31.753  1.00 41.24           O  
ATOM   8681  CB  LEU   130     -99.072  25.741 -31.425  1.00 35.81           C  
ATOM   8682  CG  LEU   130     -99.896  24.487 -31.722  1.00 34.91           C  
ATOM   8683  CD1 LEU   130    -101.245  24.877 -32.294  1.00 34.39           C  
ATOM   8684  CD2 LEU   130     -99.152  23.531 -32.666  1.00 30.66           C  
ATOM   8685  N   ASN   131     -96.387  27.213 -29.548  1.00 39.07           N  
ATOM   8686  CA  ASN   131     -95.550  28.406 -29.468  1.00 38.32           C  
ATOM   8687  C   ASN   131     -94.264  28.239 -30.276  1.00 39.51           C  
ATOM   8688  O   ASN   131     -93.415  27.407 -29.953  1.00 40.05           O  
ATOM   8689  CB  ASN   131     -95.232  28.778 -28.015  1.00 41.74           C  
ATOM   8690  CG  ASN   131     -94.448  30.077 -27.907  1.00 44.69           C  
ATOM   8691  OD1 ASN   131     -93.229  30.068 -27.732  1.00 50.64           O  
ATOM   8692  ND2 ASN   131     -95.144  31.199 -28.033  1.00 50.20           N  
ATOM   8693  N   GLY   132     -94.150  29.023 -31.343  1.00 37.36           N  
ATOM   8694  CA  GLY   132     -93.003  28.953 -32.239  1.00 31.67           C  
ATOM   8695  C   GLY   132     -93.244  28.183 -33.527  1.00 34.02           C  
ATOM   8696  O   GLY   132     -92.359  28.129 -34.377  1.00 38.35           O  
ATOM   8697  N   PHE   133     -94.431  27.590 -33.670  1.00 36.76           N  
ATOM   8698  CA  PHE   133     -94.796  26.820 -34.870  1.00 38.96           C  
ATOM   8699  C   PHE   133     -94.644  27.644 -36.152  1.00 41.71           C  
ATOM   8700  O   PHE   133     -94.022  27.185 -37.115  1.00 42.81           O  
ATOM   8701  CB  PHE   133     -96.235  26.273 -34.773  1.00 39.20           C  
ATOM   8702  CG  PHE   133     -96.596  25.297 -35.871  1.00 41.70           C  
ATOM   8703  CD1 PHE   133     -96.525  23.924 -35.649  1.00 43.33           C  
ATOM   8704  CD2 PHE   133     -97.017  25.749 -37.127  1.00 42.03           C  
ATOM   8705  CE1 PHE   133     -96.848  23.014 -36.665  1.00 43.98           C  
ATOM   8706  CE2 PHE   133     -97.337  24.854 -38.146  1.00 39.80           C  
ATOM   8707  CZ  PHE   133     -97.254  23.484 -37.916  1.00 42.34           C  
ATOM   8708  N   SER   134     -95.220  28.848 -36.149  1.00 42.18           N  
ATOM   8709  CA  SER   134     -95.229  29.740 -37.313  1.00 42.38           C  
ATOM   8710  C   SER   134     -93.817  30.116 -37.757  1.00 40.58           C  
ATOM   8711  O   SER   134     -93.495  30.008 -38.943  1.00 42.40           O  
ATOM   8712  CB  SER   134     -96.059  30.995 -37.014  1.00 46.82           C  
ATOM   8713  OG  SER   134     -96.150  31.853 -38.136  1.00 54.10           O  
ATOM   8714  N   ASN   135     -92.980  30.528 -36.802  1.00 38.02           N  
ATOM   8715  CA  ASN   135     -91.591  30.900 -37.084  1.00 39.07           C  
ATOM   8716  C   ASN   135     -90.716  29.738 -37.534  1.00 40.40           C  
ATOM   8717  O   ASN   135     -89.853  29.910 -38.399  1.00 45.00           O  
ATOM   8718  CB  ASN   135     -90.956  31.588 -35.877  1.00 42.86           C  
ATOM   8719  CG  ASN   135     -91.424  33.016 -35.704  1.00 45.18           C  
ATOM   8720  OD1 ASN   135     -91.832  33.673 -36.664  1.00 49.01           O  
ATOM   8721  ND2 ASN   135     -91.363  33.509 -34.472  1.00 45.57           N  
ATOM   8722  N   ALA   136     -90.941  28.563 -36.950  1.00 40.02           N  
ATOM   8723  CA  ALA   136     -90.217  27.350 -37.346  1.00 38.53           C  
ATOM   8724  C   ALA   136     -90.631  26.886 -38.742  1.00 36.86           C  
ATOM   8725  O   ALA   136     -89.804  26.381 -39.498  1.00 38.11           O  
ATOM   8726  CB  ALA   136     -90.411  26.230 -36.319  1.00 36.47           C  
ATOM   8727  N   LEU   137     -91.905  27.070 -39.082  1.00 37.02           N  
ATOM   8728  CA  LEU   137     -92.394  26.736 -40.420  1.00 39.48           C  
ATOM   8729  C   LEU   137     -91.861  27.698 -41.484  1.00 41.97           C  
ATOM   8730  O   LEU   137     -91.545  27.270 -42.596  1.00 45.89           O  
ATOM   8731  CB  LEU   137     -93.922  26.674 -40.453  1.00 38.11           C  
ATOM   8732  CG  LEU   137     -94.596  26.152 -41.724  1.00 38.77           C  
ATOM   8733  CD1 LEU   137     -94.068  24.788 -42.136  1.00 37.35           C  
ATOM   8734  CD2 LEU   137     -96.089  26.102 -41.522  1.00 38.36           C  
ATOM   8735  N   ASN   138     -91.750  28.982 -41.131  1.00 42.09           N  
ATOM   8736  CA  ASN   138     -91.138  29.994 -42.000  1.00 42.09           C  
ATOM   8737  C   ASN   138     -89.689  29.657 -42.328  1.00 43.62           C  
ATOM   8738  O   ASN   138     -89.239  29.867 -43.454  1.00 48.34           O  
ATOM   8739  CB  ASN   138     -91.190  31.386 -41.355  1.00 42.26           C  
ATOM   8740  CG  ASN   138     -92.591  31.979 -41.320  1.00 42.14           C  
ATOM   8741  OD1 ASN   138     -93.517  31.477 -41.950  1.00 42.75           O  
ATOM   8742  ND2 ASN   138     -92.745  33.061 -40.571  1.00 41.76           N  
ATOM   8743  N   ARG   139     -88.969  29.140 -41.334  1.00 45.67           N  
ATOM   8744  CA  ARG   139     -87.590  28.693 -41.508  1.00 43.72           C  
ATOM   8745  C   ARG   139     -87.516  27.463 -42.424  1.00 43.33           C  
ATOM   8746  O   ARG   139     -86.610  27.356 -43.247  1.00 45.37           O  
ATOM   8747  CB  ARG   139     -86.942  28.429 -40.142  1.00 42.86           C  
ATOM   8748  CG  ARG   139     -85.506  27.912 -40.174  1.00 43.81           C  
ATOM   8749  CD  ARG   139     -84.563  28.856 -40.900  1.00 45.81           C  
ATOM   8750  NE  ARG   139     -83.174  28.411 -40.801  1.00 53.72           N  
ATOM   8751  CZ  ARG   139     -82.195  28.800 -41.613  1.00 55.64           C  
ATOM   8752  NH1 ARG   139     -82.438  29.636 -42.614  1.00 57.67           N  
ATOM   8753  NH2 ARG   139     -80.965  28.341 -41.429  1.00 55.83           N  
ATOM   8754  N   LEU   140     -88.484  26.557 -42.290  1.00 44.94           N  
ATOM   8755  CA  LEU   140     -88.597  25.388 -43.168  1.00 46.02           C  
ATOM   8756  C   LEU   140     -88.870  25.768 -44.627  1.00 49.25           C  
ATOM   8757  O   LEU   140     -88.360  25.119 -45.547  1.00 50.94           O  
ATOM   8758  CB  LEU   140     -89.676  24.427 -42.657  1.00 44.43           C  
ATOM   8759  CG  LEU   140     -89.263  23.036 -42.161  1.00 42.54           C  
ATOM   8760  CD1 LEU   140     -88.145  23.071 -41.135  1.00 34.28           C  
ATOM   8761  CD2 LEU   140     -90.474  22.281 -41.622  1.00 34.42           C  
ATOM   8762  N   ILE   141     -89.674  26.813 -44.825  1.00 50.63           N  
ATOM   8763  CA  ILE   141     -89.933  27.380 -46.152  1.00 51.16           C  
ATOM   8764  C   ILE   141     -88.652  28.003 -46.720  1.00 52.42           C  
ATOM   8765  O   ILE   141     -88.311  27.776 -47.885  1.00 55.57           O  
ATOM   8766  CB  ILE   141     -91.092  28.418 -46.116  1.00 51.67           C  
ATOM   8767  CG1 ILE   141     -92.414  27.733 -45.743  1.00 48.54           C  
ATOM   8768  CG2 ILE   141     -91.245  29.126 -47.466  1.00 53.10           C  
ATOM   8769  CD1 ILE   141     -93.491  28.667 -45.217  1.00 46.79           C  
ATOM   8770  N   ALA   142     -87.940  28.750 -45.876  1.00 52.51           N  
ATOM   8771  CA  ALA   142     -86.662  29.376 -46.232  1.00 53.46           C  
ATOM   8772  C   ALA   142     -85.546  28.372 -46.549  1.00 55.72           C  
ATOM   8773  O   ALA   142     -84.695  28.639 -47.401  1.00 60.79           O  
ATOM   8774  CB  ALA   142     -86.216  30.336 -45.124  1.00 50.56           C  
ATOM   8775  N   LEU   143     -85.555  27.228 -45.864  1.00 57.21           N  
ATOM   8776  CA  LEU   143     -84.567  26.172 -46.092  1.00 58.17           C  
ATOM   8777  C   LEU   143     -84.829  25.377 -47.377  1.00 61.92           C  
ATOM   8778  O   LEU   143     -83.911  24.755 -47.923  1.00 63.84           O  
ATOM   8779  CB  LEU   143     -84.485  25.230 -44.885  1.00 55.26           C  
ATOM   8780  CG  LEU   143     -83.691  25.691 -43.658  1.00 52.15           C  
ATOM   8781  CD1 LEU   143     -84.099  24.885 -42.426  1.00 47.67           C  
ATOM   8782  CD2 LEU   143     -82.186  25.601 -43.889  1.00 51.87           C  
ATOM   8783  N   GLN   144     -86.078  25.390 -47.846  1.00 65.75           N  
ATOM   8784  CA  GLN   144     -86.444  24.772 -49.123  1.00 71.05           C  
ATOM   8785  C   GLN   144     -85.878  25.549 -50.307  1.00 73.07           C  
ATOM   8786  O   GLN   144     -85.436  24.954 -51.296  1.00 73.75           O  
ATOM   8787  CB  GLN   144     -87.963  24.664 -49.268  1.00 71.94           C  
ATOM   8788  CG  GLN   144     -88.529  23.295 -48.930  1.00 77.77           C  
ATOM   8789  CD  GLN   144     -89.821  22.994 -49.678  1.00 79.09           C  
ATOM   8790  OE1 GLN   144     -90.596  23.898 -50.003  1.00 73.88           O  
ATOM   8791  NE2 GLN   144     -90.057  21.714 -49.952  1.00 79.06           N  
ATOM   8792  N   LYS   145     -85.898  26.877 -50.191  1.00 74.17           N  
ATOM   8793  CA  LYS   145     -85.368  27.774 -51.220  1.00 75.54           C  
ATOM   8794  C   LYS   145     -83.838  27.721 -51.302  1.00 76.51           C  
ATOM   8795  O   LYS   145     -83.263  27.926 -52.374  1.00 79.49           O  
ATOM   8796  CB  LYS   145     -85.854  29.206 -50.982  1.00 76.15           C  
ATOM   8797  CG  LYS   145     -87.359  29.376 -51.148  1.00 79.02           C  
ATOM   8798  CD  LYS   145     -87.827  30.741 -50.679  1.00 82.69           C  
ATOM   8799  CE  LYS   145     -89.345  30.829 -50.697  1.00 86.16           C  
ATOM   8800  NZ  LYS   145     -89.840  32.104 -50.106  1.00 88.65           N  
END
